//----------------------------------------------------------------------------
//  System.Security.Cryptography.Algorithms.dll: System.Security.Cryptography.Algorithms, Version=4.3.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.Algorithms
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.Algorithms;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Security.Cryptography.Primitives,
  DDNC.System.Security.Cryptography.Encoding;

type

{ enums }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.ECCurve+ECCurveType')]
  DNECCurve_ECCurveType = type Integer;
  DNECCurve_ECCurveTypeHelper = record helper for DNECCurve_ECCurveType
  public const
    Implicit = 0;
    PrimeShortWeierstrass = 1;
    PrimeTwistedEdwards = 2;
    PrimeMontgomery = 3;
    Characteristic2 = 4;
    Named = 5;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.RSAEncryptionPaddingMode')]
  DNRSAEncryptionPaddingMode = type Integer;
  DNRSAEncryptionPaddingModeHelper = record helper for DNRSAEncryptionPaddingMode
  public const
    Pkcs1 = 0;
    Oaep = 1;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.RSASignaturePaddingMode')]
  DNRSASignaturePaddingMode = type Integer;
  DNRSASignaturePaddingModeHelper = record helper for DNRSASignaturePaddingMode
  public const
    Pkcs1 = 0;
    Pss = 1;
  end;




type


{ declares }

  DNAesCcm = interface; // type: System.Security.Cryptography.AesCcm, namespace: System.Security.Cryptography
  DNAesGcm = interface; // type: System.Security.Cryptography.AesGcm, namespace: System.Security.Cryptography
  DNDSA = interface; // type: System.Security.Cryptography.DSA, namespace: System.Security.Cryptography
  DNECDiffieHellman = interface; // type: System.Security.Cryptography.ECDiffieHellman, namespace: System.Security.Cryptography
  DNECDsa = interface; // type: System.Security.Cryptography.ECDsa, namespace: System.Security.Cryptography
  DNRSA = interface; // type: System.Security.Cryptography.RSA, namespace: System.Security.Cryptography
  DNAsymmetricKeyExchangeDeformatter = interface; // type: System.Security.Cryptography.AsymmetricKeyExchangeDeformatter, namespace: System.Security.Cryptography
  DNRSAOAEPKeyExchangeDeformatter = interface; // type: System.Security.Cryptography.RSAOAEPKeyExchangeDeformatter, namespace: System.Security.Cryptography
  DNRSAPKCS1KeyExchangeDeformatter = interface; // type: System.Security.Cryptography.RSAPKCS1KeyExchangeDeformatter, namespace: System.Security.Cryptography
  DNAsymmetricKeyExchangeFormatter = interface; // type: System.Security.Cryptography.AsymmetricKeyExchangeFormatter, namespace: System.Security.Cryptography
  DNRSAOAEPKeyExchangeFormatter = interface; // type: System.Security.Cryptography.RSAOAEPKeyExchangeFormatter, namespace: System.Security.Cryptography
  DNRSAPKCS1KeyExchangeFormatter = interface; // type: System.Security.Cryptography.RSAPKCS1KeyExchangeFormatter, namespace: System.Security.Cryptography
  DNAsymmetricSignatureDeformatter = interface; // type: System.Security.Cryptography.AsymmetricSignatureDeformatter, namespace: System.Security.Cryptography
  DNDSASignatureDeformatter = interface; // type: System.Security.Cryptography.DSASignatureDeformatter, namespace: System.Security.Cryptography
  DNRSAPKCS1SignatureDeformatter = interface; // type: System.Security.Cryptography.RSAPKCS1SignatureDeformatter, namespace: System.Security.Cryptography
  DNAsymmetricSignatureFormatter = interface; // type: System.Security.Cryptography.AsymmetricSignatureFormatter, namespace: System.Security.Cryptography
  DNDSASignatureFormatter = interface; // type: System.Security.Cryptography.DSASignatureFormatter, namespace: System.Security.Cryptography
  DNRSAPKCS1SignatureFormatter = interface; // type: System.Security.Cryptography.RSAPKCS1SignatureFormatter, namespace: System.Security.Cryptography
  DNCryptoConfig = interface; // type: System.Security.Cryptography.CryptoConfig, namespace: System.Security.Cryptography
  DNDeriveBytes = interface; // type: System.Security.Cryptography.DeriveBytes, namespace: System.Security.Cryptography
  DNRfc2898DeriveBytes = interface; // type: System.Security.Cryptography.Rfc2898DeriveBytes, namespace: System.Security.Cryptography
  DNECCurve_NamedCurves = interface; // type: System.Security.Cryptography.ECCurve+NamedCurves, namespace: System.Security.Cryptography
  DNECDiffieHellmanPublicKey = interface; // type: System.Security.Cryptography.ECDiffieHellmanPublicKey, namespace: System.Security.Cryptography
  DNHMACMD5 = interface; // type: System.Security.Cryptography.HMACMD5, namespace: System.Security.Cryptography
  DNHMACSHA1 = interface; // type: System.Security.Cryptography.HMACSHA1, namespace: System.Security.Cryptography
  DNHMACSHA256 = interface; // type: System.Security.Cryptography.HMACSHA256, namespace: System.Security.Cryptography
  DNHMACSHA384 = interface; // type: System.Security.Cryptography.HMACSHA384, namespace: System.Security.Cryptography
  DNHMACSHA512 = interface; // type: System.Security.Cryptography.HMACSHA512, namespace: System.Security.Cryptography
  DNMD5 = interface; // type: System.Security.Cryptography.MD5, namespace: System.Security.Cryptography
  DNSHA1 = interface; // type: System.Security.Cryptography.SHA1, namespace: System.Security.Cryptography
  DNSHA1Managed = interface; // type: System.Security.Cryptography.SHA1Managed, namespace: System.Security.Cryptography
  DNSHA256 = interface; // type: System.Security.Cryptography.SHA256, namespace: System.Security.Cryptography
  DNSHA256Managed = interface; // type: System.Security.Cryptography.SHA256Managed, namespace: System.Security.Cryptography
  DNSHA384 = interface; // type: System.Security.Cryptography.SHA384, namespace: System.Security.Cryptography
  DNSHA384Managed = interface; // type: System.Security.Cryptography.SHA384Managed, namespace: System.Security.Cryptography
  DNSHA512 = interface; // type: System.Security.Cryptography.SHA512, namespace: System.Security.Cryptography
  DNSHA512Managed = interface; // type: System.Security.Cryptography.SHA512Managed, namespace: System.Security.Cryptography
  DNIncrementalHash = interface; // type: System.Security.Cryptography.IncrementalHash, namespace: System.Security.Cryptography
  DNMaskGenerationMethod = interface; // type: System.Security.Cryptography.MaskGenerationMethod, namespace: System.Security.Cryptography
  DNPKCS1MaskGenerationMethod = interface; // type: System.Security.Cryptography.PKCS1MaskGenerationMethod, namespace: System.Security.Cryptography
  DNRandomNumberGenerator = interface; // type: System.Security.Cryptography.RandomNumberGenerator, namespace: System.Security.Cryptography
  DNRSAEncryptionPadding = interface; // type: System.Security.Cryptography.RSAEncryptionPadding, namespace: System.Security.Cryptography
  DNRSASignaturePadding = interface; // type: System.Security.Cryptography.RSASignaturePadding, namespace: System.Security.Cryptography
  DNSignatureDescription = interface; // type: System.Security.Cryptography.SignatureDescription, namespace: System.Security.Cryptography
  DNAes = interface; // type: System.Security.Cryptography.Aes, namespace: System.Security.Cryptography
  DNAesManaged = interface; // type: System.Security.Cryptography.AesManaged, namespace: System.Security.Cryptography
  DNDES = interface; // type: System.Security.Cryptography.DES, namespace: System.Security.Cryptography
  DNRC2 = interface; // type: System.Security.Cryptography.RC2, namespace: System.Security.Cryptography
  DNRijndael = interface; // type: System.Security.Cryptography.Rijndael, namespace: System.Security.Cryptography
  DNRijndaelManaged = interface; // type: System.Security.Cryptography.RijndaelManaged, namespace: System.Security.Cryptography
  DNTripleDES = interface; // type: System.Security.Cryptography.TripleDES, namespace: System.Security.Cryptography
  DNDSAParameters = interface; // type: System.Security.Cryptography.DSAParameters, namespace: System.Security.Cryptography
  DNECCurve = interface; // type: System.Security.Cryptography.ECCurve, namespace: System.Security.Cryptography
  DNECParameters = interface; // type: System.Security.Cryptography.ECParameters, namespace: System.Security.Cryptography
  DNECPoint = interface; // type: System.Security.Cryptography.ECPoint, namespace: System.Security.Cryptography
  DNRSAParameters = interface; // type: System.Security.Cryptography.RSAParameters, namespace: System.Security.Cryptography


{ objects }

  //-------------namespace: System.Security.Cryptography----------------
  DNAesCcmClass = interface(DNObjectClass)
  ['{C5B7D412-A9A2-59D4-BCDC-02F3A2574A82}']
  { static getter & setter } 

    {class} function get_NonceByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes;
    {class} function get_TagByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes;

  { constructors } 

    {class} function init(key: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNAesCcm; overload;
    {class} function init(key: TArray<Byte>): DNAesCcm; overload;

  { static propertys } 

    {class} property NonceByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes read get_NonceByteSizes;
    {class} property TagByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes read get_TagByteSizes;
  end;

  [DNTypeName('System.Security.Cryptography.AesCcm')]
  DNAesCcm = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{6BE60C4C-C2E1-36B6-9CAA-8409BDA3BEB5}']
  { methods } 

    procedure Encrypt(nonce: TArray<Byte>; plaintext: TArray<Byte>; ciphertext: TArray<Byte>; tag: TArray<Byte>; associatedData: TArray<Byte>); overload;
    procedure Encrypt(nonce: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; plaintext: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; ciphertext: DDNC.System.Private.CoreLib.DNSpan<Byte>; tag: DDNC.System.Private.CoreLib.DNSpan<Byte>; associatedData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure Decrypt(nonce: TArray<Byte>; ciphertext: TArray<Byte>; tag: TArray<Byte>; plaintext: TArray<Byte>; associatedData: TArray<Byte>); overload;
    procedure Decrypt(nonce: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; ciphertext: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; tag: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; plaintext: DDNC.System.Private.CoreLib.DNSpan<Byte>; associatedData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNAesCcm = class(TDNGenericImport<DNAesCcmClass, DNAesCcm>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesGcmClass = interface(DNObjectClass)
  ['{DA689E6D-DB3B-56B3-8BD4-B6FC10C21137}']
  { static getter & setter } 

    {class} function get_NonceByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes;
    {class} function get_TagByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes;

  { constructors } 

    {class} function init(key: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNAesGcm; overload;
    {class} function init(key: TArray<Byte>): DNAesGcm; overload;

  { static propertys } 

    {class} property NonceByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes read get_NonceByteSizes;
    {class} property TagByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes read get_TagByteSizes;
  end;

  [DNTypeName('System.Security.Cryptography.AesGcm')]
  DNAesGcm = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{194ABC0C-83CB-3876-B0F3-75C2FE6A8CD1}']
  { methods } 

    procedure Encrypt(nonce: TArray<Byte>; plaintext: TArray<Byte>; ciphertext: TArray<Byte>; tag: TArray<Byte>; associatedData: TArray<Byte>); overload;
    procedure Encrypt(nonce: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; plaintext: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; ciphertext: DDNC.System.Private.CoreLib.DNSpan<Byte>; tag: DDNC.System.Private.CoreLib.DNSpan<Byte>; associatedData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure Decrypt(nonce: TArray<Byte>; ciphertext: TArray<Byte>; tag: TArray<Byte>; plaintext: TArray<Byte>; associatedData: TArray<Byte>); overload;
    procedure Decrypt(nonce: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; ciphertext: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; tag: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; plaintext: DDNC.System.Private.CoreLib.DNSpan<Byte>; associatedData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNAesGcm = class(TDNGenericImport<DNAesGcmClass, DNAesGcm>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSAClass = interface(DNObjectClass)
  ['{A148522C-51B0-5C76-A97D-F1A7D9934994}']
  { static methods } 

    {class} function Create(algName: string): DNDSA; overload;
    {class} function Create(keySizeInBits: Int32): DNDSA; overload;
    {class} function Create(parameters: DNDSAParameters): DNDSA; overload;
    {class} function Create: DNDSA; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSA')]
  DNDSA = interface(DNObject)
  ['{64078178-500F-3783-BAB3-EFCBBA0DF34D}']
  { getters & setters } 

    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_SignatureAlgorithm: string;
    function get_KeyExchangeAlgorithm: string;

  { methods } 

    function ExportParameters(includePrivateParameters: Boolean): DNDSAParameters;
    procedure ImportParameters(parameters: DNDSAParameters);
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
  end;

  TDNDSA = class(TDNGenericImport<DNDSAClass, DNDSA>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanClass = interface(DNObjectClass)
  ['{0BC99304-E828-54FE-BF83-16181CD7445C}']
  { static methods } 

    {class} function Create(algorithm: string): DNECDiffieHellman; overload;
    {class} function Create: DNECDiffieHellman; overload;
    {class} function Create(curve: DNECCurve): DNECDiffieHellman; overload;
    {class} function Create(parameters: DNECParameters): DNECDiffieHellman; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellman')]
  DNECDiffieHellman = interface(DNObject)
  ['{B45D131F-6A27-3DD2-A898-E0F8DDE9BF82}']
  { getters & setters } 

    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_PublicKey: DNECDiffieHellmanPublicKey;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function DeriveKeyMaterial(otherPartyPublicKey: DNECDiffieHellmanPublicKey): TArray<Byte>;
    function DeriveKeyFromHash(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function DeriveKeyFromHash(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyTls(otherPartyPublicKey: DNECDiffieHellmanPublicKey; prfLabel: TArray<Byte>; prfSeed: TArray<Byte>): TArray<Byte>;
    function ExportParameters(includePrivateParameters: Boolean): DNECParameters;
    function ExportExplicitParameters(includePrivateParameters: Boolean): DNECParameters;
    procedure ImportParameters(parameters: DNECParameters);
    procedure GenerateKey(curve: DNECCurve);
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportECPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function ExportECPrivateKey: TArray<Byte>;
    function TryExportECPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property PublicKey: DNECDiffieHellmanPublicKey read get_PublicKey;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNECDiffieHellman = class(TDNGenericImport<DNECDiffieHellmanClass, DNECDiffieHellman>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDsaClass = interface(DNObjectClass)
  ['{C82DA133-4744-56B1-BE12-EAE4E8D63041}']
  { static methods } 

    {class} function Create(algorithm: string): DNECDsa; overload;
    {class} function Create: DNECDsa; overload;
    {class} function Create(curve: DNECCurve): DNECDsa; overload;
    {class} function Create(parameters: DNECParameters): DNECDsa; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDsa')]
  DNECDsa = interface(DNObject)
  ['{5200A63F-36E5-3E13-A453-32707C09D6A8}']
  { getters & setters } 

    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function ExportParameters(includePrivateParameters: Boolean): DNECParameters;
    function ExportExplicitParameters(includePrivateParameters: Boolean): DNECParameters;
    procedure ImportParameters(parameters: DNECParameters);
    procedure GenerateKey(curve: DNECCurve);
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function SignHash(hash: TArray<Byte>): TArray<Byte>;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>): Boolean; overload;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportECPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function ExportECPrivateKey: TArray<Byte>;
    function TryExportECPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNECDsa = class(TDNGenericImport<DNECDsaClass, DNECDsa>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAClass = interface(DNObjectClass)
  ['{E08BAB7A-320E-5C66-A6D6-0193C140F141}']
  { static methods } 

    {class} function Create(algName: string): DNRSA; overload;
    {class} function Create(keySizeInBits: Int32): DNRSA; overload;
    {class} function Create(parameters: DNRSAParameters): DNRSA; overload;
    {class} function Create: DNRSA; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSA')]
  DNRSA = interface(DNObject)
  ['{25BDD9B9-7498-33AB-9021-FA70C5A970D9}']
  { getters & setters } 

    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function ExportParameters(includePrivateParameters: Boolean): DNRSAParameters;
    procedure ImportParameters(parameters: DNRSAParameters);
    function Encrypt(data: TArray<Byte>; padding: DNRSAEncryptionPadding): TArray<Byte>;
    function Decrypt(data: TArray<Byte>; padding: DNRSAEncryptionPadding): TArray<Byte>;
    function SignHash(hash: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function TryDecrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TryEncrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function DecryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function EncryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function ExportRSAPrivateKey: TArray<Byte>;
    function TryExportRSAPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ExportRSAPublicKey: TArray<Byte>;
    function TryExportRSAPublicKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPublicKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNRSA = class(TDNGenericImport<DNRSAClass, DNRSA>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricKeyExchangeDeformatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{C207855F-06FE-5303-AC23-D67B8232D73E}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricKeyExchangeDeformatter')]
  DNAsymmetricKeyExchangeDeformatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{1A11422C-A3A2-3D1C-97A3-09FA6037AE23}']
  { getters & setters } 

    function get_Parameters: string;
    procedure set_Parameters(value: string);

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function DecryptKeyExchange(rgb: TArray<Byte>): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameters: string read get_Parameters write set_Parameters;
  end;

  TDNAsymmetricKeyExchangeDeformatter = class(TDNGenericImport<DNAsymmetricKeyExchangeDeformatterClass, DNAsymmetricKeyExchangeDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAOAEPKeyExchangeDeformatterClass = interface(DNAsymmetricKeyExchangeDeformatterClass)
  ['{BC6A1B21-50CF-5EC5-8A06-8491DCB1C5AE}']
  { constructors } 

    {class} function init: DNRSAOAEPKeyExchangeDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAOAEPKeyExchangeDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAOAEPKeyExchangeDeformatter')]
  DNRSAOAEPKeyExchangeDeformatter = interface(DNAsymmetricKeyExchangeDeformatter)
  ['{4E254DCF-623F-34A3-8640-04BF17BA2922}']
  { getters & setters } 

    function get_Parameters: string;
    procedure set_Parameters(value: string);

  { methods } 

    function DecryptKeyExchange(rgbData: TArray<Byte>): TArray<Byte>;
    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameters: string read get_Parameters write set_Parameters;
  end;

  TDNRSAOAEPKeyExchangeDeformatter = class(TDNGenericImport<DNRSAOAEPKeyExchangeDeformatterClass, DNRSAOAEPKeyExchangeDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1KeyExchangeDeformatterClass = interface(DNAsymmetricKeyExchangeDeformatterClass)
  ['{89218D72-C98E-5A13-86E1-46E6D413B404}']
  { constructors } 

    {class} function init: DNRSAPKCS1KeyExchangeDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1KeyExchangeDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1KeyExchangeDeformatter')]
  DNRSAPKCS1KeyExchangeDeformatter = interface(DNAsymmetricKeyExchangeDeformatter)
  ['{A38A5EF5-98C7-3F3A-BAC3-B32F0F6CE3BC}']
  { getters & setters } 

    function get_RNG: DNRandomNumberGenerator;
    procedure set_RNG(value: DNRandomNumberGenerator);
    function get_Parameters: string;
    procedure set_Parameters(value: string);

  { methods } 

    function DecryptKeyExchange(rgbIn: TArray<Byte>): TArray<Byte>;
    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property RNG: DNRandomNumberGenerator read get_RNG write set_RNG;
    property Parameters: string read get_Parameters write set_Parameters;
  end;

  TDNRSAPKCS1KeyExchangeDeformatter = class(TDNGenericImport<DNRSAPKCS1KeyExchangeDeformatterClass, DNRSAPKCS1KeyExchangeDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricKeyExchangeFormatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{49005BB2-0741-5D8F-81A1-1D4B41EC40BF}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricKeyExchangeFormatter')]
  DNAsymmetricKeyExchangeFormatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F3FF46FA-2924-3048-82B1-D49FE7239D4D}']
  { getters & setters } 

    function get_Parameters: string;

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function CreateKeyExchange(data: TArray<Byte>): TArray<Byte>; overload;
    function CreateKeyExchange(data: TArray<Byte>; symAlgType: DDNC.System.Private.CoreLib.DNType): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameters: string read get_Parameters;
  end;

  TDNAsymmetricKeyExchangeFormatter = class(TDNGenericImport<DNAsymmetricKeyExchangeFormatterClass, DNAsymmetricKeyExchangeFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAOAEPKeyExchangeFormatterClass = interface(DNAsymmetricKeyExchangeFormatterClass)
  ['{0F000096-C72D-51CD-9940-3AB60FCC141E}']
  { constructors } 

    {class} function init: DNRSAOAEPKeyExchangeFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAOAEPKeyExchangeFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAOAEPKeyExchangeFormatter')]
  DNRSAOAEPKeyExchangeFormatter = interface(DNAsymmetricKeyExchangeFormatter)
  ['{241230E5-6F3C-3264-9E1B-959021DD2958}']
  { getters & setters } 

    function get_Parameter: TArray<Byte>;
    procedure set_Parameter(value: TArray<Byte>);
    function get_Parameters: string;
    function get_Rng: DNRandomNumberGenerator;
    procedure set_Rng(value: DNRandomNumberGenerator);

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function CreateKeyExchange(rgbData: TArray<Byte>; symAlgType: DDNC.System.Private.CoreLib.DNType): TArray<Byte>; overload;
    function CreateKeyExchange(rgbData: TArray<Byte>): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameter: TArray<Byte> read get_Parameter write set_Parameter;
    property Parameters: string read get_Parameters;
    property Rng: DNRandomNumberGenerator read get_Rng write set_Rng;
  end;

  TDNRSAOAEPKeyExchangeFormatter = class(TDNGenericImport<DNRSAOAEPKeyExchangeFormatterClass, DNRSAOAEPKeyExchangeFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1KeyExchangeFormatterClass = interface(DNAsymmetricKeyExchangeFormatterClass)
  ['{69F8B4B0-965F-5B01-8186-2763E73F701E}']
  { constructors } 

    {class} function init: DNRSAPKCS1KeyExchangeFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1KeyExchangeFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1KeyExchangeFormatter')]
  DNRSAPKCS1KeyExchangeFormatter = interface(DNAsymmetricKeyExchangeFormatter)
  ['{41F78A6F-9F05-326F-954A-F64FB49A56D2}']
  { getters & setters } 

    function get_Parameters: string;
    function get_Rng: DNRandomNumberGenerator;
    procedure set_Rng(value: DNRandomNumberGenerator);

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function CreateKeyExchange(rgbData: TArray<Byte>; symAlgType: DDNC.System.Private.CoreLib.DNType): TArray<Byte>; overload;
    function CreateKeyExchange(rgbData: TArray<Byte>): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameters: string read get_Parameters;
    property Rng: DNRandomNumberGenerator read get_Rng write set_Rng;
  end;

  TDNRSAPKCS1KeyExchangeFormatter = class(TDNGenericImport<DNRSAPKCS1KeyExchangeFormatterClass, DNRSAPKCS1KeyExchangeFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricSignatureDeformatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{C46B7FF4-306B-57EC-9ADC-E756C3150B9F}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricSignatureDeformatter')]
  DNAsymmetricSignatureDeformatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2D29D8EF-7F87-3A81-818C-1962C4650385}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function VerifySignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNAsymmetricSignatureDeformatter = class(TDNGenericImport<DNAsymmetricSignatureDeformatterClass, DNAsymmetricSignatureDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSASignatureDeformatterClass = interface(DNAsymmetricSignatureDeformatterClass)
  ['{F8878546-718C-55A0-9C5A-2EDA677C8FB8}']
  { constructors } 

    {class} function init: DNDSASignatureDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNDSASignatureDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSASignatureDeformatter')]
  DNDSASignatureDeformatter = interface(DNAsymmetricSignatureDeformatter)
  ['{5E2AE3E2-EB4C-354A-965B-0C91D88A569C}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm; rgbSignature: TArray<Byte>): Boolean; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDSASignatureDeformatter = class(TDNGenericImport<DNDSASignatureDeformatterClass, DNDSASignatureDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1SignatureDeformatterClass = interface(DNAsymmetricSignatureDeformatterClass)
  ['{316C4750-6F26-5876-A6CB-DFDD5AA2DA98}']
  { constructors } 

    {class} function init: DNRSAPKCS1SignatureDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1SignatureDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1SignatureDeformatter')]
  DNRSAPKCS1SignatureDeformatter = interface(DNAsymmetricSignatureDeformatter)
  ['{7EFFF9CE-90B3-389C-9D6B-B13D49173AE3}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm; rgbSignature: TArray<Byte>): Boolean; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNRSAPKCS1SignatureDeformatter = class(TDNGenericImport<DNRSAPKCS1SignatureDeformatterClass, DNRSAPKCS1SignatureDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricSignatureFormatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{95DEB523-9924-5F82-80F8-AC3DEC438A41}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricSignatureFormatter')]
  DNAsymmetricSignatureFormatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A02E20F8-7320-32BA-99D3-3204F2D9FE25}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function CreateSignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm): TArray<Byte>; overload;
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNAsymmetricSignatureFormatter = class(TDNGenericImport<DNAsymmetricSignatureFormatterClass, DNAsymmetricSignatureFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSASignatureFormatterClass = interface(DNAsymmetricSignatureFormatterClass)
  ['{7D110341-FF98-54F6-A6BF-4DB9FC356544}']
  { constructors } 

    {class} function init: DNDSASignatureFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNDSASignatureFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSASignatureFormatter')]
  DNDSASignatureFormatter = interface(DNAsymmetricSignatureFormatter)
  ['{5BEAC072-9A7A-3972-BEDA-D9EAB1F048FB}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function CreateSignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDSASignatureFormatter = class(TDNGenericImport<DNDSASignatureFormatterClass, DNDSASignatureFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1SignatureFormatterClass = interface(DNAsymmetricSignatureFormatterClass)
  ['{F236F125-159C-5542-BF1E-6CCCA08923FA}']
  { constructors } 

    {class} function init: DNRSAPKCS1SignatureFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1SignatureFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1SignatureFormatter')]
  DNRSAPKCS1SignatureFormatter = interface(DNAsymmetricSignatureFormatter)
  ['{37992AF9-CE1E-3FE0-80E3-87647B12C19A}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function CreateSignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNRSAPKCS1SignatureFormatter = class(TDNGenericImport<DNRSAPKCS1SignatureFormatterClass, DNRSAPKCS1SignatureFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCryptoConfigClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{2FF58136-9D3A-527A-AC60-E26543C4A27E}']
  { static getter & setter } 

    {class} function get_AllowOnlyFipsAlgorithms: Boolean;

  { constructors } 

    {class} function init: DNCryptoConfig;

  { static methods } 

    {class} procedure AddAlgorithm(algorithm: DDNC.System.Private.CoreLib.DNType; names: TArray<string>);
    {class} function CreateFromName(name: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject; overload;
    {class} function CreateFromName(name: string): DDNC.System.Private.CoreLib.DNObject; overload;
    {class} procedure AddOID(oid: string; names: TArray<string>);
    {class} function MapNameToOID(name: string): string;
    {class} function EncodeOID(str: string): TArray<Byte>;

  { static propertys } 

    {class} property AllowOnlyFipsAlgorithms: Boolean read get_AllowOnlyFipsAlgorithms;
  end;

  [DNTypeName('System.Security.Cryptography.CryptoConfig')]
  DNCryptoConfig = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{EBF03E3C-BE66-3058-A9EC-3A6ECE9EB53A}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNCryptoConfig = class(TDNGenericImport<DNCryptoConfigClass, DNCryptoConfig>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDeriveBytesClass = interface(DNObjectClass)
  ['{B92D5DE6-9DCA-55F8-A8D7-C923B98ED1B7}']
  end;

  [DNTypeName('System.Security.Cryptography.DeriveBytes')]
  DNDeriveBytes = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{BC968320-1B6A-3568-856A-0C5CDE273AF0}']
  { methods } 

    function GetBytes(cb: Int32): TArray<Byte>;
    procedure Reset;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDeriveBytes = class(TDNGenericImport<DNDeriveBytesClass, DNDeriveBytes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRfc2898DeriveBytesClass = interface(DNDeriveBytesClass)
  ['{269F2420-2BB1-5572-865E-BDE98CB5C0B9}']
  { constructors } 

    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; iterations: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; iterations: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; salt: TArray<Byte>): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; salt: TArray<Byte>; iterations: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; salt: TArray<Byte>; iterations: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; saltSize: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; saltSize: Int32; iterations: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; saltSize: Int32; iterations: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRfc2898DeriveBytes; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Rfc2898DeriveBytes')]
  DNRfc2898DeriveBytes = interface(DNDeriveBytes)
  ['{89C7A908-4604-3B7B-918B-B64D3FBA7178}']
  { getters & setters } 

    function get_HashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;
    function get_IterationCount: Int32;
    procedure set_IterationCount(value: Int32);
    function get_Salt: TArray<Byte>;
    procedure set_Salt(value: TArray<Byte>);

  { methods } 

    function GetBytes(cb: Int32): TArray<Byte>;
    function CryptDeriveKey(algname: string; alghashname: string; keySize: Int32; rgbIV: TArray<Byte>): TArray<Byte>;
    procedure Reset;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_HashAlgorithm;
    property IterationCount: Int32 read get_IterationCount write set_IterationCount;
    property Salt: TArray<Byte> read get_Salt write set_Salt;
  end;

  TDNRfc2898DeriveBytes = class(TDNGenericImport<DNRfc2898DeriveBytesClass, DNRfc2898DeriveBytes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECCurve_NamedCurvesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{E2BBD9A3-0F92-5B8B-97B8-E850EA313CE3}']
  { static getter & setter } 

    {class} function get_brainpoolP160r1: DNECCurve;
    {class} function get_brainpoolP160t1: DNECCurve;
    {class} function get_brainpoolP192r1: DNECCurve;
    {class} function get_brainpoolP192t1: DNECCurve;
    {class} function get_brainpoolP224r1: DNECCurve;
    {class} function get_brainpoolP224t1: DNECCurve;
    {class} function get_brainpoolP256r1: DNECCurve;
    {class} function get_brainpoolP256t1: DNECCurve;
    {class} function get_brainpoolP320r1: DNECCurve;
    {class} function get_brainpoolP320t1: DNECCurve;
    {class} function get_brainpoolP384r1: DNECCurve;
    {class} function get_brainpoolP384t1: DNECCurve;
    {class} function get_brainpoolP512r1: DNECCurve;
    {class} function get_brainpoolP512t1: DNECCurve;
    {class} function get_nistP256: DNECCurve;
    {class} function get_nistP384: DNECCurve;
    {class} function get_nistP521: DNECCurve;

  { static propertys } 

    {class} property brainpoolP160r1: DNECCurve read get_brainpoolP160r1;
    {class} property brainpoolP160t1: DNECCurve read get_brainpoolP160t1;
    {class} property brainpoolP192r1: DNECCurve read get_brainpoolP192r1;
    {class} property brainpoolP192t1: DNECCurve read get_brainpoolP192t1;
    {class} property brainpoolP224r1: DNECCurve read get_brainpoolP224r1;
    {class} property brainpoolP224t1: DNECCurve read get_brainpoolP224t1;
    {class} property brainpoolP256r1: DNECCurve read get_brainpoolP256r1;
    {class} property brainpoolP256t1: DNECCurve read get_brainpoolP256t1;
    {class} property brainpoolP320r1: DNECCurve read get_brainpoolP320r1;
    {class} property brainpoolP320t1: DNECCurve read get_brainpoolP320t1;
    {class} property brainpoolP384r1: DNECCurve read get_brainpoolP384r1;
    {class} property brainpoolP384t1: DNECCurve read get_brainpoolP384t1;
    {class} property brainpoolP512r1: DNECCurve read get_brainpoolP512r1;
    {class} property brainpoolP512t1: DNECCurve read get_brainpoolP512t1;
    {class} property nistP256: DNECCurve read get_nistP256;
    {class} property nistP384: DNECCurve read get_nistP384;
    {class} property nistP521: DNECCurve read get_nistP521;
  end;

  [DNTypeName('System.Security.Cryptography.ECCurve+NamedCurves')]
  DNECCurve_NamedCurves = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C18FA636-AA83-3B0E-909A-D16C20BAB049}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNECCurve_NamedCurves = class(TDNGenericImport<DNECCurve_NamedCurvesClass, DNECCurve_NamedCurves>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanPublicKeyClass = interface(DNObjectClass)
  ['{F4F0814D-8DA3-5C8F-9B5E-DEF1EEC0648C}']
  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanPublicKey')]
  DNECDiffieHellmanPublicKey = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{A42392FD-E825-37EB-99BD-4EFA56183E77}']
  { methods } 

    procedure Dispose;
    function ToByteArray: TArray<Byte>;
    function ToXmlString: string;
    function ExportParameters: DNECParameters;
    function ExportExplicitParameters: DNECParameters;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNECDiffieHellmanPublicKey = class(TDNGenericImport<DNECDiffieHellmanPublicKeyClass, DNECDiffieHellmanPublicKey>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACMD5Class = interface(DNObjectClass)
  ['{06CFDD50-89EF-5D0E-B5D3-3FC59D246270}']
  { constructors } 

    {class} function init: DNHMACMD5; overload;
    {class} function init(key: TArray<Byte>): DNHMACMD5; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACMD5')]
  DNHMACMD5 = interface(DNObject)
  ['{4CCFBA36-CB13-3004-91BE-A48635C43A4F}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACMD5 = class(TDNGenericImport<DNHMACMD5Class, DNHMACMD5>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA1Class = interface(DNObjectClass)
  ['{DF775604-DCDA-5D41-9DB6-61CB82BCCB06}']
  { constructors } 

    {class} function init: DNHMACSHA1; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA1; overload;
    {class} function init(key: TArray<Byte>; useManagedSha1: Boolean): DNHMACSHA1; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA1')]
  DNHMACSHA1 = interface(DNObject)
  ['{E08A0372-78A2-3A05-84F3-F6E16EC83FB0}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA1 = class(TDNGenericImport<DNHMACSHA1Class, DNHMACSHA1>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA256Class = interface(DNObjectClass)
  ['{A5151016-9656-543A-B9AF-913E8CE2E987}']
  { constructors } 

    {class} function init: DNHMACSHA256; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA256; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA256')]
  DNHMACSHA256 = interface(DNObject)
  ['{743A4384-7229-31D1-ABCE-50FAE3217E1D}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA256 = class(TDNGenericImport<DNHMACSHA256Class, DNHMACSHA256>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA384Class = interface(DNObjectClass)
  ['{162F1319-7567-5D1E-A6E8-BEC538793483}']
  { constructors } 

    {class} function init: DNHMACSHA384; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA384; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA384')]
  DNHMACSHA384 = interface(DNObject)
  ['{91B4FDE6-1069-3A95-AA40-C7D198388D8D}']
  { getters & setters } 

    function get_ProduceLegacyHmacValues: Boolean;
    procedure set_ProduceLegacyHmacValues(value: Boolean);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ProduceLegacyHmacValues: Boolean read get_ProduceLegacyHmacValues write set_ProduceLegacyHmacValues;
    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA384 = class(TDNGenericImport<DNHMACSHA384Class, DNHMACSHA384>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA512Class = interface(DNObjectClass)
  ['{DA92AAEC-372A-5B83-99C4-6D74B93A35B1}']
  { constructors } 

    {class} function init: DNHMACSHA512; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA512; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA512')]
  DNHMACSHA512 = interface(DNObject)
  ['{7DCA5B67-E150-3FCE-81FD-B948EE465B27}']
  { getters & setters } 

    function get_ProduceLegacyHmacValues: Boolean;
    procedure set_ProduceLegacyHmacValues(value: Boolean);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ProduceLegacyHmacValues: Boolean read get_ProduceLegacyHmacValues write set_ProduceLegacyHmacValues;
    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA512 = class(TDNGenericImport<DNHMACSHA512Class, DNHMACSHA512>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNMD5Class = interface(DNObjectClass)
  ['{E9959123-46F6-5312-BDCD-EC9249F5648C}']
  { static methods } 

    {class} function Create: DNMD5; overload;
    {class} function Create(algName: string): DNMD5; overload;

  end;

  [DNTypeName('System.Security.Cryptography.MD5')]
  DNMD5 = interface(DNObject)
  ['{7F1F1A6A-BA52-3E0B-AAD3-7ACA8463F688}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNMD5 = class(TDNGenericImport<DNMD5Class, DNMD5>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA1Class = interface(DNObjectClass)
  ['{97EF8F26-9556-5110-9CD8-C01C110EF49C}']
  { static methods } 

    {class} function Create: DNSHA1; overload;
    {class} function Create(hashName: string): DNSHA1; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SHA1')]
  DNSHA1 = interface(DNObject)
  ['{CA8451F7-3249-3A05-B767-11EA6984EE1D}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA1 = class(TDNGenericImport<DNSHA1Class, DNSHA1>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA1ManagedClass = interface(DNSHA1Class)
  ['{550B54A2-C943-5A5D-AB6E-654D3ABE0894}']
  { constructors } 

    {class} function init: DNSHA1Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA1Managed')]
  DNSHA1Managed = interface(DNSHA1)
  ['{95033CC0-0277-3810-A7A7-EB6E90EAA777}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA1Managed = class(TDNGenericImport<DNSHA1ManagedClass, DNSHA1Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA256Class = interface(DNObjectClass)
  ['{85D09537-FF21-59CF-844F-F3C79B940204}']
  { static methods } 

    {class} function Create: DNSHA256; overload;
    {class} function Create(hashName: string): DNSHA256; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SHA256')]
  DNSHA256 = interface(DNObject)
  ['{09755BED-1465-3C34-8B8E-66A726D8CF1A}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA256 = class(TDNGenericImport<DNSHA256Class, DNSHA256>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA256ManagedClass = interface(DNSHA256Class)
  ['{F8675ED7-E908-592A-9DF9-B070D33BF3D2}']
  { constructors } 

    {class} function init: DNSHA256Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA256Managed')]
  DNSHA256Managed = interface(DNSHA256)
  ['{DCA0E3F9-1924-3040-BF87-F9D26AC756FA}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA256Managed = class(TDNGenericImport<DNSHA256ManagedClass, DNSHA256Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA384Class = interface(DNObjectClass)
  ['{9BFE6377-9288-5323-AE5E-964D85559B52}']
  { static methods } 

    {class} function Create: DNSHA384; overload;
    {class} function Create(hashName: string): DNSHA384; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SHA384')]
  DNSHA384 = interface(DNObject)
  ['{D61B72E8-9299-3B86-8657-7944914A24D3}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA384 = class(TDNGenericImport<DNSHA384Class, DNSHA384>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA384ManagedClass = interface(DNSHA384Class)
  ['{C2F0BCE4-3128-5D3A-BEC1-625EB4B79AC7}']
  { constructors } 

    {class} function init: DNSHA384Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA384Managed')]
  DNSHA384Managed = interface(DNSHA384)
  ['{2130DB09-70D5-3BF8-B6C9-3AF119C0BF12}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA384Managed = class(TDNGenericImport<DNSHA384ManagedClass, DNSHA384Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA512Class = interface(DNObjectClass)
  ['{8731E0E2-B023-5499-8019-F960F897F7D5}']
  { static methods } 

    {class} function Create: DNSHA512; overload;
    {class} function Create(hashName: string): DNSHA512; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SHA512')]
  DNSHA512 = interface(DNObject)
  ['{EEEB5A9A-BBCA-378D-9E2C-860DFA98E75B}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA512 = class(TDNGenericImport<DNSHA512Class, DNSHA512>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA512ManagedClass = interface(DNSHA512Class)
  ['{45E3150C-6AB5-5756-BD2F-BFC957787A76}']
  { constructors } 

    {class} function init: DNSHA512Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA512Managed')]
  DNSHA512Managed = interface(DNSHA512)
  ['{29D57FE8-2B4E-3F0A-BF6B-0E3BA8AA3662}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA512Managed = class(TDNGenericImport<DNSHA512ManagedClass, DNSHA512Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNIncrementalHashClass = interface(DNObjectClass)
  ['{DB3443D7-7C55-5857-85C0-A7AE18E1B289}']
  { static methods } 

    {class} function CreateHash(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNIncrementalHash;
    {class} function CreateHMAC(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; key: TArray<Byte>): DNIncrementalHash;

  end;

  [DNTypeName('System.Security.Cryptography.IncrementalHash')]
  DNIncrementalHash = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{C41FF611-88E8-3179-9ABE-7BE351372FD6}']
  { getters & setters } 

    function get_AlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;

  { methods } 

    procedure AppendData(data: TArray<Byte>); overload;
    procedure AppendData(data: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure AppendData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    function GetHashAndReset: TArray<Byte>;
    function TryGetHashAndReset(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_AlgorithmName;
  end;

  TDNIncrementalHash = class(TDNGenericImport<DNIncrementalHashClass, DNIncrementalHash>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNMaskGenerationMethodClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{3D0CFE94-8A2E-514E-931D-68FC834EF4A4}']
  end;

  [DNTypeName('System.Security.Cryptography.MaskGenerationMethod')]
  DNMaskGenerationMethod = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4D8CBF69-CECA-3510-B69E-BF9563E18DFC}']
  { methods } 

    function GenerateMask(rgbSeed: TArray<Byte>; cbReturn: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNMaskGenerationMethod = class(TDNGenericImport<DNMaskGenerationMethodClass, DNMaskGenerationMethod>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNPKCS1MaskGenerationMethodClass = interface(DNMaskGenerationMethodClass)
  ['{B9E687F9-2192-51EC-84FD-372A09A9201F}']
  { constructors } 

    {class} function init: DNPKCS1MaskGenerationMethod;

  end;

  [DNTypeName('System.Security.Cryptography.PKCS1MaskGenerationMethod')]
  DNPKCS1MaskGenerationMethod = interface(DNMaskGenerationMethod)
  ['{53909F7F-28E2-3CF3-99B3-5928FF8BEB8C}']
  { getters & setters } 

    function get_HashName: string;
    procedure set_HashName(value: string);

  { methods } 

    function GenerateMask(rgbSeed: TArray<Byte>; cbReturn: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashName: string read get_HashName write set_HashName;
  end;

  TDNPKCS1MaskGenerationMethod = class(TDNGenericImport<DNPKCS1MaskGenerationMethodClass, DNPKCS1MaskGenerationMethod>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRandomNumberGeneratorClass = interface(DNObjectClass)
  ['{88FBB9DE-929D-5300-9851-07C621AD9711}']
  { static methods } 

    {class} function Create: DNRandomNumberGenerator; overload;
    {class} function Create(rngName: string): DNRandomNumberGenerator; overload;
    {class} procedure Fill(data: DDNC.System.Private.CoreLib.DNSpan<Byte>);
    {class} function GetInt32(fromInclusive: Int32; toExclusive: Int32): Int32; overload;
    {class} function GetInt32(toExclusive: Int32): Int32; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RandomNumberGenerator')]
  DNRandomNumberGenerator = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{CA1446CC-BE02-305B-B9B8-4E1884E5F22A}']
  { methods } 

    procedure Dispose;
    procedure GetBytes(data: TArray<Byte>); overload;
    procedure GetBytes(data: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure GetBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    procedure GetNonZeroBytes(data: TArray<Byte>); overload;
    procedure GetNonZeroBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNRandomNumberGenerator = class(TDNGenericImport<DNRandomNumberGeneratorClass, DNRandomNumberGenerator>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAEncryptionPaddingClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{4ED8DCFA-A6AB-5CB6-B19C-3236ADA9FCB9}']
  { static getter & setter } 

    {class} function get_Pkcs1: DNRSAEncryptionPadding;
    {class} function get_OaepSHA1: DNRSAEncryptionPadding;
    {class} function get_OaepSHA256: DNRSAEncryptionPadding;
    {class} function get_OaepSHA384: DNRSAEncryptionPadding;
    {class} function get_OaepSHA512: DNRSAEncryptionPadding;

  { static methods } 

    {class} function CreateOaep(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRSAEncryptionPadding;

  { static propertys } 

    {class} property Pkcs1: DNRSAEncryptionPadding read get_Pkcs1;
    {class} property OaepSHA1: DNRSAEncryptionPadding read get_OaepSHA1;
    {class} property OaepSHA256: DNRSAEncryptionPadding read get_OaepSHA256;
    {class} property OaepSHA384: DNRSAEncryptionPadding read get_OaepSHA384;
    {class} property OaepSHA512: DNRSAEncryptionPadding read get_OaepSHA512;
  end;

  [DNTypeName('System.Security.Cryptography.RSAEncryptionPadding')]
  DNRSAEncryptionPadding = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FAC810D1-A92E-3681-B13C-91E707ECE647}']
  { getters & setters } 

    function get_Mode: DNRSAEncryptionPaddingMode;
    function get_OaepHashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNRSAEncryptionPadding): Boolean; overload;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Mode: DNRSAEncryptionPaddingMode read get_Mode;
    property OaepHashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_OaepHashAlgorithm;
  end;

  TDNRSAEncryptionPadding = class(TDNGenericImport<DNRSAEncryptionPaddingClass, DNRSAEncryptionPadding>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSASignaturePaddingClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{85D10F6B-78D0-53E6-87C5-863AD29C99BC}']
  { static getter & setter } 

    {class} function get_Pkcs1: DNRSASignaturePadding;
    {class} function get_Pss: DNRSASignaturePadding;

  { static propertys } 

    {class} property Pkcs1: DNRSASignaturePadding read get_Pkcs1;
    {class} property Pss: DNRSASignaturePadding read get_Pss;
  end;

  [DNTypeName('System.Security.Cryptography.RSASignaturePadding')]
  DNRSASignaturePadding = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{16F3F866-E855-34C1-8015-684C790893CE}']
  { getters & setters } 

    function get_Mode: DNRSASignaturePaddingMode;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNRSASignaturePadding): Boolean; overload;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Mode: DNRSASignaturePaddingMode read get_Mode;
  end;

  TDNRSASignaturePadding = class(TDNGenericImport<DNRSASignaturePaddingClass, DNRSASignaturePadding>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSignatureDescriptionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0CE4D1B9-854E-5532-9BF6-464242757706}']
  { constructors } 

    {class} function init: DNSignatureDescription; overload;
    {class} function init(el: DDNC.System.Private.CoreLib.DNSecurityElement): DNSignatureDescription; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SignatureDescription')]
  DNSignatureDescription = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F6BB3838-C5C8-32A3-B4AD-0048F189FACB}']
  { getters & setters } 

    function get_KeyAlgorithm: string;
    procedure set_KeyAlgorithm(value: string);
    function get_DigestAlgorithm: string;
    procedure set_DigestAlgorithm(value: string);
    function get_FormatterAlgorithm: string;
    procedure set_FormatterAlgorithm(value: string);
    function get_DeformatterAlgorithm: string;
    procedure set_DeformatterAlgorithm(value: string);

  { methods } 

    function CreateDeformatter(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNAsymmetricSignatureDeformatter;
    function CreateFormatter(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNAsymmetricSignatureFormatter;
    function CreateDigest: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeyAlgorithm: string read get_KeyAlgorithm write set_KeyAlgorithm;
    property DigestAlgorithm: string read get_DigestAlgorithm write set_DigestAlgorithm;
    property FormatterAlgorithm: string read get_FormatterAlgorithm write set_FormatterAlgorithm;
    property DeformatterAlgorithm: string read get_DeformatterAlgorithm write set_DeformatterAlgorithm;
  end;

  TDNSignatureDescription = class(TDNGenericImport<DNSignatureDescriptionClass, DNSignatureDescription>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesClass = interface(DNObjectClass)
  ['{45A119AA-5C89-5633-8564-7B6F50DAC99E}']
  { static methods } 

    {class} function Create: DNAes; overload;
    {class} function Create(algorithmName: string): DNAes; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Aes')]
  DNAes = interface(DNObject)
  ['{DBEB7233-260F-34C2-9724-8D55B438F67B}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNAes = class(TDNGenericImport<DNAesClass, DNAes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesManagedClass = interface(DNAesClass)
  ['{9A2E12F9-5124-508A-BED6-2119BE76D334}']
  { constructors } 

    {class} function init: DNAesManaged;

  end;

  [DNTypeName('System.Security.Cryptography.AesManaged')]
  DNAesManaged = interface(DNAes)
  ['{01E013CE-0494-3AB8-96D4-3AE8DB36B067}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNAesManaged = class(TDNGenericImport<DNAesManagedClass, DNAesManaged>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDESClass = interface(DNObjectClass)
  ['{AC99DFA9-E0F3-593C-804B-D6BF7323CF24}']
  { static methods } 

    {class} function Create: DNDES; overload;
    {class} function Create(algName: string): DNDES; overload;
    {class} function IsWeakKey(rgbKey: TArray<Byte>): Boolean;
    {class} function IsSemiWeakKey(rgbKey: TArray<Byte>): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.DES')]
  DNDES = interface(DNObject)
  ['{5ABAEF12-63FB-3F63-B49A-05A9E3273B1B}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNDES = class(TDNGenericImport<DNDESClass, DNDES>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRC2Class = interface(DNObjectClass)
  ['{627DA76E-2BBB-5ECB-B5D6-D297650608E1}']
  { static methods } 

    {class} function Create: DNRC2; overload;
    {class} function Create(AlgName: string): DNRC2; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RC2')]
  DNRC2 = interface(DNObject)
  ['{08D0CC8D-E364-3A88-A65A-7E743D9BA429}']
  { getters & setters } 

    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_EffectiveKeySize: Int32;
    procedure set_EffectiveKeySize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeySize: Int32 read get_KeySize write set_KeySize;
    property EffectiveKeySize: Int32 read get_EffectiveKeySize write set_EffectiveKeySize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNRC2 = class(TDNGenericImport<DNRC2Class, DNRC2>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRijndaelClass = interface(DNObjectClass)
  ['{BB198AE7-FA17-5841-82C2-52EA882FB9B1}']
  { static methods } 

    {class} function Create: DNRijndael; overload;
    {class} function Create(algName: string): DNRijndael; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Rijndael')]
  DNRijndael = interface(DNObject)
  ['{562B6885-78B2-3914-A077-122BC805C737}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNRijndael = class(TDNGenericImport<DNRijndaelClass, DNRijndael>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRijndaelManagedClass = interface(DNRijndaelClass)
  ['{1220080E-C6CC-5AB5-B850-5A55AE608C3A}']
  { constructors } 

    {class} function init: DNRijndaelManaged;

  end;

  [DNTypeName('System.Security.Cryptography.RijndaelManaged')]
  DNRijndaelManaged = interface(DNRijndael)
  ['{7BFC7D44-DCE7-363D-8E79-4008860916E8}']
  { getters & setters } 

    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
  end;

  TDNRijndaelManaged = class(TDNGenericImport<DNRijndaelManagedClass, DNRijndaelManaged>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNTripleDESClass = interface(DNObjectClass)
  ['{647CC37F-D8C4-5FA1-9C61-75136785161F}']
  { static methods } 

    {class} function Create: DNTripleDES; overload;
    {class} function Create(str: string): DNTripleDES; overload;
    {class} function IsWeakKey(rgbKey: TArray<Byte>): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.TripleDES')]
  DNTripleDES = interface(DNObject)
  ['{DDB3A542-A9DA-30EE-AD14-F0756DC99FDF}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNTripleDES = class(TDNGenericImport<DNTripleDESClass, DNTripleDES>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSAParametersClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{1C342F5E-D221-5171-994D-BC8B654F8986}']
  end;

  [DNTypeName('System.Security.Cryptography.DSAParameters')]
  DNDSAParameters = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{57BBD508-5A25-3DEF-924B-69DFFA5E1ABF}']
  { fields getter & setter } 

   function __fakeFieldGet_P: TArray<Byte>;
   procedure __fakeFieldSet_P(value: TArray<Byte>);
   function __fakeFieldGet_Q: TArray<Byte>;
   procedure __fakeFieldSet_Q(value: TArray<Byte>);
   function __fakeFieldGet_G: TArray<Byte>;
   procedure __fakeFieldSet_G(value: TArray<Byte>);
   function __fakeFieldGet_Y: TArray<Byte>;
   procedure __fakeFieldSet_Y(value: TArray<Byte>);
   function __fakeFieldGet_J: TArray<Byte>;
   procedure __fakeFieldSet_J(value: TArray<Byte>);
   function __fakeFieldGet_X: TArray<Byte>;
   procedure __fakeFieldSet_X(value: TArray<Byte>);
   function __fakeFieldGet_Seed: TArray<Byte>;
   procedure __fakeFieldSet_Seed(value: TArray<Byte>);
   function __fakeFieldGet_Counter: Int32;
   procedure __fakeFieldSet_Counter(value: Int32);

  { fields } 

   property P: TArray<Byte> read __fakeFieldGet_P write __fakeFieldSet_P;
   property Q: TArray<Byte> read __fakeFieldGet_Q write __fakeFieldSet_Q;
   property G: TArray<Byte> read __fakeFieldGet_G write __fakeFieldSet_G;
   property Y: TArray<Byte> read __fakeFieldGet_Y write __fakeFieldSet_Y;
   property J: TArray<Byte> read __fakeFieldGet_J write __fakeFieldSet_J;
   property X: TArray<Byte> read __fakeFieldGet_X write __fakeFieldSet_X;
   property Seed: TArray<Byte> read __fakeFieldGet_Seed write __fakeFieldSet_Seed;
   property Counter: Int32 read __fakeFieldGet_Counter write __fakeFieldSet_Counter;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNDSAParameters = class(TDNGenericImport<DNDSAParametersClass, DNDSAParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECCurveClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{13C25428-40F4-545A-A25F-04159878D944}']
  { static methods } 

    {class} function CreateFromOid(curveOid: DDNC.System.Security.Cryptography.Encoding.DNOid): DNECCurve;
    {class} function CreateFromFriendlyName(oidFriendlyName: string): DNECCurve;
    {class} function CreateFromValue(oidValue: string): DNECCurve;

  end;

  [DNTypeName('System.Security.Cryptography.ECCurve')]
  DNECCurve = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{06735635-D053-39EB-8A05-B70531D0B642}']
  { getters & setters } 

    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;
    function get_IsPrime: Boolean;
    function get_IsCharacteristic2: Boolean;
    function get_IsExplicit: Boolean;
    function get_IsNamed: Boolean;

  { fields getter & setter } 

   function __fakeFieldGet_A: TArray<Byte>;
   procedure __fakeFieldSet_A(value: TArray<Byte>);
   function __fakeFieldGet_B: TArray<Byte>;
   procedure __fakeFieldSet_B(value: TArray<Byte>);
   function __fakeFieldGet_G: DNECPoint;
   procedure __fakeFieldSet_G(value: DNECPoint);
   function __fakeFieldGet_Order: TArray<Byte>;
   procedure __fakeFieldSet_Order(value: TArray<Byte>);
   function __fakeFieldGet_Cofactor: TArray<Byte>;
   procedure __fakeFieldSet_Cofactor(value: TArray<Byte>);
   function __fakeFieldGet_Seed: TArray<Byte>;
   procedure __fakeFieldSet_Seed(value: TArray<Byte>);
   function __fakeFieldGet_CurveType: DNECCurve_ECCurveType;
   procedure __fakeFieldSet_CurveType(value: DNECCurve_ECCurveType);
   function __fakeFieldGet_Hash: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName>;
   procedure __fakeFieldSet_Hash(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName>);
   function __fakeFieldGet_Polynomial: TArray<Byte>;
   procedure __fakeFieldSet_Polynomial(value: TArray<Byte>);
   function __fakeFieldGet_Prime: TArray<Byte>;
   procedure __fakeFieldSet_Prime(value: TArray<Byte>);

  { fields } 

   property A: TArray<Byte> read __fakeFieldGet_A write __fakeFieldSet_A;
   property B: TArray<Byte> read __fakeFieldGet_B write __fakeFieldSet_B;
   property G: DNECPoint read __fakeFieldGet_G write __fakeFieldSet_G;
   property Order: TArray<Byte> read __fakeFieldGet_Order write __fakeFieldSet_Order;
   property Cofactor: TArray<Byte> read __fakeFieldGet_Cofactor write __fakeFieldSet_Cofactor;
   property Seed: TArray<Byte> read __fakeFieldGet_Seed write __fakeFieldSet_Seed;
   property CurveType: DNECCurve_ECCurveType read __fakeFieldGet_CurveType write __fakeFieldSet_CurveType;
   property Hash: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName> read __fakeFieldGet_Hash write __fakeFieldSet_Hash;
   property Polynomial: TArray<Byte> read __fakeFieldGet_Polynomial write __fakeFieldSet_Polynomial;
   property Prime: TArray<Byte> read __fakeFieldGet_Prime write __fakeFieldSet_Prime;

  { methods } 

    procedure Validate;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid;
    property IsPrime: Boolean read get_IsPrime;
    property IsCharacteristic2: Boolean read get_IsCharacteristic2;
    property IsExplicit: Boolean read get_IsExplicit;
    property IsNamed: Boolean read get_IsNamed;
  end;

  TDNECCurve = class(TDNGenericImport<DNECCurveClass, DNECCurve>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECParametersClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{13B6E63A-734A-5486-A2DA-FCB76C16984E}']
  end;

  [DNTypeName('System.Security.Cryptography.ECParameters')]
  DNECParameters = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{F4701172-58F5-3FDF-8230-3E186FF27D38}']
  { fields getter & setter } 

   function __fakeFieldGet_Q: DNECPoint;
   procedure __fakeFieldSet_Q(value: DNECPoint);
   function __fakeFieldGet_D: TArray<Byte>;
   procedure __fakeFieldSet_D(value: TArray<Byte>);
   function __fakeFieldGet_Curve: DNECCurve;
   procedure __fakeFieldSet_Curve(value: DNECCurve);

  { fields } 

   property Q: DNECPoint read __fakeFieldGet_Q write __fakeFieldSet_Q;
   property D: TArray<Byte> read __fakeFieldGet_D write __fakeFieldSet_D;
   property Curve: DNECCurve read __fakeFieldGet_Curve write __fakeFieldSet_Curve;

  { methods } 

    procedure Validate;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNECParameters = class(TDNGenericImport<DNECParametersClass, DNECParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECPointClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{B45DAA0E-584B-5415-9E7D-7E7C4C0BEDB0}']
  end;

  [DNTypeName('System.Security.Cryptography.ECPoint')]
  DNECPoint = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{025835A1-2A19-3A3D-8B02-72D4C8D411D5}']
  { fields getter & setter } 

   function __fakeFieldGet_X: TArray<Byte>;
   procedure __fakeFieldSet_X(value: TArray<Byte>);
   function __fakeFieldGet_Y: TArray<Byte>;
   procedure __fakeFieldSet_Y(value: TArray<Byte>);

  { fields } 

   property X: TArray<Byte> read __fakeFieldGet_X write __fakeFieldSet_X;
   property Y: TArray<Byte> read __fakeFieldGet_Y write __fakeFieldSet_Y;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNECPoint = class(TDNGenericImport<DNECPointClass, DNECPoint>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAParametersClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{F8253350-FE10-5EF7-9204-2137DCC3E9A4}']
  end;

  [DNTypeName('System.Security.Cryptography.RSAParameters')]
  DNRSAParameters = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{B68879F5-516F-3CAF-9213-54834BBE8CD5}']
  { fields getter & setter } 

   function __fakeFieldGet_D: TArray<Byte>;
   procedure __fakeFieldSet_D(value: TArray<Byte>);
   function __fakeFieldGet_DP: TArray<Byte>;
   procedure __fakeFieldSet_DP(value: TArray<Byte>);
   function __fakeFieldGet_DQ: TArray<Byte>;
   procedure __fakeFieldSet_DQ(value: TArray<Byte>);
   function __fakeFieldGet_Exponent: TArray<Byte>;
   procedure __fakeFieldSet_Exponent(value: TArray<Byte>);
   function __fakeFieldGet_InverseQ: TArray<Byte>;
   procedure __fakeFieldSet_InverseQ(value: TArray<Byte>);
   function __fakeFieldGet_Modulus: TArray<Byte>;
   procedure __fakeFieldSet_Modulus(value: TArray<Byte>);
   function __fakeFieldGet_P: TArray<Byte>;
   procedure __fakeFieldSet_P(value: TArray<Byte>);
   function __fakeFieldGet_Q: TArray<Byte>;
   procedure __fakeFieldSet_Q(value: TArray<Byte>);

  { fields } 

   property D: TArray<Byte> read __fakeFieldGet_D write __fakeFieldSet_D;
   property DP: TArray<Byte> read __fakeFieldGet_DP write __fakeFieldSet_DP;
   property DQ: TArray<Byte> read __fakeFieldGet_DQ write __fakeFieldSet_DQ;
   property Exponent: TArray<Byte> read __fakeFieldGet_Exponent write __fakeFieldSet_Exponent;
   property InverseQ: TArray<Byte> read __fakeFieldGet_InverseQ write __fakeFieldSet_InverseQ;
   property Modulus: TArray<Byte> read __fakeFieldGet_Modulus write __fakeFieldSet_Modulus;
   property P: TArray<Byte> read __fakeFieldGet_P write __fakeFieldSet_P;
   property Q: TArray<Byte> read __fakeFieldGet_Q write __fakeFieldSet_Q;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRSAParameters = class(TDNGenericImport<DNRSAParametersClass, DNRSAParameters>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.Algorithms, Version=4.3.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
