//----------------------------------------------------------------------------
//  System.Security.AccessControl.dll: System.Security.AccessControl, Version=4.1.3.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.AccessControl
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.AccessControl;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Collections.NonGeneric,
  DDNC.System.Security.Principal.Windows;

type

{ enums }

  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AccessControlActions')]
  DNAccessControlActions = type Integer;
  DNAccessControlActionsHelper = record helper for DNAccessControlActions
  public const
    None = 0;
    View = 1;
    Change = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AccessControlModification')]
  DNAccessControlModification = type Integer;
  DNAccessControlModificationHelper = record helper for DNAccessControlModification
  public const
    Add = 0;
    Set_ = 1;
    Reset = 2;
    Remove = 3;
    RemoveAll = 4;
    RemoveSpecific = 5;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AccessControlSections')]
  DNAccessControlSections = type Integer;
  DNAccessControlSectionsHelper = record helper for DNAccessControlSections
  public const
    None = 0;
    Audit = 1;
    Access = 2;
    Owner = 4;
    Group = 8;
    All = 15;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AccessControlType')]
  DNAccessControlType = type Integer;
  DNAccessControlTypeHelper = record helper for DNAccessControlType
  public const
    Allow = 0;
    Deny = 1;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AceFlags')]
  DNAceFlags = type Integer;
  DNAceFlagsHelper = record helper for DNAceFlags
  public const
    None = 0;
    ObjectInherit = 1;
    ContainerInherit = 2;
    NoPropagateInherit = 4;
    InheritOnly = 8;
    InheritanceFlags = 15;
    Inherited_ = 16;
    SuccessfulAccess = 64;
    FailedAccess = 128;
    AuditFlags = 192;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AceQualifier')]
  DNAceQualifier = type Integer;
  DNAceQualifierHelper = record helper for DNAceQualifier
  public const
    AccessAllowed = 0;
    AccessDenied = 1;
    SystemAudit = 2;
    SystemAlarm = 3;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AceType')]
  DNAceType = type Integer;
  DNAceTypeHelper = record helper for DNAceType
  public const
    AccessAllowed = 0;
    AccessDenied = 1;
    SystemAudit = 2;
    SystemAlarm = 3;
    AccessAllowedCompound = 4;
    AccessAllowedObject = 5;
    AccessDeniedObject = 6;
    SystemAuditObject = 7;
    SystemAlarmObject = 8;
    AccessAllowedCallback = 9;
    AccessDeniedCallback = 10;
    AccessAllowedCallbackObject = 11;
    AccessDeniedCallbackObject = 12;
    SystemAuditCallback = 13;
    SystemAlarmCallback = 14;
    SystemAuditCallbackObject = 15;
    SystemAlarmCallbackObject = 16;
    MaxDefinedAceType = 16;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AuditFlags')]
  DNAuditFlags = type Integer;
  DNAuditFlagsHelper = record helper for DNAuditFlags
  public const
    None = 0;
    Success = 1;
    Failure = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.CompoundAceType')]
  DNCompoundAceType = type Integer;
  DNCompoundAceTypeHelper = record helper for DNCompoundAceType
  public const
    Impersonation = 1;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.ControlFlags')]
  DNControlFlags = type Integer;
  DNControlFlagsHelper = record helper for DNControlFlags
  public const
    None = 0;
    OwnerDefaulted = 1;
    GroupDefaulted = 2;
    DiscretionaryAclPresent = 4;
    DiscretionaryAclDefaulted = 8;
    SystemAclPresent = 16;
    SystemAclDefaulted = 32;
    DiscretionaryAclUntrusted = 64;
    ServerSecurity = 128;
    DiscretionaryAclAutoInheritRequired = 256;
    SystemAclAutoInheritRequired = 512;
    DiscretionaryAclAutoInherited = 1024;
    SystemAclAutoInherited = 2048;
    DiscretionaryAclProtected = 4096;
    SystemAclProtected = 8192;
    RMControlValid = 16384;
    SelfRelative = 32768;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.InheritanceFlags')]
  DNInheritanceFlags = type Integer;
  DNInheritanceFlagsHelper = record helper for DNInheritanceFlags
  public const
    None = 0;
    ContainerInherit = 1;
    ObjectInherit = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.ObjectAceFlags')]
  DNObjectAceFlags = type Integer;
  DNObjectAceFlagsHelper = record helper for DNObjectAceFlags
  public const
    None = 0;
    ObjectAceTypePresent = 1;
    InheritedObjectAceTypePresent = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.PropagationFlags')]
  DNPropagationFlags = type Integer;
  DNPropagationFlagsHelper = record helper for DNPropagationFlags
  public const
    None = 0;
    NoPropagateInherit = 1;
    InheritOnly = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.ResourceType')]
  DNResourceType = type Integer;
  DNResourceTypeHelper = record helper for DNResourceType
  public const
    Unknown = 0;
    FileObject = 1;
    Service = 2;
    Printer = 3;
    RegistryKey = 4;
    LMShare = 5;
    KernelObject = 6;
    WindowObject = 7;
    DSObject = 8;
    DSObjectAll = 9;
    ProviderDefined = 10;
    WmiGuidObject = 11;
    RegistryWow6432Key = 12;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.SecurityInfos')]
  DNSecurityInfos = type Integer;
  DNSecurityInfosHelper = record helper for DNSecurityInfos
  public const
    Owner = 1;
    Group = 2;
    DiscretionaryAcl = 4;
    SystemAcl = 8;
  end;




type


{ declares }

  DNAuthorizationRuleCollection = interface; // type: System.Security.AccessControl.AuthorizationRuleCollection, namespace: System.Security.AccessControl
  DNPrivilegeNotHeldException = interface; // type: System.Security.AccessControl.PrivilegeNotHeldException, namespace: System.Security.AccessControl
  DNAceEnumerator = interface; // type: System.Security.AccessControl.AceEnumerator, namespace: System.Security.AccessControl
  DNAuthorizationRule = interface; // type: System.Security.AccessControl.AuthorizationRule, namespace: System.Security.AccessControl
  DNAccessRule = interface; // type: System.Security.AccessControl.AccessRule, namespace: System.Security.AccessControl
  DNAccessRule<T> = interface; // type: System.Security.AccessControl.AccessRule`1, namespace: System.Security.AccessControl
  DNObjectAccessRule = interface; // type: System.Security.AccessControl.ObjectAccessRule, namespace: System.Security.AccessControl
  DNAuditRule = interface; // type: System.Security.AccessControl.AuditRule, namespace: System.Security.AccessControl
  DNAuditRule<T> = interface; // type: System.Security.AccessControl.AuditRule`1, namespace: System.Security.AccessControl
  DNObjectAuditRule = interface; // type: System.Security.AccessControl.ObjectAuditRule, namespace: System.Security.AccessControl
  DNGenericAce = interface; // type: System.Security.AccessControl.GenericAce, namespace: System.Security.AccessControl
  DNCustomAce = interface; // type: System.Security.AccessControl.CustomAce, namespace: System.Security.AccessControl
  DNKnownAce = interface; // type: System.Security.AccessControl.KnownAce, namespace: System.Security.AccessControl
  DNCompoundAce = interface; // type: System.Security.AccessControl.CompoundAce, namespace: System.Security.AccessControl
  DNQualifiedAce = interface; // type: System.Security.AccessControl.QualifiedAce, namespace: System.Security.AccessControl
  DNCommonAce = interface; // type: System.Security.AccessControl.CommonAce, namespace: System.Security.AccessControl
  DNObjectAce = interface; // type: System.Security.AccessControl.ObjectAce, namespace: System.Security.AccessControl
  DNGenericAcl = interface; // type: System.Security.AccessControl.GenericAcl, namespace: System.Security.AccessControl
  DNCommonAcl = interface; // type: System.Security.AccessControl.CommonAcl, namespace: System.Security.AccessControl
  DNDiscretionaryAcl = interface; // type: System.Security.AccessControl.DiscretionaryAcl, namespace: System.Security.AccessControl
  DNSystemAcl = interface; // type: System.Security.AccessControl.SystemAcl, namespace: System.Security.AccessControl
  DNRawAcl = interface; // type: System.Security.AccessControl.RawAcl, namespace: System.Security.AccessControl
  DNGenericSecurityDescriptor = interface; // type: System.Security.AccessControl.GenericSecurityDescriptor, namespace: System.Security.AccessControl
  DNCommonSecurityDescriptor = interface; // type: System.Security.AccessControl.CommonSecurityDescriptor, namespace: System.Security.AccessControl
  DNRawSecurityDescriptor = interface; // type: System.Security.AccessControl.RawSecurityDescriptor, namespace: System.Security.AccessControl
  DNObjectSecurity = interface; // type: System.Security.AccessControl.ObjectSecurity, namespace: System.Security.AccessControl
  DNCommonObjectSecurity = interface; // type: System.Security.AccessControl.CommonObjectSecurity, namespace: System.Security.AccessControl
  DNNativeObjectSecurity = interface; // type: System.Security.AccessControl.NativeObjectSecurity, namespace: System.Security.AccessControl
  DNObjectSecurity<T> = interface; // type: System.Security.AccessControl.ObjectSecurity`1, namespace: System.Security.AccessControl


{ objects }

  //-------------namespace: System.Security.AccessControl----------------
  DNAuthorizationRuleCollectionClass = interface(DNObjectClass)
  ['{7D7676BE-D937-5663-8AB8-AB854FC69E3B}']
  { constructors } 

    {class} function init: DNAuthorizationRuleCollection;

  end;

  [DNTypeName('System.Security.AccessControl.AuthorizationRuleCollection')]
  DNAuthorizationRuleCollection = interface(DNObject)
  ['{44F84816-BE1F-35BA-8642-23B82FDA3BAB}']
  { getters & setters } 

    function get_Item(index: Int32): DNAuthorizationRule;
    function get_Count: Int32;

  { methods } 

    procedure AddRule(rule: DNAuthorizationRule);
    procedure CopyTo(rules: TArray<DNAuthorizationRule>; index: Int32);
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Item[index: Int32]: DNAuthorizationRule read get_Item; default;
    property Count: Int32 read get_Count;
  end;

  TDNAuthorizationRuleCollection = class(TDNGenericImport<DNAuthorizationRuleCollectionClass, DNAuthorizationRuleCollection>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNPrivilegeNotHeldExceptionClass = interface(DDNC.System.Private.CoreLib.DNUnauthorizedAccessExceptionClass)
  ['{F82321EC-363B-5D15-9F78-6F1C5D0BB501}']
  { constructors } 

    {class} function init: DNPrivilegeNotHeldException; overload;
    {class} function init(privilege: string): DNPrivilegeNotHeldException; overload;
    {class} function init(privilege: string; inner: DDNC.System.Private.CoreLib.DNException): DNPrivilegeNotHeldException; overload;

  end;

  [DNTypeName('System.Security.AccessControl.PrivilegeNotHeldException')]
  DNPrivilegeNotHeldException = interface(DDNC.System.Private.CoreLib.DNUnauthorizedAccessException)
  ['{B73D6117-AC57-34F9-93EA-1AF60EA6CC67}']
  { getters & setters } 

    function get_PrivilegeName: string;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property PrivilegeName: string read get_PrivilegeName;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNPrivilegeNotHeldException = class(TDNGenericImport<DNPrivilegeNotHeldExceptionClass, DNPrivilegeNotHeldException>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAceEnumeratorClass = interface(DNObjectClass)
  ['{AF63F127-6DE6-51AA-B573-893AD3C675BF}']
  end;

  [DNTypeName('System.Security.AccessControl.AceEnumerator')]
  DNAceEnumerator = interface(DDNC.System.Private.CoreLib.DNIEnumerator)
  ['{052C3A31-35E8-3731-8441-0CEE2240A0BA}']
  { getters & setters } 

    function get_Current: DNGenericAce;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Current: DNGenericAce read get_Current;
  end;

  TDNAceEnumerator = class(TDNGenericImport<DNAceEnumeratorClass, DNAceEnumerator>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAuthorizationRuleClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{D6F67CED-FB25-5146-80DD-A33715CDB104}']
  end;

  [DNTypeName('System.Security.AccessControl.AuthorizationRule')]
  DNAuthorizationRule = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8E5AE22B-D1A0-3AAB-90B0-AEB29A461933}']
  { getters & setters } 

    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAuthorizationRule = class(TDNGenericImport<DNAuthorizationRuleClass, DNAuthorizationRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAccessRuleClass = interface(DNAuthorizationRuleClass)
  ['{28EAAA6F-7BD5-548E-8A03-AAF83D59D082}']
  end;

  [DNTypeName('System.Security.AccessControl.AccessRule')]
  DNAccessRule = interface(DNAuthorizationRule)
  ['{1480937D-9EBA-3563-ABB4-D91CA0B79318}']
  { getters & setters } 

    function get_AccessControlType: DNAccessControlType;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AccessControlType: DNAccessControlType read get_AccessControlType;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAccessRule = class(TDNGenericImport<DNAccessRuleClass, DNAccessRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAccessRuleClass<T> = interface(DNAccessRuleClass)
  ['{F7C50AB3-122F-5689-8F7D-C897146074B1}']
  { constructors } 

    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: T; &type: DNAccessControlType): DNAccessRule<T>; overload;
    {class} function init(identity: string; rights: T; &type: DNAccessControlType): DNAccessRule<T>; overload;
    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: T; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule<T>; overload;
    {class} function init(identity: string; rights: T; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule<T>; overload;

  end;

  [DNTypeName('System.Security.AccessControl.AccessRule`1')]
  DNAccessRule<T> = interface(DNAccessRule)
  ['{2795EEC2-E928-3BB9-A4B5-5C914D3B8DD2}']
  { getters & setters } 

    function get_Rights: T;
    function get_AccessControlType: DNAccessControlType;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Rights: T read get_Rights;
    property AccessControlType: DNAccessControlType read get_AccessControlType;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAccessRule<T> = class(TDNGenericImport<DNAccessRuleClass<T>, DNAccessRule<T>>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectAccessRuleClass = interface(DNAccessRuleClass)
  ['{E51DA547-240F-531C-8C1E-AFA243ACD4D5}']
  end;

  [DNTypeName('System.Security.AccessControl.ObjectAccessRule')]
  DNObjectAccessRule = interface(DNAccessRule)
  ['{98B7EAD0-8107-3CC8-BC06-918C3B0F3C16}']
  { getters & setters } 

    function get_ObjectType: DDNC.System.Private.CoreLib.DNGuid;
    function get_InheritedObjectType: DDNC.System.Private.CoreLib.DNGuid;
    function get_ObjectFlags: DNObjectAceFlags;
    function get_AccessControlType: DNAccessControlType;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ObjectType: DDNC.System.Private.CoreLib.DNGuid read get_ObjectType;
    property InheritedObjectType: DDNC.System.Private.CoreLib.DNGuid read get_InheritedObjectType;
    property ObjectFlags: DNObjectAceFlags read get_ObjectFlags;
    property AccessControlType: DNAccessControlType read get_AccessControlType;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNObjectAccessRule = class(TDNGenericImport<DNObjectAccessRuleClass, DNObjectAccessRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAuditRuleClass = interface(DNAuthorizationRuleClass)
  ['{DD4090C7-8ED0-566E-8E45-22B5C1D47B7D}']
  end;

  [DNTypeName('System.Security.AccessControl.AuditRule')]
  DNAuditRule = interface(DNAuthorizationRule)
  ['{846DDD8D-CFB5-342E-BD38-0089572C6D0E}']
  { getters & setters } 

    function get_AuditFlags: DNAuditFlags;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAuditRule = class(TDNGenericImport<DNAuditRuleClass, DNAuditRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAuditRuleClass<T> = interface(DNAuditRuleClass)
  ['{93BAC8C8-56D6-5899-B525-43D528F10BDA}']
  { constructors } 

    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: T; flags: DNAuditFlags): DNAuditRule<T>; overload;
    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: T; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule<T>; overload;
    {class} function init(identity: string; rights: T; flags: DNAuditFlags): DNAuditRule<T>; overload;
    {class} function init(identity: string; rights: T; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule<T>; overload;

  end;

  [DNTypeName('System.Security.AccessControl.AuditRule`1')]
  DNAuditRule<T> = interface(DNAuditRule)
  ['{A848B87E-A3A6-30E2-886B-1D33EED1D5FB}']
  { getters & setters } 

    function get_Rights: T;
    function get_AuditFlags: DNAuditFlags;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Rights: T read get_Rights;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAuditRule<T> = class(TDNGenericImport<DNAuditRuleClass<T>, DNAuditRule<T>>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectAuditRuleClass = interface(DNAuditRuleClass)
  ['{5A016817-EFBD-5745-BD63-993D2119A9CA}']
  end;

  [DNTypeName('System.Security.AccessControl.ObjectAuditRule')]
  DNObjectAuditRule = interface(DNAuditRule)
  ['{C0AD21A3-4055-3013-8F29-5A01E0516A5F}']
  { getters & setters } 

    function get_ObjectType: DDNC.System.Private.CoreLib.DNGuid;
    function get_InheritedObjectType: DDNC.System.Private.CoreLib.DNGuid;
    function get_ObjectFlags: DNObjectAceFlags;
    function get_AuditFlags: DNAuditFlags;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ObjectType: DDNC.System.Private.CoreLib.DNGuid read get_ObjectType;
    property InheritedObjectType: DDNC.System.Private.CoreLib.DNGuid read get_InheritedObjectType;
    property ObjectFlags: DNObjectAceFlags read get_ObjectFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNObjectAuditRule = class(TDNGenericImport<DNObjectAuditRuleClass, DNObjectAuditRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNGenericAceClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{B541261B-BF64-5FFA-9D00-A35B3031182B}']
  { static methods } 

    {class} function CreateFromBinaryForm(binaryForm: TArray<Byte>; offset: Int32): DNGenericAce;

  end;

  [DNTypeName('System.Security.AccessControl.GenericAce')]
  DNGenericAce = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{DDB945BE-A1D9-30A7-AF78-2B198E766AE0}']
  { getters & setters } 

    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;
    function get_BinaryLength: Int32;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNGenericAce = class(TDNGenericImport<DNGenericAceClass, DNGenericAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCustomAceClass = interface(DNGenericAceClass)
  ['{2E778C9F-32C5-59E2-9B45-06AC45DDEDC4}']
  { constructors } 

    {class} function init(&type: DNAceType; flags: DNAceFlags; opaque: TArray<Byte>): DNCustomAce;

  { static fields getter & setter } 

   function __fakeFieldGet_MaxOpaqueLength: Int32;

  { static fields } 

    {class} property MaxOpaqueLength: Int32 read __fakeFieldGet_MaxOpaqueLength;

  end;

  [DNTypeName('System.Security.AccessControl.CustomAce')]
  DNCustomAce = interface(DNGenericAce)
  ['{3E34FD1D-9DB9-3790-B1AF-236DC30A6CB4}']
  { getters & setters } 

    function get_OpaqueLength: Int32;
    function get_BinaryLength: Int32;
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;

  { methods } 

    function GetOpaque: TArray<Byte>;
    procedure SetOpaque(opaque: TArray<Byte>);
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property OpaqueLength: Int32 read get_OpaqueLength;
    property BinaryLength: Int32 read get_BinaryLength;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
  end;

  TDNCustomAce = class(TDNGenericImport<DNCustomAceClass, DNCustomAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNKnownAceClass = interface(DNGenericAceClass)
  ['{A59110A0-7CD4-5EDD-A51A-D94E61779A14}']
  end;

  [DNTypeName('System.Security.AccessControl.KnownAce')]
  DNKnownAce = interface(DNGenericAce)
  ['{415DA461-65B9-3C78-BF7E-7CC6B41A7807}']
  { getters & setters } 

    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;
    function get_BinaryLength: Int32;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNKnownAce = class(TDNGenericImport<DNKnownAceClass, DNKnownAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCompoundAceClass = interface(DNKnownAceClass)
  ['{699AF7F8-8DBE-5E67-A1C9-974EE94C2432}']
  { constructors } 

    {class} function init(flags: DNAceFlags; accessMask: Int32; compoundAceType: DNCompoundAceType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier): DNCompoundAce;

  end;

  [DNTypeName('System.Security.AccessControl.CompoundAce')]
  DNCompoundAce = interface(DNKnownAce)
  ['{CF3475E6-29CB-35D9-B5E1-2147D033D7C5}']
  { getters & setters } 

    function get_CompoundAceType: DNCompoundAceType;
    procedure set_CompoundAceType(value: DNCompoundAceType);
    function get_BinaryLength: Int32;
    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property CompoundAceType: DNCompoundAceType read get_CompoundAceType write set_CompoundAceType;
    property BinaryLength: Int32 read get_BinaryLength;
    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
  end;

  TDNCompoundAce = class(TDNGenericImport<DNCompoundAceClass, DNCompoundAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNQualifiedAceClass = interface(DNKnownAceClass)
  ['{C6A5321E-9BD4-5A34-B807-D75FE58B4405}']
  end;

  [DNTypeName('System.Security.AccessControl.QualifiedAce')]
  DNQualifiedAce = interface(DNKnownAce)
  ['{D92DA26F-4026-38DC-B915-D631B3F5F3A4}']
  { getters & setters } 

    function get_AceQualifier: DNAceQualifier;
    function get_IsCallback: Boolean;
    function get_OpaqueLength: Int32;
    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;
    function get_BinaryLength: Int32;

  { methods } 

    function GetOpaque: TArray<Byte>;
    procedure SetOpaque(opaque: TArray<Byte>);
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property AceQualifier: DNAceQualifier read get_AceQualifier;
    property IsCallback: Boolean read get_IsCallback;
    property OpaqueLength: Int32 read get_OpaqueLength;
    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNQualifiedAce = class(TDNGenericImport<DNQualifiedAceClass, DNQualifiedAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCommonAceClass = interface(DNQualifiedAceClass)
  ['{B46D24A0-5264-5C22-A95D-9E7BC39ADCF3}']
  { constructors } 

    {class} function init(flags: DNAceFlags; qualifier: DNAceQualifier; accessMask: Int32; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; isCallback: Boolean; opaque: TArray<Byte>): DNCommonAce;

  { static methods } 

    {class} function MaxOpaqueLength(isCallback: Boolean): Int32;

  end;

  [DNTypeName('System.Security.AccessControl.CommonAce')]
  DNCommonAce = interface(DNQualifiedAce)
  ['{F269D0FA-C99D-398E-97DF-48C81993DD7E}']
  { getters & setters } 

    function get_BinaryLength: Int32;
    function get_AceQualifier: DNAceQualifier;
    function get_IsCallback: Boolean;
    function get_OpaqueLength: Int32;
    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetOpaque: TArray<Byte>;
    procedure SetOpaque(opaque: TArray<Byte>);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property BinaryLength: Int32 read get_BinaryLength;
    property AceQualifier: DNAceQualifier read get_AceQualifier;
    property IsCallback: Boolean read get_IsCallback;
    property OpaqueLength: Int32 read get_OpaqueLength;
    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
  end;

  TDNCommonAce = class(TDNGenericImport<DNCommonAceClass, DNCommonAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectAceClass = interface(DNQualifiedAceClass)
  ['{04560F06-026A-5511-A385-15C185139BAF}']
  { constructors } 

    {class} function init(aceFlags: DNAceFlags; qualifier: DNAceQualifier; accessMask: Int32; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; flags: DNObjectAceFlags; &type: DDNC.System.Private.CoreLib.DNGuid; inheritedType: DDNC.System.Private.CoreLib.DNGuid; isCallback: Boolean; opaque: TArray<Byte>): DNObjectAce;

  { static methods } 

    {class} function MaxOpaqueLength(isCallback: Boolean): Int32;

  end;

  [DNTypeName('System.Security.AccessControl.ObjectAce')]
  DNObjectAce = interface(DNQualifiedAce)
  ['{8E8BB1C1-323E-35AB-A635-51B0E18A0C3F}']
  { getters & setters } 

    function get_ObjectAceFlags: DNObjectAceFlags;
    procedure set_ObjectAceFlags(value: DNObjectAceFlags);
    function get_ObjectAceType: DDNC.System.Private.CoreLib.DNGuid;
    procedure set_ObjectAceType(value: DDNC.System.Private.CoreLib.DNGuid);
    function get_InheritedObjectAceType: DDNC.System.Private.CoreLib.DNGuid;
    procedure set_InheritedObjectAceType(value: DDNC.System.Private.CoreLib.DNGuid);
    function get_BinaryLength: Int32;
    function get_AceQualifier: DNAceQualifier;
    function get_IsCallback: Boolean;
    function get_OpaqueLength: Int32;
    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetOpaque: TArray<Byte>;
    procedure SetOpaque(opaque: TArray<Byte>);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property ObjectAceFlags: DNObjectAceFlags read get_ObjectAceFlags write set_ObjectAceFlags;
    property ObjectAceType: DDNC.System.Private.CoreLib.DNGuid read get_ObjectAceType write set_ObjectAceType;
    property InheritedObjectAceType: DDNC.System.Private.CoreLib.DNGuid read get_InheritedObjectAceType write set_InheritedObjectAceType;
    property BinaryLength: Int32 read get_BinaryLength;
    property AceQualifier: DNAceQualifier read get_AceQualifier;
    property IsCallback: Boolean read get_IsCallback;
    property OpaqueLength: Int32 read get_OpaqueLength;
    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
  end;

  TDNObjectAce = class(TDNGenericImport<DNObjectAceClass, DNObjectAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNGenericAclClass = interface(DNObjectClass)
  ['{7B80CF26-07C4-56AB-B0FB-53EC4C0514FE}']
  { static fields getter & setter } 

   function __fakeFieldGet_AclRevision: Byte;
   function __fakeFieldGet_AclRevisionDS: Byte;
   function __fakeFieldGet_MaxBinaryLength: Int32;

  { static fields } 

    {class} property AclRevision: Byte read __fakeFieldGet_AclRevision;
    {class} property AclRevisionDS: Byte read __fakeFieldGet_AclRevisionDS;
    {class} property MaxBinaryLength: Int32 read __fakeFieldGet_MaxBinaryLength;

  end;

  [DNTypeName('System.Security.AccessControl.GenericAcl')]
  DNGenericAcl = interface(DDNC.System.Private.CoreLib.DNICollection)
  ['{E5E5E644-2D58-3B43-AD9E-AAB3CE7CEC13}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_BinaryLength: Int32;
    function get_Item(index: Int32): DNGenericAce;
    procedure set_Item(index: Int32; value: DNGenericAce);
    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property BinaryLength: Int32 read get_BinaryLength;
    property Item[index: Int32]: DNGenericAce read get_Item write set_Item; default;
    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNGenericAcl = class(TDNGenericImport<DNGenericAclClass, DNGenericAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCommonAclClass = interface(DNGenericAclClass)
  ['{6CE256D1-152B-5D72-90BC-19B9479D02A7}']
  end;

  [DNTypeName('System.Security.AccessControl.CommonAcl')]
  DNCommonAcl = interface(DNGenericAcl)
  ['{5075F9E1-4129-3CF1-937E-61589383B605}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_Count: Int32;
    function get_BinaryLength: Int32;
    function get_IsCanonical: Boolean;
    function get_IsContainer: Boolean;
    function get_IsDS: Boolean;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure RemoveInheritedAces;
    procedure Purge(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property Count: Int32 read get_Count;
    property BinaryLength: Int32 read get_BinaryLength;
    property IsCanonical: Boolean read get_IsCanonical;
    property IsContainer: Boolean read get_IsContainer;
    property IsDS: Boolean read get_IsDS;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNCommonAcl = class(TDNGenericImport<DNCommonAclClass, DNCommonAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNDiscretionaryAclClass = interface(DNCommonAclClass)
  ['{56AA9C73-5998-53D7-B20B-7803FF9096C6}']
  { constructors } 

    {class} function init(isContainer: Boolean; isDS: Boolean; capacity: Int32): DNDiscretionaryAcl; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; revision: Byte; capacity: Int32): DNDiscretionaryAcl; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; rawAcl: DNRawAcl): DNDiscretionaryAcl; overload;

  end;

  [DNTypeName('System.Security.AccessControl.DiscretionaryAcl')]
  DNDiscretionaryAcl = interface(DNCommonAcl)
  ['{F434466E-AEC1-3D79-8CC9-344DEFCDF689}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_Count: Int32;
    function get_BinaryLength: Int32;
    function get_IsCanonical: Boolean;
    function get_IsContainer: Boolean;
    function get_IsDS: Boolean;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure AddAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    procedure SetAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    function RemoveAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags): Boolean; overload;
    procedure RemoveAccessSpecific(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    procedure AddAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAccessRule); overload;
    procedure AddAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    procedure SetAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAccessRule); overload;
    procedure SetAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    function RemoveAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAccessRule): Boolean; overload;
    function RemoveAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    procedure RemoveAccessSpecific(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAccessRule); overload;
    procedure RemoveAccessSpecific(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure RemoveInheritedAces;
    procedure Purge(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property Count: Int32 read get_Count;
    property BinaryLength: Int32 read get_BinaryLength;
    property IsCanonical: Boolean read get_IsCanonical;
    property IsContainer: Boolean read get_IsContainer;
    property IsDS: Boolean read get_IsDS;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNDiscretionaryAcl = class(TDNGenericImport<DNDiscretionaryAclClass, DNDiscretionaryAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNSystemAclClass = interface(DNCommonAclClass)
  ['{428F268E-C0ED-590F-B760-D3E5E9EA1470}']
  { constructors } 

    {class} function init(isContainer: Boolean; isDS: Boolean; capacity: Int32): DNSystemAcl; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; revision: Byte; capacity: Int32): DNSystemAcl; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; rawAcl: DNRawAcl): DNSystemAcl; overload;

  end;

  [DNTypeName('System.Security.AccessControl.SystemAcl')]
  DNSystemAcl = interface(DNCommonAcl)
  ['{532686CF-7C37-3F1F-93A7-4C64AACE8774}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_Count: Int32;
    function get_BinaryLength: Int32;
    function get_IsCanonical: Boolean;
    function get_IsContainer: Boolean;
    function get_IsDS: Boolean;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure AddAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    procedure SetAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    function RemoveAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags): Boolean; overload;
    procedure RemoveAuditSpecific(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    procedure AddAudit(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAuditRule); overload;
    procedure AddAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    procedure SetAudit(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAuditRule); overload;
    procedure SetAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    function RemoveAudit(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAuditRule): Boolean; overload;
    function RemoveAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    procedure RemoveAuditSpecific(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAuditRule); overload;
    procedure RemoveAuditSpecific(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure RemoveInheritedAces;
    procedure Purge(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property Count: Int32 read get_Count;
    property BinaryLength: Int32 read get_BinaryLength;
    property IsCanonical: Boolean read get_IsCanonical;
    property IsContainer: Boolean read get_IsContainer;
    property IsDS: Boolean read get_IsDS;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNSystemAcl = class(TDNGenericImport<DNSystemAclClass, DNSystemAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNRawAclClass = interface(DNGenericAclClass)
  ['{CC9F963B-222F-55B4-9C94-AFA85CD194BF}']
  { constructors } 

    {class} function init(revision: Byte; capacity: Int32): DNRawAcl; overload;
    {class} function init(binaryForm: TArray<Byte>; offset: Int32): DNRawAcl; overload;

  end;

  [DNTypeName('System.Security.AccessControl.RawAcl')]
  DNRawAcl = interface(DNGenericAcl)
  ['{62DB7FA6-1B50-3A3F-878F-58F4BE1800F3}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_Count: Int32;
    function get_BinaryLength: Int32;
    function get_Item(index: Int32): DNGenericAce;
    procedure set_Item(index: Int32; value: DNGenericAce);
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure InsertAce(index: Int32; ace: DNGenericAce);
    procedure RemoveAce(index: Int32);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property Count: Int32 read get_Count;
    property BinaryLength: Int32 read get_BinaryLength;
    property Item[index: Int32]: DNGenericAce read get_Item write set_Item; default;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNRawAcl = class(TDNGenericImport<DNRawAclClass, DNRawAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNGenericSecurityDescriptorClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{AD09B080-DA99-5473-BC68-6CC2B1F5D811}']
  { static getter & setter } 

    {class} function get_Revision: Byte;

  { static methods } 

    {class} function IsSddlConversionSupported: Boolean;

  { static propertys } 

    {class} property Revision: Byte read get_Revision;
  end;

  [DNTypeName('System.Security.AccessControl.GenericSecurityDescriptor')]
  DNGenericSecurityDescriptor = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{DC1A009F-6CF6-3F6F-AADF-8F7E13A1C18B}']
  { getters & setters } 

    function get_ControlFlags: DNControlFlags;
    function get_Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Owner(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Group(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_BinaryLength: Int32;

  { methods } 

    function GetSddlForm(includeSections: DNAccessControlSections): string;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ControlFlags: DNControlFlags read get_ControlFlags;
    property Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Owner write set_Owner;
    property Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Group write set_Group;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNGenericSecurityDescriptor = class(TDNGenericImport<DNGenericSecurityDescriptorClass, DNGenericSecurityDescriptor>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCommonSecurityDescriptorClass = interface(DNGenericSecurityDescriptorClass)
  ['{364F95AE-F501-5B98-A8F2-D7E826291CE2}']
  { constructors } 

    {class} function init(isContainer: Boolean; isDS: Boolean; flags: DNControlFlags; owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; systemAcl: DNSystemAcl; discretionaryAcl: DNDiscretionaryAcl): DNCommonSecurityDescriptor; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; rawSecurityDescriptor: DNRawSecurityDescriptor): DNCommonSecurityDescriptor; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; sddlForm: string): DNCommonSecurityDescriptor; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; binaryForm: TArray<Byte>; offset: Int32): DNCommonSecurityDescriptor; overload;

  end;

  [DNTypeName('System.Security.AccessControl.CommonSecurityDescriptor')]
  DNCommonSecurityDescriptor = interface(DNGenericSecurityDescriptor)
  ['{101ED095-9320-340D-8BB5-B926C2DBAFB0}']
  { getters & setters } 

    function get_IsContainer: Boolean;
    function get_IsDS: Boolean;
    function get_ControlFlags: DNControlFlags;
    function get_Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Owner(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Group(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_SystemAcl: DNSystemAcl;
    procedure set_SystemAcl(value: DNSystemAcl);
    function get_DiscretionaryAcl: DNDiscretionaryAcl;
    procedure set_DiscretionaryAcl(value: DNDiscretionaryAcl);
    function get_IsSystemAclCanonical: Boolean;
    function get_IsDiscretionaryAclCanonical: Boolean;
    function get_BinaryLength: Int32;

  { methods } 

    procedure SetSystemAclProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetDiscretionaryAclProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure PurgeAccessControl(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure PurgeAudit(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure AddDiscretionaryAcl(revision: Byte; trusted: Int32);
    procedure AddSystemAcl(revision: Byte; trusted: Int32);
    function GetSddlForm(includeSections: DNAccessControlSections): string;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsContainer: Boolean read get_IsContainer;
    property IsDS: Boolean read get_IsDS;
    property ControlFlags: DNControlFlags read get_ControlFlags;
    property Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Owner write set_Owner;
    property Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Group write set_Group;
    property SystemAcl: DNSystemAcl read get_SystemAcl write set_SystemAcl;
    property DiscretionaryAcl: DNDiscretionaryAcl read get_DiscretionaryAcl write set_DiscretionaryAcl;
    property IsSystemAclCanonical: Boolean read get_IsSystemAclCanonical;
    property IsDiscretionaryAclCanonical: Boolean read get_IsDiscretionaryAclCanonical;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNCommonSecurityDescriptor = class(TDNGenericImport<DNCommonSecurityDescriptorClass, DNCommonSecurityDescriptor>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNRawSecurityDescriptorClass = interface(DNGenericSecurityDescriptorClass)
  ['{5B6EC04F-C163-583C-85B1-7D07F966659B}']
  { constructors } 

    {class} function init(flags: DNControlFlags; owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; systemAcl: DNRawAcl; discretionaryAcl: DNRawAcl): DNRawSecurityDescriptor; overload;
    {class} function init(sddlForm: string): DNRawSecurityDescriptor; overload;
    {class} function init(binaryForm: TArray<Byte>; offset: Int32): DNRawSecurityDescriptor; overload;

  end;

  [DNTypeName('System.Security.AccessControl.RawSecurityDescriptor')]
  DNRawSecurityDescriptor = interface(DNGenericSecurityDescriptor)
  ['{996FE1B9-13AC-37DC-8E1A-15915E588020}']
  { getters & setters } 

    function get_ControlFlags: DNControlFlags;
    function get_Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Owner(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Group(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_SystemAcl: DNRawAcl;
    procedure set_SystemAcl(value: DNRawAcl);
    function get_DiscretionaryAcl: DNRawAcl;
    procedure set_DiscretionaryAcl(value: DNRawAcl);
    function get_ResourceManagerControl: Byte;
    procedure set_ResourceManagerControl(value: Byte);
    function get_BinaryLength: Int32;

  { methods } 

    procedure SetFlags(flags: DNControlFlags);
    function GetSddlForm(includeSections: DNAccessControlSections): string;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ControlFlags: DNControlFlags read get_ControlFlags;
    property Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Owner write set_Owner;
    property Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Group write set_Group;
    property SystemAcl: DNRawAcl read get_SystemAcl write set_SystemAcl;
    property DiscretionaryAcl: DNRawAcl read get_DiscretionaryAcl write set_DiscretionaryAcl;
    property ResourceManagerControl: Byte read get_ResourceManagerControl write set_ResourceManagerControl;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNRawSecurityDescriptor = class(TDNGenericImport<DNRawSecurityDescriptorClass, DNRawSecurityDescriptor>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectSecurityClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{8D106825-84B3-5755-BC92-C66D904704F9}']
  { static methods } 

    {class} function IsSddlConversionSupported: Boolean;

  end;

  [DNTypeName('System.Security.AccessControl.ObjectSecurity')]
  DNObjectSecurity = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{05CCE97D-97C9-38CE-AB4E-C68D9438DA1E}']
  { getters & setters } 

    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;
    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;

  { methods } 

    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DNAccessControlModification; rule: DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DNAccessControlModification; rule: DNAuditRule; out modified: Boolean): Boolean;
    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
  end;

  TDNObjectSecurity = class(TDNGenericImport<DNObjectSecurityClass, DNObjectSecurity>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCommonObjectSecurityClass = interface(DNObjectSecurityClass)
  ['{1A02A5CD-46F9-5D3D-AB6D-59CE5B57EC57}']
  end;

  [DNTypeName('System.Security.AccessControl.CommonObjectSecurity')]
  DNCommonObjectSecurity = interface(DNObjectSecurity)
  ['{472E9F06-BD8F-3D39-8396-C7F5AD1510A8}']
  { getters & setters } 

    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;
    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;

  { methods } 

    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DNAccessControlModification; rule: DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DNAccessControlModification; rule: DNAuditRule; out modified: Boolean): Boolean;
    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
  end;

  TDNCommonObjectSecurity = class(TDNGenericImport<DNCommonObjectSecurityClass, DNCommonObjectSecurity>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNNativeObjectSecurityClass = interface(DNCommonObjectSecurityClass)
  ['{CA10D04D-3343-507E-B643-BED2ACA7F218}']
  end;

  [DNTypeName('System.Security.AccessControl.NativeObjectSecurity')]
  DNNativeObjectSecurity = interface(DNCommonObjectSecurity)
  ['{0636F8D3-2107-3544-B581-D20987F6FF73}']
  { getters & setters } 

    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;
    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;

  { methods } 

    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DNAccessControlModification; rule: DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DNAccessControlModification; rule: DNAuditRule; out modified: Boolean): Boolean;
    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
  end;

  TDNNativeObjectSecurity = class(TDNGenericImport<DNNativeObjectSecurityClass, DNNativeObjectSecurity>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectSecurityClass<T> = interface(DNNativeObjectSecurityClass)
  ['{9BB7AA7F-DD31-521A-89FD-EACEAEA0677A}']
  end;

  [DNTypeName('System.Security.AccessControl.ObjectSecurity`1')]
  DNObjectSecurity<T> = interface(DNNativeObjectSecurity)
  ['{5DB1A5A8-C934-3990-9A8C-9BB5C68240B6}']
  { getters & setters } 

    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;

  { methods } 

    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule;
    procedure AddAccessRule(rule: DNAccessRule<T>);
    procedure SetAccessRule(rule: DNAccessRule<T>);
    procedure ResetAccessRule(rule: DNAccessRule<T>);
    function RemoveAccessRule(rule: DNAccessRule<T>): Boolean;
    procedure RemoveAccessRuleAll(rule: DNAccessRule<T>);
    procedure RemoveAccessRuleSpecific(rule: DNAccessRule<T>);
    procedure AddAuditRule(rule: DNAuditRule<T>);
    procedure SetAuditRule(rule: DNAuditRule<T>);
    function RemoveAuditRule(rule: DNAuditRule<T>): Boolean;
    procedure RemoveAuditRuleAll(rule: DNAuditRule<T>);
    procedure RemoveAuditRuleSpecific(rule: DNAuditRule<T>);
    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DNAccessControlModification; rule: DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DNAccessControlModification; rule: DNAuditRule; out modified: Boolean): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
  end;

  TDNObjectSecurity<T> = class(TDNGenericImport<DNObjectSecurityClass<T>, DNObjectSecurity<T>>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.AccessControl, Version=4.1.3.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
