//----------------------------------------------------------------------------
//  System.Private.Uri.dll: System.Private.Uri, Version=4.0.6.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Private.Uri
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Private.Uri;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type

{ enums }

  //-------------namespace: System----------------
  [DNTypeName('System.GenericUriParserOptions')]
  DNGenericUriParserOptions = type Integer;
  DNGenericUriParserOptionsHelper = record helper for DNGenericUriParserOptions
  public const
    Default_ = 0;
    GenericAuthority = 1;
    AllowEmptyAuthority = 2;
    NoUserInfo = 4;
    NoPort = 8;
    NoQuery = 16;
    NoFragment = 32;
    DontConvertPathBackslashes = 64;
    DontCompressPath = 128;
    DontUnescapePathDotsAndSlashes = 256;
    Idn = 512;
    IriParsing = 1024;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriComponents')]
  DNUriComponents = type Integer;
  DNUriComponentsHelper = record helper for DNUriComponents
  public const
    Scheme = 1;
    UserInfo = 2;
    Host = 4;
    Port = 8;
    SchemeAndServer = 13;
    Path = 16;
    Query = 32;
    PathAndQuery = 48;
    HttpRequestUrl = 61;
    Fragment = 64;
    AbsoluteUri = 127;
    StrongPort = 128;
    HostAndPort = 132;
    StrongAuthority = 134;
    NormalizedHost = 256;
    KeepDelimiter = 1073741824;
    SerializationInfoString = -2147483648;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriFormat')]
  DNUriFormat = type Integer;
  DNUriFormatHelper = record helper for DNUriFormat
  public const
    UriEscaped = 1;
    Unescaped = 2;
    SafeUnescaped = 3;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriHostNameType')]
  DNUriHostNameType = type Integer;
  DNUriHostNameTypeHelper = record helper for DNUriHostNameType
  public const
    Unknown = 0;
    Basic = 1;
    Dns = 2;
    IPv4 = 3;
    IPv6 = 4;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriKind')]
  DNUriKind = type Integer;
  DNUriKindHelper = record helper for DNUriKind
  public const
    RelativeOrAbsolute = 0;
    Absolute_ = 1;
    Relative = 2;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriPartial')]
  DNUriPartial = type Integer;
  DNUriPartialHelper = record helper for DNUriPartial
  public const
    Scheme = 0;
    Authority = 1;
    Path = 2;
    Query = 3;
  end;




type


{ declares }

  DNUriFormatException = interface; // type: System.UriFormatException, namespace: System
  DNUri = interface; // type: System.Uri, namespace: System
  DNUriBuilder = interface; // type: System.UriBuilder, namespace: System
  DNUriParser = interface; // type: System.UriParser, namespace: System
  DNFileStyleUriParser = interface; // type: System.FileStyleUriParser, namespace: System
  DNFtpStyleUriParser = interface; // type: System.FtpStyleUriParser, namespace: System
  DNGenericUriParser = interface; // type: System.GenericUriParser, namespace: System
  DNGopherStyleUriParser = interface; // type: System.GopherStyleUriParser, namespace: System
  DNHttpStyleUriParser = interface; // type: System.HttpStyleUriParser, namespace: System
  DNLdapStyleUriParser = interface; // type: System.LdapStyleUriParser, namespace: System
  DNNetPipeStyleUriParser = interface; // type: System.NetPipeStyleUriParser, namespace: System
  DNNetTcpStyleUriParser = interface; // type: System.NetTcpStyleUriParser, namespace: System
  DNNewsStyleUriParser = interface; // type: System.NewsStyleUriParser, namespace: System


{ objects }

  //-------------namespace: System----------------
  DNUriFormatExceptionClass = interface(DDNC.System.Private.CoreLib.DNFormatExceptionClass)
  ['{FD08AFFB-EA87-5900-8EDF-57C6FFDC6FCE}']
  { constructors } 

    {class} function init: DNUriFormatException; overload;
    {class} function init(textString: string): DNUriFormatException; overload;
    {class} function init(textString: string; e: DDNC.System.Private.CoreLib.DNException): DNUriFormatException; overload;

  end;

  [DNTypeName('System.UriFormatException')]
  DNUriFormatException = interface(DDNC.System.Private.CoreLib.DNFormatException)
  ['{9CE3592D-E519-3144-9BF9-DD3AF3F33709}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNUriFormatException = class(TDNGenericImport<DNUriFormatExceptionClass, DNUriFormatException>) end;

  //-------------namespace: System----------------
  DNUriClass = interface(DNObjectClass)
  ['{F1DB87F2-2764-5658-8725-AACF7DA7389D}']
  { constructors } 

    {class} function init(uriString: string): DNUri; overload;
    {class} function init(uriString: string; dontEscape: Boolean): DNUri; overload;
    {class} function init(baseUri: DNUri; relativeUri: string; dontEscape: Boolean): DNUri; overload;
    {class} function init(uriString: string; uriKind: DNUriKind): DNUri; overload;
    {class} function init(baseUri: DNUri; relativeUri: string): DNUri; overload;
    {class} function init(baseUri: DNUri; relativeUri: DNUri): DNUri; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_UriSchemeFile: string;
   function __fakeFieldGet_UriSchemeFtp: string;
   function __fakeFieldGet_UriSchemeGopher: string;
   function __fakeFieldGet_UriSchemeHttp: string;
   function __fakeFieldGet_UriSchemeHttps: string;
   function __fakeFieldGet_UriSchemeMailto: string;
   function __fakeFieldGet_UriSchemeNews: string;
   function __fakeFieldGet_UriSchemeNntp: string;
   function __fakeFieldGet_UriSchemeNetTcp: string;
   function __fakeFieldGet_UriSchemeNetPipe: string;
   function __fakeFieldGet_SchemeDelimiter: string;

  { static fields } 

    {class} property UriSchemeFile: string read __fakeFieldGet_UriSchemeFile;
    {class} property UriSchemeFtp: string read __fakeFieldGet_UriSchemeFtp;
    {class} property UriSchemeGopher: string read __fakeFieldGet_UriSchemeGopher;
    {class} property UriSchemeHttp: string read __fakeFieldGet_UriSchemeHttp;
    {class} property UriSchemeHttps: string read __fakeFieldGet_UriSchemeHttps;
    {class} property UriSchemeMailto: string read __fakeFieldGet_UriSchemeMailto;
    {class} property UriSchemeNews: string read __fakeFieldGet_UriSchemeNews;
    {class} property UriSchemeNntp: string read __fakeFieldGet_UriSchemeNntp;
    {class} property UriSchemeNetTcp: string read __fakeFieldGet_UriSchemeNetTcp;
    {class} property UriSchemeNetPipe: string read __fakeFieldGet_UriSchemeNetPipe;
    {class} property SchemeDelimiter: string read __fakeFieldGet_SchemeDelimiter;

  { static methods } 

    {class} function TryCreate(uriString: string; uriKind: DNUriKind; out result: DNUri): Boolean; overload;
    {class} function TryCreate(baseUri: DNUri; relativeUri: string; out result: DNUri): Boolean; overload;
    {class} function TryCreate(baseUri: DNUri; relativeUri: DNUri; out result: DNUri): Boolean; overload;
    {class} function Compare(uri1: DNUri; uri2: DNUri; partsToCompare: DNUriComponents; compareFormat: DNUriFormat; comparisonType: DDNC.System.Private.CoreLib.DNStringComparison): Int32;
    {class} function IsWellFormedUriString(uriString: string; uriKind: DNUriKind): Boolean;
    {class} function UnescapeDataString(stringToUnescape: string): string;
    {class} function EscapeUriString(stringToEscape: string): string;
    {class} function EscapeDataString(stringToEscape: string): string;
    {class} function CheckHostName(name: string): DNUriHostNameType;
    {class} function HexEscape(character: Char): string;
    {class} function HexUnescape(pattern: string; out index: Int32): Char;
    {class} function IsHexEncoding(pattern: string; index: Int32): Boolean;
    {class} function CheckSchemeName(schemeName: string): Boolean;
    {class} function IsHexDigit(character: Char): Boolean;
    {class} function FromHex(digit: Char): Int32;

  end;

  [DNTypeName('System.Uri')]
  DNUri = interface(DDNC.System.Private.CoreLib.DNISerializable)
  ['{5FD3BFB5-3335-3A5E-82ED-8CFE3E503E51}']
  { getters & setters } 

    function get_AbsolutePath: string;
    function get_AbsoluteUri: string;
    function get_LocalPath: string;
    function get_Authority: string;
    function get_HostNameType: DNUriHostNameType;
    function get_IsDefaultPort: Boolean;
    function get_IsFile: Boolean;
    function get_IsLoopback: Boolean;
    function get_PathAndQuery: string;
    function get_Segments: TArray<string>;
    function get_IsUnc: Boolean;
    function get_Host: string;
    function get_Port: Int32;
    function get_Query: string;
    function get_Fragment: string;
    function get_Scheme: string;
    function get_OriginalString: string;
    function get_DnsSafeHost: string;
    function get_IdnHost: string;
    function get_IsAbsoluteUri: Boolean;
    function get_UserEscaped: Boolean;
    function get_UserInfo: string;

  { methods } 

    function MakeRelative(toUri: DNUri): string;
    function GetComponents(components: DNUriComponents; format: DNUriFormat): string;
    function IsWellFormedOriginalString: Boolean;
    function IsBaseOf(uri: DNUri): Boolean;
    function GetLeftPart(part: DNUriPartial): string;
    function GetHashCode: Int32;
    function ToString: string;
    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function MakeRelativeUri(uri: DNUri): DNUri;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AbsolutePath: string read get_AbsolutePath;
    property AbsoluteUri: string read get_AbsoluteUri;
    property LocalPath: string read get_LocalPath;
    property Authority: string read get_Authority;
    property HostNameType: DNUriHostNameType read get_HostNameType;
    property IsDefaultPort: Boolean read get_IsDefaultPort;
    property IsFile: Boolean read get_IsFile;
    property IsLoopback: Boolean read get_IsLoopback;
    property PathAndQuery: string read get_PathAndQuery;
    property Segments: TArray<string> read get_Segments;
    property IsUnc: Boolean read get_IsUnc;
    property Host: string read get_Host;
    property Port: Int32 read get_Port;
    property Query: string read get_Query;
    property Fragment: string read get_Fragment;
    property Scheme: string read get_Scheme;
    property OriginalString: string read get_OriginalString;
    property DnsSafeHost: string read get_DnsSafeHost;
    property IdnHost: string read get_IdnHost;
    property IsAbsoluteUri: Boolean read get_IsAbsoluteUri;
    property UserEscaped: Boolean read get_UserEscaped;
    property UserInfo: string read get_UserInfo;
  end;

  TDNUri = class(TDNGenericImport<DNUriClass, DNUri>) end;

  //-------------namespace: System----------------
  DNUriBuilderClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{70920D14-209F-5E2C-B060-4ED00C6ACBF5}']
  { constructors } 

    {class} function init: DNUriBuilder; overload;
    {class} function init(uri: string): DNUriBuilder; overload;
    {class} function init(uri: DNUri): DNUriBuilder; overload;
    {class} function init(schemeName: string; hostName: string): DNUriBuilder; overload;
    {class} function init(scheme: string; host: string; portNumber: Int32): DNUriBuilder; overload;
    {class} function init(scheme: string; host: string; port: Int32; pathValue: string): DNUriBuilder; overload;
    {class} function init(scheme: string; host: string; port: Int32; path: string; extraValue: string): DNUriBuilder; overload;

  end;

  [DNTypeName('System.UriBuilder')]
  DNUriBuilder = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8642FC4E-1ABF-32C6-A818-199B390B643B}']
  { getters & setters } 

    function get_Fragment: string;
    procedure set_Fragment(value: string);
    function get_Host: string;
    procedure set_Host(value: string);
    function get_Password: string;
    procedure set_Password(value: string);
    function get_Path: string;
    procedure set_Path(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_Query: string;
    procedure set_Query(value: string);
    function get_Scheme: string;
    procedure set_Scheme(value: string);
    function get_Uri: DNUri;
    function get_UserName: string;
    procedure set_UserName(value: string);

  { methods } 

    function Equals(rparam: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Fragment: string read get_Fragment write set_Fragment;
    property Host: string read get_Host write set_Host;
    property Password: string read get_Password write set_Password;
    property Path: string read get_Path write set_Path;
    property Port: Int32 read get_Port write set_Port;
    property Query: string read get_Query write set_Query;
    property Scheme: string read get_Scheme write set_Scheme;
    property Uri: DNUri read get_Uri;
    property UserName: string read get_UserName write set_UserName;
  end;

  TDNUriBuilder = class(TDNGenericImport<DNUriBuilderClass, DNUriBuilder>) end;

  //-------------namespace: System----------------
  DNUriParserClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{23818DE7-1A3D-52CB-B9E5-D0EE6A30382E}']
  { static methods } 

    {class} procedure &Register(uriParser: DNUriParser; schemeName: string; defaultPort: Int32);
    {class} function IsKnownScheme(schemeName: string): Boolean;

  end;

  [DNTypeName('System.UriParser')]
  DNUriParser = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4EA3B3EA-45D8-3347-B7C5-AAB9F7681561}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNUriParser = class(TDNGenericImport<DNUriParserClass, DNUriParser>) end;

  //-------------namespace: System----------------
  DNFileStyleUriParserClass = interface(DNUriParserClass)
  ['{658468E8-C199-5B1B-A7DF-479F912BBBEC}']
  { constructors } 

    {class} function init: DNFileStyleUriParser;

  end;

  [DNTypeName('System.FileStyleUriParser')]
  DNFileStyleUriParser = interface(DNUriParser)
  ['{BF6B3166-9EE2-35C4-AEB9-042AB726F563}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNFileStyleUriParser = class(TDNGenericImport<DNFileStyleUriParserClass, DNFileStyleUriParser>) end;

  //-------------namespace: System----------------
  DNFtpStyleUriParserClass = interface(DNUriParserClass)
  ['{0B325772-33CD-502E-9C4E-6BC98D6BDF59}']
  { constructors } 

    {class} function init: DNFtpStyleUriParser;

  end;

  [DNTypeName('System.FtpStyleUriParser')]
  DNFtpStyleUriParser = interface(DNUriParser)
  ['{8BB6264F-03E6-33EA-BF5F-2407F435481A}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNFtpStyleUriParser = class(TDNGenericImport<DNFtpStyleUriParserClass, DNFtpStyleUriParser>) end;

  //-------------namespace: System----------------
  DNGenericUriParserClass = interface(DNUriParserClass)
  ['{4F8B0452-E22F-5415-9AD5-2DBA310C2277}']
  { constructors } 

    {class} function init(options: DNGenericUriParserOptions): DNGenericUriParser;

  end;

  [DNTypeName('System.GenericUriParser')]
  DNGenericUriParser = interface(DNUriParser)
  ['{B2C93B0D-2CC8-3AD2-AC51-784C78D7E3A0}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNGenericUriParser = class(TDNGenericImport<DNGenericUriParserClass, DNGenericUriParser>) end;

  //-------------namespace: System----------------
  DNGopherStyleUriParserClass = interface(DNUriParserClass)
  ['{4B141C00-715B-54C0-A694-972F4BF595F4}']
  { constructors } 

    {class} function init: DNGopherStyleUriParser;

  end;

  [DNTypeName('System.GopherStyleUriParser')]
  DNGopherStyleUriParser = interface(DNUriParser)
  ['{9B75FEBC-C9C0-3F60-AD4F-4B2A0D8AE6D3}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNGopherStyleUriParser = class(TDNGenericImport<DNGopherStyleUriParserClass, DNGopherStyleUriParser>) end;

  //-------------namespace: System----------------
  DNHttpStyleUriParserClass = interface(DNUriParserClass)
  ['{14F55586-5489-5FAA-A7F5-D8393679A250}']
  { constructors } 

    {class} function init: DNHttpStyleUriParser;

  end;

  [DNTypeName('System.HttpStyleUriParser')]
  DNHttpStyleUriParser = interface(DNUriParser)
  ['{E0C2DF3E-6EAB-390B-982B-1A558FF102F5}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpStyleUriParser = class(TDNGenericImport<DNHttpStyleUriParserClass, DNHttpStyleUriParser>) end;

  //-------------namespace: System----------------
  DNLdapStyleUriParserClass = interface(DNUriParserClass)
  ['{62C779EF-61F2-5B66-BBD8-973D4AAB02BF}']
  { constructors } 

    {class} function init: DNLdapStyleUriParser;

  end;

  [DNTypeName('System.LdapStyleUriParser')]
  DNLdapStyleUriParser = interface(DNUriParser)
  ['{A64A275F-5AE3-3E2E-A2D8-2A30C50DDE32}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNLdapStyleUriParser = class(TDNGenericImport<DNLdapStyleUriParserClass, DNLdapStyleUriParser>) end;

  //-------------namespace: System----------------
  DNNetPipeStyleUriParserClass = interface(DNUriParserClass)
  ['{96A691C7-9477-5FEF-8A80-44C9561ECC8C}']
  { constructors } 

    {class} function init: DNNetPipeStyleUriParser;

  end;

  [DNTypeName('System.NetPipeStyleUriParser')]
  DNNetPipeStyleUriParser = interface(DNUriParser)
  ['{5F239C12-CE07-3918-B4B0-8986153A72BE}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNNetPipeStyleUriParser = class(TDNGenericImport<DNNetPipeStyleUriParserClass, DNNetPipeStyleUriParser>) end;

  //-------------namespace: System----------------
  DNNetTcpStyleUriParserClass = interface(DNUriParserClass)
  ['{8C0E5CE8-D646-59DB-9F13-D14F409DE53E}']
  { constructors } 

    {class} function init: DNNetTcpStyleUriParser;

  end;

  [DNTypeName('System.NetTcpStyleUriParser')]
  DNNetTcpStyleUriParser = interface(DNUriParser)
  ['{9FF03B95-5E7B-369C-B946-5857DCBC675F}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNNetTcpStyleUriParser = class(TDNGenericImport<DNNetTcpStyleUriParserClass, DNNetTcpStyleUriParser>) end;

  //-------------namespace: System----------------
  DNNewsStyleUriParserClass = interface(DNUriParserClass)
  ['{63DE95AB-FBD9-56E4-80E4-E2DB3DE19E25}']
  { constructors } 

    {class} function init: DNNewsStyleUriParser;

  end;

  [DNTypeName('System.NewsStyleUriParser')]
  DNNewsStyleUriParser = interface(DNUriParser)
  ['{D5056AE5-4E2A-330F-86A2-5CC724A8BBEF}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNNewsStyleUriParser = class(TDNGenericImport<DNNewsStyleUriParserClass, DNNewsStyleUriParser>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Private.Uri, Version=4.0.6.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
