//----------------------------------------------------------------------------
//  System.Net.Security.dll: System.Net.Security, Version=4.1.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.Security
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.Security;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Collections.NonGeneric,
  DDNC.System.Security.Cryptography.X509Certificates,
  DDNC.System.Net.Primitives,
  DDNC.System.Security.Principal;

type

{ enums }

  //-------------namespace: System.Net.Security----------------
  [DNTypeName('System.Net.Security.EncryptionPolicy')]
  DNEncryptionPolicy = type Integer;
  DNEncryptionPolicyHelper = record helper for DNEncryptionPolicy
  public const
    RequireEncryption = 0;
    AllowNoEncryption = 1;
    NoEncryption = 2;
  end;


  //-------------namespace: System.Net.Security----------------
  [DNTypeName('System.Net.Security.ProtectionLevel')]
  DNProtectionLevel = type Integer;
  DNProtectionLevelHelper = record helper for DNProtectionLevel
  public const
    None = 0;
    Sign = 1;
    EncryptAndSign = 2;
  end;


  //-------------namespace: System.Net.Security----------------
  [DNTypeName('System.Net.Security.TlsCipherSuite')]
  DNTlsCipherSuite = type Integer;
  DNTlsCipherSuiteHelper = record helper for DNTlsCipherSuite
  public const
    TLS_NULL_WITH_NULL_NULL = 0;
    TLS_RSA_WITH_NULL_MD5 = 1;
    TLS_RSA_WITH_NULL_SHA = 2;
    TLS_RSA_EXPORT_WITH_RC4_40_MD5 = 3;
    TLS_RSA_WITH_RC4_128_MD5 = 4;
    TLS_RSA_WITH_RC4_128_SHA = 5;
    TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6;
    TLS_RSA_WITH_IDEA_CBC_SHA = 7;
    TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = 8;
    TLS_RSA_WITH_DES_CBC_SHA = 9;
    TLS_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 11;
    TLS_DH_DSS_WITH_DES_CBC_SHA = 12;
    TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = 13;
    TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 14;
    TLS_DH_RSA_WITH_DES_CBC_SHA = 15;
    TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = 16;
    TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 17;
    TLS_DHE_DSS_WITH_DES_CBC_SHA = 18;
    TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 20;
    TLS_DHE_RSA_WITH_DES_CBC_SHA = 21;
    TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    TLS_DH_anon_EXPORT_WITH_RC4_40_MD5 = 23;
    TLS_DH_anon_WITH_RC4_128_MD5 = 24;
    TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA = 25;
    TLS_DH_anon_WITH_DES_CBC_SHA = 26;
    TLS_DH_anon_WITH_3DES_EDE_CBC_SHA = 27;
    TLS_KRB5_WITH_DES_CBC_SHA = 30;
    TLS_KRB5_WITH_3DES_EDE_CBC_SHA = 31;
    TLS_KRB5_WITH_RC4_128_SHA = 32;
    TLS_KRB5_WITH_IDEA_CBC_SHA = 33;
    TLS_KRB5_WITH_DES_CBC_MD5 = 34;
    TLS_KRB5_WITH_3DES_EDE_CBC_MD5 = 35;
    TLS_KRB5_WITH_RC4_128_MD5 = 36;
    TLS_KRB5_WITH_IDEA_CBC_MD5 = 37;
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA = 38;
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA = 39;
    TLS_KRB5_EXPORT_WITH_RC4_40_SHA = 40;
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5 = 41;
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5 = 42;
    TLS_KRB5_EXPORT_WITH_RC4_40_MD5 = 43;
    TLS_PSK_WITH_NULL_SHA = 44;
    TLS_DHE_PSK_WITH_NULL_SHA = 45;
    TLS_RSA_PSK_WITH_NULL_SHA = 46;
    TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    TLS_DH_DSS_WITH_AES_128_CBC_SHA = 48;
    TLS_DH_RSA_WITH_AES_128_CBC_SHA = 49;
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50;
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    TLS_DH_anon_WITH_AES_128_CBC_SHA = 52;
    TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    TLS_DH_DSS_WITH_AES_256_CBC_SHA = 54;
    TLS_DH_RSA_WITH_AES_256_CBC_SHA = 55;
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56;
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;
    TLS_DH_anon_WITH_AES_256_CBC_SHA = 58;
    TLS_RSA_WITH_NULL_SHA256 = 59;
    TLS_RSA_WITH_AES_128_CBC_SHA256 = 60;
    TLS_RSA_WITH_AES_256_CBC_SHA256 = 61;
    TLS_DH_DSS_WITH_AES_128_CBC_SHA256 = 62;
    TLS_DH_RSA_WITH_AES_128_CBC_SHA256 = 63;
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 = 64;
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA = 65;
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 66;
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 67;
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 68;
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 69;
    TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA = 70;
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = 103;
    TLS_DH_DSS_WITH_AES_256_CBC_SHA256 = 104;
    TLS_DH_RSA_WITH_AES_256_CBC_SHA256 = 105;
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 = 106;
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = 107;
    TLS_DH_anon_WITH_AES_128_CBC_SHA256 = 108;
    TLS_DH_anon_WITH_AES_256_CBC_SHA256 = 109;
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA = 132;
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 133;
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 134;
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 135;
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 136;
    TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA = 137;
    TLS_PSK_WITH_RC4_128_SHA = 138;
    TLS_PSK_WITH_3DES_EDE_CBC_SHA = 139;
    TLS_PSK_WITH_AES_128_CBC_SHA = 140;
    TLS_PSK_WITH_AES_256_CBC_SHA = 141;
    TLS_DHE_PSK_WITH_RC4_128_SHA = 142;
    TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 143;
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA = 144;
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA = 145;
    TLS_RSA_PSK_WITH_RC4_128_SHA = 146;
    TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 147;
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA = 148;
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA = 149;
    TLS_RSA_WITH_SEED_CBC_SHA = 150;
    TLS_DH_DSS_WITH_SEED_CBC_SHA = 151;
    TLS_DH_RSA_WITH_SEED_CBC_SHA = 152;
    TLS_DHE_DSS_WITH_SEED_CBC_SHA = 153;
    TLS_DHE_RSA_WITH_SEED_CBC_SHA = 154;
    TLS_DH_anon_WITH_SEED_CBC_SHA = 155;
    TLS_RSA_WITH_AES_128_GCM_SHA256 = 156;
    TLS_RSA_WITH_AES_256_GCM_SHA384 = 157;
    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = 158;
    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = 159;
    TLS_DH_RSA_WITH_AES_128_GCM_SHA256 = 160;
    TLS_DH_RSA_WITH_AES_256_GCM_SHA384 = 161;
    TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 = 162;
    TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 = 163;
    TLS_DH_DSS_WITH_AES_128_GCM_SHA256 = 164;
    TLS_DH_DSS_WITH_AES_256_GCM_SHA384 = 165;
    TLS_DH_anon_WITH_AES_128_GCM_SHA256 = 166;
    TLS_DH_anon_WITH_AES_256_GCM_SHA384 = 167;
    TLS_PSK_WITH_AES_128_GCM_SHA256 = 168;
    TLS_PSK_WITH_AES_256_GCM_SHA384 = 169;
    TLS_DHE_PSK_WITH_AES_128_GCM_SHA256 = 170;
    TLS_DHE_PSK_WITH_AES_256_GCM_SHA384 = 171;
    TLS_RSA_PSK_WITH_AES_128_GCM_SHA256 = 172;
    TLS_RSA_PSK_WITH_AES_256_GCM_SHA384 = 173;
    TLS_PSK_WITH_AES_128_CBC_SHA256 = 174;
    TLS_PSK_WITH_AES_256_CBC_SHA384 = 175;
    TLS_PSK_WITH_NULL_SHA256 = 176;
    TLS_PSK_WITH_NULL_SHA384 = 177;
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA256 = 178;
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA384 = 179;
    TLS_DHE_PSK_WITH_NULL_SHA256 = 180;
    TLS_DHE_PSK_WITH_NULL_SHA384 = 181;
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA256 = 182;
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA384 = 183;
    TLS_RSA_PSK_WITH_NULL_SHA256 = 184;
    TLS_RSA_PSK_WITH_NULL_SHA384 = 185;
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 186;
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 187;
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 188;
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 189;
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 190;
    TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256 = 191;
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 192;
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 193;
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 194;
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 195;
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 196;
    TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256 = 197;
    TLS_AES_128_GCM_SHA256 = 4865;
    TLS_AES_256_GCM_SHA384 = 4866;
    TLS_CHACHA20_POLY1305_SHA256 = 4867;
    TLS_AES_128_CCM_SHA256 = 4868;
    TLS_AES_128_CCM_8_SHA256 = 4869;
    TLS_ECDH_ECDSA_WITH_NULL_SHA = 49153;
    TLS_ECDH_ECDSA_WITH_RC4_128_SHA = 49154;
    TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = 49155;
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 49156;
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 49157;
    TLS_ECDHE_ECDSA_WITH_NULL_SHA = 49158;
    TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = 49159;
    TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = 49160;
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 49161;
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 49162;
    TLS_ECDH_RSA_WITH_NULL_SHA = 49163;
    TLS_ECDH_RSA_WITH_RC4_128_SHA = 49164;
    TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = 49165;
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = 49166;
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = 49167;
    TLS_ECDHE_RSA_WITH_NULL_SHA = 49168;
    TLS_ECDHE_RSA_WITH_RC4_128_SHA = 49169;
    TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = 49170;
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = 49171;
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = 49172;
    TLS_ECDH_anon_WITH_NULL_SHA = 49173;
    TLS_ECDH_anon_WITH_RC4_128_SHA = 49174;
    TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA = 49175;
    TLS_ECDH_anon_WITH_AES_128_CBC_SHA = 49176;
    TLS_ECDH_anon_WITH_AES_256_CBC_SHA = 49177;
    TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 49178;
    TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 49179;
    TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 49180;
    TLS_SRP_SHA_WITH_AES_128_CBC_SHA = 49181;
    TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 49182;
    TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 49183;
    TLS_SRP_SHA_WITH_AES_256_CBC_SHA = 49184;
    TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 49185;
    TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 49186;
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = 49187;
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = 49188;
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = 49189;
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = 49190;
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = 49191;
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = 49192;
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256 = 49193;
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384 = 49194;
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 49195;
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 49196;
    TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = 49197;
    TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = 49198;
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 49199;
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 49200;
    TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = 49201;
    TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384 = 49202;
    TLS_ECDHE_PSK_WITH_RC4_128_SHA = 49203;
    TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 49204;
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA = 49205;
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA = 49206;
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 49207;
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 49208;
    TLS_ECDHE_PSK_WITH_NULL_SHA = 49209;
    TLS_ECDHE_PSK_WITH_NULL_SHA256 = 49210;
    TLS_ECDHE_PSK_WITH_NULL_SHA384 = 49211;
    TLS_RSA_WITH_ARIA_128_CBC_SHA256 = 49212;
    TLS_RSA_WITH_ARIA_256_CBC_SHA384 = 49213;
    TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256 = 49214;
    TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384 = 49215;
    TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256 = 49216;
    TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384 = 49217;
    TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256 = 49218;
    TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384 = 49219;
    TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256 = 49220;
    TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384 = 49221;
    TLS_DH_anon_WITH_ARIA_128_CBC_SHA256 = 49222;
    TLS_DH_anon_WITH_ARIA_256_CBC_SHA384 = 49223;
    TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256 = 49224;
    TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384 = 49225;
    TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256 = 49226;
    TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384 = 49227;
    TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256 = 49228;
    TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384 = 49229;
    TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256 = 49230;
    TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384 = 49231;
    TLS_RSA_WITH_ARIA_128_GCM_SHA256 = 49232;
    TLS_RSA_WITH_ARIA_256_GCM_SHA384 = 49233;
    TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 49234;
    TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 49235;
    TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 49236;
    TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 49237;
    TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 49238;
    TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 49239;
    TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 49240;
    TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 49241;
    TLS_DH_anon_WITH_ARIA_128_GCM_SHA256 = 49242;
    TLS_DH_anon_WITH_ARIA_256_GCM_SHA384 = 49243;
    TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 49244;
    TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 49245;
    TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 49246;
    TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 49247;
    TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 49248;
    TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 49249;
    TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 49250;
    TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 49251;
    TLS_PSK_WITH_ARIA_128_CBC_SHA256 = 49252;
    TLS_PSK_WITH_ARIA_256_CBC_SHA384 = 49253;
    TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256 = 49254;
    TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384 = 49255;
    TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256 = 49256;
    TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384 = 49257;
    TLS_PSK_WITH_ARIA_128_GCM_SHA256 = 49258;
    TLS_PSK_WITH_ARIA_256_GCM_SHA384 = 49259;
    TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 49260;
    TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 49261;
    TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 49262;
    TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 49263;
    TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256 = 49264;
    TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384 = 49265;
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 49266;
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 49267;
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 49268;
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 49269;
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 49270;
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 49271;
    TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 49272;
    TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 49273;
    TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49274;
    TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49275;
    TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49276;
    TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49277;
    TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49278;
    TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49279;
    TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256 = 49280;
    TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384 = 49281;
    TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256 = 49282;
    TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384 = 49283;
    TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256 = 49284;
    TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384 = 49285;
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = 49286;
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = 49287;
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = 49288;
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = 49289;
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49290;
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49291;
    TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49292;
    TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49293;
    TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 49294;
    TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 49295;
    TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 49296;
    TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 49297;
    TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 49298;
    TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 49299;
    TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49300;
    TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49301;
    TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49302;
    TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49303;
    TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49304;
    TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49305;
    TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49306;
    TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49307;
    TLS_RSA_WITH_AES_128_CCM = 49308;
    TLS_RSA_WITH_AES_256_CCM = 49309;
    TLS_DHE_RSA_WITH_AES_128_CCM = 49310;
    TLS_DHE_RSA_WITH_AES_256_CCM = 49311;
    TLS_RSA_WITH_AES_128_CCM_8 = 49312;
    TLS_RSA_WITH_AES_256_CCM_8 = 49313;
    TLS_DHE_RSA_WITH_AES_128_CCM_8 = 49314;
    TLS_DHE_RSA_WITH_AES_256_CCM_8 = 49315;
    TLS_PSK_WITH_AES_128_CCM = 49316;
    TLS_PSK_WITH_AES_256_CCM = 49317;
    TLS_DHE_PSK_WITH_AES_128_CCM = 49318;
    TLS_DHE_PSK_WITH_AES_256_CCM = 49319;
    TLS_PSK_WITH_AES_128_CCM_8 = 49320;
    TLS_PSK_WITH_AES_256_CCM_8 = 49321;
    TLS_PSK_DHE_WITH_AES_128_CCM_8 = 49322;
    TLS_PSK_DHE_WITH_AES_256_CCM_8 = 49323;
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM = 49324;
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM = 49325;
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 49326;
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 49327;
    TLS_ECCPWD_WITH_AES_128_GCM_SHA256 = 49328;
    TLS_ECCPWD_WITH_AES_256_GCM_SHA384 = 49329;
    TLS_ECCPWD_WITH_AES_128_CCM_SHA256 = 49330;
    TLS_ECCPWD_WITH_AES_256_CCM_SHA384 = 49331;
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52392;
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 52393;
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52394;
    TLS_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52395;
    TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52396;
    TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52397;
    TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52398;
    TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256 = 53249;
    TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384 = 53250;
    TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256 = 53251;
    TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256 = 53253;
  end;


  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  [DNTypeName('System.Security.Authentication.ExtendedProtection.PolicyEnforcement')]
  DNPolicyEnforcement = type Integer;
  DNPolicyEnforcementHelper = record helper for DNPolicyEnforcement
  public const
    Never = 0;
    WhenSupported = 1;
    Always = 2;
  end;


  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  [DNTypeName('System.Security.Authentication.ExtendedProtection.ProtectionScenario')]
  DNProtectionScenario = type Integer;
  DNProtectionScenarioHelper = record helper for DNProtectionScenario
  public const
    TransportSelected = 0;
    TrustedProxy = 1;
  end;




type


{ declares }

  DNServiceNameCollection = interface; // type: System.Security.Authentication.ExtendedProtection.ServiceNameCollection, namespace: System.Security.Authentication.ExtendedProtection
  DNAuthenticationException = interface; // type: System.Security.Authentication.AuthenticationException, namespace: System.Security.Authentication
  DNInvalidCredentialException = interface; // type: System.Security.Authentication.InvalidCredentialException, namespace: System.Security.Authentication
  DNAuthenticatedStream = interface; // type: System.Net.Security.AuthenticatedStream, namespace: System.Net.Security
  DNNegotiateStream = interface; // type: System.Net.Security.NegotiateStream, namespace: System.Net.Security
  DNSslStream = interface; // type: System.Net.Security.SslStream, namespace: System.Net.Security
  DNCipherSuitesPolicy = interface; // type: System.Net.Security.CipherSuitesPolicy, namespace: System.Net.Security
  DNSslClientAuthenticationOptions = interface; // type: System.Net.Security.SslClientAuthenticationOptions, namespace: System.Net.Security
  DNSslServerAuthenticationOptions = interface; // type: System.Net.Security.SslServerAuthenticationOptions, namespace: System.Net.Security
  DNExtendedProtectionPolicy = interface; // type: System.Security.Authentication.ExtendedProtection.ExtendedProtectionPolicy, namespace: System.Security.Authentication.ExtendedProtection
  DNSslApplicationProtocol = interface; // type: System.Net.Security.SslApplicationProtocol, namespace: System.Net.Security

{ delegates }

  [DNTypeName('System.Net.Security.LocalCertificateSelectionCallback')]
  DNLocalCertificateSelectionCallback = function(sender: DDNC.System.Private.CoreLib.DNObject; targetHost: string; localCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; remoteCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; acceptableIssuers: TArray<string>): DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate of object;

  [DNTypeName('System.Net.Security.RemoteCertificateValidationCallback')]
  DNRemoteCertificateValidationCallback = function(sender: DDNC.System.Private.CoreLib.DNObject; certificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; chain: DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain; sslPolicyErrors: DDNC.System.Net.Primitives.DNSslPolicyErrors): Boolean of object;

  [DNTypeName('System.Net.Security.ServerCertificateSelectionCallback')]
  DNServerCertificateSelectionCallback = function(sender: DDNC.System.Private.CoreLib.DNObject; hostName: string): DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate of object;




{ objects }

  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  DNServiceNameCollectionClass = interface(DNObjectClass)
  ['{F8E80AB4-B125-58E9-8D26-BE9C10CD6123}']
  { constructors } 

    {class} function init(items: DDNC.System.Private.CoreLib.DNICollection): DNServiceNameCollection;

  end;

  [DNTypeName('System.Security.Authentication.ExtendedProtection.ServiceNameCollection')]
  DNServiceNameCollection = interface(DNObject)
  ['{29431CF3-75BD-3D95-A8A3-CADC2DCA8DDA}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    function &Contains(searchServiceName: string): Boolean;
    function Merge(serviceName: string): DNServiceNameCollection; overload;
    function Merge(serviceNames: DDNC.System.Private.CoreLib.DNIEnumerable): DNServiceNameCollection; overload;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNServiceNameCollection = class(TDNGenericImport<DNServiceNameCollectionClass, DNServiceNameCollection>) end;

  //-------------namespace: System.Security.Authentication----------------
  DNAuthenticationExceptionClass = interface(DDNC.System.Private.CoreLib.DNSystemExceptionClass)
  ['{5F8BA2DC-79F9-53DF-BA0D-A68BD53B632A}']
  { constructors } 

    {class} function init: DNAuthenticationException; overload;
    {class} function init(message: string): DNAuthenticationException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNAuthenticationException; overload;

  end;

  [DNTypeName('System.Security.Authentication.AuthenticationException')]
  DNAuthenticationException = interface(DDNC.System.Private.CoreLib.DNSystemException)
  ['{84231F00-43AE-304F-8D56-3255057F4D0B}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNAuthenticationException = class(TDNGenericImport<DNAuthenticationExceptionClass, DNAuthenticationException>) end;

  //-------------namespace: System.Security.Authentication----------------
  DNInvalidCredentialExceptionClass = interface(DNAuthenticationExceptionClass)
  ['{32392EDA-CCDB-576A-9509-8137555D2B0A}']
  { constructors } 

    {class} function init: DNInvalidCredentialException; overload;
    {class} function init(message: string): DNInvalidCredentialException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNInvalidCredentialException; overload;

  end;

  [DNTypeName('System.Security.Authentication.InvalidCredentialException')]
  DNInvalidCredentialException = interface(DNAuthenticationException)
  ['{A67BEC13-23A3-31D6-820C-10549A802DA0}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNInvalidCredentialException = class(TDNGenericImport<DNInvalidCredentialExceptionClass, DNInvalidCredentialException>) end;

  //-------------namespace: System.Net.Security----------------
  DNAuthenticatedStreamClass = interface(DDNC.System.Private.CoreLib.DNStreamClass)
  ['{490A94F4-FC1C-5E38-A625-DDF9D1193700}']
  end;

  [DNTypeName('System.Net.Security.AuthenticatedStream')]
  DNAuthenticatedStream = interface(DDNC.System.Private.CoreLib.DNStream)
  ['{56E2434E-9415-34B4-89BB-ED11664D87BC}']
  { getters & setters } 

    function get_LeaveInnerStreamOpen: Boolean;
    function get_IsAuthenticated: Boolean;
    function get_IsMutuallyAuthenticated: Boolean;
    function get_IsEncrypted: Boolean;
    function get_IsSigned: Boolean;
    function get_IsServer: Boolean;
    function get_CanRead: Boolean;
    function get_CanSeek: Boolean;
    function get_CanTimeout: Boolean;
    function get_CanWrite: Boolean;
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);

  { methods } 

    function DisposeAsync: DDNC.System.Private.CoreLib.DNValueTask;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    procedure Flush;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure SetLength(value: Int64);
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadByte: Int32;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure WriteByte(value: Byte);
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property LeaveInnerStreamOpen: Boolean read get_LeaveInnerStreamOpen;
    property IsAuthenticated: Boolean read get_IsAuthenticated;
    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
    property IsEncrypted: Boolean read get_IsEncrypted;
    property IsSigned: Boolean read get_IsSigned;
    property IsServer: Boolean read get_IsServer;
    property CanRead: Boolean read get_CanRead;
    property CanSeek: Boolean read get_CanSeek;
    property CanTimeout: Boolean read get_CanTimeout;
    property CanWrite: Boolean read get_CanWrite;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
  end;

  TDNAuthenticatedStream = class(TDNGenericImport<DNAuthenticatedStreamClass, DNAuthenticatedStream>) end;

  //-------------namespace: System.Net.Security----------------
  DNNegotiateStreamClass = interface(DNAuthenticatedStreamClass)
  ['{D22F751C-9532-53B7-BA2D-987CEBBC16E8}']
  { constructors } 

    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream): DNNegotiateStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean): DNNegotiateStream; overload;

  end;

  [DNTypeName('System.Net.Security.NegotiateStream')]
  DNNegotiateStream = interface(DNAuthenticatedStream)
  ['{0C336BD2-0A0C-3520-ADF9-144566860240}']
  { getters & setters } 

    function get_IsAuthenticated: Boolean;
    function get_IsMutuallyAuthenticated: Boolean;
    function get_IsEncrypted: Boolean;
    function get_IsSigned: Boolean;
    function get_IsServer: Boolean;
    function get_ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel;
    function get_RemoteIdentity: DDNC.System.Private.CoreLib.DNIIdentity;
    function get_CanSeek: Boolean;
    function get_CanRead: Boolean;
    function get_CanTimeout: Boolean;
    function get_CanWrite: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_LeaveInnerStreamOpen: Boolean;

  { methods } 

    function BeginAuthenticateAsClient(asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndAuthenticateAsClient(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    procedure AuthenticateAsServer; overload;
    procedure AuthenticateAsServer(policy: DNExtendedProtectionPolicy); overload;
    procedure AuthenticateAsServer(credential: DDNC.System.Net.Primitives.DNNetworkCredential; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel); overload;
    procedure AuthenticateAsServer(credential: DDNC.System.Net.Primitives.DNNetworkCredential; policy: DNExtendedProtectionPolicy; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel); overload;
    function BeginAuthenticateAsServer(asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(policy: DNExtendedProtectionPolicy; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(credential: DDNC.System.Net.Primitives.DNNetworkCredential; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(credential: DDNC.System.Net.Primitives.DNNetworkCredential; policy: DNExtendedProtectionPolicy; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndAuthenticateAsServer(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    procedure AuthenticateAsClient; overload;
    procedure AuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string); overload;
    procedure AuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string); overload;
    procedure AuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel); overload;
    procedure AuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel); overload;
    function AuthenticateAsClientAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(policy: DNExtendedProtectionPolicy): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; policy: DNExtendedProtectionPolicy; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure SetLength(value: Int64);
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure Flush;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function DisposeAsync: DDNC.System.Private.CoreLib.DNValueTask;
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadByte: Int32;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure WriteByte(value: Byte);
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsAuthenticated: Boolean read get_IsAuthenticated;
    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
    property IsEncrypted: Boolean read get_IsEncrypted;
    property IsSigned: Boolean read get_IsSigned;
    property IsServer: Boolean read get_IsServer;
    property ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel read get_ImpersonationLevel;
    property RemoteIdentity: DDNC.System.Private.CoreLib.DNIIdentity read get_RemoteIdentity;
    property CanSeek: Boolean read get_CanSeek;
    property CanRead: Boolean read get_CanRead;
    property CanTimeout: Boolean read get_CanTimeout;
    property CanWrite: Boolean read get_CanWrite;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property LeaveInnerStreamOpen: Boolean read get_LeaveInnerStreamOpen;
  end;

  TDNNegotiateStream = class(TDNGenericImport<DNNegotiateStreamClass, DNNegotiateStream>) end;

  //-------------namespace: System.Net.Security----------------
  DNSslStreamClass = interface(DNAuthenticatedStreamClass)
  ['{AEA4C299-E95D-590C-86B2-C276051DE9AD}']
  { constructors } 

    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream): DNSslStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean): DNSslStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean; userCertificateValidationCallback: DNRemoteCertificateValidationCallback): DNSslStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean; userCertificateValidationCallback: DNRemoteCertificateValidationCallback; userCertificateSelectionCallback: DNLocalCertificateSelectionCallback): DNSslStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean; userCertificateValidationCallback: DNRemoteCertificateValidationCallback; userCertificateSelectionCallback: DNLocalCertificateSelectionCallback; encryptionPolicy: DNEncryptionPolicy): DNSslStream; overload;

  end;

  [DNTypeName('System.Net.Security.SslStream')]
  DNSslStream = interface(DNAuthenticatedStream)
  ['{E6C8BAF6-BDD4-33D2-9A01-855FEA5C12C9}']
  { getters & setters } 

    function get_NegotiatedApplicationProtocol: DNSslApplicationProtocol;
    function get_TransportContext: DDNC.System.Net.Primitives.DNTransportContext;
    function get_IsAuthenticated: Boolean;
    function get_IsMutuallyAuthenticated: Boolean;
    function get_IsEncrypted: Boolean;
    function get_IsSigned: Boolean;
    function get_IsServer: Boolean;
    function get_SslProtocol: DDNC.System.Net.Primitives.DNSslProtocols;
    function get_CheckCertRevocationStatus: Boolean;
    function get_LocalCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate;
    function get_RemoteCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate;
    function get_NegotiatedCipherSuite: DNTlsCipherSuite;
    function get_CipherAlgorithm: DDNC.System.Net.Primitives.DNCipherAlgorithmType;
    function get_CipherStrength: Int32;
    function get_HashAlgorithm: DDNC.System.Net.Primitives.DNHashAlgorithmType;
    function get_HashStrength: Int32;
    function get_KeyExchangeAlgorithm: DDNC.System.Net.Primitives.DNExchangeAlgorithmType;
    function get_KeyExchangeStrength: Int32;
    function get_CanSeek: Boolean;
    function get_CanRead: Boolean;
    function get_CanTimeout: Boolean;
    function get_CanWrite: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_LeaveInnerStreamOpen: Boolean;

  { methods } 

    function BeginAuthenticateAsClient(targetHost: string; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; checkCertificateRevocation: Boolean; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndAuthenticateAsClient(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function BeginAuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; checkCertificateRevocation: Boolean; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndAuthenticateAsServer(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    procedure AuthenticateAsClient(targetHost: string); overload;
    procedure AuthenticateAsClient(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; checkCertificateRevocation: Boolean); overload;
    procedure AuthenticateAsClient(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean); overload;
    procedure AuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate); overload;
    procedure AuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; checkCertificateRevocation: Boolean); overload;
    procedure AuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean); overload;
    function AuthenticateAsClientAsync(targetHost: string): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; checkCertificateRevocation: Boolean): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(sslClientAuthenticationOptions: DNSslClientAuthenticationOptions; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; checkCertificateRevocation: Boolean): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(sslServerAuthenticationOptions: DNSslServerAuthenticationOptions; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function ShutdownAsync: DDNC.System.Private.CoreLib.DNTask;
    procedure SetLength(value: Int64);
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure Flush;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function DisposeAsync: DDNC.System.Private.CoreLib.DNValueTask;
    function ReadByte: Int32;
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    procedure Write(buffer: TArray<Byte>); overload;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure WriteByte(value: Byte);
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property NegotiatedApplicationProtocol: DNSslApplicationProtocol read get_NegotiatedApplicationProtocol;
    property TransportContext: DDNC.System.Net.Primitives.DNTransportContext read get_TransportContext;
    property IsAuthenticated: Boolean read get_IsAuthenticated;
    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
    property IsEncrypted: Boolean read get_IsEncrypted;
    property IsSigned: Boolean read get_IsSigned;
    property IsServer: Boolean read get_IsServer;
    property SslProtocol: DDNC.System.Net.Primitives.DNSslProtocols read get_SslProtocol;
    property CheckCertRevocationStatus: Boolean read get_CheckCertRevocationStatus;
    property LocalCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate read get_LocalCertificate;
    property RemoteCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate read get_RemoteCertificate;
    property NegotiatedCipherSuite: DNTlsCipherSuite read get_NegotiatedCipherSuite;
    property CipherAlgorithm: DDNC.System.Net.Primitives.DNCipherAlgorithmType read get_CipherAlgorithm;
    property CipherStrength: Int32 read get_CipherStrength;
    property HashAlgorithm: DDNC.System.Net.Primitives.DNHashAlgorithmType read get_HashAlgorithm;
    property HashStrength: Int32 read get_HashStrength;
    property KeyExchangeAlgorithm: DDNC.System.Net.Primitives.DNExchangeAlgorithmType read get_KeyExchangeAlgorithm;
    property KeyExchangeStrength: Int32 read get_KeyExchangeStrength;
    property CanSeek: Boolean read get_CanSeek;
    property CanRead: Boolean read get_CanRead;
    property CanTimeout: Boolean read get_CanTimeout;
    property CanWrite: Boolean read get_CanWrite;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property LeaveInnerStreamOpen: Boolean read get_LeaveInnerStreamOpen;
  end;

  TDNSslStream = class(TDNGenericImport<DNSslStreamClass, DNSslStream>) end;

  //-------------namespace: System.Net.Security----------------
  DNCipherSuitesPolicyClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{512362E5-1F0C-5984-BDA6-CE91E1124CE8}']
  { constructors } 

    {class} function init(allowedCipherSuites: DDNC.System.Private.CoreLib.DNIEnumerable<DNTlsCipherSuite>): DNCipherSuitesPolicy;

  end;

  [DNTypeName('System.Net.Security.CipherSuitesPolicy')]
  DNCipherSuitesPolicy = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C65A1223-DCD0-3A89-BC72-F93AFD788798}']
  { getters & setters } 

    function get_AllowedCipherSuites: DDNC.System.Private.CoreLib.DNIEnumerable<DNTlsCipherSuite>;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AllowedCipherSuites: DDNC.System.Private.CoreLib.DNIEnumerable<DNTlsCipherSuite> read get_AllowedCipherSuites;
  end;

  TDNCipherSuitesPolicy = class(TDNGenericImport<DNCipherSuitesPolicyClass, DNCipherSuitesPolicy>) end;

  //-------------namespace: System.Net.Security----------------
  DNSslClientAuthenticationOptionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{81D466D6-4CF1-586D-BF9D-1EB99A7859DF}']
  { constructors } 

    {class} function init: DNSslClientAuthenticationOptions;

  end;

  [DNTypeName('System.Net.Security.SslClientAuthenticationOptions')]
  DNSslClientAuthenticationOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8478B9F8-F279-32AA-AB78-4EA288788345}']
  { getters & setters } 

    function get_AllowRenegotiation: Boolean;
    procedure set_AllowRenegotiation(value: Boolean);
    function get_LocalCertificateSelectionCallback: DNLocalCertificateSelectionCallback;
    procedure set_LocalCertificateSelectionCallback(value: DNLocalCertificateSelectionCallback);
    function get_RemoteCertificateValidationCallback: DNRemoteCertificateValidationCallback;
    procedure set_RemoteCertificateValidationCallback(value: DNRemoteCertificateValidationCallback);
    function get_ApplicationProtocols: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol>;
    procedure set_ApplicationProtocols(value: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol>);
    function get_TargetHost: string;
    procedure set_TargetHost(value: string);
    function get_ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection;
    procedure set_ClientCertificates(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection);
    function get_CertificateRevocationCheckMode: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode;
    procedure set_CertificateRevocationCheckMode(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode);
    function get_EncryptionPolicy: DNEncryptionPolicy;
    procedure set_EncryptionPolicy(value: DNEncryptionPolicy);
    function get_EnabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols;
    procedure set_EnabledSslProtocols(value: DDNC.System.Net.Primitives.DNSslProtocols);
    function get_CipherSuitesPolicy: DNCipherSuitesPolicy;
    procedure set_CipherSuitesPolicy(value: DNCipherSuitesPolicy);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AllowRenegotiation: Boolean read get_AllowRenegotiation write set_AllowRenegotiation;
    property LocalCertificateSelectionCallback: DNLocalCertificateSelectionCallback read get_LocalCertificateSelectionCallback write set_LocalCertificateSelectionCallback;
    property RemoteCertificateValidationCallback: DNRemoteCertificateValidationCallback read get_RemoteCertificateValidationCallback write set_RemoteCertificateValidationCallback;
    property ApplicationProtocols: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol> read get_ApplicationProtocols write set_ApplicationProtocols;
    property TargetHost: string read get_TargetHost write set_TargetHost;
    property ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection read get_ClientCertificates write set_ClientCertificates;
    property CertificateRevocationCheckMode: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode read get_CertificateRevocationCheckMode write set_CertificateRevocationCheckMode;
    property EncryptionPolicy: DNEncryptionPolicy read get_EncryptionPolicy write set_EncryptionPolicy;
    property EnabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols read get_EnabledSslProtocols write set_EnabledSslProtocols;
    property CipherSuitesPolicy: DNCipherSuitesPolicy read get_CipherSuitesPolicy write set_CipherSuitesPolicy;
  end;

  TDNSslClientAuthenticationOptions = class(TDNGenericImport<DNSslClientAuthenticationOptionsClass, DNSslClientAuthenticationOptions>) end;

  //-------------namespace: System.Net.Security----------------
  DNSslServerAuthenticationOptionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{35E2EF2C-E9BF-523B-97E8-74B70D0EFB1E}']
  { constructors } 

    {class} function init: DNSslServerAuthenticationOptions;

  end;

  [DNTypeName('System.Net.Security.SslServerAuthenticationOptions')]
  DNSslServerAuthenticationOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F21CAE52-891B-3AF3-A9EC-C17B8BD391CE}']
  { getters & setters } 

    function get_AllowRenegotiation: Boolean;
    procedure set_AllowRenegotiation(value: Boolean);
    function get_ClientCertificateRequired: Boolean;
    procedure set_ClientCertificateRequired(value: Boolean);
    function get_ApplicationProtocols: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol>;
    procedure set_ApplicationProtocols(value: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol>);
    function get_RemoteCertificateValidationCallback: DNRemoteCertificateValidationCallback;
    procedure set_RemoteCertificateValidationCallback(value: DNRemoteCertificateValidationCallback);
    function get_ServerCertificateSelectionCallback: DNServerCertificateSelectionCallback;
    procedure set_ServerCertificateSelectionCallback(value: DNServerCertificateSelectionCallback);
    function get_ServerCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate;
    procedure set_ServerCertificate(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate);
    function get_EnabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols;
    procedure set_EnabledSslProtocols(value: DDNC.System.Net.Primitives.DNSslProtocols);
    function get_CertificateRevocationCheckMode: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode;
    procedure set_CertificateRevocationCheckMode(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode);
    function get_EncryptionPolicy: DNEncryptionPolicy;
    procedure set_EncryptionPolicy(value: DNEncryptionPolicy);
    function get_CipherSuitesPolicy: DNCipherSuitesPolicy;
    procedure set_CipherSuitesPolicy(value: DNCipherSuitesPolicy);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AllowRenegotiation: Boolean read get_AllowRenegotiation write set_AllowRenegotiation;
    property ClientCertificateRequired: Boolean read get_ClientCertificateRequired write set_ClientCertificateRequired;
    property ApplicationProtocols: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol> read get_ApplicationProtocols write set_ApplicationProtocols;
    property RemoteCertificateValidationCallback: DNRemoteCertificateValidationCallback read get_RemoteCertificateValidationCallback write set_RemoteCertificateValidationCallback;
    property ServerCertificateSelectionCallback: DNServerCertificateSelectionCallback read get_ServerCertificateSelectionCallback write set_ServerCertificateSelectionCallback;
    property ServerCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate read get_ServerCertificate write set_ServerCertificate;
    property EnabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols read get_EnabledSslProtocols write set_EnabledSslProtocols;
    property CertificateRevocationCheckMode: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode read get_CertificateRevocationCheckMode write set_CertificateRevocationCheckMode;
    property EncryptionPolicy: DNEncryptionPolicy read get_EncryptionPolicy write set_EncryptionPolicy;
    property CipherSuitesPolicy: DNCipherSuitesPolicy read get_CipherSuitesPolicy write set_CipherSuitesPolicy;
  end;

  TDNSslServerAuthenticationOptions = class(TDNGenericImport<DNSslServerAuthenticationOptionsClass, DNSslServerAuthenticationOptions>) end;

  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  DNExtendedProtectionPolicyClass = interface(DNObjectClass)
  ['{FAAA719D-695D-566C-8066-B017B583F443}']
  { static getter & setter } 

    {class} function get_OSSupportsExtendedProtection: Boolean;

  { constructors } 

    {class} function init(policyEnforcement: DNPolicyEnforcement; protectionScenario: DNProtectionScenario; customServiceNames: DNServiceNameCollection): DNExtendedProtectionPolicy; overload;
    {class} function init(policyEnforcement: DNPolicyEnforcement; protectionScenario: DNProtectionScenario; customServiceNames: DDNC.System.Private.CoreLib.DNICollection): DNExtendedProtectionPolicy; overload;
    {class} function init(policyEnforcement: DNPolicyEnforcement; customChannelBinding: DDNC.System.Net.Primitives.DNChannelBinding): DNExtendedProtectionPolicy; overload;
    {class} function init(policyEnforcement: DNPolicyEnforcement): DNExtendedProtectionPolicy; overload;

  { static propertys } 

    {class} property OSSupportsExtendedProtection: Boolean read get_OSSupportsExtendedProtection;
  end;

  [DNTypeName('System.Security.Authentication.ExtendedProtection.ExtendedProtectionPolicy')]
  DNExtendedProtectionPolicy = interface(DDNC.System.Private.CoreLib.DNISerializable)
  ['{F550F73E-02C7-3F78-A64C-28D48F1300CC}']
  { getters & setters } 

    function get_CustomServiceNames: DNServiceNameCollection;
    function get_PolicyEnforcement: DNPolicyEnforcement;
    function get_ProtectionScenario: DNProtectionScenario;
    function get_CustomChannelBinding: DDNC.System.Net.Primitives.DNChannelBinding;

  { methods } 

    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property CustomServiceNames: DNServiceNameCollection read get_CustomServiceNames;
    property PolicyEnforcement: DNPolicyEnforcement read get_PolicyEnforcement;
    property ProtectionScenario: DNProtectionScenario read get_ProtectionScenario;
    property CustomChannelBinding: DDNC.System.Net.Primitives.DNChannelBinding read get_CustomChannelBinding;
  end;

  TDNExtendedProtectionPolicy = class(TDNGenericImport<DNExtendedProtectionPolicyClass, DNExtendedProtectionPolicy>) end;

  //-------------namespace: System.Net.Security----------------
  DNSslApplicationProtocolClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{8DFF34D7-6086-5C07-B7F9-76D9C11F3386}']
  { constructors } 

    {class} function init(protocol: TArray<Byte>): DNSslApplicationProtocol; overload;
    {class} function init(protocol: string): DNSslApplicationProtocol; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_Http2: DNSslApplicationProtocol;
   function __fakeFieldGet_Http11: DNSslApplicationProtocol;

  { static fields } 

    {class} property Http2: DNSslApplicationProtocol read __fakeFieldGet_Http2;
    {class} property Http11: DNSslApplicationProtocol read __fakeFieldGet_Http11;

  end;

  [DNTypeName('System.Net.Security.SslApplicationProtocol')]
  DNSslApplicationProtocol = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{E16CD728-DDDD-3DAE-A162-E1B0FDA76BC8}']
  { getters & setters } 

    function get_Protocol: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>;

  { methods } 

    function Equals(other: DNSslApplicationProtocol): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Protocol: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte> read get_Protocol;
  end;

  TDNSslApplicationProtocol = class(TDNGenericImport<DNSslApplicationProtocolClass, DNSslApplicationProtocol>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.Security, Version=4.1.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
