//----------------------------------------------------------------------------
//  System.Net.Requests.dll: System.Net.Requests, Version=4.1.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.Requests
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.Requests;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Net.Primitives,
  DDNC.System.Private.Uri,
  DDNC.System.Net.WebHeaderCollection,
  DDNC.System.Security.Principal,
  DDNC.System.Net.ServicePoint,
  DDNC.System.Security.Cryptography.X509Certificates,
  DDNC.System.Net.Security,
  DDNC.System.Collections.Specialized;

type

{ enums }

  //-------------namespace: System.Net.Cache----------------
  [DNTypeName('System.Net.Cache.HttpCacheAgeControl')]
  DNHttpCacheAgeControl = type Integer;
  DNHttpCacheAgeControlHelper = record helper for DNHttpCacheAgeControl
  public const
    None = 0;
    MinFresh = 1;
    MaxAge = 2;
    MaxAgeAndMinFresh = 3;
    MaxStale = 4;
    MaxAgeAndMaxStale = 6;
  end;


  //-------------namespace: System.Net.Cache----------------
  [DNTypeName('System.Net.Cache.HttpRequestCacheLevel')]
  DNHttpRequestCacheLevel = type Integer;
  DNHttpRequestCacheLevelHelper = record helper for DNHttpRequestCacheLevel
  public const
    Default_ = 0;
    BypassCache = 1;
    CacheOnly = 2;
    CacheIfAvailable = 3;
    Revalidate = 4;
    Reload = 5;
    NoCacheNoStore = 6;
    CacheOrNextCacheOnly = 7;
    Refresh = 8;
  end;


  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.FtpStatusCode')]
  DNFtpStatusCode = type Integer;
  DNFtpStatusCodeHelper = record helper for DNFtpStatusCode
  public const
    Undefined = 0;
    RestartMarker = 110;
    ServiceTemporarilyNotAvailable = 120;
    DataAlreadyOpen = 125;
    OpeningData = 150;
    CommandOK = 200;
    CommandExtraneous = 202;
    DirectoryStatus = 212;
    FileStatus = 213;
    SystemType = 215;
    SendUserCommand = 220;
    ClosingControl = 221;
    ClosingData = 226;
    EnteringPassive = 227;
    LoggedInProceed = 230;
    ServerWantsSecureSession = 234;
    FileActionOK = 250;
    PathnameCreated = 257;
    SendPasswordCommand = 331;
    NeedLoginAccount = 332;
    FileCommandPending = 350;
    ServiceNotAvailable = 421;
    CantOpenData = 425;
    ConnectionClosed = 426;
    ActionNotTakenFileUnavailableOrBusy = 450;
    ActionAbortedLocalProcessingError = 451;
    ActionNotTakenInsufficientSpace = 452;
    CommandSyntaxError = 500;
    ArgumentSyntaxError = 501;
    CommandNotImplemented = 502;
    BadCommandSequence = 503;
    NotLoggedIn = 530;
    AccountNeeded = 532;
    ActionNotTakenFileUnavailable = 550;
    ActionAbortedUnknownPageType = 551;
    FileActionAborted = 552;
    ActionNotTakenFilenameNotAllowed = 553;
  end;


  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.WebExceptionStatus')]
  DNWebExceptionStatus = type Integer;
  DNWebExceptionStatusHelper = record helper for DNWebExceptionStatus
  public const
    Success = 0;
    NameResolutionFailure = 1;
    ConnectFailure = 2;
    ReceiveFailure = 3;
    SendFailure = 4;
    PipelineFailure = 5;
    RequestCanceled = 6;
    ProtocolError = 7;
    ConnectionClosed = 8;
    TrustFailure = 9;
    SecureChannelFailure = 10;
    ServerProtocolViolation = 11;
    KeepAliveFailure = 12;
    Pending = 13;
    Timeout = 14;
    ProxyNameResolutionFailure = 15;
    UnknownError = 16;
    MessageLengthLimitExceeded = 17;
    CacheEntryNotFound = 18;
    RequestProhibitedByCachePolicy = 19;
    RequestProhibitedByProxy = 20;
  end;




type


{ declares }

  DNIAuthenticationModule = interface; // type: System.Net.IAuthenticationModule, namespace: System.Net
  DNICredentialPolicy = interface; // type: System.Net.ICredentialPolicy, namespace: System.Net
  DNIWebRequestCreate = interface; // type: System.Net.IWebRequestCreate, namespace: System.Net
  DNProtocolViolationException = interface; // type: System.Net.ProtocolViolationException, namespace: System.Net
  DNWebException = interface; // type: System.Net.WebException, namespace: System.Net
  DNWebRequest = interface; // type: System.Net.WebRequest, namespace: System.Net
  DNFileWebRequest = interface; // type: System.Net.FileWebRequest, namespace: System.Net
  DNFtpWebRequest = interface; // type: System.Net.FtpWebRequest, namespace: System.Net
  DNHttpWebRequest = interface; // type: System.Net.HttpWebRequest, namespace: System.Net
  DNWebResponse = interface; // type: System.Net.WebResponse, namespace: System.Net
  DNFileWebResponse = interface; // type: System.Net.FileWebResponse, namespace: System.Net
  DNFtpWebResponse = interface; // type: System.Net.FtpWebResponse, namespace: System.Net
  DNHttpWebResponse = interface; // type: System.Net.HttpWebResponse, namespace: System.Net
  DNAuthenticationManager = interface; // type: System.Net.AuthenticationManager, namespace: System.Net
  DNAuthorization = interface; // type: System.Net.Authorization, namespace: System.Net
  DNHttpRequestCachePolicy = interface; // type: System.Net.Cache.HttpRequestCachePolicy, namespace: System.Net.Cache
  DNGlobalProxySelection = interface; // type: System.Net.GlobalProxySelection, namespace: System.Net
  DNWebRequestMethods = interface; // type: System.Net.WebRequestMethods, namespace: System.Net
  DNWebRequestMethods_File = interface; // type: System.Net.WebRequestMethods+File, namespace: System.Net
  DNWebRequestMethods_Ftp = interface; // type: System.Net.WebRequestMethods+Ftp, namespace: System.Net
  DNWebRequestMethods_Http = interface; // type: System.Net.WebRequestMethods+Http, namespace: System.Net

{ delegates }

  [DNTypeName('System.Net.HttpContinueDelegate')]
  DNHttpContinueDelegate = procedure(StatusCode: Int32; httpHeaders: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection) of object;




{ objects }

  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.IAuthenticationModule')]
  DNIAuthenticationModule = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F9EA8965-6040-3595-998B-72D4EE883C3F}']
  { getters & setters } 

    function get_CanPreAuthenticate: Boolean;
    function get_AuthenticationType: string;

  { methods } 

    function Authenticate(challenge: string; request: DNWebRequest; credentials: DDNC.System.Net.Primitives.DNICredentials): DNAuthorization;
    function PreAuthenticate(request: DNWebRequest; credentials: DDNC.System.Net.Primitives.DNICredentials): DNAuthorization;

  { propertys } 

    property CanPreAuthenticate: Boolean read get_CanPreAuthenticate;
    property AuthenticationType: string read get_AuthenticationType;
  end;

  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.ICredentialPolicy')]
  DNICredentialPolicy = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C31393E0-E2EC-37C3-BA6C-BB46E1D0E1FE}']
  { methods } 

    function ShouldSendCredential(challengeUri: DDNC.System.Private.Uri.DNUri; request: DNWebRequest; credential: DDNC.System.Net.Primitives.DNNetworkCredential; authenticationModule: DNIAuthenticationModule): Boolean;

  end;

  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.IWebRequestCreate')]
  DNIWebRequestCreate = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9801F161-166F-3532-85DF-DB6C310570BE}']
  { methods } 

    function Create(uri: DDNC.System.Private.Uri.DNUri): DNWebRequest;

  end;

  //-------------namespace: System.Net----------------
  DNProtocolViolationExceptionClass = interface(DDNC.System.Private.CoreLib.DNInvalidOperationExceptionClass)
  ['{73D0EDB3-8609-5311-9770-36A9D49AFC40}']
  { constructors } 

    {class} function init: DNProtocolViolationException; overload;
    {class} function init(message: string): DNProtocolViolationException; overload;

  end;

  [DNTypeName('System.Net.ProtocolViolationException')]
  DNProtocolViolationException = interface(DDNC.System.Private.CoreLib.DNInvalidOperationException)
  ['{12277C5F-1BAA-3EB6-9DC2-8C40FEC1CF80}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(serializationInfo: DDNC.System.Private.CoreLib.DNSerializationInfo; streamingContext: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNProtocolViolationException = class(TDNGenericImport<DNProtocolViolationExceptionClass, DNProtocolViolationException>) end;

  //-------------namespace: System.Net----------------
  DNWebExceptionClass = interface(DDNC.System.Private.CoreLib.DNInvalidOperationExceptionClass)
  ['{7120DD79-45E6-53B0-8D28-86A2D6BB0AB9}']
  { constructors } 

    {class} function init: DNWebException; overload;
    {class} function init(message: string): DNWebException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNWebException; overload;
    {class} function init(message: string; status: DNWebExceptionStatus): DNWebException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException; status: DNWebExceptionStatus; response: DNWebResponse): DNWebException; overload;

  end;

  [DNTypeName('System.Net.WebException')]
  DNWebException = interface(DDNC.System.Private.CoreLib.DNInvalidOperationException)
  ['{0954621A-8628-3973-99EF-3A6EF81DDEE5}']
  { getters & setters } 

    function get_Status: DNWebExceptionStatus;
    function get_Response: DNWebResponse;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(serializationInfo: DDNC.System.Private.CoreLib.DNSerializationInfo; streamingContext: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Status: DNWebExceptionStatus read get_Status;
    property Response: DNWebResponse read get_Response;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNWebException = class(TDNGenericImport<DNWebExceptionClass, DNWebException>) end;

  //-------------namespace: System.Net----------------
  DNWebRequestClass = interface(DDNC.System.Private.CoreLib.DNMarshalByRefObjectClass)
  ['{6F6325E5-0393-5378-A08C-1E91C2A787C4}']
  { static getter & setter } 

    {class} function get_DefaultCachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy;
    {class} procedure set_DefaultCachePolicy(value: DDNC.System.Net.Primitives.DNRequestCachePolicy);
    {class} function get_DefaultWebProxy: DDNC.System.Net.Primitives.DNIWebProxy;
    {class} procedure set_DefaultWebProxy(value: DDNC.System.Net.Primitives.DNIWebProxy);

  { static methods } 

    {class} function Create(requestUriString: string): DNWebRequest; overload;
    {class} function Create(requestUri: DDNC.System.Private.Uri.DNUri): DNWebRequest; overload;
    {class} function CreateDefault(requestUri: DDNC.System.Private.Uri.DNUri): DNWebRequest;
    {class} function CreateHttp(requestUriString: string): DNHttpWebRequest; overload;
    {class} function CreateHttp(requestUri: DDNC.System.Private.Uri.DNUri): DNHttpWebRequest; overload;
    {class} function RegisterPrefix(prefix: string; creator: DNIWebRequestCreate): Boolean;
    {class} function GetSystemWebProxy: DDNC.System.Net.Primitives.DNIWebProxy;

  { static propertys } 

    {class} property DefaultCachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy read get_DefaultCachePolicy write set_DefaultCachePolicy;
    {class} property DefaultWebProxy: DDNC.System.Net.Primitives.DNIWebProxy read get_DefaultWebProxy write set_DefaultWebProxy;
  end;

  [DNTypeName('System.Net.WebRequest')]
  DNWebRequest = interface(DDNC.System.Private.CoreLib.DNMarshalByRefObject)
  ['{3BFD3C7B-35E7-3819-AAE0-EADABB7F93A5}']
  { getters & setters } 

    function get_CachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy;
    procedure set_CachePolicy(value: DDNC.System.Net.Primitives.DNRequestCachePolicy);
    function get_AuthenticationLevel: DDNC.System.Net.Primitives.DNAuthenticationLevel;
    procedure set_AuthenticationLevel(value: DDNC.System.Net.Primitives.DNAuthenticationLevel);
    function get_ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel;
    procedure set_ImpersonationLevel(value: DDNC.System.Security.Principal.DNTokenImpersonationLevel);
    function get_ConnectionGroupName: string;
    procedure set_ConnectionGroupName(value: string);
    function get_Method: string;
    procedure set_Method(value: string);
    function get_RequestUri: DDNC.System.Private.Uri.DNUri;
    function get_Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection;
    procedure set_Headers(value: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection);
    function get_ContentLength: Int64;
    procedure set_ContentLength(value: Int64);
    function get_ContentType: string;
    procedure set_ContentType(value: string);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_Timeout: Int32;
    procedure set_Timeout(value: Int32);
    function get_UseDefaultCredentials: Boolean;
    procedure set_UseDefaultCredentials(value: Boolean);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);

  { methods } 

    function GetRequestStream: DDNC.System.Private.CoreLib.DNStream;
    function GetResponse: DNWebResponse;
    function BeginGetResponse(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndGetResponse(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNWebResponse;
    function BeginGetRequestStream(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndGetRequestStream(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DDNC.System.Private.CoreLib.DNStream;
    function GetRequestStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function GetResponseAsync: DDNC.System.Private.CoreLib.DNTask<DNWebResponse>;
    procedure &Abort;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property CachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy read get_CachePolicy write set_CachePolicy;
    property AuthenticationLevel: DDNC.System.Net.Primitives.DNAuthenticationLevel read get_AuthenticationLevel write set_AuthenticationLevel;
    property ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel read get_ImpersonationLevel write set_ImpersonationLevel;
    property ConnectionGroupName: string read get_ConnectionGroupName write set_ConnectionGroupName;
    property Method: string read get_Method write set_Method;
    property RequestUri: DDNC.System.Private.Uri.DNUri read get_RequestUri;
    property Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection read get_Headers write set_Headers;
    property ContentLength: Int64 read get_ContentLength write set_ContentLength;
    property ContentType: string read get_ContentType write set_ContentType;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property Timeout: Int32 read get_Timeout write set_Timeout;
    property UseDefaultCredentials: Boolean read get_UseDefaultCredentials write set_UseDefaultCredentials;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
  end;

  TDNWebRequest = class(TDNGenericImport<DNWebRequestClass, DNWebRequest>) end;

  //-------------namespace: System.Net----------------
  DNFileWebRequestClass = interface(DNWebRequestClass)
  ['{72DB5379-872C-594B-920C-C5C353A9E105}']
  end;

  [DNTypeName('System.Net.FileWebRequest')]
  DNFileWebRequest = interface(DNWebRequest)
  ['{D2CE82B4-6429-3D9D-AA33-EA5EA883BA4D}']
  { getters & setters } 

    function get_ConnectionGroupName: string;
    procedure set_ConnectionGroupName(value: string);
    function get_ContentLength: Int64;
    procedure set_ContentLength(value: Int64);
    function get_ContentType: string;
    procedure set_ContentType(value: string);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection;
    function get_Method: string;
    procedure set_Method(value: string);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_Timeout: Int32;
    procedure set_Timeout(value: Int32);
    function get_RequestUri: DDNC.System.Private.Uri.DNUri;
    function get_UseDefaultCredentials: Boolean;
    procedure set_UseDefaultCredentials(value: Boolean);
    function get_CachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy;
    procedure set_CachePolicy(value: DDNC.System.Net.Primitives.DNRequestCachePolicy);
    function get_AuthenticationLevel: DDNC.System.Net.Primitives.DNAuthenticationLevel;
    procedure set_AuthenticationLevel(value: DDNC.System.Net.Primitives.DNAuthenticationLevel);
    function get_ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel;
    procedure set_ImpersonationLevel(value: DDNC.System.Security.Principal.DNTokenImpersonationLevel);

  { methods } 

    function BeginGetRequestStream(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function GetRequestStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function BeginGetResponse(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function GetResponseAsync: DDNC.System.Private.CoreLib.DNTask<DNWebResponse>;
    function EndGetRequestStream(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DDNC.System.Private.CoreLib.DNStream;
    function EndGetResponse(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNWebResponse;
    function GetRequestStream: DDNC.System.Private.CoreLib.DNStream;
    function GetResponse: DNWebResponse;
    procedure &Abort;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ConnectionGroupName: string read get_ConnectionGroupName write set_ConnectionGroupName;
    property ContentLength: Int64 read get_ContentLength write set_ContentLength;
    property ContentType: string read get_ContentType write set_ContentType;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection read get_Headers;
    property Method: string read get_Method write set_Method;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property Timeout: Int32 read get_Timeout write set_Timeout;
    property RequestUri: DDNC.System.Private.Uri.DNUri read get_RequestUri;
    property UseDefaultCredentials: Boolean read get_UseDefaultCredentials write set_UseDefaultCredentials;
    property CachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy read get_CachePolicy write set_CachePolicy;
    property AuthenticationLevel: DDNC.System.Net.Primitives.DNAuthenticationLevel read get_AuthenticationLevel write set_AuthenticationLevel;
    property ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel read get_ImpersonationLevel write set_ImpersonationLevel;
  end;

  TDNFileWebRequest = class(TDNGenericImport<DNFileWebRequestClass, DNFileWebRequest>) end;

  //-------------namespace: System.Net----------------
  DNFtpWebRequestClass = interface(DNWebRequestClass)
  ['{DD9B1037-EC3C-59C6-8D6D-66CF85AC982E}']
  { static getter & setter } 

    {class} function get_DefaultCachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy;
    {class} procedure set_DefaultCachePolicy(value: DDNC.System.Net.Primitives.DNRequestCachePolicy);

  { static propertys } 

    {class} property DefaultCachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy read get_DefaultCachePolicy write set_DefaultCachePolicy;
  end;

  [DNTypeName('System.Net.FtpWebRequest')]
  DNFtpWebRequest = interface(DNWebRequest)
  ['{30ACE327-9173-360E-A074-936430FB81B9}']
  { getters & setters } 

    function get_Method: string;
    procedure set_Method(value: string);
    function get_RenameTo: string;
    procedure set_RenameTo(value: string);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_RequestUri: DDNC.System.Private.Uri.DNUri;
    function get_Timeout: Int32;
    procedure set_Timeout(value: Int32);
    function get_ReadWriteTimeout: Int32;
    procedure set_ReadWriteTimeout(value: Int32);
    function get_ContentOffset: Int64;
    procedure set_ContentOffset(value: Int64);
    function get_ContentLength: Int64;
    procedure set_ContentLength(value: Int64);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_ConnectionGroupName: string;
    procedure set_ConnectionGroupName(value: string);
    function get_ServicePoint: DDNC.System.Net.ServicePoint.DNServicePoint;
    function get_KeepAlive: Boolean;
    procedure set_KeepAlive(value: Boolean);
    function get_CachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy;
    procedure set_CachePolicy(value: DDNC.System.Net.Primitives.DNRequestCachePolicy);
    function get_UseBinary: Boolean;
    procedure set_UseBinary(value: Boolean);
    function get_UsePassive: Boolean;
    procedure set_UsePassive(value: Boolean);
    function get_ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection;
    procedure set_ClientCertificates(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection);
    function get_EnableSsl: Boolean;
    procedure set_EnableSsl(value: Boolean);
    function get_Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection;
    procedure set_Headers(value: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection);
    function get_ContentType: string;
    procedure set_ContentType(value: string);
    function get_UseDefaultCredentials: Boolean;
    procedure set_UseDefaultCredentials(value: Boolean);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_AuthenticationLevel: DDNC.System.Net.Primitives.DNAuthenticationLevel;
    procedure set_AuthenticationLevel(value: DDNC.System.Net.Primitives.DNAuthenticationLevel);
    function get_ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel;
    procedure set_ImpersonationLevel(value: DDNC.System.Security.Principal.DNTokenImpersonationLevel);

  { methods } 

    function GetResponse: DNWebResponse;
    function BeginGetResponse(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndGetResponse(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNWebResponse;
    function GetRequestStream: DDNC.System.Private.CoreLib.DNStream;
    function BeginGetRequestStream(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndGetRequestStream(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DDNC.System.Private.CoreLib.DNStream;
    procedure &Abort;
    function GetRequestStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function GetResponseAsync: DDNC.System.Private.CoreLib.DNTask<DNWebResponse>;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Method: string read get_Method write set_Method;
    property RenameTo: string read get_RenameTo write set_RenameTo;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property RequestUri: DDNC.System.Private.Uri.DNUri read get_RequestUri;
    property Timeout: Int32 read get_Timeout write set_Timeout;
    property ReadWriteTimeout: Int32 read get_ReadWriteTimeout write set_ReadWriteTimeout;
    property ContentOffset: Int64 read get_ContentOffset write set_ContentOffset;
    property ContentLength: Int64 read get_ContentLength write set_ContentLength;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property ConnectionGroupName: string read get_ConnectionGroupName write set_ConnectionGroupName;
    property ServicePoint: DDNC.System.Net.ServicePoint.DNServicePoint read get_ServicePoint;
    property KeepAlive: Boolean read get_KeepAlive write set_KeepAlive;
    property CachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy read get_CachePolicy write set_CachePolicy;
    property UseBinary: Boolean read get_UseBinary write set_UseBinary;
    property UsePassive: Boolean read get_UsePassive write set_UsePassive;
    property ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection read get_ClientCertificates write set_ClientCertificates;
    property EnableSsl: Boolean read get_EnableSsl write set_EnableSsl;
    property Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection read get_Headers write set_Headers;
    property ContentType: string read get_ContentType write set_ContentType;
    property UseDefaultCredentials: Boolean read get_UseDefaultCredentials write set_UseDefaultCredentials;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property AuthenticationLevel: DDNC.System.Net.Primitives.DNAuthenticationLevel read get_AuthenticationLevel write set_AuthenticationLevel;
    property ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel read get_ImpersonationLevel write set_ImpersonationLevel;
  end;

  TDNFtpWebRequest = class(TDNGenericImport<DNFtpWebRequestClass, DNFtpWebRequest>) end;

  //-------------namespace: System.Net----------------
  DNHttpWebRequestClass = interface(DNWebRequestClass)
  ['{FA74B586-4493-5570-B215-3B9C730338D6}']
  { static getter & setter } 

    {class} function get_DefaultMaximumResponseHeadersLength: Int32;
    {class} procedure set_DefaultMaximumResponseHeadersLength(value: Int32);
    {class} function get_DefaultMaximumErrorResponseLength: Int32;
    {class} procedure set_DefaultMaximumErrorResponseLength(value: Int32);
    {class} function get_DefaultCachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy;
    {class} procedure set_DefaultCachePolicy(value: DDNC.System.Net.Primitives.DNRequestCachePolicy);

  { constructors } 

    {class} function init: DNHttpWebRequest;

  { static propertys } 

    {class} property DefaultMaximumResponseHeadersLength: Int32 read get_DefaultMaximumResponseHeadersLength write set_DefaultMaximumResponseHeadersLength;
    {class} property DefaultMaximumErrorResponseLength: Int32 read get_DefaultMaximumErrorResponseLength write set_DefaultMaximumErrorResponseLength;
    {class} property DefaultCachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy read get_DefaultCachePolicy write set_DefaultCachePolicy;
  end;

  [DNTypeName('System.Net.HttpWebRequest')]
  DNHttpWebRequest = interface(DNWebRequest)
  ['{7C51848F-37DC-35F8-93FD-776D3F22B396}']
  { getters & setters } 

    function get_Accept: string;
    procedure set_Accept(value: string);
    function get_AllowReadStreamBuffering: Boolean;
    procedure set_AllowReadStreamBuffering(value: Boolean);
    function get_MaximumResponseHeadersLength: Int32;
    procedure set_MaximumResponseHeadersLength(value: Int32);
    function get_MaximumAutomaticRedirections: Int32;
    procedure set_MaximumAutomaticRedirections(value: Int32);
    function get_ContentType: string;
    procedure set_ContentType(value: string);
    function get_ContinueTimeout: Int32;
    procedure set_ContinueTimeout(value: Int32);
    function get_Timeout: Int32;
    procedure set_Timeout(value: Int32);
    function get_ContentLength: Int64;
    procedure set_ContentLength(value: Int64);
    function get_Address: DDNC.System.Private.Uri.DNUri;
    function get_UserAgent: string;
    procedure set_UserAgent(value: string);
    function get_Host: string;
    procedure set_Host(value: string);
    function get_Pipelined: Boolean;
    procedure set_Pipelined(value: Boolean);
    function get_Referer: string;
    procedure set_Referer(value: string);
    function get_MediaType: string;
    procedure set_MediaType(value: string);
    function get_TransferEncoding: string;
    procedure set_TransferEncoding(value: string);
    function get_KeepAlive: Boolean;
    procedure set_KeepAlive(value: Boolean);
    function get_UnsafeAuthenticatedConnectionSharing: Boolean;
    procedure set_UnsafeAuthenticatedConnectionSharing(value: Boolean);
    function get_AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods;
    procedure set_AutomaticDecompression(value: DDNC.System.Net.Primitives.DNDecompressionMethods);
    function get_AllowWriteStreamBuffering: Boolean;
    procedure set_AllowWriteStreamBuffering(value: Boolean);
    function get_AllowAutoRedirect: Boolean;
    procedure set_AllowAutoRedirect(value: Boolean);
    function get_ConnectionGroupName: string;
    procedure set_ConnectionGroupName(value: string);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_Connection: string;
    procedure set_Connection(value: string);
    function get_Expect: string;
    procedure set_Expect(value: string);
    function get_IfModifiedSince: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_IfModifiedSince(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_Date: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_Date(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_SendChunked: Boolean;
    procedure set_SendChunked(value: Boolean);
    function get_ContinueDelegate: DNHttpContinueDelegate;
    procedure set_ContinueDelegate(value: DNHttpContinueDelegate);
    function get_ServicePoint: DDNC.System.Net.ServicePoint.DNServicePoint;
    function get_ServerCertificateValidationCallback: DDNC.System.Net.Security.DNRemoteCertificateValidationCallback;
    procedure set_ServerCertificateValidationCallback(value: DDNC.System.Net.Security.DNRemoteCertificateValidationCallback);
    function get_ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection;
    procedure set_ClientCertificates(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection);
    function get_ProtocolVersion: DDNC.System.Private.CoreLib.DNVersion;
    procedure set_ProtocolVersion(value: DDNC.System.Private.CoreLib.DNVersion);
    function get_ReadWriteTimeout: Int32;
    procedure set_ReadWriteTimeout(value: Int32);
    function get_CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer;
    procedure set_CookieContainer(value: DDNC.System.Net.Primitives.DNCookieContainer);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_HaveResponse: Boolean;
    function get_Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection;
    procedure set_Headers(value: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection);
    function get_Method: string;
    procedure set_Method(value: string);
    function get_RequestUri: DDNC.System.Private.Uri.DNUri;
    function get_SupportsCookieContainer: Boolean;
    function get_UseDefaultCredentials: Boolean;
    procedure set_UseDefaultCredentials(value: Boolean);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_CachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy;
    procedure set_CachePolicy(value: DDNC.System.Net.Primitives.DNRequestCachePolicy);
    function get_AuthenticationLevel: DDNC.System.Net.Primitives.DNAuthenticationLevel;
    procedure set_AuthenticationLevel(value: DDNC.System.Net.Primitives.DNAuthenticationLevel);
    function get_ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel;
    procedure set_ImpersonationLevel(value: DDNC.System.Security.Principal.DNTokenImpersonationLevel);

  { methods } 

    function EndGetRequestStream(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult; out context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNStream; overload;
    function GetRequestStream(out context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNStream; overload;
    function BeginGetRequestStream(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndGetRequestStream(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DDNC.System.Private.CoreLib.DNStream; overload;
    function BeginGetResponse(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndGetResponse(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNWebResponse;
    procedure AddRange(from: Int32; &to: Int32); overload;
    procedure AddRange(from: Int64; &to: Int64); overload;
    procedure AddRange(range: Int32); overload;
    procedure AddRange(range: Int64); overload;
    procedure AddRange(rangeSpecifier: string; from: Int32; &to: Int32); overload;
    procedure AddRange(rangeSpecifier: string; from: Int64; &to: Int64); overload;
    procedure AddRange(rangeSpecifier: string; range: Int32); overload;
    procedure AddRange(rangeSpecifier: string; range: Int64); overload;
    procedure &Abort;
    function GetResponse: DNWebResponse;
    function GetRequestStream: DDNC.System.Private.CoreLib.DNStream; overload;
    function GetRequestStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function GetResponseAsync: DDNC.System.Private.CoreLib.DNTask<DNWebResponse>;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Accept: string read get_Accept write set_Accept;
    property AllowReadStreamBuffering: Boolean read get_AllowReadStreamBuffering write set_AllowReadStreamBuffering;
    property MaximumResponseHeadersLength: Int32 read get_MaximumResponseHeadersLength write set_MaximumResponseHeadersLength;
    property MaximumAutomaticRedirections: Int32 read get_MaximumAutomaticRedirections write set_MaximumAutomaticRedirections;
    property ContentType: string read get_ContentType write set_ContentType;
    property ContinueTimeout: Int32 read get_ContinueTimeout write set_ContinueTimeout;
    property Timeout: Int32 read get_Timeout write set_Timeout;
    property ContentLength: Int64 read get_ContentLength write set_ContentLength;
    property Address: DDNC.System.Private.Uri.DNUri read get_Address;
    property UserAgent: string read get_UserAgent write set_UserAgent;
    property Host: string read get_Host write set_Host;
    property Pipelined: Boolean read get_Pipelined write set_Pipelined;
    property Referer: string read get_Referer write set_Referer;
    property MediaType: string read get_MediaType write set_MediaType;
    property TransferEncoding: string read get_TransferEncoding write set_TransferEncoding;
    property KeepAlive: Boolean read get_KeepAlive write set_KeepAlive;
    property UnsafeAuthenticatedConnectionSharing: Boolean read get_UnsafeAuthenticatedConnectionSharing write set_UnsafeAuthenticatedConnectionSharing;
    property AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods read get_AutomaticDecompression write set_AutomaticDecompression;
    property AllowWriteStreamBuffering: Boolean read get_AllowWriteStreamBuffering write set_AllowWriteStreamBuffering;
    property AllowAutoRedirect: Boolean read get_AllowAutoRedirect write set_AllowAutoRedirect;
    property ConnectionGroupName: string read get_ConnectionGroupName write set_ConnectionGroupName;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property Connection: string read get_Connection write set_Connection;
    property Expect: string read get_Expect write set_Expect;
    property IfModifiedSince: DDNC.System.Private.CoreLib.DNDateTime read get_IfModifiedSince write set_IfModifiedSince;
    property Date: DDNC.System.Private.CoreLib.DNDateTime read get_Date write set_Date;
    property SendChunked: Boolean read get_SendChunked write set_SendChunked;
    property ContinueDelegate: DNHttpContinueDelegate read get_ContinueDelegate write set_ContinueDelegate;
    property ServicePoint: DDNC.System.Net.ServicePoint.DNServicePoint read get_ServicePoint;
    property ServerCertificateValidationCallback: DDNC.System.Net.Security.DNRemoteCertificateValidationCallback read get_ServerCertificateValidationCallback write set_ServerCertificateValidationCallback;
    property ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection read get_ClientCertificates write set_ClientCertificates;
    property ProtocolVersion: DDNC.System.Private.CoreLib.DNVersion read get_ProtocolVersion write set_ProtocolVersion;
    property ReadWriteTimeout: Int32 read get_ReadWriteTimeout write set_ReadWriteTimeout;
    property CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer read get_CookieContainer write set_CookieContainer;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property HaveResponse: Boolean read get_HaveResponse;
    property Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection read get_Headers write set_Headers;
    property Method: string read get_Method write set_Method;
    property RequestUri: DDNC.System.Private.Uri.DNUri read get_RequestUri;
    property SupportsCookieContainer: Boolean read get_SupportsCookieContainer;
    property UseDefaultCredentials: Boolean read get_UseDefaultCredentials write set_UseDefaultCredentials;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property CachePolicy: DDNC.System.Net.Primitives.DNRequestCachePolicy read get_CachePolicy write set_CachePolicy;
    property AuthenticationLevel: DDNC.System.Net.Primitives.DNAuthenticationLevel read get_AuthenticationLevel write set_AuthenticationLevel;
    property ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel read get_ImpersonationLevel write set_ImpersonationLevel;
  end;

  TDNHttpWebRequest = class(TDNGenericImport<DNHttpWebRequestClass, DNHttpWebRequest>) end;

  //-------------namespace: System.Net----------------
  DNWebResponseClass = interface(DDNC.System.Private.CoreLib.DNMarshalByRefObjectClass)
  ['{9DDE9763-BFAA-55BD-B955-D6044881F290}']
  end;

  [DNTypeName('System.Net.WebResponse')]
  DNWebResponse = interface(DDNC.System.Private.CoreLib.DNMarshalByRefObject)
  ['{9520B34E-C15C-31C8-8CBB-23D2C645696A}']
  { getters & setters } 

    function get_ContentLength: Int64;
    procedure set_ContentLength(value: Int64);
    function get_ContentType: string;
    procedure set_ContentType(value: string);
    function get_IsFromCache: Boolean;
    function get_IsMutuallyAuthenticated: Boolean;
    function get_ResponseUri: DDNC.System.Private.Uri.DNUri;
    function get_Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection;
    function get_SupportsHeaders: Boolean;

  { methods } 

    procedure Close;
    procedure Dispose;
    function GetResponseStream: DDNC.System.Private.CoreLib.DNStream;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ContentLength: Int64 read get_ContentLength write set_ContentLength;
    property ContentType: string read get_ContentType write set_ContentType;
    property IsFromCache: Boolean read get_IsFromCache;
    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
    property ResponseUri: DDNC.System.Private.Uri.DNUri read get_ResponseUri;
    property Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection read get_Headers;
    property SupportsHeaders: Boolean read get_SupportsHeaders;
  end;

  TDNWebResponse = class(TDNGenericImport<DNWebResponseClass, DNWebResponse>) end;

  //-------------namespace: System.Net----------------
  DNFileWebResponseClass = interface(DNWebResponseClass)
  ['{3D07FF1F-4B09-5EC2-AEA5-26178703D700}']
  end;

  [DNTypeName('System.Net.FileWebResponse')]
  DNFileWebResponse = interface(DNWebResponse)
  ['{0526A512-DC20-3EF2-810C-AAC52DE556CA}']
  { getters & setters } 

    function get_ContentLength: Int64;
    function get_ContentType: string;
    function get_Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection;
    function get_SupportsHeaders: Boolean;
    function get_ResponseUri: DDNC.System.Private.Uri.DNUri;
    function get_IsFromCache: Boolean;
    function get_IsMutuallyAuthenticated: Boolean;

  { methods } 

    procedure Close;
    function GetResponseStream: DDNC.System.Private.CoreLib.DNStream;
    procedure Dispose;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ContentLength: Int64 read get_ContentLength;
    property ContentType: string read get_ContentType;
    property Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection read get_Headers;
    property SupportsHeaders: Boolean read get_SupportsHeaders;
    property ResponseUri: DDNC.System.Private.Uri.DNUri read get_ResponseUri;
    property IsFromCache: Boolean read get_IsFromCache;
    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
  end;

  TDNFileWebResponse = class(TDNGenericImport<DNFileWebResponseClass, DNFileWebResponse>) end;

  //-------------namespace: System.Net----------------
  DNFtpWebResponseClass = interface(DNWebResponseClass)
  ['{565C1B62-96A8-57DC-8E72-809BCEC2C661}']
  end;

  [DNTypeName('System.Net.FtpWebResponse')]
  DNFtpWebResponse = interface(DNWebResponse)
  ['{8C2EE23F-E481-39EF-B324-B05F7EDE9C2C}']
  { getters & setters } 

    function get_ContentLength: Int64;
    function get_Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection;
    function get_SupportsHeaders: Boolean;
    function get_ResponseUri: DDNC.System.Private.Uri.DNUri;
    function get_StatusCode: DNFtpStatusCode;
    function get_StatusDescription: string;
    function get_LastModified: DDNC.System.Private.CoreLib.DNDateTime;
    function get_BannerMessage: string;
    function get_WelcomeMessage: string;
    function get_ExitMessage: string;
    function get_ContentType: string;
    procedure set_ContentType(value: string);
    function get_IsFromCache: Boolean;
    function get_IsMutuallyAuthenticated: Boolean;

  { methods } 

    function GetResponseStream: DDNC.System.Private.CoreLib.DNStream;
    procedure Close;
    procedure Dispose;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ContentLength: Int64 read get_ContentLength;
    property Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection read get_Headers;
    property SupportsHeaders: Boolean read get_SupportsHeaders;
    property ResponseUri: DDNC.System.Private.Uri.DNUri read get_ResponseUri;
    property StatusCode: DNFtpStatusCode read get_StatusCode;
    property StatusDescription: string read get_StatusDescription;
    property LastModified: DDNC.System.Private.CoreLib.DNDateTime read get_LastModified;
    property BannerMessage: string read get_BannerMessage;
    property WelcomeMessage: string read get_WelcomeMessage;
    property ExitMessage: string read get_ExitMessage;
    property ContentType: string read get_ContentType write set_ContentType;
    property IsFromCache: Boolean read get_IsFromCache;
    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
  end;

  TDNFtpWebResponse = class(TDNGenericImport<DNFtpWebResponseClass, DNFtpWebResponse>) end;

  //-------------namespace: System.Net----------------
  DNHttpWebResponseClass = interface(DNWebResponseClass)
  ['{6DD6DE80-3684-5314-AC70-20C5CD8A1FEB}']
  { constructors } 

    {class} function init: DNHttpWebResponse;

  end;

  [DNTypeName('System.Net.HttpWebResponse')]
  DNHttpWebResponse = interface(DNWebResponse)
  ['{68D017FC-4A6C-33A4-8858-5BDDD8FFDB90}']
  { getters & setters } 

    function get_IsMutuallyAuthenticated: Boolean;
    function get_ContentLength: Int64;
    function get_ContentType: string;
    function get_ContentEncoding: string;
    function get_Cookies: DDNC.System.Net.Primitives.DNCookieCollection;
    procedure set_Cookies(value: DDNC.System.Net.Primitives.DNCookieCollection);
    function get_LastModified: DDNC.System.Private.CoreLib.DNDateTime;
    function get_Server: string;
    function get_ProtocolVersion: DDNC.System.Private.CoreLib.DNVersion;
    function get_Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection;
    function get_Method: string;
    function get_ResponseUri: DDNC.System.Private.Uri.DNUri;
    function get_StatusCode: DDNC.System.Net.Primitives.DNHttpStatusCode;
    function get_StatusDescription: string;
    function get_CharacterSet: string;
    function get_SupportsHeaders: Boolean;
    function get_IsFromCache: Boolean;

  { methods } 

    function GetResponseStream: DDNC.System.Private.CoreLib.DNStream;
    function GetResponseHeader(headerName: string): string;
    procedure Close;
    procedure Dispose;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
    property ContentLength: Int64 read get_ContentLength;
    property ContentType: string read get_ContentType;
    property ContentEncoding: string read get_ContentEncoding;
    property Cookies: DDNC.System.Net.Primitives.DNCookieCollection read get_Cookies write set_Cookies;
    property LastModified: DDNC.System.Private.CoreLib.DNDateTime read get_LastModified;
    property Server: string read get_Server;
    property ProtocolVersion: DDNC.System.Private.CoreLib.DNVersion read get_ProtocolVersion;
    property Headers: DDNC.System.Net.WebHeaderCollection.DNWebHeaderCollection read get_Headers;
    property Method: string read get_Method;
    property ResponseUri: DDNC.System.Private.Uri.DNUri read get_ResponseUri;
    property StatusCode: DDNC.System.Net.Primitives.DNHttpStatusCode read get_StatusCode;
    property StatusDescription: string read get_StatusDescription;
    property CharacterSet: string read get_CharacterSet;
    property SupportsHeaders: Boolean read get_SupportsHeaders;
    property IsFromCache: Boolean read get_IsFromCache;
  end;

  TDNHttpWebResponse = class(TDNGenericImport<DNHttpWebResponseClass, DNHttpWebResponse>) end;

  //-------------namespace: System.Net----------------
  DNAuthenticationManagerClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{85539C69-3DA7-5D35-89A9-FE2B1CB91B22}']
  { static getter & setter } 

    {class} function get_CredentialPolicy: DNICredentialPolicy;
    {class} procedure set_CredentialPolicy(value: DNICredentialPolicy);
    {class} function get_CustomTargetNameDictionary: DDNC.System.Collections.Specialized.DNStringDictionary;
    {class} function get_RegisteredModules: DDNC.System.Private.CoreLib.DNIEnumerator;

  { static methods } 

    {class} function Authenticate(challenge: string; request: DNWebRequest; credentials: DDNC.System.Net.Primitives.DNICredentials): DNAuthorization;
    {class} function PreAuthenticate(request: DNWebRequest; credentials: DDNC.System.Net.Primitives.DNICredentials): DNAuthorization;
    {class} procedure &Register(authenticationModule: DNIAuthenticationModule);
    {class} procedure Unregister(authenticationModule: DNIAuthenticationModule); overload;
    {class} procedure Unregister(authenticationScheme: string); overload;

  { static propertys } 

    {class} property CredentialPolicy: DNICredentialPolicy read get_CredentialPolicy write set_CredentialPolicy;
    {class} property CustomTargetNameDictionary: DDNC.System.Collections.Specialized.DNStringDictionary read get_CustomTargetNameDictionary;
    {class} property RegisteredModules: DDNC.System.Private.CoreLib.DNIEnumerator read get_RegisteredModules;
  end;

  [DNTypeName('System.Net.AuthenticationManager')]
  DNAuthenticationManager = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9E57B058-C259-30B4-B3E0-8A346A7222B4}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNAuthenticationManager = class(TDNGenericImport<DNAuthenticationManagerClass, DNAuthenticationManager>) end;

  //-------------namespace: System.Net----------------
  DNAuthorizationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{FE30D64C-2A6F-5847-87F1-70A5A0879DE5}']
  { constructors } 

    {class} function init(token: string): DNAuthorization; overload;
    {class} function init(token: string; finished: Boolean): DNAuthorization; overload;
    {class} function init(token: string; finished: Boolean; connectionGroupId: string): DNAuthorization; overload;

  end;

  [DNTypeName('System.Net.Authorization')]
  DNAuthorization = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{38790294-5279-3C2F-AB59-F7306D129EBD}']
  { getters & setters } 

    function get_Message: string;
    function get_ConnectionGroupId: string;
    function get_Complete: Boolean;
    function get_ProtectionRealm: TArray<string>;
    procedure set_ProtectionRealm(value: TArray<string>);
    function get_MutuallyAuthenticated: Boolean;
    procedure set_MutuallyAuthenticated(value: Boolean);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property ConnectionGroupId: string read get_ConnectionGroupId;
    property Complete: Boolean read get_Complete;
    property ProtectionRealm: TArray<string> read get_ProtectionRealm write set_ProtectionRealm;
    property MutuallyAuthenticated: Boolean read get_MutuallyAuthenticated write set_MutuallyAuthenticated;
  end;

  TDNAuthorization = class(TDNGenericImport<DNAuthorizationClass, DNAuthorization>) end;

  //-------------namespace: System.Net.Cache----------------
  DNHttpRequestCachePolicyClass = interface(DNObjectClass)
  ['{CCCEC5D0-67BE-599D-AE58-55B85033A6D4}']
  { constructors } 

    {class} function init: DNHttpRequestCachePolicy; overload;
    {class} function init(level: DNHttpRequestCacheLevel): DNHttpRequestCachePolicy; overload;
    {class} function init(cacheAgeControl: DNHttpCacheAgeControl; ageOrFreshOrStale: DDNC.System.Private.CoreLib.DNTimeSpan): DNHttpRequestCachePolicy; overload;
    {class} function init(cacheAgeControl: DNHttpCacheAgeControl; maxAge: DDNC.System.Private.CoreLib.DNTimeSpan; freshOrStale: DDNC.System.Private.CoreLib.DNTimeSpan): DNHttpRequestCachePolicy; overload;
    {class} function init(cacheSyncDate: DDNC.System.Private.CoreLib.DNDateTime): DNHttpRequestCachePolicy; overload;
    {class} function init(cacheAgeControl: DNHttpCacheAgeControl; maxAge: DDNC.System.Private.CoreLib.DNTimeSpan; freshOrStale: DDNC.System.Private.CoreLib.DNTimeSpan; cacheSyncDate: DDNC.System.Private.CoreLib.DNDateTime): DNHttpRequestCachePolicy; overload;

  end;

  [DNTypeName('System.Net.Cache.HttpRequestCachePolicy')]
  DNHttpRequestCachePolicy = interface(DNObject)
  ['{AD255866-AED8-325B-943B-9F750331572D}']
  { getters & setters } 

    function get_Level: DNHttpRequestCacheLevel;
    function get_CacheSyncDate: DDNC.System.Private.CoreLib.DNDateTime;
    function get_MaxAge: DDNC.System.Private.CoreLib.DNTimeSpan;
    function get_MinFresh: DDNC.System.Private.CoreLib.DNTimeSpan;
    function get_MaxStale: DDNC.System.Private.CoreLib.DNTimeSpan;

  { methods } 

    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Level: DNHttpRequestCacheLevel read get_Level;
    property CacheSyncDate: DDNC.System.Private.CoreLib.DNDateTime read get_CacheSyncDate;
    property MaxAge: DDNC.System.Private.CoreLib.DNTimeSpan read get_MaxAge;
    property MinFresh: DDNC.System.Private.CoreLib.DNTimeSpan read get_MinFresh;
    property MaxStale: DDNC.System.Private.CoreLib.DNTimeSpan read get_MaxStale;
  end;

  TDNHttpRequestCachePolicy = class(TDNGenericImport<DNHttpRequestCachePolicyClass, DNHttpRequestCachePolicy>) end;

  //-------------namespace: System.Net----------------
  DNGlobalProxySelectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A232A5C0-11E8-5CB4-9E51-B1618B60972D}']
  { static getter & setter } 

    {class} function get_Select: DDNC.System.Net.Primitives.DNIWebProxy;
    {class} procedure set_Select(value: DDNC.System.Net.Primitives.DNIWebProxy);

  { constructors } 

    {class} function init: DNGlobalProxySelection;

  { static methods } 

    {class} function GetEmptyWebProxy: DDNC.System.Net.Primitives.DNIWebProxy;

  { static propertys } 

    {class} property Select: DDNC.System.Net.Primitives.DNIWebProxy read get_Select write set_Select;
  end;

  [DNTypeName('System.Net.GlobalProxySelection')]
  DNGlobalProxySelection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2416F926-C805-304A-9120-22A573F2861E}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNGlobalProxySelection = class(TDNGenericImport<DNGlobalProxySelectionClass, DNGlobalProxySelection>) end;

  //-------------namespace: System.Net----------------
  DNWebRequestMethodsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{19867AAD-CE7D-5086-BA04-3FC0B7169163}']
  end;

  [DNTypeName('System.Net.WebRequestMethods')]
  DNWebRequestMethods = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8D433847-4D7E-3676-8C37-D7520E3DAC57}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNWebRequestMethods = class(TDNGenericImport<DNWebRequestMethodsClass, DNWebRequestMethods>) end;

  //-------------namespace: System.Net----------------
  DNWebRequestMethods_FileClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{10ED7A96-D35B-5271-8D65-D104DDC18484}']
  end;

  [DNTypeName('System.Net.WebRequestMethods+File')]
  DNWebRequestMethods_File = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2DEB9CF2-BEE9-31FF-BF7E-B60D9D635F62}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNWebRequestMethods_File = class(TDNGenericImport<DNWebRequestMethods_FileClass, DNWebRequestMethods_File>)
  public const
   DownloadFile = 'GET';
   UploadFile = 'PUT';
  end;

  //-------------namespace: System.Net----------------
  DNWebRequestMethods_FtpClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{8B5CA257-1301-5F47-B152-691C3B5B5290}']
  end;

  [DNTypeName('System.Net.WebRequestMethods+Ftp')]
  DNWebRequestMethods_Ftp = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{09817709-4298-32D9-AC1F-63FA631F7A45}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNWebRequestMethods_Ftp = class(TDNGenericImport<DNWebRequestMethods_FtpClass, DNWebRequestMethods_Ftp>)
  public const
   DownloadFile = 'RETR';
   ListDirectory = 'NLST';
   UploadFile = 'STOR';
   DeleteFile = 'DELE';
   AppendFile = 'APPE';
   GetFileSize = 'SIZE';
   UploadFileWithUniqueName = 'STOU';
   MakeDirectory = 'MKD';
   RemoveDirectory = 'RMD';
   ListDirectoryDetails = 'LIST';
   GetDateTimestamp = 'MDTM';
   PrintWorkingDirectory = 'PWD';
   Rename = 'RENAME';
  end;

  //-------------namespace: System.Net----------------
  DNWebRequestMethods_HttpClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{DEABC298-C229-58F9-9651-67BDF56EDACF}']
  end;

  [DNTypeName('System.Net.WebRequestMethods+Http')]
  DNWebRequestMethods_Http = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{CCFCBED5-3BE2-38B4-8045-DD529FCA365D}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNWebRequestMethods_Http = class(TDNGenericImport<DNWebRequestMethods_HttpClass, DNWebRequestMethods_Http>)
  public const
   Get = 'GET';
   Connect = 'CONNECT';
   Head = 'HEAD';
   Put = 'PUT';
   Post = 'POST';
   MkCol = 'MKCOL';
  end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.Requests, Version=4.1.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
