//----------------------------------------------------------------------------
//  System.Net.NetworkInformation.dll: System.Net.NetworkInformation, Version=4.2.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.NetworkInformation
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.NetworkInformation;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.Microsoft.Win32.Primitives,
  DDNC.System.Net.Primitives;

type

{ enums }

  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.DuplicateAddressDetectionState')]
  DNDuplicateAddressDetectionState = type Integer;
  DNDuplicateAddressDetectionStateHelper = record helper for DNDuplicateAddressDetectionState
  public const
    Invalid = 0;
    Tentative = 1;
    Duplicate = 2;
    Deprecated = 3;
    Preferred = 4;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.NetBiosNodeType')]
  DNNetBiosNodeType = type Integer;
  DNNetBiosNodeTypeHelper = record helper for DNNetBiosNodeType
  public const
    Unknown = 0;
    Broadcast = 1;
    Peer2Peer = 2;
    Mixed = 4;
    Hybrid = 8;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.NetworkInterfaceComponent')]
  DNNetworkInterfaceComponent = type Integer;
  DNNetworkInterfaceComponentHelper = record helper for DNNetworkInterfaceComponent
  public const
    IPv4 = 0;
    IPv6 = 1;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.NetworkInterfaceType')]
  DNNetworkInterfaceType = type Integer;
  DNNetworkInterfaceTypeHelper = record helper for DNNetworkInterfaceType
  public const
    Unknown = 1;
    Ethernet = 6;
    TokenRing = 9;
    Fddi = 15;
    BasicIsdn = 20;
    PrimaryIsdn = 21;
    Ppp = 23;
    Loopback = 24;
    Ethernet3Megabit = 26;
    Slip = 28;
    Atm = 37;
    GenericModem = 48;
    FastEthernetT = 62;
    Isdn = 63;
    FastEthernetFx = 69;
    Wireless80211 = 71;
    AsymmetricDsl = 94;
    RateAdaptDsl = 95;
    SymmetricDsl = 96;
    VeryHighSpeedDsl = 97;
    IPOverAtm = 114;
    GigabitEthernet = 117;
    Tunnel = 131;
    MultiRateSymmetricDsl = 143;
    HighPerformanceSerialBus = 144;
    Wman = 237;
    Wwanpp = 243;
    Wwanpp2 = 244;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.OperationalStatus')]
  DNOperationalStatus = type Integer;
  DNOperationalStatusHelper = record helper for DNOperationalStatus
  public const
    Up = 1;
    Down = 2;
    Testing = 3;
    Unknown = 4;
    Dormant = 5;
    NotPresent = 6;
    LowerLayerDown = 7;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.PrefixOrigin')]
  DNPrefixOrigin = type Integer;
  DNPrefixOriginHelper = record helper for DNPrefixOrigin
  public const
    Other = 0;
    Manual = 1;
    WellKnown = 2;
    Dhcp = 3;
    RouterAdvertisement = 4;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.ScopeLevel')]
  DNScopeLevel = type Integer;
  DNScopeLevelHelper = record helper for DNScopeLevel
  public const
    None = 0;
    Interface_ = 1;
    Link = 2;
    Subnet = 3;
    Admin = 4;
    Site = 5;
    Organization = 8;
    Global = 14;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.SuffixOrigin')]
  DNSuffixOrigin = type Integer;
  DNSuffixOriginHelper = record helper for DNSuffixOrigin
  public const
    Other = 0;
    Manual = 1;
    WellKnown = 2;
    OriginDhcp = 3;
    LinkLayerAddress = 4;
    Random = 5;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.TcpState')]
  DNTcpState = type Integer;
  DNTcpStateHelper = record helper for DNTcpState
  public const
    Unknown = 0;
    Closed = 1;
    Listen = 2;
    SynSent = 3;
    SynReceived = 4;
    Established = 5;
    FinWait1 = 6;
    FinWait2 = 7;
    CloseWait = 8;
    Closing = 9;
    LastAck = 10;
    TimeWait = 11;
    DeleteTcb = 12;
  end;




type


{ declares }

  DNNetworkAvailabilityEventArgs = interface; // type: System.Net.NetworkInformation.NetworkAvailabilityEventArgs, namespace: System.Net.NetworkInformation
  DNNetworkInformationException = interface; // type: System.Net.NetworkInformation.NetworkInformationException, namespace: System.Net.NetworkInformation
  DNGatewayIPAddressInformation = interface; // type: System.Net.NetworkInformation.GatewayIPAddressInformation, namespace: System.Net.NetworkInformation
  DNGatewayIPAddressInformationCollection = interface; // type: System.Net.NetworkInformation.GatewayIPAddressInformationCollection, namespace: System.Net.NetworkInformation
  DNIcmpV4Statistics = interface; // type: System.Net.NetworkInformation.IcmpV4Statistics, namespace: System.Net.NetworkInformation
  DNIcmpV6Statistics = interface; // type: System.Net.NetworkInformation.IcmpV6Statistics, namespace: System.Net.NetworkInformation
  DNIPAddressInformation = interface; // type: System.Net.NetworkInformation.IPAddressInformation, namespace: System.Net.NetworkInformation
  DNMulticastIPAddressInformation = interface; // type: System.Net.NetworkInformation.MulticastIPAddressInformation, namespace: System.Net.NetworkInformation
  DNUnicastIPAddressInformation = interface; // type: System.Net.NetworkInformation.UnicastIPAddressInformation, namespace: System.Net.NetworkInformation
  DNIPAddressInformationCollection = interface; // type: System.Net.NetworkInformation.IPAddressInformationCollection, namespace: System.Net.NetworkInformation
  DNIPGlobalProperties = interface; // type: System.Net.NetworkInformation.IPGlobalProperties, namespace: System.Net.NetworkInformation
  DNIPGlobalStatistics = interface; // type: System.Net.NetworkInformation.IPGlobalStatistics, namespace: System.Net.NetworkInformation
  DNIPInterfaceProperties = interface; // type: System.Net.NetworkInformation.IPInterfaceProperties, namespace: System.Net.NetworkInformation
  DNIPInterfaceStatistics = interface; // type: System.Net.NetworkInformation.IPInterfaceStatistics, namespace: System.Net.NetworkInformation
  DNIPv4InterfaceProperties = interface; // type: System.Net.NetworkInformation.IPv4InterfaceProperties, namespace: System.Net.NetworkInformation
  DNIPv4InterfaceStatistics = interface; // type: System.Net.NetworkInformation.IPv4InterfaceStatistics, namespace: System.Net.NetworkInformation
  DNIPv6InterfaceProperties = interface; // type: System.Net.NetworkInformation.IPv6InterfaceProperties, namespace: System.Net.NetworkInformation
  DNMulticastIPAddressInformationCollection = interface; // type: System.Net.NetworkInformation.MulticastIPAddressInformationCollection, namespace: System.Net.NetworkInformation
  DNNetworkChange = interface; // type: System.Net.NetworkInformation.NetworkChange, namespace: System.Net.NetworkInformation
  DNNetworkInterface = interface; // type: System.Net.NetworkInformation.NetworkInterface, namespace: System.Net.NetworkInformation
  DNPhysicalAddress = interface; // type: System.Net.NetworkInformation.PhysicalAddress, namespace: System.Net.NetworkInformation
  DNTcpConnectionInformation = interface; // type: System.Net.NetworkInformation.TcpConnectionInformation, namespace: System.Net.NetworkInformation
  DNTcpStatistics = interface; // type: System.Net.NetworkInformation.TcpStatistics, namespace: System.Net.NetworkInformation
  DNUdpStatistics = interface; // type: System.Net.NetworkInformation.UdpStatistics, namespace: System.Net.NetworkInformation
  DNUnicastIPAddressInformationCollection = interface; // type: System.Net.NetworkInformation.UnicastIPAddressInformationCollection, namespace: System.Net.NetworkInformation

{ delegates }

  [DNTypeName('System.Net.NetworkInformation.NetworkAddressChangedEventHandler')]
  DNNetworkAddressChangedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DDNC.System.Private.CoreLib.DNEventArgs) of object;

  [DNTypeName('System.Net.NetworkInformation.NetworkAvailabilityChangedEventHandler')]
  DNNetworkAvailabilityChangedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNNetworkAvailabilityEventArgs) of object;




{ objects }

  //-------------namespace: System.Net.NetworkInformation----------------
  DNNetworkAvailabilityEventArgsClass = interface(DDNC.System.Private.CoreLib.DNEventArgsClass)
  ['{7DB7C453-297A-5224-B7BE-20187EFD8820}']
  end;

  [DNTypeName('System.Net.NetworkInformation.NetworkAvailabilityEventArgs')]
  DNNetworkAvailabilityEventArgs = interface(DDNC.System.Private.CoreLib.DNEventArgs)
  ['{D587646A-B53B-31A2-821E-866EDE29A085}']
  { getters & setters } 

    function get_IsAvailable: Boolean;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsAvailable: Boolean read get_IsAvailable;
  end;

  TDNNetworkAvailabilityEventArgs = class(TDNGenericImport<DNNetworkAvailabilityEventArgsClass, DNNetworkAvailabilityEventArgs>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNNetworkInformationExceptionClass = interface(DNObjectClass)
  ['{C884958A-7E9A-5E3F-9478-27CDAC97F853}']
  { constructors } 

    {class} function init: DNNetworkInformationException; overload;
    {class} function init(errorCode: Int32): DNNetworkInformationException; overload;

  end;

  [DNTypeName('System.Net.NetworkInformation.NetworkInformationException')]
  DNNetworkInformationException = interface(DNObject)
  ['{A55389A7-5FA8-3913-B68C-01A8E7C310DE}']
  { getters & setters } 

    function get_ErrorCode: Int32;
    function get_NativeErrorCode: Int32;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ErrorCode: Int32 read get_ErrorCode;
    property NativeErrorCode: Int32 read get_NativeErrorCode;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNNetworkInformationException = class(TDNGenericImport<DNNetworkInformationExceptionClass, DNNetworkInformationException>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNGatewayIPAddressInformationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{2DCAF924-FEF7-58A8-AD39-61205DD3B5E4}']
  end;

  [DNTypeName('System.Net.NetworkInformation.GatewayIPAddressInformation')]
  DNGatewayIPAddressInformation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FE10DE8C-7408-3035-ADB3-F958622D5949}']
  { getters & setters } 

    function get_Address: DDNC.System.Net.Primitives.DNIPAddress;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Address: DDNC.System.Net.Primitives.DNIPAddress read get_Address;
  end;

  TDNGatewayIPAddressInformation = class(TDNGenericImport<DNGatewayIPAddressInformationClass, DNGatewayIPAddressInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNGatewayIPAddressInformationCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{98300070-F3BD-55CA-AD4B-D700D6B1FA91}']
  end;

  [DNTypeName('System.Net.NetworkInformation.GatewayIPAddressInformationCollection')]
  DNGatewayIPAddressInformationCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{71E0FC79-20EB-3E90-A709-4362371B843E}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNGatewayIPAddressInformation;

  { methods } 

    procedure CopyTo(&array: TArray<DNGatewayIPAddressInformation>; offset: Int32);
    procedure Add(address: DNGatewayIPAddressInformation);
    function &Contains(address: DNGatewayIPAddressInformation): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNGatewayIPAddressInformation>;
    function Remove(address: DNGatewayIPAddressInformation): Boolean;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNGatewayIPAddressInformation read get_Item; default;
  end;

  TDNGatewayIPAddressInformationCollection = class(TDNGenericImport<DNGatewayIPAddressInformationCollectionClass, DNGatewayIPAddressInformationCollection>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIcmpV4StatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{653E3CD1-7795-575A-B26B-267C5760B5E0}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IcmpV4Statistics')]
  DNIcmpV4Statistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{832D2E2F-F6BA-34B8-90B7-B1319E0DE1E0}']
  { getters & setters } 

    function get_AddressMaskRepliesReceived: Int64;
    function get_AddressMaskRepliesSent: Int64;
    function get_AddressMaskRequestsReceived: Int64;
    function get_AddressMaskRequestsSent: Int64;
    function get_DestinationUnreachableMessagesReceived: Int64;
    function get_DestinationUnreachableMessagesSent: Int64;
    function get_EchoRepliesReceived: Int64;
    function get_EchoRepliesSent: Int64;
    function get_EchoRequestsReceived: Int64;
    function get_EchoRequestsSent: Int64;
    function get_ErrorsReceived: Int64;
    function get_ErrorsSent: Int64;
    function get_MessagesReceived: Int64;
    function get_MessagesSent: Int64;
    function get_ParameterProblemsReceived: Int64;
    function get_ParameterProblemsSent: Int64;
    function get_RedirectsReceived: Int64;
    function get_RedirectsSent: Int64;
    function get_SourceQuenchesReceived: Int64;
    function get_SourceQuenchesSent: Int64;
    function get_TimeExceededMessagesReceived: Int64;
    function get_TimeExceededMessagesSent: Int64;
    function get_TimestampRepliesReceived: Int64;
    function get_TimestampRepliesSent: Int64;
    function get_TimestampRequestsReceived: Int64;
    function get_TimestampRequestsSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AddressMaskRepliesReceived: Int64 read get_AddressMaskRepliesReceived;
    property AddressMaskRepliesSent: Int64 read get_AddressMaskRepliesSent;
    property AddressMaskRequestsReceived: Int64 read get_AddressMaskRequestsReceived;
    property AddressMaskRequestsSent: Int64 read get_AddressMaskRequestsSent;
    property DestinationUnreachableMessagesReceived: Int64 read get_DestinationUnreachableMessagesReceived;
    property DestinationUnreachableMessagesSent: Int64 read get_DestinationUnreachableMessagesSent;
    property EchoRepliesReceived: Int64 read get_EchoRepliesReceived;
    property EchoRepliesSent: Int64 read get_EchoRepliesSent;
    property EchoRequestsReceived: Int64 read get_EchoRequestsReceived;
    property EchoRequestsSent: Int64 read get_EchoRequestsSent;
    property ErrorsReceived: Int64 read get_ErrorsReceived;
    property ErrorsSent: Int64 read get_ErrorsSent;
    property MessagesReceived: Int64 read get_MessagesReceived;
    property MessagesSent: Int64 read get_MessagesSent;
    property ParameterProblemsReceived: Int64 read get_ParameterProblemsReceived;
    property ParameterProblemsSent: Int64 read get_ParameterProblemsSent;
    property RedirectsReceived: Int64 read get_RedirectsReceived;
    property RedirectsSent: Int64 read get_RedirectsSent;
    property SourceQuenchesReceived: Int64 read get_SourceQuenchesReceived;
    property SourceQuenchesSent: Int64 read get_SourceQuenchesSent;
    property TimeExceededMessagesReceived: Int64 read get_TimeExceededMessagesReceived;
    property TimeExceededMessagesSent: Int64 read get_TimeExceededMessagesSent;
    property TimestampRepliesReceived: Int64 read get_TimestampRepliesReceived;
    property TimestampRepliesSent: Int64 read get_TimestampRepliesSent;
    property TimestampRequestsReceived: Int64 read get_TimestampRequestsReceived;
    property TimestampRequestsSent: Int64 read get_TimestampRequestsSent;
  end;

  TDNIcmpV4Statistics = class(TDNGenericImport<DNIcmpV4StatisticsClass, DNIcmpV4Statistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIcmpV6StatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{2388E079-59E3-5E10-B5D1-A4131A7D9573}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IcmpV6Statistics')]
  DNIcmpV6Statistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{12E222C5-93C8-3CD0-BC43-21A9A4F26D1B}']
  { getters & setters } 

    function get_DestinationUnreachableMessagesReceived: Int64;
    function get_DestinationUnreachableMessagesSent: Int64;
    function get_EchoRepliesReceived: Int64;
    function get_EchoRepliesSent: Int64;
    function get_EchoRequestsReceived: Int64;
    function get_EchoRequestsSent: Int64;
    function get_ErrorsReceived: Int64;
    function get_ErrorsSent: Int64;
    function get_MembershipQueriesReceived: Int64;
    function get_MembershipQueriesSent: Int64;
    function get_MembershipReductionsReceived: Int64;
    function get_MembershipReductionsSent: Int64;
    function get_MembershipReportsReceived: Int64;
    function get_MembershipReportsSent: Int64;
    function get_MessagesReceived: Int64;
    function get_MessagesSent: Int64;
    function get_NeighborAdvertisementsReceived: Int64;
    function get_NeighborAdvertisementsSent: Int64;
    function get_NeighborSolicitsReceived: Int64;
    function get_NeighborSolicitsSent: Int64;
    function get_PacketTooBigMessagesReceived: Int64;
    function get_PacketTooBigMessagesSent: Int64;
    function get_ParameterProblemsReceived: Int64;
    function get_ParameterProblemsSent: Int64;
    function get_RedirectsReceived: Int64;
    function get_RedirectsSent: Int64;
    function get_RouterAdvertisementsReceived: Int64;
    function get_RouterAdvertisementsSent: Int64;
    function get_RouterSolicitsReceived: Int64;
    function get_RouterSolicitsSent: Int64;
    function get_TimeExceededMessagesReceived: Int64;
    function get_TimeExceededMessagesSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DestinationUnreachableMessagesReceived: Int64 read get_DestinationUnreachableMessagesReceived;
    property DestinationUnreachableMessagesSent: Int64 read get_DestinationUnreachableMessagesSent;
    property EchoRepliesReceived: Int64 read get_EchoRepliesReceived;
    property EchoRepliesSent: Int64 read get_EchoRepliesSent;
    property EchoRequestsReceived: Int64 read get_EchoRequestsReceived;
    property EchoRequestsSent: Int64 read get_EchoRequestsSent;
    property ErrorsReceived: Int64 read get_ErrorsReceived;
    property ErrorsSent: Int64 read get_ErrorsSent;
    property MembershipQueriesReceived: Int64 read get_MembershipQueriesReceived;
    property MembershipQueriesSent: Int64 read get_MembershipQueriesSent;
    property MembershipReductionsReceived: Int64 read get_MembershipReductionsReceived;
    property MembershipReductionsSent: Int64 read get_MembershipReductionsSent;
    property MembershipReportsReceived: Int64 read get_MembershipReportsReceived;
    property MembershipReportsSent: Int64 read get_MembershipReportsSent;
    property MessagesReceived: Int64 read get_MessagesReceived;
    property MessagesSent: Int64 read get_MessagesSent;
    property NeighborAdvertisementsReceived: Int64 read get_NeighborAdvertisementsReceived;
    property NeighborAdvertisementsSent: Int64 read get_NeighborAdvertisementsSent;
    property NeighborSolicitsReceived: Int64 read get_NeighborSolicitsReceived;
    property NeighborSolicitsSent: Int64 read get_NeighborSolicitsSent;
    property PacketTooBigMessagesReceived: Int64 read get_PacketTooBigMessagesReceived;
    property PacketTooBigMessagesSent: Int64 read get_PacketTooBigMessagesSent;
    property ParameterProblemsReceived: Int64 read get_ParameterProblemsReceived;
    property ParameterProblemsSent: Int64 read get_ParameterProblemsSent;
    property RedirectsReceived: Int64 read get_RedirectsReceived;
    property RedirectsSent: Int64 read get_RedirectsSent;
    property RouterAdvertisementsReceived: Int64 read get_RouterAdvertisementsReceived;
    property RouterAdvertisementsSent: Int64 read get_RouterAdvertisementsSent;
    property RouterSolicitsReceived: Int64 read get_RouterSolicitsReceived;
    property RouterSolicitsSent: Int64 read get_RouterSolicitsSent;
    property TimeExceededMessagesReceived: Int64 read get_TimeExceededMessagesReceived;
    property TimeExceededMessagesSent: Int64 read get_TimeExceededMessagesSent;
  end;

  TDNIcmpV6Statistics = class(TDNGenericImport<DNIcmpV6StatisticsClass, DNIcmpV6Statistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPAddressInformationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{55AC0DF0-B300-5B5E-B55E-587811576F76}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPAddressInformation')]
  DNIPAddressInformation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{31D40AFB-162A-31D3-A256-2F68ABBFAEDF}']
  { getters & setters } 

    function get_Address: DDNC.System.Net.Primitives.DNIPAddress;
    function get_IsDnsEligible: Boolean;
    function get_IsTransient: Boolean;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Address: DDNC.System.Net.Primitives.DNIPAddress read get_Address;
    property IsDnsEligible: Boolean read get_IsDnsEligible;
    property IsTransient: Boolean read get_IsTransient;
  end;

  TDNIPAddressInformation = class(TDNGenericImport<DNIPAddressInformationClass, DNIPAddressInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNMulticastIPAddressInformationClass = interface(DNIPAddressInformationClass)
  ['{E233C8A9-6C95-5C85-9DF8-DA7F67DB0894}']
  end;

  [DNTypeName('System.Net.NetworkInformation.MulticastIPAddressInformation')]
  DNMulticastIPAddressInformation = interface(DNIPAddressInformation)
  ['{91D334EC-4EDC-3C63-8661-8EDE854D0AA1}']
  { getters & setters } 

    function get_AddressPreferredLifetime: Int64;
    function get_AddressValidLifetime: Int64;
    function get_DhcpLeaseLifetime: Int64;
    function get_DuplicateAddressDetectionState: DNDuplicateAddressDetectionState;
    function get_PrefixOrigin: DNPrefixOrigin;
    function get_SuffixOrigin: DNSuffixOrigin;
    function get_Address: DDNC.System.Net.Primitives.DNIPAddress;
    function get_IsDnsEligible: Boolean;
    function get_IsTransient: Boolean;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AddressPreferredLifetime: Int64 read get_AddressPreferredLifetime;
    property AddressValidLifetime: Int64 read get_AddressValidLifetime;
    property DhcpLeaseLifetime: Int64 read get_DhcpLeaseLifetime;
    property DuplicateAddressDetectionState: DNDuplicateAddressDetectionState read get_DuplicateAddressDetectionState;
    property PrefixOrigin: DNPrefixOrigin read get_PrefixOrigin;
    property SuffixOrigin: DNSuffixOrigin read get_SuffixOrigin;
    property Address: DDNC.System.Net.Primitives.DNIPAddress read get_Address;
    property IsDnsEligible: Boolean read get_IsDnsEligible;
    property IsTransient: Boolean read get_IsTransient;
  end;

  TDNMulticastIPAddressInformation = class(TDNGenericImport<DNMulticastIPAddressInformationClass, DNMulticastIPAddressInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNUnicastIPAddressInformationClass = interface(DNIPAddressInformationClass)
  ['{CA628A69-705D-5953-B5BE-89300C087539}']
  end;

  [DNTypeName('System.Net.NetworkInformation.UnicastIPAddressInformation')]
  DNUnicastIPAddressInformation = interface(DNIPAddressInformation)
  ['{66107D65-C1C5-3AFF-A2F7-E5556ABCE192}']
  { getters & setters } 

    function get_AddressPreferredLifetime: Int64;
    function get_AddressValidLifetime: Int64;
    function get_DhcpLeaseLifetime: Int64;
    function get_DuplicateAddressDetectionState: DNDuplicateAddressDetectionState;
    function get_PrefixOrigin: DNPrefixOrigin;
    function get_SuffixOrigin: DNSuffixOrigin;
    function get_IPv4Mask: DDNC.System.Net.Primitives.DNIPAddress;
    function get_PrefixLength: Int32;
    function get_Address: DDNC.System.Net.Primitives.DNIPAddress;
    function get_IsDnsEligible: Boolean;
    function get_IsTransient: Boolean;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AddressPreferredLifetime: Int64 read get_AddressPreferredLifetime;
    property AddressValidLifetime: Int64 read get_AddressValidLifetime;
    property DhcpLeaseLifetime: Int64 read get_DhcpLeaseLifetime;
    property DuplicateAddressDetectionState: DNDuplicateAddressDetectionState read get_DuplicateAddressDetectionState;
    property PrefixOrigin: DNPrefixOrigin read get_PrefixOrigin;
    property SuffixOrigin: DNSuffixOrigin read get_SuffixOrigin;
    property IPv4Mask: DDNC.System.Net.Primitives.DNIPAddress read get_IPv4Mask;
    property PrefixLength: Int32 read get_PrefixLength;
    property Address: DDNC.System.Net.Primitives.DNIPAddress read get_Address;
    property IsDnsEligible: Boolean read get_IsDnsEligible;
    property IsTransient: Boolean read get_IsTransient;
  end;

  TDNUnicastIPAddressInformation = class(TDNGenericImport<DNUnicastIPAddressInformationClass, DNUnicastIPAddressInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPAddressInformationCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{EAF12042-314D-511D-825E-6205B85472F9}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPAddressInformationCollection')]
  DNIPAddressInformationCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4BB938FC-8E43-303A-BF7D-49602765F952}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNIPAddressInformation;

  { methods } 

    procedure CopyTo(&array: TArray<DNIPAddressInformation>; offset: Int32);
    procedure Add(address: DNIPAddressInformation);
    function &Contains(address: DNIPAddressInformation): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNIPAddressInformation>;
    function Remove(address: DNIPAddressInformation): Boolean;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNIPAddressInformation read get_Item; default;
  end;

  TDNIPAddressInformationCollection = class(TDNGenericImport<DNIPAddressInformationCollectionClass, DNIPAddressInformationCollection>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPGlobalPropertiesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{C669D474-7205-52BA-A279-42B82C659A80}']
  { static methods } 

    {class} function GetIPGlobalProperties: DNIPGlobalProperties;

  end;

  [DNTypeName('System.Net.NetworkInformation.IPGlobalProperties')]
  DNIPGlobalProperties = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{91F76E77-BD4E-3C52-B0CE-E0178B539F14}']
  { getters & setters } 

    function get_DhcpScopeName: string;
    function get_DomainName: string;
    function get_HostName: string;
    function get_IsWinsProxy: Boolean;
    function get_NodeType: DNNetBiosNodeType;

  { methods } 

    function GetActiveUdpListeners: TArray<DDNC.System.Net.Primitives.DNIPEndPoint>;
    function GetActiveTcpListeners: TArray<DDNC.System.Net.Primitives.DNIPEndPoint>;
    function GetActiveTcpConnections: TArray<DNTcpConnectionInformation>;
    function BeginGetUnicastAddresses(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndGetUnicastAddresses(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNUnicastIPAddressInformationCollection;
    function GetTcpIPv4Statistics: DNTcpStatistics;
    function GetTcpIPv6Statistics: DNTcpStatistics;
    function GetUdpIPv4Statistics: DNUdpStatistics;
    function GetUdpIPv6Statistics: DNUdpStatistics;
    function GetIcmpV4Statistics: DNIcmpV4Statistics;
    function GetIcmpV6Statistics: DNIcmpV6Statistics;
    function GetIPv4GlobalStatistics: DNIPGlobalStatistics;
    function GetIPv6GlobalStatistics: DNIPGlobalStatistics;
    function GetUnicastAddresses: DNUnicastIPAddressInformationCollection;
    function GetUnicastAddressesAsync: DDNC.System.Private.CoreLib.DNTask<DNUnicastIPAddressInformationCollection>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DhcpScopeName: string read get_DhcpScopeName;
    property DomainName: string read get_DomainName;
    property HostName: string read get_HostName;
    property IsWinsProxy: Boolean read get_IsWinsProxy;
    property NodeType: DNNetBiosNodeType read get_NodeType;
  end;

  TDNIPGlobalProperties = class(TDNGenericImport<DNIPGlobalPropertiesClass, DNIPGlobalProperties>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPGlobalStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{3CDD2E68-E7AF-5FCF-AA59-FA75FD80F293}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPGlobalStatistics')]
  DNIPGlobalStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F2C273A0-D473-3245-BF4D-C0AA3EDB8DA9}']
  { getters & setters } 

    function get_DefaultTtl: Int32;
    function get_ForwardingEnabled: Boolean;
    function get_NumberOfInterfaces: Int32;
    function get_NumberOfIPAddresses: Int32;
    function get_OutputPacketRequests: Int64;
    function get_OutputPacketRoutingDiscards: Int64;
    function get_OutputPacketsDiscarded: Int64;
    function get_OutputPacketsWithNoRoute: Int64;
    function get_PacketFragmentFailures: Int64;
    function get_PacketReassembliesRequired: Int64;
    function get_PacketReassemblyFailures: Int64;
    function get_PacketReassemblyTimeout: Int64;
    function get_PacketsFragmented: Int64;
    function get_PacketsReassembled: Int64;
    function get_ReceivedPackets: Int64;
    function get_ReceivedPacketsDelivered: Int64;
    function get_ReceivedPacketsDiscarded: Int64;
    function get_ReceivedPacketsForwarded: Int64;
    function get_ReceivedPacketsWithAddressErrors: Int64;
    function get_ReceivedPacketsWithHeadersErrors: Int64;
    function get_ReceivedPacketsWithUnknownProtocol: Int64;
    function get_NumberOfRoutes: Int32;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DefaultTtl: Int32 read get_DefaultTtl;
    property ForwardingEnabled: Boolean read get_ForwardingEnabled;
    property NumberOfInterfaces: Int32 read get_NumberOfInterfaces;
    property NumberOfIPAddresses: Int32 read get_NumberOfIPAddresses;
    property OutputPacketRequests: Int64 read get_OutputPacketRequests;
    property OutputPacketRoutingDiscards: Int64 read get_OutputPacketRoutingDiscards;
    property OutputPacketsDiscarded: Int64 read get_OutputPacketsDiscarded;
    property OutputPacketsWithNoRoute: Int64 read get_OutputPacketsWithNoRoute;
    property PacketFragmentFailures: Int64 read get_PacketFragmentFailures;
    property PacketReassembliesRequired: Int64 read get_PacketReassembliesRequired;
    property PacketReassemblyFailures: Int64 read get_PacketReassemblyFailures;
    property PacketReassemblyTimeout: Int64 read get_PacketReassemblyTimeout;
    property PacketsFragmented: Int64 read get_PacketsFragmented;
    property PacketsReassembled: Int64 read get_PacketsReassembled;
    property ReceivedPackets: Int64 read get_ReceivedPackets;
    property ReceivedPacketsDelivered: Int64 read get_ReceivedPacketsDelivered;
    property ReceivedPacketsDiscarded: Int64 read get_ReceivedPacketsDiscarded;
    property ReceivedPacketsForwarded: Int64 read get_ReceivedPacketsForwarded;
    property ReceivedPacketsWithAddressErrors: Int64 read get_ReceivedPacketsWithAddressErrors;
    property ReceivedPacketsWithHeadersErrors: Int64 read get_ReceivedPacketsWithHeadersErrors;
    property ReceivedPacketsWithUnknownProtocol: Int64 read get_ReceivedPacketsWithUnknownProtocol;
    property NumberOfRoutes: Int32 read get_NumberOfRoutes;
  end;

  TDNIPGlobalStatistics = class(TDNGenericImport<DNIPGlobalStatisticsClass, DNIPGlobalStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPInterfacePropertiesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{D229F542-13E6-5C75-AD53-B0BC41442911}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPInterfaceProperties')]
  DNIPInterfaceProperties = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{15B67EC3-B66D-3FD9-9DBC-48FCF9453F2B}']
  { getters & setters } 

    function get_IsDnsEnabled: Boolean;
    function get_DnsSuffix: string;
    function get_IsDynamicDnsEnabled: Boolean;
    function get_UnicastAddresses: DNUnicastIPAddressInformationCollection;
    function get_MulticastAddresses: DNMulticastIPAddressInformationCollection;
    function get_AnycastAddresses: DNIPAddressInformationCollection;
    function get_DnsAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection;
    function get_GatewayAddresses: DNGatewayIPAddressInformationCollection;
    function get_DhcpServerAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection;
    function get_WinsServersAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection;

  { methods } 

    function GetIPv4Properties: DNIPv4InterfaceProperties;
    function GetIPv6Properties: DNIPv6InterfaceProperties;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsDnsEnabled: Boolean read get_IsDnsEnabled;
    property DnsSuffix: string read get_DnsSuffix;
    property IsDynamicDnsEnabled: Boolean read get_IsDynamicDnsEnabled;
    property UnicastAddresses: DNUnicastIPAddressInformationCollection read get_UnicastAddresses;
    property MulticastAddresses: DNMulticastIPAddressInformationCollection read get_MulticastAddresses;
    property AnycastAddresses: DNIPAddressInformationCollection read get_AnycastAddresses;
    property DnsAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection read get_DnsAddresses;
    property GatewayAddresses: DNGatewayIPAddressInformationCollection read get_GatewayAddresses;
    property DhcpServerAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection read get_DhcpServerAddresses;
    property WinsServersAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection read get_WinsServersAddresses;
  end;

  TDNIPInterfaceProperties = class(TDNGenericImport<DNIPInterfacePropertiesClass, DNIPInterfaceProperties>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPInterfaceStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{74DC1FE9-9AA8-5555-8E66-AC4AABFB40C4}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPInterfaceStatistics')]
  DNIPInterfaceStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{553CBC5B-2C58-36BB-AA57-970068FB9056}']
  { getters & setters } 

    function get_BytesReceived: Int64;
    function get_BytesSent: Int64;
    function get_IncomingPacketsDiscarded: Int64;
    function get_IncomingPacketsWithErrors: Int64;
    function get_IncomingUnknownProtocolPackets: Int64;
    function get_NonUnicastPacketsReceived: Int64;
    function get_NonUnicastPacketsSent: Int64;
    function get_OutgoingPacketsDiscarded: Int64;
    function get_OutgoingPacketsWithErrors: Int64;
    function get_OutputQueueLength: Int64;
    function get_UnicastPacketsReceived: Int64;
    function get_UnicastPacketsSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property BytesReceived: Int64 read get_BytesReceived;
    property BytesSent: Int64 read get_BytesSent;
    property IncomingPacketsDiscarded: Int64 read get_IncomingPacketsDiscarded;
    property IncomingPacketsWithErrors: Int64 read get_IncomingPacketsWithErrors;
    property IncomingUnknownProtocolPackets: Int64 read get_IncomingUnknownProtocolPackets;
    property NonUnicastPacketsReceived: Int64 read get_NonUnicastPacketsReceived;
    property NonUnicastPacketsSent: Int64 read get_NonUnicastPacketsSent;
    property OutgoingPacketsDiscarded: Int64 read get_OutgoingPacketsDiscarded;
    property OutgoingPacketsWithErrors: Int64 read get_OutgoingPacketsWithErrors;
    property OutputQueueLength: Int64 read get_OutputQueueLength;
    property UnicastPacketsReceived: Int64 read get_UnicastPacketsReceived;
    property UnicastPacketsSent: Int64 read get_UnicastPacketsSent;
  end;

  TDNIPInterfaceStatistics = class(TDNGenericImport<DNIPInterfaceStatisticsClass, DNIPInterfaceStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPv4InterfacePropertiesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{F87C7948-5F71-50CD-AA02-BC393F9F6215}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPv4InterfaceProperties')]
  DNIPv4InterfaceProperties = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0FE80455-C8B5-3188-81D1-B6525DCE5FD3}']
  { getters & setters } 

    function get_UsesWins: Boolean;
    function get_IsDhcpEnabled: Boolean;
    function get_IsAutomaticPrivateAddressingActive: Boolean;
    function get_IsAutomaticPrivateAddressingEnabled: Boolean;
    function get_Index: Int32;
    function get_IsForwardingEnabled: Boolean;
    function get_Mtu: Int32;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property UsesWins: Boolean read get_UsesWins;
    property IsDhcpEnabled: Boolean read get_IsDhcpEnabled;
    property IsAutomaticPrivateAddressingActive: Boolean read get_IsAutomaticPrivateAddressingActive;
    property IsAutomaticPrivateAddressingEnabled: Boolean read get_IsAutomaticPrivateAddressingEnabled;
    property Index: Int32 read get_Index;
    property IsForwardingEnabled: Boolean read get_IsForwardingEnabled;
    property Mtu: Int32 read get_Mtu;
  end;

  TDNIPv4InterfaceProperties = class(TDNGenericImport<DNIPv4InterfacePropertiesClass, DNIPv4InterfaceProperties>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPv4InterfaceStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{871B2515-1015-5999-86B0-D6ADBDB02D2E}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPv4InterfaceStatistics')]
  DNIPv4InterfaceStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3AF6A41D-40FE-3FAA-9F19-BCEB9E30A427}']
  { getters & setters } 

    function get_BytesReceived: Int64;
    function get_BytesSent: Int64;
    function get_IncomingPacketsDiscarded: Int64;
    function get_IncomingPacketsWithErrors: Int64;
    function get_IncomingUnknownProtocolPackets: Int64;
    function get_NonUnicastPacketsReceived: Int64;
    function get_NonUnicastPacketsSent: Int64;
    function get_OutgoingPacketsDiscarded: Int64;
    function get_OutgoingPacketsWithErrors: Int64;
    function get_OutputQueueLength: Int64;
    function get_UnicastPacketsReceived: Int64;
    function get_UnicastPacketsSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property BytesReceived: Int64 read get_BytesReceived;
    property BytesSent: Int64 read get_BytesSent;
    property IncomingPacketsDiscarded: Int64 read get_IncomingPacketsDiscarded;
    property IncomingPacketsWithErrors: Int64 read get_IncomingPacketsWithErrors;
    property IncomingUnknownProtocolPackets: Int64 read get_IncomingUnknownProtocolPackets;
    property NonUnicastPacketsReceived: Int64 read get_NonUnicastPacketsReceived;
    property NonUnicastPacketsSent: Int64 read get_NonUnicastPacketsSent;
    property OutgoingPacketsDiscarded: Int64 read get_OutgoingPacketsDiscarded;
    property OutgoingPacketsWithErrors: Int64 read get_OutgoingPacketsWithErrors;
    property OutputQueueLength: Int64 read get_OutputQueueLength;
    property UnicastPacketsReceived: Int64 read get_UnicastPacketsReceived;
    property UnicastPacketsSent: Int64 read get_UnicastPacketsSent;
  end;

  TDNIPv4InterfaceStatistics = class(TDNGenericImport<DNIPv4InterfaceStatisticsClass, DNIPv4InterfaceStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPv6InterfacePropertiesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0D301E8F-066E-5B50-93C1-4106F98FBA60}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPv6InterfaceProperties')]
  DNIPv6InterfaceProperties = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{869F740A-6F1E-3695-9373-62947A8FC749}']
  { getters & setters } 

    function get_Index: Int32;
    function get_Mtu: Int32;

  { methods } 

    function GetScopeId(scopeLevel: DNScopeLevel): Int64;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Index: Int32 read get_Index;
    property Mtu: Int32 read get_Mtu;
  end;

  TDNIPv6InterfaceProperties = class(TDNGenericImport<DNIPv6InterfacePropertiesClass, DNIPv6InterfaceProperties>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNMulticastIPAddressInformationCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{CE0FEB73-F068-53F0-A054-6250C277C794}']
  end;

  [DNTypeName('System.Net.NetworkInformation.MulticastIPAddressInformationCollection')]
  DNMulticastIPAddressInformationCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{385FC82E-7320-33EF-ADE4-F12F28D7E032}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNMulticastIPAddressInformation;

  { methods } 

    procedure CopyTo(&array: TArray<DNMulticastIPAddressInformation>; offset: Int32);
    procedure Add(address: DNMulticastIPAddressInformation);
    function &Contains(address: DNMulticastIPAddressInformation): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNMulticastIPAddressInformation>;
    function Remove(address: DNMulticastIPAddressInformation): Boolean;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNMulticastIPAddressInformation read get_Item; default;
  end;

  TDNMulticastIPAddressInformationCollection = class(TDNGenericImport<DNMulticastIPAddressInformationCollectionClass, DNMulticastIPAddressInformationCollection>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNNetworkChangeClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{4D3634A2-D458-5E96-88C0-1BFC31080AE5}']
  { constructors } 

    {class} function init: DNNetworkChange;

  { static methods } 

    {class} procedure RegisterNetworkChange(nc: DNNetworkChange);

  end;

  [DNTypeName('System.Net.NetworkInformation.NetworkChange')]
  DNNetworkChange = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{89EC679A-32D1-3F2F-98F8-14699A747577}']
  { events } 

    {class} procedure add_NetworkAvailabilityChanged(value: DNNetworkAvailabilityChangedEventHandler);
    {class} procedure remove_NetworkAvailabilityChanged(value: DNNetworkAvailabilityChangedEventHandler);
    {class} procedure add_NetworkAddressChanged(value: DNNetworkAddressChangedEventHandler);
    {class} procedure remove_NetworkAddressChanged(value: DNNetworkAddressChangedEventHandler);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNNetworkChange = class(TDNGenericImport<DNNetworkChangeClass, DNNetworkChange>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNNetworkInterfaceClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{F42CB0E3-606D-5A6B-A8DC-90D67CB10B38}']
  { static getter & setter } 

    {class} function get_IPv6LoopbackInterfaceIndex: Int32;
    {class} function get_LoopbackInterfaceIndex: Int32;

  { static methods } 

    {class} function GetAllNetworkInterfaces: TArray<DNNetworkInterface>;
    {class} function GetIsNetworkAvailable: Boolean;

  { static propertys } 

    {class} property IPv6LoopbackInterfaceIndex: Int32 read get_IPv6LoopbackInterfaceIndex;
    {class} property LoopbackInterfaceIndex: Int32 read get_LoopbackInterfaceIndex;
  end;

  [DNTypeName('System.Net.NetworkInformation.NetworkInterface')]
  DNNetworkInterface = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E1110EE2-35D3-389C-91E7-122E870078AD}']
  { getters & setters } 

    function get_Id: string;
    function get_Name: string;
    function get_Description: string;
    function get_OperationalStatus: DNOperationalStatus;
    function get_Speed: Int64;
    function get_IsReceiveOnly: Boolean;
    function get_SupportsMulticast: Boolean;
    function get_NetworkInterfaceType: DNNetworkInterfaceType;

  { methods } 

    function GetIPProperties: DNIPInterfaceProperties;
    function GetIPStatistics: DNIPInterfaceStatistics;
    function GetIPv4Statistics: DNIPv4InterfaceStatistics;
    function GetPhysicalAddress: DNPhysicalAddress;
    function Supports(networkInterfaceComponent: DNNetworkInterfaceComponent): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Id: string read get_Id;
    property Name: string read get_Name;
    property Description: string read get_Description;
    property OperationalStatus: DNOperationalStatus read get_OperationalStatus;
    property Speed: Int64 read get_Speed;
    property IsReceiveOnly: Boolean read get_IsReceiveOnly;
    property SupportsMulticast: Boolean read get_SupportsMulticast;
    property NetworkInterfaceType: DNNetworkInterfaceType read get_NetworkInterfaceType;
  end;

  TDNNetworkInterface = class(TDNGenericImport<DNNetworkInterfaceClass, DNNetworkInterface>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNPhysicalAddressClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0307F4B0-3C56-5AAA-A6C5-8FA822DD1C6E}']
  { constructors } 

    {class} function init(address: TArray<Byte>): DNPhysicalAddress;

  { static fields getter & setter } 

   function __fakeFieldGet_None: DNPhysicalAddress;

  { static fields } 

    {class} property None: DNPhysicalAddress read __fakeFieldGet_None;

  { static methods } 

    {class} function Parse(address: string): DNPhysicalAddress;

  end;

  [DNTypeName('System.Net.NetworkInformation.PhysicalAddress')]
  DNPhysicalAddress = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8F4FB692-248D-3569-A768-2F71C15BAC19}']
  { methods } 

    function GetHashCode: Int32;
    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function ToString: string;
    function GetAddressBytes: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNPhysicalAddress = class(TDNGenericImport<DNPhysicalAddressClass, DNPhysicalAddress>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNTcpConnectionInformationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{4DDCB0C3-BE51-5229-AF87-59BCDCF89F16}']
  end;

  [DNTypeName('System.Net.NetworkInformation.TcpConnectionInformation')]
  DNTcpConnectionInformation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{CB9D0A65-4945-3553-B81C-F327A7489714}']
  { getters & setters } 

    function get_LocalEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint;
    function get_RemoteEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint;
    function get_State: DNTcpState;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property LocalEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint read get_LocalEndPoint;
    property RemoteEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint read get_RemoteEndPoint;
    property State: DNTcpState read get_State;
  end;

  TDNTcpConnectionInformation = class(TDNGenericImport<DNTcpConnectionInformationClass, DNTcpConnectionInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNTcpStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{93F39309-DC6A-5A21-B6F6-236AE277866F}']
  end;

  [DNTypeName('System.Net.NetworkInformation.TcpStatistics')]
  DNTcpStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{88434E94-0D1D-32DC-9B27-21EF4F35EE2D}']
  { getters & setters } 

    function get_ConnectionsAccepted: Int64;
    function get_ConnectionsInitiated: Int64;
    function get_CumulativeConnections: Int64;
    function get_CurrentConnections: Int64;
    function get_ErrorsReceived: Int64;
    function get_FailedConnectionAttempts: Int64;
    function get_MaximumConnections: Int64;
    function get_MaximumTransmissionTimeout: Int64;
    function get_MinimumTransmissionTimeout: Int64;
    function get_ResetConnections: Int64;
    function get_SegmentsReceived: Int64;
    function get_SegmentsResent: Int64;
    function get_SegmentsSent: Int64;
    function get_ResetsSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ConnectionsAccepted: Int64 read get_ConnectionsAccepted;
    property ConnectionsInitiated: Int64 read get_ConnectionsInitiated;
    property CumulativeConnections: Int64 read get_CumulativeConnections;
    property CurrentConnections: Int64 read get_CurrentConnections;
    property ErrorsReceived: Int64 read get_ErrorsReceived;
    property FailedConnectionAttempts: Int64 read get_FailedConnectionAttempts;
    property MaximumConnections: Int64 read get_MaximumConnections;
    property MaximumTransmissionTimeout: Int64 read get_MaximumTransmissionTimeout;
    property MinimumTransmissionTimeout: Int64 read get_MinimumTransmissionTimeout;
    property ResetConnections: Int64 read get_ResetConnections;
    property SegmentsReceived: Int64 read get_SegmentsReceived;
    property SegmentsResent: Int64 read get_SegmentsResent;
    property SegmentsSent: Int64 read get_SegmentsSent;
    property ResetsSent: Int64 read get_ResetsSent;
  end;

  TDNTcpStatistics = class(TDNGenericImport<DNTcpStatisticsClass, DNTcpStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNUdpStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{61BFF245-990C-534D-BB5A-A8D95E46F542}']
  end;

  [DNTypeName('System.Net.NetworkInformation.UdpStatistics')]
  DNUdpStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{CFF04932-48BF-36D9-BBB9-3FED20383BDD}']
  { getters & setters } 

    function get_DatagramsReceived: Int64;
    function get_DatagramsSent: Int64;
    function get_IncomingDatagramsDiscarded: Int64;
    function get_IncomingDatagramsWithErrors: Int64;
    function get_UdpListeners: Int32;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DatagramsReceived: Int64 read get_DatagramsReceived;
    property DatagramsSent: Int64 read get_DatagramsSent;
    property IncomingDatagramsDiscarded: Int64 read get_IncomingDatagramsDiscarded;
    property IncomingDatagramsWithErrors: Int64 read get_IncomingDatagramsWithErrors;
    property UdpListeners: Int32 read get_UdpListeners;
  end;

  TDNUdpStatistics = class(TDNGenericImport<DNUdpStatisticsClass, DNUdpStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNUnicastIPAddressInformationCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A3258262-9DBA-59B0-9F61-3194608B453C}']
  end;

  [DNTypeName('System.Net.NetworkInformation.UnicastIPAddressInformationCollection')]
  DNUnicastIPAddressInformationCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{06E550CB-0938-3AC9-8667-CEE26858D7B9}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNUnicastIPAddressInformation;

  { methods } 

    procedure CopyTo(&array: TArray<DNUnicastIPAddressInformation>; offset: Int32);
    procedure Add(address: DNUnicastIPAddressInformation);
    function &Contains(address: DNUnicastIPAddressInformation): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNUnicastIPAddressInformation>;
    function Remove(address: DNUnicastIPAddressInformation): Boolean;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNUnicastIPAddressInformation read get_Item; default;
  end;

  TDNUnicastIPAddressInformationCollection = class(TDNGenericImport<DNUnicastIPAddressInformationCollectionClass, DNUnicastIPAddressInformationCollection>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.NetworkInformation, Version=4.2.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
