//----------------------------------------------------------------------------
//  System.Net.Http.dll: System.Net.Http, Version=4.2.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.Http
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.Http;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Private.Uri,
  DDNC.System.Net.Primitives,
  DDNC.System.Security.Cryptography.X509Certificates,
  DDNC.System.Net.Security;

type

{ enums }

  //-------------namespace: System.Net.Http----------------
  [DNTypeName('System.Net.Http.ClientCertificateOption')]
  DNClientCertificateOption = type Integer;
  DNClientCertificateOptionHelper = record helper for DNClientCertificateOption
  public const
    Manual = 0;
    Automatic = 1;
  end;


  //-------------namespace: System.Net.Http----------------
  [DNTypeName('System.Net.Http.HttpCompletionOption')]
  DNHttpCompletionOption = type Integer;
  DNHttpCompletionOptionHelper = record helper for DNHttpCompletionOption
  public const
    ResponseContentRead = 0;
    ResponseHeadersRead = 1;
  end;




type


{ declares }

  DNHttpRequestException = interface; // type: System.Net.Http.HttpRequestException, namespace: System.Net.Http
  DNAuthenticationHeaderValue = interface; // type: System.Net.Http.Headers.AuthenticationHeaderValue, namespace: System.Net.Http.Headers
  DNCacheControlHeaderValue = interface; // type: System.Net.Http.Headers.CacheControlHeaderValue, namespace: System.Net.Http.Headers
  DNContentDispositionHeaderValue = interface; // type: System.Net.Http.Headers.ContentDispositionHeaderValue, namespace: System.Net.Http.Headers
  DNContentRangeHeaderValue = interface; // type: System.Net.Http.Headers.ContentRangeHeaderValue, namespace: System.Net.Http.Headers
  DNEntityTagHeaderValue = interface; // type: System.Net.Http.Headers.EntityTagHeaderValue, namespace: System.Net.Http.Headers
  DNHttpHeaders = interface; // type: System.Net.Http.Headers.HttpHeaders, namespace: System.Net.Http.Headers
  DNHttpContentHeaders = interface; // type: System.Net.Http.Headers.HttpContentHeaders, namespace: System.Net.Http.Headers
  DNHttpRequestHeaders = interface; // type: System.Net.Http.Headers.HttpRequestHeaders, namespace: System.Net.Http.Headers
  DNHttpResponseHeaders = interface; // type: System.Net.Http.Headers.HttpResponseHeaders, namespace: System.Net.Http.Headers
  DNHttpHeaderValueCollection<T> = interface; // type: System.Net.Http.Headers.HttpHeaderValueCollection`1, namespace: System.Net.Http.Headers
  DNMediaTypeHeaderValue = interface; // type: System.Net.Http.Headers.MediaTypeHeaderValue, namespace: System.Net.Http.Headers
  DNMediaTypeWithQualityHeaderValue = interface; // type: System.Net.Http.Headers.MediaTypeWithQualityHeaderValue, namespace: System.Net.Http.Headers
  DNNameValueHeaderValue = interface; // type: System.Net.Http.Headers.NameValueHeaderValue, namespace: System.Net.Http.Headers
  DNNameValueWithParametersHeaderValue = interface; // type: System.Net.Http.Headers.NameValueWithParametersHeaderValue, namespace: System.Net.Http.Headers
  DNProductHeaderValue = interface; // type: System.Net.Http.Headers.ProductHeaderValue, namespace: System.Net.Http.Headers
  DNProductInfoHeaderValue = interface; // type: System.Net.Http.Headers.ProductInfoHeaderValue, namespace: System.Net.Http.Headers
  DNRangeConditionHeaderValue = interface; // type: System.Net.Http.Headers.RangeConditionHeaderValue, namespace: System.Net.Http.Headers
  DNRangeHeaderValue = interface; // type: System.Net.Http.Headers.RangeHeaderValue, namespace: System.Net.Http.Headers
  DNRangeItemHeaderValue = interface; // type: System.Net.Http.Headers.RangeItemHeaderValue, namespace: System.Net.Http.Headers
  DNRetryConditionHeaderValue = interface; // type: System.Net.Http.Headers.RetryConditionHeaderValue, namespace: System.Net.Http.Headers
  DNStringWithQualityHeaderValue = interface; // type: System.Net.Http.Headers.StringWithQualityHeaderValue, namespace: System.Net.Http.Headers
  DNTransferCodingHeaderValue = interface; // type: System.Net.Http.Headers.TransferCodingHeaderValue, namespace: System.Net.Http.Headers
  DNTransferCodingWithQualityHeaderValue = interface; // type: System.Net.Http.Headers.TransferCodingWithQualityHeaderValue, namespace: System.Net.Http.Headers
  DNViaHeaderValue = interface; // type: System.Net.Http.Headers.ViaHeaderValue, namespace: System.Net.Http.Headers
  DNWarningHeaderValue = interface; // type: System.Net.Http.Headers.WarningHeaderValue, namespace: System.Net.Http.Headers
  DNHttpContent = interface; // type: System.Net.Http.HttpContent, namespace: System.Net.Http
  DNByteArrayContent = interface; // type: System.Net.Http.ByteArrayContent, namespace: System.Net.Http
  DNFormUrlEncodedContent = interface; // type: System.Net.Http.FormUrlEncodedContent, namespace: System.Net.Http
  DNStringContent = interface; // type: System.Net.Http.StringContent, namespace: System.Net.Http
  DNMultipartContent = interface; // type: System.Net.Http.MultipartContent, namespace: System.Net.Http
  DNMultipartFormDataContent = interface; // type: System.Net.Http.MultipartFormDataContent, namespace: System.Net.Http
  DNReadOnlyMemoryContent = interface; // type: System.Net.Http.ReadOnlyMemoryContent, namespace: System.Net.Http
  DNStreamContent = interface; // type: System.Net.Http.StreamContent, namespace: System.Net.Http
  DNHttpMessageHandler = interface; // type: System.Net.Http.HttpMessageHandler, namespace: System.Net.Http
  DNDelegatingHandler = interface; // type: System.Net.Http.DelegatingHandler, namespace: System.Net.Http
  DNMessageProcessingHandler = interface; // type: System.Net.Http.MessageProcessingHandler, namespace: System.Net.Http
  DNHttpClientHandler = interface; // type: System.Net.Http.HttpClientHandler, namespace: System.Net.Http
  DNSocketsHttpHandler = interface; // type: System.Net.Http.SocketsHttpHandler, namespace: System.Net.Http
  DNHttpMessageInvoker = interface; // type: System.Net.Http.HttpMessageInvoker, namespace: System.Net.Http
  DNHttpClient = interface; // type: System.Net.Http.HttpClient, namespace: System.Net.Http
  DNHttpMethod = interface; // type: System.Net.Http.HttpMethod, namespace: System.Net.Http
  DNHttpRequestMessage = interface; // type: System.Net.Http.HttpRequestMessage, namespace: System.Net.Http
  DNHttpResponseMessage = interface; // type: System.Net.Http.HttpResponseMessage, namespace: System.Net.Http


{ objects }

  //-------------namespace: System.Net.Http----------------
  DNHttpRequestExceptionClass = interface(DDNC.System.Private.CoreLib.DNExceptionClass)
  ['{2C466A7B-8B6E-520C-9631-1C886FF19F18}']
  { constructors } 

    {class} function init: DNHttpRequestException; overload;
    {class} function init(message: string): DNHttpRequestException; overload;
    {class} function init(message: string; inner: DDNC.System.Private.CoreLib.DNException): DNHttpRequestException; overload;

  end;

  [DNTypeName('System.Net.Http.HttpRequestException')]
  DNHttpRequestException = interface(DDNC.System.Private.CoreLib.DNException)
  ['{6D9DAAA5-905F-3E88-AD7E-5DCF42D793B6}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNHttpRequestException = class(TDNGenericImport<DNHttpRequestExceptionClass, DNHttpRequestException>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNAuthenticationHeaderValueClass = interface(DNObjectClass)
  ['{F6E6C04F-E434-5BBE-8194-8761ABFF9F83}']
  { constructors } 

    {class} function init(scheme: string): DNAuthenticationHeaderValue; overload;
    {class} function init(scheme: string; parameter: string): DNAuthenticationHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNAuthenticationHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNAuthenticationHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.AuthenticationHeaderValue')]
  DNAuthenticationHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{35EC0EF6-0866-336F-BD14-63B888DB48AF}']
  { getters & setters } 

    function get_Scheme: string;
    function get_Parameter: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Scheme: string read get_Scheme;
    property Parameter: string read get_Parameter;
  end;

  TDNAuthenticationHeaderValue = class(TDNGenericImport<DNAuthenticationHeaderValueClass, DNAuthenticationHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNCacheControlHeaderValueClass = interface(DNObjectClass)
  ['{0AA0322A-23FC-5D72-ADBF-25123B13B31F}']
  { constructors } 

    {class} function init: DNCacheControlHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNCacheControlHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNCacheControlHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.CacheControlHeaderValue')]
  DNCacheControlHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{91A258D5-08B4-3F1B-9B8B-AEB62BEB9AEC}']
  { getters & setters } 

    function get_NoCache: Boolean;
    procedure set_NoCache(value: Boolean);
    function get_NoCacheHeaders: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_NoStore: Boolean;
    procedure set_NoStore(value: Boolean);
    function get_MaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_MaxAge(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_SharedMaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_SharedMaxAge(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_MaxStale: Boolean;
    procedure set_MaxStale(value: Boolean);
    function get_MaxStaleLimit: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_MaxStaleLimit(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_MinFresh: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_MinFresh(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_NoTransform: Boolean;
    procedure set_NoTransform(value: Boolean);
    function get_OnlyIfCached: Boolean;
    procedure set_OnlyIfCached(value: Boolean);
    function get_Public: Boolean;
    procedure set_Public(value: Boolean);
    function get_Private: Boolean;
    procedure set_Private(value: Boolean);
    function get_PrivateHeaders: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_MustRevalidate: Boolean;
    procedure set_MustRevalidate(value: Boolean);
    function get_ProxyRevalidate: Boolean;
    procedure set_ProxyRevalidate(value: Boolean);
    function get_Extensions: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property NoCache: Boolean read get_NoCache write set_NoCache;
    property NoCacheHeaders: DDNC.System.Private.CoreLib.DNICollection<string> read get_NoCacheHeaders;
    property NoStore: Boolean read get_NoStore write set_NoStore;
    property MaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_MaxAge write set_MaxAge;
    property SharedMaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_SharedMaxAge write set_SharedMaxAge;
    property MaxStale: Boolean read get_MaxStale write set_MaxStale;
    property MaxStaleLimit: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_MaxStaleLimit write set_MaxStaleLimit;
    property MinFresh: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_MinFresh write set_MinFresh;
    property NoTransform: Boolean read get_NoTransform write set_NoTransform;
    property OnlyIfCached: Boolean read get_OnlyIfCached write set_OnlyIfCached;
    property &Public: Boolean read get_Public write set_Public;
    property &Private: Boolean read get_Private write set_Private;
    property PrivateHeaders: DDNC.System.Private.CoreLib.DNICollection<string> read get_PrivateHeaders;
    property MustRevalidate: Boolean read get_MustRevalidate write set_MustRevalidate;
    property ProxyRevalidate: Boolean read get_ProxyRevalidate write set_ProxyRevalidate;
    property Extensions: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Extensions;
  end;

  TDNCacheControlHeaderValue = class(TDNGenericImport<DNCacheControlHeaderValueClass, DNCacheControlHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNContentDispositionHeaderValueClass = interface(DNObjectClass)
  ['{C90B314E-B7B5-5496-BBC5-A9613D021DC9}']
  { constructors } 

    {class} function init(dispositionType: string): DNContentDispositionHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNContentDispositionHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNContentDispositionHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ContentDispositionHeaderValue')]
  DNContentDispositionHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{56D6FA80-4E73-3CBD-9F4B-285948ED4AA2}']
  { getters & setters } 

    function get_DispositionType: string;
    procedure set_DispositionType(value: string);
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_Name: string;
    procedure set_Name(value: string);
    function get_FileName: string;
    procedure set_FileName(value: string);
    function get_FileNameStar: string;
    procedure set_FileNameStar(value: string);
    function get_CreationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_CreationDate(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_ModificationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_ModificationDate(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_ReadDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_ReadDate(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_Size: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    procedure set_Size(value: DDNC.System.Private.CoreLib.DNNullable<Int64>);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property DispositionType: string read get_DispositionType write set_DispositionType;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property Name: string read get_Name write set_Name;
    property FileName: string read get_FileName write set_FileName;
    property FileNameStar: string read get_FileNameStar write set_FileNameStar;
    property CreationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_CreationDate write set_CreationDate;
    property ModificationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_ModificationDate write set_ModificationDate;
    property ReadDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_ReadDate write set_ReadDate;
    property Size: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_Size write set_Size;
  end;

  TDNContentDispositionHeaderValue = class(TDNGenericImport<DNContentDispositionHeaderValueClass, DNContentDispositionHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNContentRangeHeaderValueClass = interface(DNObjectClass)
  ['{ADCA465D-8449-5754-9D40-270F1E0B6312}']
  { constructors } 

    {class} function init(from: Int64; &to: Int64; length: Int64): DNContentRangeHeaderValue; overload;
    {class} function init(length: Int64): DNContentRangeHeaderValue; overload;
    {class} function init(from: Int64; &to: Int64): DNContentRangeHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNContentRangeHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNContentRangeHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ContentRangeHeaderValue')]
  DNContentRangeHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{3E39EA76-D2DA-3387-9A89-6466C964179A}']
  { getters & setters } 

    function get_Unit: string;
    procedure set_Unit(value: string);
    function get_From: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_To: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_Length: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_HasLength: Boolean;
    function get_HasRange: Boolean;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property &Unit: string read get_Unit write set_Unit;
    property From: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_From;
    property &To: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_To;
    property Length: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_Length;
    property HasLength: Boolean read get_HasLength;
    property HasRange: Boolean read get_HasRange;
  end;

  TDNContentRangeHeaderValue = class(TDNGenericImport<DNContentRangeHeaderValueClass, DNContentRangeHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNEntityTagHeaderValueClass = interface(DNObjectClass)
  ['{88096008-0F07-509C-8ACF-D95B1D78F55F}']
  { static getter & setter } 

    {class} function get_Any: DNEntityTagHeaderValue;

  { constructors } 

    {class} function init(tag: string): DNEntityTagHeaderValue; overload;
    {class} function init(tag: string; isWeak: Boolean): DNEntityTagHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNEntityTagHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNEntityTagHeaderValue): Boolean;

  { static propertys } 

    {class} property Any: DNEntityTagHeaderValue read get_Any;
  end;

  [DNTypeName('System.Net.Http.Headers.EntityTagHeaderValue')]
  DNEntityTagHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{92F3F061-664A-3971-8472-0235E3D1197A}']
  { getters & setters } 

    function get_Tag: string;
    function get_IsWeak: Boolean;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Tag: string read get_Tag;
    property IsWeak: Boolean read get_IsWeak;
  end;

  TDNEntityTagHeaderValue = class(TDNGenericImport<DNEntityTagHeaderValueClass, DNEntityTagHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpHeadersClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{29F7CDC0-39BF-5100-AFE7-9B3DBC363693}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpHeaders')]
  DNHttpHeaders = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C71542D2-E050-3D5C-BCA3-FFCC41EE7CB9}']
  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function Remove(name: string): Boolean;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpHeaders = class(TDNGenericImport<DNHttpHeadersClass, DNHttpHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpContentHeadersClass = interface(DNHttpHeadersClass)
  ['{DC4C6DB4-A032-50DB-9F43-CAE48AF31965}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpContentHeaders')]
  DNHttpContentHeaders = interface(DNHttpHeaders)
  ['{91350A2A-46C9-3472-9C7F-4F71E81FC2A7}']
  { getters & setters } 

    function get_Allow: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_ContentDisposition: DNContentDispositionHeaderValue;
    procedure set_ContentDisposition(value: DNContentDispositionHeaderValue);
    function get_ContentEncoding: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_ContentLanguage: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_ContentLength: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    procedure set_ContentLength(value: DDNC.System.Private.CoreLib.DNNullable<Int64>);
    function get_ContentLocation: DDNC.System.Private.Uri.DNUri;
    procedure set_ContentLocation(value: DDNC.System.Private.Uri.DNUri);
    function get_ContentMD5: TArray<Byte>;
    procedure set_ContentMD5(value: TArray<Byte>);
    function get_ContentRange: DNContentRangeHeaderValue;
    procedure set_ContentRange(value: DNContentRangeHeaderValue);
    function get_ContentType: DNMediaTypeHeaderValue;
    procedure set_ContentType(value: DNMediaTypeHeaderValue);
    function get_Expires: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_Expires(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_LastModified: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_LastModified(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);

  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function Remove(name: string): Boolean;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Allow: DDNC.System.Private.CoreLib.DNICollection<string> read get_Allow;
    property ContentDisposition: DNContentDispositionHeaderValue read get_ContentDisposition write set_ContentDisposition;
    property ContentEncoding: DDNC.System.Private.CoreLib.DNICollection<string> read get_ContentEncoding;
    property ContentLanguage: DDNC.System.Private.CoreLib.DNICollection<string> read get_ContentLanguage;
    property ContentLength: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_ContentLength write set_ContentLength;
    property ContentLocation: DDNC.System.Private.Uri.DNUri read get_ContentLocation write set_ContentLocation;
    property ContentMD5: TArray<Byte> read get_ContentMD5 write set_ContentMD5;
    property ContentRange: DNContentRangeHeaderValue read get_ContentRange write set_ContentRange;
    property ContentType: DNMediaTypeHeaderValue read get_ContentType write set_ContentType;
    property Expires: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Expires write set_Expires;
    property LastModified: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_LastModified write set_LastModified;
  end;

  TDNHttpContentHeaders = class(TDNGenericImport<DNHttpContentHeadersClass, DNHttpContentHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpRequestHeadersClass = interface(DNHttpHeadersClass)
  ['{D47AE5A8-7CA0-5A6F-AA1B-BDF2E224B7D6}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpRequestHeaders')]
  DNHttpRequestHeaders = interface(DNHttpHeaders)
  ['{C70082FB-9413-3981-821F-4D4C624204AF}']
  { getters & setters } 

    function get_Accept: DNHttpHeaderValueCollection<DNMediaTypeWithQualityHeaderValue>;
    function get_AcceptCharset: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue>;
    function get_AcceptEncoding: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue>;
    function get_AcceptLanguage: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue>;
    function get_Authorization: DNAuthenticationHeaderValue;
    procedure set_Authorization(value: DNAuthenticationHeaderValue);
    function get_Expect: DNHttpHeaderValueCollection<DNNameValueWithParametersHeaderValue>;
    function get_ExpectContinue: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_ExpectContinue(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_From: string;
    procedure set_From(value: string);
    function get_Host: string;
    procedure set_Host(value: string);
    function get_IfMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue>;
    function get_IfModifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_IfModifiedSince(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_IfNoneMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue>;
    function get_IfRange: DNRangeConditionHeaderValue;
    procedure set_IfRange(value: DNRangeConditionHeaderValue);
    function get_IfUnmodifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_IfUnmodifiedSince(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_MaxForwards: DDNC.System.Private.CoreLib.DNNullable<Int32>;
    procedure set_MaxForwards(value: DDNC.System.Private.CoreLib.DNNullable<Int32>);
    function get_ProxyAuthorization: DNAuthenticationHeaderValue;
    procedure set_ProxyAuthorization(value: DNAuthenticationHeaderValue);
    function get_Range: DNRangeHeaderValue;
    procedure set_Range(value: DNRangeHeaderValue);
    function get_Referrer: DDNC.System.Private.Uri.DNUri;
    procedure set_Referrer(value: DDNC.System.Private.Uri.DNUri);
    function get_TE: DNHttpHeaderValueCollection<DNTransferCodingWithQualityHeaderValue>;
    function get_UserAgent: DNHttpHeaderValueCollection<DNProductInfoHeaderValue>;
    function get_CacheControl: DNCacheControlHeaderValue;
    procedure set_CacheControl(value: DNCacheControlHeaderValue);
    function get_Connection: DNHttpHeaderValueCollection<string>;
    function get_ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_ConnectionClose(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_Date(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue>;
    function get_Trailer: DNHttpHeaderValueCollection<string>;
    function get_TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue>;
    function get_TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_TransferEncodingChunked(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue>;
    function get_Via: DNHttpHeaderValueCollection<DNViaHeaderValue>;
    function get_Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue>;

  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function Remove(name: string): Boolean;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Accept: DNHttpHeaderValueCollection<DNMediaTypeWithQualityHeaderValue> read get_Accept;
    property AcceptCharset: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue> read get_AcceptCharset;
    property AcceptEncoding: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue> read get_AcceptEncoding;
    property AcceptLanguage: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue> read get_AcceptLanguage;
    property Authorization: DNAuthenticationHeaderValue read get_Authorization write set_Authorization;
    property Expect: DNHttpHeaderValueCollection<DNNameValueWithParametersHeaderValue> read get_Expect;
    property ExpectContinue: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_ExpectContinue write set_ExpectContinue;
    property From: string read get_From write set_From;
    property Host: string read get_Host write set_Host;
    property IfMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue> read get_IfMatch;
    property IfModifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_IfModifiedSince write set_IfModifiedSince;
    property IfNoneMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue> read get_IfNoneMatch;
    property IfRange: DNRangeConditionHeaderValue read get_IfRange write set_IfRange;
    property IfUnmodifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_IfUnmodifiedSince write set_IfUnmodifiedSince;
    property MaxForwards: DDNC.System.Private.CoreLib.DNNullable<Int32> read get_MaxForwards write set_MaxForwards;
    property ProxyAuthorization: DNAuthenticationHeaderValue read get_ProxyAuthorization write set_ProxyAuthorization;
    property Range: DNRangeHeaderValue read get_Range write set_Range;
    property Referrer: DDNC.System.Private.Uri.DNUri read get_Referrer write set_Referrer;
    property TE: DNHttpHeaderValueCollection<DNTransferCodingWithQualityHeaderValue> read get_TE;
    property UserAgent: DNHttpHeaderValueCollection<DNProductInfoHeaderValue> read get_UserAgent;
    property CacheControl: DNCacheControlHeaderValue read get_CacheControl write set_CacheControl;
    property Connection: DNHttpHeaderValueCollection<string> read get_Connection;
    property ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_ConnectionClose write set_ConnectionClose;
    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date write set_Date;
    property Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue> read get_Pragma;
    property Trailer: DNHttpHeaderValueCollection<string> read get_Trailer;
    property TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue> read get_TransferEncoding;
    property TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_TransferEncodingChunked write set_TransferEncodingChunked;
    property Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue> read get_Upgrade;
    property Via: DNHttpHeaderValueCollection<DNViaHeaderValue> read get_Via;
    property Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue> read get_Warning;
  end;

  TDNHttpRequestHeaders = class(TDNGenericImport<DNHttpRequestHeadersClass, DNHttpRequestHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpResponseHeadersClass = interface(DNHttpHeadersClass)
  ['{53FB55D8-015D-5165-BA36-BBF0B5C5C90A}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpResponseHeaders')]
  DNHttpResponseHeaders = interface(DNHttpHeaders)
  ['{AAA305FB-7B77-320E-A6D0-56DADAB7D4AA}']
  { getters & setters } 

    function get_AcceptRanges: DNHttpHeaderValueCollection<string>;
    function get_Age: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_Age(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_ETag: DNEntityTagHeaderValue;
    procedure set_ETag(value: DNEntityTagHeaderValue);
    function get_Location: DDNC.System.Private.Uri.DNUri;
    procedure set_Location(value: DDNC.System.Private.Uri.DNUri);
    function get_ProxyAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue>;
    function get_RetryAfter: DNRetryConditionHeaderValue;
    procedure set_RetryAfter(value: DNRetryConditionHeaderValue);
    function get_Server: DNHttpHeaderValueCollection<DNProductInfoHeaderValue>;
    function get_Vary: DNHttpHeaderValueCollection<string>;
    function get_WwwAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue>;
    function get_CacheControl: DNCacheControlHeaderValue;
    procedure set_CacheControl(value: DNCacheControlHeaderValue);
    function get_Connection: DNHttpHeaderValueCollection<string>;
    function get_ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_ConnectionClose(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_Date(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue>;
    function get_Trailer: DNHttpHeaderValueCollection<string>;
    function get_TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue>;
    function get_TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_TransferEncodingChunked(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue>;
    function get_Via: DNHttpHeaderValueCollection<DNViaHeaderValue>;
    function get_Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue>;

  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function Remove(name: string): Boolean;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AcceptRanges: DNHttpHeaderValueCollection<string> read get_AcceptRanges;
    property Age: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_Age write set_Age;
    property ETag: DNEntityTagHeaderValue read get_ETag write set_ETag;
    property Location: DDNC.System.Private.Uri.DNUri read get_Location write set_Location;
    property ProxyAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue> read get_ProxyAuthenticate;
    property RetryAfter: DNRetryConditionHeaderValue read get_RetryAfter write set_RetryAfter;
    property Server: DNHttpHeaderValueCollection<DNProductInfoHeaderValue> read get_Server;
    property Vary: DNHttpHeaderValueCollection<string> read get_Vary;
    property WwwAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue> read get_WwwAuthenticate;
    property CacheControl: DNCacheControlHeaderValue read get_CacheControl write set_CacheControl;
    property Connection: DNHttpHeaderValueCollection<string> read get_Connection;
    property ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_ConnectionClose write set_ConnectionClose;
    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date write set_Date;
    property Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue> read get_Pragma;
    property Trailer: DNHttpHeaderValueCollection<string> read get_Trailer;
    property TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue> read get_TransferEncoding;
    property TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_TransferEncodingChunked write set_TransferEncodingChunked;
    property Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue> read get_Upgrade;
    property Via: DNHttpHeaderValueCollection<DNViaHeaderValue> read get_Via;
    property Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue> read get_Warning;
  end;

  TDNHttpResponseHeaders = class(TDNGenericImport<DNHttpResponseHeadersClass, DNHttpResponseHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpHeaderValueCollectionClass<T> = interface(DNObjectClass)
  ['{48A5804E-D508-5724-99A5-6C3DACC4B6E6}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpHeaderValueCollection`1')]
  DNHttpHeaderValueCollection<T> = interface(DDNC.System.Private.CoreLib.DNICollection<T>)
  ['{35BE04C5-41FA-316A-911E-6B4C3BF5F5C3}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;

  { methods } 

    procedure ParseAdd(input: string);
    function TryParseAdd(input: string): Boolean;
    function &Contains(item: T): Boolean;
    procedure CopyTo(&array: TArray<T>; arrayIndex: Int32);
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<T>;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
  end;

  TDNHttpHeaderValueCollection<T> = class(TDNGenericImport<DNHttpHeaderValueCollectionClass<T>, DNHttpHeaderValueCollection<T>>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNMediaTypeHeaderValueClass = interface(DNObjectClass)
  ['{BC0A585F-B759-5E45-83B4-78D205BD531D}']
  { constructors } 

    {class} function init(mediaType: string): DNMediaTypeHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNMediaTypeHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNMediaTypeHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.MediaTypeHeaderValue')]
  DNMediaTypeHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{CA92518F-5D16-3F7A-9C1C-EDAC62DF98CC}']
  { getters & setters } 

    function get_CharSet: string;
    procedure set_CharSet(value: string);
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_MediaType: string;
    procedure set_MediaType(value: string);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CharSet: string read get_CharSet write set_CharSet;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property MediaType: string read get_MediaType write set_MediaType;
  end;

  TDNMediaTypeHeaderValue = class(TDNGenericImport<DNMediaTypeHeaderValueClass, DNMediaTypeHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNMediaTypeWithQualityHeaderValueClass = interface(DNMediaTypeHeaderValueClass)
  ['{2EB8DE94-AC11-5C83-AE1C-9239D9A817ED}']
  { constructors } 

    {class} function init(mediaType: string): DNMediaTypeWithQualityHeaderValue; overload;
    {class} function init(mediaType: string; quality: Double): DNMediaTypeWithQualityHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNMediaTypeWithQualityHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNMediaTypeWithQualityHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.MediaTypeWithQualityHeaderValue')]
  DNMediaTypeWithQualityHeaderValue = interface(DNMediaTypeHeaderValue)
  ['{CBB308C0-F58E-3031-8124-F0A9311A0D75}']
  { getters & setters } 

    function get_Quality: DDNC.System.Private.CoreLib.DNNullable<Double>;
    procedure set_Quality(value: DDNC.System.Private.CoreLib.DNNullable<Double>);
    function get_CharSet: string;
    procedure set_CharSet(value: string);
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_MediaType: string;
    procedure set_MediaType(value: string);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Quality: DDNC.System.Private.CoreLib.DNNullable<Double> read get_Quality write set_Quality;
    property CharSet: string read get_CharSet write set_CharSet;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property MediaType: string read get_MediaType write set_MediaType;
  end;

  TDNMediaTypeWithQualityHeaderValue = class(TDNGenericImport<DNMediaTypeWithQualityHeaderValueClass, DNMediaTypeWithQualityHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNNameValueHeaderValueClass = interface(DNObjectClass)
  ['{2FC60D5B-9269-5FEC-A36F-EEB7652DB140}']
  { constructors } 

    {class} function init(name: string): DNNameValueHeaderValue; overload;
    {class} function init(name: string; value: string): DNNameValueHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNNameValueHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNNameValueHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.NameValueHeaderValue')]
  DNNameValueHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{61B89549-702C-35AF-B962-20DE998F8CDC}']
  { getters & setters } 

    function get_Name: string;
    function get_Value: string;
    procedure set_Value(value: string);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Value: string read get_Value write set_Value;
  end;

  TDNNameValueHeaderValue = class(TDNGenericImport<DNNameValueHeaderValueClass, DNNameValueHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNNameValueWithParametersHeaderValueClass = interface(DNNameValueHeaderValueClass)
  ['{FE8DB19B-7BC8-59FB-AEC5-4B790161DF7E}']
  { constructors } 

    {class} function init(name: string): DNNameValueWithParametersHeaderValue; overload;
    {class} function init(name: string; value: string): DNNameValueWithParametersHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNNameValueWithParametersHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNNameValueWithParametersHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.NameValueWithParametersHeaderValue')]
  DNNameValueWithParametersHeaderValue = interface(DNNameValueHeaderValue)
  ['{F04F6137-1CE2-3829-A906-B3F8B47359AE}']
  { getters & setters } 

    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_Name: string;
    function get_Value: string;
    procedure set_Value(value: string);

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property Name: string read get_Name;
    property Value: string read get_Value write set_Value;
  end;

  TDNNameValueWithParametersHeaderValue = class(TDNGenericImport<DNNameValueWithParametersHeaderValueClass, DNNameValueWithParametersHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNProductHeaderValueClass = interface(DNObjectClass)
  ['{D816C5BE-1B04-5BCC-BA12-5465A943422B}']
  { constructors } 

    {class} function init(name: string): DNProductHeaderValue; overload;
    {class} function init(name: string; version: string): DNProductHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNProductHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNProductHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ProductHeaderValue')]
  DNProductHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{765F7C7B-2561-3A88-AD9D-6B221770A5FD}']
  { getters & setters } 

    function get_Name: string;
    function get_Version: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Version: string read get_Version;
  end;

  TDNProductHeaderValue = class(TDNGenericImport<DNProductHeaderValueClass, DNProductHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNProductInfoHeaderValueClass = interface(DNObjectClass)
  ['{9A4E428D-CAF3-58E6-B4FF-F3FC5E8FD0FC}']
  { constructors } 

    {class} function init(productName: string; productVersion: string): DNProductInfoHeaderValue; overload;
    {class} function init(product: DNProductHeaderValue): DNProductInfoHeaderValue; overload;
    {class} function init(comment: string): DNProductInfoHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNProductInfoHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNProductInfoHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ProductInfoHeaderValue')]
  DNProductInfoHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{F399D712-67F1-3881-8EBC-E3501FDDE652}']
  { getters & setters } 

    function get_Product: DNProductHeaderValue;
    function get_Comment: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Product: DNProductHeaderValue read get_Product;
    property Comment: string read get_Comment;
  end;

  TDNProductInfoHeaderValue = class(TDNGenericImport<DNProductInfoHeaderValueClass, DNProductInfoHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRangeConditionHeaderValueClass = interface(DNObjectClass)
  ['{286E3C6D-1CC8-5551-BB06-03418F3E9052}']
  { constructors } 

    {class} function init(date: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNRangeConditionHeaderValue; overload;
    {class} function init(entityTag: DNEntityTagHeaderValue): DNRangeConditionHeaderValue; overload;
    {class} function init(entityTag: string): DNRangeConditionHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNRangeConditionHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNRangeConditionHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.RangeConditionHeaderValue')]
  DNRangeConditionHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{C5B8406A-1000-3B40-B209-90B88BED73C1}']
  { getters & setters } 

    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    function get_EntityTag: DNEntityTagHeaderValue;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date;
    property EntityTag: DNEntityTagHeaderValue read get_EntityTag;
  end;

  TDNRangeConditionHeaderValue = class(TDNGenericImport<DNRangeConditionHeaderValueClass, DNRangeConditionHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRangeHeaderValueClass = interface(DNObjectClass)
  ['{6A388B2C-31AC-52A7-914F-8B0B60611DD4}']
  { constructors } 

    {class} function init: DNRangeHeaderValue; overload;
    {class} function init(from: DDNC.System.Private.CoreLib.DNNullable<Int64>; &to: DDNC.System.Private.CoreLib.DNNullable<Int64>): DNRangeHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNRangeHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNRangeHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.RangeHeaderValue')]
  DNRangeHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{5F77D260-FCCF-326E-AE60-367F23AF5E3B}']
  { getters & setters } 

    function get_Unit: string;
    procedure set_Unit(value: string);
    function get_Ranges: DDNC.System.Private.CoreLib.DNICollection<DNRangeItemHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property &Unit: string read get_Unit write set_Unit;
    property Ranges: DDNC.System.Private.CoreLib.DNICollection<DNRangeItemHeaderValue> read get_Ranges;
  end;

  TDNRangeHeaderValue = class(TDNGenericImport<DNRangeHeaderValueClass, DNRangeHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRangeItemHeaderValueClass = interface(DNObjectClass)
  ['{9432BBE7-4CCE-5BC9-97CA-9915081A3A4E}']
  { constructors } 

    {class} function init(from: DDNC.System.Private.CoreLib.DNNullable<Int64>; &to: DDNC.System.Private.CoreLib.DNNullable<Int64>): DNRangeItemHeaderValue;

  end;

  [DNTypeName('System.Net.Http.Headers.RangeItemHeaderValue')]
  DNRangeItemHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{F0529260-365B-34BF-A37D-F44C56C23471}']
  { getters & setters } 

    function get_From: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_To: DDNC.System.Private.CoreLib.DNNullable<Int64>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property From: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_From;
    property &To: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_To;
  end;

  TDNRangeItemHeaderValue = class(TDNGenericImport<DNRangeItemHeaderValueClass, DNRangeItemHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRetryConditionHeaderValueClass = interface(DNObjectClass)
  ['{E095D2DB-B0C2-55E1-B293-525BDF48ADC5}']
  { constructors } 

    {class} function init(date: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNRetryConditionHeaderValue; overload;
    {class} function init(delta: DDNC.System.Private.CoreLib.DNTimeSpan): DNRetryConditionHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNRetryConditionHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNRetryConditionHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.RetryConditionHeaderValue')]
  DNRetryConditionHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{2ADD0403-642F-3D9D-A4EA-5DDA9584DED1}']
  { getters & setters } 

    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    function get_Delta: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date;
    property Delta: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_Delta;
  end;

  TDNRetryConditionHeaderValue = class(TDNGenericImport<DNRetryConditionHeaderValueClass, DNRetryConditionHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNStringWithQualityHeaderValueClass = interface(DNObjectClass)
  ['{842E3C2E-9CB0-5E8B-82A4-DD0EBCC666B2}']
  { constructors } 

    {class} function init(value: string): DNStringWithQualityHeaderValue; overload;
    {class} function init(value: string; quality: Double): DNStringWithQualityHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNStringWithQualityHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNStringWithQualityHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.StringWithQualityHeaderValue')]
  DNStringWithQualityHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{D536D71A-1960-3644-84B5-D7B263B66FC3}']
  { getters & setters } 

    function get_Value: string;
    function get_Quality: DDNC.System.Private.CoreLib.DNNullable<Double>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Value: string read get_Value;
    property Quality: DDNC.System.Private.CoreLib.DNNullable<Double> read get_Quality;
  end;

  TDNStringWithQualityHeaderValue = class(TDNGenericImport<DNStringWithQualityHeaderValueClass, DNStringWithQualityHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNTransferCodingHeaderValueClass = interface(DNObjectClass)
  ['{B4645376-6883-5D69-AB99-F5ED9F125AE0}']
  { constructors } 

    {class} function init(value: string): DNTransferCodingHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNTransferCodingHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNTransferCodingHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.TransferCodingHeaderValue')]
  DNTransferCodingHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{4FBE1E24-13CE-3F3E-8FA9-D5671B52E7FA}']
  { getters & setters } 

    function get_Value: string;
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Value: string read get_Value;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
  end;

  TDNTransferCodingHeaderValue = class(TDNGenericImport<DNTransferCodingHeaderValueClass, DNTransferCodingHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNTransferCodingWithQualityHeaderValueClass = interface(DNTransferCodingHeaderValueClass)
  ['{914D3D78-9BB2-56F4-8E34-F2A6B911A3B4}']
  { constructors } 

    {class} function init(value: string): DNTransferCodingWithQualityHeaderValue; overload;
    {class} function init(value: string; quality: Double): DNTransferCodingWithQualityHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNTransferCodingWithQualityHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNTransferCodingWithQualityHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.TransferCodingWithQualityHeaderValue')]
  DNTransferCodingWithQualityHeaderValue = interface(DNTransferCodingHeaderValue)
  ['{B21EC53D-64B7-36B5-964B-E378CB39C205}']
  { getters & setters } 

    function get_Quality: DDNC.System.Private.CoreLib.DNNullable<Double>;
    procedure set_Quality(value: DDNC.System.Private.CoreLib.DNNullable<Double>);
    function get_Value: string;
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Quality: DDNC.System.Private.CoreLib.DNNullable<Double> read get_Quality write set_Quality;
    property Value: string read get_Value;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
  end;

  TDNTransferCodingWithQualityHeaderValue = class(TDNGenericImport<DNTransferCodingWithQualityHeaderValueClass, DNTransferCodingWithQualityHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNViaHeaderValueClass = interface(DNObjectClass)
  ['{288F2805-06F7-5FDB-8DD5-6FB0891F901F}']
  { constructors } 

    {class} function init(protocolVersion: string; receivedBy: string): DNViaHeaderValue; overload;
    {class} function init(protocolVersion: string; receivedBy: string; protocolName: string): DNViaHeaderValue; overload;
    {class} function init(protocolVersion: string; receivedBy: string; protocolName: string; comment: string): DNViaHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNViaHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNViaHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ViaHeaderValue')]
  DNViaHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{76EE9F0F-8029-3729-BF3F-7AF2631203E2}']
  { getters & setters } 

    function get_ProtocolName: string;
    function get_ProtocolVersion: string;
    function get_ReceivedBy: string;
    function get_Comment: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ProtocolName: string read get_ProtocolName;
    property ProtocolVersion: string read get_ProtocolVersion;
    property ReceivedBy: string read get_ReceivedBy;
    property Comment: string read get_Comment;
  end;

  TDNViaHeaderValue = class(TDNGenericImport<DNViaHeaderValueClass, DNViaHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNWarningHeaderValueClass = interface(DNObjectClass)
  ['{8C782FA5-D0E5-5738-81D9-8112E4433E09}']
  { constructors } 

    {class} function init(code: Int32; agent: string; text: string): DNWarningHeaderValue; overload;
    {class} function init(code: Int32; agent: string; text: string; date: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNWarningHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNWarningHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNWarningHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.WarningHeaderValue')]
  DNWarningHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{9DDC74A9-9681-3807-8D85-C9DED44D0A2A}']
  { getters & setters } 

    function get_Code: Int32;
    function get_Agent: string;
    function get_Text: string;
    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Code: Int32 read get_Code;
    property Agent: string read get_Agent;
    property Text: string read get_Text;
    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date;
  end;

  TDNWarningHeaderValue = class(TDNGenericImport<DNWarningHeaderValueClass, DNWarningHeaderValue>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpContentClass = interface(DNObjectClass)
  ['{35E13C67-491D-5FC4-952C-C8059E2C354E}']
  end;

  [DNTypeName('System.Net.Http.HttpContent')]
  DNHttpContent = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{B4F817EF-29C3-3795-A906-9B1790300A99}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNHttpContent = class(TDNGenericImport<DNHttpContentClass, DNHttpContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNByteArrayContentClass = interface(DNHttpContentClass)
  ['{9C596777-0C5E-5DB8-B0F3-96FEABBDBE4A}']
  { constructors } 

    {class} function init(content: TArray<Byte>): DNByteArrayContent; overload;
    {class} function init(content: TArray<Byte>; offset: Int32; count: Int32): DNByteArrayContent; overload;

  end;

  [DNTypeName('System.Net.Http.ByteArrayContent')]
  DNByteArrayContent = interface(DNHttpContent)
  ['{7830932C-1BFF-3769-BDD9-DA403AC26B12}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNByteArrayContent = class(TDNGenericImport<DNByteArrayContentClass, DNByteArrayContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNFormUrlEncodedContentClass = interface(DNByteArrayContentClass)
  ['{C15AA401-05CC-5E7E-9C97-DC2AFD4E7477}']
  { constructors } 

    {class} function init(nameValueCollection: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, string>>): DNFormUrlEncodedContent;

  end;

  [DNTypeName('System.Net.Http.FormUrlEncodedContent')]
  DNFormUrlEncodedContent = interface(DNByteArrayContent)
  ['{0E27632D-26A9-3812-A078-D8C6BCA7E88F}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNFormUrlEncodedContent = class(TDNGenericImport<DNFormUrlEncodedContentClass, DNFormUrlEncodedContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNStringContentClass = interface(DNByteArrayContentClass)
  ['{06D768CA-9068-54EE-8DD0-07564BD2EABB}']
  { constructors } 

    {class} function init(content: string): DNStringContent; overload;
    {class} function init(content: string; encoding: DDNC.System.Private.CoreLib.DNEncoding): DNStringContent; overload;
    {class} function init(content: string; encoding: DDNC.System.Private.CoreLib.DNEncoding; mediaType: string): DNStringContent; overload;

  end;

  [DNTypeName('System.Net.Http.StringContent')]
  DNStringContent = interface(DNByteArrayContent)
  ['{B197CA34-71BF-3C28-8631-6D9D8E7DF76A}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNStringContent = class(TDNGenericImport<DNStringContentClass, DNStringContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNMultipartContentClass = interface(DNHttpContentClass)
  ['{CBDEFDFA-BE7D-5789-A52C-B6F563FE50C5}']
  { constructors } 

    {class} function init: DNMultipartContent; overload;
    {class} function init(subtype: string): DNMultipartContent; overload;
    {class} function init(subtype: string; boundary: string): DNMultipartContent; overload;

  end;

  [DNTypeName('System.Net.Http.MultipartContent')]
  DNMultipartContent = interface(DNHttpContent)
  ['{E4D2A81B-1AFB-3FC3-937B-16BD5F158E65}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    procedure Add(content: DNHttpContent);
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNHttpContent>;
    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNMultipartContent = class(TDNGenericImport<DNMultipartContentClass, DNMultipartContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNMultipartFormDataContentClass = interface(DNMultipartContentClass)
  ['{CC756328-0F67-5226-8412-9FBA87325C06}']
  { constructors } 

    {class} function init: DNMultipartFormDataContent; overload;
    {class} function init(boundary: string): DNMultipartFormDataContent; overload;

  end;

  [DNTypeName('System.Net.Http.MultipartFormDataContent')]
  DNMultipartFormDataContent = interface(DNMultipartContent)
  ['{F0778E9A-469E-342E-A5CB-C2B3BABD254F}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    procedure Add(content: DNHttpContent); overload;
    procedure Add(content: DNHttpContent; name: string); overload;
    procedure Add(content: DNHttpContent; name: string; fileName: string); overload;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNHttpContent>;
    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNMultipartFormDataContent = class(TDNGenericImport<DNMultipartFormDataContentClass, DNMultipartFormDataContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNReadOnlyMemoryContentClass = interface(DNHttpContentClass)
  ['{FD0CEEAC-087F-5173-80EB-F954B9BC4890}']
  { constructors } 

    {class} function init(content: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>): DNReadOnlyMemoryContent;

  end;

  [DNTypeName('System.Net.Http.ReadOnlyMemoryContent')]
  DNReadOnlyMemoryContent = interface(DNHttpContent)
  ['{B80664E0-9D8A-33F8-BC13-2B08C241FF42}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNReadOnlyMemoryContent = class(TDNGenericImport<DNReadOnlyMemoryContentClass, DNReadOnlyMemoryContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNStreamContentClass = interface(DNHttpContentClass)
  ['{1034F907-F25C-59C1-9C4F-6E0CF8CC02A1}']
  { constructors } 

    {class} function init(content: DDNC.System.Private.CoreLib.DNStream): DNStreamContent; overload;
    {class} function init(content: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DNStreamContent; overload;

  end;

  [DNTypeName('System.Net.Http.StreamContent')]
  DNStreamContent = interface(DNHttpContent)
  ['{FF16302B-C064-3B5E-8231-3C83C003C1BA}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNStreamContent = class(TDNGenericImport<DNStreamContentClass, DNStreamContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpMessageHandlerClass = interface(DNObjectClass)
  ['{AA873B16-0053-5FFD-A514-F6FD914C99FC}']
  end;

  [DNTypeName('System.Net.Http.HttpMessageHandler')]
  DNHttpMessageHandler = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{C2EDA899-5289-3CFC-993E-C3D972811FA1}']
  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpMessageHandler = class(TDNGenericImport<DNHttpMessageHandlerClass, DNHttpMessageHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNDelegatingHandlerClass = interface(DNHttpMessageHandlerClass)
  ['{0803F540-67AF-558D-A94A-944370D1D5D9}']
  end;

  [DNTypeName('System.Net.Http.DelegatingHandler')]
  DNDelegatingHandler = interface(DNHttpMessageHandler)
  ['{E33A6E7D-6D8F-346F-86B6-1BFE8953776D}']
  { getters & setters } 

    function get_InnerHandler: DNHttpMessageHandler;
    procedure set_InnerHandler(value: DNHttpMessageHandler);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property InnerHandler: DNHttpMessageHandler read get_InnerHandler write set_InnerHandler;
  end;

  TDNDelegatingHandler = class(TDNGenericImport<DNDelegatingHandlerClass, DNDelegatingHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNMessageProcessingHandlerClass = interface(DNDelegatingHandlerClass)
  ['{57C1D2D0-4094-5F90-B8F9-0D1C50932A13}']
  end;

  [DNTypeName('System.Net.Http.MessageProcessingHandler')]
  DNMessageProcessingHandler = interface(DNDelegatingHandler)
  ['{EB9BB57D-0A3E-368D-AD3F-ED8376D5C6AC}']
  { getters & setters } 

    function get_InnerHandler: DNHttpMessageHandler;
    procedure set_InnerHandler(value: DNHttpMessageHandler);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property InnerHandler: DNHttpMessageHandler read get_InnerHandler write set_InnerHandler;
  end;

  TDNMessageProcessingHandler = class(TDNGenericImport<DNMessageProcessingHandlerClass, DNMessageProcessingHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpClientHandlerClass = interface(DNHttpMessageHandlerClass)
  ['{FC19996D-7986-5401-AC73-128024ABCE43}']
  { static getter & setter } 

    {class} function get_DangerousAcceptAnyServerCertificateValidator: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean>;

  { constructors } 

    {class} function init: DNHttpClientHandler;

  { static propertys } 

    {class} property DangerousAcceptAnyServerCertificateValidator: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean> read get_DangerousAcceptAnyServerCertificateValidator;
  end;

  [DNTypeName('System.Net.Http.HttpClientHandler')]
  DNHttpClientHandler = interface(DNHttpMessageHandler)
  ['{EC9BD574-4952-3DE0-BB6D-56017755D9F2}']
  { getters & setters } 

    function get_MaxRequestContentBufferSize: Int64;
    procedure set_MaxRequestContentBufferSize(value: Int64);
    function get_SupportsAutomaticDecompression: Boolean;
    function get_SupportsProxy: Boolean;
    function get_SupportsRedirectConfiguration: Boolean;
    function get_UseCookies: Boolean;
    procedure set_UseCookies(value: Boolean);
    function get_CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer;
    procedure set_CookieContainer(value: DDNC.System.Net.Primitives.DNCookieContainer);
    function get_AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods;
    procedure set_AutomaticDecompression(value: DDNC.System.Net.Primitives.DNDecompressionMethods);
    function get_UseProxy: Boolean;
    procedure set_UseProxy(value: Boolean);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_DefaultProxyCredentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_UseDefaultCredentials: Boolean;
    procedure set_UseDefaultCredentials(value: Boolean);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_AllowAutoRedirect: Boolean;
    procedure set_AllowAutoRedirect(value: Boolean);
    function get_MaxAutomaticRedirections: Int32;
    procedure set_MaxAutomaticRedirections(value: Int32);
    function get_MaxConnectionsPerServer: Int32;
    procedure set_MaxConnectionsPerServer(value: Int32);
    function get_MaxResponseHeadersLength: Int32;
    procedure set_MaxResponseHeadersLength(value: Int32);
    function get_ClientCertificateOptions: DNClientCertificateOption;
    procedure set_ClientCertificateOptions(value: DNClientCertificateOption);
    function get_ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection;
    function get_ServerCertificateCustomValidationCallback: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean>;
    procedure set_ServerCertificateCustomValidationCallback(value: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean>);
    function get_CheckCertificateRevocationList: Boolean;
    procedure set_CheckCertificateRevocationList(value: Boolean);
    function get_SslProtocols: DDNC.System.Net.Primitives.DNSslProtocols;
    procedure set_SslProtocols(value: DDNC.System.Net.Primitives.DNSslProtocols);
    function get_Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject>;

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property MaxRequestContentBufferSize: Int64 read get_MaxRequestContentBufferSize write set_MaxRequestContentBufferSize;
    property SupportsAutomaticDecompression: Boolean read get_SupportsAutomaticDecompression;
    property SupportsProxy: Boolean read get_SupportsProxy;
    property SupportsRedirectConfiguration: Boolean read get_SupportsRedirectConfiguration;
    property UseCookies: Boolean read get_UseCookies write set_UseCookies;
    property CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer read get_CookieContainer write set_CookieContainer;
    property AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods read get_AutomaticDecompression write set_AutomaticDecompression;
    property UseProxy: Boolean read get_UseProxy write set_UseProxy;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials read get_DefaultProxyCredentials write set_DefaultProxyCredentials;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property UseDefaultCredentials: Boolean read get_UseDefaultCredentials write set_UseDefaultCredentials;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property AllowAutoRedirect: Boolean read get_AllowAutoRedirect write set_AllowAutoRedirect;
    property MaxAutomaticRedirections: Int32 read get_MaxAutomaticRedirections write set_MaxAutomaticRedirections;
    property MaxConnectionsPerServer: Int32 read get_MaxConnectionsPerServer write set_MaxConnectionsPerServer;
    property MaxResponseHeadersLength: Int32 read get_MaxResponseHeadersLength write set_MaxResponseHeadersLength;
    property ClientCertificateOptions: DNClientCertificateOption read get_ClientCertificateOptions write set_ClientCertificateOptions;
    property ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection read get_ClientCertificates;
    property ServerCertificateCustomValidationCallback: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean> read get_ServerCertificateCustomValidationCallback write set_ServerCertificateCustomValidationCallback;
    property CheckCertificateRevocationList: Boolean read get_CheckCertificateRevocationList write set_CheckCertificateRevocationList;
    property SslProtocols: DDNC.System.Net.Primitives.DNSslProtocols read get_SslProtocols write set_SslProtocols;
    property Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Properties;
  end;

  TDNHttpClientHandler = class(TDNGenericImport<DNHttpClientHandlerClass, DNHttpClientHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNSocketsHttpHandlerClass = interface(DNHttpMessageHandlerClass)
  ['{24D047A6-8EC4-5CB6-8C23-9D878D595C1D}']
  { constructors } 

    {class} function init: DNSocketsHttpHandler;

  end;

  [DNTypeName('System.Net.Http.SocketsHttpHandler')]
  DNSocketsHttpHandler = interface(DNHttpMessageHandler)
  ['{C6C64D51-8076-385D-B814-1ED84F78CCCE}']
  { getters & setters } 

    function get_UseCookies: Boolean;
    procedure set_UseCookies(value: Boolean);
    function get_CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer;
    procedure set_CookieContainer(value: DDNC.System.Net.Primitives.DNCookieContainer);
    function get_AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods;
    procedure set_AutomaticDecompression(value: DDNC.System.Net.Primitives.DNDecompressionMethods);
    function get_UseProxy: Boolean;
    procedure set_UseProxy(value: Boolean);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_DefaultProxyCredentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_AllowAutoRedirect: Boolean;
    procedure set_AllowAutoRedirect(value: Boolean);
    function get_MaxAutomaticRedirections: Int32;
    procedure set_MaxAutomaticRedirections(value: Int32);
    function get_MaxConnectionsPerServer: Int32;
    procedure set_MaxConnectionsPerServer(value: Int32);
    function get_MaxResponseDrainSize: Int32;
    procedure set_MaxResponseDrainSize(value: Int32);
    function get_ResponseDrainTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_ResponseDrainTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_MaxResponseHeadersLength: Int32;
    procedure set_MaxResponseHeadersLength(value: Int32);
    function get_SslOptions: DDNC.System.Net.Security.DNSslClientAuthenticationOptions;
    procedure set_SslOptions(value: DDNC.System.Net.Security.DNSslClientAuthenticationOptions);
    function get_PooledConnectionLifetime: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PooledConnectionLifetime(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_PooledConnectionIdleTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PooledConnectionIdleTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_ConnectTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_ConnectTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_Expect100ContinueTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Expect100ContinueTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject>;

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property UseCookies: Boolean read get_UseCookies write set_UseCookies;
    property CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer read get_CookieContainer write set_CookieContainer;
    property AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods read get_AutomaticDecompression write set_AutomaticDecompression;
    property UseProxy: Boolean read get_UseProxy write set_UseProxy;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials read get_DefaultProxyCredentials write set_DefaultProxyCredentials;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property AllowAutoRedirect: Boolean read get_AllowAutoRedirect write set_AllowAutoRedirect;
    property MaxAutomaticRedirections: Int32 read get_MaxAutomaticRedirections write set_MaxAutomaticRedirections;
    property MaxConnectionsPerServer: Int32 read get_MaxConnectionsPerServer write set_MaxConnectionsPerServer;
    property MaxResponseDrainSize: Int32 read get_MaxResponseDrainSize write set_MaxResponseDrainSize;
    property ResponseDrainTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_ResponseDrainTimeout write set_ResponseDrainTimeout;
    property MaxResponseHeadersLength: Int32 read get_MaxResponseHeadersLength write set_MaxResponseHeadersLength;
    property SslOptions: DDNC.System.Net.Security.DNSslClientAuthenticationOptions read get_SslOptions write set_SslOptions;
    property PooledConnectionLifetime: DDNC.System.Private.CoreLib.DNTimeSpan read get_PooledConnectionLifetime write set_PooledConnectionLifetime;
    property PooledConnectionIdleTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_PooledConnectionIdleTimeout write set_PooledConnectionIdleTimeout;
    property ConnectTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_ConnectTimeout write set_ConnectTimeout;
    property Expect100ContinueTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Expect100ContinueTimeout write set_Expect100ContinueTimeout;
    property Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Properties;
  end;

  TDNSocketsHttpHandler = class(TDNGenericImport<DNSocketsHttpHandlerClass, DNSocketsHttpHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpMessageInvokerClass = interface(DNObjectClass)
  ['{D60EA80F-7DBE-5C6F-AC3B-024D84960778}']
  { constructors } 

    {class} function init(handler: DNHttpMessageHandler): DNHttpMessageInvoker; overload;
    {class} function init(handler: DNHttpMessageHandler; disposeHandler: Boolean): DNHttpMessageInvoker; overload;

  end;

  [DNTypeName('System.Net.Http.HttpMessageInvoker')]
  DNHttpMessageInvoker = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{AD2D3001-3775-3E3D-BECA-7CCD780039E1}']
  { methods } 

    function SendAsync(request: DNHttpRequestMessage; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpMessageInvoker = class(TDNGenericImport<DNHttpMessageInvokerClass, DNHttpMessageInvoker>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpClientClass = interface(DNHttpMessageInvokerClass)
  ['{5310ECF2-943B-5620-AB88-BE088BC0B6D4}']
  { static getter & setter } 

    {class} function get_DefaultProxy: DDNC.System.Net.Primitives.DNIWebProxy;
    {class} procedure set_DefaultProxy(value: DDNC.System.Net.Primitives.DNIWebProxy);

  { constructors } 

    {class} function init: DNHttpClient; overload;
    {class} function init(handler: DNHttpMessageHandler): DNHttpClient; overload;
    {class} function init(handler: DNHttpMessageHandler; disposeHandler: Boolean): DNHttpClient; overload;

  { static propertys } 

    {class} property DefaultProxy: DDNC.System.Net.Primitives.DNIWebProxy read get_DefaultProxy write set_DefaultProxy;
  end;

  [DNTypeName('System.Net.Http.HttpClient')]
  DNHttpClient = interface(DNHttpMessageInvoker)
  ['{693AF350-4E09-3EA2-985A-73432E960BA3}']
  { getters & setters } 

    function get_DefaultRequestHeaders: DNHttpRequestHeaders;
    function get_DefaultRequestVersion: DDNC.System.Private.CoreLib.DNVersion;
    procedure set_DefaultRequestVersion(value: DDNC.System.Private.CoreLib.DNVersion);
    function get_BaseAddress: DDNC.System.Private.Uri.DNUri;
    procedure set_BaseAddress(value: DDNC.System.Private.Uri.DNUri);
    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_MaxResponseContentBufferSize: Int64;
    procedure set_MaxResponseContentBufferSize(value: Int64);

  { methods } 

    function GetStringAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function GetStringAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function GetByteArrayAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function GetByteArrayAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function GetStreamAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function GetStreamAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function GetAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: string; completionOption: DNHttpCompletionOption): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri; completionOption: DNHttpCompletionOption): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: string; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: string; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: string; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: string; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: string; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: string; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: string; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: DDNC.System.Private.Uri.DNUri; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage; completionOption: DNHttpCompletionOption): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    procedure CancelPendingRequests;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DefaultRequestHeaders: DNHttpRequestHeaders read get_DefaultRequestHeaders;
    property DefaultRequestVersion: DDNC.System.Private.CoreLib.DNVersion read get_DefaultRequestVersion write set_DefaultRequestVersion;
    property BaseAddress: DDNC.System.Private.Uri.DNUri read get_BaseAddress write set_BaseAddress;
    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
    property MaxResponseContentBufferSize: Int64 read get_MaxResponseContentBufferSize write set_MaxResponseContentBufferSize;
  end;

  TDNHttpClient = class(TDNGenericImport<DNHttpClientClass, DNHttpClient>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpMethodClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{369CA724-7A51-553A-AC34-BC75C47E24D0}']
  { static getter & setter } 

    {class} function get_Get: DNHttpMethod;
    {class} function get_Put: DNHttpMethod;
    {class} function get_Post: DNHttpMethod;
    {class} function get_Delete: DNHttpMethod;
    {class} function get_Head: DNHttpMethod;
    {class} function get_Options: DNHttpMethod;
    {class} function get_Trace: DNHttpMethod;
    {class} function get_Patch: DNHttpMethod;

  { constructors } 

    {class} function init(method: string): DNHttpMethod;

  { static propertys } 

    {class} property Get: DNHttpMethod read get_Get;
    {class} property Put: DNHttpMethod read get_Put;
    {class} property Post: DNHttpMethod read get_Post;
    {class} property Delete: DNHttpMethod read get_Delete;
    {class} property Head: DNHttpMethod read get_Head;
    {class} property Options: DNHttpMethod read get_Options;
    {class} property Trace: DNHttpMethod read get_Trace;
    {class} property Patch: DNHttpMethod read get_Patch;
  end;

  [DNTypeName('System.Net.Http.HttpMethod')]
  DNHttpMethod = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4274D11C-5E01-33CB-8A6F-22132614ABB3}']
  { getters & setters } 

    function get_Method: string;

  { methods } 

    function Equals(other: DNHttpMethod): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Method: string read get_Method;
  end;

  TDNHttpMethod = class(TDNGenericImport<DNHttpMethodClass, DNHttpMethod>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpRequestMessageClass = interface(DNObjectClass)
  ['{4D015949-C846-5515-B8FE-F56559087867}']
  { constructors } 

    {class} function init: DNHttpRequestMessage; overload;
    {class} function init(method: DNHttpMethod; requestUri: DDNC.System.Private.Uri.DNUri): DNHttpRequestMessage; overload;
    {class} function init(method: DNHttpMethod; requestUri: string): DNHttpRequestMessage; overload;

  end;

  [DNTypeName('System.Net.Http.HttpRequestMessage')]
  DNHttpRequestMessage = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{B7C19843-43B7-362E-A7E1-D73B30188183}']
  { getters & setters } 

    function get_Version: DDNC.System.Private.CoreLib.DNVersion;
    procedure set_Version(value: DDNC.System.Private.CoreLib.DNVersion);
    function get_Content: DNHttpContent;
    procedure set_Content(value: DNHttpContent);
    function get_Method: DNHttpMethod;
    procedure set_Method(value: DNHttpMethod);
    function get_RequestUri: DDNC.System.Private.Uri.DNUri;
    procedure set_RequestUri(value: DDNC.System.Private.Uri.DNUri);
    function get_Headers: DNHttpRequestHeaders;
    function get_Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject>;

  { methods } 

    function ToString: string;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Version: DDNC.System.Private.CoreLib.DNVersion read get_Version write set_Version;
    property Content: DNHttpContent read get_Content write set_Content;
    property Method: DNHttpMethod read get_Method write set_Method;
    property RequestUri: DDNC.System.Private.Uri.DNUri read get_RequestUri write set_RequestUri;
    property Headers: DNHttpRequestHeaders read get_Headers;
    property Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Properties;
  end;

  TDNHttpRequestMessage = class(TDNGenericImport<DNHttpRequestMessageClass, DNHttpRequestMessage>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpResponseMessageClass = interface(DNObjectClass)
  ['{90980DB7-6172-5D2F-8211-A3F00D847436}']
  { constructors } 

    {class} function init: DNHttpResponseMessage; overload;
    {class} function init(statusCode: DDNC.System.Net.Primitives.DNHttpStatusCode): DNHttpResponseMessage; overload;

  end;

  [DNTypeName('System.Net.Http.HttpResponseMessage')]
  DNHttpResponseMessage = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{6A9282DD-64AE-3676-A340-0DDAEDA43065}']
  { getters & setters } 

    function get_Version: DDNC.System.Private.CoreLib.DNVersion;
    procedure set_Version(value: DDNC.System.Private.CoreLib.DNVersion);
    function get_Content: DNHttpContent;
    procedure set_Content(value: DNHttpContent);
    function get_StatusCode: DDNC.System.Net.Primitives.DNHttpStatusCode;
    procedure set_StatusCode(value: DDNC.System.Net.Primitives.DNHttpStatusCode);
    function get_ReasonPhrase: string;
    procedure set_ReasonPhrase(value: string);
    function get_Headers: DNHttpResponseHeaders;
    function get_TrailingHeaders: DNHttpResponseHeaders;
    function get_RequestMessage: DNHttpRequestMessage;
    procedure set_RequestMessage(value: DNHttpRequestMessage);
    function get_IsSuccessStatusCode: Boolean;

  { methods } 

    function EnsureSuccessStatusCode: DNHttpResponseMessage;
    function ToString: string;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Version: DDNC.System.Private.CoreLib.DNVersion read get_Version write set_Version;
    property Content: DNHttpContent read get_Content write set_Content;
    property StatusCode: DDNC.System.Net.Primitives.DNHttpStatusCode read get_StatusCode write set_StatusCode;
    property ReasonPhrase: string read get_ReasonPhrase write set_ReasonPhrase;
    property Headers: DNHttpResponseHeaders read get_Headers;
    property TrailingHeaders: DNHttpResponseHeaders read get_TrailingHeaders;
    property RequestMessage: DNHttpRequestMessage read get_RequestMessage write set_RequestMessage;
    property IsSuccessStatusCode: Boolean read get_IsSuccessStatusCode;
  end;

  TDNHttpResponseMessage = class(TDNGenericImport<DNHttpResponseMessageClass, DNHttpResponseMessage>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.Http, Version=4.2.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
