//----------------------------------------------------------------------------
//  System.IO.FileSystem.Watcher.dll: System.IO.FileSystem.Watcher, Version=4.1.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 3.1.18
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.IO.FileSystem.Watcher
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.IO.FileSystem.Watcher;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.ComponentModel.Primitives;

type

{ enums }

  //-------------namespace: System.IO----------------
  [DNTypeName('System.IO.NotifyFilters')]
  DNNotifyFilters = type Integer;
  DNNotifyFiltersHelper = record helper for DNNotifyFilters
  public const
    FileName = 1;
    DirectoryName = 2;
    Attributes = 4;
    Size = 8;
    LastWrite = 16;
    LastAccess = 32;
    CreationTime = 64;
    Security = 256;
  end;


  //-------------namespace: System.IO----------------
  [DNTypeName('System.IO.WatcherChangeTypes')]
  DNWatcherChangeTypes = type Integer;
  DNWatcherChangeTypesHelper = record helper for DNWatcherChangeTypes
  public const
    Created = 1;
    Deleted = 2;
    Changed = 4;
    Renamed = 8;
    All = 15;
  end;




type


{ declares }

  DNErrorEventArgs = interface; // type: System.IO.ErrorEventArgs, namespace: System.IO
  DNFileSystemEventArgs = interface; // type: System.IO.FileSystemEventArgs, namespace: System.IO
  DNRenamedEventArgs = interface; // type: System.IO.RenamedEventArgs, namespace: System.IO
  DNInternalBufferOverflowException = interface; // type: System.IO.InternalBufferOverflowException, namespace: System.IO
  DNFileSystemWatcher = interface; // type: System.IO.FileSystemWatcher, namespace: System.IO
  DNWaitForChangedResult = interface; // type: System.IO.WaitForChangedResult, namespace: System.IO

{ delegates }

  [DNTypeName('System.IO.ErrorEventHandler')]
  DNErrorEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNErrorEventArgs) of object;

  [DNTypeName('System.IO.FileSystemEventHandler')]
  DNFileSystemEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNFileSystemEventArgs) of object;

  [DNTypeName('System.IO.RenamedEventHandler')]
  DNRenamedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNRenamedEventArgs) of object;




{ objects }

  //-------------namespace: System.IO----------------
  DNErrorEventArgsClass = interface(DDNC.System.Private.CoreLib.DNEventArgsClass)
  ['{0C5FE9EB-02E3-5920-B791-6C86C82E55B8}']
  { constructors } 

    {class} function init(exception: DDNC.System.Private.CoreLib.DNException): DNErrorEventArgs;

  end;

  [DNTypeName('System.IO.ErrorEventArgs')]
  DNErrorEventArgs = interface(DDNC.System.Private.CoreLib.DNEventArgs)
  ['{3F45B22B-A8EF-3701-8D99-7CB76E3E3FE8}']
  { methods } 

    function GetException: DDNC.System.Private.CoreLib.DNException;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNErrorEventArgs = class(TDNGenericImport<DNErrorEventArgsClass, DNErrorEventArgs>) end;

  //-------------namespace: System.IO----------------
  DNFileSystemEventArgsClass = interface(DDNC.System.Private.CoreLib.DNEventArgsClass)
  ['{2B1F245B-74CE-58F1-ACD6-CE390388D868}']
  { constructors } 

    {class} function init(changeType: DNWatcherChangeTypes; directory: string; name: string): DNFileSystemEventArgs;

  end;

  [DNTypeName('System.IO.FileSystemEventArgs')]
  DNFileSystemEventArgs = interface(DDNC.System.Private.CoreLib.DNEventArgs)
  ['{07AF0A60-7B19-3319-A69B-A6ED91A16D96}']
  { getters & setters } 

    function get_ChangeType: DNWatcherChangeTypes;
    function get_FullPath: string;
    function get_Name: string;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ChangeType: DNWatcherChangeTypes read get_ChangeType;
    property FullPath: string read get_FullPath;
    property Name: string read get_Name;
  end;

  TDNFileSystemEventArgs = class(TDNGenericImport<DNFileSystemEventArgsClass, DNFileSystemEventArgs>) end;

  //-------------namespace: System.IO----------------
  DNRenamedEventArgsClass = interface(DNFileSystemEventArgsClass)
  ['{4D79406E-D6B3-5D80-8FBF-0019D533E649}']
  { constructors } 

    {class} function init(changeType: DNWatcherChangeTypes; directory: string; name: string; oldName: string): DNRenamedEventArgs;

  end;

  [DNTypeName('System.IO.RenamedEventArgs')]
  DNRenamedEventArgs = interface(DNFileSystemEventArgs)
  ['{37268F91-A5F1-31D9-AE7B-EB52389D318C}']
  { getters & setters } 

    function get_OldFullPath: string;
    function get_OldName: string;
    function get_ChangeType: DNWatcherChangeTypes;
    function get_FullPath: string;
    function get_Name: string;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property OldFullPath: string read get_OldFullPath;
    property OldName: string read get_OldName;
    property ChangeType: DNWatcherChangeTypes read get_ChangeType;
    property FullPath: string read get_FullPath;
    property Name: string read get_Name;
  end;

  TDNRenamedEventArgs = class(TDNGenericImport<DNRenamedEventArgsClass, DNRenamedEventArgs>) end;

  //-------------namespace: System.IO----------------
  DNInternalBufferOverflowExceptionClass = interface(DDNC.System.Private.CoreLib.DNSystemExceptionClass)
  ['{E467A3F2-F128-50FD-A769-E13F4CBDD7AD}']
  { constructors } 

    {class} function init: DNInternalBufferOverflowException; overload;
    {class} function init(message: string): DNInternalBufferOverflowException; overload;
    {class} function init(message: string; inner: DDNC.System.Private.CoreLib.DNException): DNInternalBufferOverflowException; overload;

  end;

  [DNTypeName('System.IO.InternalBufferOverflowException')]
  DNInternalBufferOverflowException = interface(DDNC.System.Private.CoreLib.DNSystemException)
  ['{1D008C63-FCDC-3FF3-8DA2-EBD0EBB31CC4}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNInternalBufferOverflowException = class(TDNGenericImport<DNInternalBufferOverflowExceptionClass, DNInternalBufferOverflowException>) end;

  //-------------namespace: System.IO----------------
  DNFileSystemWatcherClass = interface(DNObjectClass)
  ['{E69AA1D3-AB34-5977-AAFC-D654729958A9}']
  { constructors } 

    {class} function init: DNFileSystemWatcher; overload;
    {class} function init(path: string): DNFileSystemWatcher; overload;
    {class} function init(path: string; filter: string): DNFileSystemWatcher; overload;

  end;

  [DNTypeName('System.IO.FileSystemWatcher')]
  DNFileSystemWatcher = interface(DNObject)
  ['{F563DB7F-4D1C-3B97-B90B-D6822F2ACEF6}']
  { getters & setters } 

    function get_NotifyFilter: DNNotifyFilters;
    procedure set_NotifyFilter(value: DNNotifyFilters);
    function get_Filters: DDNC.System.Private.CoreLib.DNCollection<string>;
    function get_EnableRaisingEvents: Boolean;
    procedure set_EnableRaisingEvents(value: Boolean);
    function get_Filter: string;
    procedure set_Filter(value: string);
    function get_IncludeSubdirectories: Boolean;
    procedure set_IncludeSubdirectories(value: Boolean);
    function get_InternalBufferSize: Int32;
    procedure set_InternalBufferSize(value: Int32);
    function get_Path: string;
    procedure set_Path(value: string);
    function get_Site: DDNC.System.ComponentModel.Primitives.DNISite;
    procedure set_Site(value: DDNC.System.ComponentModel.Primitives.DNISite);
    function get_SynchronizingObject: DDNC.System.ComponentModel.Primitives.DNISynchronizeInvoke;
    procedure set_SynchronizingObject(value: DDNC.System.ComponentModel.Primitives.DNISynchronizeInvoke);
    function get_Container: DDNC.System.ComponentModel.Primitives.DNIContainer;

  { events } 

    procedure add_Changed(value: DNFileSystemEventHandler);
    procedure remove_Changed(value: DNFileSystemEventHandler);
    procedure add_Created(value: DNFileSystemEventHandler);
    procedure remove_Created(value: DNFileSystemEventHandler);
    procedure add_Deleted(value: DNFileSystemEventHandler);
    procedure remove_Deleted(value: DNFileSystemEventHandler);
    procedure add_Error(value: DNErrorEventHandler);
    procedure remove_Error(value: DNErrorEventHandler);
    procedure add_Renamed(value: DNRenamedEventHandler);
    procedure remove_Renamed(value: DNRenamedEventHandler);
    procedure add_Disposed(value: DDNC.System.Private.CoreLib.DNEventHandler);
    procedure remove_Disposed(value: DDNC.System.Private.CoreLib.DNEventHandler);

  { methods } 

    function WaitForChanged(changeType: DNWatcherChangeTypes): DNWaitForChangedResult; overload;
    function WaitForChanged(changeType: DNWatcherChangeTypes; timeout: Int32): DNWaitForChangedResult; overload;
    procedure BeginInit;
    procedure EndInit;
    procedure Dispose;
    function ToString: string;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property NotifyFilter: DNNotifyFilters read get_NotifyFilter write set_NotifyFilter;
    property Filters: DDNC.System.Private.CoreLib.DNCollection<string> read get_Filters;
    property EnableRaisingEvents: Boolean read get_EnableRaisingEvents write set_EnableRaisingEvents;
    property Filter: string read get_Filter write set_Filter;
    property IncludeSubdirectories: Boolean read get_IncludeSubdirectories write set_IncludeSubdirectories;
    property InternalBufferSize: Int32 read get_InternalBufferSize write set_InternalBufferSize;
    property Path: string read get_Path write set_Path;
    property Site: DDNC.System.ComponentModel.Primitives.DNISite read get_Site write set_Site;
    property SynchronizingObject: DDNC.System.ComponentModel.Primitives.DNISynchronizeInvoke read get_SynchronizingObject write set_SynchronizingObject;
    property Container: DDNC.System.ComponentModel.Primitives.DNIContainer read get_Container;
  end;

  TDNFileSystemWatcher = class(TDNGenericImport<DNFileSystemWatcherClass, DNFileSystemWatcher>) end;

  //-------------namespace: System.IO----------------
  DNWaitForChangedResultClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{3B5961F6-41F0-5E51-94C4-B6D003AFE88E}']
  end;

  [DNTypeName('System.IO.WaitForChangedResult')]
  DNWaitForChangedResult = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{29A97F78-ADBB-3874-910A-C823709ABEB3}']
  { getters & setters } 

    function get_ChangeType: DNWatcherChangeTypes;
    procedure set_ChangeType(value: DNWatcherChangeTypes);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_OldName: string;
    procedure set_OldName(value: string);
    function get_TimedOut: Boolean;
    procedure set_TimedOut(value: Boolean);

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ChangeType: DNWatcherChangeTypes read get_ChangeType write set_ChangeType;
    property Name: string read get_Name write set_Name;
    property OldName: string read get_OldName write set_OldName;
    property TimedOut: Boolean read get_TimedOut write set_TimedOut;
  end;

  TDNWaitForChangedResult = class(TDNGenericImport<DNWaitForChangedResultClass, DNWaitForChangedResult>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.IO.FileSystem.Watcher, Version=4.1.2.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
