//----------------------------------------------------------------------------
//  System.Transactions.Local.dll: System.Transactions.Local, Version=4.0.1.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Transactions.Local
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Transactions.Local;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type

{ enums }

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.DependentCloneOption')]
  DNDependentCloneOption = type Integer;
  DNDependentCloneOptionHelper = record helper for DNDependentCloneOption
  public const
    BlockCommitUntilComplete = 0;
    RollbackIfNotComplete = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.EnlistmentOptions')]
  DNEnlistmentOptions = type Integer;
  DNEnlistmentOptionsHelper = record helper for DNEnlistmentOptions
  public const
    None = 0;
    EnlistDuringPrepareRequired = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.EnterpriseServicesInteropOption')]
  DNEnterpriseServicesInteropOption = type Integer;
  DNEnterpriseServicesInteropOptionHelper = record helper for DNEnterpriseServicesInteropOption
  public const
    None = 0;
    Automatic = 1;
    Full = 2;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IsolationLevel')]
  DNIsolationLevel = type Integer;
  DNIsolationLevelHelper = record helper for DNIsolationLevel
  public const
    Serializable = 0;
    RepeatableRead = 1;
    ReadCommitted = 2;
    ReadUncommitted = 3;
    Snapshot = 4;
    Chaos = 5;
    Unspecified = 6;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionScopeAsyncFlowOption')]
  DNTransactionScopeAsyncFlowOption = type Integer;
  DNTransactionScopeAsyncFlowOptionHelper = record helper for DNTransactionScopeAsyncFlowOption
  public const
    Suppress = 0;
    Enabled = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionScopeOption')]
  DNTransactionScopeOption = type Integer;
  DNTransactionScopeOptionHelper = record helper for DNTransactionScopeOption
  public const
    Required = 0;
    RequiresNew = 1;
    Suppress = 2;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionStatus')]
  DNTransactionStatus = type Integer;
  DNTransactionStatusHelper = record helper for DNTransactionStatus
  public const
    Active = 0;
    Committed = 1;
    Aborted = 2;
    InDoubt = 3;
  end;




type


{ declares }

  DNIDtcTransaction = interface; // type: System.Transactions.IDtcTransaction, namespace: System.Transactions
  DNIEnlistmentNotification = interface; // type: System.Transactions.IEnlistmentNotification, namespace: System.Transactions
  DNISinglePhaseNotification = interface; // type: System.Transactions.ISinglePhaseNotification, namespace: System.Transactions
  DNITransactionPromoter = interface; // type: System.Transactions.ITransactionPromoter, namespace: System.Transactions
  DNIPromotableSinglePhaseNotification = interface; // type: System.Transactions.IPromotableSinglePhaseNotification, namespace: System.Transactions
  DNISimpleTransactionSuperior = interface; // type: System.Transactions.ISimpleTransactionSuperior, namespace: System.Transactions
  DNTransactionEventArgs = interface; // type: System.Transactions.TransactionEventArgs, namespace: System.Transactions
  DNTransactionException = interface; // type: System.Transactions.TransactionException, namespace: System.Transactions
  DNTransactionAbortedException = interface; // type: System.Transactions.TransactionAbortedException, namespace: System.Transactions
  DNTransactionInDoubtException = interface; // type: System.Transactions.TransactionInDoubtException, namespace: System.Transactions
  DNTransactionManagerCommunicationException = interface; // type: System.Transactions.TransactionManagerCommunicationException, namespace: System.Transactions
  DNTransactionPromotionException = interface; // type: System.Transactions.TransactionPromotionException, namespace: System.Transactions
  DNEnlistment = interface; // type: System.Transactions.Enlistment, namespace: System.Transactions
  DNPreparingEnlistment = interface; // type: System.Transactions.PreparingEnlistment, namespace: System.Transactions
  DNSinglePhaseEnlistment = interface; // type: System.Transactions.SinglePhaseEnlistment, namespace: System.Transactions
  DNTransaction = interface; // type: System.Transactions.Transaction, namespace: System.Transactions
  DNCommittableTransaction = interface; // type: System.Transactions.CommittableTransaction, namespace: System.Transactions
  DNDependentTransaction = interface; // type: System.Transactions.DependentTransaction, namespace: System.Transactions
  DNSubordinateTransaction = interface; // type: System.Transactions.SubordinateTransaction, namespace: System.Transactions
  DNTransactionInformation = interface; // type: System.Transactions.TransactionInformation, namespace: System.Transactions
  DNTransactionInterop = interface; // type: System.Transactions.TransactionInterop, namespace: System.Transactions
  DNTransactionManager = interface; // type: System.Transactions.TransactionManager, namespace: System.Transactions
  DNTransactionScope = interface; // type: System.Transactions.TransactionScope, namespace: System.Transactions
  DNTransactionOptions = interface; // type: System.Transactions.TransactionOptions, namespace: System.Transactions

{ delegates }

  [DNTypeName('System.Transactions.HostCurrentTransactionCallback')]
  DNHostCurrentTransactionCallback = function: DNTransaction of object;

  [DNTypeName('System.Transactions.TransactionCompletedEventHandler')]
  DNTransactionCompletedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNTransactionEventArgs) of object;

  [DNTypeName('System.Transactions.TransactionStartedEventHandler')]
  DNTransactionStartedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNTransactionEventArgs) of object;




{ objects }

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IDtcTransaction')]
  DNIDtcTransaction = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0FB15084-AF41-11CE-BD2B-204C4F4F5020}']
  { methods } 

    procedure Commit(retaining: Int32; commitType: Int32; reserved: Int32);
    procedure &Abort(reason: IntPtr; retaining: Int32; async: Int32);
    procedure GetTransactionInfo(transactionInformation: IntPtr);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IEnlistmentNotification')]
  DNIEnlistmentNotification = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{68723FCB-A005-3CD5-AF43-E27703E304F2}']
  { methods } 

    procedure Prepare(preparingEnlistment: DNPreparingEnlistment);
    procedure Commit(enlistment: DNEnlistment);
    procedure Rollback(enlistment: DNEnlistment);
    procedure InDoubt(enlistment: DNEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ISinglePhaseNotification')]
  DNISinglePhaseNotification = interface(DNIEnlistmentNotification)
  ['{2354C464-7457-3AE8-AF68-751AF5A1FFC0}']
  { methods } 

    procedure SinglePhaseCommit(singlePhaseEnlistment: DNSinglePhaseEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ITransactionPromoter')]
  DNITransactionPromoter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2EE24BD6-197C-3BD2-ABB2-03F7113E3B60}']
  { methods } 

    function Promote: TArray<Byte>;

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IPromotableSinglePhaseNotification')]
  DNIPromotableSinglePhaseNotification = interface(DNITransactionPromoter)
  ['{5C25E3AA-572A-331E-88C5-CD69DCEF4C71}']
  { methods } 

    procedure Initialize;
    procedure SinglePhaseCommit(singlePhaseEnlistment: DNSinglePhaseEnlistment);
    procedure Rollback(singlePhaseEnlistment: DNSinglePhaseEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ISimpleTransactionSuperior')]
  DNISimpleTransactionSuperior = interface(DNITransactionPromoter)
  ['{8C30F42C-7396-303C-89E2-3EB683EF53BD}']
  { methods } 

    procedure Rollback;

  end;

  //-------------namespace: System.Transactions----------------
  DNTransactionEventArgsClass = interface(DDNC.System.Private.CoreLib.DNEventArgsClass)
  ['{198E362D-0193-515F-A0F5-8FBA55EFC6A0}']
  { constructors } 

    {class} function init: DNTransactionEventArgs;

  end;

  [DNTypeName('System.Transactions.TransactionEventArgs')]
  DNTransactionEventArgs = interface(DDNC.System.Private.CoreLib.DNEventArgs)
  ['{B097090F-3C9C-3BB7-B410-65973AC16756}']
  { getters & setters } 

    function get_Transaction: DNTransaction;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Transaction: DNTransaction read get_Transaction;
  end;

  TDNTransactionEventArgs = class(TDNGenericImport<DNTransactionEventArgsClass, DNTransactionEventArgs>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionExceptionClass = interface(DDNC.System.Private.CoreLib.DNSystemExceptionClass)
  ['{BED311B2-9D35-558F-8430-027E0A59B472}']
  { constructors } 

    {class} function init: DNTransactionException; overload;
    {class} function init(message: string): DNTransactionException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionException')]
  DNTransactionException = interface(DDNC.System.Private.CoreLib.DNSystemException)
  ['{3B2AF041-298E-3224-AF6A-0564F213DB73}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionException = class(TDNGenericImport<DNTransactionExceptionClass, DNTransactionException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionAbortedExceptionClass = interface(DNTransactionExceptionClass)
  ['{2971ECB8-8F73-5409-9E2E-65CC8528CF7C}']
  { constructors } 

    {class} function init: DNTransactionAbortedException; overload;
    {class} function init(message: string): DNTransactionAbortedException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionAbortedException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionAbortedException')]
  DNTransactionAbortedException = interface(DNTransactionException)
  ['{236C51AC-AF43-30DB-9DA7-7A8A5D15EC5F}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionAbortedException = class(TDNGenericImport<DNTransactionAbortedExceptionClass, DNTransactionAbortedException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInDoubtExceptionClass = interface(DNTransactionExceptionClass)
  ['{7FF4CF1A-809B-5C9E-B5E9-417A936E3862}']
  { constructors } 

    {class} function init: DNTransactionInDoubtException; overload;
    {class} function init(message: string): DNTransactionInDoubtException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionInDoubtException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionInDoubtException')]
  DNTransactionInDoubtException = interface(DNTransactionException)
  ['{184DEEC6-8C96-36DC-8641-445C0ECB70E7}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionInDoubtException = class(TDNGenericImport<DNTransactionInDoubtExceptionClass, DNTransactionInDoubtException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionManagerCommunicationExceptionClass = interface(DNTransactionExceptionClass)
  ['{F44823CC-2CAC-5DAE-8750-B9010BED194B}']
  { constructors } 

    {class} function init: DNTransactionManagerCommunicationException; overload;
    {class} function init(message: string): DNTransactionManagerCommunicationException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionManagerCommunicationException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionManagerCommunicationException')]
  DNTransactionManagerCommunicationException = interface(DNTransactionException)
  ['{769C4E2E-68FF-3640-8F4B-ADCB0232EFF9}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionManagerCommunicationException = class(TDNGenericImport<DNTransactionManagerCommunicationExceptionClass, DNTransactionManagerCommunicationException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionPromotionExceptionClass = interface(DNTransactionExceptionClass)
  ['{10799F64-374D-581C-85D7-A0D79D1C6205}']
  { constructors } 

    {class} function init: DNTransactionPromotionException; overload;
    {class} function init(message: string): DNTransactionPromotionException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionPromotionException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionPromotionException')]
  DNTransactionPromotionException = interface(DNTransactionException)
  ['{2347E52D-E87F-3694-894F-DB8471369449}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNTransactionPromotionException = class(TDNGenericImport<DNTransactionPromotionExceptionClass, DNTransactionPromotionException>) end;

  //-------------namespace: System.Transactions----------------
  DNEnlistmentClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{EF688E87-E0BD-5E0B-AE3D-5DD519170DEE}']
  end;

  [DNTypeName('System.Transactions.Enlistment')]
  DNEnlistment = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{869E866F-FACF-362B-9C2F-6C93D48881D0}']
  { methods } 

    procedure Done;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNEnlistment = class(TDNGenericImport<DNEnlistmentClass, DNEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNPreparingEnlistmentClass = interface(DNEnlistmentClass)
  ['{B5D2B82B-03BB-5F03-9512-D0F5FF2477FB}']
  end;

  [DNTypeName('System.Transactions.PreparingEnlistment')]
  DNPreparingEnlistment = interface(DNEnlistment)
  ['{72463520-C145-3FC5-AC05-DC59E6977BAA}']
  { methods } 

    procedure Prepared;
    procedure ForceRollback; overload;
    procedure ForceRollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function RecoveryInformation: TArray<Byte>;
    procedure Done;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNPreparingEnlistment = class(TDNGenericImport<DNPreparingEnlistmentClass, DNPreparingEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNSinglePhaseEnlistmentClass = interface(DNEnlistmentClass)
  ['{BF8B9FF3-5217-5EEC-8D75-A5006D1A1709}']
  end;

  [DNTypeName('System.Transactions.SinglePhaseEnlistment')]
  DNSinglePhaseEnlistment = interface(DNEnlistment)
  ['{ED5CE935-F483-33D6-830A-758B6610FEE5}']
  { methods } 

    procedure Aborted; overload;
    procedure Aborted(e: DDNC.System.Private.CoreLib.DNException); overload;
    procedure Committed;
    procedure InDoubt; overload;
    procedure InDoubt(e: DDNC.System.Private.CoreLib.DNException); overload;
    procedure Done;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNSinglePhaseEnlistment = class(TDNGenericImport<DNSinglePhaseEnlistmentClass, DNSinglePhaseEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionClass = interface(DNObjectClass)
  ['{C859C1F0-22C7-52E3-93F0-0C3F6F881978}']
  { static getter & setter } 

    {class} function get_Current: DNTransaction;
    {class} procedure set_Current(value: DNTransaction);

  { static propertys } 

    {class} property Current: DNTransaction read get_Current write set_Current;
  end;

  [DNTypeName('System.Transactions.Transaction')]
  DNTransaction = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{8EDAB186-2F04-3613-8B83-DDB186EA0BF9}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNTransaction = class(TDNGenericImport<DNTransactionClass, DNTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNCommittableTransactionClass = interface(DNTransactionClass)
  ['{36E15BAE-C991-508C-8F23-C4D45083D81D}']
  { constructors } 

    {class} function init: DNCommittableTransaction; overload;
    {class} function init(timeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNCommittableTransaction; overload;
    {class} function init(options: DNTransactionOptions): DNCommittableTransaction; overload;

  end;

  [DNTypeName('System.Transactions.CommittableTransaction')]
  DNCommittableTransaction = interface(DNTransaction)
  ['{0C4937D4-E763-34D5-8E11-C41548E7E2B8}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function BeginCommit(asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure Commit;
    procedure EndCommit(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNCommittableTransaction = class(TDNGenericImport<DNCommittableTransactionClass, DNCommittableTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNDependentTransactionClass = interface(DNTransactionClass)
  ['{E1F79F32-C66B-5BB0-99F7-2F1DF92CE8DE}']
  end;

  [DNTypeName('System.Transactions.DependentTransaction')]
  DNDependentTransaction = interface(DNTransaction)
  ['{3516AE9F-18E4-37B0-8335-69E3EE8088A9}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    procedure Complete;
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNDependentTransaction = class(TDNGenericImport<DNDependentTransactionClass, DNDependentTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNSubordinateTransactionClass = interface(DNTransactionClass)
  ['{4FEC3967-2417-5759-AF83-03D1E0660A9E}']
  { constructors } 

    {class} function init(isoLevel: DNIsolationLevel; superior: DNISimpleTransactionSuperior): DNSubordinateTransaction;

  end;

  [DNTypeName('System.Transactions.SubordinateTransaction')]
  DNSubordinateTransaction = interface(DNTransaction)
  ['{A6141133-CC86-3691-A8B1-B6BD53C4A890}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNSubordinateTransaction = class(TDNGenericImport<DNSubordinateTransactionClass, DNSubordinateTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInformationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{46956D54-FEB3-59A5-B13B-7B63F0DD2F92}']
  end;

  [DNTypeName('System.Transactions.TransactionInformation')]
  DNTransactionInformation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{40258F43-E94A-3C23-9312-0C4B99750B8B}']
  { getters & setters } 

    function get_LocalIdentifier: string;
    function get_DistributedIdentifier: DDNC.System.Private.CoreLib.DNGuid;
    function get_CreationTime: DDNC.System.Private.CoreLib.DNDateTime;
    function get_Status: DNTransactionStatus;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property LocalIdentifier: string read get_LocalIdentifier;
    property DistributedIdentifier: DDNC.System.Private.CoreLib.DNGuid read get_DistributedIdentifier;
    property CreationTime: DDNC.System.Private.CoreLib.DNDateTime read get_CreationTime;
    property Status: DNTransactionStatus read get_Status;
  end;

  TDNTransactionInformation = class(TDNGenericImport<DNTransactionInformationClass, DNTransactionInformation>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInteropClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{6EC60632-F1C2-51FD-B241-A685D61B27DC}']
  { static fields getter & setter } 

   function __fakeFieldGet_PromoterTypeDtc: DDNC.System.Private.CoreLib.DNGuid;

  { static fields } 

    {class} property PromoterTypeDtc: DDNC.System.Private.CoreLib.DNGuid read __fakeFieldGet_PromoterTypeDtc;

  { static methods } 

    {class} function GetExportCookie(transaction: DNTransaction; whereabouts: TArray<Byte>): TArray<Byte>;
    {class} function GetTransactionFromExportCookie(cookie: TArray<Byte>): DNTransaction;
    {class} function GetTransmitterPropagationToken(transaction: DNTransaction): TArray<Byte>;
    {class} function GetTransactionFromTransmitterPropagationToken(propagationToken: TArray<Byte>): DNTransaction;
    {class} function GetDtcTransaction(transaction: DNTransaction): DNIDtcTransaction;
    {class} function GetTransactionFromDtcTransaction(transactionNative: DNIDtcTransaction): DNTransaction;
    {class} function GetWhereabouts: TArray<Byte>;

  end;

  [DNTypeName('System.Transactions.TransactionInterop')]
  DNTransactionInterop = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{36D87586-610D-31FE-A630-36B0CCC4F489}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNTransactionInterop = class(TDNGenericImport<DNTransactionInteropClass, DNTransactionInterop>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionManagerClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{F9B7F45B-D680-5066-9F47-C9CF0D612A92}']
  { static getter & setter } 

    {class} function get_HostCurrentCallback: DNHostCurrentTransactionCallback;
    {class} procedure set_HostCurrentCallback(value: DNHostCurrentTransactionCallback);
    {class} function get_DefaultTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    {class} function get_MaximumTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;

  { static methods } 

    {class} function Reenlist(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; recoveryInformation: TArray<Byte>; enlistmentNotification: DNIEnlistmentNotification): DNEnlistment;
    {class} procedure RecoveryComplete(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid);

  { static propertys } 

    {class} property HostCurrentCallback: DNHostCurrentTransactionCallback read get_HostCurrentCallback write set_HostCurrentCallback;
    {class} property DefaultTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_DefaultTimeout;
    {class} property MaximumTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_MaximumTimeout;
  end;

  [DNTypeName('System.Transactions.TransactionManager')]
  DNTransactionManager = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C8F76CC2-54D3-3FF9-8264-2757D8E91626}']
  { events } 

    {class} procedure add_DistributedTransactionStarted(value: DNTransactionStartedEventHandler);
    {class} procedure remove_DistributedTransactionStarted(value: DNTransactionStartedEventHandler);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNTransactionManager = class(TDNGenericImport<DNTransactionManagerClass, DNTransactionManager>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionScopeClass = interface(DNObjectClass)
  ['{EDCC2615-84B5-56B7-AB95-EAC912E65279}']
  { constructors } 

    {class} function init: DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption): DNTransactionScope; overload;
    {class} function init(asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions; interopOption: DNEnterpriseServicesInteropOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; interopOption: DNEnterpriseServicesInteropOption): DNTransactionScope; overload;

  end;

  [DNTypeName('System.Transactions.TransactionScope')]
  DNTransactionScope = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{BB509EBD-EB5E-37D8-8885-973784351710}']
  { methods } 

    procedure Dispose;
    procedure Complete;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNTransactionScope = class(TDNGenericImport<DNTransactionScopeClass, DNTransactionScope>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionOptionsClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{5E99FDCB-8B3D-51CD-8BD8-470921B6C58B}']
  end;

  [DNTypeName('System.Transactions.TransactionOptions')]
  DNTransactionOptions = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{18E4778C-FB19-3477-89BC-E0FA31CAA3F8}']
  { getters & setters } 

    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_IsolationLevel: DNIsolationLevel;
    procedure set_IsolationLevel(value: DNIsolationLevel);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel write set_IsolationLevel;
  end;

  TDNTransactionOptions = class(TDNGenericImport<DNTransactionOptionsClass, DNTransactionOptions>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Transactions.Local, Version=4.0.1.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51');

finalization

end.
