//----------------------------------------------------------------------------
//  System.Threading.dll: System.Threading, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Threading
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Threading;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type


{ declares }

  DNBarrierPostPhaseException = interface; // type: System.Threading.BarrierPostPhaseException, namespace: System.Threading
  DNReaderWriterLock = interface; // type: System.Threading.ReaderWriterLock, namespace: System.Threading
  DNBarrier = interface; // type: System.Threading.Barrier, namespace: System.Threading
  DNCountdownEvent = interface; // type: System.Threading.CountdownEvent, namespace: System.Threading
  DNHostExecutionContext = interface; // type: System.Threading.HostExecutionContext, namespace: System.Threading
  DNHostExecutionContextManager = interface; // type: System.Threading.HostExecutionContextManager, namespace: System.Threading
  DNLockCookie = interface; // type: System.Threading.LockCookie, namespace: System.Threading


{ objects }

  //-------------namespace: System.Threading----------------
  DNBarrierPostPhaseExceptionClass = interface(DDNC.System.Private.CoreLib.DNExceptionClass)
  ['{13602911-2968-532B-8D44-AC5D91CFE7F5}']
  { constructors } 

    {class} function init: DNBarrierPostPhaseException; overload;
    {class} function init(innerException: DDNC.System.Private.CoreLib.DNException): DNBarrierPostPhaseException; overload;
    {class} function init(message: string): DNBarrierPostPhaseException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNBarrierPostPhaseException; overload;

  end;

  [DNTypeName('System.Threading.BarrierPostPhaseException')]
  DNBarrierPostPhaseException = interface(DDNC.System.Private.CoreLib.DNException)
  ['{4D11625D-7FC7-3B56-99A1-78C1A20B6BB6}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNBarrierPostPhaseException = class(TDNGenericImport<DNBarrierPostPhaseExceptionClass, DNBarrierPostPhaseException>) end;

  //-------------namespace: System.Threading----------------
  DNReaderWriterLockClass = interface(DDNC.System.Private.CoreLib.DNCriticalFinalizerObjectClass)
  ['{5DD74A12-19F9-5B9C-A40A-29A6EC4F83C4}']
  { constructors } 

    {class} function init: DNReaderWriterLock;

  end;

  [DNTypeName('System.Threading.ReaderWriterLock')]
  DNReaderWriterLock = interface(DDNC.System.Private.CoreLib.DNCriticalFinalizerObject)
  ['{1092A840-AA34-3C54-95C0-258240A4EE82}']
  { getters & setters } 

    function get_IsReaderLockHeld: Boolean;
    function get_IsWriterLockHeld: Boolean;
    function get_WriterSeqNum: Int32;

  { methods } 

    function AnyWritersSince(seqNum: Int32): Boolean;
    procedure AcquireReaderLock(millisecondsTimeout: Int32); overload;
    procedure AcquireReaderLock(timeout: DDNC.System.Private.CoreLib.DNTimeSpan); overload;
    procedure AcquireWriterLock(millisecondsTimeout: Int32); overload;
    procedure AcquireWriterLock(timeout: DDNC.System.Private.CoreLib.DNTimeSpan); overload;
    procedure ReleaseReaderLock;
    procedure ReleaseWriterLock;
    function UpgradeToWriterLock(millisecondsTimeout: Int32): DNLockCookie; overload;
    function UpgradeToWriterLock(timeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNLockCookie; overload;
    procedure DowngradeFromWriterLock(out lockCookie: DNLockCookie);
    function ReleaseLock: DNLockCookie;
    procedure RestoreLock(out lockCookie: DNLockCookie);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsReaderLockHeld: Boolean read get_IsReaderLockHeld;
    property IsWriterLockHeld: Boolean read get_IsWriterLockHeld;
    property WriterSeqNum: Int32 read get_WriterSeqNum;
  end;

  TDNReaderWriterLock = class(TDNGenericImport<DNReaderWriterLockClass, DNReaderWriterLock>) end;

  //-------------namespace: System.Threading----------------
  DNBarrierClass = interface(DNObjectClass)
  ['{C58FC5C3-CE27-5750-9E97-DE5B30BF3114}']
  { constructors } 

    {class} function init(participantCount: Int32): DNBarrier; overload;
    {class} function init(participantCount: Int32; postPhaseAction: DDNC.System.Private.CoreLib.DNAction<DNBarrier>): DNBarrier; overload;

  end;

  [DNTypeName('System.Threading.Barrier')]
  DNBarrier = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{19B2582F-7998-3388-8D06-8C203CB38550}']
  { getters & setters } 

    function get_ParticipantsRemaining: Int32;
    function get_ParticipantCount: Int32;
    function get_CurrentPhaseNumber: Int64;

  { methods } 

    function AddParticipant: Int64;
    function AddParticipants(participantCount: Int32): Int64;
    procedure RemoveParticipant;
    procedure RemoveParticipants(participantCount: Int32);
    procedure SignalAndWait; overload;
    procedure SignalAndWait(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken); overload;
    function SignalAndWait(timeout: DDNC.System.Private.CoreLib.DNTimeSpan): Boolean; overload;
    function SignalAndWait(timeout: DDNC.System.Private.CoreLib.DNTimeSpan; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): Boolean; overload;
    function SignalAndWait(millisecondsTimeout: Int32): Boolean; overload;
    function SignalAndWait(millisecondsTimeout: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): Boolean; overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ParticipantsRemaining: Int32 read get_ParticipantsRemaining;
    property ParticipantCount: Int32 read get_ParticipantCount;
    property CurrentPhaseNumber: Int64 read get_CurrentPhaseNumber;
  end;

  TDNBarrier = class(TDNGenericImport<DNBarrierClass, DNBarrier>) end;

  //-------------namespace: System.Threading----------------
  DNCountdownEventClass = interface(DNObjectClass)
  ['{D525C9F3-6685-526D-9C18-B0A86B29ACF8}']
  { constructors } 

    {class} function init(initialCount: Int32): DNCountdownEvent;

  end;

  [DNTypeName('System.Threading.CountdownEvent')]
  DNCountdownEvent = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{8210C06C-033C-369A-BD1F-957CA438C9EA}']
  { getters & setters } 

    function get_CurrentCount: Int32;
    function get_InitialCount: Int32;
    function get_IsSet: Boolean;
    function get_WaitHandle: DDNC.System.Private.CoreLib.DNWaitHandle;

  { methods } 

    procedure Dispose;
    function Signal: Boolean; overload;
    function Signal(signalCount: Int32): Boolean; overload;
    procedure AddCount; overload;
    function TryAddCount: Boolean; overload;
    procedure AddCount(signalCount: Int32); overload;
    function TryAddCount(signalCount: Int32): Boolean; overload;
    procedure Reset; overload;
    procedure Reset(count: Int32); overload;
    procedure Wait; overload;
    procedure Wait(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken); overload;
    function Wait(timeout: DDNC.System.Private.CoreLib.DNTimeSpan): Boolean; overload;
    function Wait(timeout: DDNC.System.Private.CoreLib.DNTimeSpan; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): Boolean; overload;
    function Wait(millisecondsTimeout: Int32): Boolean; overload;
    function Wait(millisecondsTimeout: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): Boolean; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CurrentCount: Int32 read get_CurrentCount;
    property InitialCount: Int32 read get_InitialCount;
    property IsSet: Boolean read get_IsSet;
    property WaitHandle: DDNC.System.Private.CoreLib.DNWaitHandle read get_WaitHandle;
  end;

  TDNCountdownEvent = class(TDNGenericImport<DNCountdownEventClass, DNCountdownEvent>) end;

  //-------------namespace: System.Threading----------------
  DNHostExecutionContextClass = interface(DNObjectClass)
  ['{929A4306-1257-5CCD-87DF-C8A77E37D79D}']
  { constructors } 

    {class} function init: DNHostExecutionContext; overload;
    {class} function init(state: DDNC.System.Private.CoreLib.DNObject): DNHostExecutionContext; overload;

  end;

  [DNTypeName('System.Threading.HostExecutionContext')]
  DNHostExecutionContext = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{1E94EAD4-379E-3618-8CE9-4DF8C9A90DA5}']
  { methods } 

    function CreateCopy: DNHostExecutionContext;
    procedure Dispose; overload;
    procedure Dispose(disposing: Boolean); overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNHostExecutionContext = class(TDNGenericImport<DNHostExecutionContextClass, DNHostExecutionContext>) end;

  //-------------namespace: System.Threading----------------
  DNHostExecutionContextManagerClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{74DFBB28-0678-5CA4-8A82-2504CE047186}']
  { constructors } 

    {class} function init: DNHostExecutionContextManager;

  end;

  [DNTypeName('System.Threading.HostExecutionContextManager')]
  DNHostExecutionContextManager = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F7AF16F2-F77B-3478-8807-4EFC30C6AFCD}']
  { methods } 

    function Capture: DNHostExecutionContext;
    function SetHostExecutionContext(hostExecutionContext: DNHostExecutionContext): DDNC.System.Private.CoreLib.DNObject;
    procedure Revert(previousState: DDNC.System.Private.CoreLib.DNObject);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNHostExecutionContextManager = class(TDNGenericImport<DNHostExecutionContextManagerClass, DNHostExecutionContextManager>) end;

  //-------------namespace: System.Threading----------------
  DNLockCookieClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{DBC7F37E-0D13-5472-AABF-0353F830323D}']
  end;

  [DNTypeName('System.Threading.LockCookie')]
  DNLockCookie = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{5BDBE611-9F90-37B1-A582-22DF52C345BE}']
  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(obj: DNLockCookie): Boolean; overload;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNLockCookie = class(TDNGenericImport<DNLockCookieClass, DNLockCookie>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Threading, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
