//----------------------------------------------------------------------------
//  System.Threading.Tasks.Dataflow.dll: System.Threading.Tasks.Dataflow, Version=4.6.3.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Threading.Tasks.Dataflow
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Threading.Tasks.Dataflow;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type

{ enums }

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  [DNTypeName('System.Threading.Tasks.Dataflow.DataflowMessageStatus')]
  DNDataflowMessageStatus = type Integer;
  DNDataflowMessageStatusHelper = record helper for DNDataflowMessageStatus
  public const
    Accepted = 0;
    Declined = 1;
    Postponed = 2;
    NotAvailable = 3;
    DecliningPermanently = 4;
  end;




type


{ declares }

  DNIDataflowBlock = interface; // type: System.Threading.Tasks.Dataflow.IDataflowBlock, namespace: System.Threading.Tasks.Dataflow
  DNISourceBlock<TOutput> = interface; // type: System.Threading.Tasks.Dataflow.ISourceBlock`1, namespace: System.Threading.Tasks.Dataflow
  DNIReceivableSourceBlock<TOutput> = interface; // type: System.Threading.Tasks.Dataflow.IReceivableSourceBlock`1, namespace: System.Threading.Tasks.Dataflow
  DNITargetBlock<TInput> = interface; // type: System.Threading.Tasks.Dataflow.ITargetBlock`1, namespace: System.Threading.Tasks.Dataflow
  DNIPropagatorBlock<TInput, TOutput> = interface; // type: System.Threading.Tasks.Dataflow.IPropagatorBlock`2, namespace: System.Threading.Tasks.Dataflow
  DNActionBlock<TInput> = interface; // type: System.Threading.Tasks.Dataflow.ActionBlock`1, namespace: System.Threading.Tasks.Dataflow
  DNBatchBlock<T> = interface; // type: System.Threading.Tasks.Dataflow.BatchBlock`1, namespace: System.Threading.Tasks.Dataflow
  DNBatchedJoinBlock<T1, T2> = interface; // type: System.Threading.Tasks.Dataflow.BatchedJoinBlock`2, namespace: System.Threading.Tasks.Dataflow
  DNBatchedJoinBlock<T1, T2, T3> = interface; // type: System.Threading.Tasks.Dataflow.BatchedJoinBlock`3, namespace: System.Threading.Tasks.Dataflow
  DNBroadcastBlock<T> = interface; // type: System.Threading.Tasks.Dataflow.BroadcastBlock`1, namespace: System.Threading.Tasks.Dataflow
  DNBufferBlock<T> = interface; // type: System.Threading.Tasks.Dataflow.BufferBlock`1, namespace: System.Threading.Tasks.Dataflow
  DNDataflowBlock = interface; // type: System.Threading.Tasks.Dataflow.DataflowBlock, namespace: System.Threading.Tasks.Dataflow
  DNDataflowBlockOptions = interface; // type: System.Threading.Tasks.Dataflow.DataflowBlockOptions, namespace: System.Threading.Tasks.Dataflow
  DNExecutionDataflowBlockOptions = interface; // type: System.Threading.Tasks.Dataflow.ExecutionDataflowBlockOptions, namespace: System.Threading.Tasks.Dataflow
  DNGroupingDataflowBlockOptions = interface; // type: System.Threading.Tasks.Dataflow.GroupingDataflowBlockOptions, namespace: System.Threading.Tasks.Dataflow
  DNDataflowLinkOptions = interface; // type: System.Threading.Tasks.Dataflow.DataflowLinkOptions, namespace: System.Threading.Tasks.Dataflow
  DNJoinBlock<T1, T2> = interface; // type: System.Threading.Tasks.Dataflow.JoinBlock`2, namespace: System.Threading.Tasks.Dataflow
  DNJoinBlock<T1, T2, T3> = interface; // type: System.Threading.Tasks.Dataflow.JoinBlock`3, namespace: System.Threading.Tasks.Dataflow
  DNTransformBlock<TInput, TOutput> = interface; // type: System.Threading.Tasks.Dataflow.TransformBlock`2, namespace: System.Threading.Tasks.Dataflow
  DNTransformManyBlock<TInput, TOutput> = interface; // type: System.Threading.Tasks.Dataflow.TransformManyBlock`2, namespace: System.Threading.Tasks.Dataflow
  DNWriteOnceBlock<T> = interface; // type: System.Threading.Tasks.Dataflow.WriteOnceBlock`1, namespace: System.Threading.Tasks.Dataflow
  DNDataflowMessageHeader = interface; // type: System.Threading.Tasks.Dataflow.DataflowMessageHeader, namespace: System.Threading.Tasks.Dataflow


{ objects }

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  [DNTypeName('System.Threading.Tasks.Dataflow.IDataflowBlock')]
  DNIDataflowBlock = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E1BD6CA2-CA92-3066-ABAF-1A792727FC4A}']
  { getters & setters } 

    function get_Completion: DDNC.System.Private.CoreLib.DNTask;

  { methods } 

    procedure Complete;
    procedure Fault(exception: DDNC.System.Private.CoreLib.DNException);

  { propertys } 

    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
  end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  [DNTypeName('System.Threading.Tasks.Dataflow.ISourceBlock`1')]
  DNISourceBlock<TOutput> = interface(DNIDataflowBlock)
  ['{E986232A-4388-39DF-AC79-96B754E76439}']
  { methods } 

    function LinkTo(target: DNITargetBlock<TOutput>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function ConsumeMessage(messageHeader: DNDataflowMessageHeader; target: DNITargetBlock<TOutput>; out messageConsumed: Boolean): TOutput;
    function ReserveMessage(messageHeader: DNDataflowMessageHeader; target: DNITargetBlock<TOutput>): Boolean;
    procedure ReleaseReservation(messageHeader: DNDataflowMessageHeader; target: DNITargetBlock<TOutput>);

  end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  [DNTypeName('System.Threading.Tasks.Dataflow.IReceivableSourceBlock`1')]
  DNIReceivableSourceBlock<TOutput> = interface(DNISourceBlock<TOutput>)
  ['{0EA62736-976E-31E6-9472-159ADF33C413}']
  { methods } 

    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<TOutput>; out item: TOutput): Boolean;
    function TryReceiveAll(out items: DDNC.System.Private.CoreLib.DNIList<TOutput>): Boolean;

  end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  [DNTypeName('System.Threading.Tasks.Dataflow.ITargetBlock`1')]
  DNITargetBlock<TInput> = interface(DNIDataflowBlock)
  ['{E4E18FDC-AEF4-309D-A150-4B9E171DCF79}']
  { methods } 

    function OfferMessage(messageHeader: DNDataflowMessageHeader; messageValue: TInput; source: DNISourceBlock<TInput>; consumeToAccept: Boolean): DNDataflowMessageStatus;

  end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  [DNTypeName('System.Threading.Tasks.Dataflow.IPropagatorBlock`2')]
  DNIPropagatorBlock<TInput, TOutput> = interface(DNITargetBlock<TInput>)
  ['{78EBD1AF-0468-358A-B2E7-FD79469B946B}']
  end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNActionBlockClass<TInput> = interface(DNObjectClass)
  ['{8A99B3AA-E036-566B-938D-1D2A596A9791}']
  { constructors } 

    {class} function init(action: DDNC.System.Private.CoreLib.DNAction<TInput>): DNActionBlock<TInput>; overload;
    {class} function init(action: DDNC.System.Private.CoreLib.DNAction<TInput>; dataflowBlockOptions: DNExecutionDataflowBlockOptions): DNActionBlock<TInput>; overload;
    {class} function init(action: DDNC.System.Private.CoreLib.DNFunc<TInput, DDNC.System.Private.CoreLib.DNTask>): DNActionBlock<TInput>; overload;
    {class} function init(action: DDNC.System.Private.CoreLib.DNFunc<TInput, DDNC.System.Private.CoreLib.DNTask>; dataflowBlockOptions: DNExecutionDataflowBlockOptions): DNActionBlock<TInput>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.ActionBlock`1')]
  DNActionBlock<TInput> = interface(DNITargetBlock<TInput>)
  ['{ED822ADF-C47F-3D6E-8C98-1614BF138BDD}']
  { getters & setters } 

    function get_Completion: DDNC.System.Private.CoreLib.DNTask;
    function get_InputCount: Int32;

  { methods } 

    procedure Complete;
    function Post(item: TInput): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
    property InputCount: Int32 read get_InputCount;
  end;

  TDNActionBlock<TInput> = class(TDNGenericImport<DNActionBlockClass<TInput>, DNActionBlock<TInput>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNBatchBlockClass<T> = interface(DNObjectClass)
  ['{C5C4514F-099D-57E1-A377-D02AFB07A600}']
  { constructors } 

    {class} function init(batchSize: Int32): DNBatchBlock<T>; overload;
    {class} function init(batchSize: Int32; dataflowBlockOptions: DNGroupingDataflowBlockOptions): DNBatchBlock<T>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.BatchBlock`1')]
  DNBatchBlock<T> = interface(DNIPropagatorBlock<T, TArray<T>>)
  ['{B67ADBA1-3ACC-3B49-99B7-D849AF1B9EBB}']
  { getters & setters } 

    function get_OutputCount: Int32;
    function get_Completion: DDNC.System.Private.CoreLib.DNTask;
    function get_BatchSize: Int32;

  { methods } 

    procedure Complete;
    procedure TriggerBatch;
    function LinkTo(target: DNITargetBlock<TArray<T>>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<TArray<T>>; out item: TArray<T>): Boolean;
    function TryReceiveAll(out items: DDNC.System.Private.CoreLib.DNIList<TArray<T>>): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property OutputCount: Int32 read get_OutputCount;
    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
    property BatchSize: Int32 read get_BatchSize;
  end;

  TDNBatchBlock<T> = class(TDNGenericImport<DNBatchBlockClass<T>, DNBatchBlock<T>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNBatchedJoinBlockClass<T1, T2> = interface(DNObjectClass)
  ['{683A633A-EF0D-5D4F-8768-31C68239E1D4}']
  { constructors } 

    {class} function init(batchSize: Int32): DNBatchedJoinBlock<T1, T2>; overload;
    {class} function init(batchSize: Int32; dataflowBlockOptions: DNGroupingDataflowBlockOptions): DNBatchedJoinBlock<T1, T2>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.BatchedJoinBlock`2')]
  DNBatchedJoinBlock<T1, T2> = interface(DNIReceivableSourceBlock<DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>>>)
  ['{1952C798-7C4C-37A9-A40B-31E572C7DD9C}']
  { getters & setters } 

    function get_BatchSize: Int32;
    function get_Target1: DNITargetBlock<T1>;
    function get_Target2: DNITargetBlock<T2>;
    function get_OutputCount: Int32;
    function get_Completion: DDNC.System.Private.CoreLib.DNTask;

  { methods } 

    function LinkTo(target: DNITargetBlock<DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>>>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>>>; out item: DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>>): Boolean;
    function TryReceiveAll(out items: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>>>): Boolean;
    procedure Complete;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property BatchSize: Int32 read get_BatchSize;
    property Target1: DNITargetBlock<T1> read get_Target1;
    property Target2: DNITargetBlock<T2> read get_Target2;
    property OutputCount: Int32 read get_OutputCount;
    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
  end;

  TDNBatchedJoinBlock<T1, T2> = class(TDNGenericImport<DNBatchedJoinBlockClass<T1, T2>, DNBatchedJoinBlock<T1, T2>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNBatchedJoinBlockClass<T1, T2, T3> = interface(DNObjectClass)
  ['{587B49EC-1AAF-5AE2-B598-9192200E8F6C}']
  { constructors } 

    {class} function init(batchSize: Int32): DNBatchedJoinBlock<T1, T2, T3>; overload;
    {class} function init(batchSize: Int32; dataflowBlockOptions: DNGroupingDataflowBlockOptions): DNBatchedJoinBlock<T1, T2, T3>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.BatchedJoinBlock`3')]
  DNBatchedJoinBlock<T1, T2, T3> = interface(DNIReceivableSourceBlock<DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>, DDNC.System.Private.CoreLib.DNIList<T3>>>)
  ['{4737946E-64C7-3D22-854D-53D2289B61A6}']
  { getters & setters } 

    function get_BatchSize: Int32;
    function get_Target1: DNITargetBlock<T1>;
    function get_Target2: DNITargetBlock<T2>;
    function get_Target3: DNITargetBlock<T3>;
    function get_OutputCount: Int32;
    function get_Completion: DDNC.System.Private.CoreLib.DNTask;

  { methods } 

    function LinkTo(target: DNITargetBlock<DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>, DDNC.System.Private.CoreLib.DNIList<T3>>>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>, DDNC.System.Private.CoreLib.DNIList<T3>>>; out item: DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>, DDNC.System.Private.CoreLib.DNIList<T3>>): Boolean;
    function TryReceiveAll(out items: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNTuple<DDNC.System.Private.CoreLib.DNIList<T1>, DDNC.System.Private.CoreLib.DNIList<T2>, DDNC.System.Private.CoreLib.DNIList<T3>>>): Boolean;
    procedure Complete;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property BatchSize: Int32 read get_BatchSize;
    property Target1: DNITargetBlock<T1> read get_Target1;
    property Target2: DNITargetBlock<T2> read get_Target2;
    property Target3: DNITargetBlock<T3> read get_Target3;
    property OutputCount: Int32 read get_OutputCount;
    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
  end;

  TDNBatchedJoinBlock<T1, T2, T3> = class(TDNGenericImport<DNBatchedJoinBlockClass<T1, T2, T3>, DNBatchedJoinBlock<T1, T2, T3>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNBroadcastBlockClass<T> = interface(DNObjectClass)
  ['{EA72EA4D-B7B6-58DE-A689-A8C3C1E9194B}']
  { constructors } 

    {class} function init(cloningFunction: DDNC.System.Private.CoreLib.DNFunc<T, T>): DNBroadcastBlock<T>; overload;
    {class} function init(cloningFunction: DDNC.System.Private.CoreLib.DNFunc<T, T>; dataflowBlockOptions: DNDataflowBlockOptions): DNBroadcastBlock<T>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.BroadcastBlock`1')]
  DNBroadcastBlock<T> = interface(DNIPropagatorBlock<T, T>)
  ['{4A6F4CB5-2072-3F5D-8A47-53162F0C2F20}']
  { getters & setters } 

    function get_Completion: DDNC.System.Private.CoreLib.DNTask;

  { methods } 

    procedure Complete;
    function LinkTo(target: DNITargetBlock<T>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<T>; out item: T): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
  end;

  TDNBroadcastBlock<T> = class(TDNGenericImport<DNBroadcastBlockClass<T>, DNBroadcastBlock<T>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNBufferBlockClass<T> = interface(DNObjectClass)
  ['{E791AEE7-ACAC-54FB-B20D-7E0EAB93848B}']
  { constructors } 

    {class} function init: DNBufferBlock<T>; overload;
    {class} function init(dataflowBlockOptions: DNDataflowBlockOptions): DNBufferBlock<T>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.BufferBlock`1')]
  DNBufferBlock<T> = interface(DNIPropagatorBlock<T, T>)
  ['{A7F31856-D43D-3B43-AB54-60634C20B6C4}']
  { getters & setters } 

    function get_Count: Int32;
    function get_Completion: DDNC.System.Private.CoreLib.DNTask;

  { methods } 

    procedure Complete;
    function LinkTo(target: DNITargetBlock<T>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<T>; out item: T): Boolean;
    function TryReceiveAll(out items: DDNC.System.Private.CoreLib.DNIList<T>): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Count: Int32 read get_Count;
    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
  end;

  TDNBufferBlock<T> = class(TDNGenericImport<DNBufferBlockClass<T>, DNBufferBlock<T>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNDataflowBlockClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{4E88BFE3-F3E5-503E-8462-7098B5D0F0CB}']
  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.DataflowBlock')]
  DNDataflowBlock = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F0BE086B-A11F-3133-8D1E-9F237D5A7839}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNDataflowBlock = class(TDNGenericImport<DNDataflowBlockClass, DNDataflowBlock>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNDataflowBlockOptionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{76FCA720-1872-55CE-A0BA-83137C5C87E8}']
  { constructors } 

    {class} function init: DNDataflowBlockOptions;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.DataflowBlockOptions')]
  DNDataflowBlockOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{BE98B5E2-C045-3ADA-BFDE-4A2C8BC52470}']
  { getters & setters } 

    function get_TaskScheduler: DDNC.System.Private.CoreLib.DNTaskScheduler;
    procedure set_TaskScheduler(value: DDNC.System.Private.CoreLib.DNTaskScheduler);
    function get_CancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken;
    procedure set_CancellationToken(value: DDNC.System.Private.CoreLib.DNCancellationToken);
    function get_MaxMessagesPerTask: Int32;
    procedure set_MaxMessagesPerTask(value: Int32);
    function get_BoundedCapacity: Int32;
    procedure set_BoundedCapacity(value: Int32);
    function get_NameFormat: string;
    procedure set_NameFormat(value: string);
    function get_EnsureOrdered: Boolean;
    procedure set_EnsureOrdered(value: Boolean);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property TaskScheduler: DDNC.System.Private.CoreLib.DNTaskScheduler read get_TaskScheduler write set_TaskScheduler;
    property CancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken read get_CancellationToken write set_CancellationToken;
    property MaxMessagesPerTask: Int32 read get_MaxMessagesPerTask write set_MaxMessagesPerTask;
    property BoundedCapacity: Int32 read get_BoundedCapacity write set_BoundedCapacity;
    property NameFormat: string read get_NameFormat write set_NameFormat;
    property EnsureOrdered: Boolean read get_EnsureOrdered write set_EnsureOrdered;
  end;

  TDNDataflowBlockOptions = class(TDNGenericImport<DNDataflowBlockOptionsClass, DNDataflowBlockOptions>)
  public const
   Unbounded = -1;
  end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNExecutionDataflowBlockOptionsClass = interface(DNDataflowBlockOptionsClass)
  ['{9F732B61-A0CA-586D-968B-6FD31F60B530}']
  { constructors } 

    {class} function init: DNExecutionDataflowBlockOptions;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.ExecutionDataflowBlockOptions')]
  DNExecutionDataflowBlockOptions = interface(DNDataflowBlockOptions)
  ['{6647A58A-1C80-3A02-A821-8155D5C29FCF}']
  { getters & setters } 

    function get_MaxDegreeOfParallelism: Int32;
    procedure set_MaxDegreeOfParallelism(value: Int32);
    function get_SingleProducerConstrained: Boolean;
    procedure set_SingleProducerConstrained(value: Boolean);
    function get_TaskScheduler: DDNC.System.Private.CoreLib.DNTaskScheduler;
    procedure set_TaskScheduler(value: DDNC.System.Private.CoreLib.DNTaskScheduler);
    function get_CancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken;
    procedure set_CancellationToken(value: DDNC.System.Private.CoreLib.DNCancellationToken);
    function get_MaxMessagesPerTask: Int32;
    procedure set_MaxMessagesPerTask(value: Int32);
    function get_BoundedCapacity: Int32;
    procedure set_BoundedCapacity(value: Int32);
    function get_NameFormat: string;
    procedure set_NameFormat(value: string);
    function get_EnsureOrdered: Boolean;
    procedure set_EnsureOrdered(value: Boolean);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property MaxDegreeOfParallelism: Int32 read get_MaxDegreeOfParallelism write set_MaxDegreeOfParallelism;
    property SingleProducerConstrained: Boolean read get_SingleProducerConstrained write set_SingleProducerConstrained;
    property TaskScheduler: DDNC.System.Private.CoreLib.DNTaskScheduler read get_TaskScheduler write set_TaskScheduler;
    property CancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken read get_CancellationToken write set_CancellationToken;
    property MaxMessagesPerTask: Int32 read get_MaxMessagesPerTask write set_MaxMessagesPerTask;
    property BoundedCapacity: Int32 read get_BoundedCapacity write set_BoundedCapacity;
    property NameFormat: string read get_NameFormat write set_NameFormat;
    property EnsureOrdered: Boolean read get_EnsureOrdered write set_EnsureOrdered;
  end;

  TDNExecutionDataflowBlockOptions = class(TDNGenericImport<DNExecutionDataflowBlockOptionsClass, DNExecutionDataflowBlockOptions>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNGroupingDataflowBlockOptionsClass = interface(DNDataflowBlockOptionsClass)
  ['{883C8FD2-CDBB-5661-A4CE-095A2A9873CA}']
  { constructors } 

    {class} function init: DNGroupingDataflowBlockOptions;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.GroupingDataflowBlockOptions')]
  DNGroupingDataflowBlockOptions = interface(DNDataflowBlockOptions)
  ['{DA9E9395-16B8-3DDE-A2D8-6628680B344C}']
  { getters & setters } 

    function get_Greedy: Boolean;
    procedure set_Greedy(value: Boolean);
    function get_MaxNumberOfGroups: Int64;
    procedure set_MaxNumberOfGroups(value: Int64);
    function get_TaskScheduler: DDNC.System.Private.CoreLib.DNTaskScheduler;
    procedure set_TaskScheduler(value: DDNC.System.Private.CoreLib.DNTaskScheduler);
    function get_CancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken;
    procedure set_CancellationToken(value: DDNC.System.Private.CoreLib.DNCancellationToken);
    function get_MaxMessagesPerTask: Int32;
    procedure set_MaxMessagesPerTask(value: Int32);
    function get_BoundedCapacity: Int32;
    procedure set_BoundedCapacity(value: Int32);
    function get_NameFormat: string;
    procedure set_NameFormat(value: string);
    function get_EnsureOrdered: Boolean;
    procedure set_EnsureOrdered(value: Boolean);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Greedy: Boolean read get_Greedy write set_Greedy;
    property MaxNumberOfGroups: Int64 read get_MaxNumberOfGroups write set_MaxNumberOfGroups;
    property TaskScheduler: DDNC.System.Private.CoreLib.DNTaskScheduler read get_TaskScheduler write set_TaskScheduler;
    property CancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken read get_CancellationToken write set_CancellationToken;
    property MaxMessagesPerTask: Int32 read get_MaxMessagesPerTask write set_MaxMessagesPerTask;
    property BoundedCapacity: Int32 read get_BoundedCapacity write set_BoundedCapacity;
    property NameFormat: string read get_NameFormat write set_NameFormat;
    property EnsureOrdered: Boolean read get_EnsureOrdered write set_EnsureOrdered;
  end;

  TDNGroupingDataflowBlockOptions = class(TDNGenericImport<DNGroupingDataflowBlockOptionsClass, DNGroupingDataflowBlockOptions>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNDataflowLinkOptionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{ACA63157-96EF-559D-8D60-EB10BE6C31FB}']
  { constructors } 

    {class} function init: DNDataflowLinkOptions;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.DataflowLinkOptions')]
  DNDataflowLinkOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{75D9477A-120C-3917-9884-DA590DDC61F0}']
  { getters & setters } 

    function get_PropagateCompletion: Boolean;
    procedure set_PropagateCompletion(value: Boolean);
    function get_MaxMessages: Int32;
    procedure set_MaxMessages(value: Int32);
    function get_Append: Boolean;
    procedure set_Append(value: Boolean);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property PropagateCompletion: Boolean read get_PropagateCompletion write set_PropagateCompletion;
    property MaxMessages: Int32 read get_MaxMessages write set_MaxMessages;
    property Append: Boolean read get_Append write set_Append;
  end;

  TDNDataflowLinkOptions = class(TDNGenericImport<DNDataflowLinkOptionsClass, DNDataflowLinkOptions>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNJoinBlockClass<T1, T2> = interface(DNObjectClass)
  ['{A7B5909A-FCD3-5A69-8A91-8932300BC4CD}']
  { constructors } 

    {class} function init: DNJoinBlock<T1, T2>; overload;
    {class} function init(dataflowBlockOptions: DNGroupingDataflowBlockOptions): DNJoinBlock<T1, T2>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.JoinBlock`2')]
  DNJoinBlock<T1, T2> = interface(DNIReceivableSourceBlock<DDNC.System.Private.CoreLib.DNTuple<T1, T2>>)
  ['{71533A88-7C1D-3370-8612-70D24C5B98F9}']
  { getters & setters } 

    function get_OutputCount: Int32;
    function get_Completion: DDNC.System.Private.CoreLib.DNTask;
    function get_Target1: DNITargetBlock<T1>;
    function get_Target2: DNITargetBlock<T2>;

  { methods } 

    function LinkTo(target: DNITargetBlock<DDNC.System.Private.CoreLib.DNTuple<T1, T2>>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<DDNC.System.Private.CoreLib.DNTuple<T1, T2>>; out item: DDNC.System.Private.CoreLib.DNTuple<T1, T2>): Boolean;
    function TryReceiveAll(out items: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNTuple<T1, T2>>): Boolean;
    procedure Complete;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property OutputCount: Int32 read get_OutputCount;
    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
    property Target1: DNITargetBlock<T1> read get_Target1;
    property Target2: DNITargetBlock<T2> read get_Target2;
  end;

  TDNJoinBlock<T1, T2> = class(TDNGenericImport<DNJoinBlockClass<T1, T2>, DNJoinBlock<T1, T2>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNJoinBlockClass<T1, T2, T3> = interface(DNObjectClass)
  ['{43289197-4321-548D-88B8-D94BC89C2841}']
  { constructors } 

    {class} function init: DNJoinBlock<T1, T2, T3>; overload;
    {class} function init(dataflowBlockOptions: DNGroupingDataflowBlockOptions): DNJoinBlock<T1, T2, T3>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.JoinBlock`3')]
  DNJoinBlock<T1, T2, T3> = interface(DNIReceivableSourceBlock<DDNC.System.Private.CoreLib.DNTuple<T1, T2, T3>>)
  ['{5821B9FF-E9DF-3FF0-8C11-A3F957F0D31B}']
  { getters & setters } 

    function get_OutputCount: Int32;
    function get_Completion: DDNC.System.Private.CoreLib.DNTask;
    function get_Target1: DNITargetBlock<T1>;
    function get_Target2: DNITargetBlock<T2>;
    function get_Target3: DNITargetBlock<T3>;

  { methods } 

    function LinkTo(target: DNITargetBlock<DDNC.System.Private.CoreLib.DNTuple<T1, T2, T3>>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<DDNC.System.Private.CoreLib.DNTuple<T1, T2, T3>>; out item: DDNC.System.Private.CoreLib.DNTuple<T1, T2, T3>): Boolean;
    function TryReceiveAll(out items: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNTuple<T1, T2, T3>>): Boolean;
    procedure Complete;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property OutputCount: Int32 read get_OutputCount;
    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
    property Target1: DNITargetBlock<T1> read get_Target1;
    property Target2: DNITargetBlock<T2> read get_Target2;
    property Target3: DNITargetBlock<T3> read get_Target3;
  end;

  TDNJoinBlock<T1, T2, T3> = class(TDNGenericImport<DNJoinBlockClass<T1, T2, T3>, DNJoinBlock<T1, T2, T3>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNTransformBlockClass<TInput, TOutput> = interface(DNObjectClass)
  ['{879587A7-EACD-5AF8-BD20-E2070D8E8618}']
  { constructors } 

    {class} function init(transform: DDNC.System.Private.CoreLib.DNFunc<TInput, TOutput>): DNTransformBlock<TInput, TOutput>; overload;
    {class} function init(transform: DDNC.System.Private.CoreLib.DNFunc<TInput, TOutput>; dataflowBlockOptions: DNExecutionDataflowBlockOptions): DNTransformBlock<TInput, TOutput>; overload;
    {class} function init(transform: DDNC.System.Private.CoreLib.DNFunc<TInput, DDNC.System.Private.CoreLib.DNTask<TOutput>>): DNTransformBlock<TInput, TOutput>; overload;
    {class} function init(transform: DDNC.System.Private.CoreLib.DNFunc<TInput, DDNC.System.Private.CoreLib.DNTask<TOutput>>; dataflowBlockOptions: DNExecutionDataflowBlockOptions): DNTransformBlock<TInput, TOutput>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.TransformBlock`2')]
  DNTransformBlock<TInput, TOutput> = interface(DNIPropagatorBlock<TInput, TOutput>)
  ['{BC3F174B-1A35-35B9-9FB3-30C581F5EA2C}']
  { getters & setters } 

    function get_Completion: DDNC.System.Private.CoreLib.DNTask;
    function get_InputCount: Int32;
    function get_OutputCount: Int32;

  { methods } 

    procedure Complete;
    function LinkTo(target: DNITargetBlock<TOutput>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<TOutput>; out item: TOutput): Boolean;
    function TryReceiveAll(out items: DDNC.System.Private.CoreLib.DNIList<TOutput>): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
    property InputCount: Int32 read get_InputCount;
    property OutputCount: Int32 read get_OutputCount;
  end;

  TDNTransformBlock<TInput, TOutput> = class(TDNGenericImport<DNTransformBlockClass<TInput, TOutput>, DNTransformBlock<TInput, TOutput>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNTransformManyBlockClass<TInput, TOutput> = interface(DNObjectClass)
  ['{921D30FD-AD27-5FC1-8780-D34ECC9C9BB3}']
  { constructors } 

    {class} function init(transform: DDNC.System.Private.CoreLib.DNFunc<TInput, DDNC.System.Private.CoreLib.DNIEnumerable<TOutput>>): DNTransformManyBlock<TInput, TOutput>; overload;
    {class} function init(transform: DDNC.System.Private.CoreLib.DNFunc<TInput, DDNC.System.Private.CoreLib.DNIEnumerable<TOutput>>; dataflowBlockOptions: DNExecutionDataflowBlockOptions): DNTransformManyBlock<TInput, TOutput>; overload;
    {class} function init(transform: DDNC.System.Private.CoreLib.DNFunc<TInput, DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNIEnumerable<TOutput>>>): DNTransformManyBlock<TInput, TOutput>; overload;
    {class} function init(transform: DDNC.System.Private.CoreLib.DNFunc<TInput, DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNIEnumerable<TOutput>>>; dataflowBlockOptions: DNExecutionDataflowBlockOptions): DNTransformManyBlock<TInput, TOutput>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.TransformManyBlock`2')]
  DNTransformManyBlock<TInput, TOutput> = interface(DNIPropagatorBlock<TInput, TOutput>)
  ['{5BDC939C-604E-39C0-96A2-B5FD9AEBC463}']
  { getters & setters } 

    function get_Completion: DDNC.System.Private.CoreLib.DNTask;
    function get_InputCount: Int32;
    function get_OutputCount: Int32;

  { methods } 

    procedure Complete;
    function LinkTo(target: DNITargetBlock<TOutput>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<TOutput>; out item: TOutput): Boolean;
    function TryReceiveAll(out items: DDNC.System.Private.CoreLib.DNIList<TOutput>): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
    property InputCount: Int32 read get_InputCount;
    property OutputCount: Int32 read get_OutputCount;
  end;

  TDNTransformManyBlock<TInput, TOutput> = class(TDNGenericImport<DNTransformManyBlockClass<TInput, TOutput>, DNTransformManyBlock<TInput, TOutput>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNWriteOnceBlockClass<T> = interface(DNObjectClass)
  ['{64BDD403-484A-53C1-BBE2-E577D3FB41C3}']
  { constructors } 

    {class} function init(cloningFunction: DDNC.System.Private.CoreLib.DNFunc<T, T>): DNWriteOnceBlock<T>; overload;
    {class} function init(cloningFunction: DDNC.System.Private.CoreLib.DNFunc<T, T>; dataflowBlockOptions: DNDataflowBlockOptions): DNWriteOnceBlock<T>; overload;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.WriteOnceBlock`1')]
  DNWriteOnceBlock<T> = interface(DNIPropagatorBlock<T, T>)
  ['{B173E120-855D-3056-8476-66E06D766D45}']
  { getters & setters } 

    function get_Completion: DDNC.System.Private.CoreLib.DNTask;

  { methods } 

    procedure Complete;
    function TryReceive(filter: DDNC.System.Private.CoreLib.DNPredicate<T>; out item: T): Boolean;
    function LinkTo(target: DNITargetBlock<T>; linkOptions: DNDataflowLinkOptions): DDNC.System.Private.CoreLib.DNIDisposable;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Completion: DDNC.System.Private.CoreLib.DNTask read get_Completion;
  end;

  TDNWriteOnceBlock<T> = class(TDNGenericImport<DNWriteOnceBlockClass<T>, DNWriteOnceBlock<T>>) end;

  //-------------namespace: System.Threading.Tasks.Dataflow----------------
  DNDataflowMessageHeaderClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{B4959AF1-7EAF-5DD2-BBC5-E372F9B2AB8E}']
  { constructors } 

    {class} function init(id: Int64): DNDataflowMessageHeader;

  end;

  [DNTypeName('System.Threading.Tasks.Dataflow.DataflowMessageHeader')]
  DNDataflowMessageHeader = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{08B772B5-1183-3DC8-88A5-88E97F1DDFAB}']
  { getters & setters } 

    function get_IsValid: Boolean;
    function get_Id: Int64;

  { methods } 

    function Equals(other: DNDataflowMessageHeader): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsValid: Boolean read get_IsValid;
    property Id: Int64 read get_Id;
  end;

  TDNDataflowMessageHeader = class(TDNGenericImport<DNDataflowMessageHeaderClass, DNDataflowMessageHeader>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Threading.Tasks.Dataflow, Version=4.6.3.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
