//----------------------------------------------------------------------------
//  System.Security.Cryptography.OpenSsl.dll: System.Security.Cryptography.OpenSsl, Version=4.1.1.1, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.OpenSsl
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.OpenSsl;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Security.Cryptography.Algorithms,
  DDNC.System.Security.Cryptography.Primitives;

type


{ declares }

  DNSafeEvpPKeyHandle = interface; // type: System.Security.Cryptography.SafeEvpPKeyHandle, namespace: System.Security.Cryptography
  DNDSAOpenSsl = interface; // type: System.Security.Cryptography.DSAOpenSsl, namespace: System.Security.Cryptography
  DNECDiffieHellmanOpenSsl = interface; // type: System.Security.Cryptography.ECDiffieHellmanOpenSsl, namespace: System.Security.Cryptography
  DNECDsaOpenSsl = interface; // type: System.Security.Cryptography.ECDsaOpenSsl, namespace: System.Security.Cryptography
  DNRSAOpenSsl = interface; // type: System.Security.Cryptography.RSAOpenSsl, namespace: System.Security.Cryptography


{ objects }

  //-------------namespace: System.Security.Cryptography----------------
  DNSafeEvpPKeyHandleClass = interface(DDNC.System.Private.CoreLib.DNSafeHandleClass)
  ['{6408935B-0B9B-5780-BFCC-CC5B48BC52A7}']
  { constructors } 

    {class} function init(handle: IntPtr; ownsHandle: Boolean): DNSafeEvpPKeyHandle;

  end;

  [DNTypeName('System.Security.Cryptography.SafeEvpPKeyHandle')]
  DNSafeEvpPKeyHandle = interface(DDNC.System.Private.CoreLib.DNSafeHandle)
  ['{98CAF538-333D-3207-9F94-72CAA953466D}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DuplicateHandle: DNSafeEvpPKeyHandle;
    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeEvpPKeyHandle = class(TDNGenericImport<DNSafeEvpPKeyHandleClass, DNSafeEvpPKeyHandle>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSAOpenSslClass = interface(DNObjectClass)
  ['{D058C146-2989-5738-8DEF-7F6BE5B54C43}']
  { static getter & setter } 

    procedure set_KeySize(value: Int32);

  { constructors } 

    {class} function init: DNDSAOpenSsl; overload;
    {class} function init(keySize: Int32): DNDSAOpenSsl; overload;
    {class} function init(handle: IntPtr): DNDSAOpenSsl; overload;
    {class} function init(parameters: DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters): DNDSAOpenSsl; overload;
    {class} function init(pkeyHandle: DNSafeEvpPKeyHandle): DNDSAOpenSsl; overload;

  { static propertys } 

    {class} property KeySize: Int32 write set_KeySize;
  end;

  [DNTypeName('System.Security.Cryptography.DSAOpenSsl')]
  DNDSAOpenSsl = interface(DNObject)
  ['{6E4DBE9C-E3E0-321D-823A-0463A7BF206D}']
  { getters & setters } 

    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_SignatureAlgorithm: string;
    function get_KeyExchangeAlgorithm: string;

  { methods } 

    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>;
    function DuplicateKeyHandle: DNSafeEvpPKeyHandle;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters;
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters);
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property KeySize: Int32 write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
  end;

  TDNDSAOpenSsl = class(TDNGenericImport<DNDSAOpenSslClass, DNDSAOpenSsl>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanOpenSslClass = interface(DNObjectClass)
  ['{E1E3D5A7-EEB1-57C5-935D-1A839A16813C}']
  { constructors } 

    {class} function init: DNECDiffieHellmanOpenSsl; overload;
    {class} function init(keySize: Int32): DNECDiffieHellmanOpenSsl; overload;
    {class} function init(handle: IntPtr): DNECDiffieHellmanOpenSsl; overload;
    {class} function init(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve): DNECDiffieHellmanOpenSsl; overload;
    {class} function init(pkeyHandle: DNSafeEvpPKeyHandle): DNECDiffieHellmanOpenSsl; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanOpenSsl')]
  DNECDiffieHellmanOpenSsl = interface(DNObject)
  ['{CBCDE2CD-4056-3276-A28D-A7403DE8033A}']
  { getters & setters } 

    function get_PublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function DeriveKeyFromHash(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyMaterial(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey): TArray<Byte>;
    function DeriveKeyTls(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; prfLabel: TArray<Byte>; prfSeed: TArray<Byte>): TArray<Byte>;
    function DuplicateKeyHandle: DNSafeEvpPKeyHandle;
    function ExportExplicitParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    procedure GenerateKey(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve);
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters);
    function DeriveKeyFromHash(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>): TArray<Byte>; overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property PublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey read get_PublicKey;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNECDiffieHellmanOpenSsl = class(TDNGenericImport<DNECDiffieHellmanOpenSslClass, DNECDiffieHellmanOpenSsl>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDsaOpenSslClass = interface(DNObjectClass)
  ['{F5299357-D53C-5D1F-99FF-8E566A7E4CA9}']
  { constructors } 

    {class} function init: DNECDsaOpenSsl; overload;
    {class} function init(keySize: Int32): DNECDsaOpenSsl; overload;
    {class} function init(handle: IntPtr): DNECDsaOpenSsl; overload;
    {class} function init(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve): DNECDsaOpenSsl; overload;
    {class} function init(pkeyHandle: DNSafeEvpPKeyHandle): DNECDsaOpenSsl; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDsaOpenSsl')]
  DNECDsaOpenSsl = interface(DNObject)
  ['{648AE3AA-CCD1-3B1B-8B7B-D65D60625BBC}']
  { getters & setters } 

    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function DuplicateKeyHandle: DNSafeEvpPKeyHandle;
    function ExportExplicitParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    procedure GenerateKey(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve);
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters);
    function SignHash(hash: TArray<Byte>): TArray<Byte>;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNECDsaOpenSsl = class(TDNGenericImport<DNECDsaOpenSslClass, DNECDsaOpenSsl>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAOpenSslClass = interface(DNObjectClass)
  ['{A886EAF4-0237-5506-BD99-505C8C64D1C1}']
  { static getter & setter } 

    procedure set_KeySize(value: Int32);

  { constructors } 

    {class} function init: DNRSAOpenSsl; overload;
    {class} function init(keySize: Int32): DNRSAOpenSsl; overload;
    {class} function init(handle: IntPtr): DNRSAOpenSsl; overload;
    {class} function init(parameters: DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters): DNRSAOpenSsl; overload;
    {class} function init(pkeyHandle: DNSafeEvpPKeyHandle): DNRSAOpenSsl; overload;

  { static propertys } 

    {class} property KeySize: Int32 write set_KeySize;
  end;

  [DNTypeName('System.Security.Cryptography.RSAOpenSsl')]
  DNRSAOpenSsl = interface(DNObject)
  ['{041FF280-D2D9-3819-B31C-25F7DC04B270}']
  { getters & setters } 

    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function Decrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>;
    function DuplicateKeyHandle: DNSafeEvpPKeyHandle;
    function Encrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters;
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters);
    function SignHash(hash: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function TryDecrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TryEncrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function DecryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function EncryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property KeySize: Int32 write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNRSAOpenSsl = class(TDNGenericImport<DNRSAOpenSslClass, DNRSAOpenSsl>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.OpenSsl, Version=4.1.1.1, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
