//----------------------------------------------------------------------------
//  System.Security.Cryptography.Csp.dll: System.Security.Cryptography.Csp, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.Csp
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.Csp;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Security.Cryptography.Algorithms,
  DDNC.System.Security.Cryptography.Primitives;

type

{ enums }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CspProviderFlags')]
  DNCspProviderFlags = type Integer;
  DNCspProviderFlagsHelper = record helper for DNCspProviderFlags
  public const
    NoFlags = 0;
    UseMachineKeyStore = 1;
    UseDefaultKeyContainer = 2;
    UseNonExportableKey = 4;
    UseExistingKey = 8;
    UseArchivableKey = 16;
    UseUserProtectedKey = 32;
    NoPrompt = 64;
    CreateEphemeralKey = 128;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.KeyNumber')]
  DNKeyNumber = type Integer;
  DNKeyNumberHelper = record helper for DNKeyNumber
  public const
    Exchange = 1;
    Signature = 2;
  end;




type


{ declares }

  DNICspAsymmetricAlgorithm = interface; // type: System.Security.Cryptography.ICspAsymmetricAlgorithm, namespace: System.Security.Cryptography
  DNDSACryptoServiceProvider = interface; // type: System.Security.Cryptography.DSACryptoServiceProvider, namespace: System.Security.Cryptography
  DNRSACryptoServiceProvider = interface; // type: System.Security.Cryptography.RSACryptoServiceProvider, namespace: System.Security.Cryptography
  DNCspKeyContainerInfo = interface; // type: System.Security.Cryptography.CspKeyContainerInfo, namespace: System.Security.Cryptography
  DNCspParameters = interface; // type: System.Security.Cryptography.CspParameters, namespace: System.Security.Cryptography
  DNPasswordDeriveBytes = interface; // type: System.Security.Cryptography.PasswordDeriveBytes, namespace: System.Security.Cryptography
  DNMD5CryptoServiceProvider = interface; // type: System.Security.Cryptography.MD5CryptoServiceProvider, namespace: System.Security.Cryptography
  DNSHA1CryptoServiceProvider = interface; // type: System.Security.Cryptography.SHA1CryptoServiceProvider, namespace: System.Security.Cryptography
  DNSHA256CryptoServiceProvider = interface; // type: System.Security.Cryptography.SHA256CryptoServiceProvider, namespace: System.Security.Cryptography
  DNSHA384CryptoServiceProvider = interface; // type: System.Security.Cryptography.SHA384CryptoServiceProvider, namespace: System.Security.Cryptography
  DNSHA512CryptoServiceProvider = interface; // type: System.Security.Cryptography.SHA512CryptoServiceProvider, namespace: System.Security.Cryptography
  DNRNGCryptoServiceProvider = interface; // type: System.Security.Cryptography.RNGCryptoServiceProvider, namespace: System.Security.Cryptography
  DNAesCryptoServiceProvider = interface; // type: System.Security.Cryptography.AesCryptoServiceProvider, namespace: System.Security.Cryptography
  DNDESCryptoServiceProvider = interface; // type: System.Security.Cryptography.DESCryptoServiceProvider, namespace: System.Security.Cryptography
  DNRC2CryptoServiceProvider = interface; // type: System.Security.Cryptography.RC2CryptoServiceProvider, namespace: System.Security.Cryptography
  DNTripleDESCryptoServiceProvider = interface; // type: System.Security.Cryptography.TripleDESCryptoServiceProvider, namespace: System.Security.Cryptography


{ objects }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.ICspAsymmetricAlgorithm')]
  DNICspAsymmetricAlgorithm = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{494A7583-190E-3693-9EC4-DE54DC6A84A2}']
  { getters & setters } 

    function get_CspKeyContainerInfo: DNCspKeyContainerInfo;

  { methods } 

    function ExportCspBlob(includePrivateParameters: Boolean): TArray<Byte>;
    procedure ImportCspBlob(rawData: TArray<Byte>);

  { propertys } 

    property CspKeyContainerInfo: DNCspKeyContainerInfo read get_CspKeyContainerInfo;
  end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSACryptoServiceProviderClass = interface(DNObjectClass)
  ['{CF4144A8-C87F-598D-954C-9D5CE88DE00F}']
  { static getter & setter } 

    {class} function get_UseMachineKeyStore: Boolean;
    {class} procedure set_UseMachineKeyStore(value: Boolean);

  { constructors } 

    {class} function init: DNDSACryptoServiceProvider; overload;
    {class} function init(dwKeySize: Int32): DNDSACryptoServiceProvider; overload;
    {class} function init(parameters: DNCspParameters): DNDSACryptoServiceProvider; overload;
    {class} function init(dwKeySize: Int32; parameters: DNCspParameters): DNDSACryptoServiceProvider; overload;

  { static propertys } 

    {class} property UseMachineKeyStore: Boolean read get_UseMachineKeyStore write set_UseMachineKeyStore;
  end;

  [DNTypeName('System.Security.Cryptography.DSACryptoServiceProvider')]
  DNDSACryptoServiceProvider = interface(DNObject)
  ['{D4A22DE8-11B6-32CB-BC22-63E2077D3C1C}']
  { getters & setters } 

    function get_CspKeyContainerInfo: DNCspKeyContainerInfo;
    function get_KeySize: Int32;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_PersistKeyInCsp: Boolean;
    procedure set_PersistKeyInCsp(value: Boolean);
    function get_PublicOnly: Boolean;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function ExportCspBlob(includePrivateParameters: Boolean): TArray<Byte>;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters;
    procedure ImportCspBlob(keyBlob: TArray<Byte>);
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters);
    function SignData(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function SignData(buffer: TArray<Byte>): TArray<Byte>; overload;
    function SignData(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function VerifyData(rgbData: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function SignHash(rgbHash: TArray<Byte>; str: string): TArray<Byte>;
    function VerifyHash(rgbHash: TArray<Byte>; str: string; rgbSignature: TArray<Byte>): Boolean;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CspKeyContainerInfo: DNCspKeyContainerInfo read get_CspKeyContainerInfo;
    property KeySize: Int32 read get_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property PersistKeyInCsp: Boolean read get_PersistKeyInCsp write set_PersistKeyInCsp;
    property PublicOnly: Boolean read get_PublicOnly;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNDSACryptoServiceProvider = class(TDNGenericImport<DNDSACryptoServiceProviderClass, DNDSACryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSACryptoServiceProviderClass = interface(DNObjectClass)
  ['{075F5845-C10D-562F-8676-2F036703DBFB}']
  { static getter & setter } 

    {class} function get_UseMachineKeyStore: Boolean;
    {class} procedure set_UseMachineKeyStore(value: Boolean);

  { constructors } 

    {class} function init: DNRSACryptoServiceProvider; overload;
    {class} function init(dwKeySize: Int32): DNRSACryptoServiceProvider; overload;
    {class} function init(dwKeySize: Int32; parameters: DNCspParameters): DNRSACryptoServiceProvider; overload;
    {class} function init(parameters: DNCspParameters): DNRSACryptoServiceProvider; overload;

  { static propertys } 

    {class} property UseMachineKeyStore: Boolean read get_UseMachineKeyStore write set_UseMachineKeyStore;
  end;

  [DNTypeName('System.Security.Cryptography.RSACryptoServiceProvider')]
  DNRSACryptoServiceProvider = interface(DNObject)
  ['{797ED833-B1E3-3CDF-B063-3FD7B388B85D}']
  { getters & setters } 

    function get_CspKeyContainerInfo: DNCspKeyContainerInfo;
    function get_KeySize: Int32;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_PersistKeyInCsp: Boolean;
    procedure set_PersistKeyInCsp(value: Boolean);
    function get_PublicOnly: Boolean;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function Decrypt(rgb: TArray<Byte>; fOAEP: Boolean): TArray<Byte>; overload;
    function DecryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function Encrypt(rgb: TArray<Byte>; fOAEP: Boolean): TArray<Byte>; overload;
    function EncryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function ExportCspBlob(includePrivateParameters: Boolean): TArray<Byte>;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters;
    procedure ImportCspBlob(keyBlob: TArray<Byte>);
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters);
    function SignData(buffer: TArray<Byte>; offset: Int32; count: Int32; halg: DDNC.System.Private.CoreLib.DNObject): TArray<Byte>; overload;
    function SignData(buffer: TArray<Byte>; halg: DDNC.System.Private.CoreLib.DNObject): TArray<Byte>; overload;
    function SignData(inputStream: DDNC.System.Private.CoreLib.DNStream; halg: DDNC.System.Private.CoreLib.DNObject): TArray<Byte>; overload;
    function SignHash(rgbHash: TArray<Byte>; str: string): TArray<Byte>; overload;
    function VerifyData(buffer: TArray<Byte>; halg: DDNC.System.Private.CoreLib.DNObject; signature: TArray<Byte>): Boolean; overload;
    function VerifyHash(rgbHash: TArray<Byte>; str: string; rgbSignature: TArray<Byte>): Boolean; overload;
    function Encrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>; overload;
    function Decrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>; overload;
    function SignHash(hash: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function TryDecrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TryEncrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CspKeyContainerInfo: DNCspKeyContainerInfo read get_CspKeyContainerInfo;
    property KeySize: Int32 read get_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property PersistKeyInCsp: Boolean read get_PersistKeyInCsp write set_PersistKeyInCsp;
    property PublicOnly: Boolean read get_PublicOnly;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNRSACryptoServiceProvider = class(TDNGenericImport<DNRSACryptoServiceProviderClass, DNRSACryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCspKeyContainerInfoClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{E8F61AC0-615D-56A8-B65C-169916BE9D6D}']
  { constructors } 

    {class} function init(parameters: DNCspParameters): DNCspKeyContainerInfo;

  end;

  [DNTypeName('System.Security.Cryptography.CspKeyContainerInfo')]
  DNCspKeyContainerInfo = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4B63118B-5E8C-34FF-9758-AE5060AC24F2}']
  { getters & setters } 

    function get_Accessible: Boolean;
    function get_Exportable: Boolean;
    function get_HardwareDevice: Boolean;
    function get_KeyContainerName: string;
    function get_KeyNumber: DNKeyNumber;
    function get_MachineKeyStore: Boolean;
    function get_Protected: Boolean;
    function get_ProviderName: string;
    function get_ProviderType: Int32;
    function get_RandomlyGenerated: Boolean;
    function get_Removable: Boolean;
    function get_UniqueKeyContainerName: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Accessible: Boolean read get_Accessible;
    property Exportable: Boolean read get_Exportable;
    property HardwareDevice: Boolean read get_HardwareDevice;
    property KeyContainerName: string read get_KeyContainerName;
    property KeyNumber: DNKeyNumber read get_KeyNumber;
    property MachineKeyStore: Boolean read get_MachineKeyStore;
    property &Protected: Boolean read get_Protected;
    property ProviderName: string read get_ProviderName;
    property ProviderType: Int32 read get_ProviderType;
    property RandomlyGenerated: Boolean read get_RandomlyGenerated;
    property Removable: Boolean read get_Removable;
    property UniqueKeyContainerName: string read get_UniqueKeyContainerName;
  end;

  TDNCspKeyContainerInfo = class(TDNGenericImport<DNCspKeyContainerInfoClass, DNCspKeyContainerInfo>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCspParametersClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7890AD91-133E-5F29-AFC0-772C850576F3}']
  { constructors } 

    {class} function init: DNCspParameters; overload;
    {class} function init(dwTypeIn: Int32): DNCspParameters; overload;
    {class} function init(dwTypeIn: Int32; strProviderNameIn: string): DNCspParameters; overload;
    {class} function init(dwTypeIn: Int32; strProviderNameIn: string; strContainerNameIn: string): DNCspParameters; overload;

  end;

  [DNTypeName('System.Security.Cryptography.CspParameters')]
  DNCspParameters = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{85640FF2-100A-3038-A690-62FDDE4459E7}']
  { getters & setters } 

    function get_Flags: DNCspProviderFlags;
    procedure set_Flags(value: DNCspProviderFlags);
    function get_KeyPassword: DDNC.System.Private.CoreLib.DNSecureString;
    procedure set_KeyPassword(value: DDNC.System.Private.CoreLib.DNSecureString);
    function get_ParentWindowHandle: IntPtr;
    procedure set_ParentWindowHandle(value: IntPtr);

  { fields getter & setter } 

   function __fakeFieldGet_ProviderType: Int32;
   procedure __fakeFieldSet_ProviderType(value: Int32);
   function __fakeFieldGet_ProviderName: string;
   procedure __fakeFieldSet_ProviderName(value: string);
   function __fakeFieldGet_KeyContainerName: string;
   procedure __fakeFieldSet_KeyContainerName(value: string);
   function __fakeFieldGet_KeyNumber: Int32;
   procedure __fakeFieldSet_KeyNumber(value: Int32);

  { fields } 

   property ProviderType: Int32 read __fakeFieldGet_ProviderType write __fakeFieldSet_ProviderType;
   property ProviderName: string read __fakeFieldGet_ProviderName write __fakeFieldSet_ProviderName;
   property KeyContainerName: string read __fakeFieldGet_KeyContainerName write __fakeFieldSet_KeyContainerName;
   property KeyNumber: Int32 read __fakeFieldGet_KeyNumber write __fakeFieldSet_KeyNumber;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Flags: DNCspProviderFlags read get_Flags write set_Flags;
    property KeyPassword: DDNC.System.Private.CoreLib.DNSecureString read get_KeyPassword write set_KeyPassword;
    property ParentWindowHandle: IntPtr read get_ParentWindowHandle write set_ParentWindowHandle;
  end;

  TDNCspParameters = class(TDNGenericImport<DNCspParametersClass, DNCspParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNPasswordDeriveBytesClass = interface(DNObjectClass)
  ['{1E88DCC5-3353-5BD4-9DEC-F67847DEC55F}']
  { constructors } 

    {class} function init(strPassword: string; rgbSalt: TArray<Byte>): DNPasswordDeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>): DNPasswordDeriveBytes; overload;
    {class} function init(strPassword: string; rgbSalt: TArray<Byte>; strHashName: string; iterations: Int32): DNPasswordDeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; hashName: string; iterations: Int32): DNPasswordDeriveBytes; overload;
    {class} function init(strPassword: string; rgbSalt: TArray<Byte>; cspParams: DNCspParameters): DNPasswordDeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; cspParams: DNCspParameters): DNPasswordDeriveBytes; overload;
    {class} function init(strPassword: string; rgbSalt: TArray<Byte>; strHashName: string; iterations: Int32; cspParams: DNCspParameters): DNPasswordDeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; hashName: string; iterations: Int32; cspParams: DNCspParameters): DNPasswordDeriveBytes; overload;

  end;

  [DNTypeName('System.Security.Cryptography.PasswordDeriveBytes')]
  DNPasswordDeriveBytes = interface(DNObject)
  ['{B1F41EBC-3E2C-34D7-8DBF-8971D000B9AD}']
  { getters & setters } 

    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_IterationCount: Int32;
    procedure set_IterationCount(value: Int32);
    function get_Salt: TArray<Byte>;
    procedure set_Salt(value: TArray<Byte>);

  { methods } 

    function GetBytes(cb: Int32): TArray<Byte>;
    procedure Reset;
    function CryptDeriveKey(algname: string; alghashname: string; keySize: Int32; rgbIV: TArray<Byte>): TArray<Byte>;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashName: string read get_HashName write set_HashName;
    property IterationCount: Int32 read get_IterationCount write set_IterationCount;
    property Salt: TArray<Byte> read get_Salt write set_Salt;
  end;

  TDNPasswordDeriveBytes = class(TDNGenericImport<DNPasswordDeriveBytesClass, DNPasswordDeriveBytes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNMD5CryptoServiceProviderClass = interface(DNObjectClass)
  ['{E389F3EB-1EB9-5177-BFCF-D3808A5C247A}']
  { constructors } 

    {class} function init: DNMD5CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.MD5CryptoServiceProvider')]
  DNMD5CryptoServiceProvider = interface(DNObject)
  ['{F64F9C93-3BA5-30EE-BEF8-E596A6099375}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNMD5CryptoServiceProvider = class(TDNGenericImport<DNMD5CryptoServiceProviderClass, DNMD5CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA1CryptoServiceProviderClass = interface(DNObjectClass)
  ['{351CF406-F4F8-5DE5-B79C-5ABA487F7141}']
  { constructors } 

    {class} function init: DNSHA1CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.SHA1CryptoServiceProvider')]
  DNSHA1CryptoServiceProvider = interface(DNObject)
  ['{51B3FD06-01C2-31DE-B2CA-8D54792F270E}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA1CryptoServiceProvider = class(TDNGenericImport<DNSHA1CryptoServiceProviderClass, DNSHA1CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA256CryptoServiceProviderClass = interface(DNObjectClass)
  ['{209427E1-37F6-598E-81CD-38FFE9593199}']
  { constructors } 

    {class} function init: DNSHA256CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.SHA256CryptoServiceProvider')]
  DNSHA256CryptoServiceProvider = interface(DNObject)
  ['{FC976BC5-644E-3127-A69C-DF688B8989A7}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA256CryptoServiceProvider = class(TDNGenericImport<DNSHA256CryptoServiceProviderClass, DNSHA256CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA384CryptoServiceProviderClass = interface(DNObjectClass)
  ['{DAF85E5E-4666-5E21-9C85-0BB24698E351}']
  { constructors } 

    {class} function init: DNSHA384CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.SHA384CryptoServiceProvider')]
  DNSHA384CryptoServiceProvider = interface(DNObject)
  ['{9F0FAF7D-3D2C-3F11-B090-E40FEF539BAB}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA384CryptoServiceProvider = class(TDNGenericImport<DNSHA384CryptoServiceProviderClass, DNSHA384CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA512CryptoServiceProviderClass = interface(DNObjectClass)
  ['{FBC33382-4FDA-5008-AB79-01B6F200D8E2}']
  { constructors } 

    {class} function init: DNSHA512CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.SHA512CryptoServiceProvider')]
  DNSHA512CryptoServiceProvider = interface(DNObject)
  ['{F3BB8269-ABEB-3AC9-936E-A3EBBD56442D}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA512CryptoServiceProvider = class(TDNGenericImport<DNSHA512CryptoServiceProviderClass, DNSHA512CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRNGCryptoServiceProviderClass = interface(DNObjectClass)
  ['{A9BDD2F9-9C94-5629-A808-7A88362C4773}']
  { constructors } 

    {class} function init: DNRNGCryptoServiceProvider; overload;
    {class} function init(str: string): DNRNGCryptoServiceProvider; overload;
    {class} function init(rgb: TArray<Byte>): DNRNGCryptoServiceProvider; overload;
    {class} function init(cspParams: DNCspParameters): DNRNGCryptoServiceProvider; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RNGCryptoServiceProvider')]
  DNRNGCryptoServiceProvider = interface(DNObject)
  ['{2B299AC1-1793-37C1-8F57-48C7F9F8C9C5}']
  { methods } 

    procedure GetBytes(data: TArray<Byte>); overload;
    procedure GetBytes(data: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure GetBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    procedure GetNonZeroBytes(data: TArray<Byte>); overload;
    procedure GetNonZeroBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRNGCryptoServiceProvider = class(TDNGenericImport<DNRNGCryptoServiceProviderClass, DNRNGCryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesCryptoServiceProviderClass = interface(DNObjectClass)
  ['{5FE08E93-51D1-5AD5-AD5D-1515FB328AE0}']
  { constructors } 

    {class} function init: DNAesCryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.AesCryptoServiceProvider')]
  DNAesCryptoServiceProvider = interface(DNObject)
  ['{A189B72E-D386-34AF-A6C7-672E6667399C}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNAesCryptoServiceProvider = class(TDNGenericImport<DNAesCryptoServiceProviderClass, DNAesCryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDESCryptoServiceProviderClass = interface(DNObjectClass)
  ['{787402A8-31DF-531C-AC6F-854C6CD89ED8}']
  { constructors } 

    {class} function init: DNDESCryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.DESCryptoServiceProvider')]
  DNDESCryptoServiceProvider = interface(DNObject)
  ['{21E1BA37-43EE-32AD-A9C8-494B869EF521}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    procedure GenerateKey;
    procedure GenerateIV;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNDESCryptoServiceProvider = class(TDNGenericImport<DNDESCryptoServiceProviderClass, DNDESCryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRC2CryptoServiceProviderClass = interface(DNObjectClass)
  ['{972105B6-4B32-5FA8-8336-6E1C9CA7139A}']
  { constructors } 

    {class} function init: DNRC2CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.RC2CryptoServiceProvider')]
  DNRC2CryptoServiceProvider = interface(DNObject)
  ['{D9A92556-725C-35E0-9363-D2574F04BA25}']
  { getters & setters } 

    function get_EffectiveKeySize: Int32;
    procedure set_EffectiveKeySize(value: Int32);
    function get_UseSalt: Boolean;
    procedure set_UseSalt(value: Boolean);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateKey;
    procedure GenerateIV;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property EffectiveKeySize: Int32 read get_EffectiveKeySize write set_EffectiveKeySize;
    property UseSalt: Boolean read get_UseSalt write set_UseSalt;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNRC2CryptoServiceProvider = class(TDNGenericImport<DNRC2CryptoServiceProviderClass, DNRC2CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNTripleDESCryptoServiceProviderClass = interface(DNObjectClass)
  ['{53625AD0-D14C-5EE1-83F0-F810CF4FFC28}']
  { constructors } 

    {class} function init: DNTripleDESCryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.TripleDESCryptoServiceProvider')]
  DNTripleDESCryptoServiceProvider = interface(DNObject)
  ['{5832C5C5-2DC3-32EE-AFD2-6A4765937969}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNTripleDESCryptoServiceProvider = class(TDNGenericImport<DNTripleDESCryptoServiceProviderClass, DNTripleDESCryptoServiceProvider>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.Csp, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
