//----------------------------------------------------------------------------
//  System.Security.Cryptography.Algorithms.dll: System.Security.Cryptography.Algorithms, Version=4.3.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.Algorithms
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.Algorithms;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Security.Cryptography.Primitives,
  DDNC.System.Runtime.Extensions,
  DDNC.System.Security.Cryptography.Encoding;

type

{ enums }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.ECCurve+ECCurveType')]
  DNECCurve_ECCurveType = type Integer;
  DNECCurve_ECCurveTypeHelper = record helper for DNECCurve_ECCurveType
  public const
    Implicit = 0;
    PrimeShortWeierstrass = 1;
    PrimeTwistedEdwards = 2;
    PrimeMontgomery = 3;
    Characteristic2 = 4;
    Named = 5;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.RSAEncryptionPaddingMode')]
  DNRSAEncryptionPaddingMode = type Integer;
  DNRSAEncryptionPaddingModeHelper = record helper for DNRSAEncryptionPaddingMode
  public const
    Pkcs1 = 0;
    Oaep = 1;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.RSASignaturePaddingMode')]
  DNRSASignaturePaddingMode = type Integer;
  DNRSASignaturePaddingModeHelper = record helper for DNRSASignaturePaddingMode
  public const
    Pkcs1 = 0;
    Pss = 1;
  end;




type


{ declares }

  DNDSA = interface; // type: System.Security.Cryptography.DSA, namespace: System.Security.Cryptography
  DNECDiffieHellman = interface; // type: System.Security.Cryptography.ECDiffieHellman, namespace: System.Security.Cryptography
  DNECDsa = interface; // type: System.Security.Cryptography.ECDsa, namespace: System.Security.Cryptography
  DNRSA = interface; // type: System.Security.Cryptography.RSA, namespace: System.Security.Cryptography
  DNAsymmetricKeyExchangeDeformatter = interface; // type: System.Security.Cryptography.AsymmetricKeyExchangeDeformatter, namespace: System.Security.Cryptography
  DNRSAOAEPKeyExchangeDeformatter = interface; // type: System.Security.Cryptography.RSAOAEPKeyExchangeDeformatter, namespace: System.Security.Cryptography
  DNRSAPKCS1KeyExchangeDeformatter = interface; // type: System.Security.Cryptography.RSAPKCS1KeyExchangeDeformatter, namespace: System.Security.Cryptography
  DNAsymmetricKeyExchangeFormatter = interface; // type: System.Security.Cryptography.AsymmetricKeyExchangeFormatter, namespace: System.Security.Cryptography
  DNRSAOAEPKeyExchangeFormatter = interface; // type: System.Security.Cryptography.RSAOAEPKeyExchangeFormatter, namespace: System.Security.Cryptography
  DNRSAPKCS1KeyExchangeFormatter = interface; // type: System.Security.Cryptography.RSAPKCS1KeyExchangeFormatter, namespace: System.Security.Cryptography
  DNAsymmetricSignatureDeformatter = interface; // type: System.Security.Cryptography.AsymmetricSignatureDeformatter, namespace: System.Security.Cryptography
  DNDSASignatureDeformatter = interface; // type: System.Security.Cryptography.DSASignatureDeformatter, namespace: System.Security.Cryptography
  DNRSAPKCS1SignatureDeformatter = interface; // type: System.Security.Cryptography.RSAPKCS1SignatureDeformatter, namespace: System.Security.Cryptography
  DNAsymmetricSignatureFormatter = interface; // type: System.Security.Cryptography.AsymmetricSignatureFormatter, namespace: System.Security.Cryptography
  DNDSASignatureFormatter = interface; // type: System.Security.Cryptography.DSASignatureFormatter, namespace: System.Security.Cryptography
  DNRSAPKCS1SignatureFormatter = interface; // type: System.Security.Cryptography.RSAPKCS1SignatureFormatter, namespace: System.Security.Cryptography
  DNCryptoConfig = interface; // type: System.Security.Cryptography.CryptoConfig, namespace: System.Security.Cryptography
  DNDeriveBytes = interface; // type: System.Security.Cryptography.DeriveBytes, namespace: System.Security.Cryptography
  DNRfc2898DeriveBytes = interface; // type: System.Security.Cryptography.Rfc2898DeriveBytes, namespace: System.Security.Cryptography
  DNECCurve_NamedCurves = interface; // type: System.Security.Cryptography.ECCurve+NamedCurves, namespace: System.Security.Cryptography
  DNECDiffieHellmanPublicKey = interface; // type: System.Security.Cryptography.ECDiffieHellmanPublicKey, namespace: System.Security.Cryptography
  DNHMACMD5 = interface; // type: System.Security.Cryptography.HMACMD5, namespace: System.Security.Cryptography
  DNHMACSHA1 = interface; // type: System.Security.Cryptography.HMACSHA1, namespace: System.Security.Cryptography
  DNHMACSHA256 = interface; // type: System.Security.Cryptography.HMACSHA256, namespace: System.Security.Cryptography
  DNHMACSHA384 = interface; // type: System.Security.Cryptography.HMACSHA384, namespace: System.Security.Cryptography
  DNHMACSHA512 = interface; // type: System.Security.Cryptography.HMACSHA512, namespace: System.Security.Cryptography
  DNMD5 = interface; // type: System.Security.Cryptography.MD5, namespace: System.Security.Cryptography
  DNSHA1 = interface; // type: System.Security.Cryptography.SHA1, namespace: System.Security.Cryptography
  DNSHA1Managed = interface; // type: System.Security.Cryptography.SHA1Managed, namespace: System.Security.Cryptography
  DNSHA256 = interface; // type: System.Security.Cryptography.SHA256, namespace: System.Security.Cryptography
  DNSHA256Managed = interface; // type: System.Security.Cryptography.SHA256Managed, namespace: System.Security.Cryptography
  DNSHA384 = interface; // type: System.Security.Cryptography.SHA384, namespace: System.Security.Cryptography
  DNSHA384Managed = interface; // type: System.Security.Cryptography.SHA384Managed, namespace: System.Security.Cryptography
  DNSHA512 = interface; // type: System.Security.Cryptography.SHA512, namespace: System.Security.Cryptography
  DNSHA512Managed = interface; // type: System.Security.Cryptography.SHA512Managed, namespace: System.Security.Cryptography
  DNIncrementalHash = interface; // type: System.Security.Cryptography.IncrementalHash, namespace: System.Security.Cryptography
  DNMaskGenerationMethod = interface; // type: System.Security.Cryptography.MaskGenerationMethod, namespace: System.Security.Cryptography
  DNPKCS1MaskGenerationMethod = interface; // type: System.Security.Cryptography.PKCS1MaskGenerationMethod, namespace: System.Security.Cryptography
  DNRandomNumberGenerator = interface; // type: System.Security.Cryptography.RandomNumberGenerator, namespace: System.Security.Cryptography
  DNRSAEncryptionPadding = interface; // type: System.Security.Cryptography.RSAEncryptionPadding, namespace: System.Security.Cryptography
  DNRSASignaturePadding = interface; // type: System.Security.Cryptography.RSASignaturePadding, namespace: System.Security.Cryptography
  DNSignatureDescription = interface; // type: System.Security.Cryptography.SignatureDescription, namespace: System.Security.Cryptography
  DNAes = interface; // type: System.Security.Cryptography.Aes, namespace: System.Security.Cryptography
  DNAesManaged = interface; // type: System.Security.Cryptography.AesManaged, namespace: System.Security.Cryptography
  DNDES = interface; // type: System.Security.Cryptography.DES, namespace: System.Security.Cryptography
  DNRC2 = interface; // type: System.Security.Cryptography.RC2, namespace: System.Security.Cryptography
  DNRijndael = interface; // type: System.Security.Cryptography.Rijndael, namespace: System.Security.Cryptography
  DNRijndaelManaged = interface; // type: System.Security.Cryptography.RijndaelManaged, namespace: System.Security.Cryptography
  DNTripleDES = interface; // type: System.Security.Cryptography.TripleDES, namespace: System.Security.Cryptography
  DNDSAParameters = interface; // type: System.Security.Cryptography.DSAParameters, namespace: System.Security.Cryptography
  DNECCurve = interface; // type: System.Security.Cryptography.ECCurve, namespace: System.Security.Cryptography
  DNECParameters = interface; // type: System.Security.Cryptography.ECParameters, namespace: System.Security.Cryptography
  DNECPoint = interface; // type: System.Security.Cryptography.ECPoint, namespace: System.Security.Cryptography
  DNRSAParameters = interface; // type: System.Security.Cryptography.RSAParameters, namespace: System.Security.Cryptography


{ objects }

  //-------------namespace: System.Security.Cryptography----------------
  DNDSAClass = interface(DNObjectClass)
  ['{B65D4F1B-4503-5E85-83D0-6684605D4045}']
  { static methods } 

    {class} function Create(algName: string): DNDSA; overload;
    {class} function Create(keySizeInBits: Int32): DNDSA; overload;
    {class} function Create(parameters: DNDSAParameters): DNDSA; overload;
    {class} function Create: DNDSA; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSA')]
  DNDSA = interface(DNObject)
  ['{5B03E5E3-3207-397E-B8A1-091FF5C8095C}']
  { getters & setters } 

    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_SignatureAlgorithm: string;
    function get_KeyExchangeAlgorithm: string;

  { methods } 

    function ExportParameters(includePrivateParameters: Boolean): DNDSAParameters;
    procedure ImportParameters(parameters: DNDSAParameters);
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
  end;

  TDNDSA = class(TDNGenericImport<DNDSAClass, DNDSA>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanClass = interface(DNObjectClass)
  ['{59A3755E-5B8E-5DC8-9B68-DC36897B105D}']
  { static methods } 

    {class} function Create(algorithm: string): DNECDiffieHellman; overload;
    {class} function Create: DNECDiffieHellman; overload;
    {class} function Create(curve: DNECCurve): DNECDiffieHellman; overload;
    {class} function Create(parameters: DNECParameters): DNECDiffieHellman; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellman')]
  DNECDiffieHellman = interface(DNObject)
  ['{8E75BBC1-95B9-3CB1-BFEB-D536B3987DDF}']
  { getters & setters } 

    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_PublicKey: DNECDiffieHellmanPublicKey;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function DeriveKeyMaterial(otherPartyPublicKey: DNECDiffieHellmanPublicKey): TArray<Byte>;
    function DeriveKeyFromHash(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function DeriveKeyFromHash(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyTls(otherPartyPublicKey: DNECDiffieHellmanPublicKey; prfLabel: TArray<Byte>; prfSeed: TArray<Byte>): TArray<Byte>;
    function ExportParameters(includePrivateParameters: Boolean): DNECParameters;
    function ExportExplicitParameters(includePrivateParameters: Boolean): DNECParameters;
    procedure ImportParameters(parameters: DNECParameters);
    procedure GenerateKey(curve: DNECCurve);
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property PublicKey: DNECDiffieHellmanPublicKey read get_PublicKey;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNECDiffieHellman = class(TDNGenericImport<DNECDiffieHellmanClass, DNECDiffieHellman>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDsaClass = interface(DNObjectClass)
  ['{6BB32FC5-6B62-57C1-B153-3DF527857903}']
  { static methods } 

    {class} function Create(algorithm: string): DNECDsa; overload;
    {class} function Create: DNECDsa; overload;
    {class} function Create(curve: DNECCurve): DNECDsa; overload;
    {class} function Create(parameters: DNECParameters): DNECDsa; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDsa')]
  DNECDsa = interface(DNObject)
  ['{7A992E7E-105B-308B-9C2D-EBF09BEEC943}']
  { getters & setters } 

    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function ExportParameters(includePrivateParameters: Boolean): DNECParameters;
    function ExportExplicitParameters(includePrivateParameters: Boolean): DNECParameters;
    procedure ImportParameters(parameters: DNECParameters);
    procedure GenerateKey(curve: DNECCurve);
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function SignHash(hash: TArray<Byte>): TArray<Byte>;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>): Boolean; overload;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNECDsa = class(TDNGenericImport<DNECDsaClass, DNECDsa>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAClass = interface(DNObjectClass)
  ['{89376C30-E053-5FE0-A1C2-96ACD2F6175E}']
  { static methods } 

    {class} function Create(algName: string): DNRSA; overload;
    {class} function Create(keySizeInBits: Int32): DNRSA; overload;
    {class} function Create(parameters: DNRSAParameters): DNRSA; overload;
    {class} function Create: DNRSA; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSA')]
  DNRSA = interface(DNObject)
  ['{9D0055F1-2DF3-35D4-B6B3-73D90C3B4A3F}']
  { getters & setters } 

    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function ExportParameters(includePrivateParameters: Boolean): DNRSAParameters;
    procedure ImportParameters(parameters: DNRSAParameters);
    function Encrypt(data: TArray<Byte>; padding: DNRSAEncryptionPadding): TArray<Byte>;
    function Decrypt(data: TArray<Byte>; padding: DNRSAEncryptionPadding): TArray<Byte>;
    function SignHash(hash: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function TryDecrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TryEncrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function DecryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function EncryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNRSA = class(TDNGenericImport<DNRSAClass, DNRSA>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricKeyExchangeDeformatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{68212AAA-FE7D-5157-A98C-520C0E3488EE}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricKeyExchangeDeformatter')]
  DNAsymmetricKeyExchangeDeformatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9BEC5653-F017-3EB1-BDD8-BAD3C5D43C10}']
  { getters & setters } 

    function get_Parameters: string;
    procedure set_Parameters(value: string);

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function DecryptKeyExchange(rgb: TArray<Byte>): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Parameters: string read get_Parameters write set_Parameters;
  end;

  TDNAsymmetricKeyExchangeDeformatter = class(TDNGenericImport<DNAsymmetricKeyExchangeDeformatterClass, DNAsymmetricKeyExchangeDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAOAEPKeyExchangeDeformatterClass = interface(DNAsymmetricKeyExchangeDeformatterClass)
  ['{D5AB0BBD-E324-5C2F-874B-A6FD167C5BBE}']
  { constructors } 

    {class} function init: DNRSAOAEPKeyExchangeDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAOAEPKeyExchangeDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAOAEPKeyExchangeDeformatter')]
  DNRSAOAEPKeyExchangeDeformatter = interface(DNAsymmetricKeyExchangeDeformatter)
  ['{3841ABB8-6D4E-3BA1-B267-62DE08FF2878}']
  { getters & setters } 

    function get_Parameters: string;
    procedure set_Parameters(value: string);

  { methods } 

    function DecryptKeyExchange(rgbData: TArray<Byte>): TArray<Byte>;
    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Parameters: string read get_Parameters write set_Parameters;
  end;

  TDNRSAOAEPKeyExchangeDeformatter = class(TDNGenericImport<DNRSAOAEPKeyExchangeDeformatterClass, DNRSAOAEPKeyExchangeDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1KeyExchangeDeformatterClass = interface(DNAsymmetricKeyExchangeDeformatterClass)
  ['{9ABCD8FA-CCDC-50D4-B592-4A9F43DFB306}']
  { constructors } 

    {class} function init: DNRSAPKCS1KeyExchangeDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1KeyExchangeDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1KeyExchangeDeformatter')]
  DNRSAPKCS1KeyExchangeDeformatter = interface(DNAsymmetricKeyExchangeDeformatter)
  ['{3E1FE587-2B99-3D52-9AA3-A3A917753E9E}']
  { getters & setters } 

    function get_RNG: DNRandomNumberGenerator;
    procedure set_RNG(value: DNRandomNumberGenerator);
    function get_Parameters: string;
    procedure set_Parameters(value: string);

  { methods } 

    function DecryptKeyExchange(rgbIn: TArray<Byte>): TArray<Byte>;
    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property RNG: DNRandomNumberGenerator read get_RNG write set_RNG;
    property Parameters: string read get_Parameters write set_Parameters;
  end;

  TDNRSAPKCS1KeyExchangeDeformatter = class(TDNGenericImport<DNRSAPKCS1KeyExchangeDeformatterClass, DNRSAPKCS1KeyExchangeDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricKeyExchangeFormatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{FB6A3B81-78E5-5CF4-81DF-FB119EE7527B}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricKeyExchangeFormatter')]
  DNAsymmetricKeyExchangeFormatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7EC37267-CF47-3E22-BB67-835A05C2BCBD}']
  { getters & setters } 

    function get_Parameters: string;

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function CreateKeyExchange(data: TArray<Byte>): TArray<Byte>; overload;
    function CreateKeyExchange(data: TArray<Byte>; symAlgType: DDNC.System.Private.CoreLib.DNType): TArray<Byte>; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Parameters: string read get_Parameters;
  end;

  TDNAsymmetricKeyExchangeFormatter = class(TDNGenericImport<DNAsymmetricKeyExchangeFormatterClass, DNAsymmetricKeyExchangeFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAOAEPKeyExchangeFormatterClass = interface(DNAsymmetricKeyExchangeFormatterClass)
  ['{9D53B953-A646-5692-9C0A-59167253F85B}']
  { constructors } 

    {class} function init: DNRSAOAEPKeyExchangeFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAOAEPKeyExchangeFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAOAEPKeyExchangeFormatter')]
  DNRSAOAEPKeyExchangeFormatter = interface(DNAsymmetricKeyExchangeFormatter)
  ['{B50B0D06-360A-3201-8C6F-473AF75895CC}']
  { getters & setters } 

    function get_Parameter: TArray<Byte>;
    procedure set_Parameter(value: TArray<Byte>);
    function get_Parameters: string;
    function get_Rng: DNRandomNumberGenerator;
    procedure set_Rng(value: DNRandomNumberGenerator);

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function CreateKeyExchange(rgbData: TArray<Byte>; symAlgType: DDNC.System.Private.CoreLib.DNType): TArray<Byte>; overload;
    function CreateKeyExchange(rgbData: TArray<Byte>): TArray<Byte>; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Parameter: TArray<Byte> read get_Parameter write set_Parameter;
    property Parameters: string read get_Parameters;
    property Rng: DNRandomNumberGenerator read get_Rng write set_Rng;
  end;

  TDNRSAOAEPKeyExchangeFormatter = class(TDNGenericImport<DNRSAOAEPKeyExchangeFormatterClass, DNRSAOAEPKeyExchangeFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1KeyExchangeFormatterClass = interface(DNAsymmetricKeyExchangeFormatterClass)
  ['{D5078793-A3C4-5B75-B3A9-2C20C1FFE140}']
  { constructors } 

    {class} function init: DNRSAPKCS1KeyExchangeFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1KeyExchangeFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1KeyExchangeFormatter')]
  DNRSAPKCS1KeyExchangeFormatter = interface(DNAsymmetricKeyExchangeFormatter)
  ['{2A1F18C2-F7D8-31A2-988C-DC060777E342}']
  { getters & setters } 

    function get_Parameters: string;
    function get_Rng: DNRandomNumberGenerator;
    procedure set_Rng(value: DNRandomNumberGenerator);

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function CreateKeyExchange(rgbData: TArray<Byte>; symAlgType: DDNC.System.Private.CoreLib.DNType): TArray<Byte>; overload;
    function CreateKeyExchange(rgbData: TArray<Byte>): TArray<Byte>; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Parameters: string read get_Parameters;
    property Rng: DNRandomNumberGenerator read get_Rng write set_Rng;
  end;

  TDNRSAPKCS1KeyExchangeFormatter = class(TDNGenericImport<DNRSAPKCS1KeyExchangeFormatterClass, DNRSAPKCS1KeyExchangeFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricSignatureDeformatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{DBA34536-61C7-5F31-BA1B-356FBA14D613}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricSignatureDeformatter')]
  DNAsymmetricSignatureDeformatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4C264F0F-F10B-39CD-B069-31457DBC8B01}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function VerifySignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNAsymmetricSignatureDeformatter = class(TDNGenericImport<DNAsymmetricSignatureDeformatterClass, DNAsymmetricSignatureDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSASignatureDeformatterClass = interface(DNAsymmetricSignatureDeformatterClass)
  ['{2D62022A-B735-5657-B8CC-82C6608C4343}']
  { constructors } 

    {class} function init: DNDSASignatureDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNDSASignatureDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSASignatureDeformatter')]
  DNDSASignatureDeformatter = interface(DNAsymmetricSignatureDeformatter)
  ['{0C7FB819-6AC9-366E-9B4A-DE04FFFB3AE0}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm; rgbSignature: TArray<Byte>): Boolean; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNDSASignatureDeformatter = class(TDNGenericImport<DNDSASignatureDeformatterClass, DNDSASignatureDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1SignatureDeformatterClass = interface(DNAsymmetricSignatureDeformatterClass)
  ['{869E127F-D42B-5CE6-B63B-166EE7548954}']
  { constructors } 

    {class} function init: DNRSAPKCS1SignatureDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1SignatureDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1SignatureDeformatter')]
  DNRSAPKCS1SignatureDeformatter = interface(DNAsymmetricSignatureDeformatter)
  ['{E3C54E28-E707-3BE4-89B4-76319B4DFF48}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm; rgbSignature: TArray<Byte>): Boolean; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRSAPKCS1SignatureDeformatter = class(TDNGenericImport<DNRSAPKCS1SignatureDeformatterClass, DNRSAPKCS1SignatureDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricSignatureFormatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{736B5156-B266-53EC-B1E4-B8459BBAC2AF}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricSignatureFormatter')]
  DNAsymmetricSignatureFormatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{EB7EE3EF-A888-36CF-842A-0950728EB00A}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function CreateSignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm): TArray<Byte>; overload;
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNAsymmetricSignatureFormatter = class(TDNGenericImport<DNAsymmetricSignatureFormatterClass, DNAsymmetricSignatureFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSASignatureFormatterClass = interface(DNAsymmetricSignatureFormatterClass)
  ['{CBCBD8F0-47D6-5DAF-AC2A-F3690C5BCAD0}']
  { constructors } 

    {class} function init: DNDSASignatureFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNDSASignatureFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSASignatureFormatter')]
  DNDSASignatureFormatter = interface(DNAsymmetricSignatureFormatter)
  ['{555DFEA7-1069-3ADE-B24C-9131845060C0}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function CreateSignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm): TArray<Byte>; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNDSASignatureFormatter = class(TDNGenericImport<DNDSASignatureFormatterClass, DNDSASignatureFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1SignatureFormatterClass = interface(DNAsymmetricSignatureFormatterClass)
  ['{55B146E5-3CB9-5748-844E-7E4520A05568}']
  { constructors } 

    {class} function init: DNRSAPKCS1SignatureFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1SignatureFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1SignatureFormatter')]
  DNRSAPKCS1SignatureFormatter = interface(DNAsymmetricSignatureFormatter)
  ['{30109AE5-3DD7-32DE-A655-4B662EFF988F}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function CreateSignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm): TArray<Byte>; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRSAPKCS1SignatureFormatter = class(TDNGenericImport<DNRSAPKCS1SignatureFormatterClass, DNRSAPKCS1SignatureFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCryptoConfigClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{DCF66536-1EC8-5C24-8ACA-82FAB5138D15}']
  { static getter & setter } 

    {class} function get_AllowOnlyFipsAlgorithms: Boolean;

  { constructors } 

    {class} function init: DNCryptoConfig;

  { static methods } 

    {class} procedure AddAlgorithm(algorithm: DDNC.System.Private.CoreLib.DNType; names: TArray<string>);
    {class} function CreateFromName(name: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject; overload;
    {class} function CreateFromName(name: string): DDNC.System.Private.CoreLib.DNObject; overload;
    {class} procedure AddOID(oid: string; names: TArray<string>);
    {class} function MapNameToOID(name: string): string;
    {class} function EncodeOID(str: string): TArray<Byte>;

  { static propertys } 

    {class} property AllowOnlyFipsAlgorithms: Boolean read get_AllowOnlyFipsAlgorithms;
  end;

  [DNTypeName('System.Security.Cryptography.CryptoConfig')]
  DNCryptoConfig = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{80F808D8-C4F3-3A81-A1BB-A2FEA3B6B446}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNCryptoConfig = class(TDNGenericImport<DNCryptoConfigClass, DNCryptoConfig>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDeriveBytesClass = interface(DNObjectClass)
  ['{49EBB350-89F2-5CE5-A7F4-5617CB8E674F}']
  end;

  [DNTypeName('System.Security.Cryptography.DeriveBytes')]
  DNDeriveBytes = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{510C15D5-8E0C-34A6-9E9B-6AC898BCE003}']
  { methods } 

    function GetBytes(cb: Int32): TArray<Byte>;
    procedure Reset;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNDeriveBytes = class(TDNGenericImport<DNDeriveBytesClass, DNDeriveBytes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRfc2898DeriveBytesClass = interface(DNDeriveBytesClass)
  ['{FC7E920B-94E9-5B9A-8380-84E9A1CD5193}']
  { constructors } 

    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; iterations: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; iterations: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; salt: TArray<Byte>): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; salt: TArray<Byte>; iterations: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; salt: TArray<Byte>; iterations: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; saltSize: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; saltSize: Int32; iterations: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; saltSize: Int32; iterations: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRfc2898DeriveBytes; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Rfc2898DeriveBytes')]
  DNRfc2898DeriveBytes = interface(DNDeriveBytes)
  ['{E0551EBD-8C63-3327-837D-65843BDF2197}']
  { getters & setters } 

    function get_HashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;
    function get_IterationCount: Int32;
    procedure set_IterationCount(value: Int32);
    function get_Salt: TArray<Byte>;
    procedure set_Salt(value: TArray<Byte>);

  { methods } 

    function GetBytes(cb: Int32): TArray<Byte>;
    function CryptDeriveKey(algname: string; alghashname: string; keySize: Int32; rgbIV: TArray<Byte>): TArray<Byte>;
    procedure Reset;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_HashAlgorithm;
    property IterationCount: Int32 read get_IterationCount write set_IterationCount;
    property Salt: TArray<Byte> read get_Salt write set_Salt;
  end;

  TDNRfc2898DeriveBytes = class(TDNGenericImport<DNRfc2898DeriveBytesClass, DNRfc2898DeriveBytes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECCurve_NamedCurvesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7C7F7584-EEC6-5029-A453-58F2D8ECB1EF}']
  { static getter & setter } 

    {class} function get_brainpoolP160r1: DNECCurve;
    {class} function get_brainpoolP160t1: DNECCurve;
    {class} function get_brainpoolP192r1: DNECCurve;
    {class} function get_brainpoolP192t1: DNECCurve;
    {class} function get_brainpoolP224r1: DNECCurve;
    {class} function get_brainpoolP224t1: DNECCurve;
    {class} function get_brainpoolP256r1: DNECCurve;
    {class} function get_brainpoolP256t1: DNECCurve;
    {class} function get_brainpoolP320r1: DNECCurve;
    {class} function get_brainpoolP320t1: DNECCurve;
    {class} function get_brainpoolP384r1: DNECCurve;
    {class} function get_brainpoolP384t1: DNECCurve;
    {class} function get_brainpoolP512r1: DNECCurve;
    {class} function get_brainpoolP512t1: DNECCurve;
    {class} function get_nistP256: DNECCurve;
    {class} function get_nistP384: DNECCurve;
    {class} function get_nistP521: DNECCurve;

  { static propertys } 

    {class} property brainpoolP160r1: DNECCurve read get_brainpoolP160r1;
    {class} property brainpoolP160t1: DNECCurve read get_brainpoolP160t1;
    {class} property brainpoolP192r1: DNECCurve read get_brainpoolP192r1;
    {class} property brainpoolP192t1: DNECCurve read get_brainpoolP192t1;
    {class} property brainpoolP224r1: DNECCurve read get_brainpoolP224r1;
    {class} property brainpoolP224t1: DNECCurve read get_brainpoolP224t1;
    {class} property brainpoolP256r1: DNECCurve read get_brainpoolP256r1;
    {class} property brainpoolP256t1: DNECCurve read get_brainpoolP256t1;
    {class} property brainpoolP320r1: DNECCurve read get_brainpoolP320r1;
    {class} property brainpoolP320t1: DNECCurve read get_brainpoolP320t1;
    {class} property brainpoolP384r1: DNECCurve read get_brainpoolP384r1;
    {class} property brainpoolP384t1: DNECCurve read get_brainpoolP384t1;
    {class} property brainpoolP512r1: DNECCurve read get_brainpoolP512r1;
    {class} property brainpoolP512t1: DNECCurve read get_brainpoolP512t1;
    {class} property nistP256: DNECCurve read get_nistP256;
    {class} property nistP384: DNECCurve read get_nistP384;
    {class} property nistP521: DNECCurve read get_nistP521;
  end;

  [DNTypeName('System.Security.Cryptography.ECCurve+NamedCurves')]
  DNECCurve_NamedCurves = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9621A4C4-AFD8-3084-AECC-2EE0AB74F806}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNECCurve_NamedCurves = class(TDNGenericImport<DNECCurve_NamedCurvesClass, DNECCurve_NamedCurves>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanPublicKeyClass = interface(DNObjectClass)
  ['{77222558-68E8-5F29-9C15-D572A5F7790D}']
  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanPublicKey')]
  DNECDiffieHellmanPublicKey = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{670C23A8-A083-3CAB-A7E6-363DA6260A96}']
  { methods } 

    procedure Dispose;
    function ToByteArray: TArray<Byte>;
    function ToXmlString: string;
    function ExportParameters: DNECParameters;
    function ExportExplicitParameters: DNECParameters;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNECDiffieHellmanPublicKey = class(TDNGenericImport<DNECDiffieHellmanPublicKeyClass, DNECDiffieHellmanPublicKey>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACMD5Class = interface(DNObjectClass)
  ['{F8D78684-A27C-51C3-8646-7FA51606C022}']
  { constructors } 

    {class} function init: DNHMACMD5; overload;
    {class} function init(key: TArray<Byte>): DNHMACMD5; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACMD5')]
  DNHMACMD5 = interface(DNObject)
  ['{AE340A05-D382-3D53-88B4-C0EB36A0276D}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACMD5 = class(TDNGenericImport<DNHMACMD5Class, DNHMACMD5>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA1Class = interface(DNObjectClass)
  ['{D0ED5CC6-82A0-5BEF-B871-2BEF30837437}']
  { constructors } 

    {class} function init: DNHMACSHA1; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA1; overload;
    {class} function init(key: TArray<Byte>; useManagedSha1: Boolean): DNHMACSHA1; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA1')]
  DNHMACSHA1 = interface(DNObject)
  ['{CA76A146-7811-33CA-AFCF-E3722E705493}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA1 = class(TDNGenericImport<DNHMACSHA1Class, DNHMACSHA1>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA256Class = interface(DNObjectClass)
  ['{88253749-C558-5B9B-BB42-855FADAEDE7F}']
  { constructors } 

    {class} function init: DNHMACSHA256; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA256; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA256')]
  DNHMACSHA256 = interface(DNObject)
  ['{2BCB1899-6045-3FF3-8EE3-97D7C7C0BE92}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA256 = class(TDNGenericImport<DNHMACSHA256Class, DNHMACSHA256>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA384Class = interface(DNObjectClass)
  ['{14D6073B-0FDD-55EE-BFCE-B0204E062A1E}']
  { constructors } 

    {class} function init: DNHMACSHA384; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA384; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA384')]
  DNHMACSHA384 = interface(DNObject)
  ['{8E5698BC-A554-309B-8DF6-66F6213E00A3}']
  { getters & setters } 

    function get_ProduceLegacyHmacValues: Boolean;
    procedure set_ProduceLegacyHmacValues(value: Boolean);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ProduceLegacyHmacValues: Boolean read get_ProduceLegacyHmacValues write set_ProduceLegacyHmacValues;
    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA384 = class(TDNGenericImport<DNHMACSHA384Class, DNHMACSHA384>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA512Class = interface(DNObjectClass)
  ['{7D397CFA-7BDB-5F38-92A4-0439B8FE3D53}']
  { constructors } 

    {class} function init: DNHMACSHA512; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA512; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA512')]
  DNHMACSHA512 = interface(DNObject)
  ['{7F8231C1-F6C2-380A-85AA-5C2F9A883AEB}']
  { getters & setters } 

    function get_ProduceLegacyHmacValues: Boolean;
    procedure set_ProduceLegacyHmacValues(value: Boolean);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ProduceLegacyHmacValues: Boolean read get_ProduceLegacyHmacValues write set_ProduceLegacyHmacValues;
    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA512 = class(TDNGenericImport<DNHMACSHA512Class, DNHMACSHA512>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNMD5Class = interface(DNObjectClass)
  ['{8AB0ACAE-268A-5BEC-9A05-A53C7AB04CDC}']
  { static methods } 

    {class} function Create: DNMD5; overload;
    {class} function Create(algName: string): DNMD5; overload;

  end;

  [DNTypeName('System.Security.Cryptography.MD5')]
  DNMD5 = interface(DNObject)
  ['{2A767F7D-553F-3B80-9DE5-9E3BED5FFBD5}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNMD5 = class(TDNGenericImport<DNMD5Class, DNMD5>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA1Class = interface(DNObjectClass)
  ['{160853BA-27BD-5B5E-B1F8-5E74D9E9D73F}']
  { static methods } 

    {class} function Create: DNSHA1; overload;
    {class} function Create(hashName: string): DNSHA1; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SHA1')]
  DNSHA1 = interface(DNObject)
  ['{5DF0F4A5-EEDB-3FF8-BC0F-3AD0B2A83DED}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA1 = class(TDNGenericImport<DNSHA1Class, DNSHA1>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA1ManagedClass = interface(DNSHA1Class)
  ['{24D1FABA-374E-5A54-9771-32EBF99E7FE6}']
  { constructors } 

    {class} function init: DNSHA1Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA1Managed')]
  DNSHA1Managed = interface(DNSHA1)
  ['{6D095B7E-F17D-3DA9-9D26-73BDE4EDF23B}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA1Managed = class(TDNGenericImport<DNSHA1ManagedClass, DNSHA1Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA256Class = interface(DNObjectClass)
  ['{69200C35-F841-5A00-9C7E-55C8FAFB9459}']
  { static methods } 

    {class} function Create: DNSHA256; overload;
    {class} function Create(hashName: string): DNSHA256; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SHA256')]
  DNSHA256 = interface(DNObject)
  ['{C26E43FB-9BE8-316E-A051-3B797125CE06}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA256 = class(TDNGenericImport<DNSHA256Class, DNSHA256>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA256ManagedClass = interface(DNSHA256Class)
  ['{DEB79ADB-915B-5404-85D5-D8C200099C5D}']
  { constructors } 

    {class} function init: DNSHA256Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA256Managed')]
  DNSHA256Managed = interface(DNSHA256)
  ['{9D7B1176-1352-3A41-B053-F8FFF1CC7C5F}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA256Managed = class(TDNGenericImport<DNSHA256ManagedClass, DNSHA256Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA384Class = interface(DNObjectClass)
  ['{60BF9D1A-83D3-513C-B066-309D965EF209}']
  { static methods } 

    {class} function Create: DNSHA384; overload;
    {class} function Create(hashName: string): DNSHA384; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SHA384')]
  DNSHA384 = interface(DNObject)
  ['{09B472DE-A3D9-3C61-BD2E-3D8AB0B69E11}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA384 = class(TDNGenericImport<DNSHA384Class, DNSHA384>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA384ManagedClass = interface(DNSHA384Class)
  ['{C52D77EB-A7A8-544F-8855-DE69798D5EF6}']
  { constructors } 

    {class} function init: DNSHA384Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA384Managed')]
  DNSHA384Managed = interface(DNSHA384)
  ['{7B113EF3-E520-33B0-9235-10B9F98F7875}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA384Managed = class(TDNGenericImport<DNSHA384ManagedClass, DNSHA384Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA512Class = interface(DNObjectClass)
  ['{3CCDB36B-6418-5832-B39A-9EB748F203BA}']
  { static methods } 

    {class} function Create: DNSHA512; overload;
    {class} function Create(hashName: string): DNSHA512; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SHA512')]
  DNSHA512 = interface(DNObject)
  ['{FC710B5A-5D9E-39DB-ADF9-91B99BF0B689}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA512 = class(TDNGenericImport<DNSHA512Class, DNSHA512>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA512ManagedClass = interface(DNSHA512Class)
  ['{AD5EFD51-1F93-5B7C-A73F-581F0AE9C59A}']
  { constructors } 

    {class} function init: DNSHA512Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA512Managed')]
  DNSHA512Managed = interface(DNSHA512)
  ['{D740A875-2C03-3200-A172-6EBAC27A3336}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA512Managed = class(TDNGenericImport<DNSHA512ManagedClass, DNSHA512Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNIncrementalHashClass = interface(DNObjectClass)
  ['{09535028-CC5C-53AF-BAD0-7AB11CE2FDFC}']
  { static methods } 

    {class} function CreateHash(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNIncrementalHash;
    {class} function CreateHMAC(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; key: TArray<Byte>): DNIncrementalHash;

  end;

  [DNTypeName('System.Security.Cryptography.IncrementalHash')]
  DNIncrementalHash = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{301E3156-666F-317C-B082-18EF4E838E27}']
  { getters & setters } 

    function get_AlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;

  { methods } 

    procedure AppendData(data: TArray<Byte>); overload;
    procedure AppendData(data: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure AppendData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    function GetHashAndReset: TArray<Byte>;
    function TryGetHashAndReset(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_AlgorithmName;
  end;

  TDNIncrementalHash = class(TDNGenericImport<DNIncrementalHashClass, DNIncrementalHash>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNMaskGenerationMethodClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{2C6D3D91-41EC-5FF3-8FC9-DBA7F88B6B01}']
  end;

  [DNTypeName('System.Security.Cryptography.MaskGenerationMethod')]
  DNMaskGenerationMethod = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B14004B2-4F43-32B0-96C4-5A0B48C69E6C}']
  { methods } 

    function GenerateMask(rgbSeed: TArray<Byte>; cbReturn: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNMaskGenerationMethod = class(TDNGenericImport<DNMaskGenerationMethodClass, DNMaskGenerationMethod>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNPKCS1MaskGenerationMethodClass = interface(DNMaskGenerationMethodClass)
  ['{9039F1A9-C7AA-5E7A-A99F-8D13C2EC2A0E}']
  { constructors } 

    {class} function init: DNPKCS1MaskGenerationMethod;

  end;

  [DNTypeName('System.Security.Cryptography.PKCS1MaskGenerationMethod')]
  DNPKCS1MaskGenerationMethod = interface(DNMaskGenerationMethod)
  ['{6D6A1BA3-B745-3A28-8A47-08615BBC0D00}']
  { getters & setters } 

    function get_HashName: string;
    procedure set_HashName(value: string);

  { methods } 

    function GenerateMask(rgbSeed: TArray<Byte>; cbReturn: Int32): TArray<Byte>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property HashName: string read get_HashName write set_HashName;
  end;

  TDNPKCS1MaskGenerationMethod = class(TDNGenericImport<DNPKCS1MaskGenerationMethodClass, DNPKCS1MaskGenerationMethod>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRandomNumberGeneratorClass = interface(DNObjectClass)
  ['{4F138F9A-9744-54DC-ABAC-2DA77CA26F47}']
  { static methods } 

    {class} function Create: DNRandomNumberGenerator; overload;
    {class} function Create(rngName: string): DNRandomNumberGenerator; overload;
    {class} procedure Fill(data: DDNC.System.Private.CoreLib.DNSpan<Byte>);

  end;

  [DNTypeName('System.Security.Cryptography.RandomNumberGenerator')]
  DNRandomNumberGenerator = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{216510A6-145B-3EA8-AD8E-89970BF0E07F}']
  { methods } 

    procedure Dispose;
    procedure GetBytes(data: TArray<Byte>); overload;
    procedure GetBytes(data: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure GetBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    procedure GetNonZeroBytes(data: TArray<Byte>); overload;
    procedure GetNonZeroBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRandomNumberGenerator = class(TDNGenericImport<DNRandomNumberGeneratorClass, DNRandomNumberGenerator>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAEncryptionPaddingClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{60CF9636-3C11-5E90-ABC8-E271795D38E9}']
  { static getter & setter } 

    {class} function get_Pkcs1: DNRSAEncryptionPadding;
    {class} function get_OaepSHA1: DNRSAEncryptionPadding;
    {class} function get_OaepSHA256: DNRSAEncryptionPadding;
    {class} function get_OaepSHA384: DNRSAEncryptionPadding;
    {class} function get_OaepSHA512: DNRSAEncryptionPadding;

  { static methods } 

    {class} function CreateOaep(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRSAEncryptionPadding;

  { static propertys } 

    {class} property Pkcs1: DNRSAEncryptionPadding read get_Pkcs1;
    {class} property OaepSHA1: DNRSAEncryptionPadding read get_OaepSHA1;
    {class} property OaepSHA256: DNRSAEncryptionPadding read get_OaepSHA256;
    {class} property OaepSHA384: DNRSAEncryptionPadding read get_OaepSHA384;
    {class} property OaepSHA512: DNRSAEncryptionPadding read get_OaepSHA512;
  end;

  [DNTypeName('System.Security.Cryptography.RSAEncryptionPadding')]
  DNRSAEncryptionPadding = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3613258C-2B45-3078-9D0E-631F66F5D5B3}']
  { getters & setters } 

    function get_Mode: DNRSAEncryptionPaddingMode;
    function get_OaepHashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNRSAEncryptionPadding): Boolean; overload;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Mode: DNRSAEncryptionPaddingMode read get_Mode;
    property OaepHashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_OaepHashAlgorithm;
  end;

  TDNRSAEncryptionPadding = class(TDNGenericImport<DNRSAEncryptionPaddingClass, DNRSAEncryptionPadding>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSASignaturePaddingClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{D07F43F3-57B9-5B9E-A3DF-8CA3A4FCE9E6}']
  { static getter & setter } 

    {class} function get_Pkcs1: DNRSASignaturePadding;
    {class} function get_Pss: DNRSASignaturePadding;

  { static propertys } 

    {class} property Pkcs1: DNRSASignaturePadding read get_Pkcs1;
    {class} property Pss: DNRSASignaturePadding read get_Pss;
  end;

  [DNTypeName('System.Security.Cryptography.RSASignaturePadding')]
  DNRSASignaturePadding = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4F8EBA15-28BF-335D-BFE4-98F568E9DAC9}']
  { getters & setters } 

    function get_Mode: DNRSASignaturePaddingMode;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNRSASignaturePadding): Boolean; overload;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Mode: DNRSASignaturePaddingMode read get_Mode;
  end;

  TDNRSASignaturePadding = class(TDNGenericImport<DNRSASignaturePaddingClass, DNRSASignaturePadding>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSignatureDescriptionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7FE6BF71-EE6D-5EAA-94AC-C10F9A688326}']
  { constructors } 

    {class} function init: DNSignatureDescription; overload;
    {class} function init(el: DDNC.System.Runtime.Extensions.DNSecurityElement): DNSignatureDescription; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SignatureDescription')]
  DNSignatureDescription = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{AF92479A-8D9E-3384-81D0-C162980C75EE}']
  { getters & setters } 

    function get_KeyAlgorithm: string;
    procedure set_KeyAlgorithm(value: string);
    function get_DigestAlgorithm: string;
    procedure set_DigestAlgorithm(value: string);
    function get_FormatterAlgorithm: string;
    procedure set_FormatterAlgorithm(value: string);
    function get_DeformatterAlgorithm: string;
    procedure set_DeformatterAlgorithm(value: string);

  { methods } 

    function CreateDeformatter(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNAsymmetricSignatureDeformatter;
    function CreateFormatter(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNAsymmetricSignatureFormatter;
    function CreateDigest: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property KeyAlgorithm: string read get_KeyAlgorithm write set_KeyAlgorithm;
    property DigestAlgorithm: string read get_DigestAlgorithm write set_DigestAlgorithm;
    property FormatterAlgorithm: string read get_FormatterAlgorithm write set_FormatterAlgorithm;
    property DeformatterAlgorithm: string read get_DeformatterAlgorithm write set_DeformatterAlgorithm;
  end;

  TDNSignatureDescription = class(TDNGenericImport<DNSignatureDescriptionClass, DNSignatureDescription>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesClass = interface(DNObjectClass)
  ['{941CD78B-A2DD-5E81-B458-33DF108E75AA}']
  { static methods } 

    {class} function Create: DNAes; overload;
    {class} function Create(algorithmName: string): DNAes; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Aes')]
  DNAes = interface(DNObject)
  ['{CC7072C9-A47B-3E00-ABEA-4100BE94CB2F}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNAes = class(TDNGenericImport<DNAesClass, DNAes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesManagedClass = interface(DNAesClass)
  ['{07E419CA-E6DD-5576-BE7E-6F3E3FEF3702}']
  { constructors } 

    {class} function init: DNAesManaged;

  end;

  [DNTypeName('System.Security.Cryptography.AesManaged')]
  DNAesManaged = interface(DNAes)
  ['{47E922B8-30E5-3644-A6BD-2980045A0303}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNAesManaged = class(TDNGenericImport<DNAesManagedClass, DNAesManaged>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDESClass = interface(DNObjectClass)
  ['{3D6A1F14-99F9-5D3F-9F91-8F1D933E4CCB}']
  { static methods } 

    {class} function Create: DNDES; overload;
    {class} function Create(algName: string): DNDES; overload;
    {class} function IsWeakKey(rgbKey: TArray<Byte>): Boolean;
    {class} function IsSemiWeakKey(rgbKey: TArray<Byte>): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.DES')]
  DNDES = interface(DNObject)
  ['{067D05F0-0441-33BD-9104-5A20A951A5CD}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNDES = class(TDNGenericImport<DNDESClass, DNDES>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRC2Class = interface(DNObjectClass)
  ['{AEBDA168-E08C-529D-8D8F-3E67F3B64AF3}']
  { static methods } 

    {class} function Create: DNRC2; overload;
    {class} function Create(AlgName: string): DNRC2; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RC2')]
  DNRC2 = interface(DNObject)
  ['{B8E71CBE-D686-3814-9D66-1E32A5938388}']
  { getters & setters } 

    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_EffectiveKeySize: Int32;
    procedure set_EffectiveKeySize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property KeySize: Int32 read get_KeySize write set_KeySize;
    property EffectiveKeySize: Int32 read get_EffectiveKeySize write set_EffectiveKeySize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNRC2 = class(TDNGenericImport<DNRC2Class, DNRC2>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRijndaelClass = interface(DNObjectClass)
  ['{A9A4902F-3D59-54B1-97E1-12D7F4C7C9DE}']
  { static methods } 

    {class} function Create: DNRijndael; overload;
    {class} function Create(algName: string): DNRijndael; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Rijndael')]
  DNRijndael = interface(DNObject)
  ['{51CBAF0F-BF44-35E8-B1B5-DC362144D8EE}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNRijndael = class(TDNGenericImport<DNRijndaelClass, DNRijndael>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRijndaelManagedClass = interface(DNRijndaelClass)
  ['{C6CB3E4A-9A6C-506C-82C3-A6543174D135}']
  { constructors } 

    {class} function init: DNRijndaelManaged;

  end;

  [DNTypeName('System.Security.Cryptography.RijndaelManaged')]
  DNRijndaelManaged = interface(DNRijndael)
  ['{56FE6331-5981-397C-B6C0-295635646412}']
  { getters & setters } 

    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
  end;

  TDNRijndaelManaged = class(TDNGenericImport<DNRijndaelManagedClass, DNRijndaelManaged>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNTripleDESClass = interface(DNObjectClass)
  ['{94313D72-FBAE-5F25-A232-134BA13143DB}']
  { static methods } 

    {class} function Create: DNTripleDES; overload;
    {class} function Create(str: string): DNTripleDES; overload;
    {class} function IsWeakKey(rgbKey: TArray<Byte>): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.TripleDES')]
  DNTripleDES = interface(DNObject)
  ['{B497983F-73BF-3096-9F75-74ABCC715314}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNTripleDES = class(TDNGenericImport<DNTripleDESClass, DNTripleDES>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSAParametersClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{D965B27F-EC8F-5A59-BC2E-EAA75AF1C11F}']
  end;

  [DNTypeName('System.Security.Cryptography.DSAParameters')]
  DNDSAParameters = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{A5238D25-424F-30B6-B98B-03D3617E0AE3}']
  { fields getter & setter } 

   function __fakeFieldGet_P: TArray<Byte>;
   procedure __fakeFieldSet_P(value: TArray<Byte>);
   function __fakeFieldGet_Q: TArray<Byte>;
   procedure __fakeFieldSet_Q(value: TArray<Byte>);
   function __fakeFieldGet_G: TArray<Byte>;
   procedure __fakeFieldSet_G(value: TArray<Byte>);
   function __fakeFieldGet_Y: TArray<Byte>;
   procedure __fakeFieldSet_Y(value: TArray<Byte>);
   function __fakeFieldGet_J: TArray<Byte>;
   procedure __fakeFieldSet_J(value: TArray<Byte>);
   function __fakeFieldGet_X: TArray<Byte>;
   procedure __fakeFieldSet_X(value: TArray<Byte>);
   function __fakeFieldGet_Seed: TArray<Byte>;
   procedure __fakeFieldSet_Seed(value: TArray<Byte>);
   function __fakeFieldGet_Counter: Int32;
   procedure __fakeFieldSet_Counter(value: Int32);

  { fields } 

   property P: TArray<Byte> read __fakeFieldGet_P write __fakeFieldSet_P;
   property Q: TArray<Byte> read __fakeFieldGet_Q write __fakeFieldSet_Q;
   property G: TArray<Byte> read __fakeFieldGet_G write __fakeFieldSet_G;
   property Y: TArray<Byte> read __fakeFieldGet_Y write __fakeFieldSet_Y;
   property J: TArray<Byte> read __fakeFieldGet_J write __fakeFieldSet_J;
   property X: TArray<Byte> read __fakeFieldGet_X write __fakeFieldSet_X;
   property Seed: TArray<Byte> read __fakeFieldGet_Seed write __fakeFieldSet_Seed;
   property Counter: Int32 read __fakeFieldGet_Counter write __fakeFieldSet_Counter;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNDSAParameters = class(TDNGenericImport<DNDSAParametersClass, DNDSAParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECCurveClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{15864AE3-6086-5F93-A810-5BC20896F744}']
  { static methods } 

    {class} function CreateFromOid(curveOid: DDNC.System.Security.Cryptography.Encoding.DNOid): DNECCurve;
    {class} function CreateFromFriendlyName(oidFriendlyName: string): DNECCurve;
    {class} function CreateFromValue(oidValue: string): DNECCurve;

  end;

  [DNTypeName('System.Security.Cryptography.ECCurve')]
  DNECCurve = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{CBC9D0BF-A1EB-3E8C-B02E-44181F5C2124}']
  { getters & setters } 

    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;
    function get_IsPrime: Boolean;
    function get_IsCharacteristic2: Boolean;
    function get_IsExplicit: Boolean;
    function get_IsNamed: Boolean;

  { fields getter & setter } 

   function __fakeFieldGet_A: TArray<Byte>;
   procedure __fakeFieldSet_A(value: TArray<Byte>);
   function __fakeFieldGet_B: TArray<Byte>;
   procedure __fakeFieldSet_B(value: TArray<Byte>);
   function __fakeFieldGet_G: DNECPoint;
   procedure __fakeFieldSet_G(value: DNECPoint);
   function __fakeFieldGet_Order: TArray<Byte>;
   procedure __fakeFieldSet_Order(value: TArray<Byte>);
   function __fakeFieldGet_Cofactor: TArray<Byte>;
   procedure __fakeFieldSet_Cofactor(value: TArray<Byte>);
   function __fakeFieldGet_Seed: TArray<Byte>;
   procedure __fakeFieldSet_Seed(value: TArray<Byte>);
   function __fakeFieldGet_CurveType: DNECCurve_ECCurveType;
   procedure __fakeFieldSet_CurveType(value: DNECCurve_ECCurveType);
   function __fakeFieldGet_Hash: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName>;
   procedure __fakeFieldSet_Hash(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName>);
   function __fakeFieldGet_Polynomial: TArray<Byte>;
   procedure __fakeFieldSet_Polynomial(value: TArray<Byte>);
   function __fakeFieldGet_Prime: TArray<Byte>;
   procedure __fakeFieldSet_Prime(value: TArray<Byte>);

  { fields } 

   property A: TArray<Byte> read __fakeFieldGet_A write __fakeFieldSet_A;
   property B: TArray<Byte> read __fakeFieldGet_B write __fakeFieldSet_B;
   property G: DNECPoint read __fakeFieldGet_G write __fakeFieldSet_G;
   property Order: TArray<Byte> read __fakeFieldGet_Order write __fakeFieldSet_Order;
   property Cofactor: TArray<Byte> read __fakeFieldGet_Cofactor write __fakeFieldSet_Cofactor;
   property Seed: TArray<Byte> read __fakeFieldGet_Seed write __fakeFieldSet_Seed;
   property CurveType: DNECCurve_ECCurveType read __fakeFieldGet_CurveType write __fakeFieldSet_CurveType;
   property Hash: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName> read __fakeFieldGet_Hash write __fakeFieldSet_Hash;
   property Polynomial: TArray<Byte> read __fakeFieldGet_Polynomial write __fakeFieldSet_Polynomial;
   property Prime: TArray<Byte> read __fakeFieldGet_Prime write __fakeFieldSet_Prime;

  { methods } 

    procedure Validate;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid;
    property IsPrime: Boolean read get_IsPrime;
    property IsCharacteristic2: Boolean read get_IsCharacteristic2;
    property IsExplicit: Boolean read get_IsExplicit;
    property IsNamed: Boolean read get_IsNamed;
  end;

  TDNECCurve = class(TDNGenericImport<DNECCurveClass, DNECCurve>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECParametersClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{48B16469-6A23-5B44-8AB7-D95357BE1505}']
  end;

  [DNTypeName('System.Security.Cryptography.ECParameters')]
  DNECParameters = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{0D3D7DAE-1654-3E5D-A04B-FCD575368CC6}']
  { fields getter & setter } 

   function __fakeFieldGet_Q: DNECPoint;
   procedure __fakeFieldSet_Q(value: DNECPoint);
   function __fakeFieldGet_D: TArray<Byte>;
   procedure __fakeFieldSet_D(value: TArray<Byte>);
   function __fakeFieldGet_Curve: DNECCurve;
   procedure __fakeFieldSet_Curve(value: DNECCurve);

  { fields } 

   property Q: DNECPoint read __fakeFieldGet_Q write __fakeFieldSet_Q;
   property D: TArray<Byte> read __fakeFieldGet_D write __fakeFieldSet_D;
   property Curve: DNECCurve read __fakeFieldGet_Curve write __fakeFieldSet_Curve;

  { methods } 

    procedure Validate;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNECParameters = class(TDNGenericImport<DNECParametersClass, DNECParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECPointClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{2DADDFCA-EF42-514D-851A-0E0F9AA2DC94}']
  end;

  [DNTypeName('System.Security.Cryptography.ECPoint')]
  DNECPoint = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{ADECAE79-E19D-3EDA-81F0-ACC6ADD75C79}']
  { fields getter & setter } 

   function __fakeFieldGet_X: TArray<Byte>;
   procedure __fakeFieldSet_X(value: TArray<Byte>);
   function __fakeFieldGet_Y: TArray<Byte>;
   procedure __fakeFieldSet_Y(value: TArray<Byte>);

  { fields } 

   property X: TArray<Byte> read __fakeFieldGet_X write __fakeFieldSet_X;
   property Y: TArray<Byte> read __fakeFieldGet_Y write __fakeFieldSet_Y;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNECPoint = class(TDNGenericImport<DNECPointClass, DNECPoint>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAParametersClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{01AC6319-D3EB-5ABB-B0CD-7093F7FDC7CD}']
  end;

  [DNTypeName('System.Security.Cryptography.RSAParameters')]
  DNRSAParameters = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{3F3B0806-8ACE-3266-BF5E-C5F9834933C3}']
  { fields getter & setter } 

   function __fakeFieldGet_D: TArray<Byte>;
   procedure __fakeFieldSet_D(value: TArray<Byte>);
   function __fakeFieldGet_DP: TArray<Byte>;
   procedure __fakeFieldSet_DP(value: TArray<Byte>);
   function __fakeFieldGet_DQ: TArray<Byte>;
   procedure __fakeFieldSet_DQ(value: TArray<Byte>);
   function __fakeFieldGet_Exponent: TArray<Byte>;
   procedure __fakeFieldSet_Exponent(value: TArray<Byte>);
   function __fakeFieldGet_InverseQ: TArray<Byte>;
   procedure __fakeFieldSet_InverseQ(value: TArray<Byte>);
   function __fakeFieldGet_Modulus: TArray<Byte>;
   procedure __fakeFieldSet_Modulus(value: TArray<Byte>);
   function __fakeFieldGet_P: TArray<Byte>;
   procedure __fakeFieldSet_P(value: TArray<Byte>);
   function __fakeFieldGet_Q: TArray<Byte>;
   procedure __fakeFieldSet_Q(value: TArray<Byte>);

  { fields } 

   property D: TArray<Byte> read __fakeFieldGet_D write __fakeFieldSet_D;
   property DP: TArray<Byte> read __fakeFieldGet_DP write __fakeFieldSet_DP;
   property DQ: TArray<Byte> read __fakeFieldGet_DQ write __fakeFieldSet_DQ;
   property Exponent: TArray<Byte> read __fakeFieldGet_Exponent write __fakeFieldSet_Exponent;
   property InverseQ: TArray<Byte> read __fakeFieldGet_InverseQ write __fakeFieldSet_InverseQ;
   property Modulus: TArray<Byte> read __fakeFieldGet_Modulus write __fakeFieldSet_Modulus;
   property P: TArray<Byte> read __fakeFieldGet_P write __fakeFieldSet_P;
   property Q: TArray<Byte> read __fakeFieldGet_Q write __fakeFieldSet_Q;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRSAParameters = class(TDNGenericImport<DNRSAParametersClass, DNRSAParameters>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.Algorithms, Version=4.3.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
