//----------------------------------------------------------------------------
//  System.Numerics.Vectors.dll: System.Numerics.Vectors, Version=4.1.4.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Numerics.Vectors
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Numerics.Vectors;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type


{ declares }

  DNMatrix3x2 = interface; // type: System.Numerics.Matrix3x2, namespace: System.Numerics
  DNMatrix4x4 = interface; // type: System.Numerics.Matrix4x4, namespace: System.Numerics
  DNPlane = interface; // type: System.Numerics.Plane, namespace: System.Numerics
  DNQuaternion = interface; // type: System.Numerics.Quaternion, namespace: System.Numerics
  DNVector2 = interface; // type: System.Numerics.Vector2, namespace: System.Numerics
  DNVector3 = interface; // type: System.Numerics.Vector3, namespace: System.Numerics
  DNVector4 = interface; // type: System.Numerics.Vector4, namespace: System.Numerics


{ objects }

  //-------------namespace: System.Numerics----------------
  DNMatrix3x2Class = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{66F4522C-E2EF-5B38-A917-F45D4DCA269B}']
  { static getter & setter } 

    {class} function get_Identity: DNMatrix3x2;

  { constructors } 

    {class} function init(m11: Single; m12: Single; m21: Single; m22: Single; m31: Single; m32: Single): DNMatrix3x2;

  { static methods } 

    {class} function CreateTranslation(position: DNVector2): DNMatrix3x2; overload;
    {class} function CreateTranslation(xPosition: Single; yPosition: Single): DNMatrix3x2; overload;
    {class} function CreateScale(xScale: Single; yScale: Single): DNMatrix3x2; overload;
    {class} function CreateScale(xScale: Single; yScale: Single; centerPoint: DNVector2): DNMatrix3x2; overload;
    {class} function CreateScale(scales: DNVector2): DNMatrix3x2; overload;
    {class} function CreateScale(scales: DNVector2; centerPoint: DNVector2): DNMatrix3x2; overload;
    {class} function CreateScale(scale: Single): DNMatrix3x2; overload;
    {class} function CreateScale(scale: Single; centerPoint: DNVector2): DNMatrix3x2; overload;
    {class} function CreateSkew(radiansX: Single; radiansY: Single): DNMatrix3x2; overload;
    {class} function CreateSkew(radiansX: Single; radiansY: Single; centerPoint: DNVector2): DNMatrix3x2; overload;
    {class} function CreateRotation(radians: Single): DNMatrix3x2; overload;
    {class} function CreateRotation(radians: Single; centerPoint: DNVector2): DNMatrix3x2; overload;
    {class} function Invert(matrix: DNMatrix3x2; out result: DNMatrix3x2): Boolean;
    {class} function Lerp(matrix1: DNMatrix3x2; matrix2: DNMatrix3x2; amount: Single): DNMatrix3x2;
    {class} function Negate(value: DNMatrix3x2): DNMatrix3x2;
    {class} function Add(value1: DNMatrix3x2; value2: DNMatrix3x2): DNMatrix3x2;
    {class} function Subtract(value1: DNMatrix3x2; value2: DNMatrix3x2): DNMatrix3x2;
    {class} function Multiply(value1: DNMatrix3x2; value2: DNMatrix3x2): DNMatrix3x2; overload;
    {class} function Multiply(value1: DNMatrix3x2; value2: Single): DNMatrix3x2; overload;

  { static propertys } 

    {class} property Identity: DNMatrix3x2 read get_Identity;
  end;

  [DNTypeName('System.Numerics.Matrix3x2')]
  DNMatrix3x2 = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{7E8A892F-BD9B-3A8F-BA3E-B46E2EA527C6}']
  { getters & setters } 

    function get_IsIdentity: Boolean;
    function get_Translation: DNVector2;
    procedure set_Translation(value: DNVector2);

  { fields getter & setter } 

   function __fakeFieldGet_M11: Single;
   procedure __fakeFieldSet_M11(value: Single);
   function __fakeFieldGet_M12: Single;
   procedure __fakeFieldSet_M12(value: Single);
   function __fakeFieldGet_M21: Single;
   procedure __fakeFieldSet_M21(value: Single);
   function __fakeFieldGet_M22: Single;
   procedure __fakeFieldSet_M22(value: Single);
   function __fakeFieldGet_M31: Single;
   procedure __fakeFieldSet_M31(value: Single);
   function __fakeFieldGet_M32: Single;
   procedure __fakeFieldSet_M32(value: Single);

  { fields } 

   property M11: Single read __fakeFieldGet_M11 write __fakeFieldSet_M11;
   property M12: Single read __fakeFieldGet_M12 write __fakeFieldSet_M12;
   property M21: Single read __fakeFieldGet_M21 write __fakeFieldSet_M21;
   property M22: Single read __fakeFieldGet_M22 write __fakeFieldSet_M22;
   property M31: Single read __fakeFieldGet_M31 write __fakeFieldSet_M31;
   property M32: Single read __fakeFieldGet_M32 write __fakeFieldSet_M32;

  { methods } 

    function GetDeterminant: Single;
    function Equals(other: DNMatrix3x2): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function ToString: string;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsIdentity: Boolean read get_IsIdentity;
    property Translation: DNVector2 read get_Translation write set_Translation;
  end;

  TDNMatrix3x2 = class(TDNGenericImport<DNMatrix3x2Class, DNMatrix3x2>) end;

  //-------------namespace: System.Numerics----------------
  DNMatrix4x4Class = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{F6A11DE9-4E95-58D2-AFBD-A780A5870E52}']
  { static getter & setter } 

    {class} function get_Identity: DNMatrix4x4;

  { constructors } 

    {class} function init(m11: Single; m12: Single; m13: Single; m14: Single; m21: Single; m22: Single; m23: Single; m24: Single; m31: Single; m32: Single; m33: Single; m34: Single; m41: Single; m42: Single; m43: Single; m44: Single): DNMatrix4x4; overload;
    {class} function init(value: DNMatrix3x2): DNMatrix4x4; overload;

  { static methods } 

    {class} function CreateBillboard(objectPosition: DNVector3; cameraPosition: DNVector3; cameraUpVector: DNVector3; cameraForwardVector: DNVector3): DNMatrix4x4;
    {class} function CreateConstrainedBillboard(objectPosition: DNVector3; cameraPosition: DNVector3; rotateAxis: DNVector3; cameraForwardVector: DNVector3; objectForwardVector: DNVector3): DNMatrix4x4;
    {class} function CreateTranslation(position: DNVector3): DNMatrix4x4; overload;
    {class} function CreateTranslation(xPosition: Single; yPosition: Single; zPosition: Single): DNMatrix4x4; overload;
    {class} function CreateScale(xScale: Single; yScale: Single; zScale: Single): DNMatrix4x4; overload;
    {class} function CreateScale(xScale: Single; yScale: Single; zScale: Single; centerPoint: DNVector3): DNMatrix4x4; overload;
    {class} function CreateScale(scales: DNVector3): DNMatrix4x4; overload;
    {class} function CreateScale(scales: DNVector3; centerPoint: DNVector3): DNMatrix4x4; overload;
    {class} function CreateScale(scale: Single): DNMatrix4x4; overload;
    {class} function CreateScale(scale: Single; centerPoint: DNVector3): DNMatrix4x4; overload;
    {class} function CreateRotationX(radians: Single): DNMatrix4x4; overload;
    {class} function CreateRotationX(radians: Single; centerPoint: DNVector3): DNMatrix4x4; overload;
    {class} function CreateRotationY(radians: Single): DNMatrix4x4; overload;
    {class} function CreateRotationY(radians: Single; centerPoint: DNVector3): DNMatrix4x4; overload;
    {class} function CreateRotationZ(radians: Single): DNMatrix4x4; overload;
    {class} function CreateRotationZ(radians: Single; centerPoint: DNVector3): DNMatrix4x4; overload;
    {class} function CreateFromAxisAngle(axis: DNVector3; angle: Single): DNMatrix4x4;
    {class} function CreatePerspectiveFieldOfView(fieldOfView: Single; aspectRatio: Single; nearPlaneDistance: Single; farPlaneDistance: Single): DNMatrix4x4;
    {class} function CreatePerspective(width: Single; height: Single; nearPlaneDistance: Single; farPlaneDistance: Single): DNMatrix4x4;
    {class} function CreatePerspectiveOffCenter(left: Single; right: Single; bottom: Single; top: Single; nearPlaneDistance: Single; farPlaneDistance: Single): DNMatrix4x4;
    {class} function CreateOrthographic(width: Single; height: Single; zNearPlane: Single; zFarPlane: Single): DNMatrix4x4;
    {class} function CreateOrthographicOffCenter(left: Single; right: Single; bottom: Single; top: Single; zNearPlane: Single; zFarPlane: Single): DNMatrix4x4;
    {class} function CreateLookAt(cameraPosition: DNVector3; cameraTarget: DNVector3; cameraUpVector: DNVector3): DNMatrix4x4;
    {class} function CreateWorld(position: DNVector3; &forward: DNVector3; up: DNVector3): DNMatrix4x4;
    {class} function CreateFromQuaternion(quaternion: DNQuaternion): DNMatrix4x4;
    {class} function CreateFromYawPitchRoll(yaw: Single; pitch: Single; roll: Single): DNMatrix4x4;
    {class} function CreateShadow(lightDirection: DNVector3; plane: DNPlane): DNMatrix4x4;
    {class} function CreateReflection(value: DNPlane): DNMatrix4x4;
    {class} function Invert(matrix: DNMatrix4x4; out result: DNMatrix4x4): Boolean;
    {class} function Decompose(matrix: DNMatrix4x4; out scale: DNVector3; out rotation: DNQuaternion; out translation: DNVector3): Boolean;
    {class} function Transform(value: DNMatrix4x4; rotation: DNQuaternion): DNMatrix4x4;
    {class} function Transpose(matrix: DNMatrix4x4): DNMatrix4x4;
    {class} function Lerp(matrix1: DNMatrix4x4; matrix2: DNMatrix4x4; amount: Single): DNMatrix4x4;
    {class} function Negate(value: DNMatrix4x4): DNMatrix4x4;
    {class} function Add(value1: DNMatrix4x4; value2: DNMatrix4x4): DNMatrix4x4;
    {class} function Subtract(value1: DNMatrix4x4; value2: DNMatrix4x4): DNMatrix4x4;
    {class} function Multiply(value1: DNMatrix4x4; value2: DNMatrix4x4): DNMatrix4x4; overload;
    {class} function Multiply(value1: DNMatrix4x4; value2: Single): DNMatrix4x4; overload;

  { static propertys } 

    {class} property Identity: DNMatrix4x4 read get_Identity;
  end;

  [DNTypeName('System.Numerics.Matrix4x4')]
  DNMatrix4x4 = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{C5CBBBC9-3080-3E1F-998B-A7109E8A11CD}']
  { getters & setters } 

    function get_IsIdentity: Boolean;
    function get_Translation: DNVector3;
    procedure set_Translation(value: DNVector3);

  { fields getter & setter } 

   function __fakeFieldGet_M11: Single;
   procedure __fakeFieldSet_M11(value: Single);
   function __fakeFieldGet_M12: Single;
   procedure __fakeFieldSet_M12(value: Single);
   function __fakeFieldGet_M13: Single;
   procedure __fakeFieldSet_M13(value: Single);
   function __fakeFieldGet_M14: Single;
   procedure __fakeFieldSet_M14(value: Single);
   function __fakeFieldGet_M21: Single;
   procedure __fakeFieldSet_M21(value: Single);
   function __fakeFieldGet_M22: Single;
   procedure __fakeFieldSet_M22(value: Single);
   function __fakeFieldGet_M23: Single;
   procedure __fakeFieldSet_M23(value: Single);
   function __fakeFieldGet_M24: Single;
   procedure __fakeFieldSet_M24(value: Single);
   function __fakeFieldGet_M31: Single;
   procedure __fakeFieldSet_M31(value: Single);
   function __fakeFieldGet_M32: Single;
   procedure __fakeFieldSet_M32(value: Single);
   function __fakeFieldGet_M33: Single;
   procedure __fakeFieldSet_M33(value: Single);
   function __fakeFieldGet_M34: Single;
   procedure __fakeFieldSet_M34(value: Single);
   function __fakeFieldGet_M41: Single;
   procedure __fakeFieldSet_M41(value: Single);
   function __fakeFieldGet_M42: Single;
   procedure __fakeFieldSet_M42(value: Single);
   function __fakeFieldGet_M43: Single;
   procedure __fakeFieldSet_M43(value: Single);
   function __fakeFieldGet_M44: Single;
   procedure __fakeFieldSet_M44(value: Single);

  { fields } 

   property M11: Single read __fakeFieldGet_M11 write __fakeFieldSet_M11;
   property M12: Single read __fakeFieldGet_M12 write __fakeFieldSet_M12;
   property M13: Single read __fakeFieldGet_M13 write __fakeFieldSet_M13;
   property M14: Single read __fakeFieldGet_M14 write __fakeFieldSet_M14;
   property M21: Single read __fakeFieldGet_M21 write __fakeFieldSet_M21;
   property M22: Single read __fakeFieldGet_M22 write __fakeFieldSet_M22;
   property M23: Single read __fakeFieldGet_M23 write __fakeFieldSet_M23;
   property M24: Single read __fakeFieldGet_M24 write __fakeFieldSet_M24;
   property M31: Single read __fakeFieldGet_M31 write __fakeFieldSet_M31;
   property M32: Single read __fakeFieldGet_M32 write __fakeFieldSet_M32;
   property M33: Single read __fakeFieldGet_M33 write __fakeFieldSet_M33;
   property M34: Single read __fakeFieldGet_M34 write __fakeFieldSet_M34;
   property M41: Single read __fakeFieldGet_M41 write __fakeFieldSet_M41;
   property M42: Single read __fakeFieldGet_M42 write __fakeFieldSet_M42;
   property M43: Single read __fakeFieldGet_M43 write __fakeFieldSet_M43;
   property M44: Single read __fakeFieldGet_M44 write __fakeFieldSet_M44;

  { methods } 

    function GetDeterminant: Single;
    function Equals(other: DNMatrix4x4): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function ToString: string;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsIdentity: Boolean read get_IsIdentity;
    property Translation: DNVector3 read get_Translation write set_Translation;
  end;

  TDNMatrix4x4 = class(TDNGenericImport<DNMatrix4x4Class, DNMatrix4x4>) end;

  //-------------namespace: System.Numerics----------------
  DNPlaneClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{503F53FA-8537-56D3-B502-8EBEB13ED34C}']
  { constructors } 

    {class} function init(x: Single; y: Single; z: Single; d: Single): DNPlane; overload;
    {class} function init(normal: DNVector3; d: Single): DNPlane; overload;
    {class} function init(value: DNVector4): DNPlane; overload;

  { static methods } 

    {class} function CreateFromVertices(point1: DNVector3; point2: DNVector3; point3: DNVector3): DNPlane;
    {class} function Normalize(value: DNPlane): DNPlane;
    {class} function Transform(plane: DNPlane; matrix: DNMatrix4x4): DNPlane; overload;
    {class} function Transform(plane: DNPlane; rotation: DNQuaternion): DNPlane; overload;
    {class} function Dot(plane: DNPlane; value: DNVector4): Single;
    {class} function DotCoordinate(plane: DNPlane; value: DNVector3): Single;
    {class} function DotNormal(plane: DNPlane; value: DNVector3): Single;

  end;

  [DNTypeName('System.Numerics.Plane')]
  DNPlane = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{12C1F5C4-828C-3840-8D0F-A5CA6BF5AC83}']
  { fields getter & setter } 

   function __fakeFieldGet_Normal: DNVector3;
   procedure __fakeFieldSet_Normal(value: DNVector3);
   function __fakeFieldGet_D: Single;
   procedure __fakeFieldSet_D(value: Single);

  { fields } 

   property Normal: DNVector3 read __fakeFieldGet_Normal write __fakeFieldSet_Normal;
   property D: Single read __fakeFieldGet_D write __fakeFieldSet_D;

  { methods } 

    function Equals(other: DNPlane): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function ToString: string;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNPlane = class(TDNGenericImport<DNPlaneClass, DNPlane>) end;

  //-------------namespace: System.Numerics----------------
  DNQuaternionClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{DF02FBD0-4B62-5A95-BED2-D8576DCC0DF6}']
  { static getter & setter } 

    {class} function get_Identity: DNQuaternion;

  { constructors } 

    {class} function init(x: Single; y: Single; z: Single; w: Single): DNQuaternion; overload;
    {class} function init(vectorPart: DNVector3; scalarPart: Single): DNQuaternion; overload;

  { static methods } 

    {class} function Normalize(value: DNQuaternion): DNQuaternion;
    {class} function Conjugate(value: DNQuaternion): DNQuaternion;
    {class} function Inverse(value: DNQuaternion): DNQuaternion;
    {class} function CreateFromAxisAngle(axis: DNVector3; angle: Single): DNQuaternion;
    {class} function CreateFromYawPitchRoll(yaw: Single; pitch: Single; roll: Single): DNQuaternion;
    {class} function CreateFromRotationMatrix(matrix: DNMatrix4x4): DNQuaternion;
    {class} function Dot(quaternion1: DNQuaternion; quaternion2: DNQuaternion): Single;
    {class} function Slerp(quaternion1: DNQuaternion; quaternion2: DNQuaternion; amount: Single): DNQuaternion;
    {class} function Lerp(quaternion1: DNQuaternion; quaternion2: DNQuaternion; amount: Single): DNQuaternion;
    {class} function Concatenate(value1: DNQuaternion; value2: DNQuaternion): DNQuaternion;
    {class} function Negate(value: DNQuaternion): DNQuaternion;
    {class} function Add(value1: DNQuaternion; value2: DNQuaternion): DNQuaternion;
    {class} function Subtract(value1: DNQuaternion; value2: DNQuaternion): DNQuaternion;
    {class} function Multiply(value1: DNQuaternion; value2: DNQuaternion): DNQuaternion; overload;
    {class} function Multiply(value1: DNQuaternion; value2: Single): DNQuaternion; overload;
    {class} function Divide(value1: DNQuaternion; value2: DNQuaternion): DNQuaternion;

  { static propertys } 

    {class} property Identity: DNQuaternion read get_Identity;
  end;

  [DNTypeName('System.Numerics.Quaternion')]
  DNQuaternion = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{4AB07119-2498-34D6-9CB4-4DB4D18E01F4}']
  { getters & setters } 

    function get_IsIdentity: Boolean;

  { fields getter & setter } 

   function __fakeFieldGet_X: Single;
   procedure __fakeFieldSet_X(value: Single);
   function __fakeFieldGet_Y: Single;
   procedure __fakeFieldSet_Y(value: Single);
   function __fakeFieldGet_Z: Single;
   procedure __fakeFieldSet_Z(value: Single);
   function __fakeFieldGet_W: Single;
   procedure __fakeFieldSet_W(value: Single);

  { fields } 

   property X: Single read __fakeFieldGet_X write __fakeFieldSet_X;
   property Y: Single read __fakeFieldGet_Y write __fakeFieldSet_Y;
   property Z: Single read __fakeFieldGet_Z write __fakeFieldSet_Z;
   property W: Single read __fakeFieldGet_W write __fakeFieldSet_W;

  { methods } 

    function Length: Single;
    function LengthSquared: Single;
    function Equals(other: DNQuaternion): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function ToString: string;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsIdentity: Boolean read get_IsIdentity;
  end;

  TDNQuaternion = class(TDNGenericImport<DNQuaternionClass, DNQuaternion>) end;

  //-------------namespace: System.Numerics----------------
  DNVector2Class = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{8F3749DF-D234-52C8-BCC9-A09E972C601E}']
  { static getter & setter } 

    {class} function get_Zero: DNVector2;
    {class} function get_One: DNVector2;
    {class} function get_UnitX: DNVector2;
    {class} function get_UnitY: DNVector2;

  { constructors } 

    {class} function init(value: Single): DNVector2; overload;
    {class} function init(x: Single; y: Single): DNVector2; overload;

  { static methods } 

    {class} function Distance(value1: DNVector2; value2: DNVector2): Single;
    {class} function DistanceSquared(value1: DNVector2; value2: DNVector2): Single;
    {class} function Normalize(value: DNVector2): DNVector2;
    {class} function Reflect(vector: DNVector2; normal: DNVector2): DNVector2;
    {class} function Clamp(value1: DNVector2; min: DNVector2; max: DNVector2): DNVector2;
    {class} function Lerp(value1: DNVector2; value2: DNVector2; amount: Single): DNVector2;
    {class} function Transform(position: DNVector2; matrix: DNMatrix3x2): DNVector2; overload;
    {class} function Transform(position: DNVector2; matrix: DNMatrix4x4): DNVector2; overload;
    {class} function TransformNormal(normal: DNVector2; matrix: DNMatrix3x2): DNVector2; overload;
    {class} function TransformNormal(normal: DNVector2; matrix: DNMatrix4x4): DNVector2; overload;
    {class} function Transform(value: DNVector2; rotation: DNQuaternion): DNVector2; overload;
    {class} function Add(left: DNVector2; right: DNVector2): DNVector2;
    {class} function Subtract(left: DNVector2; right: DNVector2): DNVector2;
    {class} function Multiply(left: DNVector2; right: DNVector2): DNVector2; overload;
    {class} function Multiply(left: DNVector2; right: Single): DNVector2; overload;
    {class} function Multiply(left: Single; right: DNVector2): DNVector2; overload;
    {class} function Divide(left: DNVector2; right: DNVector2): DNVector2; overload;
    {class} function Divide(left: DNVector2; divisor: Single): DNVector2; overload;
    {class} function Negate(value: DNVector2): DNVector2;
    {class} function Dot(value1: DNVector2; value2: DNVector2): Single;
    {class} function Min(value1: DNVector2; value2: DNVector2): DNVector2;
    {class} function Max(value1: DNVector2; value2: DNVector2): DNVector2;
    {class} function Abs(value: DNVector2): DNVector2;
    {class} function SquareRoot(value: DNVector2): DNVector2;

  { static propertys } 

    {class} property Zero: DNVector2 read get_Zero;
    {class} property One: DNVector2 read get_One;
    {class} property UnitX: DNVector2 read get_UnitX;
    {class} property UnitY: DNVector2 read get_UnitY;
  end;

  [DNTypeName('System.Numerics.Vector2')]
  DNVector2 = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{57D58EB2-3FBF-36C5-8E19-A1706F854C67}']
  { fields getter & setter } 

   function __fakeFieldGet_X: Single;
   procedure __fakeFieldSet_X(value: Single);
   function __fakeFieldGet_Y: Single;
   procedure __fakeFieldSet_Y(value: Single);

  { fields } 

   property X: Single read __fakeFieldGet_X write __fakeFieldSet_X;
   property Y: Single read __fakeFieldGet_Y write __fakeFieldSet_Y;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function ToString: string; overload;
    function ToString(format: string): string; overload;
    function ToString(format: string; formatProvider: DDNC.System.Private.CoreLib.DNIFormatProvider): string; overload;
    function Length: Single;
    function LengthSquared: Single;
    procedure CopyTo(&array: TArray<Single>); overload;
    procedure CopyTo(&array: TArray<Single>; index: Int32); overload;
    function Equals(other: DNVector2): Boolean; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNVector2 = class(TDNGenericImport<DNVector2Class, DNVector2>) end;

  //-------------namespace: System.Numerics----------------
  DNVector3Class = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{1672B0C1-1F9E-5E29-A386-BBC6A1FAF11E}']
  { static getter & setter } 

    {class} function get_Zero: DNVector3;
    {class} function get_One: DNVector3;
    {class} function get_UnitX: DNVector3;
    {class} function get_UnitY: DNVector3;
    {class} function get_UnitZ: DNVector3;

  { constructors } 

    {class} function init(value: Single): DNVector3; overload;
    {class} function init(value: DNVector2; z: Single): DNVector3; overload;
    {class} function init(x: Single; y: Single; z: Single): DNVector3; overload;

  { static methods } 

    {class} function Distance(value1: DNVector3; value2: DNVector3): Single;
    {class} function DistanceSquared(value1: DNVector3; value2: DNVector3): Single;
    {class} function Normalize(value: DNVector3): DNVector3;
    {class} function Cross(vector1: DNVector3; vector2: DNVector3): DNVector3;
    {class} function Reflect(vector: DNVector3; normal: DNVector3): DNVector3;
    {class} function Clamp(value1: DNVector3; min: DNVector3; max: DNVector3): DNVector3;
    {class} function Lerp(value1: DNVector3; value2: DNVector3; amount: Single): DNVector3;
    {class} function Transform(position: DNVector3; matrix: DNMatrix4x4): DNVector3; overload;
    {class} function TransformNormal(normal: DNVector3; matrix: DNMatrix4x4): DNVector3;
    {class} function Transform(value: DNVector3; rotation: DNQuaternion): DNVector3; overload;
    {class} function Add(left: DNVector3; right: DNVector3): DNVector3;
    {class} function Subtract(left: DNVector3; right: DNVector3): DNVector3;
    {class} function Multiply(left: DNVector3; right: DNVector3): DNVector3; overload;
    {class} function Multiply(left: DNVector3; right: Single): DNVector3; overload;
    {class} function Multiply(left: Single; right: DNVector3): DNVector3; overload;
    {class} function Divide(left: DNVector3; right: DNVector3): DNVector3; overload;
    {class} function Divide(left: DNVector3; divisor: Single): DNVector3; overload;
    {class} function Negate(value: DNVector3): DNVector3;
    {class} function Dot(vector1: DNVector3; vector2: DNVector3): Single;
    {class} function Min(value1: DNVector3; value2: DNVector3): DNVector3;
    {class} function Max(value1: DNVector3; value2: DNVector3): DNVector3;
    {class} function Abs(value: DNVector3): DNVector3;
    {class} function SquareRoot(value: DNVector3): DNVector3;

  { static propertys } 

    {class} property Zero: DNVector3 read get_Zero;
    {class} property One: DNVector3 read get_One;
    {class} property UnitX: DNVector3 read get_UnitX;
    {class} property UnitY: DNVector3 read get_UnitY;
    {class} property UnitZ: DNVector3 read get_UnitZ;
  end;

  [DNTypeName('System.Numerics.Vector3')]
  DNVector3 = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{6A73C6D1-8FED-3917-9EBB-CBE050A77A7C}']
  { fields getter & setter } 

   function __fakeFieldGet_X: Single;
   procedure __fakeFieldSet_X(value: Single);
   function __fakeFieldGet_Y: Single;
   procedure __fakeFieldSet_Y(value: Single);
   function __fakeFieldGet_Z: Single;
   procedure __fakeFieldSet_Z(value: Single);

  { fields } 

   property X: Single read __fakeFieldGet_X write __fakeFieldSet_X;
   property Y: Single read __fakeFieldGet_Y write __fakeFieldSet_Y;
   property Z: Single read __fakeFieldGet_Z write __fakeFieldSet_Z;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function ToString: string; overload;
    function ToString(format: string): string; overload;
    function ToString(format: string; formatProvider: DDNC.System.Private.CoreLib.DNIFormatProvider): string; overload;
    function Length: Single;
    function LengthSquared: Single;
    procedure CopyTo(&array: TArray<Single>); overload;
    procedure CopyTo(&array: TArray<Single>; index: Int32); overload;
    function Equals(other: DNVector3): Boolean; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNVector3 = class(TDNGenericImport<DNVector3Class, DNVector3>) end;

  //-------------namespace: System.Numerics----------------
  DNVector4Class = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{23F4992D-D1ED-5FDB-8860-004EB934DF7A}']
  { static getter & setter } 

    {class} function get_Zero: DNVector4;
    {class} function get_One: DNVector4;
    {class} function get_UnitX: DNVector4;
    {class} function get_UnitY: DNVector4;
    {class} function get_UnitZ: DNVector4;
    {class} function get_UnitW: DNVector4;

  { constructors } 

    {class} function init(value: Single): DNVector4; overload;
    {class} function init(x: Single; y: Single; z: Single; w: Single): DNVector4; overload;
    {class} function init(value: DNVector2; z: Single; w: Single): DNVector4; overload;
    {class} function init(value: DNVector3; w: Single): DNVector4; overload;

  { static methods } 

    {class} function Distance(value1: DNVector4; value2: DNVector4): Single;
    {class} function DistanceSquared(value1: DNVector4; value2: DNVector4): Single;
    {class} function Normalize(vector: DNVector4): DNVector4;
    {class} function Clamp(value1: DNVector4; min: DNVector4; max: DNVector4): DNVector4;
    {class} function Lerp(value1: DNVector4; value2: DNVector4; amount: Single): DNVector4;
    {class} function Transform(position: DNVector2; matrix: DNMatrix4x4): DNVector4; overload;
    {class} function Transform(position: DNVector3; matrix: DNMatrix4x4): DNVector4; overload;
    {class} function Transform(vector: DNVector4; matrix: DNMatrix4x4): DNVector4; overload;
    {class} function Transform(value: DNVector2; rotation: DNQuaternion): DNVector4; overload;
    {class} function Transform(value: DNVector3; rotation: DNQuaternion): DNVector4; overload;
    {class} function Transform(value: DNVector4; rotation: DNQuaternion): DNVector4; overload;
    {class} function Add(left: DNVector4; right: DNVector4): DNVector4;
    {class} function Subtract(left: DNVector4; right: DNVector4): DNVector4;
    {class} function Multiply(left: DNVector4; right: DNVector4): DNVector4; overload;
    {class} function Multiply(left: DNVector4; right: Single): DNVector4; overload;
    {class} function Multiply(left: Single; right: DNVector4): DNVector4; overload;
    {class} function Divide(left: DNVector4; right: DNVector4): DNVector4; overload;
    {class} function Divide(left: DNVector4; divisor: Single): DNVector4; overload;
    {class} function Negate(value: DNVector4): DNVector4;
    {class} function Dot(vector1: DNVector4; vector2: DNVector4): Single;
    {class} function Min(value1: DNVector4; value2: DNVector4): DNVector4;
    {class} function Max(value1: DNVector4; value2: DNVector4): DNVector4;
    {class} function Abs(value: DNVector4): DNVector4;
    {class} function SquareRoot(value: DNVector4): DNVector4;

  { static propertys } 

    {class} property Zero: DNVector4 read get_Zero;
    {class} property One: DNVector4 read get_One;
    {class} property UnitX: DNVector4 read get_UnitX;
    {class} property UnitY: DNVector4 read get_UnitY;
    {class} property UnitZ: DNVector4 read get_UnitZ;
    {class} property UnitW: DNVector4 read get_UnitW;
  end;

  [DNTypeName('System.Numerics.Vector4')]
  DNVector4 = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{6D7BA34E-9110-352A-85BF-249C38E62F7F}']
  { fields getter & setter } 

   function __fakeFieldGet_X: Single;
   procedure __fakeFieldSet_X(value: Single);
   function __fakeFieldGet_Y: Single;
   procedure __fakeFieldSet_Y(value: Single);
   function __fakeFieldGet_Z: Single;
   procedure __fakeFieldSet_Z(value: Single);
   function __fakeFieldGet_W: Single;
   procedure __fakeFieldSet_W(value: Single);

  { fields } 

   property X: Single read __fakeFieldGet_X write __fakeFieldSet_X;
   property Y: Single read __fakeFieldGet_Y write __fakeFieldSet_Y;
   property Z: Single read __fakeFieldGet_Z write __fakeFieldSet_Z;
   property W: Single read __fakeFieldGet_W write __fakeFieldSet_W;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function ToString: string; overload;
    function ToString(format: string): string; overload;
    function ToString(format: string; formatProvider: DDNC.System.Private.CoreLib.DNIFormatProvider): string; overload;
    function Length: Single;
    function LengthSquared: Single;
    procedure CopyTo(&array: TArray<Single>); overload;
    procedure CopyTo(&array: TArray<Single>; index: Int32); overload;
    function Equals(other: DNVector4): Boolean; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNVector4 = class(TDNGenericImport<DNVector4Class, DNVector4>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Numerics.Vectors, Version=4.1.4.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
