//----------------------------------------------------------------------------
//  System.Net.Security.dll: System.Net.Security, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.Security
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.Security;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Collections.NonGeneric,
  DDNC.System.Security.Cryptography.X509Certificates,
  DDNC.System.Net.Primitives,
  DDNC.System.Security.Principal;

type

{ enums }

  //-------------namespace: System.Net.Security----------------
  [DNTypeName('System.Net.Security.EncryptionPolicy')]
  DNEncryptionPolicy = type Integer;
  DNEncryptionPolicyHelper = record helper for DNEncryptionPolicy
  public const
    RequireEncryption = 0;
    AllowNoEncryption = 1;
    NoEncryption = 2;
  end;


  //-------------namespace: System.Net.Security----------------
  [DNTypeName('System.Net.Security.ProtectionLevel')]
  DNProtectionLevel = type Integer;
  DNProtectionLevelHelper = record helper for DNProtectionLevel
  public const
    None = 0;
    Sign = 1;
    EncryptAndSign = 2;
  end;


  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  [DNTypeName('System.Security.Authentication.ExtendedProtection.PolicyEnforcement')]
  DNPolicyEnforcement = type Integer;
  DNPolicyEnforcementHelper = record helper for DNPolicyEnforcement
  public const
    Never = 0;
    WhenSupported = 1;
    Always = 2;
  end;


  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  [DNTypeName('System.Security.Authentication.ExtendedProtection.ProtectionScenario')]
  DNProtectionScenario = type Integer;
  DNProtectionScenarioHelper = record helper for DNProtectionScenario
  public const
    TransportSelected = 0;
    TrustedProxy = 1;
  end;




type


{ declares }

  DNServiceNameCollection = interface; // type: System.Security.Authentication.ExtendedProtection.ServiceNameCollection, namespace: System.Security.Authentication.ExtendedProtection
  DNAuthenticationException = interface; // type: System.Security.Authentication.AuthenticationException, namespace: System.Security.Authentication
  DNInvalidCredentialException = interface; // type: System.Security.Authentication.InvalidCredentialException, namespace: System.Security.Authentication
  DNAuthenticatedStream = interface; // type: System.Net.Security.AuthenticatedStream, namespace: System.Net.Security
  DNNegotiateStream = interface; // type: System.Net.Security.NegotiateStream, namespace: System.Net.Security
  DNSslStream = interface; // type: System.Net.Security.SslStream, namespace: System.Net.Security
  DNSslClientAuthenticationOptions = interface; // type: System.Net.Security.SslClientAuthenticationOptions, namespace: System.Net.Security
  DNSslServerAuthenticationOptions = interface; // type: System.Net.Security.SslServerAuthenticationOptions, namespace: System.Net.Security
  DNExtendedProtectionPolicy = interface; // type: System.Security.Authentication.ExtendedProtection.ExtendedProtectionPolicy, namespace: System.Security.Authentication.ExtendedProtection
  DNSslApplicationProtocol = interface; // type: System.Net.Security.SslApplicationProtocol, namespace: System.Net.Security

{ delegates }

  [DNTypeName('System.Net.Security.LocalCertificateSelectionCallback')]
  DNLocalCertificateSelectionCallback = function(sender: DDNC.System.Private.CoreLib.DNObject; targetHost: string; localCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; remoteCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; acceptableIssuers: TArray<string>): DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate of object;

  [DNTypeName('System.Net.Security.RemoteCertificateValidationCallback')]
  DNRemoteCertificateValidationCallback = function(sender: DDNC.System.Private.CoreLib.DNObject; certificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; chain: DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain; sslPolicyErrors: DDNC.System.Net.Primitives.DNSslPolicyErrors): Boolean of object;

  [DNTypeName('System.Net.Security.ServerCertificateSelectionCallback')]
  DNServerCertificateSelectionCallback = function(sender: DDNC.System.Private.CoreLib.DNObject; hostName: string): DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate of object;




{ objects }

  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  DNServiceNameCollectionClass = interface(DNObjectClass)
  ['{57181375-D80D-54F3-AF8D-BB3794517A3D}']
  { constructors } 

    {class} function init(items: DDNC.System.Private.CoreLib.DNICollection): DNServiceNameCollection;

  end;

  [DNTypeName('System.Security.Authentication.ExtendedProtection.ServiceNameCollection')]
  DNServiceNameCollection = interface(DNObject)
  ['{DAD43EC1-F40A-3DCE-9B2C-0B1D97C8E7AA}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    function &Contains(searchServiceName: string): Boolean;
    function Merge(serviceName: string): DNServiceNameCollection; overload;
    function Merge(serviceNames: DDNC.System.Private.CoreLib.DNIEnumerable): DNServiceNameCollection; overload;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNServiceNameCollection = class(TDNGenericImport<DNServiceNameCollectionClass, DNServiceNameCollection>) end;

  //-------------namespace: System.Security.Authentication----------------
  DNAuthenticationExceptionClass = interface(DDNC.System.Private.CoreLib.DNSystemExceptionClass)
  ['{4ECAD830-FCE2-5142-9E50-CC2969639FA6}']
  { constructors } 

    {class} function init: DNAuthenticationException; overload;
    {class} function init(message: string): DNAuthenticationException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNAuthenticationException; overload;

  end;

  [DNTypeName('System.Security.Authentication.AuthenticationException')]
  DNAuthenticationException = interface(DDNC.System.Private.CoreLib.DNSystemException)
  ['{80FB65A4-2620-3341-8BCF-B315422E0D14}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNAuthenticationException = class(TDNGenericImport<DNAuthenticationExceptionClass, DNAuthenticationException>) end;

  //-------------namespace: System.Security.Authentication----------------
  DNInvalidCredentialExceptionClass = interface(DNAuthenticationExceptionClass)
  ['{8B4B9897-0B72-569C-A95F-901DF56999AF}']
  { constructors } 

    {class} function init: DNInvalidCredentialException; overload;
    {class} function init(message: string): DNInvalidCredentialException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNInvalidCredentialException; overload;

  end;

  [DNTypeName('System.Security.Authentication.InvalidCredentialException')]
  DNInvalidCredentialException = interface(DNAuthenticationException)
  ['{4462F4D8-DFD6-35E9-8EE1-06730C45EC24}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNInvalidCredentialException = class(TDNGenericImport<DNInvalidCredentialExceptionClass, DNInvalidCredentialException>) end;

  //-------------namespace: System.Net.Security----------------
  DNAuthenticatedStreamClass = interface(DDNC.System.Private.CoreLib.DNStreamClass)
  ['{E5C3B6A6-00D3-5361-8055-BC0ADC13DC71}']
  end;

  [DNTypeName('System.Net.Security.AuthenticatedStream')]
  DNAuthenticatedStream = interface(DDNC.System.Private.CoreLib.DNStream)
  ['{764B0B6A-3EDB-37FC-A753-96C0D6174E01}']
  { getters & setters } 

    function get_LeaveInnerStreamOpen: Boolean;
    function get_IsAuthenticated: Boolean;
    function get_IsMutuallyAuthenticated: Boolean;
    function get_IsEncrypted: Boolean;
    function get_IsSigned: Boolean;
    function get_IsServer: Boolean;
    function get_CanRead: Boolean;
    function get_CanSeek: Boolean;
    function get_CanTimeout: Boolean;
    function get_CanWrite: Boolean;
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);

  { methods } 

    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    procedure Flush;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure SetLength(value: Int64);
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadByte: Int32;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure WriteByte(value: Byte);
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property LeaveInnerStreamOpen: Boolean read get_LeaveInnerStreamOpen;
    property IsAuthenticated: Boolean read get_IsAuthenticated;
    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
    property IsEncrypted: Boolean read get_IsEncrypted;
    property IsSigned: Boolean read get_IsSigned;
    property IsServer: Boolean read get_IsServer;
    property CanRead: Boolean read get_CanRead;
    property CanSeek: Boolean read get_CanSeek;
    property CanTimeout: Boolean read get_CanTimeout;
    property CanWrite: Boolean read get_CanWrite;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
  end;

  TDNAuthenticatedStream = class(TDNGenericImport<DNAuthenticatedStreamClass, DNAuthenticatedStream>) end;

  //-------------namespace: System.Net.Security----------------
  DNNegotiateStreamClass = interface(DNAuthenticatedStreamClass)
  ['{55255130-D963-5791-BBEF-6D3409446345}']
  { constructors } 

    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream): DNNegotiateStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean): DNNegotiateStream; overload;

  end;

  [DNTypeName('System.Net.Security.NegotiateStream')]
  DNNegotiateStream = interface(DNAuthenticatedStream)
  ['{EF701648-C2C7-3FB0-906C-E316115A8B46}']
  { getters & setters } 

    function get_IsAuthenticated: Boolean;
    function get_IsMutuallyAuthenticated: Boolean;
    function get_IsEncrypted: Boolean;
    function get_IsSigned: Boolean;
    function get_IsServer: Boolean;
    function get_ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel;
    function get_RemoteIdentity: DDNC.System.Security.Principal.DNIIdentity;
    function get_CanSeek: Boolean;
    function get_CanRead: Boolean;
    function get_CanTimeout: Boolean;
    function get_CanWrite: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_LeaveInnerStreamOpen: Boolean;

  { methods } 

    function BeginAuthenticateAsClient(asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndAuthenticateAsClient(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    procedure AuthenticateAsServer; overload;
    procedure AuthenticateAsServer(policy: DNExtendedProtectionPolicy); overload;
    procedure AuthenticateAsServer(credential: DDNC.System.Net.Primitives.DNNetworkCredential; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel); overload;
    procedure AuthenticateAsServer(credential: DDNC.System.Net.Primitives.DNNetworkCredential; policy: DNExtendedProtectionPolicy; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel); overload;
    function BeginAuthenticateAsServer(asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(policy: DNExtendedProtectionPolicy; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(credential: DDNC.System.Net.Primitives.DNNetworkCredential; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(credential: DDNC.System.Net.Primitives.DNNetworkCredential; policy: DNExtendedProtectionPolicy; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndAuthenticateAsServer(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    procedure AuthenticateAsClient; overload;
    procedure AuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string); overload;
    procedure AuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string); overload;
    procedure AuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel); overload;
    procedure AuthenticateAsClient(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel); overload;
    function AuthenticateAsClientAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; binding: DDNC.System.Net.Primitives.DNChannelBinding; targetName: string; requiredProtectionLevel: DNProtectionLevel; allowedImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(policy: DNExtendedProtectionPolicy): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(credential: DDNC.System.Net.Primitives.DNNetworkCredential; policy: DNExtendedProtectionPolicy; requiredProtectionLevel: DNProtectionLevel; requiredImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure SetLength(value: Int64);
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure Flush;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadByte: Int32;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure WriteByte(value: Byte);
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsAuthenticated: Boolean read get_IsAuthenticated;
    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
    property IsEncrypted: Boolean read get_IsEncrypted;
    property IsSigned: Boolean read get_IsSigned;
    property IsServer: Boolean read get_IsServer;
    property ImpersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel read get_ImpersonationLevel;
    property RemoteIdentity: DDNC.System.Security.Principal.DNIIdentity read get_RemoteIdentity;
    property CanSeek: Boolean read get_CanSeek;
    property CanRead: Boolean read get_CanRead;
    property CanTimeout: Boolean read get_CanTimeout;
    property CanWrite: Boolean read get_CanWrite;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property LeaveInnerStreamOpen: Boolean read get_LeaveInnerStreamOpen;
  end;

  TDNNegotiateStream = class(TDNGenericImport<DNNegotiateStreamClass, DNNegotiateStream>) end;

  //-------------namespace: System.Net.Security----------------
  DNSslStreamClass = interface(DNAuthenticatedStreamClass)
  ['{F9733308-62D8-5112-AD8C-B78E794AF7C4}']
  { constructors } 

    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream): DNSslStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean): DNSslStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean; userCertificateValidationCallback: DNRemoteCertificateValidationCallback): DNSslStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean; userCertificateValidationCallback: DNRemoteCertificateValidationCallback; userCertificateSelectionCallback: DNLocalCertificateSelectionCallback): DNSslStream; overload;
    {class} function init(innerStream: DDNC.System.Private.CoreLib.DNStream; leaveInnerStreamOpen: Boolean; userCertificateValidationCallback: DNRemoteCertificateValidationCallback; userCertificateSelectionCallback: DNLocalCertificateSelectionCallback; encryptionPolicy: DNEncryptionPolicy): DNSslStream; overload;

  end;

  [DNTypeName('System.Net.Security.SslStream')]
  DNSslStream = interface(DNAuthenticatedStream)
  ['{B477806B-1178-3D6B-8E50-06ED988AD0DC}']
  { getters & setters } 

    function get_NegotiatedApplicationProtocol: DNSslApplicationProtocol;
    function get_TransportContext: DDNC.System.Net.Primitives.DNTransportContext;
    function get_IsAuthenticated: Boolean;
    function get_IsMutuallyAuthenticated: Boolean;
    function get_IsEncrypted: Boolean;
    function get_IsSigned: Boolean;
    function get_IsServer: Boolean;
    function get_SslProtocol: DDNC.System.Net.Primitives.DNSslProtocols;
    function get_CheckCertRevocationStatus: Boolean;
    function get_LocalCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate;
    function get_RemoteCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate;
    function get_CipherAlgorithm: DDNC.System.Net.Primitives.DNCipherAlgorithmType;
    function get_CipherStrength: Int32;
    function get_HashAlgorithm: DDNC.System.Net.Primitives.DNHashAlgorithmType;
    function get_HashStrength: Int32;
    function get_KeyExchangeAlgorithm: DDNC.System.Net.Primitives.DNExchangeAlgorithmType;
    function get_KeyExchangeStrength: Int32;
    function get_CanSeek: Boolean;
    function get_CanRead: Boolean;
    function get_CanTimeout: Boolean;
    function get_CanWrite: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_LeaveInnerStreamOpen: Boolean;

  { methods } 

    function BeginAuthenticateAsClient(targetHost: string; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; checkCertificateRevocation: Boolean; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsClient(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndAuthenticateAsClient(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function BeginAuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; checkCertificateRevocation: Boolean; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndAuthenticateAsServer(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    procedure AuthenticateAsClient(targetHost: string); overload;
    procedure AuthenticateAsClient(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; checkCertificateRevocation: Boolean); overload;
    procedure AuthenticateAsClient(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean); overload;
    procedure AuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate); overload;
    procedure AuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; checkCertificateRevocation: Boolean); overload;
    procedure AuthenticateAsServer(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean); overload;
    function AuthenticateAsClientAsync(targetHost: string): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; checkCertificateRevocation: Boolean): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(targetHost: string; clientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsClientAsync(sslClientAuthenticationOptions: DNSslClientAuthenticationOptions; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; checkCertificateRevocation: Boolean): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(serverCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate; clientCertificateRequired: Boolean; enabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols; checkCertificateRevocation: Boolean): DDNC.System.Private.CoreLib.DNTask; overload;
    function AuthenticateAsServerAsync(sslServerAuthenticationOptions: DNSslServerAuthenticationOptions; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function ShutdownAsync: DDNC.System.Private.CoreLib.DNTask;
    procedure SetLength(value: Int64);
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure Flush;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadByte: Int32;
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    procedure Write(buffer: TArray<Byte>); overload;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure WriteByte(value: Byte);
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property NegotiatedApplicationProtocol: DNSslApplicationProtocol read get_NegotiatedApplicationProtocol;
    property TransportContext: DDNC.System.Net.Primitives.DNTransportContext read get_TransportContext;
    property IsAuthenticated: Boolean read get_IsAuthenticated;
    property IsMutuallyAuthenticated: Boolean read get_IsMutuallyAuthenticated;
    property IsEncrypted: Boolean read get_IsEncrypted;
    property IsSigned: Boolean read get_IsSigned;
    property IsServer: Boolean read get_IsServer;
    property SslProtocol: DDNC.System.Net.Primitives.DNSslProtocols read get_SslProtocol;
    property CheckCertRevocationStatus: Boolean read get_CheckCertRevocationStatus;
    property LocalCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate read get_LocalCertificate;
    property RemoteCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate read get_RemoteCertificate;
    property CipherAlgorithm: DDNC.System.Net.Primitives.DNCipherAlgorithmType read get_CipherAlgorithm;
    property CipherStrength: Int32 read get_CipherStrength;
    property HashAlgorithm: DDNC.System.Net.Primitives.DNHashAlgorithmType read get_HashAlgorithm;
    property HashStrength: Int32 read get_HashStrength;
    property KeyExchangeAlgorithm: DDNC.System.Net.Primitives.DNExchangeAlgorithmType read get_KeyExchangeAlgorithm;
    property KeyExchangeStrength: Int32 read get_KeyExchangeStrength;
    property CanSeek: Boolean read get_CanSeek;
    property CanRead: Boolean read get_CanRead;
    property CanTimeout: Boolean read get_CanTimeout;
    property CanWrite: Boolean read get_CanWrite;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property LeaveInnerStreamOpen: Boolean read get_LeaveInnerStreamOpen;
  end;

  TDNSslStream = class(TDNGenericImport<DNSslStreamClass, DNSslStream>) end;

  //-------------namespace: System.Net.Security----------------
  DNSslClientAuthenticationOptionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{EA1CC187-9F15-5DD6-A2E8-A808A1C8B16B}']
  { constructors } 

    {class} function init: DNSslClientAuthenticationOptions;

  end;

  [DNTypeName('System.Net.Security.SslClientAuthenticationOptions')]
  DNSslClientAuthenticationOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{CB541FDF-BF91-33E4-90E7-E12592F8101A}']
  { getters & setters } 

    function get_AllowRenegotiation: Boolean;
    procedure set_AllowRenegotiation(value: Boolean);
    function get_LocalCertificateSelectionCallback: DNLocalCertificateSelectionCallback;
    procedure set_LocalCertificateSelectionCallback(value: DNLocalCertificateSelectionCallback);
    function get_RemoteCertificateValidationCallback: DNRemoteCertificateValidationCallback;
    procedure set_RemoteCertificateValidationCallback(value: DNRemoteCertificateValidationCallback);
    function get_ApplicationProtocols: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol>;
    procedure set_ApplicationProtocols(value: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol>);
    function get_TargetHost: string;
    procedure set_TargetHost(value: string);
    function get_ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection;
    procedure set_ClientCertificates(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection);
    function get_CertificateRevocationCheckMode: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode;
    procedure set_CertificateRevocationCheckMode(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode);
    function get_EncryptionPolicy: DNEncryptionPolicy;
    procedure set_EncryptionPolicy(value: DNEncryptionPolicy);
    function get_EnabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols;
    procedure set_EnabledSslProtocols(value: DDNC.System.Net.Primitives.DNSslProtocols);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AllowRenegotiation: Boolean read get_AllowRenegotiation write set_AllowRenegotiation;
    property LocalCertificateSelectionCallback: DNLocalCertificateSelectionCallback read get_LocalCertificateSelectionCallback write set_LocalCertificateSelectionCallback;
    property RemoteCertificateValidationCallback: DNRemoteCertificateValidationCallback read get_RemoteCertificateValidationCallback write set_RemoteCertificateValidationCallback;
    property ApplicationProtocols: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol> read get_ApplicationProtocols write set_ApplicationProtocols;
    property TargetHost: string read get_TargetHost write set_TargetHost;
    property ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection read get_ClientCertificates write set_ClientCertificates;
    property CertificateRevocationCheckMode: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode read get_CertificateRevocationCheckMode write set_CertificateRevocationCheckMode;
    property EncryptionPolicy: DNEncryptionPolicy read get_EncryptionPolicy write set_EncryptionPolicy;
    property EnabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols read get_EnabledSslProtocols write set_EnabledSslProtocols;
  end;

  TDNSslClientAuthenticationOptions = class(TDNGenericImport<DNSslClientAuthenticationOptionsClass, DNSslClientAuthenticationOptions>) end;

  //-------------namespace: System.Net.Security----------------
  DNSslServerAuthenticationOptionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0CADEA2C-8427-5854-8442-9032E6D3CE09}']
  { constructors } 

    {class} function init: DNSslServerAuthenticationOptions;

  end;

  [DNTypeName('System.Net.Security.SslServerAuthenticationOptions')]
  DNSslServerAuthenticationOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A80960A2-664C-3F63-B727-A89D23A06A33}']
  { getters & setters } 

    function get_AllowRenegotiation: Boolean;
    procedure set_AllowRenegotiation(value: Boolean);
    function get_ClientCertificateRequired: Boolean;
    procedure set_ClientCertificateRequired(value: Boolean);
    function get_ApplicationProtocols: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol>;
    procedure set_ApplicationProtocols(value: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol>);
    function get_RemoteCertificateValidationCallback: DNRemoteCertificateValidationCallback;
    procedure set_RemoteCertificateValidationCallback(value: DNRemoteCertificateValidationCallback);
    function get_ServerCertificateSelectionCallback: DNServerCertificateSelectionCallback;
    procedure set_ServerCertificateSelectionCallback(value: DNServerCertificateSelectionCallback);
    function get_ServerCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate;
    procedure set_ServerCertificate(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate);
    function get_EnabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols;
    procedure set_EnabledSslProtocols(value: DDNC.System.Net.Primitives.DNSslProtocols);
    function get_CertificateRevocationCheckMode: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode;
    procedure set_CertificateRevocationCheckMode(value: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode);
    function get_EncryptionPolicy: DNEncryptionPolicy;
    procedure set_EncryptionPolicy(value: DNEncryptionPolicy);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AllowRenegotiation: Boolean read get_AllowRenegotiation write set_AllowRenegotiation;
    property ClientCertificateRequired: Boolean read get_ClientCertificateRequired write set_ClientCertificateRequired;
    property ApplicationProtocols: DDNC.System.Private.CoreLib.DNList<DNSslApplicationProtocol> read get_ApplicationProtocols write set_ApplicationProtocols;
    property RemoteCertificateValidationCallback: DNRemoteCertificateValidationCallback read get_RemoteCertificateValidationCallback write set_RemoteCertificateValidationCallback;
    property ServerCertificateSelectionCallback: DNServerCertificateSelectionCallback read get_ServerCertificateSelectionCallback write set_ServerCertificateSelectionCallback;
    property ServerCertificate: DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate read get_ServerCertificate write set_ServerCertificate;
    property EnabledSslProtocols: DDNC.System.Net.Primitives.DNSslProtocols read get_EnabledSslProtocols write set_EnabledSslProtocols;
    property CertificateRevocationCheckMode: DDNC.System.Security.Cryptography.X509Certificates.DNX509RevocationMode read get_CertificateRevocationCheckMode write set_CertificateRevocationCheckMode;
    property EncryptionPolicy: DNEncryptionPolicy read get_EncryptionPolicy write set_EncryptionPolicy;
  end;

  TDNSslServerAuthenticationOptions = class(TDNGenericImport<DNSslServerAuthenticationOptionsClass, DNSslServerAuthenticationOptions>) end;

  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  DNExtendedProtectionPolicyClass = interface(DNObjectClass)
  ['{62228524-17AF-5F92-AAAC-628233C0B0DC}']
  { static getter & setter } 

    {class} function get_OSSupportsExtendedProtection: Boolean;

  { constructors } 

    {class} function init(policyEnforcement: DNPolicyEnforcement; protectionScenario: DNProtectionScenario; customServiceNames: DNServiceNameCollection): DNExtendedProtectionPolicy; overload;
    {class} function init(policyEnforcement: DNPolicyEnforcement; protectionScenario: DNProtectionScenario; customServiceNames: DDNC.System.Private.CoreLib.DNICollection): DNExtendedProtectionPolicy; overload;
    {class} function init(policyEnforcement: DNPolicyEnforcement; customChannelBinding: DDNC.System.Net.Primitives.DNChannelBinding): DNExtendedProtectionPolicy; overload;
    {class} function init(policyEnforcement: DNPolicyEnforcement): DNExtendedProtectionPolicy; overload;

  { static propertys } 

    {class} property OSSupportsExtendedProtection: Boolean read get_OSSupportsExtendedProtection;
  end;

  [DNTypeName('System.Security.Authentication.ExtendedProtection.ExtendedProtectionPolicy')]
  DNExtendedProtectionPolicy = interface(DDNC.System.Private.CoreLib.DNISerializable)
  ['{9E5B477B-4BFA-3CBD-AE2D-F82072EFD0A1}']
  { getters & setters } 

    function get_CustomServiceNames: DNServiceNameCollection;
    function get_PolicyEnforcement: DNPolicyEnforcement;
    function get_ProtectionScenario: DNProtectionScenario;
    function get_CustomChannelBinding: DDNC.System.Net.Primitives.DNChannelBinding;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CustomServiceNames: DNServiceNameCollection read get_CustomServiceNames;
    property PolicyEnforcement: DNPolicyEnforcement read get_PolicyEnforcement;
    property ProtectionScenario: DNProtectionScenario read get_ProtectionScenario;
    property CustomChannelBinding: DDNC.System.Net.Primitives.DNChannelBinding read get_CustomChannelBinding;
  end;

  TDNExtendedProtectionPolicy = class(TDNGenericImport<DNExtendedProtectionPolicyClass, DNExtendedProtectionPolicy>) end;

  //-------------namespace: System.Net.Security----------------
  DNSslApplicationProtocolClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{AD72DF7C-55FF-5577-8EF9-C2F5C8EDE97F}']
  { constructors } 

    {class} function init(protocol: TArray<Byte>): DNSslApplicationProtocol; overload;
    {class} function init(protocol: string): DNSslApplicationProtocol; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_Http2: DNSslApplicationProtocol;
   function __fakeFieldGet_Http11: DNSslApplicationProtocol;

  { static fields } 

    {class} property Http2: DNSslApplicationProtocol read __fakeFieldGet_Http2;
    {class} property Http11: DNSslApplicationProtocol read __fakeFieldGet_Http11;

  end;

  [DNTypeName('System.Net.Security.SslApplicationProtocol')]
  DNSslApplicationProtocol = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{F914AB93-C26E-3A87-BACD-9FD17F5C37B1}']
  { getters & setters } 

    function get_Protocol: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>;

  { methods } 

    function Equals(other: DNSslApplicationProtocol): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Protocol: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte> read get_Protocol;
  end;

  TDNSslApplicationProtocol = class(TDNGenericImport<DNSslApplicationProtocolClass, DNSslApplicationProtocol>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.Security, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
