//----------------------------------------------------------------------------
//  System.Net.Http.dll: System.Net.Http, Version=4.2.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.Http
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.Http;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Private.Uri,
  DDNC.System.Net.Primitives,
  DDNC.System.Security.Cryptography.X509Certificates,
  DDNC.System.Net.Security;

type

{ enums }

  //-------------namespace: System.Net.Http----------------
  [DNTypeName('System.Net.Http.ClientCertificateOption')]
  DNClientCertificateOption = type Integer;
  DNClientCertificateOptionHelper = record helper for DNClientCertificateOption
  public const
    Manual = 0;
    Automatic = 1;
  end;


  //-------------namespace: System.Net.Http----------------
  [DNTypeName('System.Net.Http.HttpCompletionOption')]
  DNHttpCompletionOption = type Integer;
  DNHttpCompletionOptionHelper = record helper for DNHttpCompletionOption
  public const
    ResponseContentRead = 0;
    ResponseHeadersRead = 1;
  end;




type


{ declares }

  DNHttpRequestException = interface; // type: System.Net.Http.HttpRequestException, namespace: System.Net.Http
  DNAuthenticationHeaderValue = interface; // type: System.Net.Http.Headers.AuthenticationHeaderValue, namespace: System.Net.Http.Headers
  DNCacheControlHeaderValue = interface; // type: System.Net.Http.Headers.CacheControlHeaderValue, namespace: System.Net.Http.Headers
  DNContentDispositionHeaderValue = interface; // type: System.Net.Http.Headers.ContentDispositionHeaderValue, namespace: System.Net.Http.Headers
  DNContentRangeHeaderValue = interface; // type: System.Net.Http.Headers.ContentRangeHeaderValue, namespace: System.Net.Http.Headers
  DNEntityTagHeaderValue = interface; // type: System.Net.Http.Headers.EntityTagHeaderValue, namespace: System.Net.Http.Headers
  DNHttpHeaders = interface; // type: System.Net.Http.Headers.HttpHeaders, namespace: System.Net.Http.Headers
  DNHttpContentHeaders = interface; // type: System.Net.Http.Headers.HttpContentHeaders, namespace: System.Net.Http.Headers
  DNHttpRequestHeaders = interface; // type: System.Net.Http.Headers.HttpRequestHeaders, namespace: System.Net.Http.Headers
  DNHttpResponseHeaders = interface; // type: System.Net.Http.Headers.HttpResponseHeaders, namespace: System.Net.Http.Headers
  DNHttpHeaderValueCollection<T> = interface; // type: System.Net.Http.Headers.HttpHeaderValueCollection`1, namespace: System.Net.Http.Headers
  DNMediaTypeHeaderValue = interface; // type: System.Net.Http.Headers.MediaTypeHeaderValue, namespace: System.Net.Http.Headers
  DNMediaTypeWithQualityHeaderValue = interface; // type: System.Net.Http.Headers.MediaTypeWithQualityHeaderValue, namespace: System.Net.Http.Headers
  DNNameValueHeaderValue = interface; // type: System.Net.Http.Headers.NameValueHeaderValue, namespace: System.Net.Http.Headers
  DNNameValueWithParametersHeaderValue = interface; // type: System.Net.Http.Headers.NameValueWithParametersHeaderValue, namespace: System.Net.Http.Headers
  DNProductHeaderValue = interface; // type: System.Net.Http.Headers.ProductHeaderValue, namespace: System.Net.Http.Headers
  DNProductInfoHeaderValue = interface; // type: System.Net.Http.Headers.ProductInfoHeaderValue, namespace: System.Net.Http.Headers
  DNRangeConditionHeaderValue = interface; // type: System.Net.Http.Headers.RangeConditionHeaderValue, namespace: System.Net.Http.Headers
  DNRangeHeaderValue = interface; // type: System.Net.Http.Headers.RangeHeaderValue, namespace: System.Net.Http.Headers
  DNRangeItemHeaderValue = interface; // type: System.Net.Http.Headers.RangeItemHeaderValue, namespace: System.Net.Http.Headers
  DNRetryConditionHeaderValue = interface; // type: System.Net.Http.Headers.RetryConditionHeaderValue, namespace: System.Net.Http.Headers
  DNStringWithQualityHeaderValue = interface; // type: System.Net.Http.Headers.StringWithQualityHeaderValue, namespace: System.Net.Http.Headers
  DNTransferCodingHeaderValue = interface; // type: System.Net.Http.Headers.TransferCodingHeaderValue, namespace: System.Net.Http.Headers
  DNTransferCodingWithQualityHeaderValue = interface; // type: System.Net.Http.Headers.TransferCodingWithQualityHeaderValue, namespace: System.Net.Http.Headers
  DNViaHeaderValue = interface; // type: System.Net.Http.Headers.ViaHeaderValue, namespace: System.Net.Http.Headers
  DNWarningHeaderValue = interface; // type: System.Net.Http.Headers.WarningHeaderValue, namespace: System.Net.Http.Headers
  DNHttpContent = interface; // type: System.Net.Http.HttpContent, namespace: System.Net.Http
  DNByteArrayContent = interface; // type: System.Net.Http.ByteArrayContent, namespace: System.Net.Http
  DNFormUrlEncodedContent = interface; // type: System.Net.Http.FormUrlEncodedContent, namespace: System.Net.Http
  DNStringContent = interface; // type: System.Net.Http.StringContent, namespace: System.Net.Http
  DNMultipartContent = interface; // type: System.Net.Http.MultipartContent, namespace: System.Net.Http
  DNMultipartFormDataContent = interface; // type: System.Net.Http.MultipartFormDataContent, namespace: System.Net.Http
  DNReadOnlyMemoryContent = interface; // type: System.Net.Http.ReadOnlyMemoryContent, namespace: System.Net.Http
  DNStreamContent = interface; // type: System.Net.Http.StreamContent, namespace: System.Net.Http
  DNHttpMessageHandler = interface; // type: System.Net.Http.HttpMessageHandler, namespace: System.Net.Http
  DNDelegatingHandler = interface; // type: System.Net.Http.DelegatingHandler, namespace: System.Net.Http
  DNMessageProcessingHandler = interface; // type: System.Net.Http.MessageProcessingHandler, namespace: System.Net.Http
  DNHttpClientHandler = interface; // type: System.Net.Http.HttpClientHandler, namespace: System.Net.Http
  DNSocketsHttpHandler = interface; // type: System.Net.Http.SocketsHttpHandler, namespace: System.Net.Http
  DNHttpMessageInvoker = interface; // type: System.Net.Http.HttpMessageInvoker, namespace: System.Net.Http
  DNHttpClient = interface; // type: System.Net.Http.HttpClient, namespace: System.Net.Http
  DNHttpMethod = interface; // type: System.Net.Http.HttpMethod, namespace: System.Net.Http
  DNHttpRequestMessage = interface; // type: System.Net.Http.HttpRequestMessage, namespace: System.Net.Http
  DNHttpResponseMessage = interface; // type: System.Net.Http.HttpResponseMessage, namespace: System.Net.Http


{ objects }

  //-------------namespace: System.Net.Http----------------
  DNHttpRequestExceptionClass = interface(DDNC.System.Private.CoreLib.DNExceptionClass)
  ['{81E711C9-40C9-56E9-B24D-0E6A22FBF270}']
  { constructors } 

    {class} function init: DNHttpRequestException; overload;
    {class} function init(message: string): DNHttpRequestException; overload;
    {class} function init(message: string; inner: DDNC.System.Private.CoreLib.DNException): DNHttpRequestException; overload;

  end;

  [DNTypeName('System.Net.Http.HttpRequestException')]
  DNHttpRequestException = interface(DDNC.System.Private.CoreLib.DNException)
  ['{260879EE-1BB3-315A-B13E-0D6A78D1967F}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNHttpRequestException = class(TDNGenericImport<DNHttpRequestExceptionClass, DNHttpRequestException>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNAuthenticationHeaderValueClass = interface(DNObjectClass)
  ['{6A71C003-5419-57A5-BF9C-C688421DA379}']
  { constructors } 

    {class} function init(scheme: string): DNAuthenticationHeaderValue; overload;
    {class} function init(scheme: string; parameter: string): DNAuthenticationHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNAuthenticationHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNAuthenticationHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.AuthenticationHeaderValue')]
  DNAuthenticationHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{460F4B20-6089-3C6F-AB9F-17BD1D730C8C}']
  { getters & setters } 

    function get_Scheme: string;
    function get_Parameter: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Scheme: string read get_Scheme;
    property Parameter: string read get_Parameter;
  end;

  TDNAuthenticationHeaderValue = class(TDNGenericImport<DNAuthenticationHeaderValueClass, DNAuthenticationHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNCacheControlHeaderValueClass = interface(DNObjectClass)
  ['{20AC4371-FF03-5B48-961C-543AD4349AA9}']
  { constructors } 

    {class} function init: DNCacheControlHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNCacheControlHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNCacheControlHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.CacheControlHeaderValue')]
  DNCacheControlHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{A862FC60-D7C4-3FE7-BEBA-591EC29C470F}']
  { getters & setters } 

    function get_NoCache: Boolean;
    procedure set_NoCache(value: Boolean);
    function get_NoCacheHeaders: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_NoStore: Boolean;
    procedure set_NoStore(value: Boolean);
    function get_MaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_MaxAge(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_SharedMaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_SharedMaxAge(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_MaxStale: Boolean;
    procedure set_MaxStale(value: Boolean);
    function get_MaxStaleLimit: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_MaxStaleLimit(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_MinFresh: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_MinFresh(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_NoTransform: Boolean;
    procedure set_NoTransform(value: Boolean);
    function get_OnlyIfCached: Boolean;
    procedure set_OnlyIfCached(value: Boolean);
    function get_Public: Boolean;
    procedure set_Public(value: Boolean);
    function get_Private: Boolean;
    procedure set_Private(value: Boolean);
    function get_PrivateHeaders: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_MustRevalidate: Boolean;
    procedure set_MustRevalidate(value: Boolean);
    function get_ProxyRevalidate: Boolean;
    procedure set_ProxyRevalidate(value: Boolean);
    function get_Extensions: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property NoCache: Boolean read get_NoCache write set_NoCache;
    property NoCacheHeaders: DDNC.System.Private.CoreLib.DNICollection<string> read get_NoCacheHeaders;
    property NoStore: Boolean read get_NoStore write set_NoStore;
    property MaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_MaxAge write set_MaxAge;
    property SharedMaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_SharedMaxAge write set_SharedMaxAge;
    property MaxStale: Boolean read get_MaxStale write set_MaxStale;
    property MaxStaleLimit: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_MaxStaleLimit write set_MaxStaleLimit;
    property MinFresh: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_MinFresh write set_MinFresh;
    property NoTransform: Boolean read get_NoTransform write set_NoTransform;
    property OnlyIfCached: Boolean read get_OnlyIfCached write set_OnlyIfCached;
    property &Public: Boolean read get_Public write set_Public;
    property &Private: Boolean read get_Private write set_Private;
    property PrivateHeaders: DDNC.System.Private.CoreLib.DNICollection<string> read get_PrivateHeaders;
    property MustRevalidate: Boolean read get_MustRevalidate write set_MustRevalidate;
    property ProxyRevalidate: Boolean read get_ProxyRevalidate write set_ProxyRevalidate;
    property Extensions: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Extensions;
  end;

  TDNCacheControlHeaderValue = class(TDNGenericImport<DNCacheControlHeaderValueClass, DNCacheControlHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNContentDispositionHeaderValueClass = interface(DNObjectClass)
  ['{5177AFA2-42BC-57C0-AE2C-5F38C953DFB7}']
  { constructors } 

    {class} function init(dispositionType: string): DNContentDispositionHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNContentDispositionHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNContentDispositionHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ContentDispositionHeaderValue')]
  DNContentDispositionHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{4DB3304B-F95E-33D9-BCED-153B704ADEDA}']
  { getters & setters } 

    function get_DispositionType: string;
    procedure set_DispositionType(value: string);
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_Name: string;
    procedure set_Name(value: string);
    function get_FileName: string;
    procedure set_FileName(value: string);
    function get_FileNameStar: string;
    procedure set_FileNameStar(value: string);
    function get_CreationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_CreationDate(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_ModificationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_ModificationDate(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_ReadDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_ReadDate(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_Size: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    procedure set_Size(value: DDNC.System.Private.CoreLib.DNNullable<Int64>);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property DispositionType: string read get_DispositionType write set_DispositionType;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property Name: string read get_Name write set_Name;
    property FileName: string read get_FileName write set_FileName;
    property FileNameStar: string read get_FileNameStar write set_FileNameStar;
    property CreationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_CreationDate write set_CreationDate;
    property ModificationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_ModificationDate write set_ModificationDate;
    property ReadDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_ReadDate write set_ReadDate;
    property Size: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_Size write set_Size;
  end;

  TDNContentDispositionHeaderValue = class(TDNGenericImport<DNContentDispositionHeaderValueClass, DNContentDispositionHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNContentRangeHeaderValueClass = interface(DNObjectClass)
  ['{A1F8EC70-A7F6-5B82-B895-C17A39CD72EB}']
  { constructors } 

    {class} function init(from: Int64; &to: Int64; length: Int64): DNContentRangeHeaderValue; overload;
    {class} function init(length: Int64): DNContentRangeHeaderValue; overload;
    {class} function init(from: Int64; &to: Int64): DNContentRangeHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNContentRangeHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNContentRangeHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ContentRangeHeaderValue')]
  DNContentRangeHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{EEB01F17-80AC-3DED-B536-25D65A517617}']
  { getters & setters } 

    function get_Unit: string;
    procedure set_Unit(value: string);
    function get_From: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_To: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_Length: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_HasLength: Boolean;
    function get_HasRange: Boolean;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property &Unit: string read get_Unit write set_Unit;
    property From: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_From;
    property &To: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_To;
    property Length: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_Length;
    property HasLength: Boolean read get_HasLength;
    property HasRange: Boolean read get_HasRange;
  end;

  TDNContentRangeHeaderValue = class(TDNGenericImport<DNContentRangeHeaderValueClass, DNContentRangeHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNEntityTagHeaderValueClass = interface(DNObjectClass)
  ['{3D5F46DC-025B-5360-9E8C-25A1195019C0}']
  { static getter & setter } 

    {class} function get_Any: DNEntityTagHeaderValue;

  { constructors } 

    {class} function init(tag: string): DNEntityTagHeaderValue; overload;
    {class} function init(tag: string; isWeak: Boolean): DNEntityTagHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNEntityTagHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNEntityTagHeaderValue): Boolean;

  { static propertys } 

    {class} property Any: DNEntityTagHeaderValue read get_Any;
  end;

  [DNTypeName('System.Net.Http.Headers.EntityTagHeaderValue')]
  DNEntityTagHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{B67564AA-A3B8-3A32-9FFE-4F21EF8EB532}']
  { getters & setters } 

    function get_Tag: string;
    function get_IsWeak: Boolean;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Tag: string read get_Tag;
    property IsWeak: Boolean read get_IsWeak;
  end;

  TDNEntityTagHeaderValue = class(TDNGenericImport<DNEntityTagHeaderValueClass, DNEntityTagHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpHeadersClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7557B126-7C36-5F74-BDFC-EEB8C71CDA30}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpHeaders')]
  DNHttpHeaders = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{17140D06-6C2A-3A79-A64B-E7D96E364114}']
  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function Remove(name: string): Boolean;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNHttpHeaders = class(TDNGenericImport<DNHttpHeadersClass, DNHttpHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpContentHeadersClass = interface(DNHttpHeadersClass)
  ['{D702AC7C-8862-5783-B1F9-4C4FB468F0F4}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpContentHeaders')]
  DNHttpContentHeaders = interface(DNHttpHeaders)
  ['{2DA28EC2-C123-3F2A-9CC5-2B2A57A91B04}']
  { getters & setters } 

    function get_Allow: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_ContentDisposition: DNContentDispositionHeaderValue;
    procedure set_ContentDisposition(value: DNContentDispositionHeaderValue);
    function get_ContentEncoding: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_ContentLanguage: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_ContentLength: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    procedure set_ContentLength(value: DDNC.System.Private.CoreLib.DNNullable<Int64>);
    function get_ContentLocation: DDNC.System.Private.Uri.DNUri;
    procedure set_ContentLocation(value: DDNC.System.Private.Uri.DNUri);
    function get_ContentMD5: TArray<Byte>;
    procedure set_ContentMD5(value: TArray<Byte>);
    function get_ContentRange: DNContentRangeHeaderValue;
    procedure set_ContentRange(value: DNContentRangeHeaderValue);
    function get_ContentType: DNMediaTypeHeaderValue;
    procedure set_ContentType(value: DNMediaTypeHeaderValue);
    function get_Expires: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_Expires(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_LastModified: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_LastModified(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);

  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function Remove(name: string): Boolean;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Allow: DDNC.System.Private.CoreLib.DNICollection<string> read get_Allow;
    property ContentDisposition: DNContentDispositionHeaderValue read get_ContentDisposition write set_ContentDisposition;
    property ContentEncoding: DDNC.System.Private.CoreLib.DNICollection<string> read get_ContentEncoding;
    property ContentLanguage: DDNC.System.Private.CoreLib.DNICollection<string> read get_ContentLanguage;
    property ContentLength: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_ContentLength write set_ContentLength;
    property ContentLocation: DDNC.System.Private.Uri.DNUri read get_ContentLocation write set_ContentLocation;
    property ContentMD5: TArray<Byte> read get_ContentMD5 write set_ContentMD5;
    property ContentRange: DNContentRangeHeaderValue read get_ContentRange write set_ContentRange;
    property ContentType: DNMediaTypeHeaderValue read get_ContentType write set_ContentType;
    property Expires: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Expires write set_Expires;
    property LastModified: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_LastModified write set_LastModified;
  end;

  TDNHttpContentHeaders = class(TDNGenericImport<DNHttpContentHeadersClass, DNHttpContentHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpRequestHeadersClass = interface(DNHttpHeadersClass)
  ['{47BDBE37-21E1-5B9B-97DE-A6F24507C86B}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpRequestHeaders')]
  DNHttpRequestHeaders = interface(DNHttpHeaders)
  ['{0789C69D-C08F-3666-9400-E98F4718C514}']
  { getters & setters } 

    function get_Accept: DNHttpHeaderValueCollection<DNMediaTypeWithQualityHeaderValue>;
    function get_AcceptCharset: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue>;
    function get_AcceptEncoding: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue>;
    function get_AcceptLanguage: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue>;
    function get_Authorization: DNAuthenticationHeaderValue;
    procedure set_Authorization(value: DNAuthenticationHeaderValue);
    function get_Expect: DNHttpHeaderValueCollection<DNNameValueWithParametersHeaderValue>;
    function get_ExpectContinue: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_ExpectContinue(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_From: string;
    procedure set_From(value: string);
    function get_Host: string;
    procedure set_Host(value: string);
    function get_IfMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue>;
    function get_IfModifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_IfModifiedSince(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_IfNoneMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue>;
    function get_IfRange: DNRangeConditionHeaderValue;
    procedure set_IfRange(value: DNRangeConditionHeaderValue);
    function get_IfUnmodifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_IfUnmodifiedSince(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_MaxForwards: DDNC.System.Private.CoreLib.DNNullable<Int32>;
    procedure set_MaxForwards(value: DDNC.System.Private.CoreLib.DNNullable<Int32>);
    function get_ProxyAuthorization: DNAuthenticationHeaderValue;
    procedure set_ProxyAuthorization(value: DNAuthenticationHeaderValue);
    function get_Range: DNRangeHeaderValue;
    procedure set_Range(value: DNRangeHeaderValue);
    function get_Referrer: DDNC.System.Private.Uri.DNUri;
    procedure set_Referrer(value: DDNC.System.Private.Uri.DNUri);
    function get_TE: DNHttpHeaderValueCollection<DNTransferCodingWithQualityHeaderValue>;
    function get_UserAgent: DNHttpHeaderValueCollection<DNProductInfoHeaderValue>;
    function get_CacheControl: DNCacheControlHeaderValue;
    procedure set_CacheControl(value: DNCacheControlHeaderValue);
    function get_Connection: DNHttpHeaderValueCollection<string>;
    function get_ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_ConnectionClose(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_Date(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue>;
    function get_Trailer: DNHttpHeaderValueCollection<string>;
    function get_TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue>;
    function get_TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_TransferEncodingChunked(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue>;
    function get_Via: DNHttpHeaderValueCollection<DNViaHeaderValue>;
    function get_Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue>;

  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function Remove(name: string): Boolean;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Accept: DNHttpHeaderValueCollection<DNMediaTypeWithQualityHeaderValue> read get_Accept;
    property AcceptCharset: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue> read get_AcceptCharset;
    property AcceptEncoding: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue> read get_AcceptEncoding;
    property AcceptLanguage: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue> read get_AcceptLanguage;
    property Authorization: DNAuthenticationHeaderValue read get_Authorization write set_Authorization;
    property Expect: DNHttpHeaderValueCollection<DNNameValueWithParametersHeaderValue> read get_Expect;
    property ExpectContinue: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_ExpectContinue write set_ExpectContinue;
    property From: string read get_From write set_From;
    property Host: string read get_Host write set_Host;
    property IfMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue> read get_IfMatch;
    property IfModifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_IfModifiedSince write set_IfModifiedSince;
    property IfNoneMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue> read get_IfNoneMatch;
    property IfRange: DNRangeConditionHeaderValue read get_IfRange write set_IfRange;
    property IfUnmodifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_IfUnmodifiedSince write set_IfUnmodifiedSince;
    property MaxForwards: DDNC.System.Private.CoreLib.DNNullable<Int32> read get_MaxForwards write set_MaxForwards;
    property ProxyAuthorization: DNAuthenticationHeaderValue read get_ProxyAuthorization write set_ProxyAuthorization;
    property Range: DNRangeHeaderValue read get_Range write set_Range;
    property Referrer: DDNC.System.Private.Uri.DNUri read get_Referrer write set_Referrer;
    property TE: DNHttpHeaderValueCollection<DNTransferCodingWithQualityHeaderValue> read get_TE;
    property UserAgent: DNHttpHeaderValueCollection<DNProductInfoHeaderValue> read get_UserAgent;
    property CacheControl: DNCacheControlHeaderValue read get_CacheControl write set_CacheControl;
    property Connection: DNHttpHeaderValueCollection<string> read get_Connection;
    property ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_ConnectionClose write set_ConnectionClose;
    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date write set_Date;
    property Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue> read get_Pragma;
    property Trailer: DNHttpHeaderValueCollection<string> read get_Trailer;
    property TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue> read get_TransferEncoding;
    property TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_TransferEncodingChunked write set_TransferEncodingChunked;
    property Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue> read get_Upgrade;
    property Via: DNHttpHeaderValueCollection<DNViaHeaderValue> read get_Via;
    property Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue> read get_Warning;
  end;

  TDNHttpRequestHeaders = class(TDNGenericImport<DNHttpRequestHeadersClass, DNHttpRequestHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpResponseHeadersClass = interface(DNHttpHeadersClass)
  ['{45895049-CA92-5BBE-BE3F-7D56E1947234}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpResponseHeaders')]
  DNHttpResponseHeaders = interface(DNHttpHeaders)
  ['{F46025CF-BCD4-3F3C-82C9-B27B1DA680CA}']
  { getters & setters } 

    function get_AcceptRanges: DNHttpHeaderValueCollection<string>;
    function get_Age: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_Age(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_ETag: DNEntityTagHeaderValue;
    procedure set_ETag(value: DNEntityTagHeaderValue);
    function get_Location: DDNC.System.Private.Uri.DNUri;
    procedure set_Location(value: DDNC.System.Private.Uri.DNUri);
    function get_ProxyAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue>;
    function get_RetryAfter: DNRetryConditionHeaderValue;
    procedure set_RetryAfter(value: DNRetryConditionHeaderValue);
    function get_Server: DNHttpHeaderValueCollection<DNProductInfoHeaderValue>;
    function get_Vary: DNHttpHeaderValueCollection<string>;
    function get_WwwAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue>;
    function get_CacheControl: DNCacheControlHeaderValue;
    procedure set_CacheControl(value: DNCacheControlHeaderValue);
    function get_Connection: DNHttpHeaderValueCollection<string>;
    function get_ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_ConnectionClose(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_Date(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue>;
    function get_Trailer: DNHttpHeaderValueCollection<string>;
    function get_TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue>;
    function get_TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_TransferEncodingChunked(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue>;
    function get_Via: DNHttpHeaderValueCollection<DNViaHeaderValue>;
    function get_Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue>;

  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function Remove(name: string): Boolean;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AcceptRanges: DNHttpHeaderValueCollection<string> read get_AcceptRanges;
    property Age: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_Age write set_Age;
    property ETag: DNEntityTagHeaderValue read get_ETag write set_ETag;
    property Location: DDNC.System.Private.Uri.DNUri read get_Location write set_Location;
    property ProxyAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue> read get_ProxyAuthenticate;
    property RetryAfter: DNRetryConditionHeaderValue read get_RetryAfter write set_RetryAfter;
    property Server: DNHttpHeaderValueCollection<DNProductInfoHeaderValue> read get_Server;
    property Vary: DNHttpHeaderValueCollection<string> read get_Vary;
    property WwwAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue> read get_WwwAuthenticate;
    property CacheControl: DNCacheControlHeaderValue read get_CacheControl write set_CacheControl;
    property Connection: DNHttpHeaderValueCollection<string> read get_Connection;
    property ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_ConnectionClose write set_ConnectionClose;
    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date write set_Date;
    property Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue> read get_Pragma;
    property Trailer: DNHttpHeaderValueCollection<string> read get_Trailer;
    property TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue> read get_TransferEncoding;
    property TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_TransferEncodingChunked write set_TransferEncodingChunked;
    property Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue> read get_Upgrade;
    property Via: DNHttpHeaderValueCollection<DNViaHeaderValue> read get_Via;
    property Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue> read get_Warning;
  end;

  TDNHttpResponseHeaders = class(TDNGenericImport<DNHttpResponseHeadersClass, DNHttpResponseHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpHeaderValueCollectionClass<T> = interface(DNObjectClass)
  ['{C48499B8-7204-5B7C-A418-36755F361114}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpHeaderValueCollection`1')]
  DNHttpHeaderValueCollection<T> = interface(DDNC.System.Private.CoreLib.DNICollection<T>)
  ['{64E47DA9-19D3-3B2C-A9A8-F0928A7AC349}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;

  { methods } 

    procedure ParseAdd(input: string);
    function TryParseAdd(input: string): Boolean;
    function &Contains(item: T): Boolean;
    procedure CopyTo(&array: TArray<T>; arrayIndex: Int32);
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<T>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
  end;

  TDNHttpHeaderValueCollection<T> = class(TDNGenericImport<DNHttpHeaderValueCollectionClass<T>, DNHttpHeaderValueCollection<T>>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNMediaTypeHeaderValueClass = interface(DNObjectClass)
  ['{4B7A19A3-6E6F-5C7C-8116-62D00A02C727}']
  { constructors } 

    {class} function init(mediaType: string): DNMediaTypeHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNMediaTypeHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNMediaTypeHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.MediaTypeHeaderValue')]
  DNMediaTypeHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{73B1BF30-0030-3A8D-876A-94CEFFE00777}']
  { getters & setters } 

    function get_CharSet: string;
    procedure set_CharSet(value: string);
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_MediaType: string;
    procedure set_MediaType(value: string);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CharSet: string read get_CharSet write set_CharSet;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property MediaType: string read get_MediaType write set_MediaType;
  end;

  TDNMediaTypeHeaderValue = class(TDNGenericImport<DNMediaTypeHeaderValueClass, DNMediaTypeHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNMediaTypeWithQualityHeaderValueClass = interface(DNMediaTypeHeaderValueClass)
  ['{77E784BB-0D66-5068-8B86-D9A3CCB18D5B}']
  { constructors } 

    {class} function init(mediaType: string): DNMediaTypeWithQualityHeaderValue; overload;
    {class} function init(mediaType: string; quality: Double): DNMediaTypeWithQualityHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNMediaTypeWithQualityHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNMediaTypeWithQualityHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.MediaTypeWithQualityHeaderValue')]
  DNMediaTypeWithQualityHeaderValue = interface(DNMediaTypeHeaderValue)
  ['{E76915FF-7422-37F1-95A3-ED6DCEE5A5C2}']
  { getters & setters } 

    function get_Quality: DDNC.System.Private.CoreLib.DNNullable<Double>;
    procedure set_Quality(value: DDNC.System.Private.CoreLib.DNNullable<Double>);
    function get_CharSet: string;
    procedure set_CharSet(value: string);
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_MediaType: string;
    procedure set_MediaType(value: string);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Quality: DDNC.System.Private.CoreLib.DNNullable<Double> read get_Quality write set_Quality;
    property CharSet: string read get_CharSet write set_CharSet;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property MediaType: string read get_MediaType write set_MediaType;
  end;

  TDNMediaTypeWithQualityHeaderValue = class(TDNGenericImport<DNMediaTypeWithQualityHeaderValueClass, DNMediaTypeWithQualityHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNNameValueHeaderValueClass = interface(DNObjectClass)
  ['{AE4156DE-AA10-5386-A208-EB85D675E97D}']
  { constructors } 

    {class} function init(name: string): DNNameValueHeaderValue; overload;
    {class} function init(name: string; value: string): DNNameValueHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNNameValueHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNNameValueHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.NameValueHeaderValue')]
  DNNameValueHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{AE459E5F-B437-3A1A-8DCF-B343E94C4B57}']
  { getters & setters } 

    function get_Name: string;
    function get_Value: string;
    procedure set_Value(value: string);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Value: string read get_Value write set_Value;
  end;

  TDNNameValueHeaderValue = class(TDNGenericImport<DNNameValueHeaderValueClass, DNNameValueHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNNameValueWithParametersHeaderValueClass = interface(DNNameValueHeaderValueClass)
  ['{70633B62-A7D3-5739-85DA-B0FFF742C259}']
  { constructors } 

    {class} function init(name: string): DNNameValueWithParametersHeaderValue; overload;
    {class} function init(name: string; value: string): DNNameValueWithParametersHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNNameValueWithParametersHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNNameValueWithParametersHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.NameValueWithParametersHeaderValue')]
  DNNameValueWithParametersHeaderValue = interface(DNNameValueHeaderValue)
  ['{A9B156F5-3055-3504-AD99-070A2FB280C5}']
  { getters & setters } 

    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_Name: string;
    function get_Value: string;
    procedure set_Value(value: string);

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property Name: string read get_Name;
    property Value: string read get_Value write set_Value;
  end;

  TDNNameValueWithParametersHeaderValue = class(TDNGenericImport<DNNameValueWithParametersHeaderValueClass, DNNameValueWithParametersHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNProductHeaderValueClass = interface(DNObjectClass)
  ['{CCE45816-5E72-5E4D-B027-F24132F44828}']
  { constructors } 

    {class} function init(name: string): DNProductHeaderValue; overload;
    {class} function init(name: string; version: string): DNProductHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNProductHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNProductHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ProductHeaderValue')]
  DNProductHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{D28D359D-3F98-33A6-9F0E-E4C702A1ABA5}']
  { getters & setters } 

    function get_Name: string;
    function get_Version: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Version: string read get_Version;
  end;

  TDNProductHeaderValue = class(TDNGenericImport<DNProductHeaderValueClass, DNProductHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNProductInfoHeaderValueClass = interface(DNObjectClass)
  ['{2AB226BE-D1AE-5B73-B0CE-07FDD68B5753}']
  { constructors } 

    {class} function init(productName: string; productVersion: string): DNProductInfoHeaderValue; overload;
    {class} function init(product: DNProductHeaderValue): DNProductInfoHeaderValue; overload;
    {class} function init(comment: string): DNProductInfoHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNProductInfoHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNProductInfoHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ProductInfoHeaderValue')]
  DNProductInfoHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{8689A0E8-8954-34F2-8968-61F54FD0C9DB}']
  { getters & setters } 

    function get_Product: DNProductHeaderValue;
    function get_Comment: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Product: DNProductHeaderValue read get_Product;
    property Comment: string read get_Comment;
  end;

  TDNProductInfoHeaderValue = class(TDNGenericImport<DNProductInfoHeaderValueClass, DNProductInfoHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRangeConditionHeaderValueClass = interface(DNObjectClass)
  ['{89C6D171-8A69-579E-BAB6-5FC2657BEF72}']
  { constructors } 

    {class} function init(date: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNRangeConditionHeaderValue; overload;
    {class} function init(entityTag: DNEntityTagHeaderValue): DNRangeConditionHeaderValue; overload;
    {class} function init(entityTag: string): DNRangeConditionHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNRangeConditionHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNRangeConditionHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.RangeConditionHeaderValue')]
  DNRangeConditionHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{8C693EC9-6948-329C-B02C-AA42635445B9}']
  { getters & setters } 

    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    function get_EntityTag: DNEntityTagHeaderValue;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date;
    property EntityTag: DNEntityTagHeaderValue read get_EntityTag;
  end;

  TDNRangeConditionHeaderValue = class(TDNGenericImport<DNRangeConditionHeaderValueClass, DNRangeConditionHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRangeHeaderValueClass = interface(DNObjectClass)
  ['{63A393F7-2249-5847-87FC-91CFD6D333ED}']
  { constructors } 

    {class} function init: DNRangeHeaderValue; overload;
    {class} function init(from: DDNC.System.Private.CoreLib.DNNullable<Int64>; &to: DDNC.System.Private.CoreLib.DNNullable<Int64>): DNRangeHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNRangeHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNRangeHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.RangeHeaderValue')]
  DNRangeHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{62B6DEE1-1897-3469-A884-27CB847EAA28}']
  { getters & setters } 

    function get_Unit: string;
    procedure set_Unit(value: string);
    function get_Ranges: DDNC.System.Private.CoreLib.DNICollection<DNRangeItemHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property &Unit: string read get_Unit write set_Unit;
    property Ranges: DDNC.System.Private.CoreLib.DNICollection<DNRangeItemHeaderValue> read get_Ranges;
  end;

  TDNRangeHeaderValue = class(TDNGenericImport<DNRangeHeaderValueClass, DNRangeHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRangeItemHeaderValueClass = interface(DNObjectClass)
  ['{F39206BB-EE3B-5B9B-81DE-D186282F59C6}']
  { constructors } 

    {class} function init(from: DDNC.System.Private.CoreLib.DNNullable<Int64>; &to: DDNC.System.Private.CoreLib.DNNullable<Int64>): DNRangeItemHeaderValue;

  end;

  [DNTypeName('System.Net.Http.Headers.RangeItemHeaderValue')]
  DNRangeItemHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{5ACEACB5-3DAE-3488-9B6D-C73965B692B6}']
  { getters & setters } 

    function get_From: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_To: DDNC.System.Private.CoreLib.DNNullable<Int64>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property From: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_From;
    property &To: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_To;
  end;

  TDNRangeItemHeaderValue = class(TDNGenericImport<DNRangeItemHeaderValueClass, DNRangeItemHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRetryConditionHeaderValueClass = interface(DNObjectClass)
  ['{3813E7C0-3110-57AA-9E11-2C6D1BC95D9B}']
  { constructors } 

    {class} function init(date: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNRetryConditionHeaderValue; overload;
    {class} function init(delta: DDNC.System.Private.CoreLib.DNTimeSpan): DNRetryConditionHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNRetryConditionHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNRetryConditionHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.RetryConditionHeaderValue')]
  DNRetryConditionHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{5008ED16-F228-35CE-9E14-D1A02C9C7AA2}']
  { getters & setters } 

    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    function get_Delta: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date;
    property Delta: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_Delta;
  end;

  TDNRetryConditionHeaderValue = class(TDNGenericImport<DNRetryConditionHeaderValueClass, DNRetryConditionHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNStringWithQualityHeaderValueClass = interface(DNObjectClass)
  ['{80E1E6F9-9299-51B1-B10B-11889B2B2DFE}']
  { constructors } 

    {class} function init(value: string): DNStringWithQualityHeaderValue; overload;
    {class} function init(value: string; quality: Double): DNStringWithQualityHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNStringWithQualityHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNStringWithQualityHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.StringWithQualityHeaderValue')]
  DNStringWithQualityHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{A7E4FB2A-54DF-3A46-8368-EEE67303C181}']
  { getters & setters } 

    function get_Value: string;
    function get_Quality: DDNC.System.Private.CoreLib.DNNullable<Double>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Value: string read get_Value;
    property Quality: DDNC.System.Private.CoreLib.DNNullable<Double> read get_Quality;
  end;

  TDNStringWithQualityHeaderValue = class(TDNGenericImport<DNStringWithQualityHeaderValueClass, DNStringWithQualityHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNTransferCodingHeaderValueClass = interface(DNObjectClass)
  ['{8764DC4D-0873-58F6-9650-C5DE90BFD54E}']
  { constructors } 

    {class} function init(value: string): DNTransferCodingHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNTransferCodingHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNTransferCodingHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.TransferCodingHeaderValue')]
  DNTransferCodingHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{D991EB4C-D57C-3226-8C01-77720E10AB77}']
  { getters & setters } 

    function get_Value: string;
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Value: string read get_Value;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
  end;

  TDNTransferCodingHeaderValue = class(TDNGenericImport<DNTransferCodingHeaderValueClass, DNTransferCodingHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNTransferCodingWithQualityHeaderValueClass = interface(DNTransferCodingHeaderValueClass)
  ['{B2318932-5239-59DB-9D02-0DEFA42A6CC1}']
  { constructors } 

    {class} function init(value: string): DNTransferCodingWithQualityHeaderValue; overload;
    {class} function init(value: string; quality: Double): DNTransferCodingWithQualityHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNTransferCodingWithQualityHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNTransferCodingWithQualityHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.TransferCodingWithQualityHeaderValue')]
  DNTransferCodingWithQualityHeaderValue = interface(DNTransferCodingHeaderValue)
  ['{0B868CDD-243C-3136-A4E8-EF2C68250FF1}']
  { getters & setters } 

    function get_Quality: DDNC.System.Private.CoreLib.DNNullable<Double>;
    procedure set_Quality(value: DDNC.System.Private.CoreLib.DNNullable<Double>);
    function get_Value: string;
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Quality: DDNC.System.Private.CoreLib.DNNullable<Double> read get_Quality write set_Quality;
    property Value: string read get_Value;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
  end;

  TDNTransferCodingWithQualityHeaderValue = class(TDNGenericImport<DNTransferCodingWithQualityHeaderValueClass, DNTransferCodingWithQualityHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNViaHeaderValueClass = interface(DNObjectClass)
  ['{89071F47-0551-5DB1-BF4B-E8C3F0FD5359}']
  { constructors } 

    {class} function init(protocolVersion: string; receivedBy: string): DNViaHeaderValue; overload;
    {class} function init(protocolVersion: string; receivedBy: string; protocolName: string): DNViaHeaderValue; overload;
    {class} function init(protocolVersion: string; receivedBy: string; protocolName: string; comment: string): DNViaHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNViaHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNViaHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ViaHeaderValue')]
  DNViaHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{403BA9DB-3313-33B9-B461-C6167663F35E}']
  { getters & setters } 

    function get_ProtocolName: string;
    function get_ProtocolVersion: string;
    function get_ReceivedBy: string;
    function get_Comment: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ProtocolName: string read get_ProtocolName;
    property ProtocolVersion: string read get_ProtocolVersion;
    property ReceivedBy: string read get_ReceivedBy;
    property Comment: string read get_Comment;
  end;

  TDNViaHeaderValue = class(TDNGenericImport<DNViaHeaderValueClass, DNViaHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNWarningHeaderValueClass = interface(DNObjectClass)
  ['{E9200061-1A25-5B31-8EB2-2503A07996BC}']
  { constructors } 

    {class} function init(code: Int32; agent: string; text: string): DNWarningHeaderValue; overload;
    {class} function init(code: Int32; agent: string; text: string; date: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNWarningHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNWarningHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNWarningHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.WarningHeaderValue')]
  DNWarningHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{4084E1F7-68CC-33FD-A998-630582A51DD9}']
  { getters & setters } 

    function get_Code: Int32;
    function get_Agent: string;
    function get_Text: string;
    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Code: Int32 read get_Code;
    property Agent: string read get_Agent;
    property Text: string read get_Text;
    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date;
  end;

  TDNWarningHeaderValue = class(TDNGenericImport<DNWarningHeaderValueClass, DNWarningHeaderValue>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpContentClass = interface(DNObjectClass)
  ['{3368F91D-F53F-57B0-A28F-E2B137D79772}']
  end;

  [DNTypeName('System.Net.Http.HttpContent')]
  DNHttpContent = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{AEDB25CF-F3CC-3F25-8381-91CF10DF0C95}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNHttpContent = class(TDNGenericImport<DNHttpContentClass, DNHttpContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNByteArrayContentClass = interface(DNHttpContentClass)
  ['{252B5EBF-1D6D-5034-9F7A-12798E87613B}']
  { constructors } 

    {class} function init(content: TArray<Byte>): DNByteArrayContent; overload;
    {class} function init(content: TArray<Byte>; offset: Int32; count: Int32): DNByteArrayContent; overload;

  end;

  [DNTypeName('System.Net.Http.ByteArrayContent')]
  DNByteArrayContent = interface(DNHttpContent)
  ['{FA7EA849-5CFC-3F8D-B9C5-587E583643A4}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNByteArrayContent = class(TDNGenericImport<DNByteArrayContentClass, DNByteArrayContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNFormUrlEncodedContentClass = interface(DNByteArrayContentClass)
  ['{A554BD0A-1CBD-5763-80D0-85CC9E104EE6}']
  { constructors } 

    {class} function init(nameValueCollection: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, string>>): DNFormUrlEncodedContent;

  end;

  [DNTypeName('System.Net.Http.FormUrlEncodedContent')]
  DNFormUrlEncodedContent = interface(DNByteArrayContent)
  ['{8A22596B-509D-3609-B34E-7B9CB70D834D}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNFormUrlEncodedContent = class(TDNGenericImport<DNFormUrlEncodedContentClass, DNFormUrlEncodedContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNStringContentClass = interface(DNByteArrayContentClass)
  ['{3504A7CE-D479-5128-87A5-92E7081722FD}']
  { constructors } 

    {class} function init(content: string): DNStringContent; overload;
    {class} function init(content: string; encoding: DDNC.System.Private.CoreLib.DNEncoding): DNStringContent; overload;
    {class} function init(content: string; encoding: DDNC.System.Private.CoreLib.DNEncoding; mediaType: string): DNStringContent; overload;

  end;

  [DNTypeName('System.Net.Http.StringContent')]
  DNStringContent = interface(DNByteArrayContent)
  ['{7596EF1A-565A-3766-9023-9598D2A61625}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNStringContent = class(TDNGenericImport<DNStringContentClass, DNStringContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNMultipartContentClass = interface(DNHttpContentClass)
  ['{890FE71D-4A9E-5B09-B041-22B3C8399F99}']
  { constructors } 

    {class} function init: DNMultipartContent; overload;
    {class} function init(subtype: string): DNMultipartContent; overload;
    {class} function init(subtype: string; boundary: string): DNMultipartContent; overload;

  end;

  [DNTypeName('System.Net.Http.MultipartContent')]
  DNMultipartContent = interface(DNHttpContent)
  ['{B0B91F62-EBF9-3497-875E-D8A6A5C89F7F}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    procedure Add(content: DNHttpContent);
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNHttpContent>;
    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNMultipartContent = class(TDNGenericImport<DNMultipartContentClass, DNMultipartContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNMultipartFormDataContentClass = interface(DNMultipartContentClass)
  ['{EBB4981F-8F46-5157-A54C-EEEE431BA6BF}']
  { constructors } 

    {class} function init: DNMultipartFormDataContent; overload;
    {class} function init(boundary: string): DNMultipartFormDataContent; overload;

  end;

  [DNTypeName('System.Net.Http.MultipartFormDataContent')]
  DNMultipartFormDataContent = interface(DNMultipartContent)
  ['{BA8CED81-002B-38B9-8896-69065FFF1518}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    procedure Add(content: DNHttpContent); overload;
    procedure Add(content: DNHttpContent; name: string); overload;
    procedure Add(content: DNHttpContent; name: string; fileName: string); overload;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNHttpContent>;
    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNMultipartFormDataContent = class(TDNGenericImport<DNMultipartFormDataContentClass, DNMultipartFormDataContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNReadOnlyMemoryContentClass = interface(DNHttpContentClass)
  ['{3B469772-6EE1-53F0-A60F-C03A56F3F8BF}']
  { constructors } 

    {class} function init(content: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>): DNReadOnlyMemoryContent;

  end;

  [DNTypeName('System.Net.Http.ReadOnlyMemoryContent')]
  DNReadOnlyMemoryContent = interface(DNHttpContent)
  ['{E141BB0E-F949-3874-B984-E41347AD19E8}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNReadOnlyMemoryContent = class(TDNGenericImport<DNReadOnlyMemoryContentClass, DNReadOnlyMemoryContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNStreamContentClass = interface(DNHttpContentClass)
  ['{0648DE19-4C42-5B17-A8E1-2CE9824D7F2A}']
  { constructors } 

    {class} function init(content: DDNC.System.Private.CoreLib.DNStream): DNStreamContent; overload;
    {class} function init(content: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DNStreamContent; overload;

  end;

  [DNTypeName('System.Net.Http.StreamContent')]
  DNStreamContent = interface(DNHttpContent)
  ['{AA763452-2C19-3A76-BC65-180C51A3E01A}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNStreamContent = class(TDNGenericImport<DNStreamContentClass, DNStreamContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpMessageHandlerClass = interface(DNObjectClass)
  ['{65BA30A4-D4B2-50CB-ADB7-D7FC07499BCB}']
  end;

  [DNTypeName('System.Net.Http.HttpMessageHandler')]
  DNHttpMessageHandler = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{8FDDD840-3D88-3BFA-BCF1-F1B2562C9974}']
  { methods } 

    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNHttpMessageHandler = class(TDNGenericImport<DNHttpMessageHandlerClass, DNHttpMessageHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNDelegatingHandlerClass = interface(DNHttpMessageHandlerClass)
  ['{21D64C7C-C95B-5B48-A335-0879D5B23A9D}']
  end;

  [DNTypeName('System.Net.Http.DelegatingHandler')]
  DNDelegatingHandler = interface(DNHttpMessageHandler)
  ['{40BC793F-9F57-3D73-B09E-207EEBF6B600}']
  { getters & setters } 

    function get_InnerHandler: DNHttpMessageHandler;
    procedure set_InnerHandler(value: DNHttpMessageHandler);

  { methods } 

    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property InnerHandler: DNHttpMessageHandler read get_InnerHandler write set_InnerHandler;
  end;

  TDNDelegatingHandler = class(TDNGenericImport<DNDelegatingHandlerClass, DNDelegatingHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNMessageProcessingHandlerClass = interface(DNDelegatingHandlerClass)
  ['{231E2E71-C76E-5ECA-A118-0F4B2158503D}']
  end;

  [DNTypeName('System.Net.Http.MessageProcessingHandler')]
  DNMessageProcessingHandler = interface(DNDelegatingHandler)
  ['{B830EC91-7604-34ED-87FE-C9FF4EB69BBF}']
  { getters & setters } 

    function get_InnerHandler: DNHttpMessageHandler;
    procedure set_InnerHandler(value: DNHttpMessageHandler);

  { methods } 

    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property InnerHandler: DNHttpMessageHandler read get_InnerHandler write set_InnerHandler;
  end;

  TDNMessageProcessingHandler = class(TDNGenericImport<DNMessageProcessingHandlerClass, DNMessageProcessingHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpClientHandlerClass = interface(DNHttpMessageHandlerClass)
  ['{7943932F-1C61-535A-95B1-8030DC023C3E}']
  { static getter & setter } 

    {class} function get_DangerousAcceptAnyServerCertificateValidator: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean>;

  { constructors } 

    {class} function init: DNHttpClientHandler;

  { static propertys } 

    {class} property DangerousAcceptAnyServerCertificateValidator: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean> read get_DangerousAcceptAnyServerCertificateValidator;
  end;

  [DNTypeName('System.Net.Http.HttpClientHandler')]
  DNHttpClientHandler = interface(DNHttpMessageHandler)
  ['{76BD295A-7CBA-3BEE-87DC-7B81F38B4063}']
  { getters & setters } 

    function get_MaxRequestContentBufferSize: Int64;
    procedure set_MaxRequestContentBufferSize(value: Int64);
    function get_SupportsAutomaticDecompression: Boolean;
    function get_SupportsProxy: Boolean;
    function get_SupportsRedirectConfiguration: Boolean;
    function get_UseCookies: Boolean;
    procedure set_UseCookies(value: Boolean);
    function get_CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer;
    procedure set_CookieContainer(value: DDNC.System.Net.Primitives.DNCookieContainer);
    function get_AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods;
    procedure set_AutomaticDecompression(value: DDNC.System.Net.Primitives.DNDecompressionMethods);
    function get_UseProxy: Boolean;
    procedure set_UseProxy(value: Boolean);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_DefaultProxyCredentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_UseDefaultCredentials: Boolean;
    procedure set_UseDefaultCredentials(value: Boolean);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_AllowAutoRedirect: Boolean;
    procedure set_AllowAutoRedirect(value: Boolean);
    function get_MaxAutomaticRedirections: Int32;
    procedure set_MaxAutomaticRedirections(value: Int32);
    function get_MaxConnectionsPerServer: Int32;
    procedure set_MaxConnectionsPerServer(value: Int32);
    function get_MaxResponseHeadersLength: Int32;
    procedure set_MaxResponseHeadersLength(value: Int32);
    function get_ClientCertificateOptions: DNClientCertificateOption;
    procedure set_ClientCertificateOptions(value: DNClientCertificateOption);
    function get_ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection;
    function get_ServerCertificateCustomValidationCallback: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean>;
    procedure set_ServerCertificateCustomValidationCallback(value: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean>);
    function get_CheckCertificateRevocationList: Boolean;
    procedure set_CheckCertificateRevocationList(value: Boolean);
    function get_SslProtocols: DDNC.System.Net.Primitives.DNSslProtocols;
    procedure set_SslProtocols(value: DDNC.System.Net.Primitives.DNSslProtocols);
    function get_Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject>;

  { methods } 

    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property MaxRequestContentBufferSize: Int64 read get_MaxRequestContentBufferSize write set_MaxRequestContentBufferSize;
    property SupportsAutomaticDecompression: Boolean read get_SupportsAutomaticDecompression;
    property SupportsProxy: Boolean read get_SupportsProxy;
    property SupportsRedirectConfiguration: Boolean read get_SupportsRedirectConfiguration;
    property UseCookies: Boolean read get_UseCookies write set_UseCookies;
    property CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer read get_CookieContainer write set_CookieContainer;
    property AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods read get_AutomaticDecompression write set_AutomaticDecompression;
    property UseProxy: Boolean read get_UseProxy write set_UseProxy;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials read get_DefaultProxyCredentials write set_DefaultProxyCredentials;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property UseDefaultCredentials: Boolean read get_UseDefaultCredentials write set_UseDefaultCredentials;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property AllowAutoRedirect: Boolean read get_AllowAutoRedirect write set_AllowAutoRedirect;
    property MaxAutomaticRedirections: Int32 read get_MaxAutomaticRedirections write set_MaxAutomaticRedirections;
    property MaxConnectionsPerServer: Int32 read get_MaxConnectionsPerServer write set_MaxConnectionsPerServer;
    property MaxResponseHeadersLength: Int32 read get_MaxResponseHeadersLength write set_MaxResponseHeadersLength;
    property ClientCertificateOptions: DNClientCertificateOption read get_ClientCertificateOptions write set_ClientCertificateOptions;
    property ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection read get_ClientCertificates;
    property ServerCertificateCustomValidationCallback: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean> read get_ServerCertificateCustomValidationCallback write set_ServerCertificateCustomValidationCallback;
    property CheckCertificateRevocationList: Boolean read get_CheckCertificateRevocationList write set_CheckCertificateRevocationList;
    property SslProtocols: DDNC.System.Net.Primitives.DNSslProtocols read get_SslProtocols write set_SslProtocols;
    property Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Properties;
  end;

  TDNHttpClientHandler = class(TDNGenericImport<DNHttpClientHandlerClass, DNHttpClientHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNSocketsHttpHandlerClass = interface(DNHttpMessageHandlerClass)
  ['{1CAE1342-FF17-522E-885E-C92F2922B14C}']
  { constructors } 

    {class} function init: DNSocketsHttpHandler;

  end;

  [DNTypeName('System.Net.Http.SocketsHttpHandler')]
  DNSocketsHttpHandler = interface(DNHttpMessageHandler)
  ['{63E38AF0-65C4-3EE5-9111-F527829F16D8}']
  { getters & setters } 

    function get_UseCookies: Boolean;
    procedure set_UseCookies(value: Boolean);
    function get_CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer;
    procedure set_CookieContainer(value: DDNC.System.Net.Primitives.DNCookieContainer);
    function get_AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods;
    procedure set_AutomaticDecompression(value: DDNC.System.Net.Primitives.DNDecompressionMethods);
    function get_UseProxy: Boolean;
    procedure set_UseProxy(value: Boolean);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_DefaultProxyCredentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_AllowAutoRedirect: Boolean;
    procedure set_AllowAutoRedirect(value: Boolean);
    function get_MaxAutomaticRedirections: Int32;
    procedure set_MaxAutomaticRedirections(value: Int32);
    function get_MaxConnectionsPerServer: Int32;
    procedure set_MaxConnectionsPerServer(value: Int32);
    function get_MaxResponseDrainSize: Int32;
    procedure set_MaxResponseDrainSize(value: Int32);
    function get_ResponseDrainTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_ResponseDrainTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_MaxResponseHeadersLength: Int32;
    procedure set_MaxResponseHeadersLength(value: Int32);
    function get_SslOptions: DDNC.System.Net.Security.DNSslClientAuthenticationOptions;
    procedure set_SslOptions(value: DDNC.System.Net.Security.DNSslClientAuthenticationOptions);
    function get_PooledConnectionLifetime: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PooledConnectionLifetime(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_PooledConnectionIdleTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PooledConnectionIdleTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_ConnectTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_ConnectTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_Expect100ContinueTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Expect100ContinueTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject>;

  { methods } 

    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property UseCookies: Boolean read get_UseCookies write set_UseCookies;
    property CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer read get_CookieContainer write set_CookieContainer;
    property AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods read get_AutomaticDecompression write set_AutomaticDecompression;
    property UseProxy: Boolean read get_UseProxy write set_UseProxy;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials read get_DefaultProxyCredentials write set_DefaultProxyCredentials;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property AllowAutoRedirect: Boolean read get_AllowAutoRedirect write set_AllowAutoRedirect;
    property MaxAutomaticRedirections: Int32 read get_MaxAutomaticRedirections write set_MaxAutomaticRedirections;
    property MaxConnectionsPerServer: Int32 read get_MaxConnectionsPerServer write set_MaxConnectionsPerServer;
    property MaxResponseDrainSize: Int32 read get_MaxResponseDrainSize write set_MaxResponseDrainSize;
    property ResponseDrainTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_ResponseDrainTimeout write set_ResponseDrainTimeout;
    property MaxResponseHeadersLength: Int32 read get_MaxResponseHeadersLength write set_MaxResponseHeadersLength;
    property SslOptions: DDNC.System.Net.Security.DNSslClientAuthenticationOptions read get_SslOptions write set_SslOptions;
    property PooledConnectionLifetime: DDNC.System.Private.CoreLib.DNTimeSpan read get_PooledConnectionLifetime write set_PooledConnectionLifetime;
    property PooledConnectionIdleTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_PooledConnectionIdleTimeout write set_PooledConnectionIdleTimeout;
    property ConnectTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_ConnectTimeout write set_ConnectTimeout;
    property Expect100ContinueTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Expect100ContinueTimeout write set_Expect100ContinueTimeout;
    property Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Properties;
  end;

  TDNSocketsHttpHandler = class(TDNGenericImport<DNSocketsHttpHandlerClass, DNSocketsHttpHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpMessageInvokerClass = interface(DNObjectClass)
  ['{823BBDC1-6794-5079-8830-8C2DB89FDA1E}']
  { constructors } 

    {class} function init(handler: DNHttpMessageHandler): DNHttpMessageInvoker; overload;
    {class} function init(handler: DNHttpMessageHandler; disposeHandler: Boolean): DNHttpMessageInvoker; overload;

  end;

  [DNTypeName('System.Net.Http.HttpMessageInvoker')]
  DNHttpMessageInvoker = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{D572A47A-22E4-37A5-8C6F-5C0613AD09D6}']
  { methods } 

    function SendAsync(request: DNHttpRequestMessage; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNHttpMessageInvoker = class(TDNGenericImport<DNHttpMessageInvokerClass, DNHttpMessageInvoker>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpClientClass = interface(DNHttpMessageInvokerClass)
  ['{902A467E-DB42-5E5F-9BB8-2BEB783C06A8}']
  { constructors } 

    {class} function init: DNHttpClient; overload;
    {class} function init(handler: DNHttpMessageHandler): DNHttpClient; overload;
    {class} function init(handler: DNHttpMessageHandler; disposeHandler: Boolean): DNHttpClient; overload;

  end;

  [DNTypeName('System.Net.Http.HttpClient')]
  DNHttpClient = interface(DNHttpMessageInvoker)
  ['{138D7B22-61B5-3856-A378-FDB41198114B}']
  { getters & setters } 

    function get_DefaultRequestHeaders: DNHttpRequestHeaders;
    function get_BaseAddress: DDNC.System.Private.Uri.DNUri;
    procedure set_BaseAddress(value: DDNC.System.Private.Uri.DNUri);
    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_MaxResponseContentBufferSize: Int64;
    procedure set_MaxResponseContentBufferSize(value: Int64);

  { methods } 

    function GetStringAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function GetStringAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function GetByteArrayAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function GetByteArrayAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function GetStreamAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function GetStreamAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function GetAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: string; completionOption: DNHttpCompletionOption): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri; completionOption: DNHttpCompletionOption): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: string; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: string; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: string; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: string; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: string; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: string; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: string; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: DDNC.System.Private.Uri.DNUri; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage; completionOption: DNHttpCompletionOption): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    procedure CancelPendingRequests;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property DefaultRequestHeaders: DNHttpRequestHeaders read get_DefaultRequestHeaders;
    property BaseAddress: DDNC.System.Private.Uri.DNUri read get_BaseAddress write set_BaseAddress;
    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
    property MaxResponseContentBufferSize: Int64 read get_MaxResponseContentBufferSize write set_MaxResponseContentBufferSize;
  end;

  TDNHttpClient = class(TDNGenericImport<DNHttpClientClass, DNHttpClient>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpMethodClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7175CA18-5AD0-5C15-BBEB-BAFCDBB554A9}']
  { static getter & setter } 

    {class} function get_Get: DNHttpMethod;
    {class} function get_Put: DNHttpMethod;
    {class} function get_Post: DNHttpMethod;
    {class} function get_Delete: DNHttpMethod;
    {class} function get_Head: DNHttpMethod;
    {class} function get_Options: DNHttpMethod;
    {class} function get_Trace: DNHttpMethod;
    {class} function get_Patch: DNHttpMethod;

  { constructors } 

    {class} function init(method: string): DNHttpMethod;

  { static propertys } 

    {class} property Get: DNHttpMethod read get_Get;
    {class} property Put: DNHttpMethod read get_Put;
    {class} property Post: DNHttpMethod read get_Post;
    {class} property Delete: DNHttpMethod read get_Delete;
    {class} property Head: DNHttpMethod read get_Head;
    {class} property Options: DNHttpMethod read get_Options;
    {class} property Trace: DNHttpMethod read get_Trace;
    {class} property Patch: DNHttpMethod read get_Patch;
  end;

  [DNTypeName('System.Net.Http.HttpMethod')]
  DNHttpMethod = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A8060A0B-21B8-31ED-889E-72A440B7FC70}']
  { getters & setters } 

    function get_Method: string;

  { methods } 

    function Equals(other: DNHttpMethod): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Method: string read get_Method;
  end;

  TDNHttpMethod = class(TDNGenericImport<DNHttpMethodClass, DNHttpMethod>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpRequestMessageClass = interface(DNObjectClass)
  ['{0C79F9DB-9E3E-53BB-A604-DD0AD2638ACA}']
  { constructors } 

    {class} function init: DNHttpRequestMessage; overload;
    {class} function init(method: DNHttpMethod; requestUri: DDNC.System.Private.Uri.DNUri): DNHttpRequestMessage; overload;
    {class} function init(method: DNHttpMethod; requestUri: string): DNHttpRequestMessage; overload;

  end;

  [DNTypeName('System.Net.Http.HttpRequestMessage')]
  DNHttpRequestMessage = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{70D513EC-FBAF-313B-9F76-388E57297E70}']
  { getters & setters } 

    function get_Version: DDNC.System.Private.CoreLib.DNVersion;
    procedure set_Version(value: DDNC.System.Private.CoreLib.DNVersion);
    function get_Content: DNHttpContent;
    procedure set_Content(value: DNHttpContent);
    function get_Method: DNHttpMethod;
    procedure set_Method(value: DNHttpMethod);
    function get_RequestUri: DDNC.System.Private.Uri.DNUri;
    procedure set_RequestUri(value: DDNC.System.Private.Uri.DNUri);
    function get_Headers: DNHttpRequestHeaders;
    function get_Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject>;

  { methods } 

    function ToString: string;
    procedure Dispose;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Version: DDNC.System.Private.CoreLib.DNVersion read get_Version write set_Version;
    property Content: DNHttpContent read get_Content write set_Content;
    property Method: DNHttpMethod read get_Method write set_Method;
    property RequestUri: DDNC.System.Private.Uri.DNUri read get_RequestUri write set_RequestUri;
    property Headers: DNHttpRequestHeaders read get_Headers;
    property Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Properties;
  end;

  TDNHttpRequestMessage = class(TDNGenericImport<DNHttpRequestMessageClass, DNHttpRequestMessage>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpResponseMessageClass = interface(DNObjectClass)
  ['{095284F7-1648-57E1-840B-2175D0E19E26}']
  { constructors } 

    {class} function init: DNHttpResponseMessage; overload;
    {class} function init(statusCode: DDNC.System.Net.Primitives.DNHttpStatusCode): DNHttpResponseMessage; overload;

  end;

  [DNTypeName('System.Net.Http.HttpResponseMessage')]
  DNHttpResponseMessage = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{98997C40-13B4-3696-89D7-5EF63CF17017}']
  { getters & setters } 

    function get_Version: DDNC.System.Private.CoreLib.DNVersion;
    procedure set_Version(value: DDNC.System.Private.CoreLib.DNVersion);
    function get_Content: DNHttpContent;
    procedure set_Content(value: DNHttpContent);
    function get_StatusCode: DDNC.System.Net.Primitives.DNHttpStatusCode;
    procedure set_StatusCode(value: DDNC.System.Net.Primitives.DNHttpStatusCode);
    function get_ReasonPhrase: string;
    procedure set_ReasonPhrase(value: string);
    function get_Headers: DNHttpResponseHeaders;
    function get_RequestMessage: DNHttpRequestMessage;
    procedure set_RequestMessage(value: DNHttpRequestMessage);
    function get_IsSuccessStatusCode: Boolean;

  { methods } 

    function EnsureSuccessStatusCode: DNHttpResponseMessage;
    function ToString: string;
    procedure Dispose;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Version: DDNC.System.Private.CoreLib.DNVersion read get_Version write set_Version;
    property Content: DNHttpContent read get_Content write set_Content;
    property StatusCode: DDNC.System.Net.Primitives.DNHttpStatusCode read get_StatusCode write set_StatusCode;
    property ReasonPhrase: string read get_ReasonPhrase write set_ReasonPhrase;
    property Headers: DNHttpResponseHeaders read get_Headers;
    property RequestMessage: DNHttpRequestMessage read get_RequestMessage write set_RequestMessage;
    property IsSuccessStatusCode: Boolean read get_IsSuccessStatusCode;
  end;

  TDNHttpResponseMessage = class(TDNGenericImport<DNHttpResponseMessageClass, DNHttpResponseMessage>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.Http, Version=4.2.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
