//----------------------------------------------------------------------------
//  System.IO.Pipes.dll: System.IO.Pipes, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.IO.Pipes
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.IO.Pipes;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Runtime,
  DDNC.System.Security.Principal,
  DDNC.System.Security.AccessControl,
  DDNC.System.Security.Principal.Windows;

type

{ enums }

  //-------------namespace: System.IO.Pipes----------------
  [DNTypeName('System.IO.Pipes.PipeAccessRights')]
  DNPipeAccessRights = type Integer;
  DNPipeAccessRightsHelper = record helper for DNPipeAccessRights
  public const
    ReadData = 1;
    WriteData = 2;
    CreateNewInstance = 4;
    ReadExtendedAttributes = 8;
    WriteExtendedAttributes = 16;
    ReadAttributes = 128;
    WriteAttributes = 256;
    Write = 274;
    Delete = 65536;
    ReadPermissions = 131072;
    Read = 131209;
    ReadWrite = 131483;
    ChangePermissions = 262144;
    TakeOwnership = 524288;
    Synchronize = 1048576;
    FullControl = 2032031;
    AccessSystemSecurity = 16777216;
  end;


  //-------------namespace: System.IO.Pipes----------------
  [DNTypeName('System.IO.Pipes.PipeDirection')]
  DNPipeDirection = type Integer;
  DNPipeDirectionHelper = record helper for DNPipeDirection
  public const
    In_ = 1;
    Out_ = 2;
    InOut = 3;
  end;


  //-------------namespace: System.IO.Pipes----------------
  [DNTypeName('System.IO.Pipes.PipeOptions')]
  DNPipeOptions = type Integer;
  DNPipeOptionsHelper = record helper for DNPipeOptions
  public const
    None = 0;
    CurrentUserOnly = 536870912;
    Asynchronous = 1073741824;
    WriteThrough = -2147483648;
  end;


  //-------------namespace: System.IO.Pipes----------------
  [DNTypeName('System.IO.Pipes.PipeTransmissionMode')]
  DNPipeTransmissionMode = type Integer;
  DNPipeTransmissionModeHelper = record helper for DNPipeTransmissionMode
  public const
    Byte = 0;
    Message = 1;
  end;




type


{ declares }

  DNPipesAclExtensions = interface; // type: System.IO.Pipes.PipesAclExtensions, namespace: System.IO.Pipes
  DNPipeStream = interface; // type: System.IO.Pipes.PipeStream, namespace: System.IO.Pipes
  DNAnonymousPipeClientStream = interface; // type: System.IO.Pipes.AnonymousPipeClientStream, namespace: System.IO.Pipes
  DNAnonymousPipeServerStream = interface; // type: System.IO.Pipes.AnonymousPipeServerStream, namespace: System.IO.Pipes
  DNNamedPipeClientStream = interface; // type: System.IO.Pipes.NamedPipeClientStream, namespace: System.IO.Pipes
  DNNamedPipeServerStream = interface; // type: System.IO.Pipes.NamedPipeServerStream, namespace: System.IO.Pipes
  DNSafePipeHandle = interface; // type: Microsoft.Win32.SafeHandles.SafePipeHandle, namespace: Microsoft.Win32.SafeHandles
  DNPipeAccessRule = interface; // type: System.IO.Pipes.PipeAccessRule, namespace: System.IO.Pipes
  DNPipeAuditRule = interface; // type: System.IO.Pipes.PipeAuditRule, namespace: System.IO.Pipes
  DNPipeSecurity = interface; // type: System.IO.Pipes.PipeSecurity, namespace: System.IO.Pipes

{ delegates }

  [DNTypeName('System.IO.Pipes.PipeStreamImpersonationWorker')]
  DNPipeStreamImpersonationWorker = procedure of object;




{ objects }

  //-------------namespace: System.IO.Pipes----------------
  DNPipesAclExtensionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A9A007ED-CEE0-59DC-9B30-A42801479B41}']
  { static methods } 

    {class} function GetAccessControl(stream: DNPipeStream): DNPipeSecurity;
    {class} procedure SetAccessControl(stream: DNPipeStream; pipeSecurity: DNPipeSecurity);

  end;

  [DNTypeName('System.IO.Pipes.PipesAclExtensions')]
  DNPipesAclExtensions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{1B48A88B-CE8E-3DBC-96B0-F0A232E02C79}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNPipesAclExtensions = class(TDNGenericImport<DNPipesAclExtensionsClass, DNPipesAclExtensions>) end;

  //-------------namespace: System.IO.Pipes----------------
  DNPipeStreamClass = interface(DDNC.System.Private.CoreLib.DNStreamClass)
  ['{6F697E7A-12A7-54E1-A340-35E3001E2DE2}']
  end;

  [DNTypeName('System.IO.Pipes.PipeStream')]
  DNPipeStream = interface(DDNC.System.Private.CoreLib.DNStream)
  ['{AE9A720E-58E8-3EDD-B7D3-F8CAC03081B0}']
  { getters & setters } 

    function get_IsConnected: Boolean;
    function get_IsAsync: Boolean;
    function get_IsMessageComplete: Boolean;
    function get_SafePipeHandle: DNSafePipeHandle;
    function get_CanRead: Boolean;
    function get_CanWrite: Boolean;
    function get_CanSeek: Boolean;
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_TransmissionMode: DNPipeTransmissionMode;
    function get_InBufferSize: Int32;
    function get_OutBufferSize: Int32;
    function get_ReadMode: DNPipeTransmissionMode;
    procedure set_ReadMode(value: DNPipeTransmissionMode);
    function get_CanTimeout: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);

  { methods } 

    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function ReadByte: Int32;
    procedure WriteByte(value: Byte);
    procedure Flush;
    procedure SetLength(value: Int64);
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure WaitForPipeDrain;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsConnected: Boolean read get_IsConnected;
    property IsAsync: Boolean read get_IsAsync;
    property IsMessageComplete: Boolean read get_IsMessageComplete;
    property SafePipeHandle: DNSafePipeHandle read get_SafePipeHandle;
    property CanRead: Boolean read get_CanRead;
    property CanWrite: Boolean read get_CanWrite;
    property CanSeek: Boolean read get_CanSeek;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property TransmissionMode: DNPipeTransmissionMode read get_TransmissionMode;
    property InBufferSize: Int32 read get_InBufferSize;
    property OutBufferSize: Int32 read get_OutBufferSize;
    property ReadMode: DNPipeTransmissionMode read get_ReadMode write set_ReadMode;
    property CanTimeout: Boolean read get_CanTimeout;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
  end;

  TDNPipeStream = class(TDNGenericImport<DNPipeStreamClass, DNPipeStream>) end;

  //-------------namespace: System.IO.Pipes----------------
  DNAnonymousPipeClientStreamClass = interface(DNPipeStreamClass)
  ['{8C8EC639-B12E-546D-B6BD-B3EE7A2C9AD9}']
  { static getter & setter } 

    procedure set_ReadMode(value: DNPipeTransmissionMode);

  { constructors } 

    {class} function init(pipeHandleAsString: string): DNAnonymousPipeClientStream; overload;
    {class} function init(direction: DNPipeDirection; pipeHandleAsString: string): DNAnonymousPipeClientStream; overload;
    {class} function init(direction: DNPipeDirection; safePipeHandle: DNSafePipeHandle): DNAnonymousPipeClientStream; overload;

  { static propertys } 

    {class} property ReadMode: DNPipeTransmissionMode write set_ReadMode;
  end;

  [DNTypeName('System.IO.Pipes.AnonymousPipeClientStream')]
  DNAnonymousPipeClientStream = interface(DNPipeStream)
  ['{6E8C6E90-F08F-3054-AB0D-3ACCB54855F4}']
  { getters & setters } 

    function get_TransmissionMode: DNPipeTransmissionMode;
    procedure set_ReadMode(value: DNPipeTransmissionMode);
    function get_IsConnected: Boolean;
    function get_IsAsync: Boolean;
    function get_IsMessageComplete: Boolean;
    function get_SafePipeHandle: DNSafePipeHandle;
    function get_CanRead: Boolean;
    function get_CanWrite: Boolean;
    function get_CanSeek: Boolean;
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_InBufferSize: Int32;
    function get_OutBufferSize: Int32;
    function get_CanTimeout: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);

  { methods } 

    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function ReadByte: Int32;
    procedure WriteByte(value: Byte);
    procedure Flush;
    procedure SetLength(value: Int64);
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure WaitForPipeDrain;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property TransmissionMode: DNPipeTransmissionMode read get_TransmissionMode;
    property ReadMode: DNPipeTransmissionMode write set_ReadMode;
    property IsConnected: Boolean read get_IsConnected;
    property IsAsync: Boolean read get_IsAsync;
    property IsMessageComplete: Boolean read get_IsMessageComplete;
    property SafePipeHandle: DNSafePipeHandle read get_SafePipeHandle;
    property CanRead: Boolean read get_CanRead;
    property CanWrite: Boolean read get_CanWrite;
    property CanSeek: Boolean read get_CanSeek;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property InBufferSize: Int32 read get_InBufferSize;
    property OutBufferSize: Int32 read get_OutBufferSize;
    property CanTimeout: Boolean read get_CanTimeout;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
  end;

  TDNAnonymousPipeClientStream = class(TDNGenericImport<DNAnonymousPipeClientStreamClass, DNAnonymousPipeClientStream>) end;

  //-------------namespace: System.IO.Pipes----------------
  DNAnonymousPipeServerStreamClass = interface(DNPipeStreamClass)
  ['{B695E063-E535-53D7-8FC5-CF06D27A611B}']
  { static getter & setter } 

    procedure set_ReadMode(value: DNPipeTransmissionMode);

  { constructors } 

    {class} function init: DNAnonymousPipeServerStream; overload;
    {class} function init(direction: DNPipeDirection): DNAnonymousPipeServerStream; overload;
    {class} function init(direction: DNPipeDirection; inheritability: DDNC.System.Runtime.DNHandleInheritability): DNAnonymousPipeServerStream; overload;
    {class} function init(direction: DNPipeDirection; serverSafePipeHandle: DNSafePipeHandle; clientSafePipeHandle: DNSafePipeHandle): DNAnonymousPipeServerStream; overload;
    {class} function init(direction: DNPipeDirection; inheritability: DDNC.System.Runtime.DNHandleInheritability; bufferSize: Int32): DNAnonymousPipeServerStream; overload;

  { static propertys } 

    {class} property ReadMode: DNPipeTransmissionMode write set_ReadMode;
  end;

  [DNTypeName('System.IO.Pipes.AnonymousPipeServerStream')]
  DNAnonymousPipeServerStream = interface(DNPipeStream)
  ['{AC361306-4DBB-3E1E-9CBB-79852DF0B18B}']
  { getters & setters } 

    function get_ClientSafePipeHandle: DNSafePipeHandle;
    function get_TransmissionMode: DNPipeTransmissionMode;
    procedure set_ReadMode(value: DNPipeTransmissionMode);
    function get_IsConnected: Boolean;
    function get_IsAsync: Boolean;
    function get_IsMessageComplete: Boolean;
    function get_SafePipeHandle: DNSafePipeHandle;
    function get_CanRead: Boolean;
    function get_CanWrite: Boolean;
    function get_CanSeek: Boolean;
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_InBufferSize: Int32;
    function get_OutBufferSize: Int32;
    function get_CanTimeout: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);

  { methods } 

    function GetClientHandleAsString: string;
    procedure DisposeLocalCopyOfClientHandle;
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function ReadByte: Int32;
    procedure WriteByte(value: Byte);
    procedure Flush;
    procedure SetLength(value: Int64);
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure WaitForPipeDrain;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ClientSafePipeHandle: DNSafePipeHandle read get_ClientSafePipeHandle;
    property TransmissionMode: DNPipeTransmissionMode read get_TransmissionMode;
    property ReadMode: DNPipeTransmissionMode write set_ReadMode;
    property IsConnected: Boolean read get_IsConnected;
    property IsAsync: Boolean read get_IsAsync;
    property IsMessageComplete: Boolean read get_IsMessageComplete;
    property SafePipeHandle: DNSafePipeHandle read get_SafePipeHandle;
    property CanRead: Boolean read get_CanRead;
    property CanWrite: Boolean read get_CanWrite;
    property CanSeek: Boolean read get_CanSeek;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property InBufferSize: Int32 read get_InBufferSize;
    property OutBufferSize: Int32 read get_OutBufferSize;
    property CanTimeout: Boolean read get_CanTimeout;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
  end;

  TDNAnonymousPipeServerStream = class(TDNGenericImport<DNAnonymousPipeServerStreamClass, DNAnonymousPipeServerStream>) end;

  //-------------namespace: System.IO.Pipes----------------
  DNNamedPipeClientStreamClass = interface(DNPipeStreamClass)
  ['{7CA4B1C9-D8F5-57DD-9505-3C26F2CAFF61}']
  { constructors } 

    {class} function init(pipeName: string): DNNamedPipeClientStream; overload;
    {class} function init(serverName: string; pipeName: string): DNNamedPipeClientStream; overload;
    {class} function init(serverName: string; pipeName: string; direction: DNPipeDirection): DNNamedPipeClientStream; overload;
    {class} function init(serverName: string; pipeName: string; direction: DNPipeDirection; options: DNPipeOptions): DNNamedPipeClientStream; overload;
    {class} function init(serverName: string; pipeName: string; direction: DNPipeDirection; options: DNPipeOptions; impersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel): DNNamedPipeClientStream; overload;
    {class} function init(serverName: string; pipeName: string; direction: DNPipeDirection; options: DNPipeOptions; impersonationLevel: DDNC.System.Security.Principal.DNTokenImpersonationLevel; inheritability: DDNC.System.Runtime.DNHandleInheritability): DNNamedPipeClientStream; overload;
    {class} function init(direction: DNPipeDirection; isAsync: Boolean; isConnected: Boolean; safePipeHandle: DNSafePipeHandle): DNNamedPipeClientStream; overload;

  end;

  [DNTypeName('System.IO.Pipes.NamedPipeClientStream')]
  DNNamedPipeClientStream = interface(DNPipeStream)
  ['{C9034BBA-D0F0-3B89-BF37-CB612306908E}']
  { getters & setters } 

    function get_NumberOfServerInstances: Int32;
    function get_IsConnected: Boolean;
    function get_IsAsync: Boolean;
    function get_IsMessageComplete: Boolean;
    function get_SafePipeHandle: DNSafePipeHandle;
    function get_CanRead: Boolean;
    function get_CanWrite: Boolean;
    function get_CanSeek: Boolean;
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_TransmissionMode: DNPipeTransmissionMode;
    function get_InBufferSize: Int32;
    function get_OutBufferSize: Int32;
    function get_ReadMode: DNPipeTransmissionMode;
    procedure set_ReadMode(value: DNPipeTransmissionMode);
    function get_CanTimeout: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);

  { methods } 

    procedure Connect; overload;
    procedure Connect(timeout: Int32); overload;
    function ConnectAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function ConnectAsync(timeout: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function ConnectAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function ConnectAsync(timeout: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function ReadByte: Int32;
    procedure WriteByte(value: Byte);
    procedure Flush;
    procedure SetLength(value: Int64);
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure WaitForPipeDrain;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property NumberOfServerInstances: Int32 read get_NumberOfServerInstances;
    property IsConnected: Boolean read get_IsConnected;
    property IsAsync: Boolean read get_IsAsync;
    property IsMessageComplete: Boolean read get_IsMessageComplete;
    property SafePipeHandle: DNSafePipeHandle read get_SafePipeHandle;
    property CanRead: Boolean read get_CanRead;
    property CanWrite: Boolean read get_CanWrite;
    property CanSeek: Boolean read get_CanSeek;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property TransmissionMode: DNPipeTransmissionMode read get_TransmissionMode;
    property InBufferSize: Int32 read get_InBufferSize;
    property OutBufferSize: Int32 read get_OutBufferSize;
    property ReadMode: DNPipeTransmissionMode read get_ReadMode write set_ReadMode;
    property CanTimeout: Boolean read get_CanTimeout;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
  end;

  TDNNamedPipeClientStream = class(TDNGenericImport<DNNamedPipeClientStreamClass, DNNamedPipeClientStream>) end;

  //-------------namespace: System.IO.Pipes----------------
  DNNamedPipeServerStreamClass = interface(DNPipeStreamClass)
  ['{D12F835A-661C-55AF-A4BB-D769FCE43B51}']
  { constructors } 

    {class} function init(pipeName: string): DNNamedPipeServerStream; overload;
    {class} function init(pipeName: string; direction: DNPipeDirection): DNNamedPipeServerStream; overload;
    {class} function init(pipeName: string; direction: DNPipeDirection; maxNumberOfServerInstances: Int32): DNNamedPipeServerStream; overload;
    {class} function init(pipeName: string; direction: DNPipeDirection; maxNumberOfServerInstances: Int32; transmissionMode: DNPipeTransmissionMode): DNNamedPipeServerStream; overload;
    {class} function init(pipeName: string; direction: DNPipeDirection; maxNumberOfServerInstances: Int32; transmissionMode: DNPipeTransmissionMode; options: DNPipeOptions): DNNamedPipeServerStream; overload;
    {class} function init(pipeName: string; direction: DNPipeDirection; maxNumberOfServerInstances: Int32; transmissionMode: DNPipeTransmissionMode; options: DNPipeOptions; inBufferSize: Int32; outBufferSize: Int32): DNNamedPipeServerStream; overload;
    {class} function init(direction: DNPipeDirection; isAsync: Boolean; isConnected: Boolean; safePipeHandle: DNSafePipeHandle): DNNamedPipeServerStream; overload;

  end;

  [DNTypeName('System.IO.Pipes.NamedPipeServerStream')]
  DNNamedPipeServerStream = interface(DNPipeStream)
  ['{4CC91330-4150-3D6B-9888-A831FA45DFE3}']
  { getters & setters } 

    function get_IsConnected: Boolean;
    function get_IsAsync: Boolean;
    function get_IsMessageComplete: Boolean;
    function get_SafePipeHandle: DNSafePipeHandle;
    function get_CanRead: Boolean;
    function get_CanWrite: Boolean;
    function get_CanSeek: Boolean;
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_TransmissionMode: DNPipeTransmissionMode;
    function get_InBufferSize: Int32;
    function get_OutBufferSize: Int32;
    function get_ReadMode: DNPipeTransmissionMode;
    procedure set_ReadMode(value: DNPipeTransmissionMode);
    function get_CanTimeout: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);

  { methods } 

    function WaitForConnectionAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function BeginWaitForConnection(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWaitForConnection(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    procedure WaitForConnection;
    function WaitForConnectionAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Disconnect;
    function GetImpersonationUserName: string;
    procedure RunAsClient(impersonationWorker: DNPipeStreamImpersonationWorker);
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; count: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function ReadByte: Int32;
    procedure WriteByte(value: Byte);
    procedure Flush;
    procedure SetLength(value: Int64);
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure WaitForPipeDrain;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsConnected: Boolean read get_IsConnected;
    property IsAsync: Boolean read get_IsAsync;
    property IsMessageComplete: Boolean read get_IsMessageComplete;
    property SafePipeHandle: DNSafePipeHandle read get_SafePipeHandle;
    property CanRead: Boolean read get_CanRead;
    property CanWrite: Boolean read get_CanWrite;
    property CanSeek: Boolean read get_CanSeek;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property TransmissionMode: DNPipeTransmissionMode read get_TransmissionMode;
    property InBufferSize: Int32 read get_InBufferSize;
    property OutBufferSize: Int32 read get_OutBufferSize;
    property ReadMode: DNPipeTransmissionMode read get_ReadMode write set_ReadMode;
    property CanTimeout: Boolean read get_CanTimeout;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
  end;

  TDNNamedPipeServerStream = class(TDNGenericImport<DNNamedPipeServerStreamClass, DNNamedPipeServerStream>)
  public const
   MaxAllowedServerInstances = -1;
  end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafePipeHandleClass = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalidClass)
  ['{9415916B-16CF-51EF-9F77-166223EB33C9}']
  { constructors } 

    {class} function init(preexistingHandle: IntPtr; ownsHandle: Boolean): DNSafePipeHandle;

  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafePipeHandle')]
  DNSafePipeHandle = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalid)
  ['{0CFC0B9A-EC44-3B67-BC18-A75C62B887E8}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafePipeHandle = class(TDNGenericImport<DNSafePipeHandleClass, DNSafePipeHandle>) end;

  //-------------namespace: System.IO.Pipes----------------
  DNPipeAccessRuleClass = interface(DNObjectClass)
  ['{DAEFD075-8696-5A77-A141-1162675D48D5}']
  { constructors } 

    {class} function init(identity: string; rights: DNPipeAccessRights; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DNPipeAccessRule; overload;
    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: DNPipeAccessRights; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DNPipeAccessRule; overload;

  end;

  [DNTypeName('System.IO.Pipes.PipeAccessRule')]
  DNPipeAccessRule = interface(DNObject)
  ['{87C2CAD6-CF3C-3B2D-8B23-0B151D6B7FB3}']
  { getters & setters } 

    function get_PipeAccessRights: DNPipeAccessRights;
    function get_AccessControlType: DDNC.System.Security.AccessControl.DNAccessControlType;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags;
    function get_PropagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property PipeAccessRights: DNPipeAccessRights read get_PipeAccessRights;
    property AccessControlType: DDNC.System.Security.AccessControl.DNAccessControlType read get_AccessControlType;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags read get_PropagationFlags;
  end;

  TDNPipeAccessRule = class(TDNGenericImport<DNPipeAccessRuleClass, DNPipeAccessRule>) end;

  //-------------namespace: System.IO.Pipes----------------
  DNPipeAuditRuleClass = interface(DNObjectClass)
  ['{6A452EC4-AFC6-59D0-A9A2-66FCE9AF6EC5}']
  { constructors } 

    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: DNPipeAccessRights; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DNPipeAuditRule; overload;
    {class} function init(identity: string; rights: DNPipeAccessRights; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DNPipeAuditRule; overload;

  end;

  [DNTypeName('System.IO.Pipes.PipeAuditRule')]
  DNPipeAuditRule = interface(DNObject)
  ['{48924961-9C4D-3AD1-8FF0-75212E86E874}']
  { getters & setters } 

    function get_PipeAccessRights: DNPipeAccessRights;
    function get_AuditFlags: DDNC.System.Security.AccessControl.DNAuditFlags;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags;
    function get_PropagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property PipeAccessRights: DNPipeAccessRights read get_PipeAccessRights;
    property AuditFlags: DDNC.System.Security.AccessControl.DNAuditFlags read get_AuditFlags;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags read get_PropagationFlags;
  end;

  TDNPipeAuditRule = class(TDNGenericImport<DNPipeAuditRuleClass, DNPipeAuditRule>) end;

  //-------------namespace: System.IO.Pipes----------------
  DNPipeSecurityClass = interface(DNObjectClass)
  ['{1DCEBBEC-47B9-52E4-A6F9-C067D36B7EE5}']
  { constructors } 

    {class} function init: DNPipeSecurity;

  end;

  [DNTypeName('System.IO.Pipes.PipeSecurity')]
  DNPipeSecurity = interface(DNObject)
  ['{7E534B54-2986-3DC3-A9B4-7D02B05C826B}']
  { getters & setters } 

    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;

  { methods } 

    procedure AddAccessRule(rule: DNPipeAccessRule);
    procedure SetAccessRule(rule: DNPipeAccessRule);
    procedure ResetAccessRule(rule: DNPipeAccessRule);
    function RemoveAccessRule(rule: DNPipeAccessRule): Boolean;
    procedure RemoveAccessRuleSpecific(rule: DNPipeAccessRule);
    procedure AddAuditRule(rule: DNPipeAuditRule);
    procedure SetAuditRule(rule: DNPipeAuditRule);
    function RemoveAuditRule(rule: DNPipeAuditRule): Boolean;
    procedure RemoveAuditRuleAll(rule: DNPipeAuditRule);
    procedure RemoveAuditRuleSpecific(rule: DNPipeAuditRule);
    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DDNC.System.Security.AccessControl.DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DDNC.System.Security.AccessControl.DNAuditRule;
    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAuditRule; out modified: Boolean): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
  end;

  TDNPipeSecurity = class(TDNGenericImport<DNPipeSecurityClass, DNPipeSecurity>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.IO.Pipes, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
