//----------------------------------------------------------------------------
//  System.IO.IsolatedStorage.dll: System.IO.IsolatedStorage, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.IO.IsolatedStorage
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.IO.IsolatedStorage;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type

{ enums }

  //-------------namespace: System.IO.IsolatedStorage----------------
  [DNTypeName('System.IO.IsolatedStorage.IsolatedStorageScope')]
  DNIsolatedStorageScope = type Integer;
  DNIsolatedStorageScopeHelper = record helper for DNIsolatedStorageScope
  public const
    None = 0;
    User = 1;
    Domain = 2;
    Assembly = 4;
    Roaming = 8;
    Machine = 16;
    Application = 32;
  end;




type


{ declares }

  DNINormalizeForIsolatedStorage = interface; // type: System.IO.IsolatedStorage.INormalizeForIsolatedStorage, namespace: System.IO.IsolatedStorage
  DNIsolatedStorageException = interface; // type: System.IO.IsolatedStorage.IsolatedStorageException, namespace: System.IO.IsolatedStorage
  DNIsolatedStorage = interface; // type: System.IO.IsolatedStorage.IsolatedStorage, namespace: System.IO.IsolatedStorage
  DNIsolatedStorageFile = interface; // type: System.IO.IsolatedStorage.IsolatedStorageFile, namespace: System.IO.IsolatedStorage
  DNIsolatedStorageFileStream = interface; // type: System.IO.IsolatedStorage.IsolatedStorageFileStream, namespace: System.IO.IsolatedStorage


{ objects }

  //-------------namespace: System.IO.IsolatedStorage----------------
  [DNTypeName('System.IO.IsolatedStorage.INormalizeForIsolatedStorage')]
  DNINormalizeForIsolatedStorage = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F5006531-D4D7-319E-9EDA-9B4B65AD8D4F}']
  { methods } 

    function Normalize: DDNC.System.Private.CoreLib.DNObject;

  end;

  //-------------namespace: System.IO.IsolatedStorage----------------
  DNIsolatedStorageExceptionClass = interface(DDNC.System.Private.CoreLib.DNExceptionClass)
  ['{48DCB201-ED60-577F-B0CB-B0D5A0588548}']
  { constructors } 

    {class} function init: DNIsolatedStorageException; overload;
    {class} function init(message: string): DNIsolatedStorageException; overload;
    {class} function init(message: string; inner: DDNC.System.Private.CoreLib.DNException): DNIsolatedStorageException; overload;

  end;

  [DNTypeName('System.IO.IsolatedStorage.IsolatedStorageException')]
  DNIsolatedStorageException = interface(DDNC.System.Private.CoreLib.DNException)
  ['{B334732B-8C15-321F-8539-9739C90A58B4}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNIsolatedStorageException = class(TDNGenericImport<DNIsolatedStorageExceptionClass, DNIsolatedStorageException>) end;

  //-------------namespace: System.IO.IsolatedStorage----------------
  DNIsolatedStorageClass = interface(DDNC.System.Private.CoreLib.DNMarshalByRefObjectClass)
  ['{AA38A036-6CB1-542F-89D2-63D8837CB7A2}']
  end;

  [DNTypeName('System.IO.IsolatedStorage.IsolatedStorage')]
  DNIsolatedStorage = interface(DDNC.System.Private.CoreLib.DNMarshalByRefObject)
  ['{768A863D-0382-3A39-96EA-CBEC9DFFADF7}']
  { getters & setters } 

    function get_ApplicationIdentity: DDNC.System.Private.CoreLib.DNObject;
    function get_AssemblyIdentity: DDNC.System.Private.CoreLib.DNObject;
    function get_DomainIdentity: DDNC.System.Private.CoreLib.DNObject;
    function get_CurrentSize: UInt64;
    function get_UsedSize: Int64;
    function get_AvailableFreeSpace: Int64;
    function get_MaximumSize: UInt64;
    function get_Quota: Int64;
    function get_Scope: DNIsolatedStorageScope;

  { methods } 

    function IncreaseQuotaTo(newQuotaSize: Int64): Boolean;
    procedure Remove;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ApplicationIdentity: DDNC.System.Private.CoreLib.DNObject read get_ApplicationIdentity;
    property AssemblyIdentity: DDNC.System.Private.CoreLib.DNObject read get_AssemblyIdentity;
    property DomainIdentity: DDNC.System.Private.CoreLib.DNObject read get_DomainIdentity;
    property CurrentSize: UInt64 read get_CurrentSize;
    property UsedSize: Int64 read get_UsedSize;
    property AvailableFreeSpace: Int64 read get_AvailableFreeSpace;
    property MaximumSize: UInt64 read get_MaximumSize;
    property Quota: Int64 read get_Quota;
    property Scope: DNIsolatedStorageScope read get_Scope;
  end;

  TDNIsolatedStorage = class(TDNGenericImport<DNIsolatedStorageClass, DNIsolatedStorage>) end;

  //-------------namespace: System.IO.IsolatedStorage----------------
  DNIsolatedStorageFileClass = interface(DNIsolatedStorageClass)
  ['{44676434-CA80-53FC-8BB5-7C5803BDC4E6}']
  { static getter & setter } 

    {class} function get_IsEnabled: Boolean;

  { static methods } 

    {class} function GetEnumerator(scope: DNIsolatedStorageScope): DDNC.System.Private.CoreLib.DNIEnumerator;
    {class} function GetUserStoreForApplication: DNIsolatedStorageFile;
    {class} function GetUserStoreForAssembly: DNIsolatedStorageFile;
    {class} function GetUserStoreForDomain: DNIsolatedStorageFile;
    {class} function GetUserStoreForSite: DNIsolatedStorageFile;
    {class} function GetMachineStoreForApplication: DNIsolatedStorageFile;
    {class} function GetMachineStoreForAssembly: DNIsolatedStorageFile;
    {class} function GetMachineStoreForDomain: DNIsolatedStorageFile;
    {class} function GetStore(scope: DNIsolatedStorageScope; applicationEvidenceType: DDNC.System.Private.CoreLib.DNType): DNIsolatedStorageFile; overload;
    {class} function GetStore(scope: DNIsolatedStorageScope; applicationIdentity: DDNC.System.Private.CoreLib.DNObject): DNIsolatedStorageFile; overload;
    {class} function GetStore(scope: DNIsolatedStorageScope; domainEvidenceType: DDNC.System.Private.CoreLib.DNType; assemblyEvidenceType: DDNC.System.Private.CoreLib.DNType): DNIsolatedStorageFile; overload;
    {class} function GetStore(scope: DNIsolatedStorageScope; domainIdentity: DDNC.System.Private.CoreLib.DNObject; assemblyIdentity: DDNC.System.Private.CoreLib.DNObject): DNIsolatedStorageFile; overload;
    {class} procedure Remove(scope: DNIsolatedStorageScope); overload;

  { static propertys } 

    {class} property IsEnabled: Boolean read get_IsEnabled;
  end;

  [DNTypeName('System.IO.IsolatedStorage.IsolatedStorageFile')]
  DNIsolatedStorageFile = interface(DNIsolatedStorage)
  ['{758B5C3B-3A1A-35DE-A70A-952B435867E5}']
  { getters & setters } 

    function get_AvailableFreeSpace: Int64;
    function get_MaximumSize: UInt64;
    function get_Quota: Int64;
    function get_UsedSize: Int64;
    function get_CurrentSize: UInt64;
    function get_ApplicationIdentity: DDNC.System.Private.CoreLib.DNObject;
    function get_AssemblyIdentity: DDNC.System.Private.CoreLib.DNObject;
    function get_DomainIdentity: DDNC.System.Private.CoreLib.DNObject;
    function get_Scope: DNIsolatedStorageScope;

  { methods } 

    procedure Close;
    procedure DeleteFile(&file: string);
    function FileExists(path: string): Boolean;
    function DirectoryExists(path: string): Boolean;
    procedure CreateDirectory(dir: string);
    procedure DeleteDirectory(dir: string);
    function GetFileNames: TArray<string>; overload;
    function GetFileNames(searchPattern: string): TArray<string>; overload;
    function GetDirectoryNames: TArray<string>; overload;
    function GetDirectoryNames(searchPattern: string): TArray<string>; overload;
    function OpenFile(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode): DNIsolatedStorageFileStream; overload;
    function OpenFile(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess): DNIsolatedStorageFileStream; overload;
    function OpenFile(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess; share: DDNC.System.Private.CoreLib.DNFileShare): DNIsolatedStorageFileStream; overload;
    function CreateFile(path: string): DNIsolatedStorageFileStream;
    function GetCreationTime(path: string): DDNC.System.Private.CoreLib.DNDateTimeOffset;
    function GetLastAccessTime(path: string): DDNC.System.Private.CoreLib.DNDateTimeOffset;
    function GetLastWriteTime(path: string): DDNC.System.Private.CoreLib.DNDateTimeOffset;
    procedure CopyFile(sourceFileName: string; destinationFileName: string); overload;
    procedure CopyFile(sourceFileName: string; destinationFileName: string; overwrite: Boolean); overload;
    procedure MoveFile(sourceFileName: string; destinationFileName: string);
    procedure MoveDirectory(sourceDirectoryName: string; destinationDirectoryName: string);
    procedure Dispose;
    function IncreaseQuotaTo(newQuotaSize: Int64): Boolean;
    procedure Remove; overload;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AvailableFreeSpace: Int64 read get_AvailableFreeSpace;
    property MaximumSize: UInt64 read get_MaximumSize;
    property Quota: Int64 read get_Quota;
    property UsedSize: Int64 read get_UsedSize;
    property CurrentSize: UInt64 read get_CurrentSize;
    property ApplicationIdentity: DDNC.System.Private.CoreLib.DNObject read get_ApplicationIdentity;
    property AssemblyIdentity: DDNC.System.Private.CoreLib.DNObject read get_AssemblyIdentity;
    property DomainIdentity: DDNC.System.Private.CoreLib.DNObject read get_DomainIdentity;
    property Scope: DNIsolatedStorageScope read get_Scope;
  end;

  TDNIsolatedStorageFile = class(TDNGenericImport<DNIsolatedStorageFileClass, DNIsolatedStorageFile>) end;

  //-------------namespace: System.IO.IsolatedStorage----------------
  DNIsolatedStorageFileStreamClass = interface(DDNC.System.Private.CoreLib.DNFileStreamClass)
  ['{F2132CFD-CE4D-5763-889C-7542BD52B5D1}']
  { constructors } 

    {class} function init(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode): DNIsolatedStorageFileStream; overload;
    {class} function init(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; isf: DNIsolatedStorageFile): DNIsolatedStorageFileStream; overload;
    {class} function init(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess): DNIsolatedStorageFileStream; overload;
    {class} function init(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess; isf: DNIsolatedStorageFile): DNIsolatedStorageFileStream; overload;
    {class} function init(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess; share: DDNC.System.Private.CoreLib.DNFileShare): DNIsolatedStorageFileStream; overload;
    {class} function init(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess; share: DDNC.System.Private.CoreLib.DNFileShare; isf: DNIsolatedStorageFile): DNIsolatedStorageFileStream; overload;
    {class} function init(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess; share: DDNC.System.Private.CoreLib.DNFileShare; bufferSize: Int32): DNIsolatedStorageFileStream; overload;
    {class} function init(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess; share: DDNC.System.Private.CoreLib.DNFileShare; bufferSize: Int32; isf: DNIsolatedStorageFile): DNIsolatedStorageFileStream; overload;

  end;

  [DNTypeName('System.IO.IsolatedStorage.IsolatedStorageFileStream')]
  DNIsolatedStorageFileStream = interface(DDNC.System.Private.CoreLib.DNFileStream)
  ['{C06E647D-5494-355C-A6B7-890CF05BBDB6}']
  { getters & setters } 

    function get_CanRead: Boolean;
    function get_CanWrite: Boolean;
    function get_CanSeek: Boolean;
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);
    function get_IsAsync: Boolean;
    function get_Handle: IntPtr;
    function get_SafeFileHandle: DDNC.System.Private.CoreLib.DNSafeFileHandle;
    function get_Name: string;
    function get_CanTimeout: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);

  { methods } 

    procedure Flush; overload;
    procedure Flush(flushToDisk: Boolean); overload;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure SetLength(value: Int64);
    function Read(buffer: TArray<Byte>; offset: Int32; count: Int32): Int32; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function ReadByte: Int32;
    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    procedure Write(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    procedure WriteByte(value: Byte);
    function BeginRead(&array: TArray<Byte>; offset: Int32; numBytes: Int32; userCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; stateObject: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function BeginWrite(&array: TArray<Byte>; offset: Int32; numBytes: Int32; userCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; stateObject: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    procedure Unlock(position: Int64; length: Int64);
    procedure Lock(position: Int64; length: Int64);
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close;
    procedure Dispose;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CanRead: Boolean read get_CanRead;
    property CanWrite: Boolean read get_CanWrite;
    property CanSeek: Boolean read get_CanSeek;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
    property IsAsync: Boolean read get_IsAsync;
    property Handle: IntPtr read get_Handle;
    property SafeFileHandle: DDNC.System.Private.CoreLib.DNSafeFileHandle read get_SafeFileHandle;
    property Name: string read get_Name;
    property CanTimeout: Boolean read get_CanTimeout;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
  end;

  TDNIsolatedStorageFileStream = class(TDNGenericImport<DNIsolatedStorageFileStreamClass, DNIsolatedStorageFileStream>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.IO.IsolatedStorage, Version=4.1.1.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
