//----------------------------------------------------------------------------
//  System.IO.FileSystem.AccessControl.dll: System.IO.FileSystem.AccessControl, Version=4.0.3.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 2.1.30
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.IO.FileSystem.AccessControl
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.IO.FileSystem.AccessControl;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.IO.FileSystem,
  DDNC.System.Security.AccessControl,
  DDNC.System.Security.Principal.Windows;

type

{ enums }

  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.FileSystemRights')]
  DNFileSystemRights = type Integer;
  DNFileSystemRightsHelper = record helper for DNFileSystemRights
  public const
    ListDirectory = 1;
    ReadData = 1;
    WriteData = 2;
    CreateFiles = 2;
    CreateDirectories = 4;
    AppendData = 4;
    ReadExtendedAttributes = 8;
    WriteExtendedAttributes = 16;
    Traverse = 32;
    ExecuteFile = 32;
    DeleteSubdirectoriesAndFiles = 64;
    ReadAttributes = 128;
    WriteAttributes = 256;
    Write = 278;
    Delete = 65536;
    ReadPermissions = 131072;
    Read = 131209;
    ReadAndExecute = 131241;
    Modify = 197055;
    ChangePermissions = 262144;
    TakeOwnership = 524288;
    Synchronize = 1048576;
    FullControl = 2032127;
  end;




type


{ declares }

  DNFileSystemAclExtensions = interface; // type: System.IO.FileSystemAclExtensions, namespace: System.IO
  DNFileSystemAccessRule = interface; // type: System.Security.AccessControl.FileSystemAccessRule, namespace: System.Security.AccessControl
  DNFileSystemAuditRule = interface; // type: System.Security.AccessControl.FileSystemAuditRule, namespace: System.Security.AccessControl
  DNFileSystemSecurity = interface; // type: System.Security.AccessControl.FileSystemSecurity, namespace: System.Security.AccessControl
  DNDirectorySecurity = interface; // type: System.Security.AccessControl.DirectorySecurity, namespace: System.Security.AccessControl
  DNFileSecurity = interface; // type: System.Security.AccessControl.FileSecurity, namespace: System.Security.AccessControl
  DNDirectoryObjectSecurity = interface; // type: System.Security.AccessControl.DirectoryObjectSecurity, namespace: System.Security.AccessControl


{ objects }

  //-------------namespace: System.IO----------------
  DNFileSystemAclExtensionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{8F695831-2A37-5A90-B53E-BA8D584AF2E5}']
  { static methods } 

    {class} function GetAccessControl(directoryInfo: DDNC.System.IO.FileSystem.DNDirectoryInfo): DNDirectorySecurity; overload;
    {class} function GetAccessControl(directoryInfo: DDNC.System.IO.FileSystem.DNDirectoryInfo; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections): DNDirectorySecurity; overload;
    {class} procedure SetAccessControl(directoryInfo: DDNC.System.IO.FileSystem.DNDirectoryInfo; directorySecurity: DNDirectorySecurity); overload;
    {class} function GetAccessControl(fileInfo: DDNC.System.IO.FileSystem.DNFileInfo): DNFileSecurity; overload;
    {class} function GetAccessControl(fileInfo: DDNC.System.IO.FileSystem.DNFileInfo; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections): DNFileSecurity; overload;
    {class} procedure SetAccessControl(fileInfo: DDNC.System.IO.FileSystem.DNFileInfo; fileSecurity: DNFileSecurity); overload;
    {class} function GetAccessControl(fileStream: DDNC.System.Private.CoreLib.DNFileStream): DNFileSecurity; overload;
    {class} procedure SetAccessControl(fileStream: DDNC.System.Private.CoreLib.DNFileStream; fileSecurity: DNFileSecurity); overload;

  end;

  [DNTypeName('System.IO.FileSystemAclExtensions')]
  DNFileSystemAclExtensions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B0CDF6E2-74C3-3B28-8E3C-1D5858287D43}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNFileSystemAclExtensions = class(TDNGenericImport<DNFileSystemAclExtensionsClass, DNFileSystemAclExtensions>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNFileSystemAccessRuleClass = interface(DNObjectClass)
  ['{A6C206B6-458F-5178-A1F9-7BF949A2CF22}']
  { constructors } 

    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; fileSystemRights: DNFileSystemRights; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DNFileSystemAccessRule; overload;
    {class} function init(identity: string; fileSystemRights: DNFileSystemRights; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DNFileSystemAccessRule; overload;
    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; fileSystemRights: DNFileSystemRights; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DNFileSystemAccessRule; overload;
    {class} function init(identity: string; fileSystemRights: DNFileSystemRights; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DNFileSystemAccessRule; overload;

  end;

  [DNTypeName('System.Security.AccessControl.FileSystemAccessRule')]
  DNFileSystemAccessRule = interface(DNObject)
  ['{A8EFEE97-FADF-38CA-8B80-EEBA53FCAB07}']
  { getters & setters } 

    function get_FileSystemRights: DNFileSystemRights;
    function get_AccessControlType: DDNC.System.Security.AccessControl.DNAccessControlType;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags;
    function get_PropagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FileSystemRights: DNFileSystemRights read get_FileSystemRights;
    property AccessControlType: DDNC.System.Security.AccessControl.DNAccessControlType read get_AccessControlType;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags read get_PropagationFlags;
  end;

  TDNFileSystemAccessRule = class(TDNGenericImport<DNFileSystemAccessRuleClass, DNFileSystemAccessRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNFileSystemAuditRuleClass = interface(DNObjectClass)
  ['{0CD02546-E59B-5EC0-9BA8-DAD125AFC3A9}']
  { constructors } 

    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; fileSystemRights: DNFileSystemRights; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DNFileSystemAuditRule; overload;
    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; fileSystemRights: DNFileSystemRights; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DNFileSystemAuditRule; overload;
    {class} function init(identity: string; fileSystemRights: DNFileSystemRights; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DNFileSystemAuditRule; overload;
    {class} function init(identity: string; fileSystemRights: DNFileSystemRights; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DNFileSystemAuditRule; overload;

  end;

  [DNTypeName('System.Security.AccessControl.FileSystemAuditRule')]
  DNFileSystemAuditRule = interface(DNObject)
  ['{D4911623-722F-368A-A8DB-6339FB054C20}']
  { getters & setters } 

    function get_FileSystemRights: DNFileSystemRights;
    function get_AuditFlags: DDNC.System.Security.AccessControl.DNAuditFlags;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags;
    function get_PropagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FileSystemRights: DNFileSystemRights read get_FileSystemRights;
    property AuditFlags: DDNC.System.Security.AccessControl.DNAuditFlags read get_AuditFlags;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags read get_PropagationFlags;
  end;

  TDNFileSystemAuditRule = class(TDNGenericImport<DNFileSystemAuditRuleClass, DNFileSystemAuditRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNFileSystemSecurityClass = interface(DNObjectClass)
  ['{1A695578-4B71-563B-AF1A-553624110300}']
  end;

  [DNTypeName('System.Security.AccessControl.FileSystemSecurity')]
  DNFileSystemSecurity = interface(DNObject)
  ['{98206677-38E0-3486-8E2D-F9FD3BA67F2E}']
  { getters & setters } 

    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;

  { methods } 

    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DDNC.System.Security.AccessControl.DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DDNC.System.Security.AccessControl.DNAuditRule;
    procedure AddAccessRule(rule: DNFileSystemAccessRule);
    procedure SetAccessRule(rule: DNFileSystemAccessRule);
    procedure ResetAccessRule(rule: DNFileSystemAccessRule);
    function RemoveAccessRule(rule: DNFileSystemAccessRule): Boolean;
    procedure RemoveAccessRuleAll(rule: DNFileSystemAccessRule);
    procedure RemoveAccessRuleSpecific(rule: DNFileSystemAccessRule);
    procedure AddAuditRule(rule: DNFileSystemAuditRule);
    procedure SetAuditRule(rule: DNFileSystemAuditRule);
    function RemoveAuditRule(rule: DNFileSystemAuditRule): Boolean;
    procedure RemoveAuditRuleAll(rule: DNFileSystemAuditRule);
    procedure RemoveAuditRuleSpecific(rule: DNFileSystemAuditRule);
    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAuditRule; out modified: Boolean): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
  end;

  TDNFileSystemSecurity = class(TDNGenericImport<DNFileSystemSecurityClass, DNFileSystemSecurity>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNDirectorySecurityClass = interface(DNFileSystemSecurityClass)
  ['{4A66EF94-16AB-5B4E-B404-CB7E44CDF785}']
  { constructors } 

    {class} function init: DNDirectorySecurity; overload;
    {class} function init(name: string; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections): DNDirectorySecurity; overload;

  end;

  [DNTypeName('System.Security.AccessControl.DirectorySecurity')]
  DNDirectorySecurity = interface(DNFileSystemSecurity)
  ['{CA9556BC-B12F-31BE-8C4A-536D6E860E17}']
  { getters & setters } 

    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;

  { methods } 

    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DDNC.System.Security.AccessControl.DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DDNC.System.Security.AccessControl.DNAuditRule;
    procedure AddAccessRule(rule: DNFileSystemAccessRule);
    procedure SetAccessRule(rule: DNFileSystemAccessRule);
    procedure ResetAccessRule(rule: DNFileSystemAccessRule);
    function RemoveAccessRule(rule: DNFileSystemAccessRule): Boolean;
    procedure RemoveAccessRuleAll(rule: DNFileSystemAccessRule);
    procedure RemoveAccessRuleSpecific(rule: DNFileSystemAccessRule);
    procedure AddAuditRule(rule: DNFileSystemAuditRule);
    procedure SetAuditRule(rule: DNFileSystemAuditRule);
    function RemoveAuditRule(rule: DNFileSystemAuditRule): Boolean;
    procedure RemoveAuditRuleAll(rule: DNFileSystemAuditRule);
    procedure RemoveAuditRuleSpecific(rule: DNFileSystemAuditRule);
    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAuditRule; out modified: Boolean): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
  end;

  TDNDirectorySecurity = class(TDNGenericImport<DNDirectorySecurityClass, DNDirectorySecurity>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNFileSecurityClass = interface(DNFileSystemSecurityClass)
  ['{EB9D6EE0-E23B-57BC-B1A3-426BB926EC46}']
  { constructors } 

    {class} function init: DNFileSecurity; overload;
    {class} function init(fileName: string; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections): DNFileSecurity; overload;

  end;

  [DNTypeName('System.Security.AccessControl.FileSecurity')]
  DNFileSecurity = interface(DNFileSystemSecurity)
  ['{A20EB477-9A7B-38A8-99E8-A2465EE817CB}']
  { getters & setters } 

    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;

  { methods } 

    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DDNC.System.Security.AccessControl.DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DDNC.System.Security.AccessControl.DNAuditRule;
    procedure AddAccessRule(rule: DNFileSystemAccessRule);
    procedure SetAccessRule(rule: DNFileSystemAccessRule);
    procedure ResetAccessRule(rule: DNFileSystemAccessRule);
    function RemoveAccessRule(rule: DNFileSystemAccessRule): Boolean;
    procedure RemoveAccessRuleAll(rule: DNFileSystemAccessRule);
    procedure RemoveAccessRuleSpecific(rule: DNFileSystemAccessRule);
    procedure AddAuditRule(rule: DNFileSystemAuditRule);
    procedure SetAuditRule(rule: DNFileSystemAuditRule);
    function RemoveAuditRule(rule: DNFileSystemAuditRule): Boolean;
    procedure RemoveAuditRuleAll(rule: DNFileSystemAuditRule);
    procedure RemoveAuditRuleSpecific(rule: DNFileSystemAuditRule);
    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAuditRule; out modified: Boolean): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
  end;

  TDNFileSecurity = class(TDNGenericImport<DNFileSecurityClass, DNFileSecurity>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNDirectoryObjectSecurityClass = interface(DNObjectClass)
  ['{C850D0DD-DFF7-5CC4-855C-352CF9919634}']
  end;

  [DNTypeName('System.Security.AccessControl.DirectoryObjectSecurity')]
  DNDirectoryObjectSecurity = interface(DNObject)
  ['{70DC830F-26C4-3249-AAED-89452A737B20}']
  { getters & setters } 

    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;
    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;

  { methods } 

    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; &type: DDNC.System.Security.AccessControl.DNAccessControlType; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid): DDNC.System.Security.AccessControl.DNAccessRule; overload;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; flags: DDNC.System.Security.AccessControl.DNAuditFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid): DDNC.System.Security.AccessControl.DNAuditRule; overload;
    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.AccessControl.DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DDNC.System.Security.AccessControl.DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DDNC.System.Security.AccessControl.DNAccessControlModification; rule: DDNC.System.Security.AccessControl.DNAuditRule; out modified: Boolean): Boolean;
    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; &type: DDNC.System.Security.AccessControl.DNAccessControlType): DDNC.System.Security.AccessControl.DNAccessRule; overload;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DDNC.System.Security.AccessControl.DNInheritanceFlags; propagationFlags: DDNC.System.Security.AccessControl.DNPropagationFlags; flags: DDNC.System.Security.AccessControl.DNAuditFlags): DDNC.System.Security.AccessControl.DNAuditRule; overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
  end;

  TDNDirectoryObjectSecurity = class(TDNGenericImport<DNDirectoryObjectSecurityClass, DNDirectoryObjectSecurity>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.IO.FileSystem.AccessControl, Version=4.0.3.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
