//----------------------------------------------------------------------------
//  System.Transactions.Local.dll: System.Transactions.Local, Version=5.0.0.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Transactions.Local
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Transactions.Local;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type

{ enums }

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.DependentCloneOption')]
  DNDependentCloneOption = type Integer;
  DNDependentCloneOptionHelper = record helper for DNDependentCloneOption
  public const
    BlockCommitUntilComplete = 0;
    RollbackIfNotComplete = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.EnlistmentOptions')]
  DNEnlistmentOptions = type Integer;
  DNEnlistmentOptionsHelper = record helper for DNEnlistmentOptions
  public const
    None = 0;
    EnlistDuringPrepareRequired = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.EnterpriseServicesInteropOption')]
  DNEnterpriseServicesInteropOption = type Integer;
  DNEnterpriseServicesInteropOptionHelper = record helper for DNEnterpriseServicesInteropOption
  public const
    None = 0;
    Automatic = 1;
    Full = 2;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IsolationLevel')]
  DNIsolationLevel = type Integer;
  DNIsolationLevelHelper = record helper for DNIsolationLevel
  public const
    Serializable = 0;
    RepeatableRead = 1;
    ReadCommitted = 2;
    ReadUncommitted = 3;
    Snapshot = 4;
    Chaos = 5;
    Unspecified = 6;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionScopeAsyncFlowOption')]
  DNTransactionScopeAsyncFlowOption = type Integer;
  DNTransactionScopeAsyncFlowOptionHelper = record helper for DNTransactionScopeAsyncFlowOption
  public const
    Suppress = 0;
    Enabled = 1;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionScopeOption')]
  DNTransactionScopeOption = type Integer;
  DNTransactionScopeOptionHelper = record helper for DNTransactionScopeOption
  public const
    Required = 0;
    RequiresNew = 1;
    Suppress = 2;
  end;


  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.TransactionStatus')]
  DNTransactionStatus = type Integer;
  DNTransactionStatusHelper = record helper for DNTransactionStatus
  public const
    Active = 0;
    Committed = 1;
    Aborted = 2;
    InDoubt = 3;
  end;




type


{ declares }

  DNIDtcTransaction = interface; // type: System.Transactions.IDtcTransaction, namespace: System.Transactions
  DNIEnlistmentNotification = interface; // type: System.Transactions.IEnlistmentNotification, namespace: System.Transactions
  DNISinglePhaseNotification = interface; // type: System.Transactions.ISinglePhaseNotification, namespace: System.Transactions
  DNITransactionPromoter = interface; // type: System.Transactions.ITransactionPromoter, namespace: System.Transactions
  DNIPromotableSinglePhaseNotification = interface; // type: System.Transactions.IPromotableSinglePhaseNotification, namespace: System.Transactions
  DNISimpleTransactionSuperior = interface; // type: System.Transactions.ISimpleTransactionSuperior, namespace: System.Transactions
  DNTransactionEventArgs = interface; // type: System.Transactions.TransactionEventArgs, namespace: System.Transactions
  DNTransactionException = interface; // type: System.Transactions.TransactionException, namespace: System.Transactions
  DNTransactionAbortedException = interface; // type: System.Transactions.TransactionAbortedException, namespace: System.Transactions
  DNTransactionInDoubtException = interface; // type: System.Transactions.TransactionInDoubtException, namespace: System.Transactions
  DNTransactionManagerCommunicationException = interface; // type: System.Transactions.TransactionManagerCommunicationException, namespace: System.Transactions
  DNTransactionPromotionException = interface; // type: System.Transactions.TransactionPromotionException, namespace: System.Transactions
  DNEnlistment = interface; // type: System.Transactions.Enlistment, namespace: System.Transactions
  DNPreparingEnlistment = interface; // type: System.Transactions.PreparingEnlistment, namespace: System.Transactions
  DNSinglePhaseEnlistment = interface; // type: System.Transactions.SinglePhaseEnlistment, namespace: System.Transactions
  DNTransaction = interface; // type: System.Transactions.Transaction, namespace: System.Transactions
  DNCommittableTransaction = interface; // type: System.Transactions.CommittableTransaction, namespace: System.Transactions
  DNDependentTransaction = interface; // type: System.Transactions.DependentTransaction, namespace: System.Transactions
  DNSubordinateTransaction = interface; // type: System.Transactions.SubordinateTransaction, namespace: System.Transactions
  DNTransactionInformation = interface; // type: System.Transactions.TransactionInformation, namespace: System.Transactions
  DNTransactionInterop = interface; // type: System.Transactions.TransactionInterop, namespace: System.Transactions
  DNTransactionManager = interface; // type: System.Transactions.TransactionManager, namespace: System.Transactions
  DNTransactionScope = interface; // type: System.Transactions.TransactionScope, namespace: System.Transactions
  DNTransactionOptions = interface; // type: System.Transactions.TransactionOptions, namespace: System.Transactions

{ delegates }

  [DNTypeName('System.Transactions.HostCurrentTransactionCallback')]
  DNHostCurrentTransactionCallback = function: DNTransaction of object;

  [DNTypeName('System.Transactions.TransactionCompletedEventHandler')]
  DNTransactionCompletedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNTransactionEventArgs) of object;

  [DNTypeName('System.Transactions.TransactionStartedEventHandler')]
  DNTransactionStartedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNTransactionEventArgs) of object;




{ objects }

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IDtcTransaction')]
  DNIDtcTransaction = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0FB15084-AF41-11CE-BD2B-204C4F4F5020}']
  { methods } 

    procedure Commit(retaining: Int32; commitType: Int32; reserved: Int32);
    procedure &Abort(reason: IntPtr; retaining: Int32; async: Int32);
    procedure GetTransactionInfo(transactionInformation: IntPtr);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IEnlistmentNotification')]
  DNIEnlistmentNotification = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{68723FCB-A005-3CD5-AF43-E27703E304F2}']
  { methods } 

    procedure Prepare(preparingEnlistment: DNPreparingEnlistment);
    procedure Commit(enlistment: DNEnlistment);
    procedure Rollback(enlistment: DNEnlistment);
    procedure InDoubt(enlistment: DNEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ISinglePhaseNotification')]
  DNISinglePhaseNotification = interface(DNIEnlistmentNotification)
  ['{2354C464-7457-3AE8-AF68-751AF5A1FFC0}']
  { methods } 

    procedure SinglePhaseCommit(singlePhaseEnlistment: DNSinglePhaseEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ITransactionPromoter')]
  DNITransactionPromoter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2EE24BD6-197C-3BD2-ABB2-03F7113E3B60}']
  { methods } 

    function Promote: TArray<Byte>;

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.IPromotableSinglePhaseNotification')]
  DNIPromotableSinglePhaseNotification = interface(DNITransactionPromoter)
  ['{5C25E3AA-572A-331E-88C5-CD69DCEF4C71}']
  { methods } 

    procedure Initialize;
    procedure SinglePhaseCommit(singlePhaseEnlistment: DNSinglePhaseEnlistment);
    procedure Rollback(singlePhaseEnlistment: DNSinglePhaseEnlistment);

  end;

  //-------------namespace: System.Transactions----------------
  [DNTypeName('System.Transactions.ISimpleTransactionSuperior')]
  DNISimpleTransactionSuperior = interface(DNITransactionPromoter)
  ['{8C30F42C-7396-303C-89E2-3EB683EF53BD}']
  { methods } 

    procedure Rollback;

  end;

  //-------------namespace: System.Transactions----------------
  DNTransactionEventArgsClass = interface(DDNC.System.Private.CoreLib.DNEventArgsClass)
  ['{81CDE50B-9F55-5AAB-829E-3BF5DEBE7AEB}']
  { constructors } 

    {class} function init: DNTransactionEventArgs;

  end;

  [DNTypeName('System.Transactions.TransactionEventArgs')]
  DNTransactionEventArgs = interface(DDNC.System.Private.CoreLib.DNEventArgs)
  ['{A65F6902-A689-3D01-969D-B841C13D6D42}']
  { getters & setters } 

    function get_Transaction: DNTransaction;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Transaction: DNTransaction read get_Transaction;
  end;

  TDNTransactionEventArgs = class(TDNGenericImport<DNTransactionEventArgsClass, DNTransactionEventArgs>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionExceptionClass = interface(DDNC.System.Private.CoreLib.DNSystemExceptionClass)
  ['{B36873A2-CFF9-5A6C-8C56-49D7C6D85B46}']
  { constructors } 

    {class} function init: DNTransactionException; overload;
    {class} function init(message: string): DNTransactionException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionException')]
  DNTransactionException = interface(DDNC.System.Private.CoreLib.DNSystemException)
  ['{BAFE4B9C-890D-31B4-8F9C-EB2C8B253CA6}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionException = class(TDNGenericImport<DNTransactionExceptionClass, DNTransactionException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionAbortedExceptionClass = interface(DNTransactionExceptionClass)
  ['{B368E515-74BA-5BD2-BDA3-EAC1C178FC90}']
  { constructors } 

    {class} function init: DNTransactionAbortedException; overload;
    {class} function init(message: string): DNTransactionAbortedException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionAbortedException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionAbortedException')]
  DNTransactionAbortedException = interface(DNTransactionException)
  ['{29A833D6-F344-30BA-83B0-858033E37218}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionAbortedException = class(TDNGenericImport<DNTransactionAbortedExceptionClass, DNTransactionAbortedException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInDoubtExceptionClass = interface(DNTransactionExceptionClass)
  ['{82E569D8-E51E-5EFA-B3FE-9925F55F83CE}']
  { constructors } 

    {class} function init: DNTransactionInDoubtException; overload;
    {class} function init(message: string): DNTransactionInDoubtException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionInDoubtException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionInDoubtException')]
  DNTransactionInDoubtException = interface(DNTransactionException)
  ['{D148C12A-DC69-3A9F-96F8-79B7FFAC8775}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionInDoubtException = class(TDNGenericImport<DNTransactionInDoubtExceptionClass, DNTransactionInDoubtException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionManagerCommunicationExceptionClass = interface(DNTransactionExceptionClass)
  ['{F671562D-0082-5680-8FD2-4CCF4A51D7CB}']
  { constructors } 

    {class} function init: DNTransactionManagerCommunicationException; overload;
    {class} function init(message: string): DNTransactionManagerCommunicationException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionManagerCommunicationException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionManagerCommunicationException')]
  DNTransactionManagerCommunicationException = interface(DNTransactionException)
  ['{8BD1FF88-FB2B-3B1F-8419-D123C314CB7E}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionManagerCommunicationException = class(TDNGenericImport<DNTransactionManagerCommunicationExceptionClass, DNTransactionManagerCommunicationException>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionPromotionExceptionClass = interface(DNTransactionExceptionClass)
  ['{9EC6D66B-5C73-5861-A5AE-D4592A303BEE}']
  { constructors } 

    {class} function init: DNTransactionPromotionException; overload;
    {class} function init(message: string): DNTransactionPromotionException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNTransactionPromotionException; overload;

  end;

  [DNTypeName('System.Transactions.TransactionPromotionException')]
  DNTransactionPromotionException = interface(DNTransactionException)
  ['{F29A84DE-A3A5-38D5-81B0-76D359CD7164}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNTransactionPromotionException = class(TDNGenericImport<DNTransactionPromotionExceptionClass, DNTransactionPromotionException>) end;

  //-------------namespace: System.Transactions----------------
  DNEnlistmentClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{4C6E287F-85D3-525C-97E6-3778E6391717}']
  end;

  [DNTypeName('System.Transactions.Enlistment')]
  DNEnlistment = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0F036F01-3366-397F-8F9D-BA702AFE2F43}']
  { methods } 

    procedure Done;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNEnlistment = class(TDNGenericImport<DNEnlistmentClass, DNEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNPreparingEnlistmentClass = interface(DNEnlistmentClass)
  ['{1495E886-3DBF-5A46-BEB6-B68A4B47BD02}']
  end;

  [DNTypeName('System.Transactions.PreparingEnlistment')]
  DNPreparingEnlistment = interface(DNEnlistment)
  ['{19CEF00D-C14D-3D4F-9F16-CA0DC8D40192}']
  { methods } 

    procedure Prepared;
    procedure ForceRollback; overload;
    procedure ForceRollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function RecoveryInformation: TArray<Byte>;
    procedure Done;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNPreparingEnlistment = class(TDNGenericImport<DNPreparingEnlistmentClass, DNPreparingEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNSinglePhaseEnlistmentClass = interface(DNEnlistmentClass)
  ['{7E0D19EB-5FD4-503B-9BBF-007B09E0FB85}']
  end;

  [DNTypeName('System.Transactions.SinglePhaseEnlistment')]
  DNSinglePhaseEnlistment = interface(DNEnlistment)
  ['{9C818C38-B3F3-368B-8F83-52C4198CADA7}']
  { methods } 

    procedure Aborted; overload;
    procedure Aborted(e: DDNC.System.Private.CoreLib.DNException); overload;
    procedure Committed;
    procedure InDoubt; overload;
    procedure InDoubt(e: DDNC.System.Private.CoreLib.DNException); overload;
    procedure Done;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNSinglePhaseEnlistment = class(TDNGenericImport<DNSinglePhaseEnlistmentClass, DNSinglePhaseEnlistment>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionClass = interface(DNObjectClass)
  ['{703D4FDF-22DB-5B57-884D-A0B894B2A62F}']
  { static getter & setter } 

    {class} function get_Current: DNTransaction;
    {class} procedure set_Current(value: DNTransaction);

  { static propertys } 

    {class} property Current: DNTransaction read get_Current write set_Current;
  end;

  [DNTypeName('System.Transactions.Transaction')]
  DNTransaction = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{D2F6D479-9222-3422-A310-60CCD6FCF660}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNTransaction = class(TDNGenericImport<DNTransactionClass, DNTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNCommittableTransactionClass = interface(DNTransactionClass)
  ['{E0F27980-D5BD-58C7-953C-F952B7E06540}']
  { constructors } 

    {class} function init: DNCommittableTransaction; overload;
    {class} function init(timeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNCommittableTransaction; overload;
    {class} function init(options: DNTransactionOptions): DNCommittableTransaction; overload;

  end;

  [DNTypeName('System.Transactions.CommittableTransaction')]
  DNCommittableTransaction = interface(DNTransaction)
  ['{37C02A23-54EA-36D1-9D69-32BB97A98159}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function BeginCommit(asyncCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; asyncState: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure Commit;
    procedure EndCommit(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNCommittableTransaction = class(TDNGenericImport<DNCommittableTransactionClass, DNCommittableTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNDependentTransactionClass = interface(DNTransactionClass)
  ['{9D9BD86E-5289-5F5C-92FA-56E3098304DF}']
  end;

  [DNTypeName('System.Transactions.DependentTransaction')]
  DNDependentTransaction = interface(DNTransaction)
  ['{ADEDFFD8-9B32-30D0-814A-2C93BABB5CE4}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    procedure Complete;
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNDependentTransaction = class(TDNGenericImport<DNDependentTransactionClass, DNDependentTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNSubordinateTransactionClass = interface(DNTransactionClass)
  ['{CBBE5A29-EBA1-5F18-8E24-5DC274AB4A98}']
  { constructors } 

    {class} function init(isoLevel: DNIsolationLevel; superior: DNISimpleTransactionSuperior): DNSubordinateTransaction;

  end;

  [DNTypeName('System.Transactions.SubordinateTransaction')]
  DNSubordinateTransaction = interface(DNTransaction)
  ['{3105A5DA-DB24-3F3B-8CB8-6854DA44A7F0}']
  { getters & setters } 

    function get_TransactionInformation: DNTransactionInformation;
    function get_IsolationLevel: DNIsolationLevel;
    function get_PromoterType: DDNC.System.Private.CoreLib.DNGuid;

  { events } 

    procedure add_TransactionCompleted(value: DNTransactionCompletedEventHandler);
    procedure remove_TransactionCompleted(value: DNTransactionCompletedEventHandler);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetPromotedToken: TArray<Byte>;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    procedure Rollback; overload;
    procedure Rollback(e: DDNC.System.Private.CoreLib.DNException); overload;
    function EnlistVolatile(enlistmentNotification: DNIEnlistmentNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function EnlistVolatile(singlePhaseNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment; overload;
    function Clone: DNTransaction;
    function DependentClone(cloneOption: DNDependentCloneOption): DNDependentTransaction;
    procedure Dispose;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification): Boolean; overload;
    function EnlistPromotableSinglePhase(promotableSinglePhaseNotification: DNIPromotableSinglePhaseNotification; promoterType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    function PromoteAndEnlistDurable(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; promotableNotification: DNIPromotableSinglePhaseNotification; enlistmentNotification: DNISinglePhaseNotification; enlistmentOptions: DNEnlistmentOptions): DNEnlistment;
    procedure SetDistributedTransactionIdentifier(promotableNotification: DNIPromotableSinglePhaseNotification; distributedTransactionIdentifier: DDNC.System.Private.CoreLib.DNGuid);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property TransactionInformation: DNTransactionInformation read get_TransactionInformation;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel;
    property PromoterType: DDNC.System.Private.CoreLib.DNGuid read get_PromoterType;
  end;

  TDNSubordinateTransaction = class(TDNGenericImport<DNSubordinateTransactionClass, DNSubordinateTransaction>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInformationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{5FA9B400-86F6-5568-90F9-C5B3F04F38F1}']
  end;

  [DNTypeName('System.Transactions.TransactionInformation')]
  DNTransactionInformation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{585B26B5-E339-3E4F-921E-5AF4EA2D9EFC}']
  { getters & setters } 

    function get_LocalIdentifier: string;
    function get_DistributedIdentifier: DDNC.System.Private.CoreLib.DNGuid;
    function get_CreationTime: DDNC.System.Private.CoreLib.DNDateTime;
    function get_Status: DNTransactionStatus;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property LocalIdentifier: string read get_LocalIdentifier;
    property DistributedIdentifier: DDNC.System.Private.CoreLib.DNGuid read get_DistributedIdentifier;
    property CreationTime: DDNC.System.Private.CoreLib.DNDateTime read get_CreationTime;
    property Status: DNTransactionStatus read get_Status;
  end;

  TDNTransactionInformation = class(TDNGenericImport<DNTransactionInformationClass, DNTransactionInformation>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionInteropClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7BA3DAC0-9274-5433-B19C-B3305C7F1E33}']
  { static fields getter & setter } 

   function __fakeFieldGet_PromoterTypeDtc: DDNC.System.Private.CoreLib.DNGuid;

  { static fields } 

    {class} property PromoterTypeDtc: DDNC.System.Private.CoreLib.DNGuid read __fakeFieldGet_PromoterTypeDtc;

  { static methods } 

    {class} function GetExportCookie(transaction: DNTransaction; whereabouts: TArray<Byte>): TArray<Byte>;
    {class} function GetTransactionFromExportCookie(cookie: TArray<Byte>): DNTransaction;
    {class} function GetTransmitterPropagationToken(transaction: DNTransaction): TArray<Byte>;
    {class} function GetTransactionFromTransmitterPropagationToken(propagationToken: TArray<Byte>): DNTransaction;
    {class} function GetDtcTransaction(transaction: DNTransaction): DNIDtcTransaction;
    {class} function GetTransactionFromDtcTransaction(transactionNative: DNIDtcTransaction): DNTransaction;
    {class} function GetWhereabouts: TArray<Byte>;

  end;

  [DNTypeName('System.Transactions.TransactionInterop')]
  DNTransactionInterop = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A1AAFA7B-481D-3EC2-9E57-815976593425}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNTransactionInterop = class(TDNGenericImport<DNTransactionInteropClass, DNTransactionInterop>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionManagerClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{E44A0533-90C5-5148-9E01-BE5A68BF4ACC}']
  { static getter & setter } 

    {class} function get_HostCurrentCallback: DNHostCurrentTransactionCallback;
    {class} procedure set_HostCurrentCallback(value: DNHostCurrentTransactionCallback);
    {class} function get_DefaultTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    {class} function get_MaximumTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;

  { static methods } 

    {class} function Reenlist(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid; recoveryInformation: TArray<Byte>; enlistmentNotification: DNIEnlistmentNotification): DNEnlistment;
    {class} procedure RecoveryComplete(resourceManagerIdentifier: DDNC.System.Private.CoreLib.DNGuid);

  { static propertys } 

    {class} property HostCurrentCallback: DNHostCurrentTransactionCallback read get_HostCurrentCallback write set_HostCurrentCallback;
    {class} property DefaultTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_DefaultTimeout;
    {class} property MaximumTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_MaximumTimeout;
  end;

  [DNTypeName('System.Transactions.TransactionManager')]
  DNTransactionManager = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3BFDD74D-D649-3D09-9F90-624252059FD9}']
  { events } 

    {class} procedure add_DistributedTransactionStarted(value: DNTransactionStartedEventHandler);
    {class} procedure remove_DistributedTransactionStarted(value: DNTransactionStartedEventHandler);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNTransactionManager = class(TDNGenericImport<DNTransactionManagerClass, DNTransactionManager>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionScopeClass = interface(DNObjectClass)
  ['{9D5729B1-02E9-54B0-A08A-0D58F8DEEA76}']
  { constructors } 

    {class} function init: DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption): DNTransactionScope; overload;
    {class} function init(asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(scopeOption: DNTransactionScopeOption; transactionOptions: DNTransactionOptions; interopOption: DNEnterpriseServicesInteropOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; asyncFlowOption: DNTransactionScopeAsyncFlowOption): DNTransactionScope; overload;
    {class} function init(transactionToUse: DNTransaction; scopeTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; interopOption: DNEnterpriseServicesInteropOption): DNTransactionScope; overload;

  end;

  [DNTypeName('System.Transactions.TransactionScope')]
  DNTransactionScope = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{AA916494-44F3-3747-8174-53C15F5DBEC8}']
  { methods } 

    procedure Dispose;
    procedure Complete;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNTransactionScope = class(TDNGenericImport<DNTransactionScopeClass, DNTransactionScope>) end;

  //-------------namespace: System.Transactions----------------
  DNTransactionOptionsClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{D520070C-AB51-53C0-99DC-BE4ED0223908}']
  end;

  [DNTypeName('System.Transactions.TransactionOptions')]
  DNTransactionOptions = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{71E5A231-6AB0-3973-91D5-E49FFB7D0668}']
  { getters & setters } 

    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_IsolationLevel: DNIsolationLevel;
    procedure set_IsolationLevel(value: DNIsolationLevel);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
    property IsolationLevel: DNIsolationLevel read get_IsolationLevel write set_IsolationLevel;
  end;

  TDNTransactionOptions = class(TDNGenericImport<DNTransactionOptionsClass, DNTransactionOptions>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Transactions.Local, Version=5.0.0.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51');

finalization

end.
