//----------------------------------------------------------------------------
//  System.Security.Cryptography.Csp.dll: System.Security.Cryptography.Csp, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.Csp
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.Csp;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Security.Cryptography.Algorithms,
  DDNC.System.Security.Cryptography.Primitives;

type

{ enums }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CspProviderFlags')]
  DNCspProviderFlags = type Integer;
  DNCspProviderFlagsHelper = record helper for DNCspProviderFlags
  public const
    NoFlags = 0;
    UseMachineKeyStore = 1;
    UseDefaultKeyContainer = 2;
    UseNonExportableKey = 4;
    UseExistingKey = 8;
    UseArchivableKey = 16;
    UseUserProtectedKey = 32;
    NoPrompt = 64;
    CreateEphemeralKey = 128;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.KeyNumber')]
  DNKeyNumber = type Integer;
  DNKeyNumberHelper = record helper for DNKeyNumber
  public const
    Exchange = 1;
    Signature = 2;
  end;




type


{ declares }

  DNICspAsymmetricAlgorithm = interface; // type: System.Security.Cryptography.ICspAsymmetricAlgorithm, namespace: System.Security.Cryptography
  DNDSACryptoServiceProvider = interface; // type: System.Security.Cryptography.DSACryptoServiceProvider, namespace: System.Security.Cryptography
  DNRSACryptoServiceProvider = interface; // type: System.Security.Cryptography.RSACryptoServiceProvider, namespace: System.Security.Cryptography
  DNCspKeyContainerInfo = interface; // type: System.Security.Cryptography.CspKeyContainerInfo, namespace: System.Security.Cryptography
  DNCspParameters = interface; // type: System.Security.Cryptography.CspParameters, namespace: System.Security.Cryptography
  DNPasswordDeriveBytes = interface; // type: System.Security.Cryptography.PasswordDeriveBytes, namespace: System.Security.Cryptography
  DNMD5CryptoServiceProvider = interface; // type: System.Security.Cryptography.MD5CryptoServiceProvider, namespace: System.Security.Cryptography
  DNSHA1CryptoServiceProvider = interface; // type: System.Security.Cryptography.SHA1CryptoServiceProvider, namespace: System.Security.Cryptography
  DNSHA256CryptoServiceProvider = interface; // type: System.Security.Cryptography.SHA256CryptoServiceProvider, namespace: System.Security.Cryptography
  DNSHA384CryptoServiceProvider = interface; // type: System.Security.Cryptography.SHA384CryptoServiceProvider, namespace: System.Security.Cryptography
  DNSHA512CryptoServiceProvider = interface; // type: System.Security.Cryptography.SHA512CryptoServiceProvider, namespace: System.Security.Cryptography
  DNRNGCryptoServiceProvider = interface; // type: System.Security.Cryptography.RNGCryptoServiceProvider, namespace: System.Security.Cryptography
  DNAesCryptoServiceProvider = interface; // type: System.Security.Cryptography.AesCryptoServiceProvider, namespace: System.Security.Cryptography
  DNDESCryptoServiceProvider = interface; // type: System.Security.Cryptography.DESCryptoServiceProvider, namespace: System.Security.Cryptography
  DNRC2CryptoServiceProvider = interface; // type: System.Security.Cryptography.RC2CryptoServiceProvider, namespace: System.Security.Cryptography
  DNTripleDESCryptoServiceProvider = interface; // type: System.Security.Cryptography.TripleDESCryptoServiceProvider, namespace: System.Security.Cryptography


{ objects }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.ICspAsymmetricAlgorithm')]
  DNICspAsymmetricAlgorithm = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{494A7583-190E-3693-9EC4-DE54DC6A84A2}']
  { getters & setters } 

    function get_CspKeyContainerInfo: DNCspKeyContainerInfo;

  { methods } 

    function ExportCspBlob(includePrivateParameters: Boolean): TArray<Byte>;
    procedure ImportCspBlob(rawData: TArray<Byte>);

  { propertys } 

    property CspKeyContainerInfo: DNCspKeyContainerInfo read get_CspKeyContainerInfo;
  end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSACryptoServiceProviderClass = interface(DNObjectClass)
  ['{8254FF7D-94E2-5DAA-9E56-F37539CE395F}']
  { static getter & setter } 

    {class} function get_UseMachineKeyStore: Boolean;
    {class} procedure set_UseMachineKeyStore(value: Boolean);

  { constructors } 

    {class} function init: DNDSACryptoServiceProvider; overload;
    {class} function init(dwKeySize: Int32): DNDSACryptoServiceProvider; overload;
    {class} function init(parameters: DNCspParameters): DNDSACryptoServiceProvider; overload;
    {class} function init(dwKeySize: Int32; parameters: DNCspParameters): DNDSACryptoServiceProvider; overload;

  { static propertys } 

    {class} property UseMachineKeyStore: Boolean read get_UseMachineKeyStore write set_UseMachineKeyStore;
  end;

  [DNTypeName('System.Security.Cryptography.DSACryptoServiceProvider')]
  DNDSACryptoServiceProvider = interface(DNObject)
  ['{3617A992-A87A-3273-AA29-0657F7CF2F43}']
  { getters & setters } 

    function get_CspKeyContainerInfo: DNCspKeyContainerInfo;
    function get_KeySize: Int32;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_PersistKeyInCsp: Boolean;
    procedure set_PersistKeyInCsp(value: Boolean);
    function get_PublicOnly: Boolean;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function ExportCspBlob(includePrivateParameters: Boolean): TArray<Byte>;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters;
    procedure ImportCspBlob(keyBlob: TArray<Byte>);
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function SignData(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function SignData(buffer: TArray<Byte>): TArray<Byte>; overload;
    function SignData(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function VerifyData(rgbData: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function SignHash(rgbHash: TArray<Byte>; str: string): TArray<Byte>;
    function VerifyHash(rgbHash: TArray<Byte>; str: string; rgbSignature: TArray<Byte>): Boolean;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function CreateSignature(rgbHash: TArray<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function GetMaxSignatureSize(signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Int32;
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property CspKeyContainerInfo: DNCspKeyContainerInfo read get_CspKeyContainerInfo;
    property KeySize: Int32 read get_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property PersistKeyInCsp: Boolean read get_PersistKeyInCsp write set_PersistKeyInCsp;
    property PublicOnly: Boolean read get_PublicOnly;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNDSACryptoServiceProvider = class(TDNGenericImport<DNDSACryptoServiceProviderClass, DNDSACryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSACryptoServiceProviderClass = interface(DNObjectClass)
  ['{F6A79A47-3825-598F-A4A9-60DCC97D7932}']
  { static getter & setter } 

    {class} function get_UseMachineKeyStore: Boolean;
    {class} procedure set_UseMachineKeyStore(value: Boolean);

  { constructors } 

    {class} function init: DNRSACryptoServiceProvider; overload;
    {class} function init(dwKeySize: Int32): DNRSACryptoServiceProvider; overload;
    {class} function init(dwKeySize: Int32; parameters: DNCspParameters): DNRSACryptoServiceProvider; overload;
    {class} function init(parameters: DNCspParameters): DNRSACryptoServiceProvider; overload;

  { static propertys } 

    {class} property UseMachineKeyStore: Boolean read get_UseMachineKeyStore write set_UseMachineKeyStore;
  end;

  [DNTypeName('System.Security.Cryptography.RSACryptoServiceProvider')]
  DNRSACryptoServiceProvider = interface(DNObject)
  ['{9F08392A-9131-3527-9126-15F1D64D0A97}']
  { getters & setters } 

    function get_CspKeyContainerInfo: DNCspKeyContainerInfo;
    function get_KeySize: Int32;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_PersistKeyInCsp: Boolean;
    procedure set_PersistKeyInCsp(value: Boolean);
    function get_PublicOnly: Boolean;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function Decrypt(rgb: TArray<Byte>; fOAEP: Boolean): TArray<Byte>; overload;
    function DecryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function Encrypt(rgb: TArray<Byte>; fOAEP: Boolean): TArray<Byte>; overload;
    function EncryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function ExportCspBlob(includePrivateParameters: Boolean): TArray<Byte>;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters;
    procedure ImportCspBlob(keyBlob: TArray<Byte>);
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function SignData(buffer: TArray<Byte>; offset: Int32; count: Int32; halg: DDNC.System.Private.CoreLib.DNObject): TArray<Byte>; overload;
    function SignData(buffer: TArray<Byte>; halg: DDNC.System.Private.CoreLib.DNObject): TArray<Byte>; overload;
    function SignData(inputStream: DDNC.System.Private.CoreLib.DNStream; halg: DDNC.System.Private.CoreLib.DNObject): TArray<Byte>; overload;
    function SignHash(rgbHash: TArray<Byte>; str: string): TArray<Byte>; overload;
    function VerifyData(buffer: TArray<Byte>; halg: DDNC.System.Private.CoreLib.DNObject; signature: TArray<Byte>): Boolean; overload;
    function VerifyHash(rgbHash: TArray<Byte>; str: string; rgbSignature: TArray<Byte>): Boolean; overload;
    function Encrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>; overload;
    function Decrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>; overload;
    function SignHash(hash: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function TryDecrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TryEncrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function ExportRSAPrivateKey: TArray<Byte>;
    function TryExportRSAPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ExportRSAPublicKey: TArray<Byte>;
    function TryExportRSAPublicKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPublicKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property CspKeyContainerInfo: DNCspKeyContainerInfo read get_CspKeyContainerInfo;
    property KeySize: Int32 read get_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property PersistKeyInCsp: Boolean read get_PersistKeyInCsp write set_PersistKeyInCsp;
    property PublicOnly: Boolean read get_PublicOnly;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNRSACryptoServiceProvider = class(TDNGenericImport<DNRSACryptoServiceProviderClass, DNRSACryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCspKeyContainerInfoClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7CDA0DAD-1958-56D0-9113-523BC6FB1CE3}']
  { constructors } 

    {class} function init(parameters: DNCspParameters): DNCspKeyContainerInfo;

  end;

  [DNTypeName('System.Security.Cryptography.CspKeyContainerInfo')]
  DNCspKeyContainerInfo = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{66C31E39-CE8D-3CE4-AF21-FED97B4F5DC6}']
  { getters & setters } 

    function get_Accessible: Boolean;
    function get_Exportable: Boolean;
    function get_HardwareDevice: Boolean;
    function get_KeyContainerName: string;
    function get_KeyNumber: DNKeyNumber;
    function get_MachineKeyStore: Boolean;
    function get_Protected: Boolean;
    function get_ProviderName: string;
    function get_ProviderType: Int32;
    function get_RandomlyGenerated: Boolean;
    function get_Removable: Boolean;
    function get_UniqueKeyContainerName: string;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Accessible: Boolean read get_Accessible;
    property Exportable: Boolean read get_Exportable;
    property HardwareDevice: Boolean read get_HardwareDevice;
    property KeyContainerName: string read get_KeyContainerName;
    property KeyNumber: DNKeyNumber read get_KeyNumber;
    property MachineKeyStore: Boolean read get_MachineKeyStore;
    property &Protected: Boolean read get_Protected;
    property ProviderName: string read get_ProviderName;
    property ProviderType: Int32 read get_ProviderType;
    property RandomlyGenerated: Boolean read get_RandomlyGenerated;
    property Removable: Boolean read get_Removable;
    property UniqueKeyContainerName: string read get_UniqueKeyContainerName;
  end;

  TDNCspKeyContainerInfo = class(TDNGenericImport<DNCspKeyContainerInfoClass, DNCspKeyContainerInfo>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCspParametersClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{E9089B8B-80D9-500B-B78A-426E1B54BE10}']
  { constructors } 

    {class} function init: DNCspParameters; overload;
    {class} function init(dwTypeIn: Int32): DNCspParameters; overload;
    {class} function init(dwTypeIn: Int32; strProviderNameIn: string): DNCspParameters; overload;
    {class} function init(dwTypeIn: Int32; strProviderNameIn: string; strContainerNameIn: string): DNCspParameters; overload;

  end;

  [DNTypeName('System.Security.Cryptography.CspParameters')]
  DNCspParameters = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{49EB3240-AA4B-3213-9513-4B4955162968}']
  { getters & setters } 

    function get_Flags: DNCspProviderFlags;
    procedure set_Flags(value: DNCspProviderFlags);
    function get_KeyPassword: DDNC.System.Private.CoreLib.DNSecureString;
    procedure set_KeyPassword(value: DDNC.System.Private.CoreLib.DNSecureString);
    function get_ParentWindowHandle: IntPtr;
    procedure set_ParentWindowHandle(value: IntPtr);

  { fields getter & setter } 

   function __fakeFieldGet_ProviderType: Int32;
   procedure __fakeFieldSet_ProviderType(value: Int32);
   function __fakeFieldGet_ProviderName: string;
   procedure __fakeFieldSet_ProviderName(value: string);
   function __fakeFieldGet_KeyContainerName: string;
   procedure __fakeFieldSet_KeyContainerName(value: string);
   function __fakeFieldGet_KeyNumber: Int32;
   procedure __fakeFieldSet_KeyNumber(value: Int32);

  { fields } 

   property ProviderType: Int32 read __fakeFieldGet_ProviderType write __fakeFieldSet_ProviderType;
   property ProviderName: string read __fakeFieldGet_ProviderName write __fakeFieldSet_ProviderName;
   property KeyContainerName: string read __fakeFieldGet_KeyContainerName write __fakeFieldSet_KeyContainerName;
   property KeyNumber: Int32 read __fakeFieldGet_KeyNumber write __fakeFieldSet_KeyNumber;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Flags: DNCspProviderFlags read get_Flags write set_Flags;
    property KeyPassword: DDNC.System.Private.CoreLib.DNSecureString read get_KeyPassword write set_KeyPassword;
    property ParentWindowHandle: IntPtr read get_ParentWindowHandle write set_ParentWindowHandle;
  end;

  TDNCspParameters = class(TDNGenericImport<DNCspParametersClass, DNCspParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNPasswordDeriveBytesClass = interface(DNObjectClass)
  ['{3B30E492-89C8-5FDF-B81C-395D6D38F0EE}']
  { constructors } 

    {class} function init(strPassword: string; rgbSalt: TArray<Byte>): DNPasswordDeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>): DNPasswordDeriveBytes; overload;
    {class} function init(strPassword: string; rgbSalt: TArray<Byte>; strHashName: string; iterations: Int32): DNPasswordDeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; hashName: string; iterations: Int32): DNPasswordDeriveBytes; overload;
    {class} function init(strPassword: string; rgbSalt: TArray<Byte>; cspParams: DNCspParameters): DNPasswordDeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; cspParams: DNCspParameters): DNPasswordDeriveBytes; overload;
    {class} function init(strPassword: string; rgbSalt: TArray<Byte>; strHashName: string; iterations: Int32; cspParams: DNCspParameters): DNPasswordDeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; hashName: string; iterations: Int32; cspParams: DNCspParameters): DNPasswordDeriveBytes; overload;

  end;

  [DNTypeName('System.Security.Cryptography.PasswordDeriveBytes')]
  DNPasswordDeriveBytes = interface(DNObject)
  ['{624F8043-F01B-3FFB-B708-53D950823E3F}']
  { getters & setters } 

    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_IterationCount: Int32;
    procedure set_IterationCount(value: Int32);
    function get_Salt: TArray<Byte>;
    procedure set_Salt(value: TArray<Byte>);

  { methods } 

    function GetBytes(cb: Int32): TArray<Byte>;
    procedure Reset;
    function CryptDeriveKey(algname: string; alghashname: string; keySize: Int32; rgbIV: TArray<Byte>): TArray<Byte>;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashName: string read get_HashName write set_HashName;
    property IterationCount: Int32 read get_IterationCount write set_IterationCount;
    property Salt: TArray<Byte> read get_Salt write set_Salt;
  end;

  TDNPasswordDeriveBytes = class(TDNGenericImport<DNPasswordDeriveBytesClass, DNPasswordDeriveBytes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNMD5CryptoServiceProviderClass = interface(DNObjectClass)
  ['{23D74F3B-604E-54EC-AA6A-3FAF5CCD0659}']
  { constructors } 

    {class} function init: DNMD5CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.MD5CryptoServiceProvider')]
  DNMD5CryptoServiceProvider = interface(DNObject)
  ['{950768AA-6B7C-3F35-A1EA-72043F77F925}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNMD5CryptoServiceProvider = class(TDNGenericImport<DNMD5CryptoServiceProviderClass, DNMD5CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA1CryptoServiceProviderClass = interface(DNObjectClass)
  ['{AD86CB13-5B76-5921-A52B-F1F94E4B243D}']
  { constructors } 

    {class} function init: DNSHA1CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.SHA1CryptoServiceProvider')]
  DNSHA1CryptoServiceProvider = interface(DNObject)
  ['{F167ED3A-B911-3643-8B0A-F2245FF1CD1A}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA1CryptoServiceProvider = class(TDNGenericImport<DNSHA1CryptoServiceProviderClass, DNSHA1CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA256CryptoServiceProviderClass = interface(DNObjectClass)
  ['{5A36D26E-F0AB-516C-B085-8C8836D567CD}']
  { constructors } 

    {class} function init: DNSHA256CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.SHA256CryptoServiceProvider')]
  DNSHA256CryptoServiceProvider = interface(DNObject)
  ['{489D1B26-D6FF-321E-A986-5F48AE9C1814}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA256CryptoServiceProvider = class(TDNGenericImport<DNSHA256CryptoServiceProviderClass, DNSHA256CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA384CryptoServiceProviderClass = interface(DNObjectClass)
  ['{7064754C-A5CB-533D-B2C1-4942F9961819}']
  { constructors } 

    {class} function init: DNSHA384CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.SHA384CryptoServiceProvider')]
  DNSHA384CryptoServiceProvider = interface(DNObject)
  ['{75DD6AA1-9F0C-32B1-A942-3E32BF4BD44D}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA384CryptoServiceProvider = class(TDNGenericImport<DNSHA384CryptoServiceProviderClass, DNSHA384CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA512CryptoServiceProviderClass = interface(DNObjectClass)
  ['{7A18F409-87BD-59BA-8350-81AD5AE94059}']
  { constructors } 

    {class} function init: DNSHA512CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.SHA512CryptoServiceProvider')]
  DNSHA512CryptoServiceProvider = interface(DNObject)
  ['{6F8F30A4-1382-30D9-A65A-778BA60564DA}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA512CryptoServiceProvider = class(TDNGenericImport<DNSHA512CryptoServiceProviderClass, DNSHA512CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRNGCryptoServiceProviderClass = interface(DNObjectClass)
  ['{2DC9C2B9-FC73-5B7F-8E92-CA6B1FF61299}']
  { constructors } 

    {class} function init: DNRNGCryptoServiceProvider; overload;
    {class} function init(str: string): DNRNGCryptoServiceProvider; overload;
    {class} function init(rgb: TArray<Byte>): DNRNGCryptoServiceProvider; overload;
    {class} function init(cspParams: DNCspParameters): DNRNGCryptoServiceProvider; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RNGCryptoServiceProvider')]
  DNRNGCryptoServiceProvider = interface(DNObject)
  ['{95DE0605-958C-3819-99EF-8F313593DE92}']
  { methods } 

    procedure GetBytes(data: TArray<Byte>); overload;
    procedure GetBytes(data: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure GetBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    procedure GetNonZeroBytes(data: TArray<Byte>); overload;
    procedure GetNonZeroBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNRNGCryptoServiceProvider = class(TDNGenericImport<DNRNGCryptoServiceProviderClass, DNRNGCryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesCryptoServiceProviderClass = interface(DNObjectClass)
  ['{60ED55F2-D854-548D-874F-6C2E466FCFF3}']
  { constructors } 

    {class} function init: DNAesCryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.AesCryptoServiceProvider')]
  DNAesCryptoServiceProvider = interface(DNObject)
  ['{F9A479AE-E10E-3E91-B3D2-98F5ADA38A8F}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNAesCryptoServiceProvider = class(TDNGenericImport<DNAesCryptoServiceProviderClass, DNAesCryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDESCryptoServiceProviderClass = interface(DNObjectClass)
  ['{1A8D9F84-7703-58B5-96C5-4DB394614638}']
  { constructors } 

    {class} function init: DNDESCryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.DESCryptoServiceProvider')]
  DNDESCryptoServiceProvider = interface(DNObject)
  ['{8073731D-DFD4-3BE7-AF4B-EAA09805CE1F}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    procedure GenerateKey;
    procedure GenerateIV;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNDESCryptoServiceProvider = class(TDNGenericImport<DNDESCryptoServiceProviderClass, DNDESCryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRC2CryptoServiceProviderClass = interface(DNObjectClass)
  ['{88870BC0-BA63-5164-B8AF-954EAE18E2A3}']
  { constructors } 

    {class} function init: DNRC2CryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.RC2CryptoServiceProvider')]
  DNRC2CryptoServiceProvider = interface(DNObject)
  ['{684786F8-5B38-3E7F-A7F9-57190D37E607}']
  { getters & setters } 

    function get_EffectiveKeySize: Int32;
    procedure set_EffectiveKeySize(value: Int32);
    function get_UseSalt: Boolean;
    procedure set_UseSalt(value: Boolean);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateKey;
    procedure GenerateIV;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property EffectiveKeySize: Int32 read get_EffectiveKeySize write set_EffectiveKeySize;
    property UseSalt: Boolean read get_UseSalt write set_UseSalt;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNRC2CryptoServiceProvider = class(TDNGenericImport<DNRC2CryptoServiceProviderClass, DNRC2CryptoServiceProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNTripleDESCryptoServiceProviderClass = interface(DNObjectClass)
  ['{D2A436DC-394E-59FF-98ED-6C3D9E67CC06}']
  { constructors } 

    {class} function init: DNTripleDESCryptoServiceProvider;

  end;

  [DNTypeName('System.Security.Cryptography.TripleDESCryptoServiceProvider')]
  DNTripleDESCryptoServiceProvider = interface(DNObject)
  ['{953AFFEA-2114-3D38-BB8C-FA3396088282}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNTripleDESCryptoServiceProvider = class(TDNGenericImport<DNTripleDESCryptoServiceProviderClass, DNTripleDESCryptoServiceProvider>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.Csp, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
