//----------------------------------------------------------------------------
//  System.Security.Cryptography.Cng.dll: System.Security.Cryptography.Cng, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.Cng
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.Cng;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Security.Cryptography.Algorithms,
  DDNC.System.Security.Cryptography.Primitives;

type

{ enums }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngExportPolicies')]
  DNCngExportPolicies = type Integer;
  DNCngExportPoliciesHelper = record helper for DNCngExportPolicies
  public const
    None = 0;
    AllowExport = 1;
    AllowPlaintextExport = 2;
    AllowArchiving = 4;
    AllowPlaintextArchiving = 8;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngKeyCreationOptions')]
  DNCngKeyCreationOptions = type Integer;
  DNCngKeyCreationOptionsHelper = record helper for DNCngKeyCreationOptions
  public const
    None = 0;
    MachineKey = 32;
    OverwriteExistingKey = 128;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngKeyHandleOpenOptions')]
  DNCngKeyHandleOpenOptions = type Integer;
  DNCngKeyHandleOpenOptionsHelper = record helper for DNCngKeyHandleOpenOptions
  public const
    None = 0;
    EphemeralKey = 1;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngKeyOpenOptions')]
  DNCngKeyOpenOptions = type Integer;
  DNCngKeyOpenOptionsHelper = record helper for DNCngKeyOpenOptions
  public const
    None = 0;
    UserKey = 0;
    MachineKey = 32;
    Silent = 64;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngKeyUsages')]
  DNCngKeyUsages = type Integer;
  DNCngKeyUsagesHelper = record helper for DNCngKeyUsages
  public const
    None = 0;
    Decryption = 1;
    Signing = 2;
    KeyAgreement = 4;
    AllUsages = 16777215;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngPropertyOptions')]
  DNCngPropertyOptions = type Integer;
  DNCngPropertyOptionsHelper = record helper for DNCngPropertyOptions
  public const
    None = 0;
    CustomProperty = 1073741824;
    Persist = -2147483648;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.CngUIProtectionLevels')]
  DNCngUIProtectionLevels = type Integer;
  DNCngUIProtectionLevelsHelper = record helper for DNCngUIProtectionLevels
  public const
    None = 0;
    ProtectKey = 1;
    ForceHighProtection = 2;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanKeyDerivationFunction')]
  DNECDiffieHellmanKeyDerivationFunction = type Integer;
  DNECDiffieHellmanKeyDerivationFunctionHelper = record helper for DNECDiffieHellmanKeyDerivationFunction
  public const
    Hash = 0;
    Hmac = 1;
    Tls = 2;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.ECKeyXmlFormat')]
  DNECKeyXmlFormat = type Integer;
  DNECKeyXmlFormatHelper = record helper for DNECKeyXmlFormat
  public const
    Rfc4050 = 0;
  end;




type


{ declares }

  DNCngPropertyCollection = interface; // type: System.Security.Cryptography.CngPropertyCollection, namespace: System.Security.Cryptography
  DNSafeNCryptHandle = interface; // type: Microsoft.Win32.SafeHandles.SafeNCryptHandle, namespace: Microsoft.Win32.SafeHandles
  DNSafeNCryptKeyHandle = interface; // type: Microsoft.Win32.SafeHandles.SafeNCryptKeyHandle, namespace: Microsoft.Win32.SafeHandles
  DNSafeNCryptProviderHandle = interface; // type: Microsoft.Win32.SafeHandles.SafeNCryptProviderHandle, namespace: Microsoft.Win32.SafeHandles
  DNSafeNCryptSecretHandle = interface; // type: Microsoft.Win32.SafeHandles.SafeNCryptSecretHandle, namespace: Microsoft.Win32.SafeHandles
  DNDSACng = interface; // type: System.Security.Cryptography.DSACng, namespace: System.Security.Cryptography
  DNECDiffieHellmanCng = interface; // type: System.Security.Cryptography.ECDiffieHellmanCng, namespace: System.Security.Cryptography
  DNECDsaCng = interface; // type: System.Security.Cryptography.ECDsaCng, namespace: System.Security.Cryptography
  DNRSACng = interface; // type: System.Security.Cryptography.RSACng, namespace: System.Security.Cryptography
  DNCngAlgorithm = interface; // type: System.Security.Cryptography.CngAlgorithm, namespace: System.Security.Cryptography
  DNCngAlgorithmGroup = interface; // type: System.Security.Cryptography.CngAlgorithmGroup, namespace: System.Security.Cryptography
  DNCngKey = interface; // type: System.Security.Cryptography.CngKey, namespace: System.Security.Cryptography
  DNCngKeyBlobFormat = interface; // type: System.Security.Cryptography.CngKeyBlobFormat, namespace: System.Security.Cryptography
  DNCngKeyCreationParameters = interface; // type: System.Security.Cryptography.CngKeyCreationParameters, namespace: System.Security.Cryptography
  DNCngProvider = interface; // type: System.Security.Cryptography.CngProvider, namespace: System.Security.Cryptography
  DNCngUIPolicy = interface; // type: System.Security.Cryptography.CngUIPolicy, namespace: System.Security.Cryptography
  DNECDiffieHellmanCngPublicKey = interface; // type: System.Security.Cryptography.ECDiffieHellmanCngPublicKey, namespace: System.Security.Cryptography
  DNAesCng = interface; // type: System.Security.Cryptography.AesCng, namespace: System.Security.Cryptography
  DNTripleDESCng = interface; // type: System.Security.Cryptography.TripleDESCng, namespace: System.Security.Cryptography
  DNCngProperty = interface; // type: System.Security.Cryptography.CngProperty, namespace: System.Security.Cryptography


{ objects }

  //-------------namespace: System.Security.Cryptography----------------
  DNCngPropertyCollectionClass = interface(DDNC.System.Private.CoreLib.DNCollectionClass<DNCngProperty>)
  ['{88E3F7B5-AE5C-5F40-9751-C1C8ADB880C6}']
  { constructors } 

    {class} function init: DNCngPropertyCollection;

  end;

  [DNTypeName('System.Security.Cryptography.CngPropertyCollection')]
  DNCngPropertyCollection = interface(DDNC.System.Private.CoreLib.DNCollection<DNCngProperty>)
  ['{3CA447D2-4BDA-307F-AA98-A89D65F3A3DE}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    procedure CopyTo(&array: TArray<DNCngProperty>; index: Int32);
    function &Contains(item: DNCngProperty): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNCngProperty>;
    function IndexOf(item: DNCngProperty): Int32;
    procedure Insert(index: Int32; item: DNCngProperty);
    procedure RemoveAt(index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNCngPropertyCollection = class(TDNGenericImport<DNCngPropertyCollectionClass, DNCngPropertyCollection>) end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafeNCryptHandleClass = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalidClass)
  ['{66C76AED-ACCD-5DA8-BD51-169660AB37BA}']
  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafeNCryptHandle')]
  DNSafeNCryptHandle = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalid)
  ['{FE0FF9E9-6449-3E0D-A5DD-F11104B28A09}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeNCryptHandle = class(TDNGenericImport<DNSafeNCryptHandleClass, DNSafeNCryptHandle>) end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafeNCryptKeyHandleClass = interface(DNSafeNCryptHandleClass)
  ['{109D535D-92DB-5C7F-B5D1-20A7F932AD5D}']
  { constructors } 

    {class} function init: DNSafeNCryptKeyHandle; overload;
    {class} function init(handle: IntPtr; parentHandle: DDNC.System.Private.CoreLib.DNSafeHandle): DNSafeNCryptKeyHandle; overload;

  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafeNCryptKeyHandle')]
  DNSafeNCryptKeyHandle = interface(DNSafeNCryptHandle)
  ['{AF2F5020-1BF6-316F-A5CD-B27C5D46D94E}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeNCryptKeyHandle = class(TDNGenericImport<DNSafeNCryptKeyHandleClass, DNSafeNCryptKeyHandle>) end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafeNCryptProviderHandleClass = interface(DNSafeNCryptHandleClass)
  ['{44C7E3EE-4F9D-57C9-8824-FA5472511C0E}']
  { constructors } 

    {class} function init: DNSafeNCryptProviderHandle;

  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafeNCryptProviderHandle')]
  DNSafeNCryptProviderHandle = interface(DNSafeNCryptHandle)
  ['{ADAB0200-B652-32C3-B621-407A47A60330}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeNCryptProviderHandle = class(TDNGenericImport<DNSafeNCryptProviderHandleClass, DNSafeNCryptProviderHandle>) end;

  //-------------namespace: Microsoft.Win32.SafeHandles----------------
  DNSafeNCryptSecretHandleClass = interface(DNSafeNCryptHandleClass)
  ['{758B0A05-B2B4-5DF1-8B2D-5A3FD03AC89D}']
  { constructors } 

    {class} function init: DNSafeNCryptSecretHandle;

  end;

  [DNTypeName('Microsoft.Win32.SafeHandles.SafeNCryptSecretHandle')]
  DNSafeNCryptSecretHandle = interface(DNSafeNCryptHandle)
  ['{B32A5522-A799-3E31-B266-D5141CB42D48}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeNCryptSecretHandle = class(TDNGenericImport<DNSafeNCryptSecretHandleClass, DNSafeNCryptSecretHandle>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSACngClass = interface(DNObjectClass)
  ['{EADE0EF5-CECA-54C0-940A-BCABF572157A}']
  { constructors } 

    {class} function init(key: DNCngKey): DNDSACng; overload;
    {class} function init: DNDSACng; overload;
    {class} function init(keySize: Int32): DNDSACng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSACng')]
  DNDSACng = interface(DNObject)
  ['{7147E715-6000-3032-97C7-4FEF1CA6F0CF}']
  { getters & setters } 

    function get_Key: DNCngKey;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_SignatureAlgorithm: string;
    function get_KeyExchangeAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);

  { methods } 

    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNDSAParameters;
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function CreateSignature(rgbHash: TArray<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function GetMaxSignatureSize(signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Int32;
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: DNCngKey read get_Key;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
  end;

  TDNDSACng = class(TDNGenericImport<DNDSACngClass, DNDSACng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanCngClass = interface(DNObjectClass)
  ['{279CF71C-C5BA-59F0-887E-9D06DF09F2F8}']
  { constructors } 

    {class} function init(key: DNCngKey): DNECDiffieHellmanCng; overload;
    {class} function init: DNECDiffieHellmanCng; overload;
    {class} function init(keySize: Int32): DNECDiffieHellmanCng; overload;
    {class} function init(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve): DNECDiffieHellmanCng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanCng')]
  DNECDiffieHellmanCng = interface(DNObject)
  ['{C3128885-8706-3193-8C48-B8A6F24AB7BB}']
  { getters & setters } 

    function get_HashAlgorithm: DNCngAlgorithm;
    procedure set_HashAlgorithm(value: DNCngAlgorithm);
    function get_KeyDerivationFunction: DNECDiffieHellmanKeyDerivationFunction;
    procedure set_KeyDerivationFunction(value: DNECDiffieHellmanKeyDerivationFunction);
    function get_HmacKey: TArray<Byte>;
    procedure set_HmacKey(value: TArray<Byte>);
    function get_Label: TArray<Byte>;
    procedure set_Label(value: TArray<Byte>);
    function get_SecretAppend: TArray<Byte>;
    procedure set_SecretAppend(value: TArray<Byte>);
    function get_SecretPrepend: TArray<Byte>;
    procedure set_SecretPrepend(value: TArray<Byte>);
    function get_Seed: TArray<Byte>;
    procedure set_Seed(value: TArray<Byte>);
    function get_UseSecretAgreementAsHmacKey: Boolean;
    function get_PublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey;
    function get_Key: DNCngKey;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function DeriveKeyMaterial(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey): TArray<Byte>; overload;
    function DeriveKeyMaterial(otherPartyPublicKey: DNCngKey): TArray<Byte>; overload;
    function DeriveSecretAgreementHandle(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey): DNSafeNCryptSecretHandle; overload;
    function DeriveSecretAgreementHandle(otherPartyPublicKey: DNCngKey): DNSafeNCryptSecretHandle; overload;
    procedure GenerateKey(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve);
    procedure FromXmlString(xml: string; format: DNECKeyXmlFormat); overload;
    function ToXmlString(format: DNECKeyXmlFormat): string; overload;
    function DeriveKeyFromHash(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyTls(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; prfLabel: TArray<Byte>; prfSeed: TArray<Byte>): TArray<Byte>;
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters);
    function ExportExplicitParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function DeriveKeyFromHash(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>): TArray<Byte>; overload;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportECPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function ExportECPrivateKey: TArray<Byte>;
    function TryExportECPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string); overload;
    function ToXmlString(includePrivateParameters: Boolean): string; overload;
    procedure Clear;
    procedure Dispose;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashAlgorithm: DNCngAlgorithm read get_HashAlgorithm write set_HashAlgorithm;
    property KeyDerivationFunction: DNECDiffieHellmanKeyDerivationFunction read get_KeyDerivationFunction write set_KeyDerivationFunction;
    property HmacKey: TArray<Byte> read get_HmacKey write set_HmacKey;
    property &Label: TArray<Byte> read get_Label write set_Label;
    property SecretAppend: TArray<Byte> read get_SecretAppend write set_SecretAppend;
    property SecretPrepend: TArray<Byte> read get_SecretPrepend write set_SecretPrepend;
    property Seed: TArray<Byte> read get_Seed write set_Seed;
    property UseSecretAgreementAsHmacKey: Boolean read get_UseSecretAgreementAsHmacKey;
    property PublicKey: DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey read get_PublicKey;
    property Key: DNCngKey read get_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNECDiffieHellmanCng = class(TDNGenericImport<DNECDiffieHellmanCngClass, DNECDiffieHellmanCng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDsaCngClass = interface(DNObjectClass)
  ['{99A56547-E5C9-50BD-9F93-A0E6748DB638}']
  { constructors } 

    {class} function init(key: DNCngKey): DNECDsaCng; overload;
    {class} function init(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve): DNECDsaCng; overload;
    {class} function init: DNECDsaCng; overload;
    {class} function init(keySize: Int32): DNECDsaCng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDsaCng')]
  DNECDsaCng = interface(DNObject)
  ['{5DAA2AE9-C846-3E1B-8883-8E8500C13F28}']
  { getters & setters } 

    function get_HashAlgorithm: DNCngAlgorithm;
    procedure set_HashAlgorithm(value: DNCngAlgorithm);
    function get_Key: DNCngKey;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;

  { methods } 

    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure FromXmlString(xml: string; format: DNECKeyXmlFormat); overload;
    function SignData(data: TArray<Byte>): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ToXmlString(format: DNECKeyXmlFormat): string; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>): Boolean; overload;
    procedure GenerateKey(curve: DDNC.System.Security.Cryptography.Algorithms.DNECCurve);
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters);
    function ExportExplicitParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function SignHash(hash: TArray<Byte>): TArray<Byte>; overload;
    function TrySignHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>): Boolean; overload;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function SignHash(hash: TArray<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Boolean; overload;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportECPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function ExportECPrivateKey: TArray<Byte>;
    function TryExportECPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function GetMaxSignatureSize(signatureFormat: DDNC.System.Security.Cryptography.Algorithms.DNDSASignatureFormat): Int32;
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string); overload;
    function ToXmlString(includePrivateParameters: Boolean): string; overload;
    procedure Clear;
    procedure Dispose;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashAlgorithm: DNCngAlgorithm read get_HashAlgorithm write set_HashAlgorithm;
    property Key: DNCngKey read get_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
  end;

  TDNECDsaCng = class(TDNGenericImport<DNECDsaCngClass, DNECDsaCng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSACngClass = interface(DNObjectClass)
  ['{9427EFE3-3283-5664-9586-7001E3F546FA}']
  { constructors } 

    {class} function init(key: DNCngKey): DNRSACng; overload;
    {class} function init: DNRSACng; overload;
    {class} function init(keySize: Int32): DNRSACng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSACng')]
  DNRSACng = interface(DNObject)
  ['{E5B7A0F0-E020-3BE1-9640-C7BD089B571A}']
  { getters & setters } 

    function get_Key: DNCngKey;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);

  { methods } 

    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function Encrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>;
    function Decrypt(data: TArray<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding): TArray<Byte>;
    function TryEncrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TryDecrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    procedure ImportParameters(parameters: DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters);
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function ExportParameters(includePrivateParameters: Boolean): DDNC.System.Security.Cryptography.Algorithms.DNRSAParameters;
    function SignHash(hash: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function DecryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function EncryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DDNC.System.Security.Cryptography.Algorithms.DNRSASignaturePadding): Boolean; overload;
    function ExportRSAPrivateKey: TArray<Byte>;
    function TryExportRSAPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ExportRSAPublicKey: TArray<Byte>;
    function TryExportRSAPublicKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPublicKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: DNCngKey read get_Key;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
  end;

  TDNRSACng = class(TDNGenericImport<DNRSACngClass, DNRSACng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngAlgorithmClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{FD8DE14F-7A13-5242-8E72-3283F3990594}']
  { static getter & setter } 

    {class} function get_Rsa: DNCngAlgorithm;
    {class} function get_ECDiffieHellman: DNCngAlgorithm;
    {class} function get_ECDiffieHellmanP256: DNCngAlgorithm;
    {class} function get_ECDiffieHellmanP384: DNCngAlgorithm;
    {class} function get_ECDiffieHellmanP521: DNCngAlgorithm;
    {class} function get_ECDsa: DNCngAlgorithm;
    {class} function get_ECDsaP256: DNCngAlgorithm;
    {class} function get_ECDsaP384: DNCngAlgorithm;
    {class} function get_ECDsaP521: DNCngAlgorithm;
    {class} function get_MD5: DNCngAlgorithm;
    {class} function get_Sha1: DNCngAlgorithm;
    {class} function get_Sha256: DNCngAlgorithm;
    {class} function get_Sha384: DNCngAlgorithm;
    {class} function get_Sha512: DNCngAlgorithm;

  { constructors } 

    {class} function init(algorithm: string): DNCngAlgorithm;

  { static propertys } 

    {class} property Rsa: DNCngAlgorithm read get_Rsa;
    {class} property ECDiffieHellman: DNCngAlgorithm read get_ECDiffieHellman;
    {class} property ECDiffieHellmanP256: DNCngAlgorithm read get_ECDiffieHellmanP256;
    {class} property ECDiffieHellmanP384: DNCngAlgorithm read get_ECDiffieHellmanP384;
    {class} property ECDiffieHellmanP521: DNCngAlgorithm read get_ECDiffieHellmanP521;
    {class} property ECDsa: DNCngAlgorithm read get_ECDsa;
    {class} property ECDsaP256: DNCngAlgorithm read get_ECDsaP256;
    {class} property ECDsaP384: DNCngAlgorithm read get_ECDsaP384;
    {class} property ECDsaP521: DNCngAlgorithm read get_ECDsaP521;
    {class} property MD5: DNCngAlgorithm read get_MD5;
    {class} property Sha1: DNCngAlgorithm read get_Sha1;
    {class} property Sha256: DNCngAlgorithm read get_Sha256;
    {class} property Sha384: DNCngAlgorithm read get_Sha384;
    {class} property Sha512: DNCngAlgorithm read get_Sha512;
  end;

  [DNTypeName('System.Security.Cryptography.CngAlgorithm')]
  DNCngAlgorithm = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F3CFC2D2-4D86-3C43-8D01-508D0BCD1315}']
  { getters & setters } 

    function get_Algorithm: string;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngAlgorithm): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Algorithm: string read get_Algorithm;
  end;

  TDNCngAlgorithm = class(TDNGenericImport<DNCngAlgorithmClass, DNCngAlgorithm>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngAlgorithmGroupClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{B55D9BB4-A5BE-56EE-AB7F-49DE6433783F}']
  { static getter & setter } 

    {class} function get_DiffieHellman: DNCngAlgorithmGroup;
    {class} function get_Dsa: DNCngAlgorithmGroup;
    {class} function get_ECDiffieHellman: DNCngAlgorithmGroup;
    {class} function get_ECDsa: DNCngAlgorithmGroup;
    {class} function get_Rsa: DNCngAlgorithmGroup;

  { constructors } 

    {class} function init(algorithmGroup: string): DNCngAlgorithmGroup;

  { static propertys } 

    {class} property DiffieHellman: DNCngAlgorithmGroup read get_DiffieHellman;
    {class} property Dsa: DNCngAlgorithmGroup read get_Dsa;
    {class} property ECDiffieHellman: DNCngAlgorithmGroup read get_ECDiffieHellman;
    {class} property ECDsa: DNCngAlgorithmGroup read get_ECDsa;
    {class} property Rsa: DNCngAlgorithmGroup read get_Rsa;
  end;

  [DNTypeName('System.Security.Cryptography.CngAlgorithmGroup')]
  DNCngAlgorithmGroup = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A5D104EB-27FE-302D-ADC9-AB95E5C6223D}']
  { getters & setters } 

    function get_AlgorithmGroup: string;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngAlgorithmGroup): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AlgorithmGroup: string read get_AlgorithmGroup;
  end;

  TDNCngAlgorithmGroup = class(TDNGenericImport<DNCngAlgorithmGroupClass, DNCngAlgorithmGroup>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngKeyClass = interface(DNObjectClass)
  ['{A2B54E6F-FE85-5A51-9519-FC0EE03083F1}']
  { static methods } 

    {class} function Create(algorithm: DNCngAlgorithm): DNCngKey; overload;
    {class} function Create(algorithm: DNCngAlgorithm; keyName: string): DNCngKey; overload;
    {class} function Create(algorithm: DNCngAlgorithm; keyName: string; creationParameters: DNCngKeyCreationParameters): DNCngKey; overload;
    {class} function Import(keyBlob: TArray<Byte>; format: DNCngKeyBlobFormat): DNCngKey; overload;
    {class} function Import(keyBlob: TArray<Byte>; format: DNCngKeyBlobFormat; provider: DNCngProvider): DNCngKey; overload;
    {class} function Exists(keyName: string): Boolean; overload;
    {class} function Exists(keyName: string; provider: DNCngProvider): Boolean; overload;
    {class} function Exists(keyName: string; provider: DNCngProvider; options: DNCngKeyOpenOptions): Boolean; overload;
    {class} function Open(keyName: string): DNCngKey; overload;
    {class} function Open(keyName: string; provider: DNCngProvider): DNCngKey; overload;
    {class} function Open(keyName: string; provider: DNCngProvider; openOptions: DNCngKeyOpenOptions): DNCngKey; overload;
    {class} function Open(keyHandle: DNSafeNCryptKeyHandle; keyHandleOpenOptions: DNCngKeyHandleOpenOptions): DNCngKey; overload;

  end;

  [DNTypeName('System.Security.Cryptography.CngKey')]
  DNCngKey = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{73850853-0B6D-3A01-8EFA-57A5C726F7DC}']
  { getters & setters } 

    function get_Algorithm: DNCngAlgorithm;
    function get_AlgorithmGroup: DNCngAlgorithmGroup;
    function get_ExportPolicy: DNCngExportPolicies;
    function get_Handle: DNSafeNCryptKeyHandle;
    function get_IsEphemeral: Boolean;
    function get_IsMachineKey: Boolean;
    function get_KeyName: string;
    function get_KeySize: Int32;
    function get_KeyUsage: DNCngKeyUsages;
    function get_ParentWindowHandle: IntPtr;
    procedure set_ParentWindowHandle(value: IntPtr);
    function get_Provider: DNCngProvider;
    function get_ProviderHandle: DNSafeNCryptProviderHandle;
    function get_UIPolicy: DNCngUIPolicy;
    function get_UniqueName: string;

  { methods } 

    procedure Dispose;
    function GetProperty(name: string; options: DNCngPropertyOptions): DNCngProperty;
    function HasProperty(name: string; options: DNCngPropertyOptions): Boolean;
    procedure SetProperty(&property: DNCngProperty);
    function &Export(format: DNCngKeyBlobFormat): TArray<Byte>;
    procedure Delete;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Algorithm: DNCngAlgorithm read get_Algorithm;
    property AlgorithmGroup: DNCngAlgorithmGroup read get_AlgorithmGroup;
    property ExportPolicy: DNCngExportPolicies read get_ExportPolicy;
    property Handle: DNSafeNCryptKeyHandle read get_Handle;
    property IsEphemeral: Boolean read get_IsEphemeral;
    property IsMachineKey: Boolean read get_IsMachineKey;
    property KeyName: string read get_KeyName;
    property KeySize: Int32 read get_KeySize;
    property KeyUsage: DNCngKeyUsages read get_KeyUsage;
    property ParentWindowHandle: IntPtr read get_ParentWindowHandle write set_ParentWindowHandle;
    property Provider: DNCngProvider read get_Provider;
    property ProviderHandle: DNSafeNCryptProviderHandle read get_ProviderHandle;
    property UIPolicy: DNCngUIPolicy read get_UIPolicy;
    property UniqueName: string read get_UniqueName;
  end;

  TDNCngKey = class(TDNGenericImport<DNCngKeyClass, DNCngKey>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngKeyBlobFormatClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{593A13DC-131F-56A0-96A3-448C221A5BC8}']
  { static getter & setter } 

    {class} function get_EccPrivateBlob: DNCngKeyBlobFormat;
    {class} function get_EccPublicBlob: DNCngKeyBlobFormat;
    {class} function get_EccFullPrivateBlob: DNCngKeyBlobFormat;
    {class} function get_EccFullPublicBlob: DNCngKeyBlobFormat;
    {class} function get_GenericPrivateBlob: DNCngKeyBlobFormat;
    {class} function get_GenericPublicBlob: DNCngKeyBlobFormat;
    {class} function get_OpaqueTransportBlob: DNCngKeyBlobFormat;
    {class} function get_Pkcs8PrivateBlob: DNCngKeyBlobFormat;

  { constructors } 

    {class} function init(format: string): DNCngKeyBlobFormat;

  { static propertys } 

    {class} property EccPrivateBlob: DNCngKeyBlobFormat read get_EccPrivateBlob;
    {class} property EccPublicBlob: DNCngKeyBlobFormat read get_EccPublicBlob;
    {class} property EccFullPrivateBlob: DNCngKeyBlobFormat read get_EccFullPrivateBlob;
    {class} property EccFullPublicBlob: DNCngKeyBlobFormat read get_EccFullPublicBlob;
    {class} property GenericPrivateBlob: DNCngKeyBlobFormat read get_GenericPrivateBlob;
    {class} property GenericPublicBlob: DNCngKeyBlobFormat read get_GenericPublicBlob;
    {class} property OpaqueTransportBlob: DNCngKeyBlobFormat read get_OpaqueTransportBlob;
    {class} property Pkcs8PrivateBlob: DNCngKeyBlobFormat read get_Pkcs8PrivateBlob;
  end;

  [DNTypeName('System.Security.Cryptography.CngKeyBlobFormat')]
  DNCngKeyBlobFormat = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E9BC5742-45A3-3546-AB8C-5A7F61DF1F14}']
  { getters & setters } 

    function get_Format: string;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngKeyBlobFormat): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Format: string read get_Format;
  end;

  TDNCngKeyBlobFormat = class(TDNGenericImport<DNCngKeyBlobFormatClass, DNCngKeyBlobFormat>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngKeyCreationParametersClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0A13BBA1-5440-5D85-9D48-D6B661C1A38E}']
  { constructors } 

    {class} function init: DNCngKeyCreationParameters;

  end;

  [DNTypeName('System.Security.Cryptography.CngKeyCreationParameters')]
  DNCngKeyCreationParameters = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7926E96D-46F8-33A9-A370-4856A2C1AD28}']
  { getters & setters } 

    function get_ExportPolicy: DDNC.System.Private.CoreLib.DNNullable<DNCngExportPolicies>;
    procedure set_ExportPolicy(value: DDNC.System.Private.CoreLib.DNNullable<DNCngExportPolicies>);
    function get_KeyCreationOptions: DNCngKeyCreationOptions;
    procedure set_KeyCreationOptions(value: DNCngKeyCreationOptions);
    function get_KeyUsage: DDNC.System.Private.CoreLib.DNNullable<DNCngKeyUsages>;
    procedure set_KeyUsage(value: DDNC.System.Private.CoreLib.DNNullable<DNCngKeyUsages>);
    function get_Parameters: DNCngPropertyCollection;
    function get_ParentWindowHandle: IntPtr;
    procedure set_ParentWindowHandle(value: IntPtr);
    function get_Provider: DNCngProvider;
    procedure set_Provider(value: DNCngProvider);
    function get_UIPolicy: DNCngUIPolicy;
    procedure set_UIPolicy(value: DNCngUIPolicy);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ExportPolicy: DDNC.System.Private.CoreLib.DNNullable<DNCngExportPolicies> read get_ExportPolicy write set_ExportPolicy;
    property KeyCreationOptions: DNCngKeyCreationOptions read get_KeyCreationOptions write set_KeyCreationOptions;
    property KeyUsage: DDNC.System.Private.CoreLib.DNNullable<DNCngKeyUsages> read get_KeyUsage write set_KeyUsage;
    property Parameters: DNCngPropertyCollection read get_Parameters;
    property ParentWindowHandle: IntPtr read get_ParentWindowHandle write set_ParentWindowHandle;
    property Provider: DNCngProvider read get_Provider write set_Provider;
    property UIPolicy: DNCngUIPolicy read get_UIPolicy write set_UIPolicy;
  end;

  TDNCngKeyCreationParameters = class(TDNGenericImport<DNCngKeyCreationParametersClass, DNCngKeyCreationParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngProviderClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{879AA2B6-15DD-51FB-809D-B7B675326837}']
  { static getter & setter } 

    {class} function get_MicrosoftSmartCardKeyStorageProvider: DNCngProvider;
    {class} function get_MicrosoftSoftwareKeyStorageProvider: DNCngProvider;

  { constructors } 

    {class} function init(provider: string): DNCngProvider;

  { static propertys } 

    {class} property MicrosoftSmartCardKeyStorageProvider: DNCngProvider read get_MicrosoftSmartCardKeyStorageProvider;
    {class} property MicrosoftSoftwareKeyStorageProvider: DNCngProvider read get_MicrosoftSoftwareKeyStorageProvider;
  end;

  [DNTypeName('System.Security.Cryptography.CngProvider')]
  DNCngProvider = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{272E6B29-A750-3C50-8399-8F62B2684E34}']
  { getters & setters } 

    function get_Provider: string;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngProvider): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Provider: string read get_Provider;
  end;

  TDNCngProvider = class(TDNGenericImport<DNCngProviderClass, DNCngProvider>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngUIPolicyClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{398B724A-7200-5961-88AB-44ED62B07B2B}']
  { constructors } 

    {class} function init(protectionLevel: DNCngUIProtectionLevels): DNCngUIPolicy; overload;
    {class} function init(protectionLevel: DNCngUIProtectionLevels; friendlyName: string): DNCngUIPolicy; overload;
    {class} function init(protectionLevel: DNCngUIProtectionLevels; friendlyName: string; description: string): DNCngUIPolicy; overload;
    {class} function init(protectionLevel: DNCngUIProtectionLevels; friendlyName: string; description: string; useContext: string): DNCngUIPolicy; overload;
    {class} function init(protectionLevel: DNCngUIProtectionLevels; friendlyName: string; description: string; useContext: string; creationTitle: string): DNCngUIPolicy; overload;

  end;

  [DNTypeName('System.Security.Cryptography.CngUIPolicy')]
  DNCngUIPolicy = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{919CE38D-A945-3A7E-A9F6-D6BC4BA68A2B}']
  { getters & setters } 

    function get_ProtectionLevel: DNCngUIProtectionLevels;
    function get_FriendlyName: string;
    function get_Description: string;
    function get_UseContext: string;
    function get_CreationTitle: string;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ProtectionLevel: DNCngUIProtectionLevels read get_ProtectionLevel;
    property FriendlyName: string read get_FriendlyName;
    property Description: string read get_Description;
    property UseContext: string read get_UseContext;
    property CreationTitle: string read get_CreationTitle;
  end;

  TDNCngUIPolicy = class(TDNGenericImport<DNCngUIPolicyClass, DNCngUIPolicy>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanCngPublicKeyClass = interface(DNObjectClass)
  ['{F868C9AF-2D9E-5417-AB60-0719093CD83C}']
  { static methods } 

    {class} function FromXmlString(xml: string): DNECDiffieHellmanCngPublicKey;
    {class} function FromByteArray(publicKeyBlob: TArray<Byte>; format: DNCngKeyBlobFormat): DDNC.System.Security.Cryptography.Algorithms.DNECDiffieHellmanPublicKey;

  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanCngPublicKey')]
  DNECDiffieHellmanCngPublicKey = interface(DNObject)
  ['{0C7F0FD6-8229-3909-86F0-1685F67B8686}']
  { getters & setters } 

    function get_BlobFormat: DNCngKeyBlobFormat;

  { methods } 

    function ToXmlString: string;
    function Import: DNCngKey;
    function ExportExplicitParameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    function ExportParameters: DDNC.System.Security.Cryptography.Algorithms.DNECParameters;
    procedure Dispose;
    function ToByteArray: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property BlobFormat: DNCngKeyBlobFormat read get_BlobFormat;
  end;

  TDNECDiffieHellmanCngPublicKey = class(TDNGenericImport<DNECDiffieHellmanCngPublicKeyClass, DNECDiffieHellmanCngPublicKey>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesCngClass = interface(DNObjectClass)
  ['{9A1DB7C8-19EF-5B0A-BE5F-81EAEC0BDDE1}']
  { constructors } 

    {class} function init: DNAesCng; overload;
    {class} function init(keyName: string): DNAesCng; overload;
    {class} function init(keyName: string; provider: DNCngProvider): DNAesCng; overload;
    {class} function init(keyName: string; provider: DNCngProvider; openOptions: DNCngKeyOpenOptions): DNAesCng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.AesCng')]
  DNAesCng = interface(DNObject)
  ['{FA369E89-C0CF-3BD8-ACAD-638B3FEAEDED}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateKey;
    procedure GenerateIV;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNAesCng = class(TDNGenericImport<DNAesCngClass, DNAesCng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNTripleDESCngClass = interface(DNObjectClass)
  ['{A492B1DD-4C97-54F8-A55B-1A0C5BFBBA8E}']
  { constructors } 

    {class} function init: DNTripleDESCng; overload;
    {class} function init(keyName: string): DNTripleDESCng; overload;
    {class} function init(keyName: string; provider: DNCngProvider): DNTripleDESCng; overload;
    {class} function init(keyName: string; provider: DNCngProvider; openOptions: DNCngKeyOpenOptions): DNTripleDESCng; overload;

  end;

  [DNTypeName('System.Security.Cryptography.TripleDESCng')]
  DNTripleDESCng = interface(DNObject)
  ['{EFFB99C0-5589-3014-9DE2-E3F6EA7C72DD}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateKey;
    procedure GenerateIV;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNTripleDESCng = class(TDNGenericImport<DNTripleDESCngClass, DNTripleDESCng>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCngPropertyClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{5EA6952B-1F97-5499-B58C-8A1F000CCDF5}']
  { constructors } 

    {class} function init(name: string; value: TArray<Byte>; options: DNCngPropertyOptions): DNCngProperty;

  end;

  [DNTypeName('System.Security.Cryptography.CngProperty')]
  DNCngProperty = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{42E8067D-51A9-3E40-8C1C-F0233A0EC0BC}']
  { getters & setters } 

    function get_Name: string;
    function get_Options: DNCngPropertyOptions;

  { methods } 

    function GetValue: TArray<Byte>;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNCngProperty): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Options: DNCngPropertyOptions read get_Options;
  end;

  TDNCngProperty = class(TDNGenericImport<DNCngPropertyClass, DNCngProperty>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.Cng, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
