//----------------------------------------------------------------------------
//  System.Security.Cryptography.Algorithms.dll: System.Security.Cryptography.Algorithms, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.Cryptography.Algorithms
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.Cryptography.Algorithms;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Security.Cryptography.Primitives,
  DDNC.System.Security.Cryptography.Encoding;

type

{ enums }

  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.DSASignatureFormat')]
  DNDSASignatureFormat = type Integer;
  DNDSASignatureFormatHelper = record helper for DNDSASignatureFormat
  public const
    IeeeP1363FixedFieldConcatenation = 0;
    Rfc3279DerSequence = 1;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.ECCurve+ECCurveType')]
  DNECCurve_ECCurveType = type Integer;
  DNECCurve_ECCurveTypeHelper = record helper for DNECCurve_ECCurveType
  public const
    Implicit = 0;
    PrimeShortWeierstrass = 1;
    PrimeTwistedEdwards = 2;
    PrimeMontgomery = 3;
    Characteristic2 = 4;
    Named = 5;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.RSAEncryptionPaddingMode')]
  DNRSAEncryptionPaddingMode = type Integer;
  DNRSAEncryptionPaddingModeHelper = record helper for DNRSAEncryptionPaddingMode
  public const
    Pkcs1 = 0;
    Oaep = 1;
  end;


  //-------------namespace: System.Security.Cryptography----------------
  [DNTypeName('System.Security.Cryptography.RSASignaturePaddingMode')]
  DNRSASignaturePaddingMode = type Integer;
  DNRSASignaturePaddingModeHelper = record helper for DNRSASignaturePaddingMode
  public const
    Pkcs1 = 0;
    Pss = 1;
  end;




type


{ declares }

  DNAesCcm = interface; // type: System.Security.Cryptography.AesCcm, namespace: System.Security.Cryptography
  DNAesGcm = interface; // type: System.Security.Cryptography.AesGcm, namespace: System.Security.Cryptography
  DNDSA = interface; // type: System.Security.Cryptography.DSA, namespace: System.Security.Cryptography
  DNECDiffieHellman = interface; // type: System.Security.Cryptography.ECDiffieHellman, namespace: System.Security.Cryptography
  DNECDsa = interface; // type: System.Security.Cryptography.ECDsa, namespace: System.Security.Cryptography
  DNRSA = interface; // type: System.Security.Cryptography.RSA, namespace: System.Security.Cryptography
  DNAsymmetricKeyExchangeDeformatter = interface; // type: System.Security.Cryptography.AsymmetricKeyExchangeDeformatter, namespace: System.Security.Cryptography
  DNRSAOAEPKeyExchangeDeformatter = interface; // type: System.Security.Cryptography.RSAOAEPKeyExchangeDeformatter, namespace: System.Security.Cryptography
  DNRSAPKCS1KeyExchangeDeformatter = interface; // type: System.Security.Cryptography.RSAPKCS1KeyExchangeDeformatter, namespace: System.Security.Cryptography
  DNAsymmetricKeyExchangeFormatter = interface; // type: System.Security.Cryptography.AsymmetricKeyExchangeFormatter, namespace: System.Security.Cryptography
  DNRSAOAEPKeyExchangeFormatter = interface; // type: System.Security.Cryptography.RSAOAEPKeyExchangeFormatter, namespace: System.Security.Cryptography
  DNRSAPKCS1KeyExchangeFormatter = interface; // type: System.Security.Cryptography.RSAPKCS1KeyExchangeFormatter, namespace: System.Security.Cryptography
  DNAsymmetricSignatureDeformatter = interface; // type: System.Security.Cryptography.AsymmetricSignatureDeformatter, namespace: System.Security.Cryptography
  DNDSASignatureDeformatter = interface; // type: System.Security.Cryptography.DSASignatureDeformatter, namespace: System.Security.Cryptography
  DNRSAPKCS1SignatureDeformatter = interface; // type: System.Security.Cryptography.RSAPKCS1SignatureDeformatter, namespace: System.Security.Cryptography
  DNAsymmetricSignatureFormatter = interface; // type: System.Security.Cryptography.AsymmetricSignatureFormatter, namespace: System.Security.Cryptography
  DNDSASignatureFormatter = interface; // type: System.Security.Cryptography.DSASignatureFormatter, namespace: System.Security.Cryptography
  DNRSAPKCS1SignatureFormatter = interface; // type: System.Security.Cryptography.RSAPKCS1SignatureFormatter, namespace: System.Security.Cryptography
  DNCryptoConfig = interface; // type: System.Security.Cryptography.CryptoConfig, namespace: System.Security.Cryptography
  DNDeriveBytes = interface; // type: System.Security.Cryptography.DeriveBytes, namespace: System.Security.Cryptography
  DNRfc2898DeriveBytes = interface; // type: System.Security.Cryptography.Rfc2898DeriveBytes, namespace: System.Security.Cryptography
  DNECCurve_NamedCurves = interface; // type: System.Security.Cryptography.ECCurve+NamedCurves, namespace: System.Security.Cryptography
  DNECDiffieHellmanPublicKey = interface; // type: System.Security.Cryptography.ECDiffieHellmanPublicKey, namespace: System.Security.Cryptography
  DNHMACMD5 = interface; // type: System.Security.Cryptography.HMACMD5, namespace: System.Security.Cryptography
  DNHMACSHA1 = interface; // type: System.Security.Cryptography.HMACSHA1, namespace: System.Security.Cryptography
  DNHMACSHA256 = interface; // type: System.Security.Cryptography.HMACSHA256, namespace: System.Security.Cryptography
  DNHMACSHA384 = interface; // type: System.Security.Cryptography.HMACSHA384, namespace: System.Security.Cryptography
  DNHMACSHA512 = interface; // type: System.Security.Cryptography.HMACSHA512, namespace: System.Security.Cryptography
  DNMD5 = interface; // type: System.Security.Cryptography.MD5, namespace: System.Security.Cryptography
  DNSHA1 = interface; // type: System.Security.Cryptography.SHA1, namespace: System.Security.Cryptography
  DNSHA1Managed = interface; // type: System.Security.Cryptography.SHA1Managed, namespace: System.Security.Cryptography
  DNSHA256 = interface; // type: System.Security.Cryptography.SHA256, namespace: System.Security.Cryptography
  DNSHA256Managed = interface; // type: System.Security.Cryptography.SHA256Managed, namespace: System.Security.Cryptography
  DNSHA384 = interface; // type: System.Security.Cryptography.SHA384, namespace: System.Security.Cryptography
  DNSHA384Managed = interface; // type: System.Security.Cryptography.SHA384Managed, namespace: System.Security.Cryptography
  DNSHA512 = interface; // type: System.Security.Cryptography.SHA512, namespace: System.Security.Cryptography
  DNSHA512Managed = interface; // type: System.Security.Cryptography.SHA512Managed, namespace: System.Security.Cryptography
  DNHKDF = interface; // type: System.Security.Cryptography.HKDF, namespace: System.Security.Cryptography
  DNIncrementalHash = interface; // type: System.Security.Cryptography.IncrementalHash, namespace: System.Security.Cryptography
  DNMaskGenerationMethod = interface; // type: System.Security.Cryptography.MaskGenerationMethod, namespace: System.Security.Cryptography
  DNPKCS1MaskGenerationMethod = interface; // type: System.Security.Cryptography.PKCS1MaskGenerationMethod, namespace: System.Security.Cryptography
  DNRandomNumberGenerator = interface; // type: System.Security.Cryptography.RandomNumberGenerator, namespace: System.Security.Cryptography
  DNRSAEncryptionPadding = interface; // type: System.Security.Cryptography.RSAEncryptionPadding, namespace: System.Security.Cryptography
  DNRSASignaturePadding = interface; // type: System.Security.Cryptography.RSASignaturePadding, namespace: System.Security.Cryptography
  DNSignatureDescription = interface; // type: System.Security.Cryptography.SignatureDescription, namespace: System.Security.Cryptography
  DNAes = interface; // type: System.Security.Cryptography.Aes, namespace: System.Security.Cryptography
  DNAesManaged = interface; // type: System.Security.Cryptography.AesManaged, namespace: System.Security.Cryptography
  DNDES = interface; // type: System.Security.Cryptography.DES, namespace: System.Security.Cryptography
  DNRC2 = interface; // type: System.Security.Cryptography.RC2, namespace: System.Security.Cryptography
  DNRijndael = interface; // type: System.Security.Cryptography.Rijndael, namespace: System.Security.Cryptography
  DNRijndaelManaged = interface; // type: System.Security.Cryptography.RijndaelManaged, namespace: System.Security.Cryptography
  DNTripleDES = interface; // type: System.Security.Cryptography.TripleDES, namespace: System.Security.Cryptography
  DNDSAParameters = interface; // type: System.Security.Cryptography.DSAParameters, namespace: System.Security.Cryptography
  DNECCurve = interface; // type: System.Security.Cryptography.ECCurve, namespace: System.Security.Cryptography
  DNECParameters = interface; // type: System.Security.Cryptography.ECParameters, namespace: System.Security.Cryptography
  DNECPoint = interface; // type: System.Security.Cryptography.ECPoint, namespace: System.Security.Cryptography
  DNRSAParameters = interface; // type: System.Security.Cryptography.RSAParameters, namespace: System.Security.Cryptography


{ objects }

  //-------------namespace: System.Security.Cryptography----------------
  DNAesCcmClass = interface(DNObjectClass)
  ['{690634D4-4000-5108-AA8B-21F71AC7D013}']
  { static getter & setter } 

    {class} function get_NonceByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes;
    {class} function get_TagByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes;

  { constructors } 

    {class} function init(key: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNAesCcm; overload;
    {class} function init(key: TArray<Byte>): DNAesCcm; overload;

  { static propertys } 

    {class} property NonceByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes read get_NonceByteSizes;
    {class} property TagByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes read get_TagByteSizes;
  end;

  [DNTypeName('System.Security.Cryptography.AesCcm')]
  DNAesCcm = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{9A9C0887-BE40-3A4D-BDE4-9CC6337062D6}']
  { methods } 

    procedure Encrypt(nonce: TArray<Byte>; plaintext: TArray<Byte>; ciphertext: TArray<Byte>; tag: TArray<Byte>; associatedData: TArray<Byte>); overload;
    procedure Encrypt(nonce: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; plaintext: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; ciphertext: DDNC.System.Private.CoreLib.DNSpan<Byte>; tag: DDNC.System.Private.CoreLib.DNSpan<Byte>; associatedData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure Decrypt(nonce: TArray<Byte>; ciphertext: TArray<Byte>; tag: TArray<Byte>; plaintext: TArray<Byte>; associatedData: TArray<Byte>); overload;
    procedure Decrypt(nonce: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; ciphertext: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; tag: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; plaintext: DDNC.System.Private.CoreLib.DNSpan<Byte>; associatedData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNAesCcm = class(TDNGenericImport<DNAesCcmClass, DNAesCcm>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesGcmClass = interface(DNObjectClass)
  ['{E5E963E5-D440-5F6A-AA2A-37EA8031C687}']
  { static getter & setter } 

    {class} function get_NonceByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes;
    {class} function get_TagByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes;

  { constructors } 

    {class} function init(key: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNAesGcm; overload;
    {class} function init(key: TArray<Byte>): DNAesGcm; overload;

  { static propertys } 

    {class} property NonceByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes read get_NonceByteSizes;
    {class} property TagByteSizes: DDNC.System.Security.Cryptography.Primitives.DNKeySizes read get_TagByteSizes;
  end;

  [DNTypeName('System.Security.Cryptography.AesGcm')]
  DNAesGcm = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{5005B404-F3E8-3F05-BC3F-63A657983B88}']
  { methods } 

    procedure Encrypt(nonce: TArray<Byte>; plaintext: TArray<Byte>; ciphertext: TArray<Byte>; tag: TArray<Byte>; associatedData: TArray<Byte>); overload;
    procedure Encrypt(nonce: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; plaintext: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; ciphertext: DDNC.System.Private.CoreLib.DNSpan<Byte>; tag: DDNC.System.Private.CoreLib.DNSpan<Byte>; associatedData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure Decrypt(nonce: TArray<Byte>; ciphertext: TArray<Byte>; tag: TArray<Byte>; plaintext: TArray<Byte>; associatedData: TArray<Byte>); overload;
    procedure Decrypt(nonce: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; ciphertext: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; tag: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; plaintext: DDNC.System.Private.CoreLib.DNSpan<Byte>; associatedData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNAesGcm = class(TDNGenericImport<DNAesGcmClass, DNAesGcm>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSAClass = interface(DNObjectClass)
  ['{8B259641-C8AF-5FA8-BC66-2F987204923F}']
  { static methods } 

    {class} function Create(algName: string): DNDSA; overload;
    {class} function Create(keySizeInBits: Int32): DNDSA; overload;
    {class} function Create(parameters: DNDSAParameters): DNDSA; overload;
    {class} function Create: DNDSA; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSA')]
  DNDSA = interface(DNObject)
  ['{9773A838-4EF8-3D1E-B67E-24D6B1D8C809}']
  { getters & setters } 

    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_SignatureAlgorithm: string;
    function get_KeyExchangeAlgorithm: string;

  { methods } 

    function ExportParameters(includePrivateParameters: Boolean): DNDSAParameters;
    procedure ImportParameters(parameters: DNDSAParameters);
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function CreateSignature(rgbHash: TArray<Byte>; signatureFormat: DNDSASignatureFormat): TArray<Byte>; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryCreateSignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; signatureFormat: DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function GetMaxSignatureSize(signatureFormat: DNDSASignatureFormat): Int32;
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
  end;

  TDNDSA = class(TDNGenericImport<DNDSAClass, DNDSA>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanClass = interface(DNObjectClass)
  ['{A3D630D1-79AD-5F28-8B42-3667671BEE84}']
  { static methods } 

    {class} function Create(algorithm: string): DNECDiffieHellman; overload;
    {class} function Create: DNECDiffieHellman; overload;
    {class} function Create(curve: DNECCurve): DNECDiffieHellman; overload;
    {class} function Create(parameters: DNECParameters): DNECDiffieHellman; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellman')]
  DNECDiffieHellman = interface(DNObject)
  ['{9A9E2F62-2E0C-3B1D-ABB8-86B787AECE00}']
  { getters & setters } 

    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_PublicKey: DNECDiffieHellmanPublicKey;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function DeriveKeyMaterial(otherPartyPublicKey: DNECDiffieHellmanPublicKey): TArray<Byte>;
    function DeriveKeyFromHash(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function DeriveKeyFromHash(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyFromHmac(otherPartyPublicKey: DNECDiffieHellmanPublicKey; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; hmacKey: TArray<Byte>; secretPrepend: TArray<Byte>; secretAppend: TArray<Byte>): TArray<Byte>; overload;
    function DeriveKeyTls(otherPartyPublicKey: DNECDiffieHellmanPublicKey; prfLabel: TArray<Byte>; prfSeed: TArray<Byte>): TArray<Byte>;
    function ExportParameters(includePrivateParameters: Boolean): DNECParameters;
    function ExportExplicitParameters(includePrivateParameters: Boolean): DNECParameters;
    procedure ImportParameters(parameters: DNECParameters);
    procedure GenerateKey(curve: DNECCurve);
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportECPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function ExportECPrivateKey: TArray<Byte>;
    function TryExportECPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property PublicKey: DNECDiffieHellmanPublicKey read get_PublicKey;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNECDiffieHellman = class(TDNGenericImport<DNECDiffieHellmanClass, DNECDiffieHellman>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDsaClass = interface(DNObjectClass)
  ['{69EEF51A-E101-52BE-8D79-E1C82EC0A06D}']
  { static methods } 

    {class} function Create(algorithm: string): DNECDsa; overload;
    {class} function Create: DNECDsa; overload;
    {class} function Create(curve: DNECCurve): DNECDsa; overload;
    {class} function Create(parameters: DNECParameters): DNECDsa; overload;

  end;

  [DNTypeName('System.Security.Cryptography.ECDsa')]
  DNECDsa = interface(DNObject)
  ['{18213275-78EB-390C-AC87-67CE328CDE9A}']
  { getters & setters } 

    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function ExportParameters(includePrivateParameters: Boolean): DNECParameters;
    function ExportExplicitParameters(includePrivateParameters: Boolean): DNECParameters;
    procedure ImportParameters(parameters: DNECParameters);
    procedure GenerateKey(curve: DNECCurve);
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): TArray<Byte>; overload;
    function SignHash(hash: TArray<Byte>; signatureFormat: DNDSASignatureFormat): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; out bytesWritten: Int32): Boolean; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): TArray<Byte>; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function SignHash(hash: TArray<Byte>): TArray<Byte>; overload;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>): Boolean; overload;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; signatureFormat: DNDSASignatureFormat; out bytesWritten: Int32): Boolean; overload;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Boolean; overload;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signatureFormat: DNDSASignatureFormat): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportECPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    function ExportECPrivateKey: TArray<Byte>;
    function TryExportECPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function GetMaxSignatureSize(signatureFormat: DNDSASignatureFormat): Int32;
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNECDsa = class(TDNGenericImport<DNECDsaClass, DNECDsa>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAClass = interface(DNObjectClass)
  ['{2C360B67-7933-59A4-B6E1-BE5D79BB23CF}']
  { static methods } 

    {class} function Create(algName: string): DNRSA; overload;
    {class} function Create(keySizeInBits: Int32): DNRSA; overload;
    {class} function Create(parameters: DNRSAParameters): DNRSA; overload;
    {class} function Create: DNRSA; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSA')]
  DNRSA = interface(DNObject)
  ['{D76C8F63-48B3-3681-8540-1E53E90674F7}']
  { getters & setters } 

    function get_KeyExchangeAlgorithm: string;
    function get_SignatureAlgorithm: string;
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function ExportParameters(includePrivateParameters: Boolean): DNRSAParameters;
    procedure ImportParameters(parameters: DNRSAParameters);
    function Encrypt(data: TArray<Byte>; padding: DNRSAEncryptionPadding): TArray<Byte>;
    function Decrypt(data: TArray<Byte>; padding: DNRSAEncryptionPadding): TArray<Byte>;
    function SignHash(hash: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>;
    function VerifyHash(hash: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function TryDecrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TryEncrypt(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; padding: DNRSAEncryptionPadding; out bytesWritten: Int32): Boolean;
    function TrySignHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyHash(hash: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function DecryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function EncryptValue(rgb: TArray<Byte>): TArray<Byte>;
    function SignData(data: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: TArray<Byte>; offset: Int32; count: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>; overload;
    function SignData(data: DDNC.System.Private.CoreLib.DNStream; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): TArray<Byte>; overload;
    function TrySignData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding; out bytesWritten: Int32): Boolean;
    function VerifyData(data: TArray<Byte>; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: TArray<Byte>; offset: Int32; count: Int32; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNStream; signature: TArray<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function VerifyData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; signature: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; padding: DNRSASignaturePadding): Boolean; overload;
    function ExportRSAPrivateKey: TArray<Byte>;
    function TryExportRSAPrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ExportRSAPublicKey: TArray<Byte>;
    function TryExportRSAPublicKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportSubjectPublicKeyInfo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportPkcs8PrivateKey(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function TryExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    function TryExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean; overload;
    procedure ImportSubjectPublicKeyInfo(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPublicKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportRSAPrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportPkcs8PrivateKey(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32);
    procedure ImportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; out bytesRead: Int32); overload;
    procedure ImportFromPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>);
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>); overload;
    procedure ImportFromEncryptedPem(input: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure FromXmlString(xmlString: string);
    function ToXmlString(includePrivateParameters: Boolean): string;
    procedure Clear;
    procedure Dispose;
    function ExportEncryptedPkcs8PrivateKey(passwordBytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportEncryptedPkcs8PrivateKey(password: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; pbeParameters: DDNC.System.Security.Cryptography.Primitives.DNPbeParameters): TArray<Byte>; overload;
    function ExportPkcs8PrivateKey: TArray<Byte>;
    function ExportSubjectPublicKeyInfo: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeyExchangeAlgorithm: string read get_KeyExchangeAlgorithm;
    property SignatureAlgorithm: string read get_SignatureAlgorithm;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNRSA = class(TDNGenericImport<DNRSAClass, DNRSA>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricKeyExchangeDeformatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0D7E41DC-871A-55F7-94A9-0FE638D4A8EC}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricKeyExchangeDeformatter')]
  DNAsymmetricKeyExchangeDeformatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{456474E4-D452-3C73-A622-FC611D674048}']
  { getters & setters } 

    function get_Parameters: string;
    procedure set_Parameters(value: string);

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function DecryptKeyExchange(rgb: TArray<Byte>): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameters: string read get_Parameters write set_Parameters;
  end;

  TDNAsymmetricKeyExchangeDeformatter = class(TDNGenericImport<DNAsymmetricKeyExchangeDeformatterClass, DNAsymmetricKeyExchangeDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAOAEPKeyExchangeDeformatterClass = interface(DNAsymmetricKeyExchangeDeformatterClass)
  ['{BCCA3F75-0C2E-582A-B437-767169A5A104}']
  { constructors } 

    {class} function init: DNRSAOAEPKeyExchangeDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAOAEPKeyExchangeDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAOAEPKeyExchangeDeformatter')]
  DNRSAOAEPKeyExchangeDeformatter = interface(DNAsymmetricKeyExchangeDeformatter)
  ['{75FD6CEA-059D-31E8-9C30-AC273E4A60FC}']
  { getters & setters } 

    function get_Parameters: string;
    procedure set_Parameters(value: string);

  { methods } 

    function DecryptKeyExchange(rgbData: TArray<Byte>): TArray<Byte>;
    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameters: string read get_Parameters write set_Parameters;
  end;

  TDNRSAOAEPKeyExchangeDeformatter = class(TDNGenericImport<DNRSAOAEPKeyExchangeDeformatterClass, DNRSAOAEPKeyExchangeDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1KeyExchangeDeformatterClass = interface(DNAsymmetricKeyExchangeDeformatterClass)
  ['{7F047774-35E8-5E43-89E1-8ED1A4433BCD}']
  { constructors } 

    {class} function init: DNRSAPKCS1KeyExchangeDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1KeyExchangeDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1KeyExchangeDeformatter')]
  DNRSAPKCS1KeyExchangeDeformatter = interface(DNAsymmetricKeyExchangeDeformatter)
  ['{D99D546D-4291-3C60-BD21-3A2E7A177477}']
  { getters & setters } 

    function get_RNG: DNRandomNumberGenerator;
    procedure set_RNG(value: DNRandomNumberGenerator);
    function get_Parameters: string;
    procedure set_Parameters(value: string);

  { methods } 

    function DecryptKeyExchange(rgbIn: TArray<Byte>): TArray<Byte>;
    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property RNG: DNRandomNumberGenerator read get_RNG write set_RNG;
    property Parameters: string read get_Parameters write set_Parameters;
  end;

  TDNRSAPKCS1KeyExchangeDeformatter = class(TDNGenericImport<DNRSAPKCS1KeyExchangeDeformatterClass, DNRSAPKCS1KeyExchangeDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricKeyExchangeFormatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{3686819D-9920-5498-80AA-812A8252780D}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricKeyExchangeFormatter')]
  DNAsymmetricKeyExchangeFormatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{D2D5B5DE-241D-3FF2-A7D7-9FE89C7AC99B}']
  { getters & setters } 

    function get_Parameters: string;

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function CreateKeyExchange(data: TArray<Byte>): TArray<Byte>; overload;
    function CreateKeyExchange(data: TArray<Byte>; symAlgType: DDNC.System.Private.CoreLib.DNType): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameters: string read get_Parameters;
  end;

  TDNAsymmetricKeyExchangeFormatter = class(TDNGenericImport<DNAsymmetricKeyExchangeFormatterClass, DNAsymmetricKeyExchangeFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAOAEPKeyExchangeFormatterClass = interface(DNAsymmetricKeyExchangeFormatterClass)
  ['{848DBEC2-BE9B-57AC-A36A-FD4126071677}']
  { constructors } 

    {class} function init: DNRSAOAEPKeyExchangeFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAOAEPKeyExchangeFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAOAEPKeyExchangeFormatter')]
  DNRSAOAEPKeyExchangeFormatter = interface(DNAsymmetricKeyExchangeFormatter)
  ['{FCD67148-5948-3233-B084-A53EAE6509DC}']
  { getters & setters } 

    function get_Parameter: TArray<Byte>;
    procedure set_Parameter(value: TArray<Byte>);
    function get_Parameters: string;
    function get_Rng: DNRandomNumberGenerator;
    procedure set_Rng(value: DNRandomNumberGenerator);

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function CreateKeyExchange(rgbData: TArray<Byte>; symAlgType: DDNC.System.Private.CoreLib.DNType): TArray<Byte>; overload;
    function CreateKeyExchange(rgbData: TArray<Byte>): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameter: TArray<Byte> read get_Parameter write set_Parameter;
    property Parameters: string read get_Parameters;
    property Rng: DNRandomNumberGenerator read get_Rng write set_Rng;
  end;

  TDNRSAOAEPKeyExchangeFormatter = class(TDNGenericImport<DNRSAOAEPKeyExchangeFormatterClass, DNRSAOAEPKeyExchangeFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1KeyExchangeFormatterClass = interface(DNAsymmetricKeyExchangeFormatterClass)
  ['{A7B039EB-C876-575C-8E91-5A5564B37AAD}']
  { constructors } 

    {class} function init: DNRSAPKCS1KeyExchangeFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1KeyExchangeFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1KeyExchangeFormatter')]
  DNRSAPKCS1KeyExchangeFormatter = interface(DNAsymmetricKeyExchangeFormatter)
  ['{0DFD289C-291F-333E-860C-021AC932DDE3}']
  { getters & setters } 

    function get_Parameters: string;
    function get_Rng: DNRandomNumberGenerator;
    procedure set_Rng(value: DNRandomNumberGenerator);

  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    function CreateKeyExchange(rgbData: TArray<Byte>; symAlgType: DDNC.System.Private.CoreLib.DNType): TArray<Byte>; overload;
    function CreateKeyExchange(rgbData: TArray<Byte>): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parameters: string read get_Parameters;
    property Rng: DNRandomNumberGenerator read get_Rng write set_Rng;
  end;

  TDNRSAPKCS1KeyExchangeFormatter = class(TDNGenericImport<DNRSAPKCS1KeyExchangeFormatterClass, DNRSAPKCS1KeyExchangeFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricSignatureDeformatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{6D84FC66-56D3-5060-86F5-BC17A5C9C86B}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricSignatureDeformatter')]
  DNAsymmetricSignatureDeformatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0719C071-04CD-3403-807B-67FB0231A26D}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function VerifySignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNAsymmetricSignatureDeformatter = class(TDNGenericImport<DNAsymmetricSignatureDeformatterClass, DNAsymmetricSignatureDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSASignatureDeformatterClass = interface(DNAsymmetricSignatureDeformatterClass)
  ['{F72FBA2F-B440-51A4-82F8-C1F609CCAA09}']
  { constructors } 

    {class} function init: DNDSASignatureDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNDSASignatureDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSASignatureDeformatter')]
  DNDSASignatureDeformatter = interface(DNAsymmetricSignatureDeformatter)
  ['{010AE6C9-05ED-311A-BAC2-5C95E13494E0}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm; rgbSignature: TArray<Byte>): Boolean; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDSASignatureDeformatter = class(TDNGenericImport<DNDSASignatureDeformatterClass, DNDSASignatureDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1SignatureDeformatterClass = interface(DNAsymmetricSignatureDeformatterClass)
  ['{0768DABD-7FBE-53A6-84B6-0FB4011AA0BD}']
  { constructors } 

    {class} function init: DNRSAPKCS1SignatureDeformatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1SignatureDeformatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1SignatureDeformatter')]
  DNRSAPKCS1SignatureDeformatter = interface(DNAsymmetricSignatureDeformatter)
  ['{005DEDFB-93CE-36C1-A2B5-51492137436F}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function VerifySignature(rgbHash: TArray<Byte>; rgbSignature: TArray<Byte>): Boolean; overload;
    function VerifySignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm; rgbSignature: TArray<Byte>): Boolean; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNRSAPKCS1SignatureDeformatter = class(TDNGenericImport<DNRSAPKCS1SignatureDeformatterClass, DNRSAPKCS1SignatureDeformatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAsymmetricSignatureFormatterClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{3B249CC8-A060-5955-92AE-0E0A54BAE4C4}']
  end;

  [DNTypeName('System.Security.Cryptography.AsymmetricSignatureFormatter')]
  DNAsymmetricSignatureFormatter = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{65C26066-5198-33AD-943E-308DBECFEF78}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function CreateSignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm): TArray<Byte>; overload;
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNAsymmetricSignatureFormatter = class(TDNGenericImport<DNAsymmetricSignatureFormatterClass, DNAsymmetricSignatureFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSASignatureFormatterClass = interface(DNAsymmetricSignatureFormatterClass)
  ['{7BD17C13-5170-5D42-B6FC-565AB1336FA4}']
  { constructors } 

    {class} function init: DNDSASignatureFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNDSASignatureFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.DSASignatureFormatter')]
  DNDSASignatureFormatter = interface(DNAsymmetricSignatureFormatter)
  ['{24BE18BC-69E4-341E-AE40-EEAB0BF5C7EF}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function CreateSignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDSASignatureFormatter = class(TDNGenericImport<DNDSASignatureFormatterClass, DNDSASignatureFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAPKCS1SignatureFormatterClass = interface(DNAsymmetricSignatureFormatterClass)
  ['{BAEF4A5B-F28F-5517-B453-38C6E956E6ED}']
  { constructors } 

    {class} function init: DNRSAPKCS1SignatureFormatter; overload;
    {class} function init(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNRSAPKCS1SignatureFormatter; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RSAPKCS1SignatureFormatter')]
  DNRSAPKCS1SignatureFormatter = interface(DNAsymmetricSignatureFormatter)
  ['{3F27F962-79E7-3D05-8B4C-C24EE13E33AB}']
  { methods } 

    procedure SetKey(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm);
    procedure SetHashAlgorithm(strName: string);
    function CreateSignature(rgbHash: TArray<Byte>): TArray<Byte>; overload;
    function CreateSignature(hash: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm): TArray<Byte>; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNRSAPKCS1SignatureFormatter = class(TDNGenericImport<DNRSAPKCS1SignatureFormatterClass, DNRSAPKCS1SignatureFormatter>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNCryptoConfigClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{E948B6E0-701E-5D6C-BD21-C2AB06C98485}']
  { static getter & setter } 

    {class} function get_AllowOnlyFipsAlgorithms: Boolean;

  { constructors } 

    {class} function init: DNCryptoConfig;

  { static methods } 

    {class} procedure AddAlgorithm(algorithm: DDNC.System.Private.CoreLib.DNType; names: TArray<string>);
    {class} function CreateFromName(name: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject; overload;
    {class} function CreateFromName(name: string): DDNC.System.Private.CoreLib.DNObject; overload;
    {class} procedure AddOID(oid: string; names: TArray<string>);
    {class} function MapNameToOID(name: string): string;
    {class} function EncodeOID(str: string): TArray<Byte>;

  { static propertys } 

    {class} property AllowOnlyFipsAlgorithms: Boolean read get_AllowOnlyFipsAlgorithms;
  end;

  [DNTypeName('System.Security.Cryptography.CryptoConfig')]
  DNCryptoConfig = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3CD8799A-FFAC-31B3-8476-D38786F5867E}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNCryptoConfig = class(TDNGenericImport<DNCryptoConfigClass, DNCryptoConfig>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDeriveBytesClass = interface(DNObjectClass)
  ['{7CE44E6D-CFC7-5EC3-91E5-437CDBEE110E}']
  end;

  [DNTypeName('System.Security.Cryptography.DeriveBytes')]
  DNDeriveBytes = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{9918783A-32FB-3D8E-AA9E-9728D81DEB6C}']
  { methods } 

    function GetBytes(cb: Int32): TArray<Byte>;
    procedure Reset;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDeriveBytes = class(TDNGenericImport<DNDeriveBytesClass, DNDeriveBytes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRfc2898DeriveBytesClass = interface(DNDeriveBytesClass)
  ['{202E8500-D290-5231-81D6-D83BD2F77110}']
  { constructors } 

    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; iterations: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: TArray<Byte>; salt: TArray<Byte>; iterations: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; salt: TArray<Byte>): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; salt: TArray<Byte>; iterations: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; salt: TArray<Byte>; iterations: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; saltSize: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; saltSize: Int32; iterations: Int32): DNRfc2898DeriveBytes; overload;
    {class} function init(password: string; saltSize: Int32; iterations: Int32; hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRfc2898DeriveBytes; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Rfc2898DeriveBytes')]
  DNRfc2898DeriveBytes = interface(DNDeriveBytes)
  ['{9ABEB25B-4B6B-3745-A063-C41B1D408C10}']
  { getters & setters } 

    function get_HashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;
    function get_IterationCount: Int32;
    procedure set_IterationCount(value: Int32);
    function get_Salt: TArray<Byte>;
    procedure set_Salt(value: TArray<Byte>);

  { methods } 

    function GetBytes(cb: Int32): TArray<Byte>;
    function CryptDeriveKey(algname: string; alghashname: string; keySize: Int32; rgbIV: TArray<Byte>): TArray<Byte>;
    procedure Reset;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_HashAlgorithm;
    property IterationCount: Int32 read get_IterationCount write set_IterationCount;
    property Salt: TArray<Byte> read get_Salt write set_Salt;
  end;

  TDNRfc2898DeriveBytes = class(TDNGenericImport<DNRfc2898DeriveBytesClass, DNRfc2898DeriveBytes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECCurve_NamedCurvesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{D58389A2-5CCB-51F2-8668-2C2F5817EBCB}']
  { static getter & setter } 

    {class} function get_brainpoolP160r1: DNECCurve;
    {class} function get_brainpoolP160t1: DNECCurve;
    {class} function get_brainpoolP192r1: DNECCurve;
    {class} function get_brainpoolP192t1: DNECCurve;
    {class} function get_brainpoolP224r1: DNECCurve;
    {class} function get_brainpoolP224t1: DNECCurve;
    {class} function get_brainpoolP256r1: DNECCurve;
    {class} function get_brainpoolP256t1: DNECCurve;
    {class} function get_brainpoolP320r1: DNECCurve;
    {class} function get_brainpoolP320t1: DNECCurve;
    {class} function get_brainpoolP384r1: DNECCurve;
    {class} function get_brainpoolP384t1: DNECCurve;
    {class} function get_brainpoolP512r1: DNECCurve;
    {class} function get_brainpoolP512t1: DNECCurve;
    {class} function get_nistP256: DNECCurve;
    {class} function get_nistP384: DNECCurve;
    {class} function get_nistP521: DNECCurve;

  { static propertys } 

    {class} property brainpoolP160r1: DNECCurve read get_brainpoolP160r1;
    {class} property brainpoolP160t1: DNECCurve read get_brainpoolP160t1;
    {class} property brainpoolP192r1: DNECCurve read get_brainpoolP192r1;
    {class} property brainpoolP192t1: DNECCurve read get_brainpoolP192t1;
    {class} property brainpoolP224r1: DNECCurve read get_brainpoolP224r1;
    {class} property brainpoolP224t1: DNECCurve read get_brainpoolP224t1;
    {class} property brainpoolP256r1: DNECCurve read get_brainpoolP256r1;
    {class} property brainpoolP256t1: DNECCurve read get_brainpoolP256t1;
    {class} property brainpoolP320r1: DNECCurve read get_brainpoolP320r1;
    {class} property brainpoolP320t1: DNECCurve read get_brainpoolP320t1;
    {class} property brainpoolP384r1: DNECCurve read get_brainpoolP384r1;
    {class} property brainpoolP384t1: DNECCurve read get_brainpoolP384t1;
    {class} property brainpoolP512r1: DNECCurve read get_brainpoolP512r1;
    {class} property brainpoolP512t1: DNECCurve read get_brainpoolP512t1;
    {class} property nistP256: DNECCurve read get_nistP256;
    {class} property nistP384: DNECCurve read get_nistP384;
    {class} property nistP521: DNECCurve read get_nistP521;
  end;

  [DNTypeName('System.Security.Cryptography.ECCurve+NamedCurves')]
  DNECCurve_NamedCurves = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{BEB4D4A6-7DB1-3F66-803B-1498AF366C26}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNECCurve_NamedCurves = class(TDNGenericImport<DNECCurve_NamedCurvesClass, DNECCurve_NamedCurves>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECDiffieHellmanPublicKeyClass = interface(DNObjectClass)
  ['{B08C6B7A-D7AD-5410-9C7B-0BD8DE511619}']
  end;

  [DNTypeName('System.Security.Cryptography.ECDiffieHellmanPublicKey')]
  DNECDiffieHellmanPublicKey = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{61D38D77-53FC-37FC-803D-4AFABFCB4001}']
  { methods } 

    procedure Dispose;
    function ToByteArray: TArray<Byte>;
    function ToXmlString: string;
    function ExportParameters: DNECParameters;
    function ExportExplicitParameters: DNECParameters;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNECDiffieHellmanPublicKey = class(TDNGenericImport<DNECDiffieHellmanPublicKeyClass, DNECDiffieHellmanPublicKey>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACMD5Class = interface(DNObjectClass)
  ['{51712444-F47F-5573-AD4D-CDB027C3F5AC}']
  { constructors } 

    {class} function init: DNHMACMD5; overload;
    {class} function init(key: TArray<Byte>): DNHMACMD5; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACMD5')]
  DNHMACMD5 = interface(DNObject)
  ['{70E0FC87-9FB3-3D51-963F-C1E2D336D5ED}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACMD5 = class(TDNGenericImport<DNHMACMD5Class, DNHMACMD5>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA1Class = interface(DNObjectClass)
  ['{67C34FA6-9ACC-5D4C-A8E0-C3C85FAFDC94}']
  { constructors } 

    {class} function init: DNHMACSHA1; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA1; overload;
    {class} function init(key: TArray<Byte>; useManagedSha1: Boolean): DNHMACSHA1; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA1')]
  DNHMACSHA1 = interface(DNObject)
  ['{0A3375CD-E2AD-3BC2-98E4-6AF6C7981979}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA1 = class(TDNGenericImport<DNHMACSHA1Class, DNHMACSHA1>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA256Class = interface(DNObjectClass)
  ['{44F1A015-A727-5F3D-80C3-F703643FBEC4}']
  { constructors } 

    {class} function init: DNHMACSHA256; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA256; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA256')]
  DNHMACSHA256 = interface(DNObject)
  ['{DDB1918E-51D1-3B1B-8563-B95C91EFC4D0}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA256 = class(TDNGenericImport<DNHMACSHA256Class, DNHMACSHA256>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA384Class = interface(DNObjectClass)
  ['{B9A1836A-5A2F-58FE-9A1B-5D942D1BD85C}']
  { constructors } 

    {class} function init: DNHMACSHA384; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA384; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA384')]
  DNHMACSHA384 = interface(DNObject)
  ['{208B251A-177D-3970-8B36-FB06A14A40E0}']
  { getters & setters } 

    function get_ProduceLegacyHmacValues: Boolean;
    procedure set_ProduceLegacyHmacValues(value: Boolean);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ProduceLegacyHmacValues: Boolean read get_ProduceLegacyHmacValues write set_ProduceLegacyHmacValues;
    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA384 = class(TDNGenericImport<DNHMACSHA384Class, DNHMACSHA384>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHMACSHA512Class = interface(DNObjectClass)
  ['{8DDE69D3-1AC8-5BE6-8EDC-F64C805C0CEF}']
  { constructors } 

    {class} function init: DNHMACSHA512; overload;
    {class} function init(key: TArray<Byte>): DNHMACSHA512; overload;

  end;

  [DNTypeName('System.Security.Cryptography.HMACSHA512')]
  DNHMACSHA512 = interface(DNObject)
  ['{9FF64320-27AA-3845-AA86-E11A0D77D2BE}']
  { getters & setters } 

    function get_ProduceLegacyHmacValues: Boolean;
    procedure set_ProduceLegacyHmacValues(value: Boolean);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_HashName: string;
    procedure set_HashName(value: string);
    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ProduceLegacyHmacValues: Boolean read get_ProduceLegacyHmacValues write set_ProduceLegacyHmacValues;
    property Key: TArray<Byte> read get_Key write set_Key;
    property HashName: string read get_HashName write set_HashName;
    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNHMACSHA512 = class(TDNGenericImport<DNHMACSHA512Class, DNHMACSHA512>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNMD5Class = interface(DNObjectClass)
  ['{18F9839A-DEDC-527D-9F3D-1F6782278FAA}']
  { static methods } 

    {class} function Create: DNMD5; overload;
    {class} function Create(algName: string): DNMD5; overload;
    {class} function HashData(source: TArray<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    {class} function TryHashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.MD5')]
  DNMD5 = interface(DNObject)
  ['{9A79DF8A-05DB-3A45-A35D-34A76387BE55}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNMD5 = class(TDNGenericImport<DNMD5Class, DNMD5>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA1Class = interface(DNObjectClass)
  ['{E9A8D40E-A5DF-5FFA-9EB2-0C930759DE21}']
  { static methods } 

    {class} function Create: DNSHA1; overload;
    {class} function Create(hashName: string): DNSHA1; overload;
    {class} function HashData(source: TArray<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    {class} function TryHashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.SHA1')]
  DNSHA1 = interface(DNObject)
  ['{BF86EC5B-61F9-35F0-9991-9665142CA694}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA1 = class(TDNGenericImport<DNSHA1Class, DNSHA1>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA1ManagedClass = interface(DNSHA1Class)
  ['{F4A35CA6-7D50-586A-918E-256BD33DC3BD}']
  { constructors } 

    {class} function init: DNSHA1Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA1Managed')]
  DNSHA1Managed = interface(DNSHA1)
  ['{9180F4F8-F1D6-3A73-A2E4-8EF8D22B921F}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA1Managed = class(TDNGenericImport<DNSHA1ManagedClass, DNSHA1Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA256Class = interface(DNObjectClass)
  ['{D9D6ED52-1E96-56AC-86CB-C92001151BEC}']
  { static methods } 

    {class} function Create: DNSHA256; overload;
    {class} function Create(hashName: string): DNSHA256; overload;
    {class} function HashData(source: TArray<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    {class} function TryHashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.SHA256')]
  DNSHA256 = interface(DNObject)
  ['{4FC3289F-3B16-39FE-A913-AB3E011BE820}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA256 = class(TDNGenericImport<DNSHA256Class, DNSHA256>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA256ManagedClass = interface(DNSHA256Class)
  ['{22AC697C-CA05-55D0-A660-9C7AA0AFD19F}']
  { constructors } 

    {class} function init: DNSHA256Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA256Managed')]
  DNSHA256Managed = interface(DNSHA256)
  ['{9202A57F-D839-3D80-A7E3-62C6192AE303}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA256Managed = class(TDNGenericImport<DNSHA256ManagedClass, DNSHA256Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA384Class = interface(DNObjectClass)
  ['{71436013-9E5D-58F3-B190-3945C0F5BD02}']
  { static methods } 

    {class} function Create: DNSHA384; overload;
    {class} function Create(hashName: string): DNSHA384; overload;
    {class} function HashData(source: TArray<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    {class} function TryHashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.SHA384')]
  DNSHA384 = interface(DNObject)
  ['{CC1189B7-CE54-33BF-B1A2-93225D579534}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA384 = class(TDNGenericImport<DNSHA384Class, DNSHA384>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA384ManagedClass = interface(DNSHA384Class)
  ['{7DB67AF5-06BB-53D7-99C7-B18C9358FAD8}']
  { constructors } 

    {class} function init: DNSHA384Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA384Managed')]
  DNSHA384Managed = interface(DNSHA384)
  ['{BE8CC32F-B046-3AED-824B-E4342C376094}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA384Managed = class(TDNGenericImport<DNSHA384ManagedClass, DNSHA384Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA512Class = interface(DNObjectClass)
  ['{636509D1-1777-53D1-9EA6-7F80EDF34641}']
  { static methods } 

    {class} function Create: DNSHA512; overload;
    {class} function Create(hashName: string): DNSHA512; overload;
    {class} function HashData(source: TArray<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): TArray<Byte>; overload;
    {class} function HashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    {class} function TryHashData(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.SHA512')]
  DNSHA512 = interface(DNObject)
  ['{F9F7DD18-8943-3DEC-9D8A-C127E21C4D50}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    procedure Initialize;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA512 = class(TDNGenericImport<DNSHA512Class, DNSHA512>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSHA512ManagedClass = interface(DNSHA512Class)
  ['{61CD021E-8F3A-5A4D-AA97-48DF7712D8B9}']
  { constructors } 

    {class} function init: DNSHA512Managed;

  end;

  [DNTypeName('System.Security.Cryptography.SHA512Managed')]
  DNSHA512Managed = interface(DNSHA512)
  ['{0F461154-5FD9-351C-88E8-BA7146236D7A}']
  { getters & setters } 

    function get_HashSize: Int32;
    function get_Hash: TArray<Byte>;
    function get_InputBlockSize: Int32;
    function get_OutputBlockSize: Int32;
    function get_CanTransformMultipleBlocks: Boolean;
    function get_CanReuseTransform: Boolean;

  { methods } 

    procedure Initialize;
    function ComputeHash(buffer: TArray<Byte>): TArray<Byte>; overload;
    function TryComputeHash(source: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function ComputeHash(buffer: TArray<Byte>; offset: Int32; count: Int32): TArray<Byte>; overload;
    function ComputeHash(inputStream: DDNC.System.Private.CoreLib.DNStream): TArray<Byte>; overload;
    function ComputeHashAsync(inputStream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    procedure Dispose;
    procedure Clear;
    function TransformBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32; outputBuffer: TArray<Byte>; outputOffset: Int32): Int32;
    function TransformFinalBlock(inputBuffer: TArray<Byte>; inputOffset: Int32; inputCount: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashSize: Int32 read get_HashSize;
    property Hash: TArray<Byte> read get_Hash;
    property InputBlockSize: Int32 read get_InputBlockSize;
    property OutputBlockSize: Int32 read get_OutputBlockSize;
    property CanTransformMultipleBlocks: Boolean read get_CanTransformMultipleBlocks;
    property CanReuseTransform: Boolean read get_CanReuseTransform;
  end;

  TDNSHA512Managed = class(TDNGenericImport<DNSHA512ManagedClass, DNSHA512Managed>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNHKDFClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{E52712F6-96A7-5D54-97B2-0B003890BC81}']
  { static methods } 

    {class} function Extract(hashAlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; ikm: TArray<Byte>; salt: TArray<Byte>): TArray<Byte>; overload;
    {class} function Extract(hashAlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; ikm: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; salt: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; prk: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    {class} function Expand(hashAlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; prk: TArray<Byte>; outputLength: Int32; info: TArray<Byte>): TArray<Byte>; overload;
    {class} procedure Expand(hashAlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; prk: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; output: DDNC.System.Private.CoreLib.DNSpan<Byte>; info: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    {class} function DeriveKey(hashAlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; ikm: TArray<Byte>; outputLength: Int32; salt: TArray<Byte>; info: TArray<Byte>): TArray<Byte>; overload;
    {class} procedure DeriveKey(hashAlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; ikm: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; output: DDNC.System.Private.CoreLib.DNSpan<Byte>; salt: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; info: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;

  end;

  [DNTypeName('System.Security.Cryptography.HKDF')]
  DNHKDF = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8618C531-5342-3646-9E85-D1AA3BB5A53E}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHKDF = class(TDNGenericImport<DNHKDFClass, DNHKDF>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNIncrementalHashClass = interface(DNObjectClass)
  ['{81AEC4E4-7B00-54CA-A9ED-67922B6318D2}']
  { static methods } 

    {class} function CreateHash(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNIncrementalHash;
    {class} function CreateHMAC(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; key: TArray<Byte>): DNIncrementalHash; overload;
    {class} function CreateHMAC(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName; key: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNIncrementalHash; overload;

  end;

  [DNTypeName('System.Security.Cryptography.IncrementalHash')]
  DNIncrementalHash = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{CF5FE42E-3CDB-3572-960A-75FF1B51051E}']
  { getters & setters } 

    function get_HashLengthInBytes: Int32;
    function get_AlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;

  { methods } 

    procedure AppendData(data: TArray<Byte>); overload;
    procedure AppendData(data: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure AppendData(data: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    function GetHashAndReset: TArray<Byte>; overload;
    function GetHashAndReset(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function TryGetHashAndReset(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function GetCurrentHash: TArray<Byte>; overload;
    function GetCurrentHash(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function TryGetCurrentHash(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashLengthInBytes: Int32 read get_HashLengthInBytes;
    property AlgorithmName: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_AlgorithmName;
  end;

  TDNIncrementalHash = class(TDNGenericImport<DNIncrementalHashClass, DNIncrementalHash>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNMaskGenerationMethodClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{4D94E51A-A77D-5938-9EB9-75D8E7BBE7C5}']
  end;

  [DNTypeName('System.Security.Cryptography.MaskGenerationMethod')]
  DNMaskGenerationMethod = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{248C0075-DB16-3793-9A8B-10ABF1D1B461}']
  { methods } 

    function GenerateMask(rgbSeed: TArray<Byte>; cbReturn: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNMaskGenerationMethod = class(TDNGenericImport<DNMaskGenerationMethodClass, DNMaskGenerationMethod>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNPKCS1MaskGenerationMethodClass = interface(DNMaskGenerationMethodClass)
  ['{52BEA2ED-21B5-58B0-8DA5-126EAC1CA2F6}']
  { constructors } 

    {class} function init: DNPKCS1MaskGenerationMethod;

  end;

  [DNTypeName('System.Security.Cryptography.PKCS1MaskGenerationMethod')]
  DNPKCS1MaskGenerationMethod = interface(DNMaskGenerationMethod)
  ['{723CAEC8-F764-3FAA-87F5-8C707D7B74FF}']
  { getters & setters } 

    function get_HashName: string;
    procedure set_HashName(value: string);

  { methods } 

    function GenerateMask(rgbSeed: TArray<Byte>; cbReturn: Int32): TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HashName: string read get_HashName write set_HashName;
  end;

  TDNPKCS1MaskGenerationMethod = class(TDNGenericImport<DNPKCS1MaskGenerationMethodClass, DNPKCS1MaskGenerationMethod>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRandomNumberGeneratorClass = interface(DNObjectClass)
  ['{E08BB2AA-E4DC-5FF6-8A27-2A8ACBF94BC7}']
  { static methods } 

    {class} function Create: DNRandomNumberGenerator; overload;
    {class} function Create(rngName: string): DNRandomNumberGenerator; overload;
    {class} procedure Fill(data: DDNC.System.Private.CoreLib.DNSpan<Byte>);
    {class} function GetInt32(fromInclusive: Int32; toExclusive: Int32): Int32; overload;
    {class} function GetInt32(toExclusive: Int32): Int32; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RandomNumberGenerator')]
  DNRandomNumberGenerator = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{0029A707-E4ED-33AA-9A93-6B2F5F0F8B97}']
  { methods } 

    procedure Dispose;
    procedure GetBytes(data: TArray<Byte>); overload;
    procedure GetBytes(data: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure GetBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    procedure GetNonZeroBytes(data: TArray<Byte>); overload;
    procedure GetNonZeroBytes(data: DDNC.System.Private.CoreLib.DNSpan<Byte>); overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNRandomNumberGenerator = class(TDNGenericImport<DNRandomNumberGeneratorClass, DNRandomNumberGenerator>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAEncryptionPaddingClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{BED52B8E-82EF-58B8-B0F0-A7CA87F2EF9E}']
  { static getter & setter } 

    {class} function get_Pkcs1: DNRSAEncryptionPadding;
    {class} function get_OaepSHA1: DNRSAEncryptionPadding;
    {class} function get_OaepSHA256: DNRSAEncryptionPadding;
    {class} function get_OaepSHA384: DNRSAEncryptionPadding;
    {class} function get_OaepSHA512: DNRSAEncryptionPadding;

  { static methods } 

    {class} function CreateOaep(hashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName): DNRSAEncryptionPadding;

  { static propertys } 

    {class} property Pkcs1: DNRSAEncryptionPadding read get_Pkcs1;
    {class} property OaepSHA1: DNRSAEncryptionPadding read get_OaepSHA1;
    {class} property OaepSHA256: DNRSAEncryptionPadding read get_OaepSHA256;
    {class} property OaepSHA384: DNRSAEncryptionPadding read get_OaepSHA384;
    {class} property OaepSHA512: DNRSAEncryptionPadding read get_OaepSHA512;
  end;

  [DNTypeName('System.Security.Cryptography.RSAEncryptionPadding')]
  DNRSAEncryptionPadding = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{50BD58EA-0777-3BE5-82D8-C5C1CF90BC3E}']
  { getters & setters } 

    function get_Mode: DNRSAEncryptionPaddingMode;
    function get_OaepHashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNRSAEncryptionPadding): Boolean; overload;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Mode: DNRSAEncryptionPaddingMode read get_Mode;
    property OaepHashAlgorithm: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName read get_OaepHashAlgorithm;
  end;

  TDNRSAEncryptionPadding = class(TDNGenericImport<DNRSAEncryptionPaddingClass, DNRSAEncryptionPadding>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSASignaturePaddingClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0569E0BB-1DB9-5E8B-A95C-93C9E5A8152C}']
  { static getter & setter } 

    {class} function get_Pkcs1: DNRSASignaturePadding;
    {class} function get_Pss: DNRSASignaturePadding;

  { static propertys } 

    {class} property Pkcs1: DNRSASignaturePadding read get_Pkcs1;
    {class} property Pss: DNRSASignaturePadding read get_Pss;
  end;

  [DNTypeName('System.Security.Cryptography.RSASignaturePadding')]
  DNRSASignaturePadding = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{5A2FFEFE-D8D7-397D-945C-94D4D227142B}']
  { getters & setters } 

    function get_Mode: DNRSASignaturePaddingMode;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNRSASignaturePadding): Boolean; overload;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Mode: DNRSASignaturePaddingMode read get_Mode;
  end;

  TDNRSASignaturePadding = class(TDNGenericImport<DNRSASignaturePaddingClass, DNRSASignaturePadding>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNSignatureDescriptionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{736FFCD9-3E0A-5765-8EC0-7FFFA5FF5722}']
  { constructors } 

    {class} function init: DNSignatureDescription; overload;
    {class} function init(el: DDNC.System.Private.CoreLib.DNSecurityElement): DNSignatureDescription; overload;

  end;

  [DNTypeName('System.Security.Cryptography.SignatureDescription')]
  DNSignatureDescription = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{6497B022-8B5E-3194-9BD0-45FD10CBEC62}']
  { getters & setters } 

    function get_KeyAlgorithm: string;
    procedure set_KeyAlgorithm(value: string);
    function get_DigestAlgorithm: string;
    procedure set_DigestAlgorithm(value: string);
    function get_FormatterAlgorithm: string;
    procedure set_FormatterAlgorithm(value: string);
    function get_DeformatterAlgorithm: string;
    procedure set_DeformatterAlgorithm(value: string);

  { methods } 

    function CreateDeformatter(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNAsymmetricSignatureDeformatter;
    function CreateFormatter(key: DDNC.System.Security.Cryptography.Primitives.DNAsymmetricAlgorithm): DNAsymmetricSignatureFormatter;
    function CreateDigest: DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithm;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeyAlgorithm: string read get_KeyAlgorithm write set_KeyAlgorithm;
    property DigestAlgorithm: string read get_DigestAlgorithm write set_DigestAlgorithm;
    property FormatterAlgorithm: string read get_FormatterAlgorithm write set_FormatterAlgorithm;
    property DeformatterAlgorithm: string read get_DeformatterAlgorithm write set_DeformatterAlgorithm;
  end;

  TDNSignatureDescription = class(TDNGenericImport<DNSignatureDescriptionClass, DNSignatureDescription>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesClass = interface(DNObjectClass)
  ['{3DFC2A00-F257-59A3-BD3F-1B7A6EBF4ABF}']
  { static methods } 

    {class} function Create: DNAes; overload;
    {class} function Create(algorithmName: string): DNAes; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Aes')]
  DNAes = interface(DNObject)
  ['{A55F207C-F297-327D-A8A4-ABE503FE013F}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNAes = class(TDNGenericImport<DNAesClass, DNAes>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNAesManagedClass = interface(DNAesClass)
  ['{7794D807-927D-54DC-BD94-15515F7A9D2D}']
  { constructors } 

    {class} function init: DNAesManaged;

  end;

  [DNTypeName('System.Security.Cryptography.AesManaged')]
  DNAesManaged = interface(DNAes)
  ['{16D58647-5D04-3267-8C48-7625FE8F94B6}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
  end;

  TDNAesManaged = class(TDNGenericImport<DNAesManagedClass, DNAesManaged>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDESClass = interface(DNObjectClass)
  ['{5871D885-A1F2-5290-B503-3FE0BD0A400A}']
  { static methods } 

    {class} function Create: DNDES; overload;
    {class} function Create(algName: string): DNDES; overload;
    {class} function IsWeakKey(rgbKey: TArray<Byte>): Boolean;
    {class} function IsSemiWeakKey(rgbKey: TArray<Byte>): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.DES')]
  DNDES = interface(DNObject)
  ['{BCB7D985-C02D-3F02-BF55-2D59EF9085A3}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNDES = class(TDNGenericImport<DNDESClass, DNDES>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRC2Class = interface(DNObjectClass)
  ['{622DA8BC-0597-56E0-8719-AD7BDDB336A3}']
  { static methods } 

    {class} function Create: DNRC2; overload;
    {class} function Create(AlgName: string): DNRC2; overload;

  end;

  [DNTypeName('System.Security.Cryptography.RC2')]
  DNRC2 = interface(DNObject)
  ['{18F8F9F2-9D62-3F6C-81B4-18AA224F009A}']
  { getters & setters } 

    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_EffectiveKeySize: Int32;
    procedure set_EffectiveKeySize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property KeySize: Int32 read get_KeySize write set_KeySize;
    property EffectiveKeySize: Int32 read get_EffectiveKeySize write set_EffectiveKeySize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNRC2 = class(TDNGenericImport<DNRC2Class, DNRC2>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRijndaelClass = interface(DNObjectClass)
  ['{557FBD30-F2FB-50CA-9F48-1CDDCF778BB4}']
  { static methods } 

    {class} function Create: DNRijndael; overload;
    {class} function Create(algName: string): DNRijndael; overload;

  end;

  [DNTypeName('System.Security.Cryptography.Rijndael')]
  DNRijndael = interface(DNObject)
  ['{D742E4BE-6CDD-3F6A-94CE-CBE6B60C3CFC}']
  { getters & setters } 

    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNRijndael = class(TDNGenericImport<DNRijndaelClass, DNRijndael>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRijndaelManagedClass = interface(DNRijndaelClass)
  ['{75D82189-F9EF-584A-8A5E-C4487A8C0E21}']
  { constructors } 

    {class} function init: DNRijndaelManaged;

  end;

  [DNTypeName('System.Security.Cryptography.RijndaelManaged')]
  DNRijndaelManaged = interface(DNRijndael)
  ['{EA95AE60-DA11-3076-A22A-B107D817DDC4}']
  { getters & setters } 

    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;

  { methods } 

    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure GenerateIV;
    procedure GenerateKey;
    procedure Dispose;
    procedure Clear;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property Key: TArray<Byte> read get_Key write set_Key;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
  end;

  TDNRijndaelManaged = class(TDNGenericImport<DNRijndaelManagedClass, DNRijndaelManaged>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNTripleDESClass = interface(DNObjectClass)
  ['{4C2C87A0-62D1-51D3-A928-B472BE55B660}']
  { static methods } 

    {class} function Create: DNTripleDES; overload;
    {class} function Create(str: string): DNTripleDES; overload;
    {class} function IsWeakKey(rgbKey: TArray<Byte>): Boolean;

  end;

  [DNTypeName('System.Security.Cryptography.TripleDES')]
  DNTripleDES = interface(DNObject)
  ['{8B14748B-9720-345D-A99C-E49BB3F69DE3}']
  { getters & setters } 

    function get_Key: TArray<Byte>;
    procedure set_Key(value: TArray<Byte>);
    function get_FeedbackSize: Int32;
    procedure set_FeedbackSize(value: Int32);
    function get_BlockSize: Int32;
    procedure set_BlockSize(value: Int32);
    function get_IV: TArray<Byte>;
    procedure set_IV(value: TArray<Byte>);
    function get_KeySize: Int32;
    procedure set_KeySize(value: Int32);
    function get_LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes>;
    function get_Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode;
    procedure set_Mode(value: DDNC.System.Security.Cryptography.Primitives.DNCipherMode);
    function get_Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode;
    procedure set_Padding(value: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode);

  { methods } 

    function CreateDecryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateDecryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor: DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    function CreateEncryptor(rgbKey: TArray<Byte>; rgbIV: TArray<Byte>): DDNC.System.Security.Cryptography.Primitives.DNICryptoTransform; overload;
    procedure Dispose;
    procedure Clear;
    procedure GenerateIV;
    procedure GenerateKey;
    function ValidKeySize(bitLength: Int32): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Key: TArray<Byte> read get_Key write set_Key;
    property FeedbackSize: Int32 read get_FeedbackSize write set_FeedbackSize;
    property BlockSize: Int32 read get_BlockSize write set_BlockSize;
    property IV: TArray<Byte> read get_IV write set_IV;
    property KeySize: Int32 read get_KeySize write set_KeySize;
    property LegalBlockSizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalBlockSizes;
    property LegalKeySizes: TArray<DDNC.System.Security.Cryptography.Primitives.DNKeySizes> read get_LegalKeySizes;
    property Mode: DDNC.System.Security.Cryptography.Primitives.DNCipherMode read get_Mode write set_Mode;
    property Padding: DDNC.System.Security.Cryptography.Primitives.DNPaddingMode read get_Padding write set_Padding;
  end;

  TDNTripleDES = class(TDNGenericImport<DNTripleDESClass, DNTripleDES>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNDSAParametersClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{78EC1A38-E2EB-5CFF-846C-E2C4109E8D2C}']
  end;

  [DNTypeName('System.Security.Cryptography.DSAParameters')]
  DNDSAParameters = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{03D56A62-3A9C-373B-9DF0-51ACEC56F264}']
  { fields getter & setter } 

   function __fakeFieldGet_P: TArray<Byte>;
   procedure __fakeFieldSet_P(value: TArray<Byte>);
   function __fakeFieldGet_Q: TArray<Byte>;
   procedure __fakeFieldSet_Q(value: TArray<Byte>);
   function __fakeFieldGet_G: TArray<Byte>;
   procedure __fakeFieldSet_G(value: TArray<Byte>);
   function __fakeFieldGet_Y: TArray<Byte>;
   procedure __fakeFieldSet_Y(value: TArray<Byte>);
   function __fakeFieldGet_J: TArray<Byte>;
   procedure __fakeFieldSet_J(value: TArray<Byte>);
   function __fakeFieldGet_X: TArray<Byte>;
   procedure __fakeFieldSet_X(value: TArray<Byte>);
   function __fakeFieldGet_Seed: TArray<Byte>;
   procedure __fakeFieldSet_Seed(value: TArray<Byte>);
   function __fakeFieldGet_Counter: Int32;
   procedure __fakeFieldSet_Counter(value: Int32);

  { fields } 

   property P: TArray<Byte> read __fakeFieldGet_P write __fakeFieldSet_P;
   property Q: TArray<Byte> read __fakeFieldGet_Q write __fakeFieldSet_Q;
   property G: TArray<Byte> read __fakeFieldGet_G write __fakeFieldSet_G;
   property Y: TArray<Byte> read __fakeFieldGet_Y write __fakeFieldSet_Y;
   property J: TArray<Byte> read __fakeFieldGet_J write __fakeFieldSet_J;
   property X: TArray<Byte> read __fakeFieldGet_X write __fakeFieldSet_X;
   property Seed: TArray<Byte> read __fakeFieldGet_Seed write __fakeFieldSet_Seed;
   property Counter: Int32 read __fakeFieldGet_Counter write __fakeFieldSet_Counter;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNDSAParameters = class(TDNGenericImport<DNDSAParametersClass, DNDSAParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECCurveClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{6C2127B6-46A8-5762-A962-331E875ED36E}']
  { static methods } 

    {class} function CreateFromOid(curveOid: DDNC.System.Security.Cryptography.Encoding.DNOid): DNECCurve;
    {class} function CreateFromFriendlyName(oidFriendlyName: string): DNECCurve;
    {class} function CreateFromValue(oidValue: string): DNECCurve;

  end;

  [DNTypeName('System.Security.Cryptography.ECCurve')]
  DNECCurve = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{DB673AF6-A1C9-36D1-B9D8-9555970C715A}']
  { getters & setters } 

    function get_Oid: DDNC.System.Security.Cryptography.Encoding.DNOid;
    function get_IsPrime: Boolean;
    function get_IsCharacteristic2: Boolean;
    function get_IsExplicit: Boolean;
    function get_IsNamed: Boolean;

  { fields getter & setter } 

   function __fakeFieldGet_A: TArray<Byte>;
   procedure __fakeFieldSet_A(value: TArray<Byte>);
   function __fakeFieldGet_B: TArray<Byte>;
   procedure __fakeFieldSet_B(value: TArray<Byte>);
   function __fakeFieldGet_G: DNECPoint;
   procedure __fakeFieldSet_G(value: DNECPoint);
   function __fakeFieldGet_Order: TArray<Byte>;
   procedure __fakeFieldSet_Order(value: TArray<Byte>);
   function __fakeFieldGet_Cofactor: TArray<Byte>;
   procedure __fakeFieldSet_Cofactor(value: TArray<Byte>);
   function __fakeFieldGet_Seed: TArray<Byte>;
   procedure __fakeFieldSet_Seed(value: TArray<Byte>);
   function __fakeFieldGet_CurveType: DNECCurve_ECCurveType;
   procedure __fakeFieldSet_CurveType(value: DNECCurve_ECCurveType);
   function __fakeFieldGet_Hash: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName>;
   procedure __fakeFieldSet_Hash(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName>);
   function __fakeFieldGet_Polynomial: TArray<Byte>;
   procedure __fakeFieldSet_Polynomial(value: TArray<Byte>);
   function __fakeFieldGet_Prime: TArray<Byte>;
   procedure __fakeFieldSet_Prime(value: TArray<Byte>);

  { fields } 

   property A: TArray<Byte> read __fakeFieldGet_A write __fakeFieldSet_A;
   property B: TArray<Byte> read __fakeFieldGet_B write __fakeFieldSet_B;
   property G: DNECPoint read __fakeFieldGet_G write __fakeFieldSet_G;
   property Order: TArray<Byte> read __fakeFieldGet_Order write __fakeFieldSet_Order;
   property Cofactor: TArray<Byte> read __fakeFieldGet_Cofactor write __fakeFieldSet_Cofactor;
   property Seed: TArray<Byte> read __fakeFieldGet_Seed write __fakeFieldSet_Seed;
   property CurveType: DNECCurve_ECCurveType read __fakeFieldGet_CurveType write __fakeFieldSet_CurveType;
   property Hash: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Security.Cryptography.Primitives.DNHashAlgorithmName> read __fakeFieldGet_Hash write __fakeFieldSet_Hash;
   property Polynomial: TArray<Byte> read __fakeFieldGet_Polynomial write __fakeFieldSet_Polynomial;
   property Prime: TArray<Byte> read __fakeFieldGet_Prime write __fakeFieldSet_Prime;

  { methods } 

    procedure Validate;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Oid: DDNC.System.Security.Cryptography.Encoding.DNOid read get_Oid;
    property IsPrime: Boolean read get_IsPrime;
    property IsCharacteristic2: Boolean read get_IsCharacteristic2;
    property IsExplicit: Boolean read get_IsExplicit;
    property IsNamed: Boolean read get_IsNamed;
  end;

  TDNECCurve = class(TDNGenericImport<DNECCurveClass, DNECCurve>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECParametersClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{B1212D23-DDAC-5185-BED4-3AC6AB59EEEC}']
  end;

  [DNTypeName('System.Security.Cryptography.ECParameters')]
  DNECParameters = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{DBB8AD3F-406D-318E-BA73-17FC9787FA12}']
  { fields getter & setter } 

   function __fakeFieldGet_Q: DNECPoint;
   procedure __fakeFieldSet_Q(value: DNECPoint);
   function __fakeFieldGet_D: TArray<Byte>;
   procedure __fakeFieldSet_D(value: TArray<Byte>);
   function __fakeFieldGet_Curve: DNECCurve;
   procedure __fakeFieldSet_Curve(value: DNECCurve);

  { fields } 

   property Q: DNECPoint read __fakeFieldGet_Q write __fakeFieldSet_Q;
   property D: TArray<Byte> read __fakeFieldGet_D write __fakeFieldSet_D;
   property Curve: DNECCurve read __fakeFieldGet_Curve write __fakeFieldSet_Curve;

  { methods } 

    procedure Validate;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNECParameters = class(TDNGenericImport<DNECParametersClass, DNECParameters>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNECPointClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{9262E6BF-5CA2-5E52-8E8C-3152EE115E65}']
  end;

  [DNTypeName('System.Security.Cryptography.ECPoint')]
  DNECPoint = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{A0D823E1-3C1E-35A4-85EA-649C53D2F538}']
  { fields getter & setter } 

   function __fakeFieldGet_X: TArray<Byte>;
   procedure __fakeFieldSet_X(value: TArray<Byte>);
   function __fakeFieldGet_Y: TArray<Byte>;
   procedure __fakeFieldSet_Y(value: TArray<Byte>);

  { fields } 

   property X: TArray<Byte> read __fakeFieldGet_X write __fakeFieldSet_X;
   property Y: TArray<Byte> read __fakeFieldGet_Y write __fakeFieldSet_Y;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNECPoint = class(TDNGenericImport<DNECPointClass, DNECPoint>) end;

  //-------------namespace: System.Security.Cryptography----------------
  DNRSAParametersClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{5823F982-E6B4-5149-A0C3-517C7C4F6E11}']
  end;

  [DNTypeName('System.Security.Cryptography.RSAParameters')]
  DNRSAParameters = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{8FBF19EE-F314-3928-BD49-8C8712CAFEBC}']
  { fields getter & setter } 

   function __fakeFieldGet_D: TArray<Byte>;
   procedure __fakeFieldSet_D(value: TArray<Byte>);
   function __fakeFieldGet_DP: TArray<Byte>;
   procedure __fakeFieldSet_DP(value: TArray<Byte>);
   function __fakeFieldGet_DQ: TArray<Byte>;
   procedure __fakeFieldSet_DQ(value: TArray<Byte>);
   function __fakeFieldGet_Exponent: TArray<Byte>;
   procedure __fakeFieldSet_Exponent(value: TArray<Byte>);
   function __fakeFieldGet_InverseQ: TArray<Byte>;
   procedure __fakeFieldSet_InverseQ(value: TArray<Byte>);
   function __fakeFieldGet_Modulus: TArray<Byte>;
   procedure __fakeFieldSet_Modulus(value: TArray<Byte>);
   function __fakeFieldGet_P: TArray<Byte>;
   procedure __fakeFieldSet_P(value: TArray<Byte>);
   function __fakeFieldGet_Q: TArray<Byte>;
   procedure __fakeFieldSet_Q(value: TArray<Byte>);

  { fields } 

   property D: TArray<Byte> read __fakeFieldGet_D write __fakeFieldSet_D;
   property DP: TArray<Byte> read __fakeFieldGet_DP write __fakeFieldSet_DP;
   property DQ: TArray<Byte> read __fakeFieldGet_DQ write __fakeFieldSet_DQ;
   property Exponent: TArray<Byte> read __fakeFieldGet_Exponent write __fakeFieldSet_Exponent;
   property InverseQ: TArray<Byte> read __fakeFieldGet_InverseQ write __fakeFieldSet_InverseQ;
   property Modulus: TArray<Byte> read __fakeFieldGet_Modulus write __fakeFieldSet_Modulus;
   property P: TArray<Byte> read __fakeFieldGet_P write __fakeFieldSet_P;
   property Q: TArray<Byte> read __fakeFieldGet_Q write __fakeFieldSet_Q;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRSAParameters = class(TDNGenericImport<DNRSAParametersClass, DNRSAParameters>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.Cryptography.Algorithms, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
