//----------------------------------------------------------------------------
//  System.Security.AccessControl.dll: System.Security.AccessControl, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Security.AccessControl
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Security.AccessControl;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Collections.NonGeneric,
  DDNC.System.Security.Principal.Windows;

type

{ enums }

  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AccessControlActions')]
  DNAccessControlActions = type Integer;
  DNAccessControlActionsHelper = record helper for DNAccessControlActions
  public const
    None = 0;
    View = 1;
    Change = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AccessControlModification')]
  DNAccessControlModification = type Integer;
  DNAccessControlModificationHelper = record helper for DNAccessControlModification
  public const
    Add = 0;
    Set_ = 1;
    Reset = 2;
    Remove = 3;
    RemoveAll = 4;
    RemoveSpecific = 5;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AccessControlSections')]
  DNAccessControlSections = type Integer;
  DNAccessControlSectionsHelper = record helper for DNAccessControlSections
  public const
    None = 0;
    Audit = 1;
    Access = 2;
    Owner = 4;
    Group = 8;
    All = 15;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AccessControlType')]
  DNAccessControlType = type Integer;
  DNAccessControlTypeHelper = record helper for DNAccessControlType
  public const
    Allow = 0;
    Deny = 1;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AceFlags')]
  DNAceFlags = type Integer;
  DNAceFlagsHelper = record helper for DNAceFlags
  public const
    None = 0;
    ObjectInherit = 1;
    ContainerInherit = 2;
    NoPropagateInherit = 4;
    InheritOnly = 8;
    InheritanceFlags = 15;
    Inherited_ = 16;
    SuccessfulAccess = 64;
    FailedAccess = 128;
    AuditFlags = 192;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AceQualifier')]
  DNAceQualifier = type Integer;
  DNAceQualifierHelper = record helper for DNAceQualifier
  public const
    AccessAllowed = 0;
    AccessDenied = 1;
    SystemAudit = 2;
    SystemAlarm = 3;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AceType')]
  DNAceType = type Integer;
  DNAceTypeHelper = record helper for DNAceType
  public const
    AccessAllowed = 0;
    AccessDenied = 1;
    SystemAudit = 2;
    SystemAlarm = 3;
    AccessAllowedCompound = 4;
    AccessAllowedObject = 5;
    AccessDeniedObject = 6;
    SystemAuditObject = 7;
    SystemAlarmObject = 8;
    AccessAllowedCallback = 9;
    AccessDeniedCallback = 10;
    AccessAllowedCallbackObject = 11;
    AccessDeniedCallbackObject = 12;
    SystemAuditCallback = 13;
    SystemAlarmCallback = 14;
    SystemAuditCallbackObject = 15;
    SystemAlarmCallbackObject = 16;
    MaxDefinedAceType = 16;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.AuditFlags')]
  DNAuditFlags = type Integer;
  DNAuditFlagsHelper = record helper for DNAuditFlags
  public const
    None = 0;
    Success = 1;
    Failure = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.CompoundAceType')]
  DNCompoundAceType = type Integer;
  DNCompoundAceTypeHelper = record helper for DNCompoundAceType
  public const
    Impersonation = 1;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.ControlFlags')]
  DNControlFlags = type Integer;
  DNControlFlagsHelper = record helper for DNControlFlags
  public const
    None = 0;
    OwnerDefaulted = 1;
    GroupDefaulted = 2;
    DiscretionaryAclPresent = 4;
    DiscretionaryAclDefaulted = 8;
    SystemAclPresent = 16;
    SystemAclDefaulted = 32;
    DiscretionaryAclUntrusted = 64;
    ServerSecurity = 128;
    DiscretionaryAclAutoInheritRequired = 256;
    SystemAclAutoInheritRequired = 512;
    DiscretionaryAclAutoInherited = 1024;
    SystemAclAutoInherited = 2048;
    DiscretionaryAclProtected = 4096;
    SystemAclProtected = 8192;
    RMControlValid = 16384;
    SelfRelative = 32768;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.InheritanceFlags')]
  DNInheritanceFlags = type Integer;
  DNInheritanceFlagsHelper = record helper for DNInheritanceFlags
  public const
    None = 0;
    ContainerInherit = 1;
    ObjectInherit = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.ObjectAceFlags')]
  DNObjectAceFlags = type Integer;
  DNObjectAceFlagsHelper = record helper for DNObjectAceFlags
  public const
    None = 0;
    ObjectAceTypePresent = 1;
    InheritedObjectAceTypePresent = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.PropagationFlags')]
  DNPropagationFlags = type Integer;
  DNPropagationFlagsHelper = record helper for DNPropagationFlags
  public const
    None = 0;
    NoPropagateInherit = 1;
    InheritOnly = 2;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.ResourceType')]
  DNResourceType = type Integer;
  DNResourceTypeHelper = record helper for DNResourceType
  public const
    Unknown = 0;
    FileObject = 1;
    Service = 2;
    Printer = 3;
    RegistryKey = 4;
    LMShare = 5;
    KernelObject = 6;
    WindowObject = 7;
    DSObject = 8;
    DSObjectAll = 9;
    ProviderDefined = 10;
    WmiGuidObject = 11;
    RegistryWow6432Key = 12;
  end;


  //-------------namespace: System.Security.AccessControl----------------
  [DNTypeName('System.Security.AccessControl.SecurityInfos')]
  DNSecurityInfos = type Integer;
  DNSecurityInfosHelper = record helper for DNSecurityInfos
  public const
    Owner = 1;
    Group = 2;
    DiscretionaryAcl = 4;
    SystemAcl = 8;
  end;




type


{ declares }

  DNAuthorizationRuleCollection = interface; // type: System.Security.AccessControl.AuthorizationRuleCollection, namespace: System.Security.AccessControl
  DNPrivilegeNotHeldException = interface; // type: System.Security.AccessControl.PrivilegeNotHeldException, namespace: System.Security.AccessControl
  DNAceEnumerator = interface; // type: System.Security.AccessControl.AceEnumerator, namespace: System.Security.AccessControl
  DNAuthorizationRule = interface; // type: System.Security.AccessControl.AuthorizationRule, namespace: System.Security.AccessControl
  DNAccessRule = interface; // type: System.Security.AccessControl.AccessRule, namespace: System.Security.AccessControl
  DNAccessRule<T> = interface; // type: System.Security.AccessControl.AccessRule`1, namespace: System.Security.AccessControl
  DNObjectAccessRule = interface; // type: System.Security.AccessControl.ObjectAccessRule, namespace: System.Security.AccessControl
  DNAuditRule = interface; // type: System.Security.AccessControl.AuditRule, namespace: System.Security.AccessControl
  DNAuditRule<T> = interface; // type: System.Security.AccessControl.AuditRule`1, namespace: System.Security.AccessControl
  DNObjectAuditRule = interface; // type: System.Security.AccessControl.ObjectAuditRule, namespace: System.Security.AccessControl
  DNGenericAce = interface; // type: System.Security.AccessControl.GenericAce, namespace: System.Security.AccessControl
  DNCustomAce = interface; // type: System.Security.AccessControl.CustomAce, namespace: System.Security.AccessControl
  DNKnownAce = interface; // type: System.Security.AccessControl.KnownAce, namespace: System.Security.AccessControl
  DNCompoundAce = interface; // type: System.Security.AccessControl.CompoundAce, namespace: System.Security.AccessControl
  DNQualifiedAce = interface; // type: System.Security.AccessControl.QualifiedAce, namespace: System.Security.AccessControl
  DNCommonAce = interface; // type: System.Security.AccessControl.CommonAce, namespace: System.Security.AccessControl
  DNObjectAce = interface; // type: System.Security.AccessControl.ObjectAce, namespace: System.Security.AccessControl
  DNGenericAcl = interface; // type: System.Security.AccessControl.GenericAcl, namespace: System.Security.AccessControl
  DNCommonAcl = interface; // type: System.Security.AccessControl.CommonAcl, namespace: System.Security.AccessControl
  DNDiscretionaryAcl = interface; // type: System.Security.AccessControl.DiscretionaryAcl, namespace: System.Security.AccessControl
  DNSystemAcl = interface; // type: System.Security.AccessControl.SystemAcl, namespace: System.Security.AccessControl
  DNRawAcl = interface; // type: System.Security.AccessControl.RawAcl, namespace: System.Security.AccessControl
  DNGenericSecurityDescriptor = interface; // type: System.Security.AccessControl.GenericSecurityDescriptor, namespace: System.Security.AccessControl
  DNCommonSecurityDescriptor = interface; // type: System.Security.AccessControl.CommonSecurityDescriptor, namespace: System.Security.AccessControl
  DNRawSecurityDescriptor = interface; // type: System.Security.AccessControl.RawSecurityDescriptor, namespace: System.Security.AccessControl
  DNObjectSecurity = interface; // type: System.Security.AccessControl.ObjectSecurity, namespace: System.Security.AccessControl
  DNCommonObjectSecurity = interface; // type: System.Security.AccessControl.CommonObjectSecurity, namespace: System.Security.AccessControl
  DNNativeObjectSecurity = interface; // type: System.Security.AccessControl.NativeObjectSecurity, namespace: System.Security.AccessControl
  DNObjectSecurity<T> = interface; // type: System.Security.AccessControl.ObjectSecurity`1, namespace: System.Security.AccessControl


{ objects }

  //-------------namespace: System.Security.AccessControl----------------
  DNAuthorizationRuleCollectionClass = interface(DNObjectClass)
  ['{1AE0BD27-7854-58DD-ADBA-105814525ACD}']
  { constructors } 

    {class} function init: DNAuthorizationRuleCollection;

  end;

  [DNTypeName('System.Security.AccessControl.AuthorizationRuleCollection')]
  DNAuthorizationRuleCollection = interface(DNObject)
  ['{3E766B91-9067-3597-88BC-82E195F9AF25}']
  { getters & setters } 

    function get_Item(index: Int32): DNAuthorizationRule;
    function get_Count: Int32;

  { methods } 

    procedure AddRule(rule: DNAuthorizationRule);
    procedure CopyTo(rules: TArray<DNAuthorizationRule>; index: Int32);
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Item[index: Int32]: DNAuthorizationRule read get_Item; default;
    property Count: Int32 read get_Count;
  end;

  TDNAuthorizationRuleCollection = class(TDNGenericImport<DNAuthorizationRuleCollectionClass, DNAuthorizationRuleCollection>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNPrivilegeNotHeldExceptionClass = interface(DDNC.System.Private.CoreLib.DNUnauthorizedAccessExceptionClass)
  ['{85EFF4CD-800E-5251-A373-44709A075F9D}']
  { constructors } 

    {class} function init: DNPrivilegeNotHeldException; overload;
    {class} function init(privilege: string): DNPrivilegeNotHeldException; overload;
    {class} function init(privilege: string; inner: DDNC.System.Private.CoreLib.DNException): DNPrivilegeNotHeldException; overload;

  end;

  [DNTypeName('System.Security.AccessControl.PrivilegeNotHeldException')]
  DNPrivilegeNotHeldException = interface(DDNC.System.Private.CoreLib.DNUnauthorizedAccessException)
  ['{5750A69C-321D-308E-93FE-225D3AB2EE3D}']
  { getters & setters } 

    function get_PrivilegeName: string;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property PrivilegeName: string read get_PrivilegeName;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNPrivilegeNotHeldException = class(TDNGenericImport<DNPrivilegeNotHeldExceptionClass, DNPrivilegeNotHeldException>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAceEnumeratorClass = interface(DNObjectClass)
  ['{B26C2D98-68FE-57F3-A4DE-AB6BBC0D8F83}']
  end;

  [DNTypeName('System.Security.AccessControl.AceEnumerator')]
  DNAceEnumerator = interface(DDNC.System.Private.CoreLib.DNIEnumerator)
  ['{72998B40-A654-3B7E-851E-FCA872F062B1}']
  { getters & setters } 

    function get_Current: DNGenericAce;

  { methods } 

    function MoveNext: Boolean;
    procedure Reset;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Current: DNGenericAce read get_Current;
  end;

  TDNAceEnumerator = class(TDNGenericImport<DNAceEnumeratorClass, DNAceEnumerator>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAuthorizationRuleClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{C343CC5C-1F93-57DB-8A3F-CAF546BC9E3A}']
  end;

  [DNTypeName('System.Security.AccessControl.AuthorizationRule')]
  DNAuthorizationRule = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{5D31AC7C-967D-39AE-A7E4-6E6E7CAFA086}']
  { getters & setters } 

    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAuthorizationRule = class(TDNGenericImport<DNAuthorizationRuleClass, DNAuthorizationRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAccessRuleClass = interface(DNAuthorizationRuleClass)
  ['{B5441322-3C13-538F-B030-9C2628B61C1D}']
  end;

  [DNTypeName('System.Security.AccessControl.AccessRule')]
  DNAccessRule = interface(DNAuthorizationRule)
  ['{9A37676E-79E1-3139-AB94-A9B6900404D1}']
  { getters & setters } 

    function get_AccessControlType: DNAccessControlType;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AccessControlType: DNAccessControlType read get_AccessControlType;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAccessRule = class(TDNGenericImport<DNAccessRuleClass, DNAccessRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAccessRuleClass<T> = interface(DNAccessRuleClass)
  ['{467E66F6-F847-5CEC-B9AE-9C63F92086AF}']
  { constructors } 

    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: T; &type: DNAccessControlType): DNAccessRule<T>; overload;
    {class} function init(identity: string; rights: T; &type: DNAccessControlType): DNAccessRule<T>; overload;
    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: T; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule<T>; overload;
    {class} function init(identity: string; rights: T; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule<T>; overload;

  end;

  [DNTypeName('System.Security.AccessControl.AccessRule`1')]
  DNAccessRule<T> = interface(DNAccessRule)
  ['{EEE4AD47-242A-3C45-95C7-267A7478F8D6}']
  { getters & setters } 

    function get_Rights: T;
    function get_AccessControlType: DNAccessControlType;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Rights: T read get_Rights;
    property AccessControlType: DNAccessControlType read get_AccessControlType;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAccessRule<T> = class(TDNGenericImport<DNAccessRuleClass<T>, DNAccessRule<T>>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectAccessRuleClass = interface(DNAccessRuleClass)
  ['{03C03E4F-1D36-512A-B2C7-60FC29EBC180}']
  end;

  [DNTypeName('System.Security.AccessControl.ObjectAccessRule')]
  DNObjectAccessRule = interface(DNAccessRule)
  ['{33FE4474-13EE-356B-AE83-FE751E923B06}']
  { getters & setters } 

    function get_ObjectType: DDNC.System.Private.CoreLib.DNGuid;
    function get_InheritedObjectType: DDNC.System.Private.CoreLib.DNGuid;
    function get_ObjectFlags: DNObjectAceFlags;
    function get_AccessControlType: DNAccessControlType;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ObjectType: DDNC.System.Private.CoreLib.DNGuid read get_ObjectType;
    property InheritedObjectType: DDNC.System.Private.CoreLib.DNGuid read get_InheritedObjectType;
    property ObjectFlags: DNObjectAceFlags read get_ObjectFlags;
    property AccessControlType: DNAccessControlType read get_AccessControlType;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNObjectAccessRule = class(TDNGenericImport<DNObjectAccessRuleClass, DNObjectAccessRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAuditRuleClass = interface(DNAuthorizationRuleClass)
  ['{D02168DB-2354-56B9-9BAF-60258B59DB4A}']
  end;

  [DNTypeName('System.Security.AccessControl.AuditRule')]
  DNAuditRule = interface(DNAuthorizationRule)
  ['{4FF50E98-8382-32D8-BD29-3FFBDE105198}']
  { getters & setters } 

    function get_AuditFlags: DNAuditFlags;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAuditRule = class(TDNGenericImport<DNAuditRuleClass, DNAuditRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNAuditRuleClass<T> = interface(DNAuditRuleClass)
  ['{EEB45B74-F0C3-5518-8D00-E9FB97B12392}']
  { constructors } 

    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: T; flags: DNAuditFlags): DNAuditRule<T>; overload;
    {class} function init(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference; rights: T; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule<T>; overload;
    {class} function init(identity: string; rights: T; flags: DNAuditFlags): DNAuditRule<T>; overload;
    {class} function init(identity: string; rights: T; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule<T>; overload;

  end;

  [DNTypeName('System.Security.AccessControl.AuditRule`1')]
  DNAuditRule<T> = interface(DNAuditRule)
  ['{BC9AB087-D34A-3A88-A22A-33DC60D50C00}']
  { getters & setters } 

    function get_Rights: T;
    function get_AuditFlags: DNAuditFlags;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Rights: T read get_Rights;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNAuditRule<T> = class(TDNGenericImport<DNAuditRuleClass<T>, DNAuditRule<T>>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectAuditRuleClass = interface(DNAuditRuleClass)
  ['{C79D8C55-4C7A-5C36-968D-D0DAF4211D45}']
  end;

  [DNTypeName('System.Security.AccessControl.ObjectAuditRule')]
  DNObjectAuditRule = interface(DNAuditRule)
  ['{CA9C0B9D-7122-35E4-A82E-0BE3774A3C35}']
  { getters & setters } 

    function get_ObjectType: DDNC.System.Private.CoreLib.DNGuid;
    function get_InheritedObjectType: DDNC.System.Private.CoreLib.DNGuid;
    function get_ObjectFlags: DNObjectAceFlags;
    function get_AuditFlags: DNAuditFlags;
    function get_IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference;
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ObjectType: DDNC.System.Private.CoreLib.DNGuid read get_ObjectType;
    property InheritedObjectType: DDNC.System.Private.CoreLib.DNGuid read get_InheritedObjectType;
    property ObjectFlags: DNObjectAceFlags read get_ObjectFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property IdentityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference read get_IdentityReference;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
  end;

  TDNObjectAuditRule = class(TDNGenericImport<DNObjectAuditRuleClass, DNObjectAuditRule>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNGenericAceClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{AD1AE360-ACD3-5F07-8FB9-004CDD1EF421}']
  { static methods } 

    {class} function CreateFromBinaryForm(binaryForm: TArray<Byte>; offset: Int32): DNGenericAce;

  end;

  [DNTypeName('System.Security.AccessControl.GenericAce')]
  DNGenericAce = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{5599E8F5-55BE-3728-9DCC-ED0513B61CCC}']
  { getters & setters } 

    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;
    function get_BinaryLength: Int32;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNGenericAce = class(TDNGenericImport<DNGenericAceClass, DNGenericAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCustomAceClass = interface(DNGenericAceClass)
  ['{21C4E539-9AC3-55B3-9FD3-205D68355BEE}']
  { constructors } 

    {class} function init(&type: DNAceType; flags: DNAceFlags; opaque: TArray<Byte>): DNCustomAce;

  { static fields getter & setter } 

   function __fakeFieldGet_MaxOpaqueLength: Int32;

  { static fields } 

    {class} property MaxOpaqueLength: Int32 read __fakeFieldGet_MaxOpaqueLength;

  end;

  [DNTypeName('System.Security.AccessControl.CustomAce')]
  DNCustomAce = interface(DNGenericAce)
  ['{AB482BE2-EDF8-3881-A28B-79836D636D20}']
  { getters & setters } 

    function get_OpaqueLength: Int32;
    function get_BinaryLength: Int32;
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;

  { methods } 

    function GetOpaque: TArray<Byte>;
    procedure SetOpaque(opaque: TArray<Byte>);
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property OpaqueLength: Int32 read get_OpaqueLength;
    property BinaryLength: Int32 read get_BinaryLength;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
  end;

  TDNCustomAce = class(TDNGenericImport<DNCustomAceClass, DNCustomAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNKnownAceClass = interface(DNGenericAceClass)
  ['{3DE2AC8B-75E3-5D22-AFEB-DF29F3B7D84D}']
  end;

  [DNTypeName('System.Security.AccessControl.KnownAce')]
  DNKnownAce = interface(DNGenericAce)
  ['{8E4B8D86-1C52-333D-8280-DDD681F5EB89}']
  { getters & setters } 

    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;
    function get_BinaryLength: Int32;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNKnownAce = class(TDNGenericImport<DNKnownAceClass, DNKnownAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCompoundAceClass = interface(DNKnownAceClass)
  ['{4C502E84-224A-59AD-A197-AFC4A08A8EAA}']
  { constructors } 

    {class} function init(flags: DNAceFlags; accessMask: Int32; compoundAceType: DNCompoundAceType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier): DNCompoundAce;

  end;

  [DNTypeName('System.Security.AccessControl.CompoundAce')]
  DNCompoundAce = interface(DNKnownAce)
  ['{675C61C9-545E-30BD-9D5D-7E6F25261CA6}']
  { getters & setters } 

    function get_CompoundAceType: DNCompoundAceType;
    procedure set_CompoundAceType(value: DNCompoundAceType);
    function get_BinaryLength: Int32;
    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property CompoundAceType: DNCompoundAceType read get_CompoundAceType write set_CompoundAceType;
    property BinaryLength: Int32 read get_BinaryLength;
    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
  end;

  TDNCompoundAce = class(TDNGenericImport<DNCompoundAceClass, DNCompoundAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNQualifiedAceClass = interface(DNKnownAceClass)
  ['{842D9CAA-7C9E-5124-BCBC-387494D177D9}']
  end;

  [DNTypeName('System.Security.AccessControl.QualifiedAce')]
  DNQualifiedAce = interface(DNKnownAce)
  ['{8625A660-7156-3F73-A152-D42AEFA0008B}']
  { getters & setters } 

    function get_AceQualifier: DNAceQualifier;
    function get_IsCallback: Boolean;
    function get_OpaqueLength: Int32;
    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;
    function get_BinaryLength: Int32;

  { methods } 

    function GetOpaque: TArray<Byte>;
    procedure SetOpaque(opaque: TArray<Byte>);
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property AceQualifier: DNAceQualifier read get_AceQualifier;
    property IsCallback: Boolean read get_IsCallback;
    property OpaqueLength: Int32 read get_OpaqueLength;
    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNQualifiedAce = class(TDNGenericImport<DNQualifiedAceClass, DNQualifiedAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCommonAceClass = interface(DNQualifiedAceClass)
  ['{27C7CEA0-7AFC-5958-815D-F07C28F5CC4B}']
  { constructors } 

    {class} function init(flags: DNAceFlags; qualifier: DNAceQualifier; accessMask: Int32; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; isCallback: Boolean; opaque: TArray<Byte>): DNCommonAce;

  { static methods } 

    {class} function MaxOpaqueLength(isCallback: Boolean): Int32;

  end;

  [DNTypeName('System.Security.AccessControl.CommonAce')]
  DNCommonAce = interface(DNQualifiedAce)
  ['{21D415DA-46B2-3EF0-B00F-6EDD3429DF13}']
  { getters & setters } 

    function get_BinaryLength: Int32;
    function get_AceQualifier: DNAceQualifier;
    function get_IsCallback: Boolean;
    function get_OpaqueLength: Int32;
    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetOpaque: TArray<Byte>;
    procedure SetOpaque(opaque: TArray<Byte>);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property BinaryLength: Int32 read get_BinaryLength;
    property AceQualifier: DNAceQualifier read get_AceQualifier;
    property IsCallback: Boolean read get_IsCallback;
    property OpaqueLength: Int32 read get_OpaqueLength;
    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
  end;

  TDNCommonAce = class(TDNGenericImport<DNCommonAceClass, DNCommonAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectAceClass = interface(DNQualifiedAceClass)
  ['{08A6089F-AF61-5948-84C7-AD5E869BA66A}']
  { constructors } 

    {class} function init(aceFlags: DNAceFlags; qualifier: DNAceQualifier; accessMask: Int32; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; flags: DNObjectAceFlags; &type: DDNC.System.Private.CoreLib.DNGuid; inheritedType: DDNC.System.Private.CoreLib.DNGuid; isCallback: Boolean; opaque: TArray<Byte>): DNObjectAce;

  { static methods } 

    {class} function MaxOpaqueLength(isCallback: Boolean): Int32;

  end;

  [DNTypeName('System.Security.AccessControl.ObjectAce')]
  DNObjectAce = interface(DNQualifiedAce)
  ['{EF6802E0-78D6-3CE6-BE49-EA5281191DD7}']
  { getters & setters } 

    function get_ObjectAceFlags: DNObjectAceFlags;
    procedure set_ObjectAceFlags(value: DNObjectAceFlags);
    function get_ObjectAceType: DDNC.System.Private.CoreLib.DNGuid;
    procedure set_ObjectAceType(value: DDNC.System.Private.CoreLib.DNGuid);
    function get_InheritedObjectAceType: DDNC.System.Private.CoreLib.DNGuid;
    procedure set_InheritedObjectAceType(value: DDNC.System.Private.CoreLib.DNGuid);
    function get_BinaryLength: Int32;
    function get_AceQualifier: DNAceQualifier;
    function get_IsCallback: Boolean;
    function get_OpaqueLength: Int32;
    function get_AccessMask: Int32;
    procedure set_AccessMask(value: Int32);
    function get_SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_SecurityIdentifier(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_AceType: DNAceType;
    function get_AceFlags: DNAceFlags;
    procedure set_AceFlags(value: DNAceFlags);
    function get_IsInherited: Boolean;
    function get_InheritanceFlags: DNInheritanceFlags;
    function get_PropagationFlags: DNPropagationFlags;
    function get_AuditFlags: DNAuditFlags;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetOpaque: TArray<Byte>;
    procedure SetOpaque(opaque: TArray<Byte>);
    function Copy: DNGenericAce;
    function Equals(o: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;

  { propertys } 

    property ObjectAceFlags: DNObjectAceFlags read get_ObjectAceFlags write set_ObjectAceFlags;
    property ObjectAceType: DDNC.System.Private.CoreLib.DNGuid read get_ObjectAceType write set_ObjectAceType;
    property InheritedObjectAceType: DDNC.System.Private.CoreLib.DNGuid read get_InheritedObjectAceType write set_InheritedObjectAceType;
    property BinaryLength: Int32 read get_BinaryLength;
    property AceQualifier: DNAceQualifier read get_AceQualifier;
    property IsCallback: Boolean read get_IsCallback;
    property OpaqueLength: Int32 read get_OpaqueLength;
    property AccessMask: Int32 read get_AccessMask write set_AccessMask;
    property SecurityIdentifier: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_SecurityIdentifier write set_SecurityIdentifier;
    property AceType: DNAceType read get_AceType;
    property AceFlags: DNAceFlags read get_AceFlags write set_AceFlags;
    property IsInherited: Boolean read get_IsInherited;
    property InheritanceFlags: DNInheritanceFlags read get_InheritanceFlags;
    property PropagationFlags: DNPropagationFlags read get_PropagationFlags;
    property AuditFlags: DNAuditFlags read get_AuditFlags;
  end;

  TDNObjectAce = class(TDNGenericImport<DNObjectAceClass, DNObjectAce>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNGenericAclClass = interface(DNObjectClass)
  ['{EBD7A422-BE55-54F3-99A5-E060B269DC98}']
  { static fields getter & setter } 

   function __fakeFieldGet_AclRevision: Byte;
   function __fakeFieldGet_AclRevisionDS: Byte;
   function __fakeFieldGet_MaxBinaryLength: Int32;

  { static fields } 

    {class} property AclRevision: Byte read __fakeFieldGet_AclRevision;
    {class} property AclRevisionDS: Byte read __fakeFieldGet_AclRevisionDS;
    {class} property MaxBinaryLength: Int32 read __fakeFieldGet_MaxBinaryLength;

  end;

  [DNTypeName('System.Security.AccessControl.GenericAcl')]
  DNGenericAcl = interface(DDNC.System.Private.CoreLib.DNICollection)
  ['{46BAB8E6-2463-3947-8A8D-3B05763AFB4B}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_BinaryLength: Int32;
    function get_Item(index: Int32): DNGenericAce;
    procedure set_Item(index: Int32; value: DNGenericAce);
    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property BinaryLength: Int32 read get_BinaryLength;
    property Item[index: Int32]: DNGenericAce read get_Item write set_Item; default;
    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNGenericAcl = class(TDNGenericImport<DNGenericAclClass, DNGenericAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCommonAclClass = interface(DNGenericAclClass)
  ['{D232BAA6-0ED4-5408-8A4D-EEFC807CEE21}']
  end;

  [DNTypeName('System.Security.AccessControl.CommonAcl')]
  DNCommonAcl = interface(DNGenericAcl)
  ['{6D3DC108-169A-3A44-82CE-03C7E55C3D07}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_Count: Int32;
    function get_BinaryLength: Int32;
    function get_IsCanonical: Boolean;
    function get_IsContainer: Boolean;
    function get_IsDS: Boolean;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure RemoveInheritedAces;
    procedure Purge(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property Count: Int32 read get_Count;
    property BinaryLength: Int32 read get_BinaryLength;
    property IsCanonical: Boolean read get_IsCanonical;
    property IsContainer: Boolean read get_IsContainer;
    property IsDS: Boolean read get_IsDS;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNCommonAcl = class(TDNGenericImport<DNCommonAclClass, DNCommonAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNDiscretionaryAclClass = interface(DNCommonAclClass)
  ['{7EA13C7F-7459-585D-965C-4F406910B76E}']
  { constructors } 

    {class} function init(isContainer: Boolean; isDS: Boolean; capacity: Int32): DNDiscretionaryAcl; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; revision: Byte; capacity: Int32): DNDiscretionaryAcl; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; rawAcl: DNRawAcl): DNDiscretionaryAcl; overload;

  end;

  [DNTypeName('System.Security.AccessControl.DiscretionaryAcl')]
  DNDiscretionaryAcl = interface(DNCommonAcl)
  ['{EB154D7B-07FC-3F7A-A01B-82DD9F4860FF}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_Count: Int32;
    function get_BinaryLength: Int32;
    function get_IsCanonical: Boolean;
    function get_IsContainer: Boolean;
    function get_IsDS: Boolean;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure AddAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    procedure SetAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    function RemoveAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags): Boolean; overload;
    procedure RemoveAccessSpecific(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    procedure AddAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAccessRule); overload;
    procedure AddAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    procedure SetAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAccessRule); overload;
    procedure SetAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    function RemoveAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAccessRule): Boolean; overload;
    function RemoveAccess(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    procedure RemoveAccessSpecific(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAccessRule); overload;
    procedure RemoveAccessSpecific(accessType: DNAccessControlType; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure RemoveInheritedAces;
    procedure Purge(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property Count: Int32 read get_Count;
    property BinaryLength: Int32 read get_BinaryLength;
    property IsCanonical: Boolean read get_IsCanonical;
    property IsContainer: Boolean read get_IsContainer;
    property IsDS: Boolean read get_IsDS;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNDiscretionaryAcl = class(TDNGenericImport<DNDiscretionaryAclClass, DNDiscretionaryAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNSystemAclClass = interface(DNCommonAclClass)
  ['{C354A86C-1650-519E-8176-B801062D8A35}']
  { constructors } 

    {class} function init(isContainer: Boolean; isDS: Boolean; capacity: Int32): DNSystemAcl; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; revision: Byte; capacity: Int32): DNSystemAcl; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; rawAcl: DNRawAcl): DNSystemAcl; overload;

  end;

  [DNTypeName('System.Security.AccessControl.SystemAcl')]
  DNSystemAcl = interface(DNCommonAcl)
  ['{9DC91504-243A-3CAF-8B23-E4682CDF2000}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_Count: Int32;
    function get_BinaryLength: Int32;
    function get_IsCanonical: Boolean;
    function get_IsContainer: Boolean;
    function get_IsDS: Boolean;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure AddAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    procedure SetAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    function RemoveAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags): Boolean; overload;
    procedure RemoveAuditSpecific(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags); overload;
    procedure AddAudit(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAuditRule); overload;
    procedure AddAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    procedure SetAudit(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAuditRule); overload;
    procedure SetAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    function RemoveAudit(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAuditRule): Boolean; overload;
    function RemoveAudit(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid): Boolean; overload;
    procedure RemoveAuditSpecific(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; rule: DNObjectAuditRule); overload;
    procedure RemoveAuditSpecific(auditFlags: DNAuditFlags; sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; accessMask: Int32; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; objectFlags: DNObjectAceFlags; objectType: DDNC.System.Private.CoreLib.DNGuid; inheritedObjectType: DDNC.System.Private.CoreLib.DNGuid); overload;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure RemoveInheritedAces;
    procedure Purge(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property Count: Int32 read get_Count;
    property BinaryLength: Int32 read get_BinaryLength;
    property IsCanonical: Boolean read get_IsCanonical;
    property IsContainer: Boolean read get_IsContainer;
    property IsDS: Boolean read get_IsDS;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNSystemAcl = class(TDNGenericImport<DNSystemAclClass, DNSystemAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNRawAclClass = interface(DNGenericAclClass)
  ['{A30EB78B-F631-5563-9E03-58814B428AE8}']
  { constructors } 

    {class} function init(revision: Byte; capacity: Int32): DNRawAcl; overload;
    {class} function init(binaryForm: TArray<Byte>; offset: Int32): DNRawAcl; overload;

  end;

  [DNTypeName('System.Security.AccessControl.RawAcl')]
  DNRawAcl = interface(DNGenericAcl)
  ['{5CA43335-02AE-3CC2-8066-BC7836E9281E}']
  { getters & setters } 

    function get_Revision: Byte;
    function get_Count: Int32;
    function get_BinaryLength: Int32;
    function get_Item(index: Int32): DNGenericAce;
    procedure set_Item(index: Int32; value: DNGenericAce);
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    procedure InsertAce(index: Int32; ace: DNGenericAce);
    procedure RemoveAce(index: Int32);
    procedure CopyTo(&array: TArray<DNGenericAce>; index: Int32);
    function GetEnumerator: DNAceEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Revision: Byte read get_Revision;
    property Count: Int32 read get_Count;
    property BinaryLength: Int32 read get_BinaryLength;
    property Item[index: Int32]: DNGenericAce read get_Item write set_Item; default;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNRawAcl = class(TDNGenericImport<DNRawAclClass, DNRawAcl>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNGenericSecurityDescriptorClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{E9839493-B06D-5689-8E6E-CF2AFB957EA3}']
  { static getter & setter } 

    {class} function get_Revision: Byte;

  { static methods } 

    {class} function IsSddlConversionSupported: Boolean;

  { static propertys } 

    {class} property Revision: Byte read get_Revision;
  end;

  [DNTypeName('System.Security.AccessControl.GenericSecurityDescriptor')]
  DNGenericSecurityDescriptor = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{07EE1FCE-49F5-3AAB-B009-981D8195008A}']
  { getters & setters } 

    function get_ControlFlags: DNControlFlags;
    function get_Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Owner(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Group(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_BinaryLength: Int32;

  { methods } 

    function GetSddlForm(includeSections: DNAccessControlSections): string;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ControlFlags: DNControlFlags read get_ControlFlags;
    property Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Owner write set_Owner;
    property Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Group write set_Group;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNGenericSecurityDescriptor = class(TDNGenericImport<DNGenericSecurityDescriptorClass, DNGenericSecurityDescriptor>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCommonSecurityDescriptorClass = interface(DNGenericSecurityDescriptorClass)
  ['{9C6D708C-061E-5D03-9EC1-D5D7D38D719A}']
  { constructors } 

    {class} function init(isContainer: Boolean; isDS: Boolean; flags: DNControlFlags; owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; systemAcl: DNSystemAcl; discretionaryAcl: DNDiscretionaryAcl): DNCommonSecurityDescriptor; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; rawSecurityDescriptor: DNRawSecurityDescriptor): DNCommonSecurityDescriptor; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; sddlForm: string): DNCommonSecurityDescriptor; overload;
    {class} function init(isContainer: Boolean; isDS: Boolean; binaryForm: TArray<Byte>; offset: Int32): DNCommonSecurityDescriptor; overload;

  end;

  [DNTypeName('System.Security.AccessControl.CommonSecurityDescriptor')]
  DNCommonSecurityDescriptor = interface(DNGenericSecurityDescriptor)
  ['{A77764CA-C699-37AE-A65D-F827B7636B49}']
  { getters & setters } 

    function get_IsContainer: Boolean;
    function get_IsDS: Boolean;
    function get_ControlFlags: DNControlFlags;
    function get_Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Owner(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Group(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_SystemAcl: DNSystemAcl;
    procedure set_SystemAcl(value: DNSystemAcl);
    function get_DiscretionaryAcl: DNDiscretionaryAcl;
    procedure set_DiscretionaryAcl(value: DNDiscretionaryAcl);
    function get_IsSystemAclCanonical: Boolean;
    function get_IsDiscretionaryAclCanonical: Boolean;
    function get_BinaryLength: Int32;

  { methods } 

    procedure SetSystemAclProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetDiscretionaryAclProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure PurgeAccessControl(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure PurgeAudit(sid: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    procedure AddDiscretionaryAcl(revision: Byte; trusted: Int32);
    procedure AddSystemAcl(revision: Byte; trusted: Int32);
    function GetSddlForm(includeSections: DNAccessControlSections): string;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsContainer: Boolean read get_IsContainer;
    property IsDS: Boolean read get_IsDS;
    property ControlFlags: DNControlFlags read get_ControlFlags;
    property Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Owner write set_Owner;
    property Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Group write set_Group;
    property SystemAcl: DNSystemAcl read get_SystemAcl write set_SystemAcl;
    property DiscretionaryAcl: DNDiscretionaryAcl read get_DiscretionaryAcl write set_DiscretionaryAcl;
    property IsSystemAclCanonical: Boolean read get_IsSystemAclCanonical;
    property IsDiscretionaryAclCanonical: Boolean read get_IsDiscretionaryAclCanonical;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNCommonSecurityDescriptor = class(TDNGenericImport<DNCommonSecurityDescriptorClass, DNCommonSecurityDescriptor>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNRawSecurityDescriptorClass = interface(DNGenericSecurityDescriptorClass)
  ['{D4AEB67E-355E-562A-B9C9-8764CCC59745}']
  { constructors } 

    {class} function init(flags: DNControlFlags; owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier; systemAcl: DNRawAcl; discretionaryAcl: DNRawAcl): DNRawSecurityDescriptor; overload;
    {class} function init(sddlForm: string): DNRawSecurityDescriptor; overload;
    {class} function init(binaryForm: TArray<Byte>; offset: Int32): DNRawSecurityDescriptor; overload;

  end;

  [DNTypeName('System.Security.AccessControl.RawSecurityDescriptor')]
  DNRawSecurityDescriptor = interface(DNGenericSecurityDescriptor)
  ['{D2BE310A-3E2E-3DBE-9A36-7C1610EEBAFB}']
  { getters & setters } 

    function get_ControlFlags: DNControlFlags;
    function get_Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Owner(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier;
    procedure set_Group(value: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier);
    function get_SystemAcl: DNRawAcl;
    procedure set_SystemAcl(value: DNRawAcl);
    function get_DiscretionaryAcl: DNRawAcl;
    procedure set_DiscretionaryAcl(value: DNRawAcl);
    function get_ResourceManagerControl: Byte;
    procedure set_ResourceManagerControl(value: Byte);
    function get_BinaryLength: Int32;

  { methods } 

    procedure SetFlags(flags: DNControlFlags);
    function GetSddlForm(includeSections: DNAccessControlSections): string;
    procedure GetBinaryForm(binaryForm: TArray<Byte>; offset: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ControlFlags: DNControlFlags read get_ControlFlags;
    property Owner: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Owner write set_Owner;
    property Group: DDNC.System.Security.Principal.Windows.DNSecurityIdentifier read get_Group write set_Group;
    property SystemAcl: DNRawAcl read get_SystemAcl write set_SystemAcl;
    property DiscretionaryAcl: DNRawAcl read get_DiscretionaryAcl write set_DiscretionaryAcl;
    property ResourceManagerControl: Byte read get_ResourceManagerControl write set_ResourceManagerControl;
    property BinaryLength: Int32 read get_BinaryLength;
  end;

  TDNRawSecurityDescriptor = class(TDNGenericImport<DNRawSecurityDescriptorClass, DNRawSecurityDescriptor>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectSecurityClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A8E6A938-8A8B-5E0A-882A-0D267C37D2AD}']
  { static methods } 

    {class} function IsSddlConversionSupported: Boolean;

  end;

  [DNTypeName('System.Security.AccessControl.ObjectSecurity')]
  DNObjectSecurity = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FBF2CB6E-4889-35CA-A2F3-8162839AEFA4}']
  { getters & setters } 

    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;
    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;

  { methods } 

    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DNAccessControlModification; rule: DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DNAccessControlModification; rule: DNAuditRule; out modified: Boolean): Boolean;
    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
  end;

  TDNObjectSecurity = class(TDNGenericImport<DNObjectSecurityClass, DNObjectSecurity>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNCommonObjectSecurityClass = interface(DNObjectSecurityClass)
  ['{707F24AC-29A5-5FD7-8424-5220F74BA80B}']
  end;

  [DNTypeName('System.Security.AccessControl.CommonObjectSecurity')]
  DNCommonObjectSecurity = interface(DNObjectSecurity)
  ['{2219B0D2-2296-3BF7-B629-9C3C812FD6C3}']
  { getters & setters } 

    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;
    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;

  { methods } 

    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DNAccessControlModification; rule: DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DNAccessControlModification; rule: DNAuditRule; out modified: Boolean): Boolean;
    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
  end;

  TDNCommonObjectSecurity = class(TDNGenericImport<DNCommonObjectSecurityClass, DNCommonObjectSecurity>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNNativeObjectSecurityClass = interface(DNCommonObjectSecurityClass)
  ['{9E8B7F2D-23BD-576D-9164-57614DA57142}']
  end;

  [DNTypeName('System.Security.AccessControl.NativeObjectSecurity')]
  DNNativeObjectSecurity = interface(DNCommonObjectSecurity)
  ['{E76A977F-E04C-3A31-BBBE-1665D57A6472}']
  { getters & setters } 

    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;
    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;

  { methods } 

    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DNAccessControlModification; rule: DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DNAccessControlModification; rule: DNAuditRule; out modified: Boolean): Boolean;
    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
  end;

  TDNNativeObjectSecurity = class(TDNGenericImport<DNNativeObjectSecurityClass, DNNativeObjectSecurity>) end;

  //-------------namespace: System.Security.AccessControl----------------
  DNObjectSecurityClass<T> = interface(DNNativeObjectSecurityClass)
  ['{18B68ECB-75BA-5D0F-A702-57287F2FF000}']
  end;

  [DNTypeName('System.Security.AccessControl.ObjectSecurity`1')]
  DNObjectSecurity<T> = interface(DNNativeObjectSecurity)
  ['{8E8E04B5-1063-32C7-90F9-0FF943BDAB8D}']
  { getters & setters } 

    function get_AccessRightType: DDNC.System.Private.CoreLib.DNType;
    function get_AccessRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AuditRuleType: DDNC.System.Private.CoreLib.DNType;
    function get_AreAccessRulesProtected: Boolean;
    function get_AreAuditRulesProtected: Boolean;
    function get_AreAccessRulesCanonical: Boolean;
    function get_AreAuditRulesCanonical: Boolean;

  { methods } 

    function AccessRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; &type: DNAccessControlType): DNAccessRule;
    function AuditRuleFactory(identityReference: DDNC.System.Security.Principal.Windows.DNIdentityReference; accessMask: Int32; isInherited: Boolean; inheritanceFlags: DNInheritanceFlags; propagationFlags: DNPropagationFlags; flags: DNAuditFlags): DNAuditRule;
    procedure AddAccessRule(rule: DNAccessRule<T>);
    procedure SetAccessRule(rule: DNAccessRule<T>);
    procedure ResetAccessRule(rule: DNAccessRule<T>);
    function RemoveAccessRule(rule: DNAccessRule<T>): Boolean;
    procedure RemoveAccessRuleAll(rule: DNAccessRule<T>);
    procedure RemoveAccessRuleSpecific(rule: DNAccessRule<T>);
    procedure AddAuditRule(rule: DNAuditRule<T>);
    procedure SetAuditRule(rule: DNAuditRule<T>);
    function RemoveAuditRule(rule: DNAuditRule<T>): Boolean;
    procedure RemoveAuditRuleAll(rule: DNAuditRule<T>);
    procedure RemoveAuditRuleSpecific(rule: DNAuditRule<T>);
    function GetAccessRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetAuditRules(includeExplicit: Boolean; includeInherited: Boolean; targetType: DDNC.System.Private.CoreLib.DNType): DNAuthorizationRuleCollection;
    function GetOwner(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetOwner(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    function GetGroup(targetType: DDNC.System.Private.CoreLib.DNType): DDNC.System.Security.Principal.Windows.DNIdentityReference;
    procedure SetGroup(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAccessRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure PurgeAuditRules(identity: DDNC.System.Security.Principal.Windows.DNIdentityReference);
    procedure SetAccessRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    procedure SetAuditRuleProtection(isProtected: Boolean; preserveInheritance: Boolean);
    function GetSecurityDescriptorSddlForm(includeSections: DNAccessControlSections): string;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string); overload;
    procedure SetSecurityDescriptorSddlForm(sddlForm: string; includeSections: DNAccessControlSections); overload;
    function GetSecurityDescriptorBinaryForm: TArray<Byte>;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>); overload;
    procedure SetSecurityDescriptorBinaryForm(binaryForm: TArray<Byte>; includeSections: DNAccessControlSections); overload;
    function ModifyAccessRule(modification: DNAccessControlModification; rule: DNAccessRule; out modified: Boolean): Boolean;
    function ModifyAuditRule(modification: DNAccessControlModification; rule: DNAuditRule; out modified: Boolean): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AccessRightType: DDNC.System.Private.CoreLib.DNType read get_AccessRightType;
    property AccessRuleType: DDNC.System.Private.CoreLib.DNType read get_AccessRuleType;
    property AuditRuleType: DDNC.System.Private.CoreLib.DNType read get_AuditRuleType;
    property AreAccessRulesProtected: Boolean read get_AreAccessRulesProtected;
    property AreAuditRulesProtected: Boolean read get_AreAuditRulesProtected;
    property AreAccessRulesCanonical: Boolean read get_AreAccessRulesCanonical;
    property AreAuditRulesCanonical: Boolean read get_AreAuditRulesCanonical;
  end;

  TDNObjectSecurity<T> = class(TDNGenericImport<DNObjectSecurityClass<T>, DNObjectSecurity<T>>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Security.AccessControl, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
