//----------------------------------------------------------------------------
//  System.Private.Uri.dll: System.Private.Uri, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Private.Uri
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Private.Uri;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type

{ enums }

  //-------------namespace: System----------------
  [DNTypeName('System.GenericUriParserOptions')]
  DNGenericUriParserOptions = type Integer;
  DNGenericUriParserOptionsHelper = record helper for DNGenericUriParserOptions
  public const
    Default_ = 0;
    GenericAuthority = 1;
    AllowEmptyAuthority = 2;
    NoUserInfo = 4;
    NoPort = 8;
    NoQuery = 16;
    NoFragment = 32;
    DontConvertPathBackslashes = 64;
    DontCompressPath = 128;
    DontUnescapePathDotsAndSlashes = 256;
    Idn = 512;
    IriParsing = 1024;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriComponents')]
  DNUriComponents = type Integer;
  DNUriComponentsHelper = record helper for DNUriComponents
  public const
    Scheme = 1;
    UserInfo = 2;
    Host = 4;
    Port = 8;
    SchemeAndServer = 13;
    Path = 16;
    Query = 32;
    PathAndQuery = 48;
    HttpRequestUrl = 61;
    Fragment = 64;
    AbsoluteUri = 127;
    StrongPort = 128;
    HostAndPort = 132;
    StrongAuthority = 134;
    NormalizedHost = 256;
    KeepDelimiter = 1073741824;
    SerializationInfoString = -2147483648;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriFormat')]
  DNUriFormat = type Integer;
  DNUriFormatHelper = record helper for DNUriFormat
  public const
    UriEscaped = 1;
    Unescaped = 2;
    SafeUnescaped = 3;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriHostNameType')]
  DNUriHostNameType = type Integer;
  DNUriHostNameTypeHelper = record helper for DNUriHostNameType
  public const
    Unknown = 0;
    Basic = 1;
    Dns = 2;
    IPv4 = 3;
    IPv6 = 4;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriKind')]
  DNUriKind = type Integer;
  DNUriKindHelper = record helper for DNUriKind
  public const
    RelativeOrAbsolute = 0;
    Absolute_ = 1;
    Relative = 2;
  end;


  //-------------namespace: System----------------
  [DNTypeName('System.UriPartial')]
  DNUriPartial = type Integer;
  DNUriPartialHelper = record helper for DNUriPartial
  public const
    Scheme = 0;
    Authority = 1;
    Path = 2;
    Query = 3;
  end;




type


{ declares }

  DNUriFormatException = interface; // type: System.UriFormatException, namespace: System
  DNUri = interface; // type: System.Uri, namespace: System
  DNUriBuilder = interface; // type: System.UriBuilder, namespace: System
  DNUriParser = interface; // type: System.UriParser, namespace: System
  DNFileStyleUriParser = interface; // type: System.FileStyleUriParser, namespace: System
  DNFtpStyleUriParser = interface; // type: System.FtpStyleUriParser, namespace: System
  DNGenericUriParser = interface; // type: System.GenericUriParser, namespace: System
  DNGopherStyleUriParser = interface; // type: System.GopherStyleUriParser, namespace: System
  DNHttpStyleUriParser = interface; // type: System.HttpStyleUriParser, namespace: System
  DNLdapStyleUriParser = interface; // type: System.LdapStyleUriParser, namespace: System
  DNNetPipeStyleUriParser = interface; // type: System.NetPipeStyleUriParser, namespace: System
  DNNetTcpStyleUriParser = interface; // type: System.NetTcpStyleUriParser, namespace: System
  DNNewsStyleUriParser = interface; // type: System.NewsStyleUriParser, namespace: System


{ objects }

  //-------------namespace: System----------------
  DNUriFormatExceptionClass = interface(DDNC.System.Private.CoreLib.DNFormatExceptionClass)
  ['{DB0E8920-F22F-5E31-8387-7E40F235C83B}']
  { constructors } 

    {class} function init: DNUriFormatException; overload;
    {class} function init(textString: string): DNUriFormatException; overload;
    {class} function init(textString: string; e: DDNC.System.Private.CoreLib.DNException): DNUriFormatException; overload;

  end;

  [DNTypeName('System.UriFormatException')]
  DNUriFormatException = interface(DDNC.System.Private.CoreLib.DNFormatException)
  ['{15B770C0-CC0C-3FD2-A928-CE0C257E0B17}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNUriFormatException = class(TDNGenericImport<DNUriFormatExceptionClass, DNUriFormatException>) end;

  //-------------namespace: System----------------
  DNUriClass = interface(DNObjectClass)
  ['{040C18EC-0185-5BE6-A0FC-1F782584A041}']
  { constructors } 

    {class} function init(uriString: string): DNUri; overload;
    {class} function init(uriString: string; dontEscape: Boolean): DNUri; overload;
    {class} function init(baseUri: DNUri; relativeUri: string; dontEscape: Boolean): DNUri; overload;
    {class} function init(uriString: string; uriKind: DNUriKind): DNUri; overload;
    {class} function init(baseUri: DNUri; relativeUri: string): DNUri; overload;
    {class} function init(baseUri: DNUri; relativeUri: DNUri): DNUri; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_UriSchemeFile: string;
   function __fakeFieldGet_UriSchemeFtp: string;
   function __fakeFieldGet_UriSchemeGopher: string;
   function __fakeFieldGet_UriSchemeHttp: string;
   function __fakeFieldGet_UriSchemeHttps: string;
   function __fakeFieldGet_UriSchemeMailto: string;
   function __fakeFieldGet_UriSchemeNews: string;
   function __fakeFieldGet_UriSchemeNntp: string;
   function __fakeFieldGet_UriSchemeNetTcp: string;
   function __fakeFieldGet_UriSchemeNetPipe: string;
   function __fakeFieldGet_SchemeDelimiter: string;

  { static fields } 

    {class} property UriSchemeFile: string read __fakeFieldGet_UriSchemeFile;
    {class} property UriSchemeFtp: string read __fakeFieldGet_UriSchemeFtp;
    {class} property UriSchemeGopher: string read __fakeFieldGet_UriSchemeGopher;
    {class} property UriSchemeHttp: string read __fakeFieldGet_UriSchemeHttp;
    {class} property UriSchemeHttps: string read __fakeFieldGet_UriSchemeHttps;
    {class} property UriSchemeMailto: string read __fakeFieldGet_UriSchemeMailto;
    {class} property UriSchemeNews: string read __fakeFieldGet_UriSchemeNews;
    {class} property UriSchemeNntp: string read __fakeFieldGet_UriSchemeNntp;
    {class} property UriSchemeNetTcp: string read __fakeFieldGet_UriSchemeNetTcp;
    {class} property UriSchemeNetPipe: string read __fakeFieldGet_UriSchemeNetPipe;
    {class} property SchemeDelimiter: string read __fakeFieldGet_SchemeDelimiter;

  { static methods } 

    {class} function TryCreate(uriString: string; uriKind: DNUriKind; out result: DNUri): Boolean; overload;
    {class} function TryCreate(baseUri: DNUri; relativeUri: string; out result: DNUri): Boolean; overload;
    {class} function TryCreate(baseUri: DNUri; relativeUri: DNUri; out result: DNUri): Boolean; overload;
    {class} function Compare(uri1: DNUri; uri2: DNUri; partsToCompare: DNUriComponents; compareFormat: DNUriFormat; comparisonType: DDNC.System.Private.CoreLib.DNStringComparison): Int32;
    {class} function IsWellFormedUriString(uriString: string; uriKind: DNUriKind): Boolean;
    {class} function UnescapeDataString(stringToUnescape: string): string;
    {class} function EscapeUriString(stringToEscape: string): string;
    {class} function EscapeDataString(stringToEscape: string): string;
    {class} function CheckHostName(name: string): DNUriHostNameType;
    {class} function HexEscape(character: Char): string;
    {class} function HexUnescape(pattern: string; out index: Int32): Char;
    {class} function IsHexEncoding(pattern: string; index: Int32): Boolean;
    {class} function CheckSchemeName(schemeName: string): Boolean;
    {class} function IsHexDigit(character: Char): Boolean;
    {class} function FromHex(digit: Char): Int32;

  end;

  [DNTypeName('System.Uri')]
  DNUri = interface(DDNC.System.Private.CoreLib.DNISerializable)
  ['{2F927391-FA90-3B81-AC4E-19D58B43373B}']
  { getters & setters } 

    function get_AbsolutePath: string;
    function get_AbsoluteUri: string;
    function get_LocalPath: string;
    function get_Authority: string;
    function get_HostNameType: DNUriHostNameType;
    function get_IsDefaultPort: Boolean;
    function get_IsFile: Boolean;
    function get_IsLoopback: Boolean;
    function get_PathAndQuery: string;
    function get_Segments: TArray<string>;
    function get_IsUnc: Boolean;
    function get_Host: string;
    function get_Port: Int32;
    function get_Query: string;
    function get_Fragment: string;
    function get_Scheme: string;
    function get_OriginalString: string;
    function get_DnsSafeHost: string;
    function get_IdnHost: string;
    function get_IsAbsoluteUri: Boolean;
    function get_UserEscaped: Boolean;
    function get_UserInfo: string;

  { methods } 

    function MakeRelative(toUri: DNUri): string;
    function GetComponents(components: DNUriComponents; format: DNUriFormat): string;
    function IsWellFormedOriginalString: Boolean;
    function IsBaseOf(uri: DNUri): Boolean;
    function GetLeftPart(part: DNUriPartial): string;
    function GetHashCode: Int32;
    function ToString: string;
    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function MakeRelativeUri(uri: DNUri): DNUri;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AbsolutePath: string read get_AbsolutePath;
    property AbsoluteUri: string read get_AbsoluteUri;
    property LocalPath: string read get_LocalPath;
    property Authority: string read get_Authority;
    property HostNameType: DNUriHostNameType read get_HostNameType;
    property IsDefaultPort: Boolean read get_IsDefaultPort;
    property IsFile: Boolean read get_IsFile;
    property IsLoopback: Boolean read get_IsLoopback;
    property PathAndQuery: string read get_PathAndQuery;
    property Segments: TArray<string> read get_Segments;
    property IsUnc: Boolean read get_IsUnc;
    property Host: string read get_Host;
    property Port: Int32 read get_Port;
    property Query: string read get_Query;
    property Fragment: string read get_Fragment;
    property Scheme: string read get_Scheme;
    property OriginalString: string read get_OriginalString;
    property DnsSafeHost: string read get_DnsSafeHost;
    property IdnHost: string read get_IdnHost;
    property IsAbsoluteUri: Boolean read get_IsAbsoluteUri;
    property UserEscaped: Boolean read get_UserEscaped;
    property UserInfo: string read get_UserInfo;
  end;

  TDNUri = class(TDNGenericImport<DNUriClass, DNUri>) end;

  //-------------namespace: System----------------
  DNUriBuilderClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{9AC3C12A-93CC-5A62-8FEC-421538732FA4}']
  { constructors } 

    {class} function init: DNUriBuilder; overload;
    {class} function init(uri: string): DNUriBuilder; overload;
    {class} function init(uri: DNUri): DNUriBuilder; overload;
    {class} function init(schemeName: string; hostName: string): DNUriBuilder; overload;
    {class} function init(scheme: string; host: string; portNumber: Int32): DNUriBuilder; overload;
    {class} function init(scheme: string; host: string; port: Int32; pathValue: string): DNUriBuilder; overload;
    {class} function init(scheme: string; host: string; port: Int32; path: string; extraValue: string): DNUriBuilder; overload;

  end;

  [DNTypeName('System.UriBuilder')]
  DNUriBuilder = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A004299E-466F-3707-A33A-57689C321CD0}']
  { getters & setters } 

    function get_Fragment: string;
    procedure set_Fragment(value: string);
    function get_Host: string;
    procedure set_Host(value: string);
    function get_Password: string;
    procedure set_Password(value: string);
    function get_Path: string;
    procedure set_Path(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_Query: string;
    procedure set_Query(value: string);
    function get_Scheme: string;
    procedure set_Scheme(value: string);
    function get_Uri: DNUri;
    function get_UserName: string;
    procedure set_UserName(value: string);

  { methods } 

    function Equals(rparam: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Fragment: string read get_Fragment write set_Fragment;
    property Host: string read get_Host write set_Host;
    property Password: string read get_Password write set_Password;
    property Path: string read get_Path write set_Path;
    property Port: Int32 read get_Port write set_Port;
    property Query: string read get_Query write set_Query;
    property Scheme: string read get_Scheme write set_Scheme;
    property Uri: DNUri read get_Uri;
    property UserName: string read get_UserName write set_UserName;
  end;

  TDNUriBuilder = class(TDNGenericImport<DNUriBuilderClass, DNUriBuilder>) end;

  //-------------namespace: System----------------
  DNUriParserClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{38914126-8DD7-571F-A6E8-D781F83523AF}']
  { static methods } 

    {class} procedure &Register(uriParser: DNUriParser; schemeName: string; defaultPort: Int32);
    {class} function IsKnownScheme(schemeName: string): Boolean;

  end;

  [DNTypeName('System.UriParser')]
  DNUriParser = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{BB9DC778-6D0C-3F3A-BF1D-94E28AE7B243}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNUriParser = class(TDNGenericImport<DNUriParserClass, DNUriParser>) end;

  //-------------namespace: System----------------
  DNFileStyleUriParserClass = interface(DNUriParserClass)
  ['{D7121E4D-1B87-5D15-825B-1F24CB214EE0}']
  { constructors } 

    {class} function init: DNFileStyleUriParser;

  end;

  [DNTypeName('System.FileStyleUriParser')]
  DNFileStyleUriParser = interface(DNUriParser)
  ['{655BDF46-8C7D-39A0-86C2-8C266ED8CB04}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNFileStyleUriParser = class(TDNGenericImport<DNFileStyleUriParserClass, DNFileStyleUriParser>) end;

  //-------------namespace: System----------------
  DNFtpStyleUriParserClass = interface(DNUriParserClass)
  ['{0D042306-9649-53C2-9160-1E93C5294B3B}']
  { constructors } 

    {class} function init: DNFtpStyleUriParser;

  end;

  [DNTypeName('System.FtpStyleUriParser')]
  DNFtpStyleUriParser = interface(DNUriParser)
  ['{0E3F165E-E943-3EF7-84C8-5B5AC2644741}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNFtpStyleUriParser = class(TDNGenericImport<DNFtpStyleUriParserClass, DNFtpStyleUriParser>) end;

  //-------------namespace: System----------------
  DNGenericUriParserClass = interface(DNUriParserClass)
  ['{94F8392F-2584-5BFD-9DF9-8AE4185DFA0A}']
  { constructors } 

    {class} function init(options: DNGenericUriParserOptions): DNGenericUriParser;

  end;

  [DNTypeName('System.GenericUriParser')]
  DNGenericUriParser = interface(DNUriParser)
  ['{68930CD0-FC78-320B-B2BC-3EBC7933813B}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNGenericUriParser = class(TDNGenericImport<DNGenericUriParserClass, DNGenericUriParser>) end;

  //-------------namespace: System----------------
  DNGopherStyleUriParserClass = interface(DNUriParserClass)
  ['{81AE6E2B-91F5-5AD2-AAFF-B96B98B7676A}']
  { constructors } 

    {class} function init: DNGopherStyleUriParser;

  end;

  [DNTypeName('System.GopherStyleUriParser')]
  DNGopherStyleUriParser = interface(DNUriParser)
  ['{C155A3C4-F122-396D-99E7-33A3087222D4}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNGopherStyleUriParser = class(TDNGenericImport<DNGopherStyleUriParserClass, DNGopherStyleUriParser>) end;

  //-------------namespace: System----------------
  DNHttpStyleUriParserClass = interface(DNUriParserClass)
  ['{BB508B4D-54C3-5346-8F17-6991D658A58D}']
  { constructors } 

    {class} function init: DNHttpStyleUriParser;

  end;

  [DNTypeName('System.HttpStyleUriParser')]
  DNHttpStyleUriParser = interface(DNUriParser)
  ['{A828F2D5-0A45-383A-BAFD-534E6A6E112B}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpStyleUriParser = class(TDNGenericImport<DNHttpStyleUriParserClass, DNHttpStyleUriParser>) end;

  //-------------namespace: System----------------
  DNLdapStyleUriParserClass = interface(DNUriParserClass)
  ['{4AB7545F-C835-535A-ABD8-46617A15EE3D}']
  { constructors } 

    {class} function init: DNLdapStyleUriParser;

  end;

  [DNTypeName('System.LdapStyleUriParser')]
  DNLdapStyleUriParser = interface(DNUriParser)
  ['{81F3E98C-27F2-3CFE-B169-9BC5B426513B}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNLdapStyleUriParser = class(TDNGenericImport<DNLdapStyleUriParserClass, DNLdapStyleUriParser>) end;

  //-------------namespace: System----------------
  DNNetPipeStyleUriParserClass = interface(DNUriParserClass)
  ['{4E28719B-AC07-540F-94FC-6E2684EBEF09}']
  { constructors } 

    {class} function init: DNNetPipeStyleUriParser;

  end;

  [DNTypeName('System.NetPipeStyleUriParser')]
  DNNetPipeStyleUriParser = interface(DNUriParser)
  ['{EF9F96C1-DA62-3DCB-853A-AB0FD5321E9B}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNNetPipeStyleUriParser = class(TDNGenericImport<DNNetPipeStyleUriParserClass, DNNetPipeStyleUriParser>) end;

  //-------------namespace: System----------------
  DNNetTcpStyleUriParserClass = interface(DNUriParserClass)
  ['{6884AD12-F90F-5241-BEC7-0FA1CAACF7D4}']
  { constructors } 

    {class} function init: DNNetTcpStyleUriParser;

  end;

  [DNTypeName('System.NetTcpStyleUriParser')]
  DNNetTcpStyleUriParser = interface(DNUriParser)
  ['{AA174A5C-9D91-3B8E-80F1-3CD6FA21021C}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNNetTcpStyleUriParser = class(TDNGenericImport<DNNetTcpStyleUriParserClass, DNNetTcpStyleUriParser>) end;

  //-------------namespace: System----------------
  DNNewsStyleUriParserClass = interface(DNUriParserClass)
  ['{B225C3D5-CB55-5F43-9585-E0D680D9E573}']
  { constructors } 

    {class} function init: DNNewsStyleUriParser;

  end;

  [DNTypeName('System.NewsStyleUriParser')]
  DNNewsStyleUriParser = interface(DNUriParser)
  ['{86B9866F-F43D-3125-A2E2-6538D7936E30}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNNewsStyleUriParser = class(TDNGenericImport<DNNewsStyleUriParserClass, DNNewsStyleUriParser>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Private.Uri, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
