//----------------------------------------------------------------------------
//  System.Net.Sockets.dll: System.Net.Sockets, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.Sockets
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.Sockets;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Net.Primitives;

type

{ enums }

  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.IOControlCode')]
  DNIOControlCode = type Integer;
  DNIOControlCodeHelper = record helper for DNIOControlCode
  public const
    EnableCircularQueuing = 671088642;
    Flush = 671088644;
    AddressListChange = 671088663;
    DataToRead = 1074030207;
    OobDataRead = 1074033415;
    GetBroadcastAddress = 1207959557;
    AddressListQuery = 1207959574;
    QueryTargetPnpHandle = 1207959576;
    AsyncIO = 2147772029;
    NonBlockingIO = 2147772030;
    AssociateHandle = 2281701377;
    MultipointLoopback = 2281701385;
    MulticastScope = 2281701386;
    SetQos = 2281701387;
    SetGroupQos = 2281701388;
    RoutingInterfaceChange = 2281701397;
    NamespaceChange = 2281701401;
    ReceiveAll = 2550136833;
    ReceiveAllMulticast = 2550136834;
    ReceiveAllIgmpMulticast = 2550136835;
    KeepAliveValues = 2550136836;
    AbsorbRouterAlert = 2550136837;
    UnicastInterface = 2550136838;
    LimitBroadcasts = 2550136839;
    BindToInterface = 2550136840;
    MulticastInterface = 2550136841;
    AddMulticastGroupOnInterface = 2550136842;
    DeleteMulticastGroupFromInterface = 2550136843;
    GetExtensionFunctionPointer = 3355443206;
    GetQos = 3355443207;
    GetGroupQos = 3355443208;
    TranslateHandle = 3355443213;
    RoutingInterfaceQuery = 3355443220;
    AddressListSort = 3355443225;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.IPProtectionLevel')]
  DNIPProtectionLevel = type Integer;
  DNIPProtectionLevelHelper = record helper for DNIPProtectionLevel
  public const
    Unrestricted = 10;
    EdgeRestricted = 20;
    Restricted = 30;
    Unspecified = -1;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.ProtocolFamily')]
  DNProtocolFamily = type Integer;
  DNProtocolFamilyHelper = record helper for DNProtocolFamily
  public const
    Unspecified = 0;
    Unix = 1;
    InterNetwork = 2;
    ImpLink = 3;
    Pup = 4;
    Chaos = 5;
    NS = 6;
    Ipx = 6;
    Osi = 7;
    Iso = 7;
    Ecma = 8;
    DataKit = 9;
    Ccitt = 10;
    Sna = 11;
    DecNet = 12;
    DataLink = 13;
    Lat = 14;
    HyperChannel = 15;
    AppleTalk = 16;
    NetBios = 17;
    VoiceView = 18;
    FireFox = 19;
    Banyan = 21;
    Atm = 22;
    InterNetworkV6 = 23;
    Cluster = 24;
    Ieee12844 = 25;
    Irda = 26;
    NetworkDesigners = 28;
    Max = 29;
    Packet = 65536;
    ControllerAreaNetwork = 65537;
    Unknown = -1;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.ProtocolType')]
  DNProtocolType = type Integer;
  DNProtocolTypeHelper = record helper for DNProtocolType
  public const
    IPv6HopByHopOptions = 0;
    IP = 0;
    Unspecified = 0;
    Icmp = 1;
    Igmp = 2;
    Ggp = 3;
    IPv4 = 4;
    Tcp = 6;
    Pup = 12;
    Udp = 17;
    Idp = 22;
    IPv6 = 41;
    IPv6RoutingHeader = 43;
    IPv6FragmentHeader = 44;
    IPSecEncapsulatingSecurityPayload = 50;
    IPSecAuthenticationHeader = 51;
    IcmpV6 = 58;
    IPv6NoNextHeader = 59;
    IPv6DestinationOptions = 60;
    ND = 77;
    Raw = 255;
    Ipx = 1000;
    Spx = 1256;
    SpxII = 1257;
    Unknown = -1;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.SelectMode')]
  DNSelectMode = type Integer;
  DNSelectModeHelper = record helper for DNSelectMode
  public const
    SelectRead = 0;
    SelectWrite = 1;
    SelectError = 2;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.SocketAsyncOperation')]
  DNSocketAsyncOperation = type Integer;
  DNSocketAsyncOperationHelper = record helper for DNSocketAsyncOperation
  public const
    None = 0;
    Accept = 1;
    Connect = 2;
    Disconnect = 3;
    Receive = 4;
    ReceiveFrom = 5;
    ReceiveMessageFrom = 6;
    Send = 7;
    SendPackets = 8;
    SendTo = 9;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.SocketFlags')]
  DNSocketFlags = type Integer;
  DNSocketFlagsHelper = record helper for DNSocketFlags
  public const
    None = 0;
    OutOfBand = 1;
    Peek = 2;
    DontRoute = 4;
    Truncated = 256;
    ControlDataTruncated = 512;
    Broadcast = 1024;
    Multicast = 2048;
    Partial = 32768;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.SocketInformationOptions')]
  DNSocketInformationOptions = type Integer;
  DNSocketInformationOptionsHelper = record helper for DNSocketInformationOptions
  public const
    NonBlocking = 1;
    Connected = 2;
    Listening = 4;
    UseOnlyOverlappedIO = 8;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.SocketOptionLevel')]
  DNSocketOptionLevel = type Integer;
  DNSocketOptionLevelHelper = record helper for DNSocketOptionLevel
  public const
    IP = 0;
    Tcp = 6;
    Udp = 17;
    IPv6 = 41;
    Socket = 65535;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.SocketOptionName')]
  DNSocketOptionName = type Integer;
  DNSocketOptionNameHelper = record helper for DNSocketOptionName
  public const
    IPOptions = 1;
    NoChecksum = 1;
    NoDelay = 1;
    Debug = 1;
    HeaderIncluded = 2;
    AcceptConnection = 2;
    Expedited = 2;
    BsdUrgent = 2;
    TypeOfService = 3;
    TcpKeepAliveTime = 3;
    IpTimeToLive = 4;
    ReuseAddress = 4;
    KeepAlive = 8;
    MulticastInterface = 9;
    MulticastTimeToLive = 10;
    MulticastLoopback = 11;
    AddMembership = 12;
    DropMembership = 13;
    DontFragment = 14;
    AddSourceMembership = 15;
    TcpKeepAliveRetryCount = 16;
    DontRoute = 16;
    DropSourceMembership = 16;
    BlockSource = 17;
    TcpKeepAliveInterval = 17;
    UnblockSource = 18;
    PacketInformation = 19;
    ChecksumCoverage = 20;
    HopLimit = 21;
    IPProtectionLevel = 23;
    IPv6Only = 27;
    Broadcast = 32;
    UseLoopback = 64;
    Linger = 128;
    OutOfBandInline = 256;
    SendBuffer = 4097;
    ReceiveBuffer = 4098;
    SendLowWater = 4099;
    ReceiveLowWater = 4100;
    SendTimeout = 4101;
    ReceiveTimeout = 4102;
    Error = 4103;
    Type_ = 4104;
    ReuseUnicastPort = 12295;
    UpdateAcceptContext = 28683;
    UpdateConnectContext = 28688;
    MaxConnections = 2147483647;
    DontLinger = -129;
    ExclusiveAddressUse = -5;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.SocketShutdown')]
  DNSocketShutdown = type Integer;
  DNSocketShutdownHelper = record helper for DNSocketShutdown
  public const
    Receive = 0;
    Send = 1;
    Both = 2;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.SocketType')]
  DNSocketType = type Integer;
  DNSocketTypeHelper = record helper for DNSocketType
  public const
    Stream = 1;
    Dgram = 2;
    Raw = 3;
    Rdm = 4;
    Seqpacket = 5;
    Unknown = -1;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.TransmitFileOptions')]
  DNTransmitFileOptions = type Integer;
  DNTransmitFileOptionsHelper = record helper for DNTransmitFileOptions
  public const
    UseDefaultWorkerThread = 0;
    Disconnect = 1;
    ReuseSocket = 2;
    WriteBehind = 4;
    UseSystemThread = 16;
    UseKernelApc = 32;
  end;




type


{ declares }

  DNSocketAsyncEventArgs = interface; // type: System.Net.Sockets.SocketAsyncEventArgs, namespace: System.Net.Sockets
  DNNetworkStream = interface; // type: System.Net.Sockets.NetworkStream, namespace: System.Net.Sockets
  DNUnixDomainSocketEndPoint = interface; // type: System.Net.Sockets.UnixDomainSocketEndPoint, namespace: System.Net.Sockets
  DNIPv6MulticastOption = interface; // type: System.Net.Sockets.IPv6MulticastOption, namespace: System.Net.Sockets
  DNLingerOption = interface; // type: System.Net.Sockets.LingerOption, namespace: System.Net.Sockets
  DNMulticastOption = interface; // type: System.Net.Sockets.MulticastOption, namespace: System.Net.Sockets
  DNSendPacketsElement = interface; // type: System.Net.Sockets.SendPacketsElement, namespace: System.Net.Sockets
  DNSocket = interface; // type: System.Net.Sockets.Socket, namespace: System.Net.Sockets
  DNSocketTaskExtensions = interface; // type: System.Net.Sockets.SocketTaskExtensions, namespace: System.Net.Sockets
  DNTcpClient = interface; // type: System.Net.Sockets.TcpClient, namespace: System.Net.Sockets
  DNTcpListener = interface; // type: System.Net.Sockets.TcpListener, namespace: System.Net.Sockets
  DNUdpClient = interface; // type: System.Net.Sockets.UdpClient, namespace: System.Net.Sockets
  DNSafeSocketHandle = interface; // type: System.Net.Sockets.SafeSocketHandle, namespace: System.Net.Sockets
  DNIPPacketInformation = interface; // type: System.Net.Sockets.IPPacketInformation, namespace: System.Net.Sockets
  DNSocketInformation = interface; // type: System.Net.Sockets.SocketInformation, namespace: System.Net.Sockets
  DNSocketReceiveFromResult = interface; // type: System.Net.Sockets.SocketReceiveFromResult, namespace: System.Net.Sockets
  DNSocketReceiveMessageFromResult = interface; // type: System.Net.Sockets.SocketReceiveMessageFromResult, namespace: System.Net.Sockets
  DNUdpReceiveResult = interface; // type: System.Net.Sockets.UdpReceiveResult, namespace: System.Net.Sockets


{ objects }

  //-------------namespace: System.Net.Sockets----------------
  DNSocketAsyncEventArgsClass = interface(DDNC.System.Private.CoreLib.DNEventArgsClass)
  ['{BE2164B3-AC18-599A-BAA1-F20D0EC5BF19}']
  { constructors } 

    {class} function init: DNSocketAsyncEventArgs; overload;
    {class} function init(unsafeSuppressExecutionContextFlow: Boolean): DNSocketAsyncEventArgs; overload;

  end;

  [DNTypeName('System.Net.Sockets.SocketAsyncEventArgs')]
  DNSocketAsyncEventArgs = interface(DDNC.System.Private.CoreLib.DNEventArgs)
  ['{074F8AFC-47BC-3466-9F84-4B1DB2886754}']
  { getters & setters } 

    function get_AcceptSocket: DNSocket;
    procedure set_AcceptSocket(value: DNSocket);
    function get_ConnectSocket: DNSocket;
    function get_Buffer: TArray<Byte>;
    function get_MemoryBuffer: DDNC.System.Private.CoreLib.DNMemory<Byte>;
    function get_Offset: Int32;
    function get_Count: Int32;
    function get_SendPacketsFlags: DNTransmitFileOptions;
    procedure set_SendPacketsFlags(value: DNTransmitFileOptions);
    function get_BufferList: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>;
    procedure set_BufferList(value: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>);
    function get_BytesTransferred: Int32;
    function get_DisconnectReuseSocket: Boolean;
    procedure set_DisconnectReuseSocket(value: Boolean);
    function get_LastOperation: DNSocketAsyncOperation;
    function get_ReceiveMessageFromPacketInfo: DNIPPacketInformation;
    function get_RemoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint;
    procedure set_RemoteEndPoint(value: DDNC.System.Net.Primitives.DNEndPoint);
    function get_SendPacketsElements: TArray<DNSendPacketsElement>;
    procedure set_SendPacketsElements(value: TArray<DNSendPacketsElement>);
    function get_SendPacketsSendSize: Int32;
    procedure set_SendPacketsSendSize(value: Int32);
    function get_SocketError: DDNC.System.Net.Primitives.DNSocketError;
    procedure set_SocketError(value: DDNC.System.Net.Primitives.DNSocketError);
    function get_ConnectByNameError: DDNC.System.Private.CoreLib.DNException;
    function get_SocketFlags: DNSocketFlags;
    procedure set_SocketFlags(value: DNSocketFlags);
    function get_UserToken: DDNC.System.Private.CoreLib.DNObject;
    procedure set_UserToken(value: DDNC.System.Private.CoreLib.DNObject);

  { events } 

    procedure add_Completed(value: DDNC.System.Private.CoreLib.DNEventHandler<DNSocketAsyncEventArgs>);
    procedure remove_Completed(value: DDNC.System.Private.CoreLib.DNEventHandler<DNSocketAsyncEventArgs>);

  { methods } 

    procedure SetBuffer(offset: Int32; count: Int32); overload;
    procedure SetBuffer(buffer: TArray<Byte>; offset: Int32; count: Int32); overload;
    procedure SetBuffer(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>); overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AcceptSocket: DNSocket read get_AcceptSocket write set_AcceptSocket;
    property ConnectSocket: DNSocket read get_ConnectSocket;
    property Buffer: TArray<Byte> read get_Buffer;
    property MemoryBuffer: DDNC.System.Private.CoreLib.DNMemory<Byte> read get_MemoryBuffer;
    property Offset: Int32 read get_Offset;
    property Count: Int32 read get_Count;
    property SendPacketsFlags: DNTransmitFileOptions read get_SendPacketsFlags write set_SendPacketsFlags;
    property BufferList: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>> read get_BufferList write set_BufferList;
    property BytesTransferred: Int32 read get_BytesTransferred;
    property DisconnectReuseSocket: Boolean read get_DisconnectReuseSocket write set_DisconnectReuseSocket;
    property LastOperation: DNSocketAsyncOperation read get_LastOperation;
    property ReceiveMessageFromPacketInfo: DNIPPacketInformation read get_ReceiveMessageFromPacketInfo;
    property RemoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint read get_RemoteEndPoint write set_RemoteEndPoint;
    property SendPacketsElements: TArray<DNSendPacketsElement> read get_SendPacketsElements write set_SendPacketsElements;
    property SendPacketsSendSize: Int32 read get_SendPacketsSendSize write set_SendPacketsSendSize;
    property SocketError: DDNC.System.Net.Primitives.DNSocketError read get_SocketError write set_SocketError;
    property ConnectByNameError: DDNC.System.Private.CoreLib.DNException read get_ConnectByNameError;
    property SocketFlags: DNSocketFlags read get_SocketFlags write set_SocketFlags;
    property UserToken: DDNC.System.Private.CoreLib.DNObject read get_UserToken write set_UserToken;
  end;

  TDNSocketAsyncEventArgs = class(TDNGenericImport<DNSocketAsyncEventArgsClass, DNSocketAsyncEventArgs>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNNetworkStreamClass = interface(DDNC.System.Private.CoreLib.DNStreamClass)
  ['{78D7AF47-105D-5DD8-98BC-DB99322F9E98}']
  { constructors } 

    {class} function init(socket: DNSocket): DNNetworkStream; overload;
    {class} function init(socket: DNSocket; ownsSocket: Boolean): DNNetworkStream; overload;
    {class} function init(socket: DNSocket; access: DDNC.System.Private.CoreLib.DNFileAccess): DNNetworkStream; overload;
    {class} function init(socket: DNSocket; access: DDNC.System.Private.CoreLib.DNFileAccess; ownsSocket: Boolean): DNNetworkStream; overload;

  end;

  [DNTypeName('System.Net.Sockets.NetworkStream')]
  DNNetworkStream = interface(DDNC.System.Private.CoreLib.DNStream)
  ['{1B0CCCF5-71BC-39E0-912C-730B44B12949}']
  { getters & setters } 

    function get_Socket: DNSocket;
    function get_CanRead: Boolean;
    function get_CanSeek: Boolean;
    function get_CanWrite: Boolean;
    function get_CanTimeout: Boolean;
    function get_ReadTimeout: Int32;
    procedure set_ReadTimeout(value: Int32);
    function get_WriteTimeout: Int32;
    procedure set_WriteTimeout(value: Int32);
    function get_DataAvailable: Boolean;
    function get_Length: Int64;
    function get_Position: Int64;
    procedure set_Position(value: Int64);

  { methods } 

    function Seek(offset: Int64; origin: DDNC.System.Private.CoreLib.DNSeekOrigin): Int64;
    function Read(buffer: TArray<Byte>; offset: Int32; size: Int32): Int32; overload;
    function Read(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function ReadByte: Int32;
    procedure Write(buffer: TArray<Byte>; offset: Int32; size: Int32); overload;
    procedure Write(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>); overload;
    procedure WriteByte(value: Byte);
    procedure Close(timeout: Int32); overload;
    function BeginRead(buffer: TArray<Byte>; offset: Int32; size: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndRead(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    function BeginWrite(buffer: TArray<Byte>; offset: Int32; size: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure EndWrite(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; size: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReadAsync(buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; size: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function WriteAsync(buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    procedure Flush;
    function FlushAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure SetLength(value: Int64);
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream); overload;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32); overload;
    procedure Close; overload;
    procedure Dispose;
    function DisposeAsync: DDNC.System.Private.CoreLib.DNValueTask;
    function FlushAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function ReadAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function WriteAsync(buffer: TArray<Byte>; offset: Int32; count: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Socket: DNSocket read get_Socket;
    property CanRead: Boolean read get_CanRead;
    property CanSeek: Boolean read get_CanSeek;
    property CanWrite: Boolean read get_CanWrite;
    property CanTimeout: Boolean read get_CanTimeout;
    property ReadTimeout: Int32 read get_ReadTimeout write set_ReadTimeout;
    property WriteTimeout: Int32 read get_WriteTimeout write set_WriteTimeout;
    property DataAvailable: Boolean read get_DataAvailable;
    property Length: Int64 read get_Length;
    property Position: Int64 read get_Position write set_Position;
  end;

  TDNNetworkStream = class(TDNGenericImport<DNNetworkStreamClass, DNNetworkStream>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNUnixDomainSocketEndPointClass = interface(DNObjectClass)
  ['{FC238841-62C7-5741-9C16-CB984C88D3FF}']
  { constructors } 

    {class} function init(path: string): DNUnixDomainSocketEndPoint;

  end;

  [DNTypeName('System.Net.Sockets.UnixDomainSocketEndPoint')]
  DNUnixDomainSocketEndPoint = interface(DNObject)
  ['{8BA341C0-F5DB-3CFA-AD74-78E5F0F975FE}']
  { getters & setters } 

    function get_AddressFamily: DDNC.System.Net.Primitives.DNAddressFamily;

  { methods } 

    function Serialize: DDNC.System.Net.Primitives.DNSocketAddress;
    function Create(socketAddress: DDNC.System.Net.Primitives.DNSocketAddress): DDNC.System.Net.Primitives.DNEndPoint;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AddressFamily: DDNC.System.Net.Primitives.DNAddressFamily read get_AddressFamily;
  end;

  TDNUnixDomainSocketEndPoint = class(TDNGenericImport<DNUnixDomainSocketEndPointClass, DNUnixDomainSocketEndPoint>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNIPv6MulticastOptionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7973DAE6-EEB4-56FE-ABB4-4BC473E69375}']
  { constructors } 

    {class} function init(group: DDNC.System.Net.Primitives.DNIPAddress; ifindex: Int64): DNIPv6MulticastOption; overload;
    {class} function init(group: DDNC.System.Net.Primitives.DNIPAddress): DNIPv6MulticastOption; overload;

  end;

  [DNTypeName('System.Net.Sockets.IPv6MulticastOption')]
  DNIPv6MulticastOption = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7155683E-54FC-3629-A163-3C52A3018961}']
  { getters & setters } 

    function get_Group: DDNC.System.Net.Primitives.DNIPAddress;
    procedure set_Group(value: DDNC.System.Net.Primitives.DNIPAddress);
    function get_InterfaceIndex: Int64;
    procedure set_InterfaceIndex(value: Int64);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Group: DDNC.System.Net.Primitives.DNIPAddress read get_Group write set_Group;
    property InterfaceIndex: Int64 read get_InterfaceIndex write set_InterfaceIndex;
  end;

  TDNIPv6MulticastOption = class(TDNGenericImport<DNIPv6MulticastOptionClass, DNIPv6MulticastOption>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNLingerOptionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{FA32D71C-E668-56E2-8830-E9A174B9B85C}']
  { constructors } 

    {class} function init(enable: Boolean; seconds: Int32): DNLingerOption;

  end;

  [DNTypeName('System.Net.Sockets.LingerOption')]
  DNLingerOption = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{20E3CD45-485E-340E-BC88-3921C2485032}']
  { getters & setters } 

    function get_Enabled: Boolean;
    procedure set_Enabled(value: Boolean);
    function get_LingerTime: Int32;
    procedure set_LingerTime(value: Int32);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Enabled: Boolean read get_Enabled write set_Enabled;
    property LingerTime: Int32 read get_LingerTime write set_LingerTime;
  end;

  TDNLingerOption = class(TDNGenericImport<DNLingerOptionClass, DNLingerOption>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNMulticastOptionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{5A5D372B-25B9-53F7-8E61-EAAD9A6F3501}']
  { constructors } 

    {class} function init(group: DDNC.System.Net.Primitives.DNIPAddress; mcint: DDNC.System.Net.Primitives.DNIPAddress): DNMulticastOption; overload;
    {class} function init(group: DDNC.System.Net.Primitives.DNIPAddress; interfaceIndex: Int32): DNMulticastOption; overload;
    {class} function init(group: DDNC.System.Net.Primitives.DNIPAddress): DNMulticastOption; overload;

  end;

  [DNTypeName('System.Net.Sockets.MulticastOption')]
  DNMulticastOption = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FAF808A5-1210-37BB-AC13-720C0729C9D3}']
  { getters & setters } 

    function get_Group: DDNC.System.Net.Primitives.DNIPAddress;
    procedure set_Group(value: DDNC.System.Net.Primitives.DNIPAddress);
    function get_LocalAddress: DDNC.System.Net.Primitives.DNIPAddress;
    procedure set_LocalAddress(value: DDNC.System.Net.Primitives.DNIPAddress);
    function get_InterfaceIndex: Int32;
    procedure set_InterfaceIndex(value: Int32);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Group: DDNC.System.Net.Primitives.DNIPAddress read get_Group write set_Group;
    property LocalAddress: DDNC.System.Net.Primitives.DNIPAddress read get_LocalAddress write set_LocalAddress;
    property InterfaceIndex: Int32 read get_InterfaceIndex write set_InterfaceIndex;
  end;

  TDNMulticastOption = class(TDNGenericImport<DNMulticastOptionClass, DNMulticastOption>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNSendPacketsElementClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7A200396-6D4D-54AC-845E-8EAB3209FFAC}']
  { constructors } 

    {class} function init(filepath: string): DNSendPacketsElement; overload;
    {class} function init(filepath: string; offset: Int32; count: Int32): DNSendPacketsElement; overload;
    {class} function init(filepath: string; offset: Int32; count: Int32; endOfPacket: Boolean): DNSendPacketsElement; overload;
    {class} function init(filepath: string; offset: Int64; count: Int32): DNSendPacketsElement; overload;
    {class} function init(filepath: string; offset: Int64; count: Int32; endOfPacket: Boolean): DNSendPacketsElement; overload;
    {class} function init(fileStream: DDNC.System.Private.CoreLib.DNFileStream): DNSendPacketsElement; overload;
    {class} function init(fileStream: DDNC.System.Private.CoreLib.DNFileStream; offset: Int64; count: Int32): DNSendPacketsElement; overload;
    {class} function init(fileStream: DDNC.System.Private.CoreLib.DNFileStream; offset: Int64; count: Int32; endOfPacket: Boolean): DNSendPacketsElement; overload;
    {class} function init(buffer: TArray<Byte>): DNSendPacketsElement; overload;
    {class} function init(buffer: TArray<Byte>; offset: Int32; count: Int32): DNSendPacketsElement; overload;
    {class} function init(buffer: TArray<Byte>; offset: Int32; count: Int32; endOfPacket: Boolean): DNSendPacketsElement; overload;

  end;

  [DNTypeName('System.Net.Sockets.SendPacketsElement')]
  DNSendPacketsElement = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B94444C4-F12B-3162-AF36-C557BD679425}']
  { getters & setters } 

    function get_FilePath: string;
    function get_FileStream: DDNC.System.Private.CoreLib.DNFileStream;
    function get_Buffer: TArray<Byte>;
    function get_Count: Int32;
    function get_Offset: Int32;
    function get_OffsetLong: Int64;
    function get_EndOfPacket: Boolean;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FilePath: string read get_FilePath;
    property FileStream: DDNC.System.Private.CoreLib.DNFileStream read get_FileStream;
    property Buffer: TArray<Byte> read get_Buffer;
    property Count: Int32 read get_Count;
    property Offset: Int32 read get_Offset;
    property OffsetLong: Int64 read get_OffsetLong;
    property EndOfPacket: Boolean read get_EndOfPacket;
  end;

  TDNSendPacketsElement = class(TDNGenericImport<DNSendPacketsElementClass, DNSendPacketsElement>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNSocketClass = interface(DNObjectClass)
  ['{607C7F9E-883C-5D45-9F49-8706E2656D04}']
  { static getter & setter } 

    {class} function get_SupportsIPv4: Boolean;
    {class} function get_SupportsIPv6: Boolean;
    {class} function get_OSSupportsIPv4: Boolean;
    {class} function get_OSSupportsIPv6: Boolean;
    {class} function get_OSSupportsUnixDomainSockets: Boolean;

  { constructors } 

    {class} function init(socketInformation: DNSocketInformation): DNSocket; overload;
    {class} function init(socketType: DNSocketType; protocolType: DNProtocolType): DNSocket; overload;
    {class} function init(addressFamily: DDNC.System.Net.Primitives.DNAddressFamily; socketType: DNSocketType; protocolType: DNProtocolType): DNSocket; overload;
    {class} function init(handle: DNSafeSocketHandle): DNSocket; overload;

  { static methods } 

    {class} procedure Select(checkRead: DDNC.System.Private.CoreLib.DNIList; checkWrite: DDNC.System.Private.CoreLib.DNIList; checkError: DDNC.System.Private.CoreLib.DNIList; microSeconds: Int32);
    {class} function ConnectAsync(socketType: DNSocketType; protocolType: DNProtocolType; e: DNSocketAsyncEventArgs): Boolean; overload;
    {class} procedure CancelConnectAsync(e: DNSocketAsyncEventArgs);

  { static propertys } 

    {class} property SupportsIPv4: Boolean read get_SupportsIPv4;
    {class} property SupportsIPv6: Boolean read get_SupportsIPv6;
    {class} property OSSupportsIPv4: Boolean read get_OSSupportsIPv4;
    {class} property OSSupportsIPv6: Boolean read get_OSSupportsIPv6;
    {class} property OSSupportsUnixDomainSockets: Boolean read get_OSSupportsUnixDomainSockets;
  end;

  [DNTypeName('System.Net.Sockets.Socket')]
  DNSocket = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{019A0B3D-0427-3332-B94B-A9AC4C62F36C}']
  { getters & setters } 

    function get_Available: Int32;
    function get_LocalEndPoint: DDNC.System.Net.Primitives.DNEndPoint;
    function get_RemoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint;
    function get_Handle: IntPtr;
    function get_SafeHandle: DNSafeSocketHandle;
    function get_Blocking: Boolean;
    procedure set_Blocking(value: Boolean);
    function get_UseOnlyOverlappedIO: Boolean;
    procedure set_UseOnlyOverlappedIO(value: Boolean);
    function get_Connected: Boolean;
    function get_AddressFamily: DDNC.System.Net.Primitives.DNAddressFamily;
    function get_SocketType: DNSocketType;
    function get_ProtocolType: DNProtocolType;
    function get_IsBound: Boolean;
    function get_ExclusiveAddressUse: Boolean;
    procedure set_ExclusiveAddressUse(value: Boolean);
    function get_ReceiveBufferSize: Int32;
    procedure set_ReceiveBufferSize(value: Int32);
    function get_SendBufferSize: Int32;
    procedure set_SendBufferSize(value: Int32);
    function get_ReceiveTimeout: Int32;
    procedure set_ReceiveTimeout(value: Int32);
    function get_SendTimeout: Int32;
    procedure set_SendTimeout(value: Int32);
    function get_LingerState: DNLingerOption;
    procedure set_LingerState(value: DNLingerOption);
    function get_NoDelay: Boolean;
    procedure set_NoDelay(value: Boolean);
    function get_Ttl: Int16;
    procedure set_Ttl(value: Int16);
    function get_DontFragment: Boolean;
    procedure set_DontFragment(value: Boolean);
    function get_MulticastLoopback: Boolean;
    procedure set_MulticastLoopback(value: Boolean);
    function get_EnableBroadcast: Boolean;
    procedure set_EnableBroadcast(value: Boolean);
    function get_DualMode: Boolean;
    procedure set_DualMode(value: Boolean);

  { methods } 

    procedure Dispose;
    function DuplicateAndClose(targetProcessId: Int32): DNSocketInformation;
    function BeginAccept(receiveSize: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginAccept(acceptSocket: DNSocket; receiveSize: Int32; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function EndAccept(out buffer: TArray<Byte>; asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNSocket; overload;
    function EndAccept(out buffer: TArray<Byte>; out bytesTransferred: Int32; asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNSocket; overload;
    function Receive(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>; socketFlags: DNSocketFlags): Int32; overload;
    function Receive(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError): Int32; overload;
    function Receive(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>): Int32; overload;
    function Receive(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags): Int32; overload;
    function Receive(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError): Int32; overload;
    function ReceiveMessageFrom(buffer: TArray<Byte>; offset: Int32; size: Int32; out socketFlags: DNSocketFlags; out remoteEP: DDNC.System.Net.Primitives.DNEndPoint; out ipPacketInformation: DNIPPacketInformation): Int32;
    function ReceiveFrom(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; out remoteEP: DDNC.System.Net.Primitives.DNEndPoint): Int32; overload;
    function ReceiveFrom(buffer: TArray<Byte>; size: Int32; socketFlags: DNSocketFlags; out remoteEP: DDNC.System.Net.Primitives.DNEndPoint): Int32; overload;
    function ReceiveFrom(buffer: TArray<Byte>; socketFlags: DNSocketFlags; out remoteEP: DDNC.System.Net.Primitives.DNEndPoint): Int32; overload;
    function ReceiveFrom(buffer: TArray<Byte>; out remoteEP: DDNC.System.Net.Primitives.DNEndPoint): Int32; overload;
    function IOControl(ioControlCode: Int32; optionInValue: TArray<Byte>; optionOutValue: TArray<Byte>): Int32; overload;
    function IOControl(ioControlCode: DNIOControlCode; optionInValue: TArray<Byte>; optionOutValue: TArray<Byte>): Int32; overload;
    procedure SetSocketOption(optionLevel: DNSocketOptionLevel; optionName: DNSocketOptionName; optionValue: Int32); overload;
    procedure SetSocketOption(optionLevel: DNSocketOptionLevel; optionName: DNSocketOptionName; optionValue: TArray<Byte>); overload;
    procedure SetSocketOption(optionLevel: DNSocketOptionLevel; optionName: DNSocketOptionName; optionValue: Boolean); overload;
    procedure SetSocketOption(optionLevel: DNSocketOptionLevel; optionName: DNSocketOptionName; optionValue: DDNC.System.Private.CoreLib.DNObject); overload;
    procedure SetRawSocketOption(optionLevel: Int32; optionName: Int32; optionValue: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>);
    function GetSocketOption(optionLevel: DNSocketOptionLevel; optionName: DNSocketOptionName): DDNC.System.Private.CoreLib.DNObject; overload;
    procedure GetSocketOption(optionLevel: DNSocketOptionLevel; optionName: DNSocketOptionName; optionValue: TArray<Byte>); overload;
    function GetSocketOption(optionLevel: DNSocketOptionLevel; optionName: DNSocketOptionName; optionLength: Int32): TArray<Byte>; overload;
    function GetRawSocketOption(optionLevel: Int32; optionName: Int32; optionValue: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32;
    procedure SetIPProtectionLevel(level: DNIPProtectionLevel);
    function Poll(microSeconds: Int32; mode: DNSelectMode): Boolean;
    function BeginConnect(remoteEP: DDNC.System.Net.Primitives.DNEndPoint; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginConnect(host: string; port: Int32; requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginConnect(address: DDNC.System.Net.Primitives.DNIPAddress; port: Int32; requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginConnect(addresses: TArray<DDNC.System.Net.Primitives.DNIPAddress>; port: Int32; requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginDisconnect(reuseSocket: Boolean; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    procedure Disconnect(reuseSocket: Boolean);
    procedure EndConnect(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    procedure EndDisconnect(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function BeginSend(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginSend(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginSend(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginSend(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function EndSend(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32; overload;
    function EndSend(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult; out errorCode: DDNC.System.Net.Primitives.DNSocketError): Int32; overload;
    function BeginSendFile(fileName: string; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginSendFile(fileName: string; preBuffer: TArray<Byte>; postBuffer: TArray<Byte>; flags: DNTransmitFileOptions; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndSendFile(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function BeginSendTo(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; remoteEP: DDNC.System.Net.Primitives.DNEndPoint; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndSendTo(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    function BeginReceive(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginReceive(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginReceive(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginReceive(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function EndReceive(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32; overload;
    function EndReceive(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult; out errorCode: DDNC.System.Net.Primitives.DNSocketError): Int32; overload;
    function BeginReceiveMessageFrom(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; out remoteEP: DDNC.System.Net.Primitives.DNEndPoint; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndReceiveMessageFrom(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult; out socketFlags: DNSocketFlags; out endPoint: DDNC.System.Net.Primitives.DNEndPoint; out ipPacketInformation: DNIPPacketInformation): Int32;
    function BeginReceiveFrom(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; out remoteEP: DDNC.System.Net.Primitives.DNEndPoint; callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndReceiveFrom(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult; out endPoint: DDNC.System.Net.Primitives.DNEndPoint): Int32;
    function BeginAccept(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function EndAccept(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNSocket; overload;
    procedure Shutdown(how: DNSocketShutdown);
    function AcceptAsync(e: DNSocketAsyncEventArgs): Boolean;
    function ConnectAsync(e: DNSocketAsyncEventArgs): Boolean; overload;
    function DisconnectAsync(e: DNSocketAsyncEventArgs): Boolean;
    function ReceiveAsync(e: DNSocketAsyncEventArgs): Boolean;
    function ReceiveFromAsync(e: DNSocketAsyncEventArgs): Boolean;
    function ReceiveMessageFromAsync(e: DNSocketAsyncEventArgs): Boolean;
    function SendAsync(e: DNSocketAsyncEventArgs): Boolean;
    function SendPacketsAsync(e: DNSocketAsyncEventArgs): Boolean;
    function SendToAsync(e: DNSocketAsyncEventArgs): Boolean;
    procedure Bind(localEP: DDNC.System.Net.Primitives.DNEndPoint);
    procedure Connect(remoteEP: DDNC.System.Net.Primitives.DNEndPoint); overload;
    procedure Connect(address: DDNC.System.Net.Primitives.DNIPAddress; port: Int32); overload;
    procedure Connect(host: string; port: Int32); overload;
    procedure Connect(addresses: TArray<DDNC.System.Net.Primitives.DNIPAddress>; port: Int32); overload;
    procedure Close; overload;
    procedure Close(timeout: Int32); overload;
    procedure Listen; overload;
    procedure Listen(backlog: Int32); overload;
    function Accept: DNSocket;
    function Send(buffer: TArray<Byte>; size: Int32; socketFlags: DNSocketFlags): Int32; overload;
    function Send(buffer: TArray<Byte>; socketFlags: DNSocketFlags): Int32; overload;
    function Send(buffer: TArray<Byte>): Int32; overload;
    function Send(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>): Int32; overload;
    function Send(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags): Int32; overload;
    function Send(buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError): Int32; overload;
    function Send(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags): Int32; overload;
    function Send(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError): Int32; overload;
    function Send(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): Int32; overload;
    function Send(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; socketFlags: DNSocketFlags): Int32; overload;
    function Send(buffer: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError): Int32; overload;
    procedure SendFile(fileName: string); overload;
    procedure SendFile(fileName: string; preBuffer: TArray<Byte>; postBuffer: TArray<Byte>; flags: DNTransmitFileOptions); overload;
    function SendTo(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; remoteEP: DDNC.System.Net.Primitives.DNEndPoint): Int32; overload;
    function SendTo(buffer: TArray<Byte>; size: Int32; socketFlags: DNSocketFlags; remoteEP: DDNC.System.Net.Primitives.DNEndPoint): Int32; overload;
    function SendTo(buffer: TArray<Byte>; socketFlags: DNSocketFlags; remoteEP: DDNC.System.Net.Primitives.DNEndPoint): Int32; overload;
    function SendTo(buffer: TArray<Byte>; remoteEP: DDNC.System.Net.Primitives.DNEndPoint): Int32; overload;
    function Receive(buffer: TArray<Byte>; size: Int32; socketFlags: DNSocketFlags): Int32; overload;
    function Receive(buffer: TArray<Byte>; socketFlags: DNSocketFlags): Int32; overload;
    function Receive(buffer: TArray<Byte>): Int32; overload;
    function Receive(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags): Int32; overload;
    function Receive(buffer: TArray<Byte>; offset: Int32; size: Int32; socketFlags: DNSocketFlags; out errorCode: DDNC.System.Net.Primitives.DNSocketError): Int32; overload;
    function Receive(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Available: Int32 read get_Available;
    property LocalEndPoint: DDNC.System.Net.Primitives.DNEndPoint read get_LocalEndPoint;
    property RemoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint read get_RemoteEndPoint;
    property Handle: IntPtr read get_Handle;
    property SafeHandle: DNSafeSocketHandle read get_SafeHandle;
    property Blocking: Boolean read get_Blocking write set_Blocking;
    property UseOnlyOverlappedIO: Boolean read get_UseOnlyOverlappedIO write set_UseOnlyOverlappedIO;
    property Connected: Boolean read get_Connected;
    property AddressFamily: DDNC.System.Net.Primitives.DNAddressFamily read get_AddressFamily;
    property SocketType: DNSocketType read get_SocketType;
    property ProtocolType: DNProtocolType read get_ProtocolType;
    property IsBound: Boolean read get_IsBound;
    property ExclusiveAddressUse: Boolean read get_ExclusiveAddressUse write set_ExclusiveAddressUse;
    property ReceiveBufferSize: Int32 read get_ReceiveBufferSize write set_ReceiveBufferSize;
    property SendBufferSize: Int32 read get_SendBufferSize write set_SendBufferSize;
    property ReceiveTimeout: Int32 read get_ReceiveTimeout write set_ReceiveTimeout;
    property SendTimeout: Int32 read get_SendTimeout write set_SendTimeout;
    property LingerState: DNLingerOption read get_LingerState write set_LingerState;
    property NoDelay: Boolean read get_NoDelay write set_NoDelay;
    property Ttl: Int16 read get_Ttl write set_Ttl;
    property DontFragment: Boolean read get_DontFragment write set_DontFragment;
    property MulticastLoopback: Boolean read get_MulticastLoopback write set_MulticastLoopback;
    property EnableBroadcast: Boolean read get_EnableBroadcast write set_EnableBroadcast;
    property DualMode: Boolean read get_DualMode write set_DualMode;
  end;

  TDNSocket = class(TDNGenericImport<DNSocketClass, DNSocket>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNSocketTaskExtensionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{80DC4BB6-8C44-520D-B628-C4087ACE03DF}']
  { static methods } 

    {class} function AcceptAsync(socket: DNSocket): DDNC.System.Private.CoreLib.DNTask<DNSocket>; overload;
    {class} function AcceptAsync(socket: DNSocket; acceptSocket: DNSocket): DDNC.System.Private.CoreLib.DNTask<DNSocket>; overload;
    {class} function ConnectAsync(socket: DNSocket; remoteEP: DDNC.System.Net.Primitives.DNEndPoint): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function ConnectAsync(socket: DNSocket; remoteEP: DDNC.System.Net.Primitives.DNEndPoint; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    {class} function ConnectAsync(socket: DNSocket; address: DDNC.System.Net.Primitives.DNIPAddress; port: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function ConnectAsync(socket: DNSocket; address: DDNC.System.Net.Primitives.DNIPAddress; port: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    {class} function ConnectAsync(socket: DNSocket; addresses: TArray<DDNC.System.Net.Primitives.DNIPAddress>; port: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function ConnectAsync(socket: DNSocket; addresses: TArray<DDNC.System.Net.Primitives.DNIPAddress>; port: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    {class} function ConnectAsync(socket: DNSocket; host: string; port: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function ConnectAsync(socket: DNSocket; host: string; port: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    {class} function ReceiveAsync(socket: DNSocket; buffer: DDNC.System.Private.CoreLib.DNArraySegment<Byte>; socketFlags: DNSocketFlags): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    {class} function ReceiveAsync(socket: DNSocket; buffer: DDNC.System.Private.CoreLib.DNMemory<Byte>; socketFlags: DNSocketFlags; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    {class} function ReceiveAsync(socket: DNSocket; buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    {class} function ReceiveFromAsync(socket: DNSocket; buffer: DDNC.System.Private.CoreLib.DNArraySegment<Byte>; socketFlags: DNSocketFlags; remoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint): DDNC.System.Private.CoreLib.DNTask<DNSocketReceiveFromResult>;
    {class} function ReceiveMessageFromAsync(socket: DNSocket; buffer: DDNC.System.Private.CoreLib.DNArraySegment<Byte>; socketFlags: DNSocketFlags; remoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint): DDNC.System.Private.CoreLib.DNTask<DNSocketReceiveMessageFromResult>;
    {class} function SendAsync(socket: DNSocket; buffer: DDNC.System.Private.CoreLib.DNArraySegment<Byte>; socketFlags: DNSocketFlags): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    {class} function SendAsync(socket: DNSocket; buffer: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>; socketFlags: DNSocketFlags; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask<Int32>; overload;
    {class} function SendAsync(socket: DNSocket; buffers: DDNC.System.Private.CoreLib.DNIList<DDNC.System.Private.CoreLib.DNArraySegment<Byte>>; socketFlags: DNSocketFlags): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    {class} function SendToAsync(socket: DNSocket; buffer: DDNC.System.Private.CoreLib.DNArraySegment<Byte>; socketFlags: DNSocketFlags; remoteEP: DDNC.System.Net.Primitives.DNEndPoint): DDNC.System.Private.CoreLib.DNTask<Int32>;

  end;

  [DNTypeName('System.Net.Sockets.SocketTaskExtensions')]
  DNSocketTaskExtensions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A7BC5B22-8599-36B6-B2BC-6059E1208B73}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNSocketTaskExtensions = class(TDNGenericImport<DNSocketTaskExtensionsClass, DNSocketTaskExtensions>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNTcpClientClass = interface(DNObjectClass)
  ['{D3EC395D-004D-5E80-8648-B892836BCC56}']
  { constructors } 

    {class} function init: DNTcpClient; overload;
    {class} function init(family: DDNC.System.Net.Primitives.DNAddressFamily): DNTcpClient; overload;
    {class} function init(localEP: DDNC.System.Net.Primitives.DNIPEndPoint): DNTcpClient; overload;
    {class} function init(hostname: string; port: Int32): DNTcpClient; overload;

  end;

  [DNTypeName('System.Net.Sockets.TcpClient')]
  DNTcpClient = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{BE0A6840-92FF-377E-A120-3395F2F966F0}']
  { getters & setters } 

    function get_Available: Int32;
    function get_Client: DNSocket;
    procedure set_Client(value: DNSocket);
    function get_Connected: Boolean;
    function get_ExclusiveAddressUse: Boolean;
    procedure set_ExclusiveAddressUse(value: Boolean);
    function get_ReceiveBufferSize: Int32;
    procedure set_ReceiveBufferSize(value: Int32);
    function get_SendBufferSize: Int32;
    procedure set_SendBufferSize(value: Int32);
    function get_ReceiveTimeout: Int32;
    procedure set_ReceiveTimeout(value: Int32);
    function get_SendTimeout: Int32;
    procedure set_SendTimeout(value: Int32);
    function get_LingerState: DNLingerOption;
    procedure set_LingerState(value: DNLingerOption);
    function get_NoDelay: Boolean;
    procedure set_NoDelay(value: Boolean);

  { methods } 

    procedure Connect(hostname: string; port: Int32); overload;
    procedure Connect(address: DDNC.System.Net.Primitives.DNIPAddress; port: Int32); overload;
    procedure Connect(remoteEP: DDNC.System.Net.Primitives.DNIPEndPoint); overload;
    procedure Connect(ipAddresses: TArray<DDNC.System.Net.Primitives.DNIPAddress>; port: Int32); overload;
    function ConnectAsync(address: DDNC.System.Net.Primitives.DNIPAddress; port: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function ConnectAsync(host: string; port: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function ConnectAsync(addresses: TArray<DDNC.System.Net.Primitives.DNIPAddress>; port: Int32): DDNC.System.Private.CoreLib.DNTask; overload;
    function ConnectAsync(address: DDNC.System.Net.Primitives.DNIPAddress; port: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function ConnectAsync(host: string; port: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function ConnectAsync(addresses: TArray<DDNC.System.Net.Primitives.DNIPAddress>; port: Int32; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNValueTask; overload;
    function BeginConnect(address: DDNC.System.Net.Primitives.DNIPAddress; port: Int32; requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginConnect(host: string; port: Int32; requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginConnect(addresses: TArray<DDNC.System.Net.Primitives.DNIPAddress>; port: Int32; requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    procedure EndConnect(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult);
    function GetStream: DNNetworkStream;
    procedure Close;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Available: Int32 read get_Available;
    property Client: DNSocket read get_Client write set_Client;
    property Connected: Boolean read get_Connected;
    property ExclusiveAddressUse: Boolean read get_ExclusiveAddressUse write set_ExclusiveAddressUse;
    property ReceiveBufferSize: Int32 read get_ReceiveBufferSize write set_ReceiveBufferSize;
    property SendBufferSize: Int32 read get_SendBufferSize write set_SendBufferSize;
    property ReceiveTimeout: Int32 read get_ReceiveTimeout write set_ReceiveTimeout;
    property SendTimeout: Int32 read get_SendTimeout write set_SendTimeout;
    property LingerState: DNLingerOption read get_LingerState write set_LingerState;
    property NoDelay: Boolean read get_NoDelay write set_NoDelay;
  end;

  TDNTcpClient = class(TDNGenericImport<DNTcpClientClass, DNTcpClient>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNTcpListenerClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7BD3C3F2-99D0-5619-88F6-FBAF82463AD2}']
  { constructors } 

    {class} function init(localEP: DDNC.System.Net.Primitives.DNIPEndPoint): DNTcpListener; overload;
    {class} function init(localaddr: DDNC.System.Net.Primitives.DNIPAddress; port: Int32): DNTcpListener; overload;
    {class} function init(port: Int32): DNTcpListener; overload;

  { static methods } 

    {class} function Create(port: Int32): DNTcpListener;

  end;

  [DNTypeName('System.Net.Sockets.TcpListener')]
  DNTcpListener = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{37C20118-ABE7-3584-83A6-6DDDD53AFBA6}']
  { getters & setters } 

    function get_Server: DNSocket;
    function get_LocalEndpoint: DDNC.System.Net.Primitives.DNEndPoint;
    function get_ExclusiveAddressUse: Boolean;
    procedure set_ExclusiveAddressUse(value: Boolean);

  { methods } 

    procedure AllowNatTraversal(allowed: Boolean);
    procedure Start; overload;
    procedure Start(backlog: Int32); overload;
    procedure Stop;
    function Pending: Boolean;
    function AcceptSocket: DNSocket;
    function AcceptTcpClient: DNTcpClient;
    function BeginAcceptSocket(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndAcceptSocket(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNSocket;
    function BeginAcceptTcpClient(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndAcceptTcpClient(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNTcpClient;
    function AcceptSocketAsync: DDNC.System.Private.CoreLib.DNTask<DNSocket>;
    function AcceptTcpClientAsync: DDNC.System.Private.CoreLib.DNTask<DNTcpClient>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Server: DNSocket read get_Server;
    property LocalEndpoint: DDNC.System.Net.Primitives.DNEndPoint read get_LocalEndpoint;
    property ExclusiveAddressUse: Boolean read get_ExclusiveAddressUse write set_ExclusiveAddressUse;
  end;

  TDNTcpListener = class(TDNGenericImport<DNTcpListenerClass, DNTcpListener>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNUdpClientClass = interface(DNObjectClass)
  ['{A5AC81FC-62BF-5F1C-BCF9-D8A6926207F7}']
  { constructors } 

    {class} function init: DNUdpClient; overload;
    {class} function init(family: DDNC.System.Net.Primitives.DNAddressFamily): DNUdpClient; overload;
    {class} function init(port: Int32): DNUdpClient; overload;
    {class} function init(port: Int32; family: DDNC.System.Net.Primitives.DNAddressFamily): DNUdpClient; overload;
    {class} function init(localEP: DDNC.System.Net.Primitives.DNIPEndPoint): DNUdpClient; overload;
    {class} function init(hostname: string; port: Int32): DNUdpClient; overload;

  end;

  [DNTypeName('System.Net.Sockets.UdpClient')]
  DNUdpClient = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{585F7D93-EC6C-3C63-A045-58D19D68A549}']
  { getters & setters } 

    function get_Available: Int32;
    function get_Client: DNSocket;
    procedure set_Client(value: DNSocket);
    function get_Ttl: Int16;
    procedure set_Ttl(value: Int16);
    function get_DontFragment: Boolean;
    procedure set_DontFragment(value: Boolean);
    function get_MulticastLoopback: Boolean;
    procedure set_MulticastLoopback(value: Boolean);
    function get_EnableBroadcast: Boolean;
    procedure set_EnableBroadcast(value: Boolean);
    function get_ExclusiveAddressUse: Boolean;
    procedure set_ExclusiveAddressUse(value: Boolean);

  { methods } 

    procedure AllowNatTraversal(allowed: Boolean);
    procedure Dispose;
    function BeginSend(datagram: TArray<Byte>; bytes: Int32; requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginSend(datagram: TArray<Byte>; bytes: Int32; hostname: string; port: Int32; requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function BeginSend(datagram: TArray<Byte>; bytes: Int32; endPoint: DDNC.System.Net.Primitives.DNIPEndPoint; requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult; overload;
    function EndSend(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): Int32;
    function BeginReceive(requestCallback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndReceive(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult; out remoteEP: DDNC.System.Net.Primitives.DNIPEndPoint): TArray<Byte>;
    procedure JoinMulticastGroup(multicastAddr: DDNC.System.Net.Primitives.DNIPAddress); overload;
    procedure JoinMulticastGroup(multicastAddr: DDNC.System.Net.Primitives.DNIPAddress; localAddress: DDNC.System.Net.Primitives.DNIPAddress); overload;
    procedure JoinMulticastGroup(ifindex: Int32; multicastAddr: DDNC.System.Net.Primitives.DNIPAddress); overload;
    procedure JoinMulticastGroup(multicastAddr: DDNC.System.Net.Primitives.DNIPAddress; timeToLive: Int32); overload;
    procedure DropMulticastGroup(multicastAddr: DDNC.System.Net.Primitives.DNIPAddress); overload;
    procedure DropMulticastGroup(multicastAddr: DDNC.System.Net.Primitives.DNIPAddress; ifindex: Int32); overload;
    function SendAsync(datagram: TArray<Byte>; bytes: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function SendAsync(datagram: TArray<Byte>; bytes: Int32; hostname: string; port: Int32): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function SendAsync(datagram: TArray<Byte>; bytes: Int32; endPoint: DDNC.System.Net.Primitives.DNIPEndPoint): DDNC.System.Private.CoreLib.DNTask<Int32>; overload;
    function ReceiveAsync: DDNC.System.Private.CoreLib.DNTask<DNUdpReceiveResult>;
    procedure Close;
    procedure Connect(hostname: string; port: Int32); overload;
    procedure Connect(addr: DDNC.System.Net.Primitives.DNIPAddress; port: Int32); overload;
    procedure Connect(endPoint: DDNC.System.Net.Primitives.DNIPEndPoint); overload;
    function Receive(out remoteEP: DDNC.System.Net.Primitives.DNIPEndPoint): TArray<Byte>;
    function Send(dgram: TArray<Byte>; bytes: Int32; endPoint: DDNC.System.Net.Primitives.DNIPEndPoint): Int32; overload;
    function Send(dgram: TArray<Byte>; bytes: Int32; hostname: string; port: Int32): Int32; overload;
    function Send(dgram: TArray<Byte>; bytes: Int32): Int32; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Available: Int32 read get_Available;
    property Client: DNSocket read get_Client write set_Client;
    property Ttl: Int16 read get_Ttl write set_Ttl;
    property DontFragment: Boolean read get_DontFragment write set_DontFragment;
    property MulticastLoopback: Boolean read get_MulticastLoopback write set_MulticastLoopback;
    property EnableBroadcast: Boolean read get_EnableBroadcast write set_EnableBroadcast;
    property ExclusiveAddressUse: Boolean read get_ExclusiveAddressUse write set_ExclusiveAddressUse;
  end;

  TDNUdpClient = class(TDNGenericImport<DNUdpClientClass, DNUdpClient>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNSafeSocketHandleClass = interface(DDNC.System.Private.CoreLib.DNSafeHandleMinusOneIsInvalidClass)
  ['{9DD8A8EF-E467-5369-BF5F-2AAE2A50644C}']
  { constructors } 

    {class} function init(preexistingHandle: IntPtr; ownsHandle: Boolean): DNSafeSocketHandle;

  end;

  [DNTypeName('System.Net.Sockets.SafeSocketHandle')]
  DNSafeSocketHandle = interface(DDNC.System.Private.CoreLib.DNSafeHandleMinusOneIsInvalid)
  ['{6CB99A6C-9ACD-3242-8CD9-CB295C4DCCF2}']
  { getters & setters } 

    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNSafeSocketHandle = class(TDNGenericImport<DNSafeSocketHandleClass, DNSafeSocketHandle>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNIPPacketInformationClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{5865F494-0681-5DA1-9F7B-874F7BC85A60}']
  end;

  [DNTypeName('System.Net.Sockets.IPPacketInformation')]
  DNIPPacketInformation = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{94E302DB-FB9F-3077-AD34-20D80217E8EC}']
  { getters & setters } 

    function get_Address: DDNC.System.Net.Primitives.DNIPAddress;
    function get_Interface: Int32;

  { methods } 

    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Address: DDNC.System.Net.Primitives.DNIPAddress read get_Address;
    property &Interface: Int32 read get_Interface;
  end;

  TDNIPPacketInformation = class(TDNGenericImport<DNIPPacketInformationClass, DNIPPacketInformation>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNSocketInformationClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{6A661A74-56D7-5C7E-9F22-6C7A0BAA1960}']
  end;

  [DNTypeName('System.Net.Sockets.SocketInformation')]
  DNSocketInformation = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{08D20669-DD75-37F0-90BB-0F1188C2B835}']
  { getters & setters } 

    function get_ProtocolInformation: TArray<Byte>;
    procedure set_ProtocolInformation(value: TArray<Byte>);
    function get_Options: DNSocketInformationOptions;
    procedure set_Options(value: DNSocketInformationOptions);

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ProtocolInformation: TArray<Byte> read get_ProtocolInformation write set_ProtocolInformation;
    property Options: DNSocketInformationOptions read get_Options write set_Options;
  end;

  TDNSocketInformation = class(TDNGenericImport<DNSocketInformationClass, DNSocketInformation>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNSocketReceiveFromResultClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{61178000-6D3E-597B-B7AB-4EADB30B9CF0}']
  end;

  [DNTypeName('System.Net.Sockets.SocketReceiveFromResult')]
  DNSocketReceiveFromResult = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{53B08059-D216-3133-B687-73D22610D6EA}']
  { fields getter & setter } 

   function __fakeFieldGet_ReceivedBytes: Int32;
   procedure __fakeFieldSet_ReceivedBytes(value: Int32);
   function __fakeFieldGet_RemoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint;
   procedure __fakeFieldSet_RemoteEndPoint(value: DDNC.System.Net.Primitives.DNEndPoint);

  { fields } 

   property ReceivedBytes: Int32 read __fakeFieldGet_ReceivedBytes write __fakeFieldSet_ReceivedBytes;
   property RemoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint read __fakeFieldGet_RemoteEndPoint write __fakeFieldSet_RemoteEndPoint;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNSocketReceiveFromResult = class(TDNGenericImport<DNSocketReceiveFromResultClass, DNSocketReceiveFromResult>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNSocketReceiveMessageFromResultClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{BB171196-26DF-5D19-8779-069710372BCC}']
  end;

  [DNTypeName('System.Net.Sockets.SocketReceiveMessageFromResult')]
  DNSocketReceiveMessageFromResult = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{D3D03BB7-B959-3799-A209-5BD12BE1D16B}']
  { fields getter & setter } 

   function __fakeFieldGet_ReceivedBytes: Int32;
   procedure __fakeFieldSet_ReceivedBytes(value: Int32);
   function __fakeFieldGet_SocketFlags: DNSocketFlags;
   procedure __fakeFieldSet_SocketFlags(value: DNSocketFlags);
   function __fakeFieldGet_RemoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint;
   procedure __fakeFieldSet_RemoteEndPoint(value: DDNC.System.Net.Primitives.DNEndPoint);
   function __fakeFieldGet_PacketInformation: DNIPPacketInformation;
   procedure __fakeFieldSet_PacketInformation(value: DNIPPacketInformation);

  { fields } 

   property ReceivedBytes: Int32 read __fakeFieldGet_ReceivedBytes write __fakeFieldSet_ReceivedBytes;
   property SocketFlags: DNSocketFlags read __fakeFieldGet_SocketFlags write __fakeFieldSet_SocketFlags;
   property RemoteEndPoint: DDNC.System.Net.Primitives.DNEndPoint read __fakeFieldGet_RemoteEndPoint write __fakeFieldSet_RemoteEndPoint;
   property PacketInformation: DNIPPacketInformation read __fakeFieldGet_PacketInformation write __fakeFieldSet_PacketInformation;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNSocketReceiveMessageFromResult = class(TDNGenericImport<DNSocketReceiveMessageFromResultClass, DNSocketReceiveMessageFromResult>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNUdpReceiveResultClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{281FF1B0-7D4F-5288-9022-2BF716EE58B1}']
  { constructors } 

    {class} function init(buffer: TArray<Byte>; remoteEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint): DNUdpReceiveResult;

  end;

  [DNTypeName('System.Net.Sockets.UdpReceiveResult')]
  DNUdpReceiveResult = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{AF7E0876-6107-3C48-A43E-03C7649A8ADF}']
  { getters & setters } 

    function get_Buffer: TArray<Byte>;
    function get_RemoteEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint;

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(other: DNUdpReceiveResult): Boolean; overload;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Buffer: TArray<Byte> read get_Buffer;
    property RemoteEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint read get_RemoteEndPoint;
  end;

  TDNUdpReceiveResult = class(TDNGenericImport<DNUdpReceiveResultClass, DNUdpReceiveResult>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.Sockets, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
