//----------------------------------------------------------------------------
//  System.Net.Primitives.dll: System.Net.Primitives, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.Primitives
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.Primitives;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Private.Uri,
  DDNC.Microsoft.Win32.Primitives;

type

{ enums }

  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.AuthenticationSchemes')]
  DNAuthenticationSchemes = type Integer;
  DNAuthenticationSchemesHelper = record helper for DNAuthenticationSchemes
  public const
    None = 0;
    Digest = 1;
    Negotiate = 2;
    Ntlm = 4;
    IntegratedWindowsAuthentication = 6;
    Basic = 8;
    Anonymous = 32768;
  end;


  //-------------namespace: System.Net.Cache----------------
  [DNTypeName('System.Net.Cache.RequestCacheLevel')]
  DNRequestCacheLevel = type Integer;
  DNRequestCacheLevelHelper = record helper for DNRequestCacheLevel
  public const
    Default_ = 0;
    BypassCache = 1;
    CacheOnly = 2;
    CacheIfAvailable = 3;
    Revalidate = 4;
    Reload = 5;
    NoCacheNoStore = 6;
  end;


  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.CookieVariant')]
  DNCookieVariant = type Integer;
  DNCookieVariantHelper = record helper for DNCookieVariant
  public const
    Unknown = 0;
    Plain = 1;
    Rfc2109 = 2;
    Default_ = 2;
    Rfc2965 = 3;
  end;


  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.DecompressionMethods')]
  DNDecompressionMethods = type Integer;
  DNDecompressionMethodsHelper = record helper for DNDecompressionMethods
  public const
    None = 0;
    GZip = 1;
    Deflate = 2;
    Brotli = 4;
    All = -1;
  end;


  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.HttpStatusCode')]
  DNHttpStatusCode = type Integer;
  DNHttpStatusCodeHelper = record helper for DNHttpStatusCode
  public const
    Continue_ = 100;
    SwitchingProtocols = 101;
    Processing = 102;
    EarlyHints = 103;
    OK = 200;
    Created = 201;
    Accepted = 202;
    NonAuthoritativeInformation = 203;
    NoContent = 204;
    ResetContent = 205;
    PartialContent = 206;
    MultiStatus = 207;
    AlreadyReported = 208;
    IMUsed = 226;
    MultipleChoices = 300;
    Ambiguous = 300;
    MovedPermanently = 301;
    Moved = 301;
    Found = 302;
    Redirect = 302;
    SeeOther = 303;
    RedirectMethod = 303;
    NotModified = 304;
    UseProxy = 305;
    Unused = 306;
    TemporaryRedirect = 307;
    RedirectKeepVerb = 307;
    PermanentRedirect = 308;
    BadRequest = 400;
    Unauthorized = 401;
    PaymentRequired = 402;
    Forbidden = 403;
    NotFound = 404;
    MethodNotAllowed = 405;
    NotAcceptable = 406;
    ProxyAuthenticationRequired = 407;
    RequestTimeout = 408;
    Conflict = 409;
    Gone = 410;
    LengthRequired = 411;
    PreconditionFailed = 412;
    RequestEntityTooLarge = 413;
    RequestUriTooLong = 414;
    UnsupportedMediaType = 415;
    RequestedRangeNotSatisfiable = 416;
    ExpectationFailed = 417;
    MisdirectedRequest = 421;
    UnprocessableEntity = 422;
    Locked = 423;
    FailedDependency = 424;
    UpgradeRequired = 426;
    PreconditionRequired = 428;
    TooManyRequests = 429;
    RequestHeaderFieldsTooLarge = 431;
    UnavailableForLegalReasons = 451;
    InternalServerError = 500;
    NotImplemented = 501;
    BadGateway = 502;
    ServiceUnavailable = 503;
    GatewayTimeout = 504;
    HttpVersionNotSupported = 505;
    VariantAlsoNegotiates = 506;
    InsufficientStorage = 507;
    LoopDetected = 508;
    NotExtended = 510;
    NetworkAuthenticationRequired = 511;
  end;


  //-------------namespace: System.Net.Security----------------
  [DNTypeName('System.Net.Security.AuthenticationLevel')]
  DNAuthenticationLevel = type Integer;
  DNAuthenticationLevelHelper = record helper for DNAuthenticationLevel
  public const
    None = 0;
    MutualAuthRequested = 1;
    MutualAuthRequired = 2;
  end;


  //-------------namespace: System.Net.Security----------------
  [DNTypeName('System.Net.Security.SslPolicyErrors')]
  DNSslPolicyErrors = type Integer;
  DNSslPolicyErrorsHelper = record helper for DNSslPolicyErrors
  public const
    None = 0;
    RemoteCertificateNotAvailable = 1;
    RemoteCertificateNameMismatch = 2;
    RemoteCertificateChainErrors = 4;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.AddressFamily')]
  DNAddressFamily = type Integer;
  DNAddressFamilyHelper = record helper for DNAddressFamily
  public const
    Unspecified = 0;
    Unix = 1;
    InterNetwork = 2;
    ImpLink = 3;
    Pup = 4;
    Chaos = 5;
    NS = 6;
    Ipx = 6;
    Osi = 7;
    Iso = 7;
    Ecma = 8;
    DataKit = 9;
    Ccitt = 10;
    Sna = 11;
    DecNet = 12;
    DataLink = 13;
    Lat = 14;
    HyperChannel = 15;
    AppleTalk = 16;
    NetBios = 17;
    VoiceView = 18;
    FireFox = 19;
    Banyan = 21;
    Atm = 22;
    InterNetworkV6 = 23;
    Cluster = 24;
    Ieee12844 = 25;
    Irda = 26;
    NetworkDesigners = 28;
    Max = 29;
    Packet = 65536;
    ControllerAreaNetwork = 65537;
    Unknown = -1;
  end;


  //-------------namespace: System.Net.Sockets----------------
  [DNTypeName('System.Net.Sockets.SocketError')]
  DNSocketError = type Integer;
  DNSocketErrorHelper = record helper for DNSocketError
  public const
    Success = 0;
    OperationAborted = 995;
    IOPending = 997;
    Interrupted = 10004;
    AccessDenied = 10013;
    Fault = 10014;
    InvalidArgument = 10022;
    TooManyOpenSockets = 10024;
    WouldBlock = 10035;
    InProgress = 10036;
    AlreadyInProgress = 10037;
    NotSocket = 10038;
    DestinationAddressRequired = 10039;
    MessageSize = 10040;
    ProtocolType = 10041;
    ProtocolOption = 10042;
    ProtocolNotSupported = 10043;
    SocketNotSupported = 10044;
    OperationNotSupported = 10045;
    ProtocolFamilyNotSupported = 10046;
    AddressFamilyNotSupported = 10047;
    AddressAlreadyInUse = 10048;
    AddressNotAvailable = 10049;
    NetworkDown = 10050;
    NetworkUnreachable = 10051;
    NetworkReset = 10052;
    ConnectionAborted = 10053;
    ConnectionReset = 10054;
    NoBufferSpaceAvailable = 10055;
    IsConnected = 10056;
    NotConnected = 10057;
    Shutdown = 10058;
    TimedOut = 10060;
    ConnectionRefused = 10061;
    HostDown = 10064;
    HostUnreachable = 10065;
    ProcessLimit = 10067;
    SystemNotReady = 10091;
    VersionNotSupported = 10092;
    NotInitialized = 10093;
    Disconnecting = 10101;
    TypeNotFound = 10109;
    HostNotFound = 11001;
    TryAgain = 11002;
    NoRecovery = 11003;
    NoData = 11004;
    SocketError = -1;
  end;


  //-------------namespace: System.Security.Authentication----------------
  [DNTypeName('System.Security.Authentication.CipherAlgorithmType')]
  DNCipherAlgorithmType = type Integer;
  DNCipherAlgorithmTypeHelper = record helper for DNCipherAlgorithmType
  public const
    None = 0;
    Null = 24576;
    Des = 26113;
    Rc2 = 26114;
    TripleDes = 26115;
    Aes128 = 26126;
    Aes192 = 26127;
    Aes256 = 26128;
    Aes = 26129;
    Rc4 = 26625;
  end;


  //-------------namespace: System.Security.Authentication----------------
  [DNTypeName('System.Security.Authentication.ExchangeAlgorithmType')]
  DNExchangeAlgorithmType = type Integer;
  DNExchangeAlgorithmTypeHelper = record helper for DNExchangeAlgorithmType
  public const
    None = 0;
    RsaSign = 9216;
    RsaKeyX = 41984;
    DiffieHellman = 43522;
  end;


  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  [DNTypeName('System.Security.Authentication.ExtendedProtection.ChannelBindingKind')]
  DNChannelBindingKind = type Integer;
  DNChannelBindingKindHelper = record helper for DNChannelBindingKind
  public const
    Unknown = 0;
    Unique = 25;
    Endpoint = 26;
  end;


  //-------------namespace: System.Security.Authentication----------------
  [DNTypeName('System.Security.Authentication.HashAlgorithmType')]
  DNHashAlgorithmType = type Integer;
  DNHashAlgorithmTypeHelper = record helper for DNHashAlgorithmType
  public const
    None = 0;
    Md5 = 32771;
    Sha1 = 32772;
    Sha256 = 32780;
    Sha384 = 32781;
    Sha512 = 32782;
  end;


  //-------------namespace: System.Security.Authentication----------------
  [DNTypeName('System.Security.Authentication.SslProtocols')]
  DNSslProtocols = type Integer;
  DNSslProtocolsHelper = record helper for DNSslProtocols
  public const
    None = 0;
    Ssl2 = 12;
    Ssl3 = 48;
    Tls = 192;
    Default_ = 240;
    Tls11 = 768;
    Tls12 = 3072;
    Tls13 = 12288;
  end;




type


{ declares }

  DNICredentials = interface; // type: System.Net.ICredentials, namespace: System.Net
  DNICredentialsByHost = interface; // type: System.Net.ICredentialsByHost, namespace: System.Net
  DNIWebProxy = interface; // type: System.Net.IWebProxy, namespace: System.Net
  DNCookieException = interface; // type: System.Net.CookieException, namespace: System.Net
  DNSocketException = interface; // type: System.Net.Sockets.SocketException, namespace: System.Net.Sockets
  DNRequestCachePolicy = interface; // type: System.Net.Cache.RequestCachePolicy, namespace: System.Net.Cache
  DNCookie = interface; // type: System.Net.Cookie, namespace: System.Net
  DNCookieCollection = interface; // type: System.Net.CookieCollection, namespace: System.Net
  DNCookieContainer = interface; // type: System.Net.CookieContainer, namespace: System.Net
  DNCredentialCache = interface; // type: System.Net.CredentialCache, namespace: System.Net
  DNEndPoint = interface; // type: System.Net.EndPoint, namespace: System.Net
  DNDnsEndPoint = interface; // type: System.Net.DnsEndPoint, namespace: System.Net
  DNIPEndPoint = interface; // type: System.Net.IPEndPoint, namespace: System.Net
  DNHttpVersion = interface; // type: System.Net.HttpVersion, namespace: System.Net
  DNIPAddress = interface; // type: System.Net.IPAddress, namespace: System.Net
  DNNetworkCredential = interface; // type: System.Net.NetworkCredential, namespace: System.Net
  DNIPAddressCollection = interface; // type: System.Net.NetworkInformation.IPAddressCollection, namespace: System.Net.NetworkInformation
  DNPathList = interface; // type: System.Net.PathList, namespace: System.Net
  DNSocketAddress = interface; // type: System.Net.SocketAddress, namespace: System.Net
  DNTransportContext = interface; // type: System.Net.TransportContext, namespace: System.Net
  DNChannelBinding = interface; // type: System.Security.Authentication.ExtendedProtection.ChannelBinding, namespace: System.Security.Authentication.ExtendedProtection


{ objects }

  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.ICredentials')]
  DNICredentials = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{AA928FDF-0CBF-3845-8ECB-08339B2DC61D}']
  { methods } 

    function GetCredential(uri: DDNC.System.Private.Uri.DNUri; authType: string): DNNetworkCredential;

  end;

  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.ICredentialsByHost')]
  DNICredentialsByHost = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{864BFF99-3AF0-38DA-B9FC-5E0DDF74E952}']
  { methods } 

    function GetCredential(host: string; port: Int32; authenticationType: string): DNNetworkCredential;

  end;

  //-------------namespace: System.Net----------------
  [DNTypeName('System.Net.IWebProxy')]
  DNIWebProxy = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{26EE9E09-527D-3AB2-B8F2-6C0425580210}']
  { getters & setters } 

    function get_Credentials: DNICredentials;
    procedure set_Credentials(value: DNICredentials);

  { methods } 

    function GetProxy(destination: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.Uri.DNUri;
    function IsBypassed(host: DDNC.System.Private.Uri.DNUri): Boolean;

  { propertys } 

    property Credentials: DNICredentials read get_Credentials write set_Credentials;
  end;

  //-------------namespace: System.Net----------------
  DNCookieExceptionClass = interface(DDNC.System.Private.CoreLib.DNFormatExceptionClass)
  ['{0FA9F7D0-4C5B-55EE-AFFE-47264CFBCCB5}']
  { constructors } 

    {class} function init: DNCookieException;

  end;

  [DNTypeName('System.Net.CookieException')]
  DNCookieException = interface(DDNC.System.Private.CoreLib.DNFormatException)
  ['{DAA9F1A1-E039-3D4D-8499-8209EF2543BF}']
  { getters & setters } 

    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(serializationInfo: DDNC.System.Private.CoreLib.DNSerializationInfo; streamingContext: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNCookieException = class(TDNGenericImport<DNCookieExceptionClass, DNCookieException>) end;

  //-------------namespace: System.Net.Sockets----------------
  DNSocketExceptionClass = interface(DNObjectClass)
  ['{A7839514-5ECE-594A-8D8A-58F940869362}']
  { constructors } 

    {class} function init(errorCode: Int32): DNSocketException; overload;
    {class} function init: DNSocketException; overload;

  end;

  [DNTypeName('System.Net.Sockets.SocketException')]
  DNSocketException = interface(DNObject)
  ['{3025D4A8-19DB-3B45-88EE-B5C939BA485F}']
  { getters & setters } 

    function get_Message: string;
    function get_SocketErrorCode: DNSocketError;
    function get_ErrorCode: Int32;
    function get_NativeErrorCode: Int32;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property SocketErrorCode: DNSocketError read get_SocketErrorCode;
    property ErrorCode: Int32 read get_ErrorCode;
    property NativeErrorCode: Int32 read get_NativeErrorCode;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNSocketException = class(TDNGenericImport<DNSocketExceptionClass, DNSocketException>) end;

  //-------------namespace: System.Net.Cache----------------
  DNRequestCachePolicyClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{47847179-95FC-557E-82E6-F01CBB461EA1}']
  { constructors } 

    {class} function init: DNRequestCachePolicy; overload;
    {class} function init(level: DNRequestCacheLevel): DNRequestCachePolicy; overload;

  end;

  [DNTypeName('System.Net.Cache.RequestCachePolicy')]
  DNRequestCachePolicy = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{77AFCE4C-B978-3279-89A3-CBDED0B5A89B}']
  { getters & setters } 

    function get_Level: DNRequestCacheLevel;

  { methods } 

    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Level: DNRequestCacheLevel read get_Level;
  end;

  TDNRequestCachePolicy = class(TDNGenericImport<DNRequestCachePolicyClass, DNRequestCachePolicy>) end;

  //-------------namespace: System.Net----------------
  DNCookieClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{2B5208E0-7D57-571A-A9D4-DA328F893F40}']
  { constructors } 

    {class} function init: DNCookie; overload;
    {class} function init(name: string; value: string): DNCookie; overload;
    {class} function init(name: string; value: string; path: string): DNCookie; overload;
    {class} function init(name: string; value: string; path: string; domain: string): DNCookie; overload;

  end;

  [DNTypeName('System.Net.Cookie')]
  DNCookie = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B3C985BC-F4E3-3A25-BBD7-F330486AD447}']
  { getters & setters } 

    function get_Comment: string;
    procedure set_Comment(value: string);
    function get_CommentUri: DDNC.System.Private.Uri.DNUri;
    procedure set_CommentUri(value: DDNC.System.Private.Uri.DNUri);
    function get_HttpOnly: Boolean;
    procedure set_HttpOnly(value: Boolean);
    function get_Discard: Boolean;
    procedure set_Discard(value: Boolean);
    function get_Domain: string;
    procedure set_Domain(value: string);
    function get_Expired: Boolean;
    procedure set_Expired(value: Boolean);
    function get_Expires: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_Expires(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Path: string;
    procedure set_Path(value: string);
    function get_Port: string;
    procedure set_Port(value: string);
    function get_Secure: Boolean;
    procedure set_Secure(value: Boolean);
    function get_TimeStamp: DDNC.System.Private.CoreLib.DNDateTime;
    function get_Value: string;
    procedure set_Value(value: string);
    function get_Version: Int32;
    procedure set_Version(value: Int32);

  { methods } 

    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Comment: string read get_Comment write set_Comment;
    property CommentUri: DDNC.System.Private.Uri.DNUri read get_CommentUri write set_CommentUri;
    property HttpOnly: Boolean read get_HttpOnly write set_HttpOnly;
    property Discard: Boolean read get_Discard write set_Discard;
    property Domain: string read get_Domain write set_Domain;
    property Expired: Boolean read get_Expired write set_Expired;
    property Expires: DDNC.System.Private.CoreLib.DNDateTime read get_Expires write set_Expires;
    property Name: string read get_Name write set_Name;
    property Path: string read get_Path write set_Path;
    property Port: string read get_Port write set_Port;
    property Secure: Boolean read get_Secure write set_Secure;
    property TimeStamp: DDNC.System.Private.CoreLib.DNDateTime read get_TimeStamp;
    property Value: string read get_Value write set_Value;
    property Version: Int32 read get_Version write set_Version;
  end;

  TDNCookie = class(TDNGenericImport<DNCookieClass, DNCookie>) end;

  //-------------namespace: System.Net----------------
  DNCookieCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A342EB33-EF44-51E1-9E8C-32947519BD02}']
  { constructors } 

    {class} function init: DNCookieCollection;

  end;

  [DNTypeName('System.Net.CookieCollection')]
  DNCookieCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{AFC58599-DEC7-3146-86B9-F9742EA6C859}']
  { getters & setters } 

    function get_Item(index: Int32): DNCookie; overload;
    function get_Item(name: string): DNCookie; overload;
    function get_IsReadOnly: Boolean;
    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    procedure Add(cookies: DNCookieCollection);
    function &Contains(cookie: DNCookie): Boolean;
    procedure CopyTo(&array: DDNC.System.Private.CoreLib.DNArray; index: Int32); overload;
    procedure CopyTo(&array: TArray<DNCookie>; index: Int32); overload;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Item[index: Int32]: DNCookie read get_Item; default;
    property Item[name: string]: DNCookie read get_Item; default;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Count: Int32 read get_Count;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property SyncRoot: DDNC.System.Private.CoreLib.DNObject read get_SyncRoot;
  end;

  TDNCookieCollection = class(TDNGenericImport<DNCookieCollectionClass, DNCookieCollection>) end;

  //-------------namespace: System.Net----------------
  DNCookieContainerClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{40792E84-A881-5BDB-873D-BC1C8EB308C7}']
  { constructors } 

    {class} function init: DNCookieContainer; overload;
    {class} function init(capacity: Int32): DNCookieContainer; overload;
    {class} function init(capacity: Int32; perDomainCapacity: Int32; maxCookieSize: Int32): DNCookieContainer; overload;

  end;

  [DNTypeName('System.Net.CookieContainer')]
  DNCookieContainer = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{D8DFC4D5-EB5C-35CB-99FD-504AB751F52E}']
  { getters & setters } 

    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;
    function get_MaxCookieSize: Int32;
    procedure set_MaxCookieSize(value: Int32);
    function get_PerDomainCapacity: Int32;
    procedure set_PerDomainCapacity(value: Int32);

  { methods } 

    procedure Add(cookie: DNCookie); overload;
    procedure Add(cookies: DNCookieCollection); overload;
    procedure Add(uri: DDNC.System.Private.Uri.DNUri; cookie: DNCookie); overload;
    procedure Add(uri: DDNC.System.Private.Uri.DNUri; cookies: DNCookieCollection); overload;
    function GetCookies(uri: DDNC.System.Private.Uri.DNUri): DNCookieCollection;
    function GetCookieHeader(uri: DDNC.System.Private.Uri.DNUri): string;
    procedure SetCookies(uri: DDNC.System.Private.Uri.DNUri; cookieHeader: string);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
    property MaxCookieSize: Int32 read get_MaxCookieSize write set_MaxCookieSize;
    property PerDomainCapacity: Int32 read get_PerDomainCapacity write set_PerDomainCapacity;
  end;

  TDNCookieContainer = class(TDNGenericImport<DNCookieContainerClass, DNCookieContainer>)
  public const
   DefaultCookieLimit = 300;
   DefaultPerDomainCookieLimit = 20;
   DefaultCookieLengthLimit = 4096;
  end;

  //-------------namespace: System.Net----------------
  DNCredentialCacheClass = interface(DNObjectClass)
  ['{B969B268-BE0E-56E8-985B-3C8A22A5273A}']
  { static getter & setter } 

    {class} function get_DefaultCredentials: DNICredentials;
    {class} function get_DefaultNetworkCredentials: DNNetworkCredential;

  { constructors } 

    {class} function init: DNCredentialCache;

  { static propertys } 

    {class} property DefaultCredentials: DNICredentials read get_DefaultCredentials;
    {class} property DefaultNetworkCredentials: DNNetworkCredential read get_DefaultNetworkCredentials;
  end;

  [DNTypeName('System.Net.CredentialCache')]
  DNCredentialCache = interface(DNICredentials)
  ['{B8020739-3D39-38CF-9173-1A8B3E080034}']
  { methods } 

    procedure Add(uriPrefix: DDNC.System.Private.Uri.DNUri; authType: string; cred: DNNetworkCredential); overload;
    procedure Add(host: string; port: Int32; authenticationType: string; credential: DNNetworkCredential); overload;
    procedure Remove(uriPrefix: DDNC.System.Private.Uri.DNUri; authType: string); overload;
    procedure Remove(host: string; port: Int32; authenticationType: string); overload;
    function GetCredential(uriPrefix: DDNC.System.Private.Uri.DNUri; authType: string): DNNetworkCredential; overload;
    function GetCredential(host: string; port: Int32; authenticationType: string): DNNetworkCredential; overload;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNCredentialCache = class(TDNGenericImport<DNCredentialCacheClass, DNCredentialCache>) end;

  //-------------namespace: System.Net----------------
  DNEndPointClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{CCC832F9-8110-5853-A368-3A67FEDDAEF6}']
  end;

  [DNTypeName('System.Net.EndPoint')]
  DNEndPoint = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F8338B3A-7FD4-3FF7-9981-9FB8FB519D62}']
  { getters & setters } 

    function get_AddressFamily: DNAddressFamily;

  { methods } 

    function Serialize: DNSocketAddress;
    function Create(socketAddress: DNSocketAddress): DNEndPoint;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AddressFamily: DNAddressFamily read get_AddressFamily;
  end;

  TDNEndPoint = class(TDNGenericImport<DNEndPointClass, DNEndPoint>) end;

  //-------------namespace: System.Net----------------
  DNDnsEndPointClass = interface(DNEndPointClass)
  ['{AB277A21-0344-5F95-8657-56E3D2B5DE54}']
  { constructors } 

    {class} function init(host: string; port: Int32): DNDnsEndPoint; overload;
    {class} function init(host: string; port: Int32; addressFamily: DNAddressFamily): DNDnsEndPoint; overload;

  end;

  [DNTypeName('System.Net.DnsEndPoint')]
  DNDnsEndPoint = interface(DNEndPoint)
  ['{7E0FD7D7-878E-33E1-A34D-20AEF9558E9C}']
  { getters & setters } 

    function get_Host: string;
    function get_AddressFamily: DNAddressFamily;
    function get_Port: Int32;

  { methods } 

    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function Serialize: DNSocketAddress;
    function Create(socketAddress: DNSocketAddress): DNEndPoint;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Host: string read get_Host;
    property AddressFamily: DNAddressFamily read get_AddressFamily;
    property Port: Int32 read get_Port;
  end;

  TDNDnsEndPoint = class(TDNGenericImport<DNDnsEndPointClass, DNDnsEndPoint>) end;

  //-------------namespace: System.Net----------------
  DNIPEndPointClass = interface(DNEndPointClass)
  ['{BD8C9156-56EE-5FDC-BB76-9731203FA03C}']
  { constructors } 

    {class} function init(address: Int64; port: Int32): DNIPEndPoint; overload;
    {class} function init(address: DNIPAddress; port: Int32): DNIPEndPoint; overload;

  { static methods } 

    {class} function TryParse(s: string; out result: DNIPEndPoint): Boolean; overload;
    {class} function TryParse(s: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; out result: DNIPEndPoint): Boolean; overload;
    {class} function Parse(s: string): DNIPEndPoint; overload;
    {class} function Parse(s: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>): DNIPEndPoint; overload;

  end;

  [DNTypeName('System.Net.IPEndPoint')]
  DNIPEndPoint = interface(DNEndPoint)
  ['{17869EA9-8C8E-38B7-9036-0141F955CAB4}']
  { getters & setters } 

    function get_AddressFamily: DNAddressFamily;
    function get_Address: DNIPAddress;
    procedure set_Address(value: DNIPAddress);
    function get_Port: Int32;
    procedure set_Port(value: Int32);

  { methods } 

    function ToString: string;
    function Serialize: DNSocketAddress;
    function Create(socketAddress: DNSocketAddress): DNEndPoint;
    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AddressFamily: DNAddressFamily read get_AddressFamily;
    property Address: DNIPAddress read get_Address write set_Address;
    property Port: Int32 read get_Port write set_Port;
  end;

  TDNIPEndPoint = class(TDNGenericImport<DNIPEndPointClass, DNIPEndPoint>)
  public const
   MinPort = 0;
   MaxPort = 65535;
  end;

  //-------------namespace: System.Net----------------
  DNHttpVersionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A7294A6C-69EE-578C-8200-77BF85D5C515}']
  { static fields getter & setter } 

   function __fakeFieldGet_Unknown: DDNC.System.Private.CoreLib.DNVersion;
   function __fakeFieldGet_Version10: DDNC.System.Private.CoreLib.DNVersion;
   function __fakeFieldGet_Version11: DDNC.System.Private.CoreLib.DNVersion;
   function __fakeFieldGet_Version20: DDNC.System.Private.CoreLib.DNVersion;

  { static fields } 

    {class} property Unknown: DDNC.System.Private.CoreLib.DNVersion read __fakeFieldGet_Unknown;
    {class} property Version10: DDNC.System.Private.CoreLib.DNVersion read __fakeFieldGet_Version10;
    {class} property Version11: DDNC.System.Private.CoreLib.DNVersion read __fakeFieldGet_Version11;
    {class} property Version20: DDNC.System.Private.CoreLib.DNVersion read __fakeFieldGet_Version20;

  end;

  [DNTypeName('System.Net.HttpVersion')]
  DNHttpVersion = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7D0EA41F-683D-36BC-9DC6-C143FAC7C9F3}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpVersion = class(TDNGenericImport<DNHttpVersionClass, DNHttpVersion>) end;

  //-------------namespace: System.Net----------------
  DNIPAddressClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{5A11D827-79A6-5E79-809A-6C2C7568D00A}']
  { constructors } 

    {class} function init(newAddress: Int64): DNIPAddress; overload;
    {class} function init(address: TArray<Byte>; scopeid: Int64): DNIPAddress; overload;
    {class} function init(address: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; scopeid: Int64): DNIPAddress; overload;
    {class} function init(address: TArray<Byte>): DNIPAddress; overload;
    {class} function init(address: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNIPAddress; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_Any: DNIPAddress;
   function __fakeFieldGet_Loopback: DNIPAddress;
   function __fakeFieldGet_Broadcast: DNIPAddress;
   function __fakeFieldGet_None: DNIPAddress;
   function __fakeFieldGet_IPv6Any: DNIPAddress;
   function __fakeFieldGet_IPv6Loopback: DNIPAddress;
   function __fakeFieldGet_IPv6None: DNIPAddress;

  { static fields } 

    {class} property Any: DNIPAddress read __fakeFieldGet_Any;
    {class} property Loopback: DNIPAddress read __fakeFieldGet_Loopback;
    {class} property Broadcast: DNIPAddress read __fakeFieldGet_Broadcast;
    {class} property None: DNIPAddress read __fakeFieldGet_None;
    {class} property IPv6Any: DNIPAddress read __fakeFieldGet_IPv6Any;
    {class} property IPv6Loopback: DNIPAddress read __fakeFieldGet_IPv6Loopback;
    {class} property IPv6None: DNIPAddress read __fakeFieldGet_IPv6None;

  { static methods } 

    {class} function TryParse(ipString: string; out address: DNIPAddress): Boolean; overload;
    {class} function TryParse(ipSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; out address: DNIPAddress): Boolean; overload;
    {class} function Parse(ipString: string): DNIPAddress; overload;
    {class} function Parse(ipSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>): DNIPAddress; overload;
    {class} function HostToNetworkOrder(host: Int64): Int64; overload;
    {class} function HostToNetworkOrder(host: Int32): Int32; overload;
    {class} function HostToNetworkOrder(host: Int16): Int16; overload;
    {class} function NetworkToHostOrder(network: Int64): Int64; overload;
    {class} function NetworkToHostOrder(network: Int32): Int32; overload;
    {class} function NetworkToHostOrder(network: Int16): Int16; overload;
    {class} function IsLoopback(address: DNIPAddress): Boolean;

  end;

  [DNTypeName('System.Net.IPAddress')]
  DNIPAddress = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{42BB0D75-4630-3B0D-AE50-A68F3CD21CE3}']
  { getters & setters } 

    function get_AddressFamily: DNAddressFamily;
    function get_ScopeId: Int64;
    procedure set_ScopeId(value: Int64);
    function get_IsIPv6Multicast: Boolean;
    function get_IsIPv6LinkLocal: Boolean;
    function get_IsIPv6SiteLocal: Boolean;
    function get_IsIPv6Teredo: Boolean;
    function get_IsIPv4MappedToIPv6: Boolean;
    function get_Address: Int64;
    procedure set_Address(value: Int64);

  { methods } 

    function TryWriteBytes(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): Boolean;
    function GetAddressBytes: TArray<Byte>;
    function ToString: string;
    function TryFormat(destination: DDNC.System.Private.CoreLib.DNSpan<Char>; out charsWritten: Int32): Boolean;
    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function MapToIPv6: DNIPAddress;
    function MapToIPv4: DNIPAddress;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AddressFamily: DNAddressFamily read get_AddressFamily;
    property ScopeId: Int64 read get_ScopeId write set_ScopeId;
    property IsIPv6Multicast: Boolean read get_IsIPv6Multicast;
    property IsIPv6LinkLocal: Boolean read get_IsIPv6LinkLocal;
    property IsIPv6SiteLocal: Boolean read get_IsIPv6SiteLocal;
    property IsIPv6Teredo: Boolean read get_IsIPv6Teredo;
    property IsIPv4MappedToIPv6: Boolean read get_IsIPv4MappedToIPv6;
    property Address: Int64 read get_Address write set_Address;
  end;

  TDNIPAddress = class(TDNGenericImport<DNIPAddressClass, DNIPAddress>) end;

  //-------------namespace: System.Net----------------
  DNNetworkCredentialClass = interface(DNObjectClass)
  ['{603EF629-27EE-572C-926B-FB84149D82C9}']
  { constructors } 

    {class} function init: DNNetworkCredential; overload;
    {class} function init(userName: string; password: string): DNNetworkCredential; overload;
    {class} function init(userName: string; password: string; domain: string): DNNetworkCredential; overload;
    {class} function init(userName: string; password: DDNC.System.Private.CoreLib.DNSecureString): DNNetworkCredential; overload;
    {class} function init(userName: string; password: DDNC.System.Private.CoreLib.DNSecureString; domain: string): DNNetworkCredential; overload;

  end;

  [DNTypeName('System.Net.NetworkCredential')]
  DNNetworkCredential = interface(DNICredentials)
  ['{315610EB-23F9-321B-9C6D-849E40EE413C}']
  { getters & setters } 

    function get_UserName: string;
    procedure set_UserName(value: string);
    function get_Password: string;
    procedure set_Password(value: string);
    function get_SecurePassword: DDNC.System.Private.CoreLib.DNSecureString;
    procedure set_SecurePassword(value: DDNC.System.Private.CoreLib.DNSecureString);
    function get_Domain: string;
    procedure set_Domain(value: string);

  { methods } 

    function GetCredential(uri: DDNC.System.Private.Uri.DNUri; authenticationType: string): DNNetworkCredential; overload;
    function GetCredential(host: string; port: Int32; authenticationType: string): DNNetworkCredential; overload;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property UserName: string read get_UserName write set_UserName;
    property Password: string read get_Password write set_Password;
    property SecurePassword: DDNC.System.Private.CoreLib.DNSecureString read get_SecurePassword write set_SecurePassword;
    property Domain: string read get_Domain write set_Domain;
  end;

  TDNNetworkCredential = class(TDNGenericImport<DNNetworkCredentialClass, DNNetworkCredential>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPAddressCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{FCFE6E60-09C5-5597-850B-F4F02B3D0441}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPAddressCollection')]
  DNIPAddressCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{42A71DE0-740F-3AD5-BC12-CB8D5F476A0D}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNIPAddress;

  { methods } 

    procedure CopyTo(&array: TArray<DNIPAddress>; offset: Int32);
    procedure Add(address: DNIPAddress);
    function &Contains(address: DNIPAddress): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNIPAddress>;
    function Remove(address: DNIPAddress): Boolean;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNIPAddress read get_Item; default;
  end;

  TDNIPAddressCollection = class(TDNGenericImport<DNIPAddressCollectionClass, DNIPAddressCollection>) end;

  //-------------namespace: System.Net----------------
  DNPathListClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{CE11F4BE-9B57-51EC-9B1E-93889F55FA56}']
  { constructors } 

    {class} function init: DNPathList;

  end;

  [DNTypeName('System.Net.PathList')]
  DNPathList = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{736FC9BC-D428-336A-B045-A7D8AEBE9C56}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNPathList = class(TDNGenericImport<DNPathListClass, DNPathList>) end;

  //-------------namespace: System.Net----------------
  DNSocketAddressClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{966B2F57-9FA1-59FB-835A-1B9CD070C1D3}']
  { constructors } 

    {class} function init(family: DNAddressFamily): DNSocketAddress; overload;
    {class} function init(family: DNAddressFamily; size: Int32): DNSocketAddress; overload;

  end;

  [DNTypeName('System.Net.SocketAddress')]
  DNSocketAddress = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2454B29A-28C5-33F2-AAC0-827332394300}']
  { getters & setters } 

    function get_Family: DNAddressFamily;
    function get_Size: Int32;
    function get_Item(offset: Int32): Byte;
    procedure set_Item(offset: Int32; value: Byte);

  { methods } 

    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Family: DNAddressFamily read get_Family;
    property Size: Int32 read get_Size;
    property Item[offset: Int32]: Byte read get_Item write set_Item; default;
  end;

  TDNSocketAddress = class(TDNGenericImport<DNSocketAddressClass, DNSocketAddress>) end;

  //-------------namespace: System.Net----------------
  DNTransportContextClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{34538716-9E8B-5AC9-8F05-12C4581DECDC}']
  end;

  [DNTypeName('System.Net.TransportContext')]
  DNTransportContext = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4430860E-3B71-3A8C-8A2F-3A8334FE9A12}']
  { methods } 

    function GetChannelBinding(kind: DNChannelBindingKind): DNChannelBinding;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNTransportContext = class(TDNGenericImport<DNTransportContextClass, DNTransportContext>) end;

  //-------------namespace: System.Security.Authentication.ExtendedProtection----------------
  DNChannelBindingClass = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalidClass)
  ['{C2DB34DC-E8EE-5B18-B24A-17B03A4B355C}']
  end;

  [DNTypeName('System.Security.Authentication.ExtendedProtection.ChannelBinding')]
  DNChannelBinding = interface(DDNC.System.Private.CoreLib.DNSafeHandleZeroOrMinusOneIsInvalid)
  ['{EFA8A83B-E691-3FF4-9717-3CFF47ED2C31}']
  { getters & setters } 

    function get_Size: Int32;
    function get_IsInvalid: Boolean;
    function get_IsClosed: Boolean;

  { methods } 

    function DangerousGetHandle: IntPtr;
    procedure Close;
    procedure Dispose;
    procedure SetHandleAsInvalid;
    procedure DangerousAddRef(out success: Boolean);
    procedure DangerousRelease;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Size: Int32 read get_Size;
    property IsInvalid: Boolean read get_IsInvalid;
    property IsClosed: Boolean read get_IsClosed;
  end;

  TDNChannelBinding = class(TDNGenericImport<DNChannelBindingClass, DNChannelBinding>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.Primitives, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
