//----------------------------------------------------------------------------
//  System.Net.NetworkInformation.dll: System.Net.NetworkInformation, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.NetworkInformation
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.NetworkInformation;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.Microsoft.Win32.Primitives,
  DDNC.System.Net.Primitives;

type

{ enums }

  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.DuplicateAddressDetectionState')]
  DNDuplicateAddressDetectionState = type Integer;
  DNDuplicateAddressDetectionStateHelper = record helper for DNDuplicateAddressDetectionState
  public const
    Invalid = 0;
    Tentative = 1;
    Duplicate = 2;
    Deprecated = 3;
    Preferred = 4;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.NetBiosNodeType')]
  DNNetBiosNodeType = type Integer;
  DNNetBiosNodeTypeHelper = record helper for DNNetBiosNodeType
  public const
    Unknown = 0;
    Broadcast = 1;
    Peer2Peer = 2;
    Mixed = 4;
    Hybrid = 8;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.NetworkInterfaceComponent')]
  DNNetworkInterfaceComponent = type Integer;
  DNNetworkInterfaceComponentHelper = record helper for DNNetworkInterfaceComponent
  public const
    IPv4 = 0;
    IPv6 = 1;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.NetworkInterfaceType')]
  DNNetworkInterfaceType = type Integer;
  DNNetworkInterfaceTypeHelper = record helper for DNNetworkInterfaceType
  public const
    Unknown = 1;
    Ethernet = 6;
    TokenRing = 9;
    Fddi = 15;
    BasicIsdn = 20;
    PrimaryIsdn = 21;
    Ppp = 23;
    Loopback = 24;
    Ethernet3Megabit = 26;
    Slip = 28;
    Atm = 37;
    GenericModem = 48;
    FastEthernetT = 62;
    Isdn = 63;
    FastEthernetFx = 69;
    Wireless80211 = 71;
    AsymmetricDsl = 94;
    RateAdaptDsl = 95;
    SymmetricDsl = 96;
    VeryHighSpeedDsl = 97;
    IPOverAtm = 114;
    GigabitEthernet = 117;
    Tunnel = 131;
    MultiRateSymmetricDsl = 143;
    HighPerformanceSerialBus = 144;
    Wman = 237;
    Wwanpp = 243;
    Wwanpp2 = 244;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.OperationalStatus')]
  DNOperationalStatus = type Integer;
  DNOperationalStatusHelper = record helper for DNOperationalStatus
  public const
    Up = 1;
    Down = 2;
    Testing = 3;
    Unknown = 4;
    Dormant = 5;
    NotPresent = 6;
    LowerLayerDown = 7;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.PrefixOrigin')]
  DNPrefixOrigin = type Integer;
  DNPrefixOriginHelper = record helper for DNPrefixOrigin
  public const
    Other = 0;
    Manual = 1;
    WellKnown = 2;
    Dhcp = 3;
    RouterAdvertisement = 4;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.ScopeLevel')]
  DNScopeLevel = type Integer;
  DNScopeLevelHelper = record helper for DNScopeLevel
  public const
    None = 0;
    Interface_ = 1;
    Link = 2;
    Subnet = 3;
    Admin = 4;
    Site = 5;
    Organization = 8;
    Global = 14;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.SuffixOrigin')]
  DNSuffixOrigin = type Integer;
  DNSuffixOriginHelper = record helper for DNSuffixOrigin
  public const
    Other = 0;
    Manual = 1;
    WellKnown = 2;
    OriginDhcp = 3;
    LinkLayerAddress = 4;
    Random = 5;
  end;


  //-------------namespace: System.Net.NetworkInformation----------------
  [DNTypeName('System.Net.NetworkInformation.TcpState')]
  DNTcpState = type Integer;
  DNTcpStateHelper = record helper for DNTcpState
  public const
    Unknown = 0;
    Closed = 1;
    Listen = 2;
    SynSent = 3;
    SynReceived = 4;
    Established = 5;
    FinWait1 = 6;
    FinWait2 = 7;
    CloseWait = 8;
    Closing = 9;
    LastAck = 10;
    TimeWait = 11;
    DeleteTcb = 12;
  end;




type


{ declares }

  DNNetworkAvailabilityEventArgs = interface; // type: System.Net.NetworkInformation.NetworkAvailabilityEventArgs, namespace: System.Net.NetworkInformation
  DNNetworkInformationException = interface; // type: System.Net.NetworkInformation.NetworkInformationException, namespace: System.Net.NetworkInformation
  DNGatewayIPAddressInformation = interface; // type: System.Net.NetworkInformation.GatewayIPAddressInformation, namespace: System.Net.NetworkInformation
  DNGatewayIPAddressInformationCollection = interface; // type: System.Net.NetworkInformation.GatewayIPAddressInformationCollection, namespace: System.Net.NetworkInformation
  DNIcmpV4Statistics = interface; // type: System.Net.NetworkInformation.IcmpV4Statistics, namespace: System.Net.NetworkInformation
  DNIcmpV6Statistics = interface; // type: System.Net.NetworkInformation.IcmpV6Statistics, namespace: System.Net.NetworkInformation
  DNIPAddressInformation = interface; // type: System.Net.NetworkInformation.IPAddressInformation, namespace: System.Net.NetworkInformation
  DNMulticastIPAddressInformation = interface; // type: System.Net.NetworkInformation.MulticastIPAddressInformation, namespace: System.Net.NetworkInformation
  DNUnicastIPAddressInformation = interface; // type: System.Net.NetworkInformation.UnicastIPAddressInformation, namespace: System.Net.NetworkInformation
  DNIPAddressInformationCollection = interface; // type: System.Net.NetworkInformation.IPAddressInformationCollection, namespace: System.Net.NetworkInformation
  DNIPGlobalProperties = interface; // type: System.Net.NetworkInformation.IPGlobalProperties, namespace: System.Net.NetworkInformation
  DNIPGlobalStatistics = interface; // type: System.Net.NetworkInformation.IPGlobalStatistics, namespace: System.Net.NetworkInformation
  DNIPInterfaceProperties = interface; // type: System.Net.NetworkInformation.IPInterfaceProperties, namespace: System.Net.NetworkInformation
  DNIPInterfaceStatistics = interface; // type: System.Net.NetworkInformation.IPInterfaceStatistics, namespace: System.Net.NetworkInformation
  DNIPv4InterfaceProperties = interface; // type: System.Net.NetworkInformation.IPv4InterfaceProperties, namespace: System.Net.NetworkInformation
  DNIPv4InterfaceStatistics = interface; // type: System.Net.NetworkInformation.IPv4InterfaceStatistics, namespace: System.Net.NetworkInformation
  DNIPv6InterfaceProperties = interface; // type: System.Net.NetworkInformation.IPv6InterfaceProperties, namespace: System.Net.NetworkInformation
  DNMulticastIPAddressInformationCollection = interface; // type: System.Net.NetworkInformation.MulticastIPAddressInformationCollection, namespace: System.Net.NetworkInformation
  DNNetworkChange = interface; // type: System.Net.NetworkInformation.NetworkChange, namespace: System.Net.NetworkInformation
  DNNetworkInterface = interface; // type: System.Net.NetworkInformation.NetworkInterface, namespace: System.Net.NetworkInformation
  DNPhysicalAddress = interface; // type: System.Net.NetworkInformation.PhysicalAddress, namespace: System.Net.NetworkInformation
  DNTcpConnectionInformation = interface; // type: System.Net.NetworkInformation.TcpConnectionInformation, namespace: System.Net.NetworkInformation
  DNTcpStatistics = interface; // type: System.Net.NetworkInformation.TcpStatistics, namespace: System.Net.NetworkInformation
  DNUdpStatistics = interface; // type: System.Net.NetworkInformation.UdpStatistics, namespace: System.Net.NetworkInformation
  DNUnicastIPAddressInformationCollection = interface; // type: System.Net.NetworkInformation.UnicastIPAddressInformationCollection, namespace: System.Net.NetworkInformation

{ delegates }

  [DNTypeName('System.Net.NetworkInformation.NetworkAddressChangedEventHandler')]
  DNNetworkAddressChangedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DDNC.System.Private.CoreLib.DNEventArgs) of object;

  [DNTypeName('System.Net.NetworkInformation.NetworkAvailabilityChangedEventHandler')]
  DNNetworkAvailabilityChangedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DNNetworkAvailabilityEventArgs) of object;




{ objects }

  //-------------namespace: System.Net.NetworkInformation----------------
  DNNetworkAvailabilityEventArgsClass = interface(DDNC.System.Private.CoreLib.DNEventArgsClass)
  ['{A4DC4E2D-B191-5D31-B7BF-86A08CE56E1A}']
  end;

  [DNTypeName('System.Net.NetworkInformation.NetworkAvailabilityEventArgs')]
  DNNetworkAvailabilityEventArgs = interface(DDNC.System.Private.CoreLib.DNEventArgs)
  ['{B2D92E16-01CF-34BF-891B-ACEAC2E80C97}']
  { getters & setters } 

    function get_IsAvailable: Boolean;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsAvailable: Boolean read get_IsAvailable;
  end;

  TDNNetworkAvailabilityEventArgs = class(TDNGenericImport<DNNetworkAvailabilityEventArgsClass, DNNetworkAvailabilityEventArgs>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNNetworkInformationExceptionClass = interface(DNObjectClass)
  ['{B19ED5CA-661F-5FFF-A074-F602B242CEC8}']
  { constructors } 

    {class} function init: DNNetworkInformationException; overload;
    {class} function init(errorCode: Int32): DNNetworkInformationException; overload;

  end;

  [DNTypeName('System.Net.NetworkInformation.NetworkInformationException')]
  DNNetworkInformationException = interface(DNObject)
  ['{20E54FE8-2129-3AE7-AA48-B4C35C441CAA}']
  { getters & setters } 

    function get_ErrorCode: Int32;
    function get_NativeErrorCode: Int32;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ErrorCode: Int32 read get_ErrorCode;
    property NativeErrorCode: Int32 read get_NativeErrorCode;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNNetworkInformationException = class(TDNGenericImport<DNNetworkInformationExceptionClass, DNNetworkInformationException>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNGatewayIPAddressInformationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{B300A780-0003-556E-A45F-3419D4911B88}']
  end;

  [DNTypeName('System.Net.NetworkInformation.GatewayIPAddressInformation')]
  DNGatewayIPAddressInformation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8FD6C011-95A2-3A97-8E13-0EAE104EAF35}']
  { getters & setters } 

    function get_Address: DDNC.System.Net.Primitives.DNIPAddress;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Address: DDNC.System.Net.Primitives.DNIPAddress read get_Address;
  end;

  TDNGatewayIPAddressInformation = class(TDNGenericImport<DNGatewayIPAddressInformationClass, DNGatewayIPAddressInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNGatewayIPAddressInformationCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{229CC3F4-A387-57DF-BBFB-89371750D441}']
  end;

  [DNTypeName('System.Net.NetworkInformation.GatewayIPAddressInformationCollection')]
  DNGatewayIPAddressInformationCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C856D2BB-B069-39A9-BA30-665B65B96B19}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNGatewayIPAddressInformation;

  { methods } 

    procedure CopyTo(&array: TArray<DNGatewayIPAddressInformation>; offset: Int32);
    procedure Add(address: DNGatewayIPAddressInformation);
    function &Contains(address: DNGatewayIPAddressInformation): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNGatewayIPAddressInformation>;
    function Remove(address: DNGatewayIPAddressInformation): Boolean;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNGatewayIPAddressInformation read get_Item; default;
  end;

  TDNGatewayIPAddressInformationCollection = class(TDNGenericImport<DNGatewayIPAddressInformationCollectionClass, DNGatewayIPAddressInformationCollection>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIcmpV4StatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{442DC239-97DF-56FF-BB97-BBD87F578F8E}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IcmpV4Statistics')]
  DNIcmpV4Statistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A4D0F4A1-5A71-3D99-9C86-3090980D5F56}']
  { getters & setters } 

    function get_AddressMaskRepliesReceived: Int64;
    function get_AddressMaskRepliesSent: Int64;
    function get_AddressMaskRequestsReceived: Int64;
    function get_AddressMaskRequestsSent: Int64;
    function get_DestinationUnreachableMessagesReceived: Int64;
    function get_DestinationUnreachableMessagesSent: Int64;
    function get_EchoRepliesReceived: Int64;
    function get_EchoRepliesSent: Int64;
    function get_EchoRequestsReceived: Int64;
    function get_EchoRequestsSent: Int64;
    function get_ErrorsReceived: Int64;
    function get_ErrorsSent: Int64;
    function get_MessagesReceived: Int64;
    function get_MessagesSent: Int64;
    function get_ParameterProblemsReceived: Int64;
    function get_ParameterProblemsSent: Int64;
    function get_RedirectsReceived: Int64;
    function get_RedirectsSent: Int64;
    function get_SourceQuenchesReceived: Int64;
    function get_SourceQuenchesSent: Int64;
    function get_TimeExceededMessagesReceived: Int64;
    function get_TimeExceededMessagesSent: Int64;
    function get_TimestampRepliesReceived: Int64;
    function get_TimestampRepliesSent: Int64;
    function get_TimestampRequestsReceived: Int64;
    function get_TimestampRequestsSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AddressMaskRepliesReceived: Int64 read get_AddressMaskRepliesReceived;
    property AddressMaskRepliesSent: Int64 read get_AddressMaskRepliesSent;
    property AddressMaskRequestsReceived: Int64 read get_AddressMaskRequestsReceived;
    property AddressMaskRequestsSent: Int64 read get_AddressMaskRequestsSent;
    property DestinationUnreachableMessagesReceived: Int64 read get_DestinationUnreachableMessagesReceived;
    property DestinationUnreachableMessagesSent: Int64 read get_DestinationUnreachableMessagesSent;
    property EchoRepliesReceived: Int64 read get_EchoRepliesReceived;
    property EchoRepliesSent: Int64 read get_EchoRepliesSent;
    property EchoRequestsReceived: Int64 read get_EchoRequestsReceived;
    property EchoRequestsSent: Int64 read get_EchoRequestsSent;
    property ErrorsReceived: Int64 read get_ErrorsReceived;
    property ErrorsSent: Int64 read get_ErrorsSent;
    property MessagesReceived: Int64 read get_MessagesReceived;
    property MessagesSent: Int64 read get_MessagesSent;
    property ParameterProblemsReceived: Int64 read get_ParameterProblemsReceived;
    property ParameterProblemsSent: Int64 read get_ParameterProblemsSent;
    property RedirectsReceived: Int64 read get_RedirectsReceived;
    property RedirectsSent: Int64 read get_RedirectsSent;
    property SourceQuenchesReceived: Int64 read get_SourceQuenchesReceived;
    property SourceQuenchesSent: Int64 read get_SourceQuenchesSent;
    property TimeExceededMessagesReceived: Int64 read get_TimeExceededMessagesReceived;
    property TimeExceededMessagesSent: Int64 read get_TimeExceededMessagesSent;
    property TimestampRepliesReceived: Int64 read get_TimestampRepliesReceived;
    property TimestampRepliesSent: Int64 read get_TimestampRepliesSent;
    property TimestampRequestsReceived: Int64 read get_TimestampRequestsReceived;
    property TimestampRequestsSent: Int64 read get_TimestampRequestsSent;
  end;

  TDNIcmpV4Statistics = class(TDNGenericImport<DNIcmpV4StatisticsClass, DNIcmpV4Statistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIcmpV6StatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{AC7F01D6-152C-55A4-B138-BA7DC34EB81F}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IcmpV6Statistics')]
  DNIcmpV6Statistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{702B8C90-2345-3EBB-B0F9-7CDB75494BA4}']
  { getters & setters } 

    function get_DestinationUnreachableMessagesReceived: Int64;
    function get_DestinationUnreachableMessagesSent: Int64;
    function get_EchoRepliesReceived: Int64;
    function get_EchoRepliesSent: Int64;
    function get_EchoRequestsReceived: Int64;
    function get_EchoRequestsSent: Int64;
    function get_ErrorsReceived: Int64;
    function get_ErrorsSent: Int64;
    function get_MembershipQueriesReceived: Int64;
    function get_MembershipQueriesSent: Int64;
    function get_MembershipReductionsReceived: Int64;
    function get_MembershipReductionsSent: Int64;
    function get_MembershipReportsReceived: Int64;
    function get_MembershipReportsSent: Int64;
    function get_MessagesReceived: Int64;
    function get_MessagesSent: Int64;
    function get_NeighborAdvertisementsReceived: Int64;
    function get_NeighborAdvertisementsSent: Int64;
    function get_NeighborSolicitsReceived: Int64;
    function get_NeighborSolicitsSent: Int64;
    function get_PacketTooBigMessagesReceived: Int64;
    function get_PacketTooBigMessagesSent: Int64;
    function get_ParameterProblemsReceived: Int64;
    function get_ParameterProblemsSent: Int64;
    function get_RedirectsReceived: Int64;
    function get_RedirectsSent: Int64;
    function get_RouterAdvertisementsReceived: Int64;
    function get_RouterAdvertisementsSent: Int64;
    function get_RouterSolicitsReceived: Int64;
    function get_RouterSolicitsSent: Int64;
    function get_TimeExceededMessagesReceived: Int64;
    function get_TimeExceededMessagesSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DestinationUnreachableMessagesReceived: Int64 read get_DestinationUnreachableMessagesReceived;
    property DestinationUnreachableMessagesSent: Int64 read get_DestinationUnreachableMessagesSent;
    property EchoRepliesReceived: Int64 read get_EchoRepliesReceived;
    property EchoRepliesSent: Int64 read get_EchoRepliesSent;
    property EchoRequestsReceived: Int64 read get_EchoRequestsReceived;
    property EchoRequestsSent: Int64 read get_EchoRequestsSent;
    property ErrorsReceived: Int64 read get_ErrorsReceived;
    property ErrorsSent: Int64 read get_ErrorsSent;
    property MembershipQueriesReceived: Int64 read get_MembershipQueriesReceived;
    property MembershipQueriesSent: Int64 read get_MembershipQueriesSent;
    property MembershipReductionsReceived: Int64 read get_MembershipReductionsReceived;
    property MembershipReductionsSent: Int64 read get_MembershipReductionsSent;
    property MembershipReportsReceived: Int64 read get_MembershipReportsReceived;
    property MembershipReportsSent: Int64 read get_MembershipReportsSent;
    property MessagesReceived: Int64 read get_MessagesReceived;
    property MessagesSent: Int64 read get_MessagesSent;
    property NeighborAdvertisementsReceived: Int64 read get_NeighborAdvertisementsReceived;
    property NeighborAdvertisementsSent: Int64 read get_NeighborAdvertisementsSent;
    property NeighborSolicitsReceived: Int64 read get_NeighborSolicitsReceived;
    property NeighborSolicitsSent: Int64 read get_NeighborSolicitsSent;
    property PacketTooBigMessagesReceived: Int64 read get_PacketTooBigMessagesReceived;
    property PacketTooBigMessagesSent: Int64 read get_PacketTooBigMessagesSent;
    property ParameterProblemsReceived: Int64 read get_ParameterProblemsReceived;
    property ParameterProblemsSent: Int64 read get_ParameterProblemsSent;
    property RedirectsReceived: Int64 read get_RedirectsReceived;
    property RedirectsSent: Int64 read get_RedirectsSent;
    property RouterAdvertisementsReceived: Int64 read get_RouterAdvertisementsReceived;
    property RouterAdvertisementsSent: Int64 read get_RouterAdvertisementsSent;
    property RouterSolicitsReceived: Int64 read get_RouterSolicitsReceived;
    property RouterSolicitsSent: Int64 read get_RouterSolicitsSent;
    property TimeExceededMessagesReceived: Int64 read get_TimeExceededMessagesReceived;
    property TimeExceededMessagesSent: Int64 read get_TimeExceededMessagesSent;
  end;

  TDNIcmpV6Statistics = class(TDNGenericImport<DNIcmpV6StatisticsClass, DNIcmpV6Statistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPAddressInformationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{5FDCD4F9-25A2-5792-9086-5AEE92C2AC36}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPAddressInformation')]
  DNIPAddressInformation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{6E9BFDC0-C151-3D61-8F9B-76449B768605}']
  { getters & setters } 

    function get_Address: DDNC.System.Net.Primitives.DNIPAddress;
    function get_IsDnsEligible: Boolean;
    function get_IsTransient: Boolean;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Address: DDNC.System.Net.Primitives.DNIPAddress read get_Address;
    property IsDnsEligible: Boolean read get_IsDnsEligible;
    property IsTransient: Boolean read get_IsTransient;
  end;

  TDNIPAddressInformation = class(TDNGenericImport<DNIPAddressInformationClass, DNIPAddressInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNMulticastIPAddressInformationClass = interface(DNIPAddressInformationClass)
  ['{2CE1AE42-48A0-574C-A17E-6A55219DFF7F}']
  end;

  [DNTypeName('System.Net.NetworkInformation.MulticastIPAddressInformation')]
  DNMulticastIPAddressInformation = interface(DNIPAddressInformation)
  ['{CD6C57E1-7DEC-3863-A9C5-6B6CC7FFAB33}']
  { getters & setters } 

    function get_AddressPreferredLifetime: Int64;
    function get_AddressValidLifetime: Int64;
    function get_DhcpLeaseLifetime: Int64;
    function get_DuplicateAddressDetectionState: DNDuplicateAddressDetectionState;
    function get_PrefixOrigin: DNPrefixOrigin;
    function get_SuffixOrigin: DNSuffixOrigin;
    function get_Address: DDNC.System.Net.Primitives.DNIPAddress;
    function get_IsDnsEligible: Boolean;
    function get_IsTransient: Boolean;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AddressPreferredLifetime: Int64 read get_AddressPreferredLifetime;
    property AddressValidLifetime: Int64 read get_AddressValidLifetime;
    property DhcpLeaseLifetime: Int64 read get_DhcpLeaseLifetime;
    property DuplicateAddressDetectionState: DNDuplicateAddressDetectionState read get_DuplicateAddressDetectionState;
    property PrefixOrigin: DNPrefixOrigin read get_PrefixOrigin;
    property SuffixOrigin: DNSuffixOrigin read get_SuffixOrigin;
    property Address: DDNC.System.Net.Primitives.DNIPAddress read get_Address;
    property IsDnsEligible: Boolean read get_IsDnsEligible;
    property IsTransient: Boolean read get_IsTransient;
  end;

  TDNMulticastIPAddressInformation = class(TDNGenericImport<DNMulticastIPAddressInformationClass, DNMulticastIPAddressInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNUnicastIPAddressInformationClass = interface(DNIPAddressInformationClass)
  ['{33F08059-CB01-5005-8C8A-EE9862E53DD3}']
  end;

  [DNTypeName('System.Net.NetworkInformation.UnicastIPAddressInformation')]
  DNUnicastIPAddressInformation = interface(DNIPAddressInformation)
  ['{9D07A2C5-A5B7-3349-855B-391EA87E0491}']
  { getters & setters } 

    function get_AddressPreferredLifetime: Int64;
    function get_AddressValidLifetime: Int64;
    function get_DhcpLeaseLifetime: Int64;
    function get_DuplicateAddressDetectionState: DNDuplicateAddressDetectionState;
    function get_PrefixOrigin: DNPrefixOrigin;
    function get_SuffixOrigin: DNSuffixOrigin;
    function get_IPv4Mask: DDNC.System.Net.Primitives.DNIPAddress;
    function get_PrefixLength: Int32;
    function get_Address: DDNC.System.Net.Primitives.DNIPAddress;
    function get_IsDnsEligible: Boolean;
    function get_IsTransient: Boolean;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AddressPreferredLifetime: Int64 read get_AddressPreferredLifetime;
    property AddressValidLifetime: Int64 read get_AddressValidLifetime;
    property DhcpLeaseLifetime: Int64 read get_DhcpLeaseLifetime;
    property DuplicateAddressDetectionState: DNDuplicateAddressDetectionState read get_DuplicateAddressDetectionState;
    property PrefixOrigin: DNPrefixOrigin read get_PrefixOrigin;
    property SuffixOrigin: DNSuffixOrigin read get_SuffixOrigin;
    property IPv4Mask: DDNC.System.Net.Primitives.DNIPAddress read get_IPv4Mask;
    property PrefixLength: Int32 read get_PrefixLength;
    property Address: DDNC.System.Net.Primitives.DNIPAddress read get_Address;
    property IsDnsEligible: Boolean read get_IsDnsEligible;
    property IsTransient: Boolean read get_IsTransient;
  end;

  TDNUnicastIPAddressInformation = class(TDNGenericImport<DNUnicastIPAddressInformationClass, DNUnicastIPAddressInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPAddressInformationCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{1E6B9941-1933-58FC-A9A5-C52527CE730D}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPAddressInformationCollection')]
  DNIPAddressInformationCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{02A5AB84-FBB7-3279-BE74-C0194DF2B616}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNIPAddressInformation;

  { methods } 

    procedure CopyTo(&array: TArray<DNIPAddressInformation>; offset: Int32);
    procedure Add(address: DNIPAddressInformation);
    function &Contains(address: DNIPAddressInformation): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNIPAddressInformation>;
    function Remove(address: DNIPAddressInformation): Boolean;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNIPAddressInformation read get_Item; default;
  end;

  TDNIPAddressInformationCollection = class(TDNGenericImport<DNIPAddressInformationCollectionClass, DNIPAddressInformationCollection>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPGlobalPropertiesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A99B32CB-B816-5BBD-A302-60907BA99A63}']
  { static methods } 

    {class} function GetIPGlobalProperties: DNIPGlobalProperties;

  end;

  [DNTypeName('System.Net.NetworkInformation.IPGlobalProperties')]
  DNIPGlobalProperties = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{099AEC96-6CE7-3B1F-8A21-2DA0FE964D9D}']
  { getters & setters } 

    function get_DhcpScopeName: string;
    function get_DomainName: string;
    function get_HostName: string;
    function get_IsWinsProxy: Boolean;
    function get_NodeType: DNNetBiosNodeType;

  { methods } 

    function GetActiveUdpListeners: TArray<DDNC.System.Net.Primitives.DNIPEndPoint>;
    function GetActiveTcpListeners: TArray<DDNC.System.Net.Primitives.DNIPEndPoint>;
    function GetActiveTcpConnections: TArray<DNTcpConnectionInformation>;
    function BeginGetUnicastAddresses(callback: DDNC.System.Private.CoreLib.DNAsyncCallback; state: DDNC.System.Private.CoreLib.DNObject): DDNC.System.Private.CoreLib.DNIAsyncResult;
    function EndGetUnicastAddresses(asyncResult: DDNC.System.Private.CoreLib.DNIAsyncResult): DNUnicastIPAddressInformationCollection;
    function GetTcpIPv4Statistics: DNTcpStatistics;
    function GetTcpIPv6Statistics: DNTcpStatistics;
    function GetUdpIPv4Statistics: DNUdpStatistics;
    function GetUdpIPv6Statistics: DNUdpStatistics;
    function GetIcmpV4Statistics: DNIcmpV4Statistics;
    function GetIcmpV6Statistics: DNIcmpV6Statistics;
    function GetIPv4GlobalStatistics: DNIPGlobalStatistics;
    function GetIPv6GlobalStatistics: DNIPGlobalStatistics;
    function GetUnicastAddresses: DNUnicastIPAddressInformationCollection;
    function GetUnicastAddressesAsync: DDNC.System.Private.CoreLib.DNTask<DNUnicastIPAddressInformationCollection>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DhcpScopeName: string read get_DhcpScopeName;
    property DomainName: string read get_DomainName;
    property HostName: string read get_HostName;
    property IsWinsProxy: Boolean read get_IsWinsProxy;
    property NodeType: DNNetBiosNodeType read get_NodeType;
  end;

  TDNIPGlobalProperties = class(TDNGenericImport<DNIPGlobalPropertiesClass, DNIPGlobalProperties>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPGlobalStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{4346A53B-0BA1-5616-BF6A-49DD620C25CC}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPGlobalStatistics')]
  DNIPGlobalStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{581A4175-897A-3482-8F73-E39E948E2ED3}']
  { getters & setters } 

    function get_DefaultTtl: Int32;
    function get_ForwardingEnabled: Boolean;
    function get_NumberOfInterfaces: Int32;
    function get_NumberOfIPAddresses: Int32;
    function get_OutputPacketRequests: Int64;
    function get_OutputPacketRoutingDiscards: Int64;
    function get_OutputPacketsDiscarded: Int64;
    function get_OutputPacketsWithNoRoute: Int64;
    function get_PacketFragmentFailures: Int64;
    function get_PacketReassembliesRequired: Int64;
    function get_PacketReassemblyFailures: Int64;
    function get_PacketReassemblyTimeout: Int64;
    function get_PacketsFragmented: Int64;
    function get_PacketsReassembled: Int64;
    function get_ReceivedPackets: Int64;
    function get_ReceivedPacketsDelivered: Int64;
    function get_ReceivedPacketsDiscarded: Int64;
    function get_ReceivedPacketsForwarded: Int64;
    function get_ReceivedPacketsWithAddressErrors: Int64;
    function get_ReceivedPacketsWithHeadersErrors: Int64;
    function get_ReceivedPacketsWithUnknownProtocol: Int64;
    function get_NumberOfRoutes: Int32;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DefaultTtl: Int32 read get_DefaultTtl;
    property ForwardingEnabled: Boolean read get_ForwardingEnabled;
    property NumberOfInterfaces: Int32 read get_NumberOfInterfaces;
    property NumberOfIPAddresses: Int32 read get_NumberOfIPAddresses;
    property OutputPacketRequests: Int64 read get_OutputPacketRequests;
    property OutputPacketRoutingDiscards: Int64 read get_OutputPacketRoutingDiscards;
    property OutputPacketsDiscarded: Int64 read get_OutputPacketsDiscarded;
    property OutputPacketsWithNoRoute: Int64 read get_OutputPacketsWithNoRoute;
    property PacketFragmentFailures: Int64 read get_PacketFragmentFailures;
    property PacketReassembliesRequired: Int64 read get_PacketReassembliesRequired;
    property PacketReassemblyFailures: Int64 read get_PacketReassemblyFailures;
    property PacketReassemblyTimeout: Int64 read get_PacketReassemblyTimeout;
    property PacketsFragmented: Int64 read get_PacketsFragmented;
    property PacketsReassembled: Int64 read get_PacketsReassembled;
    property ReceivedPackets: Int64 read get_ReceivedPackets;
    property ReceivedPacketsDelivered: Int64 read get_ReceivedPacketsDelivered;
    property ReceivedPacketsDiscarded: Int64 read get_ReceivedPacketsDiscarded;
    property ReceivedPacketsForwarded: Int64 read get_ReceivedPacketsForwarded;
    property ReceivedPacketsWithAddressErrors: Int64 read get_ReceivedPacketsWithAddressErrors;
    property ReceivedPacketsWithHeadersErrors: Int64 read get_ReceivedPacketsWithHeadersErrors;
    property ReceivedPacketsWithUnknownProtocol: Int64 read get_ReceivedPacketsWithUnknownProtocol;
    property NumberOfRoutes: Int32 read get_NumberOfRoutes;
  end;

  TDNIPGlobalStatistics = class(TDNGenericImport<DNIPGlobalStatisticsClass, DNIPGlobalStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPInterfacePropertiesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{CB91B13C-4079-5AAA-BF7C-639FCC8FB543}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPInterfaceProperties')]
  DNIPInterfaceProperties = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{DB746DEF-21BF-311F-B78E-50C326F92EFA}']
  { getters & setters } 

    function get_IsDnsEnabled: Boolean;
    function get_DnsSuffix: string;
    function get_IsDynamicDnsEnabled: Boolean;
    function get_UnicastAddresses: DNUnicastIPAddressInformationCollection;
    function get_MulticastAddresses: DNMulticastIPAddressInformationCollection;
    function get_AnycastAddresses: DNIPAddressInformationCollection;
    function get_DnsAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection;
    function get_GatewayAddresses: DNGatewayIPAddressInformationCollection;
    function get_DhcpServerAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection;
    function get_WinsServersAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection;

  { methods } 

    function GetIPv4Properties: DNIPv4InterfaceProperties;
    function GetIPv6Properties: DNIPv6InterfaceProperties;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property IsDnsEnabled: Boolean read get_IsDnsEnabled;
    property DnsSuffix: string read get_DnsSuffix;
    property IsDynamicDnsEnabled: Boolean read get_IsDynamicDnsEnabled;
    property UnicastAddresses: DNUnicastIPAddressInformationCollection read get_UnicastAddresses;
    property MulticastAddresses: DNMulticastIPAddressInformationCollection read get_MulticastAddresses;
    property AnycastAddresses: DNIPAddressInformationCollection read get_AnycastAddresses;
    property DnsAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection read get_DnsAddresses;
    property GatewayAddresses: DNGatewayIPAddressInformationCollection read get_GatewayAddresses;
    property DhcpServerAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection read get_DhcpServerAddresses;
    property WinsServersAddresses: DDNC.System.Net.Primitives.DNIPAddressCollection read get_WinsServersAddresses;
  end;

  TDNIPInterfaceProperties = class(TDNGenericImport<DNIPInterfacePropertiesClass, DNIPInterfaceProperties>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPInterfaceStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{4BCF4148-3716-5E57-9E6C-8CE4E29CF14F}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPInterfaceStatistics')]
  DNIPInterfaceStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{91F30C6F-D475-3FA5-AE2B-1C98977CA323}']
  { getters & setters } 

    function get_BytesReceived: Int64;
    function get_BytesSent: Int64;
    function get_IncomingPacketsDiscarded: Int64;
    function get_IncomingPacketsWithErrors: Int64;
    function get_IncomingUnknownProtocolPackets: Int64;
    function get_NonUnicastPacketsReceived: Int64;
    function get_NonUnicastPacketsSent: Int64;
    function get_OutgoingPacketsDiscarded: Int64;
    function get_OutgoingPacketsWithErrors: Int64;
    function get_OutputQueueLength: Int64;
    function get_UnicastPacketsReceived: Int64;
    function get_UnicastPacketsSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property BytesReceived: Int64 read get_BytesReceived;
    property BytesSent: Int64 read get_BytesSent;
    property IncomingPacketsDiscarded: Int64 read get_IncomingPacketsDiscarded;
    property IncomingPacketsWithErrors: Int64 read get_IncomingPacketsWithErrors;
    property IncomingUnknownProtocolPackets: Int64 read get_IncomingUnknownProtocolPackets;
    property NonUnicastPacketsReceived: Int64 read get_NonUnicastPacketsReceived;
    property NonUnicastPacketsSent: Int64 read get_NonUnicastPacketsSent;
    property OutgoingPacketsDiscarded: Int64 read get_OutgoingPacketsDiscarded;
    property OutgoingPacketsWithErrors: Int64 read get_OutgoingPacketsWithErrors;
    property OutputQueueLength: Int64 read get_OutputQueueLength;
    property UnicastPacketsReceived: Int64 read get_UnicastPacketsReceived;
    property UnicastPacketsSent: Int64 read get_UnicastPacketsSent;
  end;

  TDNIPInterfaceStatistics = class(TDNGenericImport<DNIPInterfaceStatisticsClass, DNIPInterfaceStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPv4InterfacePropertiesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{63CE3AD8-6870-50F5-BFEF-B8533D9636E7}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPv4InterfaceProperties')]
  DNIPv4InterfaceProperties = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{54F6CC6E-18A8-31EC-B49B-A74DDD5F0265}']
  { getters & setters } 

    function get_UsesWins: Boolean;
    function get_IsDhcpEnabled: Boolean;
    function get_IsAutomaticPrivateAddressingActive: Boolean;
    function get_IsAutomaticPrivateAddressingEnabled: Boolean;
    function get_Index: Int32;
    function get_IsForwardingEnabled: Boolean;
    function get_Mtu: Int32;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property UsesWins: Boolean read get_UsesWins;
    property IsDhcpEnabled: Boolean read get_IsDhcpEnabled;
    property IsAutomaticPrivateAddressingActive: Boolean read get_IsAutomaticPrivateAddressingActive;
    property IsAutomaticPrivateAddressingEnabled: Boolean read get_IsAutomaticPrivateAddressingEnabled;
    property Index: Int32 read get_Index;
    property IsForwardingEnabled: Boolean read get_IsForwardingEnabled;
    property Mtu: Int32 read get_Mtu;
  end;

  TDNIPv4InterfaceProperties = class(TDNGenericImport<DNIPv4InterfacePropertiesClass, DNIPv4InterfaceProperties>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPv4InterfaceStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7CD98619-AD51-52E5-8C4C-B18881D69DBC}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPv4InterfaceStatistics')]
  DNIPv4InterfaceStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{D6F6E68D-18E4-3E34-9037-B017612DC659}']
  { getters & setters } 

    function get_BytesReceived: Int64;
    function get_BytesSent: Int64;
    function get_IncomingPacketsDiscarded: Int64;
    function get_IncomingPacketsWithErrors: Int64;
    function get_IncomingUnknownProtocolPackets: Int64;
    function get_NonUnicastPacketsReceived: Int64;
    function get_NonUnicastPacketsSent: Int64;
    function get_OutgoingPacketsDiscarded: Int64;
    function get_OutgoingPacketsWithErrors: Int64;
    function get_OutputQueueLength: Int64;
    function get_UnicastPacketsReceived: Int64;
    function get_UnicastPacketsSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property BytesReceived: Int64 read get_BytesReceived;
    property BytesSent: Int64 read get_BytesSent;
    property IncomingPacketsDiscarded: Int64 read get_IncomingPacketsDiscarded;
    property IncomingPacketsWithErrors: Int64 read get_IncomingPacketsWithErrors;
    property IncomingUnknownProtocolPackets: Int64 read get_IncomingUnknownProtocolPackets;
    property NonUnicastPacketsReceived: Int64 read get_NonUnicastPacketsReceived;
    property NonUnicastPacketsSent: Int64 read get_NonUnicastPacketsSent;
    property OutgoingPacketsDiscarded: Int64 read get_OutgoingPacketsDiscarded;
    property OutgoingPacketsWithErrors: Int64 read get_OutgoingPacketsWithErrors;
    property OutputQueueLength: Int64 read get_OutputQueueLength;
    property UnicastPacketsReceived: Int64 read get_UnicastPacketsReceived;
    property UnicastPacketsSent: Int64 read get_UnicastPacketsSent;
  end;

  TDNIPv4InterfaceStatistics = class(TDNGenericImport<DNIPv4InterfaceStatisticsClass, DNIPv4InterfaceStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNIPv6InterfacePropertiesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7BF2B00A-B298-5D9D-A85F-BC5104F8D5F9}']
  end;

  [DNTypeName('System.Net.NetworkInformation.IPv6InterfaceProperties')]
  DNIPv6InterfaceProperties = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3FF292BE-8AB9-3320-B77F-62D8868E1B86}']
  { getters & setters } 

    function get_Index: Int32;
    function get_Mtu: Int32;

  { methods } 

    function GetScopeId(scopeLevel: DNScopeLevel): Int64;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Index: Int32 read get_Index;
    property Mtu: Int32 read get_Mtu;
  end;

  TDNIPv6InterfaceProperties = class(TDNGenericImport<DNIPv6InterfacePropertiesClass, DNIPv6InterfaceProperties>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNMulticastIPAddressInformationCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{7F0F483F-A5ED-5543-B341-494BC9FE65BA}']
  end;

  [DNTypeName('System.Net.NetworkInformation.MulticastIPAddressInformationCollection')]
  DNMulticastIPAddressInformationCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9A327EA5-29F3-3BC5-AE8F-89B28C62CA2D}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNMulticastIPAddressInformation;

  { methods } 

    procedure CopyTo(&array: TArray<DNMulticastIPAddressInformation>; offset: Int32);
    procedure Add(address: DNMulticastIPAddressInformation);
    function &Contains(address: DNMulticastIPAddressInformation): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNMulticastIPAddressInformation>;
    function Remove(address: DNMulticastIPAddressInformation): Boolean;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNMulticastIPAddressInformation read get_Item; default;
  end;

  TDNMulticastIPAddressInformationCollection = class(TDNGenericImport<DNMulticastIPAddressInformationCollectionClass, DNMulticastIPAddressInformationCollection>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNNetworkChangeClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{792EF585-0896-5130-8046-3A497038A1A1}']
  { constructors } 

    {class} function init: DNNetworkChange;

  { static methods } 

    {class} procedure RegisterNetworkChange(nc: DNNetworkChange);

  end;

  [DNTypeName('System.Net.NetworkInformation.NetworkChange')]
  DNNetworkChange = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FF477B54-8906-37AD-8ED8-E62B276AB1E8}']
  { events } 

    {class} procedure add_NetworkAvailabilityChanged(value: DNNetworkAvailabilityChangedEventHandler);
    {class} procedure remove_NetworkAvailabilityChanged(value: DNNetworkAvailabilityChangedEventHandler);
    {class} procedure add_NetworkAddressChanged(value: DNNetworkAddressChangedEventHandler);
    {class} procedure remove_NetworkAddressChanged(value: DNNetworkAddressChangedEventHandler);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNNetworkChange = class(TDNGenericImport<DNNetworkChangeClass, DNNetworkChange>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNNetworkInterfaceClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{6187D2CA-8C0E-5204-9F53-81A190D61CD8}']
  { static getter & setter } 

    {class} function get_IPv6LoopbackInterfaceIndex: Int32;
    {class} function get_LoopbackInterfaceIndex: Int32;

  { static methods } 

    {class} function GetAllNetworkInterfaces: TArray<DNNetworkInterface>;
    {class} function GetIsNetworkAvailable: Boolean;

  { static propertys } 

    {class} property IPv6LoopbackInterfaceIndex: Int32 read get_IPv6LoopbackInterfaceIndex;
    {class} property LoopbackInterfaceIndex: Int32 read get_LoopbackInterfaceIndex;
  end;

  [DNTypeName('System.Net.NetworkInformation.NetworkInterface')]
  DNNetworkInterface = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{D50743D4-A19F-38EA-B483-FB6443E67EE8}']
  { getters & setters } 

    function get_Id: string;
    function get_Name: string;
    function get_Description: string;
    function get_OperationalStatus: DNOperationalStatus;
    function get_Speed: Int64;
    function get_IsReceiveOnly: Boolean;
    function get_SupportsMulticast: Boolean;
    function get_NetworkInterfaceType: DNNetworkInterfaceType;

  { methods } 

    function GetIPProperties: DNIPInterfaceProperties;
    function GetIPStatistics: DNIPInterfaceStatistics;
    function GetIPv4Statistics: DNIPv4InterfaceStatistics;
    function GetPhysicalAddress: DNPhysicalAddress;
    function Supports(networkInterfaceComponent: DNNetworkInterfaceComponent): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Id: string read get_Id;
    property Name: string read get_Name;
    property Description: string read get_Description;
    property OperationalStatus: DNOperationalStatus read get_OperationalStatus;
    property Speed: Int64 read get_Speed;
    property IsReceiveOnly: Boolean read get_IsReceiveOnly;
    property SupportsMulticast: Boolean read get_SupportsMulticast;
    property NetworkInterfaceType: DNNetworkInterfaceType read get_NetworkInterfaceType;
  end;

  TDNNetworkInterface = class(TDNGenericImport<DNNetworkInterfaceClass, DNNetworkInterface>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNPhysicalAddressClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{15D56863-56C8-51B9-939C-2A68504F1800}']
  { constructors } 

    {class} function init(address: TArray<Byte>): DNPhysicalAddress;

  { static fields getter & setter } 

   function __fakeFieldGet_None: DNPhysicalAddress;

  { static fields } 

    {class} property None: DNPhysicalAddress read __fakeFieldGet_None;

  { static methods } 

    {class} function Parse(address: string): DNPhysicalAddress; overload;
    {class} function Parse(address: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>): DNPhysicalAddress; overload;
    {class} function TryParse(address: string; out value: DNPhysicalAddress): Boolean; overload;
    {class} function TryParse(address: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; out value: DNPhysicalAddress): Boolean; overload;

  end;

  [DNTypeName('System.Net.NetworkInformation.PhysicalAddress')]
  DNPhysicalAddress = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E87E6312-1791-3D98-9C8F-81D47B5224CE}']
  { methods } 

    function GetHashCode: Int32;
    function Equals(comparand: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function ToString: string;
    function GetAddressBytes: TArray<Byte>;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNPhysicalAddress = class(TDNGenericImport<DNPhysicalAddressClass, DNPhysicalAddress>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNTcpConnectionInformationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{8CF52B9F-05C5-5E08-9E0A-0B90438C0DC5}']
  end;

  [DNTypeName('System.Net.NetworkInformation.TcpConnectionInformation')]
  DNTcpConnectionInformation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A2AE4655-7C11-3B00-9439-8A46910751D5}']
  { getters & setters } 

    function get_LocalEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint;
    function get_RemoteEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint;
    function get_State: DNTcpState;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property LocalEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint read get_LocalEndPoint;
    property RemoteEndPoint: DDNC.System.Net.Primitives.DNIPEndPoint read get_RemoteEndPoint;
    property State: DNTcpState read get_State;
  end;

  TDNTcpConnectionInformation = class(TDNGenericImport<DNTcpConnectionInformationClass, DNTcpConnectionInformation>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNTcpStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{95F0C3EC-F4A2-5F56-9D54-CA4B6CB101E6}']
  end;

  [DNTypeName('System.Net.NetworkInformation.TcpStatistics')]
  DNTcpStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C1765933-522A-3468-9181-73337C024E16}']
  { getters & setters } 

    function get_ConnectionsAccepted: Int64;
    function get_ConnectionsInitiated: Int64;
    function get_CumulativeConnections: Int64;
    function get_CurrentConnections: Int64;
    function get_ErrorsReceived: Int64;
    function get_FailedConnectionAttempts: Int64;
    function get_MaximumConnections: Int64;
    function get_MaximumTransmissionTimeout: Int64;
    function get_MinimumTransmissionTimeout: Int64;
    function get_ResetConnections: Int64;
    function get_SegmentsReceived: Int64;
    function get_SegmentsResent: Int64;
    function get_SegmentsSent: Int64;
    function get_ResetsSent: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ConnectionsAccepted: Int64 read get_ConnectionsAccepted;
    property ConnectionsInitiated: Int64 read get_ConnectionsInitiated;
    property CumulativeConnections: Int64 read get_CumulativeConnections;
    property CurrentConnections: Int64 read get_CurrentConnections;
    property ErrorsReceived: Int64 read get_ErrorsReceived;
    property FailedConnectionAttempts: Int64 read get_FailedConnectionAttempts;
    property MaximumConnections: Int64 read get_MaximumConnections;
    property MaximumTransmissionTimeout: Int64 read get_MaximumTransmissionTimeout;
    property MinimumTransmissionTimeout: Int64 read get_MinimumTransmissionTimeout;
    property ResetConnections: Int64 read get_ResetConnections;
    property SegmentsReceived: Int64 read get_SegmentsReceived;
    property SegmentsResent: Int64 read get_SegmentsResent;
    property SegmentsSent: Int64 read get_SegmentsSent;
    property ResetsSent: Int64 read get_ResetsSent;
  end;

  TDNTcpStatistics = class(TDNGenericImport<DNTcpStatisticsClass, DNTcpStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNUdpStatisticsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{332B163A-C411-56CB-88AB-3AD5AD1F50EF}']
  end;

  [DNTypeName('System.Net.NetworkInformation.UdpStatistics')]
  DNUdpStatistics = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{44E66D0F-26DE-389A-89DF-138D306050FD}']
  { getters & setters } 

    function get_DatagramsReceived: Int64;
    function get_DatagramsSent: Int64;
    function get_IncomingDatagramsDiscarded: Int64;
    function get_IncomingDatagramsWithErrors: Int64;
    function get_UdpListeners: Int32;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DatagramsReceived: Int64 read get_DatagramsReceived;
    property DatagramsSent: Int64 read get_DatagramsSent;
    property IncomingDatagramsDiscarded: Int64 read get_IncomingDatagramsDiscarded;
    property IncomingDatagramsWithErrors: Int64 read get_IncomingDatagramsWithErrors;
    property UdpListeners: Int32 read get_UdpListeners;
  end;

  TDNUdpStatistics = class(TDNGenericImport<DNUdpStatisticsClass, DNUdpStatistics>) end;

  //-------------namespace: System.Net.NetworkInformation----------------
  DNUnicastIPAddressInformationCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{9C7B60CC-1B9F-50FD-9274-8098978B0535}']
  end;

  [DNTypeName('System.Net.NetworkInformation.UnicastIPAddressInformationCollection')]
  DNUnicastIPAddressInformationCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E7C246B5-0EA9-38CB-B39E-8754A1DA039B}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNUnicastIPAddressInformation;

  { methods } 

    procedure CopyTo(&array: TArray<DNUnicastIPAddressInformation>; offset: Int32);
    procedure Add(address: DNUnicastIPAddressInformation);
    function &Contains(address: DNUnicastIPAddressInformation): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNUnicastIPAddressInformation>;
    function Remove(address: DNUnicastIPAddressInformation): Boolean;
    procedure Clear;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNUnicastIPAddressInformation read get_Item; default;
  end;

  TDNUnicastIPAddressInformationCollection = class(TDNGenericImport<DNUnicastIPAddressInformationCollectionClass, DNUnicastIPAddressInformationCollection>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.NetworkInformation, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
