//----------------------------------------------------------------------------
//  System.Net.Mail.dll: System.Net.Mail, Version=5.0.0.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.Mail
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.Mail;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.ComponentModel.EventBasedAsync,
  DDNC.System.Private.Uri,
  DDNC.System.Collections.Specialized,
  DDNC.System.Net.Primitives,
  DDNC.System.Net.ServicePoint,
  DDNC.System.Security.Cryptography.X509Certificates;

type

{ enums }

  //-------------namespace: System.Net.Mail----------------
  [DNTypeName('System.Net.Mail.DeliveryNotificationOptions')]
  DNDeliveryNotificationOptions = type Integer;
  DNDeliveryNotificationOptionsHelper = record helper for DNDeliveryNotificationOptions
  public const
    None = 0;
    OnSuccess = 1;
    OnFailure = 2;
    Delay = 4;
    Never = 134217728;
  end;


  //-------------namespace: System.Net.Mail----------------
  [DNTypeName('System.Net.Mail.MailPriority')]
  DNMailPriority = type Integer;
  DNMailPriorityHelper = record helper for DNMailPriority
  public const
    Normal = 0;
    Low = 1;
    High = 2;
  end;


  //-------------namespace: System.Net.Mail----------------
  [DNTypeName('System.Net.Mail.SmtpDeliveryFormat')]
  DNSmtpDeliveryFormat = type Integer;
  DNSmtpDeliveryFormatHelper = record helper for DNSmtpDeliveryFormat
  public const
    SevenBit = 0;
    International = 1;
  end;


  //-------------namespace: System.Net.Mail----------------
  [DNTypeName('System.Net.Mail.SmtpDeliveryMethod')]
  DNSmtpDeliveryMethod = type Integer;
  DNSmtpDeliveryMethodHelper = record helper for DNSmtpDeliveryMethod
  public const
    Network = 0;
    SpecifiedPickupDirectory = 1;
    PickupDirectoryFromIis = 2;
  end;


  //-------------namespace: System.Net.Mail----------------
  [DNTypeName('System.Net.Mail.SmtpStatusCode')]
  DNSmtpStatusCode = type Integer;
  DNSmtpStatusCodeHelper = record helper for DNSmtpStatusCode
  public const
    SystemStatus = 211;
    HelpMessage = 214;
    ServiceReady = 220;
    ServiceClosingTransmissionChannel = 221;
    Ok = 250;
    UserNotLocalWillForward = 251;
    CannotVerifyUserWillAttemptDelivery = 252;
    StartMailInput = 354;
    ServiceNotAvailable = 421;
    MailboxBusy = 450;
    LocalErrorInProcessing = 451;
    InsufficientStorage = 452;
    ClientNotPermitted = 454;
    CommandUnrecognized = 500;
    SyntaxError = 501;
    CommandNotImplemented = 502;
    BadCommandSequence = 503;
    CommandParameterNotImplemented = 504;
    MustIssueStartTlsFirst = 530;
    MailboxUnavailable = 550;
    UserNotLocalTryAlternatePath = 551;
    ExceededStorageAllocation = 552;
    MailboxNameNotAllowed = 553;
    TransactionFailed = 554;
    GeneralFailure = -1;
  end;


  //-------------namespace: System.Net.Mime----------------
  [DNTypeName('System.Net.Mime.TransferEncoding')]
  DNTransferEncoding = type Integer;
  DNTransferEncodingHelper = record helper for DNTransferEncoding
  public const
    QuotedPrintable = 0;
    Base64 = 1;
    SevenBit = 2;
    EightBit = 3;
    Unknown = -1;
  end;




type


{ declares }

  DNAlternateViewCollection = interface; // type: System.Net.Mail.AlternateViewCollection, namespace: System.Net.Mail
  DNAttachmentCollection = interface; // type: System.Net.Mail.AttachmentCollection, namespace: System.Net.Mail
  DNLinkedResourceCollection = interface; // type: System.Net.Mail.LinkedResourceCollection, namespace: System.Net.Mail
  DNMailAddressCollection = interface; // type: System.Net.Mail.MailAddressCollection, namespace: System.Net.Mail
  DNSmtpException = interface; // type: System.Net.Mail.SmtpException, namespace: System.Net.Mail
  DNSmtpFailedRecipientException = interface; // type: System.Net.Mail.SmtpFailedRecipientException, namespace: System.Net.Mail
  DNSmtpFailedRecipientsException = interface; // type: System.Net.Mail.SmtpFailedRecipientsException, namespace: System.Net.Mail
  DNAttachmentBase = interface; // type: System.Net.Mail.AttachmentBase, namespace: System.Net.Mail
  DNAlternateView = interface; // type: System.Net.Mail.AlternateView, namespace: System.Net.Mail
  DNAttachment = interface; // type: System.Net.Mail.Attachment, namespace: System.Net.Mail
  DNLinkedResource = interface; // type: System.Net.Mail.LinkedResource, namespace: System.Net.Mail
  DNMailAddress = interface; // type: System.Net.Mail.MailAddress, namespace: System.Net.Mail
  DNMailMessage = interface; // type: System.Net.Mail.MailMessage, namespace: System.Net.Mail
  DNSmtpClient = interface; // type: System.Net.Mail.SmtpClient, namespace: System.Net.Mail
  DNContentDisposition = interface; // type: System.Net.Mime.ContentDisposition, namespace: System.Net.Mime
  DNContentType = interface; // type: System.Net.Mime.ContentType, namespace: System.Net.Mime
  DNDispositionTypeNames = interface; // type: System.Net.Mime.DispositionTypeNames, namespace: System.Net.Mime
  DNMediaTypeNames = interface; // type: System.Net.Mime.MediaTypeNames, namespace: System.Net.Mime
  DNMediaTypeNames_Application = interface; // type: System.Net.Mime.MediaTypeNames+Application, namespace: System.Net.Mime
  DNMediaTypeNames_Image = interface; // type: System.Net.Mime.MediaTypeNames+Image, namespace: System.Net.Mime
  DNMediaTypeNames_Text = interface; // type: System.Net.Mime.MediaTypeNames+Text, namespace: System.Net.Mime

{ delegates }

  [DNTypeName('System.Net.Mail.SendCompletedEventHandler')]
  DNSendCompletedEventHandler = procedure(sender: DDNC.System.Private.CoreLib.DNObject; e: DDNC.System.ComponentModel.EventBasedAsync.DNAsyncCompletedEventArgs) of object;




{ objects }

  //-------------namespace: System.Net.Mail----------------
  DNAlternateViewCollectionClass = interface(DDNC.System.Private.CoreLib.DNCollectionClass<DNAlternateView>)
  ['{07487219-F225-563E-8EAA-73A4070A5B44}']
  end;

  [DNTypeName('System.Net.Mail.AlternateViewCollection')]
  DNAlternateViewCollection = interface(DDNC.System.Private.CoreLib.DNCollection<DNAlternateView>)
  ['{E13F92AA-15AF-3F7C-9FE2-89D2EA826EE7}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    procedure Dispose;
    procedure CopyTo(&array: TArray<DNAlternateView>; index: Int32);
    function &Contains(item: DNAlternateView): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNAlternateView>;
    function IndexOf(item: DNAlternateView): Int32;
    procedure Insert(index: Int32; item: DNAlternateView);
    procedure RemoveAt(index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNAlternateViewCollection = class(TDNGenericImport<DNAlternateViewCollectionClass, DNAlternateViewCollection>) end;

  //-------------namespace: System.Net.Mail----------------
  DNAttachmentCollectionClass = interface(DDNC.System.Private.CoreLib.DNCollectionClass<DNAttachment>)
  ['{0B2DCAFA-C19D-5FAE-BFFA-9C4C087CCCB4}']
  end;

  [DNTypeName('System.Net.Mail.AttachmentCollection')]
  DNAttachmentCollection = interface(DDNC.System.Private.CoreLib.DNCollection<DNAttachment>)
  ['{9F15AFEB-3790-349D-AC11-E0A5B8190374}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    procedure Dispose;
    procedure CopyTo(&array: TArray<DNAttachment>; index: Int32);
    function &Contains(item: DNAttachment): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNAttachment>;
    function IndexOf(item: DNAttachment): Int32;
    procedure Insert(index: Int32; item: DNAttachment);
    procedure RemoveAt(index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNAttachmentCollection = class(TDNGenericImport<DNAttachmentCollectionClass, DNAttachmentCollection>) end;

  //-------------namespace: System.Net.Mail----------------
  DNLinkedResourceCollectionClass = interface(DDNC.System.Private.CoreLib.DNCollectionClass<DNLinkedResource>)
  ['{A78640CA-2FD3-58A9-93A3-3AA3C70561A5}']
  end;

  [DNTypeName('System.Net.Mail.LinkedResourceCollection')]
  DNLinkedResourceCollection = interface(DDNC.System.Private.CoreLib.DNCollection<DNLinkedResource>)
  ['{1320A7A9-5C77-32DF-A2FA-260F1FB5B7E9}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    procedure Dispose;
    procedure CopyTo(&array: TArray<DNLinkedResource>; index: Int32);
    function &Contains(item: DNLinkedResource): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNLinkedResource>;
    function IndexOf(item: DNLinkedResource): Int32;
    procedure Insert(index: Int32; item: DNLinkedResource);
    procedure RemoveAt(index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNLinkedResourceCollection = class(TDNGenericImport<DNLinkedResourceCollectionClass, DNLinkedResourceCollection>) end;

  //-------------namespace: System.Net.Mail----------------
  DNMailAddressCollectionClass = interface(DDNC.System.Private.CoreLib.DNCollectionClass<DNMailAddress>)
  ['{60DEE4FD-0FBB-5604-B4F1-1B37AC61F5D0}']
  { constructors } 

    {class} function init: DNMailAddressCollection;

  end;

  [DNTypeName('System.Net.Mail.MailAddressCollection')]
  DNMailAddressCollection = interface(DDNC.System.Private.CoreLib.DNCollection<DNMailAddress>)
  ['{B7B859EA-EB58-3933-B9A1-9500A9295D1A}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    procedure Add(addresses: string);
    function ToString: string;
    procedure CopyTo(&array: TArray<DNMailAddress>; index: Int32);
    function &Contains(item: DNMailAddress): Boolean;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNMailAddress>;
    function IndexOf(item: DNMailAddress): Int32;
    procedure Insert(index: Int32; item: DNMailAddress);
    procedure RemoveAt(index: Int32);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNMailAddressCollection = class(TDNGenericImport<DNMailAddressCollectionClass, DNMailAddressCollection>) end;

  //-------------namespace: System.Net.Mail----------------
  DNSmtpExceptionClass = interface(DDNC.System.Private.CoreLib.DNExceptionClass)
  ['{AE11E00A-9545-5E8D-8312-2346CE825DC4}']
  { constructors } 

    {class} function init(statusCode: DNSmtpStatusCode): DNSmtpException; overload;
    {class} function init(statusCode: DNSmtpStatusCode; message: string): DNSmtpException; overload;
    {class} function init: DNSmtpException; overload;
    {class} function init(message: string): DNSmtpException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNSmtpException; overload;

  end;

  [DNTypeName('System.Net.Mail.SmtpException')]
  DNSmtpException = interface(DDNC.System.Private.CoreLib.DNException)
  ['{036B333A-EEBA-3F24-94FC-60BA5A6733A4}']
  { getters & setters } 

    function get_StatusCode: DNSmtpStatusCode;
    procedure set_StatusCode(value: DNSmtpStatusCode);
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(serializationInfo: DDNC.System.Private.CoreLib.DNSerializationInfo; streamingContext: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property StatusCode: DNSmtpStatusCode read get_StatusCode write set_StatusCode;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNSmtpException = class(TDNGenericImport<DNSmtpExceptionClass, DNSmtpException>) end;

  //-------------namespace: System.Net.Mail----------------
  DNSmtpFailedRecipientExceptionClass = interface(DNSmtpExceptionClass)
  ['{B3B1C5AE-AD87-5492-945F-FB9EDD53E2DC}']
  { constructors } 

    {class} function init: DNSmtpFailedRecipientException; overload;
    {class} function init(message: string): DNSmtpFailedRecipientException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNSmtpFailedRecipientException; overload;
    {class} function init(statusCode: DNSmtpStatusCode; failedRecipient: string): DNSmtpFailedRecipientException; overload;
    {class} function init(statusCode: DNSmtpStatusCode; failedRecipient: string; serverResponse: string): DNSmtpFailedRecipientException; overload;
    {class} function init(message: string; failedRecipient: string; innerException: DDNC.System.Private.CoreLib.DNException): DNSmtpFailedRecipientException; overload;

  end;

  [DNTypeName('System.Net.Mail.SmtpFailedRecipientException')]
  DNSmtpFailedRecipientException = interface(DNSmtpException)
  ['{D56B05A1-89A6-3D4E-A954-CC6A6F74F52E}']
  { getters & setters } 

    function get_FailedRecipient: string;
    function get_StatusCode: DNSmtpStatusCode;
    procedure set_StatusCode(value: DNSmtpStatusCode);
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(serializationInfo: DDNC.System.Private.CoreLib.DNSerializationInfo; streamingContext: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FailedRecipient: string read get_FailedRecipient;
    property StatusCode: DNSmtpStatusCode read get_StatusCode write set_StatusCode;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNSmtpFailedRecipientException = class(TDNGenericImport<DNSmtpFailedRecipientExceptionClass, DNSmtpFailedRecipientException>) end;

  //-------------namespace: System.Net.Mail----------------
  DNSmtpFailedRecipientsExceptionClass = interface(DNSmtpFailedRecipientExceptionClass)
  ['{31E501C4-37D7-55E5-BBBD-05CC8EF45813}']
  { constructors } 

    {class} function init: DNSmtpFailedRecipientsException; overload;
    {class} function init(message: string): DNSmtpFailedRecipientsException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNSmtpFailedRecipientsException; overload;
    {class} function init(message: string; innerExceptions: TArray<DNSmtpFailedRecipientException>): DNSmtpFailedRecipientsException; overload;

  end;

  [DNTypeName('System.Net.Mail.SmtpFailedRecipientsException')]
  DNSmtpFailedRecipientsException = interface(DNSmtpFailedRecipientException)
  ['{7F1B564F-749E-326C-B15E-11C1458780CE}']
  { getters & setters } 

    function get_InnerExceptions: TArray<DNSmtpFailedRecipientException>;
    function get_FailedRecipient: string;
    function get_StatusCode: DNSmtpStatusCode;
    procedure set_StatusCode(value: DNSmtpStatusCode);
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    procedure GetObjectData(serializationInfo: DDNC.System.Private.CoreLib.DNSerializationInfo; streamingContext: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property InnerExceptions: TArray<DNSmtpFailedRecipientException> read get_InnerExceptions;
    property FailedRecipient: string read get_FailedRecipient;
    property StatusCode: DNSmtpStatusCode read get_StatusCode write set_StatusCode;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNSmtpFailedRecipientsException = class(TDNGenericImport<DNSmtpFailedRecipientsExceptionClass, DNSmtpFailedRecipientsException>) end;

  //-------------namespace: System.Net.Mail----------------
  DNAttachmentBaseClass = interface(DNObjectClass)
  ['{79F33590-51EE-5D85-90BC-0A87D720A53A}']
  end;

  [DNTypeName('System.Net.Mail.AttachmentBase')]
  DNAttachmentBase = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{CF53BF4C-DB8F-3BC6-B3AD-67EC3081EFAA}']
  { getters & setters } 

    function get_ContentStream: DDNC.System.Private.CoreLib.DNStream;
    function get_ContentId: string;
    procedure set_ContentId(value: string);
    function get_ContentType: DNContentType;
    procedure set_ContentType(value: DNContentType);
    function get_TransferEncoding: DNTransferEncoding;
    procedure set_TransferEncoding(value: DNTransferEncoding);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ContentStream: DDNC.System.Private.CoreLib.DNStream read get_ContentStream;
    property ContentId: string read get_ContentId write set_ContentId;
    property ContentType: DNContentType read get_ContentType write set_ContentType;
    property TransferEncoding: DNTransferEncoding read get_TransferEncoding write set_TransferEncoding;
  end;

  TDNAttachmentBase = class(TDNGenericImport<DNAttachmentBaseClass, DNAttachmentBase>) end;

  //-------------namespace: System.Net.Mail----------------
  DNAlternateViewClass = interface(DNAttachmentBaseClass)
  ['{CEE00C08-0F99-5FEB-A942-45A6A3AD2DA4}']
  { constructors } 

    {class} function init(fileName: string): DNAlternateView; overload;
    {class} function init(fileName: string; mediaType: string): DNAlternateView; overload;
    {class} function init(fileName: string; contentType: DNContentType): DNAlternateView; overload;
    {class} function init(contentStream: DDNC.System.Private.CoreLib.DNStream): DNAlternateView; overload;
    {class} function init(contentStream: DDNC.System.Private.CoreLib.DNStream; mediaType: string): DNAlternateView; overload;
    {class} function init(contentStream: DDNC.System.Private.CoreLib.DNStream; contentType: DNContentType): DNAlternateView; overload;

  { static methods } 

    {class} function CreateAlternateViewFromString(content: string): DNAlternateView; overload;
    {class} function CreateAlternateViewFromString(content: string; contentEncoding: DDNC.System.Private.CoreLib.DNEncoding; mediaType: string): DNAlternateView; overload;
    {class} function CreateAlternateViewFromString(content: string; contentType: DNContentType): DNAlternateView; overload;

  end;

  [DNTypeName('System.Net.Mail.AlternateView')]
  DNAlternateView = interface(DNAttachmentBase)
  ['{C920E623-52F8-3C70-B8F4-A35EE62CB109}']
  { getters & setters } 

    function get_LinkedResources: DNLinkedResourceCollection;
    function get_BaseUri: DDNC.System.Private.Uri.DNUri;
    procedure set_BaseUri(value: DDNC.System.Private.Uri.DNUri);
    function get_ContentStream: DDNC.System.Private.CoreLib.DNStream;
    function get_ContentId: string;
    procedure set_ContentId(value: string);
    function get_ContentType: DNContentType;
    procedure set_ContentType(value: DNContentType);
    function get_TransferEncoding: DNTransferEncoding;
    procedure set_TransferEncoding(value: DNTransferEncoding);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property LinkedResources: DNLinkedResourceCollection read get_LinkedResources;
    property BaseUri: DDNC.System.Private.Uri.DNUri read get_BaseUri write set_BaseUri;
    property ContentStream: DDNC.System.Private.CoreLib.DNStream read get_ContentStream;
    property ContentId: string read get_ContentId write set_ContentId;
    property ContentType: DNContentType read get_ContentType write set_ContentType;
    property TransferEncoding: DNTransferEncoding read get_TransferEncoding write set_TransferEncoding;
  end;

  TDNAlternateView = class(TDNGenericImport<DNAlternateViewClass, DNAlternateView>) end;

  //-------------namespace: System.Net.Mail----------------
  DNAttachmentClass = interface(DNAttachmentBaseClass)
  ['{FBEA290B-C39F-5C41-85CF-25457D02B2FB}']
  { constructors } 

    {class} function init(fileName: string): DNAttachment; overload;
    {class} function init(fileName: string; mediaType: string): DNAttachment; overload;
    {class} function init(fileName: string; contentType: DNContentType): DNAttachment; overload;
    {class} function init(contentStream: DDNC.System.Private.CoreLib.DNStream; name: string): DNAttachment; overload;
    {class} function init(contentStream: DDNC.System.Private.CoreLib.DNStream; name: string; mediaType: string): DNAttachment; overload;
    {class} function init(contentStream: DDNC.System.Private.CoreLib.DNStream; contentType: DNContentType): DNAttachment; overload;

  { static methods } 

    {class} function CreateAttachmentFromString(content: string; name: string): DNAttachment; overload;
    {class} function CreateAttachmentFromString(content: string; name: string; contentEncoding: DDNC.System.Private.CoreLib.DNEncoding; mediaType: string): DNAttachment; overload;
    {class} function CreateAttachmentFromString(content: string; contentType: DNContentType): DNAttachment; overload;

  end;

  [DNTypeName('System.Net.Mail.Attachment')]
  DNAttachment = interface(DNAttachmentBase)
  ['{E8E3433C-4242-39AD-A539-619BDDE7C1FB}']
  { getters & setters } 

    function get_Name: string;
    procedure set_Name(value: string);
    function get_NameEncoding: DDNC.System.Private.CoreLib.DNEncoding;
    procedure set_NameEncoding(value: DDNC.System.Private.CoreLib.DNEncoding);
    function get_ContentDisposition: DNContentDisposition;
    function get_ContentStream: DDNC.System.Private.CoreLib.DNStream;
    function get_ContentId: string;
    procedure set_ContentId(value: string);
    function get_ContentType: DNContentType;
    procedure set_ContentType(value: DNContentType);
    function get_TransferEncoding: DNTransferEncoding;
    procedure set_TransferEncoding(value: DNTransferEncoding);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Name: string read get_Name write set_Name;
    property NameEncoding: DDNC.System.Private.CoreLib.DNEncoding read get_NameEncoding write set_NameEncoding;
    property ContentDisposition: DNContentDisposition read get_ContentDisposition;
    property ContentStream: DDNC.System.Private.CoreLib.DNStream read get_ContentStream;
    property ContentId: string read get_ContentId write set_ContentId;
    property ContentType: DNContentType read get_ContentType write set_ContentType;
    property TransferEncoding: DNTransferEncoding read get_TransferEncoding write set_TransferEncoding;
  end;

  TDNAttachment = class(TDNGenericImport<DNAttachmentClass, DNAttachment>) end;

  //-------------namespace: System.Net.Mail----------------
  DNLinkedResourceClass = interface(DNAttachmentBaseClass)
  ['{48C293D1-9635-542A-9F26-3256B56097EC}']
  { constructors } 

    {class} function init(fileName: string): DNLinkedResource; overload;
    {class} function init(fileName: string; mediaType: string): DNLinkedResource; overload;
    {class} function init(fileName: string; contentType: DNContentType): DNLinkedResource; overload;
    {class} function init(contentStream: DDNC.System.Private.CoreLib.DNStream): DNLinkedResource; overload;
    {class} function init(contentStream: DDNC.System.Private.CoreLib.DNStream; mediaType: string): DNLinkedResource; overload;
    {class} function init(contentStream: DDNC.System.Private.CoreLib.DNStream; contentType: DNContentType): DNLinkedResource; overload;

  { static methods } 

    {class} function CreateLinkedResourceFromString(content: string): DNLinkedResource; overload;
    {class} function CreateLinkedResourceFromString(content: string; contentEncoding: DDNC.System.Private.CoreLib.DNEncoding; mediaType: string): DNLinkedResource; overload;
    {class} function CreateLinkedResourceFromString(content: string; contentType: DNContentType): DNLinkedResource; overload;

  end;

  [DNTypeName('System.Net.Mail.LinkedResource')]
  DNLinkedResource = interface(DNAttachmentBase)
  ['{48B79BA3-DC2D-379A-AFB5-C5AB14188FCF}']
  { getters & setters } 

    function get_ContentLink: DDNC.System.Private.Uri.DNUri;
    procedure set_ContentLink(value: DDNC.System.Private.Uri.DNUri);
    function get_ContentStream: DDNC.System.Private.CoreLib.DNStream;
    function get_ContentId: string;
    procedure set_ContentId(value: string);
    function get_ContentType: DNContentType;
    procedure set_ContentType(value: DNContentType);
    function get_TransferEncoding: DNTransferEncoding;
    procedure set_TransferEncoding(value: DNTransferEncoding);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ContentLink: DDNC.System.Private.Uri.DNUri read get_ContentLink write set_ContentLink;
    property ContentStream: DDNC.System.Private.CoreLib.DNStream read get_ContentStream;
    property ContentId: string read get_ContentId write set_ContentId;
    property ContentType: DNContentType read get_ContentType write set_ContentType;
    property TransferEncoding: DNTransferEncoding read get_TransferEncoding write set_TransferEncoding;
  end;

  TDNLinkedResource = class(TDNGenericImport<DNLinkedResourceClass, DNLinkedResource>) end;

  //-------------namespace: System.Net.Mail----------------
  DNMailAddressClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{61B46117-D37B-527A-B5CB-8A3A52E0BBE3}']
  { constructors } 

    {class} function init(address: string): DNMailAddress; overload;
    {class} function init(address: string; displayName: string): DNMailAddress; overload;
    {class} function init(address: string; displayName: string; displayNameEncoding: DDNC.System.Private.CoreLib.DNEncoding): DNMailAddress; overload;

  { static methods } 

    {class} function TryCreate(address: string; out result: DNMailAddress): Boolean; overload;
    {class} function TryCreate(address: string; displayName: string; out result: DNMailAddress): Boolean; overload;
    {class} function TryCreate(address: string; displayName: string; displayNameEncoding: DDNC.System.Private.CoreLib.DNEncoding; out result: DNMailAddress): Boolean; overload;

  end;

  [DNTypeName('System.Net.Mail.MailAddress')]
  DNMailAddress = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{EA03D2D0-FFAD-3C0F-BA86-73C62EDBC5B5}']
  { getters & setters } 

    function get_DisplayName: string;
    function get_User: string;
    function get_Host: string;
    function get_Address: string;

  { methods } 

    function ToString: string;
    function Equals(value: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property DisplayName: string read get_DisplayName;
    property User: string read get_User;
    property Host: string read get_Host;
    property Address: string read get_Address;
  end;

  TDNMailAddress = class(TDNGenericImport<DNMailAddressClass, DNMailAddress>) end;

  //-------------namespace: System.Net.Mail----------------
  DNMailMessageClass = interface(DNObjectClass)
  ['{A9886F19-EE1E-5775-B91B-61BB68734456}']
  { constructors } 

    {class} function init: DNMailMessage; overload;
    {class} function init(from: string; &to: string): DNMailMessage; overload;
    {class} function init(from: string; &to: string; subject: string; body: string): DNMailMessage; overload;
    {class} function init(from: DNMailAddress; &to: DNMailAddress): DNMailMessage; overload;

  end;

  [DNTypeName('System.Net.Mail.MailMessage')]
  DNMailMessage = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{00B9F715-7ECB-30BE-9A62-979D48570B0C}']
  { getters & setters } 

    function get_From: DNMailAddress;
    procedure set_From(value: DNMailAddress);
    function get_Sender: DNMailAddress;
    procedure set_Sender(value: DNMailAddress);
    function get_ReplyTo: DNMailAddress;
    procedure set_ReplyTo(value: DNMailAddress);
    function get_ReplyToList: DNMailAddressCollection;
    function get_To: DNMailAddressCollection;
    function get_Bcc: DNMailAddressCollection;
    function get_CC: DNMailAddressCollection;
    function get_Priority: DNMailPriority;
    procedure set_Priority(value: DNMailPriority);
    function get_DeliveryNotificationOptions: DNDeliveryNotificationOptions;
    procedure set_DeliveryNotificationOptions(value: DNDeliveryNotificationOptions);
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_SubjectEncoding: DDNC.System.Private.CoreLib.DNEncoding;
    procedure set_SubjectEncoding(value: DDNC.System.Private.CoreLib.DNEncoding);
    function get_Headers: DDNC.System.Collections.Specialized.DNNameValueCollection;
    function get_HeadersEncoding: DDNC.System.Private.CoreLib.DNEncoding;
    procedure set_HeadersEncoding(value: DDNC.System.Private.CoreLib.DNEncoding);
    function get_Body: string;
    procedure set_Body(value: string);
    function get_BodyEncoding: DDNC.System.Private.CoreLib.DNEncoding;
    procedure set_BodyEncoding(value: DDNC.System.Private.CoreLib.DNEncoding);
    function get_BodyTransferEncoding: DNTransferEncoding;
    procedure set_BodyTransferEncoding(value: DNTransferEncoding);
    function get_IsBodyHtml: Boolean;
    procedure set_IsBodyHtml(value: Boolean);
    function get_Attachments: DNAttachmentCollection;
    function get_AlternateViews: DNAlternateViewCollection;

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property From: DNMailAddress read get_From write set_From;
    property Sender: DNMailAddress read get_Sender write set_Sender;
    property ReplyTo: DNMailAddress read get_ReplyTo write set_ReplyTo;
    property ReplyToList: DNMailAddressCollection read get_ReplyToList;
    property &To: DNMailAddressCollection read get_To;
    property Bcc: DNMailAddressCollection read get_Bcc;
    property CC: DNMailAddressCollection read get_CC;
    property Priority: DNMailPriority read get_Priority write set_Priority;
    property DeliveryNotificationOptions: DNDeliveryNotificationOptions read get_DeliveryNotificationOptions write set_DeliveryNotificationOptions;
    property Subject: string read get_Subject write set_Subject;
    property SubjectEncoding: DDNC.System.Private.CoreLib.DNEncoding read get_SubjectEncoding write set_SubjectEncoding;
    property Headers: DDNC.System.Collections.Specialized.DNNameValueCollection read get_Headers;
    property HeadersEncoding: DDNC.System.Private.CoreLib.DNEncoding read get_HeadersEncoding write set_HeadersEncoding;
    property Body: string read get_Body write set_Body;
    property BodyEncoding: DDNC.System.Private.CoreLib.DNEncoding read get_BodyEncoding write set_BodyEncoding;
    property BodyTransferEncoding: DNTransferEncoding read get_BodyTransferEncoding write set_BodyTransferEncoding;
    property IsBodyHtml: Boolean read get_IsBodyHtml write set_IsBodyHtml;
    property Attachments: DNAttachmentCollection read get_Attachments;
    property AlternateViews: DNAlternateViewCollection read get_AlternateViews;
  end;

  TDNMailMessage = class(TDNGenericImport<DNMailMessageClass, DNMailMessage>) end;

  //-------------namespace: System.Net.Mail----------------
  DNSmtpClientClass = interface(DNObjectClass)
  ['{0AEA6980-A135-527A-A130-FF68498C4260}']
  { constructors } 

    {class} function init: DNSmtpClient; overload;
    {class} function init(host: string): DNSmtpClient; overload;
    {class} function init(host: string; port: Int32): DNSmtpClient; overload;

  end;

  [DNTypeName('System.Net.Mail.SmtpClient')]
  DNSmtpClient = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{2D647AEE-9D63-3AA4-8C74-36119A1AA2C4}']
  { getters & setters } 

    function get_Host: string;
    procedure set_Host(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_UseDefaultCredentials: Boolean;
    procedure set_UseDefaultCredentials(value: Boolean);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentialsByHost;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentialsByHost);
    function get_Timeout: Int32;
    procedure set_Timeout(value: Int32);
    function get_ServicePoint: DDNC.System.Net.ServicePoint.DNServicePoint;
    function get_DeliveryMethod: DNSmtpDeliveryMethod;
    procedure set_DeliveryMethod(value: DNSmtpDeliveryMethod);
    function get_DeliveryFormat: DNSmtpDeliveryFormat;
    procedure set_DeliveryFormat(value: DNSmtpDeliveryFormat);
    function get_PickupDirectoryLocation: string;
    procedure set_PickupDirectoryLocation(value: string);
    function get_EnableSsl: Boolean;
    procedure set_EnableSsl(value: Boolean);
    function get_ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection;
    function get_TargetName: string;
    procedure set_TargetName(value: string);

  { events } 

    procedure add_SendCompleted(value: DNSendCompletedEventHandler);
    procedure remove_SendCompleted(value: DNSendCompletedEventHandler);

  { methods } 

    procedure Send(from: string; recipients: string; subject: string; body: string); overload;
    procedure Send(message: DNMailMessage); overload;
    procedure SendAsync(from: string; recipients: string; subject: string; body: string; userToken: DDNC.System.Private.CoreLib.DNObject); overload;
    procedure SendAsync(message: DNMailMessage; userToken: DDNC.System.Private.CoreLib.DNObject); overload;
    procedure SendAsyncCancel;
    function SendMailAsync(from: string; recipients: string; subject: string; body: string): DDNC.System.Private.CoreLib.DNTask; overload;
    function SendMailAsync(message: DNMailMessage): DDNC.System.Private.CoreLib.DNTask; overload;
    function SendMailAsync(from: string; recipients: string; subject: string; body: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function SendMailAsync(message: DNMailMessage; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Host: string read get_Host write set_Host;
    property Port: Int32 read get_Port write set_Port;
    property UseDefaultCredentials: Boolean read get_UseDefaultCredentials write set_UseDefaultCredentials;
    property Credentials: DDNC.System.Net.Primitives.DNICredentialsByHost read get_Credentials write set_Credentials;
    property Timeout: Int32 read get_Timeout write set_Timeout;
    property ServicePoint: DDNC.System.Net.ServicePoint.DNServicePoint read get_ServicePoint;
    property DeliveryMethod: DNSmtpDeliveryMethod read get_DeliveryMethod write set_DeliveryMethod;
    property DeliveryFormat: DNSmtpDeliveryFormat read get_DeliveryFormat write set_DeliveryFormat;
    property PickupDirectoryLocation: string read get_PickupDirectoryLocation write set_PickupDirectoryLocation;
    property EnableSsl: Boolean read get_EnableSsl write set_EnableSsl;
    property ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection read get_ClientCertificates;
    property TargetName: string read get_TargetName write set_TargetName;
  end;

  TDNSmtpClient = class(TDNGenericImport<DNSmtpClientClass, DNSmtpClient>) end;

  //-------------namespace: System.Net.Mime----------------
  DNContentDispositionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{A77469E7-D16F-5124-828F-E90B5E385E47}']
  { constructors } 

    {class} function init: DNContentDisposition; overload;
    {class} function init(disposition: string): DNContentDisposition; overload;

  end;

  [DNTypeName('System.Net.Mime.ContentDisposition')]
  DNContentDisposition = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9CA1D0E8-44C1-3EE2-B912-069525443909}']
  { getters & setters } 

    function get_DispositionType: string;
    procedure set_DispositionType(value: string);
    function get_Parameters: DDNC.System.Collections.Specialized.DNStringDictionary;
    function get_FileName: string;
    procedure set_FileName(value: string);
    function get_CreationDate: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_CreationDate(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_ModificationDate: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_ModificationDate(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_Inline: Boolean;
    procedure set_Inline(value: Boolean);
    function get_ReadDate: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_ReadDate(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_Size: Int64;
    procedure set_Size(value: Int64);

  { methods } 

    function ToString: string;
    function Equals(rparam: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property DispositionType: string read get_DispositionType write set_DispositionType;
    property Parameters: DDNC.System.Collections.Specialized.DNStringDictionary read get_Parameters;
    property FileName: string read get_FileName write set_FileName;
    property CreationDate: DDNC.System.Private.CoreLib.DNDateTime read get_CreationDate write set_CreationDate;
    property ModificationDate: DDNC.System.Private.CoreLib.DNDateTime read get_ModificationDate write set_ModificationDate;
    property &Inline: Boolean read get_Inline write set_Inline;
    property ReadDate: DDNC.System.Private.CoreLib.DNDateTime read get_ReadDate write set_ReadDate;
    property Size: Int64 read get_Size write set_Size;
  end;

  TDNContentDisposition = class(TDNGenericImport<DNContentDispositionClass, DNContentDisposition>) end;

  //-------------namespace: System.Net.Mime----------------
  DNContentTypeClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{EE56FEE0-E3E7-5372-B4F7-8A71B606797F}']
  { constructors } 

    {class} function init: DNContentType; overload;
    {class} function init(contentType: string): DNContentType; overload;

  end;

  [DNTypeName('System.Net.Mime.ContentType')]
  DNContentType = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4326DCBC-A51C-3748-8830-14D52B9F215C}']
  { getters & setters } 

    function get_Boundary: string;
    procedure set_Boundary(value: string);
    function get_CharSet: string;
    procedure set_CharSet(value: string);
    function get_MediaType: string;
    procedure set_MediaType(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Parameters: DDNC.System.Collections.Specialized.DNStringDictionary;

  { methods } 

    function ToString: string;
    function Equals(rparam: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Boundary: string read get_Boundary write set_Boundary;
    property CharSet: string read get_CharSet write set_CharSet;
    property MediaType: string read get_MediaType write set_MediaType;
    property Name: string read get_Name write set_Name;
    property Parameters: DDNC.System.Collections.Specialized.DNStringDictionary read get_Parameters;
  end;

  TDNContentType = class(TDNGenericImport<DNContentTypeClass, DNContentType>) end;

  //-------------namespace: System.Net.Mime----------------
  DNDispositionTypeNamesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{C3AD6720-DEF2-56E4-91AB-49D9F1E330E4}']
  end;

  [DNTypeName('System.Net.Mime.DispositionTypeNames')]
  DNDispositionTypeNames = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9BDA1244-8E93-3DAE-8C80-F005E2BBFD46}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDispositionTypeNames = class(TDNGenericImport<DNDispositionTypeNamesClass, DNDispositionTypeNames>)
  public const
   Inline_ = 'inline';
   Attachment = 'attachment';
  end;

  //-------------namespace: System.Net.Mime----------------
  DNMediaTypeNamesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{C76C4947-85D6-5862-A5C3-5D6B2A8FD5AE}']
  end;

  [DNTypeName('System.Net.Mime.MediaTypeNames')]
  DNMediaTypeNames = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3FA0368A-DC3C-31FD-A959-07C07E3E9BDA}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNMediaTypeNames = class(TDNGenericImport<DNMediaTypeNamesClass, DNMediaTypeNames>) end;

  //-------------namespace: System.Net.Mime----------------
  DNMediaTypeNames_ApplicationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{E599CED6-9ECD-5956-9291-2514469C8D71}']
  end;

  [DNTypeName('System.Net.Mime.MediaTypeNames+Application')]
  DNMediaTypeNames_Application = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C51E4A7A-D87C-364F-A867-6AEF59977932}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNMediaTypeNames_Application = class(TDNGenericImport<DNMediaTypeNames_ApplicationClass, DNMediaTypeNames_Application>)
  public const
   Soap = 'application/soap+xml';
   Octet = 'application/octet-stream';
   Rtf = 'application/rtf';
   Pdf = 'application/pdf';
   Zip = 'application/zip';
   Json = 'application/json';
   Xml = 'application/xml';
  end;

  //-------------namespace: System.Net.Mime----------------
  DNMediaTypeNames_ImageClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{EC5426A0-6F55-5743-BAB8-9D82AD17C6D3}']
  end;

  [DNTypeName('System.Net.Mime.MediaTypeNames+Image')]
  DNMediaTypeNames_Image = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{CDFE6223-FC8D-330E-AC4A-CCB7044FB270}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNMediaTypeNames_Image = class(TDNGenericImport<DNMediaTypeNames_ImageClass, DNMediaTypeNames_Image>)
  public const
   Gif = 'image/gif';
   Tiff = 'image/tiff';
   Jpeg = 'image/jpeg';
  end;

  //-------------namespace: System.Net.Mime----------------
  DNMediaTypeNames_TextClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{834BF5E0-BCB3-5D61-AE66-D0FD0FAFD672}']
  end;

  [DNTypeName('System.Net.Mime.MediaTypeNames+Text')]
  DNMediaTypeNames_Text = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B218C8BA-B5CD-3C51-A810-FC9CDD2849D3}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNMediaTypeNames_Text = class(TDNGenericImport<DNMediaTypeNames_TextClass, DNMediaTypeNames_Text>)
  public const
   Plain = 'text/plain';
   Html = 'text/html';
   Xml = 'text/xml';
   RichText = 'text/richtext';
  end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.Mail, Version=5.0.0.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51');

finalization

end.
