//----------------------------------------------------------------------------
//  System.Net.Http.dll: System.Net.Http, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Net.Http
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Net.Http;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Net.Primitives,
  DDNC.System.Private.Uri,
  DDNC.System.Security.Cryptography.X509Certificates,
  DDNC.System.Net.Security;

type

{ enums }

  //-------------namespace: System.Net.Http----------------
  [DNTypeName('System.Net.Http.ClientCertificateOption')]
  DNClientCertificateOption = type Integer;
  DNClientCertificateOptionHelper = record helper for DNClientCertificateOption
  public const
    Manual = 0;
    Automatic = 1;
  end;


  //-------------namespace: System.Net.Http----------------
  [DNTypeName('System.Net.Http.HttpCompletionOption')]
  DNHttpCompletionOption = type Integer;
  DNHttpCompletionOptionHelper = record helper for DNHttpCompletionOption
  public const
    ResponseContentRead = 0;
    ResponseHeadersRead = 1;
  end;


  //-------------namespace: System.Net.Http----------------
  [DNTypeName('System.Net.Http.HttpKeepAlivePingPolicy')]
  DNHttpKeepAlivePingPolicy = type Integer;
  DNHttpKeepAlivePingPolicyHelper = record helper for DNHttpKeepAlivePingPolicy
  public const
    WithActiveRequests = 0;
    Always = 1;
  end;


  //-------------namespace: System.Net.Http----------------
  [DNTypeName('System.Net.Http.HttpVersionPolicy')]
  DNHttpVersionPolicy = type Integer;
  DNHttpVersionPolicyHelper = record helper for DNHttpVersionPolicy
  public const
    RequestVersionOrLower = 0;
    RequestVersionOrHigher = 1;
    RequestVersionExact = 2;
  end;




type


{ declares }

  DNHttpRequestException = interface; // type: System.Net.Http.HttpRequestException, namespace: System.Net.Http
  DNAuthenticationHeaderValue = interface; // type: System.Net.Http.Headers.AuthenticationHeaderValue, namespace: System.Net.Http.Headers
  DNCacheControlHeaderValue = interface; // type: System.Net.Http.Headers.CacheControlHeaderValue, namespace: System.Net.Http.Headers
  DNContentDispositionHeaderValue = interface; // type: System.Net.Http.Headers.ContentDispositionHeaderValue, namespace: System.Net.Http.Headers
  DNContentRangeHeaderValue = interface; // type: System.Net.Http.Headers.ContentRangeHeaderValue, namespace: System.Net.Http.Headers
  DNEntityTagHeaderValue = interface; // type: System.Net.Http.Headers.EntityTagHeaderValue, namespace: System.Net.Http.Headers
  DNHttpHeaders = interface; // type: System.Net.Http.Headers.HttpHeaders, namespace: System.Net.Http.Headers
  DNHttpContentHeaders = interface; // type: System.Net.Http.Headers.HttpContentHeaders, namespace: System.Net.Http.Headers
  DNHttpRequestHeaders = interface; // type: System.Net.Http.Headers.HttpRequestHeaders, namespace: System.Net.Http.Headers
  DNHttpResponseHeaders = interface; // type: System.Net.Http.Headers.HttpResponseHeaders, namespace: System.Net.Http.Headers
  DNHttpHeaderValueCollection<T> = interface; // type: System.Net.Http.Headers.HttpHeaderValueCollection`1, namespace: System.Net.Http.Headers
  DNMediaTypeHeaderValue = interface; // type: System.Net.Http.Headers.MediaTypeHeaderValue, namespace: System.Net.Http.Headers
  DNMediaTypeWithQualityHeaderValue = interface; // type: System.Net.Http.Headers.MediaTypeWithQualityHeaderValue, namespace: System.Net.Http.Headers
  DNNameValueHeaderValue = interface; // type: System.Net.Http.Headers.NameValueHeaderValue, namespace: System.Net.Http.Headers
  DNNameValueWithParametersHeaderValue = interface; // type: System.Net.Http.Headers.NameValueWithParametersHeaderValue, namespace: System.Net.Http.Headers
  DNProductHeaderValue = interface; // type: System.Net.Http.Headers.ProductHeaderValue, namespace: System.Net.Http.Headers
  DNProductInfoHeaderValue = interface; // type: System.Net.Http.Headers.ProductInfoHeaderValue, namespace: System.Net.Http.Headers
  DNRangeConditionHeaderValue = interface; // type: System.Net.Http.Headers.RangeConditionHeaderValue, namespace: System.Net.Http.Headers
  DNRangeHeaderValue = interface; // type: System.Net.Http.Headers.RangeHeaderValue, namespace: System.Net.Http.Headers
  DNRangeItemHeaderValue = interface; // type: System.Net.Http.Headers.RangeItemHeaderValue, namespace: System.Net.Http.Headers
  DNRetryConditionHeaderValue = interface; // type: System.Net.Http.Headers.RetryConditionHeaderValue, namespace: System.Net.Http.Headers
  DNStringWithQualityHeaderValue = interface; // type: System.Net.Http.Headers.StringWithQualityHeaderValue, namespace: System.Net.Http.Headers
  DNTransferCodingHeaderValue = interface; // type: System.Net.Http.Headers.TransferCodingHeaderValue, namespace: System.Net.Http.Headers
  DNTransferCodingWithQualityHeaderValue = interface; // type: System.Net.Http.Headers.TransferCodingWithQualityHeaderValue, namespace: System.Net.Http.Headers
  DNViaHeaderValue = interface; // type: System.Net.Http.Headers.ViaHeaderValue, namespace: System.Net.Http.Headers
  DNWarningHeaderValue = interface; // type: System.Net.Http.Headers.WarningHeaderValue, namespace: System.Net.Http.Headers
  DNHttpContent = interface; // type: System.Net.Http.HttpContent, namespace: System.Net.Http
  DNByteArrayContent = interface; // type: System.Net.Http.ByteArrayContent, namespace: System.Net.Http
  DNFormUrlEncodedContent = interface; // type: System.Net.Http.FormUrlEncodedContent, namespace: System.Net.Http
  DNStringContent = interface; // type: System.Net.Http.StringContent, namespace: System.Net.Http
  DNMultipartContent = interface; // type: System.Net.Http.MultipartContent, namespace: System.Net.Http
  DNMultipartFormDataContent = interface; // type: System.Net.Http.MultipartFormDataContent, namespace: System.Net.Http
  DNReadOnlyMemoryContent = interface; // type: System.Net.Http.ReadOnlyMemoryContent, namespace: System.Net.Http
  DNStreamContent = interface; // type: System.Net.Http.StreamContent, namespace: System.Net.Http
  DNHttpMessageHandler = interface; // type: System.Net.Http.HttpMessageHandler, namespace: System.Net.Http
  DNDelegatingHandler = interface; // type: System.Net.Http.DelegatingHandler, namespace: System.Net.Http
  DNMessageProcessingHandler = interface; // type: System.Net.Http.MessageProcessingHandler, namespace: System.Net.Http
  DNHttpClientHandler = interface; // type: System.Net.Http.HttpClientHandler, namespace: System.Net.Http
  DNSocketsHttpHandler = interface; // type: System.Net.Http.SocketsHttpHandler, namespace: System.Net.Http
  DNHttpMessageInvoker = interface; // type: System.Net.Http.HttpMessageInvoker, namespace: System.Net.Http
  DNHttpClient = interface; // type: System.Net.Http.HttpClient, namespace: System.Net.Http
  DNHttpMethod = interface; // type: System.Net.Http.HttpMethod, namespace: System.Net.Http
  DNHttpRequestMessage = interface; // type: System.Net.Http.HttpRequestMessage, namespace: System.Net.Http
  DNHttpRequestOptions = interface; // type: System.Net.Http.HttpRequestOptions, namespace: System.Net.Http
  DNHttpResponseMessage = interface; // type: System.Net.Http.HttpResponseMessage, namespace: System.Net.Http
  DNSocketsHttpConnectionContext = interface; // type: System.Net.Http.SocketsHttpConnectionContext, namespace: System.Net.Http
  DNSocketsHttpPlaintextStreamFilterContext = interface; // type: System.Net.Http.SocketsHttpPlaintextStreamFilterContext, namespace: System.Net.Http
  DNHttpRequestOptionsKey<TValue> = interface; // type: System.Net.Http.HttpRequestOptionsKey`1, namespace: System.Net.Http

{ delegates }

  [DNTypeName('System.Net.Http.HeaderEncodingSelector`1')]
  DNHeaderEncodingSelector<TContext> = function(headerName: string; context: TContext): DDNC.System.Private.CoreLib.DNEncoding of object;




{ objects }

  //-------------namespace: System.Net.Http----------------
  DNHttpRequestExceptionClass = interface(DDNC.System.Private.CoreLib.DNExceptionClass)
  ['{42BBB756-B245-5B66-9C62-D7B64B824239}']
  { constructors } 

    {class} function init: DNHttpRequestException; overload;
    {class} function init(message: string): DNHttpRequestException; overload;
    {class} function init(message: string; inner: DDNC.System.Private.CoreLib.DNException): DNHttpRequestException; overload;
    {class} function init(message: string; inner: DDNC.System.Private.CoreLib.DNException; statusCode: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Net.Primitives.DNHttpStatusCode>): DNHttpRequestException; overload;

  end;

  [DNTypeName('System.Net.Http.HttpRequestException')]
  DNHttpRequestException = interface(DDNC.System.Private.CoreLib.DNException)
  ['{42FDD27F-611B-3A74-AD83-56AED10D9394}']
  { getters & setters } 

    function get_StatusCode: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Net.Primitives.DNHttpStatusCode>;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;
    procedure set_HResult(value: Int32);

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property StatusCode: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Net.Primitives.DNHttpStatusCode> read get_StatusCode;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult write set_HResult;
  end;

  TDNHttpRequestException = class(TDNGenericImport<DNHttpRequestExceptionClass, DNHttpRequestException>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNAuthenticationHeaderValueClass = interface(DNObjectClass)
  ['{AAA0EA8F-9849-5180-8E74-3C2D042EDD48}']
  { constructors } 

    {class} function init(scheme: string): DNAuthenticationHeaderValue; overload;
    {class} function init(scheme: string; parameter: string): DNAuthenticationHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNAuthenticationHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNAuthenticationHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.AuthenticationHeaderValue')]
  DNAuthenticationHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{23405ADD-4BB1-3F2C-B034-3D29584E2719}']
  { getters & setters } 

    function get_Scheme: string;
    function get_Parameter: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Scheme: string read get_Scheme;
    property Parameter: string read get_Parameter;
  end;

  TDNAuthenticationHeaderValue = class(TDNGenericImport<DNAuthenticationHeaderValueClass, DNAuthenticationHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNCacheControlHeaderValueClass = interface(DNObjectClass)
  ['{369290A6-1718-5854-8986-8292B0F93D35}']
  { constructors } 

    {class} function init: DNCacheControlHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNCacheControlHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNCacheControlHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.CacheControlHeaderValue')]
  DNCacheControlHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{7BB4AC39-8C68-3CB4-8134-A443AC5A4C3E}']
  { getters & setters } 

    function get_NoCache: Boolean;
    procedure set_NoCache(value: Boolean);
    function get_NoCacheHeaders: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_NoStore: Boolean;
    procedure set_NoStore(value: Boolean);
    function get_MaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_MaxAge(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_SharedMaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_SharedMaxAge(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_MaxStale: Boolean;
    procedure set_MaxStale(value: Boolean);
    function get_MaxStaleLimit: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_MaxStaleLimit(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_MinFresh: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_MinFresh(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_NoTransform: Boolean;
    procedure set_NoTransform(value: Boolean);
    function get_OnlyIfCached: Boolean;
    procedure set_OnlyIfCached(value: Boolean);
    function get_Public: Boolean;
    procedure set_Public(value: Boolean);
    function get_Private: Boolean;
    procedure set_Private(value: Boolean);
    function get_PrivateHeaders: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_MustRevalidate: Boolean;
    procedure set_MustRevalidate(value: Boolean);
    function get_ProxyRevalidate: Boolean;
    procedure set_ProxyRevalidate(value: Boolean);
    function get_Extensions: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property NoCache: Boolean read get_NoCache write set_NoCache;
    property NoCacheHeaders: DDNC.System.Private.CoreLib.DNICollection<string> read get_NoCacheHeaders;
    property NoStore: Boolean read get_NoStore write set_NoStore;
    property MaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_MaxAge write set_MaxAge;
    property SharedMaxAge: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_SharedMaxAge write set_SharedMaxAge;
    property MaxStale: Boolean read get_MaxStale write set_MaxStale;
    property MaxStaleLimit: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_MaxStaleLimit write set_MaxStaleLimit;
    property MinFresh: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_MinFresh write set_MinFresh;
    property NoTransform: Boolean read get_NoTransform write set_NoTransform;
    property OnlyIfCached: Boolean read get_OnlyIfCached write set_OnlyIfCached;
    property &Public: Boolean read get_Public write set_Public;
    property &Private: Boolean read get_Private write set_Private;
    property PrivateHeaders: DDNC.System.Private.CoreLib.DNICollection<string> read get_PrivateHeaders;
    property MustRevalidate: Boolean read get_MustRevalidate write set_MustRevalidate;
    property ProxyRevalidate: Boolean read get_ProxyRevalidate write set_ProxyRevalidate;
    property Extensions: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Extensions;
  end;

  TDNCacheControlHeaderValue = class(TDNGenericImport<DNCacheControlHeaderValueClass, DNCacheControlHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNContentDispositionHeaderValueClass = interface(DNObjectClass)
  ['{C0BABC72-9744-5E28-B79D-CCB87BC48E27}']
  { constructors } 

    {class} function init(dispositionType: string): DNContentDispositionHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNContentDispositionHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNContentDispositionHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ContentDispositionHeaderValue')]
  DNContentDispositionHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{E515761D-8723-3E37-B8C2-627835CF9C3B}']
  { getters & setters } 

    function get_DispositionType: string;
    procedure set_DispositionType(value: string);
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_Name: string;
    procedure set_Name(value: string);
    function get_FileName: string;
    procedure set_FileName(value: string);
    function get_FileNameStar: string;
    procedure set_FileNameStar(value: string);
    function get_CreationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_CreationDate(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_ModificationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_ModificationDate(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_ReadDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_ReadDate(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_Size: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    procedure set_Size(value: DDNC.System.Private.CoreLib.DNNullable<Int64>);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property DispositionType: string read get_DispositionType write set_DispositionType;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property Name: string read get_Name write set_Name;
    property FileName: string read get_FileName write set_FileName;
    property FileNameStar: string read get_FileNameStar write set_FileNameStar;
    property CreationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_CreationDate write set_CreationDate;
    property ModificationDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_ModificationDate write set_ModificationDate;
    property ReadDate: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_ReadDate write set_ReadDate;
    property Size: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_Size write set_Size;
  end;

  TDNContentDispositionHeaderValue = class(TDNGenericImport<DNContentDispositionHeaderValueClass, DNContentDispositionHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNContentRangeHeaderValueClass = interface(DNObjectClass)
  ['{0EEACE09-B9B8-5F35-9D3D-39DD97259EA8}']
  { constructors } 

    {class} function init(from: Int64; &to: Int64; length: Int64): DNContentRangeHeaderValue; overload;
    {class} function init(length: Int64): DNContentRangeHeaderValue; overload;
    {class} function init(from: Int64; &to: Int64): DNContentRangeHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNContentRangeHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNContentRangeHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ContentRangeHeaderValue')]
  DNContentRangeHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{C3431A36-6CE9-314E-B942-A7BC0B26FD3D}']
  { getters & setters } 

    function get_Unit: string;
    procedure set_Unit(value: string);
    function get_From: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_To: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_Length: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_HasLength: Boolean;
    function get_HasRange: Boolean;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property &Unit: string read get_Unit write set_Unit;
    property From: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_From;
    property &To: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_To;
    property Length: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_Length;
    property HasLength: Boolean read get_HasLength;
    property HasRange: Boolean read get_HasRange;
  end;

  TDNContentRangeHeaderValue = class(TDNGenericImport<DNContentRangeHeaderValueClass, DNContentRangeHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNEntityTagHeaderValueClass = interface(DNObjectClass)
  ['{D8FE9819-C2DA-5B1F-ACF4-9A4302FC7572}']
  { static getter & setter } 

    {class} function get_Any: DNEntityTagHeaderValue;

  { constructors } 

    {class} function init(tag: string): DNEntityTagHeaderValue; overload;
    {class} function init(tag: string; isWeak: Boolean): DNEntityTagHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNEntityTagHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNEntityTagHeaderValue): Boolean;

  { static propertys } 

    {class} property Any: DNEntityTagHeaderValue read get_Any;
  end;

  [DNTypeName('System.Net.Http.Headers.EntityTagHeaderValue')]
  DNEntityTagHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{F79278C9-D8B4-3493-A6EF-50846D0FB754}']
  { getters & setters } 

    function get_Tag: string;
    function get_IsWeak: Boolean;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Tag: string read get_Tag;
    property IsWeak: Boolean read get_IsWeak;
  end;

  TDNEntityTagHeaderValue = class(TDNGenericImport<DNEntityTagHeaderValueClass, DNEntityTagHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpHeadersClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{FD08FCC3-C9E1-599F-A2E7-9E4FE79ACB9C}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpHeaders')]
  DNHttpHeaders = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8989996A-A55D-3E1D-A622-159B13089446}']
  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function Remove(name: string): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpHeaders = class(TDNGenericImport<DNHttpHeadersClass, DNHttpHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpContentHeadersClass = interface(DNHttpHeadersClass)
  ['{5F1E6825-025C-5A1C-92EC-DDE284DBA54E}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpContentHeaders')]
  DNHttpContentHeaders = interface(DNHttpHeaders)
  ['{CC1480CC-A65C-383B-AF5B-36554EF14F75}']
  { getters & setters } 

    function get_Allow: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_ContentDisposition: DNContentDispositionHeaderValue;
    procedure set_ContentDisposition(value: DNContentDispositionHeaderValue);
    function get_ContentEncoding: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_ContentLanguage: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_ContentLength: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    procedure set_ContentLength(value: DDNC.System.Private.CoreLib.DNNullable<Int64>);
    function get_ContentLocation: DDNC.System.Private.Uri.DNUri;
    procedure set_ContentLocation(value: DDNC.System.Private.Uri.DNUri);
    function get_ContentMD5: TArray<Byte>;
    procedure set_ContentMD5(value: TArray<Byte>);
    function get_ContentRange: DNContentRangeHeaderValue;
    procedure set_ContentRange(value: DNContentRangeHeaderValue);
    function get_ContentType: DNMediaTypeHeaderValue;
    procedure set_ContentType(value: DNMediaTypeHeaderValue);
    function get_Expires: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_Expires(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_LastModified: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_LastModified(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);

  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function Remove(name: string): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Allow: DDNC.System.Private.CoreLib.DNICollection<string> read get_Allow;
    property ContentDisposition: DNContentDispositionHeaderValue read get_ContentDisposition write set_ContentDisposition;
    property ContentEncoding: DDNC.System.Private.CoreLib.DNICollection<string> read get_ContentEncoding;
    property ContentLanguage: DDNC.System.Private.CoreLib.DNICollection<string> read get_ContentLanguage;
    property ContentLength: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_ContentLength write set_ContentLength;
    property ContentLocation: DDNC.System.Private.Uri.DNUri read get_ContentLocation write set_ContentLocation;
    property ContentMD5: TArray<Byte> read get_ContentMD5 write set_ContentMD5;
    property ContentRange: DNContentRangeHeaderValue read get_ContentRange write set_ContentRange;
    property ContentType: DNMediaTypeHeaderValue read get_ContentType write set_ContentType;
    property Expires: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Expires write set_Expires;
    property LastModified: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_LastModified write set_LastModified;
  end;

  TDNHttpContentHeaders = class(TDNGenericImport<DNHttpContentHeadersClass, DNHttpContentHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpRequestHeadersClass = interface(DNHttpHeadersClass)
  ['{B2D150A7-6548-5B8C-AE02-9512BB6CC65A}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpRequestHeaders')]
  DNHttpRequestHeaders = interface(DNHttpHeaders)
  ['{56C2B74C-0672-3E7E-BD5C-18707AD5BC21}']
  { getters & setters } 

    function get_Accept: DNHttpHeaderValueCollection<DNMediaTypeWithQualityHeaderValue>;
    function get_AcceptCharset: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue>;
    function get_AcceptEncoding: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue>;
    function get_AcceptLanguage: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue>;
    function get_Authorization: DNAuthenticationHeaderValue;
    procedure set_Authorization(value: DNAuthenticationHeaderValue);
    function get_Expect: DNHttpHeaderValueCollection<DNNameValueWithParametersHeaderValue>;
    function get_ExpectContinue: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_ExpectContinue(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_From: string;
    procedure set_From(value: string);
    function get_Host: string;
    procedure set_Host(value: string);
    function get_IfMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue>;
    function get_IfModifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_IfModifiedSince(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_IfNoneMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue>;
    function get_IfRange: DNRangeConditionHeaderValue;
    procedure set_IfRange(value: DNRangeConditionHeaderValue);
    function get_IfUnmodifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_IfUnmodifiedSince(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_MaxForwards: DDNC.System.Private.CoreLib.DNNullable<Int32>;
    procedure set_MaxForwards(value: DDNC.System.Private.CoreLib.DNNullable<Int32>);
    function get_ProxyAuthorization: DNAuthenticationHeaderValue;
    procedure set_ProxyAuthorization(value: DNAuthenticationHeaderValue);
    function get_Range: DNRangeHeaderValue;
    procedure set_Range(value: DNRangeHeaderValue);
    function get_Referrer: DDNC.System.Private.Uri.DNUri;
    procedure set_Referrer(value: DDNC.System.Private.Uri.DNUri);
    function get_TE: DNHttpHeaderValueCollection<DNTransferCodingWithQualityHeaderValue>;
    function get_UserAgent: DNHttpHeaderValueCollection<DNProductInfoHeaderValue>;
    function get_CacheControl: DNCacheControlHeaderValue;
    procedure set_CacheControl(value: DNCacheControlHeaderValue);
    function get_Connection: DNHttpHeaderValueCollection<string>;
    function get_ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_ConnectionClose(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_Date(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue>;
    function get_Trailer: DNHttpHeaderValueCollection<string>;
    function get_TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue>;
    function get_TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_TransferEncodingChunked(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue>;
    function get_Via: DNHttpHeaderValueCollection<DNViaHeaderValue>;
    function get_Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue>;

  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function Remove(name: string): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Accept: DNHttpHeaderValueCollection<DNMediaTypeWithQualityHeaderValue> read get_Accept;
    property AcceptCharset: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue> read get_AcceptCharset;
    property AcceptEncoding: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue> read get_AcceptEncoding;
    property AcceptLanguage: DNHttpHeaderValueCollection<DNStringWithQualityHeaderValue> read get_AcceptLanguage;
    property Authorization: DNAuthenticationHeaderValue read get_Authorization write set_Authorization;
    property Expect: DNHttpHeaderValueCollection<DNNameValueWithParametersHeaderValue> read get_Expect;
    property ExpectContinue: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_ExpectContinue write set_ExpectContinue;
    property From: string read get_From write set_From;
    property Host: string read get_Host write set_Host;
    property IfMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue> read get_IfMatch;
    property IfModifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_IfModifiedSince write set_IfModifiedSince;
    property IfNoneMatch: DNHttpHeaderValueCollection<DNEntityTagHeaderValue> read get_IfNoneMatch;
    property IfRange: DNRangeConditionHeaderValue read get_IfRange write set_IfRange;
    property IfUnmodifiedSince: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_IfUnmodifiedSince write set_IfUnmodifiedSince;
    property MaxForwards: DDNC.System.Private.CoreLib.DNNullable<Int32> read get_MaxForwards write set_MaxForwards;
    property ProxyAuthorization: DNAuthenticationHeaderValue read get_ProxyAuthorization write set_ProxyAuthorization;
    property Range: DNRangeHeaderValue read get_Range write set_Range;
    property Referrer: DDNC.System.Private.Uri.DNUri read get_Referrer write set_Referrer;
    property TE: DNHttpHeaderValueCollection<DNTransferCodingWithQualityHeaderValue> read get_TE;
    property UserAgent: DNHttpHeaderValueCollection<DNProductInfoHeaderValue> read get_UserAgent;
    property CacheControl: DNCacheControlHeaderValue read get_CacheControl write set_CacheControl;
    property Connection: DNHttpHeaderValueCollection<string> read get_Connection;
    property ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_ConnectionClose write set_ConnectionClose;
    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date write set_Date;
    property Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue> read get_Pragma;
    property Trailer: DNHttpHeaderValueCollection<string> read get_Trailer;
    property TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue> read get_TransferEncoding;
    property TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_TransferEncodingChunked write set_TransferEncodingChunked;
    property Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue> read get_Upgrade;
    property Via: DNHttpHeaderValueCollection<DNViaHeaderValue> read get_Via;
    property Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue> read get_Warning;
  end;

  TDNHttpRequestHeaders = class(TDNGenericImport<DNHttpRequestHeadersClass, DNHttpRequestHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpResponseHeadersClass = interface(DNHttpHeadersClass)
  ['{C5926E9B-E419-547B-A32D-744C5B0E5CA6}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpResponseHeaders')]
  DNHttpResponseHeaders = interface(DNHttpHeaders)
  ['{955ED730-9245-3343-ABCF-9768E2F5F9A6}']
  { getters & setters } 

    function get_AcceptRanges: DNHttpHeaderValueCollection<string>;
    function get_Age: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;
    procedure set_Age(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>);
    function get_ETag: DNEntityTagHeaderValue;
    procedure set_ETag(value: DNEntityTagHeaderValue);
    function get_Location: DDNC.System.Private.Uri.DNUri;
    procedure set_Location(value: DDNC.System.Private.Uri.DNUri);
    function get_ProxyAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue>;
    function get_RetryAfter: DNRetryConditionHeaderValue;
    procedure set_RetryAfter(value: DNRetryConditionHeaderValue);
    function get_Server: DNHttpHeaderValueCollection<DNProductInfoHeaderValue>;
    function get_Vary: DNHttpHeaderValueCollection<string>;
    function get_WwwAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue>;
    function get_CacheControl: DNCacheControlHeaderValue;
    procedure set_CacheControl(value: DNCacheControlHeaderValue);
    function get_Connection: DNHttpHeaderValueCollection<string>;
    function get_ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_ConnectionClose(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    procedure set_Date(value: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>);
    function get_Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue>;
    function get_Trailer: DNHttpHeaderValueCollection<string>;
    function get_TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue>;
    function get_TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_TransferEncodingChunked(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue>;
    function get_Via: DNHttpHeaderValueCollection<DNViaHeaderValue>;
    function get_Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue>;

  { methods } 

    procedure Add(name: string; value: string); overload;
    procedure Add(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function TryAddWithoutValidation(name: string; value: string): Boolean; overload;
    function TryAddWithoutValidation(name: string; values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean; overload;
    procedure Clear;
    function GetValues(name: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>;
    function TryGetValues(name: string; out values: DDNC.System.Private.CoreLib.DNIEnumerable<string>): Boolean;
    function &Contains(name: string): Boolean;
    function ToString: string;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNIEnumerable<string>>>;
    function Remove(name: string): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AcceptRanges: DNHttpHeaderValueCollection<string> read get_AcceptRanges;
    property Age: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_Age write set_Age;
    property ETag: DNEntityTagHeaderValue read get_ETag write set_ETag;
    property Location: DDNC.System.Private.Uri.DNUri read get_Location write set_Location;
    property ProxyAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue> read get_ProxyAuthenticate;
    property RetryAfter: DNRetryConditionHeaderValue read get_RetryAfter write set_RetryAfter;
    property Server: DNHttpHeaderValueCollection<DNProductInfoHeaderValue> read get_Server;
    property Vary: DNHttpHeaderValueCollection<string> read get_Vary;
    property WwwAuthenticate: DNHttpHeaderValueCollection<DNAuthenticationHeaderValue> read get_WwwAuthenticate;
    property CacheControl: DNCacheControlHeaderValue read get_CacheControl write set_CacheControl;
    property Connection: DNHttpHeaderValueCollection<string> read get_Connection;
    property ConnectionClose: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_ConnectionClose write set_ConnectionClose;
    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date write set_Date;
    property Pragma: DNHttpHeaderValueCollection<DNNameValueHeaderValue> read get_Pragma;
    property Trailer: DNHttpHeaderValueCollection<string> read get_Trailer;
    property TransferEncoding: DNHttpHeaderValueCollection<DNTransferCodingHeaderValue> read get_TransferEncoding;
    property TransferEncodingChunked: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_TransferEncodingChunked write set_TransferEncodingChunked;
    property Upgrade: DNHttpHeaderValueCollection<DNProductHeaderValue> read get_Upgrade;
    property Via: DNHttpHeaderValueCollection<DNViaHeaderValue> read get_Via;
    property Warning: DNHttpHeaderValueCollection<DNWarningHeaderValue> read get_Warning;
  end;

  TDNHttpResponseHeaders = class(TDNGenericImport<DNHttpResponseHeadersClass, DNHttpResponseHeaders>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNHttpHeaderValueCollectionClass<T> = interface(DNObjectClass)
  ['{D9D8731F-39D3-5E05-ACDA-8C1BAC4DB981}']
  end;

  [DNTypeName('System.Net.Http.Headers.HttpHeaderValueCollection`1')]
  DNHttpHeaderValueCollection<T> = interface(DDNC.System.Private.CoreLib.DNICollection<T>)
  ['{5D13F693-67D8-30D9-912B-E51219E36E95}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsReadOnly: Boolean;

  { methods } 

    procedure ParseAdd(input: string);
    function TryParseAdd(input: string): Boolean;
    function &Contains(item: T): Boolean;
    procedure CopyTo(&array: TArray<T>; arrayIndex: Int32);
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<T>;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Count: Int32 read get_Count;
    property IsReadOnly: Boolean read get_IsReadOnly;
  end;

  TDNHttpHeaderValueCollection<T> = class(TDNGenericImport<DNHttpHeaderValueCollectionClass<T>, DNHttpHeaderValueCollection<T>>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNMediaTypeHeaderValueClass = interface(DNObjectClass)
  ['{44CFEE7B-1071-5DE6-BD90-3C918EDC1422}']
  { constructors } 

    {class} function init(mediaType: string): DNMediaTypeHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNMediaTypeHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNMediaTypeHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.MediaTypeHeaderValue')]
  DNMediaTypeHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{0F328508-7517-3742-B442-81E260B7365B}']
  { getters & setters } 

    function get_CharSet: string;
    procedure set_CharSet(value: string);
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_MediaType: string;
    procedure set_MediaType(value: string);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CharSet: string read get_CharSet write set_CharSet;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property MediaType: string read get_MediaType write set_MediaType;
  end;

  TDNMediaTypeHeaderValue = class(TDNGenericImport<DNMediaTypeHeaderValueClass, DNMediaTypeHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNMediaTypeWithQualityHeaderValueClass = interface(DNMediaTypeHeaderValueClass)
  ['{C973DA2B-5C16-58AC-B25A-C13278A408B7}']
  { constructors } 

    {class} function init(mediaType: string): DNMediaTypeWithQualityHeaderValue; overload;
    {class} function init(mediaType: string; quality: Double): DNMediaTypeWithQualityHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNMediaTypeWithQualityHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNMediaTypeWithQualityHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.MediaTypeWithQualityHeaderValue')]
  DNMediaTypeWithQualityHeaderValue = interface(DNMediaTypeHeaderValue)
  ['{CB50B01F-379B-3F46-9EFE-9D588E7BE15E}']
  { getters & setters } 

    function get_Quality: DDNC.System.Private.CoreLib.DNNullable<Double>;
    procedure set_Quality(value: DDNC.System.Private.CoreLib.DNNullable<Double>);
    function get_CharSet: string;
    procedure set_CharSet(value: string);
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_MediaType: string;
    procedure set_MediaType(value: string);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Quality: DDNC.System.Private.CoreLib.DNNullable<Double> read get_Quality write set_Quality;
    property CharSet: string read get_CharSet write set_CharSet;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property MediaType: string read get_MediaType write set_MediaType;
  end;

  TDNMediaTypeWithQualityHeaderValue = class(TDNGenericImport<DNMediaTypeWithQualityHeaderValueClass, DNMediaTypeWithQualityHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNNameValueHeaderValueClass = interface(DNObjectClass)
  ['{D61F6E24-A056-5A22-A178-2C3A7B404CCC}']
  { constructors } 

    {class} function init(name: string): DNNameValueHeaderValue; overload;
    {class} function init(name: string; value: string): DNNameValueHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNNameValueHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNNameValueHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.NameValueHeaderValue')]
  DNNameValueHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{AB060B98-982D-3B19-A275-F1CD7F132214}']
  { getters & setters } 

    function get_Name: string;
    function get_Value: string;
    procedure set_Value(value: string);

  { methods } 

    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Value: string read get_Value write set_Value;
  end;

  TDNNameValueHeaderValue = class(TDNGenericImport<DNNameValueHeaderValueClass, DNNameValueHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNNameValueWithParametersHeaderValueClass = interface(DNNameValueHeaderValueClass)
  ['{E8E4AAF8-25F3-5C94-A861-9C8808B714C3}']
  { constructors } 

    {class} function init(name: string): DNNameValueWithParametersHeaderValue; overload;
    {class} function init(name: string; value: string): DNNameValueWithParametersHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNNameValueWithParametersHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNNameValueWithParametersHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.NameValueWithParametersHeaderValue')]
  DNNameValueWithParametersHeaderValue = interface(DNNameValueHeaderValue)
  ['{635A5D82-224C-3EE7-B8CA-0EFFF319A958}']
  { getters & setters } 

    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;
    function get_Name: string;
    function get_Value: string;
    procedure set_Value(value: string);

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
    property Name: string read get_Name;
    property Value: string read get_Value write set_Value;
  end;

  TDNNameValueWithParametersHeaderValue = class(TDNGenericImport<DNNameValueWithParametersHeaderValueClass, DNNameValueWithParametersHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNProductHeaderValueClass = interface(DNObjectClass)
  ['{BE0F067A-2462-5D38-9F50-AB2559EAE5AE}']
  { constructors } 

    {class} function init(name: string): DNProductHeaderValue; overload;
    {class} function init(name: string; version: string): DNProductHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNProductHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNProductHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ProductHeaderValue')]
  DNProductHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{C644E29A-C8A7-3036-B95D-937D8990C674}']
  { getters & setters } 

    function get_Name: string;
    function get_Version: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Version: string read get_Version;
  end;

  TDNProductHeaderValue = class(TDNGenericImport<DNProductHeaderValueClass, DNProductHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNProductInfoHeaderValueClass = interface(DNObjectClass)
  ['{26C6BA97-C386-5289-9E76-2DC87F617285}']
  { constructors } 

    {class} function init(productName: string; productVersion: string): DNProductInfoHeaderValue; overload;
    {class} function init(product: DNProductHeaderValue): DNProductInfoHeaderValue; overload;
    {class} function init(comment: string): DNProductInfoHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNProductInfoHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNProductInfoHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ProductInfoHeaderValue')]
  DNProductInfoHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{1C471EC3-8C85-3FC6-AF70-F51AB856ECBE}']
  { getters & setters } 

    function get_Product: DNProductHeaderValue;
    function get_Comment: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Product: DNProductHeaderValue read get_Product;
    property Comment: string read get_Comment;
  end;

  TDNProductInfoHeaderValue = class(TDNGenericImport<DNProductInfoHeaderValueClass, DNProductInfoHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRangeConditionHeaderValueClass = interface(DNObjectClass)
  ['{2306A4FD-8544-54DC-A068-7485A7231DDF}']
  { constructors } 

    {class} function init(date: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNRangeConditionHeaderValue; overload;
    {class} function init(entityTag: DNEntityTagHeaderValue): DNRangeConditionHeaderValue; overload;
    {class} function init(entityTag: string): DNRangeConditionHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNRangeConditionHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNRangeConditionHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.RangeConditionHeaderValue')]
  DNRangeConditionHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{2CD0977B-9DFA-3264-9DA1-B70BC592AFF0}']
  { getters & setters } 

    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    function get_EntityTag: DNEntityTagHeaderValue;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date;
    property EntityTag: DNEntityTagHeaderValue read get_EntityTag;
  end;

  TDNRangeConditionHeaderValue = class(TDNGenericImport<DNRangeConditionHeaderValueClass, DNRangeConditionHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRangeHeaderValueClass = interface(DNObjectClass)
  ['{90C5436B-36F5-542A-AD7F-5A39700FAB4F}']
  { constructors } 

    {class} function init: DNRangeHeaderValue; overload;
    {class} function init(from: DDNC.System.Private.CoreLib.DNNullable<Int64>; &to: DDNC.System.Private.CoreLib.DNNullable<Int64>): DNRangeHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNRangeHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNRangeHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.RangeHeaderValue')]
  DNRangeHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{621B8D67-2C45-3489-B2B5-4E45BF294C25}']
  { getters & setters } 

    function get_Unit: string;
    procedure set_Unit(value: string);
    function get_Ranges: DDNC.System.Private.CoreLib.DNICollection<DNRangeItemHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property &Unit: string read get_Unit write set_Unit;
    property Ranges: DDNC.System.Private.CoreLib.DNICollection<DNRangeItemHeaderValue> read get_Ranges;
  end;

  TDNRangeHeaderValue = class(TDNGenericImport<DNRangeHeaderValueClass, DNRangeHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRangeItemHeaderValueClass = interface(DNObjectClass)
  ['{73D38656-C59A-5787-9BC5-4D043C131292}']
  { constructors } 

    {class} function init(from: DDNC.System.Private.CoreLib.DNNullable<Int64>; &to: DDNC.System.Private.CoreLib.DNNullable<Int64>): DNRangeItemHeaderValue;

  end;

  [DNTypeName('System.Net.Http.Headers.RangeItemHeaderValue')]
  DNRangeItemHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{8E1C2C16-047C-3F0A-A4CE-576B34AB4CAA}']
  { getters & setters } 

    function get_From: DDNC.System.Private.CoreLib.DNNullable<Int64>;
    function get_To: DDNC.System.Private.CoreLib.DNNullable<Int64>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property From: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_From;
    property &To: DDNC.System.Private.CoreLib.DNNullable<Int64> read get_To;
  end;

  TDNRangeItemHeaderValue = class(TDNGenericImport<DNRangeItemHeaderValueClass, DNRangeItemHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNRetryConditionHeaderValueClass = interface(DNObjectClass)
  ['{1A29ABD7-6523-58F4-BA57-6FF40E4C0A03}']
  { constructors } 

    {class} function init(date: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNRetryConditionHeaderValue; overload;
    {class} function init(delta: DDNC.System.Private.CoreLib.DNTimeSpan): DNRetryConditionHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNRetryConditionHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNRetryConditionHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.RetryConditionHeaderValue')]
  DNRetryConditionHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{4A546CDE-9DA7-361B-AA44-79FA0061AF0F}']
  { getters & setters } 

    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;
    function get_Delta: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date;
    property Delta: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNTimeSpan> read get_Delta;
  end;

  TDNRetryConditionHeaderValue = class(TDNGenericImport<DNRetryConditionHeaderValueClass, DNRetryConditionHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNStringWithQualityHeaderValueClass = interface(DNObjectClass)
  ['{C640191B-563E-5D8B-8A16-C455AEDAA4D1}']
  { constructors } 

    {class} function init(value: string): DNStringWithQualityHeaderValue; overload;
    {class} function init(value: string; quality: Double): DNStringWithQualityHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNStringWithQualityHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNStringWithQualityHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.StringWithQualityHeaderValue')]
  DNStringWithQualityHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{E7F125D0-F273-3E57-9C29-01CBF7EFFE85}']
  { getters & setters } 

    function get_Value: string;
    function get_Quality: DDNC.System.Private.CoreLib.DNNullable<Double>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Value: string read get_Value;
    property Quality: DDNC.System.Private.CoreLib.DNNullable<Double> read get_Quality;
  end;

  TDNStringWithQualityHeaderValue = class(TDNGenericImport<DNStringWithQualityHeaderValueClass, DNStringWithQualityHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNTransferCodingHeaderValueClass = interface(DNObjectClass)
  ['{33C30A14-4478-54FA-81C3-E641754CDC1A}']
  { constructors } 

    {class} function init(value: string): DNTransferCodingHeaderValue;

  { static methods } 

    {class} function Parse(input: string): DNTransferCodingHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNTransferCodingHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.TransferCodingHeaderValue')]
  DNTransferCodingHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{4A32D02D-57B6-3341-9A2E-D56756CAB2AB}']
  { getters & setters } 

    function get_Value: string;
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Value: string read get_Value;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
  end;

  TDNTransferCodingHeaderValue = class(TDNGenericImport<DNTransferCodingHeaderValueClass, DNTransferCodingHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNTransferCodingWithQualityHeaderValueClass = interface(DNTransferCodingHeaderValueClass)
  ['{49152A01-E4AE-559B-B49D-A4243582150A}']
  { constructors } 

    {class} function init(value: string): DNTransferCodingWithQualityHeaderValue; overload;
    {class} function init(value: string; quality: Double): DNTransferCodingWithQualityHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNTransferCodingWithQualityHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNTransferCodingWithQualityHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.TransferCodingWithQualityHeaderValue')]
  DNTransferCodingWithQualityHeaderValue = interface(DNTransferCodingHeaderValue)
  ['{6B61B2BA-DB4F-34AF-8A66-753B99782C7F}']
  { getters & setters } 

    function get_Quality: DDNC.System.Private.CoreLib.DNNullable<Double>;
    procedure set_Quality(value: DDNC.System.Private.CoreLib.DNNullable<Double>);
    function get_Value: string;
    function get_Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Quality: DDNC.System.Private.CoreLib.DNNullable<Double> read get_Quality write set_Quality;
    property Value: string read get_Value;
    property Parameters: DDNC.System.Private.CoreLib.DNICollection<DNNameValueHeaderValue> read get_Parameters;
  end;

  TDNTransferCodingWithQualityHeaderValue = class(TDNGenericImport<DNTransferCodingWithQualityHeaderValueClass, DNTransferCodingWithQualityHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNViaHeaderValueClass = interface(DNObjectClass)
  ['{39466EC0-719C-5AB6-925F-27012E758DD8}']
  { constructors } 

    {class} function init(protocolVersion: string; receivedBy: string): DNViaHeaderValue; overload;
    {class} function init(protocolVersion: string; receivedBy: string; protocolName: string): DNViaHeaderValue; overload;
    {class} function init(protocolVersion: string; receivedBy: string; protocolName: string; comment: string): DNViaHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNViaHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNViaHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.ViaHeaderValue')]
  DNViaHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{362CCFC6-47AE-3374-B283-A2A6C1D94122}']
  { getters & setters } 

    function get_ProtocolName: string;
    function get_ProtocolVersion: string;
    function get_ReceivedBy: string;
    function get_Comment: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ProtocolName: string read get_ProtocolName;
    property ProtocolVersion: string read get_ProtocolVersion;
    property ReceivedBy: string read get_ReceivedBy;
    property Comment: string read get_Comment;
  end;

  TDNViaHeaderValue = class(TDNGenericImport<DNViaHeaderValueClass, DNViaHeaderValue>) end;

  //-------------namespace: System.Net.Http.Headers----------------
  DNWarningHeaderValueClass = interface(DNObjectClass)
  ['{F9308A77-0720-5CC8-8AD0-AB803A5B162B}']
  { constructors } 

    {class} function init(code: Int32; agent: string; text: string): DNWarningHeaderValue; overload;
    {class} function init(code: Int32; agent: string; text: string; date: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNWarningHeaderValue; overload;

  { static methods } 

    {class} function Parse(input: string): DNWarningHeaderValue;
    {class} function TryParse(input: string; out parsedValue: DNWarningHeaderValue): Boolean;

  end;

  [DNTypeName('System.Net.Http.Headers.WarningHeaderValue')]
  DNWarningHeaderValue = interface(DDNC.System.Private.CoreLib.DNICloneable)
  ['{21B480A2-1163-3352-BD1C-15EDDE4A2C4B}']
  { getters & setters } 

    function get_Code: Int32;
    function get_Agent: string;
    function get_Text: string;
    function get_Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Code: Int32 read get_Code;
    property Agent: string read get_Agent;
    property Text: string read get_Text;
    property Date: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTimeOffset> read get_Date;
  end;

  TDNWarningHeaderValue = class(TDNGenericImport<DNWarningHeaderValueClass, DNWarningHeaderValue>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpContentClass = interface(DNObjectClass)
  ['{F07635B3-4C12-53B4-A5A4-FC6FC6E8BF76}']
  end;

  [DNTypeName('System.Net.Http.HttpContent')]
  DNHttpContent = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{1D4BB14C-FC70-31B4-9ABA-CCFD2AD90100}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsStringAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsByteArrayAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsStream: DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStream(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function ReadAsStreamAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    procedure CopyTo(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken);
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNHttpContent = class(TDNGenericImport<DNHttpContentClass, DNHttpContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNByteArrayContentClass = interface(DNHttpContentClass)
  ['{07FF49FE-F7D5-5F21-9057-FE16CEA603C5}']
  { constructors } 

    {class} function init(content: TArray<Byte>): DNByteArrayContent; overload;
    {class} function init(content: TArray<Byte>; offset: Int32; count: Int32): DNByteArrayContent; overload;

  end;

  [DNTypeName('System.Net.Http.ByteArrayContent')]
  DNByteArrayContent = interface(DNHttpContent)
  ['{972CC05D-065D-3674-B75D-BEFD21844F86}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsStringAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsByteArrayAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsStream: DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStream(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function ReadAsStreamAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    procedure CopyTo(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken);
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNByteArrayContent = class(TDNGenericImport<DNByteArrayContentClass, DNByteArrayContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNFormUrlEncodedContentClass = interface(DNByteArrayContentClass)
  ['{1E18098F-7EAF-59C4-B102-02EA19A4B53D}']
  { constructors } 

    {class} function init(nameValueCollection: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, string>>): DNFormUrlEncodedContent;

  end;

  [DNTypeName('System.Net.Http.FormUrlEncodedContent')]
  DNFormUrlEncodedContent = interface(DNByteArrayContent)
  ['{00D466F5-B8FD-3241-9225-98243A0D0E25}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsStringAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsByteArrayAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsStream: DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStream(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function ReadAsStreamAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    procedure CopyTo(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken);
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNFormUrlEncodedContent = class(TDNGenericImport<DNFormUrlEncodedContentClass, DNFormUrlEncodedContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNStringContentClass = interface(DNByteArrayContentClass)
  ['{B716D978-DEFC-5409-9959-40EB99DB9584}']
  { constructors } 

    {class} function init(content: string): DNStringContent; overload;
    {class} function init(content: string; encoding: DDNC.System.Private.CoreLib.DNEncoding): DNStringContent; overload;
    {class} function init(content: string; encoding: DDNC.System.Private.CoreLib.DNEncoding; mediaType: string): DNStringContent; overload;

  end;

  [DNTypeName('System.Net.Http.StringContent')]
  DNStringContent = interface(DNByteArrayContent)
  ['{4CF123EF-EECB-33AC-BE4C-1BF9EFEB87BD}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsStringAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsByteArrayAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsStream: DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStream(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function ReadAsStreamAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    procedure CopyTo(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken);
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNStringContent = class(TDNGenericImport<DNStringContentClass, DNStringContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNMultipartContentClass = interface(DNHttpContentClass)
  ['{3DD9A70F-AD53-510F-9364-9F9D72779717}']
  { constructors } 

    {class} function init: DNMultipartContent; overload;
    {class} function init(subtype: string): DNMultipartContent; overload;
    {class} function init(subtype: string; boundary: string): DNMultipartContent; overload;

  end;

  [DNTypeName('System.Net.Http.MultipartContent')]
  DNMultipartContent = interface(DNHttpContent)
  ['{14E68B85-8E7A-3787-A172-DFE1100394B5}']
  { getters & setters } 

    function get_HeaderEncodingSelector: DNHeaderEncodingSelector<DNHttpContent>;
    procedure set_HeaderEncodingSelector(value: DNHeaderEncodingSelector<DNHttpContent>);
    function get_Headers: DNHttpContentHeaders;

  { methods } 

    procedure Add(content: DNHttpContent);
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNHttpContent>;
    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsStringAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsByteArrayAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsStream: DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStream(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function ReadAsStreamAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    procedure CopyTo(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken);
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HeaderEncodingSelector: DNHeaderEncodingSelector<DNHttpContent> read get_HeaderEncodingSelector write set_HeaderEncodingSelector;
    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNMultipartContent = class(TDNGenericImport<DNMultipartContentClass, DNMultipartContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNMultipartFormDataContentClass = interface(DNMultipartContentClass)
  ['{E6D0E232-F6E0-5F34-BE2F-FA746317DEFB}']
  { constructors } 

    {class} function init: DNMultipartFormDataContent; overload;
    {class} function init(boundary: string): DNMultipartFormDataContent; overload;

  end;

  [DNTypeName('System.Net.Http.MultipartFormDataContent')]
  DNMultipartFormDataContent = interface(DNMultipartContent)
  ['{D3E81BD5-BF73-3E30-8BA5-E5443727E8AF}']
  { getters & setters } 

    function get_HeaderEncodingSelector: DNHeaderEncodingSelector<DNHttpContent>;
    procedure set_HeaderEncodingSelector(value: DNHeaderEncodingSelector<DNHttpContent>);
    function get_Headers: DNHttpContentHeaders;

  { methods } 

    procedure Add(content: DNHttpContent); overload;
    procedure Add(content: DNHttpContent; name: string); overload;
    procedure Add(content: DNHttpContent; name: string; fileName: string); overload;
    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<DNHttpContent>;
    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsStringAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsByteArrayAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsStream: DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStream(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function ReadAsStreamAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    procedure CopyTo(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken);
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property HeaderEncodingSelector: DNHeaderEncodingSelector<DNHttpContent> read get_HeaderEncodingSelector write set_HeaderEncodingSelector;
    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNMultipartFormDataContent = class(TDNGenericImport<DNMultipartFormDataContentClass, DNMultipartFormDataContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNReadOnlyMemoryContentClass = interface(DNHttpContentClass)
  ['{CD0ECEAE-F7D2-57FD-8228-C1DFD315AB55}']
  { constructors } 

    {class} function init(content: DDNC.System.Private.CoreLib.DNReadOnlyMemory<Byte>): DNReadOnlyMemoryContent;

  end;

  [DNTypeName('System.Net.Http.ReadOnlyMemoryContent')]
  DNReadOnlyMemoryContent = interface(DNHttpContent)
  ['{2887D693-29AF-3E6E-B9F7-F8F1F4CAD53F}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsStringAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsByteArrayAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsStream: DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStream(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function ReadAsStreamAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    procedure CopyTo(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken);
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNReadOnlyMemoryContent = class(TDNGenericImport<DNReadOnlyMemoryContentClass, DNReadOnlyMemoryContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNStreamContentClass = interface(DNHttpContentClass)
  ['{CECA03EB-90BC-5356-BB87-1B080604B809}']
  { constructors } 

    {class} function init(content: DDNC.System.Private.CoreLib.DNStream): DNStreamContent; overload;
    {class} function init(content: DDNC.System.Private.CoreLib.DNStream; bufferSize: Int32): DNStreamContent; overload;

  end;

  [DNTypeName('System.Net.Http.StreamContent')]
  DNStreamContent = interface(DNHttpContent)
  ['{B9155D8A-63BB-32EA-8305-51A7B05002F9}']
  { getters & setters } 

    function get_Headers: DNHttpContentHeaders;

  { methods } 

    function ReadAsStringAsync: DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsStringAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function ReadAsByteArrayAsync: DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsByteArrayAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function ReadAsStream: DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStream(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNStream; overload;
    function ReadAsStreamAsync: DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function ReadAsStreamAsync(cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    procedure CopyTo(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken);
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext): DDNC.System.Private.CoreLib.DNTask; overload;
    function CopyToAsync(stream: DDNC.System.Private.CoreLib.DNStream; context: DDNC.System.Net.Primitives.DNTransportContext; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync: DDNC.System.Private.CoreLib.DNTask; overload;
    function LoadIntoBufferAsync(maxBufferSize: Int64): DDNC.System.Private.CoreLib.DNTask; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Headers: DNHttpContentHeaders read get_Headers;
  end;

  TDNStreamContent = class(TDNGenericImport<DNStreamContentClass, DNStreamContent>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpMessageHandlerClass = interface(DNObjectClass)
  ['{CC29D2BA-9083-555E-8293-A07D8594EEAA}']
  end;

  [DNTypeName('System.Net.Http.HttpMessageHandler')]
  DNHttpMessageHandler = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{C2DC8D4D-0A51-35DD-B5DA-30A573EE8291}']
  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpMessageHandler = class(TDNGenericImport<DNHttpMessageHandlerClass, DNHttpMessageHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNDelegatingHandlerClass = interface(DNHttpMessageHandlerClass)
  ['{9D95D3B5-5267-55C5-92EA-05BB12C08B90}']
  end;

  [DNTypeName('System.Net.Http.DelegatingHandler')]
  DNDelegatingHandler = interface(DNHttpMessageHandler)
  ['{3FECEF4B-EFE3-374B-B986-918A73E8A92E}']
  { getters & setters } 

    function get_InnerHandler: DNHttpMessageHandler;
    procedure set_InnerHandler(value: DNHttpMessageHandler);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property InnerHandler: DNHttpMessageHandler read get_InnerHandler write set_InnerHandler;
  end;

  TDNDelegatingHandler = class(TDNGenericImport<DNDelegatingHandlerClass, DNDelegatingHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNMessageProcessingHandlerClass = interface(DNDelegatingHandlerClass)
  ['{22CE2AF7-E0D1-5174-BEB1-C5BB6A9FBAE4}']
  end;

  [DNTypeName('System.Net.Http.MessageProcessingHandler')]
  DNMessageProcessingHandler = interface(DNDelegatingHandler)
  ['{3A93A256-87D4-301F-9A4E-514190C3887A}']
  { getters & setters } 

    function get_InnerHandler: DNHttpMessageHandler;
    procedure set_InnerHandler(value: DNHttpMessageHandler);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property InnerHandler: DNHttpMessageHandler read get_InnerHandler write set_InnerHandler;
  end;

  TDNMessageProcessingHandler = class(TDNGenericImport<DNMessageProcessingHandlerClass, DNMessageProcessingHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpClientHandlerClass = interface(DNHttpMessageHandlerClass)
  ['{304B2DD5-330A-5940-B1C7-9A1BC053C05C}']
  { static getter & setter } 

    {class} function get_DangerousAcceptAnyServerCertificateValidator: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean>;

  { constructors } 

    {class} function init: DNHttpClientHandler;

  { static propertys } 

    {class} property DangerousAcceptAnyServerCertificateValidator: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean> read get_DangerousAcceptAnyServerCertificateValidator;
  end;

  [DNTypeName('System.Net.Http.HttpClientHandler')]
  DNHttpClientHandler = interface(DNHttpMessageHandler)
  ['{F2450608-4350-3876-95E7-865C0129AA47}']
  { getters & setters } 

    function get_SupportsAutomaticDecompression: Boolean;
    function get_SupportsProxy: Boolean;
    function get_SupportsRedirectConfiguration: Boolean;
    function get_UseCookies: Boolean;
    procedure set_UseCookies(value: Boolean);
    function get_CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer;
    procedure set_CookieContainer(value: DDNC.System.Net.Primitives.DNCookieContainer);
    function get_AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods;
    procedure set_AutomaticDecompression(value: DDNC.System.Net.Primitives.DNDecompressionMethods);
    function get_UseProxy: Boolean;
    procedure set_UseProxy(value: Boolean);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_DefaultProxyCredentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_UseDefaultCredentials: Boolean;
    procedure set_UseDefaultCredentials(value: Boolean);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_AllowAutoRedirect: Boolean;
    procedure set_AllowAutoRedirect(value: Boolean);
    function get_MaxAutomaticRedirections: Int32;
    procedure set_MaxAutomaticRedirections(value: Int32);
    function get_MaxConnectionsPerServer: Int32;
    procedure set_MaxConnectionsPerServer(value: Int32);
    function get_MaxRequestContentBufferSize: Int64;
    procedure set_MaxRequestContentBufferSize(value: Int64);
    function get_MaxResponseHeadersLength: Int32;
    procedure set_MaxResponseHeadersLength(value: Int32);
    function get_ClientCertificateOptions: DNClientCertificateOption;
    procedure set_ClientCertificateOptions(value: DNClientCertificateOption);
    function get_ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection;
    function get_ServerCertificateCustomValidationCallback: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean>;
    procedure set_ServerCertificateCustomValidationCallback(value: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean>);
    function get_CheckCertificateRevocationList: Boolean;
    procedure set_CheckCertificateRevocationList(value: Boolean);
    function get_SslProtocols: DDNC.System.Net.Primitives.DNSslProtocols;
    procedure set_SslProtocols(value: DDNC.System.Net.Primitives.DNSslProtocols);
    function get_Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject>;

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property SupportsAutomaticDecompression: Boolean read get_SupportsAutomaticDecompression;
    property SupportsProxy: Boolean read get_SupportsProxy;
    property SupportsRedirectConfiguration: Boolean read get_SupportsRedirectConfiguration;
    property UseCookies: Boolean read get_UseCookies write set_UseCookies;
    property CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer read get_CookieContainer write set_CookieContainer;
    property AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods read get_AutomaticDecompression write set_AutomaticDecompression;
    property UseProxy: Boolean read get_UseProxy write set_UseProxy;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials read get_DefaultProxyCredentials write set_DefaultProxyCredentials;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property UseDefaultCredentials: Boolean read get_UseDefaultCredentials write set_UseDefaultCredentials;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property AllowAutoRedirect: Boolean read get_AllowAutoRedirect write set_AllowAutoRedirect;
    property MaxAutomaticRedirections: Int32 read get_MaxAutomaticRedirections write set_MaxAutomaticRedirections;
    property MaxConnectionsPerServer: Int32 read get_MaxConnectionsPerServer write set_MaxConnectionsPerServer;
    property MaxRequestContentBufferSize: Int64 read get_MaxRequestContentBufferSize write set_MaxRequestContentBufferSize;
    property MaxResponseHeadersLength: Int32 read get_MaxResponseHeadersLength write set_MaxResponseHeadersLength;
    property ClientCertificateOptions: DNClientCertificateOption read get_ClientCertificateOptions write set_ClientCertificateOptions;
    property ClientCertificates: DDNC.System.Security.Cryptography.X509Certificates.DNX509CertificateCollection read get_ClientCertificates;
    property ServerCertificateCustomValidationCallback: DDNC.System.Private.CoreLib.DNFunc<DNHttpRequestMessage, DDNC.System.Security.Cryptography.X509Certificates.DNX509Certificate2, DDNC.System.Security.Cryptography.X509Certificates.DNX509Chain, DDNC.System.Net.Primitives.DNSslPolicyErrors, Boolean> read get_ServerCertificateCustomValidationCallback write set_ServerCertificateCustomValidationCallback;
    property CheckCertificateRevocationList: Boolean read get_CheckCertificateRevocationList write set_CheckCertificateRevocationList;
    property SslProtocols: DDNC.System.Net.Primitives.DNSslProtocols read get_SslProtocols write set_SslProtocols;
    property Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Properties;
  end;

  TDNHttpClientHandler = class(TDNGenericImport<DNHttpClientHandlerClass, DNHttpClientHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNSocketsHttpHandlerClass = interface(DNHttpMessageHandlerClass)
  ['{FFE22153-D000-5794-B2DA-3E1C82F0B79A}']
  { static getter & setter } 

    {class} function get_IsSupported: Boolean;

  { constructors } 

    {class} function init: DNSocketsHttpHandler;

  { static propertys } 

    {class} property IsSupported: Boolean read get_IsSupported;
  end;

  [DNTypeName('System.Net.Http.SocketsHttpHandler')]
  DNSocketsHttpHandler = interface(DNHttpMessageHandler)
  ['{8563803D-45F6-3D8D-9E8D-DAF421C2F3E7}']
  { getters & setters } 

    function get_UseCookies: Boolean;
    procedure set_UseCookies(value: Boolean);
    function get_CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer;
    procedure set_CookieContainer(value: DDNC.System.Net.Primitives.DNCookieContainer);
    function get_AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods;
    procedure set_AutomaticDecompression(value: DDNC.System.Net.Primitives.DNDecompressionMethods);
    function get_UseProxy: Boolean;
    procedure set_UseProxy(value: Boolean);
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_DefaultProxyCredentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_PreAuthenticate: Boolean;
    procedure set_PreAuthenticate(value: Boolean);
    function get_Credentials: DDNC.System.Net.Primitives.DNICredentials;
    procedure set_Credentials(value: DDNC.System.Net.Primitives.DNICredentials);
    function get_AllowAutoRedirect: Boolean;
    procedure set_AllowAutoRedirect(value: Boolean);
    function get_MaxAutomaticRedirections: Int32;
    procedure set_MaxAutomaticRedirections(value: Int32);
    function get_MaxConnectionsPerServer: Int32;
    procedure set_MaxConnectionsPerServer(value: Int32);
    function get_MaxResponseDrainSize: Int32;
    procedure set_MaxResponseDrainSize(value: Int32);
    function get_ResponseDrainTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_ResponseDrainTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_MaxResponseHeadersLength: Int32;
    procedure set_MaxResponseHeadersLength(value: Int32);
    function get_SslOptions: DDNC.System.Net.Security.DNSslClientAuthenticationOptions;
    procedure set_SslOptions(value: DDNC.System.Net.Security.DNSslClientAuthenticationOptions);
    function get_PooledConnectionLifetime: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PooledConnectionLifetime(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_PooledConnectionIdleTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PooledConnectionIdleTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_ConnectTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_ConnectTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_Expect100ContinueTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Expect100ContinueTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_KeepAlivePingDelay: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_KeepAlivePingDelay(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_KeepAlivePingTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_KeepAlivePingTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_KeepAlivePingPolicy: DNHttpKeepAlivePingPolicy;
    procedure set_KeepAlivePingPolicy(value: DNHttpKeepAlivePingPolicy);
    function get_EnableMultipleHttp2Connections: Boolean;
    procedure set_EnableMultipleHttp2Connections(value: Boolean);
    function get_ConnectCallback: DDNC.System.Private.CoreLib.DNFunc<DNSocketsHttpConnectionContext, DDNC.System.Private.CoreLib.DNCancellationToken, DDNC.System.Private.CoreLib.DNValueTask<DDNC.System.Private.CoreLib.DNStream>>;
    procedure set_ConnectCallback(value: DDNC.System.Private.CoreLib.DNFunc<DNSocketsHttpConnectionContext, DDNC.System.Private.CoreLib.DNCancellationToken, DDNC.System.Private.CoreLib.DNValueTask<DDNC.System.Private.CoreLib.DNStream>>);
    function get_PlaintextStreamFilter: DDNC.System.Private.CoreLib.DNFunc<DNSocketsHttpPlaintextStreamFilterContext, DDNC.System.Private.CoreLib.DNCancellationToken, DDNC.System.Private.CoreLib.DNValueTask<DDNC.System.Private.CoreLib.DNStream>>;
    procedure set_PlaintextStreamFilter(value: DDNC.System.Private.CoreLib.DNFunc<DNSocketsHttpPlaintextStreamFilterContext, DDNC.System.Private.CoreLib.DNCancellationToken, DDNC.System.Private.CoreLib.DNValueTask<DDNC.System.Private.CoreLib.DNStream>>);
    function get_Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function get_RequestHeaderEncodingSelector: DNHeaderEncodingSelector<DNHttpRequestMessage>;
    procedure set_RequestHeaderEncodingSelector(value: DNHeaderEncodingSelector<DNHttpRequestMessage>);
    function get_ResponseHeaderEncodingSelector: DNHeaderEncodingSelector<DNHttpRequestMessage>;
    procedure set_ResponseHeaderEncodingSelector(value: DNHeaderEncodingSelector<DNHttpRequestMessage>);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property UseCookies: Boolean read get_UseCookies write set_UseCookies;
    property CookieContainer: DDNC.System.Net.Primitives.DNCookieContainer read get_CookieContainer write set_CookieContainer;
    property AutomaticDecompression: DDNC.System.Net.Primitives.DNDecompressionMethods read get_AutomaticDecompression write set_AutomaticDecompression;
    property UseProxy: Boolean read get_UseProxy write set_UseProxy;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property DefaultProxyCredentials: DDNC.System.Net.Primitives.DNICredentials read get_DefaultProxyCredentials write set_DefaultProxyCredentials;
    property PreAuthenticate: Boolean read get_PreAuthenticate write set_PreAuthenticate;
    property Credentials: DDNC.System.Net.Primitives.DNICredentials read get_Credentials write set_Credentials;
    property AllowAutoRedirect: Boolean read get_AllowAutoRedirect write set_AllowAutoRedirect;
    property MaxAutomaticRedirections: Int32 read get_MaxAutomaticRedirections write set_MaxAutomaticRedirections;
    property MaxConnectionsPerServer: Int32 read get_MaxConnectionsPerServer write set_MaxConnectionsPerServer;
    property MaxResponseDrainSize: Int32 read get_MaxResponseDrainSize write set_MaxResponseDrainSize;
    property ResponseDrainTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_ResponseDrainTimeout write set_ResponseDrainTimeout;
    property MaxResponseHeadersLength: Int32 read get_MaxResponseHeadersLength write set_MaxResponseHeadersLength;
    property SslOptions: DDNC.System.Net.Security.DNSslClientAuthenticationOptions read get_SslOptions write set_SslOptions;
    property PooledConnectionLifetime: DDNC.System.Private.CoreLib.DNTimeSpan read get_PooledConnectionLifetime write set_PooledConnectionLifetime;
    property PooledConnectionIdleTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_PooledConnectionIdleTimeout write set_PooledConnectionIdleTimeout;
    property ConnectTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_ConnectTimeout write set_ConnectTimeout;
    property Expect100ContinueTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Expect100ContinueTimeout write set_Expect100ContinueTimeout;
    property KeepAlivePingDelay: DDNC.System.Private.CoreLib.DNTimeSpan read get_KeepAlivePingDelay write set_KeepAlivePingDelay;
    property KeepAlivePingTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_KeepAlivePingTimeout write set_KeepAlivePingTimeout;
    property KeepAlivePingPolicy: DNHttpKeepAlivePingPolicy read get_KeepAlivePingPolicy write set_KeepAlivePingPolicy;
    property EnableMultipleHttp2Connections: Boolean read get_EnableMultipleHttp2Connections write set_EnableMultipleHttp2Connections;
    property ConnectCallback: DDNC.System.Private.CoreLib.DNFunc<DNSocketsHttpConnectionContext, DDNC.System.Private.CoreLib.DNCancellationToken, DDNC.System.Private.CoreLib.DNValueTask<DDNC.System.Private.CoreLib.DNStream>> read get_ConnectCallback write set_ConnectCallback;
    property PlaintextStreamFilter: DDNC.System.Private.CoreLib.DNFunc<DNSocketsHttpPlaintextStreamFilterContext, DDNC.System.Private.CoreLib.DNCancellationToken, DDNC.System.Private.CoreLib.DNValueTask<DDNC.System.Private.CoreLib.DNStream>> read get_PlaintextStreamFilter write set_PlaintextStreamFilter;
    property Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Properties;
    property RequestHeaderEncodingSelector: DNHeaderEncodingSelector<DNHttpRequestMessage> read get_RequestHeaderEncodingSelector write set_RequestHeaderEncodingSelector;
    property ResponseHeaderEncodingSelector: DNHeaderEncodingSelector<DNHttpRequestMessage> read get_ResponseHeaderEncodingSelector write set_ResponseHeaderEncodingSelector;
  end;

  TDNSocketsHttpHandler = class(TDNGenericImport<DNSocketsHttpHandlerClass, DNSocketsHttpHandler>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpMessageInvokerClass = interface(DNObjectClass)
  ['{6A214C86-4F5B-5315-8CF3-DB90131AA274}']
  { constructors } 

    {class} function init(handler: DNHttpMessageHandler): DNHttpMessageInvoker; overload;
    {class} function init(handler: DNHttpMessageHandler; disposeHandler: Boolean): DNHttpMessageInvoker; overload;

  end;

  [DNTypeName('System.Net.Http.HttpMessageInvoker')]
  DNHttpMessageInvoker = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{ECD96E91-1C85-347E-98C6-300872BAF64E}']
  { methods } 

    function Send(request: DNHttpRequestMessage; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DNHttpResponseMessage;
    function SendAsync(request: DNHttpRequestMessage; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpMessageInvoker = class(TDNGenericImport<DNHttpMessageInvokerClass, DNHttpMessageInvoker>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpClientClass = interface(DNHttpMessageInvokerClass)
  ['{42C0E6DA-13FA-52EE-9186-CABEA96AE8C9}']
  { static getter & setter } 

    {class} function get_DefaultProxy: DDNC.System.Net.Primitives.DNIWebProxy;
    {class} procedure set_DefaultProxy(value: DDNC.System.Net.Primitives.DNIWebProxy);

  { constructors } 

    {class} function init: DNHttpClient; overload;
    {class} function init(handler: DNHttpMessageHandler): DNHttpClient; overload;
    {class} function init(handler: DNHttpMessageHandler; disposeHandler: Boolean): DNHttpClient; overload;

  { static propertys } 

    {class} property DefaultProxy: DDNC.System.Net.Primitives.DNIWebProxy read get_DefaultProxy write set_DefaultProxy;
  end;

  [DNTypeName('System.Net.Http.HttpClient')]
  DNHttpClient = interface(DNHttpMessageInvoker)
  ['{627E300D-7D7A-371C-8069-06FFC0DBC95D}']
  { getters & setters } 

    function get_DefaultRequestHeaders: DNHttpRequestHeaders;
    function get_DefaultRequestVersion: DDNC.System.Private.CoreLib.DNVersion;
    procedure set_DefaultRequestVersion(value: DDNC.System.Private.CoreLib.DNVersion);
    function get_DefaultVersionPolicy: DNHttpVersionPolicy;
    procedure set_DefaultVersionPolicy(value: DNHttpVersionPolicy);
    function get_BaseAddress: DDNC.System.Private.Uri.DNUri;
    procedure set_BaseAddress(value: DDNC.System.Private.Uri.DNUri);
    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_MaxResponseContentBufferSize: Int64;
    procedure set_MaxResponseContentBufferSize(value: Int64);

  { methods } 

    function GetStringAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function GetStringAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function GetStringAsync(requestUri: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function GetStringAsync(requestUri: DDNC.System.Private.Uri.DNUri; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    function GetByteArrayAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function GetByteArrayAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function GetByteArrayAsync(requestUri: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function GetByteArrayAsync(requestUri: DDNC.System.Private.Uri.DNUri; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>; overload;
    function GetStreamAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function GetStreamAsync(requestUri: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function GetStreamAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function GetStreamAsync(requestUri: DDNC.System.Private.Uri.DNUri; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DDNC.System.Private.CoreLib.DNStream>; overload;
    function GetAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: string; completionOption: DNHttpCompletionOption): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri; completionOption: DNHttpCompletionOption): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: string; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function GetAsync(requestUri: DDNC.System.Private.Uri.DNUri; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: string; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: string; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PostAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: string; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: string; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PutAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: string; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: string; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function PatchAsync(requestUri: DDNC.System.Private.Uri.DNUri; content: DNHttpContent; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: string): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: DDNC.System.Private.Uri.DNUri): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function DeleteAsync(requestUri: DDNC.System.Private.Uri.DNUri; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function Send(request: DNHttpRequestMessage): DNHttpResponseMessage; overload;
    function Send(request: DNHttpRequestMessage; completionOption: DNHttpCompletionOption): DNHttpResponseMessage; overload;
    function Send(request: DNHttpRequestMessage; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DNHttpResponseMessage; overload;
    function Send(request: DNHttpRequestMessage; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DNHttpResponseMessage; overload;
    function SendAsync(request: DNHttpRequestMessage): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage; completionOption: DNHttpCompletionOption): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    function SendAsync(request: DNHttpRequestMessage; completionOption: DNHttpCompletionOption; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<DNHttpResponseMessage>; overload;
    procedure CancelPendingRequests;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DefaultRequestHeaders: DNHttpRequestHeaders read get_DefaultRequestHeaders;
    property DefaultRequestVersion: DDNC.System.Private.CoreLib.DNVersion read get_DefaultRequestVersion write set_DefaultRequestVersion;
    property DefaultVersionPolicy: DNHttpVersionPolicy read get_DefaultVersionPolicy write set_DefaultVersionPolicy;
    property BaseAddress: DDNC.System.Private.Uri.DNUri read get_BaseAddress write set_BaseAddress;
    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
    property MaxResponseContentBufferSize: Int64 read get_MaxResponseContentBufferSize write set_MaxResponseContentBufferSize;
  end;

  TDNHttpClient = class(TDNGenericImport<DNHttpClientClass, DNHttpClient>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpMethodClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{29404C8E-EC04-560E-AAAE-5D29DADD1BEF}']
  { static getter & setter } 

    {class} function get_Get: DNHttpMethod;
    {class} function get_Put: DNHttpMethod;
    {class} function get_Post: DNHttpMethod;
    {class} function get_Delete: DNHttpMethod;
    {class} function get_Head: DNHttpMethod;
    {class} function get_Options: DNHttpMethod;
    {class} function get_Trace: DNHttpMethod;
    {class} function get_Patch: DNHttpMethod;

  { constructors } 

    {class} function init(method: string): DNHttpMethod;

  { static propertys } 

    {class} property Get: DNHttpMethod read get_Get;
    {class} property Put: DNHttpMethod read get_Put;
    {class} property Post: DNHttpMethod read get_Post;
    {class} property Delete: DNHttpMethod read get_Delete;
    {class} property Head: DNHttpMethod read get_Head;
    {class} property Options: DNHttpMethod read get_Options;
    {class} property Trace: DNHttpMethod read get_Trace;
    {class} property Patch: DNHttpMethod read get_Patch;
  end;

  [DNTypeName('System.Net.Http.HttpMethod')]
  DNHttpMethod = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3582BE59-B31B-3C8D-849C-5E6B40DC913A}']
  { getters & setters } 

    function get_Method: string;

  { methods } 

    function Equals(other: DNHttpMethod): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Method: string read get_Method;
  end;

  TDNHttpMethod = class(TDNGenericImport<DNHttpMethodClass, DNHttpMethod>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpRequestMessageClass = interface(DNObjectClass)
  ['{D2FC62C0-45D9-5155-9C59-A9BCD9DA170D}']
  { constructors } 

    {class} function init: DNHttpRequestMessage; overload;
    {class} function init(method: DNHttpMethod; requestUri: DDNC.System.Private.Uri.DNUri): DNHttpRequestMessage; overload;
    {class} function init(method: DNHttpMethod; requestUri: string): DNHttpRequestMessage; overload;

  end;

  [DNTypeName('System.Net.Http.HttpRequestMessage')]
  DNHttpRequestMessage = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{41AE6DFB-9D16-36C0-9101-A0323A1B7E99}']
  { getters & setters } 

    function get_Version: DDNC.System.Private.CoreLib.DNVersion;
    procedure set_Version(value: DDNC.System.Private.CoreLib.DNVersion);
    function get_VersionPolicy: DNHttpVersionPolicy;
    procedure set_VersionPolicy(value: DNHttpVersionPolicy);
    function get_Content: DNHttpContent;
    procedure set_Content(value: DNHttpContent);
    function get_Method: DNHttpMethod;
    procedure set_Method(value: DNHttpMethod);
    function get_RequestUri: DDNC.System.Private.Uri.DNUri;
    procedure set_RequestUri(value: DDNC.System.Private.Uri.DNUri);
    function get_Headers: DNHttpRequestHeaders;
    function get_Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function get_Options: DNHttpRequestOptions;

  { methods } 

    function ToString: string;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Version: DDNC.System.Private.CoreLib.DNVersion read get_Version write set_Version;
    property VersionPolicy: DNHttpVersionPolicy read get_VersionPolicy write set_VersionPolicy;
    property Content: DNHttpContent read get_Content write set_Content;
    property Method: DNHttpMethod read get_Method write set_Method;
    property RequestUri: DDNC.System.Private.Uri.DNUri read get_RequestUri write set_RequestUri;
    property Headers: DNHttpRequestHeaders read get_Headers;
    property Properties: DDNC.System.Private.CoreLib.DNIDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Properties;
    property Options: DNHttpRequestOptions read get_Options;
  end;

  TDNHttpRequestMessage = class(TDNGenericImport<DNHttpRequestMessageClass, DNHttpRequestMessage>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpRequestOptionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{C0BB0617-EB7B-5774-806B-E84CE97CC321}']
  { constructors } 

    {class} function init: DNHttpRequestOptions;

  end;

  [DNTypeName('System.Net.Http.HttpRequestOptions')]
  DNHttpRequestOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9B25F52B-E9DF-3A71-8B42-42D5E77EE6D5}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNHttpRequestOptions = class(TDNGenericImport<DNHttpRequestOptionsClass, DNHttpRequestOptions>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpResponseMessageClass = interface(DNObjectClass)
  ['{5189D191-75CB-5D5C-BAC6-06CFCD7CE4DB}']
  { constructors } 

    {class} function init: DNHttpResponseMessage; overload;
    {class} function init(statusCode: DDNC.System.Net.Primitives.DNHttpStatusCode): DNHttpResponseMessage; overload;

  end;

  [DNTypeName('System.Net.Http.HttpResponseMessage')]
  DNHttpResponseMessage = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{632BA5C4-D374-3F0E-828D-748C392E73A5}']
  { getters & setters } 

    function get_Version: DDNC.System.Private.CoreLib.DNVersion;
    procedure set_Version(value: DDNC.System.Private.CoreLib.DNVersion);
    function get_Content: DNHttpContent;
    procedure set_Content(value: DNHttpContent);
    function get_StatusCode: DDNC.System.Net.Primitives.DNHttpStatusCode;
    procedure set_StatusCode(value: DDNC.System.Net.Primitives.DNHttpStatusCode);
    function get_ReasonPhrase: string;
    procedure set_ReasonPhrase(value: string);
    function get_Headers: DNHttpResponseHeaders;
    function get_TrailingHeaders: DNHttpResponseHeaders;
    function get_RequestMessage: DNHttpRequestMessage;
    procedure set_RequestMessage(value: DNHttpRequestMessage);
    function get_IsSuccessStatusCode: Boolean;

  { methods } 

    function EnsureSuccessStatusCode: DNHttpResponseMessage;
    function ToString: string;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Version: DDNC.System.Private.CoreLib.DNVersion read get_Version write set_Version;
    property Content: DNHttpContent read get_Content write set_Content;
    property StatusCode: DDNC.System.Net.Primitives.DNHttpStatusCode read get_StatusCode write set_StatusCode;
    property ReasonPhrase: string read get_ReasonPhrase write set_ReasonPhrase;
    property Headers: DNHttpResponseHeaders read get_Headers;
    property TrailingHeaders: DNHttpResponseHeaders read get_TrailingHeaders;
    property RequestMessage: DNHttpRequestMessage read get_RequestMessage write set_RequestMessage;
    property IsSuccessStatusCode: Boolean read get_IsSuccessStatusCode;
  end;

  TDNHttpResponseMessage = class(TDNGenericImport<DNHttpResponseMessageClass, DNHttpResponseMessage>) end;

  //-------------namespace: System.Net.Http----------------
  DNSocketsHttpConnectionContextClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{110D1771-AB7B-5689-AB11-57B9071D1923}']
  end;

  [DNTypeName('System.Net.Http.SocketsHttpConnectionContext')]
  DNSocketsHttpConnectionContext = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{90F6F366-4EE9-3C8A-BF99-86AFE773F6F8}']
  { getters & setters } 

    function get_DnsEndPoint: DDNC.System.Net.Primitives.DNDnsEndPoint;
    function get_InitialRequestMessage: DNHttpRequestMessage;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property DnsEndPoint: DDNC.System.Net.Primitives.DNDnsEndPoint read get_DnsEndPoint;
    property InitialRequestMessage: DNHttpRequestMessage read get_InitialRequestMessage;
  end;

  TDNSocketsHttpConnectionContext = class(TDNGenericImport<DNSocketsHttpConnectionContextClass, DNSocketsHttpConnectionContext>) end;

  //-------------namespace: System.Net.Http----------------
  DNSocketsHttpPlaintextStreamFilterContextClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{9478EE21-72C0-5E33-911D-5DEA8636C193}']
  end;

  [DNTypeName('System.Net.Http.SocketsHttpPlaintextStreamFilterContext')]
  DNSocketsHttpPlaintextStreamFilterContext = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0680BA23-7070-305C-8F1F-0DCDBB1C9A56}']
  { getters & setters } 

    function get_PlaintextStream: DDNC.System.Private.CoreLib.DNStream;
    function get_NegotiatedHttpVersion: DDNC.System.Private.CoreLib.DNVersion;
    function get_InitialRequestMessage: DNHttpRequestMessage;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property PlaintextStream: DDNC.System.Private.CoreLib.DNStream read get_PlaintextStream;
    property NegotiatedHttpVersion: DDNC.System.Private.CoreLib.DNVersion read get_NegotiatedHttpVersion;
    property InitialRequestMessage: DNHttpRequestMessage read get_InitialRequestMessage;
  end;

  TDNSocketsHttpPlaintextStreamFilterContext = class(TDNGenericImport<DNSocketsHttpPlaintextStreamFilterContextClass, DNSocketsHttpPlaintextStreamFilterContext>) end;

  //-------------namespace: System.Net.Http----------------
  DNHttpRequestOptionsKeyClass<TValue> = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{AE5E7324-83DB-5CE1-ACED-DD4E7DD27EB1}']
  { constructors } 

    {class} function init(key: string): DNHttpRequestOptionsKey<TValue>;

  end;

  [DNTypeName('System.Net.Http.HttpRequestOptionsKey`1')]
  DNHttpRequestOptionsKey<TValue> = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{C53BB56B-C457-399C-A65E-25D26D70C261}']
  { getters & setters } 

    function get_Key: string;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Key: string read get_Key;
  end;

  TDNHttpRequestOptionsKey<TValue> = class(TDNGenericImport<DNHttpRequestOptionsKeyClass<TValue>, DNHttpRequestOptionsKey<TValue>>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Net.Http, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
