//----------------------------------------------------------------------------
//  System.Memory.dll: System.Memory, Version=5.0.0.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Memory
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Memory;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type


{ declares }

  DNIBufferWriter<T> = interface; // type: System.Buffers.IBufferWriter`1, namespace: System.Buffers
  DNArrayBufferWriter<T> = interface; // type: System.Buffers.ArrayBufferWriter`1, namespace: System.Buffers
  DNBuffersExtensions = interface; // type: System.Buffers.BuffersExtensions, namespace: System.Buffers
  DNMemoryPool<T> = interface; // type: System.Buffers.MemoryPool`1, namespace: System.Buffers
  DNReadOnlySequenceSegment<T> = interface; // type: System.Buffers.ReadOnlySequenceSegment`1, namespace: System.Buffers
  DNSequenceReaderExtensions = interface; // type: System.Buffers.SequenceReaderExtensions, namespace: System.Buffers
  DNBase64 = interface; // type: System.Buffers.Text.Base64, namespace: System.Buffers.Text
  DNSequenceMarshal = interface; // type: System.Runtime.InteropServices.SequenceMarshal, namespace: System.Runtime.InteropServices
  DNEncodingExtensions = interface; // type: System.Text.EncodingExtensions, namespace: System.Text
  DNReadOnlySequence<T> = interface; // type: System.Buffers.ReadOnlySequence`1, namespace: System.Buffers
  DNReadOnlySequence_Enumerator<T> = interface; // type: System.Buffers.ReadOnlySequence`1+Enumerator, namespace: System.Buffers
  DNSequenceReader<T> = interface; // type: System.Buffers.SequenceReader`1, namespace: System.Buffers
  DNSequencePosition = interface; // type: System.SequencePosition, namespace: System


{ objects }

  //-------------namespace: System.Buffers----------------
  [DNTypeName('System.Buffers.IBufferWriter`1')]
  DNIBufferWriter<T> = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{89472571-765F-32B2-945C-CEF8AE50EF89}']
  { methods } 

    procedure Advance(count: Int32);
    function GetMemory(sizeHint: Int32): DDNC.System.Private.CoreLib.DNMemory<T>;
    function GetSpan(sizeHint: Int32): DDNC.System.Private.CoreLib.DNSpan<T>;

  end;

  //-------------namespace: System.Buffers----------------
  DNArrayBufferWriterClass<T> = interface(DNObjectClass)
  ['{0662E4AB-7085-5E75-B44D-94E55C40A129}']
  { constructors } 

    {class} function init: DNArrayBufferWriter<T>; overload;
    {class} function init(initialCapacity: Int32): DNArrayBufferWriter<T>; overload;

  end;

  [DNTypeName('System.Buffers.ArrayBufferWriter`1')]
  DNArrayBufferWriter<T> = interface(DNIBufferWriter<T>)
  ['{844D700C-F68C-3853-B1CD-C33B586BD4BD}']
  { getters & setters } 

    function get_WrittenMemory: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T>;
    function get_WrittenSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>;
    function get_WrittenCount: Int32;
    function get_Capacity: Int32;
    function get_FreeCapacity: Int32;

  { methods } 

    procedure Clear;
    procedure Advance(count: Int32);
    function GetMemory(sizeHint: Int32): DDNC.System.Private.CoreLib.DNMemory<T>;
    function GetSpan(sizeHint: Int32): DDNC.System.Private.CoreLib.DNSpan<T>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property WrittenMemory: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T> read get_WrittenMemory;
    property WrittenSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<T> read get_WrittenSpan;
    property WrittenCount: Int32 read get_WrittenCount;
    property Capacity: Int32 read get_Capacity;
    property FreeCapacity: Int32 read get_FreeCapacity;
  end;

  TDNArrayBufferWriter<T> = class(TDNGenericImport<DNArrayBufferWriterClass<T>, DNArrayBufferWriter<T>>) end;

  //-------------namespace: System.Buffers----------------
  DNBuffersExtensionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0226ABDC-1CF5-50BA-843A-2FD6C8AFBA0B}']
  end;

  [DNTypeName('System.Buffers.BuffersExtensions')]
  DNBuffersExtensions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7DC59FCD-2ADF-37E1-9B88-A94A34683E1F}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNBuffersExtensions = class(TDNGenericImport<DNBuffersExtensionsClass, DNBuffersExtensions>) end;

  //-------------namespace: System.Buffers----------------
  DNMemoryPoolClass<T> = interface(DNObjectClass)
  ['{4F96D049-532D-52DD-8B0E-338CE04B6839}']
  { static getter & setter } 

    {class} function get_Shared: DNMemoryPool<T>;

  { static propertys } 

    {class} property Shared: DNMemoryPool<T> read get_Shared;
  end;

  [DNTypeName('System.Buffers.MemoryPool`1')]
  DNMemoryPool<T> = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{1E4C8664-5673-3E22-AE1C-BC834FADF150}']
  { getters & setters } 

    function get_MaxBufferSize: Int32;

  { methods } 

    function Rent(minBufferSize: Int32): DDNC.System.Private.CoreLib.DNIMemoryOwner<T>;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property MaxBufferSize: Int32 read get_MaxBufferSize;
  end;

  TDNMemoryPool<T> = class(TDNGenericImport<DNMemoryPoolClass<T>, DNMemoryPool<T>>) end;

  //-------------namespace: System.Buffers----------------
  DNReadOnlySequenceSegmentClass<T> = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{F7A7DE50-39E6-5393-A2B5-C8589164C3A5}']
  end;

  [DNTypeName('System.Buffers.ReadOnlySequenceSegment`1')]
  DNReadOnlySequenceSegment<T> = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7F09E711-07EB-3930-B136-07CB4D1AA38E}']
  { getters & setters } 

    function get_Memory: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T>;
    function get_Next: DNReadOnlySequenceSegment<T>;
    function get_RunningIndex: Int64;

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Memory: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T> read get_Memory;
    property Next: DNReadOnlySequenceSegment<T> read get_Next;
    property RunningIndex: Int64 read get_RunningIndex;
  end;

  TDNReadOnlySequenceSegment<T> = class(TDNGenericImport<DNReadOnlySequenceSegmentClass<T>, DNReadOnlySequenceSegment<T>>) end;

  //-------------namespace: System.Buffers----------------
  DNSequenceReaderExtensionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{ABB0C2D6-7FDF-5987-940C-404490C582B2}']
  { static methods } 

    {class} function TryReadLittleEndian(out reader: DNSequenceReader<Byte>; out value: Int16): Boolean; overload;
    {class} function TryReadBigEndian(out reader: DNSequenceReader<Byte>; out value: Int16): Boolean; overload;
    {class} function TryReadLittleEndian(out reader: DNSequenceReader<Byte>; out value: Int32): Boolean; overload;
    {class} function TryReadBigEndian(out reader: DNSequenceReader<Byte>; out value: Int32): Boolean; overload;
    {class} function TryReadLittleEndian(out reader: DNSequenceReader<Byte>; out value: Int64): Boolean; overload;
    {class} function TryReadBigEndian(out reader: DNSequenceReader<Byte>; out value: Int64): Boolean; overload;

  end;

  [DNTypeName('System.Buffers.SequenceReaderExtensions')]
  DNSequenceReaderExtensions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{797234BF-B4ED-34A2-A7BF-468662516752}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNSequenceReaderExtensions = class(TDNGenericImport<DNSequenceReaderExtensionsClass, DNSequenceReaderExtensions>) end;

  //-------------namespace: System.Buffers.Text----------------
  DNBase64Class = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{45ACA72A-0828-5924-BACE-A57DF0166B68}']
  { static methods } 

    {class} function DecodeFromUtf8(utf8: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; bytes: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesConsumed: Int32; out bytesWritten: Int32; isFinalBlock: Boolean): DDNC.System.Private.CoreLib.DNOperationStatus;
    {class} function GetMaxDecodedFromUtf8Length(length: Int32): Int32;
    {class} function DecodeFromUtf8InPlace(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesWritten: Int32): DDNC.System.Private.CoreLib.DNOperationStatus;
    {class} function EncodeToUtf8(bytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; utf8: DDNC.System.Private.CoreLib.DNSpan<Byte>; out bytesConsumed: Int32; out bytesWritten: Int32; isFinalBlock: Boolean): DDNC.System.Private.CoreLib.DNOperationStatus;
    {class} function GetMaxEncodedToUtf8Length(length: Int32): Int32;
    {class} function EncodeToUtf8InPlace(buffer: DDNC.System.Private.CoreLib.DNSpan<Byte>; dataLength: Int32; out bytesWritten: Int32): DDNC.System.Private.CoreLib.DNOperationStatus;

  end;

  [DNTypeName('System.Buffers.Text.Base64')]
  DNBase64 = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3F48F21E-1222-398A-9939-540D13FEA9D0}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNBase64 = class(TDNGenericImport<DNBase64Class, DNBase64>) end;

  //-------------namespace: System.Runtime.InteropServices----------------
  DNSequenceMarshalClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{9C31FA1E-C398-53B3-A08F-F5198457420B}']
  end;

  [DNTypeName('System.Runtime.InteropServices.SequenceMarshal')]
  DNSequenceMarshal = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{6E1FEEBB-B8F1-36FF-BBAB-83BCE3CEB72A}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNSequenceMarshal = class(TDNGenericImport<DNSequenceMarshalClass, DNSequenceMarshal>) end;

  //-------------namespace: System.Text----------------
  DNEncodingExtensionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{2EF078CD-C7B4-55D1-B3C6-602DC79E850F}']
  { static methods } 

    {class} function GetBytes(encoding: DDNC.System.Private.CoreLib.DNEncoding; chars: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; writer: DNIBufferWriter<Byte>): Int64; overload;
    {class} function GetBytes(encoding: DDNC.System.Private.CoreLib.DNEncoding; out chars: DNReadOnlySequence<Char>; writer: DNIBufferWriter<Byte>): Int64; overload;
    {class} function GetBytes(encoding: DDNC.System.Private.CoreLib.DNEncoding; out chars: DNReadOnlySequence<Char>; bytes: DDNC.System.Private.CoreLib.DNSpan<Byte>): Int32; overload;
    {class} function GetBytes(encoding: DDNC.System.Private.CoreLib.DNEncoding; out chars: DNReadOnlySequence<Char>): TArray<Byte>; overload;
    {class} function GetChars(encoding: DDNC.System.Private.CoreLib.DNEncoding; bytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; writer: DNIBufferWriter<Char>): Int64; overload;
    {class} function GetChars(encoding: DDNC.System.Private.CoreLib.DNEncoding; out bytes: DNReadOnlySequence<Byte>; writer: DNIBufferWriter<Char>): Int64; overload;
    {class} function GetChars(encoding: DDNC.System.Private.CoreLib.DNEncoding; out bytes: DNReadOnlySequence<Byte>; chars: DDNC.System.Private.CoreLib.DNSpan<Char>): Int32; overload;
    {class} function GetString(encoding: DDNC.System.Private.CoreLib.DNEncoding; out bytes: DNReadOnlySequence<Byte>): string;
    {class} procedure Convert(encoder: DDNC.System.Private.CoreLib.DNEncoder; chars: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; writer: DNIBufferWriter<Byte>; flush: Boolean; out bytesUsed: Int64; out completed: Boolean); overload;
    {class} procedure Convert(encoder: DDNC.System.Private.CoreLib.DNEncoder; out chars: DNReadOnlySequence<Char>; writer: DNIBufferWriter<Byte>; flush: Boolean; out bytesUsed: Int64; out completed: Boolean); overload;
    {class} procedure Convert(decoder: DDNC.System.Private.CoreLib.DNDecoder; bytes: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>; writer: DNIBufferWriter<Char>; flush: Boolean; out charsUsed: Int64; out completed: Boolean); overload;
    {class} procedure Convert(decoder: DDNC.System.Private.CoreLib.DNDecoder; out bytes: DNReadOnlySequence<Byte>; writer: DNIBufferWriter<Char>; flush: Boolean; out charsUsed: Int64; out completed: Boolean); overload;

  end;

  [DNTypeName('System.Text.EncodingExtensions')]
  DNEncodingExtensions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9A90C981-62EC-3F36-9E9F-E14B3F4F6520}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNEncodingExtensions = class(TDNGenericImport<DNEncodingExtensionsClass, DNEncodingExtensions>) end;

  //-------------namespace: System.Buffers----------------
  DNReadOnlySequenceClass<T> = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{9660089B-D5F3-52F7-91B7-4CF835DD4D0B}']
  { constructors } 

    {class} function init(startSegment: DNReadOnlySequenceSegment<T>; startIndex: Int32; endSegment: DNReadOnlySequenceSegment<T>; endIndex: Int32): DNReadOnlySequence<T>; overload;
    {class} function init(&array: TArray<T>): DNReadOnlySequence<T>; overload;
    {class} function init(&array: TArray<T>; start: Int32; length: Int32): DNReadOnlySequence<T>; overload;
    {class} function init(memory: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T>): DNReadOnlySequence<T>; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_Empty: DNReadOnlySequence<T>;

  { static fields } 

    {class} property Empty: DNReadOnlySequence<T> read __fakeFieldGet_Empty;

  end;

  [DNTypeName('System.Buffers.ReadOnlySequence`1')]
  DNReadOnlySequence<T> = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{F75F45C9-3CAC-36BB-854F-41838BBF3C41}']
  { getters & setters } 

    function get_Length: Int64;
    function get_IsEmpty: Boolean;
    function get_IsSingleSegment: Boolean;
    function get_First: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T>;
    function get_FirstSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>;
    function get_Start: DNSequencePosition;
    function get_End: DNSequencePosition;

  { methods } 

    function Slice(start: Int64; length: Int64): DNReadOnlySequence<T>; overload;
    function Slice(start: Int64; &end: DNSequencePosition): DNReadOnlySequence<T>; overload;
    function Slice(start: DNSequencePosition; length: Int64): DNReadOnlySequence<T>; overload;
    function Slice(start: Int32; length: Int32): DNReadOnlySequence<T>; overload;
    function Slice(start: Int32; &end: DNSequencePosition): DNReadOnlySequence<T>; overload;
    function Slice(start: DNSequencePosition; length: Int32): DNReadOnlySequence<T>; overload;
    function Slice(start: DNSequencePosition; &end: DNSequencePosition): DNReadOnlySequence<T>; overload;
    function Slice(start: DNSequencePosition): DNReadOnlySequence<T>; overload;
    function Slice(start: Int64): DNReadOnlySequence<T>; overload;
    function ToString: string;
    function GetEnumerator: DNReadOnlySequence_Enumerator<T>;
    function GetPosition(offset: Int64): DNSequencePosition; overload;
    function GetOffset(position: DNSequencePosition): Int64;
    function GetPosition(offset: Int64; origin: DNSequencePosition): DNSequencePosition; overload;
    function TryGet(out position: DNSequencePosition; out memory: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T>; advance: Boolean): Boolean;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Length: Int64 read get_Length;
    property IsEmpty: Boolean read get_IsEmpty;
    property IsSingleSegment: Boolean read get_IsSingleSegment;
    property First: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T> read get_First;
    property FirstSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<T> read get_FirstSpan;
    property Start: DNSequencePosition read get_Start;
    property &End: DNSequencePosition read get_End;
  end;

  TDNReadOnlySequence<T> = class(TDNGenericImport<DNReadOnlySequenceClass<T>, DNReadOnlySequence<T>>) end;

  //-------------namespace: System.Buffers----------------
  DNReadOnlySequence_EnumeratorClass<T> = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{6D92E387-7D3C-504C-A7DB-96AD3F674A0B}']
  { constructors } 

    {class} function init(out sequence: DNReadOnlySequence<T>): DNReadOnlySequence_Enumerator<T>;

  end;

  [DNTypeName('System.Buffers.ReadOnlySequence`1+Enumerator')]
  DNReadOnlySequence_Enumerator<T> = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{D2A1F35D-3A87-3038-80A9-529E9F00178C}']
  { getters & setters } 

    function get_Current: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T>;

  { methods } 

    function MoveNext: Boolean;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Current: DDNC.System.Private.CoreLib.DNReadOnlyMemory<T> read get_Current;
  end;

  TDNReadOnlySequence_Enumerator<T> = class(TDNGenericImport<DNReadOnlySequence_EnumeratorClass<T>, DNReadOnlySequence_Enumerator<T>>) end;

  //-------------namespace: System.Buffers----------------
  DNSequenceReaderClass<T> = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{EA73F43B-4C3C-5AF9-8AB5-FE2EB5B7D82E}']
  { constructors } 

    {class} function init(sequence: DNReadOnlySequence<T>): DNSequenceReader<T>;

  end;

  [DNTypeName('System.Buffers.SequenceReader`1')]
  DNSequenceReader<T> = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{C2CA6BE4-B40E-3189-9A81-A84250EF60A2}']
  { getters & setters } 

    function get_End: Boolean;
    function get_Sequence: DNReadOnlySequence<T>;
    function get_UnreadSequence: DNReadOnlySequence<T>;
    function get_Position: DNSequencePosition;
    function get_CurrentSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>;
    function get_CurrentSpanIndex: Int32;
    function get_UnreadSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>;
    function get_Consumed: Int64;
    function get_Remaining: Int64;
    function get_Length: Int64;

  { methods } 

    function TryPeek(out value: T): Boolean; overload;
    function TryPeek(offset: Int64; out value: T): Boolean; overload;
    function TryRead(out value: T): Boolean;
    procedure Rewind(count: Int64);
    procedure Advance(count: Int64);
    function TryCopyTo(destination: DDNC.System.Private.CoreLib.DNSpan<T>): Boolean;
    function TryReadTo(out span: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; delimiter: T; advancePastDelimiter: Boolean): Boolean; overload;
    function TryReadTo(out span: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; delimiter: T; delimiterEscape: T; advancePastDelimiter: Boolean): Boolean; overload;
    function TryReadTo(out sequence: DNReadOnlySequence<T>; delimiter: T; advancePastDelimiter: Boolean): Boolean; overload;
    function TryReadTo(out sequence: DNReadOnlySequence<T>; delimiter: T; delimiterEscape: T; advancePastDelimiter: Boolean): Boolean; overload;
    function TryReadToAny(out span: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; delimiters: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; advancePastDelimiter: Boolean): Boolean; overload;
    function TryReadToAny(out sequence: DNReadOnlySequence<T>; delimiters: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; advancePastDelimiter: Boolean): Boolean; overload;
    function TryReadTo(out span: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; delimiter: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; advancePastDelimiter: Boolean): Boolean; overload;
    function TryReadTo(out sequence: DNReadOnlySequence<T>; delimiter: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; advancePastDelimiter: Boolean): Boolean; overload;
    function TryAdvanceTo(delimiter: T; advancePastDelimiter: Boolean): Boolean;
    function TryAdvanceToAny(delimiters: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; advancePastDelimiter: Boolean): Boolean;
    function AdvancePast(value: T): Int64;
    function AdvancePastAny(values: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>): Int64; overload;
    function AdvancePastAny(value0: T; value1: T; value2: T; value3: T): Int64; overload;
    function AdvancePastAny(value0: T; value1: T; value2: T): Int64; overload;
    function AdvancePastAny(value0: T; value1: T): Int64; overload;
    procedure AdvanceToEnd;
    function IsNext(next: T; advancePast: Boolean): Boolean; overload;
    function IsNext(next: DDNC.System.Private.CoreLib.DNReadOnlySpan<T>; advancePast: Boolean): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property &End: Boolean read get_End;
    property Sequence: DNReadOnlySequence<T> read get_Sequence;
    property UnreadSequence: DNReadOnlySequence<T> read get_UnreadSequence;
    property Position: DNSequencePosition read get_Position;
    property CurrentSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<T> read get_CurrentSpan;
    property CurrentSpanIndex: Int32 read get_CurrentSpanIndex;
    property UnreadSpan: DDNC.System.Private.CoreLib.DNReadOnlySpan<T> read get_UnreadSpan;
    property Consumed: Int64 read get_Consumed;
    property Remaining: Int64 read get_Remaining;
    property Length: Int64 read get_Length;
  end;

  TDNSequenceReader<T> = class(TDNGenericImport<DNSequenceReaderClass<T>, DNSequenceReader<T>>) end;

  //-------------namespace: System----------------
  DNSequencePositionClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{5B2594F0-153B-5124-A600-56E4EFF5C45A}']
  { constructors } 

    {class} function init(&object: DDNC.System.Private.CoreLib.DNObject; integer: Int32): DNSequencePosition;

  end;

  [DNTypeName('System.SequencePosition')]
  DNSequencePosition = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{A23167D7-65C1-3D37-A8EC-C8A1B15C9558}']
  { methods } 

    function GetObject: DDNC.System.Private.CoreLib.DNObject;
    function GetInteger: Int32;
    function Equals(other: DNSequencePosition): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNSequencePosition = class(TDNGenericImport<DNSequencePositionClass, DNSequencePosition>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Memory, Version=5.0.0.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51');

finalization

end.
