//----------------------------------------------------------------------------
//  System.IO.FileSystem.dll: System.IO.FileSystem, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.IO.FileSystem
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.IO.FileSystem;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type

{ enums }

  //-------------namespace: System.IO----------------
  [DNTypeName('System.IO.MatchCasing')]
  DNMatchCasing = type Integer;
  DNMatchCasingHelper = record helper for DNMatchCasing
  public const
    PlatformDefault = 0;
    CaseSensitive = 1;
    CaseInsensitive = 2;
  end;


  //-------------namespace: System.IO----------------
  [DNTypeName('System.IO.MatchType')]
  DNMatchType = type Integer;
  DNMatchTypeHelper = record helper for DNMatchType
  public const
    Simple = 0;
    Win32 = 1;
  end;


  //-------------namespace: System.IO----------------
  [DNTypeName('System.IO.SearchOption')]
  DNSearchOption = type Integer;
  DNSearchOptionHelper = record helper for DNSearchOption
  public const
    TopDirectoryOnly = 0;
    AllDirectories = 1;
  end;




type


{ declares }

  DNDirectory = interface; // type: System.IO.Directory, namespace: System.IO
  DNFileSystemEnumerable<TResult> = interface; // type: System.IO.Enumeration.FileSystemEnumerable`1, namespace: System.IO.Enumeration
  DNFileSystemName = interface; // type: System.IO.Enumeration.FileSystemName, namespace: System.IO.Enumeration
  DNEnumerationOptions = interface; // type: System.IO.EnumerationOptions, namespace: System.IO
  DNFile = interface; // type: System.IO.File, namespace: System.IO
  DNFileSystemInfo = interface; // type: System.IO.FileSystemInfo, namespace: System.IO
  DNDirectoryInfo = interface; // type: System.IO.DirectoryInfo, namespace: System.IO
  DNFileInfo = interface; // type: System.IO.FileInfo, namespace: System.IO
  DNFileSystemEnumerator<TResult> = interface; // type: System.IO.Enumeration.FileSystemEnumerator`1, namespace: System.IO.Enumeration
  DNFileSystemEntry = interface; // type: System.IO.Enumeration.FileSystemEntry, namespace: System.IO.Enumeration

{ delegates }

  [DNTypeName('System.IO.Enumeration.FileSystemEnumerable`1+FindPredicate')]
  DNFileSystemEnumerable_FindPredicate<TResult> = function(out entry: DNFileSystemEntry): Boolean of object;

  [DNTypeName('System.IO.Enumeration.FileSystemEnumerable`1+FindTransform')]
  DNFileSystemEnumerable_FindTransform<TResult> = function(out entry: DNFileSystemEntry): TResult of object;




{ objects }

  //-------------namespace: System.IO----------------
  DNDirectoryClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{375C8875-4B62-5197-A884-DE008515D070}']
  { static methods } 

    {class} function GetParent(path: string): DNDirectoryInfo;
    {class} function CreateDirectory(path: string): DNDirectoryInfo;
    {class} function Exists(path: string): Boolean;
    {class} procedure SetCreationTime(path: string; creationTime: DDNC.System.Private.CoreLib.DNDateTime);
    {class} procedure SetCreationTimeUtc(path: string; creationTimeUtc: DDNC.System.Private.CoreLib.DNDateTime);
    {class} function GetCreationTime(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} function GetCreationTimeUtc(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} procedure SetLastWriteTime(path: string; lastWriteTime: DDNC.System.Private.CoreLib.DNDateTime);
    {class} procedure SetLastWriteTimeUtc(path: string; lastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTime);
    {class} function GetLastWriteTime(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} function GetLastWriteTimeUtc(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} procedure SetLastAccessTime(path: string; lastAccessTime: DDNC.System.Private.CoreLib.DNDateTime);
    {class} procedure SetLastAccessTimeUtc(path: string; lastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTime);
    {class} function GetLastAccessTime(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} function GetLastAccessTimeUtc(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} function GetFiles(path: string): TArray<string>; overload;
    {class} function GetFiles(path: string; searchPattern: string): TArray<string>; overload;
    {class} function GetFiles(path: string; searchPattern: string; searchOption: DNSearchOption): TArray<string>; overload;
    {class} function GetFiles(path: string; searchPattern: string; enumerationOptions: DNEnumerationOptions): TArray<string>; overload;
    {class} function GetDirectories(path: string): TArray<string>; overload;
    {class} function GetDirectories(path: string; searchPattern: string): TArray<string>; overload;
    {class} function GetDirectories(path: string; searchPattern: string; searchOption: DNSearchOption): TArray<string>; overload;
    {class} function GetDirectories(path: string; searchPattern: string; enumerationOptions: DNEnumerationOptions): TArray<string>; overload;
    {class} function GetFileSystemEntries(path: string): TArray<string>; overload;
    {class} function GetFileSystemEntries(path: string; searchPattern: string): TArray<string>; overload;
    {class} function GetFileSystemEntries(path: string; searchPattern: string; searchOption: DNSearchOption): TArray<string>; overload;
    {class} function GetFileSystemEntries(path: string; searchPattern: string; enumerationOptions: DNEnumerationOptions): TArray<string>; overload;
    {class} function EnumerateDirectories(path: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateDirectories(path: string; searchPattern: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateDirectories(path: string; searchPattern: string; searchOption: DNSearchOption): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateDirectories(path: string; searchPattern: string; enumerationOptions: DNEnumerationOptions): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateFiles(path: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateFiles(path: string; searchPattern: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateFiles(path: string; searchPattern: string; searchOption: DNSearchOption): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateFiles(path: string; searchPattern: string; enumerationOptions: DNEnumerationOptions): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateFileSystemEntries(path: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateFileSystemEntries(path: string; searchPattern: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateFileSystemEntries(path: string; searchPattern: string; searchOption: DNSearchOption): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function EnumerateFileSystemEntries(path: string; searchPattern: string; enumerationOptions: DNEnumerationOptions): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function GetDirectoryRoot(path: string): string;
    {class} function GetCurrentDirectory: string;
    {class} procedure SetCurrentDirectory(path: string);
    {class} procedure Move(sourceDirName: string; destDirName: string);
    {class} procedure Delete(path: string); overload;
    {class} procedure Delete(path: string; recursive: Boolean); overload;
    {class} function GetLogicalDrives: TArray<string>;

  end;

  [DNTypeName('System.IO.Directory')]
  DNDirectory = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{175BCC60-7E0F-3E98-9463-D5987A6EFD84}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDirectory = class(TDNGenericImport<DNDirectoryClass, DNDirectory>) end;

  //-------------namespace: System.IO.Enumeration----------------
  DNFileSystemEnumerableClass<TResult> = interface(DNObjectClass)
  ['{03B99166-D238-5EF3-84D3-EC9171D692F3}']
  { constructors } 

    {class} function init(directory: string; transform: DNFileSystemEnumerable_FindTransform<TResult>; options: DNEnumerationOptions): DNFileSystemEnumerable<TResult>;

  end;

  [DNTypeName('System.IO.Enumeration.FileSystemEnumerable`1')]
  DNFileSystemEnumerable<TResult> = interface(DDNC.System.Private.CoreLib.DNIEnumerable<TResult>)
  ['{BD984F7F-CF24-3330-9829-AA4E8D8092D0}']
  { getters & setters } 

    function get_ShouldIncludePredicate: DNFileSystemEnumerable_FindPredicate<TResult>;
    procedure set_ShouldIncludePredicate(value: DNFileSystemEnumerable_FindPredicate<TResult>);
    function get_ShouldRecursePredicate: DNFileSystemEnumerable_FindPredicate<TResult>;
    procedure set_ShouldRecursePredicate(value: DNFileSystemEnumerable_FindPredicate<TResult>);

  { methods } 

    function GetEnumerator: DDNC.System.Private.CoreLib.DNIEnumerator<TResult>;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ShouldIncludePredicate: DNFileSystemEnumerable_FindPredicate<TResult> read get_ShouldIncludePredicate write set_ShouldIncludePredicate;
    property ShouldRecursePredicate: DNFileSystemEnumerable_FindPredicate<TResult> read get_ShouldRecursePredicate write set_ShouldRecursePredicate;
  end;

  TDNFileSystemEnumerable<TResult> = class(TDNGenericImport<DNFileSystemEnumerableClass<TResult>, DNFileSystemEnumerable<TResult>>) end;

  //-------------namespace: System.IO.Enumeration----------------
  DNFileSystemNameClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{543A5E38-470B-5300-A865-D7595C82534D}']
  { static methods } 

    {class} function TranslateWin32Expression(expression: string): string;
    {class} function MatchesWin32Expression(expression: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; name: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; ignoreCase: Boolean): Boolean;
    {class} function MatchesSimpleExpression(expression: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; name: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>; ignoreCase: Boolean): Boolean;

  end;

  [DNTypeName('System.IO.Enumeration.FileSystemName')]
  DNFileSystemName = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B3149DFB-4A7F-3D3A-B584-C1D9DD77CD63}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNFileSystemName = class(TDNGenericImport<DNFileSystemNameClass, DNFileSystemName>) end;

  //-------------namespace: System.IO----------------
  DNEnumerationOptionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{97450B7C-A6DE-56A4-9C82-679383C2FB1D}']
  { constructors } 

    {class} function init: DNEnumerationOptions;

  end;

  [DNTypeName('System.IO.EnumerationOptions')]
  DNEnumerationOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E67876E4-DD3D-34A7-8DDA-1692FAAF45C4}']
  { getters & setters } 

    function get_RecurseSubdirectories: Boolean;
    procedure set_RecurseSubdirectories(value: Boolean);
    function get_IgnoreInaccessible: Boolean;
    procedure set_IgnoreInaccessible(value: Boolean);
    function get_BufferSize: Int32;
    procedure set_BufferSize(value: Int32);
    function get_AttributesToSkip: DDNC.System.Private.CoreLib.DNFileAttributes;
    procedure set_AttributesToSkip(value: DDNC.System.Private.CoreLib.DNFileAttributes);
    function get_MatchType: DNMatchType;
    procedure set_MatchType(value: DNMatchType);
    function get_MatchCasing: DNMatchCasing;
    procedure set_MatchCasing(value: DNMatchCasing);
    function get_ReturnSpecialDirectories: Boolean;
    procedure set_ReturnSpecialDirectories(value: Boolean);

  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property RecurseSubdirectories: Boolean read get_RecurseSubdirectories write set_RecurseSubdirectories;
    property IgnoreInaccessible: Boolean read get_IgnoreInaccessible write set_IgnoreInaccessible;
    property BufferSize: Int32 read get_BufferSize write set_BufferSize;
    property AttributesToSkip: DDNC.System.Private.CoreLib.DNFileAttributes read get_AttributesToSkip write set_AttributesToSkip;
    property MatchType: DNMatchType read get_MatchType write set_MatchType;
    property MatchCasing: DNMatchCasing read get_MatchCasing write set_MatchCasing;
    property ReturnSpecialDirectories: Boolean read get_ReturnSpecialDirectories write set_ReturnSpecialDirectories;
  end;

  TDNEnumerationOptions = class(TDNGenericImport<DNEnumerationOptionsClass, DNEnumerationOptions>) end;

  //-------------namespace: System.IO----------------
  DNFileClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{1A35395E-01DC-55AD-BF78-0AF4576BCE12}']
  { static methods } 

    {class} function OpenText(path: string): DDNC.System.Private.CoreLib.DNStreamReader;
    {class} function CreateText(path: string): DDNC.System.Private.CoreLib.DNStreamWriter;
    {class} function AppendText(path: string): DDNC.System.Private.CoreLib.DNStreamWriter;
    {class} procedure Copy(sourceFileName: string; destFileName: string); overload;
    {class} procedure Copy(sourceFileName: string; destFileName: string; overwrite: Boolean); overload;
    {class} function Create(path: string): DDNC.System.Private.CoreLib.DNFileStream; overload;
    {class} function Create(path: string; bufferSize: Int32): DDNC.System.Private.CoreLib.DNFileStream; overload;
    {class} function Create(path: string; bufferSize: Int32; options: DDNC.System.Private.CoreLib.DNFileOptions): DDNC.System.Private.CoreLib.DNFileStream; overload;
    {class} procedure Delete(path: string);
    {class} function Exists(path: string): Boolean;
    {class} function Open(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode): DDNC.System.Private.CoreLib.DNFileStream; overload;
    {class} function Open(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess): DDNC.System.Private.CoreLib.DNFileStream; overload;
    {class} function Open(path: string; mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess; share: DDNC.System.Private.CoreLib.DNFileShare): DDNC.System.Private.CoreLib.DNFileStream; overload;
    {class} procedure SetCreationTime(path: string; creationTime: DDNC.System.Private.CoreLib.DNDateTime);
    {class} procedure SetCreationTimeUtc(path: string; creationTimeUtc: DDNC.System.Private.CoreLib.DNDateTime);
    {class} function GetCreationTime(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} function GetCreationTimeUtc(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} procedure SetLastAccessTime(path: string; lastAccessTime: DDNC.System.Private.CoreLib.DNDateTime);
    {class} procedure SetLastAccessTimeUtc(path: string; lastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTime);
    {class} function GetLastAccessTime(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} function GetLastAccessTimeUtc(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} procedure SetLastWriteTime(path: string; lastWriteTime: DDNC.System.Private.CoreLib.DNDateTime);
    {class} procedure SetLastWriteTimeUtc(path: string; lastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTime);
    {class} function GetLastWriteTime(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} function GetLastWriteTimeUtc(path: string): DDNC.System.Private.CoreLib.DNDateTime;
    {class} function GetAttributes(path: string): DDNC.System.Private.CoreLib.DNFileAttributes;
    {class} procedure SetAttributes(path: string; fileAttributes: DDNC.System.Private.CoreLib.DNFileAttributes);
    {class} function OpenRead(path: string): DDNC.System.Private.CoreLib.DNFileStream;
    {class} function OpenWrite(path: string): DDNC.System.Private.CoreLib.DNFileStream;
    {class} function ReadAllText(path: string): string; overload;
    {class} function ReadAllText(path: string; encoding: DDNC.System.Private.CoreLib.DNEncoding): string; overload;
    {class} procedure WriteAllText(path: string; contents: string); overload;
    {class} procedure WriteAllText(path: string; contents: string; encoding: DDNC.System.Private.CoreLib.DNEncoding); overload;
    {class} function ReadAllBytes(path: string): TArray<Byte>;
    {class} procedure WriteAllBytes(path: string; bytes: TArray<Byte>);
    {class} function ReadAllLines(path: string): TArray<string>; overload;
    {class} function ReadAllLines(path: string; encoding: DDNC.System.Private.CoreLib.DNEncoding): TArray<string>; overload;
    {class} function ReadLines(path: string): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} function ReadLines(path: string; encoding: DDNC.System.Private.CoreLib.DNEncoding): DDNC.System.Private.CoreLib.DNIEnumerable<string>; overload;
    {class} procedure WriteAllLines(path: string; contents: TArray<string>); overload;
    {class} procedure WriteAllLines(path: string; contents: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    {class} procedure WriteAllLines(path: string; contents: TArray<string>; encoding: DDNC.System.Private.CoreLib.DNEncoding); overload;
    {class} procedure WriteAllLines(path: string; contents: DDNC.System.Private.CoreLib.DNIEnumerable<string>; encoding: DDNC.System.Private.CoreLib.DNEncoding); overload;
    {class} procedure AppendAllText(path: string; contents: string); overload;
    {class} procedure AppendAllText(path: string; contents: string; encoding: DDNC.System.Private.CoreLib.DNEncoding); overload;
    {class} procedure AppendAllLines(path: string; contents: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    {class} procedure AppendAllLines(path: string; contents: DDNC.System.Private.CoreLib.DNIEnumerable<string>; encoding: DDNC.System.Private.CoreLib.DNEncoding); overload;
    {class} procedure Replace(sourceFileName: string; destinationFileName: string; destinationBackupFileName: string); overload;
    {class} procedure Replace(sourceFileName: string; destinationFileName: string; destinationBackupFileName: string; ignoreMetadataErrors: Boolean); overload;
    {class} procedure Move(sourceFileName: string; destFileName: string); overload;
    {class} procedure Move(sourceFileName: string; destFileName: string; overwrite: Boolean); overload;
    {class} procedure Encrypt(path: string);
    {class} procedure Decrypt(path: string);
    {class} function ReadAllTextAsync(path: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    {class} function ReadAllTextAsync(path: string; encoding: DDNC.System.Private.CoreLib.DNEncoding; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<string>; overload;
    {class} function WriteAllTextAsync(path: string; contents: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function WriteAllTextAsync(path: string; contents: string; encoding: DDNC.System.Private.CoreLib.DNEncoding; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function ReadAllBytesAsync(path: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<Byte>>;
    {class} function WriteAllBytesAsync(path: string; bytes: TArray<Byte>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask;
    {class} function ReadAllLinesAsync(path: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<string>>; overload;
    {class} function ReadAllLinesAsync(path: string; encoding: DDNC.System.Private.CoreLib.DNEncoding; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask<TArray<string>>; overload;
    {class} function WriteAllLinesAsync(path: string; contents: DDNC.System.Private.CoreLib.DNIEnumerable<string>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function WriteAllLinesAsync(path: string; contents: DDNC.System.Private.CoreLib.DNIEnumerable<string>; encoding: DDNC.System.Private.CoreLib.DNEncoding; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function AppendAllTextAsync(path: string; contents: string; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function AppendAllTextAsync(path: string; contents: string; encoding: DDNC.System.Private.CoreLib.DNEncoding; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function AppendAllLinesAsync(path: string; contents: DDNC.System.Private.CoreLib.DNIEnumerable<string>; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;
    {class} function AppendAllLinesAsync(path: string; contents: DDNC.System.Private.CoreLib.DNIEnumerable<string>; encoding: DDNC.System.Private.CoreLib.DNEncoding; cancellationToken: DDNC.System.Private.CoreLib.DNCancellationToken): DDNC.System.Private.CoreLib.DNTask; overload;

  end;

  [DNTypeName('System.IO.File')]
  DNFile = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{21A08CC6-038A-374A-8EBB-4B7D82ED0F03}']
  { methods } 

    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNFile = class(TDNGenericImport<DNFileClass, DNFile>) end;

  //-------------namespace: System.IO----------------
  DNFileSystemInfoClass = interface(DDNC.System.Private.CoreLib.DNMarshalByRefObjectClass)
  ['{90C9A16E-9858-56B9-B6A2-71AA7FC89D3F}']
  end;

  [DNTypeName('System.IO.FileSystemInfo')]
  DNFileSystemInfo = interface(DDNC.System.Private.CoreLib.DNMarshalByRefObject)
  ['{6D27A03A-1E28-39A7-A8E1-2224BC10CC8B}']
  { getters & setters } 

    function get_FullName: string;
    function get_Extension: string;
    function get_Name: string;
    function get_Exists: Boolean;
    function get_CreationTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_CreationTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_CreationTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_CreationTimeUtc(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastAccessTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastAccessTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastAccessTimeUtc(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastWriteTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastWriteTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastWriteTimeUtc(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_Attributes: DDNC.System.Private.CoreLib.DNFileAttributes;
    procedure set_Attributes(value: DDNC.System.Private.CoreLib.DNFileAttributes);

  { methods } 

    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    procedure Delete;
    function ToString: string;
    procedure Refresh;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property FullName: string read get_FullName;
    property Extension: string read get_Extension;
    property Name: string read get_Name;
    property Exists: Boolean read get_Exists;
    property CreationTime: DDNC.System.Private.CoreLib.DNDateTime read get_CreationTime write set_CreationTime;
    property CreationTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_CreationTimeUtc write set_CreationTimeUtc;
    property LastAccessTime: DDNC.System.Private.CoreLib.DNDateTime read get_LastAccessTime write set_LastAccessTime;
    property LastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_LastAccessTimeUtc write set_LastAccessTimeUtc;
    property LastWriteTime: DDNC.System.Private.CoreLib.DNDateTime read get_LastWriteTime write set_LastWriteTime;
    property LastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_LastWriteTimeUtc write set_LastWriteTimeUtc;
    property Attributes: DDNC.System.Private.CoreLib.DNFileAttributes read get_Attributes write set_Attributes;
  end;

  TDNFileSystemInfo = class(TDNGenericImport<DNFileSystemInfoClass, DNFileSystemInfo>) end;

  //-------------namespace: System.IO----------------
  DNDirectoryInfoClass = interface(DNFileSystemInfoClass)
  ['{3A466407-40DF-555C-BCE5-7DB1F55EA3BB}']
  { constructors } 

    {class} function init(path: string): DNDirectoryInfo;

  end;

  [DNTypeName('System.IO.DirectoryInfo')]
  DNDirectoryInfo = interface(DNFileSystemInfo)
  ['{AB352309-7394-3506-AFBD-C9B8C76227F4}']
  { getters & setters } 

    function get_Parent: DNDirectoryInfo;
    function get_Root: DNDirectoryInfo;
    function get_FullName: string;
    function get_Extension: string;
    function get_Name: string;
    function get_Exists: Boolean;
    function get_CreationTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_CreationTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_CreationTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_CreationTimeUtc(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastAccessTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastAccessTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastAccessTimeUtc(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastWriteTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastWriteTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastWriteTimeUtc(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_Attributes: DDNC.System.Private.CoreLib.DNFileAttributes;
    procedure set_Attributes(value: DDNC.System.Private.CoreLib.DNFileAttributes);

  { methods } 

    function CreateSubdirectory(path: string): DNDirectoryInfo;
    procedure Create;
    function GetFiles: TArray<DNFileInfo>; overload;
    function GetFiles(searchPattern: string): TArray<DNFileInfo>; overload;
    function GetFiles(searchPattern: string; searchOption: DNSearchOption): TArray<DNFileInfo>; overload;
    function GetFiles(searchPattern: string; enumerationOptions: DNEnumerationOptions): TArray<DNFileInfo>; overload;
    function GetFileSystemInfos: TArray<DNFileSystemInfo>; overload;
    function GetFileSystemInfos(searchPattern: string): TArray<DNFileSystemInfo>; overload;
    function GetFileSystemInfos(searchPattern: string; searchOption: DNSearchOption): TArray<DNFileSystemInfo>; overload;
    function GetFileSystemInfos(searchPattern: string; enumerationOptions: DNEnumerationOptions): TArray<DNFileSystemInfo>; overload;
    function GetDirectories: TArray<DNDirectoryInfo>; overload;
    function GetDirectories(searchPattern: string): TArray<DNDirectoryInfo>; overload;
    function GetDirectories(searchPattern: string; searchOption: DNSearchOption): TArray<DNDirectoryInfo>; overload;
    function GetDirectories(searchPattern: string; enumerationOptions: DNEnumerationOptions): TArray<DNDirectoryInfo>; overload;
    function EnumerateDirectories: DDNC.System.Private.CoreLib.DNIEnumerable<DNDirectoryInfo>; overload;
    function EnumerateDirectories(searchPattern: string): DDNC.System.Private.CoreLib.DNIEnumerable<DNDirectoryInfo>; overload;
    function EnumerateDirectories(searchPattern: string; searchOption: DNSearchOption): DDNC.System.Private.CoreLib.DNIEnumerable<DNDirectoryInfo>; overload;
    function EnumerateDirectories(searchPattern: string; enumerationOptions: DNEnumerationOptions): DDNC.System.Private.CoreLib.DNIEnumerable<DNDirectoryInfo>; overload;
    function EnumerateFiles: DDNC.System.Private.CoreLib.DNIEnumerable<DNFileInfo>; overload;
    function EnumerateFiles(searchPattern: string): DDNC.System.Private.CoreLib.DNIEnumerable<DNFileInfo>; overload;
    function EnumerateFiles(searchPattern: string; searchOption: DNSearchOption): DDNC.System.Private.CoreLib.DNIEnumerable<DNFileInfo>; overload;
    function EnumerateFiles(searchPattern: string; enumerationOptions: DNEnumerationOptions): DDNC.System.Private.CoreLib.DNIEnumerable<DNFileInfo>; overload;
    function EnumerateFileSystemInfos: DDNC.System.Private.CoreLib.DNIEnumerable<DNFileSystemInfo>; overload;
    function EnumerateFileSystemInfos(searchPattern: string): DDNC.System.Private.CoreLib.DNIEnumerable<DNFileSystemInfo>; overload;
    function EnumerateFileSystemInfos(searchPattern: string; searchOption: DNSearchOption): DDNC.System.Private.CoreLib.DNIEnumerable<DNFileSystemInfo>; overload;
    function EnumerateFileSystemInfos(searchPattern: string; enumerationOptions: DNEnumerationOptions): DDNC.System.Private.CoreLib.DNIEnumerable<DNFileSystemInfo>; overload;
    procedure MoveTo(destDirName: string);
    procedure Delete; overload;
    procedure Delete(recursive: Boolean); overload;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    procedure Refresh;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Parent: DNDirectoryInfo read get_Parent;
    property Root: DNDirectoryInfo read get_Root;
    property FullName: string read get_FullName;
    property Extension: string read get_Extension;
    property Name: string read get_Name;
    property Exists: Boolean read get_Exists;
    property CreationTime: DDNC.System.Private.CoreLib.DNDateTime read get_CreationTime write set_CreationTime;
    property CreationTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_CreationTimeUtc write set_CreationTimeUtc;
    property LastAccessTime: DDNC.System.Private.CoreLib.DNDateTime read get_LastAccessTime write set_LastAccessTime;
    property LastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_LastAccessTimeUtc write set_LastAccessTimeUtc;
    property LastWriteTime: DDNC.System.Private.CoreLib.DNDateTime read get_LastWriteTime write set_LastWriteTime;
    property LastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_LastWriteTimeUtc write set_LastWriteTimeUtc;
    property Attributes: DDNC.System.Private.CoreLib.DNFileAttributes read get_Attributes write set_Attributes;
  end;

  TDNDirectoryInfo = class(TDNGenericImport<DNDirectoryInfoClass, DNDirectoryInfo>) end;

  //-------------namespace: System.IO----------------
  DNFileInfoClass = interface(DNFileSystemInfoClass)
  ['{6F1CC9CE-A22B-5227-BFDF-74D3AD760AC9}']
  { constructors } 

    {class} function init(fileName: string): DNFileInfo;

  end;

  [DNTypeName('System.IO.FileInfo')]
  DNFileInfo = interface(DNFileSystemInfo)
  ['{068465BD-CFA6-39FB-A7C4-2225F0C83DF0}']
  { getters & setters } 

    function get_Length: Int64;
    function get_DirectoryName: string;
    function get_Directory: DNDirectoryInfo;
    function get_IsReadOnly: Boolean;
    procedure set_IsReadOnly(value: Boolean);
    function get_FullName: string;
    function get_Extension: string;
    function get_Name: string;
    function get_Exists: Boolean;
    function get_CreationTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_CreationTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_CreationTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_CreationTimeUtc(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastAccessTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastAccessTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastAccessTimeUtc(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastWriteTime: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastWriteTime(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_LastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    procedure set_LastWriteTimeUtc(value: DDNC.System.Private.CoreLib.DNDateTime);
    function get_Attributes: DDNC.System.Private.CoreLib.DNFileAttributes;
    procedure set_Attributes(value: DDNC.System.Private.CoreLib.DNFileAttributes);

  { methods } 

    function OpenText: DDNC.System.Private.CoreLib.DNStreamReader;
    function CreateText: DDNC.System.Private.CoreLib.DNStreamWriter;
    function AppendText: DDNC.System.Private.CoreLib.DNStreamWriter;
    function CopyTo(destFileName: string): DNFileInfo; overload;
    function CopyTo(destFileName: string; overwrite: Boolean): DNFileInfo; overload;
    function Create: DDNC.System.Private.CoreLib.DNFileStream;
    procedure Delete;
    function Open(mode: DDNC.System.Private.CoreLib.DNFileMode): DDNC.System.Private.CoreLib.DNFileStream; overload;
    function Open(mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess): DDNC.System.Private.CoreLib.DNFileStream; overload;
    function Open(mode: DDNC.System.Private.CoreLib.DNFileMode; access: DDNC.System.Private.CoreLib.DNFileAccess; share: DDNC.System.Private.CoreLib.DNFileShare): DDNC.System.Private.CoreLib.DNFileStream; overload;
    function OpenRead: DDNC.System.Private.CoreLib.DNFileStream;
    function OpenWrite: DDNC.System.Private.CoreLib.DNFileStream;
    procedure MoveTo(destFileName: string); overload;
    procedure MoveTo(destFileName: string; overwrite: Boolean); overload;
    function Replace(destinationFileName: string; destinationBackupFileName: string): DNFileInfo; overload;
    function Replace(destinationFileName: string; destinationBackupFileName: string; ignoreMetadataErrors: Boolean): DNFileInfo; overload;
    procedure Decrypt;
    procedure Encrypt;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function ToString: string;
    procedure Refresh;
    function GetLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function InitializeLifetimeService: DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Length: Int64 read get_Length;
    property DirectoryName: string read get_DirectoryName;
    property Directory: DNDirectoryInfo read get_Directory;
    property IsReadOnly: Boolean read get_IsReadOnly write set_IsReadOnly;
    property FullName: string read get_FullName;
    property Extension: string read get_Extension;
    property Name: string read get_Name;
    property Exists: Boolean read get_Exists;
    property CreationTime: DDNC.System.Private.CoreLib.DNDateTime read get_CreationTime write set_CreationTime;
    property CreationTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_CreationTimeUtc write set_CreationTimeUtc;
    property LastAccessTime: DDNC.System.Private.CoreLib.DNDateTime read get_LastAccessTime write set_LastAccessTime;
    property LastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_LastAccessTimeUtc write set_LastAccessTimeUtc;
    property LastWriteTime: DDNC.System.Private.CoreLib.DNDateTime read get_LastWriteTime write set_LastWriteTime;
    property LastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_LastWriteTimeUtc write set_LastWriteTimeUtc;
    property Attributes: DDNC.System.Private.CoreLib.DNFileAttributes read get_Attributes write set_Attributes;
  end;

  TDNFileInfo = class(TDNGenericImport<DNFileInfoClass, DNFileInfo>) end;

  //-------------namespace: System.IO.Enumeration----------------
  DNFileSystemEnumeratorClass<TResult> = interface(DDNC.System.Private.CoreLib.DNCriticalFinalizerObjectClass)
  ['{84E0324A-A852-5161-8402-090D30059989}']
  { constructors } 

    {class} function init(directory: string; options: DNEnumerationOptions): DNFileSystemEnumerator<TResult>;

  end;

  [DNTypeName('System.IO.Enumeration.FileSystemEnumerator`1')]
  DNFileSystemEnumerator<TResult> = interface(DDNC.System.Private.CoreLib.DNCriticalFinalizerObject)
  ['{0FBBDE8A-BC50-3F71-A34A-FA5DCE642B9E}']
  { getters & setters } 

    function get_Current: TResult;

  { methods } 

    procedure Reset;
    procedure Dispose;
    function MoveNext: Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Current: TResult read get_Current;
  end;

  TDNFileSystemEnumerator<TResult> = class(TDNGenericImport<DNFileSystemEnumeratorClass<TResult>, DNFileSystemEnumerator<TResult>>) end;

  //-------------namespace: System.IO.Enumeration----------------
  DNFileSystemEntryClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{F7E45916-0972-5AAE-AB32-F9E512F9132B}']
  end;

  [DNTypeName('System.IO.Enumeration.FileSystemEntry')]
  DNFileSystemEntry = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{5E0247EE-ABF1-3190-ABEF-FA2F6AF6BD82}']
  { getters & setters } 

    function get_Directory: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>;
    function get_RootDirectory: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>;
    function get_OriginalRootDirectory: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>;
    function get_FileName: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>;
    function get_Attributes: DDNC.System.Private.CoreLib.DNFileAttributes;
    function get_Length: Int64;
    function get_CreationTimeUtc: DDNC.System.Private.CoreLib.DNDateTimeOffset;
    function get_LastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTimeOffset;
    function get_LastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTimeOffset;
    function get_IsDirectory: Boolean;
    function get_IsHidden: Boolean;

  { methods } 

    function ToSpecifiedFullPath: string;
    function ToFileSystemInfo: DNFileSystemInfo;
    function ToFullPath: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Directory: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char> read get_Directory;
    property RootDirectory: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char> read get_RootDirectory;
    property OriginalRootDirectory: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char> read get_OriginalRootDirectory;
    property FileName: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char> read get_FileName;
    property Attributes: DDNC.System.Private.CoreLib.DNFileAttributes read get_Attributes;
    property Length: Int64 read get_Length;
    property CreationTimeUtc: DDNC.System.Private.CoreLib.DNDateTimeOffset read get_CreationTimeUtc;
    property LastAccessTimeUtc: DDNC.System.Private.CoreLib.DNDateTimeOffset read get_LastAccessTimeUtc;
    property LastWriteTimeUtc: DDNC.System.Private.CoreLib.DNDateTimeOffset read get_LastWriteTimeUtc;
    property IsDirectory: Boolean read get_IsDirectory;
    property IsHidden: Boolean read get_IsHidden;
  end;

  TDNFileSystemEntry = class(TDNGenericImport<DNFileSystemEntryClass, DNFileSystemEntry>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.IO.FileSystem, Version=5.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a');

finalization

end.
