//----------------------------------------------------------------------------
//  System.Diagnostics.DiagnosticSource.dll: System.Diagnostics.DiagnosticSource, Version=5.0.0.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 5.0.9
//----------------------------------------------------------------------------
//  UnitName: DDNC.System.Diagnostics.DiagnosticSource
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.System.Diagnostics.DiagnosticSource;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib;

type

{ enums }

  //-------------namespace: System.Diagnostics----------------
  [DNTypeName('System.Diagnostics.ActivityIdFormat')]
  DNActivityIdFormat = type Integer;
  DNActivityIdFormatHelper = record helper for DNActivityIdFormat
  public const
    Unknown = 0;
    Hierarchical = 1;
    W3C = 2;
  end;


  //-------------namespace: System.Diagnostics----------------
  [DNTypeName('System.Diagnostics.ActivityKind')]
  DNActivityKind = type Integer;
  DNActivityKindHelper = record helper for DNActivityKind
  public const
    Internal = 0;
    Server = 1;
    Client = 2;
    Producer = 3;
    Consumer = 4;
  end;


  //-------------namespace: System.Diagnostics----------------
  [DNTypeName('System.Diagnostics.ActivitySamplingResult')]
  DNActivitySamplingResult = type Integer;
  DNActivitySamplingResultHelper = record helper for DNActivitySamplingResult
  public const
    None = 0;
    PropagationData = 1;
    AllData = 2;
    AllDataAndRecorded = 3;
  end;


  //-------------namespace: System.Diagnostics----------------
  [DNTypeName('System.Diagnostics.ActivityTraceFlags')]
  DNActivityTraceFlags = type Integer;
  DNActivityTraceFlagsHelper = record helper for DNActivityTraceFlags
  public const
    None = 0;
    Recorded = 1;
  end;




type


{ declares }

  DNActivity = interface; // type: System.Diagnostics.Activity, namespace: System.Diagnostics
  DNActivityListener = interface; // type: System.Diagnostics.ActivityListener, namespace: System.Diagnostics
  DNActivitySource = interface; // type: System.Diagnostics.ActivitySource, namespace: System.Diagnostics
  DNActivityTagsCollection = interface; // type: System.Diagnostics.ActivityTagsCollection, namespace: System.Diagnostics
  DNDiagnosticSource = interface; // type: System.Diagnostics.DiagnosticSource, namespace: System.Diagnostics
  DNDiagnosticListener = interface; // type: System.Diagnostics.DiagnosticListener, namespace: System.Diagnostics
  DNActivityContext = interface; // type: System.Diagnostics.ActivityContext, namespace: System.Diagnostics
  DNActivityCreationOptions<T> = interface; // type: System.Diagnostics.ActivityCreationOptions`1, namespace: System.Diagnostics
  DNActivityEvent = interface; // type: System.Diagnostics.ActivityEvent, namespace: System.Diagnostics
  DNActivityLink = interface; // type: System.Diagnostics.ActivityLink, namespace: System.Diagnostics
  DNActivitySpanId = interface; // type: System.Diagnostics.ActivitySpanId, namespace: System.Diagnostics
  DNActivityTagsCollection_Enumerator = interface; // type: System.Diagnostics.ActivityTagsCollection+Enumerator, namespace: System.Diagnostics
  DNActivityTraceId = interface; // type: System.Diagnostics.ActivityTraceId, namespace: System.Diagnostics

{ delegates }

  [DNTypeName('System.Diagnostics.SampleActivity`1')]
  DNSampleActivity<T> = function(out options: DNActivityCreationOptions<T>): DNActivitySamplingResult of object;




{ objects }

  //-------------namespace: System.Diagnostics----------------
  DNActivityClass = interface(DNObjectClass)
  ['{5E503C2A-A819-5B58-80C4-241254E2CD9A}']
  { static getter & setter } 

    {class} function get_ForceDefaultIdFormat: Boolean;
    {class} procedure set_ForceDefaultIdFormat(value: Boolean);
    {class} function get_DefaultIdFormat: DNActivityIdFormat;
    {class} procedure set_DefaultIdFormat(value: DNActivityIdFormat);
    {class} function get_Current: DNActivity;
    {class} procedure set_Current(value: DNActivity);

  { constructors } 

    {class} function init(operationName: string): DNActivity;

  { static propertys } 

    {class} property ForceDefaultIdFormat: Boolean read get_ForceDefaultIdFormat write set_ForceDefaultIdFormat;
    {class} property DefaultIdFormat: DNActivityIdFormat read get_DefaultIdFormat write set_DefaultIdFormat;
    {class} property Current: DNActivity read get_Current write set_Current;
  end;

  [DNTypeName('System.Diagnostics.Activity')]
  DNActivity = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{FFD00C47-A516-374C-A77F-85FB38EB82FA}']
  { getters & setters } 

    function get_Kind: DNActivityKind;
    function get_OperationName: string;
    function get_DisplayName: string;
    procedure set_DisplayName(value: string);
    function get_Source: DNActivitySource;
    function get_Parent: DNActivity;
    function get_Duration: DDNC.System.Private.CoreLib.DNTimeSpan;
    function get_StartTimeUtc: DDNC.System.Private.CoreLib.DNDateTime;
    function get_Id: string;
    function get_ParentId: string;
    function get_RootId: string;
    function get_Tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, string>>;
    function get_TagObjects: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>;
    function get_Events: DDNC.System.Private.CoreLib.DNIEnumerable<DNActivityEvent>;
    function get_Links: DDNC.System.Private.CoreLib.DNIEnumerable<DNActivityLink>;
    function get_Baggage: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, string>>;
    function get_Context: DNActivityContext;
    function get_TraceStateString: string;
    procedure set_TraceStateString(value: string);
    function get_SpanId: DNActivitySpanId;
    function get_TraceId: DNActivityTraceId;
    function get_Recorded: Boolean;
    function get_IsAllDataRequested: Boolean;
    procedure set_IsAllDataRequested(value: Boolean);
    function get_ActivityTraceFlags: DNActivityTraceFlags;
    procedure set_ActivityTraceFlags(value: DNActivityTraceFlags);
    function get_ParentSpanId: DNActivitySpanId;
    function get_IdFormat: DNActivityIdFormat;

  { methods } 

    function GetBaggageItem(key: string): string;
    function AddTag(key: string; value: string): DNActivity; overload;
    function AddTag(key: string; value: DDNC.System.Private.CoreLib.DNObject): DNActivity; overload;
    function SetTag(key: string; value: DDNC.System.Private.CoreLib.DNObject): DNActivity;
    function AddEvent(e: DNActivityEvent): DNActivity;
    function AddBaggage(key: string; value: string): DNActivity;
    function SetParentId(parentId: string): DNActivity; overload;
    function SetParentId(traceId: DNActivityTraceId; spanId: DNActivitySpanId; activityTraceFlags: DNActivityTraceFlags): DNActivity; overload;
    function SetStartTime(startTimeUtc: DDNC.System.Private.CoreLib.DNDateTime): DNActivity;
    function SetEndTime(endTimeUtc: DDNC.System.Private.CoreLib.DNDateTime): DNActivity;
    function Start: DNActivity;
    procedure Stop;
    function SetIdFormat(format: DNActivityIdFormat): DNActivity;
    procedure Dispose;
    procedure SetCustomProperty(propertyName: string; propertyValue: DDNC.System.Private.CoreLib.DNObject);
    function GetCustomProperty(propertyName: string): DDNC.System.Private.CoreLib.DNObject;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Kind: DNActivityKind read get_Kind;
    property OperationName: string read get_OperationName;
    property DisplayName: string read get_DisplayName write set_DisplayName;
    property Source: DNActivitySource read get_Source;
    property Parent: DNActivity read get_Parent;
    property Duration: DDNC.System.Private.CoreLib.DNTimeSpan read get_Duration;
    property StartTimeUtc: DDNC.System.Private.CoreLib.DNDateTime read get_StartTimeUtc;
    property Id: string read get_Id;
    property ParentId: string read get_ParentId;
    property RootId: string read get_RootId;
    property Tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, string>> read get_Tags;
    property TagObjects: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>> read get_TagObjects;
    property Events: DDNC.System.Private.CoreLib.DNIEnumerable<DNActivityEvent> read get_Events;
    property Links: DDNC.System.Private.CoreLib.DNIEnumerable<DNActivityLink> read get_Links;
    property Baggage: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, string>> read get_Baggage;
    property Context: DNActivityContext read get_Context;
    property TraceStateString: string read get_TraceStateString write set_TraceStateString;
    property SpanId: DNActivitySpanId read get_SpanId;
    property TraceId: DNActivityTraceId read get_TraceId;
    property Recorded: Boolean read get_Recorded;
    property IsAllDataRequested: Boolean read get_IsAllDataRequested write set_IsAllDataRequested;
    property ActivityTraceFlags: DNActivityTraceFlags read get_ActivityTraceFlags write set_ActivityTraceFlags;
    property ParentSpanId: DNActivitySpanId read get_ParentSpanId;
    property IdFormat: DNActivityIdFormat read get_IdFormat;
  end;

  TDNActivity = class(TDNGenericImport<DNActivityClass, DNActivity>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivityListenerClass = interface(DNObjectClass)
  ['{746C9297-99F7-5DC0-A118-0FBF08F11DB7}']
  { constructors } 

    {class} function init: DNActivityListener;

  end;

  [DNTypeName('System.Diagnostics.ActivityListener')]
  DNActivityListener = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{E01A9059-55C0-34B1-BDEE-80B167026862}']
  { getters & setters } 

    function get_ActivityStarted: DDNC.System.Private.CoreLib.DNAction<DNActivity>;
    procedure set_ActivityStarted(value: DDNC.System.Private.CoreLib.DNAction<DNActivity>);
    function get_ActivityStopped: DDNC.System.Private.CoreLib.DNAction<DNActivity>;
    procedure set_ActivityStopped(value: DDNC.System.Private.CoreLib.DNAction<DNActivity>);
    function get_ShouldListenTo: DDNC.System.Private.CoreLib.DNFunc<DNActivitySource, Boolean>;
    procedure set_ShouldListenTo(value: DDNC.System.Private.CoreLib.DNFunc<DNActivitySource, Boolean>);
    function get_SampleUsingParentId: DNSampleActivity<string>;
    procedure set_SampleUsingParentId(value: DNSampleActivity<string>);
    function get_Sample: DNSampleActivity<DNActivityContext>;
    procedure set_Sample(value: DNSampleActivity<DNActivityContext>);

  { methods } 

    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property ActivityStarted: DDNC.System.Private.CoreLib.DNAction<DNActivity> read get_ActivityStarted write set_ActivityStarted;
    property ActivityStopped: DDNC.System.Private.CoreLib.DNAction<DNActivity> read get_ActivityStopped write set_ActivityStopped;
    property ShouldListenTo: DDNC.System.Private.CoreLib.DNFunc<DNActivitySource, Boolean> read get_ShouldListenTo write set_ShouldListenTo;
    property SampleUsingParentId: DNSampleActivity<string> read get_SampleUsingParentId write set_SampleUsingParentId;
    property Sample: DNSampleActivity<DNActivityContext> read get_Sample write set_Sample;
  end;

  TDNActivityListener = class(TDNGenericImport<DNActivityListenerClass, DNActivityListener>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivitySourceClass = interface(DNObjectClass)
  ['{60016D9B-3359-52E3-BBF2-0958F2CD7F8E}']
  { constructors } 

    {class} function init(name: string; version: string): DNActivitySource;

  { static methods } 

    {class} procedure AddActivityListener(listener: DNActivityListener);

  end;

  [DNTypeName('System.Diagnostics.ActivitySource')]
  DNActivitySource = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{B36DDDAA-3AEC-391C-80FA-D88EB4A26AC8}']
  { getters & setters } 

    function get_Name: string;
    function get_Version: string;

  { methods } 

    function HasListeners: Boolean;
    function StartActivity(name: string; kind: DNActivityKind): DNActivity; overload;
    function StartActivity(name: string; kind: DNActivityKind; parentContext: DNActivityContext; tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>; links: DDNC.System.Private.CoreLib.DNIEnumerable<DNActivityLink>; startTime: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNActivity; overload;
    function StartActivity(name: string; kind: DNActivityKind; parentId: string; tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>; links: DDNC.System.Private.CoreLib.DNIEnumerable<DNActivityLink>; startTime: DDNC.System.Private.CoreLib.DNDateTimeOffset): DNActivity; overload;
    procedure Dispose;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Name: string read get_Name;
    property Version: string read get_Version;
  end;

  TDNActivitySource = class(TDNGenericImport<DNActivitySourceClass, DNActivitySource>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivityTagsCollectionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{C88B054F-A1A1-52EB-9B14-CB3D0F4FB5B3}']
  { constructors } 

    {class} function init: DNActivityTagsCollection; overload;
    {class} function init(list: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>): DNActivityTagsCollection; overload;

  end;

  [DNTypeName('System.Diagnostics.ActivityTagsCollection')]
  DNActivityTagsCollection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{D6E463F7-27CD-355B-BC7F-A9F1F6685D9F}']
  { getters & setters } 

    function get_Keys: DDNC.System.Private.CoreLib.DNICollection<string>;
    function get_Values: DDNC.System.Private.CoreLib.DNICollection<DDNC.System.Private.CoreLib.DNObject>;
    function get_IsReadOnly: Boolean;
    function get_Count: Int32;

  { methods } 

    function &Contains(item: DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>): Boolean;
    function ContainsKey(key: string): Boolean;
    procedure CopyTo(&array: TArray<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>; arrayIndex: Int32);
    function GetEnumerator: DNActivityTagsCollection_Enumerator;
    function TryGetValue(key: string; out value: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Keys: DDNC.System.Private.CoreLib.DNICollection<string> read get_Keys;
    property Values: DDNC.System.Private.CoreLib.DNICollection<DDNC.System.Private.CoreLib.DNObject> read get_Values;
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Count: Int32 read get_Count;
  end;

  TDNActivityTagsCollection = class(TDNGenericImport<DNActivityTagsCollectionClass, DNActivityTagsCollection>) end;

  //-------------namespace: System.Diagnostics----------------
  DNDiagnosticSourceClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{45F3E04E-33FA-5DC4-9D8F-49C3A83956C5}']
  end;

  [DNTypeName('System.Diagnostics.DiagnosticSource')]
  DNDiagnosticSource = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{78350396-10AD-3E17-A1AA-256D8A5D63F7}']
  { methods } 

    procedure Write(name: string; value: DDNC.System.Private.CoreLib.DNObject);
    function IsEnabled(name: string): Boolean; overload;
    function IsEnabled(name: string; arg1: DDNC.System.Private.CoreLib.DNObject; arg2: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function StartActivity(activity: DNActivity; args: DDNC.System.Private.CoreLib.DNObject): DNActivity;
    procedure StopActivity(activity: DNActivity; args: DDNC.System.Private.CoreLib.DNObject);
    procedure OnActivityImport(activity: DNActivity; payload: DDNC.System.Private.CoreLib.DNObject);
    procedure OnActivityExport(activity: DNActivity; payload: DDNC.System.Private.CoreLib.DNObject);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  end;

  TDNDiagnosticSource = class(TDNGenericImport<DNDiagnosticSourceClass, DNDiagnosticSource>) end;

  //-------------namespace: System.Diagnostics----------------
  DNDiagnosticListenerClass = interface(DNDiagnosticSourceClass)
  ['{6CAEC429-A4D4-5108-B3F5-17E6EA65DE01}']
  { static getter & setter } 

    {class} function get_AllListeners: DDNC.System.Private.CoreLib.DNIObservable<DNDiagnosticListener>;

  { constructors } 

    {class} function init(name: string): DNDiagnosticListener;

  { static propertys } 

    {class} property AllListeners: DDNC.System.Private.CoreLib.DNIObservable<DNDiagnosticListener> read get_AllListeners;
  end;

  [DNTypeName('System.Diagnostics.DiagnosticListener')]
  DNDiagnosticListener = interface(DNDiagnosticSource)
  ['{F51976BD-CABA-34BA-A514-B648E15ED075}']
  { getters & setters } 

    function get_Name: string;

  { methods } 

    function Subscribe(observer: DDNC.System.Private.CoreLib.DNIObserver<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>; isEnabled: DDNC.System.Private.CoreLib.DNPredicate<string>): DDNC.System.Private.CoreLib.DNIDisposable; overload;
    function Subscribe(observer: DDNC.System.Private.CoreLib.DNIObserver<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>; isEnabled: DDNC.System.Private.CoreLib.DNFunc<string, DDNC.System.Private.CoreLib.DNObject, DDNC.System.Private.CoreLib.DNObject, Boolean>): DDNC.System.Private.CoreLib.DNIDisposable; overload;
    function Subscribe(observer: DDNC.System.Private.CoreLib.DNIObserver<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>): DDNC.System.Private.CoreLib.DNIDisposable; overload;
    procedure Dispose;
    function ToString: string;
    function IsEnabled: Boolean; overload;
    function IsEnabled(name: string): Boolean; overload;
    function IsEnabled(name: string; arg1: DDNC.System.Private.CoreLib.DNObject; arg2: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    procedure Write(name: string; value: DDNC.System.Private.CoreLib.DNObject);
    procedure OnActivityImport(activity: DNActivity; payload: DDNC.System.Private.CoreLib.DNObject);
    procedure OnActivityExport(activity: DNActivity; payload: DDNC.System.Private.CoreLib.DNObject);
    function Subscribe(observer: DDNC.System.Private.CoreLib.DNIObserver<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>; isEnabled: DDNC.System.Private.CoreLib.DNFunc<string, DDNC.System.Private.CoreLib.DNObject, DDNC.System.Private.CoreLib.DNObject, Boolean>; onActivityImport: DDNC.System.Private.CoreLib.DNAction<DNActivity, DDNC.System.Private.CoreLib.DNObject>; onActivityExport: DDNC.System.Private.CoreLib.DNAction<DNActivity, DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNIDisposable; overload;
    function StartActivity(activity: DNActivity; args: DDNC.System.Private.CoreLib.DNObject): DNActivity;
    procedure StopActivity(activity: DNActivity; args: DDNC.System.Private.CoreLib.DNObject);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Name: string read get_Name;
  end;

  TDNDiagnosticListener = class(TDNGenericImport<DNDiagnosticListenerClass, DNDiagnosticListener>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivityContextClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{2569E68F-6090-5669-AFA3-947227D25ECF}']
  { constructors } 

    {class} function init(traceId: DNActivityTraceId; spanId: DNActivitySpanId; traceFlags: DNActivityTraceFlags; traceState: string; isRemote: Boolean): DNActivityContext;

  { static methods } 

    {class} function TryParse(traceParent: string; traceState: string; out context: DNActivityContext): Boolean;
    {class} function Parse(traceParent: string; traceState: string): DNActivityContext;

  end;

  [DNTypeName('System.Diagnostics.ActivityContext')]
  DNActivityContext = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{CA081D66-7CD1-3FC1-BADE-A1BE04A57DCF}']
  { getters & setters } 

    function get_TraceId: DNActivityTraceId;
    function get_SpanId: DNActivitySpanId;
    function get_TraceFlags: DNActivityTraceFlags;
    function get_TraceState: string;
    function get_IsRemote: Boolean;

  { methods } 

    function Equals(value: DNActivityContext): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property TraceId: DNActivityTraceId read get_TraceId;
    property SpanId: DNActivitySpanId read get_SpanId;
    property TraceFlags: DNActivityTraceFlags read get_TraceFlags;
    property TraceState: string read get_TraceState;
    property IsRemote: Boolean read get_IsRemote;
  end;

  TDNActivityContext = class(TDNGenericImport<DNActivityContextClass, DNActivityContext>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivityCreationOptionsClass<T> = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{2BF3464A-8FEA-527F-9DC4-CEAF02C67154}']
  end;

  [DNTypeName('System.Diagnostics.ActivityCreationOptions`1')]
  DNActivityCreationOptions<T> = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{88886BA0-9314-38D6-B3E1-B17DC0C7E831}']
  { getters & setters } 

    function get_Source: DNActivitySource;
    function get_Name: string;
    function get_Kind: DNActivityKind;
    function get_Parent: T;
    function get_Tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>;
    function get_Links: DDNC.System.Private.CoreLib.DNIEnumerable<DNActivityLink>;
    function get_SamplingTags: DNActivityTagsCollection;
    function get_TraceId: DNActivityTraceId;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Source: DNActivitySource read get_Source;
    property Name: string read get_Name;
    property Kind: DNActivityKind read get_Kind;
    property Parent: T read get_Parent;
    property Tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>> read get_Tags;
    property Links: DDNC.System.Private.CoreLib.DNIEnumerable<DNActivityLink> read get_Links;
    property SamplingTags: DNActivityTagsCollection read get_SamplingTags;
    property TraceId: DNActivityTraceId read get_TraceId;
  end;

  TDNActivityCreationOptions<T> = class(TDNGenericImport<DNActivityCreationOptionsClass<T>, DNActivityCreationOptions<T>>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivityEventClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{DDE4B24F-D0E3-5C28-A230-6649F44438F4}']
  { constructors } 

    {class} function init(name: string): DNActivityEvent; overload;
    {class} function init(name: string; timestamp: DDNC.System.Private.CoreLib.DNDateTimeOffset; tags: DNActivityTagsCollection): DNActivityEvent; overload;

  end;

  [DNTypeName('System.Diagnostics.ActivityEvent')]
  DNActivityEvent = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{084AA0BE-9AD1-3135-BC10-CE3C2AF7C219}']
  { getters & setters } 

    function get_Name: string;
    function get_Timestamp: DDNC.System.Private.CoreLib.DNDateTimeOffset;
    function get_Tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Timestamp: DDNC.System.Private.CoreLib.DNDateTimeOffset read get_Timestamp;
    property Tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>> read get_Tags;
  end;

  TDNActivityEvent = class(TDNGenericImport<DNActivityEventClass, DNActivityEvent>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivityLinkClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{5329FEFF-3CF2-503F-AA3C-852F4EFA53DC}']
  { constructors } 

    {class} function init(context: DNActivityContext; tags: DNActivityTagsCollection): DNActivityLink;

  end;

  [DNTypeName('System.Diagnostics.ActivityLink')]
  DNActivityLink = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{A025A986-3312-3C3E-A543-D97454310A45}']
  { getters & setters } 

    function get_Context: DNActivityContext;
    function get_Tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>>;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function Equals(value: DNActivityLink): Boolean; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Context: DNActivityContext read get_Context;
    property Tags: DDNC.System.Private.CoreLib.DNIEnumerable<DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>> read get_Tags;
  end;

  TDNActivityLink = class(TDNGenericImport<DNActivityLinkClass, DNActivityLink>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivitySpanIdClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{5CD3D713-3BF4-5727-8944-7B46DE6DCD29}']
  { static methods } 

    {class} function CreateRandom: DNActivitySpanId;
    {class} function CreateFromBytes(idData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNActivitySpanId;
    {class} function CreateFromUtf8String(idData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNActivitySpanId;
    {class} function CreateFromString(idData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>): DNActivitySpanId;

  end;

  [DNTypeName('System.Diagnostics.ActivitySpanId')]
  DNActivitySpanId = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{7DC19118-7439-30BF-9F60-F66F432F9155}']
  { methods } 

    function ToHexString: string;
    function ToString: string;
    function Equals(spanId: DNActivitySpanId): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>);
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNActivitySpanId = class(TDNGenericImport<DNActivitySpanIdClass, DNActivitySpanId>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivityTagsCollection_EnumeratorClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{64B484C9-300E-5478-A19D-5AAB1C719D77}']
  end;

  [DNTypeName('System.Diagnostics.ActivityTagsCollection+Enumerator')]
  DNActivityTagsCollection_Enumerator = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{A74C4929-71F9-3F97-9BEB-A13CDAFD94D2}']
  { getters & setters } 

    function get_Current: DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject>;

  { methods } 

    procedure Dispose;
    function MoveNext: Boolean;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Current: DDNC.System.Private.CoreLib.DNKeyValuePair<string, DDNC.System.Private.CoreLib.DNObject> read get_Current;
  end;

  TDNActivityTagsCollection_Enumerator = class(TDNGenericImport<DNActivityTagsCollection_EnumeratorClass, DNActivityTagsCollection_Enumerator>) end;

  //-------------namespace: System.Diagnostics----------------
  DNActivityTraceIdClass = interface(DDNC.System.Private.CoreLib.DNValueTypeClass)
  ['{56F133BF-BA57-59BC-A42F-2FCBA29575D1}']
  { static methods } 

    {class} function CreateRandom: DNActivityTraceId;
    {class} function CreateFromBytes(idData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNActivityTraceId;
    {class} function CreateFromUtf8String(idData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Byte>): DNActivityTraceId;
    {class} function CreateFromString(idData: DDNC.System.Private.CoreLib.DNReadOnlySpan<Char>): DNActivityTraceId;

  end;

  [DNTypeName('System.Diagnostics.ActivityTraceId')]
  DNActivityTraceId = interface(DDNC.System.Private.CoreLib.DNValueType)
  ['{48DFE763-1789-3506-9766-22259E5B3336}']
  { methods } 

    function ToHexString: string;
    function ToString: string;
    function Equals(traceId: DNActivityTraceId): Boolean; overload;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    procedure CopyTo(destination: DDNC.System.Private.CoreLib.DNSpan<Byte>);
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNActivityTraceId = class(TDNGenericImport<DNActivityTraceIdClass, DNActivityTraceId>) end;


implementation


initialization
  InternalTryLoadAssemblyModule('System.Diagnostics.DiagnosticSource, Version=5.0.0.0, Culture=neutral, PublicKeyToken=cc7b13ffcd2ddd51');

finalization

end.
