//----------------------------------------------------------------------------
//  Aspose.Words.dll: Aspose.Words, Version=21.6.0.0, Culture=neutral, PublicKeyToken=716fcc553a201e56
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Framework: 4.0
//----------------------------------------------------------------------------
//  UnitName: DDN.Aspose.Words
//  Author: ying32
//----------------------------------------------------------------------------

unit DDN.Aspose.Words;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDN.mscorlib,
  DDN.System.Drawing,
  DDN.System,
  DDN.System.Data,
  DDN.System.Xml,
  DDN.System.Web;

type

{ enums }

  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies sides of a border.
  ///</summary>
  [DNTypeName('Aspose.Words.BorderType')]
  DNBorderType = type Integer;
  DNBorderTypeHelper = record helper for DNBorderType
  public const
    ///<summary>
    ///  Specifies the bottom border of a paragraph or a table cell.
    ///</summary>
    Bottom = 0;
    ///<summary>
    ///  Specifies the left border of a paragraph or a table cell.
    ///</summary>
    Left = 1;
    ///<summary>
    ///  Specifies the right border of a paragraph or a table cell.
    ///</summary>
    Right = 2;
    ///<summary>
    ///  Specifies the top border of a paragraph or a table cell.
    ///</summary>
    Top = 3;
    ///<summary>
    ///  Specifies the horizontal border between cells in a table or between conforming paragraphs.
    ///</summary>
    Horizontal = 4;
    ///<summary>
    ///  Specifies the vertical border between cells in a table.
    ///</summary>
    Vertical = 5;
    ///<summary>
    ///  Specifies the diagonal border in a table cell.
    ///</summary>
    DiagonalDown = 6;
    ///<summary>
    ///  Specifies the diagonal border in a table cell.
    ///</summary>
    DiagonalUp = 7;
    ///<summary>
    ///  Default value.
    ///</summary>
    None = -1;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies type of a break inside a document.
  ///</summary>
  [DNTypeName('Aspose.Words.BreakType')]
  DNBreakType = type Integer;
  DNBreakTypeHelper = record helper for DNBreakType
  public const
    ///<summary>
    ///  Break between paragraphs.
    ///</summary>
    ParagraphBreak = 0;
    ///<summary>
    ///  Explicit page break.
    ///</summary>
    PageBreak = 1;
    ///<summary>
    ///  Explicit column break.
    ///</summary>
    ColumnBreak = 2;
    ///<summary>
    ///  Specifies start of new section on the same page as the previous section.
    ///</summary>
    SectionBreakContinuous = 3;
    ///<summary>
    ///  Specifies start of new section in the new column.
    ///</summary>
    SectionBreakNewColumn = 4;
    ///<summary>
    ///  Specifies start of new section on a new page.
    ///</summary>
    SectionBreakNewPage = 5;
    ///<summary>
    ///  Specifies start of new section on a new even page.
    ///</summary>
    SectionBreakEvenPage = 6;
    ///<summary>
    ///  Specifies start of new section on a odd page.
    ///</summary>
    SectionBreakOddPage = 7;
    ///<summary>
    ///  Explicit line break.
    ///</summary>
    LineBreak = 8;
  end;


  //-------------namespace: Aspose.Words.BuildingBlocks----------------
  ///<summary>
  ///  Specifies the behavior that shall be applied to the contents of the building block
  ///  when it is inserted into the main document.
  ///</summary>
  ///<remarks><para>Corresponds to the <b>ST_DocPartBehavior</b>
  ///  type in OOXML.</para><seealso cref="P:Aspose.Words.BuildingBlocks.BuildingBlock.Behavior" />
  ///</remarks>
  [DNTypeName('Aspose.Words.BuildingBlocks.BuildingBlockBehavior')]
  DNBuildingBlockBehavior = type Integer;
  DNBuildingBlockBehaviorHelper = record helper for DNBuildingBlockBehavior
  public const
    ///<summary>
    ///  Same as <see cref="F:Aspose.Words.BuildingBlocks.BuildingBlockBehavior.Content" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that the building block shall be inserted as inline content.
    ///</summary>
    Content = 0;
    ///<summary>
    ///  Specifies that the building block shall be inserted into its own paragraph.
    ///</summary>
    Paragraph = 1;
    ///<summary>
    ///  Specifies that the building block shall be added into its own page.
    ///</summary>
    Page = 2;
  end;


  //-------------namespace: Aspose.Words.BuildingBlocks----------------
  ///<summary>
  ///  Specifies the predefined gallery into which a building block is classified.
  ///</summary>
  ///<remarks><para>Corresponds to the <b>ST_DocPartGallery</b>
  ///  type in OOXML.</para><seealso cref="P:Aspose.Words.BuildingBlocks.BuildingBlock.Gallery" />
  ///</remarks>
  [DNTypeName('Aspose.Words.BuildingBlocks.BuildingBlockGallery')]
  DNBuildingBlockGallery = type Integer;
  DNBuildingBlockGalleryHelper = record helper for DNBuildingBlockGallery
  public const
    ///<summary>
    ///  Same as <see cref="F:Aspose.Words.BuildingBlocks.BuildingBlockGallery.All" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that this glossary document entry shall be associated with all possible gallery classification values.
    ///</summary>
    All = 0;
    ///<summary></summary>
    AutoText = 1;
    ///<summary></summary>
    Bibliography = 2;
    ///<summary></summary>
    CoverPage = 3;
    ///<summary></summary>
    CustomAutoText = 4;
    ///<summary></summary>
    CustomBibliography = 5;
    ///<summary></summary>
    CustomCoverPage = 6;
    ///<summary></summary>
    CustomEquations = 7;
    ///<summary></summary>
    CustomFooters = 8;
    ///<summary></summary>
    CustomHeaders = 9;
    ///<summary></summary>
    Custom1 = 10;
    ///<summary></summary>
    Custom2 = 11;
    ///<summary></summary>
    Custom3 = 12;
    ///<summary></summary>
    Custom4 = 13;
    ///<summary></summary>
    Custom5 = 14;
    ///<summary></summary>
    CustomPageNumber = 15;
    ///<summary></summary>
    CustomPageNumberAtBottom = 16;
    ///<summary></summary>
    CustomPageNumberAtMargin = 17;
    ///<summary></summary>
    CustomPageNumberAtTop = 18;
    ///<summary></summary>
    CustomQuickParts = 19;
    ///<summary></summary>
    CustomTableOfContents = 20;
    ///<summary></summary>
    CustomTables = 21;
    ///<summary></summary>
    CustomTextBox = 22;
    ///<summary></summary>
    CustomWatermarks = 23;
    ///<summary></summary>
    NoGallery = 24;
    ///<summary></summary>
    QuickParts = 25;
    ///<summary></summary>
    Equations = 26;
    ///<summary></summary>
    Footers = 27;
    ///<summary></summary>
    Headers = 28;
    ///<summary></summary>
    PageNumber = 29;
    ///<summary></summary>
    PageNumberAtBottom = 30;
    ///<summary></summary>
    PageNumberAtMargin = 31;
    ///<summary></summary>
    PageNumberAtTop = 32;
    ///<summary></summary>
    StructuredDocumentTagPlaceholderText = 33;
    ///<summary></summary>
    TableOfContents = 34;
    ///<summary></summary>
    Tables = 35;
    ///<summary></summary>
    TextBox = 36;
    ///<summary></summary>
    Watermarks = 37;
  end;


  //-------------namespace: Aspose.Words.BuildingBlocks----------------
  ///<summary>
  ///  Specifies a building block type. The type might affect the visibility and behavior of the building block
  ///  in Microsoft Word.
  ///</summary>
  ///<remarks><para>Corresponds to the <b>ST_DocPartType</b>
  ///  type in OOXML.</para><seealso cref="P:Aspose.Words.BuildingBlocks.BuildingBlock.Type" />
  ///</remarks>
  [DNTypeName('Aspose.Words.BuildingBlocks.BuildingBlockType')]
  DNBuildingBlockType = type Integer;
  DNBuildingBlockTypeHelper = record helper for DNBuildingBlockType
  public const
    ///<summary>
    ///  Save as <see cref="F:Aspose.Words.BuildingBlocks.BuildingBlockType.None" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  No type information is specified for the building block.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Allows the building block to be automatically inserted into the document whenever
    ///  its name is entered into an application.
    ///</summary>
    AutomaticallyReplaceNameWithContent = 1;
    ///<summary>
    ///  The building block is a structured document tag placeholder text.
    ///</summary>
    StructuredDocumentTagPlaceholderText = 2;
    ///<summary>
    ///  The building block is a form field help text.
    ///</summary>
    FormFieldHelpText = 3;
    ///<summary>
    ///  The building block is a normal (i.e. regular) glossary document entry.
    ///</summary>
    Normal = 4;
    ///<summary>
    ///  The building block is associated with the spelling and grammar tools.
    ///</summary>
    AutoCorrect = 5;
    ///<summary>
    ///  The building block is an AutoText entry.
    ///</summary>
    AutoText = 6;
    ///<summary>
    ///  The building block is associated with all types.
    ///</summary>
    All = 7;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the type of a calendar.
  ///</summary>
  [DNTypeName('Aspose.Words.CalendarType')]
  DNCalendarType = type Integer;
  DNCalendarTypeHelper = record helper for DNCalendarType
  public const
    ///<summary>
    ///  The Gregorian calendar.
    ///</summary>
    Gregorian = 0;
    ///<summary>
    ///  The Hijri Lunar calendar.
    ///</summary>
    Hijri = 1;
    ///<summary>
    ///  The Hebrew Lunar calendar.
    ///</summary>
    Hebrew = 2;
    ///<summary>
    ///  The Saka Era calendar.
    ///</summary>
    SakaEra = 3;
    ///<summary>
    ///  The Um-al-Qura calendar.
    ///</summary>
    UmAlQura = 4;
  end;


  //-------------namespace: Aspose.Words.Comparing----------------
  ///<summary>
  ///  Allows to specify base document which will be used during comparison.  Default value is <see cref="F:Aspose.Words.Comparing.ComparisonTargetType.Current" />
  ///  .
  ///</summary>
  ///<remarks>
  ///  Relates to Microsoft Word "Show changes in" option in "Compare Documents" dialog box.
  ///</remarks>
  [DNTypeName('Aspose.Words.Comparing.ComparisonTargetType')]
  DNComparisonTargetType = type Integer;
  DNComparisonTargetTypeHelper = record helper for DNComparisonTargetType
  public const
    ///<summary>
    ///  This document is used as a base during comparison.
    ///</summary>
    Current = 0;
    ///<summary>
    ///  Other document is used as a base during comparison.
    ///</summary>
    New = 1;
  end;


  //-------------namespace: Aspose.Words.Comparing----------------
  ///<summary>
  ///  Specifies the granularity of changes to track when comparing two documents.
  ///</summary>
  [DNTypeName('Aspose.Words.Comparing.Granularity')]
  DNGranularity = type Integer;
  DNGranularityHelper = record helper for DNGranularity
  public const
    CharLevel = 0;
    WordLevel = 1;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Represents possible table areas to which conditional formatting may be defined in a table style.
  ///</summary>
  [DNTypeName('Aspose.Words.ConditionalStyleType')]
  DNConditionalStyleType = type Integer;
  DNConditionalStyleTypeHelper = record helper for DNConditionalStyleType
  public const
    ///<summary>
    ///  Specifies formatting of the first row of a table.
    ///</summary>
    FirstRow = 0;
    ///<summary>
    ///  Specifies formatting of the first column of a table.
    ///</summary>
    FirstColumn = 1;
    ///<summary>
    ///  Specifies formatting of the last row of a table.
    ///</summary>
    LastRow = 2;
    ///<summary>
    ///  Specifies formatting of the last column of a table.
    ///</summary>
    LastColumn = 3;
    ///<summary>
    ///  Specifies formatting of odd-numbered row stripe.
    ///</summary>
    OddRowBanding = 4;
    ///<summary>
    ///  Specifies formatting of odd-numbered column stripe.
    ///</summary>
    OddColumnBanding = 5;
    ///<summary>
    ///  Specifies formatting of even-numbered row stripe.
    ///</summary>
    EvenRowBanding = 6;
    ///<summary>
    ///  Specifies formatting of even-numbered column stripe.
    ///</summary>
    EvenColumnBanding = 7;
    ///<summary>
    ///  Specifies formatting of the top left cell of a table.
    ///</summary>
    TopLeftCell = 8;
    ///<summary>
    ///  Specifies formatting of the top right cell of a table.
    ///</summary>
    TopRightCell = 9;
    ///<summary>
    ///  Specifies formatting of the bottom left cell of a table.
    ///</summary>
    BottomLeftCell = 10;
    ///<summary>
    ///  Specifies formatting of the bottom right cell of a table.
    ///</summary>
    BottomRightCell = 11;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Enumerates different ways of presenting the document at the client browser.
  ///</summary>
  ///<remarks><para>Note that the actual behavior on the client browser might be affected by security configuration of the browser.</para></remarks>
  [DNTypeName('Aspose.Words.ContentDisposition')]
  DNContentDisposition = type Integer;
  DNContentDispositionHelper = record helper for DNContentDisposition
  public const
    ///<summary>
    ///  Send the document to the browser and present an option to save the document to disk or open in the application
    ///  associated with the document's extension.
    ///</summary>
    Attachment = 0;
    ///<summary>
    ///  Send the document to the browser and presents an option to save the document to disk or open inside the browser.
    ///</summary>
    Inline_ = 1;
  end;


  //-------------namespace: Aspose.Words.DigitalSignatures----------------
  ///<summary>
  ///  Specifies the type of a digital signature.
  ///</summary>
  [DNTypeName('Aspose.Words.DigitalSignatures.DigitalSignatureType')]
  DNDigitalSignatureType = type Integer;
  DNDigitalSignatureTypeHelper = record helper for DNDigitalSignatureType
  public const
    ///<summary>
    ///  Indicates an error, unknown digital signature type.
    ///</summary>
    Unknown = 0;
    ///<summary>
    ///  The Crypto API signature method used in Microsoft Word 97-2003 .DOC binary documents.
    ///</summary>
    CryptoApi = 1;
    ///<summary>
    ///  The XmlDsig signature method used in OOXML and OpenDocument documents.
    ///</summary>
    XmlDsig = 2;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Length of the arrow at the end of a line.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.StartArrowLength" />
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.EndArrowLength" />
  [DNTypeName('Aspose.Words.Drawing.ArrowLength')]
  DNArrowLength = type Integer;
  DNArrowLengthHelper = record helper for DNArrowLength
  public const
    ///<summary>
    ///  Same as <see cref="F:Aspose.Words.Drawing.ArrowLength.Short" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary></summary>
    Short = 0;
    ///<summary></summary>
    Medium = 1;
    ///<summary></summary>
    Long = 2;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies the type of an arrow at a line end.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.StartArrowType" />
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.EndArrowType" />
  [DNTypeName('Aspose.Words.Drawing.ArrowType')]
  DNArrowType = type Integer;
  DNArrowTypeHelper = record helper for DNArrowType
  public const
    ///<summary>
    ///  The line does not have an arrow at the end.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Same as <see cref="F:Aspose.Words.Drawing.ArrowType.None" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  The arrow is a solid triangle.
    ///</summary>
    Arrow = 1;
    ///<summary>
    ///  The arrow is a "stealth" arrow.
    ///</summary>
    Stealth = 2;
    ///<summary>
    ///  The line end is a solid diamond.
    ///</summary>
    Diamond = 3;
    ///<summary>
    ///  The line end is a solid oval.
    ///</summary>
    Oval = 4;
    ///<summary>
    ///  The arrow is an open arrow.
    ///</summary>
    Open = 5;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Width of the arrow at the end of a line.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.StartArrowWidth" />
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.EndArrowWidth" />
  [DNTypeName('Aspose.Words.Drawing.ArrowWidth')]
  DNArrowWidth = type Integer;
  DNArrowWidthHelper = record helper for DNArrowWidth
  public const
    ///<summary>
    ///  Same as <see cref="F:Aspose.Words.Drawing.ArrowWidth.Narrow" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary></summary>
    Narrow = 0;
    ///<summary></summary>
    Medium = 1;
    ///<summary></summary>
    Wide = 2;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies the display units for an axis.
  ///</summary>
  ///<dev>
  ///  Corresponds to the ST_BuiltInUnit simple type (5.7.3.6).
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisBuiltInUnit')]
  DNAxisBuiltInUnit = type Integer;
  DNAxisBuiltInUnitHelper = record helper for DNAxisBuiltInUnit
  public const
    ///<summary>
    ///  Specifies the values on the chart shall displayed as is.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by a user-defined divisor. This value is not supported
    ///  by the new chart types of MS Office 2016.
    ///</summary>
    Custom = 1;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 1,000,000,000.
    ///</summary>
    Billions = 2;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 100,000,000.
    ///</summary>
    HundredMillions = 3;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 100.
    ///</summary>
    Hundreds = 4;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 100,000.
    ///</summary>
    HundredThousands = 5;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 1,000,000.
    ///</summary>
    Millions = 6;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 10,000,000.
    ///</summary>
    TenMillions = 7;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 10,000.
    ///</summary>
    TenThousands = 8;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 1,000.
    ///</summary>
    Thousands = 9;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 1,000,000,000,0000.
    ///</summary>
    Trillions = 10;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 0.01. This value is supported only by the new chart
    ///  types of MS Office 2016.
    ///</summary>
    Percentage = 11;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies type of a category axis.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisCategoryType')]
  DNAxisCategoryType = type Integer;
  DNAxisCategoryTypeHelper = record helper for DNAxisCategoryType
  public const
    ///<summary>
    ///  Specifies that type of a category axis is determined automatically based on data.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Specifies an axis of an arbitrary set of categories.
    ///</summary>
    Category = 1;
    ///<summary>
    ///  Specifies a time category axis.
    ///</summary>
    Time = 2;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies the possible crossing points for an axis.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisCrosses')]
  DNAxisCrosses = type Integer;
  DNAxisCrossesHelper = record helper for DNAxisCrosses
  public const
    ///<summary>
    ///  The category axis crosses at the zero point of the value axis (if possible), or at the minimum value
    ///  if the minimum is greater than zero, or at the maximum if the maximum is less than zero.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  A perpendicular axis crosses at the maximum value of the axis.
    ///</summary>
    Maximum = 1;
    ///<summary>
    ///  A perpendicular axis crosses at the minimum value of the axis.
    ///</summary>
    Minimum = 2;
    ///<summary>
    ///  A perpendicular axis crosses at the specified value of the axis.
    ///</summary>
    Custom = 3;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies the possible scale types for an axis.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisScaleType')]
  DNAxisScaleType = type Integer;
  DNAxisScaleTypeHelper = record helper for DNAxisScaleType
  public const
    ///<summary>
    ///  Linear scaling.
    ///</summary>
    Linear = 0;
    ///<summary>
    ///  Logarithmic scaling.
    ///</summary>
    Logarithmic = 1;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies the possible positions for tick labels.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisTickLabelPosition')]
  DNAxisTickLabelPosition = type Integer;
  DNAxisTickLabelPositionHelper = record helper for DNAxisTickLabelPosition
  public const
    ///<summary>
    ///  Specifies the axis labels shall be at the high end of the perpendicular axis.
    ///</summary>
    High = 0;
    ///<summary>
    ///  Specifies the axis labels shall be at the low end of the perpendicular axis.
    ///</summary>
    Low = 1;
    ///<summary>
    ///  Specifies the axis labels shall be next to the axis.
    ///</summary>
    NextToAxis = 2;
    ///<summary>
    ///  Specifies default value of tick labels position.
    ///</summary>
    Default_ = 2;
    ///<summary>
    ///  Specifies the axis labels are not drawn.
    ///</summary>
    None = 3;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies the possible positions for tick marks.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisTickMark')]
  DNAxisTickMark = type Integer;
  DNAxisTickMarkHelper = record helper for DNAxisTickMark
  public const
    ///<summary>
    ///  Specifies that the tick marks shall cross the axis.
    ///</summary>
    Cross = 0;
    ///<summary>
    ///  Specifies that the tick marks shall be inside the plot area.
    ///</summary>
    Inside = 1;
    ///<summary>
    ///  Specifies that the tick marks shall be outside the plot area.
    ///</summary>
    Outside = 2;
    ///<summary>
    ///  Specifies that there shall be no tick marks.
    ///</summary>
    None = 3;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies the unit of time for axes.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisTimeUnit')]
  DNAxisTimeUnit = type Integer;
  DNAxisTimeUnitHelper = record helper for DNAxisTimeUnit
  public const
    ///<summary>
    ///  Specifies that unit was not set explicitly and default value should be used.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Specifies that the chart data shall be shown in days.
    ///</summary>
    Days = 1;
    ///<summary>
    ///  Specifies that the chart data shall be shown in months.
    ///</summary>
    Months = 2;
    ///<summary>
    ///  Specifies that the chart data shall be shown in years.
    ///</summary>
    Years = 3;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies type of chart axis.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartAxisType')]
  DNChartAxisType = type Integer;
  DNChartAxisTypeHelper = record helper for DNChartAxisType
  public const
    ///<summary>
    ///  Category axis of a chart.
    ///</summary>
    Category = 0;
    ///<summary>
    ///  Series axis of a chart.
    ///</summary>
    Series = 1;
    ///<summary>
    ///  Value axis of a chart.
    ///</summary>
    Value = 2;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies type of a chart.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartType')]
  DNChartType = type Integer;
  DNChartTypeHelper = record helper for DNChartType
  public const
    ///<summary>
    ///  Area chart.
    ///</summary>
    Area = 0;
    ///<summary>
    ///  Stacked Area chart.
    ///</summary>
    AreaStacked = 1;
    ///<summary>
    ///  100% Stacked Area chart.
    ///</summary>
    AreaPercentStacked = 2;
    ///<summary>
    ///  3D Area chart.
    ///</summary>
    Area3D = 3;
    ///<summary>
    ///  3D Stacked Area chart.
    ///</summary>
    Area3DStacked = 4;
    ///<summary>
    ///  3D 100% Stacked Area chart.
    ///</summary>
    Area3DPercentStacked = 5;
    ///<summary>
    ///  Bar chart.
    ///</summary>
    Bar = 6;
    ///<summary>
    ///  Stacked Bar chart.
    ///</summary>
    BarStacked = 7;
    ///<summary>
    ///  100% Stacked Bar chart.
    ///</summary>
    BarPercentStacked = 8;
    ///<summary>
    ///  3D Bar chart.
    ///</summary>
    Bar3D = 9;
    ///<summary>
    ///  3D Stacked Bar chart.
    ///</summary>
    Bar3DStacked = 10;
    ///<summary>
    ///  3D 100% Stacked Bar chart.
    ///</summary>
    Bar3DPercentStacked = 11;
    ///<summary>
    ///  Bubble chart.
    ///</summary>
    Bubble = 12;
    ///<summary>
    ///  3D Bubble chart.
    ///</summary>
    Bubble3D = 13;
    ///<summary>
    ///  Column chart.
    ///</summary>
    Column = 14;
    ///<summary>
    ///  Stacked Column chart.
    ///</summary>
    ColumnStacked = 15;
    ///<summary>
    ///  100% Stacked Column chart.
    ///</summary>
    ColumnPercentStacked = 16;
    ///<summary>
    ///  3D Column chart.
    ///</summary>
    Column3D = 17;
    ///<summary>
    ///  3D Stacked Column chart.
    ///</summary>
    Column3DStacked = 18;
    ///<summary>
    ///  3D 100% Stacked Column chart.
    ///</summary>
    Column3DPercentStacked = 19;
    ///<summary>
    ///  3D Clustered Column chart.
    ///</summary>
    Column3DClustered = 20;
    ///<summary>
    ///  Doughnut chart.
    ///</summary>
    Doughnut = 21;
    ///<summary>
    ///  Line chart.
    ///</summary>
    Line = 22;
    ///<summary>
    ///  Stacked Line chart.
    ///</summary>
    LineStacked = 23;
    ///<summary>
    ///  100% Stacked Line chart.
    ///</summary>
    LinePercentStacked = 24;
    ///<summary>
    ///  3D Line chart.
    ///</summary>
    Line3D = 25;
    ///<summary>
    ///  Pie chart.
    ///</summary>
    Pie = 26;
    ///<summary>
    ///  3D Pie chart.
    ///</summary>
    Pie3D = 27;
    ///<summary>
    ///  Pie of Bar chart.
    ///</summary>
    PieOfBar = 28;
    ///<summary>
    ///  Pie of Pie chart.
    ///</summary>
    PieOfPie = 29;
    ///<summary>
    ///  Radar chart.
    ///</summary>
    Radar = 30;
    ///<summary>
    ///  Scatter chart.
    ///</summary>
    Scatter = 31;
    ///<summary>
    ///  Stock chart.
    ///</summary>
    Stock = 32;
    ///<summary>
    ///  Surface chart.
    ///</summary>
    Surface = 33;
    ///<summary>
    ///  3D Surface chart.
    ///</summary>
    Surface3D = 34;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies the possible positions for a chart legend.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.LegendPosition')]
  DNLegendPosition = type Integer;
  DNLegendPositionHelper = record helper for DNLegendPosition
  public const
    ///<summary>
    ///  No legend will be shown for the chart.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Specifies that the legend shall be drawn at the bottom of the chart.
    ///</summary>
    Bottom = 1;
    ///<summary>
    ///  Specifies that the legend shall be drawn at the left of the chart.
    ///</summary>
    Left = 2;
    ///<summary>
    ///  Specifies that the legend shall be drawn at the right of the chart.
    ///</summary>
    Right = 3;
    ///<summary>
    ///  Specifies that the legend shall be drawn at the top of the chart.
    ///</summary>
    Top = 4;
    ///<summary>
    ///  Specifies that the legend shall be drawn at the top right of the chart.
    ///</summary>
    TopRight = 5;
  end;


  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Specifies marker symbol style.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.MarkerSymbol')]
  DNMarkerSymbol = type Integer;
  DNMarkerSymbolHelper = record helper for DNMarkerSymbol
  public const
    ///<summary>
    ///  Specifies a default marker symbol shall be drawn at each data point.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies a circle shall be drawn at each data point.
    ///</summary>
    Circle = 1;
    ///<summary>
    ///  Specifies a dash shall be drawn at each data point.
    ///</summary>
    Dash = 2;
    ///<summary>
    ///  Specifies a diamond shall be drawn at each data point.
    ///</summary>
    Diamond = 3;
    ///<summary>
    ///  Specifies a dot shall be drawn at each data point.
    ///</summary>
    Dot = 4;
    ///<summary>
    ///  Specifies nothing shall be drawn at each data point.
    ///</summary>
    None = 5;
    ///<summary>
    ///  Specifies a picture shall be drawn at each data point.
    ///</summary>
    Picture = 6;
    ///<summary>
    ///  Specifies a plus shall be drawn at each data point.
    ///</summary>
    Plus = 7;
    ///<summary>
    ///  Specifies a square shall be drawn at each data point.
    ///</summary>
    Square = 8;
    ///<summary>
    ///  Specifies a star shall be drawn at each data point.
    ///</summary>
    Star = 9;
    ///<summary>
    ///  Specifies a triangle shall be drawn at each data point.
    ///</summary>
    Triangle = 10;
    ///<summary>
    ///  Specifies an X shall be drawn at each data point.
    ///</summary>
    X = 11;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Dashed line style.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.DashStyle" />
  [DNTypeName('Aspose.Words.Drawing.DashStyle')]
  DNDashStyle = type Integer;
  DNDashStyleHelper = record helper for DNDashStyle
  public const
    ///<summary>
    ///  Same as <see cref="F:Aspose.Words.Drawing.DashStyle.Solid" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Solid (continuous) pen.
    ///</summary>
    Solid = 0;
    ///<summary>
    ///  System dash style.
    ///</summary>
    ShortDash = 1;
    ///<summary>
    ///  System dash style.
    ///</summary>
    ShortDot = 2;
    ///<summary>
    ///  System dash style.
    ///</summary>
    ShortDashDot = 3;
    ///<summary>
    ///  System dash style.
    ///</summary>
    ShortDashDotDot = 4;
    ///<summary>
    ///  Square dot style.
    ///</summary>
    Dot = 5;
    ///<summary>
    ///  Dash style.
    ///</summary>
    Dash = 6;
    ///<summary>
    ///  Long dash style.
    ///</summary>
    LongDash = 7;
    ///<summary>
    ///  Dash short dash.
    ///</summary>
    DashDot = 8;
    ///<summary>
    ///  Long dash short dash.
    ///</summary>
    LongDashDot = 9;
    ///<summary>
    ///  Long dash short dash short dash.
    ///</summary>
    LongDashDotDot = 10;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies line cap style.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.EndCap" />
  [DNTypeName('Aspose.Words.Drawing.EndCap')]
  DNEndCap = type Integer;
  DNEndCapHelper = record helper for DNEndCap
  public const
    ///<summary>
    ///  Rounded ends.
    ///</summary>
    Round = 0;
    ///<summary>
    ///  Square protrudes by half line width.
    ///</summary>
    Square = 1;
    ///<summary>
    ///  Line ends at end point.
    ///</summary>
    Flat = 2;
    ///<summary>
    ///  Default value is <see cref="F:Aspose.Words.Drawing.EndCap.Flat" />
    ///  .
    ///</summary>
    Default_ = 2;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies fill type for a fillable object.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.FillType')]
  DNFillType = type Integer;
  DNFillTypeHelper = record helper for DNFillType
  public const
    ///<summary>
    ///  Solid fill.
    ///</summary>
    Solid = 1;
    ///<summary>
    ///  Patterned fill.
    ///</summary>
    Patterned = 2;
    ///<summary>
    ///  Gradient fill.
    ///</summary>
    Gradient = 3;
    ///<summary>
    ///  Textured fill.
    ///</summary>
    Textured = 4;
    ///<summary>
    ///  Fill is the same as the background.
    ///</summary>
    Background = 5;
    ///<summary>
    ///  Picture fill.
    ///</summary>
    Picture = 6;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Possible values for the orientation of a shape.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ShapeBase.FlipOrientation" />
  [DNTypeName('Aspose.Words.Drawing.FlipOrientation')]
  DNFlipOrientation = type Integer;
  DNFlipOrientationHelper = record helper for DNFlipOrientation
  public const
    ///<summary>
    ///  Coordinates are not flipped.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Flip along the y-axis, reversing the x-coordinates.
    ///</summary>
    Horizontal = 1;
    ///<summary>
    ///  Flip along the x-axis, reversing the y-coordinates.
    ///</summary>
    Vertical = 2;
    ///<summary>
    ///  Flip along both the y- and x-axis.
    ///</summary>
    Both = 3;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies horizontal alignment of a floating shape, text frame or floating table.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ShapeBase.HorizontalAlignment" />
  ///<dev>
  ///  Do not renumber. The values are taken from the RTF specification.
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.HorizontalAlignment')]
  DNHorizontalAlignment = type Integer;
  DNHorizontalAlignmentHelper = record helper for DNHorizontalAlignment
  public const
    ///<summary>
    ///  The object is explicitly positioned, usually using its <b>Left</b>
    ///  property.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Same as <see cref="F:Aspose.Words.Drawing.HorizontalAlignment.None" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that the object shall be left aligned to the horizontal alignment base.
    ///</summary>
    Left = 1;
    ///<summary>
    ///  Specifies that the object shall be centered with respect to the horizontal alignment base.
    ///</summary>
    Center = 2;
    ///<summary>
    ///  Specifies that the object shall be right aligned to the horizontal alignment base.
    ///</summary>
    Right = 3;
    ///<summary>
    ///  Specifies that the object shall be inside of the horizontal alignment base.
    ///</summary>
    Inside = 4;
    ///<summary>
    ///  Specifies that the object shall be outside of the horizontal alignment base.
    ///</summary>
    Outside = 5;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Represents the alignment for the specified horizontal rule.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.HorizontalRuleAlignment')]
  DNHorizontalRuleAlignment = type Integer;
  DNHorizontalRuleAlignmentHelper = record helper for DNHorizontalRuleAlignment
  public const
    ///<summary>
    ///  Aligned to the left.
    ///</summary>
    Left = 0;
    ///<summary>
    ///  Aligned to the center.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Aligned to the right.
    ///</summary>
    Right = 2;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies the type (format) of an image in a Microsoft Word document.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ImageData.ImageType" />
  ///<dev>
  ///  Do not renumber these. The values correspond to MSOBLIPTYPE in the Binary Drawing format.
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.ImageType')]
  DNImageType = type Integer;
  DNImageTypeHelper = record helper for DNImageType
  public const
    ///<summary>
    ///  The is no image data.
    ///</summary>
    ///<dev>
    ///  The spec says: "An error occurred during loading."
    ///  I've seen this in some places, more likely it means "this blip record is unused".
    ///</dev>
    NoImage = 0;
    ///<summary>
    ///  An unknown image type or image type that cannot be directly stored inside a Microsoft Word document.
    ///</summary>
    Unknown = 1;
    ///<summary>
    ///  Windows Enhanced Metafile.
    ///</summary>
    Emf = 2;
    ///<summary>
    ///  Windows Metafile.
    ///</summary>
    Wmf = 3;
    ///<summary>
    ///  Macintosh PICT. An existing image will be preserved in a document, but inserting new
    ///  PICT images into a document is not supported.
    ///</summary>
    Pict = 4;
    ///<summary>
    ///  JPEG JFIF.
    ///</summary>
    Jpeg = 5;
    ///<summary>
    ///  Portable Network Graphics.
    ///</summary>
    Png = 6;
    ///<summary>
    ///  Windows Bitmap.
    ///</summary>
    ///<dev>
    ///  Note this is BMP in my model, but in a Word document this is stored as a DIB.
    ///  DIB is basically a BMP without a header.
    ///</dev>
    Bmp = 7;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Line join style.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.JoinStyle" />
  [DNTypeName('Aspose.Words.Drawing.JoinStyle')]
  DNJoinStyle = type Integer;
  DNJoinStyleHelper = record helper for DNJoinStyle
  public const
    ///<summary>
    ///  Join edges by a straight line.
    ///</summary>
    Bevel = 0;
    ///<summary>
    ///  Extend edges until they join.
    ///</summary>
    Miter = 1;
    ///<summary>
    ///  Draw an arc between the two edges.
    ///</summary>
    Round = 2;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Determines the flow of the text layout in a textbox.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.TextBox.LayoutFlow" />
  ///<dev>
  ///  Do not renumber. The values are from the RTF spec.
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.LayoutFlow')]
  DNLayoutFlow = type Integer;
  DNLayoutFlowHelper = record helper for DNLayoutFlow
  public const
    ///<summary>
    ///  Text is displayed horizontally.
    ///</summary>
    Horizontal = 0;
    ///<summary>
    ///  Ideographic text is displayed vertically.
    ///</summary>
    TopToBottomIdeographic = 1;
    ///<summary>
    ///  Text is displayed vertically.
    ///</summary>
    BottomToTop = 2;
    ///<summary>
    ///  Text is displayed vertically.
    ///</summary>
    TopToBottom = 3;
    ///<summary>
    ///  Ideographic text is displayed horizontally.
    ///</summary>
    HorizontalIdeographic = 4;
    ///<summary>
    ///  Text is displayed vertically.
    ///</summary>
    Vertical = 5;
  end;


  //-------------namespace: Aspose.Words.Drawing.Ole----------------
  [DNTypeName('Aspose.Words.Drawing.Ole.Forms2OleControlType')]
  DNForms2OleControlType = type Integer;
  DNForms2OleControlTypeHelper = record helper for DNForms2OleControlType
  public const
    OptionButton = 0;
    Label_ = 1;
    Textbox = 2;
    CheckBox = 3;
    ToggleButton = 4;
    SpinButton = 5;
    ComboBox = 6;
    Frame = 7;
    MultiPage = 8;
    TabStrip = 9;
    CommandButton = 10;
    Image = 11;
    ScrollBar = 12;
    Form = 13;
    ListBox = 14;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  [DNTypeName('Aspose.Words.Drawing.PresetTexture')]
  DNPresetTexture = type Integer;
  DNPresetTextureHelper = record helper for DNPresetTexture
  public const
    BlueTissuePaper = 1;
    Bouquet = 2;
    BrownMarble = 3;
    Canvas = 4;
    Cork = 5;
    Denim = 6;
    FishFossil = 7;
    Granite = 8;
    GreenMarble = 9;
    MediumWood = 10;
    Newsprint = 11;
    Oak = 12;
    PaperBag = 13;
    Papyrus = 14;
    Parchment = 15;
    PinkTissuePaper = 16;
    PurpleMesh = 17;
    RecycledPaper = 18;
    Sand = 19;
    Stationery = 20;
    Walnut = 21;
    WaterDroplets = 22;
    WhiteMarble = 23;
    WovenMat = 24;
    None = -1;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies to what the horizontal position of a shape or text frame is relative.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ShapeBase.RelativeHorizontalPosition" />
  ///<dev>
  ///  Do not renumber. The values are taken from the RTF specification.
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.RelativeHorizontalPosition')]
  DNRelativeHorizontalPosition = type Integer;
  DNRelativeHorizontalPositionHelper = record helper for DNRelativeHorizontalPosition
  public const
    ///<summary>
    ///  Specifies that the horizontal positioning shall be relative to the page margins.
    ///</summary>
    Margin = 0;
    ///<summary>
    ///  The object is positioned relative to the left edge of the page.
    ///</summary>
    Page = 1;
    ///<summary>
    ///  The object is positioned relative to the left side of the column.
    ///</summary>
    Column = 2;
    ///<summary>
    ///  Default value is <see cref="F:Aspose.Words.Drawing.RelativeHorizontalPosition.Column" />
    ///  .
    ///</summary>
    Default_ = 2;
    ///<summary>
    ///  The object is positioned relative to the left side of the paragraph.
    ///</summary>
    Character = 3;
    ///<summary>
    ///  Specifies that the horizontal positioning shall be relative to the left margin of the page.
    ///</summary>
    LeftMargin = 4;
    ///<summary>
    ///  Specifies that the horizontal positioning shall be relative to the right margin of the page.
    ///</summary>
    RightMargin = 5;
    ///<summary>
    ///  Specifies that the horizontal positioning shall be relative to the inside margin of the
    ///  current page (the left margin on odd pages, right on even pages).
    ///</summary>
    InsideMargin = 6;
    ///<summary>
    ///  Specifies that the horizontal positioning shall be relative to the outside margin of the
    ///  current page (the right margin on odd pages, left on even pages).
    ///</summary>
    OutsideMargin = 7;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies to what the vertical position of a shape or text frame is relative.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ShapeBase.RelativeVerticalPosition" />
  ///<dev>
  ///  Do not renumber. The values are taken from the RTF specification.
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.RelativeVerticalPosition')]
  DNRelativeVerticalPosition = type Integer;
  DNRelativeVerticalPositionHelper = record helper for DNRelativeVerticalPosition
  public const
    ///<summary>
    ///  Specifies that the vertical positioning shall be relative to the page margins.
    ///</summary>
    Margin = 0;
    ///<summary>
    ///  Default value is <see cref="F:Aspose.Words.Drawing.RelativeVerticalPosition.Margin" />
    ///  .
    ///</summary>
    TableDefault = 0;
    ///<summary>
    ///  The object is positioned relative to the top edge of the page.
    ///</summary>
    Page = 1;
    ///<summary>
    ///  The object is positioned relative to the top of the paragraph that contains the anchor.
    ///</summary>
    Paragraph = 2;
    ///<summary>
    ///  Default value is <see cref="F:Aspose.Words.Drawing.RelativeVerticalPosition.Paragraph" />
    ///  .
    ///</summary>
    TextFrameDefault = 2;
    ///<summary>
    ///  Undocumented.
    ///</summary>
    Line = 3;
    ///<summary>
    ///  Specifies that the vertical positioning shall be relative to the top margin of the current page.
    ///</summary>
    TopMargin = 4;
    ///<summary>
    ///  Specifies that the vertical positioning shall be relative to the bottom margin of the current page.
    ///</summary>
    BottomMargin = 5;
    ///<summary>
    ///  Specifies that the vertical positioning shall be relative to the inside margin of the current page.
    ///</summary>
    InsideMargin = 6;
    ///<summary>
    ///  Specifies that the vertical positioning shall be relative to the outside margin of the current page.
    ///</summary>
    OutsideMargin = 7;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies the compound line style of a <see cref="T:Aspose.Words.Drawing.Shape" />
  ///  .
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.Stroke.LineStyle" />
  ///<dev>
  ///  This enum name violates the rule "enum name equals property name", but I have to avoid
  ///  collision between Aspose.Words.LineStyle and this line style because otherwise it will
  ///  be too hard to port to Java as all types are in the same namespace in Java.
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.ShapeLineStyle')]
  DNShapeLineStyle = type Integer;
  DNShapeLineStyleHelper = record helper for DNShapeLineStyle
  public const
    ///<summary>
    ///  Single line.
    ///</summary>
    Single = 0;
    ///<summary>
    ///  Default value is <see cref="F:Aspose.Words.Drawing.ShapeLineStyle.Single" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Double lines of equal width.
    ///</summary>
    Double = 1;
    ///<summary>
    ///  Double lines, one thick, one thin.
    ///</summary>
    ThickThin = 2;
    ///<summary>
    ///  Double lines, one thin, one thick.
    ///</summary>
    ThinThick = 3;
    ///<summary>
    ///  Three lines, thin, thick, thin.
    ///</summary>
    Triple = 4;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies Markup language used for the shape.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.ShapeMarkupLanguage')]
  DNShapeMarkupLanguage = type Integer;
  DNShapeMarkupLanguageHelper = record helper for DNShapeMarkupLanguage
  public const
    ///<summary>
    ///  Drawing Markup Language is used to define the shape.
    ///</summary>
    ///<remarks>
    ///  This is the new standard for drawing for Office Open XML which has appeared first in ECMA-376 1st edition (2006), first appeared in MS Word 2007.
    ///</remarks>
    Dml = 0;
    ///<summary>
    ///  Vector Markup Language is used to define the shape.
    ///</summary>
    ///<remarks>A deprecated format included in Office Open XML for legacy reasons only.</remarks>
    Vml = 1;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies the type of shape in a Microsoft Word document.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ShapeBase.ShapeType" />
  [DNTypeName('Aspose.Words.Drawing.ShapeType')]
  DNShapeType = type Integer;
  DNShapeTypeHelper = record helper for DNShapeType
  public const
    ///<summary>
    ///  A shape drawn by user and consisting of multiple segments and/or vertices (curve, freeform or scribble).
    ///  <p>You cannot create shapes of this type in the document.</p>
    ///</summary>
    NonPrimitive = 0;
    ///<summary></summary>
    Rectangle = 1;
    ///<summary></summary>
    RoundRectangle = 2;
    ///<summary></summary>
    Ellipse = 3;
    ///<summary></summary>
    Diamond = 4;
    ///<summary></summary>
    Triangle = 5;
    ///<summary></summary>
    RightTriangle = 6;
    ///<summary></summary>
    Parallelogram = 7;
    ///<summary></summary>
    Trapezoid = 8;
    ///<summary></summary>
    Hexagon = 9;
    ///<summary></summary>
    Octagon = 10;
    ///<summary></summary>
    Plus = 11;
    ///<summary></summary>
    Star = 12;
    ///<summary></summary>
    Arrow = 13;
    ///<summary></summary>
    ThickArrow = 14;
    ///<summary></summary>
    HomePlate = 15;
    ///<summary></summary>
    Cube = 16;
    ///<summary></summary>
    Balloon = 17;
    ///<summary></summary>
    Seal = 18;
    ///<summary></summary>
    Arc = 19;
    ///<summary></summary>
    Line = 20;
    ///<summary></summary>
    Plaque = 21;
    ///<summary></summary>
    Can = 22;
    ///<summary></summary>
    Donut = 23;
    ///<summary></summary>
    TextSimple = 24;
    ///<summary></summary>
    TextOctagon = 25;
    ///<summary></summary>
    TextHexagon = 26;
    ///<summary></summary>
    TextCurve = 27;
    ///<summary></summary>
    TextWave = 28;
    ///<summary></summary>
    TextRing = 29;
    ///<summary></summary>
    TextOnCurve = 30;
    ///<summary></summary>
    TextOnRing = 31;
    ///<summary></summary>
    StraightConnector1 = 32;
    ///<summary></summary>
    BentConnector2 = 33;
    ///<summary></summary>
    BentConnector3 = 34;
    ///<summary></summary>
    BentConnector4 = 35;
    ///<summary></summary>
    BentConnector5 = 36;
    ///<summary></summary>
    CurvedConnector2 = 37;
    ///<summary></summary>
    CurvedConnector3 = 38;
    ///<summary></summary>
    CurvedConnector4 = 39;
    ///<summary></summary>
    CurvedConnector5 = 40;
    ///<summary></summary>
    Callout1 = 41;
    ///<summary></summary>
    Callout2 = 42;
    ///<summary></summary>
    Callout3 = 43;
    ///<summary></summary>
    AccentCallout1 = 44;
    ///<summary></summary>
    AccentCallout2 = 45;
    ///<summary></summary>
    AccentCallout3 = 46;
    ///<summary></summary>
    BorderCallout1 = 47;
    ///<summary></summary>
    BorderCallout2 = 48;
    ///<summary></summary>
    BorderCallout3 = 49;
    ///<summary></summary>
    AccentBorderCallout1 = 50;
    ///<summary></summary>
    AccentBorderCallout2 = 51;
    ///<summary></summary>
    AccentBorderCallout3 = 52;
    ///<summary></summary>
    Ribbon = 53;
    ///<summary></summary>
    Ribbon2 = 54;
    ///<summary></summary>
    Chevron = 55;
    ///<summary></summary>
    Pentagon = 56;
    ///<summary></summary>
    NoSmoking = 57;
    ///<summary></summary>
    Seal8 = 58;
    ///<summary></summary>
    Seal16 = 59;
    ///<summary></summary>
    Seal32 = 60;
    ///<summary></summary>
    WedgeRectCallout = 61;
    ///<summary></summary>
    WedgeRRectCallout = 62;
    ///<summary></summary>
    WedgeEllipseCallout = 63;
    ///<summary></summary>
    Wave = 64;
    ///<summary></summary>
    FoldedCorner = 65;
    ///<summary></summary>
    LeftArrow = 66;
    ///<summary></summary>
    DownArrow = 67;
    ///<summary></summary>
    UpArrow = 68;
    ///<summary></summary>
    LeftRightArrow = 69;
    ///<summary></summary>
    UpDownArrow = 70;
    ///<summary></summary>
    IrregularSeal1 = 71;
    ///<summary></summary>
    IrregularSeal2 = 72;
    ///<summary></summary>
    LightningBolt = 73;
    ///<summary></summary>
    Heart = 74;
    ///<summary>
    ///  The shape is an image.
    ///</summary>
    Image = 75;
    ///<summary></summary>
    QuadArrow = 76;
    ///<summary></summary>
    LeftArrowCallout = 77;
    ///<summary></summary>
    RightArrowCallout = 78;
    ///<summary></summary>
    UpArrowCallout = 79;
    ///<summary></summary>
    DownArrowCallout = 80;
    ///<summary></summary>
    LeftRightArrowCallout = 81;
    ///<summary></summary>
    UpDownArrowCallout = 82;
    ///<summary></summary>
    QuadArrowCallout = 83;
    ///<summary></summary>
    Bevel = 84;
    ///<summary></summary>
    LeftBracket = 85;
    ///<summary></summary>
    RightBracket = 86;
    ///<summary></summary>
    LeftBrace = 87;
    ///<summary></summary>
    RightBrace = 88;
    ///<summary></summary>
    LeftUpArrow = 89;
    ///<summary></summary>
    BentUpArrow = 90;
    ///<summary></summary>
    BentArrow = 91;
    ///<summary></summary>
    Seal24 = 92;
    ///<summary></summary>
    StripedRightArrow = 93;
    ///<summary></summary>
    NotchedRightArrow = 94;
    ///<summary></summary>
    BlockArc = 95;
    ///<summary></summary>
    SmileyFace = 96;
    ///<summary></summary>
    VerticalScroll = 97;
    ///<summary></summary>
    HorizontalScroll = 98;
    ///<summary></summary>
    CircularArrow = 99;
    ///<summary>
    ///  This shape type seems to be set for shapes that are not part of the standard set of the
    ///  auto shapes in Microsoft Word. For example, if you insert a new auto shape from ClipArt.
    ///  <p>You cannot create shapes of this type in the document.</p>
    ///</summary>
    CustomShape = 100;
    ///<summary></summary>
    UturnArrow = 101;
    ///<summary></summary>
    CurvedRightArrow = 102;
    ///<summary></summary>
    CurvedLeftArrow = 103;
    ///<summary></summary>
    CurvedUpArrow = 104;
    ///<summary></summary>
    CurvedDownArrow = 105;
    ///<summary></summary>
    CloudCallout = 106;
    ///<summary></summary>
    EllipseRibbon = 107;
    ///<summary></summary>
    EllipseRibbon2 = 108;
    ///<summary></summary>
    FlowChartProcess = 109;
    ///<summary></summary>
    FlowChartDecision = 110;
    ///<summary></summary>
    FlowChartInputOutput = 111;
    ///<summary></summary>
    FlowChartPredefinedProcess = 112;
    ///<summary></summary>
    FlowChartInternalStorage = 113;
    ///<summary></summary>
    FlowChartDocument = 114;
    ///<summary></summary>
    FlowChartMultidocument = 115;
    ///<summary></summary>
    FlowChartTerminator = 116;
    ///<summary></summary>
    FlowChartPreparation = 117;
    ///<summary></summary>
    FlowChartManualInput = 118;
    ///<summary></summary>
    FlowChartManualOperation = 119;
    ///<summary></summary>
    FlowChartConnector = 120;
    ///<summary></summary>
    FlowChartPunchedCard = 121;
    ///<summary></summary>
    FlowChartPunchedTape = 122;
    ///<summary></summary>
    FlowChartSummingJunction = 123;
    ///<summary></summary>
    FlowChartOr = 124;
    ///<summary></summary>
    FlowChartCollate = 125;
    ///<summary></summary>
    FlowChartSort = 126;
    ///<summary></summary>
    FlowChartExtract = 127;
    ///<summary></summary>
    FlowChartMerge = 128;
    ///<summary></summary>
    FlowChartOfflineStorage = 129;
    ///<summary></summary>
    FlowChartOnlineStorage = 130;
    ///<summary></summary>
    FlowChartMagneticTape = 131;
    ///<summary></summary>
    FlowChartMagneticDisk = 132;
    ///<summary></summary>
    FlowChartMagneticDrum = 133;
    ///<summary></summary>
    FlowChartDisplay = 134;
    ///<summary></summary>
    FlowChartDelay = 135;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextPlainText = 136;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextStop = 137;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextTriangle = 138;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextTriangleInverted = 139;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextChevron = 140;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextChevronInverted = 141;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextRingInside = 142;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextRingOutside = 143;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextArchUpCurve = 144;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextArchDownCurve = 145;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextCircleCurve = 146;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextButtonCurve = 147;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextArchUpPour = 148;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextArchDownPour = 149;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextCirclePour = 150;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextButtonPour = 151;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextCurveUp = 152;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextCurveDown = 153;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextCascadeUp = 154;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextCascadeDown = 155;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextWave1 = 156;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextWave2 = 157;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextWave3 = 158;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextWave4 = 159;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextInflate = 160;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextDeflate = 161;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextInflateBottom = 162;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextDeflateBottom = 163;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextInflateTop = 164;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextDeflateTop = 165;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextDeflateInflate = 166;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextDeflateInflateDeflate = 167;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextFadeRight = 168;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextFadeLeft = 169;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextFadeUp = 170;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextFadeDown = 171;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextSlantUp = 172;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextSlantDown = 173;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextCanUp = 174;
    ///<summary>
    ///  WordArt object.
    ///</summary>
    TextCanDown = 175;
    ///<summary></summary>
    FlowChartAlternateProcess = 176;
    ///<summary></summary>
    FlowChartOffpageConnector = 177;
    ///<summary></summary>
    Callout90 = 178;
    ///<summary></summary>
    AccentCallout90 = 179;
    ///<summary></summary>
    BorderCallout90 = 180;
    ///<summary></summary>
    AccentBorderCallout90 = 181;
    ///<summary></summary>
    LeftRightUpArrow = 182;
    ///<summary></summary>
    Sun = 183;
    ///<summary></summary>
    Moon = 184;
    ///<summary></summary>
    BracketPair = 185;
    ///<summary></summary>
    BracePair = 186;
    ///<summary></summary>
    Seal4 = 187;
    ///<summary></summary>
    DoubleWave = 188;
    ///<summary></summary>
    ActionButtonBlank = 189;
    ///<summary></summary>
    ActionButtonHome = 190;
    ///<summary></summary>
    ActionButtonHelp = 191;
    ///<summary></summary>
    ActionButtonInformation = 192;
    ///<summary></summary>
    ActionButtonForwardNext = 193;
    ///<summary></summary>
    ActionButtonBackPrevious = 194;
    ///<summary></summary>
    ActionButtonEnd = 195;
    ///<summary></summary>
    ActionButtonBeginning = 196;
    ///<summary></summary>
    ActionButtonReturn = 197;
    ///<summary></summary>
    ActionButtonDocument = 198;
    ///<summary></summary>
    ActionButtonSound = 199;
    ///<summary></summary>
    ActionButtonMovie = 200;
    ///<summary>
    ///  The shape is an ActiveX control.
    ///  <p>You cannot create shapes of this type in the document.</p>
    ///</summary>
    ///<dev>
    ///  In DOC and RTF, shapes that represent ActiveX controls have shape type picture.
    ///  In WordML, ActiveX controls have their own shape type and so is in the model.
    ///</dev>
    OleControl = 201;
    ///<summary>
    ///  The shape is a textbox. Note that shapes of many other types can also have text inside them too.
    ///  A shape does not have to have this type to contain text.
    ///</summary>
    TextBox = 202;
    ///<summary>
    ///  Snip single corner rectangle object.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    SingleCornerSnipped = 203;
    ///<summary>
    ///  Snip same side corner rectangle.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    TopCornersSnipped = 204;
    ///<summary>
    ///  Snip diagonal corner rectangle.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    DiagonalCornersSnipped = 205;
    ///<summary>
    ///  Snip and round single corner rectangle.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    TopCornersOneRoundedOneSnipped = 206;
    ///<summary>
    ///  Round single corner rectangle.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    SingleCornerRounded = 207;
    ///<summary>
    ///  Round same side corner rectangle.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    TopCornersRounded = 208;
    ///<summary>
    ///  Round diagonal corner rectangle.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    DiagonalCornersRounded = 209;
    ///<summary>
    ///  Heptagon.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Heptagon = 210;
    ///<summary>
    ///  Cloud.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Cloud = 211;
    ///<summary>
    ///  Six-pointed star.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Seal6 = 212;
    ///<summary>
    ///  Seven-pointed star.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Seal7 = 213;
    ///<summary>
    ///  Ten-pointed star.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Seal10 = 214;
    ///<summary>
    ///  Twelve-pointed star.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Seal12 = 215;
    ///<summary>
    ///  Swoosh arrow.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    SwooshArrow = 216;
    ///<summary>
    ///  Teardrop.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Teardrop = 217;
    ///<summary>
    ///  Square tabs.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    SquareTabs = 218;
    ///<summary>
    ///  Plaque tabs.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    PlaqueTabs = 219;
    ///<summary>
    ///  Pie.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Pie = 220;
    ///<summary>
    ///  Wedge pie.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    WedgePie = 221;
    ///<summary>
    ///  Inverse line.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    InverseLine = 222;
    ///<summary>
    ///  Math plus.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    MathPlus = 223;
    ///<summary>
    ///  Math minus.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    MathMinus = 224;
    ///<summary>
    ///  Math multiply.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    MathMultiply = 225;
    ///<summary>
    ///  Math divide.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    MathDivide = 226;
    ///<summary>
    ///  Math equal.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    MathEqual = 227;
    ///<summary>
    ///  Math not equal.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    MathNotEqual = 228;
    ///<summary>
    ///  Non-isosceles trapezoid.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    NonIsoscelesTrapezoid = 229;
    ///<summary>
    ///  Left-right circular arrow.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    LeftRightCircularArrow = 230;
    ///<summary>
    ///  Left-right ribbon.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    LeftRightRibbon = 231;
    ///<summary>
    ///  Left circular arrow.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    LeftCircularArrow = 232;
    ///<summary>
    ///  Frame.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Frame = 233;
    ///<summary>
    ///  Half frame.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    HalfFrame = 234;
    ///<summary>
    ///  Funnel.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Funnel = 235;
    ///<summary>
    ///  Six-tooth gear.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Gear6 = 236;
    ///<summary>
    ///  Nine-tooth gear.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Gear9 = 237;
    ///<summary>
    ///  Decagon.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Decagon = 238;
    ///<summary>
    ///  Dodecagon.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Dodecagon = 239;
    ///<summary>
    ///  Diagonal stripe.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    DiagonalStripe = 240;
    ///<summary>
    ///  Corner.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Corner = 241;
    ///<summary>
    ///  Corner tabs.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    CornerTabs = 242;
    ///<summary>
    ///  Chord.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    Chord = 243;
    ///<summary>
    ///  Chart plus.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    ChartPlus = 244;
    ///<summary>
    ///  Chart star.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    ChartStar = 245;
    ///<summary>
    ///  Chart X.
    ///</summary>
    ///<remarks>
    ///  Applicable only for DML shapes.
    ///</remarks>
    ChartX = 246;
    ///<summary>
    ///  The shape is an OLE object.
    ///  <p>You cannot create shapes of this type in the document.</p>
    ///</summary>
    ///<dev>
    ///  In Microsoft Word, shapes that represent OLE objects have shape type picture,
    ///  but in our model, they are distinguished into their own shape type.
    ///</dev>
    OleObject = -2;
    ///<summary>
    ///  Reserved for the system use.
    ///</summary>
    MinValue = -2;
    ///<summary><p>The shape is a group shape.</p>
    ///</summary>
    ///<dev>In DOC file, shape group has shape type NonPrimitive, we don't want this in the model,
    ///  so in the model it is our own constant.</dev>
    Group = -1;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies values used for shape text vertical alignment.
  ///</summary>
  ///<dev>
  ///  Do not renumber. The values are from the RTF spec.
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.TextBoxAnchor')]
  DNTextBoxAnchor = type Integer;
  DNTextBoxAnchorHelper = record helper for DNTextBoxAnchor
  public const
    ///<summary>
    ///  Text is aligned to the top of the textbox.
    ///</summary>
    Top = 0;
    ///<summary>
    ///  Text is aligned to the middle of the textbox.
    ///</summary>
    Middle = 1;
    ///<summary>
    ///  Text is aligned to the bottom of the textbox.
    ///</summary>
    Bottom = 2;
    ///<summary>
    ///  Text is aligned to the top centered of the textbox.
    ///</summary>
    TopCentered = 3;
    ///<summary>
    ///  Text is aligned to the middle centered of the textbox.
    ///</summary>
    MiddleCentered = 4;
    ///<summary>
    ///  Text is aligned to the bottom centered of the textbox.
    ///</summary>
    BottomCentered = 5;
    ///<summary>
    ///  Text is aligned to the top baseline of the textbox.
    ///</summary>
    TopBaseline = 6;
    ///<summary>
    ///  Text is aligned to the bottom baseline of the textbox.
    ///</summary>
    BottomBaseline = 7;
    ///<summary>
    ///  Text is aligned to the top centered baseline of the textbox.
    ///</summary>
    TopCenteredBaseline = 8;
    ///<summary>
    ///  Text is aligned to the bottom centered baseline of the textbox.
    ///</summary>
    BottomCenteredBaseline = 9;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies how text wraps inside a shape.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.TextBoxWrapMode')]
  DNTextBoxWrapMode = type Integer;
  DNTextBoxWrapModeHelper = record helper for DNTextBoxWrapMode
  public const
    ///<summary>
    ///  Text wraps inside a shape.
    ///</summary>
    Square = 0;
    ///<summary>
    ///  Text does not wrap inside a shape.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  WordArt alignment.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.TextPath.TextPathAlignment" />
  [DNTypeName('Aspose.Words.Drawing.TextPathAlignment')]
  DNTextPathAlignment = type Integer;
  DNTextPathAlignmentHelper = record helper for DNTextPathAlignment
  public const
    ///<summary>
    ///  Stretch each line of text to fit width.
    ///</summary>
    Stretch = 0;
    ///<summary>
    ///  Center text on width.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Left justify.
    ///</summary>
    Left = 2;
    ///<summary>
    ///  Right justify.
    ///</summary>
    Right = 3;
    ///<summary>
    ///  Spread letters out to fit width.
    ///</summary>
    LetterJustify = 4;
    ///<summary>
    ///  Spread words out to fit width.
    ///</summary>
    WordJustify = 5;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies vertical alignment of a floating shape, text frame or a floating table.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ShapeBase.VerticalAlignment" />
  ///<dev>
  ///  Do not renumber. The values are taken from the RTF specification.
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.VerticalAlignment')]
  DNVerticalAlignment = type Integer;
  DNVerticalAlignmentHelper = record helper for DNVerticalAlignment
  public const
    ///<summary>
    ///  The object is explicitly positioned, usually using its <b>Top</b>
    ///  property.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Same as <see cref="F:Aspose.Words.Drawing.VerticalAlignment.None" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that the object shall be at the top of the vertical alignment base.
    ///</summary>
    Top = 1;
    ///<summary>
    ///  Specifies that the object shall be centered with respect to the vertical alignment base.
    ///</summary>
    Center = 2;
    ///<summary>
    ///  Specifies that the object shall be at the bottom of the vertical alignment base.
    ///</summary>
    Bottom = 3;
    ///<summary>
    ///  Specifies that the object shall be inside of the horizontal alignment base.
    ///</summary>
    Inside = 4;
    ///<summary>
    ///  Specifies that the object shall be outside of the vertical alignment base.
    ///</summary>
    Outside = 5;
    ///<summary>
    ///  Not documented. Seems to be a possible value for floating paragraphs and tables.
    ///</summary>
    Inline_ = -1;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies what side(s) of the shape or picture the text wraps around.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ShapeBase.WrapSide" />
  [DNTypeName('Aspose.Words.Drawing.WrapSide')]
  DNWrapSide = type Integer;
  DNWrapSideHelper = record helper for DNWrapSide
  public const
    ///<summary>
    ///  The document text wraps on both sides of the shape.
    ///</summary>
    Both = 0;
    ///<summary>
    ///  Default value is <see cref="F:Aspose.Words.Drawing.WrapSide.Both" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  The document text wraps on the left side of the shape only. There is a text free area on the right of the shape.
    ///</summary>
    Left = 1;
    ///<summary>
    ///  The document text wraps on the right side of the shape only. There is a text free area on the left side of the shape.
    ///</summary>
    Right = 2;
    ///<summary>
    ///  The document text wraps on the side of the shape that is farthest from the page margin, leaving text free area on the other side of the shape.
    ///</summary>
    Largest = 3;
  end;


  //-------------namespace: Aspose.Words.Drawing----------------
  ///<summary>
  ///  Specifies how text is wrapped around a shape or picture.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ShapeBase.WrapType" />
  [DNTypeName('Aspose.Words.Drawing.WrapType')]
  DNWrapType = type Integer;
  DNWrapTypeHelper = record helper for DNWrapType
  public const
    ///<summary>
    ///  The shape remains on the same layer as text and treated as a character.
    ///</summary>
    Inline_ = 0;
    ///<summary>
    ///  The text stops at the top of the shape and restarts on the line below the shape.
    ///</summary>
    TopBottom = 1;
    ///<summary>
    ///  Wraps text around all sides of the square bounding box of the shape.
    ///</summary>
    Square = 2;
    ///<summary>
    ///  No text wrapping around the shape. The shape is placed behind or in front of text.
    ///</summary>
    None = 3;
    ///<summary>
    ///  Wraps tightly around the edges of the shape, instead of wrapping around the bounding box.
    ///</summary>
    Tight = 4;
    ///<summary>
    ///  Same as Tight, but wraps inside any parts of the shape that are open.
    ///</summary>
    Through = 5;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the position for a drop cap text.
  ///</summary>
  [DNTypeName('Aspose.Words.DropCapPosition')]
  DNDropCapPosition = type Integer;
  DNDropCapPositionHelper = record helper for DNDropCapPosition
  public const
    ///<summary>
    ///  The paragraph does not have a drop cap.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The drop cap is positioned inside the text margin on the anchor paragraph.
    ///</summary>
    Normal = 1;
    ///<summary>
    ///  The drop cap is positioned outside the text margin on the anchor paragraph.
    ///</summary>
    Margin = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the set of possible aliases (or editing groups) which can be used as aliases to
  ///  determine if the current user shall be allowed to edit a single range
  ///  defined by an editable range within a document.
  ///</summary>
  [DNTypeName('Aspose.Words.EditorType')]
  DNEditorType = type Integer;
  DNEditorTypeHelper = record helper for DNEditorType
  public const
    ///<summary>
    ///  Same as <see cref="F:Aspose.Words.EditorType.Unspecified" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Means that editor type is not specified.
    ///</summary>
    Unspecified = 0;
    ///<summary>
    ///  Specifies that users associated with the Administrators group shall be allowed to edit editable ranges using
    ///  this editing type when document protection is enabled.
    ///</summary>
    Administrators = 1;
    ///<summary>
    ///  Specifies that users associated with the Contributors group shall be allowed to edit editable ranges using
    ///  this editing type when document protection is enabled.
    ///</summary>
    Contributors = 2;
    ///<summary>
    ///  Specifies that users associated with the Current group shall be allowed to edit editable ranges using this
    ///  editing type when document protection is enabled.
    ///</summary>
    Current = 3;
    ///<summary>
    ///  Specifies that users associated with the Editors group shall be allowed to edit editable ranges using this
    ///  editing type when document protection is enabled.
    ///</summary>
    Editors = 4;
    ///<summary>
    ///  Specifies that all users that open the document shall be allowed to edit editable ranges using this editing
    ///  type when document protection is enabled.
    ///</summary>
    Everyone = 5;
    ///<summary>
    ///  Specifies that none of the users that open the document shall be allowed to edit editable ranges
    ///  using this editing type when document protection is enabled.
    ///</summary>
    None = 6;
    ///<summary>
    ///  Specifies that users associated with the Owners group shall be allowed to edit editable ranges using this
    ///  editing type when document protection is enabled.
    ///</summary>
    Owners = 7;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies possible types of emphasis mark.
  ///</summary>
  ///<dev>
  ///  Names borrowed from https://docs.microsoft.com/en-us/dotnet/api/microsoft.office.interop.word.wdemphasismark?view=word-pia
  ///</dev>
  [DNTypeName('Aspose.Words.EmphasisMark')]
  DNEmphasisMark = type Integer;
  DNEmphasisMarkHelper = record helper for DNEmphasisMark
  public const
    ///<summary>
    ///  No emphasis mark.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Emphasis mark is a solid black circle displayed above text.
    ///</summary>
    OverSolidCircle = 1;
    ///<summary>
    ///  Emphasis mark is a comma character displayed above text.
    ///</summary>
    OverComma = 2;
    ///<summary>
    ///  Emphasis mark is an empty white circle displayed above text.
    ///</summary>
    OverWhiteCircle = 3;
    ///<summary>
    ///  Emphasis mark is a solid black circle displayed below text.
    ///</summary>
    UnderSolidCircle = 4;
  end;


  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Specifies the result of the IF field condition evaluation.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.FieldIfComparisonResult')]
  DNFieldIfComparisonResult = type Integer;
  DNFieldIfComparisonResultHelper = record helper for DNFieldIfComparisonResult
  public const
    ///<summary>
    ///  There is an error in the condition.
    ///</summary>
    Error = 0;
    ///<summary>
    ///  The condition is <c>true</c>.
    ///</summary>
    True = 1;
    ///<summary>
    ///  The condition is <c>false</c>.
    ///</summary>
    False = 2;
  end;


  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Specifies the formatting for the <see cref="T:Aspose.Words.Fields.FieldIndex" />
  ///  fields in a document.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.FieldIndexFormat')]
  DNFieldIndexFormat = type Integer;
  DNFieldIndexFormatHelper = record helper for DNFieldIndexFormat
  public const
    ///<summary>From template.</summary>
    Template = 0;
    ///<summary>Classic.</summary>
    Classic = 1;
    ///<summary>Fancy.</summary>
    Fancy = 2;
    ///<summary>Modern.</summary>
    Modern = 3;
    ///<summary>Bulleted.</summary>
    Bulleted = 4;
    ///<summary>Formal.</summary>
    Formal = 5;
    ///<summary>Simple.</summary>
    Simple = 6;
  end;


  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Specifies Microsoft Word field types.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.FieldType')]
  DNFieldType = type Integer;
  DNFieldTypeHelper = record helper for DNFieldType
  public const
    ///<summary>
    ///  Field type is not specified or unknown.
    ///</summary>
    FieldNone = 0;
    ///<summary>
    ///  Specifies that the field was unable to be parsed.
    ///</summary>
    FieldCannotParse = 1;
    ///<summary>
    ///  Specifies that the field represents a REF field where the keyword has been omitted.
    ///</summary>
    FieldRefNoKeyword = 2;
    ///<summary>
    ///  Specifies the REF field.
    ///</summary>
    FieldRef = 3;
    ///<summary>
    ///  Specifies the XE field.
    ///</summary>
    FieldIndexEntry = 4;
    ///<summary>
    ///  Specifies the FOOTNOTEREF field.
    ///</summary>
    FieldFootnoteRef = 5;
    ///<summary>
    ///  Specifies the SET field.
    ///</summary>
    FieldSet = 6;
    ///<summary>
    ///  Specifies the IF field.
    ///</summary>
    FieldIf = 7;
    ///<summary>
    ///  Specifies the INDEX field.
    ///</summary>
    FieldIndex = 8;
    ///<summary>
    ///  Specifies the TC field.
    ///</summary>
    FieldTOCEntry = 9;
    ///<summary>
    ///  Specifies the STYLEREF field.
    ///</summary>
    FieldStyleRef = 10;
    ///<summary>
    ///  Specifies the RD field.
    ///</summary>
    FieldRefDoc = 11;
    ///<summary>
    ///  Specifies the SEQ field.
    ///</summary>
    FieldSequence = 12;
    ///<summary>
    ///  Specifies the TOC field.
    ///</summary>
    FieldTOC = 13;
    ///<summary>
    ///  Specifies the INFO field.
    ///</summary>
    FieldInfo = 14;
    ///<summary>
    ///  Specifies the TITLE field.
    ///</summary>
    FieldTitle = 15;
    ///<summary>
    ///  Specifies the SUBJECT field.
    ///</summary>
    FieldSubject = 16;
    ///<summary>
    ///  Specifies the AUTHOR field.
    ///</summary>
    FieldAuthor = 17;
    ///<summary>
    ///  Specifies the KEYWORDS field.
    ///</summary>
    FieldKeyword = 18;
    ///<summary>
    ///  Specifies the COMMENTS field.
    ///</summary>
    FieldComments = 19;
    ///<summary>
    ///  Specifies the LASTSAVEDBY field.
    ///</summary>
    FieldLastSavedBy = 20;
    ///<summary>
    ///  Specifies the CREATEDATE field.
    ///</summary>
    FieldCreateDate = 21;
    ///<summary>
    ///  Specifies the SAVEDATE field.
    ///</summary>
    FieldSaveDate = 22;
    ///<summary>
    ///  Specifies the PRINTDATE field.
    ///</summary>
    FieldPrintDate = 23;
    ///<summary>
    ///  Specifies the REVNUM field.
    ///</summary>
    FieldRevisionNum = 24;
    ///<summary>
    ///  Specifies the EDITTIME field.
    ///</summary>
    FieldEditTime = 25;
    ///<summary>
    ///  Specifies the NUMPAGES field.
    ///</summary>
    FieldNumPages = 26;
    ///<summary>
    ///  Specifies the NUMWORDS field.
    ///</summary>
    FieldNumWords = 27;
    ///<summary>
    ///  Specifies the NUMCHARS field.
    ///</summary>
    FieldNumChars = 28;
    ///<summary>
    ///  Specifies the FILENAME field.
    ///</summary>
    FieldFileName = 29;
    ///<summary>
    ///  Specifies the TEMPLATE field.
    ///</summary>
    FieldTemplate = 30;
    ///<summary>
    ///  Specifies the DATE field.
    ///</summary>
    FieldDate = 31;
    ///<summary>
    ///  Specifies the TIME field.
    ///</summary>
    FieldTime = 32;
    ///<summary>
    ///  Specifies the PAGE field.
    ///</summary>
    FieldPage = 33;
    ///<summary>
    ///  Specifies the = (formula) field.
    ///</summary>
    FieldFormula = 34;
    ///<summary>
    ///  Specifies the QUOTE field.
    ///</summary>
    FieldQuote = 35;
    ///<summary>
    ///  Specifies the INCLUDE field.
    ///</summary>
    FieldInclude = 36;
    ///<summary>
    ///  Specifies the PAGEREF field.
    ///</summary>
    FieldPageRef = 37;
    ///<summary>
    ///  Specifies the ASK field.
    ///</summary>
    FieldAsk = 38;
    ///<summary>
    ///  Specifies the FILLIN field.
    ///</summary>
    FieldFillIn = 39;
    ///<summary>
    ///  Specifies the DATA field.
    ///</summary>
    FieldData = 40;
    ///<summary>
    ///  Specifies the NEXT field.
    ///</summary>
    FieldNext = 41;
    ///<summary>
    ///  Specifies the NEXTIF field.
    ///</summary>
    FieldNextIf = 42;
    ///<summary>
    ///  Specifies the SKIPIF field.
    ///</summary>
    FieldSkipIf = 43;
    ///<summary>
    ///  Specifies the MERGEREC field.
    ///</summary>
    FieldMergeRec = 44;
    ///<summary>
    ///  Specifies the DDE field.
    ///</summary>
    FieldDDE = 45;
    ///<summary>
    ///  Specifies the DDEAUTO field.
    ///</summary>
    FieldDDEAuto = 46;
    ///<summary>
    ///  Specifies the GLOSSARY field.
    ///</summary>
    FieldGlossary = 47;
    ///<summary>
    ///  Specifies the PRINT field.
    ///</summary>
    FieldPrint = 48;
    ///<summary>
    ///  Specifies the EQ field.
    ///</summary>
    FieldEquation = 49;
    ///<summary>
    ///  Specifies the GOTOBUTTON field.
    ///</summary>
    FieldGoToButton = 50;
    ///<summary>
    ///  Specifies the MACROBUTTON field.
    ///</summary>
    FieldMacroButton = 51;
    ///<summary>
    ///  Specifies the AUTONUMOUT field.
    ///</summary>
    FieldAutoNumOutline = 52;
    ///<summary>
    ///  Specifies the AUTONUMLGL field.
    ///</summary>
    FieldAutoNumLegal = 53;
    ///<summary>
    ///  Specifies the AUTONUM field.
    ///</summary>
    FieldAutoNum = 54;
    ///<summary>
    ///  Specifies the IMPORT field.
    ///</summary>
    FieldImport = 55;
    ///<summary>
    ///  Specifies the LINK field.
    ///</summary>
    FieldLink = 56;
    ///<summary>
    ///  Specifies the SYMBOL field.
    ///</summary>
    FieldSymbol = 57;
    ///<summary>
    ///  Specifies the EMBED field.
    ///</summary>
    FieldEmbed = 58;
    ///<summary>
    ///  Specifies the MERGEFIELD field.
    ///</summary>
    FieldMergeField = 59;
    ///<summary>
    ///  Specifies the USERNAME field.
    ///</summary>
    FieldUserName = 60;
    ///<summary>
    ///  Specifies the USERINITIALS field.
    ///</summary>
    FieldUserInitials = 61;
    ///<summary>
    ///  Specifies the USERADDRESS field.
    ///</summary>
    FieldUserAddress = 62;
    ///<summary>
    ///  Specifies the BARCODE field.
    ///</summary>
    FieldBarcode = 63;
    ///<summary>
    ///  Specifies the DOCVARIABLE field.
    ///</summary>
    FieldDocVariable = 64;
    ///<summary>
    ///  Specifies the SECTION field.
    ///</summary>
    FieldSection = 65;
    ///<summary>
    ///  Specifies the SECTIONPAGES field.
    ///</summary>
    FieldSectionPages = 66;
    ///<summary>
    ///  Specifies the INCLUDEPICTURE field.
    ///</summary>
    FieldIncludePicture = 67;
    ///<summary>
    ///  Specifies the INCLUDETEXT field.
    ///</summary>
    FieldIncludeText = 68;
    ///<summary>
    ///  Specifies the FILESIZE field.
    ///</summary>
    FieldFileSize = 69;
    ///<summary>
    ///  Specifies the FORMTEXT field.
    ///</summary>
    FieldFormTextInput = 70;
    ///<summary>
    ///  Specifies the FORMCHECKBOX field.
    ///</summary>
    FieldFormCheckBox = 71;
    ///<summary>
    ///  Specifies the NOTEREF field.
    ///</summary>
    FieldNoteRef = 72;
    ///<summary>
    ///  Specifies the TOA field.
    ///</summary>
    FieldTOA = 73;
    ///<summary>
    ///  Specifies the TA field.
    ///</summary>
    FieldTOAEntry = 74;
    ///<summary>
    ///  Specifies the MERGESEQ field.
    ///</summary>
    FieldMergeSeq = 75;
    ///<summary>
    ///  Specifies the PRIVATE field.
    ///</summary>
    FieldPrivate = 77;
    ///<summary>
    ///  Specifies the DATABASE field.
    ///</summary>
    FieldDatabase = 78;
    ///<summary>
    ///  Specifies the AUTOTEXT field.
    ///</summary>
    FieldAutoText = 79;
    ///<summary>
    ///  Specifies the COMPARE field.
    ///</summary>
    FieldCompare = 80;
    ///<summary>
    ///  Specifies the ADDIN field.
    ///</summary>
    FieldAddin = 81;
    ///<summary>
    ///  Specifies the FORMDROPDOWN field.
    ///</summary>
    FieldFormDropDown = 83;
    ///<summary>
    ///  Specifies the ADVANCE field.
    ///</summary>
    FieldAdvance = 84;
    ///<summary>
    ///  Specifies the DOCPROPERTY field.
    ///</summary>
    FieldDocProperty = 85;
    ///<summary><p>Specifies the OCX field.</p>
    ///  <p>Normally, Aspose.Words will represent an ActiveX control as a
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object, but for some documents, where a control does
    ///  not have data and/or seems to be invalid, it will be represented as a field.</p>
    ///</summary>
    FieldOcx = 87;
    ///<summary>
    ///  Specifies the HYPERLINK field.
    ///</summary>
    FieldHyperlink = 88;
    ///<summary>
    ///  Specifies the AUTOTEXTLIST field.
    ///</summary>
    FieldAutoTextList = 89;
    ///<summary>
    ///  Specifies the LISTNUM field.
    ///</summary>
    FieldListNum = 90;
    ///<summary>
    ///  Specifies the field that represents an HTML control.
    ///</summary>
    FieldHtmlActiveX = 91;
    ///<summary>
    ///  Specifies the BIDIOUTLINE field.
    ///</summary>
    FieldBidiOutline = 92;
    ///<summary>
    ///  Specifies the ADDRESSBLOCK field.
    ///</summary>
    FieldAddressBlock = 93;
    ///<summary>
    ///  Specifies the GREETINGLINE field.
    ///</summary>
    FieldGreetingLine = 94;
    ///<summary>
    ///  Specifies the SHAPE field.
    ///</summary>
    FieldShape = 95;
    ///<summary>
    ///  Specifies the CITATION field.
    ///</summary>
    FieldCitation = 1980;
    ///<summary>
    ///  Specifies the DISPLAYBARCODE field.
    ///</summary>
    FieldDisplayBarcode = 6301;
    ///<summary>
    ///  Specifies the MERGEBARCODE field.
    ///</summary>
    FieldMergeBarcode = 6302;
    ///<summary>
    ///  Specifies the BIBLIOGRAPHY field.
    ///</summary>
    FieldBibliography = 100500;
  end;


  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Indicates what culture to use during field update.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.FieldUpdateCultureSource')]
  DNFieldUpdateCultureSource = type Integer;
  DNFieldUpdateCultureSourceHelper = record helper for DNFieldUpdateCultureSource
  public const
    ///<summary>
    ///  The culture of the current execution thread is used to update fields.
    ///</summary>
    CurrentThread = 0;
    ///<summary>
    ///  The culture specified in the field formatting properties via language setting is used.
    ///</summary>
    ///<remarks>
    ///  To be exact, Aspose.Words mimics MS Word by using the language set for the first character of the field code.
    ///</remarks>
    ///<seealso cref="P:Aspose.Words.Fields.Field.LocaleId" />
    FieldCode = 1;
  end;


  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Specifies a general format that is applied to a numeric, text, or any field result.
  ///  A field may have a combination of general formats.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.GeneralFormat')]
  DNGeneralFormat = type Integer;
  DNGeneralFormatHelper = record helper for DNGeneralFormat
  public const
    ///<summary>
    ///  Used to specify a missing general format.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using hiragana characters in the traditional a-i-u-e-o order.
    ///</summary>
    Aiueo = 1;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result as one or more occurrences of an uppercase alphabetic Latin character.
    ///</summary>
    UppercaseAlphabetic = 2;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result as one or more occurrences of an lowercase alphabetic Latin character.
    ///</summary>
    LowercaseAlphabetic = 3;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using Arabic cardinal numerals.
    ///</summary>
    Arabic = 4;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using ascending Abjad numerals.
    ///</summary>
    ArabicAbjad = 5;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using characters in the Arabic alphabet.
    ///</summary>
    ArabicAlpha = 6;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using Arabic cardinal numerals, with a prefix of "- " and a suffix of " -".
    ///</summary>
    ArabicDash = 7;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result in the Thai counting system.
    ///</summary>
    BahtText = 8;
    ///<summary>
    ///  Numeric formatting. Cardinal text (One, Two, Three, ...).
    ///</summary>
    CardText = 9;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using ascending numbers from the appropriate counting system.
    ///</summary>
    ChineseNum1 = 10;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numbers from the appropriate legal format.
    ///</summary>
    ChineseNum2 = 11;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numbers from the appropriate counting thousand system.
    ///</summary>
    ChineseNum3 = 12;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numbers from the Korean Chosung format.
    ///</summary>
    Chosung = 13;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using decimal numbering enclosed in a circle, using the
    ///  enclosed alphanumeric glyph character for numbers in the range 1–20.
    ///</summary>
    CircleNum = 14;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using double-byte Arabic numbering.
    ///</summary>
    DBChar = 15;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential digital ideographs, using the appropriate character.
    ///</summary>
    DBNum1 = 16;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numbers from the appropriate counting system.
    ///</summary>
    DBNum2 = 17;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numbers from the appropriate legal counting system.
    ///</summary>
    DBNum3 = 18;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numbers from the appropriate digital counting system.
    ///</summary>
    DBNum4 = 19;
    ///<summary>
    ///  Numeric formatting. Dollar text (One, Two, Three, ... + AND 55/100).
    ///</summary>
    DollarText = 20;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numbers from the Korean Ganada format.
    ///</summary>
    Ganada = 21;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using decimal numbering followed by a period, using
    ///  the enclosed alphanumeric glyph character.
    ///</summary>
    GB1 = 22;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using decimal numbering enclosed in parenthesis,
    ///  using the enclosed alphanumeric glyph character.
    ///</summary>
    GB2 = 23;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using decimal numbering enclosed in a circle, using the
    ///  enclosed alphanumeric glyph character.
    ///</summary>
    GB3 = 24;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using decimal numbering enclosed in a circle, using the
    ///  enclosed alphanumeric glyph character.
    ///</summary>
    GB4 = 25;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using Hebrew numerals.
    ///</summary>
    Hebrew1 = 26;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using the Hebrew alphabet.
    ///</summary>
    Hebrew2 = 27;
    ///<summary>
    ///  Numeric formatting. Formats the numeric result using uppercase hexadecimal digits.
    ///</summary>
    Hex = 28;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using Hindi numbers.
    ///</summary>
    HindiArabic = 29;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numbers from the Hindi counting system.
    ///</summary>
    HindiCardText = 30;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using Hindi vowels.
    ///</summary>
    HindiLetter1 = 31;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using Hindi consonants.
    ///</summary>
    HindiLetter2 = 32;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using the Japanese iroha.
    ///</summary>
    Iroha = 33;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using a Japanese style using the appropriate counting system.
    ///</summary>
    KanjiNum1 = 34;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using the appropriate counting system.
    ///</summary>
    KanjiNum2 = 35;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using the appropriate counting system.
    ///</summary>
    KanjiNum3 = 36;
    ///<summary>
    ///  Numeric formatting. Ordinal (1st, 2nd, 3rd, ...).
    ///</summary>
    Ordinal = 37;
    ///<summary>
    ///  Numeric formatting. Ordinal text (First, Second, Third, ...).
    ///</summary>
    OrdText = 38;
    ///<summary>
    ///  Numeric formatting. Uppercase Roman (I, II, III, ...).
    ///</summary>
    UppercaseRoman = 39;
    ///<summary>
    ///  Numeric formatting. Lowercase Roman (i, ii, iii, ...).
    ///</summary>
    LowercaseRoman = 40;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using single-byte Arabic numbering.
    ///</summary>
    SBChar = 41;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using Thai numbers.
    ///</summary>
    ThaiArabic = 42;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numbers from the Thai counting system.
    ///</summary>
    ThaiCardText = 43;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using Thai letters.
    ///</summary>
    ThaiLetter = 44;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using Vietnamese numerals.
    ///</summary>
    VietCardText = 45;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential numerical traditional ideographs.
    ///</summary>
    Zodiac1 = 46;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential zodiac ideographs.
    ///</summary>
    Zodiac2 = 47;
    ///<summary>
    ///  Numeric formatting. Formats a numeric result using sequential traditional zodiac ideographs.
    ///</summary>
    Zodiac3 = 48;
    ///<summary>
    ///  Text formatting. Capitalizes the first letter of each word.
    ///</summary>
    Caps = 49;
    ///<summary>
    ///  Text formatting. Capitalizes the first letter of the first word.
    ///</summary>
    FirstCap = 50;
    ///<summary>
    ///  Text formatting. All letters are lowercase.
    ///</summary>
    Lower = 51;
    ///<summary>
    ///  Text formatting. All letters are uppercase.
    ///</summary>
    Upper = 52;
    ///<summary>
    ///  Field result formatting. The CHARFORMAT instruction.
    ///</summary>
    CharFormat = 53;
    ///<summary>
    ///  Field result formatting. The MERGEFORMAT instruction.
    ///</summary>
    MergeFormat = 54;
    ///<summary>
    ///  Field result formatting. The MERGEFORMATINET instruction.
    ///</summary>
    MergeFormatInet = 55;
  end;


  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Specifies an unit of an image dimension (i.e. the width or the height) used across a mail merge process.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.MergeFieldImageDimensionUnit')]
  DNMergeFieldImageDimensionUnit = type Integer;
  DNMergeFieldImageDimensionUnitHelper = record helper for DNMergeFieldImageDimensionUnit
  public const
    ///<summary>
    ///  The point (i.e. 1/72 inch).
    ///</summary>
    Point = 0;
    ///<summary>
    ///  The percent of the original image dimension value.
    ///</summary>
    Percent = 1;
  end;


  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Specifies the type of a text form field.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.TextFormFieldType')]
  DNTextFormFieldType = type Integer;
  DNTextFormFieldTypeHelper = record helper for DNTextFormFieldType
  public const
    ///<summary>
    ///  The text form field can contain any text.
    ///</summary>
    Regular = 0;
    ///<summary>
    ///  The text form field can contain only numbers.
    ///</summary>
    Number = 1;
    ///<summary>
    ///  The text form field can contain only a valid date value.
    ///</summary>
    Date = 2;
    ///<summary>
    ///  The text form field value is the current date when the field is updated.
    ///</summary>
    CurrentDate = 3;
    ///<summary>
    ///  The text form field value is the current time when the field is updated.
    ///</summary>
    CurrentTime = 4;
    ///<summary>
    ///  The text form field value is calculated from the expression specified in
    ///  the <see cref="P:Aspose.Words.Fields.FormField.TextInputDefault" />
    ///  property.
    ///</summary>
    Calculated = 5;
  end;


  //-------------namespace: Aspose.Words.Fonts----------------
  ///<summary><para>Specifies format of particular embedded font inside <see cref="T:Aspose.Words.Fonts.FontInfo" />
  ///  object.</para><para>When saving a document to a file, only embedded fonts of corresponding format are written down.</para></summary>
  [DNTypeName('Aspose.Words.Fonts.EmbeddedFontFormat')]
  DNEmbeddedFontFormat = type Integer;
  DNEmbeddedFontFormatHelper = record helper for DNEmbeddedFontFormat
  public const
    ///<summary><para>Specifies Embedded OpenType (EOT) File Format.</para><para>This format of embedded fonts used in DOC files.</para></summary>
    ///<remarks><para>See http://www.w3.org/Submission/EOT for description of the format.</para></remarks>
    EmbeddedOpenType = 0;
    ///<summary><para>Specifies font, embedded as plain copy of OpenType (TrueType) font file.</para><para>This format of embedded fonts used in Open Office XML format, including DOCX files.</para></summary>
    OpenType = 1;
  end;


  //-------------namespace: Aspose.Words.Fonts----------------
  ///<summary>
  ///  Specifies the style of an embedded font inside a <see cref="T:Aspose.Words.Fonts.FontInfo" />
  ///  object.
  ///</summary>
  [DNTypeName('Aspose.Words.Fonts.EmbeddedFontStyle')]
  DNEmbeddedFontStyle = type Integer;
  DNEmbeddedFontStyleHelper = record helper for DNEmbeddedFontStyle
  public const
    ///<summary>
    ///  Specifies the Regular embedded font.
    ///</summary>
    Regular = 0;
    ///<summary>
    ///  Specifies the Bold embedded font.
    ///</summary>
    Bold = 1;
    ///<summary>
    ///  Specifies the Italic embedded font.
    ///</summary>
    Italic = 2;
    ///<summary>
    ///  Specifies the Bold-Italic embedded font.
    ///</summary>
    BoldItalic = 3;
  end;


  //-------------namespace: Aspose.Words.Fonts----------------
  ///<summary>
  ///  Represents the font family.
  ///</summary>
  ///<remarks><para>A font family is a set of fonts having common stroke width and serif characteristics.</para></remarks>
  [DNTypeName('Aspose.Words.Fonts.FontFamily')]
  DNFontFamily = type Integer;
  DNFontFamilyHelper = record helper for DNFontFamily
  public const
    ///<summary>
    ///  Specifies a generic family name. This name is used when information about a font
    ///  does not exist or does not matter. The default font is used.
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  Specifies a proportional font with serifs. An example is Times New Roman.
    ///</summary>
    Roman = 1;
    ///<summary>
    ///  Specifies a proportional font without serifs. An example is Arial.
    ///</summary>
    Swiss = 2;
    ///<summary>
    ///  Specifies a monospace font with or without serifs. Monospace fonts are
    ///  usually modern; examples include Pica, Elite, and Courier New.
    ///</summary>
    Modern = 3;
    ///<summary>
    ///  Specifies a font that is designed to look like handwriting; examples include Script and Cursive.
    ///</summary>
    Script = 4;
    ///<summary>
    ///  Specifies a novelty font. An example is Old English.
    ///</summary>
    Decorative = 5;
  end;


  //-------------namespace: Aspose.Words.Fonts----------------
  ///<summary>
  ///  Represents the font pitch.
  ///</summary>
  ///<remarks>The pitch indicates if the font is fixed pitch, proportionally spaced, or relies on a default setting.</remarks>
  [DNTypeName('Aspose.Words.Fonts.FontPitch')]
  DNFontPitch = type Integer;
  DNFontPitchHelper = record helper for DNFontPitch
  public const
    ///<summary>
    ///  Specifies that no information is available about the pitch of a font.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that this is a fixed width font.
    ///</summary>
    Fixed = 1;
    ///<summary>
    ///  Specifies that this is a proportional width font.
    ///</summary>
    Variable = 2;
  end;


  //-------------namespace: Aspose.Words.Fonts----------------
  ///<summary>
  ///  Specifies the type of a font source.
  ///</summary>
  [DNTypeName('Aspose.Words.Fonts.FontSourceType')]
  DNFontSourceType = type Integer;
  DNFontSourceTypeHelper = record helper for DNFontSourceType
  public const
    ///<summary>
    ///  A <see cref="T:Aspose.Words.Fonts.FileFontSource" />
    ///  object that represents single font file.
    ///</summary>
    FontFile = 0;
    ///<summary>
    ///  A <see cref="T:Aspose.Words.Fonts.FolderFontSource" />
    ///  object that represents folder with font files.
    ///</summary>
    FontsFolder = 1;
    ///<summary>
    ///  A <see cref="T:Aspose.Words.Fonts.MemoryFontSource" />
    ///  object that represents single font in memory.
    ///</summary>
    MemoryFont = 2;
    ///<summary>
    ///  A <see cref="T:Aspose.Words.Fonts.SystemFontSource" />
    ///  object that represents all fonts installed to the system.
    ///</summary>
    SystemFonts = 3;
    ///<summary>
    ///  A <see cref="T:Aspose.Words.Fonts.StreamFontSource" />
    ///  object that represents a stream with font data.
    ///</summary>
    FontStream = 4;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Identifies the type of header or footer found in a Word file.
  ///</summary>
  ///<rev>
  ///  This is a per section header/footer.
  ///  Do not renumber as the value of the enum used as an index into plcfhdd.
  ///</rev>
  [DNTypeName('Aspose.Words.HeaderFooterType')]
  DNHeaderFooterType = type Integer;
  DNHeaderFooterTypeHelper = record helper for DNHeaderFooterType
  public const
    ///<summary>
    ///  Header for even numbered pages.
    ///</summary>
    HeaderEven = 0;
    ///<summary>
    ///  Primary header, also used for odd numbered pages.
    ///</summary>
    HeaderPrimary = 1;
    ///<summary>
    ///  Footer for even numbered pages.
    ///</summary>
    FooterEven = 2;
    ///<summary>
    ///  Primary footer, also used for odd numbered pages.
    ///</summary>
    FooterPrimary = 3;
    ///<summary>
    ///  Header for the first page of the section.
    ///</summary>
    HeaderFirst = 4;
    ///<summary>
    ///  Footer for the first page of the section.
    ///</summary>
    FooterFirst = 5;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the rule for determining the height of an object.
  ///</summary>
  [DNTypeName('Aspose.Words.HeightRule')]
  DNHeightRule = type Integer;
  DNHeightRuleHelper = record helper for DNHeightRule
  public const
    ///<summary>
    ///  The height will be at least the specified height in points. It will grow, if needed,
    ///  to accommodate all text inside an object.
    ///</summary>
    AtLeast = 0;
    ///<summary>
    ///  The height is specified exactly in points. Please note that if the text cannot
    ///  fit inside the object of this height, it will appear truncated.
    ///</summary>
    Exactly = 1;
    ///<summary>
    ///  The height will grow automatically to accommodate all text inside an object.
    ///</summary>
    Auto = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies how formatting is merged when importing content from another document.
  ///</summary>
  ///<remarks><p>When you copy nodes from one document to another, this option specifies how formatting
  ///  is resolved when both documents have a style with the same name, but different formatting.</p>
  ///  <p>The formatting is resolved as follows:</p>
  ///<list type="number"><item>Built-in styles are matched using their locale independent style identifier.
  ///  User defined styles are matched using case-sensitive style name.</item>
  ///<item>If a matching style is not found in the destination document, the style
  ///  (and all styles referenced by it) are copied into the destination document
  ///  and the imported nodes are updated to reference the new style.</item>
  ///<item>If a matching style already exists in the destination document, what happens
  ///  depends on the <c>importFormatMode</c> parameter passed to
  ///<see cref="M:Aspose.Words.DocumentBase.ImportNode(Aspose.Words.Node,System.Boolean,Aspose.Words.ImportFormatMode)">Document.ImportNode</see>
  ///  as described below.</item>
  ///</list>
  ///  <p>When using the <b>UseDestinationStyles</b>
  ///  option, if a matching style already exists
  ///  in the destination document, the style is not copied and the imported nodes are updated
  ///  to reference the existing style.</p>
  ///  <p>The drawback of using <b>UseDestinationStyles</b>
  ///  is that the imported text might
  ///  look different in the destination document comparing to the source document.
  ///  For example, the "Heading 1" style in the source document uses Arial 16pt font and
  ///  the "Heading 1" style in the destination document uses Times New Roman 14pt font.
  ///  When importing text of "Heading 1" style with no other direct formatting, it will
  ///  appear as Times New Roman 14pt font in the destination document.</p>
  ///  <p><b>KeepSourceFormatting</b>
  ///  option allows to make sure the imported content looks the same
  ///  in the destination document like it looks in the source document.
  ///  If a matching style already exists in the destination document, the source style formatting is expanded
  ///  into direct Node attributes and the style is changed to Normal.
  ///  If the style does not exist in the destination document, then the source style is imported
  ///  into the destination document and applied to the imported node.
  ///  Note, that it is not always possible to preserve the source style even if it does not exist in the destination document.
  ///  In this case formating of such style will be expanded into direct Node attributes in favor of preserving original Node formatting.</p>
  ///  <p>The drawback of using <b>KeepSourceFormatting</b>
  ///  is that if you perform several imports,
  ///  you could end up with many styles in the destination document and that could make using
  ///  consistent style formatting in Microsoft Word difficult for this document.</p>
  ///  <p>Using <b>KeepDifferentStyles</b>
  ///  option allows to reuse destination styles
  ///  if the formatting they provide is identical to the styles in the source document.
  ///  If the style in destination document is different from the source then it is imported.</p>
  ///<seealso cref="M:Aspose.Words.DocumentBase.ImportNode(Aspose.Words.Node,System.Boolean,Aspose.Words.ImportFormatMode)" />
  ///</remarks>
  [DNTypeName('Aspose.Words.ImportFormatMode')]
  DNImportFormatMode = type Integer;
  DNImportFormatModeHelper = record helper for DNImportFormatMode
  public const
    ///<summary>
    ///  Use the destination document styles and copy new styles. This is the default option.
    ///</summary>
    UseDestinationStyles = 0;
    ///<summary>
    ///  Copy all required styles to the destination document, generate unique style names if needed.
    ///</summary>
    KeepSourceFormatting = 1;
    ///<summary>
    ///  Only copy styles that are different from those in the source document.
    ///</summary>
    KeepDifferentStyles = 2;
  end;


  //-------------namespace: Aspose.Words.Layout----------------
  ///<summary>
  ///  Specifies the rendering mode for document comments.
  ///</summary>
  [DNTypeName('Aspose.Words.Layout.CommentDisplayMode')]
  DNCommentDisplayMode = type Integer;
  DNCommentDisplayModeHelper = record helper for DNCommentDisplayMode
  public const
    ///<summary>
    ///  No document comments are rendered.
    ///</summary>
    Hide = 0;
    ///<summary>
    ///  Renders document comments in balloons in the margin. This is the default value.
    ///</summary>
    ShowInBalloons = 1;
    ///<summary>
    ///  Renders document comments in annotations. This is only available for Pdf format.
    ///</summary>
    ShowInAnnotations = 2;
  end;


  //-------------namespace: Aspose.Words.Layout----------------
  [DNTypeName('Aspose.Words.Layout.ContinuosSectionRestart')]
  DNContinuosSectionRestart = type Integer;
  DNContinuosSectionRestartHelper = record helper for DNContinuosSectionRestart
  public const
    Always = 0;
    FromNewPageOnly = 1;
  end;


  //-------------namespace: Aspose.Words.Layout----------------
  ///<summary>
  ///  Types of the layout entities.
  ///</summary>
  [DNTypeName('Aspose.Words.Layout.LayoutEntityType')]
  DNLayoutEntityType = type Integer;
  DNLayoutEntityTypeHelper = record helper for DNLayoutEntityType
  public const
    ///<summary>
    ///  Default value.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Represents page of a document.
    ///  Page may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Column" />
    ///  , <see cref="F:Aspose.Words.Layout.LayoutEntityType.HeaderFooter" />
    ///  and <see cref="F:Aspose.Words.Layout.LayoutEntityType.Comment" />
    ///  child entities.
    ///</summary>
    Page = 1;
    ///<summary>
    ///  Represents a column of text on a page.
    ///  Column may have the same child entities as <see cref="F:Aspose.Words.Layout.LayoutEntityType.Cell" />
    ///  , plus <see cref="F:Aspose.Words.Layout.LayoutEntityType.Footnote" />
    ///  , <see cref="F:Aspose.Words.Layout.LayoutEntityType.Endnote" />
    ///  and <see cref="F:Aspose.Words.Layout.LayoutEntityType.NoteSeparator" />
    ///  entities.
    ///</summary>
    Column = 2;
    ///<summary>
    ///  Represents a table row.
    ///  Row may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Cell" />
    ///  as child entities.
    ///</summary>
    Row = 8;
    ///<summary>
    ///  Represents a table cell.
    ///  Cell may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Line" />
    ///  and <see cref="F:Aspose.Words.Layout.LayoutEntityType.Row" />
    ///  child entities.
    ///</summary>
    Cell = 16;
    ///<summary>
    ///  Represents line of characters of text and inline objects.
    ///  Line may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Span" />
    ///  child entities.
    ///</summary>
    Line = 32;
    ///<summary>
    ///  Represents one or more characters in a line.
    ///  This include special characters like field start/end markers, bookmarks and comments.
    ///  Span may not have child entities.
    ///</summary>
    Span = 64;
    ///<summary>
    ///  Represents placeholder for footnote content.
    ///  Footnote may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Line" />
    ///  and <see cref="F:Aspose.Words.Layout.LayoutEntityType.Row" />
    ///  child entities.
    ///</summary>
    Footnote = 256;
    ///<summary>
    ///  Represents placeholder for endnote content.
    ///  Endnote may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Line" />
    ///  and <see cref="F:Aspose.Words.Layout.LayoutEntityType.Row" />
    ///  child entities.
    ///</summary>
    Endnote = 512;
    ///<summary>
    ///  Represents placeholder for header/footer content on a page.
    ///  HeaderFooter may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Line" />
    ///  and <see cref="F:Aspose.Words.Layout.LayoutEntityType.Row" />
    ///  child entities.
    ///</summary>
    HeaderFooter = 1024;
    ///<summary>
    ///  Represents text area inside of a shape.
    ///  Textbox may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Line" />
    ///  and <see cref="F:Aspose.Words.Layout.LayoutEntityType.Row" />
    ///  child entities.
    ///</summary>
    TextBox = 2048;
    ///<summary>
    ///  Represents placeholder for comment content.
    ///  Comment may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Line" />
    ///  and <see cref="F:Aspose.Words.Layout.LayoutEntityType.Row" />
    ///  child entities.
    ///</summary>
    Comment = 4096;
    ///<summary>
    ///  Represents footnote/endnote separator.
    ///  NoteSeparator may have <see cref="F:Aspose.Words.Layout.LayoutEntityType.Line" />
    ///  and <see cref="F:Aspose.Words.Layout.LayoutEntityType.Row" />
    ///  child entities.
    ///</summary>
    NoteSeparator = 8192;
    Note = 16384;
  end;


  //-------------namespace: Aspose.Words.Layout----------------
  ///<summary>
  ///  A code of event raised during page layout model build and rendering.<para />
  ///  Page layout model is built in two steps.
  ///  First, "conversion step", this is when page layout pulls document content and creates object graph.
  ///  Second, "reflow step", this is when structures are split, merged and arranged into pages.<para />
  ///  Depending of the operation which triggered build, page layout model may or may not be further rendered into fixed page format.
  ///  For example, computing number of pages in the document or updating fields does not require rendering, whereas export to Pdf does.<para /></summary>
  [DNTypeName('Aspose.Words.Layout.PageLayoutEvent')]
  DNPageLayoutEvent = type Integer;
  DNPageLayoutEventHelper = record helper for DNPageLayoutEvent
  public const
    ///<summary>
    ///  Default value
    ///</summary>
    None = 0;
    ///<summary>
    ///  Corresponds to a checkpoint in code which is often visited and which is suitable to abort process.<para />
    ///  While inside <see cref="M:Aspose.Words.Layout.IPageLayoutCallback.Notify(Aspose.Words.Layout.PageLayoutCallbackArgs)" />
    ///  throw custom exception to abort process.<para />
    ///  You can throw when handling any callback event to abort process.<para />
    ///  Note that if process is aborted the page layout model remains in undefined state. If process is aborted upon reflow of a complete page,
    ///  however, it should be possible to use layout model up to the end of that page.<para /></summary>
    WatchDog = 1;
    ///<summary>
    ///  Build of the page layout has started. Fired once.
    ///  This is the first event which occurs when <see cref="M:Aspose.Words.Document.UpdatePageLayout" />
    ///  is called.
    ///</summary>
    BuildStarted = 2;
    ///<summary>
    ///  Build of the page layout has finished. Fired once.
    ///  This is the last event which occurs when <see cref="M:Aspose.Words.Document.UpdatePageLayout" />
    ///  is called.
    ///</summary>
    BuildFinished = 3;
    ///<summary>
    ///  Conversion of document model to page layout has started. Fired once.
    ///  This occurs when layout model starts pulling document content.
    ///</summary>
    ConversionStarted = 4;
    ///<summary>
    ///  Conversion of document model to page layout has finished. Fired once.
    ///  This occurs when layout model stops pulling document content.
    ///</summary>
    ConversionFinished = 5;
    ///<summary>
    ///  Reflow of the page layout has started. Fired once.
    ///  This occurs when layout model starts reflowing document content.
    ///</summary>
    ReflowStarted = 6;
    ///<summary>
    ///  Reflow of the page layout has finished. Fired once.
    ///  This occurs when layout model stops reflowing document content.
    ///</summary>
    ReflowFinished = 7;
    ///<summary>
    ///  Reflow of the page has started.
    ///  Note that page may reflow multiple times and that reflow may restart before it is finished.
    ///<seealso cref="P:Aspose.Words.Layout.PageLayoutCallbackArgs.PageIndex" />
    ///</summary>
    PartReflowStarted = 8;
    ///<summary>
    ///  Reflow of the page has finished.
    ///  Note that page may reflow multiple times and that reflow may restart before it is finished.
    ///<seealso cref="P:Aspose.Words.Layout.PageLayoutCallbackArgs.PageIndex" />
    ///</summary>
    PartReflowFinished = 9;
    ///<summary>
    ///  Rendering of page has started. This is fired once per page.
    ///</summary>
    PartRenderingStarted = 10;
    ///<summary>
    ///  Rendering of page has finished. This is fired once per page.
    ///</summary>
    PartRenderingFinished = 11;
  end;


  //-------------namespace: Aspose.Words.Layout----------------
  ///<summary>
  ///  Allows to specify color of document revisions.
  ///</summary>
  [DNTypeName('Aspose.Words.Layout.RevisionColor')]
  DNRevisionColor = type Integer;
  DNRevisionColorHelper = record helper for DNRevisionColor
  public const
    ///<summary>
    ///  Default.
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  Represents 000000 color.
    ///</summary>
    Black = 1;
    ///<summary>
    ///  Represents 2e97d3 color.
    ///</summary>
    Blue = 2;
    ///<summary>
    ///  Represents 84a35b color.
    ///</summary>
    BrightGreen = 3;
    ///<summary>
    ///  Represents 376e96 color.
    ///</summary>
    DarkBlue = 4;
    ///<summary>
    ///  Represents 881824 color.
    ///</summary>
    DarkRed = 5;
    ///<summary>
    ///  Represents e09a2b color.
    ///</summary>
    DarkYellow = 6;
    ///<summary>
    ///  Represents a0a3a9 color.
    ///</summary>
    Gray25 = 7;
    ///<summary>
    ///  Represents 50565e color.
    ///</summary>
    Gray50 = 8;
    ///<summary>
    ///  Represents 2c6234 color.
    ///</summary>
    Green = 9;
    ///<summary>
    ///  Represents ce338f color.
    ///</summary>
    Pink = 10;
    ///<summary>
    ///  Represents b5082e color.
    ///</summary>
    Red = 11;
    ///<summary>
    ///  Represents 1b9cab color.
    ///</summary>
    Teal = 12;
    ///<summary>
    ///  Represents 3eafc2 color.
    ///</summary>
    Turquoise = 13;
    ///<summary>
    ///  Represents 633277 color.
    ///</summary>
    Violet = 14;
    ///<summary>
    ///  Represents ffffff color.
    ///</summary>
    White = 15;
    ///<summary>
    ///  Represents fad272 color.
    ///</summary>
    Yellow = 16;
    ///<summary>
    ///  No color is used to highlight revision changes.
    ///</summary>
    ///<dev>
    ///  We shall consider getting rid of this one as it duplicates <see cref="F:Aspose.Words.Layout.RevisionEffect.None" />
    ///  .
    ///  I believe it has no use if <see cref="T:Aspose.Words.Layout.RevisionEffect" />
    ///  is publicly available.
    ///  It is confusing to use <see cref="F:Aspose.Words.Layout.RevisionColor.NoHighlight" />
    ///  and <see cref="F:Aspose.Words.Layout.RevisionEffect.Color" />
    ///  together,
    ///  or <see cref="F:Aspose.Words.Layout.RevisionColor.ByAuthor" />
    ///  and <see cref="F:Aspose.Words.Layout.RevisionEffect.None" />
    ///  for example.
    ///</dev>
    NoHighlight = 17;
    ///<summary>
    ///  Revisions of each author receive their own color for highlighting from a predfined set of hi-contrast colors.
    ///</summary>
    ByAuthor = 18;
  end;


  //-------------namespace: Aspose.Words.Layout----------------
  ///<summary>
  ///  Allows to specify decoration effect for revisions of document text.
  ///</summary>
  [DNTypeName('Aspose.Words.Layout.RevisionTextEffect')]
  DNRevisionTextEffect = type Integer;
  DNRevisionTextEffectHelper = record helper for DNRevisionTextEffect
  public const
    ///<summary>
    ///  Revised content has no special effects applied.
    ///  This corresponds to <see cref="F:Aspose.Words.Layout.RevisionColor.NoHighlight" />
    ///  .
    ///</summary>
    None = 0;
    ///<summary>
    ///  Revised content is highlighted with color only.
    ///</summary>
    Color = 1;
    ///<summary>
    ///  Revised content is made bold and colored.
    ///</summary>
    Bold = 2;
    ///<summary>
    ///  Revised content is made italic and colored.
    ///</summary>
    Italic = 3;
    ///<summary>
    ///  Revised content is underlined and colored.
    ///</summary>
    Underline = 4;
    ///<summary>
    ///  Revised content is double underlined and colored.
    ///</summary>
    DoubleUnderline = 5;
    ///<summary>
    ///  Revised content is stroked through and colored.
    ///</summary>
    StrikeThrough = 6;
    ///<summary>
    ///  Revised content is double stroked through and colored.
    ///</summary>
    ///<remarks>Only works for <see cref="F:Aspose.Words.RevisionType.Deletion" />
    ///  , <see cref="F:Aspose.Words.RevisionType.FormatChange" />
    ///  and <see cref="F:Aspose.Words.RevisionType.Moving" />
    ///  ('move from' type).</remarks>
    DoubleStrikeThrough = 7;
    ///<summary>
    ///  Revised content is hidden.
    ///</summary>
    ///<remarks>Only works for <see cref="F:Aspose.Words.RevisionType.Deletion" />
    ///  and <see cref="F:Aspose.Words.RevisionType.Moving" />
    ///  ('move from' type).</remarks>
    Hidden = 8;
  end;


  //-------------namespace: Aspose.Words.Layout----------------
  ///<summary>
  ///  Specifies which revisions are rendered in balloons.
  ///</summary>
  ///<remarks>
  ///  Note that revisions are not rendered in balloons for <see cref="F:Aspose.Words.Layout.CommentDisplayMode.ShowInAnnotations" />
  ///  .
  ///</remarks>
  [DNTypeName('Aspose.Words.Layout.ShowInBalloons')]
  DNShowInBalloons = type Integer;
  DNShowInBalloonsHelper = record helper for DNShowInBalloons
  public const
    ///<summary>
    ///  Renders insert, delete and format revisions inline.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Renders insert and delete revisions inline, format revisions in balloons.
    ///</summary>
    Format = 1;
    ///<summary>
    ///  Renders insert revisions inline, delete and format revisions in balloons.
    ///</summary>
    FormatAndDelete = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Determines when automatic line numbering restarts.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.PageSetup" />
  ///<seealso cref="P:Aspose.Words.PageSetup.LineNumberRestartMode" />
  [DNTypeName('Aspose.Words.LineNumberRestartMode')]
  DNLineNumberRestartMode = type Integer;
  DNLineNumberRestartModeHelper = record helper for DNLineNumberRestartMode
  public const
    ///<summary>
    ///  Line numbering restarts at the start of every page.
    ///</summary>
    RestartPage = 0;
    ///<summary>
    ///  Line numbering restarts at the section start.
    ///</summary>
    RestartSection = 1;
    ///<summary>
    ///  Line numbering continuous from the previous section.
    ///</summary>
    Continuous = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies line spacing values for a paragraph.
  ///</summary>
  [DNTypeName('Aspose.Words.LineSpacingRule')]
  DNLineSpacingRule = type Integer;
  DNLineSpacingRuleHelper = record helper for DNLineSpacingRule
  public const
    ///<summary>
    ///  The line spacing can be greater than or equal to, but never less than,
    ///  the value specified in the <see cref="P:Aspose.Words.ParagraphFormat.LineSpacing" />
    ///  property.
    ///</summary>
    AtLeast = 0;
    ///<summary>
    ///  The line spacing never changes from the value specified in the
    ///<see cref="P:Aspose.Words.ParagraphFormat.LineSpacing" />
    ///  property,
    ///  even if a larger font is used within the paragraph.
    ///</summary>
    Exactly = 1;
    ///<summary>
    ///  The line spacing is specified in the <see cref="P:Aspose.Words.ParagraphFormat.LineSpacing" />
    ///  property as the number of lines. One line equals 12 points.
    ///</summary>
    Multiple = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies line style of a <see cref="T:Aspose.Words.Border" />
  ///  .
  ///</summary>
  [DNTypeName('Aspose.Words.LineStyle')]
  DNLineStyle = type Integer;
  DNLineStyleHelper = record helper for DNLineStyle
  public const
    ///<summary></summary>
    ///<dev>
    ///  In MS Word binary format LineStyle.None means no border for all objects, except table cells.
    ///  For table cells LineStyle.None means inherit from the default table border.
    ///  Apparently this looks like a very bad hack made by someone at MS and I work around it
    ///  by making LineStyle.None to mean "no border" for any object in the model including table cells.
    ///  The translation is performed in the binary cell reader/writer.
    ///  I also use a single approach to indicate that a border is inherited. At first the border attribute
    ///  is simply missing, but if a use requests it, a Border object is instantiated in "inherited" mode.
    ///  DS 12.10.2010. Right now the enum contains the continuous range of values and it is used in
    ///  Border.HasValidLineStyle to define if a line style belongs to the enum or not. If new values
    ///  are added to the enum then Border.HasValidLineStyle should be reworked correspondingly.
    ///</dev>
    None = 0;
    ///<summary></summary>
    Single = 1;
    ///<summary></summary>
    Thick = 2;
    ///<summary></summary>
    Double = 3;
    ///<summary></summary>
    Hairline = 5;
    ///<summary></summary>
    Dot = 6;
    ///<summary></summary>
    DashLargeGap = 7;
    ///<summary></summary>
    DotDash = 8;
    ///<summary></summary>
    DotDotDash = 9;
    ///<summary></summary>
    Triple = 10;
    ///<summary></summary>
    ThinThickSmallGap = 11;
    ///<summary></summary>
    ThickThinSmallGap = 12;
    ///<summary></summary>
    ThinThickThinSmallGap = 13;
    ///<summary></summary>
    ThinThickMediumGap = 14;
    ///<summary></summary>
    ThickThinMediumGap = 15;
    ///<summary></summary>
    ThinThickThinMediumGap = 16;
    ///<summary></summary>
    ThinThickLargeGap = 17;
    ///<summary></summary>
    ThickThinLargeGap = 18;
    ///<summary></summary>
    ThinThickThinLargeGap = 19;
    ///<summary></summary>
    Wave = 20;
    ///<summary></summary>
    DoubleWave = 21;
    ///<summary></summary>
    DashSmallGap = 22;
    ///<summary></summary>
    DashDotStroker = 23;
    ///<summary></summary>
    Emboss3D = 24;
    ///<summary></summary>
    Engrave3D = 25;
    ///<summary></summary>
    Outset = 26;
    ///<summary></summary>
    Inset = 27;
  end;


  //-------------namespace: Aspose.Words.Lists----------------
  ///<summary>
  ///  Specifies alignment for the list number or bullet.
  ///</summary>
  ///<remarks><p>Used as a value for the <see cref="P:Aspose.Words.Lists.ListLevel.Alignment" />
  ///  property.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.Lists.ListLevelAlignment')]
  DNListLevelAlignment = type Integer;
  DNListLevelAlignmentHelper = record helper for DNListLevelAlignment
  public const
    ///<summary>
    ///  The list label is aligned to the left of the number position.
    ///</summary>
    Left = 0;
    ///<summary>
    ///  The list label is centered at the number position.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  This list label is aligned to the right of the number position.
    ///</summary>
    Right = 2;
  end;


  //-------------namespace: Aspose.Words.Lists----------------
  ///<summary>
  ///  Specifies one of the predefined list formats available in Microsoft Word.
  ///</summary>
  ///<remarks><p>A list template value is used as a parameter into the
  ///<see cref="M:Aspose.Words.Lists.ListCollection.Add(Aspose.Words.Lists.ListTemplate)" />
  ///  method.</p>
  ///  <p>Aspose.Words list templates correspond to the 21 list templates available
  ///  in the Bullets and Numbering dialog box in Microsoft Word 2003.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.Lists.ListTemplate')]
  DNListTemplate = type Integer;
  DNListTemplateHelper = record helper for DNListTemplate
  public const
    ///<summary><p>Default bulleted list with 9 levels. Bullet of the first level is a disc,
    ///  bullet of the second level is a circle, bullet of the third level is a square.
    ///  Then formatting repeats for the remaining levels.</p>
    ///  <p>Each level is indented to the right by 0.25" relative to the previous level.</p>
    ///  <p>Corresponds to the 1st bulleted list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    BulletDefault = 0;
    ///<summary><p>Same as BulletDefault.</p>
    ///  <p>Corresponds to the 1st bulleted list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    BulletDisk = 0;
    ///<summary><p>The bullet of the first level is a circle. The remaining levels are same as in BulletDefault.</p>
    ///  <p>Corresponds to the 2nd bulleted list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    BulletCircle = 1;
    ///<summary><p>The bullet of the first level is a square. The remaining levels are same as in BulletDefault.</p>
    ///  <p>Corresponds to the 3rd bulleted list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    BulletSquare = 2;
    ///<summary><p>The bullet of the first level is a 4-diamond Wingding character. The remaining levels are same as in BulletDefault.</p>
    ///  <p>Corresponds to the 5th bulleted list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    BulletDiamonds = 3;
    ///<summary><p>The bullet of the first level is an arrow head Wingding character. The remaining levels are same as in BulletDefault.</p>
    ///  <p>Corresponds to the 6th bulleted list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    BulletArrowHead = 4;
    ///<summary><p>The bullet of the first level is a tick Wingding character. The remaining levels are same as in BulletDefault.</p>
    ///  <p>Corresponds to the 7th bulleted list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    BulletTick = 5;
    ///<summary><p>Default numbered list with 9 levels. Arabic numbering (1., 2., 3., ...) for the first level,
    ///  lowecase letter numbering (a., b., c., ...) for the second level,
    ///  lowercase roman numbering (i., ii., iii., ...) for the third level.
    ///  Then formatting repeats for the remaining levels.</p>
    ///  <p>Each level is indented to the right by 0.25" relative to the previous level.</p>
    ///  <p>Corresponds to the 1st numbered list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    NumberDefault = 6;
    ///<summary><p>Same as NumberDefault.</p>
    ///  <p>Corresponds to the 1st numbered list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    NumberArabicDot = 6;
    ///<summary><p>The number of the first level is "1)". The remaining levels are same as in NumberDefault.</p>
    ///  <p>Corresponds to the 2nd numbered list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    NumberArabicParenthesis = 7;
    ///<summary><p>The number of the first level is "I.". The remaining levels are same as in NumberDefault.</p>
    ///  <p>Corresponds to the 3rd numbered list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    NumberUppercaseRomanDot = 8;
    ///<summary><p>The number of the first level is "A.". The remaining levels are same as in NumberDefault.</p>
    ///  <p>Corresponds to the 4th numbered list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    NumberUppercaseLetterDot = 9;
    ///<summary><p>The number of the first level is "a)". The remaining levels are same as in NumberDefault.</p>
    ///  <p>Corresponds to the 5th numbered list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    NumberLowercaseLetterParenthesis = 10;
    ///<summary><p>The number of the first level is "a.". The remaining levels are same as in NumberDefault.</p>
    ///  <p>Corresponds to the 6th numbered list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    NumberLowercaseLetterDot = 11;
    ///<summary><p>The number of the first level is "i.". The remaining levels are same as in NumberDefault.</p>
    ///  <p>Corresponds to the 7th numbered list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    NumberLowercaseRomanDot = 12;
    ///<summary><p>An outline list with levels numbered "1), a), i), (1), (a), (i), 1., a., i.".</p>
    ///  <p>Corresponds to the 1st outline list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    OutlineNumbers = 13;
    ///<summary><p>An outline list with levels are numbered "1., 1.1., 1.1.1, ...".</p>
    ///  <p>Corresponds to the 2nd outline list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    OutlineLegal = 14;
    ///<summary><p>An outline lists with various bullets for different levels.</p>
    ///  <p>Corresponds to the 3rd outline list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    OutlineBullets = 15;
    ///<summary><p>An outline list with levels linked to Heading styles.</p>
    ///  <p>Corresponds to the 4th outline list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    OutlineHeadingsArticleSection = 16;
    ///<summary><p>An outline list with levels linked to Heading styles.</p>
    ///  <p>Corresponds to the 5th outline list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    OutlineHeadingsLegal = 17;
    ///<summary><p>An outline list with levels linked to Heading styles.</p>
    ///  <p>Corresponds to the 6th outline list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    OutlineHeadingsNumbers = 18;
    ///<summary><p>An outline list with levels linked to Heading styles.</p>
    ///  <p>Corresponds to the 7th outline list template in the Bullets and Numbering dialog box in Microsoft Word.</p>
    ///</summary>
    OutlineHeadingsChapter = 19;
  end;


  //-------------namespace: Aspose.Words.Lists----------------
  ///<summary>
  ///  Specifies the character that separates the list label from the text of the paragraph.
  ///</summary>
  ///<remarks><p>Used as a value for the <see cref="P:Aspose.Words.Lists.ListLevel.TrailingCharacter" />
  ///  property.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.Lists.ListTrailingCharacter')]
  DNListTrailingCharacter = type Integer;
  DNListTrailingCharacterHelper = record helper for DNListTrailingCharacter
  public const
    ///<summary>
    ///  A tab character is placed between the list label and text of the paragraph.
    ///</summary>
    Tab = 0;
    ///<summary>
    ///  A space character is placed between the list label and text of the paragraph.
    ///</summary>
    Space = 1;
    ///<summary>
    ///  There is no separator character between the list label and text of the paragraph.
    ///</summary>
    Nothing = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Indicates the format of the document that is to be loaded.
  ///</summary>
  ///<dev>
  ///  We should only use values 0..255 here because these values are used as bit flags in the UnifiedScenario enum.
  ///</dev>
  [DNTypeName('Aspose.Words.LoadFormat')]
  DNLoadFormat = type Integer;
  DNLoadFormatHelper = record helper for DNLoadFormat
  public const
    ///<summary>
    ///  Instructs Aspose.Words to recognize the format automatically.
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  Microsoft Word 95 or Word 97 - 2003 Document.
    ///</summary>
    Doc = 10;
    ///<summary>
    ///  Microsoft Word 95 or Word 97 - 2003 Template.
    ///</summary>
    Dot = 11;
    ///<summary>
    ///  The document is in pre-Word 95 format.
    ///  Aspose.Words does not currently support loading such documents.
    ///</summary>
    DocPreWord60 = 12;
    ///<summary>
    ///  Office Open XML WordprocessingML Document (macro-free).
    ///</summary>
    Docx = 20;
    ///<summary>
    ///  Office Open XML WordprocessingML Macro-Enabled Document.
    ///</summary>
    Docm = 21;
    ///<summary>
    ///  Office Open XML WordprocessingML Template (macro-free).
    ///</summary>
    Dotx = 22;
    ///<summary>
    ///  Office Open XML WordprocessingML Macro-Enabled Template.
    ///</summary>
    Dotm = 23;
    ///<summary>
    ///  Office Open XML WordprocessingML stored in a flat XML file instead of a ZIP package.
    ///</summary>
    FlatOpc = 24;
    ///<summary>
    ///  Office Open XML WordprocessingML Macro-Enabled Document stored in a flat XML file instead of a ZIP package.
    ///</summary>
    FlatOpcMacroEnabled = 25;
    ///<summary>
    ///  Office Open XML WordprocessingML Template (macro-free) stored in a flat XML file instead of a ZIP package.
    ///</summary>
    FlatOpcTemplate = 26;
    ///<summary>
    ///  Office Open XML WordprocessingML Macro-Enabled Template stored in a flat XML file instead of a ZIP package.
    ///</summary>
    FlatOpcTemplateMacroEnabled = 27;
    ///<summary>
    ///  RTF format.
    ///</summary>
    Rtf = 30;
    ///<summary>
    ///  Microsoft Word 2003 WordprocessingML format.
    ///</summary>
    WordML = 31;
    ///<summary>
    ///  HTML format.
    ///</summary>
    Html = 50;
    ///<summary>
    ///  MHTML (Web archive) format.
    ///</summary>
    Mhtml = 51;
    ///<summary>
    ///  MOBI is an eBook format used by the MobiPocket Reader and Amazon Kindle Readers.
    ///</summary>
    Mobi = 52;
    ///<summary>
    ///  CHM (Compiled HTML Help) format.
    ///</summary>
    Chm = 53;
    ///<summary>
    ///  ODF Text Document.
    ///</summary>
    Odt = 60;
    ///<summary>
    ///  ODF Text Document Template.
    ///</summary>
    Ott = 61;
    ///<summary>
    ///  Plain Text.
    ///</summary>
    Text = 62;
    ///<summary>
    ///  Markdown text document.
    ///</summary>
    Markdown = 63;
    ///<summary>
    ///  Pdf document.
    ///</summary>
    Pdf = 64;
    ///<summary>
    ///  Unrecognized format, cannot be loaded by Aspose.Words.
    ///</summary>
    Unknown = 255;
  end;


  //-------------namespace: Aspose.Words.Loading----------------
  ///<summary>
  ///  Allows to specify the direction to flow the text in a document.
  ///</summary>
  [DNTypeName('Aspose.Words.Loading.DocumentDirection')]
  DNDocumentDirection = type Integer;
  DNDocumentDirectionHelper = record helper for DNDocumentDirection
  public const
    ///<summary>
    ///  Left to right direction.
    ///</summary>
    LeftToRight = 0;
    ///<summary>
    ///  Right to left direction.
    ///</summary>
    RightToLeft = 1;
    ///<summary>
    ///  Auto-detect direction.
    ///</summary>
    ///<remarks>
    ///  When this option is selected and text contains characters belonging to RTL scripts,
    ///  the document direction will be set automatically to RTL.
    ///</remarks>
    Auto = 2;
  end;


  //-------------namespace: Aspose.Words.Loading----------------
  ///<summary>
  ///  Specifies the editing language.
  ///</summary>
  ///<dev>
  ///  https://msdn.microsoft.com/en-us/library/windows/desktop/dd318693(v=vs.85).aspx
  ///  and also
  ///  https://ss64.com/locale.html
  ///</dev>
  [DNTypeName('Aspose.Words.Loading.EditingLanguage')]
  DNEditingLanguage = type Integer;
  DNEditingLanguageHelper = record helper for DNEditingLanguage
  public const
    ArabicSaudiArabia = 1025;
    Bulgarian = 1026;
    Catalan = 1027;
    ChineseTaiwan = 1028;
    Czech = 1029;
    Danish = 1030;
    GermanGermany = 1031;
    Greek = 1032;
    EnglishUS = 1033;
    SpanishSpainTraditionalSort = 1034;
    Finnish = 1035;
    FrenchFrance = 1036;
    Hebrew = 1037;
    Hungarian = 1038;
    Icelandic = 1039;
    ItalianItaly = 1040;
    Japanese = 1041;
    Korean = 1042;
    DutchNetherlands = 1043;
    NorwegianBokmal = 1044;
    Polish = 1045;
    PortugueseBrazil = 1046;
    Romansh = 1047;
    Romanian = 1048;
    Russian = 1049;
    Croatian = 1050;
    Slovak = 1051;
    Albanian = 1052;
    SwedishSweden = 1053;
    Thai = 1054;
    Turkish = 1055;
    Urdu = 1056;
    Indonesian = 1057;
    Ukrainian = 1058;
    Belarusian = 1059;
    Slovenian = 1060;
    Estonian = 1061;
    Latvian = 1062;
    Lithuanian = 1063;
    Tajik = 1064;
    Persian = 1065;
    Vietnamese = 1066;
    Armenian = 1067;
    AzerbaijaniLatin = 1068;
    Basque = 1069;
    Sorbian = 1070;
    Macedonian = 1071;
    Sutu = 1072;
    Tsonga = 1073;
    Tswana = 1074;
    Venda = 1075;
    IsiXhosa = 1076;
    IsiZulu = 1077;
    Afrikaans = 1078;
    Georgian = 1079;
    Faeroese = 1080;
    Hindi = 1081;
    Maltese = 1082;
    NorthernSamiNorway = 1083;
    Yiddish = 1085;
    MalayMalaysia = 1086;
    Kazakh = 1087;
    Kyrgyz = 1088;
    Kiswahili = 1089;
    Turkmen = 1090;
    UzbekLatin = 1091;
    Tatar = 1092;
    BanglaIndia = 1093;
    PunjabiIndia = 1094;
    Gujarati = 1095;
    Oriya = 1096;
    Tamil = 1097;
    Telugu = 1098;
    Kannada = 1099;
    Malayalam = 1100;
    Assamese = 1101;
    Marathi = 1102;
    Sanskrit = 1103;
    MongolianCyrillic = 1104;
    TibetanChina = 1105;
    Welsh = 1106;
    Khmer = 1107;
    Lao = 1108;
    Burmese = 1109;
    Galician = 1110;
    Konkani = 1111;
    Manipuri = 1112;
    SindhiDevanagaric = 1113;
    Syriac = 1114;
    Sinhalese = 1115;
    Cherokee = 1116;
    Amharic = 1118;
    Tamazight = 1119;
    KashmiriArabic = 1120;
    Nepali = 1121;
    Frisian = 1122;
    Pashto = 1123;
    Filipino = 1124;
    Divehi = 1125;
    Edo = 1126;
    FulahNigeria = 1127;
    Hausa = 1128;
    Yoruba = 1130;
    QuechuaBolivia = 1131;
    Bashkir = 1133;
    Luxembougish = 1134;
    Greenlandic = 1135;
    Igbo = 1136;
    Kanuri = 1137;
    Oromo = 1138;
    TigrignaEthiopia = 1139;
    Guarani = 1140;
    Hawaiian = 1141;
    Latin = 1142;
    Somali = 1143;
    Yi = 1144;
    Papiamentu = 1145;
    MapudungunChile = 1146;
    Mohawk = 1148;
    Breton = 1150;
    Maori = 1153;
    Corsican = 1155;
    Alsatian = 1156;
    Sakha = 1157;
    Kinyarwanda = 1159;
    ScottishGaelic = 1169;
    CentralKurdishIraq = 1170;
    ArabicIraq = 2049;
    ChinesePRC = 2052;
    GermanSwitzerland = 2055;
    EnglishUK = 2057;
    SpanishMexico = 2058;
    FrenchBelgium = 2060;
    ItalianSwitzerland = 2064;
    DutchBelgium = 2067;
    NorwegianNynorsk = 2068;
    PortuguesePortugal = 2070;
    SerbianLatinSerbiaAndMontenegro = 2074;
    SwedishFinland = 2077;
    AzerbaijaniCyrillic = 2092;
    NorthernSamiSweden = 2107;
    Irish = 2108;
    MalayBruneiDarussalam = 2110;
    UzbekCyrillic = 2115;
    BanglaBangladesh = 2117;
    PunjabiPakistan = 2118;
    MongolianMongolian = 2128;
    TibetanButan = 2129;
    Sindhi = 2137;
    TamazightLatin = 2143;
    Kashmiri = 2144;
    FulahLatinSenegal = 2151;
    QuechuaEcuador = 2155;
    TigrignaEritrea = 2163;
    ArabicEgypt = 3073;
    ChineseHongKong = 3076;
    GermanAustria = 3079;
    EnglishAustralia = 3081;
    SpanishSpainModernSort = 3082;
    FrenchCanada = 3084;
    SerbianCyrillicSerbiaAndMontenegro = 3098;
    NorthernSamiFinland = 3131;
    QuechuaPeru = 3179;
    ArabicLibya = 4097;
    ChineseSingapore = 4100;
    GermanLuxembourg = 4103;
    EnglishCanada = 4105;
    SpanishGuatemala = 4106;
    FrenchSwitzerland = 4108;
    CroatianBozniaAndHerzegovina = 4122;
    LuleSamiNorway = 4155;
    ArabicAlgeria = 5121;
    ChineseMacao = 5124;
    GermanLiechtenstein = 5127;
    EnglishNewZealand = 5129;
    SpanishCostaRica = 5130;
    FrenchLuxembourg = 5132;
    BosnianLatin = 5146;
    LuleSamiSweden = 5179;
    ArabicMorocco = 6145;
    EnglishIreland = 6153;
    SpanishPanama = 6154;
    FrenchMonaco = 6156;
    SerbianLatinBosniaAndHerzegovina = 6170;
    ArabicTunisia = 7169;
    EnglishSouthAfrica = 7177;
    SpanishDominicanRepublic = 7178;
    SerbianCyrillicBosniaAndHerzegovina = 7194;
    ArabicOman = 8193;
    EnglishJamaica = 8201;
    SpanishVenezuela = 8202;
    BosnianCyrillic = 8218;
    ArabicYemen = 9217;
    EnglishCaribbean = 9225;
    SpanishColombia = 9226;
    InariSamiFinland = 9275;
    ArabicSyria = 10241;
    EnglishBelize = 10249;
    SpanishPeru = 10250;
    ArabicJordan = 11265;
    EnglishTrinidadAndTobago = 11273;
    SpanishArgentina = 11274;
    ArabicLebanon = 12289;
    EnglishZimbabwe = 12297;
    SpanishEcuador = 12298;
    ArabicKuwait = 13313;
    EnglishPhilippines = 13321;
    SpanishChile = 13322;
    ArabicUAE = 14337;
    EnglishIndonesia = 14345;
    SpanishUruguay = 14346;
    ArabicBahrain = 15361;
    EnglishHongKong = 15369;
    SpanishParaguay = 15370;
    ArabicQatar = 16385;
    EnglishIndia = 16393;
    SpanishBolivia = 16394;
    EnglishMalaysia = 17417;
    SpanishElSalvador = 17418;
    EnglishSingapore = 18441;
    SpanishHonduras = 18442;
    SpanishNicaragua = 19466;
    SpanishPuertoRico = 20490;
    InuktitutSyllabics = 30813;
    LowerSorbian = 31790;
    InuktitutLatin = 31837;
    Kiche = 31878;
  end;


  //-------------namespace: Aspose.Words.Loading----------------
  ///<summary>
  ///  Type of document nodes that represent &lt;input&gt; and &lt;select&gt; elements imported from HTML.
  ///</summary>
  [DNTypeName('Aspose.Words.Loading.HtmlControlType')]
  DNHtmlControlType = type Integer;
  DNHtmlControlTypeHelper = record helper for DNHtmlControlType
  public const
    FormField = 0;
    StructuredDocumentTag = 1;
  end;


  //-------------namespace: Aspose.Words.Loading----------------
  ///<summary>
  ///  Specifies the mode of resource loading.
  ///</summary>
  [DNTypeName('Aspose.Words.Loading.ResourceLoadingAction')]
  DNResourceLoadingAction = type Integer;
  DNResourceLoadingActionHelper = record helper for DNResourceLoadingAction
  public const
    ///<summary>
    ///  Aspose.Words will load this resource as usual.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Aspose.Words will skip loading of this resource.
    ///  Only link without data will be stored for an image, CSS style sheet will be ignored for HTML format.
    ///</summary>
    Skip = 1;
    ///<summary>
    ///  Aspose.Words will use byte array provided by user in <see cref="M:Aspose.Words.Loading.ResourceLoadingArgs.SetData(System.Byte[])" />
    ///  as resource data.
    ///</summary>
    UserProvided = 2;
  end;


  //-------------namespace: Aspose.Words.Loading----------------
  ///<summary>
  ///  Type of loaded resource.
  ///</summary>
  [DNTypeName('Aspose.Words.Loading.ResourceType')]
  DNResourceType = type Integer;
  DNResourceTypeHelper = record helper for DNResourceType
  public const
    ///<summary>
    ///  Image.
    ///</summary>
    Image = 0;
    ///<summary>
    ///  Css style sheet.
    ///</summary>
    CssStyleSheet = 1;
    ///<summary>
    ///  Document.
    ///</summary>
    Document = 2;
  end;


  //-------------namespace: Aspose.Words.Loading----------------
  ///<summary>
  ///  Specifies available options for leading space handling during import from <see cref="F:Aspose.Words.LoadFormat.Text" />
  ///  file.
  ///</summary>
  [DNTypeName('Aspose.Words.Loading.TxtLeadingSpacesOptions')]
  DNTxtLeadingSpacesOptions = type Integer;
  DNTxtLeadingSpacesOptionsHelper = record helper for DNTxtLeadingSpacesOptions
  public const
    ConvertToIndent = 0;
    Trim = 1;
    Preserve = 2;
  end;


  //-------------namespace: Aspose.Words.Loading----------------
  ///<summary>
  ///  Specifies available options for trailing spaces handling during import from <see cref="F:Aspose.Words.LoadFormat.Text" />
  ///  file.
  ///</summary>
  [DNTypeName('Aspose.Words.Loading.TxtTrailingSpacesOptions')]
  DNTxtTrailingSpacesOptions = type Integer;
  DNTxtTrailingSpacesOptionsHelper = record helper for DNTxtTrailingSpacesOptions
  public const
    Trim = 0;
    Preserve = 1;
  end;


  //-------------namespace: Aspose.Words.MailMerging----------------
  ///<summary>
  ///  Specifies options that determine what items are removed during mail merge.
  ///</summary>
  [DNTypeName('Aspose.Words.MailMerging.MailMergeCleanupOptions')]
  DNMailMergeCleanupOptions = type Integer;
  DNMailMergeCleanupOptionsHelper = record helper for DNMailMergeCleanupOptions
  public const
    ///<summary>
    ///  Specifies a default value.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Specifies whether paragraphs that contained mail merge fields with no data should be removed from the document.
    ///  When this option is set, paragraphs which contain region start and end merge fields which are otherwise empty
    ///  are also removed.
    ///</summary>
    RemoveEmptyParagraphs = 1;
    ///<summary>
    ///  Specifies whether unused mail merge regions should be removed from the document.
    ///</summary>
    ///<remarks>
    ///  This option applies only to mail merge with regions.
    ///</remarks>
    RemoveUnusedRegions = 2;
    ///<summary>
    ///  Specifies whether unused merge fields should be removed from the document.
    ///</summary>
    RemoveUnusedFields = 4;
    ///<summary>
    ///  Specifies whether fields that contain merge fields (for example, IFs) should be removed from the document
    ///  if the nested merge fields are removed.
    ///</summary>
    RemoveContainingFields = 8;
    ///<summary>
    ///  Specifies whether static fields should be removed from the document. Static fields are fields, which
    ///  results remain the same upon any document change. Fields, which do not store their results in a document
    ///  and are calculated on the fly (like <see cref="F:Aspose.Words.Fields.FieldType.FieldListNum" />
    ///  ,
    ///<see cref="F:Aspose.Words.Fields.FieldType.FieldSymbol" />
    ///  , etc.) are not considered to be static.
    ///</summary>
    ///<remarks>
    ///  Here is the full list of field types, which are not considered to be static:
    ///<list type="bullet"><item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldAdvance" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldAutoNum" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldAutoNumLegal" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldAutoNumOutline" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldBarcode" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldBidiOutline" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldDate" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldDisplayBarcode" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldMergeBarcode" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldFormCheckBox" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldFormDropDown" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldFormula" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldGoToButton" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldHyperlink" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldIncludeText" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldIndexEntry" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldLink" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldListNum" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldMacroButton" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldNoteRef" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldNumPages" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldPage" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldPageRef" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldPrint" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldPrintDate" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldPrivate" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldRefDoc" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldSection" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldSectionPages" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldSymbol" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldTime" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldTOAEntry" />
    ///</description>
    ///</item>
    ///<item><description><see cref="F:Aspose.Words.Fields.FieldType.FieldTOCEntry" />
    ///</description>
    ///</item>
    ///</list>
    ///</remarks>
    RemoveStaticFields = 16;
    ///<summary>
    ///  Specifies whether empty rows that contain mail merge regions should be removed from the document.
    ///</summary>
    ///<remarks>
    ///  This option applies only to mail merge with regions.
    ///</remarks>
    RemoveEmptyTableRows = 32;
  end;


  //-------------namespace: Aspose.Words.Markup----------------
  ///<summary>
  ///  Specifies the level in the document tree where a particular <see cref="T:Aspose.Words.Markup.StructuredDocumentTag" />
  ///  can occur.
  ///</summary>
  [DNTypeName('Aspose.Words.Markup.MarkupLevel')]
  DNMarkupLevel = type Integer;
  DNMarkupLevelHelper = record helper for DNMarkupLevel
  public const
    ///<summary>
    ///  Specifies the unknown or invalid value.
    ///</summary>
    Unknown = 0;
    ///<summary>
    ///  The element occurs at the inline level (e.g. among as runs of text).
    ///</summary>
    Inline_ = 1;
    ///<summary>
    ///  The element occurs at the block level (e.g. among tables and paragraphs).
    ///</summary>
    Block = 2;
    ///<summary>
    ///  The element occurs among rows in a table.
    ///</summary>
    Row = 3;
    ///<summary>
    ///  The element occurs among cells in a row.
    ///</summary>
    Cell = 4;
  end;


  //-------------namespace: Aspose.Words.Markup----------------
  ///<summary>
  ///  Specifies the possible types of calendars which can be used to specify <see cref="P:Aspose.Words.Markup.StructuredDocumentTag.CalendarType" />
  ///  in an Office Open XML document.
  ///</summary>
  [DNTypeName('Aspose.Words.Markup.SdtCalendarType')]
  DNSdtCalendarType = type Integer;
  DNSdtCalendarTypeHelper = record helper for DNSdtCalendarType
  public const
    ///<summary>
    ///  Used as default value in OOXML. Equals <see cref="F:Aspose.Words.Markup.SdtCalendarType.Gregorian" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that the Gregorian calendar, as defined in ISO  8601, shall be used.
    ///  This calendar should be localized into the appropriate language.
    ///</summary>
    Gregorian = 0;
    ///<summary>
    ///  Specifies that the Gregorian calendar, as defined in ISO 8601, shall be used.
    ///  The values for this calendar should be presented in Arabic.
    ///</summary>
    GregorianArabic = 1;
    ///<summary>
    ///  Specifies that the Gregorian calendar, as defined in ISO 8601, shall be used.
    ///  The values for this calendar should be presented in Middle East French.
    ///</summary>
    GregorianMeFrench = 2;
    ///<summary>
    ///  Specifies that the Gregorian calendar, as defined in ISO 8601, shall be used.
    ///  The values for this calendar should be presented in English.
    ///</summary>
    GregorianUs = 3;
    ///<summary>
    ///  Specifies that the Gregorian calendar, as defined in ISO 8601, shall be used.
    ///  The values for this calendar should be the representation of the English strings in the corresponding Arabic characters
    ///  (the Arabic transliteration of the English for the Gregorian calendar).
    ///</summary>
    GregorianXlitEnglish = 4;
    ///<summary>
    ///  Specifies that the Gregorian calendar, as defined in ISO 8601, shall be used.
    ///  The values for this calendar should be the representation of the French strings in the corresponding Arabic characters
    ///  (the Arabic transliteration of the French for the Gregorian calendar).
    ///</summary>
    GregorianXlitFrench = 5;
    ///<summary>
    ///  Specifies that the Hebrew lunar calendar, as described by the Gauss formula for Passover [CITATION]
    ///  and The Complete Restatement of Oral Law (Mishneh Torah),shall be used.
    ///</summary>
    Hebrew = 6;
    ///<summary>
    ///  Specifies that the Hijri lunar calendar, as described by the Kingdom of Saudi Arabia,
    ///  Ministry of Islamic Affairs, Endowments, Da‘wah and Guidance, shall be used.
    ///</summary>
    Hijri = 7;
    ///<summary>
    ///  Specifies that the Japanese Emperor Era calendar, as described by
    ///  Japanese Industrial Standard JIS X 0301, shall be used.
    ///</summary>
    Japan = 8;
    ///<summary>
    ///  Specifies that the Korean Tangun Era calendar,
    ///  as described by Korean Law Enactment No. 4, shall be used.
    ///</summary>
    Korea = 9;
    ///<summary>
    ///  Specifies that no calendar should be used.
    ///</summary>
    ///<remarks>
    ///  Usually in AW, None is the first and default value for enums, but not in this case.
    ///  None is not default for OOXML, instead <see cref="F:Aspose.Words.Markup.SdtCalendarType.Gregorian" />
    ///  is default and is first member of this enum.
    ///</remarks>
    None = 10;
    ///<summary>
    ///  Specifies that the Saka Era calendar, as described by the Calendar Reform Committee of India,
    ///  as part of the Indian Ephemeris and Nautical Almanac, shall be used.
    ///</summary>
    Saka = 11;
    ///<summary>
    ///  Specifies that the Taiwanese calendar, as defined by the Chinese National Standard CNS 7648, shall be used.
    ///</summary>
    Taiwan = 12;
    ///<summary>
    ///  Specifies that the Thai calendar, as defined by the Royal Decree of H.M. King Vajiravudh (Rama VI) in
    ///  Royal Gazette B. E. 2456 (1913 A.D.) and by the decree of Prime Minister Phibunsongkhram (1941 A.D.) to
    ///  start the year on the Gregorian January 1 and to map year zero to Gregorian year 543 B.C., shall be used.
    ///</summary>
    Thai = 13;
  end;


  //-------------namespace: Aspose.Words.Markup----------------
  ///<summary>
  ///  Specifies how the date for a date SDT is stored/retrieved when the SDT is bound to an XML node in the document's data store.
  ///</summary>
  [DNTypeName('Aspose.Words.Markup.SdtDateStorageFormat')]
  DNSdtDateStorageFormat = type Integer;
  DNSdtDateStorageFormatHelper = record helper for DNSdtDateStorageFormat
  public const
    ///<summary>
    ///  The date value for a date SDT is stored as a date in the standard XML Schema Date format.
    ///</summary>
    Date = 0;
    ///<summary>
    ///  The date value for a date SDT is stored as a date in the standard XML Schema DateTime format.
    ///</summary>
    DateTime = 1;
    ///<summary>
    ///  Defaults to <see cref="F:Aspose.Words.Markup.SdtDateStorageFormat.DateTime" />
    ///</summary>
    Default_ = 1;
    ///<summary>
    ///  The date value for a date SDT is stored as text.
    ///</summary>
    Text = 2;
  end;


  //-------------namespace: Aspose.Words.Markup----------------
  ///<summary>
  ///  Specifies the type of a structured document tag (SDT) node.
  ///</summary>
  [DNTypeName('Aspose.Words.Markup.SdtType')]
  DNSdtType = type Integer;
  DNSdtTypeHelper = record helper for DNSdtType
  public const
    ///<summary>
    ///  No type is assigned to the SDT.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The SDT represents a bibliography entry.
    ///</summary>
    Bibliography = 1;
    ///<summary>
    ///  The SDT represents a citation.
    ///</summary>
    Citation = 2;
    ///<summary>
    ///  The SDT represents an equation.
    ///</summary>
    Equation = 3;
    ///<summary>
    ///  The SDT represents a drop down list when displayed in the document.
    ///</summary>
    DropDownList = 4;
    ///<summary>
    ///  The SDT represents a combo box when displayed in the document.
    ///</summary>
    ComboBox = 5;
    ///<summary>
    ///  The SDT represents a date picker when displayed in the document.
    ///</summary>
    Date = 6;
    ///<summary>
    ///  The SDT represents a building block gallery type.
    ///</summary>
    BuildingBlockGallery = 7;
    ///<summary>
    ///  The SDT represents a document part type.
    ///</summary>
    DocPartObj = 8;
    ///<summary>
    ///  The SDT represents a restricted grouping when displayed in the document.
    ///</summary>
    Group = 9;
    ///<summary>
    ///  The SDT represents a picture when displayed in the document.
    ///</summary>
    Picture = 10;
    ///<summary>
    ///  The SDT represents a rich text box when displayed in the document.
    ///</summary>
    RichText = 11;
    ///<summary>
    ///  The SDT represents a plain text box when displayed in the document.
    ///</summary>
    PlainText = 12;
    ///<summary>
    ///  The SDT represents a checkbox when displayed in the document.
    ///</summary>
    ///<remarks>
    ///  This is MS-specific feature available since Office 2010 and not supported by the ISO/IEC 29500 OOXML standard.
    ///</remarks>
    Checkbox = 13;
    ///<summary>
    ///  The SDT represents repeating section type when displayed in the document.
    ///</summary>
    ///<remarks>
    ///  This is MS-specific feature available since Office 2013 and not supported by the ISO/IEC 29500 OOXML standard.
    ///</remarks>
    RepeatingSection = 14;
    ///<summary>
    ///  The SDT represents repeating section item.
    ///</summary>
    ///<remarks>
    ///  This is MS-specific feature available since Office 2013 and not supported by the ISO/IEC 29500 OOXML standard.
    ///</remarks>
    RepeatingSectionItem = 15;
    ///<summary>
    ///  The SDT represents an entity picker that allows the user to select an instance of an external content type.
    ///</summary>
    ///<remarks>
    ///  This is MS-specific feature available since Office 2010 and not supported by the ISO/IEC 29500 OOXML standard.
    ///</remarks>
    ///<dev>
    ///  §2.6.1.15 entityPicker [MS-DOCX].
    ///  Some additional information about entity pickers can be taken from the chapter USING EXTERNAL DATA IN WORD
    ///  of Scot Hillier, Brad Stevenson. Professional Business Connectivity Services in SharePoint 2010.
    ///</dev>
    EntityPicker = 16;
  end;


  //-------------namespace: Aspose.Words.Math----------------
  ///<summary>
  ///  Specifies type of an Office Math object.
  ///</summary>
  [DNTypeName('Aspose.Words.Math.MathObjectType')]
  DNMathObjectType = type Integer;
  DNMathObjectTypeHelper = record helper for DNMathObjectType
  public const
    ///<summary>
    ///  Instance of mathematical text.
    ///</summary>
    OMath = 0;
    ///<summary>
    ///  Math paragraph, or display math zone, that contains one or more <see cref="F:Aspose.Words.Math.MathObjectType.OMath" />
    ///  elements that are in display mode.
    ///</summary>
    OMathPara = 1;
    ///<summary>
    ///  Accent function, consisting of a base and a combining diacritical mark.
    ///</summary>
    Accent = 2;
    ///<summary>
    ///  Bar function, consisting of a base argument and an overbar or underbar.
    ///</summary>
    Bar = 3;
    ///<summary>
    ///  Border Box object, consisting of a border drawn around an instance of mathematical text (such as a formula or equation)
    ///</summary>
    BorderBox = 4;
    ///<summary>
    ///  Box object, which is used to group components of an equation or other instance of mathematical text.
    ///</summary>
    Box = 5;
    ///<summary>
    ///  Delimiter object, consisting of opening and closing delimiters (such as parentheses,
    ///  braces, brackets, and vertical bars), and an element contained inside.
    ///</summary>
    Delimiter = 6;
    ///<summary>
    ///  Degree in the mathematical radical.
    ///</summary>
    Degree = 7;
    ///<summary>
    ///  Argument object. Encloses Office Math entities when they are used as arguments to other Office Math entities.
    ///</summary>
    Argument = 8;
    ///<summary>
    ///  Array object, consisting of one or more equations, expressions, or other mathematical text runs
    ///  that can be vertically justified as a unit with respect to surrounding text on the line.
    ///</summary>
    Array_ = 9;
    ///<summary>
    ///  Fraction object, consisting of a numerator and denominator separated by a fraction bar.
    ///</summary>
    Fraction = 10;
    ///<summary>
    ///  Denominator of a fraction object.
    ///</summary>
    Denominator = 11;
    ///<summary>
    ///  Numerator of the Fraction object.
    ///</summary>
    Numerator = 12;
    ///<summary>
    ///  Function-Apply object, which consists of a function name and an argument element acted upon.
    ///</summary>
    Function_ = 13;
    ///<summary>
    ///  Name of the function. For example, function names are sin and cos.
    ///</summary>
    FunctionName = 14;
    ///<summary>
    ///  Group-Character object, consisting of a character drawn above or below text, often
    ///  with the purpose of visually grouping items
    ///</summary>
    GroupCharacter = 15;
    ///<summary>
    ///  Lower limit of the <see cref="F:Aspose.Words.Math.MathObjectType.LowerLimit" />
    ///  object and
    ///  the upper limit of the <see cref="F:Aspose.Words.Math.MathObjectType.UpperLimit" />
    ///  function.
    ///</summary>
    Limit = 16;
    ///<summary>
    ///  Lower-Limit object, consisting of text on the baseline and reduced-size text immediately below it.
    ///</summary>
    LowerLimit = 17;
    ///<summary>
    ///  Upper-Limit object, consisting of text on the baseline and reduced-size text immediately above it.
    ///</summary>
    UpperLimit = 18;
    ///<summary>
    ///  Matrix object, consisting of one or more elements laid out in one or more rows and one or more columns.
    ///</summary>
    Matrix = 19;
    ///<summary>
    ///  Single row of the matrix.
    ///</summary>
    MatrixRow = 20;
    ///<summary>
    ///  N-ary object, consisting of an n-ary object, a base (or operand), and optional upper and lower limits.
    ///</summary>
    NAry = 21;
    ///<summary>
    ///  Phantom object.
    ///</summary>
    Phantom = 22;
    ///<summary>
    ///  Radical object, consisting of a radical, a base element, and an optional degree .
    ///</summary>
    Radical = 23;
    ///<summary>
    ///  Subscript of the object that can have subscript part.
    ///</summary>
    SubscriptPart = 24;
    ///<summary>
    ///  Superscript of the superscript object.
    ///</summary>
    SuperscriptPart = 25;
    ///<summary>
    ///  Pre-Sub-Superscript object, which consists of a base element and a subscript and superscript placed to the left of the base.
    ///</summary>
    PreSubSuperscript = 26;
    ///<summary>
    ///  Subscript object, which consists of a base element and a reduced-size script placed below and to the right.
    ///</summary>
    Subscript = 27;
    ///<summary>
    ///  Sub-superscript object, which consists of a base element, a reduced-size script placed below and to the right, and a reduced-size script placed above and to the right.
    ///</summary>
    SubSuperscript = 28;
    ///<summary>
    ///  Superscript object, which consists of a base element and a reduced-size script placed above and to the right.
    ///</summary>
    Supercript = 29;
  end;


  //-------------namespace: Aspose.Words.Math----------------
  ///<summary>
  ///  Specifies the display format type of the equation.
  ///</summary>
  [DNTypeName('Aspose.Words.Math.OfficeMathDisplayType')]
  DNOfficeMathDisplayType = type Integer;
  DNOfficeMathDisplayTypeHelper = record helper for DNOfficeMathDisplayType
  public const
    ///<summary>
    ///  The Office Math is displayed on its own line.
    ///</summary>
    Display = 0;
    ///<summary>
    ///  The Office Math is displayed inline with the text.
    ///</summary>
    Inline_ = 1;
  end;


  //-------------namespace: Aspose.Words.Math----------------
  ///<summary>
  ///  Specifies the justification of the equation.
  ///</summary>
  [DNTypeName('Aspose.Words.Math.OfficeMathJustification')]
  DNOfficeMathJustification = type Integer;
  DNOfficeMathJustificationHelper = record helper for DNOfficeMathJustification
  public const
    ///<summary>
    ///  Justifies instances of mathematical text to the left with respect to each other, and centers the group of mathematical
    ///  text (the Math Paragraph) with respect to the page.
    ///</summary>
    CenterGroup = 1;
    ///<summary>
    ///  Default value <see cref="F:Aspose.Words.Math.OfficeMathJustification.CenterGroup" />
    ///  .
    ///</summary>
    Default_ = 1;
    ///<summary>
    ///  Centers each instance of mathematical text individually with respect to margins.
    ///</summary>
    Center = 2;
    ///<summary>
    ///  Left justification of Math Paragraph.
    ///</summary>
    Left = 3;
    ///<summary>
    ///  Right Justification of Math Paragraph.
    ///</summary>
    Right = 4;
    ///<summary>
    ///  Inline position of Math.
    ///</summary>
    Inline_ = 7;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the unit of measurement.
  ///</summary>
  [DNTypeName('Aspose.Words.MeasurementUnits')]
  DNMeasurementUnits = type Integer;
  DNMeasurementUnitsHelper = record helper for DNMeasurementUnits
  public const
    ///<summary>
    ///  Inches.
    ///</summary>
    Inches = 0;
    ///<summary>
    ///  Centimeters.
    ///</summary>
    Centimeters = 1;
    ///<summary>
    ///  Millimeters.
    ///</summary>
    Millimeters = 2;
    ///<summary>
    ///  Points.
    ///</summary>
    Points = 3;
    ///<summary>
    ///  Picas (commonly used in traditional typewriter font spacing).
    ///</summary>
    Picas = 4;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the type of node change.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.NodeChangingArgs" />
  ///<seealso cref="P:Aspose.Words.NodeChangingArgs.Action" />
  [DNTypeName('Aspose.Words.NodeChangingAction')]
  DNNodeChangingAction = type Integer;
  DNNodeChangingActionHelper = record helper for DNNodeChangingAction
  public const
    ///<summary>
    ///  A node is being inserted in the tree.
    ///</summary>
    Insert = 0;
    ///<summary>
    ///  A node is being removed from the tree.
    ///</summary>
    Remove = 1;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the type of a Word document node.
  ///</summary>
  ///<dev><p>Enumerated node types are provided as a common denominator to ensure all functionality
  ///  is accessible to all clients (including COM applications that might not have full access
  ///  to the runtime type information).</p>
  ///</dev>
  [DNTypeName('Aspose.Words.NodeType')]
  DNNodeType = type Integer;
  DNNodeTypeHelper = record helper for DNNodeType
  public const
    ///<summary>
    ///  Indicates all node types. Allows to select all children.
    ///</summary>
    Any = 0;
    ///<summary><p>A <see cref="T:Aspose.Words.Document" />
    ///  object that, as the root of the document tree,
    ///  provides access to the entire Word document.</p>
    ///  <p>A <see cref="T:Aspose.Words.Document" />
    ///  node can have <see cref="T:Aspose.Words.Section" />
    ///  nodes.</p>
    ///</summary>
    Document = 1;
    ///<summary><p>A <see cref="T:Aspose.Words.Section" />
    ///  object that corresponds to one section in a Word document.</p>
    ///  <p>A <see cref="T:Aspose.Words.Section" />
    ///  node can have <b>Body</b>
    ///  and <b>HeaderFooter</b>
    ///  nodes.</p>
    ///</summary>
    Section = 2;
    ///<summary><p>A <see cref="T:Aspose.Words.Body" />
    ///  object that contains the main text of a section (main text story).</p>
    ///  <p>A <see cref="T:Aspose.Words.Body" />
    ///  node can have <see cref="T:Aspose.Words.Paragraph" />
    ///  and <see cref="T:Aspose.Words.Tables.Table" />
    ///  nodes.</p>
    ///</summary>
    Body = 3;
    ///<summary><p>A <see cref="T:Aspose.Words.HeaderFooter" />
    ///  object that contains text of a particular header or footer inside a section.</p>
    ///  <p>A <see cref="T:Aspose.Words.HeaderFooter" />
    ///  node can have <see cref="T:Aspose.Words.Paragraph" />
    ///  and <see cref="T:Aspose.Words.Tables.Table" />
    ///  nodes.</p>
    ///</summary>
    HeaderFooter = 4;
    ///<summary><p>A <see cref="T:Aspose.Words.Tables.Table" />
    ///  object that represents a table in a Word document.</p>
    ///  <p>A <see cref="T:Aspose.Words.Tables.Table" />
    ///  node can have <see cref="T:Aspose.Words.Tables.Row" />
    ///  nodes.</p>
    ///</summary>
    Table = 5;
    ///<summary><p>A row of a table.</p>
    ///  <p>A <see cref="T:Aspose.Words.Tables.Row" />
    ///  node can have <see cref="T:Aspose.Words.Tables.Cell" />
    ///  nodes.</p>
    ///</summary>
    Row = 6;
    ///<summary><p>A cell of a table row.</p>
    ///  <p>A <see cref="T:Aspose.Words.Tables.Cell" />
    ///  node can have <see cref="T:Aspose.Words.Paragraph" />
    ///  and <see cref="T:Aspose.Words.Tables.Table" />
    ///  nodes.</p>
    ///</summary>
    Cell = 7;
    ///<summary><p>A paragraph of text.</p>
    ///  <p>A <see cref="T:Aspose.Words.Paragraph" />
    ///  node is a container for inline level elements
    ///<see cref="T:Aspose.Words.Run" />
    ///  ,
    ///<see cref="T:Aspose.Words.Fields.FieldStart" />
    ///  ,
    ///<see cref="T:Aspose.Words.Fields.FieldSeparator" />
    ///  ,
    ///<see cref="T:Aspose.Words.Fields.FieldEnd" />
    ///  ,
    ///<see cref="T:Aspose.Words.Fields.FormField" />
    ///  ,
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  ,
    ///<see cref="T:Aspose.Words.Drawing.GroupShape" />
    ///  ,
    ///<see cref="T:Aspose.Words.Notes.Footnote" />
    ///  ,
    ///<see cref="T:Aspose.Words.Comment" />
    ///  ,
    ///<see cref="T:Aspose.Words.SpecialChar" />
    ///  ,
    ///  as well as <see cref="T:Aspose.Words.BookmarkStart" />
    ///  and <see cref="T:Aspose.Words.BookmarkEnd" />
    ///  .</p>
    ///</summary>
    Paragraph = 8;
    ///<summary><p>A beginning of a bookmark marker.</p>
    ///</summary>
    BookmarkStart = 9;
    ///<summary><p>An end of a bookmark marker.</p>
    ///</summary>
    BookmarkEnd = 10;
    ///<summary><p>A beginning of an editable range.</p>
    ///</summary>
    EditableRangeStart = 11;
    ///<summary><p>An end of an editable range.</p>
    ///</summary>
    EditableRangeEnd = 12;
    ///<summary><p>A beginning of an MoveFrom range.</p>
    ///</summary>
    MoveFromRangeStart = 13;
    ///<summary><p>An end of an MoveFrom range.</p>
    ///</summary>
    MoveFromRangeEnd = 14;
    ///<summary><p>A beginning of an MoveTo range.</p>
    ///</summary>
    MoveToRangeStart = 15;
    ///<summary><p>An end of an MoveTo range.</p>
    ///</summary>
    MoveToRangeEnd = 16;
    ///<summary><p>A group of shapes, images, OLE objects or other group shapes.</p>
    ///  <p>A <see cref="T:Aspose.Words.Drawing.GroupShape" />
    ///  node can contain other
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  and <see cref="T:Aspose.Words.Drawing.GroupShape" />
    ///  nodes.</p>
    ///</summary>
    GroupShape = 17;
    ///<summary><p>A drawing object, such as an OfficeArt shape, image or an OLE object.</p>
    ///  <p>A <see cref="T:Aspose.Words.Drawing.Shape" />
    ///  node can contain <see cref="T:Aspose.Words.Paragraph" />
    ///  and <see cref="T:Aspose.Words.Tables.Table" />
    ///  nodes.</p>
    ///</summary>
    Shape = 18;
    ///<summary><p>A comment in a Word document.</p>
    ///  <p>A <see cref="T:Aspose.Words.Comment" />
    ///  node can have <see cref="T:Aspose.Words.Paragraph" />
    ///  and <see cref="T:Aspose.Words.Tables.Table" />
    ///  nodes.</p>
    ///</summary>
    Comment = 19;
    ///<summary><p>A footnote or endnote in a Word document.</p>
    ///  <p>A <see cref="T:Aspose.Words.Notes.Footnote" />
    ///  node can have <see cref="T:Aspose.Words.Paragraph" />
    ///  and <see cref="T:Aspose.Words.Tables.Table" />
    ///  nodes.</p>
    ///</summary>
    Footnote = 20;
    ///<summary><p>A run of text.</p>
    ///</summary>
    Run = 21;
    ///<summary><p>A special character that designates the start of a Word field.</p>
    ///</summary>
    FieldStart = 22;
    ///<summary><p>A special character that separates the field code from the field result.</p>
    ///</summary>
    FieldSeparator = 23;
    ///<summary><p>A special character that designates the end of a Word field.</p>
    ///</summary>
    FieldEnd = 24;
    ///<summary><p>A form field.</p>
    ///</summary>
    FormField = 25;
    ///<summary><p>A special character that is not one of the more specific special character types.</p>
    ///</summary>
    SpecialChar = 26;
    ///<summary><para>A smart tag around one or more inline structures (runs, images, fields,etc.) within a paragraph</para></summary>
    SmartTag = 27;
    ///<summary><para>Allows to define customer-specific information and its means of presentation.</para></summary>
    StructuredDocumentTag = 28;
    ///<summary><para>A start of <b>ranged</b>
    ///  structured document tag which accepts multi-sections content.</para></summary>
    StructuredDocumentTagRangeStart = 29;
    ///<summary><para>A end of <b>ranged</b>
    ///  structured document tag which accepts multi-sections content.</para></summary>
    StructuredDocumentTagRangeEnd = 30;
    ///<summary><para>A glossary document within the main document.</para></summary>
    GlossaryDocument = 31;
    ///<summary><para>A building block within a glossary document (e.g. glossary document entry).</para></summary>
    BuildingBlock = 32;
    ///<summary>
    ///  A marker node that represents the start of a commented range.
    ///</summary>
    CommentRangeStart = 33;
    ///<summary>
    ///  A marker node that represents the end of a commented range.
    ///</summary>
    CommentRangeEnd = 34;
    ///<summary><para> An Office Math object. Can be equation, function, matrix or one of other mathematical objects.
    ///  Can be a collection of mathematical object and also can contain some non-mathematical objects such as runs of text.</para></summary>
    OfficeMath = 35;
    ///<summary>
    ///  A subdocument node which is a link to another document.
    ///</summary>
    SubDocument = 36;
    ///<summary>
    ///  Reserved for internal use by Aspose.Words.
    ///</summary>
    System = 37;
    ///<summary>
    ///  Reserved for internal use by Aspose.Words.
    ///</summary>
    Null = 38;
  end;


  //-------------namespace: Aspose.Words.Notes----------------
  ///<summary>
  ///  Defines the endnote position.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.Notes.EndnoteOptions" />
  [DNTypeName('Aspose.Words.Notes.EndnotePosition')]
  DNEndnotePosition = type Integer;
  DNEndnotePositionHelper = record helper for DNEndnotePosition
  public const
    ///<summary>
    ///  Endnotes are output at the end of the section.
    ///</summary>
    EndOfSection = 0;
    ///<summary>
    ///  Endnotes are output at the end of the document.
    ///</summary>
    EndOfDocument = 3;
  end;


  //-------------namespace: Aspose.Words.Notes----------------
  ///<summary>
  ///  Determines when automatic footnote or endnote numbering restarts.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.Notes.FootnoteOptions" />
  ///<seealso cref="T:Aspose.Words.Notes.EndnoteOptions" />
  [DNTypeName('Aspose.Words.Notes.FootnoteNumberingRule')]
  DNFootnoteNumberingRule = type Integer;
  DNFootnoteNumberingRuleHelper = record helper for DNFootnoteNumberingRule
  public const
    ///<summary>
    ///  Equals <see cref="F:Aspose.Words.Notes.FootnoteNumberingRule.Continuous" />
    ///  .
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Numbering continuous throughout the document.
    ///</summary>
    Continuous = 0;
    ///<summary>
    ///  Numbering restarts at each section.
    ///</summary>
    RestartSection = 1;
    ///<summary>
    ///  Numbering restarts at each page. Valid for footnotes only.
    ///</summary>
    RestartPage = 2;
  end;


  //-------------namespace: Aspose.Words.Notes----------------
  ///<summary>
  ///  Defines the footnote position.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.Notes.FootnoteOptions" />
  [DNTypeName('Aspose.Words.Notes.FootnotePosition')]
  DNFootnotePosition = type Integer;
  DNFootnotePositionHelper = record helper for DNFootnotePosition
  public const
    ///<summary>
    ///  Footnotes are output at the bottom of each page.
    ///</summary>
    BottomOfPage = 1;
    ///<summary>
    ///  Footnotes are output beneath text on each page.
    ///</summary>
    BeneathText = 2;
  end;


  //-------------namespace: Aspose.Words.Notes----------------
  ///<summary>
  ///  Specifies whether this is a footnote or an endnote.
  ///</summary>
  ///<remarks><para>Both footnotes and endnotes are represented by objects by the <see cref="F:Aspose.Words.Notes.FootnoteType.Footnote" />
  ///  class. Use <see cref="P:Aspose.Words.Notes.Footnote.FootnoteType" />
  ///  to distinguish between footnotes
  ///  and endnotes.</para><seealso cref="F:Aspose.Words.Notes.FootnoteType.Footnote" />
  ///</remarks>
  [DNTypeName('Aspose.Words.Notes.FootnoteType')]
  DNFootnoteType = type Integer;
  DNFootnoteTypeHelper = record helper for DNFootnoteType
  public const
    ///<summary>
    ///  The object is a footnote.
    ///</summary>
    Footnote = 0;
    ///<summary>
    ///  The object is an endnote.
    ///</summary>
    Endnote = 1;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the number style for a list, footnotes and endnotes, page numbers.
  ///</summary>
  ///<dev>
  ///  Should keep members of this enum in sync with <see cref="T:Aspose.Numbering.NumberStyleCore" />
  ///  .
  ///</dev>
  [DNTypeName('Aspose.Words.NumberStyle')]
  DNNumberStyle = type Integer;
  DNNumberStyleHelper = record helper for DNNumberStyle
  public const
    ///<summary>
    ///  Arabic numbering (1, 2, 3, ...)
    ///</summary>
    Arabic = 0;
    ///<summary>
    ///  Upper case Roman (I, II, III, ...)
    ///</summary>
    UppercaseRoman = 1;
    ///<summary>
    ///  Lower case Roman (i, ii, iii, ...)
    ///</summary>
    LowercaseRoman = 2;
    ///<summary>
    ///  Upper case Letter (A, B, C, ...)
    ///</summary>
    UppercaseLetter = 3;
    ///<summary>
    ///  Lower case letter (a, b, c, ...)
    ///</summary>
    LowercaseLetter = 4;
    ///<summary>
    ///  Ordinal (1st, 2nd, 3rd, ...)
    ///</summary>
    Ordinal = 5;
    ///<summary>
    ///  Numbered (One, Two, Three, ...)
    ///</summary>
    Number = 6;
    ///<summary>
    ///  Ordinal (text) (First, Second, Third, ...)
    ///</summary>
    OrdinalText = 7;
    ///<summary>
    ///  Hexadecimal: 8, 9, A, B, C, D, E, F, 10, 11, 12
    ///</summary>
    Hex = 8;
    ///<summary>
    ///  Chicago Manual of Style: *, †, †
    ///</summary>
    ChicagoManual = 9;
    ///<summary>
    ///  Ideograph-digital
    ///</summary>
    Kanji = 10;
    ///<summary>
    ///  Japanese counting
    ///</summary>
    KanjiDigit = 11;
    ///<summary>
    ///  Aiueo
    ///</summary>
    AiueoHalfWidth = 12;
    ///<summary>
    ///  Iroha
    ///</summary>
    IrohaHalfWidth = 13;
    ///<summary>
    ///  Full-width Arabic: 1, 2, 3, 4
    ///</summary>
    ArabicFullWidth = 14;
    ///<summary>
    ///  Half-width Arabic: 1, 2, 3, 4
    ///</summary>
    ArabicHalfWidth = 15;
    ///<summary>
    ///  Japanese legal
    ///</summary>
    KanjiTraditional = 16;
    ///<summary>
    ///  Japanese digital ten thousand
    ///</summary>
    KanjiTraditional2 = 17;
    ///<summary>
    ///  Enclosed circles
    ///</summary>
    NumberInCircle = 18;
    ///<summary>
    ///  Decimal full width: 1, 2, 3, 4
    ///</summary>
    DecimalFullWidth = 19;
    ///<summary>
    ///  Aiueo full width
    ///</summary>
    Aiueo = 20;
    ///<summary>
    ///  Iroha full width
    ///</summary>
    Iroha = 21;
    ///<summary>
    ///  Leading Zero (01, 02,..., 09, 10, 11,..., 99, 100, 101,...)
    ///</summary>
    LeadingZero = 22;
    ///<summary>
    ///  Bullet (check the character code in the text)
    ///</summary>
    Bullet = 23;
    ///<summary>
    ///  Korean Ganada
    ///</summary>
    Ganada = 24;
    ///<summary>
    ///  Korea Chosung
    ///</summary>
    Chosung = 25;
    ///<summary>
    ///  Enclosed full stop
    ///</summary>
    GB1 = 26;
    ///<summary>
    ///  Enclosed parenthesis
    ///</summary>
    GB2 = 27;
    ///<summary>
    ///  Enclosed circle Chinese
    ///</summary>
    GB3 = 28;
    ///<summary>
    ///  Ideograph enclosed circle
    ///</summary>
    GB4 = 29;
    ///<summary>
    ///  Ideograph traditional
    ///</summary>
    Zodiac1 = 30;
    ///<summary>
    ///  Ideograph Zodiac
    ///</summary>
    Zodiac2 = 31;
    ///<summary>
    ///  Ideograph Zodiac traditional
    ///</summary>
    Zodiac3 = 32;
    ///<summary>
    ///  Taiwanese counting
    ///</summary>
    TradChinNum1 = 33;
    ///<summary>
    ///  Ideograph legal traditional
    ///</summary>
    TradChinNum2 = 34;
    ///<summary>
    ///  Taiwanese counting thousand
    ///</summary>
    TradChinNum3 = 35;
    ///<summary>
    ///  Taiwanese digital
    ///</summary>
    TradChinNum4 = 36;
    ///<summary>
    ///  Chinese counting
    ///</summary>
    SimpChinNum1 = 37;
    ///<summary>
    ///  Chinese legal simplified
    ///</summary>
    SimpChinNum2 = 38;
    ///<summary>
    ///  Chinese counting thousand
    ///</summary>
    SimpChinNum3 = 39;
    ///<summary>
    ///  Chinese (not implemented)
    ///</summary>
    SimpChinNum4 = 40;
    ///<summary>
    ///  Korean digital
    ///</summary>
    HanjaRead = 41;
    ///<summary>
    ///  Korean counting
    ///</summary>
    HanjaReadDigit = 42;
    ///<summary>
    ///  Korea legal
    ///</summary>
    Hangul = 43;
    ///<summary>
    ///  Korea digital2
    ///</summary>
    Hanja = 44;
    ///<summary>
    ///  Hebrew-1
    ///</summary>
    Hebrew1 = 45;
    ///<summary>
    ///  Arabic alpha
    ///</summary>
    Arabic1 = 46;
    ///<summary>
    ///  Hebrew-2
    ///</summary>
    Hebrew2 = 47;
    ///<summary>
    ///  Arabic abjad
    ///</summary>
    Arabic2 = 48;
    ///<summary>
    ///  Hindi vowels
    ///</summary>
    HindiLetter1 = 49;
    ///<summary>
    ///  Hindi consonants
    ///</summary>
    HindiLetter2 = 50;
    ///<summary>
    ///  Hindi numbers
    ///</summary>
    HindiArabic = 51;
    ///<summary>
    ///  Hindi descriptive (cardinals)
    ///</summary>
    HindiCardinalText = 52;
    ///<summary>
    ///  Thai letters
    ///</summary>
    ThaiLetter = 53;
    ///<summary>
    ///  Thai numbers
    ///</summary>
    ThaiArabic = 54;
    ///<summary>
    ///  Thai descriptive (cardinals)
    ///</summary>
    ThaiCardinalText = 55;
    ///<summary>
    ///  Vietnamese descriptive (cardinals)
    ///</summary>
    VietCardinalText = 56;
    ///<summary>
    ///  Page number format: - 1 -, - 2 -, - 3 -, - 4 -
    ///</summary>
    NumberInDash = 57;
    ///<summary>
    ///  Lowercase Russian alphabet
    ///</summary>
    LowercaseRussian = 58;
    ///<summary>
    ///  Uppercase Russian alphabet
    ///</summary>
    UppercaseRussian = 59;
    ///<summary>
    ///  No bullet or number.
    ///</summary>
    None = 255;
    ///<summary>
    ///  Custom number format. It is supported by DOCX format only.
    ///</summary>
    Custom = 65280;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies page orientation.
  ///</summary>
  [DNTypeName('Aspose.Words.Orientation')]
  DNOrientation = type Integer;
  DNOrientationHelper = record helper for DNOrientation
  public const
    ///<summary>
    ///  Portrait page orientation (narrow and tall).
    ///</summary>
    Portrait = 1;
    ///<summary>
    ///  Landscape page orientation (wide and short).
    ///</summary>
    Landscape = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the outline level of a paragraph in the document.
  ///</summary>
  [DNTypeName('Aspose.Words.OutlineLevel')]
  DNOutlineLevel = type Integer;
  DNOutlineLevelHelper = record helper for DNOutlineLevel
  public const
    ///<summary>
    ///  The paragraph is at the outline level 1 (topmost level).
    ///</summary>
    Level1 = 0;
    ///<summary>
    ///  The paragraph is at the outline level 2.
    ///</summary>
    Level2 = 1;
    ///<summary>
    ///  The paragraph is at the outline level 3.
    ///</summary>
    Level3 = 2;
    ///<summary>
    ///  The paragraph is at the outline level 4.
    ///</summary>
    Level4 = 3;
    ///<summary>
    ///  The paragraph is at the outline level 5.
    ///</summary>
    Level5 = 4;
    ///<summary>
    ///  The paragraph is at the outline level 6.
    ///</summary>
    Level6 = 5;
    ///<summary>
    ///  The paragraph is at the outline level 7.
    ///</summary>
    Level7 = 6;
    ///<summary>
    ///  The paragraph is at the outline level 8.
    ///</summary>
    Level8 = 7;
    ///<summary>
    ///  The paragraph is at the outline level 9.
    ///</summary>
    Level9 = 8;
    ///<summary>
    ///  The paragraph is at the level of the main text.
    ///</summary>
    BodyText = 9;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies which pages the page border is printed on.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.PageSetup" />
  ///<seealso cref="P:Aspose.Words.PageSetup.BorderAppliesTo" />
  [DNTypeName('Aspose.Words.PageBorderAppliesTo')]
  DNPageBorderAppliesTo = type Integer;
  DNPageBorderAppliesToHelper = record helper for DNPageBorderAppliesTo
  public const
    ///<summary>
    ///  Page border is shown on all pages of the section.
    ///</summary>
    AllPages = 0;
    ///<summary>
    ///  Page border is shown on the first page of the section only.
    ///</summary>
    FirstPage = 1;
    ///<summary>
    ///  Page border is shown on all pages except the first page of the section.
    ///</summary>
    OtherPages = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the positioning of the page border relative to the page margin.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.PageSetup" />
  ///<seealso cref="P:Aspose.Words.PageSetup.BorderDistanceFrom" />
  [DNTypeName('Aspose.Words.PageBorderDistanceFrom')]
  DNPageBorderDistanceFrom = type Integer;
  DNPageBorderDistanceFromHelper = record helper for DNPageBorderDistanceFrom
  public const
    ///<summary>
    ///  Border position is measured from the page margin.
    ///</summary>
    Text = 0;
    ///<summary>
    ///  Border position is measured from the page edge.
    ///</summary>
    PageEdge = 1;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies vertical justification of text on each page.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.PageSetup" />
  ///<seealso cref="P:Aspose.Words.PageSetup.VerticalAlignment" />
  [DNTypeName('Aspose.Words.PageVerticalAlignment')]
  DNPageVerticalAlignment = type Integer;
  DNPageVerticalAlignmentHelper = record helper for DNPageVerticalAlignment
  public const
    ///<summary>
    ///  Text is aligned at the top of the page.
    ///</summary>
    Top = 0;
    ///<summary>
    ///  Text is aligned in the middle of the page.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Text is spread to fill the page.
    ///</summary>
    Justify = 2;
    ///<summary>
    ///  Text is aligned at the bottom of the page.
    ///</summary>
    Bottom = 3;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies paper size.
  ///</summary>
  [DNTypeName('Aspose.Words.PaperSize')]
  DNPaperSize = type Integer;
  DNPaperSizeHelper = record helper for DNPaperSize
  public const
    ///<summary>
    ///  297 x 420 mm.
    ///</summary>
    A3 = 0;
    ///<summary>
    ///  210 x 297 mm.
    ///</summary>
    A4 = 1;
    ///<summary>
    ///  148 x 210 mm.
    ///</summary>
    A5 = 2;
    ///<summary>
    ///  250 x 353 mm.
    ///</summary>
    B4 = 3;
    ///<summary>
    ///  176 x 250 mm.
    ///</summary>
    B5 = 4;
    ///<summary>
    ///  7.25 x 10.5 inches.
    ///</summary>
    Executive = 5;
    ///<summary>
    ///  8.5 x 13 inches.
    ///</summary>
    Folio = 6;
    ///<summary>
    ///  17 x 11 inches.
    ///</summary>
    Ledger = 7;
    ///<summary>
    ///  8.5 x 14 inches.
    ///</summary>
    Legal = 8;
    ///<summary>
    ///  8.5 x 11 inches.
    ///</summary>
    Letter = 9;
    ///<summary>
    ///  110 x 220 mm.
    ///</summary>
    EnvelopeDL = 10;
    ///<summary>
    ///  8.47 x 10.83 inches.
    ///</summary>
    Quarto = 11;
    ///<summary>
    ///  8.5 x 5.5 inches.
    ///</summary>
    Statement = 12;
    ///<summary>
    ///  11 x 17 inches.
    ///</summary>
    Tabloid = 13;
    ///<summary>
    ///  10 x 14 inches.
    ///</summary>
    Paper10x14 = 14;
    ///<summary>
    ///  11 x 17 inches.
    ///</summary>
    Paper11x17 = 15;
    ///<summary>
    ///  Custom paper size.
    ///</summary>
    Custom = 16;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies text alignment in a paragraph.
  ///</summary>
  [DNTypeName('Aspose.Words.ParagraphAlignment')]
  DNParagraphAlignment = type Integer;
  DNParagraphAlignmentHelper = record helper for DNParagraphAlignment
  public const
    ///<summary>
    ///  Text is aligned to the left.
    ///</summary>
    Left = 0;
    ///<summary>
    ///  Text is centered horizontally.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Text is aligned to the right.
    ///</summary>
    Right = 2;
    ///<summary>
    ///  Text is aligned to both left and right.
    ///</summary>
    Justify = 3;
    ///<summary>
    ///  Text is evenly distributed.
    ///</summary>
    Distributed = 4;
    ///<summary>
    ///  Arabic only. Kashida length for text is extended to a medium length determined by the consumer.
    ///</summary>
    ArabicMediumKashida = 5;
    ///<summary>
    ///  Arabic only. Kashida length for text is extended to its widest possible length.
    ///</summary>
    ArabicHighKashida = 7;
    ///<summary>
    ///  Arabic only. Kashida length for text is extended to a slightly longer length.
    ///</summary>
    ArabicLowKashida = 8;
    ///<summary>
    ///  Thai only. Text is justified with an optimization for Thai.
    ///</summary>
    ThaiDistributed = 9;
  end;


  //-------------namespace: Aspose.Words.Properties----------------
  ///<summary>
  ///  Used as a value for the <see cref="P:Aspose.Words.Properties.BuiltInDocumentProperties.Security" />
  ///  property.
  ///  Specifies the security level of a document as a numeric value.
  ///</summary>
  [DNTypeName('Aspose.Words.Properties.DocumentSecurity')]
  DNDocumentSecurity = type Integer;
  DNDocumentSecurityHelper = record helper for DNDocumentSecurity
  public const
    ///<summary>
    ///  There are no security states specified by the property.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The document is password protected. (Note has never been seen in a document so far).
    ///</summary>
    PasswordProtected = 1;
    ///<summary>
    ///  The document to be opened read-only if possible, but the setting can be overridden.
    ///</summary>
    ReadOnlyRecommended = 2;
    ///<summary>
    ///  The document to always be opened read-only.
    ///</summary>
    ReadOnlyEnforced = 4;
    ///<summary>
    ///  The document to always be opened read-only except for annotations.
    ///</summary>
    ReadOnlyExceptAnnotations = 8;
  end;


  //-------------namespace: Aspose.Words.Properties----------------
  ///<summary>
  ///  Specifies data type of a document property.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.Properties.DocumentProperty" />
  ///<seealso cref="P:Aspose.Words.Properties.DocumentProperty.Type" />
  [DNTypeName('Aspose.Words.Properties.PropertyType')]
  DNPropertyType = type Integer;
  DNPropertyTypeHelper = record helper for DNPropertyType
  public const
    ///<summary>
    ///  The property is a boolean value.
    ///</summary>
    Boolean = 0;
    ///<summary>
    ///  The property is a date time value.
    ///</summary>
    DateTime = 1;
    ///<summary>
    ///  The property is a floating number.
    ///</summary>
    Double = 2;
    ///<summary>
    ///  The property is an integer number.
    ///</summary>
    Number = 3;
    ///<summary>
    ///  The property is a string value.
    ///</summary>
    String_ = 4;
    ///<summary>
    ///  The property is an array of strings.
    ///</summary>
    StringArray = 5;
    ///<summary>
    ///  The property is an array of objects.
    ///</summary>
    ObjectArray = 6;
    ///<summary>
    ///  The property is an array of bytes.
    ///</summary>
    ByteArray = 7;
    ///<summary>
    ///  The property is some other type.
    ///</summary>
    Other = 8;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Protection type for a document.
  ///</summary>
  ///<dev>Keep in the Aspose.Words namespace (not in Aspose.Words.Settings) because many clients are using
  ///  this enum and it will be a big and unnecessary breaking change.</dev>
  [DNTypeName('Aspose.Words.ProtectionType')]
  DNProtectionType = type Integer;
  DNProtectionTypeHelper = record helper for DNProtectionType
  public const
    ///<summary>
    ///  User can only add revision marks to the document.
    ///</summary>
    AllowOnlyRevisions = 0;
    ///<summary>
    ///  User can only modify comments in the document.
    ///</summary>
    AllowOnlyComments = 1;
    ///<summary>
    ///  User can only enter data in the form fields in the document.
    ///</summary>
    AllowOnlyFormFields = 2;
    ///<summary>
    ///  No changes are allowed to the document. Available since Microsoft Word 2003.
    ///</summary>
    ReadOnly = 3;
    ///<summary>
    ///  The document is not protected.
    ///</summary>
    NoProtection = -1;
  end;


  //-------------namespace: Aspose.Words.Replacing----------------
  ///<summary>
  ///  Specifies direction for replace operations.
  ///</summary>
  [DNTypeName('Aspose.Words.Replacing.FindReplaceDirection')]
  DNFindReplaceDirection = type Integer;
  DNFindReplaceDirectionHelper = record helper for DNFindReplaceDirection
  public const
    ///<summary>
    ///  Matched items are replaced from first to last.
    ///</summary>
    Forward_ = 0;
    ///<summary>
    ///  Matched items are replaced from last back to first.
    ///</summary>
    Backward = 1;
  end;


  //-------------namespace: Aspose.Words.Replacing----------------
  ///<summary>
  ///  Allows the user to specify what happens to the current match during a replace operation.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.Replacing.IReplacingCallback" />
  ///<seealso cref="T:Aspose.Words.Range" />
  ///<seealso cref="M:Aspose.Words.Range.Replace(System.String,System.String,Aspose.Words.Replacing.FindReplaceOptions)" />
  [DNTypeName('Aspose.Words.Replacing.ReplaceAction')]
  DNReplaceAction = type Integer;
  DNReplaceActionHelper = record helper for DNReplaceAction
  public const
    ///<summary>
    ///  Replace the current match.
    ///</summary>
    Replace = 0;
    ///<summary>
    ///  Skip the current match.
    ///</summary>
    Skip = 1;
    ///<summary>
    ///  Terminate the replace operation.
    ///</summary>
    Stop = 2;
  end;


  //-------------namespace: Aspose.Words.Reporting----------------
  ///<summary>
  ///  Specifies a mode for parsing JSON simple values (null, boolean, number, integer, and string) while loading JSON.
  ///  Such a mode does not affect parsing of date-time values.
  ///</summary>
  [DNTypeName('Aspose.Words.Reporting.JsonSimpleValueParseMode')]
  DNJsonSimpleValueParseMode = type Integer;
  DNJsonSimpleValueParseModeHelper = record helper for DNJsonSimpleValueParseMode
  public const
    ///<summary>
    ///  Specifies the mode where types of JSON simple values are determined upon parsing of their string representations.
    ///  For example, the type of 'prop' from the JSON snippet '{ prop: "123" }' is determined as integer in this mode.
    ///</summary>
    Loose = 0;
    ///<summary>
    ///  Specifies the mode where types of JSON simple values are determined from JSON notation itself.
    ///  For example, the type of 'prop' from the JSON snippet '{ prop: "123" }' is determined as string in this mode.
    ///</summary>
    Strict_ = 1;
  end;


  //-------------namespace: Aspose.Words.Reporting----------------
  ///<summary>
  ///  Specifies options controlling behavior of <see cref="T:Aspose.Words.Reporting.ReportingEngine" />
  ///  while building a report.
  ///</summary>
  [DNTypeName('Aspose.Words.Reporting.ReportBuildOptions')]
  DNReportBuildOptions = type Integer;
  DNReportBuildOptionsHelper = record helper for DNReportBuildOptions
  public const
    ///<summary>
    ///  Specifies default options.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Specifies that missing object members should be treated as null literals by the engine. This option
    ///  affects only access to instance (that is, non-static) object members and extension methods. If this
    ///  option is not set, the engine throws an exception when encounters a missing object member.
    ///</summary>
    AllowMissingMembers = 1;
    ///<summary>
    ///  Specifies that the engine should remove paragraphs becoming empty after template syntax tags are
    ///  removed or replaced with empty values.
    ///</summary>
    RemoveEmptyParagraphs = 2;
    ///<summary>
    ///  Specifies that the engine should inline template syntax error messages into output documents.
    ///  If this option is not set, the engine throws an exception when encounters a syntax error.
    ///</summary>
    InlineErrorMessages = 4;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Allows to specify whether to work with the original or revised version of a document.
  ///</summary>
  [DNTypeName('Aspose.Words.RevisionsView')]
  DNRevisionsView = type Integer;
  DNRevisionsViewHelper = record helper for DNRevisionsView
  public const
    ///<summary>
    ///  Specifies original version of a document.
    ///</summary>
    Original = 0;
    ///<summary>
    ///  Specifies revised version of a document.
    ///</summary>
    Final_ = 1;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the type of change being tracked in <see cref="T:Aspose.Words.Revision" />
  ///  .
  ///</summary>
  [DNTypeName('Aspose.Words.RevisionType')]
  DNRevisionType = type Integer;
  DNRevisionTypeHelper = record helper for DNRevisionType
  public const
    ///<summary>
    ///  New content was inserted in the document.
    ///</summary>
    Insertion = 0;
    ///<summary>
    ///  Content was removed from the document.
    ///</summary>
    Deletion = 1;
    ///<summary>
    ///  Change of formatting was applied to the parent node.
    ///</summary>
    FormatChange = 2;
    ///<summary>
    ///  Change of formatting was applied to the parent style.
    ///</summary>
    StyleDefinitionChange = 3;
    ///<summary>
    ///  Content was moved in the document.
    ///</summary>
    Moving = 4;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Indicates the format in which the document is saved.
  ///</summary>
  ///<seealso cref="M:Aspose.Words.Document.Save(System.IO.Stream,Aspose.Words.SaveFormat)" />
  ///<seealso cref="T:Aspose.Words.Saving.SaveOptions" />
  ///<dev>
  ///  We should only use values 0..255 here because these values are used as bit flags in the UnifiedScenario enum.
  ///</dev>
  [DNTypeName('Aspose.Words.SaveFormat')]
  DNSaveFormat = type Integer;
  DNSaveFormatHelper = record helper for DNSaveFormat
  public const
    ///<summary>
    ///  Default, invalid value for file format.
    ///</summary>
    Unknown = 0;
    ///<summary>
    ///  Saves the document in the Microsoft Word 97 - 2007 Document format.
    ///</summary>
    Doc = 10;
    ///<summary>
    ///  Saves the document in the Microsoft Word 97 - 2007 Template format.
    ///</summary>
    Dot = 11;
    ///<summary>
    ///  Saves the document as an Office Open XML WordprocessingML Document (macro-free).
    ///</summary>
    Docx = 20;
    ///<summary>
    ///  Saves the document as an Office Open XML WordprocessingML Macro-Enabled Document.
    ///</summary>
    Docm = 21;
    ///<summary>
    ///  Saves the document as an Office Open XML WordprocessingML Template (macro-free).
    ///</summary>
    Dotx = 22;
    ///<summary>
    ///  Saves the document as an Office Open XML WordprocessingML Macro-Enabled Template.
    ///</summary>
    Dotm = 23;
    ///<summary>
    ///  Saves the document as an Office Open XML WordprocessingML stored in a flat XML file instead of a ZIP package.
    ///</summary>
    FlatOpc = 24;
    ///<summary>
    ///  Saves the document as an Office Open XML WordprocessingML Macro-Enabled Document stored in a flat XML file instead of a ZIP package.
    ///</summary>
    FlatOpcMacroEnabled = 25;
    ///<summary>
    ///  Saves the document as an Office Open XML WordprocessingML Template (macro-free) stored in a flat XML file instead of a ZIP package.
    ///</summary>
    FlatOpcTemplate = 26;
    ///<summary>
    ///  Saves the document as an Office Open XML WordprocessingML Macro-Enabled Template stored in a flat XML file instead of a ZIP package.
    ///</summary>
    FlatOpcTemplateMacroEnabled = 27;
    ///<summary>
    ///  Saves the document in the RTF format.
    ///  All characters above 7-bits are escaped as hexadecimal or Unicode characters.
    ///</summary>
    Rtf = 30;
    ///<summary>
    ///  Saves the document in the Microsoft Word 2003 WordprocessingML format.
    ///</summary>
    WordML = 31;
    ///<summary>
    ///  Saves the document as PDF (Adobe Portable Document) format.
    ///</summary>
    Pdf = 40;
    ///<summary>
    ///  Saves the document in the XPS (XML Paper Specification) format.
    ///</summary>
    Xps = 41;
    ///<summary>
    ///  Saves the document in the Extensible Application Markup Language (XAML) format as a fixed document.
    ///</summary>
    XamlFixed = 42;
    ///<summary>
    ///  Saves the document in the Svg (Scalable Vector Graphics) format.
    ///</summary>
    Svg = 44;
    ///<summary>
    ///  Saves the document in the HTML format using absolutely positioned elements
    ///</summary>
    HtmlFixed = 45;
    ///<summary>
    ///  Saves the document in the OpenXPS (Ecma-388) format.
    ///</summary>
    OpenXps = 46;
    ///<summary>
    ///  Saves the document in the PS (PostScript) format.
    ///</summary>
    Ps = 47;
    ///<summary>
    ///  Saves the document in the PCL (Printer Control Language) format.
    ///</summary>
    Pcl = 48;
    ///<summary>
    ///  Saves the document in the HTML format.
    ///</summary>
    Html = 50;
    ///<summary>
    ///  Saves the document in the MHTML (Web archive) format.
    ///</summary>
    Mhtml = 51;
    ///<summary>
    ///  Saves the document in the IDPF EPUB format.
    ///</summary>
    Epub = 52;
    ///<summary>
    ///  Saves the document as an ODF Text Document.
    ///</summary>
    Odt = 60;
    ///<summary>
    ///  Saves the document as an ODF Text Document Template.
    ///</summary>
    Ott = 61;
    ///<summary>
    ///  Saves the document in the plain text format.
    ///</summary>
    Text = 70;
    ///<summary><b>Beta.</b>
    ///  Saves the document in the Extensible Application Markup Language (XAML) format as a flow document.
    ///</summary>
    XamlFlow = 71;
    ///<summary><b>Beta.</b>
    ///  Saves the document in the Extensible Application Markup Language (XAML) package format as a flow document.
    ///</summary>
    XamlFlowPack = 72;
    ///<summary>
    ///  Saves the document in the Markdown format.
    ///</summary>
    Markdown = 73;
    ///<summary>
    ///  Renders a page or pages of the document and saves them into a single or multipage TIFF file.
    ///</summary>
    Tiff = 100;
    ///<summary>
    ///  Renders a page of the document and saves it as a PNG file.
    ///</summary>
    Png = 101;
    ///<summary>
    ///  Renders a page of the document and saves it as a BMP file.
    ///</summary>
    Bmp = 102;
    ///<summary>
    ///  Renders a page of the document and saves it as a vector EMF (Enhanced Meta File) file.
    ///</summary>
    Emf = 103;
    ///<summary>
    ///  Renders a page of the document and saves it as a JPEG file.
    ///</summary>
    Jpeg = 104;
    ///<summary>
    ///  Renders a page of the document and saves it as a GIF file.
    ///</summary>
    Gif = 105;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how colors are rendered.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.ColorMode')]
  DNColorMode = type Integer;
  DNColorModeHelper = record helper for DNColorMode
  public const
    ///<summary>
    ///  Rendering with unmodified colors.
    ///</summary>
    Normal = 0;
    ///<summary>
    ///  Rendering with colors in a range of gray shades from white to black.
    ///</summary>
    Grayscale = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Compression level for OOXML files.
  ///  <para>
  ///  (DOCX and DOTX files are internally a ZIP-archive, this property controls the compression level of the archive.
  ///</para><para>
  ///  Note, that FlatOpc file is not a ZIP-archive, therefore, this property does not affect the FlatOpc files.)
  ///</para></summary>
  [DNTypeName('Aspose.Words.Saving.CompressionLevel')]
  DNCompressionLevel = type Integer;
  DNCompressionLevelHelper = record helper for DNCompressionLevel
  public const
    ///<summary>
    ///  Normal compression level. Default compression level used by Aspose.Words.
    ///</summary>
    Normal = 0;
    ///<summary>
    ///  Maximum compression level.
    ///</summary>
    Maximum = 1;
    ///<summary>
    ///  Fast compression level.
    ///</summary>
    Fast = 2;
    ///<summary>
    ///  Super Fast compression level. Microsoft Word uses this compression level.
    ///</summary>
    SuperFast = 3;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how CSS (Cascading Style Sheet) styles are exported to HTML.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Saving.HtmlSaveOptions.CssStyleSheetType" />
  [DNTypeName('Aspose.Words.Saving.CssStyleSheetType')]
  DNCssStyleSheetType = type Integer;
  DNCssStyleSheetTypeHelper = record helper for DNCssStyleSheetType
  public const
    ///<summary>
    ///  CSS styles are written inline (as a value of the <b>style</b>
    ///  attribute on every element).
    ///</summary>
    Inline_ = 0;
    ///<summary>
    ///  CSS styles are written separately from the content in a style sheet embedded in the HTML file.
    ///</summary>
    Embedded = 1;
    ///<summary>
    ///  CSS styles are written separately from the content in a style sheet in an external file.
    ///  The HTML file links the style sheet.
    ///</summary>
    External_ = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how 3D shape effects are rendered.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.Dml3DEffectsRenderingMode')]
  DNDml3DEffectsRenderingMode = type Integer;
  DNDml3DEffectsRenderingModeHelper = record helper for DNDml3DEffectsRenderingMode
  public const
    ///<summary>
    ///  A lightweight and stable rendering, based on the internal engine,
    ///  but advanced effects such as lighting, materials and other additional effects
    ///  are not displayed when using this mode.
    ///  Please see documentation for details.
    ///</summary>
    Basic = 0;
    ///<summary>
    ///  Rendering of an extended list of special effects including advanced 3D effects
    ///  such as bevels, lighting and materials.
    ///</summary>
    ///<remarks>
    ///  The current implementation uses OpenGL.
    ///  Please make sure that OpenGL library version 1.1 or higher is installed on your system before use.
    ///  This mode is still under development, and some things may not be supported, so it's recommended to use
    ///  the <see cref="F:Aspose.Words.Saving.Dml3DEffectsRenderingMode.Basic" />
    ///  mode if the rendering result is not acceptable.
    ///  Please see documentation for details.
    ///</remarks>
    Advanced = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how DrawingML effects are rendered to fixed page formats.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.DmlEffectsRenderingMode')]
  DNDmlEffectsRenderingMode = type Integer;
  DNDmlEffectsRenderingModeHelper = record helper for DNDmlEffectsRenderingMode
  public const
    ///<summary>
    ///  Rendering of DrawingML effects are simplified.
    ///</summary>
    Simplified = 0;
    ///<summary>
    ///  No DrawingML effects are rendered.
    ///</summary>
    None = 1;
    ///<summary>
    ///  DrawingML effects are rendered in fine mode which involves advanced processing.
    ///  In this mode rendering of effects gives better results but at a higher performance cost than <see cref="F:Aspose.Words.Saving.DmlEffectsRenderingMode.Simplified" />
    ///  mode.
    ///</summary>
    Fine = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how DrawingML shapes are rendered to fixed page formats.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.DmlRenderingMode')]
  DNDmlRenderingMode = type Integer;
  DNDmlRenderingModeHelper = record helper for DNDmlRenderingMode
  public const
    ///<summary>
    ///  If fall-back shape is available for DrawingML, Aspose.Words renders fall-back shape instead of the DrawingML.
    ///</summary>
    ///<remarks>
    ///  Please note that after saving a document to a fixed page format with fall-back DML rendering mode,
    ///  DML shapes in the AW document model are permanently replaced with their fall-back counterparts.
    ///  As a result, saving the same document again will always use fall-back shapes, even if DmlRenderingMode is set to DrawingML.
    ///</remarks>
    Fallback = 0;
    ///<summary>
    ///  Aspose.Words ignores fall-back shape of DrawingML and renders DrawingML itself.
    ///  This is the default mode.
    ///</summary>
    DrawingML = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how the document is split into parts when saving to <see cref="F:Aspose.Words.SaveFormat.Html" />
  ///  or <see cref="F:Aspose.Words.SaveFormat.Epub" />
  ///  format.
  ///</summary>
  ///<remarks><p><see cref="T:Aspose.Words.Saving.DocumentSplitCriteria" />
  ///  is a set of flags which can be combined. For instance you can split the document
  ///  at page breaks and heading paragraphs in the same export operation.</p>
  ///  <p>Different criteria can partially overlap. For instance, <b>Heading 1</b>
  ///  style is frequently given
  ///<see cref="P:Aspose.Words.ParagraphFormat.PageBreakBefore" />
  ///  property so it falls under two criteria: <see cref="F:Aspose.Words.Saving.DocumentSplitCriteria.PageBreak" />
  ///  and
  ///<see cref="F:Aspose.Words.Saving.DocumentSplitCriteria.HeadingParagraph" />
  ///  . Some section breaks can cause page breaks and so on.
  ///  In typical cases specifying only one flag is the most practical option.</p>
  ///<seealso cref="P:Aspose.Words.Saving.HtmlSaveOptions.DocumentSplitCriteria" />
  ///</remarks>
  [DNTypeName('Aspose.Words.Saving.DocumentSplitCriteria')]
  DNDocumentSplitCriteria = type Integer;
  DNDocumentSplitCriteriaHelper = record helper for DNDocumentSplitCriteria
  public const
    ///<summary>
    ///  The document is not split.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The document is split into parts at explicit page breaks.
    ///  A page break can be specified by a <see cref="F:Aspose.Words.ControlChar.PageBreak" />
    ///  character,
    ///  a section break specifying start of new section on a new page,
    ///  or a paragraph that has its <see cref="P:Aspose.Words.ParagraphFormat.PageBreakBefore" />
    ///  property set to <c>true</c>.
    ///</summary>
    PageBreak = 1;
    ///<summary>
    ///  The document is split into parts at column breaks.
    ///  A column break can be specified by a <see cref="F:Aspose.Words.ControlChar.ColumnBreak" />
    ///  character or
    ///  a section break specifying start of new section in a new column.
    ///</summary>
    ColumnBreak = 2;
    ///<summary>
    ///  The document is split into parts at a section break of any type.
    ///</summary>
    SectionBreak = 4;
    ///<summary>
    ///  The document is split into parts at a paragraph formatted using a heading style <b>Heading 1</b>
    ///  , <b>Heading 2</b>
    ///  etc.
    ///  Use together with <see cref="P:Aspose.Words.Saving.HtmlSaveOptions.DocumentSplitHeadingLevel" />
    ///  to specify the heading levels
    ///  (from 1 to the specified level) at which to split.
    ///</summary>
    HeadingParagraph = 8;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how Aspose.Words should render EMF+ Dual metafiles.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.EmfPlusDualRenderingMode')]
  DNEmfPlusDualRenderingMode = type Integer;
  DNEmfPlusDualRenderingModeHelper = record helper for DNEmfPlusDualRenderingMode
  public const
    ///<summary>
    ///  Aspose.Words tries to render EMF+ part of EMF+ Dual metafile. If some of the EMF+ records are not supported
    ///  then Aspose.Words renders EMF part of EMF+ Dual metafile.
    ///</summary>
    EmfPlusWithFallback = 0;
    ///<summary>
    ///  Aspose.Words renders EMF+ part of EMF+ Dual metafile.
    ///</summary>
    EmfPlus = 1;
    ///<summary>
    ///  Aspose.Words renders EMF part of EMF+ Dual metafile.
    ///</summary>
    Emf = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Indicates the format that is used to export fonts while rendering to HTML fixed format.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Saving.HtmlFixedSaveOptions.FontFormat" />
  [DNTypeName('Aspose.Words.Saving.ExportFontFormat')]
  DNExportFontFormat = type Integer;
  DNExportFontFormatHelper = record helper for DNExportFontFormat
  public const
    ///<summary>
    ///  WOFF (Web Open Font Format).
    ///</summary>
    Woff = 0;
    ///<summary>
    ///  TTF (TrueType Font format).
    ///</summary>
    Ttf = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how headers and footers are exported to HTML, MHTML or EPUB.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Saving.HtmlSaveOptions.ExportHeadersFootersMode" />
  [DNTypeName('Aspose.Words.Saving.ExportHeadersFootersMode')]
  DNExportHeadersFootersMode = type Integer;
  DNExportHeadersFootersModeHelper = record helper for DNExportHeadersFootersMode
  public const
    ///<summary>
    ///  Headers and footers are not exported.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Primary headers and footers are exported at the beginning and the end of each section.
    ///</summary>
    PerSection = 1;
    ///<summary>
    ///  Primary header of the first section is exported at the beginning of the document and primary footer is at the end.
    ///</summary>
    FirstSectionHeaderLastSectionFooter = 2;
    ///<summary>
    ///  First page header and footer are exported at the beginning and the end of each section.
    ///</summary>
    FirstPageHeaderFooterPerSection = 3;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how list labels are exported to HTML, MHTML and EPUB.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Saving.HtmlSaveOptions.ExportListLabels" />
  [DNTypeName('Aspose.Words.Saving.ExportListLabels')]
  DNExportListLabels = type Integer;
  DNExportListLabelsHelper = record helper for DNExportListLabels
  public const
    ///<summary>
    ///  Outputs list labels in auto mode. Uses HTML native elements when possible.
    ///</summary>
    ///<remarks>
    ///  HTML &lt;ul&gt; and &lt;ol&gt; tags are used for list label representation if it doesn't cause formatting loss, otherwise the HTML &lt;p&gt; tag is used.
    ///</remarks>
    Auto = 0;
    ///<summary>
    ///  Outputs all list labels as inline text.
    ///</summary>
    ///<remarks>
    ///  HTML &lt;p&gt; tag is used for any list label representation.
    ///</remarks>
    AsInlineText = 1;
    ///<summary>
    ///  Outputs all list labels as HTML native elements.
    ///</summary>
    ///<remarks>
    ///  HTML &lt;ul&gt; and &lt;ol&gt; tags are used for list label representation. Some formatting loss is possible.
    ///</remarks>
    ByHtmlTags = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how bookmarks in headers/footers are exported.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.HeaderFooterBookmarksExportMode')]
  DNHeaderFooterBookmarksExportMode = type Integer;
  DNHeaderFooterBookmarksExportModeHelper = record helper for DNHeaderFooterBookmarksExportMode
  public const
    ///<summary>
    ///  Bookmarks in headers/footers are not exported.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Only bookmark in first header/footer of the section is exported.
    ///</summary>
    First = 1;
    ///<summary>
    ///  Bookmarks in all headers/footers are exported.
    ///</summary>
    All = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how Aspose.Words exports element widths and heights to HTML, MHTML and EPUB.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Saving.HtmlSaveOptions.TableWidthOutputMode" />
  [DNTypeName('Aspose.Words.Saving.HtmlElementSizeOutputMode')]
  DNHtmlElementSizeOutputMode = type Integer;
  DNHtmlElementSizeOutputModeHelper = record helper for DNHtmlElementSizeOutputMode
  public const
    ///<summary>
    ///  All element sizes, both in absolute and relative units, specified in the document are exported.
    ///</summary>
    All = 0;
    ///<summary>
    ///  Element sizes are exported only if they are specified in relative units in the document.
    ///  Fixed sizes are not exported in this mode. Visual agents will calculate missing sizes to make
    ///  document layout more natural.
    ///</summary>
    RelativeOnly = 1;
    ///<summary>
    ///  Element sizes are not exported. Visual agents will build layout automatically according to relationship between elements.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the horizontal alignment for pages in output HTML document.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.HtmlFixedPageHorizontalAlignment')]
  DNHtmlFixedPageHorizontalAlignment = type Integer;
  DNHtmlFixedPageHorizontalAlignmentHelper = record helper for DNHtmlFixedPageHorizontalAlignment
  public const
    ///<summary>
    ///  Align pages to the left.
    ///</summary>
    Left = 0;
    ///<summary>
    ///  Center pages. This is the default value.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Align pages to the right.
    ///</summary>
    Right = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Indicates the format in which metafiles are saved to HTML documents.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.HtmlMetafileFormat')]
  DNHtmlMetafileFormat = type Integer;
  DNHtmlMetafileFormatHelper = record helper for DNHtmlMetafileFormat
  public const
    ///<summary>
    ///  Metafiles are rendered to raster PNG images.
    ///</summary>
    Png = 0;
    ///<summary>
    ///  Metafiles are converted to vector SVG images.
    ///</summary>
    Svg = 1;
    ///<summary>
    ///  Metafiles are saved as is, without conversion.
    ///</summary>
    EmfOrWmf = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how Aspose.Words exports OfficeMath to HTML, MHTML and EPUB.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.HtmlOfficeMathOutputMode')]
  DNHtmlOfficeMathOutputMode = type Integer;
  DNHtmlOfficeMathOutputModeHelper = record helper for DNHtmlOfficeMathOutputMode
  public const
    ///<summary>
    ///  OfficeMath is converted to HTML as image specified by &lt;img&gt; tag.
    ///</summary>
    Image = 0;
    ///<summary>
    ///  OfficeMath is converted to HTML using MathML.
    ///</summary>
    MathML = 1;
    ///<summary>
    ///  OfficeMath is converted to HTML as sequence of runs specified by &lt;span&gt; tags.
    ///</summary>
    Text = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Indicates the version of HTML is used when saving the document to <see cref="F:Aspose.Words.SaveFormat.Html" />
  ///  and
  ///<see cref="F:Aspose.Words.SaveFormat.Mhtml" />
  ///  formats.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.HtmlVersion')]
  DNHtmlVersion = type Integer;
  DNHtmlVersionHelper = record helper for DNHtmlVersion
  public const
    ///<summary>
    ///  Saves the document in compliance with the XHTML 1.0 Transitional standard.
    ///</summary>
    ///<remarks><p>Aspose.Words aims to output XHTML according to the XHTML 1.0 Transitional standard,
    ///  but the output will not always validate against the DTD. Some structures inside a Microsoft Word
    ///  document are hard or impossible to map to a document that will validate against the XHTML schema.
    ///  For example, XHTML does not allow nested lists (UL cannot be nested inside another UL element),
    ///  but in Microsoft Word document multilevel lists occur quite often.</p>
    ///</remarks>
    Xhtml = 0;
    ///<summary>
    ///  Saves the document in compliance with the HTML 5 standard.
    ///</summary>
    Html5 = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the method used to binarize image.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.ImageBinarizationMethod')]
  DNImageBinarizationMethod = type Integer;
  DNImageBinarizationMethodHelper = record helper for DNImageBinarizationMethod
  public const
    ///<summary>
    ///  Specifies threshold method.
    ///</summary>
    Threshold = 0;
    ///<summary>
    ///  Specifies dithering using Floyd-Steinberg error diffusion method.
    ///</summary>
    FloydSteinbergDithering = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the color mode for the generated images of document pages.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.ImageColorMode')]
  DNImageColorMode = type Integer;
  DNImageColorModeHelper = record helper for DNImageColorMode
  public const
    ///<summary>
    ///  The pages of the document will be rendered as color images.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The pages of the document will be rendered as grayscale images.
    ///</summary>
    Grayscale = 1;
    ///<summary>
    ///  The pages of the document will be rendered as black and white images.
    ///</summary>
    BlackAndWhite = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the pixel format for the generated images of document pages.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.ImagePixelFormat')]
  DNImagePixelFormat = type Integer;
  DNImagePixelFormatHelper = record helper for DNImagePixelFormat
  public const
    ///<summary>
    ///  16 bits per pixel, RGB.
    ///</summary>
    Format16BppRgb555 = 0;
    ///<summary>
    ///  16 bits per pixel, RGB.
    ///</summary>
    Format16BppRgb565 = 1;
    ///<summary>
    ///  16 bits per pixel, ARGB.
    ///</summary>
    Format16BppArgb1555 = 2;
    ///<summary>
    ///  24 bits per pixel, RGB.
    ///</summary>
    Format24BppRgb = 3;
    ///<summary>
    ///  32 bits per pixel, RGB.
    ///</summary>
    Format32BppRgb = 4;
    ///<summary>
    ///  32 bits per pixel, ARGB.
    ///</summary>
    Format32BppArgb = 5;
    ///<summary>
    ///  32 bits per pixel, ARGB, premultiplied alpha.
    ///</summary>
    Format32BppPArgb = 6;
    ///<summary>
    ///  48 bits per pixel, RGB.
    ///</summary>
    Format48BppRgb = 7;
    ///<summary>
    ///  64 bits per pixel, ARGB.
    ///</summary>
    Format64BppArgb = 8;
    ///<summary>
    ///  64 bits per pixel, ARGB, premultiplied alpha.
    ///</summary>
    Format64BppPArgb = 9;
    ///<summary>
    ///  1 bit per pixel, Indexed.
    ///</summary>
    Format1bppIndexed = 10;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  [DNTypeName('Aspose.Words.Saving.ImlRenderingMode')]
  DNImlRenderingMode = type Integer;
  DNImlRenderingModeHelper = record helper for DNImlRenderingMode
  public const
    Fallback = 0;
    InkML = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how Aspose.Words should render WMF and EMF metafiles.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.MetafileRenderingMode')]
  DNMetafileRenderingMode = type Integer;
  DNMetafileRenderingModeHelper = record helper for DNMetafileRenderingMode
  public const
    ///<summary>
    ///  Aspose.Words tries to render a metafile as vector graphics. If Aspose.Words cannot correctly render some of
    ///  the metafile records to vector graphics then Aspose.Words renders this metafile to a bitmap.
    ///</summary>
    VectorWithFallback = 0;
    ///<summary>
    ///  Aspose.Words renders a metafile as vector graphics.
    ///</summary>
    Vector = 1;
    ///<summary>
    ///  Aspose.Words invokes GDI+ to render a metafile to a bitmap and then saves the bitmap to the output document.
    ///</summary>
    Bitmap = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Indicates the symbol set that is used to represent numbers
  ///  while rendering to fixed page formats.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.NumeralFormat')]
  DNNumeralFormat = type Integer;
  DNNumeralFormatHelper = record helper for DNNumeralFormat
  public const
    ///<summary>
    ///  European numerals: 0123456789.
    ///</summary>
    European = 0;
    ///<summary>
    ///  Numerals used in Arabic: ٠١٢٣٤٥٦٧٨٩.
    ///  Unicode range U+0660 - u+0669.
    ///</summary>
    ArabicIndic = 1;
    ///<summary>
    ///  Numerals used in Persian and Urdu: ۰۱۲۳۴۵۶۷۸۹.
    ///  Unicode range U+06F0 - u+06F9.
    ///</summary>
    EasternArabicIndic = 2;
    ///<summary>
    ///  Symbol set is decided from context(locale and RTL property).
    ///</summary>
    Context = 3;
    ///<summary>
    ///  THIS OPTION IS NOT SUPPORTED.
    ///  Symbol set is decided from regional settings.
    ///</summary>
    System = 4;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specified units of measure to apply to measurable document content such as shape, widths and other during saving.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.OdtSaveMeasureUnit')]
  DNOdtSaveMeasureUnit = type Integer;
  DNOdtSaveMeasureUnitHelper = record helper for DNOdtSaveMeasureUnit
  public const
    ///<summary>
    ///  Specifies that the document content is saved using centimeters.
    ///</summary>
    Centimeters = 0;
    ///<summary>
    ///  Specifies that the document content is saved using inches.
    ///</summary>
    Inches = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Allows to specify which OOXML specification will be used when saving in the DOCX format.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.OoxmlCompliance')]
  DNOoxmlCompliance = type Integer;
  DNOoxmlComplianceHelper = record helper for DNOoxmlCompliance
  public const
    ///<summary>
    ///  ECMA-376 1st Edition, 2006.
    ///</summary>
    Ecma376_2006 = 0;
    ///<summary>
    ///  ISO/IEC 29500:2008 Transitional compliance level.
    ///</summary>
    Iso29500_2008_Transitional = 1;
    ///<summary>
    ///  ISO/IEC 29500:2008 Strict compliance level.
    ///</summary>
    Iso29500_2008_Strict = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the PDF standards compliance level.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfCompliance')]
  DNPdfCompliance = type Integer;
  DNPdfComplianceHelper = record helper for DNPdfCompliance
  public const
    ///<summary>
    ///  The output file will comply with the PDF 1.7 standard.
    ///</summary>
    Pdf17 = 0;
    ///<summary>
    ///  The output file will comply with the PDF 1.5 standard.
    ///</summary>
    Pdf15 = 1;
    ///<summary>
    ///  The output file will comply with the PDF/A-1a standard.
    ///  This level includes all the requirements of PDF/A-1b and additionally requires
    ///  that document structure be included (also known as being "tagged"),
    ///  with the objective of ensuring that document content can be searched and repurposed.
    ///</summary>
    ///<remarks>
    ///  Note that exporting the document structure significantly increases the memory consumption, especially
    ///  for the large documents.
    ///</remarks>
    PdfA1a = 2;
    ///<summary>
    ///  The output file will comply with the PDF/A-1b standard.
    ///  PDF/A-1b has the objective of ensuring reliable reproduction of the
    ///  visual appearance of the document.
    ///</summary>
    PdfA1b = 3;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the way <see cref="P:Aspose.Words.Document.CustomDocumentProperties" />
  ///  are exported to PDF file.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfCustomPropertiesExport')]
  DNPdfCustomPropertiesExport = type Integer;
  DNPdfCustomPropertiesExportHelper = record helper for DNPdfCustomPropertiesExport
  public const
    ///<summary>
    ///  No custom properties are exported.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Custom properties are exported as entries in /Info dictionary.
    ///<remarks></remarks>
    ///  <para>Custom properties with the following names are not exported:
    ///  "Title", "Author", "Subject", "Keywords", "Creator", "Producer", "CreationDate", "ModDate", "Trapped".
    ///</para></summary>
    Standard = 1;
    ///<summary>
    ///  Custom properties are Metadata.
    ///</summary>
    ///<remarks><para>The namespace of exported properties in XMP packet is "custprops".
    ///  Every property has an associated xml-element "custprops:Property1", "custprops:Property2" and so on.
    ///  There is "rdf:Description" element inside property element.
    ///  The description element has two elements "custprops:Name", containing custom property's name
    ///  as a value of this xml-element, and "custprops:Value", containing custom property's value as value of this xml-element.
    ///</para></remarks>
    Metadata = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies a digital hash algorithm used by a digital signature.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfDigitalSignatureHashAlgorithm')]
  DNPdfDigitalSignatureHashAlgorithm = type Integer;
  DNPdfDigitalSignatureHashAlgorithmHelper = record helper for DNPdfDigitalSignatureHashAlgorithm
  public const
    ///<summary>
    ///  SHA-1 hash algorithm.
    ///</summary>
    Sha1 = 0;
    ///<summary>
    ///  SHA-256 hash algorithm.
    ///</summary>
    Sha256 = 1;
    ///<summary>
    ///  SHA-384 hash algorithm.
    ///</summary>
    Sha384 = 2;
    ///<summary>
    ///  SHA-512 hash algorithm.
    ///</summary>
    Sha512 = 3;
    ///<summary>
    ///  SHA-1 hash algorithm.
    ///</summary>
    Md5 = 4;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the encryption algorithm to use for encrypting a PDF document.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfEncryptionAlgorithm')]
  DNPdfEncryptionAlgorithm = type Integer;
  DNPdfEncryptionAlgorithmHelper = record helper for DNPdfEncryptionAlgorithm
  public const
    ///<summary>
    ///  RC4 encryption, key length of 40 bits.
    ///</summary>
    RC4_40 = 0;
    ///<summary>
    ///  RC4 encryption, key length of 128 bits.
    ///</summary>
    RC4_128 = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how Aspose.Words should embed fonts.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfFontEmbeddingMode')]
  DNPdfFontEmbeddingMode = type Integer;
  DNPdfFontEmbeddingModeHelper = record helper for DNPdfFontEmbeddingMode
  public const
    ///<summary>
    ///  Aspose.Words embeds all fonts.
    ///</summary>
    EmbedAll = 0;
    ///<summary>
    ///  Aspose.Words embeds all fonts excepting standard Windows fonts Arial and Times New Roman.
    ///  Only Arial and Times New Roman fonts are affected in this mode because MS Word doesn't embed
    ///  only these fonts when saving document to PDF.
    ///</summary>
    EmbedNonstandard = 1;
    ///<summary>
    ///  Aspose.Words do not embed any fonts.
    ///</summary>
    EmbedNone = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how the color space will be selected for the images in PDF document.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfImageColorSpaceExportMode')]
  DNPdfImageColorSpaceExportMode = type Integer;
  DNPdfImageColorSpaceExportModeHelper = record helper for DNPdfImageColorSpaceExportMode
  public const
    ///<summary>
    ///  Aspose.Words automatically selects the most appropriate color space for each image.
    ///</summary>
    ///<remarks><para>Most of the images are saved in RGB color space. Also Indexed and Grayscale color spaces may be used. CMYK color space is never used.</para><para>For some images the color space may be different on different platforms.</para></remarks>
    Auto = 0;
    ///<summary>
    ///  Aspose.Words coverts RGB images to CMYK color space using simple formula.
    ///</summary>
    ///<remarks><para>
    ///  Images in RGB color space are converted to CMYK using formula:
    ///  Black   = minimum(1-Red,1-Green,1-Blue).
    ///  Cyan    = (1-Red-Black)/(1-Black).
    ///  Magenta = (1-Green-Black)/(1-Black).
    ///  Yellow  = (1-Blue-Black)/(1-Black).
    ///  RGB values are normalized - they are between 0 and 1.0.
    ///</para></remarks>
    SimpleCmyk = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the type of compression applied to images in the PDF file.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfImageCompression')]
  DNPdfImageCompression = type Integer;
  DNPdfImageCompressionHelper = record helper for DNPdfImageCompression
  public const
    ///<summary>
    ///  Automatically selects the most appropriate compression for each image.
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  Jpeg compression.
    ///  Does not support transparency.
    ///</summary>
    Jpeg = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies how the PDF document should be displayed when opened in the PDF reader.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfPageMode')]
  DNPdfPageMode = type Integer;
  DNPdfPageModeHelper = record helper for DNPdfPageMode
  public const
    ///<summary>
    ///  Neither document outline nor thumbnail images are visible.
    ///</summary>
    UseNone = 0;
    ///<summary>
    ///  Document outline is visible.
    ///  Note that if there're no outlines in the PDF document then outline navigation pane will not be visible anyway.
    ///</summary>
    UseOutlines = 1;
    ///<summary>
    ///  Thumbnail images are visible.
    ///</summary>
    UseThumbs = 2;
    ///<summary>
    ///  Full-screen mode, with no menu bar, window controls, or any other window visible.
    ///</summary>
    FullScreen = 3;
    ///<summary>
    ///  Optional content group panel is visible.
    ///</summary>
    UseOC = 4;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the operations that are allowed to a user on an encrypted PDF document.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfPermissions')]
  DNPdfPermissions = type Integer;
  DNPdfPermissionsHelper = record helper for DNPdfPermissions
  public const
    ///<summary>
    ///  Disallows all operations on the PDF document.
    ///  This is the default value.
    ///</summary>
    DisallowAll = 0;
    ///<summary>
    ///  Allows printing the document.
    ///</summary>
    Printing = 4;
    ///<summary>
    ///  Allows modifying the document’s contents.
    ///</summary>
    ModifyContents = 8;
    ///<summary>
    ///  Allows copying or otherwise extracting text and graphics from the document, including extraction for accessibility purposes.
    ///</summary>
    ContentCopy = 16;
    ///<summary>
    ///  Allows adding or modifying text annotations.
    ///  When using RC4 40-bit encryption, this option also allows filling in form fields.
    ///</summary>
    ModifyAnnotations = 32;
    ///<summary>
    ///  Allows filling in forms and signing the document.
    ///  When using RC4 40-bit encryption, this option is ignored and filling in form is allowed whenever <see cref="F:Aspose.Words.Saving.PdfPermissions.ModifyAnnotations" />
    ///  is set.
    ///</summary>
    FillIn = 256;
    ///<summary>
    ///  Allows extract text and graphics in support of accessibility to disabled users or for other purposes.
    ///  When using RC4 40-bit encryption, this option is ignored and accessibility is allowed whenever <see cref="F:Aspose.Words.Saving.PdfPermissions.ContentCopy" />
    ///  is set.
    ///</summary>
    ContentCopyForAccessibility = 512;
    ///<summary>
    ///  Allows assembling the document: inserting, rotating, or deleting pages and creating
    ///  navigation elements such as bookmarks or thumbnail images.
    ///  When using RC4 40-bit encryption, this option is ignored and document assembly is allowed when <see cref="F:Aspose.Words.Saving.PdfPermissions.ModifyContents" />
    ///  is set.
    ///</summary>
    DocumentAssembly = 1024;
    ///<summary>
    ///  Allows printing the document to the highest resolution possible.
    ///  When using RC4 40-bit encryption, this option is ignored and high resolution printing is allowed when <see cref="F:Aspose.Words.Saving.PdfPermissions.Printing" />
    ///  is set.
    ///</summary>
    HighResolutionPrinting = 2052;
    ///<summary>
    ///  Allows all operations on the PDF document.
    ///</summary>
    AllowAll = 65535;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies a type of compression applied to all content in the PDF file except images.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfTextCompression')]
  DNPdfTextCompression = type Integer;
  DNPdfTextCompressionHelper = record helper for DNPdfTextCompression
  public const
    ///<summary>
    ///  No compression.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Flate (ZIP) compression.
    ///</summary>
    Flate = 1;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the type of zoom applied to a PDF document when it is opened in a PDF viewer.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.PdfZoomBehavior')]
  DNPdfZoomBehavior = type Integer;
  DNPdfZoomBehaviorHelper = record helper for DNPdfZoomBehavior
  public const
    ///<summary>
    ///  How the document is displayed is left to the PDF viewer. Usually the viewer displays the document to fit page width.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Displays the page using the specified zoom factor.
    ///</summary>
    ZoomFactor = 1;
    ///<summary>
    ///  Displays the page so it visible entirely.
    ///</summary>
    FitPage = 2;
    ///<summary>
    ///  Fits the width of the page.
    ///</summary>
    FitWidth = 3;
    ///<summary>
    ///  Fits the height of the page.
    ///</summary>
    FitHeight = 4;
    ///<summary>
    ///  Fits the bounding box (rectangle containing all visible elements on the page).
    ///</summary>
    FitBox = 5;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary></summary>
  [DNTypeName('Aspose.Words.Saving.SvgTextOutputMode')]
  DNSvgTextOutputMode = type Integer;
  DNSvgTextOutputModeHelper = record helper for DNSvgTextOutputMode
  public const
    ///<summary>
    ///  SVG fonts are used to render text. Note, not all browsers support SVG fonts.
    ///</summary>
    UseSvgFonts = 0;
    ///<summary>
    ///  Fonts installed on the target machine are used to render text.
    ///  Note, if some of fonts used in the document are not available on the target machine, document can look differently.
    ///</summary>
    UseTargetMachineFonts = 1;
    ///<summary>
    ///  Text is rendered using curves. Note, text selection will not work if you use this option.
    ///</summary>
    UsePlacedGlyphs = 2;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Allows to specify the alignment of the content of the table to be used when exporting into Markdown format.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.TableContentAlignment')]
  DNTableContentAlignment = type Integer;
  DNTableContentAlignmentHelper = record helper for DNTableContentAlignment
  public const
    ///<summary>
    ///  The alignment will be taken from the first paragraph in corresponding table column.
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  The content of tables will be aligned to the Left.
    ///</summary>
    Left = 1;
    ///<summary>
    ///  The content of tables will be aligned to the Center.
    ///</summary>
    Center = 2;
    ///<summary>
    ///  The content of tables will be aligned to the Right.
    ///</summary>
    Right = 3;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies what type of compression to apply when saving page images into a TIFF file.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.TiffCompression')]
  DNTiffCompression = type Integer;
  DNTiffCompressionHelper = record helper for DNTiffCompression
  public const
    ///<summary>
    ///  Specifies no compression.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Specifies the RLE compression scheme.
    ///</summary>
    Rle = 1;
    ///<summary>
    ///  Specifies the LZW compression scheme.
    ///  In Java emulated by Deflate (Zip) compression.
    ///</summary>
    Lzw = 2;
    ///<summary>
    ///  Specifies the CCITT3 compression scheme.
    ///</summary>
    Ccitt3 = 3;
    ///<summary>
    ///  Specifies the CCITT4 compression scheme.
    ///</summary>
    Ccitt4 = 4;
  end;


  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Specifies the way headers and footers are exported to plain text format.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.TxtExportHeadersFootersMode')]
  DNTxtExportHeadersFootersMode = type Integer;
  DNTxtExportHeadersFootersModeHelper = record helper for DNTxtExportHeadersFootersMode
  public const
    ///<summary>
    ///  No headers and footers are exported.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Only primary headers and footers are exported at the beginning and end of each section.
    ///</summary>
    ///<remarks><para>It is hard to meaningfully output headers and footers to plain text because it is not paginated.</para><para>When this mode is used, only primary headers and footers are exported at the beginning and end of each section.</para></remarks>
    PrimaryOnly = 1;
    ///<summary>
    ///  All headers and footers are placed after all section bodies at the very end of a document.
    ///</summary>
    ///<remarks>
    ///  This mode is similar to Word.
    ///</remarks>
    AllAtEnd = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the layout mode for a section allowing to define the document grid behavior.
  ///</summary>
  [DNTypeName('Aspose.Words.SectionLayoutMode')]
  DNSectionLayoutMode = type Integer;
  DNSectionLayoutModeHelper = record helper for DNSectionLayoutMode
  public const
    ///<summary>
    ///  Specifies that no document grid shall be applied to the contents of the corresponding section in the document.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that the corresponding section shall have both the additional line pitch and character pitch
    ///  added to each line and character within it in order to maintain a specific number
    ///  of lines per page and characters per line.
    ///  Characters will not be automatically aligned with gridlines on typing.
    ///</summary>
    Grid = 1;
    ///<summary>
    ///  Specifies that the corresponding section shall have additional line pitch added to each line within it
    ///  in order to maintain the specified number of lines per page.
    ///</summary>
    LineGrid = 2;
    ///<summary>
    ///  Specifies that the corresponding section shall have both the additional line pitch and character pitch
    ///  added to each line and character within it in order to maintain a specific number
    ///  of lines per page and characters per line.
    ///  Characters will be automatically aligned with gridlines on typing.
    ///</summary>
    SnapToChars = 3;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  The type of break at the beginning of the section.
  ///</summary>
  [DNTypeName('Aspose.Words.SectionStart')]
  DNSectionStart = type Integer;
  DNSectionStartHelper = record helper for DNSectionStart
  public const
    ///<summary>
    ///  The new section starts on the same page as the previous section.
    ///</summary>
    Continuous = 0;
    ///<summary>
    ///  The section starts from a new column.
    ///</summary>
    NewColumn = 1;
    ///<summary>
    ///  The section starts from a new page.
    ///</summary>
    NewPage = 2;
    ///<summary>
    ///  The section starts on a new even page.
    ///</summary>
    EvenPage = 3;
    ///<summary>
    ///  The section starts on a new odd page.
    ///</summary>
    OddPage = 4;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Specifies names of compatibility options.
  ///</summary>
  [DNTypeName('Aspose.Words.Settings.Compatibility')]
  DNCompatibility = type Integer;
  DNCompatibilityHelper = record helper for DNCompatibility
  public const
    NoTabHangInd = 0;
    NoSpaceRaiseLower = 1;
    SuppressSpBfAfterPgBrk = 2;
    WrapTrailSpaces = 3;
    PrintColBlack = 4;
    NoColumnBalance = 5;
    ConvMailMergeEsc = 6;
    SuppressTopSpacing = 7;
    UseSingleBorderforContiguousCells = 8;
    TransparentMetafiles = 9;
    ShowBreaksInFrames = 10;
    SwapBordersOddFacingPgs = 11;
    DoNotLeaveBackslashAlone = 12;
    DoNotExpandOnShiftReturn = 13;
    UlTrailSpace = 14;
    BalanceSingleByteDoubleByteWidth = 15;
    SuppressTopSpacingAtTopOfPage = 16;
    SpacingInWholePoints = 17;
    PrintBodyTextBeforeHeader = 18;
    NoLeading = 19;
    SpaceForUL = 20;
    MWSmallCaps = 21;
    SuppressTopLineSpacingWP = 22;
    TruncateFontHeightLikeWP6 = 23;
    SubFontBySize = 24;
    LineWrapLikeWord6 = 25;
    DoNotSuppressParagraphBorder = 26;
    NoExtraLineSpacing = 27;
    SuppressBottomSpacing = 28;
    WPSpaceWidth = 29;
    WPJustification = 30;
    UsePrinterMetrics = 31;
    ShapeLayoutLikeWW8 = 32;
    FootnoteLayoutLikeWW8 = 33;
    DoNotUseHtmlParagraphAutoSpacing = 34;
    AdjustLineHeightInTable = 35;
    ForgetLastTabAlignment = 36;
    AutoSpaceLikeWord95 = 37;
    AlignTableRowByRow = 38;
    LayoutRawTableWidth = 39;
    LayoutTableRowsApart = 40;
    UseWord97LineBreakRules = 41;
    DoNotBreakWrappedTables = 42;
    doNotSnapToGridInCell = 43;
    SelectFldWithFirstOrLastChar = 44;
    ApplyBreakingRules = 45;
    DoNotWrapTextWithPunct = 46;
    DoNotUseEastAsianBreakRules = 47;
    UseWord2002TableStyleRules = 48;
    GrowAutofit = 49;
    UseNormalStyleForList = 50;
    DoNotUseIndentAsNumberingTabStop = 51;
    UseAltKinsokuLineBreakRules = 52;
    AllowSpaceOfSameStyleInTable = 53;
    DoNotSuppressIndentation = 54;
    DoNotAutofitConstrainedTables = 55;
    AutofitToFirstFixedWidthCell = 56;
    UnderlineTabInNumList = 57;
    DisplayHangulFixedWidth = 58;
    SplitPgBreakAndParaMark = 59;
    DoNotVertAlignCellWithSp = 60;
    DoNotBreakConstrainedForcedTable = 61;
    DoNotVertAlignInTxbx = 62;
    UseAnsiKerningPairs = 63;
    CachedColBalance = 64;
    UseFELayout = 65;
    UICompat97To2003 = 66;
    OverrideTableStyleFontSizeAndJustification = 67;
    DisableOpenTypeFontFormattingFeatures = 68;
    SwapInsideAndOutsideForMirrorIndentsAndRelativePositioning = 69;
    UseWord2010TableStyleRules = 70;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Specifies how Microsoft Word will report errors detected during mail merge.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Settings.MailMergeSettings.CheckErrors" />
  [DNTypeName('Aspose.Words.Settings.MailMergeCheckErrors')]
  DNMailMergeCheckErrors = type Integer;
  DNMailMergeCheckErrorsHelper = record helper for DNMailMergeCheckErrors
  public const
    ///<summary>
    ///  Simulate the merge and report errors in a new document.
    ///</summary>
    Simulate = 1;
    ///<summary>
    ///  Complete the merge and pause to report errors.
    ///</summary>
    PauseOnError = 2;
    ///<summary>
    ///  Equals to the <see cref="F:Aspose.Words.Settings.MailMergeCheckErrors.PauseOnError" />
    ///  value.
    ///</summary>
    Default_ = 2;
    ///<summary>
    ///  Complete the merge and report errors in a new document.
    ///</summary>
    CollectErrors = 3;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Specifies the type of an external mail merge data source.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Settings.MailMergeSettings.DataType" />
  ///<dev>Do not renumber these values as they are used in the DOC codec.</dev>
  [DNTypeName('Aspose.Words.Settings.MailMergeDataType')]
  DNMailMergeDataType = type Integer;
  DNMailMergeDataTypeHelper = record helper for DNMailMergeDataType
  public const
    ///<summary>
    ///  Specifies that a given document has been connected to a text file via the Dynamic Data Exchange (DDE) system.
    ///</summary>
    TextFile = 0;
    ///<summary>
    ///  Specifies that a given document has been connected to an Access database via the Dynamic Data Exchange (DDE) system.
    ///</summary>
    Database = 1;
    ///<summary>
    ///  Specifies that a given document has been connected to an Excel spreadsheet via the Dynamic Data Exchange (DDE) system.
    ///</summary>
    Spreadsheet = 2;
    ///<summary>
    ///  Specifies that a given document has been connected to an external data source using an external query tool.
    ///</summary>
    Query = 3;
    ///<summary>
    ///  Specifies that a given document has been connected to an external data source via the Open Database Connectivity interface.
    ///</summary>
    Odbc = 4;
    ///<summary>
    ///  Specifies that a given document has been connected to an external data source via the Office Data Source Object (ODSO) interface.
    ///</summary>
    Native = 5;
    ///<summary>
    ///  No mail merge data source is specified.
    ///</summary>
    None = -1;
    ///<summary>
    ///  Equals to <see cref="F:Aspose.Words.Settings.MailMergeDataType.None" />
    ///  .
    ///</summary>
    Default_ = -1;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Specifies the possible results which may be generated when a mail merge is carried out on a document.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Settings.MailMergeSettings.Destination" />
  ///<dev>Do not renumber these as they values are used in the DOC codec.</dev>
  [DNTypeName('Aspose.Words.Settings.MailMergeDestination')]
  DNMailMergeDestination = type Integer;
  DNMailMergeDestinationHelper = record helper for DNMailMergeDestination
  public const
    ///<summary>
    ///  Specifies that conforming hosting applications shall generate new documents by populating the fields
    ///  within a given document with data from the specified external data source.
    ///</summary>
    NewDocument = 0;
    ///<summary>
    ///  Equals to the <see cref="F:Aspose.Words.Settings.MailMergeDestination.NewDocument" />
    ///  value.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that conforming hosting applications shall print the documents that result from populating the
    ///  fields within a given document with external data from the specified external data source.
    ///</summary>
    Printer = 1;
    ///<summary>
    ///  Specifies that conforming hosting applications shall generate emails using the documents that result from
    ///  populating the fields within a given document with data from the specified external data source.
    ///</summary>
    Email = 2;
    ///<summary>
    ///  Specifies that conforming hosting applications shall generate faxes using the documents that result from
    ///  populating the fields within a given document with data from the specified external data source.
    ///</summary>
    Fax = 4;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Specifies the possible types for a mail merge source document.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Settings.MailMergeSettings.MainDocumentType" />
  ///<dev>Do not renumber these because the values are used in the DOC codec.</dev>
  [DNTypeName('Aspose.Words.Settings.MailMergeMainDocumentType')]
  DNMailMergeMainDocumentType = type Integer;
  DNMailMergeMainDocumentTypeHelper = record helper for DNMailMergeMainDocumentType
  public const
    ///<summary>
    ///  This document is not a mail merge document.
    ///</summary>
    NotAMergeDocument = 0;
    ///<summary>
    ///  Equals to <see cref="F:Aspose.Words.Settings.MailMergeMainDocumentType.NotAMergeDocument" />
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that the mail merge source document is of the form letter type.
    ///</summary>
    FormLetters = 1;
    ///<summary>
    ///  Specifies that the mail merge source document is of the mailing label type.
    ///</summary>
    MailingLabels = 2;
    ///<summary>
    ///  Specifies that the mail merge source document is of the envelope type.
    ///</summary>
    Envelopes = 4;
    ///<summary>
    ///  Specifies that the mail merge source document is of the catalog type.
    ///</summary>
    Catalog = 8;
    ///<summary>
    ///  Specifies that the mail merge source document is of the e-mail message type.
    ///</summary>
    Email = 16;
    ///<summary>
    ///  Specifies that the mail merge source document is of the fax type.
    ///</summary>
    Fax = 32;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Allows Aspose.Wods to mimic MS Word version-specific application behavior.
  ///</summary>
  [DNTypeName('Aspose.Words.Settings.MsWordVersion')]
  DNMsWordVersion = type Integer;
  DNMsWordVersionHelper = record helper for DNMsWordVersion
  public const
    ///<summary>
    ///  Optimize Aspose.Words behavior to match MS Word 2000 version.
    ///</summary>
    Word2000 = 0;
    ///<summary>
    ///  Optimize Aspose.Words behavior to match MS Word 2002 version.
    ///</summary>
    Word2002 = 1;
    ///<summary>
    ///  Optimize Aspose.Words behavior to match MS Word 2003 version.
    ///</summary>
    Word2003 = 2;
    ///<summary>
    ///  Optimize Aspose.Words behavior to match MS Word 2007 version.
    ///</summary>
    Word2007 = 3;
    ///<summary>
    ///  Optimize Aspose.Words behavior to match MS Word 2010 version.
    ///</summary>
    Word2010 = 4;
    ///<summary>
    ///  Optimize Aspose.Words behavior to match MS Word 2013 version.
    ///</summary>
    Word2013 = 5;
    ///<summary>
    ///  Optimize Aspose.Words behavior to match MS Word 2016 version.
    ///</summary>
    Word2016 = 6;
    ///<summary>
    ///  Optimize Aspose.Words behavior to match MS Word 2019 version.
    ///</summary>
    Word2019 = 7;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Specifies how document is printed out.
  ///</summary>
  [DNTypeName('Aspose.Words.Settings.MultiplePagesType')]
  DNMultiplePagesType = type Integer;
  DNMultiplePagesTypeHelper = record helper for DNMultiplePagesType
  public const
    ///<summary>
    ///  Normal printing, no multiple pages specified.
    ///</summary>
    Normal = 0;
    ///<summary>
    ///  Default value is <see cref="F:Aspose.Words.Settings.MultiplePagesType.Normal" />
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Swaps left and right margins on facing pages.
    ///</summary>
    MirrorMargins = 1;
    ///<summary>
    ///  Prints two pages per sheet.
    ///</summary>
    TwoPagesPerSheet = 2;
    ///<summary>
    ///  Specifies whether to print the document as a book fold.
    ///</summary>
    BookFoldPrinting = 3;
    ///<summary>
    ///  Specifies whether to print the document as a reverse book fold.
    ///</summary>
    BookFoldPrintingReverse = 4;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Specifies the type of the external data source to be connected to as part of the ODSO connection information.
  ///</summary>
  ///<remarks><para>The OOXML specification is very vague for this enum. I guess it might correspond to the WdMergeSubType
  ///  enumeration http://msdn.microsoft.com/en-us/library/bb237801.aspx.</para><seealso cref="P:Aspose.Words.Settings.Odso.DataSourceType" />
  ///</remarks>
  ///<dev>Do not renumber these.</dev>
  [DNTypeName('Aspose.Words.Settings.OdsoDataSourceType')]
  DNOdsoDataSourceType = type Integer;
  DNOdsoDataSourceTypeHelper = record helper for DNOdsoDataSourceType
  public const
    ///<summary>
    ///  Specifies that a given document has been connected to a text file.
    ///  Possibly wdMergeSubTypeOther.
    ///</summary>
    Text = 0;
    ///<summary>
    ///  Specifies that a given document has been connected to a database.
    ///  Possibly wdMergeSubTypeAccess.
    ///</summary>
    Database = 1;
    ///<summary>
    ///  Specifies that a given document has been connected to an address book of contacts.
    ///  Possibly wdMergeSubTypeOAL.
    ///</summary>
    AddressBook = 2;
    ///<summary>
    ///  Specifies that a given document has been connected to another document format supported by the producing application.
    ///  Possibly wdMergeSubTypeOLEDBWord.
    ///</summary>
    Document1 = 3;
    ///<summary>
    ///  Specifies that a given document has been connected to another document format supported by the producing application.
    ///  Possibly wdMergeSubTypeWorks.
    ///</summary>
    Document2 = 4;
    ///<summary>
    ///  Specifies that a given document has been connected to another document format native to the producing application.
    ///  Possibly wdMergeSubTypeOLEDBText
    ///</summary>
    Native = 5;
    ///<summary>
    ///  Specifies that a given document has been connected to an e-mail application.
    ///  Possibly wdMergeSubTypeOutlook.
    ///</summary>
    Email = 6;
    ///<summary>
    ///  The type of the external data source is not specified.
    ///  Possibly wdMergeSubTypeWord.
    ///</summary>
    None = 7;
    ///<summary>
    ///  Equals to <see cref="F:Aspose.Words.Settings.OdsoDataSourceType.None" />
    ///  .
    ///</summary>
    Default_ = 7;
    ///<summary>
    ///  Specifies that a given document has been connected to a legacy document format supported by the producing application
    ///  Possibly wdMergeSubTypeWord2000.
    ///</summary>
    Legacy = 8;
    ///<summary>
    ///  Specifies that a given document has been connected to a data source which aggregates other data sources.
    ///</summary>
    Master = 9;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Specifies the possible types used to indicate if a given mail merge field has been mapped to a column in the given external data source.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Settings.OdsoFieldMapData.Type" />
  [DNTypeName('Aspose.Words.Settings.OdsoFieldMappingType')]
  DNOdsoFieldMappingType = type Integer;
  DNOdsoFieldMappingTypeHelper = record helper for DNOdsoFieldMappingType
  public const
    ///<summary>
    ///  Specifies that the mail merge field has been mapped to a column in the given external data source.
    ///</summary>
    Column = 0;
    ///<summary>
    ///  Specifies that the mail merge field has not been mapped to a column in the given external data source.
    ///</summary>
    Null = 1;
    ///<summary>
    ///  Equals to <see cref="F:Aspose.Words.Settings.OdsoFieldMappingType.Null" />
    ///  .
    ///</summary>
    Default_ = 1;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Possible values for the view mode in Microsoft Word.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.Settings.ViewOptions" />
  ///<seealso cref="P:Aspose.Words.Settings.ViewOptions.ViewType" />
  [DNTypeName('Aspose.Words.Settings.ViewType')]
  DNViewType = type Integer;
  DNViewTypeHelper = record helper for DNViewType
  public const
    ///<summary>
    ///  The document shall be rendered in the default view of the application.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The document shall be rendered in the default view of the application.
    ///</summary>
    Reading = 0;
    ///<summary>
    ///  The document shall be opened in a view that displays the document as it will print.
    ///</summary>
    PageLayout = 1;
    ///<summary>
    ///  The document shall be rendered in a view optimized for outlining or creating long documents.
    ///</summary>
    Outline = 3;
    ///<summary>
    ///  The document shall be rendered in a view optimized for outlining or creating long documents.
    ///</summary>
    Normal = 4;
    ///<summary>
    ///  The document shall be rendered in a view mimicking the way this document would be displayed
    ///  in a web page.
    ///</summary>
    Web = 5;
  end;


  //-------------namespace: Aspose.Words.Settings----------------
  ///<summary>
  ///  Possible values for how large or small the document appears on the screen in Microsoft Word.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.Settings.ViewOptions" />
  ///<seealso cref="P:Aspose.Words.Settings.ViewOptions.ZoomType" />
  [DNTypeName('Aspose.Words.Settings.ZoomType')]
  DNZoomType = type Integer;
  DNZoomTypeHelper = record helper for DNZoomType
  public const
    ///<summary>
    ///  Zoom percentage is set explicitly. It is not recalculated automatically when control size changes.
    ///</summary>
    Custom = 0;
    ///<summary>
    ///  Indicates to use the explicit zoom percentage. Same as <see cref="F:Aspose.Words.Settings.ZoomType.Custom" />
    ///  .
    ///</summary>
    None = 0;
    ///<summary>
    ///  Zoom percentage is automatically recalculated to fit one full page.
    ///</summary>
    FullPage = 1;
    ///<summary>
    ///  Zoom percentage is automatically recalculated to fit page width.
    ///</summary>
    PageWidth = 2;
    ///<summary>
    ///  Zoom percentage is automatically recalculated to fit text.
    ///</summary>
    TextFit = 3;
  end;


  //-------------namespace: Aspose.Words.Shaping----------------
  [DNTypeName('Aspose.Words.Shaping.Direction')]
  DNDirection = type Integer;
  DNDirectionHelper = record helper for DNDirection
  public const
    Default_ = 0;
    LTR = 0;
    RTL = 1;
    TTB = 2;
    BTT = 3;
  end;


  //-------------namespace: Aspose.Words.Shaping----------------
  [DNTypeName('Aspose.Words.Shaping.FontFeature')]
  DNFontFeature = type Integer;
  DNFontFeatureHelper = record helper for DNFontFeature
  public const
    GlyphCompositionDecomposition = 1667460464;
    ContextualLigatures = 1668049255;
    DiscretionaryLigatures = 1684826471;
    HistoricalLigatures = 1751935335;
    Kerning = 1801810542;
    StandardLigatures = 1818847073;
    LiningFigures = 1819178349;
    OldstyleFigures = 1869509997;
    ProportionalFigures = 1886287213;
    RequiredLigatures = 1919707495;
    StylisticSet01 = 1936928817;
    StylisticSet02 = 1936928818;
    StylisticSet03 = 1936928819;
    StylisticSet04 = 1936928820;
    StylisticSet05 = 1936928821;
    StylisticSet06 = 1936928822;
    StylisticSet07 = 1936928823;
    StylisticSet08 = 1936928824;
    StylisticSet09 = 1936928825;
    StylisticSet10 = 1936929072;
    StylisticSet11 = 1936929073;
    StylisticSet12 = 1936929074;
    StylisticSet13 = 1936929075;
    StylisticSet14 = 1936929076;
    StylisticSet15 = 1936929077;
    StylisticSet16 = 1936929078;
    StylisticSet17 = 1936929079;
    StylisticSet18 = 1936929080;
    StylisticSet19 = 1936929081;
    StylisticSet20 = 1936929328;
    TabularFigures = 1953396077;
    VerticalAlternates = 1986359924;
    VerticalAlternatesAndRotation = 1987212338;
  end;


  //-------------namespace: Aspose.Words.Shaping----------------
  [DNTypeName('Aspose.Words.Shaping.UnicodeScript')]
  DNUnicodeScript = type Integer;
  DNUnicodeScriptHelper = record helper for DNUnicodeScript
  public const
    Adlam = 1097100397;
    Caucasian_Albanian = 1097295970;
    Ahom = 1097363309;
    Arabic = 1098015074;
    Imperial_Aramaic = 1098018153;
    Armenian = 1098018158;
    Avestan = 1098281844;
    Balinese = 1113681001;
    Bamum = 1113681269;
    Bassa_Vah = 1113682803;
    Batak = 1113683051;
    Bengali = 1113943655;
    Bhaiksuki = 1114139507;
    Bopomofo = 1114599535;
    Brahmi = 1114792296;
    Braille = 1114792297;
    Buginese = 1114990441;
    Buhid = 1114990692;
    Chakma = 1130457965;
    Canadian_Aboriginal = 1130458739;
    Carian = 1130459753;
    Cham = 1130914157;
    Cherokee = 1130915186;
    Chorasmian = 1130918515;
    Coptic = 1131376756;
    Cypriot = 1131442804;
    Cyrillic = 1132032620;
    Devanagari = 1147500129;
    Dives_Akuru = 1147756907;
    Dogra = 1148151666;
    Deseret = 1148416628;
    Duployan = 1148547180;
    Egyptian_Hieroglyphs = 1164409200;
    Elbasan = 1164730977;
    Elymaic = 1164736877;
    Ethiopic = 1165256809;
    Georgian = 1197830002;
    Glagolitic = 1198285159;
    Gunjala_Gondi = 1198485095;
    Masaram_Gondi = 1198485101;
    Gothic = 1198486632;
    Grantha = 1198678382;
    Greek = 1198679403;
    Gujarati = 1198877298;
    Gurmukhi = 1198879349;
    Hangul = 1214344807;
    Han = 1214344809;
    Hanunoo = 1214344815;
    Hatran = 1214346354;
    Hebrew = 1214603890;
    Hiragana = 1214870113;
    Anatolian_Hieroglyphs = 1215067511;
    Pahawh_Hmong = 1215131239;
    Nyiakeng_Puachue_Hmong = 1215131248;
    Katakana_Or_Hiragana = 1215458164;
    Old_Hungarian = 1215655527;
    Old_Italic = 1232363884;
    Javanese = 1247901281;
    Kayah_Li = 1264675945;
    Katakana = 1264676449;
    Kharoshthi = 1265131890;
    Khmer = 1265134962;
    Khojki = 1265135466;
    Khitan_Small_Script = 1265202291;
    Kannada = 1265525857;
    Kaithi = 1265920105;
    Tai_Tham = 1281453665;
    Lao = 1281453935;
    Latin = 1281455214;
    Lepcha = 1281716323;
    Limbu = 1281977698;
    Linear_A = 1281977953;
    Linear_B = 1281977954;
    Lisu = 1281979253;
    Lycian = 1283023721;
    Lydian = 1283023977;
    Mahajani = 1298229354;
    Makasar = 1298230113;
    Mandaic = 1298230884;
    Manichaean = 1298230889;
    Marchen = 1298231907;
    Medefaidrin = 1298490470;
    Mende_Kikakui = 1298493028;
    Meroitic_Cursive = 1298494051;
    Meroitic_Hieroglyphs = 1298494063;
    Malayalam = 1298954605;
    Modi = 1299145833;
    Mongolian = 1299148391;
    Mro = 1299345263;
    Meetei_Mayek = 1299473769;
    Multani = 1299541108;
    Myanmar = 1299803506;
    Nandinagari = 1315008100;
    Old_North_Arabian = 1315009122;
    Nabataean = 1315070324;
    Newa = 1315272545;
    Nko = 1315663727;
    Nushu = 1316186229;
    Ogham = 1332175213;
    Ol_Chiki = 1332503403;
    Old_Turkic = 1332898664;
    Oriya = 1332902241;
    Osage = 1332963173;
    Osmanya = 1332964705;
    Palmyrene = 1348562029;
    Pau_Cin_Hau = 1348564323;
    Old_Permic = 1348825709;
    Phags_Pa = 1349017959;
    Inscriptional_Pahlavi = 1349020777;
    Psalter_Pahlavi = 1349020784;
    Phoenician = 1349021304;
    Miao = 1349284452;
    Inscriptional_Parthian = 1349678185;
    Rejang = 1382706791;
    Hanifi_Rohingya = 1383032935;
    Runic = 1383427698;
    Samaritan = 1398893938;
    Old_South_Arabian = 1398895202;
    Saurashtra = 1398895986;
    SignWriting = 1399287415;
    Shavian = 1399349623;
    Sharada = 1399353956;
    Siddham = 1399415908;
    Khudawadi = 1399418468;
    Sinhala = 1399418472;
    Sogdian = 1399809892;
    Old_Sogdian = 1399809903;
    Sora_Sompeng = 1399812705;
    Soyombo = 1399814511;
    Sundanese = 1400204900;
    Syloti_Nagri = 1400466543;
    Syriac = 1400468067;
    Tagbanwa = 1415669602;
    Takri = 1415670642;
    Tai_Le = 1415670885;
    New_Tai_Lue = 1415670901;
    Tamil = 1415671148;
    Tangut = 1415671399;
    Tai_Viet = 1415673460;
    Telugu = 1415933045;
    Tifinagh = 1415999079;
    Tagalog = 1416064103;
    Thaana = 1416126817;
    Thai = 1416126825;
    Tibetan = 1416192628;
    Tirhuta = 1416196712;
    Ugaritic = 1432838514;
    Vai = 1449224553;
    Warang_Citi = 1466004065;
    Wancho = 1466132591;
    Old_Persian = 1483761007;
    Cuneiform = 1483961720;
    Yezidi = 1499822697;
    Yi = 1500080489;
    Zanabazar_Square = 1516334690;
    Inherited_ = 1516858984;
    Common = 1517910393;
    Unknown = 1517976186;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Text of a Word document is stored in stories. <b>StoryType</b>
  ///  identifies a story.
  ///</summary>
  [DNTypeName('Aspose.Words.StoryType')]
  DNStoryType = type Integer;
  DNStoryTypeHelper = record helper for DNStoryType
  public const
    ///<summary>
    ///  Default value. There is no such story in the document.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Contains the main text of the document, represented by <see cref="T:Aspose.Words.Body" />
    ///  .
    ///</summary>
    MainText = 1;
    ///<summary>
    ///  Contains footnote text, represented by <see cref="T:Aspose.Words.Notes.Footnote" />
    ///  .
    ///</summary>
    Footnotes = 2;
    ///<summary>
    ///  Contains endnotes text, represented by <see cref="T:Aspose.Words.Notes.Footnote" />
    ///  .
    ///</summary>
    Endnotes = 3;
    ///<summary>
    ///  Contains document comments (annotations), represented by <see cref="T:Aspose.Words.Comment" />
    ///  .
    ///</summary>
    Comments = 4;
    ///<summary>
    ///  Contains shape or textbox text, represented by <see cref="T:Aspose.Words.Drawing.Shape" />
    ///  .
    ///</summary>
    Textbox = 5;
    ///<summary>
    ///  Contains text of the even pages header, represented by <see cref="T:Aspose.Words.HeaderFooter" />
    ///  .
    ///</summary>
    EvenPagesHeader = 6;
    ///<summary>
    ///  Contains text of the primary header. When header is different for odd and even pages,
    ///  contains text of the odd pages header. Represented by <see cref="T:Aspose.Words.HeaderFooter" />
    ///  .
    ///</summary>
    PrimaryHeader = 7;
    ///<summary>
    ///  Contains text of the even pages footer, represented by <see cref="T:Aspose.Words.HeaderFooter" />
    ///  .
    ///</summary>
    EvenPagesFooter = 8;
    ///<summary>
    ///  Contains text of the primary footer. When footer is different for odd and even pages,
    ///  contains text of the odd pages footer. Represented by <see cref="T:Aspose.Words.HeaderFooter" />
    ///  .
    ///</summary>
    PrimaryFooter = 9;
    ///<summary>
    ///  Contains text of the first page header, represented by <see cref="T:Aspose.Words.HeaderFooter" />
    ///  .
    ///</summary>
    FirstPageHeader = 10;
    ///<summary>
    ///  Contains text of the first page footer, represented by <see cref="T:Aspose.Words.HeaderFooter" />
    ///  .
    ///</summary>
    FirstPageFooter = 11;
    ///<summary>
    ///  Contains the text of the footnote separator, represented by <see cref="T:Aspose.Words.Notes.FootnoteSeparator" />
    ///  .
    ///</summary>
    FootnoteSeparator = 12;
    ///<summary>
    ///  Contains the text of the footnote continuation separator, represented by <see cref="T:Aspose.Words.Notes.FootnoteSeparator" />
    ///  .
    ///</summary>
    FootnoteContinuationSeparator = 13;
    ///<summary>
    ///  Contains the text of the footnote continuation notice separator, represented by <see cref="T:Aspose.Words.Notes.FootnoteSeparator" />
    ///  .
    ///</summary>
    FootnoteContinuationNotice = 14;
    ///<summary>
    ///  Contains the text of the endnote separator, represented by <see cref="T:Aspose.Words.Notes.FootnoteSeparator" />
    ///  .
    ///</summary>
    EndnoteSeparator = 15;
    ///<summary>
    ///  Contains the text of the endnote continuation separator, represented by <see cref="T:Aspose.Words.Notes.FootnoteSeparator" />
    ///  .
    ///</summary>
    EndnoteContinuationSeparator = 16;
    ///<summary>
    ///  Contains the text of the endnote continuation notice separator, represented by <see cref="T:Aspose.Words.Notes.FootnoteSeparator" />
    ///  .
    ///</summary>
    EndnoteContinuationNotice = 17;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Locale independent style identifier.
  ///</summary>
  ///<remarks><p>The names of built-in styles in MS Word are localized for different languages.
  ///  Using a style identifier you can find the correct style regardless of the document language.</p>
  ///  <p>All user defined styles are assigned the StyleIdentifier.User value.</p>
  ///</remarks>
  ///<dev>DO NOT RENUMBER! These values are important for DOC import/export.</dev><dev>Please note that the CURRENT USED MAXIMUM COUNT is SmartLink (371).</dev>
  [DNTypeName('Aspose.Words.StyleIdentifier')]
  DNStyleIdentifier = type Integer;
  DNStyleIdentifierHelper = record helper for DNStyleIdentifier
  public const
    ///<summary>
    ///  The Normal style.
    ///</summary>
    Normal = 0;
    ///<summary>
    ///  The Heading 1 style.
    ///</summary>
    Heading1 = 1;
    ///<summary>
    ///  The Heading 2 style.
    ///</summary>
    Heading2 = 2;
    ///<summary>
    ///  The Heading 3 style.
    ///</summary>
    Heading3 = 3;
    ///<summary>
    ///  The Heading 4 style.
    ///</summary>
    Heading4 = 4;
    ///<summary>
    ///  The Heading 5 style.
    ///</summary>
    Heading5 = 5;
    ///<summary>
    ///  The Heading 6 style.
    ///</summary>
    Heading6 = 6;
    ///<summary>
    ///  The Heading 7 style.
    ///</summary>
    Heading7 = 7;
    ///<summary>
    ///  The Heading 8 style.
    ///</summary>
    Heading8 = 8;
    ///<summary>
    ///  The Heading 9 style.
    ///</summary>
    Heading9 = 9;
    ///<summary></summary>
    Index1 = 10;
    ///<summary></summary>
    Index2 = 11;
    ///<summary></summary>
    Index3 = 12;
    ///<summary></summary>
    Index4 = 13;
    ///<summary></summary>
    Index5 = 14;
    ///<summary></summary>
    Index6 = 15;
    ///<summary></summary>
    Index7 = 16;
    ///<summary></summary>
    Index8 = 17;
    ///<summary></summary>
    Index9 = 18;
    ///<summary></summary>
    Toc1 = 19;
    ///<summary></summary>
    Toc2 = 20;
    ///<summary></summary>
    Toc3 = 21;
    ///<summary></summary>
    Toc4 = 22;
    ///<summary></summary>
    Toc5 = 23;
    ///<summary></summary>
    Toc6 = 24;
    ///<summary></summary>
    Toc7 = 25;
    ///<summary></summary>
    Toc8 = 26;
    ///<summary></summary>
    Toc9 = 27;
    ///<summary>
    ///  The Normal Indent style.
    ///</summary>
    NormalIndent = 28;
    ///<summary>
    ///  The Footnote Text style.
    ///</summary>
    FootnoteText = 29;
    ///<summary>
    ///  The Annotation (Comment) Text style.
    ///</summary>
    CommentText = 30;
    ///<summary>
    ///  The Header style.
    ///</summary>
    Header = 31;
    ///<summary>
    ///  The Footer style.
    ///</summary>
    Footer = 32;
    ///<summary>
    ///  The Index Heading style.
    ///</summary>
    IndexHeading = 33;
    ///<summary></summary>
    Caption = 34;
    ///<summary>
    ///  The Table of Figures style.
    ///</summary>
    TableOfFigures = 35;
    ///<summary>
    ///  The Envelope Address style.
    ///</summary>
    EnvelopeAddress = 36;
    ///<summary>
    ///  The Envelope Return style.
    ///</summary>
    EnvelopeReturn = 37;
    ///<summary>
    ///  The Footnote Reference style.
    ///</summary>
    FootnoteReference = 38;
    ///<summary>
    ///  The Annotation (Comment) Reference style.
    ///</summary>
    CommentReference = 39;
    ///<summary>
    ///  The Line Number style.
    ///</summary>
    LineNumber = 40;
    ///<summary>
    ///  The Page Number style.
    ///</summary>
    PageNumber = 41;
    ///<summary>
    ///  The Endnote Reference style.
    ///</summary>
    EndnoteReference = 42;
    ///<summary>
    ///  The Endnote Text style.
    ///</summary>
    EndnoteText = 43;
    ///<summary></summary>
    TableOfAuthorities = 44;
    ///<summary></summary>
    Macro = 45;
    ///<summary></summary>
    ToaHeading = 46;
    ///<summary>
    ///  The List style.
    ///</summary>
    List = 47;
    ///<summary>
    ///  The List Bullet style.
    ///</summary>
    ListBullet = 48;
    ///<summary>
    ///  The List Number style.
    ///</summary>
    ListNumber = 49;
    ///<summary></summary>
    List2 = 50;
    ///<summary></summary>
    List3 = 51;
    ///<summary></summary>
    List4 = 52;
    ///<summary></summary>
    List5 = 53;
    ///<summary></summary>
    ListBullet2 = 54;
    ///<summary></summary>
    ListBullet3 = 55;
    ///<summary></summary>
    ListBullet4 = 56;
    ///<summary></summary>
    ListBullet5 = 57;
    ///<summary></summary>
    ListNumber2 = 58;
    ///<summary></summary>
    ListNumber3 = 59;
    ///<summary></summary>
    ListNumber4 = 60;
    ///<summary></summary>
    ListNumber5 = 61;
    ///<summary>
    ///  The Title style.
    ///</summary>
    Title = 62;
    ///<summary></summary>
    Closing = 63;
    ///<summary></summary>
    Signature = 64;
    ///<summary>
    ///  The Default Paragraph Font style.
    ///</summary>
    DefaultParagraphFont = 65;
    ///<summary>
    ///  The Body Text style.
    ///</summary>
    BodyText = 66;
    ///<summary></summary>
    BodyTextInd = 67;
    ///<summary></summary>
    ListContinue = 68;
    ///<summary></summary>
    ListContinue2 = 69;
    ///<summary></summary>
    ListContinue3 = 70;
    ///<summary></summary>
    ListContinue4 = 71;
    ///<summary></summary>
    ListContinue5 = 72;
    ///<summary></summary>
    MessageHeader = 73;
    ///<summary></summary>
    Subtitle = 74;
    ///<summary></summary>
    Salutation = 75;
    ///<summary></summary>
    Date = 76;
    ///<summary></summary>
    BodyText1I = 77;
    ///<summary></summary>
    BodyText1I2 = 78;
    ///<summary></summary>
    NoteHeading = 79;
    ///<summary></summary>
    BodyText2 = 80;
    ///<summary></summary>
    BodyText3 = 81;
    ///<summary></summary>
    BodyTextInd2 = 82;
    ///<summary></summary>
    BodyTextInd3 = 83;
    ///<summary></summary>
    BlockText = 84;
    ///<summary>
    ///  The Hyperlink style.
    ///</summary>
    Hyperlink = 85;
    ///<summary></summary>
    FollowedHyperlink = 86;
    ///<summary></summary>
    Strong = 87;
    ///<summary></summary>
    Emphasis = 88;
    ///<summary></summary>
    DocumentMap = 89;
    ///<summary></summary>
    PlainText = 90;
    ///<summary></summary>
    EmailSignature = 91;
    ///<summary></summary>
    HtmlTopOfForm = 92;
    ///<summary></summary>
    HtmlBottomOfForm = 93;
    ///<summary></summary>
    NormalWeb = 94;
    ///<summary></summary>
    HtmlAcronym = 95;
    ///<summary></summary>
    HtmlAddress = 96;
    ///<summary></summary>
    HtmlCite = 97;
    ///<summary></summary>
    HtmlCode = 98;
    ///<summary></summary>
    HtmlDefinition = 99;
    ///<summary></summary>
    HtmlKeyboard = 100;
    ///<summary></summary>
    HtmlPreformatted = 101;
    ///<summary></summary>
    HtmlSample = 102;
    ///<summary></summary>
    HtmlTypewriter = 103;
    ///<summary></summary>
    HtmlVariable = 104;
    ///<summary></summary>
    TableNormal = 105;
    ///<summary></summary>
    CommentSubject = 106;
    ///<summary></summary>
    NoList = 107;
    ///<summary>
    ///  The 1 / a / i style.
    ///</summary>
    OutlineList1 = 108;
    ///<summary>
    ///  The 1 / 1.1 / 1.1.1 style.
    ///</summary>
    OutlineList2 = 109;
    ///<summary>
    ///  The Article / Section style.
    ///</summary>
    OutlineList3 = 110;
    ///<summary></summary>
    TableSimple1 = 111;
    ///<summary></summary>
    TableSimple2 = 112;
    ///<summary></summary>
    TableSimple3 = 113;
    ///<summary></summary>
    TableClassic1 = 114;
    ///<summary></summary>
    TableClassic2 = 115;
    ///<summary></summary>
    TableClassic3 = 116;
    ///<summary></summary>
    TableClassic4 = 117;
    ///<summary></summary>
    TableColorful1 = 118;
    ///<summary></summary>
    TableColorful2 = 119;
    ///<summary></summary>
    TableColorful3 = 120;
    ///<summary></summary>
    TableColumns1 = 121;
    ///<summary></summary>
    TableColumns2 = 122;
    ///<summary></summary>
    TableColumns3 = 123;
    ///<summary></summary>
    TableColumns4 = 124;
    ///<summary></summary>
    TableColumns5 = 125;
    ///<summary></summary>
    TableGrid1 = 126;
    ///<summary></summary>
    TableGrid2 = 127;
    ///<summary></summary>
    TableGrid3 = 128;
    ///<summary></summary>
    TableGrid4 = 129;
    ///<summary></summary>
    TableGrid5 = 130;
    ///<summary></summary>
    TableGrid6 = 131;
    ///<summary></summary>
    TableGrid7 = 132;
    ///<summary></summary>
    TableGrid8 = 133;
    ///<summary></summary>
    TableList1 = 134;
    ///<summary></summary>
    TableList2 = 135;
    ///<summary></summary>
    TableList3 = 136;
    ///<summary></summary>
    TableList4 = 137;
    ///<summary></summary>
    TableList5 = 138;
    ///<summary></summary>
    TableList6 = 139;
    ///<summary></summary>
    TableList7 = 140;
    ///<summary></summary>
    TableList8 = 141;
    ///<summary></summary>
    Table3DEffects1 = 142;
    ///<summary></summary>
    Table3DEffects2 = 143;
    ///<summary></summary>
    Table3DEffects3 = 144;
    ///<summary></summary>
    TableContemporary = 145;
    ///<summary></summary>
    TableElegant = 146;
    ///<summary></summary>
    TableProfessional = 147;
    ///<summary></summary>
    TableSubtle1 = 148;
    ///<summary></summary>
    TableSubtle2 = 149;
    ///<summary></summary>
    TableWeb1 = 150;
    ///<summary></summary>
    TableWeb2 = 151;
    ///<summary></summary>
    TableWeb3 = 152;
    ///<summary></summary>
    BalloonText = 153;
    ///<summary></summary>
    TableGrid = 154;
    ///<summary></summary>
    TableTheme = 155;
    ///<summary></summary>
    PlaceholderText = 156;
    ///<summary></summary>
    NoSpacing = 157;
    ///<summary></summary>
    LightShading = 158;
    ///<summary></summary>
    LightList = 159;
    ///<summary></summary>
    LightGrid = 160;
    ///<summary></summary>
    MediumShading1 = 161;
    ///<summary></summary>
    MediumShading2 = 162;
    ///<summary></summary>
    MediumList1 = 163;
    ///<summary></summary>
    MediumList2 = 164;
    ///<summary></summary>
    MediumGrid1 = 165;
    ///<summary></summary>
    MediumGrid2 = 166;
    ///<summary></summary>
    MediumGrid3 = 167;
    ///<summary></summary>
    DarkList = 168;
    ///<summary></summary>
    ColorfulShading = 169;
    ///<summary></summary>
    ColorfulList = 170;
    ///<summary></summary>
    ColorfulGrid = 171;
    ///<summary></summary>
    LightShadingAccent1 = 172;
    ///<summary></summary>
    LightListAccent1 = 173;
    ///<summary></summary>
    LightGridAccent1 = 174;
    ///<summary></summary>
    MediumShading1Accent1 = 175;
    ///<summary></summary>
    MediumShading2Accent1 = 176;
    ///<summary></summary>
    MediumList1Accent1 = 177;
    ///<summary></summary>
    Revision = 178;
    ///<summary></summary>
    ListParagraph = 179;
    ///<summary></summary>
    Quote = 180;
    ///<summary></summary>
    IntenseQuote = 181;
    ///<summary></summary>
    MediumList2Accent1 = 182;
    ///<summary></summary>
    MediumGrid1Accent1 = 183;
    ///<summary></summary>
    MediumGrid2Accent1 = 184;
    ///<summary></summary>
    MediumGrid3Accent1 = 185;
    ///<summary></summary>
    DarkListAccent1 = 186;
    ///<summary></summary>
    ColorfulShadingAccent1 = 187;
    ///<summary></summary>
    ColorfulListAccent1 = 188;
    ///<summary></summary>
    ColorfulGridAccent1 = 189;
    ///<summary></summary>
    LightShadingAccent2 = 190;
    ///<summary></summary>
    LightListAccent2 = 191;
    ///<summary></summary>
    LightGridAccent2 = 192;
    ///<summary></summary>
    MediumShading1Accent2 = 193;
    ///<summary></summary>
    MediumShading2Accent2 = 194;
    ///<summary></summary>
    MediumList1Accent2 = 195;
    ///<summary></summary>
    MediumList2Accent2 = 196;
    ///<summary></summary>
    MediumGrid1Accent2 = 197;
    ///<summary></summary>
    MediumGrid2Accent2 = 198;
    ///<summary></summary>
    MediumGrid3Accent2 = 199;
    ///<summary></summary>
    DarkListAccent2 = 200;
    ///<summary></summary>
    ColorfulShadingAccent2 = 201;
    ///<summary></summary>
    ColorfulListAccent2 = 202;
    ///<summary></summary>
    ColorfulGridAccent2 = 203;
    ///<summary></summary>
    LightShadingAccent3 = 204;
    ///<summary></summary>
    LightListAccent3 = 205;
    ///<summary></summary>
    LightGridAccent3 = 206;
    ///<summary></summary>
    MediumShading1Accent3 = 207;
    ///<summary></summary>
    MediumShading2Accent3 = 208;
    ///<summary></summary>
    MediumList1Accent3 = 209;
    ///<summary></summary>
    MediumList2Accent3 = 210;
    ///<summary></summary>
    MediumGrid1Accent3 = 211;
    ///<summary></summary>
    MediumGrid2Accent3 = 212;
    ///<summary></summary>
    MediumGrid3Accent3 = 213;
    ///<summary></summary>
    DarkListAccent3 = 214;
    ///<summary></summary>
    ColorfulShadingAccent3 = 215;
    ///<summary></summary>
    ColorfulListAccent3 = 216;
    ///<summary></summary>
    ColorfulGridAccent3 = 217;
    ///<summary></summary>
    LightShadingAccent4 = 218;
    ///<summary></summary>
    LightListAccent4 = 219;
    ///<summary></summary>
    LightGridAccent4 = 220;
    ///<summary></summary>
    MediumShading1Accent4 = 221;
    ///<summary></summary>
    MediumShading2Accent4 = 222;
    ///<summary></summary>
    MediumList1Accent4 = 223;
    ///<summary></summary>
    MediumList2Accent4 = 224;
    ///<summary></summary>
    MediumGrid1Accent4 = 225;
    ///<summary></summary>
    MediumGrid2Accent4 = 226;
    ///<summary></summary>
    MediumGrid3Accent4 = 227;
    ///<summary></summary>
    DarkListAccent4 = 228;
    ///<summary></summary>
    ColorfulShadingAccent4 = 229;
    ///<summary></summary>
    ColorfulListAccent4 = 230;
    ///<summary></summary>
    ColorfulGridAccent4 = 231;
    ///<summary></summary>
    LightShadingAccent5 = 232;
    ///<summary></summary>
    LightListAccent5 = 233;
    ///<summary></summary>
    LightGridAccent5 = 234;
    ///<summary></summary>
    MediumShading1Accent5 = 235;
    ///<summary></summary>
    MediumShading2Accent5 = 236;
    ///<summary></summary>
    MediumList1Accent5 = 237;
    ///<summary></summary>
    MediumList2Accent5 = 238;
    ///<summary></summary>
    MediumGrid1Accent5 = 239;
    ///<summary></summary>
    MediumGrid2Accent5 = 240;
    ///<summary></summary>
    MediumGrid3Accent5 = 241;
    ///<summary></summary>
    DarkListAccent5 = 242;
    ///<summary></summary>
    ColorfulShadingAccent5 = 243;
    ///<summary></summary>
    ColorfulListAccent5 = 244;
    ///<summary></summary>
    ColorfulGridAccent5 = 245;
    ///<summary></summary>
    LightShadingAccent6 = 246;
    ///<summary></summary>
    LightListAccent6 = 247;
    ///<summary></summary>
    LightGridAccent6 = 248;
    ///<summary></summary>
    MediumShading1Accent6 = 249;
    ///<summary></summary>
    MediumShading2Accent6 = 250;
    ///<summary></summary>
    MediumList1Accent6 = 251;
    ///<summary></summary>
    MediumList2Accent6 = 252;
    ///<summary></summary>
    MediumGrid1Accent6 = 253;
    ///<summary></summary>
    MediumGrid2Accent6 = 254;
    ///<summary></summary>
    MediumGrid3Accent6 = 255;
    ///<summary></summary>
    DarkListAccent6 = 256;
    ///<summary></summary>
    ColorfulShadingAccent6 = 257;
    ///<summary></summary>
    ColorfulListAccent6 = 258;
    ///<summary></summary>
    ColorfulGridAccent6 = 259;
    ///<summary></summary>
    SubtleEmphasis = 260;
    ///<summary></summary>
    IntenseEmphasis = 261;
    ///<summary></summary>
    SubtleReference = 262;
    ///<summary></summary>
    IntenseReference = 263;
    ///<summary></summary>
    BookTitle = 264;
    ///<summary></summary>
    Bibliography = 265;
    ///<summary></summary>
    TocHeading = 266;
    ///<summary>
    ///  Plain Table 1
    ///</summary>
    PlainTable1 = 267;
    ///<summary>
    ///  Plain Table 2
    ///</summary>
    PlainTable2 = 268;
    ///<summary>
    ///  Plain Table 3
    ///</summary>
    PlainTable3 = 269;
    ///<summary>
    ///  Plain Table 4
    ///</summary>
    PlainTable4 = 270;
    ///<summary>
    ///  Plain Table 5
    ///</summary>
    PlainTable5 = 271;
    ///<summary>
    ///  Table Grid Light
    ///</summary>
    TableGridLight = 272;
    ///<summary>
    ///  Grid Table 1 Light
    ///</summary>
    GridTable1Light = 273;
    ///<summary>
    ///  Grid Table 2
    ///</summary>
    GridTable2 = 274;
    ///<summary>
    ///  Grid Table 3
    ///</summary>
    GridTable3 = 275;
    ///<summary>
    ///  Grid Table 4
    ///</summary>
    GridTable4 = 276;
    ///<summary>
    ///  Grid Table 5 Dark
    ///</summary>
    GridTable5Dark = 277;
    ///<summary>
    ///  Grid Table 6 Colorful
    ///</summary>
    GridTable6Colorful = 278;
    ///<summary>
    ///  Grid Table 7 Colorful
    ///</summary>
    GridTable7Colorful = 279;
    ///<summary>
    ///  Grid Table 1 Light - Accent 1
    ///</summary>
    GridTable1LightAccent1 = 280;
    ///<summary>
    ///  Grid Table 2 - Accent 1
    ///</summary>
    GridTable2Accent1 = 281;
    ///<summary>
    ///  Grid Table 3 - Accent 1
    ///</summary>
    GridTable3Accent1 = 282;
    ///<summary>
    ///  Grid Table 4 - Accent 1
    ///</summary>
    GridTable4Accent1 = 283;
    ///<summary>
    ///  Grid Table 5 Dark - Accent 1
    ///</summary>
    GridTable5DarkAccent1 = 284;
    ///<summary>
    ///  Grid Table 6 Colorful - Accent 1
    ///</summary>
    GridTable6ColorfulAccent1 = 285;
    ///<summary>
    ///  Grid Table 7 Colorful - Accent 1
    ///</summary>
    GridTable7ColorfulAccent1 = 286;
    ///<summary>
    ///  Grid Table 1 Light - Accent 2
    ///</summary>
    GridTable1LightAccent2 = 287;
    ///<summary>
    ///  Grid Table 2 - Accent 2
    ///</summary>
    GridTable2Accent2 = 288;
    ///<summary>
    ///  Grid Table 3 - Accent 2
    ///</summary>
    GridTable3Accent2 = 289;
    ///<summary>
    ///  Grid Table 4 - Accent 2
    ///</summary>
    GridTable4Accent2 = 290;
    ///<summary>
    ///  Grid Table 5 Dark - Accent 2
    ///</summary>
    GridTable5DarkAccent2 = 291;
    ///<summary>
    ///  Grid Table 6 Colorful - Accent 2
    ///</summary>
    GridTable6ColorfulAccent2 = 292;
    ///<summary>
    ///  Grid Table 7 Colorful - Accent 2
    ///</summary>
    GridTable7ColorfulAccent2 = 293;
    ///<summary>
    ///  Grid Table 1 Light - Accent 3
    ///</summary>
    GridTable1LightAccent3 = 294;
    ///<summary>
    ///  Grid Table 2 - Accent 3
    ///</summary>
    GridTable2Accent3 = 295;
    ///<summary>
    ///  Grid Table 3 - Accent 3
    ///</summary>
    GridTable3Accent3 = 296;
    ///<summary>
    ///  Grid Table 4 - Accent 3
    ///</summary>
    GridTable4Accent3 = 297;
    ///<summary>
    ///  Grid Table 5 Dark - Accent 3
    ///</summary>
    GridTable5DarkAccent3 = 298;
    ///<summary>
    ///  Grid Table 6 Colorful - Accent 3
    ///</summary>
    GridTable6ColorfulAccent3 = 299;
    ///<summary>
    ///  Grid Table 7 Colorful - Accent 3
    ///</summary>
    GridTable7ColorfulAccent3 = 300;
    ///<summary>
    ///  Grid Table 1 Light - Accent 4
    ///</summary>
    GridTable1LightAccent4 = 301;
    ///<summary>
    ///  Grid Table 2 - Accent 4
    ///</summary>
    GridTable2Accent4 = 302;
    ///<summary>
    ///  Grid Table 3 - Accent 4
    ///</summary>
    GridTable3Accent4 = 303;
    ///<summary>
    ///  Grid Table 4 - Accent 4
    ///</summary>
    GridTable4Accent4 = 304;
    ///<summary>
    ///  Grid Table 5 Dark - Accent 4
    ///</summary>
    GridTable5DarkAccent4 = 305;
    ///<summary>
    ///  Grid Table 6 Colorful - Accent 4
    ///</summary>
    GridTable6ColorfulAccent4 = 306;
    ///<summary>
    ///  Grid Table 7 Colorful - Accent 4
    ///</summary>
    GridTable7ColorfulAccent4 = 307;
    ///<summary>
    ///  Grid Table 1 Light - Accent 5
    ///</summary>
    GridTable1LightAccent5 = 308;
    ///<summary>
    ///  Grid Table 2 - Accent 5
    ///</summary>
    GridTable2Accent5 = 309;
    ///<summary>
    ///  Grid Table 3 - Accent 5
    ///</summary>
    GridTable3Accent5 = 310;
    ///<summary>
    ///  Grid Table 4 - Accent 5
    ///</summary>
    GridTable4Accent5 = 311;
    ///<summary>
    ///  Grid Table 5 Dark - Accent 5
    ///</summary>
    GridTable5DarkAccent5 = 312;
    ///<summary>
    ///  Grid Table 6 Colorful - Accent 5
    ///</summary>
    GridTable6ColorfulAccent5 = 313;
    ///<summary>
    ///  Grid Table 7 Colorful - Accent 5
    ///</summary>
    GridTable7ColorfulAccent5 = 314;
    ///<summary>
    ///  Grid Table 1 Light - Accent 6
    ///</summary>
    GridTable1LightAccent6 = 315;
    ///<summary>
    ///  Grid Table 2 - Accent 6
    ///</summary>
    GridTable2Accent6 = 316;
    ///<summary>
    ///  Grid Table 3 - Accent 6
    ///</summary>
    GridTable3Accent6 = 317;
    ///<summary>
    ///  Grid Table 4 - Accent 6
    ///</summary>
    GridTable4Accent6 = 318;
    ///<summary>
    ///  Grid Table 5 Dark - Accent 6
    ///</summary>
    GridTable5DarkAccent6 = 319;
    ///<summary>
    ///  Grid Table 6 Colorful - Accent 6
    ///</summary>
    GridTable6ColorfulAccent6 = 320;
    ///<summary>
    ///  Grid Table 7 Colorful - Accent 6
    ///</summary>
    GridTable7ColorfulAccent6 = 321;
    ///<summary>
    ///  List Table 1 Light
    ///</summary>
    ListTable1Light = 322;
    ///<summary>
    ///  List Table 2
    ///</summary>
    ListTable2 = 323;
    ///<summary>
    ///  List Table 3
    ///</summary>
    ListTable3 = 324;
    ///<summary>
    ///  List Table 4
    ///</summary>
    ListTable4 = 325;
    ///<summary>
    ///  List Table 5 Dark
    ///</summary>
    ListTable5Dark = 326;
    ///<summary>
    ///  List Table 6 Colorful
    ///</summary>
    ListTable6Colorful = 327;
    ///<summary>
    ///  List Table 7 Colorful
    ///</summary>
    ListTable7Colorful = 328;
    ///<summary>
    ///  List Table 1 Light - Accent 1
    ///</summary>
    ListTable1LightAccent1 = 329;
    ///<summary>
    ///  List Table 2 - Accent 1
    ///</summary>
    ListTable2Accent1 = 330;
    ///<summary>
    ///  List Table 3 - Accent 1
    ///</summary>
    ListTable3Accent1 = 331;
    ///<summary>
    ///  List Table 4 - Accent 1
    ///</summary>
    ListTable4Accent1 = 332;
    ///<summary>
    ///  List Table 5 Dark - Accent 1
    ///</summary>
    ListTable5DarkAccent1 = 333;
    ///<summary>
    ///  List Table 6 Colorful - Accent 1
    ///</summary>
    ListTable6ColorfulAccent1 = 334;
    ///<summary>
    ///  List Table 7 Colorful - Accent 1
    ///</summary>
    ListTable7ColorfulAccent1 = 335;
    ///<summary>
    ///  List Table 1 Light - Accent 2
    ///</summary>
    ListTable1LightAccent2 = 336;
    ///<summary>
    ///  List Table 2 - Accent 2
    ///</summary>
    ListTable2Accent2 = 337;
    ///<summary>
    ///  List Table 3 - Accent 2
    ///</summary>
    ListTable3Accent2 = 338;
    ///<summary>
    ///  List Table 4 - Accent 2
    ///</summary>
    ListTable4Accent2 = 339;
    ///<summary>
    ///  List Table 5 Dark - Accent 2
    ///</summary>
    ListTable5DarkAccent2 = 340;
    ///<summary>
    ///  List Table 6 Colorful - Accent 2
    ///</summary>
    ListTable6ColorfulAccent2 = 341;
    ///<summary>
    ///  List Table 7 Colorful - Accent 2
    ///</summary>
    ListTable7ColorfulAccent2 = 342;
    ///<summary>
    ///  List Table 1 Light - Accent 3
    ///</summary>
    ListTable1LightAccent3 = 343;
    ///<summary>
    ///  List Table 2 - Accent 3
    ///</summary>
    ListTable2Accent3 = 344;
    ///<summary>
    ///  List Table 3 - Accent 3
    ///</summary>
    ListTable3Accent3 = 345;
    ///<summary>
    ///  List Table 4 - Accent 3
    ///</summary>
    ListTable4Accent3 = 346;
    ///<summary>
    ///  List Table 5 Dark - Accent 3
    ///</summary>
    ListTable5DarkAccent3 = 347;
    ///<summary>
    ///  List Table 6 Colorful - Accent 3
    ///</summary>
    ListTable6ColorfulAccent3 = 348;
    ///<summary>
    ///  List Table 7 Colorful - Accent 3
    ///</summary>
    ListTable7ColorfulAccent3 = 349;
    ///<summary>
    ///  List Table 1 Light - Accent 4
    ///</summary>
    ListTable1LightAccent4 = 350;
    ///<summary>
    ///  List Table 2 - Accent 4
    ///</summary>
    ListTable2Accent4 = 351;
    ///<summary>
    ///  List Table 3 - Accent 4
    ///</summary>
    ListTable3Accent4 = 352;
    ///<summary>
    ///  List Table 4 - Accent 4
    ///</summary>
    ListTable4Accent4 = 353;
    ///<summary>
    ///  List Table 5 Dark - Accent 4
    ///</summary>
    ListTable5DarkAccent4 = 354;
    ///<summary>
    ///  List Table 6 Colorful - Accent 4
    ///</summary>
    ListTable6ColorfulAccent4 = 355;
    ///<summary>
    ///  List Table 7 Colorful - Accent 4
    ///</summary>
    ListTable7ColorfulAccent4 = 356;
    ///<summary>
    ///  List Table 1 Light - Accent 5
    ///</summary>
    ListTable1LightAccent5 = 357;
    ///<summary>
    ///  List Table 2 - Accent 5
    ///</summary>
    ListTable2Accent5 = 358;
    ///<summary>
    ///  List Table 3 - Accent 5
    ///</summary>
    ListTable3Accent5 = 359;
    ///<summary>
    ///  List Table 4 - Accent 5
    ///</summary>
    ListTable4Accent5 = 360;
    ///<summary>
    ///  List Table 5 Dark - Accent 5
    ///</summary>
    ListTable5DarkAccent5 = 361;
    ///<summary>
    ///  List Table 6 Colorful - Accent 5
    ///</summary>
    ListTable6ColorfulAccent5 = 362;
    ///<summary>
    ///  List Table 7 Colorful - Accent 5
    ///</summary>
    ListTable7ColorfulAccent5 = 363;
    ///<summary>
    ///  List Table 1 Light - Accent 6
    ///</summary>
    ListTable1LightAccent6 = 364;
    ///<summary>
    ///  List Table 2 - Accent 6
    ///</summary>
    ListTable2Accent6 = 365;
    ///<summary>
    ///  List Table 3 - Accent 6
    ///</summary>
    ListTable3Accent6 = 366;
    ///<summary>
    ///  List Table 4 - Accent 6
    ///</summary>
    ListTable4Accent6 = 367;
    ///<summary>
    ///  List Table 5 Dark - Accent 6
    ///</summary>
    ListTable5DarkAccent6 = 368;
    ///<summary>
    ///  List Table 6 Colorful - Accent 6
    ///</summary>
    ListTable6ColorfulAccent6 = 369;
    ///<summary>
    ///  List Table 7 Colorful - Accent 6
    ///</summary>
    ListTable7ColorfulAccent6 = 370;
    ///<summary>
    ///  The Smart Link style.
    ///</summary>
    SmartLink = 371;
    ///<summary>
    ///  A user defined style.
    ///</summary>
    User = 4094;
    ///<summary>
    ///  Reserved for internal use.
    ///</summary>
    Nil_ = 12287;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Represents type of the style.
  ///</summary>
  [DNTypeName('Aspose.Words.StyleType')]
  DNStyleType = type Integer;
  DNStyleTypeHelper = record helper for DNStyleType
  public const
    ///<summary>
    ///  The style is a paragraph style.
    ///</summary>
    Paragraph = 1;
    ///<summary>
    ///  The style is a character style.
    ///</summary>
    Character = 2;
    ///<summary>
    ///  The style is a table style.
    ///</summary>
    Table = 3;
    ///<summary>
    ///  The style is a list style.
    ///</summary>
    List = 4;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the alignment/type of a tab stop.
  ///</summary>
  [DNTypeName('Aspose.Words.TabAlignment')]
  DNTabAlignment = type Integer;
  DNTabAlignmentHelper = record helper for DNTabAlignment
  public const
    ///<summary>
    ///  Left-aligns the text after the tab stop.
    ///</summary>
    Left = 0;
    ///<summary>
    ///  Centers the text around the tab stop.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Right-aligns the text at the tab stop.
    ///</summary>
    Right = 2;
    ///<summary>
    ///  Aligns the text at the decimal dot.
    ///</summary>
    Decimal = 3;
    ///<summary>
    ///  Draws a vertical bar at the tab stop position.
    ///</summary>
    Bar = 4;
    ///<summary>
    ///  The tab is a delimiter between the number/bullet and text in a list item.
    ///</summary>
    List = 6;
    ///<summary>
    ///  Clears any tab stop in this position.
    ///</summary>
    Clear = 7;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the type of the leader line displayed under the tab character.
  ///</summary>
  [DNTypeName('Aspose.Words.TabLeader')]
  DNTabLeader = type Integer;
  DNTabLeaderHelper = record helper for DNTabLeader
  public const
    ///<summary>
    ///  No leader line is displayed.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The leader line is made up from dots.
    ///</summary>
    Dots = 1;
    ///<summary>
    ///  The leader line is made up from dashes.
    ///</summary>
    Dashes = 2;
    ///<summary>
    ///  The leader line is a single line.
    ///</summary>
    Line = 3;
    ///<summary>
    ///  The leader line is a single thick line.
    ///</summary>
    Heavy = 4;
    ///<summary>
    ///  The leader line is made up from middle-dots.
    ///</summary>
    MiddleDot = 5;
  end;


  //-------------namespace: Aspose.Words.Tables----------------
  ///<summary>
  ///  Determines how Aspose.Words resizes the table when you invoke the <see cref="M:Aspose.Words.Tables.Table.AutoFit(Aspose.Words.Tables.AutoFitBehavior)" />
  ///  method.
  ///</summary>
  [DNTypeName('Aspose.Words.Tables.AutoFitBehavior')]
  DNAutoFitBehavior = type Integer;
  DNAutoFitBehaviorHelper = record helper for DNAutoFitBehavior
  public const
    ///<summary><para>Aspose.Words enables the AutoFit option, removes the preferred width from the table and all cells and then updates the table layout.</para><para>In the resulting table, cell widths are updated to fit the table contents. Most likely, the table will shrink.</para></summary>
    AutoFitToContents = 0;
    ///<summary><para>When you use this value, Aspose.Words enables the AutoFit option, sets the preferred width for the table to 100%,
    ///  removes preferred widths from all cells and then updates the table layout.</para><para>As a result, the table occupies all available width and the cell widths are updated to fit table contents.</para></summary>
    AutoFitToWindow = 1;
    ///<summary><para>Aspose.Words disables the AutoFit option and removes the preferred with from the table.</para><para>The widths of the cells remain as they are specified by their <see cref="P:Aspose.Words.Tables.CellFormat.Width" />
    ///  properties.</para></summary>
    FixedColumnWidths = 2;
  end;


  //-------------namespace: Aspose.Words.Tables----------------
  ///<summary>
  ///  Specifies how a cell in a table is merged with other cells.
  ///</summary>
  [DNTypeName('Aspose.Words.Tables.CellMerge')]
  DNCellMerge = type Integer;
  DNCellMergeHelper = record helper for DNCellMerge
  public const
    ///<summary>
    ///  The cell is not merged.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The cell is the first cell in a range of merged cells.
    ///</summary>
    First = 1;
    ///<summary>
    ///  The cell is merged to the previous cell horizontally or vertically.
    ///</summary>
    Previous = 2;
  end;


  //-------------namespace: Aspose.Words.Tables----------------
  ///<summary>
  ///  Specifies vertical justification of text inside a table cell.
  ///</summary>
  [DNTypeName('Aspose.Words.Tables.CellVerticalAlignment')]
  DNCellVerticalAlignment = type Integer;
  DNCellVerticalAlignmentHelper = record helper for DNCellVerticalAlignment
  public const
    ///<summary>
    ///  Text is aligned at the top of a cell.
    ///</summary>
    Top = 0;
    ///<summary>
    ///  Text is aligned in the middle of a cell.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Text is aligned at the bottom of the cell.
    ///</summary>
    Bottom = 2;
  end;


  //-------------namespace: Aspose.Words.Tables----------------
  ///<summary>
  ///  Specifies the unit of measurement for the preferred width of a table or cell.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.Tables.PreferredWidth" />
  [DNTypeName('Aspose.Words.Tables.PreferredWidthType')]
  DNPreferredWidthType = type Integer;
  DNPreferredWidthTypeHelper = record helper for DNPreferredWidthType
  public const
    ///<summary>
    ///  The preferred width is not specified. The actual width of the table or cell is either specified using the explicit width or
    ///  will be determined automatically by the table layout algorithm when the table is displayed, depending on the table auto fit setting.
    ///</summary>
    Auto = 1;
    ///<summary>
    ///  Measure the current item width using a specified percentage.
    ///</summary>
    Percent = 2;
    ///<summary>
    ///  Measure the current item width using a specified number of points (1/72 inch).
    ///</summary>
    Points = 3;
  end;


  //-------------namespace: Aspose.Words.Tables----------------
  ///<summary>
  ///  Specifies alignment for an inline table.
  ///</summary>
  [DNTypeName('Aspose.Words.Tables.TableAlignment')]
  DNTableAlignment = type Integer;
  DNTableAlignmentHelper = record helper for DNTableAlignment
  public const
    ///<summary>
    ///  The table is aligned to the left.
    ///</summary>
    Left = 0;
    ///<summary>
    ///  The table is centered.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  The table is aligned to the right.
    ///</summary>
    Right = 2;
  end;


  //-------------namespace: Aspose.Words.Tables----------------
  ///<summary>
  ///  Specifies how table style is applied to a table.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Tables.Table.StyleOptions" />
  ///<dev>
  ///  2.4.51 tblLook (Table Style Conditional Formatting Settings)
  ///  The DOC spec defines more values here, but it says they are ignored by Word 2007 so we ignore them too.
  ///</dev>
  [DNTypeName('Aspose.Words.Tables.TableStyleOptions')]
  DNTableStyleOptions = type Integer;
  DNTableStyleOptionsHelper = record helper for DNTableStyleOptions
  public const
    ///<summary>
    ///  No table style formatting is applied.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Apply first row conditional formatting.
    ///</summary>
    FirstRow = 32;
    ///<summary>
    ///  Apply last row conditional formatting.
    ///</summary>
    LastRow = 64;
    ///<summary>
    ///  Apply 1 first column conditional formatting.
    ///</summary>
    FirstColumn = 128;
    ///<summary>
    ///  Apply last column conditional formatting.
    ///</summary>
    LastColumn = 256;
    ///<summary>
    ///  Apply row banding conditional formatting.
    ///</summary>
    RowBands = 512;
    ///<summary>
    ///  This is Microsoft Word defaults.
    ///</summary>
    Default_ = 672;
    ///<summary>
    ///  Apply column banding conditional formatting.
    ///</summary>
    ColumnBands = 1024;
    ///<summary>
    ///  Row and column banding is applied. This is Microsoft Word default for old formats such as DOC, WML and RTF.
    ///</summary>
    Default2003 = 1536;
  end;


  //-------------namespace: Aspose.Words.Tables----------------
  ///<summary>
  ///  Specifies how text is wrapped around the table.
  ///</summary>
  [DNTypeName('Aspose.Words.Tables.TextWrapping')]
  DNTextWrapping = type Integer;
  DNTextWrappingHelper = record helper for DNTextWrapping
  public const
    ///<summary>
    ///  Default value.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Text and table is displayed in the order of their appearance in the document.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Text is wrapped around the table occupying available side space.
    ///</summary>
    Around = 1;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Dml text effect for text runs.
  ///</summary>
  [DNTypeName('Aspose.Words.TextDmlEffect')]
  DNTextDmlEffect = type Integer;
  DNTextDmlEffectHelper = record helper for DNTextDmlEffect
  public const
    ///<summary>
    ///  Glow effect, in which a color blurred outline is added outside the edges of the object.
    ///</summary>
    Glow = 0;
    ///<summary>
    ///  Fill overlay effect.
    ///</summary>
    Fill = 1;
    ///<summary>
    ///  Shadow effect.
    ///</summary>
    Shadow = 2;
    ///<summary>
    ///  Outline effect.
    ///</summary>
    Outline = 3;
    ///<summary>
    ///  3D effect.
    ///</summary>
    Effect3D = 4;
    ///<summary>
    ///  Reflection effect.
    ///</summary>
    Reflection = 5;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Animation effect for text runs.
  ///</summary>
  [DNTypeName('Aspose.Words.TextEffect')]
  DNTextEffect = type Integer;
  DNTextEffectHelper = record helper for DNTextEffect
  public const
    ///<summary></summary>
    None = 0;
    ///<summary></summary>
    LasVegasLights = 1;
    ///<summary></summary>
    BlinkingBackground = 2;
    ///<summary></summary>
    SparkleText = 3;
    ///<summary></summary>
    MarchingBlackAnts = 4;
    ///<summary></summary>
    MarchingRedAnts = 5;
    ///<summary></summary>
    Shimmer = 6;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies orientation of text on a page, in a table cell or a text frame.
  ///</summary>
  [DNTypeName('Aspose.Words.TextOrientation')]
  DNTextOrientation = type Integer;
  DNTextOrientationHelper = record helper for DNTextOrientation
  public const
    ///<summary>
    ///  Text is arranged horizontally (lr-tb).
    ///</summary>
    Horizontal = 0;
    ///<summary>
    ///  Text is rotated 90 degrees to the right to appear from top to bottom (tb-rl).
    ///</summary>
    Downward = 1;
    ///<summary>
    ///  Text is rotated 90 degrees to the left to appear from bottom to top (bt-lr).
    ///</summary>
    Upward = 3;
    ///<summary>
    ///  Text is arranged horizontally, but Far East characters are rotated 90 degrees to the left (lr-tb-v).
    ///</summary>
    HorizontalRotatedFarEast = 4;
    ///<summary>
    ///  Far East characters appear vertical, other text is rotated 90 degrees
    ///  to the right to appear from top to bottom (tb-rl-v).
    ///</summary>
    VerticalFarEast = 5;
    ///<summary>
    ///  Far East characters appear vertical, other text is rotated 90 degrees
    ///  to the right to appear from top to bottom vertically, then left to right horizontally  (tb-lr-v).
    ///</summary>
    ///<dev> IN: Set this value to 7 because MS Word uses this value in DOC format. </dev>
    VerticalRotatedFarEast = 7;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies shading texture.
  ///</summary>
  [DNTypeName('Aspose.Words.TextureIndex')]
  DNTextureIndex = type Integer;
  DNTextureIndexHelper = record helper for DNTextureIndex
  public const
    ///<summary></summary>
    TextureNone = 0;
    ///<summary></summary>
    TextureSolid = 1;
    ///<summary></summary>
    Texture5Percent = 2;
    ///<summary></summary>
    Texture10Percent = 3;
    ///<summary></summary>
    Texture20Percent = 4;
    ///<summary></summary>
    Texture25Percent = 5;
    ///<summary></summary>
    Texture30Percent = 6;
    ///<summary></summary>
    Texture40Percent = 7;
    ///<summary></summary>
    Texture50Percent = 8;
    ///<summary></summary>
    Texture60Percent = 9;
    ///<summary></summary>
    Texture70Percent = 10;
    ///<summary></summary>
    Texture75Percent = 11;
    ///<summary></summary>
    Texture80Percent = 12;
    ///<summary></summary>
    Texture90Percent = 13;
    ///<summary></summary>
    TextureDarkHorizontal = 14;
    ///<summary></summary>
    TextureDarkVertical = 15;
    ///<summary></summary>
    TextureDarkDiagonalDown = 16;
    ///<summary></summary>
    TextureDarkDiagonalUp = 17;
    ///<summary></summary>
    TextureDarkCross = 18;
    ///<summary></summary>
    TextureDarkDiagonalCross = 19;
    ///<summary></summary>
    TextureHorizontal = 20;
    ///<summary></summary>
    TextureVertical = 21;
    ///<summary></summary>
    TextureDiagonalDown = 22;
    ///<summary></summary>
    TextureDiagonalUp = 23;
    ///<summary></summary>
    TextureCross = 24;
    ///<summary></summary>
    TextureDiagonalCross = 25;
    ///<summary></summary>
    Texture2Pt5Percent = 35;
    ///<summary></summary>
    Texture7Pt5Percent = 36;
    ///<summary></summary>
    Texture12Pt5Percent = 37;
    ///<summary></summary>
    Texture15Percent = 38;
    ///<summary></summary>
    Texture17Pt5Percent = 39;
    ///<summary></summary>
    Texture22Pt5Percent = 40;
    ///<summary></summary>
    Texture27Pt5Percent = 41;
    ///<summary></summary>
    Texture32Pt5Percent = 42;
    ///<summary></summary>
    Texture35Percent = 43;
    ///<summary></summary>
    Texture37Pt5Percent = 44;
    ///<summary></summary>
    Texture42Pt5Percent = 45;
    ///<summary></summary>
    Texture45Percent = 46;
    ///<summary></summary>
    Texture47Pt5Percent = 47;
    ///<summary></summary>
    Texture52Pt5Percent = 48;
    ///<summary></summary>
    Texture55Percent = 49;
    ///<summary></summary>
    Texture57Pt5Percent = 50;
    ///<summary></summary>
    Texture62Pt5Percent = 51;
    ///<summary></summary>
    Texture65Percent = 52;
    ///<summary></summary>
    Texture67Pt5Percent = 53;
    ///<summary></summary>
    Texture72Pt5Percent = 54;
    ///<summary></summary>
    Texture77Pt5Percent = 55;
    ///<summary></summary>
    Texture82Pt5Percent = 56;
    ///<summary></summary>
    Texture85Percent = 57;
    ///<summary></summary>
    Texture87Pt5Percent = 58;
    ///<summary></summary>
    Texture92Pt5Percent = 59;
    ///<summary></summary>
    Texture95Percent = 60;
    ///<summary></summary>
    Texture97Pt5Percent = 61;
    ///<summary>
    ///  Specifies that there shall be no pattern used on the current shaded region
    ///  (i.e. the pattern shall be a complete fill with the background color).
    ///</summary>
    ///<dev>
    ///  Actually the Word does not renders shading with such pattern type i.e. shading is invisible (WORDSNET-17402).
    ///</dev>
    TextureNil = 65535;
  end;


  //-------------namespace: Aspose.Words.Themes----------------
  ///<summary>
  ///  Specifies the theme colors for document themes.
  ///</summary>
  ///<remarks>
  ///  The specified theme color is a reference to one of the predefined theme colors, located in the
  ///  document's Theme part, which allows color information to be set centrally in the document.
  ///</remarks>
  ///<dev>
  ///  The Color Scheme Color elements appear in a sequence.
  ///  See also https://docs.microsoft.com/en-us/office/vba/api/word.wdthemecolorindex
  ///</dev>
  [DNTypeName('Aspose.Words.Themes.ThemeColor')]
  DNThemeColor = type Integer;
  DNThemeColorHelper = record helper for DNThemeColor
  public const
    ///<summary>
    ///  Dark main color 1.
    ///</summary>
    Dark1 = 0;
    ///<summary>
    ///  Light main color 1.
    ///</summary>
    Light1 = 1;
    ///<summary>
    ///  Dark main color 2.
    ///</summary>
    Dark2 = 2;
    ///<summary>
    ///  Light main color 2.
    ///</summary>
    Light2 = 3;
    ///<summary>
    ///  Accent color 1.
    ///</summary>
    Accent1 = 4;
    ///<summary>
    ///  Accent color 2.
    ///</summary>
    Accent2 = 5;
    ///<summary>
    ///  Accent color 3.
    ///</summary>
    Accent3 = 6;
    ///<summary>
    ///  Accent color 4.
    ///</summary>
    Accent4 = 7;
    ///<summary>
    ///  Accent color 5.
    ///</summary>
    Accent5 = 8;
    ///<summary>
    ///  Accent color 6.
    ///</summary>
    Accent6 = 9;
    ///<summary>
    ///  Hyperlink color.
    ///</summary>
    Hyperlink = 10;
    ///<summary>
    ///  Followed hyperlink color.
    ///</summary>
    FollowedHyperlink = 11;
    ///<summary>
    ///  Text color 1.
    ///</summary>
    Text1 = 12;
    ///<summary>
    ///  Text color 2.
    ///</summary>
    Text2 = 13;
    ///<summary>
    ///  Background color 1.
    ///</summary>
    Background1 = 14;
    ///<summary>
    ///  Background color 2.
    ///</summary>
    Background2 = 15;
    ///<summary>
    ///  No color.
    ///</summary>
    None = -1;
  end;


  //-------------namespace: Aspose.Words.Themes----------------
  ///<summary>
  ///  Specifies the types of theme font names for document themes.
  ///</summary>
  ///<remarks>
  ///  Specifies a theme font type which can be referenced as a theme font within the parent object properties.
  ///  This theme font is a reference to one of the predefined theme fonts, located in the document's
  ///  Theme part, which allows for font information to be set centrally in the document.
  ///</remarks>
  ///<dev>
  ///  See https://docs.microsoft.com/en-us/office/vba/api/excel.font.themefont
  ///  and ISO29500 17.18.96 ST_Theme (Theme Font).
  ///</dev>
  [DNTypeName('Aspose.Words.Themes.ThemeFont')]
  DNThemeFont = type Integer;
  DNThemeFontHelper = record helper for DNThemeFont
  public const
    ///<summary>
    ///  No theme font.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Major theme font.
    ///</summary>
    Major = 1;
    ///<summary>
    ///  Minor theme font.
    ///</summary>
    Minor = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Indicates type of the underline applied to a font.
  ///</summary>
  [DNTypeName('Aspose.Words.Underline')]
  DNUnderline = type Integer;
  DNUnderlineHelper = record helper for DNUnderline
  public const
    ///<summary></summary>
    None = 0;
    ///<summary></summary>
    Single = 1;
    ///<summary></summary>
    Words = 2;
    ///<summary></summary>
    Double = 3;
    ///<summary></summary>
    Dotted = 4;
    ///<summary></summary>
    Thick = 6;
    ///<summary></summary>
    Dash = 7;
    ///<summary></summary>
    DotDash = 9;
    ///<summary></summary>
    DotDotDash = 10;
    ///<summary></summary>
    Wavy = 11;
    ///<summary></summary>
    DottedHeavy = 20;
    ///<summary></summary>
    DashHeavy = 23;
    ///<summary></summary>
    DotDashHeavy = 25;
    ///<summary></summary>
    DotDotDashHeavy = 26;
    ///<summary></summary>
    WavyHeavy = 27;
    ///<summary></summary>
    DashLong = 39;
    ///<summary></summary>
    WavyDouble = 43;
    ///<summary></summary>
    DashLongHeavy = 55;
  end;


  //-------------namespace: Aspose.Words.Vba----------------
  ///<summary>
  ///  Specifies the type of a model in a VBA project.
  ///</summary>
  [DNTypeName('Aspose.Words.Vba.VbaModuleType')]
  DNVbaModuleType = type Integer;
  DNVbaModuleTypeHelper = record helper for DNVbaModuleType
  public const
    ///<summary>
    ///  A type of VBA project item that specifies a module for embedded macros and programmatic access operations
    ///  that are associated with a document.
    ///</summary>
    DocumentModule = 0;
    ///<summary>
    ///  A collection of subroutines and functions.
    ///</summary>
    ProceduralModule = 1;
    ///<summary>
    ///  A module that contains the definition for a new object. Each instance of a class creates a new object,
    ///  and procedures that are defined in the module become properties and methods of the object.
    ///</summary>
    ClassModule = 2;
    ///<summary>
    ///  A VBA module that extends the methods and properties of an ActiveX control that has been registered with the project.
    ///</summary>
    DesignerModule = 3;
  end;


  //-------------namespace: Aspose.Words.Vba----------------
  ///<summary>
  ///  Allows to specify the type of a <see cref="T:Aspose.Words.Vba.VbaReference" />
  ///  object.
  ///</summary>
  [DNTypeName('Aspose.Words.Vba.VbaReferenceType')]
  DNVbaReferenceType = type Integer;
  DNVbaReferenceTypeHelper = record helper for DNVbaReferenceType
  public const
    ///<summary>
    ///  Specifies an Automation type library reference type.
    ///</summary>
    ///<remarks>
    ///  This type corresponds to 2.3.4.2.2.5 REFERENCEREGISTERED Record of [MS-OVBA]:
    ///  https://docs.microsoft.com/en-us/openspecs/office_file_formats/ms-ovba/6c39388e-96f5-4b93-b90a-ae625a063fcf
    ///</remarks>
    Registered = 13;
    ///<summary>
    ///  Specified an external VBA project reference type.
    ///</summary>
    ///<remarks>
    ///  This type corresponds to 2.3.4.2.2.6 REFERENCEPROJECT Record of [MS-OVBA]:
    ///  https://docs.microsoft.com/en-us/openspecs/office_file_formats/ms-ovba/08280eb0-d628-495c-867f-5985ed020142
    ///</remarks>
    Project = 14;
    ///<summary>
    ///  Specifies a twiddled type library reference type.
    ///</summary>
    ///<remarks>
    ///  This type corresponds to 2.3.4.2.2.3 REFERENCECONTROL Record of [MS-OVBA]:
    ///  https://docs.microsoft.com/en-us/openspecs/office_file_formats/ms-ovba/d64485fa-8562-4726-9c5e-11e8f01a81c0
    ///</remarks>
    Control = 47;
    ///<summary>
    ///  Specifies an original Automation type library reference type.
    ///</summary>
    ///<remarks>
    ///  This type corresponds to 2.3.4.2.2.4 REFERENCEORIGINAL Record of [MS-OVBA]:
    ///  https://docs.microsoft.com/en-us/openspecs/office_file_formats/ms-ovba/3ba66994-8c7a-4634-b2da-f9331ace6686
    ///</remarks>
    Original = 51;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Allows the visitor to control the enumeration of nodes.
  ///</summary>
  [DNTypeName('Aspose.Words.VisitorAction')]
  DNVisitorAction = type Integer;
  DNVisitorActionHelper = record helper for DNVisitorAction
  public const
    ///<summary>
    ///  The visitor requests the enumeration to continue.
    ///</summary>
    Continue_ = 0;
    ///<summary>
    ///  The visitor requests to skip the current node and continue enumeration.
    ///</summary>
    SkipThisNode = 1;
    ///<summary>
    ///  The visitor requests the enumeration of nodes to stop.
    ///</summary>
    Stop = 2;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the module that produces a warning during document loading or saving.
  ///</summary>
  [DNTypeName('Aspose.Words.WarningSource')]
  DNWarningSource = type Integer;
  DNWarningSourceHelper = record helper for DNWarningSource
  public const
    ///<summary>
    ///  The warning source is not specified.
    ///</summary>
    Unknown = 0;
    ///<summary>
    ///  Module that builds a document layout.
    ///</summary>
    Layout = 1;
    ///<summary>
    ///  Module that renders DrawingML shapes.
    ///</summary>
    DrawingML = 2;
    ///<summary>
    ///  Module that renders OfficeMath.
    ///</summary>
    OfficeMath = 3;
    ///<summary>
    ///  Module that renders ordinary shapes.
    ///</summary>
    Shapes = 4;
    ///<summary>
    ///  Module that renders metafiles.
    ///</summary>
    Metafile = 5;
    ///<summary>
    ///  Module that renders XPS.
    ///</summary>
    Xps = 6;
    ///<summary>
    ///  Module that renders PDF.
    ///</summary>
    Pdf = 7;
    ///<summary>
    ///  Module that renders images.
    ///</summary>
    Image = 8;
    ///<summary>
    ///  Module that reads/writes DOCX files.
    ///</summary>
    Docx = 9;
    ///<summary>
    ///  Module that reads/writes binary DOC files.
    ///</summary>
    Doc = 10;
    ///<summary>
    ///  Module that reads/writes plaintext files.
    ///</summary>
    Text = 11;
    ///<summary>
    ///  Module that reads/writes RTF files.
    ///</summary>
    Rtf = 12;
    ///<summary>
    ///  Module that reads/writes WML files.
    ///</summary>
    WordML = 13;
    ///<summary>
    ///  Common modules that are shared between DOCX/WML reader/writer modules.
    ///</summary>
    Nrx = 14;
    ///<summary>
    ///  Module that reads/writes ODT files.
    ///</summary>
    Odt = 15;
    ///<summary>
    ///  Module that reads/writes HTML/MHTML files.
    ///</summary>
    Html = 16;
    ///<summary>
    ///  Module that verifies model consistency and validity.
    ///</summary>
    Validator = 17;
    ///<summary>
    ///  Module that reads/writes Xaml files.
    ///</summary>
    Xaml = 18;
    ///<summary>
    ///  Module that reads Svm files.
    ///</summary>
    Svm = 19;
    ///<summary>
    ///  Module that reads W3C MathML files.
    ///</summary>
    MathML = 20;
    ///<summary>
    ///  Module that reads font files.
    ///</summary>
    Font = 21;
    ///<summary>
    ///  Module that reads SVG files.
    ///</summary>
    Svg = 22;
    ///<summary>
    ///  Module that reads/writes Markdown files.
    ///</summary>
    Markdown = 23;
    ///<summary>
    ///  Module that reads CHM files.
    ///</summary>
    Chm = 24;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the type of a warning that is issued by Aspose.Words during document loading or saving.
  ///</summary>
  [DNTypeName('Aspose.Words.WarningType')]
  DNWarningType = type Integer;
  DNWarningTypeHelper = record helper for DNWarningType
  public const
    ///<summary>
    ///  Generic data loss, no specific code.
    ///</summary>
    DataLoss = 1;
    ///<summary>
    ///  Some text/char/image or other data will be missing from either the document tree following load,
    ///  or from the created document following save.
    ///</summary>
    DataLossCategory = 255;
    ///<summary>
    ///  Generic major formatting loss, no specific code.
    ///</summary>
    MajorFormattingLoss = 256;
    ///<summary>
    ///  The resulting document or a particular location in it might look substantially different
    ///  compared to the original document.
    ///</summary>
    MajorFormattingLossCategory = 65280;
    ///<summary>
    ///  Generic minor formatting loss, no specific code.
    ///</summary>
    MinorFormattingLoss = 65536;
    ///<summary>
    ///  Font has been substituted.
    ///</summary>
    FontSubstitution = 131072;
    ///<summary>
    ///  Loss of embedded font information during document saving.
    ///</summary>
    FontEmbedding = 262144;
    ///<summary>
    ///  The resulting document or a particular location in it might look somewhat different compared
    ///  to the original document.
    ///</summary>
    MinorFormattingLossCategory = 16711680;
    ///<summary>
    ///  Generic unexpected content, no specific code.
    ///</summary>
    UnexpectedContent = 16777216;
    ///<summary>
    ///  Some content in the source document could not be recognized (i.e. is unsupported), this may or may not
    ///  cause issues or result in data/formatting loss.
    ///</summary>
    UnexpectedContentCategory = 251658240;
    ///<summary>
    ///  Advises of a potential problem or suggests an improvement.
    ///</summary>
    Hint = 268435456;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Defines layout of the watermark relative to the watermark center.
  ///</summary>
  [DNTypeName('Aspose.Words.WatermarkLayout')]
  DNWatermarkLayout = type Integer;
  DNWatermarkLayoutHelper = record helper for DNWatermarkLayout
  public const
    ///<summary>
    ///  Horizontal watermark layout. Corresponds to 0 degrees of rotation.
    ///</summary>
    Horizontal = 0;
    ///<summary>
    ///  Diagonal watermark layout. Corresponds to 315 degrees of rotation.
    ///</summary>
    Diagonal = 315;
  end;


  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Specifies the watermark type.
  ///</summary>
  [DNTypeName('Aspose.Words.WatermarkType')]
  DNWatermarkType = type Integer;
  DNWatermarkTypeHelper = record helper for DNWatermarkType
  public const
    ///<summary>
    ///  Indicates that the text will be used as a watermark.
    ///  <p>Such a watermark corresponds to a WordArt object.</p>
    ///</summary>
    Text = 0;
    ///<summary>
    ///  Indicates that the image will be used as a watermark.
    ///  <p>Such a watermark corresponds to a shape with image.</p>
    ///</summary>
    Image = 1;
    ///<summary>
    ///  Indicates watermark is no set.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Words.WebExtensions----------------
  ///<summary>
  ///  Enumerates available locations of task pane object.
  ///</summary>
  ///<dev>"top", "bottom", "fill" do not work. Add more available values upon request.</dev>
  [DNTypeName('Aspose.Words.WebExtensions.TaskPaneDockState')]
  DNTaskPaneDockState = type Integer;
  DNTaskPaneDockStateHelper = record helper for DNTaskPaneDockState
  public const
    ///<summary>
    ///  Dock the task pane on the right side of the document window.
    ///</summary>
    Right = 0;
    ///<summary>
    ///  Dock the task pane on the left side of the document window.
    ///</summary>
    Left = 1;
  end;


  //-------------namespace: Aspose.Words.WebExtensions----------------
  ///<summary>
  ///  Enumerates available types of binding between a web extension and the data in the document.
  ///</summary>
  ///<dev>https://docs.microsoft.com/en-us/javascript/api/office/office.bindingtype?view=office-js</dev>
  [DNTypeName('Aspose.Words.WebExtensions.WebExtensionBindingType')]
  DNWebExtensionBindingType = type Integer;
  DNWebExtensionBindingTypeHelper = record helper for DNWebExtensionBindingType
  public const
    Default_ = 0;
    ///<summary>
    ///  Tabular data without a header row.
    ///</summary>
    Matrix = 0;
    ///<summary>
    ///  Tabular data with a header row.
    ///</summary>
    Table = 1;
    ///<summary>
    ///  Plain text.
    ///</summary>
    Text = 2;
  end;


  //-------------namespace: Aspose.Words.WebExtensions----------------
  ///<summary>
  ///  Enumerates available types of a web extension store.
  ///</summary>
  [DNTypeName('Aspose.Words.WebExtensions.WebExtensionStoreType')]
  DNWebExtensionStoreType = type Integer;
  DNWebExtensionStoreTypeHelper = record helper for DNWebExtensionStoreType
  public const
    ///<summary>
    ///  Specifies that the store type is SharePoint corporate catalog.
    ///</summary>
    SPCatalog = 0;
    ///<summary>
    ///  Default value.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Specifies that the store type is Office.com.
    ///</summary>
    OMEX = 1;
    ///<summary>
    ///  Specifies that the store type is a SharePoint web application.
    ///</summary>
    SPApp = 2;
    ///<summary>
    ///  Specifies that the store type is an Exchange server.
    ///</summary>
    Exchange = 3;
    ///<summary>
    ///  Specifies that the store type is a file system share.
    ///</summary>
    FileSystem = 4;
    ///<summary>
    ///  Specifies that the store type is the system registry.
    ///</summary>
    Registry = 5;
    ///<summary>
    ///  Specifies that the store type is Centralized Deployment via Exchange.
    ///</summary>
    ExCatalog = 6;
  end;




type


{ declares }

  DNIChartDataPoint = interface; // type: Aspose.Words.Drawing.Charts.IChartDataPoint, namespace: Aspose.Words.Drawing.Charts
  DNIBarcodeGenerator = interface; // type: Aspose.Words.Fields.IBarcodeGenerator, namespace: Aspose.Words.Fields
  DNIComparisonExpressionEvaluator = interface; // type: Aspose.Words.Fields.IComparisonExpressionEvaluator, namespace: Aspose.Words.Fields
  DNIFieldResultFormatter = interface; // type: Aspose.Words.Fields.IFieldResultFormatter, namespace: Aspose.Words.Fields
  DNIFieldUpdateCultureProvider = interface; // type: Aspose.Words.Fields.IFieldUpdateCultureProvider, namespace: Aspose.Words.Fields
  DNIFieldUserPromptRespondent = interface; // type: Aspose.Words.Fields.IFieldUserPromptRespondent, namespace: Aspose.Words.Fields
  DNIDocumentReaderPlugin = interface; // type: Aspose.Words.IDocumentReaderPlugin, namespace: Aspose.Words
  DNIHyphenationCallback = interface; // type: Aspose.Words.IHyphenationCallback, namespace: Aspose.Words
  DNINodeChangingCallback = interface; // type: Aspose.Words.INodeChangingCallback, namespace: Aspose.Words
  DNIWarningCallback = interface; // type: Aspose.Words.IWarningCallback, namespace: Aspose.Words
  DNIPageLayoutCallback = interface; // type: Aspose.Words.Layout.IPageLayoutCallback, namespace: Aspose.Words.Layout
  DNIResourceLoadingCallback = interface; // type: Aspose.Words.Loading.IResourceLoadingCallback, namespace: Aspose.Words.Loading
  DNIFieldMergingCallback = interface; // type: Aspose.Words.MailMerging.IFieldMergingCallback, namespace: Aspose.Words.MailMerging
  DNIMailMergeCallback = interface; // type: Aspose.Words.MailMerging.IMailMergeCallback, namespace: Aspose.Words.MailMerging
  DNIMailMergeDataSource = interface; // type: Aspose.Words.MailMerging.IMailMergeDataSource, namespace: Aspose.Words.MailMerging
  DNIMailMergeDataSourceRoot = interface; // type: Aspose.Words.MailMerging.IMailMergeDataSourceRoot, namespace: Aspose.Words.MailMerging
  DNIReplacingCallback = interface; // type: Aspose.Words.Replacing.IReplacingCallback, namespace: Aspose.Words.Replacing
  DNICssSavingCallback = interface; // type: Aspose.Words.Saving.ICssSavingCallback, namespace: Aspose.Words.Saving
  DNIDocumentPartSavingCallback = interface; // type: Aspose.Words.Saving.IDocumentPartSavingCallback, namespace: Aspose.Words.Saving
  DNIFontSavingCallback = interface; // type: Aspose.Words.Saving.IFontSavingCallback, namespace: Aspose.Words.Saving
  DNIImageSavingCallback = interface; // type: Aspose.Words.Saving.IImageSavingCallback, namespace: Aspose.Words.Saving
  DNIPageSavingCallback = interface; // type: Aspose.Words.Saving.IPageSavingCallback, namespace: Aspose.Words.Saving
  DNIResourceSavingCallback = interface; // type: Aspose.Words.Saving.IResourceSavingCallback, namespace: Aspose.Words.Saving
  DNITextShaperFactory = interface; // type: Aspose.Words.Shaping.ITextShaperFactory, namespace: Aspose.Words.Shaping
  DNITextShaper = interface; // type: Aspose.Words.Shaping.ITextShaper, namespace: Aspose.Words.Shaping
  DNBookmark = interface; // type: Aspose.Words.Bookmark, namespace: Aspose.Words
  DNBookmarkCollection = interface; // type: Aspose.Words.BookmarkCollection, namespace: Aspose.Words
  DNBorderCollection = interface; // type: Aspose.Words.BorderCollection, namespace: Aspose.Words
  DNBuildVersionInfo = interface; // type: Aspose.Words.BuildVersionInfo, namespace: Aspose.Words
  DNCleanupOptions = interface; // type: Aspose.Words.CleanupOptions, namespace: Aspose.Words
  DNComHelper = interface; // type: Aspose.Words.ComHelper, namespace: Aspose.Words
  DNCompareOptions = interface; // type: Aspose.Words.Comparing.CompareOptions, namespace: Aspose.Words.Comparing
  DNConditionalStyle = interface; // type: Aspose.Words.ConditionalStyle, namespace: Aspose.Words
  DNConditionalStyleCollection = interface; // type: Aspose.Words.ConditionalStyleCollection, namespace: Aspose.Words
  DNControlChar = interface; // type: Aspose.Words.ControlChar, namespace: Aspose.Words
  DNConvertUtil = interface; // type: Aspose.Words.ConvertUtil, namespace: Aspose.Words
  DNCertificateHolder = interface; // type: Aspose.Words.DigitalSignatures.CertificateHolder, namespace: Aspose.Words.DigitalSignatures
  DNDigitalSignature = interface; // type: Aspose.Words.DigitalSignatures.DigitalSignature, namespace: Aspose.Words.DigitalSignatures
  DNDigitalSignatureCollection = interface; // type: Aspose.Words.DigitalSignatures.DigitalSignatureCollection, namespace: Aspose.Words.DigitalSignatures
  DNDigitalSignatureUtil = interface; // type: Aspose.Words.DigitalSignatures.DigitalSignatureUtil, namespace: Aspose.Words.DigitalSignatures
  DNSignOptions = interface; // type: Aspose.Words.DigitalSignatures.SignOptions, namespace: Aspose.Words.DigitalSignatures
  DNDocumentBuilder = interface; // type: Aspose.Words.DocumentBuilder, namespace: Aspose.Words
  DNDocumentVisitor = interface; // type: Aspose.Words.DocumentVisitor, namespace: Aspose.Words
  DNAxisBound = interface; // type: Aspose.Words.Drawing.Charts.AxisBound, namespace: Aspose.Words.Drawing.Charts
  DNAxisDisplayUnit = interface; // type: Aspose.Words.Drawing.Charts.AxisDisplayUnit, namespace: Aspose.Words.Drawing.Charts
  DNAxisScaling = interface; // type: Aspose.Words.Drawing.Charts.AxisScaling, namespace: Aspose.Words.Drawing.Charts
  DNChart = interface; // type: Aspose.Words.Drawing.Charts.Chart, namespace: Aspose.Words.Drawing.Charts
  DNChartAxis = interface; // type: Aspose.Words.Drawing.Charts.ChartAxis, namespace: Aspose.Words.Drawing.Charts
  DNChartDataLabel = interface; // type: Aspose.Words.Drawing.Charts.ChartDataLabel, namespace: Aspose.Words.Drawing.Charts
  DNChartDataLabelCollection = interface; // type: Aspose.Words.Drawing.Charts.ChartDataLabelCollection, namespace: Aspose.Words.Drawing.Charts
  DNChartDataPoint = interface; // type: Aspose.Words.Drawing.Charts.ChartDataPoint, namespace: Aspose.Words.Drawing.Charts
  DNChartDataPointCollection = interface; // type: Aspose.Words.Drawing.Charts.ChartDataPointCollection, namespace: Aspose.Words.Drawing.Charts
  DNChartFormat = interface; // type: Aspose.Words.Drawing.Charts.ChartFormat, namespace: Aspose.Words.Drawing.Charts
  DNChartLegend = interface; // type: Aspose.Words.Drawing.Charts.ChartLegend, namespace: Aspose.Words.Drawing.Charts
  DNChartMarker = interface; // type: Aspose.Words.Drawing.Charts.ChartMarker, namespace: Aspose.Words.Drawing.Charts
  DNChartNumberFormat = interface; // type: Aspose.Words.Drawing.Charts.ChartNumberFormat, namespace: Aspose.Words.Drawing.Charts
  DNChartSeries = interface; // type: Aspose.Words.Drawing.Charts.ChartSeries, namespace: Aspose.Words.Drawing.Charts
  DNChartSeriesCollection = interface; // type: Aspose.Words.Drawing.Charts.ChartSeriesCollection, namespace: Aspose.Words.Drawing.Charts
  DNChartTitle = interface; // type: Aspose.Words.Drawing.Charts.ChartTitle, namespace: Aspose.Words.Drawing.Charts
  DNFill = interface; // type: Aspose.Words.Drawing.Fill, namespace: Aspose.Words.Drawing
  DNHorizontalRuleFormat = interface; // type: Aspose.Words.Drawing.HorizontalRuleFormat, namespace: Aspose.Words.Drawing
  DNImageData = interface; // type: Aspose.Words.Drawing.ImageData, namespace: Aspose.Words.Drawing
  DNImageSize = interface; // type: Aspose.Words.Drawing.ImageSize, namespace: Aspose.Words.Drawing
  DNForms2OleControlCollection = interface; // type: Aspose.Words.Drawing.Ole.Forms2OleControlCollection, namespace: Aspose.Words.Drawing.Ole
  DNOleControl = interface; // type: Aspose.Words.Drawing.Ole.OleControl, namespace: Aspose.Words.Drawing.Ole
  DNForms2OleControl = interface; // type: Aspose.Words.Drawing.Ole.Forms2OleControl, namespace: Aspose.Words.Drawing.Ole
  DNOleFormat = interface; // type: Aspose.Words.Drawing.OleFormat, namespace: Aspose.Words.Drawing
  DNOlePackage = interface; // type: Aspose.Words.Drawing.OlePackage, namespace: Aspose.Words.Drawing
  DNSignatureLine = interface; // type: Aspose.Words.Drawing.SignatureLine, namespace: Aspose.Words.Drawing
  DNStroke = interface; // type: Aspose.Words.Drawing.Stroke, namespace: Aspose.Words.Drawing
  DNTextBox = interface; // type: Aspose.Words.Drawing.TextBox, namespace: Aspose.Words.Drawing
  DNTextPath = interface; // type: Aspose.Words.Drawing.TextPath, namespace: Aspose.Words.Drawing
  DNEditableRange = interface; // type: Aspose.Words.EditableRange, namespace: Aspose.Words
  DNBarcodeParameters = interface; // type: Aspose.Words.Fields.BarcodeParameters, namespace: Aspose.Words.Fields
  DNComparisonEvaluationResult = interface; // type: Aspose.Words.Fields.ComparisonEvaluationResult, namespace: Aspose.Words.Fields
  DNComparisonExpression = interface; // type: Aspose.Words.Fields.ComparisonExpression, namespace: Aspose.Words.Fields
  DNDropDownItemCollection = interface; // type: Aspose.Words.Fields.DropDownItemCollection, namespace: Aspose.Words.Fields
  DNField = interface; // type: Aspose.Words.Fields.Field, namespace: Aspose.Words.Fields
  DNFieldAddIn = interface; // type: Aspose.Words.Fields.FieldAddIn, namespace: Aspose.Words.Fields
  DNFieldAddressBlock = interface; // type: Aspose.Words.Fields.FieldAddressBlock, namespace: Aspose.Words.Fields
  DNFieldAdvance = interface; // type: Aspose.Words.Fields.FieldAdvance, namespace: Aspose.Words.Fields
  DNFieldAsk = interface; // type: Aspose.Words.Fields.FieldAsk, namespace: Aspose.Words.Fields
  DNFieldAuthor = interface; // type: Aspose.Words.Fields.FieldAuthor, namespace: Aspose.Words.Fields
  DNFieldAutoNum = interface; // type: Aspose.Words.Fields.FieldAutoNum, namespace: Aspose.Words.Fields
  DNFieldAutoNumLgl = interface; // type: Aspose.Words.Fields.FieldAutoNumLgl, namespace: Aspose.Words.Fields
  DNFieldAutoNumOut = interface; // type: Aspose.Words.Fields.FieldAutoNumOut, namespace: Aspose.Words.Fields
  DNFieldAutoText = interface; // type: Aspose.Words.Fields.FieldAutoText, namespace: Aspose.Words.Fields
  DNFieldAutoTextList = interface; // type: Aspose.Words.Fields.FieldAutoTextList, namespace: Aspose.Words.Fields
  DNFieldBarcode = interface; // type: Aspose.Words.Fields.FieldBarcode, namespace: Aspose.Words.Fields
  DNFieldBibliography = interface; // type: Aspose.Words.Fields.FieldBibliography, namespace: Aspose.Words.Fields
  DNFieldBidiOutline = interface; // type: Aspose.Words.Fields.FieldBidiOutline, namespace: Aspose.Words.Fields
  DNFieldCitation = interface; // type: Aspose.Words.Fields.FieldCitation, namespace: Aspose.Words.Fields
  DNFieldComments = interface; // type: Aspose.Words.Fields.FieldComments, namespace: Aspose.Words.Fields
  DNFieldCompare = interface; // type: Aspose.Words.Fields.FieldCompare, namespace: Aspose.Words.Fields
  DNFieldCreateDate = interface; // type: Aspose.Words.Fields.FieldCreateDate, namespace: Aspose.Words.Fields
  DNFieldData = interface; // type: Aspose.Words.Fields.FieldData, namespace: Aspose.Words.Fields
  DNFieldDatabase = interface; // type: Aspose.Words.Fields.FieldDatabase, namespace: Aspose.Words.Fields
  DNFieldDate = interface; // type: Aspose.Words.Fields.FieldDate, namespace: Aspose.Words.Fields
  DNFieldDde = interface; // type: Aspose.Words.Fields.FieldDde, namespace: Aspose.Words.Fields
  DNFieldDdeAuto = interface; // type: Aspose.Words.Fields.FieldDdeAuto, namespace: Aspose.Words.Fields
  DNFieldDisplayBarcode = interface; // type: Aspose.Words.Fields.FieldDisplayBarcode, namespace: Aspose.Words.Fields
  DNFieldDocProperty = interface; // type: Aspose.Words.Fields.FieldDocProperty, namespace: Aspose.Words.Fields
  DNFieldDocVariable = interface; // type: Aspose.Words.Fields.FieldDocVariable, namespace: Aspose.Words.Fields
  DNFieldEditTime = interface; // type: Aspose.Words.Fields.FieldEditTime, namespace: Aspose.Words.Fields
  DNFieldEmbed = interface; // type: Aspose.Words.Fields.FieldEmbed, namespace: Aspose.Words.Fields
  DNFieldEQ = interface; // type: Aspose.Words.Fields.FieldEQ, namespace: Aspose.Words.Fields
  DNFieldFileName = interface; // type: Aspose.Words.Fields.FieldFileName, namespace: Aspose.Words.Fields
  DNFieldFileSize = interface; // type: Aspose.Words.Fields.FieldFileSize, namespace: Aspose.Words.Fields
  DNFieldFillIn = interface; // type: Aspose.Words.Fields.FieldFillIn, namespace: Aspose.Words.Fields
  DNFieldFootnoteRef = interface; // type: Aspose.Words.Fields.FieldFootnoteRef, namespace: Aspose.Words.Fields
  DNFieldFormCheckBox = interface; // type: Aspose.Words.Fields.FieldFormCheckBox, namespace: Aspose.Words.Fields
  DNFieldFormDropDown = interface; // type: Aspose.Words.Fields.FieldFormDropDown, namespace: Aspose.Words.Fields
  DNFieldFormText = interface; // type: Aspose.Words.Fields.FieldFormText, namespace: Aspose.Words.Fields
  DNFieldFormula = interface; // type: Aspose.Words.Fields.FieldFormula, namespace: Aspose.Words.Fields
  DNFieldGlossary = interface; // type: Aspose.Words.Fields.FieldGlossary, namespace: Aspose.Words.Fields
  DNFieldGoToButton = interface; // type: Aspose.Words.Fields.FieldGoToButton, namespace: Aspose.Words.Fields
  DNFieldGreetingLine = interface; // type: Aspose.Words.Fields.FieldGreetingLine, namespace: Aspose.Words.Fields
  DNFieldHyperlink = interface; // type: Aspose.Words.Fields.FieldHyperlink, namespace: Aspose.Words.Fields
  DNFieldIf = interface; // type: Aspose.Words.Fields.FieldIf, namespace: Aspose.Words.Fields
  DNFieldImport = interface; // type: Aspose.Words.Fields.FieldImport, namespace: Aspose.Words.Fields
  DNFieldInclude = interface; // type: Aspose.Words.Fields.FieldInclude, namespace: Aspose.Words.Fields
  DNFieldIncludePicture = interface; // type: Aspose.Words.Fields.FieldIncludePicture, namespace: Aspose.Words.Fields
  DNFieldIncludeText = interface; // type: Aspose.Words.Fields.FieldIncludeText, namespace: Aspose.Words.Fields
  DNFieldIndex = interface; // type: Aspose.Words.Fields.FieldIndex, namespace: Aspose.Words.Fields
  DNFieldInfo = interface; // type: Aspose.Words.Fields.FieldInfo, namespace: Aspose.Words.Fields
  DNFieldKeywords = interface; // type: Aspose.Words.Fields.FieldKeywords, namespace: Aspose.Words.Fields
  DNFieldLastSavedBy = interface; // type: Aspose.Words.Fields.FieldLastSavedBy, namespace: Aspose.Words.Fields
  DNFieldLink = interface; // type: Aspose.Words.Fields.FieldLink, namespace: Aspose.Words.Fields
  DNFieldListNum = interface; // type: Aspose.Words.Fields.FieldListNum, namespace: Aspose.Words.Fields
  DNFieldMacroButton = interface; // type: Aspose.Words.Fields.FieldMacroButton, namespace: Aspose.Words.Fields
  DNFieldMergeBarcode = interface; // type: Aspose.Words.Fields.FieldMergeBarcode, namespace: Aspose.Words.Fields
  DNFieldMergeField = interface; // type: Aspose.Words.Fields.FieldMergeField, namespace: Aspose.Words.Fields
  DNFieldMergeRec = interface; // type: Aspose.Words.Fields.FieldMergeRec, namespace: Aspose.Words.Fields
  DNFieldMergeSeq = interface; // type: Aspose.Words.Fields.FieldMergeSeq, namespace: Aspose.Words.Fields
  DNFieldNext = interface; // type: Aspose.Words.Fields.FieldNext, namespace: Aspose.Words.Fields
  DNFieldNextIf = interface; // type: Aspose.Words.Fields.FieldNextIf, namespace: Aspose.Words.Fields
  DNFieldNoteRef = interface; // type: Aspose.Words.Fields.FieldNoteRef, namespace: Aspose.Words.Fields
  DNFieldNumChars = interface; // type: Aspose.Words.Fields.FieldNumChars, namespace: Aspose.Words.Fields
  DNFieldNumPages = interface; // type: Aspose.Words.Fields.FieldNumPages, namespace: Aspose.Words.Fields
  DNFieldNumWords = interface; // type: Aspose.Words.Fields.FieldNumWords, namespace: Aspose.Words.Fields
  DNFieldOcx = interface; // type: Aspose.Words.Fields.FieldOcx, namespace: Aspose.Words.Fields
  DNFieldPage = interface; // type: Aspose.Words.Fields.FieldPage, namespace: Aspose.Words.Fields
  DNFieldPageRef = interface; // type: Aspose.Words.Fields.FieldPageRef, namespace: Aspose.Words.Fields
  DNFieldPrint = interface; // type: Aspose.Words.Fields.FieldPrint, namespace: Aspose.Words.Fields
  DNFieldPrintDate = interface; // type: Aspose.Words.Fields.FieldPrintDate, namespace: Aspose.Words.Fields
  DNFieldPrivate = interface; // type: Aspose.Words.Fields.FieldPrivate, namespace: Aspose.Words.Fields
  DNFieldQuote = interface; // type: Aspose.Words.Fields.FieldQuote, namespace: Aspose.Words.Fields
  DNFieldRD = interface; // type: Aspose.Words.Fields.FieldRD, namespace: Aspose.Words.Fields
  DNFieldRef = interface; // type: Aspose.Words.Fields.FieldRef, namespace: Aspose.Words.Fields
  DNFieldRevNum = interface; // type: Aspose.Words.Fields.FieldRevNum, namespace: Aspose.Words.Fields
  DNFieldSaveDate = interface; // type: Aspose.Words.Fields.FieldSaveDate, namespace: Aspose.Words.Fields
  DNFieldSection = interface; // type: Aspose.Words.Fields.FieldSection, namespace: Aspose.Words.Fields
  DNFieldSectionPages = interface; // type: Aspose.Words.Fields.FieldSectionPages, namespace: Aspose.Words.Fields
  DNFieldSeq = interface; // type: Aspose.Words.Fields.FieldSeq, namespace: Aspose.Words.Fields
  DNFieldSet = interface; // type: Aspose.Words.Fields.FieldSet, namespace: Aspose.Words.Fields
  DNFieldShape = interface; // type: Aspose.Words.Fields.FieldShape, namespace: Aspose.Words.Fields
  DNFieldSkipIf = interface; // type: Aspose.Words.Fields.FieldSkipIf, namespace: Aspose.Words.Fields
  DNFieldStyleRef = interface; // type: Aspose.Words.Fields.FieldStyleRef, namespace: Aspose.Words.Fields
  DNFieldSubject = interface; // type: Aspose.Words.Fields.FieldSubject, namespace: Aspose.Words.Fields
  DNFieldSymbol = interface; // type: Aspose.Words.Fields.FieldSymbol, namespace: Aspose.Words.Fields
  DNFieldTA = interface; // type: Aspose.Words.Fields.FieldTA, namespace: Aspose.Words.Fields
  DNFieldTC = interface; // type: Aspose.Words.Fields.FieldTC, namespace: Aspose.Words.Fields
  DNFieldTemplate = interface; // type: Aspose.Words.Fields.FieldTemplate, namespace: Aspose.Words.Fields
  DNFieldTime = interface; // type: Aspose.Words.Fields.FieldTime, namespace: Aspose.Words.Fields
  DNFieldTitle = interface; // type: Aspose.Words.Fields.FieldTitle, namespace: Aspose.Words.Fields
  DNFieldToa = interface; // type: Aspose.Words.Fields.FieldToa, namespace: Aspose.Words.Fields
  DNFieldToc = interface; // type: Aspose.Words.Fields.FieldToc, namespace: Aspose.Words.Fields
  DNFieldUnknown = interface; // type: Aspose.Words.Fields.FieldUnknown, namespace: Aspose.Words.Fields
  DNFieldUserAddress = interface; // type: Aspose.Words.Fields.FieldUserAddress, namespace: Aspose.Words.Fields
  DNFieldUserInitials = interface; // type: Aspose.Words.Fields.FieldUserInitials, namespace: Aspose.Words.Fields
  DNFieldUserName = interface; // type: Aspose.Words.Fields.FieldUserName, namespace: Aspose.Words.Fields
  DNFieldXE = interface; // type: Aspose.Words.Fields.FieldXE, namespace: Aspose.Words.Fields
  DNFieldArgumentBuilder = interface; // type: Aspose.Words.Fields.FieldArgumentBuilder, namespace: Aspose.Words.Fields
  DNFieldBuilder = interface; // type: Aspose.Words.Fields.FieldBuilder, namespace: Aspose.Words.Fields
  DNFieldCollection = interface; // type: Aspose.Words.Fields.FieldCollection, namespace: Aspose.Words.Fields
  DNFieldFormat = interface; // type: Aspose.Words.Fields.FieldFormat, namespace: Aspose.Words.Fields
  DNFieldOptions = interface; // type: Aspose.Words.Fields.FieldOptions, namespace: Aspose.Words.Fields
  DNFormFieldCollection = interface; // type: Aspose.Words.Fields.FormFieldCollection, namespace: Aspose.Words.Fields
  DNGeneralFormatCollection = interface; // type: Aspose.Words.Fields.GeneralFormatCollection, namespace: Aspose.Words.Fields
  DNMergeFieldImageDimension = interface; // type: Aspose.Words.Fields.MergeFieldImageDimension, namespace: Aspose.Words.Fields
  DNToaCategories = interface; // type: Aspose.Words.Fields.ToaCategories, namespace: Aspose.Words.Fields
  DNUserInformation = interface; // type: Aspose.Words.Fields.UserInformation, namespace: Aspose.Words.Fields
  DNFileFormatInfo = interface; // type: Aspose.Words.FileFormatInfo, namespace: Aspose.Words
  DNFileFormatUtil = interface; // type: Aspose.Words.FileFormatUtil, namespace: Aspose.Words
  DNFont = interface; // type: Aspose.Words.Font, namespace: Aspose.Words
  DNFontFallbackSettings = interface; // type: Aspose.Words.Fonts.FontFallbackSettings, namespace: Aspose.Words.Fonts
  DNFontInfo = interface; // type: Aspose.Words.Fonts.FontInfo, namespace: Aspose.Words.Fonts
  DNFontInfoCollection = interface; // type: Aspose.Words.Fonts.FontInfoCollection, namespace: Aspose.Words.Fonts
  DNFontSettings = interface; // type: Aspose.Words.Fonts.FontSettings, namespace: Aspose.Words.Fonts
  DNFontSourceBase = interface; // type: Aspose.Words.Fonts.FontSourceBase, namespace: Aspose.Words.Fonts
  DNFileFontSource = interface; // type: Aspose.Words.Fonts.FileFontSource, namespace: Aspose.Words.Fonts
  DNFolderFontSource = interface; // type: Aspose.Words.Fonts.FolderFontSource, namespace: Aspose.Words.Fonts
  DNMemoryFontSource = interface; // type: Aspose.Words.Fonts.MemoryFontSource, namespace: Aspose.Words.Fonts
  DNStreamFontSource = interface; // type: Aspose.Words.Fonts.StreamFontSource, namespace: Aspose.Words.Fonts
  DNSystemFontSource = interface; // type: Aspose.Words.Fonts.SystemFontSource, namespace: Aspose.Words.Fonts
  DNFontSubstitutionRule = interface; // type: Aspose.Words.Fonts.FontSubstitutionRule, namespace: Aspose.Words.Fonts
  DNDefaultFontSubstitutionRule = interface; // type: Aspose.Words.Fonts.DefaultFontSubstitutionRule, namespace: Aspose.Words.Fonts
  DNFontConfigSubstitutionRule = interface; // type: Aspose.Words.Fonts.FontConfigSubstitutionRule, namespace: Aspose.Words.Fonts
  DNFontInfoSubstitutionRule = interface; // type: Aspose.Words.Fonts.FontInfoSubstitutionRule, namespace: Aspose.Words.Fonts
  DNFontNameSubstitutionRule = interface; // type: Aspose.Words.Fonts.FontNameSubstitutionRule, namespace: Aspose.Words.Fonts
  DNTableSubstitutionRule = interface; // type: Aspose.Words.Fonts.TableSubstitutionRule, namespace: Aspose.Words.Fonts
  DNFontSubstitutionSettings = interface; // type: Aspose.Words.Fonts.FontSubstitutionSettings, namespace: Aspose.Words.Fonts
  DNPhysicalFontInfo = interface; // type: Aspose.Words.Fonts.PhysicalFontInfo, namespace: Aspose.Words.Fonts
  DNFrameFormat = interface; // type: Aspose.Words.FrameFormat, namespace: Aspose.Words
  DNHyphenation = interface; // type: Aspose.Words.Hyphenation, namespace: Aspose.Words
  DNImageWatermarkOptions = interface; // type: Aspose.Words.ImageWatermarkOptions, namespace: Aspose.Words
  DNImportFormatOptions = interface; // type: Aspose.Words.ImportFormatOptions, namespace: Aspose.Words
  DNInternableComplexAttr = interface; // type: Aspose.Words.InternableComplexAttr, namespace: Aspose.Words
  DNBorder = interface; // type: Aspose.Words.Border, namespace: Aspose.Words
  DNShading = interface; // type: Aspose.Words.Shading, namespace: Aspose.Words
  DNTabStopCollection = interface; // type: Aspose.Words.TabStopCollection, namespace: Aspose.Words
  DNInterruptionToken = interface; // type: Aspose.Words.InterruptionToken, namespace: Aspose.Words
  DNLayoutCollector = interface; // type: Aspose.Words.Layout.LayoutCollector, namespace: Aspose.Words.Layout
  DNLayoutEnumerator = interface; // type: Aspose.Words.Layout.LayoutEnumerator, namespace: Aspose.Words.Layout
  DNLayoutOptions = interface; // type: Aspose.Words.Layout.LayoutOptions, namespace: Aspose.Words.Layout
  DNPageLayoutCallbackArgs = interface; // type: Aspose.Words.Layout.PageLayoutCallbackArgs, namespace: Aspose.Words.Layout
  DNRevisionOptions = interface; // type: Aspose.Words.Layout.RevisionOptions, namespace: Aspose.Words.Layout
  DNLicense = interface; // type: Aspose.Words.License, namespace: Aspose.Words
  DNList = interface; // type: Aspose.Words.Lists.List, namespace: Aspose.Words.Lists
  DNListCollection = interface; // type: Aspose.Words.Lists.ListCollection, namespace: Aspose.Words.Lists
  DNListFormat = interface; // type: Aspose.Words.Lists.ListFormat, namespace: Aspose.Words.Lists
  DNListLabel = interface; // type: Aspose.Words.Lists.ListLabel, namespace: Aspose.Words.Lists
  DNListLevel = interface; // type: Aspose.Words.Lists.ListLevel, namespace: Aspose.Words.Lists
  DNListLevelCollection = interface; // type: Aspose.Words.Lists.ListLevelCollection, namespace: Aspose.Words.Lists
  DNLanguagePreferences = interface; // type: Aspose.Words.Loading.LanguagePreferences, namespace: Aspose.Words.Loading
  DNLoadOptions = interface; // type: Aspose.Words.Loading.LoadOptions, namespace: Aspose.Words.Loading
  DNHtmlLoadOptions = interface; // type: Aspose.Words.Loading.HtmlLoadOptions, namespace: Aspose.Words.Loading
  DNPdfLoadOptions = interface; // type: Aspose.Words.Loading.PdfLoadOptions, namespace: Aspose.Words.Loading
  DNRtfLoadOptions = interface; // type: Aspose.Words.Loading.RtfLoadOptions, namespace: Aspose.Words.Loading
  DNTxtLoadOptions = interface; // type: Aspose.Words.Loading.TxtLoadOptions, namespace: Aspose.Words.Loading
  DNResourceLoadingArgs = interface; // type: Aspose.Words.Loading.ResourceLoadingArgs, namespace: Aspose.Words.Loading
  DNFieldMergingArgsBase = interface; // type: Aspose.Words.MailMerging.FieldMergingArgsBase, namespace: Aspose.Words.MailMerging
  DNFieldMergingArgs = interface; // type: Aspose.Words.MailMerging.FieldMergingArgs, namespace: Aspose.Words.MailMerging
  DNImageFieldMergingArgs = interface; // type: Aspose.Words.MailMerging.ImageFieldMergingArgs, namespace: Aspose.Words.MailMerging
  DNMailMerge = interface; // type: Aspose.Words.MailMerging.MailMerge, namespace: Aspose.Words.MailMerging
  DNMailMergeRegionInfo = interface; // type: Aspose.Words.MailMerging.MailMergeRegionInfo, namespace: Aspose.Words.MailMerging
  DNMappedDataFieldCollection = interface; // type: Aspose.Words.MailMerging.MappedDataFieldCollection, namespace: Aspose.Words.MailMerging
  DNCustomPart = interface; // type: Aspose.Words.Markup.CustomPart, namespace: Aspose.Words.Markup
  DNCustomPartCollection = interface; // type: Aspose.Words.Markup.CustomPartCollection, namespace: Aspose.Words.Markup
  DNCustomXmlPart = interface; // type: Aspose.Words.Markup.CustomXmlPart, namespace: Aspose.Words.Markup
  DNCustomXmlPartCollection = interface; // type: Aspose.Words.Markup.CustomXmlPartCollection, namespace: Aspose.Words.Markup
  DNCustomXmlProperty = interface; // type: Aspose.Words.Markup.CustomXmlProperty, namespace: Aspose.Words.Markup
  DNCustomXmlPropertyCollection = interface; // type: Aspose.Words.Markup.CustomXmlPropertyCollection, namespace: Aspose.Words.Markup
  DNCustomXmlSchemaCollection = interface; // type: Aspose.Words.Markup.CustomXmlSchemaCollection, namespace: Aspose.Words.Markup
  DNSdtListItem = interface; // type: Aspose.Words.Markup.SdtListItem, namespace: Aspose.Words.Markup
  DNSdtListItemCollection = interface; // type: Aspose.Words.Markup.SdtListItemCollection, namespace: Aspose.Words.Markup
  DNXmlMapping = interface; // type: Aspose.Words.Markup.XmlMapping, namespace: Aspose.Words.Markup
  DNMetered = interface; // type: Aspose.Words.Metered, namespace: Aspose.Words
  DNNode = interface; // type: Aspose.Words.Node, namespace: Aspose.Words
  DNBookmarkEnd = interface; // type: Aspose.Words.BookmarkEnd, namespace: Aspose.Words
  DNBookmarkStart = interface; // type: Aspose.Words.BookmarkStart, namespace: Aspose.Words
  DNCommentRangeEnd = interface; // type: Aspose.Words.CommentRangeEnd, namespace: Aspose.Words
  DNCommentRangeStart = interface; // type: Aspose.Words.CommentRangeStart, namespace: Aspose.Words
  DNCompositeNode = interface; // type: Aspose.Words.CompositeNode, namespace: Aspose.Words
  DNBuildingBlock = interface; // type: Aspose.Words.BuildingBlocks.BuildingBlock, namespace: Aspose.Words.BuildingBlocks
  DNDocumentBase = interface; // type: Aspose.Words.DocumentBase, namespace: Aspose.Words
  DNGlossaryDocument = interface; // type: Aspose.Words.BuildingBlocks.GlossaryDocument, namespace: Aspose.Words.BuildingBlocks
  DNDocument = interface; // type: Aspose.Words.Document, namespace: Aspose.Words
  DNShapeBase = interface; // type: Aspose.Words.Drawing.ShapeBase, namespace: Aspose.Words.Drawing
  DNGroupShape = interface; // type: Aspose.Words.Drawing.GroupShape, namespace: Aspose.Words.Drawing
  DNShape = interface; // type: Aspose.Words.Drawing.Shape, namespace: Aspose.Words.Drawing
  DNInlineStory = interface; // type: Aspose.Words.InlineStory, namespace: Aspose.Words
  DNComment = interface; // type: Aspose.Words.Comment, namespace: Aspose.Words
  DNFootnote = interface; // type: Aspose.Words.Notes.Footnote, namespace: Aspose.Words.Notes
  DNSmartTag = interface; // type: Aspose.Words.Markup.SmartTag, namespace: Aspose.Words.Markup
  DNStructuredDocumentTag = interface; // type: Aspose.Words.Markup.StructuredDocumentTag, namespace: Aspose.Words.Markup
  DNOfficeMath = interface; // type: Aspose.Words.Math.OfficeMath, namespace: Aspose.Words.Math
  DNParagraph = interface; // type: Aspose.Words.Paragraph, namespace: Aspose.Words
  DNSection = interface; // type: Aspose.Words.Section, namespace: Aspose.Words
  DNStory = interface; // type: Aspose.Words.Story, namespace: Aspose.Words
  DNBody = interface; // type: Aspose.Words.Body, namespace: Aspose.Words
  DNHeaderFooter = interface; // type: Aspose.Words.HeaderFooter, namespace: Aspose.Words
  DNCell = interface; // type: Aspose.Words.Tables.Cell, namespace: Aspose.Words.Tables
  DNRow = interface; // type: Aspose.Words.Tables.Row, namespace: Aspose.Words.Tables
  DNTable = interface; // type: Aspose.Words.Tables.Table, namespace: Aspose.Words.Tables
  DNEditableRangeEnd = interface; // type: Aspose.Words.EditableRangeEnd, namespace: Aspose.Words
  DNEditableRangeStart = interface; // type: Aspose.Words.EditableRangeStart, namespace: Aspose.Words
  DNInline = interface; // type: Aspose.Words.Inline, namespace: Aspose.Words
  DNRun = interface; // type: Aspose.Words.Run, namespace: Aspose.Words
  DNSpecialChar = interface; // type: Aspose.Words.SpecialChar, namespace: Aspose.Words
  DNAbsolutePositionTab = interface; // type: Aspose.Words.AbsolutePositionTab, namespace: Aspose.Words
  DNFieldChar = interface; // type: Aspose.Words.Fields.FieldChar, namespace: Aspose.Words.Fields
  DNFieldEnd = interface; // type: Aspose.Words.Fields.FieldEnd, namespace: Aspose.Words.Fields
  DNFieldSeparator = interface; // type: Aspose.Words.Fields.FieldSeparator, namespace: Aspose.Words.Fields
  DNFieldStart = interface; // type: Aspose.Words.Fields.FieldStart, namespace: Aspose.Words.Fields
  DNFormField = interface; // type: Aspose.Words.Fields.FormField, namespace: Aspose.Words.Fields
  DNStructuredDocumentTagRangeEnd = interface; // type: Aspose.Words.Markup.StructuredDocumentTagRangeEnd, namespace: Aspose.Words.Markup
  DNStructuredDocumentTagRangeStart = interface; // type: Aspose.Words.Markup.StructuredDocumentTagRangeStart, namespace: Aspose.Words.Markup
  DNSubDocument = interface; // type: Aspose.Words.SubDocument, namespace: Aspose.Words
  DNNodeChangingArgs = interface; // type: Aspose.Words.NodeChangingArgs, namespace: Aspose.Words
  DNNodeCollection = interface; // type: Aspose.Words.NodeCollection, namespace: Aspose.Words
  DNBuildingBlockCollection = interface; // type: Aspose.Words.BuildingBlocks.BuildingBlockCollection, namespace: Aspose.Words.BuildingBlocks
  DNCommentCollection = interface; // type: Aspose.Words.CommentCollection, namespace: Aspose.Words
  DNHeaderFooterCollection = interface; // type: Aspose.Words.HeaderFooterCollection, namespace: Aspose.Words
  DNParagraphCollection = interface; // type: Aspose.Words.ParagraphCollection, namespace: Aspose.Words
  DNRunCollection = interface; // type: Aspose.Words.RunCollection, namespace: Aspose.Words
  DNSectionCollection = interface; // type: Aspose.Words.SectionCollection, namespace: Aspose.Words
  DNCellCollection = interface; // type: Aspose.Words.Tables.CellCollection, namespace: Aspose.Words.Tables
  DNRowCollection = interface; // type: Aspose.Words.Tables.RowCollection, namespace: Aspose.Words.Tables
  DNTableCollection = interface; // type: Aspose.Words.Tables.TableCollection, namespace: Aspose.Words.Tables
  DNNodeImporter = interface; // type: Aspose.Words.NodeImporter, namespace: Aspose.Words
  DNNodeList = interface; // type: Aspose.Words.NodeList, namespace: Aspose.Words
  DNEndnoteOptions = interface; // type: Aspose.Words.Notes.EndnoteOptions, namespace: Aspose.Words.Notes
  DNFootnoteOptions = interface; // type: Aspose.Words.Notes.FootnoteOptions, namespace: Aspose.Words.Notes
  DNPageSetup = interface; // type: Aspose.Words.PageSetup, namespace: Aspose.Words
  DNParagraphFormat = interface; // type: Aspose.Words.ParagraphFormat, namespace: Aspose.Words
  DNPlainTextDocument = interface; // type: Aspose.Words.PlainTextDocument, namespace: Aspose.Words
  DNDocumentProperty = interface; // type: Aspose.Words.Properties.DocumentProperty, namespace: Aspose.Words.Properties
  DNDocumentPropertyCollection = interface; // type: Aspose.Words.Properties.DocumentPropertyCollection, namespace: Aspose.Words.Properties
  DNBuiltInDocumentProperties = interface; // type: Aspose.Words.Properties.BuiltInDocumentProperties, namespace: Aspose.Words.Properties
  DNCustomDocumentProperties = interface; // type: Aspose.Words.Properties.CustomDocumentProperties, namespace: Aspose.Words.Properties
  DNRange = interface; // type: Aspose.Words.Range, namespace: Aspose.Words
  DNNodeRendererBase = interface; // type: Aspose.Words.Rendering.NodeRendererBase, namespace: Aspose.Words.Rendering
  DNOfficeMathRenderer = interface; // type: Aspose.Words.Rendering.OfficeMathRenderer, namespace: Aspose.Words.Rendering
  DNShapeRenderer = interface; // type: Aspose.Words.Rendering.ShapeRenderer, namespace: Aspose.Words.Rendering
  DNPageInfo = interface; // type: Aspose.Words.Rendering.PageInfo, namespace: Aspose.Words.Rendering
  DNPrinterSettingsContainer = interface; // type: Aspose.Words.Rendering.PrinterSettingsContainer, namespace: Aspose.Words.Rendering
  DNThumbnailGeneratingOptions = interface; // type: Aspose.Words.Rendering.ThumbnailGeneratingOptions, namespace: Aspose.Words.Rendering
  DNFindReplaceOptions = interface; // type: Aspose.Words.Replacing.FindReplaceOptions, namespace: Aspose.Words.Replacing
  DNReplacingArgs = interface; // type: Aspose.Words.Replacing.ReplacingArgs, namespace: Aspose.Words.Replacing
  DNCsvDataLoadOptions = interface; // type: Aspose.Words.Reporting.CsvDataLoadOptions, namespace: Aspose.Words.Reporting
  DNCsvDataSource = interface; // type: Aspose.Words.Reporting.CsvDataSource, namespace: Aspose.Words.Reporting
  DNJsonDataLoadOptions = interface; // type: Aspose.Words.Reporting.JsonDataLoadOptions, namespace: Aspose.Words.Reporting
  DNJsonDataSource = interface; // type: Aspose.Words.Reporting.JsonDataSource, namespace: Aspose.Words.Reporting
  DNKnownTypeSet = interface; // type: Aspose.Words.Reporting.KnownTypeSet, namespace: Aspose.Words.Reporting
  DNReportingEngine = interface; // type: Aspose.Words.Reporting.ReportingEngine, namespace: Aspose.Words.Reporting
  DNXmlDataLoadOptions = interface; // type: Aspose.Words.Reporting.XmlDataLoadOptions, namespace: Aspose.Words.Reporting
  DNXmlDataSource = interface; // type: Aspose.Words.Reporting.XmlDataSource, namespace: Aspose.Words.Reporting
  DNRevision = interface; // type: Aspose.Words.Revision, namespace: Aspose.Words
  DNRevisionCollection = interface; // type: Aspose.Words.RevisionCollection, namespace: Aspose.Words
  DNRevisionGroup = interface; // type: Aspose.Words.RevisionGroup, namespace: Aspose.Words
  DNRevisionGroupCollection = interface; // type: Aspose.Words.RevisionGroupCollection, namespace: Aspose.Words
  DNBookmarksOutlineLevelCollection = interface; // type: Aspose.Words.Saving.BookmarksOutlineLevelCollection, namespace: Aspose.Words.Saving
  DNCssSavingArgs = interface; // type: Aspose.Words.Saving.CssSavingArgs, namespace: Aspose.Words.Saving
  DNDocumentPartSavingArgs = interface; // type: Aspose.Words.Saving.DocumentPartSavingArgs, namespace: Aspose.Words.Saving
  DNDownsampleOptions = interface; // type: Aspose.Words.Saving.DownsampleOptions, namespace: Aspose.Words.Saving
  DNFontSavingArgs = interface; // type: Aspose.Words.Saving.FontSavingArgs, namespace: Aspose.Words.Saving
  DNGraphicsQualityOptions = interface; // type: Aspose.Words.Saving.GraphicsQualityOptions, namespace: Aspose.Words.Saving
  DNImageSavingArgs = interface; // type: Aspose.Words.Saving.ImageSavingArgs, namespace: Aspose.Words.Saving
  DNMetafileRenderingOptions = interface; // type: Aspose.Words.Saving.MetafileRenderingOptions, namespace: Aspose.Words.Saving
  DNOutlineOptions = interface; // type: Aspose.Words.Saving.OutlineOptions, namespace: Aspose.Words.Saving
  DNPageRange = interface; // type: Aspose.Words.Saving.PageRange, namespace: Aspose.Words.Saving
  DNPageSavingArgs = interface; // type: Aspose.Words.Saving.PageSavingArgs, namespace: Aspose.Words.Saving
  DNPageSet = interface; // type: Aspose.Words.Saving.PageSet, namespace: Aspose.Words.Saving
  DNPdfDigitalSignatureDetails = interface; // type: Aspose.Words.Saving.PdfDigitalSignatureDetails, namespace: Aspose.Words.Saving
  DNPdfDigitalSignatureTimestampSettings = interface; // type: Aspose.Words.Saving.PdfDigitalSignatureTimestampSettings, namespace: Aspose.Words.Saving
  DNPdfEncryptionDetails = interface; // type: Aspose.Words.Saving.PdfEncryptionDetails, namespace: Aspose.Words.Saving
  DNResourceSavingArgs = interface; // type: Aspose.Words.Saving.ResourceSavingArgs, namespace: Aspose.Words.Saving
  DNSaveOptions = interface; // type: Aspose.Words.Saving.SaveOptions, namespace: Aspose.Words.Saving
  DNDocSaveOptions = interface; // type: Aspose.Words.Saving.DocSaveOptions, namespace: Aspose.Words.Saving
  DNFixedPageSaveOptions = interface; // type: Aspose.Words.Saving.FixedPageSaveOptions, namespace: Aspose.Words.Saving
  DNHtmlFixedSaveOptions = interface; // type: Aspose.Words.Saving.HtmlFixedSaveOptions, namespace: Aspose.Words.Saving
  DNImageSaveOptions = interface; // type: Aspose.Words.Saving.ImageSaveOptions, namespace: Aspose.Words.Saving
  DNPclSaveOptions = interface; // type: Aspose.Words.Saving.PclSaveOptions, namespace: Aspose.Words.Saving
  DNPdfSaveOptions = interface; // type: Aspose.Words.Saving.PdfSaveOptions, namespace: Aspose.Words.Saving
  DNPsSaveOptions = interface; // type: Aspose.Words.Saving.PsSaveOptions, namespace: Aspose.Words.Saving
  DNSvgSaveOptions = interface; // type: Aspose.Words.Saving.SvgSaveOptions, namespace: Aspose.Words.Saving
  DNXamlFixedSaveOptions = interface; // type: Aspose.Words.Saving.XamlFixedSaveOptions, namespace: Aspose.Words.Saving
  DNXpsSaveOptions = interface; // type: Aspose.Words.Saving.XpsSaveOptions, namespace: Aspose.Words.Saving
  DNHtmlSaveOptions = interface; // type: Aspose.Words.Saving.HtmlSaveOptions, namespace: Aspose.Words.Saving
  DNOdtSaveOptions = interface; // type: Aspose.Words.Saving.OdtSaveOptions, namespace: Aspose.Words.Saving
  DNOoxmlSaveOptions = interface; // type: Aspose.Words.Saving.OoxmlSaveOptions, namespace: Aspose.Words.Saving
  DNRtfSaveOptions = interface; // type: Aspose.Words.Saving.RtfSaveOptions, namespace: Aspose.Words.Saving
  DNTxtSaveOptionsBase = interface; // type: Aspose.Words.Saving.TxtSaveOptionsBase, namespace: Aspose.Words.Saving
  DNMarkdownSaveOptions = interface; // type: Aspose.Words.Saving.MarkdownSaveOptions, namespace: Aspose.Words.Saving
  DNTxtSaveOptions = interface; // type: Aspose.Words.Saving.TxtSaveOptions, namespace: Aspose.Words.Saving
  DNWordML2003SaveOptions = interface; // type: Aspose.Words.Saving.WordML2003SaveOptions, namespace: Aspose.Words.Saving
  DNXamlFlowSaveOptions = interface; // type: Aspose.Words.Saving.XamlFlowSaveOptions, namespace: Aspose.Words.Saving
  DNSaveOutputParameters = interface; // type: Aspose.Words.Saving.SaveOutputParameters, namespace: Aspose.Words.Saving
  DNTxtListIndentation = interface; // type: Aspose.Words.Saving.TxtListIndentation, namespace: Aspose.Words.Saving
  DNCompatibilityOptions = interface; // type: Aspose.Words.Settings.CompatibilityOptions, namespace: Aspose.Words.Settings
  DNHyphenationOptions = interface; // type: Aspose.Words.Settings.HyphenationOptions, namespace: Aspose.Words.Settings
  DNMailMergeSettings = interface; // type: Aspose.Words.Settings.MailMergeSettings, namespace: Aspose.Words.Settings
  DNOdso = interface; // type: Aspose.Words.Settings.Odso, namespace: Aspose.Words.Settings
  DNOdsoFieldMapData = interface; // type: Aspose.Words.Settings.OdsoFieldMapData, namespace: Aspose.Words.Settings
  DNOdsoFieldMapDataCollection = interface; // type: Aspose.Words.Settings.OdsoFieldMapDataCollection, namespace: Aspose.Words.Settings
  DNOdsoRecipientData = interface; // type: Aspose.Words.Settings.OdsoRecipientData, namespace: Aspose.Words.Settings
  DNOdsoRecipientDataCollection = interface; // type: Aspose.Words.Settings.OdsoRecipientDataCollection, namespace: Aspose.Words.Settings
  DNViewOptions = interface; // type: Aspose.Words.Settings.ViewOptions, namespace: Aspose.Words.Settings
  DNWriteProtection = interface; // type: Aspose.Words.Settings.WriteProtection, namespace: Aspose.Words.Settings
  DNBasicTextShaperCache = interface; // type: Aspose.Words.Shaping.BasicTextShaperCache, namespace: Aspose.Words.Shaping
  DNCluster = interface; // type: Aspose.Words.Shaping.Cluster, namespace: Aspose.Words.Shaping
  DNGlyph = interface; // type: Aspose.Words.Shaping.Glyph, namespace: Aspose.Words.Shaping
  DNSignatureLineOptions = interface; // type: Aspose.Words.SignatureLineOptions, namespace: Aspose.Words
  DNStyle = interface; // type: Aspose.Words.Style, namespace: Aspose.Words
  DNTableStyle = interface; // type: Aspose.Words.TableStyle, namespace: Aspose.Words
  DNStyleCollection = interface; // type: Aspose.Words.StyleCollection, namespace: Aspose.Words
  DNCellFormat = interface; // type: Aspose.Words.Tables.CellFormat, namespace: Aspose.Words.Tables
  DNPreferredWidth = interface; // type: Aspose.Words.Tables.PreferredWidth, namespace: Aspose.Words.Tables
  DNRowFormat = interface; // type: Aspose.Words.Tables.RowFormat, namespace: Aspose.Words.Tables
  DNTabStop = interface; // type: Aspose.Words.TabStop, namespace: Aspose.Words
  DNTextColumn = interface; // type: Aspose.Words.TextColumn, namespace: Aspose.Words
  DNTextColumnCollection = interface; // type: Aspose.Words.TextColumnCollection, namespace: Aspose.Words
  DNTextWatermarkOptions = interface; // type: Aspose.Words.TextWatermarkOptions, namespace: Aspose.Words
  DNTheme = interface; // type: Aspose.Words.Themes.Theme, namespace: Aspose.Words.Themes
  DNThemeColors = interface; // type: Aspose.Words.Themes.ThemeColors, namespace: Aspose.Words.Themes
  DNThemeFonts = interface; // type: Aspose.Words.Themes.ThemeFonts, namespace: Aspose.Words.Themes
  DNVariableCollection = interface; // type: Aspose.Words.VariableCollection, namespace: Aspose.Words
  DNVbaModule = interface; // type: Aspose.Words.Vba.VbaModule, namespace: Aspose.Words.Vba
  DNVbaModuleCollection = interface; // type: Aspose.Words.Vba.VbaModuleCollection, namespace: Aspose.Words.Vba
  DNVbaProject = interface; // type: Aspose.Words.Vba.VbaProject, namespace: Aspose.Words.Vba
  DNVbaReference = interface; // type: Aspose.Words.Vba.VbaReference, namespace: Aspose.Words.Vba
  DNVbaReferenceCollection = interface; // type: Aspose.Words.Vba.VbaReferenceCollection, namespace: Aspose.Words.Vba
  DNWarningInfo = interface; // type: Aspose.Words.WarningInfo, namespace: Aspose.Words
  DNWarningInfoCollection = interface; // type: Aspose.Words.WarningInfoCollection, namespace: Aspose.Words
  DNWatermark = interface; // type: Aspose.Words.Watermark, namespace: Aspose.Words
  DNTaskPaneCollection = interface; // type: Aspose.Words.WebExtensions.TaskPaneCollection, namespace: Aspose.Words.WebExtensions
  DNWebExtensionBindingCollection = interface; // type: Aspose.Words.WebExtensions.WebExtensionBindingCollection, namespace: Aspose.Words.WebExtensions
  DNWebExtensionPropertyCollection = interface; // type: Aspose.Words.WebExtensions.WebExtensionPropertyCollection, namespace: Aspose.Words.WebExtensions
  DNWebExtensionReferenceCollection = interface; // type: Aspose.Words.WebExtensions.WebExtensionReferenceCollection, namespace: Aspose.Words.WebExtensions
  DNBaseWebExtensionCollection<T> = interface; // type: Aspose.Words.WebExtensions.BaseWebExtensionCollection`1, namespace: Aspose.Words.WebExtensions
  DNTaskPane = interface; // type: Aspose.Words.WebExtensions.TaskPane, namespace: Aspose.Words.WebExtensions
  DNWebExtension = interface; // type: Aspose.Words.WebExtensions.WebExtension, namespace: Aspose.Words.WebExtensions
  DNWebExtensionBinding = interface; // type: Aspose.Words.WebExtensions.WebExtensionBinding, namespace: Aspose.Words.WebExtensions
  DNWebExtensionProperty = interface; // type: Aspose.Words.WebExtensions.WebExtensionProperty, namespace: Aspose.Words.WebExtensions
  DNWebExtensionReference = interface; // type: Aspose.Words.WebExtensions.WebExtensionReference, namespace: Aspose.Words.WebExtensions
  DNDocumentReaderPluginLoadException = interface; // type: Aspose.Words.DocumentReaderPluginLoadException, namespace: Aspose.Words
  DNFileCorruptedException = interface; // type: Aspose.Words.FileCorruptedException, namespace: Aspose.Words
  DNIncorrectPasswordException = interface; // type: Aspose.Words.IncorrectPasswordException, namespace: Aspose.Words
  DNUnsupportedFileFormatException = interface; // type: Aspose.Words.UnsupportedFileFormatException, namespace: Aspose.Words
  DNAsposeWordsPrintDocument = interface; // type: Aspose.Words.Rendering.AsposeWordsPrintDocument, namespace: Aspose.Words.Rendering


{ objects }

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  ///<summary>
  ///  Contains properties of a single data point on the chart.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.IChartDataPoint')]
  DNIChartDataPoint = interface(DDN.mscorlib.DNObject)
  ['{5887582F-F858-3A19-AF56-6C33936182A3}']
  { getters & setters } 

    function get_Explosion: Int32;
    procedure set_Explosion(value: Int32);
    function get_InvertIfNegative: Boolean;
    procedure set_InvertIfNegative(value: Boolean);
    function get_Marker: DNChartMarker;
    function get_Bubble3D: Boolean;
    procedure set_Bubble3D(value: Boolean);

  { propertys } 

    ///<summary>
    ///  Specifies the amount the data point shall be moved from the center of the pie.
    ///  Can be negative, negative means that property is not set and no explosion should be applied.
    ///  Applies only to Pie charts.
    ///</summary>
    property Explosion: Int32 read get_Explosion write set_Explosion;
    ///<summary>
    ///  Specifies whether the parent element shall inverts its colors if the value is negative.
    ///</summary>
    property InvertIfNegative: Boolean read get_InvertIfNegative write set_InvertIfNegative;
    ///<summary>
    ///  Specifies a data marker. Marker is automatically created when requested.
    ///</summary>
    property Marker: DNChartMarker read get_Marker;
    ///<summary>
    ///  Specifies whether the bubbles in Bubble chart should have a 3-D effect applied to them.
    ///</summary>
    property Bubble3D: Boolean read get_Bubble3D write set_Bubble3D;
  end;

  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Public interface for barcode custom generator. Implementation should be provided by user.
  ///</summary>
  ///<remarks>
  ///  Generator instance should be passed through the <see cref="P:Aspose.Words.Fields.FieldOptions.BarcodeGenerator" />
  ///  property.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.IBarcodeGenerator')]
  DNIBarcodeGenerator = interface(DDN.mscorlib.DNObject)
  ['{D6B151F7-0BF2-3973-8176-C0C4E178C4ED}']
  { methods } 

    ///<summary>
    ///  Generate barcode image using the set of parameters (for DisplayBarcode field).
    ///</summary>
    ///  <param name="parameters">The set of parameters</param>
    ///<returns>Image representing generated barcode.</returns>
    function GetBarcodeImage(parameters: DNBarcodeParameters): DDN.System.Drawing.DNImage;
    ///<summary>
    ///  Generate barcode image using the set of parameters (for old-fashioned Barcode field).
    ///</summary>
    ///  <param name="parameters">The set of parameters</param>
    ///<returns>Image representing generated barcode.</returns>
    function GetOldBarcodeImage(parameters: DNBarcodeParameters): DDN.System.Drawing.DNImage;

  end;

  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  When implemented, allows to override default comparison expressions evaluation for the <see cref="T:Aspose.Words.Fields.FieldIf" />
  ///  and <see cref="T:Aspose.Words.Fields.FieldCompare" />
  ///  fields.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Fields.FieldOptions.ComparisonExpressionEvaluator" />
  [DNTypeName('Aspose.Words.Fields.IComparisonExpressionEvaluator')]
  DNIComparisonExpressionEvaluator = interface(DDN.mscorlib.DNObject)
  ['{BDB4A8BE-6A68-3742-ADA1-5329DA8A168E}']
  { methods } 

    ///<summary>
    ///  Evaluates comparison expression.
    ///</summary>
    ///<remarks>
    ///  The implementation should return <b>null</b>
    ///  to indicate that the default evaluation should be performed.
    ///</remarks>
    function Evaluate(field: DNField; expression: DNComparisonExpression): DNComparisonEvaluationResult;

  end;

  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Implement this interface if you want to control how the field result is formatted.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.IFieldResultFormatter')]
  DNIFieldResultFormatter = interface(DDN.mscorlib.DNObject)
  ['{97E06029-227C-364E-B0E1-9BE0B49103DC}']
  { methods } 

    ///<summary>
    ///  Called when Aspose.Words applies a numeric format switch, i.e. \# "#.##".
    ///</summary>
    ///<remarks>
    ///  The implementation should return <b>null</b>
    ///  to indicate that the default formatting should be applied.
    ///</remarks>
    function FormatNumeric(value: Double; format: string): string;
    ///<summary>
    ///  Called when Aspose.Words applies a date/time format switch, i.e. \@ "dd.MM.yyyy".
    ///</summary>
    ///<remarks>
    ///  The implementation should return <b>null</b>
    ///  to indicate that the default formatting should be applied.
    ///</remarks>
    function FormatDateTime(value: DDN.mscorlib.DNDateTime; format: string; calendarType: DNCalendarType): string;
    ///<summary>
    ///  Called when Aspose.Words applies a capitalization format switch, i.e. \* Upper.
    ///</summary>
    ///<remarks>
    ///  The implementation should return <b>null</b>
    ///  to indicate that the default formatting should be applied.
    ///</remarks>
    function Format(value: string; format: DNGeneralFormat): string; overload;
    ///<summary>
    ///  Called when Aspose.Words applies a number format switch, i.e. \* Ordinal.
    ///</summary>
    ///<remarks>
    ///  The implementation should return <b>null</b>
    ///  to indicate that the default formatting should be applied.
    ///</remarks>
    function Format(value: Double; format: DNGeneralFormat): string; overload;

  end;

  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  When implemented, provides a <see cref="T:System.Globalization.CultureInfo" />
  ///  object that should be used during the update of a particular field.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.IFieldUpdateCultureProvider')]
  DNIFieldUpdateCultureProvider = interface(DDN.mscorlib.DNObject)
  ['{835EBA32-A873-3A3E-A484-52A967203D77}']
  { methods } 

    ///<summary>
    ///  Returns a <see cref="T:System.Globalization.CultureInfo" />
    ///  object to be used during the field's update.
    ///</summary>
    ///  <param name="culture">The name of the culture requested for the field being updated.</param>
    ///  <param name="field">The field being updated.</param>
    ///<returns>The culture object that should be used for the field's update.</returns>
    function GetCulture(culture: string; field: DNField): DDN.mscorlib.DNCultureInfo;

  end;

  //-------------namespace: Aspose.Words.Fields----------------
  ///<summary>
  ///  Represents the respondent to user prompts during field update.
  ///</summary>
  ///<remarks>
  ///  The ASK and FILLIN fields are the examples of fields that prompt the user for some response. Implement this interface
  ///  and assign it to the <see cref="P:Aspose.Words.Fields.FieldOptions.UserPromptRespondent" />
  ///  property to establish interaction between field update
  ///  and the user.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.IFieldUserPromptRespondent')]
  DNIFieldUserPromptRespondent = interface(DDN.mscorlib.DNObject)
  ['{F36797B9-8E3C-3C7B-AEC4-F7433F1B74F8}']
  { methods } 

    ///<summary>
    ///  When implemented, returns a response from the user on prompting.
    ///  Your implementation should return <b>null</b>
    ///  to indicate that the user has not responded to the prompt
    ///  (i.e. the user has pressed the Cancel button in the prompt window).
    ///</summary>
    ///  <param name="promptText">Prompt text (i.e. title of the prompt window).</param>
    ///  <param name="defaultResponse">Default user response (i.e. initial value contained in the prompt window).</param>
    ///<returns>User response (i.e. confirmed value contained in the prompt window).</returns>
    function Respond(promptText: string; defaultResponse: string): string;

  end;

  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Defines an interface for external reader plugins that can read a file into a document.
  ///</summary>
  [DNTypeName('Aspose.Words.IDocumentReaderPlugin')]
  DNIDocumentReaderPlugin = interface(DDN.mscorlib.DNObject)
  ['{9F4B5B97-7223-349C-A401-1A48BBA07C03}']
  { methods } 

    ///<summary>
    ///  Reads the data from the specified stream into the <see cref="T:Aspose.Words.Document" />
    ///  instance.
    ///</summary>
    ///  <param name="src">The source stream to read the document from.</param>
    ///  <param name="loadOptions">An additional load options to load the document.</param>
    ///  <param name="document">The instance of the <see cref="T:Aspose.Words.Document" />
    ///  class to read the data to.
    ///  If the instance contains some content, it will be overriden by the data from the source stream</param>
    procedure Read(src: DDN.mscorlib.DNStream; loadOptions: DNLoadOptions; document: DNDocument);

  end;

  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Implemented by classes which can register hyphenation dictionaries.
  ///</summary>
  [DNTypeName('Aspose.Words.IHyphenationCallback')]
  DNIHyphenationCallback = interface(DDN.mscorlib.DNObject)
  ['{8FE5A898-05D7-3A31-BFEB-4590D9F4D257}']
  { methods } 

    ///<summary>
    ///  Notifies application that hyphenation dictionary for the specified language wasn't found and may need to be registered.<para />
    ///  Implementation should find a dictionary and register it using <see cref="M:Aspose.Words.Hyphenation.RegisterDictionary(System.String,System.IO.Stream)" />
    ///  methods.<para />
    ///  If dictionary is unavailable for the specified language implementation can opt out of further calls for the same language
    ///  using <see cref="M:Aspose.Words.Hyphenation.RegisterDictionary(System.String,System.String)" />
    ///  with null value.
    ///</summary>
    ///  <param name="language">A language name, e.g. "en-US". See .NET documentation for "culture name" and RFC 4646 for details.</param>
    ///<remarks>Exceptions thrown by this method will abort execution of page layout process.</remarks>
    procedure RequestDictionary(language: string);

  end;

  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Implement this interface if you want to receive notifications when nodes are inserted or removed in the document.
  ///</summary>
  [DNTypeName('Aspose.Words.INodeChangingCallback')]
  DNINodeChangingCallback = interface(DDN.mscorlib.DNObject)
  ['{5F271C32-AF80-3ADF-BBFA-4AAB6F5DBF13}']
  { methods } 

    ///<summary>
    ///  Called just before a node belonging to this document is about to be inserted into another node.
    ///</summary>
    procedure NodeInserting(args: DNNodeChangingArgs);
    ///<summary>
    ///  Called when a node belonging to this document has been inserted into another node.
    ///</summary>
    procedure NodeInserted(args: DNNodeChangingArgs);
    ///<summary>
    ///  Called just before a node belonging to this document is about to be removed from the document.
    ///</summary>
    procedure NodeRemoving(args: DNNodeChangingArgs);
    ///<summary>
    ///  Called when a node belonging to this document has been removed from its parent.
    ///</summary>
    procedure NodeRemoved(args: DNNodeChangingArgs);

  end;

  //-------------namespace: Aspose.Words----------------
  ///<summary>
  ///  Implement this interface if you want to have your own custom method called to
  ///  capture loss of fidelity warnings that can occur during document loading or saving.
  ///</summary>
  [DNTypeName('Aspose.Words.IWarningCallback')]
  DNIWarningCallback = interface(DDN.mscorlib.DNObject)
  ['{29662C09-EE27-3859-B5CD-1C2181644240}']
  { methods } 

    ///<summary>
    ///  Aspose.Words invokes this method when it encounters some issue during document loading
    ///  or saving that might result in loss of formatting or data fidelity.
    ///</summary>
    procedure Warning(info: DNWarningInfo);

  end;

  //-------------namespace: Aspose.Words.Layout----------------
  ///<summary>
  ///  Implement this interface if you want to have your own custom method called during build and rendering of page layout model.
  ///</summary>
  ///<remarks>
  ///  The primary use for this interface is to allow application code to abort build process.<para />
  ///  It is possible to build page layout model for only a few pages at start of the document then abort process and render only what has been built already.<para />
  ///  Note, however, that rendering results may not match what would be rendered for each page if process would have finished.<para />
  ///  This technique may not work for every document or may fail completely.<para /></remarks>
  ///<seealso cref="P:Aspose.Words.Layout.LayoutOptions.Callback" />
  [DNTypeName('Aspose.Words.Layout.IPageLayoutCallback')]
  DNIPageLayoutCallback = interface(DDN.mscorlib.DNObject)
  ['{891E18AC-FBC5-3304-8653-8B4C6D28FF6A}']
  { methods } 

    ///<summary>
    ///  This is called to notify of layout build and rendering progress.
    ///</summary>
    ///  <param name="args">An argument of the event.</param>
    ///<remarks>
    ///  Exception when thrown by implementation aborts layout build process.<para /></remarks>
    procedure Notify(args: DNPageLayoutCallbackArgs);

  end;

  //-------------namespace: Aspose.Words.Loading----------------
  ///<summary>
  ///  Implement this interface if you want to control how Aspose.Words loads external resource when
  ///  importing a document and inserting images using <see cref="T:Aspose.Words.DocumentBuilder" />
  ///  .
  ///</summary>
  [DNTypeName('Aspose.Words.Loading.IResourceLoadingCallback')]
  DNIResourceLoadingCallback = interface(DDN.mscorlib.DNObject)
  ['{A2546162-6B9C-3605-9724-A653468CF0EC}']
  { methods } 

    ///<summary>
    ///  Called when Aspose.Words loads any external resource.
    ///</summary>
    function ResourceLoading(args: DNResourceLoadingArgs): DNResourceLoadingAction;

  end;

  //-------------namespace: Aspose.Words.MailMerging----------------
  ///<summary>
  ///  Implement this interface if you want to control how data is inserted into merge fields during a mail merge operation.
  ///</summary>
  [DNTypeName('Aspose.Words.MailMerging.IFieldMergingCallback')]
  DNIFieldMergingCallback = interface(DDN.mscorlib.DNObject)
  ['{EA71F2E8-71B5-3141-9ABB-6AAED29E71CC}']
  { methods } 

    ///<summary>
    ///  Called when the Aspose.Words mail merge engine is about to insert data into a merge field in the document.
    ///</summary>
    procedure FieldMerging(args: DNFieldMergingArgs);
    ///<summary>
    ///  Called when the Aspose.Words mail merge engine is about to insert an image into a merge field.
    ///</summary>
    procedure ImageFieldMerging(args: DNImageFieldMergingArgs);

  end;

  //-------------namespace: Aspose.Words.MailMerging----------------
  ///<summary>
  ///  Implement this interface if you want to receive notifications while mail merge is performed.
  ///</summary>
  [DNTypeName('Aspose.Words.MailMerging.IMailMergeCallback')]
  DNIMailMergeCallback = interface(DDN.mscorlib.DNObject)
  ['{4854824C-F854-3B7C-AB21-DBBDD751A4E4}']
  { methods } 

    ///<summary>
    ///  Called when "mustache" text tags are replaced with MERGEFIELD fields.
    ///</summary>
    ///<seealso cref="P:Aspose.Words.MailMerging.MailMerge.UseNonMergeFields" />
    procedure TagsReplaced;

  end;

  //-------------namespace: Aspose.Words.MailMerging----------------
  ///<summary>
  ///  Implement this interface to allow mail merge from a custom data source, such as a list of objects. Master-detail data is also supported.
  ///</summary>
  ///<remarks><para>When a data source is created, it should be initialized to point to BOF (before the first record).
  ///  The Aspose.Words mail merge engine will invoke <see cref="M:Aspose.Words.MailMerging.IMailMergeDataSource.MoveNext" />
  ///  to advance to next record and
  ///  then invoke <see cref="M:Aspose.Words.MailMerging.IMailMergeDataSource.GetValue(System.String,System.Object@)" />
  ///  for every merge field it encounters in the document or the current mail merge region.</para><seealso cref="T:Aspose.Words.MailMerging.MailMerge" />
  ///</remarks>
  [DNTypeName('Aspose.Words.MailMerging.IMailMergeDataSource')]
  DNIMailMergeDataSource = interface(DDN.mscorlib.DNObject)
  ['{0E06BFCC-D9C8-3C46-9492-D81B5491332B}']
  { getters & setters } 

    function get_TableName: string;

  { methods } 

    ///<summary>
    ///  Advances to the next record in the data source.
    ///</summary>
    ///<returns>True if moved to next record successfully. False if reached end of the data source.</returns>
    function MoveNext: Boolean;
    function GetValue(fieldName: string; out fieldValue: DDN.mscorlib.DNObject): Boolean;
    ///<summary>
    ///  The Aspose.Words mail merge engine invokes this method when it encounters a beginning of a nested mail merge region.
    ///</summary>
    ///<remarks><para>
    ///  When the Aspose.Words mail merge engines populates a mail merge region with data and encounters the beginning of a nested
    ///  mail merge region in the form of MERGEFIELD TableStart:TableName, it invokes <see cref="M:Aspose.Words.MailMerging.IMailMergeDataSource.GetChildDataSource(System.String)" />
    ///  on the current
    ///  data source object. Your implementation needs to return a new data source object that will provide access to the child
    ///  records of the current parent record. Aspose.Words will use the returned data source to populate the nested mail merge region.
    ///</para><para>
    ///  Below are the rules that the implementation of <see cref="M:Aspose.Words.MailMerging.IMailMergeDataSource.GetChildDataSource(System.String)" />
    ///  must follow.
    ///</para><para>
    ///  If the table that is represented by this data source object has a related child (detail) table with the specified name,
    ///  then your implementation needs to return a new <see cref="T:Aspose.Words.MailMerging.IMailMergeDataSource" />
    ///  object that will provide access
    ///  to the child records of the current record.
    ///  An example of this is Orders / OrderDetails relationship. Let's assume that the current <see cref="T:Aspose.Words.MailMerging.IMailMergeDataSource" />
    ///  object
    ///  represents the Orders table and it has a current order record. Next, Aspose.Words encounters "MERGEFIELD TableStart:OrderDetails"
    ///  in the document and invokes <see cref="M:Aspose.Words.MailMerging.IMailMergeDataSource.GetChildDataSource(System.String)" />
    ///  . You need to create and return a <see cref="T:Aspose.Words.MailMerging.IMailMergeDataSource" />
    ///  object that will allow Aspose.Words to access the OrderDetails record for the current order.
    ///</para><para>
    ///  If this data source object does not have a relation to the table with the specified name, then you need to return
    ///  a <see cref="T:Aspose.Words.MailMerging.IMailMergeDataSource" />
    ///  object that will provide access to all records of the specified table.
    ///</para><para>
    ///  If a table with the specified name does not exist, your implementation should return <c>null</c>.
    ///</para></remarks>
    ///  <param name="tableName">The name of the mail merge region as specified in the template document. Case-insensitive.</param>
    ///<returns>A data source object that will provide access to the data records of the specified table.</returns>
    function GetChildDataSource(tableName: string): DNIMailMergeDataSource;

  { propertys } 

    ///<summary>
    ///  Returns the name of the data source.
    ///</summary>
    ///<remarks><p>If you are implementing <see cref="T:Aspose.Words.MailMerging.IMailMergeDataSource" />
    ///  , return the name of the data
    ///  source from this property.</p>
    ///  <p>Aspose.Words uses this name to match against the mail merge region name specified
    ///  in the template document. The comparison between the data source name and
    ///  the mail merge region name is not case sensitive.</p>
    ///</remarks>
    ///<returns>The name of the data source. Empty string if the data source has no name.</returns>
    property TableName: string read get_TableName;
  end;

  //-------------namespace: Aspose.Words.MailMerging----------------
  ///<summary>
  ///  Implement this interface to allow mail merge from a custom data source with master-detail data.
  ///</summary>
  [DNTypeName('Aspose.Words.MailMerging.IMailMergeDataSourceRoot')]
  DNIMailMergeDataSourceRoot = interface(DDN.mscorlib.DNObject)
  ['{A23255FE-0464-36A4-BCFE-38E4C4073CEA}']
  { methods } 

    ///<summary>
    ///  The Aspose.Words mail merge engine invokes this method when it encounters a beginning of a top-level mail merge region.
    ///</summary>
    ///<remarks><para>
    ///  When the Aspose.Words mail merge engines populates a document with data and encounters MERGEFIELD TableStart:TableName,
    ///  it invokes <see cref="M:Aspose.Words.MailMerging.IMailMergeDataSourceRoot.GetDataSource(System.String)" />
    ///  on this object. Your implementation needs to return a new data source object.
    ///  Aspose.Words will use the returned data source to populate the mail merge region.
    ///</para><para>
    ///  If a data source (table) with the specified name does not exist, your implementation should return <c>null</c>.
    ///</para></remarks>
    ///  <param name="tableName">The name of the mail merge region as specified in the template document. Case-insensitive.</param>
    ///<returns>A data source object that will provide access to the data records of the specified table.</returns>
    function GetDataSource(tableName: string): DNIMailMergeDataSource;

  end;

  //-------------namespace: Aspose.Words.Replacing----------------
  ///<summary>
  ///  Implement this interface if you want to have your own custom method called during a find and replace operation.
  ///</summary>
  [DNTypeName('Aspose.Words.Replacing.IReplacingCallback')]
  DNIReplacingCallback = interface(DDN.mscorlib.DNObject)
  ['{FF0B8E19-D9B7-3495-9CD2-FB8E0D099D17}']
  { methods } 

    ///<summary>
    ///  A user defined method that is called during a replace operation for each match found just before a replace is made.
    ///</summary>
    ///<returns>
    ///  A <see cref="T:Aspose.Words.Replacing.ReplaceAction" />
    ///  value that specifies the action to be taken for the current match.
    ///</returns>
    function Replacing(args: DNReplacingArgs): DNReplaceAction;

  end;

  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Implement this interface if you want to control how Aspose.Words saves CSS (Cascading Style Sheet) when
  ///  saving a document to HTML.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.ICssSavingCallback')]
  DNICssSavingCallback = interface(DDN.mscorlib.DNObject)
  ['{2847C427-25CE-3CB8-85D1-C102E440176F}']
  { methods } 

    ///<summary>
    ///  Called when Aspose.Words saves an CSS (Cascading Style Sheet).
    ///</summary>
    procedure CssSaving(args: DNCssSavingArgs);

  end;

  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Implement this interface if you want to receive notifications and control how
  ///  Aspose.Words saves document parts when exporting a document to <see cref="F:Aspose.Words.SaveFormat.Html" />
  ///  or <see cref="F:Aspose.Words.SaveFormat.Epub" />
  ///  format.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.IDocumentPartSavingCallback')]
  DNIDocumentPartSavingCallback = interface(DDN.mscorlib.DNObject)
  ['{16EC42F9-029C-3185-9A3B-4B587C995F24}']
  { methods } 

    ///<summary>
    ///  Called when Aspose.Words is about to save a document part.
    ///</summary>
    procedure DocumentPartSaving(args: DNDocumentPartSavingArgs);

  end;

  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Implement this interface if you want to receive notifications and control how
  ///  Aspose.Words saves fonts when exporting a document to HTML format.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.IFontSavingCallback')]
  DNIFontSavingCallback = interface(DDN.mscorlib.DNObject)
  ['{489BB40F-AED0-316E-9308-2D95652FA990}']
  { methods } 

    ///<summary>
    ///  Called when Aspose.Words is about to save a font resource.
    ///</summary>
    procedure FontSaving(args: DNFontSavingArgs);

  end;

  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Implement this interface if you want to control how Aspose.Words saves images when
  ///  saving a document to HTML. May be used by other formats.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.IImageSavingCallback')]
  DNIImageSavingCallback = interface(DDN.mscorlib.DNObject)
  ['{D8C578B7-7378-3897-8D13-31B3372593D8}']
  { methods } 

    ///<summary>
    ///  Called when Aspose.Words saves an image to HTML.
    ///</summary>
    procedure ImageSaving(args: DNImageSavingArgs);

  end;

  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Implement this interface if you want to control how Aspose.Words saves separate pages when
  ///  saving a document to fixed page formats.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.IPageSavingCallback')]
  DNIPageSavingCallback = interface(DDN.mscorlib.DNObject)
  ['{E7399323-579A-3523-8D78-FCCD043DA3DD}']
  { methods } 

    ///<summary>
    ///  Called when Aspose.Words saves a separate page to fixed page formats.
    ///</summary>
    procedure PageSaving(args: DNPageSavingArgs);

  end;

  //-------------namespace: Aspose.Words.Saving----------------
  ///<summary>
  ///  Implement this interface if you want to control how Aspose.Words saves external resources (images, fonts and css) when
  ///  saving a document to fixed page HTML or SVG.
  ///</summary>
  [DNTypeName('Aspose.Words.Saving.IResourceSavingCallback')]
  DNIResourceSavingCallback = interface(DDN.mscorlib.DNObject)
  ['{A7400D28-517F-3EC3-8BF2-6783ECC6A626}']
  { methods } 

    ///<summary>
    ///  Called when Aspose.Words saves an external resource to fixed page HTML or SVG formats.
    ///</summary>
    procedure ResourceSaving(args: DNResourceSavingArgs);

  end;

  //-------------namespace: Aspose.Words.Shaping----------------
  [DNTypeName('Aspose.Words.Shaping.ITextShaperFactory')]
  DNITextShaperFactory = interface(DDN.mscorlib.DNObject)
  ['{70F491F8-4760-3E37-8A21-20C3293D4C4D}']
  { methods } 

    function GetTextShaper(fontPath: string; faceIndex: Int32): DNITextShaper; overload;
    function GetTextShaper(fontId: string; fontBlob: TArray<Byte>; faceIndex: Int32): DNITextShaper; overload;

  end;

  //-------------namespace: Aspose.Words.Shaping----------------
  [DNTypeName('Aspose.Words.Shaping.ITextShaper')]
  DNITextShaper = interface(DDN.mscorlib.DNIDisposable)
  ['{54342F49-90D6-36F7-A47B-DDE50D7A558C}']
  { methods } 

    function ShapeText(runs: TArray<string>; direction: DNDirection; script: DNUnicodeScript; fontFeatures: TArray<DNFontFeature>): TArray<TArray<DNCluster>>;

  end;

  //-------------namespace: Aspose.Words----------------
  DNBookmarkClass = interface(DDN.mscorlib.DNObjectClass)
  ['{43AEC448-050E-59CB-9120-69177BD4F172}']
  end;

  ///<summary>
  ///  Represents a single bookmark.
  ///</summary>
  ///<remarks><p><see cref="T:Aspose.Words.Bookmark" />
  ///  is a "facade" object that encapsulates two nodes <see cref="P:Aspose.Words.Bookmark.BookmarkStart" />
  ///  and <see cref="P:Aspose.Words.Bookmark.BookmarkEnd" />
  ///  in a document tree and allows to work with a bookmark as a single object.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.Bookmark')]
  DNBookmark = interface(DDN.mscorlib.DNObject)
  ['{CFD911E7-64F8-36B0-B4D4-E8EBD37442F9}']
  { getters & setters } 

    function get_Name: string;
    procedure set_Name(value: string);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_BookmarkStart: DNBookmarkStart;
    function get_BookmarkEnd: DNBookmarkEnd;
    function get_IsColumn: Boolean;
    function get_FirstColumn: Int32;
    function get_LastColumn: Int32;

  { methods } 

    ///<summary>
    ///  Removes the bookmark from the document. Does not remove text inside the bookmark.
    ///</summary>
    procedure Remove;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the name of the bookmark.
    ///</summary>
    ///<remarks>
    ///  Note that if you change the name of a bookmark to a name that already exists in the document,
    ///  no error will be given and only the first bookmark will be stored when you save the document.
    ///</remarks>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets the text enclosed in the bookmark.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets the node that represents the start of the bookmark.
    ///</summary>
    property BookmarkStart: DNBookmarkStart read get_BookmarkStart;
    ///<summary>
    ///  Gets the node that represents the end of the bookmark.
    ///</summary>
    property BookmarkEnd: DNBookmarkEnd read get_BookmarkEnd;
    ///<summary>
    ///  Returns <b>true</b>
    ///  if this bookmark is a table column bookmark.
    ///</summary>
    property IsColumn: Boolean read get_IsColumn;
    ///<summary>
    ///  Gets the zero-based index of the first column of the table column range associated with the bookmark.
    ///</summary>
    ///<remarks>
    ///  Returns <b>-1</b>
    ///  if this bookmark is not a table column bookmark.
    ///</remarks>
    property FirstColumn: Int32 read get_FirstColumn;
    ///<summary>
    ///  Gets the zero-based index of the last column of the table column range associated with the bookmark.
    ///</summary>
    ///<remarks>
    ///  Returns <b>-1</b>
    ///  if this bookmark is not a table column bookmark.
    ///</remarks>
    property LastColumn: Int32 read get_LastColumn;
  end;

  TDNBookmark = class(TDNGenericImport<DNBookmarkClass, DNBookmark>) end;

  //-------------namespace: Aspose.Words----------------
  DNBookmarkCollectionClass = interface(DNObjectClass)
  ['{2FFA0F26-E1F2-5B05-9F70-23EFEB5914BF}']
  end;

  ///<summary>
  ///  A collection of <see cref="T:Aspose.Words.Bookmark" />
  ///  objects that represent the bookmarks in the specified range.
  ///</summary>
  [DNTypeName('Aspose.Words.BookmarkCollection')]
  DNBookmarkCollection = interface(DDN.mscorlib.DNIEnumerable)
  ['{FA9215EE-0796-354E-B443-C79FBF4B479E}']
  { getters & setters } 

    function get_Count: Int32;
    function get_Item(index: Int32): DNBookmark; overload;
    function get_Item(bookmarkName: string): DNBookmark; overload;

  { methods } 

    ///<summary>
    ///  Removes the specified bookmark from the document.
    ///</summary>
    ///  <param name="bookmark">The bookmark to remove.</param>
    procedure Remove(bookmark: DNBookmark); overload;
    ///<summary>
    ///  Removes a bookmark with the specified name.
    ///</summary>
    ///  <param name="bookmarkName">The case-insensitive name of the bookmark to remove.</param>
    procedure Remove(bookmarkName: string); overload;
    ///<summary>
    ///  Removes a bookmark at the specified index.
    ///</summary>
    ///  <param name="index">The zero-based index of the bookmark to remove.</param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Removes all bookmarks from this collection and from the document.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Returns an enumerator object.
    ///</summary>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNBookmark>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Returns the number of bookmarks in the collection.
    ///</summary>
    property Count: Int32 read get_Count;
    property Item[index: Int32]: DNBookmark read get_Item; default;
    property Item[bookmarkName: string]: DNBookmark read get_Item; default;
  end;

  TDNBookmarkCollection = class(TDNGenericImport<DNBookmarkCollectionClass, DNBookmarkCollection>) end;

  //-------------namespace: Aspose.Words----------------
  DNBorderCollectionClass = interface(DNObjectClass)
  ['{03A74EFA-6854-5DE1-B0BF-AC310B88982E}']
  end;

  ///<summary>
  ///  A collection of Border objects.
  ///</summary>
  ///<remarks>
  ///  Different document elements have different borders.
  ///  For example, ParagraphFormat has Bottom, Left, Right and Top borders.
  ///  You can specify different formatting for each border independently or
  ///  enumerate through all borders and apply same formatting.
  ///</remarks>
  ///<dev>
  ///  This is a presentation object only, does not store any model data.
  ///</dev>
  [DNTypeName('Aspose.Words.BorderCollection')]
  DNBorderCollection = interface(DDN.mscorlib.DNIEnumerable)
  ['{0962E84A-ED6F-3E5D-BE9B-4BBC1DA3DE43}']
  { getters & setters } 

    function get_Item(borderType: DNBorderType): DNBorder; overload;
    function get_Item(index: Int32): DNBorder; overload;
    function get_Left: DNBorder;
    function get_Right: DNBorder;
    function get_Top: DNBorder;
    function get_Bottom: DNBorder;
    function get_Horizontal: DNBorder;
    function get_Vertical: DNBorder;
    function get_Count: Int32;
    function get_LineWidth: Double;
    procedure set_LineWidth(value: Double);
    function get_LineStyle: DNLineStyle;
    procedure set_LineStyle(value: DNLineStyle);
    function get_Color: DDN.System.Drawing.DNColor;
    procedure set_Color(value: DDN.System.Drawing.DNColor);
    function get_DistanceFromText: Double;
    procedure set_DistanceFromText(value: Double);
    function get_Shadow: Boolean;
    procedure set_Shadow(value: Boolean);

  { methods } 

    ///<summary>
    ///  Compares collections of borders.
    ///</summary>
    function Equals(brColl: DNBorderCollection): Boolean; overload;
    ///<summary>
    ///  Removes all borders of an object.
    ///</summary>
    procedure ClearFormatting;
    ///<summary>
    ///  Returns an enumerator object that can be used to iterate over all borders in the collection.
    ///</summary>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNBorder>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean; overload;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[borderType: DNBorderType]: DNBorder read get_Item; default;
    property Item[index: Int32]: DNBorder read get_Item; default;
    ///<summary>
    ///  Gets the left border.
    ///</summary>
    property Left: DNBorder read get_Left;
    ///<summary>
    ///  Gets the right border.
    ///</summary>
    property Right: DNBorder read get_Right;
    ///<summary>
    ///  Gets the top border.
    ///</summary>
    property Top: DNBorder read get_Top;
    ///<summary>
    ///  Gets the bottom border.
    ///</summary>
    property Bottom: DNBorder read get_Bottom;
    ///<summary>
    ///  Gets the horizontal border that is used between cells or conforming paragraphs.
    ///</summary>
    property Horizontal: DNBorder read get_Horizontal;
    ///<summary>
    ///  Gets the vertical border that is used between cells.
    ///</summary>
    property Vertical: DNBorder read get_Vertical;
    ///<summary>
    ///  Gets the number of borders in the collection.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Gets or sets the border width in points.
    ///</summary>
    ///<remarks><p>Returns the width of the first border in the collection.</p>
    ///  <p>Sets the width of all borders in the collection excluding diagonal borders.</p>
    ///</remarks>
    property LineWidth: Double read get_LineWidth write set_LineWidth;
    ///<summary>
    ///  Gets or sets the border style.
    ///</summary>
    ///<remarks><p>Returns the style of the first border in the collection.</p>
    ///  <p>Sets the style of all borders in the collection excluding diagonal borders.</p>
    ///</remarks>
    property LineStyle: DNLineStyle read get_LineStyle write set_LineStyle;
    ///<summary>
    ///  Gets or sets the border color.
    ///</summary>
    ///<remarks><p>Returns the color of the first border in the collection.</p>
    ///  <p>Sets the color of all borders in the collection excluding diagonal borders.</p>
    ///</remarks>
    property Color: DDN.System.Drawing.DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets distance of the border from text in points.
    ///</summary>
    ///<remarks><p>Gets the distance from text for the first border.</p>
    ///  <p>Sets the distance from text for all borders in the collection excluding diagonal borders.</p>
    ///  <p>Has no effect and will be automatically reset to zero for borders of table cells.</p>
    ///</remarks>
    property DistanceFromText: Double read get_DistanceFromText write set_DistanceFromText;
    ///<summary>
    ///  Gets or sets a value indicating whether the border has a shadow.
    ///</summary>
    ///<remarks><p>Gets the value from the first border in the collection.</p>
    ///  <p>Sets the value for all borders in the collection excluding diagonal borders.</p>
    ///</remarks>
    property Shadow: Boolean read get_Shadow write set_Shadow;
  end;

  TDNBorderCollection = class(TDNGenericImport<DNBorderCollectionClass, DNBorderCollection>) end;

  //-------------namespace: Aspose.Words----------------
  DNBuildVersionInfoClass = interface(DDN.mscorlib.DNObjectClass)
  ['{71F3FA54-873E-5806-91E9-8ABDD4097372}']
  { static getter & setter } 

    {class} function get_Product: string;
    {class} function get_Version: string;

  { static propertys } 

    ///<summary>
    ///  Gets the full name of the product.
    ///</summary>
    {class} property Product: string read get_Product;
    ///<summary>
    ///  Gets the product version.
    ///</summary>
    ///<remarks><para>The product version is in the "Major.Minor.Hotfix.0" format.</para></remarks>
    {class} property Version: string read get_Version;
  end;

  ///<summary>
  ///  Provides information about the current product name and version.
  ///</summary>
  [DNTypeName('Aspose.Words.BuildVersionInfo')]
  DNBuildVersionInfo = interface(DDN.mscorlib.DNObject)
  ['{4B06F422-6C19-30EF-A905-A8B44C118369}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNBuildVersionInfo = class(TDNGenericImport<DNBuildVersionInfoClass, DNBuildVersionInfo>) end;

  //-------------namespace: Aspose.Words----------------
  DNCleanupOptionsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{02D58285-2A26-5A97-85AF-8818BEB9EE4E}']
  { constructors } 

    {class} function init: DNCleanupOptions;

  end;

  ///<summary>
  ///  Allows to specify options for document cleaning.
  ///</summary>
  [DNTypeName('Aspose.Words.CleanupOptions')]
  DNCleanupOptions = interface(DDN.mscorlib.DNObject)
  ['{249523B2-5932-307E-B734-31769661E7D9}']
  { getters & setters } 

    function get_UnusedStyles: Boolean;
    procedure set_UnusedStyles(value: Boolean);
    function get_UnusedLists: Boolean;
    procedure set_UnusedLists(value: Boolean);
    function get_DuplicateStyle: Boolean;
    procedure set_DuplicateStyle(value: Boolean);
    function get_UnusedBuiltinStyles: Boolean;
    procedure set_UnusedBuiltinStyles(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Specifies whether unused styles should be removed from document.
    ///  Default value is <b>true</b>
    ///  .
    ///</summary>
    property UnusedStyles: Boolean read get_UnusedStyles write set_UnusedStyles;
    ///<summary>
    ///  Specifies whether unused list and list definitions should be removed from document.
    ///  Default value is <b>true</b>
    ///  .
    ///</summary>
    property UnusedLists: Boolean read get_UnusedLists write set_UnusedLists;
    ///<summary>
    ///  Gets/sets a flag indicating whether duplicate styles should be removed from document.
    ///  Default value is <b>false</b>
    ///  .
    ///</summary>
    property DuplicateStyle: Boolean read get_DuplicateStyle write set_DuplicateStyle;
    ///<summary>
    ///  Specifies that unused <see cref="P:Aspose.Words.Style.BuiltIn" />
    ///  styles should be removed from document.
    ///</summary>
    property UnusedBuiltinStyles: Boolean read get_UnusedBuiltinStyles write set_UnusedBuiltinStyles;
  end;

  TDNCleanupOptions = class(TDNGenericImport<DNCleanupOptionsClass, DNCleanupOptions>) end;

  //-------------namespace: Aspose.Words----------------
  DNComHelperClass = interface(DDN.mscorlib.DNObjectClass)
  ['{87041206-2EDF-5C05-9E17-133EF2116868}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of this class.
    ///</summary>
    {class} function init: DNComHelper;

  end;

  ///<summary>
  ///  Provides methods for COM clients to load a document into Aspose.Words.
  ///</summary>
  ///<remarks><p>Use the <see cref="T:Aspose.Words.ComHelper" />
  ///  class to load a document from a file or stream into a
  ///<see cref="T:Aspose.Words.Document" />
  ///  object in a COM application.</p>
  ///  <p>The <see cref="T:Aspose.Words.Document" />
  ///  class provides a default constructor to create a new document
  ///  and also provides overloaded constructors to load a document from a file or stream.
  ///  If you are using Aspose.Words from a .NET application, you can use all of the <see cref="T:Aspose.Words.Document" />
  ///  constructors directly, but if you are using Aspose.Words from a COM application,
  ///  only the default <see cref="T:Aspose.Words.Document" />
  ///  constructor is available.</p>
  ///</remarks>
  ///<example><code>
  ///  [VBScript]
  ///  Dim helper
  ///  Set helper = CreateObject("Aspose.Words.ComHelper")
  ///  Dim doc
  ///  Set doc = helper.Open(fileName)
  ///</code></example>
  [DNTypeName('Aspose.Words.ComHelper')]
  DNComHelper = interface(DDN.mscorlib.DNObject)
  ['{EE4C722F-91C2-3CDC-B5BA-C6D600A9E961}']
  { methods } 

    ///<overloads>Allows a COM application to load a document.</overloads><summary>
    ///  Allows a COM application to load a <see cref="T:Aspose.Words.Document" />
    ///  from a file.
    ///</summary>
    ///<remarks><p>This method is same as calling the <see cref="T:Aspose.Words.Document" />
    ///  constructor with a file name parameter.</p>
    ///</remarks>
    ///<example><code>
    ///  [VBScript]
    ///  Dim helper
    ///  Set helper = CreateObject("Aspose.Words.ComHelper")
    ///  Dim doc
    ///  Set doc = helper.Open(fileName)
    ///</code></example><param name="fileName">Filename of the document to load.</param>
    ///<returns>A <see cref="T:Aspose.Words.Document" />
    ///  object that represents a Word document.</returns>
    function Open(fileName: string): DNDocument; overload;
    ///<summary>
    ///  Allows a COM application to load <see cref="T:Aspose.Words.Document" />
    ///  from a stream.
    ///</summary>
    ///<remarks><p>This method is same as calling the <see cref="T:Aspose.Words.Document" />
    ///  constructor with a stream parameter.</p>
    ///</remarks>
    ///  <param name="stream">A .NET stream object that contains the document to load.</param>
    ///<returns>A <see cref="T:Aspose.Words.Document" />
    ///  object that represents a Word document.</returns>
    function Open(stream: DDN.mscorlib.DNStream): DNDocument; overload;
    ///<summary>
    ///  Allows a COM application to load a <see cref="T:Aspose.Words.Document" />
    ///  from an IStream object.
    ///</summary>
    ///  <param name="stream">A .NET IStream object that contains the document to load.</param>
    ///<returns>A <see cref="T:Aspose.Words.Document" />
    ///  object that represents a Word document.</returns>
    function OpenIStream(stream: DDN.mscorlib.DNIStream): DNDocument;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNComHelper = class(TDNGenericImport<DNComHelperClass, DNComHelper>) end;

  //-------------namespace: Aspose.Words.Comparing----------------
  DNCompareOptionsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{DBC4FB73-B420-5613-A13E-FA9E0522318E}']
  { constructors } 

    {class} function init: DNCompareOptions;

  end;

  ///<summary>
  ///  Allows to choose advanced options for document comparison operation.
  ///</summary>
  [DNTypeName('Aspose.Words.Comparing.CompareOptions')]
  DNCompareOptions = interface(DDN.mscorlib.DNObject)
  ['{F3CA892E-8D71-3A0F-BA3C-A8D699D5AAC8}']
  { getters & setters } 

    function get_IgnoreCaseChanges: Boolean;
    procedure set_IgnoreCaseChanges(value: Boolean);
    function get_IgnoreTables: Boolean;
    procedure set_IgnoreTables(value: Boolean);
    function get_IgnoreFields: Boolean;
    procedure set_IgnoreFields(value: Boolean);
    function get_IgnoreFootnotes: Boolean;
    procedure set_IgnoreFootnotes(value: Boolean);
    function get_IgnoreComments: Boolean;
    procedure set_IgnoreComments(value: Boolean);
    function get_IgnoreTextboxes: Boolean;
    procedure set_IgnoreTextboxes(value: Boolean);
    function get_IgnoreFormatting: Boolean;
    procedure set_IgnoreFormatting(value: Boolean);
    function get_IgnoreHeadersAndFooters: Boolean;
    procedure set_IgnoreHeadersAndFooters(value: Boolean);
    function get_Target: DNComparisonTargetType;
    procedure set_Target(value: DNComparisonTargetType);
    function get_Granularity: DNGranularity;
    procedure set_Granularity(value: DNGranularity);
    function get_IgnoreDmlUniqueId: Boolean;
    procedure set_IgnoreDmlUniqueId(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  True indicates that documents comparison is case insensitive.
    ///  By default comparison is case sensitive.
    ///</summary>
    property IgnoreCaseChanges: Boolean read get_IgnoreCaseChanges write set_IgnoreCaseChanges;
    ///<summary>
    ///  Specifies whether to compare the differences in data contained in tables.
    ///  By default tables are not ignored.
    ///</summary>
    property IgnoreTables: Boolean read get_IgnoreTables write set_IgnoreTables;
    ///<summary>
    ///  Specifies whether to compare differences in fields.
    ///  By default fields are not ignored.
    ///</summary>
    property IgnoreFields: Boolean read get_IgnoreFields write set_IgnoreFields;
    ///<summary>
    ///  Specifies whether to compare differences in footnotes and endnotes.
    ///  By default footnotes are not ignored.
    ///</summary>
    property IgnoreFootnotes: Boolean read get_IgnoreFootnotes write set_IgnoreFootnotes;
    ///<summary>
    ///  Specifies whether to compare differences in comments.
    ///  By default comments are not ignored.
    ///</summary>
    property IgnoreComments: Boolean read get_IgnoreComments write set_IgnoreComments;
    ///<summary>
    ///  Specifies whether to compare differences in the data contained within text boxes.
    ///  By default textboxes are not ignored.
    ///</summary>
    property IgnoreTextboxes: Boolean read get_IgnoreTextboxes write set_IgnoreTextboxes;
    ///<summary>
    ///  True indicates that formatting is ignored.
    ///  By default document formatting is not ignored.
    ///</summary>
    property IgnoreFormatting: Boolean read get_IgnoreFormatting write set_IgnoreFormatting;
    ///<summary>
    ///  True indicates that headers and footers content is ignored.
    ///  By default headers and footers are not ignored.
    ///</summary>
    property IgnoreHeadersAndFooters: Boolean read get_IgnoreHeadersAndFooters write set_IgnoreHeadersAndFooters;
    ///<summary>
    ///  Specifies which document shall be used as a target during comparison.
    ///</summary>
    property Target: DNComparisonTargetType read get_Target write set_Target;
    ///<summary>
    ///  Specifies whether changes are tracked by character or by word.
    ///  Default value is <see cref="F:Aspose.Words.Comparing.Granularity.WordLevel" />
    ///  .
    ///</summary>
    property Granularity: DNGranularity read get_Granularity write set_Granularity;
    ///<summary>
    ///  Specifies whether to ignore difference in DrawingML unique Id.
    ///  Default value is <b>false</b>
    ///  .
    ///</summary>
    property IgnoreDmlUniqueId: Boolean read get_IgnoreDmlUniqueId write set_IgnoreDmlUniqueId;
  end;

  TDNCompareOptions = class(TDNGenericImport<DNCompareOptionsClass, DNCompareOptions>) end;

  //-------------namespace: Aspose.Words----------------
  DNConditionalStyleClass = interface(DDN.mscorlib.DNObjectClass)
  ['{C8CD1329-F7AD-56A0-80AF-C20220C06048}']
  end;

  ///<summary>
  ///  Represents special formatting applied to some area of a table with assigned table style.
  ///</summary>
  [DNTypeName('Aspose.Words.ConditionalStyle')]
  DNConditionalStyle = interface(DDN.mscorlib.DNObject)
  ['{F4DE8FB8-1690-3A1F-8B7A-4DAB17519A7C}']
  { getters & setters } 

    function get_ParagraphFormat: DNParagraphFormat;
    function get_Font: DNFont;
    function get_Shading: DNShading;
    function get_Borders: DNBorderCollection;
    function get_LeftPadding: Double;
    procedure set_LeftPadding(value: Double);
    function get_RightPadding: Double;
    procedure set_RightPadding(value: Double);
    function get_TopPadding: Double;
    procedure set_TopPadding(value: Double);
    function get_BottomPadding: Double;
    procedure set_BottomPadding(value: Double);
    function get_Type: DNConditionalStyleType;

  { methods } 

    ///<summary>
    ///  Clears formatting of this conditional style.
    ///</summary>
    procedure ClearFormatting;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    ///<summary>
    ///  Calculates hash code for this object.
    ///</summary>
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the paragraph formatting of the conditional style.
    ///</summary>
    property ParagraphFormat: DNParagraphFormat read get_ParagraphFormat;
    ///<summary>
    ///  Gets the character formatting of the conditional style.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Shading" />
    ///  object that refers to the shading formatting for this conditional style.
    ///</summary>
    property Shading: DNShading read get_Shading;
    ///<summary>
    ///  Gets the collection of default cell borders for the conditional style.
    ///</summary>
    property Borders: DNBorderCollection read get_Borders;
    ///<summary>
    ///  Gets or sets the amount of space (in points) to add to the left of the contents of table cells.
    ///</summary>
    property LeftPadding: Double read get_LeftPadding write set_LeftPadding;
    ///<summary>
    ///  Gets or sets the amount of space (in points) to add to the right of the contents of table cells.
    ///</summary>
    property RightPadding: Double read get_RightPadding write set_RightPadding;
    ///<summary>
    ///  Gets or sets the amount of space (in points) to add above the contents of table cells.
    ///</summary>
    property TopPadding: Double read get_TopPadding write set_TopPadding;
    ///<summary>
    ///  Gets or sets the amount of space (in points) to add below the contents of table cells.
    ///</summary>
    property BottomPadding: Double read get_BottomPadding write set_BottomPadding;
    ///<summary>
    ///  Gets table area to which this conditional style relates.
    ///</summary>
    property &Type: DNConditionalStyleType read get_Type;
  end;

  TDNConditionalStyle = class(TDNGenericImport<DNConditionalStyleClass, DNConditionalStyle>) end;

  //-------------namespace: Aspose.Words----------------
  DNConditionalStyleCollectionClass = interface(DNObjectClass)
  ['{7DBB4BDD-E1BD-5F9C-8EC0-CE65D2193603}']
  end;

  ///<summary>
  ///  Represents a collection of <see cref="T:Aspose.Words.ConditionalStyle" />
  ///  objects.
  ///</summary>
  ///<remarks>
  ///  It is not possible to add or remove items from this collection. It contains permanent set of items: one item for
  ///  each value of the <see cref="T:Aspose.Words.ConditionalStyleType" />
  ///  enumeration type.
  ///</remarks>
  ///<dev>
  ///  With using public properties of the class, it is possible to get only conditional styles that correspond to items
  ///  of the <see cref="T:Aspose.Words.ConditionalStyleType" />
  ///  enumeration type. But a collection may contain also styles related
  ///  to <see cref="F:Aspose.Words.TableStyleOverrideType.None" />
  ///  and <see cref="F:Aspose.Words.TableStyleOverrideType.WholeTable" />
  ///  values, use the
  ///  this[TableStyleOverrideType] or <see cref="P:Aspose.Words.ConditionalStyleCollection.DefinedStyles" />
  ///  properties to get them.
  ///</dev>
  [DNTypeName('Aspose.Words.ConditionalStyleCollection')]
  DNConditionalStyleCollection = interface(DDN.mscorlib.DNIEnumerable)
  ['{BFECBE31-AD54-3C87-8717-F2DA7E478E10}']
  { getters & setters } 

    function get_Item(conditionalStyleType: DNConditionalStyleType): DNConditionalStyle; overload;
    function get_Item(index: Int32): DNConditionalStyle; overload;
    function get_Count: Int32;
    function get_FirstRow: DNConditionalStyle;
    function get_FirstColumn: DNConditionalStyle;
    function get_LastRow: DNConditionalStyle;
    function get_LastColumn: DNConditionalStyle;
    function get_OddRowBanding: DNConditionalStyle;
    function get_OddColumnBanding: DNConditionalStyle;
    function get_EvenRowBanding: DNConditionalStyle;
    function get_EvenColumnBanding: DNConditionalStyle;
    function get_TopLeftCell: DNConditionalStyle;
    function get_TopRightCell: DNConditionalStyle;
    function get_BottomLeftCell: DNConditionalStyle;
    function get_BottomRightCell: DNConditionalStyle;

  { methods } 

    ///<summary>
    ///  Clears all conditional styles of the table style.
    ///</summary>
    procedure ClearFormatting;
    ///<summary>
    ///  Returns an enumerator object that can be used to iterate over all conditional styles in the collection.
    ///</summary>
    ///<dev>
    ///  Conditional styles related to <see cref="F:Aspose.Words.TableStyleOverrideType.None" />
    ///  and
    ///<see cref="F:Aspose.Words.TableStyleOverrideType.WholeTable" />
    ///  values are not included into the enumeration.
    ///</dev>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNConditionalStyle>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[conditionalStyleType: DNConditionalStyleType]: DNConditionalStyle read get_Item; default;
    property Item[index: Int32]: DNConditionalStyle read get_Item; default;
    ///<summary>
    ///  Gets the number of conditional styles in the collection.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Gets the first row style.
    ///</summary>
    property FirstRow: DNConditionalStyle read get_FirstRow;
    ///<summary>
    ///  Gets the first column style.
    ///</summary>
    property FirstColumn: DNConditionalStyle read get_FirstColumn;
    ///<summary>
    ///  Gets the last row style.
    ///</summary>
    property LastRow: DNConditionalStyle read get_LastRow;
    ///<summary>
    ///  Gets the last column style.
    ///</summary>
    property LastColumn: DNConditionalStyle read get_LastColumn;
    ///<summary>
    ///  Gets the odd row banding style.
    ///</summary>
    property OddRowBanding: DNConditionalStyle read get_OddRowBanding;
    ///<summary>
    ///  Gets the odd column banding style.
    ///</summary>
    property OddColumnBanding: DNConditionalStyle read get_OddColumnBanding;
    ///<summary>
    ///  Gets the even row banding style.
    ///</summary>
    property EvenRowBanding: DNConditionalStyle read get_EvenRowBanding;
    ///<summary>
    ///  Gets the even column banding style.
    ///</summary>
    property EvenColumnBanding: DNConditionalStyle read get_EvenColumnBanding;
    ///<summary>
    ///  Gets the top left cell style.
    ///</summary>
    property TopLeftCell: DNConditionalStyle read get_TopLeftCell;
    ///<summary>
    ///  Gets the top right cell style.
    ///</summary>
    property TopRightCell: DNConditionalStyle read get_TopRightCell;
    ///<summary>
    ///  Gets the bottom left cell style.
    ///</summary>
    property BottomLeftCell: DNConditionalStyle read get_BottomLeftCell;
    ///<summary>
    ///  Gets the bottom right cell style.
    ///</summary>
    property BottomRightCell: DNConditionalStyle read get_BottomRightCell;
  end;

  TDNConditionalStyleCollection = class(TDNGenericImport<DNConditionalStyleCollectionClass, DNConditionalStyleCollection>) end;

  //-------------namespace: Aspose.Words----------------
  DNControlCharClass = interface(DDN.mscorlib.DNObjectClass)
  ['{3BBA41D5-FD36-5EAA-9EA9-684BD011DF07}']
  { static fields getter & setter } 

   function __fakeFieldGet_Cell: string;
   function __fakeFieldGet_Tab: string;
   function __fakeFieldGet_Lf: string;
   function __fakeFieldGet_LineFeed: string;
   function __fakeFieldGet_LineBreak: string;
   function __fakeFieldGet_PageBreak: string;
   function __fakeFieldGet_SectionBreak: string;
   function __fakeFieldGet_Cr: string;
   function __fakeFieldGet_ParagraphBreak: string;
   function __fakeFieldGet_ColumnBreak: string;
   function __fakeFieldGet_CrLf: string;
   function __fakeFieldGet_NonBreakingSpace: string;

  { static fields } 

    ///<summary>
    ///  End of a table cell or end of a table row character: "\x0007" or "\a".
    ///</summary>
    {class} property Cell: string read __fakeFieldGet_Cell;
    ///<summary>
    ///  Tab character: "\x0009" or "\t".
    ///</summary>
    {class} property Tab: string read __fakeFieldGet_Tab;
    ///<summary>
    ///  Line feed character: "\x000a" or "\n". Same as <see cref="F:Aspose.Words.ControlChar.LineFeed" />
    ///  .
    ///</summary>
    {class} property Lf: string read __fakeFieldGet_Lf;
    ///<summary>
    ///  Line feed character: "\x000a" or "\n". Same as <see cref="F:Aspose.Words.ControlChar.Lf" />
    ///  .
    ///</summary>
    {class} property LineFeed: string read __fakeFieldGet_LineFeed;
    ///<summary>
    ///  Line break character: "\x000b" or "\v".
    ///</summary>
    {class} property LineBreak: string read __fakeFieldGet_LineBreak;
    ///<summary>
    ///  Page break character: "\x000c" or "\f". Note it has the same value as <see cref="F:Aspose.Words.ControlChar.SectionBreak" />
    ///  .
    ///</summary>
    {class} property PageBreak: string read __fakeFieldGet_PageBreak;
    ///<summary>
    ///  End of section character: "\x000c" or "\f". Note it has the same value as <see cref="F:Aspose.Words.ControlChar.PageBreak" />
    ///  .
    ///</summary>
    {class} property SectionBreak: string read __fakeFieldGet_SectionBreak;
    ///<summary>
    ///  Carriage return character: "\x000d" or "\r". Same as <see cref="F:Aspose.Words.ControlChar.ParagraphBreak" />
    ///  .
    ///</summary>
    {class} property Cr: string read __fakeFieldGet_Cr;
    ///<summary>
    ///  End of paragraph character: "\x000d" or "\r". Same as <see cref="F:Aspose.Words.ControlChar.Cr" />
    ///</summary>
    {class} property ParagraphBreak: string read __fakeFieldGet_ParagraphBreak;
    ///<summary>
    ///  End of column character: "\x000e".
    ///</summary>
    {class} property ColumnBreak: string read __fakeFieldGet_ColumnBreak;
    ///<summary>
    ///  Carriage return followed by line feed character: "\x000d\x000a" or "\r\n".
    ///  Not used as such in Microsoft Word documents, but commonly used in text files for paragraph breaks.
    ///</summary>
    {class} property CrLf: string read __fakeFieldGet_CrLf;
    ///<summary>
    ///  Non-breaking space character: "\x00a0".
    ///</summary>
    {class} property NonBreakingSpace: string read __fakeFieldGet_NonBreakingSpace;

  end;

  ///<summary>
  ///  Control characters often encountered in documents.
  ///</summary>
  ///<remarks>
  ///  Provides both char and string versions of the same constants. For example:
  ///  string ControlChar.LineBreak and char ControlChar.LineBreakChar have the same value.
  ///</remarks>
  [DNTypeName('Aspose.Words.ControlChar')]
  DNControlChar = interface(DDN.mscorlib.DNObject)
  ['{A3A4C162-93EE-3557-8FF3-B24C00E3E5D2}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNControlChar = class(TDNGenericImport<DNControlCharClass, DNControlChar>)
  public const
    ///<summary>
    ///  End of a table cell or end of a table row character: (char)7 or "\a".
    ///</summary>
   CellChar = #7;
    ///<summary>
    ///  Tab character: (char)9 or "\t".
    ///</summary>
   TabChar = #9;
    ///<summary>
    ///  Line feed character: (char)10 or "\n".
    ///</summary>
   LineFeedChar = #10;
    ///<summary>
    ///  Line break character: (char)11 or "\v".
    ///</summary>
   LineBreakChar = #11;
    ///<summary>
    ///  Page break character: (char)12 or "\f".
    ///</summary>
   PageBreakChar = #12;
    ///<summary>
    ///  End of section character: (char)12 or "\f".
    ///</summary>
   SectionBreakChar = #12;
    ///<summary>
    ///  End of paragraph character: (char)13 or "\r".
    ///</summary>
   ParagraphBreakChar = #13;
    ///<summary>
    ///  End of column character: (char)14.
    ///</summary>
   ColumnBreakChar = #14;
    ///<summary>
    ///  Start of MS Word field character: (char)19.
    ///</summary>
   FieldStartChar = #19;
    ///<summary>
    ///  Field separator character separates field code from field value. Optional in some fields. Value: (char)20.
    ///</summary>
   FieldSeparatorChar = #20;
    ///<summary>
    ///  End of MS Word field character: (char)21.
    ///</summary>
   FieldEndChar = #21;
    ///<summary>
    ///  Nonbreaking Hyphen in Microsoft Word is (char)30.
    ///</summary>
    ///<remarks><p>Nonbreaking Hyphen in Microsoft Word does not correspond to the
    ///  Unicode character U+2011 non-breaking hyphen but instead represents
    ///  internal information that tells Microsoft Word to display a hyphen and not to break a line.</p>
    ///  <p>Useful info: http://www.cs.tut.fi/~jkorpela/dashes.html#linebreaks.</p>
    ///</remarks>
   NonBreakingHyphenChar = #30;
    ///<summary>
    ///  Optional Hyphen in Microsoft Word is (char)31.
    ///</summary>
    ///<remarks><p>Optional Hyphen in Microsoft Word does not correspond to the Unicode character U+00AD soft hyphen.
    ///  Instead, it inserts internal information that tells Word about a possible hyphenation point.</p>
    ///</remarks>
   OptionalHyphenChar = #31;
    ///<summary>
    ///  Space character: (char)32.
    ///</summary>
   SpaceChar = #32;
    ///<summary>
    ///  Non-breaking space character: (char)160.
    ///</summary>
   NonBreakingSpaceChar = #160;
    ///<summary>
    ///  This is the "o" character used as a default value in text input form fields.
    ///</summary>
   DefaultTextInputChar = #8194;
  end;

  //-------------namespace: Aspose.Words----------------
  DNConvertUtilClass = interface(DDN.mscorlib.DNObjectClass)
  ['{281DA24C-F1B2-5C43-BDE6-3C94C94D4A75}']
  { static methods } 

    ///<overloads>Converts points to pixels.</overloads><summary>
    ///  Converts points to pixels at 96 dpi.
    ///</summary>
    ///  <param name="points">The value to convert.</param>
    ///<remarks>
    ///  1 inch equals 72 points.
    ///</remarks>
    {class} function PointToPixel(points: Double): Double; overload;
    ///<summary>
    ///  Converts points to pixels at the specified pixel resolution.
    ///</summary>
    ///  <param name="points">The value to convert.</param>
    ///  <param name="resolution">The dpi (dots per inch) resolution.</param>
    ///<remarks>
    ///  1 inch equals 72 points.
    ///</remarks>
    {class} function PointToPixel(points: Double; resolution: Double): Double; overload;
    ///<overloads>Converts pixels to points.</overloads><summary>
    ///  Converts pixels to points at 96 dpi.
    ///</summary>
    ///  <param name="pixels">The value to convert.</param>
    ///<remarks>
    ///  1 inch equals 72 points.
    ///</remarks>
    {class} function PixelToPoint(pixels: Double): Double; overload;
    ///<summary>
    ///  Converts pixels to points at the specified pixel resolution.
    ///</summary>
    ///  <param name="pixels">The value to convert.</param>
    ///  <param name="resolution">The dpi (dots per inch) resolution.</param>
    ///<remarks>
    ///  1 inch equals 72 points.
    ///</remarks>
    {class} function PixelToPoint(pixels: Double; resolution: Double): Double; overload;
    ///<summary>
    ///  Converts pixels from one resolution to another.
    ///</summary>
    ///  <param name="pixels">The value to convert.</param>
    ///  <param name="oldDpi">The current dpi (dots per inch) resolution.</param>
    ///  <param name="newDpi">The new dpi (dots per inch) resolution.</param>
    {class} function PixelToNewDpi(pixels: Double; oldDpi: Double; newDpi: Double): Int32;
    ///<summary>
    ///  Converts inches to points.
    ///</summary>
    ///  <param name="inches">The value to convert.</param>
    ///<remarks>
    ///  1 inch equals 72 points.
    ///</remarks>
    {class} function InchToPoint(inches: Double): Double;
    ///<summary>
    ///  Converts points to inches.
    ///</summary>
    ///  <param name="points">The value to convert.</param>
    ///<remarks>
    ///  1 inch equals 72 points.
    ///</remarks>
    {class} function PointToInch(points: Double): Double;
    ///<summary>
    ///  Converts millimeters to points.
    ///</summary>
    ///  <param name="millimeters">The value to convert.</param>
    ///<remarks>
    ///  1 inch equals 25.4 millimeters. 1 inch equals 72 points.
    ///</remarks>
    {class} function MillimeterToPoint(millimeters: Double): Double;

  end;

  ///<summary>
  ///  Provides helper functions to convert between various measurement units.
  ///</summary>
  ///<dev>
  ///  This is only a public wrapper that makes functions available in the public Aspose.Words namespace.
  ///  The actual implementation is in <see cref="T:Aspose.ConvertUtilCore" />
  ///  .
  ///</dev>
  [DNTypeName('Aspose.Words.ConvertUtil')]
  DNConvertUtil = interface(DDN.mscorlib.DNObject)
  ['{6BBCC53D-4605-3326-A641-EFC1F8243239}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNConvertUtil = class(TDNGenericImport<DNConvertUtilClass, DNConvertUtil>) end;

  //-------------namespace: Aspose.Words.DigitalSignatures----------------
  DNCertificateHolderClass = interface(DDN.mscorlib.DNObjectClass)
  ['{0F7FF78E-89BD-5AE5-B79C-84D9ABB4CE77}']
  { static methods } 

    ///<summary>
    ///  Creates CertificateHolder object using byte array of PKCS12 store and its password.
    ///</summary>
    ///  <param name="certBytes">A byte array that contains data from an X.509 certificate.</param>
    ///  <param name="password">The password required to access the X.509 certificate data.</param>
    ///<returns>An instance of CertificateHolder</returns>
    ///<exception cref="T:Org.BouncyCastle.Security.InvalidParameterException">Thrown if <b>certBytes</b>
    ///  is null</exception><exception cref="T:Org.BouncyCastle.Security.InvalidParameterException">Thrown if <b>password</b>
    ///  is null</exception><exception cref="T:System.Security.SecurityException">Thrown if PKCS12 store contains no aliases</exception><exception cref="T:System.IO.IOException">Thrown if there is wrong password or corrupted file.</exception>
    {class} function Create(certBytes: TArray<Byte>; password: DDN.mscorlib.DNSecureString): DNCertificateHolder; overload;
    ///<summary>
    ///  Creates CertificateHolder object using byte array of PKCS12 store and its password.
    ///</summary>
    ///  <param name="certBytes">A byte array that contains data from an X.509 certificate.</param>
    ///  <param name="password">The password required to access the X.509 certificate data.</param>
    ///<returns>An instance of CertificateHolder</returns>
    ///<exception cref="T:Org.BouncyCastle.Security.InvalidParameterException">Thrown if <b>certBytes</b>
    ///  is null</exception><exception cref="T:Org.BouncyCastle.Security.InvalidParameterException">Thrown if <b>password</b>
    ///  is null</exception><exception cref="T:System.Security.SecurityException">Thrown if PKCS12 store contains no aliases</exception><exception cref="T:System.IO.IOException">Thrown if there is wrong password or corrupted file.</exception>
    {class} function Create(certBytes: TArray<Byte>; password: string): DNCertificateHolder; overload;
    ///<summary>
    ///  Creates CertificateHolder object using path to PKCS12 store and its password.
    ///</summary>
    ///  <param name="fileName">The name of a certificate file.</param>
    ///  <param name="password">The password required to access the X.509 certificate data.</param>
    ///<returns>An instance of CertificateHolder</returns>
    ///<exception cref="T:Org.BouncyCastle.Security.InvalidParameterException">Thrown if <b>fileName</b>
    ///  is null</exception><exception cref="T:Org.BouncyCastle.Security.InvalidParameterException">Thrown if <b>password</b>
    ///  is null</exception><exception cref="T:System.Security.SecurityException">Thrown if PKCS12 store contains no aliases</exception><exception cref="T:System.IO.IOException">Thrown if there is wrong password or corrupted file.</exception>
    {class} function Create(fileName: string; password: string): DNCertificateHolder; overload;
    ///<summary>
    ///  Creates CertificateHolder object using path to PKCS12 store, its password and the alias by using which private key and certificate will be found.
    ///</summary>
    ///  <param name="fileName">The name of a certificate file.</param>
    ///  <param name="password">The password required to access the X.509 certificate data.</param>
    ///  <param name="alias">The associated alias for a certificate and its private key</param>
    ///<returns>An instance of CertificateHolder</returns>
    ///<exception cref="T:Org.BouncyCastle.Security.InvalidParameterException">Thrown if <b>fileName</b>
    ///  is null</exception><exception cref="T:Org.BouncyCastle.Security.InvalidParameterException">Thrown if <b>password</b>
    ///  is null</exception><exception cref="T:System.Security.SecurityException">Thrown if PKCS12 store contains no aliases</exception><exception cref="T:System.IO.IOException">Thrown if there is wrong password or corrupted file.</exception><exception cref="T:System.Security.SecurityException">Thrown if there is no private key with the given alias</exception>
    {class} function Create(fileName: string; password: string; alias: string): DNCertificateHolder; overload;

  end;

  ///<summary>
  ///  Represents a holder of <b>X509Certificate2</b>
  ///  instance.
  ///</summary>
  ///<remarks><p><b>CertificateHolder</b>
  ///  can be created by static factory methods only.
  ///  It contains an instance of <b>X509Certificate2</b>
  ///  which is used to introduce private, public keys and certificate chains into the system.
  ///  This class is applied in <see cref="T:Aspose.Words.DigitalSignatures.DigitalSignatureUtil" />
  ///  and <see cref="T:Aspose.Words.Saving.PdfDigitalSignatureDetails" />
  ///  instead of obsolete methods with
  ///<see cref="T:System.Security.Cryptography.X509Certificates.X509Certificate2" />
  ///  as parameters.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.DigitalSignatures.CertificateHolder')]
  DNCertificateHolder = interface(DDN.mscorlib.DNObject)
  ['{D8247497-DB88-3EE7-9B46-79E1F9570335}']
  { getters & setters } 

    function get_Certificate: DDN.System.DNX509Certificate2;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Returns the instance of <b>X509Certificate2</b>
    ///  which holds private, public keys and certificate chain.
    ///</summary>
    ///<returns><see cref="T:System.Security.Cryptography.X509Certificates.X509Certificate2" />
    ///  instance</returns>
    property Certificate: DDN.System.DNX509Certificate2 read get_Certificate;
  end;

  TDNCertificateHolder = class(TDNGenericImport<DNCertificateHolderClass, DNCertificateHolder>) end;

  //-------------namespace: Aspose.Words.DigitalSignatures----------------
  DNDigitalSignatureClass = interface(DDN.mscorlib.DNObjectClass)
  ['{71A100C2-B423-545D-9080-1B04885C8474}']
  end;

  ///<summary>
  ///  Represents a digital signature on a document and the result of its verification.
  ///</summary>
  [DNTypeName('Aspose.Words.DigitalSignatures.DigitalSignature')]
  DNDigitalSignature = interface(DDN.mscorlib.DNObject)
  ['{BC6E8F6B-92DC-3CC1-BDD6-D898F72C81AA}']
  { getters & setters } 

    function get_SignatureType: DNDigitalSignatureType;
    function get_SignTime: DDN.mscorlib.DNDateTime;
    function get_Comments: string;
    function get_SubjectName: string;
    function get_IssuerName: string;
    function get_IsValid: Boolean;
    function get_CertificateHolder: DNCertificateHolder;

  { methods } 

    ///<summary>
    ///  Returns a user-friendly string that displays the value of this object.
    ///</summary>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the type of the digital signature.
    ///</summary>
    property SignatureType: DNDigitalSignatureType read get_SignatureType;
    ///<summary>
    ///  Gets the time the document was signed.
    ///</summary>
    property SignTime: DDN.mscorlib.DNDateTime read get_SignTime;
    ///<summary>
    ///  Gets the signing purpose comment.
    ///</summary>
    property Comments: string read get_Comments;
    ///<summary>
    ///  Returns the subject distinguished name of the certificate that was used to sign the document.
    ///</summary>
    property SubjectName: string read get_SubjectName;
    ///<summary>
    ///  Returns the subject distinguished name of the certificate isuuer.
    ///</summary>
    property IssuerName: string read get_IssuerName;
    ///<summary>
    ///  Returns true if this digital signature is valid and the document has not been tampered with.
    ///</summary>
    property IsValid: Boolean read get_IsValid;
    ///<summary>
    ///  Returns the certificate holder object that contains the certificate was used to sign the document.
    ///</summary>
    property CertificateHolder: DNCertificateHolder read get_CertificateHolder;
  end;

  TDNDigitalSignature = class(TDNGenericImport<DNDigitalSignatureClass, DNDigitalSignature>) end;

  //-------------namespace: Aspose.Words.DigitalSignatures----------------
  DNDigitalSignatureCollectionClass = interface(DNObjectClass)
  ['{2EB7ED37-40D8-5025-929A-60CEBE106FEC}']
  { constructors } 

    {class} function init: DNDigitalSignatureCollection;

  end;

  ///<summary>
  ///  Provides a read-only collection of digital signatures attached to a document.
  ///</summary>
  ///<remarks><see cref="P:Aspose.Words.Document.DigitalSignatures" />
  ///</remarks>
  [DNTypeName('Aspose.Words.DigitalSignatures.DigitalSignatureCollection')]
  DNDigitalSignatureCollection = interface(DDN.mscorlib.DNIEnumerable)
  ['{DA3CCA37-3AE8-3B09-9527-FA34D7FA7E85}']
  { getters & setters } 

    function get_IsValid: Boolean;
    function get_Count: Int32;
    function get_Item(index: Int32): DNDigitalSignature;

  { methods } 

    ///<summary>
    ///  Returns a dictionary enumerator object that can be used to iterate over all items in the collection.
    ///</summary>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNDigitalSignature>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Returns <c>true</c> if all digital signatures in this collection are valid and the document has not been tampered with
    ///  Also returns <c>true</c> if there are no digital signatures.
    ///  Returns <c>false</c> if at least one digital signature is invalid.
    ///</summary>
    property IsValid: Boolean read get_IsValid;
    ///<summary>
    ///  Gets the number of elements contained in the collection.
    ///</summary>
    property Count: Int32 read get_Count;
    property Item[index: Int32]: DNDigitalSignature read get_Item; default;
  end;

  TDNDigitalSignatureCollection = class(TDNGenericImport<DNDigitalSignatureCollectionClass, DNDigitalSignatureCollection>) end;

  //-------------namespace: Aspose.Words.DigitalSignatures----------------
  DNDigitalSignatureUtilClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F07A1E73-E2BC-5292-B508-AAAE96DD6D9D}']
  { static methods } 

    ///<summary>
    ///  Signs source document using given <see cref="T:Aspose.Words.DigitalSignatures.CertificateHolder" />
    ///  and <see cref="T:Aspose.Words.DigitalSignatures.SignOptions" />
    ///  with digital signature and writes signed document to destination stream.
    ///  <p>Document should be either <see cref="F:Aspose.Words.LoadFormat.Doc" />
    ///  or <see cref="F:Aspose.Words.LoadFormat.Docx" />
    ///  .</p>
    ///  <p><b>Output will be written to the start of stream and stream size will be updated with content length.</b>
    ///</p>
    ///</summary>
    ///  <param name="srcStream">The stream which contains the document to sign.</param>
    ///  <param name="dstStream">The stream that signed document will be written to.</param>
    ///  <param name="certHolder"><see cref="T:Aspose.Words.DigitalSignatures.CertificateHolder" />
    ///  object with certificate that used to sign file.
    ///  The certificate in holder MUST contain private keys and have the X509KeyStorageFlags.Exportable flag set.</param>
    ///  <param name="signOptions"><see cref="T:Aspose.Words.DigitalSignatures.SignOptions" />
    ///  object with various signing options.</param>
    {class} procedure Sign(srcStream: DDN.mscorlib.DNStream; dstStream: DDN.mscorlib.DNStream; certHolder: DNCertificateHolder; signOptions: DNSignOptions); overload;
    ///<summary>
    ///  Signs source document using given <see cref="T:Aspose.Words.DigitalSignatures.CertificateHolder" />
    ///  and <see cref="T:Aspose.Words.DigitalSignatures.SignOptions" />
    ///  with digital signature and writes signed document to destination file.
    ///  <p>Document should be either <see cref="F:Aspose.Words.LoadFormat.Doc" />
    ///  or <see cref="F:Aspose.Words.LoadFormat.Docx" />
    ///  .</p>
    ///</summary>
    ///  <param name="srcFileName">The file name of the document to sign.</param>
    ///  <param name="dstFileName">The file name of the signed document output.</param>
    ///  <param name="certHolder"><see cref="T:Aspose.Words.DigitalSignatures.CertificateHolder" />
    ///  object with certificate that used to sign file.
    ///  The certificate in holder MUST contain private keys and have the X509KeyStorageFlags.Exportable flag set.</param>
    ///  <param name="signOptions"><see cref="T:Aspose.Words.DigitalSignatures.SignOptions" />
    ///  object with various signing options.</param>
    {class} procedure Sign(srcFileName: string; dstFileName: string; certHolder: DNCertificateHolder; signOptions: DNSignOptions); overload;
    ///<summary>
    ///  Signs source document using given <see cref="T:Aspose.Words.DigitalSignatures.CertificateHolder" />
    ///  with digital signature
    ///  and writes signed document to destination stream.
    ///  <p>Document should be either <see cref="F:Aspose.Words.LoadFormat.Doc" />
    ///  or <see cref="F:Aspose.Words.LoadFormat.Docx" />
    ///  .</p>
    ///  <p><b>Output will be written to the start of stream and stream size will be updated with content length.</b>
    ///</p>
    ///</summary>
    ///  <param name="srcStream">The stream which contains the document to sign.</param>
    ///  <param name="dstStream">The stream that signed document will be written to.</param>
    ///  <param name="certHolder"><see cref="T:Aspose.Words.DigitalSignatures.CertificateHolder" />
    ///  object with certificate that used to sign file.
    ///  The certificate in holder MUST contain private keys and have the X509KeyStorageFlags.Exportable flag set.</param>
    {class} procedure Sign(srcStream: DDN.mscorlib.DNStream; dstStream: DDN.mscorlib.DNStream; certHolder: DNCertificateHolder); overload;
    ///<summary>
    ///  Signs source document using given <see cref="T:Aspose.Words.DigitalSignatures.CertificateHolder" />
    ///  with digital signature
    ///  and writes signed document to destination file.
    ///  <p>Document should be either <see cref="F:Aspose.Words.LoadFormat.Doc" />
    ///  or <see cref="F:Aspose.Words.LoadFormat.Docx" />
    ///  .</p>
    ///</summary>
    ///  <param name="srcFileName">The file name of the document to sign.</param>
    ///  <param name="dstFileName">The file name of the signed document output.</param>
    ///  <param name="certHolder"><see cref="T:Aspose.Words.DigitalSignatures.CertificateHolder" />
    ///  object with certificate that used to sign file.
    ///  The certificate in holder MUST contain private keys and have the X509KeyStorageFlags.Exportable flag set.</param>
    {class} procedure Sign(srcFileName: string; dstFileName: string; certHolder: DNCertificateHolder); overload;
    ///<summary>
    ///  Removes all digital signatures from source file and writes unsigned file to destination file.
    ///</summary>
    {class} procedure RemoveAllSignatures(srcFileName: string; dstFileName: string); overload;
    ///<summary>
    ///  Removes all digital signatures from document in source stream and writes unsigned document to destination stream.
    ///  <p><b>Output will be written to the start of stream and stream size will be updated with content length.</b>
    ///</p>
    ///</summary>
    {class} procedure RemoveAllSignatures(srcStream: DDN.mscorlib.DNStream; dstStream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Loads digital signatures from document.
    ///</summary>
    ///  <param name="fileName">Path to the document.</param>
    ///<returns>Collection of digital signatures. Returns empty collection if file is not signed.</returns>
    {class} function LoadSignatures(fileName: string): DNDigitalSignatureCollection; overload;
    ///<summary>
    ///  Loads digital signatures from document using stream.
    ///</summary>
    ///  <param name="stream">Stream with the document.</param>
    ///<returns>Collection of digital signatures. Returns empty collection if file is not signed.</returns>
    {class} function LoadSignatures(stream: DDN.mscorlib.DNStream): DNDigitalSignatureCollection; overload;

  end;

  ///<summary>
  ///  Provides methods for signing document.
  ///</summary>
  ///<remarks><para>Since digital signature works with file content rather than Document Object Model these methods are put into a separate class.</para><para>Supported formats are <see cref="F:Aspose.Words.LoadFormat.Doc" />
  ///  and <see cref="F:Aspose.Words.LoadFormat.Docx" />
  ///  .</para></remarks>
  [DNTypeName('Aspose.Words.DigitalSignatures.DigitalSignatureUtil')]
  DNDigitalSignatureUtil = interface(DDN.mscorlib.DNObject)
  ['{01413692-5DB2-343B-9F33-D523120B3D4F}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNDigitalSignatureUtil = class(TDNGenericImport<DNDigitalSignatureUtilClass, DNDigitalSignatureUtil>) end;

  //-------------namespace: Aspose.Words.DigitalSignatures----------------
  DNSignOptionsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{3D5604AE-10A1-509A-B15E-5DAE0BB02FF6}']
  { constructors } 

    {class} function init: DNSignOptions;

  end;

  ///<summary>
  ///  Allows to specify options for document signing.
  ///</summary>
  [DNTypeName('Aspose.Words.DigitalSignatures.SignOptions')]
  DNSignOptions = interface(DDN.mscorlib.DNObject)
  ['{BA08ED92-4B65-3997-8C2A-35D5BFF261F8}']
  { getters & setters } 

    function get_Comments: string;
    procedure set_Comments(value: string);
    function get_SignTime: DDN.mscorlib.DNDateTime;
    procedure set_SignTime(value: DDN.mscorlib.DNDateTime);
    function get_SignatureLineId: DDN.mscorlib.DNGuid;
    procedure set_SignatureLineId(value: DDN.mscorlib.DNGuid);
    function get_SignatureLineImage: TArray<Byte>;
    procedure set_SignatureLineImage(value: TArray<Byte>);
    function get_DecryptionPassword: string;
    procedure set_DecryptionPassword(value: string);
    function get_ProviderId: DDN.mscorlib.DNGuid;
    procedure set_ProviderId(value: DDN.mscorlib.DNGuid);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Specifies comments on the digital signature.
    ///  Default value is <b>empty string</b>
    ///  (<see cref="F:System.String.Empty" />
    ///  ).
    ///</summary>
    property Comments: string read get_Comments write set_Comments;
    ///<summary>
    ///  The date of signing.
    ///  Default value is <b>current time</b>
    ///  (<see cref="P:System.DateTime.Now" />
    ///  ).
    ///</summary>
    property SignTime: DDN.mscorlib.DNDateTime read get_SignTime write set_SignTime;
    ///<summary>
    ///  Signature line identifier.
    ///  Default value is <b>Empty (all zeroes) Guid</b>
    ///  .
    ///</summary>
    ///<remarks>
    ///  When set, it associates <see cref="T:Aspose.Words.Drawing.SignatureLine" />
    ///  with corresponding <see cref="T:Aspose.Words.DigitalSignatures.DigitalSignature" />
    ///  .
    ///</remarks>
    property SignatureLineId: DDN.mscorlib.DNGuid read get_SignatureLineId write set_SignatureLineId;
    ///<summary>
    ///  The image that will be shown in associated <see cref="T:Aspose.Words.Drawing.SignatureLine" />
    ///  .
    ///  Default value is <c>null</c>.
    ///</summary>
    property SignatureLineImage: TArray<Byte> read get_SignatureLineImage write set_SignatureLineImage;
    ///<summary>
    ///  The password to decrypt source document.
    ///  Default value is <b>empty string</b>
    ///  (<see cref="F:System.String.Empty" />
    ///  ).
    ///</summary>
    ///<remarks>
    ///  If OOXML document is encrypted, you should provide decryption password
    ///  to decrypt source document before it will be signed.
    ///  This is not required for documents in binary DOC format.
    ///</remarks>
    property DecryptionPassword: string read get_DecryptionPassword write set_DecryptionPassword;
    ///<summary>
    ///  Specifies the class ID of the signature provider.
    ///  Default value is <b>Empty (all zeroes) Guid</b>
    ///  .
    ///</summary>
    ///<remarks><para>The cryptographic service provider (CSP) is an independent software module that actually performs
    ///  cryptography algorithms for authentication, encoding, and encryption. MS Office reserves the value
    ///  of {00000000-0000-0000-0000-000000000000} for its default signature provider.</para><para>The GUID of the additionally installed provider should be obtained from the documentation shipped with the provider.</para><para>In addition, all the installed cryptographic providers are enumerated in windows registry.
    ///  It can be found in the following path: HKLM\SOFTWARE\Microsoft\Cryptography\Defaults\Provider.
    ///  There is a key name "CP Service UUID" which corresponds to a GUID of signature provider.</para></remarks>
    property ProviderId: DDN.mscorlib.DNGuid read get_ProviderId write set_ProviderId;
  end;

  TDNSignOptions = class(TDNGenericImport<DNSignOptionsClass, DNSignOptions>) end;

  //-------------namespace: Aspose.Words----------------
  DNDocumentBuilderClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B4E7D328-171B-573A-AE62-F34665482B6E}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of this class.
    ///</summary>
    ///<remarks>
    ///  Creates a new <b>DocumentBuilder</b>
    ///  object and attaches it to a new <see cref="P:Aspose.Words.DocumentBuilder.Document" />
    ///  object.
    ///</remarks>
    {class} function init: DNDocumentBuilder; overload;
    ///<summary>
    ///  Initializes a new instance of this class.
    ///</summary>
    ///<remarks>
    ///  Creates a new <b>DocumentBuilder</b>
    ///  object, attaches to the specified <see cref="P:Aspose.Words.DocumentBuilder.Document" />
    ///  object.
    ///  The cursor is positioned at the beginning of the document.
    ///</remarks>
    ///  <param name="doc">The Document object to attach to.</param>
    {class} function init(doc: DNDocument): DNDocumentBuilder; overload;

  end;

  ///<summary>
  ///  Provides methods to insert text, images and other content, specify font, paragraph and section formatting.
  ///</summary>
  ///<remarks><p><b>DocumentBuilder</b>
  ///  makes the process of building a <b>Document</b>
  ///  easier.
  ///<b>Document</b>
  ///  is a composite object consisting of a tree of nodes and while inserting content
  ///  nodes directly into the tree is possible, it requires good understanding of the tree structure.
  ///<b>DocumentBuilder</b>
  ///  is a "facade" for the complex structure of <b>Document</b>
  ///  and allows
  ///  to insert content and formatting quickly and easily.</p>
  ///  <p>Create a <b>DocumentBuilder</b>
  ///  and associate it with a <see cref="P:Aspose.Words.DocumentBuilder.Document" />
  ///  .</p>
  ///  <p>The <b>DocumentBuilder</b>
  ///  has an internal cursor where the text will be inserted
  ///  when you call <see cref="M:Aspose.Words.DocumentBuilder.Write(System.String)" />
  ///  , <see cref="M:Aspose.Words.DocumentBuilder.Writeln(System.String)" />
  ///  , <see cref="M:Aspose.Words.DocumentBuilder.InsertBreak(Aspose.Words.BreakType)" />
  ///  and other methods. You can navigate the <b>DocumentBuilder</b>
  ///  cursor to a different location
  ///  in a document using various MoveToXXX methods.</p>
  ///  <p>Use the <see cref="P:Aspose.Words.DocumentBuilder.Font" />
  ///  property to specify character formatting that will apply to
  ///  all text inserted from the current position in the document onwards.</p>
  ///  <p>Use the <see cref="P:Aspose.Words.DocumentBuilder.ParagraphFormat" />
  ///  property to specify paragraph formatting for the current
  ///  and all paragraphs that will be inserted.</p>
  ///  <p>Use the <see cref="P:Aspose.Words.DocumentBuilder.PageSetup" />
  ///  property to specify page and section properties for the current
  ///  section and all section that will be inserted.</p>
  ///  <p>Use the <see cref="P:Aspose.Words.DocumentBuilder.CellFormat" />
  ///  and <see cref="P:Aspose.Words.DocumentBuilder.RowFormat" />
  ///  properties to specify
  ///  formatting properties for table cells and rows. User the <see cref="M:Aspose.Words.DocumentBuilder.InsertCell" />
  ///  and
  ///<see cref="M:Aspose.Words.DocumentBuilder.EndRow" />
  ///  methods to build a table.</p>
  ///  <p>Note that <b>Font</b>
  ///  , <b>ParagraphFormat</b>
  ///  and <b>PageSetup</b>
  ///  properties are updated whenever
  ///  you navigate to a different place in the document to reflect formatting properties available at the new location.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.DocumentBuilder')]
  DNDocumentBuilder = interface(DDN.mscorlib.DNObject)
  ['{CBA946FB-3CDD-383E-9ECF-243BDF0BD1F8}']
  { getters & setters } 

    function get_Document: DNDocument;
    procedure set_Document(value: DNDocument);
    function get_Font: DNFont;
    function get_Bold: Boolean;
    procedure set_Bold(value: Boolean);
    function get_Italic: Boolean;
    procedure set_Italic(value: Boolean);
    function get_Underline: DNUnderline;
    procedure set_Underline(value: DNUnderline);
    function get_ParagraphFormat: DNParagraphFormat;
    function get_ListFormat: DNListFormat;
    function get_PageSetup: DNPageSetup;
    function get_RowFormat: DNRowFormat;
    function get_CellFormat: DNCellFormat;
    function get_IsAtStartOfParagraph: Boolean;
    function get_IsAtEndOfParagraph: Boolean;
    function get_CurrentNode: DNNode;
    function get_CurrentParagraph: DNParagraph;
    function get_CurrentStory: DNStory;
    function get_CurrentSection: DNSection;

  { methods } 

    ///<summary>
    ///  Moves the cursor to the beginning of the document.
    ///</summary>
    procedure MoveToDocumentStart;
    ///<summary>
    ///  Moves the cursor to the end of the document.
    ///</summary>
    procedure MoveToDocumentEnd;
    ///<summary>
    ///  Moves the cursor to the beginning of the body in a specified section.
    ///</summary>
    ///<remarks><p>When sectionIndex is greater than or equal to 0, it specifies an index from
    ///  the beginning of the document with 0 being the first section. When sectionIndex is less than 0,
    ///  it specified an index from the end of the document with -1 being the last section.</p>
    ///  <p>The cursor is moved to the first paragraph in the <b>Body</b>
    ///  of the specified section.</p>
    ///</remarks>
    ///  <param name="sectionIndex">The index of the section to move to.</param>
    procedure MoveToSection(sectionIndex: Int32);
    ///<summary>
    ///  Moves the cursor to the beginning of a header or footer in the current section.
    ///</summary>
    ///<remarks><p>After you moved the cursor into a header or footer, you can use the rest of DocumentBuilder
    ///  methods to modify the contents of the header or footer.</p>
    ///  <p>If you want to create headers and footers different for the first page, you need
    ///  to set <see cref="P:Aspose.Words.PageSetup.DifferentFirstPageHeaderFooter" />
    ///  .</p>
    ///  <p>If you want to create headers and footers different for even and odd pages, you need
    ///  to set <see cref="P:Aspose.Words.PageSetup.OddAndEvenPagesHeaderFooter" />
    ///  .</p>
    ///  <p>Use <see cref="M:Aspose.Words.DocumentBuilder.MoveToSection(System.Int32)" />
    ///  to move out of the header into the main text.</p>
    ///</remarks>
    ///  <param name="headerFooterType">Specifies the header or footer to move to.</param>
    procedure MoveToHeaderFooter(headerFooterType: DNHeaderFooterType);
    ///<overloads>Moves the cursor to the specified merge field.</overloads><summary>
    ///  Moves the cursor to a position just beyond the specified merge field and removes the merge field.
    ///</summary>
    ///<remarks><p>Note that this method deletes the merge field from the document after moving the cursor.</p>
    ///</remarks>
    ///  <param name="fieldName">The case-insensitive name of the mail merge field.</param>
    ///<returns>True if the merge field was found and the cursor was moved; false otherwise.</returns>
    function MoveToMergeField(fieldName: string): Boolean; overload;
    ///<summary>
    ///  Moves the merge field to the specified merge field.
    ///</summary>
    ///  <param name="fieldName">The case-insensitive name of the mail merge field.</param>
    ///  <param name="isAfter">When true, moves the cursor to be after the field end.
    ///  When false, moves the cursor to be before the field start. </param>
    ///  <param name="isDeleteField">When true, deletes the merge field.</param>
    ///<returns>True if the merge field was found and the cursor was moved; false otherwise.</returns>
    function MoveToMergeField(fieldName: string; isAfter: Boolean; isDeleteField: Boolean): Boolean; overload;
    ///<summary>
    ///  Moves the cursor to a field in the document.
    ///</summary>
    ///  <param name="field">The field to move the cursor to.</param>
    ///  <param name="isAfter">When true, moves the cursor to be after the field end.
    ///  When false, moves the cursor to be before the field start. </param>
    procedure MoveToField(field: DNField; isAfter: Boolean);
    ///<summary>
    ///  Moves the cursor to a bookmark.
    ///</summary>
    ///<remarks><p>Moves the cursor to a position just after the start of the bookmark with the
    ///  specified name.</p>
    ///  <p>The comparison is not case-sensitive. If the bookmark was not found, false is
    ///  returned and the cursor is not moved.</p>
    ///  <p>Inserting new text does not replace existing text of the bookmark.</p>
    ///  <p>Note that some bookmarks in the document are assigned to form fields.
    ///  Moving to such a bookmark and inserting text there inserts the text into the
    ///  form field code. Although this will not invalidate the form field, the inserted
    ///  text will not be visible because it becomes part of the field code.</p>
    ///</remarks>
    ///  <param name="bookmarkName">The name of the bookmark to move the cursor to.</param>
    ///<returns>True if the bookmark was found; false otherwise.</returns>
    function MoveToBookmark(bookmarkName: string): Boolean; overload;
    ///<summary>
    ///  Moves the cursor to a bookmark with greater precision.
    ///</summary>
    ///<remarks><p>Moves the cursor to a position before or after the bookmark start or end.</p>
    ///  <p>If desired position is not at inline level, moves to the next paragraph.</p>
    ///  <p>The comparison is not case-sensitive. If the bookmark was not found, false is
    ///  returned and the cursor is not moved.</p>
    ///</remarks>
    ///  <param name="bookmarkName">The name of the bookmark to move the cursor to.</param>
    ///  <param name="isStart">When true, moves the cursor to the beginning of the bookmark.
    ///  When false, moves the cursor to the end of the bookmark.</param>
    ///  <param name="isAfter">When true, moves the cursor to be after the bookmark
    ///  start or end position. When false, moves the cursor to be before the bookmark
    ///  start or end position.</param>
    ///<returns>True if the bookmark was found; false otherwise.</returns>
    function MoveToBookmark(bookmarkName: string; isStart: Boolean; isAfter: Boolean): Boolean; overload;
    ///<summary>
    ///  Moves the cursor to a paragraph in the current section.
    ///</summary>
    ///<remarks><p>The navigation is performed inside the current story of the current section.
    ///  That is, if you moved the cursor to the primary header of the first section,
    ///  then paragraphIndex specified the index of the paragraph inside that header
    ///  of that section.</p>
    ///  <p>When paragraphIndex is greater than or equal to 0, it specifies an index from
    ///  the beginning of the section with 0 being the first paragraph. When paragraphIndex is less than 0,
    ///  it specified an index from the end of the section with -1 being the last paragraph.</p>
    ///</remarks>
    ///  <param name="paragraphIndex">The index of the paragraph to move to.</param>
    ///  <param name="characterIndex">The index of the character inside the paragraph.
    ///  A negative value allows you to specify a position from the end of the paragraph. Use -1 to move to the end of
    ///  the paragraph.</param>
    procedure MoveToParagraph(paragraphIndex: Int32; characterIndex: Int32);
    ///<summary>
    ///  Moves the cursor to a table cell in the current section.
    ///</summary>
    ///<remarks><p>The navigation is performed inside the current story of the current section.</p>
    ///  <p>For the index parameters, when index is greater than or equal to 0, it specifies an index from
    ///  the beginning with 0 being the first element. When index is less than 0, it specified an index from
    ///  the end with -1 being the last element.</p>
    ///</remarks>
    ///  <param name="tableIndex">The index of the table to move to.</param>
    ///  <param name="rowIndex">The index of the row in the table.</param>
    ///  <param name="columnIndex">The index of the column in the table.</param>
    ///  <param name="characterIndex">The index of the character inside the cell.
    ///  A negative value allows you to specify a position from the end of the cell. Use -1 to move to the end of
    ///  the cell.</param>
    procedure MoveToCell(tableIndex: Int32; rowIndex: Int32; columnIndex: Int32; characterIndex: Int32);
    ///<summary>
    ///  Moves the cursor to an inline node or to the end of a paragraph.
    ///</summary>
    ///<remarks><p>When <i>node</i> is an inline-level node, the cursor is moved to this node
    ///  and further content will be inserted before that node.</p>
    ///  <p>When <i>node</i> is a <b>Paragraph</b>
    ///  , the cursor is moved to the end of the paragraph
    ///  and further content will be inserted just before the paragraph break.</p>
    ///  <p>When <i>node</i> is a block-level node but not a Paragraph, the cursor is moved to the end of the first paragraph into block-level node
    ///  and further content will be inserted just before the paragraph break.</p>
    ///</remarks>
    ///  <param name="node">The node must be a paragraph or a direct child of a paragraph.</param>
    procedure MoveTo(node: DNNode);
    ///<summary>
    ///  Deletes a row from a table.
    ///</summary>
    ///<remarks><p>If the cursor is inside the row that is being deleted, the cursor is moved
    ///  out to the next row or to the next paragraph after the table.</p>
    ///  <p>If you delete a row from a table that contains only one row, the whole
    ///  table is deleted.</p>
    ///  <p>For the index parameters, when index is greater than or equal to 0, it specifies an index from
    ///  the beginning with 0 being the first element. When index is less than 0, it specified an index from
    ///  the end with -1 being the last element.</p>
    ///</remarks>
    ///  <param name="tableIndex">The index of the table.</param>
    ///  <param name="rowIndex">The index of the row in the table.</param>
    ///<returns>The row node that was just removed.</returns>
    function DeleteRow(tableIndex: Int32; rowIndex: Int32): DNRow;
    ///<summary>
    ///  Inserts a string into the document at the current insert position.
    ///</summary>
    ///<remarks>
    ///  Current font formatting specified by the <see cref="P:Aspose.Words.DocumentBuilder.Font" />
    ///  property is used.
    ///</remarks>
    ///  <param name="text">The string to insert into the document.</param>
    procedure Write(text: string);
    ///<summary>
    ///  Inserts a string and a paragraph break into the document.
    ///</summary>
    ///<remarks>
    ///  Current font and paragraph formatting specified by the <see cref="P:Aspose.Words.DocumentBuilder.Font" />
    ///  and <see cref="P:Aspose.Words.DocumentBuilder.ParagraphFormat" />
    ///  properties are used.
    ///</remarks>
    ///  <param name="text">The string to insert into the document.</param>
    procedure Writeln(text: string); overload;
    ///<summary>
    ///  Inserts a paragraph break into the document.
    ///</summary>
    ///<remarks><p>Calls <see cref="M:Aspose.Words.DocumentBuilder.InsertParagraph" />
    ///  .</p>
    ///</remarks>
    procedure Writeln; overload;
    ///<summary>
    ///  Inserts a paragraph break into the document.
    ///</summary>
    ///<remarks><p>Current paragraph formatting specified by the <see cref="P:Aspose.Words.DocumentBuilder.ParagraphFormat" />
    ///  property is used.</p>
    ///  <p>Breaks the current paragraph in two. After inserting the paragraph, the cursor is placed at the beginning of the new paragraph.</p>
    ///</remarks>
    ///<returns>The paragraph node that was just inserted. It is the same node as <see cref="P:Aspose.Words.DocumentBuilder.CurrentParagraph" />
    ///  .</returns>
    function InsertParagraph: DNParagraph;
    ///<summary>
    ///  Inserts style separator into the document.
    ///</summary>
    ///<remarks>
    ///  This method allows to apply different paragraph styles to two different parts of a text line.
    ///</remarks>
    procedure InsertStyleSeparator;
    ///<summary>
    ///  Inserts a break of the specified type into the document.
    ///</summary>
    ///<remarks>
    ///  Use this method to insert paragraph, page, column, section or line break into the document.
    ///</remarks>
    ///  <param name="breakType">Specifies the type of the break to insert.</param>
    procedure InsertBreak(breakType: DNBreakType);
    ///<summary>
    ///  Inserts a TOC (table of contents) field into the document.
    ///</summary>
    ///<remarks><p>This method inserts a TOC (table of contents) field into the document at
    ///  the current position.</p>
    ///  <p>A table of contents in a Word document can be built in a number of ways
    ///  and formatted using a variety of options. The way the table is built and
    ///  displayed by Microsoft Word is controlled by the field switches.</p>
    ///  <p>The easiest way to specify the switches is to insert and configure a table of
    ///  contents into a Word document using the Insert-&gt;Reference-&gt;Index and Tables menu,
    ///  then switch display of field codes on to see the switches. You can press Alt+F9 in
    ///  Microsoft Word to toggle display of field codes on or off.</p>
    ///  <p>For example, after creating a table of contents, the following field is inserted
    ///  into the document: <b>{ TOC \o "1-3" \h \z \u }</b>
    ///  .
    ///  You can copy <b>\o "1-3" \h \z \u</b>
    ///  and use it as the switches parameter.</p>
    ///  <p>Note that <b>InsertTableOfContents</b>
    ///  will only insert a TOC field, but
    ///  will not actually build the table of contents. The table of contents is built by
    ///  Microsoft Word when the field is updated.</p>
    ///  <p>If you insert a table of contents using this method and then open the file
    ///  in Microsoft Word, you will not see the table of contents because the TOC field
    ///  has not yet been updated.</p>
    ///  <p>In Microsoft Word, fields are not automatically updated when a document is opened,
    ///  but you can update fields in a document at any time by pressing F9.</p>
    ///</remarks>
    ///  <param name="switches">The TOC field switches.</param>
    function InsertTableOfContents(switches: string): DNField;
    ///<overloads>Inserts a Word field into a document.</overloads><summary>
    ///  Inserts a Word field into a document and optionally updates the field result.
    ///</summary>
    ///<remarks><para>This method inserts a field into a document.
    ///  Aspose.Words can update fields of most types, but not all. For more details see the
    ///<see cref="M:Aspose.Words.DocumentBuilder.InsertField(System.String,System.String)" />
    ///  overload.</para><seealso cref="T:Aspose.Words.Fields.Field" />
    ///</remarks>
    ///  <param name="fieldType">The type of the field to append.</param>
    ///  <param name="updateField">Specifies whether to update the field immediately.</param>
    ///<returns>A <see cref="T:Aspose.Words.Fields.Field" />
    ///  object that represents the inserted field.</returns>
    function InsertField(fieldType: DNFieldType; updateField: Boolean): DNField; overload;
    ///<overloads>Inserts a Word field into a document.</overloads><summary>
    ///  Inserts a Word field into a document and updates the field result.
    ///</summary>
    ///<remarks><para>This method inserts a field into a document and updates the field result immediately.
    ///  Aspose.Words can update fields of most types, but not all. For more details see the
    ///<see cref="M:Aspose.Words.DocumentBuilder.InsertField(System.String,System.String)" />
    ///  overload.</para><seealso cref="T:Aspose.Words.Fields.Field" />
    ///</remarks>
    ///  <param name="fieldCode">The field code to insert (without curly braces).</param>
    ///<returns>A <see cref="T:Aspose.Words.Fields.Field" />
    ///  object that represents the inserted field.</returns>
    function InsertField(fieldCode: string): DNField; overload;
    ///<summary>
    ///  Inserts a Word field into a document without updating the field result.
    ///</summary>
    ///<remarks><p>Fields in Microsoft Word documents consist of a field code and a field result.
    ///  The field code is like a formula and the field result is like the value that
    ///  the formula produces. The field code may also contain field switches
    ///  that are like additional instructions to perform a specific action.</p>
    ///  <p>You can switch between displaying field codes and results in your document in
    ///  Microsoft Word using the keyboard shortcut Alt+F9. Field codes appear between curly braces ( { } ).</p>
    ///  <p>To create a field, you need to specify a field type, field code and a "placeholder" field value.
    ///  If you are not sure about a particular field code syntax, create the field in Microsoft Word first
    ///  and switch to see its field code.</p>
    ///  <para>Aspose.Words can calculate field results for most of the field types, but this method
    ///  does not update the field result automatically. Because the field result is not calculated automatically,
    ///  you are expected to pass some string value (or even an empty string) that will be inserted into the field result.
    ///  This value will remain in the field result as a placeholder until the field is updated.
    ///  To update the field result you can call <see cref="M:Aspose.Words.Fields.Field.Update" />
    ///  on the field object returned
    ///  to you or <see cref="M:Aspose.Words.Document.UpdateFields" />
    ///  to update fields in the whole document.</para><seealso cref="T:Aspose.Words.Fields.Field" />
    ///</remarks>
    ///  <param name="fieldCode">The field code to insert (without curly braces).</param>
    ///  <param name="fieldValue">The field value to insert. Pass null for fields that do not have a value.</param>
    ///<returns>A <see cref="T:Aspose.Words.Fields.Field" />
    ///  object that represents the inserted field.</returns>
    function InsertField(fieldCode: string; fieldValue: string): DNField; overload;
    ///<summary>
    ///  Inserts a hyperlink into the document.
    ///</summary>
    ///<remarks><p>Note that you need to specify font formatting for the hyperlink display text explicitly
    ///  using the <see cref="P:Aspose.Words.DocumentBuilder.Font" />
    ///  property.</p>
    ///  <p>This methods internally calls <see cref="M:Aspose.Words.DocumentBuilder.InsertField(System.String)" />
    ///  to insert an MS Word HYPERLINK field
    ///  into the document.</p>
    ///</remarks>
    ///  <param name="displayText">Text of the link to be displayed in the document.</param>
    ///  <param name="urlOrBookmark">Link destination. Can be a url or a name of a bookmark inside the document.
    ///  This method always adds apostrophes at the beginning and end of the url.</param>
    ///  <param name="isBookmark">True if the previous parameter is a name of a bookmark inside the document;
    ///  false is the previous parameter is a URL.</param>
    ///<returns>A <see cref="T:Aspose.Words.Fields.Field" />
    ///  object that represents the inserted field.</returns>
    function InsertHyperlink(displayText: string; urlOrBookmark: string; isBookmark: Boolean): DNField;
    ///<summary>
    ///  Inserts a text form field at the current position.
    ///</summary>
    ///<remarks><p>If you specify a name for the form field, then a bookmark is automatically created with the same name.</p>
    ///</remarks>
    ///  <param name="name">The name of the form field. Can be an empty string.</param>
    ///  <param name="type">Specifies the type of the text form field.</param>
    ///  <param name="format">Format string used to format the value of the form field.</param>
    ///  <param name="fieldValue">Text that will be shown in the field.</param>
    ///  <param name="maxLength">Maximum length the user can enter into the form field. Set to zero for unlimited length.</param>
    ///<returns>The form field node that was just inserted.</returns>
    function InsertTextInput(name: string; &type: DNTextFormFieldType; format: string; fieldValue: string; maxLength: Int32): DNFormField;
    ///<summary>
    ///  Inserts a checkbox form field at the current position.
    ///</summary>
    ///<remarks><p>If you specify a name for the form field, then a bookmark is automatically created with the same name.</p>
    ///</remarks>
    ///  <param name="name">The name of the form field. Can be an empty string. The value longer than 20 characters will be truncated.</param>
    ///  <param name="checkedValue">Checked status of the checkbox form field.</param>
    ///  <param name="size">Specifies the size of the checkbox in points. Specify 0 for MS Word
    ///  to calculate the size of the checkbox automatically.</param>
    ///<returns>The form field node that was just inserted.</returns>
    function InsertCheckBox(name: string; checkedValue: Boolean; size: Int32): DNFormField; overload;
    ///<summary>
    ///  Inserts a checkbox form field at the current position.
    ///</summary>
    ///<remarks><p>If you specify a name for the form field, then a bookmark is automatically created with the same name.</p>
    ///</remarks>
    ///  <param name="name">The name of the form field. Can be an empty string. The value longer than 20 characters will be truncated.</param>
    ///  <param name="defaultValue">Default value of the checkbox form field.</param>
    ///  <param name="checkedValue">Current checked status of the checkbox form field.</param>
    ///  <param name="size">Specifies the size of the checkbox in points. Specify 0 for MS Word
    ///  to calculate the size of the checkbox automatically.</param>
    ///<returns>The form field node that was just inserted.</returns>
    function InsertCheckBox(name: string; defaultValue: Boolean; checkedValue: Boolean; size: Int32): DNFormField; overload;
    ///<summary>
    ///  Inserts a combobox form field at the current position.
    ///</summary>
    ///<remarks><p>If you specify a name for the form field, then a bookmark is automatically created with the same name.</p>
    ///</remarks>
    ///  <param name="name">The name of the form field. Can be an empty string. The value longer than 20 characters will be truncated.</param>
    ///  <param name="items">The items of the ComboBox. Maximum is 25 items.</param>
    ///  <param name="selectedIndex">The index of the selected item in the ComboBox.</param>
    ///<returns>The form field node that was just inserted.</returns>
    function InsertComboBox(name: string; items: TArray<string>; selectedIndex: Int32): DNFormField;
    ///<summary>
    ///  Inserts a footnote or endnote into the document.
    ///</summary>
    ///  <param name="footnoteType">Specifies whether to insert a footnote or an endnote.</param>
    ///  <param name="footnoteText">Specifies the text of the footnote.</param>
    ///<returns>Returns a footnote object that was just created.</returns>
    function InsertFootnote(footnoteType: DNFootnoteType; footnoteText: string): DNFootnote; overload;
    ///<summary>
    ///  Inserts a footnote or endnote into the document.
    ///</summary>
    ///  <param name="footnoteType">Specifies whether to insert a footnote or an endnote.</param>
    ///  <param name="footnoteText">Specifies the text of the footnote.</param>
    ///  <param name="referenceMark">Specifies the custom reference mark of the footnote.</param>
    ///<returns>Returns a footnote object that was just created.</returns>
    function InsertFootnote(footnoteType: DNFootnoteType; footnoteText: string; referenceMark: string): DNFootnote; overload;
    ///<overloads>Inserts an image into the document.</overloads><summary>
    ///  Inserts an image from a .NET <see cref="T:System.Drawing.Image" />
    ///  object into the document. The image is inserted inline and at 100% scale.
    ///</summary>
    ///  <param name="image">The image to insert into the document.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(image: DDN.System.Drawing.DNImage): DNShape; overload;
    ///<summary>
    ///  Inserts an image from a file or URL into the document. The image is inserted inline and at 100% scale.
    ///</summary>
    ///  <param name="fileName">The file with the image. Can be any valid local or remote URI.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>This overload will automatically download the image before inserting into the document
    ///  if you specify a remote URI.</p>
    ///  <p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(fileName: string): DNShape; overload;
    ///<summary>
    ///  Inserts an image from a stream into the document. The image is inserted inline and at 100% scale.
    ///</summary>
    ///  <param name="stream">The stream that contains the image.
    ///</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(stream: DDN.mscorlib.DNStream): DNShape; overload;
    ///<summary>
    ///  Inserts an image from a byte array into the document. The image is inserted inline and at 100% scale.
    ///</summary>
    ///  <param name="imageBytes">The byte array that contains the image.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(imageBytes: TArray<Byte>): DNShape; overload;
    ///<summary>
    ///  Inserts an inline image from a .NET <see cref="T:System.Drawing.Image" />
    ///  object into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="image">The image to insert into the document.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(image: DDN.System.Drawing.DNImage; width: Double; height: Double): DNShape; overload;
    ///<summary>
    ///  Inserts an inline image from a file or URL into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="fileName">The file that contains the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(fileName: string; width: Double; height: Double): DNShape; overload;
    ///<summary>
    ///  Inserts an inline image from a stream into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="stream">The stream that contains the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(stream: DDN.mscorlib.DNStream; width: Double; height: Double): DNShape; overload;
    ///<summary>
    ///  Inserts an inline image from a byte array into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="imageBytes">The byte array that contains the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(imageBytes: TArray<Byte>; width: Double; height: Double): DNShape; overload;
    ///<summary>
    ///  Inserts an image from a .NET <see cref="T:System.Drawing.Image" />
    ///  object at the specified position and size.
    ///</summary>
    ///  <param name="image">The image to insert into the document.</param>
    ///  <param name="horzPos">Specifies where the distance to the image is measured from.</param>
    ///  <param name="left">Distance in points from the origin to the left side of the image.</param>
    ///  <param name="vertPos">Specifies where the distance to the image measured from.</param>
    ///  <param name="top">Distance in points from the origin to the top side of the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="wrapType">Specifies how to wrap text around the image.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(image: DDN.System.Drawing.DNImage; horzPos: DNRelativeHorizontalPosition; left: Double; vertPos: DNRelativeVerticalPosition; top: Double; width: Double; height: Double; wrapType: DNWrapType): DNShape; overload;
    ///<summary>
    ///  Inserts an image from a file or URL at the specified position and size.
    ///</summary>
    ///  <param name="fileName">The file that contains the image.</param>
    ///  <param name="horzPos">Specifies where the distance to the image is measured from.</param>
    ///  <param name="left">Distance in points from the origin to the left side of the image.</param>
    ///  <param name="vertPos">Specifies where the distance to the image measured from.</param>
    ///  <param name="top">Distance in points from the origin to the top side of the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="wrapType">Specifies how to wrap text around the image.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(fileName: string; horzPos: DNRelativeHorizontalPosition; left: Double; vertPos: DNRelativeVerticalPosition; top: Double; width: Double; height: Double; wrapType: DNWrapType): DNShape; overload;
    ///<summary>
    ///  Inserts an image from a stream at the specified position and size.
    ///</summary>
    ///  <param name="stream">The stream that contains the image.</param>
    ///  <param name="horzPos">Specifies where the distance to the image is measured from.</param>
    ///  <param name="left">Distance in points from the origin to the left side of the image.</param>
    ///  <param name="vertPos">Specifies where the distance to the image measured from.</param>
    ///  <param name="top">Distance in points from the origin to the top side of the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="wrapType">Specifies how to wrap text around the image.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(stream: DDN.mscorlib.DNStream; horzPos: DNRelativeHorizontalPosition; left: Double; vertPos: DNRelativeVerticalPosition; top: Double; width: Double; height: Double; wrapType: DNWrapType): DNShape; overload;
    ///<summary>
    ///  Inserts an image from a byte array at the specified position and size.
    ///</summary>
    ///  <param name="imageBytes">The byte array that contains the image.</param>
    ///  <param name="horzPos">Specifies where the distance to the image is measured from.</param>
    ///  <param name="left">Distance in points from the origin to the left side of the image.</param>
    ///  <param name="vertPos">Specifies where the distance to the image measured from.</param>
    ///  <param name="top">Distance in points from the origin to the top side of the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="wrapType">Specifies how to wrap text around the image.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertImage(imageBytes: TArray<Byte>; horzPos: DNRelativeHorizontalPosition; left: Double; vertPos: DNRelativeVerticalPosition; top: Double; width: Double; height: Double; wrapType: DNWrapType): DNShape; overload;
    ///<summary>
    ///  Inserts an embedded OLE object from a stream into the document.
    ///</summary>
    ///  <param name="stream">Stream containing application data.</param>
    ///  <param name="progId">Programmatic Identifier of OLE object.</param>
    ///  <param name="asIcon">Specifies either Iconic or Normal mode of OLE object being inserted.</param>
    ///  <param name="presentation">Image presentation of OLE object. If value is null Aspose.Words will use one of the predefined images.</param>
    ///<returns>Shape node containing Ole object and inserted at the current Builder position.</returns>
    function InsertOleObject(stream: DDN.mscorlib.DNStream; progId: string; asIcon: Boolean; presentation: DDN.mscorlib.DNStream): DNShape; overload;
    ///<summary>
    ///  Inserts an embedded or linked OLE object from a file into the document. Detects OLE object type using file extension.
    ///</summary>
    ///  <param name="fileName">Full path to the file.</param>
    ///  <param name="isLinked">If true then linked OLE object is inserted otherwise embedded OLE object is inserted.</param>
    ///  <param name="asIcon">Specifies either Iconic or Normal mode of OLE object being inserted.</param>
    ///  <param name="presentation">Image presentation of OLE object. If value is null Aspose.Words will use one of the predefined images.</param>
    ///<returns>Shape node containing Ole object and inserted at the current Builder position.</returns>
    function InsertOleObject(fileName: string; isLinked: Boolean; asIcon: Boolean; presentation: DDN.mscorlib.DNStream): DNShape; overload;
    ///<summary>
    ///  Inserts an embedded or linked OLE object from a file into the document. Detects OLE object type using given progID parameter.
    ///</summary>
    ///  <param name="fileName">Full path to the file.</param>
    ///  <param name="progId">ProgId of OLE object.</param>
    ///  <param name="isLinked">If true then linked OLE object is inserted otherwise embedded OLE object is inserted.</param>
    ///  <param name="asIcon">Specifies either Iconic or Normal mode of OLE object being inserted.</param>
    ///  <param name="presentation">Image presentation of OLE object. If value is null Aspose.Words will use one of the predefined images.</param>
    ///<returns>Shape node containing Ole object and inserted at the current Builder position.</returns>
    function InsertOleObject(fileName: string; progId: string; isLinked: Boolean; asIcon: Boolean; presentation: DDN.mscorlib.DNStream): DNShape; overload;
    ///<summary>
    ///  Inserts an embedded or linked OLE object as icon into the document.
    ///  Allows to specify icon file and caption. Detects OLE object type using file extension.
    ///</summary>
    ///  <param name="fileName">Full path to the file.</param>
    ///  <param name="isLinked">
    ///  If true then linked OLE object is inserted otherwise embedded OLE object is inserted.
    ///</param>
    ///  <param name="iconFile">
    ///  Full path to the ICO file. If the value is null, Aspose.Words will use a predefined image.
    ///</param>
    ///  <param name="iconCaption">
    ///  Icon caption. If the value is null, Aspose.Words will use the file name.
    ///</param>
    ///<returns>Shape node containing Ole object and inserted at the current Builder position.</returns>
    function InsertOleObjectAsIcon(fileName: string; isLinked: Boolean; iconFile: string; iconCaption: string): DNShape; overload;
    ///<summary>
    ///  Inserts an embedded or linked OLE object as icon into the document.
    ///  Allows to specify icon file and caption. Detects OLE object type using given progID parameter.
    ///</summary>
    ///  <param name="fileName">Full path to the file.</param>
    ///  <param name="progId">ProgId of OLE object.</param>
    ///  <param name="isLinked">
    ///  If true then linked OLE object is inserted otherwise embedded OLE object is inserted.
    ///</param>
    ///  <param name="iconFile">
    ///  Full path to the ICO file. If the value is null, Aspose.Words will use a predefined image.
    ///</param>
    ///  <param name="iconCaption">
    ///  Icon caption. If the value is null, Aspose.Words will use the file name.
    ///</param>
    ///<returns>Shape node containing Ole object and inserted at the current Builder position.</returns>
    function InsertOleObjectAsIcon(fileName: string; progId: string; isLinked: Boolean; iconFile: string; iconCaption: string): DNShape; overload;
    ///<summary>
    ///  Inserts an embedded OLE object as icon from a stream into the document.
    ///  Allows to specify icon file and caption. Detects OLE object type using given progID parameter.
    ///</summary>
    ///  <param name="stream">Stream containing application data.</param>
    ///  <param name="progId">ProgId of OLE object.</param>
    ///  <param name="iconFile">
    ///  Full path to the ICO file. If the value is null, Aspose.Words will use a predefined image.
    ///</param>
    ///  <param name="iconCaption">
    ///  Icon caption. If the value is null, Aspose.Words will use the a predefined icon caption.
    ///</param>
    ///<returns>Shape node containing Ole object and inserted at the current Builder position.</returns>
    function InsertOleObjectAsIcon(stream: DDN.mscorlib.DNStream; progId: string; iconFile: string; iconCaption: string): DNShape; overload;
    ///<summary>
    ///  Inserts an HTML string into the document.
    ///</summary>
    ///<remarks><p>You can use InsertHtml to insert an HTML fragment or whole HTML document.</p>
    ///</remarks>
    ///  <param name="html">An HTML string to insert into the document.</param>
    procedure InsertHtml(html: string); overload;
    ///<summary>
    ///  Inserts an HTML string into the document.
    ///</summary>
    ///<remarks><p>You can use InsertHtml to insert an HTML fragment or whole HTML document.</p>
    ///</remarks>
    ///  <param name="html">An HTML string to insert into the document.</param>
    ///  <param name="useBuilderFormatting">
    ///  A value indicating whether formatting specified in <see cref="T:Aspose.Words.DocumentBuilder" />
    ///  is used as base formatting for text imported from HTML.
    ///</param>
    ///<remarks><para>
    ///  When <paramref name="useBuilderFormatting" />
    ///  is <c>false</c>,
    ///<see cref="T:Aspose.Words.DocumentBuilder" />
    ///  formating is ignored and formatting of inserted text
    ///  is based on default HTML formatting. As a result, the text looks as it is rendered in browsers.
    ///</para><para>
    ///  When <paramref name="useBuilderFormatting" />
    ///  is <c>true</c>,
    ///  formatting of inserted text is based on <see cref="T:Aspose.Words.DocumentBuilder" />
    ///  formatting,
    ///  and the text looks as if it were inserted with <see cref="M:Aspose.Words.DocumentBuilder.Write(System.String)" />
    ///  .
    ///</para></remarks>
    procedure InsertHtml(html: string; useBuilderFormatting: Boolean); overload;
    ///<summary>
    ///  Inserts inline shape with specified type and size.
    ///</summary>
    ///  <param name="shapeType">The shape type to insert into the document.</param>
    ///  <param name="width">The width of the shape in points.</param>
    ///  <param name="height">The height of the shape in points.</param>
    ///<returns>The shape node that was inserted.</returns>
    function InsertShape(shapeType: DNShapeType; width: Double; height: Double): DNShape; overload;
    ///<summary>
    ///  Inserts free-floating shape with specified position, size and text wrap type.
    ///</summary>
    ///  <param name="shapeType">The shape type to insert into the document</param>
    ///  <param name="horzPos">Specifies where the horizontal distance to the shape is measured from.</param>
    ///  <param name="left">Distance in points from the origin to the left side of the shape.</param>
    ///  <param name="vertPos">Specifies where the vertical distance to the shape is measured from.</param>
    ///  <param name="top">Distance in points from the origin to the top side of the shape.</param>
    ///  <param name="width">The width of the shape in points.</param>
    ///  <param name="height">The width of the shape in points.</param>
    ///  <param name="wrapType">Specifies how to wrap text around the shape.</param>
    ///<returns>The shape node that was inserted.</returns>
    function InsertShape(shapeType: DNShapeType; horzPos: DNRelativeHorizontalPosition; left: Double; vertPos: DNRelativeVerticalPosition; top: Double; width: Double; height: Double; wrapType: DNWrapType): DNShape; overload;
    ///<summary>
    ///  Inserts an chart object into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="chartType">The chart type to insert into the document.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertChart(chartType: DNChartType; width: Double; height: Double): DNShape; overload;
    ///<summary>
    ///  Inserts an chart object into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="chartType">The chart type to insert into the document.</param>
    ///  <param name="horzPos">Specifies where the distance to the image is measured from.</param>
    ///  <param name="left">Distance in points from the origin to the left side of the image.</param>
    ///  <param name="vertPos">Specifies where the distance to the image measured from.</param>
    ///  <param name="top">Distance in points from the origin to the top side of the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="wrapType">Specifies how to wrap text around the image.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertChart(chartType: DNChartType; horzPos: DNRelativeHorizontalPosition; left: Double; vertPos: DNRelativeVerticalPosition; top: Double; width: Double; height: Double; wrapType: DNWrapType): DNShape; overload;
    ///<summary>
    ///  Inserts an online video object into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="videoUrl">The URL to the video.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///  <para>Insertion of online video from the following resources is supported:</para><list type="bullet"><item><description>https://www.youtube.com/</description>
    ///</item>
    ///<item><description>https://vimeo.com/</description>
    ///</item>
    ///</list>
    ///  <para>If your online video is not displaying correctly, use <see cref="M:Aspose.Words.DocumentBuilder.InsertOnlineVideo(System.String,System.String,System.Byte[],System.Double,System.Double)" />
    ///  , which accepts custom embedded html code.</para><para>The code for embedding video can vary between providers, consult your corresponding provider of choice for details.</para></remarks>
    function InsertOnlineVideo(videoUrl: string; width: Double; height: Double): DNShape; overload;
    ///<summary>
    ///  Inserts an online video object into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="videoUrl">The URL to the video.</param>
    ///  <param name="horzPos">Specifies where the distance to the image is measured from.</param>
    ///  <param name="left">Distance in points from the origin to the left side of the image.</param>
    ///  <param name="vertPos">Specifies where the distance to the image measured from.</param>
    ///  <param name="top">Distance in points from the origin to the top side of the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="wrapType">Specifies how to wrap text around the image.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///  <para>Insertion of online video from the following resources is supported:</para><list type="bullet"><item><description>https://www.youtube.com/</description>
    ///</item>
    ///<item><description>https://vimeo.com/</description>
    ///</item>
    ///</list>
    ///  <para>If your online video is not displaying correctly, use <see cref="M:Aspose.Words.DocumentBuilder.InsertOnlineVideo(System.String,System.String,System.Byte[],System.Double,System.Double)" />
    ///  , which accepts custom embedded html code.</para><para>The code for embedding video can vary between providers, consult your corresponding provider of choice for details.</para></remarks>
    function InsertOnlineVideo(videoUrl: string; horzPos: DNRelativeHorizontalPosition; left: Double; vertPos: DNRelativeVerticalPosition; top: Double; width: Double; height: Double; wrapType: DNWrapType): DNShape; overload;
    ///<summary>
    ///  Inserts an online video object into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="videoUrl">The URL to the video.</param>
    ///  <param name="videoEmbedCode">The embed code for the video.</param>
    ///  <param name="thumbnailImageBytes">The thumbnail image bytes.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertOnlineVideo(videoUrl: string; videoEmbedCode: string; thumbnailImageBytes: TArray<Byte>; width: Double; height: Double): DNShape; overload;
    ///<summary>
    ///  Inserts an online video object into the document and scales it to the specified size.
    ///</summary>
    ///  <param name="videoUrl">The URL to the video.</param>
    ///  <param name="videoEmbedCode">The embed code for the video.</param>
    ///  <param name="thumbnailImageBytes">The thumbnail image bytes.</param>
    ///  <param name="horzPos">Specifies where the distance to the image is measured from.</param>
    ///  <param name="left">Distance in points from the origin to the left side of the image.</param>
    ///  <param name="vertPos">Specifies where the distance to the image measured from.</param>
    ///  <param name="top">Distance in points from the origin to the top side of the image.</param>
    ///  <param name="width">The width of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="height">The height of the image in points. Can be a negative or zero value to request 100% scale.</param>
    ///  <param name="wrapType">Specifies how to wrap text around the image.</param>
    ///<returns>The image node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertOnlineVideo(videoUrl: string; videoEmbedCode: string; thumbnailImageBytes: TArray<Byte>; horzPos: DNRelativeHorizontalPosition; left: Double; vertPos: DNRelativeVerticalPosition; top: Double; width: Double; height: Double; wrapType: DNWrapType): DNShape; overload;
    ///<summary>
    ///  Inserts a signature line at the current position.
    ///</summary>
    ///  <param name="signatureLineOptions">The object that stores parameters of creating signature line.</param>
    ///<returns>The signature line node that was just inserted.</returns>
    function InsertSignatureLine(signatureLineOptions: DNSignatureLineOptions): DNShape; overload;
    ///<summary>
    ///  Inserts a signature line at the specified position.
    ///</summary>
    ///  <param name="signatureLineOptions">The object that stores parameters of creating signature line.</param>
    ///  <param name="horzPos">Specifies where the distance to the signature line is measured from.</param>
    ///  <param name="left">Distance in points from the origin to the left side of the signature line.</param>
    ///  <param name="vertPos">Specifies where the distance to the signature line measured from.</param>
    ///  <param name="top">Distance in points from the origin to the top side of the signature line.</param>
    ///  <param name="wrapType">Specifies how to wrap text around the signature line.</param>
    ///<returns>The signature line node that was just inserted.</returns>
    ///<remarks><p>You can change the image size, location, positioning method and other settings using the
    ///<see cref="T:Aspose.Words.Drawing.Shape" />
    ///  object returned by this method.</p>
    ///</remarks>
    function InsertSignatureLine(signatureLineOptions: DNSignatureLineOptions; horzPos: DNRelativeHorizontalPosition; left: Double; vertPos: DNRelativeVerticalPosition; top: Double; wrapType: DNWrapType): DNShape; overload;
    ///<summary>
    ///  Inserts a horizontal rule shape into the document.
    ///</summary>
    ///<returns>The shape that is a horizontal rule.</returns>
    function InsertHorizontalRule: DNShape;
    ///<summary>
    ///  Inserts a table cell into the document.
    ///</summary>
    ///<remarks><p>To start a table, just call <b>InsertCell</b>
    ///  . After this, any content you add using
    ///  other methods of the <see cref="T:Aspose.Words.DocumentBuilder" />
    ///  class will be added to the current cell.</p>
    ///  <p>To start a new cell in the same row, call <b>InsertCell</b>
    ///  again.</p>
    ///  <p>To end a table row call <see cref="M:Aspose.Words.DocumentBuilder.EndRow" />
    ///  .</p>
    ///  <p>Use the <see cref="P:Aspose.Words.DocumentBuilder.CellFormat" />
    ///  property to specify cell formatting.</p>
    ///</remarks>
    ///<returns>The cell node that was just inserted.</returns>
    function InsertCell: DNCell;
    ///<summary>
    ///  Starts a table in the document.
    ///</summary>
    ///<remarks><p>The next method to call is <see cref="M:Aspose.Words.DocumentBuilder.InsertCell" />
    ///  .</p>
    ///  <p>This method starts a nested table when called inside a cell.</p>
    ///</remarks>
    ///<returns>The table node that was just created.</returns>
    function StartTable: DNTable;
    ///<summary>
    ///  Ends a table in the document.
    ///</summary>
    ///<remarks><p>This method should be called only once after <see cref="M:Aspose.Words.DocumentBuilder.EndRow" />
    ///  was called. When called,
    ///<b>EndTable</b>
    ///  moves the cursor out of the current cell to point just after the table.</p>
    ///</remarks>
    ///<returns>The table node that was just finished.</returns>
    function EndTable: DNTable;
    ///<summary>
    ///  Ends a table row in the document.
    ///</summary>
    ///<remarks><p>Call <b>EndRow</b>
    ///  to end a table row. If you call <see cref="M:Aspose.Words.DocumentBuilder.InsertCell" />
    ///  immediately
    ///  after that, then the table continues on a new row.</p>
    ///  <p>Use the <see cref="P:Aspose.Words.DocumentBuilder.RowFormat" />
    ///  property to specify row formatting.</p>
    ///</remarks>
    ///<returns>The row node that was just finished.</returns>
    function EndRow: DNRow;
    ///<summary>
    ///  Marks the current position in the document as a bookmark start.
    ///</summary>
    ///<remarks><p>Bookmarks in a document can overlap and span any range. To create a valid bookmark you need to
    ///  call both <see cref="M:Aspose.Words.DocumentBuilder.StartBookmark(System.String)" />
    ///  and <see cref="M:Aspose.Words.DocumentBuilder.EndBookmark(System.String)" />
    ///  with the same <b>bookmarkName</b>
    ///  parameter.</p>
    ///  <p>Badly formed bookmarks or bookmarks with duplicate names will be ignored when the document is saved.</p>
    ///</remarks>
    ///  <param name="bookmarkName">Name of the bookmark.</param>
    ///<returns>The bookmark start node that was just created.</returns>
    function StartBookmark(bookmarkName: string): DNBookmarkStart;
    ///<summary>
    ///  Marks the current position in the document as a bookmark end.
    ///</summary>
    ///<remarks><p>Bookmarks in a document can overlap and span any range. To create a valid bookmark you need to
    ///  call both <see cref="M:Aspose.Words.DocumentBuilder.StartBookmark(System.String)" />
    ///  and <see cref="M:Aspose.Words.DocumentBuilder.EndBookmark(System.String)" />
    ///  with the same <b>bookmarkName</b>
    ///  parameter.</p>
    ///  <p>Badly formed bookmarks or bookmarks with duplicate names will be ignored when the document is saved.</p>
    ///</remarks>
    ///  <param name="bookmarkName">Name of the bookmark.</param>
    ///<returns>The bookmark end node that was just created.</returns>
    function EndBookmark(bookmarkName: string): DNBookmarkEnd;
    ///<summary>
    ///  Marks the current position in the document as a column bookmark start. The position must be in a table cell.
    ///</summary>
    ///<remarks><p>A column bookmark covers one or more columns in a range of rows. To create a valid bookmark you
    ///  need to call both <see cref="M:Aspose.Words.DocumentBuilder.StartColumnBookmark(System.String)" />
    ///  and <see cref="M:Aspose.Words.DocumentBuilder.EndColumnBookmark(System.String)" />
    ///  with the same
    ///<b>bookmarkName</b>
    ///  parameter.</p>
    ///  <p>Badly formed bookmarks or bookmarks with duplicate names will be ignored when the document is saved.</p>
    ///  <p>The actual position of the inserted <see cref="T:Aspose.Words.BookmarkStart" />
    ///  node may differ from the current document
    ///  builder position.</p>
    ///</remarks>
    ///  <param name="bookmarkName">Name of the bookmark.</param>
    ///<returns>The bookmark start node that was just created.</returns>
    function StartColumnBookmark(bookmarkName: string): DNBookmarkStart;
    ///<summary>
    ///  Marks the current position in the document as a column bookmark end. The position must be in a table cell.
    ///</summary>
    ///<remarks><p>A column bookmark covers one or more columns in a range of rows. To create a valid bookmark you
    ///  need to call both <see cref="M:Aspose.Words.DocumentBuilder.StartColumnBookmark(System.String)" />
    ///  and <see cref="M:Aspose.Words.DocumentBuilder.EndColumnBookmark(System.String)" />
    ///  with the same
    ///<b>bookmarkName</b>
    ///  parameter.</p>
    ///  <p>Badly formed bookmarks or bookmarks with duplicate names will be ignored when the document is saved.</p>
    ///  <p>The actual position of the inserted <see cref="T:Aspose.Words.BookmarkEnd" />
    ///  node may differ from the current document
    ///  builder position.</p>
    ///</remarks>
    ///  <param name="bookmarkName">Name of the bookmark.</param>
    ///<returns>The bookmark end node that was just created.</returns>
    function EndColumnBookmark(bookmarkName: string): DNBookmarkEnd;
    ///<summary>
    ///  Marks the current position in the document as an editable range start.
    ///</summary>
    ///<remarks><p>Editable range in a document can overlap and span any range. To create a valid editable range you need to
    ///  call both <see cref="M:Aspose.Words.DocumentBuilder.StartEditableRange" />
    ///  and <see cref="M:Aspose.Words.DocumentBuilder.EndEditableRange" />
    ///  or <see cref="M:Aspose.Words.DocumentBuilder.EndEditableRange(Aspose.Words.EditableRangeStart)" />
    ///  methods.</p>
    ///  <p>Badly formed editable range will be ignored when the document is saved.</p>
    ///</remarks>
    ///<returns>The editable range start node that was just created.</returns>
    function StartEditableRange: DNEditableRangeStart;
    ///<summary>
    ///  Marks the current position in the document as an editable range end.
    ///</summary>
    ///<remarks><p>Editable range in a document can overlap and span any range. To create a valid editable range you need to
    ///  call both <see cref="M:Aspose.Words.DocumentBuilder.StartEditableRange" />
    ///  and <see cref="M:Aspose.Words.DocumentBuilder.EndEditableRange" />
    ///  or <see cref="M:Aspose.Words.DocumentBuilder.EndEditableRange(Aspose.Words.EditableRangeStart)" />
    ///  methods.</p>
    ///  <p>Badly formed editable range will be ignored when the document is saved.</p>
    ///</remarks>
    ///<returns>The editable range end node that was just created.</returns>
    function EndEditableRange: DNEditableRangeEnd; overload;
    ///<summary>
    ///  Marks the current position in the document as an editable range end.
    ///</summary>
    ///<remarks><p>Use this overload during creating nested editable ranges.</p>
    ///  <p>Editable range in a document can overlap and span any range. To create a valid editable range you need to
    ///  call both <see cref="M:Aspose.Words.DocumentBuilder.StartEditableRange" />
    ///  and <see cref="M:Aspose.Words.DocumentBuilder.EndEditableRange" />
    ///  or <see cref="M:Aspose.Words.DocumentBuilder.EndEditableRange(Aspose.Words.EditableRangeStart)" />
    ///  methods.</p>
    ///  <p>Badly formed editable range will be ignored when the document is saved.</p>
    ///</remarks>
    ///  <param name="start">This editable range start.</param>
    ///<returns>The editable range end node that was just created.</returns>
    function EndEditableRange(start: DNEditableRangeStart): DNEditableRangeEnd; overload;
    ///<summary>
    ///  Inserts a document at the cursor position.
    ///</summary>
    ///<remarks>
    ///  This method mimics the MS Word behavior, as if CTRL+'A' (select all content) was pressed,
    ///  then CTRL+'C' (copy selected into the buffer) inside one document
    ///  and then CTRL+'V' (insert content from the buffer) inside another document.
    ///</remarks>
    ///  <param name="srcDoc">Source document for inserting.</param>
    ///  <param name="importFormatMode">Specifies how to merge style formatting that clashes.</param>
    ///<returns>First node of the inserted content.</returns>
    function InsertDocument(srcDoc: DNDocument; importFormatMode: DNImportFormatMode): DNNode; overload;
    ///<summary>
    ///  Inserts a document at the cursor position.
    ///</summary>
    ///<remarks>
    ///  This method mimics the MS Word behavior, as if CTRL+'A' (select all content) was pressed,
    ///  then CTRL+'C' (copy selected into the buffer) inside one document
    ///  and then CTRL+'V' (insert content from the buffer) inside another document.
    ///</remarks>
    ///  <param name="srcDoc">Source document for inserting.</param>
    ///  <param name="importFormatMode">Specifies how to merge style formatting that clashes.</param>
    ///  <param name="importFormatOptions">Allows to specify options that affect formatting of a result document.</param>
    ///<returns>First node of the inserted content.</returns>
    function InsertDocument(srcDoc: DNDocument; importFormatMode: DNImportFormatMode; importFormatOptions: DNImportFormatOptions): DNNode; overload;
    ///<summary>
    ///  Saves current character formatting onto the stack.
    ///</summary>
    ///<seealso cref="P:Aspose.Words.DocumentBuilder.Font" />
    ///<seealso cref="M:Aspose.Words.DocumentBuilder.PopFont" />
    procedure PushFont;
    ///<summary>
    ///  Retrieves character formatting previously saved on the stack.
    ///</summary>
    ///<seealso cref="P:Aspose.Words.DocumentBuilder.Font" />
    ///<seealso cref="M:Aspose.Words.DocumentBuilder.PushFont" />
    procedure PopFont;
    ///<summary>
    ///  Inserts a text level node inside the current paragraph before the cursor.
    ///</summary>
    procedure InsertNode(node: DNNode);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the <see cref="P:Aspose.Words.DocumentBuilder.Document" />
    ///  object that this object is attached to.
    ///</summary>
    property Document: DNDocument read get_Document write set_Document;
    ///<summary>
    ///  Returns an object that represents current font formatting properties.
    ///</summary>
    ///<remarks><p>Use <b>Font</b>
    ///  to access and modify font formatting properties.</p>
    ///  <p>Specify font formatting before inserting text.</p>
    ///</remarks>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  True if the font is formatted as bold.
    ///</summary>
    property Bold: Boolean read get_Bold write set_Bold;
    ///<summary>
    ///  True if the font is formatted as italic.
    ///</summary>
    property Italic: Boolean read get_Italic write set_Italic;
    ///<summary>
    ///  Gets/sets underline type for the current font.
    ///</summary>
    property Underline: DNUnderline read get_Underline write set_Underline;
    ///<summary>
    ///  Returns an object that represents current paragraph formatting properties.
    ///</summary>
    property ParagraphFormat: DNParagraphFormat read get_ParagraphFormat;
    ///<summary>
    ///  Returns an object that represents current list formatting properties.
    ///</summary>
    property ListFormat: DNListFormat read get_ListFormat;
    ///<summary>
    ///  Returns an object that represents current page setup and section properties.
    ///</summary>
    property PageSetup: DNPageSetup read get_PageSetup;
    ///<summary>
    ///  Returns an object that represents current table row formatting properties.
    ///</summary>
    property RowFormat: DNRowFormat read get_RowFormat;
    ///<summary>
    ///  Returns an object that represents current table cell formatting properties.
    ///</summary>
    property CellFormat: DNCellFormat read get_CellFormat;
    ///<summary>
    ///  Returns true if the cursor is at the beginning of the current paragraph (no text before the cursor).
    ///</summary>
    property IsAtStartOfParagraph: Boolean read get_IsAtStartOfParagraph;
    ///<summary>
    ///  Returns true if the cursor is at the end of the current paragraph.
    ///</summary>
    property IsAtEndOfParagraph: Boolean read get_IsAtEndOfParagraph;
    ///<summary>
    ///  Gets the node that is currently selected in this DocumentBuilder.
    ///</summary>
    ///<remarks><p><b>CurrentNode</b>
    ///  is a cursor of <b>DocumentBuilder</b>
    ///  and points to a <b>Node</b>
    ///  that is a direct child of a <b>Paragraph</b>
    ///  . Any insert operations you perform using
    ///<b>DocumentBuilder</b>
    ///  will insert before the <b>CurrentNode</b>
    ///  .</p>
    ///  <p>When the current paragraph is empty or the cursor is positioned just
    ///  before the end of the paragraph, <b>CurrentNode</b>
    ///  returns null.</p>
    ///<seealso cref="P:Aspose.Words.DocumentBuilder.CurrentParagraph" />
    ///</remarks>
    property CurrentNode: DNNode read get_CurrentNode;
    ///<summary>
    ///  Gets the paragraph that is currently selected in this DocumentBuilder.
    ///</summary>
    ///<remarks><see cref="P:Aspose.Words.DocumentBuilder.CurrentNode" />
    ///</remarks>
    property CurrentParagraph: DNParagraph read get_CurrentParagraph;
    ///<summary>
    ///  Gets the story that is currently selected in this DocumentBuilder.
    ///</summary>
    property CurrentStory: DNStory read get_CurrentStory;
    ///<summary>
    ///  Gets the section that is currently selected in this DocumentBuilder.
    ///</summary>
    property CurrentSection: DNSection read get_CurrentSection;
  end;

  TDNDocumentBuilder = class(TDNGenericImport<DNDocumentBuilderClass, DNDocumentBuilder>) end;

  //-------------namespace: Aspose.Words----------------
  DNDocumentVisitorClass = interface(DDN.mscorlib.DNObjectClass)
  ['{323F9143-0670-516D-9CDD-F8139610CBDF}']
  end;

  ///<summary>
  ///  Base class for custom document visitors.
  ///</summary>
  ///<remarks><p>With <b>DocumentVisitor</b>
  ///  you can define and execute custom operations
  ///  that require enumeration over the document tree.</p>
  ///  <p>For example, Aspose.Words uses <b>DocumentVisitor</b>
  ///  internally for saving <b>Document</b>
  ///  in various formats and for other operations like finding fields or bookmarks over
  ///  a fragment of a document.</p>
  ///  <p>To use <b>DocumentVisitor</b>
  ///  :</p>
  ///<list type="number"><item>Create a class derived from <b>DocumentVisitor</b>
  ///  .</item>
  ///<item>Override and provide implementations for some or all of the VisitXXX methods
  ///  to perform some custom operations.</item>
  ///<item>Call <see cref="M:Aspose.Words.Node.Accept(Aspose.Words.DocumentVisitor)">Node.Accept</see> on the <b>Node</b>
  ///  that
  ///  you want to start the enumeration from.</item>
  ///</list>
  ///  <p><b>DocumentVisitor</b>
  ///  provides default implementations for all of the VisitXXX methods
  ///  to make it easier to create new document visitors as only the methods required for the particular
  ///  visitor need to be overridden. It is not necessary to override all of the visitor methods.</p>
  ///  <p>For more information see the Visitor design pattern.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.DocumentVisitor')]
  DNDocumentVisitor = interface(DDN.mscorlib.DNObject)
  ['{D85A796E-40BB-3E35-8470-5E1813082A83}']
  { methods } 

    ///<summary>
    ///  Called when enumeration of the document has started.
    ///</summary>
    ///  <param name="doc">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitDocumentStart(doc: DNDocument): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of the document has finished.
    ///</summary>
    ///  <param name="doc">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitDocumentEnd(doc: DNDocument): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a section has started.
    ///</summary>
    ///  <param name="section">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitSectionStart(section: DNSection): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a section has ended.
    ///</summary>
    ///  <param name="section">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitSectionEnd(section: DNSection): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of the main text story in a section has started.
    ///</summary>
    ///  <param name="body">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitBodyStart(body: DNBody): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of the main text story in a section has ended.
    ///</summary>
    ///  <param name="body">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitBodyEnd(body: DNBody): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a header or footer in a section has started.
    ///</summary>
    ///  <param name="headerFooter">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitHeaderFooterStart(headerFooter: DNHeaderFooter): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a header or footer in a section has ended.
    ///</summary>
    ///  <param name="headerFooter">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitHeaderFooterEnd(headerFooter: DNHeaderFooter): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a paragraph has started.
    ///</summary>
    ///  <param name="paragraph">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitParagraphStart(paragraph: DNParagraph): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a paragraph has ended.
    ///</summary>
    ///  <param name="paragraph">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitParagraphEnd(paragraph: DNParagraph): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a table has started.
    ///</summary>
    ///  <param name="table">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitTableStart(table: DNTable): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a table has ended.
    ///</summary>
    ///  <param name="table">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitTableEnd(table: DNTable): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a table row has started.
    ///</summary>
    ///  <param name="row">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitRowStart(row: DNRow): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a table row has ended.
    ///</summary>
    ///  <param name="row">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitRowEnd(row: DNRow): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a table cell has started.
    ///</summary>
    ///  <param name="cell">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitCellStart(cell: DNCell): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a table cell has ended.
    ///</summary>
    ///  <param name="cell">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitCellEnd(cell: DNCell): DNVisitorAction;
    ///<summary>
    ///  Called when a run of text in the is encountered.
    ///</summary>
    ///  <param name="run">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitRun(run: DNRun): DNVisitorAction;
    ///<summary>
    ///  Called when a field starts in the document.
    ///</summary>
    ///<remarks><p>A field in a Word Word document consists of a field code and field value.</p>
    ///  <p>For example, a field that displays a page number can be represented as follows:</p>
    ///  <p>[FieldStart]PAGE[FieldSeparator]98[FieldEnd]</p>
    ///  <p>The field separator separates field code from field value in the document. Note that some
    ///  fields have only field code and do not have field separator and field value.</p>
    ///  <p>Fields can be nested.</p>
    ///</remarks>
    ///  <param name="fieldStart">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitFieldStart(fieldStart: DNFieldStart): DNVisitorAction;
    ///<summary>
    ///  Called when a field separator is encountered in the document.
    ///</summary>
    ///<remarks><p>The field separator separates field code from field value in the document. Note that some
    ///  fields have only field code and do not have field separator and field value.</p>
    ///  <p>For more info see <see cref="M:Aspose.Words.DocumentVisitor.VisitFieldStart(Aspose.Words.Fields.FieldStart)" />
    ///</p>
    ///</remarks>
    ///  <param name="fieldSeparator">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitFieldSeparator(fieldSeparator: DNFieldSeparator): DNVisitorAction;
    ///<summary>
    ///  Called when a field ends in the document.
    ///</summary>
    ///<remarks><p>For more info see <see cref="M:Aspose.Words.DocumentVisitor.VisitFieldStart(Aspose.Words.Fields.FieldStart)" />
    ///</p>
    ///</remarks>
    ///  <param name="fieldEnd">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitFieldEnd(fieldEnd: DNFieldEnd): DNVisitorAction;
    ///<summary>
    ///  Called when a form field is encountered in the document.
    ///</summary>
    ///  <param name="formField">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitFormField(formField: DNFormField): DNVisitorAction;
    ///<summary>
    ///  Called when a start of a bookmark is encountered in the document.
    ///</summary>
    ///  <param name="bookmarkStart">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitBookmarkStart(bookmarkStart: DNBookmarkStart): DNVisitorAction;
    ///<summary>
    ///  Called when an end of a bookmark is encountered in the document.
    ///</summary>
    ///  <param name="bookmarkEnd">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitBookmarkEnd(bookmarkEnd: DNBookmarkEnd): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a footnote or endnote text has started.
    ///</summary>
    ///  <param name="footnote">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitFootnoteStart(footnote: DNFootnote): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a footnote or endnote text has ended.
    ///</summary>
    ///  <param name="footnote">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitFootnoteEnd(footnote: DNFootnote): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a comment text has started.
    ///</summary>
    ///  <param name="comment">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitCommentStart(comment: DNComment): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a comment text has ended.
    ///</summary>
    ///  <param name="comment">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitCommentEnd(comment: DNComment): DNVisitorAction;
    ///<summary>
    ///  Called when a start of an editable range is encountered in the document.
    ///</summary>
    ///  <param name="editableRangeStart">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitEditableRangeStart(editableRangeStart: DNEditableRangeStart): DNVisitorAction;
    ///<summary>
    ///  Called when an end of an editable range is encountered in the document.
    ///</summary>
    ///  <param name="editableRangeEnd">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitEditableRangeEnd(editableRangeEnd: DNEditableRangeEnd): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a shape has started.
    ///</summary>
    ///  <param name="shape">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitShapeStart(shape: DNShape): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a shape has ended.
    ///</summary>
    ///  <param name="shape">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitShapeEnd(shape: DNShape): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a group shape has started.
    ///</summary>
    ///  <param name="groupShape">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitGroupShapeStart(groupShape: DNGroupShape): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a group shape has ended.
    ///</summary>
    ///  <param name="groupShape">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitGroupShapeEnd(groupShape: DNGroupShape): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a Office Math object has started.
    ///</summary>
    ///  <param name="officeMath">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitOfficeMathStart(officeMath: DNOfficeMath): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a Office Math object has ended.
    ///</summary>
    ///  <param name="officeMath">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitOfficeMathEnd(officeMath: DNOfficeMath): DNVisitorAction;
    ///<summary>
    ///  Called when a <see cref="T:Aspose.Words.SpecialChar" />
    ///  node is encountered in the document.
    ///</summary>
    ///  <param name="specialChar">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    ///<remarks>
    ///  This method is not be called for generic control characters (see <see cref="T:Aspose.Words.ControlChar" />
    ///  ) that can be present in the document.
    ///</remarks>
    function VisitSpecialChar(specialChar: DNSpecialChar): DNVisitorAction;
    ///<summary>
    ///  Called when a <see cref="T:Aspose.Words.AbsolutePositionTab" />
    ///  node is encountered in the document.
    ///</summary>
    ///  <param name="tab">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitAbsolutePositionTab(tab: DNAbsolutePositionTab): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a smart tag has started.
    ///</summary>
    ///  <param name="smartTag">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitSmartTagStart(smartTag: DNSmartTag): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a smart tag has ended.
    ///</summary>
    ///  <param name="smartTag">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitSmartTagEnd(smartTag: DNSmartTag): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a structured document tag has started.
    ///</summary>
    ///  <param name="sdt">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitStructuredDocumentTagStart(sdt: DNStructuredDocumentTag): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a structured document tag has ended.
    ///</summary>
    ///  <param name="sdt">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitStructuredDocumentTagEnd(sdt: DNStructuredDocumentTag): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a glossary document has started.
    ///</summary>
    ///<remarks><para>
    ///  Note: A glossary document node and its children are not visited when you execute a
    ///  Visitor over a <see cref="T:Aspose.Words.Document" />
    ///  . If you want to execute a Visitor over a
    ///  glossary document, you need to call <see cref="M:Aspose.Words.BuildingBlocks.GlossaryDocument.Accept(Aspose.Words.DocumentVisitor)" />
    ///  .
    ///</para></remarks>
    ///  <param name="glossary">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitGlossaryDocumentStart(glossary: DNGlossaryDocument): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a glossary document has ended.
    ///</summary>
    ///<remarks><para>
    ///  Note: A glossary document node and its children are not visited when you execute a
    ///  Visitor over a <see cref="T:Aspose.Words.Document" />
    ///  . If you want to execute a Visitor over a
    ///  glossary document, you need to call <see cref="M:Aspose.Words.BuildingBlocks.GlossaryDocument.Accept(Aspose.Words.DocumentVisitor)" />
    ///  .
    ///</para></remarks>
    ///  <param name="glossary">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitGlossaryDocumentEnd(glossary: DNGlossaryDocument): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a building block has started.
    ///</summary>
    ///<remarks><para>
    ///  Note: A building block node and its children are not visited when you execute a
    ///  Visitor over a <see cref="T:Aspose.Words.Document" />
    ///  . If you want to execute a Visitor over a
    ///  building block, you need to execute the visitor over <see cref="T:Aspose.Words.BuildingBlocks.GlossaryDocument" />
    ///  or
    ///  call <see cref="M:Aspose.Words.BuildingBlocks.BuildingBlock.Accept(Aspose.Words.DocumentVisitor)" />
    ///  .
    ///</para></remarks>
    ///  <param name="block">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitBuildingBlockStart(block: DNBuildingBlock): DNVisitorAction;
    ///<summary>
    ///  Called when enumeration of a building block has ended.
    ///</summary>
    ///<remarks><para>
    ///  Note: A building block node and its children are not visited when you execute a
    ///  Visitor over a <see cref="T:Aspose.Words.Document" />
    ///  . If you want to execute a Visitor over a
    ///  building block, you need to execute the visitor over <see cref="T:Aspose.Words.BuildingBlocks.GlossaryDocument" />
    ///  or
    ///  call <see cref="M:Aspose.Words.BuildingBlocks.BuildingBlock.Accept(Aspose.Words.DocumentVisitor)" />
    ///  .
    ///</para></remarks>
    ///  <param name="block">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitBuildingBlockEnd(block: DNBuildingBlock): DNVisitorAction;
    ///<summary>
    ///  Called when the start of a commented range of text is encountered.
    ///</summary>
    ///  <param name="commentRangeStart">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitCommentRangeStart(commentRangeStart: DNCommentRangeStart): DNVisitorAction;
    ///<summary>
    ///  Called when the end of a commented range of text is encountered.
    ///</summary>
    ///  <param name="commentRangeEnd">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitCommentRangeEnd(commentRangeEnd: DNCommentRangeEnd): DNVisitorAction;
    ///<summary>
    ///  Called when a subDocument is encountered.
    ///</summary>
    ///  <param name="subDocument">The object that is being visited.</param>
    ///<returns>A <see cref="T:Aspose.Words.VisitorAction" />
    ///  value that specifies how to continue the enumeration.</returns>
    function VisitSubDocument(subDocument: DNSubDocument): DNVisitorAction;
    function VisitStructuredDocumentTagRangeStart(sdtRangeStart: DNStructuredDocumentTagRangeStart): DNVisitorAction;
    function VisitStructuredDocumentTagRangeEnd(sdtRangeEnd: DNStructuredDocumentTagRangeEnd): DNVisitorAction;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNDocumentVisitor = class(TDNGenericImport<DNDocumentVisitorClass, DNDocumentVisitor>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNAxisBoundClass = interface(DDN.mscorlib.DNObjectClass)
  ['{28738D18-BB5E-5EEE-91FE-8B04B7FF9062}']
  { constructors } 

    ///<summary>
    ///  Creates a new instance indicating that axis bound should be determined automatically by a word-processing
    ///  application.
    ///</summary>
    {class} function init: DNAxisBound; overload;
    ///<summary>
    ///  Creates an axis bound represented as a number.
    ///</summary>
    {class} function init(value: Double): DNAxisBound; overload;
    ///<summary>
    ///  Creates an axis bound represented as datetime value.
    ///</summary>
    {class} function init(datetime: DDN.mscorlib.DNDateTime): DNAxisBound; overload;

  end;

  ///<summary>
  ///  Represents minimum or maximum bound of axis values.
  ///</summary>
  ///<remarks><para>Bound can be specified as a numeric, datetime or a special "auto" value.</para><para>The instances of this class are immutable.</para><seealso cref="P:Aspose.Words.Drawing.Charts.AxisScaling.Minimum" />
  ///<seealso cref="P:Aspose.Words.Drawing.Charts.AxisScaling.Maximum" />
  ///</remarks>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisBound')]
  DNAxisBound = interface(DDN.mscorlib.DNObject)
  ['{EAB4C2EF-3411-3272-8A99-4813A13B76E6}']
  { getters & setters } 

    function get_IsAuto: Boolean;
    function get_Value: Double;
    function get_ValueAsDate: DDN.mscorlib.DNDateTime;

  { methods } 

    ///<summary>
    ///  Determines whether the specified object is equal in value to the current object.
    ///</summary>
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    ///<summary>
    ///  Serves as a hash function for this type.
    ///</summary>
    function GetHashCode: Int32;
    ///<summary>
    ///  Returns a user-friendly string that displays the value of this object.
    ///</summary>
    function ToString: string;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Returns a flag indicating that axis bound should be determined automatically.
    ///</summary>
    property IsAuto: Boolean read get_IsAuto;
    ///<summary>
    ///  Returns numeric value of axis bound.
    ///</summary>
    property Value: Double read get_Value;
    ///<summary>
    ///  Returns value of axis bound represented as datetime.
    ///</summary>
    property ValueAsDate: DDN.mscorlib.DNDateTime read get_ValueAsDate;
  end;

  TDNAxisBound = class(TDNGenericImport<DNAxisBoundClass, DNAxisBound>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNAxisDisplayUnitClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F194AF7F-CF69-5F09-B736-1C6BEB4E80DE}']
  { constructors } 

    {class} function init: DNAxisDisplayUnit;

  end;

  ///<summary>
  ///  Provides access to the scaling options of the display units for the value axis.
  ///</summary>
  ///<dev>
  ///  Corresponds to the dispUnits element (5.7.2.45, 21.2.2.45).
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisDisplayUnit')]
  DNAxisDisplayUnit = interface(DDN.mscorlib.DNObject)
  ['{EA7634FD-7808-3D58-831F-54635B759846}']
  { getters & setters } 

    function get_Unit: DNAxisBuiltInUnit;
    procedure set_Unit(value: DNAxisBuiltInUnit);
    function get_CustomUnit: Double;
    procedure set_CustomUnit(value: Double);
    function get_Document: DNDocumentBase;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the scaling value of the display units as one of the predefined values.
    ///</summary>
    ///<remarks>
    ///  Default value is <see cref="F:Aspose.Words.Drawing.Charts.AxisBuiltInUnit.None" />
    ///  . The <see cref="F:Aspose.Words.Drawing.Charts.AxisBuiltInUnit.Custom" />
    ///  and
    ///<see cref="F:Aspose.Words.Drawing.Charts.AxisBuiltInUnit.Percentage" />
    ///  values are not available in some chart types; see
    ///<see cref="T:Aspose.Words.Drawing.Charts.AxisBuiltInUnit" />
    ///  for more information.
    ///</remarks>
    property &Unit: DNAxisBuiltInUnit read get_Unit write set_Unit;
    ///<summary>
    ///  Gets or sets a user-defined divisor to scale display units on the value axis.
    ///</summary>
    ///<remarks><para>The property is not supported by MS Office 2016 new charts. Default value is 1.</para><para>Setting this property sets the <see cref="P:Aspose.Words.Drawing.Charts.AxisDisplayUnit.Unit" />
    ///  property to
    ///<see cref="F:Aspose.Words.Drawing.Charts.AxisBuiltInUnit.Custom" />
    ///  .</para></remarks>
    property CustomUnit: Double read get_CustomUnit write set_CustomUnit;
    ///<summary>
    ///  Returns the Document the title holder belongs.
    ///</summary>
    property Document: DNDocumentBase read get_Document;
  end;

  TDNAxisDisplayUnit = class(TDNGenericImport<DNAxisDisplayUnitClass, DNAxisDisplayUnit>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNAxisScalingClass = interface(DDN.mscorlib.DNObjectClass)
  ['{5FC90868-C377-52A2-B458-F6BF5DCCDFF9}']
  { constructors } 

    {class} function init: DNAxisScaling;

  end;

  ///<summary>
  ///  Represents the scaling options of the axis.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.AxisScaling')]
  DNAxisScaling = interface(DDN.mscorlib.DNObject)
  ['{836D6C82-28F2-3743-9A14-5E623546A222}']
  { getters & setters } 

    function get_Type: DNAxisScaleType;
    procedure set_Type(value: DNAxisScaleType);
    function get_LogBase: Double;
    procedure set_LogBase(value: Double);
    function get_Minimum: DNAxisBound;
    procedure set_Minimum(value: DNAxisBound);
    function get_Maximum: DNAxisBound;
    procedure set_Maximum(value: DNAxisBound);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets scaling type of the axis.
    ///</summary>
    ///<remarks>
    ///  The <see cref="F:Aspose.Words.Drawing.Charts.AxisScaleType.Linear" />
    ///  value is the only that is allowed in MS Office 2016 new charts.
    ///</remarks>
    property &Type: DNAxisScaleType read get_Type write set_Type;
    ///<summary>
    ///  Gets or sets the logarithmic base for a logarithmic axis.
    ///</summary>
    ///<remarks><para>The property is not supported by MS Office 2016 new charts.</para><para>Valid range of a floating point value is greater than or equal to 2 and less than or
    ///  equal to 1000. The property has effect only if <see cref="P:Aspose.Words.Drawing.Charts.AxisScaling.Type" />
    ///  is set to
    ///<see cref="F:Aspose.Words.Drawing.Charts.AxisScaleType.Logarithmic" />
    ///  .</para><para>Setting this property sets the <see cref="P:Aspose.Words.Drawing.Charts.AxisScaling.Type" />
    ///  property to <see cref="F:Aspose.Words.Drawing.Charts.AxisScaleType.Logarithmic" />
    ///  .
    ///</para></remarks>
    property LogBase: Double read get_LogBase write set_LogBase;
    ///<summary>
    ///  Gets or sets minimum value of the axis.
    ///</summary>
    ///<remarks>
    ///  The default value is "auto".
    ///</remarks>
    property Minimum: DNAxisBound read get_Minimum write set_Minimum;
    ///<summary>
    ///  Gets or sets the maximum value of the axis.
    ///</summary>
    ///<remarks>
    ///  The default value is "auto".
    ///</remarks>
    property Maximum: DNAxisBound read get_Maximum write set_Maximum;
  end;

  TDNAxisScaling = class(TDNGenericImport<DNAxisScalingClass, DNAxisScaling>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartClass = interface(DDN.mscorlib.DNObjectClass)
  ['{8C5ED8B4-A909-52CB-AAB1-DE13A16CB6A2}']
  end;

  ///<summary>
  ///  Provides access to the chart shape properties.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.Chart')]
  DNChart = interface(DDN.mscorlib.DNObject)
  ['{6DC43F75-51E2-37E8-B539-5ACB15C8C080}']
  { getters & setters } 

    function get_Series: DNChartSeriesCollection;
    function get_Title: DNChartTitle;
    function get_Legend: DNChartLegend;
    function get_AxisX: DNChartAxis;
    function get_AxisY: DNChartAxis;
    function get_AxisZ: DNChartAxis;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Provides access to series collection.
    ///</summary>
    property Series: DNChartSeriesCollection read get_Series;
    ///<summary>
    ///  Provides access to the chart title properties.
    ///</summary>
    property Title: DNChartTitle read get_Title;
    ///<summary>
    ///  Provides access to the chart legend properties.
    ///</summary>
    property Legend: DNChartLegend read get_Legend;
    ///<summary>
    ///  Provides access to properties of the X axis of the chart.
    ///</summary>
    property AxisX: DNChartAxis read get_AxisX;
    ///<summary>
    ///  Provides access to properties of the Y axis of the chart.
    ///</summary>
    property AxisY: DNChartAxis read get_AxisY;
    ///<summary>
    ///  Provides access to properties of the Z axis of the chart.
    ///</summary>
    property AxisZ: DNChartAxis read get_AxisZ;
  end;

  TDNChart = class(TDNGenericImport<DNChartClass, DNChart>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartAxisClass = interface(DDN.mscorlib.DNObjectClass)
  ['{1685D859-DA02-53E3-BB04-B256B973F0D8}']
  end;

  ///<summary>
  ///  Represents the axis options of the chart.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartAxis')]
  DNChartAxis = interface(DDN.mscorlib.DNObject)
  ['{2445888D-0C29-3754-9E90-2F4E3EA9EC51}']
  { getters & setters } 

    function get_Type: DNChartAxisType;
    function get_CategoryType: DNAxisCategoryType;
    procedure set_CategoryType(value: DNAxisCategoryType);
    function get_Crosses: DNAxisCrosses;
    procedure set_Crosses(value: DNAxisCrosses);
    function get_CrossesAt: Double;
    procedure set_CrossesAt(value: Double);
    function get_ReverseOrder: Boolean;
    procedure set_ReverseOrder(value: Boolean);
    function get_MajorTickMark: DNAxisTickMark;
    procedure set_MajorTickMark(value: DNAxisTickMark);
    function get_MinorTickMark: DNAxisTickMark;
    procedure set_MinorTickMark(value: DNAxisTickMark);
    function get_TickLabelPosition: DNAxisTickLabelPosition;
    procedure set_TickLabelPosition(value: DNAxisTickLabelPosition);
    function get_MajorUnit: Double;
    procedure set_MajorUnit(value: Double);
    function get_MajorUnitIsAuto: Boolean;
    procedure set_MajorUnitIsAuto(value: Boolean);
    function get_MajorUnitScale: DNAxisTimeUnit;
    procedure set_MajorUnitScale(value: DNAxisTimeUnit);
    function get_MinorUnit: Double;
    procedure set_MinorUnit(value: Double);
    function get_MinorUnitIsAuto: Boolean;
    procedure set_MinorUnitIsAuto(value: Boolean);
    function get_MinorUnitScale: DNAxisTimeUnit;
    procedure set_MinorUnitScale(value: DNAxisTimeUnit);
    function get_BaseTimeUnit: DNAxisTimeUnit;
    procedure set_BaseTimeUnit(value: DNAxisTimeUnit);
    function get_NumberFormat: DNChartNumberFormat;
    function get_TickLabelOffset: Int32;
    procedure set_TickLabelOffset(value: Int32);
    function get_DisplayUnit: DNAxisDisplayUnit;
    function get_AxisBetweenCategories: Boolean;
    procedure set_AxisBetweenCategories(value: Boolean);
    function get_Scaling: DNAxisScaling;
    function get_TickLabelSpacing: Int32;
    procedure set_TickLabelSpacing(value: Int32);
    function get_TickLabelSpacingIsAuto: Boolean;
    procedure set_TickLabelSpacingIsAuto(value: Boolean);
    function get_TickLabelAlignment: DNParagraphAlignment;
    procedure set_TickLabelAlignment(value: DNParagraphAlignment);
    function get_TickMarkSpacing: Int32;
    procedure set_TickMarkSpacing(value: Int32);
    function get_Hidden: Boolean;
    procedure set_Hidden(value: Boolean);
    function get_Document: DNDocumentBase;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Returns type of the axis.
    ///</summary>
    property &Type: DNChartAxisType read get_Type;
    ///<summary>
    ///  Gets or sets type of the category axis.
    ///</summary>
    ///<remarks>
    ///  Only text categories (<see cref="F:Aspose.Words.Drawing.Charts.AxisCategoryType.Category" />
    ///  ) are allowed in MS Office 2016 new charts.
    ///</remarks>
    ///<dev>
    ///  The property is internally represented as two bool attributes since the <see cref="T:Aspose.Words.Drawing.Charts.AxisCategoryType" />
    ///  type
    ///  provides no enough information that is needed to store the property in document file.
    ///</dev>
    property CategoryType: DNAxisCategoryType read get_CategoryType write set_CategoryType;
    ///<summary>
    ///  Specifies how this axis crosses the perpendicular axis.
    ///</summary>
    ///<remarks><para>Default value is <see cref="F:Aspose.Words.Drawing.Charts.AxisCrosses.Automatic" />
    ///  .</para><para>The property is not supported by MS Office 2016 new charts.</para></remarks>
    property Crosses: DNAxisCrosses read get_Crosses write set_Crosses;
    ///<summary>
    ///  Specifies where on the perpendicular axis the axis crosses.
    ///</summary>
    ///<remarks><para>The property has effect only if <see cref="P:Aspose.Words.Drawing.Charts.ChartAxis.Crosses" />
    ///  are set to <see cref="F:Aspose.Words.Drawing.Charts.AxisCrosses.Custom" />
    ///  .
    ///  It is not supported by MS Office 2016 new charts.</para><para>The units are determined by the type of axis. When the axis is a value axis, the value of the property
    ///  is a decimal number on the value axis. When the axis is a time category axis, the value is defined as
    ///  an integer number of days relative to the base date (30/12/1899). For a text category axis, the value is
    ///  an integer category number, starting with 1 as the first category.</para></remarks>
    property CrossesAt: Double read get_CrossesAt write set_CrossesAt;
    ///<summary>
    ///  Returns or sets a flag indicating whether values of axis should be displayed in reverse order, i.e.
    ///  from max to min.
    ///</summary>
    ///<remarks>
    ///  The property is not supported by MS Office 2016 new charts. Default value is <b>false</b>
    ///  .
    ///</remarks>
    property ReverseOrder: Boolean read get_ReverseOrder write set_ReverseOrder;
    ///<summary>
    ///  Returns or sets the major tick marks.
    ///</summary>
    property MajorTickMark: DNAxisTickMark read get_MajorTickMark write set_MajorTickMark;
    ///<summary>
    ///  Returns or sets the minor tick marks for the axis.
    ///</summary>
    property MinorTickMark: DNAxisTickMark read get_MinorTickMark write set_MinorTickMark;
    ///<summary>
    ///  Returns or sets the position of the tick labels on the axis.
    ///</summary>
    ///<remarks>
    ///  The property is not supported by MS Office 2016 new charts.
    ///</remarks>
    property TickLabelPosition: DNAxisTickLabelPosition read get_TickLabelPosition write set_TickLabelPosition;
    ///<summary>
    ///  Returns or sets the distance between major tick marks.
    ///</summary>
    ///<remarks><para>Valid range of a value is greater than zero. The property has effect for time category and
    ///  value axes.</para><para>Setting this property sets the <see cref="P:Aspose.Words.Drawing.Charts.ChartAxis.MajorUnitIsAuto" />
    ///  property to <b>false</b>
    ///  .</para></remarks>
    property MajorUnit: Double read get_MajorUnit write set_MajorUnit;
    ///<summary>
    ///  Gets or sets a flag indicating whether default distance between major tick marks shall be used.
    ///</summary>
    ///<remarks>
    ///  The property has effect for time category and value axes.
    ///</remarks>
    property MajorUnitIsAuto: Boolean read get_MajorUnitIsAuto write set_MajorUnitIsAuto;
    ///<summary>
    ///  Returns or sets the scale value for major tick marks on the time category axis.
    ///</summary>
    ///<remarks>
    ///  The property has effect only for time category axes.
    ///</remarks>
    property MajorUnitScale: DNAxisTimeUnit read get_MajorUnitScale write set_MajorUnitScale;
    ///<summary>
    ///  Returns or sets the distance between minor tick marks.
    ///</summary>
    ///<remarks><para>Valid range of a value is greater than zero. The property has effect for time category and
    ///  value axes.</para><para>Setting this property sets the <see cref="P:Aspose.Words.Drawing.Charts.ChartAxis.MinorUnitIsAuto" />
    ///  property to <b>false</b>
    ///  .</para></remarks>
    property MinorUnit: Double read get_MinorUnit write set_MinorUnit;
    ///<summary>
    ///  Gets or sets a flag indicating whether default distance between minor tick marks shall be used.
    ///</summary>
    ///<remarks>
    ///  The property has effect for time category and value axes.
    ///</remarks>
    property MinorUnitIsAuto: Boolean read get_MinorUnitIsAuto write set_MinorUnitIsAuto;
    ///<summary>
    ///  Returns or sets the scale value for minor tick marks on the time category axis.
    ///</summary>
    ///<remarks>
    ///  The property has effect only for time category axes.
    ///</remarks>
    property MinorUnitScale: DNAxisTimeUnit read get_MinorUnitScale write set_MinorUnitScale;
    ///<summary>
    ///  Returns or sets the smallest time unit that is represented on the time category axis.
    ///</summary>
    ///<remarks>
    ///  The property has effect only for time category axes.
    ///</remarks>
    property BaseTimeUnit: DNAxisTimeUnit read get_BaseTimeUnit write set_BaseTimeUnit;
    ///<summary>
    ///  Returns a <see cref="T:Aspose.Words.Drawing.Charts.ChartNumberFormat" />
    ///  object that allows defining number formats for the axis.
    ///</summary>
    property NumberFormat: DNChartNumberFormat read get_NumberFormat;
    ///<summary>
    ///  Gets or sets the distance of labels from the axis.
    ///</summary>
    ///<remarks><para>The property represents a percentage of the default label offset.</para><para>Valid range is from 0 to 1000 percent inclusive. Default value is 100%.</para><para>The property has effect only for category axes. It is not supported by MS Office 2016 new charts.</para></remarks>
    property TickLabelOffset: Int32 read get_TickLabelOffset write set_TickLabelOffset;
    ///<summary>
    ///  Specifies the scaling value of the display units for the value axis.
    ///</summary>
    ///<remarks>
    ///  The property has effect only for value axes.
    ///</remarks>
    property DisplayUnit: DNAxisDisplayUnit read get_DisplayUnit;
    ///<summary>
    ///  Gets or sets a flag indicating whether the value axis crosses the category axis between categories.
    ///</summary>
    ///<remarks>
    ///  The property has effect only for value axes. It is not supported by MS Office 2016 new charts.
    ///</remarks>
    property AxisBetweenCategories: Boolean read get_AxisBetweenCategories write set_AxisBetweenCategories;
    ///<summary>
    ///  Provides access to the scaling options of the axis.
    ///</summary>
    property Scaling: DNAxisScaling read get_Scaling;
    ///<summary>
    ///  Gets or sets the interval, at which tick labels are drawn.
    ///</summary>
    ///<remarks><para>The property has effect for text category and series axes. It is not supported by MS Office 2016
    ///  new charts. Valid range of a value is greater than or equal to 1.</para><para>Setting this property sets the <see cref="P:Aspose.Words.Drawing.Charts.ChartAxis.TickLabelSpacingIsAuto" />
    ///  property to <b>false</b>
    ///  .</para></remarks>
    ///<dev>
    ///  The ISO standard states that this element specifies how many tick labels to skip between label that is drawn.
    ///  In MS Office, this element specifies the interval at which tick labels are drawn.
    ///</dev>
    property TickLabelSpacing: Int32 read get_TickLabelSpacing write set_TickLabelSpacing;
    ///<summary>
    ///  Gets or sets a flag indicating whether automatic interval of drawing tick labels shall be used.
    ///</summary>
    ///<remarks><para>Default value is <b>true</b>
    ///  .</para><para>The property has effect for text category and series axes. It is not supported by MS Office 2016
    ///  new charts.</para></remarks>
    property TickLabelSpacingIsAuto: Boolean read get_TickLabelSpacingIsAuto write set_TickLabelSpacingIsAuto;
    ///<summary>
    ///  Gets or sets text alignment of axis tick labels.
    ///</summary>
    ///<remarks><para>This property has effect only for multi-line labels.</para><para>Default value is <see cref="F:Aspose.Words.ParagraphAlignment.Center" />
    ///  .</para>.
    ///</remarks>
    property TickLabelAlignment: DNParagraphAlignment read get_TickLabelAlignment write set_TickLabelAlignment;
    ///<summary>
    ///  Gets or sets the interval, at which tick marks are drawn.
    ///</summary>
    ///<remarks><para>The property has effect for text category and series axes. It is not supported by MS Office 2016
    ///  new charts.</para><para>Valid range of a value is greater than or equal to 1.</para></remarks>
    ///<dev>
    ///  The ISO standard states that this element specifies how many tick marks shall be skipped before the next
    ///  one shall be drawn.
    ///  In MS Office, this element specifies the interval at which tick marks are drawn.
    ///</dev>
    property TickMarkSpacing: Int32 read get_TickMarkSpacing write set_TickMarkSpacing;
    ///<summary>
    ///  Gets or sets a flag indicating whether this axis is hidden or not.
    ///</summary>
    ///<remarks>
    ///  Default value is <b>false</b>
    ///  .
    ///</remarks>
    ///<dev>
    ///  Corresponds to the 21.2.2.40 delete element [ISO/IEC 29500] and to the hidden attribute of the 2.24.3.3
    ///  CT_Axis complex type [MS-ODRAWXML].
    ///</dev>
    property Hidden: Boolean read get_Hidden write set_Hidden;
    ///<summary>
    ///  Returns the Document the title holder belongs.
    ///</summary>
    property Document: DNDocumentBase read get_Document;
  end;

  TDNChartAxis = class(TDNGenericImport<DNChartAxisClass, DNChartAxis>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartDataLabelClass = interface(DDN.mscorlib.DNObjectClass)
  ['{030A9074-15A0-5B06-BB6A-6CF3772B1C08}']
  end;

  ///<summary>
  ///  Represents data label on a chart point or trendline.
  ///</summary>
  ///<remarks>
  ///  On a series, the <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabel" />
  ///  object is a member of the <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabelCollection" />
  ///  .
  ///  The <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabelCollection" />
  ///  contains a <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabel" />
  ///  object for each point.
  ///</remarks>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartDataLabel')]
  DNChartDataLabel = interface(DDN.mscorlib.DNObject)
  ['{F0D579EC-6759-3439-BEB6-D262B8BBE192}']
  { getters & setters } 

    function get_Index: Int32;
    function get_ShowCategoryName: Boolean;
    procedure set_ShowCategoryName(value: Boolean);
    function get_ShowBubbleSize: Boolean;
    procedure set_ShowBubbleSize(value: Boolean);
    function get_ShowLegendKey: Boolean;
    procedure set_ShowLegendKey(value: Boolean);
    function get_ShowPercentage: Boolean;
    procedure set_ShowPercentage(value: Boolean);
    function get_ShowSeriesName: Boolean;
    procedure set_ShowSeriesName(value: Boolean);
    function get_ShowValue: Boolean;
    procedure set_ShowValue(value: Boolean);
    function get_ShowLeaderLines: Boolean;
    procedure set_ShowLeaderLines(value: Boolean);
    function get_ShowDataLabelsRange: Boolean;
    procedure set_ShowDataLabelsRange(value: Boolean);
    function get_Separator: string;
    procedure set_Separator(value: string);
    function get_IsVisible: Boolean;
    function get_NumberFormat: DNChartNumberFormat;
    function get_IsHidden: Boolean;
    procedure set_IsHidden(value: Boolean);

  { methods } 

    ///<summary>
    ///  Clears format of this data label. The properties are set to the default values defined in the parent data
    ///  label collection.
    ///</summary>
    procedure ClearFormat;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Specifies the index of the containing element.
    ///  This index shall determine which of the parent's children collection this element applies to.
    ///  Default value is 0.
    ///</summary>
    property Index: Int32 read get_Index;
    ///<summary>
    ///  Allows to specify if category name is to be displayed for the data labels on a chart.
    ///  Default value is false.
    ///</summary>
    property ShowCategoryName: Boolean read get_ShowCategoryName write set_ShowCategoryName;
    ///<summary>
    ///  Allows to specify if bubble size is to be displayed for the data labels on a chart.
    ///  Applies only to Bubble charts.
    ///  Default value is false.
    ///</summary>
    property ShowBubbleSize: Boolean read get_ShowBubbleSize write set_ShowBubbleSize;
    ///<summary>
    ///  Allows to specify if legend key is to be displayed for the data labels on a chart.
    ///  Default value is false.
    ///</summary>
    property ShowLegendKey: Boolean read get_ShowLegendKey write set_ShowLegendKey;
    ///<summary>
    ///  Allows to specify if percentage value is to be displayed for the data labels on a chart.
    ///  Default value is false.
    ///</summary>
    property ShowPercentage: Boolean read get_ShowPercentage write set_ShowPercentage;
    ///<summary>
    ///  Returns or sets a Boolean to indicate the series name display behavior for the data labels on a chart.
    ///  True to show the series name. False to hide. By default false.
    ///</summary>
    property ShowSeriesName: Boolean read get_ShowSeriesName write set_ShowSeriesName;
    ///<summary>
    ///  Allows to specify if values are to be displayed in the data labels.
    ///  Default value is false.
    ///</summary>
    property ShowValue: Boolean read get_ShowValue write set_ShowValue;
    ///<summary>
    ///  Allows to specify if data label leader lines need be shown.
    ///  Default value is false.
    ///</summary>
    ///<remarks>
    ///  Applies to Pie charts only.
    ///  Leader lines create a visual connection between a data label and its corresponding data point.
    ///</remarks>
    property ShowLeaderLines: Boolean read get_ShowLeaderLines write set_ShowLeaderLines;
    ///<summary>
    ///  Allows to specify if values from data labels range to be displayed in the data labels.
    ///  Default value is false.
    ///</summary>
    property ShowDataLabelsRange: Boolean read get_ShowDataLabelsRange write set_ShowDataLabelsRange;
    ///<summary>
    ///  Gets or sets string separator used for the data labels on a chart.
    ///  The default is a comma, except for pie charts showing only category name and percentage, when a line break
    ///  shall be used instead.
    ///</summary>
    property Separator: string read get_Separator write set_Separator;
    ///<summary>
    ///  Returns true if this data label has something to display.
    ///</summary>
    property IsVisible: Boolean read get_IsVisible;
    ///<summary>
    ///  Returns number format of the parent element.
    ///</summary>
    property NumberFormat: DNChartNumberFormat read get_NumberFormat;
    ///<summary>
    ///  Gets/sets a flag indicating whether this label is hidden.
    ///  The default value is <b>false</b>
    ///  .
    ///</summary>
    property IsHidden: Boolean read get_IsHidden write set_IsHidden;
  end;

  TDNChartDataLabel = class(TDNGenericImport<DNChartDataLabelClass, DNChartDataLabel>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartDataLabelCollectionClass = interface(DNObjectClass)
  ['{B63A467D-6D95-5DEF-A0F0-ED21EAA80CED}']
  end;

  ///<summary>
  ///  Represents a collection of <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabel" />
  ///  .
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartDataLabelCollection')]
  DNChartDataLabelCollection = interface(DDN.mscorlib.DNIEnumerable)
  ['{A0F8F56B-A030-35A5-9D4A-F8DFE536C605}']
  { getters & setters } 

    function get_Item(index: Int32): DNChartDataLabel;
    function get_Count: Int32;
    function get_ShowCategoryName: Boolean;
    procedure set_ShowCategoryName(value: Boolean);
    function get_ShowBubbleSize: Boolean;
    procedure set_ShowBubbleSize(value: Boolean);
    function get_ShowLegendKey: Boolean;
    procedure set_ShowLegendKey(value: Boolean);
    function get_ShowPercentage: Boolean;
    procedure set_ShowPercentage(value: Boolean);
    function get_ShowSeriesName: Boolean;
    procedure set_ShowSeriesName(value: Boolean);
    function get_ShowValue: Boolean;
    procedure set_ShowValue(value: Boolean);
    function get_ShowLeaderLines: Boolean;
    procedure set_ShowLeaderLines(value: Boolean);
    function get_ShowDataLabelsRange: Boolean;
    procedure set_ShowDataLabelsRange(value: Boolean);
    function get_Separator: string;
    procedure set_Separator(value: string);
    function get_NumberFormat: DNChartNumberFormat;

  { methods } 

    ///<summary>
    ///  Returns an enumerator object.
    ///</summary>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNChartDataLabel>;
    ///<summary>
    ///  Adds new <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabel" />
    ///  at the specified index.
    ///</summary>
    ///  <param name="index">Target data label index.</param>
    function Add(index: Int32): DNChartDataLabel;
    ///<summary>
    ///  Clears format of a <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabel" />
    ///  at the specified index.
    ///</summary>
    ///  <param name="index">The zero-based index of the chart data label to clear format.</param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Clears format of all <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabel" />
    ///  in this collection.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Clears format of all <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabel" />
    ///  in this collection.
    ///</summary>
    procedure ClearFormat;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNChartDataLabel read get_Item; default;
    ///<summary>
    ///  Returns the number of <see cref="T:Aspose.Words.Drawing.Charts.ChartDataLabel" />
    ///  in this collection.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Allows to specify whether category name is to be displayed for the data labels of the entire series.
    ///  Default value is <b>false</b>
    ///  .
    ///</summary>
    ///<remarks>
    ///  Value defined for this property can be overridden for an individual data label with using the
    ///<see cref="P:Aspose.Words.Drawing.Charts.ChartDataLabel.ShowCategoryName" />
    ///  property.
    ///</remarks>
    property ShowCategoryName: Boolean read get_ShowCategoryName write set_ShowCategoryName;
    ///<summary>
    ///  Allows to specify whether bubble size is to be displayed for the data labels of the entire series.
    ///  Applies only to Bubble charts.
    ///  Default value is <b>false</b>
    ///  .
    ///</summary>
    ///<remarks>
    ///  Value defined for this property can be overridden for an individual data label with using the
    ///<see cref="P:Aspose.Words.Drawing.Charts.ChartDataLabel.ShowBubbleSize" />
    ///  property.
    ///</remarks>
    property ShowBubbleSize: Boolean read get_ShowBubbleSize write set_ShowBubbleSize;
    ///<summary>
    ///  Allows to specify whether legend key is to be displayed for the data labels of the entire series.
    ///  Default value is <b>false</b>
    ///  .
    ///</summary>
    ///<remarks>
    ///  Value defined for this property can be overridden for an individual data label with using the
    ///<see cref="P:Aspose.Words.Drawing.Charts.ChartDataLabel.ShowLegendKey" />
    ///  property.
    ///</remarks>
    property ShowLegendKey: Boolean read get_ShowLegendKey write set_ShowLegendKey;
    ///<summary>
    ///  Allows to specify whether percentage value is to be displayed for the data labels of the entire series.
    ///  Default value is <b>false</b>
    ///  . Applies only to Pie charts.
    ///</summary>
    ///<remarks>
    ///  Value defined for this property can be overridden for an individual data label with using the
    ///<see cref="P:Aspose.Words.Drawing.Charts.ChartDataLabel.ShowPercentage" />
    ///  property.
    ///</remarks>
    property ShowPercentage: Boolean read get_ShowPercentage write set_ShowPercentage;
    ///<summary>
    ///  Returns or sets a Boolean to indicate the series name display behavior for the data labels of the entire series.
    ///<b>True</b>
    ///  to show the series name. <b>False</b>
    ///  to hide. By default <b>false</b>
    ///  .
    ///</summary>
    ///<remarks>
    ///  Value defined for this property can be overridden for an individual data label with using the
    ///<see cref="P:Aspose.Words.Drawing.Charts.ChartDataLabel.ShowSeriesName" />
    ///  property.
    ///</remarks>
    property ShowSeriesName: Boolean read get_ShowSeriesName write set_ShowSeriesName;
    ///<summary>
    ///  Allows to specify whether values are to be displayed in the data labels of the entire series.
    ///  Default value is <b>false</b>
    ///  .
    ///</summary>
    ///<remarks>
    ///  Value defined for this property can be overridden for an individual data label with using the
    ///<see cref="P:Aspose.Words.Drawing.Charts.ChartDataLabel.ShowValue" />
    ///  property.
    ///</remarks>
    property ShowValue: Boolean read get_ShowValue write set_ShowValue;
    ///<summary>
    ///  Allows to specify whether data label leader lines need be shown for the data labels of the entire series.
    ///  Default value is <b>false</b>
    ///  .
    ///</summary>
    ///<remarks><para>Applies to Pie charts only.
    ///  Leader lines create a visual connection between a data label and its corresponding data point.</para><para>Value defined for this property can be overridden for an individual data label with using the
    ///<see cref="P:Aspose.Words.Drawing.Charts.ChartDataLabel.ShowLeaderLines" />
    ///  property.</para></remarks>
    property ShowLeaderLines: Boolean read get_ShowLeaderLines write set_ShowLeaderLines;
    ///<summary>
    ///  Allows to specify whether values from data labels range to be displayed in the data labels of the entire series.
    ///  Default value is <b>false</b>
    ///  .
    ///</summary>
    ///<remarks>
    ///  Value defined for this property can be overridden for an individual data label with using the
    ///<see cref="P:Aspose.Words.Drawing.Charts.ChartDataLabel.ShowDataLabelsRange" />
    ///  property.
    ///</remarks>
    property ShowDataLabelsRange: Boolean read get_ShowDataLabelsRange write set_ShowDataLabelsRange;
    ///<summary>
    ///  Gets or sets string separator used for the data labels of the entire series.
    ///  The default is a comma, except for pie charts showing only category name and percentage, when a line break
    ///  shall be used instead.
    ///</summary>
    ///<remarks>
    ///  Value defined for this property can be overridden for an individual data label with using the
    ///<see cref="P:Aspose.Words.Drawing.Charts.ChartDataLabel.Separator" />
    ///  property.
    ///</remarks>
    property Separator: string read get_Separator write set_Separator;
    ///<summary>
    ///  Gets an <see cref="T:Aspose.Words.Drawing.Charts.ChartNumberFormat" />
    ///  instance allowing to set number format for the data labels of the
    ///  entire series.
    ///</summary>
    property NumberFormat: DNChartNumberFormat read get_NumberFormat;
  end;

  TDNChartDataLabelCollection = class(TDNGenericImport<DNChartDataLabelCollectionClass, DNChartDataLabelCollection>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartDataPointClass = interface(DNObjectClass)
  ['{D708AAA2-3CF7-5689-AD47-1529E243DA04}']
  end;

  ///<summary>
  ///  Allows to specify formatting of a single data point on the chart.
  ///</summary>
  ///<remarks>
  ///  On a series, the <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPoint" />
  ///  object is a member of the <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPointCollection" />
  ///  .
  ///  The <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPointCollection" />
  ///  contains a <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPoint" />
  ///  object for each point.
  ///</remarks>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartDataPoint')]
  DNChartDataPoint = interface(DNIChartDataPoint)
  ['{B41598BA-48AE-37BD-8C97-CEB472287DF9}']
  { getters & setters } 

    function get_Index: Int32;
    function get_Explosion: Int32;
    procedure set_Explosion(value: Int32);
    function get_InvertIfNegative: Boolean;
    procedure set_InvertIfNegative(value: Boolean);
    function get_Bubble3D: Boolean;
    procedure set_Bubble3D(value: Boolean);
    function get_Format: DNChartFormat;
    function get_Marker: DNChartMarker;

  { methods } 

    ///<summary>
    ///  Clears format of this data point. The properties are set to the default values defined in the parent series.
    ///</summary>
    procedure ClearFormat;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Index of the data point this object applies formatting to.
    ///</summary>
    property Index: Int32 read get_Index;
    property Explosion: Int32 read get_Explosion write set_Explosion;
    property InvertIfNegative: Boolean read get_InvertIfNegative write set_InvertIfNegative;
    property Bubble3D: Boolean read get_Bubble3D write set_Bubble3D;
    property Format: DNChartFormat read get_Format;
    property Marker: DNChartMarker read get_Marker;
  end;

  TDNChartDataPoint = class(TDNGenericImport<DNChartDataPointClass, DNChartDataPoint>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartDataPointCollectionClass = interface(DNObjectClass)
  ['{D8F1D34D-2B2C-5575-BE47-C2CECAEEEA07}']
  end;

  ///<summary>
  ///  Represents collection of a <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPoint" />
  ///  .
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartDataPointCollection')]
  DNChartDataPointCollection = interface(DDN.mscorlib.DNIEnumerable)
  ['{A5B362F9-A55E-38FD-8E09-4CE80F454D31}']
  { getters & setters } 

    function get_Item(index: Int32): DNChartDataPoint;
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Returns an enumerator object.
    ///</summary>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNChartDataPoint>;
    ///<summary>
    ///  Adds new <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPoint" />
    ///  at the specified index.
    ///</summary>
    ///  <param name="index">Target data point index.</param>
    function Add(index: Int32): DNChartDataPoint;
    ///<summary>
    ///  Clears format of a <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPoint" />
    ///  at the specified index.
    ///</summary>
    ///  <param name="index">The zero-based index of the data point to clear format.</param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Clears format of all <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPoint" />
    ///  in this collection.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Clears format of all <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPoint" />
    ///  in this collection.
    ///</summary>
    procedure ClearFormat;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNChartDataPoint read get_Item; default;
    ///<summary>
    ///  Returns the number of <see cref="T:Aspose.Words.Drawing.Charts.ChartDataPoint" />
    ///  in this collection.
    ///</summary>
    property Count: Int32 read get_Count;
  end;

  TDNChartDataPointCollection = class(TDNGenericImport<DNChartDataPointCollectionClass, DNChartDataPointCollection>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartFormatClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F946CF13-E990-50A1-BE4C-4EBEC33CE28A}']
  end;

  [DNTypeName('Aspose.Words.Drawing.Charts.ChartFormat')]
  DNChartFormat = interface(DDN.mscorlib.DNObject)
  ['{C2CADA09-3BE0-388F-BE1A-6E867F29145D}']
  { getters & setters } 

    function get_Fill: DNFill;
    function get_Stroke: DNStroke;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Fill: DNFill read get_Fill;
    property Stroke: DNStroke read get_Stroke;
  end;

  TDNChartFormat = class(TDNGenericImport<DNChartFormatClass, DNChartFormat>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartLegendClass = interface(DDN.mscorlib.DNObjectClass)
  ['{9FEE91D1-E1A9-57DA-9099-5FC00270C417}']
  { constructors } 

    {class} function init: DNChartLegend;

  end;

  ///<summary>
  ///  Represents chart legend properties.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartLegend')]
  DNChartLegend = interface(DDN.mscorlib.DNObject)
  ['{5B9B754D-1787-3187-8B1B-6B3936CF7FBB}']
  { getters & setters } 

    function get_Position: DNLegendPosition;
    procedure set_Position(value: DNLegendPosition);
    function get_Overlay: Boolean;
    procedure set_Overlay(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Specifies the position of the legend on a chart.
    ///  Default value is <see cref="F:Aspose.Words.Drawing.Charts.LegendPosition.Right" />
    ///  .
    ///</summary>
    property Position: DNLegendPosition read get_Position write set_Position;
    ///<summary>
    ///  Determines whether other chart elements shall be allowed to overlap legend.
    ///  Default value is false.
    ///</summary>
    property Overlay: Boolean read get_Overlay write set_Overlay;
  end;

  TDNChartLegend = class(TDNGenericImport<DNChartLegendClass, DNChartLegend>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartMarkerClass = interface(DDN.mscorlib.DNObjectClass)
  ['{3B39C649-7F51-545F-9C0C-590872392090}']
  end;

  ///<summary>
  ///  Represents a chart data marker.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartMarker')]
  DNChartMarker = interface(DDN.mscorlib.DNObject)
  ['{22124290-4D1C-3570-AE27-35DF360D9DFF}']
  { getters & setters } 

    function get_Symbol: DNMarkerSymbol;
    procedure set_Symbol(value: DNMarkerSymbol);
    function get_Size: Int32;
    procedure set_Size(value: Int32);
    function get_Format: DNChartFormat;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets chart marker symbol.
    ///</summary>
    property Symbol: DNMarkerSymbol read get_Symbol write set_Symbol;
    ///<summary>
    ///  Gets or sets chart marker size.
    ///  Default value is 7.
    ///</summary>
    property Size: Int32 read get_Size write set_Size;
    property Format: DNChartFormat read get_Format;
  end;

  TDNChartMarker = class(TDNGenericImport<DNChartMarkerClass, DNChartMarker>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartNumberFormatClass = interface(DDN.mscorlib.DNObjectClass)
  ['{C4985BA5-F289-5A55-9610-95233025FAD1}']
  end;

  ///<summary>
  ///  Represents number formatting of the parent element.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartNumberFormat')]
  DNChartNumberFormat = interface(DDN.mscorlib.DNObject)
  ['{DEF7B41B-D44A-3595-9C0D-4C132742F28D}']
  { getters & setters } 

    function get_FormatCode: string;
    procedure set_FormatCode(value: string);
    function get_IsLinkedToSource: Boolean;
    procedure set_IsLinkedToSource(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the format code applied to a data label.
    ///</summary>
    ///<remarks>
    ///  Number formatting is used to change the way a value appears in data label and can be used in some very creative ways.
    ///  The examples of number formats:
    ///  <para>Number - "#,##0.00"</para><para>Currency - "\"$\"#,##0.00"</para><para>Time - "[$-x-systime]h:mm:ss AM/PM"</para><para>Date - "d/mm/yyyy"</para><para>Percentage - "0.00%"</para><para>Fraction - "# ?/?"</para><para>Scientific - "0.00E+00"</para><para>Text - "@"</para><para>Accounting - "_-\"$\"* #,##0.00_-;-\"$\"* #,##0.00_-;_-\"$\"* \"-\"??_-;_-@_-"</para><para>Custom with color - "[Red]-#,##0.0"</para></remarks>
    property FormatCode: string read get_FormatCode write set_FormatCode;
    ///<summary>
    ///  Specifies whether the format code is linked to a source cell.
    ///  Default is true.
    ///</summary>
    ///<remarks>The NumberFormat will be reset to general if format code is linked to source.</remarks>
    property IsLinkedToSource: Boolean read get_IsLinkedToSource write set_IsLinkedToSource;
  end;

  TDNChartNumberFormat = class(TDNGenericImport<DNChartNumberFormatClass, DNChartNumberFormat>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartSeriesClass = interface(DDN.mscorlib.DNObjectClass)
  ['{8AFF7391-8CF5-5192-A451-B0CEBFB67215}']
  end;

  ///<summary>
  ///  Represents chart series properties.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartSeries')]
  DNChartSeries = interface(DDN.mscorlib.DNObject)
  ['{4F65AF6A-F592-3E27-B314-586F5267AD74}']
  { getters & setters } 

    function get_Explosion: Int32;
    procedure set_Explosion(value: Int32);
    function get_InvertIfNegative: Boolean;
    procedure set_InvertIfNegative(value: Boolean);
    function get_Marker: DNChartMarker;
    function get_Bubble3D: Boolean;
    procedure set_Bubble3D(value: Boolean);
    function get_DataPoints: DNChartDataPointCollection;
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Smooth: Boolean;
    procedure set_Smooth(value: Boolean);
    function get_HasDataLabels: Boolean;
    procedure set_HasDataLabels(value: Boolean);
    function get_DataLabels: DNChartDataLabelCollection;
    function get_Format: DNChartFormat;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Explosion: Int32 read get_Explosion write set_Explosion;
    property InvertIfNegative: Boolean read get_InvertIfNegative write set_InvertIfNegative;
    property Marker: DNChartMarker read get_Marker;
    property Bubble3D: Boolean read get_Bubble3D write set_Bubble3D;
    ///<summary>
    ///  Returns a collection of formatting objects for all data points in this series.
    ///</summary>
    property DataPoints: DNChartDataPointCollection read get_DataPoints;
    ///<summary>
    ///  Gets or sets the name of the series, if name is not set explicitly it is generated using index.
    ///  By default returns Series plus one based index.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Allows to specify whether the line connecting the points on the chart shall be smoothed using Catmull-Rom splines.
    ///</summary>
    property Smooth: Boolean read get_Smooth write set_Smooth;
    ///<summary>
    ///  Gets or sets a flag indicating whether data labels are displayed for the series.
    ///</summary>
    property HasDataLabels: Boolean read get_HasDataLabels write set_HasDataLabels;
    ///<summary>
    ///  Specifies the settings for the data labels for the entire series.
    ///</summary>
    property DataLabels: DNChartDataLabelCollection read get_DataLabels;
    property Format: DNChartFormat read get_Format;
  end;

  TDNChartSeries = class(TDNGenericImport<DNChartSeriesClass, DNChartSeries>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartSeriesCollectionClass = interface(DNObjectClass)
  ['{E031968D-43E8-5DEF-B50A-F859F0ED8567}']
  end;

  ///<summary>
  ///  Represents collection of a <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
  ///  .
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartSeriesCollection')]
  DNChartSeriesCollection = interface(DDN.mscorlib.DNIEnumerable)
  ['{279E477B-5722-3475-9EBE-DDBD67BEE1BC}']
  { getters & setters } 

    function get_Item(index: Int32): DNChartSeries;
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Returns an enumerator object.
    ///</summary>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNChartSeries>;
    ///<summary>
    ///  Removes a <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  at the specified index.
    ///</summary>
    ///  <param name="index">The zero-based index of the ChartSeries to remove.</param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Removes all <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  from this collection.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Adds new <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  to this collection.
    ///  Use this method to add series to any type of Bar, Column, Line and Surface charts.
    ///</summary>
    ///<returns>Recently added <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  object.</returns>
    function Add(seriesName: string; categories: TArray<string>; values: TArray<Double>): DNChartSeries; overload;
    ///<summary>
    ///  Adds new <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  to this collection.
    ///  Use this method to add series to any type of Scatter charts.
    ///</summary>
    ///<returns>Recently added <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  object.</returns>
    function Add(seriesName: string; xValues: TArray<Double>; yValues: TArray<Double>): DNChartSeries; overload;
    ///<summary>
    ///  Adds new <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  to this collection.
    ///  Use this method to add series to any type of Area, Radar and Stock charts.
    ///</summary>
    function Add(seriesName: string; dates: TArray<DDN.mscorlib.DNDateTime>; values: TArray<Double>): DNChartSeries; overload;
    ///<summary>
    ///  Adds new <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  to this collection.
    ///  Use this method to add series to any type of Bubble charts.
    ///</summary>
    ///<returns>Recently added <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  object.</returns>
    function Add(seriesName: string; xValues: TArray<Double>; yValues: TArray<Double>; bubbleSizes: TArray<Double>): DNChartSeries; overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNChartSeries read get_Item; default;
    ///<summary>
    ///  Returns the number of <see cref="T:Aspose.Words.Drawing.Charts.ChartSeries" />
    ///  in this collection.
    ///</summary>
    property Count: Int32 read get_Count;
  end;

  TDNChartSeriesCollection = class(TDNGenericImport<DNChartSeriesCollectionClass, DNChartSeriesCollection>) end;

  //-------------namespace: Aspose.Words.Drawing.Charts----------------
  DNChartTitleClass = interface(DDN.mscorlib.DNObjectClass)
  ['{E62E697F-00C5-5E35-8DE9-F2810E02CC3E}']
  end;

  ///<summary>
  ///  Provides access to the chart title properties.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Charts.ChartTitle')]
  DNChartTitle = interface(DDN.mscorlib.DNObject)
  ['{23D14192-1CEB-341B-A30D-C9F6CA8D3E78}']
  { getters & setters } 

    function get_Text: string;
    procedure set_Text(value: string);
    function get_Overlay: Boolean;
    procedure set_Overlay(value: Boolean);
    function get_Show: Boolean;
    procedure set_Show(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the text of the chart title.
    ///  If null or empty value is specified, auto generated title will be shown.
    ///</summary>
    ///<remarks>Use <see cref="P:Aspose.Words.Drawing.Charts.ChartTitle.Show" />
    ///  option if you need to hide the Title.</remarks>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Determines whether other chart elements shall be allowed to overlap title.
    ///  By default overlay is false.
    ///</summary>
    property Overlay: Boolean read get_Overlay write set_Overlay;
    ///<summary>
    ///  Determines whether the title shall be shown for this chart.
    ///  Default value is true.
    ///</summary>
    property Show: Boolean read get_Show write set_Show;
  end;

  TDNChartTitle = class(TDNGenericImport<DNChartTitleClass, DNChartTitle>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNFillClass = interface(DDN.mscorlib.DNObjectClass)
  ['{8AFAB7F8-5408-5D14-A7B9-65B1EA89B7D5}']
  end;

  ///<summary>
  ///  Represents fill formatting for an object.
  ///</summary>
  ///<remarks><p>Use the <see cref="P:Aspose.Words.Drawing.ShapeBase.Fill" />
  ///  or <see cref="P:Aspose.Words.Font.Fill" />
  ///  property
  ///  to access fill properties of an object.
  ///  You do not create instances of the <see cref="T:Aspose.Words.Drawing.Fill" />
  ///  class directly.</p>
  ///  <p>Although the <see cref="T:Aspose.Words.Drawing.Fill" />
  ///  class provides properties to specify solid color fill only,
  ///  all of the more complex fill types, including as gradient, pattern and texture are fully preserved
  ///  during document open-save cycles.</p>
  ///</remarks>
  ///<dev>
  ///  This class is proposed public facade for <see cref="T:Aspose.Words.Drawing.Core.IFillable" />
  ///  .
  ///  https://docs.microsoft.com/en-us/office/vba/api/word.fillformat
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.Fill')]
  DNFill = interface(DDN.mscorlib.DNObject)
  ['{E95D70CF-0288-3E76-B0EF-F0ECECB7B704}']
  { getters & setters } 

    function get_PresetTexture: DNPresetTexture;
    function get_Color: DDN.System.Drawing.DNColor;
    procedure set_Color(value: DDN.System.Drawing.DNColor);
    function get_On: Boolean;
    procedure set_On(value: Boolean);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_ImageBytes: TArray<Byte>;
    function get_ForeColor: DDN.System.Drawing.DNColor;
    procedure set_ForeColor(value: DDN.System.Drawing.DNColor);
    function get_BackColor: DDN.System.Drawing.DNColor;
    procedure set_BackColor(value: DDN.System.Drawing.DNColor);
    function get_Visible: Boolean;
    procedure set_Visible(value: Boolean);
    function get_Transparency: Double;
    procedure set_Transparency(value: Double);
    function get_RotateWithObject: Boolean;
    procedure set_RotateWithObject(value: Boolean);
    function get_FillType: DNFillType;

  { methods } 

    ///<summary>
    ///  Sets the fill to a uniform color.
    ///</summary>
    ///<remarks>
    ///  Use this method to convert any of the fills back to solid fill.
    ///</remarks>
    procedure Solid; overload;
    ///<summary>
    ///  Sets the fill to a specified uniform color.
    ///</summary>
    ///<remarks>
    ///  Use this method to convert any of the fills back to solid fill.
    ///</remarks>
    procedure Solid(color: DDN.System.Drawing.DNColor); overload;
    procedure PresetTextured(presetTexture: DNPresetTexture);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property PresetTexture: DNPresetTexture read get_PresetTexture;
    ///<summary>
    ///  Gets or sets a Color object that represents the foreground color for the fill.
    ///</summary>
    ///<dev> Word VBA gets and sets RGB color. </dev>
    property Color: DDN.System.Drawing.DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets value that is <c>true</c> if the formatting applied to this instance, is visible.
    ///</summary>
    property &On: Boolean read get_On write set_On;
    ///<summary>
    ///  Gets or sets the degree of opacity of the specified fill as a value between 0.0 (clear) and 1.0 (opaque).
    ///</summary>
    ///<remarks>This property is the opposite of property <see cref="P:Aspose.Words.Drawing.Fill.Transparency" />
    ///  .</remarks>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  Gets the raw bytes of the fill texture or pattern.
    ///</summary>
    ///<remarks><p>The default value is null.</p>
    ///</remarks>
    property ImageBytes: TArray<Byte> read get_ImageBytes;
    ///<summary>
    ///  Gets or sets a Color object that represents the foreground color for the fill.
    ///</summary>
    ///<dev> Word VBA gets and sets RGB color. </dev>
    property ForeColor: DDN.System.Drawing.DNColor read get_ForeColor write set_ForeColor;
    ///<summary>
    ///  Gets or sets a Color object that represents the background color for the fill.
    ///</summary>
    ///<dev> Word VBA gets and sets RGB color. </dev>
    property BackColor: DDN.System.Drawing.DNColor read get_BackColor write set_BackColor;
    ///<summary>
    ///  Gets or sets value that is <c>true</c> if the formatting applied to this instance, is visible.
    ///</summary>
    property Visible: Boolean read get_Visible write set_Visible;
    ///<summary>
    ///  Gets or sets the degree of transparency of the specified fill as a value between 0.0 (opaque) and 1.0 (clear).
    ///</summary>
    ///<remarks>This property is the opposite of property <see cref="P:Aspose.Words.Drawing.Fill.Opacity" />
    ///  .</remarks>
    ///<dev>See https://docs.microsoft.com/en-us/office/vba/api/word.fillformat for details.</dev>
    property Transparency: Double read get_Transparency write set_Transparency;
    ///<summary>
    ///  Gets or sets whether the fill rotates with the specified object.
    ///</summary>
    ///<dev>
    ///  This property is applicable to shape objects only.
    ///  When accessing this property in VBA for text an exception is thrown.
    ///</dev>
    property RotateWithObject: Boolean read get_RotateWithObject write set_RotateWithObject;
    ///<summary>
    ///  Gets a fill type.
    ///</summary>
    property FillType: DNFillType read get_FillType;
  end;

  TDNFill = class(TDNGenericImport<DNFillClass, DNFill>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNHorizontalRuleFormatClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B6958BA7-4CE5-5A26-83A0-1CF08345BB20}']
  end;

  ///<summary>
  ///  Represents horizontal rule formatting.
  ///</summary>
  ///<dev>
  ///  FIX 18182. This class has been added to provide public horizontal rule properties.
  ///</dev>
  [DNTypeName('Aspose.Words.Drawing.HorizontalRuleFormat')]
  DNHorizontalRuleFormat = interface(DDN.mscorlib.DNObject)
  ['{78571D1B-420B-33C8-8974-E742A3DE94FF}']
  { getters & setters } 

    function get_WidthPercent: Double;
    procedure set_WidthPercent(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_NoShade: Boolean;
    procedure set_NoShade(value: Boolean);
    function get_Color: DDN.System.Drawing.DNColor;
    procedure set_Color(value: DDN.System.Drawing.DNColor);
    function get_Alignment: DNHorizontalRuleAlignment;
    procedure set_Alignment(value: DNHorizontalRuleAlignment);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the length of the specified horizontal rule expressed as a percentage of the window width.
    ///</summary>
    ///<remarks><p>Valid values ​​range from 1 to 100 inclusive.</p>
    ///  <p>The default value is 100.</p>
    ///</remarks>
    ///<exception cref="T:System.ArgumentOutOfRangeException">
    ///  Throws when argument was out of the range of valid values.
    ///</exception>
    property WidthPercent: Double read get_WidthPercent write set_WidthPercent;
    ///<summary>
    ///  Gets or sets the height of the horizontal rule.
    ///</summary>
    ///<remarks><p>This is a shortcut to the <see cref="P:Aspose.Words.Drawing.ShapeBase.Height" />
    ///  property.</p>
    ///  <p>Valid values ​​range from 0 to 1584 inclusive.</p>
    ///  <p>The default value is 1.5.</p>
    ///</remarks>
    ///<exception cref="T:System.ArgumentOutOfRangeException">
    ///  Throws when argument was out of the range of valid values.
    ///</exception>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Indicates the presence of 3D shading for the horizontal rule.
    ///  If true, then the horizontal rule is without 3D shading and solid color is used.
    ///</summary>
    ///<remarks><p>The default value is false.</p>
    ///</remarks>
    property NoShade: Boolean read get_NoShade write set_NoShade;
    ///<summary>
    ///  Gets or sets the brush color that fills the horizontal rule.
    ///</summary>
    ///<remarks><p>This is a shortcut to the <see cref="P:Aspose.Words.Drawing.Fill.Color" />
    ///  property.</p>
    ///  <p>The default value is
    ///<see cref="P:System.Drawing.Color.Gray" />
    ///  .</p>
    ///</remarks>
    property Color: DDN.System.Drawing.DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets the alignment of the horizontal rule.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.HorizontalRuleAlignment.Left" />
    ///  .</p>
    ///</remarks>
    property Alignment: DNHorizontalRuleAlignment read get_Alignment write set_Alignment;
  end;

  TDNHorizontalRuleFormat = class(TDNGenericImport<DNHorizontalRuleFormatClass, DNHorizontalRuleFormat>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNImageDataClass = interface(DDN.mscorlib.DNObjectClass)
  ['{4F80C508-BE35-562F-9847-C3FD3F5C024F}']
  end;

  ///<summary>
  ///  Defines an image for a shape.
  ///</summary>
  ///<remarks><p>Use the <see cref="P:Aspose.Words.Drawing.Shape.ImageData" />
  ///  property to access and modify the image inside a shape.
  ///  You do not create instances of the <see cref="T:Aspose.Words.Drawing.ImageData" />
  ///  class directly.</p>
  ///  <p>An image can be stored inside a shape, linked to external file or both (linked and stored in the document).</p>
  ///  <p>Regardless of whether the image is stored inside the shape or linked, you can always access the actual
  ///  image using the <see cref="M:Aspose.Words.Drawing.ImageData.ToByteArray" />
  ///  , <see cref="M:Aspose.Words.Drawing.ImageData.ToStream" />
  ///  , <see cref="M:Aspose.Words.Drawing.ImageData.ToImage" />
  ///  or <see cref="M:Aspose.Words.Drawing.ImageData.Save(System.String)" />
  ///  methods.
  ///  If the image is stored inside the shape, you can also directly access it using the <see cref="P:Aspose.Words.Drawing.ImageData.ImageBytes" />
  ///  property.</p>
  ///  <p>To store an image inside a shape use the <see cref="M:Aspose.Words.Drawing.ImageData.SetImage(System.String)" />
  ///  method. To link an image to a shape, set the <see cref="P:Aspose.Words.Drawing.ImageData.SourceFullName" />
  ///  property.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.Drawing.ImageData')]
  DNImageData = interface(DDN.mscorlib.DNObject)
  ['{E02B2693-C39C-3D68-8272-04007241AC86}']
  { getters & setters } 

    function get_ImageBytes: TArray<Byte>;
    procedure set_ImageBytes(value: TArray<Byte>);
    function get_HasImage: Boolean;
    function get_ImageSize: DNImageSize;
    function get_ImageType: DNImageType;
    function get_IsLink: Boolean;
    function get_IsLinkOnly: Boolean;
    function get_SourceFullName: string;
    procedure set_SourceFullName(value: string);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_CropTop: Double;
    procedure set_CropTop(value: Double);
    function get_CropBottom: Double;
    procedure set_CropBottom(value: Double);
    function get_CropLeft: Double;
    procedure set_CropLeft(value: Double);
    function get_CropRight: Double;
    procedure set_CropRight(value: Double);
    function get_Borders: DNBorderCollection;
    function get_ChromaKey: DDN.System.Drawing.DNColor;
    procedure set_ChromaKey(value: DDN.System.Drawing.DNColor);
    function get_Brightness: Double;
    procedure set_Brightness(value: Double);
    function get_Contrast: Double;
    procedure set_Contrast(value: Double);
    function get_BiLevel: Boolean;
    procedure set_BiLevel(value: Boolean);
    function get_GrayScale: Boolean;
    procedure set_GrayScale(value: Boolean);

  { methods } 

    ///<summary>
    ///  Sets the image that the shape displays.
    ///</summary>
    ///  <param name="image">The image object.</param>
    procedure SetImage(image: DDN.System.Drawing.DNImage); overload;
    ///<summary>
    ///  Sets the image that the shape displays.
    ///</summary>
    ///  <param name="stream">The stream that contains the image.
    ///</param>
    procedure SetImage(stream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Sets the image that the shape displays.
    ///</summary>
    ///  <param name="fileName">The image file. Can be a file name or a URL.</param>
    procedure SetImage(fileName: string); overload;
    ///<summary>
    ///  Gets the image stored in the shape as a <see cref="T:System.Drawing.Image" />
    ///  object.
    ///</summary>
    ///<returns></returns>
    ///<remarks><p>A new <see cref="T:System.Drawing.Image" />
    ///  object is created every time this method is called.</p>
    ///  <p>It is the responsibility of the caller to dispose the image object.</p>
    ///</remarks>
    function ToImage: DDN.System.Drawing.DNImage;
    ///<summary>
    ///  Creates and returns a stream that contains the image bytes.
    ///</summary>
    ///<remarks><p>If the image bytes are stored in the shape, creates and returns a <see cref="T:System.IO.MemoryStream" />
    ///  object.</p>
    ///  <p>If the image is linked and stored in a file, opens the file and returns a <see cref="T:System.IO.FileStream" />
    ///  object.</p>
    ///  <p>If the image is linked and stored in an external URL, downloads the file and returns a <see cref="T:System.IO.MemoryStream" />
    ///  object.</p>
    ///  <p>Is it the responsibility of the caller to dispose the stream object.</p>
    ///</remarks>
    function ToStream: DDN.mscorlib.DNStream;
    ///<summary>
    ///  Returns image bytes for any image regardless whether the image is stored or linked.
    ///</summary>
    ///<returns></returns>
    ///<remarks><para>If the image is linked, downloads the image every time it is called.</para><seealso cref="P:Aspose.Words.Drawing.ImageData.ImageBytes" />
    ///</remarks>
    function ToByteArray: TArray<Byte>;
    ///<summary>
    ///  Saves the image into the specified stream.
    ///</summary>
    ///  <param name="stream">The stream where to save the image to.</param>
    ///<overloads>Saves the image of the shape.</overloads><remarks><p>Is it the responsibility of the caller to dispose the stream object.</p>
    ///</remarks>
    procedure Save(stream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Saves the image into a file.
    ///</summary>
    ///  <param name="fileName">The file name where to save the image.</param>
    procedure Save(fileName: string); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the raw bytes of the image stored in the shape.
    ///</summary>
    ///<remarks><para>Setting the value to <c>null</c> or an empty array will remove the image from the shape.</para><p>Returns <c>null</c> if the image is not stored in the document (e.g the image is probably linked in this case).</p>
    ///<seealso cref="M:Aspose.Words.Drawing.ImageData.SetImage(System.String)" />
    ///<seealso cref="M:Aspose.Words.Drawing.ImageData.ToByteArray" />
    ///<seealso cref="M:Aspose.Words.Drawing.ImageData.ToImage" />
    ///<seealso cref="M:Aspose.Words.Drawing.ImageData.ToStream" />
    ///<seealso cref="M:Aspose.Words.Drawing.ImageData.Save(System.String)" />
    ///</remarks>
    property ImageBytes: TArray<Byte> read get_ImageBytes write set_ImageBytes;
    ///<summary>
    ///  Returns true if the shape has image bytes or links an image.
    ///</summary>
    ///<value></value>
    property HasImage: Boolean read get_HasImage;
    ///<summary>
    ///  Gets the information about image size and resolution.
    ///</summary>
    ///<value></value><remarks><p>If the image is linked only and not stored in the document, returns zero size.</p>
    ///</remarks>
    property ImageSize: DNImageSize read get_ImageSize;
    ///<summary>
    ///  Gets the type of the image.
    ///</summary>
    ///<value></value>
    property ImageType: DNImageType read get_ImageType;
    ///<summary>
    ///  Returns true if the image is linked to the shape (when <see cref="P:Aspose.Words.Drawing.ImageData.SourceFullName" />
    ///  is specified).
    ///</summary>
    ///<value></value>
    property IsLink: Boolean read get_IsLink;
    ///<summary>
    ///  Returns true if the image is linked and not stored in the document.
    ///</summary>
    ///<value></value>
    property IsLinkOnly: Boolean read get_IsLinkOnly;
    ///<summary>
    ///  Gets or sets the path and name of the source file for the linked image.
    ///</summary>
    ///  <p>The default value is an empty string.</p>
    ///  <p>If <see cref="P:Aspose.Words.Drawing.ImageData.SourceFullName" />
    ///  is not an empty string, the image is linked.</p>
    property SourceFullName: string read get_SourceFullName write set_SourceFullName;
    ///<summary>
    ///  Defines the title of an image.
    ///</summary>
    ///<remarks><p>The default value is an empty string.</p>
    ///</remarks>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Defines the fraction of picture removal from the top side.
    ///</summary>
    ///<remarks><p>The amount of cropping can range from -1.0 to 1.0. The default value is 0. Note
    ///  that a value of 1 will display no picture at all. Negative values will result in
    ///  the picture being squeezed inward from the edge being cropped (the empty space
    ///  between the picture and the cropped edge will be filled by the fill color of the
    ///  shape). Positive values less than 1 will result in the remaining picture being
    ///  stretched to fit the shape.</p>
    ///  <p>The default value is 0.</p>
    ///</remarks>
    property CropTop: Double read get_CropTop write set_CropTop;
    ///<summary>
    ///  Defines the fraction of picture removal from the bottom side.
    ///</summary>
    ///<remarks><p>The amount of cropping can range from -1.0 to 1.0. The default value is 0. Note
    ///  that a value of 1 will display no picture at all. Negative values will result in
    ///  the picture being squeezed inward from the edge being cropped (the empty space
    ///  between the picture and the cropped edge will be filled by the fill color of the
    ///  shape). Positive values less than 1 will result in the remaining picture being
    ///  stretched to fit the shape.</p>
    ///  <p>The default value is 0.</p>
    ///</remarks>
    property CropBottom: Double read get_CropBottom write set_CropBottom;
    ///<summary>
    ///  Defines the fraction of picture removal from the left side.
    ///</summary>
    ///<remarks><p>The amount of cropping can range from -1.0 to 1.0. The default value is 0. Note
    ///  that a value of 1 will display no picture at all. Negative values will result in
    ///  the picture being squeezed inward from the edge being cropped (the empty space
    ///  between the picture and the cropped edge will be filled by the fill color of the
    ///  shape). Positive values less than 1 will result in the remaining picture being
    ///  stretched to fit the shape.</p>
    ///  <p>The default value is 0.</p>
    ///</remarks>
    property CropLeft: Double read get_CropLeft write set_CropLeft;
    ///<summary>
    ///  Defines the fraction of picture removal from the right side.
    ///</summary>
    ///<remarks><p>The amount of cropping can range from -1.0 to 1.0. The default value is 0. Note
    ///  that a value of 1 will display no picture at all. Negative values will result in
    ///  the picture being squeezed inward from the edge being cropped (the empty space
    ///  between the picture and the cropped edge will be filled by the fill color of the
    ///  shape). Positive values less than 1 will result in the remaining picture being
    ///  stretched to fit the shape.</p>
    ///  <p>The default value is 0.</p>
    ///</remarks>
    property CropRight: Double read get_CropRight write set_CropRight;
    ///<summary>
    ///  Gets the collection of borders of the image. Borders only have effect for inline images.
    ///</summary>
    property Borders: DNBorderCollection read get_Borders;
    ///<summary>
    ///  Defines the color value of the image that will be treated as transparent.
    ///</summary>
    ///<remarks><p>The default value is 0.</p>
    ///</remarks>
    property ChromaKey: DDN.System.Drawing.DNColor read get_ChromaKey write set_ChromaKey;
    ///<summary>
    ///  Gets or sets the brightness of the picture.
    ///  The value for this property must be a number from 0.0 (dimmest) to 1.0 (brightest).
    ///</summary>
    ///<remarks><p>The default value is 0.5.</p>
    ///</remarks>
    property Brightness: Double read get_Brightness write set_Brightness;
    ///<summary>
    ///  Gets or sets the contrast for the specified picture. The value
    ///  for this property must be a number from 0.0 (the least contrast) to 1.0 (the greatest contrast).
    ///</summary>
    ///<remarks><p>The default value is 0.5.</p>
    ///</remarks>
    property Contrast: Double read get_Contrast write set_Contrast;
    ///<summary>
    ///  Determines whether an image will be displayed in black and white.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property BiLevel: Boolean read get_BiLevel write set_BiLevel;
    ///<summary>
    ///  Determines whether a picture will display in grayscale mode.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property GrayScale: Boolean read get_GrayScale write set_GrayScale;
  end;

  TDNImageData = class(TDNGenericImport<DNImageDataClass, DNImageData>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNImageSizeClass = interface(DDN.mscorlib.DNObjectClass)
  ['{1475A378-FDA9-5C6A-B2D9-2E8EA1B578C6}']
  { constructors } 

    ///<summary>
    ///  Initializes width and height to the given values in pixels. Initializes resolution to 96 dpi.
    ///</summary>
    ///  <param name="widthPixels">Width in pixels.</param>
    ///  <param name="heightPixels">Height in pixels.</param>
    {class} function init(widthPixels: Int32; heightPixels: Int32): DNImageSize; overload;
    ///<summary>
    ///  Initializes width, height and resolution to the given values.
    ///</summary>
    ///  <param name="widthPixels">Width in pixels.</param>
    ///  <param name="heightPixels">Height in pixels.</param>
    ///  <param name="horizontalResolution">Horizontal resolution in DPI.</param>
    ///  <param name="verticalResolution">Vertical resolution in DPI.</param>
    {class} function init(widthPixels: Int32; heightPixels: Int32; horizontalResolution: Double; verticalResolution: Double): DNImageSize; overload;

  end;

  ///<summary>
  ///  Contains information about image size and resolution.
  ///</summary>
  ///<seealso cref="P:Aspose.Words.Drawing.ImageData.ImageSize" />
  [DNTypeName('Aspose.Words.Drawing.ImageSize')]
  DNImageSize = interface(DDN.mscorlib.DNObject)
  ['{2FBE507C-6A95-33B4-9EF9-AA50F271B03E}']
  { getters & setters } 

    function get_WidthPixels: Int32;
    function get_HeightPixels: Int32;
    function get_HorizontalResolution: Double;
    function get_VerticalResolution: Double;
    function get_WidthPoints: Double;
    function get_HeightPoints: Double;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the width of the image in pixels.
    ///</summary>
    property WidthPixels: Int32 read get_WidthPixels;
    ///<summary>
    ///  Gets the height of the image in pixels.
    ///</summary>
    property HeightPixels: Int32 read get_HeightPixels;
    ///<summary>
    ///  Gets the horizontal resolution in DPI.
    ///</summary>
    property HorizontalResolution: Double read get_HorizontalResolution;
    ///<summary>
    ///  Gets the vertical resolution in DPI.
    ///</summary>
    property VerticalResolution: Double read get_VerticalResolution;
    ///<summary>
    ///  Gets the width of the image in points. 1 point is 1/72 inch.
    ///</summary>
    property WidthPoints: Double read get_WidthPoints;
    ///<summary>
    ///  Gets the height of the image in points. 1 point is 1/72 inch.
    ///</summary>
    property HeightPoints: Double read get_HeightPoints;
  end;

  TDNImageSize = class(TDNGenericImport<DNImageSizeClass, DNImageSize>) end;

  //-------------namespace: Aspose.Words.Drawing.Ole----------------
  DNForms2OleControlCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{31257109-EED0-516A-BF0A-F3B2AE9CD58A}']
  { constructors } 

    {class} function init: DNForms2OleControlCollection;

  end;

  ///<summary>
  ///  Represents collection of <see cref="T:Aspose.Words.Drawing.Ole.Forms2OleControl" />
  ///  objects.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Ole.Forms2OleControlCollection')]
  DNForms2OleControlCollection = interface(DDN.mscorlib.DNObject)
  ['{22519FE1-7AC5-3CBE-997F-A7B6DDE25746}']
  { getters & setters } 

    function get_Item(index: Int32): DNForms2OleControl;
    function get_Count: Int32;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNForms2OleControl read get_Item; default;
    ///<summary>
    ///  Gets count of objects in the collection.
    ///</summary>
    property Count: Int32 read get_Count;
  end;

  TDNForms2OleControlCollection = class(TDNGenericImport<DNForms2OleControlCollectionClass, DNForms2OleControlCollection>) end;

  //-------------namespace: Aspose.Words.Drawing.Ole----------------
  DNOleControlClass = interface(DDN.mscorlib.DNObjectClass)
  ['{61939D73-2CF5-5EFC-9954-99449A677C5D}']
  end;

  ///<summary>
  ///  Represents OLE ActiveX control.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Ole.OleControl')]
  DNOleControl = interface(DDN.mscorlib.DNObject)
  ['{DA80F002-2A15-3015-A576-A07A82864EEE}']
  { getters & setters } 

    function get_IsForms2OleControl: Boolean;
    function get_Name: string;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Returns true if the control is a <see cref="T:Aspose.Words.Drawing.Ole.Forms2OleControl" />
    ///  .
    ///</summary>
    property IsForms2OleControl: Boolean read get_IsForms2OleControl;
    ///<summary>
    ///  Gets name of the ActiveX control.
    ///</summary>
    property Name: string read get_Name;
  end;

  TDNOleControl = class(TDNGenericImport<DNOleControlClass, DNOleControl>) end;

  //-------------namespace: Aspose.Words.Drawing.Ole----------------
  DNForms2OleControlClass = interface(DNOleControlClass)
  ['{FD17A981-5C95-5D20-8D38-78F4A397BF85}']
  end;

  ///<summary>
  ///  Represents Microsoft Forms 2.0 OLE control.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.Ole.Forms2OleControl')]
  DNForms2OleControl = interface(DNOleControl)
  ['{8B67A68A-48E2-3DC9-9155-2410E7268362}']
  { getters & setters } 

    function get_Caption: string;
    function get_Value: string;
    function get_Enabled: Boolean;
    function get_ChildNodes: DNForms2OleControlCollection;
    function get_Type: DNForms2OleControlType;
    function get_IsForms2OleControl: Boolean;
    function get_Name: string;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets Caption property of control. Default value is an empty string.
    ///</summary>
    property Caption: string read get_Caption;
    ///<summary>
    ///  Gets underlying Value property which often represents control state.
    ///  For example checked option button has '1' value while unchecked has '0'.
    ///  Default value is an empty string.
    ///</summary>
    property Value: string read get_Value;
    ///<summary>
    ///  Returns true if control is in enabled state.
    ///</summary>
    property Enabled: Boolean read get_Enabled;
    ///<summary>
    ///  Gets collection of immediate child controls.
    ///</summary>
    ///<remarks>Returns <b>null</b>
    ///  if this control can not have children.</remarks>
    property ChildNodes: DNForms2OleControlCollection read get_ChildNodes;
    ///<summary>
    ///  Gets type of Forms 2.0 control.
    ///</summary>
    property &Type: DNForms2OleControlType read get_Type;
    ///<summary>
    ///  Returns true if the control is a <see cref="T:Aspose.Words.Drawing.Ole.Forms2OleControl" />
    ///  .
    ///</summary>
    property IsForms2OleControl: Boolean read get_IsForms2OleControl;
    ///<summary>
    ///  Gets name of the ActiveX control.
    ///</summary>
    property Name: string read get_Name;
  end;

  TDNForms2OleControl = class(TDNGenericImport<DNForms2OleControlClass, DNForms2OleControl>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNOleFormatClass = interface(DDN.mscorlib.DNObjectClass)
  ['{BD0373E3-352F-559C-A31F-FEFBBEBD07AA}']
  end;

  ///<summary>
  ///  Provides access to the data of an OLE object or ActiveX control.
  ///</summary>
  ///<remarks><p>Use the <see cref="P:Aspose.Words.Drawing.Shape.OleFormat" />
  ///  property to access the data of an OLE object.
  ///  You do not create instances of the <see cref="T:Aspose.Words.Drawing.OleFormat" />
  ///  class directly.</p>
  ///<seealso cref="P:Aspose.Words.Drawing.Shape.OleFormat" />
  ///</remarks>
  [DNTypeName('Aspose.Words.Drawing.OleFormat')]
  DNOleFormat = interface(DDN.mscorlib.DNObject)
  ['{5132EC2C-54C5-31EF-86A0-97880FDE1EF5}']
  { getters & setters } 

    function get_IconCaption: string;
    function get_SuggestedExtension: string;
    function get_SuggestedFileName: string;
    function get_ProgId: string;
    procedure set_ProgId(value: string);
    function get_IsLink: Boolean;
    function get_SourceFullName: string;
    procedure set_SourceFullName(value: string);
    function get_SourceItem: string;
    procedure set_SourceItem(value: string);
    function get_AutoUpdate: Boolean;
    procedure set_AutoUpdate(value: Boolean);
    function get_OleIcon: Boolean;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_Clsid: DDN.mscorlib.DNGuid;
    function get_OlePackage: DNOlePackage;
    function get_OleControl: DNOleControl;

  { methods } 

    ///<summary>
    ///  Saves the data of the embedded object into the specified stream.
    ///</summary>
    ///<remarks><p>It is the responsibility of the caller to dispose the stream.</p>
    ///</remarks>
    ///<exception cref="T:System.InvalidOperationException">Throws if you attempt to save a linked object.</exception><param name="stream">Where to save the object data.</param>
    procedure Save(stream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Saves the data of the embedded object into a file with the specified name.
    ///</summary>
    ///<exception cref="T:System.InvalidOperationException">Throws if you attempt to save a linked object.</exception><param name="fileName">Name of the file to save the OLE object data.</param>
    procedure Save(fileName: string); overload;
    ///<summary>
    ///  Gets OLE object data entry.
    ///</summary>
    ///  <param name="oleEntryName">Case-sensitive name of the OLE data stream.</param>
    ///<returns>An OLE data stream or null.</returns>
    function GetOleEntry(oleEntryName: string): DDN.mscorlib.DNMemoryStream;
    ///<summary>
    ///  Gets OLE object raw data.
    ///</summary>
    function GetRawData: TArray<Byte>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets icon caption of OLE object.
    ///  <para>In case of OLE object is not embedded as icon or caption couldn't be retrieved returns empty string.</para></summary>
    property IconCaption: string read get_IconCaption;
    ///<summary>
    ///  Gets the file extension suggested for the current embedded object if you want to save it into a file.
    ///</summary>
    property SuggestedExtension: string read get_SuggestedExtension;
    ///<summary>
    ///  Gets the file name suggested for the current embedded object if you want to save it into a file.
    ///</summary>
    property SuggestedFileName: string read get_SuggestedFileName;
    ///<summary>
    ///  Gets or sets the ProgID of the OLE object.
    ///</summary>
    ///<remarks><para>The ProgID property is not always present in Microsoft Word documents and cannot be relied upon.</para><para>Cannot be null.</para><p>The default value is an empty string.</p>
    ///</remarks>
    property ProgId: string read get_ProgId write set_ProgId;
    ///<summary>
    ///  Returns true if the OLE object is linked (when <see cref="P:Aspose.Words.Drawing.OleFormat.SourceFullName" />
    ///  is specified).
    ///</summary>
    property IsLink: Boolean read get_IsLink;
    ///<summary>
    ///  Gets or sets the path and name of the source file for the linked OLE object.
    ///</summary>
    ///<remarks><p>The default value is an empty string.</p>
    ///  <p>If <see cref="P:Aspose.Words.Drawing.OleFormat.SourceFullName" />
    ///  is not an empty string, the OLE object is linked.</p>
    ///</remarks>
    property SourceFullName: string read get_SourceFullName write set_SourceFullName;
    ///<summary>
    ///  Gets or sets a string that is used to identify the portion of the source file that is being linked.
    ///</summary>
    ///<remarks><p>The default value is an empty string.</p>
    ///  <p>For example, if the source file is a Microsoft Excel workbook, the <see cref="P:Aspose.Words.Drawing.OleFormat.SourceItem" />
    ///  property might return "Workbook1!R3C1:R4C2" if the OLE object contains only a few cells from
    ///  the worksheet.</p>
    ///</remarks>
    property SourceItem: string read get_SourceItem write set_SourceItem;
    ///<summary>
    ///  Specifies whether the link to the OLE object is automatically updated or not in Microsoft Word.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property AutoUpdate: Boolean read get_AutoUpdate write set_AutoUpdate;
    ///<summary>
    ///  Gets the draw aspect of the OLE object. When <b>true</b>
    ///  , the OLE object is displayed as an icon.
    ///  When <b>false</b>
    ///  , the OLE object is displayed as content.
    ///</summary>
    ///<remarks><para>Aspose.Words does not allow to set this property to avoid confusion. If you were able to change
    ///  the draw aspect in Aspose.Words, Microsoft Word would still display the OLE object in its original
    ///  draw aspect until you edit or update the OLE object in Microsoft Word.</para></remarks>
    property OleIcon: Boolean read get_OleIcon;
    ///<summary>
    ///  Specifies whether the link to the OLE object is locked from updates.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets the CLSID of the OLE object.
    ///</summary>
    property Clsid: DDN.mscorlib.DNGuid read get_Clsid;
    ///<summary>
    ///  Provide access to <see cref="T:Aspose.Words.Drawing.OlePackage" />
    ///  if OLE object is an OLE Package.
    ///  Returns null otherwise.
    ///</summary>
    ///<remarks>
    ///  OLE Package is a legacy technology that allows to wrap any file format not present in the OLE registry of
    ///  a Windows system into a generic package allowing to embed almost anything into a document.
    ///  See <see cref="T:Aspose.Words.Drawing.OlePackage" />
    ///  type for more info.
    ///</remarks>
    ///<dev>
    ///  Has meaning only if ProgId equal to "Package" otherwise is null.
    ///</dev>
    property OlePackage: DNOlePackage read get_OlePackage;
    ///<summary>
    ///  Gets <see cref="P:Aspose.Words.Drawing.OleFormat.OleControl" />
    ///  objects if this OLE object is an ActiveX control. Otherwise this property is null.
    ///</summary>
    property OleControl: DNOleControl read get_OleControl;
  end;

  TDNOleFormat = class(TDNGenericImport<DNOleFormatClass, DNOleFormat>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNOlePackageClass = interface(DDN.mscorlib.DNObjectClass)
  ['{4CC9FFED-CD41-5750-8C5A-5266343D7AE4}']
  end;

  ///<summary>
  ///  Allows to access OLE Package properties.
  ///</summary>
  ///<remarks>
  ///  OLE package is a legacy and "undocumented" way to store embedded object if OLE handler is unknown.
  ///  Early Windows versions such as Windows 3.1, 95 and 98 had Packager.exe application which could be used to embed any type of data into document.
  ///  Now this application is excluded from Windows but MS Word and other applications still use it to embed data if OLE handler is missing or unknown.
  ///</remarks>
  [DNTypeName('Aspose.Words.Drawing.OlePackage')]
  DNOlePackage = interface(DDN.mscorlib.DNObject)
  ['{4A683E76-5237-3C85-A9CA-BF4AFFAD14EF}']
  { getters & setters } 

    function get_FileName: string;
    procedure set_FileName(value: string);
    function get_DisplayName: string;
    procedure set_DisplayName(value: string);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets OLE Package file name.
    ///</summary>
    property FileName: string read get_FileName write set_FileName;
    ///<summary>
    ///  Gets or sets OLE Package display name.
    ///</summary>
    property DisplayName: string read get_DisplayName write set_DisplayName;
  end;

  TDNOlePackage = class(TDNGenericImport<DNOlePackageClass, DNOlePackage>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNSignatureLineClass = interface(DDN.mscorlib.DNObjectClass)
  ['{83E7C892-5566-534A-8821-263220D5D8DB}']
  end;

  ///<summary>
  ///  Provides access to signature line properties.
  ///</summary>
  [DNTypeName('Aspose.Words.Drawing.SignatureLine')]
  DNSignatureLine = interface(DDN.mscorlib.DNObject)
  ['{EA4C5776-91C6-3929-83A7-4BD059C2733E}']
  { getters & setters } 

    function get_Signer: string;
    procedure set_Signer(value: string);
    function get_SignerTitle: string;
    procedure set_SignerTitle(value: string);
    function get_Email: string;
    procedure set_Email(value: string);
    function get_DefaultInstructions: Boolean;
    procedure set_DefaultInstructions(value: Boolean);
    function get_Instructions: string;
    procedure set_Instructions(value: string);
    function get_AllowComments: Boolean;
    procedure set_AllowComments(value: Boolean);
    function get_ShowDate: Boolean;
    procedure set_ShowDate(value: Boolean);
    function get_Id: DDN.mscorlib.DNGuid;
    procedure set_Id(value: DDN.mscorlib.DNGuid);
    function get_ProviderId: DDN.mscorlib.DNGuid;
    procedure set_ProviderId(value: DDN.mscorlib.DNGuid);
    function get_IsSigned: Boolean;
    function get_IsValid: Boolean;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets suggested signer of the signature line.
    ///  Default value for this property is <b>empty string</b>
    ///  (<see cref="F:System.String.Empty" />
    ///  ).
    ///</summary>
    property Signer: string read get_Signer write set_Signer;
    ///<summary>
    ///  Gets or sets suggested signer's title (for example, Manager).
    ///  Default value for this property is <b>empty string</b>
    ///  (<see cref="F:System.String.Empty" />
    ///  ).
    ///</summary>
    property SignerTitle: string read get_SignerTitle write set_SignerTitle;
    ///<summary>
    ///  Gets or sets suggested signer's e-mail address.
    ///  Default value for this property is <b>empty string</b>
    ///  (<see cref="F:System.String.Empty" />
    ///  ).
    ///</summary>
    property Email: string read get_Email write set_Email;
    ///<summary>
    ///  Gets or sets a value indicating that default instructions is shown in the Sign dialog.
    ///  Default value for this property is <b>true</b>
    ///  .
    ///</summary>
    property DefaultInstructions: Boolean read get_DefaultInstructions write set_DefaultInstructions;
    ///<summary>
    ///  Gets or sets instructions to the signer that are displayed on signing the signature line.
    ///  This property is ignored if <see cref="P:Aspose.Words.Drawing.SignatureLine.DefaultInstructions" />
    ///  is set.
    ///  Default value for this property is <b>empty string</b>
    ///  (<see cref="F:System.String.Empty" />
    ///  ).
    ///</summary>
    property Instructions: string read get_Instructions write set_Instructions;
    ///<summary>
    ///  Gets or sets a value indicating that the signer can add comments in the Sign dialog.
    ///  Default value for this property is <b>false</b>
    ///  .
    ///</summary>
    property AllowComments: Boolean read get_AllowComments write set_AllowComments;
    ///<summary>
    ///  Gets or sets a value indicating that sign date is shown in the signature line.
    ///  Default value for this property is <b>true</b>
    ///  .
    ///</summary>
    property ShowDate: Boolean read get_ShowDate write set_ShowDate;
    ///<summary>
    ///  Gets or sets identifier for this signature line.
    ///  <p>This identifier can be associated with a digital signature, when signing document using <see cref="T:Aspose.Words.DigitalSignatures.DigitalSignatureUtil" />
    ///  .
    ///  This value must be unique and by default it is randomly generated new Guid (<see cref="M:System.Guid.NewGuid" />
    ///  ).</p>
    ///</summary>
    property Id: DDN.mscorlib.DNGuid read get_Id write set_Id;
    ///<summary>
    ///  Gets or sets signature provider identifier for this signature line.
    ///  Default value is "{00000000-0000-0000-0000-000000000000}".
    ///</summary>
    ///<remarks><para>The cryptographic service provider (CSP) is an independent software module that actually performs
    ///  cryptography algorithms for authentication, encoding, and encryption. MS Office reserves the value
    ///  of {00000000-0000-0000-0000-000000000000} for its default signature provider.</para><para>The GUID of the additionally installed provider should be obtained from the documentation shipped with the provider.</para><para>In addition, all the installed cryptographic providers are enumerated in windows registry.
    ///  It can be found in the following path: HKLM\SOFTWARE\Microsoft\Cryptography\Defaults\Provider.
    ///  There is a key name "CP Service UUID" which corresponds to a GUID of signature provider.</para></remarks>
    property ProviderId: DDN.mscorlib.DNGuid read get_ProviderId write set_ProviderId;
    ///<summary>
    ///  Indicates that signature line is signed by digital signature.
    ///</summary>
    property IsSigned: Boolean read get_IsSigned;
    ///<summary>
    ///  Indicates that signature line is signed by digital signature and this digital signature is valid.
    ///</summary>
    property IsValid: Boolean read get_IsValid;
  end;

  TDNSignatureLine = class(TDNGenericImport<DNSignatureLineClass, DNSignatureLine>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNStrokeClass = interface(DDN.mscorlib.DNObjectClass)
  ['{EE288245-8CC4-51FA-9386-DBC465620650}']
  end;

  ///<summary>
  ///  Defines a stroke for a shape.
  ///</summary>
  ///<remarks><p>Use the <see cref="P:Aspose.Words.Drawing.Shape.Stroke" />
  ///  property to access stroke properties of a shape.
  ///  You do not create instances of the <see cref="T:Aspose.Words.Drawing.Stroke" />
  ///  class directly.</p>
  ///<seealso cref="P:Aspose.Words.Drawing.Shape.Stroke" />
  ///</remarks>
  [DNTypeName('Aspose.Words.Drawing.Stroke')]
  DNStroke = interface(DDN.mscorlib.DNObject)
  ['{995D0F50-1E5E-37EB-86D9-487D33DB2EE6}']
  { getters & setters } 

    function get_On: Boolean;
    procedure set_On(value: Boolean);
    function get_Color: DDN.System.Drawing.DNColor;
    procedure set_Color(value: DDN.System.Drawing.DNColor);
    function get_Color2: DDN.System.Drawing.DNColor;
    procedure set_Color2(value: DDN.System.Drawing.DNColor);
    function get_ForeColor: DDN.System.Drawing.DNColor;
    procedure set_ForeColor(value: DDN.System.Drawing.DNColor);
    function get_BackColor: DDN.System.Drawing.DNColor;
    procedure set_BackColor(value: DDN.System.Drawing.DNColor);
    function get_Visible: Boolean;
    procedure set_Visible(value: Boolean);
    function get_Transparency: Double;
    procedure set_Transparency(value: Double);
    function get_Weight: Double;
    procedure set_Weight(value: Double);
    function get_DashStyle: DNDashStyle;
    procedure set_DashStyle(value: DNDashStyle);
    function get_JoinStyle: DNJoinStyle;
    procedure set_JoinStyle(value: DNJoinStyle);
    function get_EndCap: DNEndCap;
    procedure set_EndCap(value: DNEndCap);
    function get_LineStyle: DNShapeLineStyle;
    procedure set_LineStyle(value: DNShapeLineStyle);
    function get_StartArrowType: DNArrowType;
    procedure set_StartArrowType(value: DNArrowType);
    function get_EndArrowType: DNArrowType;
    procedure set_EndArrowType(value: DNArrowType);
    function get_StartArrowWidth: DNArrowWidth;
    procedure set_StartArrowWidth(value: DNArrowWidth);
    function get_StartArrowLength: DNArrowLength;
    procedure set_StartArrowLength(value: DNArrowLength);
    function get_EndArrowWidth: DNArrowWidth;
    procedure set_EndArrowWidth(value: DNArrowWidth);
    function get_EndArrowLength: DNArrowLength;
    procedure set_EndArrowLength(value: DNArrowLength);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_ImageBytes: TArray<Byte>;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Defines whether the path will be stroked.
    ///</summary>
    ///<remarks><p>The default value is <b>true</b>
    ///  .</p>
    ///</remarks>
    property &On: Boolean read get_On write set_On;
    ///<summary>
    ///  Defines the color of a stroke.
    ///</summary>
    ///<remarks><p>The default value is
    ///<see cref="P:System.Drawing.Color.Black" />
    ///  .</p>
    ///</remarks>
    property Color: DDN.System.Drawing.DNColor read get_Color write set_Color;
    ///<summary>
    ///  Defines a second color for a stroke.
    ///</summary>
    ///<remarks><p>The default value is
    ///<see cref="P:System.Drawing.Color.White" />
    ///  .</p>
    ///</remarks>
    property Color2: DDN.System.Drawing.DNColor read get_Color2 write set_Color2;
    property ForeColor: DDN.System.Drawing.DNColor read get_ForeColor write set_ForeColor;
    property BackColor: DDN.System.Drawing.DNColor read get_BackColor write set_BackColor;
    property Visible: Boolean read get_Visible write set_Visible;
    property Transparency: Double read get_Transparency write set_Transparency;
    ///<summary>
    ///  Defines the brush thickness that strokes the path of a shape in points.
    ///</summary>
    ///<remarks><p>The default value is 0.75.</p>
    ///</remarks>
    property Weight: Double read get_Weight write set_Weight;
    ///<summary>
    ///  Specifies the dot and dash pattern for a stroke.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.DashStyle.Solid" />
    ///  .</p>
    ///</remarks>
    property DashStyle: DNDashStyle read get_DashStyle write set_DashStyle;
    ///<summary>
    ///  Defines the join style of a polyline.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.JoinStyle.Round" />
    ///  .</p>
    ///</remarks>
    property JoinStyle: DNJoinStyle read get_JoinStyle write set_JoinStyle;
    ///<summary>
    ///  Defines the cap style for the end of a stroke.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.EndCap.Flat" />
    ///  .</p>
    ///</remarks>
    property EndCap: DNEndCap read get_EndCap write set_EndCap;
    ///<summary>
    ///  Defines the line style of the stroke.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.ShapeLineStyle.Single" />
    ///  .</p>
    ///</remarks>
    property LineStyle: DNShapeLineStyle read get_LineStyle write set_LineStyle;
    ///<summary>
    ///  Defines the arrowhead for the start of a stroke.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.ArrowType.None" />
    ///  .</p>
    ///</remarks>
    property StartArrowType: DNArrowType read get_StartArrowType write set_StartArrowType;
    ///<summary>
    ///  Defines the arrowhead for the end of a stroke.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.ArrowType.None" />
    ///  .</p>
    ///</remarks>
    property EndArrowType: DNArrowType read get_EndArrowType write set_EndArrowType;
    ///<summary>
    ///  Defines the arrowhead width for the start of a stroke.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.ArrowWidth.Medium" />
    ///  .</p>
    ///</remarks>
    property StartArrowWidth: DNArrowWidth read get_StartArrowWidth write set_StartArrowWidth;
    ///<summary>
    ///  Defines the arrowhead length for the start of a stroke.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.ArrowLength.Medium" />
    ///  .</p>
    ///</remarks>
    property StartArrowLength: DNArrowLength read get_StartArrowLength write set_StartArrowLength;
    ///<summary>
    ///  Defines the arrowhead width for the end of a stroke.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.ArrowWidth.Medium" />
    ///  .</p>
    ///</remarks>
    property EndArrowWidth: DNArrowWidth read get_EndArrowWidth write set_EndArrowWidth;
    ///<summary>
    ///  Defines the arrowhead length for the end of a stroke.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.ArrowLength.Medium" />
    ///  .</p>
    ///</remarks>
    property EndArrowLength: DNArrowLength read get_EndArrowLength write set_EndArrowLength;
    ///<summary>
    ///  Defines the amount of transparency of a stroke. Valid range is from 0 to 1.
    ///</summary>
    ///<remarks><p>The default value is 1.</p>
    ///</remarks>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  Defines the image for a stroke image or pattern fill.
    ///</summary>
    property ImageBytes: TArray<Byte> read get_ImageBytes;
  end;

  TDNStroke = class(TDNGenericImport<DNStrokeClass, DNStroke>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNTextBoxClass = interface(DDN.mscorlib.DNObjectClass)
  ['{0B0AC423-6F02-537B-BCC5-6B3FB45378A6}']
  end;

  ///<summary>
  ///  Defines attributes that specify how a text is displayed inside a shape.
  ///</summary>
  ///<remarks><p>Use the <see cref="P:Aspose.Words.Drawing.Shape.TextBox" />
  ///  property to access text properties of a shape.
  ///  You do not create instances of the <see cref="T:Aspose.Words.Drawing.TextBox" />
  ///  class directly.</p>
  ///<seealso cref="P:Aspose.Words.Drawing.Shape.TextBox" />
  ///</remarks>
  [DNTypeName('Aspose.Words.Drawing.TextBox')]
  DNTextBox = interface(DDN.mscorlib.DNObject)
  ['{D407E923-03CA-3B22-9AF6-60C22A62E3A3}']
  { getters & setters } 

    function get_InternalMarginLeft: Double;
    procedure set_InternalMarginLeft(value: Double);
    function get_InternalMarginRight: Double;
    procedure set_InternalMarginRight(value: Double);
    function get_InternalMarginTop: Double;
    procedure set_InternalMarginTop(value: Double);
    function get_InternalMarginBottom: Double;
    procedure set_InternalMarginBottom(value: Double);
    function get_FitShapeToText: Boolean;
    procedure set_FitShapeToText(value: Boolean);
    function get_LayoutFlow: DNLayoutFlow;
    procedure set_LayoutFlow(value: DNLayoutFlow);
    function get_TextBoxWrapMode: DNTextBoxWrapMode;
    procedure set_TextBoxWrapMode(value: DNTextBoxWrapMode);
    function get_VerticalAnchor: DNTextBoxAnchor;
    procedure set_VerticalAnchor(value: DNTextBoxAnchor);
    function get_Next: DNTextBox;
    procedure set_Next(value: DNTextBox);
    function get_Previous: DNTextBox;
    function get_Parent: DNShape;

  { methods } 

    ///<summary>
    ///  Determines whether this TextBox can be linked to the target Textbox.
    ///</summary>
    function IsValidLinkTarget(target: DNTextBox): Boolean;
    ///<summary>
    ///  Breaks the link to the next TextBox.
    ///</summary>
    ///<remarks>
    ///  BreakForwardLink() doesn't break all other links in the current sequence of shapes.
    ///  For example: 1-2-3-4 sequence and BreakForwardLink at the 2-nd textbox will create
    ///  two sequences 1-2, 3-4.
    ///</remarks>
    procedure BreakForwardLink;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Specifies the inner left margin in points for a shape.
    ///</summary>
    ///<remarks><p>The default value is 1/10 inch.</p>
    ///</remarks>
    property InternalMarginLeft: Double read get_InternalMarginLeft write set_InternalMarginLeft;
    ///<summary>
    ///  Specifies the inner right margin in points for a shape.
    ///</summary>
    ///<remarks><p>The default value is 1/10 inch.</p>
    ///</remarks>
    property InternalMarginRight: Double read get_InternalMarginRight write set_InternalMarginRight;
    ///<summary>
    ///  Specifies the inner top margin in points for a shape.
    ///</summary>
    ///<remarks><p>The default value is 1/20 inch.</p>
    ///</remarks>
    property InternalMarginTop: Double read get_InternalMarginTop write set_InternalMarginTop;
    ///<summary>
    ///  Specifies the inner bottom margin in points for a shape.
    ///</summary>
    ///<remarks><p>The default value is 1/20 inch.</p>
    ///</remarks>
    property InternalMarginBottom: Double read get_InternalMarginBottom write set_InternalMarginBottom;
    ///<summary>
    ///  Determines whether Microsoft Word will grow the shape to fit text.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property FitShapeToText: Boolean read get_FitShapeToText write set_FitShapeToText;
    ///<summary>
    ///  Determines the flow of the text layout in a shape.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.LayoutFlow.Horizontal" />
    ///  .</p>
    ///</remarks>
    property LayoutFlow: DNLayoutFlow read get_LayoutFlow write set_LayoutFlow;
    ///<summary>
    ///  Determines how text wraps inside a shape.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.TextBoxWrapMode.Square" />
    ///  .</p>
    ///</remarks>
    property TextBoxWrapMode: DNTextBoxWrapMode read get_TextBoxWrapMode write set_TextBoxWrapMode;
    ///<summary>
    ///  Specifies the vertical alignment of the text within a shape.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.TextBoxAnchor.Top" />
    ///  .</p>
    ///</remarks>
    property VerticalAnchor: DNTextBoxAnchor read get_VerticalAnchor write set_VerticalAnchor;
    ///<summary>
    ///  Returns or sets a TextBox that represents the next TextBox in a sequence of shapes.
    ///</summary>
    property Next: DNTextBox read get_Next write set_Next;
    ///<summary>
    ///  Returns a TextBox that represents the previous TextBox in a sequence of shapes.
    ///</summary>
    property Previous: DNTextBox read get_Previous;
    ///<summary>
    ///  Gets a parent shape for the TextBox.
    ///</summary>
    property Parent: DNShape read get_Parent;
  end;

  TDNTextBox = class(TDNGenericImport<DNTextBoxClass, DNTextBox>) end;

  //-------------namespace: Aspose.Words.Drawing----------------
  DNTextPathClass = interface(DDN.mscorlib.DNObjectClass)
  ['{A9F88CD4-3A4B-5FB7-A81E-048D0E1C0D17}']
  end;

  ///<summary>
  ///  Defines the text and formatting of the text path (of a WordArt object).
  ///</summary>
  ///<remarks><p>Use the <see cref="P:Aspose.Words.Drawing.Shape.TextPath" />
  ///  property to access WordArt properties of a shape.
  ///  You do not create instances of the <see cref="T:Aspose.Words.Drawing.TextPath" />
  ///  class directly.</p>
  ///<seealso cref="P:Aspose.Words.Drawing.Shape.TextPath" />
  ///</remarks>
  [DNTypeName('Aspose.Words.Drawing.TextPath')]
  DNTextPath = interface(DDN.mscorlib.DNObject)
  ['{22CD7862-78E8-3B48-B72D-2FD06A1FA04F}']
  { getters & setters } 

    function get_On: Boolean;
    procedure set_On(value: Boolean);
    function get_FitPath: Boolean;
    procedure set_FitPath(value: Boolean);
    function get_FitShape: Boolean;
    procedure set_FitShape(value: Boolean);
    function get_FontFamily: string;
    procedure set_FontFamily(value: string);
    function get_Size: Double;
    procedure set_Size(value: Double);
    function get_Bold: Boolean;
    procedure set_Bold(value: Boolean);
    function get_Italic: Boolean;
    procedure set_Italic(value: Boolean);
    function get_SmallCaps: Boolean;
    procedure set_SmallCaps(value: Boolean);
    function get_RotateLetters: Boolean;
    procedure set_RotateLetters(value: Boolean);
    function get_Trim: Boolean;
    procedure set_Trim(value: Boolean);
    function get_Kerning: Boolean;
    procedure set_Kerning(value: Boolean);
    function get_Shadow: Boolean;
    procedure set_Shadow(value: Boolean);
    function get_Underline: Boolean;
    procedure set_Underline(value: Boolean);
    function get_StrikeThrough: Boolean;
    procedure set_StrikeThrough(value: Boolean);
    function get_SameLetterHeights: Boolean;
    procedure set_SameLetterHeights(value: Boolean);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_TextPathAlignment: DNTextPathAlignment;
    procedure set_TextPathAlignment(value: DNTextPathAlignment);
    function get_ReverseRows: Boolean;
    procedure set_ReverseRows(value: Boolean);
    function get_Spacing: Double;
    procedure set_Spacing(value: Double);
    function get_XScale: Boolean;
    procedure set_XScale(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Defines whether the text is displayed.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property &On: Boolean read get_On write set_On;
    ///<summary>
    ///  Defines whether the text fits the path of a shape.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property FitPath: Boolean read get_FitPath write set_FitPath;
    ///<summary>
    ///  Defines whether the text fits bounding box of a shape.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property FitShape: Boolean read get_FitShape write set_FitShape;
    ///<summary>
    ///  Defines the family of the textpath font.
    ///</summary>
    ///<remarks><p>The default value is Arial.</p>
    ///</remarks>
    property FontFamily: string read get_FontFamily write set_FontFamily;
    ///<summary>
    ///  Defines the size of the font in points.
    ///</summary>
    ///<remarks><p>The default value is 36.</p>
    ///</remarks>
    property Size: Double read get_Size write set_Size;
    ///<summary>
    ///  True if the font is formatted as bold.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property Bold: Boolean read get_Bold write set_Bold;
    ///<summary>
    ///  True if the font is formatted as italic.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property Italic: Boolean read get_Italic write set_Italic;
    ///<summary>
    ///  True if the font is formatted as small capital letters.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property SmallCaps: Boolean read get_SmallCaps write set_SmallCaps;
    ///<summary>
    ///  Determines whether the letters of the text are rotated.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property RotateLetters: Boolean read get_RotateLetters write set_RotateLetters;
    ///<summary>
    ///  Determines whether extra space is removed above and below the text.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property Trim: Boolean read get_Trim write set_Trim;
    ///<summary>
    ///  Determines whether kerning is turned on.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property Kerning: Boolean read get_Kerning write set_Kerning;
    ///<summary>
    ///  Defines whether a shadow is applied to the text on a text path.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property Shadow: Boolean read get_Shadow write set_Shadow;
    ///<summary>
    ///  True if the font is underlined.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property Underline: Boolean read get_Underline write set_Underline;
    ///<summary>
    ///  True if the font is formatted as strikethrough text.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property StrikeThrough: Boolean read get_StrikeThrough write set_StrikeThrough;
    ///<summary>
    ///  Determines whether all letters will be the same height regardless of initial case.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///</remarks>
    property SameLetterHeights: Boolean read get_SameLetterHeights write set_SameLetterHeights;
    ///<summary>
    ///  Defines the text of the text path.
    ///</summary>
    ///<remarks><p>The default value is an empty string.</p>
    ///</remarks>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Defines the alignment of text.
    ///</summary>
    ///<remarks><p>The default value is <see cref="F:Aspose.Words.Drawing.TextPathAlignment.Center" />
    ///  .</p>
    ///</remarks>
    property TextPathAlignment: DNTextPathAlignment read get_TextPathAlignment write set_TextPathAlignment;
    ///<summary>
    ///  Determines whether the layout order of rows is reversed.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///  <p>If <b>true</b>
    ///  , the layout order of rows is reversed. This attribute is used for vertical text layout.</p>
    ///</remarks>
    property ReverseRows: Boolean read get_ReverseRows write set_ReverseRows;
    ///<summary>
    ///  Defines the amount of spacing for text. 1 means 100%.
    ///</summary>
    ///<remarks><p>The default value is 1.</p>
    ///</remarks>
    property Spacing: Double read get_Spacing write set_Spacing;
    ///<summary>
    ///  Determines whether a straight textpath will be used instead of the shape path.
    ///</summary>
    ///<remarks><p>The default value is <b>false</b>
    ///  .</p>
    ///  <p>If <b>true</b>
    ///  , the text runs along a path from left to right along the x value of
    ///  the lower boundary of the shape.</p>
    ///</remarks>
    property XScale: Boolean read get_XScale write set_XScale;
  end;

  TDNTextPath = class(TDNGenericImport<DNTextPathClass, DNTextPath>) end;

  //-------------namespace: Aspose.Words----------------
  DNEditableRangeClass = interface(DDN.mscorlib.DNObjectClass)
  ['{441166C4-AFDC-529E-AB0D-455ADF6931FB}']
  end;

  ///<summary>
  ///  Represents a single editable range.
  ///</summary>
  ///<remarks><p><see cref="T:Aspose.Words.EditableRange" />
  ///  is a "facade" object that encapsulates two nodes <see cref="P:Aspose.Words.EditableRange.EditableRangeStart" />
  ///  and <see cref="P:Aspose.Words.EditableRange.EditableRangeEnd" />
  ///  in a document tree and allows to work with an editable range as a single object.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.EditableRange')]
  DNEditableRange = interface(DDN.mscorlib.DNObject)
  ['{3102D626-FA5C-30D1-BEFA-29A6AC4DFCFE}']
  { getters & setters } 

    function get_Id: Int32;
    function get_SingleUser: string;
    procedure set_SingleUser(value: string);
    function get_EditorGroup: DNEditorType;
    procedure set_EditorGroup(value: DNEditorType);
    function get_EditableRangeStart: DNEditableRangeStart;
    function get_EditableRangeEnd: DNEditableRangeEnd;

  { methods } 

    ///<summary>
    ///  Removes the editable range from the document. Does not remove content inside the editable range.
    ///</summary>
    procedure Remove;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the editable range identifier.
    ///</summary>
    ///<remarks><para>The region must be demarcated using the <see cref="P:Aspose.Words.EditableRange.EditableRangeStart" />
    ///  and <see cref="P:Aspose.Words.EditableRange.EditableRangeEnd" />
    ///</para><para>Editable range identifiers are supposed to be unique across a document and Aspose.Words automatically
    ///  maintains editable range identifiers when loading, saving and combining documents.</para></remarks>
    property Id: Int32 read get_Id;
    ///<summary>
    ///  Returns or sets the single user for editable range.
    ///</summary>
    ///<remarks><p>This editor can be stored in one of the following forms:</p>
    ///  <p>DOMAIN\Username - for users whose access shall be authenticated using the current user's domain credentials.</p>
    ///  <p>user@domain.com - for users whose access shall be authenticated using the user's e-mail address as credentials.</p>
    ///  <p>user - for users whose access shall be authenticated using the current user's machine credentials.</p>
    ///  <p>Single user and editor group cannot be set simultaneously for the specific editable range,
    ///  if the one is set, the other will be clear.</p>
    ///</remarks>
    property SingleUser: string read get_SingleUser write set_SingleUser;
    ///<summary>
    ///  Returns or sets an alias (or editing group) which shall be used to determine if the current user
    ///  shall be allowed to edit this editable range.
    ///</summary>
    ///<remarks><p>Single user and editor group cannot be set simultaneously for the specific editable range,
    ///  if the one is set, the other will be clear.</p>
    ///</remarks>
    property EditorGroup: DNEditorType read get_EditorGroup write set_EditorGroup;
    ///<summary>
    ///  Gets the node that represents the start of the editable range.
    ///</summary>
    property EditableRangeStart: DNEditableRangeStart read get_EditableRangeStart;
    ///<summary>
    ///  Gets the node that represents the end of the editable range.
    ///</summary>
    property EditableRangeEnd: DNEditableRangeEnd read get_EditableRangeEnd;
  end;

  TDNEditableRange = class(TDNGenericImport<DNEditableRangeClass, DNEditableRange>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNBarcodeParametersClass = interface(DDN.mscorlib.DNObjectClass)
  ['{441B032A-ACEC-5EE0-8932-03089518DAFA}']
  { constructors } 

    {class} function init: DNBarcodeParameters;

  end;

  ///<summary>
  ///  Container class for barcode parameters to pass-through to BarcodeGenerator.
  ///</summary>
  ///<remarks>
  ///  The set of parameters are according to DISPLAYBARCODE field options.
  ///  See the exact list at <a href="https://msdn.microsoft.com/en-us/library/hh745901(v=office.12).aspx" />
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.BarcodeParameters')]
  DNBarcodeParameters = interface(DDN.mscorlib.DNObject)
  ['{A3A6CEF2-1DD4-380B-9AFF-A4D3A1024811}']
  { getters & setters } 

    function get_BarcodeType: string;
    procedure set_BarcodeType(value: string);
    function get_BarcodeValue: string;
    procedure set_BarcodeValue(value: string);
    function get_SymbolHeight: string;
    procedure set_SymbolHeight(value: string);
    function get_ForegroundColor: string;
    procedure set_ForegroundColor(value: string);
    function get_BackgroundColor: string;
    procedure set_BackgroundColor(value: string);
    function get_SymbolRotation: string;
    procedure set_SymbolRotation(value: string);
    function get_ScalingFactor: string;
    procedure set_ScalingFactor(value: string);
    function get_PosCodeStyle: string;
    procedure set_PosCodeStyle(value: string);
    function get_CaseCodeStyle: string;
    procedure set_CaseCodeStyle(value: string);
    function get_ErrorCorrectionLevel: string;
    procedure set_ErrorCorrectionLevel(value: string);
    function get_DisplayText: Boolean;
    procedure set_DisplayText(value: Boolean);
    function get_AddStartStopChar: Boolean;
    procedure set_AddStartStopChar(value: Boolean);
    function get_FixCheckDigit: Boolean;
    procedure set_FixCheckDigit(value: Boolean);
    function get_PostalAddress: string;
    procedure set_PostalAddress(value: string);
    function get_IsBookmark: Boolean;
    procedure set_IsBookmark(value: Boolean);
    function get_FacingIdentificationMark: string;
    procedure set_FacingIdentificationMark(value: string);
    function get_IsUSPostalAddress: Boolean;
    procedure set_IsUSPostalAddress(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Bar code type.
    ///</summary>
    property BarcodeType: string read get_BarcodeType write set_BarcodeType;
    ///<summary>
    ///  Data to be encoded.
    ///</summary>
    property BarcodeValue: string read get_BarcodeValue write set_BarcodeValue;
    ///<summary>
    ///  Bar code image height (in twips - 1/1440 inches)
    ///</summary>
    property SymbolHeight: string read get_SymbolHeight write set_SymbolHeight;
    ///<summary>
    ///  Bar code foreground color (0x000000 - 0xFFFFFF)
    ///</summary>
    property ForegroundColor: string read get_ForegroundColor write set_ForegroundColor;
    ///<summary>
    ///  Bar code background color (0x000000 - 0xFFFFFF)
    ///</summary>
    property BackgroundColor: string read get_BackgroundColor write set_BackgroundColor;
    ///<summary>
    ///  Rotation of the barcode symbol. Valid values are [0, 3].
    ///</summary>
    property SymbolRotation: string read get_SymbolRotation write set_SymbolRotation;
    ///<summary>
    ///  Scaling factor for the symbol. The value is in whole percentage points and the valid values are [10, 1000].
    ///</summary>
    property ScalingFactor: string read get_ScalingFactor write set_ScalingFactor;
    ///<summary>
    ///  Style of a Point of Sale barcode (barcode types UPCA|UPCE|EAN13|EAN8). The valid values (case insensitive) are [STD|SUP2|SUP5|CASE].
    ///</summary>
    property PosCodeStyle: string read get_PosCodeStyle write set_PosCodeStyle;
    ///<summary>
    ///  Style of a Case Code for barcode type ITF14. The valid values are [STD|EXT|ADD]
    ///</summary>
    property CaseCodeStyle: string read get_CaseCodeStyle write set_CaseCodeStyle;
    ///<summary>
    ///  Error correction level of QR Code. Valid values are [0, 3].
    ///</summary>
    property ErrorCorrectionLevel: string read get_ErrorCorrectionLevel write set_ErrorCorrectionLevel;
    ///<summary>
    ///  Whether to display barcode data (text) along with image.
    ///</summary>
    property DisplayText: Boolean read get_DisplayText write set_DisplayText;
    ///<summary>
    ///  Whether to add Start/Stop characters for barcode types NW7 and CODE39.
    ///</summary>
    property AddStartStopChar: Boolean read get_AddStartStopChar write set_AddStartStopChar;
    ///<summary>
    ///  Whether to fix the check digit if it’s invalid.
    ///</summary>
    property FixCheckDigit: Boolean read get_FixCheckDigit write set_FixCheckDigit;
    ///<summary>
    ///  Barcode postal address.
    ///</summary>
    property PostalAddress: string read get_PostalAddress write set_PostalAddress;
    ///<summary>
    ///  Whether <see cref="P:Aspose.Words.Fields.BarcodeParameters.PostalAddress" />
    ///  is the name of a bookmark.
    ///</summary>
    property IsBookmark: Boolean read get_IsBookmark write set_IsBookmark;
    ///<summary>
    ///  Type of a Facing Identification Mark (FIM).
    ///</summary>
    property FacingIdentificationMark: string read get_FacingIdentificationMark write set_FacingIdentificationMark;
    ///<summary>
    ///  Whether <see cref="P:Aspose.Words.Fields.BarcodeParameters.PostalAddress" />
    ///  is a U.S. postal address.
    ///</summary>
    property IsUSPostalAddress: Boolean read get_IsUSPostalAddress write set_IsUSPostalAddress;
  end;

  TDNBarcodeParameters = class(TDNGenericImport<DNBarcodeParametersClass, DNBarcodeParameters>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNComparisonEvaluationResultClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F7D0837A-3C62-561C-AE22-7FB7987A8708}']
  { constructors } 

    ///<summary>
    ///  Creates a comparison evaluation result.
    ///</summary>
    {class} function init(result: Boolean): DNComparisonEvaluationResult; overload;
    ///<summary>
    ///  Creates a failed comparison evaluation result with the corresponding error message.
    ///</summary>
    {class} function init(errorMessage: string): DNComparisonEvaluationResult; overload;

  end;

  ///<summary>
  ///  The comparison evaluation result.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.ComparisonEvaluationResult')]
  DNComparisonEvaluationResult = interface(DDN.mscorlib.DNObject)
  ['{BDF2155A-DC8D-304E-9277-3BE126EB4B1A}']
  { getters & setters } 

    function get_Result: Boolean;
    function get_ErrorMessage: string;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the comparison evaluation result.
    ///</summary>
    property Result: Boolean read get_Result;
    ///<summary>
    ///  Gets the failed comparison evaluation result's error message.
    ///</summary>
    property ErrorMessage: string read get_ErrorMessage;
  end;

  TDNComparisonEvaluationResult = class(TDNGenericImport<DNComparisonEvaluationResultClass, DNComparisonEvaluationResult>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNComparisonExpressionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{58C556D2-2F28-55DB-9263-C7730C26AA64}']
  end;

  ///<summary>
  ///  The comparison expression.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.ComparisonExpression')]
  DNComparisonExpression = interface(DDN.mscorlib.DNObject)
  ['{949B5B26-039E-35D8-BA56-C2C316786D68}']
  { getters & setters } 

    function get_LeftExpression: string;
    function get_ComparisonOperator: string;
    function get_RightExpression: string;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the left expression.
    ///</summary>
    property LeftExpression: string read get_LeftExpression;
    ///<summary>
    ///  Gets the comparison operator.
    ///</summary>
    property ComparisonOperator: string read get_ComparisonOperator;
    ///<summary>
    ///  Gets the right expression.
    ///</summary>
    property RightExpression: string read get_RightExpression;
  end;

  TDNComparisonExpression = class(TDNGenericImport<DNComparisonExpressionClass, DNComparisonExpression>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNDropDownItemCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{60EF6076-95FC-5E8C-B871-D89A52E8FAB2}']
  end;

  ///<summary>
  ///  A collection of strings that represent all the items in a drop-down form field.
  ///</summary>
  ///<seealso cref="T:Aspose.Words.Fields.FormField" />
  ///<seealso cref="P:Aspose.Words.Fields.FormField.DropDownItems" />
  [DNTypeName('Aspose.Words.Fields.DropDownItemCollection')]
  DNDropDownItemCollection = interface(DDN.mscorlib.DNObject)
  ['{89282693-6CDE-3429-91C5-765570873605}']
  { getters & setters } 

    function get_Count: Int32;
    function get_Item(index: Int32): string;
    procedure set_Item(index: Int32; value: string);

  { methods } 

    ///<summary>
    ///  Returns an enumerator object that can be used to iterate over all items in the collection.
    ///</summary>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<string>;
    ///<summary>
    ///  Adds a string to the end of the collection.
    ///</summary>
    ///  <param name="value">The string to add to the end of the collection.</param>
    ///<returns>The zero-based index at which the new element is inserted.</returns>
    function Add(value: string): Int32;
    ///<summary>
    ///  Determines whether the collection contains the specified value.
    ///</summary>
    ///  <param name="value">Case-sensitive value to locate.</param>
    ///<returns>True if the item is found in the collection; otherwise, false.</returns>
    function &Contains(value: string): Boolean;
    ///<summary>
    ///  Returns the zero-based index of the specified value in the collection.
    ///</summary>
    ///  <param name="value">The case-sensitive value to locate.</param>
    ///<returns>The zero based index. Negative value if not found.</returns>
    function IndexOf(value: string): Int32;
    ///<summary>
    ///  Inserts a string into the collection at the specified index.
    ///</summary>
    ///  <param name="index">The zero-based index at which value is inserted.</param>
    ///  <param name="value">The string to insert.</param>
    procedure Insert(index: Int32; value: string);
    ///<summary>
    ///  Removes the specified value from the collection.
    ///</summary>
    ///  <param name="name">The case-sensitive value to remove.</param>
    procedure Remove(name: string);
    ///<summary>
    ///  Removes a value at the specified index.
    ///</summary>
    ///  <param name="index">The zero based index.</param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Removes all elements from the collection.
    ///</summary>
    procedure Clear;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the number of elements contained in the collection.
    ///</summary>
    property Count: Int32 read get_Count;
    property Item[index: Int32]: string read get_Item write set_Item; default;
  end;

  TDNDropDownItemCollection = class(TDNGenericImport<DNDropDownItemCollectionClass, DNDropDownItemCollection>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldClass = interface(DDN.mscorlib.DNObjectClass)
  ['{7F9FF57F-0CAC-5BBA-BDF7-35DC98A46158}']
  end;

  ///<summary>
  ///  Represents a Microsoft Word document field.
  ///</summary>
  ///<remarks><para>A field in a Word document is a complex structure consisting of multiple nodes that include field start,
  ///  field code, field separator, field result and field end. Fields can be nested, contain rich content and span
  ///  multiple paragraphs or sections in a document. The <see cref="T:Aspose.Words.Fields.Field" />
  ///  class is a "facade" object that provides
  ///  properties and methods that allow to work with a field as a single object. </para><para>The <see cref="P:Aspose.Words.Fields.Field.Start" />
  ///  , <see cref="P:Aspose.Words.Fields.Field.Separator" />
  ///  and <see cref="P:Aspose.Words.Fields.Field.End" />
  ///  properties point to the
  ///  field start, separator and end nodes of the field respectively.</para><para>The content between the field start and separator is the field code. The content between the
  ///  field separator and field end is the field result. The field code typically consists of one or more
  ///<see cref="T:Aspose.Words.Run" />
  ///  objects that specify instructions. The processing application is expected to execute
  ///  the field code to calculate the field result.</para><para>The process of calculating field results is called the field update. Aspose.Words can update field
  ///  results of most of the field types in exactly the same way as Microsoft Word does it. Most notably,
  ///  Aspose.Words can calculate results of even the most complex formula fields. To calculate the field
  ///  result of a single field use the <see cref="M:Aspose.Words.Fields.Field.Update" />
  ///  method. To update fields in the whole document
  ///  use <see cref="M:Aspose.Words.Document.UpdateFields" />
  ///  .</para><para>You can get the plain text version of the field code using the <see cref="M:Aspose.Words.Fields.Field.GetFieldCode(System.Boolean)" />
  ///  method.
  ///  You can get and set the plain text version of the field result using the <see cref="P:Aspose.Words.Fields.Field.Result" />
  ///  property.
  ///  Both the field code and field result can contain complex content, such as nested fields, paragraphs, shapes,
  ///  tables and in this case you might want to work with the field nodes directly if you need more control.</para><para>You do not create instances of the <see cref="T:Aspose.Words.Fields.Field" />
  ///  class directly.
  ///  To create a new field use the <see cref="M:Aspose.Words.DocumentBuilder.InsertField(System.String)" />
  ///  method.</para></remarks>
  [DNTypeName('Aspose.Words.Fields.Field')]
  DNField = interface(DDN.mscorlib.DNObject)
  ['{229A53BC-A029-39E4-A768-37A0F2672484}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNField = class(TDNGenericImport<DNFieldClass, DNField>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAddInClass = interface(DNFieldClass)
  ['{5DC105C2-C2B9-543D-BD64-832DABF32F6D}']
  { constructors } 

    {class} function init: DNFieldAddIn;

  end;

  ///<summary>
  ///  Implements the ADDIN field.
  ///</summary>
  ///<remarks>
  ///  Contains data created by an add-in.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAddIn')]
  DNFieldAddIn = interface(DNField)
  ['{E61CA7B1-B894-3B3E-A763-E8FCF439162A}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAddIn = class(TDNGenericImport<DNFieldAddInClass, DNFieldAddIn>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAddressBlockClass = interface(DNFieldClass)
  ['{157EA77C-1990-5456-A4D8-93A1995A89B2}']
  { constructors } 

    {class} function init: DNFieldAddressBlock;

  end;

  ///<summary>
  ///  Implements the ADDRESSBLOCK field.
  ///</summary>
  ///<remarks>
  ///  Represents an address block. An <i>address block</i> is a block of text specifying information
  ///  appropriate for a postal mailing address, in the order required by the destination country.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAddressBlock')]
  DNFieldAddressBlock = interface(DNField)
  ['{73FF1AFC-7C08-31C9-B8A0-41AC2CD288A2}']
  { getters & setters } 

    function get_FormatAddressOnCountryOrRegion: Boolean;
    procedure set_FormatAddressOnCountryOrRegion(value: Boolean);
    function get_IncludeCountryOrRegionName: string;
    procedure set_IncludeCountryOrRegionName(value: string);
    function get_ExcludedCountryOrRegionName: string;
    procedure set_ExcludedCountryOrRegionName(value: string);
    function get_NameAndAddressFormat: string;
    procedure set_NameAndAddressFormat(value: string);
    function get_LanguageId: string;
    procedure set_LanguageId(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns a collection of mail merge field names used by the field.
    ///</summary>
    function GetFieldNames: TArray<string>;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets whether to format the address according to the country/region of the recipient
    ///  as defined by POST*CODE (Universal Postal Union 2006).
    ///</summary>
    property FormatAddressOnCountryOrRegion: Boolean read get_FormatAddressOnCountryOrRegion write set_FormatAddressOnCountryOrRegion;
    ///<summary>
    ///  Gets or sets whether to include the name of the country/region.
    ///</summary>
    property IncludeCountryOrRegionName: string read get_IncludeCountryOrRegionName write set_IncludeCountryOrRegionName;
    ///<summary>
    ///  Gets or sets the excluded country/region name.
    ///</summary>
    ///<dev>TODO DV May be more than one.</dev>
    property ExcludedCountryOrRegionName: string read get_ExcludedCountryOrRegionName write set_ExcludedCountryOrRegionName;
    ///<summary>
    ///  Gets or sets the name and address format.
    ///</summary>
    property NameAndAddressFormat: string read get_NameAndAddressFormat write set_NameAndAddressFormat;
    ///<summary>
    ///  Gets or sets the language ID used to format the address.
    ///</summary>
    property LanguageId: string read get_LanguageId write set_LanguageId;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAddressBlock = class(TDNGenericImport<DNFieldAddressBlockClass, DNFieldAddressBlock>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAdvanceClass = interface(DNFieldClass)
  ['{6B6F79B2-C6B8-5032-B35F-512C78159E34}']
  { constructors } 

    {class} function init: DNFieldAdvance;

  end;

  ///<summary>
  ///  Implements the ADVANCE field.
  ///</summary>
  ///<remarks>
  ///  Moves the starting point at which the text that lexically follows the field is displayed to the right or left,
  ///  up or down, or to a specific horizontal or vertical position.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAdvance')]
  DNFieldAdvance = interface(DNField)
  ['{2894E0BC-2D99-3E28-9440-534CFBAF7B9F}']
  { getters & setters } 

    function get_DownOffset: string;
    procedure set_DownOffset(value: string);
    function get_LeftOffset: string;
    procedure set_LeftOffset(value: string);
    function get_RightOffset: string;
    procedure set_RightOffset(value: string);
    function get_UpOffset: string;
    procedure set_UpOffset(value: string);
    function get_HorizontalPosition: string;
    procedure set_HorizontalPosition(value: string);
    function get_VerticalPosition: string;
    procedure set_VerticalPosition(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the number of points by which the text that follows the field should be moved down.
    ///</summary>
    property DownOffset: string read get_DownOffset write set_DownOffset;
    ///<summary>
    ///  Gets or sets the number of points by which the text that follows the field should be moved left.
    ///</summary>
    property LeftOffset: string read get_LeftOffset write set_LeftOffset;
    ///<summary>
    ///  Gets or sets the number of points by which the text that follows the field should be moved right.
    ///</summary>
    property RightOffset: string read get_RightOffset write set_RightOffset;
    ///<summary>
    ///  Gets or sets the number of points by which the text that follows the field should be moved up.
    ///</summary>
    property UpOffset: string read get_UpOffset write set_UpOffset;
    ///<summary>
    ///  Gets or sets the number of points by which the text that follows the field should be moved horizontally
    ///  from the left edge of the column, frame, or text box.
    ///</summary>
    property HorizontalPosition: string read get_HorizontalPosition write set_HorizontalPosition;
    ///<summary>
    ///  Gets or sets the number of points by which the text that follows the field should be moved vertically
    ///  from the top edge of the page.
    ///</summary>
    property VerticalPosition: string read get_VerticalPosition write set_VerticalPosition;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAdvance = class(TDNGenericImport<DNFieldAdvanceClass, DNFieldAdvance>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAskClass = interface(DNFieldClass)
  ['{9D08BEFB-E239-51F2-B0F7-E9282257B2E1}']
  { constructors } 

    {class} function init: DNFieldAsk;

  end;

  ///<summary>
  ///  Implements the ASK field.
  ///</summary>
  ///<remarks>
  ///  Prompts the user to enter information and assigns a bookmark to represent the user's response.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAsk')]
  DNFieldAsk = interface(DNField)
  ['{A85B5276-4983-3A4C-9469-63B0D4D7300B}']
  { getters & setters } 

    function get_BookmarkName: string;
    procedure set_BookmarkName(value: string);
    function get_PromptText: string;
    procedure set_PromptText(value: string);
    function get_DefaultResponse: string;
    procedure set_DefaultResponse(value: string);
    function get_PromptOnceOnMailMerge: Boolean;
    procedure set_PromptOnceOnMailMerge(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the name of the bookmark.
    ///</summary>
    property BookmarkName: string read get_BookmarkName write set_BookmarkName;
    ///<summary>
    ///  Gets or sets the prompt text (the title of the prompt window).
    ///</summary>
    property PromptText: string read get_PromptText write set_PromptText;
    ///<summary>
    ///  Gets or sets default user response (initial value contained in the prompt window).
    ///</summary>
    property DefaultResponse: string read get_DefaultResponse write set_DefaultResponse;
    ///<summary>
    ///  Gets or sets whether the user response should be recieved once per a mail merge operation.
    ///</summary>
    property PromptOnceOnMailMerge: Boolean read get_PromptOnceOnMailMerge write set_PromptOnceOnMailMerge;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAsk = class(TDNGenericImport<DNFieldAskClass, DNFieldAsk>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAuthorClass = interface(DNFieldClass)
  ['{FF48DD4C-990F-574A-8C94-53E2BD53D20B}']
  { constructors } 

    {class} function init: DNFieldAuthor;

  end;

  ///<summary>
  ///  Implements the AUTHOR field.
  ///</summary>
  ///<remarks>
  ///  Retrieves, and optionally sets, the document author's name, as recorded in the <b>Author</b>
  ///  property of the
  ///  built-in document properties.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAuthor')]
  DNFieldAuthor = interface(DNField)
  ['{1DEAEA38-C2A2-3405-8977-FFD22230DEA8}']
  { getters & setters } 

    function get_AuthorName: string;
    procedure set_AuthorName(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the document author's name.
    ///</summary>
    property AuthorName: string read get_AuthorName write set_AuthorName;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAuthor = class(TDNGenericImport<DNFieldAuthorClass, DNFieldAuthor>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAutoNumClass = interface(DNFieldClass)
  ['{759BDAB4-448F-5A2A-94E4-EC275ADE20E0}']
  { constructors } 

    {class} function init: DNFieldAutoNum;

  end;

  ///<summary>
  ///  Implements the AUTONUM field.
  ///</summary>
  ///<remarks>
  ///  Inserts an automatic number.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAutoNum')]
  DNFieldAutoNum = interface(DNField)
  ['{71A59ADA-5A60-3806-9B8E-8F40F775BAF8}']
  { getters & setters } 

    function get_SeparatorCharacter: string;
    procedure set_SeparatorCharacter(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the separator character to be used.
    ///</summary>
    property SeparatorCharacter: string read get_SeparatorCharacter write set_SeparatorCharacter;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAutoNum = class(TDNGenericImport<DNFieldAutoNumClass, DNFieldAutoNum>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAutoNumLglClass = interface(DNFieldClass)
  ['{E48AFDE4-46F5-5BA1-85F2-169900CEE000}']
  { constructors } 

    {class} function init: DNFieldAutoNumLgl;

  end;

  ///<summary>
  ///  Implements the AUTONUMLGL field.
  ///</summary>
  ///<remarks>
  ///  Inserts an automatic number in legal format.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAutoNumLgl')]
  DNFieldAutoNumLgl = interface(DNField)
  ['{C8D67FAD-ECF3-3719-875C-175858A0F493}']
  { getters & setters } 

    function get_RemoveTrailingPeriod: Boolean;
    procedure set_RemoveTrailingPeriod(value: Boolean);
    function get_SeparatorCharacter: string;
    procedure set_SeparatorCharacter(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets whether to display the number without a trailing period.
    ///</summary>
    property RemoveTrailingPeriod: Boolean read get_RemoveTrailingPeriod write set_RemoveTrailingPeriod;
    ///<summary>
    ///  Gets or sets the separator character to be used.
    ///</summary>
    property SeparatorCharacter: string read get_SeparatorCharacter write set_SeparatorCharacter;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAutoNumLgl = class(TDNGenericImport<DNFieldAutoNumLglClass, DNFieldAutoNumLgl>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAutoNumOutClass = interface(DNFieldClass)
  ['{D97314B1-F319-5411-ABA6-F9596190C157}']
  { constructors } 

    {class} function init: DNFieldAutoNumOut;

  end;

  ///<summary>
  ///  Implements the AUTONUMOUT field.
  ///</summary>
  ///<remarks>
  ///  Inserts an automatic number in outline format.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAutoNumOut')]
  DNFieldAutoNumOut = interface(DNField)
  ['{E12540DA-3962-3C1B-A861-5593B1B3BA5D}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAutoNumOut = class(TDNGenericImport<DNFieldAutoNumOutClass, DNFieldAutoNumOut>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAutoTextClass = interface(DNFieldClass)
  ['{CB955D7C-919A-517E-8DE5-7C7079E1DD93}']
  { constructors } 

    {class} function init: DNFieldAutoText;

  end;

  ///<summary>
  ///  Implements the AUTOTEXT field.
  ///</summary>
  ///<remarks>
  ///  Inserts an AutoText entry.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAutoText')]
  DNFieldAutoText = interface(DNField)
  ['{DFF9D88C-8259-357D-A80C-B83F47433086}']
  { getters & setters } 

    function get_EntryName: string;
    procedure set_EntryName(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the name of the AutoText entry.
    ///</summary>
    property EntryName: string read get_EntryName write set_EntryName;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAutoText = class(TDNGenericImport<DNFieldAutoTextClass, DNFieldAutoText>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldAutoTextListClass = interface(DNFieldClass)
  ['{B3D5C7CC-DD0E-537B-B272-2EF542E8E16A}']
  { constructors } 

    {class} function init: DNFieldAutoTextList;

  end;

  ///<summary>
  ///  Implements the AUTOTEXTLIST field.
  ///</summary>
  ///<remarks>
  ///  Creates a shortcut menu based on AutoText entries in the active template.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldAutoTextList')]
  DNFieldAutoTextList = interface(DNField)
  ['{4E87F851-01C5-36B0-B33F-75E2C85DDFD4}']
  { getters & setters } 

    function get_EntryName: string;
    procedure set_EntryName(value: string);
    function get_ListStyle: string;
    procedure set_ListStyle(value: string);
    function get_ScreenTip: string;
    procedure set_ScreenTip(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the name of the AutoText entry.
    ///</summary>
    property EntryName: string read get_EntryName write set_EntryName;
    ///<summary>
    ///  Gets or sets the name of the style on which the list to contain entries is based.
    ///</summary>
    property ListStyle: string read get_ListStyle write set_ListStyle;
    ///<summary>
    ///  Gets or sets the text of the ScreenTip to show.
    ///</summary>
    property ScreenTip: string read get_ScreenTip write set_ScreenTip;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldAutoTextList = class(TDNGenericImport<DNFieldAutoTextListClass, DNFieldAutoTextList>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldBarcodeClass = interface(DNFieldClass)
  ['{7CDABC97-745E-5079-909C-078A82F2B4B8}']
  { constructors } 

    {class} function init: DNFieldBarcode;

  end;

  ///<summary>
  ///  Implements the BARCODE field.
  ///</summary>
  ///<remarks>
  ///  Inserts a postal barcode in a machine-readable form of address used by the U.S. Postal Service.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldBarcode')]
  DNFieldBarcode = interface(DNField)
  ['{C48961D5-5D42-3500-A8B6-3259D7572745}']
  { getters & setters } 

    function get_PostalAddress: string;
    procedure set_PostalAddress(value: string);
    function get_IsBookmark: Boolean;
    procedure set_IsBookmark(value: Boolean);
    function get_FacingIdentificationMark: string;
    procedure set_FacingIdentificationMark(value: string);
    function get_IsUSPostalAddress: Boolean;
    procedure set_IsUSPostalAddress(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the postal address used for generating a barcode or the name of the bookmark that refers to it.
    ///</summary>
    property PostalAddress: string read get_PostalAddress write set_PostalAddress;
    ///<summary>
    ///  Gets or sets whether <see cref="P:Aspose.Words.Fields.FieldBarcode.PostalAddress" />
    ///  is the name of a bookmark.
    ///</summary>
    property IsBookmark: Boolean read get_IsBookmark write set_IsBookmark;
    ///<summary>
    ///  Gets or sets the type of a Facing Identification Mark (FIM) to insert.
    ///</summary>
    property FacingIdentificationMark: string read get_FacingIdentificationMark write set_FacingIdentificationMark;
    ///<summary>
    ///  Gets or sets whether <see cref="P:Aspose.Words.Fields.FieldBarcode.PostalAddress" />
    ///  is a U.S. postal address.
    ///</summary>
    property IsUSPostalAddress: Boolean read get_IsUSPostalAddress write set_IsUSPostalAddress;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldBarcode = class(TDNGenericImport<DNFieldBarcodeClass, DNFieldBarcode>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldBibliographyClass = interface(DNFieldClass)
  ['{8E1E9A17-0D3A-563C-8A98-85BFD8F53D76}']
  { constructors } 

    {class} function init: DNFieldBibliography;

  end;

  ///<summary>
  ///  Implements the BIBLIOGRAPHY field.
  ///</summary>
  ///<remarks>Inserts the contents of the document's Bibliography part in a bibliographic style.</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldBibliography')]
  DNFieldBibliography = interface(DNField)
  ['{A844C3A9-967F-315A-A84E-58BC59524C1A}']
  { getters & setters } 

    function get_FormatLanguageId: string;
    procedure set_FormatLanguageId(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the language ID that is used to format the bibliographic sources in the document.
    ///</summary>
    property FormatLanguageId: string read get_FormatLanguageId write set_FormatLanguageId;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldBibliography = class(TDNGenericImport<DNFieldBibliographyClass, DNFieldBibliography>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldBidiOutlineClass = interface(DNFieldClass)
  ['{055C022F-1356-5153-AC64-8177D680E1CD}']
  { constructors } 

    {class} function init: DNFieldBidiOutline;

  end;

  ///<summary>
  ///  Implements the BIDIOUTLINE field.
  ///</summary>
  ///<remarks>
  ///  This field is identical to the AUTONUMLGL field, except for the separator that delimits each level
  ///  of the paragraph numbering.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldBidiOutline')]
  DNFieldBidiOutline = interface(DNField)
  ['{B78597AE-44B1-3897-A7F8-FA1A04F7175A}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldBidiOutline = class(TDNGenericImport<DNFieldBidiOutlineClass, DNFieldBidiOutline>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldCitationClass = interface(DNFieldClass)
  ['{D0F73E71-C31A-5E6E-A68C-0F7F14F1B09C}']
  { constructors } 

    {class} function init: DNFieldCitation;

  end;

  ///<summary>
  ///  Implements the CITATION field.
  ///</summary>
  ///<remarks>
  ///  Inserts the contents of the <b>Source</b>
  ///  element with a specified <b>Tag</b>
  ///  element using a bibliographic style.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldCitation')]
  DNFieldCitation = interface(DNField)
  ['{5F73992B-A27E-3E8B-B511-CD3C9020E96B}']
  { getters & setters } 

    function get_SourceTag: string;
    procedure set_SourceTag(value: string);
    function get_FormatLanguageId: string;
    procedure set_FormatLanguageId(value: string);
    function get_Prefix: string;
    procedure set_Prefix(value: string);
    function get_Suffix: string;
    procedure set_Suffix(value: string);
    function get_SuppressAuthor: Boolean;
    procedure set_SuppressAuthor(value: Boolean);
    function get_SuppressTitle: Boolean;
    procedure set_SuppressTitle(value: Boolean);
    function get_SuppressYear: Boolean;
    procedure set_SuppressYear(value: Boolean);
    function get_PageNumber: string;
    procedure set_PageNumber(value: string);
    function get_VolumeNumber: string;
    procedure set_VolumeNumber(value: string);
    function get_AnotherSourceTag: string;
    procedure set_AnotherSourceTag(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets a value that mathes the <b>Tag</b>
    ///  element's value of the source to insert.
    ///</summary>
    property SourceTag: string read get_SourceTag write set_SourceTag;
    ///<summary>
    ///  Gets or sets the language ID that is used in conjunction with the specified bibliographic style to format the citation
    ///  in the document.
    ///</summary>
    property FormatLanguageId: string read get_FormatLanguageId write set_FormatLanguageId;
    ///<summary>
    ///  Gets or sets a prefix that is prepended to the citation.
    ///</summary>
    property Prefix: string read get_Prefix write set_Prefix;
    ///<summary>
    ///  Gets or sets a suffix that is appended to the citation.
    ///</summary>
    property Suffix: string read get_Suffix write set_Suffix;
    ///<summary>
    ///  Gets or sets whether the author information is suppressed from the citation.
    ///</summary>
    property SuppressAuthor: Boolean read get_SuppressAuthor write set_SuppressAuthor;
    ///<summary>
    ///  Gets or sets whether the title information is suppressed from the citation.
    ///</summary>
    property SuppressTitle: Boolean read get_SuppressTitle write set_SuppressTitle;
    ///<summary>
    ///  Gets or sets whether the year information is suppressed from the citation.
    ///</summary>
    property SuppressYear: Boolean read get_SuppressYear write set_SuppressYear;
    ///<summary>
    ///  Gets or sets a page number associated with the citation.
    ///</summary>
    property PageNumber: string read get_PageNumber write set_PageNumber;
    ///<summary>
    ///  Gets or sets a volume number associated with the citation.
    ///</summary>
    property VolumeNumber: string read get_VolumeNumber write set_VolumeNumber;
    ///<summary>
    ///  Gets or sets a value that mathes the <b>Tag</b>
    ///  element's value of another source to be included in the citation.
    ///</summary>
    property AnotherSourceTag: string read get_AnotherSourceTag write set_AnotherSourceTag;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldCitation = class(TDNGenericImport<DNFieldCitationClass, DNFieldCitation>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldCommentsClass = interface(DNFieldClass)
  ['{7F747C94-1C21-5544-AACB-D69C0378DC63}']
  { constructors } 

    {class} function init: DNFieldComments;

  end;

  ///<summary>
  ///  Implements the COMMENTS field.
  ///</summary>
  ///<remarks>
  ///  Retrieves, and optionally sets, the comments relating to the current document, as recorded in the <b>Comments</b>
  ///  property
  ///  of the built-in document properties.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldComments')]
  DNFieldComments = interface(DNField)
  ['{F7575D18-0228-386F-B123-16E9DDDA313F}']
  { getters & setters } 

    function get_Text: string;
    procedure set_Text(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the text of the comments.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldComments = class(TDNGenericImport<DNFieldCommentsClass, DNFieldComments>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldCompareClass = interface(DNFieldClass)
  ['{78767D18-3147-596B-8053-944FCE5EDE2F}']
  { constructors } 

    {class} function init: DNFieldCompare;

  end;

  ///<summary>
  ///  Implements the COMPARE field.
  ///</summary>
  ///<remarks>
  ///  Compares the values designated by the expressions <see cref="P:Aspose.Words.Fields.FieldCompare.LeftExpression" />
  ///  and <see cref="P:Aspose.Words.Fields.FieldCompare.RightExpression" />
  ///  in comparison using the operator designated by <see cref="P:Aspose.Words.Fields.FieldCompare.ComparisonOperator" />
  ///  .
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldCompare')]
  DNFieldCompare = interface(DNField)
  ['{E6B34847-1A7B-3C66-AF21-926AC4827652}']
  { getters & setters } 

    function get_LeftExpression: string;
    procedure set_LeftExpression(value: string);
    function get_ComparisonOperator: string;
    procedure set_ComparisonOperator(value: string);
    function get_RightExpression: string;
    procedure set_RightExpression(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the left part of the comparison expression.
    ///</summary>
    property LeftExpression: string read get_LeftExpression write set_LeftExpression;
    ///<summary>
    ///  Gets or sets the comparison operator.
    ///</summary>
    property ComparisonOperator: string read get_ComparisonOperator write set_ComparisonOperator;
    ///<summary>
    ///  Gets or sets the right part of the comparison expression.
    ///</summary>
    property RightExpression: string read get_RightExpression write set_RightExpression;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldCompare = class(TDNGenericImport<DNFieldCompareClass, DNFieldCompare>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldCreateDateClass = interface(DNFieldClass)
  ['{6A77BA44-3892-5C64-9139-C4D5F05DEC0C}']
  { constructors } 

    {class} function init: DNFieldCreateDate;

  end;

  ///<summary>
  ///  Implements the CREATEDATE field.
  ///</summary>
  ///<remarks>
  ///  Retrieves the date and time at which the document was created. By default, the Gregorian calendar is used.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldCreateDate')]
  DNFieldCreateDate = interface(DNField)
  ['{D509863E-6031-33E8-8B8A-E85317D4D11A}']
  { getters & setters } 

    function get_UseLunarCalendar: Boolean;
    procedure set_UseLunarCalendar(value: Boolean);
    function get_UseSakaEraCalendar: Boolean;
    procedure set_UseSakaEraCalendar(value: Boolean);
    function get_UseUmAlQuraCalendar: Boolean;
    procedure set_UseUmAlQuraCalendar(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets whether to use the Hijri Lunar or Hebrew Lunar calendar.
    ///</summary>
    property UseLunarCalendar: Boolean read get_UseLunarCalendar write set_UseLunarCalendar;
    ///<summary>
    ///  Gets or sets whether to use the Saka Era calendar.
    ///</summary>
    property UseSakaEraCalendar: Boolean read get_UseSakaEraCalendar write set_UseSakaEraCalendar;
    ///<summary>
    ///  Gets or sets whether to use the Um-al-Qura calendar.
    ///</summary>
    property UseUmAlQuraCalendar: Boolean read get_UseUmAlQuraCalendar write set_UseUmAlQuraCalendar;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldCreateDate = class(TDNGenericImport<DNFieldCreateDateClass, DNFieldCreateDate>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldDataClass = interface(DNFieldClass)
  ['{2EF6A561-4727-5C1D-841E-06507014829E}']
  { constructors } 

    {class} function init: DNFieldData;

  end;

  ///<summary>
  ///  Implements the DATA field.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.FieldData')]
  DNFieldData = interface(DNField)
  ['{2510FC93-D8FD-3F5A-B9B9-B786DF37EAF0}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldData = class(TDNGenericImport<DNFieldDataClass, DNFieldData>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldDatabaseClass = interface(DNFieldClass)
  ['{533C701D-1B92-5581-A947-3CC6349FB451}']
  { constructors } 

    {class} function init: DNFieldDatabase;

  end;

  ///<summary>
  ///  Implements the DATABASE field.
  ///</summary>
  ///<remarks>
  ///  Inserts the results of a database query into a WordprocessingML table.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldDatabase')]
  DNFieldDatabase = interface(DNField)
  ['{E9B70AF2-77CE-3095-835B-1D92F55E616E}']
  { getters & setters } 

    function get_FormatAttributes: string;
    procedure set_FormatAttributes(value: string);
    function get_Connection: string;
    procedure set_Connection(value: string);
    function get_FileName: string;
    procedure set_FileName(value: string);
    function get_FirstRecord: string;
    procedure set_FirstRecord(value: string);
    function get_InsertHeadings: Boolean;
    procedure set_InsertHeadings(value: Boolean);
    function get_TableFormat: string;
    procedure set_TableFormat(value: string);
    function get_InsertOnceOnMailMerge: Boolean;
    procedure set_InsertOnceOnMailMerge(value: Boolean);
    function get_Query: string;
    procedure set_Query(value: string);
    function get_LastRecord: string;
    procedure set_LastRecord(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets which attributes of the format are to be applied to the table.
    ///</summary>
    property FormatAttributes: string read get_FormatAttributes write set_FormatAttributes;
    ///<summary>
    ///  Gets or sets a connection to the data.
    ///</summary>
    property Connection: string read get_Connection write set_Connection;
    ///<summary>
    ///  Gets or sets the complete path and file name of the database
    ///</summary>
    property FileName: string read get_FileName write set_FileName;
    ///<summary>
    ///  Gets or sets the integral record number of the first data record to insert.
    ///</summary>
    property FirstRecord: string read get_FirstRecord write set_FirstRecord;
    ///<summary>
    ///  Gets or sets whether to insert the field names from the database as column headings in
    ///  the resulting table.
    ///</summary>
    property InsertHeadings: Boolean read get_InsertHeadings write set_InsertHeadings;
    ///<summary>
    ///  Gets or sets the format that is to be applied to the result of the database query.
    ///</summary>
    property TableFormat: string read get_TableFormat write set_TableFormat;
    ///<summary>
    ///  Gets or sets whether to insert data at the beginning of a merge.
    ///</summary>
    property InsertOnceOnMailMerge: Boolean read get_InsertOnceOnMailMerge write set_InsertOnceOnMailMerge;
    ///<summary>
    ///  Gets or sets a set of SQL instructions that query the database.
    ///</summary>
    property Query: string read get_Query write set_Query;
    ///<summary>
    ///  Gets or sets the integral record number of the last data record to insert.
    ///</summary>
    property LastRecord: string read get_LastRecord write set_LastRecord;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldDatabase = class(TDNGenericImport<DNFieldDatabaseClass, DNFieldDatabase>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldDateClass = interface(DNFieldClass)
  ['{3C76FB40-2C7E-5021-85CF-7BB91DAC3642}']
  { constructors } 

    {class} function init: DNFieldDate;

  end;

  ///<summary>
  ///  Implements the DATE field.
  ///</summary>
  ///<remarks>
  ///  Inserts the current date and time. By default, the Gregorian calendar is used.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldDate')]
  DNFieldDate = interface(DNField)
  ['{73F914F8-E864-328F-BCA4-D07EFA609B05}']
  { getters & setters } 

    function get_UseLunarCalendar: Boolean;
    procedure set_UseLunarCalendar(value: Boolean);
    function get_UseLastFormat: Boolean;
    procedure set_UseLastFormat(value: Boolean);
    function get_UseSakaEraCalendar: Boolean;
    procedure set_UseSakaEraCalendar(value: Boolean);
    function get_UseUmAlQuraCalendar: Boolean;
    procedure set_UseUmAlQuraCalendar(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets whether to use the Hijri Lunar or Hebrew Lunar calendar.
    ///</summary>
    property UseLunarCalendar: Boolean read get_UseLunarCalendar write set_UseLunarCalendar;
    ///<summary>
    ///  Gets or sets whether to use a format last used by the hosting application when inserting a new DATE field.
    ///</summary>
    property UseLastFormat: Boolean read get_UseLastFormat write set_UseLastFormat;
    ///<summary>
    ///  Gets or sets whether to use the Saka Era calendar.
    ///</summary>
    property UseSakaEraCalendar: Boolean read get_UseSakaEraCalendar write set_UseSakaEraCalendar;
    ///<summary>
    ///  Gets or sets whether to use the Um-al-Qura calendar.
    ///</summary>
    property UseUmAlQuraCalendar: Boolean read get_UseUmAlQuraCalendar write set_UseUmAlQuraCalendar;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldDate = class(TDNGenericImport<DNFieldDateClass, DNFieldDate>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldDdeClass = interface(DNFieldClass)
  ['{137D4F39-9D53-5BDE-B8A7-3163B93B2E38}']
  { constructors } 

    {class} function init: DNFieldDde;

  end;

  ///<summary>
  ///  Implements the DDE field.
  ///</summary>
  ///<remarks>
  ///  For information copied from another application, this field links that information to its original source file using DDE.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldDde')]
  DNFieldDde = interface(DNField)
  ['{B4827D67-492B-344A-A72C-22728E96623D}']
  { getters & setters } 

    function get_ProgId: string;
    procedure set_ProgId(value: string);
    function get_SourceFullName: string;
    procedure set_SourceFullName(value: string);
    function get_SourceItem: string;
    procedure set_SourceItem(value: string);
    function get_AutoUpdate: Boolean;
    procedure set_AutoUpdate(value: Boolean);
    function get_InsertAsBitmap: Boolean;
    procedure set_InsertAsBitmap(value: Boolean);
    function get_IsLinked: Boolean;
    procedure set_IsLinked(value: Boolean);
    function get_InsertAsHtml: Boolean;
    procedure set_InsertAsHtml(value: Boolean);
    function get_InsertAsPicture: Boolean;
    procedure set_InsertAsPicture(value: Boolean);
    function get_InsertAsRtf: Boolean;
    procedure set_InsertAsRtf(value: Boolean);
    function get_InsertAsText: Boolean;
    procedure set_InsertAsText(value: Boolean);
    function get_InsertAsUnicode: Boolean;
    procedure set_InsertAsUnicode(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the application type of the link information.
    ///</summary>
    property ProgId: string read get_ProgId write set_ProgId;
    ///<summary>
    ///  Gets or sets the name and location of the source file.
    ///</summary>
    property SourceFullName: string read get_SourceFullName write set_SourceFullName;
    ///<summary>
    ///  Gets or sets the portion of the source file that's being linked.
    ///</summary>
    property SourceItem: string read get_SourceItem write set_SourceItem;
    ///<summary>
    ///  Gets or sets whether to update this field automatically.
    ///</summary>
    property AutoUpdate: Boolean read get_AutoUpdate write set_AutoUpdate;
    ///<summary>
    ///  Gets or sets whether to insert the linked object as a bitmap.
    ///</summary>
    property InsertAsBitmap: Boolean read get_InsertAsBitmap write set_InsertAsBitmap;
    ///<summary>
    ///  Gets or sets whether to reduce the file size by not storing graphics data with the document.
    ///</summary>
    property IsLinked: Boolean read get_IsLinked write set_IsLinked;
    ///<summary>
    ///  Gets or sets whether to insert the linked object as HTML format text.
    ///</summary>
    property InsertAsHtml: Boolean read get_InsertAsHtml write set_InsertAsHtml;
    ///<summary>
    ///  Gets or sets whether to insert the linked object as a picture.
    ///</summary>
    property InsertAsPicture: Boolean read get_InsertAsPicture write set_InsertAsPicture;
    ///<summary>
    ///  Gets or sets whether to insert the linked object in rich-text format (RTF).
    ///</summary>
    property InsertAsRtf: Boolean read get_InsertAsRtf write set_InsertAsRtf;
    ///<summary>
    ///  Gets or sets whether to insert the linked object in text-only format.
    ///</summary>
    property InsertAsText: Boolean read get_InsertAsText write set_InsertAsText;
    ///<summary>
    ///  Gets or sets whether to insert the linked object as Unicode text.
    ///</summary>
    property InsertAsUnicode: Boolean read get_InsertAsUnicode write set_InsertAsUnicode;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldDde = class(TDNGenericImport<DNFieldDdeClass, DNFieldDde>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldDdeAutoClass = interface(DNFieldClass)
  ['{D7E71541-0A87-5238-A6B0-D7E659CB971C}']
  { constructors } 

    {class} function init: DNFieldDdeAuto;

  end;

  ///<summary>
  ///  Implements the DDEAUTO field.
  ///</summary>
  ///<remarks>
  ///  For information copied from another application, this field links that information to its original source file using DDE
  ///  and is updated automatically.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldDdeAuto')]
  DNFieldDdeAuto = interface(DNField)
  ['{97160B19-DFCC-3F46-A713-F84B5C1BFCCE}']
  { getters & setters } 

    function get_ProgId: string;
    procedure set_ProgId(value: string);
    function get_SourceFullName: string;
    procedure set_SourceFullName(value: string);
    function get_SourceItem: string;
    procedure set_SourceItem(value: string);
    function get_InsertAsBitmap: Boolean;
    procedure set_InsertAsBitmap(value: Boolean);
    function get_IsLinked: Boolean;
    procedure set_IsLinked(value: Boolean);
    function get_InsertAsHtml: Boolean;
    procedure set_InsertAsHtml(value: Boolean);
    function get_InsertAsPicture: Boolean;
    procedure set_InsertAsPicture(value: Boolean);
    function get_InsertAsRtf: Boolean;
    procedure set_InsertAsRtf(value: Boolean);
    function get_InsertAsText: Boolean;
    procedure set_InsertAsText(value: Boolean);
    function get_InsertAsUnicode: Boolean;
    procedure set_InsertAsUnicode(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the application type of the link information.
    ///</summary>
    property ProgId: string read get_ProgId write set_ProgId;
    ///<summary>
    ///  Gets or sets the name and location of the source file.
    ///</summary>
    property SourceFullName: string read get_SourceFullName write set_SourceFullName;
    ///<summary>
    ///  Gets or sets the portion of the source file that's being linked.
    ///</summary>
    property SourceItem: string read get_SourceItem write set_SourceItem;
    ///<summary>
    ///  Gets or sets whether to insert the linked object as a bitmap.
    ///</summary>
    property InsertAsBitmap: Boolean read get_InsertAsBitmap write set_InsertAsBitmap;
    ///<summary>
    ///  Gets or sets whether to reduce the file size by not storing graphics data with the document.
    ///</summary>
    property IsLinked: Boolean read get_IsLinked write set_IsLinked;
    ///<summary>
    ///  Gets or sets whether to insert the linked object as HTML format text.
    ///</summary>
    property InsertAsHtml: Boolean read get_InsertAsHtml write set_InsertAsHtml;
    ///<summary>
    ///  Gets or sets whether to insert the linked object as a picture.
    ///</summary>
    property InsertAsPicture: Boolean read get_InsertAsPicture write set_InsertAsPicture;
    ///<summary>
    ///  Gets or sets whether to insert the linked object in rich-text format (RTF).
    ///</summary>
    property InsertAsRtf: Boolean read get_InsertAsRtf write set_InsertAsRtf;
    ///<summary>
    ///  Gets or sets whether to insert the linked object in text-only format.
    ///</summary>
    property InsertAsText: Boolean read get_InsertAsText write set_InsertAsText;
    ///<summary>
    ///  Gets or sets whether to insert the linked object as Unicode text.
    ///</summary>
    property InsertAsUnicode: Boolean read get_InsertAsUnicode write set_InsertAsUnicode;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldDdeAuto = class(TDNGenericImport<DNFieldDdeAutoClass, DNFieldDdeAuto>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldDisplayBarcodeClass = interface(DNFieldClass)
  ['{87079811-4396-5B48-9079-B7DAA3FF7D00}']
  { constructors } 

    {class} function init: DNFieldDisplayBarcode;

  end;

  ///<summary>
  ///  Implements the DISPLAYBARCODE field.
  ///</summary>
  ///<remarks>
  ///  Inserts a barcode.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldDisplayBarcode')]
  DNFieldDisplayBarcode = interface(DNField)
  ['{3E90513A-929C-351F-A9DE-73727AFC71A6}']
  { getters & setters } 

    function get_BarcodeValue: string;
    procedure set_BarcodeValue(value: string);
    function get_BarcodeType: string;
    procedure set_BarcodeType(value: string);
    function get_SymbolHeight: string;
    procedure set_SymbolHeight(value: string);
    function get_SymbolRotation: string;
    procedure set_SymbolRotation(value: string);
    function get_ScalingFactor: string;
    procedure set_ScalingFactor(value: string);
    function get_ForegroundColor: string;
    procedure set_ForegroundColor(value: string);
    function get_BackgroundColor: string;
    procedure set_BackgroundColor(value: string);
    function get_PosCodeStyle: string;
    procedure set_PosCodeStyle(value: string);
    function get_CaseCodeStyle: string;
    procedure set_CaseCodeStyle(value: string);
    function get_ErrorCorrectionLevel: string;
    procedure set_ErrorCorrectionLevel(value: string);
    function get_DisplayText: Boolean;
    procedure set_DisplayText(value: Boolean);
    function get_AddStartStopChar: Boolean;
    procedure set_AddStartStopChar(value: Boolean);
    function get_FixCheckDigit: Boolean;
    procedure set_FixCheckDigit(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the barcode value.
    ///</summary>
    property BarcodeValue: string read get_BarcodeValue write set_BarcodeValue;
    ///<summary>
    ///  Gets or sets the barcode type (QR, etc.)
    ///</summary>
    property BarcodeType: string read get_BarcodeType write set_BarcodeType;
    ///<summary>
    ///  Gets or sets the height of the symbol. The units are in TWIPS (1/1440 inch).
    ///</summary>
    property SymbolHeight: string read get_SymbolHeight write set_SymbolHeight;
    ///<summary>
    ///  Gets or sets the rotation of the barcode symbol. Valid values are [0, 3]
    ///</summary>
    property SymbolRotation: string read get_SymbolRotation write set_SymbolRotation;
    ///<summary>
    ///  Gets or sets a scaling factor for the symbol. The value is in whole percentage points and the valid values are [10, 1000]
    ///</summary>
    property ScalingFactor: string read get_ScalingFactor write set_ScalingFactor;
    ///<summary>
    ///  Gets or sets the foreground color of the barcode symbol. Valid values are in the range [0, 0xFFFFFF]
    ///</summary>
    property ForegroundColor: string read get_ForegroundColor write set_ForegroundColor;
    ///<summary>
    ///  Gets or sets the background color of the barcode symbol. Valid values are in the range [0, 0xFFFFFF]
    ///</summary>
    property BackgroundColor: string read get_BackgroundColor write set_BackgroundColor;
    ///<summary>
    ///  Gets or sets the style of a Point of Sale barcode (barcode types UPCA|UPCE|EAN13|EAN8). The valid values (case insensitive) are [STD|SUP2|SUP5|CASE].
    ///</summary>
    property PosCodeStyle: string read get_PosCodeStyle write set_PosCodeStyle;
    ///<summary>
    ///  Gets or sets the style of a Case Code for barcode type ITF14. The valid values are [STD|EXT|ADD]
    ///</summary>
    property CaseCodeStyle: string read get_CaseCodeStyle write set_CaseCodeStyle;
    ///<summary>
    ///  Gets or sets an error correction level of QR Code. Valid values are [0, 3].
    ///</summary>
    property ErrorCorrectionLevel: string read get_ErrorCorrectionLevel write set_ErrorCorrectionLevel;
    ///<summary>
    ///  Gets or sets whether to display barcode data (text) along with image.
    ///</summary>
    property DisplayText: Boolean read get_DisplayText write set_DisplayText;
    ///<summary>
    ///  Gets or sets whether to add Start/Stop characters for barcode types NW7 and CODE39.
    ///</summary>
    property AddStartStopChar: Boolean read get_AddStartStopChar write set_AddStartStopChar;
    ///<summary>
    ///  Gets or sets whether to fix the check digit if it’s invalid.
    ///</summary>
    property FixCheckDigit: Boolean read get_FixCheckDigit write set_FixCheckDigit;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldDisplayBarcode = class(TDNGenericImport<DNFieldDisplayBarcodeClass, DNFieldDisplayBarcode>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldDocPropertyClass = interface(DNFieldClass)
  ['{17FCA47C-77C2-5937-B982-01D575CE0CF0}']
  { constructors } 

    {class} function init: DNFieldDocProperty;

  end;

  ///<summary>
  ///  Implements the DOCPROPERTY field.
  ///</summary>
  ///<remarks>
  ///  Retrieves the indicated document information.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldDocProperty')]
  DNFieldDocProperty = interface(DNField)
  ['{2309AFF9-0C32-3D0C-BBE5-51F8D7FCC61C}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldDocProperty = class(TDNGenericImport<DNFieldDocPropertyClass, DNFieldDocProperty>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldDocVariableClass = interface(DNFieldClass)
  ['{EC9C05C3-94D7-5FFE-B9C6-D3D4961394AE}']
  { constructors } 

    {class} function init: DNFieldDocVariable;

  end;

  ///<summary>
  ///  Implements DOCVARIABLE field.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.FieldDocVariable')]
  DNFieldDocVariable = interface(DNField)
  ['{A8B71DB2-D6C2-3759-A12F-23778C2AF6FE}']
  { getters & setters } 

    function get_VariableName: string;
    procedure set_VariableName(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the name of the document variable to retrieve.
    ///</summary>
    property VariableName: string read get_VariableName write set_VariableName;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldDocVariable = class(TDNGenericImport<DNFieldDocVariableClass, DNFieldDocVariable>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldEditTimeClass = interface(DNFieldClass)
  ['{857935F8-7FAC-55C7-90FD-B77E862AC22A}']
  { constructors } 

    {class} function init: DNFieldEditTime;

  end;

  ///<summary>
  ///  Implements the EDITTIME field.
  ///</summary>
  ///<remarks>
  ///  Retrieves the total editing time, in minutes, since the document was created.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldEditTime')]
  DNFieldEditTime = interface(DNField)
  ['{4CC3C820-98E9-3BB0-831B-4FBA5AA21558}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldEditTime = class(TDNGenericImport<DNFieldEditTimeClass, DNFieldEditTime>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldEmbedClass = interface(DNFieldClass)
  ['{A257C457-C0FD-5281-9317-3B982834E05A}']
  { constructors } 

    {class} function init: DNFieldEmbed;

  end;

  ///<summary>
  ///  Implements the EMBED field.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.FieldEmbed')]
  DNFieldEmbed = interface(DNField)
  ['{55CE8CF1-E044-3E06-98DC-15CF5CFE89EA}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldEmbed = class(TDNGenericImport<DNFieldEmbedClass, DNFieldEmbed>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldEQClass = interface(DNFieldClass)
  ['{C81CF2F3-2F6C-50D6-92E2-524BB30EE0CE}']
  { constructors } 

    {class} function init: DNFieldEQ;

  end;

  ///<summary>
  ///  Implements the EQ field.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.FieldEQ')]
  DNFieldEQ = interface(DNField)
  ['{FCB5C35A-8ABF-35AF-ACBA-5585FCE6B996}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldEQ = class(TDNGenericImport<DNFieldEQClass, DNFieldEQ>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldFileNameClass = interface(DNFieldClass)
  ['{276BD5E3-1727-5C53-B6A6-931CE98F957D}']
  { constructors } 

    {class} function init: DNFieldFileName;

  end;

  ///<summary>
  ///  Implements the FILENAME field.
  ///</summary>
  ///<remarks><p>Retrieves the name of the current document from its storage location.</p>
  ///  <p>In the current implementation, uses the <see cref="P:Aspose.Words.Document.OriginalFileName" />
  ///  property to retrieve
  ///  the file name. If the document was loaded from a stream or created blank, uses the name of the file that is being saved to (if known).</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldFileName')]
  DNFieldFileName = interface(DNField)
  ['{AD6C7B50-4A8A-3B21-9AA5-71A0D1FCA4A4}']
  { getters & setters } 

    function get_IncludeFullPath: Boolean;
    procedure set_IncludeFullPath(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets whether to include the full file path name.
    ///</summary>
    property IncludeFullPath: Boolean read get_IncludeFullPath write set_IncludeFullPath;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldFileName = class(TDNGenericImport<DNFieldFileNameClass, DNFieldFileName>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldFileSizeClass = interface(DNFieldClass)
  ['{5AA4B9A4-FA41-55C0-A153-D0E529780E38}']
  { constructors } 

    {class} function init: DNFieldFileSize;

  end;

  ///<summary>
  ///  Implements the FILESIZE field.
  ///</summary>
  ///<remarks><p>Retrieves the size of the current document's file or 0 if the size cannot be determined.</p>
  ///  <p>In the current implementation, uses the <see cref="P:Aspose.Words.Document.OriginalFileName" />
  ///  property to retrieve
  ///  the file name used to determine the file size.</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldFileSize')]
  DNFieldFileSize = interface(DNField)
  ['{8601243E-B485-37BB-858D-81501B34FFD6}']
  { getters & setters } 

    function get_IsInKilobytes: Boolean;
    procedure set_IsInKilobytes(value: Boolean);
    function get_IsInMegabytes: Boolean;
    procedure set_IsInMegabytes(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets whether to display the file size in kilobytes.
    ///</summary>
    property IsInKilobytes: Boolean read get_IsInKilobytes write set_IsInKilobytes;
    ///<summary>
    ///  Gets or sets whether to display the file size in megabytes.
    ///</summary>
    property IsInMegabytes: Boolean read get_IsInMegabytes write set_IsInMegabytes;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldFileSize = class(TDNGenericImport<DNFieldFileSizeClass, DNFieldFileSize>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldFillInClass = interface(DNFieldClass)
  ['{0536757F-B7C4-5D6A-9CEC-96EB70FB2DE3}']
  { constructors } 

    {class} function init: DNFieldFillIn;

  end;

  ///<summary>
  ///  Implements the FILLIN field.
  ///</summary>
  ///<remarks>
  ///  Prompts the user to enter text.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldFillIn')]
  DNFieldFillIn = interface(DNField)
  ['{4B0A92F1-CF17-365A-AFDC-637531A0C8C7}']
  { getters & setters } 

    function get_PromptText: string;
    procedure set_PromptText(value: string);
    function get_PromptOnceOnMailMerge: Boolean;
    procedure set_PromptOnceOnMailMerge(value: Boolean);
    function get_DefaultResponse: string;
    procedure set_DefaultResponse(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the prompt text (the title of the prompt window).
    ///</summary>
    property PromptText: string read get_PromptText write set_PromptText;
    ///<summary>
    ///  Gets or sets whether the user response should be recieved once per a mail merge operation.
    ///</summary>
    property PromptOnceOnMailMerge: Boolean read get_PromptOnceOnMailMerge write set_PromptOnceOnMailMerge;
    ///<summary>
    ///  Gets or sets default user response (initial value contained in the prompt window).
    ///</summary>
    property DefaultResponse: string read get_DefaultResponse write set_DefaultResponse;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldFillIn = class(TDNGenericImport<DNFieldFillInClass, DNFieldFillIn>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldFootnoteRefClass = interface(DNFieldClass)
  ['{AD29AD3C-4005-55F7-B16C-8A7FAE8359FF}']
  { constructors } 

    {class} function init: DNFieldFootnoteRef;

  end;

  ///<summary>
  ///  Implements the FOOTNOTEREF field.
  ///</summary>
  [DNTypeName('Aspose.Words.Fields.FieldFootnoteRef')]
  DNFieldFootnoteRef = interface(DNField)
  ['{B1D56C69-C509-3CD9-A0A6-4722F21E52A3}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldFootnoteRef = class(TDNGenericImport<DNFieldFootnoteRefClass, DNFieldFootnoteRef>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldFormCheckBoxClass = interface(DNFieldClass)
  ['{8EF4F193-86ED-5F89-A0CA-A0BA4B8799B7}']
  { constructors } 

    {class} function init: DNFieldFormCheckBox;

  end;

  ///<summary>
  ///  Implements the FORMCHECKBOX field.
  ///</summary>
  ///<remarks>
  ///  Inserts a check box style form field.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldFormCheckBox')]
  DNFieldFormCheckBox = interface(DNField)
  ['{70FE43B2-D519-3B2D-87E5-A53639315DF5}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldFormCheckBox = class(TDNGenericImport<DNFieldFormCheckBoxClass, DNFieldFormCheckBox>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldFormDropDownClass = interface(DNFieldClass)
  ['{4C5E1629-E4E1-54E3-8D28-326F75ABDF10}']
  { constructors } 

    {class} function init: DNFieldFormDropDown;

  end;

  ///<summary>
  ///  Implements the FORMDROPDOWN field.
  ///</summary>
  ///<remarks>
  ///  Inserts a drop-down list style form field.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldFormDropDown')]
  DNFieldFormDropDown = interface(DNField)
  ['{F1BA1D99-A5F1-3DA9-89BF-65806ED45BD9}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldFormDropDown = class(TDNGenericImport<DNFieldFormDropDownClass, DNFieldFormDropDown>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldFormTextClass = interface(DNFieldClass)
  ['{18647DDA-0091-58FA-8CE6-231DFAD7A37F}']
  { constructors } 

    {class} function init: DNFieldFormText;

  end;

  ///<summary>
  ///  Implements the FORMTEXT field.
  ///</summary>
  ///<remarks>
  ///  Inserts a text box style form field.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldFormText')]
  DNFieldFormText = interface(DNField)
  ['{E4C9933B-8AE7-3749-AF7B-7C88F916D2C6}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldFormText = class(TDNGenericImport<DNFieldFormTextClass, DNFieldFormText>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldFormulaClass = interface(DNFieldClass)
  ['{8E1C9123-18B5-5961-ABD1-E33C1EC10DA7}']
  { constructors } 

    {class} function init: DNFieldFormula;

  end;

  ///<summary>
  ///  Implements the = (formula) field.
  ///</summary>
  ///<remarks>
  ///  Calcualtes the result of an expression.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldFormula')]
  DNFieldFormula = interface(DNField)
  ['{3DE0C309-DF7E-3AA9-A217-4F42ADC3903E}']
  { getters & setters } 

    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldFormula = class(TDNGenericImport<DNFieldFormulaClass, DNFieldFormula>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldGlossaryClass = interface(DNFieldClass)
  ['{6666D891-7902-582D-AB5A-BEA85743CE22}']
  { constructors } 

    {class} function init: DNFieldGlossary;

  end;

  ///<summary>
  ///  Implements the GLOSSARY field.
  ///</summary>
  ///<remarks>
  ///  Inserts a glossary entry.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldGlossary')]
  DNFieldGlossary = interface(DNField)
  ['{045D9B22-6F00-3FD9-A4E3-4A3D811844EC}']
  { getters & setters } 

    function get_EntryName: string;
    procedure set_EntryName(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the name of the glossary entry to insert.
    ///</summary>
    property EntryName: string read get_EntryName write set_EntryName;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldGlossary = class(TDNGenericImport<DNFieldGlossaryClass, DNFieldGlossary>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldGoToButtonClass = interface(DNFieldClass)
  ['{42656015-B99C-5E44-A7CD-669485B8CB49}']
  { constructors } 

    {class} function init: DNFieldGoToButton;

  end;

  ///<summary>
  ///  Implements the GOTOBUTTON field.
  ///</summary>
  ///<remarks>
  ///  Inserts a jump command, such that when it is activated, the insertion point of the document is
  ///  moved to the specified location.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldGoToButton')]
  DNFieldGoToButton = interface(DNField)
  ['{07DB9A87-4280-3065-BB4B-132A71F04694}']
  { getters & setters } 

    function get_Location: string;
    procedure set_Location(value: string);
    function get_DisplayText: string;
    procedure set_DisplayText(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the name of a bookmark, a page number, or some other item to jump to.
    ///</summary>
    property Location: string read get_Location write set_Location;
    ///<summary>
    ///  Gets or sets the text of the "button" that appears in the document, such that it can be selected to activate the jump.
    ///</summary>
    property DisplayText: string read get_DisplayText write set_DisplayText;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldGoToButton = class(TDNGenericImport<DNFieldGoToButtonClass, DNFieldGoToButton>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldGreetingLineClass = interface(DNFieldClass)
  ['{CBD37E55-F16C-5777-80C9-48D0CE8A1F81}']
  { constructors } 

    {class} function init: DNFieldGreetingLine;

  end;

  ///<summary>
  ///  Implements the GREETINGLINE field.
  ///</summary>
  ///<remarks>
  ///  Inserts a mail merge greeting line.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldGreetingLine')]
  DNFieldGreetingLine = interface(DNField)
  ['{6B49C1FF-3007-3C0D-8F61-AEE58C6E3898}']
  { getters & setters } 

    function get_AlternateText: string;
    procedure set_AlternateText(value: string);
    function get_NameFormat: string;
    procedure set_NameFormat(value: string);
    function get_LanguageId: string;
    procedure set_LanguageId(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns a collection of mail merge field names used by the field.
    ///</summary>
    function GetFieldNames: TArray<string>;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the text to include in the field if the name is blank.
    ///</summary>
    property AlternateText: string read get_AlternateText write set_AlternateText;
    ///<summary>
    ///  Gets or sets the format of the name included in the field.
    ///</summary>
    property NameFormat: string read get_NameFormat write set_NameFormat;
    ///<summary>
    ///  Gets or sets the language id used to format the name.
    ///</summary>
    property LanguageId: string read get_LanguageId write set_LanguageId;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldGreetingLine = class(TDNGenericImport<DNFieldGreetingLineClass, DNFieldGreetingLine>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldHyperlinkClass = interface(DNFieldClass)
  ['{43BD32D2-0317-574B-9873-6538641914D4}']
  { constructors } 

    {class} function init: DNFieldHyperlink;

  end;

  ///<summary>
  ///  Implements the HYPERLINK field
  ///</summary>
  ///<remarks>
  ///  When selected, causes control to jump to the location such as a bookmark or a URL.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldHyperlink')]
  DNFieldHyperlink = interface(DNField)
  ['{285CAFF2-E895-3919-B714-87B429715F2C}']
  { getters & setters } 

    function get_Target: string;
    procedure set_Target(value: string);
    function get_Address: string;
    procedure set_Address(value: string);
    function get_SubAddress: string;
    procedure set_SubAddress(value: string);
    function get_IsImageMap: Boolean;
    procedure set_IsImageMap(value: Boolean);
    function get_OpenInNewWindow: Boolean;
    procedure set_OpenInNewWindow(value: Boolean);
    function get_ScreenTip: string;
    procedure set_ScreenTip(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the target to which the link should be redirected.
    ///</summary>
    property Target: string read get_Target write set_Target;
    ///<summary>
    ///  Gets or sets a location where this hyperlink jumps.
    ///</summary>
    property Address: string read get_Address write set_Address;
    ///<summary>
    ///  Gets or sets a location in the file, such as a bookmark, where this hyperlink jumps.
    ///</summary>
    property SubAddress: string read get_SubAddress write set_SubAddress;
    ///<summary>
    ///  Gets or sets whether to append coordinates to the hyperlink for a server-side image map.
    ///</summary>
    property IsImageMap: Boolean read get_IsImageMap write set_IsImageMap;
    ///<summary>
    ///  Gets or sets whether to open the destination site in a new web browser window.
    ///</summary>
    property OpenInNewWindow: Boolean read get_OpenInNewWindow write set_OpenInNewWindow;
    ///<summary>
    ///  Gets or sets the ScreenTip text for the hyperlink.
    ///</summary>
    property ScreenTip: string read get_ScreenTip write set_ScreenTip;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldHyperlink = class(TDNGenericImport<DNFieldHyperlinkClass, DNFieldHyperlink>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldIfClass = interface(DNFieldClass)
  ['{98E4B5E9-39A7-5215-B87A-656517AB4FA2}']
  { constructors } 

    {class} function init: DNFieldIf;

  end;

  ///<summary>
  ///  Implements the IF field.
  ///</summary>
  ///<remarks><p>Compares the values designated by the expressions <see cref="P:Aspose.Words.Fields.FieldIf.LeftExpression" />
  ///  and <see cref="P:Aspose.Words.Fields.FieldIf.RightExpression" />
  ///  in comparison using the operator designated by <see cref="P:Aspose.Words.Fields.FieldIf.ComparisonOperator" />
  ///  .</p>
  ///  <p>A field in the following format will be used as a mail merge source: { IF 0 = 0 "{PatientsNameFML}" "" \* MERGEFORMAT }</p>
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldIf')]
  DNFieldIf = interface(DNField)
  ['{B08D7E25-304B-378F-8F1C-2A5A51705C85}']
  { getters & setters } 

    function get_LeftExpression: string;
    procedure set_LeftExpression(value: string);
    function get_ComparisonOperator: string;
    procedure set_ComparisonOperator(value: string);
    function get_RightExpression: string;
    procedure set_RightExpression(value: string);
    function get_TrueText: string;
    procedure set_TrueText(value: string);
    function get_FalseText: string;
    procedure set_FalseText(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Evaluates the condition.
    ///</summary>
    ///<returns>
    ///  A <see cref="T:Aspose.Words.Fields.FieldIfComparisonResult" />
    ///  value that represents the result of the condition evaluation.
    ///</returns>
    function EvaluateCondition: DNFieldIfComparisonResult;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the left part of the comparison expression.
    ///</summary>
    property LeftExpression: string read get_LeftExpression write set_LeftExpression;
    ///<summary>
    ///  Gets or sets the comparison operator.
    ///</summary>
    property ComparisonOperator: string read get_ComparisonOperator write set_ComparisonOperator;
    ///<summary>
    ///  Gets or sets the right part of the comparison expression.
    ///</summary>
    property RightExpression: string read get_RightExpression write set_RightExpression;
    ///<summary>
    ///  Gets or sets the text displayed if the comparison expression is true.
    ///</summary>
    property TrueText: string read get_TrueText write set_TrueText;
    ///<summary>
    ///  Gets or sets the text displayed if the comparison expression is false.
    ///</summary>
    property FalseText: string read get_FalseText write set_FalseText;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldIf = class(TDNGenericImport<DNFieldIfClass, DNFieldIf>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldImportClass = interface(DNFieldClass)
  ['{0DD62AD8-40D1-551F-B609-993DFA5B1B00}']
  { constructors } 

    {class} function init: DNFieldImport;

  end;

  ///<summary>
  ///  Implements the IMPORT field.
  ///</summary>
  ///<remarks>
  ///  Retrieves the picture contained in the document.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldImport')]
  DNFieldImport = interface(DNField)
  ['{FBFD459C-F403-3F3B-A46F-005350421789}']
  { getters & setters } 

    function get_SourceFullName: string;
    procedure set_SourceFullName(value: string);
    function get_GraphicFilter: string;
    procedure set_GraphicFilter(value: string);
    function get_IsLinked: Boolean;
    procedure set_IsLinked(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the location of the picture.
    ///</summary>
    property SourceFullName: string read get_SourceFullName write set_SourceFullName;
    ///<summary>
    ///  Gets or sets the name of the filter for the format of the graphic that is to be inserted.
    ///</summary>
    property GraphicFilter: string read get_GraphicFilter write set_GraphicFilter;
    ///<summary>
    ///  Gets or sets whether to reduce the file size by not storing graphics data with the document.
    ///</summary>
    property IsLinked: Boolean read get_IsLinked write set_IsLinked;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldImport = class(TDNGenericImport<DNFieldImportClass, DNFieldImport>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldIncludeClass = interface(DNFieldClass)
  ['{6C7C2EF7-0E99-54C0-A40D-25CF797EC77B}']
  { constructors } 

    {class} function init: DNFieldInclude;

  end;

  ///<summary>
  ///  Implements the INCLUDE field.
  ///</summary>
  ///<remarks>
  ///  Inserts all or part of the text and graphics contained in another document.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldInclude')]
  DNFieldInclude = interface(DNField)
  ['{A939BA4F-7647-3EF7-BCBA-53B529D707A4}']
  { getters & setters } 

    function get_SourceFullName: string;
    procedure set_SourceFullName(value: string);
    function get_BookmarkName: string;
    procedure set_BookmarkName(value: string);
    function get_LockFields: Boolean;
    procedure set_LockFields(value: Boolean);
    function get_TextConverter: string;
    procedure set_TextConverter(value: string);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the location of the document.
    ///</summary>
    property SourceFullName: string read get_SourceFullName write set_SourceFullName;
    ///<summary>
    ///  Gets or sets the name of the bookmark in the document to include.
    ///</summary>
    property BookmarkName: string read get_BookmarkName write set_BookmarkName;
    ///<summary>
    ///  Gets or sets whether to prevent fields in the included document from being updated.
    ///</summary>
    property LockFields: Boolean read get_LockFields write set_LockFields;
    ///<summary>
    ///  Gets or sets the name of the text converter for the format of the included file.
    ///</summary>
    property TextConverter: string read get_TextConverter write set_TextConverter;
    ///<summary>
    ///  Gets the node that represents the start of the field.
    ///</summary>
    property Start: DNFieldStart read get_Start;
    ///<summary>
    ///  Gets the node that represents the field separator. Can be null.
    ///</summary>
    property Separator: DNFieldSeparator read get_Separator;
    ///<summary>
    ///  Gets the node that represents the field end.
    ///</summary>
    property &End: DNFieldEnd read get_End;
    ///<summary>
    ///  Gets the Microsoft Word field type.
    ///</summary>
    property &Type: DNFieldType read get_Type;
    ///<summary>
    ///  Gets or sets text that is between the field separator and field end.
    ///</summary>
    property Result: string read get_Result write set_Result;
    ///<summary>
    ///  Gets the text that represents the displayed field result.
    ///</summary>
    ///<remarks>
    ///  The <see cref="M:Aspose.Words.Document.UpdateListLabels" />
    ///  method must be called to obtain correct value for the
    ///<see cref="T:Aspose.Words.Fields.FieldListNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNum" />
    ///  , <see cref="T:Aspose.Words.Fields.FieldAutoNumOut" />
    ///  and <see cref="T:Aspose.Words.Fields.FieldAutoNumLgl" />
    ///  fields.
    ///</remarks>
    property DisplayResult: string read get_DisplayResult;
    ///<summary>
    ///  Gets or sets whether the field is locked (should not recalculate its result).
    ///</summary>
    property IsLocked: Boolean read get_IsLocked write set_IsLocked;
    ///<summary>
    ///  Gets or sets whether the current result of the field is no longer correct (stale) due to other modifications made to the document.
    ///</summary>
    property IsDirty: Boolean read get_IsDirty write set_IsDirty;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Words.Fields.FieldFormat" />
    ///  object that provides typed access to field's formatting.
    ///</summary>
    property Format: DNFieldFormat read get_Format;
    ///<summary>
    ///  Gets or sets the LCID of the field.
    ///</summary>
    ///<seealso cref="F:Aspose.Words.Fields.FieldUpdateCultureSource.FieldCode" />
    property LocaleId: Int32 read get_LocaleId write set_LocaleId;
  end;

  TDNFieldInclude = class(TDNGenericImport<DNFieldIncludeClass, DNFieldInclude>) end;

  //-------------namespace: Aspose.Words.Fields----------------
  DNFieldIncludePictureClass = interface(DNFieldClass)
  ['{C8971D1D-6886-51CE-B14B-D2CBD3D536B1}']
  { constructors } 

    {class} function init: DNFieldIncludePicture;

  end;

  ///<summary>
  ///  Implements the INCLUDEPICTURE field.
  ///</summary>
  ///<remarks>
  ///  Retrieves a picture and displays it as the field result.
  ///</remarks>
  [DNTypeName('Aspose.Words.Fields.FieldIncludePicture')]
  DNFieldIncludePicture = interface(DNField)
  ['{760A6711-DA64-3951-AB4C-B909361D1E41}']
  { getters & setters } 

    function get_SourceFullName: string;
    procedure set_SourceFullName(value: string);
    function get_GraphicFilter: string;
    procedure set_GraphicFilter(value: string);
    function get_IsLinked: Boolean;
    procedure set_IsLinked(value: Boolean);
    function get_ResizeHorizontally: Boolean;
    procedure set_ResizeHorizontally(value: Boolean);
    function get_ResizeVertically: Boolean;
    procedure set_ResizeVertically(value: Boolean);
    function get_Start: DNFieldStart;
    function get_Separator: DNFieldSeparator;
    function get_End: DNFieldEnd;
    function get_Type: DNFieldType;
    function get_Result: string;
    procedure set_Result(value: string);
    function get_DisplayResult: string;
    function get_IsLocked: Boolean;
    procedure set_IsLocked(value: Boolean);
    function get_IsDirty: Boolean;
    procedure set_IsDirty(value: Boolean);
    function get_Format: DNFieldFormat;
    function get_LocaleId: Int32;
    procedure set_LocaleId(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///  Both field code and field result of child fields are included.
    ///</summary>
    function GetFieldCode: string; overload;
    ///<summary>
    ///  Returns text between field start and field separator (or field end if there is no separator).
    ///</summary>
    ///  <param name="includeChildFieldCodes"><c>True</c> if child field codes should be included.
    ///</param>
    function GetFieldCode(includeChildFieldCodes: Boolean): string; overload;
    ///<summary>
    ///  Removes the field from the document. Returns a node right after the field. If the field's end is the last child
    ///  of its parent node, returns its parent paragraph. If the field is already removed, returns <b>null</b>
    ///  .
    ///</summary>
    function Remove: DNNode;
    ///<summary>
    ///  Performs the field update. Throws if the field is being updated already.
    ///</summary>
    procedure Update; overload;
    ///<summary>
    ///  Performs a field update. Throws if the field is being updated already.
    ///</summary>
    ///  <param name="ignoreMergeFormat">
    ///  If <c>true</c> then direct field result formatting is abandoned, regardless of the MERGEFORMAT switch, otherwise normal update is performed.
    ///</param>
    procedure Update(ignoreMergeFormat: Boolean); overload;
    ///<summary>
    ///  Performs the field unlink.
    ///</summary>
    ///<remarks><para>Replaces the field with its most recent result.</para><para>Some fields, such as XE (Index Entry) fields and SEQ (Sequence) fields, cannot be unlinked.</para></remarks>
    ///<returns><c>True</c> if the field has been unlinked, otherwise <c>false</c>.
    ///</returns>
    function Unlink: Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the location of the picture using an IRI.
    ///</summary>
    property SourceFullName: string read get_SourceFullName write set_SourceFullName;
    ///<summary>
    ///  Gets or sets the name of the filter for the format of the graphic that is to be inserted.
    ///</summary>
    property GraphicFilter: string read get_GraphicFilter write set_GraphicFilter;
    ///<summary>
    ///  Gets or sets whether to reduce the file size by not storing graphics data with the document.
    ///</summary>
    property IsLinked: Boolean read get_IsLinked write set_IsLinked;
    ///<summary>
    ///  Gets or sets whether to resize the picture horizontally from the source.
    ///</summary>
    property ResizeHorizontally: Boolean read get_ResizeHorizontally write set_ResizeHorizontally;
    ///<summary>
    ///  Gets or sets whether to resize the picture vertically from the source.
    ///</summary>
    property ResizeVertically: Boolean rea