//----------------------------------------------------------------------------
//  Aspose.PDF.dll: Aspose.PDF, Version=21.6.0.0, Culture=neutral, PublicKeyToken=f0262d67fe233d63
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Framework: 4.0
//----------------------------------------------------------------------------
//  UnitName: DDN.Aspose.PDF
//  Author: ying32
//----------------------------------------------------------------------------

unit DDN.Aspose.PDF;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDN.mscorlib,
  DDN.System.Drawing,
  DDN.System.Xml,
  DDN.System.Data,
  DDN.System.Web,
  DDN.System;

type

{ enums }

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumeration describes associated files relationship.
  ///</summary>
  [DNTypeName('Aspose.Pdf.AFRelationship')]
  DNAFRelationship = type Integer;
  DNAFRelationshipHelper = record helper for DNAFRelationship
  public const
    ///<summary>
    ///  Source
    ///</summary>
    Source = 0;
    ///<summary>
    ///  Data
    ///</summary>
    Data = 1;
    ///<summary>
    ///  Alternative
    ///</summary>
    Alternative = 2;
    ///<summary>
    ///  Supplement
    ///</summary>
    Supplement = 3;
    ///<summary>
    ///  Unspecified
    ///</summary>
    Unspecified = 4;
    ///<summary>
    ///  EncryptedPayload
    ///</summary>
    EncryptedPayload = 5;
    ///<summary>
    ///  None
    ///</summary>
    None = 6;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  A set of flags specifying various characteristics of the annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.AnnotationFlags')]
  DNAnnotationFlags = type Integer;
  DNAnnotationFlagsHelper = record helper for DNAnnotationFlags
  public const
    ///<summary>
    ///  Default value.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  If set, do not display the annotation if it does not belong to one of the standard annotation types
    ///  and no annotation handler is available. If clear, display such an unknown annotation
    ///  using an appearance stream specified by its appearance dictionary, if any.
    ///</summary>
    Invisible = 1;
    ///<summary>
    ///  If set, do not display or print the annotation or allow it to interact with the user,
    ///  regardless of its annotation type or whether an annotation handler is available.
    ///  In cases where screen space is limited, the ability to hide and show annotations selectively
    ///  can be used in combination with appearance streams to display auxiliary pop-up information
    ///  similar in function to online help systems.
    ///</summary>
    Hidden = 2;
    ///<summary>
    ///  If set, print the annotation when the page is printed. If clear, never print the annotation,
    ///  regardless of whether it is displayed on the screen. This can be useful, for example, for annotations
    ///  representing interactive pushbuttons, which would serve no meaningful purpose on the printed page.
    ///</summary>
    Print = 4;
    ///<summary>
    ///  If set, do not scale the annotation�s appearance to match the magnification of the page.
    ///  The location of the annotation on the page (defined by the upper-left corner of its annotation rectangle)
    ///  remains fixed, regardless of the page magnification.
    ///</summary>
    NoZoom = 8;
    ///<summary>
    ///  If set, do not rotate the annotation�s appearance to match the rotation of the page.
    ///  The upper-left corner of the annotation rectangle remains in a fixed location on the page,
    ///  regardless of the page rotation.
    ///</summary>
    NoRotate = 16;
    ///<summary>
    ///  If set, do not display the annotation on the screen or allow it to interact with the user.
    ///  The annotation may be printed (depending on the setting of the Print flag)
    ///  but should be considered hidden for purposes of on-screen display and user interaction.
    ///</summary>
    NoView = 32;
    ///<summary>
    ///  If set, do not allow the annotation to interact with the user. The annotation may be displayed
    ///  or printed (depending on the settings of the NoView and Print flags) but should not respond to mouse
    ///  clicks or change its appearance in response to mouse motions. This flag is ignored for widget annotations;
    ///  its function is subsumed by the ReadOnly flag of the associated form field.
    ///</summary>
    ReadOnly = 64;
    ///<summary>
    ///  If set, do not allow the annotation to be deleted or its properties (including position and size)
    ///  to be modified by the user. However, this flag does not restrict changes to the annotation�s contents,
    ///  such as the value of a form field.
    ///</summary>
    Locked = 128;
    ///<summary>
    ///  If set, invert the interpretation of the NoView flag for certain events.
    ///  A typical use is to have an annotation that appears only when a mouse cursor is held over it.
    ///</summary>
    ToggleNoView = 256;
    ///<summary>
    ///  If set, do not allow the contents of the annotation to be modified by the user.
    ///  This flag does not restrict deletion of the annotation or changes to other annotation properties,
    ///  such as position and size.
    ///</summary>
    LockedContents = 512;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  The enumeration of states to which the original annotation can be set.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.AnnotationState')]
  DNAnnotationState = type Integer;
  DNAnnotationStateHelper = record helper for DNAnnotationState
  public const
    ///<summary>
    ///  Not defined state.
    ///</summary>
    Undefined = 0;
    ///<summary>
    ///  The annotation has been marked by the user.
    ///</summary>
    Marked = 1;
    ///<summary>
    ///  The annotation has not been marked by the user.
    ///</summary>
    Unmarked = 2;
    ///<summary>
    ///  The user agrees with the change.
    ///</summary>
    Accepted = 3;
    ///<summary>
    ///  The user disagrees with the change.
    ///</summary>
    Rejected = 4;
    ///<summary>
    ///  The change has been cancelled.
    ///</summary>
    Cancelled = 5;
    ///<summary>
    ///  The change has been completed.
    ///</summary>
    Completed = 6;
    ///<summary>
    ///  The user has indicated nothing about the change.
    ///</summary>
    None = 7;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  The state model corresponding to state of annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.AnnotationStateModel')]
  DNAnnotationStateModel = type Integer;
  DNAnnotationStateModelHelper = record helper for DNAnnotationStateModel
  public const
    ///<summary>
    ///  Not defined state model.
    ///</summary>
    Undefined = 0;
    ///<summary>
    ///  The annotation has been marked (or unmarked) by the user.
    ///</summary>
    Marked = 1;
    ///<summary>
    ///  The annotation has been reviewed (accepted, rejected, cancelled, completed, none) by the user.
    ///</summary>
    Review = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumeration of annotation types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.AnnotationType')]
  DNAnnotationType = type Integer;
  DNAnnotationTypeHelper = record helper for DNAnnotationType
  public const
    ///<summary>
    ///  Text annotation type.
    ///</summary>
    Text = 0;
    ///<summary>
    ///  Circle annotation type.
    ///</summary>
    Circle = 1;
    ///<summary>
    ///  Polygon annotation type.
    ///</summary>
    Polygon = 2;
    ///<summary>
    ///  Plyline annotation type.
    ///</summary>
    PolyLine = 3;
    ///<summary>
    ///  Line annotation type.
    ///</summary>
    Line = 4;
    ///<summary>
    ///  Square annotatotion type.
    ///</summary>
    Square = 5;
    ///<summary>
    ///  Free text annotation type.
    ///</summary>
    FreeText = 6;
    ///<summary>
    ///  Highlight annotation type.
    ///</summary>
    Highlight = 7;
    ///<summary>
    ///  Underline annotation type.
    ///</summary>
    Underline = 8;
    ///<summary>
    ///  Squiggle annotation type.
    ///</summary>
    Squiggly = 9;
    ///<summary>
    ///  Strikeout annotation type.
    ///</summary>
    StrikeOut = 10;
    ///<summary>
    ///  Caret annotation type.
    ///</summary>
    Caret = 11;
    ///<summary>
    ///  Ink annotation type.
    ///</summary>
    Ink = 12;
    ///<summary>
    ///  Link annotation type.
    ///</summary>
    Link = 13;
    ///<summary>
    ///  Popup annotation type.
    ///</summary>
    Popup = 14;
    ///<summary>
    ///  File attachment annotation type.
    ///</summary>
    FileAttachment = 15;
    ///<summary>
    ///  Sound annotation type.
    ///</summary>
    Sound = 16;
    ///<summary>
    ///  Movie annotation type.
    ///</summary>
    Movie = 17;
    ///<summary>
    ///  Screen annotation type.
    ///</summary>
    Screen = 18;
    ///<summary>
    ///  Widget annotation type.
    ///</summary>
    Widget = 19;
    ///<summary>
    ///  Watermark annotation type.
    ///</summary>
    Watermark = 20;
    ///<summary>
    ///  Trap network annotation type.
    ///</summary>
    TrapNet = 21;
    ///<summary>
    ///  Printer mark annotation type.
    ///</summary>
    PrinterMark = 22;
    ///<summary>
    ///  Redaction annotation type.
    ///</summary>
    Redaction = 23;
    ///<summary>
    ///  Rubber stamp annotation type.
    ///</summary>
    Stamp = 24;
    ///<summary>
    ///  Rich media annotation type
    ///</summary>
    RichMedia = 25;
    ///<summary>
    ///  Unknown annotation.
    ///</summary>
    Unknown = 26;
    PDF3D = 27;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Describes effect which should be applied to the border of the annotations.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.BorderEffect')]
  DNBorderEffect = type Integer;
  DNBorderEffectHelper = record helper for DNBorderEffect
  public const
    ///<summary>
    ///  No effect.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The border will appear "cloudly".
    ///</summary>
    Cloudy = 1;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Describes style of the annotation border.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.BorderStyle')]
  DNBorderStyle = type Integer;
  DNBorderStyleHelper = record helper for DNBorderStyle
  public const
    ///<summary>
    ///  Solid border.
    ///</summary>
    Solid = 0;
    ///<summary>
    ///  Dashed border.
    ///</summary>
    Dashed = 1;
    ///<summary>
    ///  Bevelled border.
    ///</summary>
    Beveled = 2;
    ///<summary>
    ///  Inset border.
    ///</summary>
    Inset = 3;
    ///<summary>
    ///  Underlined border.
    ///</summary>
    Underline = 4;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Style of line ending of Ink annotation line.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.CapStyle')]
  DNCapStyle = type Integer;
  DNCapStyleHelper = record helper for DNCapStyle
  public const
    ///<summary>
    ///  End is rectangular.
    ///</summary>
    Rectangular = 1;
    ///<summary>
    ///  End is rounded.
    ///</summary>
    Rounded = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumeration of the annotation�s caption positioning.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.CaptionPosition')]
  DNCaptionPosition = type Integer;
  DNCaptionPositionHelper = record helper for DNCaptionPosition
  public const
    ///<summary>
    ///  The caption will be centered inside the line (default value).
    ///</summary>
    Inline_ = 0;
    ///<summary>
    ///  The caption will be on top of the line.
    ///</summary>
    Top = 1;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  A symbol to be associated with the caret.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.CaretSymbol')]
  DNCaretSymbol = type Integer;
  DNCaretSymbolHelper = record helper for DNCaretSymbol
  public const
    ///<summary>
    ///  No symbol should be associated with the caret.
    ///</summary>
    None = 0;
    ///<summary>
    ///  A new paragraph symbol (�) should be associated with the caret.
    ///</summary>
    Paragraph = 1;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the types of explicit destinations.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.ExplicitDestinationType')]
  DNExplicitDestinationType = type Integer;
  DNExplicitDestinationTypeHelper = record helper for DNExplicitDestinationType
  public const
    ///<summary>
    ///  Display the page with the coordinates (left,�top) positioned at the upper-left corner of the window
    ///  and the contents of the page magnified by the factor zoom. A null value for any of the parameters
    ///  left, top, or zoom specifies that the current value of that parameter is to be retained unchanged.
    ///  A zoom value of 0 has the same meaning as a null value.
    ///</summary>
    XYZ = 0;
    ///<summary>
    ///  Display the page with its contents magnified just enough to fit the entire page within the window
    ///  both horizontally and vertically. If the required horizontal and vertical magnification factors are
    ///  different, use the smaller of the two, centering the page within the window in the other dimension.
    ///</summary>
    Fit = 1;
    ///<summary>
    ///  Display the page with the vertical coordinate top positioned at the top edge of the window and
    ///  the contents of the page magnified just enough to fit the entire width of the page within the window.
    ///  A null value for top specifies that the current value of that parameter is to be retained unchanged.
    ///</summary>
    FitH = 2;
    ///<summary>
    ///  Display the page with the horizontal coordinate left positioned at the left edge of the window
    ///  and the contents of the page magnified just enough to fit the entire height of the page within the window.
    ///  A null value for left specifies that the current value of that parameter is to be retained unchanged.
    ///</summary>
    FitV = 3;
    ///<summary>
    ///  Display the page with its contents magnified just enough to fit the rectangle specified by the
    ///  coordinates left, bottom, right, and topentirely within the window both horizontally and vertically.
    ///  If the required horizontal and vertical magnification factors are different, use the smaller of
    ///  the two, centering the rectangle within the window in the other dimension. A null value for any
    ///  of the parameters may result in unpredictable behavior.
    ///</summary>
    FitR = 4;
    ///<summary>
    ///  Display the page with its contents magnified just enough to fit its bounding box entirely within
    ///  the window both horizontally and vertically. If the required horizontal and vertical magnification
    ///  factors are different, use the smaller of the two, centering the bounding box within the window
    ///  in the other dimension.
    ///</summary>
    FitB = 5;
    ///<summary>
    ///  Display the page with the vertical coordinate top positioned at the top edge of the window and the
    ///  contents of the page magnified just enough to fit the entire width of its bounding box within the window.
    ///  A null value for top specifies that the current value of that parameter is to be retained unchanged.
    ///</summary>
    FitBH = 6;
    ///<summary>
    ///  Display the page with the horizontal coordinate left positioned at the left edge of the window and the
    ///  contents of the page magnified just enough to fit the entire height of its bounding box within the window.
    ///  A null value for left specifies that the current value of that parameter is to be retained unchanged.
    ///</summary>
    FitBV = 7;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  An icon to be used in displaying the annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FileIcon')]
  DNFileIcon = type Integer;
  DNFileIconHelper = record helper for DNFileIcon
  public const
    ///<summary>
    ///  PushPin icon (default value).
    ///</summary>
    PushPin = 0;
    ///<summary>
    ///  Graph icon.
    ///</summary>
    Graph = 1;
    ///<summary>
    ///  Paperclip icon.
    ///</summary>
    Paperclip = 2;
    ///<summary>
    ///  This is tag icon.
    ///</summary>
    Tag = 3;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the intents of the free text annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FreeTextIntent')]
  DNFreeTextIntent = type Integer;
  DNFreeTextIntentHelper = record helper for DNFreeTextIntent
  public const
    ///<summary>
    ///  Not defined state.
    ///</summary>
    Undefined = 0;
    ///<summary>
    ///  Means that the annotation is intended to function as a callout.
    ///</summary>
    FreeTextCallout = 1;
    ///<summary>
    ///  Means that the annotation is intended to function as a click-to-type or typewriter object.
    ///</summary>
    FreeTextTypeWriter = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the annotation�s highlighting mode, the visual effect to be used when the mouse button is pressed or held down inside its active area.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.HighlightingMode')]
  DNHighlightingMode = type Integer;
  DNHighlightingModeHelper = record helper for DNHighlightingMode
  public const
    ///<summary>
    ///  No highlighting.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Invert the contents of the annotation rectangle.
    ///</summary>
    Invert = 1;
    ///<summary>
    ///  Invert the annotation�s border.
    ///</summary>
    Outline = 2;
    ///<summary>
    ///  Display the annotation�s down appearance, if any. If no down appearance is defined, offset the contents of the annotation rectangle to appear as if it were being pushed below the surface of the page.
    ///</summary>
    Push = 3;
    ///<summary>
    ///  Same as Push (which is preferred).
    ///</summary>
    Toggle = 4;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the forms of quadding (justification) to be used in displaying the annotation�s text.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Justification')]
  DNJustification = type Integer;
  DNJustificationHelper = record helper for DNJustification
  public const
    ///<summary>
    ///  Left justification.
    ///</summary>
    Left = 0;
    ///<summary>
    ///  Center justification.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Right justification.
    ///</summary>
    Right = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the operations to perform with document during launch action executing.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.LaunchActionOperation')]
  DNLaunchActionOperation = type Integer;
  DNLaunchActionOperationHelper = record helper for DNLaunchActionOperation
  public const
    ///<summary>
    ///  Undefined state.
    ///</summary>
    Undefined = 0;
    ///<summary>
    ///  Open a document.
    ///</summary>
    Open = 1;
    ///<summary>
    ///  Print a document.
    ///</summary>
    Print = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enum LightingSchemeType: set of lighting scheme types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.LightingSchemeType')]
  DNLightingSchemeType = type Integer;
  DNLightingSchemeTypeHelper = record helper for DNLightingSchemeType
  public const
    ///<summary>
    ///  The "Artwork" lighting scheme.
    ///</summary>
    Artwork = 0;
    ///<summary>
    ///  The "None" lighting scheme.
    ///</summary>
    None = 1;
    ///<summary>
    ///  The "White" lighting scheme.
    ///</summary>
    White = 2;
    ///<summary>
    ///  The "Day" lighting scheme.
    ///</summary>
    Day = 3;
    ///<summary>
    ///  The "Night" lighting scheme.
    ///</summary>
    Night = 4;
    ///<summary>
    ///  The "Hard" lighting scheme.
    ///</summary>
    Hard = 5;
    ///<summary>
    ///  The "Primary" lighting scheme.
    ///</summary>
    Primary = 6;
    ///<summary>
    ///  The "Blue" lighting scheme.
    ///</summary>
    Blue = 7;
    ///<summary>
    ///  The "Red" lighting scheme.
    ///</summary>
    Red = 8;
    ///<summary>
    ///  The "Cube" lighting scheme.
    ///</summary>
    Cube = 9;
    ///<summary>
    ///  The "Cad" lighting scheme.
    ///</summary>
    CAD = 10;
    ///<summary>
    ///  The "Headlamp" lighting scheme.
    ///</summary>
    Headlamp = 11;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the line ending styles to be used in drawing the line.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.LineEnding')]
  DNLineEnding = type Integer;
  DNLineEndingHelper = record helper for DNLineEnding
  public const
    ///<summary>
    ///  No line ending.
    ///</summary>
    None = 0;
    ///<summary>
    ///  A square filled with the annotation�s interior color, if any.
    ///</summary>
    Square = 1;
    ///<summary>
    ///  A circle filled with the annotation�s interior color, if any.
    ///</summary>
    Circle = 2;
    ///<summary>
    ///  A diamond shape filled with the annotation�s interior color, if any.
    ///</summary>
    Diamond = 3;
    ///<summary>
    ///  Two short lines meeting in an acute angle to form an open arrowhead.
    ///</summary>
    OpenArrow = 4;
    ///<summary>
    ///  Two short lines meeting in an acute angle as in the OpenArrow style and connected by a third line to form a triangular closed arrowhead filled with the annotation�s interior color, if any.
    ///</summary>
    ClosedArrow = 5;
    ///<summary>
    ///  A short line at the endpoint perpendicular to the line itself.
    ///</summary>
    Butt = 6;
    ///<summary>
    ///  Two short lines in the reverse direction from OpenArrow.
    ///</summary>
    ROpenArrow = 7;
    ///<summary>
    ///  A triangular closed arrowhead in the reverse direction from ClosedArrow.
    ///</summary>
    RClosedArrow = 8;
    ///<summary>
    ///  A short line at the endpoint approximately 30 degrees clockwise from perpendicular to the line itself.
    ///</summary>
    Slash = 9;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the intents of the line annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.LineIntent')]
  DNLineIntent = type Integer;
  DNLineIntentHelper = record helper for DNLineIntent
  public const
    ///<summary>
    ///  Undefined state.
    ///</summary>
    Undefined = 0;
    ///<summary>
    ///  Means that the annotation is intended to function as an arrow.
    ///</summary>
    LineArrow = 1;
    ///<summary>
    ///  Means that the annotation is intended to function as a dimension line.
    ///</summary>
    LineDimension = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Value which indicates in which manner fraction values are displayed.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Measure+NumberFormat+FractionStyle')]
  DNMeasure_NumberFormat_FractionStyle = type Integer;
  DNMeasure_NumberFormat_FractionStyleHelper = record helper for DNMeasure_NumberFormat_FractionStyle
  public const
    ///<summary>
    ///  Show fractional values as decimal fraction.
    ///</summary>
    ShowAsDecimal = 0;
    ///<summary>
    ///  Show fractional value as fraction.
    ///</summary>
    ShowAsFraction = 1;
    ///<summary>
    ///  Round fractional values to the nearest whole integer.
    ///</summary>
    Round = 2;
    ///<summary>
    ///  Truncate to achieve whole units.
    ///</summary>
    Truncate = 3;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enum PDF3DActivation: set of 3D annotation activation mode.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DActivation')]
  DNPDF3DActivation = type Integer;
  DNPDF3DActivationHelper = record helper for DNPDF3DActivation
  public const
    ///<summary>
    ///  The active when open
    ///</summary>
    activeWhenOpen = 0;
    ///<summary>
    ///  The active when visible
    ///</summary>
    activeWhenVisible = 1;
    ///<summary>
    ///  The activated by user or script action
    ///</summary>
    activatedUserOrScriptAction = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the intents of the polygon or polyline annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PolyIntent')]
  DNPolyIntent = type Integer;
  DNPolyIntentHelper = record helper for DNPolyIntent
  public const
    ///<summary>
    ///  Undefined state.
    ///</summary>
    Undefined = 0;
    ///<summary>
    ///  Means that the annotation is intended to function as a cloud object.
    ///</summary>
    PolygonCloud = 1;
    ///<summary>
    ///  Indicates that the polyline annotation is intended to function as a dimension.
    ///</summary>
    PolyLineDimension = 2;
    ///<summary>
    ///  Indicates that the polygon annotation is intended to function as a dimension.
    ///</summary>
    PolygonDimension = 3;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Defines different actions which can be triggered from a PDF file.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PredefinedAction')]
  DNPredefinedAction = type Integer;
  DNPredefinedActionHelper = record helper for DNPredefinedAction
  public const
    ///<summary>
    ///  A named action to go to the first page.
    ///</summary>
    FirstPage = 0;
    ///<summary>
    ///  A named action to go to the last page.
    ///</summary>
    LastPage = 1;
    ///<summary>
    ///  A named action to go to the next page.
    ///</summary>
    NextPage = 2;
    ///<summary>
    ///  A named action to go to the previous page.
    ///</summary>
    PrevPage = 3;
    ///<summary>
    ///  A named action to open a print dialog (JavaScript).
    ///</summary>
    PrintDialog = 4;
    ///<summary>
    ///  A named action to open a print dialog.
    ///</summary>
    Print = 5;
    ///<summary>
    ///  A named action to find current bookmark.
    ///</summary>
    Bookmarks_ExpanCurrentBookmark = 6;
    ///<summary>
    ///  A named action to highlight current bookmark.
    ///</summary>
    Bookmarks_HightlightCurrentBookmark = 7;
    ///<summary>
    ///  A named action to add file attachment.
    ///</summary>
    Document_AttachFile = 8;
    ///<summary>
    ///  A named action to crop document pages.
    ///</summary>
    Document_CropPages = 9;
    ///<summary>
    ///  A named action to delete document pages.
    ///</summary>
    Document_DeletePages = 10;
    ///<summary>
    ///  A named action to exctract document pages.
    ///</summary>
    Document_ExtractPages = 11;
    ///<summary>
    ///  A named action to insert pages from a document.
    ///</summary>
    Document_InsertPages = 12;
    ///<summary>
    ///  A named action to replace document pages.
    ///</summary>
    Document_ReplacePages = 13;
    ///<summary>
    ///  A named action to rotate document pages.
    ///</summary>
    Document_RotatePages = 14;
    ///<summary>
    ///  A named action to check spelling in comments.
    ///</summary>
    Edit_CheckSpelling_InComFieldEdit = 15;
    ///<summary>
    ///  A named action to find.
    ///</summary>
    Edit_Find = 16;
    ///<summary>
    ///  A named action to edit preferences.
    ///</summary>
    Edit_Preferences = 17;
    ///<summary>
    ///  A named action for searching.
    ///</summary>
    Edit_Search = 18;
    ///<summary>
    ///  A named action for attaching current pdf document into email message.
    ///</summary>
    File_AttachToEmail = 19;
    ///<summary>
    ///  A named action to close the document.
    ///</summary>
    File_Close = 20;
    ///<summary>
    ///  A named action to create pdf document from scanner.
    ///</summary>
    File_CreatePDF_FromScanner = 21;
    ///<summary>
    ///  A named action to create pdf document from web page.
    ///</summary>
    File_CreatePDF_FromWebPage = 22;
    ///<summary>
    ///  A named action to exit pdf reader.
    ///</summary>
    File_Exit = 23;
    ///<summary>
    ///  A named action to open organizer.
    ///</summary>
    File_Organizer_OpenOrganizer = 24;
    ///<summary>
    ///  A named action to print the document.
    ///</summary>
    File_Print = 25;
    ///<summary>
    ///  A named action to open the document properties.
    ///</summary>
    File_Properties = 26;
    ///<summary>
    ///  A named action to save the document with another name.
    ///</summary>
    File_SaveAs = 27;
    ///<summary>
    ///  A named action to zoom in the document.
    ///</summary>
    Miscellaneous_ZoomIn = 28;
    ///<summary>
    ///  A named action to zoom out the document.
    ///</summary>
    Miscellaneous_ZoomOut = 29;
    ///<summary>
    ///  A named action to print the document pages.
    ///</summary>
    PageImages_PrintPages = 30;
    ///<summary>
    ///  A named action to go to the next view.
    ///</summary>
    View_GoTo_NextView = 31;
    ///<summary>
    ///  A named action to go to the certain page.
    ///</summary>
    View_GoTo_Page = 32;
    ///<summary>
    ///  A named action to go to the previous document.
    ///</summary>
    View_GoTo_PreDocument = 33;
    ///<summary>
    ///  A named action to go to the previous view.
    ///</summary>
    View_GoTo_PreView = 34;
    ///<summary>
    ///  A named action to show/hide articles panel.
    ///</summary>
    View_NavigationPanels_Articles = 35;
    ///<summary>
    ///  A named action to show/hide attachment panel.
    ///</summary>
    View_NavigationPanels_Attachments = 36;
    ///<summary>
    ///  A named action to show/hide bookmark panel.
    ///</summary>
    View_NavigationPanels_Boomarks = 37;
    ///<summary>
    ///  A named action to show/hide comments panel.
    ///</summary>
    View_NavigationPanels_Comments = 38;
    ///<summary>
    ///  A named action to show/hide fields panel.
    ///</summary>
    View_NavigationPanels_Fields = 39;
    ///<summary>
    ///  A named action to show/hide layers panel.
    ///</summary>
    View_NavigationPanels_Layers = 40;
    ///<summary>
    ///  A named action to show/hide model tree panel.
    ///</summary>
    View_NavigationPanels_ModelTree = 41;
    ///<summary>
    ///  A named action to show/hide pages panel.
    ///</summary>
    View_NavigationPanels_Pages = 42;
    ///<summary>
    ///  A named action to show/hide signatures panel.
    ///</summary>
    View_NavigationPanels_Signatures = 43;
    ///<summary>
    ///  A named action to display single page.
    ///</summary>
    View_PageDisplay_SinglePage = 44;
    ///<summary>
    ///  A named action to display single continious page.
    ///</summary>
    View_PageDisplay_SinglePageContinuous = 45;
    ///<summary>
    ///  A named action to display pages as Two-Up.
    ///</summary>
    View_PageDisplay_TwoUp = 46;
    ///<summary>
    ///  A named action to display pages as Two-Up continious.
    ///</summary>
    View_PageDisplay_TwoUpContinuous = 47;
    ///<summary>
    ///  A named action to show/hide advanced editing toolbar.
    ///</summary>
    View_Toolbars_AdvanceEditing = 48;
    ///<summary>
    ///  A named action to show/hide commenting toolbar.
    ///</summary>
    View_Toolbars_CommentMarkup = 49;
    ///<summary>
    ///  A named action to show/hide edit toolbar.
    ///</summary>
    View_Toolbars_Edit = 50;
    ///<summary>
    ///  A named action to show/hide file toolbar.
    ///</summary>
    View_Toolbars_File = 51;
    ///<summary>
    ///  A named action to show/hide find toolbar.
    ///</summary>
    View_Toolbars_Find = 52;
    ///<summary>
    ///  A named action to show/hide forms toolbar.
    ///</summary>
    View_Toolbars_Forms = 53;
    ///<summary>
    ///  A named action to show/hide measuring toolbar.
    ///</summary>
    View_Toolbars_Measuring = 54;
    ///<summary>
    ///  A named action to show/hide object data toolbar.
    ///</summary>
    View_Toolbars_ObjectData = 55;
    ///<summary>
    ///  A named action to show/hide page display toolbar.
    ///</summary>
    View_Toolbars_PageDisplay = 56;
    ///<summary>
    ///  A named action to show/hide navigation toolbar.
    ///</summary>
    View_Toolbars_PageNavigation = 57;
    ///<summary>
    ///  A named action to show/hide print production toolbar.
    ///</summary>
    View_Toolbars_PrintProduction = 58;
    ///<summary>
    ///  A named action to show/hide property toolbar.
    ///</summary>
    View_Toolbars_PropertiesBar = 59;
    ///<summary>
    ///  A named action to show/hide redaction toolbar.
    ///</summary>
    View_Toolbars_Redaction = 60;
    ///<summary>
    ///  A named action to show/hide select &amp; zoom toolbar.
    ///</summary>
    View_Toolbars_SelectZoom = 61;
    ///<summary>
    ///  A named action to show/hide tasks toolbar.
    ///</summary>
    View_Toolbars_Tasks = 62;
    ///<summary>
    ///  A named action to show/hide typewriter toolbar.
    ///</summary>
    View_Toolbars_Typewriter = 63;
    ///<summary>
    ///  A named action to view pages in actual size.
    ///</summary>
    View_Zoom_ActualSize = 64;
    ///<summary>
    ///  A named action to fit page on height.
    ///</summary>
    View_Zoom_FitHeight = 65;
    ///<summary>
    ///  A named action to fit page.
    ///</summary>
    View_Zoom_FitPage = 66;
    ///<summary>
    ///  A named action to fit page visibility.
    ///</summary>
    View_Zoom_FitVisible = 67;
    ///<summary>
    ///  A named action to fit page on width.
    ///</summary>
    View_Zoom_FitWidth = 68;
    ///<summary>
    ///  A named action to make zoom.
    ///</summary>
    View_Zoom_ZoomTo = 69;
    ///<summary>
    ///  A named action to view the document in the full screen mode.
    ///</summary>
    Window_FullScreenMode = 70;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enum RenderModeType: set of render mode types
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.RenderModeType')]
  DNRenderModeType = type Integer;
  DNRenderModeTypeHelper = record helper for DNRenderModeType
  public const
    ///<summary>
    ///  The "Solid" render mode.
    ///</summary>
    Solid = 0;
    ///<summary>
    ///  The "SolidWireFrame" render mode.
    ///</summary>
    SolidWireframe = 1;
    ///<summary>
    ///  The "Transparent" render mode.
    ///</summary>
    Transparent = 2;
    ///<summary>
    ///  The "TransparentWareFrame" render mode.
    ///</summary>
    TransparentWareFrame = 3;
    ///<summary>
    ///  The "BoundingBox" render mode.
    ///</summary>
    BoundingBox = 4;
    ///<summary>
    ///  The "TransparentBoundingBox" render mode.
    ///</summary>
    TransparentBoundingBox = 5;
    ///<summary>
    ///  The "TransparentBoundingBoxOutline" render mode.
    ///</summary>
    TransparentBoundingBoxOutline = 6;
    ///<summary>
    ///  The "WireFrame" render mode.
    ///</summary>
    Wireframe = 7;
    ///<summary>
    ///  The "ShadedWireFrame" render mode.
    ///</summary>
    ShadedWireframe = 8;
    ///<summary>
    ///  The "Vertices" render mode.
    ///</summary>
    Vertices = 9;
    ///<summary>
    ///  The "ShadedVertices" render mode.
    ///</summary>
    ShadedVertices = 10;
    ///<summary>
    ///  The "Illustration" render mode.
    ///</summary>
    Illustration = 11;
    ///<summary>
    ///  The "SolidOutline" render mode.
    ///</summary>
    SolidOutline = 12;
    ///<summary>
    ///  The "ShadedIllustration" render mode.
    ///</summary>
    ShadedIllustration = 13;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  The operation to perform when the action is triggered.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.RenditionOperation')]
  DNRenditionOperation = type Integer;
  DNRenditionOperationHelper = record helper for DNRenditionOperation
  public const
    ///<summary>
    ///  If no rendition is associated with the annotation, play the specified rendition, associating it with the annotation. If a rendition is already associated with the annotation, it shall be stopped, and the new rendition shall be associated with the annotation.
    ///</summary>
    PlayStop = 0;
    ///<summary>
    ///  Stop any rendition being played in association with the annotation.
    ///</summary>
    Stop = 1;
    ///<summary>
    ///  Pause any rendition being played in association with the annotation.
    ///</summary>
    Pause = 2;
    ///<summary>
    ///  Resume any rendition being played in association with the annotation.
    ///</summary>
    Resume = 3;
    ///<summary>
    ///  Play the specified rendition, associating it with the annotation. If a rendition is already associated with the annotation, resume the rendition if it is paused.
    ///</summary>
    PlayResume = 4;
    ///<summary>
    ///  Operation not defined.
    ///</summary>
    Undefined = -1;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumeration describes possible types of Rendition.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.RenditionType')]
  DNRenditionType = type Integer;
  DNRenditionTypeHelper = record helper for DNRenditionType
  public const
    ///<summary>
    ///  Media rendition object.
    ///</summary>
    Media = 0;
    ///<summary>
    ///  Selector rendition object.
    ///</summary>
    Selector = 1;
    ///<summary>
    ///  Rendition type is undefined.
    ///</summary>
    Undefined = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the kinds of the relationships (the “reply type”) between the annotation and one specified by InReplyTo.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.ReplyType')]
  DNReplyType = type Integer;
  DNReplyTypeHelper = record helper for DNReplyType
  public const
    ///<summary>
    ///  Undefined relationship.
    ///</summary>
    Undefined = 0;
    ///<summary>
    ///  The annotation is considered a reply to the annotation specified by InReplyTo. Viewer applications should not display replies to an annotation individually but together in the form of threaded comments.
    ///</summary>
    Reply = 1;
    ///<summary>
    ///  The annotation is grouped with the annotation specified by InReplyTo.
    ///</summary>
    Group = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Event which activates annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.RichMediaAnnotation+ActivationEvent')]
  DNRichMediaAnnotation_ActivationEvent = type Integer;
  DNRichMediaAnnotation_ActivationEventHelper = record helper for DNRichMediaAnnotation_ActivationEvent
  public const
    ///<summary>
    ///  Activated by click on the annotation.
    ///</summary>
    Click = 0;
    ///<summary>
    ///  Activated on page open.
    ///</summary>
    PageOpen = 1;
    ///<summary>
    ///  Activated when page becames visible.
    ///</summary>
    PageVisible = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Type of the multimedia.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.RichMediaAnnotation+ContentType')]
  DNRichMediaAnnotation_ContentType = type Integer;
  DNRichMediaAnnotation_ContentTypeHelper = record helper for DNRichMediaAnnotation_ContentType
  public const
    ///<summary>
    ///  Audio data.
    ///</summary>
    Audio = 0;
    ///<summary>
    ///  Video data.
    ///</summary>
    Video = 1;
    ///<summary>
    ///  Unknown/unsupported type of data.
    ///</summary>
    Unknown = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  The encoding format for the sample data.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SoundEncoding')]
  DNSoundEncoding = type Integer;
  DNSoundEncodingHelper = record helper for DNSoundEncoding
  public const
    ///<summary>
    ///  Unspecified or unsigned values in the range 0 to 2^bits − 1.
    ///</summary>
    Raw = 0;
    ///<summary>
    ///  Twos-complement values.
    ///</summary>
    Signed = 1;
    ///<summary>
    ///  μ-law–encoded samples.
    ///</summary>
    MuLaw = 2;
    ///<summary>
    ///  A-law–encoded samples.
    ///</summary>
    ALaw = 3;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the icons to be used in displaying the annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SoundIcon')]
  DNSoundIcon = type Integer;
  DNSoundIconHelper = record helper for DNSoundIcon
  public const
    ///<summary>
    ///  Speaker icon.
    ///</summary>
    Speaker = 0;
    ///<summary>
    ///  Microphone icon.
    ///</summary>
    Mic = 1;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  The encoding format for the sound sample data.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SoundSampleDataEncodingFormat')]
  DNSoundSampleDataEncodingFormat = type Integer;
  DNSoundSampleDataEncodingFormatHelper = record helper for DNSoundSampleDataEncodingFormat
  public const
    ///<summary>
    ///  Unspecified or unsigned values in the range 0 to 2B − 1.
    ///</summary>
    Raw = 0;
    ///<summary>
    ///  Twos-complement values.
    ///</summary>
    Signed = 1;
    ///<summary>
    ///  μ-law–encoded samples.
    ///</summary>
    muLaw = 2;
    ///<summary>
    ///  A-law–encoded samples.
    ///</summary>
    ALaw = 3;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the icons to be used in displaying the annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.StampIcon')]
  DNStampIcon = type Integer;
  DNStampIconHelper = record helper for DNStampIcon
  public const
    ///<summary>
    ///  Draft stamp icon.
    ///</summary>
    Draft = 0;
    ///<summary>
    ///  Approved stamp icon.
    ///</summary>
    Approved = 1;
    ///<summary>
    ///  Experimental stamp icon.
    ///</summary>
    Experimental = 2;
    ///<summary>
    ///  Stamp icon is not approved.
    ///</summary>
    NotApproved = 3;
    ///<summary>
    ///  Stamp icon "as is".
    ///</summary>
    AsIs = 4;
    ///<summary>
    ///  Stamp icon is expired.
    ///</summary>
    Expired = 5;
    ///<summary>
    ///  Not for public release.
    ///</summary>
    NotForPublicRelease = 6;
    ///<summary>
    ///  Confidential.
    ///</summary>
    Confidential = 7;
    ///<summary>
    ///  Final stamp.
    ///</summary>
    Final_ = 8;
    ///<summary>
    ///  Sold   stamp.
    ///</summary>
    Sold = 9;
    ///<summary>
    ///  Departamental.
    ///</summary>
    Departmental = 10;
    ///<summary>
    ///  For comment.
    ///</summary>
    ForComment = 11;
    ///<summary>
    ///  For public release.
    ///</summary>
    ForPublicRelease = 12;
    ///<summary>
    ///  Top secret.
    ///</summary>
    TopSecret = 13;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Alignment of text in annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.TextAlignment')]
  DNTextAlignment = type Integer;
  DNTextAlignmentHelper = record helper for DNTextAlignment
  public const
    ///<summary>
    ///  Text is aligned to left.
    ///</summary>
    Left = 0;
    ///<summary>
    ///  Text is centered.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Text is aligned to right.
    ///</summary>
    Right = 2;
  end;


  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Enumerates the icons to be used in displaying the annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.TextIcon')]
  DNTextIcon = type Integer;
  DNTextIconHelper = record helper for DNTextIcon
  public const
    ///<summary>
    ///  Note icon.
    ///</summary>
    Note = 0;
    ///<summary>
    ///  Comment icon.
    ///</summary>
    Comment = 1;
    ///<summary>
    ///  Key    icon.
    ///</summary>
    Key = 2;
    ///<summary>
    ///  Help icon.
    ///</summary>
    Help = 3;
    ///<summary>
    ///  NewParagraph icon.
    ///</summary>
    NewParagraph = 4;
    ///<summary>
    ///  Paragraph icon.
    ///</summary>
    Paragraph = 5;
    ///<summary>
    ///  Insert icon.
    ///</summary>
    Insert = 6;
    ///<summary>
    ///  Check icon.
    ///</summary>
    Check = 7;
    ///<summary>
    ///  Cross icon.
    ///</summary>
    Cross = 8;
    ///<summary>
    ///  Circle icon.
    ///</summary>
    Circle = 9;
    ///<summary>
    ///  Star icon.
    ///</summary>
    Star = 10;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumeration of possible artifacts subtype.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Artifact+ArtifactSubtype')]
  DNArtifact_ArtifactSubtype = type Integer;
  DNArtifact_ArtifactSubtypeHelper = record helper for DNArtifact_ArtifactSubtype
  public const
    ///<summary>
    ///  Header artifact.
    ///</summary>
    Header = 0;
    ///<summary>
    ///  Footer artifact.
    ///</summary>
    Footer = 1;
    ///<summary>
    ///  Watermark artifact.
    ///</summary>
    Watermark = 2;
    ///<summary>
    ///  Background artifact.
    ///</summary>
    Background = 3;
    ///<summary>
    ///  Artifact subtype is not defined or unknown.
    ///</summary>
    Undefined = 4;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumeration of possuble artifact types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Artifact+ArtifactType')]
  DNArtifact_ArtifactType = type Integer;
  DNArtifact_ArtifactTypeHelper = record helper for DNArtifact_ArtifactType
  public const
    ///<summary>
    ///  Pagination artifacts. Ancillary page features such as running heads and folios (page numbers).
    ///</summary>
    Pagination = 0;
    ///<summary>
    ///  Layout artifacts. Purely cosmetic typographical or design elements such as footnote rules or background screens.
    ///</summary>
    Layout = 1;
    ///<summary>
    ///  Page artifacts. Production aids extraneous to the document itself, such as cut marks and colour bars.
    ///</summary>
    Page = 2;
    ///<summary>
    ///  Background artifacts. Images, patterns or coloured blocks.
    ///</summary>
    Background = 3;
    ///<summary>
    ///  Artifact type is not defined or unknown.
    ///</summary>
    Undefined = 4;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  The blend modes enumeration.
  ///</summary>
  [DNTypeName('Aspose.Pdf.BlendMode')]
  DNBlendMode = type Integer;
  DNBlendModeHelper = record helper for DNBlendMode
  public const
    ///<summary>
    ///  Normal blend mode.
    ///</summary>
    Normal = 0;
    ///<summary>
    ///  Multiply blend mode.
    ///</summary>
    Multiply = 1;
    ///<summary>
    ///  Screen blend mode.
    ///</summary>
    Screen = 2;
    ///<summary>
    ///  Overlay blend mode.
    ///</summary>
    Overlay = 3;
    ///<summary>
    ///  Darken blend mode.
    ///</summary>
    Darken = 4;
    ///<summary>
    ///  Lighten blend mode.
    ///</summary>
    Lighten = 5;
    ///<summary>
    ///  ColorDodge blend mode.
    ///</summary>
    ColorDodge = 6;
    ///<summary>
    ///  ColorBurn blend mode.
    ///</summary>
    ColorBurn = 7;
    ///<summary>
    ///  HardLight blend mode.
    ///</summary>
    HardLight = 8;
    ///<summary>
    ///  SoftLight blend mode.
    ///</summary>
    SoftLight = 9;
    ///<summary>
    ///  Difference blend mode.
    ///</summary>
    Difference = 10;
    ///<summary>
    ///  Exclusion blend mode.
    ///</summary>
    Exclusion = 11;
    ///<summary>
    ///  Hue blend mode.
    ///</summary>
    Hue = 12;
    ///<summary>
    ///  Saturation blend mode.
    ///</summary>
    Saturation = 13;
    ///<summary>
    ///  Color blend mode.
    ///</summary>
    Color = 14;
    ///<summary>
    ///  Luminosity blend mode.
    ///</summary>
    Luminosity = 15;
    ///<summary>
    ///  Compatible blend mode.
    ///</summary>
    Compatible = 16;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates the border corner styles for border.
  ///</summary>
  [DNTypeName('Aspose.Pdf.BorderCornerStyle')]
  DNBorderCornerStyle = type Integer;
  DNBorderCornerStyleHelper = record helper for DNBorderCornerStyle
  public const
    ///<summary>
    ///  None border style.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Round border style.
    ///</summary>
    Round = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates the border sides.
  ///</summary>
  [DNTypeName('Aspose.Pdf.BorderSide')]
  DNBorderSide = type Integer;
  DNBorderSideHelper = record helper for DNBorderSide
  public const
    ///<summary>
    ///  No border.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Left border.
    ///</summary>
    Left = 1;
    ///<summary>
    ///  Top border.
    ///</summary>
    Top = 2;
    ///<summary>
    ///  Right border.
    ///</summary>
    Right = 4;
    ///<summary>
    ///  Bottom border.
    ///</summary>
    Bottom = 8;
    ///<summary>
    ///  All sides borders.It has the same meaning when useing "Box" and will be replaced by "Box" one year later. So, please use "Box" if possible.
    ///</summary>
    All = 15;
    ///<summary>
    ///  Four sides borders.
    ///</summary>
    Box = 15;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  The color spaces enumeration.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ColorSpace')]
  DNColorSpace = type Integer;
  DNColorSpaceHelper = record helper for DNColorSpace
  public const
    ///<summary>
    ///  The device-dependent RGB color space.
    ///</summary>
    DeviceRGB = 0;
    ///<summary>
    ///  The device-dependent CMYK color space.
    ///</summary>
    DeviceCMYK = 1;
    ///<summary>
    ///  The device-dependent gray color space.
    ///</summary>
    DeviceGray = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Specifies color type of elements on page.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ColorType')]
  DNColorType = type Integer;
  DNColorTypeHelper = record helper for DNColorType
  public const
    ///<summary>
    ///  RGB color type.
    ///</summary>
    Rgb = 0;
    ///<summary>
    ///  Grayscale color type.
    ///</summary>
    Grayscale = 1;
    ///<summary>
    ///  Black and white color type.
    ///</summary>
    BlackAndWhite = 2;
    ///<summary>
    ///  Undefined color type value.
    ///</summary>
    Undefined = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates column adjustment types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ColumnAdjustment')]
  DNColumnAdjustment = type Integer;
  DNColumnAdjustmentHelper = record helper for DNColumnAdjustment
  public const
    ///<summary>
    ///  Customized.
    ///</summary>
    Customized = 0;
    ///<summary>
    ///  Auto fit to content.
    ///</summary>
    AutoFitToContent = 1;
    ///<summary>
    ///  Auto fit to window.
    ///</summary>
    AutoFitToWindow = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  MIME protocol Content-Disposition header.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ContentDisposition')]
  DNContentDisposition = type Integer;
  DNContentDispositionHelper = record helper for DNContentDisposition
  public const
    ///<summary>
    ///  Result is shown inline.
    ///</summary>
    Inline_ = 0;
    ///<summary>
    ///  Result is saved as attachment.
    ///</summary>
    Attachment = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This class represents action for conversion errors.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ConvertErrorAction')]
  DNConvertErrorAction = type Integer;
  DNConvertErrorActionHelper = record helper for DNConvertErrorAction
  public const
    ///  Delete convert errors
    Delete = 0;
    ///  Do nothing with convert errors
    None = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This action represents actions for conversion of images with soft mask.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ConvertSoftMaskAction')]
  DNConvertSoftMaskAction = type Integer;
  DNConvertSoftMaskActionHelper = record helper for DNConvertSoftMaskAction
  public const
    ///<summary>
    ///  Use default strategy.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Soft mask will be converted into stencil mask.
    ///</summary>
    ConvertToStencilMask = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This class represents action for conversion of transparency.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ConvertTransparencyAction')]
  DNConvertTransparencyAction = type Integer;
  DNConvertTransparencyActionHelper = record helper for DNConvertTransparencyAction
  public const
    ///<summary>
    ///  Use default strategy, no adding masks.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Add transparent mask image.
    ///</summary>
    Mask = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Represent type of cryptographic algorithm that used in encryption/decryption routines.
  ///</summary>
  [DNTypeName('Aspose.Pdf.CryptoAlgorithm')]
  DNCryptoAlgorithm = type Integer;
  DNCryptoAlgorithmHelper = record helper for DNCryptoAlgorithm
  public const
    ///<summary>
    ///  RC4 with key length 40.
    ///</summary>
    RC4x40 = 0;
    ///<summary>
    ///  RC4 with key length 128.
    ///</summary>
    RC4x128 = 1;
    ///<summary>
    ///  AES with key length 128.
    ///</summary>
    AESx128 = 2;
    ///<summary>
    ///  AES with key length 256.
    ///</summary>
    AESx256 = 3;
  end;


  //-------------namespace: Aspose.Pdf.Devices----------------
  ///<summary>
  ///  Used to specify the parameter value passed to a Tiff image device.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Devices.ColorDepth')]
  DNColorDepth = type Integer;
  DNColorDepthHelper = record helper for DNColorDepth
  public const
    ///<summary>
    ///  Default color depth.
    ///  32 bit depth is used by default.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  8 bits per pixel. Equal <see cref="F:System.Drawing.Imaging.PixelFormat.Format8bppIndexed" />
    ///</summary>
    Format8bpp = 1;
    ///<summary>
    ///  4 bits per pixel. Equal <see cref="F:System.Drawing.Imaging.PixelFormat.Format4bppIndexed" />
    ///</summary>
    Format4bpp = 2;
    ///<summary>
    ///  1 bit per pixel. Equal <see cref="F:System.Drawing.Imaging.PixelFormat.Format32bppRgb" />
    ///</summary>
    Format1bpp = 3;
  end;


  //-------------namespace: Aspose.Pdf.Devices----------------
  ///<summary>
  ///  Used to specify the parameter value passed to a Tiff image device.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Devices.CompressionType')]
  DNCompressionType = type Integer;
  DNCompressionTypeHelper = record helper for DNCompressionType
  public const
    ///<summary>
    ///  Specifies the LZW compression scheme. Can be passed to the Tiff encoder as a parameter that belongs to the Compression category.
    ///</summary>
    LZW = 0;
    ///<summary>
    ///  Specifies the CCITT4 compression scheme. Can be passed to the CCITT4 encoder as a parameter that belongs to the Compression category.
    ///</summary>
    CCITT4 = 1;
    ///<summary>
    ///  Specifies the CCITT3 compression scheme. Can be passed to the CCITT3 encoder as a parameter that belongs to the Compression category.
    ///</summary>
    CCITT3 = 2;
    ///<summary>
    ///  Specifies the RLE compression scheme. Can be passed to the RLE encoder as a parameter that belongs to the Compression category.
    ///</summary>
    RLE = 3;
    ///<summary>
    ///  Specifies no compression. Can be passed to the Tiff encoder as a parameter that belongs to the compression category.
    ///</summary>
    None = 4;
  end;


  //-------------namespace: Aspose.Pdf.Devices----------------
  ///<summary>
  ///  Used to specify the form presentation mode when printing or converting to image pdf documents.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Devices.FormPresentationMode')]
  DNFormPresentationMode = type Integer;
  DNFormPresentationModeHelper = record helper for DNFormPresentationMode
  public const
    ///<summary>
    ///  Specifies Production form presentation mode (used by default).
    ///</summary>
    Production = 0;
    ///<summary>
    ///  Specifies Editor form presentation mode.
    ///</summary>
    ///<remarks>
    ///  The Editor mode is used by some products to display forms.
    ///  In Editor mode some form elements are displayed as they are shown in form designer.
    ///</remarks>
    Editor = 1;
  end;


  //-------------namespace: Aspose.Pdf.Devices----------------
  ///<summary>
  ///  This enum represents shape type for the extracted images.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Devices.ShapeType')]
  DNShapeType = type Integer;
  DNShapeTypeHelper = record helper for DNShapeType
  public const
    ///<summary>
    ///  Original image shape.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Landscape Shape.
    ///</summary>
    Landscape = 1;
    ///<summary>
    ///  Portrait Shape.
    ///</summary>
    Portrait = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Text direction.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Direction')]
  DNDirection = type Integer;
  DNDirectionHelper = record helper for DNDirection
  public const
    ///<summary>
    ///  Left to right direction.
    ///</summary>
    L2R = 0;
    ///<summary>
    ///  Right to left direction.
    ///</summary>
    R2L = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Allows to specify .doc or .docx file format.
  ///</summary>
  [DNTypeName('Aspose.Pdf.DocSaveOptions+DocFormat')]
  DNDocSaveOptions_DocFormat = type Integer;
  DNDocSaveOptions_DocFormatHelper = record helper for DNDocSaveOptions_DocFormat
  public const
    ///<summary>
    ///  [MS-DOC]: Word (.doc) Binary File Format
    ///</summary>
    Doc = 0;
    ///<summary>
    ///  Office Open XML (.docx) File Format
    ///</summary>
    DocX = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Allows to control how a PDF document is converted into a word processing document.
  ///</summary>
  ///<remarks><para>Use the <see cref="F:Aspose.Pdf.DocSaveOptions.RecognitionMode.Textbox" />
  ///  mode when the resulting document is not goining
  ///  to be heavily edited futher. Textboxes are easy to modify when there is not a lot to do.</para><para>Use the <see cref="F:Aspose.Pdf.DocSaveOptions.RecognitionMode.Flow" />
  ///  mode when the output document needs further editing.
  ///  Paragraphs and texlines in the flow mode allow easy modification of text, but unupported
  ///  formatting objects will look worse than in the <see cref="F:Aspose.Pdf.DocSaveOptions.RecognitionMode.Textbox" />
  ///  mode.</para></remarks>
  [DNTypeName('Aspose.Pdf.DocSaveOptions+RecognitionMode')]
  DNDocSaveOptions_RecognitionMode = type Integer;
  DNDocSaveOptions_RecognitionModeHelper = record helper for DNDocSaveOptions_RecognitionMode
  public const
    ///<summary><para>This mode is fast and good for maximally preserving original look of the PDF file,
    ///  but editability of the resulting document could be limited.</para><para>Every visually grouped block of text int the original PDF file is converted into a textbox
    ///  in the resulting document. This achieves maximal resemblance of the output document to the original
    ///  PDF file. The output document will look good, but it will consist entirely of textboxes and it
    ///  could makes further editing of the document in Microsoft Word quite hard.</para><para>This is the default mode.</para></summary>
    Textbox = 0;
    ///<summary>
    ///  Full recognition mode, the engine performs grouping and multi-level analysis to restore
    ///  the original document author's intent and produce a maximally editable document.
    ///  The downside is that the output document might look different from the original PDF file.
    ///</summary>
    Flow = 1;
    ///<summary>
    ///  An early alfa version of a new Flow mode supporting recognition of tables.
    ///</summary>
    EnhancedFlow = 2;
  end;


  //-------------namespace: Aspose.Pdf.Drawing----------------
  ///<summary>
  ///  This enum represents image formats.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Drawing.ImageFormat')]
  DNImageFormat = type Integer;
  DNImageFormatHelper = record helper for DNImageFormat
  public const
    Bmp = 0;
    Jpeg = 1;
    Gif = 2;
    Png = 3;
    Tiff = 4;
    Emf = 5;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  When PDF file (that usually has fixed layout) is being converted,
  ///  the conversion engine tries to perform grouping and multi-level analysis to restore
  ///  the original document author's intent and produce result in flow layout.
  ///  This property tunes that conversion for this or that
  ///  desirable method of recognition of content.
  ///</summary>
  [DNTypeName('Aspose.Pdf.EpubSaveOptions+RecognitionMode')]
  DNEpubSaveOptions_RecognitionMode = type Integer;
  DNEpubSaveOptions_RecognitionModeHelper = record helper for DNEpubSaveOptions_RecognitionMode
  public const
    ///<summary>
    ///  Full recognition mode, the engine tries to perform grouping and multi-level analysis to restore
    ///  the original document author's intent and produce xhtml in flow layout.
    ///</summary>
    Flow = 0;
    ///<summary>
    ///  The main idea of this conversion is based on saving "natural" order of content rendering that is formed during processing of pdf documents.
    ///  In the general cases pdf documents keep top-down\left-right rendering order (see attachment directions.png). This assumption allows to
    ///  create a single-path algorithm that will transform Aps elements that have positions (fixed-layout) into flow formats like HTML,EPUB,DOC.
    ///  This mode will be especially useful for converting from PDF(APS) into EPUB, because the EPUB format was developed for e-readers like the Kindle or
    ///  smart-phones. The size of screen those devices usually is less than the size of screen of ordinary PC. Therefore the content of EPUB documents is better to save
    ///  in the flow format, for correct rendering on screens with different sizes.
    ///  In this mode every column will be added to the end of previous column this allows to keep the logical structure of transformed document
    ///  during "pagination" in EPUB readers. This achievement allows correctly render scientific or magazine articles.
    ///</summary>
    PdfFlow = 1;
    ///<summary>
    ///  This mode is fast and good for maximally preserving the original look pages,
    ///  but unfortunately many EPUB readeres don't support xhtml with fixed layout
    ///</summary>
    Fixed = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates conversion engines that can be used for conversion
  ///  Default value is NewEngine
  ///</summary>
  [DNTypeName('Aspose.Pdf.ExcelSaveOptions+ConversionEngines')]
  DNExcelSaveOptions_ConversionEngines = type Integer;
  DNExcelSaveOptions_ConversionEnginesHelper = record helper for DNExcelSaveOptions_ConversionEngines
  public const
    ///<summary>
    ///  Legacy conversion engine is deprecated.
    ///</summary>
    LegacyEngine = 0;
    ///<summary>
    ///  The new conversion engine. Used by default.
    ///</summary>
    NewEngine = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Allows to specify .xlsx, .xls/xml or csv file format.
  ///  Default value is XLSX;
  ///</summary>
  [DNTypeName('Aspose.Pdf.ExcelSaveOptions+ExcelFormat')]
  DNExcelSaveOptions_ExcelFormat = type Integer;
  DNExcelSaveOptions_ExcelFormatHelper = record helper for DNExcelSaveOptions_ExcelFormat
  public const
    ///<summary>
    ///  Excel 2003 XML Format
    ///</summary>
    XMLSpreadSheet2003 = 0;
    ///<summary>
    ///  Office Open XML (.xlsx) File Format
    ///</summary>
    XLSX = 1;
    ///<summary>
    ///  A comma-separated values (CSV) File Format
    ///</summary>
    CSV = 2;
    ///<summary>
    ///  A macro-enabled Office Open XML (.xlsm) File Format
    ///</summary>
    XLSM = 3;
    ///<summary>
    ///  OpenDocument Spreadsheet
    ///</summary>
    ODS = 4;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Represents boolean type that supports Undefined value.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ExtendedBoolean')]
  DNExtendedBoolean = type Integer;
  DNExtendedBooleanHelper = record helper for DNExtendedBoolean
  public const
    ///<summary>
    ///  Undefined value value of ExtendnedBoolean.
    ///</summary>
    Undefined = 0;
    ///<summary>
    ///  False value of ExtendnedBoolean.
    ///</summary>
    False = 1;
    ///<summary>
    ///  True value of ExtendnedBoolean.
    ///</summary>
    True = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Defines different modes which can be used while extracting images from documents.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ExtractImageMode')]
  DNExtractImageMode = type Integer;
  DNExtractImageModeHelper = record helper for DNExtractImageMode
  public const
    ///<summary>
    ///  Defines image extraction mode in which all images defined in resources for particular page are extracted.
    ///</summary>
    DefinedInResources = 0;
    ///<summary>
    ///  Defines image extraction mode in which only those images are extracted that are actually shown on a page.
    ///</summary>
    ActuallyUsed = 1;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Represents algorithms which can be used to encrypt pdf document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.Algorithm')]
  DNAlgorithm = type Integer;
  DNAlgorithmHelper = record helper for DNAlgorithm
  public const
    ///<summary>
    ///  RC4 algorithm.
    ///</summary>
    RC4 = 0;
    ///<summary>
    ///  AES algorithm.
    ///</summary>
    AES = 1;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Direction of the rotation when document is printed.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.AutoRotateMode')]
  DNAutoRotateMode = type Integer;
  DNAutoRotateModeHelper = record helper for DNAutoRotateMode
  public const
    ///<summary>
    ///  No rotation.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Rotation direction is clockwise.
    ///</summary>
    ClockWise = 1;
    ///<summary>
    ///  Rotation directon is counterclockwise.
    ///</summary>
    AntiClockWise = 2;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Class represents blending color space.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.BlendingColorSpace')]
  DNBlendingColorSpace = type Integer;
  DNBlendingColorSpaceHelper = record helper for DNBlendingColorSpace
  public const
    ///<summary>
    ///  The blending color space is not changed.
    ///</summary>
    DontChange = 0;
    ///<summary>
    ///  The blending color space is determined automatically.
    ///</summary>
    Auto = 1;
    ///<summary>
    ///  Blending color space is set to DeviceRGB.
    ///</summary>
    DeviceRGB = 2;
    ///<summary>
    ///  Blending color space is set to DeviceCMYK.
    ///</summary>
    DeviceCMYK = 3;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Enumerates field types definitions.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.DataType')]
  DNDataType = type Integer;
  DNDataTypeHelper = record helper for DNDataType
  public const
    ///<summary>
    ///  FDF stream.
    ///</summary>
    FDF = 0;
    ///<summary>
    ///  XML stream.
    ///</summary>
    XML = 1;
    ///<summary>
    ///  XFDF stream.
    ///</summary>
    XFDF = 2;
    ///<summary>
    ///  PDF stream.
    ///</summary>
    PDF = 3;
    ///<summary>
    ///  OLEDB database, such as MS Access.
    ///</summary>
    OLEDB = 4;
    ///<summary>
    ///  ODBC database, such as MS SQL Server.
    ///</summary>
    ODBC = 5;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Enumeration of standard XMP properties.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.DefaultMetadataProperties')]
  DNDefaultMetadataProperties = type Integer;
  DNDefaultMetadataPropertiesHelper = record helper for DNDefaultMetadataProperties
  public const
    ///<summary>
    ///  xmp:Advisory property.
    ///  An unordered array specifying properties that were edited outside the authoring application. Each item should contain a single          /// namespace and XPath separated by one ASCII space
    ///</summary>
    Advisory = 0;
    ///<summary>
    ///  xmp:BaseURL property.
    ///  The base URL for relative URLs in the document content. If this document contains Internet links, and those links are relative,          /// they are relative to this base URL. This property provides a standard way for embedded relative URLs to be interpreted by tools.        /// Web authoring tools should set the value based on their notion of where URLs will be interpreted
    ///</summary>
    BaseURL = 1;
    ///<summary>
    ///  xmp:CreateDate property.
    ///  The date and time the resource was originally created.
    ///</summary>
    CreateDate = 2;
    ///<summary>
    ///  xmp:CreatorTool property.
    ///  The name of the first known tool used to create the resource.
    ///</summary>
    CreatorTool = 3;
    ///<summary>
    ///  xmp:Identifier property.
    ///  An unordered array of text strings that unambiguously
    ///  identify the resource within a given context
    ///</summary>
    Identifier = 4;
    ///<summary>
    ///  xmp:MetadataDate property.
    ///  The date and time that any metadata for this resource
    ///  was last changed
    ///</summary>
    MetadataDate = 5;
    ///<summary>
    ///  xmp:ModifyDate property.
    ///  The date and time the resource was last modified.
    ///</summary>
    ModifyDate = 6;
    ///<summary>
    ///  xmp:Nickname property.
    ///  A short informal name for the resource.
    ///</summary>
    Nickname = 7;
    ///<summary>
    ///  xmp:Thumbnails property.
    ///  An alternative array of thumbnail images for a file,
    ///  which can differ in characteristics such as size or image
    ///  encoding.
    ///</summary>
    Thumbnails = 8;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Enumerates encoding types of the text using.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.EncodingType')]
  DNEncodingType = type Integer;
  DNEncodingTypeHelper = record helper for DNEncodingType
  public const
    ///<summary>
    ///  The Unicode encoding with horizontal writing.
    ///</summary>
    Identity_h = 0;
    ///<summary>
    ///  The Unicode encoding with vertical writing.
    ///</summary>
    Identity_v = 1;
    ///<summary>
    ///  A windows text encoding name.
    ///</summary>
    Cp1250 = 2;
    ///<summary>
    ///  A windows text encoding name.
    ///</summary>
    Cp1252 = 3;
    ///<summary>
    ///  A windows text encoding name.
    ///</summary>
    Cp1257 = 4;
    ///<summary>
    ///  Windows ansi encoding.
    ///</summary>
    Winansi = 5;
    ///<summary>
    ///  Mac os standard encoding for Latin text.
    ///</summary>
    Macroman = 6;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Enumeration of possible field types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.FieldType')]
  DNFieldType = type Integer;
  DNFieldTypeHelper = record helper for DNFieldType
  public const
    ///<summary>
    ///  Text field.
    ///</summary>
    Text = 0;
    ///<summary>
    ///  Combo box field.
    ///</summary>
    ComboBox = 1;
    ///<summary>
    ///  List box field.
    ///</summary>
    ListBox = 2;
    ///<summary>
    ///  Radio button field.
    ///</summary>
    Radio = 3;
    ///<summary>
    ///  Check box field.
    ///</summary>
    CheckBox = 4;
    ///<summary>
    ///  Push button field.
    ///</summary>
    PushButton = 5;
    ///<summary>
    ///  Multiline text field.
    ///</summary>
    MultiLineText = 6;
    ///<summary>
    ///  Barcode field.
    ///</summary>
    Barcode = 7;
    ///<summary>
    ///  Invalid field type.
    ///</summary>
    InvalidNameOrType = 8;
    ///<summary>
    ///  Signature field.
    ///</summary>
    Signature = 9;
    ///<summary>
    ///  Image field.
    ///</summary>
    Image = 10;
    ///<summary>
    ///  Numeric field
    ///</summary>
    Numeric = 11;
    ///<summary>
    ///  Date/time field
    ///</summary>
    DateTime = 12;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Enumerates 14 types of font.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.FontStyle')]
  DNFontStyle = type Integer;
  DNFontStyleHelper = record helper for DNFontStyle
  public const
    ///<summary>
    ///  Courier font.
    ///</summary>
    Courier = 0;
    ///<summary>
    ///  Bold Courier font.
    ///</summary>
    CourierBold = 1;
    ///<summary>
    ///  Oblique Curier font.
    ///</summary>
    CourierOblique = 2;
    ///<summary>
    ///  Bold oblique Courier font.
    ///</summary>
    CourierBoldOblique = 3;
    ///<summary>
    ///  Helvetica font.
    ///</summary>
    Helvetica = 4;
    ///<summary>
    ///  Bold Helvetica font.
    ///</summary>
    HelveticaBold = 5;
    ///<summary>
    ///  Oblique Helvetica font.
    ///</summary>
    HelveticaOblique = 6;
    ///<summary>
    ///  Bold oblique Helvetica font.
    ///</summary>
    HelveticaBoldOblique = 7;
    ///<summary>
    ///  Symbol font.
    ///</summary>
    Symbol = 8;
    ///<summary>
    ///  Times-Roman font.
    ///</summary>
    TimesRoman = 9;
    ///<summary>
    ///  Bold Times font.
    ///</summary>
    TimesBold = 10;
    ///<summary>
    ///  Italic Times font.
    ///</summary>
    TimesItalic = 11;
    ///<summary>
    ///  Bold italic Times font.
    ///</summary>
    TimesBoldItalic = 12;
    ///<summary>
    ///  ZapfDingbats font.
    ///</summary>
    ZapfDingbats = 13;
    ///<summary>
    ///  Unknown font. Standard font will be used.
    ///</summary>
    Unknown = 14;
    ///<summary>
    ///  True Type Font for CJK supporting ,default is MS PGothic font.
    ///</summary>
    CjkFont = 15;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Status of imported field
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.Form+ImportStatus')]
  DNForm_ImportStatus = type Integer;
  DNForm_ImportStatusHelper = record helper for DNForm_ImportStatus
  public const
    ///<summary>
    ///  Field was successfully imported
    ///</summary>
    Success = 0;
    ///<summary>
    ///  Field with this name was not found in the document form.
    ///</summary>
    FieldNotFound = 1;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Represents modes for merging images.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.ImageMergeMode')]
  DNImageMergeMode = type Integer;
  DNImageMergeModeHelper = record helper for DNImageMergeMode
  public const
    ///<summary>
    ///  Images merged vertically.
    ///</summary>
    Vertical = 1;
    ///<summary>
    ///  Images merged horizontally.
    ///</summary>
    Horizontal = 2;
    ///<summary>
    ///  Images aligned by center.
    ///</summary>
    Center = 3;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Defines different key sizes which can be used to encrypt pdf documents.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.KeySize')]
  DNKeySize = type Integer;
  DNKeySizeHelper = record helper for DNKeySize
  public const
    ///<summary>
    ///  40 bit key. Such key size is used with RC4 algorithm and provides low level of security.
    ///  Nevertheless old versions of pdf documents can be encrypted only with such keys (v. 1.3 and lower);
    ///</summary>
    x40 = 0;
    ///<summary>
    ///  128 bit key. Both RC4 and AES algorithms can use such key size.
    ///</summary>
    x128 = 1;
    ///<summary>
    ///  256 bit key. Such key size can be used only with AES and is recognized with the last Adobe Reader versions (starting from v.9).
    ///</summary>
    x256 = 2;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Action performed when corrupted file was met in concatenation process.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.PdfFileEditor+ConcatenateCorruptedFileAction')]
  DNPdfFileEditor_ConcatenateCorruptedFileAction = type Integer;
  DNPdfFileEditor_ConcatenateCorruptedFileActionHelper = record helper for DNPdfFileEditor_ConcatenateCorruptedFileAction
  public const
    ///<summary>
    ///  If corrupted file was met, then stop concatentation process and return error.
    ///</summary>
    StopWithError = 0;
    ///<summary>
    ///  If corrupted file was met, then don't stop concatenation and don't process corrupted file.
    ///  List of corrupted files is accessible in Failures property.
    ///</summary>
    ConcatenateIgnoringCorrupted = 1;
    ///<summary>
    ///  When corrupted object is met in source document, process will not stopped and corrupted object only is ignored.
    ///</summary>
    ConcatenateIgnoringCorruptedObjects = 2;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Defines positioning mode.
  ///  Possible values include Legacy (backward compatibility) and
  ///  Current (updated text position calculation method)
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.PositioningMode')]
  DNPositioningMode = type Integer;
  DNPositioningModeHelper = record helper for DNPositioningMode
  public const
    ///<summary>
    ///  Legacy text positioning
    ///</summary>
    Legacy = 0;
    ///<summary>
    ///  Updated line spacing, vertical position calculation is done by the old rules
    ///  (i.e. text is positioned relative to bottom-left corner of the specified rectangle)
    ///</summary>
    ModernLineSpacing = 1;
    ///<summary>
    ///  Updated line spacing and vertical position calculation is done based on left-top corner rather than left-bottom.
    ///</summary>
    Current = 2;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Enumeration of possible field flags.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.PropertyFlag')]
  DNPropertyFlag = type Integer;
  DNPropertyFlagHelper = record helper for DNPropertyFlag
  public const
    ///<summary>
    ///  Field is read-only.
    ///</summary>
    ReadOnly = 0;
    ///<summary>
    ///  Field is required.
    ///</summary>
    Required = 1;
    ///<summary>
    ///  Field is not exportable.
    ///</summary>
    NoExport = 2;
    ///<summary>
    ///  Invalid field flag.
    ///</summary>
    InvalidFlag = 3;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Action to perform if font does not contain required character
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.ReplaceTextStrategy+NoCharacterAction')]
  DNReplaceTextStrategy_NoCharacterAction = type Integer;
  DNReplaceTextStrategy_NoCharacterActionHelper = record helper for DNReplaceTextStrategy_NoCharacterAction
  public const
    ///<summary>
    ///  Throw exception
    ///</summary>
    ThrowException = 0;
    ///<summary>
    ///  Repalce font to standard font which contains required character
    ///</summary>
    UseStandardFont = 1;
    ///<summary>
    ///  Replace text anyway without font substitution
    ///</summary>
    ReplaceAnyway = 2;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Scope where replace text operation is applied
  ///  REPLACE_FIRST by default
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.ReplaceTextStrategy+Scope')]
  DNReplaceTextStrategy_Scope = type Integer;
  DNReplaceTextStrategy_ScopeHelper = record helper for DNReplaceTextStrategy_Scope
  public const
    ///<summary>
    ///  Replace only first occurence of the text on each of affected pages
    ///</summary>
    ReplaceFirst = 0;
    ///<summary>
    ///  Replace all text occurences on all affected pages
    ///</summary>
    ReplaceAll = 1;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Describes stamp types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.StampType')]
  DNStampType = type Integer;
  DNStampTypeHelper = record helper for DNStampType
  public const
    ///<summary>
    ///  Stamp if Form.
    ///</summary>
    Form = 0;
    ///<summary>
    ///  Stamp is image.
    ///</summary>
    Image = 1;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Enumeration of possible submit form flags.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.SubmitFormFlag')]
  DNSubmitFormFlag = type Integer;
  DNSubmitFormFlagHelper = record helper for DNSubmitFormFlag
  public const
    ///<summary>
    ///  Data will be returned in FDF format.
    ///</summary>
    Fdf = 0;
    ///<summary>
    ///  Data will be returned in HTML format.
    ///</summary>
    Html = 1;
    ///<summary>
    ///  Data will be returned in XFDF format.
    ///</summary>
    Xfdf = 2;
    ///<summary>
    ///  Data will be returned in FDF format with comments.
    ///</summary>
    FdfWithComments = 3;
    ///<summary>
    ///  Data will be returned in XFDF format with comments.
    ///</summary>
    XfdfWithComments = 4;
    ///<summary>
    ///  Whole PDF file will be submitted.
    ///</summary>
    Pdf = 5;
  end;


  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Defines word wrapping strategies
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.WordWrapMode')]
  DNWordWrapMode = type Integer;
  DNWordWrapModeHelper = record helper for DNWordWrapMode
  public const
    ///<summary>
    ///  Default algorithm (allows breaking words in the middle)
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Word wrapping only wraps complete words.
    ///  If the complete word cannot be wrapped, attempts
    ///  to wrap word in the middle
    ///</summary>
    ByWords = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Encoding of the attached file. Possible values: Zip - file is compressed with ZIP, None - file is non compressed.
  ///</summary>
  [DNTypeName('Aspose.Pdf.FileEncoding')]
  DNFileEncoding = type Integer;
  DNFileEncodingHelper = record helper for DNFileEncoding
  public const
    ///<summary>
    ///  File is not compressed.
    ///</summary>
    None = 0;
    ///<summary>
    ///  File is compressed with ZIP algorithhm.
    ///</summary>
    Zip = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  enumerates strategies for font subsetting
  ///</summary>
  [DNTypeName('Aspose.Pdf.FontSubsetStrategy')]
  DNFontSubsetStrategy = type Integer;
  DNFontSubsetStrategyHelper = record helper for DNFontSubsetStrategy
  public const
    ///<summary>
    ///  Declares to subset only fonts which are embedded in document already
    ///</summary>
    SubsetEmbeddedFontsOnly = 0;
    ///<summary>
    ///  Declares to subsets all the fonts, non-embedded and embedded both
    ///</summary>
    SubsetAllFonts = 1;
  end;


  //-------------namespace: Aspose.Pdf.Forms----------------
  [DNTypeName('Aspose.Pdf.Forms.BoxStyle')]
  DNBoxStyle = type Integer;
  DNBoxStyleHelper = record helper for DNBoxStyle
  public const
    ///<summary>
    ///  Circle style.
    ///</summary>
    Circle = 0;
    ///<summary>
    ///  Check style.
    ///</summary>
    Check = 1;
    ///<summary>
    ///  Cross style.
    ///</summary>
    Cross = 2;
    ///<summary>
    ///  Diamond style.
    ///</summary>
    Diamond = 3;
    ///<summary>
    ///  Square style.
    ///</summary>
    Square = 4;
    ///<summary>
    ///  Star style.
    ///</summary>
    Star = 5;
  end;


  //-------------namespace: Aspose.Pdf.Forms----------------
  ///<summary>
  ///  The access permissions granted for this document.
  ///  Valid values are:
  ///  1 - No changes to the document are permitted; any change to the document invalidates the signature.
  ///  2 - Permitted changes are filling in forms, instantiating page templates, and signing; other changes invalidate the signature.
  ///  3 - Permitted changes are the same as for 2, as well as annotation creation, deletion, and modification; other changes invalidate the signature.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.DocMDPAccessPermissions')]
  DNDocMDPAccessPermissions = type Integer;
  DNDocMDPAccessPermissionsHelper = record helper for DNDocMDPAccessPermissions
  public const
    ///<summary>
    ///  1 - No changes to the document are permitted; any change to the document invalidates the signature.
    ///</summary>
    NoChanges = 1;
    ///<summary>
    ///  2 - Permitted changes are filling in forms, instantiating page templates, and signing; other changes invalidate the signature.
    ///</summary>
    FillingInForms = 2;
    ///<summary>
    ///  3 - Permitted changes are the same as for 2, as well as annotation creation, deletion, and modification; other changes invalidate the signature.
    ///</summary>
    AnnotationModification = 3;
  end;


  //-------------namespace: Aspose.Pdf.Forms----------------
  ///<summary>
  ///  Forms can contain signing information and can be signed or unsigned.
  ///  Sometimes view of forms in viewer must depend on whether form is signed or not.
  ///  This enum enumerates possible rendering modes during convertion of form type in regard to sign.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.Form+SignDependentElementsRenderingModes')]
  DNForm_SignDependentElementsRenderingModes = type Integer;
  DNForm_SignDependentElementsRenderingModesHelper = record helper for DNForm_SignDependentElementsRenderingModes
  public const
    RenderFormAsUnsigned = 0;
    RenderFormAsSigned = 1;
  end;


  //-------------namespace: Aspose.Pdf.Forms----------------
  ///<summary>
  ///  Enumeration of posible types of Acro Form.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.FormType')]
  DNFormType = type Integer;
  DNFormTypeHelper = record helper for DNFormType
  public const
    ///<summary>
    ///  Standard AcroForm.
    ///</summary>
    Standard = 0;
    ///<summary>
    ///  Static XFA form.
    ///</summary>
    Static_ = 1;
    ///<summary>
    ///  Dynamic XFA form.
    ///</summary>
    Dynamic_ = 2;
  end;


  //-------------namespace: Aspose.Pdf.Forms----------------
  ///<summary>
  ///  Describes position of icon.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.IconCaptionPosition')]
  DNIconCaptionPosition = type Integer;
  DNIconCaptionPositionHelper = record helper for DNIconCaptionPosition
  public const
    ///<summary>
    ///  Icon is not displayed.
    ///</summary>
    NoIcon = 0;
    ///<summary>
    ///  Caption is not displayed.
    ///</summary>
    NoCaption = 1;
    ///<summary>
    ///  Caption is below icon.
    ///</summary>
    CaptionBelowIcon = 2;
    ///<summary>
    ///  Caption is above icon.
    ///</summary>
    CaptionAboveIcon = 3;
    ///<summary>
    ///  Caption to the right.
    ///</summary>
    CaptionToTheRight = 4;
    ///<summary>
    ///  Caption to the left.
    ///</summary>
    CaptionToTheLeft = 5;
    ///<summary>
    ///  Caption over laid.
    ///</summary>
    CaptionOverlaid = 6;
  end;


  //-------------namespace: Aspose.Pdf.Forms----------------
  ///<summary>
  ///  The type of scaling that shall be used.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.ScalingMode')]
  DNScalingMode = type Integer;
  DNScalingModeHelper = record helper for DNScalingMode
  public const
    ///<summary>
    ///  Scale the icon to fit the width or height of the annotation rectangle while maintaining the icon�s original aspect ratio.
    ///</summary>
    Proportional = 0;
    ///<summary>
    ///  Scale the icon to fill the annotation rectangle exactly.
    ///</summary>
    Anamorphic = 1;
  end;


  //-------------namespace: Aspose.Pdf.Forms----------------
  ///<summary>
  ///  The circumstances under which the icon shall be scaled inside the annotation rectangle.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.ScalingReason')]
  DNScalingReason = type Integer;
  DNScalingReasonHelper = record helper for DNScalingReason
  public const
    ///<summary>
    ///  Always scale.
    ///</summary>
    Always = 0;
    ///<summary>
    ///  BScale only when the icon is bigger than the annotation rectangle.
    ///</summary>
    IconIsBigger = 1;
    ///<summary>
    ///  Scale only when the icon is smaller than the annotation rectangle.
    ///</summary>
    IconIsSmaller = 2;
    ///<summary>
    ///  Never scale.
    ///</summary>
    Never = 3;
  end;


  //-------------namespace: Aspose.Pdf.Forms----------------
  ///<summary>
  ///  A (Barcode) Symbology defines the technical details of a particular type of barcode:
  ///  the width of the bars, character set, method of encoding, checksum specifications, etc.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.Symbology')]
  DNSymbology = type Integer;
  DNSymbologyHelper = record helper for DNSymbology
  public const
    ///<summary>
    ///  A multi-row, variable-length 2D symbology with high data capacity and error-correction capability.
    ///</summary>
    PDF417 = 0;
    ///<summary>
    ///  QR code (short for Quick Response) is a specific matrix barcode (2D code),
    ///  readable by dedicated QR barcode readers and camera phones.
    ///</summary>
    QRCode = 1;
    ///<summary>
    ///  A 2D matrix symbology consisting of black and white square modules arranged in either a square or
    ///  rectangular pattern.
    ///</summary>
    DataMatrix = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Describes horizontal alignment.
  ///</summary>
  [DNTypeName('Aspose.Pdf.HorizontalAlignment')]
  DNHorizontalAlignment = type Integer;
  DNHorizontalAlignmentHelper = record helper for DNHorizontalAlignment
  public const
    ///<summary>
    ///  No alignment.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Align to left.
    ///</summary>
    Left = 1;
    ///<summary>
    ///  Center alignment.
    ///</summary>
    Center = 2;
    ///<summary>
    ///  Align to right.
    ///</summary>
    Right = 3;
    ///<summary>
    ///  Justify alignment. Text will be aligned on both left and right margins.
    ///</summary>
    Justify = 4;
    ///<summary>
    ///  Similar to 'Justify' alignment, except that the very last line will only be
    ///  left-aligned in 'Justify' mode, while in 'FullJustify' mode all lines will be
    ///  left- and right-aligned.
    ///</summary>
    FullJustify = 5;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Represents enumeration of the Html document types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlDocumentType')]
  DNHtmlDocumentType = type Integer;
  DNHtmlDocumentTypeHelper = record helper for DNHtmlDocumentType
  public const
    ///<summary>
    ///  The XHtml Document Type.
    ///</summary>
    Xhtml = 0;
    ///<summary>
    ///  The HTML5 Document Type.
    ///</summary>
    Html5 = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Specifies possible media types used during rendering.
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlMediaType')]
  DNHtmlMediaType = type Integer;
  DNHtmlMediaTypeHelper = record helper for DNHtmlMediaType
  public const
    Print = 0;
    Screen = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This enum describes possible antialiasing measures during conversion
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+AntialiasingProcessingType')]
  DNHtmlSaveOptions_AntialiasingProcessingType = type Integer;
  DNHtmlSaveOptions_AntialiasingProcessingTypeHelper = record helper for DNHtmlSaveOptions_AntialiasingProcessingType
  public const
    ///<summary>
    ///  no special antialiasing processing in use. This is an optimal option
    ///  for overhelming majority of documents and it does not require additional time
    ///  during conversion
    ///</summary>
    NoAdditionalProcessing = 0;
    ///<summary>
    ///  In such case converter tries to detect places with ajacent background graphical
    ///  elements and correct result HTML in relevant way.
    ///  This option allows enhance result of export for documents that contain backgrounds
    ///  built from several ajacent graphical elements (for such kind of documents PDF renderers , f.e. Acrobat Reader,
    ///  usually try smooth boundaries of elements during rendering.
    ///  With this option converter imitates that behaviour of PDF-renderers.
    ///  This option allows enhance layout of result of export for some specific documents (that use such compound backgrounds),
    ///  but it requires additional time for processng (usually about 10-15% of additional time).
    ///  So usage of this mode in general case is not recommended.
    ///</summary>
    TryCorrectResultHtml = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This enumeration defines rules which tune encoding logic
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+FontEncodingRules')]
  DNHtmlSaveOptions_FontEncodingRules = type Integer;
  DNHtmlSaveOptions_FontEncodingRulesHelper = record helper for DNHtmlSaveOptions_FontEncodingRules
  public const
    ///<summary>
    ///  Leave encoding logic "as is" - in accordance with PDF specification
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  ToUnicode is a special mechanism which helps to decode input codes to unicode symbols.
    ///  According to specification it must be used first of all mechanisms to get unicode symbols
    ///  for specific input code. But some documents has non-standard fonts and to convert these
    ///  documents correctly it may be necessary to decrease ToUnicode priority and use another
    ///  mechanisms to decode input codes.
    ///</summary>
    DecreaseToUnicodePriorityLevel = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates modes that can be used for saving of fonts
  ///  referenced in saved PDF
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+FontSavingModes')]
  DNHtmlSaveOptions_FontSavingModes = type Integer;
  DNHtmlSaveOptions_FontSavingModesHelper = record helper for DNHtmlSaveOptions_FontSavingModes
  public const
    ///<summary>
    ///  All referenced fonts will be saved and referenced as WOFF-fonts
    ///</summary>
    AlwaysSaveAsWOFF = 0;
    ///<summary>
    ///  All referenced fonts will be saved and referenced as TTF-fonts
    ///</summary>
    AlwaysSaveAsTTF = 1;
    ///<summary>
    ///  All referenced fonts will be saved and referenced as EOT-fonts
    ///</summary>
    AlwaysSaveAsEOT = 2;
    ///<summary>
    ///  All referenced fonts will be saved (and referenced in CSS) as 3 independent files : EOT, TTH,WOFF.
    ///  It increases size of output data but makes output sutable for overhelming majority of web brawsers
    ///</summary>
    SaveInAllFormats = 3;
    ///<summary>
    ///  All referenced fonts will not be saved.
    ///</summary>
    DontSave = 4;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  enumerates possible types of image files
  ///  that can be saved as external resources
  ///  during Pdf to Html conversion
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+HtmlImageType')]
  DNHtmlSaveOptions_HtmlImageType = type Integer;
  DNHtmlSaveOptions_HtmlImageTypeHelper = record helper for DNHtmlSaveOptions_HtmlImageType
  public const
    ///<summary>
    ///  Jpeg format
    ///</summary>
    Jpeg = 0;
    ///<summary>
    ///  Png format
    ///</summary>
    Png = 1;
    ///<summary>
    ///  Bmp format
    ///</summary>
    Bmp = 2;
    ///<summary>
    ///  Gif format
    ///</summary>
    Gif = 3;
    ///<summary>
    ///  Tiff format
    ///</summary>
    Tiff = 4;
    ///<summary>
    ///  Svg format
    ///</summary>
    Svg = 5;
    ///<summary>
    ///  Zipped Svg format
    ///</summary>
    ZippedSvg = 6;
    ///<summary>
    ///  Unknown - means that converter cannot detect type of content itself
    ///</summary>
    Unknown = 7;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Sometimes specific reqirments to created HTML are present.
  ///  This enum defines HTML preparing modes that can be used
  ///  during conversion of PDF to HTML to match such specific requirments.
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+HtmlMarkupGenerationModes')]
  DNHtmlSaveOptions_HtmlMarkupGenerationModes = type Integer;
  DNHtmlSaveOptions_HtmlMarkupGenerationModesHelper = record helper for DNHtmlSaveOptions_HtmlMarkupGenerationModes
  public const
    ///<summary>
    ///  Default mode any specific requirments are absent.
    ///  Will be generated output that will contain all parts of HTML
    ///  without any special additional processing.
    ///</summary>
    WriteAllHtml = 0;
    ///<summary>
    ///  will be stripped away all HTML content that is outside HTML's body,
    ///  i.e. will be left only content that is inside <body></body> tags
    ///</summary>
    WriteOnlyBodyContent = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates possible types of image's parents
  ///  Image can pertain to HTML page or to SVG parent image
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+ImageParentTypes')]
  DNHtmlSaveOptions_ImageParentTypes = type Integer;
  DNHtmlSaveOptions_ImageParentTypesHelper = record helper for DNHtmlSaveOptions_ImageParentTypes
  public const
    ///<summary>
    ///  Image pertains to HTML page itself
    ///</summary>
    HtmlPage = 0;
    ///<summary>
    ///  Image was embedded in SVG image
    ///</summary>
    SvgImage = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  It enumerates possible modes of positioning of letters in words in result HTML
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+LettersPositioningMethods')]
  DNHtmlSaveOptions_LettersPositioningMethods = type Integer;
  DNHtmlSaveOptions_LettersPositioningMethodsHelper = record helper for DNHtmlSaveOptions_LettersPositioningMethods
  public const
    ///<summary>
    ///  It's default method. It uses EM-units and special alhorithm of compensation of rounding errors
    ///  It's preferable for usage in IE10.0 and more fresh versions and gives better scaling of captions when scaling is necessary
    ///</summary>
    UseEmUnitsAndCompensationOfRoundingErrorsInCss = 0;
    ///<summary>
    ///  It allows to get sometimes more precise results in old IE browser versions
    ///</summary>
    UsePixelUnitsInCssLetterSpacingForIE = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This enum enumerates possible modes of embedding of files referenced in HTML
  ///  It allows to control whether referenced files (HTML, Fonts,Images, CSSes)
  ///  will be embedded into main HTML file or will be generated as apart binary entities
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+PartsEmbeddingModes')]
  DNHtmlSaveOptions_PartsEmbeddingModes = type Integer;
  DNHtmlSaveOptions_PartsEmbeddingModesHelper = record helper for DNHtmlSaveOptions_PartsEmbeddingModes
  public const
    ///<summary>
    ///  Enforces embed all referenced files(Css,Images,Fonts) into generated HTML markup (i.e. into HTML itself)
    ///  This approach generates one HTML file, but total size of output
    ///  becames bigger(because Base64 encoding of binaries is in use) and not all browsers (especially legacy)
    ///  successfully process binaries embedded into HTML. But it allows get HTML that contains whole result, without any additional files.
    ///</summary>
    EmbedAllIntoHtml = 0;
    ///<summary>
    ///  Enforces put apart all referenced files except CSS (Images and Fonts)
    ///  I.e. CSS will be embedded into result HTML , and all other referenced files(Images and Fonts)
    ///  will be processed as external parts
    ///  It generates HTML that is sutable for wide set of browsers
    ///</summary>
    EmbedCssOnly = 1;
    ///<summary>
    ///  Enforces put apart referenced files(Css,Images,Fonts)
    ///  This approach generates set of files, but total size of output
    ///  becames smaller(because no Base64 encoding of binaries is in use)
    ///  Also such approach generates HTML that is sutable for wide set of browsers
    ///</summary>
    NoEmbedding = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Converted PDF can contain raster images(.png, *.jpeg etc.)
  ///  This enum defines methods of how raster images can be handled
  ///  during conversion of PDF to HTML
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+RasterImagesSavingModes')]
  DNHtmlSaveOptions_RasterImagesSavingModes = type Integer;
  DNHtmlSaveOptions_RasterImagesSavingModesHelper = record helper for DNHtmlSaveOptions_RasterImagesSavingModes
  public const
    ///<summary>
    ///  for each distinct raster file will be generated wrapper SVG image,
    ///  and raster image will be embedded as Base64 encoded strings
    ///  into that SVG image
    ///</summary>
    AsPngImagesEmbeddedIntoSvg = 0;
    ///<summary>
    ///  distinct raster images will be put apart as PNG files but will be referenced through wrapping SVG images,
    ///  i.e. will be generated one PNG file and one SVG for each raster image,
    ///  and each of such SVGs will contain links to relevant PNG file
    ///</summary>
    AsExternalPngFilesReferencedViaSvg = 1;
    ///<summary>
    ///  Will be generated one big PNG background file for each result page.
    ///  Raster images will be embedded into that file and rendered as regions of that image.
    ///  No external PNG files for each image will be generated,
    ///  only one PNG file per page will be present in conversion result set of files.
    ///</summary>
    AsEmbeddedPartsOfPngPageBackground = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Action which performed with image object when image is removed from collection. If image object is removed
  ///</summary>
  [DNTypeName('Aspose.Pdf.ImageDeleteAction')]
  DNImageDeleteAction = type Integer;
  DNImageDeleteActionHelper = record helper for DNImageDeleteAction
  public const
    ///<summary>
    ///  Image will be removed from the collection. If page contents contains references to the image they will not be removed. Document may became invalid.
    ///</summary>
    KeepContents = 0;
    ///<summary>
    ///  Image will be removed from the collection and from page contents, but image object will not be deleted. File size will not be decreased.
    ///</summary>
    None = 1;
    ///<summary>
    ///  Image will be removed from the collection and image object will be removed from the document. If other references on the same object exist the document may be corrupted.
    ///</summary>
    ForceDelete = 2;
    ///<summary>
    ///  Image will be removed from the collection and image object will be removed only if no other references to the image from other pages. This may require more time in comparision with ForeDelete option.
    ///</summary>
    Check = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates the image file types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ImageFileType')]
  DNImageFileType = type Integer;
  DNImageFileTypeHelper = record helper for DNImageFileType
  public const
    ///<summary>
    ///  Unknown type.
    ///</summary>
    Unknown = 0;
    ///<summary>
    ///  svg image file type.
    ///</summary>
    Svg = 1;
    ///<summary>
    ///  Dicom image file type.
    ///</summary>
    Dicom = 2;
    ///<summary>
    ///  Base64 image file type.
    ///</summary>
    Base64 = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumeration representing image filter type.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ImageFilterType')]
  DNImageFilterType = type Integer;
  DNImageFilterTypeHelper = record helper for DNImageFilterType
  public const
    Jpeg2000 = 0;
    Jpeg = 1;
    Flate = 2;
    CCITTFax = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Specifies import format.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ImportFormat')]
  DNImportFormat = type Integer;
  DNImportFormatHelper = record helper for DNImportFormat
  public const
    ///<summary>
    ///  Computer Graphics Metafile format.
    ///</summary>
    Cgm = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Specifies load format.
  ///</summary>
  [DNTypeName('Aspose.Pdf.LoadFormat')]
  DNLoadFormat = type Integer;
  DNLoadFormatHelper = record helper for DNLoadFormat
  public const
    ///<summary>
    ///  means loading of document in CGM format
    ///</summary>
    CGM = 0;
    ///<summary>
    ///  means loading of document in HTML format
    ///</summary>
    HTML = 1;
    ///<summary>
    ///  means loading of document in EPUB format(special format of e-books)
    ///</summary>
    EPUB = 2;
    ///<summary>
    ///  means loading of document in XML format(special XML that represent logical structure of PDF document)
    ///</summary>
    XML = 3;
    ///<summary>
    ///  means loading of document in XSLFO format
    ///</summary>
    XSLFO = 4;
    ///<summary>
    ///  means loading of document in PCL format
    ///</summary>
    PCL = 5;
    ///<summary>
    ///  means loading of document in XPS format
    ///</summary>
    XPS = 6;
    ///<summary>
    ///  means loading of document in TEX format - format of Latex text editor
    ///</summary>
    TEX = 7;
    ///<summary>
    ///  means loading of document in SVG format - format of Latex text editor
    ///</summary>
    SVG = 8;
    ///<summary>
    ///  means loading of document in MHT format(that is packed HTML format)
    ///</summary>
    MHT = 9;
    ///<summary>
    ///  means loading of document in PS format(format of PostScript document)
    ///</summary>
    PS = 10;
    ///<summary>
    ///  means loading document is in MD format (markdown).
    ///</summary>
    MD = 11;
    ///<summary>
    ///  means loading document is in TXT format.
    ///</summary>
    TXT = 12;
    ///<summary>
    ///  means loading document in APS format.
    ///</summary>
    APS = 13;
    ///<summary>
    ///  Internal PDF document structure in XML format.
    ///</summary>
    PDFXML = 14;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Represents mode of usage of margins area during conversion
  ///  (like HTML, EPUB etc), defines treatement of instructions of imported format
  ///  related to usage of margins.
  ///</summary>
  [DNTypeName('Aspose.Pdf.LoadOptions+MarginsAreaUsageModes')]
  DNLoadOptions_MarginsAreaUsageModes = type Integer;
  DNLoadOptions_MarginsAreaUsageModesHelper = record helper for DNLoadOptions_MarginsAreaUsageModes
  public const
    ///<summary>
    ///  In this mode converter obeyes format of imported document (f.e. CSS of imported HTML)
    ///  in usage of margins area.So, if format of imported document requires usage
    ///  of margins area for rendering , converter will allow that
    ///</summary>
    PutContentOnMarginAreaIfNecessary = 0;
    ///<summary>
    ///  This mode strictly forbids usage of margins area,
    ///  so, converter will never use area of margins for rendering,
    ///  even if CSS or format of source document allows or requirs that
    ///</summary>
    NeverPutContentOnMarginArea = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  ATTENTION! The feature implemented but did not put yet to public API since blocker issue in
  ///  OSHARED layer revealed for sample document.
  ///  Represents mode of usage of page size during conversion.
  ///  Formats (like HTML, EPUB etc), usually have float design, so, it allows to fit required
  ///  pagesize. But sometimes content has specifies horizontal positions or size that
  ///  does not allow put content into required page size.
  ///  In such case we can define what should be done in this case (i.e when size of content does not fit
  ///  required initial page size of result PDF document).
  ///</summary>
  [DNTypeName('Aspose.Pdf.LoadOptions+PageSizeAdjustmentModes')]
  DNLoadOptions_PageSizeAdjustmentModes = type Integer;
  DNLoadOptions_PageSizeAdjustmentModesHelper = record helper for DNLoadOptions_PageSizeAdjustmentModes
  public const
    ///<summary>
    ///  In this mode result pages will have required pagesize defined in LoadOptions,
    ///  no matter whether content after conversion goes out of page boundaries or no.
    ///</summary>
    NoAjustmentAllwaysUsePredefinedSize = 0;
    ///<summary>
    ///  This mode defines such behaviour: after getting of conversion result ,
    ///  and detecting of fact that some content has been truncated,
    ///  width of portview is enlarged to fit content and conversion is repeated.
    ///  This mode allows getting of less pages in result in such case but requires repeated
    ///  rendering(and therefore more processing time).
    ///</summary>
    EnlargeRequiredViewportWidthAndDoConversionAgain = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumeration of supported page numbering style for PageLabel class.
  ///</summary>
  [DNTypeName('Aspose.Pdf.NumberingStyle')]
  DNNumberingStyle = type Integer;
  DNNumberingStyleHelper = record helper for DNNumberingStyle
  public const
    ///<summary>
    ///  Arabic decimal numbers.
    ///</summary>
    NumeralsArabic = 0;
    ///<summary>
    ///  Uppercase roman numbers (I, II, III...).
    ///</summary>
    NumeralsRomanUppercase = 1;
    ///<summary>
    ///  Lowercase roman numbers (i, ii, iii...).
    ///</summary>
    NumeralsRomanLowercase = 2;
    ///<summary>
    ///  Uppercase latin letters (A, B, C...).
    ///</summary>
    LettersUppercase = 3;
    ///<summary>
    ///  Lowercase latin letters (a, b, c...).
    ///</summary>
    LettersLowercase = 4;
    ///<summary>
    ///  No numbering.
    ///</summary>
    None = 5;
  end;


  //-------------namespace: Aspose.Pdf.Optimization----------------
  ///<summary>
  ///  Describes versions of image compression algorithm.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Optimization.ImageCompressionVersion')]
  DNImageCompressionVersion = type Integer;
  DNImageCompressionVersionHelper = record helper for DNImageCompressionVersion
  public const
    ///<summary>
    ///  Standard algorithm. Default value.
    ///</summary>
    Standard = 0;
    ///<summary>
    ///  Improved algorithm faster then standard but applicable not for all cases.
    ///</summary>
    Fast = 2;
    ///<summary>
    ///  Use fast algorithm when possible and standard for other cases. May be slower then "Fast" but may produce better compression.
    ///</summary>
    Mixed = 3;
  end;


  //-------------namespace: Aspose.Pdf.Optimization----------------
  [DNTypeName('Aspose.Pdf.Optimization.ImageEncoding')]
  DNImageEncoding = type Integer;
  DNImageEncodingHelper = record helper for DNImageEncoding
  public const
    ///<summary>
    ///  Don't change encoding.
    ///</summary>
    Unchanged = 0;
    ///<summary>
    ///  JPEG (DCT) encoding.
    ///</summary>
    Jpeg = 1;
    ///<summary>
    ///  Flate encoding.
    ///</summary>
    Flate = 2;
    ///<summary>
    ///  JPEG2000 (JPX) encoding.
    ///</summary>
    Jpeg2000 = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Describes page coordinate type.
  ///</summary>
  [DNTypeName('Aspose.Pdf.PageCoordinateType')]
  DNPageCoordinateType = type Integer;
  DNPageCoordinateTypeHelper = record helper for DNPageCoordinateType
  public const
    ///<summary>
    ///  The MediaBox is used to specify the width and height of the page.
    ///  For the average user, this probably equals the actual page size.
    ///  The MediaBox is the largest page box in a PDF. The other page boxes can equal the
    ///  size of the MediaBox but they cannot be larger.
    ///</summary>
    MediaBox = 0;
    ///<summary>
    ///  The CropBox defines the region to which the page contents are to be clipped.
    ///  Acrobat uses this size for screen display and printing.
    ///</summary>
    CropBox = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Descibes page layout.
  ///</summary>
  [DNTypeName('Aspose.Pdf.PageLayout')]
  DNPageLayout = type Integer;
  DNPageLayoutHelper = record helper for DNPageLayout
  public const
    ///<summary>
    ///  Single page.
    ///</summary>
    SinglePage = 0;
    ///<summary>
    ///  Display the pages in one column.
    ///</summary>
    OneColumn = 1;
    ///<summary>
    ///  Display the pages in two columns, with odd-numbered pages on the left.
    ///</summary>
    TwoColumnLeft = 2;
    ///<summary>
    ///  Display the pages in two columns, with odd-numbered pages on the right.
    ///</summary>
    TwoColumnRight = 3;
    ///<summary>
    ///  Display the pages two at a time, with odd-numbered pages on the left.
    ///</summary>
    TwoPageLeft = 4;
    ///<summary>
    ///  Display the pages two at a time, with odd-numbered pages on the right.
    ///</summary>
    TwoPageRight = 5;
    ///<summary>
    ///  Default layout.
    ///</summary>
    Default_ = 6;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Class descibes used components of the document page.
  ///</summary>
  [DNTypeName('Aspose.Pdf.PageMode')]
  DNPageMode = type Integer;
  DNPageModeHelper = record helper for DNPageMode
  public const
    ///<summary>
    ///  Dont use any components.
    ///</summary>
    UseNone = 0;
    ///<summary>
    ///  Document outline visible.
    ///</summary>
    UseOutlines = 1;
    ///<summary>
    ///  Thumbnail images visible.
    ///</summary>
    UseThumbs = 2;
    ///<summary>
    ///  FullScreenFull-screen mode, with no menu bar, window controls, or any other window visible.
    ///</summary>
    FullScreen = 3;
    ///<summary>
    ///  Optional content group panel visible.
    ///</summary>
    UseOC = 4;
    ///<summary>
    ///  Attachments panel visible.
    ///</summary>
    UseAttachments = 5;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This enum represents  known password types used for password protected pdf documents.
  ///</summary>
  [DNTypeName('Aspose.Pdf.PasswordType')]
  DNPasswordType = type Integer;
  DNPasswordTypeHelper = record helper for DNPasswordType
  public const
    ///<summary>
    ///  Pdf document is not password protected.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Pdf document was opened using document open password (restricted access).
    ///</summary>
    User = 1;
    ///<summary>
    ///  Pdf document was opened using change permissions password (full access).
    ///</summary>
    Owner = 2;
    ///<summary>
    ///  Pdf document is password protected but both user and owner passwords are not empty and
    ///  none of the passwords was defined or supplied password was incorrect. So it impossible to deduce the type of the password.
    ///</summary>
    Inaccessible = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates conversion engines that can be used for conversion
  ///</summary>
  [DNTypeName('Aspose.Pdf.PclLoadOptions+ConversionEngines')]
  DNPclLoadOptions_ConversionEngines = type Integer;
  DNPclLoadOptions_ConversionEnginesHelper = record helper for DNPclLoadOptions_ConversionEngines
  public const
    ///<summary>
    ///  Legacy conversion engine is conversion engine thay was used for a while and is used by default.
    ///</summary>
    LegacyEngine = 0;
    ///<summary>
    ///  New conversion engine is currently in A-testing state. We open it into public API to get some feedback.
    ///  It's currently recommended to use it only when old conversion engine cannot convert document for some reasons.
    ///</summary>
    NewEngine = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Declares set of some known encoding subtables
  ///</summary>
  [DNTypeName('Aspose.Pdf.PdfASymbolicFontEncodingStrategy+QueueItem+CMapEncodingTableType')]
  DNPdfASymbolicFontEncodingStrategy_QueueItem_CMapEncodingTableType = type Integer;
  DNPdfASymbolicFontEncodingStrategy_QueueItem_CMapEncodingTableTypeHelper = record helper for DNPdfASymbolicFontEncodingStrategy_QueueItem_CMapEncodingTableType
  public const
    ///<summary>
    ///  Specifies windows unicode table(3,1) - Unicode BMP-only (UCS-2)
    ///</summary>
    WindowsUnicodeTable = 0;
    ///<summary>
    ///  Specifies windows symbolic table - (3,0)
    ///</summary>
    WindowsSymbolicTable = 1;
    ///<summary>
    ///  Specifies mac table(1,0)
    ///</summary>
    MacTable = 2;
    ///<summary>
    ///  Specifies unicode table(0,3)
    ///</summary>
    UnicodeTable = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This class represents an pdf format.
  ///</summary>
  [DNTypeName('Aspose.Pdf.PdfFormat')]
  DNPdfFormat = type Integer;
  DNPdfFormatHelper = record helper for DNPdfFormat
  public const
    ///  Pdf/A-1a format
    PDF_A_1A = 0;
    ///  Pdf/A-1b format
    PDF_A_1B = 1;
    ///  Pdf/A-2a format
    PDF_A_2A = 2;
    ///  Pdf/A-3a format
    PDF_A_3A = 3;
    ///  Pdf/A-2b format
    PDF_A_2B = 4;
    ///  Pdf/A-2u format
    PDF_A_2U = 5;
    ///  Pdf/A-3b format
    PDF_A_3B = 6;
    ///  Pdf/A-3u format
    PDF_A_3U = 7;
    ///  Adobe version 1.3
    v_1_3 = 8;
    ///  Adobe version 1.4
    v_1_4 = 9;
    ///  Adobe version 1.5
    v_1_5 = 10;
    ///  Adobe version 1.6
    v_1_6 = 11;
    ///  Adobe version 1.7
    v_1_7 = 12;
    ///  PDF/UA-1 format
    PDF_UA_1 = 13;
    ///  PDF/X-1a-2001 format
    PDF_X_1A_2001 = 14;
    ///  PDF/X-1a format
    PDF_X_1A = 15;
    ///  PDF/X-3 format
    PDF_X_3 = 16;
    ///<summary>
    ///  ZUGFeRD format
    ///</summary>
    ZUGFeRD = 17;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Some PDF documents have special unicode symbols, which are belonged to Private Use Area (PUA),
  ///  see description at https://en.wikipedia.org/wiki/Private_Use_Areas.
  ///  This symbols cause an PDF/A compliant errors like "Text is mapped to Unicode Private Use Area but no ActualText entry is present".
  ///  This enumeration declares a strategies which can be used to handle PUA symbols.
  ///</summary>
  [DNTypeName('Aspose.Pdf.PdfFormatConversionOptions+PuaProcessingStrategy')]
  DNPdfFormatConversionOptions_PuaProcessingStrategy = type Integer;
  DNPdfFormatConversionOptions_PuaProcessingStrategyHelper = record helper for DNPdfFormatConversionOptions_PuaProcessingStrategy
  public const
    ///<summary>
    ///  Disable PUA symbol processing. This strategy used by default for PDF/A documents with Level B conformance.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Inserts marked content block with ActualText entry which contains empty text.
    ///  This strategy gives good results for documents without marked content blocks. Used by default for PDF/A documents with Level A conformance.
    ///</summary>
    SurroundPuaTextWithEmptyActualText = 1;
    ///<summary>
    ///  This strategy works slower than 'SurroundPuaTextWithEmptyActualText' but it can remove
    ///  PUA compliant errors for documents which can't be handled properly by SurroundPuaTextWithEmptyActualText. PUA symbols
    ///  are substituted on symbol 'space' or special unicode (some PUA symbols have unicode analogs). Substitution applied
    ///  not to document's text but to font's internal data ToUnicode so it doesn't affects symbol's vision but it
    ///  affects symbol's presentation in copy/paste operation system buffer.
    ///</summary>
    SubstitutePuaSymbols = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Some documens have large size after converison into PDF/A format. To reduce file size for these
  ///  documents it's necessary to define a strategy of fonts removing.
  ///  This enumeration declares a strategies which can be used to optimize fonts usage.
  ///  Every strategy from this enumeration has sense only when flag <see cref="P:Aspose.Pdf.PdfFormatConversionOptions.OptimizeFileSize" />
  ///  is set.
  ///</summary>
  [DNTypeName('Aspose.Pdf.PdfFormatConversionOptions+RemoveFontsStrategy')]
  DNPdfFormatConversionOptions_RemoveFontsStrategy = type Integer;
  DNPdfFormatConversionOptions_RemoveFontsStrategyHelper = record helper for DNPdfFormatConversionOptions_RemoveFontsStrategy
  public const
    ///<summary>
    ///  This strategy looks like <see cref="F:Aspose.Pdf.PdfFormatConversionOptions.RemoveFontsStrategy.RemoveDuplicatedFonts" />
    ///  but it removes not fully
    ///  duplicated fonts but fonts which are similar one to another and differs only by parameter "Widths".
    ///  This parameter contains set of some widths for specified symbols of font. Every value of width
    ///  from this "Widths" set is not the real width of symbol(glyph), real width for this symbol already
    ///  defined in font's binary data. Value of width from "Widths" set means visual width for this
    ///  symbol - the width which PDF viewer software must set on displaying symbol instead of real width
    ///  defined in the font. More accurately specification tells:
    ///  Acrobat 5.0 and later viewers use the glyph widths stored in the font dictionary to override the
    ///  widths of glyphs in the font program itself, which improves the consistency of the display and
    ///  printing of the document.
    ///  This strategy is more effective than <see cref="F:Aspose.Pdf.PdfFormatConversionOptions.RemoveFontsStrategy.RemoveDuplicatedFonts" />
    ///  but using of this
    ///  strategy in some cases theoretically could damage visual presentation of converted document.
    ///  This defect is possible due to that declared widths of fonts could be different for the same
    ///  symbol and in this case width of this symbol will be changed to new one after font
    ///  substitution - when removed font will be replaced in document with already embedded one.
    ///  And if symbol's visual width will be changed - it will be shown incorrectly and this
    ///  distinction could cause visual defects such as text overlapping or another problems.
    ///  But visual defect described is a very rare case and this strategy reduces size of
    ///  document more effectively.
    ///</summary>
    RemoveSimilarFontsWithDifferentWidths = 1;
    ///<summary>
    ///  This is most effective strategy to reduce document's size. It takes fully embedded font sets
    ///  and trim them down to only the subsets used. It's recommended to use this strategy in combination
    ///  with <see cref="F:Aspose.Pdf.PdfFormatConversionOptions.RemoveFontsStrategy.RemoveDuplicatedFonts" />
    ///  or <see cref="F:Aspose.Pdf.PdfFormatConversionOptions.RemoveFontsStrategy.RemoveSimilarFontsWithDifferentWidths" />
    ///  to
    ///  get multiple compression effect for file size. Using of all three strategies simultaneously
    ///  has no sense and strategy <see cref="F:Aspose.Pdf.PdfFormatConversionOptions.RemoveFontsStrategy.RemoveSimilarFontsWithDifferentWidths" />
    ///  will not
    ///  be used in this case.
    ///</summary>
    SubsetFonts = 2;
    ///<summary>
    ///  This strategy removes all the fonts which have duplicates in document. If document
    ///  contains group of duplicated fonts only one font from this group is embedded in document.
    ///  All other fonts from this group are removed from document, every removed font
    ///  substituted with the already embedded analog.
    ///</summary>
    RemoveDuplicatedFonts = 4;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Describes strategies used to align document text segments.
  ///  Now only strategy to restore segments to original bounds is supported.
  ///  In future another strategies could be added.
  ///</summary>
  [DNTypeName('Aspose.Pdf.PdfFormatConversionOptions+SegmentAlignStrategy')]
  DNPdfFormatConversionOptions_SegmentAlignStrategy = type Integer;
  DNPdfFormatConversionOptions_SegmentAlignStrategyHelper = record helper for DNPdfFormatConversionOptions_SegmentAlignStrategy
  public const
    None = 0;
    RestoreSegmentBounds = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This enum represents user's permissions for a pdf.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Permissions')]
  DNPermissions = type Integer;
  DNPermissionsHelper = record helper for DNPermissions
  public const
    ///<summary>
    ///  (Security handlers of revision 2) Print the document.
    ///  (Security handlers of revision 3 or greater) Print the document
    ///  (possibly not at the highest quality level,
    ///  depending on whether <see cref="F:Aspose.Pdf.Permissions.PrintingQuality" />
    ///  is also set).
    ///</summary>
    PrintDocument = 4;
    ///<summary>
    ///  Modify the contents of the document by operations other
    ///  than those controlled by  <see cref="F:Aspose.Pdf.Permissions.ModifyTextAnnotations" />
    ///  ,
    ///<see cref="F:Aspose.Pdf.Permissions.FillForm" />
    ///  , and 11.
    ///</summary>
    ModifyContent = 8;
    ///<summary>
    ///  (Security handlers of revision 2) Copy or otherwise extract
    ///  text and graphics from the document, including extracting
    ///  text and graphics (in support of accessibility to users
    ///  with disabilities or for other purposes).
    ///  (Security handlers of revision 3 or greater) Copy or otherwise
    ///  extract text and graphics from the document by operations
    ///  other than that controlled by <see cref="F:Aspose.Pdf.Permissions.ExtractContentWithDisabilities" />
    ///  .
    ///</summary>
    ExtractContent = 16;
    ///<summary>
    ///  Add or modify text annotations, fill in interactive form fields,
    ///  and, if <see cref="F:Aspose.Pdf.Permissions.ModifyContent" />
    ///  is also set, create or modify interactive form
    ///  fields (including signature fields).
    ///</summary>
    ModifyTextAnnotations = 32;
    ///<summary>
    ///  (Security handlers of revision 3 or greater) Fill in existing
    ///  interactive form fields (including signature fields), even if
    ///<see cref="F:Aspose.Pdf.Permissions.ModifyTextAnnotations" />
    ///  is clear.
    ///</summary>
    FillForm = 256;
    ///<summary>
    ///  (Security handlers of revision 3 or greater) Extract text and
    ///  graphics (in support of accessibility to users with disabilities
    ///  or for other purposes).
    ///</summary>
    ExtractContentWithDisabilities = 512;
    ///<summary>
    ///  (Security handlers of revision 3 or greater) Assemble the document
    ///  (insert, rotate, or delete pages and create bookmarks or thumbnail
    ///  images), even if <see cref="F:Aspose.Pdf.Permissions.ModifyContent" />
    ///  is clear.
    ///</summary>
    AssembleDocument = 1024;
    ///<summary>
    ///  (Security handlers of revision 3 or greater) Print the document to
    ///  a representation from which a faithful digital copy of the PDF content
    ///  could be generated. When this bit is clear (and bit 3 is set),
    ///  printing is limited to a low-level representation of the appearance,
    ///  possibly of degraded quality.
    ///</summary>
    PrintingQuality = 2048;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  The paper handling option to use when printing the file from the print dialog..
  ///</summary>
  [DNTypeName('Aspose.Pdf.PrintDuplex')]
  DNPrintDuplex = type Integer;
  DNPrintDuplexHelper = record helper for DNPrintDuplex
  public const
    ///<summary>
    ///  Print single-sided.
    ///</summary>
    Simplex = 0;
    ///<summary>
    ///  Duplex and flip on the short edge of the sheet.
    ///</summary>
    DuplexFlipShortEdge = 1;
    ///<summary>
    ///  Duplex and flip on the long edge of the sheet.
    ///</summary>
    DuplexFlipLongEdge = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This enum describes possible progress event types
  ///  that can occure during conversion
  ///</summary>
  [DNTypeName('Aspose.Pdf.ProgressEventType')]
  DNProgressEventType = type Integer;
  DNProgressEventTypeHelper = record helper for DNProgressEventType
  public const
    ///<summary>
    ///  means that occured event informs about total progress of conversion
    ///</summary>
    TotalProgress = 0;
    ///<summary>
    ///  means that occured event informs about end of analysis of one of pages before conversion
    ///</summary>
    SourcePageAnalysed = 1;
    ///<summary>
    ///  means that occured event informs about creation of one result page before phisical export
    ///</summary>
    ResultPageCreated = 2;
    ///<summary>
    ///  means that occured event informs about finished saving of one result page
    ///</summary>
    ResultPageSaved = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enum represented a program workflow action in case of invoking the
  ///<see cref="M:Aspose.Pdf.IWarningCallback.Warning(Aspose.Pdf.WarningInfo)" />
  ///  method.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ReturnAction')]
  DNReturnAction = type Integer;
  DNReturnActionHelper = record helper for DNReturnAction
  public const
    ///<summary>
    ///  Used for continue flow.
    ///</summary>
    Continue_ = 0;
    ///<summary>
    ///  Used for abort flow.
    ///</summary>
    Abort_ = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumeration of possible rotation values.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Rotation')]
  DNRotation = type Integer;
  DNRotationHelper = record helper for DNRotation
  public const
    ///<summary>
    ///  Non-rotated.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Rotated on 90 degrees clockwise.
    ///</summary>
    on90 = 1;
    ///<summary>
    ///  Rotated on 180 degrees.
    ///</summary>
    on180 = 2;
    ///<summary>
    ///  Rotated on 270 degrees clockwise.
    ///</summary>
    on270 = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Specifies format
  ///</summary>
  [DNTypeName('Aspose.Pdf.SaveFormat')]
  DNSaveFormat = type Integer;
  DNSaveFormatHelper = record helper for DNSaveFormat
  public const
    ///<summary>
    ///  means saving without change of format, i.e. as PDF
    ///  use it please instead of 'SaveFormat.None', that is obsolete one
    ///</summary>
    Pdf = 0;
    ///<summary>
    ///  means saving without change of format, i.e. as PDF
    ///  It's obsolete one and will be deleted eventually,
    ///  please use instead 'SaveFormat.Pdf'
    ///</summary>
    None = 0;
    ///<summary>
    ///  means saving in DOC format
    ///</summary>
    Doc = 1;
    ///<summary>
    ///  means saving in XPS format
    ///</summary>
    Xps = 2;
    ///<summary>
    ///  means saving in HTML format
    ///</summary>
    Html = 3;
    ///<summary>
    ///  means saving in XML format
    ///</summary>
    Xml = 4;
    ///<summary>
    ///  means saving in TEX format i.e. format suitable for Latex text editor
    ///</summary>
    TeX = 5;
    ///<summary>
    ///  means saving in DOCX format
    ///</summary>
    DocX = 6;
    ///<summary>
    ///  means saving in SVG format
    ///</summary>
    Svg = 7;
    ///<summary>
    ///  means saving in MobiXML format(special format of e-books)
    ///</summary>
    MobiXml = 8;
    ///<summary>
    ///  means saving in MsExcel format
    ///</summary>
    Excel = 9;
    ///<summary>
    ///  means saving in EPUB format(special format of e-books)
    ///</summary>
    Epub = 10;
    ///<summary>
    ///  means saving in PPTX format
    ///</summary>
    Pptx = 14;
    ///<summary>
    ///  Saving as APS XML file.
    ///</summary>
    Aps = 15;
    ///<summary>
    ///  Internal PDF document structure in XML format
    ///</summary>
    PdfXml = 16;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Represents line types that can be used in result document for drawing borders or another lines
  ///</summary>
  [DNTypeName('Aspose.Pdf.SaveOptions+HtmlBorderLineType')]
  DNSaveOptions_HtmlBorderLineType = type Integer;
  DNSaveOptions_HtmlBorderLineTypeHelper = record helper for DNSaveOptions_HtmlBorderLineType
  public const
    ///<summary>
    ///  No line will be shown
    ///</summary>
    None = 0;
    ///<summary>
    ///  dotted line will be shown
    ///</summary>
    Dotted = 1;
    ///<summary>
    ///  dashed line will be shown
    ///</summary>
    Dashed = 2;
    ///<summary>
    ///  solid line will be shown
    ///</summary>
    Solid = 3;
    ///<summary>
    ///  double line will be shown
    ///</summary>
    Double = 4;
    ///<summary>
    ///  grove line will be shown
    ///</summary>
    Groove = 5;
    ///<summary>
    ///  ridhe line will be shown
    ///</summary>
    Ridge = 6;
    ///<summary>
    ///  inset line will be shown
    ///</summary>
    Inset = 7;
    ///<summary>
    ///  outset line will be shown
    ///</summary>
    Outset = 8;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  enumerates possible types of saved external resources
  ///</summary>
  [DNTypeName('Aspose.Pdf.SaveOptions+NodeLevelResourceType')]
  DNSaveOptions_NodeLevelResourceType = type Integer;
  DNSaveOptions_NodeLevelResourceTypeHelper = record helper for DNSaveOptions_NodeLevelResourceType
  public const
    ///<summary>
    ///  Means that supplied resource is image
    ///</summary>
    Image = 0;
    ///<summary>
    ///  Means that supplied resource is font
    ///</summary>
    Font = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates conversion engines that can be used for conversion
  ///</summary>
  [DNTypeName('Aspose.Pdf.SvgLoadOptions+ConversionEngines')]
  DNSvgLoadOptions_ConversionEngines = type Integer;
  DNSvgLoadOptions_ConversionEnginesHelper = record helper for DNSvgLoadOptions_ConversionEngines
  public const
    ///<summary>
    ///  Represents legacy SVG to PDF conversion engine.
    ///</summary>
    LegacyEngine = 0;
    ///<summary>
    ///  Represents new SVG to PDF conversion engine.
    ///</summary>
    NewEngine = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  enumerates possible types of image files
  ///  that can be saved as external resources during
  ///  during Pdf to SVG conversion
  ///</summary>
  [DNTypeName('Aspose.Pdf.SvgSaveOptions+SvgExternalImageType')]
  DNSvgSaveOptions_SvgExternalImageType = type Integer;
  DNSvgSaveOptions_SvgExternalImageTypeHelper = record helper for DNSvgSaveOptions_SvgExternalImageType
  public const
    ///<summary>
    ///  Jpeg format
    ///</summary>
    Jpeg = 0;
    ///<summary>
    ///  Png format
    ///</summary>
    Png = 1;
    ///<summary>
    ///  Bmp format
    ///</summary>
    Bmp = 2;
    ///<summary>
    ///  Gif format
    ///</summary>
    Gif = 3;
    ///<summary>
    ///  Tiff format
    ///</summary>
    Tiff = 4;
    ///<summary>
    ///  Unknown - means that converter cannot detect type of content itself
    ///</summary>
    Unknown = 5;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumerates the table broken.
  ///</summary>
  [DNTypeName('Aspose.Pdf.TableBroken')]
  DNTableBroken = type Integer;
  DNTableBrokenHelper = record helper for DNTableBroken
  public const
    ///<summary>
    ///  No broken.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Vertical broken.
    ///</summary>
    Vertical = 1;
    ///<summary>
    ///  Vertical broken in same page.
    ///</summary>
    VerticalInSamePage = 2;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Tab order on the page
  ///</summary>
  [DNTypeName('Aspose.Pdf.TabOrder')]
  DNTabOrder = type Integer;
  DNTabOrderHelper = record helper for DNTabOrder
  public const
    ///<summary>
    ///  No tab order.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Row order.
    ///</summary>
    Row = 1;
    ///<summary>
    ///  Column order.
    ///</summary>
    Column = 2;
    ///<summary>
    ///  Default tab order.
    ///</summary>
    Default_ = 3;
    ///<summary>
    ///  Manual tab order.
    ///</summary>
    Manual = 4;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Specifies style information applied to text.
  ///</summary>
  ///<remarks>
  ///  This enumeration has a <see cref="T:System.FlagsAttribute" />
  ///  attribute that allows a combination of its member values.
  ///</remarks>
  [DNTypeName('Aspose.Pdf.Text.FontStyles')]
  DNFontStyles = type Integer;
  DNFontStylesHelper = record helper for DNFontStyles
  public const
    ///<summary>
    ///  Regular text.
    ///</summary>
    Regular = 0;
    ///<summary>
    ///  Bold text.
    ///</summary>
    Bold = 1;
    ///<summary>
    ///  Italic text.
    ///</summary>
    Italic = 2;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Supported font types enumeration.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.FontTypes')]
  DNFontTypes = type Integer;
  DNFontTypesHelper = record helper for DNFontTypes
  public const
    ///<summary>
    ///  TTF font type
    ///</summary>
    TTF = 0;
    ///<summary>
    ///  OTF font type
    ///</summary>
    OTF = 1;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Represents font categories that can be substituted.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.SubstitutionFontCategories')]
  DNSubstitutionFontCategories = type Integer;
  DNSubstitutionFontCategoriesHelper = record helper for DNSubstitutionFontCategories
  public const
    ///<summary>
    ///  The fonts that are named the same as system fonts.
    ///  Those fonts are mostly safe to be substituted with the same named system fonts.
    ///</summary>
    TheSameNamedEmbeddedFonts = 0;
    ///<summary>
    ///  All embedded fonts are substituted.
    ///</summary>
    AllEmbeddedFonts = 1;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Enumerates the tab alignment types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TabAlignmentType')]
  DNTabAlignmentType = type Integer;
  DNTabAlignmentTypeHelper = record helper for DNTabAlignmentType
  public const
    ///<summary>
    ///  Text aligned left from tab stop
    ///</summary>
    Left = 0;
    ///<summary>
    ///  Text aligned center from tab stop
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Text aligned right from tab stop
    ///</summary>
    Right = 2;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Enumerates the tab leader types.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TabLeaderType')]
  DNTabLeaderType = type Integer;
  DNTabLeaderTypeHelper = record helper for DNTabLeaderType
  public const
    ///<summary>
    ///  Solid tab leader.
    ///</summary>
    Solid = 0;
    ///<summary>
    ///  Dash tab leader.
    ///</summary>
    Dash = 1;
    ///<summary>
    ///  Dot tab leader.
    ///</summary>
    Dot = 2;
    ///<summary>
    ///  No tab leader.
    ///</summary>
    None = 3;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Clipping path processing modes
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextEditOptions+ClippingPathsProcessingMode')]
  DNTextEditOptions_ClippingPathsProcessingMode = type Integer;
  DNTextEditOptions_ClippingPathsProcessingModeHelper = record helper for DNTextEditOptions_ClippingPathsProcessingMode
  public const
    ///<summary>
    ///  Keeps clipping paths of the original page layout. (Default)
    ///</summary>
    KeepIntact = 0;
    ///<summary>
    ///  Original clipping path will be expanded in the case edited text requires more space.
    ///</summary>
    Expand = 1;
    ///<summary>
    ///  Original clipping path will be removed in the case edited text requires more space. Caution: Because of clipping paths may interact with each other removing of it may lead to unexpected result on the page layout.
    ///</summary>
    Remove = 2;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Font replacement behavior.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextEditOptions+FontReplace')]
  DNTextEditOptions_FontReplace = type Integer;
  DNTextEditOptions_FontReplaceHelper = record helper for DNTextEditOptions_FontReplace
  public const
    ///<summary>
    ///  No additional changes performed during font replacement.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Fonts that become unused during font replacement will be removed from resulting document.
    ///</summary>
    RemoveUnusedFonts = 1;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Language transformation modes
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextEditOptions+LanguageTransformation')]
  DNTextEditOptions_LanguageTransformation = type Integer;
  DNTextEditOptions_LanguageTransformationHelper = record helper for DNTextEditOptions_LanguageTransformation
  public const
    ///<summary>
    ///  Default language transformation is performed.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Language transformation is performed the same way as in a text editor. It usually means text will looks in the document exactly as You see it in code. But no warranties.
    ///</summary>
    ExactlyAsISee = 1;
    ///<summary>
    ///  Language transformation is not performed.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Action to perform if font does not contain required character
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextEditOptions+NoCharacterAction')]
  DNTextEditOptions_NoCharacterAction = type Integer;
  DNTextEditOptions_NoCharacterActionHelper = record helper for DNTextEditOptions_NoCharacterAction
  public const
    ///<summary>
    ///  Throw exception
    ///</summary>
    ThrowException = 0;
    ///<summary>
    ///  Repalce font to standard font which contains required character
    ///</summary>
    UseStandardFont = 1;
    ///<summary>
    ///  Replace text anyway without font substitution
    ///</summary>
    ReplaceAnyway = 2;
    ///<summary>
    ///  Repalce font to defined replacement font
    ///</summary>
    UseCustomReplacementFont = 3;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Defines different modes which can be used while converting pdf document into text. See <see cref="!:TextDevice" />
  ///  class.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextExtractionOptions+TextFormattingMode')]
  DNTextExtractionOptions_TextFormattingMode = type Integer;
  DNTextExtractionOptions_TextFormattingModeHelper = record helper for DNTextExtractionOptions_TextFormattingMode
  public const
    ///<summary>
    ///  Represent pdf content with a bit of formatting routines.
    ///</summary>
    Pure = 0;
    ///<summary>
    ///  Represent pdf content as is, i.e. without formatting.
    ///</summary>
    Raw = 1;
    ///<summary>
    ///  Extraction with memory saving. It is almost same to 'Raw' mode but works slightly faster and uses less memory.
    ///</summary>
    MemorySaving = 2;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Defines line spacing specifics
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextFormattingOptions+LineSpacingMode')]
  DNTextFormattingOptions_LineSpacingMode = type Integer;
  DNTextFormattingOptions_LineSpacingModeHelper = record helper for DNTextFormattingOptions_LineSpacingMode
  public const
    ///<summary>
    ///  Line spacing is font size
    ///</summary>
    FontSize = 0;
    ///<summary>
    ///  Line spacing is a full space between descender and ascender
    ///</summary>
    FullSize = 1;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Defines word wrapping strategies
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextFormattingOptions+WordWrapMode')]
  DNTextFormattingOptions_WordWrapMode = type Integer;
  DNTextFormattingOptions_WordWrapModeHelper = record helper for DNTextFormattingOptions_WordWrapMode
  public const
    ///<summary>
    ///  No wrapping is performed
    ///</summary>
    NoWrap = 0;
    ///<summary>
    ///  Discretionary hyphenation is performed. Allows breaking words in the middle.
    ///</summary>
    DiscretionaryHyphenation = 1;
    ///<summary>
    ///  Word wrapping only wraps complete words.
    ///  If the complete word cannot be wrapped, attempts to use discretionary hyphenation
    ///</summary>
    ByWords = 2;
    ///<summary>
    ///  WordWrapMode not set.
    ///  Wrapping strategie of upper level structure (table cell, paragraph etc.) will be used.
    ///</summary>
    Undefined = 3;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  The text rendering mode, Tmode, determines whether showing text shall cause glyph outlines to be stroked, filled, used as a clipping boundary, or some combination of the three.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextRenderingMode')]
  DNTextRenderingMode = type Integer;
  DNTextRenderingModeHelper = record helper for DNTextRenderingMode
  public const
    ///<summary>
    ///  Fill text.
    ///</summary>
    FillText = 0;
    ///<summary>
    ///  Stroke text.
    ///</summary>
    StrokeText = 1;
    ///<summary>
    ///  Fill, then stroke text.
    ///</summary>
    FillThenStrokeText = 2;
    ///<summary>
    ///  Neither fill nor stroke text (invisible).
    ///</summary>
    Invisible = 3;
    ///<summary>
    ///  Fill text and add to path for clipping (see 9.3.6, "Text Rendering Mode,").
    ///</summary>
    FillTextAndAddPathToClipping = 4;
    ///<summary>
    ///  Stroke text and add to path for clipping.
    ///</summary>
    StrokeTextAndAddPathToClipping = 5;
    ///<summary>
    ///  Fill, then stroke text and add to path for clipping.
    ///</summary>
    FillThenStrokeTextAndAddPathToClipping = 6;
    ///<summary>
    ///  Add text to path for clipping.
    ///</summary>
    AddPathToClipping = 7;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Determines action that will be done after replace of text fragment to more short.
  ///  None - no action, replaced text may overlaps rest of the line;
  ///  AdjustSpaceWidth - tries adjust spaces between words to keep line length;
  ///  WholeWordsHyphenation - tries distribute words between paragraph lines to keep paragraph's right field;
  ///  ShiftRestOfLine - shifts rest of the line according to changing length of text, length of the line may be changed;
  ///  Default value is ShiftRestOfLine.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextReplaceOptions+ReplaceAdjustment')]
  DNTextReplaceOptions_ReplaceAdjustment = type Integer;
  DNTextReplaceOptions_ReplaceAdjustmentHelper = record helper for DNTextReplaceOptions_ReplaceAdjustment
  public const
    ///<summary>
    ///  No action, replaced text may overlaps rest of the line
    ///</summary>
    None = 0;
    ///<summary>
    ///  Tries adjust spaces between words to keep line length
    ///</summary>
    AdjustSpaceWidth = 1;
    ///<summary>
    ///  Tries distribute words between paragraph lines to keep paragraph's right field
    ///</summary>
    WholeWordsHyphenation = 2;
    ///<summary>
    ///  (Default) Shifts rest of the line according to changing length of text, length of the line may be changed
    ///</summary>
    ShiftRestOfLine = 4;
  end;


  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Scope where replace text operation is applied
  ///  REPLACE_FIRST by default
  ///  This obsolete option was kept for compatibility. It affects to PdfContentEditor and has no effect to TextFragmentAbsorber.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.TextReplaceOptions+Scope')]
  DNTextReplaceOptions_Scope = type Integer;
  DNTextReplaceOptions_ScopeHelper = record helper for DNTextReplaceOptions_Scope
  public const
    ///<summary>
    ///  Replace only first occurrence of the text on each of affected pages
    ///</summary>
    REPLACE_FIRST = 0;
    ///<summary>
    ///  Replace all text occurrences on all affected pages
    ///</summary>
    REPLACE_ALL = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enumeration of possible vertical alignment values.
  ///</summary>
  [DNTypeName('Aspose.Pdf.VerticalAlignment')]
  DNVerticalAlignment = type Integer;
  DNVerticalAlignmentHelper = record helper for DNVerticalAlignment
  public const
    ///<summary>
    ///  No alignment (use specified position).
    ///</summary>
    None = 0;
    ///<summary>
    ///  Align to top.
    ///</summary>
    Top = 1;
    ///<summary>
    ///  Center alignment.
    ///</summary>
    Center = 2;
    ///<summary>
    ///  Align to bottom.
    ///</summary>
    Bottom = 3;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Enum represented warning type.
  ///</summary>
  [DNTypeName('Aspose.Pdf.WarningType')]
  DNWarningType = type Integer;
  DNWarningTypeHelper = record helper for DNWarningType
  public const
    ///<summary>
    ///  The file is corrupted.
    ///</summary>
    SourceFileCorruption = 0;
    ///<summary>
    ///  Text/chart/image or other data is completely missing from either the documet tree following load, or the created document following save.
    ///</summary>
    DataLoss = 1;
    ///<summary>
    ///  Major formatting losses compared to the original document. This is for occasions when the formatting loss is substantial but the data is still there.
    ///</summary>
    MajorFormattingLoss = 2;
    ///<summary>
    ///  Minor formatting losses compared to the original document. This is for minor losses of fidelity.
    ///</summary>
    MinorFormattingLoss = 3;
    ///<summary>
    ///  Known issue that will prevent the document being opened by certain user agents, or previous versions of user agents.
    ///</summary>
    CompatibilityIssue = 4;
    ///<summary>
    ///  Invalid input stream type
    ///</summary>
    InvalidInputStreamType = 5;
    ///<summary>
    ///  The file has unexpected content.
    ///</summary>
    UnexpectedContent = 99;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This enum represents types of a XMP field.
  ///</summary>
  [DNTypeName('Aspose.Pdf.XmpFieldType')]
  DNXmpFieldType = type Integer;
  DNXmpFieldTypeHelper = record helper for DNXmpFieldType
  public const
    ///<summary>
    ///  This type represents a structure.
    ///</summary>
    Struct = 0;
    ///<summary>
    ///  This type represents a array.
    ///</summary>
    Array_ = 1;
    ///<summary>
    ///  This type represents a property.
    ///</summary>
    Property_ = 2;
    ///<summary>
    ///  This type represents a packet.
    ///</summary>
    Packet = 3;
    ///<summary>
    ///  This field represents an unknown type.
    ///</summary>
    Unknown = 4;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Property category: internal or external.
  ///</summary>
  [DNTypeName('Aspose.Pdf.XmpPdfAExtensionCategoryType')]
  DNXmpPdfAExtensionCategoryType = type Integer;
  DNXmpPdfAExtensionCategoryTypeHelper = record helper for DNXmpPdfAExtensionCategoryType
  public const
    ///<summary>
    ///  Internal properties are created automatically from document content.
    ///</summary>
    Internal = 0;
    ///<summary>
    ///  External properties are based on user input.
    ///</summary>
    External_ = 1;
  end;


  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Source XSLFO document can contain formatting errors. This enum enumerates possible strategies of handling of such formatting errors
  ///</summary>
  [DNTypeName('Aspose.Pdf.XslFoLoadOptions+ParsingErrorsHandlingTypes')]
  DNXslFoLoadOptions_ParsingErrorsHandlingTypes = type Integer;
  DNXslFoLoadOptions_ParsingErrorsHandlingTypesHelper = record helper for DNXslFoLoadOptions_ParsingErrorsHandlingTypes
  public const
    ///<summary>
    ///  In this case converter will be instructed to try proceed
    ///  with conversion and ignore found formatting errors.
    ///  In this case success not guaranteed,
    ///  serious problems can occure later in converter,
    ///  anf in suck case will be thrown exception with list of found
    ///  formatting errors.
    ///</summary>
    TryIgnore = 0;
    ///<summary>
    ///  In this case conversion will be stopped immediately
    ///  and exception will be thrown immediately after detecting
    ///  of first formatting error
    ///</summary>
    ThrowExceptionImmediately = 1;
    ///<summary>
    ///  This is the most agile method - custom code must supply (in WarningCallback property) special
    ///  handler that will  be called when formatting error detected.
    ///  That handler can f.e. log or count errors etc and
    ///  will supply decision whether processing can be continued for this or that error.
    ///</summary>
    InvokeCustomHandler = 2;
  end;




type


{ declares }

  DNIAnnotationVisitor = interface; // type: Aspose.Pdf.Annotations.IAnnotationVisitor, namespace: Aspose.Pdf.Annotations
  DNIAppointment = interface; // type: Aspose.Pdf.Annotations.IAppointment, namespace: Aspose.Pdf.Annotations
  DNDocument_IDocumentFontUtilities = interface; // type: Aspose.Pdf.Document+IDocumentFontUtilities, namespace: Aspose.Pdf
  DNIDocumentPageTextExtractor = interface; // type: Aspose.Pdf.GroupProcessor.IDocumentPageTextExtractor, namespace: Aspose.Pdf.GroupProcessor
  DNIDocumentTextExtractor = interface; // type: Aspose.Pdf.GroupProcessor.IDocumentTextExtractor, namespace: Aspose.Pdf.GroupProcessor
  DNIPdfTypeExtractor = interface; // type: Aspose.Pdf.GroupProcessor.IPdfTypeExtractor, namespace: Aspose.Pdf.GroupProcessor
  DNIColorSpaceConversionStrategy = interface; // type: Aspose.Pdf.IColorSpaceConversionStrategy, namespace: Aspose.Pdf
  DNIIndexBitmapConverter = interface; // type: Aspose.Pdf.IIndexBitmapConverter, namespace: Aspose.Pdf
  DNINamedDestinationCollection = interface; // type: Aspose.Pdf.INamedDestinationCollection, namespace: Aspose.Pdf
  DNIOperatorSelector = interface; // type: Aspose.Pdf.IOperatorSelector, namespace: Aspose.Pdf
  DNIPageSetOptions = interface; // type: Aspose.Pdf.IPageSetOptions, namespace: Aspose.Pdf
  DNIPipelineOptions = interface; // type: Aspose.Pdf.IPipelineOptions, namespace: Aspose.Pdf
  DNIResourceLoadingCallback = interface; // type: Aspose.Pdf.IResourceLoadingCallback, namespace: Aspose.Pdf
  DNIWarningCallback = interface; // type: Aspose.Pdf.IWarningCallback, namespace: Aspose.Pdf
  DNITextElement = interface; // type: Aspose.Pdf.LogicalStructure.ITextElement, namespace: Aspose.Pdf.LogicalStructure
  DNITaggedContent = interface; // type: Aspose.Pdf.Tagged.ITaggedContent, namespace: Aspose.Pdf.Tagged
  DNIFontOptions = interface; // type: Aspose.Pdf.Text.IFontOptions, namespace: Aspose.Pdf.Text
  DNITableElement = interface; // type: Aspose.Pdf.Text.ITableElement, namespace: Aspose.Pdf.Text
  DNIFacade = interface; // type: Aspose.Pdf.Facades.IFacade, namespace: Aspose.Pdf.Facades
  DNISaveableFacade = interface; // type: Aspose.Pdf.Facades.ISaveableFacade, namespace: Aspose.Pdf.Facades
  DNActionCollection = interface; // type: Aspose.Pdf.Annotations.ActionCollection, namespace: Aspose.Pdf.Annotations
  DNAnnotationCollection = interface; // type: Aspose.Pdf.Annotations.AnnotationCollection, namespace: Aspose.Pdf.Annotations
  DNAnnotationSelector = interface; // type: Aspose.Pdf.Annotations.AnnotationSelector, namespace: Aspose.Pdf.Annotations
  DNAppearanceDictionary = interface; // type: Aspose.Pdf.Annotations.AppearanceDictionary, namespace: Aspose.Pdf.Annotations
  DNBorder = interface; // type: Aspose.Pdf.Annotations.Border, namespace: Aspose.Pdf.Annotations
  DNCharacteristics = interface; // type: Aspose.Pdf.Annotations.Characteristics, namespace: Aspose.Pdf.Annotations
  DNDash = interface; // type: Aspose.Pdf.Annotations.Dash, namespace: Aspose.Pdf.Annotations
  DNDefaultAppearance = interface; // type: Aspose.Pdf.Annotations.DefaultAppearance, namespace: Aspose.Pdf.Annotations
  DNDocumentActionCollection = interface; // type: Aspose.Pdf.Annotations.DocumentActionCollection, namespace: Aspose.Pdf.Annotations
  DNExplicitDestination = interface; // type: Aspose.Pdf.Annotations.ExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNCustomExplicitDestination = interface; // type: Aspose.Pdf.Annotations.CustomExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNFitBExplicitDestination = interface; // type: Aspose.Pdf.Annotations.FitBExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNFitBHExplicitDestination = interface; // type: Aspose.Pdf.Annotations.FitBHExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNFitBVExplicitDestination = interface; // type: Aspose.Pdf.Annotations.FitBVExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNFitExplicitDestination = interface; // type: Aspose.Pdf.Annotations.FitExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNFitHExplicitDestination = interface; // type: Aspose.Pdf.Annotations.FitHExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNFitRExplicitDestination = interface; // type: Aspose.Pdf.Annotations.FitRExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNFitVExplicitDestination = interface; // type: Aspose.Pdf.Annotations.FitVExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNXYZExplicitDestination = interface; // type: Aspose.Pdf.Annotations.XYZExplicitDestination, namespace: Aspose.Pdf.Annotations
  DNFixedPrint = interface; // type: Aspose.Pdf.Annotations.FixedPrint, namespace: Aspose.Pdf.Annotations
  DNMeasure = interface; // type: Aspose.Pdf.Annotations.Measure, namespace: Aspose.Pdf.Annotations
  DNMeasure_NumberFormat = interface; // type: Aspose.Pdf.Annotations.Measure+NumberFormat, namespace: Aspose.Pdf.Annotations
  DNMeasure_NumberFormatList = interface; // type: Aspose.Pdf.Annotations.Measure+NumberFormatList, namespace: Aspose.Pdf.Annotations
  DNMediaClip = interface; // type: Aspose.Pdf.Annotations.MediaClip, namespace: Aspose.Pdf.Annotations
  DNMediaClipData = interface; // type: Aspose.Pdf.Annotations.MediaClipData, namespace: Aspose.Pdf.Annotations
  DNMediaClipSection = interface; // type: Aspose.Pdf.Annotations.MediaClipSection, namespace: Aspose.Pdf.Annotations
  DNNamedDestination = interface; // type: Aspose.Pdf.Annotations.NamedDestination, namespace: Aspose.Pdf.Annotations
  DNPDF3DArtwork = interface; // type: Aspose.Pdf.Annotations.PDF3DArtwork, namespace: Aspose.Pdf.Annotations
  DNPDF3DContent = interface; // type: Aspose.Pdf.Annotations.PDF3DContent, namespace: Aspose.Pdf.Annotations
  DNPDF3DCrossSection = interface; // type: Aspose.Pdf.Annotations.PDF3DCrossSection, namespace: Aspose.Pdf.Annotations
  DNPDF3DCrossSectionArray = interface; // type: Aspose.Pdf.Annotations.PDF3DCrossSectionArray, namespace: Aspose.Pdf.Annotations
  DNPDF3DCuttingPlaneOrientation = interface; // type: Aspose.Pdf.Annotations.PDF3DCuttingPlaneOrientation, namespace: Aspose.Pdf.Annotations
  DNPDF3DLightingScheme = interface; // type: Aspose.Pdf.Annotations.PDF3DLightingScheme, namespace: Aspose.Pdf.Annotations
  DNPDF3DRenderMode = interface; // type: Aspose.Pdf.Annotations.PDF3DRenderMode, namespace: Aspose.Pdf.Annotations
  DNPDF3DStream = interface; // type: Aspose.Pdf.Annotations.PDF3DStream, namespace: Aspose.Pdf.Annotations
  DNPDF3DView = interface; // type: Aspose.Pdf.Annotations.PDF3DView, namespace: Aspose.Pdf.Annotations
  DNPDF3DViewArray = interface; // type: Aspose.Pdf.Annotations.PDF3DViewArray, namespace: Aspose.Pdf.Annotations
  DNPdfAction = interface; // type: Aspose.Pdf.Annotations.PdfAction, namespace: Aspose.Pdf.Annotations
  DNGoToAction = interface; // type: Aspose.Pdf.Annotations.GoToAction, namespace: Aspose.Pdf.Annotations
  DNGoToRemoteAction = interface; // type: Aspose.Pdf.Annotations.GoToRemoteAction, namespace: Aspose.Pdf.Annotations
  DNGoToURIAction = interface; // type: Aspose.Pdf.Annotations.GoToURIAction, namespace: Aspose.Pdf.Annotations
  DNHideAction = interface; // type: Aspose.Pdf.Annotations.HideAction, namespace: Aspose.Pdf.Annotations
  DNImportDataAction = interface; // type: Aspose.Pdf.Annotations.ImportDataAction, namespace: Aspose.Pdf.Annotations
  DNJavascriptAction = interface; // type: Aspose.Pdf.Annotations.JavascriptAction, namespace: Aspose.Pdf.Annotations
  DNLaunchAction = interface; // type: Aspose.Pdf.Annotations.LaunchAction, namespace: Aspose.Pdf.Annotations
  DNNamedAction = interface; // type: Aspose.Pdf.Annotations.NamedAction, namespace: Aspose.Pdf.Annotations
  DNRenditionAction = interface; // type: Aspose.Pdf.Annotations.RenditionAction, namespace: Aspose.Pdf.Annotations
  DNSubmitFormAction = interface; // type: Aspose.Pdf.Annotations.SubmitFormAction, namespace: Aspose.Pdf.Annotations
  DNPdfActionCollection = interface; // type: Aspose.Pdf.Annotations.PdfActionCollection, namespace: Aspose.Pdf.Annotations
  DNRendition = interface; // type: Aspose.Pdf.Annotations.Rendition, namespace: Aspose.Pdf.Annotations
  DNMediaRendition = interface; // type: Aspose.Pdf.Annotations.MediaRendition, namespace: Aspose.Pdf.Annotations
  DNSelectorRendition = interface; // type: Aspose.Pdf.Annotations.SelectorRendition, namespace: Aspose.Pdf.Annotations
  DNSoundData = interface; // type: Aspose.Pdf.Annotations.SoundData, namespace: Aspose.Pdf.Annotations
  DNSoundSampleData = interface; // type: Aspose.Pdf.Annotations.SoundSampleData, namespace: Aspose.Pdf.Annotations
  DNTextStyle = interface; // type: Aspose.Pdf.Annotations.TextStyle, namespace: Aspose.Pdf.Annotations
  DNXfdfReader = interface; // type: Aspose.Pdf.Annotations.XfdfReader, namespace: Aspose.Pdf.Annotations
  DNArtifact = interface; // type: Aspose.Pdf.Artifact, namespace: Aspose.Pdf
  DNBackgroundArtifact = interface; // type: Aspose.Pdf.BackgroundArtifact, namespace: Aspose.Pdf
  DNFooterArtifact = interface; // type: Aspose.Pdf.FooterArtifact, namespace: Aspose.Pdf
  DNHeaderArtifact = interface; // type: Aspose.Pdf.HeaderArtifact, namespace: Aspose.Pdf
  DNWatermarkArtifact = interface; // type: Aspose.Pdf.WatermarkArtifact, namespace: Aspose.Pdf
  DNArtifactCollection = interface; // type: Aspose.Pdf.ArtifactCollection, namespace: Aspose.Pdf
  DNBaseActionCollection = interface; // type: Aspose.Pdf.BaseActionCollection, namespace: Aspose.Pdf
  DNAnnotationActionCollection = interface; // type: Aspose.Pdf.Annotations.AnnotationActionCollection, namespace: Aspose.Pdf.Annotations
  DNPageActionCollection = interface; // type: Aspose.Pdf.PageActionCollection, namespace: Aspose.Pdf
  DNBaseOperatorCollection = interface; // type: Aspose.Pdf.BaseOperatorCollection, namespace: Aspose.Pdf
  DNOperatorCollection = interface; // type: Aspose.Pdf.OperatorCollection, namespace: Aspose.Pdf
  DNBaseParagraph = interface; // type: Aspose.Pdf.BaseParagraph, namespace: Aspose.Pdf
  DNAnnotation = interface; // type: Aspose.Pdf.Annotations.Annotation, namespace: Aspose.Pdf.Annotations
  DNLinkAnnotation = interface; // type: Aspose.Pdf.Annotations.LinkAnnotation, namespace: Aspose.Pdf.Annotations
  DNMarkupAnnotation = interface; // type: Aspose.Pdf.Annotations.MarkupAnnotation, namespace: Aspose.Pdf.Annotations
  DNCaretAnnotation = interface; // type: Aspose.Pdf.Annotations.CaretAnnotation, namespace: Aspose.Pdf.Annotations
  DNCommonFigureAnnotation = interface; // type: Aspose.Pdf.Annotations.CommonFigureAnnotation, namespace: Aspose.Pdf.Annotations
  DNCircleAnnotation = interface; // type: Aspose.Pdf.Annotations.CircleAnnotation, namespace: Aspose.Pdf.Annotations
  DNSquareAnnotation = interface; // type: Aspose.Pdf.Annotations.SquareAnnotation, namespace: Aspose.Pdf.Annotations
  DNFileAttachmentAnnotation = interface; // type: Aspose.Pdf.Annotations.FileAttachmentAnnotation, namespace: Aspose.Pdf.Annotations
  DNFreeTextAnnotation = interface; // type: Aspose.Pdf.Annotations.FreeTextAnnotation, namespace: Aspose.Pdf.Annotations
  DNInkAnnotation = interface; // type: Aspose.Pdf.Annotations.InkAnnotation, namespace: Aspose.Pdf.Annotations
  DNLineAnnotation = interface; // type: Aspose.Pdf.Annotations.LineAnnotation, namespace: Aspose.Pdf.Annotations
  DNPolyAnnotation = interface; // type: Aspose.Pdf.Annotations.PolyAnnotation, namespace: Aspose.Pdf.Annotations
  DNPolygonAnnotation = interface; // type: Aspose.Pdf.Annotations.PolygonAnnotation, namespace: Aspose.Pdf.Annotations
  DNPolylineAnnotation = interface; // type: Aspose.Pdf.Annotations.PolylineAnnotation, namespace: Aspose.Pdf.Annotations
  DNRedactionAnnotation = interface; // type: Aspose.Pdf.Annotations.RedactionAnnotation, namespace: Aspose.Pdf.Annotations
  DNSoundAnnotation = interface; // type: Aspose.Pdf.Annotations.SoundAnnotation, namespace: Aspose.Pdf.Annotations
  DNStampAnnotation = interface; // type: Aspose.Pdf.Annotations.StampAnnotation, namespace: Aspose.Pdf.Annotations
  DNTextAnnotation = interface; // type: Aspose.Pdf.Annotations.TextAnnotation, namespace: Aspose.Pdf.Annotations
  DNTextMarkupAnnotation = interface; // type: Aspose.Pdf.Annotations.TextMarkupAnnotation, namespace: Aspose.Pdf.Annotations
  DNHighlightAnnotation = interface; // type: Aspose.Pdf.Annotations.HighlightAnnotation, namespace: Aspose.Pdf.Annotations
  DNSquigglyAnnotation = interface; // type: Aspose.Pdf.Annotations.SquigglyAnnotation, namespace: Aspose.Pdf.Annotations
  DNStrikeOutAnnotation = interface; // type: Aspose.Pdf.Annotations.StrikeOutAnnotation, namespace: Aspose.Pdf.Annotations
  DNUnderlineAnnotation = interface; // type: Aspose.Pdf.Annotations.UnderlineAnnotation, namespace: Aspose.Pdf.Annotations
  DNMovieAnnotation = interface; // type: Aspose.Pdf.Annotations.MovieAnnotation, namespace: Aspose.Pdf.Annotations
  DNPDF3DAnnotation = interface; // type: Aspose.Pdf.Annotations.PDF3DAnnotation, namespace: Aspose.Pdf.Annotations
  DNPopupAnnotation = interface; // type: Aspose.Pdf.Annotations.PopupAnnotation, namespace: Aspose.Pdf.Annotations
  DNRichMediaAnnotation = interface; // type: Aspose.Pdf.Annotations.RichMediaAnnotation, namespace: Aspose.Pdf.Annotations
  DNScreenAnnotation = interface; // type: Aspose.Pdf.Annotations.ScreenAnnotation, namespace: Aspose.Pdf.Annotations
  DNWatermarkAnnotation = interface; // type: Aspose.Pdf.Annotations.WatermarkAnnotation, namespace: Aspose.Pdf.Annotations
  DNWidgetAnnotation = interface; // type: Aspose.Pdf.Annotations.WidgetAnnotation, namespace: Aspose.Pdf.Annotations
  DNField = interface; // type: Aspose.Pdf.Forms.Field, namespace: Aspose.Pdf.Forms
  DNButtonField = interface; // type: Aspose.Pdf.Forms.ButtonField, namespace: Aspose.Pdf.Forms
  DNCheckboxField = interface; // type: Aspose.Pdf.Forms.CheckboxField, namespace: Aspose.Pdf.Forms
  DNChoiceField = interface; // type: Aspose.Pdf.Forms.ChoiceField, namespace: Aspose.Pdf.Forms
  DNComboBoxField = interface; // type: Aspose.Pdf.Forms.ComboBoxField, namespace: Aspose.Pdf.Forms
  DNListBoxField = interface; // type: Aspose.Pdf.Forms.ListBoxField, namespace: Aspose.Pdf.Forms
  DNRadioButtonField = interface; // type: Aspose.Pdf.Forms.RadioButtonField, namespace: Aspose.Pdf.Forms
  DNRadioButtonOptionField = interface; // type: Aspose.Pdf.Forms.RadioButtonOptionField, namespace: Aspose.Pdf.Forms
  DNSignatureField = interface; // type: Aspose.Pdf.Forms.SignatureField, namespace: Aspose.Pdf.Forms
  DNTextBoxField = interface; // type: Aspose.Pdf.Forms.TextBoxField, namespace: Aspose.Pdf.Forms
  DNBarcodeField = interface; // type: Aspose.Pdf.Forms.BarcodeField, namespace: Aspose.Pdf.Forms
  DNFileSelectBoxField = interface; // type: Aspose.Pdf.Forms.FileSelectBoxField, namespace: Aspose.Pdf.Forms
  DNPasswordBoxField = interface; // type: Aspose.Pdf.Forms.PasswordBoxField, namespace: Aspose.Pdf.Forms
  DNRichTextBoxField = interface; // type: Aspose.Pdf.Forms.RichTextBoxField, namespace: Aspose.Pdf.Forms
  DNGraph = interface; // type: Aspose.Pdf.Drawing.Graph, namespace: Aspose.Pdf.Drawing
  DNFloatingBox = interface; // type: Aspose.Pdf.FloatingBox, namespace: Aspose.Pdf
  DNFormattedFragment = interface; // type: Aspose.Pdf.FormattedFragment, namespace: Aspose.Pdf
  DNHtmlFragment = interface; // type: Aspose.Pdf.HtmlFragment, namespace: Aspose.Pdf
  DNTeXFragment = interface; // type: Aspose.Pdf.TeXFragment, namespace: Aspose.Pdf
  DNLatexFragment = interface; // type: Aspose.Pdf.LatexFragment, namespace: Aspose.Pdf
  DNImage = interface; // type: Aspose.Pdf.Image, namespace: Aspose.Pdf
  DNTable = interface; // type: Aspose.Pdf.Table, namespace: Aspose.Pdf
  DNTextFragment = interface; // type: Aspose.Pdf.Text.TextFragment, namespace: Aspose.Pdf.Text
  DNHeading = interface; // type: Aspose.Pdf.Heading, namespace: Aspose.Pdf
  DNBorderInfo = interface; // type: Aspose.Pdf.BorderInfo, namespace: Aspose.Pdf
  DNBuildVersionInfo = interface; // type: Aspose.Pdf.BuildVersionInfo, namespace: Aspose.Pdf
  DNCell = interface; // type: Aspose.Pdf.Cell, namespace: Aspose.Pdf
  DNCells = interface; // type: Aspose.Pdf.Cells, namespace: Aspose.Pdf
  DNColor = interface; // type: Aspose.Pdf.Color, namespace: Aspose.Pdf
  DNColumnInfo = interface; // type: Aspose.Pdf.ColumnInfo, namespace: Aspose.Pdf
  DNComHelper = interface; // type: Aspose.Pdf.ComHelper, namespace: Aspose.Pdf
  DNCompositingParameters = interface; // type: Aspose.Pdf.CompositingParameters, namespace: Aspose.Pdf
  DNDestinationCollection = interface; // type: Aspose.Pdf.DestinationCollection, namespace: Aspose.Pdf
  DNDevice = interface; // type: Aspose.Pdf.Devices.Device, namespace: Aspose.Pdf.Devices
  DNDocumentDevice = interface; // type: Aspose.Pdf.Devices.DocumentDevice, namespace: Aspose.Pdf.Devices
  DNTiffDevice = interface; // type: Aspose.Pdf.Devices.TiffDevice, namespace: Aspose.Pdf.Devices
  DNPageDevice = interface; // type: Aspose.Pdf.Devices.PageDevice, namespace: Aspose.Pdf.Devices
  DNImageDevice = interface; // type: Aspose.Pdf.Devices.ImageDevice, namespace: Aspose.Pdf.Devices
  DNBmpDevice = interface; // type: Aspose.Pdf.Devices.BmpDevice, namespace: Aspose.Pdf.Devices
  DNEmfDevice = interface; // type: Aspose.Pdf.Devices.EmfDevice, namespace: Aspose.Pdf.Devices
  DNGifDevice = interface; // type: Aspose.Pdf.Devices.GifDevice, namespace: Aspose.Pdf.Devices
  DNJpegDevice = interface; // type: Aspose.Pdf.Devices.JpegDevice, namespace: Aspose.Pdf.Devices
  DNPngDevice = interface; // type: Aspose.Pdf.Devices.PngDevice, namespace: Aspose.Pdf.Devices
  DNTextDevice = interface; // type: Aspose.Pdf.Devices.TextDevice, namespace: Aspose.Pdf.Devices
  DNMargins = interface; // type: Aspose.Pdf.Devices.Margins, namespace: Aspose.Pdf.Devices
  DNResolution = interface; // type: Aspose.Pdf.Devices.Resolution, namespace: Aspose.Pdf.Devices
  DNTiffSettings = interface; // type: Aspose.Pdf.Devices.TiffSettings, namespace: Aspose.Pdf.Devices
  DNDocument = interface; // type: Aspose.Pdf.Document, namespace: Aspose.Pdf
  DNDocumentFactory = interface; // type: Aspose.Pdf.DocumentFactory, namespace: Aspose.Pdf
  DNPatternColorSpace = interface; // type: Aspose.Pdf.Drawing.PatternColorSpace, namespace: Aspose.Pdf.Drawing
  DNGradientAxialShading = interface; // type: Aspose.Pdf.Drawing.GradientAxialShading, namespace: Aspose.Pdf.Drawing
  DNGradientRadialShading = interface; // type: Aspose.Pdf.Drawing.GradientRadialShading, namespace: Aspose.Pdf.Drawing
  DNShape = interface; // type: Aspose.Pdf.Drawing.Shape, namespace: Aspose.Pdf.Drawing
  DNArc = interface; // type: Aspose.Pdf.Drawing.Arc, namespace: Aspose.Pdf.Drawing
  DNCircle = interface; // type: Aspose.Pdf.Drawing.Circle, namespace: Aspose.Pdf.Drawing
  DNCurve = interface; // type: Aspose.Pdf.Drawing.Curve, namespace: Aspose.Pdf.Drawing
  DNEllipse = interface; // type: Aspose.Pdf.Drawing.Ellipse, namespace: Aspose.Pdf.Drawing
  DNLine = interface; // type: Aspose.Pdf.Drawing.Line, namespace: Aspose.Pdf.Drawing
  DNPath = interface; // type: Aspose.Pdf.Drawing.Path, namespace: Aspose.Pdf.Drawing
  DNDrawing_Rectangle = interface; // type: Aspose.Pdf.Drawing.Rectangle, namespace: Aspose.Pdf.Drawing
  DNEmbeddedFileCollection = interface; // type: Aspose.Pdf.EmbeddedFileCollection, namespace: Aspose.Pdf
  DNCollection = interface; // type: Aspose.Pdf.Collection, namespace: Aspose.Pdf
  DNEncryptedPayload = interface; // type: Aspose.Pdf.EncryptedPayload, namespace: Aspose.Pdf
  DNAlignmentType = interface; // type: Aspose.Pdf.Facades.AlignmentType, namespace: Aspose.Pdf.Facades
  DNAutoFiller = interface; // type: Aspose.Pdf.Facades.AutoFiller, namespace: Aspose.Pdf.Facades
  DNBookmark = interface; // type: Aspose.Pdf.Facades.Bookmark, namespace: Aspose.Pdf.Facades
  DNDocumentPrivilege = interface; // type: Aspose.Pdf.Facades.DocumentPrivilege, namespace: Aspose.Pdf.Facades
  DNFacade = interface; // type: Aspose.Pdf.Facades.Facade, namespace: Aspose.Pdf.Facades
  DNPdfConverter = interface; // type: Aspose.Pdf.Facades.PdfConverter, namespace: Aspose.Pdf.Facades
  DNPdfExtractor = interface; // type: Aspose.Pdf.Facades.PdfExtractor, namespace: Aspose.Pdf.Facades
  DNSaveableFacade = interface; // type: Aspose.Pdf.Facades.SaveableFacade, namespace: Aspose.Pdf.Facades
  DNFacades_Form = interface; // type: Aspose.Pdf.Facades.Form, namespace: Aspose.Pdf.Facades
  DNFormEditor = interface; // type: Aspose.Pdf.Facades.FormEditor, namespace: Aspose.Pdf.Facades
  DNPdfAnnotationEditor = interface; // type: Aspose.Pdf.Facades.PdfAnnotationEditor, namespace: Aspose.Pdf.Facades
  DNPdfBookmarkEditor = interface; // type: Aspose.Pdf.Facades.PdfBookmarkEditor, namespace: Aspose.Pdf.Facades
  DNPdfContentEditor = interface; // type: Aspose.Pdf.Facades.PdfContentEditor, namespace: Aspose.Pdf.Facades
  DNPdfFileInfo = interface; // type: Aspose.Pdf.Facades.PdfFileInfo, namespace: Aspose.Pdf.Facades
  DNPdfFileMend = interface; // type: Aspose.Pdf.Facades.PdfFileMend, namespace: Aspose.Pdf.Facades
  DNPdfFileSecurity = interface; // type: Aspose.Pdf.Facades.PdfFileSecurity, namespace: Aspose.Pdf.Facades
  DNPdfFileSignature = interface; // type: Aspose.Pdf.Facades.PdfFileSignature, namespace: Aspose.Pdf.Facades
  DNPdfFileStamp = interface; // type: Aspose.Pdf.Facades.PdfFileStamp, namespace: Aspose.Pdf.Facades
  DNPdfPageEditor = interface; // type: Aspose.Pdf.Facades.PdfPageEditor, namespace: Aspose.Pdf.Facades
  DNPdfXmpMetadata = interface; // type: Aspose.Pdf.Facades.PdfXmpMetadata, namespace: Aspose.Pdf.Facades
  DNFontColor = interface; // type: Aspose.Pdf.Facades.FontColor, namespace: Aspose.Pdf.Facades
  DNForm_FormImportResult = interface; // type: Aspose.Pdf.Facades.Form+FormImportResult, namespace: Aspose.Pdf.Facades
  DNFormattedText = interface; // type: Aspose.Pdf.Facades.FormattedText, namespace: Aspose.Pdf.Facades
  DNFormDataConverter = interface; // type: Aspose.Pdf.Facades.FormDataConverter, namespace: Aspose.Pdf.Facades
  DNFormFieldFacade = interface; // type: Aspose.Pdf.Facades.FormFieldFacade, namespace: Aspose.Pdf.Facades
  DNLineInfo = interface; // type: Aspose.Pdf.Facades.LineInfo, namespace: Aspose.Pdf.Facades
  DNPdfFileEditor = interface; // type: Aspose.Pdf.Facades.PdfFileEditor, namespace: Aspose.Pdf.Facades
  DNPdfFileEditor_ContentsResizeParameters = interface; // type: Aspose.Pdf.Facades.PdfFileEditor+ContentsResizeParameters, namespace: Aspose.Pdf.Facades
  DNPdfFileEditor_ContentsResizeValue = interface; // type: Aspose.Pdf.Facades.PdfFileEditor+ContentsResizeValue, namespace: Aspose.Pdf.Facades
  DNPdfFileEditor_CorruptedItem = interface; // type: Aspose.Pdf.Facades.PdfFileEditor+CorruptedItem, namespace: Aspose.Pdf.Facades
  DNPdfFileEditor_PageBreak = interface; // type: Aspose.Pdf.Facades.PdfFileEditor+PageBreak, namespace: Aspose.Pdf.Facades
  DNPdfJavaScriptStripper = interface; // type: Aspose.Pdf.Facades.PdfJavaScriptStripper, namespace: Aspose.Pdf.Facades
  DNPdfPrintPageInfo = interface; // type: Aspose.Pdf.Facades.PdfPrintPageInfo, namespace: Aspose.Pdf.Facades
  DNPdfProducer = interface; // type: Aspose.Pdf.Facades.PdfProducer, namespace: Aspose.Pdf.Facades
  DNPdfViewer = interface; // type: Aspose.Pdf.Facades.PdfViewer, namespace: Aspose.Pdf.Facades
  DNReplaceTextStrategy = interface; // type: Aspose.Pdf.Facades.ReplaceTextStrategy, namespace: Aspose.Pdf.Facades
  DNFacades_Stamp = interface; // type: Aspose.Pdf.Facades.Stamp, namespace: Aspose.Pdf.Facades
  DNStampInfo = interface; // type: Aspose.Pdf.Facades.StampInfo, namespace: Aspose.Pdf.Facades
  DNTextProperties = interface; // type: Aspose.Pdf.Facades.TextProperties, namespace: Aspose.Pdf.Facades
  DNVerticalAlignmentType = interface; // type: Aspose.Pdf.Facades.VerticalAlignmentType, namespace: Aspose.Pdf.Facades
  DNViewerPreference = interface; // type: Aspose.Pdf.Facades.ViewerPreference, namespace: Aspose.Pdf.Facades
  DNFileParams = interface; // type: Aspose.Pdf.FileParams, namespace: Aspose.Pdf
  DNFileSpecification = interface; // type: Aspose.Pdf.FileSpecification, namespace: Aspose.Pdf
  DNDocMDPSignature = interface; // type: Aspose.Pdf.Forms.DocMDPSignature, namespace: Aspose.Pdf.Forms
  DNForms_Form = interface; // type: Aspose.Pdf.Forms.Form, namespace: Aspose.Pdf.Forms
  DNForm_FlattenSettings = interface; // type: Aspose.Pdf.Forms.Form+FlattenSettings, namespace: Aspose.Pdf.Forms
  DNIconFit = interface; // type: Aspose.Pdf.Forms.IconFit, namespace: Aspose.Pdf.Forms
  DNOption = interface; // type: Aspose.Pdf.Forms.Option, namespace: Aspose.Pdf.Forms
  DNOptionCollection = interface; // type: Aspose.Pdf.Forms.OptionCollection, namespace: Aspose.Pdf.Forms
  DNSignature = interface; // type: Aspose.Pdf.Forms.Signature, namespace: Aspose.Pdf.Forms
  DNExternalSignature = interface; // type: Aspose.Pdf.Forms.ExternalSignature, namespace: Aspose.Pdf.Forms
  DNPKCS1 = interface; // type: Aspose.Pdf.Forms.PKCS1, namespace: Aspose.Pdf.Forms
  DNPKCS7 = interface; // type: Aspose.Pdf.Forms.PKCS7, namespace: Aspose.Pdf.Forms
  DNPKCS7Detached = interface; // type: Aspose.Pdf.Forms.PKCS7Detached, namespace: Aspose.Pdf.Forms
  DNSignatureCustomAppearance = interface; // type: Aspose.Pdf.Forms.SignatureCustomAppearance, namespace: Aspose.Pdf.Forms
  DNXFA = interface; // type: Aspose.Pdf.Forms.XFA, namespace: Aspose.Pdf.Forms
  DNGraphInfo = interface; // type: Aspose.Pdf.GraphInfo, namespace: Aspose.Pdf
  DNGroup = interface; // type: Aspose.Pdf.Group, namespace: Aspose.Pdf
  DNPdfTypeObjectCreator = interface; // type: Aspose.Pdf.GroupProcessor.Creators.PdfTypeObjectCreator, namespace: Aspose.Pdf.GroupProcessor.Creators
  DNExtractorFactory = interface; // type: Aspose.Pdf.GroupProcessor.ExtractorFactory, namespace: Aspose.Pdf.GroupProcessor
  DNHeaderFooter = interface; // type: Aspose.Pdf.HeaderFooter, namespace: Aspose.Pdf
  DNHtmlSaveOptions_CssSavingInfo = interface; // type: Aspose.Pdf.HtmlSaveOptions+CssSavingInfo, namespace: Aspose.Pdf
  DNHtmlSaveOptions_CssUrlRequestInfo = interface; // type: Aspose.Pdf.HtmlSaveOptions+CssUrlRequestInfo, namespace: Aspose.Pdf
  DNHtmlSaveOptions_HtmlPageMarkupSavingInfo = interface; // type: Aspose.Pdf.HtmlSaveOptions+HtmlPageMarkupSavingInfo, namespace: Aspose.Pdf
  DNHyperlink = interface; // type: Aspose.Pdf.Hyperlink, namespace: Aspose.Pdf
  DNFileHyperlink = interface; // type: Aspose.Pdf.FileHyperlink, namespace: Aspose.Pdf
  DNLocalHyperlink = interface; // type: Aspose.Pdf.LocalHyperlink, namespace: Aspose.Pdf
  DNWebHyperlink = interface; // type: Aspose.Pdf.WebHyperlink, namespace: Aspose.Pdf
  DNPdf_Id = interface; // type: Aspose.Pdf.Id, namespace: Aspose.Pdf
  DNImagePlacement = interface; // type: Aspose.Pdf.ImagePlacement, namespace: Aspose.Pdf
  DNImagePlacementAbsorber = interface; // type: Aspose.Pdf.ImagePlacementAbsorber, namespace: Aspose.Pdf
  DNImagePlacementCollection = interface; // type: Aspose.Pdf.ImagePlacementCollection, namespace: Aspose.Pdf
  DNImportOptions = interface; // type: Aspose.Pdf.ImportOptions, namespace: Aspose.Pdf
  DNCgmImportOptions = interface; // type: Aspose.Pdf.CgmImportOptions, namespace: Aspose.Pdf
  DNJavaScriptCollection = interface; // type: Aspose.Pdf.JavaScriptCollection, namespace: Aspose.Pdf
  DNLayer = interface; // type: Aspose.Pdf.Layer, namespace: Aspose.Pdf
  DNLevelFormat = interface; // type: Aspose.Pdf.LevelFormat, namespace: Aspose.Pdf
  DNLicense = interface; // type: Aspose.Pdf.License, namespace: Aspose.Pdf
  DNLoadOptions = interface; // type: Aspose.Pdf.LoadOptions, namespace: Aspose.Pdf
  DNApsLoadOptions = interface; // type: Aspose.Pdf.ApsLoadOptions, namespace: Aspose.Pdf
  DNCgmLoadOptions = interface; // type: Aspose.Pdf.CgmLoadOptions, namespace: Aspose.Pdf
  DNEpubLoadOptions = interface; // type: Aspose.Pdf.EpubLoadOptions, namespace: Aspose.Pdf
  DNHtmlLoadOptions = interface; // type: Aspose.Pdf.HtmlLoadOptions, namespace: Aspose.Pdf
  DNMdLoadOptions = interface; // type: Aspose.Pdf.MdLoadOptions, namespace: Aspose.Pdf
  DNMhtLoadOptions = interface; // type: Aspose.Pdf.MhtLoadOptions, namespace: Aspose.Pdf
  DNPclLoadOptions = interface; // type: Aspose.Pdf.PclLoadOptions, namespace: Aspose.Pdf
  DNPdfXmlLoadOptions = interface; // type: Aspose.Pdf.PdfXmlLoadOptions, namespace: Aspose.Pdf
  DNPsLoadOptions = interface; // type: Aspose.Pdf.PsLoadOptions, namespace: Aspose.Pdf
  DNSvgLoadOptions = interface; // type: Aspose.Pdf.SvgLoadOptions, namespace: Aspose.Pdf
  DNTeXLoadOptions = interface; // type: Aspose.Pdf.TeXLoadOptions, namespace: Aspose.Pdf
  DNLatexLoadOptions = interface; // type: Aspose.Pdf.LatexLoadOptions, namespace: Aspose.Pdf
  DNTxtLoadOptions = interface; // type: Aspose.Pdf.TxtLoadOptions, namespace: Aspose.Pdf
  DNXmlLoadOptions = interface; // type: Aspose.Pdf.XmlLoadOptions, namespace: Aspose.Pdf
  DNXslFoLoadOptions = interface; // type: Aspose.Pdf.XslFoLoadOptions, namespace: Aspose.Pdf
  DNXpsLoadOptions = interface; // type: Aspose.Pdf.XpsLoadOptions, namespace: Aspose.Pdf
  DNLoadOptions_ResourceLoadingResult = interface; // type: Aspose.Pdf.LoadOptions+ResourceLoadingResult, namespace: Aspose.Pdf
  DNAttributeKey = interface; // type: Aspose.Pdf.LogicalStructure.AttributeKey, namespace: Aspose.Pdf.LogicalStructure
  DNAttributeName = interface; // type: Aspose.Pdf.LogicalStructure.AttributeName, namespace: Aspose.Pdf.LogicalStructure
  DNAttributeOwnerStandard = interface; // type: Aspose.Pdf.LogicalStructure.AttributeOwnerStandard, namespace: Aspose.Pdf.LogicalStructure
  DNLogicalStructure_Element = interface; // type: Aspose.Pdf.LogicalStructure.Element, namespace: Aspose.Pdf.LogicalStructure
  DNMCRElement = interface; // type: Aspose.Pdf.LogicalStructure.MCRElement, namespace: Aspose.Pdf.LogicalStructure
  DNOBJRElement = interface; // type: Aspose.Pdf.LogicalStructure.OBJRElement, namespace: Aspose.Pdf.LogicalStructure
  DNStructTreeRootElement = interface; // type: Aspose.Pdf.LogicalStructure.StructTreeRootElement, namespace: Aspose.Pdf.LogicalStructure
  DNStructureElement = interface; // type: Aspose.Pdf.LogicalStructure.StructureElement, namespace: Aspose.Pdf.LogicalStructure
  DNBLSElement = interface; // type: Aspose.Pdf.LogicalStructure.BLSElement, namespace: Aspose.Pdf.LogicalStructure
  DNBLSTextElement = interface; // type: Aspose.Pdf.LogicalStructure.BLSTextElement, namespace: Aspose.Pdf.LogicalStructure
  DNHeaderElement = interface; // type: Aspose.Pdf.LogicalStructure.HeaderElement, namespace: Aspose.Pdf.LogicalStructure
  DNParagraphElement = interface; // type: Aspose.Pdf.LogicalStructure.ParagraphElement, namespace: Aspose.Pdf.LogicalStructure
  DNListElement = interface; // type: Aspose.Pdf.LogicalStructure.ListElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableElement = interface; // type: Aspose.Pdf.LogicalStructure.TableElement, namespace: Aspose.Pdf.LogicalStructure
  DNGroupingElement = interface; // type: Aspose.Pdf.LogicalStructure.GroupingElement, namespace: Aspose.Pdf.LogicalStructure
  DNArtElement = interface; // type: Aspose.Pdf.LogicalStructure.ArtElement, namespace: Aspose.Pdf.LogicalStructure
  DNBlockQuoteElement = interface; // type: Aspose.Pdf.LogicalStructure.BlockQuoteElement, namespace: Aspose.Pdf.LogicalStructure
  DNCaptionElement = interface; // type: Aspose.Pdf.LogicalStructure.CaptionElement, namespace: Aspose.Pdf.LogicalStructure
  DNDivElement = interface; // type: Aspose.Pdf.LogicalStructure.DivElement, namespace: Aspose.Pdf.LogicalStructure
  DNDocumentElement = interface; // type: Aspose.Pdf.LogicalStructure.DocumentElement, namespace: Aspose.Pdf.LogicalStructure
  DNIndexElement = interface; // type: Aspose.Pdf.LogicalStructure.IndexElement, namespace: Aspose.Pdf.LogicalStructure
  DNNonStructElement = interface; // type: Aspose.Pdf.LogicalStructure.NonStructElement, namespace: Aspose.Pdf.LogicalStructure
  DNPartElement = interface; // type: Aspose.Pdf.LogicalStructure.PartElement, namespace: Aspose.Pdf.LogicalStructure
  DNPrivateElement = interface; // type: Aspose.Pdf.LogicalStructure.PrivateElement, namespace: Aspose.Pdf.LogicalStructure
  DNSectElement = interface; // type: Aspose.Pdf.LogicalStructure.SectElement, namespace: Aspose.Pdf.LogicalStructure
  DNTOCElement = interface; // type: Aspose.Pdf.LogicalStructure.TOCElement, namespace: Aspose.Pdf.LogicalStructure
  DNTOCIElement = interface; // type: Aspose.Pdf.LogicalStructure.TOCIElement, namespace: Aspose.Pdf.LogicalStructure
  DNIllustrationElement = interface; // type: Aspose.Pdf.LogicalStructure.IllustrationElement, namespace: Aspose.Pdf.LogicalStructure
  DNLogicalStructure_FigureElement = interface; // type: Aspose.Pdf.LogicalStructure.FigureElement, namespace: Aspose.Pdf.LogicalStructure
  DNFormElement = interface; // type: Aspose.Pdf.LogicalStructure.FormElement, namespace: Aspose.Pdf.LogicalStructure
  DNFormulaElement = interface; // type: Aspose.Pdf.LogicalStructure.FormulaElement, namespace: Aspose.Pdf.LogicalStructure
  DNILSElement = interface; // type: Aspose.Pdf.LogicalStructure.ILSElement, namespace: Aspose.Pdf.LogicalStructure
  DNAnnotationElement = interface; // type: Aspose.Pdf.LogicalStructure.AnnotationElement, namespace: Aspose.Pdf.LogicalStructure
  DNAnnotElement = interface; // type: Aspose.Pdf.LogicalStructure.AnnotElement, namespace: Aspose.Pdf.LogicalStructure
  DNLinkElement = interface; // type: Aspose.Pdf.LogicalStructure.LinkElement, namespace: Aspose.Pdf.LogicalStructure
  DNBibEntryElement = interface; // type: Aspose.Pdf.LogicalStructure.BibEntryElement, namespace: Aspose.Pdf.LogicalStructure
  DNILSTextElement = interface; // type: Aspose.Pdf.LogicalStructure.ILSTextElement, namespace: Aspose.Pdf.LogicalStructure
  DNCodeElement = interface; // type: Aspose.Pdf.LogicalStructure.CodeElement, namespace: Aspose.Pdf.LogicalStructure
  DNNoteElement = interface; // type: Aspose.Pdf.LogicalStructure.NoteElement, namespace: Aspose.Pdf.LogicalStructure
  DNQuoteElement = interface; // type: Aspose.Pdf.LogicalStructure.QuoteElement, namespace: Aspose.Pdf.LogicalStructure
  DNSpanElement = interface; // type: Aspose.Pdf.LogicalStructure.SpanElement, namespace: Aspose.Pdf.LogicalStructure
  DNReferenceElement = interface; // type: Aspose.Pdf.LogicalStructure.ReferenceElement, namespace: Aspose.Pdf.LogicalStructure
  DNRubyElement = interface; // type: Aspose.Pdf.LogicalStructure.RubyElement, namespace: Aspose.Pdf.LogicalStructure
  DNWarichuElement = interface; // type: Aspose.Pdf.LogicalStructure.WarichuElement, namespace: Aspose.Pdf.LogicalStructure
  DNListChildElement = interface; // type: Aspose.Pdf.LogicalStructure.ListChildElement, namespace: Aspose.Pdf.LogicalStructure
  DNListLblElement = interface; // type: Aspose.Pdf.LogicalStructure.ListLblElement, namespace: Aspose.Pdf.LogicalStructure
  DNListLBodyElement = interface; // type: Aspose.Pdf.LogicalStructure.ListLBodyElement, namespace: Aspose.Pdf.LogicalStructure
  DNListLIElement = interface; // type: Aspose.Pdf.LogicalStructure.ListLIElement, namespace: Aspose.Pdf.LogicalStructure
  DNRubyChildElement = interface; // type: Aspose.Pdf.LogicalStructure.RubyChildElement, namespace: Aspose.Pdf.LogicalStructure
  DNRubyRBElement = interface; // type: Aspose.Pdf.LogicalStructure.RubyRBElement, namespace: Aspose.Pdf.LogicalStructure
  DNRubyRPElement = interface; // type: Aspose.Pdf.LogicalStructure.RubyRPElement, namespace: Aspose.Pdf.LogicalStructure
  DNRubyRTElement = interface; // type: Aspose.Pdf.LogicalStructure.RubyRTElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableChildElement = interface; // type: Aspose.Pdf.LogicalStructure.TableChildElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableCellElement = interface; // type: Aspose.Pdf.LogicalStructure.TableCellElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableTDElement = interface; // type: Aspose.Pdf.LogicalStructure.TableTDElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableTHElement = interface; // type: Aspose.Pdf.LogicalStructure.TableTHElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableRowCollectionElement = interface; // type: Aspose.Pdf.LogicalStructure.TableRowCollectionElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableTBodyElement = interface; // type: Aspose.Pdf.LogicalStructure.TableTBodyElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableTFootElement = interface; // type: Aspose.Pdf.LogicalStructure.TableTFootElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableTHeadElement = interface; // type: Aspose.Pdf.LogicalStructure.TableTHeadElement, namespace: Aspose.Pdf.LogicalStructure
  DNTableTRElement = interface; // type: Aspose.Pdf.LogicalStructure.TableTRElement, namespace: Aspose.Pdf.LogicalStructure
  DNWarichuChildElement = interface; // type: Aspose.Pdf.LogicalStructure.WarichuChildElement, namespace: Aspose.Pdf.LogicalStructure
  DNWarichuWPElement = interface; // type: Aspose.Pdf.LogicalStructure.WarichuWPElement, namespace: Aspose.Pdf.LogicalStructure
  DNWarichuWTElement = interface; // type: Aspose.Pdf.LogicalStructure.WarichuWTElement, namespace: Aspose.Pdf.LogicalStructure
  DNElementList = interface; // type: Aspose.Pdf.LogicalStructure.ElementList, namespace: Aspose.Pdf.LogicalStructure
  DNStructureAttribute = interface; // type: Aspose.Pdf.LogicalStructure.StructureAttribute, namespace: Aspose.Pdf.LogicalStructure
  DNStructureAttributeCollection = interface; // type: Aspose.Pdf.LogicalStructure.StructureAttributeCollection, namespace: Aspose.Pdf.LogicalStructure
  DNStructureAttributes = interface; // type: Aspose.Pdf.LogicalStructure.StructureAttributes, namespace: Aspose.Pdf.LogicalStructure
  DNStructureTextState = interface; // type: Aspose.Pdf.LogicalStructure.StructureTextState, namespace: Aspose.Pdf.LogicalStructure
  DNStructureTypeCategory = interface; // type: Aspose.Pdf.LogicalStructure.StructureTypeCategory, namespace: Aspose.Pdf.LogicalStructure
  DNStructureTypeStandard = interface; // type: Aspose.Pdf.LogicalStructure.StructureTypeStandard, namespace: Aspose.Pdf.LogicalStructure
  DNMarginInfo = interface; // type: Aspose.Pdf.MarginInfo, namespace: Aspose.Pdf
  DNMatrix = interface; // type: Aspose.Pdf.Matrix, namespace: Aspose.Pdf
  DNMatrix3D = interface; // type: Aspose.Pdf.Matrix3D, namespace: Aspose.Pdf
  DNMetadata = interface; // type: Aspose.Pdf.Metadata, namespace: Aspose.Pdf
  DNMetered = interface; // type: Aspose.Pdf.Metered, namespace: Aspose.Pdf
  DNNamedDestinationCollection = interface; // type: Aspose.Pdf.NamedDestinationCollection, namespace: Aspose.Pdf
  DNNote = interface; // type: Aspose.Pdf.Note, namespace: Aspose.Pdf
  DNOcspSettings = interface; // type: Aspose.Pdf.OcspSettings, namespace: Aspose.Pdf
  DNOperator = interface; // type: Aspose.Pdf.Operator, namespace: Aspose.Pdf
  DNBDC = interface; // type: Aspose.Pdf.Operators.BDC, namespace: Aspose.Pdf.Operators
  DNBI = interface; // type: Aspose.Pdf.Operators.BI, namespace: Aspose.Pdf.Operators
  DNBMC = interface; // type: Aspose.Pdf.Operators.BMC, namespace: Aspose.Pdf.Operators
  DNBX = interface; // type: Aspose.Pdf.Operators.BX, namespace: Aspose.Pdf.Operators
  DNClip = interface; // type: Aspose.Pdf.Operators.Clip, namespace: Aspose.Pdf.Operators
  DNClosePath = interface; // type: Aspose.Pdf.Operators.ClosePath, namespace: Aspose.Pdf.Operators
  DNClosePathEOFillStroke = interface; // type: Aspose.Pdf.Operators.ClosePathEOFillStroke, namespace: Aspose.Pdf.Operators
  DNClosePathFillStroke = interface; // type: Aspose.Pdf.Operators.ClosePathFillStroke, namespace: Aspose.Pdf.Operators
  DNClosePathStroke = interface; // type: Aspose.Pdf.Operators.ClosePathStroke, namespace: Aspose.Pdf.Operators
  DNConcatenateMatrix = interface; // type: Aspose.Pdf.Operators.ConcatenateMatrix, namespace: Aspose.Pdf.Operators
  DNCurveTo = interface; // type: Aspose.Pdf.Operators.CurveTo, namespace: Aspose.Pdf.Operators
  DNCurveTo1 = interface; // type: Aspose.Pdf.Operators.CurveTo1, namespace: Aspose.Pdf.Operators
  DNCurveTo2 = interface; // type: Aspose.Pdf.Operators.CurveTo2, namespace: Aspose.Pdf.Operators
  DNDo = interface; // type: Aspose.Pdf.Operators.Do, namespace: Aspose.Pdf.Operators
  DNDP = interface; // type: Aspose.Pdf.Operators.DP, namespace: Aspose.Pdf.Operators
  DNEI = interface; // type: Aspose.Pdf.Operators.EI, namespace: Aspose.Pdf.Operators
  DNEMC = interface; // type: Aspose.Pdf.Operators.EMC, namespace: Aspose.Pdf.Operators
  DNEndPath = interface; // type: Aspose.Pdf.Operators.EndPath, namespace: Aspose.Pdf.Operators
  DNEOClip = interface; // type: Aspose.Pdf.Operators.EOClip, namespace: Aspose.Pdf.Operators
  DNEOFill = interface; // type: Aspose.Pdf.Operators.EOFill, namespace: Aspose.Pdf.Operators
  DNEOFillStroke = interface; // type: Aspose.Pdf.Operators.EOFillStroke, namespace: Aspose.Pdf.Operators
  DNEX = interface; // type: Aspose.Pdf.Operators.EX, namespace: Aspose.Pdf.Operators
  DNFill = interface; // type: Aspose.Pdf.Operators.Fill, namespace: Aspose.Pdf.Operators
  DNFillStroke = interface; // type: Aspose.Pdf.Operators.FillStroke, namespace: Aspose.Pdf.Operators
  DNGRestore = interface; // type: Aspose.Pdf.Operators.GRestore, namespace: Aspose.Pdf.Operators
  DNGS = interface; // type: Aspose.Pdf.Operators.GS, namespace: Aspose.Pdf.Operators
  DNGSave = interface; // type: Aspose.Pdf.Operators.GSave, namespace: Aspose.Pdf.Operators
  DNOperators_ID = interface; // type: Aspose.Pdf.Operators.ID, namespace: Aspose.Pdf.Operators
  DNLineTo = interface; // type: Aspose.Pdf.Operators.LineTo, namespace: Aspose.Pdf.Operators
  DNMoveTo = interface; // type: Aspose.Pdf.Operators.MoveTo, namespace: Aspose.Pdf.Operators
  DNMP = interface; // type: Aspose.Pdf.Operators.MP, namespace: Aspose.Pdf.Operators
  DNObsoleteFill = interface; // type: Aspose.Pdf.Operators.ObsoleteFill, namespace: Aspose.Pdf.Operators
  DNRe = interface; // type: Aspose.Pdf.Operators.Re, namespace: Aspose.Pdf.Operators
  DNSetCharWidth = interface; // type: Aspose.Pdf.Operators.SetCharWidth, namespace: Aspose.Pdf.Operators
  DNSetCharWidthBoundingBox = interface; // type: Aspose.Pdf.Operators.SetCharWidthBoundingBox, namespace: Aspose.Pdf.Operators
  DNSetColorOperator = interface; // type: Aspose.Pdf.Operators.SetColorOperator, namespace: Aspose.Pdf.Operators
  DNBasicSetColorOperator = interface; // type: Aspose.Pdf.Operators.BasicSetColorOperator, namespace: Aspose.Pdf.Operators
  DNBasicSetColorAndPatternOperator = interface; // type: Aspose.Pdf.Operators.BasicSetColorAndPatternOperator, namespace: Aspose.Pdf.Operators
  DNSetAdvancedColor = interface; // type: Aspose.Pdf.Operators.SetAdvancedColor, namespace: Aspose.Pdf.Operators
  DNSetAdvancedColorStroke = interface; // type: Aspose.Pdf.Operators.SetAdvancedColorStroke, namespace: Aspose.Pdf.Operators
  DNSetColor = interface; // type: Aspose.Pdf.Operators.SetColor, namespace: Aspose.Pdf.Operators
  DNSetColorStroke = interface; // type: Aspose.Pdf.Operators.SetColorStroke, namespace: Aspose.Pdf.Operators
  DNSetCMYKColor = interface; // type: Aspose.Pdf.Operators.SetCMYKColor, namespace: Aspose.Pdf.Operators
  DNSetCMYKColorStroke = interface; // type: Aspose.Pdf.Operators.SetCMYKColorStroke, namespace: Aspose.Pdf.Operators
  DNSetGray = interface; // type: Aspose.Pdf.Operators.SetGray, namespace: Aspose.Pdf.Operators
  DNSetGrayStroke = interface; // type: Aspose.Pdf.Operators.SetGrayStroke, namespace: Aspose.Pdf.Operators
  DNSetRGBColor = interface; // type: Aspose.Pdf.Operators.SetRGBColor, namespace: Aspose.Pdf.Operators
  DNSetRGBColorStroke = interface; // type: Aspose.Pdf.Operators.SetRGBColorStroke, namespace: Aspose.Pdf.Operators
  DNSetColorRenderingIntent = interface; // type: Aspose.Pdf.Operators.SetColorRenderingIntent, namespace: Aspose.Pdf.Operators
  DNSetColorSpace = interface; // type: Aspose.Pdf.Operators.SetColorSpace, namespace: Aspose.Pdf.Operators
  DNSetColorSpaceStroke = interface; // type: Aspose.Pdf.Operators.SetColorSpaceStroke, namespace: Aspose.Pdf.Operators
  DNSetDash = interface; // type: Aspose.Pdf.Operators.SetDash, namespace: Aspose.Pdf.Operators
  DNSetFlat = interface; // type: Aspose.Pdf.Operators.SetFlat, namespace: Aspose.Pdf.Operators
  DNSetLineCap = interface; // type: Aspose.Pdf.Operators.SetLineCap, namespace: Aspose.Pdf.Operators
  DNSetLineJoin = interface; // type: Aspose.Pdf.Operators.SetLineJoin, namespace: Aspose.Pdf.Operators
  DNSetLineWidth = interface; // type: Aspose.Pdf.Operators.SetLineWidth, namespace: Aspose.Pdf.Operators
  DNSetMiterLimit = interface; // type: Aspose.Pdf.Operators.SetMiterLimit, namespace: Aspose.Pdf.Operators
  DNShFill = interface; // type: Aspose.Pdf.Operators.ShFill, namespace: Aspose.Pdf.Operators
  DNStroke = interface; // type: Aspose.Pdf.Operators.Stroke, namespace: Aspose.Pdf.Operators
  DNTextOperator = interface; // type: Aspose.Pdf.Operators.TextOperator, namespace: Aspose.Pdf.Operators
  DNBlockTextOperator = interface; // type: Aspose.Pdf.Operators.BlockTextOperator, namespace: Aspose.Pdf.Operators
  DNBT = interface; // type: Aspose.Pdf.Operators.BT, namespace: Aspose.Pdf.Operators
  DNET = interface; // type: Aspose.Pdf.Operators.ET, namespace: Aspose.Pdf.Operators
  DNTextPlaceOperator = interface; // type: Aspose.Pdf.Operators.TextPlaceOperator, namespace: Aspose.Pdf.Operators
  DNMoveTextPosition = interface; // type: Aspose.Pdf.Operators.MoveTextPosition, namespace: Aspose.Pdf.Operators
  DNMoveTextPositionSetLeading = interface; // type: Aspose.Pdf.Operators.MoveTextPositionSetLeading, namespace: Aspose.Pdf.Operators
  DNMoveToNextLine = interface; // type: Aspose.Pdf.Operators.MoveToNextLine, namespace: Aspose.Pdf.Operators
  DNSetTextMatrix = interface; // type: Aspose.Pdf.Operators.SetTextMatrix, namespace: Aspose.Pdf.Operators
  DNTextShowOperator = interface; // type: Aspose.Pdf.Operators.TextShowOperator, namespace: Aspose.Pdf.Operators
  DNMoveToNextLineShowText = interface; // type: Aspose.Pdf.Operators.MoveToNextLineShowText, namespace: Aspose.Pdf.Operators
  DNSetGlyphsPositionShowText = interface; // type: Aspose.Pdf.Operators.SetGlyphsPositionShowText, namespace: Aspose.Pdf.Operators
  DNSetSpacingMoveToNextLineShowText = interface; // type: Aspose.Pdf.Operators.SetSpacingMoveToNextLineShowText, namespace: Aspose.Pdf.Operators
  DNShowText = interface; // type: Aspose.Pdf.Operators.ShowText, namespace: Aspose.Pdf.Operators
  DNTextStateOperator = interface; // type: Aspose.Pdf.Operators.TextStateOperator, namespace: Aspose.Pdf.Operators
  DNSelectFont = interface; // type: Aspose.Pdf.Operators.SelectFont, namespace: Aspose.Pdf.Operators
  DNSetCharacterSpacing = interface; // type: Aspose.Pdf.Operators.SetCharacterSpacing, namespace: Aspose.Pdf.Operators
  DNSetHorizontalTextScaling = interface; // type: Aspose.Pdf.Operators.SetHorizontalTextScaling, namespace: Aspose.Pdf.Operators
  DNSetTextLeading = interface; // type: Aspose.Pdf.Operators.SetTextLeading, namespace: Aspose.Pdf.Operators
  DNSetTextRenderingMode = interface; // type: Aspose.Pdf.Operators.SetTextRenderingMode, namespace: Aspose.Pdf.Operators
  DNSetTextRise = interface; // type: Aspose.Pdf.Operators.SetTextRise, namespace: Aspose.Pdf.Operators
  DNSetWordSpacing = interface; // type: Aspose.Pdf.Operators.SetWordSpacing, namespace: Aspose.Pdf.Operators
  DNGlyphPosition = interface; // type: Aspose.Pdf.Operators.GlyphPosition, namespace: Aspose.Pdf.Operators
  DNOperatorSelector = interface; // type: Aspose.Pdf.OperatorSelector, namespace: Aspose.Pdf
  DNOpi = interface; // type: Aspose.Pdf.Opi, namespace: Aspose.Pdf
  DNImageCompressionOptions = interface; // type: Aspose.Pdf.Optimization.ImageCompressionOptions, namespace: Aspose.Pdf.Optimization
  DNOptimizationOptions = interface; // type: Aspose.Pdf.Optimization.OptimizationOptions, namespace: Aspose.Pdf.Optimization
  DNDocument_OptimizationOptions = interface; // type: Aspose.Pdf.Document+OptimizationOptions, namespace: Aspose.Pdf
  DNOutlines = interface; // type: Aspose.Pdf.Outlines, namespace: Aspose.Pdf
  DNOutlineCollection = interface; // type: Aspose.Pdf.OutlineCollection, namespace: Aspose.Pdf
  DNOutlineItemCollection = interface; // type: Aspose.Pdf.OutlineItemCollection, namespace: Aspose.Pdf
  DNPage = interface; // type: Aspose.Pdf.Page, namespace: Aspose.Pdf
  DNPageCollection = interface; // type: Aspose.Pdf.PageCollection, namespace: Aspose.Pdf
  DNPageInfo = interface; // type: Aspose.Pdf.PageInfo, namespace: Aspose.Pdf
  DNPageLabel = interface; // type: Aspose.Pdf.PageLabel, namespace: Aspose.Pdf
  DNPageLabelCollection = interface; // type: Aspose.Pdf.PageLabelCollection, namespace: Aspose.Pdf
  DNPageSize = interface; // type: Aspose.Pdf.PageSize, namespace: Aspose.Pdf
  DNParagraphs = interface; // type: Aspose.Pdf.Paragraphs, namespace: Aspose.Pdf
  DNPdfANonSpecificationFlags = interface; // type: Aspose.Pdf.PdfANonSpecificationFlags, namespace: Aspose.Pdf
  DNFontEmbeddingOptions = interface; // type: Aspose.Pdf.PdfAOptionClasses.FontEmbeddingOptions, namespace: Aspose.Pdf.PdfAOptionClasses
  DNToUnicodeProcessingRules = interface; // type: Aspose.Pdf.PdfAOptionClasses.ToUnicodeProcessingRules, namespace: Aspose.Pdf.PdfAOptionClasses
  DNPdfASymbolicFontEncodingStrategy = interface; // type: Aspose.Pdf.PdfASymbolicFontEncodingStrategy, namespace: Aspose.Pdf
  DNPdfASymbolicFontEncodingStrategy_QueueItem = interface; // type: Aspose.Pdf.PdfASymbolicFontEncodingStrategy+QueueItem, namespace: Aspose.Pdf
  DNPdfFormatConversionOptions = interface; // type: Aspose.Pdf.PdfFormatConversionOptions, namespace: Aspose.Pdf
  DNPoint = interface; // type: Aspose.Pdf.Point, namespace: Aspose.Pdf
  DNPoint3D = interface; // type: Aspose.Pdf.Point3D, namespace: Aspose.Pdf
  DNPdf_Rectangle = interface; // type: Aspose.Pdf.Rectangle, namespace: Aspose.Pdf
  DNRenderingOptions = interface; // type: Aspose.Pdf.RenderingOptions, namespace: Aspose.Pdf
  DNResourceLoadingResult = interface; // type: Aspose.Pdf.ResourceLoadingResult, namespace: Aspose.Pdf
  DNResources = interface; // type: Aspose.Pdf.Resources, namespace: Aspose.Pdf
  DNRgbToDeviceGrayConversionStrategy = interface; // type: Aspose.Pdf.RgbToDeviceGrayConversionStrategy, namespace: Aspose.Pdf
  DNRow = interface; // type: Aspose.Pdf.Row, namespace: Aspose.Pdf
  DNRows = interface; // type: Aspose.Pdf.Rows, namespace: Aspose.Pdf
  DNSaveOptions = interface; // type: Aspose.Pdf.SaveOptions, namespace: Aspose.Pdf
  DNPdfSaveOptions = interface; // type: Aspose.Pdf.PdfSaveOptions, namespace: Aspose.Pdf
  DNUnifiedSaveOptions = interface; // type: Aspose.Pdf.UnifiedSaveOptions, namespace: Aspose.Pdf
  DNApsSaveOptions = interface; // type: Aspose.Pdf.ApsSaveOptions, namespace: Aspose.Pdf
  DNDocSaveOptions = interface; // type: Aspose.Pdf.DocSaveOptions, namespace: Aspose.Pdf
  DNEpubSaveOptions = interface; // type: Aspose.Pdf.EpubSaveOptions, namespace: Aspose.Pdf
  DNExcelSaveOptions = interface; // type: Aspose.Pdf.ExcelSaveOptions, namespace: Aspose.Pdf
  DNHtmlSaveOptions = interface; // type: Aspose.Pdf.HtmlSaveOptions, namespace: Aspose.Pdf
  DNMobiXmlSaveOptions = interface; // type: Aspose.Pdf.MobiXmlSaveOptions, namespace: Aspose.Pdf
  DNPdfXmlSaveOptions = interface; // type: Aspose.Pdf.PdfXmlSaveOptions, namespace: Aspose.Pdf
  DNPptxSaveOptions = interface; // type: Aspose.Pdf.PptxSaveOptions, namespace: Aspose.Pdf
  DNSvgSaveOptions = interface; // type: Aspose.Pdf.SvgSaveOptions, namespace: Aspose.Pdf
  DNTeXSaveOptions = interface; // type: Aspose.Pdf.TeXSaveOptions, namespace: Aspose.Pdf
  DNLaTeXSaveOptions = interface; // type: Aspose.Pdf.LaTeXSaveOptions, namespace: Aspose.Pdf
  DNXpsSaveOptions = interface; // type: Aspose.Pdf.XpsSaveOptions, namespace: Aspose.Pdf
  DNXmlSaveOptions = interface; // type: Aspose.Pdf.XmlSaveOptions, namespace: Aspose.Pdf
  DNSaveOptions_BorderInfo = interface; // type: Aspose.Pdf.SaveOptions+BorderInfo, namespace: Aspose.Pdf
  DNSaveOptions_BorderPartStyle = interface; // type: Aspose.Pdf.SaveOptions+BorderPartStyle, namespace: Aspose.Pdf
  DNSaveOptions_MarginInfo = interface; // type: Aspose.Pdf.SaveOptions+MarginInfo, namespace: Aspose.Pdf
  DNSaveOptions_MarginPartStyle = interface; // type: Aspose.Pdf.SaveOptions+MarginPartStyle, namespace: Aspose.Pdf
  DNSaveOptions_ResourceSavingInfo = interface; // type: Aspose.Pdf.SaveOptions+ResourceSavingInfo, namespace: Aspose.Pdf
  DNHtmlSaveOptions_HtmlImageSavingInfo = interface; // type: Aspose.Pdf.HtmlSaveOptions+HtmlImageSavingInfo, namespace: Aspose.Pdf
  DNSvgSaveOptions_SvgImageSavingInfo = interface; // type: Aspose.Pdf.SvgSaveOptions+SvgImageSavingInfo, namespace: Aspose.Pdf
  DNPdf_Stamp = interface; // type: Aspose.Pdf.Stamp, namespace: Aspose.Pdf
  DNImageStamp = interface; // type: Aspose.Pdf.ImageStamp, namespace: Aspose.Pdf
  DNPdfPageStamp = interface; // type: Aspose.Pdf.PdfPageStamp, namespace: Aspose.Pdf
  DNTextStamp = interface; // type: Aspose.Pdf.TextStamp, namespace: Aspose.Pdf
  DNPageNumberStamp = interface; // type: Aspose.Pdf.PageNumberStamp, namespace: Aspose.Pdf
  DNStructure_Element = interface; // type: Aspose.Pdf.Structure.Element, namespace: Aspose.Pdf.Structure
  DNStructure_FigureElement = interface; // type: Aspose.Pdf.Structure.FigureElement, namespace: Aspose.Pdf.Structure
  DNRootElement = interface; // type: Aspose.Pdf.Structure.RootElement, namespace: Aspose.Pdf.Structure
  DNStructElement = interface; // type: Aspose.Pdf.Structure.StructElement, namespace: Aspose.Pdf.Structure
  DNTextElement = interface; // type: Aspose.Pdf.Structure.TextElement, namespace: Aspose.Pdf.Structure
  DNAbsorbedCell = interface; // type: Aspose.Pdf.Text.AbsorbedCell, namespace: Aspose.Pdf.Text
  DNAbsorbedRow = interface; // type: Aspose.Pdf.Text.AbsorbedRow, namespace: Aspose.Pdf.Text
  DNAbsorbedTable = interface; // type: Aspose.Pdf.Text.AbsorbedTable, namespace: Aspose.Pdf.Text
  DNCharInfo = interface; // type: Aspose.Pdf.Text.CharInfo, namespace: Aspose.Pdf.Text
  DNCharInfoCollection = interface; // type: Aspose.Pdf.Text.CharInfoCollection, namespace: Aspose.Pdf.Text
  DNCustomFontSubstitutionBase_OriginalFontSpecification = interface; // type: Aspose.Pdf.Text.CustomFontSubstitutionBase+OriginalFontSpecification, namespace: Aspose.Pdf.Text
  DNFont = interface; // type: Aspose.Pdf.Text.Font, namespace: Aspose.Pdf.Text
  DNFontAbsorber = interface; // type: Aspose.Pdf.Text.FontAbsorber, namespace: Aspose.Pdf.Text
  DNFontCollection = interface; // type: Aspose.Pdf.Text.FontCollection, namespace: Aspose.Pdf.Text
  DNFontRepository = interface; // type: Aspose.Pdf.Text.FontRepository, namespace: Aspose.Pdf.Text
  DNFontSource = interface; // type: Aspose.Pdf.Text.FontSource, namespace: Aspose.Pdf.Text
  DNFileFontSource = interface; // type: Aspose.Pdf.Text.FileFontSource, namespace: Aspose.Pdf.Text
  DNFolderFontSource = interface; // type: Aspose.Pdf.Text.FolderFontSource, namespace: Aspose.Pdf.Text
  DNMemoryFontSource = interface; // type: Aspose.Pdf.Text.MemoryFontSource, namespace: Aspose.Pdf.Text
  DNSystemFontSource = interface; // type: Aspose.Pdf.Text.SystemFontSource, namespace: Aspose.Pdf.Text
  DNFontSourceCollection = interface; // type: Aspose.Pdf.Text.FontSourceCollection, namespace: Aspose.Pdf.Text
  DNFontSubstitution = interface; // type: Aspose.Pdf.Text.FontSubstitution, namespace: Aspose.Pdf.Text
  DNCustomFontSubstitutionBase = interface; // type: Aspose.Pdf.Text.CustomFontSubstitutionBase, namespace: Aspose.Pdf.Text
  DNSimpleFontSubstitution = interface; // type: Aspose.Pdf.Text.SimpleFontSubstitution, namespace: Aspose.Pdf.Text
  DNSystemFontsSubstitution = interface; // type: Aspose.Pdf.Text.SystemFontsSubstitution, namespace: Aspose.Pdf.Text
  DNFontSubstitutionCollection = interface; // type: Aspose.Pdf.Text.FontSubstitutionCollection, namespace: Aspose.Pdf.Text
  DNMarkupParagraph = interface; // type: Aspose.Pdf.Text.MarkupParagraph, namespace: Aspose.Pdf.Text
  DNMarkupSection = interface; // type: Aspose.Pdf.Text.MarkupSection, namespace: Aspose.Pdf.Text
  DNPageMarkup = interface; // type: Aspose.Pdf.Text.PageMarkup, namespace: Aspose.Pdf.Text
  DNParagraphAbsorber = interface; // type: Aspose.Pdf.Text.ParagraphAbsorber, namespace: Aspose.Pdf.Text
  DNPosition = interface; // type: Aspose.Pdf.Text.Position, namespace: Aspose.Pdf.Text
  DNTableAbsorber = interface; // type: Aspose.Pdf.Text.TableAbsorber, namespace: Aspose.Pdf.Text
  DNTabStop = interface; // type: Aspose.Pdf.Text.TabStop, namespace: Aspose.Pdf.Text
  DNTabStops = interface; // type: Aspose.Pdf.Text.TabStops, namespace: Aspose.Pdf.Text
  DNTextAbsorber = interface; // type: Aspose.Pdf.Text.TextAbsorber, namespace: Aspose.Pdf.Text
  DNTextFragmentAbsorber = interface; // type: Aspose.Pdf.Text.TextFragmentAbsorber, namespace: Aspose.Pdf.Text
  DNTextBuilder = interface; // type: Aspose.Pdf.Text.TextBuilder, namespace: Aspose.Pdf.Text
  DNTextExtractionError = interface; // type: Aspose.Pdf.Text.TextExtractionError, namespace: Aspose.Pdf.Text
  DNTextExtractionErrorLocation = interface; // type: Aspose.Pdf.Text.TextExtractionErrorLocation, namespace: Aspose.Pdf.Text
  DNTextFragmentCollection = interface; // type: Aspose.Pdf.Text.TextFragmentCollection, namespace: Aspose.Pdf.Text
  DNTextOptions = interface; // type: Aspose.Pdf.Text.TextOptions, namespace: Aspose.Pdf.Text
  DNTextEditOptions = interface; // type: Aspose.Pdf.Text.TextEditOptions, namespace: Aspose.Pdf.Text
  DNTextExtractionOptions = interface; // type: Aspose.Pdf.Text.TextExtractionOptions, namespace: Aspose.Pdf.Text
  DNTextFormattingOptions = interface; // type: Aspose.Pdf.Text.TextFormattingOptions, namespace: Aspose.Pdf.Text
  DNTextReplaceOptions = interface; // type: Aspose.Pdf.Text.TextReplaceOptions, namespace: Aspose.Pdf.Text
  DNTextSearchOptions = interface; // type: Aspose.Pdf.Text.TextSearchOptions, namespace: Aspose.Pdf.Text
  DNTextParagraph = interface; // type: Aspose.Pdf.Text.TextParagraph, namespace: Aspose.Pdf.Text
  DNTextSegment = interface; // type: Aspose.Pdf.Text.TextSegment, namespace: Aspose.Pdf.Text
  DNTextSegmentCollection = interface; // type: Aspose.Pdf.Text.TextSegmentCollection, namespace: Aspose.Pdf.Text
  DNTextState = interface; // type: Aspose.Pdf.Text.TextState, namespace: Aspose.Pdf.Text
  DNTextFragmentState = interface; // type: Aspose.Pdf.Text.TextFragmentState, namespace: Aspose.Pdf.Text
  DNTimestampSettings = interface; // type: Aspose.Pdf.TimestampSettings, namespace: Aspose.Pdf
  DNTocInfo = interface; // type: Aspose.Pdf.TocInfo, namespace: Aspose.Pdf
  DNUnifiedSaveOptions_ProgressEventHandlerInfo = interface; // type: Aspose.Pdf.UnifiedSaveOptions+ProgressEventHandlerInfo, namespace: Aspose.Pdf
  DNWarningInfo = interface; // type: Aspose.Pdf.WarningInfo, namespace: Aspose.Pdf
  DNWatermark = interface; // type: Aspose.Pdf.Watermark, namespace: Aspose.Pdf
  DNXfaParserOptions = interface; // type: Aspose.Pdf.XfaConverter.XfaParserOptions, namespace: Aspose.Pdf.XfaConverter
  DNXForm = interface; // type: Aspose.Pdf.XForm, namespace: Aspose.Pdf
  DNXFormCollection = interface; // type: Aspose.Pdf.XFormCollection, namespace: Aspose.Pdf
  DNXImage = interface; // type: Aspose.Pdf.XImage, namespace: Aspose.Pdf
  DNXImageCollection = interface; // type: Aspose.Pdf.XImageCollection, namespace: Aspose.Pdf
  DNXmpField = interface; // type: Aspose.Pdf.XmpField, namespace: Aspose.Pdf
  DNXmpPdfAExtensionObject = interface; // type: Aspose.Pdf.XmpPdfAExtensionObject, namespace: Aspose.Pdf
  DNXmpPdfAExtensionField = interface; // type: Aspose.Pdf.XmpPdfAExtensionField, namespace: Aspose.Pdf
  DNXmpPdfAExtensionProperty = interface; // type: Aspose.Pdf.XmpPdfAExtensionProperty, namespace: Aspose.Pdf
  DNXmpPdfAExtensionValueType = interface; // type: Aspose.Pdf.XmpPdfAExtensionValueType, namespace: Aspose.Pdf
  DNXmpPdfAExtensionSchema = interface; // type: Aspose.Pdf.XmpPdfAExtensionSchema, namespace: Aspose.Pdf
  DNXmpPdfAExtensionSchemaDescription = interface; // type: Aspose.Pdf.XmpPdfAExtensionSchemaDescription, namespace: Aspose.Pdf
  DNXmpValue = interface; // type: Aspose.Pdf.XmpValue, namespace: Aspose.Pdf
  DNDocumentInfo = interface; // type: Aspose.Pdf.DocumentInfo, namespace: Aspose.Pdf
  DNBookmarks = interface; // type: Aspose.Pdf.Facades.Bookmarks, namespace: Aspose.Pdf.Facades
  DNPrintController = interface; // type: Aspose.Pdf.PrintController, namespace: Aspose.Pdf
  DNResourceLoadingEventArgs = interface; // type: Aspose.Pdf.ResourceLoadingEventArgs, namespace: Aspose.Pdf
  DNIncorrectCMapUsageException = interface; // type: Aspose.Pdf.IncorrectCMapUsageException, namespace: Aspose.Pdf
  DNPdfException = interface; // type: Aspose.Pdf.PdfException, namespace: Aspose.Pdf
  DNEmptyValueException = interface; // type: Aspose.Pdf.EmptyValueException, namespace: Aspose.Pdf
  DNInvalidFileFormatException = interface; // type: Aspose.Pdf.InvalidFileFormatException, namespace: Aspose.Pdf
  DNIncorrectFontUsageException = interface; // type: Aspose.Pdf.IncorrectFontUsageException, namespace: Aspose.Pdf
  DNInvalidCgmFileFormatException = interface; // type: Aspose.Pdf.InvalidCgmFileFormatException, namespace: Aspose.Pdf
  DNInvalidPdfFileFormatException = interface; // type: Aspose.Pdf.InvalidPdfFileFormatException, namespace: Aspose.Pdf
  DNInvalidPasswordException = interface; // type: Aspose.Pdf.InvalidPasswordException, namespace: Aspose.Pdf
  DNInvalidValueFormatException = interface; // type: Aspose.Pdf.InvalidValueFormatException, namespace: Aspose.Pdf
  DNTaggedException = interface; // type: Aspose.Pdf.Tagged.TaggedException, namespace: Aspose.Pdf.Tagged
  DNSanitizationException = interface; // type: Aspose.Pdf.Sanitization.SanitizationException, namespace: Aspose.Pdf.Sanitization
  DNFontEmbeddingException = interface; // type: Aspose.Pdf.FontEmbeddingException, namespace: Aspose.Pdf
  DNFontNotFoundException = interface; // type: Aspose.Pdf.FontNotFoundException, namespace: Aspose.Pdf
  DNUnsupportedFontTypeException = interface; // type: Aspose.Pdf.UnsupportedFontTypeException, namespace: Aspose.Pdf
  DNInvalidFormTypeOperationException = interface; // type: Aspose.Pdf.InvalidFormTypeOperationException, namespace: Aspose.Pdf

{ delegates }

  ///<summary>
  ///  The call back procedure for hocr recognize.
  ///</summary>
  ///  <param name="img">The hocr image.</param>
  ///<returns>The hocr text</returns>
  [DNTypeName('Aspose.Pdf.Document+CallBackGetHocr')]
  DNDocument_CallBackGetHocr = function(img: DDN.System.Drawing.DNImage): string of object;

  ///<summary>
  ///  Represents the method that will handle FontSubstitution event.
  ///</summary>
  ///  <param name="oldFont">original font</param>
  ///  <param name="newFont">new font</param>
  [DNTypeName('Aspose.Pdf.Document+FontSubstitutionHandler')]
  DNDocument_FontSubstitutionHandler = procedure(oldFont: DNFont; newFont: DNFont) of object;

  ///<summary>
  ///  Represents the method that handles the QueryPageSettings event of a PrintDocument.
  ///</summary>
  ///  <param name="sender">The source of the event. </param>
  ///  <param name="queryPageSettingsEventArgs">A QueryPageSettingsEventArgs that contains the event data.</param>
  ///  <param name="currentPageInfo">Currently printed page info.</param>
  [DNTypeName('Aspose.Pdf.Facades.PdfQueryPageSettingsEventHandler')]
  DNPdfQueryPageSettingsEventHandler = procedure(sender: DDN.mscorlib.DNObject; queryPageSettingsEventArgs: DDN.System.Drawing.DNQueryPageSettingsEventArgs; currentPageInfo: DNPdfPrintPageInfo) of object;

  ///<summary>
  ///  You can  assign to this property custom strategy that implements processing
  ///  or/and saving of one CSS's part that was created during conversion of PDF to HTML .
  ///  In such case  processing (like saving to stream or disk)
  ///  must be done in that custom code
  ///</summary>
  ///  <param name="partSavingInfo"> represents set of data that can be used for saving of supplied CSS part</param>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+CssSavingStrategy')]
  DNHtmlSaveOptions_CssSavingStrategy = procedure(partSavingInfo: DNHtmlSaveOptions_CssSavingInfo) of object;

  ///<summary>
  ///  You can  assign to this property  delegate created from custom method that implements creation of URL of CSS referenced
  ///  in generated HTML document. F.e. if You want to make CSS referenced in HTML f.e. as "otherPage.ASPX?CssID=zjjkklj"
  ///  Then such custom strategy must return "otherPage.ASPX?CssID=zjjkklj"
  ///</summary>
  ///  <param name="cssUrlRequestInfo"> represents set of data that can be used for generation of CSS' URL</param>
  ///<returns> must return string that represents CSS's URL or URL's template</returns>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+CssUrlMakingStrategy')]
  DNHtmlSaveOptions_CssUrlMakingStrategy = function(cssUrlRequestInfo: DNHtmlSaveOptions_CssUrlRequestInfo): string of object;

  ///<summary>
  ///  Result of conversion can contain one or several HTML-pages ( that also can reference external files like images or fonts)
  ///  You can  assign to this property delegate created from custom method that implements processing
  ///  of got HTML-page(HTML itself) that was created during conversion.
  ///  In such case  processing (like saving in stream or disk) can be done in that custom code .
  ///  In such case All the necessary actions for saving of HTML page's markup must be undertaken
  ///  in code of supplied method, because saving of result in code of converter will be not in use.
  ///  If processing for this or that case for some reason must be done by converter's code itself,
  ///  not in custom code, please set in custom code flag 'CustomProcessingCancelled'
  ///  of 'htmlSavingInfo' parameter's variable : it signals to converter that all the necessary
  ///  steps for processing of that resource  must be done in converter itself in same way
  ///  as if there was no any external custom saving code .
  ///</summary>
  ///  <param name="htmlSavingInfo"> represents data that can be used for saving or processing of supplied HTML page</param>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+HtmlPageMarkupSavingStrategy')]
  DNHtmlSaveOptions_HtmlPageMarkupSavingStrategy = procedure(htmlSavingInfo: DNHtmlSaveOptions_HtmlPageMarkupSavingInfo) of object;

  ///<summary>
  ///  To this property You can  assign delegate created from custom method that implements processing
  ///  of external resource(Font or Image)
  ///  that was extracted from PDF and must be saved as external resource during conversion of PDF to HTML.
  ///  In such case  processing (like saving in stream or disk)
  ///  can be done in that custom code and that custom code must return path(or any another string without quotemarks)
  ///  that will be afterwards incorporated into generated HTML instead of original supposed path to that image resource.
  ///  In such case All the necessary actions for saving of image must be undertaken
  ///  in code of supplied method, because saving of result in code of converter will be not in use  .
  ///  If processing for this or that file for some reason must be done by converter's code itself, not in custom code,
  ///  please set in custom code flag 'CustomProcessingCancelled' of 'resourceSavingInfo' parameter's variable
  ///  It signals to converter that all the necessary steps for processing of that resource
  ///  must be done in converter itself as if there was no any external custom code .
  ///</summary>
  ///  <param name="resourceSavingInfo"> represents set of data for saving of resource</param>
  ///<returns> must return URL to saved resource that will be used during generation of HTML </returns>
  [DNTypeName('Aspose.Pdf.HtmlSaveOptions+ResourceSavingStrategy')]
  DNHtmlSaveOptions_ResourceSavingStrategy = function(resourceSavingInfo: DNSaveOptions_ResourceSavingInfo): string of object;

  ///<summary>
  ///  Sometimes it's necessary to avoid usage of internal loader of external resources(like images or CSSes)
  ///  and supply custom method, that will get requested resources from somewhere. For example during usage
  ///  of Aspose.Pdf in cloud direct access to referenced files impossible, and some custome code put into special
  ///  method should be used.
  ///  This delegate defines signature of such custom method.
  ///</summary>
  ///  <param name="resourceURI">Resource URI.</param>
  ///<returns>ResourceLoadingResult object.</returns>
  [DNTypeName('Aspose.Pdf.LoadOptions+ResourceLoadingStrategy')]
  DNLoadOptions_ResourceLoadingStrategy = function(resourceURI: string): DNLoadOptions_ResourceLoadingResult of object;

  ///<summary>
  ///  Procedure for customize header and footer.
  ///</summary>
  ///  /// <param name="page">The current page.</param>
  [DNTypeName('Aspose.Pdf.Page+BeforePageGenerate')]
  DNPage_BeforePageGenerate = procedure(page: DNPage) of object;

  ///<summary>
  ///  To property of such type You can  assign delegate created from custom method that implements processing
  ///  of external saving of image  that was extracted from SVG created from PDF and must be saved as external resource during conversion of PDF to HTML.
  ///  In such case  processing (like self-made saving into stream or on disk)
  ///  can be done in that custom code and that custom code must return path(or any another string without quotemarks)
  ///  that will be afterwards incorporated into generated SVG instead of original supposed path to that image resource.
  ///  In such case all the necessary actions for saving of image must be undertaken
  ///  in code of supplied method, because saving of result in code of converter will be not in use.
  ///  If processing for this or that file for some reason must be done by converter's code itself, not in custom code,
  ///  please set in custom code flag 'CustomProcessingCancelled' of 'imageSavingInfo' parameter's variable
  ///  It signals to converter that all the necessary steps for processing of that resource
  ///  must be done in converter itself as if there was no any external custom code .
  ///  <param name="imageSavingInfo">represents information about saved image that can be use in custom code </param>
  ///<returns>must return string that represents URL of image that will be put into SVG</returns>
  ///</summary>
  [DNTypeName('Aspose.Pdf.SvgSaveOptions+EmbeddedImagesSavingStrategy')]
  DNSvgSaveOptions_EmbeddedImagesSavingStrategy = function(imageSavingInfo: DNSvgSaveOptions_SvgImageSavingInfo): string of object;

  ///<summary>
  ///  Represents method that usually supplied by calling side
  ///  and  handles progress events that comes from converter.
  ///  Usually such suplied customer's handler can be used to show
  ///  total conversion progress on console or in progress bar.
  ///  <param name="eventInfo">represents information about occured progress event</param>
  ///</summary>
  [DNTypeName('Aspose.Pdf.UnifiedSaveOptions+ConversionProgressEventHandler')]
  DNUnifiedSaveOptions_ConversionProgressEventHandler = procedure(eventInfo: DNUnifiedSaveOptions_ProgressEventHandlerInfo) of object;




{ objects }

  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Defines Visitor for visiting different document annotations.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.IAnnotationVisitor')]
  DNIAnnotationVisitor = interface(DDN.mscorlib.DNObject)
  ['{B5C685A3-5B12-3DD9-9BD3-D667C6B6BDF5}']
  { methods } 

    ///<summary>
    ///  Visit/select link annotation.
    ///</summary>
    ///  <param name="link">
    ///  LinkAnnotation object example/template.
    ///</param>
    procedure Visit(link: DNLinkAnnotation); overload;
    ///<summary>
    ///  Visit/select attachment annotation.
    ///</summary>
    ///  <param name="attachment">
    ///  FileAttachmentAnnotation object example/template.
    ///</param>
    procedure Visit(attachment: DNFileAttachmentAnnotation); overload;
    ///<summary>
    ///  Visit/select text annotation.
    ///</summary>
    ///  <param name="text">
    ///  TextAnnotation object example/template.
    ///</param>
    procedure Visit(text: DNTextAnnotation); overload;
    ///<summary>
    ///  Visit/select freetext annotation.
    ///</summary>
    ///  <param name="freetext">
    ///  FreeTextAnnotation object example/template.
    ///</param>
    procedure Visit(freetext: DNFreeTextAnnotation); overload;
    ///<summary>
    ///  Visit/select highlight annotation.
    ///</summary>
    ///  <param name="highlight">
    ///  HighlightAnnotation object example/template.
    ///</param>
    procedure Visit(highlight: DNHighlightAnnotation); overload;
    ///<summary>
    ///  Visit/select underline annotation.
    ///</summary>
    ///  <param name="underline">
    ///  UnderlineAnnotation object example/template.
    ///</param>
    procedure Visit(underline: DNUnderlineAnnotation); overload;
    ///<summary>
    ///  Visit/select strikeOut annotation.
    ///</summary>
    ///  <param name="strikeOut">
    ///  StrikeOutAnnotation object example/template.
    ///</param>
    procedure Visit(strikeOut: DNStrikeOutAnnotation); overload;
    ///<summary>
    ///  Visit/select squiggly annotation.
    ///</summary>
    ///  <param name="squiggly">
    ///  SquigglyAnnotation object example/template.
    ///</param>
    procedure Visit(squiggly: DNSquigglyAnnotation); overload;
    ///<summary>
    ///  Visit/select popup annotation.
    ///</summary>
    ///  <param name="popup">
    ///  PopupAnnotation object example/template.
    ///</param>
    procedure Visit(popup: DNPopupAnnotation); overload;
    ///<summary>
    ///  Visit/select line annotation.
    ///</summary>
    ///  <param name="line">
    ///  LineAnnotation object example/template.
    ///</param>
    procedure Visit(line: DNLineAnnotation); overload;
    ///<summary>
    ///  Visit/select circle annotation.
    ///</summary>
    ///  <param name="circle">
    ///  CircleAnnotation object example/template.
    ///</param>
    procedure Visit(circle: DNCircleAnnotation); overload;
    ///<summary>
    ///  Visit/select square annotation.
    ///</summary>
    ///  <param name="square">
    ///  SquareAnnotation object example/template.
    ///</param>
    procedure Visit(square: DNSquareAnnotation); overload;
    ///<summary>
    ///  Visit/select ink annotation.
    ///</summary>
    ///  <param name="ink">
    ///  InkAnnotation object example/template.
    ///</param>
    procedure Visit(ink: DNInkAnnotation); overload;
    ///<summary>
    ///  Visit/select polyline annotation.
    ///</summary>
    ///  <param name="polyline">
    ///  PolylineAnnotation object example/template.
    ///</param>
    procedure Visit(polyline: DNPolylineAnnotation); overload;
    ///<summary>
    ///  Visit/select polygon annotation.
    ///</summary>
    ///  <param name="polygon">
    ///  PolygonAnnotation object example/template.
    ///</param>
    procedure Visit(polygon: DNPolygonAnnotation); overload;
    ///<summary>
    ///  Visit/select caret annotation.
    ///</summary>
    ///  <param name="caret">
    ///  CaretAnnotation object example/template.
    ///</param>
    procedure Visit(caret: DNCaretAnnotation); overload;
    ///<summary>
    ///  Visit/select stamp annotation.
    ///</summary>
    ///  <param name="stamp">
    ///  StampAnnotation object example/template.
    ///</param>
    procedure Visit(stamp: DNStampAnnotation); overload;
    ///<summary>
    ///  Visit/select widget annotation.
    ///</summary>
    ///  <param name="widget">
    ///  WidgetAnnotation object example/template.
    ///</param>
    procedure Visit(widget: DNWidgetAnnotation); overload;
    ///<summary>
    ///  Visit/select movie annotation.
    ///</summary>
    ///  <param name="movie">
    ///  MovieAnnotation object example/template.
    ///</param>
    procedure Visit(movie: DNMovieAnnotation); overload;
    ///<summary>
    ///  Visit/select screen annotation.
    ///</summary>
    ///  <param name="screen">
    ///  ScreenAnnotation object example/template.
    ///</param>
    procedure Visit(screen: DNScreenAnnotation); overload;

  end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  ///<summary>
  ///  Represents general interface for actions and destinations.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.IAppointment')]
  DNIAppointment = interface(DDN.mscorlib.DNObject)
  ['{68FB3EE4-EEF7-3960-89B4-EDD99C58EBEB}']
  { methods } 

    ///<summary>
    ///  Returns string representation
    ///</summary>
    ///<returns></returns>
    function ToString: string;

  end;

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Holds functionality to tune fonts
  ///</summary>
  [DNTypeName('Aspose.Pdf.Document+IDocumentFontUtilities')]
  DNDocument_IDocumentFontUtilities = interface(DDN.mscorlib.DNObject)
  ['{11514758-1979-37EB-8B5A-C57E8CFCCA29}']
  { methods } 

    ///<summary>
    ///  Subsets all fonts in document
    ///</summary>
    ///  <param name="subsetStrategy">strategy</param>
    procedure SubsetFonts(subsetStrategy: DNFontSubsetStrategy);
    ///<summary>
    ///  Returns all fonts from document
    ///</summary>
    ///<returns>fonts</returns>
    function GetAllFonts: TArray<DNFont>;

  end;

  //-------------namespace: Aspose.Pdf.GroupProcessor----------------
  [DNTypeName('Aspose.Pdf.GroupProcessor.IDocumentPageTextExtractor')]
  DNIDocumentPageTextExtractor = interface(DDN.mscorlib.DNObject)
  ['{556CA483-2857-3EFC-869B-CD8FD671AAE4}']
  { getters & setters } 

    function get_PageCount: Int32;

  { methods } 

    function ExtractPageText(pageNumber: Int32): string;

  { propertys } 

    property PageCount: Int32 read get_PageCount;
  end;

  //-------------namespace: Aspose.Pdf.GroupProcessor----------------
  [DNTypeName('Aspose.Pdf.GroupProcessor.IDocumentTextExtractor')]
  DNIDocumentTextExtractor = interface(DDN.mscorlib.DNObject)
  ['{B3CBA481-8821-3208-A5B2-7BD3C456389F}']
  { methods } 

    function ExtractAllText: TArray<string>;

  end;

  //-------------namespace: Aspose.Pdf.GroupProcessor----------------
  ///<summary>
  ///  Represents interface to interacting with extractor.
  ///</summary>
  [DNTypeName('Aspose.Pdf.GroupProcessor.IPdfTypeExtractor')]
  DNIPdfTypeExtractor = interface(DNIDocumentTextExtractor)
  ['{1980B518-B706-36EE-8626-EF1D2522C93C}']
  { getters & setters } 

    function get_PageCount: Int32;
    function get_Version: string;
    function get_IsFastExtractionUsed: Boolean;

  { methods } 

    function ExtractAllText: TArray<string>;
    function ExtractPageText(pageNumber: Int32): string;
    procedure Dispose;

  { propertys } 

    property PageCount: Int32 read get_PageCount;
    property Version: string read get_Version;
    property IsFastExtractionUsed: Boolean read get_IsFastExtractionUsed;
  end;

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Interface for color space conversion strategies.
  ///</summary>
  [DNTypeName('Aspose.Pdf.IColorSpaceConversionStrategy')]
  DNIColorSpaceConversionStrategy = interface(DDN.mscorlib.DNObject)
  ['{29DCF425-B108-3A96-9B1D-66E5EF8542D8}']
  { methods } 

    ///<summary>
    ///  Converts the page of document.
    ///</summary>
    ///  <param name="page">The page of document.</param>
    procedure Convert(page: DNPage);

  end;

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  This interface declared for customization algorithms of quantization.
  ///  Users can implement their own realization of this algorithms (for example algorithms based on unmanaged code).
  ///</summary>
  [DNTypeName('Aspose.Pdf.IIndexBitmapConverter')]
  DNIIndexBitmapConverter = interface(DDN.mscorlib.DNObject)
  ['{D38C3BEE-DACA-37A9-B276-D2E356990339}']
  { methods } 

    ///<summary>
    ///  Returns 1Bpp bitmap representation
    ///</summary>
    ///  <param name="src">Source bitmap.</param>
    ///<returns>Bitmap in 1 bpp image format.</returns>
    function Get1BppImage(src: DDN.System.Drawing.DNBitmap): DDN.System.Drawing.DNBitmap;
    ///<summary>
    ///  Returns 4Bpp bitmap representation
    ///</summary>
    ///  <param name="src">Source bitmap.</param>
    ///<returns>Bitmap in 4 bpp image format.</returns>
    function Get4BppImage(src: DDN.System.Drawing.DNBitmap): DDN.System.Drawing.DNBitmap;
    ///<summary>
    ///  Returns 8Bpp bitmap representation
    ///</summary>
    ///  <param name="src">Source bitmap.</param>
    ///<returns>Bitmap in 8 bpp image format.</returns>
    function Get8BppImage(src: DDN.System.Drawing.DNBitmap): DDN.System.Drawing.DNBitmap;

  end;

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Collection of Named Destinations.
  ///</summary>
  [DNTypeName('Aspose.Pdf.INamedDestinationCollection')]
  DNINamedDestinationCollection = interface(DDN.mscorlib.DNObject)
  ['{FC4347DF-8EEF-383A-8259-26E3FB8BCABC}']
  { getters & setters } 

    function get_Item(name: string): DNIAppointment;
    procedure set_Item(name: string; value: DNIAppointment);
    function get_Count: Int32;
    function get_Names: TArray<string>;

  { methods } 

    ///<summary>
    ///  Removes destination by its name.
    ///</summary>
    ///  <param name="name"></param>
    procedure Remove(name: string);
    ///<summary>
    ///  Adds new named destination.
    ///</summary>
    ///  <param name="name"></param>
    ///  <param name="appointment"></param>
    procedure Add(name: string; appointment: DNIAppointment);

  { propertys } 

    property Item[name: string]: DNIAppointment read get_Item write set_Item; default;
    ///<summary>
    ///  Returns count of the destinations.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Gets array of names of the destiantions.
    ///</summary>
    property Names: TArray<string> read get_Names;
  end;

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Defines Visitor for visiting different pdf operators.
  ///</summary>
  [DNTypeName('Aspose.Pdf.IOperatorSelector')]
  DNIOperatorSelector = interface(DDN.mscorlib.DNObject)
  ['{53222EBF-0D3E-3609-AB15-676640C489C8}']
  { methods } 

    ///<summary>
    ///  Visit/select f operator.
    ///</summary>
    ///  <param name="f">
    ///  Fill path operator (nonzero winding number rule).
    ///</param>
    procedure Visit(f: DNFill); overload;
    ///<summary>
    ///  Visit/select F operator.
    ///</summary>
    ///  <param name="F">
    ///  Fill path operator (nonzero winding number rule).
    ///</param>
    procedure Visit(F: DNObsoleteFill); overload;
    ///<summary>
    ///  Visit/select operator f*.
    ///</summary>
    ///  <param name="f_">
    ///  Fill path operator (even-odd rule).
    ///</param>
    procedure Visit(f_: DNEOFill); overload;
    ///<summary>
    ///  Visit/select G operator.
    ///</summary>
    ///  <param name="G">
    ///  Set gray level operator (for stroking operations).
    ///</param>
    procedure Visit(G: DNSetGrayStroke); overload;
    ///<summary>
    ///  Visit/select g operator.
    ///</summary>
    ///  <param name="g">
    ///  Set gray level operator (for nonstroking operations).
    ///</param>
    procedure Visit(g: DNSetGray); overload;
    ///<summary>
    ///  Visit/select gs operator.
    ///</summary>
    ///  <param name="gs">
    ///  Set graphics state operator.
    ///</param>
    procedure Visit(gs: DNGS); overload;
    ///<summary>
    ///  Visit/select h operator.
    ///</summary>
    ///  <param name="h">
    ///  Close subpath operator.
    ///</param>
    procedure Visit(h: DNClosePath); overload;
    ///<summary>
    ///  Visit/select i operator.
    ///</summary>
    ///  <param name="i">
    ///  Set flatness tolerance operator.
    ///</param>
    procedure Visit(i: DNSetFlat); overload;
    ///<summary>
    ///  Visit/select ID operator.
    ///</summary>
    ///  <param name="ID">
    ///  Begin inline image data operator.
    ///</param>
    procedure Visit(ID: DNOperators_ID); overload;
    ///<summary>
    ///  Visit/select ri operator.
    ///</summary>
    ///  <param name="ri">
    ///  Set color rendering intent operator.
    ///</param>
    procedure Visit(ri: DNSetColorRenderingIntent); overload;
    ///<summary>
    ///  Visit/select J operator.
    ///</summary>
    ///  <param name="J">
    ///  Set line cap style operator.
    ///</param>
    procedure Visit(J: DNSetLineCap); overload;
    ///<summary>
    ///  Visit/select M operator.
    ///</summary>
    ///  <param name="M">
    ///  Set miter limit operator.
    ///</param>
    procedure Visit(M: DNSetMiterLimit); overload;
    ///<summary>
    ///  Visit/select MP operator.
    ///</summary>
    ///  <param name="MP">
    ///  Define marked-content point operator.
    ///</param>
    procedure Visit(MP: DNMP); overload;
    ///<summary>
    ///  Visit/select n operator.
    ///</summary>
    ///  <param name="n">
    ///  End path operator (without filling or stroking).
    ///</param>
    procedure Visit(n: DNEndPath); overload;
    ///<summary>
    ///  Visit/select q operator.
    ///</summary>
    ///  <param name="q">
    ///  Save graphics state operator.
    ///</param>
    procedure Visit(q: DNGSave); overload;
    ///<summary>
    ///  Visit/select Q operator.
    ///</summary>
    ///  <param name="Q">
    ///  Restore graphics state operator.
    ///</param>
    procedure Visit(Q: DNGRestore); overload;
    ///<summary>
    ///  Visit/select re operator.
    ///</summary>
    ///  <param name="re">
    ///  Append rectangle to path operator.
    ///</param>
    procedure Visit(re: DNRe); overload;
    ///<summary>
    ///  Visit/select RG operator.
    ///</summary>
    ///  <param name="RG">
    ///  Set RGB color operator (for stroking operations).
    ///</param>
    procedure Visit(RG: DNSetRGBColorStroke); overload;
    ///<summary>
    ///  Visit/select rg operator.
    ///</summary>
    ///  <param name="rg">
    ///  Set RGB color operator (for nonstroking operations).
    ///</param>
    procedure Visit(rg: DNSetRGBColor); overload;
    ///<summary>
    ///  Visit/select K operator.
    ///</summary>
    ///  <param name="K">
    ///  Set CMYK color operator (for stroking operations).
    ///</param>
    procedure Visit(K: DNSetCMYKColorStroke); overload;
    ///<summary>
    ///  Visit/select k operator.
    ///</summary>
    ///  <param name="k">
    ///  Set CMYK color operator (for nonstroking operations).
    ///</param>
    procedure Visit(k: DNSetCMYKColor); overload;
    ///<summary>
    ///  Visit/select l operator.
    ///</summary>
    ///  <param name="l">
    ///  Append straight line segment to path operator.
    ///</param>
    procedure Visit(l: DNLineTo); overload;
    ///<summary>
    ///  Visit/select m operator.
    ///</summary>
    ///  <param name="m">
    ///  Begin new subpath operator.
    ///</param>
    procedure Visit(m: DNMoveTo); overload;
    ///<summary>
    ///  Visit/select Tw operator.
    ///</summary>
    ///  <param name="Tw">
    ///  Set word spacing operator.
    ///</param>
    procedure Visit(Tw: DNSetWordSpacing); overload;
    ///<summary>
    ///  Visit/select s operator.
    ///</summary>
    ///  <param name="s">
    ///  Close and stroke path operator.
    ///</param>
    procedure Visit(s: DNClosePathStroke); overload;
    ///<summary>
    ///  Visit/select TD operator.
    ///</summary>
    ///  <param name="TD">
    ///  Move text position and set leading operator.
    ///</param>
    procedure Visit(TD: DNMoveTextPositionSetLeading); overload;
    ///<summary>
    ///  Visit/select Tf operator.
    ///</summary>
    ///  <param name="Tf">
    ///  Set text font and size operator.
    ///</param>
    procedure Visit(Tf: DNSelectFont); overload;
    ///<summary>
    ///  Visit/select Tj operator.
    ///</summary>
    ///  <param name="Tj">
    ///  Show text operator.
    ///</param>
    procedure Visit(Tj: DNShowText); overload;
    ///<summary>
    ///  Visit/select TJ operator.
    ///</summary>
    ///  <param name="TJ">
    ///  Show text operator (allowing individual glyph positioning).
    ///</param>
    procedure Visit(TJ: DNSetGlyphsPositionShowText); overload;
    ///<summary>
    ///  Visit/select TL operator.
    ///</summary>
    ///  <param name="TL">
    ///  Set text leading operator.
    ///</param>
    procedure Visit(TL: DNSetTextLeading); overload;
    ///<summary>
    ///  Visit/select Tm operator.
    ///</summary>
    ///  <param name="Tm">
    ///  Set text matrix and text line matrix operator.
    ///</param>
    procedure Visit(Tm: DNSetTextMatrix); overload;
    ///<summary>
    ///  Visit/select Tr operator.
    ///</summary>
    ///  <param name="Tr">
    ///  Set text rendering mode operator.
    ///</param>
    procedure Visit(Tr: DNSetTextRenderingMode); overload;
    ///<summary>
    ///  Visit/select Ts operator.
    ///</summary>
    ///  <param name="Ts">
    ///  Set text rise operator.
    ///</param>
    procedure Visit(Ts: DNSetTextRise); overload;
    ///<summary>
    ///  Visit/select S operator.
    ///</summary>
    ///  <param name="S">
    ///  Stroke path operator.
    ///</param>
    procedure Visit(S: DNStroke); overload;
    ///<summary>
    ///  Visit/select SC operator.
    ///</summary>
    ///  <param name="SC">
    ///  Set color operator (for stroking operations).
    ///</param>
    procedure Visit(SC: DNSetColorStroke); overload;
    ///<summary>
    ///  Visit/select sc operator.
    ///</summary>
    ///  <param name="sc">
    ///  Set color operator (for nonstroking operations).
    ///</param>
    procedure Visit(sc: DNSetColor); overload;
    ///<summary>
    ///  Visit/select SCN operator.
    ///</summary>
    ///  <param name="SCN">
    ///  Set color operator (for stroking operations, ICCBasedand special colour spaces).
    ///</param>
    procedure Visit(SCN: DNSetAdvancedColorStroke); overload;
    ///<summary>
    ///  Visit/select scn operator.
    ///</summary>
    ///  <param name="scn">
    ///  Set color operator (for nonstroking operations, ICCBased and special colour spaces).
    ///</param>
    procedure Visit(scn: DNSetAdvancedColor); overload;
    ///<summary>
    ///  Visit/select sh operator.
    ///</summary>
    ///  <param name="sh">
    ///  Paint area defined by shading pattern operator.
    ///</param>
    procedure Visit(sh: DNShFill); overload;
    ///<summary>
    ///  Visit/select T* operator.
    ///</summary>
    ///  <param name="T_">
    ///  Move to start of next text line operator.
    ///</param>
    procedure Visit(T_: DNMoveToNextLine); overload;
    ///<summary>
    ///  Visit/select Tc operator.
    ///</summary>
    ///  <param name="Tc">
    ///  Set character spacing operator.
    ///</param>
    procedure Visit(Tc: DNSetCharacterSpacing); overload;
    ///<summary>
    ///  Visit/select Td operator.
    ///</summary>
    ///  <param name="Td">
    ///  Move text position operator.
    ///</param>
    procedure Visit(Td: DNMoveTextPosition); overload;
    ///<summary>
    ///  Visit/select y operator.
    ///</summary>
    ///  <param name="y">
    ///  Append curved segment to path operator (final point replicated).
    ///</param>
    procedure Visit(y: DNCurveTo2); overload;
    ///<summary>
    ///  Visit/select W* operator.
    ///</summary>
    ///  <param name="W_">
    ///  Set clipping path operator (even-odd rule).
    ///</param>
    procedure Visit(W_: DNEOClip); overload;
    ///<summary>
    ///  Visit/select Tz operator.
    ///</summary>
    ///  <param name="Tz">
    ///  Set horizontal text scaling operator.
    ///</param>
    procedure Visit(Tz: DNSetHorizontalTextScaling); overload;
    ///<summary>
    ///  Visit/select v operator.
    ///</summary>
    ///  <param name="v">
    ///  Append curved segment to path operator (initial point replicated).
    ///</param>
    procedure Visit(v: DNCurveTo1); overload;
    ///<summary>
    ///  Visit/select W operator.
    ///</summary>
    ///  <param name="W">
    ///  Set clipping path operator (nonzero winding number rule).
    ///</param>
    procedure Visit(W: DNClip); overload;
    ///<summary>
    ///  Visit/select w operator.
    ///</summary>
    ///  <param name="w">
    ///  Set line width operator.
    ///</param>
    procedure Visit(w: DNSetLineWidth); overload;
    ///<summary>
    ///  Visit/select j operator.
    ///</summary>
    ///  <param name="j">
    ///  Set line join style operator.
    ///</param>
    procedure Visit(j: DNSetLineJoin); overload;
    ///<summary>
    ///  Visit/select EX operator.
    ///</summary>
    ///  <param name="EX">
    ///  End compatibility section operator.
    ///</param>
    procedure Visit(EX: DNEX); overload;
    ///<summary>
    ///  Visit/select ET operator.
    ///</summary>
    ///  <param name="ET">
    ///  End text object operator.
    ///</param>
    procedure Visit(ET: DNET); overload;
    ///<summary>
    ///  Visit/select EMC operator.
    ///</summary>
    ///  <param name="EMC">
    ///  End marked-content sequence operator.
    ///</param>
    procedure Visit(EMC: DNEMC); overload;
    ///<summary>
    ///  Visit/select EI operator.
    ///</summary>
    ///  <param name="EI">
    ///  End inline image object operator.
    ///</param>
    procedure Visit(EI: DNEI); overload;
    ///<summary>
    ///  Visit/select DP operator.
    ///</summary>
    ///  <param name="DP">
    ///  Define marked-content point operator (with property list).
    ///</param>
    procedure Visit(DP: DNDP); overload;
    ///<summary>
    ///  Visit/select Do operator.
    ///</summary>
    ///  <param name="Do">
    ///  Invoke named XObject operator.
    ///</param>
    procedure Visit(&Do: DNDo); overload;
    ///<summary>
    ///  Visit/select d operator.
    ///</summary>
    ///  <param name="d">
    ///  Set line dash pattern operator.
    ///</param>
    procedure Visit(d: DNSetDash); overload;
    ///<summary>
    ///  Visit/select d0 operator.
    ///</summary>
    ///  <param name="d0">
    ///  Set glyph width in Type 3 font operator.
    ///</param>
    procedure Visit(d0: DNSetCharWidth); overload;
    ///<summary>
    ///  Visit/select d1 operator.
    ///</summary>
    ///  <param name="d1">
    ///  Set glyph width and bounding box in Type 3 font operator.
    ///</param>
    procedure Visit(d1: DNSetCharWidthBoundingBox); overload;
    ///<summary>
    ///  Visit/select CS operator.
    ///</summary>
    ///  <param name="CS">
    ///  Set color space operator (for stroking operations).
    ///</param>
    procedure Visit(CS: DNSetColorSpaceStroke); overload;
    ///<summary>
    ///  Visit/select cs operator.
    ///</summary>
    ///  <param name="cs">
    ///  Set color space operator (for nonstroking operations).
    ///</param>
    procedure Visit(cs: DNSetColorSpace); overload;
    ///<summary>
    ///  Visit/select cm operator.
    ///</summary>
    ///  <param name="cm">
    ///  Concatenate matrix to current transformation matrix operator.
    ///</param>
    procedure Visit(cm: DNConcatenateMatrix); overload;
    ///<summary>
    ///  Visit/select c operator.
    ///</summary>
    ///  <param name="c">
    ///  Append curved segment to path operator (three control points).
    ///</param>
    procedure Visit(c: DNCurveTo); overload;
    ///<summary>
    ///  Visit/select BX operator.
    ///</summary>
    ///  <param name="BX">
    ///  Begin compatibility section operator.
    ///</param>
    procedure Visit(BX: DNBX); overload;
    ///<summary>
    ///  Visit/select BT operator.
    ///</summary>
    ///  <param name="BT">
    ///  Begin text object operator.
    ///</param>
    procedure Visit(BT: DNBT); overload;
    ///<summary>
    ///  Visit/select BMC operator.
    ///</summary>
    ///  <param name="BMC">
    ///  Begin marked-content sequence operator.
    ///</param>
    procedure Visit(BMC: DNBMC); overload;
    ///<summary>
    ///  Visit/select BI operator.
    ///</summary>
    ///  <param name="BI">
    ///  Begin inline image object operator.
    ///</param>
    procedure Visit(BI: DNBI); overload;
    ///<summary>
    ///  Visit/select BDC operator.
    ///</summary>
    ///  <param name="BDC">
    ///  Begin marked-content sequence operator (with property list).
    ///</param>
    procedure Visit(BDC: DNBDC); overload;
    ///<summary>
    ///  Visit/select B operator.
    ///</summary>
    ///  <param name="B">
    ///  Fill and stroke path operator (nonzero winding number rule).
    ///</param>
    procedure Visit(B: DNFillStroke); overload;
    ///<summary>
    ///  Visit/select b operator.
    ///</summary>
    ///  <param name="b">
    ///  Close, fill, and stroke path operator (nonzero winding number rule).
    ///</param>
    procedure Visit(b: DNClosePathFillStroke); overload;
    ///<summary>
    ///  Visit/select B* operator.
    ///</summary>
    ///  <param name="B_">
    ///  Fill and stroke path operator (even-odd rule).
    ///</param>
    procedure Visit(B_: DNEOFillStroke); overload;
    ///<summary>
    ///  Visit/select b* operator.
    ///</summary>
    ///  <param name="b_">
    ///  Close, fill, and stroke path operator (even-odd rule).
    ///</param>
    procedure Visit(b_: DNClosePathEOFillStroke); overload;
    ///<summary>
    ///  Visit/select ' operator.
    ///</summary>
    ///  <param name="_">
    ///  Move to next line and show text operator.
    ///</param>
    procedure Visit(_: DNMoveToNextLineShowText); overload;
    ///<summary>
    ///  Visit/select '' operator.
    ///</summary>
    ///  <param name="__">
    ///  Set word and character spacing, move to next line, and show text operator.
    ///</param>
    procedure Visit(__: DNSetSpacingMoveToNextLineShowText); overload;
    ///<summary>
    ///  Visit/select any text operator operator.
    ///</summary>
    ///  <param name="textOperator">
    ///  General text operator which is used to select the set of corresponding pdf operators.
    ///</param>
    procedure Visit(textOperator: DNTextOperator); overload;

  end;

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Defines conversion options related to a set of pages to convert.
  ///</summary>
  [DNTypeName('Aspose.Pdf.IPageSetOptions')]
  DNIPageSetOptions = interface(DDN.mscorlib.DNObject)
  ['{12D7FFEC-5638-32A5-A8F7-4E47210D47F7}']
  { getters & setters } 

    function get_ExplicitListOfSavedPages: TArray<Int32>;
    procedure set_ExplicitListOfSavedPages(value: TArray<Int32>);

  { propertys } 

    ///<summary>
    ///  Specifies the array of numbers of pages to convert.
    ///</summary>
    property ExplicitListOfSavedPages: TArray<Int32> read get_ExplicitListOfSavedPages write set_ExplicitListOfSavedPages;
  end;

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Defines conversion options related to pipeline configuration.
  ///</summary>
  [DNTypeName('Aspose.Pdf.IPipelineOptions')]
  DNIPipelineOptions = interface(DDN.mscorlib.DNObject)
  ['{F491BECB-C63F-3B3B-B17B-C82069D0294C}']
  { getters & setters } 

    function get_BatchSize: Int32;
    procedure set_BatchSize(value: Int32);

  { propertys } 

    ///<summary>
    ///  Specifies the size of a portion of pages to pass from node to node.
    ///</summary>
    property BatchSize: Int32 read get_BatchSize write set_BatchSize;
  end;

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Resource loading callback.
  ///</summary>
  [DNTypeName('Aspose.Pdf.IResourceLoadingCallback')]
  DNIResourceLoadingCallback = interface(DDN.mscorlib.DNObject)
  ['{539BB742-5A4A-3CA6-8ECC-8494E425137C}']
  { methods } 

    ///<summary>
    ///  Resource loading
    ///</summary>
    ///  <param name="sender"></param>
    ///  <param name="e"></param>
    ///<returns></returns>
    function ResourceLoading(sender: DDN.mscorlib.DNObject; e: DNResourceLoadingEventArgs): DNResourceLoadingResult;

  end;

  //-------------namespace: Aspose.Pdf----------------
  ///<summary>
  ///  Interface for user's callback mechanism support.
  ///</summary>
  [DNTypeName('Aspose.Pdf.IWarningCallback')]
  DNIWarningCallback = interface(DDN.mscorlib.DNObject)
  ['{C893114E-B519-3477-A372-3112A391C27D}']
  { methods } 

    ///<summary>
    ///  The callback method for some program notifications.
    ///</summary>
    ///  <param name="warning">
    ///  the warning information for some happened warning
    ///</param>
    ///<returns>
    ///  the result of further program workflow
    ///</returns>
    function Warning(warning: DNWarningInfo): DNReturnAction;

  end;

  //-------------namespace: Aspose.Pdf.LogicalStructure----------------
  ///<summary>
  ///  Interface for presenting text structure elements.
  ///</summary>
  [DNTypeName('Aspose.Pdf.LogicalStructure.ITextElement')]
  DNITextElement = interface(DDN.mscorlib.DNObject)
  ['{A30E0947-1393-3425-BBB1-933E19BA0CEB}']
  { getters & setters } 

    function get_StructureTextState: DNStructureTextState;

  { methods } 

    ///<summary>
    ///  Appends text content to current text element.
    ///</summary>
    ///  <param name="text">Text content</param>
    procedure SetText(text: string);

  { propertys } 

    ///<summary>
    ///  Gets <see cref="T:/Aspose.Pdf.LogicalStructure.StructureTextState" />
    ///  object for text structure element.
    ///</summary>
    ///<value><see cref="T:/Aspose.Pdf.LogicalStructure.StructureTextState" />
    ///  object for text structure element.</value>
    property StructureTextState: DNStructureTextState read get_StructureTextState;
  end;

  //-------------namespace: Aspose.Pdf.Tagged----------------
  ///<summary>
  ///  Represents interface for work with TaggedPdf content of document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Tagged.ITaggedContent')]
  DNITaggedContent = interface(DDN.mscorlib.DNObject)
  ['{39803D5A-A88B-32F6-9518-64C316D9DB06}']
  { getters & setters } 

    function get_StructureTextState: DNStructureTextState;
    function get_StructTreeRootElement: DNStructTreeRootElement;
    function get_RootElement: DNStructureElement;

  { methods } 

    ///<summary><para>Sets natural language for pdf document.</para><para>A language identifier that shall specify the natural language for all text in the document except where overridden by language specifications for structure elements or marked content.</para></summary>
    ///  <param name="lang">A language identifier shall either be the empty text string, to indicate that the language is unknown, or a Language-Tag as defined in RFC 3066, Tags for the Identification of Languages.</param>
    procedure SetLanguage(lang: string);
    ///<summary><para>Sets title for PDF document.</para></summary>
    ///  <param name="title">The title of PDF document.</param>
    procedure SetTitle(title: string);
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.PartElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreatePartElement: DNPartElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.ArtElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateArtElement: DNArtElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.SectElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateSectElement: DNSectElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.DivElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateDivElement: DNDivElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.BlockQuoteElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateBlockQuoteElement: DNBlockQuoteElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.CaptionElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateCaptionElement: DNCaptionElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.TOCElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateTOCElement: DNTOCElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.TOCIElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateTOCIElement: DNTOCIElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.IndexElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateIndexElement: DNIndexElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.NonStructElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateNonStructElement: DNNonStructElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.PrivateElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreatePrivateElement: DNPrivateElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.ParagraphElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateParagraphElement: DNParagraphElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.HeaderElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateHeaderElement: DNHeaderElement; overload;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.HeaderElement" />
    ///  with level.</para></summary>
    ///  <param name="level">The level of Header. Must be 1, 2, 3, 4, 5 or 6.</param>
    ///<returns>Created structure element.</returns>
    function CreateHeaderElement(level: Int32): DNHeaderElement; overload;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.ListElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateListElement: DNListElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.TableElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateTableElement: DNTableElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.TableTHeadElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateTableTHeadElement: DNTableTHeadElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.TableTHeadElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateTableTBodyElement: DNTableTBodyElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.TableTFootElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateTableTFootElement: DNTableTFootElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.TableTRElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateTableTRElement: DNTableTRElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.TableTHElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateTableTHElement: DNTableTHElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.TableTDElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateTableTDElement: DNTableTDElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.SpanElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateSpanElement: DNSpanElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.QuoteElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateQuoteElement: DNQuoteElement;
    function CreateNoteElement: DNNoteElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.ReferenceElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateReferenceElement: DNReferenceElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.BibEntryElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateBibEntryElement: DNBibEntryElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.CodeElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateCodeElement: DNCodeElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.LinkElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateLinkElement: DNLinkElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.AnnotElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateAnnotElement: DNAnnotElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.RubyElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateRubyElement: DNRubyElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.WarichuElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateWarichuElement: DNWarichuElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.FigureElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateFigureElement: DNLogicalStructure_FigureElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.FormulaElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateFormulaElement: DNFormulaElement;
    ///<summary><para>Creates <see cref="T:Aspose.Pdf.LogicalStructure.FormElement" />
    ///  .</para></summary>
    ///<returns>Created structure element.</returns>
    function CreateFormElement: DNFormElement;

  { propertys } 

    ///<summary><para>Get <see cref="T:Aspose.Pdf.LogicalStructure.StructureTextState" />
    ///  settings for whole document.</para></summary>
    ///<value><see cref="T:Aspose.Pdf.LogicalStructure.StructureTextState" />
    ///  settings for whole document.</value>
    property StructureTextState: DNStructureTextState read get_StructureTextState;
    ///<summary><para>Gets <see cref="T:Aspose.Pdf.LogicalStructure.StructTreeRootElement" />
    ///  of PDF document.</para></summary>
    ///<value><see cref="T:Aspose.Pdf.LogicalStructure.StructTreeRootElement" />
    ///  of PDF document.</value>
    property StructTreeRootElement: DNStructTreeRootElement read get_StructTreeRootElement;
    ///<summary><para>Gets root <see cref="T:Aspose.Pdf.LogicalStructure.StructureElement" />
    ///  of logical structure of PDF document.</para></summary>
    ///<value>Root <see cref="T:Aspose.Pdf.LogicalStructure.StructureElement" />
    ///  of logical structure of PDF document.</value>
    property RootElement: DNStructureElement read get_RootElement;
  end;

  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  Useful properties to tune Font behaviour
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.IFontOptions')]
  DNIFontOptions = interface(DDN.mscorlib.DNObject)
  ['{D0475854-BC93-35F9-A734-E7C255E441EA}']
  { getters & setters } 

    function get_NotifyAboutFontEmbeddingError: Boolean;
    procedure set_NotifyAboutFontEmbeddingError(value: Boolean);

  { propertys } 

    ///<summary>
    ///  Sometimes it's not possible to embed desired font into document. There are many reasons, for example
    ///  license restrictions or when desired font was not found on destination computer.
    ///  When this situation comes it's not simply to detect, because desired font is embedded via set
    ///  of property flag Font.IsEmbedded = true; Of course it's possible to read this property immediately after it was set but
    ///  it's not convenient approach. Flag NotifyAboutFontEmbeddingError enforces exception mechanism
    ///  for cases when attempt to embed font became failed. If this flag is set an exception of type
    ///<see cref="T:Aspose.Pdf.FontEmbeddingException" />
    ///  will be thrown. By default false.
    ///</summary>
    property NotifyAboutFontEmbeddingError: Boolean read get_NotifyAboutFontEmbeddingError write set_NotifyAboutFontEmbeddingError;
  end;

  //-------------namespace: Aspose.Pdf.Text----------------
  ///<summary>
  ///  This interface represents an element of existing table extracted by TableAbsorber.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Text.ITableElement')]
  DNITableElement = interface(DDN.mscorlib.DNObject)
  ['{05D456CE-8272-313C-8CE0-E47BD16B8618}']
  { getters & setters } 

    function get_Rectangle: DNPdf_Rectangle;

  { propertys } 

    ///<summary>
    ///  Gets rectangle that describes position of table element on the page
    ///</summary>
    property Rectangle: DNPdf_Rectangle read get_Rectangle;
  end;

  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  General facade interface that defines common facades methods.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.IFacade')]
  DNIFacade = interface(DDN.mscorlib.DNIDisposable)
  ['{FC5E8C17-4B73-3AB9-87F6-7B05370683D5}']
  { methods } 

    ///<summary>
    ///  Binds PDF document for editing.
    ///</summary>
    ///  <param name="srcFile">The path of input PDF document.</param>
    procedure BindPdf(srcFile: string); overload;
    ///<summary>
    ///  Binds PDF document for editing.
    ///</summary>
    ///  <param name="srcStream">The stream of input PDF document.</param>
    procedure BindPdf(srcStream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Binds PDF document for editing.
    ///</summary>
    ///  <param name="srcDoc">Input PDF document.</param>
    procedure BindPdf(srcDoc: DNDocument); overload;
    ///<summary>
    ///  Releases any resources associates with the current facade.
    ///</summary>
    procedure Close;

  end;

  //-------------namespace: Aspose.Pdf.Facades----------------
  ///<summary>
  ///  Facade interface that defines methods common for all saveable facades.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Facades.ISaveableFacade')]
  DNISaveableFacade = interface(DNIFacade)
  ['{B3768FA2-D883-37E2-BC87-5E5D7655FA29}']
  { methods } 

    ///<summary>
    ///  Saves the result PDF document to file.
    ///</summary>
    ///  <param name="destFile">The path of output PDF document.</param>
    procedure Save(destFile: string); overload;
    ///<summary>
    ///  Saves the result PDF document to stream.
    ///</summary>
    ///  <param name="destStream">The stream of output PDF document.</param>
    procedure Save(destStream: DDN.mscorlib.DNStream); overload;

  end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNActionCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{529DA8E0-CA2E-53F1-BDA8-024F3A35A41E}']
  end;

  ///<summary>
  ///  Collection of actions
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.ActionCollection')]
  DNActionCollection = interface(DDN.mscorlib.DNObject)
  ['{8425AAA6-173B-3773-B1C2-B8D586560C7E}']
  { getters & setters } 

    function get_Count: Int32;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNPdfAction;

  { methods } 

    ///<summary>
    ///  Removes action from collection by index.
    ///</summary>
    ///  <param name="index">Index of action to remove.</param>
    procedure Delete(index: Int32); overload;
    ///<summary>
    ///  Delete all actions.
    ///</summary>
    procedure Delete; overload;
    ///<summary>
    ///  Copies actions array into collection.
    ///</summary>
    ///  <param name="array">Array of actions which must be copied into collection.</param>
    ///  <param name="index">Index starting from which array will be copied.</param>
    procedure CopyTo(&array: TArray<DNPdfAction>; index: Int32);
    ///<summary>
    ///  Returns enumerator for collection.
    ///</summary>
    ///<returns>Collection enumerator.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNPdfAction>;
    ///<summary>
    ///  Returns true if give item presents in the collection.
    ///</summary>
    ///  <param name="item"></param>
    ///<returns></returns>
    function &Contains(item: DNPdfAction): Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Count of actions on the collection.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Returns true if object is synchronized.
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets synchronization object.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Returns true if collection is readonly.
    ///</summary>
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNPdfAction read get_Item; default;
  end;

  TDNActionCollection = class(TDNGenericImport<DNActionCollectionClass, DNActionCollection>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNAnnotationCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B3970C9A-DC82-51A2-B34B-EAEA329D837B}']
  end;

  ///<summary>
  ///  Class representing annotation collection.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.AnnotationCollection')]
  DNAnnotationCollection = interface(DDN.mscorlib.DNObject)
  ['{E070C097-B984-3D69-8AC2-DF14715576F8}']
  { getters & setters } 

    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_Item(index: Int32): DNAnnotation;

  { methods } 

    ///<summary>
    ///  Adds annotation to the collection. If page is rotated then annotation rectangle will be recalculated accordingly.
    ///</summary>
    ///  <param name="annotation">Annotation which shall be added.</param>
    ///  <param name="considerRotation">If true and if page is rotated then annotation position will be recaculated accroding to page rotation.</param>
    procedure Add(annotation: DNAnnotation; considerRotation: Boolean);
    ///<summary>
    ///  Deletes annotation from the collection by index.
    ///</summary>
    ///  <param name="index">Index of annotation which shall be deleted.</param>
    procedure Delete(index: Int32); overload;
    ///<summary>
    ///  Deletes all annotations from the collection.
    ///</summary>
    procedure Delete; overload;
    ///<summary>
    ///  Copies array of annotations into collection.
    ///</summary>
    ///  <param name="array">Array to copy into collection.</param>
    ///  <param name="index">Starting index where colleciton wil lbe copied.</param>
    procedure CopyTo(&array: TArray<DNAnnotation>; index: Int32);
    ///<summary>
    ///  Returns collection enumerator.
    ///</summary>
    ///<returns>Enumerator object</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNAnnotation>;
    ///<summary>
    ///  Accepts visitor to process annotation.
    ///</summary>
    ///  <param name="visitor">Annotation selector object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Deletes specified annotation from the collection.
    ///</summary>
    ///  <param name="annotation">Annotation which shall be deleted.</param>
    procedure Delete(annotation: DNAnnotation); overload;
    ///<summary>
    ///  Checks if specified annotation belong to collection.
    ///</summary>
    ///  <param name="annotation">Annotation to be searched.</param>
    function &Contains(annotation: DNAnnotation): Boolean;
    ///<summary>
    ///  Returns annotation by its name.
    ///</summary>
    ///  <param name="name">Name of the annotation</param>
    ///<returns></returns>
    function FindByName(name: string): DNAnnotation;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets a value indicating whether access to the Aspose.Pdf.Annotations.AnnotationCollection is synchronized (thread safe).
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets an object that can be used to synchronize access to Aspose.Pdf.Annotations.AnnotationCollection.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Gets count of annotations in collection.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Gets a value indicating if collection is readonly.
    ///</summary>
    property IsReadOnly: Boolean read get_IsReadOnly;
    property Item[index: Int32]: DNAnnotation read get_Item; default;
  end;

  TDNAnnotationCollection = class(TDNGenericImport<DNAnnotationCollectionClass, DNAnnotationCollection>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNAnnotationSelectorClass = interface(DNObjectClass)
  ['{19187F87-EF9E-5492-B4CC-ADB2FB4D621F}']
  { constructors } 

    ///<summary>
    ///  Initializes new instance of the AnnotationSelector class.
    ///</summary>
    {class} function init: DNAnnotationSelector; overload;
    ///<summary>
    ///  Initializes new <see cref="T:Aspose.Pdf.Annotations.AnnotationSelector" />
    ///  object.
    ///</summary>
    ///  <param name="annotation">
    ///  Annotation to be selected.
    ///  This object only describes some characteristics we want found annotations to have, e.g. the type of annotation.
    ///</param>
    {class} function init(annotation: DNAnnotation): DNAnnotationSelector; overload;

  end;

  ///<summary>
  ///  This class is used for selecting annotations using Visitor template idea.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.AnnotationSelector')]
  DNAnnotationSelector = interface(DNIAnnotationVisitor)
  ['{AF620BE3-42DD-3C06-B70D-08DDC587EF1F}']
  { getters & setters } 

    function get_Selected: DDN.mscorlib.DNIList<DNAnnotation>;

  { methods } 

    ///<summary>
    ///  Select redact annotation if AnnotationSelector was initialized with RedactAnnotation object.
    ///</summary>
    ///  <param name="redact">RedactAnnotation object for selecting.</param>
    procedure Visit(redact: DNRedactionAnnotation); overload;
    ///<summary>
    ///  Select watermark annotation if AnnotationSelector was initialized with WatermarkAnnotation object.
    ///</summary>
    ///  <param name="watermark">WatermarkAnnotation for selecting.</param>
    procedure Visit(watermark: DNWatermarkAnnotation); overload;
    ///<summary>
    ///  Select movie annotation if AnnotationSelector was initialized with RichMedia annotation object.
    ///</summary>
    ///  <param name="richMedia">RichMedia annotation.</param>
    procedure Visit(richMedia: DNRichMediaAnnotation); overload;
    ///<summary>
    ///  Select PDF3D annotation if AnnotationSelector was initialized with PDF3DAnnotation object.
    ///</summary>
    ///  <param name="pdf3D">PDF3DAnnotation object for selecting.</param>
    procedure Visit(pdf3D: DNPDF3DAnnotation); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  The list of selected objects.
    ///</summary>
    property Selected: DDN.mscorlib.DNIList<DNAnnotation> read get_Selected;
  end;

  TDNAnnotationSelector = class(TDNGenericImport<DNAnnotationSelectorClass, DNAnnotationSelector>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNAppearanceDictionaryClass = interface(DDN.mscorlib.DNObjectClass)
  ['{6240BC5A-C56E-570C-B139-D44758952125}']
  end;

  ///<summary>
  ///  Annotation appearance dictionary specifying how the annotation shall be presented visually on the page.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.AppearanceDictionary')]
  DNAppearanceDictionary = interface(DDN.mscorlib.DNObject)
  ['{0318009F-4470-3ACF-B6BB-8DC5B0D2A5EB}']
  { getters & setters } 

    function get_IsReadOnly: Boolean;
    function get_IsFixedSize: Boolean;
    function get_Keys: DDN.mscorlib.DNICollection<string>;
    function get_Values: DDN.mscorlib.DNICollection<DNXForm>;
    function get_IsSynchronized: Boolean;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds an element with the provided key and value.
    ///</summary>
    ///  <param name="key">
    ///  Element key.
    ///</param>
    ///  <param name="value">
    ///  Element value.
    ///</param>
    procedure Add(key: DDN.mscorlib.DNObject; value: DDN.mscorlib.DNObject);
    ///<summary>
    ///  Returns an IDictionaryEnumerator object for the dictionary.
    ///</summary>
    ///<returns>Enumerator of the dictionary.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DDN.mscorlib.DNKeyValuePair<string, DNXForm>>;
    ///<summary>
    ///  Copies the elements of the dictionary to an Array, starting at a particular Array index.
    ///</summary>
    ///  <param name="array">Array where items must be copied.</param>
    ///  <param name="index">Index where items must be copied.</param>
    procedure CopyTo(&array: TArray<DNXForm>; index: Int32); overload;
    ///<summary>
    ///  Determines does this dictionary contasins specified key.
    ///</summary>
    ///  <param name="key">Key to search in the dictionary.</param>
    ///<returns>true if key is found.</returns>
    function ContainsKey(key: string): Boolean;
    function TryGetValue(key: string; out value: DNXForm): Boolean;
    function &Contains(item: DDN.mscorlib.DNKeyValuePair<string, DNXForm>): Boolean;
    procedure CopyTo(&array: TArray<DDN.mscorlib.DNKeyValuePair<string, DNXForm>>; arrayIndex: Int32); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets a value indicating whether dictionary is read-only.
    ///</summary>
    property IsReadOnly: Boolean read get_IsReadOnly;
    ///<summary>
    ///  Gets a value indicating whether dictionary has a fixed size.
    ///</summary>
    property IsFixedSize: Boolean read get_IsFixedSize;
    ///<summary>
    ///  Gets keys of the dictionary. If appearance dictionary has subditionaries, then <see cref="P:Aspose.Pdf.Annotations.AppearanceDictionary.Keys" />
    ///  contains (N|R|D).state values,
    ///  where N - normal appearance, R - rollover appearance, D - down appearance and state - the name of the state
    ///  (e.g. On, Off for checkboxes).
    ///</summary>
    property Keys: DDN.mscorlib.DNICollection<string> read get_Keys;
    ///<summary>
    ///  Gets the list of the dictionary values.
    ///  Result collection contains the list of XForm objects.
    ///</summary>
    property Values: DDN.mscorlib.DNICollection<DNXForm> read get_Values;
    ///<summary>
    ///  Gets a value indicating whether access to the dictionary is synchronized (thread safe).
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets an object that can be used to synchronize access to the dictionary.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Gets the number of elements contained in the dictionary.
    ///</summary>
    property Count: Int32 read get_Count;
  end;

  TDNAppearanceDictionary = class(TDNGenericImport<DNAppearanceDictionaryClass, DNAppearanceDictionary>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNBorderClass = interface(DDN.mscorlib.DNObjectClass)
  ['{5434F105-53F8-54BB-B7F1-9BEFDDABA890}']
  { constructors } 

    ///<summary>
    ///  Constructor for border object.
    ///</summary>
    ///  <param name="parent">Parent annotation.</param>
    {class} function init(parent: DNAnnotation): DNBorder;

  end;

  ///<summary>
  ///  Class representing characteristics of annotation border.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Border')]
  DNBorder = interface(DDN.mscorlib.DNObject)
  ['{76717D34-90E4-32B7-971D-9D6C4E10D9D0}']
  { getters & setters } 

    function get_HCornerRadius: Double;
    procedure set_HCornerRadius(value: Double);
    function get_VCornerRadius: Double;
    procedure set_VCornerRadius(value: Double);
    function get_Width: Int32;
    procedure set_Width(value: Int32);
    function get_EffectIntensity: Int32;
    procedure set_EffectIntensity(value: Int32);
    function get_Style: DNBorderStyle;
    procedure set_Style(value: DNBorderStyle);
    function get_Effect: DNBorderEffect;
    procedure set_Effect(value: DNBorderEffect);
    function get_Dash: DNDash;
    procedure set_Dash(value: DNDash);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets horizontal corner radius.
    ///</summary>
    property HCornerRadius: Double read get_HCornerRadius write set_HCornerRadius;
    ///<summary>
    ///  Gets or sets vertical corner radius.
    ///</summary>
    property VCornerRadius: Double read get_VCornerRadius write set_VCornerRadius;
    ///<summary>
    ///  Gets or sets border width.
    ///</summary>
    property Width: Int32 read get_Width write set_Width;
    ///<summary>
    ///  Gets or sets effect intencity. Valid range of value is [0..2].
    ///</summary>
    property EffectIntensity: Int32 read get_EffectIntensity write set_EffectIntensity;
    ///<summary>
    ///  Gets or sets border style.
    ///</summary>
    ///<see cref="T:Aspose.Pdf.Annotations.BorderStyle" />
    property Style: DNBorderStyle read get_Style write set_Style;
    ///<summary>
    ///  Gets or sets border effect.
    ///</summary>
    ///<see cref="T:Aspose.Pdf.Annotations.BorderEffect" />
    property Effect: DNBorderEffect read get_Effect write set_Effect;
    ///<summary>
    ///  Gets or sets dash pattern.
    ///</summary>
    property Dash: DNDash read get_Dash write set_Dash;
  end;

  TDNBorder = class(TDNGenericImport<DNBorderClass, DNBorder>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNCharacteristicsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{66A1C1B6-C4A2-5642-94E9-4CC0FF892201}']
  end;

  ///<summary>
  ///  Represents annotation characteristics
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Characteristics')]
  DNCharacteristics = interface(DDN.mscorlib.DNObject)
  ['{3897DFE0-7206-3F09-8D25-B1F3D756C48A}']
  { getters & setters } 

    function get_Background: DDN.System.Drawing.DNColor;
    procedure set_Background(value: DDN.System.Drawing.DNColor);
    function get_Border: DDN.System.Drawing.DNColor;
    procedure set_Border(value: DDN.System.Drawing.DNColor);
    function get_Rotate: DNRotation;
    procedure set_Rotate(value: DNRotation);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets color of the background
    ///</summary>
    property Background: DDN.System.Drawing.DNColor read get_Background write set_Background;
    ///<summary>
    ///  Gets or sets color of the border.
    ///</summary>
    property Border: DDN.System.Drawing.DNColor read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets rotation of the annotation.
    ///</summary>
    property Rotate: DNRotation read get_Rotate write set_Rotate;
  end;

  TDNCharacteristics = class(TDNGenericImport<DNCharacteristicsClass, DNCharacteristics>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNDashClass = interface(DDN.mscorlib.DNObjectClass)
  ['{0A727230-E2E8-5334-9DD3-289FF55E8B67}']
  { constructors } 

    ///<summary>
    ///  Constructor for Dash.
    ///</summary>
    ///  <param name="on">Length of the dash.</param>
    ///  <param name="off">Length of the gap.</param>
    {class} function init(&on: Int32; off: Int32): DNDash;

  end;

  ///<summary>
  ///  Class representing line dash pattern.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Dash')]
  DNDash = interface(DDN.mscorlib.DNObject)
  ['{4878B964-A0CC-3A98-8A45-AC67A4D27743}']
  { getters & setters } 

    function get_On: Int32;
    procedure set_On(value: Int32);
    function get_Off: Int32;
    procedure set_Off(value: Int32);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets length of dash.
    ///</summary>
    property &On: Int32 read get_On write set_On;
    ///<summary>
    ///  Gets or sets length of gap between dashes.
    ///</summary>
    property Off: Int32 read get_Off write set_Off;
  end;

  TDNDash = class(TDNGenericImport<DNDashClass, DNDash>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNDefaultAppearanceClass = interface(DDN.mscorlib.DNObjectClass)
  ['{18DD0221-5384-5B8A-A1FB-2BE3DEF9D36A}']
  { constructors } 

    ///<summary>
    ///  Constructor of DefaultAppearance.
    ///</summary>
    {class} function init: DNDefaultAppearance; overload;
    ///<summary>
    ///  Constructor of DefaultAppearance.
    ///</summary>
    ///  <param name="fontName">Font name.</param>
    ///  <param name="fontSize">Font size.</param>
    ///  <param name="textColor">Color of text.</param>
    {class} function init(fontName: string; fontSize: Double; textColor: DDN.System.Drawing.DNColor): DNDefaultAppearance; overload;
    ///<summary>
    ///  Constructor of Default Appearance. Previously created font may be specified as default font.
    ///</summary>
    ///  <param name="font">Font which will be used as default.</param>
    ///  <param name="fontSize">Font size.</param>
    ///  <param name="textColor">Color of text.</param>
    {class} function init(font: DNFont; fontSize: Double; textColor: DDN.System.Drawing.DNColor): DNDefaultAppearance; overload;

  end;

  ///<summary>
  ///  Describes default appearance of field (font, text size and color).
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.DefaultAppearance')]
  DNDefaultAppearance = interface(DDN.mscorlib.DNObject)
  ['{303E8695-441E-3B5E-8B6D-6CCFD5452AC1}']
  { getters & setters } 

    function get_FontSize: Double;
    procedure set_FontSize(value: Double);
    function get_TextColor: DDN.System.Drawing.DNColor;
    procedure set_TextColor(value: DDN.System.Drawing.DNColor);
    function get_FontName: string;
    procedure set_FontName(value: string);
    function get_Font: DNFont;
    function get_Text: string;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets font size in default apperance.
    ///</summary>
    property FontSize: Double read get_FontSize write set_FontSize;
    ///<summary>
    ///  Gets or sets the color of text in the default appearance.
    ///</summary>
    property TextColor: DDN.System.Drawing.DNColor read get_TextColor write set_TextColor;
    ///<summary>
    ///  Gets font name in the default appearance.
    ///</summary>
    property FontName: string read get_FontName write set_FontName;
    ///<summary>
    ///  Gets font specified as default for text.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  Gets the list of pdf operators which represent appearence.
    ///</summary>
    property Text: string read get_Text;
  end;

  TDNDefaultAppearance = class(TDNGenericImport<DNDefaultAppearanceClass, DNDefaultAppearance>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNDocumentActionCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{BBA10093-ED23-50F5-AAD0-AC2A756B3B53}']
  { constructors } 

    ///<summary>
    ///  Constructor for DocumentActionCollection. Constructs DocumentActionCollection objects from Pdf.Kit.Engine Document object.
    ///</summary>
    ///  <param name="document">Document for which action colleciton is created.</param>
    {class} function init(document: DNDocument): DNDocumentActionCollection;

  end;

  ///<summary>
  ///  Class describes actions performed on some actions with document
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.DocumentActionCollection')]
  DNDocumentActionCollection = interface(DDN.mscorlib.DNObject)
  ['{81D0D694-8BB5-3E2E-AA9A-E0CF84A1484F}']
  { getters & setters } 

    function get_BeforeSaving: DNPdfAction;
    procedure set_BeforeSaving(value: DNPdfAction);
    function get_BeforeClosing: DNPdfAction;
    procedure set_BeforeClosing(value: DNPdfAction);
    function get_AfterSaving: DNPdfAction;
    procedure set_AfterSaving(value: DNPdfAction);
    function get_BeforePrinting: DNPdfAction;
    procedure set_BeforePrinting(value: DNPdfAction);
    function get_AfterPrinting: DNPdfAction;
    procedure set_AfterPrinting(value: DNPdfAction);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets action performed before document saving.
    ///</summary>
    property BeforeSaving: DNPdfAction read get_BeforeSaving write set_BeforeSaving;
    ///<summary>
    ///  Gets or sets action that will be performed before documetn closing.
    ///</summary>
    property BeforeClosing: DNPdfAction read get_BeforeClosing write set_BeforeClosing;
    ///<summary>
    ///  Gets or sets action that will be performed after document saving.
    ///</summary>
    property AfterSaving: DNPdfAction read get_AfterSaving write set_AfterSaving;
    ///<summary>
    ///  Action that will be performed before document printing.
    ///</summary>
    property BeforePrinting: DNPdfAction read get_BeforePrinting write set_BeforePrinting;
    ///<summary>
    ///  Action that will be performed after document printing.
    ///</summary>
    property AfterPrinting: DNPdfAction read get_AfterPrinting write set_AfterPrinting;
  end;

  TDNDocumentActionCollection = class(TDNGenericImport<DNDocumentActionCollectionClass, DNDocumentActionCollection>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNExplicitDestinationClass = interface(DNObjectClass)
  ['{B6388C7D-3B3C-54CB-9B9A-3DED06AA9734}']
  { static methods } 

    ///<summary>
    ///  Creates instances of ExplicitDestination descendant classes.
    ///</summary>
    ///  <param name="page">The object of destination page.</param>
    ///  <param name="type">The type of explicit destination.</param>
    ///  <param name="values">Array of double values.</param>
    ///<returns>The explicit destination object.</returns>
    {class} function CreateDestination(page: DNPage; &type: DNExplicitDestinationType; values: TArray<Double>): DNExplicitDestination; overload;
    ///<summary>
    ///  Creates instances of ExplicitDestination descendant classes.
    ///</summary>
    ///  <param name="doc">Document where destination will be created.</param>
    ///  <param name="pageNumber">Number of the page.</param>
    ///  <param name="type">Destionatyion type.</param>
    ///  <param name="values">Array of destination specific values.</param>
    ///<returns>The explicit destination object.</returns>
    {class} function CreateDestination(doc: DNDocument; pageNumber: Int32; &type: DNExplicitDestinationType; values: TArray<Double>): DNExplicitDestination; overload;
    ///<summary>
    ///  Creates instances of ExplicitDestination descendant classes.
    ///</summary>
    ///  <param name="pageNumber">The destination page number.</param>
    ///  <param name="type">The type of explicit destination.</param>
    ///  <param name="values">Array of double values.</param>
    ///<returns>The explicit destination object.</returns>
    {class} function CreateDestination(pageNumber: Int32; &type: DNExplicitDestinationType; values: TArray<Double>): DNExplicitDestination; overload;

  end;

  ///<summary>
  ///  Represents the base class for explicit destinations in PDF document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.ExplicitDestination')]
  DNExplicitDestination = interface(DNIAppointment)
  ['{77CEED46-EDDA-3EBD-964A-4EDD38FBB3E7}']
  { getters & setters } 

    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Returns string representation of ExplicitDestination object.
    ///</summary>
    ///<returns></returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNExplicitDestination = class(TDNGenericImport<DNExplicitDestinationClass, DNExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNCustomExplicitDestinationClass = interface(DNExplicitDestinationClass)
  ['{42140D29-872D-5B05-B839-F3CC488FE4FB}']
  end;

  ///<summary>
  ///  Represents custom explicit destination.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.CustomExplicitDestination')]
  DNCustomExplicitDestination = interface(DNExplicitDestination)
  ['{9A73082D-727C-388B-8F9B-057FC3D4367D}']
  { getters & setters } 

    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Returns string representation of ExplicitDestination object.
    ///</summary>
    ///<returns></returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNCustomExplicitDestination = class(TDNGenericImport<DNCustomExplicitDestinationClass, DNCustomExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFitBExplicitDestinationClass = interface(DNExplicitDestinationClass)
  ['{0B7E45DA-0265-5FB4-8B66-3FD9AC3A6F00}']
  { constructors } 

    ///<summary>
    ///  Creates local explicit destination.
    ///</summary>
    ///  <param name="page">The destination page object.</param>
    {class} function init(page: DNPage): DNFitBExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="document">The parent document that contains this object.</param>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    {class} function init(document: DNDocument; pageNumber: Int32): DNFitBExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    {class} function init(pageNumber: Int32): DNFitBExplicitDestination; overload;

  end;

  ///<summary>
  ///  Represents explicit destination that displays the page with its contents magnified just enough to fit its bounding box entirely within the window both horizontally and vertically. If the required horizontal and vertical magnification factors are different, use the smaller of the two, centering the bounding box within the window in the other dimension.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FitBExplicitDestination')]
  DNFitBExplicitDestination = interface(DNExplicitDestination)
  ['{32C01FE2-2C24-3621-9E07-D4BC7EA97F4F}']
  { getters & setters } 

    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Converts the object state into string value. Example: "1 FitB".
    ///</summary>
    ///<returns>String value representing object state.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNFitBExplicitDestination = class(TDNGenericImport<DNFitBExplicitDestinationClass, DNFitBExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFitBHExplicitDestinationClass = interface(DNExplicitDestinationClass)
  ['{D8221FA8-C725-5004-9B57-6DFFFFDCC8D6}']
  { constructors } 

    ///<summary>
    ///  Creates local explicit destination.
    ///</summary>
    ///  <param name="page">The destination page object.</param>
    ///  <param name="top">The vertical coordinate top positioned at the top edge of the window.</param>
    {class} function init(page: DNPage; top: Double): DNFitBHExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="document">The parent document that contains this object.</param>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="top">The vertical coordinate top positioned at the top edge of the window.</param>
    {class} function init(document: DNDocument; pageNumber: Int32; top: Double): DNFitBHExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="top">The vertical coordinate top positioned at the top edge of the window.</param>
    {class} function init(pageNumber: Int32; top: Double): DNFitBHExplicitDestination; overload;

  end;

  ///<summary>
  ///  Represents explicit destination that displays the page with the vertical coordinate top positioned at the top edge of the window and the contents of the page magnified just enough to fit the entire width of its bounding box within the window. A null value for top specifies that the current value of that parameter is to be retained unchanged.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FitBHExplicitDestination')]
  DNFitBHExplicitDestination = interface(DNExplicitDestination)
  ['{E5565A32-7E6D-3EFD-BE51-99D1B16DA8AC}']
  { getters & setters } 

    function get_Top: Double;
    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Converts the object state into string value. Example: "1 FitBH 100".
    ///</summary>
    ///<returns>String value representing object state.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the vertical coordinate top positioned at the top edge of the window.
    ///</summary>
    property Top: Double read get_Top;
    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNFitBHExplicitDestination = class(TDNGenericImport<DNFitBHExplicitDestinationClass, DNFitBHExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFitBVExplicitDestinationClass = interface(DNExplicitDestinationClass)
  ['{AD5ED94B-9C6D-5644-A52F-ECA90C8D9A5A}']
  { constructors } 

    ///<summary>
    ///  Creates local explicit destination.
    ///</summary>
    ///  <param name="page">The destination page object.</param>
    ///  <param name="left">The horizontal coordinate left positioned at the left edge of the window.</param>
    {class} function init(page: DNPage; left: Double): DNFitBVExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="document">The parent document that contains this object.</param>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="left">The horizontal coordinate left positioned at the left edge of the window.</param>
    {class} function init(document: DNDocument; pageNumber: Int32; left: Double): DNFitBVExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="left">The horizontal coordinate left positioned at the left edge of the window.</param>
    {class} function init(pageNumber: Int32; left: Double): DNFitBVExplicitDestination; overload;

  end;

  ///<summary>
  ///  Represents explicit destination that displays the page with the horizontal coordinate left positioned at the left edge of the window and the contents of the page magnified just enough to fit the entire height of its bounding box within the window. A null value for left specifies that the current value of that parameter is to be retained unchanged.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FitBVExplicitDestination')]
  DNFitBVExplicitDestination = interface(DNExplicitDestination)
  ['{F39AF27F-9A2C-38D0-92AB-B9CF8C694C28}']
  { getters & setters } 

    function get_Left: Double;
    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Converts the object state into string value. Example: "1 FitBV 100".
    ///</summary>
    ///<returns>String value representing object state.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the horizontal coordinate left positioned at the left edge of the window.
    ///</summary>
    property Left: Double read get_Left;
    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNFitBVExplicitDestination = class(TDNGenericImport<DNFitBVExplicitDestinationClass, DNFitBVExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFitExplicitDestinationClass = interface(DNExplicitDestinationClass)
  ['{C4E7AED2-CA9D-51CD-83FB-5D94E81BBA6B}']
  { constructors } 

    ///<summary>
    ///  Creates local explicit destination.
    ///</summary>
    ///  <param name="page">The destination page object.</param>
    {class} function init(page: DNPage): DNFitExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="document">The Aspose.Pdf.Document object.</param>
    ///  <param name="pageNumber">The destination page number.</param>
    {class} function init(document: DNDocument; pageNumber: Int32): DNFitExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    {class} function init(pageNumber: Int32): DNFitExplicitDestination; overload;

  end;

  ///<summary>
  ///  Represents explicit destination that displays the page with its contents magnified just enough to fit the entire page within the window both horizontally and vertically. If the required horizontal and vertical magnification factors are different, use the smaller of the two, centering the page within the window in the other dimension.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FitExplicitDestination')]
  DNFitExplicitDestination = interface(DNExplicitDestination)
  ['{C76393F1-03DB-3D72-957D-F9342C3E7FD0}']
  { getters & setters } 

    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Converts the object state into string value. Example: "1 Fit".
    ///</summary>
    ///<returns>String value representing object state.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNFitExplicitDestination = class(TDNGenericImport<DNFitExplicitDestinationClass, DNFitExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFitHExplicitDestinationClass = interface(DNExplicitDestinationClass)
  ['{0829E5C3-01E5-5999-B50D-AD612071BC8D}']
  { constructors } 

    ///<summary>
    ///  Creates local explicit destination.
    ///</summary>
    ///  <param name="page">The destination page object.</param>
    ///  <param name="top">The vertical coordinate top positioned at the top edge of the window.</param>
    {class} function init(page: DNPage; top: Double): DNFitHExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="document">The parent document that contains this object.</param>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="top">The vertical coordinate top positioned at the top edge of the window.</param>
    {class} function init(document: DNDocument; pageNumber: Int32; top: Double): DNFitHExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="top">The vertical coordinate top positioned at the top edge of the window.</param>
    {class} function init(pageNumber: Int32; top: Double): DNFitHExplicitDestination; overload;

  end;

  ///<summary>
  ///  Represents explicit destination that displays the page with the vertical coordinate top positioned at the top edge of the window and the contents of the page magnified just enough to fit the entire width of the page within the window. A null value for top specifies that the current value of that parameter is to be retained unchanged.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FitHExplicitDestination')]
  DNFitHExplicitDestination = interface(DNExplicitDestination)
  ['{2656A15D-A429-391B-9A80-54BBCC1F2CAA}']
  { getters & setters } 

    function get_Top: Double;
    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Converts the object state into string value. Example: "1 FitH 100".
    ///</summary>
    ///<returns>String value representing object state.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the vertical coordinate top positioned at the top edge of the window.
    ///</summary>
    property Top: Double read get_Top;
    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNFitHExplicitDestination = class(TDNGenericImport<DNFitHExplicitDestinationClass, DNFitHExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFitRExplicitDestinationClass = interface(DNExplicitDestinationClass)
  ['{14C84A1C-B8FE-5C79-BD91-B424BF6D5B7F}']
  { constructors } 

    ///<summary>
    ///  Creates local explicit destination.
    ///</summary>
    ///  <param name="page">The destination page object.</param>
    ///  <param name="left">Left horizontal coordinate of visible rectangle.</param>
    ///  <param name="bottom">Bottom vertical coordinate of visible rectangle.</param>
    ///  <param name="right">Right horizontal coordinate of visible rectangle.</param>
    ///  <param name="top">Top vertical coordinate of visible rectangle.</param>
    {class} function init(page: DNPage; left: Double; bottom: Double; right: Double; top: Double): DNFitRExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="document">The parent document that contains this object.</param>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="left">Left horizontal coordinate of visible rectangle.</param>
    ///  <param name="bottom">Bottom vertical coordinate of visible rectangle.</param>
    ///  <param name="right">Right horizontal coordinate of visible rectangle.</param>
    ///  <param name="top">Top vertical coordinate of visible rectangle.</param>
    {class} function init(document: DNDocument; pageNumber: Int32; left: Double; bottom: Double; right: Double; top: Double): DNFitRExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="left">Left horizontal coordinate of visible rectangle.</param>
    ///  <param name="bottom">Bottom vertical coordinate of visible rectangle.</param>
    ///  <param name="right">Right horizontal coordinate of visible rectangle.</param>
    ///  <param name="top">Top vertical coordinate of visible rectangle.</param>
    {class} function init(pageNumber: Int32; left: Double; bottom: Double; right: Double; top: Double): DNFitRExplicitDestination; overload;

  end;

  ///<summary>
  ///  Represents explicit destination that displays the page with its contents magnified just enough to fit the rectangle specified by the coordinates left, bottom, right, and topentirely within the window both horizontally and vertically. If the required horizontal and vertical magnification factors are different, use the smaller of the two, centering the rectangle within the window in the other dimension. A null value for any of the parameters may result in unpredictable behavior.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FitRExplicitDestination')]
  DNFitRExplicitDestination = interface(DNExplicitDestination)
  ['{EDA25105-E3C6-3369-A4EC-37036AC0BCDA}']
  { getters & setters } 

    function get_Left: Double;
    function get_Bottom: Double;
    function get_Right: Double;
    function get_Top: Double;
    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Converts the object state into string value. Example: "1 FitR 100 200 300 400".
    ///</summary>
    ///<returns>String value representing object state.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets left horizontal coordinate of visible rectangle.
    ///</summary>
    property Left: Double read get_Left;
    ///<summary>
    ///  Gets bottom vertical coordinate of visible rectangle.
    ///</summary>
    property Bottom: Double read get_Bottom;
    ///<summary>
    ///  Gets right horizontal coordinate of visible rectangle.
    ///</summary>
    property Right: Double read get_Right;
    ///<summary>
    ///  Gets top vertical coordinate of visible rectangle.
    ///</summary>
    property Top: Double read get_Top;
    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNFitRExplicitDestination = class(TDNGenericImport<DNFitRExplicitDestinationClass, DNFitRExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFitVExplicitDestinationClass = interface(DNExplicitDestinationClass)
  ['{50DCB931-3046-5457-ACC1-4FE56C37E596}']
  { constructors } 

    ///<summary>
    ///  Creates local explicit destination.
    ///</summary>
    ///  <param name="page">The destination page object.</param>
    ///  <param name="left">The horizontal coordinate left positioned at the left edge of the window.</param>
    {class} function init(page: DNPage; left: Double): DNFitVExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="document">The parent document that contains this object.</param>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="left">The horizontal coordinate left positioned at the left edge of the window.</param>
    {class} function init(document: DNDocument; pageNumber: Int32; left: Double): DNFitVExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="left">The horizontal coordinate left positioned at the left edge of the window.</param>
    {class} function init(pageNumber: Int32; left: Double): DNFitVExplicitDestination; overload;

  end;

  ///<summary>
  ///  Represents explicit destination that displays the page with the horizontal coordinate left positioned at the left edge of the window and the contents of the page magnified just enough to fit the entire height of the page within the window. A null value for left specifies that the current value of that parameter is to be retained unchanged.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FitVExplicitDestination')]
  DNFitVExplicitDestination = interface(DNExplicitDestination)
  ['{6E435F34-903A-3C3B-9741-D433ACC0EC12}']
  { getters & setters } 

    function get_Left: Double;
    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Converts the object state into string value. Example: "1 FitV 100".
    ///</summary>
    ///<returns>String value representing object state.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the horizontal coordinate left positioned at the left edge of the window.
    ///</summary>
    property Left: Double read get_Left;
    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNFitVExplicitDestination = class(TDNGenericImport<DNFitVExplicitDestinationClass, DNFitVExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNXYZExplicitDestinationClass = interface(DNExplicitDestinationClass)
  ['{7A21B98E-4D6F-5320-9797-C5BC7E51AA6B}']
  { constructors } 

    ///<summary>
    ///  Creates local explicit destination.
    ///</summary>
    ///  <param name="page">The destination page object.</param>
    ///  <param name="left">Left horizontal coordinate of the upper-left corner of the window.</param>
    ///  <param name="top">Top vertical coordinate of the upper-left corner of the window.</param>
    ///  <param name="zoom">Zoom factor.</param>
    {class} function init(page: DNPage; left: Double; top: Double; zoom: Double): DNXYZExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="document">The parent document that contains this object.</param>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="left">Left horizontal coordinate of the upper-left corner of the window.</param>
    ///  <param name="top">Top vertical coordinate of the upper-left corner of the window.</param>
    ///  <param name="zoom">Zoom factor.</param>
    {class} function init(document: DNDocument; pageNumber: Int32; left: Double; top: Double; zoom: Double): DNXYZExplicitDestination; overload;
    ///<summary>
    ///  Creates remote explicit destination.
    ///</summary>
    ///  <param name="pageNumber">The destination page number of remote document.</param>
    ///  <param name="left">Left horizontal coordinate of the upper-left corner of the window.</param>
    ///  <param name="top">Top vertical coordinate of the upper-left corner of the window.</param>
    ///  <param name="zoom">Zoom factor.</param>
    {class} function init(pageNumber: Int32; left: Double; top: Double; zoom: Double): DNXYZExplicitDestination; overload;

  { static methods } 

    ///<summary>
    ///  Create destintion to specified location of the page considering page rotation if required.
    ///</summary>
    ///  <param name="page">Destination page.</param>
    ///  <param name="left">Left position on the page.</param>
    ///  <param name="top">Top position on the page.</param>
    ///  <param name="zoom">Zoom factor (0 for default).</param>
    ///  <param name="considerRotation">If true position will be recalculated according to page rotation.</param>
    ///<returns>Destination object.</returns>
    {class} function CreateDestination(page: DNPage; left: Double; top: Double; zoom: Double; considerRotation: Boolean): DNXYZExplicitDestination;
    ///<summary>
    ///  Create destionation to upper left corner of the specifed page.
    ///</summary>
    ///  <param name="page">Destination page.</param>
    ///  <param name="zoom">Zoom factor.</param>
    ///<returns>Destination object.</returns>
    {class} function CreateDestinationToUpperLeftCorner(page: DNPage; zoom: Double): DNXYZExplicitDestination; overload;
    ///<summary>
    ///  Create destination to specified page.
    ///</summary>
    ///  <param name="page">Destination page.</param>
    ///<returns>Destination object.</returns>
    {class} function CreateDestinationToUpperLeftCorner(page: DNPage): DNXYZExplicitDestination; overload;

  end;

  ///<summary>
  ///  Represents explicit destination that displays the page with the coordinates (left, top) positioned at the upper-left corner of the window and the contents of the page magnified by the factor zoom. A null value for any of the parameters left, top, or zoom specifies that the current value of that parameter is to be retained unchanged. A zoom value of 0 has the same meaning as a null value.
  ///</summary>
  ///<example><code lang="C#">
  ///  Document doc = new Document("example.pdf");
  ///  XYZExplicitDestination dest = (XYZExplicitDestination)doc.Outlines[1].Destination;
  ///  string left = dest.Left;
  ///  string top = dest.Top;
  ///  string zoom = dest.Zoom;
  ///</code></example>
  [DNTypeName('Aspose.Pdf.Annotations.XYZExplicitDestination')]
  DNXYZExplicitDestination = interface(DNExplicitDestination)
  ['{707A55F5-B34E-3730-8C1B-45196CBC74CA}']
  { getters & setters } 

    function get_Left: Double;
    function get_Top: Double;
    function get_Zoom: Double;
    function get_Page: DNPage;
    function get_PageNumber: Int32;

  { methods } 

    ///<summary>
    ///  Converts the object state into string value. Example: "1 XYZ 100 200 3".
    ///</summary>
    ///<returns>String value representing object state.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets left horizontal coordinate of the upper-left corner of the window.
    ///</summary>
    property Left: Double read get_Left;
    ///<summary>
    ///  Gets top vertical coordinate of the upper-left corner of the window.
    ///</summary>
    property Top: Double read get_Top;
    ///<summary>
    ///  Gets zoom factor.
    ///</summary>
    property Zoom: Double read get_Zoom;
    ///<summary>
    ///  Gets the destination page object
    ///</summary>
    property Page: DNPage read get_Page;
    ///<summary>
    ///  Gets the destination page number
    ///</summary>
    property PageNumber: Int32 read get_PageNumber;
  end;

  TDNXYZExplicitDestination = class(TDNGenericImport<DNXYZExplicitDestinationClass, DNXYZExplicitDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFixedPrintClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F278111F-A571-5DA8-91DB-E26870D42E1F}']
  end;

  ///<summary>
  ///  Represent Fixed print data of Watermark Annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FixedPrint')]
  DNFixedPrint = interface(DDN.mscorlib.DNObject)
  ['{F762CF66-308B-3CA1-B130-F1E117230995}']
  { getters & setters } 

    function get_Matrix: DNMatrix;
    procedure set_Matrix(value: DNMatrix);
    function get_HorizontalTranslation: Double;
    procedure set_HorizontalTranslation(value: Double);
    function get_VerticalTranslation: Double;
    procedure set_VerticalTranslation(value: Double);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Matrix: DNMatrix read get_Matrix write set_Matrix;
    property HorizontalTranslation: Double read get_HorizontalTranslation write set_HorizontalTranslation;
    property VerticalTranslation: Double read get_VerticalTranslation write set_VerticalTranslation;
  end;

  TDNFixedPrint = class(TDNGenericImport<DNFixedPrintClass, DNFixedPrint>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNMeasureClass = interface(DDN.mscorlib.DNObjectClass)
  ['{7A038E47-AF30-5726-8A9B-F4D46A403AD6}']
  { constructors } 

    ///<summary>
    ///  Creates Measure object for measure annotations.
    ///</summary>
    ///  <param name="annotation">Annotation for which measure will be bound.</param>
    {class} function init(annotation: DNAnnotation): DNMeasure;

  end;

  ///<summary>
  ///  Class which describes Measure coordinate system.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Measure')]
  DNMeasure = interface(DDN.mscorlib.DNObject)
  ['{A505924C-5D69-3E2A-852B-6117E17C90C5}']
  { getters & setters } 

    function get_ScaleRatio: string;
    procedure set_ScaleRatio(value: string);
    function get_XFormat: DNMeasure_NumberFormatList;
    procedure set_XFormat(value: DNMeasure_NumberFormatList);
    function get_YFormat: DNMeasure_NumberFormatList;
    procedure set_YFormat(value: DNMeasure_NumberFormatList);
    function get_DistanceFormat: DNMeasure_NumberFormatList;
    procedure set_DistanceFormat(value: DNMeasure_NumberFormatList);
    function get_AreaFormat: DNMeasure_NumberFormatList;
    procedure set_AreaFormat(value: DNMeasure_NumberFormatList);
    function get_AngleFormat: DNMeasure_NumberFormatList;
    procedure set_AngleFormat(value: DNMeasure_NumberFormatList);
    function get_SlopeFormat: DNMeasure_NumberFormatList;
    procedure set_SlopeFormat(value: DNMeasure_NumberFormatList);
    function get_Origin: DNPoint;
    procedure set_Origin(value: DNPoint);
    function get_XYFactor: Double;
    procedure set_XYFactor(value: Double);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  A text string expressing the scale ratio of the drawing.
    ///</summary>
    property ScaleRatio: string read get_ScaleRatio write set_ScaleRatio;
    ///<summary>
    ///  A number format array for measurement of change along the xaxis and, if Y is not present, along the y axis as well
    ///</summary>
    property XFormat: DNMeasure_NumberFormatList read get_XFormat write set_XFormat;
    ///<summary>
    ///  A number format array for measurement of change along the y axis.
    ///</summary>
    property YFormat: DNMeasure_NumberFormatList read get_YFormat write set_YFormat;
    ///<summary>
    ///  A number format array for measurement of distance in any direction.
    ///</summary>
    property DistanceFormat: DNMeasure_NumberFormatList read get_DistanceFormat write set_DistanceFormat;
    ///<summary>
    ///  A number format array for measurement of area.
    ///</summary>
    property AreaFormat: DNMeasure_NumberFormatList read get_AreaFormat write set_AreaFormat;
    ///<summary>
    ///  A number format array for measurement of angles.
    ///</summary>
    property AngleFormat: DNMeasure_NumberFormatList read get_AngleFormat write set_AngleFormat;
    ///<summary>
    ///  A number format array for measurement of the slope of a line.
    ///</summary>
    property SlopeFormat: DNMeasure_NumberFormatList read get_SlopeFormat write set_SlopeFormat;
    ///<summary>
    ///  Point that shall specify the origin of the measurement coordinate system in default user space coordinates.
    ///</summary>
    property Origin: DNPoint read get_Origin write set_Origin;
    ///<summary>
    ///  A factor that shall be used to convert the largest units along the y axis to the largest units along the x axis.
    ///</summary>
    property XYFactor: Double read get_XYFactor write set_XYFactor;
  end;

  TDNMeasure = class(TDNGenericImport<DNMeasureClass, DNMeasure>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNMeasure_NumberFormatClass = interface(DDN.mscorlib.DNObjectClass)
  ['{AAE2B89F-15EF-58FE-A65A-CB34A6A14757}']
  { constructors } 

    ///<summary>
    ///  Constructor for NumberFormat class.
    ///</summary>
    ///  <param name="measure">Measure object which contains this number format.</param>
    {class} function init(measure: DNMeasure): DNMeasure_NumberFormat;

  end;

  ///<summary>
  ///  Number format for measure.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Measure+NumberFormat')]
  DNMeasure_NumberFormat = interface(DDN.mscorlib.DNObject)
  ['{F8AFC3C0-1B42-3BD8-997E-1FFF7D53B5EC}']
  { getters & setters } 

    function get_UnitLabel: string;
    procedure set_UnitLabel(value: string);
    function get_ConvresionFactor: Double;
    procedure set_ConvresionFactor(value: Double);
    function get_FractionDisplayment: DNMeasure_NumberFormat_FractionStyle;
    procedure set_FractionDisplayment(value: DNMeasure_NumberFormat_FractionStyle);
    function get_Precision: Int32;
    procedure set_Precision(value: Int32);
    function get_Denominator: Int32;
    procedure set_Denominator(value: Int32);
    function get_ForceDenominator: Boolean;
    procedure set_ForceDenominator(value: Boolean);
    function get_ThousandsSeparator: string;
    procedure set_ThousandsSeparator(value: string);
    function get_FractionSeparator: string;
    procedure set_FractionSeparator(value: string);
    function get_BeforeText: string;
    procedure set_BeforeText(value: string);
    function get_AfterText: string;
    procedure set_AfterText(value: string);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  A text string specifying a label for displaying the units.
    ///</summary>
    property UnitLabel: string read get_UnitLabel write set_UnitLabel;
    ///<summary>
    ///  The conversion factor used to multiply a value in partial units of the previous number format array element to obtain a value in the units of this number format.
    ///</summary>
    property ConvresionFactor: Double read get_ConvresionFactor write set_ConvresionFactor;
    ///<summary>
    ///  In what manner fractional values are displayed.
    ///</summary>
    property FractionDisplayment: DNMeasure_NumberFormat_FractionStyle read get_FractionDisplayment write set_FractionDisplayment;
    ///<summary>
    ///  If FractionDisplayment is ShowAsDecimal, this value is precision of fractional value; It shall me multiple of 10. Default is 100.
    ///</summary>
    property Precision: Int32 read get_Precision write set_Precision;
    ///<summary>
    ///  If FractionDisplayment is ShowAsFraction, this value is denominator of the fraction. Default value is 16.
    ///</summary>
    property Denominator: Int32 read get_Denominator write set_Denominator;
    ///<summary>
    ///  If FractionDisplayment is ShowAsFraction, this value determines meay or not the fraction be reduced. If value is true fraction may not be reduced.
    ///</summary>
    property ForceDenominator: Boolean read get_ForceDenominator write set_ForceDenominator;
    ///<summary>
    ///  Text that shall be used between orders of thousands in display of numerical values. An empty string indicates that no text shall be added. Default is comma.
    ///</summary>
    property ThousandsSeparator: string read get_ThousandsSeparator write set_ThousandsSeparator;
    ///<summary>
    ///  Text that shall be used as the decimal position in displaying numerical values. An empty string indicates that the default shall be used. Default is period character.
    ///</summary>
    property FractionSeparator: string read get_FractionSeparator write set_FractionSeparator;
    ///<summary>
    ///  Text that shall be concatenated to the left of the label.
    ///</summary>
    property BeforeText: string read get_BeforeText write set_BeforeText;
    ///<summary>
    ///  Text that shall be concatenated after the label
    ///</summary>
    property AfterText: string read get_AfterText write set_AfterText;
  end;

  TDNMeasure_NumberFormat = class(TDNGenericImport<DNMeasure_NumberFormatClass, DNMeasure_NumberFormat>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNMeasure_NumberFormatListClass = interface(DDN.mscorlib.DNObjectClass)
  ['{1A856092-2F7F-52B6-9CB0-FB60151F4BE9}']
  { constructors } 

    ///<summary>
    ///  Constructor for NumberFormatList.
    ///</summary>
    ///  <param name="measure">Parent measure object.</param>
    {class} function init(measure: DNMeasure): DNMeasure_NumberFormatList;

  end;

  ///<summary>
  ///  Represents list of number formats.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Measure+NumberFormatList')]
  DNMeasure_NumberFormatList = interface(DDN.mscorlib.DNObject)
  ['{EF97B762-8F1E-3094-8C65-9597F67603EC}']
  { getters & setters } 

    function get_Item(index: Int32): DNMeasure_NumberFormat;
    procedure set_Item(index: Int32; value: DNMeasure_NumberFormat);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds number format to list.
    ///</summary>
    ///  <param name="value">Value to be added into list.</param>
    procedure Add(value: DNMeasure_NumberFormat);
    ///<summary>
    ///  Inserts number format into list.
    ///</summary>
    ///  <param name="index">Index where new element will be added.</param>
    ///  <param name="value">Value to be inserted.</param>
    procedure Insert(index: Int32; value: DNMeasure_NumberFormat);
    ///<summary>
    ///  Removes number format from list.
    ///</summary>
    ///  <param name="index">Index of item to be removed.</param>
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNMeasure_NumberFormat read get_Item write set_Item; default;
    ///<summary>
    ///  Count if items in the list.
    ///</summary>
    property Count: Int32 read get_Count;
  end;

  TDNMeasure_NumberFormatList = class(TDNGenericImport<DNMeasure_NumberFormatListClass, DNMeasure_NumberFormatList>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNMediaClipClass = interface(DDN.mscorlib.DNObjectClass)
  ['{CE1AD388-6BF1-5D79-A777-240F47A5B42E}']
  end;

  [DNTypeName('Aspose.Pdf.Annotations.MediaClip')]
  DNMediaClip = interface(DDN.mscorlib.DNObject)
  ['{44C3072D-29BE-3736-BFA1-6D72389FAA36}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNMediaClip = class(TDNGenericImport<DNMediaClipClass, DNMediaClip>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNMediaClipDataClass = interface(DNMediaClipClass)
  ['{8B66413D-1E64-54F9-A5E5-F2B0A1A3D4F3}']
  end;

  ///<summary>
  ///  Class describes media clip data.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.MediaClipData')]
  DNMediaClipData = interface(DNMediaClip)
  ['{B514F7EE-F35B-3FC1-B6BF-29FBD0541ADD}']
  { getters & setters } 

    function get_Data: DNFileSpecification;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Return file specification which contains actual media data .
    ///</summary>
    property Data: DNFileSpecification read get_Data;
  end;

  TDNMediaClipData = class(TDNGenericImport<DNMediaClipDataClass, DNMediaClipData>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNMediaClipSectionClass = interface(DNMediaClipClass)
  ['{E732A316-B6A7-52C2-A3E6-FB703D49962C}']
  end;

  ///<summary>
  ///  This class descibes Media clip section.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.MediaClipSection')]
  DNMediaClipSection = interface(DNMediaClip)
  ['{45BD14B9-AEA7-3E6A-9294-66D9BDFB61D5}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNMediaClipSection = class(TDNGenericImport<DNMediaClipSectionClass, DNMediaClipSection>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNNamedDestinationClass = interface(DNObjectClass)
  ['{50826541-E783-521E-AE9B-3562F81195D6}']
  { constructors } 

    ///<summary>
    ///  Create named destination.
    ///</summary>
    ///  <param name="doc">Document where named destination should be created.</param>
    ///  <param name="name">Name to which destination refers.</param>
    {class} function init(doc: DNDocument; name: string): DNNamedDestination;

  end;

  ///<summary>
  ///  Instead of being defined directly with the explicit syntax, a destination may be referred to indirectly by means of a name object or a byte string.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.NamedDestination')]
  DNNamedDestination = interface(DNIAppointment)
  ['{8E031FF3-DA99-36F6-92D7-454DBB142CE1}']
  { getters & setters } 

    function get_Name: string;

  { methods } 

    ///<summary>
    ///  Converts destination to string value.
    ///</summary>
    ///<returns>String value.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the name of named destination.
    ///</summary>
    property Name: string read get_Name;
  end;

  TDNNamedDestination = class(TDNGenericImport<DNNamedDestinationClass, DNNamedDestination>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DArtworkClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F9F6B6F3-3B27-530E-AB5F-12F5E037DBB1}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DArtwork" />
    ///  class.
    ///</summary>
    ///  <param name="doc">The document.</param>
    ///  <param name="content">The content.</param>
    ///  <param name="lightingScheme">The lighting scheme.</param>
    ///  <param name="renderMode">The render mode.</param>
    {class} function init(doc: DNDocument; content: DNPDF3DContent; lightingScheme: DNPDF3DLightingScheme; renderMode: DNPDF3DRenderMode): DNPDF3DArtwork; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DArtwork" />
    ///  class.
    ///</summary>
    ///  <param name="doc">The document.</param>
    ///  <param name="content">The content.</param>
    {class} function init(doc: DNDocument; content: DNPDF3DContent): DNPDF3DArtwork; overload;

  end;

  ///<summary>
  ///  Class PDF3DArtwork.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DArtwork')]
  DNPDF3DArtwork = interface(DDN.mscorlib.DNObject)
  ['{22C08AB8-CF87-3BE9-BF83-264849184F01}']
  { getters & setters } 

    function get_LightingScheme: DNPDF3DLightingScheme;
    procedure set_LightingScheme(value: DNPDF3DLightingScheme);
    function get_RenderMode: DNPDF3DRenderMode;
    procedure set_RenderMode(value: DNPDF3DRenderMode);
    function get_ViewArray: DNPDF3DViewArray;

  { methods } 

    ///<summary>
    ///  Get the views as list.
    ///</summary>
    ///<returns>ReadOnlyCollection&lt;PDF3DView&gt;.</returns>
    function GetViewsList: DDN.mscorlib.DNReadOnlyCollection<DNPDF3DView>;
    ///<summary>
    ///  Gets the views array.
    ///</summary>
    ///<returns>Array of views.</returns>
    function GetViewsArray: TArray<DNPDF3DView>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the lighting scheme.
    ///</summary>
    ///<value>The lighting scheme.</value>
    property LightingScheme: DNPDF3DLightingScheme read get_LightingScheme write set_LightingScheme;
    ///<summary>
    ///  Gets or sets the render mode.
    ///</summary>
    ///<value>The render mode.</value>
    property RenderMode: DNPDF3DRenderMode read get_RenderMode write set_RenderMode;
    ///<summary>
    ///  Gets the view array.
    ///</summary>
    ///<value>The view array.</value>
    property ViewArray: DNPDF3DViewArray read get_ViewArray;
  end;

  TDNPDF3DArtwork = class(TDNGenericImport<DNPDF3DArtworkClass, DNPDF3DArtwork>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DContentClass = interface(DDN.mscorlib.DNObjectClass)
  ['{73599C70-803A-5E53-B94D-12B8802710C6}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DContent" />
    ///  class.
    ///</summary>
    {class} function init: DNPDF3DContent; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DContent" />
    ///  class.
    ///</summary>
    ///  <param name="filename">The filename.</param>
    ///<exception cref="T:System.ArgumentException">Unknown 3D Artwork type</exception>
    {class} function init(filename: string): DNPDF3DContent; overload;

  end;

  ///<summary>
  ///  Class PDF3DContent.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DContent')]
  DNPDF3DContent = interface(DDN.mscorlib.DNObject)
  ['{0C589CCD-6083-34E3-8425-DD1134B6206B}']
  { getters & setters } 

    function get_Extension: string;

  { methods } 

    ///<summary>
    ///  Loads 3D content with the specified filename.
    ///</summary>
    ///  <param name="filename">The filename.</param>
    ///<exception cref="T:System.ArgumentException">Unknown 3D content type</exception>
    procedure Load(filename: string);
    ///<summary>
    ///  Loads 3D content with the specified filename as PRC format.
    ///</summary>
    ///  <param name="filename">The filename.</param>
    procedure LoadAsPRC(filename: string); overload;
    ///<summary>
    ///  Loads 3D content with the specified filename as U3D format.
    ///</summary>
    ///  <param name="filename">The filename.</param>
    procedure LoadAsU3D(filename: string); overload;
    ///<summary>
    ///  Loads 3D content from stream as PRC format.
    ///</summary>
    ///  <param name="stream">The 3D content stream.</param>
    procedure LoadAsPRC(stream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Loads 3D content from stream as U3D format.
    ///</summary>
    ///  <param name="stream">The 3D content stream.</param>
    procedure LoadAsU3D(stream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Loads 3D content from byte array as PRC format.
    ///</summary>
    ///  <param name="stream">The stream.</param>
    procedure LoadAsPRC(stream: TArray<Byte>); overload;
    ///<summary>
    ///  Loads 3D content from byte array as U3D format.
    ///</summary>
    ///  <param name="stream">The stream.</param>
    procedure LoadAsU3D(stream: TArray<Byte>); overload;
    ///<summary>
    ///  Saves 3D content to file.
    ///</summary>
    ///  <param name="filename">The file name.</param>
    ///<exception cref="T:System.ArgumentException">3DArtwork content format is PRC or U3D.</exception>
    procedure SaveToFile(filename: string);
    ///<summary>
    ///  Gets 3D content as stream.
    ///</summary>
    ///<returns>Stream.</returns>
    function GetAsStream: DDN.mscorlib.DNStream;
    ///<summary>
    ///  Gets 3D content as byte array.
    ///</summary>
    ///<returns>System.Byte[].</returns>
    function GetAsByteArray: TArray<Byte>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the extension .
    ///</summary>
    ///<value>The extension.</value>
    property Extension: string read get_Extension;
  end;

  TDNPDF3DContent = class(TDNGenericImport<DNPDF3DContentClass, DNPDF3DContent>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DCrossSectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{0CB848F2-569A-5F21-84C8-F8B8B67E45CE}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DCrossSection" />
    ///  class.
    ///</summary>
    ///  <param name="doc">The document.</param>
    {class} function init(doc: DNDocument): DNPDF3DCrossSection;

  end;

  ///<summary>
  ///  Class PDF3DCrossSection.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DCrossSection')]
  DNPDF3DCrossSection = interface(DDN.mscorlib.DNObject)
  ['{4A2A6338-4C64-32B9-B506-9C1EC18F6486}']
  { getters & setters } 

    function get_Center: DNPoint3D;
    procedure set_Center(value: DNPoint3D);
    function get_CuttingPlaneOpacity: Double;
    procedure set_CuttingPlaneOpacity(value: Double);
    function get_CuttingPlaneOrientation: DNPDF3DCuttingPlaneOrientation;
    procedure set_CuttingPlaneOrientation(value: DNPDF3DCuttingPlaneOrientation);
    function get_CuttingPlaneColor: DNColor;
    procedure set_CuttingPlaneColor(value: DNColor);
    function get_CuttingPlanesIntersectionColor: DNColor;
    procedure set_CuttingPlanesIntersectionColor(value: DNColor);
    function get_Visibility: Boolean;
    procedure set_Visibility(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the cross section rotation center.
    ///</summary>
    ///<value>The center.</value>
    property Center: DNPoint3D read get_Center write set_Center;
    ///<summary>
    ///  Gets or sets the cutting plane opacity.
    ///</summary>
    ///<value>The cutting plane opacity.</value><exception cref="T:System.Exception">The number must be in the range [0 , 1]</exception>
    property CuttingPlaneOpacity: Double read get_CuttingPlaneOpacity write set_CuttingPlaneOpacity;
    ///<summary>
    ///  Gets or sets the cutting plane orientation.
    ///</summary>
    ///<value>The cutting plane orientation.</value><exception cref="T:System.Exception">
    ///  Only one of the values shall be Null
    ///</exception>
    property CuttingPlaneOrientation: DNPDF3DCuttingPlaneOrientation read get_CuttingPlaneOrientation write set_CuttingPlaneOrientation;
    ///<summary>
    ///  Gets or sets the color of the cutting plane.
    ///</summary>
    ///<value>The color of the cutting plane.</value>
    property CuttingPlaneColor: DNColor read get_CuttingPlaneColor write set_CuttingPlaneColor;
    ///<summary>
    ///  Gets or sets the color of the cutting planes intersection.
    ///</summary>
    ///<value>The color of the cutting planes intersection.</value>
    property CuttingPlanesIntersectionColor: DNColor read get_CuttingPlanesIntersectionColor write set_CuttingPlanesIntersectionColor;
    ///<summary>
    ///  Gets or sets a value indicating visibility of the cutting planes intersection.
    ///</summary>
    ///<value><c>true</c> if visible; otherwise, <c>false</c>.</value>
    property Visibility: Boolean read get_Visibility write set_Visibility;
  end;

  TDNPDF3DCrossSection = class(TDNGenericImport<DNPDF3DCrossSectionClass, DNPDF3DCrossSection>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DCrossSectionArrayClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B872CEFD-CBD3-5CC9-8A26-E443FD5A41D8}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DCrossSectionArray" />
    ///  class.
    ///</summary>
    ///  <param name="doc">The document.</param>
    {class} function init(doc: DNDocument): DNPDF3DCrossSectionArray;

  end;

  ///<summary>
  ///  Class PDF3DCrossSectionArray.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DCrossSectionArray')]
  DNPDF3DCrossSectionArray = interface(DDN.mscorlib.DNObject)
  ['{E8013215-9304-3A2B-A645-9D2C9AC901F3}']
  { getters & setters } 

    function get_Count: Int32;
    function get_Item(index: Int32): DNPDF3DCrossSection;
    procedure set_Item(index: Int32; value: DNPDF3DCrossSection);

  { methods } 

    ///<summary>
    ///  Adds the specified cross section to views array .
    ///</summary>
    ///  <param name="crossSection">The cross section.</param>
    procedure Add(crossSection: DNPDF3DCrossSection);
    ///<summary>
    ///  Removes cross section from array at specified index.
    ///</summary>
    ///  <param name="index">The index of removed cross section in array.</param>
    ///<exception cref="T:System.IndexOutOfRangeException">Invalid index: index should be in the range [1..n] where n equals to the cross sections count.</exception>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Removes all cross section from array.
    ///</summary>
    procedure RemoveAll;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the cross section count.
    ///</summary>
    ///<value>The cross section count.</value>
    property Count: Int32 read get_Count;
    property Item[index: Int32]: DNPDF3DCrossSection read get_Item write set_Item; default;
  end;

  TDNPDF3DCrossSectionArray = class(TDNGenericImport<DNPDF3DCrossSectionArrayClass, DNPDF3DCrossSectionArray>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DCuttingPlaneOrientationClass = interface(DDN.mscorlib.DNObjectClass)
  ['{093DEF30-B5A7-58BE-9ECF-855E12D695ED}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DCuttingPlaneOrientation" />
    ///  class.
    ///</summary>
    {class} function init: DNPDF3DCuttingPlaneOrientation; overload;
    {class} function init(angleX: DDN.mscorlib.DNNullable<Double>; angleY: DDN.mscorlib.DNNullable<Double>; angleZ: DDN.mscorlib.DNNullable<Double>): DNPDF3DCuttingPlaneOrientation; overload;

  end;

  ///<summary>
  ///  Class PDF3DCuttingPlaneOrientation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DCuttingPlaneOrientation')]
  DNPDF3DCuttingPlaneOrientation = interface(DDN.mscorlib.DNObject)
  ['{B5889E9C-DA83-3193-8766-3F6A846B5F76}']
  { getters & setters } 

    function get_AngleX: DDN.mscorlib.DNNullable<Double>;
    procedure set_AngleX(value: DDN.mscorlib.DNNullable<Double>);
    function get_AngleY: DDN.mscorlib.DNNullable<Double>;
    procedure set_AngleY(value: DDN.mscorlib.DNNullable<Double>);
    function get_AngleZ: DDN.mscorlib.DNNullable<Double>;
    procedure set_AngleZ(value: DDN.mscorlib.DNNullable<Double>);

  { methods } 

    ///<summary>
    ///  Returns a <see cref="T:System.String" />
    ///  that represents this instance.
    ///</summary>
    ///<returns>A <see cref="T:System.String" />
    ///  that represents this instance.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets or sets the angle to X axis.
    ///</summary>
    ///<value>The angle to X axis.</value>
    property AngleX: DDN.mscorlib.DNNullable<Double> read get_AngleX write set_AngleX;
    ///<summary>
    ///  Gets or sets the angle to Y axis.
    ///</summary>
    ///<value>The angle Y axis.</value>
    property AngleY: DDN.mscorlib.DNNullable<Double> read get_AngleY write set_AngleY;
    ///<summary>
    ///  Gets or sets the angle to Z axis.
    ///</summary>
    ///<value>The angle to Z axis.</value>
    property AngleZ: DDN.mscorlib.DNNullable<Double> read get_AngleZ write set_AngleZ;
  end;

  TDNPDF3DCuttingPlaneOrientation = class(TDNGenericImport<DNPDF3DCuttingPlaneOrientationClass, DNPDF3DCuttingPlaneOrientation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DLightingSchemeClass = interface(DDN.mscorlib.DNObjectClass)
  ['{15B83825-B1AF-5B11-9CD6-BA1A8C97B826}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DLightingScheme" />
    ///  class.
    ///</summary>
    ///  <param name="type">The lighting scheme type.</param>
    {class} function init(&type: DNLightingSchemeType): DNPDF3DLightingScheme; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DLightingScheme" />
    ///  class.
    ///</summary>
    ///  <param name="typeName">Name of the lighting scheme type.</param>
    ///<exception cref="T:System.ArgumentException">Unknown lighting scheme type argument</exception>
    {class} function init(typeName: string): DNPDF3DLightingScheme; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_Artwork: DNPDF3DLightingScheme;
   function __fakeFieldGet_None: DNPDF3DLightingScheme;
   function __fakeFieldGet_White: DNPDF3DLightingScheme;
   function __fakeFieldGet_Day: DNPDF3DLightingScheme;
   function __fakeFieldGet_Night: DNPDF3DLightingScheme;
   function __fakeFieldGet_Hard: DNPDF3DLightingScheme;
   function __fakeFieldGet_Primary: DNPDF3DLightingScheme;
   function __fakeFieldGet_Blue: DNPDF3DLightingScheme;
   function __fakeFieldGet_Red: DNPDF3DLightingScheme;
   function __fakeFieldGet_Cube: DNPDF3DLightingScheme;
   function __fakeFieldGet_CAD: DNPDF3DLightingScheme;
   function __fakeFieldGet_Headlamp: DNPDF3DLightingScheme;

  { static fields } 

    ///<summary>
    ///  The "Artwork" lighting scheme.
    ///</summary>
    {class} property Artwork: DNPDF3DLightingScheme read __fakeFieldGet_Artwork;
    ///<summary>
    ///  The "None" lighting scheme.
    ///</summary>
    {class} property None: DNPDF3DLightingScheme read __fakeFieldGet_None;
    ///<summary>
    ///  The "White" lighting scheme.
    ///</summary>
    {class} property White: DNPDF3DLightingScheme read __fakeFieldGet_White;
    ///<summary>
    ///  The "Day" lighting scheme.
    ///</summary>
    {class} property Day: DNPDF3DLightingScheme read __fakeFieldGet_Day;
    ///<summary>
    ///  The "Night" lighting scheme.
    ///</summary>
    {class} property Night: DNPDF3DLightingScheme read __fakeFieldGet_Night;
    ///<summary>
    ///  The "Hard" lighting scheme.
    ///</summary>
    {class} property Hard: DNPDF3DLightingScheme read __fakeFieldGet_Hard;
    ///<summary>
    ///  The "Primary" lighting scheme.
    ///</summary>
    {class} property Primary: DNPDF3DLightingScheme read __fakeFieldGet_Primary;
    ///<summary>
    ///  The "Blue" lighting scheme.
    ///</summary>
    {class} property Blue: DNPDF3DLightingScheme read __fakeFieldGet_Blue;
    ///<summary>
    ///  The "Red" lighting scheme.
    ///</summary>
    {class} property Red: DNPDF3DLightingScheme read __fakeFieldGet_Red;
    ///<summary>
    ///  The "Cube" lighting scheme.
    ///</summary>
    {class} property Cube: DNPDF3DLightingScheme read __fakeFieldGet_Cube;
    ///<summary>
    ///  The "Cad" lighting scheme.
    ///</summary>
    {class} property CAD: DNPDF3DLightingScheme read __fakeFieldGet_CAD;
    ///<summary>
    ///  The "Headlamp" lighting scheme.
    ///</summary>
    {class} property Headlamp: DNPDF3DLightingScheme read __fakeFieldGet_Headlamp;

  end;

  ///<summary>
  ///  Class PDF3DLightingScheme.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DLightingScheme')]
  DNPDF3DLightingScheme = interface(DDN.mscorlib.DNObject)
  ['{0FD43A6D-3623-394F-831D-1775A4C2F893}']
  { getters & setters } 

    function get_Type: DNLightingSchemeType;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the lighting scheme type.
    ///</summary>
    ///<value>The lighting scheme type.</value>
    property &Type: DNLightingSchemeType read get_Type;
  end;

  TDNPDF3DLightingScheme = class(TDNGenericImport<DNPDF3DLightingSchemeClass, DNPDF3DLightingScheme>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DRenderModeClass = interface(DDN.mscorlib.DNObjectClass)
  ['{18EBAFA3-6DCB-5488-BC01-17D572D4E62F}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DRenderMode" />
    ///  class.
    ///</summary>
    ///  <param name="subtype">The render mode type.</param>
    {class} function init(subtype: DNRenderModeType): DNPDF3DRenderMode; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DRenderMode" />
    ///  class.
    ///</summary>
    ///  <param name="typeName">Name of the type.</param>
    ///<exception cref="T:System.ArgumentException">Unknown a render mode type argument</exception>
    {class} function init(typeName: string): DNPDF3DRenderMode; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_Solid: DNPDF3DRenderMode;
   function __fakeFieldGet_SolidWireframe: DNPDF3DRenderMode;
   function __fakeFieldGet_Transparent: DNPDF3DRenderMode;
   function __fakeFieldGet_TransparentWareFrame: DNPDF3DRenderMode;
   function __fakeFieldGet_BoundingBox: DNPDF3DRenderMode;
   function __fakeFieldGet_TransparentBoundingBox: DNPDF3DRenderMode;
   function __fakeFieldGet_TransparentBoundingBoxOutline: DNPDF3DRenderMode;
   function __fakeFieldGet_Wireframe: DNPDF3DRenderMode;
   function __fakeFieldGet_ShadedWireframe: DNPDF3DRenderMode;
   function __fakeFieldGet_Vertices: DNPDF3DRenderMode;
   function __fakeFieldGet_ShadedVertices: DNPDF3DRenderMode;
   function __fakeFieldGet_Illustration: DNPDF3DRenderMode;
   function __fakeFieldGet_SolidOutline: DNPDF3DRenderMode;
   function __fakeFieldGet_ShadedIllustration: DNPDF3DRenderMode;

  { static fields } 

    ///<summary>
    ///  The "Solid" render mode.
    ///</summary>
    {class} property Solid: DNPDF3DRenderMode read __fakeFieldGet_Solid;
    ///<summary>
    ///  The "SolidWireFrame" render mode.
    ///</summary>
    {class} property SolidWireframe: DNPDF3DRenderMode read __fakeFieldGet_SolidWireframe;
    ///<summary>
    ///  The "Transparent" render mode.
    ///</summary>
    {class} property Transparent: DNPDF3DRenderMode read __fakeFieldGet_Transparent;
    ///<summary>
    ///  The "TransparentWareFrame" render mode.
    ///</summary>
    {class} property TransparentWareFrame: DNPDF3DRenderMode read __fakeFieldGet_TransparentWareFrame;
    ///<summary>
    ///  The "BoundingBox" render mode.
    ///</summary>
    {class} property BoundingBox: DNPDF3DRenderMode read __fakeFieldGet_BoundingBox;
    ///<summary>
    ///  The "TransparentBoundingBox" render mode.
    ///</summary>
    {class} property TransparentBoundingBox: DNPDF3DRenderMode read __fakeFieldGet_TransparentBoundingBox;
    ///<summary>
    ///  The "TransparentBoundingBoxOutline" render mode.
    ///</summary>
    {class} property TransparentBoundingBoxOutline: DNPDF3DRenderMode read __fakeFieldGet_TransparentBoundingBoxOutline;
    ///<summary>
    ///  The "WireFrame" render mode.
    ///</summary>
    {class} property Wireframe: DNPDF3DRenderMode read __fakeFieldGet_Wireframe;
    ///<summary>
    ///  The "ShadedWireFrame" render mode.
    ///</summary>
    {class} property ShadedWireframe: DNPDF3DRenderMode read __fakeFieldGet_ShadedWireframe;
    ///<summary>
    ///  The "Vertices" render mode.
    ///</summary>
    {class} property Vertices: DNPDF3DRenderMode read __fakeFieldGet_Vertices;
    ///<summary>
    ///  The "ShadedVertices" render mode.
    ///</summary>
    {class} property ShadedVertices: DNPDF3DRenderMode read __fakeFieldGet_ShadedVertices;
    ///<summary>
    ///  The "Illustration" render mode.
    ///</summary>
    {class} property Illustration: DNPDF3DRenderMode read __fakeFieldGet_Illustration;
    ///<summary>
    ///  The "SolidOutline" render mode.
    ///</summary>
    {class} property SolidOutline: DNPDF3DRenderMode read __fakeFieldGet_SolidOutline;
    ///<summary>
    ///  The "ShadedIllustration" render mode.
    ///</summary>
    {class} property ShadedIllustration: DNPDF3DRenderMode read __fakeFieldGet_ShadedIllustration;

  end;

  ///<summary>
  ///  Class PDF3DRenderMode.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DRenderMode')]
  DNPDF3DRenderMode = interface(DDN.mscorlib.DNObject)
  ['{8A82F105-894A-3434-BE3C-54B0CE0831BB}']
  { getters & setters } 

    function get_Type: DNRenderModeType;

  { methods } 

    ///<summary>
    ///  Gets the auxiliary colour.
    ///</summary>
    ///<returns>Color.</returns>
    function GetAuxiliaryColour: DNColor;
    ///<summary>
    ///  Sets the auxiliary colour.
    ///</summary>
    ///  <param name="color">The color.</param>
    ///<returns>PDF3DRenderMode.</returns>
    function SetAuxiliaryColour(color: DNColor): DNPDF3DRenderMode;
    ///<summary>
    ///  Gets the color of the face.
    ///</summary>
    ///<returns>Object.</returns>
    function GetFaceColor: DDN.mscorlib.DNObject;
    ///<summary>
    ///  Sets the color of the face.
    ///</summary>
    ///  <param name="color">The color.</param>
    ///<returns>PDF3DRenderMode.</returns>
    function SetFaceColor(color: DNColor): DNPDF3DRenderMode;
    ///<summary>
    ///  Gets the opacity.
    ///</summary>
    ///<returns>System.Double.</returns>
    function GetOpacity: Double;
    ///<summary>
    ///  Sets the opacity.
    ///</summary>
    ///  <param name="opacity">The opacity.</param>
    ///<returns>PDF3DRenderMode.</returns>
    function SetOpacity(opacity: Double): DNPDF3DRenderMode;
    ///<summary>
    ///  Sets the crease value.
    ///</summary>
    ///  <param name="creaseValue">The crease value.</param>
    ///<returns>PDF3DRenderMode.</returns>
    function SetCreaseValue(creaseValue: Double): DNPDF3DRenderMode;
    ///<summary>
    ///  Gets the crease value.
    ///</summary>
    ///<returns>System.Double.</returns>
    function GetCreaseValue: Double;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the type.
    ///</summary>
    ///<value>The type.</value>
    property &Type: DNRenderModeType read get_Type;
  end;

  TDNPDF3DRenderMode = class(TDNGenericImport<DNPDF3DRenderModeClass, DNPDF3DRenderMode>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DStreamClass = interface(DDN.mscorlib.DNObjectClass)
  ['{E8709DD2-A844-5EA3-A0AA-DC7B37AD40BA}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DStream" />
    ///  class.
    ///</summary>
    ///  <param name="doc">The document.</param>
    ///  <param name="pdf3DArtwork">The 3D Artwork.</param>
    {class} function init(doc: DNDocument; pdf3DArtwork: DNPDF3DArtwork): DNPDF3DStream;

  end;

  ///<summary>
  ///  Class PDF3DStream.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DStream')]
  DNPDF3DStream = interface(DDN.mscorlib.DNObject)
  ['{E797D4A2-E915-3B3C-B15D-6484502125DA}']
  { getters & setters } 

    function get_Content: DNPDF3DContent;
    procedure set_Content(value: DNPDF3DContent);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the content.
    ///</summary>
    ///<value>The content.</value>
    property Content: DNPDF3DContent read get_Content write set_Content;
  end;

  TDNPDF3DStream = class(TDNGenericImport<DNPDF3DStreamClass, DNPDF3DStream>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DViewClass = interface(DDN.mscorlib.DNObjectClass)
  ['{86D4D085-54C0-568D-BBDF-F9D16E68689D}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DView" />
    ///  class.
    ///</summary>
    ///  <param name="doc">The document.</param>
    ///  <param name="cameraPosition">The camera position.</param>
    ///  <param name="cameraOrbit">The camera orbit.</param>
    ///  <param name="viewName">Name of the view.</param>
    {class} function init(doc: DNDocument; cameraPosition: DNMatrix3D; cameraOrbit: Double; viewName: string): DNPDF3DView; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DView" />
    ///  class.
    ///</summary>
    ///  <param name="doc">The document.</param>
    ///  <param name="view">The view.</param>
    ///  <param name="viewName">Name of the view.</param>
    {class} function init(doc: DNDocument; view: DNPDF3DView; viewName: string): DNPDF3DView; overload;

  end;

  ///<summary>
  ///  Class PDF3DView.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DView')]
  DNPDF3DView = interface(DDN.mscorlib.DNObject)
  ['{7FDD92B8-7B3B-31AD-88A5-BBC7EF881FBA}']
  { getters & setters } 

    function get_LightingScheme: DNPDF3DLightingScheme;
    procedure set_LightingScheme(value: DNPDF3DLightingScheme);
    function get_RenderMode: DNPDF3DRenderMode;
    procedure set_RenderMode(value: DNPDF3DRenderMode);
    function get_CrossSectionsArray: DNPDF3DCrossSectionArray;
    function get_ViewName: string;
    procedure set_ViewName(value: string);
    function get_CameraPosition: DNMatrix3D;
    procedure set_CameraPosition(value: DNMatrix3D);
    function get_CameraOrbit: Double;
    procedure set_CameraOrbit(value: Double);
    function get_BackGroundColor: DNColor;
    procedure set_BackGroundColor(value: DNColor);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the lighting scheme of view.
    ///</summary>
    ///<value>The lighting scheme of view.</value>
    property LightingScheme: DNPDF3DLightingScheme read get_LightingScheme write set_LightingScheme;
    ///<summary>
    ///  Gets or sets the render mode of view.
    ///</summary>
    ///<value>The render mode of view.</value>
    property RenderMode: DNPDF3DRenderMode read get_RenderMode write set_RenderMode;
    ///<summary>
    ///  Gets the cross sections array of view.
    ///</summary>
    ///<value>The cross sections array of view.</value>
    property CrossSectionsArray: DNPDF3DCrossSectionArray read get_CrossSectionsArray;
    ///<summary>
    ///  Gets or sets the name of the view.
    ///</summary>
    ///<value>The name of the view.</value>
    property ViewName: string read get_ViewName write set_ViewName;
    ///<summary>
    ///  Gets or sets the camera position of view.
    ///</summary>
    ///<value>The camera position of view.</value>
    property CameraPosition: DNMatrix3D read get_CameraPosition write set_CameraPosition;
    ///<summary>
    ///  Gets or sets the camera orbit of view.
    ///</summary>
    ///<value>The camera orbit of view.</value>
    property CameraOrbit: Double read get_CameraOrbit write set_CameraOrbit;
    ///<summary>
    ///  Gets or sets the color of the back ground of view.
    ///</summary>
    ///<value>The color of the back ground of view.</value>
    property BackGroundColor: DNColor read get_BackGroundColor write set_BackGroundColor;
  end;

  TDNPDF3DView = class(TDNGenericImport<DNPDF3DViewClass, DNPDF3DView>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DViewArrayClass = interface(DDN.mscorlib.DNObjectClass)
  ['{75D11A71-BC31-5364-BFDD-CCB1BAD1FA76}']
  end;

  ///<summary>
  ///  Class PDF3DViewArray.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DViewArray')]
  DNPDF3DViewArray = interface(DDN.mscorlib.DNObject)
  ['{D52F5236-27DB-3DC0-A30B-7785E17E4E1C}']
  { getters & setters } 

    function get_Count: Int32;
    function get_Item(index: Int32): DNPDF3DView;
    procedure set_Item(index: Int32; value: DNPDF3DView);

  { methods } 

    ///<summary>
    ///  Adds the specified view.
    ///</summary>
    ///  <param name="view">The view.</param>
    ///<exception cref="T:System.ArgumentException">Only one entry of 3D view is allowed</exception>
    procedure Add(view: DNPDF3DView);
    ///<summary>
    ///  Removes view from views array at specified index.
    ///</summary>
    ///  <param name="index">The view index.</param>
    ///<exception cref="T:System.IndexOutOfRangeException">Invalid index: index should be in the range [1..n] where n equals to the views count.</exception>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Removes all views.
    ///</summary>
    procedure RemoveAll;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the views count.
    ///</summary>
    ///<value>The views count.</value>
    property Count: Int32 read get_Count;
    property Item[index: Int32]: DNPDF3DView read get_Item write set_Item; default;
  end;

  TDNPDF3DViewArray = class(TDNGenericImport<DNPDF3DViewArrayClass, DNPDF3DViewArray>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPdfActionClass = interface(DNObjectClass)
  ['{EE4C22E1-6328-5A40-A88F-DC213BFFE479}']
  end;

  ///<summary>
  ///  Represents Action in PDF document
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PdfAction')]
  DNPdfAction = interface(DNIAppointment)
  ['{24A6DFE0-B5CD-321B-A4AE-B8E2B4DE90F2}']
  { getters & setters } 

    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNPdfAction = class(TDNGenericImport<DNPdfActionClass, DNPdfAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNGoToActionClass = interface(DNPdfActionClass)
  ['{DBFD9C56-9799-569B-A312-1F50C463628D}']
  { constructors } 

    ///<summary>
    ///  Constructor for GoToAction class.
    ///</summary>
    ///  <param name="page">The destination page number to jump to.</param>
    {class} function init(page: Int32): DNGoToAction; overload;
    ///<summary>
    ///  Constructor for GoToAction class.
    ///</summary>
    ///  <param name="page">Aspose.Pdf.Page destination object to jump to.</param>
    {class} function init(page: DNPage): DNGoToAction; overload;
    ///<summary>
    ///  Constructor for GoToAction class.
    ///</summary>
    ///  <param name="page">Destination page.</param>
    ///  <param name="type">Destination type.</param>
    ///  <param name="values">Action parameters.</param>
    {class} function init(page: DNPage; &type: DNExplicitDestinationType; values: TArray<Double>): DNGoToAction; overload;
    ///<summary>
    ///  Constructor.
    ///</summary>
    ///  <param name="destination">Explicit destination.</param>
    {class} function init(destination: DNExplicitDestination): DNGoToAction; overload;
    ///<summary>
    ///  Constructor.
    ///</summary>
    {class} function init: DNGoToAction; overload;
    ///<summary>
    ///  Action which linked with Named Destination.
    ///</summary>
    ///  <param name="doc">Document where action will be created.</param>
    ///  <param name="name">Name of the destination.</param>
    {class} function init(doc: DNDocument; name: string): DNGoToAction; overload;

  end;

  ///<summary>
  ///  Represents a go-to action that changes the view to a specified destination (page, location, and magnification factor).
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.GoToAction')]
  DNGoToAction = interface(DNPdfAction)
  ['{2A3F8BF8-4CE5-391B-8EA4-980EA1FA7ABC}']
  { getters & setters } 

    function get_Destination: DNIAppointment;
    procedure set_Destination(value: DNIAppointment);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the destination to jump to.
    ///</summary>
    property Destination: DNIAppointment read get_Destination write set_Destination;
    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNGoToAction = class(TDNGenericImport<DNGoToActionClass, DNGoToAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNGoToRemoteActionClass = interface(DNGoToActionClass)
  ['{4A6B727A-4DE8-5739-918C-7A9C2F8FBBAE}']
  { constructors } 

    ///<summary>
    ///  Initializes GoToRemoteAction object.
    ///</summary>
    ///  <param name="remotePdf">Destination PDF document.</param>
    ///  <param name="remotePageNumber">Destination page number.</param>
    {class} function init(remotePdf: string; remotePageNumber: Int32): DNGoToRemoteAction; overload;
    ///<summary>
    ///  Initializes GoToRemoteAction object.
    ///</summary>
    ///  <param name="remotePdf">Destination PDF document. </param>
    ///  <param name="destination">Destination in the  PDF document.</param>
    {class} function init(remotePdf: string; destination: DNExplicitDestination): DNGoToRemoteAction; overload;

  end;

  ///<summary>
  ///  Represents a remote go-to action that is similar to an ordinary go-to action but jumps to a destination in another PDF file instead of the current file.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.GoToRemoteAction')]
  DNGoToRemoteAction = interface(DNGoToAction)
  ['{2EF2BDEC-948D-3270-BB07-AC720A7830A7}']
  { getters & setters } 

    function get_File: DNFileSpecification;
    procedure set_File(value: DNFileSpecification);
    function get_NewWindow: DNExtendedBoolean;
    procedure set_NewWindow(value: DNExtendedBoolean);
    function get_Destination: DNIAppointment;
    procedure set_Destination(value: DNIAppointment);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the specification of the file in which the destination is located.
    ///</summary>
    property &File: DNFileSpecification read get_File write set_File;
    ///<summary>
    ///  Gets or sets a flag specifying whether to open the destination document in a new window.
    ///</summary>
    property NewWindow: DNExtendedBoolean read get_NewWindow write set_NewWindow;
    ///<summary>
    ///  Gets or sets the destination to jump to.
    ///</summary>
    property Destination: DNIAppointment read get_Destination write set_Destination;
    property Next: DNActionCollection read get_Next;
  end;

  TDNGoToRemoteAction = class(TDNGenericImport<DNGoToRemoteActionClass, DNGoToRemoteAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNGoToURIActionClass = interface(DNPdfActionClass)
  ['{84EA7F9A-EB2E-565C-9031-5891DF7D362E}']
  { constructors } 

    ///<summary>
    ///  Constructor.
    ///</summary>
    ///  <param name="uri">The uniform resource identifier to resolve.</param>
    {class} function init(uri: string): DNGoToURIAction;

  end;

  ///<summary>
  ///  Represents a URI action causes a URI to be resolved.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.GoToURIAction')]
  DNGoToURIAction = interface(DNPdfAction)
  ['{651A3E3D-5F5C-3F2B-B7CD-67C2DB517D13}']
  { getters & setters } 

    function get_URI: string;
    procedure set_URI(value: string);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the uniform resource identifier to resolve.
    ///</summary>
    property URI: string read get_URI write set_URI;
    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNGoToURIAction = class(TDNGenericImport<DNGoToURIActionClass, DNGoToURIAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNHideActionClass = interface(DNPdfActionClass)
  ['{84131BAA-2EF3-5413-B0CE-D265C4E10E8A}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.HideAction" />
    ///  class for the specified annotation.
    ///</summary>
    ///  <param name="annotation">An annotation to be hidden.</param>
    {class} function init(annotation: DNAnnotation): DNHideAction; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.HideAction" />
    ///  class for the specified annotation and invisibility flag.
    ///</summary>
    ///  <param name="annotation">An annotation to be hidden or shown.</param>
    ///  <param name="isHidden">A flag indicating whether to hide the annotation (true) or show it (false).</param>
    {class} function init(annotation: DNAnnotation; isHidden: Boolean): DNHideAction; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.HideAction" />
    ///  class for the specified field name.
    ///</summary>
    ///  <param name="fieldName">A text string giving the fully qualified field name of an interactive form field.</param>
    {class} function init(fieldName: string): DNHideAction; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.HideAction" />
    ///  class for the specified field name and invisibility flag.
    ///</summary>
    ///  <param name="fieldName">A text string giving the fully qualified field name of an interactive form field.</param>
    ///  <param name="isHidden">A flag indicating whether to hide the field (true) or show it (false).</param>
    {class} function init(fieldName: string; isHidden: Boolean): DNHideAction; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.HideAction" />
    ///  class for the specified annotations.
    ///</summary>
    ///  <param name="annotations">An array of annotations to be hidden.</param>
    {class} function init(annotations: TArray<DNAnnotation>): DNHideAction; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.HideAction" />
    ///  class for the specified annotations and for invisibility flag.
    ///</summary>
    ///  <param name="annotations">An array of annotations to be hidden or shown.</param>
    ///  <param name="isHidden">A flag indicating whether to hide the annotations (true) or show it (false).</param>
    {class} function init(annotations: TArray<DNAnnotation>; isHidden: Boolean): DNHideAction; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.HideAction" />
    ///  class for the specified field names.
    ///</summary>
    ///  <param name="names">An array of strings giving the fully qualified field names of an interactive form fields.</param>
    {class} function init(names: TArray<string>): DNHideAction; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.HideAction" />
    ///  class for the specified field names and for invisibility flag.
    ///</summary>
    ///  <param name="names">An array of strings giving the fully qualified field names of an interactive form fields.</param>
    ///  <param name="isHidden">A flag indicating whether to hide the fields (true) or show it (false).</param>
    {class} function init(names: TArray<string>; isHidden: Boolean): DNHideAction; overload;

  end;

  ///<summary>
  ///  Represents a hide action that hides or shows one or more annotations on the screen by setting or clearing their Hidden flags.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.HideAction')]
  DNHideAction = interface(DNPdfAction)
  ['{283BC020-9F74-35D6-A5E7-F29FF0393E1E}']
  { getters & setters } 

    function get_IsHidden: Boolean;
    procedure set_IsHidden(value: Boolean);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets status of the annotation(s) to hide/display.
    ///</summary>
    property IsHidden: Boolean read get_IsHidden write set_IsHidden;
    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNHideAction = class(TDNGenericImport<DNHideActionClass, DNHideAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNImportDataActionClass = interface(DNPdfActionClass)
  ['{18D4CAAD-FABA-5CBF-B4C1-3F052D0008C9}']
  end;

  ///<summary>
  ///  Upon invocation of an import-data action, Forms Data Format (FDF) data shall be imported into the document’s interactive form from a specified file.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.ImportDataAction')]
  DNImportDataAction = interface(DNPdfAction)
  ['{6DAB2A45-7896-33CF-AF46-D6D5E4E666C9}']
  { getters & setters } 

    function get_Data: DNFileSpecification;
    procedure set_Data(value: DNFileSpecification);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  The FDF file from which to import the data.
    ///</summary>
    property Data: DNFileSpecification read get_Data write set_Data;
    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNImportDataAction = class(TDNGenericImport<DNImportDataActionClass, DNImportDataAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNJavascriptActionClass = interface(DNPdfActionClass)
  ['{E9E19221-E866-5D7C-AF41-59EAF0040EC9}']
  { constructors } 

    ///<summary>
    ///  Constructor.
    ///</summary>
    ///  <param name="javaScript">JavaScript code.</param>
    {class} function init(javaScript: string): DNJavascriptAction;

  end;

  ///<summary>
  ///  Class representing javascript action.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.JavascriptAction')]
  DNJavascriptAction = interface(DNPdfAction)
  ['{17245C15-90CD-359F-A4F4-1B4646AEBCD9}']
  { getters & setters } 

    function get_Script: string;
    procedure set_Script(value: string);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets javascript code.
    ///</summary>
    property Script: string read get_Script write set_Script;
    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNJavascriptAction = class(TDNGenericImport<DNJavascriptActionClass, DNJavascriptAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNLaunchActionClass = interface(DNPdfActionClass)
  ['{A096DA75-6126-5BD9-919B-941596BBC933}']
  { constructors } 

    ///<summary>
    ///  Creates a launch action.
    ///</summary>
    ///  <param name="file">The file to be launched.</param>
    {class} function init(&file: string): DNLaunchAction; overload;
    ///<summary>
    ///  Creates a launch action.
    ///</summary>
    ///  <param name="document">Document where action will be created.</param>
    ///  <param name="file">The file to be launched.</param>
    {class} function init(document: DNDocument; &file: string): DNLaunchAction; overload;

  end;

  ///<summary>
  ///  Represents a launch action that launches an application or opens or prints a document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.LaunchAction')]
  DNLaunchAction = interface(DNPdfAction)
  ['{001FA1E9-2724-3E78-B0F2-8F628935BE90}']
  { getters & setters } 

    function get_File: string;
    procedure set_File(value: string);
    function get_NewWindow: DNExtendedBoolean;
    procedure set_NewWindow(value: DNExtendedBoolean);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the application to be launched or the document to be opened or printed.
    ///</summary>
    property &File: string read get_File write set_File;
    ///<summary>
    ///  Gets or sets a flag specifying whether to open the destination document in a new window (affect PDF documents only).
    ///</summary>
    property NewWindow: DNExtendedBoolean read get_NewWindow write set_NewWindow;
    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNLaunchAction = class(TDNGenericImport<DNLaunchActionClass, DNLaunchAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNNamedActionClass = interface(DNPdfActionClass)
  ['{F88E7E32-E482-5710-8C47-44720FAB3C4D}']
  { constructors } 

    ///<summary>
    ///  Constructor for Named Action class.
    ///</summary>
    ///  <param name="action">Action for which this object is created.</param>
    {class} function init(action: DNPredefinedAction): DNNamedAction;

  end;

  ///<summary>
  ///  Represents named actions that PDF viewer applications are expected to support.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.NamedAction')]
  DNNamedAction = interface(DNPdfAction)
  ['{30463AC3-8370-3B26-BCC5-623A7D9F3EAD}']
  { getters & setters } 

    function get_Name: string;
    procedure set_Name(value: string);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the action to be performed.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNNamedAction = class(TDNGenericImport<DNNamedActionClass, DNNamedAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNRenditionActionClass = interface(DNPdfActionClass)
  ['{DB187375-0AE1-5766-9ED9-6630955B5A12}']
  end;

  ///<summary>
  ///  A rendition action that controls the playing of multimedia content.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.RenditionAction')]
  DNRenditionAction = interface(DNPdfAction)
  ['{2F8918F8-F054-305B-B70C-99584021655E}']
  { getters & setters } 

    function get_Rendition: DNRendition;
    function get_RenditionOperation: DNRenditionOperation;
    procedure set_RenditionOperation(value: DNRenditionOperation);
    function get_JavaScript: string;
    procedure set_JavaScript(value: string);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets rendition associated with the action.
    ///</summary>
    property Rendition: DNRendition read get_Rendition;
    ///<summary>
    ///  The operation to perform when the action is triggered.
    ///</summary>
    property RenditionOperation: DNRenditionOperation read get_RenditionOperation write set_RenditionOperation;
    ///<summary>
    ///  Gets or sets JavaScript code associated with the action.
    ///</summary>
    property JavaScript: string read get_JavaScript write set_JavaScript;
    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNRenditionAction = class(TDNGenericImport<DNRenditionActionClass, DNRenditionAction>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNSubmitFormActionClass = interface(DNPdfActionClass)
  ['{C190046D-CD40-50FD-9586-7CBC2D54A807}']
  { constructors } 

    ///<summary>
    ///  Initializes SubmitFormAction object.
    ///</summary>
    {class} function init: DNSubmitFormAction;

  end;

  ///<summary>
  ///  Class which describes submit-form action.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SubmitFormAction')]
  DNSubmitFormAction = interface(DNPdfAction)
  ['{390CDB9F-F1D5-3B60-A9A1-BEEFDB914A14}']
  { getters & setters } 

    function get_Flags: Int32;
    procedure set_Flags(value: Int32);
    function get_Url: DNFileSpecification;
    procedure set_Url(value: DNFileSpecification);
    function get_Next: DNActionCollection;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets flagas of submit action
    ///</summary>
    property Flags: Int32 read get_Flags write set_Flags;
    ///<summary>
    ///  Destination URL.
    ///</summary>
    property Url: DNFileSpecification read get_Url write set_Url;
    ///<summary>
    ///  Next actions in sequence.
    ///</summary>
    property Next: DNActionCollection read get_Next;
  end;

  TDNSubmitFormAction = class(TDNGenericImport<DNSubmitFormActionClass, DNSubmitFormAction>)
  public const
    ///<summary>
    ///  If clear, the Fields array specifies which fields to include in the submission.
    ///</summary>
   Exclude = 1;
    ///<summary>
    ///  If set, all fields designated by the Fields array and the Include/Exclude flag shall be submitted.
    ///</summary>
   IncludeNoValueFields = 2;
    ///<summary>
    ///  If set, field names and values shall be submitted in HTML Form format.
    ///</summary>
   ExportFormat = 4;
    ///<summary>
    ///  If set, field names and values shall be submitted using an HTTP GET request.
    ///</summary>
   GetMethod = 8;
    ///<summary>
    ///  If set, the coordinates of the mouse click that caused the submit-form action shall be transmitted as part of the form data.
    ///</summary>
   SubmitCoordinates = 16;
    ///<summary>
    ///  If set, field names and values shall be submitted as XFDF.
    ///</summary>
   Xfdf = 32;
    ///<summary>
    ///  If set, the submitted FDF file shall include the contents of all incremental updates.
    ///</summary>
   IncludeAppendSaves = 64;
    ///<summary>
    ///  If set, the submitted FDF file shall include includes all markup annotations in the underlying PDF document.
    ///</summary>
   IncludeAnnotations = 128;
    ///<summary>
    ///  If set, the document shall be submitted as PDF, using the MIME content type application/pdf.
    ///</summary>
   SubmitPdf = 256;
    ///<summary>
    ///  If set, any submitted field values representing dates shall be converted to the standard format.
    ///</summary>
   CanonicalFormat = 512;
    ///<summary>
    ///  If set, it shall include only those markup annotations whose T entry matches the name of the current user.
    ///</summary>
   ExclNonUserAnnots = 1024;
    ///<summary>
    ///  If set, the submitted FDF shall exclude the F entry.
    ///</summary>
   ExclFKey = 2048;
    ///<summary>
    ///  If set, the F entry of the submitted FDF shall be a file specification containing an
    ///  embedded file stream representing the PDF file from which the FDF is being submitted.
    ///</summary>
   EmbedForm = 8192;
  end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPdfActionCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{860FE26C-CA0D-570D-B8D2-EDB5FAA6CCF9}']
  end;

  ///<summary>
  ///  Class describes list of actions.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PdfActionCollection')]
  DNPdfActionCollection = interface(DDN.mscorlib.DNObject)
  ['{C9730893-2417-3C6F-8BCF-55802DB1C919}']
  { getters & setters } 

    function get_Count: Int32;
    function get_Item(index: Int32): DNPdfAction;

  { methods } 

    ///<summary>
    ///  Remove action by index.
    ///</summary>
    ///  <param name="index">Index of action to remove.</param>
    procedure Delete(index: Int32);
    ///<summary>
    ///  Add action to action list.
    ///</summary>
    ///  <param name="action">Action to be added.</param>
    procedure Add(action: DNPdfAction);
    ///<summary>
    ///  Gets enumerator.
    ///</summary>
    ///<returns>PDfAction enumerator.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNPdfAction>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets count of actions.
    ///</summary>
    property Count: Int32 read get_Count;
    property Item[index: Int32]: DNPdfAction read get_Item; default;
  end;

  TDNPdfActionCollection = class(TDNGenericImport<DNPdfActionCollectionClass, DNPdfActionCollection>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNRenditionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{91FCE545-313B-57BF-876D-890C867F6371}']
  end;

  ///<summary>
  ///  Class which describes rendition object of RendtionAnnotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Rendition')]
  DNRendition = interface(DDN.mscorlib.DNObject)
  ['{4DE578CA-4646-31F3-B44B-CEA6B74C7727}']
  { getters & setters } 

    function get_Name: string;
    procedure set_Name(value: string);
    function get_RenditionType: DNRenditionType;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Text string specifying the name of the rendition for use in a user interface and for name tree lookup by JavaScript actions.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets rendition type.
    ///</summary>
    property RenditionType: DNRenditionType read get_RenditionType;
  end;

  TDNRendition = class(TDNGenericImport<DNRenditionClass, DNRendition>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNMediaRenditionClass = interface(DNRenditionClass)
  ['{D14BC4CE-F3E7-50D2-A60D-E33C21386ABD}']
  end;

  ///<summary>
  ///  Class describes media rendition.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.MediaRendition')]
  DNMediaRendition = interface(DNRendition)
  ['{F46ED2AF-CE21-39A8-8987-87F776FD8292}']
  { getters & setters } 

    function get_MediaClip: DNMediaClip;
    function get_Name: string;
    procedure set_Name(value: string);
    function get_RenditionType: DNRenditionType;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets media clip obkects associated with rendition.
    ///</summary>
    property MediaClip: DNMediaClip read get_MediaClip;
    ///<summary>
    ///  Text string specifying the name of the rendition for use in a user interface and for name tree lookup by JavaScript actions.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets rendition type.
    ///</summary>
    property RenditionType: DNRenditionType read get_RenditionType;
  end;

  TDNMediaRendition = class(TDNGenericImport<DNMediaRenditionClass, DNMediaRendition>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNSelectorRenditionClass = interface(DNRenditionClass)
  ['{A337C45C-C63F-5C8D-8CF5-56A90B742DC6}']
  end;

  ///<summary>
  ///  Class describes selector rendition.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SelectorRendition')]
  DNSelectorRendition = interface(DNRendition)
  ['{62F911C8-41B2-3008-8305-A0C334964430}']
  { getters & setters } 

    function get_Renditions: TArray<DNRendition>;
    function get_Name: string;
    procedure set_Name(value: string);
    function get_RenditionType: DNRenditionType;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets array of renditions.
    ///</summary>
    property Renditions: TArray<DNRendition> read get_Renditions;
    ///<summary>
    ///  Text string specifying the name of the rendition for use in a user interface and for name tree lookup by JavaScript actions.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets rendition type.
    ///</summary>
    property RenditionType: DNRenditionType read get_RenditionType;
  end;

  TDNSelectorRendition = class(TDNGenericImport<DNSelectorRenditionClass, DNSelectorRendition>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNSoundDataClass = interface(DDN.mscorlib.DNObjectClass)
  ['{019E17E0-A060-5392-9528-565256A2A716}']
  end;

  ///<summary>
  ///  Represents a sound data defining the sound to be played when the annotation is activated.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SoundData')]
  DNSoundData = interface(DDN.mscorlib.DNObject)
  ['{4AB2F4A1-0A7B-3732-B5FB-9B8A718CA535}']
  { getters & setters } 

    function get_Rate: Int32;
    procedure set_Rate(value: Int32);
    function get_Channels: Int32;
    procedure set_Channels(value: Int32);
    function get_Bits: Int32;
    procedure set_Bits(value: Int32);
    function get_Contents: DDN.mscorlib.DNStream;
    function get_Encoding: DNSoundEncoding;
    procedure set_Encoding(value: DNSoundEncoding);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the sampling rate, in samples per second.
    ///</summary>
    property Rate: Int32 read get_Rate write set_Rate;
    ///<summary>
    ///  Gets or sets the number of sound channels.
    ///</summary>
    property Channels: Int32 read get_Channels write set_Channels;
    ///<summary>
    ///  Gets or sets the number of bits per sample value per channel.
    ///</summary>
    property Bits: Int32 read get_Bits write set_Bits;
    ///<summary>
    ///  Gets stream of the sound to be played when the annotation is activated.
    ///</summary>
    property Contents: DDN.mscorlib.DNStream read get_Contents;
    ///<summary>
    ///  Gets or sets the encoding format for the sample data.
    ///</summary>
    property Encoding: DNSoundEncoding read get_Encoding write set_Encoding;
  end;

  TDNSoundData = class(TDNGenericImport<DNSoundDataClass, DNSoundData>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNSoundSampleDataClass = interface(DDN.mscorlib.DNObjectClass)
  ['{39DAF750-A4B0-515C-A746-41A5EE674087}']
  { constructors } 

    ///<summary>
    ///  Initializes new sound sample data.
    ///</summary>
    ///  <param name="samplingRate">The sampling rate.</param>
    {class} function init(samplingRate: Int64): DNSoundSampleData; overload;
    ///<summary>
    ///  Initializes new sound sample data.
    ///</summary>
    ///  <param name="samplingRate">The sampling rate.</param>
    ///  <param name="numberOfSoundChannels">The number of sound channels.</param>
    {class} function init(samplingRate: Int64; numberOfSoundChannels: Int32): DNSoundSampleData; overload;
    ///<summary>
    ///  Initializes new sound sample data.
    ///</summary>
    ///  <param name="samplingRate">The sampling rate.</param>
    ///  <param name="numberOfSoundChannels">The number of sound channels.</param>
    ///  <param name="bitsPerChannel">The number of bits per sample value per channel.</param>
    {class} function init(samplingRate: Int64; numberOfSoundChannels: Int32; bitsPerChannel: Int32): DNSoundSampleData; overload;
    ///<summary>
    ///  Initializes new sound sample data.
    ///</summary>
    ///  <param name="samplingRate">The sampling rate.</param>
    ///  <param name="numberOfSoundChannels">The number of sound channels.</param>
    ///  <param name="bitsPerChannel">The number of bits per sample value per channel.</param>
    ///  <param name="soundSampleDataEncodingFormat">The encoding format for the sample data.</param>
    {class} function init(samplingRate: Int64; numberOfSoundChannels: Int32; bitsPerChannel: Int32; soundSampleDataEncodingFormat: DNSoundSampleDataEncodingFormat): DNSoundSampleData; overload;

  end;

  ///<summary>
  ///  Represents additional entries specific to a sound object (Section 9.2 PDF1-7)
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SoundSampleData')]
  DNSoundSampleData = interface(DDN.mscorlib.DNObject)
  ['{B6825B40-EDE2-3B77-B65B-A288C0F93CC1}']
  { getters & setters } 

    function get_SamplingRate: Int64;
    procedure set_SamplingRate(value: Int64);
    function get_NumberOfSoundChannels: Int32;
    procedure set_NumberOfSoundChannels(value: Int32);
    function get_BitsPerChannel: Int32;
    procedure set_BitsPerChannel(value: Int32);
    function get_EncodingFormat: DNSoundSampleDataEncodingFormat;
    procedure set_EncodingFormat(value: DNSoundSampleDataEncodingFormat);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the sampling rate.
    ///</summary>
    property SamplingRate: Int64 read get_SamplingRate write set_SamplingRate;
    ///<summary>
    ///  Gets or sets the number of sound channels.
    ///</summary>
    property NumberOfSoundChannels: Int32 read get_NumberOfSoundChannels write set_NumberOfSoundChannels;
    ///<summary>
    ///  Gets or sets the number of bits per sample value per channel.
    ///</summary>
    property BitsPerChannel: Int32 read get_BitsPerChannel write set_BitsPerChannel;
    ///<summary>
    ///  Gets or sets the encoding format.
    ///</summary>
    property EncodingFormat: DNSoundSampleDataEncodingFormat read get_EncodingFormat write set_EncodingFormat;
  end;

  TDNSoundSampleData = class(TDNGenericImport<DNSoundSampleDataClass, DNSoundSampleData>)
  public const
    ///<summary>
    ///  Default value for SamplingRate.
    ///</summary>
   DefaultSamplingRate = 11025;
    ///<summary>
    ///  Default value for Channels parameter.
    ///</summary>
   DefaultOfSoundChannels = 1;
    ///<summary>
    ///  Default value for BitsPerchannel parameter.
    ///</summary>
   DefaultOfBitsPerChannel = 8;
    ///<summary>
    ///  Default value for encoding format.
    ///</summary>
   DefaultEncodingFormat = DNSoundSampleDataEncodingFormat.Raw;
  end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNTextStyleClass = interface(DDN.mscorlib.DNObjectClass)
  ['{81CEAA2E-696E-58B6-AF1E-E69EB69799C1}']
  end;

  ///<summary>
  ///  Class represents style of text in annotation
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.TextStyle')]
  DNTextStyle = interface(DDN.mscorlib.DNObject)
  ['{0C6667C1-36DC-3D31-8F03-75CB83CABF2A}']
  { getters & setters } 

    function get_FontName: string;
    procedure set_FontName(value: string);
    function get_FontSize: Double;
    procedure set_FontSize(value: Double);
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Color: DDN.System.Drawing.DNColor;
    procedure set_Color(value: DDN.System.Drawing.DNColor);

  { methods } 

    ///<summary>
    ///  String representation of TextStyle.
    ///</summary>
    ///<returns>String representation.</returns>
    function ToString: string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Name of the font.
    ///</summary>
    property FontName: string read get_FontName write set_FontName;
    ///<summary>
    ///  Fonst size.
    ///</summary>
    property FontSize: Double read get_FontSize write set_FontSize;
    ///<summary>
    ///  Gets or sets horizontal alignment of the text.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Text alignment. Valid values are: Left, Center, Rigth.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Color of the text.
    ///</summary>
    property Color: DDN.System.Drawing.DNColor read get_Color write set_Color;
  end;

  TDNTextStyle = class(TDNGenericImport<DNTextStyleClass, DNTextStyle>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNXfdfReaderClass = interface(DDN.mscorlib.DNObjectClass)
  ['{A6D5B0B1-D6B9-52E1-8C53-060A62381712}']
  { constructors } 

    {class} function init: DNXfdfReader;

  { static methods } 

    ///<summary>
    ///  Import annotations from XFDF file and put them into document.
    ///</summary>
    ///  <param name="stream">Source stream containing XFDF file.</param>
    ///  <param name="document">Document where annotations will be added.</param>
    {class} procedure ReadAnnotations(stream: DDN.mscorlib.DNStream; document: DNDocument);
    ///<summary>
    ///  Import field values from XFDF file.
    ///</summary>
    ///  <param name="stream">Stream containing XFDF data.</param>
    ///  <param name="document">Document where fields data will be imported.</param>
    {class} procedure ReadFields(stream: DDN.mscorlib.DNStream; document: DNDocument);
    ///<summary>
    ///  Parses XFDF file and returns information as hashtable.
    ///</summary>
    ///  <param name="reader">XmlReader for the source file.</param>
    ///<returns>Hashtable with information parsed from XFDF file.</returns>
    {class} function GetElements(reader: DDN.System.Xml.DNXmlReader): DDN.mscorlib.DNDictionary<string, string>;

  end;

  ///<summary>
  ///  Class which peroformes reading of XFDF format.
  ///</summary>
  ///<example><code lang="C#">
  ///  Document doc = new Document("example.pdf");
  ///  Stream xfdfStream = File.OpenRead("file.xfdf");
  ///  XfdfReader.ReadAnnotations(xfdfStream, doc);
  ///  xfdfStream.Close();
  ///  doc.Save("example_out.pdf");
  ///</code></example>
  [DNTypeName('Aspose.Pdf.Annotations.XfdfReader')]
  DNXfdfReader = interface(DDN.mscorlib.DNObject)
  ['{44BB6BE8-639D-3DAE-99EF-DC7EB36065E2}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNXfdfReader = class(TDNGenericImport<DNXfdfReaderClass, DNXfdfReader>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNArtifactClass = interface(DNObjectClass)
  ['{4F9E15D0-CE54-5AB0-821B-CF2BFAE8D924}']
  { constructors } 

    ///<summary>
    ///  Constructor of artifact with specified type and subtype
    ///</summary>
    ///  <param name="type">Name of artifact type.</param>
    ///  <param name="subType">NAme of artifact subtype.</param>
    {class} function init(&type: string; subType: string): DNArtifact; overload;
    ///<summary>
    ///  Constructor of artifact with specified type and subtype
    ///</summary>
    ///  <param name="type">Artifact type.</param>
    ///  <param name="subType">Artifact subtype.</param>
    {class} function init(&type: DNArtifact_ArtifactType; subType: DNArtifact_ArtifactSubtype): DNArtifact; overload;

  end;

  ///<summary>
  ///  Class represetns PDF Artifact object.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Artifact')]
  DNArtifact = interface(DDN.mscorlib.DNIDisposable)
  ['{4E11936A-0D19-3943-A941-B25908C28FD8}']
  { getters & setters } 

    function get_CustomType: string;
    procedure set_CustomType(value: string);
    function get_CustomSubtype: string;
    procedure set_CustomSubtype(value: string);
    function get_Type: DNArtifact_ArtifactType;
    procedure set_Type(value: DNArtifact_ArtifactType);
    function get_Subtype: DNArtifact_ArtifactSubtype;
    procedure set_Subtype(value: DNArtifact_ArtifactSubtype);
    function get_Contents: DDN.mscorlib.DNList<DNOperator>;
    function get_Form: DNXForm;
    function get_Rectangle: DNPdf_Rectangle;
    function get_Position: DNPoint;
    procedure set_Position(value: DNPoint);
    function get_RightMargin: Double;
    procedure set_RightMargin(value: Double);
    function get_LeftMargin: Double;
    procedure set_LeftMargin(value: Double);
    function get_TopMargin: Double;
    procedure set_TopMargin(value: Double);
    function get_BottomMargin: Double;
    procedure set_BottomMargin(value: Double);
    function get_ArtifactHorizontalAlignment: DNHorizontalAlignment;
    procedure set_ArtifactHorizontalAlignment(value: DNHorizontalAlignment);
    function get_ArtifactVerticalAlignment: DNVerticalAlignment;
    procedure set_ArtifactVerticalAlignment(value: DNVerticalAlignment);
    function get_Rotation: Double;
    procedure set_Rotation(value: Double);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_Image: DNXImage;
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_Lines: DDN.mscorlib.DNList<string>;
    function get_TextState: DNTextState;
    procedure set_TextState(value: DNTextState);
    function get_IsBackground: Boolean;
    procedure set_IsBackground(value: Boolean);

  { methods } 

    ///<summary>
    ///  Sets text of the artifact.
    ///</summary>
    ///  <param name="formattedText">FormattedText object which contains artifact text.</param>
    procedure SetText(formattedText: DNFormattedText);
    ///<summary>
    ///  Set text and text properties of the artifact.
    ///</summary>
    ///  <param name="Text">Text string.</param>
    ///  <param name="textState">Text properties (color, </param>
    procedure SetTextAndState(text: string; textState: DNTextState);
    ///<summary>
    ///  Set text and text properties of the artifact. Allows to specify multiple lines.
    ///</summary>
    ///  <param name="text">Array of text string.</param>
    ///  <param name="textState">Text properties.</param>
    procedure SetLinesAndState(text: TArray<string>; textState: DNTextState);
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageStream">Stream which contains image data.</param>
    procedure SetImage(imageStream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageName">Name of image file.</param>
    procedure SetImage(imageName: string); overload;
    ///<summary>
    ///  Sets PDF page which is placed on the document page as artifact.
    ///</summary>
    ///  <param name="page">Page which is placed as Artifcact. </param>
    procedure SetPdfPage(page: DNPage);
    ///<summary>
    ///  Dispose the artifact.
    ///</summary>
    procedure Dispose;
    ///<summary>
    ///  Gets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of value.</param>
    ///<returns>Value, or null if value does not exists.</returns>
    function GetValue(name: string): string;
    ///<summary>
    ///  Sets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of custom value.</param>
    ///  <param name="value">Custom value in the artifact.</param>
    procedure SetValue(name: string; value: string);
    ///<summary>
    ///  Remove custom value from the artifact.
    ///</summary>
    ///  <param name="name">Name of custom value to be removed.</param>
    procedure RemoveValue(name: string);
    ///<summary>
    ///  Start delated updates. Use this feature if you need make several changes to the same artifact to improve performance.
    ///  Usually artifact operators are changed anytime when artifact property was changed. This causes changing of page contents
    ///  everytime when artifact was changed. To avoid this effect put all artifact updates between StartUpdates/SaveUpdates calls.
    ///  This allows to change page contents only once.
    ///</summary>
    ///<example><code lang="C#">
    ///  Artifact art = doc.Pages[1].Artifacts[1];
    ///  art.BeginUpdates();
    ///  art.Opacity = 0.3f;
    ///  art.Position = new Point(10,10);
    ///  art.Rotation = 30;
    ///  art.SaveUpdates();
    ///</code></example>
    procedure BeginUpdates;
    ///<summary>
    ///  Saves all updates in artifact which were made after BeginUpdates() call.
    ///</summary>
    procedure SaveUpdates;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets name of artifact type. May be used if artifact type is non standard.
    ///</summary>
    property CustomType: string read get_CustomType write set_CustomType;
    ///<summary>
    ///  Gets name of artifact subtype. May be used  if artifact subtype is not standard subtype.
    ///</summary>
    property CustomSubtype: string read get_CustomSubtype write set_CustomSubtype;
    ///<summary>
    ///  Gets artifact type.
    ///</summary>
    property &Type: DNArtifact_ArtifactType read get_Type write set_Type;
    ///<summary>
    ///  Gets artifact subtype. If artifact has non-standard subtype, name of the subtype may be read via CustomSubtype.
    ///</summary>
    property Subtype: DNArtifact_ArtifactSubtype read get_Subtype write set_Subtype;
    ///<summary>
    ///  Gets collection of artifact internal operators.
    ///</summary>
    property Contents: DDN.mscorlib.DNList<DNOperator> read get_Contents;
    ///<summary>
    ///  Gets XForm of the artifact (if XForm is used).
    ///</summary>
    property Form: DNXForm read get_Form;
    ///<summary>
    ///  Gets rectangle of the artifact.
    ///</summary>
    property Rectangle: DNPdf_Rectangle read get_Rectangle;
    ///<summary>
    ///  Gets or sets artifact position.
    ///  If this property is specified, then margins and alignments are ignored.
    ///</summary>
    property Position: DNPoint read get_Position write set_Position;
    ///<summary>
    ///  Right margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property RightMargin: Double read get_RightMargin write set_RightMargin;
    ///<summary>
    ///  Left margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property LeftMargin: Double read get_LeftMargin write set_LeftMargin;
    ///<summary>
    ///  Top margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property TopMargin: Double read get_TopMargin write set_TopMargin;
    ///<summary>
    ///  Bottom margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property BottomMargin: Double read get_BottomMargin write set_BottomMargin;
    ///<summary>
    ///  Horizontal alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactHorizontalAlignment: DNHorizontalAlignment read get_ArtifactHorizontalAlignment write set_ArtifactHorizontalAlignment;
    ///<summary>
    ///  Vertical alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactVerticalAlignment: DNVerticalAlignment read get_ArtifactVerticalAlignment write set_ArtifactVerticalAlignment;
    ///<summary>
    ///  Gets or sets artifact rotation angle.
    ///</summary>
    property Rotation: Double read get_Rotation write set_Rotation;
    ///<summary>
    ///  Gets text of the artifact.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets image of the artifact (if presents).
    ///</summary>
    property Image: DNXImage read get_Image;
    ///<summary>
    ///  Gets or sets opacity of the artifact. Possible values are in range 0..1.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  Lines of multiline text artifact.
    ///</summary>
    property Lines: DDN.mscorlib.DNList<string> read get_Lines;
    ///<summary>
    ///  Text state for artifact text.
    ///</summary>
    property TextState: DNTextState read get_TextState write set_TextState;
    ///<summary>
    ///  If true Artifact is placed behind page contents.
    ///</summary>
    property IsBackground: Boolean read get_IsBackground write set_IsBackground;
  end;

  TDNArtifact = class(TDNGenericImport<DNArtifactClass, DNArtifact>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNBackgroundArtifactClass = interface(DNArtifactClass)
  ['{FBCA7DD5-532E-571A-BDC5-8DA761C4AFAB}']
  { constructors } 

    ///<summary>
    ///  Initializes BackgroundArtifact object.
    ///</summary>
    {class} function init: DNBackgroundArtifact;

  end;

  ///<summary>
  ///  Class descibes background artifact. This artifact allows to set background of the page.
  ///</summary>
  [DNTypeName('Aspose.Pdf.BackgroundArtifact')]
  DNBackgroundArtifact = interface(DNArtifact)
  ['{CDBB1847-C63D-3C0D-B82E-C5FD8FD68C1D}']
  { getters & setters } 

    function get_BackgroundColor: DNColor;
    procedure set_BackgroundColor(value: DNColor);
    function get_BackgroundImage: DDN.mscorlib.DNStream;
    procedure set_BackgroundImage(value: DDN.mscorlib.DNStream);
    function get_CustomType: string;
    procedure set_CustomType(value: string);
    function get_CustomSubtype: string;
    procedure set_CustomSubtype(value: string);
    function get_Type: DNArtifact_ArtifactType;
    procedure set_Type(value: DNArtifact_ArtifactType);
    function get_Subtype: DNArtifact_ArtifactSubtype;
    procedure set_Subtype(value: DNArtifact_ArtifactSubtype);
    function get_Contents: DDN.mscorlib.DNList<DNOperator>;
    function get_Form: DNXForm;
    function get_Rectangle: DNPdf_Rectangle;
    function get_Position: DNPoint;
    procedure set_Position(value: DNPoint);
    function get_RightMargin: Double;
    procedure set_RightMargin(value: Double);
    function get_LeftMargin: Double;
    procedure set_LeftMargin(value: Double);
    function get_TopMargin: Double;
    procedure set_TopMargin(value: Double);
    function get_BottomMargin: Double;
    procedure set_BottomMargin(value: Double);
    function get_ArtifactHorizontalAlignment: DNHorizontalAlignment;
    procedure set_ArtifactHorizontalAlignment(value: DNHorizontalAlignment);
    function get_ArtifactVerticalAlignment: DNVerticalAlignment;
    procedure set_ArtifactVerticalAlignment(value: DNVerticalAlignment);
    function get_Rotation: Double;
    procedure set_Rotation(value: Double);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_Image: DNXImage;
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_Lines: DDN.mscorlib.DNList<string>;
    function get_TextState: DNTextState;
    procedure set_TextState(value: DNTextState);
    function get_IsBackground: Boolean;
    procedure set_IsBackground(value: Boolean);

  { methods } 

    ///<summary>
    ///  Sets text of the artifact.
    ///</summary>
    ///  <param name="formattedText">FormattedText object which contains artifact text.</param>
    procedure SetText(formattedText: DNFormattedText);
    ///<summary>
    ///  Set text and text properties of the artifact.
    ///</summary>
    ///  <param name="Text">Text string.</param>
    ///  <param name="textState">Text properties (color, </param>
    procedure SetTextAndState(text: string; textState: DNTextState);
    ///<summary>
    ///  Set text and text properties of the artifact. Allows to specify multiple lines.
    ///</summary>
    ///  <param name="text">Array of text string.</param>
    ///  <param name="textState">Text properties.</param>
    procedure SetLinesAndState(text: TArray<string>; textState: DNTextState);
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageStream">Stream which contains image data.</param>
    procedure SetImage(imageStream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageName">Name of image file.</param>
    procedure SetImage(imageName: string); overload;
    ///<summary>
    ///  Sets PDF page which is placed on the document page as artifact.
    ///</summary>
    ///  <param name="page">Page which is placed as Artifcact. </param>
    procedure SetPdfPage(page: DNPage);
    ///<summary>
    ///  Dispose the artifact.
    ///</summary>
    procedure Dispose;
    ///<summary>
    ///  Gets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of value.</param>
    ///<returns>Value, or null if value does not exists.</returns>
    function GetValue(name: string): string;
    ///<summary>
    ///  Sets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of custom value.</param>
    ///  <param name="value">Custom value in the artifact.</param>
    procedure SetValue(name: string; value: string);
    ///<summary>
    ///  Remove custom value from the artifact.
    ///</summary>
    ///  <param name="name">Name of custom value to be removed.</param>
    procedure RemoveValue(name: string);
    ///<summary>
    ///  Start delated updates. Use this feature if you need make several changes to the same artifact to improve performance.
    ///  Usually artifact operators are changed anytime when artifact property was changed. This causes changing of page contents
    ///  everytime when artifact was changed. To avoid this effect put all artifact updates between StartUpdates/SaveUpdates calls.
    ///  This allows to change page contents only once.
    ///</summary>
    ///<example><code lang="C#">
    ///  Artifact art = doc.Pages[1].Artifacts[1];
    ///  art.BeginUpdates();
    ///  art.Opacity = 0.3f;
    ///  art.Position = new Point(10,10);
    ///  art.Rotation = 30;
    ///  art.SaveUpdates();
    ///</code></example>
    procedure BeginUpdates;
    ///<summary>
    ///  Saves all updates in artifact which were made after BeginUpdates() call.
    ///</summary>
    procedure SaveUpdates;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets bacground color of background artifact
    ///</summary>
    property BackgroundColor: DNColor read get_BackgroundColor write set_BackgroundColor;
    ///<summary>
    ///  Gets or sets bacground image of background artifact
    ///</summary>
    property BackgroundImage: DDN.mscorlib.DNStream read get_BackgroundImage write set_BackgroundImage;
    ///<summary>
    ///  Gets name of artifact type. May be used if artifact type is non standard.
    ///</summary>
    property CustomType: string read get_CustomType write set_CustomType;
    ///<summary>
    ///  Gets name of artifact subtype. May be used  if artifact subtype is not standard subtype.
    ///</summary>
    property CustomSubtype: string read get_CustomSubtype write set_CustomSubtype;
    ///<summary>
    ///  Gets artifact type.
    ///</summary>
    property &Type: DNArtifact_ArtifactType read get_Type write set_Type;
    ///<summary>
    ///  Gets artifact subtype. If artifact has non-standard subtype, name of the subtype may be read via CustomSubtype.
    ///</summary>
    property Subtype: DNArtifact_ArtifactSubtype read get_Subtype write set_Subtype;
    ///<summary>
    ///  Gets collection of artifact internal operators.
    ///</summary>
    property Contents: DDN.mscorlib.DNList<DNOperator> read get_Contents;
    ///<summary>
    ///  Gets XForm of the artifact (if XForm is used).
    ///</summary>
    property Form: DNXForm read get_Form;
    ///<summary>
    ///  Gets rectangle of the artifact.
    ///</summary>
    property Rectangle: DNPdf_Rectangle read get_Rectangle;
    ///<summary>
    ///  Gets or sets artifact position.
    ///  If this property is specified, then margins and alignments are ignored.
    ///</summary>
    property Position: DNPoint read get_Position write set_Position;
    ///<summary>
    ///  Right margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property RightMargin: Double read get_RightMargin write set_RightMargin;
    ///<summary>
    ///  Left margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property LeftMargin: Double read get_LeftMargin write set_LeftMargin;
    ///<summary>
    ///  Top margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property TopMargin: Double read get_TopMargin write set_TopMargin;
    ///<summary>
    ///  Bottom margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property BottomMargin: Double read get_BottomMargin write set_BottomMargin;
    ///<summary>
    ///  Horizontal alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactHorizontalAlignment: DNHorizontalAlignment read get_ArtifactHorizontalAlignment write set_ArtifactHorizontalAlignment;
    ///<summary>
    ///  Vertical alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactVerticalAlignment: DNVerticalAlignment read get_ArtifactVerticalAlignment write set_ArtifactVerticalAlignment;
    ///<summary>
    ///  Gets or sets artifact rotation angle.
    ///</summary>
    property Rotation: Double read get_Rotation write set_Rotation;
    ///<summary>
    ///  Gets text of the artifact.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets image of the artifact (if presents).
    ///</summary>
    property Image: DNXImage read get_Image;
    ///<summary>
    ///  Gets or sets opacity of the artifact. Possible values are in range 0..1.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  Lines of multiline text artifact.
    ///</summary>
    property Lines: DDN.mscorlib.DNList<string> read get_Lines;
    ///<summary>
    ///  Text state for artifact text.
    ///</summary>
    property TextState: DNTextState read get_TextState write set_TextState;
    ///<summary>
    ///  If true Artifact is placed behind page contents.
    ///</summary>
    property IsBackground: Boolean read get_IsBackground write set_IsBackground;
  end;

  TDNBackgroundArtifact = class(TDNGenericImport<DNBackgroundArtifactClass, DNBackgroundArtifact>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNFooterArtifactClass = interface(DNArtifactClass)
  ['{D904672F-4DC4-5DBC-84CC-FD1783A1DB1B}']
  { constructors } 

    ///<summary>
    ///  Creates Footer Artifact instance.
    ///</summary>
    {class} function init: DNFooterArtifact;

  end;

  ///<summary>
  ///  Describes footer artifact. This may be used to set footer of the page.
  ///</summary>
  [DNTypeName('Aspose.Pdf.FooterArtifact')]
  DNFooterArtifact = interface(DNArtifact)
  ['{DDDE536F-4E16-3B67-BC35-8DB8BA2E16B5}']
  { getters & setters } 

    function get_CustomType: string;
    procedure set_CustomType(value: string);
    function get_CustomSubtype: string;
    procedure set_CustomSubtype(value: string);
    function get_Type: DNArtifact_ArtifactType;
    procedure set_Type(value: DNArtifact_ArtifactType);
    function get_Subtype: DNArtifact_ArtifactSubtype;
    procedure set_Subtype(value: DNArtifact_ArtifactSubtype);
    function get_Contents: DDN.mscorlib.DNList<DNOperator>;
    function get_Form: DNXForm;
    function get_Rectangle: DNPdf_Rectangle;
    function get_Position: DNPoint;
    procedure set_Position(value: DNPoint);
    function get_RightMargin: Double;
    procedure set_RightMargin(value: Double);
    function get_LeftMargin: Double;
    procedure set_LeftMargin(value: Double);
    function get_TopMargin: Double;
    procedure set_TopMargin(value: Double);
    function get_BottomMargin: Double;
    procedure set_BottomMargin(value: Double);
    function get_ArtifactHorizontalAlignment: DNHorizontalAlignment;
    procedure set_ArtifactHorizontalAlignment(value: DNHorizontalAlignment);
    function get_ArtifactVerticalAlignment: DNVerticalAlignment;
    procedure set_ArtifactVerticalAlignment(value: DNVerticalAlignment);
    function get_Rotation: Double;
    procedure set_Rotation(value: Double);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_Image: DNXImage;
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_Lines: DDN.mscorlib.DNList<string>;
    function get_TextState: DNTextState;
    procedure set_TextState(value: DNTextState);
    function get_IsBackground: Boolean;
    procedure set_IsBackground(value: Boolean);

  { methods } 

    ///<summary>
    ///  Sets text of the artifact.
    ///</summary>
    ///  <param name="formattedText">FormattedText object which contains artifact text.</param>
    procedure SetText(formattedText: DNFormattedText);
    ///<summary>
    ///  Set text and text properties of the artifact.
    ///</summary>
    ///  <param name="Text">Text string.</param>
    ///  <param name="textState">Text properties (color, </param>
    procedure SetTextAndState(text: string; textState: DNTextState);
    ///<summary>
    ///  Set text and text properties of the artifact. Allows to specify multiple lines.
    ///</summary>
    ///  <param name="text">Array of text string.</param>
    ///  <param name="textState">Text properties.</param>
    procedure SetLinesAndState(text: TArray<string>; textState: DNTextState);
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageStream">Stream which contains image data.</param>
    procedure SetImage(imageStream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageName">Name of image file.</param>
    procedure SetImage(imageName: string); overload;
    ///<summary>
    ///  Sets PDF page which is placed on the document page as artifact.
    ///</summary>
    ///  <param name="page">Page which is placed as Artifcact. </param>
    procedure SetPdfPage(page: DNPage);
    ///<summary>
    ///  Dispose the artifact.
    ///</summary>
    procedure Dispose;
    ///<summary>
    ///  Gets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of value.</param>
    ///<returns>Value, or null if value does not exists.</returns>
    function GetValue(name: string): string;
    ///<summary>
    ///  Sets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of custom value.</param>
    ///  <param name="value">Custom value in the artifact.</param>
    procedure SetValue(name: string; value: string);
    ///<summary>
    ///  Remove custom value from the artifact.
    ///</summary>
    ///  <param name="name">Name of custom value to be removed.</param>
    procedure RemoveValue(name: string);
    ///<summary>
    ///  Start delated updates. Use this feature if you need make several changes to the same artifact to improve performance.
    ///  Usually artifact operators are changed anytime when artifact property was changed. This causes changing of page contents
    ///  everytime when artifact was changed. To avoid this effect put all artifact updates between StartUpdates/SaveUpdates calls.
    ///  This allows to change page contents only once.
    ///</summary>
    ///<example><code lang="C#">
    ///  Artifact art = doc.Pages[1].Artifacts[1];
    ///  art.BeginUpdates();
    ///  art.Opacity = 0.3f;
    ///  art.Position = new Point(10,10);
    ///  art.Rotation = 30;
    ///  art.SaveUpdates();
    ///</code></example>
    procedure BeginUpdates;
    ///<summary>
    ///  Saves all updates in artifact which were made after BeginUpdates() call.
    ///</summary>
    procedure SaveUpdates;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets name of artifact type. May be used if artifact type is non standard.
    ///</summary>
    property CustomType: string read get_CustomType write set_CustomType;
    ///<summary>
    ///  Gets name of artifact subtype. May be used  if artifact subtype is not standard subtype.
    ///</summary>
    property CustomSubtype: string read get_CustomSubtype write set_CustomSubtype;
    ///<summary>
    ///  Gets artifact type.
    ///</summary>
    property &Type: DNArtifact_ArtifactType read get_Type write set_Type;
    ///<summary>
    ///  Gets artifact subtype. If artifact has non-standard subtype, name of the subtype may be read via CustomSubtype.
    ///</summary>
    property Subtype: DNArtifact_ArtifactSubtype read get_Subtype write set_Subtype;
    ///<summary>
    ///  Gets collection of artifact internal operators.
    ///</summary>
    property Contents: DDN.mscorlib.DNList<DNOperator> read get_Contents;
    ///<summary>
    ///  Gets XForm of the artifact (if XForm is used).
    ///</summary>
    property Form: DNXForm read get_Form;
    ///<summary>
    ///  Gets rectangle of the artifact.
    ///</summary>
    property Rectangle: DNPdf_Rectangle read get_Rectangle;
    ///<summary>
    ///  Gets or sets artifact position.
    ///  If this property is specified, then margins and alignments are ignored.
    ///</summary>
    property Position: DNPoint read get_Position write set_Position;
    ///<summary>
    ///  Right margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property RightMargin: Double read get_RightMargin write set_RightMargin;
    ///<summary>
    ///  Left margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property LeftMargin: Double read get_LeftMargin write set_LeftMargin;
    ///<summary>
    ///  Top margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property TopMargin: Double read get_TopMargin write set_TopMargin;
    ///<summary>
    ///  Bottom margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property BottomMargin: Double read get_BottomMargin write set_BottomMargin;
    ///<summary>
    ///  Horizontal alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactHorizontalAlignment: DNHorizontalAlignment read get_ArtifactHorizontalAlignment write set_ArtifactHorizontalAlignment;
    ///<summary>
    ///  Vertical alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactVerticalAlignment: DNVerticalAlignment read get_ArtifactVerticalAlignment write set_ArtifactVerticalAlignment;
    ///<summary>
    ///  Gets or sets artifact rotation angle.
    ///</summary>
    property Rotation: Double read get_Rotation write set_Rotation;
    ///<summary>
    ///  Gets text of the artifact.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets image of the artifact (if presents).
    ///</summary>
    property Image: DNXImage read get_Image;
    ///<summary>
    ///  Gets or sets opacity of the artifact. Possible values are in range 0..1.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  Lines of multiline text artifact.
    ///</summary>
    property Lines: DDN.mscorlib.DNList<string> read get_Lines;
    ///<summary>
    ///  Text state for artifact text.
    ///</summary>
    property TextState: DNTextState read get_TextState write set_TextState;
    ///<summary>
    ///  If true Artifact is placed behind page contents.
    ///</summary>
    property IsBackground: Boolean read get_IsBackground write set_IsBackground;
  end;

  TDNFooterArtifact = class(TDNGenericImport<DNFooterArtifactClass, DNFooterArtifact>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNHeaderArtifactClass = interface(DNArtifactClass)
  ['{97FE5C2C-F688-50F7-A732-6BEECD68957A}']
  { constructors } 

    ///<summary>
    ///  Creates Header Artifact instance.
    ///</summary>
    {class} function init: DNHeaderArtifact;

  end;

  ///<summary>
  ///  Class describes Heaader artifact. This artifacgt may be used to set heading of the page.
  ///</summary>
  [DNTypeName('Aspose.Pdf.HeaderArtifact')]
  DNHeaderArtifact = interface(DNArtifact)
  ['{ED17285E-B51B-349E-BBA6-B6F34186B7EA}']
  { getters & setters } 

    function get_CustomType: string;
    procedure set_CustomType(value: string);
    function get_CustomSubtype: string;
    procedure set_CustomSubtype(value: string);
    function get_Type: DNArtifact_ArtifactType;
    procedure set_Type(value: DNArtifact_ArtifactType);
    function get_Subtype: DNArtifact_ArtifactSubtype;
    procedure set_Subtype(value: DNArtifact_ArtifactSubtype);
    function get_Contents: DDN.mscorlib.DNList<DNOperator>;
    function get_Form: DNXForm;
    function get_Rectangle: DNPdf_Rectangle;
    function get_Position: DNPoint;
    procedure set_Position(value: DNPoint);
    function get_RightMargin: Double;
    procedure set_RightMargin(value: Double);
    function get_LeftMargin: Double;
    procedure set_LeftMargin(value: Double);
    function get_TopMargin: Double;
    procedure set_TopMargin(value: Double);
    function get_BottomMargin: Double;
    procedure set_BottomMargin(value: Double);
    function get_ArtifactHorizontalAlignment: DNHorizontalAlignment;
    procedure set_ArtifactHorizontalAlignment(value: DNHorizontalAlignment);
    function get_ArtifactVerticalAlignment: DNVerticalAlignment;
    procedure set_ArtifactVerticalAlignment(value: DNVerticalAlignment);
    function get_Rotation: Double;
    procedure set_Rotation(value: Double);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_Image: DNXImage;
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_Lines: DDN.mscorlib.DNList<string>;
    function get_TextState: DNTextState;
    procedure set_TextState(value: DNTextState);
    function get_IsBackground: Boolean;
    procedure set_IsBackground(value: Boolean);

  { methods } 

    ///<summary>
    ///  Sets text of the artifact.
    ///</summary>
    ///  <param name="formattedText">FormattedText object which contains artifact text.</param>
    procedure SetText(formattedText: DNFormattedText);
    ///<summary>
    ///  Set text and text properties of the artifact.
    ///</summary>
    ///  <param name="Text">Text string.</param>
    ///  <param name="textState">Text properties (color, </param>
    procedure SetTextAndState(text: string; textState: DNTextState);
    ///<summary>
    ///  Set text and text properties of the artifact. Allows to specify multiple lines.
    ///</summary>
    ///  <param name="text">Array of text string.</param>
    ///  <param name="textState">Text properties.</param>
    procedure SetLinesAndState(text: TArray<string>; textState: DNTextState);
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageStream">Stream which contains image data.</param>
    procedure SetImage(imageStream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageName">Name of image file.</param>
    procedure SetImage(imageName: string); overload;
    ///<summary>
    ///  Sets PDF page which is placed on the document page as artifact.
    ///</summary>
    ///  <param name="page">Page which is placed as Artifcact. </param>
    procedure SetPdfPage(page: DNPage);
    ///<summary>
    ///  Dispose the artifact.
    ///</summary>
    procedure Dispose;
    ///<summary>
    ///  Gets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of value.</param>
    ///<returns>Value, or null if value does not exists.</returns>
    function GetValue(name: string): string;
    ///<summary>
    ///  Sets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of custom value.</param>
    ///  <param name="value">Custom value in the artifact.</param>
    procedure SetValue(name: string; value: string);
    ///<summary>
    ///  Remove custom value from the artifact.
    ///</summary>
    ///  <param name="name">Name of custom value to be removed.</param>
    procedure RemoveValue(name: string);
    ///<summary>
    ///  Start delated updates. Use this feature if you need make several changes to the same artifact to improve performance.
    ///  Usually artifact operators are changed anytime when artifact property was changed. This causes changing of page contents
    ///  everytime when artifact was changed. To avoid this effect put all artifact updates between StartUpdates/SaveUpdates calls.
    ///  This allows to change page contents only once.
    ///</summary>
    ///<example><code lang="C#">
    ///  Artifact art = doc.Pages[1].Artifacts[1];
    ///  art.BeginUpdates();
    ///  art.Opacity = 0.3f;
    ///  art.Position = new Point(10,10);
    ///  art.Rotation = 30;
    ///  art.SaveUpdates();
    ///</code></example>
    procedure BeginUpdates;
    ///<summary>
    ///  Saves all updates in artifact which were made after BeginUpdates() call.
    ///</summary>
    procedure SaveUpdates;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets name of artifact type. May be used if artifact type is non standard.
    ///</summary>
    property CustomType: string read get_CustomType write set_CustomType;
    ///<summary>
    ///  Gets name of artifact subtype. May be used  if artifact subtype is not standard subtype.
    ///</summary>
    property CustomSubtype: string read get_CustomSubtype write set_CustomSubtype;
    ///<summary>
    ///  Gets artifact type.
    ///</summary>
    property &Type: DNArtifact_ArtifactType read get_Type write set_Type;
    ///<summary>
    ///  Gets artifact subtype. If artifact has non-standard subtype, name of the subtype may be read via CustomSubtype.
    ///</summary>
    property Subtype: DNArtifact_ArtifactSubtype read get_Subtype write set_Subtype;
    ///<summary>
    ///  Gets collection of artifact internal operators.
    ///</summary>
    property Contents: DDN.mscorlib.DNList<DNOperator> read get_Contents;
    ///<summary>
    ///  Gets XForm of the artifact (if XForm is used).
    ///</summary>
    property Form: DNXForm read get_Form;
    ///<summary>
    ///  Gets rectangle of the artifact.
    ///</summary>
    property Rectangle: DNPdf_Rectangle read get_Rectangle;
    ///<summary>
    ///  Gets or sets artifact position.
    ///  If this property is specified, then margins and alignments are ignored.
    ///</summary>
    property Position: DNPoint read get_Position write set_Position;
    ///<summary>
    ///  Right margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property RightMargin: Double read get_RightMargin write set_RightMargin;
    ///<summary>
    ///  Left margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property LeftMargin: Double read get_LeftMargin write set_LeftMargin;
    ///<summary>
    ///  Top margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property TopMargin: Double read get_TopMargin write set_TopMargin;
    ///<summary>
    ///  Bottom margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property BottomMargin: Double read get_BottomMargin write set_BottomMargin;
    ///<summary>
    ///  Horizontal alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactHorizontalAlignment: DNHorizontalAlignment read get_ArtifactHorizontalAlignment write set_ArtifactHorizontalAlignment;
    ///<summary>
    ///  Vertical alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactVerticalAlignment: DNVerticalAlignment read get_ArtifactVerticalAlignment write set_ArtifactVerticalAlignment;
    ///<summary>
    ///  Gets or sets artifact rotation angle.
    ///</summary>
    property Rotation: Double read get_Rotation write set_Rotation;
    ///<summary>
    ///  Gets text of the artifact.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets image of the artifact (if presents).
    ///</summary>
    property Image: DNXImage read get_Image;
    ///<summary>
    ///  Gets or sets opacity of the artifact. Possible values are in range 0..1.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  Lines of multiline text artifact.
    ///</summary>
    property Lines: DDN.mscorlib.DNList<string> read get_Lines;
    ///<summary>
    ///  Text state for artifact text.
    ///</summary>
    property TextState: DNTextState read get_TextState write set_TextState;
    ///<summary>
    ///  If true Artifact is placed behind page contents.
    ///</summary>
    property IsBackground: Boolean read get_IsBackground write set_IsBackground;
  end;

  TDNHeaderArtifact = class(TDNGenericImport<DNHeaderArtifactClass, DNHeaderArtifact>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNWatermarkArtifactClass = interface(DNArtifactClass)
  ['{9D1B9078-21D1-5B25-87FB-4C9FD38F532A}']
  { constructors } 

    ///<summary>
    ///  Creates instance of Watermark artifact.
    ///</summary>
    {class} function init: DNWatermarkArtifact;

  end;

  ///<summary>
  ///  Class describes watermark artifact. This may be used to
  ///</summary>
  [DNTypeName('Aspose.Pdf.WatermarkArtifact')]
  DNWatermarkArtifact = interface(DNArtifact)
  ['{3AC922AC-D821-3D4B-B5DA-FE479F5B1477}']
  { getters & setters } 

    function get_CustomType: string;
    procedure set_CustomType(value: string);
    function get_CustomSubtype: string;
    procedure set_CustomSubtype(value: string);
    function get_Type: DNArtifact_ArtifactType;
    procedure set_Type(value: DNArtifact_ArtifactType);
    function get_Subtype: DNArtifact_ArtifactSubtype;
    procedure set_Subtype(value: DNArtifact_ArtifactSubtype);
    function get_Contents: DDN.mscorlib.DNList<DNOperator>;
    function get_Form: DNXForm;
    function get_Rectangle: DNPdf_Rectangle;
    function get_Position: DNPoint;
    procedure set_Position(value: DNPoint);
    function get_RightMargin: Double;
    procedure set_RightMargin(value: Double);
    function get_LeftMargin: Double;
    procedure set_LeftMargin(value: Double);
    function get_TopMargin: Double;
    procedure set_TopMargin(value: Double);
    function get_BottomMargin: Double;
    procedure set_BottomMargin(value: Double);
    function get_ArtifactHorizontalAlignment: DNHorizontalAlignment;
    procedure set_ArtifactHorizontalAlignment(value: DNHorizontalAlignment);
    function get_ArtifactVerticalAlignment: DNVerticalAlignment;
    procedure set_ArtifactVerticalAlignment(value: DNVerticalAlignment);
    function get_Rotation: Double;
    procedure set_Rotation(value: Double);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_Image: DNXImage;
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_Lines: DDN.mscorlib.DNList<string>;
    function get_TextState: DNTextState;
    procedure set_TextState(value: DNTextState);
    function get_IsBackground: Boolean;
    procedure set_IsBackground(value: Boolean);

  { methods } 

    ///<summary>
    ///  Sets text of the artifact.
    ///</summary>
    ///  <param name="formattedText">FormattedText object which contains artifact text.</param>
    procedure SetText(formattedText: DNFormattedText);
    ///<summary>
    ///  Set text and text properties of the artifact.
    ///</summary>
    ///  <param name="Text">Text string.</param>
    ///  <param name="textState">Text properties (color, </param>
    procedure SetTextAndState(text: string; textState: DNTextState);
    ///<summary>
    ///  Set text and text properties of the artifact. Allows to specify multiple lines.
    ///</summary>
    ///  <param name="text">Array of text string.</param>
    ///  <param name="textState">Text properties.</param>
    procedure SetLinesAndState(text: TArray<string>; textState: DNTextState);
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageStream">Stream which contains image data.</param>
    procedure SetImage(imageStream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Sets image of the artifact.
    ///</summary>
    ///  <param name="imageName">Name of image file.</param>
    procedure SetImage(imageName: string); overload;
    ///<summary>
    ///  Sets PDF page which is placed on the document page as artifact.
    ///</summary>
    ///  <param name="page">Page which is placed as Artifcact. </param>
    procedure SetPdfPage(page: DNPage);
    ///<summary>
    ///  Dispose the artifact.
    ///</summary>
    procedure Dispose;
    ///<summary>
    ///  Gets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of value.</param>
    ///<returns>Value, or null if value does not exists.</returns>
    function GetValue(name: string): string;
    ///<summary>
    ///  Sets custom value of artifact.
    ///</summary>
    ///  <param name="name">Name of custom value.</param>
    ///  <param name="value">Custom value in the artifact.</param>
    procedure SetValue(name: string; value: string);
    ///<summary>
    ///  Remove custom value from the artifact.
    ///</summary>
    ///  <param name="name">Name of custom value to be removed.</param>
    procedure RemoveValue(name: string);
    ///<summary>
    ///  Start delated updates. Use this feature if you need make several changes to the same artifact to improve performance.
    ///  Usually artifact operators are changed anytime when artifact property was changed. This causes changing of page contents
    ///  everytime when artifact was changed. To avoid this effect put all artifact updates between StartUpdates/SaveUpdates calls.
    ///  This allows to change page contents only once.
    ///</summary>
    ///<example><code lang="C#">
    ///  Artifact art = doc.Pages[1].Artifacts[1];
    ///  art.BeginUpdates();
    ///  art.Opacity = 0.3f;
    ///  art.Position = new Point(10,10);
    ///  art.Rotation = 30;
    ///  art.SaveUpdates();
    ///</code></example>
    procedure BeginUpdates;
    ///<summary>
    ///  Saves all updates in artifact which were made after BeginUpdates() call.
    ///</summary>
    procedure SaveUpdates;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets name of artifact type. May be used if artifact type is non standard.
    ///</summary>
    property CustomType: string read get_CustomType write set_CustomType;
    ///<summary>
    ///  Gets name of artifact subtype. May be used  if artifact subtype is not standard subtype.
    ///</summary>
    property CustomSubtype: string read get_CustomSubtype write set_CustomSubtype;
    ///<summary>
    ///  Gets artifact type.
    ///</summary>
    property &Type: DNArtifact_ArtifactType read get_Type write set_Type;
    ///<summary>
    ///  Gets artifact subtype. If artifact has non-standard subtype, name of the subtype may be read via CustomSubtype.
    ///</summary>
    property Subtype: DNArtifact_ArtifactSubtype read get_Subtype write set_Subtype;
    ///<summary>
    ///  Gets collection of artifact internal operators.
    ///</summary>
    property Contents: DDN.mscorlib.DNList<DNOperator> read get_Contents;
    ///<summary>
    ///  Gets XForm of the artifact (if XForm is used).
    ///</summary>
    property Form: DNXForm read get_Form;
    ///<summary>
    ///  Gets rectangle of the artifact.
    ///</summary>
    property Rectangle: DNPdf_Rectangle read get_Rectangle;
    ///<summary>
    ///  Gets or sets artifact position.
    ///  If this property is specified, then margins and alignments are ignored.
    ///</summary>
    property Position: DNPoint read get_Position write set_Position;
    ///<summary>
    ///  Right margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property RightMargin: Double read get_RightMargin write set_RightMargin;
    ///<summary>
    ///  Left margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property LeftMargin: Double read get_LeftMargin write set_LeftMargin;
    ///<summary>
    ///  Top margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property TopMargin: Double read get_TopMargin write set_TopMargin;
    ///<summary>
    ///  Bottom margin of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property BottomMargin: Double read get_BottomMargin write set_BottomMargin;
    ///<summary>
    ///  Horizontal alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactHorizontalAlignment: DNHorizontalAlignment read get_ArtifactHorizontalAlignment write set_ArtifactHorizontalAlignment;
    ///<summary>
    ///  Vertical alignment of artifact.
    ///  If position is specified explicitly (in Position property) this value is ignored.
    ///</summary>
    property ArtifactVerticalAlignment: DNVerticalAlignment read get_ArtifactVerticalAlignment write set_ArtifactVerticalAlignment;
    ///<summary>
    ///  Gets or sets artifact rotation angle.
    ///</summary>
    property Rotation: Double read get_Rotation write set_Rotation;
    ///<summary>
    ///  Gets text of the artifact.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets image of the artifact (if presents).
    ///</summary>
    property Image: DNXImage read get_Image;
    ///<summary>
    ///  Gets or sets opacity of the artifact. Possible values are in range 0..1.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  Lines of multiline text artifact.
    ///</summary>
    property Lines: DDN.mscorlib.DNList<string> read get_Lines;
    ///<summary>
    ///  Text state for artifact text.
    ///</summary>
    property TextState: DNTextState read get_TextState write set_TextState;
    ///<summary>
    ///  If true Artifact is placed behind page contents.
    ///</summary>
    property IsBackground: Boolean read get_IsBackground write set_IsBackground;
  end;

  TDNWatermarkArtifact = class(TDNGenericImport<DNWatermarkArtifactClass, DNWatermarkArtifact>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNArtifactCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{273FAA65-F4CA-5942-9A42-9DBCF22C00B6}']
  end;

  ///<summary>
  ///  Class represents artifact collection.
  ///</summary>
  [DNTypeName('Aspose.Pdf.ArtifactCollection')]
  DNArtifactCollection = interface(DDN.mscorlib.DNObject)
  ['{749F7AA8-8594-3987-A4BB-740E218E5D22}']
  { getters & setters } 

    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_Item(index: Int32): DNArtifact;
    function get_IsReadOnly: Boolean;

  { methods } 

    ///<summary>
    ///  Copies colection into an array.
    ///</summary>
    ///  <param name="dest">Destination array.</param>
    ///  <param name="index">Starting index.</param>
    procedure CopyTo(dest: TArray<DNArtifact>; index: Int32);
    ///<summary>
    ///  Gets enumerator for the collection.
    ///</summary>
    ///<returns>Enumerator object.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNArtifact>;
    ///<summary>
    ///  Finds artifacts by custom value.
    ///</summary>
    ///  <param name="name">Name of custom value.</param>
    ///  <param name="expectedValue">Value to find.</param>
    ///<returns>List of found artifacts.</returns>
    function FindByValue(name: string; expectedValue: string): DDN.mscorlib.DNList<DNArtifact>;
    ///<summary>
    ///  Deletes specified artifact.
    ///</summary>
    ///  <param name="artifact">Artifact which will be deleted.</param>
    procedure Delete(artifact: DNArtifact); overload;
    ///<summary>
    ///  Update artifact inside the collection.
    ///</summary>
    ///  <param name="artifact">Artifact to be updated.</param>
    procedure Update(artifact: DNArtifact);
    ///<summary>
    ///  Deletes artifact by its index.
    ///</summary>
    ///  <param name="index">Index of artifact to delete.</param>
    procedure Delete(index: Int32); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Is this object synchronized.
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets count of artifacts in collection.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Gets synchronization object of the collection.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property Item[index: Int32]: DNArtifact read get_Item; default;
    ///<summary>
    ///  Gets if collection is readonly. Always returns false.
    ///</summary>
    property IsReadOnly: Boolean read get_IsReadOnly;
  end;

  TDNArtifactCollection = class(TDNGenericImport<DNArtifactCollectionClass, DNArtifactCollection>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNBaseActionCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F2438543-C303-5280-A018-82DC2861B12C}']
  end;

  ///<summary>
  ///  Class incapsulates basic actions wuth page/annotation/field interactive actions
  ///</summary>
  [DNTypeName('Aspose.Pdf.BaseActionCollection')]
  DNBaseActionCollection = interface(DDN.mscorlib.DNObject)
  ['{8324B312-FC9F-3F15-9EAE-C6797C828B9D}']
  { methods } 

    ///<summary>
    ///  Removes all actions of the annotation.
    ///</summary>
    procedure RemoveActions;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNBaseActionCollection = class(TDNGenericImport<DNBaseActionCollectionClass, DNBaseActionCollection>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNAnnotationActionCollectionClass = interface(DNBaseActionCollectionClass)
  ['{9D25F5FE-E658-511B-B518-CA553FFB79E4}']
  end;

  ///<summary>
  ///  Represents the collection of annotation actions.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.AnnotationActionCollection')]
  DNAnnotationActionCollection = interface(DNBaseActionCollection)
  ['{876ACB7E-3195-3D02-ACFB-E25DE9931EC2}']
  { getters & setters } 

    function get_OnEnter: DNPdfAction;
    procedure set_OnEnter(value: DNPdfAction);
    function get_OnExit: DNPdfAction;
    procedure set_OnExit(value: DNPdfAction);
    function get_OnPressMouseBtn: DNPdfAction;
    procedure set_OnPressMouseBtn(value: DNPdfAction);
    function get_OnReleaseMouseBtn: DNPdfAction;
    procedure set_OnReleaseMouseBtn(value: DNPdfAction);
    function get_OnReceiveFocus: DNPdfAction;
    procedure set_OnReceiveFocus(value: DNPdfAction);
    function get_OnOpenPage: DNPdfAction;
    procedure set_OnOpenPage(value: DNPdfAction);
    function get_OnClosePage: DNPdfAction;
    procedure set_OnClosePage(value: DNPdfAction);
    function get_OnShowPage: DNPdfAction;
    procedure set_OnShowPage(value: DNPdfAction);
    function get_OnHidePage: DNPdfAction;
    procedure set_OnHidePage(value: DNPdfAction);
    function get_OnLostFocus: DNPdfAction;
    procedure set_OnLostFocus(value: DNPdfAction);
    function get_OnModifyCharacter: DNPdfAction;
    procedure set_OnModifyCharacter(value: DNPdfAction);
    function get_OnValidate: DNPdfAction;
    procedure set_OnValidate(value: DNPdfAction);
    function get_OnFormat: DNPdfAction;
    procedure set_OnFormat(value: DNPdfAction);
    function get_OnCalculate: DNPdfAction;
    procedure set_OnCalculate(value: DNPdfAction);

  { methods } 

    ///<summary>
    ///  Removes all actions of the annotation.
    ///</summary>
    procedure RemoveActions;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets an action to be performed when the cursor enters the annotation�s active area.
    ///</summary>
    property OnEnter: DNPdfAction read get_OnEnter write set_OnEnter;
    ///<summary>
    ///  Gets or sets an action to be performed when the cursor exits the annotation�s active area.
    ///</summary>
    property OnExit: DNPdfAction read get_OnExit write set_OnExit;
    ///<summary>
    ///  Gets or sets an action to be performed when the mouse button is pressed inside the annotation�s active area.
    ///</summary>
    property OnPressMouseBtn: DNPdfAction read get_OnPressMouseBtn write set_OnPressMouseBtn;
    ///<summary>
    ///  Gets or sets an action to be performed when the mouse button is released inside the annotation�s active area.
    ///</summary>
    property OnReleaseMouseBtn: DNPdfAction read get_OnReleaseMouseBtn write set_OnReleaseMouseBtn;
    ///<summary>
    ///  Gets or sets an action to be performed when the annotation receives the input focus.
    ///</summary>
    property OnReceiveFocus: DNPdfAction read get_OnReceiveFocus write set_OnReceiveFocus;
    ///<summary>
    ///  Gets or sets an action to be performed when the page containing the annotation is opened.
    ///</summary>
    property OnOpenPage: DNPdfAction read get_OnOpenPage write set_OnOpenPage;
    ///<summary>
    ///  Gets or sets an action to be performed when the page containing the annotation is closed.
    ///</summary>
    property OnClosePage: DNPdfAction read get_OnClosePage write set_OnClosePage;
    ///<summary>
    ///  Gets or sets an action to be performed when the page containing the annotation becomes visible in the viewer application�s user interface.
    ///</summary>
    property OnShowPage: DNPdfAction read get_OnShowPage write set_OnShowPage;
    ///<summary>
    ///  Gets or sets an action to be performed when the page containing the annotation is no longer visible in the viewer application�s user interface.
    ///</summary>
    property OnHidePage: DNPdfAction read get_OnHidePage write set_OnHidePage;
    ///<summary>
    ///  Gets or sets an action to be performed when the annotation loses the input focus.
    ///</summary>
    property OnLostFocus: DNPdfAction read get_OnLostFocus write set_OnLostFocus;
    ///<summary>
    ///  Gets or sets an action to be performed when user modifies character of the field.
    ///</summary>
    property OnModifyCharacter: DNPdfAction read get_OnModifyCharacter write set_OnModifyCharacter;
    ///<summary>
    ///  Gets or sets an action to be performed when user changes contents of the field.
    ///</summary>
    property OnValidate: DNPdfAction read get_OnValidate write set_OnValidate;
    ///<summary>
    ///  Gets or sets an action to be performed to format field value.
    ///</summary>
    property OnFormat: DNPdfAction read get_OnFormat write set_OnFormat;
    ///<summary>
    ///  Gets or sets an action to calculate field value.
    ///</summary>
    property OnCalculate: DNPdfAction read get_OnCalculate write set_OnCalculate;
  end;

  TDNAnnotationActionCollection = class(TDNGenericImport<DNAnnotationActionCollectionClass, DNAnnotationActionCollection>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNPageActionCollectionClass = interface(DNBaseActionCollectionClass)
  ['{33AE155A-5FFC-5960-ABCB-BF94613F108A}']
  end;

  ///<summary>
  ///  This class describes page actions
  ///</summary>
  [DNTypeName('Aspose.Pdf.PageActionCollection')]
  DNPageActionCollection = interface(DNBaseActionCollection)
  ['{2C4C6E1C-0E2F-322A-86BE-E8695963D82E}']
  { getters & setters } 

    function get_OnOpen: DNPdfAction;
    procedure set_OnOpen(value: DNPdfAction);
    function get_OnClose: DNPdfAction;
    procedure set_OnClose(value: DNPdfAction);

  { methods } 

    ///<summary>
    ///  Removes all actions of the annotation.
    ///</summary>
    procedure RemoveActions;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  An action that shall be performed when the page is opened.
    ///</summary>
    property OnOpen: DNPdfAction read get_OnOpen write set_OnOpen;
    ///<summary>
    ///  An action that shall be performed when the page is closed.
    ///</summary>
    property OnClose: DNPdfAction read get_OnClose write set_OnClose;
  end;

  TDNPageActionCollection = class(TDNGenericImport<DNPageActionCollectionClass, DNPageActionCollection>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNBaseOperatorCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B98A5D40-653C-5268-A170-C3B25F3AD869}']
  end;

  ///<summary>
  ///  Represents base class for operator collection.
  ///</summary>
  [DNTypeName('Aspose.Pdf.BaseOperatorCollection')]
  DNBaseOperatorCollection = interface(DDN.mscorlib.DNObject)
  ['{D3142BB3-77C1-3C4D-B0A7-A92A45695308}']
  { getters & setters } 

    function get_Item(index: Int32): DNOperator;
    procedure set_Item(index: Int32; value: DNOperator);
    function get_Count: Int32;
    function get_IsReadOnly: Boolean;
    function get_IsFastTextExtractionMode: Boolean;

  { methods } 

    ///<summary>
    ///  Returns enumerator for collection
    ///</summary>
    ///<returns>Collection enumerator</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNOperator>;
    ///<summary>
    ///  Copies operators into operators list.
    ///</summary>
    ///  <param name="array">Array with operators which must to be copied. This array must be Object[] or Operator[].</param>
    ///  <param name="index">Starting index from which operators will be copied</param>
    procedure CopyTo(&array: TArray<DNOperator>; index: Int32);
    ///<summary>
    ///  Suppresses update contents data.
    ///  The contents stream is not updated until ResumeUpdate is called.
    ///</summary>
    procedure SuppressUpdate;
    ///<summary>
    ///  Resumes document update.
    ///  Updates contents stream in case there are any pending changes.
    ///</summary>
    procedure ResumeUpdate;
    ///<summary>
    ///  Inserts operator into collection.
    ///</summary>
    ///  <param name="index">Index where new operator must be added</param>
    ///  <param name="op">Operator which will be insterted</param>
    procedure Insert(index: Int32; op: DNOperator);
    ///<summary>
    ///  Adds new operator into collection.
    ///</summary>
    ///  <param name="op">Operator which must be added</param>
    procedure Add(op: DNOperator);
    ///<summary>
    ///  Removes operator from collection.
    ///</summary>
    ///  <param name="item"></param>
    ///<returns></returns>
    function Remove(item: DNOperator): Boolean;
    ///<summary></summary>
    ///  <param name="item"></param>
    ///<returns></returns>
    function &Contains(item: DNOperator): Boolean;
    ///<summary>
    ///  Clears collection.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Cancels last update.
    ///  This method may be called when the change should not raise contents update.
    ///</summary>
    procedure CancelUpdate;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNOperator read get_Item write set_Item; default;
    ///<summary>
    ///  Gets count of operators in the collection.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Returns true if collection is read only.
    ///</summary>
    property IsReadOnly: Boolean read get_IsReadOnly;
    ///<summary>
    ///  Indicates wheather collection is limited to fast text extraction
    ///</summary>
    property IsFastTextExtractionMode: Boolean read get_IsFastTextExtractionMode;
  end;

  TDNBaseOperatorCollection = class(TDNGenericImport<DNBaseOperatorCollectionClass, DNBaseOperatorCollection>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNOperatorCollectionClass = interface(DNBaseOperatorCollectionClass)
  ['{AAEF8148-4C3A-5206-8DC0-F6954C2CBF78}']
  end;

  ///<summary>
  ///  Class represents collection of operators
  ///</summary>
  [DNTypeName('Aspose.Pdf.OperatorCollection')]
  DNOperatorCollection = interface(DNBaseOperatorCollection)
  ['{35DBBC6D-456C-3902-B6D4-A4A6EEE92D1C}']
  { getters & setters } 

    function get_IsReadOnly: Boolean;
    function get_Count: Int32;
    function get_IsFastTextExtractionMode: Boolean;
    function get_Item(index: Int32): DNOperator;
    procedure set_Item(index: Int32; value: DNOperator);

  { methods } 

    ///<summary>
    ///  Copies operators into operators list.
    ///</summary>
    ///  <param name="array">Array with operators which must to be copied. This array must be Object[] or Operator[].</param>
    ///  <param name="index">Starting index from which operators will be copied</param>
    procedure CopyTo(&array: TArray<DNOperator>; index: Int32);
    ///<summary>
    ///  Returns enumerator for collection
    ///</summary>
    ///<returns>Collection enumerator</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNOperator>;
    ///<summary>
    ///  Accepts IOperatorSelector visitor object to process operators.
    ///</summary>
    ///  <param name="visitor">Visitor object</param>
    procedure Accept(visitor: DNIOperatorSelector);
    ///<summary>
    ///  Adds new operator into collection.
    ///</summary>
    ///  <param name="op">Operator which must be added</param>
    ///<example>
    ///  Example demonstrates how to add operators to the end of page.contents.
    ///<code lang="C#">
    ///  Document doc = new Document("input.pdf");
    ///  doc.Pages[1].Contents.Add(new Aspose.Pdf.Operators.q());
    ///  doc.Pages[1].Contents.Add(new Aspose.Pdf.Operators.Q());
    ///</code></example>
    procedure Add(op: DNOperator); overload;
    ///<summary>
    ///  Deletes operator from collection.
    ///</summary>
    ///  <param name="index">Index of operator which must be deleted. Operators numbering starts from 1.</param>
    ///<example>
    ///  Example demonstrates how to delete operator by its index.
    ///<code lang="C#">
    ///  Document doc = new Document("input.pdf");
    ///  OperatorCollection oc = doc.Pages[1].Contents;
    ///  oc.Delete(3);
    ///</code></example>
    procedure Delete(index: Int32); overload;
    ///<summary>
    ///  Inserts operator into collection.
    ///</summary>
    ///  <param name="index">Index where new operator must be added</param>
    ///  <param name="op">Operator which will be insterted</param>
    ///<example>
    ///  Example demonstrates how to insert operator to the page contents.
    ///<code lang="C#">
    ///  Document doc = new Document("input.pdf");
    ///  OperatorCollection oc = doc.Pages[1].Contents;
    ///  oc.Insert(1, new Aspose.Pdf.Operators.q());
    ///  oc.Add(new Aspose.Pdf.Operators.Q());
    ///</code></example>
    procedure Insert(index: Int32; op: DNOperator); overload;
    procedure Replace(operators: DDN.mscorlib.DNIList<DNOperator>);
    ///<summary>
    ///  Add operators at the end of the contents operators.
    ///</summary>
    ///  <param name="ops">Array of operators to be added. Each operator can have any index (by default -1) because they come to the end of the contents operators i.e. indices are assigned automatically.</param>
    ///<example>
    ///  Example demonstrates how to add  operator to the end of page contents.
    ///<code lang="C#">
    ///  Document doc = new Document("input.pdf");
    ///  OperatorCollection oc = doc.Pages[1].Contents;
    ///  oc.Add(new Operator[] { new Aspose.Pdf.Operators.q(), new Aspose.Pdf.Operators.Q() } );
    ///</code></example>
    procedure Add(ops: TArray<DNOperator>); overload;
    ///<summary>
    ///  Insert operators at the the given position.
    ///</summary>
    ///  <param name="at">Index from which operators are being started to insert.</param>
    ///  <param name="ops">Array of operators to be inserted. Each operator can have any index (by default -1) because their indices adjusted automatically starting from <paramref name="at" />
    ///  .</param>
    ///<example>
    ///  Example demonstrates how to insert operator to the page contents.
    ///<code lang="C#">
    ///  Document doc = new Document("input.pdf");
    ///  OperatorCollection oc = doc.Pages[1].Contents;
    ///  oc.Insert(1, new Operator[] { new Aspose.Pdf.Operators.q(), new Aspose.Pdf.Operators.Q() } );
    ///</code></example>
    procedure Insert(at: Int32; ops: TArray<DNOperator>); overload;
    ///<summary>
    ///  Deletes operators from collection.
    ///</summary>
    ///  <param name="ops">Array of operators to delete</param>
    ///<example>
    ///  Example demonstrates how to remove operator from page contents.
    ///<code lang="C#">
    ///  Document doc = new Document("input.pdf");
    ///  OperatorCollection oc = doc.Pages[1].Contents;
    ///  oc.Delete(new Operator[] { oc[1] } );
    ///</code></example>
    procedure Delete(ops: TArray<DNOperator>); overload;
    procedure Delete(list: DDN.mscorlib.DNIList<DNOperator>); overload;
    procedure Insert(at: Int32; ops: DDN.mscorlib.DNIList<DNOperator>); overload;
    ///<summary>
    ///  Removes all operators from list.
    ///</summary>
    ///<example>
    ///  Example demonstrates how to clear page contents.
    ///<code lang="C#">
    ///  Document doc = new Document("input.pdf");
    ///  doc.Pages[1].Clear();
    ///</code></example>
    procedure Clear;
    ///<summary>
    ///  Returns text representation of the operator.
    ///</summary>
    ///<returns>Text representation of operator.</returns>
    function ToString: string;
    procedure Add(ops: DDN.mscorlib.DNICollection<DNOperator>); overload;
    ///<summary>
    ///  Suppresses update contents data.
    ///  The contents stream is not updated until ResumeUpdate is called.
    ///</summary>
    procedure SuppressUpdate;
    ///<summary>
    ///  Resumes document update.
    ///  Updates contents stream in case there are any pending changes.
    ///</summary>
    procedure ResumeUpdate;
    ///<summary>
    ///  Cancels last update.
    ///  This method may be called when the change should not raise contents update.
    ///</summary>
    procedure CancelUpdate;
    ///<summary>
    ///  Remove operator from the collection.
    ///</summary>
    ///  <param name="op">Operator to be removed.</param>
    ///<returns>True if operator was found and removed. False if operator did not belong to the collection.</returns>
    function Remove(op: DNOperator): Boolean;
    ///<summary>
    ///  Returns true if the collection contains given operator.
    ///</summary>
    ///  <param name="op"></param>
    ///<returns></returns>
    function &Contains(op: DNOperator): Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets a value indicating whether the collection is read-only.
    ///</summary>
    property IsReadOnly: Boolean read get_IsReadOnly;
    ///<summary>
    ///  Gets count of operators in the collection.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Indicates wheather collection is limited to fast text extraction
    ///</summary>
    property IsFastTextExtractionMode: Boolean read get_IsFastTextExtractionMode;
    property Item[index: Int32]: DNOperator read get_Item write set_Item; default;
  end;

  TDNOperatorCollection = class(TDNGenericImport<DNOperatorCollectionClass, DNOperatorCollection>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNBaseParagraphClass = interface(DNObjectClass)
  ['{71434F94-BEA4-51E1-8966-61F56EED039E}']
  end;

  ///<summary>
  ///  Represents a abstract base object can be added to the page(doc.Paragraphs.Add()).
  ///</summary>
  [DNTypeName('Aspose.Pdf.BaseParagraph')]
  DNBaseParagraph = interface(DDN.mscorlib.DNICloneable)
  ['{1F0C92BB-C9EE-3E52-A2D1-CFABCA5CFFEB}']
  { getters & setters } 

    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Clones this instance.
    ///  Virtual method. Always return null.
    ///</summary>
    ///<returns></returns>
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets a vertical alignment of paragraph
    ///</summary>
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    ///<summary>
    ///  Gets or sets a horizontal alignment of paragraph
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets a outer margin for paragraph (for pdf generation)
    ///</summary>
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether this paragraph will be at next column.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether current paragraph remains in the same page along with next paragraph.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    ///<summary>
    ///  Gets or sets a bool value that force this paragraph generates at new page.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    ///<summary>
    ///  Gets or sets a paragraph is inline.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    ///<summary>
    ///  Gets or sets the fragment hyperlink(for pdf generator).
    ///</summary>
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    ///<summary>
    ///  Gets or sets a int value that indicates the Z-order of the graph. A graph with larger ZIndex
    ///  will be placed over the graph with smaller ZIndex. ZIndex can be negative. Graph with negative
    ///  ZIndex will be placed behind the text in the page.
    ///</summary>
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNBaseParagraph = class(TDNGenericImport<DNBaseParagraphClass, DNBaseParagraph>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNAnnotationClass = interface(DNBaseParagraphClass)
  ['{C49F0A2F-4ED8-5F6E-8704-D1976C4383EC}']
  { static getter & setter } 

    {class} function get_UpdateAppearanceOnConvert: Boolean;
    {class} procedure set_UpdateAppearanceOnConvert(value: Boolean);
    {class} function get_UseFontSubset: Boolean;
    {class} procedure set_UseFontSubset(value: Boolean);

  { static propertys } 

    ///<summary>
    ///  If true, annotation appearance will be updated before converting PF document into image. This allows convert fields correctly but probably demand more time.
    ///</summary>
    {class} property UpdateAppearanceOnConvert: Boolean read get_UpdateAppearanceOnConvert write set_UpdateAppearanceOnConvert;
    ///<summary>
    ///  If this property set to true, fonts will be added to document as subsets. Default value is true.
    ///</summary>
    {class} property UseFontSubset: Boolean read get_UseFontSubset write set_UseFontSubset;
  end;

  ///<summary>
  ///  Class representing annotation object.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.Annotation')]
  DNAnnotation = interface(DNBaseParagraph)
  ['{76CC3C2F-FE41-314B-83C1-1EC311F3BF62}']
  { getters & setters } 

    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_AnnotationType: DNAnnotationType;
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Accepts visitor for annotation processing.
    ///</summary>
    ///  <param name="visitor">AnnotationSelector object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    ///<summary>
    ///  Clones this instance.
    ///  Virtual method. Always return null.
    ///</summary>
    ///<returns></returns>
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets list of annotatation actions.
    ///</summary>
    property Actions: DNPdfActionCollection read get_Actions;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    ///<summary>
    ///  Gets or sets a vertical alignment of paragraph
    ///</summary>
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    ///<summary>
    ///  Gets or sets a outer margin for paragraph (for pdf generation)
    ///</summary>
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether this paragraph will be at next column.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether current paragraph remains in the same page along with next paragraph.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    ///<summary>
    ///  Gets or sets a bool value that force this paragraph generates at new page.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    ///<summary>
    ///  Gets or sets a paragraph is inline.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    ///<summary>
    ///  Gets or sets the fragment hyperlink(for pdf generator).
    ///</summary>
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    ///<summary>
    ///  Gets or sets a int value that indicates the Z-order of the graph. A graph with larger ZIndex
    ///  will be placed over the graph with smaller ZIndex. ZIndex can be negative. Graph with negative
    ///  ZIndex will be placed behind the text in the page.
    ///</summary>
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNAnnotation = class(TDNGenericImport<DNAnnotationClass, DNAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNLinkAnnotationClass = interface(DNAnnotationClass)
  ['{28890E0D-6BE8-5284-BE06-F62484470338}']
  { constructors } 

    ///<summary>
    ///  Creates new Link annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNLinkAnnotation;

  end;

  ///<summary>
  ///  Represents either a hypertext link to a destination elsewhere in the document or an action to be performed.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.LinkAnnotation')]
  DNLinkAnnotation = interface(DNAnnotation)
  ['{00D93A63-112F-3FB2-9CB9-81E609CE88C9}']
  { getters & setters } 

    function get_Action: DNPdfAction;
    procedure set_Action(value: DNPdfAction);
    function get_Destination: DNIAppointment;
    procedure set_Destination(value: DNIAppointment);
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  An action to be performed when the link annotation is activated.
    ///</summary>
    property Action: DNPdfAction read get_Action write set_Action;
    ///<summary>
    ///  A destination to be displayed when the annotation is activated.
    ///</summary>
    property Destination: DNIAppointment read get_Destination write set_Destination;
    ///<summary>
    ///  The visual effect to be used when the mouse button is pressed or held down inside its active area.
    ///</summary>
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets list of annotatation actions.
    ///</summary>
    property Actions: DNPdfActionCollection read get_Actions;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNLinkAnnotation = class(TDNGenericImport<DNLinkAnnotationClass, DNLinkAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNMarkupAnnotationClass = interface(DNAnnotationClass)
  ['{35F64032-0843-576A-B54A-55B5B89AF2AD}']
  { constructors } 

    ///<summary>
    ///  Constructor for markup annotation.
    ///</summary>
    ///  <param name="document">Document where annotation will be created.</param>
    {class} function init(document: DNDocument): DNMarkupAnnotation;

  end;

  ///<summary>
  ///  Abstract class representing markup annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.MarkupAnnotation')]
  DNMarkupAnnotation = interface(DNAnnotation)
  ['{D3CB863A-3A70-3F14-98C4-8A46C5B42AA1}']
  { getters & setters } 

    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_AnnotationType: DNAnnotationType;
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Accepts visitor for annotation processing.
    ///</summary>
    ///  <param name="visitor">AnnotationSelector object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets list of annotatation actions.
    ///</summary>
    property Actions: DNPdfActionCollection read get_Actions;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNMarkupAnnotation = class(TDNGenericImport<DNMarkupAnnotationClass, DNMarkupAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNCaretAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{5CF48934-16EE-515D-B2E9-C0E43F0019F0}']
  { constructors } 

    ///<summary>
    ///  Constructor for usign in Generator.
    ///</summary>
    ///  <param name="document">Document where annotation will be created.</param>
    {class} function init(document: DNDocument): DNCaretAnnotation; overload;
    ///<summary>
    ///  Creates new Caret annotation on the specified page.
    ///</summary>
    ///  <param name="page">Document's page where annotation should be created.</param>
    ///  <param name="rect">Required rectangle that sets annotation's border.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNCaretAnnotation; overload;

  end;

  ///<summary>
  ///  Class representing Caret annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.CaretAnnotation')]
  DNCaretAnnotation = interface(DNMarkupAnnotation)
  ['{38B09954-5641-37FD-9C92-35A14F5A90B2}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_Frame: DNPdf_Rectangle;
    procedure set_Frame(value: DNPdf_Rectangle);
    function get_Symbol: DNCaretSymbol;
    procedure set_Symbol(value: DNCaretSymbol);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets caret rectangle.
    ///</summary>
    property Frame: DNPdf_Rectangle read get_Frame write set_Frame;
    ///<summary>
    ///  Gets or sets symbol associated with caret.
    ///</summary>
    ///<see cref="T:Aspose.Pdf.Annotations.CaretSymbol" />
    property Symbol: DNCaretSymbol read get_Symbol write set_Symbol;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNCaretAnnotation = class(TDNGenericImport<DNCaretAnnotationClass, DNCaretAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNCommonFigureAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{F55EA253-0BAB-5127-BC2D-DE2B35182F4A}']
  { constructors } 

    ///<summary>
    ///  Constructor for using in Generator.
    ///</summary>
    ///  <param name="document">Document where annotation will be placed.</param>
    {class} function init(document: DNDocument): DNCommonFigureAnnotation;

  end;

  ///<summary>
  ///  Abstract class representing common figure annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.CommonFigureAnnotation')]
  DNCommonFigureAnnotation = interface(DNMarkupAnnotation)
  ['{6EC34194-60B4-32E4-BEC7-E83C2BC262D7}']
  { getters & setters } 

    function get_InteriorColor: DNColor;
    procedure set_InteriorColor(value: DNColor);
    function get_Frame: DNPdf_Rectangle;
    procedure set_Frame(value: DNPdf_Rectangle);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_AnnotationType: DNAnnotationType;
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Accept(visitor: DNAnnotationSelector);
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Interior color with which to fill the annotation�s rectangle or ellipse.
    ///</summary>
    property InteriorColor: DNColor read get_InteriorColor write set_InteriorColor;
    ///<summary>
    ///  The rectangle describing the numerical differences between two rectangles:
    ///  the Rect entry of the annotation and the actual boundaries of the underlying square or circle.
    ///</summary>
    property Frame: DNPdf_Rectangle read get_Frame write set_Frame;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNCommonFigureAnnotation = class(TDNGenericImport<DNCommonFigureAnnotationClass, DNCommonFigureAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNCircleAnnotationClass = interface(DNCommonFigureAnnotationClass)
  ['{A7F73233-6CC7-56FE-A49D-3B379584A5FB}']
  { constructors } 

    ///<summary>
    ///  Constructor for Circle annotation.
    ///</summary>
    ///  <param name="document">Document where annotation will be created.</param>
    {class} function init(document: DNDocument): DNCircleAnnotation; overload;
    ///<summary>
    ///  Creates new Circle annotation on the specified page.
    ///</summary>
    ///  <param name="page">Document's page where annotation should be created.</param>
    ///  <param name="rect">Required rectangle that sets annotation's border.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNCircleAnnotation; overload;

  end;

  ///<summary>
  ///  Class representing Circle annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.CircleAnnotation')]
  DNCircleAnnotation = interface(DNCommonFigureAnnotation)
  ['{D47C6BBE-CE78-35C0-8359-A3A01C70652F}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_InteriorColor: DNColor;
    procedure set_InteriorColor(value: DNColor);
    function get_Frame: DNPdf_Rectangle;
    procedure set_Frame(value: DNPdf_Rectangle);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Interior color with which to fill the annotation�s rectangle or ellipse.
    ///</summary>
    property InteriorColor: DNColor read get_InteriorColor write set_InteriorColor;
    ///<summary>
    ///  The rectangle describing the numerical differences between two rectangles:
    ///  the Rect entry of the annotation and the actual boundaries of the underlying square or circle.
    ///</summary>
    property Frame: DNPdf_Rectangle read get_Frame write set_Frame;
    property Title: string read get_Title write set_Title;
    property RichText: string read get_RichText write set_RichText;
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    property Subject: string read get_Subject write set_Subject;
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    property Opacity: Double read get_Opacity write set_Opacity;
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNCircleAnnotation = class(TDNGenericImport<DNCircleAnnotationClass, DNCircleAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNSquareAnnotationClass = interface(DNCommonFigureAnnotationClass)
  ['{B2B43D55-ED25-5784-A88D-BB3F860DE633}']
  { constructors } 

    ///<summary>
    ///  Constructor for using with Generator.
    ///</summary>
    ///  <param name="document">Documennt where annotation will be created.</param>
    {class} function init(document: DNDocument): DNSquareAnnotation; overload;
    ///<summary>
    ///  Creates new Square annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNSquareAnnotation; overload;

  end;

  ///<summary>
  ///  Class representing square annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SquareAnnotation')]
  DNSquareAnnotation = interface(DNCommonFigureAnnotation)
  ['{DFB626B0-5F74-3FC2-A815-9934784169C8}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_InteriorColor: DNColor;
    procedure set_InteriorColor(value: DNColor);
    function get_Frame: DNPdf_Rectangle;
    procedure set_Frame(value: DNPdf_Rectangle);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor to process annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Interior color with which to fill the annotation�s rectangle or ellipse.
    ///</summary>
    property InteriorColor: DNColor read get_InteriorColor write set_InteriorColor;
    ///<summary>
    ///  The rectangle describing the numerical differences between two rectangles:
    ///  the Rect entry of the annotation and the actual boundaries of the underlying square or circle.
    ///</summary>
    property Frame: DNPdf_Rectangle read get_Frame write set_Frame;
    property Title: string read get_Title write set_Title;
    property RichText: string read get_RichText write set_RichText;
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    property Subject: string read get_Subject write set_Subject;
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    property Opacity: Double read get_Opacity write set_Opacity;
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNSquareAnnotation = class(TDNGenericImport<DNSquareAnnotationClass, DNSquareAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFileAttachmentAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{CC001A9F-114D-5853-8D9E-89BBD97DDE06}']
  { constructors } 

    ///<summary>
    ///  Creates new FileAttachment annotation on the specified page.
    ///</summary>
    ///  <param name="page">Document's page where annotation should be created.</param>
    ///  <param name="rect">Required rectangle that sets annotation's border.</param>
    ///  <param name="fileSpec">Describes the file that shoud be bound with the annotation.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; fileSpec: DNFileSpecification): DNFileAttachmentAnnotation;

  end;

  ///<summary>
  ///  Class describes file attachment annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FileAttachmentAnnotation')]
  DNFileAttachmentAnnotation = interface(DNMarkupAnnotation)
  ['{7C332EFB-9012-3C6F-8C0A-DC6C2F475E1D}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_File: DNFileSpecification;
    procedure set_File(value: DNFileSpecification);
    function get_Icon: DNFileIcon;
    procedure set_Icon(value: DNFileIcon);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  The specification of the file associated with this annotation.
    ///</summary>
    property &File: DNFileSpecification read get_File write set_File;
    ///<summary>
    ///  Gets or sets icon that shall be used in displaying annotation.
    ///</summary>
    property Icon: DNFileIcon read get_Icon write set_Icon;
    ///<summary>
    ///  Gets or sets icon's opacity from 0 to 1: 0 - completely transparant, 1 - completely opaque.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNFileAttachmentAnnotation = class(TDNGenericImport<DNFileAttachmentAnnotationClass, DNFileAttachmentAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNFreeTextAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{301EC734-292C-5DAB-AC01-144ADE3B3887}']
  { constructors } 

    ///<summary>
    ///  Constructor to use with Generator.
    ///</summary>
    ///  <param name="document">Document where annotation will be created.</param>
    ///  <param name="appearance">Default Appearance</param>
    {class} function init(document: DNDocument; appearance: DNDefaultAppearance): DNFreeTextAnnotation; overload;
    ///<summary>
    ///  Creates new FreeText annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    ///  <param name="appearance">The default appearance to be used in formatting the text.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; appearance: DNDefaultAppearance): DNFreeTextAnnotation; overload;

  end;

  ///<summary>
  ///  Represents a free text annotation that displays text directly on the page. Unlike an ordinary text annotation, a free text annotation has no open or closed state; instead of being displayed in a pop-up window, the text is always visible.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.FreeTextAnnotation')]
  DNFreeTextAnnotation = interface(DNMarkupAnnotation)
  ['{25368158-800D-389E-B4A5-808E320B0605}']
  { getters & setters } 

    function get_StartingStyle: DNLineEnding;
    procedure set_StartingStyle(value: DNLineEnding);
    function get_EndingStyle: DNLineEnding;
    procedure set_EndingStyle(value: DNLineEnding);
    function get_Justification: DNJustification;
    procedure set_Justification(value: DNJustification);
    function get_DefaultAppearance: string;
    procedure set_DefaultAppearance(value: string);
    function get_DefaultAppearanceObject: DNDefaultAppearance;
    function get_Intent: DNFreeTextIntent;
    procedure set_Intent(value: DNFreeTextIntent);
    function get_DefaultStyle: string;
    procedure set_DefaultStyle(value: string);
    function get_TextStyle: DNTextStyle;
    procedure set_TextStyle(value: DNTextStyle);
    function get_Rotate: DNRotation;
    procedure set_Rotate(value: DNRotation);
    function get_AnnotationType: DNAnnotationType;
    function get_Callout: TArray<DNPoint>;
    procedure set_Callout(value: TArray<DNPoint>);
    function get_TextRectangle: DNPdf_Rectangle;
    procedure set_TextRectangle(value: DNPdf_Rectangle);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets line ending style for line ending point.
    ///  OThis property is obsolete, please use EndingStyle.
    ///</summary>
    property StartingStyle: DNLineEnding read get_StartingStyle write set_StartingStyle;
    ///<summary>
    ///  Gets or sets line ending style for line ending point.
    ///</summary>
    property EndingStyle: DNLineEnding read get_EndingStyle write set_EndingStyle;
    ///<summary>
    ///  Gets or set a code specifying the form of quadding (justification) to be used in displaying the annotation�s text.
    ///</summary>
    property Justification: DNJustification read get_Justification write set_Justification;
    ///<summary>
    ///  Gets or sets the default appearance string to be used in formatting the text.
    ///</summary>
    property DefaultAppearance: string read get_DefaultAppearance write set_DefaultAppearance;
    ///<summary>
    ///  Object which represents default appearance of FreeText annotation.
    ///</summary>
    property DefaultAppearanceObject: DNDefaultAppearance read get_DefaultAppearanceObject;
    ///<summary>
    ///  Gets or sets the intent of the free text annotation.
    ///</summary>
    property Intent: DNFreeTextIntent read get_Intent write set_Intent;
    ///<summary>
    ///  Gets or sets a default style string.
    ///</summary>
    property DefaultStyle: string read get_DefaultStyle write set_DefaultStyle;
    ///<summary>
    ///  Gets or sets style of the text in appearance. when text style is changed, text appearance is updated.
    ///</summary>
    property TextStyle: DNTextStyle read get_TextStyle write set_TextStyle;
    ///<summary>
    ///  Angle of annotation rotation.
    ///</summary>
    property Rotate: DNRotation read get_Rotate write set_Rotate;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Array of point specifying callout line.
    ///</summary>
    property Callout: TArray<DNPoint> read get_Callout write set_Callout;
    ///<summary>
    ///  Rectangle describing the numerical differences between two rectangles: the Rect entry of the annotation
    ///  and a rectangle contained within that rectangle. The inner rectangle is where the annotation�s text should be displayed.
    ///</summary>
    property TextRectangle: DNPdf_Rectangle read get_TextRectangle write set_TextRectangle;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNFreeTextAnnotation = class(TDNGenericImport<DNFreeTextAnnotationClass, DNFreeTextAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNInkAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{FFB7A601-1C2C-5641-A8DD-05F368E7DA95}']
  { constructors } 

    {class} function init(document: DNDocument; inkList: DDN.mscorlib.DNIList<TArray<DNPoint>>): DNInkAnnotation; overload;
    ///<summary>
    ///  Creates new Ink annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    ///  <param name="inkList">An array of Point[] arrays, each representing a stroked path.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; inkList: DDN.mscorlib.DNIList): DNInkAnnotation; overload;
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; inkList: DDN.mscorlib.DNIList<TArray<DNPoint>>): DNInkAnnotation; overload;

  end;

  ///<summary>
  ///  Represents a freehand "scribble" composed of one or more disjoint paths.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.InkAnnotation')]
  DNInkAnnotation = interface(DNMarkupAnnotation)
  ['{1813D872-5E71-3158-8135-78E5EAB834BB}']
  { getters & setters } 

    function get_CapStyle: DNCapStyle;
    procedure set_CapStyle(value: DNCapStyle);
    function get_InkList: DDN.mscorlib.DNIList<TArray<DNPoint>>;
    procedure set_InkList(value: DDN.mscorlib.DNIList<TArray<DNPoint>>);
    function get_AnnotationType: DNAnnotationType;
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Style of ink annotation line endings.
    ///</summary>
    property CapStyle: DNCapStyle read get_CapStyle write set_CapStyle;
    ///<summary>
    ///  Gets or sets list of gestures that are independent lines which are represented by Point[] arrays.
    ///</summary>
    property InkList: DDN.mscorlib.DNIList<TArray<DNPoint>> read get_InkList write set_InkList;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNInkAnnotation = class(TDNGenericImport<DNInkAnnotationClass, DNInkAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNLineAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{59C093FF-4A63-5A22-8D53-C477A964437D}']
  { constructors } 

    ///<summary>
    ///  Constructor for using with Generator.
    ///</summary>
    ///  <param name="document">Document where annotation will be created.</param>
    ///  <param name="start">Starting point. </param>
    ///  <param name="end">Ending point. </param>
    {class} function init(document: DNDocument; start: DNPoint; &end: DNPoint): DNLineAnnotation; overload;
    ///<summary>
    ///  Creates new Line annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    ///  <param name="start">A point, specifying the starting coordinate of the line.</param>
    ///  <param name="end">A point, specifying the ending coordinate of the line.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; start: DNPoint; &end: DNPoint): DNLineAnnotation; overload;

  end;

  ///<summary>
  ///  Class representing line annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.LineAnnotation')]
  DNLineAnnotation = interface(DNMarkupAnnotation)
  ['{FB4292C0-E200-33B5-B82E-109EDA22EAF9}']
  { getters & setters } 

    function get_Starting: DNPoint;
    procedure set_Starting(value: DNPoint);
    function get_StartingStyle: DNLineEnding;
    procedure set_StartingStyle(value: DNLineEnding);
    function get_Ending: DNPoint;
    procedure set_Ending(value: DNPoint);
    function get_EndingStyle: DNLineEnding;
    procedure set_EndingStyle(value: DNLineEnding);
    function get_InteriorColor: DNColor;
    procedure set_InteriorColor(value: DNColor);
    function get_LeaderLine: Double;
    procedure set_LeaderLine(value: Double);
    function get_LeaderLineExtension: Double;
    procedure set_LeaderLineExtension(value: Double);
    function get_ShowCaption: Boolean;
    procedure set_ShowCaption(value: Boolean);
    function get_LeaderLineOffset: Double;
    procedure set_LeaderLineOffset(value: Double);
    function get_CaptionOffset: DNPoint;
    procedure set_CaptionOffset(value: DNPoint);
    function get_CaptionPosition: DNCaptionPosition;
    procedure set_CaptionPosition(value: DNCaptionPosition);
    function get_Measure: DNMeasure;
    procedure set_Measure(value: DNMeasure);
    function get_Intent: DNLineIntent;
    procedure set_Intent(value: DNLineIntent);
    function get_AnnotationType: DNAnnotationType;
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor to annotation processing.
    ///</summary>
    ///  <param name="visitor">Visitor object</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets starting point of line.
    ///</summary>
    property Starting: DNPoint read get_Starting write set_Starting;
    ///<summary>
    ///  Gets or sets line ending style for line starting point.
    ///</summary>
    property StartingStyle: DNLineEnding read get_StartingStyle write set_StartingStyle;
    ///<summary>
    ///  Gets or sets line ending point.
    ///</summary>
    property Ending: DNPoint read get_Ending write set_Ending;
    ///<summary>
    ///  Gets or sets ending style for end point of line.
    ///</summary>
    property EndingStyle: DNLineEnding read get_EndingStyle write set_EndingStyle;
    ///<summary>
    ///  Gets or sets interior color of the annotation.
    ///</summary>
    property InteriorColor: DNColor read get_InteriorColor write set_InteriorColor;
    ///<summary>
    ///  Gets or sets leader line length.
    ///</summary>
    property LeaderLine: Double read get_LeaderLine write set_LeaderLine;
    ///<summary>
    ///  Gets or sets length of leader line extension.
    ///</summary>
    property LeaderLineExtension: Double read get_LeaderLineExtension write set_LeaderLineExtension;
    ///<summary>
    ///  Gets or sets boolean flag which determinies is contents must be shown as caption.
    ///</summary>
    property ShowCaption: Boolean read get_ShowCaption write set_ShowCaption;
    ///<summary>
    ///  Gets or sets leader line offset.
    ///</summary>
    property LeaderLineOffset: Double read get_LeaderLineOffset write set_LeaderLineOffset;
    ///<summary>
    ///  Gets or sets caption text offset from its normal position.
    ///</summary>
    property CaptionOffset: DNPoint read get_CaptionOffset write set_CaptionOffset;
    ///<summary>
    ///  Gets or sets annotation caption position.
    ///</summary>
    property CaptionPosition: DNCaptionPosition read get_CaptionPosition write set_CaptionPosition;
    ///<summary>
    ///  Measure units specifed for this annotation.
    ///</summary>
    property Measure: DNMeasure read get_Measure write set_Measure;
    ///<summary>
    ///  Gets or sets the intent of the line annotation.
    ///</summary>
    property Intent: DNLineIntent read get_Intent write set_Intent;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNLineAnnotation = class(TDNGenericImport<DNLineAnnotationClass, DNLineAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPolyAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{8BD2DFD8-4C6F-585F-AE68-4FDD400479B8}']
  end;

  ///<summary>
  ///  Abstract base class for poly- annotations.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PolyAnnotation')]
  DNPolyAnnotation = interface(DNMarkupAnnotation)
  ['{413BC0C8-92B6-37C3-A3EB-0E05D8050031}']
  { getters & setters } 

    function get_Measure: DNMeasure;
    procedure set_Measure(value: DNMeasure);
    function get_Vertices: TArray<DNPoint>;
    procedure set_Vertices(value: TArray<DNPoint>);
    function get_InteriorColor: DNColor;
    procedure set_InteriorColor(value: DNColor);
    function get_StartingStyle: DNLineEnding;
    procedure set_StartingStyle(value: DNLineEnding);
    function get_EndingStyle: DNLineEnding;
    procedure set_EndingStyle(value: DNLineEnding);
    function get_Intent: DNPolyIntent;
    procedure set_Intent(value: DNPolyIntent);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_AnnotationType: DNAnnotationType;
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Accept(visitor: DNAnnotationSelector);
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Measure units specifed for this annotation.
    ///</summary>
    property Measure: DNMeasure read get_Measure write set_Measure;
    ///<summary>
    ///  Gets or sets an array of points representing the horizontal and vertical coordinates of each vertex.
    ///</summary>
    property Vertices: TArray<DNPoint> read get_Vertices write set_Vertices;
    ///<summary>
    ///  Gets or sets the interior color with which to fill the annotation�s line endings.
    ///</summary>
    property InteriorColor: DNColor read get_InteriorColor write set_InteriorColor;
    ///<summary>
    ///  Gets or sets the style of first line ending.
    ///</summary>
    property StartingStyle: DNLineEnding read get_StartingStyle write set_StartingStyle;
    ///<summary>
    ///  Gets or sets the style of second line ending.
    ///</summary>
    property EndingStyle: DNLineEnding read get_EndingStyle write set_EndingStyle;
    ///<summary>
    ///  Gets or sets the intent of the polygon or polyline annotation.
    ///</summary>
    property Intent: DNPolyIntent read get_Intent write set_Intent;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNPolyAnnotation = class(TDNGenericImport<DNPolyAnnotationClass, DNPolyAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPolygonAnnotationClass = interface(DNPolyAnnotationClass)
  ['{EAE5A983-B760-584F-948A-BE1FA14C94E7}']
  { constructors } 

    ///<summary>
    ///  Constructor for using with Generator.
    ///</summary>
    ///  <param name="document">Document where annotation will be added.</param>
    ///  <param name="vertices">Array of points.</param>
    {class} function init(document: DNDocument; vertices: TArray<DNPoint>): DNPolygonAnnotation; overload;
    ///<summary>
    ///  Creates new Polygon annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    ///  <param name="vertices">An array of polygon vertices points.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; vertices: TArray<DNPoint>): DNPolygonAnnotation; overload;

  end;

  ///<summary>
  ///  Class representing polygon annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PolygonAnnotation')]
  DNPolygonAnnotation = interface(DNPolyAnnotation)
  ['{78E47EEC-97FC-335D-A1EF-74AAADAF372C}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_Measure: DNMeasure;
    procedure set_Measure(value: DNMeasure);
    function get_Vertices: TArray<DNPoint>;
    procedure set_Vertices(value: TArray<DNPoint>);
    function get_InteriorColor: DNColor;
    procedure set_InteriorColor(value: DNColor);
    function get_StartingStyle: DNLineEnding;
    procedure set_StartingStyle(value: DNLineEnding);
    function get_EndingStyle: DNLineEnding;
    procedure set_EndingStyle(value: DNLineEnding);
    function get_Intent: DNPolyIntent;
    procedure set_Intent(value: DNPolyIntent);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object for annotation processing.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Measure units specifed for this annotation.
    ///</summary>
    property Measure: DNMeasure read get_Measure write set_Measure;
    ///<summary>
    ///  Gets or sets an array of points representing the horizontal and vertical coordinates of each vertex.
    ///</summary>
    property Vertices: TArray<DNPoint> read get_Vertices write set_Vertices;
    ///<summary>
    ///  Gets or sets the interior color with which to fill the annotation�s line endings.
    ///</summary>
    property InteriorColor: DNColor read get_InteriorColor write set_InteriorColor;
    ///<summary>
    ///  Gets or sets the style of first line ending.
    ///</summary>
    property StartingStyle: DNLineEnding read get_StartingStyle write set_StartingStyle;
    ///<summary>
    ///  Gets or sets the style of second line ending.
    ///</summary>
    property EndingStyle: DNLineEnding read get_EndingStyle write set_EndingStyle;
    ///<summary>
    ///  Gets or sets the intent of the polygon or polyline annotation.
    ///</summary>
    property Intent: DNPolyIntent read get_Intent write set_Intent;
    property Title: string read get_Title write set_Title;
    property RichText: string read get_RichText write set_RichText;
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    property Subject: string read get_Subject write set_Subject;
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    property Opacity: Double read get_Opacity write set_Opacity;
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNPolygonAnnotation = class(TDNGenericImport<DNPolygonAnnotationClass, DNPolygonAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPolylineAnnotationClass = interface(DNPolyAnnotationClass)
  ['{F745A60D-E2B0-5440-9E9B-B4F3CDAF3719}']
  { constructors } 

    ///<summary>
    ///  Creates new Polyline annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    ///  <param name="vertices">An array of polygon vertices points.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; vertices: TArray<DNPoint>): DNPolylineAnnotation;

  end;

  ///<summary>
  ///  Represents polyline annotation that is similar to polygon, except that the first and last vertex are not implicitly connected.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PolylineAnnotation')]
  DNPolylineAnnotation = interface(DNPolyAnnotation)
  ['{D609291D-E29A-3475-B45E-E0132500E237}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_Measure: DNMeasure;
    procedure set_Measure(value: DNMeasure);
    function get_Vertices: TArray<DNPoint>;
    procedure set_Vertices(value: TArray<DNPoint>);
    function get_InteriorColor: DNColor;
    procedure set_InteriorColor(value: DNColor);
    function get_StartingStyle: DNLineEnding;
    procedure set_StartingStyle(value: DNLineEnding);
    function get_EndingStyle: DNLineEnding;
    procedure set_EndingStyle(value: DNLineEnding);
    function get_Intent: DNPolyIntent;
    procedure set_Intent(value: DNPolyIntent);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Measure units specifed for this annotation.
    ///</summary>
    property Measure: DNMeasure read get_Measure write set_Measure;
    ///<summary>
    ///  Gets or sets an array of points representing the horizontal and vertical coordinates of each vertex.
    ///</summary>
    property Vertices: TArray<DNPoint> read get_Vertices write set_Vertices;
    ///<summary>
    ///  Gets or sets the interior color with which to fill the annotation�s line endings.
    ///</summary>
    property InteriorColor: DNColor read get_InteriorColor write set_InteriorColor;
    ///<summary>
    ///  Gets or sets the style of first line ending.
    ///</summary>
    property StartingStyle: DNLineEnding read get_StartingStyle write set_StartingStyle;
    ///<summary>
    ///  Gets or sets the style of second line ending.
    ///</summary>
    property EndingStyle: DNLineEnding read get_EndingStyle write set_EndingStyle;
    ///<summary>
    ///  Gets or sets the intent of the polygon or polyline annotation.
    ///</summary>
    property Intent: DNPolyIntent read get_Intent write set_Intent;
    property Title: string read get_Title write set_Title;
    property RichText: string read get_RichText write set_RichText;
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    property Subject: string read get_Subject write set_Subject;
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    property Opacity: Double read get_Opacity write set_Opacity;
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNPolylineAnnotation = class(TDNGenericImport<DNPolylineAnnotationClass, DNPolylineAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNRedactionAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{2C07719E-130B-5B9C-819F-85089FF8865B}']
  { constructors } 

    ///<summary>
    ///  Constructor for RedactionAnnotation. For using in Generator.
    ///</summary>
    ///  <param name="document">Document where new annotation will be created.</param>
    {class} function init(document: DNDocument): DNRedactionAnnotation; overload;
    ///<summary>
    ///  Constructor for RedactAnnotation.
    ///</summary>
    ///  <param name="page">Page where annotation will be placed.</param>
    ///  <param name="rect">Annotation position on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNRedactionAnnotation; overload;

  end;

  ///<summary>
  ///  Represents Redact annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.RedactionAnnotation')]
  DNRedactionAnnotation = interface(DNMarkupAnnotation)
  ['{3F6BD7F2-4BC3-3040-99DB-BA3A71CD6014}']
  { getters & setters } 

    function get_QuadPoint: TArray<DNPoint>;
    procedure set_QuadPoint(value: TArray<DNPoint>);
    function get_DefaultAppearance: string;
    procedure set_DefaultAppearance(value: string);
    function get_FillColor: DNColor;
    procedure set_FillColor(value: DNColor);
    function get_BorderColor: DNColor;
    procedure set_BorderColor(value: DNColor);
    function get_OverlayText: string;
    procedure set_OverlayText(value: string);
    function get_Repeat: Boolean;
    procedure set_Repeat(value: Boolean);
    function get_TextAlignment: DNHorizontalAlignment;
    procedure set_TextAlignment(value: DNHorizontalAlignment);
    function get_AnnotationType: DNAnnotationType;
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Flattens annotation i.e. removes annotation and adds its
    ///</summary>
    procedure Flatten;
    ///<summary>
    ///  Flattens annotation and redacts page contents (i.e. removes text and image under redacted annotation)
    ///</summary>
    procedure Redact;
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  An array of 8xN numbers specifying the coordinates of content region that is intended to be removed.
    ///</summary>
    property QuadPoint: TArray<DNPoint> read get_QuadPoint write set_QuadPoint;
    ///<summary>
    ///  Gets or sets the default appearance string to be used in formatting the text.
    ///</summary>
    property DefaultAppearance: string read get_DefaultAppearance write set_DefaultAppearance;
    ///<summary>
    ///  Gets or sets color to fill annotation.
    ///</summary>
    property FillColor: DNColor read get_FillColor write set_FillColor;
    ///<summary>
    ///  Gets or sets color of border which is drawn when redaction is not active.
    ///</summary>
    property BorderColor: DNColor read get_BorderColor write set_BorderColor;
    ///<summary>
    ///  Text to print on redact annotation.
    ///</summary>
    property OverlayText: string read get_OverlayText write set_OverlayText;
    ///<summary>
    ///  If true overlay text will be repated on the annotation.
    ///</summary>
    property &Repeat: Boolean read get_Repeat write set_Repeat;
    ///<summary>
    ///  Gets or sets. Alignment of Overlay Text.
    ///</summary>
    property TextAlignment: DNHorizontalAlignment read get_TextAlignment write set_TextAlignment;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNRedactionAnnotation = class(TDNGenericImport<DNRedactionAnnotationClass, DNRedactionAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNSoundAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{0C3360DD-22D4-540F-BB1C-D00ADE6EC5BA}']
  { constructors } 

    ///<summary>
    ///  Creates new Sound annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    ///  <param name="soundFile">A sound file defining the sound to be played when the annotation is activated.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; soundFile: string): DNSoundAnnotation; overload;
    ///<summary>
    ///  Creates new Sound annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    ///  <param name="soundFile">A sound file defining the sound to be played when the annotation is activated.</param>
    ///  <param name="soundSampleData">A sound sample data contains extra of sound parameters such as sampling rate, bits per sample and so on.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; soundFile: string; soundSampleData: DNSoundSampleData): DNSoundAnnotation; overload;

  end;

  ///<summary>
  ///  Represents a sound annotation that contains sound recorded from the computer�s microphone or imported from a file.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SoundAnnotation')]
  DNSoundAnnotation = interface(DNMarkupAnnotation)
  ['{5135EAF6-DE99-3FC2-A7CE-F76823D2AF91}']
  { getters & setters } 

    function get_Icon: DNSoundIcon;
    procedure set_Icon(value: DNSoundIcon);
    function get_SoundData: DNSoundData;
    function get_AnnotationType: DNAnnotationType;
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets an icon to be used in displaying the annotation.
    ///</summary>
    property Icon: DNSoundIcon read get_Icon write set_Icon;
    ///<summary>
    ///  Gets a sound object defining the sound to be played when the annotation is activated.
    ///</summary>
    property SoundData: DNSoundData read get_SoundData;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNSoundAnnotation = class(TDNGenericImport<DNSoundAnnotationClass, DNSoundAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNStampAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{953F975F-1996-5D51-AB0D-7A7CB798C7F4}']
  { constructors } 

    ///<summary>
    ///  Constructor
    ///</summary>
    ///  <param name="document">Document where annotation will be created.</param>
    {class} function init(document: DNDocument): DNStampAnnotation; overload;
    ///<summary>
    ///  Creates new Stamp annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNStampAnnotation; overload;

  end;

  ///<summary>
  ///  Represents rubber stamp annotation.
  ///  This type of annotation displays text or graphics intended to look as if they were stamped on the page with a rubber stamp.
  ///</summary>
  ///<example>
  ///  Next code snippet demonstrates how to add 2 stamps into the first pdf document page.
  ///  Input document comes from inFile and changes are saved into the outFile.
  ///  The first stamp has icon NotForPublicRelease and the second comes with image from rubber.jpg.
  ///<code lang="C#">
  ///  Document document = new Document(inFile);
  ///  StampAnnotation stamp1 = new StampAnnotation(StampIcon.NotForPublicRelease);
  ///  stamp1.Rect = new Rectangle(100, 100, 120, 120)
  ///  document.Pages[1].Annotations.Add(stamp1);
  ///  StampAnnotation stamp2 = new StampAnnotation(new FileStream("rubber.jpg", FileMode.Open));
  ///  stamp2.Rect = new Rectangle(200, 200, 220, 220)
  ///  document.Pages[1].Annotations.Add(stamp2);
  ///  document.Save(outFile);
  ///</code></example>
  [DNTypeName('Aspose.Pdf.Annotations.StampAnnotation')]
  DNStampAnnotation = interface(DNMarkupAnnotation)
  ['{D5A0EC51-7DAD-3D2A-988E-AFFE13F7C6F5}']
  { getters & setters } 

    function get_Icon: DNStampIcon;
    procedure set_Icon(value: DNStampIcon);
    function get_AnnotationType: DNAnnotationType;
    function get_Image: DDN.mscorlib.DNStream;
    procedure set_Image(value: DDN.mscorlib.DNStream);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Acepts <see cref="T:Aspose.Pdf.Annotations.AnnotationSelector" />
    ///  visitor when browsing annotation collection.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets icon for rubber stamp.
    ///</summary>
    property Icon: DNStampIcon read get_Icon write set_Icon;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets image of the annotation.
    ///</summary>
    property Image: DDN.mscorlib.DNStream read get_Image write set_Image;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNStampAnnotation = class(TDNGenericImport<DNStampAnnotationClass, DNStampAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNTextAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{45D971AD-28A4-5F1A-8DAC-874732D2035B}']
  { constructors } 

    ///<summary>
    ///  Constructor for annotation when used in Generator.
    ///</summary>
    ///  <param name="document">Document where text annotation will be created.</param>
    {class} function init(document: DNDocument): DNTextAnnotation; overload;
    ///<summary>
    ///  Creates new Text annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNTextAnnotation; overload;

  end;

  ///<summary>
  ///  Represents a text annotation that is a �sticky note� attached to a point in the PDF document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.TextAnnotation')]
  DNTextAnnotation = interface(DNMarkupAnnotation)
  ['{52187D7B-66A2-39B5-B359-6797D2C61BF8}']
  { getters & setters } 

    function get_Open: Boolean;
    procedure set_Open(value: Boolean);
    function get_Icon: DNTextIcon;
    procedure set_Icon(value: DNTextIcon);
    function get_State: DNAnnotationState;
    procedure set_State(value: DNAnnotationState);
    function get_AnnotationType: DNAnnotationType;
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets a flag specifying whether the annotation should initially be displayed open.
    ///</summary>
    property Open: Boolean read get_Open write set_Open;
    ///<summary>
    ///  Gets or sets an icon to be used in displaying the annotation.
    ///</summary>
    property Icon: DNTextIcon read get_Icon write set_Icon;
    ///<summary>
    ///  Gets or sets the state to which the original annotation should be set.
    ///</summary>
    property State: DNAnnotationState read get_State write set_State;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNTextAnnotation = class(TDNGenericImport<DNTextAnnotationClass, DNTextAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNTextMarkupAnnotationClass = interface(DNMarkupAnnotationClass)
  ['{023F4DBE-58BE-587B-A21B-4E8F6FF5DA2F}']
  end;

  ///<summary>
  ///  Abstract base class for text markup annotations.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.TextMarkupAnnotation')]
  DNTextMarkupAnnotation = interface(DNMarkupAnnotation)
  ['{366868D8-303B-3670-B90C-B7073AD4DBCD}']
  { getters & setters } 

    function get_QuadPoints: TArray<DNPoint>;
    procedure set_QuadPoints(value: TArray<DNPoint>);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_AnnotationType: DNAnnotationType;
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Gets text under markup annotation as string.
    ///</summary>
    ///<returns>String containing text that is under markup annotation.</returns>
    function GetMarkedText: string;
    ///<summary>
    ///  Gets text under markup annotation as <see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  .
    ///</summary>
    ///<returns><see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  containing <see cref="T:Aspose.Pdf.Text.TextFragment" />
    ///  s that is under markup annotation.</returns>
    function GetMarkedTextFragments: DNTextFragmentCollection;
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Accept(visitor: DNAnnotationSelector);
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets an array of points specifying the coordinates of n quadrilaterals. Each quadrilateral encompasses a word or group of contiguous words in the text underlying the annotation.
    ///</summary>
    property QuadPoints: TArray<DNPoint> read get_QuadPoints write set_QuadPoints;
    ///<summary>
    ///  Gets or sets a text that shall be displayed in title bar of annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a rich text string to be displayed in the pop-up window when the annotation is opened.
    ///</summary>
    property RichText: string read get_RichText write set_RichText;
    ///<summary>
    ///  Gets date and time when annotation was created.
    ///</summary>
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    ///<summary>
    ///  Gets text representing desciption of the object.
    ///</summary>
    property Subject: string read get_Subject write set_Subject;
    ///<summary>
    ///  Pop-up annotation for entering or editing the text associated with this annotation.
    ///</summary>
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    ///<summary>
    ///  Gets or sets the constant opacity value to be used in painting the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  A reference to the annotation that this annotation is "in reply to".
    ///  Both annotations must be on the same page of the document.
    ///</summary>
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    ///<summary>
    ///  A string specifying the relationship (the "reply type") between this annotation
    ///  and one specified by InReplyTo.
    ///</summary>
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNTextMarkupAnnotation = class(TDNGenericImport<DNTextMarkupAnnotationClass, DNTextMarkupAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNHighlightAnnotationClass = interface(DNTextMarkupAnnotationClass)
  ['{9A35BED5-852A-5140-ABE6-0C37CB3007C9}']
  { constructors } 

    ///<summary>
    ///  Creates new Highlight annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNHighlightAnnotation;

  end;

  ///<summary>
  ///  Represents a highlight annotation that highlights a range of text in the document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.HighlightAnnotation')]
  DNHighlightAnnotation = interface(DNTextMarkupAnnotation)
  ['{42EE240E-0652-3692-9D41-BD506681D580}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_QuadPoints: TArray<DNPoint>;
    procedure set_QuadPoints(value: TArray<DNPoint>);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Gets text under markup annotation as string.
    ///</summary>
    ///<returns>String containing text that is under markup annotation.</returns>
    function GetMarkedText: string;
    ///<summary>
    ///  Gets text under markup annotation as <see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  .
    ///</summary>
    ///<returns><see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  containing <see cref="T:Aspose.Pdf.Text.TextFragment" />
    ///  s that is under markup annotation.</returns>
    function GetMarkedTextFragments: DNTextFragmentCollection;
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets an array of points specifying the coordinates of n quadrilaterals. Each quadrilateral encompasses a word or group of contiguous words in the text underlying the annotation.
    ///</summary>
    property QuadPoints: TArray<DNPoint> read get_QuadPoints write set_QuadPoints;
    property Title: string read get_Title write set_Title;
    property RichText: string read get_RichText write set_RichText;
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    property Subject: string read get_Subject write set_Subject;
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    property Opacity: Double read get_Opacity write set_Opacity;
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNHighlightAnnotation = class(TDNGenericImport<DNHighlightAnnotationClass, DNHighlightAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNSquigglyAnnotationClass = interface(DNTextMarkupAnnotationClass)
  ['{AC284DF8-F007-588D-A427-13471F31B9C0}']
  { constructors } 

    ///<summary>
    ///  Creates new Squiggly annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNSquigglyAnnotation;

  end;

  ///<summary>
  ///  Represents the squiggly annotation that appears as a jagged underline in the text of a document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.SquigglyAnnotation')]
  DNSquigglyAnnotation = interface(DNTextMarkupAnnotation)
  ['{A9B00E99-51A0-3A3E-9152-EB0A109FDDE6}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_QuadPoints: TArray<DNPoint>;
    procedure set_QuadPoints(value: TArray<DNPoint>);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Gets text under markup annotation as string.
    ///</summary>
    ///<returns>String containing text that is under markup annotation.</returns>
    function GetMarkedText: string;
    ///<summary>
    ///  Gets text under markup annotation as <see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  .
    ///</summary>
    ///<returns><see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  containing <see cref="T:Aspose.Pdf.Text.TextFragment" />
    ///  s that is under markup annotation.</returns>
    function GetMarkedTextFragments: DNTextFragmentCollection;
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets an array of points specifying the coordinates of n quadrilaterals. Each quadrilateral encompasses a word or group of contiguous words in the text underlying the annotation.
    ///</summary>
    property QuadPoints: TArray<DNPoint> read get_QuadPoints write set_QuadPoints;
    property Title: string read get_Title write set_Title;
    property RichText: string read get_RichText write set_RichText;
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    property Subject: string read get_Subject write set_Subject;
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    property Opacity: Double read get_Opacity write set_Opacity;
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNSquigglyAnnotation = class(TDNGenericImport<DNSquigglyAnnotationClass, DNSquigglyAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNStrikeOutAnnotationClass = interface(DNTextMarkupAnnotationClass)
  ['{6DD94AB6-6D86-562C-ABCF-62420629491B}']
  { constructors } 

    ///<summary>
    ///  Creates new StrikeOut annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNStrikeOutAnnotation;

  end;

  ///<summary>
  ///  Represents a strikeout annotation that appears as a strikeout in the text of the document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.StrikeOutAnnotation')]
  DNStrikeOutAnnotation = interface(DNTextMarkupAnnotation)
  ['{95E794B5-1602-3E2A-A52D-F6F0B00EBAAA}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_QuadPoints: TArray<DNPoint>;
    procedure set_QuadPoints(value: TArray<DNPoint>);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Gets text under markup annotation as string.
    ///</summary>
    ///<returns>String containing text that is under markup annotation.</returns>
    function GetMarkedText: string;
    ///<summary>
    ///  Gets text under markup annotation as <see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  .
    ///</summary>
    ///<returns><see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  containing <see cref="T:Aspose.Pdf.Text.TextFragment" />
    ///  s that is under markup annotation.</returns>
    function GetMarkedTextFragments: DNTextFragmentCollection;
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets an array of points specifying the coordinates of n quadrilaterals. Each quadrilateral encompasses a word or group of contiguous words in the text underlying the annotation.
    ///</summary>
    property QuadPoints: TArray<DNPoint> read get_QuadPoints write set_QuadPoints;
    property Title: string read get_Title write set_Title;
    property RichText: string read get_RichText write set_RichText;
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    property Subject: string read get_Subject write set_Subject;
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    property Opacity: Double read get_Opacity write set_Opacity;
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNStrikeOutAnnotation = class(TDNGenericImport<DNStrikeOutAnnotationClass, DNStrikeOutAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNUnderlineAnnotationClass = interface(DNTextMarkupAnnotationClass)
  ['{74E92D58-FF3E-5BE2-9A6F-42ED58B0B1B5}']
  { constructors } 

    ///<summary>
    ///  Creates new Underline annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNUnderlineAnnotation;

  end;

  ///<summary>
  ///  Represents an underline annotation that appears as an underline in the text of the document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.UnderlineAnnotation')]
  DNUnderlineAnnotation = interface(DNTextMarkupAnnotation)
  ['{197E31C5-50F2-3139-9443-0CEAA68D7383}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_QuadPoints: TArray<DNPoint>;
    procedure set_QuadPoints(value: TArray<DNPoint>);
    function get_Title: string;
    procedure set_Title(value: string);
    function get_RichText: string;
    procedure set_RichText(value: string);
    function get_CreationDate: DDN.mscorlib.DNDateTime;
    function get_Subject: string;
    procedure set_Subject(value: string);
    function get_Popup: DNPopupAnnotation;
    procedure set_Popup(value: DNPopupAnnotation);
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_InReplyTo: DNAnnotation;
    procedure set_InReplyTo(value: DNAnnotation);
    function get_ReplyType: DNReplyType;
    procedure set_ReplyType(value: DNReplyType);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Gets text under markup annotation as string.
    ///</summary>
    ///<returns>String containing text that is under markup annotation.</returns>
    function GetMarkedText: string;
    ///<summary>
    ///  Gets text under markup annotation as <see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  .
    ///</summary>
    ///<returns><see cref="T:Aspose.Pdf.Text.TextFragmentCollection" />
    ///  containing <see cref="T:Aspose.Pdf.Text.TextFragment" />
    ///  s that is under markup annotation.</returns>
    function GetMarkedTextFragments: DNTextFragmentCollection;
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets an array of points specifying the coordinates of n quadrilaterals. Each quadrilateral encompasses a word or group of contiguous words in the text underlying the annotation.
    ///</summary>
    property QuadPoints: TArray<DNPoint> read get_QuadPoints write set_QuadPoints;
    property Title: string read get_Title write set_Title;
    property RichText: string read get_RichText write set_RichText;
    property CreationDate: DDN.mscorlib.DNDateTime read get_CreationDate;
    property Subject: string read get_Subject write set_Subject;
    property Popup: DNPopupAnnotation read get_Popup write set_Popup;
    property Opacity: Double read get_Opacity write set_Opacity;
    property InReplyTo: DNAnnotation read get_InReplyTo write set_InReplyTo;
    property ReplyType: DNReplyType read get_ReplyType write set_ReplyType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Actions: DNPdfActionCollection read get_Actions;
    property Height: Double read get_Height write set_Height;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNUnderlineAnnotation = class(TDNGenericImport<DNUnderlineAnnotationClass, DNUnderlineAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNMovieAnnotationClass = interface(DNAnnotationClass)
  ['{CE02F63C-A23F-51D6-AB67-F3CFE510901B}']
  { constructors } 

    ///<summary>
    ///  Constructor for using with Generator.
    ///</summary>
    ///  <param name="document">Document where movie annotation will be created.</param>
    ///  <param name="movieFile">Name of movie file. </param>
    {class} function init(document: DNDocument; movieFile: string): DNMovieAnnotation; overload;
    ///<summary>
    ///  Creates new Sound annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    ///  <param name="movieFile">A movie file to be played when the annotation is activated.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; movieFile: string): DNMovieAnnotation; overload;

  end;

  ///<summary>
  ///  Represents a movie annotation that contains animated graphics and sound to be presented on the computer screen and through the speakers. When the annotation is activated, the movie is played.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.MovieAnnotation')]
  DNMovieAnnotation = interface(DNAnnotation)
  ['{1B50D90F-5158-3BD4-9221-8FF1D7EE2A96}']
  { getters & setters } 

    function get_Title: string;
    procedure set_Title(value: string);
    function get_File: DNFileSpecification;
    procedure set_File(value: DNFileSpecification);
    function get_Poster: Boolean;
    procedure set_Poster(value: Boolean);
    function get_Aspect: DNPoint;
    procedure set_Aspect(value: DNPoint);
    function get_Rotate: Int32;
    procedure set_Rotate(value: Int32);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the title of the movie annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a file specification identifying a self-describing movie file.
    ///</summary>
    property &File: DNFileSpecification read get_File write set_File;
    ///<summary>
    ///  Gets or sets a flag or stream specifying whether and how a poster image representing the movie shall be displayed. If true, the poster image shall be retrieved from the movie file; if it is false, no poster shall be displayed.
    ///</summary>
    property Poster: Boolean read get_Poster write set_Poster;
    ///<summary>
    ///  Gets or sets the width and height of the movie�s bounding box, in pixels.
    ///</summary>
    property Aspect: DNPoint read get_Aspect write set_Aspect;
    ///<summary>
    ///  Gets or sets the number of degrees by which the movie shall be rotated clockwise relative to the page. The value shall be a multiple of 90.
    ///</summary>
    property Rotate: Int32 read get_Rotate write set_Rotate;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets list of annotatation actions.
    ///</summary>
    property Actions: DNPdfActionCollection read get_Actions;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNMovieAnnotation = class(TDNGenericImport<DNMovieAnnotationClass, DNMovieAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPDF3DAnnotationClass = interface(DNAnnotationClass)
  ['{9A4B3703-DB4B-58E2-A1A6-A693C757293E}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DAnnotation" />
    ///  class.
    ///</summary>
    ///  <param name="page">The page.</param>
    ///  <param name="rect">The rectangle.</param>
    ///  <param name="pdf3DArtwork">The 3D Artwork.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; pdf3DArtwork: DNPDF3DArtwork): DNPDF3DAnnotation; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Annotations.PDF3DAnnotation" />
    ///  class.
    ///</summary>
    ///  <param name="page">The page.</param>
    ///  <param name="rect">The rectangle.</param>
    ///  <param name="pdf3DArtwork">The 3D Artwork.</param>
    ///  <param name="activation">The activation mode.</param>
    ///<exception cref="T:System.Exception">3D Stream is already added to current 3D Artwork</exception>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; pdf3DArtwork: DNPDF3DArtwork; activation: DNPDF3DActivation): DNPDF3DAnnotation; overload;

  end;

  ///<summary>
  ///  Class PDF3DAnnotation. This class cannot be inherited.
  ///</summary>
  ///<seealso cref="T:Aspose.Pdf.Annotations.Annotation" />
  [DNTypeName('Aspose.Pdf.Annotations.PDF3DAnnotation')]
  DNPDF3DAnnotation = interface(DNAnnotation)
  ['{DC780085-F5F5-3C08-A935-5707864641D0}']
  { getters & setters } 

    function get_Pdf3DArtwork: DNPDF3DArtwork;
    function get_LightingScheme: DNPDF3DLightingScheme;
    function get_Content: DNPDF3DContent;
    procedure set_Content(value: DNPDF3DContent);
    function get_RenderMode: DNPDF3DRenderMode;
    function get_ViewArray: DNPDF3DViewArray;
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Sets the index of the default view.
    ///</summary>
    ///  <param name="index">The default view index.</param>
    procedure SetDefaultViewIndex(index: Int32);
    ///<summary>
    ///  Accepts visitor for annotation processing.
    ///</summary>
    ///  <param name="visitor">AnnotationSelector object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Sets the image preview.
    ///</summary>
    ///  <param name="filename">The image preview filename.</param>
    procedure SetImagePreview(filename: string); overload;
    ///<summary>
    ///  Sets the image preview.
    ///</summary>
    ///  <param name="image">The image stream.</param>
    procedure SetImagePreview(image: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Clears the image preview.
    ///</summary>
    procedure ClearImagePreview;
    ///<summary>
    ///  Gets the image preview.
    ///</summary>
    ///<returns>Image preview as stream.</returns>
    function GetImagePreview: DDN.mscorlib.DNStream;
    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the 3D Artwork.
    ///</summary>
    ///<value>The PDF3 d artwork.</value>
    property Pdf3DArtwork: DNPDF3DArtwork read get_Pdf3DArtwork;
    ///<summary>
    ///  Gets the lighting scheme.
    ///</summary>
    ///<value>The lighting scheme.</value>
    property LightingScheme: DNPDF3DLightingScheme read get_LightingScheme;
    ///<summary>
    ///  Gets or sets the content.
    ///</summary>
    ///<value>The content.</value>
    property Content: DNPDF3DContent read get_Content write set_Content;
    ///<summary>
    ///  Gets the render mode.
    ///</summary>
    ///<value>The render mode.</value>
    property RenderMode: DNPDF3DRenderMode read get_RenderMode;
    ///<summary>
    ///  Gets the view array.
    ///</summary>
    ///<value>The view array.</value>
    property ViewArray: DNPDF3DViewArray read get_ViewArray;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    ///<value>The type of the annotation.</value>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets list of annotatation actions.
    ///</summary>
    property Actions: DNPdfActionCollection read get_Actions;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNPDF3DAnnotation = class(TDNGenericImport<DNPDF3DAnnotationClass, DNPDF3DAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNPopupAnnotationClass = interface(DNAnnotationClass)
  ['{FD11DBE0-8CC6-58A0-859F-0635C69C9D03}']
  { constructors } 

    ///<summary>
    ///  Constructor. for using in Generator.
    ///</summary>
    ///  <param name="document">Document where new popup annotation will be created.</param>
    {class} function init(document: DNDocument): DNPopupAnnotation; overload;
    ///<summary>
    ///  Creates new Popup annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNPopupAnnotation; overload;

  end;

  ///<summary>
  ///  Represents the pop-up annotation that displays text in a pop-up window for entry and editing.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.PopupAnnotation')]
  DNPopupAnnotation = interface(DNAnnotation)
  ['{A1C585C8-1A6B-3C56-96FC-A4827A9DA782}']
  { getters & setters } 

    function get_Open: Boolean;
    procedure set_Open(value: Boolean);
    function get_Parent: DNAnnotation;
    procedure set_Parent(value: DNAnnotation);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets a flag specifying whether the pop-up annotation should initially be displayed open.
    ///</summary>
    property Open: Boolean read get_Open write set_Open;
    ///<summary>
    ///  Gets or sets the parent annotation with which this pop-up annotation shall be associated.
    ///  If this entry is present, the parent annotation�s Contents, M, C, and T entries shall override those of the pop-up annotation itself.
    ///</summary>
    property Parent: DNAnnotation read get_Parent write set_Parent;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets list of annotatation actions.
    ///</summary>
    property Actions: DNPdfActionCollection read get_Actions;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNPopupAnnotation = class(TDNGenericImport<DNPopupAnnotationClass, DNPopupAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNRichMediaAnnotationClass = interface(DNAnnotationClass)
  ['{E6D1C60F-5607-537E-9DF5-73D185153517}']
  { constructors } 

    ///<summary>
    ///  Constructor.
    ///</summary>
    ///  <param name="page">The page with which the annotation will be associated.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNRichMediaAnnotation;

  end;

  ///<summary>
  ///  Class describes RichMediaAnnotation which allows embed video/audio data into PDF document.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.RichMediaAnnotation')]
  DNRichMediaAnnotation = interface(DNAnnotation)
  ['{C64F8A13-45D2-3997-BABC-DCCDC974D34A}']
  { getters & setters } 

    function get_AnnotationType: DNAnnotationType;
    function get_CustomPlayer: DDN.mscorlib.DNStream;
    procedure set_CustomPlayer(value: DDN.mscorlib.DNStream);
    function get_CustomFlashVariables: string;
    procedure set_CustomFlashVariables(value: string);
    function get_Content: DDN.mscorlib.DNStream;
    function get_Type: DNRichMediaAnnotation_ContentType;
    procedure set_Type(value: DNRichMediaAnnotation_ContentType);
    function get_ActivateOn: DNRichMediaAnnotation_ActivationEvent;
    procedure set_ActivateOn(value: DNRichMediaAnnotation_ActivationEvent);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor for this annotation.
    ///</summary>
    ///  <param name="visitor">Visitor instance.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Add custom named data (for example required for flash script).
    ///</summary>
    ///  <param name="name">Name of the data.</param>
    ///  <param name="data">Data.</param>
    procedure AddCustomData(name: string; data: DDN.mscorlib.DNStream);
    ///<summary>
    ///  Set content stream.
    ///</summary>
    ///  <param name="fileName">Name of the stream.</param>
    ///  <param name="audio">Data stream.</param>
    procedure SetContent(fileName: string; audio: DDN.mscorlib.DNStream);
    ///<summary>
    ///  Set poster of the annotation.
    ///</summary>
    ///  <param name="imageStream">Stream containing poster image.</param>
    procedure SetPoster(imageStream: DDN.mscorlib.DNStream);
    ///<summary>
    ///  Updates data with specified parameters.
    ///</summary>
    procedure Update;
    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Sets or gets custom flash player to play video/audio data.
    ///</summary>
    property CustomPlayer: DDN.mscorlib.DNStream read get_CustomPlayer write set_CustomPlayer;
    ///<summary>
    ///  Sets or gets flash variables which passed to player.
    ///</summary>
    property CustomFlashVariables: string read get_CustomFlashVariables write set_CustomFlashVariables;
    ///<summary>
    ///  Data of the Rich Media content.
    ///</summary>
    property Content: DDN.mscorlib.DNStream read get_Content;
    ///<summary>
    ///  Gets or sets type of content. Possible values: Audio, Video.
    ///</summary>
    property &Type: DNRichMediaAnnotation_ContentType read get_Type write set_Type;
    ///<summary>
    ///  Event which activates application.
    ///</summary>
    property ActivateOn: DNRichMediaAnnotation_ActivationEvent read get_ActivateOn write set_ActivateOn;
    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets list of annotatation actions.
    ///</summary>
    property Actions: DNPdfActionCollection read get_Actions;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNRichMediaAnnotation = class(TDNGenericImport<DNRichMediaAnnotationClass, DNRichMediaAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNScreenAnnotationClass = interface(DNAnnotationClass)
  ['{8FA8E7C2-55FA-5169-B547-A70760573EA7}']
  { constructors } 

    ///<summary>
    ///  Creates new Screen annotation on the specified page.
    ///</summary>
    ///  <param name="page">The document's page where annotation should be created.</param>
    ///  <param name="rect">The annotation rectangle, defining the location of the annotation on the page.</param>
    ///  <param name="mediaFile">The path to multimedia file.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle; mediaFile: string): DNScreenAnnotation;

  end;

  ///<summary>
  ///  A screen annotation that specifies a region of a page upon which media clips may be played.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.ScreenAnnotation')]
  DNScreenAnnotation = interface(DNAnnotation)
  ['{A8F1DF08-C487-337A-A6AB-1962C683B953}']
  { getters & setters } 

    function get_Title: string;
    procedure set_Title(value: string);
    function get_Action: DNPdfAction;
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor object to process the annotation.
    ///</summary>
    ///  <param name="visitor">Visitor object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the title of the screen annotation.
    ///</summary>
    property Title: string read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets an action to be performed when the annotation is activated.
    ///</summary>
    property Action: DNPdfAction read get_Action;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets list of annotatation actions.
    ///</summary>
    property Actions: DNPdfActionCollection read get_Actions;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNScreenAnnotation = class(TDNGenericImport<DNScreenAnnotationClass, DNScreenAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNWatermarkAnnotationClass = interface(DNAnnotationClass)
  ['{51991EF8-AC83-5150-80B1-284FED95E5AD}']
  { constructors } 

    ///<summary>
    ///  Constuctore for Watermark annotation class.
    ///</summary>
    ///  <param name="page">Page where annotation should be placed.</param>
    ///  <param name="rect">Position of the annotation.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNWatermarkAnnotation;

  end;

  ///<summary>
  ///  Class representing annotation object.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.WatermarkAnnotation')]
  DNWatermarkAnnotation = interface(DNAnnotation)
  ['{C2166FD4-8C85-36DD-9BE1-DB107BA2DA18}']
  { getters & setters } 

    function get_FixedPrint: DNFixedPrint;
    function get_AnnotationType: DNAnnotationType;
    function get_Opacity: Double;
    procedure set_Opacity(value: Double);
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Actions: DNPdfActionCollection;
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Set text of the annotation.
    ///</summary>
    ///  <param name="text"></param>
    procedure SetText(text: DNFormattedText);
    ///<summary>
    ///  Set text of the annotation.
    ///</summary>
    ///  <param name="text"></param>
    ///  <param name="textState"></param>
    procedure SetTextAndState(text: TArray<string>; textState: DNTextState);
    ///<summary>
    ///  Accepts visitor for annotation processing.
    ///</summary>
    ///  <param name="visitor">AnnotationSelector object.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Fuxed print object of Watermark annotation.
    ///</summary>
    property FixedPrint: DNFixedPrint read get_FixedPrint;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Gets or sets opacity of the annotation.
    ///</summary>
    property Opacity: Double read get_Opacity write set_Opacity;
    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets list of annotatation actions.
    ///</summary>
    property Actions: DNPdfActionCollection read get_Actions;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNWatermarkAnnotation = class(TDNGenericImport<DNWatermarkAnnotationClass, DNWatermarkAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Annotations----------------
  DNWidgetAnnotationClass = interface(DNAnnotationClass)
  ['{23417580-9DEB-53E5-958C-70141FF6E05A}']
  { constructors } 

    ///<summary>
    ///  Create annotation (used for Generator)
    ///</summary>
    ///  <param name="doc">Document where annotation will be created.</param>
    {class} function init(doc: DNDocument): DNWidgetAnnotation;

  end;

  ///<summary>
  ///  Class representing widget annotation.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Annotations.WidgetAnnotation')]
  DNWidgetAnnotation = interface(DNAnnotation)
  ['{71BB59A5-B87C-3483-91FE-C1D194216B2B}']
  { getters & setters } 

    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_PageIndex: Int32;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Accepts visitor.
    ///</summary>
    ///  <param name="visitor">Visitor to be accepted.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    ///<summary>
    ///  Returns rectangle of annotation taking into consideration page rotation.
    ///</summary>
    ///  <param name="considerRotation">If true, page rotation is takein into consideration.</param>
    ///<returns></returns>
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    ///<summary>
    ///  Places annotation contents directly on the page,
    ///  annotation object will be removed.
    ///</summary>
    procedure Flatten;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  An action which shall be performed when the annotation is activated.
    ///</summary>
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    ///<summary>
    ///  Gets the annotation actions.
    ///</summary>
    property Actions: DNAnnotationActionCollection read get_Actions;
    ///<summary>
    ///  Annotation highlighting mode.
    ///</summary>
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    ///<summary>
    ///  Gets annotation parent.
    ///</summary>
    property Parent: DNField read get_Parent;
    ///<summary>
    ///  Gets or sets default appearance of the field.
    ///</summary>
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    ///<summary>
    ///  Gets or sets read only status of the field.
    ///</summary>
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    ///<summary>
    ///  Gets or sets required status of the field.
    ///</summary>
    property Required: Boolean read get_Required write set_Required;
    ///<summary>
    ///  Gets or sets exportable flag of the field.
    ///</summary>
    property Exportable: Boolean read get_Exportable write set_Exportable;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    ///<summary>
    ///  Flags of the annotation.
    ///</summary>
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    ///<summary>
    ///  Gets or sets width of the annotation.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets or sets height of the annotation.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets annotation rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Gets or sets annotation text.
    ///</summary>
    property Contents: string read get_Contents write set_Contents;
    ///<summary>
    ///  Gets or sets annotation name on the page.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets or sets date and time when annotation was recently modified.
    ///</summary>
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    ///<summary>
    ///  Gets or sets annotation color.
    ///</summary>
    property Color: DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets or sets annotation border characteristics. <see cref="P:Aspose.Pdf.Annotations.Annotation.Border" />
    ///</summary>
    property Border: DNBorder read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets annotation characteristics.
    ///</summary>
    property Characteristics: DNCharacteristics read get_Characteristics;
    ///<summary>
    ///  Gets appearance dictionary of annotation.
    ///</summary>
    property States: DNAppearanceDictionary read get_States;
    ///<summary>
    ///  Annotation alignment. This property is obsolete. Use HorizontalAligment instead.
    ///</summary>
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets text alignment for annotation.
    ///</summary>
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets full qualified name of the annotation.
    ///</summary>
    ///<returns></returns>
    property FullName: string read get_FullName;
    ///<summary>
    ///  Gets appearance dictionary of the annotation.
    ///</summary>
    property Appearance: DNAppearanceDictionary read get_Appearance;
    ///<summary>
    ///  Gets index of page which contains annotation.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNWidgetAnnotation = class(TDNGenericImport<DNWidgetAnnotationClass, DNWidgetAnnotation>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNFieldClass = interface(DNWidgetAnnotationClass)
  ['{234CBF36-AFA0-57D6-A836-309E7F0066AF}']
  { static getter & setter } 

    {class} function get_FitIntoRectangle: Boolean;
    {class} procedure set_FitIntoRectangle(value: Boolean);
    {class} function get_MaxFontSize: Double;
    {class} procedure set_MaxFontSize(value: Double);
    {class} function get_MinFontSize: Double;
    {class} procedure set_MinFontSize(value: Double);

  { constructors } 

    ///<summary>
    ///  Creates field for use in Generator.
    ///</summary>
    ///  <param name="doc">Document where field will be created.</param>
    {class} function init(doc: DNDocument): DNField;

  { static propertys } 

    ///<summary>
    ///  If true then font size will reduced to fit text to specified rectangle.
    ///</summary>
    {class} property FitIntoRectangle: Boolean read get_FitIntoRectangle write set_FitIntoRectangle;
    ///<summary>
    ///  Maximail font size which can be used for field contents. -1 to don't check size.
    ///</summary>
    {class} property MaxFontSize: Double read get_MaxFontSize write set_MaxFontSize;
    ///<summary>
    ///  Minimal font size which can be used for field contents. -1 to don't check size.
    ///</summary>
    {class} property MinFontSize: Double read get_MinFontSize write set_MinFontSize;
  end;

  ///<summary>
  ///  Base class for acro form fields.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.Field')]
  DNField = interface(DNWidgetAnnotation)
  ['{289468F4-6382-3D1C-B8DF-2F003FC51C6B}']
  { getters & setters } 

    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Recaculates all calculated fields on the form.
    ///</summary>
    ///<returns>true if field value was changed during recalculation.</returns>
    function Recalculate: Boolean;
    ///<summary>
    ///  Copies subfields of this field into array starting from specified index.
    ///</summary>
    ///  <param name="array">Array where field must be copied.</param>
    ///  <param name="index">Starting index where fields will be copied.</param>
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    ///<summary>
    ///  Returns enumerator of contained fields.
    ///</summary>
    ///<returns>Enumerator.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    ///<summary>
    ///  Removes this field and place its value directly on the page.
    ///</summary>
    procedure Flatten;
    ///<summary>
    ///  Set position of the field.
    ///</summary>
    ///  <param name="point">Point where field should be positioned.</param>
    procedure SetPosition(point: DNPoint);
    ///<summary>
    ///  Accepts visitor.
    ///</summary>
    ///  <param name="visitor">Visitor to be accepted.</param>
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets partial name of the field.
    ///</summary>
    property PartialName: string read get_PartialName write set_PartialName;
    ///<summary>
    ///  Gets or sets alternate name of the field (An alternate field
    ///  name that shall be used in place of the actual field name
    ///  wherever the field shall be identified in the user interface).
    ///  Alternate name is used as field tooltip in Adobe Acrobat.
    ///</summary>
    property AlternateName: string read get_AlternateName write set_AlternateName;
    ///<summary>
    ///  Gets or sets mapping name  of the field that shall be used when exporting interactive form field data from the document.
    ///</summary>
    property MappingName: string read get_MappingName write set_MappingName;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    ///<summary>
    ///  Returns true if dictionary is synchronized.
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets or sets number of subfields in this field. (For example number of items in radio button field).
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Synchronization object.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Gets or sets boolean value which indicates is this field non-terminal field i.e. group of fields.
    ///</summary>
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    ///<summary>
    ///  Gets or sets index of this anotation on the page.
    ///</summary>
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    ///<summary>
    ///  Gets index of page which contains this field.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    ///<summary>
    ///  Gets or sets the field rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Property for Generator support. Used when field is added to header or footer. If true, this field will created once and it's appearance will be visible on all pages of the document. If false, separated field will be created for every document page.
    ///</summary>
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    ///<summary>
    ///  Gets or sets tab order of the field.
    ///</summary>
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    ///<summary>
    ///  An action which shall be performed when the annotation is activated.
    ///</summary>
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    ///<summary>
    ///  Gets the annotation actions.
    ///</summary>
    property Actions: DNAnnotationActionCollection read get_Actions;
    ///<summary>
    ///  Annotation highlighting mode.
    ///</summary>
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    ///<summary>
    ///  Gets annotation parent.
    ///</summary>
    property Parent: DNField read get_Parent;
    ///<summary>
    ///  Gets or sets default appearance of the field.
    ///</summary>
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    ///<summary>
    ///  Gets or sets read only status of the field.
    ///</summary>
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    ///<summary>
    ///  Gets or sets required status of the field.
    ///</summary>
    property Required: Boolean read get_Required write set_Required;
    ///<summary>
    ///  Gets or sets exportable flag of the field.
    ///</summary>
    property Exportable: Boolean read get_Exportable write set_Exportable;
    ///<summary>
    ///  Gets type of annotation.
    ///</summary>
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNField = class(TDNGenericImport<DNFieldClass, DNField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNButtonFieldClass = interface(DNFieldClass)
  ['{53836264-EEA6-5610-9528-8D348EC2E977}']
  { constructors } 

    ///<summary>
    ///  Button field constructor for Generator.
    ///</summary>
    {class} function init: DNButtonField; overload;
    ///<summary>
    ///  ButtonField constructor.
    ///</summary>
    ///  <param name="page">Page where button will be placed.</param>
    ///  <param name="rect">Rectangle where button is placed on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNButtonField; overload;
    ///<summary>
    ///  ButtonField constructore.
    ///</summary>
    ///  <param name="doc">Docuemtn where new field will be created.</param>
    ///  <param name="rect">Rectangle hwere button is placed on the page. </param>
    {class} function init(doc: DNDocument; rect: DNPdf_Rectangle): DNButtonField; overload;

  end;

  ///<summary>
  ///  Class represnets push button field.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.ButtonField')]
  DNButtonField = interface(DNField)
  ['{A3890F24-E2A8-363A-9226-3AD7C58C18D4}']
  { getters & setters } 

    function get_NormalCaption: string;
    procedure set_NormalCaption(value: string);
    function get_RolloverCaption: string;
    procedure set_RolloverCaption(value: string);
    function get_AlternateCaption: string;
    procedure set_AlternateCaption(value: string);
    function get_NormalIcon: DNXForm;
    procedure set_NormalIcon(value: DNXForm);
    function get_RolloverIcon: DNXForm;
    procedure set_RolloverIcon(value: DNXForm);
    function get_AlternateIcon: DNXForm;
    procedure set_AlternateIcon(value: DNXForm);
    function get_IconFit: DNIconFit;
    function get_ICPosition: DNIconCaptionPosition;
    procedure set_ICPosition(value: DNIconCaptionPosition);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds image into the field resources an draws it.
    ///</summary>
    ///  <param name="image">
    ///  Image ot add into text field.
    ///</param>
    procedure AddImage(image: DDN.System.Drawing.DNImage);
    ///<summary>
    ///  Recaculates all calculated fields on the form.
    ///</summary>
    ///<returns>true if field value was changed during recalculation.</returns>
    function Recalculate: Boolean;
    ///<summary>
    ///  Copies subfields of this field into array starting from specified index.
    ///</summary>
    ///  <param name="array">Array where field must be copied.</param>
    ///  <param name="index">Starting index where fields will be copied.</param>
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    ///<summary>
    ///  Returns enumerator of contained fields.
    ///</summary>
    ///<returns>Enumerator.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    ///<summary>
    ///  Removes this field and place its value directly on the page.
    ///</summary>
    procedure Flatten;
    ///<summary>
    ///  Set position of the field.
    ///</summary>
    ///  <param name="point">Point where field should be positioned.</param>
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets normal caption.
    ///</summary>
    property NormalCaption: string read get_NormalCaption write set_NormalCaption;
    ///<summary>
    ///  Gets or sets rollover caption of button which shall be displayed when the user rolls the cursor
    ///  into its active area without pressing the mouse button.
    ///</summary>
    property RolloverCaption: string read get_RolloverCaption write set_RolloverCaption;
    ///<summary>
    ///  Gets or sets alternate caption of the button which shall be displayed
    ///  when the mouse button is pressed within its active area.
    ///</summary>
    property AlternateCaption: string read get_AlternateCaption write set_AlternateCaption;
    ///<summary>
    ///  Gets or sets normal icon of the button which shall be displayed when it is not interacting with the user.
    ///</summary>
    property NormalIcon: DNXForm read get_NormalIcon write set_NormalIcon;
    ///<summary>
    ///  Gets or sets rollover icon of the button which shall be displayed when the user
    ///  rolls the cursor into its active area without pressing the mouse button.
    ///</summary>
    property RolloverIcon: DNXForm read get_RolloverIcon write set_RolloverIcon;
    ///<summary>
    ///  Gets or sets alternate icon which shall be displayed when the mouse button is pressed within its active area.
    ///</summary>
    property AlternateIcon: DNXForm read get_AlternateIcon write set_AlternateIcon;
    ///<summary>
    ///  Gets icon fit object specifying how the widget annotation's icon shall be displayed within its annotation rectangle.
    ///</summary>
    property IconFit: DNIconFit read get_IconFit;
    ///<summary>
    ///  Gets or sets icon caption position.
    ///</summary>
    property ICPosition: DNIconCaptionPosition read get_ICPosition write set_ICPosition;
    ///<summary>
    ///  Gets or sets partial name of the field.
    ///</summary>
    property PartialName: string read get_PartialName write set_PartialName;
    ///<summary>
    ///  Gets or sets alternate name of the field (An alternate field
    ///  name that shall be used in place of the actual field name
    ///  wherever the field shall be identified in the user interface).
    ///  Alternate name is used as field tooltip in Adobe Acrobat.
    ///</summary>
    property AlternateName: string read get_AlternateName write set_AlternateName;
    ///<summary>
    ///  Gets or sets mapping name  of the field that shall be used when exporting interactive form field data from the document.
    ///</summary>
    property MappingName: string read get_MappingName write set_MappingName;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    ///<summary>
    ///  Returns true if dictionary is synchronized.
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets or sets number of subfields in this field. (For example number of items in radio button field).
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Synchronization object.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Gets or sets boolean value which indicates is this field non-terminal field i.e. group of fields.
    ///</summary>
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    ///<summary>
    ///  Gets or sets index of this anotation on the page.
    ///</summary>
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    ///<summary>
    ///  Gets index of page which contains this field.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    ///<summary>
    ///  Gets or sets the field rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Property for Generator support. Used when field is added to header or footer. If true, this field will created once and it's appearance will be visible on all pages of the document. If false, separated field will be created for every document page.
    ///</summary>
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    ///<summary>
    ///  Gets or sets tab order of the field.
    ///</summary>
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNButtonField = class(TDNGenericImport<DNButtonFieldClass, DNButtonField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNCheckboxFieldClass = interface(DNFieldClass)
  ['{588984CB-5D86-55CF-9589-43910C6D9463}']
  { constructors } 

    ///<summary>
    ///  Constructor for CheckboxField class.
    ///</summary>
    ///  <param name="page">Page where check box will be placed.</param>
    ///  <param name="rect">Position and size of the check box.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNCheckboxField; overload;
    ///<summary>
    ///  Constructor for CheckboxField class.
    ///</summary>
    ///  <param name="doc">Document where will be new field created.</param>
    ///  <param name="rect">Rectangle where new field will be created.</param>
    {class} function init(doc: DNDocument; rect: DNPdf_Rectangle): DNCheckboxField; overload;
    ///<summary>
    ///  Create instance of CheckboxField.
    ///</summary>
    {class} function init: DNCheckboxField; overload;
    ///<summary>
    ///  Constructor to use with Generator.
    ///</summary>
    ///  <param name="doc">Document where field will be created.</param>
    {class} function init(doc: DNDocument): DNCheckboxField; overload;

  end;

  ///<summary>
  ///  Class representing checkbox field
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.CheckboxField')]
  DNCheckboxField = interface(DNField)
  ['{41015024-5534-346B-93F9-16A6FB6FCB30}']
  { getters & setters } 

    function get_AllowedStates: DDN.mscorlib.DNList<string>;
    function get_Style: DNBoxStyle;
    procedure set_Style(value: DNBoxStyle);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Checked: Boolean;
    procedure set_Checked(value: Boolean);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_ExportValue: string;
    procedure set_ExportValue(value: string);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Clone the checkbox.
    ///</summary>
    ///<returns>The cloned object</returns>
    function Clone: DDN.mscorlib.DNObject;
    ///<summary>
    ///  Recaculates all calculated fields on the form.
    ///</summary>
    ///<returns>true if field value was changed during recalculation.</returns>
    function Recalculate: Boolean;
    ///<summary>
    ///  Copies subfields of this field into array starting from specified index.
    ///</summary>
    ///  <param name="array">Array where field must be copied.</param>
    ///  <param name="index">Starting index where fields will be copied.</param>
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    ///<summary>
    ///  Returns enumerator of contained fields.
    ///</summary>
    ///<returns>Enumerator.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    ///<summary>
    ///  Removes this field and place its value directly on the page.
    ///</summary>
    procedure Flatten;
    ///<summary>
    ///  Set position of the field.
    ///</summary>
    ///  <param name="point">Point where field should be positioned.</param>
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Returns list of allowed states.
    ///</summary>
    ///<returns></returns>
    property AllowedStates: DDN.mscorlib.DNList<string> read get_AllowedStates;
    ///<summary>
    ///  Gets or sets style of check box.
    ///</summary>
    property Style: DNBoxStyle read get_Style write set_Style;
    ///<summary>
    ///  Gets or sets current annotation appearance state.
    ///</summary>
    property ActiveState: string read get_ActiveState write set_ActiveState;
    ///<summary>
    ///  Gets or sets state of check box.
    ///</summary>
    property Checked: Boolean read get_Checked write set_Checked;
    ///<summary>
    ///  Gets or sets value of check box field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    ///<summary>
    ///  Gets or sets export value of CheckBox field.
    ///</summary>
    property ExportValue: string read get_ExportValue write set_ExportValue;
    ///<summary>
    ///  Gets or sets partial name of the field.
    ///</summary>
    property PartialName: string read get_PartialName write set_PartialName;
    ///<summary>
    ///  Gets or sets alternate name of the field (An alternate field
    ///  name that shall be used in place of the actual field name
    ///  wherever the field shall be identified in the user interface).
    ///  Alternate name is used as field tooltip in Adobe Acrobat.
    ///</summary>
    property AlternateName: string read get_AlternateName write set_AlternateName;
    ///<summary>
    ///  Gets or sets mapping name  of the field that shall be used when exporting interactive form field data from the document.
    ///</summary>
    property MappingName: string read get_MappingName write set_MappingName;
    ///<summary>
    ///  Returns true if dictionary is synchronized.
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets or sets number of subfields in this field. (For example number of items in radio button field).
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Synchronization object.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Gets or sets boolean value which indicates is this field non-terminal field i.e. group of fields.
    ///</summary>
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    ///<summary>
    ///  Gets or sets index of this anotation on the page.
    ///</summary>
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    ///<summary>
    ///  Gets index of page which contains this field.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    ///<summary>
    ///  Gets or sets the field rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Property for Generator support. Used when field is added to header or footer. If true, this field will created once and it's appearance will be visible on all pages of the document. If false, separated field will be created for every document page.
    ///</summary>
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    ///<summary>
    ///  Gets or sets tab order of the field.
    ///</summary>
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNCheckboxField = class(TDNGenericImport<DNCheckboxFieldClass, DNCheckboxField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNChoiceFieldClass = interface(DNFieldClass)
  ['{5276F763-CB34-5624-94C0-1A7F97E3B565}']
  { constructors } 

    ///<summary>
    ///  Constructor for ChoiceField.
    ///</summary>
    ///  <param name="page">Page where field is situated.</param>
    ///  <param name="rect">Rectangle of the field.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNChoiceField; overload;
    ///<summary>
    ///  Creates choice field (for Generator)
    ///</summary>
    ///  <param name="doc">Document where choice field will be created.</param>
    {class} function init(doc: DNDocument): DNChoiceField; overload;
    ///<summary>
    ///  Constructor for ChoiceField.
    ///</summary>
    ///  <param name="doc">Document where field will be created. </param>
    ///  <param name="rect">Rectangle of the field. </param>
    {class} function init(doc: DNDocument; rect: DNPdf_Rectangle): DNChoiceField; overload;

  end;

  ///<summary>
  ///  Represents base class for choice fields.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.ChoiceField')]
  DNChoiceField = interface(DNField)
  ['{335D3158-DCDC-37BC-88C8-0AF399B11BDE}']
  { getters & setters } 

    function get_CommitImmediately: Boolean;
    procedure set_CommitImmediately(value: Boolean);
    function get_MultiSelect: Boolean;
    procedure set_MultiSelect(value: Boolean);
    function get_Selected: Int32;
    procedure set_Selected(value: Int32);
    function get_SelectedItems: TArray<Int32>;
    procedure set_SelectedItems(value: TArray<Int32>);
    function get_Options: DNOptionCollection;
    function get_Value: string;
    procedure set_Value(value: string);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds new option with specified name.
    ///</summary>
    ///  <param name="optionName">Name of the new option.</param>
    procedure AddOption(optionName: string); overload;
    ///<summary>
    ///  Adds new option with specified export value and name.
    ///</summary>
    ///  <param name="export">Export value.</param>
    ///  <param name="name">Name of the new option.</param>
    procedure AddOption(&export: string; name: string); overload;
    ///<summary>
    ///  Deletes option by its name.
    ///</summary>
    ///  <param name="optionName">Name of the option which must be deleted.</param>
    procedure DeleteOption(optionName: string);
    ///<summary>
    ///  Recaculates all calculated fields on the form.
    ///</summary>
    ///<returns>true if field value was changed during recalculation.</returns>
    function Recalculate: Boolean;
    ///<summary>
    ///  Copies subfields of this field into array starting from specified index.
    ///</summary>
    ///  <param name="array">Array where field must be copied.</param>
    ///  <param name="index">Starting index where fields will be copied.</param>
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    ///<summary>
    ///  Returns enumerator of contained fields.
    ///</summary>
    ///<returns>Enumerator.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    ///<summary>
    ///  Removes this field and place its value directly on the page.
    ///</summary>
    procedure Flatten;
    ///<summary>
    ///  Set position of the field.
    ///</summary>
    ///  <param name="point">Point where field should be positioned.</param>
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets commit on selection change flag.
    ///</summary>
    property CommitImmediately: Boolean read get_CommitImmediately write set_CommitImmediately;
    ///<summary>
    ///  Gets or sets multiselection flag.
    ///</summary>
    property MultiSelect: Boolean read get_MultiSelect write set_MultiSelect;
    ///<summary>
    ///  Gets or sets index of selected option. This property allows to change selection.
    ///</summary>
    property Selected: Int32 read get_Selected write set_Selected;
    ///<summary>
    ///  Gets or sets array of selected items. For multiselect list array contains more then one item. For single selection list it contains single item.
    ///</summary>
    property SelectedItems: TArray<Int32> read get_SelectedItems write set_SelectedItems;
    ///<summary>
    ///  Gets collection of choice options.
    ///</summary>
    property Options: DNOptionCollection read get_Options;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    ///<summary>
    ///  Gets or sets partial name of the field.
    ///</summary>
    property PartialName: string read get_PartialName write set_PartialName;
    ///<summary>
    ///  Gets or sets alternate name of the field (An alternate field
    ///  name that shall be used in place of the actual field name
    ///  wherever the field shall be identified in the user interface).
    ///  Alternate name is used as field tooltip in Adobe Acrobat.
    ///</summary>
    property AlternateName: string read get_AlternateName write set_AlternateName;
    ///<summary>
    ///  Gets or sets mapping name  of the field that shall be used when exporting interactive form field data from the document.
    ///</summary>
    property MappingName: string read get_MappingName write set_MappingName;
    ///<summary>
    ///  Returns true if dictionary is synchronized.
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets or sets number of subfields in this field. (For example number of items in radio button field).
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Synchronization object.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Gets or sets boolean value which indicates is this field non-terminal field i.e. group of fields.
    ///</summary>
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    ///<summary>
    ///  Gets or sets index of this anotation on the page.
    ///</summary>
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    ///<summary>
    ///  Gets index of page which contains this field.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    ///<summary>
    ///  Gets or sets the field rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Property for Generator support. Used when field is added to header or footer. If true, this field will created once and it's appearance will be visible on all pages of the document. If false, separated field will be created for every document page.
    ///</summary>
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    ///<summary>
    ///  Gets or sets tab order of the field.
    ///</summary>
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNChoiceField = class(TDNGenericImport<DNChoiceFieldClass, DNChoiceField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNComboBoxFieldClass = interface(DNChoiceFieldClass)
  ['{A824B83D-6C35-5F89-B73E-DCC9AF8F4AEF}']
  { constructors } 

    ///<summary>
    ///  Constructor for ComboBoxField to be used in Generator.
    ///</summary>
    {class} function init: DNComboBoxField; overload;
    ///<summary>
    ///  Creates CombBox field to work with Generator.
    ///</summary>
    ///  <param name="doc">Document where field will be created.</param>
    {class} function init(doc: DNDocument): DNComboBoxField; overload;
    ///<summary>
    ///  Constructor for Combobox Field.
    ///</summary>
    ///  <param name="page">Page where field will be placed. </param>
    ///  <param name="rect">Rectangle which defines size and position of the field on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNComboBoxField; overload;
    ///<summary>
    ///  Constructor for Combobox field.
    ///</summary>
    ///  <param name="doc">Document where field should be created.</param>
    ///  <param name="rect">Rectangle which defines size and position of the field. </param>
    {class} function init(doc: DNDocument; rect: DNPdf_Rectangle): DNComboBoxField; overload;

  end;

  ///<summary>
  ///  Class representing Combobox field of the form.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.ComboBoxField')]
  DNComboBoxField = interface(DNChoiceField)
  ['{E4EEE2CB-BF7F-3573-AFDC-33E9DB9AA3F1}']
  { getters & setters } 

    function get_Editable: Boolean;
    procedure set_Editable(value: Boolean);
    function get_SpellCheck: Boolean;
    procedure set_SpellCheck(value: Boolean);
    function get_CommitImmediately: Boolean;
    procedure set_CommitImmediately(value: Boolean);
    function get_MultiSelect: Boolean;
    procedure set_MultiSelect(value: Boolean);
    function get_Selected: Int32;
    procedure set_Selected(value: Int32);
    function get_SelectedItems: TArray<Int32>;
    procedure set_SelectedItems(value: TArray<Int32>);
    function get_Options: DNOptionCollection;
    function get_Value: string;
    procedure set_Value(value: string);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds new option with specified name.
    ///</summary>
    ///  <param name="optionName">Name of the new option.</param>
    procedure AddOption(optionName: string); overload;
    ///<summary>
    ///  Adds new option with specified export value and name.
    ///</summary>
    ///  <param name="export">Export value.</param>
    ///  <param name="name">Name of the new option.</param>
    procedure AddOption(&export: string; name: string); overload;
    ///<summary>
    ///  Deletes option by its name.
    ///</summary>
    ///  <param name="optionName">Name of the option which must be deleted.</param>
    procedure DeleteOption(optionName: string);
    function Recalculate: Boolean;
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    procedure Flatten;
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets editable status of the field.
    ///</summary>
    property Editable: Boolean read get_Editable write set_Editable;
    ///<summary>
    ///  Gets or sets spellchaeck activiity status.
    ///</summary>
    property SpellCheck: Boolean read get_SpellCheck write set_SpellCheck;
    ///<summary>
    ///  Gets or sets commit on selection change flag.
    ///</summary>
    property CommitImmediately: Boolean read get_CommitImmediately write set_CommitImmediately;
    ///<summary>
    ///  Gets or sets multiselection flag.
    ///</summary>
    property MultiSelect: Boolean read get_MultiSelect write set_MultiSelect;
    ///<summary>
    ///  Gets or sets index of selected option. This property allows to change selection.
    ///</summary>
    property Selected: Int32 read get_Selected write set_Selected;
    ///<summary>
    ///  Gets or sets array of selected items. For multiselect list array contains more then one item. For single selection list it contains single item.
    ///</summary>
    property SelectedItems: TArray<Int32> read get_SelectedItems write set_SelectedItems;
    ///<summary>
    ///  Gets collection of choice options.
    ///</summary>
    property Options: DNOptionCollection read get_Options;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    property PartialName: string read get_PartialName write set_PartialName;
    property AlternateName: string read get_AlternateName write set_AlternateName;
    property MappingName: string read get_MappingName write set_MappingName;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property Count: Int32 read get_Count;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    property PageIndex: Int32 read get_PageIndex;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNComboBoxField = class(TDNGenericImport<DNComboBoxFieldClass, DNComboBoxField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNListBoxFieldClass = interface(DNChoiceFieldClass)
  ['{B246C696-42EB-5D0B-8012-4E81A03808FF}']
  { static getter & setter } 

    procedure set_Selected(value: Int32);
    procedure set_SelectedItems(value: TArray<Int32>);

  { constructors } 

    ///<summary>
    ///  Constructor for ListBoxField to be used in Generator.
    ///</summary>
    {class} function init: DNListBoxField; overload;
    ///<summary>
    ///  Creates new ListBox field.
    ///</summary>
    ///  <param name="page">Page where list box will be placed.</param>
    ///  <param name="rect">Rectangle where list box will be placed on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNListBoxField; overload;
    ///<summary>
    ///  Constructor for ListBox field.
    ///</summary>
    ///  <param name="doc">Document to which this field will belong.</param>
    ///  <param name="rect">Rectangle where list box will be placed. </param>
    {class} function init(doc: DNDocument; rect: DNPdf_Rectangle): DNListBoxField; overload;

  { static propertys } 

    ///<summary>
    ///  Gets or sets index of the selected item. Items are numbered from 1.
    ///</summary>
    {class} property Selected: Int32 write set_Selected;
    ///<summary>
    ///  Gets or sets array of the selected items in the multiselect list. For single-select list returns array with single item.
    ///</summary>
    {class} property SelectedItems: TArray<Int32> write set_SelectedItems;
  end;

  ///<summary>
  ///  Class represents ListBox field.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.ListBoxField')]
  DNListBoxField = interface(DNChoiceField)
  ['{3C0D3999-8A56-3D4A-B3C7-BEE986E21D69}']
  { getters & setters } 

    function get_TopIndex: Int32;
    procedure set_TopIndex(value: Int32);
    procedure set_Selected(value: Int32);
    procedure set_SelectedItems(value: TArray<Int32>);
    function get_CommitImmediately: Boolean;
    procedure set_CommitImmediately(value: Boolean);
    function get_MultiSelect: Boolean;
    procedure set_MultiSelect(value: Boolean);
    function get_Options: DNOptionCollection;
    function get_Value: string;
    procedure set_Value(value: string);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds new option with specified name.
    ///</summary>
    ///  <param name="optionName">Name of the new option.</param>
    procedure AddOption(optionName: string); overload;
    ///<summary>
    ///  Adds new option with specified export value and name.
    ///</summary>
    ///  <param name="export">Export value.</param>
    ///  <param name="name">Name of the new option.</param>
    procedure AddOption(&export: string; name: string); overload;
    ///<summary>
    ///  Deletes option by its name.
    ///</summary>
    ///  <param name="optionName">Name of the option which must be deleted.</param>
    procedure DeleteOption(optionName: string);
    function Recalculate: Boolean;
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    procedure Flatten;
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets index of the top visible element of the list.
    ///</summary>
    property TopIndex: Int32 read get_TopIndex write set_TopIndex;
    ///<summary>
    ///  Gets or sets index of the selected item. Items are numbered from 1.
    ///</summary>
    property Selected: Int32 write set_Selected;
    ///<summary>
    ///  Gets or sets array of the selected items in the multiselect list. For single-select list returns array with single item.
    ///</summary>
    property SelectedItems: TArray<Int32> write set_SelectedItems;
    ///<summary>
    ///  Gets or sets commit on selection change flag.
    ///</summary>
    property CommitImmediately: Boolean read get_CommitImmediately write set_CommitImmediately;
    ///<summary>
    ///  Gets or sets multiselection flag.
    ///</summary>
    property MultiSelect: Boolean read get_MultiSelect write set_MultiSelect;
    ///<summary>
    ///  Gets collection of choice options.
    ///</summary>
    property Options: DNOptionCollection read get_Options;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    property PartialName: string read get_PartialName write set_PartialName;
    property AlternateName: string read get_AlternateName write set_AlternateName;
    property MappingName: string read get_MappingName write set_MappingName;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property Count: Int32 read get_Count;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    property PageIndex: Int32 read get_PageIndex;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNListBoxField = class(TDNGenericImport<DNListBoxFieldClass, DNListBoxField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNRadioButtonFieldClass = interface(DNChoiceFieldClass)
  ['{57D20B0B-5C20-519C-AA4D-138F074E4F70}']
  { constructors } 

    ///<summary>
    ///  Constructor for RadiouttonField
    ///</summary>
    ///  <param name="page">Page where radio button will be placed.</param>
    {class} function init(page: DNPage): DNRadioButtonField; overload;
    ///<summary>
    ///  Constructor for RadioButtonField.
    ///</summary>
    ///  <param name="doc">Document where radio button will be created.</param>
    {class} function init(doc: DNDocument): DNRadioButtonField; overload;

  end;

  ///<summary>
  ///  Class representing radio button field.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.RadioButtonField')]
  DNRadioButtonField = interface(DNChoiceField)
  ['{B604ECC6-AF30-3CCF-AA1A-F950DE29E0B5}']
  { getters & setters } 

    function get_Style: DNBoxStyle;
    procedure set_Style(value: DNBoxStyle);
    function get_Selected: Int32;
    procedure set_Selected(value: Int32);
    function get_Options: DNOptionCollection;
    function get_PageIndex: Int32;
    function get_Value: string;
    procedure set_Value(value: string);
    function get_CommitImmediately: Boolean;
    procedure set_CommitImmediately(value: Boolean);
    function get_MultiSelect: Boolean;
    procedure set_MultiSelect(value: Boolean);
    function get_SelectedItems: TArray<Int32>;
    procedure set_SelectedItems(value: TArray<Int32>);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds new option field to RadioButton field
    ///</summary>
    ///  <param name="newItem">Item which should be added.</param>
    procedure Add(newItem: DNRadioButtonOptionField);
    ///<summary>
    ///  Add  to radio button option with specifed rectangle.
    ///</summary>
    ///  <param name="optionName">Name of new option.</param>
    ///  <param name="rect">New item rectangle.</param>
    procedure AddOption(optionName: string; rect: DNPdf_Rectangle); overload;
    ///<summary>
    ///  Add option to radion button.
    ///</summary>
    ///  <param name="optionName">Name of the option which will be added.</param>
    procedure AddOption(optionName: string); overload;
    ///<summary>
    ///  Move all subitems of radio button to specified positins on the page.
    ///</summary>
    ///  <param name="point">Sets position of RadioButton field annotations.</param>
    procedure SetPosition(point: DNPoint);
    ///<summary>
    ///  Adds new option with specified export value and name.
    ///</summary>
    ///  <param name="export">Export value.</param>
    ///  <param name="name">Name of the new option.</param>
    procedure AddOption(&export: string; name: string); overload;
    ///<summary>
    ///  Deletes option by its name.
    ///</summary>
    ///  <param name="optionName">Name of the option which must be deleted.</param>
    procedure DeleteOption(optionName: string);
    function Recalculate: Boolean;
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    procedure Flatten;
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Style of field box.
    ///</summary>
    property Style: DNBoxStyle read get_Style write set_Style;
    ///<summary>
    ///  Gets or sets index of selected item. Numbering of items is started from 1.
    ///</summary>
    property Selected: Int32 read get_Selected write set_Selected;
    ///<summary>
    ///  Gets collection of options of the radio button.
    ///</summary>
    property Options: DNOptionCollection read get_Options;
    ///<summary>
    ///  Gets index of page which contains this RadioButton field.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    ///<summary>
    ///  Gets or sets value of field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    ///<summary>
    ///  Gets or sets commit on selection change flag.
    ///</summary>
    property CommitImmediately: Boolean read get_CommitImmediately write set_CommitImmediately;
    ///<summary>
    ///  Gets or sets multiselection flag.
    ///</summary>
    property MultiSelect: Boolean read get_MultiSelect write set_MultiSelect;
    ///<summary>
    ///  Gets or sets array of selected items. For multiselect list array contains more then one item. For single selection list it contains single item.
    ///</summary>
    property SelectedItems: TArray<Int32> read get_SelectedItems write set_SelectedItems;
    property PartialName: string read get_PartialName write set_PartialName;
    property AlternateName: string read get_AlternateName write set_AlternateName;
    property MappingName: string read get_MappingName write set_MappingName;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property Count: Int32 read get_Count;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNRadioButtonField = class(TDNGenericImport<DNRadioButtonFieldClass, DNRadioButtonField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNRadioButtonOptionFieldClass = interface(DNFieldClass)
  ['{A9D17CD2-E23A-57A1-9389-18D7DE4BE421}']
  { constructors } 

    ///<summary>
    ///  Create new RadioButtonOptionField instance.
    ///</summary>
    {class} function init: DNRadioButtonOptionField; overload;
    ///<summary>
    ///  Creates radiobutton in the specified recangle on specified page.
    ///</summary>
    ///  <param name="page">Page where RadioButton will be placed;</param>
    ///  <param name="rect">Recangle of RadioButton.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNRadioButtonOptionField; overload;

  end;

  ///<summary>
  ///  Class represents item of RadioButton field.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.RadioButtonOptionField')]
  DNRadioButtonOptionField = interface(DNField)
  ['{6D25AFD4-3C5F-38FE-BB68-E2F62D6FAF2B}']
  { getters & setters } 

    function get_OptionName: string;
    procedure set_OptionName(value: string);
    function get_Caption: DNTextFragment;
    procedure set_Caption(value: DNTextFragment);
    function get_Style: DNBoxStyle;
    procedure set_Style(value: DNBoxStyle);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Recaculates all calculated fields on the form.
    ///</summary>
    ///<returns>true if field value was changed during recalculation.</returns>
    function Recalculate: Boolean;
    ///<summary>
    ///  Copies subfields of this field into array starting from specified index.
    ///</summary>
    ///  <param name="array">Array where field must be copied.</param>
    ///  <param name="index">Starting index where fields will be copied.</param>
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    ///<summary>
    ///  Returns enumerator of contained fields.
    ///</summary>
    ///<returns>Enumerator.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    ///<summary>
    ///  Removes this field and place its value directly on the page.
    ///</summary>
    procedure Flatten;
    ///<summary>
    ///  Set position of the field.
    ///</summary>
    ///  <param name="point">Point where field should be positioned.</param>
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets name of the option.
    ///</summary>
    property OptionName: string read get_OptionName write set_OptionName;
    ///<summary>
    ///  Gets or sets caption.
    ///</summary>
    property Caption: DNTextFragment read get_Caption write set_Caption;
    ///<summary>
    ///  Gets or sets style of check box.
    ///</summary>
    property Style: DNBoxStyle read get_Style write set_Style;
    ///<summary>
    ///  Gets or sets partial name of the field.
    ///</summary>
    property PartialName: string read get_PartialName write set_PartialName;
    ///<summary>
    ///  Gets or sets alternate name of the field (An alternate field
    ///  name that shall be used in place of the actual field name
    ///  wherever the field shall be identified in the user interface).
    ///  Alternate name is used as field tooltip in Adobe Acrobat.
    ///</summary>
    property AlternateName: string read get_AlternateName write set_AlternateName;
    ///<summary>
    ///  Gets or sets mapping name  of the field that shall be used when exporting interactive form field data from the document.
    ///</summary>
    property MappingName: string read get_MappingName write set_MappingName;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    ///<summary>
    ///  Returns true if dictionary is synchronized.
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets or sets number of subfields in this field. (For example number of items in radio button field).
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Synchronization object.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Gets or sets boolean value which indicates is this field non-terminal field i.e. group of fields.
    ///</summary>
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    ///<summary>
    ///  Gets or sets index of this anotation on the page.
    ///</summary>
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    ///<summary>
    ///  Gets index of page which contains this field.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    ///<summary>
    ///  Gets or sets the field rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Property for Generator support. Used when field is added to header or footer. If true, this field will created once and it's appearance will be visible on all pages of the document. If false, separated field will be created for every document page.
    ///</summary>
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    ///<summary>
    ///  Gets or sets tab order of the field.
    ///</summary>
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNRadioButtonOptionField = class(TDNGenericImport<DNRadioButtonOptionFieldClass, DNRadioButtonOptionField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNSignatureFieldClass = interface(DNFieldClass)
  ['{36A227EE-6F73-5A49-BFA9-D1AF25D2C48A}']
  { constructors } 

    ///<summary>
    ///  Initializes new instance of the <see cref="T:Aspose.Pdf.Forms.SignatureField" />
    ///  class.
    ///</summary>
    ///  <param name="page">Page where signature field should be placed.</param>
    ///  <param name="rect">Position and size of signature field.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNSignatureField; overload;
    ///<summary>
    ///  Initializes new instance of the <see cref="T:Aspose.Pdf.Forms.SignatureField" />
    ///  class.
    ///</summary>
    ///  <param name="doc">Page where signature field should be placed.</param>
    ///  <param name="rect">Position and size of signature field.</param>
    {class} function init(doc: DNDocument; rect: DNPdf_Rectangle): DNSignatureField; overload;

  end;

  ///<summary>
  ///  Represents signature form field.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.SignatureField')]
  DNSignatureField = interface(DNField)
  ['{60145731-AA6C-3A3E-8524-4817D35FCF80}']
  { getters & setters } 

    function get_Signature: DNSignature;
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Signs the document using this signature field.
    ///</summary>
    ///  <param name="signature">
    ///  Signature object, see <see cref="T:Aspose.Pdf.Forms.PKCS1" />
    ///  , <see cref="T:Aspose.Pdf.Forms.PKCS7" />
    ///  , <see cref="T:Aspose.Pdf.Forms.PKCS7Detached" />
    ///  .
    ///</param>
    ///  <param name="pfx">
    ///  Stream with certificate.
    ///</param>
    ///  <param name="pass">
    ///  Password to access private in the <paramref name="pfx" />
    ///  .
    ///</param>
    procedure Sign(signature: DNSignature; pfx: DDN.mscorlib.DNStream; pass: string); overload;
    ///<summary>
    ///  Sign the document using this signature field.
    ///</summary>
    ///  <param name="signature">Signature object, see <see cref="T:Aspose.Pdf.Forms.PKCS1" />
    ///  , <see cref="T:Aspose.Pdf.Forms.PKCS7" />
    ///  and <see cref="T:Aspose.Pdf.Forms.PKCS7Detached" />
    ///  .</param>
    procedure Sign(signature: DNSignature); overload;
    ///<summary>
    ///  Extracts signature's image as jpeg encoded stream.
    ///</summary>
    ///<returns>If image was successfully found than returns jpeg encoded stream object; otherwise, null.</returns>
    function ExtractImage: DDN.mscorlib.DNStream; overload;
    ///<summary>
    ///  Extracts signature's image as encoded stream.
    ///</summary>
    ///  <param name="format">Image format for encoding.</param>
    ///<returns>If image was successfully found than returns encodedstream object; otherwise, null.</returns>
    function ExtractImage(format: DDN.System.Drawing.DNImageFormat): DDN.mscorlib.DNStream; overload;
    ///<summary>
    ///  Extracts the single X.509 certificate in DER format as a stream.
    ///</summary>
    ///<returns>If certificate was found returns X.509 single certificate; otherwise, null.</returns>
    function ExtractCertificate: DDN.mscorlib.DNStream;
    ///<summary>
    ///  Recaculates all calculated fields on the form.
    ///</summary>
    ///<returns>true if field value was changed during recalculation.</returns>
    function Recalculate: Boolean;
    ///<summary>
    ///  Copies subfields of this field into array starting from specified index.
    ///</summary>
    ///  <param name="array">Array where field must be copied.</param>
    ///  <param name="index">Starting index where fields will be copied.</param>
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    ///<summary>
    ///  Returns enumerator of contained fields.
    ///</summary>
    ///<returns>Enumerator.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    ///<summary>
    ///  Removes this field and place its value directly on the page.
    ///</summary>
    procedure Flatten;
    ///<summary>
    ///  Set position of the field.
    ///</summary>
    ///  <param name="point">Point where field should be positioned.</param>
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets signature object.
    ///  This object contains signature data regarding public-key cryptographic standards.
    ///  Classes <see cref="T:Aspose.Pdf.Forms.PKCS1" />
    ///  , <see cref="T:Aspose.Pdf.Forms.PKCS7" />
    ///  and <see cref="T:Aspose.Pdf.Forms.PKCS7Detached" />
    ///  represent all supported types of signature objects.
    ///</summary>
    property Signature: DNSignature read get_Signature;
    ///<summary>
    ///  Gets or sets partial name of the field.
    ///</summary>
    property PartialName: string read get_PartialName write set_PartialName;
    ///<summary>
    ///  Gets or sets alternate name of the field (An alternate field
    ///  name that shall be used in place of the actual field name
    ///  wherever the field shall be identified in the user interface).
    ///  Alternate name is used as field tooltip in Adobe Acrobat.
    ///</summary>
    property AlternateName: string read get_AlternateName write set_AlternateName;
    ///<summary>
    ///  Gets or sets mapping name  of the field that shall be used when exporting interactive form field data from the document.
    ///</summary>
    property MappingName: string read get_MappingName write set_MappingName;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    ///<summary>
    ///  Returns true if dictionary is synchronized.
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets or sets number of subfields in this field. (For example number of items in radio button field).
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Synchronization object.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Gets or sets boolean value which indicates is this field non-terminal field i.e. group of fields.
    ///</summary>
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    ///<summary>
    ///  Gets or sets index of this anotation on the page.
    ///</summary>
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    ///<summary>
    ///  Gets index of page which contains this field.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    ///<summary>
    ///  Gets or sets the field rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Property for Generator support. Used when field is added to header or footer. If true, this field will created once and it's appearance will be visible on all pages of the document. If false, separated field will be created for every document page.
    ///</summary>
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    ///<summary>
    ///  Gets or sets tab order of the field.
    ///</summary>
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNSignatureField = class(TDNGenericImport<DNSignatureFieldClass, DNSignatureField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNTextBoxFieldClass = interface(DNFieldClass)
  ['{C6A9FF9A-E228-5A53-898A-638726F18288}']
  { constructors } 

    ///<summary>
    ///  Constructor which should be used with Generator.
    ///</summary>
    ///  <param name="doc">Document where field will be created.</param>
    {class} function init(doc: DNDocument): DNTextBoxField; overload;
    ///<summary>
    ///  Create instance of TextBoxField.
    ///</summary>
    {class} function init: DNTextBoxField; overload;
    ///<summary>
    ///  Constructor of TextBox field.
    ///</summary>
    ///  <param name="page">Page where text field is placed.</param>
    ///  <param name="rect">Rectangle where the text field will be placed on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNTextBoxField; overload;
    ///<summary>
    ///  Constructor of TextBox field.
    ///</summary>
    ///  <param name="doc">Document where field will be created.</param>
    ///  <param name="rect">Rectangle of the field.</param>
    {class} function init(doc: DNDocument; rect: DNPdf_Rectangle): DNTextBoxField; overload;

  end;

  ///<summary>
  ///  Class representing text box field.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.TextBoxField')]
  DNTextBoxField = interface(DNField)
  ['{FE61B31F-80A5-3D4B-B4D7-7679A424A680}']
  { getters & setters } 

    function get_Multiline: Boolean;
    procedure set_Multiline(value: Boolean);
    function get_SpellCheck: Boolean;
    procedure set_SpellCheck(value: Boolean);
    function get_Scrollable: Boolean;
    procedure set_Scrollable(value: Boolean);
    function get_ForceCombs: Boolean;
    procedure set_ForceCombs(value: Boolean);
    function get_MaxLen: Int32;
    procedure set_MaxLen(value: Int32);
    function get_TextVerticalAlignment: DNVerticalAlignment;
    procedure set_TextVerticalAlignment(value: DNVerticalAlignment);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds image into the field resources an draws it.
    ///</summary>
    ///  <param name="image">
    ///  Image to add into text field.
    ///</param>
    procedure AddImage(image: DDN.System.Drawing.DNImage);
    ///<summary>
    ///  Adds barcode 128 into the field.
    ///  Field value will be changed onto the code and field become read only.
    ///</summary>
    ///  <param name="code">
    ///  The text to generate barcode 128.
    ///</param>
    procedure AddBarcode(code: string);
    ///<summary>
    ///  Recaculates all calculated fields on the form.
    ///</summary>
    ///<returns>true if field value was changed during recalculation.</returns>
    function Recalculate: Boolean;
    ///<summary>
    ///  Copies subfields of this field into array starting from specified index.
    ///</summary>
    ///  <param name="array">Array where field must be copied.</param>
    ///  <param name="index">Starting index where fields will be copied.</param>
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    ///<summary>
    ///  Returns enumerator of contained fields.
    ///</summary>
    ///<returns>Enumerator.</returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    ///<summary>
    ///  Removes this field and place its value directly on the page.
    ///</summary>
    procedure Flatten;
    ///<summary>
    ///  Set position of the field.
    ///</summary>
    ///  <param name="point">Point where field should be positioned.</param>
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets multiline flag of the field. If Multiline is true field can contain multiple lines of text.
    ///</summary>
    property Multiline: Boolean read get_Multiline write set_Multiline;
    ///<summary>
    ///  Gets or sets spellcheck flag for field. If true field shall be spell checked.
    ///</summary>
    property SpellCheck: Boolean read get_SpellCheck write set_SpellCheck;
    ///<summary>
    ///  Gets or sets scrollable flag of field. If true field can be scrolled.
    ///</summary>
    property Scrollable: Boolean read get_Scrollable write set_Scrollable;
    ///<summary>
    ///  Gets or sets flag which indicates is field divided into spaced positions.
    ///</summary>
    property ForceCombs: Boolean read get_ForceCombs write set_ForceCombs;
    ///<summary>
    ///  Gets or sets maximum length of text in the field.
    ///</summary>
    property MaxLen: Int32 read get_MaxLen write set_MaxLen;
    ///<summary>
    ///  Gets or sets text vertical alignment for annotation.
    ///</summary>
    property TextVerticalAlignment: DNVerticalAlignment read get_TextVerticalAlignment write set_TextVerticalAlignment;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    ///<summary>
    ///  Gets or sets partial name of the field.
    ///</summary>
    property PartialName: string read get_PartialName write set_PartialName;
    ///<summary>
    ///  Gets or sets alternate name of the field (An alternate field
    ///  name that shall be used in place of the actual field name
    ///  wherever the field shall be identified in the user interface).
    ///  Alternate name is used as field tooltip in Adobe Acrobat.
    ///</summary>
    property AlternateName: string read get_AlternateName write set_AlternateName;
    ///<summary>
    ///  Gets or sets mapping name  of the field that shall be used when exporting interactive form field data from the document.
    ///</summary>
    property MappingName: string read get_MappingName write set_MappingName;
    ///<summary>
    ///  Returns true if dictionary is synchronized.
    ///</summary>
    property IsSynchronized: Boolean read get_IsSynchronized;
    ///<summary>
    ///  Gets or sets number of subfields in this field. (For example number of items in radio button field).
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Synchronization object.
    ///</summary>
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    ///<summary>
    ///  Gets or sets boolean value which indicates is this field non-terminal field i.e. group of fields.
    ///</summary>
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    ///<summary>
    ///  Gets or sets index of this anotation on the page.
    ///</summary>
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    ///<summary>
    ///  Gets index of page which contains this field.
    ///</summary>
    property PageIndex: Int32 read get_PageIndex;
    ///<summary>
    ///  Gets or sets the field rectangle.
    ///</summary>
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    ///<summary>
    ///  Property for Generator support. Used when field is added to header or footer. If true, this field will created once and it's appearance will be visible on all pages of the document. If false, separated field will be created for every document page.
    ///</summary>
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    ///<summary>
    ///  Gets or sets tab order of the field.
    ///</summary>
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNTextBoxField = class(TDNGenericImport<DNTextBoxFieldClass, DNTextBoxField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNBarcodeFieldClass = interface(DNTextBoxFieldClass)
  ['{32C6D130-5F94-5E11-AAAD-440E762956CB}']
  { constructors } 

    ///<summary>
    ///  Initializes new instance of the <see cref="T:Aspose.Pdf.Forms.BarcodeField" />
    ///  class.
    ///</summary>
    ///  <param name="page">
    ///  The page where to place new barcode.
    ///</param>
    ///  <param name="rect">
    ///  Barcode sizes given in rectangle.
    ///</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNBarcodeField; overload;
    ///<summary>
    ///  Initializes new instance of the <see cref="T:Aspose.Pdf.Forms.BarcodeField" />
    ///  class.
    ///</summary>
    ///  <param name="doc">Document where field will be created.</param>
    ///  <param name="rect">Rectangle where field will be placed on the page.</param>
    {class} function init(doc: DNDocument; rect: DNPdf_Rectangle): DNBarcodeField; overload;

  end;

  ///<summary>
  ///  Class represents barcode field.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.BarcodeField')]
  DNBarcodeField = interface(DNTextBoxField)
  ['{7921CDA0-BB00-3693-B834-B5F39AE14521}']
  { getters & setters } 

    function get_Resolution: Int32;
    function get_Caption: string;
    function get_Symbology: DNSymbology;
    function get_XSymWidth: Int32;
    function get_XSymHeight: Int32;
    function get_ECC: Int32;
    function get_Multiline: Boolean;
    procedure set_Multiline(value: Boolean);
    function get_SpellCheck: Boolean;
    procedure set_SpellCheck(value: Boolean);
    function get_Scrollable: Boolean;
    procedure set_Scrollable(value: Boolean);
    function get_ForceCombs: Boolean;
    procedure set_ForceCombs(value: Boolean);
    function get_MaxLen: Int32;
    procedure set_MaxLen(value: Int32);
    function get_TextVerticalAlignment: DNVerticalAlignment;
    procedure set_TextVerticalAlignment(value: DNVerticalAlignment);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds image into the field resources an draws it.
    ///</summary>
    ///  <param name="image">
    ///  Image to add into text field.
    ///</param>
    procedure AddImage(image: DDN.System.Drawing.DNImage);
    ///<summary>
    ///  Adds barcode 128 into the field.
    ///  Field value will be changed onto the code and field become read only.
    ///</summary>
    ///  <param name="code">
    ///  The text to generate barcode 128.
    ///</param>
    procedure AddBarcode(code: string);
    function Recalculate: Boolean;
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    procedure Flatten;
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the resolution, in dots-per-inch (dpi), at which the barcode object is rendered.
    ///</summary>
    property Resolution: Int32 read get_Resolution;
    ///<summary>
    ///  Gets the caption of the barcode object.
    ///</summary>
    property Caption: string read get_Caption;
    ///<summary>
    ///  Specifies which barcode or glyph technology is to be used on this annotation,
    ///  see <see cref="P:Aspose.Pdf.Forms.BarcodeField.Symbology" />
    ///  for details.
    ///</summary>
    property Symbology: DNSymbology read get_Symbology;
    ///<summary>
    ///  Gets The horizontal distance, in pixels, between two barcode modules.
    ///</summary>
    property XSymWidth: Int32 read get_XSymWidth;
    ///<summary>
    ///  Gets the the vertical distance between two barcode modules, measured in pixels.
    ///  The ratio XSymHeight/XSymWidth shall be an integer value.
    ///  For PDF417, the acceptable ratio range is from 1 to 4. For QRCode and DataMatrix,
    ///  this ratio shall always be 1
    ///</summary>
    property XSymHeight: Int32 read get_XSymHeight;
    ///<summary>
    ///  Gets an integer value representing the error correction coefficient.
    ///  For PDF417, shall be from 0 to 8. For QRCode, shall be from 0 to 3
    ///  (0 for �L�, 1 for �M�, 2 for �Q�, and 3 for �H�).
    ///</summary>
    property ECC: Int32 read get_ECC;
    ///<summary>
    ///  Gets or sets multiline flag of the field. If Multiline is true field can contain multiple lines of text.
    ///</summary>
    property Multiline: Boolean read get_Multiline write set_Multiline;
    ///<summary>
    ///  Gets or sets spellcheck flag for field. If true field shall be spell checked.
    ///</summary>
    property SpellCheck: Boolean read get_SpellCheck write set_SpellCheck;
    ///<summary>
    ///  Gets or sets scrollable flag of field. If true field can be scrolled.
    ///</summary>
    property Scrollable: Boolean read get_Scrollable write set_Scrollable;
    ///<summary>
    ///  Gets or sets flag which indicates is field divided into spaced positions.
    ///</summary>
    property ForceCombs: Boolean read get_ForceCombs write set_ForceCombs;
    ///<summary>
    ///  Gets or sets maximum length of text in the field.
    ///</summary>
    property MaxLen: Int32 read get_MaxLen write set_MaxLen;
    ///<summary>
    ///  Gets or sets text vertical alignment for annotation.
    ///</summary>
    property TextVerticalAlignment: DNVerticalAlignment read get_TextVerticalAlignment write set_TextVerticalAlignment;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    property PartialName: string read get_PartialName write set_PartialName;
    property AlternateName: string read get_AlternateName write set_AlternateName;
    property MappingName: string read get_MappingName write set_MappingName;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property Count: Int32 read get_Count;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    property PageIndex: Int32 read get_PageIndex;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNBarcodeField = class(TDNGenericImport<DNBarcodeFieldClass, DNBarcodeField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNFileSelectBoxFieldClass = interface(DNTextBoxFieldClass)
  ['{84D177F9-F983-51D4-A1A5-260EF5EEAE65}']
  end;

  ///<summary>
  ///  Field for file select box element.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.FileSelectBoxField')]
  DNFileSelectBoxField = interface(DNTextBoxField)
  ['{9D96EABF-2CF5-3315-919E-9A248B53EBCE}']
  { getters & setters } 

    function get_Multiline: Boolean;
    procedure set_Multiline(value: Boolean);
    function get_SpellCheck: Boolean;
    procedure set_SpellCheck(value: Boolean);
    function get_Scrollable: Boolean;
    procedure set_Scrollable(value: Boolean);
    function get_ForceCombs: Boolean;
    procedure set_ForceCombs(value: Boolean);
    function get_MaxLen: Int32;
    procedure set_MaxLen(value: Int32);
    function get_TextVerticalAlignment: DNVerticalAlignment;
    procedure set_TextVerticalAlignment(value: DNVerticalAlignment);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds image into the field resources an draws it.
    ///</summary>
    ///  <param name="image">
    ///  Image to add into text field.
    ///</param>
    procedure AddImage(image: DDN.System.Drawing.DNImage);
    ///<summary>
    ///  Adds barcode 128 into the field.
    ///  Field value will be changed onto the code and field become read only.
    ///</summary>
    ///  <param name="code">
    ///  The text to generate barcode 128.
    ///</param>
    procedure AddBarcode(code: string);
    function Recalculate: Boolean;
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    procedure Flatten;
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets multiline flag of the field. If Multiline is true field can contain multiple lines of text.
    ///</summary>
    property Multiline: Boolean read get_Multiline write set_Multiline;
    ///<summary>
    ///  Gets or sets spellcheck flag for field. If true field shall be spell checked.
    ///</summary>
    property SpellCheck: Boolean read get_SpellCheck write set_SpellCheck;
    ///<summary>
    ///  Gets or sets scrollable flag of field. If true field can be scrolled.
    ///</summary>
    property Scrollable: Boolean read get_Scrollable write set_Scrollable;
    ///<summary>
    ///  Gets or sets flag which indicates is field divided into spaced positions.
    ///</summary>
    property ForceCombs: Boolean read get_ForceCombs write set_ForceCombs;
    ///<summary>
    ///  Gets or sets maximum length of text in the field.
    ///</summary>
    property MaxLen: Int32 read get_MaxLen write set_MaxLen;
    ///<summary>
    ///  Gets or sets text vertical alignment for annotation.
    ///</summary>
    property TextVerticalAlignment: DNVerticalAlignment read get_TextVerticalAlignment write set_TextVerticalAlignment;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    property PartialName: string read get_PartialName write set_PartialName;
    property AlternateName: string read get_AlternateName write set_AlternateName;
    property MappingName: string read get_MappingName write set_MappingName;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property Count: Int32 read get_Count;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    property PageIndex: Int32 read get_PageIndex;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNFileSelectBoxField = class(TDNGenericImport<DNFileSelectBoxFieldClass, DNFileSelectBoxField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNPasswordBoxFieldClass = interface(DNTextBoxFieldClass)
  ['{7E223D52-1DF9-5B0E-8104-04B595903DF3}']
  end;

  ///<summary>
  ///  Class descibes text field for entering password.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.PasswordBoxField')]
  DNPasswordBoxField = interface(DNTextBoxField)
  ['{EEC1A56F-27C3-3FAC-A361-4CEF33213D21}']
  { getters & setters } 

    function get_Multiline: Boolean;
    procedure set_Multiline(value: Boolean);
    function get_SpellCheck: Boolean;
    procedure set_SpellCheck(value: Boolean);
    function get_Scrollable: Boolean;
    procedure set_Scrollable(value: Boolean);
    function get_ForceCombs: Boolean;
    procedure set_ForceCombs(value: Boolean);
    function get_MaxLen: Int32;
    procedure set_MaxLen(value: Int32);
    function get_TextVerticalAlignment: DNVerticalAlignment;
    procedure set_TextVerticalAlignment(value: DNVerticalAlignment);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds image into the field resources an draws it.
    ///</summary>
    ///  <param name="image">
    ///  Image to add into text field.
    ///</param>
    procedure AddImage(image: DDN.System.Drawing.DNImage);
    ///<summary>
    ///  Adds barcode 128 into the field.
    ///  Field value will be changed onto the code and field become read only.
    ///</summary>
    ///  <param name="code">
    ///  The text to generate barcode 128.
    ///</param>
    procedure AddBarcode(code: string);
    function Recalculate: Boolean;
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    procedure Flatten;
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets multiline flag of the field. If Multiline is true field can contain multiple lines of text.
    ///</summary>
    property Multiline: Boolean read get_Multiline write set_Multiline;
    ///<summary>
    ///  Gets or sets spellcheck flag for field. If true field shall be spell checked.
    ///</summary>
    property SpellCheck: Boolean read get_SpellCheck write set_SpellCheck;
    ///<summary>
    ///  Gets or sets scrollable flag of field. If true field can be scrolled.
    ///</summary>
    property Scrollable: Boolean read get_Scrollable write set_Scrollable;
    ///<summary>
    ///  Gets or sets flag which indicates is field divided into spaced positions.
    ///</summary>
    property ForceCombs: Boolean read get_ForceCombs write set_ForceCombs;
    ///<summary>
    ///  Gets or sets maximum length of text in the field.
    ///</summary>
    property MaxLen: Int32 read get_MaxLen write set_MaxLen;
    ///<summary>
    ///  Gets or sets text vertical alignment for annotation.
    ///</summary>
    property TextVerticalAlignment: DNVerticalAlignment read get_TextVerticalAlignment write set_TextVerticalAlignment;
    ///<summary>
    ///  Gets or sets value of the field.
    ///</summary>
    property Value: string read get_Value write set_Value;
    property PartialName: string read get_PartialName write set_PartialName;
    property AlternateName: string read get_AlternateName write set_AlternateName;
    property MappingName: string read get_MappingName write set_MappingName;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property Count: Int32 read get_Count;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    property PageIndex: Int32 read get_PageIndex;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNPasswordBoxField = class(TDNGenericImport<DNPasswordBoxFieldClass, DNPasswordBoxField>) end;

  //-------------namespace: Aspose.Pdf.Forms----------------
  DNRichTextBoxFieldClass = interface(DNTextBoxFieldClass)
  ['{7EF1F3B0-DFF2-5DD2-A553-993A6C44D51A}']
  { constructors } 

    ///<summary>
    ///  Constructor for Rich Text Box  field.
    ///</summary>
    ///  <param name="page">Page where field will be placed.</param>
    ///  <param name="rect">Position of the field on the page.</param>
    {class} function init(page: DNPage; rect: DNPdf_Rectangle): DNRichTextBoxField;

  end;

  ///<summary>
  ///  Class describes rich text editor component.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Forms.RichTextBoxField')]
  DNRichTextBoxField = interface(DNTextBoxField)
  ['{68380C33-11C3-3635-835E-0AA611EEAF64}']
  { getters & setters } 

    function get_Style: string;
    procedure set_Style(value: string);
    function get_RichTextValue: string;
    procedure set_RichTextValue(value: string);
    function get_FormattedValue: string;
    procedure set_FormattedValue(value: string);
    function get_Value: string;
    procedure set_Value(value: string);
    function get_Justify: DNJustification;
    procedure set_Justify(value: DNJustification);
    function get_Multiline: Boolean;
    procedure set_Multiline(value: Boolean);
    function get_SpellCheck: Boolean;
    procedure set_SpellCheck(value: Boolean);
    function get_Scrollable: Boolean;
    procedure set_Scrollable(value: Boolean);
    function get_ForceCombs: Boolean;
    procedure set_ForceCombs(value: Boolean);
    function get_MaxLen: Int32;
    procedure set_MaxLen(value: Int32);
    function get_TextVerticalAlignment: DNVerticalAlignment;
    procedure set_TextVerticalAlignment(value: DNVerticalAlignment);
    function get_PartialName: string;
    procedure set_PartialName(value: string);
    function get_AlternateName: string;
    procedure set_AlternateName(value: string);
    function get_MappingName: string;
    procedure set_MappingName(value: string);
    function get_IsSynchronized: Boolean;
    function get_Count: Int32;
    function get_SyncRoot: DDN.mscorlib.DNObject;
    function get_IsGroup: Boolean;
    function get_Item(name: string): DNWidgetAnnotation; overload;
    function get_Item(index: Int32): DNWidgetAnnotation; overload;
    function get_AnnotationIndex: Int32;
    procedure set_AnnotationIndex(value: Int32);
    function get_PageIndex: Int32;
    function get_Rect: DNPdf_Rectangle;
    procedure set_Rect(value: DNPdf_Rectangle);
    function get_IsSharedField: Boolean;
    procedure set_IsSharedField(value: Boolean);
    function get_TabOrder: Int32;
    procedure set_TabOrder(value: Int32);
    function get_OnActivated: DNPdfAction;
    procedure set_OnActivated(value: DNPdfAction);
    function get_Actions: DNAnnotationActionCollection;
    function get_Highlighting: DNHighlightingMode;
    procedure set_Highlighting(value: DNHighlightingMode);
    function get_Parent: DNField;
    function get_DefaultAppearance: DNDefaultAppearance;
    procedure set_DefaultAppearance(value: DNDefaultAppearance);
    function get_ReadOnly: Boolean;
    procedure set_ReadOnly(value: Boolean);
    function get_Required: Boolean;
    procedure set_Required(value: Boolean);
    function get_Exportable: Boolean;
    procedure set_Exportable(value: Boolean);
    function get_AnnotationType: DNAnnotationType;
    function get_Flags: DNAnnotationFlags;
    procedure set_Flags(value: DNAnnotationFlags);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_Contents: string;
    procedure set_Contents(value: string);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_Modified: DDN.mscorlib.DNDateTime;
    procedure set_Modified(value: DDN.mscorlib.DNDateTime);
    function get_Color: DNColor;
    procedure set_Color(value: DNColor);
    function get_Border: DNBorder;
    procedure set_Border(value: DNBorder);
    function get_ActiveState: string;
    procedure set_ActiveState(value: string);
    function get_Characteristics: DNCharacteristics;
    function get_States: DNAppearanceDictionary;
    function get_Alignment: DNTextAlignment;
    procedure set_Alignment(value: DNTextAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_TextHorizontalAlignment: DNHorizontalAlignment;
    procedure set_TextHorizontalAlignment(value: DNHorizontalAlignment);
    function get_FullName: string;
    function get_Appearance: DNAppearanceDictionary;
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Adds image into the field resources an draws it.
    ///</summary>
    ///  <param name="image">
    ///  Image to add into text field.
    ///</param>
    procedure AddImage(image: DDN.System.Drawing.DNImage);
    ///<summary>
    ///  Adds barcode 128 into the field.
    ///  Field value will be changed onto the code and field become read only.
    ///</summary>
    ///  <param name="code">
    ///  The text to generate barcode 128.
    ///</param>
    procedure AddBarcode(code: string);
    function Recalculate: Boolean;
    procedure CopyTo(&array: TArray<DNField>; index: Int32);
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNWidgetAnnotation>;
    procedure Flatten;
    procedure SetPosition(point: DNPoint);
    procedure Accept(visitor: DNAnnotationSelector);
    function GetRectangle(considerRotation: Boolean): DNPdf_Rectangle;
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets default style string of the rich text field.
    ///</summary>
    property Style: string read get_Style write set_Style;
    ///<summary>
    ///  Gets or sets rich text value.
    ///</summary>
    property RichTextValue: string read get_RichTextValue write set_RichTextValue;
    ///<summary>
    ///  Gets or sets formatted rich text value with markup.
    ///</summary>
    property FormattedValue: string read get_FormattedValue write set_FormattedValue;
    ///<summary>
    ///  Value of RichTextField.
    ///</summary>
    property Value: string read get_Value write set_Value;
    ///<summary>
    ///  Gets or sets justification of the rich text box.
    ///</summary>
    property Justify: DNJustification read get_Justify write set_Justify;
    ///<summary>
    ///  Gets or sets multiline flag of the field. If Multiline is true field can contain multiple lines of text.
    ///</summary>
    property Multiline: Boolean read get_Multiline write set_Multiline;
    ///<summary>
    ///  Gets or sets spellcheck flag for field. If true field shall be spell checked.
    ///</summary>
    property SpellCheck: Boolean read get_SpellCheck write set_SpellCheck;
    ///<summary>
    ///  Gets or sets scrollable flag of field. If true field can be scrolled.
    ///</summary>
    property Scrollable: Boolean read get_Scrollable write set_Scrollable;
    ///<summary>
    ///  Gets or sets flag which indicates is field divided into spaced positions.
    ///</summary>
    property ForceCombs: Boolean read get_ForceCombs write set_ForceCombs;
    ///<summary>
    ///  Gets or sets maximum length of text in the field.
    ///</summary>
    property MaxLen: Int32 read get_MaxLen write set_MaxLen;
    ///<summary>
    ///  Gets or sets text vertical alignment for annotation.
    ///</summary>
    property TextVerticalAlignment: DNVerticalAlignment read get_TextVerticalAlignment write set_TextVerticalAlignment;
    property PartialName: string read get_PartialName write set_PartialName;
    property AlternateName: string read get_AlternateName write set_AlternateName;
    property MappingName: string read get_MappingName write set_MappingName;
    property IsSynchronized: Boolean read get_IsSynchronized;
    property Count: Int32 read get_Count;
    property SyncRoot: DDN.mscorlib.DNObject read get_SyncRoot;
    property IsGroup: Boolean read get_IsGroup;
    property Item[name: string]: DNWidgetAnnotation read get_Item; default;
    property Item[index: Int32]: DNWidgetAnnotation read get_Item; default;
    property AnnotationIndex: Int32 read get_AnnotationIndex write set_AnnotationIndex;
    property PageIndex: Int32 read get_PageIndex;
    property Rect: DNPdf_Rectangle read get_Rect write set_Rect;
    property IsSharedField: Boolean read get_IsSharedField write set_IsSharedField;
    property TabOrder: Int32 read get_TabOrder write set_TabOrder;
    property OnActivated: DNPdfAction read get_OnActivated write set_OnActivated;
    property Actions: DNAnnotationActionCollection read get_Actions;
    property Highlighting: DNHighlightingMode read get_Highlighting write set_Highlighting;
    property Parent: DNField read get_Parent;
    property DefaultAppearance: DNDefaultAppearance read get_DefaultAppearance write set_DefaultAppearance;
    property ReadOnly: Boolean read get_ReadOnly write set_ReadOnly;
    property Required: Boolean read get_Required write set_Required;
    property Exportable: Boolean read get_Exportable write set_Exportable;
    property AnnotationType: DNAnnotationType read get_AnnotationType;
    property Flags: DNAnnotationFlags read get_Flags write set_Flags;
    property Width: Double read get_Width write set_Width;
    property Height: Double read get_Height write set_Height;
    property Contents: string read get_Contents write set_Contents;
    property Name: string read get_Name write set_Name;
    property Modified: DDN.mscorlib.DNDateTime read get_Modified write set_Modified;
    property Color: DNColor read get_Color write set_Color;
    property Border: DNBorder read get_Border write set_Border;
    property ActiveState: string read get_ActiveState write set_ActiveState;
    property Characteristics: DNCharacteristics read get_Characteristics;
    property States: DNAppearanceDictionary read get_States;
    property Alignment: DNTextAlignment read get_Alignment write set_Alignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property TextHorizontalAlignment: DNHorizontalAlignment read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    property FullName: string read get_FullName;
    property Appearance: DNAppearanceDictionary read get_Appearance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNRichTextBoxField = class(TDNGenericImport<DNRichTextBoxFieldClass, DNRichTextBoxField>) end;

  //-------------namespace: Aspose.Pdf.Drawing----------------
  DNGraphClass = interface(DNBaseParagraphClass)
  ['{2075B09A-6BBE-501D-8815-E9C611B4DCE5}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.Drawing.Graph" />
    ///  class.
    ///</summary>
    ///  <param name="width">The width of the graph.</param>
    ///  <param name="height">The height of the graph.</param>
    {class} function init(width: Single; height: Single): DNGraph;

  end;

  ///<summary>
  ///  Represents graph - graphics generator paragraph.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Drawing.Graph')]
  DNGraph = interface(DNBaseParagraph)
  ['{AF3998C8-1C70-32BA-AA19-2C29CCE45668}']
  { getters & setters } 

    function get_GraphInfo: DNGraphInfo;
    procedure set_GraphInfo(value: DNGraphInfo);
    function get_Border: DNBorderInfo;
    procedure set_Border(value: DNBorderInfo);
    function get_IsChangePosition: Boolean;
    procedure set_IsChangePosition(value: Boolean);
    function get_Left: Double;
    procedure set_Left(value: Double);
    function get_Top: Double;
    procedure set_Top(value: Double);
    function get_Shapes: DDN.mscorlib.DNList<DNShape>;
    procedure set_Shapes(value: DDN.mscorlib.DNList<DNShape>);
    function get_Title: DNTextFragment;
    procedure set_Title(value: DNTextFragment);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Clone the graph.
    ///</summary>
    ///<returns>The cloned object</returns>
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets a <see cref="P:Aspose.Pdf.Drawing.Graph.GraphInfo" />
    ///  object that indicates the graph info,such as color,
    ///  line width,etc.
    ///</summary>
    property GraphInfo: DNGraphInfo read get_GraphInfo write set_GraphInfo;
    ///<summary>
    ///  Gets or sets the border.
    ///</summary>
    property Border: DNBorderInfo read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets change curret position after process paragraph.(default true)
    ///</summary>
    property IsChangePosition: Boolean read get_IsChangePosition write set_IsChangePosition;
    ///<summary>
    ///  Gets or sets the table left coordinate.
    ///</summary>
    property Left: Double read get_Left write set_Left;
    ///<summary>
    ///  Gets or sets the table top coordinate.
    ///</summary>
    property Top: Double read get_Top write set_Top;
    ///<summary>
    ///  Gets or sets a <see cref="P:Aspose.Pdf.Drawing.Graph.Shapes" />
    ///  collection that indicates all shapes in the graph.
    ///</summary>
    property Shapes: DDN.mscorlib.DNList<DNShape> read get_Shapes write set_Shapes;
    ///<summary>
    ///  Gets or sets a string value that indicates the title of the graph.
    ///</summary>
    property Title: DNTextFragment read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a float value that indicates the graph width.
    ///  The unit is point.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets or sets a float value that indicates the graph height.
    ///  The unit is point.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets a vertical alignment of paragraph
    ///</summary>
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    ///<summary>
    ///  Gets or sets a horizontal alignment of paragraph
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets a outer margin for paragraph (for pdf generation)
    ///</summary>
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether this paragraph will be at next column.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether current paragraph remains in the same page along with next paragraph.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    ///<summary>
    ///  Gets or sets a bool value that force this paragraph generates at new page.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    ///<summary>
    ///  Gets or sets a paragraph is inline.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    ///<summary>
    ///  Gets or sets the fragment hyperlink(for pdf generator).
    ///</summary>
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    ///<summary>
    ///  Gets or sets a int value that indicates the Z-order of the graph. A graph with larger ZIndex
    ///  will be placed over the graph with smaller ZIndex. ZIndex can be negative. Graph with negative
    ///  ZIndex will be placed behind the text in the page.
    ///</summary>
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNGraph = class(TDNGenericImport<DNGraphClass, DNGraph>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNFloatingBoxClass = interface(DNBaseParagraphClass)
  ['{690F9EDC-520C-581E-A703-A3D49A568FC3}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.FloatingBox" />
    ///  class with specified width and height.
    ///</summary>
    ///  <param name="width">The width of the box.</param>
    ///  <param name="height">The height of the box.</param>
    {class} function init(width: Single; height: Single): DNFloatingBox; overload;
    ///<summary>
    ///  Initializes a new instance of the <see cref="T:Aspose.Pdf.FloatingBox" />
    ///  class.
    ///</summary>
    {class} function init: DNFloatingBox; overload;

  end;

  ///  Represents a FloatingBox in a Pdf document. FloatingBox is custom positioned.
  [DNTypeName('Aspose.Pdf.FloatingBox')]
  DNFloatingBox = interface(DNBaseParagraph)
  ['{3CF32F15-9346-3D33-B955-6CC04F216430}']
  { getters & setters } 

    function get_ColumnInfo: DNColumnInfo;
    procedure set_ColumnInfo(value: DNColumnInfo);
    function get_Width: Double;
    procedure set_Width(value: Double);
    function get_Height: Double;
    procedure set_Height(value: Double);
    function get_IsNeedRepeating: Boolean;
    procedure set_IsNeedRepeating(value: Boolean);
    function get_Paragraphs: DNParagraphs;
    procedure set_Paragraphs(value: DNParagraphs);
    function get_Border: DNBorderInfo;
    procedure set_Border(value: DNBorderInfo);
    function get_BackgroundColor: DNColor;
    procedure set_BackgroundColor(value: DNColor);
    function get_BackgroundImage: DNImage;
    procedure set_BackgroundImage(value: DNImage);
    function get_Padding: DNMarginInfo;
    procedure set_Padding(value: DNMarginInfo);
    function get_Left: Double;
    procedure set_Left(value: Double);
    function get_Top: Double;
    procedure set_Top(value: Double);
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Clones a new <see cref="T:Aspose.Pdf.FloatingBox" />
    ///  object. Paragraphs in the floating box are not cloned.
    ///</summary>
    ///<returns>The new <see cref="T:Aspose.Pdf.FloatingBox" />
    ///  object.</returns>
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets a column info
    ///</summary>
    property ColumnInfo: DNColumnInfo read get_ColumnInfo write set_ColumnInfo;
    ///<summary>
    ///  Gets or sets a float value that indicates the width of the floating box.
    ///</summary>
    property Width: Double read get_Width write set_Width;
    ///<summary>
    ///  Gets or sets a float value that indicates the height of the floating box.
    ///</summary>
    property Height: Double read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether the paragraph need to be repeated on next page.
    ///  Default value is false.The attribute is only valid when the paragraph itself and the object its ReferenceParagraphID referred to both are included in RepeatingRows.
    ///</summary>
    property IsNeedRepeating: Boolean read get_IsNeedRepeating write set_IsNeedRepeating;
    ///<summary>
    ///  Gets or sets a <see cref="P:Aspose.Pdf.FloatingBox.Paragraphs" />
    ///  collection that indicates all paragraphs in the cell.
    ///</summary>
    property Paragraphs: DNParagraphs read get_Paragraphs write set_Paragraphs;
    ///<summary>
    ///  Gets or sets a <see cref="T:Aspose.Pdf.BorderInfo" />
    ///  object that indicates the border info of the floating box.
    ///</summary>
    property Border: DNBorderInfo read get_Border write set_Border;
    ///<summary>
    ///  Gets or sets a <see cref="T:Aspose.Pdf.Color" />
    ///  object that indicates the background color of the floating box.
    ///</summary>
    property BackgroundColor: DNColor read get_BackgroundColor write set_BackgroundColor;
    ///<summary>
    ///  Gets or sets background image for page (for generator only).
    ///</summary>
    property BackgroundImage: DNImage read get_BackgroundImage write set_BackgroundImage;
    ///<summary>
    ///  Gets or sets a <see cref="T:Aspose.Pdf.MarginInfo" />
    ///  object that indicates the padding of the floating box.
    ///</summary>
    property Padding: DNMarginInfo read get_Padding write set_Padding;
    ///<summary>
    ///  Gets or sets the table left coordinate.
    ///</summary>
    property Left: Double read get_Left write set_Left;
    ///<summary>
    ///  Gets or sets the table top coordinate.
    ///</summary>
    property Top: Double read get_Top write set_Top;
    ///<summary>
    ///  Gets or sets a vertical alignment of paragraph
    ///</summary>
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    ///<summary>
    ///  Gets or sets a horizontal alignment of paragraph
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets a outer margin for paragraph (for pdf generation)
    ///</summary>
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether this paragraph will be at next column.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether current paragraph remains in the same page along with next paragraph.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    ///<summary>
    ///  Gets or sets a bool value that force this paragraph generates at new page.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    ///<summary>
    ///  Gets or sets a paragraph is inline.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    ///<summary>
    ///  Gets or sets the fragment hyperlink(for pdf generator).
    ///</summary>
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    ///<summary>
    ///  Gets or sets a int value that indicates the Z-order of the graph. A graph with larger ZIndex
    ///  will be placed over the graph with smaller ZIndex. ZIndex can be negative. Graph with negative
    ///  ZIndex will be placed behind the text in the page.
    ///</summary>
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNFloatingBox = class(TDNGenericImport<DNFloatingBoxClass, DNFloatingBox>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNFormattedFragmentClass = interface(DNBaseParagraphClass)
  ['{38D59D25-E234-59EB-8666-08342B250B08}']
  end;

  ///<summary>
  ///  Represents abstract formatted fragment.
  ///</summary>
  [DNTypeName('Aspose.Pdf.FormattedFragment')]
  DNFormattedFragment = interface(DNBaseParagraph)
  ['{C9C363B7-3C9F-3ADF-A776-5EB82B8BA43F}']
  { getters & setters } 

    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Clones this instance.
    ///  Virtual method. Always return null.
    ///</summary>
    ///<returns></returns>
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets a vertical alignment of paragraph
    ///</summary>
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    ///<summary>
    ///  Gets or sets a horizontal alignment of paragraph
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets a outer margin for paragraph (for pdf generation)
    ///</summary>
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether this paragraph will be at next column.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether current paragraph remains in the same page along with next paragraph.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    ///<summary>
    ///  Gets or sets a bool value that force this paragraph generates at new page.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    ///<summary>
    ///  Gets or sets a paragraph is inline.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    ///<summary>
    ///  Gets or sets the fragment hyperlink(for pdf generator).
    ///</summary>
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    ///<summary>
    ///  Gets or sets a int value that indicates the Z-order of the graph. A graph with larger ZIndex
    ///  will be placed over the graph with smaller ZIndex. ZIndex can be negative. Graph with negative
    ///  ZIndex will be placed behind the text in the page.
    ///</summary>
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNFormattedFragment = class(TDNGenericImport<DNFormattedFragmentClass, DNFormattedFragment>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNHtmlFragmentClass = interface(DNFormattedFragmentClass)
  ['{021428F5-F440-586C-8893-DC94357E568C}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the HtmlFragment class.
    ///</summary>
    ///  <param name="text">The fragment text</param>
    {class} function init(text: string): DNHtmlFragment;

  end;

  ///<summary>
  ///  Represents html fragment.
  ///</summary>
  [DNTypeName('Aspose.Pdf.HtmlFragment')]
  DNHtmlFragment = interface(DNFormattedFragment)
  ['{24F23C7B-E9BB-3510-9AAB-1CFE8F66A144}']
  { getters & setters } 

    function get_Rectangle: DDN.System.Drawing.DNRectangleF;
    function get_IsBreakWords: Boolean;
    procedure set_IsBreakWords(value: Boolean);
    function get_TextState: DNTextState;
    procedure set_TextState(value: DNTextState);
    function get_HtmlLoadOptions: DNHtmlLoadOptions;
    procedure set_HtmlLoadOptions(value: DNHtmlLoadOptions);
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets rectangle of the HtmlFragment
    ///</summary>
    property Rectangle: DDN.System.Drawing.DNRectangleF read get_Rectangle;
    ///<summary>
    ///  Gets or sets words break
    ///</summary>
    property IsBreakWords: Boolean read get_IsBreakWords write set_IsBreakWords;
    ///<summary>
    ///  Gets or sets font
    ///</summary>
    property TextState: DNTextState read get_TextState write set_TextState;
    ///<summary>
    ///  Gets or sets HtmlLoadOptions that will be used for loading (and rendering) of HTML into this instance of class.
    ///  Please use it when it's necessary use specific setting for import of HTML for this or that instance
    ///  (f.e when this or that instance should use specific BasePath for imported HTML or should use specific loader of external resources)
    ///  If parameter is default (null), then standard HTML loading options will be used.
    ///</summary>
    property HtmlLoadOptions: DNHtmlLoadOptions read get_HtmlLoadOptions write set_HtmlLoadOptions;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNHtmlFragment = class(TDNGenericImport<DNHtmlFragmentClass, DNHtmlFragment>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNTeXFragmentClass = interface(DNFormattedFragmentClass)
  ['{B2DB5712-83BB-571A-A9CD-5871A9D71C13}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the HtmlFragment class.
    ///</summary>
    ///  <param name="text">The fragment text</param>
    {class} function init(text: string): DNTeXFragment; overload;
    ///<summary>
    ///  Initializes a new instance of the HtmlFragment class.
    ///</summary>
    ///  <param name="text">The fragment text</param>
    ///  <param name="removeIndents">Determines whether not to make indents while typesetting LaTeX fragment</param>
    {class} function init(text: string; removeIndents: Boolean): DNTeXFragment; overload;

  end;

  ///<summary>
  ///  Represents TeX fragment.
  ///</summary>
  [DNTypeName('Aspose.Pdf.TeXFragment')]
  DNTeXFragment = interface(DNFormattedFragment)
  ['{D7050D3D-B7E7-3F84-9101-5784A410AFB4}']
  { getters & setters } 

    function get_TeXLoadOptionsOfInstance: DNTeXLoadOptions;
    procedure set_TeXLoadOptionsOfInstance(value: DNTeXLoadOptions);
    function get_LatexLoadOptionsOfInstance: DNTeXLoadOptions;
    procedure set_LatexLoadOptionsOfInstance(value: DNTeXLoadOptions);
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets TeXLoadOptions that will be used for loading (and rendering) of LaTeX into this instance of class.
    ///  Please use it when it's necessary use specific setting for import of LaTeX for this or that instance
    ///  (f.e when this or that instance should use specific BasePath for imported LaTeX or should use specific loader of external resources)
    ///  If parameter is default (null), then standard LaTeX loading options will be used.
    ///</summary>
    property TeXLoadOptionsOfInstance: DNTeXLoadOptions read get_TeXLoadOptionsOfInstance write set_TeXLoadOptionsOfInstance;
    ///<summary>
    ///  Gets or sets TeXLoadOptions that will be used for loading (and rendering) of LaTeX into this instance of class.
    ///  Please use it when it's necessary use specific setting for import of LaTeX for this or that instance
    ///  (f.e when this or that instance should use specific BasePath for imported LaTeX or should use specific loader of external resources)
    ///  If parameter is default (null), then standard LaTeX loading options will be used.
    ///</summary>
    property LatexLoadOptionsOfInstance: DNTeXLoadOptions read get_LatexLoadOptionsOfInstance write set_LatexLoadOptionsOfInstance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNTeXFragment = class(TDNGenericImport<DNTeXFragmentClass, DNTeXFragment>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNLatexFragmentClass = interface(DNTeXFragmentClass)
  ['{48FA20BA-2A48-5FA3-BA6F-6E68C7025E1F}']
  { constructors } 

    ///<summary>
    ///  Initializes a new instance of the HtmlFragment class.
    ///</summary>
    ///  <param name="text">The fragment text</param>
    {class} function init(text: string): DNLatexFragment; overload;
    ///<summary>
    ///  Initializes a new instance of the HtmlFragment class.
    ///</summary>
    ///  <param name="text">The fragment text</param>
    ///  <param name="removeIndents">Determines whether not to make indents while typesetting LaTeX fragment</param>
    {class} function init(text: string; removeIndents: Boolean): DNLatexFragment; overload;

  end;

  ///<summary>
  ///  Represents TeX fragment.
  ///</summary>
  [DNTypeName('Aspose.Pdf.LatexFragment')]
  DNLatexFragment = interface(DNTeXFragment)
  ['{9FF9FF5D-F251-3960-A299-065B19666B00}']
  { getters & setters } 

    function get_TeXLoadOptionsOfInstance: DNTeXLoadOptions;
    procedure set_TeXLoadOptionsOfInstance(value: DNTeXLoadOptions);
    function get_LatexLoadOptionsOfInstance: DNTeXLoadOptions;
    procedure set_LatexLoadOptionsOfInstance(value: DNTeXLoadOptions);
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets TeXLoadOptions that will be used for loading (and rendering) of LaTeX into this instance of class.
    ///  Please use it when it's necessary use specific setting for import of LaTeX for this or that instance
    ///  (f.e when this or that instance should use specific BasePath for imported LaTeX or should use specific loader of external resources)
    ///  If parameter is default (null), then standard LaTeX loading options will be used.
    ///</summary>
    property TeXLoadOptionsOfInstance: DNTeXLoadOptions read get_TeXLoadOptionsOfInstance write set_TeXLoadOptionsOfInstance;
    ///<summary>
    ///  Gets or sets TeXLoadOptions that will be used for loading (and rendering) of LaTeX into this instance of class.
    ///  Please use it when it's necessary use specific setting for import of LaTeX for this or that instance
    ///  (f.e when this or that instance should use specific BasePath for imported LaTeX or should use specific loader of external resources)
    ///  If parameter is default (null), then standard LaTeX loading options will be used.
    ///</summary>
    property LatexLoadOptionsOfInstance: DNTeXLoadOptions read get_LatexLoadOptionsOfInstance write set_LatexLoadOptionsOfInstance;
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNLatexFragment = class(TDNGenericImport<DNLatexFragmentClass, DNLatexFragment>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNImageClass = interface(DNBaseParagraphClass)
  ['{8B40B7EA-257E-51F0-90D1-FF2EF50B1D5C}']
  { constructors } 

    {class} function init: DNImage;

  { static methods } 

    {class} function GetMimeType(i: DDN.System.Drawing.DNImage): string;

  end;

  ///<summary>
  ///  Represents image.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Image')]
  DNImage = interface(DNBaseParagraph)
  ['{88B5521F-2DA7-3430-A982-76624437F801}']
  { getters & setters } 

    function get_File: string;
    procedure set_File(value: string);
    function get_FixWidth: Double;
    procedure set_FixWidth(value: Double);
    function get_FixHeight: Double;
    procedure set_FixHeight(value: Double);
    function get_FileType: DNImageFileType;
    procedure set_FileType(value: DNImageFileType);
    function get_ImageScale: Double;
    procedure set_ImageScale(value: Double);
    function get_ImageStream: DDN.mscorlib.DNStream;
    procedure set_ImageStream(value: DDN.mscorlib.DNStream);
    function get_IsApplyResolution: Boolean;
    procedure set_IsApplyResolution(value: Boolean);
    function get_IsBlackWhite: Boolean;
    procedure set_IsBlackWhite(value: Boolean);
    function get_Title: DNTextFragment;
    procedure set_Title(value: DNTextFragment);
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Clone the image.
    ///</summary>
    ///<returns>The cloned object</returns>
    function Clone: DDN.mscorlib.DNObject;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the image file.
    ///</summary>
    property &File: string read get_File write set_File;
    ///<summary>
    ///  Gets or sets the image width.
    ///</summary>
    property FixWidth: Double read get_FixWidth write set_FixWidth;
    ///<summary>
    ///  Gets or sets the image height.
    ///</summary>
    property FixHeight: Double read get_FixHeight write set_FixHeight;
    ///<summary>
    ///  Gets or sets the image file type.
    ///</summary>
    property FileType: DNImageFileType read get_FileType write set_FileType;
    ///<summary>
    ///  Gets or sets the image scale.
    ///</summary>
    property ImageScale: Double read get_ImageScale write set_ImageScale;
    ///<summary>
    ///  Gets or sets the image stream.
    ///</summary>
    property ImageStream: DDN.mscorlib.DNStream read get_ImageStream write set_ImageStream;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether the image use resolution during generation
    ///</summary>
    property IsApplyResolution: Boolean read get_IsApplyResolution write set_IsApplyResolution;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether the image is forced to be black-and-white. If TIFF
    ///  image of CCITT subformat is used, this property must be set to true.
    ///</summary>
    property IsBlackWhite: Boolean read get_IsBlackWhite write set_IsBlackWhite;
    ///<summary>
    ///  Gets or sets a string value that indicates the title of the image.
    ///</summary>
    property Title: DNTextFragment read get_Title write set_Title;
    ///<summary>
    ///  Gets or sets a vertical alignment of paragraph
    ///</summary>
    property VerticalAlignment: DNVerticalAlignment read get_VerticalAlignment write set_VerticalAlignment;
    ///<summary>
    ///  Gets or sets a horizontal alignment of paragraph
    ///</summary>
    property HorizontalAlignment: DNHorizontalAlignment read get_HorizontalAlignment write set_HorizontalAlignment;
    ///<summary>
    ///  Gets or sets a outer margin for paragraph (for pdf generation)
    ///</summary>
    property Margin: DNMarginInfo read get_Margin write set_Margin;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether this paragraph will be at next column.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsFirstParagraphInColumn: Boolean read get_IsFirstParagraphInColumn write set_IsFirstParagraphInColumn;
    ///<summary>
    ///  Gets or sets a bool value that indicates whether current paragraph remains in the same page along with next paragraph.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsKeptWithNext: Boolean read get_IsKeptWithNext write set_IsKeptWithNext;
    ///<summary>
    ///  Gets or sets a bool value that force this paragraph generates at new page.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInNewPage: Boolean read get_IsInNewPage write set_IsInNewPage;
    ///<summary>
    ///  Gets or sets a paragraph is inline.
    ///  Default is false.(for pdf generation)
    ///</summary>
    property IsInLineParagraph: Boolean read get_IsInLineParagraph write set_IsInLineParagraph;
    ///<summary>
    ///  Gets or sets the fragment hyperlink(for pdf generator).
    ///</summary>
    property Hyperlink: DNHyperlink read get_Hyperlink write set_Hyperlink;
    ///<summary>
    ///  Gets or sets a int value that indicates the Z-order of the graph. A graph with larger ZIndex
    ///  will be placed over the graph with smaller ZIndex. ZIndex can be negative. Graph with negative
    ///  ZIndex will be placed behind the text in the page.
    ///</summary>
    property ZIndex: Int32 read get_ZIndex write set_ZIndex;
  end;

  TDNImage = class(TDNGenericImport<DNImageClass, DNImage>) end;

  //-------------namespace: Aspose.Pdf----------------
  DNTableClass = interface(DNBaseParagraphClass)
  ['{A9563D97-3AB0-58F9-9D5F-4CEA126EE95D}']
  { constructors } 

    {class} function init: DNTable;

  end;

  ///<summary>
  ///  Represents a table that can be added to the page.
  ///</summary>
  [DNTypeName('Aspose.Pdf.Table')]
  DNTable = interface(DNBaseParagraph)
  ['{F0ACE9BA-A737-3BA9-B621-D6E862413415}']
  { getters & setters } 

    function get_BackgroundColor: DNColor;
    procedure set_BackgroundColor(value: DNColor);
    function get_BreakText: DNTextFragment;
    procedure set_BreakText(value: DNTextFragment);
    function get_CornerStyle: DNBorderCornerStyle;
    procedure set_CornerStyle(value: DNBorderCornerStyle);
    function get_RepeatingRowsStyle: DNTextState;
    procedure set_RepeatingRowsStyle(value: DNTextState);
    function get_RepeatingColumnsCount: Int32;
    procedure set_RepeatingColumnsCount(value: Int32);
    function get_RepeatingRowsCount: Int32;
    procedure set_RepeatingRowsCount(value: Int32);
    function get_ColumnWidths: string;
    procedure set_ColumnWidths(value: string);
    function get_Broken: DNTableBroken;
    procedure set_Broken(value: DNTableBroken);
    function get_DefaultCellBorder: DNBorderInfo;
    procedure set_DefaultCellBorder(value: DNBorderInfo);
    function get_DefaultColumnWidth: string;
    procedure set_DefaultColumnWidth(value: string);
    function get_Rows: DNRows;
    function get_Border: DNBorderInfo;
    procedure set_Border(value: DNBorderInfo);
    function get_DefaultCellPadding: DNMarginInfo;
    procedure set_DefaultCellPadding(value: DNMarginInfo);
    function get_DefaultCellTextState: DNTextState;
    procedure set_DefaultCellTextState(value: DNTextState);
    function get_Alignment: DNHorizontalAlignment;
    procedure set_Alignment(value: DNHorizontalAlignment);
    function get_Left: Single;
    procedure set_Left(value: Single);
    function get_Top: Single;
    procedure set_Top(value: Single);
    function get_IsBroken: Boolean;
    procedure set_IsBroken(value: Boolean);
    function get_IsBordersIncluded: Boolean;
    procedure set_IsBordersIncluded(value: Boolean);
    function get_ColumnAdjustment: DNColumnAdjustment;
    procedure set_ColumnAdjustment(value: DNColumnAdjustment);
    function get_VerticalAlignment: DNVerticalAlignment;
    procedure set_VerticalAlignment(value: DNVerticalAlignment);
    function get_HorizontalAlignment: DNHorizontalAlignment;
    procedure set_HorizontalAlignment(value: DNHorizontalAlignment);
    function get_Margin: DNMarginInfo;
    procedure set_Margin(value: DNMarginInfo);
    function get_IsFirstParagraphInColumn: Boolean;
    procedure set_IsFirstParagraphInColumn(value: Boolean);
    function get_IsKeptWithNext: Boolean;
    procedure set_IsKeptWithNext(value: Boolean);
    function get_IsInNewPage: Boolean;
    procedure set_IsInNewPage(value: Boolean);
    function get_IsInLineParagraph: Boolean;
    procedure set_IsInLineParagraph(value: Boolean);
    function get_Hyperlink: DNHyperlink;
    procedure set_Hyperlink(value: DNHyperlink);
    function get_ZIndex: Int32;
    procedure set_ZIndex(value: Int32);

  { methods } 

    ///<summary>
    ///  Get width.
    ///</summary>
    ///<returns>The table width</returns>
    function GetWidth: Double;
    ///<summary>
    ///  Get height.
    ///</summary>
    ///<returns>The table height</returns>
    function GetHeight: Double;
    ///<summary>
    ///  Set height.
    ///</summary>
    ///  <param name="colNumber">The column number.</param>
    ///  <param name="textState">The text state for column.</param>
    procedure SetColumnTextState(colNumber: Int32; textState: DNTextState);
    ///<summary>
    ///  Imports one-dimensional array of data into table. Import goes one cell per each array's item and
    ///  starts from row and column defined in parameters. During import, if detected that necessary rows
    ///  are still absent(i.e. target table is too small to absorb all data), necessary rows will be created
    ///</summary>
    ///  <param name="importedArray">imported data, nulls will be imported as empty strings</param>
    ///  <param name="firstFilledRow">define number of first target row in target table from wich import will start.
    ///  If amount of rows in target table less then required, missing rows will be created first.
    ///</param>
    ///  <param name="firstFilledColumn">specifies number of first target column in target table , column must be present in target table before start of import </param>
    ///  <param name="isLeftColumnsFilled">If 'isLeftColumnsFilled'=false, then in second and all subsequent filled rows cells that are on the left hand from
    ///  firstFilledColumn will be skipped</param>
    procedure ImportArray(importedArray: TArray<DDN.mscorlib.DNObject>; firstFilledRow: Int32; firstFilledColumn: Int32; isLeftColumnsFilled: Boolean);
    ///<summary>
    ///  Imports data from System.Data.DataTable into Aspose.Pdf.Table
    ///</summary>
    ///  <param name="importedDataTable"> source instance of System.Data.DataTable  </param>
    ///  <param name="isColumnNamesImported"> specifies whether column names will be imported as first row</param>
    ///  <param name="firstFilledRow"> specifies zero based number of first row in target table from which import will start, if row with such  number(and some previous rows) are absent in target table, they will be created first</param>
    ///  <param name="firstFilledColumn">specifies number of first target column in target table , column must be present in target table before start of import </param>
    procedure ImportDataTable(importedDataTable: DDN.System.Data.DNDataTable; isColumnNamesImported: Boolean; firstFilledRow: Int32; firstFilledColumn: Int32); overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  object into the table.
    ///</summary>
    ///  <param name="importedDataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="isColumnNamesShown">Specifies whether the column names of the source datatable will be
    ///  imported as first row.</param>
    ///  <param name="firstFilledRow"> specifies zero based number of first row in target table from which import will start, if row with such  number(and some previous rows) are absent in target table, they will be created first</param>
    ///  <param name="firstFilledColumn">specifies number of first target column in target table , column must be present in target table before start of import </param>
    ///  <param name="maxRows">Maximum amount of rows to be imported from source table.</param>
    ///  <param name="maxColumns">Maximum amount of columns to be imported from source table.</param>
    ///  <param name="isHtmlSupported">Specifies whether the text is html string.</param>
    procedure ImportDataTable(importedDataTable: DDN.System.Data.DNDataTable; isColumnNamesShown: Boolean; firstFilledRow: Int32; firstFilledColumn: Byte; maxRows: Int32; maxColumns: Int32; isHtmlSupported: Boolean); overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  object, but not as whole entity. Only specified rows and columns are imported.
    ///</summary>
    ///  <param name="importedDataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="sourceRowList">The array of numbers of rows in source <see cref="T:System.Data.DataTable" />
    ///  object that must be imported. List must be not null and must contain only numbers of existing rows, otherwise exception will be thrown.</param>
    ///  <param name="sourceColumnList">The array of numbers of columns in source <see cref="T:System.Data.DataTable" />
    ///  object that must be imported. List must be not null and must contain only numbers of existing columns, otherwise exception will be thrown.</param>
    ///  <param name="firstFilledRow">The zero based row number of the first cell in targer table from which import will start.
    ///  If target table does not contain that row, it (and all previous if necessary) will be created</param>
    ///  <param name="firstFilledColumn">The zero based column number of the first cell in targer table from which import will start. The target table must contain that column befor import starts, otherwise exception will be thrown.</param>
    ///  <param name="showColumnNamesAsFirstRow">Specifies whether the column names of source datatable will be imported as first row.</param>
    ///  <param name="isHtmlSupported">Specifies whether the text is html string.</param>
    procedure ImportDataTable(importedDataTable: DDN.System.Data.DNDataTable; sourceRowList: TArray<Int32>; sourceColumnList: TArray<Int32>; firstFilledRow: Int32; firstFilledColumn: Int32; showColumnNamesAsFirstRow: Boolean; isHtmlSupported: Boolean); overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  object with given rows and columns into the table.
    ///</summary>
    ///  <param name="webDataGrid">The <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  object to be imported.</param>
    ///  <param name="firstFilledRow">The zero based row number of the first cell in targer table from which import will start.
    ///  If target table does not contain that row, it (and all previous if necessary) will be created</param>
    ///  <param name="firstFilledColumn">The zero based column number of the first cell in targer table from which import will start.
    ///  The target table must contain that column before import starts, otherwise exception will be thrown.
    ///</param>
    procedure ImportDataGrid(webDataGrid: DDN.System.Web.DNDataGrid; firstFilledRow: Int32; firstFilledColumn: Byte); overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  object datagrid's data into the table with specified maximum amount of imported rows and columns.
    ///</summary>
    ///  <param name="webDataGrid">The source <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  object to be imported.</param>
    ///  <param name="firstFilledRow">The zero based row number of the first cell in targer table from which import will start.
    ///  If target table does not contain that row, it (and all previous if necessary) will be created</param>
    ///  <param name="firstFilledColumn">The zero based column number of the first cell in targer table from which import will start.
    ///  The target table must contain that column before import starts, otherwise exception will be thrown.
    ///</param>
    ///  <param name="maxRows">Maximum amount of rows to be imported.</param>
    ///  <param name="maxColumns">Maximum amount of columns to be imported.</param>
    procedure ImportDataGrid(webDataGrid: DDN.System.Web.DNDataGrid; firstFilledRow: Int32; firstFilledColumn: Byte; maxRows: Int32; maxColumns: Int32); overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataView" />
    ///  object's data into the table.
    ///</summary>
    ///  <param name="sourceDataView">The <see cref="T:System.Data.DataView" />
    ///  object to be imported.</param>
    ///  <param name="isColumnNamesImported">Indicates whether the column names will be
    ///  imported as first row.</param>
    ///  <param name="firstFilledRow">The zero based row number of the first cell in targer table from which import will start.
    ///  If target table does not contain that row, it (and all previous if necessary) will be created</param>
    ///  <param name="firstFilledColumn">The zero based column number of the first cell in targer table from which import will start.
    ///  The target table must contain that column before import starts, ot