//----------------------------------------------------------------------------
//  Aspose.Cells.dll: Aspose.Cells, Version=21.6.0.0, Culture=neutral, PublicKeyToken=716fcc553a201e56
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Framework: 4.0
//----------------------------------------------------------------------------
//  UnitName: DDN.Aspose.Cells
//  Author: ying32
//----------------------------------------------------------------------------

unit DDN.Aspose.Cells;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDN.mscorlib,
  DDN.System.Drawing,
  DDN.System.Data,
  DDN.System.Web,
  DDN.System;

type

{ enums }

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Cache options for data access. Can be combined with | operator for multiple options together.
  ///</summary>
  ///<remarks>
  ///  For some features, accessing large dataset requires a lot of repeated and complicated operations
  ///  such as search, calculation, ...etc and those operations will take a lot of extra time.
  ///  For common situations, all dependent data remains unchanged during the access, so some caches can be built and used to
  ///  improve the access performance.
  ///  For this purpose, we provide this API so that user can specify which kind of data access needs
  ///  to be optimized by possible caching mechanism.
  ///<br></br>
  ///  Please note, for different options, different data set may be required to be "read-only".
  ///  And performance of accessing data depends on many aspects, the use of caching mechanism
  ///  does not guarantee that performance will be improved. For some situations,
  ///  such as the dataset to be accessed is small, using cache may cause even more time because
  ///  caching itself also needs certain extra time.
  ///</remarks>
  [DNTypeName('Aspose.Cells.AccessCacheOptions')]
  DNAccessCacheOptions = type Integer;
  DNAccessCacheOptionsHelper = record helper for DNAccessCacheOptions
  public const
    ///<summary>
    ///  No cache for any data access.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Apply possible optimization for getting object(such as Shape)'s position and size.
    ///  Row height and column width settings should not be changed during the optimized access.
    ///</summary>
    PositionAndSize = 3;
    ///<summary>
    ///  Apply possible optimization for getting cells' values.
    ///  Cells data(data and settings of Cell, Row) should not be changed during
    ///  the optimized access, no new Cell/Row objects should be created either(such as
    ///  by <see cref="P:Aspose.Cells.Cells.Item(System.Int32,System.Int32)" />
    ///  ).
    ///</summary>
    CellsData = 9;
    ///<summary>
    ///  Apply possible optimization for getting display-related results of
    ///  cells(<see cref="P:Aspose.Cells.Cell.DisplayStringValue" />
    ///  , <see cref="M:Aspose.Cells.Cell.GetStyle" />
    ///  , <see cref="M:Aspose.Cells.Cell.GetDisplayStyle" />
    ///  , etc.).
    ///  Cells data and style-related objects(Cell/Row/Column styles, column width, etc.) should not be changed
    ///  during the optimized access.
    ///</summary>
    CellDisplay = 1048710;
    ///<summary>
    ///  Apply possible optimization for getting formulas.
    ///  All data and settings which may affect the formula expression(Worksheet's name, Name's text,
    ///  table's column, etc.) should not be changed during the optimized access.
    ///</summary>
    GetFormula = 2097152;
    ///<summary>
    ///  Apply possible optimization for setting formulas.
    ///  All data and settings which may affect the formula expression(Worksheet's name, Name's text,
    ///  table's column, etc.) should not be changed during the optimized access.
    ///</summary>
    SetFormula = 4194304;
    ///<summary>
    ///  Apply possible optimization for calculating formulas.
    ///  Cells data should not be changed during the optimized access, none new objects(Cell, Row, etc.)
    ///  should be created either(such as by <see cref="P:Aspose.Cells.Cells.Item(System.Int32,System.Int32)" />
    ///  ).
    ///</summary>
    CalculateFormula = 8388617;
    ///<summary>
    ///  Apply possible optimization for getting formatting result of conditional formattings.
    ///  All data and settings which may affect the result of conditional formattings(settings of
    ///  conditional formattings, dependent cell values, etc.) should not be changed during the optimized access.
    ///</summary>
    ConditionalFormatting = 16777225;
    ///<summary>
    ///  Apply possible optimization for getting validation result.
    ///  All data and settings which may affect the result of validation(settings of the validation,
    ///  dependent cell values, etc.) should not be changed during the optimized access.
    ///</summary>
    Validation = 33554441;
    ///<summary>
    ///  Apply all possible optimizations for all kinds of data access in the workbook.
    ///  All settings and data should not be changed during the optimized access.
    ///</summary>
    All = -1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the type of auto fitting merged cells.
  ///</summary>
  [DNTypeName('Aspose.Cells.AutoFitMergedCellsType')]
  DNAutoFitMergedCellsType = type Integer;
  DNAutoFitMergedCellsTypeHelper = record helper for DNAutoFitMergedCellsType
  public const
    ///<summary>
    ///  Ignore merged cells.
    ///</summary>
    ///<remarks>
    ///  Default.
    ///</remarks>
    None = 0;
    ///<summary>
    ///  Only expands the height of the first row.
    ///</summary>
    FirstLine = 1;
    ///<summary>
    ///  Only expands the height of the last row.
    ///</summary>
    LastLine = 2;
    ///<summary>
    ///  Only expands the height of each row.
    ///</summary>
    EachLine = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the type of auto fitting wrapped text.
  ///</summary>
  [DNTypeName('Aspose.Cells.AutoFitWrappedTextType')]
  DNAutoFitWrappedTextType = type Integer;
  DNAutoFitWrappedTextTypeHelper = record helper for DNAutoFitWrappedTextType
  public const
    ///<summary>
    ///  Works as MS Excel.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Auto fit width with the longest paragraph.
    ///</summary>
    Paragraph = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates cell background pattern types.
  ///</summary>
  [DNTypeName('Aspose.Cells.BackgroundType')]
  DNBackgroundType = type Integer;
  DNBackgroundTypeHelper = record helper for DNBackgroundType
  public const
    ///<summary>
    ///  Represents no background.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Represents solid pattern.
    ///</summary>
    Solid = 1;
    ///<summary>
    ///  Represents 50% gray pattern.
    ///</summary>
    Gray50 = 2;
    ///<summary>
    ///  Represents 75% gray pattern.
    ///</summary>
    Gray75 = 3;
    ///<summary>
    ///  Represents 25% gray pattern.
    ///</summary>
    Gray25 = 4;
    ///<summary>
    ///  Represents horizontal stripe pattern.
    ///</summary>
    HorizontalStripe = 5;
    ///<summary>
    ///  Represents vertical stripe pattern.
    ///</summary>
    VerticalStripe = 6;
    ///<summary>
    ///  Represents reverse diagonal stripe pattern.
    ///</summary>
    ReverseDiagonalStripe = 7;
    ///<summary>
    ///  Represents diagonal stripe pattern.
    ///</summary>
    DiagonalStripe = 8;
    ///<summary>
    ///  Represents diagonal crosshatch pattern.
    ///</summary>
    DiagonalCrosshatch = 9;
    ///<summary>
    ///  Represents thick diagonal crosshatch pattern.
    ///</summary>
    ThickDiagonalCrosshatch = 10;
    ///<summary>
    ///  Represents thin horizontal stripe pattern.
    ///</summary>
    ThinHorizontalStripe = 11;
    ///<summary>
    ///  Represents thin vertical stripe pattern.
    ///</summary>
    ThinVerticalStripe = 12;
    ///<summary>
    ///  Represents thin reverse diagonal stripe pattern.
    ///</summary>
    ThinReverseDiagonalStripe = 13;
    ///<summary>
    ///  Represents thin diagonal stripe pattern.
    ///</summary>
    ThinDiagonalStripe = 14;
    ///<summary>
    ///  Represents thin horizontal crosshatch pattern.
    ///</summary>
    ThinHorizontalCrosshatch = 15;
    ///<summary>
    ///  Represents thin diagonal crosshatch pattern.
    ///</summary>
    ThinDiagonalCrosshatch = 16;
    ///<summary>
    ///  Represents 12.5% gray pattern
    ///</summary>
    Gray12 = 17;
    ///<summary>
    ///  Represents 6.25% gray pattern
    ///</summary>
    Gray6 = 18;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates the border line and diagonal line types.
  ///</summary>
  [DNTypeName('Aspose.Cells.BorderType')]
  DNBorderType = type Integer;
  DNBorderTypeHelper = record helper for DNBorderType
  public const
    ///<summary>
    ///  Represents left border line.
    ///</summary>
    LeftBorder = 1;
    ///<summary>
    ///  Represents right border line exists.
    ///</summary>
    RightBorder = 2;
    ///<summary>
    ///  Represents top border line.
    ///</summary>
    TopBorder = 4;
    ///<summary>
    ///  Represents bottom border line.
    ///</summary>
    BottomBorder = 8;
    ///<summary>
    ///  Represents the diagonal line from top left to right bottom.
    ///</summary>
    DiagonalDown = 16;
    ///<summary>
    ///  Represents the diagonal line from bottom left to right top.
    ///</summary>
    DiagonalUp = 32;
    ///<summary>
    ///  Only for dynamic style,such as conditional formatting.
    ///</summary>
    Vertical = 64;
    ///<summary>
    ///  Only for dynamic style,such as conditional formatting.
    ///</summary>
    Horizontal = 128;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents all built-in style type
  ///</summary>
  [DNTypeName('Aspose.Cells.BuiltinStyleType')]
  DNBuiltinStyleType = type Integer;
  DNBuiltinStyleTypeHelper = record helper for DNBuiltinStyleType
  public const
    ///<summary></summary>
    Normal = 0;
    ///<summary></summary>
    RowLevel = 1;
    ///<summary></summary>
    ColumnLevel = 2;
    ///<summary></summary>
    Comma = 3;
    ///<summary></summary>
    Currency = 4;
    ///<summary></summary>
    Percent = 5;
    ///<summary></summary>
    Comma1 = 6;
    ///<summary></summary>
    Currency1 = 7;
    ///<summary></summary>
    Hyperlink = 8;
    ///<summary></summary>
    FollowedHyperlink = 9;
    ///<summary></summary>
    Note = 10;
    ///<summary></summary>
    WarningText = 11;
    ///<summary></summary>
    Title = 15;
    ///<summary></summary>
    Header1 = 16;
    ///<summary></summary>
    Header2 = 17;
    ///<summary></summary>
    Header3 = 18;
    ///<summary></summary>
    Header4 = 19;
    ///<summary></summary>
    Input = 20;
    ///<summary></summary>
    Output = 21;
    ///<summary></summary>
    Calculation = 22;
    ///<summary></summary>
    CheckCell = 23;
    ///<summary></summary>
    LinkedCell = 24;
    ///<summary></summary>
    Total = 25;
    ///<summary></summary>
    Good = 26;
    ///<summary></summary>
    Bad = 27;
    ///<summary></summary>
    Neutral = 28;
    ///<summary></summary>
    Accent1 = 29;
    ///<summary></summary>
    TwentyPercentAccent1 = 30;
    ///<summary></summary>
    FortyPercentAccent1 = 31;
    ///<summary></summary>
    SixtyPercentAccent1 = 32;
    ///<summary></summary>
    Accent2 = 33;
    ///<summary></summary>
    TwentyPercentAccent2 = 34;
    ///<summary></summary>
    FortyPercentAccent2 = 35;
    ///<summary></summary>
    SixtyPercentAccent2 = 36;
    ///<summary></summary>
    Accent3 = 37;
    ///<summary></summary>
    TwentyPercentAccent3 = 38;
    ///<summary></summary>
    FortyPercentAccent3 = 39;
    ///<summary></summary>
    SixtyPercentAccent3 = 40;
    ///<summary></summary>
    Accent4 = 41;
    ///<summary></summary>
    TwentyPercentAccent4 = 42;
    ///<summary></summary>
    FortyPercentAccent4 = 43;
    ///<summary></summary>
    SixtyPercentAccent4 = 44;
    ///<summary></summary>
    Accent5 = 45;
    ///<summary></summary>
    TwentyPercentAccent5 = 46;
    ///<summary></summary>
    FortyPercentAccent5 = 47;
    ///<summary></summary>
    SixtyPercentAccent5 = 48;
    ///<summary></summary>
    Accent6 = 49;
    ///<summary></summary>
    TwentyPercentAccent6 = 50;
    ///<summary></summary>
    FortyPercentAccent6 = 51;
    ///<summary></summary>
    SixtyPercentAccent6 = 52;
    ///<summary></summary>
    ExplanatoryText = 53;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the mode type of calculating formulas.
  ///</summary>
  ///<remarks>
  ///  Only sets for MS Excel.
  ///</remarks>
  [DNTypeName('Aspose.Cells.CalcModeType')]
  DNCalcModeType = type Integer;
  DNCalcModeTypeHelper = record helper for DNCalcModeType
  public const
    ///<summary></summary>
    Automatic = 0;
    ///<summary></summary>
    AutomaticExceptTable = 1;
    ///<summary></summary>
    Manual = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates strategies for handling calculation precision.
  ///  Because of the precision issue of IEEE 754 Floating-Point Arithmetic, some "seemingly simple" formulas may not be calculated as the expected result.
  ///  Such as formula "=-0.45+0.43+0.02", when calculating operands by '+' operator directly, the result is not zero. For such kind of precision issue,
  ///  some special strategies may give the expected result.
  ///</summary>
  [DNTypeName('Aspose.Cells.CalculationPrecisionStrategy')]
  DNCalculationPrecisionStrategy = type Integer;
  DNCalculationPrecisionStrategyHelper = record helper for DNCalculationPrecisionStrategy
  public const
    ///<summary>
    ///  No strategy applied on calculation.
    ///  When calculating just use the original double value as operand and return the result directly.
    ///  Most efficient for performance and applicable for most cases.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Rounds the calculation result according with significant digits.
    ///</summary>
    Round = 1;
    ///<summary>
    ///  Uses decimal as operands when possible.
    ///  Most inefficient for performance.
    ///</summary>
    Decimal = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates a cell's border type.
  ///</summary>
  [DNTypeName('Aspose.Cells.CellBorderType')]
  DNCellBorderType = type Integer;
  DNCellBorderTypeHelper = record helper for DNCellBorderType
  public const
    ///<summary>
    ///  Represents no line.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Represents thin line.
    ///</summary>
    Thin = 1;
    ///<summary>
    ///  Represents medium line.
    ///</summary>
    Medium = 2;
    ///<summary>
    ///  Represents dashed line.
    ///</summary>
    Dashed = 3;
    ///<summary>
    ///  Represents dotted line.
    ///</summary>
    Dotted = 4;
    ///<summary>
    ///  Represents thick line.
    ///</summary>
    Thick = 5;
    ///<summary>
    ///  Represents double line.
    ///</summary>
    Double = 6;
    ///<summary>
    ///  Represents hair line.
    ///</summary>
    Hair = 7;
    ///<summary>
    ///  Represents medium dashed line.
    ///</summary>
    MediumDashed = 8;
    ///<summary>
    ///  Represents thin dash-dotted line.
    ///</summary>
    DashDot = 9;
    ///<summary>
    ///  Represents medium dash-dotted line.
    ///</summary>
    MediumDashDot = 10;
    ///<summary>
    ///  Represents thin dash-dot-dotted line.
    ///</summary>
    DashDotDot = 11;
    ///<summary>
    ///  Represents medium dash-dot-dotted line.
    ///</summary>
    MediumDashDotDot = 12;
    ///<summary>
    ///  Represents slanted medium dash-dotted line.
    ///</summary>
    SlantedDashDot = 13;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies how to apply style for the value of the cell.
  ///</summary>
  [DNTypeName('Aspose.Cells.CellValueFormatStrategy')]
  DNCellValueFormatStrategy = type Integer;
  DNCellValueFormatStrategyHelper = record helper for DNCellValueFormatStrategy
  public const
    ///<summary>
    ///  Not formatted.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Only formatted with the cell's original style.
    ///</summary>
    CellStyle = 1;
    ///<summary>
    ///  Formatted with the cell's displayed style.
    ///</summary>
    DisplayStyle = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies a cell value type.
  ///</summary>
  [DNTypeName('Aspose.Cells.CellValueType')]
  DNCellValueType = type Integer;
  DNCellValueTypeHelper = record helper for DNCellValueType
  public const
    ///<summary>
    ///  Cell value is boolean.
    ///</summary>
    IsBool = 0;
    ///<summary>
    ///  Cell value is datetime.
    ///</summary>
    IsDateTime = 1;
    ///<summary>
    ///  Cell contains error value
    ///</summary>
    IsError = 2;
    ///<summary>
    ///  Blank cell.
    ///</summary>
    IsNull = 3;
    ///<summary>
    ///  Cell value is numeric.
    ///</summary>
    IsNumeric = 4;
    ///<summary>
    ///  Cell value is string.
    ///</summary>
    IsString = 5;
    ///<summary>
    ///  Cell value type is unknown.
    ///</summary>
    IsUnknown = 6;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the axis type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.AxisType')]
  DNAxisType = type Integer;
  DNAxisTypeHelper = record helper for DNAxisType
  public const
    ///<summary>
    ///  Category axis
    ///</summary>
    Category = 0;
    ///<summary>
    ///  Value axis
    ///</summary>
    Value = 1;
    ///<summary>
    ///  Series axis
    ///</summary>
    Series = 2;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the display mode of the background.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.BackgroundMode')]
  DNBackgroundMode = type Integer;
  DNBackgroundModeHelper = record helper for DNBackgroundMode
  public const
    ///<summary>
    ///  Automatic
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Opaque
    ///</summary>
    Opaque = 1;
    ///<summary>
    ///  Transparent
    ///</summary>
    Transparent = 2;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the shape used with the 3-D bar or column chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.Bar3DShapeType')]
  DNBar3DShapeType = type Integer;
  DNBar3DShapeTypeHelper = record helper for DNBar3DShapeType
  public const
    ///<summary>
    ///  Box
    ///</summary>
    Box = 0;
    ///<summary>
    ///  PyramidToPoint
    ///</summary>
    PyramidToPoint = 1;
    ///<summary>
    ///  PyramidToMax
    ///</summary>
    PyramidToMax = 2;
    ///<summary>
    ///  Cylinder
    ///</summary>
    Cylinder = 3;
    ///<summary>
    ///  ConeToPoint
    ///</summary>
    ConeToPoint = 4;
    ///<summary>
    ///  ConeToMax
    ///</summary>
    ConeToMax = 5;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents what the bubble size represents on a bubble chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.BubbleSizeRepresents')]
  DNBubbleSizeRepresents = type Integer;
  DNBubbleSizeRepresentsHelper = record helper for DNBubbleSizeRepresents
  public const
    ///<summary>
    ///  Represents the value of <see cref="P:Aspose.Cells.Charts.Series.BubbleSizes" />
    ///  is area of the bubble.
    ///</summary>
    SizeIsArea = 0;
    ///<summary>
    ///  Represents the value of <see cref="P:Aspose.Cells.Charts.Series.BubbleSizes" />
    ///  is width of the bubble.
    ///</summary>
    SizeIsWidth = 1;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the category axis type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.CategoryType')]
  DNCategoryType = type Integer;
  DNCategoryTypeHelper = record helper for DNCategoryType
  public const
    ///<summary>
    ///  AutomaticScale
    ///</summary>
    AutomaticScale = 0;
    ///<summary>
    ///  CategoryScale
    ///</summary>
    CategoryScale = 1;
    ///<summary>
    ///  TimeScale
    ///</summary>
    TimeScale = 2;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents line format type of chart line.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.ChartLineFormattingType')]
  DNChartLineFormattingType = type Integer;
  DNChartLineFormattingTypeHelper = record helper for DNChartLineFormattingType
  public const
    ///<summary>
    ///  Represents automatic formatting type.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Represents solid formatting type.
    ///</summary>
    Solid = 1;
    ///<summary>
    ///  Represents none formatting type.
    ///</summary>
    None = 2;
    ///<summary>
    ///  Gradient
    ///</summary>
    Gradient = 3;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the marker style in a line chart, scatter chart, or radar chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.ChartMarkerType')]
  DNChartMarkerType = type Integer;
  DNChartMarkerTypeHelper = record helper for DNChartMarkerType
  public const
    ///<summary>
    ///  Automatic markers.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Circular markers.
    ///</summary>
    Circle = 1;
    ///<summary>
    ///  Long bar markers
    ///</summary>
    Dash = 2;
    ///<summary>
    ///  Diamond-shaped markers.
    ///</summary>
    Diamond = 3;
    ///<summary>
    ///  Short bar markers.
    ///</summary>
    Dot = 4;
    ///<summary>
    ///  No markers.
    ///</summary>
    None = 5;
    ///<summary>
    ///  Square markers with a plus sign.
    ///</summary>
    SquarePlus = 6;
    ///<summary>
    ///  Square markers.
    ///</summary>
    Square = 7;
    ///<summary>
    ///  Square markers with an asterisk.
    ///</summary>
    SquareStar = 8;
    ///<summary>
    ///  Triangular markers.
    ///</summary>
    Triangle = 9;
    ///<summary>
    ///  Square markers with an X.
    ///</summary>
    SquareX = 10;
    ///<summary>
    ///  Picture
    ///</summary>
    Picture = 11;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the way the two sections of either a pie of pie chart or a bar of pie chart are split.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.ChartSplitType')]
  DNChartSplitType = type Integer;
  DNChartSplitTypeHelper = record helper for DNChartSplitType
  public const
    ///<summary>
    ///  Represents the data points shall be split between the pie
    ///  and the second chart by putting the last Split Position
    ///  of the data points in the second chart
    ///</summary>
    Position = 0;
    ///<summary>
    ///  Represents the data points shall be split between the pie
    ///  and the second chart by putting the data points with
    ///  value less than Split Position in the second chart.
    ///</summary>
    Value = 1;
    ///<summary>
    ///  Represents the data points shall be split between the pie
    ///  and the second chart by putting the points with
    ///  percentage less than Split Position percent in the
    ///  second chart.
    ///</summary>
    PercentValue = 2;
    ///<summary>
    ///  Represents the data points shall be split between the pie
    ///  and the second chart according to the Custom Split
    ///  values.
    ///</summary>
    Custom = 3;
    ///<summary>
    ///  Represents the data points shall be split using the default
    ///  mechanism for this chart type.
    ///</summary>
    Auto = 4;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the text direction type of the chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.ChartTextDirectionType')]
  DNChartTextDirectionType = type Integer;
  DNChartTextDirectionTypeHelper = record helper for DNChartTextDirectionType
  public const
    ///<summary>
    ///  Horizontal direction type.
    ///</summary>
    Horizontal = 0;
    ///<summary>
    ///  Vertical direction type.
    ///</summary>
    Vertical = 1;
    ///<summary>
    ///  Rotate 90 angle.
    ///</summary>
    Rotate90 = 2;
    ///<summary>
    ///  Rotate 270 angle.
    ///</summary>
    Rotate270 = 3;
    ///<summary>
    ///  Stacked text.
    ///</summary>
    Stacked = 4;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Enumerates all chart types used in Excel.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.ChartType')]
  DNChartType = type Integer;
  DNChartTypeHelper = record helper for DNChartType
  public const
    ///<summary>
    ///  Represents Area Chart.
    ///</summary>
    Area = 0;
    ///<summary>
    ///  Represents Stacked Area Chart.
    ///</summary>
    AreaStacked = 1;
    ///<summary>
    ///  Represents 100% Stacked Area Chart.
    ///</summary>
    Area100PercentStacked = 2;
    ///<summary>
    ///  Represents 3D Area Chart.
    ///</summary>
    Area3D = 3;
    ///<summary>
    ///  Represents 3D Stacked Area Chart.
    ///</summary>
    Area3DStacked = 4;
    ///<summary>
    ///  Represents 3D 100% Stacked Area Chart.
    ///</summary>
    Area3D100PercentStacked = 5;
    ///<summary>
    ///  Represents Bar Chart: Clustered Bar Chart.
    ///</summary>
    Bar = 6;
    ///<summary>
    ///  Represents Stacked Bar Chart.
    ///</summary>
    BarStacked = 7;
    ///<summary>
    ///  Represents 100% Stacked Bar Chart.
    ///</summary>
    Bar100PercentStacked = 8;
    ///<summary>
    ///  Represents 3D Colustered Bar Chart.
    ///</summary>
    Bar3DClustered = 9;
    ///<summary>
    ///  Represents 3D Stacked Bar Chart.
    ///</summary>
    Bar3DStacked = 10;
    ///<summary>
    ///  Represents 3D 100% Stacked Bar Chart.
    ///</summary>
    Bar3D100PercentStacked = 11;
    ///<summary>
    ///  Represents Bubble Chart.
    ///</summary>
    Bubble = 12;
    ///<summary>
    ///  Represents 3D Bubble Chart.
    ///</summary>
    Bubble3D = 13;
    ///<summary>
    ///  Represents Column Chart: Clustered Column Chart.
    ///</summary>
    Column = 14;
    ///<summary>
    ///  Represents Stacked Column Chart.
    ///</summary>
    ColumnStacked = 15;
    ///<summary>
    ///  Represents 100% Stacked Column Chart.
    ///</summary>
    Column100PercentStacked = 16;
    ///<summary>
    ///  Represents 3D Column Chart.
    ///</summary>
    Column3D = 17;
    ///<summary>
    ///  Represents 3D Clustered Column Chart.
    ///</summary>
    Column3DClustered = 18;
    ///<summary>
    ///  Represents 3D Stacked Column Chart.
    ///</summary>
    Column3DStacked = 19;
    ///<summary>
    ///  Represents 3D 100% Stacked Column Chart.
    ///</summary>
    Column3D100PercentStacked = 20;
    ///<summary>
    ///  Represents Cone Chart.
    ///</summary>
    Cone = 21;
    ///<summary>
    ///  Represents Stacked Cone Chart.
    ///</summary>
    ConeStacked = 22;
    ///<summary>
    ///  Represents 100% Stacked Cone Chart.
    ///</summary>
    Cone100PercentStacked = 23;
    ///<summary>
    ///  Represents Conical Bar Chart.
    ///</summary>
    ConicalBar = 24;
    ///<summary>
    ///  Represents Stacked Conical Bar Chart.
    ///</summary>
    ConicalBarStacked = 25;
    ///<summary>
    ///  Represents 100% Stacked Conical Bar Chart.
    ///</summary>
    ConicalBar100PercentStacked = 26;
    ///<summary>
    ///  Represents 3D Conical Column Chart.
    ///</summary>
    ConicalColumn3D = 27;
    ///<summary>
    ///  Represents Cylinder Chart.
    ///</summary>
    Cylinder = 28;
    ///<summary>
    ///  Represents Stacked Cylinder Chart.
    ///</summary>
    CylinderStacked = 29;
    ///<summary>
    ///  Represents 100% Stacked Cylinder Chart.
    ///</summary>
    Cylinder100PercentStacked = 30;
    ///<summary>
    ///  Represents Cylindrical Bar Chart.
    ///</summary>
    CylindricalBar = 31;
    ///<summary>
    ///  Represents Stacked Cylindrical Bar Chart.
    ///</summary>
    CylindricalBarStacked = 32;
    ///<summary>
    ///  Represents 100% Stacked Cylindrical Bar Chart.
    ///</summary>
    CylindricalBar100PercentStacked = 33;
    ///<summary>
    ///  Represents 3D Cylindrical Column Chart.
    ///</summary>
    CylindricalColumn3D = 34;
    ///<summary>
    ///  Represents Doughnut Chart.
    ///</summary>
    Doughnut = 35;
    ///<summary>
    ///  Represents Exploded Doughnut Chart.
    ///</summary>
    DoughnutExploded = 36;
    ///<summary>
    ///  Represents Line Chart.
    ///</summary>
    Line = 37;
    ///<summary>
    ///  Represents Stacked Line Chart.
    ///</summary>
    LineStacked = 38;
    ///<summary>
    ///  Represents 100% Stacked Line Chart.
    ///</summary>
    Line100PercentStacked = 39;
    ///<summary>
    ///  Represents Line Chart with data markers.
    ///</summary>
    LineWithDataMarkers = 40;
    ///<summary>
    ///  Represents Stacked Line Chart with data markers.
    ///</summary>
    LineStackedWithDataMarkers = 41;
    ///<summary>
    ///  Represents 100% Stacked Line Chart with data markers.
    ///</summary>
    Line100PercentStackedWithDataMarkers = 42;
    ///<summary>
    ///  Represents 3D Line Chart.
    ///</summary>
    Line3D = 43;
    ///<summary>
    ///  Represents Pie Chart.
    ///</summary>
    Pie = 44;
    ///<summary>
    ///  Represents 3D Pie Chart.
    ///</summary>
    Pie3D = 45;
    ///<summary>
    ///  Represents Pie of Pie Chart.
    ///</summary>
    PiePie = 46;
    ///<summary>
    ///  Represents Exploded Pie Chart.
    ///</summary>
    PieExploded = 47;
    ///<summary>
    ///  Represents 3D Exploded Pie Chart.
    ///</summary>
    Pie3DExploded = 48;
    ///<summary>
    ///  Represents Bar of Pie Chart.
    ///</summary>
    PieBar = 49;
    ///<summary>
    ///  Represents Pyramid Chart.
    ///</summary>
    Pyramid = 50;
    ///<summary>
    ///  Represents Stacked Pyramid Chart.
    ///</summary>
    PyramidStacked = 51;
    ///<summary>
    ///  Represents 100% Stacked Pyramid Chart.
    ///</summary>
    Pyramid100PercentStacked = 52;
    ///<summary>
    ///  Represents Pyramid Bar Chart.
    ///</summary>
    PyramidBar = 53;
    ///<summary>
    ///  Represents Stacked Pyramid Bar Chart.
    ///</summary>
    PyramidBarStacked = 54;
    ///<summary>
    ///  Represents 100% Stacked Pyramid Bar Chart.
    ///</summary>
    PyramidBar100PercentStacked = 55;
    ///<summary>
    ///  Represents 3D Pyramid Column Chart.
    ///</summary>
    PyramidColumn3D = 56;
    ///<summary>
    ///  Represents Radar Chart.
    ///</summary>
    Radar = 57;
    ///<summary>
    ///  Represents Radar Chart with data markers.
    ///</summary>
    RadarWithDataMarkers = 58;
    ///<summary>
    ///  Represents Filled Radar Chart.
    ///</summary>
    RadarFilled = 59;
    ///<summary>
    ///  Represents Scatter Chart.
    ///</summary>
    Scatter = 60;
    ///<summary>
    ///  Represents Scatter Chart connected by curves, with data markers.
    ///</summary>
    ScatterConnectedByCurvesWithDataMarker = 61;
    ///<summary>
    ///  Represents Scatter Chart connected by curves, without data markers.
    ///</summary>
    ScatterConnectedByCurvesWithoutDataMarker = 62;
    ///<summary>
    ///  Represents Scatter Chart connected by lines, with data markers.
    ///</summary>
    ScatterConnectedByLinesWithDataMarker = 63;
    ///<summary>
    ///  Represents Scatter Chart connected by lines, without data markers.
    ///</summary>
    ScatterConnectedByLinesWithoutDataMarker = 64;
    ///<summary>
    ///  Represents High-Low-Close Stock Chart.
    ///</summary>
    StockHighLowClose = 65;
    ///<summary>
    ///  Represents Open-High-Low-Close Stock Chart.
    ///</summary>
    StockOpenHighLowClose = 66;
    ///<summary>
    ///  Represents Volume-High-Low-Close Stock Chart.
    ///</summary>
    StockVolumeHighLowClose = 67;
    ///<summary>
    ///  Represents Volume-Open-High-Low-Close Stock Chart.
    ///</summary>
    StockVolumeOpenHighLowClose = 68;
    ///<summary>
    ///  Represents Surface Chart: 3D Surface Chart.
    ///</summary>
    Surface3D = 69;
    ///<summary>
    ///  Represents Wireframe 3D Surface Chart.
    ///</summary>
    SurfaceWireframe3D = 70;
    ///<summary>
    ///  Represents Contour Chart.
    ///</summary>
    SurfaceContour = 71;
    ///<summary>
    ///  Represents Wireframe Contour Chart.
    ///</summary>
    SurfaceContourWireframe = 72;
    ///<summary>
    ///  The series is laid out as box and whisker.
    ///</summary>
    BoxWhisker = 73;
    ///<summary>
    ///  The series is laid out as a funnel.
    ///</summary>
    Funnel = 74;
    ///<summary>
    ///  The series is laid out as pareto lines.
    ///</summary>
    ParetoLine = 75;
    ///<summary>
    ///  The series is laid out as a sunburst.
    ///</summary>
    Sunburst = 76;
    ///<summary>
    ///  The series is laid out as a treemap.
    ///</summary>
    Treemap = 77;
    ///<summary>
    ///  The series is laid out as a waterfall.
    ///</summary>
    Waterfall = 78;
    ///<summary>
    ///  The series is laid out as a histogram.
    ///</summary>
    Histogram = 79;
    ///<summary>
    ///  The series is laid out as a region map.
    ///</summary>
    Map = 80;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the axis cross type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.CrossType')]
  DNCrossType = type Integer;
  DNCrossTypeHelper = record helper for DNCrossType
  public const
    ///<summary>
    ///  Microsoft Excel sets the axis crossing point.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  The axis crosses at the maximum value.
    ///</summary>
    Maximum = 1;
    ///<summary>
    ///  The axis crosses at the minimum value.
    ///</summary>
    Minimum = 2;
    ///<summary>
    ///  The axis crosses at the custom value.
    ///</summary>
    Custom = 3;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the separator type of DataLabels.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.DataLabelsSeparatorType')]
  DNDataLabelsSeparatorType = type Integer;
  DNDataLabelsSeparatorTypeHelper = record helper for DNDataLabelsSeparatorType
  public const
    ///<summary>
    ///  Represents automatic separator
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  Represents space(" ")
    ///</summary>
    Space = 1;
    ///<summary>
    ///  Represents comma(",")
    ///</summary>
    Comma = 2;
    ///<summary>
    ///  Represents semicolon(";")
    ///</summary>
    Semicolon = 3;
    ///<summary>
    ///  Represents period(".")
    ///</summary>
    Period = 4;
    ///<summary>
    ///  Represents newline("\n")
    ///</summary>
    NewLine = 5;
    ///<summary>
    ///  Represents custom separator
    ///</summary>
    Custom = 6;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the separator type of DataLabels.
  ///</summary>
  ///<remarks>
  ///  NOTE: This member is now obsolete. Instead,
  ///  please use DataLabelsSeparatorType enum.
  ///  This property will be removed 12 months later since September 2020.
  ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
  [DNTypeName('Aspose.Cells.Charts.DataLablesSeparatorType')]
  DNDataLablesSeparatorType = type Integer;
  DNDataLablesSeparatorTypeHelper = record helper for DNDataLablesSeparatorType
  public const
    ///<summary>
    ///  Represents automatic separator
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  Represents space(" ")
    ///</summary>
    Space = 1;
    ///<summary>
    ///  Represents comma(",")
    ///</summary>
    Comma = 2;
    ///<summary>
    ///  Represents semicolon(";")
    ///</summary>
    Semicolon = 3;
    ///<summary>
    ///  Represents period(".")
    ///</summary>
    Period = 4;
    ///<summary>
    ///  Represents newline("\n")
    ///</summary>
    NewLine = 5;
    ///<summary>
    ///  Represents custom separator
    ///</summary>
    Custom = 6;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the type of display unit.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.DisplayUnitType')]
  DNDisplayUnitType = type Integer;
  DNDisplayUnitTypeHelper = record helper for DNDisplayUnitType
  public const
    ///<summary>
    ///  Display unit is None.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 100.
    ///</summary>
    Hundreds = 1;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 1,000.
    ///</summary>
    Thousands = 2;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 10,000.
    ///</summary>
    TenThousands = 3;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 100,000.
    ///</summary>
    HundredThousands = 4;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 1,000,000.
    ///</summary>
    Millions = 5;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 10,000,000.
    ///</summary>
    TenMillions = 6;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 100,000,000.
    ///</summary>
    HundredMillions = 7;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 1,000,000,000.
    ///</summary>
    Billions = 8;
    ///<summary>
    ///  Specifies the values on the chart shall be divided by 1,000,000,000,000.
    ///</summary>
    Trillions = 9;
    ///<summary>
    ///  The values on the chart shall be divided by 0.01.
    ///</summary>
    Percentage = 10;
    ///<summary>
    ///  specifies a custom value for the display unit.
    ///</summary>
    Cust = 11;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents error bar display type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.ErrorBarDisplayType')]
  DNErrorBarDisplayType = type Integer;
  DNErrorBarDisplayTypeHelper = record helper for DNErrorBarDisplayType
  public const
    ///<summary>
    ///  Both
    ///</summary>
    Both = 0;
    ///<summary>
    ///  Minus
    ///</summary>
    Minus = 1;
    ///<summary>
    ///  None
    ///</summary>
    None = 2;
    ///<summary>
    ///  Plus
    ///</summary>
    Plus = 3;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents error bar amount type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.ErrorBarType')]
  DNErrorBarType = type Integer;
  DNErrorBarTypeHelper = record helper for DNErrorBarType
  public const
    ///<summary>
    ///  InnerCustom value type.
    ///</summary>
    Custom = 0;
    ///<summary>
    ///  Fixed value type.
    ///</summary>
    FixedValue = 1;
    ///<summary>
    ///  Percentage type
    ///</summary>
    Percent = 2;
    ///<summary>
    ///  Standard deviation type.
    ///</summary>
    StDev = 3;
    ///<summary>
    ///  Standard error type.
    ///</summary>
    StError = 4;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the type of formatting applied to an <see cref="T:Aspose.Cells.Drawing.Area" />
  ///  object or a <see cref="T:Aspose.Cells.Drawing.Line" />
  ///  object.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.FormattingType')]
  DNFormattingType = type Integer;
  DNFormattingTypeHelper = record helper for DNFormattingType
  public const
    ///<summary>
    ///  Represents automatic formatting type.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Represents none formatting type.
    ///</summary>
    None = 1;
    ///<summary>
    ///  Represents custom formatting type.
    ///</summary>
    Custom = 2;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents data label position type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.LabelPositionType')]
  DNLabelPositionType = type Integer;
  DNLabelPositionTypeHelper = record helper for DNLabelPositionType
  public const
    ///<summary>
    ///  Applies only to bar, 2d/3d pie charts
    ///</summary>
    Center = 0;
    ///<summary>
    ///  Applies only to bar, 2d/3d pie charts
    ///</summary>
    InsideBase = 1;
    ///<summary>
    ///  Applies only to bar charts
    ///</summary>
    InsideEnd = 2;
    ///<summary>
    ///  Applies only to bar, 2d/3d pie charts
    ///</summary>
    OutsideEnd = 3;
    ///<summary>
    ///  Applies only to line charts
    ///</summary>
    Above = 4;
    ///<summary>
    ///  Applies only to line charts
    ///</summary>
    Below = 5;
    ///<summary>
    ///  Applies only to line charts
    ///</summary>
    Left = 6;
    ///<summary>
    ///  Applies only to line charts
    ///</summary>
    Right = 7;
    ///<summary>
    ///  Applies only to 2d/3d pie charts
    ///</summary>
    BestFit = 8;
    ///<summary>
    ///  User moved the data labels, Only for reading chart from template file.
    ///</summary>
    Moved = 9;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Enumerates the legend position types.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.LegendPositionType')]
  DNLegendPositionType = type Integer;
  DNLegendPositionTypeHelper = record helper for DNLegendPositionType
  public const
    ///<summary>
    ///  Displays the legend to the bottom of the chart's plot area.
    ///</summary>
    Bottom = 0;
    ///<summary>
    ///  Displays the legend to the corner of the chart's plot area.
    ///</summary>
    Corner = 1;
    ///<summary>
    ///  Displays the legend to the top of the chart's plot area.
    ///</summary>
    Top = 2;
    ///<summary>
    ///  Displays the legend to the right of the chart's plot area.
    ///</summary>
    Right = 3;
    ///<summary>
    ///  Displays the legend to the left of the chart's plot area.
    ///</summary>
    Left = 4;
    ///<summary>
    ///  Represents that the legend is not docked.
    ///</summary>
    NotDocked = 7;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the layout of map chart's labels.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.MapChartLabelLayout')]
  DNMapChartLabelLayout = type Integer;
  DNMapChartLabelLayoutHelper = record helper for DNMapChartLabelLayout
  public const
    ///<summary>
    ///  Only best fit.
    ///</summary>
    BestFitOnly = 0;
    ///<summary>
    ///  Shows all labels.
    ///</summary>
    ShowAll = 1;
    ///<summary>
    ///  No labels.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents projection type of the map chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.MapChartProjectionType')]
  DNMapChartProjectionType = type Integer;
  DNMapChartProjectionTypeHelper = record helper for DNMapChartProjectionType
  public const
    ///<summary>
    ///  Automatic
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Mercator
    ///</summary>
    Mercator = 1;
    ///<summary>
    ///  Miller
    ///</summary>
    Miller = 2;
    ///<summary>
    ///  Albers
    ///</summary>
    Albers = 3;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the region type of the map chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.MapChartRegionType')]
  DNMapChartRegionType = type Integer;
  DNMapChartRegionTypeHelper = record helper for DNMapChartRegionType
  public const
    ///<summary>
    ///  Automatic
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Only Data.
    ///</summary>
    DataOnly = 1;
    ///<summary>
    ///  Country region list.
    ///</summary>
    CountryRegionList = 2;
    ///<summary>
    ///  World.
    ///</summary>
    World = 3;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the type of data plot by row or column.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.PlotDataByType')]
  DNPlotDataByType = type Integer;
  DNPlotDataByTypeHelper = record helper for DNPlotDataByType
  public const
    ///<summary>
    ///  By row.
    ///</summary>
    Row = 0;
    ///<summary>
    ///  By column.
    ///</summary>
    Column = 1;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents all plot empty cells type of a chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.PlotEmptyCellsType')]
  DNPlotEmptyCellsType = type Integer;
  DNPlotEmptyCellsTypeHelper = record helper for DNPlotEmptyCellsType
  public const
    ///<summary>
    ///  Not plotted(leave gap)
    ///</summary>
    NotPlotted = 0;
    ///<summary>
    ///  Zero
    ///</summary>
    Zero = 1;
    ///<summary>
    ///  Interpolated
    ///</summary>
    Interpolated = 2;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents quartile calculation methods.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.QuartileCalculationType')]
  DNQuartileCalculationType = type Integer;
  DNQuartileCalculationTypeHelper = record helper for DNQuartileCalculationType
  public const
    ///<summary>
    ///  The quartile calculation includes the median when splitting the dataset into quartiles.
    ///</summary>
    Exclusive = 0;
    ///<summary>
    ///  The quartile calculation excludes the median when splitting the dataset into quartiles.
    ///</summary>
    Inclusive = 1;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the minimum and maximum value types for the sparkline vertical axis.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.SparklineAxisMinMaxType')]
  DNSparklineAxisMinMaxType = type Integer;
  DNSparklineAxisMinMaxTypeHelper = record helper for DNSparklineAxisMinMaxType
  public const
    ///<summary>
    ///  Automatic for each sparkline.
    ///</summary>
    AutoIndividual = 0;
    ///<summary>
    ///  Same for all sparklines in the group.
    ///</summary>
    Group = 1;
    ///<summary>
    ///  Custom value for sparkline.
    ///</summary>
    Custom = 2;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the preset style types for sparkline.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.SparklinePresetStyleType')]
  DNSparklinePresetStyleType = type Integer;
  DNSparklinePresetStyleTypeHelper = record helper for DNSparklinePresetStyleType
  public const
    ///<summary>
    ///  Style 1
    ///</summary>
    Style1 = 0;
    ///<summary>
    ///  Style 2
    ///</summary>
    Style2 = 1;
    ///<summary>
    ///  Style 3
    ///</summary>
    Style3 = 2;
    ///<summary>
    ///  Style 4
    ///</summary>
    Style4 = 3;
    ///<summary>
    ///  Style 5
    ///</summary>
    Style5 = 4;
    ///<summary>
    ///  Style 6
    ///</summary>
    Style6 = 5;
    ///<summary>
    ///  Style 7
    ///</summary>
    Style7 = 6;
    ///<summary>
    ///  Style 8
    ///</summary>
    Style8 = 7;
    ///<summary>
    ///  Style 9
    ///</summary>
    Style9 = 8;
    ///<summary>
    ///  Style 10
    ///</summary>
    Style10 = 9;
    ///<summary>
    ///  Style 11
    ///</summary>
    Style11 = 10;
    ///<summary>
    ///  Style 12
    ///</summary>
    Style12 = 11;
    ///<summary>
    ///  Style 13
    ///</summary>
    Style13 = 12;
    ///<summary>
    ///  Style 14
    ///</summary>
    Style14 = 13;
    ///<summary>
    ///  Style 15
    ///</summary>
    Style15 = 14;
    ///<summary>
    ///  Style 16
    ///</summary>
    Style16 = 15;
    ///<summary>
    ///  Style 17
    ///</summary>
    Style17 = 16;
    ///<summary>
    ///  Style 18
    ///</summary>
    Style18 = 17;
    ///<summary>
    ///  Style 19
    ///</summary>
    Style19 = 18;
    ///<summary>
    ///  Style 20
    ///</summary>
    Style20 = 19;
    ///<summary>
    ///  Style 21
    ///</summary>
    Style21 = 20;
    ///<summary>
    ///  Style 22
    ///</summary>
    Style22 = 21;
    ///<summary>
    ///  Style 23
    ///</summary>
    Style23 = 22;
    ///<summary>
    ///  Style 24
    ///</summary>
    Style24 = 23;
    ///<summary>
    ///  Style 25
    ///</summary>
    Style25 = 24;
    ///<summary>
    ///  Style 26
    ///</summary>
    Style26 = 25;
    ///<summary>
    ///  Style 27
    ///</summary>
    Style27 = 26;
    ///<summary>
    ///  Style 28
    ///</summary>
    Style28 = 27;
    ///<summary>
    ///  Style 29
    ///</summary>
    Style29 = 28;
    ///<summary>
    ///  Style 30
    ///</summary>
    Style30 = 29;
    ///<summary>
    ///  Style 31
    ///</summary>
    Style31 = 30;
    ///<summary>
    ///  Style 32
    ///</summary>
    Style32 = 31;
    ///<summary>
    ///  Style 33
    ///</summary>
    Style33 = 32;
    ///<summary>
    ///  Style 34
    ///</summary>
    Style34 = 33;
    ///<summary>
    ///  Style 35
    ///</summary>
    Style35 = 34;
    ///<summary>
    ///  Style 36
    ///</summary>
    Style36 = 35;
    ///<summary>
    ///  No preset style.
    ///</summary>
    Custom = 36;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the sparkline types.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.SparklineType')]
  DNSparklineType = type Integer;
  DNSparklineTypeHelper = record helper for DNSparklineType
  public const
    ///<summary>
    ///  Line sparkline.
    ///</summary>
    Line = 0;
    ///<summary>
    ///  Column sparkline.
    ///</summary>
    Column = 1;
    ///<summary>
    ///  Win/Loss sparkline.
    ///</summary>
    Stacked = 2;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the position type of tick-mark labels on the specified axis.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.TickLabelPositionType')]
  DNTickLabelPositionType = type Integer;
  DNTickLabelPositionTypeHelper = record helper for DNTickLabelPositionType
  public const
    ///<summary>
    ///  Position type is high.
    ///</summary>
    High = 0;
    ///<summary>
    ///  Position type is low.
    ///</summary>
    Low = 1;
    ///<summary>
    ///  Position type is next to axis.
    ///</summary>
    NextToAxis = 2;
    ///<summary>
    ///  Position type is none.
    ///</summary>
    None = 3;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the tick mark type for the specified axis.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.TickMarkType')]
  DNTickMarkType = type Integer;
  DNTickMarkTypeHelper = record helper for DNTickMarkType
  public const
    ///<summary>
    ///  Tick mark type is Cross.
    ///</summary>
    Cross = 0;
    ///<summary>
    ///  Tick mark type is Inside.
    ///</summary>
    Inside = 1;
    ///<summary>
    ///  Tick mark type is None.
    ///</summary>
    None = 2;
    ///<summary>
    ///  Tick mark type is Outside
    ///</summary>
    Outside = 3;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the base unit for the category axis.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.TimeUnit')]
  DNTimeUnit = type Integer;
  DNTimeUnitHelper = record helper for DNTimeUnit
  public const
    ///<summary>
    ///  Days
    ///</summary>
    Days = 0;
    ///<summary>
    ///  Months
    ///</summary>
    Months = 1;
    ///<summary>
    ///  Years
    ///</summary>
    Years = 2;
  end;


  //-------------namespace: Aspose.Cells.Charts----------------
  ///<summary>
  ///  Represents the trendline type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.TrendlineType')]
  DNTrendlineType = type Integer;
  DNTrendlineTypeHelper = record helper for DNTrendlineType
  public const
    ///<summary>
    ///  Exponential
    ///</summary>
    Exponential = 0;
    ///<summary>
    ///  Linear
    ///</summary>
    Linear = 1;
    ///<summary>
    ///  Logarithmic
    ///</summary>
    Logarithmic = 2;
    ///<summary>
    ///  MovingAverage
    ///</summary>
    MovingAverage = 3;
    ///<summary>
    ///  Polynomial
    ///</summary>
    Polynomial = 4;
    ///<summary>
    ///  Power
    ///</summary>
    Power = 5;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents all color type
  ///</summary>
  [DNTypeName('Aspose.Cells.ColorType')]
  DNColorType = type Integer;
  DNColorTypeHelper = record helper for DNColorType
  public const
    ///<summary>
    ///  Automatic color.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  It's automatic color,but the displayed color depends the setting of the OS System.
    ///</summary>
    ///<remarks>
    ///  Not supported.
    ///</remarks>
    AutomaticIndex = 1;
    ///<summary>
    ///  The RGB color.
    ///</summary>
    RGB = 2;
    ///<summary>
    ///  The color index in the color palette.
    ///</summary>
    IndexedColor = 3;
    ///<summary>
    ///  The theme color.
    ///</summary>
    Theme = 4;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents consolidation function.
  ///</summary>
  [DNTypeName('Aspose.Cells.ConsolidationFunction')]
  DNConsolidationFunction = type Integer;
  DNConsolidationFunctionHelper = record helper for DNConsolidationFunction
  public const
    ///<summary>
    ///  Represents Sum function.
    ///</summary>
    Sum = 0;
    ///<summary>
    ///  Represents Count function.
    ///</summary>
    Count = 1;
    ///<summary>
    ///  Represents Average function.
    ///</summary>
    Average = 2;
    ///<summary>
    ///  Represents Max function.
    ///</summary>
    Max = 3;
    ///<summary>
    ///  Represents Min function.
    ///</summary>
    Min = 4;
    ///<summary>
    ///  Represents Product function.
    ///</summary>
    Product = 5;
    ///<summary>
    ///  Represents Count Nums function.
    ///</summary>
    CountNums = 6;
    ///<summary>
    ///  Represents StdDev function.
    ///</summary>
    StdDev = 7;
    ///<summary>
    ///  Represents StdDevp function.
    ///</summary>
    StdDevp = 8;
    ///<summary>
    ///  Represents Var function.
    ///</summary>
    Var_ = 9;
    ///<summary>
    ///  Represents Varp function.
    ///</summary>
    Varp = 10;
    ///<summary>
    ///  Represents Distinct Count function.
    ///</summary>
    ///<remarks>
    ///  Only valid for PivotTable with Data Module created since by 2013.
    ///</remarks>
    DistinctCount = 11;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  The content disposition type.
  ///</summary>
  [DNTypeName('Aspose.Cells.ContentDisposition')]
  DNContentDisposition = type Integer;
  DNContentDispositionHelper = record helper for DNContentDisposition
  public const
    ///<summary></summary>
    Inline_ = 0;
    ///<summary></summary>
    Attachment = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents type of copying format when inserting rows.
  ///</summary>
  [DNTypeName('Aspose.Cells.CopyFormatType')]
  DNCopyFormatType = type Integer;
  DNCopyFormatTypeHelper = record helper for DNCopyFormatType
  public const
    ///<summary>
    ///  Formats same as above row.
    ///</summary>
    SameAsAbove = 0;
    ///<summary>
    ///  Formats same as below row.
    ///</summary>
    SameAsBelow = 1;
    ///<summary>
    ///  Clears formatting.
    ///</summary>
    Clear = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents Excel country identifiers.
  ///</summary>
  [DNTypeName('Aspose.Cells.CountryCode')]
  DNCountryCode = type Integer;
  DNCountryCodeHelper = record helper for DNCountryCode
  public const
    ///<summary></summary>
    Default_ = 0;
    ///<summary>
    ///  United States
    ///</summary>
    USA = 1;
    ///<summary>
    ///  Canada
    ///</summary>
    Canada = 2;
    ///<summary>
    ///  Latin America, except Brazil
    ///</summary>
    LatinAmeric = 3;
    ///<summary>
    ///  Russia
    ///</summary>
    Russia = 7;
    ///<summary>
    ///  Egypt
    ///</summary>
    Egypt = 20;
    ///<summary>
    ///  Greece
    ///</summary>
    Greece = 30;
    ///<summary>
    ///  Netherlands
    ///</summary>
    Netherlands = 31;
    ///<summary>
    ///  Belgium
    ///</summary>
    Belgium = 32;
    ///<summary>
    ///  France
    ///</summary>
    France = 33;
    ///<summary>
    ///  Spain
    ///</summary>
    Spain = 34;
    ///<summary>
    ///  Hungary
    ///</summary>
    Hungary = 36;
    ///<summary>
    ///  Italy
    ///</summary>
    Italy = 39;
    ///<summary>
    ///  Switzerland
    ///</summary>
    Switzerland = 41;
    ///<summary>
    ///  Austria
    ///</summary>
    Austria = 43;
    ///<summary>
    ///  United Kingdom
    ///</summary>
    UnitedKingdom = 44;
    ///<summary>
    ///  Denmark
    ///</summary>
    Denmark = 45;
    ///<summary>
    ///  Sweden
    ///</summary>
    Sweden = 46;
    ///<summary>
    ///  Norway
    ///</summary>
    Norway = 47;
    ///<summary>
    ///  Poland
    ///</summary>
    Poland = 48;
    ///<summary>
    ///  Germany
    ///</summary>
    Germany = 49;
    ///<summary>
    ///  Mexico
    ///</summary>
    Mexico = 52;
    ///<summary>
    ///  Brazil
    ///</summary>
    Brazil = 55;
    ///<summary>
    ///  Australia
    ///</summary>
    Australia = 61;
    ///<summary>
    ///  New Zealand
    ///</summary>
    NewZealand = 64;
    ///<summary>
    ///  Thailand
    ///</summary>
    Thailand = 66;
    ///<summary>
    ///  Japan
    ///</summary>
    Japan = 81;
    ///<summary>
    ///  SouthKorea
    ///</summary>
    SouthKorea = 82;
    ///<summary>
    ///  Viet Nam
    ///</summary>
    VietNam = 84;
    ///<summary>
    ///  People's Republic of China
    ///</summary>
    China = 86;
    ///<summary>
    ///  Turkey
    ///</summary>
    Turkey = 90;
    ///<summary>
    ///  India
    ///</summary>
    India = 91;
    ///<summary>
    ///  Algeria
    ///</summary>
    Algeria = 213;
    ///<summary>
    ///  Morocco
    ///</summary>
    Morocco = 216;
    ///<summary>
    ///  Libya
    ///</summary>
    Libya = 218;
    ///<summary>
    ///  Portugal
    ///</summary>
    Portugal = 351;
    ///<summary>
    ///  Iceland
    ///</summary>
    Iceland = 354;
    ///<summary>
    ///  Finland
    ///</summary>
    Finland = 358;
    ///<summary>
    ///  Czech Republic
    ///</summary>
    Czech = 420;
    ///<summary>
    ///  Taiwan
    ///</summary>
    Taiwan = 886;
    ///<summary>
    ///  Lebanon
    ///</summary>
    Lebanon = 961;
    ///<summary>
    ///  Jordan
    ///</summary>
    Jordan = 962;
    ///<summary>
    ///  Syria
    ///</summary>
    Syria = 963;
    ///<summary>
    ///  Iraq
    ///</summary>
    Iraq = 964;
    ///<summary>
    ///  Kuwait
    ///</summary>
    Kuwait = 965;
    ///<summary>
    ///  Saudi Arabia
    ///</summary>
    Saudi = 966;
    ///<summary>
    ///  United Arab Emirates
    ///</summary>
    UnitedArabEmirates = 971;
    ///<summary>
    ///  Israel
    ///</summary>
    Israel = 972;
    ///<summary>
    ///  Qatar
    ///</summary>
    Qatar = 974;
    ///<summary>
    ///  Iran
    ///</summary>
    Iran = 981;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies the axis position for a range of cells with conditional formatting as data bars.
  ///</summary>
  [DNTypeName('Aspose.Cells.DataBarAxisPosition')]
  DNDataBarAxisPosition = type Integer;
  DNDataBarAxisPositionHelper = record helper for DNDataBarAxisPosition
  public const
    ///<summary>
    ///  Display the axis at a variable position based on the ratio of the minimum negative value to the maximum positive value in the range.
    ///  Positive values are displayed in a left-to-right direction.
    ///  Negative values are displayed in a right-to-left direction.
    ///  When all values are positive or all values are negative, no axis is displayed.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Display the axis at the midpoint of the cell regardless of the set of values in the range.
    ///  Positive values are displayed in a left-to-right direction.
    ///  Negative values are displayed in a right-to-left direction.
    ///</summary>
    Midpoint = 1;
    ///<summary>
    ///  No axis is displayed, and both positive and negative values are displayed in the left-to-right direction.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies the border type of a data bar.
  ///</summary>
  [DNTypeName('Aspose.Cells.DataBarBorderType')]
  DNDataBarBorderType = type Integer;
  DNDataBarBorderTypeHelper = record helper for DNDataBarBorderType
  public const
    ///<summary>
    ///  The data bar has no border.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The data bar has a solid border.
    ///</summary>
    Solid = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies how a data bar is filled with color.
  ///</summary>
  [DNTypeName('Aspose.Cells.DataBarFillType')]
  DNDataBarFillType = type Integer;
  DNDataBarFillTypeHelper = record helper for DNDataBarFillType
  public const
    ///<summary>
    ///  The data bar is filled with solid color.
    ///</summary>
    Solid = 0;
    ///<summary>
    ///  The data bar is filled with a color gradient.
    ///</summary>
    Gradient = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies whether to use the same border and fill color as positive data bars.
  ///</summary>
  [DNTypeName('Aspose.Cells.DataBarNegativeColorType')]
  DNDataBarNegativeColorType = type Integer;
  DNDataBarNegativeColorTypeHelper = record helper for DNDataBarNegativeColorType
  public const
    ///<summary>
    ///  Use the color specified in the Negative Value and Axis Setting dialog box
    ///  or by using the ColorType and BorderColorType properties of the NegativeBarFormat object.
    ///</summary>
    Color = 0;
    ///<summary>
    ///  Use the same color as positive data bars.
    ///</summary>
    SameAsPositive = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies how to group dateTime values.
  ///</summary>
  [DNTypeName('Aspose.Cells.DateTimeGroupingType')]
  DNDateTimeGroupingType = type Integer;
  DNDateTimeGroupingTypeHelper = record helper for DNDateTimeGroupingType
  public const
    ///<summary>
    ///  Group by day.
    ///</summary>
    Day = 0;
    ///<summary>
    ///  Group by hour.
    ///</summary>
    Hour = 1;
    ///<summary>
    ///  Group by Minute.
    ///</summary>
    Minute = 2;
    ///<summary>
    ///  Group by Month.
    ///</summary>
    Month = 3;
    ///<summary>
    ///  Group by Second.
    ///</summary>
    Second = 4;
    ///<summary>
    ///  Group by Year.
    ///</summary>
    Year = 5;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the default edit language.
  ///</summary>
  [DNTypeName('Aspose.Cells.DefaultEditLanguage')]
  DNDefaultEditLanguage = type Integer;
  DNDefaultEditLanguageHelper = record helper for DNDefaultEditLanguage
  public const
    ///<summary>
    ///  Represents auto detecting edit language according to the text itself.
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  Represents English language.
    ///</summary>
    English = 1;
    ///<summary>
    ///  Represents Chinese, Japanese, Korean language.
    ///</summary>
    CJK = 2;
  end;


  //-------------namespace: Aspose.Cells.DigitalSignatures----------------
  ///<summary>
  ///  Type of XML Advanced Electronic Signature (XAdES).
  ///</summary>
  [DNTypeName('Aspose.Cells.DigitalSignatures.XAdESType')]
  DNXAdESType = type Integer;
  DNXAdESTypeHelper = record helper for DNXAdESType
  public const
    ///<summary>
    ///  XAdES is off.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Basic XAdES.
    ///</summary>
    XAdES = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the directory  type of the file name.
  ///</summary>
  [DNTypeName('Aspose.Cells.DirectoryType')]
  DNDirectoryType = type Integer;
  DNDirectoryTypeHelper = record helper for DNDirectoryType
  public const
    ///<summary>
    ///  Represents an MS-DOS drive letter. It is followed by the drive letter.
    ///  Or UNC file names, such as \\server\share\myfile.xls
    ///</summary>
    Volume = 0;
    ///<summary>
    ///  Indicates that the source workbook is on the same drive as the dependent workbook (the drive letter is omitted)
    ///</summary>
    SameVolume = 1;
    ///<summary>
    ///  Indicates that the source workbook is in a subdirectory of the current directory.
    ///</summary>
    DownDirectory = 2;
    ///<summary>
    ///  Indicates that the source workbook is in the parent directory of the current directory.
    ///</summary>
    UpDirectory = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents whether and how to show objects in the workbook.
  ///</summary>
  [DNTypeName('Aspose.Cells.DisplayDrawingObjects')]
  DNDisplayDrawingObjects = type Integer;
  DNDisplayDrawingObjectsHelper = record helper for DNDisplayDrawingObjects
  public const
    ///<summary>
    ///  Show all objects
    ///</summary>
    DisplayShapes = 0;
    ///<summary>
    ///  Show placeholders
    ///</summary>
    Placeholders = 1;
    ///<summary>
    ///  Hide all shapes.
    ///</summary>
    Hide = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the persistence method to persist an ActiveX control.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ActiveXPersistenceType')]
  DNActiveXPersistenceType = type Integer;
  DNActiveXPersistenceTypeHelper = record helper for DNActiveXPersistenceType
  public const
    ///<summary>
    ///  The data is stored as xml data.
    ///</summary>
    PropertyBag = 0;
    ///<summary>
    ///  The data is stored as a storage binary data.
    ///</summary>
    Storage = 1;
    ///<summary>
    ///  The data is stored as a stream binary data.
    ///</summary>
    Stream = 2;
    ///<summary>
    ///  The data is stored as a streaminit binary data.
    ///</summary>
    StreamInit = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the border type of the ActiveX control.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlBorderType')]
  DNControlBorderType = type Integer;
  DNControlBorderTypeHelper = record helper for DNControlBorderType
  public const
    ///<summary>
    ///  No border.
    ///</summary>
    None = 0;
    ///<summary>
    ///  The single line.
    ///</summary>
    Single = 1;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the position of the Caption relative to the control.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlCaptionAlignmentType')]
  DNControlCaptionAlignmentType = type Integer;
  DNControlCaptionAlignmentTypeHelper = record helper for DNControlCaptionAlignmentType
  public const
    ///<summary>
    ///  The left of the control.
    ///</summary>
    Left = 0;
    ///<summary>
    ///  The right of the control.
    ///</summary>
    Right = 1;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the visual appearance of the list in a ListBox or ComboBox.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlListStyle')]
  DNControlListStyle = type Integer;
  DNControlListStyleHelper = record helper for DNControlListStyle
  public const
    ///<summary>
    ///  Displays a list in which the background of an item is highlighted when it is selected.
    ///</summary>
    Plain = 0;
    ///<summary>
    ///  Displays a list in which an option button or a checkbox next to each entry displays the selection state of that item.
    ///</summary>
    Option = 1;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents how a ListBox or ComboBox searches its list as the user types.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlMatchEntryType')]
  DNControlMatchEntryType = type Integer;
  DNControlMatchEntryTypeHelper = record helper for DNControlMatchEntryType
  public const
    ///<summary>
    ///  The control searches for the next entry that starts with the character entered.
    ///  Repeatedly typing the same letter cycles through all entries beginning with that letter.
    ///</summary>
    FirstLetter = 0;
    ///<summary>
    ///  As each character is typed, the control searches for an entry matching all characters entered.
    ///</summary>
    Complete = 1;
    ///<summary>
    ///  The list will not be searched when characters are typed.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the type of icon displayed as the mouse pointer for the control.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlMousePointerType')]
  DNControlMousePointerType = type Integer;
  DNControlMousePointerTypeHelper = record helper for DNControlMousePointerType
  public const
    ///<summary>
    ///  Standard pointer.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Arrow.
    ///</summary>
    Arrow = 1;
    ///<summary>
    ///  Cross-hair pointer.
    ///</summary>
    Cross = 2;
    ///<summary>
    ///  I-beam.
    ///</summary>
    IBeam = 3;
    ///<summary>
    ///  Double arrow pointing northeast and southwest.
    ///</summary>
    SizeNESW = 6;
    ///<summary>
    ///  Double arrow pointing north and south.
    ///</summary>
    SizeNS = 7;
    ///<summary>
    ///  Double arrow pointing northwest and southeast.
    ///</summary>
    SizeNWSE = 8;
    ///<summary>
    ///  Double arrow pointing west and east.
    ///</summary>
    SizeWE = 9;
    ///<summary>
    ///  Up arrow.
    ///</summary>
    UpArrow = 10;
    ///<summary>
    ///  Hourglass.
    ///</summary>
    HourGlass = 11;
    ///<summary>
    ///  "Not” symbol (circle with a diagonal line) on top of the object being dragged.
    ///</summary>
    NoDrop = 12;
    ///<summary>
    ///  Arrow with an hourglass.
    ///</summary>
    AppStarting = 13;
    ///<summary>
    ///  Arrow with a question mark.
    ///</summary>
    Help = 14;
    ///<summary>
    ///  "Size-all” cursor (arrows pointing north, south, east, and west).
    ///</summary>
    SizeAll = 15;
    ///<summary>
    ///  Uses the icon specified by the MouseIcon property.
    ///</summary>
    Custom = 99;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the alignment of the picture inside the Form or Image.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlPictureAlignmentType')]
  DNControlPictureAlignmentType = type Integer;
  DNControlPictureAlignmentTypeHelper = record helper for DNControlPictureAlignmentType
  public const
    ///<summary>
    ///  The top left corner.
    ///</summary>
    TopLeft = 0;
    ///<summary>
    ///  The top right corner.
    ///</summary>
    TopRight = 1;
    ///<summary>
    ///  The center.
    ///</summary>
    Center = 2;
    ///<summary>
    ///  The bottom left corner.
    ///</summary>
    BottomLeft = 3;
    ///<summary>
    ///  The bottom right corner.
    ///</summary>
    BottomRight = 4;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the location of the control's picture relative to its caption.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlPicturePositionType')]
  DNControlPicturePositionType = type Integer;
  DNControlPicturePositionTypeHelper = record helper for DNControlPicturePositionType
  public const
    ///<summary>
    ///  The picture appears to the right of the caption.
    ///  The caption is aligned with the top of the picture.
    ///</summary>
    RightTop = 2;
    ///<summary>
    ///  The picture appears below the caption.
    ///  The caption is aligned with the left edge of the picture.
    ///</summary>
    BelowLeft = 6;
    ///<summary>
    ///  The picture appears below the caption.
    ///  The caption is centered above the picture.
    ///</summary>
    BelowCenter = 65543;
    ///<summary>
    ///  The picture appears to the left of the caption.
    ///  The caption is aligned with the top of the picture.
    ///</summary>
    LeftTop = 131072;
    ///<summary>
    ///  The picture appears below the caption.
    ///  The caption is aligned with the right edge of the picture.
    ///</summary>
    BelowRight = 131080;
    ///<summary>
    ///  The picture appears to the right of the caption.
    ///  The caption is centered relative to the picture.
    ///</summary>
    RightCenter = 196613;
    ///<summary>
    ///  The picture appears in the center of the control.
    ///  The caption is centered horizontally and vertically on top of the picture.
    ///</summary>
    Center = 262148;
    ///<summary>
    ///  The picture appears to the left of the caption.
    ///  The caption is centered relative to the picture.
    ///</summary>
    LeftCenter = 327683;
    ///<summary>
    ///  The picture appears above the caption.
    ///  The caption is aligned with the left edge of the picture.
    ///</summary>
    AboveLeft = 393216;
    ///<summary>
    ///  The picture appears to the right of the caption.
    ///  The caption is aligned with the bottom of the picture.
    ///</summary>
    RightBottom = 393224;
    ///<summary>
    ///  The picture appears above the caption.
    ///  The caption is centered below the picture.
    ///</summary>
    AboveCenter = 458753;
    ///<summary>
    ///  The picture appears above the caption.
    ///  The caption is aligned with the right edge of the picture.
    ///</summary>
    AboveRight = 524290;
    ///<summary>
    ///  The picture appears to the left of the caption.
    ///  The caption is aligned with the bottom of the picture.
    ///</summary>
    LeftBottom = 524294;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents how to display the picture.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlPictureSizeMode')]
  DNControlPictureSizeMode = type Integer;
  DNControlPictureSizeModeHelper = record helper for DNControlPictureSizeMode
  public const
    ///<summary>
    ///  Crops any part of the picture that is larger than the control's boundaries.
    ///</summary>
    Clip = 0;
    ///<summary>
    ///  Stretches the picture to fill the control's area.
    ///  This setting distorts the picture in either the horizontal or vertical direction.
    ///</summary>
    Stretch = 1;
    ///<summary>
    ///  Enlarges the picture, but does not distort the picture in either the horizontal or vertical direction.
    ///</summary>
    Zoom = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the type of scroll bar.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlScrollBarType')]
  DNControlScrollBarType = type Integer;
  DNControlScrollBarTypeHelper = record helper for DNControlScrollBarType
  public const
    ///<summary>
    ///  Displays no scroll bars.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Displays a horizontal scroll bar.
    ///</summary>
    Horizontal = 1;
    ///<summary>
    ///  Displays a vertical scroll bar.
    ///</summary>
    BarsVertical = 2;
    ///<summary>
    ///  Displays both a horizontal and a vertical scroll bar.
    ///</summary>
    BarsBoth = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents type of scroll orientation
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlScrollOrientation')]
  DNControlScrollOrientation = type Integer;
  DNControlScrollOrientationHelper = record helper for DNControlScrollOrientation
  public const
    ///<summary>
    ///  Control is rendered vertically.
    ///</summary>
    Vertical = 0;
    ///<summary>
    ///  Control is rendered horizontally.
    ///</summary>
    Horizontal = 1;
    ///<summary>
    ///  Control is rendered horizontally when the control's width is greater than its height.
    ///  Control is rendered vertically otherwise.
    ///</summary>
    Auto = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the type of special effect.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlSpecialEffectType')]
  DNControlSpecialEffectType = type Integer;
  DNControlSpecialEffectTypeHelper = record helper for DNControlSpecialEffectType
  public const
    ///<summary>
    ///  Flat
    ///</summary>
    Flat = 0;
    ///<summary>
    ///  Raised
    ///</summary>
    Raised = 1;
    ///<summary>
    ///  Sunken
    ///</summary>
    Sunken = 2;
    ///<summary>
    ///  Etched
    ///</summary>
    Etched = 3;
    ///<summary>
    ///  Bump
    ///</summary>
    Bump = 6;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents all type of ActiveX control.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ControlType')]
  DNControlType = type Integer;
  DNControlTypeHelper = record helper for DNControlType
  public const
    ///<summary>
    ///  Button
    ///</summary>
    CommandButton = 0;
    ///<summary>
    ///  ComboBox
    ///</summary>
    ComboBox = 1;
    ///<summary>
    ///  CheckBox
    ///</summary>
    CheckBox = 2;
    ///<summary>
    ///  ListBox
    ///</summary>
    ListBox = 3;
    ///<summary>
    ///  TextBox
    ///</summary>
    TextBox = 4;
    ///<summary>
    ///  Spinner
    ///</summary>
    SpinButton = 5;
    ///<summary>
    ///  RadioButton
    ///</summary>
    RadioButton = 6;
    ///<summary>
    ///  Label
    ///</summary>
    Label_ = 7;
    ///<summary>
    ///  Image
    ///</summary>
    Image = 8;
    ///<summary>
    ///  ToggleButton
    ///</summary>
    ToggleButton = 9;
    ///<summary>
    ///  ScrollBar
    ///</summary>
    ScrollBar = 10;
    ///<summary>
    ///  Unknown
    ///</summary>
    Unknown = 11;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the symbol displayed on the drop button.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.DropButtonStyle')]
  DNDropButtonStyle = type Integer;
  DNDropButtonStyleHelper = record helper for DNDropButtonStyle
  public const
    ///<summary>
    ///  Displays a button with no symbol.
    ///</summary>
    Plain = 0;
    ///<summary>
    ///  Displays a button with a down arrow.
    ///</summary>
    Arrow = 1;
    ///<summary>
    ///  Displays a button with an ellipsis (...).
    ///</summary>
    Ellipsis = 2;
    ///<summary>
    ///  Displays a button with a horizontal line like an underscore character.
    ///</summary>
    Reduce = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Represents the default run-time mode of the Input Method Editor.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.InputMethodEditorMode')]
  DNInputMethodEditorMode = type Integer;
  DNInputMethodEditorModeHelper = record helper for DNInputMethodEditorMode
  public const
    ///<summary>
    ///  Does not control IME.
    ///</summary>
    NoControl = 0;
    ///<summary>
    ///  IME on.
    ///</summary>
    On_ = 1;
    ///<summary>
    ///  IME off. English mode.
    ///</summary>
    Off = 2;
    ///<summary>
    ///  IME off.User can't turn on IME by keyboard.
    ///</summary>
    Disable = 3;
    ///<summary>
    ///  IME on with Full-width hiragana mode.
    ///</summary>
    Hiragana = 4;
    ///<summary>
    ///  IME on with Full-width katakana mode.
    ///</summary>
    Katakana = 5;
    ///<summary>
    ///  IME on with Half-width katakana mode.
    ///</summary>
    KatakanaHalf = 6;
    ///<summary>
    ///  IME on with Full-width Alphanumeric mode.
    ///</summary>
    AlphaFull = 7;
    ///<summary>
    ///  IME on with Half-width Alphanumeric mode.
    ///</summary>
    Alpha = 8;
    ///<summary>
    ///  IME on with Full-width hangul mode.
    ///</summary>
    HangulFull = 9;
    ///<summary>
    ///  IME on with Half-width hangul mode.
    ///</summary>
    Hangul = 10;
    ///<summary>
    ///  IME on with Full-width hanzi mode.
    ///</summary>
    HanziFull = 11;
    ///<summary>
    ///  IME on with Half-width hanzi mode.
    ///</summary>
    Hanzi = 12;
  end;


  //-------------namespace: Aspose.Cells.Drawing.ActiveXControls----------------
  ///<summary>
  ///  Specifies when to show the drop button
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ActiveXControls.ShowDropButtonType')]
  DNShowDropButtonType = type Integer;
  DNShowDropButtonTypeHelper = record helper for DNShowDropButtonType
  public const
    ///<summary>
    ///  Never show the drop button.
    ///</summary>
    Never = 0;
    ///<summary>
    ///  Show the drop button when the control has the focus.
    ///</summary>
    Focus = 1;
    ///<summary>
    ///  Always show the drop button.
    ///</summary>
    Always = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents all built-in auto shape type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.AutoShapeType')]
  DNAutoShapeType = type Integer;
  DNAutoShapeTypeHelper = record helper for DNAutoShapeType
  public const
    ///<summary></summary>
    NotPrimitive = 0;
    ///<summary></summary>
    Rectangle = 1;
    ///<summary></summary>
    RoundedRectangle = 2;
    ///<summary></summary>
    Oval = 3;
    ///<summary></summary>
    Diamond = 4;
    ///<summary></summary>
    IsoscelesTriangle = 5;
    ///<summary></summary>
    RightTriangle = 6;
    ///<summary></summary>
    Parallelogram = 7;
    ///<summary></summary>
    Trapezoid = 8;
    ///<summary></summary>
    Hexagon = 9;
    ///<summary></summary>
    Octagon = 10;
    ///<summary></summary>
    Cross = 11;
    ///<summary></summary>
    Star5 = 12;
    ///<summary></summary>
    RightArrow = 13;
    ///<summary></summary>
    HomePlate = 15;
    ///<summary></summary>
    Cube = 16;
    ///<summary></summary>
    Balloon = 17;
    ///<summary></summary>
    Seal = 18;
    ///<summary></summary>
    Arc = 19;
    ///<summary></summary>
    Line = 20;
    ///<summary></summary>
    Plaque = 21;
    ///<summary></summary>
    Can = 22;
    ///<summary></summary>
    Donut = 23;
    ///<summary></summary>
    TextSimple = 24;
    ///<summary></summary>
    TextOctagon = 25;
    ///<summary></summary>
    TextHexagon = 26;
    ///<summary></summary>
    TextCurve = 27;
    ///<summary></summary>
    TextWave = 28;
    ///<summary></summary>
    TextRing = 29;
    ///<summary></summary>
    TextOnCurve = 30;
    ///<summary></summary>
    msosptTextOnRing = 31;
    ///<summary></summary>
    StraightConnector = 32;
    ///<summary></summary>
    BentConnector2 = 33;
    ///<summary></summary>
    ElbowConnector = 34;
    ///<summary></summary>
    BentConnector4 = 35;
    ///<summary></summary>
    BentConnector5 = 36;
    ///<summary></summary>
    CurvedConnector2 = 37;
    ///<summary></summary>
    CurvedConnector = 38;
    ///<summary></summary>
    CurvedConnector4 = 39;
    ///<summary></summary>
    CurvedConnector5 = 40;
    ///<summary></summary>
    LineCalloutNoBorder2 = 41;
    ///<summary></summary>
    LineCalloutNoBorder3 = 42;
    ///<summary></summary>
    LineCalloutNoBorder4 = 43;
    ///<summary></summary>
    LineCalloutWithAccentBar2 = 44;
    ///<summary></summary>
    LineCalloutWithAccentBar3 = 45;
    ///<summary></summary>
    LineCalloutWithAccentBar4 = 46;
    ///<summary></summary>
    LineCalloutWithBorder2 = 47;
    ///<summary></summary>
    LineCalloutWithBorder3 = 48;
    ///<summary></summary>
    LineCalloutWithBorder4 = 49;
    ///<summary></summary>
    LineCalloutWithBorderAndAccentBar2 = 50;
    ///<summary></summary>
    LineCalloutWithBorderAndAccentBar3 = 51;
    ///<summary></summary>
    LineCalloutWithBorderAndAccentBar4 = 52;
    ///<summary></summary>
    DownRibbon = 53;
    ///<summary></summary>
    UpRibbon = 54;
    ///<summary></summary>
    Chevron = 55;
    ///<summary></summary>
    RegularPentagon = 56;
    ///<summary></summary>
    NoSymbol = 57;
    ///<summary></summary>
    Star8 = 58;
    ///<summary></summary>
    Star16 = 59;
    ///<summary></summary>
    Star32 = 60;
    ///<summary></summary>
    RectangularCallout = 61;
    ///<summary></summary>
    RoundedRectangularCallout = 62;
    ///<summary></summary>
    OvalCallout = 63;
    ///<summary></summary>
    Wave = 64;
    ///<summary></summary>
    FoldedCorner = 65;
    ///<summary></summary>
    LeftArrow = 66;
    ///<summary></summary>
    DownArrow = 67;
    ///<summary></summary>
    UpArrow = 68;
    ///<summary></summary>
    LeftRightArrow = 69;
    ///<summary></summary>
    UpDownArrow = 70;
    ///<summary></summary>
    Explosion1 = 71;
    ///<summary></summary>
    Explosion2 = 72;
    ///<summary></summary>
    LightningBolt = 73;
    ///<summary></summary>
    Heart = 74;
    ///<summary></summary>
    PictureFrame = 75;
    ///<summary></summary>
    QuadArrow = 76;
    ///<summary></summary>
    LeftArrowCallout = 77;
    ///<summary></summary>
    RightArrowCallout = 78;
    ///<summary></summary>
    UpArrowCallout = 79;
    ///<summary></summary>
    DownArrowCallout = 80;
    ///<summary></summary>
    LeftRightArrowCallout = 81;
    ///<summary></summary>
    UpDownArrowCallout = 82;
    ///<summary></summary>
    QuadArrowCallout = 83;
    ///<summary></summary>
    Bevel = 84;
    ///<summary></summary>
    LeftBracket = 85;
    ///<summary></summary>
    RightBracket = 86;
    ///<summary></summary>
    LeftBrace = 87;
    ///<summary></summary>
    RightBrace = 88;
    ///<summary></summary>
    LeftUpArrow = 89;
    ///<summary></summary>
    BentUpArrow = 90;
    ///<summary></summary>
    BentArrow = 91;
    ///<summary></summary>
    Star24 = 92;
    ///<summary></summary>
    StripedRightArrow = 93;
    ///<summary></summary>
    NotchedRightArrow = 94;
    ///<summary></summary>
    BlockArc = 95;
    ///<summary></summary>
    SmileyFace = 96;
    ///<summary></summary>
    VerticalScroll = 97;
    ///<summary></summary>
    HorizontalScroll = 98;
    ///<summary></summary>
    CircularArrow = 99;
    ///<summary>
    ///  A value that SHOULD NOT be used.
    ///</summary>
    NotchedCircularArrow = 100;
    ///<summary></summary>
    UTurnArrow = 101;
    ///<summary></summary>
    CurvedRightArrow = 102;
    ///<summary></summary>
    CurvedLeftArrow = 103;
    ///<summary></summary>
    CurvedUpArrow = 104;
    ///<summary></summary>
    CurvedDownArrow = 105;
    ///<summary></summary>
    CloudCallout = 106;
    ///<summary></summary>
    CurvedDownRibbon = 107;
    ///<summary></summary>
    CurvedUpRibbon = 108;
    ///<summary></summary>
    FlowChartProcess = 109;
    ///<summary></summary>
    FlowChartDecision = 110;
    ///<summary></summary>
    FlowChartData = 111;
    ///<summary></summary>
    FlowChartPredefinedProcess = 112;
    ///<summary></summary>
    FlowChartInternalStorage = 113;
    ///<summary></summary>
    FlowChartDocument = 114;
    ///<summary></summary>
    FlowChartMultidocument = 115;
    ///<summary></summary>
    FlowChartTerminator = 116;
    ///<summary></summary>
    FlowChartPreparation = 117;
    ///<summary></summary>
    FlowChartManualInput = 118;
    ///<summary></summary>
    FlowChartManualOperation = 119;
    ///<summary></summary>
    FlowChartConnector = 120;
    ///<summary></summary>
    FlowChartCard = 121;
    ///<summary></summary>
    FlowChartPunchedTape = 122;
    ///<summary></summary>
    FlowChartSummingJunction = 123;
    ///<summary></summary>
    FlowChartOr = 124;
    ///<summary></summary>
    FlowChartCollate = 125;
    ///<summary></summary>
    FlowChartSort = 126;
    ///<summary></summary>
    FlowChartExtract = 127;
    ///<summary></summary>
    FlowChartMerge = 128;
    ///<summary></summary>
    FlowChartOfflineStorage = 129;
    ///<summary></summary>
    FlowChartStoredData = 130;
    ///<summary></summary>
    FlowChartSequentialAccessStorage = 131;
    ///<summary></summary>
    FlowChartMagneticDisk = 132;
    ///<summary></summary>
    FlowChartDirectAccessStorage = 133;
    ///<summary></summary>
    FlowChartDisplay = 134;
    ///<summary></summary>
    FlowChartDelay = 135;
    ///<summary>
    ///  A plain text shape.
    ///</summary>
    TextPlainText = 136;
    ///<summary>
    ///  An octagonal text shape.
    ///</summary>
    TextStop = 137;
    ///<summary>
    ///  A triangular text shape pointing upwards.
    ///</summary>
    TextTriangle = 138;
    ///<summary>
    ///  A triangular text shape pointing downwards.
    ///</summary>
    TextTriangleInverted = 139;
    ///<summary>
    ///  A chevron text shape pointing upwards.
    ///</summary>
    TextChevron = 140;
    ///<summary>
    ///  A chevron text shape pointing downwards.
    ///</summary>
    TextChevronInverted = 141;
    ///<summary>
    ///  A circular text shape, as if reading an inscription on the inside of a ring.
    ///</summary>
    TextRingInside = 142;
    ///<summary>
    ///  A circular text shape, as if reading an inscription on the outside of a ring.
    ///</summary>
    TextRingOutside = 143;
    ///<summary>
    ///  An upward arching curved text shape.
    ///</summary>
    TextArchUpCurve = 144;
    ///<summary>
    ///  A downward arching curved text shape.
    ///</summary>
    TextArchDownCurve = 145;
    ///<summary>
    ///  A circular text shape.
    ///</summary>
    TextCircleCurve = 146;
    ///<summary>
    ///  A text shape that resembles a button.
    ///</summary>
    TextButtonCurve = 147;
    ///<summary>
    ///  An upward arching text shape.
    ///</summary>
    TextArchUpPour = 148;
    ///<summary>
    ///  A downward arching text shape.
    ///</summary>
    TextArchDownPour = 149;
    ///<summary>
    ///  A circular text shape.
    ///</summary>
    TextCirclePour = 150;
    ///<summary>
    ///  A text shape that resembles a button.
    ///</summary>
    TextButtonPour = 151;
    ///<summary>
    ///  An upward curving text shape.
    ///</summary>
    TextCurveUp = 152;
    ///<summary>
    ///  A downward curving text shape.
    ///</summary>
    TextCurveDown = 153;
    ///<summary>
    ///  A cascading text shape pointed upwards.
    ///</summary>
    TextCascadeUp = 154;
    ///<summary>
    ///  A cascading text shape pointed downwards.
    ///</summary>
    TextCascadeDown = 155;
    ///<summary>
    ///  A wavy text shape.
    ///</summary>
    TextWave1 = 156;
    ///<summary>
    ///  A wavy text shape.
    ///</summary>
    TextWave2 = 157;
    ///<summary>
    ///  A wavy text shape.
    ///</summary>
    TextDoubleWave1 = 158;
    ///<summary>
    ///  A wavy text shape.
    ///</summary>
    ///<remarks>
    ///  NOTE: This enum is now obsolete. Instead, please use AutoShape.TextDoubleWave1.
    ///  This property will be removed 12 months later since April 2016.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    TextWave3 = 158;
    ///<summary>
    ///  A wavy text shape.
    ///</summary>
    ///<remarks>
    ///  NOTE: This enum is now obsolete. Instead, please use AutoShape.TextDoubleWave2.
    ///  This property will be removed 12 months later since April 2016.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    TextWave4 = 159;
    ///<summary>
    ///  A wavy text shape.
    ///</summary>
    TextDoubleWave2 = 159;
    ///<summary>
    ///  A text shape that expands vertically in the middle.
    ///</summary>
    TextInflate = 160;
    ///<summary>
    ///  A text shape that shrinks vertically in the middle.
    ///</summary>
    TextDeflate = 161;
    ///<summary>
    ///  A text shape that expands downward in the middle.
    ///</summary>
    TextInflateBottom = 162;
    ///<summary>
    ///  A text shape that shrinks upwards in the middle.
    ///</summary>
    TextDeflateBottom = 163;
    ///<summary>
    ///  A text shape that expands upward in the middle.
    ///</summary>
    TextInflateTop = 164;
    ///<summary>
    ///  A text shape that shrinks downward in the middle.
    ///</summary>
    TextDeflateTop = 165;
    ///<summary>
    ///  A text shape where lower lines expand upward. Upper lines shrink to compensate.
    ///</summary>
    TextDeflateInflate = 166;
    ///<summary>
    ///  A text shape where lines in the center expand vertically. Upper and lower lines shrink to compensate.
    ///</summary>
    TextDeflateInflateDeflate = 167;
    ///<summary>
    ///  A text shape that shrinks vertically on the right side.
    ///</summary>
    TextFadeRight = 168;
    ///<summary>
    ///  A text shape that shrinks vertically on the left side.
    ///</summary>
    TextFadeLeft = 169;
    ///<summary>
    ///  A text shape that shrinks horizontally on top.
    ///</summary>
    TextFadeUp = 170;
    ///<summary>
    ///  A text shape that shrinks horizontally on bottom.
    ///</summary>
    TextFadeDown = 171;
    ///<summary>
    ///  An upward slanted text shape.
    ///</summary>
    TextSlantUp = 172;
    ///<summary>
    ///  A downward slanted text shape.
    ///</summary>
    TextSlantDown = 173;
    ///<summary>
    ///  A text shape that is curved upwards as if being read on the side of a can.
    ///</summary>
    TextCanUp = 174;
    ///<summary>
    ///  A text shape that is curved downwards as if being read on the side of a can.
    ///</summary>
    TextCanDown = 175;
    ///<summary></summary>
    FlowChartAlternateProcess = 176;
    ///<summary></summary>
    FlowChartOffpageConnector = 177;
    ///<summary></summary>
    LineCalloutNoBorder1 = 178;
    ///<summary></summary>
    LineCalloutWithAccentBar1 = 179;
    ///<summary></summary>
    LineCalloutWithBorder1 = 180;
    ///<summary></summary>
    LineCalloutWithBorderAndAccentBar1 = 181;
    ///<summary></summary>
    LeftRightUpArrow = 182;
    ///<summary></summary>
    Sun = 183;
    ///<summary></summary>
    Moon = 184;
    ///<summary>
    ///  A shape enclosed in brackets.
    ///</summary>
    DoubleBracket = 185;
    ///<summary>
    ///  A shape enclosed in braces.
    ///</summary>
    DoubleBrace = 186;
    ///<summary></summary>
    Star4 = 187;
    ///<summary></summary>
    DoubleWave = 188;
    ///<summary></summary>
    BlankActionButton = 189;
    ///<summary></summary>
    HomeActionButton = 190;
    ///<summary></summary>
    HelpActionButton = 191;
    ///<summary></summary>
    InformationActionButton = 192;
    ///<summary></summary>
    ForwardNextActionButton = 193;
    ///<summary></summary>
    BackPreviousActionButton = 194;
    ///<summary></summary>
    EndActionButton = 195;
    ///<summary></summary>
    BeginningActionButton = 196;
    ///<summary></summary>
    ReturnActionButton = 197;
    ///<summary></summary>
    DocumentActionButton = 198;
    ///<summary></summary>
    SoundActionButton = 199;
    ///<summary></summary>
    MovieActionButton = 200;
    ///<summary>
    ///  This value SHOULD NOT be used.
    ///</summary>
    HostControl = 201;
    ///<summary></summary>
    TextBox = 202;
    ///<summary></summary>
    Heptagon = 2049;
    ///<summary></summary>
    Decagon = 2050;
    ///<summary></summary>
    Dodecagon = 2051;
    ///<summary></summary>
    Star6 = 2052;
    ///<summary></summary>
    Star7 = 2053;
    ///<summary></summary>
    Star10 = 2054;
    ///<summary></summary>
    Star12 = 2055;
    ///<summary></summary>
    RoundSingleCornerRectangle = 2056;
    ///<summary></summary>
    RoundSameSideCornerRectangle = 2057;
    ///<summary></summary>
    RoundDiagonalCornerRectangle = 2058;
    ///<summary></summary>
    SnipRoundSingleCornerRectangle = 2059;
    ///<summary></summary>
    SnipSingleCornerRectangle = 2060;
    ///<summary></summary>
    SnipSameSideCornerRectangle = 2061;
    ///<summary></summary>
    SnipDiagonalCornerRectangle = 2062;
    ///<summary></summary>
    Teardrop = 2063;
    ///<summary></summary>
    Pie = 2064;
    ///<summary></summary>
    HalfFrame = 2066;
    ///<summary></summary>
    L_Shape = 2067;
    ///<summary></summary>
    DiagonalStripe = 2068;
    ///<summary></summary>
    Chord = 2069;
    ///<summary></summary>
    Cloud = 2070;
    ///<summary></summary>
    MathPlus = 2071;
    ///<summary></summary>
    MathMinus = 2072;
    ///<summary></summary>
    MathMultiply = 2073;
    ///<summary></summary>
    MathDivide = 2074;
    ///<summary></summary>
    MathEqual = 2075;
    ///<summary></summary>
    MathNotEqual = 2076;
    ///<summary></summary>
    LineInv = 2077;
    ///<summary></summary>
    NonIsoscelesTrapezoid = 2078;
    ///<summary></summary>
    PieWedge = 2079;
    ///<summary></summary>
    LeftCircularArrow = 2080;
    ///<summary></summary>
    LeftRightCircularArrow = 2081;
    ///<summary></summary>
    SwooshArrow = 2082;
    ///<summary></summary>
    LeftRightRibbon = 2083;
    ///<summary></summary>
    TextNoShape = 2084;
    ///<summary></summary>
    Gear6 = 2097;
    ///<summary></summary>
    Gear9 = 2098;
    ///<summary></summary>
    Funnel = 2099;
    ///<summary></summary>
    CornerTabs = 2100;
    ///<summary></summary>
    SquareTabs = 2101;
    ///<summary></summary>
    PlaqueTabs = 2102;
    ///<summary></summary>
    ChartX = 2103;
    ///<summary></summary>
    ChartStar = 2104;
    ///<summary></summary>
    ChartPlus = 2105;
    ///<summary></summary>
    Frame = 2106;
    ///<summary></summary>
    Model3D = 2107;
    ///<summary>
    ///  There is no such type in Excel
    ///</summary>
    RoundCallout = 2108;
    ///<summary>
    ///  There is no such type in Excel
    ///</summary>
    TextArchLeftPour = 2109;
    ///<summary>
    ///  There is no such type in Excel
    ///</summary>
    TextArchRightPour = 2110;
    ///<summary>
    ///  There is no such type in Excel
    ///</summary>
    TextArchLeftCurve = 2111;
    ///<summary>
    ///  There is no such type in Excel
    ///</summary>
    TextArchRightCurve = 2112;
    ///<summary></summary>
    Unknown = 4095;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents a preset for a type of bevel which can be applied to a shape in 3D.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.BevelPresetType')]
  DNBevelPresetType = type Integer;
  DNBevelPresetTypeHelper = record helper for DNBevelPresetType
  public const
    ///<summary>
    ///  No bevel
    ///</summary>
    None = 0;
    ///<summary>
    ///  Angle
    ///</summary>
    Angle = 1;
    ///<summary>
    ///  Art deco
    ///</summary>
    ArtDeco = 2;
    ///<summary>
    ///  Circle
    ///</summary>
    Circle = 3;
    ///<summary>
    ///  Convex
    ///</summary>
    Convex = 4;
    ///<summary>
    ///  Cool slant
    ///</summary>
    CoolSlant = 5;
    ///<summary>
    ///  Cross
    ///</summary>
    Cross = 6;
    ///<summary>
    ///  Divot
    ///</summary>
    Divot = 7;
    ///<summary>
    ///  Hard edge
    ///</summary>
    HardEdge = 8;
    ///<summary>
    ///  Relaxed inset
    ///</summary>
    RelaxedInset = 9;
    ///<summary>
    ///  Riblet
    ///</summary>
    Riblet = 10;
    ///<summary>
    ///  Slope
    ///</summary>
    Slope = 11;
    ///<summary>
    ///  Soft round
    ///</summary>
    SoftRound = 12;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents a preset for a type of bevel which can be applied to a shape in 3D.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.BevelType')]
  DNBevelType = type Integer;
  DNBevelTypeHelper = record helper for DNBevelType
  public const
    ///<summary>
    ///  No bevel
    ///</summary>
    None = 0;
    ///<summary>
    ///  Angle
    ///</summary>
    Angle = 1;
    ///<summary>
    ///  Art deco
    ///</summary>
    ArtDeco = 2;
    ///<summary>
    ///  Circle
    ///</summary>
    Circle = 3;
    ///<summary>
    ///  Convex
    ///</summary>
    Convex = 4;
    ///<summary>
    ///  Cool slant
    ///</summary>
    CoolSlant = 5;
    ///<summary>
    ///  Cross
    ///</summary>
    Cross = 6;
    ///<summary>
    ///  Divot
    ///</summary>
    Divot = 7;
    ///<summary>
    ///  Hard edge
    ///</summary>
    HardEdge = 8;
    ///<summary>
    ///  Relaxed inset
    ///</summary>
    RelaxedInset = 9;
    ///<summary>
    ///  Riblet
    ///</summary>
    Riblet = 10;
    ///<summary>
    ///  Slope
    ///</summary>
    Slope = 11;
    ///<summary>
    ///  Soft round
    ///</summary>
    SoftRound = 12;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the check value type of the check box.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.CheckValueType')]
  DNCheckValueType = type Integer;
  DNCheckValueTypeHelper = record helper for DNCheckValueType
  public const
    ///<summary>
    ///  UnChecked
    ///</summary>
    UnChecked = 0;
    ///<summary>
    ///  Checked
    ///</summary>
    Checked = 1;
    ///<summary>
    ///  Mixed
    ///</summary>
    Mixed = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Specifies the preset shape geometry that is to be used for a chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.DataLabelShapeType')]
  DNDataLabelShapeType = type Integer;
  DNDataLabelShapeTypeHelper = record helper for DNDataLabelShapeType
  public const
    ///<summary>
    ///  Represents the rectangle shape.
    ///</summary>
    Rect = 0;
    ///<summary>
    ///  Represents the round rectangle shape.
    ///</summary>
    RoundRect = 1;
    ///<summary>
    ///  Represents the ellipse shape.
    ///</summary>
    Ellipse = 2;
    ///<summary>
    ///  Represents the right arrow callout shape.
    ///</summary>
    RightArrowCallout = 3;
    ///<summary>
    ///  Represents the down arrow callout shape.
    ///</summary>
    DownArrowCallout = 4;
    ///<summary>
    ///  Represents the left arrow callout shape.
    ///</summary>
    LeftArrowCallout = 5;
    ///<summary>
    ///  Represents the up arrow callout shape.
    ///</summary>
    UpArrowCallout = 6;
    ///<summary>
    ///  Represents the wedge rectangle callout shape.
    ///</summary>
    WedgeRectCallout = 7;
    ///<summary>
    ///  Represents the wedge round rectangle callout shape.
    ///</summary>
    WedgeRoundRectCallout = 8;
    ///<summary>
    ///  Represents the wedge ellipse callout shape.
    ///</summary>
    WedgeEllipseCallout = 9;
    ///<summary>
    ///  Represents the line callout shape.
    ///</summary>
    LineCallout = 10;
    ///<summary>
    ///  Represents the bent line callout  shape.
    ///</summary>
    BentLineCallout = 11;
    ///<summary>
    ///  Represents the line with accent bar callout shape.
    ///</summary>
    LineWithAccentBarCallout = 12;
    ///<summary>
    ///  Represents the bent line with accent bar callout shape.
    ///</summary>
    BentLineWithAccentBarCallout = 13;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Enumerates shape fill pattern types.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.FillPattern')]
  DNFillPattern = type Integer;
  DNFillPatternHelper = record helper for DNFillPattern
  public const
    ///<summary>
    ///  Represents no background.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Represents solid pattern.
    ///</summary>
    Solid = 1;
    ///<summary>
    ///  Represents 5% gray pattern.
    ///</summary>
    Gray5 = 2;
    ///<summary>
    ///  Represents 10% gray pattern.
    ///</summary>
    Gray10 = 3;
    ///<summary>
    ///  Represents 20% gray pattern.
    ///</summary>
    Gray20 = 4;
    ///<summary>
    ///  Represents 30% gray pattern.
    ///</summary>
    Gray30 = 5;
    ///<summary>
    ///  Represents 40% gray pattern.
    ///</summary>
    Gray40 = 6;
    ///<summary>
    ///  Represents 50% gray pattern.
    ///</summary>
    Gray50 = 7;
    ///<summary>
    ///  Represents 60% gray pattern.
    ///</summary>
    Gray60 = 8;
    ///<summary>
    ///  Represents 70% gray pattern.
    ///</summary>
    Gray70 = 9;
    ///<summary>
    ///  Represents 75% gray pattern.
    ///</summary>
    Gray75 = 10;
    ///<summary>
    ///  Represents 80% gray pattern.
    ///</summary>
    Gray80 = 11;
    ///<summary>
    ///  Represents 90% gray pattern.
    ///</summary>
    Gray90 = 12;
    ///<summary>
    ///  Represents 25% gray pattern.
    ///</summary>
    Gray25 = 13;
    ///<summary>
    ///  Represents light downward diagonal pattern.
    ///</summary>
    LightDownwardDiagonal = 14;
    ///<summary>
    ///  Represents light upward diagonal pattern.
    ///</summary>
    LightUpwardDiagonal = 15;
    ///<summary>
    ///  Represents dark downward diagonal pattern.
    ///</summary>
    DarkDownwardDiagonal = 16;
    ///<summary>
    ///  Represents dark upward diagonal pattern.
    ///</summary>
    DarkUpwardDiagonal = 17;
    ///<summary>
    ///  Represents wide downward diagonal pattern.
    ///</summary>
    WideDownwardDiagonal = 18;
    ///<summary>
    ///  Represents wide upward diagonal pattern.
    ///</summary>
    WideUpwardDiagonal = 19;
    ///<summary>
    ///  Represents light vertical pattern.
    ///</summary>
    LightVertical = 20;
    ///<summary>
    ///  Represents light horizontal pattern.
    ///</summary>
    LightHorizontal = 21;
    ///<summary>
    ///  Represents narrow vertical pattern.
    ///</summary>
    NarrowVertical = 22;
    ///<summary>
    ///  Represents narrow horizontal pattern.
    ///</summary>
    NarrowHorizontal = 23;
    ///<summary>
    ///  Represents dark vertical pattern.
    ///</summary>
    DarkVertical = 24;
    ///<summary>
    ///  Represents dark horizontal pattern.
    ///</summary>
    DarkHorizontal = 25;
    ///<summary>
    ///  Represents dashed downward diagonal pattern.
    ///</summary>
    DashedDownwardDiagonal = 26;
    ///<summary>
    ///  Represents dashed upward diagonal pattern.
    ///</summary>
    DashedUpwardDiagonal = 27;
    ///<summary>
    ///  Represents dashed vertical pattern.
    ///</summary>
    DashedVertical = 28;
    ///<summary>
    ///  Represents dashed horizontal pattern.
    ///</summary>
    DashedHorizontal = 29;
    ///<summary>
    ///  Represents small confetti pattern.
    ///</summary>
    SmallConfetti = 30;
    ///<summary>
    ///  Represents large confetti pattern.
    ///</summary>
    LargeConfetti = 31;
    ///<summary>
    ///  Represents zig zag pattern.
    ///</summary>
    ZigZag = 32;
    ///<summary>
    ///  Represents wave pattern.
    ///</summary>
    Wave = 33;
    ///<summary>
    ///  Represents diagonal brick pattern.
    ///</summary>
    DiagonalBrick = 34;
    ///<summary>
    ///  Represents horizontal brick pattern.
    ///</summary>
    HorizontalBrick = 35;
    ///<summary>
    ///  Represents weave pattern.
    ///</summary>
    Weave = 36;
    ///<summary>
    ///  Represents plaid pattern.
    ///</summary>
    Plaid = 37;
    ///<summary>
    ///  Represents divot pattern.
    ///</summary>
    Divot = 38;
    ///<summary>
    ///  Represents dotted grid pattern.
    ///</summary>
    DottedGrid = 39;
    ///<summary>
    ///  Represents dotted diamond pattern.
    ///</summary>
    DottedDiamond = 40;
    ///<summary>
    ///  Represents shingle pattern.
    ///</summary>
    Shingle = 41;
    ///<summary>
    ///  Represents trellis pattern.
    ///</summary>
    Trellis = 42;
    ///<summary>
    ///  Represents sphere pattern.
    ///</summary>
    Sphere = 43;
    ///<summary>
    ///  Represents small grid pattern.
    ///</summary>
    SmallGrid = 44;
    ///<summary>
    ///  Represents large grid pattern.
    ///</summary>
    LargeGrid = 45;
    ///<summary>
    ///  Represents small checker board pattern.
    ///</summary>
    SmallCheckerBoard = 46;
    ///<summary>
    ///  Represents large checker board pattern.
    ///</summary>
    LargeCheckerBoard = 47;
    ///<summary>
    ///  Represents outlined diamond pattern.
    ///</summary>
    OutlinedDiamond = 48;
    ///<summary>
    ///  Represents solid diamond pattern.
    ///</summary>
    SolidDiamond = 49;
    ///<summary>
    ///  Represents unknown pattern.
    ///</summary>
    Unknown = 50;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the picture fill type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.FillPictureType')]
  DNFillPictureType = type Integer;
  DNFillPictureTypeHelper = record helper for DNFillPictureType
  public const
    ///<summary>
    ///  Stretch
    ///</summary>
    Stretch = 0;
    ///<summary>
    ///  Stack
    ///</summary>
    Stack = 1;
    ///<summary>
    ///  StackAndScale
    ///</summary>
    StackAndScale = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Fill format type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.FillType')]
  DNFillType = type Integer;
  DNFillTypeHelper = record helper for DNFillType
  public const
    ///<summary>
    ///  Represents automatic formatting type.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  Represents none formatting type.
    ///</summary>
    None = 1;
    ///<summary>
    ///  Solid fill format.
    ///</summary>
    Solid = 2;
    ///<summary>
    ///  Gradient fill format.
    ///</summary>
    Gradient = 3;
    ///<summary>
    ///  Texture fill format(includes picture fill).
    ///</summary>
    Texture = 4;
    ///<summary>
    ///  Pattern fill format.
    ///</summary>
    Pattern = 5;
    ///<summary>
    ///  Inherit the fill properties of the group.
    ///</summary>
    Group = 6;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Fill format set type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.FormatSetType')]
  DNFormatSetType = type Integer;
  DNFormatSetTypeHelper = record helper for DNFormatSetType
  public const
    ///<summary>
    ///  No Fill format.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Gradient fill format.
    ///</summary>
    IsGradientSet = 1;
    ///<summary>
    ///  Texture fill format.
    ///</summary>
    IsTextureSet = 2;
    ///<summary>
    ///  Pattern fill format.
    ///</summary>
    IsPatternSet = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the gradient color type for the specified fill.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.GradientColorType')]
  DNGradientColorType = type Integer;
  DNGradientColorTypeHelper = record helper for DNGradientColorType
  public const
    ///<summary>
    ///  No gradient color
    ///</summary>
    None = 0;
    ///<summary>
    ///  One gradient color
    ///</summary>
    OneColor = 1;
    ///<summary>
    ///  Preset gradient colors
    ///</summary>
    PresetColors = 2;
    ///<summary>
    ///  Two gradient colors
    ///</summary>
    TwoColors = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents all direction type of gradient.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.GradientDirectionType')]
  DNGradientDirectionType = type Integer;
  DNGradientDirectionTypeHelper = record helper for DNGradientDirectionType
  public const
    ///<summary>
    ///  FromUpperLeftCorner
    ///</summary>
    FromUpperLeftCorner = 0;
    ///<summary>
    ///  FromUpperRightCorner
    ///</summary>
    FromUpperRightCorner = 1;
    ///<summary>
    ///  FromLowerLeftCorner
    ///</summary>
    FromLowerLeftCorner = 2;
    ///<summary>
    ///  FromLowerRightCorner
    ///</summary>
    FromLowerRightCorner = 3;
    ///<summary>
    ///  FromCenter
    ///</summary>
    FromCenter = 4;
    ///<summary>
    ///  Unknown
    ///</summary>
    Unknown = 5;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents all Gradient fill type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.GradientFillType')]
  DNGradientFillType = type Integer;
  DNGradientFillTypeHelper = record helper for DNGradientFillType
  public const
    ///<summary>
    ///  Linear
    ///</summary>
    Linear = 0;
    ///<summary>
    ///  Radial
    ///</summary>
    Radial = 1;
    ///<summary>
    ///  Rectangle
    ///</summary>
    Rectangle = 2;
    ///<summary>
    ///  Path
    ///</summary>
    Path = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents gradient preset color type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.GradientPresetType')]
  DNGradientPresetType = type Integer;
  DNGradientPresetTypeHelper = record helper for DNGradientPresetType
  public const
    ///<summary>
    ///  Brass preset color
    ///</summary>
    Brass = 0;
    ///<summary>
    ///  Calm Water preset color
    ///</summary>
    CalmWater = 1;
    ///<summary>
    ///  Chrome preset color
    ///</summary>
    Chrome = 2;
    ///<summary>
    ///  Chrome II preset color
    ///</summary>
    ChromeII = 3;
    ///<summary>
    ///  Daybreak preset color
    ///</summary>
    Daybreak = 4;
    ///<summary>
    ///  Desert preset color
    ///</summary>
    Desert = 5;
    ///<summary>
    ///  Early Sunset preset color
    ///</summary>
    EarlySunset = 6;
    ///<summary>
    ///  Fire preset color
    ///</summary>
    Fire = 7;
    ///<summary>
    ///  Fog preset color
    ///</summary>
    Fog = 8;
    ///<summary>
    ///  Gold preset color
    ///</summary>
    Gold = 9;
    ///<summary>
    ///  Gold II preset color
    ///</summary>
    GoldII = 10;
    ///<summary>
    ///  Horizon preset color
    ///</summary>
    Horizon = 11;
    ///<summary>
    ///  Late Sunset preset color
    ///</summary>
    LateSunset = 12;
    ///<summary>
    ///  Mahogany preset color
    ///</summary>
    Mahogany = 13;
    ///<summary>
    ///  Moss preset color
    ///</summary>
    Moss = 14;
    ///<summary>
    ///  Nightfall preset color
    ///</summary>
    Nightfall = 15;
    ///<summary>
    ///  Ocean preset color
    ///</summary>
    Ocean = 16;
    ///<summary>
    ///  Parchment preset color
    ///</summary>
    Parchment = 17;
    ///<summary>
    ///  Peacock preset color
    ///</summary>
    Peacock = 18;
    ///<summary>
    ///  Rainbow preset color
    ///</summary>
    Rainbow = 19;
    ///<summary>
    ///  Rainbow II preset color
    ///</summary>
    RainbowII = 20;
    ///<summary>
    ///  Sapphire preset color
    ///</summary>
    Sapphire = 21;
    ///<summary>
    ///  Silver preset color
    ///</summary>
    Silver = 22;
    ///<summary>
    ///  Wheat preset color
    ///</summary>
    Wheat = 23;
    ///<summary>
    ///  Unknown preset color.
    ///  Only for the preset color (which is not same as any known preset color) in the template workbook.
    ///</summary>
    Unknown = 24;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents gradient shading style.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.GradientStyleType')]
  DNGradientStyleType = type Integer;
  DNGradientStyleTypeHelper = record helper for DNGradientStyleType
  public const
    ///<summary>
    ///  Diagonal down shading style
    ///</summary>
    DiagonalDown = 0;
    ///<summary>
    ///  Diagonal up shading style
    ///</summary>
    DiagonalUp = 1;
    ///<summary>
    ///  From center shading style
    ///</summary>
    FromCenter = 2;
    ///<summary>
    ///  From corner shading style
    ///</summary>
    FromCorner = 3;
    ///<summary>
    ///  Horizontal shading style
    ///</summary>
    Horizontal = 4;
    ///<summary>
    ///  Vertical shading style
    ///</summary>
    Vertical = 5;
    ///<summary>
    ///  Unknown shading style.Only for the shading style(which is not for any member of the GradientStyleType) in the template file.
    ///</summary>
    Unknown = 6;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Specifies the type (format) of an image.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ImageType')]
  DNImageType = type Integer;
  DNImageTypeHelper = record helper for DNImageType
  public const
    ///<summary>
    ///  An unknown image type.
    ///</summary>
    Unknown = 0;
    ///<summary>
    ///  Windows Enhanced Metafile.
    ///</summary>
    Emf = 2;
    ///<summary>
    ///  Windows Metafile.
    ///</summary>
    Wmf = 3;
    ///<summary>
    ///  Macintosh PICT.
    ///</summary>
    Pict = 4;
    ///<summary>
    ///  JPEG JFIF.
    ///</summary>
    Jpeg = 5;
    ///<summary>
    ///  Portable Network Graphics.
    ///</summary>
    Png = 6;
    ///<summary>
    ///  Windows Bitmap
    ///</summary>
    Bmp = 7;
    ///<summary>
    ///  Gif
    ///</summary>
    Gif = 66;
    ///<summary>
    ///  Tiff
    ///</summary>
    Tiff = 67;
    ///<summary>
    ///  Svg
    ///</summary>
    Svg = 68;
    ///<summary>
    ///  Svm
    ///</summary>
    Svm = 69;
    ///<summary>
    ///  glTF
    ///</summary>
    Gltf = 70;
    ///<summary>
    ///  Windows Enhanced Metafile which is more compatible with Office.
    ///</summary>
    OfficeCompatibleEmf = 71;
    ///<summary>
    ///  Weppy image format
    ///</summary>
    WebP = 72;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the light rig direction type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.LightRigDirectionType')]
  DNLightRigDirectionType = type Integer;
  DNLightRigDirectionTypeHelper = record helper for DNLightRigDirectionType
  public const
    ///<summary>
    ///  Bottom
    ///</summary>
    Bottom = 0;
    ///<summary>
    ///  Bottom left.
    ///</summary>
    BottomLeft = 1;
    ///<summary>
    ///  Bottom Right.
    ///</summary>
    BottomRight = 2;
    ///<summary>
    ///  Left.
    ///</summary>
    Left = 3;
    ///<summary>
    ///  Right.
    ///</summary>
    Right = 4;
    ///<summary>
    ///  Top.
    ///</summary>
    Top = 5;
    ///<summary>
    ///  Top left.
    ///</summary>
    TopLeft = 6;
    ///<summary>
    ///  Top Right.
    ///</summary>
    TopRight = 7;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents a preset light right that can be applied to a shape
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.LightRigType')]
  DNLightRigType = type Integer;
  DNLightRigTypeHelper = record helper for DNLightRigType
  public const
    ///<summary>
    ///  Balanced
    ///</summary>
    Balanced = 0;
    ///<summary>
    ///  Bright room
    ///</summary>
    BrightRoom = 1;
    ///<summary>
    ///  Chilly
    ///</summary>
    Chilly = 2;
    ///<summary>
    ///  Contrasting
    ///</summary>
    Contrasting = 3;
    ///<summary>
    ///  Flat
    ///</summary>
    Flat = 4;
    ///<summary>
    ///  Flood
    ///</summary>
    Flood = 5;
    ///<summary>
    ///  Freezing
    ///</summary>
    Freezing = 6;
    ///<summary>
    ///  Glow
    ///</summary>
    Glow = 7;
    ///<summary>
    ///  Harsh
    ///</summary>
    Harsh = 8;
    ///<summary>
    ///  LegacyFlat1
    ///</summary>
    LegacyFlat1 = 9;
    ///<summary>
    ///  LegacyFlat2
    ///</summary>
    LegacyFlat2 = 10;
    ///<summary>
    ///  LegacyFlat3
    ///</summary>
    LegacyFlat3 = 11;
    ///<summary>
    ///  LegacyFlat4
    ///</summary>
    LegacyFlat4 = 12;
    ///<summary>
    ///  LegacyHarsh1
    ///</summary>
    LegacyHarsh1 = 13;
    ///<summary>
    ///  LegacyHarsh2
    ///</summary>
    LegacyHarsh2 = 14;
    ///<summary>
    ///  LegacyHarsh3
    ///</summary>
    LegacyHarsh3 = 15;
    ///<summary>
    ///  LegacyHarsh4
    ///</summary>
    LegacyHarsh4 = 16;
    ///<summary>
    ///  LegacyNormal1
    ///</summary>
    LegacyNormal1 = 17;
    ///<summary>
    ///  LegacyNormal2
    ///</summary>
    LegacyNormal2 = 18;
    ///<summary>
    ///  LegacyNormal3
    ///</summary>
    LegacyNormal3 = 19;
    ///<summary>
    ///  LegacyNormal4
    ///</summary>
    LegacyNormal4 = 20;
    ///<summary>
    ///  Morning
    ///</summary>
    Morning = 21;
    ///<summary>
    ///  Soft
    ///</summary>
    Soft = 22;
    ///<summary>
    ///  Sunrise
    ///</summary>
    Sunrise = 23;
    ///<summary>
    ///  Sunset
    ///</summary>
    Sunset = 24;
    ///<summary>
    ///  Three point
    ///</summary>
    ThreePoint = 25;
    ///<summary>
    ///  Two point
    ///</summary>
    TwoPoint = 26;
    ///<summary>
    ///  No light rig.
    ///</summary>
    None = 27;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the caps of a line
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.LineCapType')]
  DNLineCapType = type Integer;
  DNLineCapTypeHelper = record helper for DNLineCapType
  public const
    ///<summary>
    ///  Square protrudes by half line width.
    ///</summary>
    Square = 0;
    ///<summary>
    ///  Rounded ends.
    ///</summary>
    Round = 1;
    ///<summary>
    ///  Line ends at end point.
    ///</summary>
    Flat = 2;
    ///<summary>
    ///  None cap
    ///</summary>
    None = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the join styles of a line.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.LineJoinType')]
  DNLineJoinType = type Integer;
  DNLineJoinTypeHelper = record helper for DNLineJoinType
  public const
    ///<summary>
    ///  Round joint
    ///</summary>
    Round = 0;
    ///<summary>
    ///  Bevel joint
    ///</summary>
    Bevel = 1;
    ///<summary>
    ///  Miter joint
    ///</summary>
    Miter = 2;
    ///<summary>
    ///  None joint
    ///</summary>
    None = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Enumerates the type of <see cref="T:Aspose.Cells.Drawing.Picture" />
  ///  border or <see cref="T:Aspose.Cells.Charts.Chart" />
  ///  line.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.LineType')]
  DNLineType = type Integer;
  DNLineTypeHelper = record helper for DNLineType
  public const
    ///<summary>
    ///  Represent a solid line.
    ///</summary>
    Solid = 0;
    ///<summary>
    ///  Represent a dash line.
    ///</summary>
    Dash = 1;
    ///<summary>
    ///  Represents a dotted line.
    ///</summary>
    Dot = 2;
    ///<summary>
    ///  Represents a dash-dot line
    ///</summary>
    DashDot = 3;
    ///<summary>
    ///  Represents a dash-dot-dot line.
    ///</summary>
    DashDotDot = 4;
    ///<summary>
    ///  Represents a dark gray line.
    ///</summary>
    DarkGray = 6;
    ///<summary>
    ///  Represents a medium gray line.
    ///</summary>
    MediumGray = 7;
    ///<summary>
    ///  Represents a light gray line.
    ///</summary>
    LightGray = 8;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents mirror type of texture fill
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.MirrorType')]
  DNMirrorType = type Integer;
  DNMirrorTypeHelper = record helper for DNMirrorType
  public const
    ///<summary>
    ///  None
    ///</summary>
    None = 0;
    ///<summary>
    ///  Horizonal
    ///</summary>
    Horizonal = 1;
    ///<summary>
    ///  Vertical
    ///</summary>
    Vertical = 2;
    ///<summary>
    ///  Both
    ///</summary>
    Both = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Enumerates the line end width of the shape border line.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.MsoArrowheadLength')]
  DNMsoArrowheadLength = type Integer;
  DNMsoArrowheadLengthHelper = record helper for DNMsoArrowheadLength
  public const
    ///<summary>
    ///  Short line end length
    ///</summary>
    Short = 0;
    ///<summary>
    ///  Medium line end length
    ///</summary>
    Medium = 1;
    ///<summary>
    ///  Long line end length
    ///</summary>
    Long = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Enumerates the line end type of the shape border line.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.MsoArrowheadStyle')]
  DNMsoArrowheadStyle = type Integer;
  DNMsoArrowheadStyleHelper = record helper for DNMsoArrowheadStyle
  public const
    ///<summary>
    ///  No line end type.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Arrow line end type.
    ///</summary>
    Arrow = 1;
    ///<summary>
    ///  Arrow Stealth line end type.
    ///</summary>
    ArrowStealth = 2;
    ///<summary>
    ///  Arrow Diamond Line end type.
    ///</summary>
    ArrowDiamond = 3;
    ///<summary>
    ///  Arrow Oval line end type.
    ///</summary>
    ArrowOval = 4;
    ///<summary>
    ///  Arrow Open line end type.
    ///</summary>
    ArrowOpen = 5;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Enumerates the line end width of the shape border line.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.MsoArrowheadWidth')]
  DNMsoArrowheadWidth = type Integer;
  DNMsoArrowheadWidthHelper = record helper for DNMsoArrowheadWidth
  public const
    ///<summary>
    ///  Short line end width.
    ///</summary>
    Narrow = 0;
    ///<summary>
    ///  Medium line end width.
    ///</summary>
    Medium = 1;
    ///<summary>
    ///  Wide line end width.
    ///</summary>
    Wide = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents office drawing objects type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.MsoDrawingType')]
  DNMsoDrawingType = type Integer;
  DNMsoDrawingTypeHelper = record helper for DNMsoDrawingType
  public const
    ///<summary>
    ///  Group
    ///</summary>
    Group = 0;
    ///<summary>
    ///  Line
    ///</summary>
    Line = 1;
    ///<summary>
    ///  Rectangle
    ///</summary>
    Rectangle = 2;
    ///<summary>
    ///  Oval
    ///</summary>
    Oval = 3;
    ///<summary>
    ///  Arc
    ///</summary>
    Arc = 4;
    ///<summary>
    ///  Chart
    ///</summary>
    Chart = 5;
    ///<summary>
    ///  TextBox
    ///</summary>
    TextBox = 6;
    ///<summary>
    ///  Button
    ///</summary>
    Button = 7;
    ///<summary>
    ///  Picture
    ///</summary>
    Picture = 8;
    ///<summary>
    ///  Polygon
    ///</summary>
    Polygon = 9;
    ///<summary>
    ///  CheckBox
    ///</summary>
    CheckBox = 11;
    ///<summary>
    ///  RadioButton
    ///</summary>
    RadioButton = 12;
    ///<summary>
    ///  Label
    ///</summary>
    Label_ = 14;
    ///<summary>
    ///  DialogBox
    ///</summary>
    DialogBox = 15;
    ///<summary>
    ///  Spinner
    ///</summary>
    Spinner = 16;
    ///<summary>
    ///  ScrollBar
    ///</summary>
    ScrollBar = 17;
    ///<summary>
    ///  ListBox
    ///</summary>
    ListBox = 18;
    ///<summary>
    ///  GroupBox
    ///</summary>
    GroupBox = 19;
    ///<summary>
    ///  ComboBox
    ///</summary>
    ComboBox = 20;
    ///<summary>
    ///  OleObject
    ///</summary>
    OleObject = 24;
    ///<summary>
    ///  Comment
    ///</summary>
    Comment = 25;
    ///<summary>
    ///  Only for preserving the drawing object in the xlsx file.
    ///</summary>
    Unknown = 29;
    ///<summary>
    ///  Only for preserving the drawing object in the template file.
    ///</summary>
    CellsDrawing = 30;
    ///<summary>
    ///  Slicer
    ///</summary>
    Slicer = 31;
    ///<summary>
    ///  Web extension
    ///</summary>
    WebExtension = 32;
    ///<summary>
    ///  Smart Art
    ///</summary>
    SmartArt = 33;
    ///<summary>
    ///  Custom xml shape ,such as Ink.
    ///</summary>
    CustomXml = 34;
    ///<summary>
    ///  3D Model
    ///</summary>
    Model3D = 35;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents style of dash drawing lines.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.MsoLineDashStyle')]
  DNMsoLineDashStyle = type Integer;
  DNMsoLineDashStyleHelper = record helper for DNMsoLineDashStyle
  public const
    ///<summary>
    ///  Represent a dash line.
    ///</summary>
    Dash = 0;
    ///<summary>
    ///  Represents a dash-dot line.
    ///</summary>
    DashDot = 1;
    ///<summary>
    ///  Represents a dash-dot-dot line.
    ///</summary>
    DashDotDot = 2;
    ///<summary>
    ///  Represents a long dash-short dash line.
    ///</summary>
    DashLongDash = 3;
    ///<summary>
    ///  Represents a long dash-short dash-dot line.
    ///</summary>
    DashLongDashDot = 4;
    ///<summary>
    ///  Represents a round-dot line.
    ///</summary>
    RoundDot = 5;
    ///<summary>
    ///  Represent a solid line.
    ///</summary>
    Solid = 6;
    ///<summary>
    ///  Represents a square-dot line.
    ///</summary>
    SquareDot = 7;
    ///<summary>
    ///  Custom dash style.
    ///</summary>
    Custom = 8;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents style of drawing lines.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.MsoLineStyle')]
  DNMsoLineStyle = type Integer;
  DNMsoLineStyleHelper = record helper for DNMsoLineStyle
  public const
    ///<summary>
    ///  Single line (of width lineWidth)
    ///</summary>
    Single = 0;
    ///<summary>
    ///  Three lines, thin, thick, thin
    ///</summary>
    ThickBetweenThin = 1;
    ///<summary>
    ///  Double lines, one thin, one thick
    ///</summary>
    ThinThick = 2;
    ///<summary>
    ///  Double lines, one thick, one thin
    ///</summary>
    ThickThin = 3;
    ///<summary>
    ///  Double lines of equal width
    ///</summary>
    ThinThin = 4;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents preset text effect type of WordArt.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.MsoPresetTextEffect')]
  DNMsoPresetTextEffect = type Integer;
  DNMsoPresetTextEffectHelper = record helper for DNMsoPresetTextEffect
  public const
    ///<summary>
    ///  TextEffect1
    ///</summary>
    TextEffect1 = 0;
    ///<summary>
    ///  TextEffect2
    ///</summary>
    TextEffect2 = 1;
    ///<summary>
    ///  TextEffect3
    ///</summary>
    TextEffect3 = 2;
    ///<summary>
    ///  TextEffect4
    ///</summary>
    TextEffect4 = 3;
    ///<summary>
    ///  TextEffect5
    ///</summary>
    TextEffect5 = 4;
    ///<summary>
    ///  TextEffect6
    ///</summary>
    TextEffect6 = 5;
    ///<summary>
    ///  TextEffect7
    ///</summary>
    TextEffect7 = 6;
    ///<summary>
    ///  TextEffect8
    ///</summary>
    TextEffect8 = 7;
    ///<summary>
    ///  TextEffect9
    ///</summary>
    TextEffect9 = 8;
    ///<summary>
    ///  TextEffect10
    ///</summary>
    TextEffect10 = 9;
    ///<summary>
    ///  TextEffect11
    ///</summary>
    TextEffect11 = 10;
    ///<summary>
    ///  TextEffect12
    ///</summary>
    TextEffect12 = 11;
    ///<summary>
    ///  TextEffect13
    ///</summary>
    TextEffect13 = 12;
    ///<summary>
    ///  TextEffect14
    ///</summary>
    TextEffect14 = 13;
    ///<summary>
    ///  TextEffect15
    ///</summary>
    TextEffect15 = 14;
    ///<summary>
    ///  TextEffect16
    ///</summary>
    TextEffect16 = 15;
    ///<summary>
    ///  TextEffect17
    ///</summary>
    TextEffect17 = 16;
    ///<summary>
    ///  TextEffect18
    ///</summary>
    TextEffect18 = 17;
    ///<summary>
    ///  TextEffect19
    ///</summary>
    TextEffect19 = 18;
    ///<summary>
    ///  TextEffect20
    ///</summary>
    TextEffect20 = 19;
    ///<summary>
    ///  TextEffect21
    ///</summary>
    TextEffect21 = 20;
    ///<summary>
    ///  TextEffect22
    ///</summary>
    TextEffect22 = 21;
    ///<summary>
    ///  TextEffect23
    ///</summary>
    TextEffect23 = 22;
    ///<summary>
    ///  TextEffect24
    ///</summary>
    TextEffect24 = 23;
    ///<summary>
    ///  TextEffect25
    ///</summary>
    TextEffect25 = 24;
    ///<summary>
    ///  TextEffect26
    ///</summary>
    TextEffect26 = 25;
    ///<summary>
    ///  TextEffect27
    ///</summary>
    TextEffect27 = 26;
    ///<summary>
    ///  TextEffect28
    ///</summary>
    TextEffect28 = 27;
    ///<summary>
    ///  TextEffect29
    ///</summary>
    TextEffect29 = 28;
    ///<summary>
    ///  TextEffect30
    ///</summary>
    TextEffect30 = 29;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents preset text effect shape type of WordArt.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.MsoPresetTextEffectShape')]
  DNMsoPresetTextEffectShape = type Integer;
  DNMsoPresetTextEffectShapeHelper = record helper for DNMsoPresetTextEffectShape
  public const
    ///<summary>
    ///  PlainText
    ///</summary>
    PlainText = 136;
    ///<summary>
    ///  Stop
    ///</summary>
    Stop = 137;
    ///<summary>
    ///  TriangleUp
    ///</summary>
    TriangleUp = 138;
    ///<summary>
    ///  TriangleDown
    ///</summary>
    TriangleDown = 139;
    ///<summary>
    ///  ChevronUp
    ///</summary>
    ChevronUp = 140;
    ///<summary>
    ///  ChevronDown
    ///</summary>
    ChevronDown = 141;
    ///<summary>
    ///  RingInside
    ///</summary>
    RingInside = 142;
    ///<summary>
    ///  RingOutside
    ///</summary>
    RingOutside = 143;
    ///<summary>
    ///  ArchUpCurve
    ///</summary>
    ArchUpCurve = 144;
    ///<summary>
    ///  ArchDownCurve
    ///</summary>
    ArchDownCurve = 145;
    ///<summary>
    ///  CircleCurve
    ///</summary>
    CircleCurve = 146;
    ///<summary>
    ///  ButtonCurve
    ///</summary>
    ButtonCurve = 147;
    ///<summary>
    ///  ArchUpPour
    ///</summary>
    ArchUpPour = 148;
    ///<summary>
    ///  ArchDownPour
    ///</summary>
    ArchDownPour = 149;
    ///<summary>
    ///  CirclePour
    ///</summary>
    CirclePour = 150;
    ///<summary>
    ///  ButtonPour
    ///</summary>
    ButtonPour = 151;
    ///<summary>
    ///  CurveUp
    ///</summary>
    CurveUp = 152;
    ///<summary>
    ///  CurveDown
    ///</summary>
    CurveDown = 153;
    ///<summary>
    ///  CascadeUp
    ///</summary>
    CascadeUp = 154;
    ///<summary>
    ///  CascadeDown
    ///</summary>
    CascadeDown = 155;
    ///<summary>
    ///  Wave1
    ///</summary>
    Wave1 = 156;
    ///<summary>
    ///  Wave2
    ///</summary>
    Wave2 = 157;
    ///<summary>
    ///  DoubleWave1
    ///</summary>
    DoubleWave1 = 158;
    ///<summary>
    ///  DoubleWave2
    ///</summary>
    DoubleWave2 = 159;
    ///<summary>
    ///  Inflate
    ///</summary>
    Inflate = 160;
    ///<summary>
    ///  Deflate
    ///</summary>
    Deflate = 161;
    ///<summary>
    ///  InflateBottom
    ///</summary>
    InflateBottom = 162;
    ///<summary>
    ///  DeflateBottom
    ///</summary>
    DeflateBottom = 163;
    ///<summary>
    ///  InflateTop
    ///</summary>
    InflateTop = 164;
    ///<summary>
    ///  DeflateTop
    ///</summary>
    DeflateTop = 165;
    ///<summary>
    ///  DeflateInflate
    ///</summary>
    DeflateInflate = 166;
    ///<summary>
    ///  DeflateInflateDeflate
    ///</summary>
    DeflateInflateDeflate = 167;
    ///<summary>
    ///  FadeRight
    ///</summary>
    FadeRight = 168;
    ///<summary>
    ///  FadeLeft
    ///</summary>
    FadeLeft = 169;
    ///<summary>
    ///  FadeUp
    ///</summary>
    FadeUp = 170;
    ///<summary>
    ///  FadeDown
    ///</summary>
    FadeDown = 171;
    ///<summary>
    ///  SlantUp
    ///</summary>
    SlantUp = 172;
    ///<summary>
    ///  SlantDown
    ///</summary>
    SlantDown = 173;
    ///<summary>
    ///  CanUp
    ///</summary>
    CanUp = 174;
    ///<summary>
    ///  CanDown
    ///</summary>
    CanDown = 175;
    ///<summary>
    ///  Mixed
    ///</summary>
    Mixed = 255;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the way the drawing object is attached to the cells below it.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.PlacementType')]
  DNPlacementType = type Integer;
  DNPlacementTypeHelper = record helper for DNPlacementType
  public const
    ///<summary>
    ///  Don't move or size with cells.
    ///</summary>
    FreeFloating = 0;
    ///<summary>
    ///  Move but don't size with cells.
    ///</summary>
    Move = 1;
    ///<summary>
    ///  Move and size with cells.
    ///</summary>
    MoveAndSize = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represent different algorithmic methods for setting all camera properties, including position.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.PresetCameraType')]
  DNPresetCameraType = type Integer;
  DNPresetCameraTypeHelper = record helper for DNPresetCameraType
  public const
    ///<summary></summary>
    IsometricBottomDown = 0;
    ///<summary></summary>
    IsometricBottomUp = 1;
    ///<summary></summary>
    IsometricLeftDown = 2;
    ///<summary></summary>
    IsometricLeftUp = 3;
    ///<summary></summary>
    IsometricOffAxis1Left = 4;
    ///<summary></summary>
    IsometricOffAxis1Right = 5;
    ///<summary></summary>
    IsometricOffAxis1Top = 6;
    ///<summary></summary>
    IsometricOffAxis2Left = 7;
    ///<summary></summary>
    IsometricOffAxis2Right = 8;
    ///<summary></summary>
    IsometricOffAxis2Top = 9;
    ///<summary></summary>
    IsometricOffAxis3Bottom = 10;
    ///<summary></summary>
    IsometricOffAxis3Left = 11;
    ///<summary></summary>
    IsometricOffAxis3Right = 12;
    ///<summary></summary>
    IsometricOffAxis4Bottom = 13;
    ///<summary></summary>
    IsometricOffAxis4Left = 14;
    ///<summary></summary>
    IsometricOffAxis4Right = 15;
    ///<summary></summary>
    IsometricRightDown = 16;
    ///<summary></summary>
    IsometricRightUp = 17;
    ///<summary></summary>
    IsometricTopDown = 18;
    ///<summary></summary>
    IsometricTopUp = 19;
    ///<summary></summary>
    LegacyObliqueBottom = 20;
    ///<summary></summary>
    LegacyObliqueBottomLeft = 21;
    ///<summary></summary>
    LegacyObliqueBottomRight = 22;
    ///<summary></summary>
    LegacyObliqueFront = 23;
    ///<summary></summary>
    LegacyObliqueLeft = 24;
    ///<summary></summary>
    LegacyObliqueRight = 25;
    ///<summary></summary>
    LegacyObliqueTop = 26;
    ///<summary></summary>
    LegacyObliqueTopLeft = 27;
    ///<summary></summary>
    LegacyObliqueTopRight = 28;
    ///<summary></summary>
    LegacyPerspectiveBottom = 29;
    ///<summary></summary>
    LegacyPerspectiveBottomLeft = 30;
    ///<summary></summary>
    LegacyPerspectiveBottomRight = 31;
    ///<summary></summary>
    LegacyPerspectiveFront = 32;
    ///<summary></summary>
    LegacyPerspectiveLeft = 33;
    ///<summary></summary>
    LegacyPerspectiveRight = 34;
    ///<summary></summary>
    LegacyPerspectiveTop = 35;
    ///<summary></summary>
    LegacyPerspectiveTopLeft = 36;
    ///<summary></summary>
    LegacyPerspectiveTopRight = 37;
    ///<summary></summary>
    ObliqueBottom = 38;
    ///<summary></summary>
    ObliqueBottomLeft = 39;
    ///<summary></summary>
    ObliqueBottomRight = 40;
    ///<summary></summary>
    ObliqueLeft = 41;
    ///<summary></summary>
    ObliqueRight = 42;
    ///<summary></summary>
    ObliqueTop = 43;
    ///<summary></summary>
    ObliqueTopLeft = 44;
    ///<summary></summary>
    ObliqueTopRight = 45;
    ///<summary></summary>
    OrthographicFront = 46;
    ///<summary></summary>
    PerspectiveAbove = 47;
    ///<summary></summary>
    PerspectiveAboveLeftFacing = 48;
    ///<summary></summary>
    PerspectiveAboveRightFacing = 49;
    ///<summary></summary>
    PerspectiveBelow = 50;
    ///<summary></summary>
    PerspectiveContrastingLeftFacing = 51;
    ///<summary></summary>
    PerspectiveContrastingRightFacing = 52;
    ///<summary></summary>
    PerspectiveFront = 53;
    ///<summary></summary>
    PerspectiveHeroicExtremeLeftFacing = 54;
    ///<summary></summary>
    PerspectiveHeroicExtremeRightFacing = 55;
    ///<summary></summary>
    PerspectiveHeroicLeftFacing = 56;
    ///<summary></summary>
    PerspectiveHeroicRightFacing = 57;
    ///<summary></summary>
    PerspectiveLeft = 58;
    ///<summary></summary>
    PerspectiveRelaxed = 59;
    ///<summary></summary>
    PerspectiveRelaxedModerately = 60;
    ///<summary></summary>
    PerspectiveRight = 61;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Describes surface appearance of a shape.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.PresetMaterialType')]
  DNPresetMaterialType = type Integer;
  DNPresetMaterialTypeHelper = record helper for DNPresetMaterialType
  public const
    ///<summary>
    ///  Clear
    ///</summary>
    Clear = 0;
    ///<summary>
    ///  Dark edge
    ///</summary>
    DarkEdge = 1;
    ///<summary>
    ///  Flat
    ///</summary>
    Flat = 2;
    ///<summary>
    ///  Legacy matte
    ///</summary>
    LegacyMatte = 3;
    ///<summary>
    ///  Legacy metal
    ///</summary>
    LegacyMetal = 4;
    ///<summary>
    ///  Legacy plastic
    ///</summary>
    LegacyPlastic = 5;
    ///<summary>
    ///  Legacy wireframe
    ///</summary>
    LegacyWireframe = 6;
    ///<summary>
    ///  Matte
    ///</summary>
    Matte = 7;
    ///<summary>
    ///  Metal
    ///</summary>
    Metal = 8;
    ///<summary>
    ///  Plastic
    ///</summary>
    Plastic = 9;
    ///<summary>
    ///  Powder
    ///</summary>
    Powder = 10;
    ///<summary>
    ///  Soft edge
    ///</summary>
    SoftEdge = 11;
    ///<summary>
    ///  Soft metal
    ///</summary>
    SoftMetal = 12;
    ///<summary>
    ///  Translucent powder
    ///</summary>
    TranslucentPowder = 13;
    ///<summary>
    ///  Warm matte
    ///</summary>
    WarmMatte = 14;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents preset shadow type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.PresetShadowType')]
  DNPresetShadowType = type Integer;
  DNPresetShadowTypeHelper = record helper for DNPresetShadowType
  public const
    ///<summary>
    ///  No shadow.
    ///</summary>
    NoShadow = 0;
    ///<summary>
    ///  Custom shadow.
    ///</summary>
    Custom = 1;
    ///<summary>
    ///  Outer shadow offset diagonal bottom right.
    ///</summary>
    OffsetDiagonalBottomRight = 2;
    ///<summary>
    ///  Outer shadow offset bottom.
    ///</summary>
    OffsetBottom = 3;
    ///<summary>
    ///  Outer shadow offset diagonal bottom left.
    ///</summary>
    OffsetDiagonalBottomLeft = 4;
    ///<summary>
    ///  Outer shadow offset right.
    ///</summary>
    OffsetRight = 5;
    ///<summary>
    ///  Outer shadow offset center.
    ///</summary>
    OffsetCenter = 6;
    ///<summary>
    ///  Outer shadow offset left.
    ///</summary>
    OffsetLeft = 7;
    ///<summary>
    ///  Outer shadow offset diagonal top right.
    ///</summary>
    OffsetDiagonalTopRight = 8;
    ///<summary>
    ///  Outer shadow offset top.
    ///</summary>
    OffsetTop = 9;
    ///<summary>
    ///  Outer shadow offset diagonal top left.
    ///</summary>
    OffsetDiagonalTopLeft = 10;
    ///<summary>
    ///  Inner shadow inside diagonal top Left.
    ///</summary>
    InsideDiagonalTopLeft = 11;
    ///<summary>
    ///  Inner shadow inside top.
    ///</summary>
    InsideTop = 12;
    ///<summary>
    ///  Inner shadow inside diagonal top right.
    ///</summary>
    InsideDiagonalTopRight = 13;
    ///<summary>
    ///  Inner shadow inside left.
    ///</summary>
    InsideLeft = 14;
    ///<summary>
    ///  Inner shadow inside center.
    ///</summary>
    InsideCenter = 15;
    ///<summary>
    ///  Inner shadow inside right.
    ///</summary>
    InsideRight = 16;
    ///<summary>
    ///  Inner shadow inside diagonal bottom left.
    ///</summary>
    InsideDiagonalBottomLeft = 17;
    ///<summary>
    ///  Inner shadow inside bottom.
    ///</summary>
    InsideBottom = 18;
    ///<summary>
    ///  Inner shadow inside diagonal bottom right.
    ///</summary>
    InsideDiagonalBottomRight = 19;
    ///<summary>
    ///  Outer shadow perspective diagonal upper left.
    ///</summary>
    PerspectiveDiagonalUpperLeft = 20;
    ///<summary>
    ///  Outer shadow perspective diagonal upper right.
    ///</summary>
    PerspectiveDiagonalUpperRight = 21;
    ///<summary>
    ///  Outer shadow below.
    ///</summary>
    Below = 22;
    ///<summary>
    ///  Outer shadow perspective diagonal lower left.
    ///</summary>
    PerspectiveDiagonalLowerLeft = 23;
    ///<summary>
    ///  Outer shadow perspective diagonal lower right.
    ///</summary>
    PerspectiveDiagonalLowerRight = 24;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the preset WordArt styles.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.PresetWordArtStyle')]
  DNPresetWordArtStyle = type Integer;
  DNPresetWordArtStyleHelper = record helper for DNPresetWordArtStyle
  public const
    ///<summary>
    ///  Fill - Black, Text 1, Shadow
    ///</summary>
    WordArtStyle1 = 1;
    ///<summary>
    ///  Fill - Blue, Accent 1, Shadow
    ///</summary>
    WordArtStyle2 = 2;
    ///<summary>
    ///  Fill - Orange, Accent 2, Outline - Accent 2
    ///</summary>
    WordArtStyle3 = 3;
    ///<summary>
    ///  Fill - White, Outline - Accent 1, Shadow
    ///</summary>
    WordArtStyle4 = 4;
    ///<summary>
    ///  Fill - Gold, Accent 4, Soft Bevel
    ///</summary>
    WordArtStyle5 = 5;
    ///<summary>
    ///  Gradient Fill - Gray
    ///</summary>
    WordArtStyle6 = 6;
    ///<summary>
    ///  Gradient Fill - Blue, Accent 1, Reflection
    ///</summary>
    WordArtStyle7 = 7;
    ///<summary>
    ///  Gradient Fill - Gold, Accent 4, Outline - Accent 4
    ///</summary>
    WordArtStyle8 = 8;
    ///<summary>
    ///  Fill - White, Outline - Accent 1, Glow - Accent 1
    ///</summary>
    WordArtStyle9 = 9;
    ///<summary>
    ///  Fill - Gray-50%, Accent 3, Sharp Bevel
    ///</summary>
    WordArtStyle10 = 10;
    ///<summary>
    ///  Fill - Black, Text 1, Outline - Background 1, Hard Shadow - Background 1
    ///</summary>
    WordArtStyle11 = 11;
    ///<summary>
    ///  Fill - Black, Text 1, Outline - Background 1, Hard Shadow - Accent 1
    ///</summary>
    WordArtStyle12 = 12;
    ///<summary>
    ///  Fill - Blue, Accent 1, Outline - Background 1, Hard Shadow - Accent 1
    ///</summary>
    WordArtStyle13 = 13;
    ///<summary>
    ///  Fill - White, Outline - Accent 2, Hard Shadow - Accent 2
    ///</summary>
    WordArtStyle14 = 14;
    ///<summary>
    ///  Fill - Gray-25%, Background 2, Inner Shadow
    ///</summary>
    WordArtStyle15 = 15;
    ///<summary>
    ///  Pattern Fill - White, Text 2, Dark Upward Diagonal, Shadow
    ///</summary>
    WordArtStyle16 = 16;
    ///<summary>
    ///  Pattern Fill - Gray-50%, Accent 3, Narrow Horizontal, Inner Shadow
    ///</summary>
    WordArtStyle17 = 17;
    ///<summary>
    ///  Fill - Blue, Accent 1, 50%, Hard Shadow - Accent 1
    ///</summary>
    WordArtStyle18 = 18;
    ///<summary>
    ///  Pattern Fill - Blue, Accent 1, Light Downward Diagonal, Outline - Accent 1
    ///</summary>
    WordArtStyle19 = 19;
    ///<summary>
    ///  Pattern Fill - Blue-Gray, Text 2, Dark Upward Diagonal, Hard Shadow - Text 2
    ///</summary>
    WordArtStyle20 = 20;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents how to position two rectangles relative to each other.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.RectangleAlignmentType')]
  DNRectangleAlignmentType = type Integer;
  DNRectangleAlignmentTypeHelper = record helper for DNRectangleAlignmentType
  public const
    ///<summary>
    ///  Bottom
    ///</summary>
    Bottom = 0;
    ///<summary>
    ///  BottomLeft
    ///</summary>
    BottomLeft = 1;
    ///<summary>
    ///  BottomRight
    ///</summary>
    BottomRight = 2;
    ///<summary>
    ///  Center
    ///</summary>
    Center = 3;
    ///<summary>
    ///  Left
    ///</summary>
    Left = 4;
    ///<summary>
    ///  Right
    ///</summary>
    Right = 5;
    ///<summary>
    ///  Top
    ///</summary>
    Top = 6;
    ///<summary>
    ///  TopLeft
    ///</summary>
    TopLeft = 7;
    ///<summary>
    ///  TopRight
    ///</summary>
    TopRight = 8;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary></summary>
  [DNTypeName('Aspose.Cells.Drawing.ReflectionEffectType')]
  DNReflectionEffectType = type Integer;
  DNReflectionEffectTypeHelper = record helper for DNReflectionEffectType
  public const
    ///<summary>
    ///  No reflection effect.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Custom reflection effect.
    ///</summary>
    Custom = 1;
    ///<summary>
    ///  Tight reflection, touching.
    ///</summary>
    TightReflectionTouching = 2;
    ///<summary>
    ///  Half reflection, touching.
    ///</summary>
    HalfReflectionTouching = 3;
    ///<summary>
    ///  Full reflection, touching.
    ///</summary>
    FullReflectionTouching = 4;
    ///<summary>
    ///  Tight reflection, 4 pt offset.
    ///</summary>
    TightReflection4PtOffset = 5;
    ///<summary>
    ///  Half reflection, 4 pt offset.
    ///</summary>
    HalfReflection4PtOffset = 6;
    ///<summary>
    ///  Full reflection, 4 pt offset.
    ///</summary>
    FullReflection4PtOffset = 7;
    ///<summary>
    ///  Tight reflection, 8 pt offset.
    ///</summary>
    TightReflection8PtOffset = 8;
    ///<summary>
    ///  Half reflection, 8 pt offset.
    ///</summary>
    HalfReflection8PtOffset = 9;
    ///<summary>
    ///  Full reflection, 8 pt offset.
    ///</summary>
    FullReflection8PtOffset = 10;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  The selection type of list box.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.SelectionType')]
  DNSelectionType = type Integer;
  DNSelectionTypeHelper = record helper for DNSelectionType
  public const
    ///<summary>
    ///  Sigle selection type.
    ///</summary>
    Single = 0;
    ///<summary>
    ///  Multiple selection type.
    ///</summary>
    Multi = 1;
    ///<summary>
    ///  Extend selection type.
    ///</summary>
    Extend = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the anchor type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ShapeAnchorType')]
  DNShapeAnchorType = type Integer;
  DNShapeAnchorTypeHelper = record helper for DNShapeAnchorType
  public const
    ///<summary>
    ///  Represents a two cell anchor placeholder
    ///</summary>
    TwoCellAnchor = 0;
    ///<summary>
    ///  Represents a one cell anchor placeholder
    ///</summary>
    OneCellAnchor = 1;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents type of the property to be locked.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ShapeLockType')]
  DNShapeLockType = type Integer;
  DNShapeLockTypeHelper = record helper for DNShapeLockType
  public const
    ///<summary>
    ///  Group
    ///</summary>
    Group = 0;
    ///<summary>
    ///  AdjustHandles
    ///</summary>
    AdjustHandles = 1;
    ///<summary>
    ///  Text
    ///</summary>
    Text = 2;
    ///<summary>
    ///  Points
    ///</summary>
    Points = 3;
    ///<summary>
    ///  Crop
    ///</summary>
    Crop = 4;
    ///<summary>
    ///  Selection
    ///</summary>
    Selection = 5;
    ///<summary>
    ///  Move
    ///</summary>
    Move = 6;
    ///<summary>
    ///  AspectRatio
    ///</summary>
    AspectRatio = 7;
    ///<summary>
    ///  Rotation
    ///</summary>
    Rotation = 8;
    ///<summary>
    ///  Ungroup
    ///</summary>
    Ungroup = 9;
    ///<summary>
    ///  Resize
    ///</summary>
    Resize = 10;
    ///<summary>
    ///  ShapeType
    ///</summary>
    ShapeType = 11;
    ///<summary>
    ///  Arrowhead
    ///</summary>
    Arrowhead = 12;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents path segment type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ShapePathType')]
  DNShapePathType = type Integer;
  DNShapePathTypeHelper = record helper for DNShapePathType
  public const
    ///<summary>
    ///  Straight line segment
    ///</summary>
    LineTo = 0;
    ///<summary>
    ///  Cubic Bezier curve
    ///</summary>
    CubicBezierCurveTo = 1;
    ///<summary>
    ///  Start a new path
    ///</summary>
    MoveTo = 2;
    ///<summary>
    ///  If the starting POINT and the end POINT are not the same, a single
    ///  straight line is drawn to connect the starting POINT and ending POINT of the path.
    ///</summary>
    Close = 3;
    ///<summary>
    ///  The end of the current path
    ///</summary>
    End_ = 4;
    ///<summary>
    ///  Escape
    ///</summary>
    Escape = 5;
    ///<summary>
    ///  An arc
    ///</summary>
    ArcTo = 6;
    ///<summary>
    ///  Unknown
    ///</summary>
    Unknown = 7;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the way the text vertical or horizontal overflow.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.TextOverflowType')]
  DNTextOverflowType = type Integer;
  DNTextOverflowTypeHelper = record helper for DNTextOverflowType
  public const
    ///<summary>
    ///  Pay attention to top and bottom barriers.
    ///  Provide no indication that there is text which is not visible.
    ///</summary>
    Clip = 0;
    ///<summary>
    ///  Pay attention to top and bottom barriers.
    ///  Use an ellipsis to denote that there is text which is not visible.
    ///  Only for vertical overflow.
    ///</summary>
    Ellipsis = 1;
    ///<summary>
    ///  Overflow the text and pay no attention to top and bottom barriers.
    ///</summary>
    Overflow = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing.Texts----------------
  ///<summary>
  ///  Represents the type of the bullet.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.Texts.BulletType')]
  DNBulletType = type Integer;
  DNBulletTypeHelper = record helper for DNBulletType
  public const
    ///<summary>
    ///  No bullet.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Character bullet.
    ///</summary>
    Character = 1;
    ///<summary>
    ///  Image bullet.
    ///</summary>
    Picture = 2;
    ///<summary>
    ///  Automatic numbered bullet.
    ///</summary>
    AutoNumbered = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing.Texts----------------
  ///<summary>
  ///  Represents the unit type of line space size.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.Texts.LineSpaceSizeType')]
  DNLineSpaceSizeType = type Integer;
  DNLineSpaceSizeTypeHelper = record helper for DNLineSpaceSizeType
  public const
    ///<summary>
    ///  Represents in unit of a percentage of the text size.
    ///</summary>
    Percentage = 0;
    ///<summary>
    ///  Represents in unit of points.
    ///</summary>
    Points = 1;
  end;


  //-------------namespace: Aspose.Cells.Drawing.Texts----------------
  ///<summary>
  ///  Represents all automatic number scheme.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.Texts.TextAutonumberScheme')]
  DNTextAutonumberScheme = type Integer;
  DNTextAutonumberSchemeHelper = record helper for DNTextAutonumberScheme
  public const
    ///<summary></summary>
    None = 0;
    ///<summary>
    ///  (a), (b), (c), …
    ///</summary>
    AlphaLcParenBoth = 1;
    ///<summary>
    ///  a), b), c), …
    ///</summary>
    AlphaLcParenR = 2;
    ///<summary>
    ///  a., b., c., …
    ///</summary>
    AlphaLcPeriod = 3;
    ///<summary>
    ///  (A), (B), (C), …
    ///</summary>
    AlphaUcParenBoth = 4;
    ///<summary>
    ///  A), B), C), …
    ///</summary>
    AlphaUcParenR = 5;
    ///<summary>
    ///  A., B., C., …
    ///</summary>
    AlphaUcPeriod = 6;
    ///<summary>
    ///  Bidi Arabic 1 (AraAlpha) with ANSI minus symbol
    ///</summary>
    Arabic1Minus = 7;
    ///<summary>
    ///  Bidi Arabic 2 (AraAbjad) with ANSI minus symbol
    ///</summary>
    Arabic2Minus = 8;
    ///<summary>
    ///  Dbl-byte Arabic numbers w/ double-byte period
    ///</summary>
    ArabicDbPeriod = 9;
    ///<summary>
    ///  Dbl-byte Arabic numbers
    ///</summary>
    ArabicDbPlain = 10;
    ///<summary>
    ///  (1), (2), (3), …
    ///</summary>
    ArabicParenBoth = 11;
    ///<summary>
    ///  1), 2), 3), …
    ///</summary>
    ArabicParenR = 12;
    ///<summary>
    ///  1., 2., 3., …
    ///</summary>
    ArabicPeriod = 13;
    ///<summary>
    ///  1, 2, 3, …
    ///</summary>
    ArabicPlain = 14;
    ///<summary>
    ///  Dbl-byte circle numbers (1-10 circle[0x2460-], 11-arabic numbers)
    ///</summary>
    CircleNumDbPlain = 15;
    ///<summary>
    ///  Wingdings black circle numbers
    ///</summary>
    CircleNumWdBlackPlain = 16;
    ///<summary>
    ///  Wingdings white circle numbers (0-10 circle[0x0080-],11- arabic numbers)
    ///</summary>
    CircleNumWdWhitePlain = 17;
    ///<summary>
    ///  EA: Simplified Chinese w/ single-byte period
    ///</summary>
    Ea1ChsPeriod = 18;
    ///<summary>
    ///  EA: Simplified Chinese (TypeA 1-99, TypeC 100-)
    ///</summary>
    Ea1ChsPlain = 19;
    ///<summary>
    ///  EA: Traditional Chinese w/ single-byte period
    ///</summary>
    Ea1ChtPeriod = 20;
    ///<summary>
    ///  EA: Traditional Chinese (TypeA 1-19, TypeC 20-)
    ///</summary>
    Ea1ChtPlain = 21;
    ///<summary>
    ///  EA: Japanese w/ double-byte period
    ///</summary>
    Ea1JpnChsDbPeriod = 22;
    ///<summary>
    ///  EA: Japanese/Korean w/ single-byte period
    ///</summary>
    Ea1JpnKorPeriod = 23;
    ///<summary>
    ///  EA: Japanese/Korean (TypeC 1-)
    ///</summary>
    Ea1JpnKorPlain = 24;
    ///<summary>
    ///  Bidi Hebrew 2 with ANSI minus symbol
    ///</summary>
    Hebrew2Minus = 25;
    ///<summary>
    ///  Hindi alphabet period - consonants
    ///</summary>
    HindiAlpha1Period = 26;
    ///<summary>
    ///  Hindi alphabet period - vowels
    ///</summary>
    HindiAlphaPeriod = 27;
    ///  /// <summary>
    ///  Hindi numerical parentheses - right
    ///</summary>
    HindiNumParenR = 28;
    ///<summary>
    ///  Hindi numerical period
    ///</summary>
    HindiNumPeriod = 29;
    ///<summary>
    ///  (i), (ii), (iii), …
    ///</summary>
    RomanLcParenBoth = 30;
    ///<summary>
    ///  i), ii), iii), …
    ///</summary>
    RomanLcParenR = 31;
    ///<summary>
    ///  i., ii., iii., …
    ///</summary>
    RomanLcPeriod = 32;
    ///<summary>
    ///  (I), (II), (III), …
    ///</summary>
    RomanUcParenBoth = 33;
    ///<summary>
    ///  I), II), III), …
    ///</summary>
    RomanUcParenR = 34;
    ///<summary>
    ///  I., II., III., …
    ///</summary>
    RomanUcPeriod = 35;
    ///<summary>
    ///  Thai alphabet parentheses - both
    ///</summary>
    ThaiAlphaParenBoth = 36;
    ///<summary>
    ///  Thai alphabet parentheses - right
    ///</summary>
    ThaiAlphaParenR = 37;
    ///<summary>
    ///  Thai alphabet period
    ///</summary>
    ThaiAlphaPeriod = 38;
    ///<summary>
    ///  Thai numerical parentheses - both
    ///</summary>
    ThaiNumParenBoth = 39;
    ///<summary>
    ///  Thai numerical parentheses - right
    ///</summary>
    ThaiNumParenR = 40;
    ///<summary>
    ///  Thai numerical period
    ///</summary>
    ThaiNumPeriod = 41;
  end;


  //-------------namespace: Aspose.Cells.Drawing.Texts----------------
  ///<summary>
  ///  Represents the different types of font alignment.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.Texts.TextFontAlignType')]
  DNTextFontAlignType = type Integer;
  DNTextFontAlignTypeHelper = record helper for DNTextFontAlignType
  public const
    ///<summary>
    ///  When the text flow is horizontal or simple vertical same as fontBaseline
    ///  but for other vertical modes same as fontCenter.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  The letters are anchored to the very bottom of a single line.
    ///</summary>
    Bottom = 1;
    ///<summary>
    ///  The letters are anchored to the bottom baseline of a single line.
    ///</summary>
    Baseline = 2;
    ///<summary>
    ///  The letters are anchored between the two baselines of a single line.
    ///</summary>
    Center = 3;
    ///<summary>
    ///  The letters are anchored to the top baseline of a single dline.
    ///</summary>
    Top = 4;
  end;


  //-------------namespace: Aspose.Cells.Drawing.Texts----------------
  ///<summary>
  ///  Represents the node type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.Texts.TextNodeType')]
  DNTextNodeType = type Integer;
  DNTextNodeTypeHelper = record helper for DNTextNodeType
  public const
    ///<summary>
    ///  Represents the text node.
    ///</summary>
    TextRun = 0;
    ///<summary>
    ///  Represents the text paragraph.
    ///</summary>
    TextParagraph = 1;
    ///<summary>
    ///  Represents the equation text.
    ///</summary>
    Equation = 2;
  end;


  //-------------namespace: Aspose.Cells.Drawing.Texts----------------
  ///<summary>
  ///  Represents the text tab alignment types.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.Texts.TextTabAlignmentType')]
  DNTextTabAlignmentType = type Integer;
  DNTextTabAlignmentTypeHelper = record helper for DNTextTabAlignmentType
  public const
    ///<summary>
    ///  The text at this tab stop is center aligned.
    ///</summary>
    Center = 0;
    ///<summary>
    ///  At this tab stop, the decimals are lined up.
    ///</summary>
    Decimal = 1;
    ///<summary>
    ///  The text at this tab stop is left aligned.
    ///</summary>
    Left = 2;
    ///<summary>
    ///  The text at this tab stop is right aligned.
    ///</summary>
    Right = 3;
  end;


  //-------------namespace: Aspose.Cells.Drawing.Texts----------------
  ///<summary>
  ///  Represents the text direct type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.Texts.TextVerticalType')]
  DNTextVerticalType = type Integer;
  DNTextVerticalTypeHelper = record helper for DNTextVerticalType
  public const
    ///<summary>
    ///  East Asian Vertical display.
    ///</summary>
    Vertical = 0;
    ///<summary>
    ///  Horizontal text.
    ///</summary>
    Horizontal = 1;
    ///<summary>
    ///  Displayed vertical and the text flows top down then LEFT to RIGHT
    ///</summary>
    VerticalLeftToRight = 2;
    ///<summary>
    ///  Each line is 90 degrees rotated clockwise
    ///</summary>
    Vertical90 = 3;
    ///<summary>
    ///  Each line is 270 degrees rotated clockwise
    ///</summary>
    Vertical270 = 4;
    ///<summary>
    ///  Determines if all of the text is vertical
    ///</summary>
    Stacked = 5;
    ///<summary>
    ///  Specifies that vertical WordArt should be shown from right to left rather than left to right.
    ///</summary>
    StackedRightToLeft = 6;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Represents the preset texture type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.TextureType')]
  DNTextureType = type Integer;
  DNTextureTypeHelper = record helper for DNTextureType
  public const
    ///<summary>
    ///  Represents Blue Tissue Paper texture type.
    ///</summary>
    BlueTissuePaper = 0;
    ///<summary>
    ///  Represents Bouquet texture type.
    ///</summary>
    Bouquet = 1;
    ///<summary>
    ///  Represents Brown Marble texture type.
    ///</summary>
    BrownMarble = 2;
    ///<summary>
    ///  Represents Canvas texture type.
    ///</summary>
    Canvas = 3;
    ///<summary>
    ///  Represents Cork texture type.
    ///</summary>
    Cork = 4;
    ///<summary>
    ///  Represents Denim texture type.
    ///</summary>
    Denim = 5;
    ///<summary>
    ///  Represents Fish Fossil texture type.
    ///</summary>
    FishFossil = 6;
    ///<summary>
    ///  Represents Granite texture type.
    ///</summary>
    Granite = 7;
    ///<summary>
    ///  Represents Green Marble texture type.
    ///</summary>
    GreenMarble = 8;
    ///<summary>
    ///  Represents Medium Wood texture type.
    ///</summary>
    MediumWood = 9;
    ///<summary>
    ///  Represents Newsprint texture type.
    ///</summary>
    Newsprint = 10;
    ///<summary>
    ///  Represents Oak texture type.
    ///</summary>
    Oak = 11;
    ///<summary>
    ///  Represents Paper Bag texture type.
    ///</summary>
    PaperBag = 12;
    ///<summary>
    ///  Represents Papyrus texture type.
    ///</summary>
    Papyrus = 13;
    ///<summary>
    ///  Represents Parchment texture type.
    ///</summary>
    Parchment = 14;
    ///<summary>
    ///  Represents Pink Tissue Paper texture type.
    ///</summary>
    PinkTissuePaper = 15;
    ///<summary>
    ///  Represents Purple Mesh texture type.
    ///</summary>
    PurpleMesh = 16;
    ///<summary>
    ///  Represents Recycled Paper texture type.
    ///</summary>
    RecycledPaper = 17;
    ///<summary>
    ///  Represents Sand texture type.
    ///</summary>
    Sand = 18;
    ///<summary>
    ///  Represents Stationery texture type.
    ///</summary>
    Stationery = 19;
    ///<summary>
    ///  Represents Walnut Droplets texture type.
    ///</summary>
    Walnut = 20;
    ///<summary>
    ///  Represents Water Droplets texture type.
    ///</summary>
    WaterDroplets = 21;
    ///<summary>
    ///  Represents White Marble texture type.
    ///</summary>
    WhiteMarble = 22;
    ///<summary>
    ///  Represents Woven Mat texture type.
    ///</summary>
    WovenMat = 23;
    ///<summary>
    ///  Represents Unknown texture type.
    ///</summary>
    Unknown = 24;
  end;


  //-------------namespace: Aspose.Cells.Drawing----------------
  ///<summary>
  ///  Enumerates the weight types for a picture border or a chart line.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.WeightType')]
  DNWeightType = type Integer;
  DNWeightTypeHelper = record helper for DNWeightType
  public const
    ///<summary>
    ///  Represents the weight of single line.
    ///</summary>
    SingleLine = 0;
    ///<summary>
    ///  Represents the weight of medium line.
    ///</summary>
    MediumLine = 1;
    ///<summary>
    ///  Represents the weight of wide line.
    ///</summary>
    WideLine = 2;
    ///<summary>
    ///  Represents the weight of hair line.
    ///</summary>
    HairLine = -1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Dynamic filter type.
  ///</summary>
  [DNTypeName('Aspose.Cells.DynamicFilterType')]
  DNDynamicFilterType = type Integer;
  DNDynamicFilterTypeHelper = record helper for DNDynamicFilterType
  public const
    ///<summary>
    ///  Shows values that are above average.
    ///</summary>
    AboveAverage = 0;
    ///<summary>
    ///  Shows values that are below average.
    ///</summary>
    BelowAverage = 1;
    ///<summary>
    ///  Shows last month's dates.
    ///</summary>
    LastMonth = 2;
    ///<summary>
    ///  Shows last quarter's dates.
    ///</summary>
    LastQuarter = 3;
    ///<summary>
    ///  Shows last week's dates.
    ///</summary>
    LastWeek = 4;
    ///<summary>
    ///  Shows last year's dates.
    ///</summary>
    LastYear = 5;
    ///<summary>
    ///  Shows the dates that are in January, regardless of year.
    ///</summary>
    January = 6;
    ///<summary>
    ///  Shows the dates that are in October, regardless of year.
    ///</summary>
    October = 7;
    ///<summary>
    ///  Shows the dates that are in November, regardless of year.
    ///</summary>
    November = 8;
    ///<summary>
    ///  Shows the dates that are in December, regardless of year.
    ///</summary>
    December = 9;
    ///<summary>
    ///  Shows the dates that are in February, regardless of year.
    ///</summary>
    February = 10;
    ///<summary>
    ///  Shows the dates that are in March, regardless of year.
    ///</summary>
    March = 11;
    ///<summary>
    ///  Shows the dates that are in April, regardless of year.
    ///</summary>
    April = 12;
    ///<summary>
    ///  Shows the dates that are in May, regardless of year.
    ///</summary>
    May = 13;
    ///<summary>
    ///  Shows the dates that are in June, regardless of year.
    ///</summary>
    June = 14;
    ///<summary>
    ///  Shows the dates that are in July, regardless of year.
    ///</summary>
    July = 15;
    ///<summary>
    ///  Shows the dates that are in August, regardless of year.
    ///</summary>
    August = 16;
    ///<summary>
    ///  Shows the dates that are in September, regardless of year.
    ///</summary>
    September = 17;
    ///<summary>
    ///  Shows next month's dates.
    ///</summary>
    NextMonth = 18;
    ///<summary>
    ///  Shows next quarter's dates.
    ///</summary>
    NextQuarter = 19;
    ///<summary>
    ///  Shows next week's dates.
    ///</summary>
    NextWeek = 20;
    ///<summary>
    ///  Shows next year's dates.
    ///</summary>
    NextYear = 21;
    ///<summary>
    ///  None.
    ///</summary>
    None = 22;
    ///<summary>
    ///  Shows the dates that are in the 1st quarter, regardless of year.
    ///</summary>
    Quarter1 = 23;
    ///<summary>
    ///  Shows the dates that are in the 2nd quarter, regardless of year.
    ///</summary>
    Quarter2 = 24;
    ///<summary>
    ///  Shows the dates that are in the 3rd quarter, regardless of year.
    ///</summary>
    Quarter3 = 25;
    ///<summary>
    ///  Shows the dates that are in the 4th quarter, regardless of year.
    ///</summary>
    Quarter4 = 26;
    ///<summary>
    ///  Shows this month's dates.
    ///</summary>
    ThisMonth = 27;
    ///<summary>
    ///  Shows this quarter's dates.
    ///</summary>
    ThisQuarter = 28;
    ///<summary>
    ///  Shows this week's dates.
    ///</summary>
    ThisWeek = 29;
    ///<summary>
    ///  Shows this year's dates.
    ///</summary>
    ThisYear = 30;
    ///<summary>
    ///  Shows today's dates.
    ///</summary>
    Today = 31;
    ///<summary>
    ///  Shows tomorrow's dates.
    ///</summary>
    Tomorrow = 32;
    ///<summary>
    ///  Shows the dates between the beginning of the year and today, inclusive.
    ///</summary>
    YearToDate = 33;
    ///<summary>
    ///  Shows yesterday's dates.
    ///</summary>
    Yesterday = 34;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Setting for rendering Emf metafile.
  ///</summary>
  [DNTypeName('Aspose.Cells.EmfRenderSetting')]
  DNEmfRenderSetting = type Integer;
  DNEmfRenderSettingHelper = record helper for DNEmfRenderSetting
  public const
    ///<summary>
    ///  Only rendering Emf records.
    ///</summary>
    EmfOnly = 0;
    ///<summary>
    ///  Prefer rendering EmfPlus records.
    ///</summary>
    EmfPlusPrefer = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Encryption Type.
  ///  Only used by excel2003.
  ///  We will encrypt 2007/2010 workbook using SHA AES the same as Excel does, and this EncryptionType will be ignored.
  ///</summary>
  [DNTypeName('Aspose.Cells.EncryptionType')]
  DNEncryptionType = type Integer;
  DNEncryptionTypeHelper = record helper for DNEncryptionType
  public const
    ///<summary></summary>
    XOR_ = 0;
    ///<summary>
    ///  Office 97/2000 compatible.
    ///</summary>
    Compatible = 1;
    ///<summary></summary>
    EnhancedCryptographicProviderV1 = 2;
    ///<summary></summary>
    StrongCryptographicProvider = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents all error check type.
  ///</summary>
  [DNTypeName('Aspose.Cells.ErrorCheckType')]
  DNErrorCheckType = type Integer;
  DNErrorCheckTypeHelper = record helper for DNErrorCheckType
  public const
    ///<summary>
    ///  check for calculation errors
    ///</summary>
    Calc = 1;
    ///<summary>
    ///  check for references to empty cells
    ///</summary>
    EmptyCellRef = 2;
    ///<summary>
    ///  check the format of numeric values
    ///</summary>
    TextNumber = 4;
    ///<summary>
    ///  check formulas with references to less than the entirety
    ///  of a range containing continuous data
    ///</summary>
    InconsistRange = 8;
    ///<summary>
    ///  check formulas that are inconsistent with formulas in neighboring cells.
    ///</summary>
    InconsistFormula = 16;
    ///<summary>
    ///  check the format of date/time values
    ///</summary>
    TextDate = 32;
    ///<summary>
    ///  check for unprotected formulas
    ///</summary>
    UnproctedFormula = 64;
    ///<summary>
    ///  whether to perform data validation
    ///</summary>
    Validation = 128;
    ///<summary>
    ///  Ignore errors when cells contain a value different from a calculated column formula.
    ///</summary>
    CalculatedColumn = 129;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents custom exception type code.
  ///</summary>
  [DNTypeName('Aspose.Cells.ExceptionType')]
  DNExceptionType = type Integer;
  DNExceptionTypeHelper = record helper for DNExceptionType
  public const
    ///<summary>
    ///  Invalid chart setting.
    ///</summary>
    Chart = 0;
    ///<summary>
    ///  Invalid data type setting.
    ///</summary>
    DataType = 1;
    ///<summary>
    ///  Invalid data validation setting.
    ///</summary>
    DataValidation = 2;
    ///<summary>
    ///  Invalid data validation setting.
    ///</summary>
    ConditionalFormatting = 3;
    ///<summary>
    ///  Invalid file format.
    ///</summary>
    FileFormat = 4;
    ///<summary>
    ///  Invalid formula.
    ///</summary>
    Formula = 5;
    ///<summary>
    ///  Invalid data.
    ///</summary>
    InvalidData = 6;
    ///<summary>
    ///  Invalid operator.
    ///</summary>
    InvalidOperator = 7;
    ///<summary>
    ///  Incorrect password.
    ///</summary>
    IncorrectPassword = 8;
    ///<summary>
    ///  License related errors.
    ///</summary>
    License = 9;
    ///<summary>
    ///  Out of MS Excel limitation error.
    ///</summary>
    Limitation = 10;
    ///<summary>
    ///  Invalid page setup setting.
    ///</summary>
    PageSetup = 11;
    ///<summary>
    ///  Invalid pivotTable setting.
    ///</summary>
    PivotTable = 12;
    ///<summary>
    ///  Invalid drawing object setting.
    ///</summary>
    Shape = 13;
    ///<summary>
    ///  Invalid sparkline object setting.
    ///</summary>
    Sparkline = 14;
    ///<summary>
    ///  Invalid worksheet name.
    ///</summary>
    SheetName = 15;
    ///<summary>
    ///  Invalid worksheet type.
    ///</summary>
    SheetType = 16;
    ///<summary>
    ///  The process is interrupted.
    ///</summary>
    Interrupted = 17;
    ///<summary>
    ///  The file is invalid.
    ///</summary>
    IO = 18;
    ///<summary>
    ///  Permission is required to open this file.
    ///</summary>
    Permission = 19;
    ///<summary>
    ///  Unsupported feature.
    ///</summary>
    UnsupportedFeature = 20;
    ///<summary>
    ///  Unsupported stream to be opened.
    ///</summary>
    UnsupportedStream = 21;
    ///<summary>
    ///  Files contains some undisclosed information.
    ///</summary>
    UndisclosedInformation = 22;
  end;


  //-------------namespace: Aspose.Cells.ExternalConnections----------------
  ///<summary>
  ///  Specifies external database source type
  ///</summary>
  [DNTypeName('Aspose.Cells.ExternalConnections.ConnectionDataSourceType')]
  DNConnectionDataSourceType = type Integer;
  DNConnectionDataSourceTypeHelper = record helper for DNConnectionDataSourceType
  public const
    ///<summary>
    ///  ODBC-based source
    ///</summary>
    ODBCBasedSource = 1;
    ///<summary>
    ///  DAO-based source
    ///</summary>
    DAOBasedSource = 2;
    ///<summary>
    ///  File based database source
    ///</summary>
    FileBasedDataBaseSource = 3;
    ///<summary>
    ///  Web query
    ///</summary>
    WebQuery = 4;
    ///<summary>
    ///  OLE DB-based source
    ///</summary>
    OLEDBBasedSource = 5;
    ///<summary>
    ///  Text-based source
    ///</summary>
    TextBasedSource = 6;
    ///<summary>
    ///  ADO record set
    ///</summary>
    ADORecordSet = 7;
    ///<summary>
    ///  DSP
    ///</summary>
    DSP = 8;
    ///<summary>
    ///  OLE DB data source created by the Spreadsheet Data Model.
    ///</summary>
    OLEDBDataModel = 100;
    ///<summary>
    ///  Data feed data source created by the Spreadsheet Data Model.
    ///</summary>
    DataFeedDataModel = 101;
    ///<summary>
    ///  Worksheet data source created by the Spreadsheet Data Model.
    ///</summary>
    WorksheetDataModel = 102;
    ///<summary>
    ///  Worksheet data source created by the Spreadsheet Data Model.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use WorksheetDataModel enum.
    ///  This property will be removed 12 months later since September 2017.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    Table = 102;
    ///<summary>
    ///  Text data source created by the Spreadsheet Data Model.
    ///</summary>
    TextDataModel = 103;
    ///<summary>
    ///  Text data source created by the Spreadsheet Data Model.
    ///</summary>
    Unknown = 255;
  end;


  //-------------namespace: Aspose.Cells.ExternalConnections----------------
  ///<summary>
  ///  Specifies the parameter type of external connection
  ///</summary>
  [DNTypeName('Aspose.Cells.ExternalConnections.ConnectionParameterType')]
  DNConnectionParameterType = type Integer;
  DNConnectionParameterTypeHelper = record helper for DNConnectionParameterType
  public const
    ///<summary>
    ///  Get the parameter value from a cell on each refresh.
    ///</summary>
    Cell = 0;
    ///<summary>
    ///  Prompt the user on each refresh for a parameter value.
    ///</summary>
    Prompt = 1;
    ///<summary>
    ///  Use a constant value on each refresh for the parameter value.
    ///</summary>
    Value = 2;
  end;


  //-------------namespace: Aspose.Cells.ExternalConnections----------------
  ///<summary>
  ///  Specifies Credentials method used for server access.
  ///</summary>
  [DNTypeName('Aspose.Cells.ExternalConnections.CredentialsMethodType')]
  DNCredentialsMethodType = type Integer;
  DNCredentialsMethodTypeHelper = record helper for DNCredentialsMethodType
  public const
    ///<summary>
    ///  Integrated Authentication
    ///</summary>
    Integrated = 0;
    ///<summary>
    ///  No Credentials
    ///</summary>
    None = 1;
    ///<summary>
    ///  Prompt Credentials
    ///</summary>
    Prompt = 2;
    ///<summary>
    ///  Stored Credentials
    ///</summary>
    Stored_ = 3;
  end;


  //-------------namespace: Aspose.Cells.ExternalConnections----------------
  ///<summary>
  ///  Specifies how to handle formatting from the HTML source
  ///</summary>
  [DNTypeName('Aspose.Cells.ExternalConnections.HtmlFormatHandlingType')]
  DNHtmlFormatHandlingType = type Integer;
  DNHtmlFormatHandlingTypeHelper = record helper for DNHtmlFormatHandlingType
  public const
    ///<summary>
    ///  Transfer all HTML formatting into the worksheet along with data.
    ///</summary>
    All = 0;
    ///<summary>
    ///  Bring data in as unformatted text (setting data types still occurs).
    ///</summary>
    None = 1;
    ///<summary>
    ///  Translate HTML formatting to rich text formatting on the data brought into the worksheet.
    ///</summary>
    Rtf = 2;
  end;


  //-------------namespace: Aspose.Cells.ExternalConnections----------------
  ///<summary>
  ///  Specifies the OLE DB command type.
  ///</summary>
  [DNTypeName('Aspose.Cells.ExternalConnections.OLEDBCommandType')]
  DNOLEDBCommandType = type Integer;
  DNOLEDBCommandTypeHelper = record helper for DNOLEDBCommandType
  public const
    ///<summary>
    ///  The command type is not specified.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Specifies a cube name
    ///</summary>
    ///<remarks>unsupported</remarks>
    CubeName = 1;
    ///<summary>
    ///  Specifies a SQL statement
    ///</summary>
    SqlStatement = 2;
    ///<summary>
    ///  Specifies a table name
    ///</summary>
    TableName = 3;
    ///<summary>
    ///  Specifies that default information has been given, and it is up to the provider how to interpret.
    ///</summary>
    ///<remarks>unsupported</remarks>
    DefaultInformation = 4;
    ///<summary>
    ///  Specifies a query which is against a web based List Data Provider.
    ///</summary>
    ///<remarks>unsupported</remarks>
    WebBasedList = 5;
  end;


  //-------------namespace: Aspose.Cells.ExternalConnections----------------
  ///<summary>
  ///  Specifies what the spreadsheet application should do when a connection fails.
  ///</summary>
  [DNTypeName('Aspose.Cells.ExternalConnections.ReConnectionMethodType')]
  DNReConnectionMethodType = type Integer;
  DNReConnectionMethodTypeHelper = record helper for DNReConnectionMethodType
  public const
    ///<summary>
    ///  On refresh use the existing connection information and if it ends up being invalid
    ///  then get updated connection information, if available from the external connection file.
    ///</summary>
    Required = 1;
    ///<summary>
    ///  On every refresh get updated connection information from the external connection file,
    ///  if available, and use that instead of the existing connection information.
    ///  In this case the data refresh will fail if the external connection file is unavailable.
    ///</summary>
    Always = 2;
    ///<summary>
    ///  Never get updated connection information from the external connection file
    ///  even if it is available and even if the existing connection information is invalid
    ///</summary>
    Never = 3;
  end;


  //-------------namespace: Aspose.Cells.ExternalConnections----------------
  ///<summary>
  ///  Specifies SQL data type of the parameter. Only valid for ODBC sources.
  ///</summary>
  [DNTypeName('Aspose.Cells.ExternalConnections.SqlDataType')]
  DNSqlDataType = type Integer;
  DNSqlDataTypeHelper = record helper for DNSqlDataType
  public const
    ///<summary>
    ///  sql unknown type
    ///</summary>
    SqlUnknownType = 0;
    ///<summary>
    ///  sql char
    ///</summary>
    SqlChar = 1;
    ///<summary>
    ///  sql numeric
    ///</summary>
    SqlNumeric = 2;
    ///<summary>
    ///  sql decimal
    ///</summary>
    SqlDecimal = 3;
    ///<summary>
    ///  sql integer
    ///</summary>
    SqlInteger = 4;
    ///<summary>
    ///  sql small int
    ///</summary>
    SqlSmallInt = 5;
    ///<summary>
    ///  sql float
    ///</summary>
    SqlFloat = 6;
    ///<summary>
    ///  sql real
    ///</summary>
    SqlReal = 7;
    ///<summary>
    ///  sql double
    ///</summary>
    SqlDouble = 8;
    ///<summary>
    ///  sql date type
    ///</summary>
    SqlTypeDate = 9;
    ///<summary>
    ///  sql time type
    ///</summary>
    SqlTypeTime = 10;
    ///<summary>
    ///  sql timestamp type
    ///</summary>
    SqlTypeTimestamp = 11;
    ///<summary>
    ///  sql variable char
    ///</summary>
    SqlVarChar = 12;
    ///<summary>
    ///  sql interval year
    ///</summary>
    SqlIntervalYear = 101;
    ///<summary>
    ///  sql interval month
    ///</summary>
    SqlIntervalMonth = 102;
    ///<summary>
    ///  sql interval day
    ///</summary>
    SqlIntervalDay = 103;
    ///<summary>
    ///  sql interval hour
    ///</summary>
    SqlIntervalHour = 104;
    ///<summary>
    ///  sql interval minute
    ///</summary>
    SqlIntervalMinute = 105;
    ///<summary>
    ///  sql interval second
    ///</summary>
    SqlIntervalSecond = 106;
    ///<summary>
    ///  sql interval year to month
    ///</summary>
    SqlIntervalYearToMonth = 107;
    ///<summary>
    ///  sql interval day to hour
    ///</summary>
    SqlIntervalDayToHour = 108;
    ///<summary>
    ///  sql interval day to minute
    ///</summary>
    SqlIntervalDayToMinute = 109;
    ///<summary>
    ///  sql interval day to second
    ///</summary>
    SqlIntervalDayToSecond = 110;
    ///<summary>
    ///  sql interval hour to minute
    ///</summary>
    SqlIntervalHourToMinute = 111;
    ///<summary>
    ///  sql interval hour to second
    ///</summary>
    SqlIntervalHourToSecond = 112;
    ///<summary>
    ///  sql interval minute to second
    ///</summary>
    SqlIntervalMinuteToSecond = 113;
    ///<summary>
    ///  sql unsigned offset
    ///</summary>
    SqlUnsignedOffset = -22;
    ///<summary>
    ///  sql signed offset
    ///</summary>
    SqlSignedOffset = -20;
    ///<summary>
    ///  sql guid
    ///</summary>
    SqlGUID = -11;
    ///<summary>
    ///  sql wide long variable char
    ///</summary>
    SqlWLongVarchar = -10;
    ///<summary>
    ///  sql wide variable char
    ///</summary>
    SqlWVarchar = -9;
    ///<summary>
    ///  sql wide char
    ///</summary>
    SqlWChar = -8;
    ///<summary>
    ///  sql bit
    ///</summary>
    SqlBit = -7;
    ///<summary>
    ///  sql tiny int
    ///</summary>
    SqlTinyInt = -6;
    ///<summary>
    ///  sql big int
    ///</summary>
    SqlBigInt = -5;
    ///<summary>
    ///  sql long variable binary
    ///</summary>
    SqlLongVarBinary = -4;
    ///<summary>
    ///  sql variable binary
    ///</summary>
    SqlVarBinary = -3;
    ///<summary>
    ///  sql binary
    ///</summary>
    SqlBinary = -2;
    ///<summary>
    ///  sql long variable char
    ///</summary>
    SqlLongVarChar = -1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the type of external link.
  ///</summary>
  [DNTypeName('Aspose.Cells.ExternalLinkType')]
  DNExternalLinkType = type Integer;
  DNExternalLinkTypeHelper = record helper for DNExternalLinkType
  public const
    ///<summary>
    ///  Represents the DDE link.
    ///</summary>
    DDELink = 0;
    ///<summary>
    ///  Represents external link.
    ///</summary>
    External_ = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the file format types.
  ///</summary>
  [DNTypeName('Aspose.Cells.FileFormatType')]
  DNFileFormatType = type Integer;
  DNFileFormatTypeHelper = record helper for DNFileFormatType
  public const
    ///<summary>
    ///  Comma-Separated Values(CSV) text file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Csv" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    CSV = 1;
    ///<summary>
    ///  Excel97-2003 spreadsheet file.
    ///</summary>
    Excel97To2003 = 5;
    ///<summary>
    ///  Office Open XML SpreadsheetML file (macro-free).
    ///</summary>
    Xlsx = 6;
    ///<summary>
    ///  Office Open XML SpreadsheetML Macro-Enabled file.
    ///</summary>
    Xlsm = 7;
    ///<summary>
    ///  Office Open XML SpreadsheetML Template (macro-free).
    ///</summary>
    Xltx = 8;
    ///<summary>
    ///  Office Open XML SpreadsheetML Macro-Enabled Template.
    ///</summary>
    Xltm = 9;
    ///<summary>
    ///  Office Open XML SpreadsheetML addinMacro-Enabled file.
    ///</summary>
    Xlam = 10;
    ///<summary>
    ///  Tab-Separated Values(TSV) text file, same with <see cref="F:Aspose.Cells.FileFormatType.Tsv" />
    ///  .
    ///</summary>
    TabDelimited = 11;
    ///<summary>
    ///  Tab-Separated Values(TSV) text file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Tsv" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    TSV = 11;
    ///<summary>
    ///  HTML format.
    ///</summary>
    Html = 12;
    ///<summary>
    ///  PDF (Adobe Portable Document) format.
    ///</summary>
    Pdf = 13;
    ///<summary>
    ///  Open Document Sheet(ODS) file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Ods" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    ODS = 14;
    ///<summary>
    ///  Excel 2003 SpreadsheetML file.
    ///</summary>
    SpreadsheetML = 15;
    ///<summary>
    ///  Excel 2003 SpreadsheetML file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.SpreadsheetML" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    Excel2003XML = 15;
    ///<summary>
    ///  The Excel Binary File Format (.xlsb)
    ///</summary>
    Xlsb = 16;
    ///<summary>
    ///  MHTML (Web archive) format.
    ///</summary>
    MHtml = 17;
    ///<summary>
    ///  XPS (XML Paper Specification) format.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Xps" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    XPS = 20;
    ///<summary>
    ///  Represents a TIFF file.
    ///</summary>
    Tiff = 21;
    ///<summary>
    ///  Represents an Excel95 xls file.
    ///</summary>
    Excel95 = 22;
    ///<summary>
    ///  Represents an Excel4.0 xls file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///</remarks>
    Excel4 = 23;
    ///<summary>
    ///  Represents an Excel3.0 xls file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///</remarks>
    Excel3 = 24;
    ///<summary>
    ///  Represents an Excel2.1 xls file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///</remarks>
    Excel2 = 25;
    ///<summary>
    ///  Represents a pptx file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Pptx = 26;
    ///<summary>
    ///  Represents a docx file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Docx = 27;
    ///<summary>
    ///  SVG file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Svg" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    SVG = 28;
    ///<summary>
    ///  Data Interchange Format.
    ///</summary>
    Dif = 30;
    ///<summary>
    ///  Represents a doc file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Doc = 31;
    ///<summary>
    ///  Represents a ppt file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Ppt = 32;
    ///<summary>
    ///  Represents a email file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    MapiMessage = 33;
    ///<summary>
    ///  Represents the MS Equation 3.0 object.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    MsEquation = 34;
    ///<summary>
    ///  Represents the embedded native object.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Ole10Native = 35;
    ///<summary>
    ///  Represents MS Visio VSD binary format.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Vsd = 36;
    ///<summary>
    ///  Represents MS Visio 2013 VSDX file format.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Vsdx" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    VSDX = 37;
    ///<summary>
    ///  Represents a docm file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Docm = 38;
    ///<summary>
    ///  Represents a dotx file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Dotx = 39;
    ///<summary>
    ///  Represents a dotm file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Dotm = 40;
    ///<summary>
    ///  Represents a pptm file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Pptm = 41;
    ///<summary>
    ///  Represents a Potx file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Potx = 42;
    ///<summary>
    ///  Represents a Potm file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Potm = 43;
    ///<summary>
    ///  Represents a ppsx file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Ppsx = 44;
    ///<summary>
    ///  Represents a ppsm file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Ppsm = 45;
    ///<summary>
    ///  Represents office open xml file(such as xlsx, docx,pptx, etc).
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///  If the office open xml file is encrypted, it could not be detected as xlsx ,docx, pptx,etc.
    ///</remarks>
    Ooxml = 46;
    ///<summary>
    ///  Represents an ODT file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Odt" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    ODT = 47;
    ///<summary>
    ///  Represents a ODP file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Odp = 48;
    ///<summary>
    ///  Represents an ODF file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Odf" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    ODF = 49;
    ///<summary>
    ///  Represents an ODG file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Odg" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    ODG = 50;
    ///<summary>
    ///  Represents a simple xml file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Xml = 51;
    ///<summary>
    ///  Excel97-2003 spreadsheet template.
    ///</summary>
    Xlt = 52;
    ///<summary>
    ///  Represents an OTT file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Ott" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    OTT = 53;
    ///<summary>
    ///  Represents a BMP file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported
    ///  Only for detecting file type.
    ///</remarks>
    Bmp = 54;
    ///<summary>
    ///  Represents an OTS file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Ots" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    OTS = 55;
    ///<summary>
    ///  Represents Numbers 9.0 file format by Apple Inc
    ///</summary>
    Numbers09 = 56;
    ///<summary>
    ///  Represents Numbers 9.0 file format by Apple Inc
    ///</summary>
    Numbers = 56;
    ///<summary>
    ///  Represents markdown document.
    ///</summary>
    Markdown = 57;
    ///<summary>
    ///  Represents embedded graph chart.
    ///</summary>
    GraphChart = 58;
    ///<summary>
    ///  Represents OpenDocument Flat XML Spreadsheet (.fods) file format.
    ///</summary>
    Fods = 59;
    ///<summary>
    ///  Represents StarOffice Calc Spreadsheet (.sxc) file format.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.FileFormatType.Sxc" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    SXC = 60;
    ///<summary>
    ///  Represents a OTP file.
    ///</summary>
    ///<remarks>
    ///  The file format is not supported.
    ///  Only for detecting file type.
    ///</remarks>
    Otp = 61;
    ///<summary>
    ///  Represents Numbers 3.5 file format since 2014 by Apple Inc
    ///</summary>
    ///<remarks>
    ///  The file format is not supported.
    ///  Only for detecting file type.
    ///</remarks>
    Numbers35 = 62;
    ///<summary>
    ///  Represents unrecognized format, cannot be loaded.
    ///</summary>
    Unknown = 255;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Custom Filter operator type.
  ///</summary>
  [DNTypeName('Aspose.Cells.FilterOperatorType')]
  DNFilterOperatorType = type Integer;
  DNFilterOperatorTypeHelper = record helper for DNFilterOperatorType
  public const
    ///<summary>
    ///  Represents LessOrEqual operator.
    ///</summary>
    LessOrEqual = 0;
    ///<summary>
    ///  Represents LessThan operator.
    ///</summary>
    LessThan = 1;
    ///<summary>
    ///  Represents Equal operator.
    ///</summary>
    Equal = 2;
    ///<summary>
    ///  Represents GreaterThan operator.
    ///</summary>
    GreaterThan = 3;
    ///<summary>
    ///  Represents NotEqual operator.
    ///</summary>
    NotEqual = 4;
    ///<summary>
    ///  Represents GreaterOrEqual operator.
    ///</summary>
    GreaterOrEqual = 5;
    ///<summary>
    ///  Represents no comparison.
    ///</summary>
    None = 6;
    ///<summary>
    ///  Begins with the text.
    ///</summary>
    BeginsWith = 7;
    ///<summary>
    ///  Ends with the text.
    ///</summary>
    EndsWith = 8;
    ///<summary>
    ///  Contains the text.
    ///</summary>
    Contains_ = 9;
    ///<summary>
    ///  Not contains the text.
    ///</summary>
    NotContains = 10;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  The filter type.
  ///</summary>
  [DNTypeName('Aspose.Cells.FilterType')]
  DNFilterType = type Integer;
  DNFilterTypeHelper = record helper for DNFilterType
  public const
    ///<summary>
    ///  Filter by fill color of the cell.
    ///</summary>
    ColorFilter = 0;
    ///<summary>
    ///  Custom filter type.
    ///</summary>
    CustomFilters = 1;
    ///<summary>
    ///  Dynamic filter type.
    ///</summary>
    DynamicFilter = 2;
    ///<summary>
    ///  When multiple values are chosen to filter by, or when a group of date values are chosen to filter by,
    ///  this element groups those criteria together.
    ///</summary>
    MultipleFilters = 3;
    ///<summary>
    ///  Filter by icon of conditonal formatting.
    ///</summary>
    IconFilter = 4;
    ///<summary>
    ///  Top 10 filter.
    ///</summary>
    Top10 = 5;
    ///<summary>
    ///  No filter.
    ///</summary>
    None = 6;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the scheme type of the font.
  ///</summary>
  [DNTypeName('Aspose.Cells.FontSchemeType')]
  DNFontSchemeType = type Integer;
  DNFontSchemeTypeHelper = record helper for DNFontSchemeType
  public const
    ///<summary>
    ///  None
    ///</summary>
    None = 0;
    ///<summary>
    ///  Major scheme.
    ///</summary>
    Major = 1;
    ///<summary>
    ///  Minor scheme.
    ///</summary>
    ///<remarks>
    ///  The font's name will be automatically changed with the language.
    ///</remarks>
    Minor = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies the type of a font source.
  ///</summary>
  [DNTypeName('Aspose.Cells.FontSourceType')]
  DNFontSourceType = type Integer;
  DNFontSourceTypeHelper = record helper for DNFontSourceType
  public const
    ///<summary>
    ///  represents single font file.
    ///</summary>
    FontFile = 0;
    ///<summary>
    ///  represents folder with font files.
    ///</summary>
    FontsFolder = 1;
    ///<summary>
    ///  represents single font in memory.
    ///</summary>
    MemoryFont = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates the font underline types.
  ///</summary>
  [DNTypeName('Aspose.Cells.FontUnderlineType')]
  DNFontUnderlineType = type Integer;
  DNFontUnderlineTypeHelper = record helper for DNFontUnderlineType
  public const
    ///<summary>
    ///  Represents no underline.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Represents single underline.
    ///</summary>
    Single = 1;
    ///<summary>
    ///  Represents double underline.
    ///</summary>
    Double = 2;
    ///<summary>
    ///  Represents single accounting underline.
    ///</summary>
    Accounting = 3;
    ///<summary>
    ///  Represents double accounting underline.
    ///</summary>
    DoubleAccounting = 4;
    ///<summary>
    ///  Represents Dashed Underline
    ///</summary>
    Dash = 5;
    ///<summary>
    ///  Represents Thick Dash-Dot-Dot Underline
    ///</summary>
    DashDotDotHeavy = 6;
    ///<summary>
    ///  Represents Thick Dash-Dot Underline
    ///</summary>
    DashDotHeavy = 7;
    ///<summary>
    ///  Represents Thick Dashed Underline
    ///</summary>
    DashedHeavy = 8;
    ///<summary>
    ///  Represents Long Dashed Underline
    ///</summary>
    DashLong = 9;
    ///<summary>
    ///  Represents Thick Long Dashed Underline
    ///</summary>
    DashLongHeavy = 10;
    ///<summary>
    ///  Represents Dash-Dot Underline
    ///</summary>
    DotDash = 11;
    ///<summary>
    ///  Represents Dash-Dot-Dot Underline
    ///</summary>
    DotDotDash = 12;
    ///<summary>
    ///  Represents Dotted Underline
    ///</summary>
    Dotted = 13;
    ///<summary>
    ///  Represents Thick Dotted Underline
    ///</summary>
    DottedHeavy = 14;
    ///<summary>
    ///  Represents Thick Underline
    ///</summary>
    Heavy = 15;
    ///<summary>
    ///  Represents Wave Underline
    ///</summary>
    Wave = 16;
    ///<summary>
    ///  Represents Double Wave Underline
    ///</summary>
    WavyDouble = 17;
    ///<summary>
    ///  Represents Heavy Wave Underline
    ///</summary>
    WavyHeavy = 18;
    ///<summary>
    ///  Represents Underline Non-Space Characters Only
    ///</summary>
    Words = 19;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Conditional format rule type.
  ///</summary>
  [DNTypeName('Aspose.Cells.FormatConditionType')]
  DNFormatConditionType = type Integer;
  DNFormatConditionTypeHelper = record helper for DNFormatConditionType
  public const
    ///<summary>
    ///  This conditional formatting rule compares a cell value
    ///  to a formula calculated result, using an operator.
    ///</summary>
    CellValue = 0;
    ///<summary>
    ///  This conditional formatting rule contains a formula to
    ///  evaluate. When the formula result is true, the cell is
    ///  highlighted.
    ///</summary>
    Expression = 1;
    ///<summary>
    ///  This conditional formatting rule creates a gradated
    ///  color scale on the cells.
    ///</summary>
    ColorScale = 2;
    ///<summary>
    ///  This conditional formatting rule displays a gradated
    ///  data bar in the range of cells.
    ///</summary>
    DataBar = 3;
    ///<summary>
    ///  This conditional formatting rule applies icons to cells
    ///  according to their values.
    ///</summary>
    IconSet = 4;
    ///<summary>
    ///  This conditional formatting rule highlights cells whose
    ///  values fall in the top N or bottom N bracket, as
    ///  specified.
    ///</summary>
    Top10 = 5;
    ///<summary>
    ///  This conditional formatting rule highlights unique
    ///  values in the range.
    ///</summary>
    UniqueValues = 6;
    ///<summary>
    ///  This conditional formatting rule highlights duplicated
    ///  values.
    ///</summary>
    DuplicateValues = 7;
    ///<summary>
    ///  This conditional formatting rule highlights cells
    ///  containing given text. Equivalent to using the SEARCH()
    ///  sheet function to determine whether the cell contains
    ///  the text.
    ///</summary>
    ContainsText = 8;
    ///<summary>
    ///  This conditional formatting rule highlights cells that
    ///  are not blank. Equivalent of using LEN(TRIM()). This
    ///  means that if the cell contains only characters that
    ///  TRIM() would remove, then it is considered blank. An
    ///  empty cell is also considered blank.
    ///</summary>
    NotContainsText = 9;
    ///<summary>
    ///  This conditional formatting rule highlights cells in the
    ///  range that begin with the given text. Equivalent to
    ///  using the LEFT() sheet function and comparing values.
    ///</summary>
    BeginsWith = 10;
    ///<summary>
    ///  This conditional formatting rule highlights cells ending
    ///  with given text. Equivalent to using the RIGHT() sheet
    ///  function and comparing values.
    ///</summary>
    EndsWith = 11;
    ///<summary>
    ///  This conditional formatting rule highlights cells that
    ///  are completely blank. Equivalent of using LEN(TRIM()).
    ///  This means that if the cell contains only characters
    ///  that TRIM() would remove, then it is considered blank.
    ///  An empty cell is also considered blank.
    ///</summary>
    ContainsBlanks = 12;
    ///<summary>
    ///  This conditional formatting rule highlights cells that
    ///  are not blank. Equivalent of using LEN(TRIM()). This
    ///  means that if the cell contains only characters that
    ///  TRIM() would remove, then it is considered blank. An
    ///  empty cell is also considered blank.
    ///</summary>
    NotContainsBlanks = 13;
    ///<summary>
    ///  This conditional formatting rule highlights cells with
    ///  formula errors. Equivalent to using ISERROR() sheet
    ///  function to determine if there is a formula error.
    ///</summary>
    ContainsErrors = 14;
    ///<summary>
    ///  This conditional formatting rule highlights cells
    ///  without formula errors. Equivalent to using ISERROR()
    ///  sheet function to determine if there is a formula error.
    ///</summary>
    NotContainsErrors = 15;
    ///<summary>
    ///  This conditional formatting rule highlights cells
    ///  containing dates in the specified time period. The
    ///  underlying value of the cell is evaluated, therefore the
    ///  cell does not need to be formatted as a date to be
    ///  evaluated. For example, with a cell containing the
    ///  value 38913 the conditional format shall be applied if
    ///  the rule requires a value of 7/14/2006.
    ///</summary>
    TimePeriod = 16;
    ///<summary>
    ///  This conditional formatting rule highlights cells that
    ///  are above or below the average for all values in the
    ///  range.
    ///</summary>
    AboveAverage = 17;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Condition value type.
  ///</summary>
  [DNTypeName('Aspose.Cells.FormatConditionValueType')]
  DNFormatConditionValueType = type Integer;
  DNFormatConditionValueTypeHelper = record helper for DNFormatConditionValueType
  public const
    ///<summary>
    ///  The minimum/ midpoint / maximum value for the
    ///  gradient is determined by a formula.
    ///</summary>
    Formula = 0;
    ///<summary>
    ///  Indicates that the maximum value in the range shall be
    ///  used as the maximum value for the gradient.
    ///</summary>
    Max = 1;
    ///<summary>
    ///  Indicates that the minimum value in the range shall be
    ///  used as the minimum value for the gradient.
    ///</summary>
    Min = 2;
    ///<summary>
    ///  Indicates that the minimum / midpoint / maximum
    ///  value for the gradient is specified by a constant
    ///  numeric value.
    ///</summary>
    Number = 3;
    ///<summary>
    ///  Value indicates a percentage between the minimum
    ///  and maximum values in the range shall be used as the
    ///  minimum / midpoint / maximum value for the gradient.
    ///</summary>
    Percent = 4;
    ///<summary>
    ///  Value indicates a percentile ranking in the range shall
    ///  be used as the minimum / midpoint / maximum value
    ///  for the gradient.
    ///</summary>
    Percentile = 5;
    ///<summary>
    ///  Indicates that the Automatic maximum value in the range shall be
    ///  used as the Automatic maximum value for the gradient.
    ///</summary>
    AutomaticMax = 6;
    ///<summary>
    ///  Indicates that the Automatic minimum value in the range shall be
    ///  used as the Automatic minimum value for the gradient.
    ///</summary>
    AutomaticMin = 7;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates grid line Type.
  ///</summary>
  [DNTypeName('Aspose.Cells.GridlineType')]
  DNGridlineType = type Integer;
  DNGridlineTypeHelper = record helper for DNGridlineType
  public const
    ///<summary>
    ///  Represents dotted line.
    ///</summary>
    Dotted = 0;
    ///<summary>
    ///  Represents hair line.
    ///</summary>
    Hair = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the command type of header and footer.
  ///</summary>
  [DNTypeName('Aspose.Cells.HeaderFooterCommandType')]
  DNHeaderFooterCommandType = type Integer;
  DNHeaderFooterCommandTypeHelper = record helper for DNHeaderFooterCommandType
  public const
    ///<summary>
    ///  The text.
    ///</summary>
    Text = 0;
    ///<summary>
    ///  Current page number
    ///</summary>
    CurrentPage = 1;
    ///<summary>
    ///  Page count
    ///</summary>
    Pagecount = 2;
    ///<summary>
    ///  Current date
    ///</summary>
    CurrentDate = 3;
    ///<summary>
    ///  Current time
    ///</summary>
    CurrentTime = 4;
    ///<summary>
    ///  Sheet name
    ///</summary>
    SheetName = 5;
    ///<summary>
    ///  File name without path
    ///</summary>
    FileName = 6;
    ///<summary>
    ///  File path without file name
    ///</summary>
    FilePath = 7;
    ///<summary>
    ///  Picture
    ///</summary>
    Picture = 8;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents five types of html cross string.
  ///</summary>
  [DNTypeName('Aspose.Cells.HtmlCrossType')]
  DNHtmlCrossType = type Integer;
  DNHtmlCrossTypeHelper = record helper for DNHtmlCrossType
  public const
    ///<summary>
    ///  Display like MS Excel,depends on the next cell.
    ///  If the next cell is null,the string will cross,or it will be truncated
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Display the string like MS Excel exporting html.
    ///</summary>
    MSExport = 1;
    ///<summary>
    ///  Display HTML cross string, this performance for creating large html files will be more than ten times faster than setting the value to Default or FitToCell.
    ///</summary>
    Cross = 2;
    ///<summary>
    ///  Display HTML cross string and hide the right string when the texts overlap.
    ///</summary>
    CrossHideRight = 3;
    ///<summary>
    ///  Only displaying the string within the width of cell.
    ///</summary>
    FitToCell = 4;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the options for exporting html data.
  ///</summary>
  [DNTypeName('Aspose.Cells.HtmlExportDataOptions')]
  DNHtmlExportDataOptions = type Integer;
  DNHtmlExportDataOptionsHelper = record helper for DNHtmlExportDataOptions
  public const
    ///<summary>
    ///  Export file to html which only contains table part.
    ///</summary>
    Table = 1;
    ///<summary>
    ///  Export all the data to html.
    ///</summary>
    All = 255;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents two types of showing the hidden columns in html.
  ///</summary>
  [DNTypeName('Aspose.Cells.HtmlHiddenColDisplayType')]
  DNHtmlHiddenColDisplayType = type Integer;
  DNHtmlHiddenColDisplayTypeHelper = record helper for DNHtmlHiddenColDisplayType
  public const
    ///<summary>
    ///  Hidden the hidden columns in html page.
    ///</summary>
    Hidden = 0;
    ///<summary>
    ///  Remove the hidden columns in html page.
    ///</summary>
    Remove = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents two types of showing the hidden rows in html.
  ///</summary>
  [DNTypeName('Aspose.Cells.HtmlHiddenRowDisplayType')]
  DNHtmlHiddenRowDisplayType = type Integer;
  DNHtmlHiddenRowDisplayTypeHelper = record helper for DNHtmlHiddenRowDisplayType
  public const
    ///<summary>
    ///  Hidden the hidden rows in html page.
    ///</summary>
    Hidden = 0;
    ///<summary>
    ///  Remove the hidden rows in html page.
    ///</summary>
    Remove = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the type of target attribute in HTML <a /> tag.
  ///</summary>
  [DNTypeName('Aspose.Cells.HtmlLinkTargetType')]
  DNHtmlLinkTargetType = type Integer;
  DNHtmlLinkTargetTypeHelper = record helper for DNHtmlLinkTargetType
  public const
    ///<summary>
    ///  Opens the linked document in a new window or tab
    ///</summary>
    Blank = 0;
    ///<summary>
    ///  Opens the linked document in the parent frame
    ///</summary>
    Parent = 1;
    ///<summary>
    ///  Opens the linked document in the same frame as it was clicked (this is default)
    ///</summary>
    Self = 2;
    ///<summary>
    ///  Opens the linked document in the full body of the window
    ///</summary>
    Top = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Icon set type for conditional formatting.
  ///  The threshold values for triggering the different icons within a set are
  ///  configurable, and the icon order is reversible.
  ///</summary>
  [DNTypeName('Aspose.Cells.IconSetType')]
  DNIconSetType = type Integer;
  DNIconSetTypeHelper = record helper for DNIconSetType
  public const
    ///<summary>
    ///  3 arrows icon set.
    ///</summary>
    Arrows3 = 0;
    ///<summary>
    ///  3 gray arrows icon set.
    ///</summary>
    ArrowsGray3 = 1;
    ///<summary>
    ///  3 flags icon set.
    ///</summary>
    Flags3 = 2;
    ///<summary>
    ///  3 signs icon set.
    ///</summary>
    Signs3 = 3;
    ///<summary>
    ///  3 symbols icon set (circled).
    ///</summary>
    Symbols3 = 4;
    ///<summary>
    ///  3 Symbols icon set (uncircled).
    ///</summary>
    Symbols32 = 5;
    ///<summary>
    ///  3 traffic lights icon set (unrimmed).
    ///</summary>
    TrafficLights31 = 6;
    ///<summary>
    ///  3 traffic lights icon set with thick black border.
    ///</summary>
    TrafficLights32 = 7;
    ///<summary>
    ///  4 arrows icon set.
    ///</summary>
    Arrows4 = 8;
    ///<summary>
    ///  4 gray arrows icon set.
    ///</summary>
    ArrowsGray4 = 9;
    ///<summary>
    ///  4 ratings icon set.
    ///</summary>
    Rating4 = 10;
    ///<summary>
    ///  4 'red to black' icon set.
    ///</summary>
    RedToBlack4 = 11;
    ///<summary>
    ///  4 traffic lights icon set.
    ///</summary>
    TrafficLights4 = 12;
    ///<summary>
    ///  5 arrows icon set.
    ///</summary>
    Arrows5 = 13;
    ///<summary>
    ///  5 gray arrows icon set.
    ///</summary>
    ArrowsGray5 = 14;
    ///<summary>
    ///  5 quarters icon set.
    ///</summary>
    Quarters5 = 15;
    ///<summary>
    ///  5 rating icon set.
    ///</summary>
    Rating5 = 16;
    ///<summary>
    ///  3 stars set
    ///</summary>
    Stars3 = 17;
    ///<summary>
    ///  5 boxes set
    ///</summary>
    Boxes5 = 18;
    ///<summary>
    ///  3 triangles set
    ///</summary>
    Triangles3 = 19;
    ///<summary>
    ///  None
    ///</summary>
    None = 20;
    ///<summary>
    ///  CustomSet.
    ///  This element is read-only.
    ///</summary>
    CustomSet = 21;
    ///<summary>
    ///  3 smilies.
    ///  Only for .ods.
    ///</summary>
    Smilies3 = 22;
    ///<summary>
    ///  3 color smilies.
    ///  Only for .ods.
    ///</summary>
    ColorSmilies3 = 23;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the options to filter data when loading workbook from template.
  ///</summary>
  [DNTypeName('Aspose.Cells.LoadDataFilterOptions')]
  DNLoadDataFilterOptions = type Integer;
  DNLoadDataFilterOptionsHelper = record helper for DNLoadDataFilterOptions
  public const
    ///<summary>
    ///  Load nothing for sheet data
    ///</summary>
    ///<remarks>
    ///  NOTE: This member is now obsolete and please use Structure instead.
    ///  This property will be removed 12 months later since December 2017.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    None = 0;
    ///<summary>
    ///  Load cells whose value is blank
    ///</summary>
    CellBlank = 1;
    ///<summary>
    ///  Load cells whose value is string
    ///</summary>
    CellString = 2;
    ///<summary>
    ///  Load cells whose value is numeric(including datetime)
    ///</summary>
    CellNumeric = 4;
    ///<summary>
    ///  Load cells whose value is error
    ///</summary>
    CellError = 8;
    ///<summary>
    ///  Load cells whose value is bool
    ///</summary>
    CellBool = 16;
    ///<summary>
    ///  Load cells value(all value types) only
    ///</summary>
    CellValue = 31;
    ///<summary>
    ///  Load cell formulas.
    ///</summary>
    ///<remarks>
    ///  Generally defined Name objects(DefinedNames) also need to be loaded when loading formulas because they may be referenced by formulas.
    ///  So Formula or CellData option should work with DefinedNames option together(Formula|DefinedNames or CellData|DefinedNames) for most scenarios.
    ///</remarks>
    Formula = 32;
    ///<summary>
    ///  Load charts
    ///</summary>
    Chart = 256;
    ///<summary>
    ///  Load merged cells
    ///</summary>
    MergedArea = 1024;
    ///<summary>
    ///  Load conditional formatting
    ///</summary>
    ConditionalFormatting = 2048;
    ///<summary>
    ///  Load data validations
    ///</summary>
    DataValidation = 4096;
    ///<summary>
    ///  Load pivot tables
    ///</summary>
    PivotTable = 8192;
    ///<summary>
    ///  Load tables
    ///</summary>
    Table = 16384;
    ///<summary>
    ///  Load hyperlinks
    ///</summary>
    Hyperlinks = 32768;
    ///<summary>
    ///  Load settings for worksheet
    ///</summary>
    SheetSettings = 65536;
    ///<summary>
    ///  Load settings for workbook
    ///</summary>
    BookSettings = 1048576;
    ///<summary>
    ///  Load settings for workbook and worksheet
    ///</summary>
    Settings = 1114112;
    ///<summary>
    ///  Load XmlMap
    ///</summary>
    XmlMap = 2097152;
    ///<summary>
    ///  Load structure of the workbook
    ///</summary>
    Structure = 4194304;
    ///<summary>
    ///  Load document properties
    ///</summary>
    DocumentProperties = 8388608;
    ///<summary>
    ///  Load defined Name objects
    ///</summary>
    DefinedNames = 16777216;
    ///<summary>
    ///  Load VBA projects
    ///</summary>
    VBA = 33554432;
    ///<summary>
    ///  Load styles for cell formatting
    ///</summary>
    Style = 67108864;
    ///<summary>
    ///  Load cells data including values, formulas and formatting
    ///</summary>
    CellData = 67108927;
    ///<summary>
    ///  Load pictures
    ///</summary>
    Picture = 134217728;
    ///<summary>
    ///  Load OleObjects
    ///</summary>
    OleObject = 268435456;
    ///<summary>
    ///  Load shapes
    ///</summary>
    ///<remarks>
    ///  NOTE: This member is now obsolete and please use Drawing instead.
    ///  This property will be removed 12 months later since November 2019.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    Shape = 402653696;
    ///<summary>
    ///  Drawing objects(including Chart, Picture, OleObject and all other drawing objects)
    ///</summary>
    Drawing = 402653952;
    ///<summary>
    ///  Load all data of worksheet, such as cells data, settings, objects, ...etc.
    ///</summary>
    SheetData = 403701759;
    ///<summary>
    ///  Load all
    ///</summary>
    All = 2147483647;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the load file format.
  ///</summary>
  [DNTypeName('Aspose.Cells.LoadFormat')]
  DNLoadFormat = type Integer;
  DNLoadFormatHelper = record helper for DNLoadFormat
  public const
    ///<summary>
    ///  Represents recognizing the format automatically.
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  Comma-Separated Values(CSV) text file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.LoadFormat.Csv" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    CSV = 1;
    ///<summary>
    ///  Represents an Excel97-2003 xls file.
    ///</summary>
    Excel97To2003 = 5;
    ///<summary>
    ///  Represents Office Open XML spreadsheetML workbook or template, with or without macros.
    ///</summary>
    Xlsx = 6;
    ///<summary>
    ///  Tab-Separated Values(TSV) text file.
    ///</summary>
    Tsv = 11;
    ///<summary>
    ///  Represents a tab delimited text file, same with <see cref="F:Aspose.Cells.LoadFormat.Tsv" />
    ///  .
    ///</summary>
    TabDelimited = 11;
    ///<summary>
    ///  Represents a html file.
    ///</summary>
    Html = 12;
    ///<summary>
    ///  Represents a mhtml file.
    ///</summary>
    MHtml = 13;
    ///<summary>
    ///  Open Document Sheet(ODS) file.
    ///</summary>
    Ods = 14;
    ///<summary>
    ///  Represents an Excel 2003 xml file.
    ///</summary>
    SpreadsheetML = 15;
    ///<summary>
    ///  Represents an xlsb file.
    ///</summary>
    Xlsb = 16;
    ///<summary>
    ///  Represents a numbers file.
    ///</summary>
    Numbers = 56;
    ///<summary>
    ///  Represents OpenDocument Flat XML Spreadsheet (.fods) file format.
    ///</summary>
    Fods = 59;
    ///<summary>
    ///  Represents StarOffice Calc Spreadsheet (.sxc) file format.
    ///</summary>
    Sxc = 60;
    ///<summary>
    ///  Represents unrecognized format, cannot be loaded.
    ///</summary>
    Unknown = 255;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents look at type.
  ///</summary>
  [DNTypeName('Aspose.Cells.LookAtType')]
  DNLookAtType = type Integer;
  DNLookAtTypeHelper = record helper for DNLookAtType
  public const
    ///<summary>
    ///  Cell value Contains the find object.
    ///</summary>
    Contains_ = 0;
    ///<summary>
    ///  Cell value Starts with the find object.
    ///</summary>
    StartWith = 1;
    ///<summary>
    ///  Cell value ends with the find object.
    ///</summary>
    EndWith = 2;
    ///<summary>
    ///  Cell value is same as the find object.
    ///</summary>
    EntireContent = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents look in type.
  ///</summary>
  [DNTypeName('Aspose.Cells.LookInType')]
  DNLookInType = type Integer;
  DNLookInTypeHelper = record helper for DNLookInType
  public const
    ///<summary>
    ///  If the cell contains a formula, find object from formula,else find it from the value.
    ///</summary>
    Formulas = 0;
    ///<summary>
    ///  Only find object from the formatted values.
    ///</summary>
    Values = 1;
    ///<summary>
    ///  Only find object from the values of cells which do not contains formula.
    ///</summary>
    ValuesExcludeFormulaCell = 2;
    ///<summary>
    ///  Only find object from the comments.
    ///</summary>
    Comments = 3;
    ///<summary>
    ///  Only find object from formulas.
    ///</summary>
    OnlyFormulas = 4;
    ///<summary>
    ///  Only find object from the original values.
    ///</summary>
    OriginalValues = 5;
  end;


  //-------------namespace: Aspose.Cells.Markup----------------
  ///<summary>
  ///  Represents the show type of the smart tag.
  ///</summary>
  [DNTypeName('Aspose.Cells.Markup.SmartTagShowType')]
  DNSmartTagShowType = type Integer;
  DNSmartTagShowTypeHelper = record helper for DNSmartTagShowType
  public const
    ///<summary>
    ///  Indicates that smart tags are enabled and shown
    ///</summary>
    All = 0;
    ///<summary>
    ///  Indicates that the smart tags are enabled but the indicator not be shown.
    ///</summary>
    NoSmartTagIndicator = 1;
    ///<summary>
    ///  Indicates that smart tags are disabled and not displayed.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Memory usage options.
  ///</summary>
  [DNTypeName('Aspose.Cells.MemorySetting')]
  DNMemorySetting = type Integer;
  DNMemorySettingHelper = record helper for DNMemorySetting
  public const
    ///<summary>
    ///  Default option for cells model.
    ///</summary>
    ///<remarks>This option is applied for all versions.</remarks>
    Normal = 0;
    ///<summary>
    ///  Memory performance preferrable.
    ///  With this option the data will be held in compact format so for common scenarios it may give lower memory cost.
    ///  However, this option also may degrade R/W performance a bit in some special cases.
    ///</summary>
    ///<remarks>This option is available since v 8.0.0.</remarks>
    MemoryPreference = 1;
  end;


  //-------------namespace: Aspose.Cells.Metadata----------------
  ///<summary>
  ///  Represents the type of metadata.
  ///</summary>
  [DNTypeName('Aspose.Cells.Metadata.MetadataType')]
  DNMetadataType = type Integer;
  DNMetadataTypeHelper = record helper for DNMetadataType
  public const
    ///<summary>
    ///  Encrypts the file.
    ///</summary>
    Encryption = 1;
    ///<summary>
    ///  Decrypts the file.
    ///</summary>
    Decryption = 2;
    ///<summary>
    ///  Load the properties of the file.
    ///</summary>
    DocumentProperties = 4;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents category type of cell's number formatting.
  ///</summary>
  [DNTypeName('Aspose.Cells.NumberCategoryType')]
  DNNumberCategoryType = type Integer;
  DNNumberCategoryTypeHelper = record helper for DNNumberCategoryType
  public const
    ///<summary>
    ///  General
    ///</summary>
    General = 0;
    ///<summary>
    ///  Text
    ///</summary>
    Text = 1;
    ///<summary>
    ///  Number
    ///</summary>
    Number = 2;
    ///<summary>
    ///  Date or Date and Time
    ///</summary>
    Date = 3;
    ///<summary>
    ///  Time
    ///</summary>
    Time = 4;
    ///<summary>
    ///  Fraction
    ///</summary>
    Fraction = 5;
    ///<summary>
    ///  Scientific
    ///</summary>
    Scientific = 6;
  end;


  //-------------namespace: Aspose.Cells.Ods----------------
  ///<summary>
  ///  Represents the cell field type of ods.
  ///</summary>
  [DNTypeName('Aspose.Cells.Ods.OdsCellFieldType')]
  DNOdsCellFieldType = type Integer;
  DNOdsCellFieldTypeHelper = record helper for DNOdsCellFieldType
  public const
    ///<summary>
    ///  Current date.
    ///</summary>
    Date = 0;
    ///<summary>
    ///  The name of the sheet.
    ///</summary>
    SheetName = 1;
    ///<summary>
    ///  The name of the file.
    ///</summary>
    Title = 2;
  end;


  //-------------namespace: Aspose.Cells.Ods----------------
  ///<summary>
  ///  Represents the type of ODS generator.
  ///</summary>
  [DNTypeName('Aspose.Cells.Ods.OdsGeneratorType')]
  DNOdsGeneratorType = type Integer;
  DNOdsGeneratorTypeHelper = record helper for DNOdsGeneratorType
  public const
    ///<summary>
    ///  Libre Office
    ///</summary>
    LibreOffice = 0;
    ///<summary>
    ///  Open Office
    ///</summary>
    OpenOffice = 1;
  end;


  //-------------namespace: Aspose.Cells.Ods----------------
  ///<summary>
  ///  Represents the position.
  ///</summary>
  [DNTypeName('Aspose.Cells.Ods.OdsPageBackgroundGraphicPositionType')]
  DNOdsPageBackgroundGraphicPositionType = type Integer;
  DNOdsPageBackgroundGraphicPositionTypeHelper = record helper for DNOdsPageBackgroundGraphicPositionType
  public const
    ///<summary>
    ///  Top left.
    ///</summary>
    TopLeft = 0;
    ///<summary>
    ///  Top center.
    ///</summary>
    TopCenter = 1;
    ///<summary>
    ///  Top right.
    ///</summary>
    TopRight = 2;
    ///<summary>
    ///  Center left.
    ///</summary>
    CenterLeft = 3;
    ///<summary>
    ///  Center.
    ///</summary>
    CenterCenter = 4;
    ///<summary>
    ///  Center right.
    ///</summary>
    CenterRight = 5;
    ///<summary>
    ///  Bottom left.
    ///</summary>
    BottomLeft = 6;
    ///<summary>
    ///  Bottom center.
    ///</summary>
    BottomCenter = 7;
    ///<summary>
    ///  Bottom right.
    ///</summary>
    BottomRight = 8;
  end;


  //-------------namespace: Aspose.Cells.Ods----------------
  ///<summary>
  ///  Represents the type of formatting page background with image.
  ///</summary>
  [DNTypeName('Aspose.Cells.Ods.OdsPageBackgroundGraphicType')]
  DNOdsPageBackgroundGraphicType = type Integer;
  DNOdsPageBackgroundGraphicTypeHelper = record helper for DNOdsPageBackgroundGraphicType
  public const
    ///<summary>
    ///  Set the image at specific position.
    ///</summary>
    Position = 0;
    ///<summary>
    ///  Stretch the image.
    ///</summary>
    Area = 1;
    ///<summary>
    ///  Repeat and repeat the image.
    ///</summary>
    Tile = 2;
  end;


  //-------------namespace: Aspose.Cells.Ods----------------
  ///<summary>
  ///  Represents the page background type of ods.
  ///</summary>
  [DNTypeName('Aspose.Cells.Ods.OdsPageBackgroundType')]
  DNOdsPageBackgroundType = type Integer;
  DNOdsPageBackgroundTypeHelper = record helper for DNOdsPageBackgroundType
  public const
    ///<summary>
    ///  No background.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Formats the background with color.
    ///</summary>
    Color = 1;
    ///<summary>
    ///  Formats the background with image.
    ///</summary>
    Graphic = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Allows to specify which OOXML specification will be used when saving in the Xlsx format.
  ///</summary>
  [DNTypeName('Aspose.Cells.OoxmlCompliance')]
  DNOoxmlCompliance = type Integer;
  DNOoxmlComplianceHelper = record helper for DNOoxmlCompliance
  public const
    ///<summary>
    ///  ECMA-376 1st Edition, 2006.
    ///</summary>
    Ecma376_2006 = 0;
    ///<summary>
    ///  ISO/IEC 29500:2008 Strict compliance level.
    ///</summary>
    Iso29500_2008_Strict = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  The Ooxml compression type
  ///</summary>
  [DNTypeName('Aspose.Cells.OoxmlCompressionType')]
  DNOoxmlCompressionType = type Integer;
  DNOoxmlCompressionTypeHelper = record helper for DNOoxmlCompressionType
  public const
    ///<summary>
    ///  The fastest but least effective compression.
    ///</summary>
    Level1 = 1;
    ///<summary>
    ///  A little slower, but better, than level 1.
    ///</summary>
    Level2 = 2;
    ///<summary>
    ///  A little slower, but better, than level 2.
    ///</summary>
    Level3 = 3;
    ///<summary>
    ///  A little slower, but better, than level 3.
    ///</summary>
    Level4 = 4;
    ///<summary>
    ///  A little slower than level 4, but with better compression.
    ///</summary>
    Level5 = 5;
    ///<summary>
    ///  A good balance of speed and compression efficiency.
    ///</summary>
    Level6 = 6;
    ///<summary>
    ///  Pretty good compression!
    ///</summary>
    Level7 = 7;
    ///<summary>
    ///  Better compression than Level7!
    ///</summary>
    Level8 = 8;
    ///<summary>
    ///  The "best" compression, where best means greatest reduction in size of the input data stream.
    ///  This is also the slowest compression.
    ///</summary>
    Level9 = 9;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the operator type of conditional format and data validation.
  ///</summary>
  [DNTypeName('Aspose.Cells.OperatorType')]
  DNOperatorType = type Integer;
  DNOperatorTypeHelper = record helper for DNOperatorType
  public const
    ///<summary>
    ///  Represents Between operator of conditional format and data validation.
    ///</summary>
    Between = 0;
    ///<summary>
    ///  Represents Equal operator of conditional format and data validation.
    ///</summary>
    Equal = 1;
    ///<summary>
    ///  Represents GreaterThan operator of conditional format and data validation.
    ///</summary>
    GreaterThan = 2;
    ///<summary>
    ///  Represents GreaterOrEqual operator of conditional format and data validation.
    ///</summary>
    GreaterOrEqual = 3;
    ///<summary>
    ///  Represents LessThan operator of conditional format and data validation.
    ///</summary>
    LessThan = 4;
    ///<summary>
    ///  Represents LessOrEqual operator of conditional format and data validation.
    ///</summary>
    LessOrEqual = 5;
    ///<summary>
    ///  Represents no comparison.
    ///</summary>
    None = 6;
    ///<summary>
    ///  Represents NotBetween operator of conditional format and data validation.
    ///</summary>
    NotBetween = 7;
    ///<summary>
    ///  Represents NotEqual operator of conditional format and data validation.
    ///</summary>
    NotEqual = 8;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates page layout alignment types.
  ///</summary>
  [DNTypeName('Aspose.Cells.PageLayoutAlignmentType')]
  DNPageLayoutAlignmentType = type Integer;
  DNPageLayoutAlignmentTypeHelper = record helper for DNPageLayoutAlignmentType
  public const
    ///<summary>
    ///  Represents bottom page layout alignment.
    ///</summary>
    Bottom = 0;
    ///<summary>
    ///  Represents center page layout alignment.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Represents left page layout alignment.
    ///</summary>
    Left = 2;
    ///<summary>
    ///  Represents right page layout alignment.
    ///</summary>
    Right = 3;
    ///<summary>
    ///  Represents top page layout alignment.
    ///</summary>
    Top = 4;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents print orientation constants.
  ///</summary>
  [DNTypeName('Aspose.Cells.PageOrientationType')]
  DNPageOrientationType = type Integer;
  DNPageOrientationTypeHelper = record helper for DNPageOrientationType
  public const
    ///<summary>
    ///  Landscape orientation
    ///</summary>
    Landscape = 0;
    ///<summary>
    ///  Portrait orientation
    ///</summary>
    Portrait = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents state of the sheet's pane.
  ///</summary>
  [DNTypeName('Aspose.Cells.PaneStateType')]
  DNPaneStateType = type Integer;
  DNPaneStateTypeHelper = record helper for DNPaneStateType
  public const
    ///<summary>
    ///  Panes are frozen, but were not before being frozen.
    ///</summary>
    Frozen = 0;
    ///<summary>
    ///  Panes are frozen and were split before being frozen.
    ///</summary>
    FrozenSplit = 1;
    ///<summary>
    ///  Panes are split, but not frozen.
    ///</summary>
    Split = 2;
    ///<summary>
    ///  Panes are not frozen and not split.
    ///</summary>
    Normal = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents paper size constants.
  ///</summary>
  [DNTypeName('Aspose.Cells.PaperSizeType')]
  DNPaperSizeType = type Integer;
  DNPaperSizeTypeHelper = record helper for DNPaperSizeType
  public const
    ///<summary>
    ///  Represents the custom paper size.
    ///</summary>
    Custom = 0;
    ///<summary>
    ///  Letter (8-1/2 in. x 11 in.)
    ///</summary>
    PaperLetter = 1;
    ///<summary>
    ///  Letter Small (8-1/2 in. x 11 in.)
    ///</summary>
    PaperLetterSmall = 2;
    ///<summary>
    ///  Tabloid (11 in. x 17 in.)
    ///</summary>
    PaperTabloid = 3;
    ///<summary>
    ///  Ledger (17 in. x 11 in.)
    ///</summary>
    PaperLedger = 4;
    ///<summary>
    ///  Legal (8-1/2 in. x 14 in.)
    ///</summary>
    PaperLegal = 5;
    ///<summary>
    ///  Statement (5-1/2 in. x 8-1/2 in.)
    ///</summary>
    PaperStatement = 6;
    ///<summary>
    ///  Executive (7-1/4 in. x 10-1/2 in.)
    ///</summary>
    PaperExecutive = 7;
    ///<summary>
    ///  A3 (297 mm x 420 mm)
    ///</summary>
    PaperA3 = 8;
    ///<summary>
    ///  A4 (210 mm x 297 mm)
    ///</summary>
    PaperA4 = 9;
    ///<summary>
    ///  A4 Small (210 mm x 297 mm)
    ///</summary>
    PaperA4Small = 10;
    ///<summary>
    ///  A5 (148 mm x 210 mm)
    ///</summary>
    PaperA5 = 11;
    ///<summary>
    ///  JIS B4 (257 mm x 364 mm)
    ///</summary>
    PaperB4 = 12;
    ///<summary>
    ///  JIS B5 (182 mm x 257 mm)
    ///</summary>
    PaperB5 = 13;
    ///<summary>
    ///  Folio (8-1/2 in. x 13 in.)
    ///</summary>
    PaperFolio = 14;
    ///<summary>
    ///  Quarto (215 mm x 275 mm)
    ///</summary>
    PaperQuarto = 15;
    ///<summary>
    ///  10 in. x 14 in.
    ///</summary>
    Paper10x14 = 16;
    ///<summary>
    ///  11 in. x 17 in.
    ///</summary>
    Paper11x17 = 17;
    ///<summary>
    ///  Note (8-1/2 in. x 11 in.)
    ///</summary>
    PaperNote = 18;
    ///<summary>
    ///  Envelope #9 (3-7/8 in. x 8-7/8 in.)
    ///</summary>
    PaperEnvelope9 = 19;
    ///<summary>
    ///  Envelope #10 (4-1/8 in. x 9-1/2 in.)
    ///</summary>
    PaperEnvelope10 = 20;
    ///<summary>
    ///  Envelope #11 (4-1/2 in. x 10-3/8 in.)
    ///</summary>
    PaperEnvelope11 = 21;
    ///<summary>
    ///  Envelope #12 (4-1/2 in. x 11 in.)
    ///</summary>
    PaperEnvelope12 = 22;
    ///<summary>
    ///  Envelope #14 (5 in. x 11-1/2 in.)
    ///</summary>
    PaperEnvelope14 = 23;
    ///<summary>
    ///  C size sheet
    ///</summary>
    PaperCSheet = 24;
    ///<summary>
    ///  D size sheet
    ///</summary>
    PaperDSheet = 25;
    ///<summary>
    ///  E size sheet
    ///</summary>
    PaperESheet = 26;
    ///<summary>
    ///  Envelope DL (110 mm x 220 mm)
    ///</summary>
    PaperEnvelopeDL = 27;
    ///<summary>
    ///  Envelope C5 (162 mm x 229 mm)
    ///</summary>
    PaperEnvelopeC5 = 28;
    ///<summary>
    ///  Envelope C3 (324 mm x 458 mm)
    ///</summary>
    PaperEnvelopeC3 = 29;
    ///<summary>
    ///  Envelope C4 (229 mm x 324 mm)
    ///</summary>
    PaperEnvelopeC4 = 30;
    ///<summary>
    ///  Envelope C6 (114 mm x 162 mm)
    ///</summary>
    PaperEnvelopeC6 = 31;
    ///<summary>
    ///  Envelope C65 (114 mm x 229 mm)
    ///</summary>
    PaperEnvelopeC65 = 32;
    ///<summary>
    ///  Envelope B4 (250 mm x 353 mm)
    ///</summary>
    PaperEnvelopeB4 = 33;
    ///<summary>
    ///  Envelope B5 (176 mm x 250 mm)
    ///</summary>
    PaperEnvelopeB5 = 34;
    ///<summary>
    ///  Envelope B6 (176 mm x 125 mm)
    ///</summary>
    PaperEnvelopeB6 = 35;
    ///<summary>
    ///  Envelope Italy (110 mm x 230 mm)
    ///</summary>
    PaperEnvelopeItaly = 36;
    ///<summary>
    ///  Envelope Monarch (3-7/8 in. x 7-1/2 in.)
    ///</summary>
    PaperEnvelopeMonarch = 37;
    ///<summary>
    ///  Envelope (3-5/8 in. x 6-1/2 in.)
    ///</summary>
    PaperEnvelopePersonal = 38;
    ///<summary>
    ///  U.S. Standard Fanfold (14-7/8 in. x 11 in.)
    ///</summary>
    PaperFanfoldUS = 39;
    ///<summary>
    ///  German Standard Fanfold (8-1/2 in. x 12 in.)
    ///</summary>
    PaperFanfoldStdGerman = 40;
    ///<summary>
    ///  German Legal Fanfold (8-1/2 in. x 13 in.)
    ///</summary>
    PaperFanfoldLegalGerman = 41;
    ///<summary>
    ///  B4 (ISO) 250 x 353 mm
    ///</summary>
    PaperISOB4 = 42;
    ///<summary>
    ///  Japanese Postcard (100mm ¡Á 148mm)
    ///</summary>
    PaperJapanesePostcard = 43;
    ///<summary>
    ///  9? ¡Á 11?
    ///</summary>
    Paper9x11 = 44;
    ///<summary>
    ///  10? ¡Á 11?
    ///</summary>
    Paper10x11 = 45;
    ///<summary>
    ///  15? ¡Á 11?
    ///</summary>
    Paper15x11 = 46;
    ///<summary>
    ///  Envelope Invite(220mm ¡Á 220mm)
    ///</summary>
    PaperEnvelopeInvite = 47;
    ///<summary>
    ///  US Letter Extra 9 \275 x 12 in
    ///</summary>
    PaperLetterExtra = 50;
    ///<summary>
    ///  US Legal Extra 9 \275 x 15 in
    ///</summary>
    PaperLegalExtra = 51;
    ///<summary>
    ///  US Tabloid Extra 11.69 x 18 in
    ///</summary>
    PaperTabloidExtra = 52;
    ///<summary>
    ///  A4 Extra 9.27 x 12.69 in
    ///</summary>
    PaperA4Extra = 53;
    ///<summary>
    ///  Letter Transverse 8 \275 x 11 in
    ///</summary>
    PaperLetterTransverse = 54;
    ///<summary>
    ///  A4 Transverse 210 x 297 mm
    ///</summary>
    PaperA4Transverse = 55;
    ///<summary>
    ///  Letter Extra Transverse 9\275 x 12 in
    ///</summary>
    PaperLetterExtraTransverse = 56;
    ///<summary>
    ///  SuperA/SuperA/A4 227 x 356 mm
    ///</summary>
    PaperSuperA = 57;
    ///<summary>
    ///  SuperB/SuperB/A3 305 x 487 mm
    ///</summary>
    PaperSuperB = 58;
    ///<summary>
    ///  US Letter Plus 8.5 x 12.69 in
    ///</summary>
    PaperLetterPlus = 59;
    ///<summary>
    ///  A4 Plus 210 x 330 mm
    ///</summary>
    PaperA4Plus = 60;
    ///<summary>
    ///  A5 Transverse 148 x 210 mm
    ///</summary>
    PaperA5Transverse = 61;
    ///<summary>
    ///  B5 (JIS) Transverse 182 x 257 mm
    ///</summary>
    PaperJISB5Transverse = 62;
    ///<summary>
    ///  A3 Extra 322 x 445 mm
    ///</summary>
    PaperA3Extra = 63;
    ///<summary>
    ///  A5 Extra 174 x 235 mm
    ///</summary>
    PaperA5Extra = 64;
    ///<summary>
    ///  B5 (ISO) Extra 201 x 276 mm
    ///</summary>
    PaperISOB5Extra = 65;
    ///<summary>
    ///  A2 420 x 594 mm
    ///</summary>
    PaperA2 = 66;
    ///<summary>
    ///  A3 Transverse 297 x 420 mm
    ///</summary>
    PaperA3Transverse = 67;
    ///<summary>
    ///  A3 Extra Transverse 322 x 445 mm
    ///</summary>
    PaperA3ExtraTransverse = 68;
    ///<summary>
    ///  Japanese Double Postcard 200 x 148 mm
    ///</summary>
    PaperJapaneseDoublePostcard = 69;
    ///<summary>
    ///  A6 105 x 148 mm
    ///</summary>
    PaperA6 = 70;
    ///<summary>
    ///  Japanese Envelope Kaku #2
    ///</summary>
    PaperJapaneseEnvelopeKaku2 = 71;
    ///<summary>
    ///  Japanese Envelope Kaku #3
    ///</summary>
    PaperJapaneseEnvelopeKaku3 = 72;
    ///<summary>
    ///  Japanese Envelope Chou #3
    ///</summary>
    PaperJapaneseEnvelopeChou3 = 73;
    ///<summary>
    ///  Japanese Envelope Chou #4
    ///</summary>
    PaperJapaneseEnvelopeChou4 = 74;
    ///<summary>
    ///  11in ¡Á 8.5in
    ///</summary>
    PaperLetterRotated = 75;
    ///<summary>
    ///  420mm ¡Á 297mm
    ///</summary>
    PaperA3Rotated = 76;
    ///<summary>
    ///  297mm ¡Á 210mm
    ///</summary>
    PaperA4Rotated = 77;
    ///<summary>
    ///  210mm ¡Á 148mm
    ///</summary>
    PaperA5Rotated = 78;
    ///<summary>
    ///  B4 (JIS) Rotated 364 x 257 mm
    ///</summary>
    PaperJISB4Rotated = 79;
    ///<summary>
    ///  B5 (JIS) Rotated 257 x 182 mm
    ///</summary>
    PaperJISB5Rotated = 80;
    ///<summary>
    ///  Japanese Postcard Rotated 148 x 100 mm
    ///</summary>
    PaperJapanesePostcardRotated = 81;
    ///<summary>
    ///  Double Japanese Postcard Rotated 148 x 200 mm
    ///</summary>
    PaperJapaneseDoublePostcardRotated = 82;
    ///<summary>
    ///  A6 Rotated 148 x 105 mm
    ///</summary>
    PaperA6Rotated = 83;
    ///<summary>
    ///  Japanese Envelope Kaku #2 Rotated
    ///</summary>
    PaperJapaneseEnvelopeKaku2Rotated = 84;
    ///<summary>
    ///  Japanese Envelope Kaku #3 Rotated
    ///</summary>
    PaperJapaneseEnvelopeKaku3Rotated = 85;
    ///<summary>
    ///  Japanese Envelope Chou #3 Rotated
    ///</summary>
    PaperJapaneseEnvelopeChou3Rotated = 86;
    ///<summary>
    ///  Japanese Envelope Chou #4 Rotated
    ///</summary>
    PaperJapaneseEnvelopeChou4Rotated = 87;
    ///<summary>
    ///  B6 (JIS) 128 x 182 mm
    ///</summary>
    PaperJISB6 = 88;
    ///<summary>
    ///  B6 (JIS) Rotated 182 x 128 mm
    ///</summary>
    PaperJISB6Rotated = 89;
    ///<summary>
    ///  12 x 11 in
    ///</summary>
    Paper12x11 = 90;
    ///<summary>
    ///  Japanese Envelope You #4
    ///</summary>
    PaperJapaneseEnvelopeYou4 = 91;
    ///<summary>
    ///  Japanese Envelope You #4 Rotated
    ///</summary>
    PaperJapaneseEnvelopeYou4Rotated = 92;
    ///<summary>
    ///  PRC 16K 146 x 215 mm
    ///</summary>
    PaperPRC16K = 93;
    ///<summary>
    ///  PRC 32K 97 x 151 mm
    ///</summary>
    PaperPRC32K = 94;
    ///<summary>
    ///  PRC 32K(Big) 97 x 151 mm
    ///</summary>
    PaperPRCBig32K = 95;
    ///<summary>
    ///  PRC Envelope #1 102 x 165 mm
    ///</summary>
    PaperPRCEnvelope1 = 96;
    ///<summary>
    ///  PRC Envelope #2 102 x 176 mm
    ///</summary>
    PaperPRCEnvelope2 = 97;
    ///<summary>
    ///  PRC Envelope #3 125 x 176 mm
    ///</summary>
    PaperPRCEnvelope3 = 98;
    ///<summary>
    ///  PRC Envelope #4 110 x 208 mm
    ///</summary>
    PaperPRCEnvelope4 = 99;
    ///<summary>
    ///  PRC Envelope #5 110 x 220 mm
    ///</summary>
    PaperPRCEnvelope5 = 100;
    ///<summary>
    ///  PRC Envelope #6 120 x 230 mm
    ///</summary>
    PaperPRCEnvelope6 = 101;
    ///<summary>
    ///  PRC Envelope #7 160 x 230 mm
    ///</summary>
    PaperPRCEnvelope7 = 102;
    ///<summary>
    ///  PRC Envelope #8 120 x 309 mm
    ///</summary>
    PaperPRCEnvelope8 = 103;
    ///<summary>
    ///  PRC Envelope #9 229 x 324 mm
    ///</summary>
    PaperPRCEnvelope9 = 104;
    ///<summary>
    ///  PRC Envelope #10 324 x 458 mm
    ///</summary>
    PaperPRCEnvelope10 = 105;
    ///<summary>
    ///  PRC 16K Rotated
    ///</summary>
    PaperPRC16KRotated = 106;
    ///<summary>
    ///  PRC 32K Rotated
    ///</summary>
    PaperPRC32KRotated = 107;
    ///<summary>
    ///  PRC 32K(Big) Rotated
    ///</summary>
    PaperPRCBig32KRotated = 108;
    ///<summary>
    ///  PRC Envelope #1 Rotated 165 x 102 mm
    ///</summary>
    PaperPRCEnvelope1Rotated = 109;
    ///<summary>
    ///  PRC Envelope #2 Rotated 176 x 102 mm
    ///</summary>
    PaperPRCEnvelope2Rotated = 110;
    ///<summary>
    ///  PRC Envelope #3 Rotated 176 x 125 mm
    ///</summary>
    PaperPRCEnvelope3Rotated = 111;
    ///<summary>
    ///  PRC Envelope #4 Rotated 208 x 110 mm
    ///</summary>
    PaperPRCEnvelope4Rotated = 112;
    ///<summary>
    ///  PRC Envelope #5 Rotated 220 x 110 mm
    ///</summary>
    PaperPRCEnvelope5Rotated = 113;
    ///<summary>
    ///  PRC Envelope #6 Rotated 230 x 120 mm
    ///</summary>
    PaperPRCEnvelope6Rotated = 114;
    ///<summary>
    ///  PRC Envelope #7 Rotated 230 x 160 mm
    ///</summary>
    PaperPRCEnvelope7Rotated = 115;
    ///<summary>
    ///  PRC Envelope #8 Rotated 309 x 120 mm
    ///</summary>
    PaperPRCEnvelope8Rotated = 116;
    ///<summary>
    ///  PRC Envelope #9 Rotated 324 x 229 mm
    ///</summary>
    PaperPRCEnvelope9Rotated = 117;
    ///<summary>
    ///  PRC Envelope #10 Rotated 458 x 324 mm
    ///</summary>
    PaperPRCEnvelope10Rotated = 118;
    ///<summary>
    ///  usual B3(13.9 x 19.7 in)
    ///</summary>
    PaperB3 = 300;
    ///<summary>
    ///  Business Card(90mm x 55 mm)
    ///</summary>
    PaperBusinessCard = 301;
    ///<summary>
    ///  Thermal(3 x 11 in)
    ///</summary>
    PaperThermal = 302;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents all parameters' type or return value type of function.
  ///</summary>
  [DNTypeName('Aspose.Cells.ParameterType')]
  DNParameterType = type Integer;
  DNParameterTypeHelper = record helper for DNParameterType
  public const
    ///<summary></summary>
    Reference = 0;
    ///<summary></summary>
    Value = 1;
    ///<summary></summary>
    Array_ = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the paste special type.
  ///</summary>
  [DNTypeName('Aspose.Cells.PasteType')]
  DNPasteType = type Integer;
  DNPasteTypeHelper = record helper for DNPasteType
  public const
    ///<summary>
    ///  Copies all data of the range.
    ///</summary>
    All = 0;
    ///<summary>
    ///  It works as "All" behavior of MS Excel.
    ///</summary>
    Default_ = 1;
    ///<summary>
    ///  Copies all data of the range without the range.
    ///</summary>
    AllExceptBorders = 2;
    ///<summary>
    ///  It works as "All except borders" behavior of MS Excel.
    ///</summary>
    DefaultExceptBorders = 3;
    ///<summary>
    ///  Only copies the widths of the range.
    ///</summary>
    ColumnWidths = 4;
    ///<summary>
    ///  Only copies the heights of the range.
    ///</summary>
    RowHeights = 5;
    ///<summary></summary>
    Comments = 6;
    ///<summary></summary>
    Formats = 7;
    ///<summary></summary>
    Formulas = 8;
    ///<summary></summary>
    FormulasAndNumberFormats = 9;
    ///<summary></summary>
    Validation = 10;
    ///<summary></summary>
    Values = 11;
    ///<summary></summary>
    ValuesAndNumberFormats = 12;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents PivotTable condition formatting rule type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotConditionFormatRuleType')]
  DNPivotConditionFormatRuleType = type Integer;
  DNPivotConditionFormatRuleTypeHelper = record helper for DNPivotConditionFormatRuleType
  public const
    ///<summary>
    ///  Indicates that Top N conditional formatting is not evaluated
    ///</summary>
    None = 0;
    ///<summary>
    ///  Indicates that Top N conditional formatting is
    ///  evaluated across the entire scope range.
    ///</summary>
    All = 1;
    ///<summary>
    ///  Indicates that Top N conditional formatting is evaluated for each row.
    ///</summary>
    Row = 2;
    ///<summary>
    ///  Indicates that Top N conditional formatting is
    ///  evaluated for each column.
    ///</summary>
    Column = 3;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents PivotTable condition formatting scope type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotConditionFormatScopeType')]
  DNPivotConditionFormatScopeType = type Integer;
  DNPivotConditionFormatScopeTypeHelper = record helper for DNPivotConditionFormatScopeType
  public const
    ///<summary>
    ///  Indicates that conditional formatting is applied to the selected data fields.
    ///</summary>
    Data = 0;
    ///<summary>
    ///  Indicates that conditional formatting is applied to the selected PivotTable field intersections.
    ///</summary>
    Field = 1;
    ///<summary>
    ///  Indicates that conditional formatting is applied to the selected cells.
    ///</summary>
    Selection = 2;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents data display format in the PivotTable data field.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotFieldDataDisplayFormat')]
  DNPivotFieldDataDisplayFormat = type Integer;
  DNPivotFieldDataDisplayFormatHelper = record helper for DNPivotFieldDataDisplayFormat
  public const
    ///<summary>
    ///  Represents normal display format.
    ///</summary>
    Normal = 0;
    ///<summary>
    ///  Represents difference from display format.
    ///</summary>
    DifferenceFrom = 1;
    ///<summary>
    ///  Represents percentage of display format.
    ///</summary>
    PercentageOf = 2;
    ///<summary>
    ///  Represents percentage difference from  display format.
    ///</summary>
    PercentageDifferenceFrom = 3;
    ///<summary>
    ///  Represents running total in display format.
    ///</summary>
    RunningTotalIn = 4;
    ///<summary>
    ///  Represents percentage of row display format.
    ///</summary>
    PercentageOfRow = 5;
    ///<summary>
    ///  Represents percentage of column display format.
    ///</summary>
    PercentageOfColumn = 6;
    ///<summary>
    ///  Represents percentage of total display format.
    ///</summary>
    PercentageOfTotal = 7;
    ///<summary>
    ///  Represents index display format.
    ///</summary>
    Index = 8;
    ///<summary>
    ///  Represents percentage of parent row total display format.
    ///</summary>
    PercentageOfParentRowTotal = 9;
    ///<summary>
    ///  Represents percentage of parent column total display format.
    ///</summary>
    PercentageOfParentColumnTotal = 10;
    ///<summary>
    ///  Represents percentage of parent total display format.
    ///</summary>
    PercentageOfParentTotal = 11;
    ///<summary>
    ///  Represents percentage of running total in display format.
    ///</summary>
    PercentageOfRunningTotalIn = 12;
    ///<summary>
    ///  Represents smallest to largest display format.
    ///</summary>
    RankSmallestToLargest = 13;
    ///<summary>
    ///  Represents largest to smallest display format.
    ///</summary>
    RankLargestToSmallest = 14;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Summary description for PivotFieldSubtotalType.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotFieldSubtotalType')]
  DNPivotFieldSubtotalType = type Integer;
  DNPivotFieldSubtotalTypeHelper = record helper for DNPivotFieldSubtotalType
  public const
    ///<summary>
    ///  Represents None subtotal type.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Represents Automatic subtotal type.
    ///</summary>
    Automatic = 1;
    ///<summary>
    ///  Represents Sum subtotal type.
    ///</summary>
    Sum = 2;
    ///<summary>
    ///  Represents Count subtotal type.
    ///</summary>
    Count = 4;
    ///<summary>
    ///  Represents Average subtotal type.
    ///</summary>
    Average = 8;
    ///<summary>
    ///  Represents Max subtotal type.
    ///</summary>
    Max = 16;
    ///<summary>
    ///  Represents Min subtotal type.
    ///</summary>
    Min = 32;
    ///<summary>
    ///  Represents Product subtotal type.
    ///</summary>
    Product = 64;
    ///<summary>
    ///  Represents Count Nums subtotal type.
    ///</summary>
    CountNums = 128;
    ///<summary>
    ///  Represents Stdev subtotal type.
    ///</summary>
    Stdev = 256;
    ///<summary>
    ///  Represents Stdevp subtotal type.
    ///</summary>
    Stdevp = 512;
    ///<summary>
    ///  Represents Var subtotal type.
    ///</summary>
    Var_ = 1024;
    ///<summary>
    ///  Represents Varp subtotal type.
    ///</summary>
    Varp = 2048;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents PivotTable field type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotFieldType')]
  DNPivotFieldType = type Integer;
  DNPivotFieldTypeHelper = record helper for DNPivotFieldType
  public const
    ///<summary>
    ///  Presents base pivot field type.
    ///</summary>
    Undefined = 0;
    ///<summary>
    ///  Presents row pivot field type.
    ///</summary>
    Row = 1;
    ///<summary>
    ///  Presents column pivot field type.
    ///</summary>
    Column = 2;
    ///<summary>
    ///  Presents page pivot field type.
    ///</summary>
    Page = 4;
    ///<summary>
    ///  Presents data pivot field type.
    ///</summary>
    Data = 8;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents PivotTable Filter type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotFilterType')]
  DNPivotFilterType = type Integer;
  DNPivotFilterTypeHelper = record helper for DNPivotFilterType
  public const
    ///<summary>
    ///  Indicates the "begins with" filter for field captions.
    ///</summary>
    CaptionBeginsWith = 0;
    ///<summary>
    ///  Indicates the "is between" filter for field captions.
    ///</summary>
    CaptionBetween = 1;
    ///<summary>
    ///  Indicates the "contains" filter for field captions.
    ///</summary>
    CaptionContains = 2;
    ///<summary>
    ///  Indicates the "ends with" filter for field captions.
    ///</summary>
    CaptionEndsWith = 3;
    ///<summary>
    ///  Indicates the "equal" filter for field captions.
    ///</summary>
    CaptionEqual = 4;
    ///<summary>
    ///  Indicates the "is greater than" filter for field captions.
    ///</summary>
    CaptionGreaterThan = 5;
    ///<summary>
    ///  Indicates the "is greater than or equal to" filter for field captions.
    ///</summary>
    CaptionGreaterThanOrEqual = 6;
    ///<summary>
    ///  Indicates the "is less than" filter for field captions.
    ///</summary>
    CaptionLessThan = 7;
    ///<summary>
    ///  Indicates the "is less than or equal to" filter for field captions.
    ///</summary>
    CaptionLessThanOrEqual = 8;
    ///<summary>
    ///  Indicates the "does not begin with" filter for field captions.
    ///</summary>
    CaptionNotBeginsWith = 9;
    ///<summary>
    ///  Indicates the "is not between" filter for field captions.
    ///</summary>
    CaptionNotBetween = 10;
    ///<summary>
    ///  Indicates the "does not contain" filter for field captions.
    ///</summary>
    CaptionNotContains = 11;
    ///<summary>
    ///  Indicates the "does not end with" filter for field captions.
    ///</summary>
    CaptionNotEndsWith = 12;
    ///<summary>
    ///  Indicates the "not equal" filter for field captions.
    ///</summary>
    CaptionNotEqual = 13;
    ///<summary>
    ///  Indicates the "count" filter.
    ///</summary>
    Count = 14;
    ///<summary>
    ///  Indicates the "between" filter for date values.
    ///</summary>
    DateBetween = 15;
    ///<summary>
    ///  Indicates the "equals" filter for date values.
    ///</summary>
    DateEqual = 16;
    ///<summary>
    ///  Indicates the "newer than" filter for date values.
    ///</summary>
    DateNewerThan = 17;
    ///<summary>
    ///  Indicates the "newer than or equal to" filter for date values.
    ///</summary>
    DateNewerThanOrEqual = 18;
    ///<summary>
    ///  Indicates the "not between" filter for date values.
    ///</summary>
    DateNotBetween = 19;
    ///<summary>
    ///  Indicates the "does not equal" filter for date values.
    ///</summary>
    DateNotEqual = 20;
    ///<summary>
    ///  Indicates the "older than" filter for date values.
    ///</summary>
    DateOlderThan = 21;
    ///<summary>
    ///  Indicates the "older than or equal to" filter for date values.
    ///</summary>
    DateOlderThanOrEqual = 22;
    ///<summary>
    ///  Indicates the "last month" filter for date values.
    ///</summary>
    LastMonth = 23;
    ///<summary>
    ///  Indicates the "last quarter" filter for date values.
    ///</summary>
    LastQuarter = 24;
    ///<summary>
    ///  Indicates the "last week" filter for date values.
    ///</summary>
    LastWeek = 25;
    ///<summary>
    ///  Indicates the "last year" filter for date values.
    ///</summary>
    LastYear = 26;
    ///<summary>
    ///  Indicates the "January" filter for date values.
    ///</summary>
    M1 = 27;
    ///<summary>
    ///  Indicates the "February" filter for date values.
    ///</summary>
    M2 = 28;
    ///<summary>
    ///  Indicates the "March" filter for date values.
    ///</summary>
    M3 = 29;
    ///<summary>
    ///  Indicates the "April" filter for date values.
    ///</summary>
    M4 = 30;
    ///<summary>
    ///  Indicates the "May" filter for date values.
    ///</summary>
    M5 = 31;
    ///<summary>
    ///  Indicates the "June" filter for date values.
    ///</summary>
    M6 = 32;
    ///<summary>
    ///  Indicates the "July" filter for date values.
    ///</summary>
    M7 = 33;
    ///<summary>
    ///  Indicates the "August" filter for date values.
    ///</summary>
    M8 = 34;
    ///<summary>
    ///  Indicates the "September" filter for date values.
    ///</summary>
    M9 = 35;
    ///<summary>
    ///  Indicates the "October" filter for date values.
    ///</summary>
    M10 = 36;
    ///<summary>
    ///  Indicates the "November" filter for date values.
    ///</summary>
    M11 = 37;
    ///<summary>
    ///  Indicates the "December" filter for date values.
    ///</summary>
    M12 = 38;
    ///<summary>
    ///  Indicates the "next month" filter for date values.
    ///</summary>
    NextMonth = 39;
    ///<summary>
    ///  Indicates the "next quarter" for date values.
    ///</summary>
    NextQuarter = 40;
    ///<summary>
    ///  Indicates the "next week" for date values.
    ///</summary>
    NextWeek = 41;
    ///<summary>
    ///  Indicates the "next year" filter for date values.
    ///</summary>
    NextYear = 42;
    ///<summary>
    ///  Indicates the "percent" filter for numeric values.
    ///</summary>
    Percent = 43;
    ///<summary>
    ///  Indicates the "first quarter" filter for date values.
    ///</summary>
    Q1 = 44;
    ///<summary>
    ///  Indicates the "second quarter" filter for date values.
    ///</summary>
    Q2 = 45;
    ///<summary>
    ///  Indicates the "third quarter" filter for date values.
    ///</summary>
    Q3 = 46;
    ///<summary>
    ///  Indicates the "fourth quarter" filter for date values.
    ///</summary>
    Q4 = 47;
    ///<summary>
    ///  Indicates the "sum" filter for numeric values.
    ///</summary>
    Sum = 48;
    ///<summary>
    ///  Indicates the "this month" filter for date values.
    ///</summary>
    ThisMonth = 49;
    ///<summary>
    ///  Indicates the "this quarter" filter for date values.
    ///</summary>
    ThisQuarter = 50;
    ///<summary>
    ///  Indicates the "this week" filter for date values.
    ///</summary>
    ThisWeek = 51;
    ///<summary>
    ///  Indicate the "this year" filter for date values.
    ///</summary>
    ThisYear = 52;
    ///<summary>
    ///  Indicates the "today" filter for date values.
    ///</summary>
    Today = 53;
    ///<summary>
    ///  Indicates the "tomorrow" filter for date values.
    ///</summary>
    Tomorrow = 54;
    ///<summary>
    ///  Indicates the PivotTable filter is unknown to the application.
    ///</summary>
    Unknown = 55;
    ///<summary>
    ///  Indicates the "Value between" filter for text and numeric values.
    ///</summary>
    ValueBetween = 56;
    ///<summary>
    ///  Indicates the "value equal" filter for text and numeric values.
    ///</summary>
    ValueEqual = 57;
    ///<summary>
    ///  Indicates the "value greater than" filter for text and numeric values.
    ///</summary>
    ValueGreaterThan = 58;
    ///<summary>
    ///  Indicates the "value greater than or equal to" filter for text and numeric values.
    ///</summary>
    ValueGreaterThanOrEqual = 59;
    ///<summary>
    ///  Indicates the "value less than" filter for text and numeric values.
    ///</summary>
    ValueLessThan = 60;
    ///<summary>
    ///  Indicates the "value less than or equal to" filter for text and numeric values.
    ///</summary>
    ValueLessThanOrEqual = 61;
    ///<summary>
    ///  Indicates the "value not between" filter for text and numeric values.
    ///</summary>
    ValueNotBetween = 62;
    ///<summary>
    ///  Indicates the "value not equal" filter for text and numeric values.
    ///</summary>
    ValueNotEqual = 63;
    ///<summary>
    ///  Indicates the "year-to-date" filter for date values.
    ///</summary>
    YearToDate = 64;
    ///<summary>
    ///  Indicates the "yesterday" filter for date values.
    ///</summary>
    Yesterday = 65;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents PivotTable groupby type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotGroupByType')]
  DNPivotGroupByType = type Integer;
  DNPivotGroupByTypeHelper = record helper for DNPivotGroupByType
  public const
    ///<summary>
    ///  Presents range of values groupby type.
    ///</summary>
    RangeOfValues = 0;
    ///<summary>
    ///  Presents Seconds groupby type.
    ///</summary>
    Seconds = 1;
    ///<summary>
    ///  Presents Minutes groupby type.
    ///</summary>
    Minutes = 2;
    ///<summary>
    ///  Presents Hours groupby type.
    ///</summary>
    Hours = 3;
    ///<summary>
    ///  Presents Days groupby type.
    ///</summary>
    Days = 4;
    ///<summary>
    ///  Presents Months groupby type.
    ///</summary>
    Months = 5;
    ///<summary>
    ///  Presents Quarters groupby type.
    ///</summary>
    Quarters = 6;
    ///<summary>
    ///  Presents Years groupby type.
    ///</summary>
    Years = 7;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents PivotTable base item Next/Previous/All position in the base field .
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotItemPosition')]
  DNPivotItemPosition = type Integer;
  DNPivotItemPositionHelper = record helper for DNPivotItemPosition
  public const
    ///<summary>
    ///  Represents the previous pivot item in the PivotField.
    ///</summary>
    Previous = 0;
    ///<summary>
    ///  Represents the next pivot item in the PivotField.
    ///</summary>
    Next = 1;
    ///<summary>
    ///  Represents a pivot item index, as specified by Pivot Items, that specifies a pivot item in the PivotField.
    ///<remarks>only read</remarks>
    ///</summary>
    Custom = 2;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents number of items to retain per field.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotMissingItemLimitType')]
  DNPivotMissingItemLimitType = type Integer;
  DNPivotMissingItemLimitTypeHelper = record helper for DNPivotMissingItemLimitType
  public const
    ///<summary>
    ///  The default number of unique items per PivotField allowed.
    ///</summary>
    Automatic = 0;
    ///<summary>
    ///  The maximum number of unique items per PivotField allowed (&gt;32,500).
    ///</summary>
    Max = 1;
    ///<summary>
    ///  No unique items per PivotField allowed.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents PivotTable auto format type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotTableAutoFormatType')]
  DNPivotTableAutoFormatType = type Integer;
  DNPivotTableAutoFormatTypeHelper = record helper for DNPivotTableAutoFormatType
  public const
    ///<summary>
    ///  Represents None format type.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Represents Classic auto format type.
    ///</summary>
    Classic = 1;
    ///<summary>
    ///  Represents Report1 format type.
    ///</summary>
    Report1 = 2;
    ///<summary>
    ///  Represents Report2 format type.
    ///</summary>
    Report2 = 3;
    ///<summary>
    ///  Represents Report3 format type.
    ///</summary>
    Report3 = 4;
    ///<summary>
    ///  Represents Report4 format type.
    ///</summary>
    Report4 = 5;
    ///<summary>
    ///  Represents Report5 format type.
    ///</summary>
    Report5 = 6;
    ///<summary>
    ///  Represents Report6 format type.
    ///</summary>
    Report6 = 7;
    ///<summary>
    ///  Represents Report7 format type.
    ///</summary>
    Report7 = 8;
    ///<summary>
    ///  Represents Report8 format type.
    ///</summary>
    Report8 = 9;
    ///<summary>
    ///  Represents Report9 format type.
    ///</summary>
    Report9 = 10;
    ///<summary>
    ///  Represents Report10 format type.
    ///</summary>
    Report10 = 11;
    ///<summary>
    ///  Represents Table1 format type.
    ///</summary>
    Table1 = 12;
    ///<summary>
    ///  Represents Table2 format type.
    ///</summary>
    Table2 = 13;
    ///<summary>
    ///  Represents Table3 format type.
    ///</summary>
    Table3 = 14;
    ///<summary>
    ///  Represents Table4 format type.
    ///</summary>
    Table4 = 15;
    ///<summary>
    ///  Represents Table5 format type.
    ///</summary>
    Table5 = 16;
    ///<summary>
    ///  Represents Table6 format type.
    ///</summary>
    Table6 = 17;
    ///<summary>
    ///  Represents Table7 format type.
    ///</summary>
    Table7 = 18;
    ///<summary>
    ///  Represents Table8 format type.
    ///</summary>
    Table8 = 19;
    ///<summary>
    ///  Represents Table9 format type.
    ///</summary>
    Table9 = 20;
    ///<summary>
    ///  Represents Table10 format type.
    ///</summary>
    Table10 = 21;
  end;


  //-------------namespace: Aspose.Cells.Pivot----------------
  ///<summary>
  ///  Represents the pivot table style type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Pivot.PivotTableStyleType')]
  DNPivotTableStyleType = type Integer;
  DNPivotTableStyleTypeHelper = record helper for DNPivotTableStyleType
  public const
    ///<summary></summary>
    None = 0;
    ///<summary></summary>
    PivotTableStyleLight1 = 1;
    ///<summary></summary>
    PivotTableStyleLight2 = 2;
    ///<summary></summary>
    PivotTableStyleLight3 = 3;
    ///<summary></summary>
    PivotTableStyleLight4 = 4;
    ///<summary></summary>
    PivotTableStyleLight5 = 5;
    ///<summary></summary>
    PivotTableStyleLight6 = 6;
    ///<summary></summary>
    PivotTableStyleLight7 = 7;
    ///<summary></summary>
    PivotTableStyleLight8 = 8;
    ///<summary></summary>
    PivotTableStyleLight9 = 9;
    ///<summary></summary>
    PivotTableStyleLight10 = 10;
    ///<summary></summary>
    PivotTableStyleLight11 = 11;
    ///<summary></summary>
    PivotTableStyleLight12 = 12;
    ///<summary></summary>
    PivotTableStyleLight13 = 13;
    ///<summary></summary>
    PivotTableStyleLight14 = 14;
    ///<summary></summary>
    PivotTableStyleLight15 = 15;
    ///<summary></summary>
    PivotTableStyleLight16 = 16;
    ///<summary></summary>
    PivotTableStyleLight17 = 17;
    ///<summary></summary>
    PivotTableStyleLight18 = 18;
    ///<summary></summary>
    PivotTableStyleLight19 = 19;
    ///<summary></summary>
    PivotTableStyleLight20 = 20;
    ///<summary></summary>
    PivotTableStyleLight21 = 21;
    ///<summary></summary>
    PivotTableStyleLight22 = 22;
    ///<summary></summary>
    PivotTableStyleLight23 = 23;
    ///<summary></summary>
    PivotTableStyleLight24 = 24;
    ///<summary></summary>
    PivotTableStyleLight25 = 25;
    ///<summary></summary>
    PivotTableStyleLight26 = 26;
    ///<summary></summary>
    PivotTableStyleLight27 = 27;
    ///<summary></summary>
    PivotTableStyleLight28 = 28;
    ///<summary></summary>
    PivotTableStyleMedium1 = 29;
    ///<summary></summary>
    PivotTableStyleMedium2 = 30;
    ///<summary></summary>
    PivotTableStyleMedium3 = 31;
    ///<summary></summary>
    PivotTableStyleMedium4 = 32;
    ///<summary></summary>
    PivotTableStyleMedium5 = 33;
    ///<summary></summary>
    PivotTableStyleMedium6 = 34;
    ///<summary></summary>
    PivotTableStyleMedium7 = 35;
    ///<summary></summary>
    PivotTableStyleMedium8 = 36;
    ///<summary></summary>
    PivotTableStyleMedium9 = 37;
    ///<summary></summary>
    PivotTableStyleMedium10 = 38;
    ///<summary></summary>
    PivotTableStyleMedium11 = 39;
    ///<summary></summary>
    PivotTableStyleMedium12 = 40;
    ///<summary></summary>
    PivotTableStyleMedium13 = 41;
    ///<summary></summary>
    PivotTableStyleMedium14 = 42;
    ///<summary></summary>
    PivotTableStyleMedium15 = 43;
    ///<summary></summary>
    PivotTableStyleMedium16 = 44;
    ///<summary></summary>
    PivotTableStyleMedium17 = 45;
    ///<summary></summary>
    PivotTableStyleMedium18 = 46;
    ///<summary></summary>
    PivotTableStyleMedium19 = 47;
    ///<summary></summary>
    PivotTableStyleMedium20 = 48;
    ///<summary></summary>
    PivotTableStyleMedium21 = 49;
    ///<summary></summary>
    PivotTableStyleMedium22 = 50;
    ///<summary></summary>
    PivotTableStyleMedium23 = 51;
    ///<summary></summary>
    PivotTableStyleMedium24 = 52;
    ///<summary></summary>
    PivotTableStyleMedium25 = 53;
    ///<summary></summary>
    PivotTableStyleMedium26 = 54;
    ///<summary></summary>
    PivotTableStyleMedium27 = 55;
    ///<summary></summary>
    PivotTableStyleMedium28 = 56;
    ///<summary></summary>
    PivotTableStyleDark1 = 57;
    ///<summary></summary>
    PivotTableStyleDark2 = 58;
    ///<summary></summary>
    PivotTableStyleDark3 = 59;
    ///<summary></summary>
    PivotTableStyleDark4 = 60;
    ///<summary></summary>
    PivotTableStyleDark5 = 61;
    ///<summary></summary>
    PivotTableStyleDark6 = 62;
    ///<summary></summary>
    PivotTableStyleDark7 = 63;
    ///<summary></summary>
    PivotTableStyleDark8 = 64;
    ///<summary></summary>
    PivotTableStyleDark9 = 65;
    ///<summary></summary>
    PivotTableStyleDark10 = 66;
    ///<summary></summary>
    PivotTableStyleDark11 = 67;
    ///<summary></summary>
    PivotTableStyleDark12 = 68;
    ///<summary></summary>
    PivotTableStyleDark13 = 69;
    ///<summary></summary>
    PivotTableStyleDark14 = 70;
    ///<summary></summary>
    PivotTableStyleDark15 = 71;
    ///<summary></summary>
    PivotTableStyleDark16 = 72;
    ///<summary></summary>
    PivotTableStyleDark17 = 73;
    ///<summary></summary>
    PivotTableStyleDark18 = 74;
    ///<summary></summary>
    PivotTableStyleDark19 = 75;
    ///<summary></summary>
    PivotTableStyleDark20 = 76;
    ///<summary></summary>
    PivotTableStyleDark21 = 77;
    ///<summary></summary>
    PivotTableStyleDark22 = 78;
    ///<summary></summary>
    PivotTableStyleDark23 = 79;
    ///<summary></summary>
    PivotTableStyleDark24 = 80;
    ///<summary></summary>
    PivotTableStyleDark25 = 81;
    ///<summary></summary>
    PivotTableStyleDark26 = 82;
    ///<summary></summary>
    PivotTableStyleDark27 = 83;
    ///<summary></summary>
    PivotTableStyleDark28 = 84;
    ///<summary></summary>
    Custom = 85;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the way comments are printed with the sheet.
  ///</summary>
  [DNTypeName('Aspose.Cells.PrintCommentsType')]
  DNPrintCommentsType = type Integer;
  DNPrintCommentsTypeHelper = record helper for DNPrintCommentsType
  public const
    ///<summary>
    ///  Represents to print comments as displayed on sheet.
    ///</summary>
    PrintInPlace = 0;
    ///<summary>
    ///  Represents not to print comments.
    ///</summary>
    PrintNoComments = 1;
    ///<summary>
    ///  Represents to print comments at end of sheet.
    ///</summary>
    PrintSheetEnd = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents print errors constants.
  ///</summary>
  [DNTypeName('Aspose.Cells.PrintErrorsType')]
  DNPrintErrorsType = type Integer;
  DNPrintErrorsTypeHelper = record helper for DNPrintErrorsType
  public const
    ///<summary>
    ///  Represents not to print errors.
    ///</summary>
    PrintErrorsBlank = 0;
    ///<summary>
    ///  Represents to print errors as "--".
    ///</summary>
    PrintErrorsDash = 1;
    ///<summary>
    ///  Represents to print errors as displayed.
    ///</summary>
    PrintErrorsDisplayed = 2;
    ///<summary>
    ///  Represents to print errors as "#N/A".
    ///</summary>
    PrintErrorsNA = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Indicates which pages will not be printed.
  ///</summary>
  [DNTypeName('Aspose.Cells.PrintingPageType')]
  DNPrintingPageType = type Integer;
  DNPrintingPageTypeHelper = record helper for DNPrintingPageType
  public const
    ///<summary>
    ///  Prints all pages.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Don't print the pages which the cells are blank.
    ///</summary>
    IgnoreBlank = 1;
    ///<summary>
    ///  Don't print the pages which cells only contain styles.
    ///</summary>
    IgnoreStyle = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represent print order constants.
  ///</summary>
  [DNTypeName('Aspose.Cells.PrintOrderType')]
  DNPrintOrderType = type Integer;
  DNPrintOrderTypeHelper = record helper for DNPrintOrderType
  public const
    ///<summary>
    ///  Down, then over
    ///</summary>
    DownThenOver = 0;
    ///<summary>
    ///  Over, then down
    ///</summary>
    OverThenDown = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the printed chart size.
  ///</summary>
  [DNTypeName('Aspose.Cells.PrintSizeType')]
  DNPrintSizeType = type Integer;
  DNPrintSizeTypeHelper = record helper for DNPrintSizeType
  public const
    ///<summary>
    ///  Use full page.
    ///</summary>
    Full = 0;
    ///<summary>
    ///  Scale to fit page.
    ///</summary>
    Fit = 1;
    ///<summary>
    ///  Custom.
    ///</summary>
    Custom = 2;
  end;


  //-------------namespace: Aspose.Cells.Properties----------------
  ///<summary>
  ///  Specifies data type of a document property.
  ///</summary>
  [DNTypeName('Aspose.Cells.Properties.PropertyType')]
  DNPropertyType = type Integer;
  DNPropertyTypeHelper = record helper for DNPropertyType
  public const
    ///<summary>
    ///  The property is a boolean value.
    ///</summary>
    Boolean = 0;
    ///<summary>
    ///  The property is a date time value.
    ///</summary>
    DateTime = 1;
    ///<summary>
    ///  The property is a floating number.
    ///</summary>
    Double = 2;
    ///<summary>
    ///  The property is an integer number.
    ///</summary>
    Number = 3;
    ///<summary>
    ///  The property is a string value.
    ///</summary>
    String_ = 4;
    ///<summary>
    ///  The property is a byte array.
    ///</summary>
    Blob = 5;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents workbook/worksheet protection type.
  ///</summary>
  [DNTypeName('Aspose.Cells.ProtectionType')]
  DNProtectionType = type Integer;
  DNProtectionTypeHelper = record helper for DNProtectionType
  public const
    ///<summary>
    ///  Represents to protect all.
    ///</summary>
    All = 0;
    ///<summary>
    ///  Represents to protect contents, used in Worksheet protection.
    ///</summary>
    Contents = 1;
    ///<summary>
    ///  Represents to protect objects, used in Worksheet protection.
    ///</summary>
    Objects = 2;
    ///<summary>
    ///  Represents to protect scenarios, used in Worksheet protection.
    ///</summary>
    Scenarios = 3;
    ///<summary>
    ///  Represents to protect structure, used in Workbook protection.
    ///</summary>
    Structure = 4;
    ///<summary>
    ///  Represents to protect window, used in Workbook protection.
    ///</summary>
    Windows = 5;
    ///<summary>
    ///  Represents no protection. Only for Reading property.
    ///</summary>
    None = 6;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Renames strategy when columns contains the duplicate names.
  ///</summary>
  [DNTypeName('Aspose.Cells.RenameStrategy')]
  DNRenameStrategy = type Integer;
  DNRenameStrategyHelper = record helper for DNRenameStrategy
  public const
    ///<summary>
    ///  Throws exception.
    ///</summary>
    Exception = 0;
    ///<summary>
    ///  Named with digit.
    ///</summary>
    Digit = 1;
    ///<summary>
    ///  Named with letter.
    ///</summary>
    Letter = 2;
  end;


  //-------------namespace: Aspose.Cells.Rendering----------------
  ///<summary>
  ///  Enumerates Bit Depth Type for tiff image.
  ///</summary>
  [DNTypeName('Aspose.Cells.Rendering.ColorDepth')]
  DNColorDepth = type Integer;
  DNColorDepthHelper = record helper for DNColorDepth
  public const
    ///<summary>
    ///  Default value, not set value.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  1 bit per pixel
    ///</summary>
    Format1bpp = 1;
    ///<summary>
    ///  84 bits per pixel
    ///</summary>
    Format4bpp = 4;
    ///<summary>
    ///  8 bits per pixel
    ///</summary>
    Format8bpp = 8;
    ///<summary>
    ///  24 bits per pixel
    ///</summary>
    Format24bpp = 24;
    ///<summary>
    ///  32 bits per pixel
    ///</summary>
    Format32bpp = 32;
  end;


  //-------------namespace: Aspose.Cells.Rendering----------------
  ///<summary>
  ///  Indicate Cell or Image of DrawObject.
  ///</summary>
  [DNTypeName('Aspose.Cells.Rendering.DrawObjectEnum')]
  DNDrawObjectEnum = type Integer;
  DNDrawObjectEnumHelper = record helper for DNDrawObjectEnum
  public const
    ///<summary>
    ///  Indicate DrawObject is an Image
    ///</summary>
    Image = 0;
    ///<summary>
    ///  indicate DrawObject is an Cell
    ///</summary>
    Cell = 1;
  end;


  //-------------namespace: Aspose.Cells.Rendering----------------
  ///<summary>
  ///  Allowing user to set PDF conversion's Compatibility
  ///</summary>
  [DNTypeName('Aspose.Cells.Rendering.PdfCompliance')]
  DNPdfCompliance = type Integer;
  DNPdfComplianceHelper = record helper for DNPdfCompliance
  public const
    ///<summary>
    ///  Normal pdf format
    ///</summary>
    None = 0;
    ///<summary>
    ///  Pdf format compatible with PDFA-1b
    ///</summary>
    PdfA1b = 1;
    ///<summary>
    ///  Pdf format compatible with PDFA-1a
    ///</summary>
    PdfA1a = 2;
  end;


  //-------------namespace: Aspose.Cells.Rendering----------------
  ///<summary>
  ///  Specifies a type of compression applied to all content in the PDF file except images.
  ///</summary>
  [DNTypeName('Aspose.Cells.Rendering.PdfCompressionCore')]
  DNPdfCompressionCore = type Integer;
  DNPdfCompressionCoreHelper = record helper for DNPdfCompressionCore
  public const
    ///<summary>
    ///  None
    ///</summary>
    None = 0;
    ///<summary>
    ///  Rle
    ///</summary>
    Rle = 1;
    ///<summary>
    ///  Lzw
    ///</summary>
    Lzw = 2;
    ///<summary>
    ///  Flate
    ///</summary>
    Flate = 3;
  end;


  //-------------namespace: Aspose.Cells.Rendering----------------
  ///<summary>
  ///  Specifies the way <see cref="T:Aspose.Cells.Properties.CustomDocumentPropertyCollection" />
  ///  are exported to PDF file.
  ///</summary>
  [DNTypeName('Aspose.Cells.Rendering.PdfCustomPropertiesExport')]
  DNPdfCustomPropertiesExport = type Integer;
  DNPdfCustomPropertiesExportHelper = record helper for DNPdfCustomPropertiesExport
  public const
    ///<summary>
    ///  No custom properties are exported.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Custom properties are exported as entries in Info dictionary.
    ///</summary>
    ///<remarks>
    ///  Custom properties with the following names are not exported:
    ///  "Title", "Author", "Subject", "Keywords", "Creator", "Producer", "CreationDate", "ModDate", "Trapped".
    ///</remarks>
    Standard = 1;
  end;


  //-------------namespace: Aspose.Cells.Rendering----------------
  [DNTypeName('Aspose.Cells.Rendering.PdfFontEncoding')]
  DNPdfFontEncoding = type Integer;
  DNPdfFontEncodingHelper = record helper for DNPdfFontEncoding
  public const
    Identity = 0;
    AnsiPrefer = 1;
  end;


  //-------------namespace: Aspose.Cells.Rendering----------------
  ///<summary>
  ///  Specifies a type of optimization.
  ///</summary>
  [DNTypeName('Aspose.Cells.Rendering.PdfOptimizationType')]
  DNPdfOptimizationType = type Integer;
  DNPdfOptimizationTypeHelper = record helper for DNPdfOptimizationType
  public const
    ///<summary>
    ///  High print quality
    ///</summary>
    Standard = 0;
    ///<summary>
    ///  File size is more important than print quality
    ///</summary>
    MinimumSize = 1;
  end;


  //-------------namespace: Aspose.Cells.Rendering----------------
  ///<summary>
  ///  Specifies what type of compression to apply when saving images into TIFF format file.
  ///</summary>
  [DNTypeName('Aspose.Cells.Rendering.TiffCompression')]
  DNTiffCompression = type Integer;
  DNTiffCompressionHelper = record helper for DNTiffCompression
  public const
    ///<summary>
    ///  Specifies no compression.
    ///</summary>
    CompressionNone = 0;
    ///<summary>
    ///  Specifies the RLE compression scheme.
    ///</summary>
    CompressionRle = 1;
    ///<summary>
    ///  Specifies the LZW compression scheme.
    ///</summary>
    CompressionLZW = 2;
    ///<summary>
    ///  Specifies the CCITT3 compression scheme.
    ///</summary>
    CompressionCCITT3 = 3;
    ///<summary>
    ///  Specifies the CCITT4 compression scheme.
    ///</summary>
    CompressionCCITT4 = 4;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents how to loading the linked resource.
  ///</summary>
  [DNTypeName('Aspose.Cells.ResourceLoadingType')]
  DNResourceLoadingType = type Integer;
  DNResourceLoadingTypeHelper = record helper for DNResourceLoadingType
  public const
    ///<summary>
    ///  Loads this resource as usual.
    ///</summary>
    Default_ = 0;
    ///<summary>
    ///  Skips loading of this resource.
    ///</summary>
    Skip = 1;
    ///<summary>
    ///  Use stream provided by user
    ///</summary>
    UserProvided = 2;
  end;


  //-------------namespace: Aspose.Cells.Revisions----------------
  ///<summary>
  ///  Represents the type of revision action.
  ///</summary>
  [DNTypeName('Aspose.Cells.Revisions.RevisionActionType')]
  DNRevisionActionType = type Integer;
  DNRevisionActionTypeHelper = record helper for DNRevisionActionType
  public const
    ///<summary>
    ///  Add revision.
    ///</summary>
    Add = 0;
    ///<summary>
    ///  Delete revision.
    ///</summary>
    Delete = 1;
    ///<summary>
    ///  Column delete revision.
    ///</summary>
    DeleteColumn = 2;
    ///<summary>
    ///  Row delete revision.
    ///</summary>
    DeleteRow = 3;
    ///<summary>
    ///  Column insert revision.
    ///</summary>
    InsertColumn = 4;
    ///<summary>
    ///  Row insert revision.
    ///</summary>
    InsertRow = 5;
  end;


  //-------------namespace: Aspose.Cells.Revisions----------------
  ///<summary>
  ///  Represents the revision type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Revisions.RevisionType')]
  DNRevisionType = type Integer;
  DNRevisionTypeHelper = record helper for DNRevisionType
  public const
    ///<summary>
    ///  Custom view.
    ///</summary>
    CustomView = 0;
    ///<summary>
    ///  Defined name.
    ///</summary>
    DefinedName = 1;
    ///<summary>
    ///  Cells change.
    ///</summary>
    ChangeCells = 2;
    ///<summary>
    ///  Auto format.
    ///</summary>
    AutoFormat = 3;
    ///<summary>
    ///  Merge conflict.
    ///</summary>
    MergeConflict = 4;
    ///<summary>
    ///  Comment.
    ///</summary>
    Comment = 5;
    ///<summary>
    ///  Format.
    ///</summary>
    Format = 6;
    ///<summary>
    ///  Insert worksheet.
    ///</summary>
    InsertSheet = 7;
    ///<summary>
    ///  Move cells.
    ///</summary>
    MoveCells = 8;
    ///<summary>
    ///  Undo.
    ///</summary>
    Undo = 9;
    ///<summary>
    ///  Query table.
    ///</summary>
    QueryTable = 10;
    ///<summary>
    ///  Inserting or deleting.
    ///</summary>
    InsertDelete = 11;
    ///<summary>
    ///  Rename worksheet.
    ///</summary>
    RenameSheet = 12;
    ///<summary>
    ///  Unknown.
    ///</summary>
    Unknown = 13;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the format in which the workbook is saved.
  ///</summary>
  [DNTypeName('Aspose.Cells.SaveFormat')]
  DNSaveFormat = type Integer;
  DNSaveFormatHelper = record helper for DNSaveFormat
  public const
    ///<summary>
    ///  If saving the file to the disk,the file format accords to the extension of the file name.
    ///  If saving the file to the stream, the file format is xlsx.
    ///</summary>
    Auto = 0;
    ///<summary>
    ///  Comma-Separated Values(CSV) text file.
    ///</summary>
    Csv = 1;
    ///<summary>
    ///  Represents an Excel97-2003 xls file.
    ///</summary>
    Excel97To2003 = 5;
    ///<summary>
    ///  Represents an xlsx file.
    ///</summary>
    Xlsx = 6;
    ///<summary>
    ///  Represents an xlsm file which enable macros.
    ///</summary>
    Xlsm = 7;
    ///<summary>
    ///  Represents an xltx file.
    ///</summary>
    Xltx = 8;
    ///<summary>
    ///  Represents an xltm file which enable macros.
    ///</summary>
    Xltm = 9;
    ///<summary>
    ///  Represents an xltm file which enable addin macros.
    ///</summary>
    Xlam = 10;
    ///<summary>
    ///  Tab-Separated Values(TSV) text file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.SaveFormat.Tsv" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    TSV = 11;
    ///<summary>
    ///  Represents a tab delimited text file, same with <see cref="F:Aspose.Cells.SaveFormat.Tsv" />
    ///  .
    ///</summary>
    TabDelimited = 11;
    ///<summary>
    ///  Represents a html file.
    ///</summary>
    Html = 12;
    ///<summary>
    ///  Represents a Pdf file.
    ///</summary>
    Pdf = 13;
    ///<summary>
    ///  Open Document Sheet(ODS) file.
    ///</summary>
    Ods = 14;
    ///<summary>
    ///  Represents an Excel 2003 xml file.
    ///</summary>
    SpreadsheetML = 15;
    ///<summary>
    ///  Represents an xlsb file.
    ///</summary>
    Xlsb = 16;
    ///<summary>
    ///  Represents a mhtml file.
    ///</summary>
    MHtml = 17;
    ///<summary>
    ///  XPS (XML Paper Specification) format.
    ///</summary>
    Xps = 20;
    ///<summary>
    ///  Represents a TIFF file.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.SaveFormat.Tiff" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    TIFF = 21;
    ///<summary>
    ///  SVG file.
    ///</summary>
    Svg = 28;
    ///<summary>
    ///  Data Interchange Format.
    ///</summary>
    Dif = 30;
    ///<summary>
    ///  Represents a numbers file.
    ///</summary>
    Numbers = 56;
    ///<summary>
    ///  Represents markdown document.
    ///</summary>
    Markdown = 57;
    ///<summary>
    ///  Represents OpenDocument Flat XML Spreadsheet (.fods) file format.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use <see cref="F:Aspose.Cells.SaveFormat.Fods" />
    ///  property.
    ///  This property will be removed 6 months later since April 2021.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</summary>
    FODS = 59;
    ///<summary>
    ///  Represents StarOffice Calc Spreadsheet (.sxc) file format.
    ///</summary>
    Sxc = 60;
    ///<summary>
    ///  Represents .pptx file.
    ///</summary>
    Pptx = 61;
    ///<summary>
    ///  Represents .docx file.
    ///</summary>
    Docx = 62;
    ///<summary>
    ///  Represents unrecognized format, cannot be saved.
    ///</summary>
    Unknown = 255;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies the worksheet type.
  ///</summary>
  [DNTypeName('Aspose.Cells.SheetType')]
  DNSheetType = type Integer;
  DNSheetTypeHelper = record helper for DNSheetType
  public const
    ///<summary>
    ///  Visual Basic module
    ///</summary>
    VB = 0;
    ///<summary></summary>
    Worksheet = 1;
    ///<summary>
    ///  Chart
    ///</summary>
    Chart = 2;
    ///<summary>
    ///  BIFF4 Macro sheet
    ///</summary>
    BIFF4Macro = 3;
    ///<summary>
    ///  International Macro sheet
    ///</summary>
    InternationalMacro = 4;
    ///<summary></summary>
    Other = 5;
    ///<summary>
    ///  Dialog worksheet
    ///</summary>
    Dialog = 6;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represent the shift options when deleting a range of cells.
  ///</summary>
  [DNTypeName('Aspose.Cells.ShiftType')]
  DNShiftType = type Integer;
  DNShiftTypeHelper = record helper for DNShiftType
  public const
    ///<summary>
    ///  Shift cells down.
    ///</summary>
    Down = 0;
    ///<summary>
    ///  Shift cells left.
    ///</summary>
    Left = 1;
    ///<summary>
    ///  Do not shift cells.
    ///</summary>
    None = 2;
    ///<summary>
    ///  Shift cells right.
    ///</summary>
    Right = 3;
    ///<summary>
    ///  Shift cells up.
    ///</summary>
    Up = 4;
  end;


  //-------------namespace: Aspose.Cells.Slicers----------------
  ///<summary>
  ///  Represent the type of SlicerCacheCrossFilterType
  ///</summary>
  [DNTypeName('Aspose.Cells.Slicers.SlicerCacheCrossFilterType')]
  DNSlicerCacheCrossFilterType = type Integer;
  DNSlicerCacheCrossFilterTypeHelper = record helper for DNSlicerCacheCrossFilterType
  public const
    ///<summary>
    ///  The table style element of the slicer style for slicer items
    ///  with no data is not applied to slicer items with no data, and slicer items
    ///  with no data are not sorted separately in the list of slicer items in the slicer view
    ///</summary>
    None = 0;
    ///<summary>
    ///  The table style element of the slicer style for slicer items with
    ///  no data is applied to slicer items with no data, and slicer items
    ///  with no data are sorted at the bottom in the list of slicer items in the slicer view
    ///</summary>
    ShowItemsWithDataAtTop = 1;
    ///<summary>
    ///  The table style element of the slicer style for slicer items with no data
    ///  is applied to slicer items with no data, and slicer items with no data
    ///  are not sorted separately in the list of slicer items in the slicer view.
    ///</summary>
    ShowItemsWithNoData = 2;
  end;


  //-------------namespace: Aspose.Cells.Slicers----------------
  ///<summary>
  ///  Specify the sort type of SlicerCacheItem
  ///</summary>
  [DNTypeName('Aspose.Cells.Slicers.SlicerCacheItemSortType')]
  DNSlicerCacheItemSortType = type Integer;
  DNSlicerCacheItemSortTypeHelper = record helper for DNSlicerCacheItemSortType
  public const
    ///<summary>
    ///  Ascending sort type
    ///</summary>
    Ascending = 0;
    ///<summary>
    ///  Descending sort type
    ///</summary>
    Descending = 1;
  end;


  //-------------namespace: Aspose.Cells.Slicers----------------
  ///<summary>
  ///  Specify the style of slicer view
  ///</summary>
  [DNTypeName('Aspose.Cells.Slicers.SlicerStyleType')]
  DNSlicerStyleType = type Integer;
  DNSlicerStyleTypeHelper = record helper for DNSlicerStyleType
  public const
    ///<summary>
    ///  built-in light style one
    ///</summary>
    SlicerStyleLight1 = 0;
    ///<summary>
    ///  built-in light style two
    ///</summary>
    SlicerStyleLight2 = 1;
    ///<summary>
    ///  built-in light style three
    ///</summary>
    SlicerStyleLight3 = 2;
    ///<summary>
    ///  built-in light style four
    ///</summary>
    SlicerStyleLight4 = 3;
    ///<summary>
    ///  built-in light style five
    ///</summary>
    SlicerStyleLight5 = 4;
    ///<summary>
    ///  built-in light style six
    ///</summary>
    SlicerStyleLight6 = 5;
    ///<summary>
    ///  built-in style other one
    ///</summary>
    SlicerStyleOther1 = 6;
    ///<summary>
    ///  built-in style other two
    ///</summary>
    SlicerStyleOther2 = 7;
    ///<summary>
    ///  built-in dark style one
    ///</summary>
    SlicerStyleDark1 = 8;
    ///<summary>
    ///  built-in dark style tow
    ///</summary>
    SlicerStyleDark2 = 9;
    ///<summary>
    ///  built-in dark style three
    ///</summary>
    SlicerStyleDark3 = 10;
    ///<summary>
    ///  built-in dark style four
    ///</summary>
    SlicerStyleDark4 = 11;
    ///<summary>
    ///  built-in dark style five
    ///</summary>
    SlicerStyleDark5 = 12;
    ///<summary>
    ///  built-in dark style six
    ///</summary>
    SlicerStyleDark6 = 13;
    ///<summary>
    ///  user-defined style, unsupported for now
    ///</summary>
    ///<remarks>unsupported</remarks>
    Custom = 14;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Sorted value type.
  ///</summary>
  [DNTypeName('Aspose.Cells.SortOnType')]
  DNSortOnType = type Integer;
  DNSortOnTypeHelper = record helper for DNSortOnType
  public const
    ///<summary>
    ///  Sorts by cells' value.
    ///</summary>
    Value = 0;
    ///<summary>
    ///  Sorts by cells' color.
    ///</summary>
    CellColor = 1;
    ///<summary>
    ///  Sorts by cells' font color.
    ///</summary>
    FontColor = 2;
    ///<summary>
    ///  Sorts by conditional icon.
    ///</summary>
    Icon = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents sort order for the data range.
  ///</summary>
  [DNTypeName('Aspose.Cells.SortOrder')]
  DNSortOrder = type Integer;
  DNSortOrderHelper = record helper for DNSortOrder
  public const
    ///<summary></summary>
    Ascending = 0;
    ///<summary></summary>
    Descending = 1;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  The style modified flags.
  ///</summary>
  [DNTypeName('Aspose.Cells.StyleModifyFlag')]
  DNStyleModifyFlag = type Integer;
  DNStyleModifyFlagHelper = record helper for DNStyleModifyFlag
  public const
    ///<summary></summary>
    All = 0;
    ///<summary></summary>
    Borders = 1;
    ///<summary></summary>
    LeftBorder = 2;
    ///<summary></summary>
    RightBorder = 3;
    ///<summary></summary>
    TopBorder = 4;
    ///<summary></summary>
    BottomBorder = 5;
    ///<summary>
    ///  Only for dynamic style,such as conditional formatting.
    ///</summary>
    HorizontalBorder = 6;
    ///<summary>
    ///  Only for dynamic style,such as conditional formatting.
    ///</summary>
    VerticalBorder = 7;
    ///<summary></summary>
    Diagonal = 8;
    ///<summary></summary>
    DiagonalDownBorder = 9;
    ///<summary></summary>
    DiagonalUpBorder = 10;
    ///<summary></summary>
    Font = 11;
    ///<summary></summary>
    FontSize = 12;
    ///<summary></summary>
    FontName = 13;
    ///<summary></summary>
    FontFamily = 14;
    ///<summary></summary>
    FontCharset = 15;
    ///<summary></summary>
    FontColor = 16;
    ///<summary></summary>
    FontWeight = 17;
    ///<summary></summary>
    FontItalic = 18;
    ///<summary></summary>
    FontUnderline = 19;
    ///<summary></summary>
    FontStrike = 20;
    ///<summary></summary>
    ///<remarks>NOTE: This member is now obsolete. Instead, please use FontScript.
    ///  This property will be removed 12 months later since August 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    FontSubscript = 21;
    ///<summary></summary>
    ///<summary></summary>
    ///<remarks>NOTE: This member is now obsolete. Instead, please use FontScript.
    ///  This property will be removed 12 months later since August 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    FontSuperscript = 22;
    ///<summary></summary>
    FontScript = 23;
    ///<summary></summary>
    NumberFormat = 24;
    ///<summary></summary>
    HorizontalAlignment = 25;
    ///<summary></summary>
    VerticalAlignment = 26;
    ///<summary></summary>
    Indent = 27;
    ///<summary></summary>
    Rotation = 28;
    ///<summary></summary>
    WrapText = 29;
    ///<summary></summary>
    ShrinkToFit = 30;
    ///<summary></summary>
    TextDirection = 31;
    ///<summary></summary>
    CellShading = 32;
    ///<summary></summary>
    Pattern = 33;
    ///<summary></summary>
    ForegroundColor = 34;
    ///<summary></summary>
    BackgroundColor = 35;
    ///<summary></summary>
    Locked = 36;
    ///<summary></summary>
    HideFormula = 37;
    ///<summary>
    ///  Includes horizontal/vertical Alignment, rotation,wrap Text,indent,shrinkToFit,Text Direction
    ///</summary>
    AlignmentSettings = 38;
    ///<summary>
    ///  Includes Locked,  HideFormula
    ///</summary>
    ProtectionSettings = 39;
    ///<summary>
    ///  unused.
    ///</summary>
    FontScheme = 40;
    ///<summary>
    ///  unused.
    ///</summary>
    FontDirty = 41;
    ///<summary>
    ///  unused.
    ///</summary>
    FontSpellingError = 42;
    ///<summary>
    ///  unused.
    ///</summary>
    FontUFillTx = 43;
    ///<summary>
    ///  unused.
    ///</summary>
    FontSpacing = 44;
    ///<summary>
    ///  unused.
    ///</summary>
    FontKerning = 45;
    ///<summary>
    ///  unused.
    ///</summary>
    FontEqualize = 46;
    ///<summary>
    ///  unused.
    ///</summary>
    FontCap = 47;
    ///<summary></summary>
    RelativeIndent = 48;
  end;


  //-------------namespace: Aspose.Cells.Tables----------------
  ///<summary>
  ///  Represents the table's data source type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Tables.TableDataSourceType')]
  DNTableDataSourceType = type Integer;
  DNTableDataSourceTypeHelper = record helper for DNTableDataSourceType
  public const
    ///<summary>
    ///  Excel Worksheet Table
    ///</summary>
    Worksheet = 0;
    ///<summary>
    ///  Read-write SharePoint linked List
    ///</summary>
    SharePoint = 1;
    ///<summary>
    ///  XML mapper Table
    ///</summary>
    XML = 2;
    ///<summary>
    ///  Query Table
    ///</summary>
    QueryTable = 3;
  end;


  //-------------namespace: Aspose.Cells.Tables----------------
  ///<summary>
  ///  Represents the Table or PivotTable style element type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Tables.TableStyleElementType')]
  DNTableStyleElementType = type Integer;
  DNTableStyleElementTypeHelper = record helper for DNTableStyleElementType
  public const
    ///<summary>
    ///  Table style element that applies to table's entire content.
    ///</summary>
    WholeTable = 0;
    ///<summary>
    ///  Table style element that applies to pivot table's page field labels.
    ///</summary>
    PageFieldLabels = 1;
    ///<summary>
    ///  Table style element that applies to pivot table's page field values.
    ///</summary>
    PageFieldValues = 2;
    ///<summary>
    ///  Table style element that applies to table's first column stripes.
    ///</summary>
    FirstColumnStripe = 3;
    ///<summary>
    ///  Table style element that applies to table's second column stripes.
    ///</summary>
    SecondColumnStripe = 4;
    ///<summary>
    ///  Table style element that applies to table's first row stripes.
    ///</summary>
    FirstRowStripe = 5;
    ///<summary>
    ///  Table style element that applies to table's second row stripes.
    ///</summary>
    SecondRowStripe = 6;
    ///<summary>
    ///  Table style element that applies to table's last column.
    ///</summary>
    LastColumn = 7;
    ///<summary>
    ///  Table style element that applies to table's first column.
    ///</summary>
    FirstColumn = 8;
    ///<summary>
    ///  Table style element that applies to table's header row.
    ///</summary>
    HeaderRow = 9;
    ///<summary>
    ///  Table style element that applies to table's total row.
    ///</summary>
    TotalRow = 10;
    ///<summary>
    ///  Table style element that applies to table's first header row cell.
    ///</summary>
    FirstHeaderCell = 11;
    ///<summary>
    ///  Table style element that applies to table's last header row cell.
    ///</summary>
    LastHeaderCell = 12;
    ///<summary>
    ///  Table style element that applies to table's first total row cell.
    ///</summary>
    FirstTotalCell = 13;
    ///<summary>
    ///  Table style element that applies to table's last total row cell.
    ///</summary>
    LastTotalCell = 14;
    ///<summary>
    ///  Table style element that applies to PivotTable's first subtotal column.
    ///</summary>
    FirstSubtotalColumn = 15;
    ///<summary>
    ///  Table style element that applies to PivotTable's second subtotal column.
    ///</summary>
    SecondSubtotalColumn = 16;
    ///<summary>
    ///  Table style element that applies to pivot table's third subtotal column.
    ///</summary>
    ThirdSubtotalColumn = 17;
    ///<summary>
    ///  Table style element that applies to PivotTable's blank rows.
    ///</summary>
    BlankRow = 18;
    ///<summary>
    ///  Table style element that applies to pivot table's first subtotal row.
    ///</summary>
    FirstSubtotalRow = 19;
    ///<summary>
    ///  Table style element that applies to PivotTable's second subtotal row.
    ///</summary>
    SecondSubtotalRow = 20;
    ///<summary>
    ///  Table style element that applies to PivotTable's third subtotal row.
    ///</summary>
    ThirdSubtotalRow = 21;
    ///<summary>
    ///  Table style element that applies to PivotTable's first column subheading.
    ///</summary>
    FirstColumnSubheading = 22;
    ///<summary>
    ///  Table style element that applies to pivot table's second column subheading.
    ///</summary>
    SecondColumnSubheading = 23;
    ///<summary>
    ///  Table style element that applies to PivotTable's third column subheading.
    ///</summary>
    ThirdColumnSubheading = 24;
    ///<summary>
    ///  Table style element that applies to PivotTable's first row subheading.
    ///</summary>
    FirstRowSubheading = 25;
    ///<summary>
    ///  Table style element that applies to pivot table's second row subheading.
    ///</summary>
    SecondRowSubheading = 26;
    ///<summary>
    ///  Table style element that applies to PivotTable's third row subheading.
    ///</summary>
    ThirdRowSubheading = 27;
    ///<summary>
    ///  Table style element that applies to pivot table's grand total column.
    ///</summary>
    GrandTotalColumn = 28;
    ///<summary>
    ///  Table style element that applies to pivot table's grand total row.
    ///</summary>
    GrandTotalRow = 29;
  end;


  //-------------namespace: Aspose.Cells.Tables----------------
  ///<summary>
  ///  Represents the built-in table style type.
  ///</summary>
  [DNTypeName('Aspose.Cells.Tables.TableStyleType')]
  DNTableStyleType = type Integer;
  DNTableStyleTypeHelper = record helper for DNTableStyleType
  public const
    ///<summary></summary>
    None = 0;
    ///<summary></summary>
    TableStyleLight1 = 1;
    ///<summary></summary>
    TableStyleLight2 = 2;
    ///<summary></summary>
    TableStyleLight3 = 3;
    ///<summary></summary>
    TableStyleLight4 = 4;
    ///<summary></summary>
    TableStyleLight5 = 5;
    ///<summary></summary>
    TableStyleLight6 = 6;
    ///<summary></summary>
    TableStyleLight7 = 7;
    ///<summary></summary>
    TableStyleLight8 = 8;
    ///<summary></summary>
    TableStyleLight9 = 9;
    ///<summary></summary>
    TableStyleLight10 = 10;
    ///<summary></summary>
    TableStyleLight11 = 11;
    ///<summary></summary>
    TableStyleLight12 = 12;
    ///<summary></summary>
    TableStyleLight13 = 13;
    ///<summary></summary>
    TableStyleLight14 = 14;
    ///<summary></summary>
    TableStyleLight15 = 15;
    ///<summary></summary>
    TableStyleLight16 = 16;
    ///<summary></summary>
    TableStyleLight17 = 17;
    ///<summary></summary>
    TableStyleLight18 = 18;
    ///<summary></summary>
    TableStyleLight19 = 19;
    ///<summary></summary>
    TableStyleLight20 = 20;
    ///<summary></summary>
    TableStyleLight21 = 21;
    ///<summary></summary>
    TableStyleMedium1 = 22;
    ///<summary></summary>
    TableStyleMedium2 = 23;
    ///<summary></summary>
    TableStyleMedium3 = 24;
    ///<summary></summary>
    TableStyleMedium4 = 25;
    ///<summary></summary>
    TableStyleMedium5 = 26;
    ///<summary></summary>
    TableStyleMedium6 = 27;
    ///<summary></summary>
    TableStyleMedium7 = 28;
    ///<summary></summary>
    TableStyleMedium8 = 29;
    ///<summary></summary>
    TableStyleMedium9 = 30;
    ///<summary></summary>
    TableStyleMedium10 = 31;
    ///<summary></summary>
    TableStyleMedium11 = 32;
    ///<summary></summary>
    TableStyleMedium12 = 33;
    ///<summary></summary>
    TableStyleMedium13 = 34;
    ///<summary></summary>
    TableStyleMedium14 = 35;
    ///<summary></summary>
    TableStyleMedium15 = 36;
    ///<summary></summary>
    TableStyleMedium16 = 37;
    ///<summary></summary>
    TableStyleMedium17 = 38;
    ///<summary></summary>
    TableStyleMedium18 = 39;
    ///<summary></summary>
    TableStyleMedium19 = 40;
    ///<summary></summary>
    TableStyleMedium20 = 41;
    ///<summary></summary>
    TableStyleMedium21 = 42;
    ///<summary></summary>
    TableStyleMedium22 = 43;
    ///<summary></summary>
    TableStyleMedium23 = 44;
    ///<summary></summary>
    TableStyleMedium24 = 45;
    ///<summary></summary>
    TableStyleMedium25 = 46;
    ///<summary></summary>
    TableStyleMedium26 = 47;
    ///<summary></summary>
    TableStyleMedium27 = 48;
    ///<summary></summary>
    TableStyleMedium28 = 49;
    ///<summary></summary>
    TableStyleDark1 = 50;
    ///<summary></summary>
    TableStyleDark2 = 51;
    ///<summary></summary>
    TableStyleDark3 = 52;
    ///<summary></summary>
    TableStyleDark4 = 53;
    ///<summary></summary>
    TableStyleDark5 = 54;
    ///<summary></summary>
    TableStyleDark6 = 55;
    ///<summary></summary>
    TableStyleDark7 = 56;
    ///<summary></summary>
    TableStyleDark8 = 57;
    ///<summary></summary>
    TableStyleDark9 = 58;
    ///<summary></summary>
    TableStyleDark10 = 59;
    ///<summary></summary>
    TableStyleDark11 = 60;
    ///<summary></summary>
    Custom = 61;
  end;


  //-------------namespace: Aspose.Cells.Tables----------------
  ///<summary>
  ///  Determines the type of calculation in the Totals row of the list column.
  ///</summary>
  [DNTypeName('Aspose.Cells.Tables.TotalsCalculation')]
  DNTotalsCalculation = type Integer;
  DNTotalsCalculationHelper = record helper for DNTotalsCalculation
  public const
    ///<summary>
    ///  Represents No totals calculation.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Represents Average totals calculation.
    ///</summary>
    Average = 1;
    ///<summary>
    ///  Represents Count totals calculation.
    ///</summary>
    Count = 2;
    ///<summary>
    ///  Represents Count Nums totals calculation.
    ///</summary>
    CountNums = 3;
    ///<summary>
    ///  Represents Max totals calculation.
    ///</summary>
    Max = 4;
    ///<summary>
    ///  Represents Min totals calculation.
    ///</summary>
    Min = 5;
    ///<summary>
    ///  Represents Sum totals calculation.
    ///</summary>
    Sum = 6;
    ///<summary>
    ///  Represents StdDev totals calculation.
    ///</summary>
    StdDev = 7;
    ///<summary>
    ///  Represents Var totals calculation.
    ///</summary>
    Var_ = 8;
    ///<summary>
    ///  Represents custom calculation.
    ///</summary>
    Custom = 9;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the type of target mode.
  ///</summary>
  [DNTypeName('Aspose.Cells.TargetModeType')]
  DNTargetModeType = type Integer;
  DNTargetModeTypeHelper = record helper for DNTargetModeType
  public const
    ///<summary>
    ///  External link
    ///</summary>
    External_ = 0;
    ///<summary>
    ///  Local and full paths to files or folders.
    ///</summary>
    FilePath = 1;
    ///<summary>
    ///  Email.
    ///</summary>
    Email = 2;
    ///<summary>
    ///  Link on cell or named range.
    ///</summary>
    CellReference = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates text alignment types.
  ///</summary>
  [DNTypeName('Aspose.Cells.TextAlignmentType')]
  DNTextAlignmentType = type Integer;
  DNTextAlignmentTypeHelper = record helper for DNTextAlignmentType
  public const
    ///<summary>
    ///  Represents bottom text alignment.
    ///</summary>
    Bottom = 0;
    ///<summary>
    ///  Represents center text alignment.
    ///</summary>
    Center = 1;
    ///<summary>
    ///  Represents center across text alignment.
    ///</summary>
    CenterAcross = 2;
    ///<summary>
    ///  Represents distributed text alignment.
    ///</summary>
    Distributed = 3;
    ///<summary>
    ///  Represents fill text alignment.
    ///</summary>
    Fill = 4;
    ///<summary>
    ///  Represents general text alignment.
    ///</summary>
    General = 5;
    ///<summary>
    ///  Represents justify text alignment.
    ///</summary>
    Justify = 6;
    ///<summary>
    ///  Represents left text alignment.
    ///</summary>
    Left = 7;
    ///<summary>
    ///  Represents right text alignment.
    ///</summary>
    Right = 8;
    ///<summary>
    ///  Represents top text alignment.
    ///</summary>
    Top = 9;
    ///<summary>
    ///  Aligns the text with an adjusted kashida length for Arabic text.
    ///</summary>
    JustifiedLow = 10;
    ///<summary>
    ///  Distributes Thai text specially, because each character is treated as a word.
    ///</summary>
    ThaiDistributed = 11;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  This type specifies the cap types of the text.
  ///</summary>
  [DNTypeName('Aspose.Cells.TextCapsType')]
  DNTextCapsType = type Integer;
  DNTextCapsTypeHelper = record helper for DNTextCapsType
  public const
    ///<summary>
    ///  None caps
    ///</summary>
    None = 0;
    ///<summary>
    ///  Apply all caps on the text.
    ///</summary>
    All = 1;
    ///<summary>
    ///  Apply small caps to the text.
    ///</summary>
    Small = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates displaying text type when the text width is larger than cell width.
  ///</summary>
  [DNTypeName('Aspose.Cells.TextCrossType')]
  DNTextCrossType = type Integer;
  DNTextCrossTypeHelper = record helper for DNTextCrossType
  public const
    ///<summary>
    ///  Display text like in Microsoft Excel.
    ///</summary>
    Default_ = 1;
    ///<summary>
    ///  Display all the text by crossing other cells and keep text of crossed cells.
    ///</summary>
    CrossKeep = 2;
    ///<summary>
    ///  Display all the text by crossing other cells and override text of crossed cells.
    ///</summary>
    CrossOverride = 3;
    ///<summary>
    ///  Only display the text within the width of cell.
    ///</summary>
    StrictInCell = 4;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the direction of the text flow for this paragraph.
  ///</summary>
  [DNTypeName('Aspose.Cells.TextDirectionType')]
  DNTextDirectionType = type Integer;
  DNTextDirectionTypeHelper = record helper for DNTextDirectionType
  public const
    ///<summary></summary>
    Context = 0;
    ///<summary></summary>
    LeftToRight = 1;
    ///<summary></summary>
    RightToLeft = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates text orientation types.
  ///</summary>
  [DNTypeName('Aspose.Cells.TextOrientationType')]
  DNTextOrientationType = type Integer;
  DNTextOrientationTypeHelper = record helper for DNTextOrientationType
  public const
    ///<summary>
    ///  Rotates text with 90 degrees clockwise.
    ///</summary>
    ClockWise = 0;
    ///<summary>
    ///  Rotates text with 90 degrees counterclockwise.
    ///</summary>
    CounterClockWise = 1;
    ///<summary>
    ///  Represents the default value.
    ///</summary>
    NoRotation = 2;
    ///<summary>
    ///  Displays text from top to bottom of the cell. Stacked text.
    ///</summary>
    TopToBottom = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  This type specifies the strike type.
  ///</summary>
  [DNTypeName('Aspose.Cells.TextStrikeType')]
  DNTextStrikeType = type Integer;
  DNTextStrikeTypeHelper = record helper for DNTextStrikeType
  public const
    ///<summary>
    ///  A single strikethrough applied on the text.
    ///</summary>
    Single = 0;
    ///<summary>
    ///  A double strikethrough applied on the text.
    ///</summary>
    Double = 1;
    ///<summary>
    ///  No strike is applied to the text.
    ///</summary>
    None = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Enumerates  the theme color types.
  ///</summary>
  [DNTypeName('Aspose.Cells.ThemeColorType')]
  DNThemeColorType = type Integer;
  DNThemeColorTypeHelper = record helper for DNThemeColorType
  public const
    ///<summary></summary>
    Background1 = 0;
    ///<summary></summary>
    Text1 = 1;
    ///<summary></summary>
    Background2 = 2;
    ///<summary></summary>
    Text2 = 3;
    ///<summary></summary>
    Accent1 = 4;
    ///<summary></summary>
    Accent2 = 5;
    ///<summary></summary>
    Accent3 = 6;
    ///<summary></summary>
    Accent4 = 7;
    ///<summary></summary>
    Accent5 = 8;
    ///<summary></summary>
    Accent6 = 9;
    ///<summary></summary>
    Hyperlink = 10;
    ///<summary></summary>
    FollowedHyperlink = 11;
    ///<summary>
    ///  Inner used.
    ///  A color used in theme definitions which means to use the color of the style.
    ///</summary>
    StyleColor = 12;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Used in a FormatConditionType.TimePeriod conditional formatting rule.
  ///  These are dynamic time periods, which change based on
  ///  the date the conditional formatting is refreshed / applied.
  ///</summary>
  [DNTypeName('Aspose.Cells.TimePeriodType')]
  DNTimePeriodType = type Integer;
  DNTimePeriodTypeHelper = record helper for DNTimePeriodType
  public const
    ///<summary>
    ///  Today's date.
    ///</summary>
    Today = 0;
    ///<summary>
    ///  Yesterday's date.
    ///</summary>
    Yesterday = 1;
    ///<summary>
    ///  Tomorrow's date.
    ///</summary>
    Tomorrow = 2;
    ///<summary>
    ///  A date in the last seven days.
    ///</summary>
    Last7Days = 3;
    ///<summary>
    ///  A date occurring in this calendar month.
    ///</summary>
    ThisMonth = 4;
    ///<summary>
    ///  A date occurring in the last calendar month.
    ///</summary>
    LastMonth = 5;
    ///<summary>
    ///  A date occurring in the next calendar month.
    ///</summary>
    NextMonth = 6;
    ///<summary>
    ///  A date occurring this week.
    ///</summary>
    ThisWeek = 7;
    ///<summary>
    ///  A date occurring last week.
    ///</summary>
    LastWeek = 8;
    ///<summary>
    ///  A date occurring next week.
    ///</summary>
    NextWeek = 9;
    ///<summary>
    ///  A date occurring this year.
    ///  Only for .ods.
    ///</summary>
    ThisYear = 10;
    ///<summary>
    ///  A date occurring last year.
    ///  Only for .ods.
    ///</summary>
    LastYear = 11;
    ///<summary>
    ///  A date occurring next year.
    ///  Only for .ods.
    ///</summary>
    NextYear = 12;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies how to apply style for parsed values when converting string value to number or datetime.
  ///</summary>
  [DNTypeName('Aspose.Cells.TxtLoadStyleStrategy')]
  DNTxtLoadStyleStrategy = type Integer;
  DNTxtLoadStyleStrategyHelper = record helper for DNTxtLoadStyleStrategy
  public const
    ///<summary>
    ///  Does not set style for the parsed value.
    ///</summary>
    None = 0;
    ///<summary>
    ///  Set the style as built-in number/datetime when the parsed value are plain numeric/datetime values.
    ///</summary>
    ///<remarks>
    ///  When ms excel parsing datetime or numeric values according to user's input(such as CSV file),
    ///  the formatting of those values may be changed, such as
    ///  leading/tailing zeros of number, year/month/day order of datetime, ...etc.
    ///  This type is for simulating ms excel's behavior.
    ///</remarks>
    BuiltIn = 1;
    ///<summary>
    ///  Set the exact custom format for the parsed value to make the formatted value be same with the original input one.
    ///</summary>
    ExactFormat = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Specifies the type of using quotation marks for values in text format files.
  ///</summary>
  [DNTypeName('Aspose.Cells.TxtValueQuoteType')]
  DNTxtValueQuoteType = type Integer;
  DNTxtValueQuoteTypeHelper = record helper for DNTxtValueQuoteType
  public const
    ///<summary>
    ///  All values that contain special characters such as quotation mark, separator character will be quoted.
    ///  Same with the behavior of ms excel for exporting text file.
    ///</summary>
    Normal = 0;
    ///<summary>
    ///  All values will be quoted always.
    ///</summary>
    Always = 1;
    ///<summary>
    ///  Only quote values when needed. Such as, if one value contains quotation mark but the quotation mark is not at the begin of this value, this value will not be quoted.
    ///</summary>
    Minimum = 2;
    ///<summary>
    ///  All values will not be quoted. The exported text file with this type may not be read back correctly because the needed quotation marks being absent.
    ///</summary>
    Never = 3;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents how to update links to other workbooks when the workbook is opened.
  ///</summary>
  [DNTypeName('Aspose.Cells.UpdateLinksType')]
  DNUpdateLinksType = type Integer;
  DNUpdateLinksTypeHelper = record helper for DNUpdateLinksType
  public const
    ///<summary>
    ///  Prompt user to update.
    ///</summary>
    UserSet = 0;
    ///<summary>
    ///  Do not update, and do not prompt user.
    ///</summary>
    Never = 1;
    ///<summary>
    ///  Always update.
    ///</summary>
    Always = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the data validation alert style.
  ///</summary>
  [DNTypeName('Aspose.Cells.ValidationAlertType')]
  DNValidationAlertType = type Integer;
  DNValidationAlertTypeHelper = record helper for DNValidationAlertType
  public const
    ///<summary>
    ///  Information alert style.
    ///</summary>
    Information = 0;
    ///<summary>
    ///  Stop alert style.
    ///</summary>
    Stop = 1;
    ///<summary>
    ///  Warning alert style.
    ///</summary>
    Warning = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents data validation type.
  ///</summary>
  [DNTypeName('Aspose.Cells.ValidationType')]
  DNValidationType = type Integer;
  DNValidationTypeHelper = record helper for DNValidationType
  public const
    ///<summary>
    ///  Any value validation type.
    ///</summary>
    AnyValue = 0;
    ///<summary>
    ///  Whole number validation type.
    ///</summary>
    WholeNumber = 1;
    ///<summary>
    ///  Decimal validation type.
    ///</summary>
    Decimal = 2;
    ///<summary>
    ///  List validation type.
    ///</summary>
    List = 3;
    ///<summary>
    ///  Date validation type.
    ///</summary>
    Date = 4;
    ///<summary>
    ///  Time validation type.
    ///</summary>
    Time = 5;
    ///<summary>
    ///  Text length validation type.
    ///</summary>
    TextLength = 6;
    ///<summary>
    ///  Custom validation type.
    ///</summary>
    Custom = 7;
  end;


  //-------------namespace: Aspose.Cells.Vba----------------
  ///<summary>
  ///  Represents the type of VBA module.
  ///</summary>
  [DNTypeName('Aspose.Cells.Vba.VbaModuleType')]
  DNVbaModuleType = type Integer;
  DNVbaModuleTypeHelper = record helper for DNVbaModuleType
  public const
    ///<summary>
    ///  Represents a procedural module.
    ///</summary>
    Procedural = 0;
    ///<summary>
    ///  Represents a document module.
    ///</summary>
    Document = 1;
    ///<summary>
    ///  Represents a class module.
    ///</summary>
    Class_ = 2;
    ///<summary>
    ///  Represents a designer module.
    ///</summary>
    Designer = 3;
  end;


  //-------------namespace: Aspose.Cells.Vba----------------
  ///<summary>
  ///  Represents the type of VBA project reference.
  ///</summary>
  [DNTypeName('Aspose.Cells.Vba.VbaProjectReferenceType')]
  DNVbaProjectReferenceType = type Integer;
  DNVbaProjectReferenceTypeHelper = record helper for DNVbaProjectReferenceType
  public const
    ///<summary>
    ///  Specifies a reference to an Automation type library.
    ///</summary>
    Registered = 0;
    ///<summary>
    ///  Specifies a reference to a twiddled type library and its extended type library.
    ///</summary>
    Control = 1;
    ///<summary>
    ///  Specifies a reference to an external VBA project.
    ///</summary>
    Project = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the view type of the worksheet.
  ///</summary>
  [DNTypeName('Aspose.Cells.ViewType')]
  DNViewType = type Integer;
  DNViewTypeHelper = record helper for DNViewType
  public const
    ///<summary></summary>
    NormalView = 0;
    ///<summary></summary>
    PageBreakPreview = 1;
    ///<summary></summary>
    PageLayoutView = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the states for sheet visibility.
  ///</summary>
  [DNTypeName('Aspose.Cells.VisibilityType')]
  DNVisibilityType = type Integer;
  DNVisibilityTypeHelper = record helper for DNVisibilityType
  public const
    ///<summary>
    ///  Indicates the sheet is visible.
    ///</summary>
    Visible = 0;
    ///<summary>
    ///  Indicates the sheet is hidden, but can be shown by the user via the user interface.
    ///</summary>
    Hidden = 1;
    ///<summary>
    ///  Indicates the sheet is hidden and cannot be shown in the user interface (UI).
    ///  This state is only available programmatically.
    ///</summary>
    VeryHidden = 2;
  end;


  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  WaringType
  ///</summary>
  [DNTypeName('Aspose.Cells.WarningType')]
  DNWarningType = type Integer;
  DNWarningTypeHelper = record helper for DNWarningType
  public const
    ///<summary>
    ///  Font substitution warning type
    ///  when a font has not been found, this warning type can be get.
    ///</summary>
    FontSubstitution = 0;
    ///<summary>
    ///  Duplicate defined name is found in the file.
    ///</summary>
    DuplicateDefinedName = 1;
    ///<summary>
    ///  Unsupported file format.
    ///</summary>
    UnsupportedFileFormat = 2;
    ///<summary>
    ///  Invalid text of the defined name.
    ///</summary>
    InvalidTextOfDefinedName = 3;
    ///<summary>
    ///  Invalid the font name.
    ///</summary>
    InvalidFontName = 4;
    ///<summary>
    ///  Invalid autofilter range.
    ///</summary>
    InvalidAutoFilterRange = 5;
  end;


  //-------------namespace: Aspose.Cells.WebExtensions----------------
  ///<summary>
  ///  Represents the store type of web extension.
  ///</summary>
  [DNTypeName('Aspose.Cells.WebExtensions.WebExtensionStoreType')]
  DNWebExtensionStoreType = type Integer;
  DNWebExtensionStoreTypeHelper = record helper for DNWebExtensionStoreType
  public const
    ///<summary>
    ///  Specifies that the store type is Office.com.
    ///</summary>
    OMEX = 0;
    ///<summary>
    ///  Specifies that the store type is SharePoint corporate catalog.
    ///</summary>
    SPCatalog = 1;
    ///<summary>
    ///  Specifies that the store type is a SharePoint web application.
    ///</summary>
    SPApp = 2;
    ///<summary>
    ///  Specifies that the store type is an Exchange server.
    ///</summary>
    Exchange = 3;
    ///<summary>
    ///  Specifies that the store type is a file system share.
    ///</summary>
    FileSystem = 4;
    ///<summary>
    ///  Specifies that the store type is the system registry.
    ///</summary>
    Registry = 5;
    ///<summary>
    ///  Specifies that the store type is Centralized Deployment via Exchange.
    ///</summary>
    ExCatalog = 6;
  end;




type


{ declares }

  DNICellsDataTable = interface; // type: Aspose.Cells.ICellsDataTable, namespace: Aspose.Cells
  DNICustomFunction = interface; // type: Aspose.Cells.ICustomFunction, namespace: Aspose.Cells
  DNICustomParser = interface; // type: Aspose.Cells.ICustomParser, namespace: Aspose.Cells
  DNIExportObjectListener = interface; // type: Aspose.Cells.IExportObjectListener, namespace: Aspose.Cells
  DNIFilePathProvider = interface; // type: Aspose.Cells.IFilePathProvider, namespace: Aspose.Cells
  DNISmartMarkerCallBack = interface; // type: Aspose.Cells.ISmartMarkerCallBack, namespace: Aspose.Cells
  DNIStreamProvider = interface; // type: Aspose.Cells.IStreamProvider, namespace: Aspose.Cells
  DNIWarningCallback = interface; // type: Aspose.Cells.IWarningCallback, namespace: Aspose.Cells
  DNLightCellsDataHandler = interface; // type: Aspose.Cells.LightCellsDataHandler, namespace: Aspose.Cells
  DNLightCellsDataProvider = interface; // type: Aspose.Cells.LightCellsDataProvider, namespace: Aspose.Cells
  DNIPageSavingCallback = interface; // type: Aspose.Cells.Rendering.IPageSavingCallback, namespace: Aspose.Cells.Rendering
  DNAboveAverage = interface; // type: Aspose.Cells.AboveAverage, namespace: Aspose.Cells
  DNAbstractCalculationEngine = interface; // type: Aspose.Cells.AbstractCalculationEngine, namespace: Aspose.Cells
  DNAbstractCalculationMonitor = interface; // type: Aspose.Cells.AbstractCalculationMonitor, namespace: Aspose.Cells
  DNAutoFilter = interface; // type: Aspose.Cells.AutoFilter, namespace: Aspose.Cells
  DNAutoFitterOptions = interface; // type: Aspose.Cells.AutoFitterOptions, namespace: Aspose.Cells
  DNBorder = interface; // type: Aspose.Cells.Border, namespace: Aspose.Cells
  DNBorderCollection = interface; // type: Aspose.Cells.BorderCollection, namespace: Aspose.Cells
  DNCalculationCell = interface; // type: Aspose.Cells.CalculationCell, namespace: Aspose.Cells
  DNCalculationData = interface; // type: Aspose.Cells.CalculationData, namespace: Aspose.Cells
  DNCalculationOptions = interface; // type: Aspose.Cells.CalculationOptions, namespace: Aspose.Cells
  DNCell = interface; // type: Aspose.Cells.Cell, namespace: Aspose.Cells
  DNCells = interface; // type: Aspose.Cells.Cells, namespace: Aspose.Cells
  DNCellsColor = interface; // type: Aspose.Cells.CellsColor, namespace: Aspose.Cells
  DNCellsFactory = interface; // type: Aspose.Cells.CellsFactory, namespace: Aspose.Cells
  DNCellsHelper = interface; // type: Aspose.Cells.CellsHelper, namespace: Aspose.Cells
  DNCellWatch = interface; // type: Aspose.Cells.CellWatch, namespace: Aspose.Cells
  DNAxis = interface; // type: Aspose.Cells.Charts.Axis, namespace: Aspose.Cells.Charts
  DNChart = interface; // type: Aspose.Cells.Charts.Chart, namespace: Aspose.Cells.Charts
  DNChartDataTable = interface; // type: Aspose.Cells.Charts.ChartDataTable, namespace: Aspose.Cells.Charts
  DNChartFrame = interface; // type: Aspose.Cells.Charts.ChartFrame, namespace: Aspose.Cells.Charts
  DNChartArea = interface; // type: Aspose.Cells.Charts.ChartArea, namespace: Aspose.Cells.Charts
  DNChartTextFrame = interface; // type: Aspose.Cells.Charts.ChartTextFrame, namespace: Aspose.Cells.Charts
  DNDataLabels = interface; // type: Aspose.Cells.Charts.DataLabels, namespace: Aspose.Cells.Charts
  DNDisplayUnitLabel = interface; // type: Aspose.Cells.Charts.DisplayUnitLabel, namespace: Aspose.Cells.Charts
  DNLegend = interface; // type: Aspose.Cells.Charts.Legend, namespace: Aspose.Cells.Charts
  DNTitle = interface; // type: Aspose.Cells.Charts.Title, namespace: Aspose.Cells.Charts
  DNPlotArea = interface; // type: Aspose.Cells.Charts.PlotArea, namespace: Aspose.Cells.Charts
  DNChartPoint = interface; // type: Aspose.Cells.Charts.ChartPoint, namespace: Aspose.Cells.Charts
  DNChartPointCollection = interface; // type: Aspose.Cells.Charts.ChartPointCollection, namespace: Aspose.Cells.Charts
  DNDropBars = interface; // type: Aspose.Cells.Charts.DropBars, namespace: Aspose.Cells.Charts
  DNLegendEntry = interface; // type: Aspose.Cells.Charts.LegendEntry, namespace: Aspose.Cells.Charts
  DNMarker = interface; // type: Aspose.Cells.Charts.Marker, namespace: Aspose.Cells.Charts
  DNPivotOptions = interface; // type: Aspose.Cells.Charts.PivotOptions, namespace: Aspose.Cells.Charts
  DNSeries = interface; // type: Aspose.Cells.Charts.Series, namespace: Aspose.Cells.Charts
  DNSeriesLayoutProperties = interface; // type: Aspose.Cells.Charts.SeriesLayoutProperties, namespace: Aspose.Cells.Charts
  DNSparkline = interface; // type: Aspose.Cells.Charts.Sparkline, namespace: Aspose.Cells.Charts
  DNSparklineGroup = interface; // type: Aspose.Cells.Charts.SparklineGroup, namespace: Aspose.Cells.Charts
  DNTickLabels = interface; // type: Aspose.Cells.Charts.TickLabels, namespace: Aspose.Cells.Charts
  DNCellWatchCollection = interface; // type: Aspose.Cells.CellWatchCollection, namespace: Aspose.Cells
  DNChartCollection = interface; // type: Aspose.Cells.Charts.ChartCollection, namespace: Aspose.Cells.Charts
  DNLegendEntryCollection = interface; // type: Aspose.Cells.Charts.LegendEntryCollection, namespace: Aspose.Cells.Charts
  DNSeriesCollection = interface; // type: Aspose.Cells.Charts.SeriesCollection, namespace: Aspose.Cells.Charts
  DNSparklineCollection = interface; // type: Aspose.Cells.Charts.SparklineCollection, namespace: Aspose.Cells.Charts
  DNSparklineGroupCollection = interface; // type: Aspose.Cells.Charts.SparklineGroupCollection, namespace: Aspose.Cells.Charts
  DNTrendlineCollection = interface; // type: Aspose.Cells.Charts.TrendlineCollection, namespace: Aspose.Cells.Charts
  DNColumnCollection = interface; // type: Aspose.Cells.ColumnCollection, namespace: Aspose.Cells
  DNCommentCollection = interface; // type: Aspose.Cells.CommentCollection, namespace: Aspose.Cells
  DNConditionalFormattingIconCollection = interface; // type: Aspose.Cells.ConditionalFormattingIconCollection, namespace: Aspose.Cells
  DNConditionalFormattingValueCollection = interface; // type: Aspose.Cells.ConditionalFormattingValueCollection, namespace: Aspose.Cells
  DNCustomFilterCollection = interface; // type: Aspose.Cells.CustomFilterCollection, namespace: Aspose.Cells
  DNDataSorterKeyCollection = interface; // type: Aspose.Cells.DataSorterKeyCollection, namespace: Aspose.Cells
  DNCheckBoxCollection = interface; // type: Aspose.Cells.Drawing.CheckBoxCollection, namespace: Aspose.Cells.Drawing
  DNGradientStopCollection = interface; // type: Aspose.Cells.Drawing.GradientStopCollection, namespace: Aspose.Cells.Drawing
  DNOleObjectCollection = interface; // type: Aspose.Cells.Drawing.OleObjectCollection, namespace: Aspose.Cells.Drawing
  DNPictureCollection = interface; // type: Aspose.Cells.Drawing.PictureCollection, namespace: Aspose.Cells.Drawing
  DNShapeCollection = interface; // type: Aspose.Cells.Drawing.ShapeCollection, namespace: Aspose.Cells.Drawing
  DNShapeGuideCollection = interface; // type: Aspose.Cells.Drawing.ShapeGuideCollection, namespace: Aspose.Cells.Drawing
  DNShapePathCollection = interface; // type: Aspose.Cells.Drawing.ShapePathCollection, namespace: Aspose.Cells.Drawing
  DNShapePathPointCollection = interface; // type: Aspose.Cells.Drawing.ShapePathPointCollection, namespace: Aspose.Cells.Drawing
  DNShapeSegmentPathCollection = interface; // type: Aspose.Cells.Drawing.ShapeSegmentPathCollection, namespace: Aspose.Cells.Drawing
  DNTextBoxCollection = interface; // type: Aspose.Cells.Drawing.TextBoxCollection, namespace: Aspose.Cells.Drawing
  DNTextTabStopCollection = interface; // type: Aspose.Cells.Drawing.Texts.TextTabStopCollection, namespace: Aspose.Cells.Drawing.Texts
  DNErrorCheckOptionCollection = interface; // type: Aspose.Cells.ErrorCheckOptionCollection, namespace: Aspose.Cells
  DNConnectionParameterCollection = interface; // type: Aspose.Cells.ExternalConnections.ConnectionParameterCollection, namespace: Aspose.Cells.ExternalConnections
  DNExternalConnectionCollection = interface; // type: Aspose.Cells.ExternalConnections.ExternalConnectionCollection, namespace: Aspose.Cells.ExternalConnections
  DNFilterColumnCollection = interface; // type: Aspose.Cells.FilterColumnCollection, namespace: Aspose.Cells
  DNFontSettingCollection = interface; // type: Aspose.Cells.Drawing.Texts.FontSettingCollection, namespace: Aspose.Cells.Drawing.Texts
  DNConditionalFormattingCollection = interface; // type: Aspose.Cells.ConditionalFormattingCollection, namespace: Aspose.Cells
  DNHorizontalPageBreakCollection = interface; // type: Aspose.Cells.HorizontalPageBreakCollection, namespace: Aspose.Cells
  DNHyperlinkCollection = interface; // type: Aspose.Cells.HyperlinkCollection, namespace: Aspose.Cells
  DNCustomXmlPartCollection = interface; // type: Aspose.Cells.Markup.CustomXmlPartCollection, namespace: Aspose.Cells.Markup
  DNSmartTagCollection = interface; // type: Aspose.Cells.Markup.SmartTagCollection, namespace: Aspose.Cells.Markup
  DNSmartTagPropertyCollection = interface; // type: Aspose.Cells.Markup.SmartTagPropertyCollection, namespace: Aspose.Cells.Markup
  DNNameCollection = interface; // type: Aspose.Cells.NameCollection, namespace: Aspose.Cells
  DNOdsCellFieldCollection = interface; // type: Aspose.Cells.Ods.OdsCellFieldCollection, namespace: Aspose.Cells.Ods
  DNPivotFilterCollection = interface; // type: Aspose.Cells.Pivot.PivotFilterCollection, namespace: Aspose.Cells.Pivot
  DNPivotFormatConditionCollection = interface; // type: Aspose.Cells.Pivot.PivotFormatConditionCollection, namespace: Aspose.Cells.Pivot
  DNPivotTableCollection = interface; // type: Aspose.Cells.Pivot.PivotTableCollection, namespace: Aspose.Cells.Pivot
  DNContentTypePropertyCollection = interface; // type: Aspose.Cells.Properties.ContentTypePropertyCollection, namespace: Aspose.Cells.Properties
  DNCustomPropertyCollection = interface; // type: Aspose.Cells.Properties.CustomPropertyCollection, namespace: Aspose.Cells.Properties
  DNProtectedRangeCollection = interface; // type: Aspose.Cells.ProtectedRangeCollection, namespace: Aspose.Cells
  DNQueryTableCollection = interface; // type: Aspose.Cells.QueryTableCollection, namespace: Aspose.Cells
  DNPowerQueryFormulaCollction = interface; // type: Aspose.Cells.QueryTables.PowerQueryFormulaCollction, namespace: Aspose.Cells.QueryTables
  DNPowerQueryFormulaItemCollection = interface; // type: Aspose.Cells.QueryTables.PowerQueryFormulaItemCollection, namespace: Aspose.Cells.QueryTables
  DNPowerQueryFormulaParameterCollection = interface; // type: Aspose.Cells.QueryTables.PowerQueryFormulaParameterCollection, namespace: Aspose.Cells.QueryTables
  DNRangeCollection = interface; // type: Aspose.Cells.RangeCollection, namespace: Aspose.Cells
  DNReferredAreaCollection = interface; // type: Aspose.Cells.ReferredAreaCollection, namespace: Aspose.Cells
  DNRevisionCollection = interface; // type: Aspose.Cells.Revisions.RevisionCollection, namespace: Aspose.Cells.Revisions
  DNRevisionLogCollection = interface; // type: Aspose.Cells.Revisions.RevisionLogCollection, namespace: Aspose.Cells.Revisions
  DNScenarioCollection = interface; // type: Aspose.Cells.ScenarioCollection, namespace: Aspose.Cells
  DNScenarioInputCellCollection = interface; // type: Aspose.Cells.ScenarioInputCellCollection, namespace: Aspose.Cells
  DNSlicerCollection = interface; // type: Aspose.Cells.Slicers.SlicerCollection, namespace: Aspose.Cells.Slicers
  DNSlicerCacheItemCollection = interface; // type: Aspose.Cells.Slicers.SlicerCacheItemCollection, namespace: Aspose.Cells.Slicers
  DNDxfCollection = interface; // type: Aspose.Cells.DxfCollection, namespace: Aspose.Cells
  DNListColumnCollection = interface; // type: Aspose.Cells.Tables.ListColumnCollection, namespace: Aspose.Cells.Tables
  DNListObjectCollection = interface; // type: Aspose.Cells.Tables.ListObjectCollection, namespace: Aspose.Cells.Tables
  DNTableStyleCollection = interface; // type: Aspose.Cells.Tables.TableStyleCollection, namespace: Aspose.Cells.Tables
  DNTableStyleElementCollection = interface; // type: Aspose.Cells.Tables.TableStyleElementCollection, namespace: Aspose.Cells.Tables
  DNThreadedCommentCollection = interface; // type: Aspose.Cells.ThreadedCommentCollection, namespace: Aspose.Cells
  DNThreadedCommentAuthorCollection = interface; // type: Aspose.Cells.ThreadedCommentAuthorCollection, namespace: Aspose.Cells
  DNValidationCollection = interface; // type: Aspose.Cells.ValidationCollection, namespace: Aspose.Cells
  DNVbaModuleCollection = interface; // type: Aspose.Cells.Vba.VbaModuleCollection, namespace: Aspose.Cells.Vba
  DNVbaProjectReferenceCollection = interface; // type: Aspose.Cells.Vba.VbaProjectReferenceCollection, namespace: Aspose.Cells.Vba
  DNVerticalPageBreakCollection = interface; // type: Aspose.Cells.VerticalPageBreakCollection, namespace: Aspose.Cells
  DNWebExtensionCollection = interface; // type: Aspose.Cells.WebExtensions.WebExtensionCollection, namespace: Aspose.Cells.WebExtensions
  DNWebExtensionBindingCollection = interface; // type: Aspose.Cells.WebExtensions.WebExtensionBindingCollection, namespace: Aspose.Cells.WebExtensions
  DNWebExtensionPropertyCollection = interface; // type: Aspose.Cells.WebExtensions.WebExtensionPropertyCollection, namespace: Aspose.Cells.WebExtensions
  DNWebExtensionReferenceCollection = interface; // type: Aspose.Cells.WebExtensions.WebExtensionReferenceCollection, namespace: Aspose.Cells.WebExtensions
  DNWebExtensionTaskPaneCollection = interface; // type: Aspose.Cells.WebExtensions.WebExtensionTaskPaneCollection, namespace: Aspose.Cells.WebExtensions
  DNWorksheetCollection = interface; // type: Aspose.Cells.WorksheetCollection, namespace: Aspose.Cells
  DNXmlMapCollection = interface; // type: Aspose.Cells.XmlMapCollection, namespace: Aspose.Cells
  DNCollectionBase<T> = interface; // type: Aspose.Cells.CollectionBase`1, namespace: Aspose.Cells
  DNColorFilter = interface; // type: Aspose.Cells.ColorFilter, namespace: Aspose.Cells
  DNColorScale = interface; // type: Aspose.Cells.ColorScale, namespace: Aspose.Cells
  DNColumn = interface; // type: Aspose.Cells.Column, namespace: Aspose.Cells
  DNComment = interface; // type: Aspose.Cells.Comment, namespace: Aspose.Cells
  DNConditionalFormattingIcon = interface; // type: Aspose.Cells.ConditionalFormattingIcon, namespace: Aspose.Cells
  DNConditionalFormattingResult = interface; // type: Aspose.Cells.ConditionalFormattingResult, namespace: Aspose.Cells
  DNConditionalFormattingValue = interface; // type: Aspose.Cells.ConditionalFormattingValue, namespace: Aspose.Cells
  DNCopyOptions = interface; // type: Aspose.Cells.CopyOptions, namespace: Aspose.Cells
  DNCustomFilter = interface; // type: Aspose.Cells.CustomFilter, namespace: Aspose.Cells
  DNCustomImplementationFactory = interface; // type: Aspose.Cells.CustomImplementationFactory, namespace: Aspose.Cells
  DNDataBar = interface; // type: Aspose.Cells.DataBar, namespace: Aspose.Cells
  DNDataBarBorder = interface; // type: Aspose.Cells.DataBarBorder, namespace: Aspose.Cells
  DNDataSorter = interface; // type: Aspose.Cells.DataSorter, namespace: Aspose.Cells
  DNDataSorterKey = interface; // type: Aspose.Cells.DataSorterKey, namespace: Aspose.Cells
  DNDateTimeGroupItem = interface; // type: Aspose.Cells.DateTimeGroupItem, namespace: Aspose.Cells
  DNDeleteOptions = interface; // type: Aspose.Cells.DeleteOptions, namespace: Aspose.Cells
  DNDigitalSignature = interface; // type: Aspose.Cells.DigitalSignatures.DigitalSignature, namespace: Aspose.Cells.DigitalSignatures
  DNDigitalSignatureCollection = interface; // type: Aspose.Cells.DigitalSignatures.DigitalSignatureCollection, namespace: Aspose.Cells.DigitalSignatures
  DNActiveXControlBase = interface; // type: Aspose.Cells.Drawing.ActiveXControls.ActiveXControlBase, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.ActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNCheckBoxActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.CheckBoxActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNComboBoxActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.ComboBoxActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNCommandButtonActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.CommandButtonActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNImageActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.ImageActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNLabelActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.LabelActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNListBoxActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.ListBoxActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNSpinButtonActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.SpinButtonActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNScrollBarActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.ScrollBarActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNTextBoxActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.TextBoxActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNToggleButtonActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.ToggleButtonActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNRadioButtonActiveXControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.RadioButtonActiveXControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNUnknownControl = interface; // type: Aspose.Cells.Drawing.ActiveXControls.UnknownControl, namespace: Aspose.Cells.Drawing.ActiveXControls
  DNArea = interface; // type: Aspose.Cells.Drawing.Area, namespace: Aspose.Cells.Drawing
  DNFloor = interface; // type: Aspose.Cells.Charts.Floor, namespace: Aspose.Cells.Charts
  DNWalls = interface; // type: Aspose.Cells.Charts.Walls, namespace: Aspose.Cells.Charts
  DNBevel = interface; // type: Aspose.Cells.Drawing.Bevel, namespace: Aspose.Cells.Drawing
  DNColorHelper = interface; // type: Aspose.Cells.Drawing.ColorHelper, namespace: Aspose.Cells.Drawing
  DNFill = interface; // type: Aspose.Cells.Drawing.Fill, namespace: Aspose.Cells.Drawing
  DNAutomaticFill = interface; // type: Aspose.Cells.Drawing.AutomaticFill, namespace: Aspose.Cells.Drawing
  DNGradientFill = interface; // type: Aspose.Cells.Drawing.GradientFill, namespace: Aspose.Cells.Drawing
  DNGroupFill = interface; // type: Aspose.Cells.Drawing.GroupFill, namespace: Aspose.Cells.Drawing
  DNNoneFill = interface; // type: Aspose.Cells.Drawing.NoneFill, namespace: Aspose.Cells.Drawing
  DNPatternFill = interface; // type: Aspose.Cells.Drawing.PatternFill, namespace: Aspose.Cells.Drawing
  DNSolidFill = interface; // type: Aspose.Cells.Drawing.SolidFill, namespace: Aspose.Cells.Drawing
  DNTextureFill = interface; // type: Aspose.Cells.Drawing.TextureFill, namespace: Aspose.Cells.Drawing
  DNFillFormat = interface; // type: Aspose.Cells.Drawing.FillFormat, namespace: Aspose.Cells.Drawing
  DNLineFormat = interface; // type: Aspose.Cells.Drawing.LineFormat, namespace: Aspose.Cells.Drawing
  DNFormat3D = interface; // type: Aspose.Cells.Drawing.Format3D, namespace: Aspose.Cells.Drawing
  DNGeometry = interface; // type: Aspose.Cells.Drawing.Geometry, namespace: Aspose.Cells.Drawing
  DNCustomGeometry = interface; // type: Aspose.Cells.Drawing.CustomGeometry, namespace: Aspose.Cells.Drawing
  DNGlowEffect = interface; // type: Aspose.Cells.Drawing.GlowEffect, namespace: Aspose.Cells.Drawing
  DNGradientStop = interface; // type: Aspose.Cells.Drawing.GradientStop, namespace: Aspose.Cells.Drawing
  DNLine = interface; // type: Aspose.Cells.Drawing.Line, namespace: Aspose.Cells.Drawing
  DNErrorBar = interface; // type: Aspose.Cells.Charts.ErrorBar, namespace: Aspose.Cells.Charts
  DNTrendline = interface; // type: Aspose.Cells.Charts.Trendline, namespace: Aspose.Cells.Charts
  DNMsoFillFormat = interface; // type: Aspose.Cells.Drawing.MsoFillFormat, namespace: Aspose.Cells.Drawing
  DNMsoFillFormatHelper = interface; // type: Aspose.Cells.Drawing.MsoFillFormatHelper, namespace: Aspose.Cells.Drawing
  DNMsoFormatPicture = interface; // type: Aspose.Cells.Drawing.MsoFormatPicture, namespace: Aspose.Cells.Drawing
  DNMsoLineFormat = interface; // type: Aspose.Cells.Drawing.MsoLineFormat, namespace: Aspose.Cells.Drawing
  DNMsoLineFormatHelper = interface; // type: Aspose.Cells.Drawing.MsoLineFormatHelper, namespace: Aspose.Cells.Drawing
  DNMsoTextFrame = interface; // type: Aspose.Cells.Drawing.MsoTextFrame, namespace: Aspose.Cells.Drawing
  DNPicFormatOption = interface; // type: Aspose.Cells.Drawing.PicFormatOption, namespace: Aspose.Cells.Drawing
  DNReflectionEffect = interface; // type: Aspose.Cells.Drawing.ReflectionEffect, namespace: Aspose.Cells.Drawing
  DNShadowEffect = interface; // type: Aspose.Cells.Drawing.ShadowEffect, namespace: Aspose.Cells.Drawing
  DNShape = interface; // type: Aspose.Cells.Drawing.Shape, namespace: Aspose.Cells.Drawing
  DNArcShape = interface; // type: Aspose.Cells.Drawing.ArcShape, namespace: Aspose.Cells.Drawing
  DNButton = interface; // type: Aspose.Cells.Drawing.Button, namespace: Aspose.Cells.Drawing
  DNCellsDrawing = interface; // type: Aspose.Cells.Drawing.CellsDrawing, namespace: Aspose.Cells.Drawing
  DNChartShape = interface; // type: Aspose.Cells.Drawing.ChartShape, namespace: Aspose.Cells.Drawing
  DNCheckBox = interface; // type: Aspose.Cells.Drawing.CheckBox, namespace: Aspose.Cells.Drawing
  DNComboBox = interface; // type: Aspose.Cells.Drawing.ComboBox, namespace: Aspose.Cells.Drawing
  DNCommentShape = interface; // type: Aspose.Cells.Drawing.CommentShape, namespace: Aspose.Cells.Drawing
  DNCustomXmlShape = interface; // type: Aspose.Cells.Drawing.CustomXmlShape, namespace: Aspose.Cells.Drawing
  DNDialogBox = interface; // type: Aspose.Cells.Drawing.DialogBox, namespace: Aspose.Cells.Drawing
  DNGroupBox = interface; // type: Aspose.Cells.Drawing.GroupBox, namespace: Aspose.Cells.Drawing
  DNGroupShape = interface; // type: Aspose.Cells.Drawing.GroupShape, namespace: Aspose.Cells.Drawing
  DNLabel = interface; // type: Aspose.Cells.Drawing.Label, namespace: Aspose.Cells.Drawing
  DNLineShape = interface; // type: Aspose.Cells.Drawing.LineShape, namespace: Aspose.Cells.Drawing
  DNListBox = interface; // type: Aspose.Cells.Drawing.ListBox, namespace: Aspose.Cells.Drawing
  DNOleObject = interface; // type: Aspose.Cells.Drawing.OleObject, namespace: Aspose.Cells.Drawing
  DNOval = interface; // type: Aspose.Cells.Drawing.Oval, namespace: Aspose.Cells.Drawing
  DNPicture = interface; // type: Aspose.Cells.Drawing.Picture, namespace: Aspose.Cells.Drawing
  DNRadioButton = interface; // type: Aspose.Cells.Drawing.RadioButton, namespace: Aspose.Cells.Drawing
  DNRectangleShape = interface; // type: Aspose.Cells.Drawing.RectangleShape, namespace: Aspose.Cells.Drawing
  DNScrollBar = interface; // type: Aspose.Cells.Drawing.ScrollBar, namespace: Aspose.Cells.Drawing
  DNSmartArtShape = interface; // type: Aspose.Cells.Drawing.SmartArtShape, namespace: Aspose.Cells.Drawing
  DNSpinner = interface; // type: Aspose.Cells.Drawing.Spinner, namespace: Aspose.Cells.Drawing
  DNTextBox = interface; // type: Aspose.Cells.Drawing.TextBox, namespace: Aspose.Cells.Drawing
  DNWebExtensionShape = interface; // type: Aspose.Cells.Drawing.WebExtensionShape, namespace: Aspose.Cells.Drawing
  DNShapeFormat = interface; // type: Aspose.Cells.Drawing.ShapeFormat, namespace: Aspose.Cells.Drawing
  DNShapeGuide = interface; // type: Aspose.Cells.Drawing.ShapeGuide, namespace: Aspose.Cells.Drawing
  DNShapePath = interface; // type: Aspose.Cells.Drawing.ShapePath, namespace: Aspose.Cells.Drawing
  DNShapePathPoint = interface; // type: Aspose.Cells.Drawing.ShapePathPoint, namespace: Aspose.Cells.Drawing
  DNShapePropertyCollection = interface; // type: Aspose.Cells.Drawing.ShapePropertyCollection, namespace: Aspose.Cells.Drawing
  DNShapeSegmentPath = interface; // type: Aspose.Cells.Drawing.ShapeSegmentPath, namespace: Aspose.Cells.Drawing
  DNSignatureLine = interface; // type: Aspose.Cells.Drawing.SignatureLine, namespace: Aspose.Cells.Drawing
  DNTextEffectFormat = interface; // type: Aspose.Cells.Drawing.TextEffectFormat, namespace: Aspose.Cells.Drawing
  DNBullet = interface; // type: Aspose.Cells.Drawing.Texts.Bullet, namespace: Aspose.Cells.Drawing.Texts
  DNBulletValue = interface; // type: Aspose.Cells.Drawing.Texts.BulletValue, namespace: Aspose.Cells.Drawing.Texts
  DNAutoNumberedBulletValue = interface; // type: Aspose.Cells.Drawing.Texts.AutoNumberedBulletValue, namespace: Aspose.Cells.Drawing.Texts
  DNCharacterBulletValue = interface; // type: Aspose.Cells.Drawing.Texts.CharacterBulletValue, namespace: Aspose.Cells.Drawing.Texts
  DNNoneBulletValue = interface; // type: Aspose.Cells.Drawing.Texts.NoneBulletValue, namespace: Aspose.Cells.Drawing.Texts
  DNPictureBulletValue = interface; // type: Aspose.Cells.Drawing.Texts.PictureBulletValue, namespace: Aspose.Cells.Drawing.Texts
  DNShapeTextAlignment = interface; // type: Aspose.Cells.Drawing.Texts.ShapeTextAlignment, namespace: Aspose.Cells.Drawing.Texts
  DNTextParagraphCollection = interface; // type: Aspose.Cells.Drawing.Texts.TextParagraphCollection, namespace: Aspose.Cells.Drawing.Texts
  DNTextTabStop = interface; // type: Aspose.Cells.Drawing.Texts.TextTabStop, namespace: Aspose.Cells.Drawing.Texts
  DNThreeDFormat = interface; // type: Aspose.Cells.Drawing.ThreeDFormat, namespace: Aspose.Cells.Drawing
  DNTilePicOption = interface; // type: Aspose.Cells.Drawing.TilePicOption, namespace: Aspose.Cells.Drawing
  DNDynamicFilter = interface; // type: Aspose.Cells.DynamicFilter, namespace: Aspose.Cells
  DNErrorCheckOption = interface; // type: Aspose.Cells.ErrorCheckOption, namespace: Aspose.Cells
  DNExportObjectEvent = interface; // type: Aspose.Cells.ExportObjectEvent, namespace: Aspose.Cells
  DNExportTableOptions = interface; // type: Aspose.Cells.ExportTableOptions, namespace: Aspose.Cells
  DNConnectionParameter = interface; // type: Aspose.Cells.ExternalConnections.ConnectionParameter, namespace: Aspose.Cells.ExternalConnections
  DNExternalConnection = interface; // type: Aspose.Cells.ExternalConnections.ExternalConnection, namespace: Aspose.Cells.ExternalConnections
  DNDBConnection = interface; // type: Aspose.Cells.ExternalConnections.DBConnection, namespace: Aspose.Cells.ExternalConnections
  DNWebQueryConnection = interface; // type: Aspose.Cells.ExternalConnections.WebQueryConnection, namespace: Aspose.Cells.ExternalConnections
  DNExternalLink = interface; // type: Aspose.Cells.ExternalLink, namespace: Aspose.Cells
  DNExternalLinkCollection = interface; // type: Aspose.Cells.ExternalLinkCollection, namespace: Aspose.Cells
  DNFileFormatInfo = interface; // type: Aspose.Cells.FileFormatInfo, namespace: Aspose.Cells
  DNFileFormatUtil = interface; // type: Aspose.Cells.FileFormatUtil, namespace: Aspose.Cells
  DNFilterColumn = interface; // type: Aspose.Cells.FilterColumn, namespace: Aspose.Cells
  DNFindOptions = interface; // type: Aspose.Cells.FindOptions, namespace: Aspose.Cells
  DNFont = interface; // type: Aspose.Cells.Font, namespace: Aspose.Cells
  DNTextOptions = interface; // type: Aspose.Cells.Drawing.Texts.TextOptions, namespace: Aspose.Cells.Drawing.Texts
  DNFontConfigs = interface; // type: Aspose.Cells.FontConfigs, namespace: Aspose.Cells
  DNFontSetting = interface; // type: Aspose.Cells.FontSetting, namespace: Aspose.Cells
  DNTextParagraph = interface; // type: Aspose.Cells.Drawing.Texts.TextParagraph, namespace: Aspose.Cells.Drawing.Texts
  DNFontSourceBase = interface; // type: Aspose.Cells.FontSourceBase, namespace: Aspose.Cells
  DNFileFontSource = interface; // type: Aspose.Cells.FileFontSource, namespace: Aspose.Cells
  DNFolderFontSource = interface; // type: Aspose.Cells.FolderFontSource, namespace: Aspose.Cells
  DNMemoryFontSource = interface; // type: Aspose.Cells.MemoryFontSource, namespace: Aspose.Cells
  DNFormatCondition = interface; // type: Aspose.Cells.FormatCondition, namespace: Aspose.Cells
  DNFormatConditionCollection = interface; // type: Aspose.Cells.FormatConditionCollection, namespace: Aspose.Cells
  DNFormulaParseOptions = interface; // type: Aspose.Cells.FormulaParseOptions, namespace: Aspose.Cells
  DNGlobalizationSettings = interface; // type: Aspose.Cells.GlobalizationSettings, namespace: Aspose.Cells
  DNHeaderFooterCommand = interface; // type: Aspose.Cells.HeaderFooterCommand, namespace: Aspose.Cells
  DNHorizontalPageBreak = interface; // type: Aspose.Cells.HorizontalPageBreak, namespace: Aspose.Cells
  DNHyperlink = interface; // type: Aspose.Cells.Hyperlink, namespace: Aspose.Cells
  DNIconFilter = interface; // type: Aspose.Cells.IconFilter, namespace: Aspose.Cells
  DNIconSet = interface; // type: Aspose.Cells.IconSet, namespace: Aspose.Cells
  DNImportTableOptions = interface; // type: Aspose.Cells.ImportTableOptions, namespace: Aspose.Cells
  DNIndividualFontConfigs = interface; // type: Aspose.Cells.IndividualFontConfigs, namespace: Aspose.Cells
  DNInsertOptions = interface; // type: Aspose.Cells.InsertOptions, namespace: Aspose.Cells
  DNInterruptMonitor = interface; // type: Aspose.Cells.InterruptMonitor, namespace: Aspose.Cells
  DNLicense = interface; // type: Aspose.Cells.License, namespace: Aspose.Cells
  DNLoadFilter = interface; // type: Aspose.Cells.LoadFilter, namespace: Aspose.Cells
  DNLoadOptions = interface; // type: Aspose.Cells.LoadOptions, namespace: Aspose.Cells
  DNAbstractTextLoadOptions = interface; // type: Aspose.Cells.AbstractTextLoadOptions, namespace: Aspose.Cells
  DNHtmlLoadOptions = interface; // type: Aspose.Cells.HtmlLoadOptions, namespace: Aspose.Cells
  DNTxtLoadOptions = interface; // type: Aspose.Cells.TxtLoadOptions, namespace: Aspose.Cells
  DNOdsLoadOptions = interface; // type: Aspose.Cells.OdsLoadOptions, namespace: Aspose.Cells
  DNCustomXmlPart = interface; // type: Aspose.Cells.Markup.CustomXmlPart, namespace: Aspose.Cells.Markup
  DNSmartTag = interface; // type: Aspose.Cells.Markup.SmartTag, namespace: Aspose.Cells.Markup
  DNSmartTagOptions = interface; // type: Aspose.Cells.Markup.SmartTagOptions, namespace: Aspose.Cells.Markup
  DNSmartTagProperty = interface; // type: Aspose.Cells.Markup.SmartTagProperty, namespace: Aspose.Cells.Markup
  DNMetadataOptions = interface; // type: Aspose.Cells.Metadata.MetadataOptions, namespace: Aspose.Cells.Metadata
  DNWorkbookMetadata = interface; // type: Aspose.Cells.Metadata.WorkbookMetadata, namespace: Aspose.Cells.Metadata
  DNMetered = interface; // type: Aspose.Cells.Metered, namespace: Aspose.Cells
  DNName = interface; // type: Aspose.Cells.Name, namespace: Aspose.Cells
  DNNegativeBarFormat = interface; // type: Aspose.Cells.NegativeBarFormat, namespace: Aspose.Cells
  DNOdsCellField = interface; // type: Aspose.Cells.Ods.OdsCellField, namespace: Aspose.Cells.Ods
  DNOdsPageBackground = interface; // type: Aspose.Cells.Ods.OdsPageBackground, namespace: Aspose.Cells.Ods
  DNOutline = interface; // type: Aspose.Cells.Outline, namespace: Aspose.Cells
  DNPageSetup = interface; // type: Aspose.Cells.PageSetup, namespace: Aspose.Cells
  DNPaneCollection = interface; // type: Aspose.Cells.PaneCollection, namespace: Aspose.Cells
  DNPasteOptions = interface; // type: Aspose.Cells.PasteOptions, namespace: Aspose.Cells
  DNPivotField = interface; // type: Aspose.Cells.Pivot.PivotField, namespace: Aspose.Cells.Pivot
  DNPivotFieldCollection = interface; // type: Aspose.Cells.Pivot.PivotFieldCollection, namespace: Aspose.Cells.Pivot
  DNPivotFilter = interface; // type: Aspose.Cells.Pivot.PivotFilter, namespace: Aspose.Cells.Pivot
  DNPivotFormatCondition = interface; // type: Aspose.Cells.Pivot.PivotFormatCondition, namespace: Aspose.Cells.Pivot
  DNPivotItem = interface; // type: Aspose.Cells.Pivot.PivotItem, namespace: Aspose.Cells.Pivot
  DNPivotItemCollection = interface; // type: Aspose.Cells.Pivot.PivotItemCollection, namespace: Aspose.Cells.Pivot
  DNPivotPageFields = interface; // type: Aspose.Cells.Pivot.PivotPageFields, namespace: Aspose.Cells.Pivot
  DNPivotTable = interface; // type: Aspose.Cells.Pivot.PivotTable, namespace: Aspose.Cells.Pivot
  DNSxRng = interface; // type: Aspose.Cells.Pivot.SxRng, namespace: Aspose.Cells.Pivot
  DNContentTypeProperty = interface; // type: Aspose.Cells.Properties.ContentTypeProperty, namespace: Aspose.Cells.Properties
  DNCustomProperty = interface; // type: Aspose.Cells.Properties.CustomProperty, namespace: Aspose.Cells.Properties
  DNDocumentProperty = interface; // type: Aspose.Cells.Properties.DocumentProperty, namespace: Aspose.Cells.Properties
  DNDocumentPropertyCollection = interface; // type: Aspose.Cells.Properties.DocumentPropertyCollection, namespace: Aspose.Cells.Properties
  DNBuiltInDocumentPropertyCollection = interface; // type: Aspose.Cells.Properties.BuiltInDocumentPropertyCollection, namespace: Aspose.Cells.Properties
  DNCustomDocumentPropertyCollection = interface; // type: Aspose.Cells.Properties.CustomDocumentPropertyCollection, namespace: Aspose.Cells.Properties
  DNProtectedRange = interface; // type: Aspose.Cells.ProtectedRange, namespace: Aspose.Cells
  DNProtection = interface; // type: Aspose.Cells.Protection, namespace: Aspose.Cells
  DNQueryTable = interface; // type: Aspose.Cells.QueryTable, namespace: Aspose.Cells
  DNDataMashup = interface; // type: Aspose.Cells.QueryTables.DataMashup, namespace: Aspose.Cells.QueryTables
  DNPowerQueryFormula = interface; // type: Aspose.Cells.QueryTables.PowerQueryFormula, namespace: Aspose.Cells.QueryTables
  DNPowerQueryFormulaFunction = interface; // type: Aspose.Cells.QueryTables.PowerQueryFormulaFunction, namespace: Aspose.Cells.QueryTables
  DNPowerQueryFormulaItem = interface; // type: Aspose.Cells.QueryTables.PowerQueryFormulaItem, namespace: Aspose.Cells.QueryTables
  DNPowerQueryFormulaParameter = interface; // type: Aspose.Cells.QueryTables.PowerQueryFormulaParameter, namespace: Aspose.Cells.QueryTables
  DNRange = interface; // type: Aspose.Cells.Range, namespace: Aspose.Cells
  DNReferredArea = interface; // type: Aspose.Cells.ReferredArea, namespace: Aspose.Cells
  DNDrawObject = interface; // type: Aspose.Cells.Rendering.DrawObject, namespace: Aspose.Cells.Rendering
  DNDrawObjectEventHandler = interface; // type: Aspose.Cells.Rendering.DrawObjectEventHandler, namespace: Aspose.Cells.Rendering
  DNImageOrPrintOptions = interface; // type: Aspose.Cells.Rendering.ImageOrPrintOptions, namespace: Aspose.Cells.Rendering
  DNPageSavingArgs = interface; // type: Aspose.Cells.Rendering.PageSavingArgs, namespace: Aspose.Cells.Rendering
  DNPageEndSavingArgs = interface; // type: Aspose.Cells.Rendering.PageEndSavingArgs, namespace: Aspose.Cells.Rendering
  DNPageStartSavingArgs = interface; // type: Aspose.Cells.Rendering.PageStartSavingArgs, namespace: Aspose.Cells.Rendering
  DNPdfBookmarkEntry = interface; // type: Aspose.Cells.Rendering.PdfBookmarkEntry, namespace: Aspose.Cells.Rendering
  DNPdfSecurityOptions = interface; // type: Aspose.Cells.Rendering.PdfSecurity.PdfSecurityOptions, namespace: Aspose.Cells.Rendering.PdfSecurity
  DNSheetPrintingPreview = interface; // type: Aspose.Cells.Rendering.SheetPrintingPreview, namespace: Aspose.Cells.Rendering
  DNSheetRender = interface; // type: Aspose.Cells.Rendering.SheetRender, namespace: Aspose.Cells.Rendering
  DNWorkbookPrintingPreview = interface; // type: Aspose.Cells.Rendering.WorkbookPrintingPreview, namespace: Aspose.Cells.Rendering
  DNWorkbookRender = interface; // type: Aspose.Cells.Rendering.WorkbookRender, namespace: Aspose.Cells.Rendering
  DNReplaceOptions = interface; // type: Aspose.Cells.ReplaceOptions, namespace: Aspose.Cells
  DNRevision = interface; // type: Aspose.Cells.Revisions.Revision, namespace: Aspose.Cells.Revisions
  DNRevisionAutoFormat = interface; // type: Aspose.Cells.Revisions.RevisionAutoFormat, namespace: Aspose.Cells.Revisions
  DNRevisionCellChange = interface; // type: Aspose.Cells.Revisions.RevisionCellChange, namespace: Aspose.Cells.Revisions
  DNRevisionCellComment = interface; // type: Aspose.Cells.Revisions.RevisionCellComment, namespace: Aspose.Cells.Revisions
  DNRevisionCellMove = interface; // type: Aspose.Cells.Revisions.RevisionCellMove, namespace: Aspose.Cells.Revisions
  DNRevisionCustomView = interface; // type: Aspose.Cells.Revisions.RevisionCustomView, namespace: Aspose.Cells.Revisions
  DNRevisionDefinedName = interface; // type: Aspose.Cells.Revisions.RevisionDefinedName, namespace: Aspose.Cells.Revisions
  DNRevisionFormat = interface; // type: Aspose.Cells.Revisions.RevisionFormat, namespace: Aspose.Cells.Revisions
  DNRevisionInsertDelete = interface; // type: Aspose.Cells.Revisions.RevisionInsertDelete, namespace: Aspose.Cells.Revisions
  DNRevisionInsertSheet = interface; // type: Aspose.Cells.Revisions.RevisionInsertSheet, namespace: Aspose.Cells.Revisions
  DNRevisionMergeConflict = interface; // type: Aspose.Cells.Revisions.RevisionMergeConflict, namespace: Aspose.Cells.Revisions
  DNRevisionQueryTable = interface; // type: Aspose.Cells.Revisions.RevisionQueryTable, namespace: Aspose.Cells.Revisions
  DNRevisionRenameSheet = interface; // type: Aspose.Cells.Revisions.RevisionRenameSheet, namespace: Aspose.Cells.Revisions
  DNRevisionLog = interface; // type: Aspose.Cells.Revisions.RevisionLog, namespace: Aspose.Cells.Revisions
  DNRow = interface; // type: Aspose.Cells.Row, namespace: Aspose.Cells
  DNRowCollection = interface; // type: Aspose.Cells.RowCollection, namespace: Aspose.Cells
  DNSaveOptions = interface; // type: Aspose.Cells.SaveOptions, namespace: Aspose.Cells
  DNDifSaveOptions = interface; // type: Aspose.Cells.DifSaveOptions, namespace: Aspose.Cells
  DNDocxSaveOptions = interface; // type: Aspose.Cells.DocxSaveOptions, namespace: Aspose.Cells
  DNHtmlSaveOptions = interface; // type: Aspose.Cells.HtmlSaveOptions, namespace: Aspose.Cells
  DNImageSaveOptions = interface; // type: Aspose.Cells.ImageSaveOptions, namespace: Aspose.Cells
  DNSvgSaveOptions = interface; // type: Aspose.Cells.SvgSaveOptions, namespace: Aspose.Cells
  DNMarkdownSaveOptions = interface; // type: Aspose.Cells.MarkdownSaveOptions, namespace: Aspose.Cells
  DNOdsSaveOptions = interface; // type: Aspose.Cells.OdsSaveOptions, namespace: Aspose.Cells
  DNOoxmlSaveOptions = interface; // type: Aspose.Cells.OoxmlSaveOptions, namespace: Aspose.Cells
  DNPdfSaveOptions = interface; // type: Aspose.Cells.PdfSaveOptions, namespace: Aspose.Cells
  DNPptxSaveOptions = interface; // type: Aspose.Cells.PptxSaveOptions, namespace: Aspose.Cells
  DNSpreadsheetML2003SaveOptions = interface; // type: Aspose.Cells.SpreadsheetML2003SaveOptions, namespace: Aspose.Cells
  DNTxtSaveOptions = interface; // type: Aspose.Cells.TxtSaveOptions, namespace: Aspose.Cells
  DNXlsbSaveOptions = interface; // type: Aspose.Cells.XlsbSaveOptions, namespace: Aspose.Cells
  DNXlsSaveOptions = interface; // type: Aspose.Cells.XlsSaveOptions, namespace: Aspose.Cells
  DNXpsSaveOptions = interface; // type: Aspose.Cells.XpsSaveOptions, namespace: Aspose.Cells
  DNScenario = interface; // type: Aspose.Cells.Scenario, namespace: Aspose.Cells
  DNScenarioInputCell = interface; // type: Aspose.Cells.ScenarioInputCell, namespace: Aspose.Cells
  DNSlicer = interface; // type: Aspose.Cells.Slicers.Slicer, namespace: Aspose.Cells.Slicers
  DNSlicerCache = interface; // type: Aspose.Cells.Slicers.SlicerCache, namespace: Aspose.Cells.Slicers
  DNSlicerCacheItem = interface; // type: Aspose.Cells.Slicers.SlicerCacheItem, namespace: Aspose.Cells.Slicers
  DNStreamProviderOptions = interface; // type: Aspose.Cells.StreamProviderOptions, namespace: Aspose.Cells
  DNStyle = interface; // type: Aspose.Cells.Style, namespace: Aspose.Cells
  DNStyleCollection = interface; // type: Aspose.Cells.StyleCollection, namespace: Aspose.Cells
  DNStyleFlag = interface; // type: Aspose.Cells.StyleFlag, namespace: Aspose.Cells
  DNSubtotalSetting = interface; // type: Aspose.Cells.SubtotalSetting, namespace: Aspose.Cells
  DNListColumn = interface; // type: Aspose.Cells.Tables.ListColumn, namespace: Aspose.Cells.Tables
  DNListObject = interface; // type: Aspose.Cells.Tables.ListObject, namespace: Aspose.Cells.Tables
  DNTableStyle = interface; // type: Aspose.Cells.Tables.TableStyle, namespace: Aspose.Cells.Tables
  DNTableStyleElement = interface; // type: Aspose.Cells.Tables.TableStyleElement, namespace: Aspose.Cells.Tables
  DNTableToRangeOptions = interface; // type: Aspose.Cells.Tables.TableToRangeOptions, namespace: Aspose.Cells.Tables
  DNThemeColor = interface; // type: Aspose.Cells.ThemeColor, namespace: Aspose.Cells
  DNThreadedComment = interface; // type: Aspose.Cells.ThreadedComment, namespace: Aspose.Cells
  DNThreadedCommentAuthor = interface; // type: Aspose.Cells.ThreadedCommentAuthor, namespace: Aspose.Cells
  DNTop10 = interface; // type: Aspose.Cells.Top10, namespace: Aspose.Cells
  DNTop10Filter = interface; // type: Aspose.Cells.Top10Filter, namespace: Aspose.Cells
  DNUnionRange = interface; // type: Aspose.Cells.UnionRange, namespace: Aspose.Cells
  DNExportRangeToJsonOptions = interface; // type: Aspose.Cells.Utility.ExportRangeToJsonOptions, namespace: Aspose.Cells.Utility
  DNJsonLayoutOptions = interface; // type: Aspose.Cells.Utility.JsonLayoutOptions, namespace: Aspose.Cells.Utility
  DNJsonUtility = interface; // type: Aspose.Cells.Utility.JsonUtility, namespace: Aspose.Cells.Utility
  DNValidation = interface; // type: Aspose.Cells.Validation, namespace: Aspose.Cells
  DNVbaModule = interface; // type: Aspose.Cells.Vba.VbaModule, namespace: Aspose.Cells.Vba
  DNVbaProject = interface; // type: Aspose.Cells.Vba.VbaProject, namespace: Aspose.Cells.Vba
  DNVbaProjectReference = interface; // type: Aspose.Cells.Vba.VbaProjectReference, namespace: Aspose.Cells.Vba
  DNVerticalPageBreak = interface; // type: Aspose.Cells.VerticalPageBreak, namespace: Aspose.Cells
  DNWarningInfo = interface; // type: Aspose.Cells.WarningInfo, namespace: Aspose.Cells
  DNWebExtension = interface; // type: Aspose.Cells.WebExtensions.WebExtension, namespace: Aspose.Cells.WebExtensions
  DNWebExtensionBinding = interface; // type: Aspose.Cells.WebExtensions.WebExtensionBinding, namespace: Aspose.Cells.WebExtensions
  DNWebExtensionProperty = interface; // type: Aspose.Cells.WebExtensions.WebExtensionProperty, namespace: Aspose.Cells.WebExtensions
  DNWebExtensionReference = interface; // type: Aspose.Cells.WebExtensions.WebExtensionReference, namespace: Aspose.Cells.WebExtensions
  DNWebExtensionTaskPane = interface; // type: Aspose.Cells.WebExtensions.WebExtensionTaskPane, namespace: Aspose.Cells.WebExtensions
  DNWorkbook = interface; // type: Aspose.Cells.Workbook, namespace: Aspose.Cells
  DNWorkbookDesigner = interface; // type: Aspose.Cells.WorkbookDesigner, namespace: Aspose.Cells
  DNWorkbookSettings = interface; // type: Aspose.Cells.WorkbookSettings, namespace: Aspose.Cells
  DNWorksheet = interface; // type: Aspose.Cells.Worksheet, namespace: Aspose.Cells
  DNWriteProtection = interface; // type: Aspose.Cells.WriteProtection, namespace: Aspose.Cells
  DNXmlColumnProperty = interface; // type: Aspose.Cells.XmlColumnProperty, namespace: Aspose.Cells
  DNXmlDataBinding = interface; // type: Aspose.Cells.XmlDataBinding, namespace: Aspose.Cells
  DNXmlMap = interface; // type: Aspose.Cells.XmlMap, namespace: Aspose.Cells
  DNSmartTagSetting = interface; // type: Aspose.Cells.Markup.SmartTagSetting, namespace: Aspose.Cells.Markup
  DNMultipleFilterCollection = interface; // type: Aspose.Cells.MultipleFilterCollection, namespace: Aspose.Cells
  DNCellsException = interface; // type: Aspose.Cells.CellsException, namespace: Aspose.Cells
  DNCellArea = interface; // type: Aspose.Cells.CellArea, namespace: Aspose.Cells


{ objects }

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents data table.
  ///</summary>
  ///<remarks></remarks>
  [DNTypeName('Aspose.Cells.ICellsDataTable')]
  DNICellsDataTable = interface(DDN.mscorlib.DNObject)
  ['{9D828D3E-9414-3329-A2CC-9616A0735080}']
  { getters & setters } 

    function get_Columns: TArray<string>;
    function get_Count: Int32;
    function get_Item(columnIndex: Int32): DDN.mscorlib.DNObject; overload;
    function get_Item(columnName: string): DDN.mscorlib.DNObject; overload;

  { methods } 

    ///<summary>
    ///  Move the cursor to the front of this object, just before the first row.
    ///</summary>
    procedure BeforeFirst;
    ///<summary>
    ///  Moves the cursor down one row from its current position.
    ///</summary>
    ///<returns> if the new current row is valid; false if there are no more rows </returns>
    function Next: Boolean;

  { propertys } 

    ///<summary>
    ///  Gets the columns' name.
    ///</summary>
    property Columns: TArray<string> read get_Columns;
    ///<summary>
    ///  Gets the count of the records. -1 for unknown records count.
    ///</summary>
    property Count: Int32 read get_Count;
    property Item[columnIndex: Int32]: DDN.mscorlib.DNObject read get_Item; default;
    property Item[columnName: string]: DDN.mscorlib.DNObject read get_Item; default;
  end;

  //-------------namespace: Aspose.Cells----------------
  [DNTypeName('Aspose.Cells.ICustomFunction')]
  DNICustomFunction = interface(DDN.mscorlib.DNObject)
  ['{46BFF052-3D0F-35A7-AC02-DB4669497BD9}']
  { methods } 

    function CalculateCustomFunction(functionName: string; paramsList: DDN.mscorlib.DNArrayList; contextObjects: DDN.mscorlib.DNArrayList): DDN.mscorlib.DNObject;

  end;

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Allows users to add their custom value parser for parsing string values to other proper cell value object.
  ///</summary>
  [DNTypeName('Aspose.Cells.ICustomParser')]
  DNICustomParser = interface(DDN.mscorlib.DNObject)
  ['{4A55C564-704E-35DE-BD6E-E7629A0A80FD}']
  { methods } 

    ///<summary>
    ///  Parses given string to proper value object.
    ///</summary>
    ///  <param name="value">The string value to be parsed</param>
    ///<returns>
    ///  Parsed value object from given string. If given string cannot be parsed to proper value object, returns null.
    ///</returns>
    function ParseObject(value: string): DDN.mscorlib.DNObject;
    ///<summary>
    ///  Gets the formatting pattern corresponding to the parsed value by last invocation of <see cref="M:Aspose.Cells.ICustomParser.ParseObject(System.String)" />
    ///  .
    ///</summary>
    ///<remarks>
    ///  The returned formatting pattern may be used to format corresponding cell(set to Style.Custom for the cell).
    ///</remarks>
    function GetFormat: string;

  end;

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Allows users to manipulate objects while exporting.
  ///</summary>
  ///<example>
  ///  The following example creates a Workbook, opens a file named designer.xls in it and makes the horizontal and vertical scroll bars invisible for the Workbook. It then replaces two string values with an Integer value and string value respectively within the spreadsheet and finally sends the updated file to the client browser.
  ///<code>
  ///  [C#]
  ///  //custom implementation of IExportObjectListener
  ///  class CustomExportObjectListener : IExportObjectListener
  ///  {
  ///  private int imgIdx = 0;
  ///  public object ExportObject(ExportObjectEvent e)
  ///  {
  ///  Object source = e.GetSource();
  ///  if (source is Shape)
  ///  {
  ///  Shape shape = (Shape)source;
  ///  string url = null;
  ///  switch (shape.MsoDrawingType)
  ///  {
  ///  case MsoDrawingType.Picture:
  ///  {
  ///  url = SaveImage(((Picture)shape).Data, imgIdx, ((Picture)shape).ImageFormat);
  ///  break;
  ///  }
  ///  }
  ///  if (url != null)
  ///  {
  ///  imgIdx++;
  ///  }
  ///  return url;
  ///  }
  ///  return null;
  ///  }
  ///  private string SaveImage(byte[] data, int imgIdx, ImageFormat format)
  ///  {
  ///  //here save the image to any location, then return the url(relative or absolute) that the generated html can get the image
  ///  return "temp1/temp2.png";
  ///  }
  ///  }
  ///  //Save html file with custom listener
  ///  HtmlSaveOptions saveOptions = new HtmlSaveOptions();
  ///  saveOptions.ExportObjectListener = new CustomExportObjectListener();
  ///  Stream stream = File.Create(outfn);
  ///  book.Save(stream, saveOptions);
  ///  stream.Flush();
  ///  stream.Close();
  ///</code></example>
  [DNTypeName('Aspose.Cells.IExportObjectListener')]
  DNIExportObjectListener = interface(DDN.mscorlib.DNObject)
  ['{971994BF-4126-3637-8120-B417D2B45CA9}']
  { methods } 

    ///<summary>
    ///  Export one object.
    ///</summary>
    ///  <param name="e">The event triggered when one object needs to be exported.</param>
    ///<returns>
    ///  The information about the result of exporting object.
    ///<ul><li>For exporting objects when export workbook to HTML format,
    ///  the result is URL string to access the saved Image from the html file which contains this exported object.
    ///</li></ul></returns>
    function ExportObject(e: DNExportObjectEvent): DDN.mscorlib.DNObject;

  end;

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the exported file path provider.
  ///</summary>
  [DNTypeName('Aspose.Cells.IFilePathProvider')]
  DNIFilePathProvider = interface(DDN.mscorlib.DNObject)
  ['{6B165796-0113-36E5-B9E9-915618589062}']
  { methods } 

    ///<summary>
    ///  Gets the full path of the file by Worksheet name when exporting Worksheet to html separately.
    ///  So the references among the Worksheets can be exported correctly.
    ///</summary>
    ///  <param name="sheetName">Worksheet name</param>
    ///<returns>the full path of the file</returns>
    function GetFullName(sheetName: string): string;

  end;

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents callback interface of processing smartmarker.
  ///</summary>
  [DNTypeName('Aspose.Cells.ISmartMarkerCallBack')]
  DNISmartMarkerCallBack = interface(DDN.mscorlib.DNObject)
  ['{AE1756CB-F104-3D9B-83C9-20C3F8B31122}']
  { methods } 

    ///<summary>
    ///  Callback for processing a smart marker.
    ///</summary>
    ///  <param name="sheetIndex">The sheet index.</param>
    ///  <param name="rowIndex">The row index.</param>
    ///  <param name="colIndex">The column index.</param>
    ///  <param name="tableName">The table name of smartmarker.</param>
    ///  <param name="columnName">The table name of smartmarker.</param>
    procedure Process(sheetIndex: Int32; rowIndex: Int32; colIndex: Int32; tableName: string; columnName: string);

  end;

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents the exported stream provider.
  ///</summary>
  [DNTypeName('Aspose.Cells.IStreamProvider')]
  DNIStreamProvider = interface(DDN.mscorlib.DNObject)
  ['{04008A5A-1FF8-3E26-9645-8B88669AE372}']
  { methods } 

    ///<summary>
    ///  Gets the stream.
    ///</summary>
    ///  <param name="options"></param>
    procedure InitStream(options: DNStreamProviderOptions);
    ///<summary>
    ///  Closes the stream.
    ///</summary>
    ///  <param name="options"></param>
    procedure CloseStream(options: DNStreamProviderOptions);

  end;

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Callback interface of warning.
  ///</summary>
  [DNTypeName('Aspose.Cells.IWarningCallback')]
  DNIWarningCallback = interface(DDN.mscorlib.DNObject)
  ['{C3A26AF5-FCE8-3100-961E-4907E7C11E14}']
  { methods } 

    ///<summary>
    ///  Our callback only needs to implement the "Warning" method.
    ///</summary>
    ///  <param name="warningInfo"> warning info</param>
    procedure Warning(warningInfo: DNWarningInfo);

  end;

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents cells data handler for reading large spreadsheet files in light weight mode.
  ///</summary>
  ///<remarks>
  ///  When reading a workbook by this mode, <see cref="M:Aspose.Cells.LightCellsDataHandler.StartSheet(Aspose.Cells.Worksheet)" />
  ///  will be checked when reading every worksheet in the workbook.
  ///  For one sheet, if <see cref="M:Aspose.Cells.LightCellsDataHandler.StartSheet(Aspose.Cells.Worksheet)" />
  ///  gives true, then all data and properties of rows/cells of this sheet will be checked
  ///  and processed by the implementation of this interface. For every row, <see cref="M:Aspose.Cells.LightCellsDataHandler.StartRow(System.Int32)" />
  ///  will be called to check whether it need to be processed.
  ///  If a row needs to be processed, properties of this row will be read firstly and user can access its properties by <see cref="M:Aspose.Cells.LightCellsDataHandler.ProcessRow(Aspose.Cells.Row)" />
  ///  .
  ///  if row's cells need to be processed too, then <see cref="M:Aspose.Cells.LightCellsDataHandler.ProcessRow(Aspose.Cells.Row)" />
  ///  should returns true and then <see cref="M:Aspose.Cells.LightCellsDataHandler.StartCell(System.Int32)" />
  ///  will be
  ///  called for every existing cell in this row to check whether one cell need to be processed. If one cell needs to be processed,
  ///  then <see cref="M:Aspose.Cells.LightCellsDataHandler.ProcessCell(Aspose.Cells.Cell)" />
  ///  will be called to process the cell by the implementation of this interface.
  ///</remarks>
  [DNTypeName('Aspose.Cells.LightCellsDataHandler')]
  DNLightCellsDataHandler = interface(DDN.mscorlib.DNObject)
  ['{BDBC6223-AE14-33B8-BB42-42FB443A26A1}']
  { methods } 

    ///<summary>
    ///  Starts to process a worksheet.
    ///</summary>
    ///<remarks>
    ///  It will be called before reading cells data of a worksheet.
    ///</remarks>
    ///  <param name="sheet">the worksheet to read cells data.</param>
    ///<returns>
    ///  whether this sheet's cells data needs to be processed. false to ignore this sheet.
    ///</returns>
    function StartSheet(sheet: DNWorksheet): Boolean;
    ///<summary>
    ///  Prepares to process a row.
    ///</summary>
    ///  <param name="rowIndex">the index of next row to be processed</param>
    ///<returns>whether this row(properties or cells data) needs to be processed. false to ignore this row and its cells and check the next row.</returns>
    function StartRow(rowIndex: Int32): Boolean;
    ///<summary>
    ///  Starts to process one row.
    ///</summary>
    ///<remarks>
    ///  It will be called after row's properties such as height, style, ...etc. have been read. However, cells in this row has not been read yet.
    ///</remarks>
    ///  <param name="row">
    ///  Row object which is being processed currently.
    ///</param>
    ///<returns>whether this row's cells need to be processed. false to ignore all cells in this row.</returns>
    function ProcessRow(row: DNRow): Boolean;
    ///<summary>
    ///  Prepares to process a cell.
    ///</summary>
    ///<remarks>
    ///  It will be called when reaching an existing cell in current row. Current row is the row of last call of <see cref="M:Aspose.Cells.LightCellsDataHandler.ProcessRow(Aspose.Cells.Row)" />
    ///  .
    ///</remarks>
    ///  <param name="columnIndex">column index of the cell to be processed</param>
    ///<returns>whether this cell needs to be processed. false to ignore the cell and check the next one until reach the end of cells data of current row</returns>
    function StartCell(columnIndex: Int32): Boolean;
    ///<summary>
    ///  Starts to process one cell.
    ///</summary>
    ///<remarks>
    ///  It will be called after one cell's data has been read.
    ///</remarks>
    ///  <param name="cell">
    ///  Cell object which is being processed currently
    ///</param>
    ///<returns>whether this cell needs to be kept in cells model of current sheet.
    ///  Commonly it should be false so that all cells will not be kept in memory after being processed and then memory be saved.
    ///  For some special purpose such as user needs to access some cells later after the whole workbook having been processed,
    ///  user can make this method return true to keep those special cells in Cells model and access them later by APIs such as Cells[row, column].
    ///  However, keeping cells data in Cells model will requires more memory and if all cells are kept then reading template file
    ///  in LightCells mode will become same with reading it in normal way.</returns>
    function ProcessCell(cell: DNCell): Boolean;

  end;

  //-------------namespace: Aspose.Cells----------------
  ///<summary>
  ///  Represents Data provider for saving large spreadsheet files in light weight mode.
  ///</summary>
  ///<remarks>
  ///  When saving a workbook by this mode, <see cref="M:Aspose.Cells.LightCellsDataProvider.StartSheet(System.Int32)" />
  ///  will be checked when saving every worksheet in the workbook.
  ///  For one sheet, if <see cref="M:Aspose.Cells.LightCellsDataProvider.StartSheet(System.Int32)" />
  ///  gives true, then all data and properties of rows/cells of this sheet to be saved
  ///  will be provided by the implementation of this interface. In the first place, <see cref="M:Aspose.Cells.LightCellsDataProvider.NextRow" />
  ///  will be called to get the next row index to be saved.
  ///  If a valid row index is returned(the row index must be in ascending order for the rows to be saved),
  ///  then a Row object representing this row will be provided for implementation to set its properties by <see cref="M:Aspose.Cells.LightCellsDataProvider.StartRow(Aspose.Cells.Row)" />
  ///  .
  ///  For one row, <see cref="M:Aspose.Cells.LightCellsDataProvider.NextCell" />
  ///  will be checked firstly. If a valid column index be returned(the column index must be in ascending order for all cells of one row to be saved),
  ///  then a Cell object representing this cell will be provided for implementation to set its data and properties by <see cref="M:Aspose.Cells.LightCellsDataProvider.StartCell(Aspose.Cells.Cell)" />
  ///  .
  ///  After data of this cell is set, this cell will be saved directly to the generated spreadsheet file and the next cell will be checked and processed.
  ///</remarks>
  [DNTypeName('Aspose.Cells.LightCellsDataProvider')]
  DNLightCellsDataProvider = interface(DDN.mscorlib.DNObject)
  ['{C2E815BD-9D2E-30E7-8FD8-E7440184CF57}']
  { methods } 

    ///<summary>
    ///  Starts to save a worksheet.
    ///</summary>
    ///<remarks>
    ///  It will be called at the beginning of saving a worksheet during saving a workbook.
    ///  If the provider needs to refer to <i><code>sheetIndex</code></i> later
    ///  in startRow(Row) or startCell(Cell) method,
    ///  that is, if the process needs to know which worksheet is being processed,
    ///  the implementation should retain the <i><code>sheetIndex</code></i> value here.
    ///</remarks>
    ///  <param name="sheetIndex">index of current sheet to be saved.</param>
    ///<returns>
    ///  true if this provider will provide data for the given sheet; false if given sheet should use its normal data model(Cells).
    ///</returns>
    function StartSheet(sheetIndex: Int32): Boolean;
    ///<summary>
    ///  Gets the next row to be saved.
    ///</summary>
    ///<remarks>
    ///  It will be called at the beginning of saving a row and its cells data(before <see cref="M:Aspose.Cells.LightCellsDataProvider.StartRow(Aspose.Cells.Row)" />
    ///  ).
    ///</remarks>
    ///<returns>
    ///  the next row index to be saved. -1 means the end of current sheet data has been reached and no further row of current sheet to be saved.
    ///</returns>
    function NextRow: Int32;
    ///<summary>
    ///  Starts to save data of one row.
    ///</summary>
    ///<remarks>
    ///  It will be called at the beginning of saving a row and its cells data.
    ///  If current row has some custom properties such as height, style, ...etc.,
    ///  implementation should set those properties to given Row object here.
    ///</remarks>
    ///  <param name="row">
    ///  Row object for implementation to fill data. Its row index is the returned value of latest call of <see cref="M:Aspose.Cells.LightCellsDataProvider.NextRow" />
    ///  .
    ///  If the row has been initialized in the inner cells model, the existing row object will be used.
    ///  Otherwise a temporary Row object will be used for implementation to fill data.
    ///</param>
    procedure StartRow(row: DNRow);
    ///<summary>
    ///  Gets next cell to be saved.
    ///</summary>
    ///<remarks>
    ///  It will be called at the beginning of saving one cell.
    ///</remarks>
    ///<returns>
    ///  column index of the next cell to be saved. -1 means the end of current row data has been reached and no further cell of current row to be saved.
    ///</returns>
    function NextCell: Int32;
    ///<summary>
    ///  Starts to save data of one cell.
    ///</summary>
    ///<remarks></remarks>
    ///  <param name="cell">
    ///  Cell object for implementation to fill data. Its column index is the returned value of latest call of <see cref="M:Aspose.Cells.LightCellsDataProvider.NextCell" />
    ///  .
    ///  If the cell has been initialized in the inner cells model, the existed cell object will be used.
    ///  Otherwise a temporary Cell object will be used for implementation to fill data.
    ///</param>
    procedure StartCell(cell: DNCell);
    ///<summary>
    ///  Checks whether the current string value of cell needs to be gathered into a global pool.
    ///</summary>
    ///<remarks>
    ///  Gathering string values will take advantage only when there are many duplicated string values for the cells provided by this implementation.
    ///  In this situation gathering string will save much memory and generate smaller resultant file.
    ///  If there are many string values for the cells provided by LightCellsDataProvider but few of them are same,
    ///  gathering string will cost more memory and time and has no advantage for the resultant file.
    ///</remarks>
    ///<returns>
    ///  true if string value need to be gathered into a global pool for the resultant file.
    ///</returns>
    function IsGatherString: Boolean;

  end;

  //-------------namespace: Aspose.Cells.Rendering----------------
  ///<summary>
  ///  Control/Indicate progress of page saving process.
  ///</summary>
  [DNTypeName('Aspose.Cells.Rendering.IPageSavingCallback')]
  DNIPageSavingCallback = interface(DDN.mscorlib.DNObject)
  ['{8FD528EC-770F-3C30-BDEE-1947090E3085}']
  { methods } 

    ///<summary>
    ///  Control/Indicate a page starts to be output.
    ///</summary>
    ///  <param name="args">Info for a page starts saving process.</param>
    procedure PageStartSaving(args: DNPageStartSavingArgs);
    ///<summary>
    ///  Control/Indicate a page ends to be output.
    ///</summary>
    ///  <param name="args">Info for a page ends saving process.</param>
    procedure PageEndSaving(args: DNPageEndSavingArgs);

  end;

  //-------------namespace: Aspose.Cells----------------
  DNAboveAverageClass = interface(DDN.mscorlib.DNObjectClass)
  ['{65348485-A503-5F62-8DA2-B691473052DF}']
  { constructors } 

    {class} function init: DNAboveAverage;

  end;

  ///<summary>
  ///  Describe the AboveAverage conditional formatting rule.
  ///  This conditional formatting rule highlights cells that
  ///  are above or below the average for all values in the range.
  ///</summary>
  [DNTypeName('Aspose.Cells.AboveAverage')]
  DNAboveAverage = interface(DDN.mscorlib.DNObject)
  ['{0983160A-2486-3119-9261-6418AF1C8F87}']
  { getters & setters } 

    function get_IsAboveAverage: Boolean;
    procedure set_IsAboveAverage(value: Boolean);
    function get_IsEqualAverage: Boolean;
    procedure set_IsEqualAverage(value: Boolean);
    function get_StdDev: Int32;
    procedure set_StdDev(value: Int32);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Get or set the flag indicating whether the rule is an "above average" rule.
    ///  'true' indicates 'above average'.
    ///  Default value is true.
    ///</summary>
    property IsAboveAverage: Boolean read get_IsAboveAverage write set_IsAboveAverage;
    ///<summary>
    ///  Get or set the flag indicating whether the 'aboveAverage' and 'belowAverage' criteria
    ///  is inclusive of the average itself, or exclusive of that value.
    ///  'true' indicates to include the average value in the criteria.
    ///  Default value is false.
    ///</summary>
    property IsEqualAverage: Boolean read get_IsEqualAverage write set_IsEqualAverage;
    ///<summary>
    ///  Get or set the number of standard deviations to include above or below the average in the
    ///  conditional formatting rule.
    ///  The input value must between 0 and 3 (include 0 and 3).
    ///  Setting this value to 0 means stdDev is not set.
    ///  The default value is 0.
    ///</summary>
    property StdDev: Int32 read get_StdDev write set_StdDev;
  end;

  TDNAboveAverage = class(TDNGenericImport<DNAboveAverageClass, DNAboveAverage>) end;

  //-------------namespace: Aspose.Cells----------------
  DNAbstractCalculationEngineClass = interface(DDN.mscorlib.DNObjectClass)
  ['{CFC3855D-6F08-516D-A90A-FF5ADF2C45C9}']
  end;

  ///<summary>
  ///  Represents user's custom calculation engine to extend the default calculation engine of Aspose.Cells.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  public class MyEngine : AbstractCalculationEngine
  ///  {
  ///  public override void Calculate(CalculationData data)
  ///  {
  ///  string funcName = data.FunctionName.ToUpper();
  ///  if ("MYFUNC".Equals(funcName))
  ///  {
  ///  //do calculation for MYFUNC here
  ///  int count = data.ParamCount;
  ///  object res = null;
  ///  for (int i = 0; i &lt; count; i++)
  ///  {
  ///  object pv = data.GetParamValue(i);
  ///  if (pv is ReferredArea)
  ///  {
  ///  ReferredArea ra = (ReferredArea)pv;
  ///  pv = ra.GetValue(0, 0);
  ///  }
  ///  //process the parameter here
  ///  //res = ...;
  ///  }
  ///  data.CalculatedValue = res;
  ///  }
  ///  }
  ///  }
  ///</code></example><remarks>User should not modify any part of the Workbook directly in this implementation(except the calculated result of the custom function, which can be set by CalculationData.CalculatedValue property).
  ///  Otherwise unexpected result or Exception may be caused.
  ///  If user needs to change other data than calculated result in the implementation for some custom functions,
  ///  for example, change cell's formula, style, ...etc., user should gather those data in this implementation and change them out of the scope of formula calculation.</remarks>
  [DNTypeName('Aspose.Cells.AbstractCalculationEngine')]
  DNAbstractCalculationEngine = interface(DDN.mscorlib.DNObject)
  ['{A6E818F1-1AD7-36F1-8523-7F5C0B1D92EB}']
  { getters & setters } 

    function get_IsParamLiteralRequired: Boolean;
    function get_ProcessBuiltInFunctions: Boolean;

  { methods } 

    ///<summary>
    ///  Calculates one function with given data.
    ///</summary>
    ///  <param name="data">the required data to calculate function such as function name, parameters, ...etc.</param>
    ///<remarks>User should set the calculated value for given data for all functions(including excel native functions)
    ///  that he wants to calculate by himself in this implementation.
    ///</remarks>
    procedure Calculate(data: DNCalculationData);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Indicates whether this engine needs the literal text of parameter while doing calculation. Default value is false.
    ///</summary>
    ///<remarks>If this custom calculation engine requires the parameter's literal text, more stacks will be required to cache the literal text for parameters and Calculate() method may be called recursively to calculate the parameter's value.
    ///  Commonly the literal text is not needed for calculating formulas and this method should return false for most implementations to get better performance.
    ///</remarks>
    property IsParamLiteralRequired: Boolean read get_IsParamLiteralRequired;
    ///<summary>
    ///  Whether built-in functions that have been supported by the built-in engine should be checked and processed by this implementation.
    ///  Default is false.
    ///  If user needs to change the calculation logic of some built-in functions, this property should be set as true.
    ///</summary>
    property ProcessBuiltInFunctions: Boolean read get_ProcessBuiltInFunctions;
  end;

  TDNAbstractCalculationEngine = class(TDNGenericImport<DNAbstractCalculationEngineClass, DNAbstractCalculationEngine>) end;

  //-------------namespace: Aspose.Cells----------------
  DNAbstractCalculationMonitorClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B26EE762-8307-588D-9801-CD090C7ED3A6}']
  end;

  ///<summary>
  ///  Monitor for user to track the progress of formula calculation.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Custom monitor to check possibility of StackOverflowException
  ///  public class MyCalculationMonitor : AbstractCalculationMonitor
  ///  {
  ///  public override void BeforeCalculate(int sheetIndex, int rowIndex, int colIndex)
  ///  {
  ///  if(new StackTrace(false).FrameCount &gt; 1000)
  ///  {
  ///  throw new Exception("Stop the formula calculation because risk of StackOverflowException");
  ///  }
  ///  }
  ///  }
  ///</code></example>
  [DNTypeName('Aspose.Cells.AbstractCalculationMonitor')]
  DNAbstractCalculationMonitor = interface(DDN.mscorlib.DNObject)
  ['{F1297480-B72D-3335-92B9-02F333CAA266}']
  { getters & setters } 

    function get_OriginalValue: DDN.mscorlib.DNObject;
    function get_ValueChanged: Boolean;
    function get_CalculatedValue: DDN.mscorlib.DNObject;

  { methods } 

    ///<summary>
    ///  Implement this method to do business before calculating one cell.
    ///</summary>
    ///  <param name="sheetIndex">Index of the sheet that the cell belongs to.</param>
    ///  <param name="rowIndex">Row index of the cell</param>
    ///  <param name="colIndex">Column index of the cell</param>
    procedure BeforeCalculate(sheetIndex: Int32; rowIndex: Int32; colIndex: Int32);
    ///<summary>
    ///  Implement this method to do business after one cell has been calculated.
    ///</summary>
    ///  <param name="sheetIndex">Index of the sheet that the cell belongs to.</param>
    ///  <param name="rowIndex">Row index of the cell</param>
    ///  <param name="colIndex">Column index of the cell</param>
    procedure AfterCalculate(sheetIndex: Int32; rowIndex: Int32; colIndex: Int32);
    ///<summary>
    ///  Implement this method to do business when calculating formulas with circular references.
    ///</summary>
    ///  <param name="circularCellsData">IEnumerator with CalculationCell items representing cells that
    ///  depend on circular references.</param>
    ///<returns>Whether the formula engine needs to calculate those cells in circular after this call.
    ///  True to let the formula engine continue to do calculation for them.
    ///  False to let the formula engine just mark those cells as Calculated.
    ///</returns>
    ///<remarks>In the implementation user may also set the expected value as calculated result
    ///  for part/all of those cells so the formula engine will not calculate them recursively.
    ///</remarks>
    function OnCircular(circularCellsData: DDN.mscorlib.DNIEnumerator): Boolean;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the old value of the calculated cell.
    ///  Should be used only in <see cref="M:Aspose.Cells.AbstractCalculationMonitor.BeforeCalculate(System.Int32,System.Int32,System.Int32)" />
    ///  and <see cref="M:Aspose.Cells.AbstractCalculationMonitor.AfterCalculate(System.Int32,System.Int32,System.Int32)" />
    ///  .
    ///</summary>
    property OriginalValue: DDN.mscorlib.DNObject read get_OriginalValue;
    ///<summary>
    ///  Whether the cell's value has been changed after the calculation.
    ///  Should be used only in <see cref="M:Aspose.Cells.AbstractCalculationMonitor.AfterCalculate(System.Int32,System.Int32,System.Int32)" />
    ///  .
    ///</summary>
    property ValueChanged: Boolean read get_ValueChanged;
    ///<summary>
    ///  Gets the newly calculated value of the cell.
    ///  Should be used only in <see cref="M:Aspose.Cells.AbstractCalculationMonitor.AfterCalculate(System.Int32,System.Int32,System.Int32)" />
    ///  .
    ///</summary>
    property CalculatedValue: DDN.mscorlib.DNObject read get_CalculatedValue;
  end;

  TDNAbstractCalculationMonitor = class(TDNGenericImport<DNAbstractCalculationMonitorClass, DNAbstractCalculationMonitor>) end;

  //-------------namespace: Aspose.Cells----------------
  DNAutoFilterClass = interface(DDN.mscorlib.DNObjectClass)
  ['{413B363F-A09E-5FB3-8168-588C9DA27667}']
  end;

  ///<summary>
  ///  Represents autofiltering for the specified worksheet.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Creating a file stream containing the Excel file to be opened
  ///  FileStream fstream = new FileStream("C:\\book1.xls", FileMode.Open);
  ///  //Instantiating a Workbook object and open a stream.
  ///  Workbook workbook = new Workbook(fstream);
  ///  //Accessing the first worksheet in the Excel file
  ///  Worksheet worksheet = workbook.Worksheets[0];
  ///  //Creating AutoFilter by giving the cells range of the heading row
  ///  worksheet.AutoFilter.Range = "A1:B1";
  ///  //Filtering columns with specified values
  ///  worksheet.AutoFilter.Filter(1, "Bananas");
  ///  //Saving the modified Excel file.
  ///  workbook.Save("C:\\output.xls");
  ///  //Closing the file stream to free all resources
  ///  fstream.Close();
  ///  [Visual Basic]
  ///  'Creating a file stream containing the Excel file to be opened
  ///  Dim fstream As FileStream = New FileStream("C:\\book1.xls", FileMode.Open)
  ///  'Instantiating a Workbook object
  ///  Dim workbook As Workbook = New Workbook(fstream)
  ///  'Accessing the first worksheet in the Excel file
  ///  Dim worksheet As Worksheet = workbook.Worksheets(0)
  ///  'Creating AutoFilter by giving the cells range of the heading row
  ///  worksheet.AutoFilter.Range = "A1:B1"
  ///  'Filtering columns with specified values
  ///  Worksheet.AutoFilter.Filter(1, "Bananas")
  ///  'Saving the modified Excel file
  ///  workbook.Save("C:\\output.xls")
  ///  'Closing the file stream to free all resources
  ///  fstream.Close()
  ///</code></example>
  [DNTypeName('Aspose.Cells.AutoFilter')]
  DNAutoFilter = interface(DDN.mscorlib.DNObject)
  ['{129FF2F8-EE89-3F74-A5EF-53828411140B}']
  { getters & setters } 

    function get_Sorter: DNDataSorter;
    function get_Range: string;
    procedure set_Range(value: string);
    function get_ShowFilterButton: Boolean;
    procedure set_ShowFilterButton(value: Boolean);
    function get_FilterColumns: DNFilterColumnCollection;

  { methods } 

    ///<summary>
    ///  Sets the range to which the specified AutoFilter applies.
    ///</summary>
    ///  <param name="row">Row index.</param>
    ///  <param name="startColumn">Start column index.</param>
    ///  <param name="endColumn">End column Index.</param>
    procedure SetRange(row: Int32; startColumn: Int32; endColumn: Int32);
    ///<summary>
    ///  Adds a filter for a filter column.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).
    ///</param>
    ///  <param name="criteria">The specified criteria (a string; for example, "101").
    ///  It only can be null or be one of the cells' value in this column.
    ///</param>
    ///<remarks>
    ///  MS Excel 2007 supports multiple selection in a filter column.
    ///</remarks>
    procedure AddFilter(fieldIndex: Int32; criteria: string);
    ///<summary>
    ///  Adds a date filter.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).
    ///</param>
    ///  <param name="dateTimeGroupingType"><see cref="T:Aspose.Cells.DateTimeGroupingType" />
    ///</param>
    ///  <param name="year">The year.</param>
    ///  <param name="month">The month.</param>
    ///  <param name="day">The day.</param>
    ///  <param name="hour">The hour.</param>
    ///  <param name="minute">The minute.</param>
    ///  <param name="second">The second.</param>
    ///<remarks>
    ///  If DateTimeGroupingType is Year, only the param year effects.
    ///  If DateTiemGroupingType is Month, only the param year and month effect.
    ///</remarks>
    procedure AddDateFilter(fieldIndex: Int32; dateTimeGroupingType: DNDateTimeGroupingType; year: Int32; month: Int32; day: Int32; hour: Int32; minute: Int32; second: Int32);
    ///<summary>
    ///  Removes a date filter.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).
    ///</param>
    ///  <param name="dateTimeGroupingType"><see cref="T:Aspose.Cells.DateTimeGroupingType" />
    ///</param>
    ///  <param name="year">The year.</param>
    ///  <param name="month">The month.</param>
    ///  <param name="day">The day.</param>
    ///  <param name="hour">The hour.</param>
    ///  <param name="minute">The minute.</param>
    ///  <param name="second">The second.</param>
    ///<remarks>
    ///  If DateTimeGroupingType is Year, only the param year effects.
    ///  If DateTiemGroupingType is Month, only the param year and month effect.
    ///</remarks>
    procedure RemoveDateFilter(fieldIndex: Int32; dateTimeGroupingType: DNDateTimeGroupingType; year: Int32; month: Int32; day: Int32; hour: Int32; minute: Int32; second: Int32);
    ///<summary>
    ///  Removes a filter for a filter column.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).
    ///</param>
    ///  <param name="criteria">The specified criteria (a string; for example, "101").
    ///  It only can be null or be one of the cells' value in this column.
    ///</param>
    procedure RemoveFilter(fieldIndex: Int32; criteria: string); overload;
    ///<summary>
    ///  Filters a list with specified criteria.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).
    ///</param>
    ///  <param name="criteria">The specified criteria (a string; for example, "101"). </param>
    ///<remarks>
    ///  Aspose.Cells will remove all other filter setting on this field as Ms Excel 97-2003.
    ///</remarks>
    procedure Filter(fieldIndex: Int32; criteria: string);
    ///<summary>
    ///  Filter the top 10 item in the list
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).</param>
    ///  <param name="isTop">Indicates whether filter from top or bottom</param>
    ///  <param name="isPercent">Indicates whether the items is percent or count </param>
    ///  <param name="itemCount">The item count</param>
    procedure FilterTop10(fieldIndex: Int32; isTop: Boolean; isPercent: Boolean; itemCount: Int32);
    ///<summary>
    ///  Adds a dynamic filter.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).</param>
    ///  <param name="dynamicFilterType">
    ///  Dynamic filter type.
    ///</param>
    procedure DynamicFilter(fieldIndex: Int32; dynamicFilterType: DNDynamicFilterType);
    ///<summary>
    ///  Adds a font color filter.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).</param>
    ///  <param name="color">The <see cref="T:Aspose.Cells.CellsColor" />
    ///  object.
    ///</param>
    procedure AddFontColorFilter(fieldIndex: Int32; color: DNCellsColor);
    ///<summary>
    ///  Adds a fill color filter.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).</param>
    ///  <param name="pattern">The background pattern type.</param>
    ///  <param name="foregroundColor">The foreground color.</param>
    ///  <param name="backgroundColor">The background color.</param>
    procedure AddFillColorFilter(fieldIndex: Int32; pattern: DNBackgroundType; foregroundColor: DNCellsColor; backgroundColor: DNCellsColor);
    ///<summary>
    ///  Adds an icon filter.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).</param>
    ///  <param name="iconSetType">The icon set type.</param>
    ///  <param name="iconId">The icon id.</param>
    ///<remarks>
    ///  Only supports to add the icon filter.
    ///  Not supports checking which row is visible if the filter is icon filter.
    ///</remarks>
    procedure AddIconFilter(fieldIndex: Int32; iconSetType: DNIconSetType; iconId: Int32);
    ///<summary>
    ///  Match all blank cell in the list.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).</param>
    procedure MatchBlanks(fieldIndex: Int32);
    ///<summary>
    ///  Match all not blank cell in the list.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).</param>
    procedure MatchNonBlanks(fieldIndex: Int32);
    ///<summary>
    ///  Filters a list with a custom criteria.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).</param>
    ///  <param name="operatorType1">The filter operator type</param>
    ///  <param name="criteria1">The custom criteria</param>
    procedure Custom(fieldIndex: Int32; operatorType1: DNFilterOperatorType; criteria1: DDN.mscorlib.DNObject); overload;
    ///<summary>
    ///  Filters a list with custom criteria.
    ///</summary>
    ///  <param name="fieldIndex">The integer offset of the field on which you want to base the filter
    ///  (from the left of the list; the leftmost field is field 0).</param>
    ///  <param name="operatorType1">The filter operator type</param>
    ///  <param name="criteria1">The custom criteria</param>
    ///  <param name="isAnd"></param>
    ///  <param name="operatorType2">The filter operator type</param>
    ///  <param name="criteria2">The custom criteria</param>
    procedure Custom(fieldIndex: Int32; operatorType1: DNFilterOperatorType; criteria1: DDN.mscorlib.DNObject; isAnd: Boolean; operatorType2: DNFilterOperatorType; criteria2: DDN.mscorlib.DNObject); overload;
    ///<summary>
    ///  Unhide all rows.
    ///</summary>
    procedure ShowAll;
    ///<summary>
    ///  Remove the specific filter.
    ///</summary>
    ///  <param name="fieldIndex">The specific filter index</param>
    procedure RemoveFilter(fieldIndex: Int32); overload;
    ///<summary>
    ///  Refresh auto filters to hide or unhide the rows.
    ///</summary>
    ///<returns>
    ///  Returns all hidden rows' indexes.
    ///</returns>
    function Refresh: TArray<Int32>; overload;
    ///<summary>
    ///  Gets all hidden rows' indexes.
    ///</summary>
    ///  <param name="hideRows">
    ///  If true, hide the filtered rows.
    ///</param>
    ///<returns>
    ///  Returns all hidden rows indexes.
    ///</returns>
    function Refresh(hideRows: Boolean): TArray<Int32>; overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the data sorter.
    ///</summary>
    property Sorter: DNDataSorter read get_Sorter;
    ///<summary>
    ///  Represents the range to which the specified AutoFilter applies.
    ///</summary>
    property Range: string read get_Range write set_Range;
    ///<summary>
    ///  Indicates whether the AutoFilter button for this column is visible.
    ///</summary>
    property ShowFilterButton: Boolean read get_ShowFilterButton write set_ShowFilterButton;
    ///<summary>
    ///  Gets the collection of the filter columns.
    ///</summary>
    property FilterColumns: DNFilterColumnCollection read get_FilterColumns;
  end;

  TDNAutoFilter = class(TDNGenericImport<DNAutoFilterClass, DNAutoFilter>) end;

  //-------------namespace: Aspose.Cells----------------
  DNAutoFitterOptionsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{4CD1F678-4397-5751-ADDB-8034B4757289}']
  { constructors } 

    {class} function init: DNAutoFitterOptions;

  end;

  ///<summary>
  ///  Represents all auto fitter options.
  ///</summary>
  [DNTypeName('Aspose.Cells.AutoFitterOptions')]
  DNAutoFitterOptions = interface(DDN.mscorlib.DNObject)
  ['{F22C6652-4DEB-3062-B97A-FCE99CB09D82}']
  { getters & setters } 

    function get_DefaultEditLanguage: DNDefaultEditLanguage;
    procedure set_DefaultEditLanguage(value: DNDefaultEditLanguage);
    function get_AutoFitMergedCells: Boolean;
    procedure set_AutoFitMergedCells(value: Boolean);
    function get_AutoFitMergedCellsType: DNAutoFitMergedCellsType;
    procedure set_AutoFitMergedCellsType(value: DNAutoFitMergedCellsType);
    function get_OnlyAuto: Boolean;
    procedure set_OnlyAuto(value: Boolean);
    function get_IgnoreHidden: Boolean;
    procedure set_IgnoreHidden(value: Boolean);
    function get_MaxRowHeight: Double;
    procedure set_MaxRowHeight(value: Double);
    function get_AutoFitWrappedTextType: DNAutoFitWrappedTextType;
    procedure set_AutoFitWrappedTextType(value: DNAutoFitWrappedTextType);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets default edit language.
    ///</summary>
    ///<remarks>
    ///  It may display/render different layouts for text paragraph when different edit languages is set.
    ///  Default is <see cref="!:DefaultEditLanguage.Auto" />
    ///  .
    ///</remarks>
    property DefaultEditLanguage: DNDefaultEditLanguage read get_DefaultEditLanguage write set_DefaultEditLanguage;
    ///<summary>
    ///  Indicates whether auto fit row height when the cells is merged in a row.
    ///  The default value is false.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use AutoFitterOptions.AutoFitMergedCellsType property, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property AutoFitMergedCells: Boolean read get_AutoFitMergedCells write set_AutoFitMergedCells;
    ///<summary>
    ///  Gets and set the type of auto fitting row height of merged cells.
    ///</summary>
    ///<remarks>
    ///  Excel defaults to ignore merged cells when fitting the row height, so Aspose.Cells works as MS Excel default.
    ///  Please set this type to change the way of auto fitting row height of merged cells.
    ///</remarks>
    property AutoFitMergedCellsType: DNAutoFitMergedCellsType read get_AutoFitMergedCellsType write set_AutoFitMergedCellsType;
    ///<summary>
    ///  Indicates whether only fit the rows which height are not customed.
    ///</summary>
    property OnlyAuto: Boolean read get_OnlyAuto write set_OnlyAuto;
    ///<summary>
    ///  Ignores the hidden rows/columns.
    ///</summary>
    property IgnoreHidden: Boolean read get_IgnoreHidden write set_IgnoreHidden;
    ///<summary>
    ///  Gets and sets the max row height(in unit of Point) when autofitting rows.
    ///</summary>
    property MaxRowHeight: Double read get_MaxRowHeight write set_MaxRowHeight;
    ///<summary>
    ///  Gets and sets the type of auto fitting wrapped text.
    ///</summary>
    property AutoFitWrappedTextType: DNAutoFitWrappedTextType read get_AutoFitWrappedTextType write set_AutoFitWrappedTextType;
  end;

  TDNAutoFitterOptions = class(TDNGenericImport<DNAutoFitterOptionsClass, DNAutoFitterOptions>) end;

  //-------------namespace: Aspose.Cells----------------
  DNBorderClass = interface(DDN.mscorlib.DNObjectClass)
  ['{156C581B-ABEA-5CDE-A9A8-ED5D9B93BE23}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents the cell border.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  Style style = cell.GetStyle();
  ///  //Set top border style and color
  ///  Border border = style.Borders[BorderType.TopBorder];
  ///  border.LineStyle = CellBorderType.Medium;
  ///  border.Color = Color.Red;
  ///  cell.SetStyle(style);
  ///  [Visual Basic]
  ///  Dim style as Style = cell.GetStyle()
  ///  'Set top border style and color
  ///  Dim border as Border = style.Borders(BorderType.TopBorder)
  ///  border.LineStyle = CellBorderType.Medium
  ///  border.Color = Color.Red
  ///  cell.SetStyle(style);
  ///</code></example>
  [DNTypeName('Aspose.Cells.Border')]
  DNBorder = interface(DDN.mscorlib.DNObject)
  ['{98F782CF-7936-3786-A877-07BBB28D0409}']
  { getters & setters } 

    function get_ThemeColor: DNThemeColor;
    procedure set_ThemeColor(value: DNThemeColor);
    function get_Color: DDN.System.Drawing.DNColor;
    procedure set_Color(value: DDN.System.Drawing.DNColor);
    function get_ArgbColor: Int32;
    procedure set_ArgbColor(value: Int32);
    function get_LineStyle: DNCellBorderType;
    procedure set_LineStyle(value: DNCellBorderType);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets and sets the theme color of the border.
    ///</summary>
    property ThemeColor: DNThemeColor read get_ThemeColor write set_ThemeColor;
    ///<summary>
    ///  Gets or sets the <see cref="T:System.Drawing.Color" />
    ///  of the border.
    ///</summary>
    property Color: DDN.System.Drawing.DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets and sets the color with a 32-bit ARGB value.
    ///</summary>
    property ArgbColor: Int32 read get_ArgbColor write set_ArgbColor;
    ///<summary>
    ///  Gets or sets the cell border type.
    ///</summary>
    property LineStyle: DNCellBorderType read get_LineStyle write set_LineStyle;
  end;

  TDNBorder = class(TDNGenericImport<DNBorderClass, DNBorder>) end;

  //-------------namespace: Aspose.Cells----------------
  DNBorderCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{34D26A30-E514-52E5-A1D4-958EE0ECE8A6}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.Border" />
  ///  objects.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Adding a new worksheet to the Excel object
  ///  workbook.Worksheets.Add();
  ///  //Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Worksheet worksheet = workbook.Worksheets[0];
  ///  //Accessing the "A1" cell from the worksheet
  ///  Cell cell = worksheet.Cells["A1"];
  ///  //Adding some value to the "A1" cell
  ///  cell.PutValue("Visit Aspose!");
  ///  Style style = cell.GetStyle();
  ///  //Setting the line style of the top border
  ///  style.Borders[BorderType.TopBorder].LineStyle = CellBorderType.Thick;
  ///  //Setting the color of the top border
  ///  style.Borders[BorderType.TopBorder].Color = Color.Black;
  ///  //Setting the line style of the bottom border
  ///  style.Borders[BorderType.BottomBorder].LineStyle = CellBorderType.Thick;
  ///  //Setting the color of the bottom border
  ///  style.Borders[BorderType.BottomBorder].Color = Color.Black;
  ///  //Setting the line style of the left border
  ///  style.Borders[BorderType.LeftBorder].LineStyle = CellBorderType.Thick;
  ///  //Setting the color of the left border
  ///  style.Borders[BorderType.LeftBorder].Color = Color.Black;
  ///  //Setting the line style of the right border
  ///  style.Borders[BorderType.RightBorder].LineStyle = CellBorderType.Thick;
  ///  //Setting the color of the right border
  ///  style.Borders[BorderType.RightBorder].Color = Color.Black;
  ///  cell.SetStyle(style);
  ///  //Saving the Excel file
  ///  workbook.Save("C:\\book1.xls");
  ///  [VB.NET]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As Workbook = New Workbook()
  ///  'Adding a new worksheet to the Workbook object
  ///  workbook.Worksheets.Add()
  ///  'Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Dim worksheet As Worksheet = workbook.Worksheets(0)
  ///  'Accessing the "A1" cell from the worksheet
  ///  Dim cell As Cell = worksheet.Cells("A1")
  ///  'Adding some value to the "A1" cell
  ///  cell.PutValue("Visit Aspose!")
  ///  Dim style as Style = cell.GetStyle()
  ///  'Setting the line style of the top border
  ///  style.Borders(BorderType.TopBorder).LineStyle = CellBorderType.Thick
  ///  'Setting the color of the top border
  ///  style.Borders(BorderType.TopBorder).Color = Color.Black
  ///  'Setting the line style of the bottom border
  ///  style.Borders(BorderType.BottomBorder).LineStyle = CellBorderType.Thick
  ///  'Setting the color of the bottom border
  ///  style.Borders(BorderType.BottomBorder).Color = Color.Black
  ///  'Setting the line style of the left border
  ///  style.Borders(BorderType.LeftBorder).LineStyle = CellBorderType.Thick
  ///  'Setting the color of the left border
  ///  style.Borders(BorderType.LeftBorder).Color = Color.Black
  ///  'Setting the line style of the right border
  ///  style.Borders(BorderType.RightBorder).LineStyle = CellBorderType.Thick
  ///  'Setting the color of the right border
  ///  style.Borders(BorderType.RightBorder).Color = Color.Black
  ///  cell.SetStyle(style)
  ///  'Saving the Excel file
  ///  workbook.Save("C:\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.BorderCollection')]
  DNBorderCollection = interface(DDN.mscorlib.DNObject)
  ['{40E2CFD5-3BB5-3861-A2D8-880A13678BDE}']
  { getters & setters } 

    function get_Item(borderType: DNBorderType): DNBorder;
    function get_DiagonalColor: DDN.System.Drawing.DNColor;
    procedure set_DiagonalColor(value: DDN.System.Drawing.DNColor);
    function get_DiagonalStyle: DNCellBorderType;
    procedure set_DiagonalStyle(value: DNCellBorderType);

  { methods } 

    ///<summary>
    ///  Sets the <see cref="T:System.Drawing.Color" />
    ///  of all borders in the collection.
    ///</summary>
    ///  <param name="color">Borders' <see cref="T:System.Drawing.Color" />
    ///  .</param>
    procedure SetColor(color: DDN.System.Drawing.DNColor);
    ///<summary>
    ///  Sets the style of all borders of the collection.
    ///</summary>
    ///  <param name="style">Borders' style</param>
    procedure SetStyle(style: DNCellBorderType);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[borderType: DNBorderType]: DNBorder read get_Item; default;
    ///<summary>
    ///  Gets or sets the <see cref="T:System.Drawing.Color" />
    ///  of Diagonal lines.
    ///</summary>
    property DiagonalColor: DDN.System.Drawing.DNColor read get_DiagonalColor write set_DiagonalColor;
    ///<summary>
    ///  Gets or sets the style of Diagonal lines.
    ///</summary>
    property DiagonalStyle: DNCellBorderType read get_DiagonalStyle write set_DiagonalStyle;
  end;

  TDNBorderCollection = class(TDNGenericImport<DNBorderCollectionClass, DNBorderCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCalculationCellClass = interface(DDN.mscorlib.DNObjectClass)
  ['{3D1E7A5B-B09C-5139-BEBD-A3605841D03D}']
  end;

  ///<summary>
  ///  Represents the calculation relevant data about one cell which is being calculated.
  ///</summary>
  ///<remarks>All objects provided by this class are for "read" purpose only.
  ///  User should not change any data in the Workbook during the formula calculation process,
  ///  Otherwise unexpected result or Exception may be caused.
  ///</remarks>
  [DNTypeName('Aspose.Cells.CalculationCell')]
  DNCalculationCell = interface(DDN.mscorlib.DNObject)
  ['{BB27924D-0E53-36D9-8DBC-509A6D8DDFA9}']
  { getters & setters } 

    function get_Workbook: DNWorkbook;
    function get_Worksheet: DNWorksheet;
    function get_CellRow: Int32;
    function get_CellColumn: Int32;
    function get_Cell: DNCell;

  { methods } 

    ///<summary>
    ///  Sets the calculated value for the cell.
    ///</summary>
    ///<remarks>User can set the calculated result by this method to ignore the automatic calculation for the cell.</remarks>
    procedure SetCalculatedValue(v: DDN.mscorlib.DNObject);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the Workbook object.
    ///</summary>
    property Workbook: DNWorkbook read get_Workbook;
    ///<summary>
    ///  Gets the Worksheet object where the cell is in.
    ///</summary>
    property Worksheet: DNWorksheet read get_Worksheet;
    ///<summary>
    ///  Gets the row index of the cell.
    ///</summary>
    property CellRow: Int32 read get_CellRow;
    ///<summary>
    ///  Gets the column index of the cell.
    ///</summary>
    property CellColumn: Int32 read get_CellColumn;
    ///<summary>
    ///  Gets the Cell object which is being calculated.
    ///</summary>
    property Cell: DNCell read get_Cell;
  end;

  TDNCalculationCell = class(TDNGenericImport<DNCalculationCellClass, DNCalculationCell>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCalculationDataClass = interface(DDN.mscorlib.DNObjectClass)
  ['{910601AA-1AAF-5883-8C78-D3EBC4508A33}']
  end;

  ///<summary>
  ///  Represents the required data when calculating one function, such as function name, parameters, ...etc.
  ///</summary>
  ///<remarks>All objects provided by this class are for "read" purpose only.
  ///  User should not change any data in the Workbook during the formula calculation process,
  ///  Otherwise unexpected result or Exception may be caused.</remarks>
  [DNTypeName('Aspose.Cells.CalculationData')]
  DNCalculationData = interface(DDN.mscorlib.DNObject)
  ['{F4137B84-CBCB-34C7-A7D2-FCA79230A971}']
  { getters & setters } 

    function get_CalculatedValue: DDN.mscorlib.DNObject;
    procedure set_CalculatedValue(value: DDN.mscorlib.DNObject);
    function get_Workbook: DNWorkbook;
    function get_Worksheet: DNWorksheet;
    function get_CellRow: Int32;
    function get_CellColumn: Int32;
    function get_Cell: DNCell;
    function get_FunctionName: string;
    function get_ParamCount: Int32;

  { methods } 

    ///<summary>
    ///  Gets the represented value object of the parameter at given index.
    ///</summary>
    ///  <param name="index">index of the parameter(0 based)</param>
    ///<returns>If the parameter is plain value, then returns the plain value.
    ///  If the parameter is reference, then returns ReferredArea object.
    ///  If the parameter references to multiple datasets, then returns array of objects.</returns>
    function GetParamValue(index: Int32): DDN.mscorlib.DNObject;
    ///<summary>
    ///  Gets the literal text of the parameter at given index.
    ///</summary>
    ///  <param name="index">index of the parameter(0 based)</param>
    ///<returns>literal text of the parameter</returns>
    function GetParamText(index: Int32): string;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the calculated value for this function.
    ///</summary>
    ///<remarks>User should set this property in his custom calculation engine for those functions the engine supports,
    ///  and the set value will be returned when getting this property later.
    ///  The set value can be any value of those objects that can be set to a Cell(Cell.Value).
    ///  And it can also be array of such kind of values, or a Range, Name, ReferredArea.
    ///  Getting this property before setting will make the function be calculated by the default calculation engine of Aspose.Cells and the calculated value will be returned.
    ///</remarks>
    property CalculatedValue: DDN.mscorlib.DNObject read get_CalculatedValue write set_CalculatedValue;
    ///<summary>
    ///  Gets the Workbook object where the function is in.
    ///</summary>
    property Workbook: DNWorkbook read get_Workbook;
    ///<summary>
    ///  Gets the Worksheet object where the function is in.
    ///</summary>
    property Worksheet: DNWorksheet read get_Worksheet;
    ///<summary>
    ///  Gets the row index of the cell where the function is in.
    ///</summary>
    property CellRow: Int32 read get_CellRow;
    ///<summary>
    ///  Gets the column index of the cell where the function is in.
    ///</summary>
    property CellColumn: Int32 read get_CellColumn;
    ///<summary>
    ///  Gets the Cell object where the function is in.
    ///</summary>
    property Cell: DNCell read get_Cell;
    ///<summary>
    ///  Gets the function name to be calculated.
    ///</summary>
    property FunctionName: string read get_FunctionName;
    ///<summary>
    ///  Gets the count of parameters
    ///</summary>
    property ParamCount: Int32 read get_ParamCount;
  end;

  TDNCalculationData = class(TDNGenericImport<DNCalculationDataClass, DNCalculationData>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCalculationOptionsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{A1358E8C-C697-529E-AB16-C453F1BB6CB8}']
  { constructors } 

    {class} function init: DNCalculationOptions;

  end;

  ///<summary>
  ///  Represents options for calculation.
  ///</summary>
  [DNTypeName('Aspose.Cells.CalculationOptions')]
  DNCalculationOptions = interface(DDN.mscorlib.DNObject)
  ['{246947CD-902D-3B14-B7A7-C1F461D870FE}']
  { getters & setters } 

    function get_IgnoreError: Boolean;
    procedure set_IgnoreError(value: Boolean);
    function get_CustomFunction: DNICustomFunction;
    procedure set_CustomFunction(value: DNICustomFunction);
    function get_CustomEngine: DNAbstractCalculationEngine;
    procedure set_CustomEngine(value: DNAbstractCalculationEngine);
    function get_CalculationMonitor: DNAbstractCalculationMonitor;
    procedure set_CalculationMonitor(value: DNAbstractCalculationMonitor);
    function get_CalcStackSize: Int32;
    procedure set_CalcStackSize(value: Int32);
    function get_PrecisionStrategy: DNCalculationPrecisionStrategy;
    procedure set_PrecisionStrategy(value: DNCalculationPrecisionStrategy);
    function get_Recursive: Boolean;
    procedure set_Recursive(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Indicates if you need to hide the error in calculating formulas.
    ///  The error may be unsupported function, external links, etc.
    ///</summary>
    property IgnoreError: Boolean read get_IgnoreError write set_IgnoreError;
    ///<summary>
    ///  The custom formula calculation functions to extend the calculation engine.
    ///</summary>
    ///<remarks>
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use CustomEngine property, AbstractCalculationEngine provides more convenient and flexible APIs
    ///  for manipulating custom functions.
    ///  This property will be removed 12 months later since August 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property CustomFunction: DNICustomFunction read get_CustomFunction write set_CustomFunction;
    ///<summary>
    ///  The custom formula calculation engine to extend the default calculation engine of Aspose.Cells.
    ///</summary>
    property CustomEngine: DNAbstractCalculationEngine read get_CustomEngine write set_CustomEngine;
    ///<summary>
    ///  The monitor for user to track the progress of formula calculation.
    ///</summary>
    property CalculationMonitor: DNAbstractCalculationMonitor read get_CalculationMonitor write set_CalculationMonitor;
    ///<summary>
    ///  Specifies the stack size for calculating cells recursively.
    ///  -1 for this property means the calculation will use WorkbookSettings.CalcStackSize of corresponding workbook.
    ///</summary>
    ///<see cref="P:Aspose.Cells.WorkbookSettings.CalcStackSize" />
    property CalcStackSize: Int32 read get_CalcStackSize write set_CalcStackSize;
    ///<summary>
    ///  Specifies the strategy for processing precision of calculation.
    ///</summary>
    property PrecisionStrategy: DNCalculationPrecisionStrategy read get_PrecisionStrategy write set_PrecisionStrategy;
    ///<summary>
    ///  Indicates whether calculate the dependent cells recursively when calculating one cell and it depends on other cells.
    ///</summary>
    property Recursive: Boolean read get_Recursive write set_Recursive;
  end;

  TDNCalculationOptions = class(TDNGenericImport<DNCalculationOptionsClass, DNCalculationOptions>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCellClass = interface(DDN.mscorlib.DNObjectClass)
  ['{EDC27DD2-0396-5A92-A300-1B781B4B4C73}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents a single Workbook cell.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  Workbook excel = new Workbook();
  ///  Cells cells = excel.Worksheets[0].Cells;
  ///  //Put a string into a cell
  ///  Cell cell = cells[0, 0];
  ///  cell.PutValue("Hello");
  ///  string first = cell.StringValue;
  ///  //Put an integer into a cell
  ///  cell = cells["B1"];
  ///  cell.PutValue(12);
  ///  int second = cell.IntValue;
  ///  //Put a double into a cell
  ///  cell = cells[0, 2];
  ///  cell.PutValue(-1.234);
  ///  double third = cell.DoubleValue;
  ///  //Put a formula into a cell
  ///  cell = cells["D1"];
  ///  cell.Formula = "=B1 + C1";
  ///  //Put a combined formula: "sum(average(b1,c1), b1)" to cell at b2
  ///  cell = cells["b2"];
  ///  cell.Formula = "=sum(average(b1,c1), b1)";
  ///  //Set style of a cell
  ///  Style style = cell.GetStyle();
  ///  //Set background color
  ///  style.BackgroundColor = Color.Yellow;
  ///  //Set format of a cell
  ///  style.Font.Name = "Courier New";
  ///  style.VerticalAlignment = TextAlignmentType.Top;
  ///  cell.SetStyle(style);
  ///  [Visual Basic]
  ///  Dim excel as Workbook = new Workbook()
  ///  Dim cells as Cells = exce.Worksheets(0).Cells
  ///  'Put a string into a cell
  ///  Dim cell as Cell = cells(0, 0)
  ///  cell.PutValue("Hello")
  ///  Dim first as String = cell.StringValue
  ///  //Put an integer into a cell
  ///  cell = cells("B1")
  ///  cell.PutValue(12)
  ///  Dim second as Integer = cell.IntValue
  ///  //Put a double into a cell
  ///  cell = cells(0, 2)
  ///  cell.PutValue(-1.234)
  ///  Dim third as Double = cell.DoubleValue
  ///  //Put a formula into a cell
  ///  cell = cells("D1")
  ///  cell.Formula = "=B1 + C1"
  ///  //Put a combined formula: "sum(average(b1,c1), b1)" to cell at b2
  ///  cell = cells("b2")
  ///  cell.Formula = "=sum(average(b1,c1), b1)"
  ///  //Set style of a cell
  ///  Dim style as Style = cell.GetStyle()
  ///  //Set background color
  ///  style.BackgroundColor = Color.Yellow
  ///  //Set font of a cell
  ///  style.Font.Name = "Courier New"
  ///  style.VerticalAlignment = TextAlignmentType.Top
  ///  cell.SetStyle(style)
  ///</code></example>
  [DNTypeName('Aspose.Cells.Cell')]
  DNCell = interface(DDN.mscorlib.DNObject)
  ['{E899A3E7-C9D3-30F1-8F3A-5EF77E76137D}']
  { getters & setters } 

    function get_Worksheet: DNWorksheet;
    function get_DateTimeValue: DDN.mscorlib.DNDateTime;
    function get_Row: Int32;
    function get_Column: Int32;
    function get_IsFormula: Boolean;
    function get_Type: DNCellValueType;
    function get_Name: string;
    function get_IsErrorValue: Boolean;
    function get_IsNumericValue: Boolean;
    function get_StringValue: string;
    function get_StringValueWithoutFormat: string;
    function get_NumberCategoryType: DNNumberCategoryType;
    function get_DisplayStringValue: string;
    function get_IntValue: Int32;
    function get_DoubleValue: Double;
    function get_FloatValue: Single;
    function get_BoolValue: Boolean;
    function get_SharedStyleIndex: Int32;
    function get_Formula: string;
    procedure set_Formula(value: string);
    function get_FormulaLocal: string;
    procedure set_FormulaLocal(value: string);
    function get_R1C1Formula: string;
    procedure set_R1C1Formula(value: string);
    function get_ContainsExternalLink: Boolean;
    function get_IsArrayHeader: Boolean;
    function get_IsArrayFormula: Boolean;
    function get_IsInArray: Boolean;
    function get_IsSharedFormula: Boolean;
    function get_IsTableFormula: Boolean;
    function get_IsInTable: Boolean;
    function get_Value: DDN.mscorlib.DNObject;
    procedure set_Value(value: DDN.mscorlib.DNObject);
    function get_IsStyleSet: Boolean;
    function get_IsMerged: Boolean;
    function get_Comment: DNComment;
    function get_HtmlString: string;
    procedure set_HtmlString(value: string);

  { methods } 

    ///<summary>
    ///  Sets a formula to a range of cells.
    ///</summary>
    ///  <param name="sharedFormula">Shared formula.</param>
    ///  <param name="rowNumber">Number of rows to populate the formula.</param>
    ///  <param name="columnNumber">Number of columns to populate the formula.</param>
    ///<remarks></remarks>
    procedure SetSharedFormula(sharedFormula: string; rowNumber: Int32; columnNumber: Int32); overload;
    ///<summary>
    ///  Remove array formula.
    ///</summary>
    ///  <param name="leaveNormalFormula">True represents converting the array formula to normal formula.</param>
    procedure RemoveArrayFormula(leaveNormalFormula: Boolean);
    ///<summary>
    ///  Sets an Add-In formula to the cell.
    ///</summary>
    ///  <param name="addInFileName">Add-In file name.</param>
    ///  <param name="addInFunction">Add-In function name.</param>
    ///<example><code>
    ///  [C#]
    ///  cells["h11"].SetAddInFormula("HRVSTTRK.xla", "=pct_overcut(F3:G3)");
    ///  cells["h12"].SetAddInFormula("HRVSTTRK.xla", "=pct_overcut()");
    ///  [Visual Basic]
    ///  cells("h11").SetAddInFormula("HRVSTTRK.xla", "=pct_overcut(F3:G3)")
    ///  cells("h12").SetAddInFormula("HRVSTTRK.xla", "=pct_overcut()")
    ///</code></example><remarks>
    ///  Add-In file should be placed in the directory or sub-directory of Workbook Add-In library.
    ///  For example, file name can be "Eurotool.xla" or "solver\solver.xla".
    ///  NOTE: This class is now obsolete. Instead,
    ///  please use Cell.Formula/Cell.SetFormula() to set cell formula with the Add-In functions after registering it by WorksheetCollection.RegisterAddInFunction().
    ///  This property will be removed 12 months later since January 2019.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</remarks>
    procedure SetAddInFormula(addInFileName: string; addInFunction: string);
    ///<summary>
    ///  Copies data from a source cell.
    ///</summary>
    ///  <param name="cell">Source <see cref="T:Aspose.Cells.Cell" />
    ///  object.</param>
    procedure Copy(cell: DNCell);
    ///<summary>
    ///  Returns a Characters object that represents a range of characters within the cell text.
    ///</summary>
    ///  <param name="startIndex">The index of the start of the character.</param>
    ///  <param name="length">The number of characters.</param>
    ///<returns>Characters object.</returns>
    ///<remarks>This method only works on cell with string value.</remarks>
    ///<example><code>
    ///  [C#]
    ///  excel.Worksheets[0].Cells["A1"].PutValue("Helloworld");
    ///  excel.Worksheets[0].Cells["A1"].Characters(5, 5).Font.IsBold = true;
    ///  excel.Worksheets[0].Cells["A1"].Characters(5, 5).Font.Color = Color.Blue;
    ///  [Visual Basic]
    ///  excel.Worksheets(0).Cells("A1").PutValue("Helloworld")
    ///  excel.Worksheets(0).Cells("A1").Characters(5, 5).Font.IsBold = True
    ///  excel.Worksheets(0).Cells("A1").Characters(5, 5).Font.Color = Color.Blue
    ///</code></example>
    function Characters(startIndex: Int32; length: Int32): DNFontSetting;
    ///<summary>
    ///  Indicates whether the cell string value is a rich text.
    ///</summary>
    function IsRichText: Boolean;
    ///<summary>
    ///  Returns all Characters objects
    ///  that represents a range of characters within the cell text.
    ///</summary>
    ///<returns>All Characters objects </returns>
    function GetCharacters: TArray<DNFontSetting>; overload;
    ///<summary>
    ///  Returns all Characters objects
    ///  that represents a range of characters within the cell text.
    ///</summary>
    ///  <param name="flag">Indicates whether applying table style to the cell if the cell is in the table.</param>
    ///<returns>All Characters objects </returns>
    function GetCharacters(flag: Boolean): TArray<DNFontSetting>; overload;
    ///<summary>
    ///  Sets rich text format of the cell.
    ///</summary>
    ///  <param name="characters">All Characters objects.</param>
    procedure SetCharacters(characters: TArray<DNFontSetting>);
    ///<summary>
    ///  Returns a <see cref="T:Aspose.Cells.Range" />
    ///  object which represents a merged range.
    ///</summary>
    ///<returns><see cref="T:Aspose.Cells.Range" />
    ///  object. Null if this cell is not merged.</returns>
    function GetMergedRange: DNRange;
    ///<summary>
    ///  Gets the html string which contains data and some formats in this cell.
    ///</summary>
    ///  <param name="html5">Indicates whether the value is compatible for html5</param>
    ///<returns></returns>
    function GetHtmlString(html5: Boolean): string;
    ///<summary>
    ///  Returns a string represents the current Cell object.
    ///</summary>
    ///<returns></returns>
    function ToString: string;
    ///<summary>
    ///  Checks whether this object refers to the same cell with another.
    ///</summary>
    ///  <param name="obj">another object</param>
    ///<returns>true if two objects refers to the same cell.</returns>
    function Equals(obj: DDN.mscorlib.DNObject): Boolean; overload;
    ///<summary>
    ///  Serves as a hash function for a particular type.
    ///</summary>
    ///<returns>A hash code for current Cell object.</returns>
    function GetHashCode: Int32;
    ///<summary>
    ///  Checks whether this object refers to the same cell with another cell object.
    ///</summary>
    ///  <param name="cell">another cell object</param>
    ///<returns>true if two cell objects refers to the same cell.</returns>
    function Equals(cell: DNCell): Boolean; overload;
    ///<summary>
    ///  Get the result of the conditional formatting.
    ///</summary>
    ///<remarks>
    ///  Returns null if no conditional formatting is applied to this cell,
    ///</remarks>
    function GetConditionalFormattingResult: DNConditionalFormattingResult;
    ///<summary>
    ///  Gets the validation applied to this cell.
    ///</summary>
    ///<returns></returns>
    function GetValidation: DNValidation;
    ///<summary>
    ///  Gets the value of validation which applied to this cell.
    ///</summary>
    ///<returns></returns>
    function GetValidationValue: Boolean;
    ///<summary>
    ///  Gets the table which contains this cell.
    ///</summary>
    ///<returns></returns>
    function GetTable: DNListObject;
    ///<summary>
    ///  Calculates the formula of the cell.
    ///</summary>
    ///  <param name="options">Options for calculation</param>
    procedure Calculate(options: DNCalculationOptions); overload;
    ///<summary>
    ///  Calculates the formula of the cell.
    ///</summary>
    ///  <param name="ignoreError">Indicates if hide the error in calculating formulas.
    ///  The error may be unsupported function, external links, etc.</param>
    ///  <param name="customFunction">The custom formula calculation functions to extend the calculation engine.</param>
    ///<remarks>
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use Calculate(CalculationOptions) method.
    ///  This method will be removed 12 months later since August 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    procedure Calculate(ignoreError: Boolean; customFunction: DNICustomFunction); overload;
    ///<summary>
    ///  Puts an boolean value into the cell.
    ///</summary>
    ///  <param name="boolValue"></param>
    procedure PutValue(boolValue: Boolean); overload;
    ///<summary>
    ///  Puts an integer value into the cell.
    ///</summary>
    ///  <param name="intValue">Input value</param>
    procedure PutValue(intValue: Int32); overload;
    ///<summary>
    ///  Puts a double value into the cell.
    ///</summary>
    ///  <param name="doubleValue">Input value</param>
    procedure PutValue(doubleValue: Double); overload;
    ///<summary>
    ///  Puts a value into the cell, if appropriate the value will be converted to other data type and cell's number format will be reset.
    ///</summary>
    ///  <param name="stringValue">Input value</param>
    ///  <param name="isConverted">True: converted to other data type if appropriate.</param>
    ///  <param name="setStyle">True: set the number format to cell's style when converting to other data type</param>
    procedure PutValue(stringValue: string; isConverted: Boolean; setStyle: Boolean); overload;
    ///<summary>
    ///  Puts a string value into the cell and converts the value to other data type if appropriate.
    ///</summary>
    ///  <param name="stringValue">Input value</param>
    ///  <param name="isConverted">True: converted to other data type if appropriate.</param>
    procedure PutValue(stringValue: string; isConverted: Boolean); overload;
    ///<summary>
    ///  Puts a string value into the cell.
    ///</summary>
    ///  <param name="stringValue">Input value</param>
    procedure PutValue(stringValue: string); overload;
    ///<summary>
    ///  Puts a DateTime value into the cell.
    ///</summary>
    ///  <param name="dateTime">Input value</param>
    procedure PutValue(dateTime: DDN.mscorlib.DNDateTime); overload;
    ///<summary>
    ///  Puts an object value into the cell.
    ///</summary>
    ///  <param name="objectValue">input value</param>
    procedure PutValue(objectValue: DDN.mscorlib.DNObject); overload;
    ///<summary>
    ///  Gets the string value by specific formatted strategy.
    ///</summary>
    ///  <param name="formatStrategy">The formatted strategy.</param>
    ///<returns></returns>
    function GetStringValue(formatStrategy: DNCellValueFormatStrategy): string;
    ///<summary>
    ///  Gets the width of the value in unit of pixels.
    ///</summary>
    ///<returns></returns>
    function GetWidthOfValue: Int32;
    ///<summary>
    ///  Gets the height of the value in unit of pixels.
    ///</summary>
    ///<returns></returns>
    function GetHeightOfValue: Int32;
    ///<summary>
    ///  Gets the display style of the cell.
    ///  If the cell is conditional formatted, the display style is not same as the cell.GetStyle().
    ///</summary>
    function GetDisplayStyle: DNStyle; overload;
    ///<summary>
    ///  Gets the display style of the cell.
    ///  If the cell is conditional formatted, the display style is not same as the cell.GetStyle().
    ///</summary>
    ///  <param name="includeMergedBorders">Indicates whether checking borders of the merged cells.
    ///</param>
    function GetDisplayStyle(includeMergedBorders: Boolean): DNStyle; overload;
    ///<summary>
    ///  Gets format conditions which applies to this cell.
    ///</summary>
    ///<returns>Returns <see cref="T:Aspose.Cells.FormatConditionCollection" />
    ///  object</returns>
    function GetFormatConditions: TArray<DNFormatConditionCollection>;
    ///<summary>
    ///  Gets the cell style.
    ///</summary>
    ///<returns>Style object.</returns>
    ///<remarks>To change the style of the cell, please call Cell.SetStyle() method after changing the style.
    ///</remarks>
    function GetStyle: DNStyle; overload;
    ///<summary>
    ///  If checkBorders is true, check whether other cells' borders will effect the style of this cell.
    ///</summary>
    ///  <param name="checkBorders">Check other cells' borders</param>
    ///<returns>Style object.</returns>
    ///<remarks></remarks>
    function GetStyle(checkBorders: Boolean): DNStyle; overload;
    ///<summary>
    ///  Sets the cell style.
    ///</summary>
    ///  <param name="style">The cell style.</param>
    ///<remarks>
    ///  If the border settings are changed, the border of adjust cells will be updated too.
    ///</remarks>
    procedure SetStyle(style: DNStyle); overload;
    ///<summary>
    ///  Apply the cell style.
    ///</summary>
    ///  <param name="style">The cell style.</param>
    ///  <param name="explicitFlag">True, only overwriting formatting which is explicitly set.
    ///</param>
    procedure SetStyle(style: DNStyle; explicitFlag: Boolean); overload;
    ///<summary>
    ///  Apply the cell style.
    ///</summary>
    ///  <param name="style">The cell style.</param>
    ///  <param name="flag">The style flag.</param>
    procedure SetStyle(style: DNStyle; flag: DNStyleFlag); overload;
    ///<summary>
    ///  Set the formula and the value of the formula.
    ///</summary>
    ///  <param name="formula">The formula.</param>
    ///  <param name="value">The value of the formula.</param>
    procedure SetFormula(formula: string; value: DDN.mscorlib.DNObject); overload;
    ///<summary>
    ///  Get the formula of this cell.
    ///</summary>
    ///  <param name="isR1C1">Whether the formula needs to be formatted as R1C1.</param>
    ///  <param name="isLocal">Whether the formula needs to be formatted by locale.</param>
    ///<returns>the formula of this cell.</returns>
    function GetFormula(isR1C1: Boolean; isLocal: Boolean): string;
    ///<summary>
    ///  Set the formula and the value of the formula.
    ///</summary>
    ///  <param name="formula">The formula.</param>
    ///  <param name="isR1C1">Whether the formula is R1C1 formula.</param>
    ///  <param name="isLocal">Whether the formula is locale formatted.</param>
    ///  <param name="value">The value of the formula.</param>
    ///<remarks>
    ///  NOTE: This class is now obsolete. Instead,
    ///  please use Cell.SetFormula(string,FormulaParseOptions,object).
    ///  This property will be removed 12 months later since December 2019.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</remarks>
    procedure SetFormula(formula: string; isR1C1: Boolean; isLocal: Boolean; value: DDN.mscorlib.DNObject); overload;
    ///<summary>
    ///  Set the formula and the value of the formula.
    ///</summary>
    ///  <param name="formula">The formula.</param>
    ///  <param name="options">Options for parsing the formula.</param>
    ///  <param name="value">The value of the formula.</param>
    procedure SetFormula(formula: string; options: DNFormulaParseOptions; value: DDN.mscorlib.DNObject); overload;
    ///<summary>
    ///  Sets an array formula to a range of cells.
    ///</summary>
    ///  <param name="arrayFormula">Array formula.</param>
    ///  <param name="rowNumber">Number of rows to populate result of the array formula.</param>
    ///  <param name="columnNumber">Number of columns to populate result of the array formula.</param>
    ///  <param name="isR1C1">whether the formula is R1C1 formula</param>
    ///  <param name="isLocal">whether the formula is locale formatted</param>
    ///<remarks>
    ///  NOTE: This class is now obsolete. Instead,
    ///  please use Cell.SetArrayFormula(string,int,int,FormulaParseOptions).
    ///  This property will be removed 12 months later since December 2019.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</remarks>
    procedure SetArrayFormula(arrayFormula: string; rowNumber: Int32; columnNumber: Int32; isR1C1: Boolean; isLocal: Boolean); overload;
    ///<summary>
    ///  Sets an array formula to a range of cells.
    ///</summary>
    ///  <param name="arrayFormula">Array formula.</param>
    ///  <param name="rowNumber">Number of rows to populate result of the array formula.</param>
    ///  <param name="columnNumber">Number of columns to populate result of the array formula.</param>
    ///  <param name="options">Options for parsing the formula.</param>
    procedure SetArrayFormula(arrayFormula: string; rowNumber: Int32; columnNumber: Int32; options: DNFormulaParseOptions); overload;
    procedure SetArrayFormula(arrayFormula: string; rowNumber: Int32; columnNumber: Int32; options: DNFormulaParseOptions; values: TArray<TArray<DDN.mscorlib.DNObject>>); overload;
    ///<summary>
    ///  Sets a formula to a range of cells.
    ///</summary>
    ///  <param name="sharedFormula">Shared formula.</param>
    ///  <param name="rowNumber">Number of rows to populate the formula.</param>
    ///  <param name="columnNumber">Number of columns to populate the formula.</param>
    ///  <param name="isR1C1">whether the formula is R1C1 formula</param>
    ///  <param name="isLocal">whether the formula is locale formatted</param>
    ///<remarks>
    ///  NOTE: This class is now obsolete. Instead,
    ///  please use Cell.SetSharedFormula(string,int,int,FormulaParseOptions).
    ///  This property will be removed 12 months later since December 2019.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</remarks>
    procedure SetSharedFormula(sharedFormula: string; rowNumber: Int32; columnNumber: Int32; isR1C1: Boolean; isLocal: Boolean); overload;
    ///<summary>
    ///  Sets a formula to a range of cells.
    ///</summary>
    ///  <param name="sharedFormula">Shared formula.</param>
    ///  <param name="rowNumber">Number of rows to populate the formula.</param>
    ///  <param name="columnNumber">Number of columns to populate the formula.</param>
    ///  <param name="options">Options for parsing the formula.</param>
    procedure SetSharedFormula(sharedFormula: string; rowNumber: Int32; columnNumber: Int32; options: DNFormulaParseOptions); overload;
    procedure SetSharedFormula(sharedFormula: string; rowNumber: Int32; columnNumber: Int32; options: DNFormulaParseOptions; values: TArray<TArray<DDN.mscorlib.DNObject>>); overload;
    ///<summary>
    ///  Gets all cells or ranges which this cell's formula depends on.
    ///</summary>
    ///<returns>
    ///  Returns all cells or ranges.
    ///</returns>
    ///<remarks>Returns null if this is not a formula cell.</remarks>
    ///<example><code>
    ///  [C#]
    ///  Workbook workbook = new Workbook();
    ///  Cells cells = workbook.Worksheets[0].Cells;
    ///  cells["A1"].Formula = "= B1 + SUM(B1:B10) + [Book1.xls]Sheet1!A1";
    ///  ReferredAreas areas = cells["A1"].GetPrecedents();
    ///  for (int i = 0; i &lt; areas.Count; i++)
    ///  {
    ///  ReferredArea area = areas[i];
    ///  StringBuilder stringBuilder = new StringBuilder();
    ///  if (area.IsExternalLink)
    ///  {
    ///  stringBuilder.Append("[");
    ///  stringBuilder.Append(area.ExternalFileName);
    ///  stringBuilder.Append("]");
    ///  }
    ///  stringBuilder.Append(area.SheetName);
    ///  stringBuilder.Append("!");
    ///  stringBuilder.Append(CellsHelper.CellIndexToName(area.StartRow, area.StartColumn));
    ///  if (area.IsArea)
    ///  {
    ///  stringBuilder.Append(":");
    ///  stringBuilder.Append(CellsHelper.CellIndexToName(area.EndRow, area.EndColumn));
    ///  }
    ///  Console.WriteLine(stringBuilder.ToString());
    ///  }
    ///  workbook.Save(@"C:\Book2.xls");
    ///  [Visual Basic]
    ///  Dim workbook As Workbook = New Workbook()
    ///  Dim cells As Cells = workbook.Worksheets(0).Cells
    ///  cells("A1").Formula = "= B1 + SUM(B1:B10) + [Book1.xls]Sheet1!A1"
    ///  Dim areas As ReferredAreas = cells("A1").GetPrecedents()
    ///  For i As Integer = 0 To areas.Count - 1
    ///  Dim area As ReferredArea = areas(i)
    ///  Dim stringBuilder As StringBuilder = New StringBuilder()
    ///  If (area.IsExternalLink) Then
    ///  stringBuilder.Append("[")
    ///  stringBuilder.Append(area.ExternalFileName)
    ///  stringBuilder.Append("]")
    ///  End If
    ///  stringBuilder.Append(area.SheetName)
    ///  stringBuilder.Append("!")
    ///  stringBuilder.Append(CellsHelper.CellIndexToName(area.StartRow, area.StartColumn))
    ///  If (area.IsArea) Then
    ///  stringBuilder.Append(":")
    ///  stringBuilder.Append(CellsHelper.CellIndexToName(area.EndRow, area.EndColumn))
    ///  End If
    ///  Console.WriteLine(stringBuilder.ToString())
    ///  Next
    ///  workbook.Save("C:\Book2.xls")
    ///</code></example>
    function GetPrecedents: DNReferredAreaCollection;
    ///<summary>
    ///  Get all cells which refer to the specific cell.
    ///</summary>
    ///  <param name="isAll">Indicates whether check other worksheets</param>
    function GetDependents(isAll: Boolean): TArray<DNCell>;
    ///<summary>
    ///  Get all cells which will be updated when this cell is modified.
    ///  This method can only work after calling Workbook.CalculateFormula
    ///  with WorkbookSettings.CreateCalcChain of value true.
    ///</summary>
    function GetLeafs: DDN.mscorlib.DNIEnumerator;
    ///<summary>
    ///  Gets the array range if the cell's formula is an array formula.
    ///</summary>
    ///<returns>
    ///  The array range.
    ///</returns>
    ///<remarks>Only applies when the cell's formula is an array formula</remarks>
    function GetArrayRange: DNCellArea;
    ///<summary>
    ///  Sets dynamic array formula and make the formula spill into neighboring cells if possible.
    ///</summary>
    ///  <param name="arrayFormula">the formula expression</param>
    ///  <param name="options">options to parse formula.
    ///  "Parse" option will be ignored and the formula will always be parsed immediately</param>
    ///  <param name="calculate">Whether calculate this dynamic array formula for those cells in the spilled range.</param>
    ///<returns>the range that the formula should spill into.</returns>
    function SetDynamicArrayFormula(arrayFormula: string; options: DNFormulaParseOptions; calculateValue: Boolean): DNCellArea; overload;
    function SetDynamicArrayFormula(arrayFormula: string; options: DNFormulaParseOptions; values: TArray<TArray<DDN.mscorlib.DNObject>>; calculateRange: Boolean; calculateValue: Boolean): DNCellArea; overload;
    ///<summary>
    ///  Sets an array formula(legacy array formula entered via CTRL+SHIFT+ENTER in ms excel) to a range of cells.
    ///</summary>
    ///  <param name="arrayFormula">Array formula.</param>
    ///  <param name="rowNumber">Number of rows to populate result of the array formula.</param>
    ///  <param name="columnNumber">Number of columns to populate result of the array formula.</param>
    procedure SetArrayFormula(arrayFormula: string; rowNumber: Int32; columnNumber: Int32); overload;
    function GetType: DDN.mscorlib.DNType;

  { propertys } 

    ///<summary>
    ///  Gets the parent worksheet.
    ///</summary>
    property Worksheet: DNWorksheet read get_Worksheet;
    ///<summary>
    ///  Gets the DateTime value contained in the cell.
    ///</summary>
    property DateTimeValue: DDN.mscorlib.DNDateTime read get_DateTimeValue;
    ///<summary>
    ///  Gets row number (zero based) of the cell.
    ///</summary>
    ///<value>Cell row number</value>
    property Row: Int32 read get_Row;
    ///<summary>
    ///  Gets column number (zero based) of the cell.
    ///</summary>
    property Column: Int32 read get_Column;
    ///<summary>
    ///  Represents if the specified cell contains formula.
    ///</summary>
    property IsFormula: Boolean read get_IsFormula;
    ///<summary>
    ///  Represents cell value type.
    ///</summary>
    property &Type: DNCellValueType read get_Type;
    ///<summary>
    ///  Gets the name of the cell.
    ///</summary>
    ///<remarks>
    ///  A cell name includes its column letter and row number. For example, the name of a cell in row 0 and column 0 is A1.
    ///</remarks>
    property Name: string read get_Name;
    ///<summary>
    ///  Checks if a formula can properly evaluate a result.
    ///</summary>
    ///<remarks>Only applies to formula cell.</remarks>
    property IsErrorValue: Boolean read get_IsErrorValue;
    property IsNumericValue: Boolean read get_IsNumericValue;
    ///<summary>
    ///  Gets the string value contained in the cell. If the type of this cell is string, then return the string value itself.
    ///  For other cell types, the formatted string value (formatted with the specified style of this cell) will be returned.
    ///  The formatted cell value is same with what you can get from excel when copying a cell as text(such as
    ///  copying cell to text editor or exporting to csv).
    ///</summary>
    property StringValue: string read get_StringValue;
    ///<summary>
    ///  Gets cell's value as string without any format.
    ///</summary>
    ///<remarks>
    ///  NOTE: This class is now obsolete. Instead,
    ///  User should get the value object and format it according to the value type and the specific requirement.
    ///  This property will be removed 12 months later since December 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</remarks>
    property StringValueWithoutFormat: string read get_StringValueWithoutFormat;
    ///<summary>
    ///  Represents the category type of this cell's number formatting.
    ///</summary>
    property NumberCategoryType: DNNumberCategoryType read get_NumberCategoryType;
    ///<summary>
    ///  Gets the formatted string value of this cell.
    ///</summary>
    property DisplayStringValue: string read get_DisplayStringValue;
    ///<summary>
    ///  Gets the integer value contained in the cell.
    ///</summary>
    property IntValue: Int32 read get_IntValue;
    ///<summary>
    ///  Gets the double value contained in the cell.
    ///</summary>
    property DoubleValue: Double read get_DoubleValue;
    ///<summary>
    ///  Gets the float value contained in the cell.
    ///</summary>
    property FloatValue: Single read get_FloatValue;
    ///<summary>
    ///  Gets the boolean value contained in the cell.
    ///</summary>
    property BoolValue: Boolean read get_BoolValue;
    ///<summary>
    ///  Gets cell's shared style index in the style pool.
    ///</summary>
    property SharedStyleIndex: Int32 read get_SharedStyleIndex;
    ///<summary>
    ///  Gets or sets a formula of the <see cref="T:Aspose.Cells.Cell" />
    ///  .
    ///</summary>
    ///<remarks>A formula string always begins with an equal sign (=).
    ///  And please always use comma(,) as parameters delimiter, such as "=SUM(A1, E1, H2)".
    ///</remarks>
    ///<example><code>
    ///  [C#]
    ///  Workbook excel = new Workbook();
    ///  Cells cells = excel.Worksheets[0];
    ///  cells["B6"].Formula = "=SUM(B2:B5, E1) + sheet1!A1";
    ///  [Visual Basic]
    ///  Dim excel As Workbook =  New Workbook()
    ///  Dim cells As Cells =  excel.Worksheets(0)
    ///  cells("B6").Formula = "=SUM(B2:B5, E1) + sheet1!A1"
    ///</code></example>
    property Formula: string read get_Formula write set_Formula;
    ///<summary>
    ///  Get the locale formatted formula of the cell.
    ///</summary>
    property FormulaLocal: string read get_FormulaLocal write set_FormulaLocal;
    ///<summary>
    ///  Gets or sets a R1C1 formula of the <see cref="T:Aspose.Cells.Cell" />
    ///  .
    ///</summary>
    property R1C1Formula: string read get_R1C1Formula write set_R1C1Formula;
    ///<summary>
    ///  Indicates whether this cell contains an external link.
    ///  Only applies when the cell is a formula cell.
    ///</summary>
    property ContainsExternalLink: Boolean read get_ContainsExternalLink;
    ///<summary>
    ///  Indicates the cell's formula is and array formula
    ///  and it is the first cell of the array.
    ///</summary>
    property IsArrayHeader: Boolean read get_IsArrayHeader;
    ///<summary>
    ///  Indicates whether the cell formula is an array formula.
    ///</summary>
    property IsArrayFormula: Boolean read get_IsArrayFormula;
    ///<summary>
    ///  Indicates whether the cell formula is an array formula.
    ///</summary>
    ///<remarks>
    ///  NOTE: This class is now obsolete. Instead,
    ///  please use Cell.IsArrayFormula to check whether the cell formula is an array formula.
    ///  This property will be removed 12 months later since May 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</remarks>
    property IsInArray: Boolean read get_IsInArray;
    ///<summary>
    ///  Indicates whether the cell formula is part of shared formula.
    ///</summary>
    property IsSharedFormula: Boolean read get_IsSharedFormula;
    ///<summary>
    ///  Indicates whether this cell is part of table formula.
    ///</summary>
    property IsTableFormula: Boolean read get_IsTableFormula;
    ///<summary>
    ///  Indicates whether this cell is part of table formula.
    ///</summary>
    ///<remarks>
    ///  NOTE: This class is now obsolete. Instead,
    ///  please use Cell.IsTableFormula to check whether the cell formula is part of table formula.
    ///  This property will be removed 12 months later since May 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.
    ///</remarks>
    property IsInTable: Boolean read get_IsInTable;
    ///<summary>
    ///  Gets the value contained in this cell.
    ///</summary>
    ///<remarks>Possible type:
    ///  <p>null,</p>
    ///  <p>Boolean,</p>
    ///  <p>DateTime,</p>
    ///  <p>Double,</p>
    ///  <p>Integer</p>
    ///  <p>String.</p>
    ///  For int value, it may be returned as an Integer object or a Double object.
    ///  And there is no guarantee that the returned value will be kept as the same type of object always.
    ///</remarks>
    property Value: DDN.mscorlib.DNObject read get_Value write set_Value;
    ///<summary>
    ///  Indicates if the cell's style is set. If return false, it means this cell has a default cell format.
    ///</summary>
    property IsStyleSet: Boolean read get_IsStyleSet;
    ///<summary>
    ///  Checks if a cell is part of a merged range or not.
    ///</summary>
    property IsMerged: Boolean read get_IsMerged;
    ///<summary>
    ///  Gets the comment of this cell.
    ///</summary>
    ///<remarks>
    ///  If there is no comment applies to the cell, returns null.
    ///</remarks>
    property Comment: DNComment read get_Comment;
    ///<summary>
    ///  Gets and sets the html string which contains data and some formats in this cell.
    ///</summary>
    property HtmlString: string read get_HtmlString write set_HtmlString;
  end;

  TDNCell = class(TDNGenericImport<DNCellClass, DNCell>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCellsClass = interface(DNObjectClass)
  ['{138E5E0F-4D8E-50C3-9889-57E4A0C361B4}']
  end;

  ///<summary>
  ///  Encapsulates a collection of cell relevant objects, such as <see cref="T:Aspose.Cells.Cell" />
  ///  , <see cref="T:Aspose.Cells.Row" />
  ///  , ...etc.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  Workbook excel = new Workbook();
  ///  Cells cells = excel.Worksheets[0].Cells;
  ///  //Set default row height
  ///  cells.StandardHeight = 20;
  ///  //Set row height
  ///  cells.SetRowHeight(2, 20.5);
  ///  //Set default colum width
  ///  cells.StandardWidth = 15;
  ///  //Set column width
  ///  cells.SetColumnWidth(3, 12.57);
  ///  //Merge cells
  ///  cells.Merge(5, 4, 2, 2);
  ///  //Import data
  ///  DataTable dt = new DataTable("Products");
  ///  dt.Columns.Add("Product_ID",typeof(Int32));
  ///  dt.Columns.Add("Product_Name",typeof(string));
  ///  dt.Columns.Add("Units_In_Stock",typeof(Int32));
  ///  DataRow dr = dt.NewRow();
  ///  dr[0] = 1;
  ///  dr[1] = "Aniseed Syrup";
  ///  dr[2] = 15;
  ///  dt.Rows.Add(dr);
  ///  dr = dt.NewRow();
  ///  dr[0] = 2;
  ///  dr[1] = "Boston Crab Meat";
  ///  dr[2] = 123;
  ///  dt.Rows.Add(dr);
  ///  cells.ImportDataTable(dt, true, 12, 12, 10, 10);
  ///  //Export data
  ///  DataTable outDataTable = cells.ExportDataTable(12, 12, 10, 10);
  ///  [Visual Basic]
  ///  Dim excel as Workbook = new Workbook()
  ///  Dim cells as Cells = excel.Worksheets(0).Cells
  ///  'Set default row height
  ///  cells.StandardHeight = 20
  ///  'Set row height
  ///  cells.SetRowHeight(2, 20.5)
  ///  'Set default colum width
  ///  cells.StandardWidth = 15
  ///  'Set column width
  ///  cells.SetColumnWidth(3, 12.57)
  ///  'Merge cells
  ///  cells.Merge(5, 4, 2, 2)
  ///  'Import data
  ///  Dim dt as DataTable = new DataTable("Employee")
  ///  dt.Columns.Add("Employee_ID",typeof(Int32))
  ///  dt.Columns.Add("Employee_Name",typeof(string))
  ///  dt.Columns.Add("Gender",typeof(string))
  ///  Dim dr as DataRow = dt.NewRow()
  ///  dr(0) = 1
  ///  dr(1) = "John Smith"
  ///  dr(2) = "Male"
  ///  dt.Rows.Add(dr)
  ///  dr = dt.NewRow()
  ///  dr(0) = 2
  ///  dr(1) = "Mary Miller"
  ///  dr(2) = "Female"
  ///  dt.Rows.Add(dr)
  ///  cells.ImportDataTable(dt, true, 12, 12, 10, 10)
  ///  'Export data
  ///  Dim outDataTable as DataTable = cells.ExportDataTable(12, 12, 10, 10)
  ///</code></example>
  [DNTypeName('Aspose.Cells.Cells')]
  DNCells = interface(DDN.mscorlib.DNIDisposable)
  ['{A0A589A5-EBCD-3D6B-A80E-5472CE8E8BDB}']
  { getters & setters } 

    function get_OdsCellFields: DNOdsCellFieldCollection;
    function get_Count: Int32;
    function get_CountLarge: Int64;
    function get_Item(index: Int32): DNCell; overload;
    function get_Rows: DNRowCollection;
    function get_MergedCells: DDN.mscorlib.DNArrayList;
    function get_Item(row: Int32; column: Int32): DNCell; overload;
    function get_Item(cellName: string): DNCell; overload;
    function get_MultiThreadReading: Boolean;
    procedure set_MultiThreadReading(value: Boolean);
    function get_MemorySetting: DNMemorySetting;
    procedure set_MemorySetting(value: DNMemorySetting);
    function get_Style: DNStyle;
    procedure set_Style(value: DNStyle);
    function get_StandardWidthInch: Double;
    procedure set_StandardWidthInch(value: Double);
    function get_StandardWidthPixels: Int32;
    procedure set_StandardWidthPixels(value: Int32);
    function get_StandardWidth: Double;
    procedure set_StandardWidth(value: Double);
    function get_StandardHeight: Double;
    procedure set_StandardHeight(value: Double);
    function get_StandardHeightPixels: Int32;
    procedure set_StandardHeightPixels(value: Int32);
    function get_PreserveString: Boolean;
    procedure set_PreserveString(value: Boolean);
    function get_MinRow: Int32;
    function get_MaxRow: Int32;
    function get_MinColumn: Int32;
    function get_MaxColumn: Int32;
    function get_MinDataRow: Int32;
    function get_MaxDataRow: Int32;
    function get_MinDataColumn: Int32;
    function get_MaxDataColumn: Int32;
    function get_IsDefaultRowHeightMatched: Boolean;
    procedure set_IsDefaultRowHeightMatched(value: Boolean);
    function get_IsDefaultRowHidden: Boolean;
    procedure set_IsDefaultRowHidden(value: Boolean);
    function get_Columns: DNColumnCollection;
    function get_Ranges: DNRangeCollection;
    function get_LastCell: DNCell;
    function get_MaxDisplayRange: DNRange;
    function get_FirstCell: DNCell;

  { methods } 

    ///<remarks>
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataView,int,int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since November 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataView(dataView: DDN.System.Data.DNDataView; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataView" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataView">The <see cref="T:System.Data.DataView" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataView,int,int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since November 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataView(dataView: DDN.System.Data.DNDataView; firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataView" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataView">The <see cref="T:System.Data.DataView" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataView,int,int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since November 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataView(dataView: DDN.System.Data.DNDataView; firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataView" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataView">The <see cref="T:System.Data.DataView" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data view will be imported to the first row.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataView,int,int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since November 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataView(dataView: DDN.System.Data.DNDataView; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataView" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataView">The <see cref="T:System.Data.DataView" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data view will be imported to the first row.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="rowNumber">Number of rows to be imported.</param>
    ///  <param name="columnNumber">Number of columns to be imported.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="numberFormatString">Number format string for cells.</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataView,int,int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since November 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataView(dataView: DDN.System.Data.DNDataView; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; rowNumber: Int32; columnNumber: Int32; insertRows: Boolean; numberFormatString: string): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataView" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataView">The <see cref="T:System.Data.DataView" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data view will be imported to the first row.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataView,int,int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since November 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataView(dataView: DDN.System.Data.DNDataView; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  into a worksheet. This method doesn't try to convert text into numeric values.
    ///</summary>
    ///  <param name="dataGrid">The <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported</returns>
    function ImportDataGridAsString(dataGrid: DDN.System.Web.DNDataGrid; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32;
    ///<summary>
    ///  Imports a grid view to this cells.
    ///</summary>
    ///  <param name="gridView">The grid view object.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="options">import options.</param>
    ///<returns>The row number.</returns>
    function ImportGridView(gridView: DDN.System.Web.DNGridView; firstRow: Int32; firstColumn: Int32; options: DNImportTableOptions): Int32;
    ///<summary>
    ///  Imports a <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataGrid">The <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported</returns>
    function ImportDataGrid(dataGrid: DDN.System.Web.DNDataGrid; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataGrid">The <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported</returns>
    function ImportDataGrid(dataGrid: DDN.System.Web.DNDataGrid; firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataGrid">The <see cref="T:System.Web.UI.WebControls.DataGrid" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="importStyle">Indicates whether importing the cell style.</param>
    ///<returns>Total number of rows imported</returns>
    function ImportDataGrid(dataGrid: DDN.System.Web.DNDataGrid; firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32; insertRows: Boolean; importStyle: Boolean): Int32; overload;
    ///<summary>
    ///  Finds the cell with the input string.
    ///</summary>
    ///  <param name="formula">The formula to search for.</param>
    ///  <param name="previousCell">Previous cell with the same formula. This parameter can be set to null if searching from the start.</param>
    ///<returns>Cell object.</returns>
    ///<remarks>Returns null (Nothing) if no cell is found.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use Cells.Find(object,Cell,FindOptions) method with LookInType as LookInType.OnlyFormulas
    ///  and LookAtType as LookAtType.EntireContent.
    ///  This member will be removed 12 months later since November 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function FindFormula(formula: string; previousCell: DNCell): DNCell;
    ///<summary>
    ///  Finds the cell with formula which contains the input string.
    ///</summary>
    ///  <param name="formula">The formula to search for.</param>
    ///  <param name="previousCell">Previous cell with the same formula. This parameter can be set to null if searching from the start.</param>
    ///<returns>Cell object.</returns>
    ///<remarks>Returns null (Nothing) if no cell is found.
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use Cells.Find(object,Cell,FindOptions) method with LookInType as LookInType.OnlyFormulas
    ///  and LookAtType as LookAtType.Contains.
    ///  This member will be removed 12 months later since November 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function FindFormulaContains(formula: string; previousCell: DNCell): DNCell;
    ///<summary>
    ///  Finds the cell containing with the input object.
    ///</summary>
    ///  <param name="what">The object to search for.
    ///  The type should be int,double,DateTime,string,bool.
    ///</param>
    ///  <param name="previousCell">Previous cell with the same object.
    ///  This parameter can be set to null if searching from the start.</param>
    ///<returns>Cell object.</returns>
    ///<remarks>Returns null (Nothing) if no cell is found.</remarks>
    function Find(what: DDN.mscorlib.DNObject; previousCell: DNCell): DNCell; overload;
    ///<summary>
    ///  Finds the cell containing with the input object.
    ///</summary>
    ///  <param name="what">The object to search for.
    ///  The type should be int,double,DateTime,string,bool.
    ///</param>
    ///  <param name="previousCell">Previous cell with the same object.
    ///  This parameter can be set to null if searching from the start.</param>
    ///  <param name="findOptions">Find options</param>
    ///<returns>Cell object.</returns>
    ///<remarks>Returns null (Nothing) if no cell is found.</remarks>
    function Find(what: DDN.mscorlib.DNObject; previousCell: DNCell; findOptions: DNFindOptions): DNCell; overload;
    ///<summary>
    ///  Gets the last cell in this row.
    ///</summary>
    ///  <param name="rowIndex">Row index.</param>
    ///<returns>Cell object.</returns>
    function EndCellInRow(rowIndex: Int32): DNCell; overload;
    ///<summary>
    ///  Gets the last cell in this column.
    ///</summary>
    ///  <param name="columnIndex">Column index.</param>
    ///<returns>Cell object.</returns>
    function EndCellInColumn(columnIndex: Int16): DNCell; overload;
    ///<summary>
    ///  Gets the last cell with maximum column index in this range.
    ///</summary>
    ///  <param name="startRow">Start row index.</param>
    ///  <param name="endRow">End row index.</param>
    ///  <param name="startColumn">Start column index.</param>
    ///  <param name="endColumn">End column index.</param>
    ///<returns>Cell object.</returns>
    function EndCellInColumn(startRow: Int32; endRow: Int32; startColumn: Int16; endColumn: Int16): DNCell; overload;
    ///<summary>
    ///  Gets the last cell with maximum row index in this range.
    ///</summary>
    ///  <param name="startRow">Start row index.</param>
    ///  <param name="endRow">End row index.</param>
    ///  <param name="startColumn">Start column index.</param>
    ///  <param name="endColumn">End column index.</param>
    ///<returns>Cell object.</returns>
    function EndCellInRow(startRow: Int32; endRow: Int32; startColumn: Int32; endColumn: Int32): DNCell; overload;
    ///<summary>
    ///  Moves the range.
    ///</summary>
    ///  <param name="sourceArea">The range which should be moved.</param>
    ///  <param name="destRow">The dest row.</param>
    ///  <param name="destColumn">The dest column.</param>
    procedure MoveRange(sourceArea: DNCellArea; destRow: Int32; destColumn: Int32);
    ///<summary>
    ///  Insert cut range.
    ///</summary>
    ///  <param name="cutRange">The cut range.</param>
    ///  <param name="row">The row.</param>
    ///  <param name="column">The column.</param>
    ///  <param name="shiftType">The shift type .</param>
    procedure InsertCutCells(cutRange: DNRange; row: Int32; column: Int32; shiftType: DNShiftType);
    ///<summary>
    ///  Inserts a range of cells and shift cells according to the shift option.
    ///</summary>
    ///  <param name="area">Shift area.</param>
    ///  <param name="shiftNumber">Number of rows or columns to be inserted.</param>
    ///  <param name="shiftType">Shift cells option.</param>
    ///  <param name="updateReference">Indicates if update references in other worksheets.</param>
    procedure InsertRange(area: DNCellArea; shiftNumber: Int32; shiftType: DNShiftType; updateReference: Boolean); overload;
    ///<summary>
    ///  Inserts a range of cells and shift cells according to the shift option.
    ///</summary>
    ///  <param name="area">Shift area.</param>
    ///  <param name="shiftType">Shift cells option.</param>
    procedure InsertRange(area: DNCellArea; shiftType: DNShiftType); overload;
    ///<summary>
    ///  Inserts a range of cells and shift cells according to the shift option.
    ///</summary>
    ///  <param name="area">Shift area.</param>
    ///  <param name="shiftNumber">Number of rows or columns to be inserted.</param>
    ///  <param name="shiftType">Shift cells option.</param>
    procedure InsertRange(area: DNCellArea; shiftNumber: Int32; shiftType: DNShiftType); overload;
    ///<summary>
    ///  Deletes a range of cells and shift cells according to the shift option.
    ///</summary>
    ///  <param name="startRow">Start row index.</param>
    ///  <param name="startColumn">Start column index.</param>
    ///  <param name="endRow">End row index.</param>
    ///  <param name="endColumn">End column index.</param>
    ///  <param name="shiftType">Shift cells option.</param>
    procedure DeleteRange(startRow: Int32; startColumn: Int32; endRow: Int32; endColumn: Int32; shiftType: DNShiftType);
    ///<summary>
    ///  Exports data in the <see cref="T:Aspose.Cells.Cells" />
    ///  collection to a two-dimension array object.
    ///</summary>
    ///  <param name="firstRow">The row number of the first cell to export out.</param>
    ///  <param name="firstColumn">The column number of the first cell to export out.</param>
    ///  <param name="totalRows">Number of rows to be exported</param>
    ///  <param name="totalColumns">Number of columns to be exported</param>
    ///<returns>Exported cell value array object.</returns>
    function ExportArray(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32): TArray<DDN.mscorlib.DNObject>;
    ///<summary>
    ///  Exports cell value type in the <see cref="T:Aspose.Cells.Cells" />
    ///  collection to a two-dimension array object.
    ///</summary>
    ///  <param name="firstRow">The row number of the first cell to export out.</param>
    ///  <param name="firstColumn">The column number of the first cell to export out.</param>
    ///  <param name="totalRows">Number of rows to be exported.</param>
    ///  <param name="totalColumns">Number of columns to be exported.</param>
    ///<returns>Exported <see cref="T:Aspose.Cells.CellValueType" />
    ///  array object.</returns>
    function ExportTypeArray(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32): TArray<DNCellValueType>;
    ///<summary>
    ///  Imports custom objects.
    ///</summary>
    ///  <param name="list">The custom object</param>
    ///  <param name="propertyNames">The property names.If it is null,we will import all properties of the object.</param>
    ///  <param name="isPropertyNameShown">
    ///  Indicates whether the property name will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="rowNumber">Number of rows to be imported.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="dateFormatString">Date format string for cells.</param>
    ///  <param name="convertStringToNumber">Indicates if this method will try to convert string to number.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>The custom objects should be the same type.</remarks>
    function ImportCustomObjects(list: DDN.mscorlib.DNICollection; propertyNames: TArray<string>; isPropertyNameShown: Boolean; firstRow: Int32; firstColumn: Int32; rowNumber: Int32; insertRows: Boolean; dateFormatString: string; convertStringToNumber: Boolean): Int32; overload;
    ///<summary>
    ///  Imports custom objects.
    ///</summary>
    ///  <param name="list">The custom object</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="options"> The import options.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>The custom objects should be the same type.</remarks>
    function ImportCustomObjects(list: DDN.mscorlib.DNICollection; firstRow: Int32; firstColumn: Int32; options: DNImportTableOptions): Int32; overload;
    ///<summary>
    ///  Retrieves subtotals setting of the range.
    ///</summary>
    ///  <param name="ca">The range</param>
    ///<returns></returns>
    function RetrieveSubtotalSetting(ca: DNCellArea): DNSubtotalSetting;
    ///<summary>
    ///  Creates subtotals for the range.
    ///</summary>
    ///  <param name="ca">The range</param>
    ///  <param name="groupBy">The field to group by, as a zero-based integer offset</param>
    ///  <param name="function">The subtotal function.</param>
    ///  <param name="totalList">An array of zero-based field offsets, indicating the fields to which the subtotals are added.</param>
    procedure Subtotal(ca: DNCellArea; groupBy: Int32; &function: DNConsolidationFunction; totalList: TArray<Int32>); overload;
    ///<summary>
    ///  Creates subtotals for the range.
    ///</summary>
    ///  <param name="ca">The range</param>
    ///  <param name="groupBy">The field to group by, as a zero-based integer offset</param>
    ///  <param name="function">The subtotal function.</param>
    ///  <param name="totalList">An array of zero-based field offsets, indicating the fields to which the subtotals are added.</param>
    ///  <param name="replace">Indicates whether replace the current subtotals</param>
    ///  <param name="pageBreaks">Indicates whether add page break between groups</param>
    ///  <param name="summaryBelowData">Indicates whether add summary below data.</param>
    procedure Subtotal(ca: DNCellArea; groupBy: Int32; &function: DNConsolidationFunction; totalList: TArray<Int32>; replace: Boolean; pageBreaks: Boolean; summaryBelowData: Boolean); overload;
    ///<summary>
    ///  Removes all formula and replaces with the value of the formula.
    ///</summary>
    procedure RemoveFormulas;
    ///<summary>
    ///  Removes duplicate rows in the sheet.
    ///</summary>
    procedure RemoveDuplicates; overload;
    ///<summary>
    ///  Removes duplicate values in the range.
    ///</summary>
    ///  <param name="startRow">The start row.</param>
    ///  <param name="startColumn">The start column</param>
    ///  <param name="endRow">The end row index.</param>
    ///  <param name="endColumn">The end column index.</param>
    procedure RemoveDuplicates(startRow: Int32; startColumn: Int32; endRow: Int32; endColumn: Int32); overload;
    ///<summary>
    ///  Removes duplicate data of the range.
    ///</summary>
    ///  <param name="startRow">The start row.</param>
    ///  <param name="startColumn">The start column</param>
    ///  <param name="endRow">The end row index.</param>
    ///  <param name="endColumn">The end column index.</param>
    ///  <param name="hasHeaders">Indicates whether the range contains headers.</param>
    ///  <param name="columnOffsets">The column offsets.</param>
    procedure RemoveDuplicates(startRow: Int32; startColumn: Int32; endRow: Int32; endColumn: Int32; hasHeaders: Boolean; columnOffsets: TArray<Int32>); overload;
    ///<summary>
    ///  Converts string data in cells to numeric value if possible.
    ///</summary>
    procedure ConvertStringToNumericValue;
    ///<summary>
    ///  Get all cells which refer to the specific cell.
    ///</summary>
    ///  <param name="isAll">Indicates whether check other worksheets</param>
    ///  <param name="row">The row index.</param>
    ///  <param name="column">The column index.</param>
    ///<returns></returns>
    function GetDependents(isAll: Boolean; row: Int32; column: Int32): TArray<DNCell>;
    ///<summary>
    ///  Get the style of given cell.
    ///</summary>
    ///  <param name="row">row index</param>
    ///  <param name="column">column</param>
    ///<returns>the style of given cell.</returns>
    function GetCellStyle(row: Int32; column: Int32): DNStyle;
    ///<summary>
    ///  Merges a specified range of cells into a single cell.
    ///</summary>
    ///  <param name="firstRow">First row of this range(zero based)</param>
    ///  <param name="firstColumn">First column of this range(zero based)</param>
    ///  <param name="totalRows">Number of rows(one based)</param>
    ///  <param name="totalColumns">Number of columns(one based)</param>
    ///  <param name="checkConflict">Indicates whether check the merged cells intersects other merged cells</param>
    ///  <param name="mergeConflict">Merge conflict merged ranges.</param>
    ///<remarks>
    ///  Reference the merged cell via the address of the upper-left cell in the range.
    ///  If mergeConflict is true and the merged range conflicts with other merged cells,
    ///  other merged cells will be  automatically removed.
    ///</remarks>
    procedure Merge(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32; checkConflict: Boolean; mergeConflict: Boolean); overload;
    ///<summary>
    ///  Unmerges a specified range of merged cells.
    ///</summary>
    ///  <param name="firstRow">First row of this range(zero based)</param>
    ///  <param name="firstColumn">First column of this range(zero based)</param>
    ///  <param name="totalRows">Number of rows(one based)</param>
    ///  <param name="totalColumns">Number of columns(one based)</param>
    procedure UnMerge(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32);
    ///<summary>
    ///  Clears all merged ranges.
    ///</summary>
    procedure ClearMergedCells;
    ///<summary>
    ///  Hides a row.
    ///</summary>
    ///  <param name="row">Row index.</param>
    procedure HideRow(row: Int32);
    ///<summary>
    ///  Unhides a row.
    ///</summary>
    ///  <param name="row">Row index.</param>
    ///  <param name="height">Row height. The row's height will be changed only when the row is hidden and given height value is positive.</param>
    procedure UnhideRow(row: Int32; height: Double);
    ///<summary>
    ///  Hides multiple rows.
    ///</summary>
    ///  <param name="row">The row index.</param>
    ///  <param name="totalRows">The row number.</param>
    procedure HideRows(row: Int32; totalRows: Int32);
    ///<summary>
    ///  Unhides the hidden rows.
    ///</summary>
    ///  <param name="row">The row index.</param>
    ///  <param name="totalRows">The row number.</param>
    ///  <param name="height">Row height. The row's height will be changed only when the row is hidden and given height value is positive.</param>
    procedure UnhideRows(row: Int32; totalRows: Int32; height: Double);
    ///<summary>
    ///  Sets row height in unit of pixels.
    ///</summary>
    ///  <param name="row">Row index.</param>
    ///  <param name="pixels">Number of pixels.</param>
    procedure SetRowHeightPixel(row: Int32; pixels: Int32);
    ///<summary>
    ///  Sets row height in unit of inches.
    ///</summary>
    ///  <param name="row">Row index.</param>
    ///  <param name="inches">Number of inches. It should be between 0 and 409.5/72.</param>
    procedure SetRowHeightInch(row: Int32; inches: Double);
    ///<summary>
    ///  Sets the height of the specified row.
    ///</summary>
    ///  <param name="row">Row index.</param>
    ///  <param name="height">Height of row.In unit of point It should be between 0 and 409.5.</param>
    procedure SetRowHeight(row: Int32; height: Double);
    ///<summary>
    ///  Hides a column.
    ///</summary>
    ///  <param name="column">Column index.</param>
    procedure HideColumn(column: Int32);
    ///<summary>
    ///  Unhides a column
    ///</summary>
    ///  <param name="column">Column index.</param>
    ///  <param name="width">Column width.</param>
    procedure UnhideColumn(column: Int32; width: Double);
    ///<summary>
    ///  Hide multiple columns.
    ///</summary>
    ///  <param name="column">Column index.</param>
    ///  <param name="totalColumns">Column number.</param>
    procedure HideColumns(column: Int32; totalColumns: Int32);
    ///<summary>
    ///  Unhide multiple columns.
    ///</summary>
    ///  <param name="column">Column index.</param>
    ///  <param name="totalColumns">Column number</param>
    ///  <param name="width">Column width.</param>
    ///<remarks>
    ///  Only applies the column width to the hidden columns.
    ///</remarks>
    procedure UnhideColumns(column: Int32; totalColumns: Int32; width: Double);
    ///<summary>
    ///  Gets the height of a specified row.
    ///</summary>
    ///  <param name="row">Row index</param>
    ///<returns>Height of row</returns>
    function GetRowHeight(row: Int32): Double;
    ///<summary>
    ///  Gets the height of a specified row.
    ///</summary>
    ///  <param name="row">Row index</param>
    ///<returns>Height of row</returns>
    function GetViewRowHeight(row: Int32): Double;
    ///<summary>
    ///  Gets the height of a specified row in unit of pixel.
    ///</summary>
    ///  <param name="row">Row index</param>
    ///<returns>Height of row</returns>
    function GetRowHeightPixel(row: Int32): Int32;
    ///<summary>
    ///  Gets the height of a specified row in unit of inches.
    ///</summary>
    ///  <param name="row">Row index</param>
    ///<returns>Height of row</returns>
    function GetRowHeightInch(row: Int32): Double;
    ///<summary>
    ///  Gets the height of a specified row in unit of inches.
    ///</summary>
    ///  <param name="row">Row index</param>
    ///<returns>Height of row</returns>
    function GetViewRowHeightInch(row: Int32): Double;
    ///<summary>
    ///  Sets column width in unit of pixels in normal view.
    ///</summary>
    ///  <param name="column">Column index.</param>
    ///  <param name="pixels">Number of pixels.</param>
    procedure SetColumnWidthPixel(column: Int32; pixels: Int32);
    ///<summary>
    ///  Sets column width in unit of inches  in normal view.
    ///</summary>
    ///  <param name="column">Column index.</param>
    ///  <param name="inches">Number of inches.</param>
    procedure SetColumnWidthInch(column: Int32; inches: Double);
    ///<summary>
    ///  Sets the width of the specified column in normal view.
    ///</summary>
    ///  <param name="column">Column index.</param>
    ///  <param name="width">Width of column.Column width must be between 0 and 255.</param>
    ///<remarks>To hide a column, sets column width to zero.</remarks>
    procedure SetColumnWidth(column: Int32; width: Double);
    ///<summary>
    ///  Gets the width of the specified column in normal view, in units of pixel.
    ///</summary>
    ///  <param name="column">Column index</param>
    ///<returns>Width of column in normal view.</returns>
    function GetColumnWidthPixel(column: Int32): Int32;
    ///<summary>
    ///  Gets the width of the specified column in normal view, in units of inches.
    ///</summary>
    ///  <param name="column">Column index</param>
    ///<returns>Width of column</returns>
    function GetColumnWidthInch(column: Int32): Double;
    ///<summary>
    ///  Gets the width of the specified column in normal view
    ///</summary>
    ///  <param name="column">Column index</param>
    ///<returns>Width of column</returns>
    function GetColumnWidth(column: Int32): Double;
    ///<summary>
    ///  Get the width in different view type.
    ///</summary>
    ///  <param name="column">The column index.</param>
    ///<returns>the column width in unit of pixels</returns>
    function GetViewColumnWidthPixel(column: Int32): Int32;
    ///<summary>
    ///  Sets the width of the column in different view.
    ///</summary>
    ///  <param name="column">The column index.</param>
    ///  <param name="pixels">The width in unit of pixels.</param>
    ///<remarks>
    ///  If the current view type is <see cref="F:Aspose.Cells.ViewType.PageLayoutView" />
    ///  , the column's width is same as printed width.
    ///</remarks>
    procedure SetViewColumnWidthPixel(column: Int32; pixels: Int32);
    ///<summary>
    ///  Gets the last row index of cell which contains data in the specified column.
    ///</summary>
    ///  <param name="column">Column index.</param>
    ///<returns>last row index.</returns>
    function GetLastDataRow(column: Int32): Int32;
    ///<summary>
    ///  Applies formats for a whole column.
    ///</summary>
    ///  <param name="column">The column index.</param>
    ///  <param name="style">The style object which will be applied.</param>
    ///  <param name="flag">Flags which indicates applied formatting properties.</param>
    procedure ApplyColumnStyle(column: Int32; style: DNStyle; flag: DNStyleFlag);
    ///<summary>
    ///  Applies formats for a whole row.
    ///</summary>
    ///  <param name="row">The row index.</param>
    ///  <param name="style">The style object which will be applied.</param>
    ///  <param name="flag">Flags which indicates applied formatting properties.</param>
    procedure ApplyRowStyle(row: Int32; style: DNStyle; flag: DNStyleFlag);
    ///<summary>
    ///  Applies formats for a whole worksheet.
    ///</summary>
    ///  <param name="style">The style object which will be applied.</param>
    ///  <param name="flag">Flags which indicates applied formatting properties.</param>
    procedure ApplyStyle(style: DNStyle; flag: DNStyleFlag);
    ///<summary>
    ///  Copies data and formats of a whole column.
    ///</summary>
    ///  <param name="sourceCells0">Source Cells object contains data and formats to copy.</param>
    ///  <param name="sourceColumnIndex">Source column index.</param>
    ///  <param name="destinationColumnIndex">Destination column index.</param>
    ///  <param name="columnNumber">The copied column number.</param>
    ///  <param name="pasteOptions">the options of pasting.</param>
    procedure CopyColumns(sourceCells0: DNCells; sourceColumnIndex: Int32; destinationColumnIndex: Int32; columnNumber: Int32; pasteOptions: DNPasteOptions); overload;
    ///<summary>
    ///  Copies data and formats of a whole column.
    ///</summary>
    ///  <param name="sourceCells">Source Cells object contains data and formats to copy.</param>
    ///  <param name="sourceColumnIndex">Source column index.</param>
    ///  <param name="destinationColumnIndex">Destination column index.</param>
    procedure CopyColumn(sourceCells: DNCells; sourceColumnIndex: Int32; destinationColumnIndex: Int32);
    ///<summary>
    ///  Copies data and formats of a whole column.
    ///</summary>
    ///  <param name="sourceCells0">Source Cells object contains data and formats to copy.</param>
    ///  <param name="sourceColumnIndex">Source column index.</param>
    ///  <param name="destinationColumnIndex">Destination column index.</param>
    ///  <param name="columnNumber">The copied column number.</param>
    procedure CopyColumns(sourceCells0: DNCells; sourceColumnIndex: Int32; destinationColumnIndex: Int32; columnNumber: Int32); overload;
    ///<summary>
    ///  Copies data and formats of the whole columns.
    ///</summary>
    ///  <param name="sourceCells">Source Cells object contains data and formats to copy.</param>
    ///  <param name="sourceColumnIndex">Source column index.</param>
    ///  <param name="sourceTotalColumns">The number of the source columns.</param>
    ///  <param name="destinationColumnIndex">Destination column index.</param>
    ///  <param name="destinationTotalColumns">The number of the destination columns.</param>
    procedure CopyColumns(sourceCells: DNCells; sourceColumnIndex: Int32; sourceTotalColumns: Int32; destinationColumnIndex: Int32; destinationTotalColumns: Int32); overload;
    ///<summary>
    ///  Copies data and formats of a whole row.
    ///</summary>
    ///  <param name="sourceCells">Source Cells object contains data and formats to copy.</param>
    ///  <param name="sourceRowIndex">Source row index.</param>
    ///  <param name="destinationRowIndex">Destination row index.</param>
    procedure CopyRow(sourceCells: DNCells; sourceRowIndex: Int32; destinationRowIndex: Int32);
    ///<summary>
    ///  Copies data and formats of some whole rows.
    ///</summary>
    ///  <param name="sourceCells">Source Cells object contains data and formats to copy.</param>
    ///  <param name="sourceRowIndex">Source row index.</param>
    ///  <param name="destinationRowIndex">Destination row index.</param>
    ///  <param name="rowNumber">The copied row number.</param>
    procedure CopyRows(sourceCells: DNCells; sourceRowIndex: Int32; destinationRowIndex: Int32; rowNumber: Int32); overload;
    ///<summary>
    ///  Copies data and formats of some whole rows.
    ///</summary>
    ///  <param name="sourceCells0">Source Cells object contains data and formats to copy.</param>
    ///  <param name="sourceRowIndex">Source row index.</param>
    ///  <param name="destinationRowIndex">Destination row index.</param>
    ///  <param name="rowNumber">The copied row number.</param>
    ///  <param name="copyOptions">The copy options.</param>
    procedure CopyRows(sourceCells0: DNCells; sourceRowIndex: Int32; destinationRowIndex: Int32; rowNumber: Int32; copyOptions: DNCopyOptions); overload;
    ///<summary>
    ///  Copies data and formats of some whole rows.
    ///</summary>
    ///  <param name="sourceCells0">Source Cells object contains data and formats to copy.</param>
    ///  <param name="sourceRowIndex">Source row index.</param>
    ///  <param name="destinationRowIndex">Destination row index.</param>
    ///  <param name="rowNumber">The copied row number.</param>
    ///  <param name="copyOptions">The copy options.</param>
    ///  <param name="pasteOptions">the options of pasting.</param>
    procedure CopyRows(sourceCells0: DNCells; sourceRowIndex: Int32; destinationRowIndex: Int32; rowNumber: Int32; copyOptions: DNCopyOptions; pasteOptions: DNPasteOptions); overload;
    ///<summary>
    ///  Gets the outline level (zero-based) of the row.
    ///</summary>
    ///  <param name="rowIndex">The row index.</param>
    ///<returns>The outline level (zero-based) of the row.</returns>
    ///<remarks>If the row is not grouped, returns zero.</remarks>
    function GetGroupedRowOutlineLevel(rowIndex: Int32): Int32;
    ///<summary>
    ///  Gets the outline level (zero-based) of the column.
    ///</summary>
    ///  <param name="columnIndex">The column index</param>
    ///<returns>The outline level of the column</returns>
    ///<remarks>If the column is not grouped, returns zero.</remarks>
    function GetGroupedColumnOutlineLevel(columnIndex: Int32): Int32;
    ///<summary>
    ///  Gets the max grouped column outline level (zero-based).
    ///</summary>
    ///<returns> The max grouped column outline level (zero-based)</returns>
    function GetMaxGroupedColumnOutlineLevel: Int32;
    ///<summary>
    ///  Gets the max grouped row outline level (zero-based).
    ///</summary>
    ///<returns> The max grouped row outline level (zero-based)</returns>
    function GetMaxGroupedRowOutlineLevel: Int32;
    ///<summary>
    ///  Uncollapses the grouped rows/columns.
    ///</summary>
    ///  <param name="isVertical">True, uncollapses the grouped rows.</param>
    ///  <param name="index">The row/column index</param>
    procedure ShowGroupDetail(isVertical: Boolean; index: Int32);
    ///<summary>
    ///  Collapses the grouped rows/columns.
    ///</summary>
    ///  <param name="isVertical">True, collapse the grouped rows.</param>
    ///  <param name="index">The row/column index</param>
    procedure HideGroupDetail(isVertical: Boolean; index: Int32);
    ///<summary>
    ///  Ungroups columns.
    ///</summary>
    ///  <param name="firstIndex">The first column index to be ungrouped.</param>
    ///  <param name="lastIndex">The last column index to be ungrouped.</param>
    procedure UngroupColumns(firstIndex: Int32; lastIndex: Int32);
    ///<summary>
    ///  Groups columns.
    ///</summary>
    ///  <param name="firstIndex">The first column index to be grouped.</param>
    ///  <param name="lastIndex">The last column index to be grouped.</param>
    procedure GroupColumns(firstIndex: Int32; lastIndex: Int32); overload;
    ///<summary>
    ///  Groups columns.
    ///</summary>
    ///  <param name="firstIndex">The first column index to be grouped.</param>
    ///  <param name="lastIndex">The last column index to be grouped.</param>
    ///  <param name="isHidden">Specifies if the grouped columns are hidden.</param>
    procedure GroupColumns(firstIndex: Int32; lastIndex: Int32; isHidden: Boolean); overload;
    ///<summary>
    ///  Ungroups rows.
    ///</summary>
    ///  <param name="firstIndex">The first row index to be ungrouped.</param>
    ///  <param name="lastIndex">The last row index to be ungrouped.</param>
    ///  <param name="isAll">True, removes all grouped info.Otherwise, remove the outer group info.</param>
    procedure UngroupRows(firstIndex: Int32; lastIndex: Int32; isAll: Boolean); overload;
    ///<summary>
    ///  Ungroups rows.
    ///</summary>
    ///  <param name="firstIndex">The first row index to be ungrouped.</param>
    ///  <param name="lastIndex">The last row index to be ungrouped.</param>
    ///<remarks>
    ///  Only removes outer group info.
    ///</remarks>
    procedure UngroupRows(firstIndex: Int32; lastIndex: Int32); overload;
    ///<summary>
    ///  Groups rows.
    ///</summary>
    ///  <param name="firstIndex">The first row index to be grouped.</param>
    ///  <param name="lastIndex">The last row index to be grouped.</param>
    ///  <param name="isHidden">Specifies if the grouped columns are hidden.</param>
    procedure GroupRows(firstIndex: Int32; lastIndex: Int32; isHidden: Boolean); overload;
    ///<summary>
    ///  Groups rows.
    ///</summary>
    ///  <param name="firstIndex">The first row index to be grouped.</param>
    ///  <param name="lastIndex">The last row index to be grouped.</param>
    procedure GroupRows(firstIndex: Int32; lastIndex: Int32); overload;
    ///<summary>
    ///  Deletes a column.
    ///</summary>
    ///  <param name="columnIndex">Column index.</param>
    ///  <param name="updateReference">Indicates if update references in other worksheets.</param>
    procedure DeleteColumn(columnIndex: Int32; updateReference: Boolean); overload;
    ///<summary>
    ///  Deletes a column.
    ///</summary>
    ///  <param name="columnIndex">Column index.</param>
    procedure DeleteColumn(columnIndex: Int32); overload;
    ///<summary>
    ///  Deletes several columns.
    ///</summary>
    ///  <param name="columnIndex">Column index.</param>
    ///  <param name="totalColumns">Number of columns to be deleted.</param>
    ///  <param name="updateReference">Indicates if update references in other worksheets.</param>
    procedure DeleteColumns(columnIndex: Int32; totalColumns: Int32; updateReference: Boolean);
    ///<summary>
    ///  Check whether the range could be deleted.
    ///</summary>
    ///  <param name="startRow">The start row index of the range.</param>
    ///  <param name="startColumn">The start column index of the range.</param>
    ///  <param name="totalRows">The number of the rows in the range.</param>
    ///  <param name="totalColumns">The number of the columns in the range.</param>
    ///<returns></returns>
    function IsDeletingRangeEnabled(startRow: Int32; startColumn: Int32; totalRows: Int32; totalColumns: Int32): Boolean;
    ///<summary>
    ///  Deletes several rows.
    ///</summary>
    ///  <param name="rowIndex">The first row index to be deleted.</param>
    ///  <param name="totalRows">Number of rows to be deleted.</param>
    ///<remarks>
    ///  If the deleted range contains the top part(not whole) of the table(ListObject),
    ///  the ranged could not be deleted and nothing will be done.It works as MS Excel.
    ///</remarks>
    function DeleteRows(rowIndex: Int32; totalRows: Int32): Boolean; overload;
    ///<summary>
    ///  Deletes a row.
    ///</summary>
    ///  <param name="rowIndex">Row index.</param>
    procedure DeleteRow(rowIndex: Int32);
    ///<summary>
    ///  Deletes multiple rows in the worksheet.
    ///</summary>
    ///  <param name="rowIndex">Row index.</param>
    ///  <param name="totalRows">Number of rows to be deleted.</param>
    ///  <param name="updateReference">Indicates if update references in other worksheets.</param>
    ///<returns></returns>
    function DeleteRows(rowIndex: Int32; totalRows: Int32; updateReference: Boolean): Boolean; overload;
    ///<summary>
    ///  Delete all blank columns which do not contain any data.
    ///</summary>
    procedure DeleteBlankColumns; overload;
    ///<summary>
    ///  Delete all blank columns which do not contain any data.
    ///</summary>
    ///  <param name="options">The options of deleting range.</param>
    procedure DeleteBlankColumns(options: DNDeleteOptions); overload;
    ///<summary>
    ///  Checks whether given column is blank(does not contain any data).
    ///</summary>
    ///  <param name="columnIndex">the column index</param>
    ///<returns>true if given column does not contain any data</returns>
    function IsBlankColumn(columnIndex: Int32): Boolean;
    ///<summary>
    ///  Delete all blank rows which do not contain any data.
    ///</summary>
    procedure DeleteBlankRows; overload;
    ///<summary>
    ///  Delete all blank rows which do not contain any data.
    ///</summary>
    ///  <param name="options">The options of deleting range.</param>
    procedure DeleteBlankRows(options: DNDeleteOptions); overload;
    ///<summary>
    ///  Inserts some columns into the worksheet.
    ///</summary>
    ///  <param name="columnIndex">Column index.</param>
    ///  <param name="totalColumns">The number of columns.</param>
    procedure InsertColumns(columnIndex: Int32; totalColumns: Int32); overload;
    ///<summary>
    ///  Inserts some columns into the worksheet.
    ///</summary>
    ///  <param name="columnIndex">Column index.</param>
    ///  <param name="totalColumns">The number of columns.</param>
    ///  <param name="updateReference">Indicates if references in other worksheets will be updated.</param>
    procedure InsertColumns(columnIndex: Int32; totalColumns: Int32; updateReference: Boolean); overload;
    ///<summary>
    ///  Inserts a new column into the worksheet.
    ///</summary>
    ///  <param name="columnIndex">Column index.</param>
    ///  <param name="updateReference">Indicates if references in other worksheets will be updated.</param>
    procedure InsertColumn(columnIndex: Int32; updateReference: Boolean); overload;
    ///<summary>
    ///  Inserts a new column into the worksheet.
    ///</summary>
    ///  <param name="columnIndex">Column index.</param>
    procedure InsertColumn(columnIndex: Int32); overload;
    ///<summary>
    ///  Inserts multiple rows into the worksheet.
    ///</summary>
    ///  <param name="rowIndex">Row index.</param>
    ///  <param name="totalRows">Number of rows to be inserted.</param>
    ///  <param name="updateReference">Indicates if references in other worksheets will be updated.</param>
    procedure InsertRows(rowIndex: Int32; totalRows: Int32; updateReference: Boolean); overload;
    ///<summary>
    ///  Inserts multiple rows into the worksheet.
    ///</summary>
    ///  <param name="rowIndex">Row index.</param>
    ///  <param name="totalRows">Number of rows to be inserted.</param>
    ///  <param name="options">Indicates if references in other worksheets will be updated.</param>
    procedure InsertRows(rowIndex: Int32; totalRows: Int32; options: DNInsertOptions); overload;
    ///<summary>
    ///  Inserts multiple rows into the worksheet.
    ///</summary>
    ///  <param name="rowIndex">Row index.</param>
    ///  <param name="totalRows">Number of rows to be inserted.</param>
    procedure InsertRows(rowIndex: Int32; totalRows: Int32); overload;
    ///<summary>
    ///  Inserts a new row into the worksheet.
    ///</summary>
    ///  <param name="rowIndex">Row index.</param>
    procedure InsertRow(rowIndex: Int32);
    ///<summary>
    ///  Clears contents and formatting of a range.
    ///</summary>
    ///  <param name="range">Range to be cleared.</param>
    procedure ClearRange(range: DNCellArea); overload;
    ///<summary>
    ///  Clears contents and formatting of a range.
    ///</summary>
    ///  <param name="startRow">Start row index.</param>
    ///  <param name="startColumn">Start column index.</param>
    ///  <param name="endRow">End row index.</param>
    ///  <param name="endColumn">End column index.</param>
    procedure ClearRange(startRow: Int32; startColumn: Int32; endRow: Int32; endColumn: Int32); overload;
    ///<summary>
    ///  Clears contents of a range.
    ///</summary>
    ///  <param name="range">Range to be cleared.</param>
    procedure ClearContents(range: DNCellArea); overload;
    ///<summary>
    ///  Clears contents of a range.
    ///</summary>
    ///  <param name="startRow">Start row index.</param>
    ///  <param name="startColumn">Start column index.</param>
    ///  <param name="endRow">End row index.</param>
    ///  <param name="endColumn">End column index.</param>
    procedure ClearContents(startRow: Int32; startColumn: Int32; endRow: Int32; endColumn: Int32); overload;
    ///<summary>
    ///  Clears formatting of a range.
    ///</summary>
    ///  <param name="range">Range to be cleared.</param>
    procedure ClearFormats(range: DNCellArea); overload;
    ///<summary>
    ///  Clears formatting of a range.
    ///</summary>
    ///  <param name="startRow">Start row index.</param>
    ///  <param name="startColumn">Start column index.</param>
    ///  <param name="endRow">End row index.</param>
    ///  <param name="endColumn">End column index.</param>
    procedure ClearFormats(startRow: Int32; startColumn: Int32; endRow: Int32; endColumn: Int32); overload;
    ///<summary>
    ///  Link to a xml map.
    ///</summary>
    ///  <param name="mapName">name of xml map</param>
    ///  <param name="row">row of the destination cell</param>
    ///  <param name="column">column of the destination cell</param>
    ///  <param name="path">path of xml element in xml map</param>
    ///  e.g. A xml map element structure:
    ///  -RootElement
    ///  |-Attribute1
    ///  |-SubElement
    ///  |-Attribute2
    ///  |-Attribute3
    ///  To link "Attribute1", path is "/RootElement/Attribute1"
    ///  To link "Attribute2", path is "/RootElement/SubElement/Attribute2"
    ///  To link whole "SubElement", path is "/RootElement/SubElement"
    procedure LinkToXmlMap(mapName: string; row: Int32; column: Int32; path: string);
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataView" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataView">The <see cref="T:System.Data.DataView" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///<returns>Total number of rows imported</returns>
    function ImportDataView(dataView: DDN.System.Data.DNDataView; firstRow: Int32; firstColumn: Int32): Int32; overload;
    ///<summary>
    ///  Performs application-defined tasks associated with freeing, releasing, or
    ///  resetting unmanaged resources.
    ///</summary>
    procedure Dispose;
    ///<summary>
    ///  Gets the cells enumerator.
    ///</summary>
    ///<returns>The cells enumerator</returns>
    ///<remarks>When traversing elements by the returned Enumerator, the cells collection
    ///  should not be modified(such as operations that will cause new Cell/Row be instantiated or existing Cell/Row be deleted).
    ///  Otherwise the enumerator may not be able to traverse all cells correctly(some elements may be traversed repeatedly or skipped).</remarks>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator;
    ///<summary>
    ///  Gets the rows enumerator.
    ///</summary>
    ///<returns>The rows enumerator.</returns>
    function GetRowEnumerator: DDN.mscorlib.DNIEnumerator;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Cell" />
    ///  element or null at the specified cell row index and column index.
    ///</summary>
    ///  <param name="row">Row index</param>
    ///  <param name="column">Column index</param>
    ///<returns>Return Cell object if a Cell object exists.
    ///  Return null if the cell does not exist.
    ///</returns>
    function GetCell(row: Int32; column: Int32): DNCell;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Row" />
    ///  element at the specified cell row index.
    ///</summary>
    ///  <param name="row">Row index</param>
    ///<returns>
    ///  If the row object does exist return Row object, otherwise return null.
    ///</returns>
    function GetRow(row: Int32): DNRow;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Cell" />
    ///  element or null at the specified cell row index and column index.
    ///</summary>
    ///  <param name="row">Row index</param>
    ///  <param name="column">Column index</param>
    ///<returns>Return Cell object if a Cell object exists.
    ///  Return null if the cell does not exist.
    ///</returns>
    function CheckCell(row: Int32; column: Int32): DNCell;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Row" />
    ///  element or at the specified cell row index.
    ///</summary>
    ///  <param name="row">Row index</param>
    ///<returns>
    ///  If the row object does exist return Row object, otherwise return null.
    ///</returns>
    function CheckRow(row: Int32): DNRow;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Column" />
    ///  element or null at the specified column index.
    ///</summary>
    ///  <param name="columnIndex">The column index.</param>
    ///<returns>The Column object.</returns>
    function CheckColumn(columnIndex: Int32): DNColumn;
    ///<summary>
    ///  Checks whether a row at given index is hidden.
    ///</summary>
    ///  <param name="rowIndex">row index</param>
    ///<returns>true if the row is hidden</returns>
    function IsRowHidden(rowIndex: Int32): Boolean;
    ///<summary>
    ///  Checks whether a column at given index is hidden.
    ///</summary>
    ///  <param name="columnIndex">column index</param>
    ///<returns>true if the column is hidden.</returns>
    function IsColumnHidden(columnIndex: Int32): Boolean;
    ///<summary>
    ///  Adds a range object reference to cells
    ///</summary>
    ///  <param name="rangeObject">The range object will be contained in the cells</param>
    procedure AddRange(rangeObject: DNRange);
    ///<summary>
    ///  Creates a <see cref="T:Aspose.Cells.Range" />
    ///  object from a range of cells.
    ///</summary>
    ///  <param name="upperLeftCell">Upper left cell name.</param>
    ///  <param name="lowerRightCell">Lower right cell name.</param>
    ///<returns>A <see cref="T:Aspose.Cells.Range" />
    ///  object</returns>
    function CreateRange(upperLeftCell: string; lowerRightCell: string): DNRange; overload;
    ///<summary>
    ///  Creates a <see cref="T:Aspose.Cells.Range" />
    ///  object from a range of cells.
    ///</summary>
    ///  <param name="firstRow">First row of this range</param>
    ///  <param name="firstColumn">First column of this range</param>
    ///  <param name="totalRows">Number of rows</param>
    ///  <param name="totalColumns">Number of columns</param>
    ///<returns>A <see cref="T:Aspose.Cells.Range" />
    ///  object</returns>
    function CreateRange(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32): DNRange; overload;
    ///<summary>
    ///  Creates a <see cref="T:Aspose.Cells.Range" />
    ///  object from an address of the range.
    ///</summary>
    ///  <param name="address">The address of the range.</param>
    ///<returns>A <see cref="T:Aspose.Cells.Range" />
    ///  object</returns>
    function CreateRange(address: string): DNRange; overload;
    ///<summary>
    ///  Creates a <see cref="T:Aspose.Cells.Range" />
    ///  object from rows of cells or columns of cells.
    ///</summary>
    ///  <param name="firstIndex">First row index or first column index, zero based.</param>
    ///  <param name="number">Total number of rows or columns, one based.</param>
    ///  <param name="isVertical">True - Range created from columns of cells. False - Range created from rows of cells. </param>
    ///<returns>A <see cref="T:Aspose.Cells.Range" />
    ///  object.</returns>
    function CreateRange(firstIndex: Int32; number: Int32; isVertical: Boolean): DNRange; overload;
    ///<summary>
    ///  Clears all cell and row objects.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Exports data in the <see cref="T:Aspose.Cells.Cells" />
    ///  collection to a <see cref="T:System.Data.DataTable" />
    ///  object.
    ///</summary>
    ///<example><code>
    ///  [C#]
    ///  string designerFile = MapPath("Designer") + "\\List.xls";
    ///  Workbook excel = new Workbook(designerFile);
    ///  Worksheet sheet = excel.Worksheets[0];
    ///  DataTable dt = sheet.Cells.ExportDataTable(6, 1, 69, 4);
    ///  this.DataGrid1.DataSource = dt;
    ///  this.DataGrid1.DataBind();
    ///  [Visual Basic]
    ///  Dim designerFile As String = MapPath("Designer") + "\List.xls"
    ///  Dim excel As excel = New excel(designerFile)
    ///  Dim sheet As Worksheet = excel.Worksheets(0)
    ///  Dim dt As DataTable = sheet.Cells.ExportDataTable(6, 1, 69, 4)
    ///  Me.DataGrid1.DataSource = dt
    ///  Me.DataGrid1.DataBind()
    ///</code></example><param name="firstRow">The row number of the first cell to export out.</param>
    ///  <param name="firstColumn">The column number of the first cell to export out.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///<returns>Exported <see cref="T:System.Data.DataTable" />
    ///  object.</returns>
    ///<remarks>
    ///  If you use this method to export a block of data, please be sure that the data in a column
    ///  should be the same data type. Otherwise, use the <see cref="M:Aspose.Cells.Cells.ExportDataTableAsString(System.Int32,System.Int32,System.Int32,System.Int32)" />
    ///  method instead.
    ///</remarks>
    function ExportDataTable(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32): DDN.System.Data.DNDataTable; overload;
    ///<summary>
    ///  Exports data in the <see cref="T:Aspose.Cells.Cells" />
    ///  collection to a <see cref="T:System.Data.DataTable" />
    ///  object.
    ///</summary>
    ///  <param name="firstRow">The row number of the first cell to export out.</param>
    ///  <param name="firstColumn">The column number of the first cell to export out.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///  <param name="exportColumnName">Indicates whether the data in the first row are exported to the column name of the DataTable.</param>
    ///<returns>Exported <see cref="T:System.Data.DataTable" />
    ///  object.</returns>
    function ExportDataTable(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32; exportColumnName: Boolean): DDN.System.Data.DNDataTable; overload;
    ///<summary>
    ///  Exports data in the <see cref="T:Aspose.Cells.Cells" />
    ///  collection to a <see cref="T:System.Data.DataTable" />
    ///  object.
    ///</summary>
    ///  <param name="firstRow">The row number of the first cell to export out.</param>
    ///  <param name="firstColumn">The column number of the first cell to export out.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///<returns>Exported <see cref="T:System.Data.DataTable" />
    ///  object.</returns>
    ///<remarks>All data in the <see cref="T:Aspose.Cells.Cells" />
    ///  collection are converted to strings.</remarks>
    function ExportDataTableAsString(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32): DDN.System.Data.DNDataTable; overload;
    ///<summary>
    ///  Exports data in the <see cref="T:Aspose.Cells.Cells" />
    ///  collection to a <see cref="T:System.Data.DataTable" />
    ///  object.
    ///</summary>
    ///  <param name="firstRow">The row number of the first cell to export out.</param>
    ///  <param name="firstColumn">The column number of the first cell to export out.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///  <param name="exportColumnName">Indicates whether the data in the first row are exported to the column name of the DataTable.</param>
    ///<returns>Exported <see cref="T:System.Data.DataTable" />
    ///  object.</returns>
    ///<remarks>All data in the <see cref="T:Aspose.Cells.Cells" />
    ///  collection are converted to strings.</remarks>
    function ExportDataTableAsString(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32; exportColumnName: Boolean): DDN.System.Data.DNDataTable; overload;
    ///<summary>
    ///  Exports data in the <see cref="T:Aspose.Cells.Cells" />
    ///  collection to a <see cref="T:System.Data.DataTable" />
    ///  object.
    ///</summary>
    ///  <param name="firstRow">The row number of the first cell to export out.</param>
    ///  <param name="firstColumn">The column number of the first cell to export out.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///  <param name="options">All export table options</param>
    ///<returns>Exported <see cref="T:System.Data.DataTable" />
    ///  object.</returns>
    function ExportDataTable(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32; options: DNExportTableOptions): DDN.System.Data.DNDataTable; overload;
    ///<summary>
    ///  Import data from custom data table.
    ///</summary>
    ///  <param name="table">The custom data table.</param>
    ///  <param name="firstRow">First row index.</param>
    ///  <param name="firstColumn">First column index.</param>
    ///  <param name="options">The import options</param>
    ///<returns></returns>
    function ImportData(table: DNICellsDataTable; firstRow: Int32; firstColumn: Int32; options: DNImportTableOptions): Int32; overload;
    ///<summary>
    ///  Import data from custom data table.
    ///</summary>
    ///  <param name="table">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">First row index.</param>
    ///  <param name="firstColumn">First column index.</param>
    ///  <param name="options">The import options</param>
    ///<returns>Total number of rows imported.</returns>
    function ImportData(table: DDN.System.Data.DNDataTable; firstRow: Int32; firstColumn: Int32; options: DNImportTableOptions): Int32; overload;
    ///<summary>
    ///  Import data from data view.
    ///</summary>
    ///  <param name="dataView">The <see cref="T:System.Data.DataView" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">First row index.</param>
    ///  <param name="firstColumn">First column index.</param>
    ///  <param name="options">The import options</param>
    ///<returns>Total number of rows imported.</returns>
    function ImportData(dataView: DDN.System.Data.DNDataView; firstRow: Int32; firstColumn: Int32; options: DNImportTableOptions): Int32; overload;
    ///<summary>
    ///  Import data from data view.
    ///</summary>
    ///  <param name="dataReader">The <see cref="T:System.Data.IDataReader" />
    ///  object to be imported.</param>
    ///  <param name="firstRow">First row index.</param>
    ///  <param name="firstColumn">First column index.</param>
    ///  <param name="options">The import options</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader,int,int,ImportTableOptions) method, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function Import(dataReader: DDN.System.Data.DNIDataReader; firstRow: Int32; firstColumn: Int32; options: DNImportTableOptions): Int32;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  object into a worksheet.
    ///</summary>
    ///  <param name="dataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the datatable will be imported to the first row.</param>
    ///  <param name="startCell">The name of start cell to insert the DataTable, such as "A2".</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataTable,int,int,ImportTableOptions) method, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataTable(dataTable: DDN.System.Data.DNDataTable; isFieldNameShown: Boolean; startCell: string): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  object into a worksheet.
    ///</summary>
    ///  <param name="dataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the datatable will be imported to the first row.
    ///  Default is true.</param>
    ///  <param name="firstRow">The row number of the first cell to import.</param>
    ///  <param name="firstColumn">The column number of the first cell to import.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="convertStringToNumber">Indicates if this method will try to convert string to number.</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataTable,int,int,ImportTableOptions) method, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataTable(dataTable: DDN.System.Data.DNDataTable; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean; convertStringToNumber: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  object into a worksheet.
    ///</summary>
    ///  <param name="dataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the datatable will be imported to the first row.
    ///  Default is true.</param>
    ///  <param name="firstRow">The row number of the first cell to import.</param>
    ///  <param name="firstColumn">The column number of the first cell to import.</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataTable,int,int,ImportTableOptions) method, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataTable(dataTable: DDN.System.Data.DNDataTable; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  object into a worksheet.
    ///</summary>
    ///  <param name="dataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the datatable will be imported to the first row.
    ///  Default is true.</param>
    ///  <param name="firstRow">The row number of the first cell to import.</param>
    ///  <param name="firstColumn">The column number of the first cell to import.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataTable,int,int,ImportTableOptions) method, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataTable(dataTable: DDN.System.Data.DNDataTable; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  into a worksheet.
    ///</summary>
    ///<example><code>
    ///  [C#]
    ///  DataTable dt = new DataTable("Employee");
    ///  dt.Columns.Add("Employee_ID",typeof(Int32));
    ///  dt.Columns.Add("Employee_Name",typeof(string));
    ///  dt.Columns.Add("Gender",typeof(string));
    ///  DataRow dr = dt.NewRow();
    ///  dr[0] = 1;
    ///  dr[1] = "John Smith";
    ///  dr[2] = "Male";
    ///  dt.Rows.Add(dr);
    ///  dr = dt.NewRow();
    ///  dr[0] = 2;
    ///  dr[1] = "Mary Miller";
    ///  dr[2] = "Female";
    ///  dt.Rows.Add(dr);
    ///  cells.ImportDataTable(dt, true, 12, 12, 10, 10);
    ///  [Visual Basic]
    ///  Dim dt As DataTable =  New DataTable("Employee")
    ///  dt.Columns.Add("Employee_ID",Type.GetType(Int32))
    ///  dt.Columns.Add("Employee_Name",Type.GetType(String))
    ///  dt.Columns.Add("Gender",Type.GetType(String))
    ///  Dim dr As DataRow =  dt.NewRow()
    ///  dr(0) = 1
    ///  dr(1) = "John Smith"
    ///  dr(2) = "Male"
    ///  dt.Rows.Add(dr)
    ///  dr = dt.NewRow()
    ///  dr(0) = 2
    ///  dr(1) = "Mary Miller"
    ///  dr(2) = "Female"
    ///  dt.Rows.Add(dr)
    ///  cells.ImportDataTable(dt, True, 12, 12, 10, 10)
    ///</code></example><param name="dataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the datatable will be imported to the first row.
    ///  Default is true.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="totalRows">Number of rows to be imported.</param>
    ///  <param name="totalColumns">Number of columns to be imported.</param>
    ///<returns>Total number of rows imported</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataTable,int,int,ImportTableOptions) method, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataTable(dataTable: DDN.System.Data.DNDataTable; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object which contains data.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportFromDataReader(reader: DDN.System.Data.DNSqlDataReader; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object which contains data.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataReader(reader: DDN.System.Data.DNSqlDataReader; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object which contains data.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data reader will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportFromDataReader(reader: DDN.System.Data.DNSqlDataReader; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object which contains data.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data reader will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataReader(reader: DDN.System.Data.DNSqlDataReader; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object which contains data.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data reader will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="dateFormatString">Date format string for cells.</param>
    ///  <param name="convertStringToNumber">Indicates if this method will try to convert string to number.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportFromDataReader(reader: DDN.System.Data.DNSqlDataReader; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean; dateFormatString: string; convertStringToNumber: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.SqlClient.SqlDataReader" />
    ///  object which contains data.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data reader will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="dateFormatString">Date format string for cells.</param>
    ///  <param name="convertStringToNumber">Indicates if this method will try to convert string to number.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataReader(reader: DDN.System.Data.DNSqlDataReader; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean; dateFormatString: string; convertStringToNumber: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object which contains data.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data reader will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="dateFormatString">Date format string for cells.</param>
    ///  <param name="convertStringToNumber">Indicates if this method will try to convert string to number.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportFromDataReader(reader: DDN.System.Data.DNOleDbDataReader; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean; dateFormatString: string; convertStringToNumber: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object which contains data.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data reader will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="dateFormatString">Date format string for cells.</param>
    ///  <param name="convertStringToNumber">Indicates if this method will try to convert string to number.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataReader(reader: DDN.System.Data.DNOleDbDataReader; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean; dateFormatString: string; convertStringToNumber: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object which contains data.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data reader will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportFromDataReader(reader: DDN.System.Data.DNOleDbDataReader; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object which contains data.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data reader will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataReader(reader: DDN.System.Data.DNOleDbDataReader; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object which contains data.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportFromDataReader(reader: DDN.System.Data.DNOleDbDataReader; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.OleDb.OleDbDataReader" />
    ///  object which contains data.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataReader(reader: DDN.System.Data.DNOleDbDataReader; firstRow: Int32; firstColumn: Int32; insertRows: Boolean): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.IDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.IDataReader" />
    ///  object which contains data.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///<returns>Total number of rows imported.</returns>
    function ImportData(reader: DDN.System.Data.DNIDataReader; firstRow: Int32; firstColumn: Int32): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.IDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.IDataReader" />
    ///  object which contains data.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="options">The options of importing table.</param>
    ///<returns>Total number of rows imported.</returns>
    function ImportData(reader: DDN.System.Data.DNIDataReader; firstRow: Int32; firstColumn: Int32; options: DNImportTableOptions): Int32; overload;
    ///<summary>
    ///  Imports data from a <see cref="T:System.Data.IDataReader" />
    ///  object.
    ///</summary>
    ///  <param name="reader">The <see cref="T:System.Data.IDataReader" />
    ///  object which contains data.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the data reader will be imported to the first row.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="dateFormatString">Date format string for cells.</param>
    ///  <param name="convertStringToNumber">Indicates if this method will try to convert string to number.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(IDataReader, int, int,ImportTableOptions) method.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataReader(reader: DDN.System.Data.DNIDataReader; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; insertRows: Boolean; dateFormatString: string; convertStringToNumber: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the datatable will be imported to the first row.
    ///  Default is true.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="rowNumber">Number of rows to be imported.</param>
    ///  <param name="columnNumber">Number of columns to be imported.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="dateFormatString">Date format string for cells.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>This method automatically format date time values.
    ///  However, if the DateTable is very huge, this method may slow down the program.
    ///  In this case, you'd better format the cell manually.</remarks>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataTable,int,int,ImportTableOptions) method, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataTable(dataTable: DDN.System.Data.DNDataTable; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; rowNumber: Int32; columnNumber: Int32; insertRows: Boolean; dateFormatString: string): Int32; overload;
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the datatable will be imported to the first row.
    ///  Default is true.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="rowNumber">Number of rows to be imported.</param>
    ///  <param name="columnNumber">Number of columns to be imported.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///  <param name="dateFormatString">Date format string for cells.</param>
    ///  <param name="convertStringToNumber">Indicates if this method will try to convert string to number.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>This method automatically format date time values.
    ///  However, if the DateTable is very huge, this method may slow down the program.
    ///  In this case, you'd better format the cell manually.</remarks>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataTable,int,int,ImportTableOptions) method, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataTable(dataTable: DDN.System.Data.DNDataTable; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; rowNumber: Int32; columnNumber: Int32; insertRows: Boolean; dateFormatString: string; convertStringToNumber: Boolean): Int32; overload;
    ///<summary>
    ///  Imports a DataRow into the Excel file.
    ///</summary>
    ///  <param name="dataRow">DataRow object.</param>
    ///  <param name="row">Row index.</param>
    ///  <param name="firstColumn">First column index.</param>
    procedure ImportDataRow(dataRow: DDN.System.Data.DNDataRow; row: Int32; firstColumn: Int32);
    ///<summary>
    ///  Imports a <see cref="T:System.Data.DataTable" />
    ///  into a worksheet.
    ///</summary>
    ///  <param name="dataTable">The <see cref="T:System.Data.DataTable" />
    ///  object to be imported.</param>
    ///  <param name="isFieldNameShown">
    ///  Indicates whether the field name of the datatable will be imported to the first row.
    ///  Default is true.
    ///</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="rowNumber">Number of rows to be imported.</param>
    ///  <param name="columnNumber">Number of columns to be imported.</param>
    ///  <param name="insertRows">Indicates whether extra rows are added to fit data.</param>
    ///<returns>Total number of rows imported.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Cells.ImportData(DataTable,int,int,ImportTableOptions) method, instead.
    ///  This property will be removed 12 months later since December 2018.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function ImportDataTable(dataTable: DDN.System.Data.DNDataTable; isFieldNameShown: Boolean; firstRow: Int32; firstColumn: Int32; rowNumber: Int32; columnNumber: Int32; insertRows: Boolean): Int32; overload;
    procedure ImportTwoDimensionArray(objArray: TArray<DDN.mscorlib.DNObject>; firstRow: Int32; firstColumn: Int32); overload;
    procedure ImportTwoDimensionArray(objArray: TArray<DDN.mscorlib.DNObject>; firstRow: Int32; firstColumn: Int32; convertStringToNumber: Boolean); overload;
    procedure ImportTwoDimensionArray(objArray: TArray<DDN.mscorlib.DNObject>; styles: TArray<DDN.mscorlib.DNObject>; firstRow: Int32; firstColumn: Int32; convertStringToNumber: Boolean); overload;
    procedure ImportTwoDimensionArray(objArray: TArray<DDN.mscorlib.DNObject>; styles: TArray<DDN.mscorlib.DNObject>; firstRow: Int32; firstColumn: Int32; opts: DNTxtLoadOptions); overload;
    ///<summary>
    ///  Imports an array of data into a worksheet.
    ///</summary>
    ///  <param name="objArray">Data array.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="isVertical">Specifies to import data vertically or horizontally.</param>
    procedure ImportObjectArray(objArray: TArray<DDN.mscorlib.DNObject>; firstRow: Int32; firstColumn: Int32; isVertical: Boolean); overload;
    ///<summary>
    ///  Imports an arraylist of data into a worksheet.
    ///</summary>
    ///  <param name="arrayList">Data arraylist.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="isVertical">Specifies to import data vertically or horizontally.</param>
    procedure ImportArrayList(arrayList: DDN.mscorlib.DNArrayList; firstRow: Int32; firstColumn: Int32; isVertical: Boolean);
    ///<summary>
    ///  Imports an array of data into a worksheet.
    ///</summary>
    ///  <param name="objArray">Data array.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="isVertical">Specifies to import data vertically or horizontally.</param>
    ///  <param name="skip">Skipped number of rows or columns.</param>
    procedure ImportObjectArray(objArray: TArray<DDN.mscorlib.DNObject>; firstRow: Int32; firstColumn: Int32; isVertical: Boolean; skip: Int32); overload;
    procedure ImportArray(stringArray: TArray<string>; firstRow: Int32; firstColumn: Int32); overload;
    ///<summary>
    ///  Imports an array of formula into a worksheet.
    ///</summary>
    ///  <param name="stringArray">Formula array.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="isVertical">Specifies to import data vertically or horizontally.</param>
    procedure ImportFormulaArray(stringArray: TArray<string>; firstRow: Int32; firstColumn: Int32; isVertical: Boolean);
    ///<summary>
    ///  Imports an array of string into a worksheet.
    ///</summary>
    ///  <param name="stringArray">String array.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="isVertical">Specifies to import data vertically or horizontally.</param>
    procedure ImportArray(stringArray: TArray<string>; firstRow: Int32; firstColumn: Int32; isVertical: Boolean); overload;
    procedure ImportArray(intArray: TArray<Int32>; firstRow: Int32; firstColumn: Int32); overload;
    ///<summary>
    ///  Imports an array of integer into a worksheet.
    ///</summary>
    ///  <param name="intArray">Integer array.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="isVertical">Specifies to import data vertically or horizontally.</param>
    procedure ImportArray(intArray: TArray<Int32>; firstRow: Int32; firstColumn: Int32; isVertical: Boolean); overload;
    procedure ImportArray(doubleArray: TArray<Double>; firstRow: Int32; firstColumn: Int32); overload;
    ///<summary>
    ///  Imports an array of double into a worksheet.
    ///</summary>
    ///  <param name="doubleArray">Double array.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    ///  <param name="isVertical">Specifies to import data vertically or horizontally.</param>
    procedure ImportArray(doubleArray: TArray<Double>; firstRow: Int32; firstColumn: Int32; isVertical: Boolean); overload;
    ///<summary>
    ///  Splits the text in the column to columns.
    ///</summary>
    ///  <param name="row">The row index.</param>
    ///  <param name="column">The column index.</param>
    ///  <param name="totalRows">The number of rows.</param>
    ///  <param name="options">The split options.</param>
    procedure TextToColumns(row: Int32; column: Int32; totalRows: Int32; options: DNTxtLoadOptions);
    ///<summary>
    ///  Import a CSV file to the cells.
    ///</summary>
    ///  <param name="fileName">The CSV file name.</param>
    ///  <param name="splitter">The splitter</param>
    ///  <param name="convertNumericData"> Whether the string in text file is converted to numeric data.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    procedure ImportCSV(fileName: string; splitter: string; convertNumericData: Boolean; firstRow: Int32; firstColumn: Int32); overload;
    ///<summary>
    ///  Import a CSV file to the cells.
    ///</summary>
    ///  <param name="stream">The CSV file stream.</param>
    ///  <param name="splitter">The splitter</param>
    ///  <param name="convertNumericData"> Whether the string in text file is converted to numeric data.</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    procedure ImportCSV(stream: DDN.mscorlib.DNStream; splitter: string; convertNumericData: Boolean; firstRow: Int32; firstColumn: Int32); overload;
    ///<summary>
    ///  Import a CSV file to the cells.
    ///</summary>
    ///  <param name="fileName">The CSV file name.</param>
    ///  <param name="options">The load options for reading text file</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    procedure ImportCSV(fileName: string; options: DNTxtLoadOptions; firstRow: Int32; firstColumn: Int32); overload;
    ///<summary>
    ///  Import a CSV file to the cells.
    ///</summary>
    ///  <param name="stream">The CSV file stream.</param>
    ///  <param name="options">The load options for reading text file</param>
    ///  <param name="firstRow">The row number of the first cell to import in.</param>
    ///  <param name="firstColumn">The column number of the first cell to import in.</param>
    procedure ImportCSV(stream: DDN.mscorlib.DNStream; options: DNTxtLoadOptions; firstRow: Int32; firstColumn: Int32); overload;
    ///<summary>
    ///  Merges a specified range of cells into a single cell.
    ///</summary>
    ///  <param name="firstRow">First row of this range(zero based)</param>
    ///  <param name="firstColumn">First column of this range(zero based)</param>
    ///  <param name="totalRows">Number of rows(one based)</param>
    ///  <param name="totalColumns">Number of columns(one based)</param>
    ///<remarks>
    ///  Reference the merged cell via the address of the upper-left cell in the range.
    ///</remarks>
    procedure Merge(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32); overload;
    ///<summary>
    ///  Merges a specified range of cells into a single cell.
    ///</summary>
    ///  <param name="firstRow">First row of this range(zero based)</param>
    ///  <param name="firstColumn">First column of this range(zero based)</param>
    ///  <param name="totalRows">Number of rows(one based)</param>
    ///  <param name="totalColumns">Number of columns(one based)</param>
    ///  <param name="mergeConflict">Merge conflict merged ranges.</param>
    ///<remarks>
    ///  Reference the merged cell via the address of the upper-left cell in the range.
    ///  If mergeConflict is true and the merged range conflicts with other merged cells,
    ///  other merged cells will be  automatically removed.
    ///</remarks>
    procedure Merge(firstRow: Int32; firstColumn: Int32; totalRows: Int32; totalColumns: Int32; mergeConflict: Boolean); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the list of fields of ods.
    ///</summary>
    property OdsCellFields: DNOdsCellFieldCollection read get_OdsCellFields;
    ///<summary>
    ///  Gets the total count of instantiated Cell objects.
    ///</summary>
    property Count: Int32 read get_Count;
    ///<summary>
    ///  Gets the total count of instantiated Cell objects.
    ///</summary>
    property CountLarge: Int64 read get_CountLarge;
    property Item[index: Int32]: DNCell read get_Item; default;
    ///<summary>
    ///  Gets the collection of <see cref="T:Aspose.Cells.Row" />
    ///  objects that represents the individual rows in this worksheet.
    ///</summary>
    property Rows: DNRowCollection read get_Rows;
    ///<summary>
    ///  Gets the collection of merged cells.
    ///</summary>
    ///<remarks>In this collection, each item is a <see cref="T:Aspose.Cells.CellArea" />
    ///  structure which represents an area of merged cells.</remarks>
    property MergedCells: DDN.mscorlib.DNArrayList read get_MergedCells;
    property Item[row: Int32; column: Int32]: DNCell read get_Item; default;
    property Item[cellName: string]: DNCell read get_Item; default;
    ///<summary>
    ///  Gets or sets whether the cells data model should support Multi-Thread reading.
    ///  Default value of this property is false.
    ///  If there are multiple threads to read Row/Cell objects in this collection concurrently,
    ///  this property should be set as true, otherwise unexpected result may be produced.
    ///  Supporting Multi-Thread reading may degrade the performance for accessing Row/Cell objects from this collection.
    ///</summary>
    property MultiThreadReading: Boolean read get_MultiThreadReading write set_MultiThreadReading;
    ///<summary>
    ///  Gets or sets the memory usage option for this cells.
    ///</summary>
    property MemorySetting: DNMemorySetting read get_MemorySetting write set_MemorySetting;
    ///<summary>
    ///  Gets and sets the default style.
    ///</summary>
    property Style: DNStyle read get_Style write set_Style;
    ///<summary>
    ///  Gets or sets the default column width in the worksheet, in unit of inches.
    ///</summary>
    property StandardWidthInch: Double read get_StandardWidthInch write set_StandardWidthInch;
    ///<summary>
    ///  Gets or sets the default column width in the worksheet, in unit of pixels.
    ///</summary>
    property StandardWidthPixels: Int32 read get_StandardWidthPixels write set_StandardWidthPixels;
    ///<summary>
    ///  Gets or sets the default column width in the worksheet, in unit of characters.
    ///</summary>
    property StandardWidth: Double read get_StandardWidth write set_StandardWidth;
    ///<summary>
    ///  Gets or sets the default row height in this worksheet, in unit of points.
    ///</summary>
    property StandardHeight: Double read get_StandardHeight write set_StandardHeight;
    ///<summary>
    ///  Gets or sets the default row height in this worksheet, in unit of pixels.
    ///</summary>
    property StandardHeightPixels: Int32 read get_StandardHeightPixels write set_StandardHeightPixels;
    ///<summary>
    ///  Gets or sets a value indicating whether all worksheet values are preserved as strings.
    ///  Default is false.
    ///</summary>
    property PreserveString: Boolean read get_PreserveString write set_PreserveString;
    ///<summary>
    ///  Minimum row index of cell which contains data or style.
    ///</summary>
    property MinRow: Int32 read get_MinRow;
    ///<summary>
    ///  Maximum row index of cell which contains data or style.
    ///</summary>
    ///<remarks>
    ///  Return -1 if there is no cell which contains data or style in the worksheet.
    ///</remarks>
    property MaxRow: Int32 read get_MaxRow;
    ///<summary>
    ///  Minimum column index of cell which contains data or style.
    ///</summary>
    property MinColumn: Int32 read get_MinColumn;
    ///<summary>
    ///  Maximum column index of cell which contains data or style.
    ///</summary>
    ///<remarks>
    ///  Return -1 if there is no cell.
    ///</remarks>
    property MaxColumn: Int32 read get_MaxColumn;
    ///<summary>
    ///  Minimum row index of cell which contains data.
    ///</summary>
    property MinDataRow: Int32 read get_MinDataRow;
    ///<summary>
    ///  Maximum row index of cell which contains data.
    ///</summary>
    ///<remarks>
    ///  Return -1 if there is no cell which contains data.
    ///</remarks>
    property MaxDataRow: Int32 read get_MaxDataRow;
    ///<summary>
    ///  Minimum column index of cell which contains data.
    ///</summary>
    property MinDataColumn: Int32 read get_MinDataColumn;
    ///<summary>
    ///  Maximum column index of cell which contains data.
    ///</summary>
    ///<remarks>
    ///  Return -1 if there is not cell which contains data.
    ///  Don't call this property repeatedly. This property will iterate all cells in a worksheet.</remarks>
    property MaxDataColumn: Int32 read get_MaxDataColumn;
    ///<summary>
    ///  Indicates that row height and default font height matches
    ///</summary>
    property IsDefaultRowHeightMatched: Boolean read get_IsDefaultRowHeightMatched write set_IsDefaultRowHeightMatched;
    ///<summary>
    ///  Indicates whether the row is default hidden.
    ///</summary>
    property IsDefaultRowHidden: Boolean read get_IsDefaultRowHidden write set_IsDefaultRowHidden;
    ///<summary>
    ///  Gets the collection of <see cref="T:Aspose.Cells.Column" />
    ///  objects that represents the individual columns in this worksheet.
    ///</summary>
    property Columns: DNColumnCollection read get_Columns;
    ///<summary>
    ///  Gets the collection of <see cref="T:Aspose.Cells.Range" />
    ///  objects created at run time.
    ///</summary>
    property Ranges: DNRangeCollection read get_Ranges;
    ///<summary>
    ///  Gets the last cell in this worksheet.
    ///</summary>
    property LastCell: DNCell read get_LastCell;
    ///<summary>
    ///  Gets the max range which includes data, merged cells and shapes.
    ///</summary>
    property MaxDisplayRange: DNRange read get_MaxDisplayRange;
    ///<summary>
    ///  Gets the first cell in this worksheet.
    ///</summary>
    property FirstCell: DNCell read get_FirstCell;
  end;

  TDNCells = class(TDNGenericImport<DNCellsClass, DNCells>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCellsColorClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F1746607-3083-5076-8D64-A0830C674CEB}']
  end;

  ///<summary>
  ///  Represents all types of color.
  ///</summary>
  [DNTypeName('Aspose.Cells.CellsColor')]
  DNCellsColor = interface(DDN.mscorlib.DNObject)
  ['{209DDDB6-D7E1-37C1-95B9-AD9361EC79CC}']
  { getters & setters } 

    function get_IsShapeColor: Boolean;
    procedure set_IsShapeColor(value: Boolean);
    function get_Type: DNColorType;
    function get_ThemeColor: DNThemeColor;
    procedure set_ThemeColor(value: DNThemeColor);
    function get_ColorIndex: Int32;
    procedure set_ColorIndex(value: Int32);
    function get_Color: DDN.System.Drawing.DNColor;
    procedure set_Color(value: DDN.System.Drawing.DNColor);
    function get_Argb: Int32;
    procedure set_Argb(value: Int32);
    function get_Transparency: Double;
    procedure set_Transparency(value: Double);

  { methods } 

    ///<summary>
    ///  Set the tint of the shape color
    ///</summary>
    ///  <param name="tint"></param>
    procedure SetTintOfShapeColor(tint: Double);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets and set the color which should apply to cell or shape.
    ///</summary>
    ///<remarks>
    ///  The expression of the color of the cell and the shape is different.
    ///  For example: the theme color with same tint value will be not same in the cell and the shape.
    ///</remarks>
    property IsShapeColor: Boolean read get_IsShapeColor write set_IsShapeColor;
    ///<summary>
    ///  The color type.
    ///</summary>
    property &Type: DNColorType read get_Type;
    ///<summary>
    ///  Gets the theme color. Only applies for theme color type.
    ///</summary>
    property ThemeColor: DNThemeColor read get_ThemeColor write set_ThemeColor;
    ///<summary>
    ///  Gets and sets the color index in the color palette. Only applies of indexed color.
    ///</summary>
    property ColorIndex: Int32 read get_ColorIndex write set_ColorIndex;
    ///<summary>
    ///  Gets and sets the RGB color.
    ///</summary>
    property Color: DDN.System.Drawing.DNColor read get_Color write set_Color;
    ///<summary>
    ///  Gets and sets the color from a 32-bit ARGB value.
    ///</summary>
    property Argb: Int32 read get_Argb write set_Argb;
    ///<summary>
    ///  Gets and sets transparency as a value from 0.0 (opaque) through 1.0 (clear).
    ///</summary>
    property Transparency: Double read get_Transparency write set_Transparency;
  end;

  TDNCellsColor = class(TDNGenericImport<DNCellsColorClass, DNCellsColor>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCellsFactoryClass = interface(DDN.mscorlib.DNObjectClass)
  ['{5278C3F0-4C6C-50A6-923F-1F947A66569C}']
  { constructors } 

    {class} function init: DNCellsFactory;

  end;

  ///<summary>
  ///  Utility for instantiating classes of Cells model.
  ///</summary>
  [DNTypeName('Aspose.Cells.CellsFactory')]
  DNCellsFactory = interface(DDN.mscorlib.DNObject)
  ['{09C1BFF7-174B-30B7-9FDA-82EDB490D631}']
  { methods } 

    ///<summary>
    ///  Creates a new style.
    ///</summary>
    ///<returns>Returns a style object.</returns>
    function CreateStyle: DNStyle;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNCellsFactory = class(TDNGenericImport<DNCellsFactoryClass, DNCellsFactory>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCellsHelperClass = interface(DDN.mscorlib.DNObjectClass)
  ['{6182F2F7-6F29-5E1E-8241-8B7960A79CA2}']
  { static getter & setter } 

    {class} function get_SignificantDigits: Int32;
    {class} procedure set_SignificantDigits(value: Int32);
    {class} function get_DPI: Double;
    {class} procedure set_DPI(value: Double);
    {class} function get_StartupPath: string;
    {class} procedure set_StartupPath(value: string);
    {class} function get_AltStartPath: string;
    {class} procedure set_AltStartPath(value: string);
    {class} function get_LibraryPath: string;
    {class} procedure set_LibraryPath(value: string);
    {class} function get_CustomImplementationFactory: DNCustomImplementationFactory;
    {class} procedure set_CustomImplementationFactory(value: DNCustomImplementationFactory);
    {class} function get_IsCloudPlatform: Boolean;
    {class} procedure set_IsCloudPlatform(value: Boolean);

  { static methods } 

    ///<summary>
    ///  Get width of text in unit of points.
    ///</summary>
    ///  <param name="text">The text.</param>
    ///  <param name="font">The font of the text.</param>
    ///  <param name="scaling">The scaling of text.</param>
    ///<returns></returns>
    {class} function GetTextWidth(text: string; font: DNFont; scaling: Double): Double;
    ///<summary>
    ///  Get the release version.
    ///</summary>
    ///<returns>The release version.</returns>
    {class} function GetVersion: string;
    {class} procedure CellNameToIndex(cellName: string; out row: Int32; out column: Int32);
    ///<summary>
    ///  Gets cell name according to its row and column indexes.
    ///</summary>
    ///  <param name="row">Row index.</param>
    ///  <param name="column">Column index.</param>
    ///<returns>Name of cell.</returns>
    {class} function CellIndexToName(row: Int32; column: Int32): string;
    ///<summary>
    ///  Gets column name according to column index.
    ///</summary>
    ///  <param name="column">Column index.</param>
    ///<returns>Name of column.</returns>
    {class} function ColumnIndexToName(column: Int32): string;
    ///<summary>
    ///  Gets column index according to column name.
    ///</summary>
    ///  <param name="columnName">Column name.</param>
    ///<returns>Column index.</returns>
    {class} function ColumnNameToIndex(columnName: string): Int32;
    ///<summary>
    ///  Gets row name according to row index.
    ///</summary>
    ///  <param name="row">Row index.</param>
    ///<returns>Name of row.</returns>
    {class} function RowIndexToName(row: Int32): string;
    ///<summary>
    ///  Gets row index according to row name.
    ///</summary>
    ///  <param name="rowName">Row name.</param>
    ///<returns>Row index.</returns>
    {class} function RowNameToIndex(rowName: string): Int32;
    ///<summary>
    ///  Converts the r1c1 formula of the cell to A1 formula.
    ///</summary>
    ///  <param name="r1c1Formula">The r1c1 formula.</param>
    ///  <param name="row">The row index of the cell.</param>
    ///  <param name="column">The column index of the cell.</param>
    ///<returns>The A1 formula.</returns>
    {class} function ConvertR1C1FormulaToA1(r1c1Formula: string; row: Int32; column: Int32): string;
    ///<summary>
    ///  Converts A1 formula of the cell to the r1c1 formula.
    ///</summary>
    ///  <param name="formula">The A1 formula.</param>
    ///  <param name="row">The row index of the cell.</param>
    ///  <param name="column">The column index of the cell.</param>
    ///<returns>The R1C1 formula.</returns>
    {class} function ConvertA1FormulaToR1C1(formula: string; row: Int32; column: Int32): string;
    ///<summary>
    ///  Convert the double value to the date time value.
    ///</summary>
    ///  <param name="doubleValue">The double value.</param>
    ///  <param name="date1904">Date 1904 system.</param>
    ///<returns></returns>
    {class} function GetDateTimeFromDouble(doubleValue: Double; date1904: Boolean): DDN.mscorlib.DNDateTime;
    ///<summary>
    ///  Convert the date time to double value.
    ///</summary>
    ///  <param name="dateTime">The date time.</param>
    ///  <param name="date1904">Date 1904 system.</param>
    ///<returns></returns>
    {class} function GetDoubleFromDateTime(dateTime: DDN.mscorlib.DNDateTime; date1904: Boolean): Double;
    ///<summary>
    ///  Gets all used colors in the workbook.
    ///</summary>
    ///  <param name="workbook">The workbook object.</param>
    ///<returns>The used colors.</returns>
    {class} function GetUsedColors(workbook: DNWorkbook): TArray<DDN.System.Drawing.DNColor>;
    ///<summary>
    ///  Add addin function.
    ///</summary>
    ///  <param name="function">The function name.</param>
    ///  <param name="minCountOfParameters">Minimum number of parameters this function requires</param>
    ///  <param name="maxCountOfParameters">Maximum number of parameters this function allows.</param>
    ///  <param name="paramersType">The excepted parameters type of the function</param>
    ///  <param name="functionValueType">The function value type.</param>
    {class} procedure AddAddInFunction(&function: string; minCountOfParameters: Int32; maxCountOfParameters: Int32; paramersType: TArray<DNParameterType>; functionValueType: DNParameterType);
    ///<summary>
    ///  Merges some large xls files to a xls file.
    ///</summary>
    ///  <param name="files">The files.</param>
    ///  <param name="cachedFile">The cached file.</param>
    ///  <param name="destFile">The dest file.</param>
    ///<remarks>
    ///  This method only supports merging data, style and formulas to the new file.
    ///  The cached file is used to store some temporary data.
    ///</remarks>
    {class} procedure MergeFiles(files: TArray<string>; cachedFile: string; destFile: string);
    ///<summary>
    ///  Checks given sheet name and create a valid one when needed.
    ///  If given sheet name conforms to the rules of excel sheet name, then return it.
    ///  Otherwise string will be truncated if length exceeds the limit
    ///  and invalid characters will be replaced with ' ', then return the rebuilt string value.
    ///</summary>
    ///  <param name="nameProposal">sheet name to be used</param>
    ///<returns></returns>
    {class} function CreateSafeSheetName(nameProposal: string): string; overload;
    ///<summary>
    ///  Checks given sheet name and create a valid one when needed.
    ///  If given sheet name conforms to the rules of excel sheet name, then return it.
    ///  Otherwise string will be truncated if length exceeds the limit
    ///  and invalid characters will be replaced with given character, then return the rebuilt string value.
    ///</summary>
    ///  <param name="nameProposal">sheet name to be used</param>
    ///  <param name="replaceChar">character which will be used to replace invalid characters in given sheet name</param>
    ///<returns></returns>
    {class} function CreateSafeSheetName(nameProposal: string; replaceChar: Char): string; overload;

  { static propertys } 

    ///<summary>
    ///  Gets and sets the number of significant digits.
    ///  The default value is 17.
    ///</summary>
    ///<remarks>
    ///  Only could be 15 or 17 now.
    ///</remarks>
    {class} property SignificantDigits: Int32 read get_SignificantDigits write set_SignificantDigits;
    ///<summary>
    ///  Gets the DPI of the machine.
    ///</summary>
    ///<remarks></remarks>
    {class} property DPI: Double read get_DPI write set_DPI;
    ///<summary>
    ///  Gets or sets the startup path, which is referred to by some external formula references.
    ///</summary>
    {class} property StartupPath: string read get_StartupPath write set_StartupPath;
    ///<summary>
    ///  Gets or sets the alternate startup path, which is referred to by some external formula references.
    ///</summary>
    {class} property AltStartPath: string read get_AltStartPath write set_AltStartPath;
    ///<summary>
    ///  Gets or sets the library path which is referred to by some external formula references.
    ///</summary>
    {class} property LibraryPath: string read get_LibraryPath write set_LibraryPath;
    ///<summary>
    ///  Gets or sets the factory for creating instances with special implementation.
    ///</summary>
    {class} property CustomImplementationFactory: DNCustomImplementationFactory read get_CustomImplementationFactory write set_CustomImplementationFactory;
    ///<summary>
    ///  Please set this property True when running on a cloud platform, such as: Azure, AWSLambda, etc,
    ///</summary>
    {class} property IsCloudPlatform: Boolean read get_IsCloudPlatform write set_IsCloudPlatform;
  end;

  ///<summary>
  ///  Provides helper functions.
  ///</summary>
  [DNTypeName('Aspose.Cells.CellsHelper')]
  DNCellsHelper = interface(DDN.mscorlib.DNObject)
  ['{D87959FB-F02D-3E17-AF88-D56C786203E9}']
  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  end;

  TDNCellsHelper = class(TDNGenericImport<DNCellsHelperClass, DNCellsHelper>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCellWatchClass = interface(DDN.mscorlib.DNObjectClass)
  ['{04FA91F6-B506-5F4A-8252-FB5B7A8438EA}']
  { constructors } 

    {class} function init: DNCellWatch;

  end;

  ///<summary>
  ///  Represents Cell Watch Item in the 'watch window'.
  ///</summary>
  [DNTypeName('Aspose.Cells.CellWatch')]
  DNCellWatch = interface(DDN.mscorlib.DNObject)
  ['{9A340EE4-44C5-3F3C-8E04-A22108616862}']
  { getters & setters } 

    function get_Row: Int32;
    procedure set_Row(value: Int32);
    function get_Column: Int32;
    procedure set_Column(value: Int32);
    function get_CellName: string;
    procedure set_CellName(value: string);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets and sets the row of the cell.
    ///</summary>
    property Row: Int32 read get_Row write set_Row;
    ///<summary>
    ///  Gets and sets the column of the cell.
    ///</summary>
    property Column: Int32 read get_Column write set_Column;
    ///<summary>
    ///  Gets and sets the name of the cell.
    ///</summary>
    property CellName: string read get_CellName write set_CellName;
  end;

  TDNCellWatch = class(TDNGenericImport<DNCellWatchClass, DNCellWatch>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNAxisClass = interface(DDN.mscorlib.DNObjectClass)
  ['{B1E05970-E7D7-5E30-8545-6EBEEA0E4495}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents a chart's axis.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Adding a new worksheet to the Excel object
  ///  int sheetIndex = workbook.Worksheets.Add();
  ///  //Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Worksheet worksheet = workbook.Worksheets[sheetIndex];
  ///  //Adding a sample value to "A1" cell
  ///  worksheet.Cells["A1"].PutValue(50);
  ///  //Adding a sample value to "A2" cell
  ///  worksheet.Cells["A2"].PutValue(100);
  ///  //Adding a sample value to "A3" cell
  ///  worksheet.Cells["A3"].PutValue(150);
  ///  //Adding a sample value to "B1" cell
  ///  worksheet.Cells["B1"].PutValue(4);
  ///  //Adding a sample value to "B2" cell
  ///  worksheet.Cells["B2"].PutValue(20);
  ///  //Adding a sample value to "B3" cell
  ///  worksheet.Cells["B3"].PutValue(50);
  ///  //Adding a chart to the worksheet
  ///  int chartIndex = worksheet.Charts.Add(ChartType.Column, 5, 0, 25, 5);
  ///  //Accessing the instance of the newly added chart
  ///  Chart chart = worksheet.Charts[chartIndex];
  ///  //Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", true);
  ///  //Set the max value of value axis
  ///  chart.ValueAxis.MaxValue = 200;
  ///  //Set the min value of value axis
  ///  chart.ValueAxis.MinValue = 0;
  ///  //Set the major unit
  ///  chart.ValueAxis.MajorUnit = 25;
  ///  //Category(X) axis crosses at the maxinum value.
  ///  chart.ValueAxis.Crosses = CrossType.Maximum;
  ///  //Set he number of categories or series between tick-mark labels.
  ///  chart.CategoryAxis.TickLabelSpacing = 2;
  ///  //Saving the Excel file
  ///  workbook.Save("C:\\book1.xls");
  ///  [Visual Basic]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As Workbook = New Workbook()
  ///  'Adding a new worksheet to the Excel object
  ///  Dim sheetIndex As Int32 = workbook.Worksheets.Add()
  ///  'Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Dim worksheet As Worksheet = workbook.Worksheets(sheetIndex)
  ///  'Adding a sample value to "A1" cell
  ///  worksheet.Cells("A1").PutValue(50)
  ///  'Adding a sample value to "A2" cell
  ///  worksheet.Cells("A2").PutValue(100)
  ///  'Adding a sample value to "A3" cell
  ///  worksheet.Cells("A3").PutValue(150)
  ///  'Adding a sample value to "B1" cell
  ///  worksheet.Cells("B1").PutValue(4)
  ///  'Adding a sample value to "B2" cell
  ///  worksheet.Cells("B2").PutValue(20)
  ///  'Adding a sample value to "B3" cell
  ///  worksheet.Cells("B3").PutValue(50)
  ///  'Adding a chart to the worksheet
  ///  Dim chartIndex As Int32 = worksheet.Charts.Add(ChartType.Column, 5, 0, 25, 5)
  ///  'Accessing the instance of the newly added chart
  ///  Dim chart As Chart = worksheet.Charts(chartIndex)
  ///  'Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", True)
  ///  'Set the max value of value axis
  ///  chart.ValueAxis.MaxValue = 200
  ///  'Set the min value of value axis
  ///  chart.ValueAxis.MinValue = 0
  ///  'Set the major unit
  ///  chart.ValueAxis.MajorUnit = 25
  ///  'Category(X) axis crosses at the maxinum value.
  ///  chart.ValueAxis.Crosses = CrossType.Maximum
  ///  'Set he number of categories or series between tick-mark labels.
  ///  chart.CategoryAxis.TickLabelSpacing = 2
  ///  'Saving the Excel file
  ///  workbook.Save("C:\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.Axis')]
  DNAxis = interface(DDN.mscorlib.DNObject)
  ['{2D523194-8F60-376E-99CF-685770DBE7D7}']
  { getters & setters } 

    function get_Area: DNArea;
    function get_IsAutomaticMinValue: Boolean;
    procedure set_IsAutomaticMinValue(value: Boolean);
    function get_MinValue: DDN.mscorlib.DNObject;
    procedure set_MinValue(value: DDN.mscorlib.DNObject);
    function get_IsAutomaticMaxValue: Boolean;
    procedure set_IsAutomaticMaxValue(value: Boolean);
    function get_MaxValue: DDN.mscorlib.DNObject;
    procedure set_MaxValue(value: DDN.mscorlib.DNObject);
    function get_IsAutomaticMajorUnit: Boolean;
    procedure set_IsAutomaticMajorUnit(value: Boolean);
    function get_MajorUnit: Double;
    procedure set_MajorUnit(value: Double);
    function get_IsAutomaticMinorUnit: Boolean;
    procedure set_IsAutomaticMinorUnit(value: Boolean);
    function get_MinorUnit: Double;
    procedure set_MinorUnit(value: Double);
    function get_AxisLine: DNLine;
    function get_MajorTickMark: DNTickMarkType;
    procedure set_MajorTickMark(value: DNTickMarkType);
    function get_MinorTickMark: DNTickMarkType;
    procedure set_MinorTickMark(value: DNTickMarkType);
    function get_TickLabelPosition: DNTickLabelPositionType;
    procedure set_TickLabelPosition(value: DNTickLabelPositionType);
    function get_CrossAt: Double;
    procedure set_CrossAt(value: Double);
    function get_CrossType: DNCrossType;
    procedure set_CrossType(value: DNCrossType);
    function get_LogBase: Double;
    procedure set_LogBase(value: Double);
    function get_IsLogarithmic: Boolean;
    procedure set_IsLogarithmic(value: Boolean);
    function get_IsPlotOrderReversed: Boolean;
    procedure set_IsPlotOrderReversed(value: Boolean);
    function get_AxisBetweenCategories: Boolean;
    procedure set_AxisBetweenCategories(value: Boolean);
    function get_TickLabels: DNTickLabels;
    function get_TickLabelSpacing: Int32;
    procedure set_TickLabelSpacing(value: Int32);
    function get_IsAutoTickLabelSpacing: Boolean;
    procedure set_IsAutoTickLabelSpacing(value: Boolean);
    function get_TickMarkSpacing: Int32;
    procedure set_TickMarkSpacing(value: Int32);
    function get_DisplayUnit: DNDisplayUnitType;
    procedure set_DisplayUnit(value: DNDisplayUnitType);
    function get_CustUnit: Int32;
    procedure set_CustUnit(value: Int32);
    function get_DisplayUnitLabel: DNDisplayUnitLabel;
    function get_IsDisplayUnitLabelShown: Boolean;
    procedure set_IsDisplayUnitLabelShown(value: Boolean);
    function get_Title: DNTitle;
    function get_CategoryType: DNCategoryType;
    procedure set_CategoryType(value: DNCategoryType);
    function get_BaseUnitScale: DNTimeUnit;
    procedure set_BaseUnitScale(value: DNTimeUnit);
    function get_MajorUnitScale: DNTimeUnit;
    procedure set_MajorUnitScale(value: DNTimeUnit);
    function get_MinorUnitScale: DNTimeUnit;
    procedure set_MinorUnitScale(value: DNTimeUnit);
    function get_IsVisible: Boolean;
    procedure set_IsVisible(value: Boolean);
    function get_MajorGridLines: DNLine;
    function get_MinorGridLines: DNLine;
    function get_HasMultiLevelLabels: Boolean;
    procedure set_HasMultiLevelLabels(value: Boolean);
    function get_AxisLabels: DDN.mscorlib.DNArrayList;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.Axis.Area" />
    ///  .
    ///</summary>
    property Area: DNArea read get_Area;
    ///<summary>
    ///  Indicates whether the min value is automatically assigned.
    ///</summary>
    property IsAutomaticMinValue: Boolean read get_IsAutomaticMinValue write set_IsAutomaticMinValue;
    ///<summary>
    ///  Represents the minimum value on the value axis.
    ///</summary>
    ///<remarks>
    ///  The minValue type only can be double or DateTime
    ///</remarks>
    property MinValue: DDN.mscorlib.DNObject read get_MinValue write set_MinValue;
    ///<summary>
    ///  Indicates whether the max value is automatically assigned.
    ///</summary>
    property IsAutomaticMaxValue: Boolean read get_IsAutomaticMaxValue write set_IsAutomaticMaxValue;
    ///<summary>
    ///  Represents the maximum value on the value axis.
    ///</summary>
    ///<remarks>
    ///  The maxValue type only can be double or DateTime
    ///</remarks>
    property MaxValue: DDN.mscorlib.DNObject read get_MaxValue write set_MaxValue;
    ///<summary>
    ///  Indicates whether the major unit of the axis is automatically assigned.
    ///</summary>
    property IsAutomaticMajorUnit: Boolean read get_IsAutomaticMajorUnit write set_IsAutomaticMajorUnit;
    ///<summary>
    ///  Represents the major units for the axis.
    ///</summary>
    ///<remarks> The major units must be greater than zero.</remarks>
    property MajorUnit: Double read get_MajorUnit write set_MajorUnit;
    ///<summary>
    ///  Indicates whether the minor unit of the axis is automatically assigned.
    ///</summary>
    property IsAutomaticMinorUnit: Boolean read get_IsAutomaticMinorUnit write set_IsAutomaticMinorUnit;
    ///<summary>
    ///  Represents the minor units for the axis.
    ///</summary>
    ///<remarks> The minor units must be greater than zero.</remarks>
    property MinorUnit: Double read get_MinorUnit write set_MinorUnit;
    ///<summary>
    ///  Gets the appearance of an Axis.
    ///</summary>
    property AxisLine: DNLine read get_AxisLine;
    ///<summary>
    ///  Represents the type of major tick mark for the specified axis.
    ///</summary>
    property MajorTickMark: DNTickMarkType read get_MajorTickMark write set_MajorTickMark;
    ///<summary>
    ///  Represents the type of minor tick mark for the specified axis.
    ///</summary>
    property MinorTickMark: DNTickMarkType read get_MinorTickMark write set_MinorTickMark;
    ///<summary>
    ///  Represents the position of tick-mark labels on the specified axis.
    ///</summary>
    property TickLabelPosition: DNTickLabelPositionType read get_TickLabelPosition write set_TickLabelPosition;
    ///<summary>
    ///  Represents the point on the value axis where the category axis crosses it.
    ///</summary>
    ///<remarks>The number should be a integer when it applies to category axis.
    ///  And the value must be between 1 and 31999.</remarks>
    property CrossAt: Double read get_CrossAt write set_CrossAt;
    ///<summary>
    ///  Represents the <see cref="P:Aspose.Cells.Charts.Axis.CrossType" />
    ///  on the specified axis where the other axis crosses.
    ///</summary>
    property CrossType: DNCrossType read get_CrossType write set_CrossType;
    ///<summary>
    ///  Represents the logarithmic base. Default value is 10.Only applies for Excel2007.
    ///</summary>
    property LogBase: Double read get_LogBase write set_LogBase;
    ///<summary>
    ///  Represents if the value axis scale type is logarithmic or not.
    ///</summary>
    property IsLogarithmic: Boolean read get_IsLogarithmic write set_IsLogarithmic;
    ///<summary>
    ///  Represents if Microsoft Excel plots data points from last to first.
    ///</summary>
    property IsPlotOrderReversed: Boolean read get_IsPlotOrderReversed write set_IsPlotOrderReversed;
    ///<summary>
    ///  Represents if the value axis crosses the category axis between categories.
    ///</summary>
    ///<remarks>This property applies only to category axes, and it doesn't apply to 3-D charts.
    ///</remarks>
    property AxisBetweenCategories: Boolean read get_AxisBetweenCategories write set_AxisBetweenCategories;
    ///<summary>
    ///  Returns a <see cref="P:Aspose.Cells.Charts.Axis.TickLabels" />
    ///  object that represents the tick-mark labels for the specified axis.
    ///</summary>
    property TickLabels: DNTickLabels read get_TickLabels;
    ///<summary>
    ///  Represents the number of categories or series between tick-mark labels. Applies only to category and series axes.
    ///</summary>
    ///<remarks>The number must be between 1 and 31999.</remarks>
    property TickLabelSpacing: Int32 read get_TickLabelSpacing write set_TickLabelSpacing;
    ///<summary>
    ///  Indicates whether ticklabel spacing is automatic
    ///</summary>
    property IsAutoTickLabelSpacing: Boolean read get_IsAutoTickLabelSpacing write set_IsAutoTickLabelSpacing;
    ///<summary>
    ///  Returns or sets the number of categories or series between tick marks. Applies only to category and series axes.
    ///</summary>
    ///<remarks>The number must be between 1 and 31999.</remarks>
    property TickMarkSpacing: Int32 read get_TickMarkSpacing write set_TickMarkSpacing;
    ///<summary>
    ///  Represents the unit label for the specified axis.
    ///</summary>
    property DisplayUnit: DNDisplayUnitType read get_DisplayUnit write set_DisplayUnit;
    ///<summary>
    ///  Specifies a custom value for the display unit.
    ///</summary>
    property CustUnit: Int32 read get_CustUnit write set_CustUnit;
    ///<summary>
    ///  Represents a unit label on an axis in the specified chart.
    ///  Unit labels are useful for charting large values¡ª for example, in the millions or billions.
    ///</summary>
    property DisplayUnitLabel: DNDisplayUnitLabel read get_DisplayUnitLabel;
    ///<summary>
    ///  Represents if the display unit label is shown on the specified axis.
    ///</summary>
    ///<remarks>The default value is True.</remarks>
    property IsDisplayUnitLabelShown: Boolean read get_IsDisplayUnitLabelShown write set_IsDisplayUnitLabelShown;
    ///<summary>
    ///  Gets the axis' title.
    ///</summary>
    property Title: DNTitle read get_Title;
    ///<summary>
    ///  Represents the category axis type.
    ///</summary>
    property CategoryType: DNCategoryType read get_CategoryType write set_CategoryType;
    ///<summary>
    ///  Represents the base unit scale for the category axis.
    ///</summary>
    ///<remarks>Setting this property only takes effect when the CategoryType property is set to TimeScale.</remarks>
    property BaseUnitScale: DNTimeUnit read get_BaseUnitScale write set_BaseUnitScale;
    ///<summary>
    ///  Represents the major unit scale for the category axis.
    ///</summary>
    ///<example><code>
    ///  [C#]
    ///  chart.CategoryAxis.CategoryType = CategoryType.TimeScale;
    ///  chart.CategoryAxis.MajorUnitScale = TimeUnit.Months;
    ///  chart.CategoryAxis.MajorUnit = 2;
    ///  [Visual Basic]
    ///  chart.CategoryAxis.CategoryType = CategoryType.TimeScale
    ///  chart.CategoryAxis.MajorUnitScale = TimeUnit.Months
    ///  chart.CategoryAxis.MajorUnit = 2
    ///</code></example>
    property MajorUnitScale: DNTimeUnit read get_MajorUnitScale write set_MajorUnitScale;
    ///<summary>
    ///  Represents the major unit scale for the category axis.
    ///</summary>
    ///<example><code>
    ///  [C#]
    ///  chart.CategoryAxis.CategoryType = CategoryType.TimeScale;
    ///  chart.CategoryAxis.MinorUnitScale = TimeUnit.Months;
    ///  chart.CategoryAxis.MinorUnit = 2;
    ///  [Visual Basic]
    ///  chart.CategoryAxis.CategoryType = CategoryType.TimeScale
    ///  chart.CategoryAxis.MinorUnitScale = TimeUnit.Months
    ///  chart.CategoryAxis.MinorUnit = 2
    ///</code></example>
    property MinorUnitScale: DNTimeUnit read get_MinorUnitScale write set_MinorUnitScale;
    ///<summary>
    ///  Represents if the axis is visible.
    ///</summary>
    property IsVisible: Boolean read get_IsVisible write set_IsVisible;
    ///<summary>
    ///  Represents major gridlines on a chart axis.
    ///</summary>
    ///<example><code>
    ///  [C#]
    ///  chart.ValueAxis.MajorGridLines.IsVisible = false;
    ///  chart.CategoryAxis.MajorGridLines.IsVisible = true;
    ///  [Visual Basic]
    ///  chart.ValueAxis.MajorGridLines.IsVisible = false
    ///  chart.CategoryAxis.MajorGridLines.IsVisible = true
    ///</code></example>
    property MajorGridLines: DNLine read get_MajorGridLines;
    ///<summary>
    ///  Represents minor gridlines on a chart axis.
    ///</summary>
    property MinorGridLines: DNLine read get_MinorGridLines;
    ///<summary>
    ///  Indicates whether the labels shall be shown as multi level.
    ///</summary>
    ///<remarks>
    ///  Only valid for category axis.
    ///</remarks>
    property HasMultiLevelLabels: Boolean read get_HasMultiLevelLabels write set_HasMultiLevelLabels;
    ///<summary>
    ///  Gets the labels of the axis after call Chart.Calculate() method.
    ///</summary>
    property AxisLabels: DDN.mscorlib.DNArrayList read get_AxisLabels;
  end;

  TDNAxis = class(TDNGenericImport<DNAxisClass, DNAxis>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNChartClass = interface(DDN.mscorlib.DNObjectClass)
  ['{C84BC57F-C1DB-5B69-BB5F-470EC6B2D8EC}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents a single Excel chart.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  Workbook workbook = new Workbook();
  ///  Worksheet sheet = workbook.Worksheets[0];
  ///  Cells cells = sheet.Cells;
  ///  cells[0,1].PutValue("Income");
  ///  cells[1,0].PutValue("Company A");
  ///  cells[2,0].PutValue("Company B");
  ///  cells[3,0].PutValue("Company C");
  ///  cells[1,1].PutValue(10000);
  ///  cells[2,1].PutValue(20000);
  ///  cells[3,1].PutValue(30000);
  ///  int chartIndex = sheet.Charts.Add(ChartType.Column, 9, 9, 21, 15);
  ///  Chart chart = sheet.Charts[chartIndex];
  ///  chart.NSeries.Add("B2:B4", true);
  ///  chart.NSeries.CategoryData = "A2:A4";
  ///  ASeries aSeries = chart.NSeries[0];
  ///  aSeries.Name = "=B1";
  ///  chart.IsLegendShown = true;
  ///  chart.Title.Text = "Income Analysis";
  ///  [Visual Basic]
  ///  Dim workbook as Workbook = new Workbook()
  ///  Dim sheet as Worksheet = workbook.Worksheets(0)
  ///  Dim cells as Cells = sheet.Cells
  ///  cells(0,1).PutValue("Income")
  ///  cells(1,0).PutValue("Company A")
  ///  cells(2,0).PutValue("Company B")
  ///  cells(3,0).PutValue("Company C")
  ///  cells(1,1).PutValue(10000)
  ///  cells(2,1).PutValue(20000)
  ///  cells(3,1).PutValue(30000)
  ///  Dim chartIndex as Integer = sheet.Charts.Add(ChartType.Column, 9, 9, 21, 15)
  ///  Dim chart as Chart = sheet.Charts(chartIndex)
  ///  chart.NSeries.Add("B2:B4", true)
  ///  chart.NSeries.CategoryData = "A2:A4"
  ///  Dim aSeries as ASeries = chart.NSeries(0)
  ///  aSeries.Name = "=B1"
  ///  chart.IsLegendShown = true
  ///  chart.Title.Text = "Income Analysis"
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.Chart')]
  DNChart = interface(DDN.mscorlib.DNObject)
  ['{9314917D-B876-3249-8DE8-F46F54244A31}']
  { getters & setters } 

    function get_Style: Int32;
    procedure set_Style(value: Int32);
    function get_ChartObject: DNChartShape;
    function get_HidePivotFieldButtons: Boolean;
    procedure set_HidePivotFieldButtons(value: Boolean);
    function get_PivotOptions: DNPivotOptions;
    function get_PivotSource: string;
    procedure set_PivotSource(value: string);
    function get_PlotBy: DNPlotDataByType;
    function get_PlotEmptyCellsType: DNPlotEmptyCellsType;
    procedure set_PlotEmptyCellsType(value: DNPlotEmptyCellsType);
    function get_PlotVisibleCells: Boolean;
    procedure set_PlotVisibleCells(value: Boolean);
    function get_DisplayNaAsBlank: Boolean;
    procedure set_DisplayNaAsBlank(value: Boolean);
    function get_Name: string;
    procedure set_Name(value: string);
    function get_SizeWithWindow: Boolean;
    procedure set_SizeWithWindow(value: Boolean);
    function get_Worksheet: DNWorksheet;
    function get_Shapes: DNShapeCollection;
    function get_PrintSize: DNPrintSizeType;
    procedure set_PrintSize(value: DNPrintSizeType);
    function get_Type: DNChartType;
    procedure set_Type(value: DNChartType);
    function get_NSeries: DNSeriesCollection;
    function get_Title: DNTitle;
    function get_SubTitle: DNTitle;
    function get_PlotArea: DNPlotArea;
    function get_ChartArea: DNChartArea;
    function get_CategoryAxis: DNAxis;
    function get_ValueAxis: DNAxis;
    function get_SecondValueAxis: DNAxis;
    function get_SecondCategoryAxis: DNAxis;
    function get_SeriesAxis: DNAxis;
    function get_Legend: DNLegend;
    function get_ChartDataTable: DNChartDataTable;
    function get_ShowLegend: Boolean;
    procedure set_ShowLegend(value: Boolean);
    function get_IsRectangularCornered: Boolean;
    procedure set_IsRectangularCornered(value: Boolean);
    function get_ShowDataTable: Boolean;
    procedure set_ShowDataTable(value: Boolean);
    function get_FirstSliceAngle: Int32;
    procedure set_FirstSliceAngle(value: Int32);
    function get_GapWidth: Int32;
    procedure set_GapWidth(value: Int32);
    function get_GapDepth: Int32;
    procedure set_GapDepth(value: Int32);
    function get_Floor: DNFloor;
    function get_Walls: DNWalls;
    function get_BackWall: DNWalls;
    function get_SideWall: DNWalls;
    function get_WallsAndGridlines2D: Boolean;
    procedure set_WallsAndGridlines2D(value: Boolean);
    function get_RotationAngle: Int32;
    procedure set_RotationAngle(value: Int32);
    function get_Elevation: Int32;
    procedure set_Elevation(value: Int32);
    function get_RightAngleAxes: Boolean;
    procedure set_RightAngleAxes(value: Boolean);
    function get_AutoScaling: Boolean;
    procedure set_AutoScaling(value: Boolean);
    function get_HeightPercent: Int32;
    procedure set_HeightPercent(value: Int32);
    function get_Perspective: Int16;
    procedure set_Perspective(value: Int16);
    function get_Is3D: Boolean;
    function get_DepthPercent: Int32;
    procedure set_DepthPercent(value: Int32);
    function get_ActualChartSize: DDN.System.Drawing.DNSize;
    function get_Placement: DNPlacementType;
    procedure set_Placement(value: DNPlacementType);
    function get_PageSetup: DNPageSetup;
    function get_Line: DNLine;

  { methods } 

    ///<summary>
    ///  Gets a 32-bit <c>Bitmap</c> object of the chart.
    ///</summary>
    ///<returns>the picture of the chart.</returns>
    ///<remarks>
    ///  If the width or height is zero or the chart is not supported according to Supported Charts List, it will return null.
    ///  Please refer to <a href="http://www.aspose.com/documentation/.net-components/aspose.cells-for-.net/converting-chart-to-image.html">Supported Charts List</a> for more details.
    ///</remarks>
    function ToImage: DDN.System.Drawing.DNBitmap; overload;
    ///<summary>
    ///  Gets a 32-bit <c>Bitmap</c> object of the chart.
    ///<c>ImageOrPrintOptions.ImageFormat</c>, ImageOrPrintOptions.TiffCompression and ImageOrPrintOptions.Quality attributes are ignored.
    ///</summary>
    ///  <param name="options">Additional image creation options</param>
    ///<returns>the picture of the chart.</returns>
    ///<remarks>
    ///  Returns a 32-bit bitmap object, so ImageOrPrintOptions.ImageFormat, ImageOrPrintOptions.TiffCompression and ImageOrPrintOptions.Quality
    ///  attributes do not affect the method.
    ///  If the width or height is zero or the chart is not supported according to Supported Charts List, it will return null.
    ///  Please refer to <a href="http://www.aspose.com/documentation/.net-components/aspose.cells-for-.net/converting-chart-to-image.html">Supported Charts List</a> for more details.
    ///</remarks>
    ///<example>
    ///  Gets a bitmap object with 200 x dpi and 300 y dpi.
    ///<code>
    ///  [C#]
    ///  ImageOrPrintOptions options = new ImageOrPrintOptions();
    ///  options.HorizontalResolution = 200;
    ///  options.VerticalResolution = 300;
    ///  Workbook book = new Workbook(@"c:\test.xls");
    ///  Bitmap chartObject = book.Worksheets[0].Charts[0].ToImage(options);
    ///  [VB]
    ///  Dim options As ImageOrPrintOptions =  New ImageOrPrintOptions()
    ///  options.HorizontalResolution = 200
    ///  options.VerticalResolution = 300
    ///  Dim book As Workbook =  New Workbook("c:\test.xls")
    ///  Dim chartObject As Bitmap = book.Worksheets(0).Charts(0).ToImage(options)
    ///</code></example>
    function ToImage(options: DNImageOrPrintOptions): DDN.System.Drawing.DNBitmap; overload;
    ///<summary>
    ///  Creates the chart image and saves it to a file.
    ///  The extension of the file name determines the format of the image.
    ///</summary>
    ///  <param name="imageFile">The image file name with full path.</param>
    ///<remarks><p>The format of the image is specified by using the extension of the file name.
    ///  For example, if you specify "myfile.png", then the image will be saved
    ///  in the PNG format. The following file extensions are recognized:
    ///  .bmp, .gif, .png, .jpg, .jpeg, .tiff, .tif, .emf.</p>
    ///  If the width or height is zero or the chart is not supported according to Supported Charts List, this method will do nothing.
    ///  Please refer to <a href="http://www.aspose.com/documentation/.net-components/aspose.cells-for-.net/converting-chart-to-image.html">Supported Charts List</a> for more details.
    ///</remarks>
    procedure ToImage(imageFile: string); overload;
    ///<summary>
    ///  Creates the chart image and saves it to a file in the specified format.
    ///</summary>
    ///  <param name="imageFile">The image file name with full path.</param>
    ///  <param name="imageFormat">The format in which to save the image.</param>
    ///<remarks><p>The format of the image is specified by using <c>imageFormat</c>.
    ///  The following formats are supported:
    ///  ImageFormat.Bmp, ImageFormat.Gif, ImageFormat.Png, ImageFormat.Jpeg, ImageFormat.Tiff, ImageFormat.Emf.</p>
    ///  If the width or height is zero or the chart is not supported according to Supported Charts List, this method will do nothing.
    ///  Please refer to <a href="http://www.aspose.com/documentation/.net-components/aspose.cells-for-.net/converting-chart-to-image.html">Supported Charts List</a> for more details.
    ///</remarks>
    procedure ToImage(imageFile: string; imageFormat: DDN.System.Drawing.DNImageFormat); overload;
    ///<summary>
    ///  Creates the chart image and saves it to a file in the Jpeg format.
    ///</summary>
    ///  <param name="imageFile">The image file name with full path.</param>
    ///  <param name="jpegQuality">Jpeg quality.</param>
    ///<remarks>
    ///  If the width or height is zero or the chart is not supported according to Supported Charts List, this method will do nothing.
    ///  Please refer to <a href="http://www.aspose.com/documentation/.net-components/aspose.cells-for-.net/converting-chart-to-image.html">Supported Charts List</a> for more details.
    ///</remarks>
    procedure ToImage(imageFile: string; jpegQuality: Int64); overload;
    ///<summary>
    ///  Creates the chart image and saves it to a stream in the Jpeg format.
    ///</summary>
    ///  <param name="stream">The output stream.</param>
    ///  <param name="jpegQuality">Jpeg quality.</param>
    ///<remarks>
    ///  If the width or height is zero or the chart is not supported according to Supported Charts List, this method will do nothing.
    ///  Please refer to <a href="http://www.aspose.com/documentation/.net-components/aspose.cells-for-.net/converting-chart-to-image.html">Supported Charts List</a> for more details.
    ///</remarks>
    procedure ToImage(stream: DDN.mscorlib.DNStream; jpegQuality: Int64); overload;
    ///<summary>
    ///  Creates the chart image and saves it to a stream in the specified format.
    ///</summary>
    ///  <param name="stream">The output stream.</param>
    ///  <param name="imageFormat">The format in which to save the image.</param>
    ///<remarks><p>The format of the image is specified by using <c>imageFormat</c>.
    ///  The following formats are supported:
    ///  ImageFormat.Bmp, ImageFormat.Gif, ImageFormat.Png, ImageFormat.Jpeg, ImageFormat.Tiff, ImageFormat.Emf.</p>
    ///  If the width or height is zero or the chart is not supported according to Supported Charts List, this method will do nothing.
    ///  Please refer <a href="http://www.aspose.com/documentation/.net-components/aspose.cells-for-.net/converting-chart-to-image.html">Supported Charts List</a> for more details.
    ///</remarks>
    procedure ToImage(stream: DDN.mscorlib.DNStream; imageFormat: DDN.System.Drawing.DNImageFormat); overload;
    ///<summary>
    ///  Saves the chart to a pdf file.
    ///</summary>
    ///  <param name="fileName">the pdf file name with full path</param>
    procedure ToPdf(fileName: string); overload;
    ///<summary>
    ///  Saves the chart to a pdf file.
    ///</summary>
    ///  <param name="fileName">the pdf file name with full path</param>
    ///  <param name="desiredPageWidth">The desired page width in inches.</param>
    ///  <param name="desiredPageHeight">The desired page height in inches.</param>
    ///  <param name="hAlignmentType">The chart horizontal alignment type in the output page.</param>
    ///  <param name="vAlignmentType">The chart vertical alignment type in the output page.</param>
    procedure ToPdf(fileName: string; desiredPageWidth: Single; desiredPageHeight: Single; hAlignmentType: DNPageLayoutAlignmentType; vAlignmentType: DNPageLayoutAlignmentType); overload;
    ///<summary>
    ///  Creates the chart pdf and saves it to a stream.
    ///</summary>
    ///  <param name="stream">The output stream.</param>
    procedure ToPdf(stream: DDN.mscorlib.DNStream); overload;
    ///<summary>
    ///  Creates the chart pdf and saves it to a stream.
    ///</summary>
    ///  <param name="stream">The output stream.</param>
    ///  <param name="desiredPageWidth">The desired page width in inches.</param>
    ///  <param name="desiredPageHeight">The desired page height in inches.</param>
    ///  <param name="hAlignmentType">The chart horizontal alignment type in the output page.</param>
    ///  <param name="vAlignmentType">The chart vertical alignment type in the output page.</param>
    procedure ToPdf(stream: DDN.mscorlib.DNStream; desiredPageWidth: Single; desiredPageHeight: Single; hAlignmentType: DNPageLayoutAlignmentType; vAlignmentType: DNPageLayoutAlignmentType); overload;
    ///<summary>
    ///  Creates the chart image and saves it to a file.
    ///  The extension of the file name determines the format of the image.
    ///</summary>
    ///  <param name="imageFile">The image file name with full path.</param>
    ///  <param name="options">Additional image creation options</param>
    ///<remarks><p>The format of the image is specified by using the extension of the file name.
    ///  For example, if you specify "myfile.png", then the image will be saved
    ///  in the PNG format. The following file extensions are recognized:
    ///  .bmp, .gif, .png, .jpg, .jpeg, .tiff, .tif, .emf.</p>
    ///  If the width or height is zero or the chart is not supported according to Supported Charts List, this method will do nothing.
    ///  Please refer to <a href="http://www.aspose.com/documentation/.net-components/aspose.cells-for-.net/converting-chart-to-image.html">Supported Charts List</a> for more details.
    ///</remarks>
    ///<example>
    ///  Saves to Tiff with 300 dpi and CCITT4 compression.
    ///<code>
    ///  [C#]
    ///  ImageOrPrintOptions options = new ImageOrPrintOptions();
    ///  options.HorizontalResolution = 300;
    ///  options.VerticalResolution = 300;
    ///  options.TiffCompression = TiffCompression.CompressionCCITT4;
    ///  Workbook book = new Workbook(@"c:\test.xls");
    ///  book.Worksheets[0].Charts[0].ToImage(@"c:\chart.Tiff", options);
    ///  [VB]
    ///  Dim options As ImageOrPrintOptions =  New ImageOrPrintOptions()
    ///  options.HorizontalResolution = 300
    ///  options.VerticalResolution = 300
    ///  options.TiffCompression = TiffCompression.CompressionCCITT4
    ///  Dim book As Workbook =  New Workbook("c:\test.xls")
    ///  book.Worksheets(0).Charts(0).ToImage("c:\chart.Tiff", options)
    ///</code>
    ///  Saves to Jpeg with 300 dpi and 80 image quality.
    ///<code>
    ///  [C#]
    ///  ImageOrPrintOptions options = new ImageOrPrintOptions();
    ///  options.HorizontalResolution = 300;
    ///  options.VerticalResolution = 300;
    ///  options.Quality = 80;
    ///  Workbook book = new Workbook(@"c:\test.xls");
    ///  book.Worksheets[0].Charts[0].ToImage(@"c:\chart.Jpeg", options);
    ///  [VB]
    ///  Dim options As ImageOrPrintOptions =  New ImageOrPrintOptions()
    ///  options.HorizontalResolution = 300
    ///  options.VerticalResolution = 300
    ///  options.Quality = 80
    ///  Dim book As Workbook =  New Workbook("c:\test.xls")
    ///  book.Worksheets(0).Charts(0).ToImage("c:\chart.Jpeg", options)
    ///</code></example>
    procedure ToImage(imageFile: string; options: DNImageOrPrintOptions); overload;
    ///<summary>
    ///  Creates the chart image and saves it to a stream in the specified format.
    ///</summary>
    ///  <param name="stream">The output stream.</param>
    ///  <param name="options">Additional image creation options</param>
    ///<remarks><p>The format of the image is specified by using <c>options.ImageFormat</c>.
    ///  The following formats are supported:
    ///  ImageFormat.Bmp, ImageFormat.Gif, ImageFormat.Png, ImageFormat.Jpeg, ImageFormat.Tiff, ImageFormat.Emf.</p>
    ///  If the width or height is zero or the chart is not supported according to Supported Charts List, this method will do nothing.
    ///  Please refer to <a href="http://www.aspose.com/documentation/.net-components/aspose.cells-for-.net/converting-chart-to-image.html">Supported Charts List</a> for more details.
    ///</remarks>
    procedure ToImage(stream: DDN.mscorlib.DNStream; options: DNImageOrPrintOptions); overload;
    ///<summary>
    ///  Returns which axes exist on the chart.
    ///</summary>
    ///<remarks>
    ///  Normally, Pie, PieExploded, PiePie,PieBar, Pie3D, Pie3DExploded,Doughnut, DoughnutExploded is no axis.
    ///</remarks>
    function HasAxis(aixsType: DNAxisType; isPrimary: Boolean): Boolean;
    ///<summary>
    ///  Switches row/column.
    ///</summary>
    ///<returns>
    ///  False means switching row/column fails.
    ///</returns>
    function SwitchRowColumn: Boolean;
    ///<summary>
    ///  Gets the data source range of the chart .
    ///</summary>
    ///<returns>The data source.</returns>
    ///<remarks>
    ///  Only supports range.
    ///</remarks>
    function GetChartDataRange: string;
    ///<summary>
    ///  Specifies data range for a chart.
    ///</summary>
    ///  <param name="area">Specifies values from which to plot the data series</param>
    ///  <param name="isVertical">Specifies whether to plot the series from a range of cell values by row or by column.</param>
    procedure SetChartDataRange(area: string; isVertical: Boolean);
    ///<summary>
    ///  Detects if a chart's data source has changed.
    ///</summary>
    ///<remarks>
    ///  The method detects the changes in the chart's data source before rendering the chart to image format.
    ///  At first Chart.toImage call, the chart source data (e.g. XValuesParseData, ValuesParseData) will be recorded.
    ///  Before calling the Chart.toImage method again, call IsChartDataChanged method to check if Chart needs re-rendering.
    ///</remarks>
    ///<returns>Returns true if the chart has changed otherwise returns false</returns>
    function IsChartDataChanged: Boolean;
    ///<summary>
    ///  Refreshes pivot chart's data  from it's pivot data source.
    ///</summary>
    ///<remarks>
    ///  We will gather data from pivot data source to the pivot chart cache.
    ///  This method is only used to gather all data to a pivot chart.
    ///</remarks>
    procedure RefreshPivotData;
    ///<summary>
    ///  Moves the chart to a specified location.
    ///</summary>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="lowerRightColumn">Lower right column index</param>
    ///  <param name="lowerRightRow">Lower right row index</param>
    procedure Move(upperLeftRow: Int32; upperLeftColumn: Int32; lowerRightRow: Int32; lowerRightColumn: Int32);
    ///<summary>
    ///  Calculates the custom position of plot area, axes if the position of them are auto assigned.
    ///</summary>
    procedure Calculate;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets and sets the builtin style.
    ///</summary>
    ///<remarks>
    ///  It should be between 1 and 48.
    ///  Return -1 if it's not be set.
    ///</remarks>
    property Style: Int32 read get_Style write set_Style;
    ///<summary>
    ///  Represents the chartShape;
    ///</summary>
    property ChartObject: DNChartShape read get_ChartObject;
    ///<summary>
    ///  Indicates whether hide the pivot chart field buttons only when the chart is PivotChart
    ///</summary>
    property HidePivotFieldButtons: Boolean read get_HidePivotFieldButtons write set_HidePivotFieldButtons;
    ///<summary>
    ///  Specifies the pivot controls that appear on the chart
    ///</summary>
    property PivotOptions: DNPivotOptions read get_PivotOptions;
    ///<summary>
    ///  The source is the data of the pivotTable.
    ///  If PivotSource is not empty ,the chart is PivotChart.
    ///</summary>
    ///<remarks>If the pivot table  "PivotTable1" in the Worksheet "Sheet1" in the file "Book1.xls".
    ///  The pivotSource could be "[Book1.xls]Sheet1!PivotTable1" if the chart and the PivotTable is not in the same workbook.
    ///  If you set this property ,the previous data source setting will be lost.
    ///</remarks>
    property PivotSource: string read get_PivotSource write set_PivotSource;
    ///<summary>
    ///  Gets and sets whether plot by row or column.
    ///</summary>
    property PlotBy: DNPlotDataByType read get_PlotBy;
    ///<summary>
    ///  Gets and sets  how to plot the empty cells.
    ///</summary>
    property PlotEmptyCellsType: DNPlotEmptyCellsType read get_PlotEmptyCellsType write set_PlotEmptyCellsType;
    ///<summary>
    ///  Indicates whether only plot visible cells.
    ///</summary>
    property PlotVisibleCells: Boolean read get_PlotVisibleCells write set_PlotVisibleCells;
    ///<summary>
    ///  Indicates whether displaying #N/A as blank value.
    ///</summary>
    property DisplayNaAsBlank: Boolean read get_DisplayNaAsBlank write set_DisplayNaAsBlank;
    ///<summary>
    ///  Gets and sets the name of the chart.
    ///</summary>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  True if Microsoft Excel resizes the chart to match the size of the chart sheet window.
    ///</summary>
    property SizeWithWindow: Boolean read get_SizeWithWindow write set_SizeWithWindow;
    ///<summary>
    ///  Gets the worksheet which contains this chart.
    ///</summary>
    property Worksheet: DNWorksheet read get_Worksheet;
    ///<summary>
    ///  Returns all drawing shapes in this chart.
    ///</summary>
    property Shapes: DNShapeCollection read get_Shapes;
    ///<summary>
    ///  Gets and sets the printed chart size.
    ///</summary>
    property PrintSize: DNPrintSizeType read get_PrintSize write set_PrintSize;
    ///<summary>
    ///  Gets or sets a chart's type.
    ///</summary>
    property &Type: DNChartType read get_Type write set_Type;
    ///<summary>
    ///  Gets a <see cref="T:Aspose.Cells.Charts.SeriesCollection" />
    ///  collection representing the data series in the chart.
    ///</summary>
    property NSeries: DNSeriesCollection read get_NSeries;
    ///<summary>
    ///  Gets the chart's title.
    ///</summary>
    property Title: DNTitle read get_Title;
    ///<summary>
    ///  Gets the chart's sub-title.
    ///  Only for ODS format file.
    ///</summary>
    property SubTitle: DNTitle read get_SubTitle;
    ///<summary>
    ///  Gets the chart's plot area which includes axis tick labels.
    ///</summary>
    ///<remarks></remarks>
    property PlotArea: DNPlotArea read get_PlotArea;
    ///<summary>
    ///  Gets the chart area in the worksheet
    ///</summary>
    property ChartArea: DNChartArea read get_ChartArea;
    ///<summary>
    ///  Gets the chart's X axis.
    ///</summary>
    property CategoryAxis: DNAxis read get_CategoryAxis;
    ///<summary>
    ///  Gets the chart's Y axis.
    ///</summary>
    property ValueAxis: DNAxis read get_ValueAxis;
    ///<summary>
    ///  Gets the chart's second Y axis.
    ///</summary>
    property SecondValueAxis: DNAxis read get_SecondValueAxis;
    ///<summary>
    ///  Gets the chart's second X axis.
    ///</summary>
    property SecondCategoryAxis: DNAxis read get_SecondCategoryAxis;
    ///<summary>
    ///  Gets the chart's series axis.
    ///</summary>
    property SeriesAxis: DNAxis read get_SeriesAxis;
    ///<summary>
    ///  Gets the chart legend.
    ///</summary>
    property Legend: DNLegend read get_Legend;
    ///<summary>
    ///  Represents the chart data table.
    ///</summary>
    property ChartDataTable: DNChartDataTable read get_ChartDataTable;
    ///<summary>
    ///  Gets or sets a value indicating whether the chart legend will be displayed. Default is true.
    ///</summary>
    property ShowLegend: Boolean read get_ShowLegend write set_ShowLegend;
    ///<summary>
    ///  Gets or sets a value indicating whether the chart area is rectangular cornered.
    ///  Default is true.
    ///</summary>
    property IsRectangularCornered: Boolean read get_IsRectangularCornered write set_IsRectangularCornered;
    ///<summary>
    ///  Gets or sets a value indicating whether the chart displays a data table.
    ///</summary>
    property ShowDataTable: Boolean read get_ShowDataTable write set_ShowDataTable;
    ///<summary>
    ///  Gets or sets the angle of the first pie-chart or doughnut-chart slice, in degrees (clockwise from vertical). Applies only to pie, 3-D pie, and doughnut charts, 0 to 360.
    ///</summary>
    property FirstSliceAngle: Int32 read get_FirstSliceAngle write set_FirstSliceAngle;
    ///<summary>
    ///  Returns or sets the space between bar or column clusters, as a percentage of the bar or column width.
    ///  The value of this property must be between 0 and 500.
    ///</summary>
    property GapWidth: Int32 read get_GapWidth write set_GapWidth;
    ///<summary>
    ///  Gets or sets the distance between the data series in a 3-D chart, as a percentage of the marker width.
    ///  The value of this property must be between 0 and 500.
    ///</summary>
    property GapDepth: Int32 read get_GapDepth write set_GapDepth;
    ///<summary>
    ///  Returns a <see cref="P:Aspose.Cells.Charts.Chart.Floor" />
    ///  object that represents the walls of a 3-D chart.
    ///</summary>
    ///<remarks>This property doesn't apply to 3-D pie charts.</remarks>
    property Floor: DNFloor read get_Floor;
    ///<summary>
    ///  Returns a <see cref="P:Aspose.Cells.Charts.Chart.Walls" />
    ///  object that represents the walls of a 3-D chart.
    ///</summary>
    ///<remarks>This property doesn't apply to 3-D pie charts.</remarks>
    property Walls: DNWalls read get_Walls;
    ///<summary>
    ///  Returns a <see cref="P:Aspose.Cells.Charts.Chart.Walls" />
    ///  object that represents the back wall of a 3-D chart.
    ///</summary>
    property BackWall: DNWalls read get_BackWall;
    ///<summary>
    ///  Returns a <see cref="P:Aspose.Cells.Charts.Chart.Walls" />
    ///  object that represents the side wall of a 3-D chart.
    ///</summary>
    property SideWall: DNWalls read get_SideWall;
    ///<summary>
    ///  True if gridlines are drawn two-dimensionally on a 3-D chart.
    ///</summary>
    property WallsAndGridlines2D: Boolean read get_WallsAndGridlines2D write set_WallsAndGridlines2D;
    ///<summary>
    ///  Represents the rotation of the 3-D chart view (the rotation of the plot area around the z-axis, in degrees).
    ///</summary>
    ///<remarks>
    ///  The value of this property must be from 0 to 360, except for 3-D bar charts, where the value must be from 0 to 44.
    ///  The default value is 20. Applies only to 3-D charts.
    ///</remarks>
    property RotationAngle: Int32 read get_RotationAngle write set_RotationAngle;
    ///<summary>
    ///  Represents the elevation of the 3-D chart view, in degrees.
    ///</summary>
    ///<remarks>
    ///  The chart elevation is the height at which you view the chart, in degrees.
    ///  The default is 15 for most chart types.
    ///  The value of this property must be between -90 and 90, except for 3-D bar charts, where it must be between 0 and 44.
    ///</remarks>
    property Elevation: Int32 read get_Elevation write set_Elevation;
    ///<summary>
    ///  True if the chart axes are at right angles.Applies only for 3-D charts(except Column3D and 3-D Pie Charts).
    ///</summary>
    ///<remarks>
    ///  If this property is True, the Perspective property is ignored.
    ///</remarks>
    property RightAngleAxes: Boolean read get_RightAngleAxes write set_RightAngleAxes;
    ///<summary>
    ///  True if Microsoft Excel scales a 3-D chart so that it's closer in size to the equivalent 2-D chart.
    ///  The RightAngleAxes property must be True.
    ///</summary>
    property AutoScaling: Boolean read get_AutoScaling write set_AutoScaling;
    ///<summary>
    ///  Returns or sets the height of a 3-D chart as a percentage of the chart width (between 5 and 500 percent).
    ///</summary>
    property HeightPercent: Int32 read get_HeightPercent write set_HeightPercent;
    ///<summary>
    ///  Returns or sets the perspective for the 3-D chart view. Must be between 0 and 100.
    ///  This property is ignored if the RightAngleAxes property is True.
    ///</summary>
    property Perspective: Int16 read get_Perspective write set_Perspective;
    ///<summary>
    ///  Indicates whether the chart is a 3d chart.
    ///</summary>
    property Is3D: Boolean read get_Is3D;
    ///<summary>
    ///  Represents the depth of a 3-D chart as a percentage of the chart width (between 20 and 2000 percent).
    ///</summary>
    property DepthPercent: Int32 read get_DepthPercent write set_DepthPercent;
    ///<summary>
    ///  Gets actual size of chart
    ///</summary>
    property ActualChartSize: DDN.System.Drawing.DNSize read get_ActualChartSize;
    ///<summary>
    ///  Represents the way the chart is attached to the cells below it.
    ///</summary>
    property Placement: DNPlacementType read get_Placement write set_Placement;
    ///<summary>
    ///  Represents the page setup description in this chart.
    ///</summary>
    property PageSetup: DNPageSetup read get_PageSetup;
    ///<summary>
    ///  Gets the line.
    ///</summary>
    property Line: DNLine read get_Line;
  end;

  TDNChart = class(TDNGenericImport<DNChartClass, DNChart>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNChartDataTableClass = interface(DDN.mscorlib.DNObjectClass)
  ['{CA2F420F-A4BA-5226-98C1-804325C2900E}']
  end;

  ///<summary>
  ///  Represents a chart data table.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Obtaining the reference of the first worksheet
  ///  Worksheet worksheet = workbook.Worksheets[0];
  ///  //Adding a sample value to "A1" cell
  ///  worksheet.Cells["A1"].PutValue(50);
  ///  //Adding a sample value to "A2" cell
  ///  worksheet.Cells["A2"].PutValue(100);
  ///  //Adding a sample value to "A3" cell
  ///  worksheet.Cells["A3"].PutValue(150);
  ///  //Adding a sample value to "B1" cell
  ///  worksheet.Cells["B1"].PutValue(60);
  ///  //Adding a sample value to "B2" cell
  ///  worksheet.Cells["B2"].PutValue(32);
  ///  //Adding a sample value to "B3" cell
  ///  worksheet.Cells["B3"].PutValue(50);
  ///  //Adding a chart to the worksheet
  ///  int chartIndex = worksheet.Charts.Add(ChartType.Column, 5, 0, 25, 10);
  ///  //Accessing the instance of the newly added chart
  ///  Chart chart = worksheet.Charts[chartIndex];
  ///  //Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", true);
  ///  chart.IsDataTableShown = true;
  ///  //Getting Chart Table
  ///  ChartDataTable chartTable = chart.ChartDataTable;
  ///  //Setting Chart Table Font Color
  ///  chartTable.Font.Color = System.Drawing.Color.Red;
  ///  //Setting Legend Key VisibilityOptions
  ///  chartTable.ShowLegendKey = false;
  ///  //Saving the Excel file
  ///  workbook.Save("D:\\book1.xls");
  ///  [VB.NET]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As New Workbook()
  ///  'Obtaining the reference of the first worksheet
  ///  Dim worksheet As Worksheet = workbook.Worksheets(0)
  ///  'Adding a sample value to "A1" cell
  ///  worksheet.Cells("A1").PutValue(50)
  ///  'Adding a sample value to "A2" cell
  ///  worksheet.Cells("A2").PutValue(100)
  ///  'Adding a sample value to "A3" cell
  ///  worksheet.Cells("A3").PutValue(150)
  ///  'Adding a sample value to "B1" cell
  ///  worksheet.Cells("B1").PutValue(60)
  ///  'Adding a sample value to "B2" cell
  ///  worksheet.Cells("B2").PutValue(32)
  ///  'Adding a sample value to "B3" cell
  ///  worksheet.Cells("B3").PutValue(50)
  ///  'Adding a chart to the worksheet
  ///  Dim chartIndex As Integer = worksheet.Charts.Add(ChartType.Column, 5, 0, 25, 10)
  ///  'Accessing the instance of the newly added chart
  ///  Dim chart As Chart = worksheet.Charts(chartIndex)
  ///  'Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", True)
  ///  chart.IsDataTableShown = True
  ///  'Getting Chart Table
  ///  Dim chartTable As ChartDataTable = chart.ChartDataTable
  ///  'Setting Chart Table Font Color
  ///  chartTable.Font.Color = System.Drawing.Color.Red
  ///  'Setting Legend Key VisibilityOptions
  ///  chartTable.ShowLegendKey = False
  ///  'Saving the Excel file
  ///  workbook.Save("D:\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.ChartDataTable')]
  DNChartDataTable = interface(DDN.mscorlib.DNObject)
  ['{C48F443C-9480-37EB-B0BC-E9953284975F}']
  { getters & setters } 

    function get_Font: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_HasBorderHorizontal: Boolean;
    procedure set_HasBorderHorizontal(value: Boolean);
    function get_HasBorderVertical: Boolean;
    procedure set_HasBorderVertical(value: Boolean);
    function get_HasBorderOutline: Boolean;
    procedure set_HasBorderOutline(value: Boolean);
    function get_ShowLegendKey: Boolean;
    procedure set_ShowLegendKey(value: Boolean);
    function get_Border: DNLine;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.ChartDataTable.Font" />
    ///  object which represents the font setting of the specified chart data table.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  True if the text in the object changes font size when the object size changes.
    ///  The default value is True.
    ///</summary>
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartDataTable.BackgroundMode property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property Background: DNBackgroundMode read get_Background write set_Background;
    ///<summary>
    ///  True if the chart data table has horizontal cell borders
    ///</summary>
    property HasBorderHorizontal: Boolean read get_HasBorderHorizontal write set_HasBorderHorizontal;
    ///<summary>
    ///  True if the chart data table has vertical cell borders
    ///</summary>
    property HasBorderVertical: Boolean read get_HasBorderVertical write set_HasBorderVertical;
    ///<summary>
    ///  True if the chart data table has outline borders
    ///</summary>
    property HasBorderOutline: Boolean read get_HasBorderOutline write set_HasBorderOutline;
    ///<summary>
    ///  True if the data label legend key is visible.
    ///</summary>
    property ShowLegendKey: Boolean read get_ShowLegendKey write set_ShowLegendKey;
    ///<summary>
    ///  Returns a Border object that represents the border of the object
    ///</summary>
    property Border: DNLine read get_Border;
  end;

  TDNChartDataTable = class(TDNGenericImport<DNChartDataTableClass, DNChartDataTable>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNChartFrameClass = interface(DDN.mscorlib.DNObjectClass)
  ['{770A28E9-4076-5CCF-9DD2-713B297F2CC1}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents the frame object in a chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.ChartFrame')]
  DNChartFrame = interface(DDN.mscorlib.DNObject)
  ['{766EA04A-5575-34A5-A401-F9F4F122D790}']
  { getters & setters } 

    function get_IsInnerMode: Boolean;
    procedure set_IsInnerMode(value: Boolean);
    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_TextFont: DNFont;
    function get_Font: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_IsAutomaticSize: Boolean;
    procedure set_IsAutomaticSize(value: Boolean);
    function get_X: Int32;
    procedure set_X(value: Int32);
    function get_Y: Int32;
    procedure set_Y(value: Int32);
    function get_Height: Int32;
    procedure set_Height(value: Int32);
    function get_Width: Int32;
    procedure set_Width(value: Int32);
    function get_Shadow: Boolean;
    function get_ShapeProperties: DNShapePropertyCollection;
    function get_IsDefaultPosBeSet: Boolean;
    function get_DefaultX: Int32;
    function get_DefaultY: Int32;
    function get_DefaultWidth: Int32;
    function get_DefaultHeight: Int32;

  { methods } 

    ///<summary>
    ///  Set position of the frame to automatic
    ///</summary>
    procedure SetPositionAuto;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
    ///  False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.
    ///</summary>
    ///<remarks>
    ///  Only for Xlsx file.
    ///</remarks>
    property IsInnerMode: Boolean read get_IsInnerMode write set_IsInnerMode;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Drawing.Line">border</see>.
    ///</summary>
    property Border: DNLine read get_Border;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartFrame.Area">area</see>.
    ///</summary>
    property Area: DNArea read get_Area;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.ChartFrame.Font" />
    ///  object of the specified ChartFrame object.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartFrame.Font property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextFont: DNFont read get_TextFont;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.ChartFrame.Font" />
    ///  object of the specified ChartFrame object.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  True if the text in the object changes font size when the object size changes. The default value is True.
    ///</summary>
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartFrame.BackgroundMode property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property Background: DNBackgroundMode read get_Background write set_Background;
    ///<summary>
    ///  Indicates whether the chart frame is automatic sized.
    ///</summary>
    property IsAutomaticSize: Boolean read get_IsAutomaticSize write set_IsAutomaticSize;
    ///<summary>
    ///  Gets or sets the x coordinate of the upper left corner in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks>
    ///  How to convert units of 1/4000 to pixels?
    ///  X In Pixels = X * Chart.ChartObject.Width / 4000;
    ///</remarks>
    property X: Int32 read get_X write set_X;
    ///<summary>
    ///  Gets or sets the y coordinate of the upper left corner in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks>
    ///  How to convert units of 1/4000 to pixels?
    ///  Y In Pixels = Y * Chart.ChartObject.Height / 4000;
    ///</remarks>
    property Y: Int32 read get_Y write set_Y;
    ///<summary>
    ///  Gets or sets the height of frame in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks>
    ///  How to convert units of 1/4000 to pixels?
    ///  Height In Pixels = Y * Chart.ChartObject.Height / 4000;
    ///</remarks>
    property Height: Int32 read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets the width of frame in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks>
    ///  How to convert units of 1/4000 to pixels?
    ///  Width In Pixels = Width * Chart.ChartObject.Height / 4000;
    ///</remarks>
    property Width: Int32 read get_Width write set_Width;
    ///<summary>
    ///  True if the frame has a shadow.
    ///</summary>
    property Shadow: Boolean read get_Shadow;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartFrame.ShapeProperties" />
    ///  object.
    ///</summary>
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
    ///<summary>
    ///  Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.
    ///</summary>
    property IsDefaultPosBeSet: Boolean read get_IsDefaultPosBeSet;
    ///<summary>
    ///  Represents x of default position
    ///</summary>
    property DefaultX: Int32 read get_DefaultX;
    ///<summary>
    ///  Represents y of default position
    ///</summary>
    property DefaultY: Int32 read get_DefaultY;
    ///<summary>
    ///  Represents width of default position
    ///</summary>
    property DefaultWidth: Int32 read get_DefaultWidth;
    ///<summary>
    ///  Represents height of default position
    ///</summary>
    property DefaultHeight: Int32 read get_DefaultHeight;
  end;

  TDNChartFrame = class(TDNGenericImport<DNChartFrameClass, DNChartFrame>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNChartAreaClass = interface(DNChartFrameClass)
  ['{D5FCECA9-F6B4-5604-A9B5-0AC6B0C3355F}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents the chart area in the worksheet.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Obtaining the reference of the first worksheet
  ///  Worksheet worksheet = workbook.Worksheets[0];
  ///  //Adding a sample value to "A1" cell
  ///  worksheet.Cells["A1"].PutValue(50);
  ///  //Adding a sample value to "A2" cell
  ///  worksheet.Cells["A2"].PutValue(100);
  ///  //Adding a sample value to "A3" cell
  ///  worksheet.Cells["A3"].PutValue(150);
  ///  //Adding a sample value to "B1" cell
  ///  worksheet.Cells["B1"].PutValue(60);
  ///  //Adding a sample value to "B2" cell
  ///  worksheet.Cells["B2"].PutValue(32);
  ///  //Adding a sample value to "B3" cell
  ///  worksheet.Cells["B3"].PutValue(50);
  ///  //Adding a chart to the worksheet
  ///  int chartIndex = worksheet.Charts.Add(ChartType.Column, 5, 0, 15, 5);
  ///  //Accessing the instance of the newly added chart
  ///  Chart chart = worksheet.Charts[chartIndex];
  ///  //Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", true);
  ///  //Getting Chart Area
  ///  ChartArea chartArea = chart.ChartArea;
  ///  //Setting the foreground color of the chart area
  ///  chartArea.Area.ForegroundColor = Color.Yellow;
  ///  //Setting Chart Area Shadow
  ///  chartArea.Shadow = true;
  ///  //Saving the Excel file
  ///  workbook.Save("D:\\book1.xls");
  ///  [VB.NET]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As New Workbook()
  ///  'Obtaining the reference of the first worksheet
  ///  Dim worksheet As Worksheet = workbook.Worksheets(0)
  ///  'Adding a sample value to "A1" cell
  ///  worksheet.Cells("A1").PutValue(50)
  ///  'Adding a sample value to "A2" cell
  ///  worksheet.Cells("A2").PutValue(100)
  ///  'Adding a sample value to "A3" cell
  ///  worksheet.Cells("A3").PutValue(150)
  ///  'Adding a sample value to "B1" cell
  ///  worksheet.Cells("B1").PutValue(60)
  ///  'Adding a sample value to "B2" cell
  ///  worksheet.Cells("B2").PutValue(32)
  ///  'Adding a sample value to "B3" cell
  ///  worksheet.Cells("B3").PutValue(50)
  ///  'Adding a chart to the worksheet
  ///  Dim chartIndex As Integer = worksheet.Charts.Add(ChartType.Column, 5, 0, 15, 5)
  ///  'Accessing the instance of the newly added chart
  ///  Dim chart As Chart = worksheet.Charts(chartIndex)
  ///  'Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", True)
  ///  'Getting Chart Area
  ///  Dim chartArea As ChartArea = chart.ChartArea
  ///  'Setting the foreground color of the chart area
  ///  chartArea.Area.ForegroundColor = Color.Yellow
  ///  'Setting Chart Area Shadow
  ///  chartArea.Shadow = True
  ///  'Saving the Excel file
  ///  workbook.Save("D:\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.ChartArea')]
  DNChartArea = interface(DNChartFrame)
  ['{9015F893-EC7A-364A-8AA8-F3FF14FB676E}']
  { getters & setters } 

    function get_X: Int32;
    procedure set_X(value: Int32);
    function get_Y: Int32;
    procedure set_Y(value: Int32);
    function get_Height: Int32;
    procedure set_Height(value: Int32);
    function get_Width: Int32;
    procedure set_Width(value: Int32);
    function get_Font: DNFont;
    function get_IsInnerMode: Boolean;
    procedure set_IsInnerMode(value: Boolean);
    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_TextFont: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_IsAutomaticSize: Boolean;
    procedure set_IsAutomaticSize(value: Boolean);
    function get_Shadow: Boolean;
    function get_ShapeProperties: DNShapePropertyCollection;
    function get_IsDefaultPosBeSet: Boolean;
    function get_DefaultX: Int32;
    function get_DefaultY: Int32;
    function get_DefaultWidth: Int32;
    function get_DefaultHeight: Int32;

  { methods } 

    ///<summary>
    ///  Set position of the frame to automatic
    ///</summary>
    procedure SetPositionAuto;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or gets the horizontal offset from its upper left corner column.
    ///</summary>
    property X: Int32 read get_X write set_X;
    ///<summary>
    ///  Gets or gets the vertical offset from its upper left corner row.
    ///</summary>
    property Y: Int32 read get_Y write set_Y;
    ///<summary>
    ///  Gets or sets the vertical offset from its lower right corner row.
    ///</summary>
    property Height: Int32 read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets the horizontal offset from its lower right corner column.
    ///</summary>
    property Width: Int32 read get_Width write set_Width;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.ChartArea.Font" />
    ///  object of the specified chartarea object.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
    ///  False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.
    ///</summary>
    ///<remarks>
    ///  Only for Xlsx file.
    ///</remarks>
    property IsInnerMode: Boolean read get_IsInnerMode write set_IsInnerMode;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Drawing.Line">border</see>.
    ///</summary>
    property Border: DNLine read get_Border;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartFrame.Area">area</see>.
    ///</summary>
    property Area: DNArea read get_Area;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.ChartFrame.Font" />
    ///  object of the specified ChartFrame object.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartFrame.Font property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextFont: DNFont read get_TextFont;
    ///<summary>
    ///  True if the text in the object changes font size when the object size changes. The default value is True.
    ///</summary>
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartFrame.BackgroundMode property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property Background: DNBackgroundMode read get_Background write set_Background;
    ///<summary>
    ///  Indicates whether the chart frame is automatic sized.
    ///</summary>
    property IsAutomaticSize: Boolean read get_IsAutomaticSize write set_IsAutomaticSize;
    ///<summary>
    ///  True if the frame has a shadow.
    ///</summary>
    property Shadow: Boolean read get_Shadow;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartFrame.ShapeProperties" />
    ///  object.
    ///</summary>
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
    ///<summary>
    ///  Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.
    ///</summary>
    property IsDefaultPosBeSet: Boolean read get_IsDefaultPosBeSet;
    ///<summary>
    ///  Represents x of default position
    ///</summary>
    property DefaultX: Int32 read get_DefaultX;
    ///<summary>
    ///  Represents y of default position
    ///</summary>
    property DefaultY: Int32 read get_DefaultY;
    ///<summary>
    ///  Represents width of default position
    ///</summary>
    property DefaultWidth: Int32 read get_DefaultWidth;
    ///<summary>
    ///  Represents height of default position
    ///</summary>
    property DefaultHeight: Int32 read get_DefaultHeight;
  end;

  TDNChartArea = class(TDNGenericImport<DNChartAreaClass, DNChartArea>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNChartTextFrameClass = interface(DNChartFrameClass)
  ['{E16A3156-507E-59E0-AFF8-8C653567F172}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents the frame object which contains text.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.ChartTextFrame')]
  DNChartTextFrame = interface(DNChartFrame)
  ['{E4A9C2AF-DE51-3607-B576-E8CC687D1831}']
  { getters & setters } 

    function get_IsAutoText: Boolean;
    procedure set_IsAutoText(value: Boolean);
    function get_IsDeleted: Boolean;
    procedure set_IsDeleted(value: Boolean);
    function get_TextHorizontalAlignment: DNTextAlignmentType;
    procedure set_TextHorizontalAlignment(value: DNTextAlignmentType);
    function get_TextVerticalAlignment: DNTextAlignmentType;
    procedure set_TextVerticalAlignment(value: DNTextAlignmentType);
    function get_RotationAngle: Int32;
    procedure set_RotationAngle(value: Int32);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_LinkedSource: string;
    procedure set_LinkedSource(value: string);
    function get_TextDirection: DNTextDirectionType;
    procedure set_TextDirection(value: DNTextDirectionType);
    function get_ReadingOrder: DNTextDirectionType;
    procedure set_ReadingOrder(value: DNTextDirectionType);
    function get_DirectionType: DNChartTextDirectionType;
    procedure set_DirectionType(value: DNChartTextDirectionType);
    function get_IsTextWrapped: Boolean;
    procedure set_IsTextWrapped(value: Boolean);
    function get_IsResizeShapeToFitText: Boolean;
    procedure set_IsResizeShapeToFitText(value: Boolean);
    function get_IsInnerMode: Boolean;
    procedure set_IsInnerMode(value: Boolean);
    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_TextFont: DNFont;
    function get_Font: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_IsAutomaticSize: Boolean;
    procedure set_IsAutomaticSize(value: Boolean);
    function get_X: Int32;
    procedure set_X(value: Int32);
    function get_Y: Int32;
    procedure set_Y(value: Int32);
    function get_Height: Int32;
    procedure set_Height(value: Int32);
    function get_Width: Int32;
    procedure set_Width(value: Int32);
    function get_Shadow: Boolean;
    function get_ShapeProperties: DNShapePropertyCollection;
    function get_IsDefaultPosBeSet: Boolean;
    function get_DefaultX: Int32;
    function get_DefaultY: Int32;
    function get_DefaultWidth: Int32;
    function get_DefaultHeight: Int32;

  { methods } 

    ///<summary>
    ///  Returns a Characters object that represents a range of characters within the text.
    ///</summary>
    ///  <param name="startIndex">The index of the start of the character.</param>
    ///  <param name="length">The number of characters.</param>
    ///<returns>Characters object.</returns>
    function Characters(startIndex: Int32; length: Int32): DNFontSetting;
    ///<summary>
    ///  Set position of the frame to automatic
    ///</summary>
    procedure SetPositionAuto;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Indicates the text is auto generated.
    ///</summary>
    property IsAutoText: Boolean read get_IsAutoText write set_IsAutoText;
    ///<summary>
    ///  Indicates whether this data labels is deleted.
    ///</summary>
    property IsDeleted: Boolean read get_IsDeleted write set_IsDeleted;
    ///<summary>
    ///  Gets and sets the text horizontal alignment.
    ///</summary>
    property TextHorizontalAlignment: DNTextAlignmentType read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets or sets the text vertical alignment of text.
    ///</summary>
    property TextVerticalAlignment: DNTextAlignmentType read get_TextVerticalAlignment write set_TextVerticalAlignment;
    ///<summary>
    ///  Represents text rotation angle.
    ///</summary>
    ///<remarks><br>0: Not rotated.</br><br>255: Top to Bottom.</br><br>-90: Downward.</br><br>90: Upward.</br></remarks>
    property RotationAngle: Int32 read get_RotationAngle write set_RotationAngle;
    ///<summary>
    ///  Gets or sets the text of a frame's title.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets and sets a reference to the worksheet.
    ///</summary>
    property LinkedSource: string read get_LinkedSource write set_LinkedSource;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartTextFrame.ReadingOrder property.
    ///  This property will be removed 12 months later since March 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextDirection: DNTextDirectionType read get_TextDirection write set_TextDirection;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    property ReadingOrder: DNTextDirectionType read get_ReadingOrder write set_ReadingOrder;
    ///<summary>
    ///  Gets and sets the direction of text.
    ///</summary>
    property DirectionType: DNChartTextDirectionType read get_DirectionType write set_DirectionType;
    ///<summary>
    ///  Gets or sets a value indicating whether the text is wrapped.
    ///</summary>
    property IsTextWrapped: Boolean read get_IsTextWrapped write set_IsTextWrapped;
    ///<summary>
    ///  Gets or sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
    ///  when text within a shape is scaled in order to contain all the text inside.
    ///</summary>
    property IsResizeShapeToFitText: Boolean read get_IsResizeShapeToFitText write set_IsResizeShapeToFitText;
    ///<summary>
    ///  Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
    ///  False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.
    ///</summary>
    ///<remarks>
    ///  Only for Xlsx file.
    ///</remarks>
    property IsInnerMode: Boolean read get_IsInnerMode write set_IsInnerMode;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Drawing.Line">border</see>.
    ///</summary>
    property Border: DNLine read get_Border;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartFrame.Area">area</see>.
    ///</summary>
    property Area: DNArea read get_Area;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.ChartFrame.Font" />
    ///  object of the specified ChartFrame object.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartFrame.Font property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextFont: DNFont read get_TextFont;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.ChartFrame.Font" />
    ///  object of the specified ChartFrame object.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  True if the text in the object changes font size when the object size changes. The default value is True.
    ///</summary>
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartFrame.BackgroundMode property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property Background: DNBackgroundMode read get_Background write set_Background;
    ///<summary>
    ///  Indicates whether the chart frame is automatic sized.
    ///</summary>
    property IsAutomaticSize: Boolean read get_IsAutomaticSize write set_IsAutomaticSize;
    ///<summary>
    ///  Gets or sets the x coordinate of the upper left corner in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks>
    ///  How to convert units of 1/4000 to pixels?
    ///  X In Pixels = X * Chart.ChartObject.Width / 4000;
    ///</remarks>
    property X: Int32 read get_X write set_X;
    ///<summary>
    ///  Gets or sets the y coordinate of the upper left corner in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks>
    ///  How to convert units of 1/4000 to pixels?
    ///  Y In Pixels = Y * Chart.ChartObject.Height / 4000;
    ///</remarks>
    property Y: Int32 read get_Y write set_Y;
    ///<summary>
    ///  Gets or sets the height of frame in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks>
    ///  How to convert units of 1/4000 to pixels?
    ///  Height In Pixels = Y * Chart.ChartObject.Height / 4000;
    ///</remarks>
    property Height: Int32 read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets the width of frame in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks>
    ///  How to convert units of 1/4000 to pixels?
    ///  Width In Pixels = Width * Chart.ChartObject.Height / 4000;
    ///</remarks>
    property Width: Int32 read get_Width write set_Width;
    ///<summary>
    ///  True if the frame has a shadow.
    ///</summary>
    property Shadow: Boolean read get_Shadow;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartFrame.ShapeProperties" />
    ///  object.
    ///</summary>
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
    ///<summary>
    ///  Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.
    ///</summary>
    property IsDefaultPosBeSet: Boolean read get_IsDefaultPosBeSet;
    ///<summary>
    ///  Represents x of default position
    ///</summary>
    property DefaultX: Int32 read get_DefaultX;
    ///<summary>
    ///  Represents y of default position
    ///</summary>
    property DefaultY: Int32 read get_DefaultY;
    ///<summary>
    ///  Represents width of default position
    ///</summary>
    property DefaultWidth: Int32 read get_DefaultWidth;
    ///<summary>
    ///  Represents height of default position
    ///</summary>
    property DefaultHeight: Int32 read get_DefaultHeight;
  end;

  TDNChartTextFrame = class(TDNGenericImport<DNChartTextFrameClass, DNChartTextFrame>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNDataLabelsClass = interface(DNChartTextFrameClass)
  ['{92033AD8-3CDD-5B1A-A7F1-4432F1A01978}']
  end;

  ///<summary>
  ///  Encapsulates a collection of all the DataLabel objects for the specified Series.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Set the DataLabels in the chart
  ///  DataLabels datalabels;
  ///  for (int i = 0; i  &lt;chart.NSeries.Count; i++)
  ///  {
  ///  datalabels = chart.NSeries[i].DataLabels;
  ///  //Set the position of DataLabels
  ///  datalabels.Position = LabelPositionType.InsideBase;
  ///  //Show the category name in the DataLabels
  ///  datalabels.ShowCategoryName = true;
  ///  //Show the value in the DataLabels
  ///  datalabels.ShowValue = true;
  ///  //Not show the percentage in the DataLabels
  ///  datalabels.ShowPercentage = false;
  ///  //Not show the legend key.
  ///  datalabels.ShowLegendKey = false;
  ///  }
  ///  [Visual Basic]
  ///  'Set the DataLabels in the chart
  ///  Dim datalabels As DataLabels
  ///  Dim i As Integer
  ///  For i = 0 To chart.NSeries.Count - 1 Step 1
  ///  datalabels = chart.NSeries(i).DataLabels
  ///  'Set the position of DataLabels
  ///  datalabels.Position = LabelPositionType.InsideBase
  ///  'Show the category name in the DataLabels
  ///  datalabels.ShowCategoryName= True
  ///  'Show the value in the DataLabels
  ///  datalabels.ShowValue = True
  ///  'Not show the percentage in the DataLabels
  ///  datalabels.ShowPercentage = False
  ///  'Not show the legend key.
  ///  datalabels.ShowLegendKey = False
  ///  Next
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.DataLabels')]
  DNDataLabels = interface(DNChartTextFrame)
  ['{E2736172-2CC8-33A9-BED1-76A88806A320}']
  { getters & setters } 

    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_IsAutoText: Boolean;
    procedure set_IsAutoText(value: Boolean);
    function get_DirectionType: DNChartTextDirectionType;
    procedure set_DirectionType(value: DNChartTextDirectionType);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_IsTextWrapped: Boolean;
    procedure set_IsTextWrapped(value: Boolean);
    function get_LinkedSource: string;
    procedure set_LinkedSource(value: string);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_ShowValue: Boolean;
    procedure set_ShowValue(value: Boolean);
    function get_ShowCellRange: Boolean;
    procedure set_ShowCellRange(value: Boolean);
    function get_ShowPercentage: Boolean;
    procedure set_ShowPercentage(value: Boolean);
    function get_ShowBubbleSize: Boolean;
    procedure set_ShowBubbleSize(value: Boolean);
    function get_ShowCategoryName: Boolean;
    procedure set_ShowCategoryName(value: Boolean);
    function get_ShowSeriesName: Boolean;
    procedure set_ShowSeriesName(value: Boolean);
    function get_ShowLegendKey: Boolean;
    procedure set_ShowLegendKey(value: Boolean);
    function get_NumberFormat: string;
    procedure set_NumberFormat(value: string);
    function get_Number: Int32;
    procedure set_Number(value: Int32);
    function get_NumberFormatLinked: Boolean;
    procedure set_NumberFormatLinked(value: Boolean);
    function get_Font: DNFont;
    function get_Separator: DNDataLablesSeparatorType;
    procedure set_Separator(value: DNDataLablesSeparatorType);
    function get_SeparatorType: DNDataLabelsSeparatorType;
    procedure set_SeparatorType(value: DNDataLabelsSeparatorType);
    function get_SeparatorValue: string;
    procedure set_SeparatorValue(value: string);
    function get_Position: DNLabelPositionType;
    procedure set_Position(value: DNLabelPositionType);
    function get_ShapeType: DNDataLabelShapeType;
    procedure set_ShapeType(value: DNDataLabelShapeType);
    function get_IsDeleted: Boolean;
    procedure set_IsDeleted(value: Boolean);
    function get_TextHorizontalAlignment: DNTextAlignmentType;
    procedure set_TextHorizontalAlignment(value: DNTextAlignmentType);
    function get_TextVerticalAlignment: DNTextAlignmentType;
    procedure set_TextVerticalAlignment(value: DNTextAlignmentType);
    function get_RotationAngle: Int32;
    procedure set_RotationAngle(value: Int32);
    function get_TextDirection: DNTextDirectionType;
    procedure set_TextDirection(value: DNTextDirectionType);
    function get_ReadingOrder: DNTextDirectionType;
    procedure set_ReadingOrder(value: DNTextDirectionType);
    function get_IsResizeShapeToFitText: Boolean;
    procedure set_IsResizeShapeToFitText(value: Boolean);
    function get_IsInnerMode: Boolean;
    procedure set_IsInnerMode(value: Boolean);
    function get_TextFont: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_IsAutomaticSize: Boolean;
    procedure set_IsAutomaticSize(value: Boolean);
    function get_X: Int32;
    procedure set_X(value: Int32);
    function get_Y: Int32;
    procedure set_Y(value: Int32);
    function get_Height: Int32;
    procedure set_Height(value: Int32);
    function get_Width: Int32;
    procedure set_Width(value: Int32);
    function get_Shadow: Boolean;
    function get_ShapeProperties: DNShapePropertyCollection;
    function get_IsDefaultPosBeSet: Boolean;
    function get_DefaultX: Int32;
    function get_DefaultY: Int32;
    function get_DefaultWidth: Int32;
    function get_DefaultHeight: Int32;

  { methods } 

    ///<summary>
    ///  Returns a Characters object that represents a range of characters within the text.
    ///</summary>
    ///  <param name="startIndex">The index of the start of the character.</param>
    ///  <param name="length">The number of characters.</param>
    ///<returns>Characters object.</returns>
    function Characters(startIndex: Int32; length: Int32): DNFontSetting;
    procedure SetPositionAuto;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Drawing.Line">border</see>.
    ///</summary>
    property Border: DNLine read get_Border;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.DataLabels.Area">area</see>.
    ///</summary>
    property Area: DNArea read get_Area;
    ///<summary>
    ///  Indicates the text is auto generated.
    ///</summary>
    property IsAutoText: Boolean read get_IsAutoText write set_IsAutoText;
    ///<summary>
    ///  Gets and sets the direction of text.
    ///</summary>
    property DirectionType: DNChartTextDirectionType read get_DirectionType write set_DirectionType;
    ///<summary>
    ///  Gets or sets the text of data label.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets or sets a value indicating whether the text is wrapped.
    ///</summary>
    property IsTextWrapped: Boolean read get_IsTextWrapped write set_IsTextWrapped;
    ///<summary>
    ///  Gets and sets the linked source.
    ///</summary>
    property LinkedSource: string read get_LinkedSource write set_LinkedSource;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    ///<summary>
    ///  Represents a specified chart's data label values display behavior. True displays the values. False to hide.
    ///</summary>
    property ShowValue: Boolean read get_ShowValue write set_ShowValue;
    ///<summary>
    ///  Indicates whether showing cell range as the data labels.
    ///</summary>
    property ShowCellRange: Boolean read get_ShowCellRange write set_ShowCellRange;
    ///<summary>
    ///  Represents a specified chart's data label percentage value display behavior. True displays the percentage value. False to hide.
    ///</summary>
    property ShowPercentage: Boolean read get_ShowPercentage write set_ShowPercentage;
    ///<summary>
    ///  Represents a specified chart's data label percentage value display behavior. True displays the percentage value. False to hide.
    ///</summary>
    property ShowBubbleSize: Boolean read get_ShowBubbleSize write set_ShowBubbleSize;
    ///<summary>
    ///  Represents a specified chart's data label category name display behavior.True to display the category name for the data labels on a chart. False to hide.
    ///</summary>
    property ShowCategoryName: Boolean read get_ShowCategoryName write set_ShowCategoryName;
    ///<summary>
    ///  Returns or sets a Boolean to indicate the series name display behavior for the data labels on a chart.
    ///  True to show the series name. False to hide.
    ///</summary>
    property ShowSeriesName: Boolean read get_ShowSeriesName write set_ShowSeriesName;
    ///<summary>
    ///  Represents a specified chart's data label legend key display behavior.
    ///  True if the data label legend key is visible.
    ///</summary>
    property ShowLegendKey: Boolean read get_ShowLegendKey write set_ShowLegendKey;
    ///<summary>
    ///  Represents the format string for the DataLabels object.
    ///</summary>
    property NumberFormat: string read get_NumberFormat write set_NumberFormat;
    ///<summary>
    ///  Gets and sets the built-in number format.
    ///</summary>
    property Number: Int32 read get_Number write set_Number;
    ///<summary>
    ///  True if the number format is linked to the cells
    ///  (so that the number format changes in the labels when it changes in the cells).
    ///</summary>
    property NumberFormatLinked: Boolean read get_NumberFormatLinked write set_NumberFormatLinked;
    ///<summary>
    ///  Gets the font of the DataLabels;
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  Gets or sets the separator type used for the data labels on a chart.
    ///</summary>
    ///<remarks>
    ///  NOTE: This member is now obsolete. Instead,
    ///  please use DataLabels.SeparatorType property.
    ///  This property will be removed 12 months later since September 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property Separator: DNDataLablesSeparatorType read get_Separator write set_Separator;
    ///<summary>
    ///  Gets or sets the separator type used for the data labels on a chart.
    ///</summary>
    ///<remarks>
    ///  To set custom separator, please set  the property <see cref="P:Aspose.Cells.Charts.DataLabels.SeparatorType" />
    ///  as <see cref="F:Aspose.Cells.Charts.DataLabelsSeparatorType.Custom" />
    ///  and then specify the expected value for <see cref="P:Aspose.Cells.Charts.DataLabels.SeparatorValue" />
    ///  .
    ///</remarks>
    property SeparatorType: DNDataLabelsSeparatorType read get_SeparatorType write set_SeparatorType;
    ///<summary>
    ///  Gets or sets the separator value used for the data labels on a chart.
    ///</summary>
    property SeparatorValue: string read get_SeparatorValue write set_SeparatorValue;
    ///<summary>
    ///  Represents the position of the data label.
    ///</summary>
    property Position: DNLabelPositionType read get_Position write set_Position;
    ///<summary>
    ///  Gets or sets  shape type of data label.
    ///</summary>
    property ShapeType: DNDataLabelShapeType read get_ShapeType write set_ShapeType;
    ///<summary>
    ///  Indicates whether this data labels is deleted.
    ///</summary>
    property IsDeleted: Boolean read get_IsDeleted write set_IsDeleted;
    ///<summary>
    ///  Gets and sets the text horizontal alignment.
    ///</summary>
    property TextHorizontalAlignment: DNTextAlignmentType read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets or sets the text vertical alignment of text.
    ///</summary>
    property TextVerticalAlignment: DNTextAlignmentType read get_TextVerticalAlignment write set_TextVerticalAlignment;
    ///<summary>
    ///  Represents text rotation angle.
    ///</summary>
    ///<remarks><br>0: Not rotated.</br><br>255: Top to Bottom.</br><br>-90: Downward.</br><br>90: Upward.</br></remarks>
    property RotationAngle: Int32 read get_RotationAngle write set_RotationAngle;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartTextFrame.ReadingOrder property.
    ///  This property will be removed 12 months later since March 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextDirection: DNTextDirectionType read get_TextDirection write set_TextDirection;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    property ReadingOrder: DNTextDirectionType read get_ReadingOrder write set_ReadingOrder;
    ///<summary>
    ///  Gets or sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
    ///  when text within a shape is scaled in order to contain all the text inside.
    ///</summary>
    property IsResizeShapeToFitText: Boolean read get_IsResizeShapeToFitText write set_IsResizeShapeToFitText;
    property IsInnerMode: Boolean read get_IsInnerMode write set_IsInnerMode;
    property TextFont: DNFont read get_TextFont;
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    property Background: DNBackgroundMode read get_Background write set_Background;
    property IsAutomaticSize: Boolean read get_IsAutomaticSize write set_IsAutomaticSize;
    property X: Int32 read get_X write set_X;
    property Y: Int32 read get_Y write set_Y;
    property Height: Int32 read get_Height write set_Height;
    property Width: Int32 read get_Width write set_Width;
    property Shadow: Boolean read get_Shadow;
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
    property IsDefaultPosBeSet: Boolean read get_IsDefaultPosBeSet;
    property DefaultX: Int32 read get_DefaultX;
    property DefaultY: Int32 read get_DefaultY;
    property DefaultWidth: Int32 read get_DefaultWidth;
    property DefaultHeight: Int32 read get_DefaultHeight;
  end;

  TDNDataLabels = class(TDNGenericImport<DNDataLabelsClass, DNDataLabels>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNDisplayUnitLabelClass = interface(DNChartTextFrameClass)
  ['{6C445F4F-0F9E-5550-B81F-E6D448051353}']
  end;

  ///<summary>
  ///  Represents the display unit label.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Adding a new worksheet to the Excel object
  ///  int sheetIndex = workbook.Worksheets.Add();
  ///  //Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Worksheet worksheet = workbook.Worksheets[sheetIndex];
  ///  //Adding a sample value to "A1" cell
  ///  worksheet.Cells["A1"].PutValue(50);
  ///  //Adding a sample value to "A2" cell
  ///  worksheet.Cells["A2"].PutValue(100);
  ///  //Adding a sample value to "A3" cell
  ///  worksheet.Cells["A3"].PutValue(150);
  ///  //Adding a sample value to "A4" cell
  ///  worksheet.Cells["A4"].PutValue(200);
  ///  //Adding a sample value to "B1" cell
  ///  worksheet.Cells["B1"].PutValue(60);
  ///  //Adding a sample value to "B2" cell
  ///  worksheet.Cells["B2"].PutValue(32);
  ///  //Adding a sample value to "B3" cell
  ///  worksheet.Cells["B3"].PutValue(50);
  ///  //Adding a sample value to "B4" cell
  ///  worksheet.Cells["B4"].PutValue(40);
  ///  //Adding a sample value to "C1" cell as category data
  ///  worksheet.Cells["C1"].PutValue("Q1");
  ///  //Adding a sample value to "C2" cell as category data
  ///  worksheet.Cells["C2"].PutValue("Q2");
  ///  //Adding a sample value to "C3" cell as category data
  ///  worksheet.Cells["C3"].PutValue("Y1");
  ///  //Adding a sample value to "C4" cell as category data
  ///  worksheet.Cells["C4"].PutValue("Y2");
  ///  //Adding a chart to the worksheet
  ///  int chartIndex = worksheet.Charts.Add(ChartType.Column, 5, 0, 15, 5);
  ///  //Accessing the instance of the newly added chart
  ///  Chart chart = worksheet.Charts[chartIndex];
  ///  //Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B4"
  ///  chart.NSeries.Add("A1:B4", true);
  ///  //Setting the data source for the category data of NSeries
  ///  chart.NSeries.CategoryData = "C1:C4";
  ///  //Setting the display unit of value(Y) axis.
  ///  chart.ValueAxis.DisplayUnit = DisplayUnitType.Hundreds;
  ///  DisplayUnitLabel displayUnitLabel = chart.ValueAxis.DisplayUnitLabel;
  ///  //Setting the custom display unit label
  ///  displayUnitLabel.Text = "100";
  ///  //Saving the Excel file
  ///  workbook.Save("C:\\book1.xls");
  ///  [Visual Basic]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As Workbook = New Workbook()
  ///  'Adding a new worksheet to the Excel object
  ///  Dim sheetIndex As Int32 = workbook.Worksheets.Add()
  ///  'Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Dim worksheet As Worksheet = workbook.Worksheets(sheetIndex)
  ///  'Adding a sample value to "A1" cell
  ///  worksheet.Cells("A1").PutValue(50)
  ///  'Adding a sample value to "A2" cell
  ///  worksheet.Cells("A2").PutValue(100)
  ///  'Adding a sample value to "A3" cell
  ///  worksheet.Cells("A3").PutValue(150)
  ///  'Adding a sample value to "A4" cell
  ///  worksheet.Cells("A4").PutValue(200)
  ///  'Adding a sample value to "B1" cell
  ///  worksheet.Cells("B1").PutValue(60)
  ///  'Adding a sample value to "B2" cell
  ///  worksheet.Cells("B2").PutValue(32)
  ///  'Adding a sample value to "B3" cell
  ///  worksheet.Cells("B3").PutValue(50)
  ///  'Adding a sample value to "B4" cell
  ///  worksheet.Cells("B4").PutValue(40)
  ///  'Adding a sample value to "C1" cell as category data
  ///  worksheet.Cells("C1").PutValue("Q1")
  ///  'Adding a sample value to "C2" cell as category data
  ///  worksheet.Cells("C2").PutValue("Q2")
  ///  'Adding a sample value to "C3" cell as category data
  ///  worksheet.Cells("C3").PutValue("Y1")
  ///  'Adding a sample value to "C4" cell as category data
  ///  worksheet.Cells("C4").PutValue("Y2")
  ///  'Adding a chart to the worksheet
  ///  Dim chartIndex As Int32 = worksheet.Charts.Add(ChartType.Column, 5, 0, 15, 5)
  ///  'Accessing the instance of the newly added chart
  ///  Dim chart As Chart = worksheet.Charts(chartIndex)
  ///  'Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B4"
  ///  chart.NSeries.Add("A1:B4", True)
  ///  'Setting the data source for the category data of NSeries
  ///  Chart.NSeries.CategoryData = "C1:C4"
  ///  'Setting the display unit of value(Y) axis.
  ///  chart.ValueAxis.DisplayUnit = DisplayUnitType.Hundreds
  ///  Dim displayUnitLabel As DisplayUnitLabel = chart.ValueAxis.DisplayUnitLabel
  ///  'Setting the custom display unit label
  ///  displayUnitLabel.Text = "100"
  ///  'Saving the Excel file
  ///  workbook.Save("C:\\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.DisplayUnitLabel')]
  DNDisplayUnitLabel = interface(DNChartTextFrame)
  ['{200EE937-F507-36FB-98CA-B838B3CA1AB2}']
  { getters & setters } 

    function get_Text: string;
    procedure set_Text(value: string);
    function get_Font: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_IsAutoText: Boolean;
    procedure set_IsAutoText(value: Boolean);
    function get_IsDeleted: Boolean;
    procedure set_IsDeleted(value: Boolean);
    function get_TextHorizontalAlignment: DNTextAlignmentType;
    procedure set_TextHorizontalAlignment(value: DNTextAlignmentType);
    function get_TextVerticalAlignment: DNTextAlignmentType;
    procedure set_TextVerticalAlignment(value: DNTextAlignmentType);
    function get_RotationAngle: Int32;
    procedure set_RotationAngle(value: Int32);
    function get_LinkedSource: string;
    procedure set_LinkedSource(value: string);
    function get_TextDirection: DNTextDirectionType;
    procedure set_TextDirection(value: DNTextDirectionType);
    function get_ReadingOrder: DNTextDirectionType;
    procedure set_ReadingOrder(value: DNTextDirectionType);
    function get_DirectionType: DNChartTextDirectionType;
    procedure set_DirectionType(value: DNChartTextDirectionType);
    function get_IsTextWrapped: Boolean;
    procedure set_IsTextWrapped(value: Boolean);
    function get_IsResizeShapeToFitText: Boolean;
    procedure set_IsResizeShapeToFitText(value: Boolean);
    function get_IsInnerMode: Boolean;
    procedure set_IsInnerMode(value: Boolean);
    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_TextFont: DNFont;
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_IsAutomaticSize: Boolean;
    procedure set_IsAutomaticSize(value: Boolean);
    function get_X: Int32;
    procedure set_X(value: Int32);
    function get_Y: Int32;
    procedure set_Y(value: Int32);
    function get_Height: Int32;
    procedure set_Height(value: Int32);
    function get_Width: Int32;
    procedure set_Width(value: Int32);
    function get_Shadow: Boolean;
    function get_ShapeProperties: DNShapePropertyCollection;
    function get_IsDefaultPosBeSet: Boolean;
    function get_DefaultX: Int32;
    function get_DefaultY: Int32;
    function get_DefaultWidth: Int32;
    function get_DefaultHeight: Int32;

  { methods } 

    ///<summary>
    ///  Returns a Characters object that represents a range of characters within the text.
    ///</summary>
    ///  <param name="startIndex">The index of the start of the character.</param>
    ///  <param name="length">The number of characters.</param>
    ///<returns>Characters object.</returns>
    function Characters(startIndex: Int32; length: Int32): DNFontSetting;
    procedure SetPositionAuto;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the text of display unit label.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.DisplayUnitLabel.Font" />
    ///  object of the specified ChartFrame object.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  True if the text in the object changes font size when the object size changes. The default value is True.
    ///</summary>
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    ///<summary>
    ///  Indicates the text is auto generated.
    ///</summary>
    property IsAutoText: Boolean read get_IsAutoText write set_IsAutoText;
    ///<summary>
    ///  Indicates whether this data labels is deleted.
    ///</summary>
    property IsDeleted: Boolean read get_IsDeleted write set_IsDeleted;
    ///<summary>
    ///  Gets and sets the text horizontal alignment.
    ///</summary>
    property TextHorizontalAlignment: DNTextAlignmentType read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets or sets the text vertical alignment of text.
    ///</summary>
    property TextVerticalAlignment: DNTextAlignmentType read get_TextVerticalAlignment write set_TextVerticalAlignment;
    ///<summary>
    ///  Represents text rotation angle.
    ///</summary>
    ///<remarks><br>0: Not rotated.</br><br>255: Top to Bottom.</br><br>-90: Downward.</br><br>90: Upward.</br></remarks>
    property RotationAngle: Int32 read get_RotationAngle write set_RotationAngle;
    ///<summary>
    ///  Gets and sets a reference to the worksheet.
    ///</summary>
    property LinkedSource: string read get_LinkedSource write set_LinkedSource;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartTextFrame.ReadingOrder property.
    ///  This property will be removed 12 months later since March 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextDirection: DNTextDirectionType read get_TextDirection write set_TextDirection;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    property ReadingOrder: DNTextDirectionType read get_ReadingOrder write set_ReadingOrder;
    ///<summary>
    ///  Gets and sets the direction of text.
    ///</summary>
    property DirectionType: DNChartTextDirectionType read get_DirectionType write set_DirectionType;
    ///<summary>
    ///  Gets or sets a value indicating whether the text is wrapped.
    ///</summary>
    property IsTextWrapped: Boolean read get_IsTextWrapped write set_IsTextWrapped;
    ///<summary>
    ///  Gets or sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
    ///  when text within a shape is scaled in order to contain all the text inside.
    ///</summary>
    property IsResizeShapeToFitText: Boolean read get_IsResizeShapeToFitText write set_IsResizeShapeToFitText;
    property IsInnerMode: Boolean read get_IsInnerMode write set_IsInnerMode;
    property Border: DNLine read get_Border;
    property Area: DNArea read get_Area;
    property TextFont: DNFont read get_TextFont;
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    property Background: DNBackgroundMode read get_Background write set_Background;
    property IsAutomaticSize: Boolean read get_IsAutomaticSize write set_IsAutomaticSize;
    property X: Int32 read get_X write set_X;
    property Y: Int32 read get_Y write set_Y;
    property Height: Int32 read get_Height write set_Height;
    property Width: Int32 read get_Width write set_Width;
    property Shadow: Boolean read get_Shadow;
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
    property IsDefaultPosBeSet: Boolean read get_IsDefaultPosBeSet;
    property DefaultX: Int32 read get_DefaultX;
    property DefaultY: Int32 read get_DefaultY;
    property DefaultWidth: Int32 read get_DefaultWidth;
    property DefaultHeight: Int32 read get_DefaultHeight;
  end;

  TDNDisplayUnitLabel = class(TDNGenericImport<DNDisplayUnitLabelClass, DNDisplayUnitLabel>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNLegendClass = interface(DNChartTextFrameClass)
  ['{A11700CE-1F90-5E78-8104-8A4F2044D173}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents the chart legend.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Set Legend's width and height
  ///  Legend legend = chart.Legend;
  ///  //Legend is at right side of chart by default.
  ///  //If the legend is at left or right side of the chart, setting Legend.X property will not take effect.
  ///  //If the legend is at top or bottom side of the chart, setting Legend.Y property will not take effect.
  ///  legend.Y = 1500;
  ///  legend.Width = 50;
  ///  legend.Height = 50;
  ///  //Set legend's position
  ///  legend.Position = LegendPositionType.Left;
  ///  [Visual Basic]
  ///  'Set Legend's width and height
  ///  Dim legend as Legend = chart.Legend
  ///  'Legend is at right side of chart by default.
  ///  'If the legend is at left or right side of the chart, setting Legend.X property will not take effect.
  ///  'If the legend is at top or bottom side of the chart, setting Legend.Y property will not take effect.
  ///  legend.Y = 1500
  ///  legend.Width = 50
  ///  legend.Height = 50
  ///  'Set legend's position
  ///  legend.Position = LegendPositionType.Left
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.Legend')]
  DNLegend = interface(DNChartTextFrame)
  ['{25EB655F-3C68-382C-9C27-30243E30C2ED}']
  { getters & setters } 

    function get_Position: DNLegendPositionType;
    procedure set_Position(value: DNLegendPositionType);
    function get_LegendEntries: DNLegendEntryCollection;
    function get_LegendEntriesLabels: DDN.mscorlib.DNArrayList;
    function get_IsOverLay: Boolean;
    procedure set_IsOverLay(value: Boolean);
    function get_IsAutoText: Boolean;
    procedure set_IsAutoText(value: Boolean);
    function get_IsDeleted: Boolean;
    procedure set_IsDeleted(value: Boolean);
    function get_TextHorizontalAlignment: DNTextAlignmentType;
    procedure set_TextHorizontalAlignment(value: DNTextAlignmentType);
    function get_TextVerticalAlignment: DNTextAlignmentType;
    procedure set_TextVerticalAlignment(value: DNTextAlignmentType);
    function get_RotationAngle: Int32;
    procedure set_RotationAngle(value: Int32);
    function get_Text: string;
    procedure set_Text(value: string);
    function get_LinkedSource: string;
    procedure set_LinkedSource(value: string);
    function get_TextDirection: DNTextDirectionType;
    procedure set_TextDirection(value: DNTextDirectionType);
    function get_ReadingOrder: DNTextDirectionType;
    procedure set_ReadingOrder(value: DNTextDirectionType);
    function get_DirectionType: DNChartTextDirectionType;
    procedure set_DirectionType(value: DNChartTextDirectionType);
    function get_IsTextWrapped: Boolean;
    procedure set_IsTextWrapped(value: Boolean);
    function get_IsResizeShapeToFitText: Boolean;
    procedure set_IsResizeShapeToFitText(value: Boolean);
    function get_IsInnerMode: Boolean;
    procedure set_IsInnerMode(value: Boolean);
    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_TextFont: DNFont;
    function get_Font: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_IsAutomaticSize: Boolean;
    procedure set_IsAutomaticSize(value: Boolean);
    function get_X: Int32;
    procedure set_X(value: Int32);
    function get_Y: Int32;
    procedure set_Y(value: Int32);
    function get_Height: Int32;
    procedure set_Height(value: Int32);
    function get_Width: Int32;
    procedure set_Width(value: Int32);
    function get_Shadow: Boolean;
    function get_ShapeProperties: DNShapePropertyCollection;
    function get_IsDefaultPosBeSet: Boolean;
    function get_DefaultX: Int32;
    function get_DefaultY: Int32;
    function get_DefaultWidth: Int32;
    function get_DefaultHeight: Int32;

  { methods } 

    ///<summary>
    ///  Returns a Characters object that represents a range of characters within the text.
    ///</summary>
    ///  <param name="startIndex">The index of the start of the character.</param>
    ///  <param name="length">The number of characters.</param>
    ///<returns>Characters object.</returns>
    function Characters(startIndex: Int32; length: Int32): DNFontSetting;
    procedure SetPositionAuto;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the legend position type.
    ///</summary>
    ///<remarks><br>Default position is right.</br><br>If the legend is at left or right side of the chart, setting Legend.X property will not take effect.</br><br>If the legend is at top or bottom side of the chart, setting Legend.Y property will not take effect.</br></remarks>
    property Position: DNLegendPositionType read get_Position write set_Position;
    ///<summary>
    ///  Gets a collection of all the LegendEntry objects in the specified chart legend.
    ///  Setting the legend entries of the surface chart is not supported.
    ///  So it will return null if the chart type is surface chart type.
    ///</summary>
    property LegendEntries: DNLegendEntryCollection read get_LegendEntries;
    ///<summary>
    ///  Gets the labels of the legend entries after call Chart.Calculate() method.
    ///</summary>
    property LegendEntriesLabels: DDN.mscorlib.DNArrayList read get_LegendEntriesLabels;
    ///<summary>
    ///  Gets or sets whether other chart elements shall be allowed to overlap this chart element.
    ///</summary>
    property IsOverLay: Boolean read get_IsOverLay write set_IsOverLay;
    ///<summary>
    ///  Indicates the text is auto generated.
    ///</summary>
    property IsAutoText: Boolean read get_IsAutoText write set_IsAutoText;
    ///<summary>
    ///  Indicates whether this data labels is deleted.
    ///</summary>
    property IsDeleted: Boolean read get_IsDeleted write set_IsDeleted;
    ///<summary>
    ///  Gets and sets the text horizontal alignment.
    ///</summary>
    property TextHorizontalAlignment: DNTextAlignmentType read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets or sets the text vertical alignment of text.
    ///</summary>
    property TextVerticalAlignment: DNTextAlignmentType read get_TextVerticalAlignment write set_TextVerticalAlignment;
    ///<summary>
    ///  Represents text rotation angle.
    ///</summary>
    ///<remarks><br>0: Not rotated.</br><br>255: Top to Bottom.</br><br>-90: Downward.</br><br>90: Upward.</br></remarks>
    property RotationAngle: Int32 read get_RotationAngle write set_RotationAngle;
    ///<summary>
    ///  Gets or sets the text of a frame's title.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets and sets a reference to the worksheet.
    ///</summary>
    property LinkedSource: string read get_LinkedSource write set_LinkedSource;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartTextFrame.ReadingOrder property.
    ///  This property will be removed 12 months later since March 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextDirection: DNTextDirectionType read get_TextDirection write set_TextDirection;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    property ReadingOrder: DNTextDirectionType read get_ReadingOrder write set_ReadingOrder;
    ///<summary>
    ///  Gets and sets the direction of text.
    ///</summary>
    property DirectionType: DNChartTextDirectionType read get_DirectionType write set_DirectionType;
    ///<summary>
    ///  Gets or sets a value indicating whether the text is wrapped.
    ///</summary>
    property IsTextWrapped: Boolean read get_IsTextWrapped write set_IsTextWrapped;
    ///<summary>
    ///  Gets or sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
    ///  when text within a shape is scaled in order to contain all the text inside.
    ///</summary>
    property IsResizeShapeToFitText: Boolean read get_IsResizeShapeToFitText write set_IsResizeShapeToFitText;
    property IsInnerMode: Boolean read get_IsInnerMode write set_IsInnerMode;
    property Border: DNLine read get_Border;
    property Area: DNArea read get_Area;
    property TextFont: DNFont read get_TextFont;
    property Font: DNFont read get_Font;
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    property Background: DNBackgroundMode read get_Background write set_Background;
    property IsAutomaticSize: Boolean read get_IsAutomaticSize write set_IsAutomaticSize;
    property X: Int32 read get_X write set_X;
    property Y: Int32 read get_Y write set_Y;
    property Height: Int32 read get_Height write set_Height;
    property Width: Int32 read get_Width write set_Width;
    property Shadow: Boolean read get_Shadow;
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
    property IsDefaultPosBeSet: Boolean read get_IsDefaultPosBeSet;
    property DefaultX: Int32 read get_DefaultX;
    property DefaultY: Int32 read get_DefaultY;
    property DefaultWidth: Int32 read get_DefaultWidth;
    property DefaultHeight: Int32 read get_DefaultHeight;
  end;

  TDNLegend = class(TDNGenericImport<DNLegendClass, DNLegend>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNTitleClass = interface(DNChartTextFrameClass)
  ['{7DC9C812-6B11-5C6A-A67F-077C3F676E52}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents the title of chart or axis.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Setting the title of a chart
  ///  chart.Title.Text = "Title";
  ///  //Setting the font color of the chart title to blue
  ///  chart.Title.Font.Color = Color.Blue;
  ///  //Setting the title of category axis of the chart
  ///  chart.CategoryAxis.Title.Text = "Category";
  ///  //Setting the title of value axis of the chart
  ///  chart.ValueAxis.Title.Text = "Value";
  ///  [Visual Basic]
  ///  'Setting the title of a chart
  ///  chart.Title.Text = "Title"
  ///  'Setting the font color of the chart title to blue
  ///  chart.Title.Font.Color = Color.Blue
  ///  'Setting the title of category axis of the chart
  ///  chart.CategoryAxis.Title.Text = "Category"
  ///  'Setting the title of value axis of the chart
  ///  chart.ValueAxis.Title.Text = "Value"
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.Title')]
  DNTitle = interface(DNChartTextFrame)
  ['{5C911F59-81B3-3362-984D-9E967A46E06C}']
  { getters & setters } 

    function get_Text: string;
    procedure set_Text(value: string);
    function get_IsVisible: Boolean;
    procedure set_IsVisible(value: Boolean);
    function get_X: Int32;
    procedure set_X(value: Int32);
    function get_Y: Int32;
    procedure set_Y(value: Int32);
    function get_OverLay: Boolean;
    procedure set_OverLay(value: Boolean);
    function get_IsAutoText: Boolean;
    procedure set_IsAutoText(value: Boolean);
    function get_IsDeleted: Boolean;
    procedure set_IsDeleted(value: Boolean);
    function get_TextHorizontalAlignment: DNTextAlignmentType;
    procedure set_TextHorizontalAlignment(value: DNTextAlignmentType);
    function get_TextVerticalAlignment: DNTextAlignmentType;
    procedure set_TextVerticalAlignment(value: DNTextAlignmentType);
    function get_RotationAngle: Int32;
    procedure set_RotationAngle(value: Int32);
    function get_LinkedSource: string;
    procedure set_LinkedSource(value: string);
    function get_TextDirection: DNTextDirectionType;
    procedure set_TextDirection(value: DNTextDirectionType);
    function get_ReadingOrder: DNTextDirectionType;
    procedure set_ReadingOrder(value: DNTextDirectionType);
    function get_DirectionType: DNChartTextDirectionType;
    procedure set_DirectionType(value: DNChartTextDirectionType);
    function get_IsTextWrapped: Boolean;
    procedure set_IsTextWrapped(value: Boolean);
    function get_IsResizeShapeToFitText: Boolean;
    procedure set_IsResizeShapeToFitText(value: Boolean);
    function get_IsInnerMode: Boolean;
    procedure set_IsInnerMode(value: Boolean);
    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_TextFont: DNFont;
    function get_Font: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_IsAutomaticSize: Boolean;
    procedure set_IsAutomaticSize(value: Boolean);
    function get_Height: Int32;
    procedure set_Height(value: Int32);
    function get_Width: Int32;
    procedure set_Width(value: Int32);
    function get_Shadow: Boolean;
    function get_ShapeProperties: DNShapePropertyCollection;
    function get_IsDefaultPosBeSet: Boolean;
    function get_DefaultX: Int32;
    function get_DefaultY: Int32;
    function get_DefaultWidth: Int32;
    function get_DefaultHeight: Int32;

  { methods } 

    ///<summary>
    ///  Gets rich text formatting of this Title.
    ///</summary>
    ///<returns>returns FontSetting array</returns>
    function Characters: TArray<DNFontSetting>; overload;
    ///<summary>
    ///  Returns a Characters object that represents a range of characters within the text.
    ///</summary>
    ///  <param name="startIndex">The index of the start of the character.</param>
    ///  <param name="length">The number of characters.</param>
    ///<returns>Characters object.</returns>
    function Characters(startIndex: Int32; length: Int32): DNFontSetting; overload;
    procedure SetPositionAuto;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or sets the text of display unit label.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Represents whether the title is visible.
    ///</summary>
    property IsVisible: Boolean read get_IsVisible write set_IsVisible;
    ///<summary>
    ///  Gets or sets the x coordinate of the upper left corner in units of 1/4000 of the chart area.
    ///</summary>
    property X: Int32 read get_X write set_X;
    ///<summary>
    ///  Gets or sets the y coordinate of the upper left corner in units of 1/4000 of the chart area.
    ///</summary>
    property Y: Int32 read get_Y write set_Y;
    ///<summary>
    ///  Represents overlay centered title on chart without resizing chart.
    ///</summary>
    property OverLay: Boolean read get_OverLay write set_OverLay;
    ///<summary>
    ///  Indicates the text is auto generated.
    ///</summary>
    property IsAutoText: Boolean read get_IsAutoText write set_IsAutoText;
    ///<summary>
    ///  Indicates whether this data labels is deleted.
    ///</summary>
    property IsDeleted: Boolean read get_IsDeleted write set_IsDeleted;
    ///<summary>
    ///  Gets and sets the text horizontal alignment.
    ///</summary>
    property TextHorizontalAlignment: DNTextAlignmentType read get_TextHorizontalAlignment write set_TextHorizontalAlignment;
    ///<summary>
    ///  Gets or sets the text vertical alignment of text.
    ///</summary>
    property TextVerticalAlignment: DNTextAlignmentType read get_TextVerticalAlignment write set_TextVerticalAlignment;
    ///<summary>
    ///  Represents text rotation angle.
    ///</summary>
    ///<remarks><br>0: Not rotated.</br><br>255: Top to Bottom.</br><br>-90: Downward.</br><br>90: Upward.</br></remarks>
    property RotationAngle: Int32 read get_RotationAngle write set_RotationAngle;
    ///<summary>
    ///  Gets and sets a reference to the worksheet.
    ///</summary>
    property LinkedSource: string read get_LinkedSource write set_LinkedSource;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartTextFrame.ReadingOrder property.
    ///  This property will be removed 12 months later since March 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextDirection: DNTextDirectionType read get_TextDirection write set_TextDirection;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    property ReadingOrder: DNTextDirectionType read get_ReadingOrder write set_ReadingOrder;
    ///<summary>
    ///  Gets and sets the direction of text.
    ///</summary>
    property DirectionType: DNChartTextDirectionType read get_DirectionType write set_DirectionType;
    ///<summary>
    ///  Gets or sets a value indicating whether the text is wrapped.
    ///</summary>
    property IsTextWrapped: Boolean read get_IsTextWrapped write set_IsTextWrapped;
    ///<summary>
    ///  Gets or sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
    ///  when text within a shape is scaled in order to contain all the text inside.
    ///</summary>
    property IsResizeShapeToFitText: Boolean read get_IsResizeShapeToFitText write set_IsResizeShapeToFitText;
    property IsInnerMode: Boolean read get_IsInnerMode write set_IsInnerMode;
    property Border: DNLine read get_Border;
    property Area: DNArea read get_Area;
    property TextFont: DNFont read get_TextFont;
    property Font: DNFont read get_Font;
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    property Background: DNBackgroundMode read get_Background write set_Background;
    property IsAutomaticSize: Boolean read get_IsAutomaticSize write set_IsAutomaticSize;
    property Height: Int32 read get_Height write set_Height;
    property Width: Int32 read get_Width write set_Width;
    property Shadow: Boolean read get_Shadow;
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
    property IsDefaultPosBeSet: Boolean read get_IsDefaultPosBeSet;
    property DefaultX: Int32 read get_DefaultX;
    property DefaultY: Int32 read get_DefaultY;
    property DefaultWidth: Int32 read get_DefaultWidth;
    property DefaultHeight: Int32 read get_DefaultHeight;
  end;

  TDNTitle = class(TDNGenericImport<DNTitleClass, DNTitle>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNPlotAreaClass = interface(DNChartFrameClass)
  ['{532BE37C-09AC-5838-BC0A-CE4A135F371C}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents the plot area in a chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.PlotArea')]
  DNPlotArea = interface(DNChartFrame)
  ['{C7D276A4-5D70-3297-8EA1-3F904DBF9B2C}']
  { getters & setters } 

    function get_X: Int32;
    procedure set_X(value: Int32);
    function get_Y: Int32;
    procedure set_Y(value: Int32);
    function get_Height: Int32;
    procedure set_Height(value: Int32);
    function get_Width: Int32;
    procedure set_Width(value: Int32);
    function get_InnerX: Int32;
    procedure set_InnerX(value: Int32);
    function get_InnerY: Int32;
    procedure set_InnerY(value: Int32);
    function get_InnerHeight: Int32;
    procedure set_InnerHeight(value: Int32);
    function get_InnerWidth: Int32;
    procedure set_InnerWidth(value: Int32);
    function get_IsAutomaticSize: Boolean;
    procedure set_IsAutomaticSize(value: Boolean);
    function get_IsInnerMode: Boolean;
    procedure set_IsInnerMode(value: Boolean);
    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_TextFont: DNFont;
    function get_Font: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_Shadow: Boolean;
    function get_ShapeProperties: DNShapePropertyCollection;
    function get_IsDefaultPosBeSet: Boolean;
    function get_DefaultX: Int32;
    function get_DefaultY: Int32;
    function get_DefaultWidth: Int32;
    function get_DefaultHeight: Int32;

  { methods } 

    ///<summary>
    ///  Set position of the plot area to automatic
    ///</summary>
    procedure SetPositionAuto;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets or gets the x coordinate of the upper left corner of plot-area bounding box in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks><p>The plot-area bounding box includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If the value is not created by MS Excel, please call Chart.Calculate() method before calling this method. </p>
    ///  <p>The <b>X</b>
    ///  , <b>Y</b>
    ///  , <b>Width</b>
    ///  and <b>Height</b>
    ///  of <b>PlotArea</b>
    ///  represents the plot-area
    ///  bounding box that includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If you want to get actual size of plot area, you should call <b>InnerX</b>
    ///  , <b>InnerY</b>
    ///  , <b>InnerWidth</b>
    ///  and
    ///<b>InnerHeight</b>
    ///  properties.</p>
    ///  <p>For excel 2007 or latter, the default value is zero. you should call get the value after calling Chart.Calculate().</p>
    ///</remarks>
    property X: Int32 read get_X write set_X;
    ///<summary>
    ///  Gets or gets the y coordinate of the upper top corner  of plot-area bounding box in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks><p>The plot-area bounding box includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If the value is not created by MS Excel, please call Chart.Calculate() method before calling this method. </p>
    ///  <p>The <b>X</b>
    ///  , <b>Y</b>
    ///  , <b>Width</b>
    ///  and <b>Height</b>
    ///  of <b>PlotArea</b>
    ///  represents the plot-area
    ///  bounding box that includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If you want to get actual size of plot area, you should call <b>InnerX</b>
    ///  , <b>InnerY</b>
    ///  , <b>InnerWidth</b>
    ///  and
    ///<b>InnerHeight</b>
    ///  properties.</p>
    ///  <p>For excel 2007 or latter, the default value is zero. you should call get the value after calling Chart.Calculate().</p>
    ///</remarks>
    property Y: Int32 read get_Y write set_Y;
    ///<summary>
    ///  Gets or sets the height of plot-area bounding box in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks><p>The plot-area bounding box includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If the value is not created by MS Excel, please call Chart.Calculate() method before calling this method. </p>
    ///  <p>The <b>X</b>
    ///  , <b>Y</b>
    ///  , <b>Width</b>
    ///  and <b>Height</b>
    ///  of <b>PlotArea</b>
    ///  represents the plot-area
    ///  bounding box that includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If you want to get actual size of plot area, you should call <b>InnerX</b>
    ///  , <b>InnerY</b>
    ///  , <b>InnerWidth</b>
    ///  and
    ///<b>InnerHeight</b>
    ///  properties.</p>
    ///  <p>For excel 2007 or latter, the default value is zero. you should call get the value after calling Chart.Calculate().</p>
    ///</remarks>
    property Height: Int32 read get_Height write set_Height;
    ///<summary>
    ///  Gets or sets the width of plot-area bounding box in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks><p>The plot-area bounding box includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If the value is not created by MS Excel, please call Chart.Calculate() method before calling this method. </p>
    ///  <p>The <b>X</b>
    ///  , <b>Y</b>
    ///  , <b>Width</b>
    ///  and <b>Height</b>
    ///  of <b>PlotArea</b>
    ///  represents the plot-area
    ///  bounding box that includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If you want to get actual size of plot area, you should call <b>InnerX</b>
    ///  , <b>InnerY</b>
    ///  , <b>InnerWidth</b>
    ///  and
    ///<b>InnerHeight</b>
    ///  properties.</p>
    ///  <p>For excel 2007 or latter, the default value is zero. you should call get the value after calling Chart.Calculate().</p>
    ///</remarks>
    property Width: Int32 read get_Width write set_Width;
    ///<summary>
    ///  Gets or gets the x coordinate of the upper top corner of plot area in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks><p>The plot-area bounding box includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If the value is not created by MS Excel, please call Chart.Calculate() method before calling this method. </p>
    ///  <p>The <b>X</b>
    ///  , <b>Y</b>
    ///  , <b>Width</b>
    ///  and <b>Height</b>
    ///  of <b>PlotArea</b>
    ///  represents the plot-area
    ///  bounding box that includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If you want to get actual size of plot area, you should call <b>InnerX</b>
    ///  , <b>InnerY</b>
    ///  , <b>InnerWidth</b>
    ///  and
    ///<b>InnerHeight</b>
    ///  properties.</p>
    ///  <p>For excel 2007 or latter, the default value is zero. you should call get the value after calling Chart.Calculate().</p>
    ///</remarks>
    property InnerX: Int32 read get_InnerX write set_InnerX;
    ///<summary>
    ///  Gets or gets the x coordinate of the upper top corner of plot area in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks><p>The plot-area bounding box includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If the value is not created by MS Excel, please call Chart.Calculate() method before calling this method. </p>
    ///  <p>The <b>X</b>
    ///  , <b>Y</b>
    ///  , <b>Width</b>
    ///  and <b>Height</b>
    ///  of <b>PlotArea</b>
    ///  represents the plot-area
    ///  bounding box that includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If you want to get actual size of plot area, you should call <b>InnerX</b>
    ///  , <b>InnerY</b>
    ///  , <b>InnerWidth</b>
    ///  and
    ///<b>InnerHeight</b>
    ///  properties.</p>
    ///  <p>For excel 2007 or latter, the default value is zero. you should call get the value after calling Chart.Calculate().</p>
    ///</remarks>
    property InnerY: Int32 read get_InnerY write set_InnerY;
    ///<summary>
    ///  Gets or sets the height of plot area in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks><p>The plot-area bounding box includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If the value is not created by MS Excel, please call Chart.Calculate() method before calling this method. </p>
    ///  <p>The <b>X</b>
    ///  , <b>Y</b>
    ///  , <b>Width</b>
    ///  and <b>Height</b>
    ///  of <b>PlotArea</b>
    ///  represents the plot-area
    ///  bounding box that includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If you want to get actual size of plot area, you should call <b>InnerX</b>
    ///  , <b>InnerY</b>
    ///  , <b>InnerWidth</b>
    ///  and
    ///<b>InnerHeight</b>
    ///  properties.</p>
    ///  <p>For excel 2007 or latter, the default value is zero. you should call get the value after calling Chart.Calculate().</p>
    ///</remarks>
    property InnerHeight: Int32 read get_InnerHeight write set_InnerHeight;
    ///<summary>
    ///  Gets or sets the width  of plot area in units of 1/4000 of the chart area.
    ///</summary>
    ///<remarks><p>The plot-area bounding box includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If the value is not created by MS Excel, please call Chart.Calculate() method before calling this method. </p>
    ///  <p>The <b>X</b>
    ///  , <b>Y</b>
    ///  , <b>Width</b>
    ///  and <b>Height</b>
    ///  of <b>PlotArea</b>
    ///  represents the plot-area
    ///  bounding box that includes the plot area, tick marks(tick labels), and a small border around the tick marks.
    ///  If you want to get actual size of plot area, you should call <b>InnerX</b>
    ///  , <b>InnerY</b>
    ///  , <b>InnerWidth</b>
    ///  and
    ///<b>InnerHeight</b>
    ///  properties.</p>
    ///  <p>For excel 2007 or latter, the default value is zero. you should call get the value after calling Chart.Calculate().</p>
    ///</remarks>
    property InnerWidth: Int32 read get_InnerWidth write set_InnerWidth;
    ///<summary>
    ///  Indicates whether the plot area is automatic sized.
    ///</summary>
    property IsAutomaticSize: Boolean read get_IsAutomaticSize write set_IsAutomaticSize;
    ///<summary>
    ///  Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
    ///  False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.
    ///</summary>
    ///<remarks>
    ///  Only for Xlsx file.
    ///</remarks>
    property IsInnerMode: Boolean read get_IsInnerMode write set_IsInnerMode;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Drawing.Line">border</see>.
    ///</summary>
    property Border: DNLine read get_Border;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartFrame.Area">area</see>.
    ///</summary>
    property Area: DNArea read get_Area;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.ChartFrame.Font" />
    ///  object of the specified ChartFrame object.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartFrame.Font property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextFont: DNFont read get_TextFont;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.ChartFrame.Font" />
    ///  object of the specified ChartFrame object.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  True if the text in the object changes font size when the object size changes. The default value is True.
    ///</summary>
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ChartFrame.BackgroundMode property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property Background: DNBackgroundMode read get_Background write set_Background;
    ///<summary>
    ///  True if the frame has a shadow.
    ///</summary>
    property Shadow: Boolean read get_Shadow;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartFrame.ShapeProperties" />
    ///  object.
    ///</summary>
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
    ///<summary>
    ///  Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.
    ///</summary>
    property IsDefaultPosBeSet: Boolean read get_IsDefaultPosBeSet;
    ///<summary>
    ///  Represents x of default position
    ///</summary>
    property DefaultX: Int32 read get_DefaultX;
    ///<summary>
    ///  Represents y of default position
    ///</summary>
    property DefaultY: Int32 read get_DefaultY;
    ///<summary>
    ///  Represents width of default position
    ///</summary>
    property DefaultWidth: Int32 read get_DefaultWidth;
    ///<summary>
    ///  Represents height of default position
    ///</summary>
    property DefaultHeight: Int32 read get_DefaultHeight;
  end;

  TDNPlotArea = class(TDNGenericImport<DNPlotAreaClass, DNPlotArea>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNChartPointClass = interface(DDN.mscorlib.DNObjectClass)
  ['{29DFA16C-312F-5053-8D60-D83200E82A18}']
  end;

  ///<summary>
  ///  Represents a single point in a series in a chart.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Obtaining the reference of the first worksheet
  ///  Worksheet worksheet = workbook.Worksheets[0];
  ///  //Adding a sample value to "A1" cell
  ///  worksheet.Cells["A1"].PutValue(50);
  ///  //Adding a sample value to "A2" cell
  ///  worksheet.Cells["A2"].PutValue(100);
  ///  //Adding a sample value to "A3" cell
  ///  worksheet.Cells["A3"].PutValue(150);
  ///  //Adding a sample value to "B1" cell
  ///  worksheet.Cells["B1"].PutValue(60);
  ///  //Adding a sample value to "B2" cell
  ///  worksheet.Cells["B2"].PutValue(32);
  ///  //Adding a sample value to "B3" cell
  ///  worksheet.Cells["B3"].PutValue(50);
  ///  //Adding a chart to the worksheet
  ///  int chartIndex = worksheet.Charts.Add(ChartType.PieExploded, 5, 0, 25, 10);
  ///  //Accessing the instance of the newly added chart
  ///  Chart chart = worksheet.Charts[chartIndex];
  ///  //Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", true);
  ///  //Show Data Labels
  ///  chart.NSeries[0].DataLabels.IsValueShown = true;
  ///  for (int i = 0; i  &lt; chart.NSeries[0].Points.Count; i++)
  ///  {
  ///  //Get Data Point
  ///  ChartPoint point = chart.NSeries[0].Points[i];
  ///  //Set Pir Explosion
  ///  point.Explosion = 15;
  ///  //Set Border Color
  ///  point.Border.Color = System.Drawing.Color.Red;
  ///  }
  ///  //Saving the Excel file
  ///  workbook.Save("D:\\book1.xls");
  ///  [VB.NET]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As New Workbook()
  ///  'Obtaining the reference of the first worksheet
  ///  Dim worksheet As Worksheet = workbook.Worksheets(0)
  ///  'Adding a sample value to "A1" cell
  ///  worksheet.Cells("A1").PutValue(50)
  ///  'Adding a sample value to "A2" cell
  ///  worksheet.Cells("A2").PutValue(100)
  ///  'Adding a sample value to "A3" cell
  ///  worksheet.Cells("A3").PutValue(150)
  ///  'Adding a sample value to "B1" cell
  ///  worksheet.Cells("B1").PutValue(60)
  ///  'Adding a sample value to "B2" cell
  ///  worksheet.Cells("B2").PutValue(32)
  ///  'Adding a sample value to "B3" cell
  ///  worksheet.Cells("B3").PutValue(50)
  ///  'Adding a chart to the worksheet
  ///  Dim chartIndex As Integer = worksheet.Charts.Add(ChartType.PieExploded, 5, 0, 25, 10)
  ///  'Accessing the instance of the newly added chart
  ///  Dim chart As Chart = worksheet.Charts(chartIndex)
  ///  'Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", True)
  ///  'Show Data Labels
  ///  chart.NSeries(0).DataLabels.IsValueShown = True
  ///  For i As Integer = 0 To chart.NSeries(0).Points.Count - 1
  ///  'Get Data Point
  ///  Dim point As ChartPoint = chart.NSeries(0).Points(i)
  ///  'Set Pir Explosion
  ///  point.Explosion = 15
  ///  'Set Border Color
  ///  point.Border.Color = System.Drawing.Color.Red
  ///  Next i
  ///  'Saving the Excel file
  ///  workbook.Save("D:\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.ChartPoint')]
  DNChartPoint = interface(DDN.mscorlib.DNObject)
  ['{E30C9BE8-0B1D-351C-8AB1-4451DE67A870}']
  { getters & setters } 

    function get_Explosion: Int32;
    procedure set_Explosion(value: Int32);
    function get_Shadow: Boolean;
    procedure set_Shadow(value: Boolean);
    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_Marker: DNMarker;
    function get_DataLabels: DNDataLabels;
    function get_YValue: DDN.mscorlib.DNObject;
    procedure set_YValue(value: DDN.mscorlib.DNObject);
    function get_YValueType: DNCellValueType;
    function get_XValue: DDN.mscorlib.DNObject;
    procedure set_XValue(value: DDN.mscorlib.DNObject);
    function get_XValueType: DNCellValueType;
    function get_ShapeProperties: DNShapePropertyCollection;
    function get_IsInSecondaryPlot: Boolean;
    procedure set_IsInSecondaryPlot(value: Boolean);
    function get_ShapeX: Int32;
    function get_ShapeY: Int32;
    function get_ShapeWidth: Int32;
    function get_ShapeHeight: Int32;
    function get_ShapeXPx: Int32;
    function get_ShapeYPx: Int32;
    function get_ShapeWidthPx: Int32;
    function get_ShapeHeightPx: Int32;
    function get_BorderWidthPx: Int32;
    function get_RadiusPx: Int32;
    function get_InnerRadiusPx: Int32;
    function get_StartAngle: Single;
    function get_EndAngle: Single;
    function get_ArcStartPointXPx: Single;
    function get_ArcStartPointYPx: Single;
    function get_ArcEndPointXPx: Single;
    function get_ArcEndPointYPx: Single;
    function get_InnerArcStartPointXPx: Single;
    function get_InnerArcStartPointYPx: Single;
    function get_InnerArcEndPointXPx: Single;
    function get_InnerArcEndPointYPx: Single;

  { methods } 

    ///<summary>
    ///  Gets the number of top points after calls Chart.Calculate() method.
    ///</summary>
    function GetTopPointCount: Int32;
    ///<summary>
    ///  Gets x-coordinate of the top point of shape after calls Chart.Calculate() method.
    ///  Applies 3D charts: Column3D, Bar3D, Cone, Cylinder, Pyramid and Area3D
    ///</summary>
    function GetTopPointXPx(index: Int32): Single;
    ///<summary>
    ///  Gets y-coordinate of the top point of shape after calls Chart.Calculate() method.
    ///  Applies 3D charts: Column3D, Bar3D, Cone, Cylinder, Pyramid and Area3D
    ///</summary>
    function GetTopPointYPx(index: Int32): Single;
    ///<summary>
    ///  Gets the number of bottom points  after calls Chart.Calculate() method.
    ///</summary>
    function GetBottomPointCount: Int32;
    ///<summary>
    ///  Gets x-coordinate of the bottom point of shape after calls Chart.Calculate() method.
    ///  Applies 3D charts: Column3D, Bar3D, Cone, Cylinder, Pyramid
    ///</summary>
    function GetBottomPointXPx(index: Int32): Single;
    ///<summary>
    ///  Gets y-coordinate of the bottom point of shape  after calls Chart.Calculate() method.
    ///  Applies 3D charts: Column3D, Bar3D, Cone, Cylinder, Pyramid
    ///</summary>
    function GetBottomPointYPx(index: Int32): Single;
    ///<summary>
    ///  Gets the number of the points on category axis after calls Chart.Calculate() method. Only applies to area chart.
    ///</summary>
    ///<remarks>
    ///  Area 2D chart return 1
    ///  Area 3D chart return 2.
    ///</remarks>
    function GetOnCategoryAxisPointCount: Int32;
    ///<summary>
    ///  Gets x-coordinate of the point on category axis after calls Chart.Calculate() method. Only applies to Area chart.
    ///</summary>
    ///<remarks>
    ///  Area 2D chart: index is 0.
    ///  Area 3D chart: index is 0 or 1.
    ///</remarks>
    function GetOnCategoryAxisPointXPx(index: Int32): Single;
    ///<summary>
    ///  Gets y-coordinate of the point on category axis after calls Chart.Calculate() method. Only applies to Area chart.
    ///</summary>
    ///<remarks>
    ///  Area 2D chart: index is 0.
    ///  Area 3D chart: index is 0 or 1.
    ///</remarks>
    function GetOnCategoryAxisPointYPx(index: Int32): Single;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  The distance of an open pie slice from the center of the pie chart is expressed as a percentage of the pie diameter.
    ///</summary>
    property Explosion: Int32 read get_Explosion write set_Explosion;
    ///<summary>
    ///  True if the chartpoint has a shadow.
    ///</summary>
    property Shadow: Boolean read get_Shadow write set_Shadow;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Drawing.Line">border</see>.
    ///</summary>
    property Border: DNLine read get_Border;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartPoint.Area">area</see>.
    ///</summary>
    property Area: DNArea read get_Area;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.ChartPoint.Marker">marker</see>.
    ///</summary>
    property Marker: DNMarker read get_Marker;
    ///<summary>
    ///  Returns a DataLabels object that represents the data label associated with the point.
    ///</summary>
    property DataLabels: DNDataLabels read get_DataLabels;
    ///<summary>
    ///  Gets or sets the Y value of the chart point.
    ///</summary>
    property YValue: DDN.mscorlib.DNObject read get_YValue write set_YValue;
    ///<summary>
    ///  Gets Y value type of the chart point.
    ///</summary>
    property YValueType: DNCellValueType read get_YValueType;
    ///<summary>
    ///  Gets or sets the X value of the chart point.
    ///</summary>
    property XValue: DDN.mscorlib.DNObject read get_XValue write set_XValue;
    ///<summary>
    ///  Gets X value type of the chart point.
    ///</summary>
    property XValueType: DNCellValueType read get_XValueType;
    ///<summary>
    ///  Gets the <seealso cref="T:Aspose.Cells.Drawing.ShapePropertyCollection" />
    ///  object that holds the visual shape properties of the ChartPoint.
    ///</summary>
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
    ///<summary>
    ///  Gets or sets a value indicates whether this data points is in the second pie or bar
    ///  on a pie of pie or bar of pie chart
    ///</summary>
    property IsInSecondaryPlot: Boolean read get_IsInSecondaryPlot write set_IsInSecondaryPlot;
    ///<summary>
    ///  Gets the x coordinate of the upper left corner in units of 1/4000 of chart's width after calls Chart.Calculate() method.
    ///</summary>
    property ShapeX: Int32 read get_ShapeX;
    ///<summary>
    ///  Gets the y coordinate of the upper left corner in units of 1/4000 of chart's height after calls Chart.Calculate() method.
    ///</summary>
    property ShapeY: Int32 read get_ShapeY;
    ///<summary>
    ///  Gets the width in units of 1/4000 of chart's width after calls Chart.Calculate() method.
    ///</summary>
    property ShapeWidth: Int32 read get_ShapeWidth;
    ///<summary>
    ///  Gets the height in units of 1/4000 of chart's height after calls Chart.Calculate() method.
    ///</summary>
    property ShapeHeight: Int32 read get_ShapeHeight;
    ///<summary>
    ///  Gets the x coordinate of the upper left corner in units of pixels after calls Chart.Calculate() method.
    ///</summary>
    property ShapeXPx: Int32 read get_ShapeXPx;
    ///<summary>
    ///  Gets the y coordinate of the upper left corner in units of pixels after calls Chart.Calculate() method.
    ///</summary>
    property ShapeYPx: Int32 read get_ShapeYPx;
    ///<summary>
    ///  Gets the width in units of pixels after calls Chart.Calculate() method.
    ///</summary>
    property ShapeWidthPx: Int32 read get_ShapeWidthPx;
    ///<summary>
    ///  Gets the height in units of pixels after calls Chart.Calculate() method.
    ///</summary>
    property ShapeHeightPx: Int32 read get_ShapeHeightPx;
    ///<summary>
    ///  Gets the width of border in units of pixels after calls Chart.Calculate() method.
    ///</summary>
    property BorderWidthPx: Int32 read get_BorderWidthPx;
    ///<summary>
    ///  Gets the radius of bubble, pie or doughnut in units of pixels after calls Chart.Calculate() method.
    ///</summary>
    property RadiusPx: Int32 read get_RadiusPx;
    ///<summary>
    ///  Gets the inner radius of doughnut slice in units of pixels after calls Chart.Calculate() method.
    ///  Applies to Doughnut chart.
    ///</summary>
    property InnerRadiusPx: Int32 read get_InnerRadiusPx;
    ///<summary>
    ///  Gets the starting angle for the pie section, measured in degrees clockwise from the x-axis after calls Chart.Calculate() method.
    ///  Applies to Pie chart.
    ///</summary>
    property StartAngle: Single read get_StartAngle;
    ///<summary>
    ///  Gets the ending angle for the pie section, measured in degrees clockwise from the x-axis after calls Chart.Calculate() method.
    ///  Applies to Pie chart.
    ///</summary>
    property EndAngle: Single read get_EndAngle;
    ///<summary>
    ///  Gets the x coordinate of starting point for the pie section after calls Chart.Calculate() method.
    ///  Applies to Pie and Doughnut  chart.
    ///</summary>
    property ArcStartPointXPx: Single read get_ArcStartPointXPx;
    ///<summary>
    ///  Gets the y coordinate of starting point for the pie section after calls Chart.Calculate() method.
    ///  Applies to Pie and Doughnut  chart.
    ///</summary>
    property ArcStartPointYPx: Single read get_ArcStartPointYPx;
    ///<summary>
    ///  Gets the x coordinate of ending point for the pie section after calls Chart.Calculate() method.
    ///  Applies to Pie and Doughnut  chart.
    ///</summary>
    property ArcEndPointXPx: Single read get_ArcEndPointXPx;
    ///<summary>
    ///  Gets the y coordinate of ending point for the pie section after calls Chart.Calculate() method.
    ///  Applies to Pie and Doughnut chart.
    ///</summary>
    property ArcEndPointYPx: Single read get_ArcEndPointYPx;
    ///<summary>
    ///  Gets the x coordinate of starting point for the pie section after calls Chart.Calculate() method.
    ///  Applies to Doughnut chart.
    ///</summary>
    property InnerArcStartPointXPx: Single read get_InnerArcStartPointXPx;
    ///<summary>
    ///  Gets the y coordinate of starting point for the pie section after calls Chart.Calculate() method.
    ///  Applies to Doughnut chart.
    ///</summary>
    property InnerArcStartPointYPx: Single read get_InnerArcStartPointYPx;
    ///<summary>
    ///  Gets the x coordinate of ending point for the pie section after calls Chart.Calculate() method.
    ///  Applies to Doughnut chart.
    ///</summary>
    property InnerArcEndPointXPx: Single read get_InnerArcEndPointXPx;
    ///<summary>
    ///  Gets the y coordinate of ending point for the pie section after calls Chart.Calculate() method.
    ///  Applies to Doughnut chart.
    ///</summary>
    property InnerArcEndPointYPx: Single read get_InnerArcEndPointYPx;
  end;

  TDNChartPoint = class(TDNGenericImport<DNChartPointClass, DNChartPoint>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNChartPointCollectionClass = interface(DDN.mscorlib.DNObjectClass)
  ['{59D1ECDD-FD23-5A7B-BFC6-F4800D210473}']
  end;

  ///<summary>
  ///  Represents a collection that contains all the points in one series.
  ///</summary>
  ///<example><code>
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Obtaining the reference of the first worksheet
  ///  Worksheet worksheet = workbook.Worksheets[0];
  ///  //Adding a sample value to "A1" cell
  ///  worksheet.Cells["A1"].PutValue(50);
  ///  //Adding a sample value to "A2" cell
  ///  worksheet.Cells["A2"].PutValue(100);
  ///  //Adding a sample value to "A3" cell
  ///  worksheet.Cells["A3"].PutValue(150);
  ///  //Adding a sample value to "B1" cell
  ///  worksheet.Cells["B1"].PutValue(60);
  ///  //Adding a sample value to "B2" cell
  ///  worksheet.Cells["B2"].PutValue(32);
  ///  //Adding a sample value to "B3" cell
  ///  worksheet.Cells["B3"].PutValue(50);
  ///  //Adding a chart to the worksheet
  ///  int chartIndex = worksheet.Charts.Add(ChartType.PieExploded, 5, 0, 25, 10);
  ///  //Accessing the instance of the newly added chart
  ///  Chart chart = worksheet.Charts[chartIndex];
  ///  //Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", true);
  ///  //Show Data Labels
  ///  chart.NSeries[0].DataLabels.IsValueShown = true;
  ///  ChartPointCollection points = chart.NSeries[0].Points;
  ///  for (int i = 0; i &lt; points.Count; i++)
  ///  {
  ///  //Get Data Point
  ///  ChartPoint point = points[i];
  ///  //Set Pir Explosion
  ///  point.Explosion = 15;
  ///  //Set Border Color
  ///  point.Border.Color = System.Drawing.Color.Red;
  ///  }
  ///  //Saving the Excel file
  ///  workbook.Save("D:\\book1.xls");
  ///  [VB.NET]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As New Workbook()
  ///  'Obtaining the reference of the first worksheet
  ///  Dim worksheet As Worksheet = workbook.Worksheets(0)
  ///  'Adding a sample value to "A1" cell
  ///  worksheet.Cells("A1").PutValue(50)
  ///  'Adding a sample value to "A2" cell
  ///  worksheet.Cells("A2").PutValue(100)
  ///  'Adding a sample value to "A3" cell
  ///  worksheet.Cells("A3").PutValue(150)
  ///  'Adding a sample value to "B1" cell
  ///  worksheet.Cells("B1").PutValue(60)
  ///  'Adding a sample value to "B2" cell
  ///  worksheet.Cells("B2").PutValue(32)
  ///  'Adding a sample value to "B3" cell
  ///  worksheet.Cells("B3").PutValue(50)
  ///  'Adding a chart to the worksheet
  ///  Dim chartIndex As Integer = worksheet.Charts.Add(ChartType.PieExploded, 5, 0, 25, 10)
  ///  'Accessing the instance of the newly added chart
  ///  Dim chart As Chart = worksheet.Charts(chartIndex)
  ///  'Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B3"
  ///  chart.NSeries.Add("A1:B3", True)
  ///  'Show Data Labels
  ///  chart.NSeries(0).DataLabels.IsValueShown = True
  ///  Dim points As ChartPointCollection = chart.NSeries(0).Points
  ///  For i As Integer = 0 To points.Count - 1
  ///  'Get Data Point
  ///  Dim point As ChartPoint = points(i)
  ///  'Set Pir Explosion
  ///  point.Explosion = 15
  ///  'Set Border Color
  ///  point.Border.Color = System.Drawing.Color.Red
  ///  Next i
  ///  'Saving the Excel file
  ///  workbook.Save("D:\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.ChartPointCollection')]
  DNChartPointCollection = interface(DDN.mscorlib.DNObject)
  ['{FF74254D-4F12-3C00-AFB2-818645B5670D}']
  { getters & setters } 

    function get_Count: Int32;
    function get_Item(index: Int32): DNChartPoint;

  { methods } 

    ///<summary>
    ///  Returns an enumerator for the entire <see cref="T:Aspose.Cells.Charts.ChartPointCollection" />
    ///  .
    ///</summary>
    ///<returns></returns>
    function GetEnumerator: DDN.mscorlib.DNIEnumerator;
    ///<summary>
    ///  Remove all setting of the chart points.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Removes point at the index of the series..
    ///</summary>
    ///  <param name="index">The index of the point.</param>
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the count of the chart point.
    ///</summary>
    property Count: Int32 read get_Count;
    property Item[index: Int32]: DNChartPoint read get_Item; default;
  end;

  TDNChartPointCollection = class(TDNGenericImport<DNChartPointCollectionClass, DNChartPointCollection>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNDropBarsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{312D0733-4791-5A78-A984-6ECFB800C098}']
  end;

  ///<summary>
  ///  Represents the up/down bars in a chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.DropBars')]
  DNDropBars = interface(DDN.mscorlib.DNObject)
  ['{74A97EEA-BCB1-3A32-B29F-54CEACFB2569}']
  { getters & setters } 

    function get_Border: DNLine;
    function get_Area: DNArea;

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the border <see cref="T:Aspose.Cells.Drawing.Line" />
    ///  .
    ///</summary>
    property Border: DNLine read get_Border;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.DropBars.Area" />
    ///  .
    ///</summary>
    property Area: DNArea read get_Area;
  end;

  TDNDropBars = class(TDNGenericImport<DNDropBarsClass, DNDropBars>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNLegendEntryClass = interface(DDN.mscorlib.DNObjectClass)
  ['{7A50F5E0-E0CC-5F66-9B94-528585E70C7B}']
  end;

  ///<summary>
  ///  Represents a legend entry in a chart legend.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.LegendEntry')]
  DNLegendEntry = interface(DDN.mscorlib.DNObject)
  ['{93278A99-70AA-3491-AF2C-3352E39A21DE}']
  { getters & setters } 

    function get_IsDeleted: Boolean;
    procedure set_IsDeleted(value: Boolean);
    function get_Font: DNFont;
    function get_TextFont: DNFont;
    function get_IsTextNoFill: Boolean;
    procedure set_IsTextNoFill(value: Boolean);
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_Background: DNBackgroundMode;
    procedure set_Background(value: DNBackgroundMode);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets and sets whether the legend entry is deleted.
    ///</summary>
    property IsDeleted: Boolean read get_IsDeleted write set_IsDeleted;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.LegendEntry.Font" />
    ///  object of the specified ChartFrame object.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  Gets a <see cref="P:Aspose.Cells.Charts.LegendEntry.Font" />
    ///  object of the specified LegendEntry object.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use LegendEntry.Font property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextFont: DNFont read get_TextFont;
    ///<summary>
    ///  Gets or sets no fill of the text.
    ///</summary>
    property IsTextNoFill: Boolean read get_IsTextNoFill write set_IsTextNoFill;
    ///<summary>
    ///  True if the text in the object changes font size when the object size changes.
    ///  The default value is True.
    ///</summary>
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use LegendEntry.BackgroundMode property.
    ///  This property will be removed 12 months later since JANUARY 2012.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property Background: DNBackgroundMode read get_Background write set_Background;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
  end;

  TDNLegendEntry = class(TDNGenericImport<DNLegendEntryClass, DNLegendEntry>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNMarkerClass = interface(DDN.mscorlib.DNObjectClass)
  ['{F5C1A4D5-D409-5D9A-93FC-D974ED00C66B}']
  end;

  ///<summary>
  ///  Represents the marker in a line chart, scatter chart, or radar chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.Marker')]
  DNMarker = interface(DDN.mscorlib.DNObject)
  ['{30CF5F99-601B-3C15-B3EB-E8AD99A89AD1}']
  { getters & setters } 

    function get_Border: DNLine;
    function get_Area: DNArea;
    function get_MarkerStyle: DNChartMarkerType;
    procedure set_MarkerStyle(value: DNChartMarkerType);
    function get_MarkerSize: Int32;
    procedure set_MarkerSize(value: Int32);
    function get_MarkerSizePx: Int32;
    procedure set_MarkerSizePx(value: Int32);
    function get_ForegroundColor: DDN.System.Drawing.DNColor;
    procedure set_ForegroundColor(value: DDN.System.Drawing.DNColor);
    function get_ForegroundColorSetType: DNFormattingType;
    procedure set_ForegroundColorSetType(value: DNFormattingType);
    function get_BackgroundColor: DDN.System.Drawing.DNColor;
    procedure set_BackgroundColor(value: DDN.System.Drawing.DNColor);
    function get_BackgroundColorSetType: DNFormattingType;
    procedure set_BackgroundColorSetType(value: DNFormattingType);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Drawing.Line">border</see>.
    ///</summary>
    property Border: DNLine read get_Border;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.Marker.Area">area</see>.
    ///</summary>
    property Area: DNArea read get_Area;
    ///<summary>
    ///  Represents the marker style. Applies to line chart, scatter chart, or radar chart.
    ///</summary>
    property MarkerStyle: DNChartMarkerType read get_MarkerStyle write set_MarkerStyle;
    ///<summary>
    ///  Represents the marker size in unit of points. Applies to line chart, scatter chart, or radar chart.
    ///</summary>
    property MarkerSize: Int32 read get_MarkerSize write set_MarkerSize;
    ///<summary>
    ///  Represents the marker size in unit of pixels. Applies to line chart, scatter chart, or radar chart.
    ///</summary>
    property MarkerSizePx: Int32 read get_MarkerSizePx write set_MarkerSizePx;
    ///<summary>
    ///  Represents the marker foreground color in a line chart, scatter chart, or radar chart.
    ///</summary>
    property ForegroundColor: DDN.System.Drawing.DNColor read get_ForegroundColor write set_ForegroundColor;
    ///<summary>
    ///  Gets or sets the marker foreground color set type.
    ///</summary>
    property ForegroundColorSetType: DNFormattingType read get_ForegroundColorSetType write set_ForegroundColorSetType;
    ///<summary>
    ///  Represents the marker background color in a line chart, scatter chart, or radar chart.
    ///</summary>
    property BackgroundColor: DDN.System.Drawing.DNColor read get_BackgroundColor write set_BackgroundColor;
    ///<summary>
    ///  Gets or sets the marker background color set type.
    ///</summary>
    property BackgroundColorSetType: DNFormattingType read get_BackgroundColorSetType write set_BackgroundColorSetType;
  end;

  TDNMarker = class(TDNGenericImport<DNMarkerClass, DNMarker>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNPivotOptionsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{E194FD1D-30ED-5A36-93EC-28F9427EDE3D}']
  end;

  ///<summary>
  ///  Represents a complex type that specifies the pivot controls that appear on the chart
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.PivotOptions')]
  DNPivotOptions = interface(DDN.mscorlib.DNObject)
  ['{85D02D1B-9FBD-37E0-8DA1-F1D75A9ED19B}']
  { getters & setters } 

    function get_DropZoneFilter: Boolean;
    procedure set_DropZoneFilter(value: Boolean);
    function get_DropZoneCategories: Boolean;
    procedure set_DropZoneCategories(value: Boolean);
    function get_DropZoneData: Boolean;
    procedure set_DropZoneData(value: Boolean);
    function get_DropZoneSeries: Boolean;
    procedure set_DropZoneSeries(value: Boolean);
    function get_DropZonesVisible: Boolean;
    procedure set_DropZonesVisible(value: Boolean);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Specifies whether a control for each PivotTable field on the PivotTable page axis
    ///  of the source PivotTable appears on the chart when dropZonesVisible is set to true.
    ///</summary>
    property DropZoneFilter: Boolean read get_DropZoneFilter write set_DropZoneFilter;
    ///<summary>
    ///  Specifies whether a control for each PivotTable field on the PivotTable row axis
    ///  of the source PivotTable appears on the chart when dropZonesVisible is set to true.
    ///</summary>
    property DropZoneCategories: Boolean read get_DropZoneCategories write set_DropZoneCategories;
    ///<summary>
    ///  Specifies whether a control for each PivotTable field on the PivotTable data axis
    ///  of the source PivotTable appears on the chart when dropZonesVisible is set to true.
    ///</summary>
    property DropZoneData: Boolean read get_DropZoneData write set_DropZoneData;
    ///<summary>
    ///  Specifies whether a control for each PivotTable field on the PivotTable column axis
    ///  of the source PivotTable appears on the chart when dropZonesVisible is set to true.
    ///</summary>
    property DropZoneSeries: Boolean read get_DropZoneSeries write set_DropZoneSeries;
    ///<summary>
    ///  Specifies whether any pivot controls can appear on the pivot chart.
    ///</summary>
    property DropZonesVisible: Boolean read get_DropZonesVisible write set_DropZonesVisible;
  end;

  TDNPivotOptions = class(TDNGenericImport<DNPivotOptionsClass, DNPivotOptions>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNSeriesClass = interface(DDN.mscorlib.DNObjectClass)
  ['{12FB4714-DEFD-5ECB-A9AB-204A3BBB61D4}']
  end;

  ///<summary>
  ///  Encapsulates the object that represents a single data series in a chart.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Adding a new worksheet to the Excel object
  ///  int sheetIndex = workbook.Worksheets.Add();
  ///  //Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Worksheet worksheet = workbook.Worksheets[sheetIndex];
  ///  //Adding a sample value to "A1" cell
  ///  worksheet.Cells["A1"].PutValue(50);
  ///  //Adding a sample value to "A2" cell
  ///  worksheet.Cells["A2"].PutValue(100);
  ///  //Adding a sample value to "A3" cell
  ///  worksheet.Cells["A3"].PutValue(150);
  ///  //Adding a sample value to "A4" cell
  ///  worksheet.Cells["A4"].PutValue(200);
  ///  //Adding a sample value to "B1" cell
  ///  worksheet.Cells["B1"].PutValue(60);
  ///  //Adding a sample value to "B2" cell
  ///  worksheet.Cells["B2"].PutValue(32);
  ///  //Adding a sample value to "B3" cell
  ///  worksheet.Cells["B3"].PutValue(50);
  ///  //Adding a sample value to "B4" cell
  ///  worksheet.Cells["B4"].PutValue(40);
  ///  //Adding a sample value to "C1" cell as category data
  ///  worksheet.Cells["C1"].PutValue("Q1");
  ///  //Adding a sample value to "C2" cell as category data
  ///  worksheet.Cells["C2"].PutValue("Q2");
  ///  //Adding a sample value to "C3" cell as category data
  ///  worksheet.Cells["C3"].PutValue("Y1");
  ///  //Adding a sample value to "C4" cell as category data
  ///  worksheet.Cells["C4"].PutValue("Y2");
  ///  //Adding a chart to the worksheet
  ///  int chartIndex = worksheet.Charts.Add(ChartType.Column, 5, 0, 15, 5);
  ///  //Accessing the instance of the newly added chart
  ///  Chart chart = worksheet.Charts[chartIndex];
  ///  //Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B4"
  ///  chart.NSeries.Add("A1:B4", true);
  ///  //Setting the data source for the category data of NSeries
  ///  chart.NSeries.CategoryData = "C1:C4";
  ///  Series series = chart.NSeries[1];
  ///  //Setting the values of the series.
  ///  series.Values = "=B1:B4";
  ///  //Changing the chart type of the series.
  ///  series.Type = ChartType.Line;
  ///  //Setting marker properties.
  ///  series.MarkerStyle = ChartMarkerType.Circle;
  ///  series.MarkerForegroundColorSetType = FormattingType.Automatic;
  ///  series.MarkerForegroundColor = System.Drawing.Color.Black;
  ///  series.MarkerBackgroundColorSetType = FormattingType.Automatic;
  ///  //Saving the Excel file
  ///  workbook.Save("C:\\book1.xls");
  ///  [Visual Basic]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As Workbook = New Workbook()
  ///  'Adding a new worksheet to the Excel object
  ///  Dim sheetIndex As Int32 = workbook.Worksheets.Add()
  ///  'Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Dim worksheet As Worksheet = workbook.Worksheets(sheetIndex)
  ///  'Adding a sample value to "A1" cell
  ///  worksheet.Cells("A1").PutValue(50)
  ///  'Adding a sample value to "A2" cell
  ///  worksheet.Cells("A2").PutValue(100)
  ///  'Adding a sample value to "A3" cell
  ///  worksheet.Cells("A3").PutValue(150)
  ///  'Adding a sample value to "A4" cell
  ///  worksheet.Cells("A4").PutValue(200)
  ///  'Adding a sample value to "B1" cell
  ///  worksheet.Cells("B1").PutValue(60)
  ///  'Adding a sample value to "B2" cell
  ///  worksheet.Cells("B2").PutValue(32)
  ///  'Adding a sample value to "B3" cell
  ///  worksheet.Cells("B3").PutValue(50)
  ///  'Adding a sample value to "B4" cell
  ///  worksheet.Cells("B4").PutValue(40)
  ///  'Adding a sample value to "C1" cell as category data
  ///  worksheet.Cells("C1").PutValue("Q1")
  ///  'Adding a sample value to "C2" cell as category data
  ///  worksheet.Cells("C2").PutValue("Q2")
  ///  'Adding a sample value to "C3" cell as category data
  ///  worksheet.Cells("C3").PutValue("Y1")
  ///  'Adding a sample value to "C4" cell as category data
  ///  worksheet.Cells("C4").PutValue("Y2")
  ///  'Adding a chart to the worksheet
  ///  Dim chartIndex As Int32 = worksheet.Charts.Add(ChartType.Column, 5, 0, 15, 5)
  ///  'Accessing the instance of the newly added chart
  ///  Dim chart As Chart = worksheet.Charts(chartIndex)
  ///  'Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B4"
  ///  chart.NSeries.Add("A1:B4", True)
  ///  'Setting the data source for the category data of NSeries
  ///  chart.NSeries.CategoryData = "C1:C4"
  ///  Dim series As Series = chart.NSeries(1)
  ///  'Setting the values of the series.
  ///  series.Values = "=B1:B4"
  ///  'Changing the chart type of the series.
  ///  series.Type = ChartType.Line
  ///  'Setting marker properties.
  ///  series.MarkerStyle = ChartMarkerType.Circle
  ///  series.MarkerForegroundColorSetType = FormattingType.Automatic
  ///  series.MarkerForegroundColor = System.Drawing.Color.Black
  ///  series.MarkerBackgroundColorSetType = FormattingType.Automatic
  ///  'Saving the Excel file
  ///  workbook.Save("C:\\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.Series')]
  DNSeries = interface(DDN.mscorlib.DNObject)
  ['{4EC1D8B0-F78B-3C00-9C29-E2469456F303}']
  { getters & setters } 

    function get_LayoutProperties: DNSeriesLayoutProperties;
    function get_Points: DNChartPointCollection;
    function get_Area: DNArea;
    function get_Border: DNLine;
    function get_Name: string;
    procedure set_Name(value: string);
    function get_DisplayName: string;
    function get_CountOfDataValues: Int32;
    function get_IsVerticalValues: Boolean;
    function get_Values: string;
    procedure set_Values(value: string);
    function get_ValuesFormatCode: string;
    procedure set_ValuesFormatCode(value: string);
    function get_XValues: string;
    procedure set_XValues(value: string);
    function get_BubbleSizes: string;
    procedure set_BubbleSizes(value: string);
    function get_TrendLines: DNTrendlineCollection;
    function get_Smooth: Boolean;
    procedure set_Smooth(value: Boolean);
    function get_Shadow: Boolean;
    procedure set_Shadow(value: Boolean);
    function get_Has3DEffect: Boolean;
    procedure set_Has3DEffect(value: Boolean);
    function get_Bar3DShapeType: DNBar3DShapeType;
    procedure set_Bar3DShapeType(value: DNBar3DShapeType);
    function get_BarShape: DNBar3DShapeType;
    procedure set_BarShape(value: DNBar3DShapeType);
    function get_DataLabels: DNDataLabels;
    function get_Type: DNChartType;
    procedure set_Type(value: DNChartType);
    function get_Marker: DNMarker;
    function get_PlotOnSecondAxis: Boolean;
    procedure set_PlotOnSecondAxis(value: Boolean);
    function get_XErrorBar: DNErrorBar;
    function get_YErrorBar: DNErrorBar;
    function get_HasHiLoLines: Boolean;
    procedure set_HasHiLoLines(value: Boolean);
    function get_HiLoLines: DNLine;
    function get_HasSeriesLines: Boolean;
    procedure set_HasSeriesLines(value: Boolean);
    function get_SeriesLines: DNLine;
    function get_HasDropLines: Boolean;
    procedure set_HasDropLines(value: Boolean);
    function get_DropLines: DNLine;
    function get_HasUpDownBars: Boolean;
    procedure set_HasUpDownBars(value: Boolean);
    function get_UpBars: DNDropBars;
    function get_DownBars: DNDropBars;
    function get_IsColorVaried: Boolean;
    procedure set_IsColorVaried(value: Boolean);
    function get_GapWidth: Int16;
    procedure set_GapWidth(value: Int16);
    function get_FirstSliceAngle: Int16;
    procedure set_FirstSliceAngle(value: Int16);
    function get_Overlap: Int16;
    procedure set_Overlap(value: Int16);
    function get_SecondPlotSize: Int16;
    procedure set_SecondPlotSize(value: Int16);
    function get_SplitType: DNChartSplitType;
    procedure set_SplitType(value: DNChartSplitType);
    function get_SplitValue: Double;
    procedure set_SplitValue(value: Double);
    function get_IsAutoSplit: Boolean;
    function get_BubbleScale: Int32;
    procedure set_BubbleScale(value: Int32);
    function get_SizeRepresents: DNBubbleSizeRepresents;
    procedure set_SizeRepresents(value: DNBubbleSizeRepresents);
    function get_ShowNegativeBubbles: Boolean;
    procedure set_ShowNegativeBubbles(value: Boolean);
    function get_DoughnutHoleSize: Int32;
    procedure set_DoughnutHoleSize(value: Int32);
    function get_Explosion: Int32;
    procedure set_Explosion(value: Int32);
    function get_HasRadarAxisLabels: Boolean;
    procedure set_HasRadarAxisLabels(value: Boolean);
    function get_HasLeaderLines: Boolean;
    procedure set_HasLeaderLines(value: Boolean);
    function get_LeaderLines: DNLine;
    function get_LegendEntry: DNLegendEntry;
    function get_ShapeProperties: DNShapePropertyCollection;

  { methods } 

    ///<summary>
    ///  Moves the series up or down.
    ///</summary>
    ///  <param name="count">The number of moving up or down.
    ///  Move the series up if this is less than zero;
    ///  Move the series down if this is greater than zero.
    ///</param>
    procedure Move(count: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Represents the properties of layout.
    ///</summary>
    property LayoutProperties: DNSeriesLayoutProperties read get_LayoutProperties;
    ///<summary>
    ///  Gets the collection of points in a series in a chart.
    ///</summary>
    ///<remarks>
    ///  When the chart is Pie of Pie or Bar of Pie, the last point is other point in first pie plot.
    ///</remarks>
    property Points: DNChartPointCollection read get_Points;
    ///<summary>
    ///  Represents the background area of Series object.
    ///</summary>
    property Area: DNArea read get_Area;
    ///<summary>
    ///  Represents border of Series object.
    ///</summary>
    property Border: DNLine read get_Border;
    ///<summary>
    ///  Gets or sets the name of the data series.
    ///</summary>
    ///<example><code>
    ///  [C#]
    ///  //Reference name to a cell
    ///  chart.NSeries[0].Name = "=A1";
    ///  //Set a string to name
    ///  chart.NSeries[0].Name = "First Series";
    ///  [Visual Basic]
    ///  'Reference name to a cell
    ///  chart.NSeries[0].Name = "=A1"
    ///  'Set a string to name
    ///  chart.NSeries[0].Name = "First Series"
    ///</code></example>
    property Name: string read get_Name write set_Name;
    ///<summary>
    ///  Gets the series's name that displays on the chart graph.
    ///</summary>
    property DisplayName: string read get_DisplayName;
    ///<summary>
    ///  Gets the number of the data values.
    ///</summary>
    property CountOfDataValues: Int32 read get_CountOfDataValues;
    ///<summary>
    ///  Indicates whether the data source is vertical.
    ///</summary>
    property IsVerticalValues: Boolean read get_IsVerticalValues;
    ///<summary>
    ///  Represents the data of the chart series.
    ///</summary>
    property Values: string read get_Values write set_Values;
    ///<summary>
    ///  Represents format code of Values¡®s NumberList.
    ///</summary>
    property ValuesFormatCode: string read get_ValuesFormatCode write set_ValuesFormatCode;
    ///<summary>
    ///  Represents the x values of the chart series.
    ///</summary>
    property XValues: string read get_XValues write set_XValues;
    ///<summary>
    ///  Gets or sets the bubble sizes values of the chart series.
    ///</summary>
    property BubbleSizes: string read get_BubbleSizes write set_BubbleSizes;
    ///<summary>
    ///  Returns an object that represents a collection of all the trendlines for the series.
    ///</summary>
    property TrendLines: DNTrendlineCollection read get_TrendLines;
    ///<summary>
    ///  Represents curve smoothing.
    ///  True if curve smoothing is turned on for the line chart or scatter chart.
    ///  Applies only to line and scatter connected by lines charts.
    ///</summary>
    property Smooth: Boolean read get_Smooth write set_Smooth;
    ///<summary>
    ///  True if the series has a shadow.
    ///</summary>
    property Shadow: Boolean read get_Shadow write set_Shadow;
    ///<summary>
    ///  True if the series has a three-dimensional appearance.
    ///  Applies only to bubble charts.
    ///</summary>
    property Has3DEffect: Boolean read get_Has3DEffect write set_Has3DEffect;
    ///<summary>
    ///  Gets or sets the 3D shape type used with the 3-D bar or column chart.
    ///</summary>
    property Bar3DShapeType: DNBar3DShapeType read get_Bar3DShapeType write set_Bar3DShapeType;
    ///<summary>
    ///  Gets or sets the 3D shape type used with the 3-D bar or column chart.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use ASeries.Bar3DShapeType property.
    ///  This property will be removed 12 months later since June 2010.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property BarShape: DNBar3DShapeType read get_BarShape write set_BarShape;
    ///<summary>
    ///  Represents the DataLabels object for the specified ASeries.
    ///</summary>
    property DataLabels: DNDataLabels read get_DataLabels;
    ///<summary>
    ///  Gets or sets a data series' type.
    ///</summary>
    property &Type: DNChartType read get_Type write set_Type;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.Series.Marker">marker</see>.
    ///</summary>
    property Marker: DNMarker read get_Marker;
    ///<summary>
    ///  Indicates if this series is plotted on second value axis.
    ///</summary>
    property PlotOnSecondAxis: Boolean read get_PlotOnSecondAxis write set_PlotOnSecondAxis;
    ///<summary>
    ///  Represents X direction error bar of the series.
    ///</summary>
    property XErrorBar: DNErrorBar read get_XErrorBar;
    ///<summary>
    ///  Represents Y direction error bar of the series.
    ///</summary>
    property YErrorBar: DNErrorBar read get_YErrorBar;
    ///<summary>
    ///  True if the line chart has high-low lines.
    ///  Applies only to line charts.
    ///</summary>
    property HasHiLoLines: Boolean read get_HasHiLoLines write set_HasHiLoLines;
    ///<summary>
    ///  Returns a HiLoLines object that represents the high-low lines for a series on a line chart.
    ///  Applies only to line charts.
    ///</summary>
    property HiLoLines: DNLine read get_HiLoLines;
    ///<summary>
    ///  True if a stacked column chart or bar chart has series lines or
    ///  if a Pie of Pie chart or Bar of Pie chart has connector lines between the two sections.
    ///  Applies only to stacked column charts, bar charts, Pie of Pie charts, or Bar of Pie charts.
    ///</summary>
    property HasSeriesLines: Boolean read get_HasSeriesLines write set_HasSeriesLines;
    ///<summary>
    ///  Returns a SeriesLines object that represents the series lines for a stacked bar chart or a stacked column chart.
    ///  Applies only to stacked bar and stacked column charts.
    ///</summary>
    property SeriesLines: DNLine read get_SeriesLines;
    ///<summary>
    ///  True if the chart has drop lines.
    ///  Applies only to line chart or area charts.
    ///</summary>
    property HasDropLines: Boolean read get_HasDropLines write set_HasDropLines;
    ///<summary>
    ///  Returns a <see cref="T:Aspose.Cells.Drawing.Line" />
    ///  object that represents the drop lines for a series on the line chart or area chart.
    ///  Applies only to line chart or area charts.
    ///</summary>
    property DropLines: DNLine read get_DropLines;
    ///<summary>
    ///  True if a line chart has up and down bars.
    ///  Applies only to line charts.
    ///</summary>
    property HasUpDownBars: Boolean read get_HasUpDownBars write set_HasUpDownBars;
    ///<summary>
    ///  Returns an DropBars object that represents the up bars on a line chart.
    ///  Applies only to line charts.
    ///</summary>
    property UpBars: DNDropBars read get_UpBars;
    ///<summary>
    ///  Returns a <see cref="T:Aspose.Cells.Charts.DropBars" />
    ///  object that represents the down bars on a line chart.
    ///  Applies only to line charts.
    ///</summary>
    property DownBars: DNDropBars read get_DownBars;
    ///<summary>
    ///  Represents if the color of points is varied.
    ///  The chart must contain only one series.
    ///</summary>
    property IsColorVaried: Boolean read get_IsColorVaried write set_IsColorVaried;
    ///<summary>
    ///  Returns or sets the space between bar or column clusters, as a percentage of the bar or column width.
    ///  The value of this property must be between 0 and 500.
    ///</summary>
    property GapWidth: Int16 read get_GapWidth write set_GapWidth;
    ///<summary>
    ///  Gets or sets the angle of the first pie-chart or doughnut-chart slice, in degrees (clockwise from vertical).
    ///  Applies only to pie, 3-D pie, and doughnut charts, 0 to 360.
    ///</summary>
    property FirstSliceAngle: Int16 read get_FirstSliceAngle write set_FirstSliceAngle;
    ///<summary>
    ///  Specifies how bars and columns are positioned.
    ///  Can be a value between ¨C 100 and 100.
    ///  Applies only to 2-D bar and 2-D column charts.
    ///</summary>
    property Overlap: Int16 read get_Overlap write set_Overlap;
    ///<summary>
    ///  Returns or sets the size of the secondary section of either a pie of pie chart or a bar of pie chart,
    ///  as a percentage of the size of the primary pie.
    ///  Can be a value from 5 to 200.
    ///</summary>
    property SecondPlotSize: Int16 read get_SecondPlotSize write set_SecondPlotSize;
    ///<summary>
    ///  Returns or sets a value that how to determine which data points are in the second pie or bar on a pie of pie or bar of
    ///  pie chart.
    ///</summary>
    property SplitType: DNChartSplitType read get_SplitType write set_SplitType;
    ///<summary>
    ///  Returns or sets a value that shall be used to determine which data points are in the second pie or bar on
    ///  a pie of pie or bar of pie chart.
    ///</summary>
    property SplitValue: Double read get_SplitValue write set_SplitValue;
    ///<summary>
    ///  Indicates whether the threshold value is automatic.
    ///</summary>
    property IsAutoSplit: Boolean read get_IsAutoSplit;
    ///<summary>
    ///  Gets or sets the scale factor for bubbles in the specified chart group.
    ///  It can be an integer value from 0 (zero) to 300,
    ///  corresponding to a percentage of the default size.
    ///  Applies only to bubble charts.
    ///</summary>
    property BubbleScale: Int32 read get_BubbleScale write set_BubbleScale;
    ///<summary>
    ///  Gets or sets what the bubble size represents on a bubble chart.
    ///</summary>
    ///<remarks>
    ///  BubbleSizeRepresents.SizeIsArea means the value <see cref="P:Aspose.Cells.Charts.Series.BubbleSizes" />
    ///  is the area of the bubble.
    ///  BubbleSizeRepresents.SizeIsWidth means the value <see cref="P:Aspose.Cells.Charts.Series.BubbleSizes" />
    ///  is the width of the bubble.
    ///</remarks>
    property SizeRepresents: DNBubbleSizeRepresents read get_SizeRepresents write set_SizeRepresents;
    ///<summary>
    ///  True if negative bubbles are shown for the chart group. Valid only for bubble charts.
    ///</summary>
    property ShowNegativeBubbles: Boolean read get_ShowNegativeBubbles write set_ShowNegativeBubbles;
    ///<summary>
    ///  Returns or sets the size of the hole in a doughnut chart group.
    ///  The hole size is expressed as a percentage of the chart size, between 10 and 90 percent.
    ///</summary>
    property DoughnutHoleSize: Int32 read get_DoughnutHoleSize write set_DoughnutHoleSize;
    ///<summary>
    ///  The distance of an open pie slice from the center of the pie chart is expressed as a percentage of the pie diameter.
    ///</summary>
    property Explosion: Int32 read get_Explosion write set_Explosion;
    ///<summary>
    ///  True if a radar chart has category axis labels. Applies only to radar charts.
    ///</summary>
    property HasRadarAxisLabels: Boolean read get_HasRadarAxisLabels write set_HasRadarAxisLabels;
    ///<summary>
    ///  True if the series has leader lines.
    ///</summary>
    property HasLeaderLines: Boolean read get_HasLeaderLines write set_HasLeaderLines;
    ///<summary>
    ///  Represents leader lines on a chart. Leader lines connect data labels to data points.
    ///  This object isn¡¯t a collection; there¡¯s no object that represents a single leader line.
    ///</summary>
    property LeaderLines: DNLine read get_LeaderLines;
    ///<summary>
    ///  Gets the legend entry according to this series.
    ///</summary>
    property LegendEntry: DNLegendEntry read get_LegendEntry;
    ///<summary>
    ///  Gets the <seealso cref="T:Aspose.Cells.Drawing.ShapePropertyCollection" />
    ///  object that holds the visual shape properties of the Series.
    ///</summary>
    property ShapeProperties: DNShapePropertyCollection read get_ShapeProperties;
  end;

  TDNSeries = class(TDNGenericImport<DNSeriesClass, DNSeries>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNSeriesLayoutPropertiesClass = interface(DDN.mscorlib.DNObjectClass)
  ['{E1949A15-32B9-5BF8-8979-1EE63F4A7B8F}']
  { constructors } 

    {class} function init: DNSeriesLayoutProperties;

  end;

  ///<summary></summary>
  [DNTypeName('Aspose.Cells.Charts.SeriesLayoutProperties')]
  DNSeriesLayoutProperties = interface(DDN.mscorlib.DNObject)
  ['{4951B904-79D7-3215-AC07-0FA1797E6717}']
  { getters & setters } 

    function get_ShowConnectorLines: Boolean;
    procedure set_ShowConnectorLines(value: Boolean);
    function get_ShowMeanLine: Boolean;
    procedure set_ShowMeanLine(value: Boolean);
    function get_ShowOutlierPoints: Boolean;
    procedure set_ShowOutlierPoints(value: Boolean);
    function get_ShowMeanMarker: Boolean;
    procedure set_ShowMeanMarker(value: Boolean);
    function get_ShowInnerPoints: Boolean;
    procedure set_ShowInnerPoints(value: Boolean);
    function get_Subtotals: TArray<Int32>;
    procedure set_Subtotals(value: TArray<Int32>);
    function get_QuartileCalculation: DNQuartileCalculationType;
    procedure set_QuartileCalculation(value: DNQuartileCalculationType);
    function get_MapLabelLayout: DNMapChartLabelLayout;
    procedure set_MapLabelLayout(value: DNMapChartLabelLayout);
    function get_MapChartRegionType: DNMapChartRegionType;
    procedure set_MapChartRegionType(value: DNMapChartRegionType);
    function get_MapChartProjectionType: DNMapChartProjectionType;
    procedure set_MapChartProjectionType(value: DNMapChartProjectionType);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Indicates whether showing connector lines between data points.
    ///</summary>
    property ShowConnectorLines: Boolean read get_ShowConnectorLines write set_ShowConnectorLines;
    ///<summary>
    ///  Indicates whether showing the line connecting all mean points.
    ///</summary>
    property ShowMeanLine: Boolean read get_ShowMeanLine write set_ShowMeanLine;
    ///<summary>
    ///  Indicates whether showing outlier data points.
    ///</summary>
    property ShowOutlierPoints: Boolean read get_ShowOutlierPoints write set_ShowOutlierPoints;
    ///<summary>
    ///  Indicates whether showing markers denoting the mean.
    ///</summary>
    property ShowMeanMarker: Boolean read get_ShowMeanMarker write set_ShowMeanMarker;
    ///<summary>
    ///  Indicates whether showing non-outlier data points.
    ///</summary>
    property ShowInnerPoints: Boolean read get_ShowInnerPoints write set_ShowInnerPoints;
    ///<summary>
    ///  Represents the index of a subtotal data point.
    ///</summary>
    property Subtotals: TArray<Int32> read get_Subtotals write set_Subtotals;
    ///<summary>
    ///  Represents the statistical properties for the series.
    ///</summary>
    property QuartileCalculation: DNQuartileCalculationType read get_QuartileCalculation write set_QuartileCalculation;
    ///<summary>
    ///  Gets and sets the layout of map labels.
    ///</summary>
    property MapLabelLayout: DNMapChartLabelLayout read get_MapLabelLayout write set_MapLabelLayout;
    ///<summary>
    ///  Gets and sets the region type of the map.
    ///</summary>
    property MapChartRegionType: DNMapChartRegionType read get_MapChartRegionType write set_MapChartRegionType;
    ///<summary>
    ///  Gets and sets the projection type of the map.
    ///</summary>
    property MapChartProjectionType: DNMapChartProjectionType read get_MapChartProjectionType write set_MapChartProjectionType;
  end;

  TDNSeriesLayoutProperties = class(TDNGenericImport<DNSeriesLayoutPropertiesClass, DNSeriesLayoutProperties>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNSparklineClass = interface(DDN.mscorlib.DNObjectClass)
  ['{572878A1-67C9-5BE4-B000-7985DCDFC76D}']
  end;

  ///<summary>
  ///  A sparkline represents a tiny chart or graphic in a worksheet cell that provides a visual representation of data.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.Sparkline')]
  DNSparkline = interface(DDN.mscorlib.DNObject)
  ['{46B7A2CC-38AD-3682-88F2-4F1A7DF7FCBA}']
  { getters & setters } 

    function get_DataRange: string;
    procedure set_DataRange(value: string);
    function get_Row: Int32;
    function get_Column: Int32;

  { methods } 

    ///<summary>
    ///  Converts a sparkline to an image.
    ///</summary>
    ///  <param name="options">The image options</param>
    ///<returns>Returns a <see cref="T:System.Drawing.Bitmap" />
    ///  object.</returns>
    function ToImage(options: DNImageOrPrintOptions): DDN.System.Drawing.DNBitmap; overload;
    ///<summary>
    ///  Converts a sparkline to an image.
    ///</summary>
    ///  <param name="fileName">The image file name.</param>
    ///  <param name="options">The image options</param>
    procedure ToImage(fileName: string; options: DNImageOrPrintOptions); overload;
    ///<summary>
    ///  Converts a sparkline to an image.
    ///</summary>
    ///  <param name="stream">The image stream.</param>
    ///  <param name="options">The image options.</param>
    procedure ToImage(stream: DDN.mscorlib.DNStream; options: DNImageOrPrintOptions); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Represents the data range of the sparkline.
    ///</summary>
    property DataRange: string read get_DataRange write set_DataRange;
    ///<summary>
    ///  Gets the row index of the sparkline.
    ///</summary>
    property Row: Int32 read get_Row;
    ///<summary>
    ///  Gets the column index of the sparkline.
    ///</summary>
    property Column: Int32 read get_Column;
  end;

  TDNSparkline = class(TDNGenericImport<DNSparklineClass, DNSparkline>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNSparklineGroupClass = interface(DDN.mscorlib.DNObjectClass)
  ['{A319D14D-1702-5F09-89D1-0CFBC3684CCA}']
  end;

  ///<summary><see cref="T:Aspose.Cells.Charts.Sparkline" />
  ///  is organized into sparkline group. A SparklineGroup contains a variable number of sparkline items.
  ///  A sparkline group specifies the type, display settings and axis settings for the sparklines.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.SparklineGroup')]
  DNSparklineGroup = interface(DDN.mscorlib.DNObject)
  ['{FC886C33-6B36-3589-AA9D-65F715A75911}']
  { getters & setters } 

    function get_PresetStyle: DNSparklinePresetStyleType;
    procedure set_PresetStyle(value: DNSparklinePresetStyleType);
    function get_SparklineCollection: DNSparklineCollection;
    function get_Type: DNSparklineType;
    procedure set_Type(value: DNSparklineType);
    function get_PlotEmptyCellsType: DNPlotEmptyCellsType;
    procedure set_PlotEmptyCellsType(value: DNPlotEmptyCellsType);
    function get_DisplayHidden: Boolean;
    procedure set_DisplayHidden(value: Boolean);
    function get_ShowHighPoint: Boolean;
    procedure set_ShowHighPoint(value: Boolean);
    function get_HighPointColor: DNCellsColor;
    procedure set_HighPointColor(value: DNCellsColor);
    function get_ShowLowPoint: Boolean;
    procedure set_ShowLowPoint(value: Boolean);
    function get_LowPointColor: DNCellsColor;
    procedure set_LowPointColor(value: DNCellsColor);
    function get_ShowNegativePoints: Boolean;
    procedure set_ShowNegativePoints(value: Boolean);
    function get_NegativePointsColor: DNCellsColor;
    procedure set_NegativePointsColor(value: DNCellsColor);
    function get_ShowFirstPoint: Boolean;
    procedure set_ShowFirstPoint(value: Boolean);
    function get_FirstPointColor: DNCellsColor;
    procedure set_FirstPointColor(value: DNCellsColor);
    function get_ShowLastPoint: Boolean;
    procedure set_ShowLastPoint(value: Boolean);
    function get_LastPointColor: DNCellsColor;
    procedure set_LastPointColor(value: DNCellsColor);
    function get_ShowMarkers: Boolean;
    procedure set_ShowMarkers(value: Boolean);
    function get_MarkersColor: DNCellsColor;
    procedure set_MarkersColor(value: DNCellsColor);
    function get_SeriesColor: DNCellsColor;
    procedure set_SeriesColor(value: DNCellsColor);
    function get_PlotRightToLeft: Boolean;
    procedure set_PlotRightToLeft(value: Boolean);
    function get_LineWeight: Double;
    procedure set_LineWeight(value: Double);
    function get_HorizontalAxisColor: DNCellsColor;
    procedure set_HorizontalAxisColor(value: DNCellsColor);
    function get_ShowHorizontalAxis: Boolean;
    procedure set_ShowHorizontalAxis(value: Boolean);
    function get_HorizontalAxisDateRange: string;
    procedure set_HorizontalAxisDateRange(value: string);
    function get_VerticalAxisMaxValueType: DNSparklineAxisMinMaxType;
    procedure set_VerticalAxisMaxValueType(value: DNSparklineAxisMinMaxType);
    function get_VerticalAxisMaxValue: Double;
    procedure set_VerticalAxisMaxValue(value: Double);
    function get_VerticalAxisMinValueType: DNSparklineAxisMinMaxType;
    procedure set_VerticalAxisMinValueType(value: DNSparklineAxisMinMaxType);
    function get_VerticalAxisMinValue: Double;
    procedure set_VerticalAxisMinValue(value: Double);

  { methods } 

    ///<summary>
    ///  Resets the data range and location range of the sparkline group.
    ///  This method will clear original sparkline items in the group and creates new sparkline items for the new ranges.
    ///</summary>
    ///  <param name="dataRange">Specifies the new data range of the sparkline group.</param>
    ///  <param name="isVertical">Specifies whether to plot the sparklines from the new data range by row or by column.</param>
    ///  <param name="locationRange">Specifies where the sparklines to be placed.</param>
    procedure ResetRanges(dataRange: string; isVertical: Boolean; locationRange: DNCellArea);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets and sets the preset style type of the sparkline group.
    ///</summary>
    property PresetStyle: DNSparklinePresetStyleType read get_PresetStyle write set_PresetStyle;
    ///<summary>
    ///  Gets the <see cref="P:Aspose.Cells.Charts.SparklineGroup.SparklineCollection" />
    ///  object of the sparkline group.
    ///</summary>
    property SparklineCollection: DNSparklineCollection read get_SparklineCollection;
    ///<summary>
    ///  Indicates the sparkline type of the sparkline group.
    ///</summary>
    property &Type: DNSparklineType read get_Type write set_Type;
    ///<summary>
    ///  Indicates how to plot empty cells.
    ///</summary>
    property PlotEmptyCellsType: DNPlotEmptyCellsType read get_PlotEmptyCellsType write set_PlotEmptyCellsType;
    ///<summary>
    ///  Indicates whether to show data in hidden rows and columns.
    ///</summary>
    property DisplayHidden: Boolean read get_DisplayHidden write set_DisplayHidden;
    ///<summary>
    ///  Indicates whether to highlight the highest points of data in the sparkline group.
    ///</summary>
    property ShowHighPoint: Boolean read get_ShowHighPoint write set_ShowHighPoint;
    ///<summary>
    ///  Gets and sets the color of the highest points of data in the sparkline group.
    ///</summary>
    property HighPointColor: DNCellsColor read get_HighPointColor write set_HighPointColor;
    ///<summary>
    ///  Indicates whether to highlight the lowest points of data in the sparkline group.
    ///</summary>
    property ShowLowPoint: Boolean read get_ShowLowPoint write set_ShowLowPoint;
    ///<summary>
    ///  Gets and sets the color of the lowest points of data in the sparkline group.
    ///</summary>
    property LowPointColor: DNCellsColor read get_LowPointColor write set_LowPointColor;
    ///<summary>
    ///  Indicates whether to highlight the negative values on the sparkline group with a different color or marker.
    ///</summary>
    property ShowNegativePoints: Boolean read get_ShowNegativePoints write set_ShowNegativePoints;
    ///<summary>
    ///  Gets and sets the color of the negative values on the sparkline group.
    ///</summary>
    property NegativePointsColor: DNCellsColor read get_NegativePointsColor write set_NegativePointsColor;
    ///<summary>
    ///  Indicates whether to highlight the first point of data in the sparkline group.
    ///</summary>
    property ShowFirstPoint: Boolean read get_ShowFirstPoint write set_ShowFirstPoint;
    ///<summary>
    ///  Gets and sets the color of the first point of data in the sparkline group.
    ///</summary>
    property FirstPointColor: DNCellsColor read get_FirstPointColor write set_FirstPointColor;
    ///<summary>
    ///  Indicates whether to highlight the last point of data in the sparkline group.
    ///</summary>
    property ShowLastPoint: Boolean read get_ShowLastPoint write set_ShowLastPoint;
    ///<summary>
    ///  Gets and sets the color of the last point of data in the sparkline group.
    ///</summary>
    property LastPointColor: DNCellsColor read get_LastPointColor write set_LastPointColor;
    ///<summary>
    ///  Indicates whether to highlight each point in each line sparkline in the sparkline group.
    ///</summary>
    property ShowMarkers: Boolean read get_ShowMarkers write set_ShowMarkers;
    ///<summary>
    ///  Gets and sets the color of points in each line sparkline in the sparkline group.
    ///</summary>
    property MarkersColor: DNCellsColor read get_MarkersColor write set_MarkersColor;
    ///<summary>
    ///  Gets and sets the color of the sparklines in the sparkline group.
    ///</summary>
    property SeriesColor: DNCellsColor read get_SeriesColor write set_SeriesColor;
    ///<summary>
    ///  Indicates whether the plot data is right to left.
    ///</summary>
    property PlotRightToLeft: Boolean read get_PlotRightToLeft write set_PlotRightToLeft;
    ///<summary>
    ///  Gets and sets the line weight in each line sparkline in the sparkline group, in the unit of points.
    ///</summary>
    property LineWeight: Double read get_LineWeight write set_LineWeight;
    ///<summary>
    ///  Gets and sets the color of the horizontal axis in the sparkline group.
    ///</summary>
    property HorizontalAxisColor: DNCellsColor read get_HorizontalAxisColor write set_HorizontalAxisColor;
    ///<summary>
    ///  Indicates whether to show the sparkline horizontal axis.
    ///  The horizontal axis appears if the sparkline has data that crosses the zero axis.
    ///</summary>
    property ShowHorizontalAxis: Boolean read get_ShowHorizontalAxis write set_ShowHorizontalAxis;
    ///<summary>
    ///  Represents the range that contains the date values for the sparkline data.
    ///</summary>
    property HorizontalAxisDateRange: string read get_HorizontalAxisDateRange write set_HorizontalAxisDateRange;
    ///<summary>
    ///  Represents the vertical axis maximum value type.
    ///</summary>
    property VerticalAxisMaxValueType: DNSparklineAxisMinMaxType read get_VerticalAxisMaxValueType write set_VerticalAxisMaxValueType;
    ///<summary>
    ///  Gets and sets the custom maximum value for the vertical axis.
    ///</summary>
    property VerticalAxisMaxValue: Double read get_VerticalAxisMaxValue write set_VerticalAxisMaxValue;
    ///<summary>
    ///  Represents the vertical axis minimum value type.
    ///</summary>
    property VerticalAxisMinValueType: DNSparklineAxisMinMaxType read get_VerticalAxisMinValueType write set_VerticalAxisMinValueType;
    ///<summary>
    ///  Gets and sets the custom minimum value for the vertical axis.
    ///</summary>
    property VerticalAxisMinValue: Double read get_VerticalAxisMinValue write set_VerticalAxisMinValue;
  end;

  TDNSparklineGroup = class(TDNGenericImport<DNSparklineGroupClass, DNSparklineGroup>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNTickLabelsClass = interface(DDN.mscorlib.DNObjectClass)
  ['{177F5E5C-DB79-5084-8459-A7EE5A9B940C}']
  end;

  ///<summary>
  ///  Represents the tick-mark labels associated with tick marks on a chart axis.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.TickLabels')]
  DNTickLabels = interface(DDN.mscorlib.DNObject)
  ['{B33BBC4F-4E92-3476-AEC2-9A96928738BE}']
  { getters & setters } 

    function get_Font: DNFont;
    function get_AutoScaleFont: Boolean;
    procedure set_AutoScaleFont(value: Boolean);
    function get_BackgroundMode: DNBackgroundMode;
    procedure set_BackgroundMode(value: DNBackgroundMode);
    function get_RotationAngle: Int32;
    procedure set_RotationAngle(value: Int32);
    function get_IsAutomaticRotation: Boolean;
    procedure set_IsAutomaticRotation(value: Boolean);
    function get_NumberFormat: string;
    procedure set_NumberFormat(value: string);
    function get_Number: Int32;
    procedure set_Number(value: Int32);
    function get_NumberFormatLinked: Boolean;
    procedure set_NumberFormatLinked(value: Boolean);
    function get_DisplayNumberFormat: string;
    function get_Offset: Int32;
    procedure set_Offset(value: Int32);
    function get_TextDirection: DNTextDirectionType;
    procedure set_TextDirection(value: DNTextDirectionType);
    function get_ReadingOrder: DNTextDirectionType;
    procedure set_ReadingOrder(value: DNTextDirectionType);
    function get_DirectionType: DNChartTextDirectionType;
    procedure set_DirectionType(value: DNChartTextDirectionType);

  { methods } 

    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Returns a <see cref="P:Aspose.Cells.Charts.TickLabels.Font" />
    ///  object that represents the font of the specified TickLabels object.
    ///</summary>
    property Font: DNFont read get_Font;
    ///<summary>
    ///  True if the text in the object changes font size when the object size changes. The default value is True.
    ///</summary>
    property AutoScaleFont: Boolean read get_AutoScaleFont write set_AutoScaleFont;
    ///<summary>
    ///  Gets and sets the display mode of the background
    ///</summary>
    property BackgroundMode: DNBackgroundMode read get_BackgroundMode write set_BackgroundMode;
    ///<summary>
    ///  Represents text rotation angle in clockwise.
    ///</summary>
    ///<remarks><br>0: Not rotated.</br><br>255: Top to Bottom.</br><br>-90: Downward.</br><br>90: Upward.</br></remarks>
    property RotationAngle: Int32 read get_RotationAngle write set_RotationAngle;
    ///<summary>
    ///  Indicates whether the rotation angle is automatic
    ///</summary>
    property IsAutomaticRotation: Boolean read get_IsAutomaticRotation write set_IsAutomaticRotation;
    ///<summary>
    ///  Represents the format string for the TickLabels object.
    ///</summary>
    ///<remarks>The formatting string is same as a custom format string setting to a cell. For example, "$0".</remarks>
    property NumberFormat: string read get_NumberFormat write set_NumberFormat;
    ///<summary>
    ///  Represents the format number for the TickLabels object.
    ///</summary>
    property Number: Int32 read get_Number write set_Number;
    ///<summary>
    ///  True if the number format is linked to the cells
    ///  (so that the number format changes in the labels when it changes in the cells).
    ///</summary>
    property NumberFormatLinked: Boolean read get_NumberFormatLinked write set_NumberFormatLinked;
    ///<summary>
    ///  Gets and sets the display number format of tick labels.
    ///</summary>
    property DisplayNumberFormat: string read get_DisplayNumberFormat;
    ///<summary>
    ///  Represents the distance between the levels of labels, and the distance between the first level and the axis line.
    ///</summary>
    ///<remarks>
    ///  The default distance is 100 percent, which represents the default spacing between the axis labels and the axis line.
    ///  The value can be an integer percentage from 0 through 1000, relative to the axis label¡¯s font size.
    ///</remarks>
    property Offset: Int32 read get_Offset write set_Offset;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use TickLabels.ReadingOrder property.
    ///  This property will be removed 12 months later since March 2020.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    property TextDirection: DNTextDirectionType read get_TextDirection write set_TextDirection;
    ///<summary>
    ///  Represents text reading order.
    ///</summary>
    property ReadingOrder: DNTextDirectionType read get_ReadingOrder write set_ReadingOrder;
    ///<summary>
    ///  Gets and sets the direction of text.
    ///</summary>
    property DirectionType: DNChartTextDirectionType read get_DirectionType write set_DirectionType;
  end;

  TDNTickLabels = class(TDNGenericImport<DNTickLabelsClass, DNTickLabels>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCellWatchCollectionClass = interface(DNObjectClass)
  ['{43EB6020-D80E-5332-8BD5-9EE48F990C9A}']
  { constructors } 

    {class} function init: DNCellWatchCollection;

  end;

  ///<summary>
  ///  Represents the collection of cells on this worksheet being watched in the 'watch window'.
  ///</summary>
  [DNTypeName('Aspose.Cells.CellWatchCollection')]
  DNCellWatchCollection = interface(DNObject)
  ['{A15658A0-CD53-36ED-BBBF-146BE7089FF5}']
  { getters & setters } 

    function get_Item(index: Int32): DNCellWatch; overload;
    function get_Item(cellName: string): DNCellWatch; overload;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds <see cref="T:Aspose.Cells.CellWatch" />
    ///  with row and column.
    ///</summary>
    ///  <param name="row">The row index.</param>
    ///  <param name="column">The column index.</param>
    ///<returns>Returns the position of this item in the collection. </returns>
    function Add(row: Int32; column: Int32): Int32; overload;
    ///<summary>
    ///  Adds
    ///</summary>
    ///  <param name="cellName"></param>
    ///<returns></returns>
    function Add(cellName: string): Int32; overload;
    function BinarySearch(item: DNCellWatch): Int32; overload;
    function BinarySearch(item: DNCellWatch; comparer: DDN.mscorlib.DNIComparer<DNCellWatch>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNCellWatch; comparer: DDN.mscorlib.DNIComparer<DNCellWatch>): Int32; overload;
    function &Contains(item: DNCellWatch): Boolean;
    procedure CopyTo(&array: TArray<DNCellWatch>); overload;
    procedure CopyTo(&array: TArray<DNCellWatch>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNCellWatch>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNCellWatch>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNCellWatch>): DNCellWatch;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNCellWatch>): DDN.mscorlib.DNList<DNCellWatch>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNCellWatch>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNCellWatch>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNCellWatch>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNCellWatch>): DNCellWatch;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNCellWatch>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNCellWatch>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNCellWatch>): Int32; overload;
    function IndexOf(item: DNCellWatch): Int32; overload;
    function IndexOf(item: DNCellWatch; index: Int32): Int32; overload;
    function IndexOf(item: DNCellWatch; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNCellWatch): Int32; overload;
    function LastIndexOf(item: DNCellWatch; index: Int32): Int32; overload;
    function LastIndexOf(item: DNCellWatch; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNCellWatch>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNCellWatch read get_Item; default;
    property Item[cellName: string]: DNCellWatch read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNCellWatchCollection = class(TDNGenericImport<DNCellWatchCollectionClass, DNCellWatchCollection>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNChartCollectionClass = interface(DNObjectClass)
  ['{C47B6A23-00E6-5F24-A156-5EAF59A6FF8C}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.Charts.Chart" />
  ///  objects.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  Workbook workbook = new Workbook();
  ///  ChartCollection charts = workbook.Worksheets[0].Charts;
  ///  [Visual Basic]
  ///  Dim workbook as Workbook = new Workbook()
  ///  Dim ChartCollection as Charts = workbook.Worksheets(0).Charts
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.ChartCollection')]
  DNChartCollection = interface(DNObject)
  ['{7BD5C430-11D3-3EBC-9DB1-5B2BCE9FACF9}']
  { getters & setters } 

    function get_Item(index: Int32): DNChart; overload;
    function get_Item(name: string): DNChart; overload;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds a chart to the collection.
    ///</summary>
    ///  <param name="type">Chart type</param>
    ///  <param name="left">The x offset to corner</param>
    ///  <param name="top">The y offset to corner</param>
    ///  <param name="width">The chart width</param>
    ///  <param name="height">The chart height</param>
    ///<returns><see cref="T:Aspose.Cells.Charts.Chart" />
    ///  object index.</returns>
    function AddFloatingChart(&type: DNChartType; left: Int32; top: Int32; width: Int32; height: Int32): Int32;
    ///<summary>
    ///  Adds a chart to the collection.
    ///</summary>
    ///  <param name="type">Chart type</param>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="lowerRightRow">Lower right row index</param>
    ///  <param name="lowerRightColumn">Lower right column index</param>
    ///<returns><see cref="T:Aspose.Cells.Charts.Chart" />
    ///  object index.</returns>
    function Add(&type: DNChartType; upperLeftRow: Int32; upperLeftColumn: Int32; lowerRightRow: Int32; lowerRightColumn: Int32): Int32;
    ///<summary>
    ///  Remove a chart at the specific index.
    ///</summary>
    ///  <param name="index">The chart index.</param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Clear all charts.
    ///</summary>
    procedure Clear;
    function BinarySearch(item: DNChart): Int32; overload;
    function BinarySearch(item: DNChart; comparer: DDN.mscorlib.DNIComparer<DNChart>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNChart; comparer: DDN.mscorlib.DNIComparer<DNChart>): Int32; overload;
    function &Contains(item: DNChart): Boolean;
    procedure CopyTo(&array: TArray<DNChart>); overload;
    procedure CopyTo(&array: TArray<DNChart>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNChart>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNChart>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNChart>): DNChart;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNChart>): DDN.mscorlib.DNList<DNChart>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNChart>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNChart>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNChart>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNChart>): DNChart;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNChart>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNChart>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNChart>): Int32; overload;
    function IndexOf(item: DNChart): Int32; overload;
    function IndexOf(item: DNChart; index: Int32): Int32; overload;
    function IndexOf(item: DNChart; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNChart): Int32; overload;
    function LastIndexOf(item: DNChart; index: Int32): Int32; overload;
    function LastIndexOf(item: DNChart; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNChart>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNChart read get_Item; default;
    property Item[name: string]: DNChart read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNChartCollection = class(TDNGenericImport<DNChartCollectionClass, DNChartCollection>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNLegendEntryCollectionClass = interface(DNObjectClass)
  ['{106C9CE3-611A-5EF3-A969-6075FCB82ACD}']
  end;

  ///<summary>
  ///  Represents a collection of all the <see cref="T:Aspose.Cells.Charts.LegendEntry" />
  ///  objects in the specified chart legend.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.LegendEntryCollection')]
  DNLegendEntryCollection = interface(DNObject)
  ['{614B3C82-73BB-3199-BF5A-04B2BC3C8E3D}']
  { getters & setters } 

    function get_Item(index: Int32): DNLegendEntry;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    function BinarySearch(item: DNLegendEntry): Int32; overload;
    function BinarySearch(item: DNLegendEntry; comparer: DDN.mscorlib.DNIComparer<DNLegendEntry>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNLegendEntry; comparer: DDN.mscorlib.DNIComparer<DNLegendEntry>): Int32; overload;
    function &Contains(item: DNLegendEntry): Boolean;
    procedure CopyTo(&array: TArray<DNLegendEntry>); overload;
    procedure CopyTo(&array: TArray<DNLegendEntry>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNLegendEntry>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNLegendEntry>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNLegendEntry>): DNLegendEntry;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNLegendEntry>): DDN.mscorlib.DNList<DNLegendEntry>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNLegendEntry>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNLegendEntry>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNLegendEntry>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNLegendEntry>): DNLegendEntry;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNLegendEntry>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNLegendEntry>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNLegendEntry>): Int32; overload;
    function IndexOf(item: DNLegendEntry): Int32; overload;
    function IndexOf(item: DNLegendEntry; index: Int32): Int32; overload;
    function IndexOf(item: DNLegendEntry; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNLegendEntry): Int32; overload;
    function LastIndexOf(item: DNLegendEntry; index: Int32): Int32; overload;
    function LastIndexOf(item: DNLegendEntry; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNLegendEntry>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNLegendEntry read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNLegendEntryCollection = class(TDNGenericImport<DNLegendEntryCollectionClass, DNLegendEntryCollection>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNSeriesCollectionClass = interface(DNObjectClass)
  ['{86F97DC2-2B1E-5FB5-A761-BDC40935BFC7}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.Charts.Series" />
  ///  objects.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Adding a new worksheet to the Excel object
  ///  int sheetIndex = workbook.Worksheets.Add();
  ///  //Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Worksheet worksheet = workbook.Worksheets[sheetIndex];
  ///  //Adding a sample value to "A1" cell
  ///  worksheet.Cells["A1"].PutValue(50);
  ///  //Adding a sample value to "A2" cell
  ///  worksheet.Cells["A2"].PutValue(100);
  ///  //Adding a sample value to "A3" cell
  ///  worksheet.Cells["A3"].PutValue(150);
  ///  //Adding a sample value to "A4" cell
  ///  worksheet.Cells["A4"].PutValue(200);
  ///  //Adding a sample value to "B1" cell
  ///  worksheet.Cells["B1"].PutValue(60);
  ///  //Adding a sample value to "B2" cell
  ///  worksheet.Cells["B2"].PutValue(32);
  ///  //Adding a sample value to "B3" cell
  ///  worksheet.Cells["B3"].PutValue(50);
  ///  //Adding a sample value to "B4" cell
  ///  worksheet.Cells["B4"].PutValue(40);
  ///  //Adding a sample value to "C1" cell as category data
  ///  worksheet.Cells["C1"].PutValue("Q1");
  ///  //Adding a sample value to "C2" cell as category data
  ///  worksheet.Cells["C2"].PutValue("Q2");
  ///  //Adding a sample value to "C3" cell as category data
  ///  worksheet.Cells["C3"].PutValue("Y1");
  ///  //Adding a sample value to "C4" cell as category data
  ///  worksheet.Cells["C4"].PutValue("Y2");
  ///  //Adding a chart to the worksheet
  ///  int chartIndex = worksheet.Charts.Add(ChartType.Column, 5, 0, 15, 5);
  ///  //Accessing the instance of the newly added chart
  ///  Chart chart = worksheet.Charts[chartIndex];
  ///  //Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B4"
  ///  chart.NSeries.Add("A1:B4", true);
  ///  //Setting the data source for the category data of NSeries
  ///  chart.NSeries.CategoryData = "C1:C4";
  ///  //Saving the Excel file
  ///  workbook.Save("C:\\book1.xls");
  ///  [Visual Basic]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As Workbook = New Workbook()
  ///  'Adding a new worksheet to the Excel object
  ///  Dim sheetIndex As Integer = workbook.Worksheets.Add()
  ///  'Obtaining the reference of the newly added worksheet by passing its sheet index
  ///  Dim worksheet As Worksheet = workbook.Worksheets(sheetIndex)
  ///  'Adding a sample value to "A1" cell
  ///  worksheet.Cells("A1").PutValue(50)
  ///  'Adding a sample value to "A2" cell
  ///  worksheet.Cells("A2").PutValue(100)
  ///  'Adding a sample value to "A3" cell
  ///  worksheet.Cells("A3").PutValue(150)
  ///  'Adding a sample value to "A4" cell
  ///  worksheet.Cells("A4").PutValue(200)
  ///  'Adding a sample value to "B1" cell
  ///  worksheet.Cells("B1").PutValue(60)
  ///  'Adding a sample value to "B2" cell
  ///  worksheet.Cells("B2").PutValue(32)
  ///  'Adding a sample value to "B3" cell
  ///  worksheet.Cells("B3").PutValue(50)
  ///  'Adding a sample value to "B4" cell
  ///  worksheet.Cells("B4").PutValue(40)
  ///  'Adding a sample value to "C1" cell as category data
  ///  worksheet.Cells("C1").PutValue("Q1")
  ///  'Adding a sample value to "C2" cell as category data
  ///  worksheet.Cells("C2").PutValue("Q2")
  ///  'Adding a sample value to "C3" cell as category data
  ///  worksheet.Cells("C3").PutValue("Y1")
  ///  'Adding a sample value to "C4" cell as category data
  ///  worksheet.Cells("C4").PutValue("Y2")
  ///  'Adding a chart to the worksheet
  ///  Dim chartIndex As Integer = worksheet.Charts.Add(ChartType.Column, 5, 0, 15, 5)
  ///  'Accessing the instance of the newly added chart
  ///  Dim chart As Chart = worksheet.Charts(chartIndex)
  ///  'Adding NSeries (chart data source) to the chart ranging from "A1" cell to "B4"
  ///  chart.NSeries.Add("A1:B4", True)
  ///  'Setting the data source for the category data of NSeries
  ///  chart.NSeries.CategoryData = "C1:C4"
  ///  'Saving the Excel file
  ///  workbook.Save("C:\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.SeriesCollection')]
  DNSeriesCollection = interface(DNObject)
  ['{57941404-7B71-333A-AA82-14DCF7895445}']
  { getters & setters } 

    function get_Item(index: Int32): DNSeries;
    function get_CategoryData: string;
    procedure set_CategoryData(value: string);
    function get_SecondCategoryData: string;
    procedure set_SecondCategoryData(value: string);
    function get_IsColorVaried: Boolean;
    procedure set_IsColorVaried(value: Boolean);
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Charts.Series" />
    ///  element by order.
    ///</summary>
    ///  <param name="order">The order of series</param>
    ///<returns>The element series</returns>
    function GetSeriesByOrder(order: Int32): DNSeries;
    ///<summary>
    ///  Remove at a series at the specific index.
    ///</summary>
    ///  <param name="index">The index.</param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Directly changes the orders of the two series.
    ///</summary>
    ///  <param name="sourceIndex">The current index</param>
    ///  <param name="destIndex">The dest index</param>
    procedure ChangeSeriesOrder(sourceIndex: Int32; destIndex: Int32);
    ///<summary>
    ///  Adds the <see cref="T:Aspose.Cells.Charts.SeriesCollection" />
    ///  collection to a chart.
    ///</summary>
    ///  <param name="area">Specifies values from which to plot the data series</param>
    ///  <param name="isVertical">Specifies whether to plot the series from a range of cell values by row or by column.</param>
    ///<returns>Return the first index of the added ASeries in the NSeries.</returns>
    ///<remarks><br>If set data on contiguous cells, use colon to seperate them.For example, R[1]C[1]:R[3]C[2].</br><br>If set data on contiguous cells, use comma to seperate them.For example,(R[1]C[1],R[3]C[2]).</br></remarks>
    function AddR1C1(area: string; isVertical: Boolean): Int32;
    ///<summary>
    ///  Adds the <see cref="T:Aspose.Cells.Charts.SeriesCollection" />
    ///  collection to a chart.
    ///</summary>
    ///  <param name="area">Specifies values from which to plot the data series</param>
    ///  <param name="isVertical">Specifies whether to plot the series from a range of cell values by row or by column.</param>
    ///<returns>Return the first index of the added ASeries in the NSeries.</returns>
    ///<remarks><br>If set data on contiguous cells, use colon to seperate them.For example, $C$2:$C$5.</br><br>If set data on non contiguous cells, use comma to seperate them.For example: ($C$2,$D$5).</br></remarks>
    function Add(area: string; isVertical: Boolean): Int32;
    ///<summary>
    ///  Clears the collection
    ///</summary>
    procedure Clear;
    function BinarySearch(item: DNSeries): Int32; overload;
    function BinarySearch(item: DNSeries; comparer: DDN.mscorlib.DNIComparer<DNSeries>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNSeries; comparer: DDN.mscorlib.DNIComparer<DNSeries>): Int32; overload;
    function &Contains(item: DNSeries): Boolean;
    procedure CopyTo(&array: TArray<DNSeries>); overload;
    procedure CopyTo(&array: TArray<DNSeries>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNSeries>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNSeries>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNSeries>): DNSeries;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNSeries>): DDN.mscorlib.DNList<DNSeries>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNSeries>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNSeries>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNSeries>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNSeries>): DNSeries;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNSeries>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNSeries>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNSeries>): Int32; overload;
    function IndexOf(item: DNSeries): Int32; overload;
    function IndexOf(item: DNSeries; index: Int32): Int32; overload;
    function IndexOf(item: DNSeries; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNSeries): Int32; overload;
    function LastIndexOf(item: DNSeries; index: Int32): Int32; overload;
    function LastIndexOf(item: DNSeries; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNSeries>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNSeries read get_Item; default;
    ///<summary>
    ///  Gets or sets the range of category Axis values.
    ///  It can be a range of cells (such as, "d1:e10"),
    ///  or a sequence of values (such as,"{2,6,8,10}").
    ///</summary>
    property CategoryData: string read get_CategoryData write set_CategoryData;
    ///<summary>
    ///  Gets or sets the range of second category Axis values.
    ///  It can be a range of cells (such as, "d1:e10"),
    ///  or a sequence of values (such as,"{2,6,8,10}").
    ///  Only effects when some ASerieses plot on the second axis.
    ///</summary>
    property SecondCategoryData: string read get_SecondCategoryData write set_SecondCategoryData;
    ///<summary>
    ///  Represents if the color of points is varied.
    ///</summary>
    property IsColorVaried: Boolean read get_IsColorVaried write set_IsColorVaried;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNSeriesCollection = class(TDNGenericImport<DNSeriesCollectionClass, DNSeriesCollection>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNSparklineCollectionClass = interface(DNObjectClass)
  ['{165EFF1A-43A5-56CD-AB5C-E2DE8D237BA6}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.Charts.Sparkline" />
  ///  objects.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.SparklineCollection')]
  DNSparklineCollection = interface(DNObject)
  ['{3A1EAD61-FDD6-3EB5-9500-E7C41430E186}']
  { getters & setters } 

    function get_Item(index: Int32): DNSparkline;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Add a sparkline.
    ///</summary>
    ///  <param name="dataRange">Specifies the new data range of the sparkline.</param>
    ///  <param name="row">The row index of the location.</param>
    ///  <param name="column">The column index of the location.</param>
    function Add(dataRange: string; row: Int32; column: Int32): Int32;
    ///<summary>
    ///  Removes the sparkline
    ///</summary>
    ///  <param name="o"></param>
    procedure Remove(o: DDN.mscorlib.DNObject);
    function BinarySearch(item: DNSparkline): Int32; overload;
    function BinarySearch(item: DNSparkline; comparer: DDN.mscorlib.DNIComparer<DNSparkline>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNSparkline; comparer: DDN.mscorlib.DNIComparer<DNSparkline>): Int32; overload;
    function &Contains(item: DNSparkline): Boolean;
    procedure CopyTo(&array: TArray<DNSparkline>); overload;
    procedure CopyTo(&array: TArray<DNSparkline>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNSparkline>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNSparkline>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNSparkline>): DNSparkline;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNSparkline>): DDN.mscorlib.DNList<DNSparkline>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNSparkline>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNSparkline>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNSparkline>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNSparkline>): DNSparkline;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNSparkline>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNSparkline>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNSparkline>): Int32; overload;
    function IndexOf(item: DNSparkline): Int32; overload;
    function IndexOf(item: DNSparkline; index: Int32): Int32; overload;
    function IndexOf(item: DNSparkline; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNSparkline): Int32; overload;
    function LastIndexOf(item: DNSparkline; index: Int32): Int32; overload;
    function LastIndexOf(item: DNSparkline; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNSparkline>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNSparkline read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNSparklineCollection = class(TDNGenericImport<DNSparklineCollectionClass, DNSparklineCollection>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNSparklineGroupCollectionClass = interface(DNObjectClass)
  ['{C21B7E5F-7C5D-5168-8A65-D30EC3B790FE}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.Charts.SparklineGroup" />
  ///  objects.
  ///</summary>
  [DNTypeName('Aspose.Cells.Charts.SparklineGroupCollection')]
  DNSparklineGroupCollection = interface(DNObject)
  ['{89EC08CB-AE12-3574-893B-0B0E6C3571FB}']
  { getters & setters } 

    function get_Item(index: Int32): DNSparklineGroup;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds an <see cref="T:Aspose.Cells.Charts.SparklineGroup" />
    ///  item to the collection.
    ///</summary>
    ///  <param name="type">Specifies the type of the Sparkline group.</param>
    ///  <param name="dataRange">Specifies the data range of the sparkline group.</param>
    ///  <param name="isVertical">Specifies whether to plot the sparklines from the data range by row or by column.</param>
    ///  <param name="locationRange">Specifies where the sparklines to be placed.</param>
    ///<returns><see cref="T:Aspose.Cells.Charts.SparklineGroup" />
    ///  object index.</returns>
    function Add(&type: DNSparklineType; dataRange: string; isVertical: Boolean; locationRange: DNCellArea): Int32;
    ///<summary>
    ///  Clears the sparklines that is inside an area of cells.
    ///</summary>
    ///  <param name="cellArea">Specifies the area of cells</param>
    procedure ClearSparklines(cellArea: DNCellArea);
    ///<summary>
    ///  Clears the sparkline groups that overlaps an area of cells.
    ///</summary>
    ///  <param name="cellArea">Specifies the area of cells</param>
    procedure ClearSparklineGroups(cellArea: DNCellArea);
    function BinarySearch(item: DNSparklineGroup): Int32; overload;
    function BinarySearch(item: DNSparklineGroup; comparer: DDN.mscorlib.DNIComparer<DNSparklineGroup>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNSparklineGroup; comparer: DDN.mscorlib.DNIComparer<DNSparklineGroup>): Int32; overload;
    function &Contains(item: DNSparklineGroup): Boolean;
    procedure CopyTo(&array: TArray<DNSparklineGroup>); overload;
    procedure CopyTo(&array: TArray<DNSparklineGroup>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNSparklineGroup>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): DNSparklineGroup;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): DDN.mscorlib.DNList<DNSparklineGroup>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): DNSparklineGroup;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNSparklineGroup>): Int32; overload;
    function IndexOf(item: DNSparklineGroup): Int32; overload;
    function IndexOf(item: DNSparklineGroup; index: Int32): Int32; overload;
    function IndexOf(item: DNSparklineGroup; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNSparklineGroup): Int32; overload;
    function LastIndexOf(item: DNSparklineGroup; index: Int32): Int32; overload;
    function LastIndexOf(item: DNSparklineGroup; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNSparklineGroup>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNSparklineGroup read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNSparklineGroupCollection = class(TDNGenericImport<DNSparklineGroupCollectionClass, DNSparklineGroupCollection>) end;

  //-------------namespace: Aspose.Cells.Charts----------------
  DNTrendlineCollectionClass = interface(DNObjectClass)
  ['{A53C785C-E6BD-50CD-80C0-BBF743367026}']
  end;

  ///<summary>
  ///  Represents a collection of all the <see cref="T:Aspose.Cells.Charts.Trendline" />
  ///  objects for the specified data series.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  int chartIndex = excel.Worksheets[0].Charts.Add(ChartType.Column, 3, 3, 15, 10);
  ///  Chart chart = excel.Worksheets[0].Charts[chartIndex];
  ///  chart.NSeries.Add("A1:a3", true);
  ///  chart.NSeries[0].TrendLines.Add(TrendlineType.Linear, "MyTrendLine");
  ///  Trendline line = chart.NSeries[0].TrendLines[0];
  ///  line.DisplayEquation = true;
  ///  line.DisplayRSquared = true;
  ///  line.Color = Color.Red;
  ///  [Visual Basic]
  ///  Dim chartIndex As Integer =  excel.Worksheets(0).Charts.Add(ChartType.Column,3,3,15,10)
  ///  Dim chart As Chart =  excel.Worksheets(0).Charts(chartIndex)
  ///  chart.NSeries.Add("A1:a3", True)
  ///  chart.NSeries(0).TrendLines.Add(TrendlineType.Linear, "MyTrendLine")
  ///  Dim line As Trendline =  chart.NSeries(0).TrendLines(0)
  ///  line.DisplayEquation = True
  ///  line.DisplayRSquared = True
  ///  line.Color = Color.Red
  ///</code></example>
  [DNTypeName('Aspose.Cells.Charts.TrendlineCollection')]
  DNTrendlineCollection = interface(DNObject)
  ['{F9924C0A-3A3B-3296-978A-C00B3B4D6E6B}']
  { getters & setters } 

    function get_Item(index: Int32): DNTrendline;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds a <seealso cref="T:Aspose.Cells.Charts.Trendline" />
    ///  object to this collection with specified type.
    ///</summary>
    ///  <param name="type">Trendline type.</param>
    ///<returns><see cref="T:Aspose.Cells.Charts.Trendline" />
    ///  object index.</returns>
    function Add(&type: DNTrendlineType): Int32; overload;
    ///<summary>
    ///  Adds a <seealso cref="T:Aspose.Cells.Charts.Trendline" />
    ///  object to this collection with specified type and name.
    ///</summary>
    ///  <param name="type">Trendline type.</param>
    ///  <param name="name">Trendline name.</param>
    ///<returns><see cref="T:Aspose.Cells.Charts.Trendline" />
    ///  object index.</returns>
    function Add(&type: DNTrendlineType; name: string): Int32; overload;
    function BinarySearch(item: DNTrendline): Int32; overload;
    function BinarySearch(item: DNTrendline; comparer: DDN.mscorlib.DNIComparer<DNTrendline>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNTrendline; comparer: DDN.mscorlib.DNIComparer<DNTrendline>): Int32; overload;
    function &Contains(item: DNTrendline): Boolean;
    procedure CopyTo(&array: TArray<DNTrendline>); overload;
    procedure CopyTo(&array: TArray<DNTrendline>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNTrendline>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNTrendline>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNTrendline>): DNTrendline;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNTrendline>): DDN.mscorlib.DNList<DNTrendline>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNTrendline>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNTrendline>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNTrendline>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNTrendline>): DNTrendline;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNTrendline>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNTrendline>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNTrendline>): Int32; overload;
    function IndexOf(item: DNTrendline): Int32; overload;
    function IndexOf(item: DNTrendline; index: Int32): Int32; overload;
    function IndexOf(item: DNTrendline; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNTrendline): Int32; overload;
    function LastIndexOf(item: DNTrendline; index: Int32): Int32; overload;
    function LastIndexOf(item: DNTrendline; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNTrendline>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNTrendline read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNTrendlineCollection = class(TDNGenericImport<DNTrendlineCollectionClass, DNTrendlineCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNColumnCollectionClass = interface(DNObjectClass)
  ['{E67AA4B9-0A87-5EF1-A460-EFAC1382ED35}']
  end;

  ///<summary>
  ///  Collects the <seealso cref="T:Aspose.Cells.Column" />
  ///  objects that represent the individual columns in a worksheet.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  //Obtaining the reference of the first worksheet
  ///  Worksheet worksheet = workbook.Worksheets[0];
  ///  //Add new Style to Workbook
  ///  Style style = workbook.CreateStyle();
  ///  //Setting the background color to Blue
  ///  style.ForegroundColor = Color.Blue;
  ///  //setting Background Pattern
  ///  style.Pattern = BackgroundType.Solid;
  ///  //New Style Flag
  ///  StyleFlag styleFlag = new StyleFlag();
  ///  //Set All Styles
  ///  styleFlag.All = true;
  ///  //Change the default width of first ten columns
  ///  for (int i = 0; i &lt; 10; i++)
  ///  {
  ///  worksheet.Cells.Columns[i].Width = 20;
  ///  }
  ///  //Get the Column with non default formatting
  ///  ColumnCollection columns = worksheet.Cells.Columns;
  ///  foreach (Column column in columns)
  ///  {
  ///  //Apply Style to first ten Columns
  ///  column.ApplyStyle(style, styleFlag);
  ///  }
  ///  //Saving the Excel file
  ///  workbook.Save("D:\\book1.xls");
  ///  [VB.NET]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As New Workbook()
  ///  'Obtaining the reference of the first worksheet
  ///  Dim worksheet As Worksheet = workbook.Worksheets(0)
  ///  'Add new Style to Workbook
  ///  Dim style As Style = workbook.CreateStyles()
  ///  'Setting the background color to Blue
  ///  style.ForegroundColor = Color.Blue
  ///  'setting Background Pattern
  ///  style.Pattern = BackgroundType.Solid
  ///  'New Style Flag
  ///  Dim styleFlag As New StyleFlag()
  ///  'Set All Styles
  ///  styleFlag.All = True
  ///  'Change the default width of first ten columns
  ///  For i As Integer = 0 To 9
  ///  worksheet.Cells.Columns(i).Width = 20
  ///  Next i
  ///  'Get the Column with non default formatting
  ///  Dim columns As ColumnCollection = worksheet.Cells.Columns
  ///  For Each column As Column In columns
  ///  'Apply Style to first ten Columns
  ///  column.ApplyStyle(style, styleFlag)
  ///  Next column
  ///  'Saving the Excel file
  ///  workbook.Save("D:\book1.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.ColumnCollection')]
  DNColumnCollection = interface(DNObject)
  ['{97F9993E-BFF4-3B90-8960-E47DC1BB0382}']
  { getters & setters } 

    function get_Item(columnIndex: Int32): DNColumn;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Gets the column object by the index.
    ///</summary>
    ///  <param name="index"></param>
    ///<returns>Returns the column object.</returns>
    ///<remarks>NOTE: This member is now obsolete. Instead,
    ///  please use Columns.GetColumnByIndex() method.
    ///  This property will be removed 12 months later since June 2010.
    ///  Aspose apologizes for any inconvenience you may have experienced.</remarks>
    function GetByIndex(index: Int32): DNColumn;
    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.Column" />
    ///  object by the position in the list.
    ///</summary>
    ///  <param name="index">The position in the list.</param>
    ///<returns>Returns the column object.</returns>
    function GetColumnByIndex(index: Int32): DNColumn;
    function BinarySearch(item: DNColumn): Int32; overload;
    function BinarySearch(item: DNColumn; comparer: DDN.mscorlib.DNIComparer<DNColumn>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNColumn; comparer: DDN.mscorlib.DNIComparer<DNColumn>): Int32; overload;
    function &Contains(item: DNColumn): Boolean;
    procedure CopyTo(&array: TArray<DNColumn>); overload;
    procedure CopyTo(&array: TArray<DNColumn>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNColumn>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNColumn>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNColumn>): DNColumn;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNColumn>): DDN.mscorlib.DNList<DNColumn>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNColumn>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNColumn>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNColumn>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNColumn>): DNColumn;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNColumn>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNColumn>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNColumn>): Int32; overload;
    function IndexOf(item: DNColumn): Int32; overload;
    function IndexOf(item: DNColumn; index: Int32): Int32; overload;
    function IndexOf(item: DNColumn; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNColumn): Int32; overload;
    function LastIndexOf(item: DNColumn; index: Int32): Int32; overload;
    function LastIndexOf(item: DNColumn; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNColumn>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[columnIndex: Int32]: DNColumn read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNColumnCollection = class(TDNGenericImport<DNColumnCollectionClass, DNColumnCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCommentCollectionClass = interface(DNObjectClass)
  ['{BED0AD9E-5193-57A4-9685-5D97E3E9C9BC}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.Comment" />
  ///  objects.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  Workbook workbook = new Workbook();
  ///  CommentCollection comments = workbook.Worksheets[0].Comments;
  ///  [Visual Basic]
  ///  Dim workbook as Workbook = new Workbook()
  ///  Dim comments as CommentCollection = workbook.Worksheets(0).Comments
  ///</code></example>
  [DNTypeName('Aspose.Cells.CommentCollection')]
  DNCommentCollection = interface(DNObject)
  ['{8C33E2E3-868B-39DA-970D-08F58FC5733A}']
  { getters & setters } 

    function get_Item(index: Int32): DNComment; overload;
    function get_Item(cellName: string): DNComment; overload;
    function get_Item(row: Int32; column: Int32): DNComment; overload;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds a threaded comment.
    ///</summary>
    ///  <param name="row">Cell row index.</param>
    ///  <param name="column">Cell column index.</param>
    ///  <param name="text">The text of the comment</param>
    ///  <param name="author">The user of this threaded comment.</param>
    ///<returns><see cref="T:Aspose.Cells.ThreadedComment" />
    ///  object index.</returns>
    function AddThreadedComment(row: Int32; column: Int32; text: string; author: DNThreadedCommentAuthor): Int32; overload;
    ///<summary>
    ///  Adds a threaded comment.
    ///</summary>
    ///  <param name="cellName">The name of the cell.</param>
    ///  <param name="text">The text of the comment</param>
    ///  <param name="author">The user of this threaded comment.</param>
    ///<returns><see cref="T:Aspose.Cells.ThreadedComment" />
    ///  object index.</returns>
    function AddThreadedComment(cellName: string; text: string; author: DNThreadedCommentAuthor): Int32; overload;
    ///<summary>
    ///  Gets the threaded comments by row and column index.
    ///</summary>
    ///  <param name="row">The row index.</param>
    ///  <param name="column">The column index.</param>
    ///<returns></returns>
    function GetThreadedComments(row: Int32; column: Int32): DNThreadedCommentCollection; overload;
    ///<summary>
    ///  Gets the threaded comments by cell name.
    ///</summary>
    ///  <param name="cellName">The name of the cell.</param>
    ///<returns></returns>
    function GetThreadedComments(cellName: string): DNThreadedCommentCollection; overload;
    ///<summary>
    ///  Adds a comment to the collection.
    ///</summary>
    ///  <param name="row">Cell row index.</param>
    ///  <param name="column">Cell column index.</param>
    ///<returns><see cref="T:Aspose.Cells.Comment" />
    ///  object index.</returns>
    function Add(row: Int32; column: Int32): Int32; overload;
    ///<summary>
    ///  Adds a comment to the collection.
    ///</summary>
    ///  <param name="cellName">Cell name.</param>
    ///<returns><see cref="T:Aspose.Cells.Comment" />
    ///  object index.</returns>
    function Add(cellName: string): Int32; overload;
    ///<summary>
    ///  Removes the comment of the specific cell.
    ///</summary>
    ///  <param name="cellName">The name of cell which contains a comment.</param>
    procedure RemoveAt(cellName: string); overload;
    ///<summary>
    ///  Removes the comment of the specific cell.
    ///</summary>
    ///  <param name="row">The row index.</param>
    ///  <param name="column">the column index.</param>
    procedure RemoveAt(row: Int32; column: Int32); overload;
    ///<summary>
    ///  Removes all comments;
    ///</summary>
    procedure Clear;
    function BinarySearch(item: DNComment): Int32; overload;
    function BinarySearch(item: DNComment; comparer: DDN.mscorlib.DNIComparer<DNComment>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNComment; comparer: DDN.mscorlib.DNIComparer<DNComment>): Int32; overload;
    function &Contains(item: DNComment): Boolean;
    procedure CopyTo(&array: TArray<DNComment>); overload;
    procedure CopyTo(&array: TArray<DNComment>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNComment>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNComment>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNComment>): DNComment;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNComment>): DDN.mscorlib.DNList<DNComment>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNComment>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNComment>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNComment>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNComment>): DNComment;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNComment>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNComment>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNComment>): Int32; overload;
    function IndexOf(item: DNComment): Int32; overload;
    function IndexOf(item: DNComment; index: Int32): Int32; overload;
    function IndexOf(item: DNComment; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNComment): Int32; overload;
    function LastIndexOf(item: DNComment; index: Int32): Int32; overload;
    function LastIndexOf(item: DNComment; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNComment>;
    procedure RemoveAt(index: Int32); overload;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNComment read get_Item; default;
    property Item[cellName: string]: DNComment read get_Item; default;
    property Item[row: Int32; column: Int32]: DNComment read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNCommentCollection = class(TDNGenericImport<DNCommentCollectionClass, DNCommentCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNConditionalFormattingIconCollectionClass = interface(DNObjectClass)
  ['{43D302DB-1CC3-5C4E-B992-C8AC91018D67}']
  end;

  ///<summary>
  ///  Represents  a collection of <see cref="T:Aspose.Cells.ConditionalFormattingIcon" />
  ///  objects.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  Worksheet sheet = workbook.Worksheets[0];
  ///  //Get Conditional Formatting
  ///  ConditionalFormattingCollection cformattings = sheet.ConditionalFormattings;
  ///  //Adds an empty conditional formatting
  ///  int index = cformattings.Add();
  ///  //Get newly added Conditional formatting
  ///  FormatConditionCollection fcs = cformattings[index];
  ///  //Sets the conditional format range.
  ///  CellArea ca = new CellArea();
  ///  ca.StartRow = 0;
  ///  ca.EndRow = 0;
  ///  ca.StartColumn = 0;
  ///  ca.EndColumn = 0;
  ///  fcs.AddArea(ca);
  ///  ca = new CellArea();
  ///  ca.StartRow = 1;
  ///  ca.EndRow = 1;
  ///  ca.StartColumn = 1;
  ///  ca.EndColumn = 1;
  ///  fcs.AddArea(ca);
  ///  //Sets condition
  ///  int idx = fcs.AddCondition(FormatConditionType.IconSet);
  ///  FormatCondition cond = fcs[idx];
  ///  //Sets condition's type
  ///  cond.IconSet.Type = IconSetType.ArrowsGray3;
  ///  //Add custom iconset condition.
  ///  ConditionalFormattingIcon cfIcon = cond.IconSet.CfIcons[0];
  ///  cfIcon.Type = IconSetType.Arrows3;
  ///  cfIcon.Index = 0;
  ///  ConditionalFormattingIcon cfIcon1 = cond.IconSet.CfIcons[1];
  ///  cfIcon1.Type = IconSetType.ArrowsGray3;
  ///  cfIcon1.Index = 1;
  ///  ConditionalFormattingIcon cfIcon2 = cond.IconSet.CfIcons[2];
  ///  cfIcon2.Type = IconSetType.Boxes5;
  ///  cfIcon2.Index = 2;
  ///  //Saving the Excel file
  ///  workbook.Save("C:\\output.xls");
  ///  [VB.NET]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As New Workbook()
  ///  Dim sheet As Worksheet = workbook.Worksheets(0)
  ///  'Get Conditional Formatting
  ///  Dim cformattings As ConditionalFormattingCollection = sheet.ConditionalFormattings
  ///  'Adds an empty conditional formatting
  ///  Dim index As Integer = cformattings.Add()
  ///  'Get newly added Conditional formatting
  ///  Dim fcs As FormatConditionCollection = cformattings(index)
  ///  'Sets the conditional format range.
  ///  Dim ca As New CellArea()
  ///  ca.StartRow = 0
  ///  ca.EndRow = 0
  ///  ca.StartColumn = 0
  ///  ca.EndColumn = 0
  ///  fcs.AddArea(ca)
  ///  ca = New CellArea()
  ///  ca.StartRow = 1
  ///  ca.EndRow = 1
  ///  ca.StartColumn = 1
  ///  ca.EndColumn = 1
  ///  fcs.AddArea(ca)
  ///  //Sets condition
  ///  Dim idx As Integer =fcs.AddCondition(FormatConditionType.IconSet)
  ///  Dim cond As FormatCondition=fcs[idx]
  ///  //Sets condition's type
  ///  cfIcon.Type = IconSetType.ArrowsGray3
  ///  'Add custom iconset  condition.
  ///  Dim cfIcon As ConditionalFormattingIcon = cond.IconSet.CfIcons[0]
  ///  cfIcon.Type = IconSetType.Arrows3
  ///  cfIcon.Index=0
  ///  Dim cfIcon1 As ConditionalFormattingIcon = cond.IconSet.CfIcons[1]
  ///  cfIcon1.Type = IconSetType.ArrowsGray3
  ///  cfIcon1.Index=1
  ///  Dim cfIcon2 As ConditionalFormattingIcon = cond.IconSet.CfIcons[2]
  ///  cfIcon2.Type = IconSetType.Boxes5
  ///  cfIcon2.Index=2
  ///  'Saving the Excel file
  ///  workbook.Save("C:\output.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.ConditionalFormattingIconCollection')]
  DNConditionalFormattingIconCollection = interface(DNObject)
  ['{1B87EAF2-5263-3F3E-AB09-0765D063591E}']
  { getters & setters } 

    function get_Item(index: Int32): DNConditionalFormattingIcon;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds <see cref="T:Aspose.Cells.ConditionalFormattingIcon" />
    ///  object.
    ///</summary>
    ///  <param name="type">The value type.</param>
    ///  <param name="index">The Index.</param>
    ///<returns>Returns the index of new object in the list.</returns>
    function Add(&type: DNIconSetType; index: Int32): Int32; overload;
    ///<summary>
    ///  Adds <see cref="T:Aspose.Cells.ConditionalFormattingIcon" />
    ///  object.
    ///</summary>
    ///  <param name="cficon">Returns the index of new object in the list.</param>
    function Add(cficon: DNConditionalFormattingIcon): Int32; overload;
    function BinarySearch(item: DNConditionalFormattingIcon): Int32; overload;
    function BinarySearch(item: DNConditionalFormattingIcon; comparer: DDN.mscorlib.DNIComparer<DNConditionalFormattingIcon>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNConditionalFormattingIcon; comparer: DDN.mscorlib.DNIComparer<DNConditionalFormattingIcon>): Int32; overload;
    function &Contains(item: DNConditionalFormattingIcon): Boolean;
    procedure CopyTo(&array: TArray<DNConditionalFormattingIcon>); overload;
    procedure CopyTo(&array: TArray<DNConditionalFormattingIcon>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNConditionalFormattingIcon>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): DNConditionalFormattingIcon;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): DDN.mscorlib.DNList<DNConditionalFormattingIcon>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): DNConditionalFormattingIcon;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNConditionalFormattingIcon>): Int32; overload;
    function IndexOf(item: DNConditionalFormattingIcon): Int32; overload;
    function IndexOf(item: DNConditionalFormattingIcon; index: Int32): Int32; overload;
    function IndexOf(item: DNConditionalFormattingIcon; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNConditionalFormattingIcon): Int32; overload;
    function LastIndexOf(item: DNConditionalFormattingIcon; index: Int32): Int32; overload;
    function LastIndexOf(item: DNConditionalFormattingIcon; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNConditionalFormattingIcon>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNConditionalFormattingIcon read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNConditionalFormattingIconCollection = class(TDNGenericImport<DNConditionalFormattingIconCollectionClass, DNConditionalFormattingIconCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNConditionalFormattingValueCollectionClass = interface(DNObjectClass)
  ['{6CB096D1-7A30-5D0D-943A-5F91E2541726}']
  end;

  ///<summary>
  ///  Describes a collection of CFValueObject.
  ///  Use only for icon sets.
  ///</summary>
  [DNTypeName('Aspose.Cells.ConditionalFormattingValueCollection')]
  DNConditionalFormattingValueCollection = interface(DNObject)
  ['{88D06D82-4622-3D6A-9EFF-8D687A6782DC}']
  { getters & setters } 

    function get_Item(index: Int32): DNConditionalFormattingValue;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds <see cref="T:Aspose.Cells.ConditionalFormattingValue" />
    ///  object.
    ///</summary>
    ///  <param name="type">The value type.</param>
    ///  <param name="value">The value.</param>
    ///<returns>Returns the index of new object in the list.</returns>
    function Add(&type: DNFormatConditionValueType; value: string): Int32;
    function BinarySearch(item: DNConditionalFormattingValue): Int32; overload;
    function BinarySearch(item: DNConditionalFormattingValue; comparer: DDN.mscorlib.DNIComparer<DNConditionalFormattingValue>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNConditionalFormattingValue; comparer: DDN.mscorlib.DNIComparer<DNConditionalFormattingValue>): Int32; overload;
    function &Contains(item: DNConditionalFormattingValue): Boolean;
    procedure CopyTo(&array: TArray<DNConditionalFormattingValue>); overload;
    procedure CopyTo(&array: TArray<DNConditionalFormattingValue>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNConditionalFormattingValue>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): DNConditionalFormattingValue;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): DDN.mscorlib.DNList<DNConditionalFormattingValue>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): DNConditionalFormattingValue;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNConditionalFormattingValue>): Int32; overload;
    function IndexOf(item: DNConditionalFormattingValue): Int32; overload;
    function IndexOf(item: DNConditionalFormattingValue; index: Int32): Int32; overload;
    function IndexOf(item: DNConditionalFormattingValue; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNConditionalFormattingValue): Int32; overload;
    function LastIndexOf(item: DNConditionalFormattingValue; index: Int32): Int32; overload;
    function LastIndexOf(item: DNConditionalFormattingValue; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNConditionalFormattingValue>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNConditionalFormattingValue read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNConditionalFormattingValueCollection = class(TDNGenericImport<DNConditionalFormattingValueCollectionClass, DNConditionalFormattingValueCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNCustomFilterCollectionClass = interface(DNObjectClass)
  ['{DBA3B473-01F0-5B75-B98E-1670E3D7FBB7}']
  { constructors } 

    {class} function init: DNCustomFilterCollection;

  end;

  ///<summary>
  ///  Represents the custom filters.
  ///</summary>
  [DNTypeName('Aspose.Cells.CustomFilterCollection')]
  DNCustomFilterCollection = interface(DNObject)
  ['{FAEE49EC-D85F-365B-BCCA-45739034FC11}']
  { getters & setters } 

    function get_And: Boolean;
    procedure set_And(value: Boolean);
    function get_Item(index: Int32): DNCustomFilter;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    function BinarySearch(item: DNCustomFilter): Int32; overload;
    function BinarySearch(item: DNCustomFilter; comparer: DDN.mscorlib.DNIComparer<DNCustomFilter>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNCustomFilter; comparer: DDN.mscorlib.DNIComparer<DNCustomFilter>): Int32; overload;
    function &Contains(item: DNCustomFilter): Boolean;
    procedure CopyTo(&array: TArray<DNCustomFilter>); overload;
    procedure CopyTo(&array: TArray<DNCustomFilter>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNCustomFilter>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNCustomFilter>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNCustomFilter>): DNCustomFilter;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNCustomFilter>): DDN.mscorlib.DNList<DNCustomFilter>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNCustomFilter>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNCustomFilter>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNCustomFilter>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNCustomFilter>): DNCustomFilter;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNCustomFilter>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNCustomFilter>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNCustomFilter>): Int32; overload;
    function IndexOf(item: DNCustomFilter): Int32; overload;
    function IndexOf(item: DNCustomFilter; index: Int32): Int32; overload;
    function IndexOf(item: DNCustomFilter; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNCustomFilter): Int32; overload;
    function LastIndexOf(item: DNCustomFilter; index: Int32): Int32; overload;
    function LastIndexOf(item: DNCustomFilter; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNCustomFilter>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Indicates whether the two criteria have an "and" relationship.
    ///</summary>
    property &And: Boolean read get_And write set_And;
    property Item[index: Int32]: DNCustomFilter read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNCustomFilterCollection = class(TDNGenericImport<DNCustomFilterCollectionClass, DNCustomFilterCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNDataSorterKeyCollectionClass = interface(DNObjectClass)
  ['{C4A87B48-2DBA-5E70-BCC5-110A7CA6731E}']
  { constructors } 

    {class} function init: DNDataSorterKeyCollection;

  end;

  ///<summary>
  ///  Represents the key list of data sorter.
  ///</summary>
  [DNTypeName('Aspose.Cells.DataSorterKeyCollection')]
  DNDataSorterKeyCollection = interface(DNObject)
  ['{7A14F0DD-3025-3185-B43A-83C9EBB0BCCC}']
  { getters & setters } 

    function get_Item(index: Int32): DNDataSorterKey;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    function BinarySearch(item: DNDataSorterKey): Int32; overload;
    function BinarySearch(item: DNDataSorterKey; comparer: DDN.mscorlib.DNIComparer<DNDataSorterKey>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNDataSorterKey; comparer: DDN.mscorlib.DNIComparer<DNDataSorterKey>): Int32; overload;
    function &Contains(item: DNDataSorterKey): Boolean;
    procedure CopyTo(&array: TArray<DNDataSorterKey>); overload;
    procedure CopyTo(&array: TArray<DNDataSorterKey>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNDataSorterKey>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): DNDataSorterKey;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): DDN.mscorlib.DNList<DNDataSorterKey>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): DNDataSorterKey;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNDataSorterKey>): Int32; overload;
    function IndexOf(item: DNDataSorterKey): Int32; overload;
    function IndexOf(item: DNDataSorterKey; index: Int32): Int32; overload;
    function IndexOf(item: DNDataSorterKey; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNDataSorterKey): Int32; overload;
    function LastIndexOf(item: DNDataSorterKey; index: Int32): Int32; overload;
    function LastIndexOf(item: DNDataSorterKey; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNDataSorterKey>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNDataSorterKey read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNDataSorterKeyCollection = class(TDNGenericImport<DNDataSorterKeyCollectionClass, DNDataSorterKeyCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNCheckBoxCollectionClass = interface(DNObjectClass)
  ['{843B6CEB-22A1-5239-AAC9-4057978CE5EE}']
  end;

  ///<summary>
  ///  Represents a collection of <see cref="T:Aspose.Cells.Drawing.CheckBox" />
  ///  objects in a worksheet.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  int index = excel.Worksheets[0].CheckBoxes.Add(15, 15, 20, 100);
  ///  CheckBox checkBox = excel.Worksheets[0].CheckBoxes[index];
  ///  checkBox.Text = "Check Box 1";
  ///  [Visual Basic]
  ///  Dim index as integer = excel.Worksheets(0).CheckBoxes.Add(15, 15, 20, 100)
  ///  Dim checkBox as CheckBox = excel.Worksheets(0).CheckBoxes[index];
  ///  checkBox.Text = "Check Box 1"
  ///</code></example>
  [DNTypeName('Aspose.Cells.Drawing.CheckBoxCollection')]
  DNCheckBoxCollection = interface(DNObject)
  ['{D2E840D1-8335-3A81-AFEC-92A65F8A93BF}']
  { getters & setters } 

    function get_Item(index: Int32): DNCheckBox;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds a checkBox to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="height">Height of checkBox, in unit of pixel.</param>
    ///  <param name="width">Width of checkBox, in unit of pixel.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.CheckBox" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; height: Int32; width: Int32): Int32;
    function BinarySearch(item: DNCheckBox): Int32; overload;
    function BinarySearch(item: DNCheckBox; comparer: DDN.mscorlib.DNIComparer<DNCheckBox>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNCheckBox; comparer: DDN.mscorlib.DNIComparer<DNCheckBox>): Int32; overload;
    function &Contains(item: DNCheckBox): Boolean;
    procedure CopyTo(&array: TArray<DNCheckBox>); overload;
    procedure CopyTo(&array: TArray<DNCheckBox>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNCheckBox>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNCheckBox>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNCheckBox>): DNCheckBox;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNCheckBox>): DDN.mscorlib.DNList<DNCheckBox>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNCheckBox>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNCheckBox>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNCheckBox>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNCheckBox>): DNCheckBox;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNCheckBox>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNCheckBox>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNCheckBox>): Int32; overload;
    function IndexOf(item: DNCheckBox): Int32; overload;
    function IndexOf(item: DNCheckBox; index: Int32): Int32; overload;
    function IndexOf(item: DNCheckBox; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNCheckBox): Int32; overload;
    function LastIndexOf(item: DNCheckBox; index: Int32): Int32; overload;
    function LastIndexOf(item: DNCheckBox; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNCheckBox>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNCheckBox read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNCheckBoxCollection = class(TDNGenericImport<DNCheckBoxCollectionClass, DNCheckBoxCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNGradientStopCollectionClass = interface(DNObjectClass)
  ['{2A48E7D8-05C7-5E5F-8830-BCEBA4AD8DC6}']
  end;

  ///<summary>
  ///  Represents the gradient stop collection.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.GradientStopCollection')]
  DNGradientStopCollection = interface(DNObject)
  ['{60364C74-7E8E-3598-BB9B-81119452BFD6}']
  { getters & setters } 

    function get_Item(index: Int32): DNGradientStop;
    procedure set_Item(index: Int32; value: DNGradientStop);
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Add a gradient stop.
    ///</summary>
    ///  <param name="position">The position of the stop,in unit of percentage.</param>
    ///  <param name="color">The color of the stop.</param>
    ///  <param name="alpha">The alpha of the color.</param>
    procedure Add(position: Double; color: DNCellsColor; alpha: Int32); overload;
    ///<summary>
    ///  Add a gradient stop.
    ///</summary>
    ///  <param name="position">The position of the stop,in unit of percentage.</param>
    ///  <param name="color">The color of the stop.</param>
    ///  <param name="alpha">The alpha of the color.</param>
    procedure Add(position: Double; color: DDN.System.Drawing.DNColor; alpha: Int32); overload;
    function BinarySearch(item: DNGradientStop): Int32; overload;
    function BinarySearch(item: DNGradientStop; comparer: DDN.mscorlib.DNIComparer<DNGradientStop>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNGradientStop; comparer: DDN.mscorlib.DNIComparer<DNGradientStop>): Int32; overload;
    function &Contains(item: DNGradientStop): Boolean;
    procedure CopyTo(&array: TArray<DNGradientStop>); overload;
    procedure CopyTo(&array: TArray<DNGradientStop>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNGradientStop>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNGradientStop>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNGradientStop>): DNGradientStop;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNGradientStop>): DDN.mscorlib.DNList<DNGradientStop>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNGradientStop>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNGradientStop>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNGradientStop>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNGradientStop>): DNGradientStop;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNGradientStop>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNGradientStop>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNGradientStop>): Int32; overload;
    function IndexOf(item: DNGradientStop): Int32; overload;
    function IndexOf(item: DNGradientStop; index: Int32): Int32; overload;
    function IndexOf(item: DNGradientStop; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNGradientStop): Int32; overload;
    function LastIndexOf(item: DNGradientStop; index: Int32): Int32; overload;
    function LastIndexOf(item: DNGradientStop; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNGradientStop>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNGradientStop read get_Item write set_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNGradientStopCollection = class(TDNGenericImport<DNGradientStopCollectionClass, DNGradientStopCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNOleObjectCollectionClass = interface(DNObjectClass)
  ['{7A0C0A79-71D4-516D-AB76-226F8EE26743}']
  end;

  ///<summary>
  ///  Represents embedded OLE objects.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.OleObjectCollection')]
  DNOleObjectCollection = interface(DNObject)
  ['{9555C2C5-FEA8-3673-AB0D-16B56CCC884D}']
  { getters & setters } 

    function get_Item(index: Int32): DNOleObject;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds an OleObject to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="height">Height of oleObject, in unit of pixel.</param>
    ///  <param name="width">Width of oleObject, in unit of pixel.</param>
    ///  <param name="imageData"> Image of ole object as byte array.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.OleObject" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; height: Int32; width: Int32; imageData: TArray<Byte>): Int32; overload;
    ///<summary>
    ///  Adds an linked OleObject to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="height">Height of oleObject, in unit of pixel.</param>
    ///  <param name="width">Width of oleObject, in unit of pixel.</param>
    ///  <param name="imageData"> Image of ole object as byte array.</param>
    ///  <param name="linkedFile"></param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.OleObject" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; height: Int32; width: Int32; imageData: TArray<Byte>; linkedFile: string): Int32; overload;
    ///<summary>
    ///  Remove all embedded OLE objects.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Removes the element at the specified index.
    ///</summary>
    ///  <param name="index">The specified index.</param>
    procedure RemoveAt(index: Int32);
    function BinarySearch(item: DNOleObject): Int32; overload;
    function BinarySearch(item: DNOleObject; comparer: DDN.mscorlib.DNIComparer<DNOleObject>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNOleObject; comparer: DDN.mscorlib.DNIComparer<DNOleObject>): Int32; overload;
    function &Contains(item: DNOleObject): Boolean;
    procedure CopyTo(&array: TArray<DNOleObject>); overload;
    procedure CopyTo(&array: TArray<DNOleObject>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNOleObject>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNOleObject>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNOleObject>): DNOleObject;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNOleObject>): DDN.mscorlib.DNList<DNOleObject>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNOleObject>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNOleObject>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNOleObject>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNOleObject>): DNOleObject;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNOleObject>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNOleObject>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNOleObject>): Int32; overload;
    function IndexOf(item: DNOleObject): Int32; overload;
    function IndexOf(item: DNOleObject; index: Int32): Int32; overload;
    function IndexOf(item: DNOleObject; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNOleObject): Int32; overload;
    function LastIndexOf(item: DNOleObject; index: Int32): Int32; overload;
    function LastIndexOf(item: DNOleObject; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNOleObject>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNOleObject read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNOleObjectCollection = class(TDNGenericImport<DNOleObjectCollectionClass, DNOleObjectCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNPictureCollectionClass = interface(DNObjectClass)
  ['{87A756EF-C343-588D-90A9-9CBB8EA5C627}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.Drawing.Picture" />
  ///  objects.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.PictureCollection')]
  DNPictureCollection = interface(DNObject)
  ['{1166BD18-DB39-3B1A-894B-DCE82A0838FC}']
  { getters & setters } 

    function get_Item(index: Int32): DNPicture;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds a picture to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="lowerRightRow">Lower right row index</param>
    ///  <param name="lowerRightColumn">Lower right column index</param>
    ///  <param name="stream">Stream object which contains the image data.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; lowerRightRow: Int32; lowerRightColumn: Int32; stream: DDN.mscorlib.DNStream): Int32; overload;
    ///<summary>
    ///  Adds a picture to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="lowerRightRow">Lower right row index</param>
    ///  <param name="lowerRightColumn">Lower right column index</param>
    ///  <param name="fileName">Image filename.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; lowerRightRow: Int32; lowerRightColumn: Int32; fileName: string): Int32; overload;
    ///<summary>
    ///  Adds a picture to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="stream">Stream object which contains the image data.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; stream: DDN.mscorlib.DNStream): Int32; overload;
    ///<summary>
    ///  Adds a picture to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="fileName">Image filename.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; fileName: string): Int32; overload;
    ///<summary>
    ///  Adds a picture to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="stream">Stream object which contains the image data.</param>
    ///  <param name="widthScale">Scale of image width, a percentage.</param>
    ///  <param name="heightScale">Scale of image height, a percentage.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; stream: DDN.mscorlib.DNStream; widthScale: Int32; heightScale: Int32): Int32; overload;
    ///<summary>
    ///  Adds a picture to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="fileName">Image filename.</param>
    ///  <param name="widthScale">Scale of image width, a percentage.</param>
    ///  <param name="heightScale">Scale of image height, a percentage.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; fileName: string; widthScale: Int32; heightScale: Int32): Int32; overload;
    ///<summary>
    ///  Clear all pictures.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Remove shapes at the specific index
    ///</summary>
    procedure RemoveAt(index: Int32);
    function BinarySearch(item: DNPicture): Int32; overload;
    function BinarySearch(item: DNPicture; comparer: DDN.mscorlib.DNIComparer<DNPicture>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNPicture; comparer: DDN.mscorlib.DNIComparer<DNPicture>): Int32; overload;
    function &Contains(item: DNPicture): Boolean;
    procedure CopyTo(&array: TArray<DNPicture>); overload;
    procedure CopyTo(&array: TArray<DNPicture>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNPicture>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNPicture>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNPicture>): DNPicture;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNPicture>): DDN.mscorlib.DNList<DNPicture>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNPicture>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNPicture>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNPicture>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNPicture>): DNPicture;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNPicture>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNPicture>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNPicture>): Int32; overload;
    function IndexOf(item: DNPicture): Int32; overload;
    function IndexOf(item: DNPicture; index: Int32): Int32; overload;
    function IndexOf(item: DNPicture; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNPicture): Int32; overload;
    function LastIndexOf(item: DNPicture; index: Int32): Int32; overload;
    function LastIndexOf(item: DNPicture; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNPicture>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNPicture read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNPictureCollection = class(TDNGenericImport<DNPictureCollectionClass, DNPictureCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNShapeCollectionClass = interface(DNObjectClass)
  ['{4DFF8958-599A-511C-8D6E-4E6BD90064A7}']
  end;

  ///<summary>
  ///  Represents all the shape in a worksheet/chart.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ShapeCollection')]
  DNShapeCollection = interface(DNObject)
  ['{EBE27A46-6B0A-3F39-AA95-4914A9D2F4C1}']
  { getters & setters } 

    function get_Item(index: Int32): DNShape; overload;
    function get_Item(name: string): DNShape; overload;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds and copy a shape to the worksheet..
    ///</summary>
    ///  <param name="sourceShape"> Source shape.</param>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of checkbox from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of textbox from its left column, in unit of pixel. </param>
    ///<returns>The new shape object index.</returns>
    function AddCopy(sourceShape: DNShape; upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32): DNShape;
    ///<summary>
    ///  Adds a checkbox to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of checkbox from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of textbox from its left column, in unit of pixel. </param>
    ///  <param name="height">Height of textbox, in unit of pixel.</param>
    ///  <param name="width">Width of textbox, in unit of pixel.</param>
    ///<returns>The new CheckBox object index.</returns>
    function AddCheckBox(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNCheckBox;
    ///<summary>
    ///  Adds a text box to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of textbox from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of textbox from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of textbox, in unit of pixel. </param>
    ///  <param name="width">Represents the width of textbox, in unit of pixel. </param>
    ///<returns>A <see cref="T:Aspose.Cells.Drawing.TextBox" />
    ///  object.</returns>
    function AddTextBox(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNTextBox;
    ///<summary>
    ///  Adds a Spinner to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of Spinner from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of Spinner from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of Spinner, in unit of pixel. </param>
    ///  <param name="width">Represents the width of Spinner, in unit of pixel. </param>
    ///<returns>A Spinner object.</returns>
    function AddSpinner(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNSpinner;
    ///<summary>
    ///  Adds a ScrollBar to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of ScrollBar from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of ScrollBar from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of ScrollBar, in unit of pixel. </param>
    ///  <param name="width">Represents the width of ScrollBar, in unit of pixel. </param>
    ///<returns>A ScrollBar object.</returns>
    function AddScrollBar(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNScrollBar;
    ///<summary>
    ///  Adds a RadioButton to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of RadioButton from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of RadioButton from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of RadioButton, in unit of pixel. </param>
    ///  <param name="width">Represents the width of RadioButton, in unit of pixel. </param>
    ///<returns>A RadioButton object.</returns>
    function AddRadioButton(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNRadioButton;
    ///<summary>
    ///  Adds a ListBox to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of ListBox from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of ListBox from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of ListBox, in unit of pixel. </param>
    ///  <param name="width">Represents the width of ListBox, in unit of pixel. </param>
    ///<returns>A ListBox object.</returns>
    function AddListBox(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNListBox;
    ///<summary>
    ///  Adds a ComboBox to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of ComboBox from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of ComboBox from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of ComboBox, in unit of pixel. </param>
    ///  <param name="width">Represents the width of ComboBox, in unit of pixel. </param>
    ///<returns>A ComboBox object.</returns>
    function AddComboBox(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNComboBox;
    ///<summary>
    ///  Adds a GroupBox to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of GroupBox from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of GroupBox from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of GroupBox, in unit of pixel. </param>
    ///  <param name="width">Represents the width of GroupBox, in unit of pixel. </param>
    ///<returns>A GroupBox object.</returns>
    function AddGroupBox(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNGroupBox;
    ///<summary>
    ///  Adds a Button to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of Button from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of Button from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of Button, in unit of pixel. </param>
    ///  <param name="width">Represents the width of Button, in unit of pixel. </param>
    ///<returns>A Button object.</returns>
    function AddButton(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNButton;
    ///<summary>
    ///  Adds a Label to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of Label from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of Label from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of Label, in unit of pixel. </param>
    ///  <param name="width">Represents the width of Label, in unit of pixel. </param>
    ///<returns>A Label object.</returns>
    function AddLabel(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNLabel;
    ///<summary>
    ///  Adds a label to the chart.
    ///</summary>
    ///  <param name="top">Represents the vertical offset of label from the upper left corner in units of 1/4000 of the chart area. </param>
    ///  <param name="left">Represents the vertical offset of label from the upper left corner in units of 1/4000 of the chart area.</param>
    ///  <param name="height">Represents the height of label, in units of 1/4000 of the chart area.</param>
    ///  <param name="width">Represents the width of label, in units of 1/4000 of the chart area.</param>
    ///<returns>A new Label object.</returns>
    function AddLabelInChart(top: Int32; left: Int32; height: Int32; width: Int32): DNLabel;
    ///<summary>
    ///  Adds a textbox to the chart.
    ///</summary>
    ///  <param name="top">Represents the vertical offset of textbox from the upper left corner in units of 1/4000 of the chart area. </param>
    ///  <param name="left">Represents the vertical offset of textbox from the upper left corner in units of 1/4000 of the chart area.</param>
    ///  <param name="height">Represents the height of textbox, in units of 1/4000 of the chart area.</param>
    ///  <param name="width">Represents the width of textbox, in units of 1/4000 of the chart area.</param>
    ///<returns>A TextBox object.</returns>
    function AddTextBoxInChart(top: Int32; left: Int32; height: Int32; width: Int32): DNTextBox;
    ///<summary>
    ///  Inserts a WordArt object to the chart
    ///</summary>
    ///  <param name="effect">The mso preset text effect type.</param>
    ///  <param name="text">The WordArt text.</param>
    ///  <param name="fontName">The font name.</param>
    ///  <param name="size">The font size</param>
    ///  <param name="fontBold">Indicates whether font is bold.</param>
    ///  <param name="fontItalic">Indicates whether font is italic.</param>
    ///  <param name="top">Represents the vertical offset of shape from the upper left corner in units of 1/4000 of the chart area. </param>
    ///  <param name="left">Represents the vertical offset of shape from the upper left corner in units of 1/4000 of the chart area.</param>
    ///  <param name="height">Represents the height of shape, in units of 1/4000 of the chart area.</param>
    ///  <param name="width">Represents the width of shape, in units of 1/4000 of the chart area.</param>
    ///<returns>Returns a Shape object that represents the new WordArt object.</returns>
    function AddTextEffectInChart(effect: DNMsoPresetTextEffect; text: string; fontName: string; size: Int32; fontBold: Boolean; fontItalic: Boolean; top: Int32; left: Int32; height: Int32; width: Int32): DNShape;
    ///<summary>
    ///  Inserts a WordArt object.
    ///</summary>
    ///  <param name="effect">The mso preset text effect type.</param>
    ///  <param name="text">The WordArt text.</param>
    ///  <param name="fontName">The font name.</param>
    ///  <param name="size">The font size</param>
    ///  <param name="fontBold">Indicates whether font is bold.</param>
    ///  <param name="fontItalic">Indicates whether font is italic.</param>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of shape from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of shape from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of shape, in unit of pixel. </param>
    ///  <param name="width">Represents the width of shape, in unit of pixel. </param>
    ///<returns>Returns a Shape object that represents the new WordArt object.</returns>
    function AddTextEffect(effect: DNMsoPresetTextEffect; text: string; fontName: string; size: Int32; fontBold: Boolean; fontItalic: Boolean; upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNShape;
    ///<summary>
    ///  Adds preset WordArt since Excel 2007.s
    ///</summary>
    ///  <param name="style">The preset WordArt Style.</param>
    ///  <param name="text">The text.</param>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of shape from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of shape from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of shape, in unit of pixel. </param>
    ///  <param name="width">Represents the width of shape, in unit of pixel. </param>
    ///<returns></returns>
    function AddWordArt(style: DNPresetWordArtStyle; text: string; upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNShape;
    ///<summary>
    ///  Adds a RectangleShape to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of RectangleShape from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of RectangleShape from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of RectangleShape, in unit of pixel. </param>
    ///  <param name="width">Represents the width of RectangleShape, in unit of pixel. </param>
    ///<returns>A RectangleShape object.</returns>
    function AddRectangle(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNRectangleShape;
    ///<summary>
    ///  Adds a Oval to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of Oval from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of Oval from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of Oval, in unit of pixel. </param>
    ///  <param name="width">Represents the width of Oval, in unit of pixel. </param>
    ///<returns>A Oval object.</returns>
    function AddOval(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNOval;
    ///<summary>
    ///  Adds a LineShape to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of LineShape from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of LineShape from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of LineShape, in unit of pixel. </param>
    ///  <param name="width">Represents the width of LineShape, in unit of pixel. </param>
    ///<returns>A LineShape object.</returns>
    function AddLine(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNLineShape;
    ///<summary>
    ///  Adds a free floating shape to the worksheet.Only applies for line/image shape.
    ///</summary>
    ///  <param name="type">The shape type.</param>
    ///  <param name="top">Represents the vertical  offset of shape from the worksheet's top row, in unit of pixel.</param>
    ///  <param name="left">Represents the horizontal offset of shape from the worksheet's left column, in unit of pixel.</param>
    ///  <param name="height">Represents the height of LineShape, in unit of pixel. </param>
    ///  <param name="width">Represents the width of LineShape, in unit of pixel. </param>
    ///  <param name="imageData">The image data,only applies for the picture.</param>
    ///  <param name="isOriginalSize">Whether the shape use original size if the shape is image.</param>
    ///<returns></returns>
    function AddFreeFloatingShape(&type: DNMsoDrawingType; top: Int32; left: Int32; height: Int32; width: Int32; imageData: TArray<Byte>; isOriginalSize: Boolean): DNShape;
    ///<summary>
    ///  Add a shape to chart .All unit is 1/4000 of chart area.
    ///</summary>
    ///  <param name="type">The drawing type.</param>
    ///  <param name="placement">the placement type.</param>
    ///  <param name="left">In unit of 1/4000 chart area width.</param>
    ///  <param name="top">In unit of 1/4000 chart area height.</param>
    ///  <param name="right">In unit of 1/4000 chart area width.</param>
    ///  <param name="bottom">In unit of 1/4000 chart area height.</param>
    ///  <param name="imageData">If the shape is not a picture or ole object,imageData should be null.</param>
    function AddShapeInChart(&type: DNMsoDrawingType; placement: DNPlacementType; left: Int32; top: Int32; right: Int32; bottom: Int32; imageData: TArray<Byte>): DNShape; overload;
    ///<summary>
    ///  Add a shape to chart .All unit is 1/4000 of chart area.
    ///</summary>
    ///  <param name="type">The drawing type.</param>
    ///  <param name="placement">the placement type.</param>
    ///  <param name="left">In unit of 1/4000 chart area width.</param>
    ///  <param name="top">In unit of 1/4000 chart area height.</param>
    ///  <param name="right">In unit of 1/4000 chart area width.</param>
    ///  <param name="bottom">In unit of 1/4000 chart area height.</param>
    function AddShapeInChart(&type: DNMsoDrawingType; placement: DNPlacementType; left: Int32; top: Int32; right: Int32; bottom: Int32): DNShape; overload;
    ///<summary>
    ///  Adds a ArcShape to the worksheet.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of ArcShape from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of ArcShape from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of ArcShape, in unit of pixel. </param>
    ///  <param name="width">Represents the width of ArcShape, in unit of pixel. </param>
    ///<returns>A ArcShape object.</returns>
    function AddArc(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNArcShape;
    ///<summary>
    ///  Adds a Shape to the worksheet.
    ///</summary>
    ///  <param name="type">Mso drawing type.</param>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of Shape from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of Shape from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of Shape, in unit of pixel. </param>
    ///  <param name="width">Represents the width of Shape, in unit of pixel. </param>
    ///<returns>A Shape object.</returns>
    ///<remarks>The type could not be Chart/Comment/Picture/OleObject/Polygon/DialogBox</remarks>
    function AddShape(&type: DNMsoDrawingType; upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNShape;
    ///<summary>
    ///  Adds a AutoShape to the worksheet.
    ///</summary>
    ///  <param name="type">Auto shape type.</param>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of Shape from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of Shape from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of Shape, in unit of pixel. </param>
    ///  <param name="width">Represents the width of Shape, in unit of pixel. </param>
    ///<returns>A Shape object.</returns>
    ///<remarks>The type could not be Chart/Comment/Picture/OleObject/Polygon/DialogBox</remarks>
    function AddAutoShape(&type: DNAutoShapeType; upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32): DNShape;
    ///<summary>
    ///  Adds a AutoShape to the chart.
    ///</summary>
    ///  <param name="type">Auto shape type.</param>
    ///  <param name="top">Represents the vertical offset of textbox from the upper left corner in units of 1/4000 of the chart area. </param>
    ///  <param name="left">Represents the vertical offset of textbox from the upper left corner in units of 1/4000 of the chart area.</param>
    ///  <param name="height">Represents the height of textbox, in units of 1/4000 of the chart area.</param>
    ///  <param name="width">Represents the width of textbox, in units of 1/4000 of the chart area.</param>
    ///<returns>Returns a shape object.</returns>
    ///<remarks>The type could not be Chart/Comment/Picture/OleObject/Polygon/DialogBox</remarks>
    function AddAutoShapeInChart(&type: DNAutoShapeType; top: Int32; left: Int32; height: Int32; width: Int32): DNShape;
    ///<summary>
    ///  Creates an Activex Control.
    ///</summary>
    ///  <param name="type">The type of the control.</param>
    ///  <param name="topRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of Shape from its left row, in unit of pixel. </param>
    ///  <param name="leftColumn">Upper left column index.</param>
    ///  <param name="left">Represents the horizontal offset of Shape from its left column, in unit of pixel. </param>
    ///  <param name="height">Represents the height of Shape, in unit of pixel. </param>
    ///  <param name="width">Represents the width of Shape, in unit of pixel. </param>
    ///<returns></returns>
    function AddActiveXControl(&type: DNControlType; topRow: Int32; top: Int32; leftColumn: Int32; left: Int32; width: Int32; height: Int32): DNShape;
    ///<summary>
    ///  Adds a picture to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="lowerRightRow">Lower right row index</param>
    ///  <param name="lowerRightColumn">Lower right column index</param>
    ///  <param name="stream">Stream object which contains the image data.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  Picture object.</returns>
    function AddPicture(upperLeftRow: Int32; upperLeftColumn: Int32; lowerRightRow: Int32; lowerRightColumn: Int32; stream: DDN.mscorlib.DNStream): DNPicture; overload;
    ///<summary>
    ///  Adds a picture to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="stream">Stream object which contains the image data.</param>
    ///  <param name="widthScale">Scale of image width, a percentage.</param>
    ///  <param name="heightScale">Scale of image height, a percentage.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  Picture object.</returns>
    function AddPicture(upperLeftRow: Int32; upperLeftColumn: Int32; stream: DDN.mscorlib.DNStream; widthScale: Int32; heightScale: Int32): DNPicture; overload;
    ///<summary>
    ///  Adds svg image.
    ///</summary>
    ///  <param name="upperLeftRow"> Upper left row index.</param>
    ///  <param name="top">Represents the vertical  offset of shape from its left row, in unit of pixel. </param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="left">The horizontal offset of shape from its left column, in unit of pixel. </param>
    ///  <param name="height">The height of shape, in unit of pixel. </param>
    ///  <param name="width">The width of shape, in unit of pixel. </param>
    ///  <param name="svgData">The svg image data.</param>
    ///  <param name="compatibleImageData">Converted image data from svg in order to be compatible with Excel 2016 or lower versions.</param>
    ///<returns></returns>
    function AddSvg(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32; svgData: TArray<Byte>; compatibleImageData: TArray<Byte>): DNPicture;
    ///<summary>
    ///  Add a linked picture.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="height">The height of the shape. In unit of pixels</param>
    ///  <param name="width">The width of the shape. In unit of pixels</param>
    ///  <param name="sourceFullName">
    ///  The path and name of the source file for the linked image</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  Picture object.</returns>
    function AddLinkedPicture(upperLeftRow: Int32; upperLeftColumn: Int32; height: Int32; width: Int32; sourceFullName: string): DNPicture;
    ///<summary>
    ///  Add a linked picture.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="height">The height of the shape. In unit of pixels</param>
    ///  <param name="width">The width of the shape. In unit of pixels</param>
    ///  <param name="sourceFullName">
    ///  The path and name of the source file for the linked image</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.Picture" />
    ///  Picture object.</returns>
    function AddOleObjectWithLinkedImage(upperLeftRow: Int32; upperLeftColumn: Int32; height: Int32; width: Int32; sourceFullName: string): DNOleObject;
    ///<summary>
    ///  Adds a picture to the chart.
    ///</summary>
    ///  <param name="top">Represents the vertical offset of shape from the upper left corner in units of 1/4000 of the chart area. </param>
    ///  <param name="left">Represents the horizontal offset of shape from the upper left corner in units of 1/4000 of the chart area.</param>
    ///  <param name="stream">Stream object which contains the image data.</param>
    ///  <param name="widthScale">Scale of image width, a percentage.</param>
    ///  <param name="heightScale">Scale of image height, a percentage.</param>
    ///<returns>Returns a Picture object.</returns>
    function AddPictureInChart(top: Int32; left: Int32; stream: DDN.mscorlib.DNStream; widthScale: Int32; heightScale: Int32): DNPicture;
    ///<summary></summary>
    ///  <param name="upperLeftRow"></param>
    ///  <param name="top"></param>
    ///  <param name="upperLeftColumn"></param>
    ///  <param name="left"></param>
    ///  <param name="height"></param>
    ///  <param name="width"></param>
    ///  <param name="imageData"></param>
    ///<returns></returns>
    function AddOleObject(upperLeftRow: Int32; top: Int32; upperLeftColumn: Int32; left: Int32; height: Int32; width: Int32; imageData: TArray<Byte>): DNOleObject;
    ///<summary>
    ///  Copy all comments in the range.
    ///</summary>
    ///  <param name="shapes">The source shapes.</param>
    ///  <param name="ca">The source range.</param>
    ///  <param name="destRow">The dest range start row.</param>
    ///  <param name="destColumn">The dest range start column.</param>
    procedure CopyCommentsInRange(shapes: DNShapeCollection; ca: DNCellArea; destRow: Int32; destColumn: Int32);
    ///<summary>
    ///  Copy shapes in the range to destination range.
    ///</summary>
    ///  <param name="sourceShapes">Source shapes.</param>
    ///  <param name="ca">The source range.</param>
    ///  <param name="destRow">The dest row index of the dest range.</param>
    ///  <param name="destColumn">The dest column of the dest range.</param>
    ///  <param name="isContained">Whether only copy the shapes which are contained in the range.
    ///  If true,only copies the shapes in the range.
    ///  Otherwise,it works as MS Office.</param>
    procedure CopyInRange(sourceShapes: DNShapeCollection; ca: DNCellArea; destRow: Int32; destColumn: Int32; isContained: Boolean);
    ///<summary>
    ///  Delete shapes in the range.Comment shapes will not be deleted.
    ///</summary>
    ///  <param name="ca">The range.If the shapes are contained in the range, they will be removed.</param>
    procedure DeleteInRange(ca: DNCellArea);
    ///<summary>
    ///  Delete a shape. If the shape is in the group or is a comment shape, it will not be deleted.
    ///</summary>
    ///  <param name="shape"></param>
    procedure DeleteShape(shape: DNShape);
    ///<summary>
    ///  Group the shapes.
    ///</summary>
    ///  <param name="groupItems">the group items.</param>
    ///<returns>Return the group shape.</returns>
    ///<remarks>
    ///  The shape in the groupItems should not be grouped.
    ///  The shape must be in this Shapes collection.</remarks>
    function Group(groupItems: TArray<DNShape>): DNGroupShape;
    ///<summary>
    ///  Ungroups the shape items.
    ///</summary>
    ///  <param name="group">The group shape.</param>
    ///<remarks>If the group shape is grouped by another group shape,nothing will be done.</remarks>
    procedure Ungroup(group: DNGroupShape);
    ///<summary>
    ///  Remove the shape.
    ///</summary>
    ///  <param name="index">The index of the shape.</param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Remove the shape.
    ///</summary>
    ///  <param name="shape"></param>
    procedure Remove(shape: DNShape);
    ///<summary>
    ///  Clear all shapes.
    ///</summary>
    procedure Clear;
    ///<summary>
    ///  Update the selected value by the value of the linked cell of the shapes.
    ///</summary>
    procedure UpdateSelectedValue;
    function BinarySearch(item: DNShape): Int32; overload;
    function BinarySearch(item: DNShape; comparer: DDN.mscorlib.DNIComparer<DNShape>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNShape; comparer: DDN.mscorlib.DNIComparer<DNShape>): Int32; overload;
    function &Contains(item: DNShape): Boolean;
    procedure CopyTo(&array: TArray<DNShape>); overload;
    procedure CopyTo(&array: TArray<DNShape>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNShape>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNShape>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNShape>): DNShape;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNShape>): DDN.mscorlib.DNList<DNShape>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNShape>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShape>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShape>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNShape>): DNShape;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNShape>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShape>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShape>): Int32; overload;
    function IndexOf(item: DNShape): Int32; overload;
    function IndexOf(item: DNShape; index: Int32): Int32; overload;
    function IndexOf(item: DNShape; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNShape): Int32; overload;
    function LastIndexOf(item: DNShape; index: Int32): Int32; overload;
    function LastIndexOf(item: DNShape; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNShape>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNShape read get_Item; default;
    property Item[name: string]: DNShape read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNShapeCollection = class(TDNGenericImport<DNShapeCollectionClass, DNShapeCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNShapeGuideCollectionClass = interface(DNObjectClass)
  ['{5B716042-8EB6-53C1-9ACB-DAACE60B40E3}']
  { constructors } 

    {class} function init: DNShapeGuideCollection;

  end;

  ///<summary>
  ///  Encapsulates a collection of shape guide
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ShapeGuideCollection')]
  DNShapeGuideCollection = interface(DNObject)
  ['{DA39FE8E-AE5C-332B-A4F1-582470B06837}']
  { getters & setters } 

    function get_Item(index: Int32): DNShapeGuide;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    function BinarySearch(item: DNShapeGuide): Int32; overload;
    function BinarySearch(item: DNShapeGuide; comparer: DDN.mscorlib.DNIComparer<DNShapeGuide>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNShapeGuide; comparer: DDN.mscorlib.DNIComparer<DNShapeGuide>): Int32; overload;
    function &Contains(item: DNShapeGuide): Boolean;
    procedure CopyTo(&array: TArray<DNShapeGuide>); overload;
    procedure CopyTo(&array: TArray<DNShapeGuide>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNShapeGuide>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNShapeGuide>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNShapeGuide>): DNShapeGuide;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNShapeGuide>): DDN.mscorlib.DNList<DNShapeGuide>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNShapeGuide>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShapeGuide>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShapeGuide>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNShapeGuide>): DNShapeGuide;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNShapeGuide>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShapeGuide>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShapeGuide>): Int32; overload;
    function IndexOf(item: DNShapeGuide): Int32; overload;
    function IndexOf(item: DNShapeGuide; index: Int32): Int32; overload;
    function IndexOf(item: DNShapeGuide; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNShapeGuide): Int32; overload;
    function LastIndexOf(item: DNShapeGuide; index: Int32): Int32; overload;
    function LastIndexOf(item: DNShapeGuide; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNShapeGuide>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNShapeGuide read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNShapeGuideCollection = class(TDNGenericImport<DNShapeGuideCollectionClass, DNShapeGuideCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNShapePathCollectionClass = interface(DNObjectClass)
  ['{87B6DA48-8E5B-549F-AADE-2CB3893950F0}']
  end;

  ///<summary>
  ///  Represents path collection information in NotPrimitive autoshape
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ShapePathCollection')]
  DNShapePathCollection = interface(DNObject)
  ['{895E78F1-941B-3D5E-A8E8-6EF8CCF43373}']
  { getters & setters } 

    function get_Count: Int32;
    function get_Item(index: Int32): DNShapePath;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);

  { methods } 

    ///<summary>
    ///  Add a creation path.
    ///</summary>
    ///<returns>Returns <see cref="T:Aspose.Cells.Drawing.ShapePath" />
    ///  object.</returns>
    function Add: Int32;
    function BinarySearch(item: DNShapePath): Int32; overload;
    function BinarySearch(item: DNShapePath; comparer: DDN.mscorlib.DNIComparer<DNShapePath>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNShapePath; comparer: DDN.mscorlib.DNIComparer<DNShapePath>): Int32; overload;
    function &Contains(item: DNShapePath): Boolean;
    procedure CopyTo(&array: TArray<DNShapePath>); overload;
    procedure CopyTo(&array: TArray<DNShapePath>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNShapePath>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNShapePath>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNShapePath>): DNShapePath;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNShapePath>): DDN.mscorlib.DNList<DNShapePath>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNShapePath>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShapePath>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShapePath>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNShapePath>): DNShapePath;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNShapePath>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShapePath>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShapePath>): Int32; overload;
    function IndexOf(item: DNShapePath): Int32; overload;
    function IndexOf(item: DNShapePath; index: Int32): Int32; overload;
    function IndexOf(item: DNShapePath; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNShapePath): Int32; overload;
    function LastIndexOf(item: DNShapePath; index: Int32): Int32; overload;
    function LastIndexOf(item: DNShapePath; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNShapePath>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Gets the count of paths
    ///</summary>
    property Count: Int32 read get_Count;
    property Item[index: Int32]: DNShapePath read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
  end;

  TDNShapePathCollection = class(TDNGenericImport<DNShapePathCollectionClass, DNShapePathCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNShapePathPointCollectionClass = interface(DNObjectClass)
  ['{569540DE-615D-5BB2-8357-0D4A92BBD3EF}']
  { constructors } 

    {class} function init: DNShapePathPointCollection;

  end;

  ///<summary>
  ///  Represents all shape path points.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ShapePathPointCollection')]
  DNShapePathPointCollection = interface(DNObject)
  ['{08F5C4FA-DEC5-31B6-A829-A8098AE0A4A4}']
  { getters & setters } 

    function get_Item(index: Int32): DNShapePathPoint;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds a path point.
    ///</summary>
    ///  <param name="x">The x coordinate.</param>
    ///  <param name="y">The y coordinate.</param>
    function Add(x: Int32; y: Int32): Int32;
    function BinarySearch(item: DNShapePathPoint): Int32; overload;
    function BinarySearch(item: DNShapePathPoint; comparer: DDN.mscorlib.DNIComparer<DNShapePathPoint>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNShapePathPoint; comparer: DDN.mscorlib.DNIComparer<DNShapePathPoint>): Int32; overload;
    function &Contains(item: DNShapePathPoint): Boolean;
    procedure CopyTo(&array: TArray<DNShapePathPoint>); overload;
    procedure CopyTo(&array: TArray<DNShapePathPoint>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNShapePathPoint>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): DNShapePathPoint;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): DDN.mscorlib.DNList<DNShapePathPoint>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): DNShapePathPoint;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShapePathPoint>): Int32; overload;
    function IndexOf(item: DNShapePathPoint): Int32; overload;
    function IndexOf(item: DNShapePathPoint; index: Int32): Int32; overload;
    function IndexOf(item: DNShapePathPoint; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNShapePathPoint): Int32; overload;
    function LastIndexOf(item: DNShapePathPoint; index: Int32): Int32; overload;
    function LastIndexOf(item: DNShapePathPoint; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNShapePathPoint>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNShapePathPoint read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNShapePathPointCollection = class(TDNGenericImport<DNShapePathPointCollectionClass, DNShapePathPointCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNShapeSegmentPathCollectionClass = interface(DNObjectClass)
  ['{C4710596-7346-5EDC-A18D-E39C183618D1}']
  { constructors } 

    {class} function init: DNShapeSegmentPathCollection;

  end;

  ///<summary>
  ///  Represents a creation path consisting of a series of moves, lines and curves that when combined will form a geometric shape.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.ShapeSegmentPathCollection')]
  DNShapeSegmentPathCollection = interface(DNObject)
  ['{97CD3E94-8120-3B24-8CF4-581EA3CCBF6A}']
  { getters & setters } 

    function get_Item(index: Int32): DNShapeSegmentPath;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Add a segment path in creation path.
    ///</summary>
    ///  <param name="type">The path type.</param>
    ///<returns>Returns the position of <see cref="T:Aspose.Cells.Drawing.ShapeSegmentPath" />
    ///  object in the list. </returns>
    function Add(&type: DNShapePathType): Int32;
    function BinarySearch(item: DNShapeSegmentPath): Int32; overload;
    function BinarySearch(item: DNShapeSegmentPath; comparer: DDN.mscorlib.DNIComparer<DNShapeSegmentPath>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNShapeSegmentPath; comparer: DDN.mscorlib.DNIComparer<DNShapeSegmentPath>): Int32; overload;
    function &Contains(item: DNShapeSegmentPath): Boolean;
    procedure CopyTo(&array: TArray<DNShapeSegmentPath>); overload;
    procedure CopyTo(&array: TArray<DNShapeSegmentPath>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNShapeSegmentPath>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): DNShapeSegmentPath;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): DDN.mscorlib.DNList<DNShapeSegmentPath>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): DNShapeSegmentPath;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNShapeSegmentPath>): Int32; overload;
    function IndexOf(item: DNShapeSegmentPath): Int32; overload;
    function IndexOf(item: DNShapeSegmentPath; index: Int32): Int32; overload;
    function IndexOf(item: DNShapeSegmentPath; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNShapeSegmentPath): Int32; overload;
    function LastIndexOf(item: DNShapeSegmentPath; index: Int32): Int32; overload;
    function LastIndexOf(item: DNShapeSegmentPath; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNShapeSegmentPath>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNShapeSegmentPath read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNShapeSegmentPathCollection = class(TDNGenericImport<DNShapeSegmentPathCollectionClass, DNShapeSegmentPathCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing----------------
  DNTextBoxCollectionClass = interface(DNObjectClass)
  ['{F8DE997F-0A90-5FD5-AE6B-4CFF632525C0}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.Drawing.TextBox" />
  ///  objects.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.TextBoxCollection')]
  DNTextBoxCollection = interface(DNObject)
  ['{A9C71681-AE8E-32E3-90CC-868B1F2F15B6}']
  { getters & setters } 

    function get_Item(index: Int32): DNTextBox; overload;
    function get_Item(name: string): DNTextBox; overload;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds a textbox to the collection.
    ///</summary>
    ///  <param name="upperLeftRow">Upper left row index.</param>
    ///  <param name="upperLeftColumn">Upper left column index.</param>
    ///  <param name="height">Height of textbox, in unit of pixel.</param>
    ///  <param name="width">Width of textbox, in unit of pixel.</param>
    ///<returns><see cref="T:Aspose.Cells.Drawing.TextBox" />
    ///  object index.</returns>
    function Add(upperLeftRow: Int32; upperLeftColumn: Int32; height: Int32; width: Int32): Int32;
    ///<summary>
    ///  Remove a text box from the file.
    ///</summary>
    ///  <param name="index">The text box index.</param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Clear all text boxes.
    ///</summary>
    procedure Clear;
    function BinarySearch(item: DNTextBox): Int32; overload;
    function BinarySearch(item: DNTextBox; comparer: DDN.mscorlib.DNIComparer<DNTextBox>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNTextBox; comparer: DDN.mscorlib.DNIComparer<DNTextBox>): Int32; overload;
    function &Contains(item: DNTextBox): Boolean;
    procedure CopyTo(&array: TArray<DNTextBox>); overload;
    procedure CopyTo(&array: TArray<DNTextBox>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNTextBox>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNTextBox>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNTextBox>): DNTextBox;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNTextBox>): DDN.mscorlib.DNList<DNTextBox>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNTextBox>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNTextBox>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNTextBox>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNTextBox>): DNTextBox;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNTextBox>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNTextBox>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNTextBox>): Int32; overload;
    function IndexOf(item: DNTextBox): Int32; overload;
    function IndexOf(item: DNTextBox; index: Int32): Int32; overload;
    function IndexOf(item: DNTextBox; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNTextBox): Int32; overload;
    function LastIndexOf(item: DNTextBox; index: Int32): Int32; overload;
    function LastIndexOf(item: DNTextBox; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNTextBox>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNTextBox read get_Item; default;
    property Item[name: string]: DNTextBox read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNTextBoxCollection = class(TDNGenericImport<DNTextBoxCollectionClass, DNTextBoxCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing.Texts----------------
  DNTextTabStopCollectionClass = interface(DNObjectClass)
  ['{BC0B1EEE-D7C3-5219-88A8-B5A239CE86DF}']
  { constructors } 

    {class} function init: DNTextTabStopCollection;

  end;

  ///<summary>
  ///  Represents the list of all tab stops.
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.Texts.TextTabStopCollection')]
  DNTextTabStopCollection = interface(DNObject)
  ['{5603C5BA-2C0E-3D47-925D-E81A3A6BE216}']
  { getters & setters } 

    function get_Item(index: Int32): DNTextTabStop;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds a tab stop.
    ///</summary>
    ///  <param name="tabAlignment"></param>
    ///  <param name="tabPosition"></param>
    ///<returns></returns>
    function Add(tabAlignment: DNTextTabAlignmentType; tabPosition: Double): Int32;
    function BinarySearch(item: DNTextTabStop): Int32; overload;
    function BinarySearch(item: DNTextTabStop; comparer: DDN.mscorlib.DNIComparer<DNTextTabStop>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNTextTabStop; comparer: DDN.mscorlib.DNIComparer<DNTextTabStop>): Int32; overload;
    function &Contains(item: DNTextTabStop): Boolean;
    procedure CopyTo(&array: TArray<DNTextTabStop>); overload;
    procedure CopyTo(&array: TArray<DNTextTabStop>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNTextTabStop>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNTextTabStop>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNTextTabStop>): DNTextTabStop;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNTextTabStop>): DDN.mscorlib.DNList<DNTextTabStop>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNTextTabStop>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNTextTabStop>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNTextTabStop>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNTextTabStop>): DNTextTabStop;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNTextTabStop>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNTextTabStop>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNTextTabStop>): Int32; overload;
    function IndexOf(item: DNTextTabStop): Int32; overload;
    function IndexOf(item: DNTextTabStop; index: Int32): Int32; overload;
    function IndexOf(item: DNTextTabStop; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNTextTabStop): Int32; overload;
    function LastIndexOf(item: DNTextTabStop; index: Int32): Int32; overload;
    function LastIndexOf(item: DNTextTabStop; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNTextTabStop>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNTextTabStop read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNTextTabStopCollection = class(TDNGenericImport<DNTextTabStopCollectionClass, DNTextTabStopCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNErrorCheckOptionCollectionClass = interface(DNObjectClass)
  ['{AED4BD6D-3369-5921-BA8D-636A7C0001F4}']
  end;

  ///<summary>
  ///  Represents all error check option.
  ///</summary>
  [DNTypeName('Aspose.Cells.ErrorCheckOptionCollection')]
  DNErrorCheckOptionCollection = interface(DNObject)
  ['{C19EF225-F537-365A-AA6E-C378636C586A}']
  { getters & setters } 

    function get_Item(index: Int32): DNErrorCheckOption;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Add an error check option.
    ///</summary>
    ///<returns></returns>
    function Add: Int32;
    function BinarySearch(item: DNErrorCheckOption): Int32; overload;
    function BinarySearch(item: DNErrorCheckOption; comparer: DDN.mscorlib.DNIComparer<DNErrorCheckOption>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNErrorCheckOption; comparer: DDN.mscorlib.DNIComparer<DNErrorCheckOption>): Int32; overload;
    function &Contains(item: DNErrorCheckOption): Boolean;
    procedure CopyTo(&array: TArray<DNErrorCheckOption>); overload;
    procedure CopyTo(&array: TArray<DNErrorCheckOption>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNErrorCheckOption>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): DNErrorCheckOption;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): DDN.mscorlib.DNList<DNErrorCheckOption>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): DNErrorCheckOption;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNErrorCheckOption>): Int32; overload;
    function IndexOf(item: DNErrorCheckOption): Int32; overload;
    function IndexOf(item: DNErrorCheckOption; index: Int32): Int32; overload;
    function IndexOf(item: DNErrorCheckOption; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNErrorCheckOption): Int32; overload;
    function LastIndexOf(item: DNErrorCheckOption; index: Int32): Int32; overload;
    function LastIndexOf(item: DNErrorCheckOption; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNErrorCheckOption>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNErrorCheckOption read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNErrorCheckOptionCollection = class(TDNGenericImport<DNErrorCheckOptionCollectionClass, DNErrorCheckOptionCollection>) end;

  //-------------namespace: Aspose.Cells.ExternalConnections----------------
  DNConnectionParameterCollectionClass = interface(DNObjectClass)
  ['{74727973-264E-5E2B-A935-2C20078A0991}']
  end;

  ///<summary>
  ///  Specifies the <see cref="T:Aspose.Cells.ExternalConnections.ConnectionParameter" />
  ///  collection
  ///</summary>
  [DNTypeName('Aspose.Cells.ExternalConnections.ConnectionParameterCollection')]
  DNConnectionParameterCollection = interface(DNObject)
  ['{818D9DC0-EEDB-385C-9144-77AB6386ED36}']
  { getters & setters } 

    function get_Item(index: Int32): DNConnectionParameter; overload;
    procedure set_Item(index: Int32; value: DNConnectionParameter);
    function get_Item(connParamName: string): DNConnectionParameter; overload;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    function BinarySearch(item: DNConnectionParameter): Int32; overload;
    function BinarySearch(item: DNConnectionParameter; comparer: DDN.mscorlib.DNIComparer<DNConnectionParameter>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNConnectionParameter; comparer: DDN.mscorlib.DNIComparer<DNConnectionParameter>): Int32; overload;
    function &Contains(item: DNConnectionParameter): Boolean;
    procedure CopyTo(&array: TArray<DNConnectionParameter>); overload;
    procedure CopyTo(&array: TArray<DNConnectionParameter>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNConnectionParameter>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): DNConnectionParameter;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): DDN.mscorlib.DNList<DNConnectionParameter>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): DNConnectionParameter;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNConnectionParameter>): Int32; overload;
    function IndexOf(item: DNConnectionParameter): Int32; overload;
    function IndexOf(item: DNConnectionParameter; index: Int32): Int32; overload;
    function IndexOf(item: DNConnectionParameter; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNConnectionParameter): Int32; overload;
    function LastIndexOf(item: DNConnectionParameter; index: Int32): Int32; overload;
    function LastIndexOf(item: DNConnectionParameter; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNConnectionParameter>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNConnectionParameter read get_Item write set_Item; default;
    property Item[connParamName: string]: DNConnectionParameter read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNConnectionParameterCollection = class(TDNGenericImport<DNConnectionParameterCollectionClass, DNConnectionParameterCollection>) end;

  //-------------namespace: Aspose.Cells.ExternalConnections----------------
  DNExternalConnectionCollectionClass = interface(DNObjectClass)
  ['{C26D1B4E-0593-5918-87CF-8BEFA8A577B0}']
  end;

  ///<summary>
  ///  Specifies the <see cref="T:Aspose.Cells.ExternalConnections.ExternalConnection" />
  ///  collection
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  Workbook wb = new Workbook("connection.xlsx");
  ///  ExternalConnectionCollection dataConns = wb.DataConnections;
  ///  ExternalConnection dataConn = null;
  ///  for (int i = 0; i &lt; dataConns.Count; i++)
  ///  {
  ///  dataConn = dataConns[i];
  ///  //get external connection id
  ///  Console.WriteLine(dataConn.ConnectionId);
  ///  }
  ///  [Visual Basic]
  ///  Dim wb As Workbook = New Workbook("connection.xlsx")
  ///  Dim dataConns As ExternalConnectionCollection = wb.DataConnections
  ///  Dim dataConn As ExternalConnection
  ///  Dim count As Integer = dataConns.Count - 1
  ///  Dim i As Integer
  ///  For i = 0 To count Step 1
  ///  dataConn = dataConns(i)
  ///  'get external connection id
  ///  Console.WriteLine(dataConn.ConnectionId)
  ///  Next
  ///</code></example>
  [DNTypeName('Aspose.Cells.ExternalConnections.ExternalConnectionCollection')]
  DNExternalConnectionCollection = interface(DNObject)
  ['{883BDC1F-941F-30D5-A29E-82921A2F7836}']
  { getters & setters } 

    function get_Item(index: Int32): DNExternalConnection; overload;
    procedure set_Item(index: Int32; value: DNExternalConnection);
    function get_Item(connectionName: string): DNExternalConnection; overload;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Gets the <see cref="T:Aspose.Cells.ExternalConnections.ExternalConnection" />
    ///  element with the specified id.
    ///</summary>
    ///  <param name="connId">external connection id</param>
    ///<returns>The element with the specified id.</returns>
    function GetExternalConnectionById(connId: Int32): DNExternalConnection;
    function BinarySearch(item: DNExternalConnection): Int32; overload;
    function BinarySearch(item: DNExternalConnection; comparer: DDN.mscorlib.DNIComparer<DNExternalConnection>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNExternalConnection; comparer: DDN.mscorlib.DNIComparer<DNExternalConnection>): Int32; overload;
    function &Contains(item: DNExternalConnection): Boolean;
    procedure CopyTo(&array: TArray<DNExternalConnection>); overload;
    procedure CopyTo(&array: TArray<DNExternalConnection>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNExternalConnection>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNExternalConnection>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNExternalConnection>): DNExternalConnection;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNExternalConnection>): DDN.mscorlib.DNList<DNExternalConnection>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNExternalConnection>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNExternalConnection>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNExternalConnection>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNExternalConnection>): DNExternalConnection;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNExternalConnection>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNExternalConnection>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNExternalConnection>): Int32; overload;
    function IndexOf(item: DNExternalConnection): Int32; overload;
    function IndexOf(item: DNExternalConnection; index: Int32): Int32; overload;
    function IndexOf(item: DNExternalConnection; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNExternalConnection): Int32; overload;
    function LastIndexOf(item: DNExternalConnection; index: Int32): Int32; overload;
    function LastIndexOf(item: DNExternalConnection; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNExternalConnection>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNExternalConnection read get_Item write set_Item; default;
    property Item[connectionName: string]: DNExternalConnection read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNExternalConnectionCollection = class(TDNGenericImport<DNExternalConnectionCollectionClass, DNExternalConnectionCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNFilterColumnCollectionClass = interface(DNObjectClass)
  ['{17440A73-7AE5-57BB-A07B-4C52F7545DB7}']
  end;

  ///<summary>
  ///  A collection of Filter objects that represents all the filters in an autofiltered range.
  ///</summary>
  [DNTypeName('Aspose.Cells.FilterColumnCollection')]
  DNFilterColumnCollection = interface(DNObject)
  ['{5948F07E-6649-320C-A1AE-CB75A22DC179}']
  { getters & setters } 

    function get_Item(fieldIndex: Int32): DNFilterColumn;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary></summary>
    ///  <param name="index"></param>
    procedure RemoveAt(index: Int32);
    ///<summary>
    ///  Returns a single Filter object from a collection.
    ///</summary>
    function GetByIndex(index: Int32): DNFilterColumn;
    function BinarySearch(item: DNFilterColumn): Int32; overload;
    function BinarySearch(item: DNFilterColumn; comparer: DDN.mscorlib.DNIComparer<DNFilterColumn>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNFilterColumn; comparer: DDN.mscorlib.DNIComparer<DNFilterColumn>): Int32; overload;
    function &Contains(item: DNFilterColumn): Boolean;
    procedure CopyTo(&array: TArray<DNFilterColumn>); overload;
    procedure CopyTo(&array: TArray<DNFilterColumn>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNFilterColumn>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNFilterColumn>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNFilterColumn>): DNFilterColumn;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNFilterColumn>): DDN.mscorlib.DNList<DNFilterColumn>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNFilterColumn>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNFilterColumn>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNFilterColumn>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNFilterColumn>): DNFilterColumn;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNFilterColumn>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNFilterColumn>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNFilterColumn>): Int32; overload;
    function IndexOf(item: DNFilterColumn): Int32; overload;
    function IndexOf(item: DNFilterColumn; index: Int32): Int32; overload;
    function IndexOf(item: DNFilterColumn; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNFilterColumn): Int32; overload;
    function LastIndexOf(item: DNFilterColumn; index: Int32): Int32; overload;
    function LastIndexOf(item: DNFilterColumn; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNFilterColumn>;
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[fieldIndex: Int32]: DNFilterColumn read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNFilterColumnCollection = class(TDNGenericImport<DNFilterColumnCollectionClass, DNFilterColumnCollection>) end;

  //-------------namespace: Aspose.Cells.Drawing.Texts----------------
  DNFontSettingCollectionClass = interface(DNObjectClass)
  ['{51D870EA-5CF1-5924-B1D7-1281E3E42D6A}']
  end;

  ///<summary>
  ///  Represents the list of <see cref="T:Aspose.Cells.FontSetting" />
  ///  .
  ///</summary>
  [DNTypeName('Aspose.Cells.Drawing.Texts.FontSettingCollection')]
  DNFontSettingCollection = interface(DNObject)
  ['{C90D91CD-9E8A-3471-B474-43D7DD65E690}']
  { getters & setters } 

    function get_TextAlignment: DNShapeTextAlignment;
    function get_TextParagraphs: DNTextParagraphCollection;
    function get_Text: string;
    procedure set_Text(value: string);
    function get_HtmlString: string;
    procedure set_HtmlString(value: string);
    function get_Item(index: Int32): DNFontSetting;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Sets the preset WordArt style.
    ///</summary>
    ///  <param name="style">The preset WordArt style.</param>
    procedure SetWordArtStyle(style: DNPresetWordArtStyle);
    ///<summary>
    ///  Gets the enumerator of the paragraphs.
    ///</summary>
    ///<returns></returns>
    function GetParagraphEnumerator: DDN.mscorlib.DNIEnumerator;
    ///<summary>
    ///  Appends the text.
    ///</summary>
    ///  <param name="text">The text.</param>
    procedure AppendText(text: string);
    ///<summary>
    ///  Insert index at the position.
    ///</summary>
    ///  <param name="index">The start index.</param>
    ///  <param name="text">The text.</param>
    procedure InsertText(index: Int32; text: string);
    ///<summary>
    ///  Replace the text.
    ///</summary>
    ///  <param name="index">The start index.</param>
    ///  <param name="count">The count of characters.</param>
    ///  <param name="text">The text.</param>
    procedure Replace(index: Int32; count: Int32; text: string);
    ///<summary>
    ///  Delete some characters.
    ///</summary>
    ///  <param name="index">The start index.</param>
    ///  <param name="count">The count of characters.</param>
    procedure DeleteText(index: Int32; count: Int32);
    ///<summary>
    ///  Format the text with font setting.
    ///</summary>
    ///  <param name="startIndex">The start index.</param>
    ///  <param name="length">The length.</param>
    ///  <param name="font">The font.</param>
    ///  <param name="flag">The flags of the font.</param>
    procedure Format(startIndex: Int32; length: Int32; font: DNFont; flag: DNStyleFlag);
    ///<summary>
    ///  Clear all setting.
    ///</summary>
    procedure Clear;
    function BinarySearch(item: DNFontSetting): Int32; overload;
    function BinarySearch(item: DNFontSetting; comparer: DDN.mscorlib.DNIComparer<DNFontSetting>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNFontSetting; comparer: DDN.mscorlib.DNIComparer<DNFontSetting>): Int32; overload;
    function &Contains(item: DNFontSetting): Boolean;
    procedure CopyTo(&array: TArray<DNFontSetting>); overload;
    procedure CopyTo(&array: TArray<DNFontSetting>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNFontSetting>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNFontSetting>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNFontSetting>): DNFontSetting;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNFontSetting>): DDN.mscorlib.DNList<DNFontSetting>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNFontSetting>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNFontSetting>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNFontSetting>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNFontSetting>): DNFontSetting;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNFontSetting>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNFontSetting>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNFontSetting>): Int32; overload;
    function IndexOf(item: DNFontSetting): Int32; overload;
    function IndexOf(item: DNFontSetting; index: Int32): Int32; overload;
    function IndexOf(item: DNFontSetting; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNFontSetting): Int32; overload;
    function LastIndexOf(item: DNFontSetting; index: Int32): Int32; overload;
    function LastIndexOf(item: DNFontSetting; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNFontSetting>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    ///<summary>
    ///  Represents the alignment setting of the text body.
    ///</summary>
    property TextAlignment: DNShapeTextAlignment read get_TextAlignment;
    ///<summary>
    ///  Gets all paragraphs.
    ///</summary>
    property TextParagraphs: DNTextParagraphCollection read get_TextParagraphs;
    ///<summary>
    ///  Gets and sets the text of the shape.
    ///</summary>
    property Text: string read get_Text write set_Text;
    ///<summary>
    ///  Gets and sets the html string which contains data and some formats in this shape.
    ///</summary>
    property HtmlString: string read get_HtmlString write set_HtmlString;
    property Item[index: Int32]: DNFontSetting read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNFontSettingCollection = class(TDNGenericImport<DNFontSettingCollectionClass, DNFontSettingCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNConditionalFormattingCollectionClass = interface(DNObjectClass)
  ['{E888D741-8BC9-585E-86C3-1562FD0789E8}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.FormatCondition" />
  ///  objects.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Instantiating a Workbook object
  ///  Workbook workbook = new Workbook();
  ///  Worksheet sheet = workbook.Worksheets[0];
  ///  //Get Conditional Formatting
  ///  ConditionalFormattingCollection cformattings = sheet.ConditionalFormattings;
  ///  //Adds an empty conditional formatting
  ///  int index = cformattings.Add();
  ///  //Get newly added Conditional formatting
  ///  FormatConditionCollection fcs = cformattings[index];
  ///  //Sets the conditional format range.
  ///  CellArea ca = new CellArea();
  ///  ca.StartRow = 0;
  ///  ca.EndRow = 0;
  ///  ca.StartColumn = 0;
  ///  ca.EndColumn = 0;
  ///  fcs.AddArea(ca);
  ///  ca = new CellArea();
  ///  ca.StartRow = 1;
  ///  ca.EndRow = 1;
  ///  ca.StartColumn = 1;
  ///  ca.EndColumn = 1;
  ///  fcs.AddArea(ca);
  ///  //Add condition.
  ///  int conditionIndex = fcs.AddCondition(FormatConditionType.CellValue, OperatorType.Between, "=A2", "100");
  ///  //Add condition.
  ///  int conditionIndex2 = fcs.AddCondition(FormatConditionType.CellValue, OperatorType.Between, "50", "100");
  ///  //Sets the background color.
  ///  FormatCondition fc = fcs[conditionIndex];
  ///  fc.Style.BackgroundColor = Color.Red;
  ///  //Saving the Excel file
  ///  workbook.Save("C:\\output.xls");
  ///  [VB.NET]
  ///  'Instantiating a Workbook object
  ///  Dim workbook As New Workbook()
  ///  Dim sheet As Worksheet = workbook.Worksheets(0)
  ///  'Get Conditional Formatting
  ///  Dim cformattings As ConditionalFormattingCollection = sheet.ConditionalFormattings
  ///  'Adds an empty conditional formatting
  ///  Dim index As Integer = cformattings.Add()
  ///  'Get newly added Conditional formatting
  ///  Dim fcs As FormatConditionCollection = cformattings(index)
  ///  'Sets the conditional format range.
  ///  Dim ca As New CellArea()
  ///  ca.StartRow = 0
  ///  ca.EndRow = 0
  ///  ca.StartColumn = 0
  ///  ca.EndColumn = 0
  ///  fcs.AddArea(ca)
  ///  ca = New CellArea()
  ///  ca.StartRow = 1
  ///  ca.EndRow = 1
  ///  ca.StartColumn = 1
  ///  ca.EndColumn = 1
  ///  fcs.AddArea(ca)
  ///  'Add condition.
  ///  Dim conditionIndex As Integer = fcs.AddCondition(FormatConditionType.CellValue, OperatorType.Between, "=A2", "100")
  ///  'Add condition.
  ///  Dim conditionIndex2 As Integer = fcs.AddCondition(FormatConditionType.CellValue, OperatorType.Between, "50", "100")
  ///  'Sets the background color.
  ///  Dim fc As FormatCondition = fcs(conditionIndex)
  ///  fc.Style.BackgroundColor = Color.Red
  ///  'Saving the Excel file
  ///  workbook.Save("C:\output.xls")
  ///</code></example>
  [DNTypeName('Aspose.Cells.ConditionalFormattingCollection')]
  DNConditionalFormattingCollection = interface(DNObject)
  ['{5A294ADB-351A-3079-9282-461BC61744C3}']
  { getters & setters } 

    function get_Item(index: Int32): DNFormatConditionCollection;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Remove all conditional formatting in the range.
    ///</summary>
    ///  <param name="startRow">The start row of the range.</param>
    ///  <param name="startColumn">The start column of the range.</param>
    ///  <param name="totalRows">The number of rows of the range.</param>
    ///  <param name="totalColumns">The number of columns of the range.</param>
    procedure RemoveArea(startRow: Int32; startColumn: Int32; totalRows: Int32; totalColumns: Int32);
    ///<summary>
    ///  Copies conditional formatting.
    ///</summary>
    ///  <param name="cfs">The conditional formatting</param>
    procedure Copy(cfs: DNConditionalFormattingCollection);
    ///<summary>
    ///  Adds a FormatConditions to the collection.
    ///</summary>
    ///<returns>FormatConditions object index.</returns>
    function Add: Int32;
    function BinarySearch(item: DNFormatConditionCollection): Int32; overload;
    function BinarySearch(item: DNFormatConditionCollection; comparer: DDN.mscorlib.DNIComparer<DNFormatConditionCollection>): Int32; overload;
    function BinarySearch(index: Int32; count: Int32; item: DNFormatConditionCollection; comparer: DDN.mscorlib.DNIComparer<DNFormatConditionCollection>): Int32; overload;
    function &Contains(item: DNFormatConditionCollection): Boolean;
    procedure CopyTo(&array: TArray<DNFormatConditionCollection>); overload;
    procedure CopyTo(&array: TArray<DNFormatConditionCollection>; arrayIndex: Int32); overload;
    procedure CopyTo(index: Int32; &array: TArray<DNFormatConditionCollection>; arrayIndex: Int32; count: Int32); overload;
    function Exists(match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): Boolean;
    function Find(match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): DNFormatConditionCollection;
    function FindAll(match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): DDN.mscorlib.DNList<DNFormatConditionCollection>;
    function FindIndex(match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): Int32; overload;
    function FindIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): Int32; overload;
    function FindIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): Int32; overload;
    function FindLast(match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): DNFormatConditionCollection;
    function FindLastIndex(match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): Int32; overload;
    function FindLastIndex(startIndex: Int32; match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): Int32; overload;
    function FindLastIndex(startIndex: Int32; count: Int32; match: DDN.mscorlib.DNPredicate<DNFormatConditionCollection>): Int32; overload;
    function IndexOf(item: DNFormatConditionCollection): Int32; overload;
    function IndexOf(item: DNFormatConditionCollection; index: Int32): Int32; overload;
    function IndexOf(item: DNFormatConditionCollection; index: Int32; count: Int32): Int32; overload;
    function LastIndexOf(item: DNFormatConditionCollection): Int32; overload;
    function LastIndexOf(item: DNFormatConditionCollection; index: Int32): Int32; overload;
    function LastIndexOf(item: DNFormatConditionCollection; index: Int32; count: Int32): Int32; overload;
    function GetEnumerator: DDN.mscorlib.DNIEnumerator<DNFormatConditionCollection>;
    procedure RemoveAt(index: Int32);
    function Equals(obj: DDN.mscorlib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDN.mscorlib.DNType;
    function ToString: string;

  { propertys } 

    property Item[index: Int32]: DNFormatConditionCollection read get_Item; default;
    property Capacity: Int32 read get_Capacity write set_Capacity;
    property Count: Int32 read get_Count;
  end;

  TDNConditionalFormattingCollection = class(TDNGenericImport<DNConditionalFormattingCollectionClass, DNConditionalFormattingCollection>) end;

  //-------------namespace: Aspose.Cells----------------
  DNHorizontalPageBreakCollectionClass = interface(DNObjectClass)
  ['{1DD66642-42E4-5B11-B15F-824F8E90C6C2}']
  end;

  ///<summary>
  ///  Encapsulates a collection of <see cref="T:Aspose.Cells.HorizontalPageBreak" />
  ///  objects.
  ///</summary>
  ///<example><code>
  ///  [C#]
  ///  //Add a pagebreak at G5
  ///  excel.Worksheets[0].HorizontalPageBreaks.Add("G5");
  ///  excel.Worksheets[0].VerticalPageBreaks.Add("G5");
  ///  [VB]
  ///  'Add a pagebreak at G5
  ///  excel.Worksheets(0).HorizontalPageBreaks.Add("G5")
  ///  excel.Worksheets(0).VerticalPageBreaks.Add("G5")
  ///</code></example>
  [DNTypeName('Aspose.Cells.HorizontalPageBreakCollection')]
  DNHorizontalPageBreakCollection = interface(DNObject)
  ['{62D8CDFB-E20F-3570-94CD-E36A4BDC93FC}']
  { getters & setters } 

    function get_Item(index: Int32): DNHorizontalPageBreak; overload;
    function get_Item(cellName: string): DNHorizontalPageBreak; overload;
    function get_Capacity: Int32;
    procedure set_Capacity(value: Int32);
    function get_Count: Int32;

  { methods } 

    ///<summary>
    ///  Adds a horizontal page break to the collection.
    ///</summary>
    ///  <param name="row">Row index, zero based.</param>
    ///  <param name="startColumn">Start column index, zero based.</param>
    ///  <param name="endColumn">End column index, zero based.</param>
    ///<returns><see cref="T:Aspose.Cells.HorizontalPageBreak" />
    ///  object index.</returns>
    ///<remarks>This method is used to add a horizontal pagebreak within a print area.</remarks>
    function Add(row: Int32; startColumn: Int32; endColumn: Int32): Int32; overload;
    ///<summary>
    ///  Adds a horizontal page break to the collection.
    ///</summary>
    ///  <param name="row">Cell row index, zero based.</param>
    ///<returns><see cref="T:Aspose.Cells.HorizontalPageBreak" />
    ///  object index.</returns>
    ///<remarks>Page break is added in the top left of the cell.
    ///  Please set a horizontal page break and a vertical page break concurrently.</remarks>
    function Add(row: Int32): Int32; overload;
    ///<summary>
    ///  Adds a horizontal page break to the collection.
    ///</summary>
    ///  <param name="row">Cell row index, zero based.</param>
    ///  <param name="column">Cell column index, zero based.</param>
    ///<returns><see cref="T:Aspose.Cells.HorizontalPageBreak" />
    ///  object index.</returns>
    ///<remarks>Page break is added in the top left of the cell.
    ///  Please set a horizontal page break and a vertical page break concurrently.</remarks>
    function Add(row: Int32; column: Int32): Int32; overload;
    ///<summary>
    ///  Adds a horizontal page break to the collection.
    ///</summary>
    ///  <param name="cellName">Cell name.</param>
    ///<returns><see cref="T:Aspose.Cells.HorizontalPageBreak" />
    ///  object index.</returns>
    ///<remarks>Page break is added in the top left of the cell.
    ///  Please set a horizontal page break a