//----------------------------------------------------------------------------
//  WebDriver.dll: WebDriver, Version=3.141.0.0, Culture=neutral, PublicKeyToken=null
//----------------------------------------------------------------------------
//  The code is automatically generated by the GenCodeNET tool.
//----------------------------------------------------------------------------
//  .NET Core 
//----------------------------------------------------------------------------
//  UnitName: DDNC.WebDriver
//  Author: ying32
//----------------------------------------------------------------------------

unit DDNC.WebDriver;

{$IFDEF FPC}
  {$mode delphi}//{$H+}
  {$modeswitch advancedrecords}
  {$modeswitch prefixedattributes} // Custom attributes feature，fpc3.2.2+
{$ENDIF}

interface

uses
  DDN.Runtime,
  DDNC.System.Private.CoreLib,
  DDNC.System.Drawing.Primitives,
  DDNC.System.Private.Uri,
  DDNC.System.Net.Primitives,
  DDNC.System.Net.Requests;

type

{ enums }

  //-------------namespace: OpenQA.Selenium.Edge----------------
  [DNTypeName('OpenQA.Selenium.Edge.EdgePageLoadStrategy')]
  DNEdgePageLoadStrategy = type Integer;
  DNEdgePageLoadStrategyHelper = record helper for DNEdgePageLoadStrategy
  public const
    Default_ = 0;
    Normal = 1;
    Eager = 2;
    None = 3;
  end;


  //-------------namespace: OpenQA.Selenium.Firefox----------------
  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxDriverLogLevel')]
  DNFirefoxDriverLogLevel = type Integer;
  DNFirefoxDriverLogLevelHelper = record helper for DNFirefoxDriverLogLevel
  public const
    Trace = 0;
    Debug = 1;
    Config = 2;
    Info = 3;
    Warn = 4;
    Error = 5;
    Fatal = 6;
    Default_ = 7;
  end;


  //-------------namespace: OpenQA.Selenium.Html5----------------
  [DNTypeName('OpenQA.Selenium.Html5.AppCacheStatus')]
  DNAppCacheStatus = type Integer;
  DNAppCacheStatusHelper = record helper for DNAppCacheStatus
  public const
    Uncached = 0;
    Idle = 1;
    Checking = 2;
    Downloading = 3;
    UpdateReady = 4;
    Obsolete = 5;
  end;


  //-------------namespace: OpenQA.Selenium.IE----------------
  [DNTypeName('OpenQA.Selenium.IE.InternetExplorerDriverLogLevel')]
  DNInternetExplorerDriverLogLevel = type Integer;
  DNInternetExplorerDriverLogLevelHelper = record helper for DNInternetExplorerDriverLogLevel
  public const
    Trace = 0;
    Debug = 1;
    Info = 2;
    Warn = 3;
    Error = 4;
    Fatal = 5;
  end;


  //-------------namespace: OpenQA.Selenium.IE----------------
  [DNTypeName('OpenQA.Selenium.IE.InternetExplorerElementScrollBehavior')]
  DNInternetExplorerElementScrollBehavior = type Integer;
  DNInternetExplorerElementScrollBehaviorHelper = record helper for DNInternetExplorerElementScrollBehavior
  public const
    Default_ = 0;
    Top = 1;
    Bottom = 2;
  end;


  //-------------namespace: OpenQA.Selenium.Interactions----------------
  [DNTypeName('OpenQA.Selenium.Interactions.CoordinateOrigin')]
  DNCoordinateOrigin = type Integer;
  DNCoordinateOriginHelper = record helper for DNCoordinateOrigin
  public const
    Viewport = 0;
    Pointer = 1;
    Element = 2;
  end;


  //-------------namespace: OpenQA.Selenium.Interactions----------------
  [DNTypeName('OpenQA.Selenium.Interactions.InputDeviceKind')]
  DNInputDeviceKind = type Integer;
  DNInputDeviceKindHelper = record helper for DNInputDeviceKind
  public const
    None = 0;
    Key = 1;
    Pointer = 2;
  end;


  //-------------namespace: OpenQA.Selenium.Interactions----------------
  [DNTypeName('OpenQA.Selenium.Interactions.MouseButton')]
  DNMouseButton = type Integer;
  DNMouseButtonHelper = record helper for DNMouseButton
  public const
    Left = 0;
    Middle = 1;
    Right = 2;
  end;


  //-------------namespace: OpenQA.Selenium.Interactions----------------
  [DNTypeName('OpenQA.Selenium.Interactions.MoveToElementOffsetOrigin')]
  DNMoveToElementOffsetOrigin = type Integer;
  DNMoveToElementOffsetOriginHelper = record helper for DNMoveToElementOffsetOrigin
  public const
    TopLeft = 0;
    Center = 1;
  end;


  //-------------namespace: OpenQA.Selenium.Interactions----------------
  [DNTypeName('OpenQA.Selenium.Interactions.PointerKind')]
  DNPointerKind = type Integer;
  DNPointerKindHelper = record helper for DNPointerKind
  public const
    Mouse = 0;
    Pen = 1;
    Touch = 2;
  end;


  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.LogLevel')]
  DNLogLevel = type Integer;
  DNLogLevelHelper = record helper for DNLogLevel
  public const
    All = 0;
    Debug = 1;
    Info = 2;
    Warning = 3;
    Severe = 4;
    Off = 5;
  end;


  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.PageLoadStrategy')]
  DNPageLoadStrategy = type Integer;
  DNPageLoadStrategyHelper = record helper for DNPageLoadStrategy
  public const
    Default_ = 0;
    Normal = 1;
    Eager = 2;
    None = 3;
  end;


  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.PlatformType')]
  DNPlatformType = type Integer;
  DNPlatformTypeHelper = record helper for DNPlatformType
  public const
    Any = 0;
    Windows = 1;
    WinNT = 1;
    XP = 2;
    Vista = 3;
    Mac = 4;
    Unix = 5;
    Linux = 6;
    Android = 7;
  end;


  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ProxyKind')]
  DNProxyKind = type Integer;
  DNProxyKindHelper = record helper for DNProxyKind
  public const
    Direct = 0;
    Manual = 1;
    ProxyAutoConfigure = 2;
    AutoDetect = 4;
    System = 5;
    Unspecified = 6;
  end;


  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ScreenOrientation')]
  DNScreenOrientation = type Integer;
  DNScreenOrientationHelper = record helper for DNScreenOrientation
  public const
    Portrait = 0;
    Landscape = 1;
  end;


  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ScreenshotImageFormat')]
  DNScreenshotImageFormat = type Integer;
  DNScreenshotImageFormatHelper = record helper for DNScreenshotImageFormat
  public const
    Png = 0;
    Jpeg = 1;
    Gif = 2;
    Tiff = 3;
    Bmp = 4;
  end;


  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.UnhandledPromptBehavior')]
  DNUnhandledPromptBehavior = type Integer;
  DNUnhandledPromptBehaviorHelper = record helper for DNUnhandledPromptBehavior
  public const
    Default_ = 0;
    Ignore = 1;
    Accept = 2;
    Dismiss = 3;
    AcceptAndNotify = 4;
    DismissAndNotify = 5;
  end;


  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.WebDriverResult')]
  DNWebDriverResult = type Integer;
  DNWebDriverResultHelper = record helper for DNWebDriverResult
  public const
    Success = 0;
    IndexOutOfBounds = 1;
    NoCollection = 2;
    NoString = 3;
    NoStringLength = 4;
    NoStringWrapper = 5;
    NoSuchDriver = 6;
    NoSuchElement = 7;
    NoSuchFrame = 8;
    UnknownCommand = 9;
    ObsoleteElement = 10;
    ElementNotDisplayed = 11;
    InvalidElementState = 12;
    UnhandledError = 13;
    ExpectedError = 14;
    ElementNotSelectable = 15;
    NoSuchDocument = 16;
    UnexpectedJavaScriptError = 17;
    NoScriptResult = 18;
    XPathLookupError = 19;
    NoSuchCollection = 20;
    Timeout = 21;
    NullPointer = 22;
    NoSuchWindow = 23;
    InvalidCookieDomain = 24;
    UnableToSetCookie = 25;
    UnexpectedAlertOpen = 26;
    NoAlertPresent = 27;
    AsyncScriptTimeout = 28;
    InvalidElementCoordinates = 29;
    InvalidSelector = 32;
    SessionNotCreated = 33;
    MoveTargetOutOfBounds = 34;
    InvalidXPathSelector = 51;
    InsecureCertificate = 59;
    ElementNotInteractable = 60;
    InvalidArgument = 61;
    NoSuchCookie = 62;
    UnableToCaptureScreen = 63;
    ElementClickIntercepted = 64;
  end;




type


{ declares }

  DNIApplicationCache = interface; // type: OpenQA.Selenium.Html5.IApplicationCache, namespace: OpenQA.Selenium.Html5
  DNIHasApplicationCache = interface; // type: OpenQA.Selenium.Html5.IHasApplicationCache, namespace: OpenQA.Selenium.Html5
  DNIHasLocationContext = interface; // type: OpenQA.Selenium.Html5.IHasLocationContext, namespace: OpenQA.Selenium.Html5
  DNIHasWebStorage = interface; // type: OpenQA.Selenium.Html5.IHasWebStorage, namespace: OpenQA.Selenium.Html5
  DNILocalStorage = interface; // type: OpenQA.Selenium.Html5.ILocalStorage, namespace: OpenQA.Selenium.Html5
  DNILocationContext = interface; // type: OpenQA.Selenium.Html5.ILocationContext, namespace: OpenQA.Selenium.Html5
  DNISessionStorage = interface; // type: OpenQA.Selenium.Html5.ISessionStorage, namespace: OpenQA.Selenium.Html5
  DNIWebStorage = interface; // type: OpenQA.Selenium.Html5.IWebStorage, namespace: OpenQA.Selenium.Html5
  DNIAlert = interface; // type: OpenQA.Selenium.IAlert, namespace: OpenQA.Selenium
  DNIAllowsFileDetection = interface; // type: OpenQA.Selenium.IAllowsFileDetection, namespace: OpenQA.Selenium
  DNICapabilities = interface; // type: OpenQA.Selenium.ICapabilities, namespace: OpenQA.Selenium
  DNICookieJar = interface; // type: OpenQA.Selenium.ICookieJar, namespace: OpenQA.Selenium
  DNIFileDetector = interface; // type: OpenQA.Selenium.IFileDetector, namespace: OpenQA.Selenium
  DNIHasCapabilities = interface; // type: OpenQA.Selenium.IHasCapabilities, namespace: OpenQA.Selenium
  DNIHasInputDevices = interface; // type: OpenQA.Selenium.IHasInputDevices, namespace: OpenQA.Selenium
  DNIHasTouchScreen = interface; // type: OpenQA.Selenium.IHasTouchScreen, namespace: OpenQA.Selenium
  DNIJavaScriptExecutor = interface; // type: OpenQA.Selenium.IJavaScriptExecutor, namespace: OpenQA.Selenium
  DNIKeyboard = interface; // type: OpenQA.Selenium.IKeyboard, namespace: OpenQA.Selenium
  DNILocatable = interface; // type: OpenQA.Selenium.ILocatable, namespace: OpenQA.Selenium
  DNILogs = interface; // type: OpenQA.Selenium.ILogs, namespace: OpenQA.Selenium
  DNIMouse = interface; // type: OpenQA.Selenium.IMouse, namespace: OpenQA.Selenium
  DNINavigation = interface; // type: OpenQA.Selenium.INavigation, namespace: OpenQA.Selenium
  DNIAction = interface; // type: OpenQA.Selenium.Interactions.IAction, namespace: OpenQA.Selenium.Interactions
  DNICoordinates = interface; // type: OpenQA.Selenium.Interactions.Internal.ICoordinates, namespace: OpenQA.Selenium.Interactions.Internal
  DNIActionExecutor = interface; // type: OpenQA.Selenium.Internal.IActionExecutor, namespace: OpenQA.Selenium.Internal
  DNIFindsByClassName = interface; // type: OpenQA.Selenium.Internal.IFindsByClassName, namespace: OpenQA.Selenium.Internal
  DNIFindsByCssSelector = interface; // type: OpenQA.Selenium.Internal.IFindsByCssSelector, namespace: OpenQA.Selenium.Internal
  DNIFindsById = interface; // type: OpenQA.Selenium.Internal.IFindsById, namespace: OpenQA.Selenium.Internal
  DNIFindsByLinkText = interface; // type: OpenQA.Selenium.Internal.IFindsByLinkText, namespace: OpenQA.Selenium.Internal
  DNIFindsByName = interface; // type: OpenQA.Selenium.Internal.IFindsByName, namespace: OpenQA.Selenium.Internal
  DNIFindsByPartialLinkText = interface; // type: OpenQA.Selenium.Internal.IFindsByPartialLinkText, namespace: OpenQA.Selenium.Internal
  DNIFindsByTagName = interface; // type: OpenQA.Selenium.Internal.IFindsByTagName, namespace: OpenQA.Selenium.Internal
  DNIFindsByXPath = interface; // type: OpenQA.Selenium.Internal.IFindsByXPath, namespace: OpenQA.Selenium.Internal
  DNIWrapsDriver = interface; // type: OpenQA.Selenium.Internal.IWrapsDriver, namespace: OpenQA.Selenium.Internal
  DNIWrapsElement = interface; // type: OpenQA.Selenium.Internal.IWrapsElement, namespace: OpenQA.Selenium.Internal
  DNIOptions = interface; // type: OpenQA.Selenium.IOptions, namespace: OpenQA.Selenium
  DNIRotatable = interface; // type: OpenQA.Selenium.IRotatable, namespace: OpenQA.Selenium
  DNISearchContext = interface; // type: OpenQA.Selenium.ISearchContext, namespace: OpenQA.Selenium
  DNIWebDriver = interface; // type: OpenQA.Selenium.IWebDriver, namespace: OpenQA.Selenium
  DNIWebElement = interface; // type: OpenQA.Selenium.IWebElement, namespace: OpenQA.Selenium
  DNITakesScreenshot = interface; // type: OpenQA.Selenium.ITakesScreenshot, namespace: OpenQA.Selenium
  DNITargetLocator = interface; // type: OpenQA.Selenium.ITargetLocator, namespace: OpenQA.Selenium
  DNITimeouts = interface; // type: OpenQA.Selenium.ITimeouts, namespace: OpenQA.Selenium
  DNITouchScreen = interface; // type: OpenQA.Selenium.ITouchScreen, namespace: OpenQA.Selenium
  DNIWindow = interface; // type: OpenQA.Selenium.IWindow, namespace: OpenQA.Selenium
  DNIHasSessionId = interface; // type: OpenQA.Selenium.Remote.IHasSessionId, namespace: OpenQA.Selenium.Remote
  DNIClock = interface; // type: OpenQA.Selenium.Support.UI.IClock, namespace: OpenQA.Selenium.Support.UI
  DNIWait<T> = interface; // type: OpenQA.Selenium.Support.UI.IWait`1, namespace: OpenQA.Selenium.Support.UI
  DNICommandExecutor = interface; // type: OpenQA.Selenium.Remote.ICommandExecutor, namespace: OpenQA.Selenium.Remote
  DNICommandServer = interface; // type: OpenQA.Selenium.Remote.ICommandServer, namespace: OpenQA.Selenium.Remote
  DNBy = interface; // type: OpenQA.Selenium.By, namespace: OpenQA.Selenium
  DNChromeMobileEmulationDeviceSettings = interface; // type: OpenQA.Selenium.Chrome.ChromeMobileEmulationDeviceSettings, namespace: OpenQA.Selenium.Chrome
  DNChromeNetworkConditions = interface; // type: OpenQA.Selenium.Chrome.ChromeNetworkConditions, namespace: OpenQA.Selenium.Chrome
  DNChromePerformanceLoggingPreferences = interface; // type: OpenQA.Selenium.Chrome.ChromePerformanceLoggingPreferences, namespace: OpenQA.Selenium.Chrome
  DNCookie = interface; // type: OpenQA.Selenium.Cookie, namespace: OpenQA.Selenium
  DNReturnedCookie = interface; // type: OpenQA.Selenium.Internal.ReturnedCookie, namespace: OpenQA.Selenium.Internal
  DNDefaultFileDetector = interface; // type: OpenQA.Selenium.DefaultFileDetector, namespace: OpenQA.Selenium
  DNDriverOptions = interface; // type: OpenQA.Selenium.DriverOptions, namespace: OpenQA.Selenium
  DNChromeOptions = interface; // type: OpenQA.Selenium.Chrome.ChromeOptions, namespace: OpenQA.Selenium.Chrome
  DNEdgeOptions = interface; // type: OpenQA.Selenium.Edge.EdgeOptions, namespace: OpenQA.Selenium.Edge
  DNFirefoxOptions = interface; // type: OpenQA.Selenium.Firefox.FirefoxOptions, namespace: OpenQA.Selenium.Firefox
  DNInternetExplorerOptions = interface; // type: OpenQA.Selenium.IE.InternetExplorerOptions, namespace: OpenQA.Selenium.IE
  DNOperaOptions = interface; // type: OpenQA.Selenium.Opera.OperaOptions, namespace: OpenQA.Selenium.Opera
  DNSafariOptions = interface; // type: OpenQA.Selenium.Safari.SafariOptions, namespace: OpenQA.Selenium.Safari
  DNDriverService = interface; // type: OpenQA.Selenium.DriverService, namespace: OpenQA.Selenium
  DNChromeDriverService = interface; // type: OpenQA.Selenium.Chrome.ChromeDriverService, namespace: OpenQA.Selenium.Chrome
  DNEdgeDriverService = interface; // type: OpenQA.Selenium.Edge.EdgeDriverService, namespace: OpenQA.Selenium.Edge
  DNFirefoxDriverService = interface; // type: OpenQA.Selenium.Firefox.FirefoxDriverService, namespace: OpenQA.Selenium.Firefox
  DNInternetExplorerDriverService = interface; // type: OpenQA.Selenium.IE.InternetExplorerDriverService, namespace: OpenQA.Selenium.IE
  DNOperaDriverService = interface; // type: OpenQA.Selenium.Opera.OperaDriverService, namespace: OpenQA.Selenium.Opera
  DNSafariDriverService = interface; // type: OpenQA.Selenium.Safari.SafariDriverService, namespace: OpenQA.Selenium.Safari
  DNFirefoxBinary = interface; // type: OpenQA.Selenium.Firefox.FirefoxBinary, namespace: OpenQA.Selenium.Firefox
  DNFirefoxDriverCommandExecutor = interface; // type: OpenQA.Selenium.Firefox.FirefoxDriverCommandExecutor, namespace: OpenQA.Selenium.Firefox
  DNFirefoxDriverServer = interface; // type: OpenQA.Selenium.Firefox.FirefoxDriverServer, namespace: OpenQA.Selenium.Firefox
  DNFirefoxExtension = interface; // type: OpenQA.Selenium.Firefox.FirefoxExtension, namespace: OpenQA.Selenium.Firefox
  DNFirefoxProfile = interface; // type: OpenQA.Selenium.Firefox.FirefoxProfile, namespace: OpenQA.Selenium.Firefox
  DNFirefoxProfileManager = interface; // type: OpenQA.Selenium.Firefox.FirefoxProfileManager, namespace: OpenQA.Selenium.Firefox
  DNLocation = interface; // type: OpenQA.Selenium.Html5.Location, namespace: OpenQA.Selenium.Html5
  DNActionBuilder = interface; // type: OpenQA.Selenium.Interactions.ActionBuilder, namespace: OpenQA.Selenium.Interactions
  DNActions = interface; // type: OpenQA.Selenium.Interactions.Actions, namespace: OpenQA.Selenium.Interactions
  DNTouchActions = interface; // type: OpenQA.Selenium.Interactions.TouchActions, namespace: OpenQA.Selenium.Interactions
  DNActionSequence = interface; // type: OpenQA.Selenium.Interactions.ActionSequence, namespace: OpenQA.Selenium.Interactions
  DNInputDevice = interface; // type: OpenQA.Selenium.Interactions.InputDevice, namespace: OpenQA.Selenium.Interactions
  DNKeyInputDevice = interface; // type: OpenQA.Selenium.Interactions.KeyInputDevice, namespace: OpenQA.Selenium.Interactions
  DNPointerInputDevice = interface; // type: OpenQA.Selenium.Interactions.PointerInputDevice, namespace: OpenQA.Selenium.Interactions
  DNInteraction = interface; // type: OpenQA.Selenium.Interactions.Interaction, namespace: OpenQA.Selenium.Interactions
  DNAsyncJavaScriptExecutor = interface; // type: OpenQA.Selenium.Internal.AsyncJavaScriptExecutor, namespace: OpenQA.Selenium.Internal
  DNResourceUtilities = interface; // type: OpenQA.Selenium.Internal.ResourceUtilities, namespace: OpenQA.Selenium.Internal
  DNKeys = interface; // type: OpenQA.Selenium.Keys, namespace: OpenQA.Selenium
  DNLogEntry = interface; // type: OpenQA.Selenium.LogEntry, namespace: OpenQA.Selenium
  DNLogType = interface; // type: OpenQA.Selenium.LogType, namespace: OpenQA.Selenium
  DNPlatform = interface; // type: OpenQA.Selenium.Platform, namespace: OpenQA.Selenium
  DNProxy = interface; // type: OpenQA.Selenium.Proxy, namespace: OpenQA.Selenium
  DNCapabilityType = interface; // type: OpenQA.Selenium.Remote.CapabilityType, namespace: OpenQA.Selenium.Remote
  DNCommand = interface; // type: OpenQA.Selenium.Remote.Command, namespace: OpenQA.Selenium.Remote
  DNCommandInfo = interface; // type: OpenQA.Selenium.Remote.CommandInfo, namespace: OpenQA.Selenium.Remote
  DNCommandInfoRepository = interface; // type: OpenQA.Selenium.Remote.CommandInfoRepository, namespace: OpenQA.Selenium.Remote
  DNW3CWireProtocolCommandInfoRepository = interface; // type: OpenQA.Selenium.Remote.W3CWireProtocolCommandInfoRepository, namespace: OpenQA.Selenium.Remote
  DNWebDriverWireProtocolCommandInfoRepository = interface; // type: OpenQA.Selenium.Remote.WebDriverWireProtocolCommandInfoRepository, namespace: OpenQA.Selenium.Remote
  DNDesiredCapabilities = interface; // type: OpenQA.Selenium.Remote.DesiredCapabilities, namespace: OpenQA.Selenium.Remote
  DNDriverCommand = interface; // type: OpenQA.Selenium.Remote.DriverCommand, namespace: OpenQA.Selenium.Remote
  DNDriverOptionsMergeResult = interface; // type: OpenQA.Selenium.Remote.DriverOptionsMergeResult, namespace: OpenQA.Selenium.Remote
  DNDriverServiceCommandExecutor = interface; // type: OpenQA.Selenium.Remote.DriverServiceCommandExecutor, namespace: OpenQA.Selenium.Remote
  DNErrorResponse = interface; // type: OpenQA.Selenium.Remote.ErrorResponse, namespace: OpenQA.Selenium.Remote
  DNHttpCommandExecutor = interface; // type: OpenQA.Selenium.Remote.HttpCommandExecutor, namespace: OpenQA.Selenium.Remote
  DNLocalFileDetector = interface; // type: OpenQA.Selenium.Remote.LocalFileDetector, namespace: OpenQA.Selenium.Remote
  DNReadOnlyDesiredCapabilities = interface; // type: OpenQA.Selenium.Remote.ReadOnlyDesiredCapabilities, namespace: OpenQA.Selenium.Remote
  DNRemoteApplicationCache = interface; // type: OpenQA.Selenium.Remote.RemoteApplicationCache, namespace: OpenQA.Selenium.Remote
  DNRemoteLocalStorage = interface; // type: OpenQA.Selenium.Remote.RemoteLocalStorage, namespace: OpenQA.Selenium.Remote
  DNRemoteLocationContext = interface; // type: OpenQA.Selenium.Remote.RemoteLocationContext, namespace: OpenQA.Selenium.Remote
  DNRemoteLogs = interface; // type: OpenQA.Selenium.Remote.RemoteLogs, namespace: OpenQA.Selenium.Remote
  DNRemoteSessionStorage = interface; // type: OpenQA.Selenium.Remote.RemoteSessionStorage, namespace: OpenQA.Selenium.Remote
  DNRemoteTouchScreen = interface; // type: OpenQA.Selenium.Remote.RemoteTouchScreen, namespace: OpenQA.Selenium.Remote
  DNRemoteWebDriver = interface; // type: OpenQA.Selenium.Remote.RemoteWebDriver, namespace: OpenQA.Selenium.Remote
  DNChromeDriver = interface; // type: OpenQA.Selenium.Chrome.ChromeDriver, namespace: OpenQA.Selenium.Chrome
  DNEdgeDriver = interface; // type: OpenQA.Selenium.Edge.EdgeDriver, namespace: OpenQA.Selenium.Edge
  DNFirefoxDriver = interface; // type: OpenQA.Selenium.Firefox.FirefoxDriver, namespace: OpenQA.Selenium.Firefox
  DNInternetExplorerDriver = interface; // type: OpenQA.Selenium.IE.InternetExplorerDriver, namespace: OpenQA.Selenium.IE
  DNOperaDriver = interface; // type: OpenQA.Selenium.Opera.OperaDriver, namespace: OpenQA.Selenium.Opera
  DNSafariDriver = interface; // type: OpenQA.Selenium.Safari.SafariDriver, namespace: OpenQA.Selenium.Safari
  DNRemoteWebElement = interface; // type: OpenQA.Selenium.Remote.RemoteWebElement, namespace: OpenQA.Selenium.Remote
  DNChromeWebElement = interface; // type: OpenQA.Selenium.Chrome.ChromeWebElement, namespace: OpenQA.Selenium.Chrome
  DNEdgeWebElement = interface; // type: OpenQA.Selenium.Edge.EdgeWebElement, namespace: OpenQA.Selenium.Edge
  DNFirefoxWebElement = interface; // type: OpenQA.Selenium.Firefox.FirefoxWebElement, namespace: OpenQA.Selenium.Firefox
  DNInternetExplorerWebElement = interface; // type: OpenQA.Selenium.IE.InternetExplorerWebElement, namespace: OpenQA.Selenium.IE
  DNOperaWebElement = interface; // type: OpenQA.Selenium.Opera.OperaWebElement, namespace: OpenQA.Selenium.Opera
  DNRemoteWebElementFactory = interface; // type: OpenQA.Selenium.Remote.RemoteWebElementFactory, namespace: OpenQA.Selenium.Remote
  DNRemoteWebStorage = interface; // type: OpenQA.Selenium.Remote.RemoteWebStorage, namespace: OpenQA.Selenium.Remote
  DNResponse = interface; // type: OpenQA.Selenium.Remote.Response, namespace: OpenQA.Selenium.Remote
  DNSessionId = interface; // type: OpenQA.Selenium.Remote.SessionId, namespace: OpenQA.Selenium.Remote
  DNStackTraceElement = interface; // type: OpenQA.Selenium.Remote.StackTraceElement, namespace: OpenQA.Selenium.Remote
  DNRemoteSessionSettings = interface; // type: OpenQA.Selenium.RemoteSessionSettings, namespace: OpenQA.Selenium
  DNScreenshot = interface; // type: OpenQA.Selenium.Screenshot, namespace: OpenQA.Selenium
  DNWebDriverWait = interface; // type: OpenQA.Selenium.Support.UI.WebDriverWait, namespace: OpenQA.Selenium.Support.UI
  DNDefaultWait<T> = interface; // type: OpenQA.Selenium.Support.UI.DefaultWait`1, namespace: OpenQA.Selenium.Support.UI
  DNSystemClock = interface; // type: OpenQA.Selenium.Support.UI.SystemClock, namespace: OpenQA.Selenium.Support.UI
  DNSendingRemoteHttpRequestEventArgs = interface; // type: OpenQA.Selenium.Remote.SendingRemoteHttpRequestEventArgs, namespace: OpenQA.Selenium.Remote
  DNWebDriverException = interface; // type: OpenQA.Selenium.WebDriverException, namespace: OpenQA.Selenium
  DNDriverServiceNotFoundException = interface; // type: OpenQA.Selenium.DriverServiceNotFoundException, namespace: OpenQA.Selenium
  DNInvalidCookieDomainException = interface; // type: OpenQA.Selenium.InvalidCookieDomainException, namespace: OpenQA.Selenium
  DNInvalidElementStateException = interface; // type: OpenQA.Selenium.InvalidElementStateException, namespace: OpenQA.Selenium
  DNElementNotInteractableException = interface; // type: OpenQA.Selenium.ElementNotInteractableException, namespace: OpenQA.Selenium
  DNElementClickInterceptedException = interface; // type: OpenQA.Selenium.ElementClickInterceptedException, namespace: OpenQA.Selenium
  DNElementNotVisibleException = interface; // type: OpenQA.Selenium.ElementNotVisibleException, namespace: OpenQA.Selenium
  DNElementNotSelectableException = interface; // type: OpenQA.Selenium.ElementNotSelectableException, namespace: OpenQA.Selenium
  DNNotFoundException = interface; // type: OpenQA.Selenium.NotFoundException, namespace: OpenQA.Selenium
  DNNoAlertPresentException = interface; // type: OpenQA.Selenium.NoAlertPresentException, namespace: OpenQA.Selenium
  DNNoSuchElementException = interface; // type: OpenQA.Selenium.NoSuchElementException, namespace: OpenQA.Selenium
  DNInvalidSelectorException = interface; // type: OpenQA.Selenium.InvalidSelectorException, namespace: OpenQA.Selenium
  DNNoSuchFrameException = interface; // type: OpenQA.Selenium.NoSuchFrameException, namespace: OpenQA.Selenium
  DNNoSuchWindowException = interface; // type: OpenQA.Selenium.NoSuchWindowException, namespace: OpenQA.Selenium
  DNStaleElementReferenceException = interface; // type: OpenQA.Selenium.StaleElementReferenceException, namespace: OpenQA.Selenium
  DNUnableToSetCookieException = interface; // type: OpenQA.Selenium.UnableToSetCookieException, namespace: OpenQA.Selenium
  DNUnhandledAlertException = interface; // type: OpenQA.Selenium.UnhandledAlertException, namespace: OpenQA.Selenium
  DNWebDriverTimeoutException = interface; // type: OpenQA.Selenium.WebDriverTimeoutException, namespace: OpenQA.Selenium
  DNXPathLookupException = interface; // type: OpenQA.Selenium.XPathLookupException, namespace: OpenQA.Selenium


{ objects }

  //-------------namespace: OpenQA.Selenium.Html5----------------
  [DNTypeName('OpenQA.Selenium.Html5.IApplicationCache')]
  DNIApplicationCache = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{99A43007-8C3C-3409-B8F6-40173C3373A8}']
  { getters & setters } 

    function get_Status: DNAppCacheStatus;

  { propertys } 

    property Status: DNAppCacheStatus read get_Status;
  end;

  //-------------namespace: OpenQA.Selenium.Html5----------------
  [DNTypeName('OpenQA.Selenium.Html5.IHasApplicationCache')]
  DNIHasApplicationCache = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C22BE39D-7594-3842-96DF-B73EAED092D4}']
  { getters & setters } 

    function get_HasApplicationCache: Boolean;
    function get_ApplicationCache: DNIApplicationCache;

  { propertys } 

    property HasApplicationCache: Boolean read get_HasApplicationCache;
    property ApplicationCache: DNIApplicationCache read get_ApplicationCache;
  end;

  //-------------namespace: OpenQA.Selenium.Html5----------------
  [DNTypeName('OpenQA.Selenium.Html5.IHasLocationContext')]
  DNIHasLocationContext = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{9A8CDE0B-FE72-368E-AC51-A21526D6A6AD}']
  { getters & setters } 

    function get_HasLocationContext: Boolean;
    function get_LocationContext: DNILocationContext;

  { propertys } 

    property HasLocationContext: Boolean read get_HasLocationContext;
    property LocationContext: DNILocationContext read get_LocationContext;
  end;

  //-------------namespace: OpenQA.Selenium.Html5----------------
  [DNTypeName('OpenQA.Selenium.Html5.IHasWebStorage')]
  DNIHasWebStorage = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8F6ADAE9-909F-383A-ADFA-7A1E7B0CF051}']
  { getters & setters } 

    function get_HasWebStorage: Boolean;
    function get_WebStorage: DNIWebStorage;

  { propertys } 

    property HasWebStorage: Boolean read get_HasWebStorage;
    property WebStorage: DNIWebStorage read get_WebStorage;
  end;

  //-------------namespace: OpenQA.Selenium.Html5----------------
  [DNTypeName('OpenQA.Selenium.Html5.ILocalStorage')]
  DNILocalStorage = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A000E65C-8F86-3D07-8FEE-A195958E52DB}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    function GetItem(key: string): string;
    function KeySet: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    procedure SetItem(key: string; value: string);
    function RemoveItem(key: string): string;
    procedure Clear;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  //-------------namespace: OpenQA.Selenium.Html5----------------
  [DNTypeName('OpenQA.Selenium.Html5.ILocationContext')]
  DNILocationContext = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{47D9754E-CD0F-3A27-8CCF-81860093EA66}']
  { getters & setters } 

    function get_PhysicalLocation: DNLocation;
    procedure set_PhysicalLocation(value: DNLocation);

  { propertys } 

    property PhysicalLocation: DNLocation read get_PhysicalLocation write set_PhysicalLocation;
  end;

  //-------------namespace: OpenQA.Selenium.Html5----------------
  [DNTypeName('OpenQA.Selenium.Html5.ISessionStorage')]
  DNISessionStorage = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{DFB230DD-EA9D-3A46-8472-FC2121572A76}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    function GetItem(key: string): string;
    function KeySet: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    procedure SetItem(key: string; value: string);
    function RemoveItem(key: string): string;
    procedure Clear;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  //-------------namespace: OpenQA.Selenium.Html5----------------
  [DNTypeName('OpenQA.Selenium.Html5.IWebStorage')]
  DNIWebStorage = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8EE9C1E3-CF0C-3F39-AA79-5483E7FF609F}']
  { getters & setters } 

    function get_LocalStorage: DNILocalStorage;
    function get_SessionStorage: DNISessionStorage;

  { propertys } 

    property LocalStorage: DNILocalStorage read get_LocalStorage;
    property SessionStorage: DNISessionStorage read get_SessionStorage;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IAlert')]
  DNIAlert = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{71545BE7-77D9-3017-8563-9F4E80E3A934}']
  { getters & setters } 

    function get_Text: string;

  { methods } 

    procedure Dismiss;
    procedure Accept;
    procedure SendKeys(keysToSend: string);
    procedure SetAuthenticationCredentials(userName: string; password: string);

  { propertys } 

    property Text: string read get_Text;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IAllowsFileDetection')]
  DNIAllowsFileDetection = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{6A3A4FE6-8FE6-36CD-A463-CD31A7FEA182}']
  { getters & setters } 

    function get_FileDetector: DNIFileDetector;
    procedure set_FileDetector(value: DNIFileDetector);

  { propertys } 

    property FileDetector: DNIFileDetector read get_FileDetector write set_FileDetector;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ICapabilities')]
  DNICapabilities = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{20B0CF2F-B0DB-3953-B252-5E56C5398950}']
  { getters & setters } 

    function get_Item(capabilityName: string): DDNC.System.Private.CoreLib.DNObject;

  { methods } 

    function HasCapability(capability: string): Boolean;
    function GetCapability(capability: string): DDNC.System.Private.CoreLib.DNObject;

  { propertys } 

    property Item[capabilityName: string]: DDNC.System.Private.CoreLib.DNObject read get_Item; default;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ICookieJar')]
  DNICookieJar = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4B84C9A9-A1CC-3438-B58A-3E2FC351799B}']
  { getters & setters } 

    function get_AllCookies: DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNCookie>;

  { methods } 

    procedure AddCookie(cookie: DNCookie);
    function GetCookieNamed(name: string): DNCookie;
    procedure DeleteCookie(cookie: DNCookie);
    procedure DeleteCookieNamed(name: string);
    procedure DeleteAllCookies;

  { propertys } 

    property AllCookies: DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNCookie> read get_AllCookies;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IFileDetector')]
  DNIFileDetector = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{25BE2120-F1DE-3E91-94FC-C5CEAA2260E2}']
  { methods } 

    function IsFile(keySequence: string): Boolean;

  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IHasCapabilities')]
  DNIHasCapabilities = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{84FD5EBE-1157-36DA-A990-E330844BEF4E}']
  { getters & setters } 

    function get_Capabilities: DNICapabilities;

  { propertys } 

    property Capabilities: DNICapabilities read get_Capabilities;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IHasInputDevices')]
  DNIHasInputDevices = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{225DC6BB-7B39-388B-A803-F93FF60777AF}']
  { getters & setters } 

    function get_Keyboard: DNIKeyboard;
    function get_Mouse: DNIMouse;

  { propertys } 

    property Keyboard: DNIKeyboard read get_Keyboard;
    property Mouse: DNIMouse read get_Mouse;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IHasTouchScreen')]
  DNIHasTouchScreen = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{08C44024-2A15-3A23-B0AC-C2071ED29594}']
  { getters & setters } 

    function get_TouchScreen: DNITouchScreen;

  { propertys } 

    property TouchScreen: DNITouchScreen read get_TouchScreen;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IJavaScriptExecutor')]
  DNIJavaScriptExecutor = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B5070B44-FF01-3F39-B430-67FE8AEC6A42}']
  { methods } 

    function ExecuteScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function ExecuteAsyncScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;

  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IKeyboard')]
  DNIKeyboard = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8B2A7C1F-F008-3089-8E99-0B7BA196B4DD}']
  { methods } 

    procedure SendKeys(keySequence: string);
    procedure PressKey(keyToPress: string);
    procedure ReleaseKey(keyToRelease: string);

  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ILocatable')]
  DNILocatable = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{198F0DA4-E5F6-357C-ADF7-D5E893BE1B3A}']
  { getters & setters } 

    function get_LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Coordinates: DNICoordinates;

  { propertys } 

    property LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint read get_LocationOnScreenOnceScrolledIntoView;
    property Coordinates: DNICoordinates read get_Coordinates;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ILogs')]
  DNILogs = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0EB9C20C-4C2A-3192-83F9-A66EE60CB7D1}']
  { getters & setters } 

    function get_AvailableLogTypes: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;

  { methods } 

    function GetLog(logKind: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNLogEntry>;

  { propertys } 

    property AvailableLogTypes: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_AvailableLogTypes;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IMouse')]
  DNIMouse = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7475AB5D-2EA3-3AF2-8E3F-2F554DC19D8D}']
  { methods } 

    procedure Click(where: DNICoordinates);
    procedure DoubleClick(where: DNICoordinates);
    procedure MouseDown(where: DNICoordinates);
    procedure MouseUp(where: DNICoordinates);
    procedure MouseMove(where: DNICoordinates); overload;
    procedure MouseMove(where: DNICoordinates; offsetX: Int32; offsetY: Int32); overload;
    procedure ContextClick(where: DNICoordinates);

  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.INavigation')]
  DNINavigation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{371DB8C7-A039-32AE-A483-23FE422039CF}']
  { methods } 

    procedure Back;
    procedure &Forward;
    procedure GoToUrl(url: string); overload;
    procedure GoToUrl(url: DDNC.System.Private.Uri.DNUri); overload;
    procedure Refresh;

  end;

  //-------------namespace: OpenQA.Selenium.Interactions----------------
  [DNTypeName('OpenQA.Selenium.Interactions.IAction')]
  DNIAction = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FB9CC6AE-05C3-3E09-BFA4-0517B072BB60}']
  { methods } 

    procedure Perform;

  end;

  //-------------namespace: OpenQA.Selenium.Interactions.Internal----------------
  [DNTypeName('OpenQA.Selenium.Interactions.Internal.ICoordinates')]
  DNICoordinates = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FCF8B1C1-DFAC-3663-A8A9-80E9DF3046E1}']
  { getters & setters } 

    function get_LocationOnScreen: DDNC.System.Drawing.Primitives.DNPoint;
    function get_LocationInViewport: DDNC.System.Drawing.Primitives.DNPoint;
    function get_LocationInDom: DDNC.System.Drawing.Primitives.DNPoint;
    function get_AuxiliaryLocator: DDNC.System.Private.CoreLib.DNObject;

  { propertys } 

    property LocationOnScreen: DDNC.System.Drawing.Primitives.DNPoint read get_LocationOnScreen;
    property LocationInViewport: DDNC.System.Drawing.Primitives.DNPoint read get_LocationInViewport;
    property LocationInDom: DDNC.System.Drawing.Primitives.DNPoint read get_LocationInDom;
    property AuxiliaryLocator: DDNC.System.Private.CoreLib.DNObject read get_AuxiliaryLocator;
  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IActionExecutor')]
  DNIActionExecutor = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{944E6EB4-8FEC-31E5-9467-7D782F523E52}']
  { getters & setters } 

    function get_IsActionExecutor: Boolean;

  { methods } 

    procedure PerformActions(actionSequenceList: DDNC.System.Private.CoreLib.DNIList<DNActionSequence>);
    procedure ResetInputState;

  { propertys } 

    property IsActionExecutor: Boolean read get_IsActionExecutor;
  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IFindsByClassName')]
  DNIFindsByClassName = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8AB82485-BDD8-38F2-9C6F-B4308B0ACA5F}']
  { methods } 

    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;

  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IFindsByCssSelector')]
  DNIFindsByCssSelector = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{5E14D768-185E-3F80-B2B1-A1480AA25E1D}']
  { methods } 

    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;

  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IFindsById')]
  DNIFindsById = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{6E3A628F-5403-3F9B-A396-4E14836A941E}']
  { methods } 

    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;

  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IFindsByLinkText')]
  DNIFindsByLinkText = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7C3324C4-7A2C-3ADC-B697-5CF52B5E2E68}']
  { methods } 

    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;

  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IFindsByName')]
  DNIFindsByName = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{520C10F8-C462-3F4E-BA37-A469F056EA4F}']
  { methods } 

    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;

  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IFindsByPartialLinkText')]
  DNIFindsByPartialLinkText = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{ECBB04B9-6FBD-39E9-B33A-9D15F8EE4948}']
  { methods } 

    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;

  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IFindsByTagName')]
  DNIFindsByTagName = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{5718DB68-92B0-3617-AF49-743EE308AFEF}']
  { methods } 

    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;

  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IFindsByXPath')]
  DNIFindsByXPath = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{8EA9D700-B52F-350D-9902-DDBF00981FD0}']
  { methods } 

    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;

  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IWrapsDriver')]
  DNIWrapsDriver = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{27EB7D21-7B21-3117-A51D-92268006E526}']
  { getters & setters } 

    function get_WrappedDriver: DNIWebDriver;

  { propertys } 

    property WrappedDriver: DNIWebDriver read get_WrappedDriver;
  end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  [DNTypeName('OpenQA.Selenium.Internal.IWrapsElement')]
  DNIWrapsElement = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B7A1CE37-506F-3854-8172-7F9C92092F59}']
  { getters & setters } 

    function get_WrappedElement: DNIWebElement;

  { propertys } 

    property WrappedElement: DNIWebElement read get_WrappedElement;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IOptions')]
  DNIOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{66653B1C-CA49-354B-B740-18324DAD4A06}']
  { getters & setters } 

    function get_Cookies: DNICookieJar;
    function get_Window: DNIWindow;
    function get_Logs: DNILogs;

  { methods } 

    function Timeouts: DNITimeouts;

  { propertys } 

    property Cookies: DNICookieJar read get_Cookies;
    property Window: DNIWindow read get_Window;
    property Logs: DNILogs read get_Logs;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IRotatable')]
  DNIRotatable = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F3665991-B99E-3D5B-B3ED-C3A04303688C}']
  { getters & setters } 

    function get_Orientation: DNScreenOrientation;
    procedure set_Orientation(value: DNScreenOrientation);

  { propertys } 

    property Orientation: DNScreenOrientation read get_Orientation write set_Orientation;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ISearchContext')]
  DNISearchContext = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FACE9609-D4DD-39A7-A236-D9659A721122}']
  { methods } 

    function FindElement(by: DNBy): DNIWebElement;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;

  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IWebDriver')]
  DNIWebDriver = interface(DNISearchContext)
  ['{1C9DFC62-736E-3B41-9244-B5204C699BA5}']
  { getters & setters } 

    function get_Url: string;
    procedure set_Url(value: string);
    function get_Title: string;
    function get_PageSource: string;
    function get_CurrentWindowHandle: string;
    function get_WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;

  { methods } 

    procedure Close;
    procedure Quit;
    function Manage: DNIOptions;
    function Navigate: DNINavigation;
    function SwitchTo: DNITargetLocator;

  { propertys } 

    property Url: string read get_Url write set_Url;
    property Title: string read get_Title;
    property PageSource: string read get_PageSource;
    property CurrentWindowHandle: string read get_CurrentWindowHandle;
    property WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_WindowHandles;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IWebElement')]
  DNIWebElement = interface(DNISearchContext)
  ['{F2FF91B3-9706-3E3A-B922-B972954CCBA8}']
  { getters & setters } 

    function get_TagName: string;
    function get_Text: string;
    function get_Enabled: Boolean;
    function get_Selected: Boolean;
    function get_Location: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Size: DDNC.System.Drawing.Primitives.DNSize;
    function get_Displayed: Boolean;

  { methods } 

    procedure Clear;
    procedure SendKeys(text: string);
    procedure Submit;
    procedure Click;
    function GetAttribute(attributeName: string): string;
    function GetProperty(propertyName: string): string;
    function GetCssValue(propertyName: string): string;

  { propertys } 

    property TagName: string read get_TagName;
    property Text: string read get_Text;
    property Enabled: Boolean read get_Enabled;
    property Selected: Boolean read get_Selected;
    property Location: DDNC.System.Drawing.Primitives.DNPoint read get_Location;
    property Size: DDNC.System.Drawing.Primitives.DNSize read get_Size;
    property Displayed: Boolean read get_Displayed;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ITakesScreenshot')]
  DNITakesScreenshot = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{608D96EF-01A3-3122-B48F-8D09E2905BA2}']
  { methods } 

    function GetScreenshot: DNScreenshot;

  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ITargetLocator')]
  DNITargetLocator = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E5443C94-1885-3B1F-88F9-2015EE3FBAD2}']
  { methods } 

    function Frame(frameIndex: Int32): DNIWebDriver; overload;
    function Frame(frameName: string): DNIWebDriver; overload;
    function Frame(frameElement: DNIWebElement): DNIWebDriver; overload;
    function ParentFrame: DNIWebDriver;
    function Window(windowName: string): DNIWebDriver;
    function DefaultContent: DNIWebDriver;
    function ActiveElement: DNIWebElement;
    function Alert: DNIAlert;

  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ITimeouts')]
  DNITimeouts = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{51891E66-72D9-350A-9CDD-128EBE5AC72F}']
  { getters & setters } 

    function get_ImplicitWait: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_ImplicitWait(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_AsynchronousJavaScript: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_AsynchronousJavaScript(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_PageLoad: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PageLoad(value: DDNC.System.Private.CoreLib.DNTimeSpan);

  { propertys } 

    property ImplicitWait: DDNC.System.Private.CoreLib.DNTimeSpan read get_ImplicitWait write set_ImplicitWait;
    property AsynchronousJavaScript: DDNC.System.Private.CoreLib.DNTimeSpan read get_AsynchronousJavaScript write set_AsynchronousJavaScript;
    property PageLoad: DDNC.System.Private.CoreLib.DNTimeSpan read get_PageLoad write set_PageLoad;
  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.ITouchScreen')]
  DNITouchScreen = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A0AD896F-D924-36FD-9F61-107277EB3470}']
  { methods } 

    procedure SingleTap(where: DNICoordinates);
    procedure Down(locationX: Int32; locationY: Int32);
    procedure Up(locationX: Int32; locationY: Int32);
    procedure Move(locationX: Int32; locationY: Int32);
    procedure Scroll(where: DNICoordinates; offsetX: Int32; offsetY: Int32); overload;
    procedure Scroll(offsetX: Int32; offsetY: Int32); overload;
    procedure DoubleTap(where: DNICoordinates);
    procedure LongPress(where: DNICoordinates);
    procedure Flick(speedX: Int32; speedY: Int32); overload;
    procedure Flick(where: DNICoordinates; offsetX: Int32; offsetY: Int32; speed: Int32); overload;

  end;

  //-------------namespace: OpenQA.Selenium----------------
  [DNTypeName('OpenQA.Selenium.IWindow')]
  DNIWindow = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{24E30C72-DB5D-3F99-93E8-C521A8AE8B34}']
  { getters & setters } 

    function get_Position: DDNC.System.Drawing.Primitives.DNPoint;
    procedure set_Position(value: DDNC.System.Drawing.Primitives.DNPoint);
    function get_Size: DDNC.System.Drawing.Primitives.DNSize;
    procedure set_Size(value: DDNC.System.Drawing.Primitives.DNSize);

  { methods } 

    procedure Maximize;
    procedure Minimize;
    procedure FullScreen;

  { propertys } 

    property Position: DDNC.System.Drawing.Primitives.DNPoint read get_Position write set_Position;
    property Size: DDNC.System.Drawing.Primitives.DNSize read get_Size write set_Size;
  end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  [DNTypeName('OpenQA.Selenium.Remote.IHasSessionId')]
  DNIHasSessionId = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{AC523B5F-AAA8-3381-8850-8E8806B1EBD4}']
  { getters & setters } 

    function get_SessionId: DNSessionId;

  { propertys } 

    property SessionId: DNSessionId read get_SessionId;
  end;

  //-------------namespace: OpenQA.Selenium.Support.UI----------------
  [DNTypeName('OpenQA.Selenium.Support.UI.IClock')]
  DNIClock = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{02597229-768E-3BFE-977C-A0F27E106BD9}']
  { getters & setters } 

    function get_Now: DDNC.System.Private.CoreLib.DNDateTime;

  { methods } 

    function LaterBy(delay: DDNC.System.Private.CoreLib.DNTimeSpan): DDNC.System.Private.CoreLib.DNDateTime;
    function IsNowBefore(otherDateTime: DDNC.System.Private.CoreLib.DNDateTime): Boolean;

  { propertys } 

    property Now: DDNC.System.Private.CoreLib.DNDateTime read get_Now;
  end;

  //-------------namespace: OpenQA.Selenium.Support.UI----------------
  [DNTypeName('OpenQA.Selenium.Support.UI.IWait`1')]
  DNIWait<T> = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A96D070A-8A65-354E-BFE0-9EB143B66819}']
  { getters & setters } 

    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_PollingInterval: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PollingInterval(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_Message: string;
    procedure set_Message(value: string);

  { methods } 

    procedure IgnoreExceptionTypes(exceptionTypes: TArray<DDNC.System.Private.CoreLib.DNType>);

  { propertys } 

    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
    property PollingInterval: DDNC.System.Private.CoreLib.DNTimeSpan read get_PollingInterval write set_PollingInterval;
    property Message: string read get_Message write set_Message;
  end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  [DNTypeName('OpenQA.Selenium.Remote.ICommandExecutor')]
  DNICommandExecutor = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{31025164-17F7-396D-B574-F0E0D48FCA6B}']
  { getters & setters } 

    function get_CommandInfoRepository: DNCommandInfoRepository;

  { methods } 

    function Execute(commandToExecute: DNCommand): DNResponse;

  { propertys } 

    property CommandInfoRepository: DNCommandInfoRepository read get_CommandInfoRepository;
  end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  [DNTypeName('OpenQA.Selenium.Remote.ICommandServer')]
  DNICommandServer = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{D97CBE6B-14F0-3351-B19F-E241D4EB993F}']
  { methods } 

    procedure Start;

  end;

  //-------------namespace: OpenQA.Selenium----------------
  DNByClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{01F202D5-4718-5D26-B064-3A570E715B3A}']
  { static methods } 

    {class} function Id(idToFind: string): DNBy;
    {class} function LinkText(linkTextToFind: string): DNBy;
    {class} function Name(nameToFind: string): DNBy;
    {class} function XPath(xpathToFind: string): DNBy;
    {class} function ClassName(classNameToFind: string): DNBy;
    {class} function PartialLinkText(partialLinkTextToFind: string): DNBy;
    {class} function TagName(tagNameToFind: string): DNBy;
    {class} function CssSelector(cssSelectorToFind: string): DNBy;

  end;

  [DNTypeName('OpenQA.Selenium.By')]
  DNBy = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{24A461DF-0D81-3A6D-AD55-D5015EF4DDC6}']
  { methods } 

    function FindElement(context: DNISearchContext): DNIWebElement;
    function FindElements(context: DNISearchContext): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNBy = class(TDNGenericImport<DNByClass, DNBy>) end;

  //-------------namespace: OpenQA.Selenium.Chrome----------------
  DNChromeMobileEmulationDeviceSettingsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{AC9DA3B5-59D4-5E1E-938E-7C4A5D55F3A4}']
  { constructors } 

    {class} function init: DNChromeMobileEmulationDeviceSettings; overload;
    {class} function init(userAgent: string): DNChromeMobileEmulationDeviceSettings; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Chrome.ChromeMobileEmulationDeviceSettings')]
  DNChromeMobileEmulationDeviceSettings = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A68EDD3F-D31B-35D2-A9F4-8210DFBACD7B}']
  { getters & setters } 

    function get_UserAgent: string;
    procedure set_UserAgent(value: string);
    function get_Width: Int64;
    procedure set_Width(value: Int64);
    function get_Height: Int64;
    procedure set_Height(value: Int64);
    function get_PixelRatio: Double;
    procedure set_PixelRatio(value: Double);
    function get_EnableTouchEvents: Boolean;
    procedure set_EnableTouchEvents(value: Boolean);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property UserAgent: string read get_UserAgent write set_UserAgent;
    property Width: Int64 read get_Width write set_Width;
    property Height: Int64 read get_Height write set_Height;
    property PixelRatio: Double read get_PixelRatio write set_PixelRatio;
    property EnableTouchEvents: Boolean read get_EnableTouchEvents write set_EnableTouchEvents;
  end;

  TDNChromeMobileEmulationDeviceSettings = class(TDNGenericImport<DNChromeMobileEmulationDeviceSettingsClass, DNChromeMobileEmulationDeviceSettings>) end;

  //-------------namespace: OpenQA.Selenium.Chrome----------------
  DNChromeNetworkConditionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{B988572E-7592-534F-8B2A-81D3C1FCBC71}']
  { constructors } 

    {class} function init: DNChromeNetworkConditions;

  end;

  [DNTypeName('OpenQA.Selenium.Chrome.ChromeNetworkConditions')]
  DNChromeNetworkConditions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{CF025EE3-6067-36A9-AE9E-D16405C34F06}']
  { getters & setters } 

    function get_IsOffline: Boolean;
    procedure set_IsOffline(value: Boolean);
    function get_Latency: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Latency(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_DownloadThroughput: Int64;
    procedure set_DownloadThroughput(value: Int64);
    function get_UploadThroughput: Int64;
    procedure set_UploadThroughput(value: Int64);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsOffline: Boolean read get_IsOffline write set_IsOffline;
    property Latency: DDNC.System.Private.CoreLib.DNTimeSpan read get_Latency write set_Latency;
    property DownloadThroughput: Int64 read get_DownloadThroughput write set_DownloadThroughput;
    property UploadThroughput: Int64 read get_UploadThroughput write set_UploadThroughput;
  end;

  TDNChromeNetworkConditions = class(TDNGenericImport<DNChromeNetworkConditionsClass, DNChromeNetworkConditions>) end;

  //-------------namespace: OpenQA.Selenium.Chrome----------------
  DNChromePerformanceLoggingPreferencesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{B36B15B6-65C9-5501-9606-1B00DCF44FFF}']
  { constructors } 

    {class} function init: DNChromePerformanceLoggingPreferences;

  end;

  [DNTypeName('OpenQA.Selenium.Chrome.ChromePerformanceLoggingPreferences')]
  DNChromePerformanceLoggingPreferences = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2DDED39A-75AD-34A7-AB8A-3E6458752868}']
  { getters & setters } 

    function get_IsCollectingNetworkEvents: Boolean;
    procedure set_IsCollectingNetworkEvents(value: Boolean);
    function get_IsCollectingPageEvents: Boolean;
    procedure set_IsCollectingPageEvents(value: Boolean);
    function get_BufferUsageReportingInterval: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_BufferUsageReportingInterval(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_TracingCategories: string;

  { methods } 

    procedure AddTracingCategory(category: string);
    procedure AddTracingCategories(categoriesToAdd: TArray<string>); overload;
    procedure AddTracingCategories(categoriesToAdd: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsCollectingNetworkEvents: Boolean read get_IsCollectingNetworkEvents write set_IsCollectingNetworkEvents;
    property IsCollectingPageEvents: Boolean read get_IsCollectingPageEvents write set_IsCollectingPageEvents;
    property BufferUsageReportingInterval: DDNC.System.Private.CoreLib.DNTimeSpan read get_BufferUsageReportingInterval write set_BufferUsageReportingInterval;
    property TracingCategories: string read get_TracingCategories;
  end;

  TDNChromePerformanceLoggingPreferences = class(TDNGenericImport<DNChromePerformanceLoggingPreferencesClass, DNChromePerformanceLoggingPreferences>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNCookieClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{2B88526F-7837-5CAA-89B6-030B0958DB29}']
  { constructors } 

    {class} function init(name: string; value: string; domain: string; path: string; expiry: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTime>): DNCookie; overload;
    {class} function init(name: string; value: string; path: string; expiry: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTime>): DNCookie; overload;
    {class} function init(name: string; value: string; path: string): DNCookie; overload;
    {class} function init(name: string; value: string): DNCookie; overload;

  { static methods } 

    {class} function FromDictionary(rawCookie: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): DNCookie;

  end;

  [DNTypeName('OpenQA.Selenium.Cookie')]
  DNCookie = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{93098667-DDA2-3C7F-AB89-1223F2148ACA}']
  { getters & setters } 

    function get_Name: string;
    function get_Value: string;
    function get_Domain: string;
    function get_Path: string;
    function get_Secure: Boolean;
    function get_IsHttpOnly: Boolean;
    function get_Expiry: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTime>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Name: string read get_Name;
    property Value: string read get_Value;
    property Domain: string read get_Domain;
    property Path: string read get_Path;
    property Secure: Boolean read get_Secure;
    property IsHttpOnly: Boolean read get_IsHttpOnly;
    property Expiry: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTime> read get_Expiry;
  end;

  TDNCookie = class(TDNGenericImport<DNCookieClass, DNCookie>) end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  DNReturnedCookieClass = interface(DNCookieClass)
  ['{FEC4FE6E-8D99-5EE1-949B-DC42AFA9C029}']
  { constructors } 

    {class} function init(name: string; value: string; domain: string; path: string; expiry: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTime>; isSecure: Boolean; isHttpOnly: Boolean): DNReturnedCookie;

  end;

  [DNTypeName('OpenQA.Selenium.Internal.ReturnedCookie')]
  DNReturnedCookie = interface(DNCookie)
  ['{D727AF01-673B-3A2F-98F4-065DDFD641DC}']
  { getters & setters } 

    function get_Secure: Boolean;
    function get_IsHttpOnly: Boolean;
    function get_Name: string;
    function get_Value: string;
    function get_Domain: string;
    function get_Path: string;
    function get_Expiry: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTime>;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Secure: Boolean read get_Secure;
    property IsHttpOnly: Boolean read get_IsHttpOnly;
    property Name: string read get_Name;
    property Value: string read get_Value;
    property Domain: string read get_Domain;
    property Path: string read get_Path;
    property Expiry: DDNC.System.Private.CoreLib.DNNullable<DDNC.System.Private.CoreLib.DNDateTime> read get_Expiry;
  end;

  TDNReturnedCookie = class(TDNGenericImport<DNReturnedCookieClass, DNReturnedCookie>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNDefaultFileDetectorClass = interface(DNObjectClass)
  ['{A6A87592-88F0-5978-9292-5848354DB2BC}']
  { constructors } 

    {class} function init: DNDefaultFileDetector;

  end;

  [DNTypeName('OpenQA.Selenium.DefaultFileDetector')]
  DNDefaultFileDetector = interface(DNIFileDetector)
  ['{0BD57FEE-A0EF-3DD3-BD34-25081828B9BA}']
  { methods } 

    function IsFile(keySequence: string): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNDefaultFileDetector = class(TDNGenericImport<DNDefaultFileDetectorClass, DNDefaultFileDetector>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNDriverOptionsClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{434A2E4F-9BA7-5837-B585-EAFFD65EC64A}']
  end;

  [DNTypeName('OpenQA.Selenium.DriverOptions')]
  DNDriverOptions = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{518FDA50-CF9F-35B2-A099-6B0CC78815B2}']
  { getters & setters } 

    function get_BrowserName: string;
    function get_BrowserVersion: string;
    procedure set_BrowserVersion(value: string);
    function get_PlatformName: string;
    procedure set_PlatformName(value: string);
    function get_AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_AcceptInsecureCertificates(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_UnhandledPromptBehavior: DNUnhandledPromptBehavior;
    procedure set_UnhandledPromptBehavior(value: DNUnhandledPromptBehavior);
    function get_PageLoadStrategy: DNPageLoadStrategy;
    procedure set_PageLoadStrategy(value: DNPageLoadStrategy);
    function get_Proxy: DNProxy;
    procedure set_Proxy(value: DNProxy);

  { methods } 

    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject);
    function ToCapabilities: DNICapabilities;
    function GetMergeResult(other: DNDriverOptions): DNDriverOptionsMergeResult;
    procedure SetLoggingPreference(logType: string; logLevel: DNLogLevel);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property BrowserName: string read get_BrowserName;
    property BrowserVersion: string read get_BrowserVersion write set_BrowserVersion;
    property PlatformName: string read get_PlatformName write set_PlatformName;
    property AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_AcceptInsecureCertificates write set_AcceptInsecureCertificates;
    property UnhandledPromptBehavior: DNUnhandledPromptBehavior read get_UnhandledPromptBehavior write set_UnhandledPromptBehavior;
    property PageLoadStrategy: DNPageLoadStrategy read get_PageLoadStrategy write set_PageLoadStrategy;
    property Proxy: DNProxy read get_Proxy write set_Proxy;
  end;

  TDNDriverOptions = class(TDNGenericImport<DNDriverOptionsClass, DNDriverOptions>) end;

  //-------------namespace: OpenQA.Selenium.Chrome----------------
  DNChromeOptionsClass = interface(DNDriverOptionsClass)
  ['{D5CAAE11-70A8-5042-9042-3B51BAF94ED4}']
  { constructors } 

    {class} function init: DNChromeOptions;

  { static fields getter & setter } 

   function __fakeFieldGet_Capability: string;

  { static fields } 

    {class} property Capability: string read __fakeFieldGet_Capability;

  end;

  [DNTypeName('OpenQA.Selenium.Chrome.ChromeOptions')]
  DNChromeOptions = interface(DNDriverOptions)
  ['{4399751C-1BB5-3E04-9C43-9C2EEBA578CC}']
  { getters & setters } 

    function get_BinaryLocation: string;
    procedure set_BinaryLocation(value: string);
    function get_LeaveBrowserRunning: Boolean;
    procedure set_LeaveBrowserRunning(value: Boolean);
    function get_Arguments: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_Extensions: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_DebuggerAddress: string;
    procedure set_DebuggerAddress(value: string);
    function get_MinidumpPath: string;
    procedure set_MinidumpPath(value: string);
    function get_PerformanceLoggingPreferences: DNChromePerformanceLoggingPreferences;
    procedure set_PerformanceLoggingPreferences(value: DNChromePerformanceLoggingPreferences);
    function get_UseSpecCompliantProtocol: Boolean;
    procedure set_UseSpecCompliantProtocol(value: Boolean);
    function get_BrowserName: string;
    function get_BrowserVersion: string;
    procedure set_BrowserVersion(value: string);
    function get_PlatformName: string;
    procedure set_PlatformName(value: string);
    function get_AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_AcceptInsecureCertificates(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_UnhandledPromptBehavior: DNUnhandledPromptBehavior;
    procedure set_UnhandledPromptBehavior(value: DNUnhandledPromptBehavior);
    function get_PageLoadStrategy: DNPageLoadStrategy;
    procedure set_PageLoadStrategy(value: DNPageLoadStrategy);
    function get_Proxy: DNProxy;
    procedure set_Proxy(value: DNProxy);

  { methods } 

    procedure AddArgument(argument: string);
    procedure AddArguments(argumentsToAdd: TArray<string>); overload;
    procedure AddArguments(argumentsToAdd: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddExcludedArgument(argument: string);
    procedure AddExcludedArguments(argumentsToExclude: TArray<string>); overload;
    procedure AddExcludedArguments(argumentsToExclude: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddExtension(pathToExtension: string);
    procedure AddExtensions(extensions: TArray<string>); overload;
    procedure AddExtensions(extensions: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddEncodedExtension(extension: string);
    procedure AddEncodedExtensions(extensions: TArray<string>); overload;
    procedure AddEncodedExtensions(extensions: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddUserProfilePreference(preferenceName: string; preferenceValue: DDNC.System.Private.CoreLib.DNObject);
    procedure AddLocalStatePreference(preferenceName: string; preferenceValue: DDNC.System.Private.CoreLib.DNObject);
    procedure EnableMobileEmulation(deviceName: string); overload;
    procedure EnableMobileEmulation(deviceSettings: DNChromeMobileEmulationDeviceSettings); overload;
    procedure AddWindowType(windowType: string);
    procedure AddWindowTypes(windowTypesToAdd: TArray<string>); overload;
    procedure AddWindowTypes(windowTypesToAdd: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject); overload;
    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject; isGlobalCapability: Boolean); overload;
    function ToCapabilities: DNICapabilities;
    function GetMergeResult(other: DNDriverOptions): DNDriverOptionsMergeResult;
    procedure SetLoggingPreference(logType: string; logLevel: DNLogLevel);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property BinaryLocation: string read get_BinaryLocation write set_BinaryLocation;
    property LeaveBrowserRunning: Boolean read get_LeaveBrowserRunning write set_LeaveBrowserRunning;
    property Arguments: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_Arguments;
    property Extensions: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_Extensions;
    property DebuggerAddress: string read get_DebuggerAddress write set_DebuggerAddress;
    property MinidumpPath: string read get_MinidumpPath write set_MinidumpPath;
    property PerformanceLoggingPreferences: DNChromePerformanceLoggingPreferences read get_PerformanceLoggingPreferences write set_PerformanceLoggingPreferences;
    property UseSpecCompliantProtocol: Boolean read get_UseSpecCompliantProtocol write set_UseSpecCompliantProtocol;
    property BrowserName: string read get_BrowserName;
    property BrowserVersion: string read get_BrowserVersion write set_BrowserVersion;
    property PlatformName: string read get_PlatformName write set_PlatformName;
    property AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_AcceptInsecureCertificates write set_AcceptInsecureCertificates;
    property UnhandledPromptBehavior: DNUnhandledPromptBehavior read get_UnhandledPromptBehavior write set_UnhandledPromptBehavior;
    property PageLoadStrategy: DNPageLoadStrategy read get_PageLoadStrategy write set_PageLoadStrategy;
    property Proxy: DNProxy read get_Proxy write set_Proxy;
  end;

  TDNChromeOptions = class(TDNGenericImport<DNChromeOptionsClass, DNChromeOptions>) end;

  //-------------namespace: OpenQA.Selenium.Edge----------------
  DNEdgeOptionsClass = interface(DNDriverOptionsClass)
  ['{48F51FEE-BA61-560E-B4D7-E4E7F7B3C318}']
  { constructors } 

    {class} function init: DNEdgeOptions;

  end;

  [DNTypeName('OpenQA.Selenium.Edge.EdgeOptions')]
  DNEdgeOptions = interface(DNDriverOptions)
  ['{73A7DB87-BB42-3FE3-BFD4-B4916FA036C9}']
  { getters & setters } 

    function get_UseInPrivateBrowsing: Boolean;
    procedure set_UseInPrivateBrowsing(value: Boolean);
    function get_StartPage: string;
    procedure set_StartPage(value: string);
    function get_BrowserName: string;
    function get_BrowserVersion: string;
    procedure set_BrowserVersion(value: string);
    function get_PlatformName: string;
    procedure set_PlatformName(value: string);
    function get_AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_AcceptInsecureCertificates(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_UnhandledPromptBehavior: DNUnhandledPromptBehavior;
    procedure set_UnhandledPromptBehavior(value: DNUnhandledPromptBehavior);
    function get_PageLoadStrategy: DNPageLoadStrategy;
    procedure set_PageLoadStrategy(value: DNPageLoadStrategy);
    function get_Proxy: DNProxy;
    procedure set_Proxy(value: DNProxy);

  { methods } 

    procedure AddExtensionPath(extensionPath: string);
    procedure AddExtensionPaths(extensionPathsToAdd: TArray<string>); overload;
    procedure AddExtensionPaths(extensionPathsToAdd: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject);
    function ToCapabilities: DNICapabilities;
    function GetMergeResult(other: DNDriverOptions): DNDriverOptionsMergeResult;
    procedure SetLoggingPreference(logType: string; logLevel: DNLogLevel);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property UseInPrivateBrowsing: Boolean read get_UseInPrivateBrowsing write set_UseInPrivateBrowsing;
    property StartPage: string read get_StartPage write set_StartPage;
    property BrowserName: string read get_BrowserName;
    property BrowserVersion: string read get_BrowserVersion write set_BrowserVersion;
    property PlatformName: string read get_PlatformName write set_PlatformName;
    property AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_AcceptInsecureCertificates write set_AcceptInsecureCertificates;
    property UnhandledPromptBehavior: DNUnhandledPromptBehavior read get_UnhandledPromptBehavior write set_UnhandledPromptBehavior;
    property PageLoadStrategy: DNPageLoadStrategy read get_PageLoadStrategy write set_PageLoadStrategy;
    property Proxy: DNProxy read get_Proxy write set_Proxy;
  end;

  TDNEdgeOptions = class(TDNGenericImport<DNEdgeOptionsClass, DNEdgeOptions>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxOptionsClass = interface(DNDriverOptionsClass)
  ['{86945BB8-D974-50CF-9230-B259D1F56434}']
  { constructors } 

    {class} function init: DNFirefoxOptions;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxOptions')]
  DNFirefoxOptions = interface(DNDriverOptions)
  ['{47D6391E-BCC5-3D8B-BA3C-390852A51B10}']
  { getters & setters } 

    function get_UseLegacyImplementation: Boolean;
    procedure set_UseLegacyImplementation(value: Boolean);
    function get_Profile: DNFirefoxProfile;
    procedure set_Profile(value: DNFirefoxProfile);
    function get_BrowserExecutableLocation: string;
    procedure set_BrowserExecutableLocation(value: string);
    function get_LogLevel: DNFirefoxDriverLogLevel;
    procedure set_LogLevel(value: DNFirefoxDriverLogLevel);
    function get_BrowserName: string;
    function get_BrowserVersion: string;
    procedure set_BrowserVersion(value: string);
    function get_PlatformName: string;
    procedure set_PlatformName(value: string);
    function get_AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_AcceptInsecureCertificates(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_UnhandledPromptBehavior: DNUnhandledPromptBehavior;
    procedure set_UnhandledPromptBehavior(value: DNUnhandledPromptBehavior);
    function get_PageLoadStrategy: DNPageLoadStrategy;
    procedure set_PageLoadStrategy(value: DNPageLoadStrategy);
    function get_Proxy: DNProxy;
    procedure set_Proxy(value: DNProxy);

  { methods } 

    procedure AddArgument(argumentName: string);
    procedure AddArguments(argumentsToAdd: TArray<string>); overload;
    procedure AddArguments(argumentsToAdd: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure SetPreference(preferenceName: string; preferenceValue: Boolean); overload;
    procedure SetPreference(preferenceName: string; preferenceValue: Int32); overload;
    procedure SetPreference(preferenceName: string; preferenceValue: Int64); overload;
    procedure SetPreference(preferenceName: string; preferenceValue: Double); overload;
    procedure SetPreference(preferenceName: string; preferenceValue: string); overload;
    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject); overload;
    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject; isGlobalCapability: Boolean); overload;
    function ToCapabilities: DNICapabilities;
    function GetMergeResult(other: DNDriverOptions): DNDriverOptionsMergeResult;
    procedure SetLoggingPreference(logType: string; logLevel: DNLogLevel);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property UseLegacyImplementation: Boolean read get_UseLegacyImplementation write set_UseLegacyImplementation;
    property Profile: DNFirefoxProfile read get_Profile write set_Profile;
    property BrowserExecutableLocation: string read get_BrowserExecutableLocation write set_BrowserExecutableLocation;
    property LogLevel: DNFirefoxDriverLogLevel read get_LogLevel write set_LogLevel;
    property BrowserName: string read get_BrowserName;
    property BrowserVersion: string read get_BrowserVersion write set_BrowserVersion;
    property PlatformName: string read get_PlatformName write set_PlatformName;
    property AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_AcceptInsecureCertificates write set_AcceptInsecureCertificates;
    property UnhandledPromptBehavior: DNUnhandledPromptBehavior read get_UnhandledPromptBehavior write set_UnhandledPromptBehavior;
    property PageLoadStrategy: DNPageLoadStrategy read get_PageLoadStrategy write set_PageLoadStrategy;
    property Proxy: DNProxy read get_Proxy write set_Proxy;
  end;

  TDNFirefoxOptions = class(TDNGenericImport<DNFirefoxOptionsClass, DNFirefoxOptions>) end;

  //-------------namespace: OpenQA.Selenium.IE----------------
  DNInternetExplorerOptionsClass = interface(DNDriverOptionsClass)
  ['{38843323-992E-5231-9476-F054A117DFB8}']
  { constructors } 

    {class} function init: DNInternetExplorerOptions;

  { static fields getter & setter } 

   function __fakeFieldGet_Capability: string;

  { static fields } 

    {class} property Capability: string read __fakeFieldGet_Capability;

  end;

  [DNTypeName('OpenQA.Selenium.IE.InternetExplorerOptions')]
  DNInternetExplorerOptions = interface(DNDriverOptions)
  ['{17A8C557-B790-3386-AFEE-6296E0B6F136}']
  { getters & setters } 

    function get_IntroduceInstabilityByIgnoringProtectedModeSettings: Boolean;
    procedure set_IntroduceInstabilityByIgnoringProtectedModeSettings(value: Boolean);
    function get_IgnoreZoomLevel: Boolean;
    procedure set_IgnoreZoomLevel(value: Boolean);
    function get_EnableNativeEvents: Boolean;
    procedure set_EnableNativeEvents(value: Boolean);
    function get_RequireWindowFocus: Boolean;
    procedure set_RequireWindowFocus(value: Boolean);
    function get_InitialBrowserUrl: string;
    procedure set_InitialBrowserUrl(value: string);
    function get_ElementScrollBehavior: DNInternetExplorerElementScrollBehavior;
    procedure set_ElementScrollBehavior(value: DNInternetExplorerElementScrollBehavior);
    function get_EnablePersistentHover: Boolean;
    procedure set_EnablePersistentHover(value: Boolean);
    function get_BrowserAttachTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_BrowserAttachTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_FileUploadDialogTimeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_FileUploadDialogTimeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_ForceCreateProcessApi: Boolean;
    procedure set_ForceCreateProcessApi(value: Boolean);
    function get_ForceShellWindowsApi: Boolean;
    procedure set_ForceShellWindowsApi(value: Boolean);
    function get_BrowserCommandLineArguments: string;
    procedure set_BrowserCommandLineArguments(value: string);
    function get_UsePerProcessProxy: Boolean;
    procedure set_UsePerProcessProxy(value: Boolean);
    function get_EnsureCleanSession: Boolean;
    procedure set_EnsureCleanSession(value: Boolean);
    function get_BrowserName: string;
    function get_BrowserVersion: string;
    procedure set_BrowserVersion(value: string);
    function get_PlatformName: string;
    procedure set_PlatformName(value: string);
    function get_AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_AcceptInsecureCertificates(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_UnhandledPromptBehavior: DNUnhandledPromptBehavior;
    procedure set_UnhandledPromptBehavior(value: DNUnhandledPromptBehavior);
    function get_PageLoadStrategy: DNPageLoadStrategy;
    procedure set_PageLoadStrategy(value: DNPageLoadStrategy);
    function get_Proxy: DNProxy;
    procedure set_Proxy(value: DNProxy);

  { methods } 

    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject); overload;
    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject; isGlobalCapability: Boolean); overload;
    function ToCapabilities: DNICapabilities;
    function GetMergeResult(other: DNDriverOptions): DNDriverOptionsMergeResult;
    procedure SetLoggingPreference(logType: string; logLevel: DNLogLevel);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IntroduceInstabilityByIgnoringProtectedModeSettings: Boolean read get_IntroduceInstabilityByIgnoringProtectedModeSettings write set_IntroduceInstabilityByIgnoringProtectedModeSettings;
    property IgnoreZoomLevel: Boolean read get_IgnoreZoomLevel write set_IgnoreZoomLevel;
    property EnableNativeEvents: Boolean read get_EnableNativeEvents write set_EnableNativeEvents;
    property RequireWindowFocus: Boolean read get_RequireWindowFocus write set_RequireWindowFocus;
    property InitialBrowserUrl: string read get_InitialBrowserUrl write set_InitialBrowserUrl;
    property ElementScrollBehavior: DNInternetExplorerElementScrollBehavior read get_ElementScrollBehavior write set_ElementScrollBehavior;
    property EnablePersistentHover: Boolean read get_EnablePersistentHover write set_EnablePersistentHover;
    property BrowserAttachTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_BrowserAttachTimeout write set_BrowserAttachTimeout;
    property FileUploadDialogTimeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_FileUploadDialogTimeout write set_FileUploadDialogTimeout;
    property ForceCreateProcessApi: Boolean read get_ForceCreateProcessApi write set_ForceCreateProcessApi;
    property ForceShellWindowsApi: Boolean read get_ForceShellWindowsApi write set_ForceShellWindowsApi;
    property BrowserCommandLineArguments: string read get_BrowserCommandLineArguments write set_BrowserCommandLineArguments;
    property UsePerProcessProxy: Boolean read get_UsePerProcessProxy write set_UsePerProcessProxy;
    property EnsureCleanSession: Boolean read get_EnsureCleanSession write set_EnsureCleanSession;
    property BrowserName: string read get_BrowserName;
    property BrowserVersion: string read get_BrowserVersion write set_BrowserVersion;
    property PlatformName: string read get_PlatformName write set_PlatformName;
    property AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_AcceptInsecureCertificates write set_AcceptInsecureCertificates;
    property UnhandledPromptBehavior: DNUnhandledPromptBehavior read get_UnhandledPromptBehavior write set_UnhandledPromptBehavior;
    property PageLoadStrategy: DNPageLoadStrategy read get_PageLoadStrategy write set_PageLoadStrategy;
    property Proxy: DNProxy read get_Proxy write set_Proxy;
  end;

  TDNInternetExplorerOptions = class(TDNGenericImport<DNInternetExplorerOptionsClass, DNInternetExplorerOptions>) end;

  //-------------namespace: OpenQA.Selenium.Opera----------------
  DNOperaOptionsClass = interface(DNDriverOptionsClass)
  ['{B8A4BEB1-2C79-5E94-B6D3-A35B825EE691}']
  { constructors } 

    {class} function init: DNOperaOptions;

  { static fields getter & setter } 

   function __fakeFieldGet_Capability: string;

  { static fields } 

    {class} property Capability: string read __fakeFieldGet_Capability;

  end;

  [DNTypeName('OpenQA.Selenium.Opera.OperaOptions')]
  DNOperaOptions = interface(DNDriverOptions)
  ['{022A95BE-372B-37AD-B727-6D974036B290}']
  { getters & setters } 

    function get_BinaryLocation: string;
    procedure set_BinaryLocation(value: string);
    function get_LeaveBrowserRunning: Boolean;
    procedure set_LeaveBrowserRunning(value: Boolean);
    function get_Arguments: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_Extensions: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_DebuggerAddress: string;
    procedure set_DebuggerAddress(value: string);
    function get_MinidumpPath: string;
    procedure set_MinidumpPath(value: string);
    function get_BrowserName: string;
    function get_BrowserVersion: string;
    procedure set_BrowserVersion(value: string);
    function get_PlatformName: string;
    procedure set_PlatformName(value: string);
    function get_AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_AcceptInsecureCertificates(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_UnhandledPromptBehavior: DNUnhandledPromptBehavior;
    procedure set_UnhandledPromptBehavior(value: DNUnhandledPromptBehavior);
    function get_PageLoadStrategy: DNPageLoadStrategy;
    procedure set_PageLoadStrategy(value: DNPageLoadStrategy);
    function get_Proxy: DNProxy;
    procedure set_Proxy(value: DNProxy);

  { methods } 

    procedure AddArgument(argument: string);
    procedure AddArguments(argumentsToAdd: TArray<string>); overload;
    procedure AddArguments(argumentsToAdd: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddExcludedArgument(argument: string);
    procedure AddExcludedArguments(argumentsToExclude: TArray<string>); overload;
    procedure AddExcludedArguments(argumentsToExclude: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddExtension(pathToExtension: string);
    procedure AddExtensions(extensions: TArray<string>); overload;
    procedure AddExtensions(extensions: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddEncodedExtension(extension: string);
    procedure AddEncodedExtensions(extensions: TArray<string>); overload;
    procedure AddEncodedExtensions(extensions: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    procedure AddUserProfilePreference(preferenceName: string; preferenceValue: DDNC.System.Private.CoreLib.DNObject);
    procedure AddLocalStatePreference(preferenceName: string; preferenceValue: DDNC.System.Private.CoreLib.DNObject);
    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject); overload;
    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject; isGlobalCapability: Boolean); overload;
    function ToCapabilities: DNICapabilities;
    function GetMergeResult(other: DNDriverOptions): DNDriverOptionsMergeResult;
    procedure SetLoggingPreference(logType: string; logLevel: DNLogLevel);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property BinaryLocation: string read get_BinaryLocation write set_BinaryLocation;
    property LeaveBrowserRunning: Boolean read get_LeaveBrowserRunning write set_LeaveBrowserRunning;
    property Arguments: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_Arguments;
    property Extensions: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_Extensions;
    property DebuggerAddress: string read get_DebuggerAddress write set_DebuggerAddress;
    property MinidumpPath: string read get_MinidumpPath write set_MinidumpPath;
    property BrowserName: string read get_BrowserName;
    property BrowserVersion: string read get_BrowserVersion write set_BrowserVersion;
    property PlatformName: string read get_PlatformName write set_PlatformName;
    property AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_AcceptInsecureCertificates write set_AcceptInsecureCertificates;
    property UnhandledPromptBehavior: DNUnhandledPromptBehavior read get_UnhandledPromptBehavior write set_UnhandledPromptBehavior;
    property PageLoadStrategy: DNPageLoadStrategy read get_PageLoadStrategy write set_PageLoadStrategy;
    property Proxy: DNProxy read get_Proxy write set_Proxy;
  end;

  TDNOperaOptions = class(TDNGenericImport<DNOperaOptionsClass, DNOperaOptions>) end;

  //-------------namespace: OpenQA.Selenium.Safari----------------
  DNSafariOptionsClass = interface(DNDriverOptionsClass)
  ['{420C1E8F-1FD5-56E4-BD07-357549CE5517}']
  { constructors } 

    {class} function init: DNSafariOptions;

  end;

  [DNTypeName('OpenQA.Selenium.Safari.SafariOptions')]
  DNSafariOptions = interface(DNDriverOptions)
  ['{A6D5A523-9DA6-32D7-A700-BFD3754793BF}']
  { getters & setters } 

    function get_EnableAutomaticInspection: Boolean;
    procedure set_EnableAutomaticInspection(value: Boolean);
    function get_EnableAutomaticProfiling: Boolean;
    procedure set_EnableAutomaticProfiling(value: Boolean);
    function get_IsTechnologyPreview: Boolean;
    procedure set_IsTechnologyPreview(value: Boolean);
    function get_BrowserName: string;
    function get_BrowserVersion: string;
    procedure set_BrowserVersion(value: string);
    function get_PlatformName: string;
    procedure set_PlatformName(value: string);
    function get_AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_AcceptInsecureCertificates(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_UnhandledPromptBehavior: DNUnhandledPromptBehavior;
    procedure set_UnhandledPromptBehavior(value: DNUnhandledPromptBehavior);
    function get_PageLoadStrategy: DNPageLoadStrategy;
    procedure set_PageLoadStrategy(value: DNPageLoadStrategy);
    function get_Proxy: DNProxy;
    procedure set_Proxy(value: DNProxy);

  { methods } 

    procedure AddAdditionalCapability(capabilityName: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject);
    function ToCapabilities: DNICapabilities;
    function GetMergeResult(other: DNDriverOptions): DNDriverOptionsMergeResult;
    procedure SetLoggingPreference(logType: string; logLevel: DNLogLevel);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property EnableAutomaticInspection: Boolean read get_EnableAutomaticInspection write set_EnableAutomaticInspection;
    property EnableAutomaticProfiling: Boolean read get_EnableAutomaticProfiling write set_EnableAutomaticProfiling;
    property IsTechnologyPreview: Boolean read get_IsTechnologyPreview write set_IsTechnologyPreview;
    property BrowserName: string read get_BrowserName;
    property BrowserVersion: string read get_BrowserVersion write set_BrowserVersion;
    property PlatformName: string read get_PlatformName write set_PlatformName;
    property AcceptInsecureCertificates: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_AcceptInsecureCertificates write set_AcceptInsecureCertificates;
    property UnhandledPromptBehavior: DNUnhandledPromptBehavior read get_UnhandledPromptBehavior write set_UnhandledPromptBehavior;
    property PageLoadStrategy: DNPageLoadStrategy read get_PageLoadStrategy write set_PageLoadStrategy;
    property Proxy: DNProxy read get_Proxy write set_Proxy;
  end;

  TDNSafariOptions = class(TDNGenericImport<DNSafariOptionsClass, DNSafariOptions>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNDriverServiceClass = interface(DNObjectClass)
  ['{EBC19FF1-0EF4-5187-B072-06A9459EC97F}']
  end;

  [DNTypeName('OpenQA.Selenium.DriverService')]
  DNDriverService = interface(DNICommandServer)
  ['{37098A65-7E71-3897-8140-6A7EA1864880}']
  { getters & setters } 

    function get_ServiceUrl: DDNC.System.Private.Uri.DNUri;
    function get_HostName: string;
    procedure set_HostName(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_SuppressInitialDiagnosticInformation: Boolean;
    procedure set_SuppressInitialDiagnosticInformation(value: Boolean);
    function get_IsRunning: Boolean;
    function get_HideCommandPromptWindow: Boolean;
    procedure set_HideCommandPromptWindow(value: Boolean);
    function get_ProcessId: Int32;

  { methods } 

    procedure Dispose;
    procedure Start;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ServiceUrl: DDNC.System.Private.Uri.DNUri read get_ServiceUrl;
    property HostName: string read get_HostName write set_HostName;
    property Port: Int32 read get_Port write set_Port;
    property SuppressInitialDiagnosticInformation: Boolean read get_SuppressInitialDiagnosticInformation write set_SuppressInitialDiagnosticInformation;
    property IsRunning: Boolean read get_IsRunning;
    property HideCommandPromptWindow: Boolean read get_HideCommandPromptWindow write set_HideCommandPromptWindow;
    property ProcessId: Int32 read get_ProcessId;
  end;

  TDNDriverService = class(TDNGenericImport<DNDriverServiceClass, DNDriverService>) end;

  //-------------namespace: OpenQA.Selenium.Chrome----------------
  DNChromeDriverServiceClass = interface(DNDriverServiceClass)
  ['{FD3E5994-72C0-5A7F-9357-C1D9CC25A9B3}']
  { static methods } 

    {class} function CreateDefaultService: DNChromeDriverService; overload;
    {class} function CreateDefaultService(driverPath: string): DNChromeDriverService; overload;
    {class} function CreateDefaultService(driverPath: string; driverExecutableFileName: string): DNChromeDriverService; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Chrome.ChromeDriverService')]
  DNChromeDriverService = interface(DNDriverService)
  ['{0F237CE6-971B-32E5-ABD9-9783962316BD}']
  { getters & setters } 

    function get_LogPath: string;
    procedure set_LogPath(value: string);
    function get_UrlPathPrefix: string;
    procedure set_UrlPathPrefix(value: string);
    function get_PortServerAddress: string;
    procedure set_PortServerAddress(value: string);
    function get_AndroidDebugBridgePort: Int32;
    procedure set_AndroidDebugBridgePort(value: Int32);
    function get_EnableVerboseLogging: Boolean;
    procedure set_EnableVerboseLogging(value: Boolean);
    function get_WhitelistedIPAddresses: string;
    procedure set_WhitelistedIPAddresses(value: string);
    function get_ServiceUrl: DDNC.System.Private.Uri.DNUri;
    function get_HostName: string;
    procedure set_HostName(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_SuppressInitialDiagnosticInformation: Boolean;
    procedure set_SuppressInitialDiagnosticInformation(value: Boolean);
    function get_IsRunning: Boolean;
    function get_HideCommandPromptWindow: Boolean;
    procedure set_HideCommandPromptWindow(value: Boolean);
    function get_ProcessId: Int32;

  { methods } 

    procedure Dispose;
    procedure Start;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property LogPath: string read get_LogPath write set_LogPath;
    property UrlPathPrefix: string read get_UrlPathPrefix write set_UrlPathPrefix;
    property PortServerAddress: string read get_PortServerAddress write set_PortServerAddress;
    property AndroidDebugBridgePort: Int32 read get_AndroidDebugBridgePort write set_AndroidDebugBridgePort;
    property EnableVerboseLogging: Boolean read get_EnableVerboseLogging write set_EnableVerboseLogging;
    property WhitelistedIPAddresses: string read get_WhitelistedIPAddresses write set_WhitelistedIPAddresses;
    property ServiceUrl: DDNC.System.Private.Uri.DNUri read get_ServiceUrl;
    property HostName: string read get_HostName write set_HostName;
    property Port: Int32 read get_Port write set_Port;
    property SuppressInitialDiagnosticInformation: Boolean read get_SuppressInitialDiagnosticInformation write set_SuppressInitialDiagnosticInformation;
    property IsRunning: Boolean read get_IsRunning;
    property HideCommandPromptWindow: Boolean read get_HideCommandPromptWindow write set_HideCommandPromptWindow;
    property ProcessId: Int32 read get_ProcessId;
  end;

  TDNChromeDriverService = class(TDNGenericImport<DNChromeDriverServiceClass, DNChromeDriverService>) end;

  //-------------namespace: OpenQA.Selenium.Edge----------------
  DNEdgeDriverServiceClass = interface(DNDriverServiceClass)
  ['{DE3F81B0-F5AD-5EF3-9844-E49FB84BA0E8}']
  { static methods } 

    {class} function CreateDefaultService: DNEdgeDriverService; overload;
    {class} function CreateDefaultService(driverPath: string): DNEdgeDriverService; overload;
    {class} function CreateDefaultService(driverPath: string; driverExecutableFileName: string): DNEdgeDriverService; overload;
    {class} function CreateDefaultService(driverPath: string; driverExecutableFileName: string; port: Int32): DNEdgeDriverService; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Edge.EdgeDriverService')]
  DNEdgeDriverService = interface(DNDriverService)
  ['{CF84CBA3-2AE5-3B0A-A8AB-59CE63AA5AD4}']
  { getters & setters } 

    function get_Host: string;
    procedure set_Host(value: string);
    function get_Package: string;
    procedure set_Package(value: string);
    function get_UseVerboseLogging: Boolean;
    procedure set_UseVerboseLogging(value: Boolean);
    function get_UseSpecCompliantProtocol: DDNC.System.Private.CoreLib.DNNullable<Boolean>;
    procedure set_UseSpecCompliantProtocol(value: DDNC.System.Private.CoreLib.DNNullable<Boolean>);
    function get_ServiceUrl: DDNC.System.Private.Uri.DNUri;
    function get_HostName: string;
    procedure set_HostName(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_SuppressInitialDiagnosticInformation: Boolean;
    procedure set_SuppressInitialDiagnosticInformation(value: Boolean);
    function get_IsRunning: Boolean;
    function get_HideCommandPromptWindow: Boolean;
    procedure set_HideCommandPromptWindow(value: Boolean);
    function get_ProcessId: Int32;

  { methods } 

    procedure Dispose;
    procedure Start;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Host: string read get_Host write set_Host;
    property &Package: string read get_Package write set_Package;
    property UseVerboseLogging: Boolean read get_UseVerboseLogging write set_UseVerboseLogging;
    property UseSpecCompliantProtocol: DDNC.System.Private.CoreLib.DNNullable<Boolean> read get_UseSpecCompliantProtocol write set_UseSpecCompliantProtocol;
    property ServiceUrl: DDNC.System.Private.Uri.DNUri read get_ServiceUrl;
    property HostName: string read get_HostName write set_HostName;
    property Port: Int32 read get_Port write set_Port;
    property SuppressInitialDiagnosticInformation: Boolean read get_SuppressInitialDiagnosticInformation write set_SuppressInitialDiagnosticInformation;
    property IsRunning: Boolean read get_IsRunning;
    property HideCommandPromptWindow: Boolean read get_HideCommandPromptWindow write set_HideCommandPromptWindow;
    property ProcessId: Int32 read get_ProcessId;
  end;

  TDNEdgeDriverService = class(TDNGenericImport<DNEdgeDriverServiceClass, DNEdgeDriverService>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxDriverServiceClass = interface(DNDriverServiceClass)
  ['{7B226F86-85CB-57B3-9646-DEF3B8286C32}']
  { static methods } 

    {class} function CreateDefaultService: DNFirefoxDriverService; overload;
    {class} function CreateDefaultService(driverPath: string): DNFirefoxDriverService; overload;
    {class} function CreateDefaultService(driverPath: string; driverExecutableFileName: string): DNFirefoxDriverService; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxDriverService')]
  DNFirefoxDriverService = interface(DNDriverService)
  ['{6EB6199E-1FFC-362F-A379-7C9B5F2BDA40}']
  { getters & setters } 

    function get_FirefoxBinaryPath: string;
    procedure set_FirefoxBinaryPath(value: string);
    function get_BrowserCommunicationPort: Int32;
    procedure set_BrowserCommunicationPort(value: Int32);
    function get_Host: string;
    procedure set_Host(value: string);
    function get_ConnectToRunningBrowser: Boolean;
    procedure set_ConnectToRunningBrowser(value: Boolean);
    function get_OpenBrowserToolbox: Boolean;
    procedure set_OpenBrowserToolbox(value: Boolean);
    function get_ServiceUrl: DDNC.System.Private.Uri.DNUri;
    function get_HostName: string;
    procedure set_HostName(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_SuppressInitialDiagnosticInformation: Boolean;
    procedure set_SuppressInitialDiagnosticInformation(value: Boolean);
    function get_IsRunning: Boolean;
    function get_HideCommandPromptWindow: Boolean;
    procedure set_HideCommandPromptWindow(value: Boolean);
    function get_ProcessId: Int32;

  { methods } 

    procedure Dispose;
    procedure Start;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FirefoxBinaryPath: string read get_FirefoxBinaryPath write set_FirefoxBinaryPath;
    property BrowserCommunicationPort: Int32 read get_BrowserCommunicationPort write set_BrowserCommunicationPort;
    property Host: string read get_Host write set_Host;
    property ConnectToRunningBrowser: Boolean read get_ConnectToRunningBrowser write set_ConnectToRunningBrowser;
    property OpenBrowserToolbox: Boolean read get_OpenBrowserToolbox write set_OpenBrowserToolbox;
    property ServiceUrl: DDNC.System.Private.Uri.DNUri read get_ServiceUrl;
    property HostName: string read get_HostName write set_HostName;
    property Port: Int32 read get_Port write set_Port;
    property SuppressInitialDiagnosticInformation: Boolean read get_SuppressInitialDiagnosticInformation write set_SuppressInitialDiagnosticInformation;
    property IsRunning: Boolean read get_IsRunning;
    property HideCommandPromptWindow: Boolean read get_HideCommandPromptWindow write set_HideCommandPromptWindow;
    property ProcessId: Int32 read get_ProcessId;
  end;

  TDNFirefoxDriverService = class(TDNGenericImport<DNFirefoxDriverServiceClass, DNFirefoxDriverService>) end;

  //-------------namespace: OpenQA.Selenium.IE----------------
  DNInternetExplorerDriverServiceClass = interface(DNDriverServiceClass)
  ['{EABFC094-D245-53E3-BDCD-00F767520B4F}']
  { static methods } 

    {class} function CreateDefaultService: DNInternetExplorerDriverService; overload;
    {class} function CreateDefaultService(driverPath: string): DNInternetExplorerDriverService; overload;
    {class} function CreateDefaultService(driverPath: string; driverExecutableFileName: string): DNInternetExplorerDriverService; overload;

  end;

  [DNTypeName('OpenQA.Selenium.IE.InternetExplorerDriverService')]
  DNInternetExplorerDriverService = interface(DNDriverService)
  ['{9A8D8662-0605-3568-9D88-F5E5659352B8}']
  { getters & setters } 

    function get_Host: string;
    procedure set_Host(value: string);
    function get_LogFile: string;
    procedure set_LogFile(value: string);
    function get_LoggingLevel: DNInternetExplorerDriverLogLevel;
    procedure set_LoggingLevel(value: DNInternetExplorerDriverLogLevel);
    function get_LibraryExtractionPath: string;
    procedure set_LibraryExtractionPath(value: string);
    function get_WhitelistedIPAddresses: string;
    procedure set_WhitelistedIPAddresses(value: string);
    function get_ServiceUrl: DDNC.System.Private.Uri.DNUri;
    function get_HostName: string;
    procedure set_HostName(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_SuppressInitialDiagnosticInformation: Boolean;
    procedure set_SuppressInitialDiagnosticInformation(value: Boolean);
    function get_IsRunning: Boolean;
    function get_HideCommandPromptWindow: Boolean;
    procedure set_HideCommandPromptWindow(value: Boolean);
    function get_ProcessId: Int32;

  { methods } 

    procedure Dispose;
    procedure Start;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Host: string read get_Host write set_Host;
    property LogFile: string read get_LogFile write set_LogFile;
    property LoggingLevel: DNInternetExplorerDriverLogLevel read get_LoggingLevel write set_LoggingLevel;
    property LibraryExtractionPath: string read get_LibraryExtractionPath write set_LibraryExtractionPath;
    property WhitelistedIPAddresses: string read get_WhitelistedIPAddresses write set_WhitelistedIPAddresses;
    property ServiceUrl: DDNC.System.Private.Uri.DNUri read get_ServiceUrl;
    property HostName: string read get_HostName write set_HostName;
    property Port: Int32 read get_Port write set_Port;
    property SuppressInitialDiagnosticInformation: Boolean read get_SuppressInitialDiagnosticInformation write set_SuppressInitialDiagnosticInformation;
    property IsRunning: Boolean read get_IsRunning;
    property HideCommandPromptWindow: Boolean read get_HideCommandPromptWindow write set_HideCommandPromptWindow;
    property ProcessId: Int32 read get_ProcessId;
  end;

  TDNInternetExplorerDriverService = class(TDNGenericImport<DNInternetExplorerDriverServiceClass, DNInternetExplorerDriverService>) end;

  //-------------namespace: OpenQA.Selenium.Opera----------------
  DNOperaDriverServiceClass = interface(DNDriverServiceClass)
  ['{BFC06B41-E4A4-5669-B474-F8B71F640B35}']
  { static methods } 

    {class} function CreateDefaultService: DNOperaDriverService; overload;
    {class} function CreateDefaultService(driverPath: string): DNOperaDriverService; overload;
    {class} function CreateDefaultService(driverPath: string; driverExecutableFileName: string): DNOperaDriverService; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Opera.OperaDriverService')]
  DNOperaDriverService = interface(DNDriverService)
  ['{1C3CAE33-9070-3E93-8B11-CF8D03823921}']
  { getters & setters } 

    function get_LogPath: string;
    procedure set_LogPath(value: string);
    function get_UrlPathPrefix: string;
    procedure set_UrlPathPrefix(value: string);
    function get_PortServerAddress: string;
    procedure set_PortServerAddress(value: string);
    function get_AndroidDebugBridgePort: Int32;
    procedure set_AndroidDebugBridgePort(value: Int32);
    function get_EnableVerboseLogging: Boolean;
    procedure set_EnableVerboseLogging(value: Boolean);
    function get_ServiceUrl: DDNC.System.Private.Uri.DNUri;
    function get_HostName: string;
    procedure set_HostName(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_SuppressInitialDiagnosticInformation: Boolean;
    procedure set_SuppressInitialDiagnosticInformation(value: Boolean);
    function get_IsRunning: Boolean;
    function get_HideCommandPromptWindow: Boolean;
    procedure set_HideCommandPromptWindow(value: Boolean);
    function get_ProcessId: Int32;

  { methods } 

    procedure Dispose;
    procedure Start;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property LogPath: string read get_LogPath write set_LogPath;
    property UrlPathPrefix: string read get_UrlPathPrefix write set_UrlPathPrefix;
    property PortServerAddress: string read get_PortServerAddress write set_PortServerAddress;
    property AndroidDebugBridgePort: Int32 read get_AndroidDebugBridgePort write set_AndroidDebugBridgePort;
    property EnableVerboseLogging: Boolean read get_EnableVerboseLogging write set_EnableVerboseLogging;
    property ServiceUrl: DDNC.System.Private.Uri.DNUri read get_ServiceUrl;
    property HostName: string read get_HostName write set_HostName;
    property Port: Int32 read get_Port write set_Port;
    property SuppressInitialDiagnosticInformation: Boolean read get_SuppressInitialDiagnosticInformation write set_SuppressInitialDiagnosticInformation;
    property IsRunning: Boolean read get_IsRunning;
    property HideCommandPromptWindow: Boolean read get_HideCommandPromptWindow write set_HideCommandPromptWindow;
    property ProcessId: Int32 read get_ProcessId;
  end;

  TDNOperaDriverService = class(TDNGenericImport<DNOperaDriverServiceClass, DNOperaDriverService>) end;

  //-------------namespace: OpenQA.Selenium.Safari----------------
  DNSafariDriverServiceClass = interface(DNDriverServiceClass)
  ['{77BD3B08-DB85-524E-973C-927DD730CBA6}']
  { static methods } 

    {class} function CreateDefaultService: DNSafariDriverService; overload;
    {class} function CreateDefaultService(driverPath: string): DNSafariDriverService; overload;
    {class} function CreateDefaultService(driverPath: string; driverExecutableFileName: string): DNSafariDriverService; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Safari.SafariDriverService')]
  DNSafariDriverService = interface(DNDriverService)
  ['{80A37B9F-FEC0-387E-B5A6-90B62EF8884A}']
  { getters & setters } 

    function get_UseLegacyProtocol: Boolean;
    procedure set_UseLegacyProtocol(value: Boolean);
    function get_ServiceUrl: DDNC.System.Private.Uri.DNUri;
    function get_HostName: string;
    procedure set_HostName(value: string);
    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_SuppressInitialDiagnosticInformation: Boolean;
    procedure set_SuppressInitialDiagnosticInformation(value: Boolean);
    function get_IsRunning: Boolean;
    function get_HideCommandPromptWindow: Boolean;
    procedure set_HideCommandPromptWindow(value: Boolean);
    function get_ProcessId: Int32;

  { methods } 

    procedure Dispose;
    procedure Start;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property UseLegacyProtocol: Boolean read get_UseLegacyProtocol write set_UseLegacyProtocol;
    property ServiceUrl: DDNC.System.Private.Uri.DNUri read get_ServiceUrl;
    property HostName: string read get_HostName write set_HostName;
    property Port: Int32 read get_Port write set_Port;
    property SuppressInitialDiagnosticInformation: Boolean read get_SuppressInitialDiagnosticInformation write set_SuppressInitialDiagnosticInformation;
    property IsRunning: Boolean read get_IsRunning;
    property HideCommandPromptWindow: Boolean read get_HideCommandPromptWindow write set_HideCommandPromptWindow;
    property ProcessId: Int32 read get_ProcessId;
  end;

  TDNSafariDriverService = class(TDNGenericImport<DNSafariDriverServiceClass, DNSafariDriverService>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxBinaryClass = interface(DNObjectClass)
  ['{7DCA13B1-38F3-5F26-8535-A5B91551CF43}']
  { constructors } 

    {class} function init: DNFirefoxBinary; overload;
    {class} function init(pathToFirefoxBinary: string): DNFirefoxBinary; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxBinary')]
  DNFirefoxBinary = interface(DDNC.System.Private.CoreLib.DNIDisposable)
  ['{363CD4FE-8C23-37A7-9DA3-026F11EFFF24}']
  { getters & setters } 

    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);

  { methods } 

    procedure StartProfile(profile: DNFirefoxProfile; commandLineArguments: TArray<string>);
    procedure SetEnvironmentProperty(propertyName: string; value: string);
    procedure WaitForProcessExit;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
  end;

  TDNFirefoxBinary = class(TDNGenericImport<DNFirefoxBinaryClass, DNFirefoxBinary>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxDriverCommandExecutorClass = interface(DNObjectClass)
  ['{6BD111F0-B7D1-5E68-A40E-41EA7C5DBD7B}']
  { constructors } 

    {class} function init(binary: DNFirefoxBinary; profile: DNFirefoxProfile; host: string; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNFirefoxDriverCommandExecutor;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxDriverCommandExecutor')]
  DNFirefoxDriverCommandExecutor = interface(DNICommandExecutor)
  ['{4641EE35-4DA5-3388-B416-3A31461D859F}']
  { getters & setters } 

    function get_CommandInfoRepository: DNCommandInfoRepository;

  { methods } 

    function Execute(commandToExecute: DNCommand): DNResponse;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CommandInfoRepository: DNCommandInfoRepository read get_CommandInfoRepository;
  end;

  TDNFirefoxDriverCommandExecutor = class(TDNGenericImport<DNFirefoxDriverCommandExecutorClass, DNFirefoxDriverCommandExecutor>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxDriverServerClass = interface(DNObjectClass)
  ['{E1EBF74C-8F37-5F6E-83AD-49545CDEC493}']
  { constructors } 

    {class} function init(binary: DNFirefoxBinary; profile: DNFirefoxProfile; host: string): DNFirefoxDriverServer;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxDriverServer')]
  DNFirefoxDriverServer = interface(DNICommandServer)
  ['{519AD895-1789-392B-B961-C2E949924B34}']
  { getters & setters } 

    function get_ExtensionUri: DDNC.System.Private.Uri.DNUri;

  { methods } 

    procedure Start;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ExtensionUri: DDNC.System.Private.Uri.DNUri read get_ExtensionUri;
  end;

  TDNFirefoxDriverServer = class(TDNGenericImport<DNFirefoxDriverServerClass, DNFirefoxDriverServer>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxExtensionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{6B830E34-A9D8-54AC-8115-62714A71D4EA}']
  { constructors } 

    {class} function init(fileName: string): DNFirefoxExtension;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxExtension')]
  DNFirefoxExtension = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{7663E80D-5699-3563-B396-4E70BD5DA663}']
  { methods } 

    procedure Install(profileDirectory: string);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNFirefoxExtension = class(TDNGenericImport<DNFirefoxExtensionClass, DNFirefoxExtension>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxProfileClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0C04C260-7EDF-5446-AE66-D16110C81EC1}']
  { constructors } 

    {class} function init: DNFirefoxProfile; overload;
    {class} function init(profileDirectory: string): DNFirefoxProfile; overload;
    {class} function init(profileDirectory: string; deleteSourceOnClean: Boolean): DNFirefoxProfile; overload;

  { static methods } 

    {class} function FromBase64String(base64: string): DNFirefoxProfile;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxProfile')]
  DNFirefoxProfile = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{5CA04340-A5E0-3FF2-8170-61D7190F16D3}']
  { getters & setters } 

    function get_Port: Int32;
    procedure set_Port(value: Int32);
    function get_ProfileDirectory: string;
    function get_DeleteAfterUse: Boolean;
    procedure set_DeleteAfterUse(value: Boolean);
    function get_EnableNativeEvents: Boolean;
    procedure set_EnableNativeEvents(value: Boolean);
    function get_AlwaysLoadNoFocusLibrary: Boolean;
    procedure set_AlwaysLoadNoFocusLibrary(value: Boolean);
    function get_AcceptUntrustedCertificates: Boolean;
    procedure set_AcceptUntrustedCertificates(value: Boolean);
    function get_AssumeUntrustedCertificateIssuer: Boolean;
    procedure set_AssumeUntrustedCertificateIssuer(value: Boolean);

  { methods } 

    procedure AddExtension(extensionToInstall: string);
    procedure SetPreference(name: string; value: string); overload;
    procedure SetPreference(name: string; value: Int32); overload;
    procedure SetPreference(name: string; value: Boolean); overload;
    procedure SetProxyPreferences(proxy: DNProxy);
    procedure WriteToDisk;
    procedure Clean;
    function ToBase64String: string;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Port: Int32 read get_Port write set_Port;
    property ProfileDirectory: string read get_ProfileDirectory;
    property DeleteAfterUse: Boolean read get_DeleteAfterUse write set_DeleteAfterUse;
    property EnableNativeEvents: Boolean read get_EnableNativeEvents write set_EnableNativeEvents;
    property AlwaysLoadNoFocusLibrary: Boolean read get_AlwaysLoadNoFocusLibrary write set_AlwaysLoadNoFocusLibrary;
    property AcceptUntrustedCertificates: Boolean read get_AcceptUntrustedCertificates write set_AcceptUntrustedCertificates;
    property AssumeUntrustedCertificateIssuer: Boolean read get_AssumeUntrustedCertificateIssuer write set_AssumeUntrustedCertificateIssuer;
  end;

  TDNFirefoxProfile = class(TDNGenericImport<DNFirefoxProfileClass, DNFirefoxProfile>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxProfileManagerClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{BE5875FF-3C25-5A21-A6BE-C02869D47BCF}']
  { constructors } 

    {class} function init: DNFirefoxProfileManager;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxProfileManager')]
  DNFirefoxProfileManager = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{FE8A09A8-D011-3B71-B18E-F3A72C8FE11A}']
  { getters & setters } 

    function get_ExistingProfiles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;

  { methods } 

    function GetProfile(profileName: string): DNFirefoxProfile;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ExistingProfiles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_ExistingProfiles;
  end;

  TDNFirefoxProfileManager = class(TDNGenericImport<DNFirefoxProfileManagerClass, DNFirefoxProfileManager>) end;

  //-------------namespace: OpenQA.Selenium.Html5----------------
  DNLocationClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{6B3C960F-CC1A-5622-91CD-0D8A8604477E}']
  { constructors } 

    {class} function init(latitude: Double; longitude: Double; altitude: Double): DNLocation;

  end;

  [DNTypeName('OpenQA.Selenium.Html5.Location')]
  DNLocation = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{DB852AFE-3303-3173-B883-2CA5C6DECE42}']
  { getters & setters } 

    function get_Latitude: Double;
    function get_Longitude: Double;
    function get_Altitude: Double;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Latitude: Double read get_Latitude;
    property Longitude: Double read get_Longitude;
    property Altitude: Double read get_Altitude;
  end;

  TDNLocation = class(TDNGenericImport<DNLocationClass, DNLocation>) end;

  //-------------namespace: OpenQA.Selenium.Interactions----------------
  DNActionBuilderClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{63F16809-6102-5A45-94E3-159C713999E1}']
  { constructors } 

    {class} function init: DNActionBuilder;

  end;

  [DNTypeName('OpenQA.Selenium.Interactions.ActionBuilder')]
  DNActionBuilder = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{EDBC46B1-7954-3364-85E3-66917FD158C7}']
  { methods } 

    function AddAction(actionToAdd: DNInteraction): DNActionBuilder;
    function AddActions(actionsToAdd: TArray<DNInteraction>): DNActionBuilder;
    function ToActionSequenceList: DDNC.System.Private.CoreLib.DNIList<DNActionSequence>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNActionBuilder = class(TDNGenericImport<DNActionBuilderClass, DNActionBuilder>) end;

  //-------------namespace: OpenQA.Selenium.Interactions----------------
  DNActionsClass = interface(DNObjectClass)
  ['{AA2539B5-A1EF-531D-8FEB-43E70822D42F}']
  { constructors } 

    {class} function init(driver: DNIWebDriver): DNActions;

  end;

  [DNTypeName('OpenQA.Selenium.Interactions.Actions')]
  DNActions = interface(DNIAction)
  ['{623A71BE-B9A0-3A3B-BF59-EAE8B4FDE0E8}']
  { methods } 

    function KeyDown(theKey: string): DNActions; overload;
    function KeyDown(element: DNIWebElement; theKey: string): DNActions; overload;
    function KeyUp(theKey: string): DNActions; overload;
    function KeyUp(element: DNIWebElement; theKey: string): DNActions; overload;
    function SendKeys(keysToSend: string): DNActions; overload;
    function SendKeys(element: DNIWebElement; keysToSend: string): DNActions; overload;
    function ClickAndHold(onElement: DNIWebElement): DNActions; overload;
    function ClickAndHold: DNActions; overload;
    function Release(onElement: DNIWebElement): DNActions; overload;
    function Release: DNActions; overload;
    function Click(onElement: DNIWebElement): DNActions; overload;
    function Click: DNActions; overload;
    function DoubleClick(onElement: DNIWebElement): DNActions; overload;
    function DoubleClick: DNActions; overload;
    function MoveToElement(toElement: DNIWebElement): DNActions; overload;
    function MoveToElement(toElement: DNIWebElement; offsetX: Int32; offsetY: Int32): DNActions; overload;
    function MoveToElement(toElement: DNIWebElement; offsetX: Int32; offsetY: Int32; offsetOrigin: DNMoveToElementOffsetOrigin): DNActions; overload;
    function MoveByOffset(offsetX: Int32; offsetY: Int32): DNActions;
    function ContextClick(onElement: DNIWebElement): DNActions; overload;
    function ContextClick: DNActions; overload;
    function DragAndDrop(source: DNIWebElement; target: DNIWebElement): DNActions;
    function DragAndDropToOffset(source: DNIWebElement; offsetX: Int32; offsetY: Int32): DNActions;
    function Build: DNIAction;
    procedure Perform;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNActions = class(TDNGenericImport<DNActionsClass, DNActions>) end;

  //-------------namespace: OpenQA.Selenium.Interactions----------------
  DNTouchActionsClass = interface(DNActionsClass)
  ['{777E72D6-FFEF-57C0-94D7-236EA170D189}']
  { constructors } 

    {class} function init(driver: DNIWebDriver): DNTouchActions;

  end;

  [DNTypeName('OpenQA.Selenium.Interactions.TouchActions')]
  DNTouchActions = interface(DNActions)
  ['{18A50434-B215-3944-B208-4391682123A5}']
  { methods } 

    function SingleTap(onElement: DNIWebElement): DNTouchActions;
    function Down(locationX: Int32; locationY: Int32): DNTouchActions;
    function Up(locationX: Int32; locationY: Int32): DNTouchActions;
    function Move(locationX: Int32; locationY: Int32): DNTouchActions;
    function Scroll(onElement: DNIWebElement; offsetX: Int32; offsetY: Int32): DNTouchActions; overload;
    function DoubleTap(onElement: DNIWebElement): DNTouchActions;
    function LongPress(onElement: DNIWebElement): DNTouchActions;
    function Scroll(offsetX: Int32; offsetY: Int32): DNTouchActions; overload;
    function Flick(speedX: Int32; speedY: Int32): DNTouchActions; overload;
    function Flick(onElement: DNIWebElement; offsetX: Int32; offsetY: Int32; speed: Int32): DNTouchActions; overload;
    function KeyDown(theKey: string): DNActions; overload;
    function KeyDown(element: DNIWebElement; theKey: string): DNActions; overload;
    function KeyUp(theKey: string): DNActions; overload;
    function KeyUp(element: DNIWebElement; theKey: string): DNActions; overload;
    function SendKeys(keysToSend: string): DNActions; overload;
    function SendKeys(element: DNIWebElement; keysToSend: string): DNActions; overload;
    function ClickAndHold(onElement: DNIWebElement): DNActions; overload;
    function ClickAndHold: DNActions; overload;
    function Release(onElement: DNIWebElement): DNActions; overload;
    function Release: DNActions; overload;
    function Click(onElement: DNIWebElement): DNActions; overload;
    function Click: DNActions; overload;
    function DoubleClick(onElement: DNIWebElement): DNActions; overload;
    function DoubleClick: DNActions; overload;
    function MoveToElement(toElement: DNIWebElement): DNActions; overload;
    function MoveToElement(toElement: DNIWebElement; offsetX: Int32; offsetY: Int32): DNActions; overload;
    function MoveToElement(toElement: DNIWebElement; offsetX: Int32; offsetY: Int32; offsetOrigin: DNMoveToElementOffsetOrigin): DNActions; overload;
    function MoveByOffset(offsetX: Int32; offsetY: Int32): DNActions;
    function ContextClick(onElement: DNIWebElement): DNActions; overload;
    function ContextClick: DNActions; overload;
    function DragAndDrop(source: DNIWebElement; target: DNIWebElement): DNActions;
    function DragAndDropToOffset(source: DNIWebElement; offsetX: Int32; offsetY: Int32): DNActions;
    function Build: DNIAction;
    procedure Perform;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNTouchActions = class(TDNGenericImport<DNTouchActionsClass, DNTouchActions>) end;

  //-------------namespace: OpenQA.Selenium.Interactions----------------
  DNActionSequenceClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{8BA0954F-6B3C-5347-B8F6-E395C1FA32E9}']
  { constructors } 

    {class} function init(device: DNInputDevice): DNActionSequence; overload;
    {class} function init(device: DNInputDevice; initialSize: Int32): DNActionSequence; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Interactions.ActionSequence')]
  DNActionSequence = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{03F6447E-5541-325C-A5E7-3A308D43128C}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    function AddAction(interactionToAdd: DNInteraction): DNActionSequence;
    function ToDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNActionSequence = class(TDNGenericImport<DNActionSequenceClass, DNActionSequence>) end;

  //-------------namespace: OpenQA.Selenium.Interactions----------------
  DNInputDeviceClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{EE09C427-27C6-5480-91E8-2B3056A17D1C}']
  end;

  [DNTypeName('OpenQA.Selenium.Interactions.InputDevice')]
  DNInputDevice = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{32507AF4-49A7-389A-AF42-5CDB0AD290EB}']
  { getters & setters } 

    function get_DeviceName: string;
    function get_DeviceKind: DNInputDeviceKind;

  { methods } 

    function ToDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function CreatePause: DNInteraction; overload;
    function CreatePause(duration: DDNC.System.Private.CoreLib.DNTimeSpan): DNInteraction; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property DeviceName: string read get_DeviceName;
    property DeviceKind: DNInputDeviceKind read get_DeviceKind;
  end;

  TDNInputDevice = class(TDNGenericImport<DNInputDeviceClass, DNInputDevice>) end;

  //-------------namespace: OpenQA.Selenium.Interactions----------------
  DNKeyInputDeviceClass = interface(DNInputDeviceClass)
  ['{B1E26E80-D285-56B6-9C37-BF6084184724}']
  { constructors } 

    {class} function init: DNKeyInputDevice; overload;
    {class} function init(deviceName: string): DNKeyInputDevice; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Interactions.KeyInputDevice')]
  DNKeyInputDevice = interface(DNInputDevice)
  ['{D634D8AB-DBF7-3375-8222-3C48FDEB7B5C}']
  { getters & setters } 

    function get_DeviceKind: DNInputDeviceKind;
    function get_DeviceName: string;

  { methods } 

    function ToDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function CreateKeyDown(codePoint: Char): DNInteraction;
    function CreateKeyUp(codePoint: Char): DNInteraction;
    function CreatePause: DNInteraction; overload;
    function CreatePause(duration: DDNC.System.Private.CoreLib.DNTimeSpan): DNInteraction; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property DeviceKind: DNInputDeviceKind read get_DeviceKind;
    property DeviceName: string read get_DeviceName;
  end;

  TDNKeyInputDevice = class(TDNGenericImport<DNKeyInputDeviceClass, DNKeyInputDevice>) end;

  //-------------namespace: OpenQA.Selenium.Interactions----------------
  DNPointerInputDeviceClass = interface(DNInputDeviceClass)
  ['{FA98C023-0924-5BD4-A98E-56DE706FCD21}']
  { constructors } 

    {class} function init: DNPointerInputDevice; overload;
    {class} function init(pointerKind: DNPointerKind): DNPointerInputDevice; overload;
    {class} function init(pointerKind: DNPointerKind; deviceName: string): DNPointerInputDevice; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Interactions.PointerInputDevice')]
  DNPointerInputDevice = interface(DNInputDevice)
  ['{979739D3-2AF1-3A7E-935C-C044D56FC727}']
  { getters & setters } 

    function get_DeviceKind: DNInputDeviceKind;
    function get_DeviceName: string;

  { methods } 

    function ToDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function CreatePointerDown(button: DNMouseButton): DNInteraction;
    function CreatePointerUp(button: DNMouseButton): DNInteraction;
    function CreatePointerMove(target: DNIWebElement; xOffset: Int32; yOffset: Int32; duration: DDNC.System.Private.CoreLib.DNTimeSpan): DNInteraction; overload;
    function CreatePointerMove(origin: DNCoordinateOrigin; xOffset: Int32; yOffset: Int32; duration: DDNC.System.Private.CoreLib.DNTimeSpan): DNInteraction; overload;
    function CreatePointerCancel: DNInteraction;
    function CreatePause: DNInteraction; overload;
    function CreatePause(duration: DDNC.System.Private.CoreLib.DNTimeSpan): DNInteraction; overload;
    function GetHashCode: Int32;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property DeviceKind: DNInputDeviceKind read get_DeviceKind;
    property DeviceName: string read get_DeviceName;
  end;

  TDNPointerInputDevice = class(TDNGenericImport<DNPointerInputDeviceClass, DNPointerInputDevice>) end;

  //-------------namespace: OpenQA.Selenium.Interactions----------------
  DNInteractionClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{D1020DAC-AA54-5963-806B-C6168AEF37F1}']
  end;

  [DNTypeName('OpenQA.Selenium.Interactions.Interaction')]
  DNInteraction = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{BA66B67F-5C52-381D-8523-1012FF257A5B}']
  { getters & setters } 

    function get_SourceDevice: DNInputDevice;

  { methods } 

    function ToDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function IsValidFor(sourceDeviceKind: DNInputDeviceKind): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property SourceDevice: DNInputDevice read get_SourceDevice;
  end;

  TDNInteraction = class(TDNGenericImport<DNInteractionClass, DNInteraction>) end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  DNAsyncJavaScriptExecutorClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0B332870-8F44-5FEF-A172-DE76A2B25576}']
  { constructors } 

    {class} function init(executor: DNIJavaScriptExecutor): DNAsyncJavaScriptExecutor;

  end;

  [DNTypeName('OpenQA.Selenium.Internal.AsyncJavaScriptExecutor')]
  DNAsyncJavaScriptExecutor = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{ED3274FF-1C53-32F3-BB88-DBEC4453AAFF}']
  { getters & setters } 

    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);

  { methods } 

    function ExecuteScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
  end;

  TDNAsyncJavaScriptExecutor = class(TDNGenericImport<DNAsyncJavaScriptExecutorClass, DNAsyncJavaScriptExecutor>) end;

  //-------------namespace: OpenQA.Selenium.Internal----------------
  DNResourceUtilitiesClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{13580F2D-CD04-525C-84F8-DBA03BBDA3CD}']
  { static getter & setter } 

    {class} function get_AssemblyVersion: string;
    {class} function get_PlatformFamily: string;

  { static methods } 

    {class} function GetResourceStream(fileName: string; resourceId: string): DDNC.System.Private.CoreLib.DNStream;
    {class} function IsValidResourceName(resourceId: string): Boolean;

  { static propertys } 

    {class} property AssemblyVersion: string read get_AssemblyVersion;
    {class} property PlatformFamily: string read get_PlatformFamily;
  end;

  [DNTypeName('OpenQA.Selenium.Internal.ResourceUtilities')]
  DNResourceUtilities = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{4C441C3B-C48A-34F8-8F1C-24A338C3736F}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNResourceUtilities = class(TDNGenericImport<DNResourceUtilitiesClass, DNResourceUtilities>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNKeysClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{32E82FE5-0B58-53D0-80CD-BB7EDBDE0374}']
  { static fields getter & setter } 

   function __fakeFieldGet_Null: string;
   function __fakeFieldGet_Cancel: string;
   function __fakeFieldGet_Help: string;
   function __fakeFieldGet_Backspace: string;
   function __fakeFieldGet_Tab: string;
   function __fakeFieldGet_Clear: string;
   function __fakeFieldGet_Return: string;
   function __fakeFieldGet_Enter: string;
   function __fakeFieldGet_Shift: string;
   function __fakeFieldGet_LeftShift: string;
   function __fakeFieldGet_Control: string;
   function __fakeFieldGet_LeftControl: string;
   function __fakeFieldGet_Alt: string;
   function __fakeFieldGet_LeftAlt: string;
   function __fakeFieldGet_Pause: string;
   function __fakeFieldGet_Escape: string;
   function __fakeFieldGet_Space: string;
   function __fakeFieldGet_PageUp: string;
   function __fakeFieldGet_PageDown: string;
   function __fakeFieldGet_End: string;
   function __fakeFieldGet_Home: string;
   function __fakeFieldGet_Left: string;
   function __fakeFieldGet_ArrowLeft: string;
   function __fakeFieldGet_Up: string;
   function __fakeFieldGet_ArrowUp: string;
   function __fakeFieldGet_Right: string;
   function __fakeFieldGet_ArrowRight: string;
   function __fakeFieldGet_Down: string;
   function __fakeFieldGet_ArrowDown: string;
   function __fakeFieldGet_Insert: string;
   function __fakeFieldGet_Delete: string;
   function __fakeFieldGet_Semicolon: string;
   function __fakeFieldGet_Equal: string;
   function __fakeFieldGet_NumberPad0: string;
   function __fakeFieldGet_NumberPad1: string;
   function __fakeFieldGet_NumberPad2: string;
   function __fakeFieldGet_NumberPad3: string;
   function __fakeFieldGet_NumberPad4: string;
   function __fakeFieldGet_NumberPad5: string;
   function __fakeFieldGet_NumberPad6: string;
   function __fakeFieldGet_NumberPad7: string;
   function __fakeFieldGet_NumberPad8: string;
   function __fakeFieldGet_NumberPad9: string;
   function __fakeFieldGet_Multiply: string;
   function __fakeFieldGet_Add: string;
   function __fakeFieldGet_Separator: string;
   function __fakeFieldGet_Subtract: string;
   function __fakeFieldGet_Decimal: string;
   function __fakeFieldGet_Divide: string;
   function __fakeFieldGet_F1: string;
   function __fakeFieldGet_F2: string;
   function __fakeFieldGet_F3: string;
   function __fakeFieldGet_F4: string;
   function __fakeFieldGet_F5: string;
   function __fakeFieldGet_F6: string;
   function __fakeFieldGet_F7: string;
   function __fakeFieldGet_F8: string;
   function __fakeFieldGet_F9: string;
   function __fakeFieldGet_F10: string;
   function __fakeFieldGet_F11: string;
   function __fakeFieldGet_F12: string;
   function __fakeFieldGet_Meta: string;
   function __fakeFieldGet_Command: string;

  { static fields } 

    {class} property Null: string read __fakeFieldGet_Null;
    {class} property Cancel: string read __fakeFieldGet_Cancel;
    {class} property Help: string read __fakeFieldGet_Help;
    {class} property Backspace: string read __fakeFieldGet_Backspace;
    {class} property Tab: string read __fakeFieldGet_Tab;
    {class} property Clear: string read __fakeFieldGet_Clear;
    {class} property Return: string read __fakeFieldGet_Return;
    {class} property Enter: string read __fakeFieldGet_Enter;
    {class} property Shift: string read __fakeFieldGet_Shift;
    {class} property LeftShift: string read __fakeFieldGet_LeftShift;
    {class} property Control: string read __fakeFieldGet_Control;
    {class} property LeftControl: string read __fakeFieldGet_LeftControl;
    {class} property Alt: string read __fakeFieldGet_Alt;
    {class} property LeftAlt: string read __fakeFieldGet_LeftAlt;
    {class} property Pause: string read __fakeFieldGet_Pause;
    {class} property Escape: string read __fakeFieldGet_Escape;
    {class} property Space: string read __fakeFieldGet_Space;
    {class} property PageUp: string read __fakeFieldGet_PageUp;
    {class} property PageDown: string read __fakeFieldGet_PageDown;
    {class} property &End: string read __fakeFieldGet_End;
    {class} property Home: string read __fakeFieldGet_Home;
    {class} property Left: string read __fakeFieldGet_Left;
    {class} property ArrowLeft: string read __fakeFieldGet_ArrowLeft;
    {class} property Up: string read __fakeFieldGet_Up;
    {class} property ArrowUp: string read __fakeFieldGet_ArrowUp;
    {class} property Right: string read __fakeFieldGet_Right;
    {class} property ArrowRight: string read __fakeFieldGet_ArrowRight;
    {class} property Down: string read __fakeFieldGet_Down;
    {class} property ArrowDown: string read __fakeFieldGet_ArrowDown;
    {class} property Insert: string read __fakeFieldGet_Insert;
    {class} property Delete: string read __fakeFieldGet_Delete;
    {class} property Semicolon: string read __fakeFieldGet_Semicolon;
    {class} property Equal: string read __fakeFieldGet_Equal;
    {class} property NumberPad0: string read __fakeFieldGet_NumberPad0;
    {class} property NumberPad1: string read __fakeFieldGet_NumberPad1;
    {class} property NumberPad2: string read __fakeFieldGet_NumberPad2;
    {class} property NumberPad3: string read __fakeFieldGet_NumberPad3;
    {class} property NumberPad4: string read __fakeFieldGet_NumberPad4;
    {class} property NumberPad5: string read __fakeFieldGet_NumberPad5;
    {class} property NumberPad6: string read __fakeFieldGet_NumberPad6;
    {class} property NumberPad7: string read __fakeFieldGet_NumberPad7;
    {class} property NumberPad8: string read __fakeFieldGet_NumberPad8;
    {class} property NumberPad9: string read __fakeFieldGet_NumberPad9;
    {class} property Multiply: string read __fakeFieldGet_Multiply;
    {class} property Add: string read __fakeFieldGet_Add;
    {class} property Separator: string read __fakeFieldGet_Separator;
    {class} property Subtract: string read __fakeFieldGet_Subtract;
    {class} property Decimal: string read __fakeFieldGet_Decimal;
    {class} property Divide: string read __fakeFieldGet_Divide;
    {class} property F1: string read __fakeFieldGet_F1;
    {class} property F2: string read __fakeFieldGet_F2;
    {class} property F3: string read __fakeFieldGet_F3;
    {class} property F4: string read __fakeFieldGet_F4;
    {class} property F5: string read __fakeFieldGet_F5;
    {class} property F6: string read __fakeFieldGet_F6;
    {class} property F7: string read __fakeFieldGet_F7;
    {class} property F8: string read __fakeFieldGet_F8;
    {class} property F9: string read __fakeFieldGet_F9;
    {class} property F10: string read __fakeFieldGet_F10;
    {class} property F11: string read __fakeFieldGet_F11;
    {class} property F12: string read __fakeFieldGet_F12;
    {class} property Meta: string read __fakeFieldGet_Meta;
    {class} property Command: string read __fakeFieldGet_Command;

  end;

  [DNTypeName('OpenQA.Selenium.Keys')]
  DNKeys = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{A299D239-37AD-30FA-BB02-B22F5BE98009}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNKeys = class(TDNGenericImport<DNKeysClass, DNKeys>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNLogEntryClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{5F2C2AA0-4F35-5BA4-86DD-945301A9AA51}']
  end;

  [DNTypeName('OpenQA.Selenium.LogEntry')]
  DNLogEntry = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{BDFE838E-388A-377D-B90E-80909B8D623C}']
  { getters & setters } 

    function get_Timestamp: DDNC.System.Private.CoreLib.DNDateTime;
    function get_Level: DNLogLevel;
    function get_Message: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Timestamp: DDNC.System.Private.CoreLib.DNDateTime read get_Timestamp;
    property Level: DNLogLevel read get_Level;
    property Message: string read get_Message;
  end;

  TDNLogEntry = class(TDNGenericImport<DNLogEntryClass, DNLogEntry>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNLogTypeClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{DE5F1CDA-23B1-58AB-A59D-ABD5BE7638CB}']
  { static fields getter & setter } 

   function __fakeFieldGet_Client: string;
   function __fakeFieldGet_Driver: string;
   function __fakeFieldGet_Browser: string;
   function __fakeFieldGet_Server: string;
   function __fakeFieldGet_Profiler: string;

  { static fields } 

    {class} property Client: string read __fakeFieldGet_Client;
    {class} property Driver: string read __fakeFieldGet_Driver;
    {class} property Browser: string read __fakeFieldGet_Browser;
    {class} property Server: string read __fakeFieldGet_Server;
    {class} property Profiler: string read __fakeFieldGet_Profiler;

  end;

  [DNTypeName('OpenQA.Selenium.LogType')]
  DNLogType = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{2319157F-7614-321D-BEB2-022F592C44DE}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNLogType = class(TDNGenericImport<DNLogTypeClass, DNLogType>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNPlatformClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{B761FD8A-DA47-503F-A13F-E325705BEDCC}']
  { static getter & setter } 

    {class} function get_CurrentPlatform: DNPlatform;

  { constructors } 

    {class} function init(typeValue: DNPlatformType): DNPlatform;

  { static propertys } 

    {class} property CurrentPlatform: DNPlatform read get_CurrentPlatform;
  end;

  [DNTypeName('OpenQA.Selenium.Platform')]
  DNPlatform = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E77E093F-5D9D-314F-A2AF-9F8753F01CB1}']
  { getters & setters } 

    function get_MajorVersion: Int32;
    function get_MinorVersion: Int32;
    function get_PlatformType: DNPlatformType;
    function get_ProtocolPlatformType: string;

  { methods } 

    function IsPlatformType(compareTo: DNPlatformType): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property MajorVersion: Int32 read get_MajorVersion;
    property MinorVersion: Int32 read get_MinorVersion;
    property PlatformType: DNPlatformType read get_PlatformType;
    property ProtocolPlatformType: string read get_ProtocolPlatformType;
  end;

  TDNPlatform = class(TDNGenericImport<DNPlatformClass, DNPlatform>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNProxyClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{70F427DF-135F-52C6-80FC-04120772F8D0}']
  { constructors } 

    {class} function init: DNProxy; overload;
    {class} function init(settings: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): DNProxy; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Proxy')]
  DNProxy = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{0A13607B-223B-36F2-A5F9-DB15F4FD635A}']
  { getters & setters } 

    function get_Kind: DNProxyKind;
    procedure set_Kind(value: DNProxyKind);
    function get_SerializableProxyKind: string;
    function get_IsAutoDetect: Boolean;
    procedure set_IsAutoDetect(value: Boolean);
    function get_FtpProxy: string;
    procedure set_FtpProxy(value: string);
    function get_HttpProxy: string;
    procedure set_HttpProxy(value: string);
    function get_NoProxy: string;
    procedure set_NoProxy(value: string);
    function get_BypassProxyAddresses: string;
    function get_ProxyAutoConfigUrl: string;
    procedure set_ProxyAutoConfigUrl(value: string);
    function get_SslProxy: string;
    procedure set_SslProxy(value: string);
    function get_SocksProxy: string;
    procedure set_SocksProxy(value: string);
    function get_SocksUserName: string;
    procedure set_SocksUserName(value: string);
    function get_SocksPassword: string;
    procedure set_SocksPassword(value: string);

  { methods } 

    procedure AddBypassAddress(address: string);
    procedure AddBypassAddresses(addressesToAdd: TArray<string>); overload;
    procedure AddBypassAddresses(addressesToAdd: DDNC.System.Private.CoreLib.DNIEnumerable<string>); overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Kind: DNProxyKind read get_Kind write set_Kind;
    property SerializableProxyKind: string read get_SerializableProxyKind;
    property IsAutoDetect: Boolean read get_IsAutoDetect write set_IsAutoDetect;
    property FtpProxy: string read get_FtpProxy write set_FtpProxy;
    property HttpProxy: string read get_HttpProxy write set_HttpProxy;
    property NoProxy: string read get_NoProxy write set_NoProxy;
    property BypassProxyAddresses: string read get_BypassProxyAddresses;
    property ProxyAutoConfigUrl: string read get_ProxyAutoConfigUrl write set_ProxyAutoConfigUrl;
    property SslProxy: string read get_SslProxy write set_SslProxy;
    property SocksProxy: string read get_SocksProxy write set_SocksProxy;
    property SocksUserName: string read get_SocksUserName write set_SocksUserName;
    property SocksPassword: string read get_SocksPassword write set_SocksPassword;
  end;

  TDNProxy = class(TDNGenericImport<DNProxyClass, DNProxy>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNCapabilityTypeClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{BCF681E4-989E-5251-9D1E-CAEC7A2D4B21}']
  { static fields getter & setter } 

   function __fakeFieldGet_BrowserName: string;
   function __fakeFieldGet_BrowserVersion: string;
   function __fakeFieldGet_PlatformName: string;
   function __fakeFieldGet_Platform: string;
   function __fakeFieldGet_Version: string;
   function __fakeFieldGet_IsJavaScriptEnabled: string;
   function __fakeFieldGet_TakesScreenshot: string;
   function __fakeFieldGet_HandlesAlerts: string;
   function __fakeFieldGet_SupportsFindingByCss: string;
   function __fakeFieldGet_Proxy: string;
   function __fakeFieldGet_Rotatable: string;
   function __fakeFieldGet_AcceptSslCertificates: string;
   function __fakeFieldGet_AcceptInsecureCertificates: string;
   function __fakeFieldGet_HasNativeEvents: string;
   function __fakeFieldGet_UnexpectedAlertBehavior: string;
   function __fakeFieldGet_UnhandledPromptBehavior: string;
   function __fakeFieldGet_PageLoadStrategy: string;
   function __fakeFieldGet_LoggingPreferences: string;
   function __fakeFieldGet_DisableOverlappedElementCheck: string;
   function __fakeFieldGet_EnableProfiling: string;
   function __fakeFieldGet_SupportsLocationContext: string;
   function __fakeFieldGet_SupportsApplicationCache: string;
   function __fakeFieldGet_SupportsWebStorage: string;
   function __fakeFieldGet_SetWindowRect: string;
   function __fakeFieldGet_Timeouts: string;

  { static fields } 

    {class} property BrowserName: string read __fakeFieldGet_BrowserName;
    {class} property BrowserVersion: string read __fakeFieldGet_BrowserVersion;
    {class} property PlatformName: string read __fakeFieldGet_PlatformName;
    {class} property Platform: string read __fakeFieldGet_Platform;
    {class} property Version: string read __fakeFieldGet_Version;
    {class} property IsJavaScriptEnabled: string read __fakeFieldGet_IsJavaScriptEnabled;
    {class} property TakesScreenshot: string read __fakeFieldGet_TakesScreenshot;
    {class} property HandlesAlerts: string read __fakeFieldGet_HandlesAlerts;
    {class} property SupportsFindingByCss: string read __fakeFieldGet_SupportsFindingByCss;
    {class} property Proxy: string read __fakeFieldGet_Proxy;
    {class} property Rotatable: string read __fakeFieldGet_Rotatable;
    {class} property AcceptSslCertificates: string read __fakeFieldGet_AcceptSslCertificates;
    {class} property AcceptInsecureCertificates: string read __fakeFieldGet_AcceptInsecureCertificates;
    {class} property HasNativeEvents: string read __fakeFieldGet_HasNativeEvents;
    {class} property UnexpectedAlertBehavior: string read __fakeFieldGet_UnexpectedAlertBehavior;
    {class} property UnhandledPromptBehavior: string read __fakeFieldGet_UnhandledPromptBehavior;
    {class} property PageLoadStrategy: string read __fakeFieldGet_PageLoadStrategy;
    {class} property LoggingPreferences: string read __fakeFieldGet_LoggingPreferences;
    {class} property DisableOverlappedElementCheck: string read __fakeFieldGet_DisableOverlappedElementCheck;
    {class} property EnableProfiling: string read __fakeFieldGet_EnableProfiling;
    {class} property SupportsLocationContext: string read __fakeFieldGet_SupportsLocationContext;
    {class} property SupportsApplicationCache: string read __fakeFieldGet_SupportsApplicationCache;
    {class} property SupportsWebStorage: string read __fakeFieldGet_SupportsWebStorage;
    {class} property SetWindowRect: string read __fakeFieldGet_SetWindowRect;
    {class} property Timeouts: string read __fakeFieldGet_Timeouts;

  { static methods } 

    {class} function IsSpecCompliantCapabilityName(capabilityName: string): Boolean;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.CapabilityType')]
  DNCapabilityType = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{CA35A14D-78A0-3431-9A18-01474E709F77}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNCapabilityType = class(TDNGenericImport<DNCapabilityTypeClass, DNCapabilityType>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNCommandClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{AA438226-0983-59CB-9E4E-B90A07AAC904}']
  { constructors } 

    {class} function init(name: string; jsonParameters: string): DNCommand; overload;
    {class} function init(sessionId: DNSessionId; name: string; parameters: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): DNCommand; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.Command')]
  DNCommand = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{6C0EE35A-4EA2-3441-9BB9-07206C7DEB51}']
  { getters & setters } 

    function get_SessionId: DNSessionId;
    function get_Name: string;
    function get_Parameters: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function get_ParametersAsJsonString: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property SessionId: DNSessionId read get_SessionId;
    property Name: string read get_Name;
    property Parameters: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject> read get_Parameters;
    property ParametersAsJsonString: string read get_ParametersAsJsonString;
  end;

  TDNCommand = class(TDNGenericImport<DNCommandClass, DNCommand>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNCommandInfoClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0CF4189A-5AEB-5ADB-B9FE-3AB8329FA813}']
  { constructors } 

    {class} function init(method: string; resourcePath: string): DNCommandInfo;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.CommandInfo')]
  DNCommandInfo = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{1E3E1400-A91A-341D-AD02-94B520190378}']
  { getters & setters } 

    function get_ResourcePath: string;
    function get_Method: string;

  { methods } 

    function CreateCommandUri(baseUri: DDNC.System.Private.Uri.DNUri; commandToExecute: DNCommand): DDNC.System.Private.Uri.DNUri;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property ResourcePath: string read get_ResourcePath;
    property Method: string read get_Method;
  end;

  TDNCommandInfo = class(TDNGenericImport<DNCommandInfoClass, DNCommandInfo>)
  public const
   PostCommand = 'POST';
   GetCommand = 'GET';
   DeleteCommand = 'DELETE';
  end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNCommandInfoRepositoryClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{D9CCDE0D-0C6D-535F-9F61-68F5907F56AC}']
  end;

  [DNTypeName('OpenQA.Selenium.Remote.CommandInfoRepository')]
  DNCommandInfoRepository = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{D64CAD2D-3F65-317A-B20E-C451244E24FD}']
  { getters & setters } 

    function get_SpecificationLevel: Int32;

  { methods } 

    function GetCommandInfo(commandName: string): DNCommandInfo;
    function TryAddCommand(commandName: string; commandInfo: DNCommandInfo): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property SpecificationLevel: Int32 read get_SpecificationLevel;
  end;

  TDNCommandInfoRepository = class(TDNGenericImport<DNCommandInfoRepositoryClass, DNCommandInfoRepository>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNW3CWireProtocolCommandInfoRepositoryClass = interface(DNCommandInfoRepositoryClass)
  ['{C3110556-AD95-540A-ADB6-8F3CDAA3B985}']
  { constructors } 

    {class} function init: DNW3CWireProtocolCommandInfoRepository;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.W3CWireProtocolCommandInfoRepository')]
  DNW3CWireProtocolCommandInfoRepository = interface(DNCommandInfoRepository)
  ['{B687517D-F2A9-38B0-BE27-3E831A292243}']
  { getters & setters } 

    function get_SpecificationLevel: Int32;

  { methods } 

    function GetCommandInfo(commandName: string): DNCommandInfo;
    function TryAddCommand(commandName: string; commandInfo: DNCommandInfo): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property SpecificationLevel: Int32 read get_SpecificationLevel;
  end;

  TDNW3CWireProtocolCommandInfoRepository = class(TDNGenericImport<DNW3CWireProtocolCommandInfoRepositoryClass, DNW3CWireProtocolCommandInfoRepository>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNWebDriverWireProtocolCommandInfoRepositoryClass = interface(DNCommandInfoRepositoryClass)
  ['{060C87B4-3C45-50DF-BCC8-EF15DD5062A2}']
  { constructors } 

    {class} function init: DNWebDriverWireProtocolCommandInfoRepository;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.WebDriverWireProtocolCommandInfoRepository')]
  DNWebDriverWireProtocolCommandInfoRepository = interface(DNCommandInfoRepository)
  ['{DA26EB45-1A73-38FE-B4C3-8F758936486B}']
  { getters & setters } 

    function get_SpecificationLevel: Int32;

  { methods } 

    function GetCommandInfo(commandName: string): DNCommandInfo;
    function TryAddCommand(commandName: string; commandInfo: DNCommandInfo): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property SpecificationLevel: Int32 read get_SpecificationLevel;
  end;

  TDNWebDriverWireProtocolCommandInfoRepository = class(TDNGenericImport<DNWebDriverWireProtocolCommandInfoRepositoryClass, DNWebDriverWireProtocolCommandInfoRepository>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNDesiredCapabilitiesClass = interface(DNObjectClass)
  ['{39F168BA-271C-5CC7-AE1C-22B884CF7289}']
  { constructors } 

    {class} function init(browser: string; version: string; platform: DNPlatform): DNDesiredCapabilities; overload;
    {class} function init: DNDesiredCapabilities; overload;
    {class} function init(rawMap: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): DNDesiredCapabilities; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.DesiredCapabilities')]
  DNDesiredCapabilities = interface(DNICapabilities)
  ['{2A421CF9-70F7-3AD9-9F37-A3F14B6194B0}']
  { getters & setters } 

    function get_BrowserName: string;
    function get_Platform: DNPlatform;
    procedure set_Platform(value: DNPlatform);
    function get_Version: string;
    function get_AcceptInsecureCerts: Boolean;
    procedure set_AcceptInsecureCerts(value: Boolean);

  { methods } 

    function HasCapability(capability: string): Boolean;
    function GetCapability(capability: string): DDNC.System.Private.CoreLib.DNObject;
    procedure SetCapability(capability: string; capabilityValue: DDNC.System.Private.CoreLib.DNObject);
    function GetHashCode: Int32;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property BrowserName: string read get_BrowserName;
    property Platform: DNPlatform read get_Platform write set_Platform;
    property Version: string read get_Version;
    property AcceptInsecureCerts: Boolean read get_AcceptInsecureCerts write set_AcceptInsecureCerts;
  end;

  TDNDesiredCapabilities = class(TDNGenericImport<DNDesiredCapabilitiesClass, DNDesiredCapabilities>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNDriverCommandClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{6EBE2296-6886-59E2-9F9D-9F5A4F253602}']
  { static fields getter & setter } 

   function __fakeFieldGet_DefineDriverMapping: string;
   function __fakeFieldGet_Status: string;
   function __fakeFieldGet_NewSession: string;
   function __fakeFieldGet_GetSessionList: string;
   function __fakeFieldGet_GetSessionCapabilities: string;
   function __fakeFieldGet_Close: string;
   function __fakeFieldGet_Quit: string;
   function __fakeFieldGet_Get: string;
   function __fakeFieldGet_GoBack: string;
   function __fakeFieldGet_GoForward: string;
   function __fakeFieldGet_Refresh: string;
   function __fakeFieldGet_AddCookie: string;
   function __fakeFieldGet_GetAllCookies: string;
   function __fakeFieldGet_GetCookie: string;
   function __fakeFieldGet_DeleteCookie: string;
   function __fakeFieldGet_DeleteAllCookies: string;
   function __fakeFieldGet_FindElement: string;
   function __fakeFieldGet_FindElements: string;
   function __fakeFieldGet_FindChildElement: string;
   function __fakeFieldGet_FindChildElements: string;
   function __fakeFieldGet_DescribeElement: string;
   function __fakeFieldGet_ClearElement: string;
   function __fakeFieldGet_ClickElement: string;
   function __fakeFieldGet_SendKeysToElement: string;
   function __fakeFieldGet_TapElement: string;
   function __fakeFieldGet_SubmitElement: string;
   function __fakeFieldGet_GetCurrentWindowHandle: string;
   function __fakeFieldGet_GetWindowHandles: string;
   function __fakeFieldGet_SwitchToWindow: string;
   function __fakeFieldGet_SwitchToFrame: string;
   function __fakeFieldGet_SwitchToParentFrame: string;
   function __fakeFieldGet_GetActiveElement: string;
   function __fakeFieldGet_GetCurrentUrl: string;
   function __fakeFieldGet_GetPageSource: string;
   function __fakeFieldGet_GetTitle: string;
   function __fakeFieldGet_ExecuteScript: string;
   function __fakeFieldGet_ExecuteAsyncScript: string;
   function __fakeFieldGet_GetElementText: string;
   function __fakeFieldGet_GetElementTagName: string;
   function __fakeFieldGet_IsElementSelected: string;
   function __fakeFieldGet_IsElementEnabled: string;
   function __fakeFieldGet_IsElementDisplayed: string;
   function __fakeFieldGet_GetElementLocation: string;
   function __fakeFieldGet_GetElementLocationOnceScrolledIntoView: string;
   function __fakeFieldGet_GetElementSize: string;
   function __fakeFieldGet_GetElementRect: string;
   function __fakeFieldGet_GetElementAttribute: string;
   function __fakeFieldGet_GetElementProperty: string;
   function __fakeFieldGet_GetElementValueOfCssProperty: string;
   function __fakeFieldGet_ElementEquals: string;
   function __fakeFieldGet_Screenshot: string;
   function __fakeFieldGet_ElementScreenshot: string;
   function __fakeFieldGet_GetOrientation: string;
   function __fakeFieldGet_SetOrientation: string;
   function __fakeFieldGet_GetWindowSize: string;
   function __fakeFieldGet_SetWindowSize: string;
   function __fakeFieldGet_GetWindowPosition: string;
   function __fakeFieldGet_SetWindowPosition: string;
   function __fakeFieldGet_GetWindowRect: string;
   function __fakeFieldGet_SetWindowRect: string;
   function __fakeFieldGet_MaximizeWindow: string;
   function __fakeFieldGet_MinimizeWindow: string;
   function __fakeFieldGet_FullScreenWindow: string;
   function __fakeFieldGet_DismissAlert: string;
   function __fakeFieldGet_AcceptAlert: string;
   function __fakeFieldGet_GetAlertText: string;
   function __fakeFieldGet_SetAlertValue: string;
   function __fakeFieldGet_SetAlertCredentials: string;
   function __fakeFieldGet_ImplicitlyWait: string;
   function __fakeFieldGet_SetAsyncScriptTimeout: string;
   function __fakeFieldGet_SetTimeouts: string;
   function __fakeFieldGet_GetTimeouts: string;
   function __fakeFieldGet_Actions: string;
   function __fakeFieldGet_CancelActions: string;
   function __fakeFieldGet_MouseClick: string;
   function __fakeFieldGet_MouseDoubleClick: string;
   function __fakeFieldGet_MouseDown: string;
   function __fakeFieldGet_MouseUp: string;
   function __fakeFieldGet_MouseMoveTo: string;
   function __fakeFieldGet_SendKeysToActiveElement: string;
   function __fakeFieldGet_UploadFile: string;
   function __fakeFieldGet_TouchSingleTap: string;
   function __fakeFieldGet_TouchPress: string;
   function __fakeFieldGet_TouchRelease: string;
   function __fakeFieldGet_TouchMove: string;
   function __fakeFieldGet_TouchScroll: string;
   function __fakeFieldGet_TouchDoubleTap: string;
   function __fakeFieldGet_TouchLongPress: string;
   function __fakeFieldGet_TouchFlick: string;
   function __fakeFieldGet_GetLocation: string;
   function __fakeFieldGet_SetLocation: string;
   function __fakeFieldGet_GetAppCache: string;
   function __fakeFieldGet_GetAppCacheStatus: string;
   function __fakeFieldGet_ClearAppCache: string;
   function __fakeFieldGet_GetLocalStorageItem: string;
   function __fakeFieldGet_GetLocalStorageKeys: string;
   function __fakeFieldGet_SetLocalStorageItem: string;
   function __fakeFieldGet_RemoveLocalStorageItem: string;
   function __fakeFieldGet_ClearLocalStorage: string;
   function __fakeFieldGet_GetLocalStorageSize: string;
   function __fakeFieldGet_GetSessionStorageItem: string;
   function __fakeFieldGet_GetSessionStorageKeys: string;
   function __fakeFieldGet_SetSessionStorageItem: string;
   function __fakeFieldGet_RemoveSessionStorageItem: string;
   function __fakeFieldGet_ClearSessionStorage: string;
   function __fakeFieldGet_GetSessionStorageSize: string;
   function __fakeFieldGet_GetAvailableLogTypes: string;
   function __fakeFieldGet_GetLog: string;

  { static fields } 

    {class} property DefineDriverMapping: string read __fakeFieldGet_DefineDriverMapping;
    {class} property Status: string read __fakeFieldGet_Status;
    {class} property NewSession: string read __fakeFieldGet_NewSession;
    {class} property GetSessionList: string read __fakeFieldGet_GetSessionList;
    {class} property GetSessionCapabilities: string read __fakeFieldGet_GetSessionCapabilities;
    {class} property Close: string read __fakeFieldGet_Close;
    {class} property Quit: string read __fakeFieldGet_Quit;
    {class} property Get: string read __fakeFieldGet_Get;
    {class} property GoBack: string read __fakeFieldGet_GoBack;
    {class} property GoForward: string read __fakeFieldGet_GoForward;
    {class} property Refresh: string read __fakeFieldGet_Refresh;
    {class} property AddCookie: string read __fakeFieldGet_AddCookie;
    {class} property GetAllCookies: string read __fakeFieldGet_GetAllCookies;
    {class} property GetCookie: string read __fakeFieldGet_GetCookie;
    {class} property DeleteCookie: string read __fakeFieldGet_DeleteCookie;
    {class} property DeleteAllCookies: string read __fakeFieldGet_DeleteAllCookies;
    {class} property FindElement: string read __fakeFieldGet_FindElement;
    {class} property FindElements: string read __fakeFieldGet_FindElements;
    {class} property FindChildElement: string read __fakeFieldGet_FindChildElement;
    {class} property FindChildElements: string read __fakeFieldGet_FindChildElements;
    {class} property DescribeElement: string read __fakeFieldGet_DescribeElement;
    {class} property ClearElement: string read __fakeFieldGet_ClearElement;
    {class} property ClickElement: string read __fakeFieldGet_ClickElement;
    {class} property SendKeysToElement: string read __fakeFieldGet_SendKeysToElement;
    {class} property TapElement: string read __fakeFieldGet_TapElement;
    {class} property SubmitElement: string read __fakeFieldGet_SubmitElement;
    {class} property GetCurrentWindowHandle: string read __fakeFieldGet_GetCurrentWindowHandle;
    {class} property GetWindowHandles: string read __fakeFieldGet_GetWindowHandles;
    {class} property SwitchToWindow: string read __fakeFieldGet_SwitchToWindow;
    {class} property SwitchToFrame: string read __fakeFieldGet_SwitchToFrame;
    {class} property SwitchToParentFrame: string read __fakeFieldGet_SwitchToParentFrame;
    {class} property GetActiveElement: string read __fakeFieldGet_GetActiveElement;
    {class} property GetCurrentUrl: string read __fakeFieldGet_GetCurrentUrl;
    {class} property GetPageSource: string read __fakeFieldGet_GetPageSource;
    {class} property GetTitle: string read __fakeFieldGet_GetTitle;
    {class} property ExecuteScript: string read __fakeFieldGet_ExecuteScript;
    {class} property ExecuteAsyncScript: string read __fakeFieldGet_ExecuteAsyncScript;
    {class} property GetElementText: string read __fakeFieldGet_GetElementText;
    {class} property GetElementTagName: string read __fakeFieldGet_GetElementTagName;
    {class} property IsElementSelected: string read __fakeFieldGet_IsElementSelected;
    {class} property IsElementEnabled: string read __fakeFieldGet_IsElementEnabled;
    {class} property IsElementDisplayed: string read __fakeFieldGet_IsElementDisplayed;
    {class} property GetElementLocation: string read __fakeFieldGet_GetElementLocation;
    {class} property GetElementLocationOnceScrolledIntoView: string read __fakeFieldGet_GetElementLocationOnceScrolledIntoView;
    {class} property GetElementSize: string read __fakeFieldGet_GetElementSize;
    {class} property GetElementRect: string read __fakeFieldGet_GetElementRect;
    {class} property GetElementAttribute: string read __fakeFieldGet_GetElementAttribute;
    {class} property GetElementProperty: string read __fakeFieldGet_GetElementProperty;
    {class} property GetElementValueOfCssProperty: string read __fakeFieldGet_GetElementValueOfCssProperty;
    {class} property ElementEquals: string read __fakeFieldGet_ElementEquals;
    {class} property Screenshot: string read __fakeFieldGet_Screenshot;
    {class} property ElementScreenshot: string read __fakeFieldGet_ElementScreenshot;
    {class} property GetOrientation: string read __fakeFieldGet_GetOrientation;
    {class} property SetOrientation: string read __fakeFieldGet_SetOrientation;
    {class} property GetWindowSize: string read __fakeFieldGet_GetWindowSize;
    {class} property SetWindowSize: string read __fakeFieldGet_SetWindowSize;
    {class} property GetWindowPosition: string read __fakeFieldGet_GetWindowPosition;
    {class} property SetWindowPosition: string read __fakeFieldGet_SetWindowPosition;
    {class} property GetWindowRect: string read __fakeFieldGet_GetWindowRect;
    {class} property SetWindowRect: string read __fakeFieldGet_SetWindowRect;
    {class} property MaximizeWindow: string read __fakeFieldGet_MaximizeWindow;
    {class} property MinimizeWindow: string read __fakeFieldGet_MinimizeWindow;
    {class} property FullScreenWindow: string read __fakeFieldGet_FullScreenWindow;
    {class} property DismissAlert: string read __fakeFieldGet_DismissAlert;
    {class} property AcceptAlert: string read __fakeFieldGet_AcceptAlert;
    {class} property GetAlertText: string read __fakeFieldGet_GetAlertText;
    {class} property SetAlertValue: string read __fakeFieldGet_SetAlertValue;
    {class} property SetAlertCredentials: string read __fakeFieldGet_SetAlertCredentials;
    {class} property ImplicitlyWait: string read __fakeFieldGet_ImplicitlyWait;
    {class} property SetAsyncScriptTimeout: string read __fakeFieldGet_SetAsyncScriptTimeout;
    {class} property SetTimeouts: string read __fakeFieldGet_SetTimeouts;
    {class} property GetTimeouts: string read __fakeFieldGet_GetTimeouts;
    {class} property Actions: string read __fakeFieldGet_Actions;
    {class} property CancelActions: string read __fakeFieldGet_CancelActions;
    {class} property MouseClick: string read __fakeFieldGet_MouseClick;
    {class} property MouseDoubleClick: string read __fakeFieldGet_MouseDoubleClick;
    {class} property MouseDown: string read __fakeFieldGet_MouseDown;
    {class} property MouseUp: string read __fakeFieldGet_MouseUp;
    {class} property MouseMoveTo: string read __fakeFieldGet_MouseMoveTo;
    {class} property SendKeysToActiveElement: string read __fakeFieldGet_SendKeysToActiveElement;
    {class} property UploadFile: string read __fakeFieldGet_UploadFile;
    {class} property TouchSingleTap: string read __fakeFieldGet_TouchSingleTap;
    {class} property TouchPress: string read __fakeFieldGet_TouchPress;
    {class} property TouchRelease: string read __fakeFieldGet_TouchRelease;
    {class} property TouchMove: string read __fakeFieldGet_TouchMove;
    {class} property TouchScroll: string read __fakeFieldGet_TouchScroll;
    {class} property TouchDoubleTap: string read __fakeFieldGet_TouchDoubleTap;
    {class} property TouchLongPress: string read __fakeFieldGet_TouchLongPress;
    {class} property TouchFlick: string read __fakeFieldGet_TouchFlick;
    {class} property GetLocation: string read __fakeFieldGet_GetLocation;
    {class} property SetLocation: string read __fakeFieldGet_SetLocation;
    {class} property GetAppCache: string read __fakeFieldGet_GetAppCache;
    {class} property GetAppCacheStatus: string read __fakeFieldGet_GetAppCacheStatus;
    {class} property ClearAppCache: string read __fakeFieldGet_ClearAppCache;
    {class} property GetLocalStorageItem: string read __fakeFieldGet_GetLocalStorageItem;
    {class} property GetLocalStorageKeys: string read __fakeFieldGet_GetLocalStorageKeys;
    {class} property SetLocalStorageItem: string read __fakeFieldGet_SetLocalStorageItem;
    {class} property RemoveLocalStorageItem: string read __fakeFieldGet_RemoveLocalStorageItem;
    {class} property ClearLocalStorage: string read __fakeFieldGet_ClearLocalStorage;
    {class} property GetLocalStorageSize: string read __fakeFieldGet_GetLocalStorageSize;
    {class} property GetSessionStorageItem: string read __fakeFieldGet_GetSessionStorageItem;
    {class} property GetSessionStorageKeys: string read __fakeFieldGet_GetSessionStorageKeys;
    {class} property SetSessionStorageItem: string read __fakeFieldGet_SetSessionStorageItem;
    {class} property RemoveSessionStorageItem: string read __fakeFieldGet_RemoveSessionStorageItem;
    {class} property ClearSessionStorage: string read __fakeFieldGet_ClearSessionStorage;
    {class} property GetSessionStorageSize: string read __fakeFieldGet_GetSessionStorageSize;
    {class} property GetAvailableLogTypes: string read __fakeFieldGet_GetAvailableLogTypes;
    {class} property GetLog: string read __fakeFieldGet_GetLog;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.DriverCommand')]
  DNDriverCommand = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{3A0D0254-2CEB-368C-8659-380E0D6E667F}']
  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNDriverCommand = class(TDNGenericImport<DNDriverCommandClass, DNDriverCommand>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNDriverOptionsMergeResultClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{03D914FC-CDF5-5C7E-B6E7-CC27C952FB10}']
  { constructors } 

    {class} function init: DNDriverOptionsMergeResult;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.DriverOptionsMergeResult')]
  DNDriverOptionsMergeResult = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{1548A21E-3FFF-33AA-98B2-0D9B48740064}']
  { getters & setters } 

    function get_IsMergeConflict: Boolean;
    procedure set_IsMergeConflict(value: Boolean);
    function get_MergeConflictOptionName: string;
    procedure set_MergeConflictOptionName(value: string);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property IsMergeConflict: Boolean read get_IsMergeConflict write set_IsMergeConflict;
    property MergeConflictOptionName: string read get_MergeConflictOptionName write set_MergeConflictOptionName;
  end;

  TDNDriverOptionsMergeResult = class(TDNGenericImport<DNDriverOptionsMergeResultClass, DNDriverOptionsMergeResult>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNDriverServiceCommandExecutorClass = interface(DNObjectClass)
  ['{822DC1A4-CF6B-5F31-9BCE-7F30DD40C874}']
  { constructors } 

    {class} function init(driverService: DNDriverService; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNDriverServiceCommandExecutor; overload;
    {class} function init(driverService: DNDriverService; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan; enableKeepAlive: Boolean): DNDriverServiceCommandExecutor; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.DriverServiceCommandExecutor')]
  DNDriverServiceCommandExecutor = interface(DNICommandExecutor)
  ['{FD82AB16-F5C0-393C-986B-AFF3584901C9}']
  { getters & setters } 

    function get_CommandInfoRepository: DNCommandInfoRepository;
    function get_HttpExecutor: DNHttpCommandExecutor;

  { methods } 

    function Execute(commandToExecute: DNCommand): DNResponse;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CommandInfoRepository: DNCommandInfoRepository read get_CommandInfoRepository;
    property HttpExecutor: DNHttpCommandExecutor read get_HttpExecutor;
  end;

  TDNDriverServiceCommandExecutor = class(TDNGenericImport<DNDriverServiceCommandExecutorClass, DNDriverServiceCommandExecutor>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNErrorResponseClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{6A8224CF-9DE8-56BE-8934-4778CC92F350}']
  { constructors } 

    {class} function init: DNErrorResponse; overload;
    {class} function init(responseValue: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): DNErrorResponse; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.ErrorResponse')]
  DNErrorResponse = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{C231182A-D2CC-311E-AE23-B644B4379B80}']
  { getters & setters } 

    function get_Message: string;
    procedure set_Message(value: string);
    function get_ClassName: string;
    procedure set_ClassName(value: string);
    function get_Screenshot: string;
    procedure set_Screenshot(value: string);
    function get_StackTrace: TArray<DNStackTraceElement>;
    procedure set_StackTrace(value: TArray<DNStackTraceElement>);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Message: string read get_Message write set_Message;
    property ClassName: string read get_ClassName write set_ClassName;
    property Screenshot: string read get_Screenshot write set_Screenshot;
    property StackTrace: TArray<DNStackTraceElement> read get_StackTrace write set_StackTrace;
  end;

  TDNErrorResponse = class(TDNGenericImport<DNErrorResponseClass, DNErrorResponse>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNHttpCommandExecutorClass = interface(DNObjectClass)
  ['{17025275-6EDD-56FF-AA19-B654B9583942}']
  { constructors } 

    {class} function init(addressOfRemoteServer: DDNC.System.Private.Uri.DNUri; timeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNHttpCommandExecutor; overload;
    {class} function init(addressOfRemoteServer: DDNC.System.Private.Uri.DNUri; timeout: DDNC.System.Private.CoreLib.DNTimeSpan; enableKeepAlive: Boolean): DNHttpCommandExecutor; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.HttpCommandExecutor')]
  DNHttpCommandExecutor = interface(DNICommandExecutor)
  ['{20F8B36F-DC08-37B9-AE4F-B5A3935E17F8}']
  { getters & setters } 

    function get_CommandInfoRepository: DNCommandInfoRepository;
    function get_Proxy: DDNC.System.Net.Primitives.DNIWebProxy;
    procedure set_Proxy(value: DDNC.System.Net.Primitives.DNIWebProxy);
    function get_IsKeepAliveEnabled: Boolean;
    procedure set_IsKeepAliveEnabled(value: Boolean);

  { events } 

    procedure add_SendingRemoteHttpRequest(value: DDNC.System.Private.CoreLib.DNEventHandler<DNSendingRemoteHttpRequestEventArgs>);
    procedure remove_SendingRemoteHttpRequest(value: DDNC.System.Private.CoreLib.DNEventHandler<DNSendingRemoteHttpRequestEventArgs>);

  { methods } 

    function Execute(commandToExecute: DNCommand): DNResponse;
    procedure Dispose;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property CommandInfoRepository: DNCommandInfoRepository read get_CommandInfoRepository;
    property Proxy: DDNC.System.Net.Primitives.DNIWebProxy read get_Proxy write set_Proxy;
    property IsKeepAliveEnabled: Boolean read get_IsKeepAliveEnabled write set_IsKeepAliveEnabled;
  end;

  TDNHttpCommandExecutor = class(TDNGenericImport<DNHttpCommandExecutorClass, DNHttpCommandExecutor>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNLocalFileDetectorClass = interface(DNObjectClass)
  ['{22CECBE6-19E9-5961-9D4C-1F4260454633}']
  { constructors } 

    {class} function init: DNLocalFileDetector;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.LocalFileDetector')]
  DNLocalFileDetector = interface(DNIFileDetector)
  ['{5BA65A8E-6B0B-365C-ABFF-D1D3BD42D89A}']
  { methods } 

    function IsFile(keySequence: string): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNLocalFileDetector = class(TDNGenericImport<DNLocalFileDetectorClass, DNLocalFileDetector>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNReadOnlyDesiredCapabilitiesClass = interface(DNObjectClass)
  ['{9ECB45FE-F0FA-5390-BB00-F559EE44E26D}']
  end;

  [DNTypeName('OpenQA.Selenium.Remote.ReadOnlyDesiredCapabilities')]
  DNReadOnlyDesiredCapabilities = interface(DNICapabilities)
  ['{BC6E5823-8DC5-3E95-94FC-570DDBC825B6}']
  { getters & setters } 

    function get_BrowserName: string;
    function get_Platform: DNPlatform;
    function get_Version: string;
    function get_AcceptInsecureCerts: Boolean;

  { methods } 

    function HasCapability(capability: string): Boolean;
    function GetCapability(capability: string): DDNC.System.Private.CoreLib.DNObject;
    function ToDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function GetHashCode: Int32;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property BrowserName: string read get_BrowserName;
    property Platform: DNPlatform read get_Platform;
    property Version: string read get_Version;
    property AcceptInsecureCerts: Boolean read get_AcceptInsecureCerts;
  end;

  TDNReadOnlyDesiredCapabilities = class(TDNGenericImport<DNReadOnlyDesiredCapabilitiesClass, DNReadOnlyDesiredCapabilities>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteApplicationCacheClass = interface(DNObjectClass)
  ['{04850C87-CCCE-50AB-AA50-DBA1475709F5}']
  { constructors } 

    {class} function init(driver: DNRemoteWebDriver): DNRemoteApplicationCache;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteApplicationCache')]
  DNRemoteApplicationCache = interface(DNIApplicationCache)
  ['{89522948-F483-37D2-944C-40F4373FCBA6}']
  { getters & setters } 

    function get_Status: DNAppCacheStatus;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Status: DNAppCacheStatus read get_Status;
  end;

  TDNRemoteApplicationCache = class(TDNGenericImport<DNRemoteApplicationCacheClass, DNRemoteApplicationCache>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteLocalStorageClass = interface(DNObjectClass)
  ['{982F463A-6243-5223-9D17-5C3D44E5E94E}']
  { constructors } 

    {class} function init(driver: DNRemoteWebDriver): DNRemoteLocalStorage;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteLocalStorage')]
  DNRemoteLocalStorage = interface(DNILocalStorage)
  ['{07222463-B5D6-32B3-9115-92F053797111}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    function GetItem(key: string): string;
    function KeySet: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    procedure SetItem(key: string; value: string);
    function RemoveItem(key: string): string;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNRemoteLocalStorage = class(TDNGenericImport<DNRemoteLocalStorageClass, DNRemoteLocalStorage>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteLocationContextClass = interface(DNObjectClass)
  ['{C4BF342A-CA33-530A-9F54-497E1812024B}']
  { constructors } 

    {class} function init(driver: DNRemoteWebDriver): DNRemoteLocationContext;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteLocationContext')]
  DNRemoteLocationContext = interface(DNILocationContext)
  ['{DDE80D51-1345-30AC-B050-7D3B1F8EA155}']
  { getters & setters } 

    function get_PhysicalLocation: DNLocation;
    procedure set_PhysicalLocation(value: DNLocation);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property PhysicalLocation: DNLocation read get_PhysicalLocation write set_PhysicalLocation;
  end;

  TDNRemoteLocationContext = class(TDNGenericImport<DNRemoteLocationContextClass, DNRemoteLocationContext>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteLogsClass = interface(DNObjectClass)
  ['{3AEDFB6D-14B4-518D-813E-E0B8F9F833F5}']
  { constructors } 

    {class} function init(driver: DNRemoteWebDriver): DNRemoteLogs;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteLogs')]
  DNRemoteLogs = interface(DNILogs)
  ['{7FC7A001-B512-3617-B87B-A8DFFE2DDA59}']
  { getters & setters } 

    function get_AvailableLogTypes: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;

  { methods } 

    function GetLog(logKind: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNLogEntry>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AvailableLogTypes: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_AvailableLogTypes;
  end;

  TDNRemoteLogs = class(TDNGenericImport<DNRemoteLogsClass, DNRemoteLogs>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteSessionStorageClass = interface(DNObjectClass)
  ['{5BED3826-E9A1-5D43-BE1F-F7172B56D231}']
  { constructors } 

    {class} function init(driver: DNRemoteWebDriver): DNRemoteSessionStorage;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteSessionStorage')]
  DNRemoteSessionStorage = interface(DNISessionStorage)
  ['{8A84170C-B7EB-3CED-AD0D-40648B0BB0ED}']
  { getters & setters } 

    function get_Count: Int32;

  { methods } 

    function GetItem(key: string): string;
    function KeySet: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    procedure SetItem(key: string; value: string);
    function RemoveItem(key: string): string;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Count: Int32 read get_Count;
  end;

  TDNRemoteSessionStorage = class(TDNGenericImport<DNRemoteSessionStorageClass, DNRemoteSessionStorage>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteTouchScreenClass = interface(DNObjectClass)
  ['{1D6B955E-4004-56F9-85D8-F6B16EA239EF}']
  { constructors } 

    {class} function init(driver: DNRemoteWebDriver): DNRemoteTouchScreen;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteTouchScreen')]
  DNRemoteTouchScreen = interface(DNITouchScreen)
  ['{F8252FA0-FE91-3C77-87A9-4AE4C4C4173F}']
  { methods } 

    procedure SingleTap(where: DNICoordinates);
    procedure Down(locationX: Int32; locationY: Int32);
    procedure Up(locationX: Int32; locationY: Int32);
    procedure Move(locationX: Int32; locationY: Int32);
    procedure Scroll(where: DNICoordinates; offsetX: Int32; offsetY: Int32); overload;
    procedure Scroll(offsetX: Int32; offsetY: Int32); overload;
    procedure DoubleTap(where: DNICoordinates);
    procedure LongPress(where: DNICoordinates);
    procedure Flick(speedX: Int32; speedY: Int32); overload;
    procedure Flick(where: DNICoordinates; offsetX: Int32; offsetY: Int32; speed: Int32); overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRemoteTouchScreen = class(TDNGenericImport<DNRemoteTouchScreenClass, DNRemoteTouchScreen>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteWebDriverClass = interface(DNObjectClass)
  ['{6A1609A7-203B-5C6D-938A-372F683744DC}']
  { constructors } 

    {class} function init(options: DNDriverOptions): DNRemoteWebDriver; overload;
    {class} function init(desiredCapabilities: DNICapabilities): DNRemoteWebDriver; overload;
    {class} function init(remoteAddress: DDNC.System.Private.Uri.DNUri; options: DNDriverOptions): DNRemoteWebDriver; overload;
    {class} function init(remoteAddress: DDNC.System.Private.Uri.DNUri; desiredCapabilities: DNICapabilities): DNRemoteWebDriver; overload;
    {class} function init(remoteAddress: DDNC.System.Private.Uri.DNUri; desiredCapabilities: DNICapabilities; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNRemoteWebDriver; overload;
    {class} function init(commandExecutor: DNICommandExecutor; desiredCapabilities: DNICapabilities): DNRemoteWebDriver; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteWebDriver')]
  DNRemoteWebDriver = interface(DNIWebDriver)
  ['{369E3E45-7629-315D-B6BD-A7A4FE8B4252}']
  { getters & setters } 

    function get_Url: string;
    procedure set_Url(value: string);
    function get_Title: string;
    function get_PageSource: string;
    function get_CurrentWindowHandle: string;
    function get_WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_Keyboard: DNIKeyboard;
    function get_Mouse: DNIMouse;
    function get_HasWebStorage: Boolean;
    function get_WebStorage: DNIWebStorage;
    function get_HasApplicationCache: Boolean;
    function get_ApplicationCache: DNIApplicationCache;
    function get_HasLocationContext: Boolean;
    function get_LocationContext: DNILocationContext;
    function get_Capabilities: DNICapabilities;
    function get_FileDetector: DNIFileDetector;
    procedure set_FileDetector(value: DNIFileDetector);
    function get_SessionId: DNSessionId;
    function get_IsActionExecutor: Boolean;

  { methods } 

    function FindElement(by: DNBy): DNIWebElement;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    procedure Close;
    procedure Quit;
    function Manage: DNIOptions;
    function Navigate: DNINavigation;
    function SwitchTo: DNITargetLocator;
    function ExecuteScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function ExecuteAsyncScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    procedure Dispose;
    procedure PerformActions(actionSequenceList: DDNC.System.Private.CoreLib.DNIList<DNActionSequence>);
    procedure ResetInputState;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Url: string read get_Url write set_Url;
    property Title: string read get_Title;
    property PageSource: string read get_PageSource;
    property CurrentWindowHandle: string read get_CurrentWindowHandle;
    property WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_WindowHandles;
    property Keyboard: DNIKeyboard read get_Keyboard;
    property Mouse: DNIMouse read get_Mouse;
    property HasWebStorage: Boolean read get_HasWebStorage;
    property WebStorage: DNIWebStorage read get_WebStorage;
    property HasApplicationCache: Boolean read get_HasApplicationCache;
    property ApplicationCache: DNIApplicationCache read get_ApplicationCache;
    property HasLocationContext: Boolean read get_HasLocationContext;
    property LocationContext: DNILocationContext read get_LocationContext;
    property Capabilities: DNICapabilities read get_Capabilities;
    property FileDetector: DNIFileDetector read get_FileDetector write set_FileDetector;
    property SessionId: DNSessionId read get_SessionId;
    property IsActionExecutor: Boolean read get_IsActionExecutor;
  end;

  TDNRemoteWebDriver = class(TDNGenericImport<DNRemoteWebDriverClass, DNRemoteWebDriver>) end;

  //-------------namespace: OpenQA.Selenium.Chrome----------------
  DNChromeDriverClass = interface(DNRemoteWebDriverClass)
  ['{DF91EBF3-1535-5801-B80F-C8BFB51938A2}']
  { constructors } 

    {class} function init: DNChromeDriver; overload;
    {class} function init(options: DNChromeOptions): DNChromeDriver; overload;
    {class} function init(service: DNChromeDriverService): DNChromeDriver; overload;
    {class} function init(chromeDriverDirectory: string): DNChromeDriver; overload;
    {class} function init(chromeDriverDirectory: string; options: DNChromeOptions): DNChromeDriver; overload;
    {class} function init(chromeDriverDirectory: string; options: DNChromeOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNChromeDriver; overload;
    {class} function init(service: DNChromeDriverService; options: DNChromeOptions): DNChromeDriver; overload;
    {class} function init(service: DNChromeDriverService; options: DNChromeOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNChromeDriver; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_AcceptUntrustedCertificates: Boolean;

  { static fields } 

    {class} property AcceptUntrustedCertificates: Boolean read __fakeFieldGet_AcceptUntrustedCertificates;

  end;

  [DNTypeName('OpenQA.Selenium.Chrome.ChromeDriver')]
  DNChromeDriver = interface(DNRemoteWebDriver)
  ['{AE584A42-0539-3061-AFDD-ECA6F38AB3EC}']
  { getters & setters } 

    function get_FileDetector: DNIFileDetector;
    procedure set_FileDetector(value: DNIFileDetector);
    function get_NetworkConditions: DNChromeNetworkConditions;
    procedure set_NetworkConditions(value: DNChromeNetworkConditions);
    function get_Url: string;
    procedure set_Url(value: string);
    function get_Title: string;
    function get_PageSource: string;
    function get_CurrentWindowHandle: string;
    function get_WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_Keyboard: DNIKeyboard;
    function get_Mouse: DNIMouse;
    function get_HasWebStorage: Boolean;
    function get_WebStorage: DNIWebStorage;
    function get_HasApplicationCache: Boolean;
    function get_ApplicationCache: DNIApplicationCache;
    function get_HasLocationContext: Boolean;
    function get_LocationContext: DNILocationContext;
    function get_Capabilities: DNICapabilities;
    function get_SessionId: DNSessionId;
    function get_IsActionExecutor: Boolean;

  { methods } 

    procedure ExecuteChromeCommand(commandName: string; commandParameters: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>);
    function ExecuteChromeCommandWithResult(commandName: string; commandParameters: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function FindElement(by: DNBy): DNIWebElement;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    procedure Close;
    procedure Quit;
    function Manage: DNIOptions;
    function Navigate: DNINavigation;
    function SwitchTo: DNITargetLocator;
    function ExecuteScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function ExecuteAsyncScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    procedure Dispose;
    procedure PerformActions(actionSequenceList: DDNC.System.Private.CoreLib.DNIList<DNActionSequence>);
    procedure ResetInputState;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FileDetector: DNIFileDetector read get_FileDetector write set_FileDetector;
    property NetworkConditions: DNChromeNetworkConditions read get_NetworkConditions write set_NetworkConditions;
    property Url: string read get_Url write set_Url;
    property Title: string read get_Title;
    property PageSource: string read get_PageSource;
    property CurrentWindowHandle: string read get_CurrentWindowHandle;
    property WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_WindowHandles;
    property Keyboard: DNIKeyboard read get_Keyboard;
    property Mouse: DNIMouse read get_Mouse;
    property HasWebStorage: Boolean read get_HasWebStorage;
    property WebStorage: DNIWebStorage read get_WebStorage;
    property HasApplicationCache: Boolean read get_HasApplicationCache;
    property ApplicationCache: DNIApplicationCache read get_ApplicationCache;
    property HasLocationContext: Boolean read get_HasLocationContext;
    property LocationContext: DNILocationContext read get_LocationContext;
    property Capabilities: DNICapabilities read get_Capabilities;
    property SessionId: DNSessionId read get_SessionId;
    property IsActionExecutor: Boolean read get_IsActionExecutor;
  end;

  TDNChromeDriver = class(TDNGenericImport<DNChromeDriverClass, DNChromeDriver>) end;

  //-------------namespace: OpenQA.Selenium.Edge----------------
  DNEdgeDriverClass = interface(DNRemoteWebDriverClass)
  ['{B6F507C2-9E67-5EB4-B3DD-4E992C92E699}']
  { constructors } 

    {class} function init: DNEdgeDriver; overload;
    {class} function init(options: DNEdgeOptions): DNEdgeDriver; overload;
    {class} function init(service: DNEdgeDriverService): DNEdgeDriver; overload;
    {class} function init(edgeDriverDirectory: string): DNEdgeDriver; overload;
    {class} function init(edgeDriverDirectory: string; options: DNEdgeOptions): DNEdgeDriver; overload;
    {class} function init(edgeDriverDirectory: string; options: DNEdgeOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNEdgeDriver; overload;
    {class} function init(service: DNEdgeDriverService; options: DNEdgeOptions): DNEdgeDriver; overload;
    {class} function init(service: DNEdgeDriverService; options: DNEdgeOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNEdgeDriver; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Edge.EdgeDriver')]
  DNEdgeDriver = interface(DNRemoteWebDriver)
  ['{E1DEE691-16A5-3741-A1F4-7DA41B5A225D}']
  { getters & setters } 

    function get_Url: string;
    procedure set_Url(value: string);
    function get_Title: string;
    function get_PageSource: string;
    function get_CurrentWindowHandle: string;
    function get_WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_Keyboard: DNIKeyboard;
    function get_Mouse: DNIMouse;
    function get_HasWebStorage: Boolean;
    function get_WebStorage: DNIWebStorage;
    function get_HasApplicationCache: Boolean;
    function get_ApplicationCache: DNIApplicationCache;
    function get_HasLocationContext: Boolean;
    function get_LocationContext: DNILocationContext;
    function get_Capabilities: DNICapabilities;
    function get_FileDetector: DNIFileDetector;
    procedure set_FileDetector(value: DNIFileDetector);
    function get_SessionId: DNSessionId;
    function get_IsActionExecutor: Boolean;

  { methods } 

    function FindElement(by: DNBy): DNIWebElement;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    procedure Close;
    procedure Quit;
    function Manage: DNIOptions;
    function Navigate: DNINavigation;
    function SwitchTo: DNITargetLocator;
    function ExecuteScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function ExecuteAsyncScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    procedure Dispose;
    procedure PerformActions(actionSequenceList: DDNC.System.Private.CoreLib.DNIList<DNActionSequence>);
    procedure ResetInputState;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Url: string read get_Url write set_Url;
    property Title: string read get_Title;
    property PageSource: string read get_PageSource;
    property CurrentWindowHandle: string read get_CurrentWindowHandle;
    property WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_WindowHandles;
    property Keyboard: DNIKeyboard read get_Keyboard;
    property Mouse: DNIMouse read get_Mouse;
    property HasWebStorage: Boolean read get_HasWebStorage;
    property WebStorage: DNIWebStorage read get_WebStorage;
    property HasApplicationCache: Boolean read get_HasApplicationCache;
    property ApplicationCache: DNIApplicationCache read get_ApplicationCache;
    property HasLocationContext: Boolean read get_HasLocationContext;
    property LocationContext: DNILocationContext read get_LocationContext;
    property Capabilities: DNICapabilities read get_Capabilities;
    property FileDetector: DNIFileDetector read get_FileDetector write set_FileDetector;
    property SessionId: DNSessionId read get_SessionId;
    property IsActionExecutor: Boolean read get_IsActionExecutor;
  end;

  TDNEdgeDriver = class(TDNGenericImport<DNEdgeDriverClass, DNEdgeDriver>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxDriverClass = interface(DNRemoteWebDriverClass)
  ['{0A033E7D-00E8-5742-BC44-F060AF7EDC0B}']
  { constructors } 

    {class} function init: DNFirefoxDriver; overload;
    {class} function init(options: DNFirefoxOptions): DNFirefoxDriver; overload;
    {class} function init(service: DNFirefoxDriverService): DNFirefoxDriver; overload;
    {class} function init(geckoDriverDirectory: string): DNFirefoxDriver; overload;
    {class} function init(geckoDriverDirectory: string; options: DNFirefoxOptions): DNFirefoxDriver; overload;
    {class} function init(geckoDriverDirectory: string; options: DNFirefoxOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNFirefoxDriver; overload;
    {class} function init(service: DNFirefoxDriverService; options: DNFirefoxOptions): DNFirefoxDriver; overload;
    {class} function init(service: DNFirefoxDriverService; options: DNFirefoxOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNFirefoxDriver; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_ProfileCapabilityName: string;
   function __fakeFieldGet_BinaryCapabilityName: string;
   function __fakeFieldGet_DefaultPort: Int32;
   function __fakeFieldGet_DefaultEnableNativeEvents: Boolean;
   function __fakeFieldGet_AcceptUntrustedCertificates: Boolean;
   function __fakeFieldGet_AssumeUntrustedCertificateIssuer: Boolean;

  { static fields } 

    {class} property ProfileCapabilityName: string read __fakeFieldGet_ProfileCapabilityName;
    {class} property BinaryCapabilityName: string read __fakeFieldGet_BinaryCapabilityName;
    {class} property DefaultPort: Int32 read __fakeFieldGet_DefaultPort;
    {class} property DefaultEnableNativeEvents: Boolean read __fakeFieldGet_DefaultEnableNativeEvents;
    {class} property AcceptUntrustedCertificates: Boolean read __fakeFieldGet_AcceptUntrustedCertificates;
    {class} property AssumeUntrustedCertificateIssuer: Boolean read __fakeFieldGet_AssumeUntrustedCertificateIssuer;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxDriver')]
  DNFirefoxDriver = interface(DNRemoteWebDriver)
  ['{E03CD2A2-6FA2-36AA-B7D8-216B72B4DD9E}']
  { getters & setters } 

    function get_FileDetector: DNIFileDetector;
    procedure set_FileDetector(value: DNIFileDetector);
    function get_IsMarionette: Boolean;
    function get_Url: string;
    procedure set_Url(value: string);
    function get_Title: string;
    function get_PageSource: string;
    function get_CurrentWindowHandle: string;
    function get_WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_Keyboard: DNIKeyboard;
    function get_Mouse: DNIMouse;
    function get_HasWebStorage: Boolean;
    function get_WebStorage: DNIWebStorage;
    function get_HasApplicationCache: Boolean;
    function get_ApplicationCache: DNIApplicationCache;
    function get_HasLocationContext: Boolean;
    function get_LocationContext: DNILocationContext;
    function get_Capabilities: DNICapabilities;
    function get_SessionId: DNSessionId;
    function get_IsActionExecutor: Boolean;

  { methods } 

    function FindElement(by: DNBy): DNIWebElement;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    procedure Close;
    procedure Quit;
    function Manage: DNIOptions;
    function Navigate: DNINavigation;
    function SwitchTo: DNITargetLocator;
    function ExecuteScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function ExecuteAsyncScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    procedure Dispose;
    procedure PerformActions(actionSequenceList: DDNC.System.Private.CoreLib.DNIList<DNActionSequence>);
    procedure ResetInputState;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FileDetector: DNIFileDetector read get_FileDetector write set_FileDetector;
    property IsMarionette: Boolean read get_IsMarionette;
    property Url: string read get_Url write set_Url;
    property Title: string read get_Title;
    property PageSource: string read get_PageSource;
    property CurrentWindowHandle: string read get_CurrentWindowHandle;
    property WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_WindowHandles;
    property Keyboard: DNIKeyboard read get_Keyboard;
    property Mouse: DNIMouse read get_Mouse;
    property HasWebStorage: Boolean read get_HasWebStorage;
    property WebStorage: DNIWebStorage read get_WebStorage;
    property HasApplicationCache: Boolean read get_HasApplicationCache;
    property ApplicationCache: DNIApplicationCache read get_ApplicationCache;
    property HasLocationContext: Boolean read get_HasLocationContext;
    property LocationContext: DNILocationContext read get_LocationContext;
    property Capabilities: DNICapabilities read get_Capabilities;
    property SessionId: DNSessionId read get_SessionId;
    property IsActionExecutor: Boolean read get_IsActionExecutor;
  end;

  TDNFirefoxDriver = class(TDNGenericImport<DNFirefoxDriverClass, DNFirefoxDriver>) end;

  //-------------namespace: OpenQA.Selenium.IE----------------
  DNInternetExplorerDriverClass = interface(DNRemoteWebDriverClass)
  ['{AE870FBC-B069-57CE-A639-9B62120F4CF1}']
  { constructors } 

    {class} function init: DNInternetExplorerDriver; overload;
    {class} function init(options: DNInternetExplorerOptions): DNInternetExplorerDriver; overload;
    {class} function init(service: DNInternetExplorerDriverService): DNInternetExplorerDriver; overload;
    {class} function init(internetExplorerDriverServerDirectory: string): DNInternetExplorerDriver; overload;
    {class} function init(internetExplorerDriverServerDirectory: string; options: DNInternetExplorerOptions): DNInternetExplorerDriver; overload;
    {class} function init(internetExplorerDriverServerDirectory: string; options: DNInternetExplorerOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNInternetExplorerDriver; overload;
    {class} function init(service: DNInternetExplorerDriverService; options: DNInternetExplorerOptions): DNInternetExplorerDriver; overload;
    {class} function init(service: DNInternetExplorerDriverService; options: DNInternetExplorerOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNInternetExplorerDriver; overload;

  end;

  [DNTypeName('OpenQA.Selenium.IE.InternetExplorerDriver')]
  DNInternetExplorerDriver = interface(DNRemoteWebDriver)
  ['{ACF1D9A4-8598-3B01-A11B-23A2C6832442}']
  { getters & setters } 

    function get_FileDetector: DNIFileDetector;
    procedure set_FileDetector(value: DNIFileDetector);
    function get_Url: string;
    procedure set_Url(value: string);
    function get_Title: string;
    function get_PageSource: string;
    function get_CurrentWindowHandle: string;
    function get_WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_Keyboard: DNIKeyboard;
    function get_Mouse: DNIMouse;
    function get_HasWebStorage: Boolean;
    function get_WebStorage: DNIWebStorage;
    function get_HasApplicationCache: Boolean;
    function get_ApplicationCache: DNIApplicationCache;
    function get_HasLocationContext: Boolean;
    function get_LocationContext: DNILocationContext;
    function get_Capabilities: DNICapabilities;
    function get_SessionId: DNSessionId;
    function get_IsActionExecutor: Boolean;

  { methods } 

    function FindElement(by: DNBy): DNIWebElement;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    procedure Close;
    procedure Quit;
    function Manage: DNIOptions;
    function Navigate: DNINavigation;
    function SwitchTo: DNITargetLocator;
    function ExecuteScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function ExecuteAsyncScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    procedure Dispose;
    procedure PerformActions(actionSequenceList: DDNC.System.Private.CoreLib.DNIList<DNActionSequence>);
    procedure ResetInputState;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FileDetector: DNIFileDetector read get_FileDetector write set_FileDetector;
    property Url: string read get_Url write set_Url;
    property Title: string read get_Title;
    property PageSource: string read get_PageSource;
    property CurrentWindowHandle: string read get_CurrentWindowHandle;
    property WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_WindowHandles;
    property Keyboard: DNIKeyboard read get_Keyboard;
    property Mouse: DNIMouse read get_Mouse;
    property HasWebStorage: Boolean read get_HasWebStorage;
    property WebStorage: DNIWebStorage read get_WebStorage;
    property HasApplicationCache: Boolean read get_HasApplicationCache;
    property ApplicationCache: DNIApplicationCache read get_ApplicationCache;
    property HasLocationContext: Boolean read get_HasLocationContext;
    property LocationContext: DNILocationContext read get_LocationContext;
    property Capabilities: DNICapabilities read get_Capabilities;
    property SessionId: DNSessionId read get_SessionId;
    property IsActionExecutor: Boolean read get_IsActionExecutor;
  end;

  TDNInternetExplorerDriver = class(TDNGenericImport<DNInternetExplorerDriverClass, DNInternetExplorerDriver>) end;

  //-------------namespace: OpenQA.Selenium.Opera----------------
  DNOperaDriverClass = interface(DNRemoteWebDriverClass)
  ['{6596BE24-686D-5FBD-96A2-5392890F7D0D}']
  { constructors } 

    {class} function init: DNOperaDriver; overload;
    {class} function init(options: DNOperaOptions): DNOperaDriver; overload;
    {class} function init(operaDriverDirectory: string): DNOperaDriver; overload;
    {class} function init(operaDriverDirectory: string; options: DNOperaOptions): DNOperaDriver; overload;
    {class} function init(operaDriverDirectory: string; options: DNOperaOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNOperaDriver; overload;
    {class} function init(service: DNOperaDriverService; options: DNOperaOptions): DNOperaDriver; overload;
    {class} function init(service: DNOperaDriverService; options: DNOperaOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNOperaDriver; overload;

  { static fields getter & setter } 

   function __fakeFieldGet_AcceptUntrustedCertificates: Boolean;

  { static fields } 

    {class} property AcceptUntrustedCertificates: Boolean read __fakeFieldGet_AcceptUntrustedCertificates;

  end;

  [DNTypeName('OpenQA.Selenium.Opera.OperaDriver')]
  DNOperaDriver = interface(DNRemoteWebDriver)
  ['{6EC08E3D-A4B1-32A0-909E-0DF5BE3CE2D8}']
  { getters & setters } 

    function get_FileDetector: DNIFileDetector;
    procedure set_FileDetector(value: DNIFileDetector);
    function get_Url: string;
    procedure set_Url(value: string);
    function get_Title: string;
    function get_PageSource: string;
    function get_CurrentWindowHandle: string;
    function get_WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_Keyboard: DNIKeyboard;
    function get_Mouse: DNIMouse;
    function get_HasWebStorage: Boolean;
    function get_WebStorage: DNIWebStorage;
    function get_HasApplicationCache: Boolean;
    function get_ApplicationCache: DNIApplicationCache;
    function get_HasLocationContext: Boolean;
    function get_LocationContext: DNILocationContext;
    function get_Capabilities: DNICapabilities;
    function get_SessionId: DNSessionId;
    function get_IsActionExecutor: Boolean;

  { methods } 

    function FindElement(by: DNBy): DNIWebElement;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    procedure Close;
    procedure Quit;
    function Manage: DNIOptions;
    function Navigate: DNINavigation;
    function SwitchTo: DNITargetLocator;
    function ExecuteScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function ExecuteAsyncScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    procedure Dispose;
    procedure PerformActions(actionSequenceList: DDNC.System.Private.CoreLib.DNIList<DNActionSequence>);
    procedure ResetInputState;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FileDetector: DNIFileDetector read get_FileDetector write set_FileDetector;
    property Url: string read get_Url write set_Url;
    property Title: string read get_Title;
    property PageSource: string read get_PageSource;
    property CurrentWindowHandle: string read get_CurrentWindowHandle;
    property WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_WindowHandles;
    property Keyboard: DNIKeyboard read get_Keyboard;
    property Mouse: DNIMouse read get_Mouse;
    property HasWebStorage: Boolean read get_HasWebStorage;
    property WebStorage: DNIWebStorage read get_WebStorage;
    property HasApplicationCache: Boolean read get_HasApplicationCache;
    property ApplicationCache: DNIApplicationCache read get_ApplicationCache;
    property HasLocationContext: Boolean read get_HasLocationContext;
    property LocationContext: DNILocationContext read get_LocationContext;
    property Capabilities: DNICapabilities read get_Capabilities;
    property SessionId: DNSessionId read get_SessionId;
    property IsActionExecutor: Boolean read get_IsActionExecutor;
  end;

  TDNOperaDriver = class(TDNGenericImport<DNOperaDriverClass, DNOperaDriver>) end;

  //-------------namespace: OpenQA.Selenium.Safari----------------
  DNSafariDriverClass = interface(DNRemoteWebDriverClass)
  ['{983386D9-5DC0-5E81-9C0C-F175AB942A7C}']
  { constructors } 

    {class} function init: DNSafariDriver; overload;
    {class} function init(options: DNSafariOptions): DNSafariDriver; overload;
    {class} function init(service: DNSafariDriverService): DNSafariDriver; overload;
    {class} function init(safariDriverDirectory: string): DNSafariDriver; overload;
    {class} function init(safariDriverDirectory: string; options: DNSafariOptions): DNSafariDriver; overload;
    {class} function init(safariDriverDirectory: string; options: DNSafariOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNSafariDriver; overload;
    {class} function init(service: DNSafariDriverService; options: DNSafariOptions): DNSafariDriver; overload;
    {class} function init(service: DNSafariDriverService; options: DNSafariOptions; commandTimeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNSafariDriver; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Safari.SafariDriver')]
  DNSafariDriver = interface(DNRemoteWebDriver)
  ['{7B139527-88B7-3A0A-8ACB-6BC9AC71B4FD}']
  { getters & setters } 

    function get_FileDetector: DNIFileDetector;
    procedure set_FileDetector(value: DNIFileDetector);
    function get_Url: string;
    procedure set_Url(value: string);
    function get_Title: string;
    function get_PageSource: string;
    function get_CurrentWindowHandle: string;
    function get_WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string>;
    function get_Keyboard: DNIKeyboard;
    function get_Mouse: DNIMouse;
    function get_HasWebStorage: Boolean;
    function get_WebStorage: DNIWebStorage;
    function get_HasApplicationCache: Boolean;
    function get_ApplicationCache: DNIApplicationCache;
    function get_HasLocationContext: Boolean;
    function get_LocationContext: DNILocationContext;
    function get_Capabilities: DNICapabilities;
    function get_SessionId: DNSessionId;
    function get_IsActionExecutor: Boolean;

  { methods } 

    function FindElement(by: DNBy): DNIWebElement;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    procedure Close;
    procedure Quit;
    function Manage: DNIOptions;
    function Navigate: DNINavigation;
    function SwitchTo: DNITargetLocator;
    function ExecuteScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function ExecuteAsyncScript(script: string; args: TArray<DDNC.System.Private.CoreLib.DNObject>): DDNC.System.Private.CoreLib.DNObject;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    procedure Dispose;
    procedure PerformActions(actionSequenceList: DDNC.System.Private.CoreLib.DNIList<DNActionSequence>);
    procedure ResetInputState;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FileDetector: DNIFileDetector read get_FileDetector write set_FileDetector;
    property Url: string read get_Url write set_Url;
    property Title: string read get_Title;
    property PageSource: string read get_PageSource;
    property CurrentWindowHandle: string read get_CurrentWindowHandle;
    property WindowHandles: DDNC.System.Private.CoreLib.DNReadOnlyCollection<string> read get_WindowHandles;
    property Keyboard: DNIKeyboard read get_Keyboard;
    property Mouse: DNIMouse read get_Mouse;
    property HasWebStorage: Boolean read get_HasWebStorage;
    property WebStorage: DNIWebStorage read get_WebStorage;
    property HasApplicationCache: Boolean read get_HasApplicationCache;
    property ApplicationCache: DNIApplicationCache read get_ApplicationCache;
    property HasLocationContext: Boolean read get_HasLocationContext;
    property LocationContext: DNILocationContext read get_LocationContext;
    property Capabilities: DNICapabilities read get_Capabilities;
    property SessionId: DNSessionId read get_SessionId;
    property IsActionExecutor: Boolean read get_IsActionExecutor;
  end;

  TDNSafariDriver = class(TDNGenericImport<DNSafariDriverClass, DNSafariDriver>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteWebElementClass = interface(DNObjectClass)
  ['{5AF29656-9C23-5BAB-AAE5-DA469EC3D27F}']
  { constructors } 

    {class} function init(parentDriver: DNRemoteWebDriver; id: string): DNRemoteWebElement;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteWebElement')]
  DNRemoteWebElement = interface(DNIWebElement)
  ['{DF3AF6A6-3DC0-3762-BE16-6722FDC1B16A}']
  { getters & setters } 

    function get_WrappedDriver: DNIWebDriver;
    function get_TagName: string;
    function get_Text: string;
    function get_Enabled: Boolean;
    function get_Selected: Boolean;
    function get_Location: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Size: DDNC.System.Drawing.Primitives.DNSize;
    function get_Displayed: Boolean;
    function get_LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Coordinates: DNICoordinates;

  { methods } 

    procedure Clear;
    procedure SendKeys(text: string);
    procedure Submit;
    procedure Click;
    function GetAttribute(attributeName: string): string;
    function GetProperty(propertyName: string): string;
    function GetCssValue(propertyName: string): string;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElement(by: DNBy): DNIWebElement;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    function ToString: string;
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property WrappedDriver: DNIWebDriver read get_WrappedDriver;
    property TagName: string read get_TagName;
    property Text: string read get_Text;
    property Enabled: Boolean read get_Enabled;
    property Selected: Boolean read get_Selected;
    property Location: DDNC.System.Drawing.Primitives.DNPoint read get_Location;
    property Size: DDNC.System.Drawing.Primitives.DNSize read get_Size;
    property Displayed: Boolean read get_Displayed;
    property LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint read get_LocationOnScreenOnceScrolledIntoView;
    property Coordinates: DNICoordinates read get_Coordinates;
  end;

  TDNRemoteWebElement = class(TDNGenericImport<DNRemoteWebElementClass, DNRemoteWebElement>)
  public const
   ElementReferencePropertyName = 'element-6066-11e4-a52e-4f735466cecf';
   LegacyElementReferencePropertyName = 'ELEMENT';
  end;

  //-------------namespace: OpenQA.Selenium.Chrome----------------
  DNChromeWebElementClass = interface(DNRemoteWebElementClass)
  ['{C2A2CBD1-C973-5320-BA00-8FAC6684B23C}']
  { constructors } 

    {class} function init(parent: DNChromeDriver; elementId: string): DNChromeWebElement;

  end;

  [DNTypeName('OpenQA.Selenium.Chrome.ChromeWebElement')]
  DNChromeWebElement = interface(DNRemoteWebElement)
  ['{EC23EBE3-D002-302A-BBF5-E728C079F1F8}']
  { getters & setters } 

    function get_WrappedDriver: DNIWebDriver;
    function get_TagName: string;
    function get_Text: string;
    function get_Enabled: Boolean;
    function get_Selected: Boolean;
    function get_Location: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Size: DDNC.System.Drawing.Primitives.DNSize;
    function get_Displayed: Boolean;
    function get_LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Coordinates: DNICoordinates;

  { methods } 

    procedure Clear;
    procedure SendKeys(text: string);
    procedure Submit;
    procedure Click;
    function GetAttribute(attributeName: string): string;
    function GetProperty(propertyName: string): string;
    function GetCssValue(propertyName: string): string;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElement(by: DNBy): DNIWebElement;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    function ToString: string;
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property WrappedDriver: DNIWebDriver read get_WrappedDriver;
    property TagName: string read get_TagName;
    property Text: string read get_Text;
    property Enabled: Boolean read get_Enabled;
    property Selected: Boolean read get_Selected;
    property Location: DDNC.System.Drawing.Primitives.DNPoint read get_Location;
    property Size: DDNC.System.Drawing.Primitives.DNSize read get_Size;
    property Displayed: Boolean read get_Displayed;
    property LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint read get_LocationOnScreenOnceScrolledIntoView;
    property Coordinates: DNICoordinates read get_Coordinates;
  end;

  TDNChromeWebElement = class(TDNGenericImport<DNChromeWebElementClass, DNChromeWebElement>) end;

  //-------------namespace: OpenQA.Selenium.Edge----------------
  DNEdgeWebElementClass = interface(DNRemoteWebElementClass)
  ['{9D650D50-600D-5DB9-8BAE-840B192E769E}']
  { constructors } 

    {class} function init(parent: DNEdgeDriver; elementId: string): DNEdgeWebElement;

  end;

  [DNTypeName('OpenQA.Selenium.Edge.EdgeWebElement')]
  DNEdgeWebElement = interface(DNRemoteWebElement)
  ['{F26B291C-F033-384D-B67C-EC8B2DBBE34E}']
  { getters & setters } 

    function get_WrappedDriver: DNIWebDriver;
    function get_TagName: string;
    function get_Text: string;
    function get_Enabled: Boolean;
    function get_Selected: Boolean;
    function get_Location: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Size: DDNC.System.Drawing.Primitives.DNSize;
    function get_Displayed: Boolean;
    function get_LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Coordinates: DNICoordinates;

  { methods } 

    procedure Clear;
    procedure SendKeys(text: string);
    procedure Submit;
    procedure Click;
    function GetAttribute(attributeName: string): string;
    function GetProperty(propertyName: string): string;
    function GetCssValue(propertyName: string): string;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElement(by: DNBy): DNIWebElement;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    function ToString: string;
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property WrappedDriver: DNIWebDriver read get_WrappedDriver;
    property TagName: string read get_TagName;
    property Text: string read get_Text;
    property Enabled: Boolean read get_Enabled;
    property Selected: Boolean read get_Selected;
    property Location: DDNC.System.Drawing.Primitives.DNPoint read get_Location;
    property Size: DDNC.System.Drawing.Primitives.DNSize read get_Size;
    property Displayed: Boolean read get_Displayed;
    property LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint read get_LocationOnScreenOnceScrolledIntoView;
    property Coordinates: DNICoordinates read get_Coordinates;
  end;

  TDNEdgeWebElement = class(TDNGenericImport<DNEdgeWebElementClass, DNEdgeWebElement>) end;

  //-------------namespace: OpenQA.Selenium.Firefox----------------
  DNFirefoxWebElementClass = interface(DNRemoteWebElementClass)
  ['{27EC20E4-301B-5F76-8B59-5962797B19F7}']
  { constructors } 

    {class} function init(parentDriver: DNFirefoxDriver; id: string): DNFirefoxWebElement;

  end;

  [DNTypeName('OpenQA.Selenium.Firefox.FirefoxWebElement')]
  DNFirefoxWebElement = interface(DNRemoteWebElement)
  ['{C27D1392-9EEB-30AD-91B8-47F74BAF2448}']
  { getters & setters } 

    function get_WrappedDriver: DNIWebDriver;
    function get_TagName: string;
    function get_Text: string;
    function get_Enabled: Boolean;
    function get_Selected: Boolean;
    function get_Location: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Size: DDNC.System.Drawing.Primitives.DNSize;
    function get_Displayed: Boolean;
    function get_LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Coordinates: DNICoordinates;

  { methods } 

    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    procedure Clear;
    procedure SendKeys(text: string);
    procedure Submit;
    procedure Click;
    function GetAttribute(attributeName: string): string;
    function GetProperty(propertyName: string): string;
    function GetCssValue(propertyName: string): string;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElement(by: DNBy): DNIWebElement;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property WrappedDriver: DNIWebDriver read get_WrappedDriver;
    property TagName: string read get_TagName;
    property Text: string read get_Text;
    property Enabled: Boolean read get_Enabled;
    property Selected: Boolean read get_Selected;
    property Location: DDNC.System.Drawing.Primitives.DNPoint read get_Location;
    property Size: DDNC.System.Drawing.Primitives.DNSize read get_Size;
    property Displayed: Boolean read get_Displayed;
    property LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint read get_LocationOnScreenOnceScrolledIntoView;
    property Coordinates: DNICoordinates read get_Coordinates;
  end;

  TDNFirefoxWebElement = class(TDNGenericImport<DNFirefoxWebElementClass, DNFirefoxWebElement>) end;

  //-------------namespace: OpenQA.Selenium.IE----------------
  DNInternetExplorerWebElementClass = interface(DNRemoteWebElementClass)
  ['{C5F2D625-2C75-52B1-8B55-FFBF1BDA8991}']
  { constructors } 

    {class} function init(parent: DNInternetExplorerDriver; id: string): DNInternetExplorerWebElement;

  end;

  [DNTypeName('OpenQA.Selenium.IE.InternetExplorerWebElement')]
  DNInternetExplorerWebElement = interface(DNRemoteWebElement)
  ['{02895E5F-5795-30EF-8304-EA50915E39FE}']
  { getters & setters } 

    function get_WrappedDriver: DNIWebDriver;
    function get_TagName: string;
    function get_Text: string;
    function get_Enabled: Boolean;
    function get_Selected: Boolean;
    function get_Location: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Size: DDNC.System.Drawing.Primitives.DNSize;
    function get_Displayed: Boolean;
    function get_LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Coordinates: DNICoordinates;

  { methods } 

    procedure Clear;
    procedure SendKeys(text: string);
    procedure Submit;
    procedure Click;
    function GetAttribute(attributeName: string): string;
    function GetProperty(propertyName: string): string;
    function GetCssValue(propertyName: string): string;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElement(by: DNBy): DNIWebElement;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    function ToString: string;
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property WrappedDriver: DNIWebDriver read get_WrappedDriver;
    property TagName: string read get_TagName;
    property Text: string read get_Text;
    property Enabled: Boolean read get_Enabled;
    property Selected: Boolean read get_Selected;
    property Location: DDNC.System.Drawing.Primitives.DNPoint read get_Location;
    property Size: DDNC.System.Drawing.Primitives.DNSize read get_Size;
    property Displayed: Boolean read get_Displayed;
    property LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint read get_LocationOnScreenOnceScrolledIntoView;
    property Coordinates: DNICoordinates read get_Coordinates;
  end;

  TDNInternetExplorerWebElement = class(TDNGenericImport<DNInternetExplorerWebElementClass, DNInternetExplorerWebElement>) end;

  //-------------namespace: OpenQA.Selenium.Opera----------------
  DNOperaWebElementClass = interface(DNRemoteWebElementClass)
  ['{C3C8D02C-7F0D-5F19-A2CA-E146235AD661}']
  { constructors } 

    {class} function init(parent: DNOperaDriver; elementId: string): DNOperaWebElement;

  end;

  [DNTypeName('OpenQA.Selenium.Opera.OperaWebElement')]
  DNOperaWebElement = interface(DNRemoteWebElement)
  ['{DD7EF236-B3C7-3487-A4DD-A61948F7E00F}']
  { getters & setters } 

    function get_WrappedDriver: DNIWebDriver;
    function get_TagName: string;
    function get_Text: string;
    function get_Enabled: Boolean;
    function get_Selected: Boolean;
    function get_Location: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Size: DDNC.System.Drawing.Primitives.DNSize;
    function get_Displayed: Boolean;
    function get_LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint;
    function get_Coordinates: DNICoordinates;

  { methods } 

    procedure Clear;
    procedure SendKeys(text: string);
    procedure Submit;
    procedure Click;
    function GetAttribute(attributeName: string): string;
    function GetProperty(propertyName: string): string;
    function GetCssValue(propertyName: string): string;
    function FindElements(by: DNBy): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElement(by: DNBy): DNIWebElement;
    function FindElementByLinkText(linkText: string): DNIWebElement;
    function FindElementsByLinkText(linkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementById(id: string): DNIWebElement;
    function FindElementsById(id: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByName(name: string): DNIWebElement;
    function FindElementsByName(name: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByTagName(tagName: string): DNIWebElement;
    function FindElementsByTagName(tagName: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByClassName(className: string): DNIWebElement;
    function FindElementsByClassName(className: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByXPath(xpath: string): DNIWebElement;
    function FindElementsByXPath(xpath: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByPartialLinkText(partialLinkText: string): DNIWebElement;
    function FindElementsByPartialLinkText(partialLinkText: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function FindElementByCssSelector(cssSelector: string): DNIWebElement;
    function FindElementsByCssSelector(cssSelector: string): DDNC.System.Private.CoreLib.DNReadOnlyCollection<DNIWebElement>;
    function GetScreenshot: DNScreenshot;
    function ToString: string;
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property WrappedDriver: DNIWebDriver read get_WrappedDriver;
    property TagName: string read get_TagName;
    property Text: string read get_Text;
    property Enabled: Boolean read get_Enabled;
    property Selected: Boolean read get_Selected;
    property Location: DDNC.System.Drawing.Primitives.DNPoint read get_Location;
    property Size: DDNC.System.Drawing.Primitives.DNSize read get_Size;
    property Displayed: Boolean read get_Displayed;
    property LocationOnScreenOnceScrolledIntoView: DDNC.System.Drawing.Primitives.DNPoint read get_LocationOnScreenOnceScrolledIntoView;
    property Coordinates: DNICoordinates read get_Coordinates;
  end;

  TDNOperaWebElement = class(TDNGenericImport<DNOperaWebElementClass, DNOperaWebElement>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteWebElementFactoryClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{F562FF02-A830-5E33-AE63-969E71083693}']
  { constructors } 

    {class} function init(parentDriver: DNRemoteWebDriver): DNRemoteWebElementFactory;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteWebElementFactory')]
  DNRemoteWebElementFactory = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{F4345AEB-74E6-37EB-9F0A-B7597E1539DD}']
  { methods } 

    function CreateElement(elementDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): DNRemoteWebElement;
    function ContainsElementReference(elementDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): Boolean;
    function GetElementId(elementDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): string;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRemoteWebElementFactory = class(TDNGenericImport<DNRemoteWebElementFactoryClass, DNRemoteWebElementFactory>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNRemoteWebStorageClass = interface(DNObjectClass)
  ['{A57B3112-2DC2-52B3-924A-22801D88D04B}']
  { constructors } 

    {class} function init(driver: DNRemoteWebDriver): DNRemoteWebStorage;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.RemoteWebStorage')]
  DNRemoteWebStorage = interface(DNIWebStorage)
  ['{533BC7ED-9F0A-31CA-94D7-D41F62B3938B}']
  { getters & setters } 

    function get_LocalStorage: DNILocalStorage;
    function get_SessionStorage: DNISessionStorage;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property LocalStorage: DNILocalStorage read get_LocalStorage;
    property SessionStorage: DNISessionStorage read get_SessionStorage;
  end;

  TDNRemoteWebStorage = class(TDNGenericImport<DNRemoteWebStorageClass, DNRemoteWebStorage>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNResponseClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{D6DACC2E-941B-5518-A6EF-0832BB6647EB}']
  { constructors } 

    {class} function init: DNResponse; overload;
    {class} function init(sessionId: DNSessionId): DNResponse; overload;

  { static methods } 

    {class} function FromJson(value: string): DNResponse;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.Response')]
  DNResponse = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{B0A7609D-2323-335A-AEA5-F413C06509CC}']
  { getters & setters } 

    function get_Value: DDNC.System.Private.CoreLib.DNObject;
    procedure set_Value(value: DDNC.System.Private.CoreLib.DNObject);
    function get_SessionId: string;
    procedure set_SessionId(value: string);
    function get_Status: DNWebDriverResult;
    procedure set_Status(value: DNWebDriverResult);
    function get_IsSpecificationCompliant: Boolean;

  { methods } 

    function ToJson: string;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Value: DDNC.System.Private.CoreLib.DNObject read get_Value write set_Value;
    property SessionId: string read get_SessionId write set_SessionId;
    property Status: DNWebDriverResult read get_Status write set_Status;
    property IsSpecificationCompliant: Boolean read get_IsSpecificationCompliant;
  end;

  TDNResponse = class(TDNGenericImport<DNResponseClass, DNResponse>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNSessionIdClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{200012FA-CBF1-5A5B-9019-92651D4511B6}']
  { constructors } 

    {class} function init(opaqueKey: string): DNSessionId;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.SessionId')]
  DNSessionId = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{698808D7-CC50-3165-969F-E79CBB28D654}']
  { methods } 

    function ToString: string;
    function GetHashCode: Int32;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNSessionId = class(TDNGenericImport<DNSessionIdClass, DNSessionId>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNStackTraceElementClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{0E716A24-BB8D-57A0-A115-5382C352BC28}']
  { constructors } 

    {class} function init: DNStackTraceElement; overload;
    {class} function init(elementAttributes: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>): DNStackTraceElement; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.StackTraceElement')]
  DNStackTraceElement = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{55FE477F-FB8C-30B0-BC32-FE0950B34246}']
  { getters & setters } 

    function get_FileName: string;
    procedure set_FileName(value: string);
    function get_ClassName: string;
    procedure set_ClassName(value: string);
    function get_LineNumber: Int32;
    procedure set_LineNumber(value: Int32);
    function get_MethodName: string;
    procedure set_MethodName(value: string);

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property FileName: string read get_FileName write set_FileName;
    property ClassName: string read get_ClassName write set_ClassName;
    property LineNumber: Int32 read get_LineNumber write set_LineNumber;
    property MethodName: string read get_MethodName write set_MethodName;
  end;

  TDNStackTraceElement = class(TDNGenericImport<DNStackTraceElementClass, DNStackTraceElement>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNRemoteSessionSettingsClass = interface(DNObjectClass)
  ['{834A1CB5-CFD5-5C94-A1E7-71E30D0D58DA}']
  { constructors } 

    {class} function init: DNRemoteSessionSettings; overload;
    {class} function init(mustMatchDriverOptions: DNDriverOptions; firstMatchDriverOptions: TArray<DNDriverOptions>): DNRemoteSessionSettings; overload;

  end;

  [DNTypeName('OpenQA.Selenium.RemoteSessionSettings')]
  DNRemoteSessionSettings = interface(DNICapabilities)
  ['{78CD8FF5-A450-3E4B-9EC4-661E3EE61237}']
  { methods } 

    procedure AddMetadataSetting(settingName: string; settingValue: DDNC.System.Private.CoreLib.DNObject);
    procedure AddFirstMatchDriverOption(options: DNDriverOptions);
    procedure SetMustMatchDriverOptions(options: DNDriverOptions);
    function HasCapability(capability: string): Boolean;
    function GetCapability(capability: string): DDNC.System.Private.CoreLib.DNObject;
    function ToDictionary: DDNC.System.Private.CoreLib.DNDictionary<string, DDNC.System.Private.CoreLib.DNObject>;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  end;

  TDNRemoteSessionSettings = class(TDNGenericImport<DNRemoteSessionSettingsClass, DNRemoteSessionSettings>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNScreenshotClass = interface(DDNC.System.Private.CoreLib.DNObjectClass)
  ['{8CC5B8B2-4E3C-5695-8160-17FEA65181F1}']
  { constructors } 

    {class} function init(base64EncodedScreenshot: string): DNScreenshot;

  end;

  [DNTypeName('OpenQA.Selenium.Screenshot')]
  DNScreenshot = interface(DDNC.System.Private.CoreLib.DNObject)
  ['{E45B4877-EE00-3CE2-AA2A-78D3A4D9CD06}']
  { getters & setters } 

    function get_AsBase64EncodedString: string;
    function get_AsByteArray: TArray<Byte>;

  { methods } 

    procedure SaveAsFile(fileName: string); overload;
    procedure SaveAsFile(fileName: string; format: DNScreenshotImageFormat); overload;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property AsBase64EncodedString: string read get_AsBase64EncodedString;
    property AsByteArray: TArray<Byte> read get_AsByteArray;
  end;

  TDNScreenshot = class(TDNGenericImport<DNScreenshotClass, DNScreenshot>) end;

  //-------------namespace: OpenQA.Selenium.Support.UI----------------
  DNWebDriverWaitClass = interface(DNObjectClass)
  ['{CD0ED098-9883-5F97-A489-386D62DB0F08}']
  { constructors } 

    {class} function init(driver: DNIWebDriver; timeout: DDNC.System.Private.CoreLib.DNTimeSpan): DNWebDriverWait; overload;
    {class} function init(clock: DNIClock; driver: DNIWebDriver; timeout: DDNC.System.Private.CoreLib.DNTimeSpan; sleepInterval: DDNC.System.Private.CoreLib.DNTimeSpan): DNWebDriverWait; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Support.UI.WebDriverWait')]
  DNWebDriverWait = interface(DNObject)
  ['{57CABC09-6B1F-32D5-8848-176649740BEE}']
  { getters & setters } 

    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_PollingInterval: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PollingInterval(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_Message: string;
    procedure set_Message(value: string);

  { methods } 

    procedure IgnoreExceptionTypes(exceptionTypes: TArray<DDNC.System.Private.CoreLib.DNType>);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
    property PollingInterval: DDNC.System.Private.CoreLib.DNTimeSpan read get_PollingInterval write set_PollingInterval;
    property Message: string read get_Message write set_Message;
  end;

  TDNWebDriverWait = class(TDNGenericImport<DNWebDriverWaitClass, DNWebDriverWait>) end;

  //-------------namespace: OpenQA.Selenium.Support.UI----------------
  DNDefaultWaitClass<T> = interface(DNObjectClass)
  ['{304445AB-FE30-576C-BD8B-FB36D542CB0D}']
  { constructors } 

    {class} function init(input: T): DNDefaultWait<T>; overload;
    {class} function init(input: T; clock: DNIClock): DNDefaultWait<T>; overload;

  end;

  [DNTypeName('OpenQA.Selenium.Support.UI.DefaultWait`1')]
  DNDefaultWait<T> = interface(DNIWait<T>)
  ['{F85F8A86-646F-32A3-8631-51577E4054CC}']
  { getters & setters } 

    function get_Timeout: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_Timeout(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_PollingInterval: DDNC.System.Private.CoreLib.DNTimeSpan;
    procedure set_PollingInterval(value: DDNC.System.Private.CoreLib.DNTimeSpan);
    function get_Message: string;
    procedure set_Message(value: string);

  { methods } 

    procedure IgnoreExceptionTypes(exceptionTypes: TArray<DDNC.System.Private.CoreLib.DNType>);
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Timeout: DDNC.System.Private.CoreLib.DNTimeSpan read get_Timeout write set_Timeout;
    property PollingInterval: DDNC.System.Private.CoreLib.DNTimeSpan read get_PollingInterval write set_PollingInterval;
    property Message: string read get_Message write set_Message;
  end;

  TDNDefaultWait<T> = class(TDNGenericImport<DNDefaultWaitClass<T>, DNDefaultWait<T>>) end;

  //-------------namespace: OpenQA.Selenium.Support.UI----------------
  DNSystemClockClass = interface(DNObjectClass)
  ['{D4FF5627-F1E1-5177-87F8-4918621E74F6}']
  { constructors } 

    {class} function init: DNSystemClock;

  end;

  [DNTypeName('OpenQA.Selenium.Support.UI.SystemClock')]
  DNSystemClock = interface(DNIClock)
  ['{1284CDE3-4622-32F8-92EC-C425F6796BEB}']
  { getters & setters } 

    function get_Now: DDNC.System.Private.CoreLib.DNDateTime;

  { methods } 

    function LaterBy(delay: DDNC.System.Private.CoreLib.DNTimeSpan): DDNC.System.Private.CoreLib.DNDateTime;
    function IsNowBefore(otherDateTime: DDNC.System.Private.CoreLib.DNDateTime): Boolean;
    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Now: DDNC.System.Private.CoreLib.DNDateTime read get_Now;
  end;

  TDNSystemClock = class(TDNGenericImport<DNSystemClockClass, DNSystemClock>) end;

  //-------------namespace: OpenQA.Selenium.Remote----------------
  DNSendingRemoteHttpRequestEventArgsClass = interface(DDNC.System.Private.CoreLib.DNEventArgsClass)
  ['{798A754C-81B6-52C0-91E5-9B02D68B939F}']
  { constructors } 

    {class} function init(request: DDNC.System.Net.Requests.DNHttpWebRequest; requestBody: string): DNSendingRemoteHttpRequestEventArgs;

  end;

  [DNTypeName('OpenQA.Selenium.Remote.SendingRemoteHttpRequestEventArgs')]
  DNSendingRemoteHttpRequestEventArgs = interface(DDNC.System.Private.CoreLib.DNEventArgs)
  ['{0DB18118-08B5-3440-B1EF-1BA0C3E5DC15}']
  { getters & setters } 

    function get_Request: DDNC.System.Net.Requests.DNHttpWebRequest;
    function get_RequestBody: string;

  { methods } 

    function ToString: string;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;
    function GetType: DDNC.System.Private.CoreLib.DNType;

  { propertys } 

    property Request: DDNC.System.Net.Requests.DNHttpWebRequest read get_Request;
    property RequestBody: string read get_RequestBody;
  end;

  TDNSendingRemoteHttpRequestEventArgs = class(TDNGenericImport<DNSendingRemoteHttpRequestEventArgsClass, DNSendingRemoteHttpRequestEventArgs>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNWebDriverExceptionClass = interface(DDNC.System.Private.CoreLib.DNExceptionClass)
  ['{9E458E85-739A-59A5-B1A0-B51EE4432EE0}']
  { constructors } 

    {class} function init: DNWebDriverException; overload;
    {class} function init(message: string): DNWebDriverException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNWebDriverException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.WebDriverException')]
  DNWebDriverException = interface(DDNC.System.Private.CoreLib.DNException)
  ['{4149734F-5F66-34EB-B655-D826C6B33673}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNWebDriverException = class(TDNGenericImport<DNWebDriverExceptionClass, DNWebDriverException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNDriverServiceNotFoundExceptionClass = interface(DNWebDriverExceptionClass)
  ['{A4888CB1-A8C4-5002-967E-6A409F8C33E6}']
  { constructors } 

    {class} function init: DNDriverServiceNotFoundException; overload;
    {class} function init(message: string): DNDriverServiceNotFoundException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNDriverServiceNotFoundException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.DriverServiceNotFoundException')]
  DNDriverServiceNotFoundException = interface(DNWebDriverException)
  ['{F84EFF38-69DC-31A3-8DF0-43C9A55BBD2F}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNDriverServiceNotFoundException = class(TDNGenericImport<DNDriverServiceNotFoundExceptionClass, DNDriverServiceNotFoundException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNInvalidCookieDomainExceptionClass = interface(DNWebDriverExceptionClass)
  ['{86EBC4AA-F6D4-5F1B-8F0C-9F0B4673CA0B}']
  { constructors } 

    {class} function init: DNInvalidCookieDomainException; overload;
    {class} function init(message: string): DNInvalidCookieDomainException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNInvalidCookieDomainException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.InvalidCookieDomainException')]
  DNInvalidCookieDomainException = interface(DNWebDriverException)
  ['{3F46C83E-70B1-3D65-99B4-4D48BB27898B}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNInvalidCookieDomainException = class(TDNGenericImport<DNInvalidCookieDomainExceptionClass, DNInvalidCookieDomainException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNInvalidElementStateExceptionClass = interface(DNWebDriverExceptionClass)
  ['{E2CB50C8-02B4-5BF6-890E-22EB425E9946}']
  { constructors } 

    {class} function init: DNInvalidElementStateException; overload;
    {class} function init(message: string): DNInvalidElementStateException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNInvalidElementStateException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.InvalidElementStateException')]
  DNInvalidElementStateException = interface(DNWebDriverException)
  ['{3D913644-C0CD-31D6-B994-D228291B82CE}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNInvalidElementStateException = class(TDNGenericImport<DNInvalidElementStateExceptionClass, DNInvalidElementStateException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNElementNotInteractableExceptionClass = interface(DNInvalidElementStateExceptionClass)
  ['{A3265C1F-EF78-5C20-B488-4FA46B92D481}']
  { constructors } 

    {class} function init: DNElementNotInteractableException; overload;
    {class} function init(message: string): DNElementNotInteractableException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNElementNotInteractableException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.ElementNotInteractableException')]
  DNElementNotInteractableException = interface(DNInvalidElementStateException)
  ['{5A5F1CA3-F06D-3FCB-BCB5-C36AAEC732F6}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNElementNotInteractableException = class(TDNGenericImport<DNElementNotInteractableExceptionClass, DNElementNotInteractableException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNElementClickInterceptedExceptionClass = interface(DNElementNotInteractableExceptionClass)
  ['{F4B7DD81-44CD-5CA4-8128-7786AC198CF5}']
  { constructors } 

    {class} function init: DNElementClickInterceptedException; overload;
    {class} function init(message: string): DNElementClickInterceptedException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNElementClickInterceptedException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.ElementClickInterceptedException')]
  DNElementClickInterceptedException = interface(DNElementNotInteractableException)
  ['{A5F6F0D4-D212-360E-9DF0-975C92B35908}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNElementClickInterceptedException = class(TDNGenericImport<DNElementClickInterceptedExceptionClass, DNElementClickInterceptedException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNElementNotVisibleExceptionClass = interface(DNElementNotInteractableExceptionClass)
  ['{2ED83E39-5DCD-5328-9D70-76C6D4BD389A}']
  { constructors } 

    {class} function init: DNElementNotVisibleException; overload;
    {class} function init(message: string): DNElementNotVisibleException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNElementNotVisibleException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.ElementNotVisibleException')]
  DNElementNotVisibleException = interface(DNElementNotInteractableException)
  ['{3F4DC5E7-A744-3D6A-98D9-D5CE7DC7C7F1}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNElementNotVisibleException = class(TDNGenericImport<DNElementNotVisibleExceptionClass, DNElementNotVisibleException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNElementNotSelectableExceptionClass = interface(DNInvalidElementStateExceptionClass)
  ['{AE4CAA86-B33E-5816-9086-3353297107A9}']
  { constructors } 

    {class} function init: DNElementNotSelectableException; overload;
    {class} function init(message: string): DNElementNotSelectableException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNElementNotSelectableException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.ElementNotSelectableException')]
  DNElementNotSelectableException = interface(DNInvalidElementStateException)
  ['{A90E9D95-70E5-3BDB-A733-2D48C4086BDD}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNElementNotSelectableException = class(TDNGenericImport<DNElementNotSelectableExceptionClass, DNElementNotSelectableException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNNotFoundExceptionClass = interface(DNWebDriverExceptionClass)
  ['{B89A1266-3FF1-5DB1-8EE5-547DC2B543FD}']
  { constructors } 

    {class} function init: DNNotFoundException; overload;
    {class} function init(message: string): DNNotFoundException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNNotFoundException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.NotFoundException')]
  DNNotFoundException = interface(DNWebDriverException)
  ['{F9EC1EC5-BEC9-36A1-B23F-A1C2D9FA1F7F}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNNotFoundException = class(TDNGenericImport<DNNotFoundExceptionClass, DNNotFoundException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNNoAlertPresentExceptionClass = interface(DNNotFoundExceptionClass)
  ['{55949842-EB2C-50A3-8643-7A817D21A246}']
  { constructors } 

    {class} function init: DNNoAlertPresentException; overload;
    {class} function init(message: string): DNNoAlertPresentException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNNoAlertPresentException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.NoAlertPresentException')]
  DNNoAlertPresentException = interface(DNNotFoundException)
  ['{0A5606F7-01E6-3DF4-86A8-06EBDE6D13A0}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNNoAlertPresentException = class(TDNGenericImport<DNNoAlertPresentExceptionClass, DNNoAlertPresentException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNNoSuchElementExceptionClass = interface(DNNotFoundExceptionClass)
  ['{5A8FDCD8-FCF8-5FCA-BBEC-A68D8D11AF89}']
  { constructors } 

    {class} function init: DNNoSuchElementException; overload;
    {class} function init(message: string): DNNoSuchElementException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNNoSuchElementException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.NoSuchElementException')]
  DNNoSuchElementException = interface(DNNotFoundException)
  ['{A49103C9-60E6-31EC-B844-A2FEE7C5FB88}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNNoSuchElementException = class(TDNGenericImport<DNNoSuchElementExceptionClass, DNNoSuchElementException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNInvalidSelectorExceptionClass = interface(DNNoSuchElementExceptionClass)
  ['{291E680C-6F6A-57E8-B87C-A2A4F740EA21}']
  { constructors } 

    {class} function init: DNInvalidSelectorException; overload;
    {class} function init(message: string): DNInvalidSelectorException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNInvalidSelectorException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.InvalidSelectorException')]
  DNInvalidSelectorException = interface(DNNoSuchElementException)
  ['{D58C4102-04B2-3139-A529-6D434D38276B}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNInvalidSelectorException = class(TDNGenericImport<DNInvalidSelectorExceptionClass, DNInvalidSelectorException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNNoSuchFrameExceptionClass = interface(DNNotFoundExceptionClass)
  ['{92EB3EA3-C380-5A40-A4AD-06057DAB1EA4}']
  { constructors } 

    {class} function init: DNNoSuchFrameException; overload;
    {class} function init(message: string): DNNoSuchFrameException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNNoSuchFrameException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.NoSuchFrameException')]
  DNNoSuchFrameException = interface(DNNotFoundException)
  ['{6EB83D15-3FCC-3AD8-B527-06FEFF4C9347}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNNoSuchFrameException = class(TDNGenericImport<DNNoSuchFrameExceptionClass, DNNoSuchFrameException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNNoSuchWindowExceptionClass = interface(DNNotFoundExceptionClass)
  ['{6DA0A5C9-24BA-56FD-9B07-074419ABD719}']
  { constructors } 

    {class} function init: DNNoSuchWindowException; overload;
    {class} function init(message: string): DNNoSuchWindowException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNNoSuchWindowException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.NoSuchWindowException')]
  DNNoSuchWindowException = interface(DNNotFoundException)
  ['{19DED2AE-D6EC-370C-8B25-6FA70141E6BB}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNNoSuchWindowException = class(TDNGenericImport<DNNoSuchWindowExceptionClass, DNNoSuchWindowException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNStaleElementReferenceExceptionClass = interface(DNWebDriverExceptionClass)
  ['{3300FE7E-8DC2-571E-AC30-BC87EB96E8F8}']
  { constructors } 

    {class} function init: DNStaleElementReferenceException; overload;
    {class} function init(message: string): DNStaleElementReferenceException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNStaleElementReferenceException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.StaleElementReferenceException')]
  DNStaleElementReferenceException = interface(DNWebDriverException)
  ['{42601732-F701-3607-8EDB-1D043A11A6DB}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNStaleElementReferenceException = class(TDNGenericImport<DNStaleElementReferenceExceptionClass, DNStaleElementReferenceException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNUnableToSetCookieExceptionClass = interface(DNWebDriverExceptionClass)
  ['{E535088D-621F-5F6A-96D1-85D47635CBF0}']
  { constructors } 

    {class} function init: DNUnableToSetCookieException; overload;
    {class} function init(message: string): DNUnableToSetCookieException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNUnableToSetCookieException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.UnableToSetCookieException')]
  DNUnableToSetCookieException = interface(DNWebDriverException)
  ['{C881DCEF-BE4F-3211-B56C-1CC1DF479180}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNUnableToSetCookieException = class(TDNGenericImport<DNUnableToSetCookieExceptionClass, DNUnableToSetCookieException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNUnhandledAlertExceptionClass = interface(DNWebDriverExceptionClass)
  ['{E1A87616-30C2-5F0B-9512-31388AEF81A6}']
  { constructors } 

    {class} function init: DNUnhandledAlertException; overload;
    {class} function init(message: string): DNUnhandledAlertException; overload;
    {class} function init(message: string; alertText: string): DNUnhandledAlertException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNUnhandledAlertException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.UnhandledAlertException')]
  DNUnhandledAlertException = interface(DNWebDriverException)
  ['{9F95FFCE-87EA-3803-B155-0A9D01CA8E5D}']
  { getters & setters } 

    function get_AlertText: string;
    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property AlertText: string read get_AlertText;
    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNUnhandledAlertException = class(TDNGenericImport<DNUnhandledAlertExceptionClass, DNUnhandledAlertException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNWebDriverTimeoutExceptionClass = interface(DNWebDriverExceptionClass)
  ['{40114933-13E5-582D-AD5F-33DF3BC3985C}']
  { constructors } 

    {class} function init: DNWebDriverTimeoutException; overload;
    {class} function init(message: string): DNWebDriverTimeoutException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNWebDriverTimeoutException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.WebDriverTimeoutException')]
  DNWebDriverTimeoutException = interface(DNWebDriverException)
  ['{266140C4-D2FC-3D1A-8A80-539A8592097B}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNWebDriverTimeoutException = class(TDNGenericImport<DNWebDriverTimeoutExceptionClass, DNWebDriverTimeoutException>) end;

  //-------------namespace: OpenQA.Selenium----------------
  DNXPathLookupExceptionClass = interface(DNWebDriverExceptionClass)
  ['{FB4F44D5-6C10-554B-BC7A-1675B6AB2A58}']
  { constructors } 

    {class} function init: DNXPathLookupException; overload;
    {class} function init(message: string): DNXPathLookupException; overload;
    {class} function init(message: string; innerException: DDNC.System.Private.CoreLib.DNException): DNXPathLookupException; overload;

  end;

  [DNTypeName('OpenQA.Selenium.XPathLookupException')]
  DNXPathLookupException = interface(DNWebDriverException)
  ['{A6865C9D-A4A8-3E2F-93C4-084360E882E7}']
  { getters & setters } 

    function get_Message: string;
    function get_Data: DDNC.System.Private.CoreLib.DNIDictionary;
    function get_InnerException: DDNC.System.Private.CoreLib.DNException;
    function get_TargetSite: DDNC.System.Private.CoreLib.DNMethodBase;
    function get_StackTrace: string;
    function get_HelpLink: string;
    procedure set_HelpLink(value: string);
    function get_Source: string;
    procedure set_Source(value: string);
    function get_HResult: Int32;

  { methods } 

    function GetBaseException: DDNC.System.Private.CoreLib.DNException;
    function ToString: string;
    procedure GetObjectData(info: DDNC.System.Private.CoreLib.DNSerializationInfo; context: DDNC.System.Private.CoreLib.DNStreamingContext);
    function GetType: DDNC.System.Private.CoreLib.DNType;
    function Equals(obj: DDNC.System.Private.CoreLib.DNObject): Boolean;
    function GetHashCode: Int32;

  { propertys } 

    property Message: string read get_Message;
    property Data: DDNC.System.Private.CoreLib.DNIDictionary read get_Data;
    property InnerException: DDNC.System.Private.CoreLib.DNException read get_InnerException;
    property TargetSite: DDNC.System.Private.CoreLib.DNMethodBase read get_TargetSite;
    property StackTrace: string read get_StackTrace;
    property HelpLink: string read get_HelpLink write set_HelpLink;
    property Source: string read get_Source write set_Source;
    property HResult: Int32 read get_HResult;
  end;

  TDNXPathLookupException = class(TDNGenericImport<DNXPathLookupExceptionClass, DNXPathLookupException>) end;


implementation

end.
