Imports System.Windows.Forms
Imports System.Text

''' <summary>
''' Stellt Eigenschaften und Methoden fr ein NullableValueControl bereit, das ber einen Eingabeeditor (beispielsweise TextBox-basierend) verfgt und 
''' darber eine entsprechende Infrastruktur fr die Formatierung und Validierung der Eingabe zur Verfgung stellt.
''' </summary>
''' <remarks></remarks>
Public Interface INullableValueEditor
    Inherits INullableValueControl

    Property NullValueString As String

    ''' <summary>
    ''' Der ursprngliche Wert der Eingabe.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property OriginalValue() As Object

    ''' <summary>
    ''' Eine Formatierungs-Engine, die die aufbereitung des Wertes fr eine formatierte Darstellung bernimmt, wenn das Eingabefeld den Fokus verlsst.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property FormatterEngine() As INullableValueFormatterEngine

    ''' <summary>
    ''' Bestimmt oder ermittelt eine Formatzeichenfolge, mit der der Wert fr die formatierte Darstellung ber seine Formateirungs-Engine aufbereitet werden kann.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property FormatString As String

    ''' <summary>
    ''' Ermittelt, ob der Editor mehrzeilige Eingaben verarbeiten soll.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function IsMultilineControl() As Boolean

    ''' <summary>
    ''' Validiert die Eingabe und liefert im Bedarfsfall eine entsprechende Ausnahme oder Nothing zurck.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function ValidateContent() As ContainsUIMessageException

    ''' <summary>
    ''' Bestimmt, dass die Validierung auf Formularebene fehlgeschlagen ist, und definiert eine entsprechende Fehlermeldung fr die Anzeige.
    ''' </summary>
    ''' <param name="ErrorMessage"></param>
    ''' <remarks></remarks>
    Sub SetFailedValidation(ByVal ErrorMessage As String)

    ''' <summary>
    ''' Setzt die Validierung auf Formularebene zurck.
    ''' </summary>
    ''' <remarks></remarks>
    Sub ClearFailedValidation()

End Interface

