Imports System.ComponentModel
Imports System.Windows.Forms
Imports System.Text

''' <summary>
''' Definiert Ereignisse, Methoden und Eigenschaften, damit ein NullableValueControl automatisch 
''' ber einen FormToBusinessClassManager mit Werten befllt werden kann.
''' </summary>
''' <remarks></remarks>
Public Interface INullableValueDataBinding
    Inherits INullableValueControl, IIsDirtyChangedAware

    ''' <summary>
    ''' Ereignis, das ausgelst wird, wenn sich der Wert des Steuerelements gendert hat.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Event ValueChanged(ByVal sender As Object, ByVal e As ValueChangedEventArgs)

    ''' <summary>
    ''' Bestimmt oder ermittelt, ob die Maske, die das Steuerelement enthlt, gerade die Steuerelemente mit Daten befllt, oder nicht.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>Das Setzen dieser Eigenschaft sollte nur ber diese Schnittstelle (in der Regel von der Maskensteuerung) vorgenommen werden.</remarks>
    Property IsLoading() As HistoricalBoolean

    ''' <summary>
    ''' Bestimmt den Namen der Eigenschaft oder den Pfad der Eigenschaft, die an die Datenquelle mit ihrer Value-Eigenschaft gebunden wird.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>Bei der Angabe der Eigenschaften sollten Steuerelemente auch den Pfad zu einer Eigenschaft auswerten knnen, der mit Punkten angegeben werden kann. 
    ''' Also knnte beispielsweise mit dem DatafieldName "Contact.FirstName" auf eine Eigenschaft namens <i>Contact</i> zugegriffen werden, die eine Instanz vom Typ 
    ''' <i>Contact</i> zurckliefert, die ihrerseits ber <i>eine Firstname</i>-Eigenschaft verfgt, die erst die eigentlich zu bindende Eigenschaft darstellt.</remarks>
    Property DatafieldName() As String

    ''' <summary>
    ''' Bestimmt oder ermittelt die Beschreibung der Eigenschaft, die an die Value-Eigenschaft gebunden werden soll, um beispielsweise in Hilfe-Texten verarbeitet werden zu knnen.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property DatafieldDescription As String
End Interface
