﻿//---------------------------------------------------------------------------------
// Copyright (c) November 2020, devMobile Software
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//---------------------------------------------------------------------------------
namespace devMobile.TheThingsNetwork.Models
{
   using System.Collections.Generic;
   using System.Runtime.Serialization;

   using Newtonsoft.Json;
   using Newtonsoft.Json.Converters;
   using Newtonsoft.Json.Linq;

   public enum DownlinkPriority
   {
      Undefined = 0,
      [EnumMember(Value = "LOWEST")]
      Lowest,
      [EnumMember(Value = "LOW")]
      Low,
      [EnumMember(Value = "BELOW_NORMAL")]
      BelowNormal,
      [EnumMember(Value = "NORMAL")]
      Normal,
      [EnumMember(Value = "ABOVE_NORMAL")]
      AboveNormal,
      [EnumMember(Value = "HIGH")]
      High,
      [EnumMember(Value = "HIGHEST")]
      Highest,
   }

   /*
    * 
    https://github.com/TheThingsNetwork/lorawan-stack/tree/v3.11/pkg/messageprocessors/cayennelpp

   lorawan-stack/pkg/messageprocessors/cayennelpp/keys.go /


type ApplicationDownlink struct {
	// Join Server issued identifier for the session keys used by this downlink.
	SessionKeyID []byte `protobuf:"bytes,1,opt,name=session_key_id,json=sessionKeyId,proto3" json:"session_key_id,omitempty"`
	FPort        uint32 `protobuf:"varint,2,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	FCnt         uint32 `protobuf:"varint,3,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	// The frame payload of the downlink message.
	// The payload is encrypted if the skip_payload_crypto field of the EndDevice
	// is true.
	FRMPayload []byte `protobuf:"bytes,4,opt,name=frm_payload,json=frmPayload,proto3" json:"frm_payload,omitempty"`
	// The decoded frame payload of the downlink message.
	// When scheduling downlink with a message processor configured for the end device (see formatters) or application (see default_formatters),
	// this fields acts as input for the downlink encoder, and the output is set to frm_payload.
	// When reading downlink (listing the queue, downlink message events, etc), this fields acts as output of the downlink decoder, and the input is frm_payload.
	DecodedPayload *types.Struct `protobuf:"bytes,5,opt,name=decoded_payload,json=decodedPayload,proto3" json:"decoded_payload,omitempty"`
	// Warnings generated by the message processor while encoding frm_payload (scheduling downlink) or decoding the frm_payload (reading downlink).
	DecodedPayloadWarnings []string `protobuf:"bytes,10,rep,name=decoded_payload_warnings,json=decodedPayloadWarnings,proto3" json:"decoded_payload_warnings,omitempty"`
	Confirmed              bool     `protobuf:"varint,6,opt,name=confirmed,proto3" json:"confirmed,omitempty"`
	// Optional gateway and timing information for class B and C.
	// If set, this downlink message will only be transmitted as class B or C downlink.
	// If not set, this downlink message may be transmitted in class A, B and C.
	ClassBC *ApplicationDownlink_ClassBC `protobuf:"bytes,7,opt,name=class_b_c,json=classBC,proto3" json:"class_b_c,omitempty"`
	// Priority for scheduling the downlink message.
	Priority             TxSchedulePriority `protobuf:"varint,8,opt,name=priority,proto3,enum=ttn.lorawan.v3.TxSchedulePriority" json:"priority,omitempty"`
	CorrelationIDs       []string           `protobuf:"bytes,9,rep,name=correlation_ids,json=correlationIds,proto3" json:"correlation_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}   */

   public class Downlink
   {
      [JsonProperty("f_port")]
      public int Port { get; set; }

      //[JsonProperty("f_cnt")]
      //public int FrameCount { get; set; }

      [JsonProperty("frm_payload",NullValueHandling = NullValueHandling.Ignore)]
      public string PayloadRaw { get; set; }

      [JsonProperty("decoded_payload")]
      public JToken PayloadDecoded { get; set; }

      [JsonProperty("confirmed")]
      public bool Confirmed { get; set; }

      [JsonProperty("priority")]
      [JsonConverter(typeof(StringEnumConverter))]
      public DownlinkPriority Priority { get; set; }

      [JsonProperty("correlation_ids")]
      public List<string> CorrelationIds { get; set; }
   }

   public class DownlinkPayload
   {
      [JsonProperty("downlinks")]
      public List<Downlink> Downlinks{ get; set; }
   }
}


