﻿//---------------------------------------------------------------------------------
// Copyright (c) May 2022, devMobile Software
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//---------------------------------------------------------------------------------
namespace devMobile.IoT.SX127xLoRaDevice
{
	using System;

	// RegModemConfig3 bit flags from Semtech SX127X Datasheet
	[Flags]
	public enum RegModemConfig3LowDataRateOptimise : byte
	{
		Disabled = 0b00000000,
		Default = Disabled,
		Enabled = 0b00001000
	}

	[Flags]
	public enum RegModemConfig3AgcAutoOn : byte
	{
		LnaGain = 0b00000000,
		Default = LnaGain,
		AgcLoop = 0b00000100
	}
}