/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;

final class ObjectReaderImplClass
extends ObjectReaderBaseModule.PrimitiveImpl {
    static final ObjectReaderImplClass INSTANCE = new ObjectReaderImplClass();
    static final long TYPE_HASH = Fnv.hashCode64("java.lang.Class");

    ObjectReaderImplClass() {
    }

    @Override
    public Class getObjectClass() {
        return Class.class;
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, long features) {
        long valueHashCode;
        if (jsonReader.nextIfMatch((byte)-110) && (valueHashCode = jsonReader.readTypeHashCode()) != TYPE_HASH) {
            throw new JSONException(jsonReader.info("not support autoType : " + jsonReader.getString()));
        }
        return this.readObject(jsonReader, features);
    }

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        String className = jsonReader.readString();
        JSONReader.Context context = jsonReader.getContext();
        if (!context.isEnabled(JSONReader.Feature.SupportClassForName)) {
            throw new JSONException(jsonReader.info("not support ClassForName : " + className + ", you can config 'JSONReader.Feature.SupportClassForName'"));
        }
        Class mappingClass = TypeUtils.getMapping(className);
        if (mappingClass != null) {
            return mappingClass;
        }
        ObjectReaderProvider provider = context.getProvider();
        Class<?> resolvedClass = provider.checkAutoType(className, null, JSONReader.Feature.SupportAutoType.mask);
        if (resolvedClass == null) {
            throw new JSONException(jsonReader.info("class not found " + className));
        }
        return resolvedClass;
    }
}

