# 20230723-ChatGPT 最新注册教程

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/20230723-ChatGPT-ZC-00.png)

## 0 引言

大家好，我是 Kevin。

由于 ChatGPT 强大的能力和持续的热度，不仅成为我们技术圈炙手可热的话题，更是火出圈导致很多人蹭流量。我是从去年 12 月份开始使用 ChatGPT 的较早用户之一，深知它对我的帮助之大，因此想向更多人推荐学习使用。之前我曾写过一篇注册教程发在公众号，不过莫名奇怪被删了。

现在监管确实越来越严，中国的限制就不说了，国外也采取了一些措施。相信很多人都接收了 4 月 1 号开始广泛流传的“亚洲区封号”和“停止注册”的消息吧，在我看来，官方有一定程度的“频控”，但并没有一杆子打死，毕竟 OpenAI 这家公司是要盈利的，他难道会堵住自己的财路吗？传播这种言论的大多是不知情的自媒体或者无良的商家。**我们应该拥有独立思考和判断能力，获取真实的信息，避免成为韭菜！**

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-01.png)

估计很多人是看到上面这张图误认为“停止注册”吧，这其实只是不知道情况下操作的错误。现在注册 OpenAI 账号确实有门槛也更难，但是只要用科学的方法和正确的操作是一定能成功的。**本人在 2023 年 7 月 22 日亲自实践注册成功，下面我将用图文一步一步详细说明步骤，趁着现在还能注册，看完赶紧行动起来吧！相信你花耐心和时间一定能成功！**

> 如果你觉得这篇文章不错的话，请收藏或者转发，能帮助到更多的人我也很开心。
>
> 防止不知道哪天这篇文章又被删除，我已将内容备份到 [GitHub](https://github.com/Kevin-free/chatgpt-prompt-engineering-for-developers) 和[个人博客](https://ifree.love/chatgpt-signup/)。

[TOC]

## 1 准备工作

中国手工注册 ChatGPT 前提条件：

1. 网络代理：必需！由于众所周知的原因，中国用户需要魔 🪄 法上网，至于如何操作不便在此说明，请私聊我或者网上搜索。现在对网络的要求较高，避免使用低价人多的机场，我是使用自建机场成功的。建议全局代理到日本、美国等[支持地区](https://platform.openai.com/docs/supported-countries)。⚠️ 提示：香港是【不】行的！
2. 邮箱：必需！建议使用国外邮箱，如 Gmail，Gmail 注册不了的话可以使用 [Proton](mail.proton.me) 邮箱，另外企业邮箱也可以。⚠️ 提示：Outlook 邮箱现在是【不】行的！就会提示错误“Signup is currently unavailable, please try again later.”
3. 国外手机号：必需！用于接收验证码，有实体卡的话更好，没有的话可以使用接码平台，比如 [sms-activate](sms-activate.org/?ref=3003420)，不过这个平台已经被用烂了，可能需要换很多个号码才能收到验证码，或者换其他的小众平台（至于是哪个我就不公开了，不然又得被用烂了）。⚠️ 提示：Google Voice 虚拟号是【不】行的！
4. 浏览器：建议使用 Chrome 浏览器，清除 openai 的缓存并开启无痕窗口。
5. 耐心：作者第一次是在 2022 年 12 月 14 日注册的，当时非常容易就注册好了。第二次是在 2023 年 5 月 16 日注册的，在网络和手机号上花了不少时间。估计以后会越来越难注册，如果你想学习实践建议尽快亲自注册 ChatGPT。手工注册不会像机器注册那样容易被封号，我手工注册的号至今依然稳定使用。

中国手工注册 ChatGPT 所需成本：

1. 时间：阅读教程（10min）+ OpenAI 注册操作（5min）+ 手机号注册&验证码（10min）+ buffer = 25 - 30 min。
2. 金钱：国外接码平台充值 2 美元&手续费 = 15 人民币。

> 不得不说，现在手工注册 OpenAI 账号确实有一定门槛。如果你觉得麻烦可以联系我帮你手工注册，以及升级 ChatGPT Plus 也可以找我，当然需要收取一些手工费。另外你不担心被封号的风险的话，可以直接购买账号，不过需要辨别靠谱度。我认识靠谱的朋友有账号渠道（那种封号给你退款的），如果你需要的话，也可以联系我 VX：kevintao1024（💡 请备注：来意-昵称-获取渠道，如：手工注册-Kevin-个人博客，无备注不通过望理解）。

## 2 注册流程

> 首先使用魔 🪄 法，开启全局代理到日本、美国等[支持地区](https://platform.openai.com/docs/supported-countries)。
> 网络起着决定性的作用，很多问题可能都是网络导致的！
> 可以访问 [ipaddress](https://www.ipaddress.my/?lang=zh_CN) 查看你当前使用的网络 IP。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-03.png)

### 2.1 注册国外邮箱

OpenAI 风控又升级了，现在注册使用国内邮箱和 Outlook 邮箱，就会出现误以为“停止注册”的信息：

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-01.png)

现在可以使用 Gmail 注册，如果你没有的话可以使用以下方案。

> 如果你有企业邮箱也是可以的，或者你有域名注册企业邮箱也很简单。可以在[网易企业邮箱](https://qy.163.com/)注册。亲测是能够注册 OpenAI 账号的，⚠️ 温馨提示：网易企业邮箱将 OpenAI 的邮件放到垃圾邮件中了，当时我还以为不可以呢。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-04.png)

企业邮箱有一定要求，那我用人人都可行的方案来介绍。分享一个可以免费使用的平台 [proton](https://proton.me/)，按照下图操作注册一个新邮箱。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-05.png)

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-06.png)

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-07.png)

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-08.png)

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-09.png)

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-10.png)

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-11.png)

### 2.2 注册接码平台

如果你有实体卡可以跳过这步。

在第三方接码平台注册并购买号码用于接收验证码，这里还是以 [sms-activate](https://sms-activate.org/?ref=3003420) 为例说明，虽然太多人用导致号码被用烂了，可能需要换很多个号码才能收到验证码，不过性价比和可靠性还是可以的。当然也可以使用其他小众接码平台，这里不公开介绍了，避免又被用烂了。可以关注个人公众号「Kevin 的学堂」回复“接码平台”获取，或者添加个人 VX：kevintao1024（💡 请备注：来意-昵称-获取渠道，如：手工注册-Kevin-个人博客，无备注不通过望理解）。

1. 注册接码平台账号

打开 [sms-activate](https://sms-activate.org/?ref=3003420)，点击右上角的注册，输入邮箱和密码。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-12.png)

然后平台会发一封验证用电子邮件到你的邮箱，“电子邮件已发送到您的电子邮件。请点击信中的链接。也许在垃圾邮件文件夹中”

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/20230518-12-2.png)

点击邮件中的确认地址，或复制该地址到浏览器打开即可，验证通过后就可以在平台购买付费号码了，但在购买前需要先充值，购买号码时再进行扣除。

1. 账号充值

点击右上角的余额下面充值

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-13.png)

将页面拉到下面，找到支付宝，点击支付宝进行充值。很方便。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-14.png)

> 注意 ⚠️ 由于 OpenAI 注册需求太多了，接码平台对充值费用也做了调整，目前的充值使用支付宝最低金额 2 美元，官方原文是：“Commission 0.03$ + 3% The minimum payment amount is 2 USD”，即最低充值 2 美元，充值 10 美元以下，服务费是每笔$0.03 再加上充值金额的 3%。例如充值 9 美元，服务费是 0.03+0.27，一共付款 9.3 美元才对（但后台显示 9.31 美元）。充值超过 10 美元，免服务费。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-15.png)

> 我在 2022 年 12 月 14 号充值时最低 0.2 美元即可，手续费也低，真是早就是优势啊。平台规则经常变动，看你操作时如何。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-15-2.png)

点击支付会弹出支付宝付款码，扫码支付即可。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-16.png)

3. 购买手机号

在 sms-activate 网站左侧搜索栏输入 openai，在 OpenAI 服务列表中选择一个国家，点击右边的购物车即可购买。可以选便宜有货的，比如印度尼西亚性价比和数量都行，一个不行多试几个，实在不行买个贵的 😂

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-18.png)

点击购买后就可以看到这个界面，这个界面包含了接码手机号，还有未来接到短信之后会出现的区域，以及一个可以取消购买的按钮。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/20230518-19.png)

**注意 ⚠️ 号码有效期是 20 分钟，验证码有效期是 5 分钟。如果在 OpenAI 填了号码，却提示号码不可用或等了 3 分钟都没有收到验证码，可以返回 sms-activate 页面，取消刚刚购买的号码，重新再换个号接码就好。在没有收到验证码之前，都是不收费的，可以重复取消再购买。**

### 2.3 注册 OpenAI 账号

1. 填写邮箱密码

前面的铺垫工作做好了，接下来开始注册 OpenAI 账号，首先打开 https://platform.openai.com/signup ，点击注册。填写邮箱、密码。注意 ⚠️ 邮箱建议使用国外邮箱，国内邮箱和 Outlook 邮箱无法注册。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-20.png)

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-22.png)

2. 验证邮箱

进入邮箱收取注册邮件，点击链接，这里强调一定要全程开启代理服务器，否则你使用国内 IP 可能就会遇到所在国家/地区不可用的错误信息：“Not available OpenAI’s services are not available in your country.”。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-23-2.png)

然后在打开的页面中输入名、姓、出生日期（超过 18 岁即可）。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-24.png)

3. 验证手机号码

然后下一个页面就要验证手机号码了，输入你在接码平台买的号码，注意 ⚠️ 复制号码的话记得把前面的国家代码删掉。然后点击发送验证码。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/20230518-25.png)

在接码平台等待验证码并复制到确认区。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-26.png)

**注意 ⚠️ 号码有效期是 20 分钟，验证码有效期是 5 分钟。如果在 OpenAI 填了号码，却提示号码不可用或等了 3 分钟都没有收到验证码，可以返回 sms-activate 页面，取消刚刚购买的号码，重新再换个号接码就好。在没有收到验证码之前，都是不收费的，可以重复取消再购买。**

🎉 恭喜你，验证成功就成功注册了 ChatGPT 账号，并自动跳转到 OpenAI 后台。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-27.png)

可以看到账号有 5 美元的免费额度，如果是开发人员可以使用 API 进行开发。当然也可以直接访问 ChatGPT 官网界面是不消耗 API 的。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-28.png)

> 这里提醒下免费额度是有有效期的，我去年 12 月注册的号，送的 18 美金没用上就过期了，血亏 🤣

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-28-2.png)

可以点击右边的菜单栏或者直接访问 chat.openai.com/chat 使用 ChatGPT。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-29.png)

简单测试一下 ChatGPT。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-30.png)

> 这篇文章主要介绍 ChatGPT 的注册，就不多介绍 ChatGPT 的使用了，大家感兴趣的话可以关注个人公众号「Kevin 的学堂」，相关内容首发在公众号。防止被删我把内容备份到个人 [GitHub](https://github.com/Kevin-free/chatgpt-prompt-engineering-for-developers) 仓库了，欢迎 Follow & Star~
> 💡 对了，我正在学习使用 ChatGPT 开发 AI 应用，如果你也感兴趣欢迎加我 VX：kevintao1024，也可以加入我免费创建的 ChatGPT&AI 交流群，一起交流学习。

另外，想给你推荐下我和大佬创建的 「**ChatGPT & AI 破局俱乐部**」，你可以点击[AI 破局俱乐部社群资料](https://d16rg8unadx.feishu.cn/docx/QQN8dPfruo2zlbxuxn6c2H8JnJg)查看详情。**三天内无理由全额退款**！可能有人抱有质疑态度，认为这是割韭菜，也可能有人一看到知识星球四个字就很反感，**但真实情况怎么样只有你亲自体验了才知道！如果你也对 AI 感兴趣想抓住机会，必须躬身入局行动起来！如何在瞬息万变的 AI 风口中行动呢？一个人可能走得更快，一群人才能走得更远！**

起初我也质疑过，但是看到越来越多的大佬加入和高质量内容，就不在顾虑了。你可以点击[火出圈的 ChatGPT！AI 时代如何破局？](https://ifree.love/ad-findyi/)了解详情，或者先进来看看，**把知识学到也是血赚！三天内无理由全额退款！**

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-coupon.png)

## 3 常用网站

OpenAI 登录：https://platform.openai.com/signup

ChatGPT 对话：https://chat.openai.com/chat

查看 API 剩余额度：https://platform.openai.com/account/usage

新建 API KEY：https://platform.openai.com/account/api-keys

## 4 常见问题

### 4.1 ChatGPT 是什么？有中文版和 APP 吗？

ChatGPT 是由 OpenAI 开发的一个人工智能聊天机器人程序，于 2022 年 11 月推出。它能用中、英文回答你的各种问题，还能帮你翻译、算数学、甚至写代码检查日志。

ChatGPT 注册阶段和后台使用上都是没有中文的，但是你跟 ChatGPT 沟通时是可以使用中文的，它可以理解中文，也能用中文回答你，如果它没有用中文回答你，你可以对它说，请用中文回答我即可。

请注意，~~OpenAI 官方并没有提供 ChatGPT APP~~，OpenAI 官方在 2023 年 5 月 19 日上线了 iOS ChatGPT 应用程序，OpenAI 官方在 2023 年 7 月 22 日宣布上线 Android ChatGPT 应用程序。你在任意平台看到的其他的所谓的 ChatGPT 官方版都是假的，都是第三方封装的（但是打着官方名义就很低俗啦），注意辨别。如果你实在要用手机使用 ChatGPT，可以使用浏览器前往 ChatGPT 网页版撩拨，或者自己部署一些好玩的应用。

### 4.2 正版 ChatGPT 与 国内盗版 ChatGPT（API）的区别？

现在所有使用 OpenAI API KEY 的项目，都不是基于 ChatGPT 开发的项目，官方并未发布 ChatGPT 的 API 接口。如果你自己有分别使用过 ChatGPT 的官方 chat 和 OpenAI 的 API 接口 chat，**你会发现 API 接口 chat 比 ChatGPT 的官方 chat“笨”得多**。

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/20230723-ChatGPT-ZC-4-2.png)

### 4.3 ChatGPT 要钱吗？

目前不用，注册完成之后，有 5 美元的赠金，这部分赠金是用来支付 GPT-3 API 的调用，你使用网页版 ChatGPT 是不用支付费用的。

### 4.4 ChatGPT 和 ChatGPT Plus 区别？Plus 值得开吗？

ChatGPT 和 ChatGPT Plus 是 OpenAI 提供的两种服务计划。它们之间的区别主要在于以下几个方面：

1. 价格：ChatGPT 是免费的，而 ChatGPT Plus 是一个付费计划，每月订阅费用为 20 美元。

2. 访问优先权：订阅 ChatGPT Plus 的用户可以享有访问优先权。这意味着当访问量较大时，他们可以在免费用户之前进入系统，从而减少等待时间。

3. 增强功能：ChatGPT Plus 用户还可以获得一些额外的增强功能和优先支持。比如 Plus 用户已经可以使用联网、插件功能。

至于是否值得订阅 ChatGPT Plus，这取决于您对服务的需求和预算。如果您对系统响应时间较为敏感，或者希望享受额外的增强功能和优先支持，那么 ChatGPT Plus 可能对您有吸引力。如果您对等待时间没有太大的关注，并且不需要额外的功能或支持，那么免费版的 ChatGPT 也可以满足您的需求。

至于如何升级 ChatGPT Plus 可以查看这篇[教程](https://chatgpt-plus.github.io/chatgpt-plus/)，说实话门槛有点高，时间和金钱成本都不小，有需要的话可以私聊 VX:kevintao1024。
 
## 5 常见报错

### 5.1 访问时报错：Not available in your country

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-err-05.png)

报错原因：

国家不支持。网络 IP 不能在中国，香港也是不行的。

解决方案：

将网络 IP 代理到[支持国家](https://platform.openai.com/docs/supported-countries)，建议代理到新加坡、日本、美国等地。

### 5.2 访问时报错：Sorry, you have been blocked

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-err-04.png)

报错原因：

1. 网络原因。
2. 浏览器原因。

解决方案：

1. 更换代理网络。低价人多的机场容易触发此报错。
2. 清除 OpenAI 的 cookies 和缓存。
3. 使用无痕模式或者换一个浏览器。

### 5.3 注册时报错：Signup is currently unavailable, please try again later

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-err-01.png)

报错原因：

邮箱原因。OpenAI 风控设升级了，现在使用国内邮箱、Outlook 邮箱注册就会报这个错误。

解决方案：

更换邮箱。建议使用国外邮箱，如 Gmail，Gmail 注册不了的话可以使用 [Proton](mail.proton.me) 邮箱，另外企业邮箱也可以。

### 5.4 发送验证码时报错：Your account was flagged for potential abuse

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-err-02.png)

报错原因：

1. 网络原因。
2. 号码原因。

解决方案：

1. 更换代理网络。
2. 更换手机号或者接码平台。

### 5.5 登录时报错：We ran into an issue while authenticating you

![](https://img.ifree258.top/13-XXCC/131-JSJ/1311-ai/iloveimg-watermarked/20230518-err-03.png)

报错原因：

1. 网络原因。

解决方案：

1. 更换代理网络。

另外以上问题都可以在 help.openai.com 官网帮助中心查找，实在不行可以发邮件给 support@openai.com 。虽然不一定有帮助。

> 有不少朋友曾问我 ChatGPT 如何注册的问题，于是写了这篇更为详细的文章。策略可能还会变，这篇文章我也会保持更新。如果你有何问题欢迎留言或者联系我~
> 这就是这篇文章的全部内容了，感谢你的耐心查看，希望对你有所帮助。也欢迎你分享这篇文章帮助到更多人！

## 6 链接

1. GitHub：https://github.com/Kevin-free/chatgpt-prompt-engineering-for-developers
2. 个人博客：https://ifree.love/chatgpt-signup/
3. OpenAI 支持地区：https://platform.openai.com/docs/supported-countries
4. proton 邮箱：https://proton.me/
5. sms-activate 接码平台：https://sms-activate.org/?ref=3003420
6. ipaddress：https://www.ipaddress.my/?lang=zh_CN
7. 网易企业邮箱：https://qy.163.com/
8. AI 破局俱乐部社群资料：https://d16rg8unadx.feishu.cn/docx/QQN8dPfruo2zlbxuxn6c2H8JnJg
9. 火出圈的 ChatGPT！AI 时代如何破局？：https://ifree.love/ad-findyi/
10. ChatGPT Plus 升级教程：https://chatgpt-plus.github.io/chatgpt-plus/

## 7 参考

1. Why can't I log in to OpenAI API? https://help.openai.com/en/articles/6613629-why-can-t-i-log-in-to-openai-api
2. 注册 Chatgpt 手机号无法验证出现“Your account was flagged for potential abuse”提示账号被标记滥用的最新解决办法 https://cloud.tencent.com/developer/beta/article/2266372
3. https://www.evlit.com/477.html
4. https://juejin.cn/post/7214512376669175845#heading-8
