/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.JImmutableMap;

public abstract class MutableMapAdaptor<K, V>
extends AbstractMap<K, V> {
    private final Set<Map.Entry<K, V>> entries = new MutableEntrySet();

    protected MutableMapAdaptor() {
    }

    protected abstract JImmutableMap<K, V> accessMap();

    protected abstract void replaceMap(JImmutableMap<K, V> var1);

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entries;
    }

    @Override
    public V put(K key, V value) {
        Object oldValue = this.accessMap().get(key);
        this.replaceMap(this.accessMap().assign(key, value));
        return oldValue;
    }

    private class MutableEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private JImmutableMap<K, V> startingMap;
        private Cursor<JImmutableMap.Entry<K, V>> current;
        private Cursor<JImmutableMap.Entry<K, V>> next;

        private MutableEntryIterator() {
            this.startingMap = MutableMapAdaptor.this.accessMap();
            this.current = this.startingMap.cursor();
            this.next = this.current.next();
        }

        @Override
        public boolean hasNext() {
            if (MutableMapAdaptor.this.accessMap() != this.startingMap) {
                throw new ConcurrentModificationException();
            }
            return this.next.hasValue();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (MutableMapAdaptor.this.accessMap() != this.startingMap) {
                throw new ConcurrentModificationException();
            }
            try {
                this.current = this.next;
                this.next = this.next.next();
                return new MutableMapEntry(this.current.getValue());
            }
            catch (Cursor.NoValueException ignored) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (MutableMapAdaptor.this.accessMap() != this.startingMap) {
                throw new ConcurrentModificationException();
            }
            Object key = this.current.getValue().getKey();
            MutableMapAdaptor.this.replaceMap(MutableMapAdaptor.this.accessMap().delete(key));
            this.startingMap = MutableMapAdaptor.this.accessMap();
        }

        private class MutableMapEntry
        extends AbstractMap.SimpleEntry<K, V> {
            private MutableMapEntry(JImmutableMap.Entry<K, V> entry) {
                super(entry.getKey(), entry.getValue());
            }

            @Override
            public V setValue(V newValue) {
                if (MutableMapAdaptor.this.accessMap() != MutableEntryIterator.this.startingMap) {
                    throw new ConcurrentModificationException();
                }
                MutableMapAdaptor.this.replaceMap(MutableMapAdaptor.this.accessMap().assign(this.getKey(), newValue));
                Object answer = super.setValue(newValue);
                MutableEntryIterator.this.startingMap = MutableMapAdaptor.this.accessMap();
                return answer;
            }
        }
    }

    private class MutableEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private MutableEntrySet() {
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MutableEntryIterator();
        }

        @Override
        public int size() {
            return MutableMapAdaptor.this.accessMap().size();
        }

        @Override
        public boolean add(Map.Entry<K, V> newEntry) {
            MutableMapAdaptor.this.replaceMap(MutableMapAdaptor.this.accessMap().assign(newEntry.getKey(), newEntry.getValue()));
            return true;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            if (MutableMapAdaptor.this.accessMap().findEntry(key).isFilled()) {
                MutableMapAdaptor.this.replaceMap(MutableMapAdaptor.this.accessMap().delete(key));
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            return MutableMapAdaptor.this.accessMap().find(key).isFilled();
        }

        @Override
        public void clear() {
            MutableMapAdaptor.this.replaceMap(MutableMapAdaptor.this.accessMap().deleteAll());
        }
    }
}

