/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Cursorable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableStack;
import org.javimmutable.collections.list.JImmutableLinkedStack;

public final class Functions {
    private Functions() {
    }

    public static <T, R> R foldLeft(R accumulator, Cursor<? extends T> cursor, Func2<R, ? super T, R> func) {
        cursor = cursor.start();
        while (cursor.hasValue()) {
            accumulator = func.apply(accumulator, cursor.getValue());
            cursor = cursor.next();
        }
        return accumulator;
    }

    public static <T, R> R foldRight(R accumulator, Cursor<? extends T> cursor, Func2<R, ? super T, R> func) {
        return Functions.foldLeft(accumulator, Functions.reverse(cursor), func);
    }

    public static <T> Cursor<T> reverse(Cursor<? extends T> cursor) {
        return ((JImmutableStack)JImmutableLinkedStack.of().insertAll(cursor)).cursor();
    }

    public static <T, R, A extends Insertable<R, A>> A collectAll(Cursor<? extends T> cursor, A list, Func1<? super T, R> func) {
        cursor = cursor.start();
        while (cursor.hasValue()) {
            list = list.insert(func.apply(cursor.getValue()));
            cursor = cursor.next();
        }
        return list;
    }

    public static <T, R, A extends Insertable<R, A>> A collectSome(Cursor<? extends T> cursor, A list, Func1<? super T, Holder<R>> func) {
        cursor = cursor.start();
        while (cursor.hasValue()) {
            Holder<R> mappedValue = func.apply(cursor.getValue());
            if (mappedValue.isFilled()) {
                list = list.insert(mappedValue.getValue());
            }
            cursor = cursor.next();
        }
        return list;
    }

    public static <T> Holder<T> find(Cursor<? extends T> cursor, Func1<? super T, Boolean> func) {
        cursor = cursor.start();
        while (cursor.hasValue()) {
            if (func.apply(cursor.getValue()).booleanValue()) {
                return Holders.of(cursor.getValue());
            }
            cursor = cursor.next();
        }
        return Holders.of();
    }

    public static <T, A extends Insertable<T, A>> A reject(Cursor<? extends T> cursor, A list, Func1<? super T, Boolean> func) {
        cursor = cursor.start();
        while (cursor.hasValue()) {
            if (!func.apply(cursor.getValue()).booleanValue()) {
                list = list.insert(cursor.getValue());
            }
            cursor = cursor.next();
        }
        return list;
    }

    public static <T, A extends Insertable<T, A>> A select(Cursor<? extends T> cursor, A list, Func1<? super T, Boolean> func) {
        cursor = cursor.start();
        while (cursor.hasValue()) {
            if (func.apply(cursor.getValue()).booleanValue()) {
                list = list.insert(cursor.getValue());
            }
            cursor = cursor.next();
        }
        return list;
    }

    @Deprecated
    public static <T, A extends Insertable<T, A>> A insertAll(A addable, Iterator<? extends T> iterator) {
        return addable.insertAll(iterator);
    }

    @Deprecated
    public static <T, A extends Insertable<T, A>> A insertAll(A addable, Cursor<? extends T> cursor) {
        return addable.insertAll(cursor);
    }

    @Deprecated
    public static <T, A extends Insertable<T, A>> A insertAll(A addable, T[] values) {
        return addable.insertAll(Arrays.asList(values));
    }

    public static <K, V> JImmutableMap<K, V> assignAll(JImmutableMap<K, V> dest, JImmutableMap<K, V> src) {
        for (JImmutableMap.Entry entry : src) {
            dest = dest.assign(entry.getKey(), entry.getValue());
        }
        return dest;
    }

    public static <K, V> JImmutableMap<K, V> assignAll(JImmutableMap<K, V> dest, Map<K, V> src) {
        for (Map.Entry<K, V> entry : src.entrySet()) {
            dest = dest.assign(entry.getKey(), entry.getValue());
        }
        return dest;
    }

    @Deprecated
    public static <T> Iterable<T> each(Cursor<T> cursor) {
        return cursor;
    }

    @Deprecated
    public static <T> Iterable<T> each(Cursorable<T> cursorable) {
        return cursorable.cursor();
    }
}

