/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.tree.Node;

@Immutable
public class UpdateResult<K, V> {
    private static UpdateResult UNCHANGED = new UpdateResult(Type.UNCHANGED, null, null, 0);
    public final Type type;
    public final Node<K, V> newNode;
    public final Node<K, V> extraNode;
    public final int sizeDelta;

    private UpdateResult(Type type, Node<K, V> newNode, Node<K, V> extraNode, int sizeDelta) {
        this.type = type;
        this.newNode = newNode;
        this.extraNode = extraNode;
        this.sizeDelta = sizeDelta;
    }

    @Nonnull
    static <K, V> UpdateResult<K, V> createUnchanged() {
        return UNCHANGED;
    }

    @Nonnull
    static <K, V> UpdateResult<K, V> createInPlace(@Nonnull Node<K, V> newNode, int sizeDelta) {
        return new UpdateResult<K, V>(Type.INPLACE, newNode, null, sizeDelta);
    }

    @Nonnull
    static <K, V> UpdateResult<K, V> createSplit(@Nonnull Node<K, V> newNode, @Nonnull Node<K, V> extraNode, int sizeDelta) {
        return new UpdateResult<K, V>(Type.SPLIT, newNode, extraNode, sizeDelta);
    }

    public String toString() {
        return String.format("<%s,%s,%s,%d>", new Object[]{this.type, this.newNode, this.extraNode, this.sizeDelta});
    }

    public static enum Type {
        UNCHANGED,
        INPLACE,
        SPLIT;

    }
}

