/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Tuple2;
import org.javimmutable.collections.cursors.SingleValueCursor;
import org.javimmutable.collections.iterators.SingleValueIterator;
import org.javimmutable.collections.tree.BranchNode;
import org.javimmutable.collections.tree.EmptyNode;
import org.javimmutable.collections.tree.Node;
import org.javimmutable.collections.tree.UpdateResult;

@Immutable
public class LeafNode<K, V>
implements Node<K, V>,
JImmutableMap.Entry<K, V>,
Holders.Filled<V> {
    private final K key;
    private final V value;

    public LeafNode(@Nonnull K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K baseKey() {
        return this.key;
    }

    @Override
    public int childCount() {
        return 1;
    }

    @Override
    public int valueCount() {
        return 1;
    }

    @Override
    public V getValueOr(@Nonnull Comparator<K> comparator, @Nonnull K key, V defaultValue) {
        return comparator.compare(this.key, key) == 0 ? this.value : defaultValue;
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull Comparator<K> comparator, @Nonnull K key) {
        return comparator.compare(this.key, key) == 0 ? this : Holders.of();
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull Comparator<K> comparator, @Nonnull K key) {
        return comparator.compare(this.key, key) == 0 ? Holders.of(this) : Holders.of();
    }

    @Override
    @Nonnull
    public UpdateResult<K, V> assign(@Nonnull Comparator<K> comparator, @Nonnull K key, V value) {
        LeafNode<K, V> newLeaf = new LeafNode<K, V>(key, value);
        int diff = comparator.compare(this.key, key);
        if (diff == 0) {
            return this.value == value ? UpdateResult.createUnchanged() : UpdateResult.createInPlace(newLeaf, 0);
        }
        return diff < 0 ? UpdateResult.createSplit(this, newLeaf, 1) : UpdateResult.createSplit(newLeaf, this, 1);
    }

    @Override
    @Nonnull
    public UpdateResult<K, V> update(@Nonnull Comparator<K> comparator, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        int diff = comparator.compare(this.key, key);
        if (diff == 0) {
            V value = generator.apply(this);
            LeafNode<K, V> newLeaf = new LeafNode<K, V>(key, value);
            return this.value == value ? UpdateResult.createUnchanged() : UpdateResult.createInPlace(newLeaf, 0);
        }
        LeafNode<K, V> newLeaf = new LeafNode<K, V>(key, generator.apply(Holders.of()));
        return diff < 0 ? UpdateResult.createSplit(this, newLeaf, 1) : UpdateResult.createSplit(newLeaf, this, 1);
    }

    @Override
    @Nonnull
    public Node<K, V> delete(@Nonnull Comparator<K> comparator, @Nonnull K key) {
        int diff = comparator.compare(this.key, key);
        return diff == 0 ? EmptyNode.of() : this;
    }

    @Override
    @Nonnull
    public Node<K, V> mergeChildren(@Nonnull Node<K, V> sibling) {
        return new BranchNode<K, V>(this, sibling);
    }

    @Override
    @Nonnull
    public Tuple2<Node<K, V>, Node<K, V>> distributeChildren(@Nonnull Node<K, V> sibling) {
        return Tuple2.of(this, sibling);
    }

    @Override
    @Nonnull
    public Node<K, V> compress() {
        return this;
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor() {
        return SingleValueCursor.of(this);
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return SingleValueIterator.of(this);
    }

    @Override
    public void checkInvariants(@Nonnull Comparator<K> comparator) {
    }

    @Override
    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return "<" + this.key + "," + this.value + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafNode leafNode = (LeafNode)o;
        return Objects.equals(this.key, leafNode.key) && Objects.equals(this.value, leafNode.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }
}

