/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.common.AbstractJImmutableSet;
import org.javimmutable.collections.serialization.JImmutableTreeSetProxy;
import org.javimmutable.collections.tree.ComparableComparator;
import org.javimmutable.collections.tree.JImmutableTreeMap;

@Immutable
public class JImmutableTreeSet<T>
extends AbstractJImmutableSet<T>
implements Serializable {
    private static final JImmutableTreeSet EMPTY = new JImmutableTreeSet(new ComparableComparator());
    private final Comparator<T> comparator;

    private JImmutableTreeSet(Comparator<T> comparator) {
        this(JImmutableTreeMap.of(comparator), comparator);
    }

    private JImmutableTreeSet(JImmutableMap<T, Boolean> map, Comparator<T> comparator) {
        super(map);
        this.comparator = comparator;
    }

    @Override
    @Nonnull
    public JImmutableTreeSet<T> deleteAll() {
        return JImmutableTreeSet.of(this.comparator);
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public static <T extends Comparable<T>> JImmutableTreeSet<T> of() {
        return EMPTY;
    }

    public static <T> JImmutableTreeSet<T> of(Comparator<T> comparator) {
        return new JImmutableTreeSet<T>(comparator);
    }

    @Override
    protected JImmutableSet<T> create(JImmutableMap<T, Boolean> map) {
        return new JImmutableTreeSet<T>(map, this.comparator);
    }

    @Override
    protected Set<T> emptyMutableSet() {
        return new TreeSet<T>(this.comparator);
    }

    JImmutableMap getMap() {
        return this.map;
    }

    private Object writeReplace() {
        return new JImmutableTreeSetProxy(this);
    }
}

