/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.tree;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Cursor;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.AbstractJImmutableMap;
import org.javimmutable.collections.common.Conditions;
import org.javimmutable.collections.serialization.JImmutableTreeMapProxy;
import org.javimmutable.collections.tree.BranchNode;
import org.javimmutable.collections.tree.ComparableComparator;
import org.javimmutable.collections.tree.EmptyNode;
import org.javimmutable.collections.tree.Node;
import org.javimmutable.collections.tree.UpdateResult;

@Immutable
public class JImmutableTreeMap<K, V>
extends AbstractJImmutableMap<K, V>
implements Serializable {
    private static final Comparator EMPTY_COMPARATOR = ComparableComparator.of();
    private static final JImmutableTreeMap EMPTY = new JImmutableTreeMap(EMPTY_COMPARATOR, EmptyNode.of(), 0);
    private static final long serialVersionUID = -121805L;
    private final Comparator<K> comparator;
    private final Node<K, V> root;
    private final int size;

    private JImmutableTreeMap(@Nonnull Comparator<K> comparator, @Nonnull Node<K, V> root, int size) {
        this.comparator = comparator;
        this.root = root;
        this.size = size;
    }

    @Nonnull
    public static <K extends Comparable<K>, V> JImmutableTreeMap<K, V> of() {
        return EMPTY;
    }

    @Nonnull
    public static <K, V> JImmutableTreeMap<K, V> of(@Nonnull Comparator<K> comparator) {
        return new JImmutableTreeMap(comparator, EmptyNode.of(), 0);
    }

    @Nonnull
    @Deprecated
    public static <K extends Comparable<K>, V> JImmutableTreeMap<K, V> of(Map<K, V> map) {
        JImmutableMap<K, V> answer = JImmutableTreeMap.of();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            answer = answer.assign((Object)entry.getKey(), (Object)entry.getValue());
        }
        return answer;
    }

    @Override
    public V getValueOr(K key, V defaultValue) {
        Conditions.stopNull(key);
        return this.root.getValueOr(this.comparator, key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull K key) {
        Conditions.stopNull(key);
        return this.root.find(this.comparator, key);
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull K key) {
        Conditions.stopNull(key);
        return this.root.findEntry(this.comparator, key);
    }

    @Override
    @Nonnull
    public JImmutableTreeMap<K, V> assign(@Nonnull K key, V value) {
        Conditions.stopNull(key);
        UpdateResult<K, V> result = this.root.assign(this.comparator, key, value);
        return this.resultForAssign(result);
    }

    @Override
    @Nonnull
    public JImmutableTreeMap<K, V> update(@Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        Conditions.stopNull(key);
        UpdateResult<K, V> result = this.root.update(this.comparator, key, generator);
        return this.resultForAssign(result);
    }

    @Override
    @Nonnull
    public JImmutableTreeMap<K, V> delete(@Nonnull K key) {
        Conditions.stopNull(key);
        Node<K, V> newRoot = this.root.delete(this.comparator, key);
        if (newRoot == this.root) {
            return this;
        }
        if (this.size == 1) {
            return this.deleteAll();
        }
        return new JImmutableTreeMap<K, V>(this.comparator, newRoot.compress(), this.size - 1);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @Nonnull
    public JImmutableTreeMap<K, V> deleteAll() {
        return this.comparator == EMPTY_COMPARATOR ? EMPTY : new JImmutableTreeMap(this.comparator, EmptyNode.of(), 0);
    }

    @Override
    @Nonnull
    public Cursor<JImmutableMap.Entry<K, V>> cursor() {
        return this.root.cursor();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return this.root.iterator();
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants(this.comparator);
    }

    @Nonnull
    public Comparator<K> getComparator() {
        return this.comparator;
    }

    @Nonnull
    List<K> getKeysList() {
        LinkedList keys = new LinkedList();
        for (JImmutableMap.Entry entry : this) {
            keys.add(entry.getKey());
        }
        return Collections.unmodifiableList(keys);
    }

    @Nonnull
    private JImmutableTreeMap<K, V> resultForAssign(UpdateResult<K, V> result) {
        switch (result.type) {
            case UNCHANGED: {
                return this;
            }
            case INPLACE: {
                return new JImmutableTreeMap(this.comparator, result.newNode, this.size + result.sizeDelta);
            }
            case SPLIT: {
                return new JImmutableTreeMap(this.comparator, new BranchNode(result.newNode, result.extraNode), this.size + result.sizeDelta);
            }
        }
        throw new IllegalStateException("unknown UpdateResult.Type value");
    }

    private Object writeReplace() {
        return new JImmutableTreeMapProxy(this);
    }
}

